(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[  20120554,     820269]*)
(*NotebookOutlinePosition[  20171932,     821796]*)
(*  CellTagsIndexPosition[  20171264,     821776]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Applied ",
    FontFamily->"Times",
    FontSize->72,
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["Mathematica",
    FontFamily->"Times",
    FontSize->72,
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[":",
    FontFamily->"Times",
    FontSize->72,
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" ",
    FontFamily->"Times",
    FontSize->72,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\nMy favorite tips, tricks, and shortcuts\n",
    FontFamily->"Times",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["Fred Olness\n(SMU)",
    FontFamily->"Times",
    FontSize->24,
    FontColor->RGBColor[0, 1, 0]]
}], "Title",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dynamic\ Rotation\ of\ Space\ Station\ Mir\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52768 .45231 m .61433 .36037 L .64956 .35498 L p .396 .002 .169 r
F P
0 g
s
.53461 .43937 m .51742 .43812 L p .52108 .4625 L .706 .536 .655 r
F P
0 g
s
.52892 .51472 m .5333 .45673 L p .52108 .4625 L .706 .536 .655 r
F P
0 g
s
.64956 .35498 m .57304 .43795 L p .52768 .45231 L .396 .002 .169 r
F P
0 g
s
.54828 .44965 m .52768 .45231 L p .57304 .43795 L .396 .002 .169 r
F P
0 g
s
.5333 .45673 m .53461 .43937 L p .52108 .4625 L .706 .536 .655 r
F P
0 g
s
.57304 .43795 m .56413 .4476 L .54828 .44965 L p .396 .002 .169 r
F P
0 g
s
.52741 .57485 m .58957 .59918 L .59068 .58304 L p .92 .73 .629 r
F P
0 g
s
.59068 .58304 m .52867 .55816 L .52741 .57485 L p .92 .73 .629 r
F P
0 g
s
.52867 .55816 m .59068 .58304 L .59964 .5693 L p .854 .827 .821 r
F P
0 g
s
.5379 .54387 m .59964 .5693 L .61313 .56311 L p .669 .854 .971 r
F P
0 g
s
.59964 .5693 m .5379 .54387 L .52867 .55816 L p .854 .827 .821 r
F P
0 g
s
.53465 .58769 m .59678 .61164 L .58957 .59918 L p .879 .473 .249 r
F P
0 g
s
.58957 .59918 m .52741 .57485 L .53465 .58769 L p .879 .473 .249 r
F P
0 g
s
.61313 .56311 m .55167 .53736 L .5379 .54387 L p .669 .854 .971 r
F P
0 g
s
.55167 .53736 m .61313 .56311 L .62605 .5669 L p 0 .464 .791 r
F P
0 g
s
.54771 .59174 m .60965 .61565 L .59678 .61164 L p 0 .424 .745 r
F P
0 g
s
.59678 .61164 m .53465 .58769 L .54771 .59174 L p 0 .424 .745 r
F P
0 g
s
.62605 .5669 m .56479 .54117 L .55167 .53736 L p 0 .464 .791 r
F P
0 g
s
.56479 .54117 m .62605 .5669 L .63346 .57932 L p .877 .461 .221 r
F P
0 g
s
.56164 .58534 m .62329 .60957 L .60965 .61565 L p .661 .861 .976 r
F P
0 g
s
.60965 .61565 m .54771 .59174 L .56164 .58534 L p .661 .861 .976 r
F P
0 g
s
.63346 .57932 m .57223 .55397 L .56479 .54117 L p .877 .461 .221 r
F P
0 g
s
.57223 .55397 m .63346 .57932 L .63241 .59566 L p .925 .733 .624 r
F P
0 g
s
.57104 .57088 m .63241 .59566 L .62329 .60957 L p .857 .834 .823 r
F P
0 g
s
.02 w
.63132 .59733 m
.6406 .60106 L
s
.5 Mabswid
.62329 .60957 m .56164 .58534 L .57104 .57088 L p .857 .834 .823 r
F P
0 g
s
.63241 .59566 m .57104 .57088 L .57223 .55397 L p .925 .733 .624 r
F P
0 g
s
.61367 .56584 m .6896 .59753 L .72006 .57584 L p .754 .869 .932 r
F P
0 g
s
.41557 .56104 m .41471 .57091 L .49411 .55361 L closepath p .474 .335 .611 r
F P
0 g
s
.41258 .55167 m .41557 .56104 L .49411 .55361 L closepath p .49 .493 .787 r
F P
0 g
s
.41471 .57091 m .41032 .57756 L .49411 .55361 L closepath p .355 .029 .268 r
F P
0 g
s
.40685 .54634 m .41258 .55167 L .49411 .55361 L closepath p .41 .647 .955 r
F P
0 g
s
.69415 .55895 m .79769 .60486 L .83249 .5807 L p .752 .876 .936 r
F P
0 g
s
.41032 .57756 m .40403 .57843 L .49411 .55361 L closepath p .313 .804 .831 r
F P
0 g
s
.40055 .54711 m .40685 .54634 L .49411 .55361 L closepath p .231 0 0 r
F P
0 g
s
.72006 .57584 m .64863 .54442 L p .61367 .56584 L .754 .869 .932 r
F P
0 g
s
.63138 .55289 m .61367 .56584 L p .64863 .54442 L .754 .869 .932 r
F P
0 g
s
.67221 .55967 m .60499 .56584 L p .57516 .58394 L .474 .159 .352 r
F P
0 g
s
.60499 .56584 m .58472 .5677 L .57803 .57907 L p .474 .159 .352 r
F P
0 g
s
.57803 .57907 m .57516 .58394 L p .60499 .56584 L .474 .159 .352 r
F P
0 g
s
.64863 .54442 m .64509 .54287 L .63138 .55289 L p .754 .869 .932 r
F P
0 g
s
.40403 .57843 m .39824 .57315 L .49411 .55361 L closepath p .597 .724 .933 r
F P
0 g
s
.39609 .55373 m .40055 .54711 L .49411 .55361 L closepath p .546 .236 .393 r
F P
0 g
s
.39824 .57315 m .3952 .5637 L .49411 .55361 L closepath p .599 .561 .784 r
F P
0 g
s
.3952 .5637 m .39609 .55373 L .49411 .55361 L closepath p .585 .43 .637 r
F P
0 g
s
.83249 .5807 m .73572 .53509 L p .69415 .55895 L .752 .876 .936 r
F P
0 g
s
.70945 .54794 m .69415 .55895 L p .73572 .53509 L .752 .876 .936 r
F P
0 g
s
.728 .55456 m .68853 .55818 L p .67813 .57497 L .474 .159 .352 r
F P
0 g
s
.68853 .55818 m .68725 .55829 L .68687 .55899 L p .474 .159 .352 r
F P
0 g
s
.68687 .55899 m .67813 .57497 L p .68853 .55818 L .474 .159 .352 r
F P
0 g
s
.73572 .53509 m .73063 .5327 L .70945 .54794 L p .752 .876 .936 r
F P
0 g
s
.5116 .51346 m .51742 .43812 L .50351 .43422 L p .84 .655 .652 r
F P
0 g
s
.51742 .43812 m .5116 .51346 L .52892 .51472 L p .706 .536 .655 r
F P
0 g
s
.53461 .43937 m .52892 .51472 L .5431 .51317 L p .539 .39 .628 r
F P
0 g
s
.5431 .51317 m .5487 .4375 L .53461 .43937 L p .539 .39 .628 r
F P
0 g
s
.49755 .50984 m .50351 .43422 L .49813 .42909 L p .997 .813 .533 r
F P
0 g
s
.50351 .43422 m .49755 .50984 L .5116 .51346 L p .84 .655 .652 r
F P
0 g
s
.5487 .4375 m .5431 .51317 L .54878 .50934 L p .034 0 .442 r
F P
0 g
s
.54878 .50934 m .55437 .43318 L .5487 .4375 L p .034 0 .442 r
F P
0 g
s
.49209 .5052 m .49755 .50984 L p .49787 .46602 L .997 .813 .533 r
F P
0 g
s
.49813 .42909 m .49596 .45647 L p .49787 .46602 L .997 .813 .533 r
F P
0 g
s
.49596 .45647 m .49209 .5052 L p .49787 .46602 L .997 .813 .533 r
F P
0 g
s
.40932 .24904 m .48645 .43324 L .49118 .43259 L p .555 .569 .822 r
F P
0 g
s
.49209 .5052 m .49813 .42909 L .50349 .42468 L p 0 0 .419 r
F P
0 g
s
.49744 .5013 m .50349 .42468 L .5177 .42272 L p .533 .385 .625 r
F P
0 g
s
.49744 .5013 m .49209 .5052 L p .50045 .44611 L 0 0 .419 r
F P
0 g
s
.50349 .42468 m .50209 .44233 L p .50045 .44611 L 0 0 .419 r
F P
0 g
s
.50209 .44233 m .49744 .5013 L p .50045 .44611 L 0 0 .419 r
F P
0 g
s
.49118 .43259 m .50728 .43039 L p .47518 .35255 L .555 .569 .822 r
F P
0 g
s
.51174 .49965 m .5177 .42272 L .53527 .42399 L p .706 .535 .654 r
F P
0 g
s
.5177 .42272 m .51174 .49965 L .49744 .5013 L p .533 .385 .625 r
F P
0 g
s
.50728 .43039 m .52331 .4282 L p .51435 .41411 L .555 .569 .822 r
F P
0 g
s
.51435 .41411 m .47518 .35255 L .50728 .43039 L .555 .569 .822 r
F
.47518 .35255 m .40932 .24904 L .49118 .43259 L F
.55437 .43318 m .54878 .50934 L .54364 .50467 L p .999 .815 .515 r
F P
0 g
s
.54364 .50467 m .5493 .42801 L .55437 .43318 L p .999 .815 .515 r
F P
0 g
s
.4942 .55967 m .49516 .54744 L .50892 .55082 L p .84 .655 .652 r
F P
0 g
s
.50892 .55082 m .50798 .56301 L .4942 .55967 L p .84 .655 .652 r
F P
0 g
s
.51146 .53874 m .50892 .55082 L .49516 .54744 L p .817 .721 .759 r
F P
0 g
s
.50798 .56301 m .50892 .55082 L .52588 .55207 L p .706 .536 .655 r
F P
0 g
s
.50892 .55082 m .51146 .53874 L .52507 .53974 L p .7 .604 .746 r
F P
0 g
s
.52507 .53974 m .52588 .55207 L .50892 .55082 L p .7 .604 .746 r
F P
0 g
s
.02 w
.50936 .54824 m
.51469 .55038 L
s
.5 Mabswid
.52588 .55207 m .52496 .56425 L .50798 .56301 L p .706 .536 .655 r
F P
0 g
s
.52496 .56425 m .52588 .55207 L .53975 .5507 L p .538 .39 .628 r
F P
0 g
s
.02 w
.53591 .55893 m
.56991 .57261 L
s
.5 Mabswid
.52588 .55207 m .52507 .53974 L .53619 .5386 L p .551 .489 .739 r
F P
0 g
s
.53619 .5386 m .53975 .5507 L .52588 .55207 L p .551 .489 .739 r
F P
0 g
s
.01 w
.52178 .48957 m
.52403 .46015 L
s
.5 Mabswid
.49516 .54744 m .50043 .53599 L .51146 .53874 L p .817 .721 .759 r
F P
0 g
s
.51511 .52909 m .51146 .53874 L .50043 .53599 L p .768 .778 .861 r
F P
0 g
s
.01 w
.51969 .51696 m
.52178 .48957 L
s
.5 Mabswid
.51146 .53874 m .51511 .52909 L .52269 .52964 L p .678 .674 .839 r
F P
0 g
s
.52269 .52964 m .52507 .53974 L .51146 .53874 L p .678 .674 .839 r
F P
0 g
s
.52507 .53974 m .52269 .52964 L .52886 .52899 L p .551 .589 .845 r
F P
0 g
s
.52886 .52899 m .53619 .5386 L .52507 .53974 L p .551 .589 .845 r
F P
0 g
s
.49774 .5703 m .4942 .55967 L .50798 .56301 L p .84 .55 .498 r
F P
0 g
s
.50798 .56301 m .50882 .57296 L .49774 .5703 L p .84 .55 .498 r
F P
0 g
s
.50882 .57296 m .50798 .56301 L .52496 .56425 L p .698 .441 .531 r
F P
0 g
s
.52496 .56425 m .52249 .57396 L .50882 .57296 L p .698 .441 .531 r
F P
0 g
s
.52249 .57396 m .52496 .56425 L .53884 .56294 L p .505 .253 .467 r
F P
0 g
s
.53975 .5507 m .53884 .56294 L .52496 .56425 L p .538 .39 .628 r
F P
0 g
s
.02 w
.51469 .55038 m
.53234 .55749 L
s
.5 Mabswid
.48882 .55546 m .48979 .54316 L .49516 .54744 L p .997 .813 .532 r
F P
0 g
s
.49516 .54744 m .4942 .55967 L .48882 .55546 L p .997 .813 .532 r
F P
0 g
s
.50043 .53599 m .49516 .54744 L .48979 .54316 L p .944 .913 .756 r
F P
0 g
s
.51511 .52909 m .50898 .52754 L p .52901 .52541 L .421 .78 .996 r
F P
0 g
s
.52269 .52964 m .51511 .52909 L p .52901 .52541 L .421 .78 .996 r
F P
0 g
s
.50043 .53599 m .50898 .52754 L .51511 .52909 L p .768 .778 .861 r
F P
0 g
s
.52886 .52899 m .52269 .52964 L p .52901 .52541 L .421 .78 .996 r
F P
0 g
s
.48979 .54316 m .49616 .53249 L .50043 .53599 L p .944 .913 .756 r
F P
0 g
s
.50898 .52754 m .50043 .53599 L .49616 .53249 L p .822 .935 .904 r
F P
0 g
s
.53884 .56294 m .53975 .5507 L .54529 .54722 L p .034 0 .442 r
F P
0 g
s
.53975 .5507 m .53619 .5386 L .54061 .53575 L p .165 .236 .692 r
F P
0 g
s
.54061 .53575 m .54529 .54722 L .53975 .5507 L p .165 .236 .692 r
F P
0 g
s
.53619 .5386 m .52886 .52899 L .53129 .52738 L p .274 .462 .863 r
F P
0 g
s
.53129 .52738 m .54061 .53575 L .53619 .5386 L p .274 .462 .863 r
F P
0 g
s
.50513 .57725 m .49774 .5703 L .50882 .57296 L p .754 .291 .149 r
F P
0 g
s
.50882 .57296 m .5113 .57871 L .50513 .57725 L p .754 .291 .149 r
F P
0 g
s
.5113 .57871 m .50882 .57296 L .52249 .57396 L p .635 .228 .256 r
F P
0 g
s
.52249 .57396 m .51892 .57927 L .5113 .57871 L p .635 .228 .256 r
F P
0 g
s
.51892 .57927 m .52249 .57396 L .53364 .57294 L p .387 0 .109 r
F P
0 g
s
.53884 .56294 m .53364 .57294 L .52249 .57396 L p .505 .253 .467 r
F P
0 g
s
.49881 .67904 m .50483 .60105 L .49063 .59778 L p .84 .655 .652 r
F P
0 g
s
.50483 .60105 m .49881 .67904 L .51643 .68034 L p .706 .536 .655 r
F P
0 g
s
.51643 .68034 m .52232 .60234 L .50483 .60105 L p .706 .536 .655 r
F P
0 g
s
.01 w
.51229 .61392 m
.51442 .58597 L
s
.5 Mabswid
.52232 .60234 m .51643 .68034 L .53081 .6795 L p .539 .39 .628 r
F P
0 g
s
.53081 .6795 m .5366 .60116 L .52232 .60234 L p .539 .39 .628 r
F P
0 g
s
.49344 .56699 m .48882 .55546 L .4942 .55967 L p .93 .561 .155 r
F P
0 g
s
.4942 .55967 m .49774 .5703 L .49344 .56699 L p .93 .561 .155 r
F P
0 g
s
.53364 .57294 m .53884 .56294 L .54438 .55954 L p 0 0 .036 r
F P
0 g
s
.54529 .54722 m .54438 .55954 L .53884 .56294 L p .034 0 .442 r
F P
0 g
s
.50898 .52754 m .50664 .52557 L p .52901 .52541 L .421 .78 .996 r
F P
0 g
s
.01 w
.51904 .52548 m
.51969 .51696 L
s
.5 Mabswid
.49616 .53249 m .50664 .52557 L .50898 .52754 L p .822 .935 .904 r
F P
0 g
s
.5493 .42801 m .54364 .50467 L .52946 .50095 L p .843 .657 .65 r
F P
0 g
s
.52946 .50095 m .53527 .42399 L .5493 .42801 L p .843 .657 .65 r
F P
0 g
s
.52901 .52541 m .53129 .52738 L .52886 .52899 L p .421 .78 .996 r
F P
0 g
s
.50277 .57543 m .49344 .56699 L .49774 .5703 L p .544 .016 0 r
F P
0 g
s
.49774 .5703 m .50513 .57725 L .50277 .57543 L p .544 .016 0 r
F P
0 g
s
.53364 .57294 m .52512 .57871 L .51892 .57927 L p .387 0 .109 r
F P
0 g
s
.52512 .57871 m .53364 .57294 L .53805 .57026 L p 0 0 0 r
F P
0 g
s
.54438 .55954 m .53805 .57026 L .53364 .57294 L p 0 0 .036 r
F P
0 g
s
.50664 .52557 m .509 .52395 L p .52901 .52541 L .421 .78 .996 r
F P
0 g
s
.50037 .52959 m .509 .52395 L .50664 .52557 L p .408 .815 .608 r
F P
0 g
s
.50664 .52557 m .49616 .53249 L .50037 .52959 L p .408 .815 .608 r
F P
0 g
s
.54061 .53575 m .53129 .52738 L .52901 .52541 L p .49 0 0 r
F P
0 g
s
.48446 .67607 m .49063 .59778 L .48506 .59371 L p .997 .813 .533 r
F P
0 g
s
.49063 .59778 m .48446 .67607 L .49881 .67904 L p .84 .655 .652 r
F P
0 g
s
.5113 .57871 m .51892 .57927 L p .51905 .57393 L .394 .775 .991 r
F P
0 g
s
.50513 .57725 m .5113 .57871 L p .51905 .57393 L .394 .775 .991 r
F P
0 g
s
.51892 .57927 m .52512 .57871 L p .51905 .57393 L .394 .775 .991 r
F P
0 g
s
.5366 .60116 m .53081 .6795 L .5365 .6768 L p .034 0 .442 r
F P
0 g
s
.5365 .6768 m .54229 .59792 L .5366 .60116 L p .034 0 .442 r
F P
0 g
s
.49502 .53959 m .50037 .52959 L .49616 .53249 L p 0 0 0 r
F P
0 g
s
.49616 .53249 m .48979 .54316 L .49502 .53959 L p 0 0 0 r
F P
0 g
s
.54529 .54722 m .54061 .53575 L .53653 .53223 L p .916 .543 .112 r
F P
0 g
s
.52901 .52541 m .53653 .53223 L .54061 .53575 L p .49 0 0 r
F P
0 g
s
.53527 .42399 m .52946 .50095 L .51174 .49965 L p .706 .535 .654 r
F P
0 g
s
.49404 .55198 m .49502 .53959 L .48979 .54316 L p 0 0 .419 r
F P
0 g
s
.48979 .54316 m .48882 .55546 L .49404 .55198 L p 0 0 .419 r
F P
0 g
s
.54438 .55954 m .54529 .54722 L .54023 .5429 L p .999 .815 .515 r
F P
0 g
s
.03 w
.54448 .54863 m
.55396 .5477 L
s
.5 Mabswid
.53653 .53223 m .54023 .5429 L .54529 .54722 L p .916 .543 .112 r
F P
0 g
s
.50277 .57543 m .50513 .57725 L p .51905 .57393 L .394 .775 .991 r
F P
0 g
s
.01 w
.51442 .58597 m
.51516 .57633 L
s
.5 Mabswid
.53805 .57026 m .52755 .57724 L .52512 .57871 L p 0 0 0 r
F P
0 g
s
.52512 .57871 m .52755 .57724 L p .51905 .57393 L .394 .775 .991 r
F P
0 g
s
.67369 .53507 m .58638 .54371 L .58472 .5677 L p .54 .392 .629 r
F P
0 g
s
.58638 .54371 m .67369 .53507 L .66696 .51157 L p .554 .533 .786 r
F P
0 g
s
.66696 .51157 m .57958 .52085 L .58638 .54371 L p .554 .533 .786 r
F P
0 g
s
.509 .52395 m .5152 .52328 L p .52901 .52541 L .421 .78 .996 r
F P
0 g
s
.51157 .5284 m .5152 .52328 L .509 .52395 L p .363 0 .074 r
F P
0 g
s
.509 .52395 m .50037 .52959 L .51157 .5284 L p .363 0 .074 r
F P
0 g
s
.5152 .52328 m .52286 .52384 L .52901 .52541 L p .421 .78 .996 r
F P
0 g
s
.53653 .53223 m .52901 .52541 L .52286 .52384 L p .746 .271 .116 r
F P
0 g
s
.49766 .56426 m .49404 .55198 L .48882 .55546 L p .136 .216 .683 r
F P
0 g
s
.48882 .55546 m .49344 .56699 L .49766 .56426 L p .136 .216 .683 r
F P
0 g
s
.53805 .57026 m .54438 .55954 L .53931 .5553 L p .947 .922 .751 r
F P
0 g
s
.54023 .5429 m .53931 .5553 L .54438 .55954 L p .999 .815 .515 r
F P
0 g
s
.50513 .57394 m .49766 .56426 L .49344 .56699 L p .249 .451 .862 r
F P
0 g
s
.49344 .56699 m .50277 .57543 L .50513 .57394 L p .249 .451 .862 r
F P
0 g
s
.52755 .57724 m .53805 .57026 L .53395 .56692 L p .82 .945 .905 r
F P
0 g
s
.53931 .5553 m .53395 .56692 L .53805 .57026 L p .947 .922 .751 r
F P
0 g
s
.52543 .52941 m .52286 .52384 L .5152 .52328 L p .627 .211 .233 r
F P
0 g
s
.5152 .52328 m .51157 .5284 L .52543 .52941 L p .627 .211 .233 r
F P
0 g
s
.01 w
.51531 .57427 m
.51878 .52893 L
s
.5 Mabswid
.52286 .52384 m .52543 .52941 L .53653 .53223 L p .746 .271 .116 r
F P
0 g
s
.50513 .57394 m .50277 .57543 L p .51905 .57393 L .394 .775 .991 r
F P
0 g
s
.52755 .57724 m .52524 .57542 L .51905 .57393 L p .394 .775 .991 r
F P
0 g
s
.53395 .56692 m .52524 .57542 L .52755 .57724 L p .82 .945 .905 r
F P
0 g
s
.58472 .5677 m .67221 .55967 L .67369 .53507 L p .54 .392 .629 r
F P
0 g
s
.03 w
.55396 .5477 m
.60251 .5429 L
s
.5 Mabswid
.57958 .52085 m .66696 .51157 L .65446 .49789 L p .526 .694 .945 r
F P
0 g
s
.65446 .49789 m .56678 .50759 L .57958 .52085 L p .526 .694 .945 r
F P
0 g
s
.509 .53815 m .51157 .5284 L .50037 .52959 L p .496 .241 .458 r
F P
0 g
s
.50037 .52959 m .49502 .53959 L .509 .53815 L p .496 .241 .458 r
F P
0 g
s
.54023 .5429 m .53653 .53223 L .52543 .52941 L p .843 .548 .489 r
F P
0 g
s
.48506 .59371 m .4788 .67253 L .48446 .67607 L p .997 .813 .533 r
F P
0 g
s
.4788 .67253 m .48506 .59371 L .49042 .5904 L p 0 0 .419 r
F P
0 g
s
.54229 .59792 m .5365 .6768 L .53117 .67323 L p .999 .815 .515 r
F P
0 g
s
.53117 .67323 m .53704 .59383 L .54229 .59792 L p .999 .815 .515 r
F P
0 g
s
.51905 .57393 m .51136 .57337 L .50513 .57394 L p .394 .775 .991 r
F P
0 g
s
.49766 .56426 m .50513 .57394 L .51136 .57337 L p .545 .588 .849 r
F P
0 g
s
.52524 .57542 m .53395 .56692 L .52279 .56421 L p .769 .783 .864 r
F P
0 g
s
.52279 .56421 m .51905 .57393 L .52524 .57542 L p .769 .783 .864 r
F P
0 g
s
.52331 .4282 m .44657 .24162 L .40932 .24904 L p .555 .569 .822 r
F P
0 g
s
.50804 .5506 m .509 .53815 L .49502 .53959 L p .533 .385 .625 r
F P
0 g
s
.02 w
.50826 .54779 m
.50936 .54824 L
s
.5 Mabswid
.49502 .53959 m .49404 .55198 L .50804 .5506 L p .533 .385 .625 r
F P
0 g
s
.02 w
.49565 .54272 m
.50151 .54508 L
s
.48596 .53882 m
.49565 .54272 L
s
.5 Mabswid
.53931 .5553 m .54023 .5429 L .52634 .53942 L p .843 .657 .65 r
F P
0 g
s
.03 w
.49468 .55355 m
.53466 .5496 L
s
.53977 .5491 m
.54448 .54863 L
s
.5 Mabswid
.52543 .52941 m .52634 .53942 L .54023 .5429 L p .843 .548 .489 r
F P
0 g
s
.52634 .53942 m .52543 .52941 L .51157 .5284 L p .697 .437 .525 r
F P
0 g
s
.51157 .5284 m .509 .53815 L .52634 .53942 L p .697 .437 .525 r
F P
0 g
s
.51136 .57337 m .50888 .56319 L .49766 .56426 L p .545 .588 .849 r
F P
0 g
s
.49404 .55198 m .49766 .56426 L .50888 .56319 L p .547 .486 .739 r
F P
0 g
s
.50888 .56319 m .50804 .5506 L .49404 .55198 L p .547 .486 .739 r
F P
0 g
s
.53395 .56692 m .53931 .5553 L .5254 .55187 L p .82 .725 .76 r
F P
0 g
s
.5254 .55187 m .52279 .56421 L .53395 .56692 L p .82 .725 .76 r
F P
0 g
s
.50888 .56319 m .51136 .57337 L .51905 .57393 L p .677 .677 .842 r
F P
0 g
s
.51905 .57393 m .52279 .56421 L .50888 .56319 L p .677 .677 .842 r
F P
0 g
s
.52634 .53942 m .5254 .55187 L .53931 .5553 L p .843 .657 .65 r
F P
0 g
s
.41766 .53191 m .46735 .55135 L .46876 .53412 L p .92 .73 .629 r
F P
0 g
s
.46876 .53412 m .4192 .51424 L .41766 .53191 L p .92 .73 .629 r
F P
0 g
s
.4192 .51424 m .46876 .53412 L .47824 .51931 L p .854 .827 .821 r
F P
0 g
s
.42889 .49899 m .47824 .51931 L .49227 .51248 L p .669 .854 .971 r
F P
0 g
s
.47824 .51931 m .42889 .49899 L .4192 .51424 L p .854 .827 .821 r
F P
0 g
s
.42489 .54538 m .47459 .56454 L .46735 .55135 L p .879 .473 .249 r
F P
0 g
s
.46735 .55135 m .41766 .53191 L .42489 .54538 L p .879 .473 .249 r
F P
0 g
s
.66303 .57629 m .57516 .58394 L .56116 .58615 L p 0 0 0 r
F P
0 g
s
.57516 .58394 m .66303 .57629 L .67221 .55967 L p .474 .159 .352 r
F P
0 g
s
.56678 .50759 m .65446 .49789 L .6408 .49939 L p .079 .638 .704 r
F P
0 g
s
.6408 .49939 m .5527 .50913 L .56678 .50759 L p .079 .638 .704 r
F P
0 g
s
.5254 .55187 m .52634 .53942 L .509 .53815 L p .706 .535 .654 r
F P
0 g
s
.509 .53815 m .50804 .5506 L .5254 .55187 L p .706 .535 .654 r
F P
0 g
s
.50804 .5506 m .50888 .56319 L .52279 .56421 L p .7 .605 .746 r
F P
0 g
s
.52279 .56421 m .5254 .55187 L .50804 .5506 L p .7 .605 .746 r
F P
0 g
s
.48416 .66976 m .49042 .5904 L .50482 .58915 L p .533 .385 .625 r
F P
0 g
s
.49042 .5904 m .48416 .66976 L .4788 .67253 L p 0 0 .419 r
F P
0 g
s
.53704 .59383 m .53117 .67323 L .51669 .67018 L p .843 .657 .65 r
F P
0 g
s
.51669 .67018 m .52271 .59046 L .53704 .59383 L p .843 .657 .65 r
F P
0 g
s
.49227 .51248 m .44312 .49189 L .42889 .49899 L p .669 .854 .971 r
F P
0 g
s
.44312 .49189 m .49227 .51248 L .50557 .5163 L p 0 .464 .791 r
F P
0 g
s
.43824 .54948 m .48782 .56862 L .47459 .56454 L p 0 .424 .745 r
F P
0 g
s
.47459 .56454 m .42489 .54538 L .43824 .54948 L p 0 .424 .745 r
F P
0 g
s
.49866 .66885 m .50482 .58915 L .52271 .59046 L p .706 .535 .654 r
F P
0 g
s
.50482 .58915 m .49866 .66885 L .48416 .66976 L p .533 .385 .625 r
F P
0 g
s
.52271 .59046 m .51669 .67018 L .49866 .66885 L p .706 .535 .654 r
F P
0 g
s
.01 w
.50416 .7203 m
.50804 .66954 L
s
.5 Mabswid
.50557 .5163 m .45655 .49572 L .44312 .49189 L p 0 .464 .791 r
F P
0 g
s
.45655 .49572 m .50557 .5163 L .51302 .52945 L p .877 .461 .221 r
F P
0 g
s
.45265 .54251 m .50202 .56191 L .48782 .56862 L p .661 .861 .976 r
F P
0 g
s
.48782 .56862 m .43824 .54948 L .45265 .54251 L p .661 .861 .976 r
F P
0 g
s
.56116 .58615 m .64944 .57849 L .66303 .57629 L p 0 0 0 r
F P
0 g
s
.64944 .57849 m .56116 .58615 L .54803 .57316 L p .51 .695 .952 r
F P
0 g
s
.5527 .50913 m .6408 .49939 L .63122 .51584 L p .456 .132 .328 r
F P
0 g
s
.54275 .52522 m .5527 .50913 L p .6103 .51405 L .456 .132 .328 r
F P
0 g
s
.59995 .51916 m .54275 .52522 L p .6103 .51405 L .456 .132 .328 r
F P
0 g
s
.51302 .52945 m .464 .50914 L .45655 .49572 L p .877 .461 .221 r
F P
0 g
s
.54275 .52522 m .63122 .51584 L .6296 .54106 L p .532 .383 .625 r
F P
0 g
s
.6296 .54106 m .54094 .54979 L .54275 .52522 L p .532 .383 .625 r
F P
0 g
s
.46925 .50556 m .55496 .54134 L p .5909 .51903 L .754 .869 .932 r
F P
0 g
s
.55496 .54134 m .5588 .54294 L .5727 .53259 L p .754 .869 .932 r
F P
0 g
s
.5727 .53259 m .5909 .51903 L p .55496 .54134 L .754 .869 .932 r
F P
0 g
s
.63122 .51584 m .59995 .51916 L p .6103 .51405 L .456 .132 .328 r
F P
0 g
s
.464 .50914 m .51302 .52945 L .51168 .54691 L p .925 .733 .624 r
F P
0 g
s
.46253 .52706 m .51168 .54691 L .50202 .56191 L p .857 .834 .823 r
F P
0 g
s
.50202 .56191 m .45265 .54251 L .46253 .52706 L p .857 .834 .823 r
F P
0 g
s
.02 w
.44069 .5206 m
.46135 .52891 L
s
.5 Mabswid
.51168 .54691 m .46253 .52706 L .464 .50914 L p .925 .733 .624 r
F P
0 g
s
.63661 .56509 m .54803 .57316 L .54094 .54979 L p .547 .53 .788 r
F P
0 g
s
.54803 .57316 m .63661 .56509 L .64944 .57849 L p .51 .695 .952 r
F P
0 g
s
.54094 .54979 m .6296 .54106 L .63661 .56509 L p .547 .53 .788 r
F P
0 g
s
.72936 .52956 m .68869 .53359 L .68725 .55829 L p .54 .392 .629 r
F P
0 g
s
.68869 .53359 m .72936 .52956 L .72269 .50566 L p .554 .533 .786 r
F P
0 g
s
.72269 .50566 m .68198 .50998 L .68869 .53359 L p .554 .533 .786 r
F P
0 g
s
.68725 .55829 m .728 .55456 L .72936 .52956 L p .54 .392 .629 r
F P
0 g
s
.03 w
.62965 .54022 m
.68747 .53452 L
s
.5 Mabswid
.68198 .50998 m .72269 .50566 L .7104 .49171 L p .526 .694 .945 r
F P
0 g
s
.7104 .49171 m .66954 .49623 L .68198 .50998 L p .526 .694 .945 r
F P
0 g
s
.71907 .57141 m .67813 .57497 L .66462 .57717 L p 0 0 0 r
F P
0 g
s
.67813 .57497 m .71907 .57141 L .728 .55456 L p .474 .159 .352 r
F P
0 g
s
.66954 .49623 m .7104 .49171 L .69702 .49317 L p .079 .638 .704 r
F P
0 g
s
.69702 .49317 m .65595 .49771 L .66954 .49623 L p .079 .638 .704 r
F P
0 g
s
.5909 .51903 m .50239 .4801 L .46925 .50556 L p .754 .869 .932 r
F P
0 g
s
.66462 .57717 m .70578 .5736 L .71907 .57141 L p 0 0 0 r
F P
0 g
s
.70578 .5736 m .66462 .57717 L .65185 .5637 L p .51 .695 .952 r
F P
0 g
s
.65595 .49771 m .69702 .49317 L .6877 .50986 L p .456 .132 .328 r
F P
0 g
s
.64644 .51423 m .65595 .49771 L p .68711 .50964 L .456 .132 .328 r
F P
0 g
s
.68638 .51 m .64644 .51423 L p .68711 .50964 L .456 .132 .328 r
F P
0 g
s
.64644 .51423 m .6877 .50986 L .68619 .53549 L p .532 .383 .625 r
F P
0 g
s
.68619 .53549 m .64484 .53956 L .64644 .51423 L p .532 .383 .625 r
F P
0 g
s
.51556 .47977 m .6377 .53392 L p .68051 .50908 L .752 .876 .936 r
F P
0 g
s
.6377 .53392 m .64324 .53638 L .66474 .52063 L p .752 .876 .936 r
F P
0 g
s
.66474 .52063 m .68051 .50908 L p .6377 .53392 L .752 .876 .936 r
F P
0 g
s
.6877 .50986 m .68638 .51 L p .68711 .50964 L .456 .132 .328 r
F P
0 g
s
.69316 .55994 m .65185 .5637 L .64484 .53956 L p .547 .53 .788 r
F P
0 g
s
.65185 .5637 m .69316 .55994 L .70578 .5736 L p .51 .695 .952 r
F P
0 g
s
.82526 .53867 m .8289 .53127 L .71329 .53197 L closepath p .541 .227 .384 r
F P
0 g
s
.81982 .53951 m .82526 .53867 L .71329 .53197 L closepath p .198 0 0 r
F P
0 g
s
.81465 .53339 m .81982 .53951 L .71329 .53197 L closepath p .422 .648 .952 r
F P
0 g
s
.8289 .53127 m .82938 .52014 L .71329 .53197 L closepath p .582 .427 .636 r
F P
0 g
s
.81176 .52262 m .81465 .53339 L .71329 .53197 L closepath p .495 .495 .786 r
F P
0 g
s
.8213 .50333 m .71329 .53197 L .82654 .50948 L p .592 .726 .937 r
F P
0 g
s
.82938 .52014 m .82654 .50948 L .71329 .53197 L closepath p .597 .561 .785 r
F P
0 g
s
.81227 .51136 m .81176 .52262 L .71329 .53197 L closepath p .48 .34 .614 r
F P
0 g
s
.71329 .53197 m .8213 .50333 L .81892 .50362 L p .279 .782 .802 r
F P
0 g
s
.81892 .50362 m .81598 .50399 L .71329 .53197 L p .279 .782 .802 r
F P
0 g
s
.81598 .50399 m .81227 .51136 L .71329 .53197 L closepath p .368 .047 .283 r
F P
0 g
s
.03 w
.68747 .53452 m
.71329 .53197 L
s
.5 Mabswid
.64484 .53956 m .68619 .53549 L .69316 .55994 L p .547 .53 .788 r
F P
0 g
s
.68051 .50908 m .55469 .44978 L .51556 .47977 L p .752 .876 .936 r
F P
0 g
s
.82654 .50948 m .82379 .50615 L .8213 .50333 L p .592 .726 .937 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{41, 0}, {0, 5}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00OP3oool3000009l0oooo001h
0?ooo`H000000P2>TM800`000000oooo0?ooo`2M0?ooo`00M@3oool3000000T0SY7B00<000000?oo
o`3oool0W03oool007D0oooo00<0000008jAdP2>TM802@2>TM800`000000oooo0?ooo`2L0?ooo`00
MP3oool<08jAdP030000003oool0oooo09/0oooo001f0?ooo`030000002>TM80SY7B00T0SY7B00<0
00000?ooo`3oool0V`3oool007L0oooo2`2>TM800`000000oooo0?ooo`2K0?ooo`00M`3oool00`00
0000SY7B08jAdP0908jAdP030000003oool0oooo09X0oooo001g0?ooo`030000002>TM80SY7B00T0
SY7B00<000000?ooo`3oool0VP3oool007P0oooo00<0000008jAdP2>TM802@2>TM800`000000oooo
0?ooo`2I0?ooo`00N03oool00`000000SY7B08jAdP0908jAdP030000003oool0oooo09T0oooo001i
0?ooo``0SY7B00<000000?ooo`3oool0V03oool007T0oooo00<0000008jAdP2>TM802@2>TM800`00
0000oooo0?ooo`2H0?ooo`00NP3oool208jAdP030?ooo`2>TM80SY7B00H0SY7B00<000000?ooo`3o
ool0V03oool007X0oooo00<0000008jAdP2>TM802@2>TM800`000000oooo0?ooo`2G0?ooo`00NP3o
ool00`000000SY7B08jAdP0908jAdP030000003oool0oooo09L0oooo001k0?ooo`040000002>TM80
SY7B0?ooo`P0SY7B00<000000?ooo`3oool0UP3oool007/0oooo00<0000008jAdP2>TM802@2>TM80
0`000000oooo0?ooo`2F0?ooo`00O03oool;08jAdP030000003oool0oooo09H0oooo001l0?ooo`03
0000002>TM80SY7B00T0SY7B00<000000?ooo`3oool0U@3oool007`0oooo00<0000008jAdP2>TM80
2@2>TM800`000000oooo0?ooo`2E0?ooo`00O@3oool00`000000SY7B08jAdP0908jAdP030000003o
ool0oooo09@0oooo001m0?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool0U03oool0
07h0oooo00<0000008jAdP2>TM802@2>TM800`000000oooo0?ooo`2C0?ooo`00OP3oool00`000000
SY7B08jAdP0208jAdP030?ooo`2>TM80SY7B00@0SY7B00<000000?ooo`3oool0T`3oool007l0oooo
2`2>TM800`000000oooo0?ooo`2C0?ooo`00O`3oool00`000000SY7B08jAdP0908jAdP030000003o
ool0oooo0980oooo001o0?ooo`030000002>TM80SY7B00<0SY7B00<0oooo08jAdP2>TM800`2>TM80
0`000000oooo0?ooo`2B0?ooo`00P03oool00`000000SY7B08jAdP0908jAdP030000003oool0oooo
0940oooo00200?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool0T@3oool00840oooo
00<0000008jAdP2>TM800`2>TM800`3oool0SY7B08jAdP0208jAdP030000003oool0oooo0940oooo
00210?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool0T03oool00840oooo00<00000
08jAdP2>TM80102>TM800`3oool0SY7B08jAdP0208jAdP030000003oool0oooo02P0oooo0`00001U
0?ooo`00PP3oool00`000000SY7B08jAdP0408jAdP030?ooo`2>TM80SY7B0080SY7B00<000000?oo
o`3oool08P3oool50000000306D0:`000000oooo06D0oooo00220?ooo`030000002>TM80SY7B00T0
SY7B00<000000?ooo`3oool07`3oool3000000D0I@0[00<000000?ooo`3oool0I@3oool008<0oooo
00<0000008jAdP2>TM80102>TM800`3oool0SY7B08jAdP0208jAdP030000003oool0oooo01d0oooo
00<0000006D0:`1U02/01@1U02/00`000000oooo0?ooo`1V0?ooo`00P`3oool00`000000SY7B08jA
dP0908jAdP030000003oool0oooo01`0oooo00<0000006D0:`1U02/01@1U02/00`000000oooo0?oo
o`1W0?ooo`00Q03oool00`000000SY7B08jAdP0808jAdP030000003oool0oooo01/0oooo00<00000
06D0:`1U02/01@1U02/00`000000oooo0?ooo`1X0?ooo`00Q03oool00`000000SY7B08jAdP0508jA
dP050?ooo`2>TM80SY7B08jAdP0000006`3oool00`000000I@0[06D0:`0606D0:`030000003oool0
oooo06P0oooo00240?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool0603oool00`00
0000I@0[06D0:`0606D0:`030000003oool0oooo06T0oooo00250?ooo`030000002>TM80SY7B00T0
SY7B00<000000?ooo`3oool05P3oool00`000000I@0[06D0:`0606D0:`030000003oool0oooo06X0
oooo00250?ooo`030000002>TM80SY7B00H0SY7B00@0oooo08jAdP2>TM8000005`3oool00`000000
I@0[06D0:`0606D0:`030000003oool0oooo06/0oooo00260?ooo`030000002>TM80SY7B00P0SY7B
00<000000?ooo`3oool0503oool00`000000I@0[06D0:`0606D0:`030000003oool0oooo06`0oooo
00260?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool04P3oool00`000000I@0[06D0
:`0606D0:`030000003oool0oooo06d0oooo00260?ooo`030000002>TM80SY7B00L0SY7B00<0oooo
08jAdP0000004`3oool00`000000I@0[06D0:`0606D0:`030000003oool0oooo06h0oooo00270?oo
o`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool03`3oool00`000000I@0[06D0:`0606D0
:`030000003oool0oooo06l0oooo00270?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3o
ool03P3oool00`000000I@0[06D0:`0606D0:`030000003oool0oooo0700oooo00280?ooo`030000
002>TM80SY7B00L0SY7B00<0oooo08jAdP0000003`3oool00`000000I@0[06D0:`0506D0:`030000
003oool0oooo0740oooo00280?ooo`030000002>TM80SY7B00T0SY7B00<000000?ooo`3oool0303o
ool00`000000I@0[06D0:`0506D0:`030000003oool0oooo0780oooo00290?ooo`030000002>TM80
SY7B00L0SY7B00<0oooo0000003oool0303oool00`000000I@0[06D0:`0506D0:`030000003oool0
oooo07<0oooo00290?ooo`030000002>TM80SY7B00P0SY7B00<0oooo0000003oool02P3oool00`00
0000I@0[06D0:`0606D0:`030000003oool0oooo07<0oooo00290?ooo`030000002>TM80SY7B00T0
SY7B00<000000?ooo`3oool0203oool00`000000I@0[06D0:`0606D0:`030000003oool0oooo07@0
oooo002:0?ooo`030000002>TM80SY7B00T0SY7B1@0000040?ooo`030000001U02/0I@0[00H0I@0[
00<000000?ooo`3oool0M@3oool008X0oooo00<0000008jAdP2>TM801`2>TM8300000080]8RW00<0
00000=NXYP0000000`00000806D0:`030000003oool0oooo07H0oooo002;0?ooo`040000002>TM80
SY7B08jAdPH00000102dR:L010000000ejRV0=NXYP3GZ:H2000000L0I@0[00<000000?ooo`3oool0
M`3oool008/0oooo100000000`0006/0000008QRW`0208QRW`030000002dR:L0]8RW0080]8RW00L0
00000=NXYP3GZ:H0ejRV0000003od8<0000000D0I@0[00<000000?ooo`3oool0N03oool008h0oooo
00<000000000J`0000000`28HYl00`000000]8RW0;B8Y`020;B8Y`070000003GZ:H0ejRV0=NXYP00
0000om230000000406D0:`030000003oool0oooo07T0oooo002>0?ooo`030000000006/0000000<0
R6:O00<000000;B8Y`2dR:L00P2dR:L01`000000ejRV0=NXYP3GZ:H000000?o@P`0000000`1U02/0
0`000000oooo0?ooo`1j0?ooo`00SP3oool300000080R6:O00<000000;B8Y`2dR:L00P2dR:L00`00
0000ejRV0=NXYP020=NXYP030000003od8<000000080I@0[00<000000?ooo`3oool0N`3oool008h0
oooo00<000000000J`0000000P28HYl00`000000]8RW0;B8Y`020;B8Y`030000003GZ:H0ejRV0080
ejRV00<000000?o@P`0000000P00001n0?ooo`00SP3oool00`000000001[0000000208QRW`030000
002dR:L0]8RW0080]8RW00<000000=NXYP3GZ:H00P3GZ:H010000000om2300000000001o0?ooo`00
SP3oool00`000000001[0000000208QRW`030000002dR:L0]8RW0080]8RW00<000000=NXYP3GZ:H0
0P3GZ:H200000080`>3_0P00001m0?ooo`00SP3oool2000000<0R6:O00<000000;B8Y`2dR:L00P2d
R:L01@000000ejRV0=NXYP3GZ:H0000000H0`>3_0P00001k0?ooo`00SP3oool2000000<0R6:O00<0
00000;B8Y`0000000P2dR:L010000000ejRV0000000000090<3Pk`800000N@3oool008h0oooo0P00
000308QRW`030000002dR:L000000080]8RW0P00000=0<3Pk`800000M`3oool008h0oooo0P000003
08QRW`040000002dR:L0]8RW0;B8Y`8000004030h>l2000007D0oooo002=0?ooo`030000000006/0
000000<0R6:O00@000000;B8Y`2dR:L000005030h>l2000007<0oooo002=0?ooo`030000000006/0
000000<0R6:O0`00000G0<3Pk`800000L@3oool008d0oooo00<000000000J`0000000P0000000`28
HYl000000<3Pk`0J0<3Pk`800000K`3oool008d0oooo00<000000000J`0000000P31g^h200000003
0;B8Y`000000000001X0`>3_0`00001/0?ooo`00S@3oool2000000D0`Mk^0P0000000`2dR:L00000
0000000K0<3Pk`800000JP3oool008`0oooo00<000000<7NkP31g^h01`31g^h2000000030=NXYP00
0000000001/0`>3_0P00001X0?ooo`00OP3oool3000000X0oooo00<000000<7NkP31g^h02P31g^h6
000001X0`>3_0P0000080?ooo`X00000E03oool007`0oooo0P0000030:_Jn0@000001@3oool00`00
0000`Mk^0<7NkP0>0<7NkPD000006P30h>l8000000D0M25C00<0000008Jal@26/O400P26/O400`00
0000oooo0?ooo`1A0?ooo`00N`3oool00`000000Zm[h0:_Jn0050:_Jn0050000003PMSP000000000
003oool00P00000C0<7NkP80000000<0oooo0000000000006P30h>l2000000T0M25C00<0000008Ja
l@26/O400`26/O400`000000oooo0?ooo`1@0?ooo`00NP3oool00`000000f]?B0=[CdP02000000D0
Zm[h00@000000>1f>03PMSP000005`31g^h5000001X0`>3_0P00000607@QD`0300000026/O40Q[7a
00D0Q[7a00<000000?ooo`3oool0603oool3000003@0oooo001j0?ooo`030000003Jdm80f]?B0080
f]?B0P0000030:_Jn0030000003PMSP0000001/0`Mk^1@00000I0<3Pk`800000101d8E<00`000000
Q[7a08Jal@07000001D0oooo10000000101N34P0000009Nik`00000c0?ooo`00N@3oool00`000000
f]?B0=[CdP050=[CdP<0000000@0Zm[h000000000000h7Hh0P00000J0<7NkP80000000<0M25C0000
000000006@30h>l7000000H0SHS900<000000?ooo`3oool03`3oool400000080GPa80`000000102G
^Nl0000000000000000b0?ooo`00N03oool00`000000f]?B0=[CdP020=[CdP<00000103Jdm820000
00030>bkW`000000000000@000006@31g^h20000000307@QD`000000000001H0`>3_0P00000208QR
W`030000002=R<T0SHS900P0SHS900<000000?ooo`3oool02P3oool40000000305h<B00000000000
00<000000P1jEid200000080V8o800<000000?ooo`3oool0<03oool007P0oooo00<000000>^jX@00
0000200000020=[CdP030000003/^il0k;^O0080k;^O0P0000000`3PMSP000000000000I0<7NkP80
000000<0M25C0000000000004P30h>l2000000@0R6:O00<0000008f8b@2=R<T0102=R<T5000000T0
oooo2000000707YGW@030000002HSlP0V8o80080V8o800<000000?ooo`3oool0;`3oool007P0oooo
00@000000>^jX@3[^Z40jkZQ2@0000070>bkW`H000005P31g^h8000000h0`>3_00<0000008QRW`28
HYl01028HYl<000000D0oooo1`00000;07YGW@L00000<@3oool007L0oooo00<000000>^jX@3[^Z40
0P3[^Z49000000X0k;^O1@00000B0<7NkP8000002028HYl2000000X0`>3_0P00000308QRW`l00000
00<0SHS90000000000001P00000807YGW@P000001@2DKJ800`000000oooo0?ooo`0_0?ooo`00M`3o
ool00`000000jkZQ0>^jX@030>^jX@T00000303/^il5000000h0`Mk^00<0000008QRW`28HYl02P28
HYl2000000L0`>3_00<0000008QRW`28HYl00`28HYlP000000L0OWk900<0000009A]XP2DKJ800P2D
KJ800`000000oooo0?ooo`0`0?ooo`00M`3oool2000000L0jkZQ2@00000:0>bkW`030000002bKhH0
/Vn600<000002`31g^h00`000000R6:O08QRW`0908QRW`H000000`30h>l2000000H0R6:O6P00000>
07inb@D00000<P3oool007L0oooo00@000000>5i?`0000000000203[^Z43000000<0fmGB0P000008
0>bkW`060000002bKhH0/Vn60;9_QP000000eham0`0000070<7NkP0300000028HYl0R6:O00X0R6:O
2P00000508QRWb/000000`2:>V800`000000oooo0?ooo`0`0?ooo`00N03oool00`000000hGTo0>5i
?`03000000@0jkZQ00<000000=_EdP3KeM801P3KeM83000000@0k;^O1`0000000`3GS7d000000000
0002000000<0`Mk^00<0000008QRW`28HYl03028HYl?000000D0S8O93P0000030<3Pk`8000003@3o
ool9000003<0oooo001h0?ooo`030000003QNCl0hGTo00<0hGTo1@00000;0=_EdP<0000000<0k;^O
0000002dR:L00`2dR:L500000080R6:O0`00000=08QRW``000002`2<QlT=000000D0`>3_0P000017
0?ooo`00L`3oool8000000<0hGTo0P0000030:WLn@800000303KeM82000000@0]8RW00<000000=NX
YP0000000P00000608QRW``000000`2<QlT:000000X0S8O92000000308YTX@0300000030h>l0`>3_
00H0`>3_0P0000150?ooo`00LP3oool=000000H0ZMci0`00000:0=_EdP050000002dR:L0]8RW0;B8
Y`0000000P3GZ:H9000000l0S8O92P00000:08b7b@030000002:I:40RVBQ00P0RVBQ00<000000<3P
k`30h>l02030h>l2000004<0oooo001a0?oooa0000001`2Yg?T2000000L0fmGB1`0000020=NXYP80
00005@2<QlT:000000X0S8O900<0000008YTX@2:I:40202:I:400`000000`>3_0<3Pk`0:0<3Pk`80
0000@@3oool00740oooo00<0000009E^X`2EKZ<02`2EKZ<5000000H0ZMci0`0000040=_EdP030000
002cV[h0/iZn0080/iZn00<000000=6i`P0000001000000D08b7b@D00000102:I:400`000000S8O9
08b7b@0908b7b@030000002:I:40RVBQ0080RVBQ1P00000>0<3Pk`800000?`3oool00740oooo00<0
000009E^X`2EKZ<00P2EKZ<9000000<0VHo8100000070:WLn@80000000@0fmGB0000002<O;d00000
0`2cV[h010000000dKW20=6i`P3A^L83000001P0S8O900<0000008YTX@2:I:400P2:I:42000000D0
S8O92P00000507TXFP0300000030h>l0`>3_00h0`>3_0P00000m0?ooo`00L@3oool5000000P0VHo8
2`0000060:WLn@T0000000<0dKW20000000000000P00000I08b7b@/000001P22/O<00`000000NBQJ
07TXFP0507TXFP0300000030h>l0`>3_0140`>3_0P00000k0?ooo`00L@3oool00`000000VHo809V?
b00509V?b0D0000000@0V;W^00000000000000001@3oool400000080ZMci0`00000208^Ff@040000
002][ML0[JgG00000080a<SM0P0000000`3bk<0000000000000C08b7b@L000001@1i:5X00`000000
P[7c08:al`0908:al`030000001i:5X0NBQJ00@0NBQJ00<000000<3Pk`30h>l04`30h>l2000003T0
oooo001b0?ooo`030000002ISlP0VHo800@000000`2H^Nh3000000/0oooo0`0000000`3oool00000
0000000208^Ff@040000002][ML0[JgG00000080a<SM00<000000=7ai`0000000`00000608b7b@`0
00001`22/O<00`000000NBQJ07TXFP0207TXFP0300000022/O<0P[7c00X0P[7c00<0000007TXFP00
00000`00000H0<3Pk`800000=`3oool00780oooo0`00000309RikP@000004`3oool600000080a<SM
0`0000030>^jX@L000005022/O<00`000000NBQJ07TXFP0207TXFP0300000022/O<0P[7c00@0P[7c
2@0000020?ooo`<000005`30h>l2000003D0oooo001b0?ooo`030000002H^Nh0V;W^00<00000603o
ool01@000000I<Km000000000000I<Km00H000000`3[^Z400`000000P[7c08:al`0H08:al``00000
2031g^h2000000<0oooo0P00000G0<3Pk`800000<`3oool007<0oooo0P00000L0?ooo`H0000000@0
oooo0000003QNCl0hGTo0`0000000`3[^Z40000008:al`0C08:al`P000004031g^h2000000H0oooo
0P00000G0<3Pk`800000<@3oool00980oooo0P0000040?ooo`030000003QNCl0hGTo00<0hGTo0`00
000708:al``0000000<0k;^O0000003oool0103oool2000000h0`Mk^00<000000?ooo`3oool0203o
ool2000001@0`>3_0P00000b0?ooo`00TP3oool2000000D0oooo0P0000030>5i?`80000000<0ZMci
0000000000001@0000070=_EdP<000000P3/^il2000000L0oooo0`0000090<7NkP8000003@3oool2
00000140`>3_00<000000?ooo`3oool0<P3oool008`0oooo300000030?ooo`@000001P2Yg?T30000
00X0fmGB1@0000090?ooo`8000001P31g^h00`000000oooo0?ooo`0?0?ooo`<000003030h>l20000
03D0oooo002;0?ooo`8000000`28HYl00`000000]8RW0;B8Y`030;B8Y`030000003GZ:H000000080
00000P3oool4000000L0ZMci0P0000090=_EdPH000002@3oool200000080`Mk^0P00000E0?ooo`80
00002@30h>l00`000000oooo0?ooo`0e0?ooo`00R`3oool2000000<0R6:O00<000000;B8Y`2dR:L0
0`2dR:L010000000ejRV0=NXYP3GZ:H2000000@0oooo100000060:WLn@8000001`3KeM88000000T0
oooo0P00000I0?ooo`8000001P30h>l00`000000oooo0?ooo`0f0?ooo`00R`3oool2000000<0R6:O
00<000000;B8Y`2dR:L00`2dR:L010000000ejRV0=NXYP3GZ:H2000000H0oooo100000060:WLn@<0
00000`3KeM88000002L0oooo0P0000020<3Pk`800000>@3oool008/0oooo0P00000308QRW`030000
002dR:L0]8RW00<0]8RW00@000000=NXYP3GZ:H0ejRV0P0000090?ooo`<000001`2Yg?T200000080
fmGB1`00000Y0?ooo`800000>`3oool008/0oooo0P00000308QRW`030000002dR:L0]8RW00<0]8RW
00@000000=NXYP3GZ:H0ejRV0P00000<0?ooo`<000001P2Yg?T2000000<0oooo0`00001W0?ooo`00
R`3oool00`000000R6:O08QRW`0208QRW`030000002dR:L0]8RW0080]8RW00<000000=NXYP3GZ:H0
0P3GZ:H2000000h0oooo0`0000020:WLn@8000001`3oool00`000000oooo0?ooo`1U0?ooo`00RP3o
ool2000000@0R6:O00<000000;B8Y`2dR:L00P2dR:L01`000000ejRV0=NXYP3GZ:H000000?o@P`00
00004@3oool200000740oooo002:0?ooo`8000001028HYl00`000000]8RW0;B8Y`020;B8Y`060000
003GZ:H0ejRV0=NXYP000000om23Q@3oool008X0oooo0P00000408QRW`030000002dR:L0]8RW0080
]8RW00H000000=NXYP3GZ:H0ejRV0000003od8>50?ooo`00RP3oool2000000@0R6:O00<000000;B8
Y`2dR:L00P2dR:L010000000ejRV0=NXYP3GZ:H2000008D0oooo002:0?ooo`8000001028HYl00`00
0000]8RW0;B8Y`020;B8Y`040000003GZ:H0ejRV0=NXYP800000Q@3oool008X0oooo0P00000308QR
W`030000002dR:L0]8RW00<0]8RW00@000000=NXYP3GZ:H0ejRV0P0000250?ooo`00RP3oool20000
00<0R6:O00<000000;B8Y`2dR:L00`2dR:L010000000ejRV0=NXYP3GZ:H2000008D0oooo002:0?oo
o`8000000`28HYl00`000000]8RW0;B8Y`030;B8Y`040000003GZ:H0ejRV0=NXYP800000Q@3oool0
08X0oooo0P00000308QRW`030000002dR:L0]8RW00<0]8RW00@000000=NXYP3GZ:H0ejRV0P000025
0?ooo`00RP3oool00`0006/0000008QRW`0208QRW`030000002dR:L0]8RW00<0]8RW00@000000=NX
YP3GZ:H0ejRV0P0000250?ooo`00RP3oool00`0006/0000008QRW`0208QRW`030000002dR:L0]8RW
00<0]8RW00@000000=NXYP3GZ:H0ejRV0P0000250?ooo`00RP3oool00`000000R6:O08QRW`0208QR
W`030000002dR:L0]8RW0080]8RW00<000000=NXYP3GZ:H00P3GZ:H2000008D0oooo00290?ooo`80
00001028HYl00`000000]8RW0;B8Y`020;B8Y`070000003GZ:H0ejRV0=NXYP000000om2300000025
0?ooo`00R@3oool2000000@0R6:O00<000000;B8Y`2dR:L00P2dR:L010000000ejRV0=NXYP3GZ:H2
000008H0oooo00290?ooo`8000001028HYl00`000000]8RW0;B8Y`020;B8Y`040000003GZ:H0ejRV
0=NXYP800000QP3oool008T0oooo0P00000208QRW`D000000P2dR:L010000000ejRV0=NXYP3GZ:H2
000008H0oooo00290?ooo`@000000P3GYjH700000080ejRV0P0000260?ooo`00R@3oool00`000000
om28000000030=NWYP<000000P2dRJL00`000000RF>P00000003000008H0oooo002:0?ooo`P00000
0P2dRJL010000000RF>P08USX029Hj02000008H0oooo002@0?ooo`T00000Q`3oool00900oooo0P00
002>0?ooo`00T03oool2000008h0oooo002@0?ooo`800000SP3oool00900oooo0P00002>0?ooo`00
T03oool2000008h0oooo002@0?ooo`800000SP3oool00900oooo0P00002>0?ooo`00T03oool20000
08h0oooo002@0?ooo`800000SP3oool00900oooo0P00002>0?ooo`00S`3oool3000008h0oooo002@
0?ooo`030000003oool0oooo08d0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 143.5}, {136.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.68139 .63416 m .72232 .58127 L .68323 .59758 L p .625 .956 .914 r
F P
0 g
s
.68323 .59758 m .64507 .64946 L .68139 .63416 L p .625 .956 .914 r
F P
0 g
s
.53582 .38016 m .54414 .45834 L .5004 .45249 L p .667 .243 .231 r
F P
0 g
s
.5004 .45249 m .49518 .37459 L .53582 .38016 L p .667 .243 .231 r
F P
0 g
s
.60314 .60936 m .62742 .5708 L .59173 .58547 L p .647 .96 .927 r
F P
0 g
s
.59173 .58547 m .56928 .6234 L .60314 .60936 L p .647 .96 .927 r
F P
0 g
s
.51187 .54165 m .4974 .57384 L .51237 .58064 L p .362 .629 .955 r
F P
0 g
s
.51237 .58064 m .52751 .54875 L .51187 .54165 L p .362 .629 .955 r
F P
0 g
s
.52751 .54875 m .51237 .58064 L .52071 .59451 L p .049 .234 .732 r
F P
0 g
s
.49524 .54458 m .48147 .57669 L .4974 .57384 L p .608 .9 .987 r
F P
0 g
s
.4974 .57384 m .51187 .54165 L .49524 .54458 L p .608 .9 .987 r
F P
0 g
s
.52071 .59451 m .53626 .56321 L .52751 .54875 L p .049 .234 .732 r
F P
0 g
s
.53626 .56321 m .52071 .59451 L .51925 .61021 L p 0 0 .175 r
F P
0 g
s
.48394 .55647 m .47063 .58813 L .48147 .57669 L p .745 .966 .688 r
F P
0 g
s
.48147 .57669 m .49524 .54458 L .48394 .55647 L p .745 .966 .688 r
F P
0 g
s
.51925 .61021 m .53477 .57955 L .53626 .56321 L p 0 0 .175 r
F P
0 g
s
.53477 .57955 m .51925 .61021 L .50847 .62175 L p .71 .946 .651 r
F P
0 g
s
.48232 .57283 m .46906 .60386 L .47063 .58813 L p 0 0 .125 r
F P
0 g
s
.47063 .58813 m .48394 .55647 L .48232 .57283 L p 0 0 .125 r
F P
0 g
s
.50847 .62175 m .52354 .59155 L .53477 .57955 L p .71 .946 .651 r
F P
0 g
s
.52354 .59155 m .50847 .62175 L .49247 .62468 L p .59 .902 .984 r
F P
0 g
s
.49106 .58741 m .47739 .61784 L .46906 .60386 L p .008 .209 .72 r
F P
0 g
s
.46906 .60386 m .48232 .57283 L .49106 .58741 L p .008 .209 .72 r
F P
0 g
s
.49247 .62468 m .50683 .59457 L .52354 .59155 L p .59 .902 .984 r
F P
0 g
s
.50683 .59457 m .49247 .62468 L .47739 .61784 L p .338 .623 .956 r
F P
0 g
s
.47739 .61784 m .49106 .58741 L .50683 .59457 L p .338 .623 .956 r
F P
0 g
s
.52594 .51795 m .53279 .44475 L .51586 .44248 L p .734 .546 .639 r
F P
0 g
s
.53279 .44475 m .52594 .51795 L .54128 .51657 L p .579 .409 .616 r
F P
0 g
s
.54128 .51657 m .54799 .44313 L .53279 .44475 L p .579 .409 .616 r
F P
0 g
s
.50883 .51571 m .51586 .44248 L .50348 .43715 L p .872 .674 .632 r
F P
0 g
s
.51586 .44248 m .50883 .51571 L .52594 .51795 L p .734 .546 .639 r
F P
0 g
s
.68178 .59597 m .72547 .60157 L .72694 .57865 L p .733 .546 .639 r
F P
0 g
s
.72694 .57865 m .68339 .57303 L .68178 .59597 L p .733 .546 .639 r
F P
0 g
s
.68339 .57303 m .72694 .57865 L .7313 .55603 L p .717 .64 .772 r
F P
0 g
s
.7313 .55603 m .68763 .55035 L .68339 .57303 L p .717 .64 .772 r
F P
0 g
s
.54799 .44313 m .54128 .51657 L .54908 .51205 L p .2 .089 .494 r
F P
0 g
s
.54908 .51205 m .55575 .43819 L .54799 .44313 L p .2 .089 .494 r
F P
0 g
s
.56624 .58117 m .66535 .59386 L .66702 .57091 L p .733 .546 .639 r
F P
0 g
s
.66702 .57091 m .56825 .55815 L .56624 .58117 L p .733 .546 .639 r
F P
0 g
s
.56825 .55815 m .66702 .57091 L .6712 .54821 L p .717 .64 .772 r
F P
0 g
s
.68763 .55035 m .7313 .55603 L .73698 .54205 L p .644 .738 .917 r
F P
0 g
s
.68339 .61073 m .72745 .61634 L .72547 .60157 L p .709 .368 .397 r
F P
0 g
s
.72547 .60157 m .68178 .59597 L .68339 .61073 L p .709 .368 .397 r
F P
0 g
s
.84585 .5939 m .84789 .5842 L .74013 .58015 L closepath p .747 .671 .777 r
F P
0 g
s
.84538 .60376 m .84585 .5939 L .74013 .58015 L closepath p .765 .572 .638 r
F P
0 g
s
.49628 .51068 m .50348 .43715 L .50037 .43074 L p .985 .818 .425 r
F P
0 g
s
.50348 .43715 m .49628 .51068 L .50883 .51571 L p .872 .674 .632 r
F P
0 g
s
.73698 .54205 m .69294 .53629 L .68763 .55035 L p .644 .738 .917 r
F P
0 g
s
.84789 .5842 m .85073 .57832 L .74013 .58015 L closepath p .681 .787 .93 r
F P
0 g
s
.84667 .61009 m .84538 .60376 L .74013 .58015 L closepath p .751 .393 .376 r
F P
0 g
s
.57214 .53531 m .6712 .54821 L .67638 .53412 L p .644 .738 .917 r
F P
0 g
s
.6712 .54821 m .57214 .53531 L .56825 .55815 L p .717 .64 .772 r
F P
0 g
s
.56688 .59588 m .66683 .60862 L .66535 .59386 L p .709 .368 .397 r
F P
0 g
s
.66535 .59386 m .56624 .58117 L .56688 .59588 L p .709 .368 .397 r
F P
0 g
s
.55575 .43819 m .54908 .51205 L .54624 .50607 L p .974 .81 .392 r
F P
0 g
s
.54394 .23472 m .53835 .2664 L p .55481 .43428 L .707 .662 .803 r
F P
0 g
s
.54059 .42629 m .55299 .43175 L p .54688 .45365 L .877 .676 .628 r
F P
0 g
s
.53368 .50091 m .539 .44344 L p .54688 .45365 L .877 .676 .628 r
F P
0 g
s
.539 .44344 m .54059 .42629 L p .54688 .45365 L .877 .676 .628 r
F P
0 g
s
.54059 .42629 m .53368 .50091 L .51619 .49861 L p .734 .545 .637 r
F P
0 g
s
.51619 .49861 m .5233 .42395 L .54059 .42629 L p .734 .545 .637 r
F P
0 g
s
.53835 .2664 m .51306 .4098 L p .54898 .43349 L .707 .662 .803 r
F P
0 g
s
.50064 .50008 m .50789 .42567 L .5233 .42395 L p .575 .404 .613 r
F P
0 g
s
.5233 .42395 m .51619 .49861 L .50064 .50008 L p .575 .404 .613 r
F P
0 g
s
.51306 .4098 m .50981 .42821 L .52928 .43084 L p .707 .662 .803 r
F P
0 g
s
.52928 .43084 m .54898 .43349 L p .51306 .4098 L .707 .662 .803 r
F P
0 g
s
.55299 .43175 m .55575 .43819 L p .5513 .46995 L .974 .81 .392 r
F P
0 g
s
.55057 .45843 m .55299 .43175 L p .5513 .46995 L .974 .81 .392 r
F P
0 g
s
.55299 .43175 m .54624 .50607 L .53368 .50091 L p .877 .676 .628 r
F P
0 g
s
.54898 .43349 m .55481 .43428 L p .53835 .2664 L .707 .662 .803 r
F P
0 g
s
.54624 .50607 m .55057 .45843 L p .5513 .46995 L .974 .81 .392 r
F P
0 g
s
.85073 .57832 m .85331 .57853 L .74013 .58015 L closepath p .047 0 0 r
F P
0 g
s
.84923 .61044 m .84667 .61009 L .74013 .58015 L closepath p 0 .466 .757 r
F P
0 g
s
.67638 .53412 m .5765 .52104 L .57214 .53531 L p .644 .738 .917 r
F P
0 g
s
.50037 .43074 m .49309 .50471 L .49628 .51068 L p .985 .818 .425 r
F P
0 g
s
.49309 .50471 m .50037 .43074 L .50789 .42567 L p .173 .063 .479 r
F P
0 g
s
.69294 .53629 m .73698 .54205 L .74185 .54215 L p 0 .539 .751 r
F P
0 g
s
.68771 .61156 m .73223 .61723 L .72745 .61634 L p .117 0 0 r
F P
0 g
s
.72745 .61634 m .68339 .61073 L .68771 .61156 L p .117 0 0 r
F P
0 g
s
.74185 .54215 m .69736 .53633 L .69294 .53629 L p 0 .539 .751 r
F P
0 g
s
.85331 .57853 m .85463 .58481 L .74013 .58015 L closepath p .665 .331 .397 r
F P
0 g
s
.8521 .60461 m .84923 .61044 L .74013 .58015 L closepath p .602 .694 .908 r
F P
0 g
s
.5765 .52104 m .67638 .53412 L .68063 .53414 L p 0 .539 .751 r
F P
0 g
s
.56998 .59656 m .67097 .60943 L .66683 .60862 L p .117 0 0 r
F P
0 g
s
.66683 .60862 m .56688 .59588 L .56998 .59656 L p .117 0 0 r
F P
0 g
s
.50447 .56404 m .50562 .55213 L .5224 .5543 L p .734 .546 .639 r
F P
0 g
s
.5224 .5543 m .52128 .5662 L .50447 .56404 L p .734 .546 .639 r
F P
0 g
s
.02 w
.49876 .59091 m
.51081 .56486 L
s
.5 Mabswid
.52247 .54183 m .5224 .5543 L .50562 .55213 L p .725 .613 .732 r
F P
0 g
s
.52128 .5662 m .5224 .5543 L .53742 .55307 L p .579 .409 .616 r
F P
0 g
s
.5224 .5543 m .52247 .54183 L .53451 .54081 L p .591 .503 .723 r
F P
0 g
s
.53451 .54081 m .53742 .55307 L .5224 .5543 L p .591 .503 .723 r
F P
0 g
s
.50562 .55213 m .509 .54008 L .52247 .54183 L p .725 .613 .732 r
F P
0 g
s
.52147 .53118 m .52247 .54183 L .509 .54008 L p .7 .676 .823 r
F P
0 g
s
.01 w
.52023 .51782 m
.52197 .49937 L
s
.5 Mabswid
.52247 .54183 m .52147 .53118 L .52817 .5306 L p .591 .594 .823 r
F P
0 g
s
.52817 .5306 m .53451 .54081 L .52247 .54183 L p .591 .594 .823 r
F P
0 g
s
.49214 .55933 m .49331 .54737 L .50562 .55213 L p .872 .674 .632 r
F P
0 g
s
.50562 .55213 m .50447 .56404 L .49214 .55933 L p .872 .674 .632 r
F P
0 g
s
.509 .54008 m .50562 .55213 L .49331 .54737 L p .841 .738 .75 r
F P
0 g
s
.49331 .54737 m .49915 .53622 L .509 .54008 L p .841 .738 .75 r
F P
0 g
s
.51398 .53021 m .509 .54008 L .49915 .53622 L p .783 .783 .852 r
F P
0 g
s
.509 .54008 m .51398 .53021 L .52147 .53118 L p .7 .676 .823 r
F P
0 g
s
.5058 .57351 m .50447 .56404 L .52128 .5662 L p .726 .445 .501 r
F P
0 g
s
.52128 .5662 m .51933 .57524 L .5058 .57351 L p .726 .445 .501 r
F P
0 g
s
.51933 .57524 m .52128 .5662 L .53632 .56501 L p .543 .271 .452 r
F P
0 g
s
.53742 .55307 m .53632 .56501 L .52128 .5662 L p .579 .409 .616 r
F P
0 g
s
.85417 .5948 m .8521 .60461 L .74013 .58015 L closepath p .687 .612 .767 r
F P
0 g
s
.85463 .58481 m .85417 .5948 L .74013 .58015 L closepath p .703 .519 .636 r
F P
0 g
s
.03 w
.56141 .55707 m
.74013 .58015 L
s
.5 Mabswid
.49589 .56976 m .49214 .55933 L .50447 .56404 L p .875 .554 .439 r
F P
0 g
s
.50447 .56404 m .5058 .57351 L .49589 .56976 L p .875 .554 .439 r
F P
0 g
s
.50789 .42567 m .50064 .50008 L .49309 .50471 L p .173 .063 .479 r
F P
0 g
s
.53742 .55307 m .53451 .54081 L .5406 .53739 L p .31 .314 .702 r
F P
0 g
s
.03 w
.5475 .55527 m
.56141 .55707 L
s
.5 Mabswid
.53451 .54081 m .52817 .5306 L .53153 .52867 L p .391 .497 .847 r
F P
0 g
s
.53153 .52867 m .5406 .53739 L .53451 .54081 L p .391 .497 .847 r
F P
0 g
s
.53632 .56501 m .53742 .55307 L .54504 .54888 L p .2 .088 .494 r
F P
0 g
s
.5406 .53739 m .54504 .54888 L .53742 .55307 L p .31 .314 .702 r
F P
0 g
s
.52147 .53118 m .51398 .53021 L p .53153 .52867 L .49 .777 .995 r
F P
0 g
s
.53153 .52867 m .52817 .5306 L .52147 .53118 L p .49 .777 .995 r
F P
0 g
s
.51398 .53021 m .50852 .52804 L p .53153 .52867 L .49 .777 .995 r
F P
0 g
s
.49915 .53622 m .50852 .52804 L .51398 .53021 L p .783 .783 .852 r
F P
0 g
s
.68063 .53414 m .5797 .52093 L .5765 .52104 L p 0 .539 .751 r
F P
0 g
s
.49016 .54178 m .49666 .53168 L .49915 .53622 L p .95 .945 .736 r
F P
0 g
s
.49915 .53622 m .49331 .54737 L .49016 .54178 L p .95 .945 .736 r
F P
0 g
s
.50852 .52804 m .49915 .53622 L .49666 .53168 L p .822 .944 .904 r
F P
0 g
s
.53632 .56501 m .53143 .57432 L .51933 .57524 L p .543 .271 .452 r
F P
0 g
s
.53143 .57432 m .53632 .56501 L .54395 .56089 L p .013 0 .119 r
F P
0 g
s
.54504 .54888 m .54395 .56089 L .53632 .56501 L p .2 .088 .494 r
F P
0 g
s
.50937 .57868 m .5058 .57351 L .51933 .57524 L p .643 .191 .164 r
F P
0 g
s
.51933 .57524 m .51692 .57964 L .50937 .57868 L p .643 .191 .164 r
F P
0 g
s
.51692 .57964 m .51933 .57524 L .53143 .57432 L p .399 0 .048 r
F P
0 g
s
.48898 .55381 m .49016 .54178 L .49331 .54737 L p .985 .818 .424 r
F P
0 g
s
.49331 .54737 m .49214 .55933 L .48898 .55381 L p .985 .818 .424 r
F P
0 g
s
.50852 .52804 m .50717 .5255 L p .53153 .52867 L .49 .777 .995 r
F P
0 g
s
.49666 .53168 m .50717 .5255 L .50852 .52804 L p .822 .944 .904 r
F P
0 g
s
.50386 .5766 m .49589 .56976 L .5058 .57351 L p .727 .205 0 r
F P
0 g
s
.5058 .57351 m .50937 .57868 L .50386 .5766 L p .727 .205 0 r
F P
0 g
s
.51077 .68013 m .51793 .60352 L .5006 .60132 L p .734 .546 .639 r
F P
0 g
s
.51793 .60352 m .51077 .68013 L .5264 .6793 L p .579 .409 .616 r
F P
0 g
s
.01 w
.51129 .61256 m
.51387 .58518 L
s
.5 Mabswid
.5264 .6793 m .53343 .60243 L .51793 .60352 L p .579 .409 .616 r
F P
0 g
s
.49337 .56538 m .48898 .55381 L .49214 .55933 L p .779 .428 0 r
F P
0 g
s
.49214 .55933 m .49589 .56976 L .49337 .56538 L p .779 .428 0 r
F P
0 g
s
.69736 .53633 m .74185 .54215 L .74401 .5567 L p .706 .355 .379 r
F P
0 g
s
.69313 .59775 m .73801 .6035 L .73223 .61723 L p .638 .743 .925 r
F P
0 g
s
.73223 .61723 m .68771 .61156 L .69313 .59775 L p .638 .743 .925 r
F P
0 g
s
.49324 .67797 m .5006 .60132 L .48787 .59664 L p .872 .674 .632 r
F P
0 g
s
.5006 .60132 m .49324 .67797 L .51077 .68013 L p .734 .546 .639 r
F P
0 g
s
.52478 .52394 m .53024 .52613 L .53153 .52867 L p .49 .777 .995 r
F P
0 g
s
.51721 .52295 m .52478 .52394 L p .53153 .52867 L .49 .777 .995 r
F P
0 g
s
.51048 .52355 m .51721 .52295 L p .53153 .52867 L .49 .777 .995 r
F P
0 g
s
.01 w
.51971 .52328 m
.52023 .51782 L
s
.5 Mabswid
.50717 .5255 m .51048 .52355 L p .53153 .52867 L .49 .777 .995 r
F P
0 g
s
.5406 .53739 m .53153 .52867 L .53024 .52613 L p 0 .233 .742 r
F P
0 g
s
.53143 .57432 m .52365 .57913 L .51692 .57964 L p .399 0 .048 r
F P
0 g
s
.52365 .57913 m .53143 .57432 L .53753 .57105 L p 0 0 0 r
F P
0 g
s
.54395 .56089 m .53753 .57105 L .53143 .57432 L p .013 0 .119 r
F P
0 g
s
.53024 .52613 m .53833 .53284 L .5406 .53739 L p 0 .233 .742 r
F P
0 g
s
.54504 .54888 m .5406 .53739 L .53833 .53284 L p .734 .388 0 r
F P
0 g
s
.5026 .52819 m .51048 .52355 L .50717 .5255 L p 0 0 0 r
F P
0 g
s
.50717 .5255 m .49666 .53168 L .5026 .52819 L p 0 0 0 r
F P
0 g
s
.74401 .5567 m .69914 .55086 L .69736 .53633 L p .706 .355 .379 r
F P
0 g
s
.50249 .57419 m .49337 .56538 L .49589 .56976 L p 0 .196 .709 r
F P
0 g
s
.49589 .56976 m .50386 .5766 L .50249 .57419 L p 0 .196 .709 r
F P
0 g
s
.54395 .56089 m .54504 .54888 L .54223 .54327 L p .974 .81 .393 r
F P
0 g
s
.03 w
.54449 .55488 m
.5475 .55527 L
s
.5 Mabswid
.53833 .53284 m .54223 .54327 L .54504 .54888 L p .734 .388 0 r
F P
0 g
s
.55481 .43428 m .59072 .24145 L .54394 .23472 L p .707 .662 .803 r
F P
0 g
s
.5797 .52093 m .68063 .53414 L .68227 .54866 L p .706 .355 .379 r
F P
0 g
s
.57441 .58255 m .67625 .59559 L .67097 .60943 L p .638 .743 .925 r
F P
0 g
s
.67097 .60943 m .56998 .59656 L .57441 .58255 L p .638 .743 .925 r
F P
0 g
s
.53343 .60243 m .5264 .6793 L .53429 .67577 L p .2 .089 .494 r
F P
0 g
s
.53429 .67577 m .54127 .59843 L .53343 .60243 L p .2 .089 .494 r
F P
0 g
s
.51692 .57964 m .52365 .57913 L p .52571 .57492 L .472 .777 .997 r
F P
0 g
s
.50937 .57868 m .51692 .57964 L p .52571 .57492 L .472 .777 .997 r
F P
0 g
s
.49754 .53748 m .5026 .52819 L .49666 .53168 L p 0 0 .079 r
F P
0 g
s
.49666 .53168 m .49016 .54178 L .49754 .53748 L p 0 0 .079 r
F P
0 g
s
.50386 .5766 m .50937 .57868 L p .52571 .57492 L .472 .777 .997 r
F P
0 g
s
.53833 .53284 m .53024 .52613 L .52478 .52394 L p .708 .175 0 r
F P
0 g
s
.37457 .53302 m .37343 .54302 L .48886 .5477 L closepath p .703 .518 .635 r
F P
0 g
s
.376 .52303 m .37457 .53302 L .48886 .5477 L closepath p .686 .613 .768 r
F P
0 g
s
.53753 .57105 m .54395 .56089 L .54113 .55536 L p .95 .952 .726 r
F P
0 g
s
.54223 .54327 m .54113 .55536 L .54395 .56089 L p .974 .81 .393 r
F P
0 g
s
.51477 .52712 m .51721 .52295 L .51048 .52355 L p .375 0 .009 r
F P
0 g
s
.51048 .52355 m .5026 .52819 L .51477 .52712 L p .375 0 .009 r
F P
0 g
s
.53753 .57105 m .52702 .57733 L .52365 .57913 L p 0 0 0 r
F P
0 g
s
.52365 .57913 m .52702 .57733 L .52571 .57492 L p .472 .777 .997 r
F P
0 g
s
.48033 .67362 m .48787 .59664 L .48458 .59122 L p .985 .818 .425 r
F P
0 g
s
.48787 .59664 m .48033 .67362 L .49324 .67797 L p .872 .674 .632 r
F P
0 g
s
.49636 .54958 m .49754 .53748 L .49016 .54178 L p .174 .064 .479 r
F P
0 g
s
.03 w
.49645 .54868 m
.54121 .55446 L
s
.5 Mabswid
.49016 .54178 m .48898 .55381 L .49636 .54958 L p .174 .064 .479 r
F P
0 g
s
.37717 .5168 m .376 .52303 L .48886 .5477 L closepath p .598 .696 .912 r
F P
0 g
s
.37343 .54302 m .37299 .54926 L .48886 .5477 L closepath p .663 .324 .389 r
F P
0 g
s
.50249 .57419 m .50386 .5766 L p .52571 .57492 L .472 .777 .997 r
F P
0 g
s
.01 w
.51387 .58518 m
.51476 .57576 L
s
.5 Mabswid
.52478 .52394 m .52846 .5289 L .53833 .53284 L p .708 .175 0 r
F P
0 g
s
.52846 .5289 m .52478 .52394 L .51721 .52295 L p .633 .169 .133 r
F P
0 g
s
.37764 .51673 m .37717 .5168 L .48886 .5477 L closepath p 0 .438 .723 r
F P
0 g
s
.37722 .52292 m .37764 .51673 L .48886 .5477 L closepath p .751 .398 .385 r
F P
0 g
s
.37606 .53304 m .37722 .52292 L .48886 .5477 L closepath p .764 .573 .639 r
F P
0 g
s
.37461 .54315 m .37606 .53304 L .48886 .5477 L closepath p .746 .67 .776 r
F P
0 g
s
.37299 .54926 m .37344 .54934 L .48886 .5477 L closepath p .01 0 0 r
F P
0 g
s
.37344 .54934 m .37461 .54315 L .48886 .5477 L closepath p .683 .783 .926 r
F P
0 g
s
.03 w
.48886 .5477 m
.48957 .54779 L
s
.5 Mabswid
.52702 .57733 m .53753 .57105 L .53523 .56667 L p .82 .953 .905 r
F P
0 g
s
.54113 .55536 m .53523 .56667 L .53753 .57105 L p .95 .952 .726 r
F P
0 g
s
.51721 .52295 m .51477 .52712 L .52846 .5289 L p .633 .169 .133 r
F P
0 g
s
.01 w
.51487 .57458 m
.5193 .52771 L
s
.5 Mabswid
.49932 .56205 m .49636 .54958 L .48898 .55381 L p .291 .301 .698 r
F P
0 g
s
.48898 .55381 m .49337 .56538 L .49932 .56205 L p .291 .301 .698 r
F P
0 g
s
.54223 .54327 m .53833 .53284 L .52846 .5289 L p .879 .551 .426 r
F P
0 g
s
.68227 .54866 m .58047 .5354 L .5797 .52093 L p .706 .355 .379 r
F P
0 g
s
.53523 .56667 m .52571 .57492 L .52702 .57733 L p .82 .953 .905 r
F P
0 g
s
.50581 .57237 m .49932 .56205 L .49337 .56538 L p .375 .491 .849 r
F P
0 g
s
.49337 .56538 m .50249 .57419 L .50581 .57237 L p .375 .491 .849 r
F P
0 g
s
.51276 .53617 m .51477 .52712 L .5026 .52819 L p .536 .259 .442 r
F P
0 g
s
.5026 .52819 m .49754 .53748 L .51276 .53617 L p .536 .259 .442 r
F P
0 g
s
.69914 .55086 m .74401 .5567 L .74255 .58026 L p .734 .545 .636 r
F P
0 g
s
.69753 .57444 m .74255 .58026 L .73801 .6035 L p .717 .643 .774 r
F P
0 g
s
.73801 .6035 m .69313 .59775 L .69753 .57444 L p .717 .643 .774 r
F P
0 g
s
.50581 .57237 m .50249 .57419 L p .52571 .57492 L .472 .777 .997 r
F P
0 g
s
.54113 .55536 m .54223 .54327 L .5299 .53839 L p .877 .676 .628 r
F P
0 g
s
.52846 .5289 m .5299 .53839 L .54223 .54327 L p .879 .551 .426 r
F P
0 g
s
.54127 .59843 m .53429 .67577 L .53128 .67083 L p .974 .81 .392 r
F P
0 g
s
.53128 .67083 m .53835 .59299 L .54127 .59843 L p .974 .81 .392 r
F P
0 g
s
.74255 .58026 m .69753 .57444 L .69914 .55086 L p .734 .545 .636 r
F P
0 g
s
.5299 .53839 m .52846 .5289 L .51477 .52712 L p .726 .441 .494 r
F P
0 g
s
.51258 .57184 m .50581 .57237 L p .52571 .57492 L .472 .777 .997 r
F P
0 g
s
.52571 .57492 m .5202 .57282 L .51258 .57184 L p .472 .777 .997 r
F P
0 g
s
.52571 .57492 m .53523 .56667 L .5253 .56284 L p .785 .789 .856 r
F P
0 g
s
.5253 .56284 m .5202 .57282 L .52571 .57492 L p .785 .789 .856 r
F P
0 g
s
.53523 .56667 m .54113 .55536 L .52877 .55053 L p .844 .742 .751 r
F P
0 g
s
.5299 .53839 m .52877 .55053 L .54113 .55536 L p .877 .676 .628 r
F P
0 g
s
.51477 .52712 m .51276 .53617 L .5299 .53839 L p .726 .441 .494 r
F P
0 g
s
.58047 .5354 m .68227 .54866 L .68059 .57226 L p .734 .545 .636 r
F P
0 g
s
.57845 .55906 m .68059 .57226 L .67625 .59559 L p .717 .643 .774 r
F P
0 g
s
.67625 .59559 m .57441 .58255 L .57845 .55906 L p .717 .643 .774 r
F P
0 g
s
.5116 .54831 m .51276 .53617 L .49754 .53748 L p .575 .404 .613 r
F P
0 g
s
.49754 .53748 m .49636 .54958 L .5116 .54831 L p .575 .404 .613 r
F P
0 g
s
.49932 .56205 m .50581 .57237 L .51258 .57184 L p .587 .593 .826 r
F P
0 g
s
.52877 .55053 m .5253 .56284 L .53523 .56667 L p .844 .742 .751 r
F P
0 g
s
.74273 .55491 m .79476 .48769 L .75082 .50567 L p .625 .956 .914 r
F P
0 g
s
.75082 .50567 m .70226 .5717 L .74273 .55491 L p .625 .956 .914 r
F P
0 g
s
.48458 .59122 m .47695 .66869 L .48033 .67362 L p .985 .818 .425 r
F P
0 g
s
.47695 .66869 m .48458 .59122 L .49217 .5871 L p .173 .063 .479 r
F P
0 g
s
.5202 .57282 m .5253 .56284 L .51154 .56107 L p .7 .679 .826 r
F P
0 g
s
.51154 .56107 m .51258 .57184 L .5202 .57282 L p .7 .679 .826 r
F P
0 g
s
.51258 .57184 m .51154 .56107 L .49932 .56205 L p .587 .593 .826 r
F P
0 g
s
.51154 .56107 m .5116 .54831 L .49636 .54958 L p .588 .501 .723 r
F P
0 g
s
.49636 .54958 m .49932 .56205 L .51154 .56107 L p .588 .501 .723 r
F P
0 g
s
.52877 .55053 m .5299 .53839 L .51276 .53617 L p .734 .545 .637 r
F P
0 g
s
.68059 .57226 m .57845 .55906 L .58047 .5354 L p .734 .545 .636 r
F P
0 g
s
.51276 .53617 m .5116 .54831 L .52877 .55053 L p .734 .545 .637 r
F P
0 g
s
.02 w
.51345 .55916 m
.51808 .54915 L
s
.52076 .54335 m
.52216 .54033 L
s
.5 Mabswid
.5253 .56284 m .52877 .55053 L .5116 .54831 L p .725 .614 .733 r
F P
0 g
s
.5116 .54831 m .51154 .56107 L .5253 .56284 L p .725 .614 .733 r
F P
0 g
s
.53835 .59299 m .53128 .67083 L .51834 .66638 L p .877 .676 .628 r
F P
0 g
s
.51834 .66638 m .52559 .58819 L .53835 .59299 L p .877 .676 .628 r
F P
0 g
s
.64522 .54254 m .67471 .4957 L .63546 .51157 L p .647 .96 .927 r
F P
0 g
s
.63546 .51157 m .60818 .55768 L .64522 .54254 L p .647 .96 .927 r
F P
0 g
s
.48457 .66505 m .49217 .5871 L .50787 .58593 L p .575 .404 .613 r
F P
0 g
s
.49217 .5871 m .48457 .66505 L .47695 .66869 L p .173 .063 .479 r
F P
0 g
s
.53796 .4836 m .52606 .51007 L .54237 .51748 L p .362 .629 .955 r
F P
0 g
s
.54237 .51748 m .55483 .49126 L .53796 .4836 L p .362 .629 .955 r
F P
0 g
s
.55483 .49126 m .54237 .51748 L .55151 .5325 L p .049 .234 .732 r
F P
0 g
s
.52007 .48667 m .50875 .51308 L .52606 .51007 L p .608 .9 .987 r
F P
0 g
s
.52606 .51007 m .53796 .4836 L .52007 .48667 L p .608 .9 .987 r
F P
0 g
s
.55151 .5325 m .5643 .50676 L .55483 .49126 L p .049 .234 .732 r
F P
0 g
s
.5643 .50676 m .55151 .5325 L .54999 .54947 L p 0 0 .175 r
F P
0 g
s
.50795 .49935 m .497 .5254 L .50875 .51308 L p .745 .966 .688 r
F P
0 g
s
.50875 .51308 m .52007 .48667 L .50795 .49935 L p .745 .966 .688 r
F P
0 g
s
.52559 .58819 m .51834 .66638 L .50042 .66415 L p .734 .545 .637 r
F P
0 g
s
.01 w
.50881 .63884 m
.51129 .61256 L
s
.5 Mabswid
.50042 .66415 m .50787 .58593 L .52559 .58819 L p .734 .545 .637 r
F P
0 g
s
.50787 .58593 m .50042 .66415 L .48457 .66505 L p .575 .404 .613 r
F P
0 g
s
.01 w
.50141 .71723 m
.50635 .66489 L
s
.5 Mabswid
.54999 .54947 m .56276 .52424 L .5643 .50676 L p 0 0 .175 r
F P
0 g
s
.56276 .52424 m .54999 .54947 L .53832 .56191 L p .71 .946 .651 r
F P
0 g
s
.50626 .51685 m .49534 .54239 L .497 .5254 L p 0 0 .125 r
F P
0 g
s
.497 .5254 m .50795 .49935 L .50626 .51685 L p 0 0 .125 r
F P
0 g
s
.53832 .56191 m .55072 .53704 L .56276 .52424 L p .71 .946 .651 r
F P
0 g
s
.55072 .53704 m .53832 .56191 L .52091 .56501 L p .59 .902 .984 r
F P
0 g
s
.02 w
.52216 .54033 m
.52447 .53532 L
s
.5 Mabswid
.51573 .53249 m .50447 .55755 L .49534 .54239 L p .008 .209 .72 r
F P
0 g
s
.49534 .54239 m .50626 .51685 L .51573 .53249 L p .008 .209 .72 r
F P
0 g
s
.52091 .56501 m .53273 .54022 L .55072 .53704 L p .59 .902 .984 r
F P
0 g
s
.53273 .54022 m .52091 .56501 L .50447 .55755 L p .338 .623 .956 r
F P
0 g
s
.50447 .55755 m .51573 .53249 L .53273 .54022 L p .338 .623 .956 r
F P
0 g
s
.02 w
.52447 .53532 m
.53536 .51179 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00W03oool400000800oooo002L0?ooo`040000002dZLd0]:W=0;BYc@H0
0000NP3oool009`0oooo00<000000;BYc@2dZLd01`2dZLd4000007H0oooo002K0?ooo`030000002d
ZLd0]:W=00/0]:W=00<000000?ooo`3oool0M03oool009/0oooo00<000000;BYc@2dZLd02`2dZLd0
0`000000oooo0?ooo`1d0?ooo`00V`3oool00`000000]:W=0;BYc@0:0;BYc@030000003oool0oooo
07D0oooo002K0?ooo`030000002dZLd0]:W=00X0]:W=00<000000?ooo`3oool0M@3oool009X0oooo
00<000000;BYc@2dZLd02`2dZLd00`000000oooo0?ooo`1e0?ooo`00VP3oool00`000000]:W=0;BY
c@0;0;BYc@030000003oool0oooo07D0oooo002J0?ooo`030000002dZLd0]:W=00/0]:W=00<00000
0?ooo`3oool0M@3oool009X0oooo00<000000;BYc@2dZLd02`2dZLd00`000000oooo0?ooo`1e0?oo
o`00VP3oool00`000000]:W=0;BYc@0:0;BYc@030000003oool0oooo07H0oooo002I0?ooo`030000
002dZLd0]:W=00/0]:W=00<000000?ooo`3oool0MP3oool009T0oooo00<000000;BYc@2dZLd02`2d
ZLd00`000000oooo0?ooo`1f0?ooo`00V@3oool00`000000]:W=0;BYc@0;0;BYc@030000003oool0
oooo07H0oooo002I0?ooo`030000002dZLd0]:W=00/0]:W=00<000000?ooo`3oool0MP3oool009T0
oooo00<000000;BYc@2dZLd02P2dZLd00`000000oooo0?ooo`1g0?ooo`00V@3oool00`000000]:W=
0;BYc@0:0;BYc@030000003oool0oooo07L0oooo002H0?ooo`030000002dZLd0]:W=00/0]:W=00<0
00000?ooo`3oool0M`3oool009P0oooo00<000000;BYc@2dZLd02`2dZLd00`000000oooo0?ooo`1g
0?ooo`00V03oool00`000000]:W=0;BYc@0;0;BYc@030000003oool0oooo07L0oooo002H0?ooo`03
0000002dZLd0]:W=00/0]:W=00<000000?ooo`3oool0M`3oool009P0oooo00<000000;BYc@2dZLd0
2P2dZLd00`000000oooo0?ooo`1h0?ooo`00V03oool00`000000]:W=0;BYc@0:0;BYc@030000003o
ool0oooo07P0oooo002G0?ooo`030000002dZLd0]:W=00/0]:W=00<000000?ooo`3oool0N03oool0
09L0oooo00<000000;BYc@2dZLd02`2dZLd00`000000oooo0?ooo`1h0?ooo`00U`3oool00`000000
]:W=0;BYc@0;0;BYc@030000003oool0oooo07P0oooo002G0?ooo`030000002dZLd0]:W=00X0]:W=
00<000000?ooo`3oool0N@3oool009L0oooo00<000000;BYc@2dZLd02P2dZLd00`000000oooo0?oo
o`1i0?ooo`00U`3oool00`000000]:W=0;BYc@0:0;BYc@030000003oool0oooo07T0oooo002F0?oo
o`030000002dZLd0]:W=00/0]:W=00<000000?ooo`3oool0N@3oool009H0oooo00<000000;BYc@2d
ZLd02`2dZLd00`000000oooo0?ooo`1i0?ooo`00UP3oool00`000000]:W=0;BYc@0;0;BYc@030000
003oool0oooo07T0oooo002F0?ooo`030000002dZLd0]:W=00X0]:W=00<000000?ooo`3oool0NP3o
ool009H0oooo00<000000;BYc@2dZLd02P2dZLd00`000000oooo0?ooo`1j0?ooo`00UP3oool00`00
0000]:W=0;BYc@0:0;BYc@030000003oool0oooo07X0oooo002E0?ooo`030000002dZLd0]:W=00/0
]:W=00<000000?ooo`3oool0NP3oool009D0oooo00<000000;BYc@2dZLd02`2dZLd00`000000oooo
0?ooo`1j0?ooo`00U@3oool00`000000]:W=0;BYc@0:0;BYc@030000003oool0oooo07/0oooo002E
0?ooo`030000002dZLd0]:W=00X0]:W=00<000000?ooo`3oool0N`3oool008h0oooo0`0000040?oo
o`030000002dZLd0]:W=00X0]:W=00<000000?ooo`3oool0N`3oool008h0oooo00<000000:Xn>`2Z
?S/01@00000<0;BYc@030000003oool0oooo07/0oooo002>0?ooo`030000002Z?S/0ZShk00<0ZShk
00<000000;BYc@2dZLd02`2dZLd00`000000oooo0?ooo`1k0?ooo`00SP3oool00`000000ZShk0:Xn
>`030:Xn>`030000002dZLd0]:W=00/0]:W=00<000000?ooo`3oool0N`3oool008h0oooo00<00000
0:Xn>`2Z?S/00`2Z?S/00`000000]:W=0;BYc@0:0;BYc@030000003oool0oooo07`0oooo002>0?oo
o`030000002Z?S/0ZShk00<0ZShk00<000000;BYc@2dZLd02P2dZLd00`000000oooo0?ooo`1l0?oo
o`00SP3oool00`000000ZShk0:Xn>`030:Xn>`030000002dZLd0]:W=00X0]:W=00<000000?ooo`3o
ool0O03oool008h0oooo00<000000:Xn>`2Z?S/00`2Z?S/00`000000]:W=0;BYc@0:0;BYc@030000
003oool0oooo07`0oooo002>0?ooo`030000002Z?S/0ZShk0080ZShk00<000000;BYc@2dZLd02`2d
ZLd00`000000oooo0?ooo`1l0?ooo`00SP3oool00`000000ZShk0:Xn>`020:Xn>`030000002dZLd0
]:W=00X0]:W=00<000000?ooo`3oool0O@3oool008h0oooo00<000000:Xn>`2Z?S/00P2Z?S/00`00
0000]:W=0;BYc@0:0;BYc@030000003oool0oooo07d0oooo002>0?ooo`030000002Z?S/0ZShk0080
ZShk00<000000;BYc@2dZLd02P2dZLd00`000000oooo0?ooo`1m0?ooo`00S`3oool01@000000ZShk
0:Xn>`2Z?S/0000000`0]:W=00<000000?ooo`3oool0O@3oool008l0oooo00@000000:Xn>`2Z?S/0
00003@2dZLd00`000000oooo0?ooo`1m0?ooo`00S`3oool010000000ZShk0:Xn>`00000=0;BYc@03
0000003oool0oooo07d0oooo002?0?ooo`H000002P2dZLd00`000000oooo0?ooo`1n0?ooo`00S`3o
ool00`000000;11j0000000309=WW0D000001@2dZLd00`000000oooo0?ooo`1n0?ooo`00S`3oool0
0`000000;11j0000000409=WW0040000002kRj<0^h^S0;^;X`H00000P03oool008l0oooo00<00000
02`@NP000000102CIi`00`000000^h^S0;^;X`020;^;X`030000003P[J00h:fP00800000P03oool0
08l0oooo00<0000002`@NP000000102CIi`00`000000^h^S0;^;X`020;^;X`030000003P[J00h:fP
00800000P03oool008l0oooo00<0000002`@NP0000000`2CIi`00`000000^h^S0;^;X`030;^;X`03
0000003P[J00h:fP00800000P03oool008l0oooo0P00000409=WW0030000002kRj<0^h^S0080^h^S
00@000000>2]X03P[J00h:fP0P0000200?ooo`00SP3oool00`000000;11j0000000409=WW0030000
002kRj<0^h^S0080^h^S00<000000>2]X03P[J000`0000200?ooo`00SP3oool00`000000;11j0000
000409=WW0030000002kRj<0^h^S0080^h^S00<000000>2]X02DJ9d00`0000200?ooo`00SP3oool0
0`000000;11j0000000409=WW0030000002kRj<0^h^S0080^h^S00<000000>2]X03P[J000P000021
0?ooo`00SP3oool00`000000;11j0000000409=WW0030000002kRj<0^h^S0080^h^S00<000000>2]
X03P[J000P0000210?ooo`00SP3oool00`000000;11j0000000409=WW0030000002kRj<0^h^S0080
^h^S00<000000>2]X03P[J000P0000210?ooo`00SP3oool00`000000;11j0000000409=WW0030000
002kRj<0^h^S0080^h^S00<000000>2]X03P[J000P0000210?ooo`00SP3oool00`000000;11j0000
000409=WW0030000002kRj<0^h^S0080^h^S00<000000>2]X03P[J000P0000210?ooo`00SP3oool0
0`000000;11j0000000409=WW0030000002kRj<0^h^S0080^h^S00<000000>2]X03P[J000P000021
0?ooo`00SP3oool00`000000;11j0000000409=WW0030000002kRj<0^h^S0080^h^S00<000000>2]
X03P[J000P0000210?ooo`00SP3oool2000000@0TfNL00@000000;^;X`2kRj<0^h^S0`0000020>2]
X0800000P@3oool008d0oooo00<0000002`@NP000000102CIi`400000080VnKl1@0000140?ooo`80
0000>`3oool008d0oooo00<0000002`@NP000000102CIi`2000000<0VnKl00@0000005bQm01LXO@0
G:7d0P0000120?ooo`<00000?03oool008d0oooo00<0000002`@NP0000000`2CIi`2000000@0VnKl
00<0000005bQm01LXO@00`1LXO@00`000000oooo0?ooo`0m0?ooo`8000000P2Om>T00`000000oooo
0?ooo`0j0?ooo`00S@3oool00`000000;11j0000000209=WW0030000002nmk00000000<0VnKl00<0
000005bQm01LXO@00`1LXO@200000200oooo0P00000K0?ooo`8000000`2Om>T00`000000oooo0?oo
o`0k0?ooo`00S@3oool500000080__N`00D0000009_Vo02Ki_`0VnKl0000000505bQm0030000000<
>k/0000001`0oooo1000000J0?ooo`800000102Om>T00`000000oooo0?ooo`0l0?ooo`00S@3oool0
1`000000o=5/0=n/X@3O[:4000000;kg/00000000`2Ki_`400000080G:7d00@0000000`k^`0<>k/0
00006P3oool2000000<0YOG]00<000000?ooo`3oool05P3oool2000000D0WoCY00<000000?ooo`3o
ool0?@3oool008d0oooo00<000000?cAK03O[:400P0000000`2nmk00000009_Vo00209_Vo0L00000
0`0<>k/00`000000oooo0?ooo`0D0?ooo`<00000102UmNd00`000000oooo0?ooo`0E0?ooo`800000
1`2Om>T00`000000oooo0?ooo`0m0?ooo`00SP3oool00`000000gjbQ000000020000000309_Vo000
0000000000L00000100<>k/00`000000oooo0?ooo`0B0?ooo`8000001`2UmNd00`000000oooo0?oo
o`0D0?ooo`030000002Om>T0WoCY00H0WoCY00<000000?ooo`3oool0?P3oool008l0oooo00<00000
00007`0000002`00000300`k^`8000004`3oool00`000000YOG]0:Gek@060:Gek@030000003oool0
oooo01D0oooo00<0000009odj@2Om>T01@2Om>T00`000000oooo0?ooo`0o0?ooo`00K03oool20000
0240oooo00<0000000007`0000002P00000400`k^`030000;0000000oooo0180oooo00<000000:Ge
k@2UmNd01@2UmNd00`000000oooo0?ooo`0E0?ooo`030000002Om>T0WoCY00D0WoCY00<000000?oo
o`3oool0@03oool006`0oooo00<000000<1UHP0000000`00000L0?ooo`030000000001l0000O0080
000000<0oooo0000000000001@0000001`3oool0000000`k^`0<>k/000000000;00000000`3oool5
000000X0oooo00<000000:Gek@2UmNd01P2UmNd00`000000oooo0?ooo`0D0?ooo`030000002Om>T0
WoCY00H0WoCY00<000000?ooo`3oool0@03oool006/0oooo100000030<1UHP<000006@3oool01000
0000000O00000002=KP9000000070?ooo`00000033^k00`k^`000000000/000000030?ooo`800000
0`2dFV47000000<0oooo00<000000:Gek@2UmNd01@2UmNd00`000000oooo0?ooo`0D0?ooo`030000
002Om>T0WoCY00H0WoCY00<000000?ooo`3oool0@@3oool006/0oooo0P0000020<>BX`@000000P30
IF84000001D0oooo00<0000000007`0000000P02=KP7000000<0oooo0P0000000`0002`000000?oo
o`030?ooo`8000002P2dFV43000000L0YOG]00<000000?ooo`3oool05@3oool00`000000WoCY09od
j@0509odj@030000003oool0oooo0480oooo001[0?ooo`@000001033TZ<5000000040<1UHP000000
000000000180oooo0P000004008e^0L000000`3oool00`000000000/000000030?ooo`030000002T
_>X0000000`0]5YQ00<000000:Gek@2UmNd01@2UmNd500000180oooo00<0000009odj@2Om>T01@2O
m>T00`000000oooo0?ooo`130?ooo`00J`3oool010000000_Z_60;j[aP2nZlH6000000<0`i:S2000
000;0?ooo`D000001002=KP5000000030>6=K@000000oooo0080oooo0P0000040?ooo`030000002T
_>X0000000<00000202dFV400`000000YOG]0:Gek@050:Gek@030000002dFV40]5YQ00<0]5YQ1000
00020?ooo`D000001P3oool00`000000WoCY09odj@0609odj@030000003oool0oooo04<0oooo001[
0?ooo`030000002nZlH0_Z_600L0_Z_63`0000040?ooo`L000001002=KP7000000030>6=K@000000
000000<00000103oool00`000000]j?5000000030;^;XPP00000202UmNd00`000000]5YQ0;AJH@06
0;AJH@060000003oool0oooo0000002T_>X000000P2dFV46000000P0WoCY00<000000?ooo`3oool0
A03oool006/0oooo2@0000080;j[aP/0000000<0oooo0000000000001@000004008e^0030000001F
Wo@0000000D000000P2Gi_/500000080oooo00<000000;NSa@0000002P2kRj800`000000YOG]0:Ge
k@040:Gek@8000002@2dFV401P000000oooo0?ooo`000000Y;cZ000000L0]5YQ00<0000009odj@2O
m>T01@2Om>T00`000000oooo0?ooo`150?ooo`00J`3oool00`000000[/S]0:k8k@060:k8kA/00000
0`02=KP00`000000EYod05JOm00205JOm0800000102Gi_/:000000T0^h^R00<000000:Gek@2UmNd0
0`2UmNd2000000030;^;XP000000000000D000000`2dFV400`000000oooo000000020:BljP030000
002dFV40]5YQ00@0]5YQ00<0000009odj@2Om>T01@2Om>T00`000000oooo0?ooo`160?ooo`00J`3o
oolU000000800SFh00<0000005JOm01FWo@00P1FWo@00`000000UnKk09OVn`0209OVn`/000002@2k
Rj8010000000YOG]0:Gek@2UmNd2000000X0^h^R100000000`3oool0000000000002000000D0]5YQ
00<0000009odj@2Om>T01P2Om>T00`000000oooo0?ooo`160?ooo`00R03oool50000000504Y=/P00
00000000008e^00000001@1FWo@00`000000UnKk09OVn`0209OVn`/00000202kRj800`000000YOG]
0:Gek@02000000l0^h^R00<000000?ooo`0000000P2gXlD6000000P0WoCY00<000000?ooo`3oool0
A`3oool008P0oooo1@0000000`1:CK80000009J0^@02000000@0EYod00<0000009OVn`2Gi_/00P2G
i_/<000000P0^h^R0`00000A0;^;XP030000003oool000000080]j?500<000000;^;XP2kRj800P2k
Rj800`000000WoCY09odj@0409odj@800000BP3oool008P0oooo1@00000204Y=/P<00000101FWo@0
0`000000UnKk09OVn`0209OVn`l00000102kRj82000001<0^h^R0`0000020;NSa@050000002kRj80
^h^R0;^;XP0000001@2Om>T2000000030;^;XP000000oooo04T0oooo00280?ooo``0000000@0EYod
0000002Gi_/0UnKk3`0000030;NTaPL000004P2kRj8600000080^h^R00@0000009odj@2Om>T0WoCY
0`0000030;^;XP030000003oool0oooo04P0oooo00290?ooo`<0000000H0VnKl0000001OOMT0GggI
0000002FUm<8000000030??c^@000000000000T000002`2gY<H8000000X0^h^R1P000000102kRj80
000009odj@2Om>T2000000H0^h^R00<000000?ooo`3oool0B03oool008T0oooo0`00000209_Vo0<0
00000P2FUm<00`000000/jgC000000020<S9f`030000003AlnL0000000/000004`2gY<H7000000<0
^h^R1P000000102kRj8000000000000000080;^;XP@00000A`3oool008P0oooo00@0000000007`00
0000VnKl2P0000001038bM/000000000000000080?ooo`040000002kRj<0^h^S000001X0]jC63000
00090;^;XP@00000A`3oool008P0oooo00@0000000007`00000000000P3oool30000000307S6o`00
000000000080N<Ko0P0000000`0002`000000?ooo`070?ooo`040000002kRj<0^h^S000001d0]jC6
1P0000030;NTaPH000000`2kRj84000000/0oooo4@00000[0?ooo`00R03oool200000004008e^000
0000oooo0?ooo`X0000000<0000/0000003oool01`3oool3000001h0]jC61@00000:0;NTaR<00000
:`3oool008L0oooo00D0000000007`0000000SFh000000020?ooo`L0000000<033^k0000000002`0
0P0000080?ooo`030000002eGVD0000000@000006P2gY<H5000000d0]jC6300000040;>4XQ400000
:P3oool008L0oooo0P000003008e^0d000002@3oool00`000000]EiU000000040:>nk0X000003`2g
Y<H200000080^h^S0P00000<0;NTaP@0000000<0oooo0000000000001@0000000`2_W<@000000000
0006000000`0/hBR00<000000?ooo`3oool0:03oool008L0oooo0P000002008e^0030000000/47X0
000000<0TfNL00<000000;^;X`2kRj<00P2kRj<3000000T0oooo00<000000;ENI@0000003P2S_^`:
000000D0]jC60P0000030;^;X`030000002gY<H0]jC600X0]jC6100000050?ooo`L000001@2_W<@8
000000@0/hBR00<000000?ooo`3oool0:03oool008L0oooo00L00000008e^002=KP00SFh0000000/
47X0000000<0TfNL00<000000;^;X`2kRj<00P2kRj<00`000000h:fP0>2]X002000000L0oooo0P00
000I0:>nk0L000000P2kRj<00`000000]jC60;NTaP0;0;NTaP@00000203oool9000000P0[ic41@00
000Z0?ooo`00QP3oool2000000<00SFh00<0000002`@NP0000000`2CIi`00`000000^h^S0;^;X`02
0;^;X`040000003P[J00h:fP0>2]X08000001P3oool6000001X0Xkk/2000000:0;NTaP030000003o
ool0oooo00`0oooo1000000209Zaj0D000001`2_W<@00`000000oooo0?ooo`0X0?ooo`00QP3oool0
0`0000000SFh008e^002008e^0030000000/47X0000000<0TfNL00<000000;^;X`2kRj<00P2kRj<0
10000000h:fP0>2]X03P[J02000000/0oooo2`00000?0:>nk0030000003oool000000080]EiU00@0
00000:>nk02S_^`0Xkk/1P0000030;NTaP030000003oool0oooo0140oooo1000000309Zaj0@00000
0P2_W<@00`000000oooo0?ooo`0Y0?ooo`00QP3oool01@0000000SFh008e^002=KP000000080;11j
00D0000009=WW02CIi`0TfNL000000040;^;X`040000003P[J00h:fP0>2]X08000002P3oool00`00
0000YOG]0:Gek@050:Gek@030000003oool0oooo00/000001@2S_^`00`000000oooo000000020;EN
I@030000002S_^`0Xkk/00L0Xkk/1000000F0?ooo`@00000102J/NP3000002/0oooo00270?ooo`06
00000002=KP00SFh0000000/47X000000`2CIi`00`000000^h^S0;^;X`020;^;X`030000003P[J00
h:fP0080h:fP0P0000090?ooo`030000002UmNd0YOG]00@0YOG]0P00000=0?ooo`H0000000<0oooo
0000002Om>T00P00000=0:>nk0030000003oool0oooo01L0oooo1@00000209Zaj0030000003oool0
oooo02T0oooo00270?ooo`0600000002=KP00SFh0000000/47X000000`2CIi`00`000000^h^S0;^;
X`020;^;X`030000003P[J00h:fP0080h:fP0P0000090?ooo`030000002UmNd0YOG]0080YOG]0P00
000E0?ooo`030000002Om>T0WoCY00D000002P2S_^`00`000000oooo0?ooo`0K0?ooo`<00000;03o
ool008P0oooo0`0000000`0/47X0000009=WW00209=WW0030000002kRj<0^h^S0080^h^S00L00000
0>2]X03P[J00h:fP0000003icf@0000000P0oooo00<000000:Gek@2UmNd00`00000F0?ooo`030000
002Om>T0WoCY00D0WoCY1`0000030:>nk0030000003oool0oooo04/0oooo00290?ooo`80000000<0
;11j0000002CIi`00P2CIi`00`000000^h^S0;^;X`020;^;X`060000003P[J00h:fP0>2]X0000000
nLmT2@3oool3000001T0oooo00<0000009odj@2Om>T0102Om>T00`000000oooo0?ooo`050?ooo`@0
0000C@3oool008X0oooo00<0000002`@NP0000000`2CIi`00`000000^h^S0;^;X`020;^;X`040000
003P[J00h:fP0>2]X0800000203oool2000001X0oooo00<0000009odj@2Om>T0102Om>T00`000000
oooo0?ooo`1G0?ooo`00RP3oool00`000000;11j0000000309=WW0030000002kRj<0^h^S0080^h^S
00@000000>2]X03P[J00h:fP0P00000S0?ooo`030000002Om>T0WoCY00@0WoCY00<000000?ooo`3o
ool0F03oool008X0oooo00<0000002`@NP0000000`2CIi`00`000000^h^S0;^;X`020;^;X`040000
003P[J00h:fP0>2]X08000008P3oool00`000000WoCY09odj@0509odj@030000003oool0oooo05P0
oooo00290?ooo`040000000/47X0;11j000000<0TfNL00<000000;^;X`0000000P2kRj<010000000
h:fP0>2]X03P[J0200000280oooo00<0000009odj@2Om>T0102Om>T00`000000oooo0?ooo`1I0?oo
o`00R@3oool010000000;11j02`@NP00000309=WW0030000002kRj<000000080^h^S00@000000>2]
X03P[J00h:fP0P00000Q0?ooo`030000002Om>T0WoCY00<0WoCY0P00001L0?ooo`00R@3oool01000
0000;11j02`@NP00000309=WW0030000002kRj<000000080^h^S00@000000>2]X03P[J00h:fP0P00
000P0?ooo`030000002Om>T0WoCY0080WoCY0P00001N0?ooo`00R@3oool010000000;11j02`@NP00
000309=WW0<000000P2kRj<010000000h:fP0>2]X03P[J02000001l0oooo00<0000009odj@2Om>T0
0`00001P0?ooo`00R@3oool00`000000;11j0000000309=WW0030000002kRj<0^h^S00<0^h^S00@0
00000>2]X03P[J00h:fP0P00000O0?ooo`<00000H`3oool008T0oooo00<0000002`@NP0000000`2C
Ii`00`000000^h^S0;^;X`020;^;X`030000003P[J00h:fP0080h:fP0P00000N0?ooo`800000I@3o
ool008T0oooo0P0/47X01@000000TfNL09=WW02CIi`0000000@0^h^S00L000000>2]X03P[J00h:fP
0000003icf@0000008D0oooo00280?ooo`040000000/47X0;11j000000<0TfNL00<000000;^;X`2k
Rj<00P2kRj<010000000h:fP0>2]X03P[J02000008H0oooo00280?ooo`040000000/47X0;11j0000
00<0TfNL00<000000;^;X`0000000P2kRj<010000000h:fP0>2]X03P[J02000008H0oooo00280?oo
o`030000000/47X0000000P0000000<0^h^S0000003P[J000P3P[J02000008H0oooo00280?ooo`80
00000`3O[:400`000000^h^S0;^;X`0600000080h:fP0P0000260?ooo`00R03oool00`000000o=5/
0=n/X@020=n/X@030000002kRj<0^h^S00<000000`2DJ9d4000008H0oooo00290?ooo`8000000P3O
[:400`000000^h^S0;^;X`03000000@0U6RM0`0000260?ooo`00R`3oool800000080U6RM0`000028
0?ooo`00T03oool5000008/0oooo002@0?ooo`800000SP3oool00900oooo0P00002>0?ooo`00S`3o
ool2000008l0oooo002?0?ooo`800000S`3oool008l0oooo0P00002?0?ooo`00S`3oool2000008l0
oooo002?0?ooo`800000S`3oool008l0oooo0P00002?0?ooo`00S`3oool2000008l0oooo002>0?oo
o`<00000S`3oool008l0oooo00<000000?ooo`3oool0SP3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.46458 .64879 m .61077 .61429 L .58827 .62339 L p 0 0 0 r
F P
0 g
s
.58827 .62339 m .44104 .65795 L .46458 .64879 L p 0 0 0 r
F P
0 g
s
.69763 .64716 m .70233 .63888 L .64979 .61859 L closepath p .885 .838 .793 r
F P
0 g
s
.69755 .65616 m .69763 .64716 L .64979 .61859 L closepath p .956 .729 .556 r
F P
0 g
s
.70233 .63888 m .70989 .63443 L .64979 .61859 L closepath p .719 .881 .956 r
F P
0 g
s
.70214 .66245 m .69755 .65616 L .64979 .61859 L closepath p .778 .287 0 r
F P
0 g
s
.70989 .63443 m .71744 .63553 L .64979 .61859 L closepath p .006 .561 .818 r
F P
0 g
s
.70969 .66363 m .70214 .66245 L .64979 .61859 L closepath p .316 .634 .963 r
F P
0 g
s
.71744 .63553 m .7221 .64179 L .64979 .61859 L closepath p .82 .392 .225 r
F P
0 g
s
.71731 .6592 m .70969 .66363 L .64979 .61859 L closepath p .702 .763 .899 r
F P
0 g
s
.7221 .64179 m .72206 .65084 L .64979 .61859 L closepath p .872 .654 .604 r
F P
0 g
s
.72206 .65084 m .71731 .6592 L .64979 .61859 L closepath p .821 .738 .773 r
F P
0 g
s
.50326 .51796 m .51997 .52033 L p .50995 .46597 L .761 .556 .62 r
F P
0 g
s
.40958 .3711 m .50792 .46178 L .49214 .45312 L p .661 .111 0 r
F P
0 g
s
.50635 .44645 m .50564 .46286 L p .50995 .46597 L .761 .556 .62 r
F P
0 g
s
.50564 .46286 m .50326 .51796 L p .50995 .46597 L .761 .556 .62 r
F P
0 g
s
.49214 .45312 m .47995 .44644 L p .47392 .43998 L .661 .111 0 r
F P
0 g
s
.47392 .43998 m .40958 .3711 L .49214 .45312 L .661 .111 0 r
F
.47995 .44644 m .38189 .35543 L .40958 .3711 L p F P
0 g
s
.03 w
.63416 .61067 m
.64979 .61859 L
s
.5 Mabswid
.58259 .61726 m .53684 .59485 L p .53271 .6032 L .834 .374 .11 r
F P
0 g
s
.44838 .6139 m .54822 .58906 L p .53149 .5959 L 0 0 0 r
F P
0 g
s
.54378 .59132 m .53149 .5959 L p .54822 .58906 L 0 0 0 r
F P
0 g
s
.53149 .5959 m .42611 .62203 L .44838 .6139 L p 0 0 0 r
F P
0 g
s
.53684 .59485 m .52225 .5877 L .52957 .59855 L p .834 .374 .11 r
F P
0 g
s
.52957 .59855 m .53271 .6032 L p .53684 .59485 L .834 .374 .11 r
F P
0 g
s
.54822 .58906 m .5531 .58785 L .54378 .59132 L p 0 0 0 r
F P
0 g
s
.59229 .62201 m .6177 .63446 L .61819 .61297 L p .909 .688 .591 r
F P
0 g
s
.61819 .61297 m .59288 .60028 L .59229 .62201 L p .909 .688 .591 r
F P
0 g
s
.59288 .60028 m .61819 .61297 L .62945 .59308 L p .849 .78 .784 r
F P
0 g
s
.60427 .58012 m .62945 .59308 L .6473 .58218 L p .716 .814 .926 r
F P
0 g
s
.62945 .59308 m .60427 .58012 L .59288 .60028 L p .849 .78 .784 r
F P
0 g
s
.60284 .63719 m .62827 .64952 L .6177 .63446 L p .834 .374 .11 r
F P
0 g
s
.6177 .63446 m .59229 .62201 L .60284 .63719 L p .834 .374 .11 r
F P
0 g
s
.6473 .58218 m .62225 .56902 L .60427 .58012 L p .716 .814 .926 r
F P
0 g
s
.62225 .56902 m .6473 .58218 L .66512 .58447 L p .221 .644 .955 r
F P
0 g
s
.62069 .6399 m .64606 .65228 L .62827 .64952 L p .163 .62 .934 r
F P
0 g
s
.62827 .64952 m .60284 .63719 L .62069 .6399 L p .163 .62 .934 r
F P
0 g
s
.66512 .58447 m .64014 .57126 L .62225 .56902 L p .221 .644 .955 r
F P
0 g
s
.64014 .57126 m .66512 .58447 L .67608 .59932 L p .821 .345 .055 r
F P
0 g
s
.63904 .62888 m .66428 .64146 L .64606 .65228 L p .713 .823 .934 r
F P
0 g
s
.64606 .65228 m .62069 .6399 L .63904 .62888 L p .713 .823 .934 r
F P
0 g
s
.67608 .59932 m .65108 .58621 L .64014 .57126 L p .821 .345 .055 r
F P
0 g
s
.65108 .58621 m .67608 .59932 L .6758 .62115 L p .916 .691 .583 r
F P
0 g
s
.52225 .5877 m .58259 .61726 L .58321 .59544 L p .909 .688 .591 r
F P
0 g
s
.58321 .59544 m .52313 .56532 L .52225 .5877 L p .909 .688 .591 r
F P
0 g
s
.52313 .56532 m .58321 .59544 L .59466 .57517 L p .849 .78 .784 r
F P
0 g
s
.53491 .54442 m .59466 .57517 L .61269 .56399 L p .716 .814 .926 r
F P
0 g
s
.59466 .57517 m .53491 .54442 L .52313 .56532 L p .849 .78 .784 r
F P
0 g
s
.68037 .59787 m .8487 .55815 L .82831 .56704 L p 0 0 0 r
F P
0 g
s
.6758 .62115 m .65071 .60829 L .65108 .58621 L p .916 .691 .583 r
F P
0 g
s
.82831 .56704 m .65843 .60692 L .68037 .59787 L p 0 0 0 r
F P
0 g
s
.65071 .60829 m .6758 .62115 L .66428 .64146 L p .854 .788 .786 r
F P
0 g
s
.66428 .64146 m .63904 .62888 L .65071 .60829 L p .854 .788 .786 r
F P
0 g
s
.53271 .6032 m .59312 .63248 L .58259 .61726 L p .834 .374 .11 r
F P
0 g
s
.61269 .56399 m .55322 .53275 L .53491 .54442 L p .716 .814 .926 r
F P
0 g
s
.55322 .53275 m .61269 .56399 L .6306 .56621 L p .221 .644 .955 r
F P
0 g
s
.48446 .5471 m .40046 .56959 L .40618 .58524 L p .559 .516 .764 r
F P
0 g
s
.40618 .58524 m .49027 .56321 L .48446 .5471 L p .559 .516 .764 r
F P
0 g
s
.49027 .56321 m .40618 .58524 L .40524 .6009 L p .509 .344 .593 r
F P
0 g
s
.47428 .53693 m .39021 .5598 L .40046 .56959 L p .58 .683 .912 r
F P
0 g
s
.40046 .56959 m .48446 .5471 L .47428 .53693 L p .58 .683 .912 r
F P
0 g
s
.40524 .6009 m .48954 .57925 L .49027 .56321 L p .509 .344 .593 r
F P
0 g
s
.48954 .57925 m .40524 .6009 L .39796 .61069 L p .35 0 .206 r
F P
0 g
s
.55071 .60577 m .61099 .63518 L .59312 .63248 L p .163 .62 .934 r
F P
0 g
s
.59312 .63248 m .53271 .6032 L .55071 .60577 L p .163 .62 .934 r
F P
0 g
s
.6306 .56621 m .57127 .53481 L .55322 .53275 L p .221 .644 .955 r
F P
0 g
s
.6306 .56621 m .64153 .58121 L p .6236 .56937 L .821 .345 .055 r
F P
0 g
s
.64153 .58121 m .58214 .55007 L .57127 .53481 L p .821 .345 .055 r
F P
0 g
s
.58214 .55007 m .64153 .58121 L .64112 .60338 L p .916 .691 .583 r
F P
0 g
s
.72464 .54802 m .61113 .57616 L p .62705 .56945 L 0 0 0 r
F P
0 g
s
.64112 .60338 m .58148 .57282 L .58214 .55007 L p .916 .691 .583 r
F P
0 g
s
.61113 .57616 m .60597 .57744 L .6152 .57394 L p 0 0 0 r
F P
0 g
s
.6152 .57394 m .62705 .56945 L p .61113 .57616 L 0 0 0 r
F P
0 g
s
.57127 .53481 m .62999 .56588 L p .6236 .56937 L .821 .345 .055 r
F P
0 g
s
.62999 .56588 m .6306 .56621 L p .6236 .56937 L .821 .345 .055 r
F P
0 g
s
.46352 .53661 m .37926 .55962 L .39021 .5598 L p .416 .85 .941 r
F P
0 g
s
.39021 .5598 m .47428 .53693 L .46352 .53661 L p .416 .85 .941 r
F P
0 g
s
.39796 .61069 m .48251 .5892 L .48954 .57925 L p .35 0 .206 r
F P
0 g
s
.48251 .5892 m .39796 .61069 L .38702 .61081 L p .377 .833 .918 r
F P
0 g
s
.56942 .59418 m .6294 .62408 L .61099 .63518 L p .713 .823 .934 r
F P
0 g
s
.61099 .63518 m .55071 .60577 L .56942 .59418 L p .713 .823 .934 r
F P
0 g
s
.45629 .54641 m .37178 .56927 L .37926 .55962 L p .328 0 .178 r
F P
0 g
s
.37926 .55962 m .46352 .53661 L .45629 .54641 L p .328 0 .178 r
F P
0 g
s
.38702 .61081 m .47177 .5892 L .48251 .5892 L p .377 .833 .918 r
F P
0 g
s
.47177 .5892 m .38702 .61081 L .37659 .60106 L p .573 .685 .917 r
F P
0 g
s
.58148 .57282 m .64112 .60338 L .6294 .62408 L p .854 .788 .786 r
F P
0 g
s
.6294 .62408 m .56942 .59418 L .58148 .57282 L p .854 .788 .786 r
F P
0 g
s
.03 w
.53773 .56181 m
.57658 .5815 L
s
.5 Mabswid
.45545 .56268 m .37074 .58514 L .37178 .56927 L p .502 .336 .589 r
F P
0 g
s
.37178 .56927 m .45629 .54641 L .45545 .56268 L p .502 .336 .589 r
F P
0 g
s
.37659 .60106 m .46139 .57907 L .47177 .5892 L p .573 .685 .917 r
F P
0 g
s
.46139 .57907 m .37659 .60106 L .37074 .58514 L p .554 .514 .765 r
F P
0 g
s
.02 w
.34816 .59585 m
.37234 .58948 L
s
.5 Mabswid
.37074 .58514 m .45545 .56268 L .46139 .57907 L p .554 .514 .765 r
F P
0 g
s
.02 w
.45707 .56715 m
.48074 .56091 L
s
.5 Mabswid
.52284 .44892 m .51997 .52033 L .53623 .51854 L p .615 .432 .612 r
F P
0 g
s
.53623 .51854 m .53891 .44697 L .52284 .44892 L p .615 .432 .612 r
F P
0 g
s
.51997 .52033 m .52284 .44892 L .50635 .44645 L p .761 .556 .62 r
F P
0 g
s
.50326 .51796 m .50635 .44645 L .49558 .44046 L p .91 .689 .59 r
F P
0 g
s
.53891 .44697 m .53623 .51854 L .54598 .51322 L p .328 .197 .546 r
F P
0 g
s
.54598 .51322 m .54855 .44131 L .53891 .44697 L p .328 .197 .546 r
F P
0 g
s
.62705 .56945 m .74479 .54016 L .72464 .54802 L p 0 0 0 r
F P
0 g
s
.49233 .51228 m .49558 .44046 L .49467 .43317 L p .844 .7 .167 r
F P
0 g
s
.49558 .44046 m .49233 .51228 L .50326 .51796 L p .91 .689 .59 r
F P
0 g
s
.54855 .44131 m .54598 .51322 L .54542 .50634 L p .801 .664 .114 r
F P
0 g
s
.65591 .2617 m .54695 .41342 L p .56288 .44566 L .825 .792 .82 r
F P
0 g
s
.53457 .50052 m .53732 .42787 L .54802 .43401 L p .915 .691 .584 r
F P
0 g
s
.53732 .42787 m .53457 .50052 L .51754 .49806 L p .762 .555 .617 r
F P
0 g
s
.51754 .49806 m .52051 .42531 L .53732 .42787 L p .762 .555 .617 r
F P
0 g
s
.54695 .41342 m .53518 .4298 L .54724 .43671 L p .825 .792 .82 r
F P
0 g
s
.54802 .43401 m .54855 .44131 L p .54756 .46184 L .801 .664 .114 r
F P
0 g
s
.54742 .45061 m .54802 .43401 L p .54756 .46184 L .801 .664 .114 r
F P
0 g
s
.54802 .43401 m .54542 .50634 L .53457 .50052 L p .915 .691 .584 r
F P
0 g
s
.54724 .43671 m .56288 .44566 L p .54695 .41342 L .825 .792 .82 r
F P
0 g
s
.54542 .50634 m .54742 .45061 L p .54756 .46184 L .801 .664 .114 r
F P
0 g
s
.49467 .43317 m .4914 .5054 L .49233 .51228 L p .844 .7 .167 r
F P
0 g
s
.4914 .5054 m .49467 .43317 L .50417 .42736 L p .31 .18 .537 r
F P
0 g
s
.56288 .44566 m .68228 .28013 L .65591 .2617 L p .825 .792 .82 r
F P
0 g
s
.5016 .56528 m .5021 .5536 L .5185 .55587 L p .761 .556 .62 r
F P
0 g
s
.5185 .55587 m .51803 .56754 L .5016 .56528 L p .761 .556 .62 r
F P
0 g
s
.51868 .54334 m .5185 .55587 L .5021 .5536 L p .754 .627 .719 r
F P
0 g
s
.51803 .56754 m .5185 .55587 L .53445 .5542 L p .615 .432 .611 r
F P
0 g
s
.5185 .55587 m .51868 .54334 L .53148 .54197 L p .63 .525 .715 r
F P
0 g
s
.53148 .54197 m .53445 .5542 L .5185 .55587 L p .63 .525 .715 r
F P
0 g
s
.5021 .5536 m .50554 .5415 L .51868 .54334 L p .754 .627 .719 r
F P
0 g
s
.51856 .53234 m .51868 .54334 L .50554 .5415 L p .731 .69 .811 r
F P
0 g
s
.51868 .54334 m .51856 .53234 L .52567 .53157 L p .634 .611 .81 r
F P
0 g
s
.52567 .53157 m .53148 .54197 L .51868 .54334 L p .634 .611 .81 r
F P
0 g
s
.501 .49994 m .50417 .42736 L .52051 .42531 L p .612 .428 .609 r
F P
0 g
s
.50417 .42736 m .501 .49994 L .4914 .5054 L p .31 .18 .537 r
F P
0 g
s
.49084 .55995 m .49137 .54822 L .5021 .5536 L p .91 .689 .59 r
F P
0 g
s
.5021 .5536 m .5016 .56528 L .49084 .55995 L p .91 .689 .59 r
F P
0 g
s
.02 w
.48074 .56091 m
.49092 .55823 L
s
.5 Mabswid
.50554 .5415 m .5021 .5536 L .49137 .54822 L p .874 .76 .733 r
F P
0 g
s
.49137 .54822 m .49696 .53713 L .50554 .5415 L p .874 .76 .733 r
F P
0 g
s
.51124 .53131 m .50554 .5415 L .49696 .53713 L p .811 .801 .842 r
F P
0 g
s
.50554 .5415 m .51124 .53131 L .51856 .53234 L p .731 .69 .811 r
F P
0 g
s
.50414 .57428 m .5016 .56528 L .51803 .56754 L p .748 .44 .463 r
F P
0 g
s
.51803 .56754 m .51736 .57608 L .50414 .57428 L p .748 .44 .463 r
F P
0 g
s
.51736 .57608 m .51803 .56754 L .53401 .56589 L p .573 .288 .446 r
F P
0 g
s
.53445 .5542 m .53401 .56589 L .51803 .56754 L p .615 .432 .611 r
F P
0 g
s
.53445 .5542 m .53148 .54197 L .53912 .5379 L p .419 .386 .716 r
F P
0 g
s
.53148 .54197 m .52567 .53157 L .52989 .52928 L p .484 .538 .837 r
F P
0 g
s
.52989 .52928 m .53912 .5379 L .53148 .54197 L p .484 .538 .837 r
F P
0 g
s
.53401 .56589 m .53445 .5542 L .54401 .54919 L p .328 .197 .546 r
F P
0 g
s
.03 w
.53675 .56132 m
.53773 .56181 L
s
.5 Mabswid
.53912 .5379 m .54401 .54919 L .53445 .5542 L p .419 .386 .716 r
F P
0 g
s
.52567 .53157 m .51856 .53234 L .51124 .53131 L p .56 .791 .986 r
F P
0 g
s
.52051 .42531 m .51754 .49806 L .501 .49994 L p .612 .428 .609 r
F P
0 g
s
.01 w
.51839 .51854 m
.51922 .4983 L
s
.5 Mabswid
.4955 .57003 m .49084 .55995 L .5016 .56528 L p .898 .528 .328 r
F P
0 g
s
.5016 .56528 m .50414 .57428 L .4955 .57003 L p .898 .528 .328 r
F P
0 g
s
.51124 .53131 m .5065 .52886 L p .52567 .53157 L .56 .791 .986 r
F P
0 g
s
.49696 .53713 m .5065 .52886 L .51124 .53131 L p .811 .801 .842 r
F P
0 g
s
.5296 .52634 m .52989 .52928 L .52567 .53157 L p .56 .791 .986 r
F P
0 g
s
.52487 .52387 m .5296 .52634 L p .52567 .53157 L .56 .791 .986 r
F P
0 g
s
.51749 .52282 m .52487 .52387 L p .52567 .53157 L .56 .791 .986 r
F P
0 g
s
.51033 .52361 m .51749 .52282 L p .52567 .53157 L .56 .791 .986 r
F P
0 g
s
.01 w
.51822 .52292 m
.51839 .51854 L
s
.5 Mabswid
.50613 .52592 m .51033 .52361 L p .52567 .53157 L .56 .791 .986 r
F P
0 g
s
.5065 .52886 m .50613 .52592 L p .52567 .53157 L .56 .791 .986 r
F P
0 g
s
.53023 .57478 m .53401 .56589 L .54359 .56094 L p .153 0 .224 r
F P
0 g
s
.54401 .54919 m .54359 .56094 L .53401 .56589 L p .328 .197 .546 r
F P
0 g
s
.53401 .56589 m .53023 .57478 L .51736 .57608 L p .573 .288 .446 r
F P
0 g
s
.49045 .54171 m .49625 .53187 L .49696 .53713 L p .94 .957 .657 r
F P
0 g
s
.49696 .53713 m .49137 .54822 L .49045 .54171 L p .94 .957 .657 r
F P
0 g
s
.5065 .52886 m .49696 .53713 L .49625 .53187 L p .836 .965 .888 r
F P
0 g
s
.50926 .57881 m .50414 .57428 L .51736 .57608 L p .617 .117 .042 r
F P
0 g
s
.51736 .57608 m .51664 .57981 L .50926 .57881 L p .617 .117 .042 r
F P
0 g
s
.51664 .57981 m .51736 .57608 L .53023 .57478 L p .393 0 .001 r
F P
0 g
s
.49625 .53187 m .50613 .52592 L .5065 .52886 L p .836 .965 .888 r
F P
0 g
s
.53912 .5379 m .52989 .52928 L .5296 .52634 L p .12 .404 .854 r
F P
0 g
s
.54401 .54919 m .53912 .5379 L .53864 .53264 L p 0 0 .507 r
F P
0 g
s
.02 w
.54574 .54378 m
.55427 .54154 L
s
.5 Mabswid
.5296 .52634 m .53864 .53264 L .53912 .5379 L p .12 .404 .854 r
F P
0 g
s
.48991 .55351 m .49045 .54171 L .49137 .54822 L p .844 .699 .167 r
F P
0 g
s
.49137 .54822 m .49084 .55995 L .48991 .55351 L p .844 .699 .167 r
F P
0 g
s
.50447 .57646 m .4955 .57003 L .50414 .57428 L p .589 .02 0 r
F P
0 g
s
.50414 .57428 m .50926 .57881 L .50447 .57646 L p .589 .02 0 r
F P
0 g
s
.52381 .57909 m .53023 .57478 L .53791 .57083 L p 0 0 0 r
F P
0 g
s
.54359 .56094 m .53791 .57083 L .53023 .57478 L p .153 0 .224 r
F P
0 g
s
.53023 .57478 m .52381 .57909 L .51664 .57981 L p .393 0 .001 r
F P
0 g
s
.51659 .6042 m .51356 .67963 L .53026 .6782 L p .615 .432 .612 r
F P
0 g
s
.53026 .6782 m .53309 .6026 L .51659 .6042 L p .615 .432 .612 r
F P
0 g
s
.51356 .67963 m .51659 .6042 L .49963 .60194 L p .761 .556 .62 r
F P
0 g
s
.01 w
.51463 .61141 m
.51572 .58452 L
s
.5 Mabswid
.53864 .53264 m .54345 .54268 L .54401 .54919 L p 0 0 .507 r
F P
0 g
s
.54359 .56094 m .54401 .54919 L .54345 .54268 L p .801 .665 .115 r
F P
0 g
s
.49478 .56492 m .48991 .55351 L .49084 .55995 L p 0 0 .467 r
F P
0 g
s
.49084 .55995 m .4955 .57003 L .49478 .56492 L p 0 0 .467 r
F P
0 g
s
.50379 .52771 m .51033 .52361 L .50613 .52592 L p 0 0 0 r
F P
0 g
s
.50613 .52592 m .49625 .53187 L .50379 .52771 L p 0 0 0 r
F P
0 g
s
.53864 .53264 m .5296 .52634 L .52487 .52387 L p .548 0 0 r
F P
0 g
s
.49637 .67747 m .49963 .60194 L .48852 .59663 L p .91 .689 .59 r
F P
0 g
s
.49963 .60194 m .49637 .67747 L .51356 .67963 L p .761 .556 .62 r
F P
0 g
s
.53791 .57083 m .54359 .56094 L .54302 .5545 L p .929 .956 .635 r
F P
0 g
s
.54345 .54268 m .54302 .5545 L .54359 .56094 L p .801 .665 .115 r
F P
0 g
s
.53309 .6026 m .53026 .6782 L .54025 .6737 L p .328 .197 .546 r
F P
0 g
s
.54025 .6737 m .54296 .5977 L .53309 .6026 L p .328 .197 .546 r
F P
0 g
s
.53791 .57083 m .52806 .57691 L .52381 .57909 L p 0 0 0 r
F P
0 g
s
.51664 .57981 m .52381 .57909 L .52806 .57691 L p .547 .794 .99 r
F P
0 g
s
.50926 .57881 m .51664 .57981 L p .52806 .57691 L .547 .794 .99 r
F P
0 g
s
.49986 .53657 m .50379 .52771 L .49625 .53187 L p .119 0 .193 r
F P
0 g
s
.49625 .53187 m .49045 .54171 L .49986 .53657 L p .119 0 .193 r
F P
0 g
s
.5041 .57364 m .49478 .56492 L .4955 .57003 L p .08 .384 .845 r
F P
0 g
s
.4955 .57003 m .50447 .57646 L .5041 .57364 L p .08 .384 .845 r
F P
0 g
s
.51676 .5263 m .51749 .52282 L .51033 .52361 L p .366 0 0 r
F P
0 g
s
.51033 .52361 m .50379 .52771 L .51676 .5263 L p .366 0 0 r
F P
0 g
s
.50447 .57646 m .50926 .57881 L p .52806 .57691 L .547 .794 .99 r
F P
0 g
s
.52487 .52387 m .53011 .52819 L .53864 .53264 L p .548 0 0 r
F P
0 g
s
.53011 .52819 m .52487 .52387 L .51749 .52282 L p .601 .088 .001 r
F P
0 g
s
.54345 .54268 m .53864 .53264 L .53011 .52819 L p .899 .52 .305 r
F P
0 g
s
.52806 .57691 m .53791 .57083 L .53742 .56572 L p .832 .974 .886 r
F P
0 g
s
.54302 .5545 m .53742 .56572 L .53791 .57083 L p .929 .956 .635 r
F P
0 g
s
.51749 .52282 m .51676 .5263 L .53011 .52819 L p .601 .088 .001 r
F P
0 g
s
.62923 .50834 m .56424 .52574 L .57012 .54229 L p .559 .516 .764 r
F P
0 g
s
.57012 .54229 m .63517 .52525 L .62923 .50834 L p .559 .516 .764 r
F P
0 g
s
.63517 .52525 m .57012 .54229 L .56961 .55869 L p .509 .344 .593 r
F P
0 g
s
.49934 .54842 m .49986 .53657 L .49045 .54171 L p .311 .181 .537 r
F P
0 g
s
.49045 .54171 m .48991 .55351 L .49934 .54842 L p .311 .181 .537 r
F P
0 g
s
.5041 .57364 m .50447 .57646 L p .52806 .57691 L .547 .794 .99 r
F P
0 g
s
.6192 .49752 m .55413 .51521 L .56424 .52574 L p .58 .683 .912 r
F P
0 g
s
.56424 .52574 m .62923 .50834 L .6192 .49752 L p .58 .683 .912 r
F P
0 g
s
.02 w
.61641 .52516 m
.61858 .52459 L
s
.5 Mabswid
.50832 .57143 m .5041 .57364 L p .52806 .57691 L .547 .794 .99 r
F P
0 g
s
.51555 .57069 m .50832 .57143 L p .52806 .57691 L .547 .794 .99 r
F P
0 g
s
.52298 .57171 m .51555 .57069 L p .52806 .57691 L .547 .794 .99 r
F P
0 g
s
.01 w
.51572 .58452 m
.51609 .57528 L
s
.51628 .57079 m
.51803 .5276 L
s
.5 Mabswid
.52806 .57691 m .52776 .57409 L .52298 .57171 L p .547 .794 .99 r
F P
0 g
s
.53742 .56572 m .52776 .57409 L .52806 .57691 L p .832 .974 .886 r
F P
0 g
s
.54302 .5545 m .54345 .54268 L .53279 .53717 L p .915 .691 .584 r
F P
0 g
s
.53011 .52819 m .53279 .53717 L .54345 .54268 L p .899 .52 .305 r
F P
0 g
s
.4851 .67252 m .48852 .59663 L .48755 .59025 L p .844 .7 .167 r
F P
0 g
s
.48852 .59663 m .4851 .67252 L .49637 .67747 L p .91 .689 .59 r
F P
0 g
s
.50237 .56089 m .49934 .54842 L .48991 .55351 L p .407 .378 .714 r
F P
0 g
s
.48991 .55351 m .49478 .56492 L .50237 .56089 L p .407 .378 .714 r
F P
0 g
s
.51608 .53481 m .51676 .5263 L .50379 .52771 L p .567 .277 .436 r
F P
0 g
s
.50379 .52771 m .49986 .53657 L .51608 .53481 L p .567 .277 .436 r
F P
0 g
s
.54296 .5977 m .54025 .6737 L .53963 .66778 L p .801 .664 .114 r
F P
0 g
s
.53963 .66778 m .54237 .59131 L .54296 .5977 L p .801 .664 .114 r
F P
0 g
s
.56961 .55869 m .63484 .54194 L .63517 .52525 L p .509 .344 .593 r
F P
0 g
s
.63484 .54194 m .56961 .55869 L .56284 .56879 L p .35 0 .206 r
F P
0 g
s
.53279 .53717 m .53011 .52819 L .51676 .5263 L p .748 .435 .454 r
F P
0 g
s
.53742 .56572 m .54302 .5545 L .53235 .54903 L p .879 .765 .733 r
F P
0 g
s
.53279 .53717 m .53235 .54903 L .54302 .5545 L p .915 .691 .584 r
F P
0 g
s
.02 w
.50107 .55556 m
.53241 .5473 L
s
.54288 .54454 m
.54574 .54378 L
s
.53792 .54584 m
.54288 .54454 L
s
.5 Mabswid
.50832 .57143 m .50237 .56089 L .49478 .56492 L p .474 .536 .84 r
F P
0 g
s
.49478 .56492 m .5041 .57364 L .50832 .57143 L p .474 .536 .84 r
F P
0 g
s
.52776 .57409 m .53742 .56572 L .52884 .56139 L p .813 .807 .845 r
F P
0 g
s
.52884 .56139 m .52298 .57171 L .52776 .57409 L p .813 .807 .845 r
F P
0 g
s
.51676 .5263 m .51608 .53481 L .53279 .53717 L p .748 .435 .454 r
F P
0 g
s
.53235 .54903 m .52884 .56139 L .53742 .56572 L p .879 .765 .733 r
F P
0 g
s
.60883 .49693 m .54358 .51475 L .55413 .51521 L p .416 .85 .941 r
F P
0 g
s
.55413 .51521 m .6192 .49752 L .60883 .49693 L p .416 .85 .941 r
F P
0 g
s
.5156 .5467 m .51608 .53481 L .49986 .53657 L p .612 .428 .609 r
F P
0 g
s
.49986 .53657 m .49934 .54842 L .5156 .5467 L p .612 .428 .609 r
F P
0 g
s
.03 w
.50924 .54737 m
.52985 .55782 L
s
.5 Mabswid
.50237 .56089 m .50832 .57143 L .51555 .57069 L p .632 .612 .812 r
F P
0 g
s
.52298 .57171 m .52884 .56139 L .51541 .55953 L p .731 .692 .813 r
F P
0 g
s
.51541 .55953 m .51555 .57069 L .52298 .57171 L p .731 .692 .813 r
F P
0 g
s
.53235 .54903 m .53279 .53717 L .51608 .53481 L p .762 .555 .617 r
F P
0 g
s
.43291 .48863 m .42509 .48784 L .49914 .54226 L closepath p .297 .628 .962 r
F P
0 g
s
.43742 .49542 m .43291 .48863 L .49914 .54226 L closepath p .795 .308 0 r
F P
0 g
s
.41696 .49329 m .41158 .5029 L .49914 .54226 L closepath p .823 .741 .774 r
F P
0 g
s
.42509 .48784 m .41696 .49329 L .49914 .54226 L closepath p .701 .767 .903 r
F P
0 g
s
.43686 .50564 m .43742 .49542 L .49914 .54226 L closepath p .952 .728 .562 r
F P
0 g
s
.41158 .5029 m .41097 .51304 L .49914 .54226 L closepath p .875 .655 .601 r
F P
0 g
s
.43142 .51534 m .43686 .50564 L .49914 .54226 L closepath p .883 .833 .793 r
F P
0 g
s
.41097 .51304 m .4154 .51988 L .49914 .54226 L closepath p .818 .383 .207 r
F P
0 g
s
.42321 .52078 m .43142 .51534 L .49914 .54226 L closepath p .722 .876 .953 r
F P
0 g
s
.4154 .51988 m .42321 .52078 L .49914 .54226 L closepath p .042 .585 .845 r
F P
0 g
s
.03 w
.49914 .54226 m
.4996 .54249 L
s
.5 Mabswid
.51555 .57069 m .51541 .55953 L .50237 .56089 L p .632 .612 .812 r
F P
0 g
s
.51541 .55953 m .5156 .5467 L .49934 .54842 L p .628 .523 .715 r
F P
0 g
s
.49934 .54842 m .50237 .56089 L .51541 .55953 L p .628 .523 .715 r
F P
0 g
s
.51608 .53481 m .5156 .5467 L .53235 .54903 L p .762 .555 .617 r
F P
0 g
s
.56284 .56879 m .6283 .55216 L .63484 .54194 L p .35 0 .206 r
F P
0 g
s
.6283 .55216 m .56284 .56879 L .5523 .56866 L p .377 .833 .918 r
F P
0 g
s
.48755 .59025 m .48408 .6666 L .4851 .67252 L p .844 .7 .167 r
F P
0 g
s
.48408 .6666 m .48755 .59025 L .49727 .58522 L p .31 .18 .537 r
F P
0 g
s
.52884 .56139 m .53235 .54903 L .5156 .5467 L p .755 .628 .72 r
F P
0 g
s
.5156 .5467 m .51541 .55953 L .52884 .56139 L p .755 .628 .72 r
F P
0 g
s
.54237 .59131 m .53963 .66778 L .52844 .6627 L p .915 .691 .584 r
F P
0 g
s
.52844 .6627 m .53135 .58588 L .54237 .59131 L p .915 .691 .584 r
F P
0 g
s
.60209 .50698 m .53661 .52469 L .54358 .51475 L p .328 0 .178 r
F P
0 g
s
.54358 .51475 m .60883 .49693 L .60209 .50698 L p .328 0 .178 r
F P
0 g
s
.5523 .56866 m .61796 .55192 L .6283 .55216 L p .377 .833 .918 r
F P
0 g
s
.61796 .55192 m .5523 .56866 L .54201 .55817 L p .573 .685 .917 r
F P
0 g
s
.49391 .66197 m .49727 .58522 L .51405 .58353 L p .612 .428 .609 r
F P
0 g
s
.49727 .58522 m .49391 .66197 L .48408 .6666 L p .31 .18 .537 r
F P
0 g
s
.53135 .58588 m .52844 .6627 L .51091 .66046 L p .762 .555 .617 r
F P
0 g
s
.51091 .66046 m .51405 .58353 L .53135 .58588 L p .762 .555 .617 r
F P
0 g
s
.60165 .52391 m .53599 .54132 L .53661 .52469 L p .502 .336 .589 r
F P
0 g
s
.53661 .52469 m .60209 .50698 L .60165 .52391 L p .502 .336 .589 r
F P
0 g
s
.51405 .58353 m .51091 .66046 L .49391 .66197 L p .612 .428 .609 r
F P
0 g
s
.01 w
.51045 .7146 m
.51263 .66068 L
s
.5 Mabswid
.54201 .55817 m .60774 .54114 L .61796 .55192 L p .573 .685 .917 r
F P
0 g
s
.60774 .54114 m .54201 .55817 L .53599 .54132 L p .554 .514 .765 r
F P
0 g
s
.53599 .54132 m .60165 .52391 L .60774 .54114 L p .554 .514 .765 r
F P
0 g
s
.02 w
.60331 .52861 m
.61641 .52516 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00_03oool0
0`000000oooo0?ooo`1Q0?ooo`00^`3oool010000000dl[A00000000001Q0?ooo`00^`3oool40=?:
d@030000003oool0oooo05h0oooo002j0?ooo`030000003Cb]40dl[A00<0dl[A00<000000?ooo`3o
ool0G@3oool00;T0oooo00<000000=?:d@3Cb]401@3Cb]42000005d0oooo002h0?ooo`030000003C
b]40dl[A00P0dl[A00<000000?ooo`3oool0FP3oool00;P0oooo00<000000=?:d@3Cb]401`3Cb]40
0`000000oooo0?ooo`1K0?ooo`00]`3oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo
05/0oooo002f0?ooo`030000003Cb]40dl[A00P0dl[A00<000000?ooo`3oool0G03oool00;D0oooo
00<000000=?:d@3Cb]40203Cb]400`000000oooo0?ooo`1M0?ooo`00]@3oool00`000000dl[A0=?:
d@070=?:d@030000003oool0oooo05h0oooo002d0?ooo`030000003Cb]40dl[A00P0dl[A00<00000
0?ooo`3oool0GP3oool00;<0oooo00<000000=?:d@3Cb]40203Cb]400`000000oooo0?ooo`1O0?oo
o`00/P3oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo0600oooo002b0?ooo`030000
003Cb]40dl[A00L0dl[A00<000000?ooo`3oool0H@3oool00;40oooo00<000000=?:d@3Cb]40203C
b]400`000000oooo0?ooo`1Q0?ooo`00/03oool00`000000dl[A0=?:d@080=?:d@030000003oool0
oooo0680oooo002_0?ooo`030000003Cb]40dl[A00P0dl[A00<000000?ooo`3oool0H`3oool00:l0
oooo00<000000=?:d@3Cb]40203Cb]400`000000oooo0?ooo`1S0?ooo`00[P3oool00`000000dl[A
0=?:d@080=?:d@030000003oool0oooo06@0oooo002]0?ooo`030000003Cb]40dl[A00P0dl[A00<0
00000?ooo`3oool0I@3oool00:`0oooo00<000000=?:d@3Cb]40203Cb]400`000000oooo0?ooo`1V
0?ooo`00[03oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo06H0oooo002[0?ooo`03
0000003Cb]40dl[A00P0dl[A00<000000?ooo`3oool0I`3oool00:X0oooo00<000000=?:d@3Cb]40
203Cb]400`000000oooo0?ooo`1X0?ooo`00Z@3oool00`000000dl[A0=?:d@090=?:d@030000003o
ool0oooo06P0oooo002Y0?ooo`030000003Cb]40dl[A00P0dl[A00<000000?ooo`3oool0J@3oool0
06d0oooo00<000000?ooo`3oool0>03oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo
06X0oooo001^0?ooo`800000=`3oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo06/0
oooo001_0?ooo`<00000=03oool00`000000dl[A0=?:d@090=?:d@030000003oool0oooo06/0oooo
001`0?ooo`040000002Y7000000000000380oooo00<000000=?:d@3Cb]40203Cb]400`000000oooo
0?ooo`1/0?ooo`00L@3oool00`000000ZA`00:TL0002000002l0oooo00<000000=?:d@3Cb]40203C
b]400`000000oooo0?ooo`1]0?ooo`00LP3oool01@000000ZA`00:TL002Y7000000002d0oooo00<0
00000=?:d@3Cb]40203Cb]400`000000oooo0?ooo`1^0?ooo`00L`3oool01@000000ZA`00:TL002Y
7000000002/0oooo00<000000=?:d@3Cb]402@3Cb]400`000000oooo0?ooo`1^0?ooo`00M03oool2
00000080ZA`000<000000?ooo`3oool0:03oool00`000000dl[A0=?:d@080=?:d@030000003oool0
oooo06l0oooo001f0?ooo`040000002Y7000ZA`0000002P0oooo00<000000=?:d@3Cb]40203Cb]40
0`000000oooo0?ooo`1`0?ooo`00M`3oool010000000ZA`00:TL0000000V0?ooo`030000003Cb]40
dl[A00T0dl[A00<000000?ooo`3oool0L03oool007P0oooo00@000000:TL002Y70000000903oool0
0`000000dl[A0=?:d@090=?:d@030000003oool0oooo0740oooo001i0?ooo`030000002Y7000ZA`0
008000008P3oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo0780oooo001j0?ooo`05
0000002Y7000ZA`00:TL00000000803oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo
07<0oooo001k0?ooo`050000002Y7000ZA`00:TL000000007P3oool00`000000dl[A0=?:d@090=?:
d@030000003oool0oooo07<0oooo001l0?ooo`050000002Y7000ZA`00:TL00000000703oool00`00
0000dl[A0=?:d@090=?:d@030000003oool0oooo07@0oooo001m0?ooo`050000002Y7000oooo0:TL
000000006`3oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo07D0oooo001n0?ooo`05
0000002Y7000oooo0:TL000000006@3oool00`000000dl[A0=?:d@090=?:d@030000003oool0oooo
07D0oooo001o0?ooo`050000002Y7000oooo0:TL000000005`3oool00`000000dl[A0=?:d@090=?:
d@030000003oool0oooo07H0oooo00200?ooo`050000002Y7000oooo0:TL000000005P3oool00`00
0000dl[A0=?:d@080=?:d@030000003oool0oooo07L0oooo00210?ooo`050000002Y7000oooo0:TL
00000000503oool00`000000dl[A0=?:d@080=?:d@030000003oool0oooo07P0oooo00220?ooo`80
000000<0oooo0:TL000000002@3oool;000000X0dl[A00<000000?ooo`3oool0N03oool008@0oooo
00@000000?ooo`2Y700000001P3oool3000000@0W6fK00D000000<>>W@33SYd0`hjM0000000:0=?:
d@030000003oool0oooo07T0oooo00250?ooo`040000003oool0ZA`0000000@0oooo00@0000004l^
R@1?;XT00000102LKI/00`000000`hjM0<>>W@020<>>W@8000001`3Cb]400`000000oooo0?ooo`1j
0?ooo`00QP3oool010000000oooo0:TL000000030?ooo`040000001?;XT0Cbj9000000@0W6fK00<0
00000<>>W@33SYd00P33SYd010000000j[2E0000000000040=?:d@030000003oool0oooo07/0oooo
00270?ooo`030000002Y7000ZA`00080000000D0oooo0000001?;XT0Cbj90000000409a]V`030000
0033SYd0`hjM0080`hjM00<000000>Z`U@3Z/9D00`0000020=?:d@030000003oool0oooo07/0oooo
00280?ooo`040000002Y7000ZA`00:TL008000000P1?;XT00`000000W6fK09a]V`0209a]V`030000
0033SYd0`hjM0080`hjM00@000000>Z`U@3Z/9D000000P3oool2000007h0oooo00290?ooo`050000
002Y7000ZA`00:TL000000000P1?;XT00`000000W6fK09a]V`0209a]V`0300000033SYd0`hjM0080
`hjM00@000000>Z`U@3Z/9D00000PP3oool008X0oooo0P0000001@2Y7000000004l^R@1?;XT00000
00@0W6fK00<000000<>>W@33SYd00P33SYd010000000j[2E0>Z`U@0000220?ooo`00S03oool20000
0080Cbj900<0000009a]V`2LKI/00P2LKI/00`000000`hjM0<>>W@020<>>W@040000003Z/9D0j[2E
00000880oooo002=0?ooo`040000001?;XT0Cbj9000000@0W6fK00<000000<>>W@33SYd00P33SYd0
10000000j[2E0>Z`U@0000220?ooo`00S@3oool010000000Cbj904l^R@00000409a]V`0300000033
SYd0`hjM0080`hjM00@000000>Z`U@3Z/9D00000PP3oool008d0oooo00<0000004l^R@000000102L
KI/00`000000`hjM0<>>W@020<>>W@050000003Z/9D0j[2E0>Z`U@000000PP3oool008d0oooo00<0
000004l^R@000000102LKI/00`000000`hjM0<>>W@020<>>W@050000003Z/9D0j[2E0>Z`U@000000
PP3oool008d0oooo00<0000004l^R@000000102LKI/00`000000`hjM0<>>W@020<>>W@030000003Z
/9D0j[2E00800000PP3oool008d0oooo00<0000004l^R@000000102LKI/00`000000`hjM0<>>W@02
0<>>W@030000003Z/9D0j[2E00800000PP3oool008d0oooo00<0000004l^R@000000102LKI/00`00
0000`hjM0<>>W@020<>>W@030000003Z/9D0j[2E00800000PP3oool008d0oooo00<0000004l^R@00
0000102LKI/00`000000`hjM0<>>W@020<>>W@040000003Z/9D0j[2E000008<0oooo002=0?ooo`03
0000001?;XT0000000@0W6fK00<000000<>>W@33SYd00P33SYd010000000j[2E0>Z`U@0000230?oo
o`00N@3oool400000100oooo00<0000004l^R@000000102LKI/00`000000`hjM0<>>W@020<>>W@04
0000003Z/9D0j[2E000008<0oooo001g0?ooo`8000000P2ca>L3000000l0oooo00<0000004l^R@00
0000102LKI/00`000000`hjM0<>>W@020<>>W@040000003Z/9D0j[2E000008<0oooo001g0?ooo`<0
00000`2ca>L3000000d0oooo00<0000004l^R@0000000P2LKI/500000080`hjM00@000000>Z`U@3Z
/9D00000403oool5000006h0oooo001f0?ooo`040000003B_LH0d[g60=:maP80000000<0/lCW0000
000000000P00000<0?ooo`030000001?;XT00000008000000P32SYh600000080j[2E00<000000?oo
o`3oool02P3oool700000080U:kY00<000000?ooo`3oool0J`3oool007H0oooo0P0000040=:maP80
00000P3c^Xl2000000/0oooo0P0000000`3X/9L000000<:>WP020<:>WP8000000`2MKY`4000000P0
oooo1000000405<0;@030000002D[^T0U:kY00<0U:kY00<000000?ooo`3oool0JP3oool007H0oooo
00@000000=nWV@00000000000`3B_LH010000000lkZ?0?>jS`3c^Xl2000000X0oooo00@000000>R`
U`3X/9L000000`32SYh2000000<0WFjL00@0000005<bR`1C<X/000001@3oool3000000H0D`0]0P00
000609B^j@800000J`3oool007D0oooo00<000000=nWV@3OYiT00P3OYiT3000000030>;Eb`000000
00000080lkZ?0`0000080?ooo`040000003X/9L0j;2G000000<0`XjN0P00000309e^W0050000001C
<X/0Dc:;0000003oool01000000505<0;@@0000000@0P5JF0000002D[^T0U:kY100000000`2?Q<<0
00000?ooo`1Z0?ooo`00M@3oool2000000@0gjNI0P0000030>;Eb`8000000P3c^Xl2000000L0oooo
0P0000000`3X/9L000000<:>WP020<:>WP8000000`2MKY`00`000000Dc:;00000002000000D0D`0]
10000005081FUP<000001P2?Q<<00`000000oooo0?ooo`1X0?ooo`00MP3oool500000080^>3c0P00
00030>;Eb`80000000<0lkZ?000000000000203oool70000000309e^W0000000000000<00000101C
02d3000000T0P5JF00<0000008n4``0000001@0000000`2?Q<<000000?ooo`1Y0?ooo`00M`3oool4
000000@0^>3c0`0000020>;Eb`D000002P3oool4000000@0oooo1@00000<081FUPP000000P2?Q<<0
0`000000oooo0?ooo`1W0?ooo`00N@3oool6000000<0^>3c0P0000020>;Eb`040000003c^Xl00000
000000L0oooo1P0000030?ooo`8000003`20EYH90000000308n4``000000000006T0oooo001m0?oo
o`H0000000<0^>3c0000000000001@0000040?ooo`X0000000<0oooo00000020EYH02`20EYH>0000
0003089HU`000000oooo06P0oooo00210?ooo`D0000000<0^>3c0000000000002P0000000`2AAVl0
00000;m_M0020;m_M0<000002020EYH4000000@0SH?320000003089HU`030000003oool0oooo06L0
oooo00250?oooa4000000P2oKg@2000000D0P5JF1000000908f3``<000001`22F9L00`000000oooo
0?ooo`1W0?ooo`00P`3ooolB000000030<>>W@00000000000080000000<0P5JF0000000000000P00
000?08f3``0300000022F9L0PURG00D0PURG00<000000?ooo`3oool0I`3oool007l0oooo1`000003
09B^j@030000003oool0000000P000001033SYd3000001<0SH?300<00000089HU`22F9L01022F9L2
000001`0oooo0`00001:0?ooo`00N`3oool400000080D`0]0P00000709B^j@`000000P33SYd20000
00l0SH?31000000209:_jP0300000022F9L000000080000000<0F@0d0000003oool0603oool50000
04`0oooo001g0?ooo`@000000P1C02d400000003081FUP000000U:kY00D0U:kY200000020:25]`03
00000031X;P0`J2h00D000002P2=Pl<4000000L0TZoZ00<0000005T0=01I03@00P1I03@00`000000
oooo0?ooo`0C0?ooo`H00000C`3oool007<0oooo1000000305<0;@<000001@20EYH00`000000U:kY
09B^j@0;000000<0X8Fg00<000000<6P^031X;P00P31X;P3000000H0SH?31000000<09:_jP@00000
4P3oool6000005<0oooo001_0?ooo`@000000`1C02d4000000P0P5JF3`0000020:25]`0300000031
X;P0`J2h0080`J2h100000000`2=Pl<0000000000002000000/0TZoZ1`00000?0?ooo`L00000E`3o
ool006`0oooo0`00000405<0;@<000003020EYHC00000080`J2h1P00000;09:_jPL0000000<0dUP>
000000000000303oool7000002`0oooo0`00000/0?ooo`00J`3oool00`000000D`0]05<0;@0205<0
;@<000003@20EYHA00000080XIc?00<000000;^ad00000001`00000709:_jPL000000`3Z/9D01000
0000dUP>0=9H3P3BF0h2000000H0oooo1`00000/0?ooo`D00000;P3oool006/0oooo1@00000<081F
UP@0000000<0SH?3000000000000300000001@1iRML000000:6Lc`2QW<l0000000<0^k7@1`000002
09:_jPL000002@3Z/9D01P000000dUP>0=9H3P3BF0h000000?ooo`L00000;03oool600000340oooo
001Z0?ooo`8000003020EYH4000000D0SH?31`000004089HU`050000003oool000000000001iRML0
100000000`2k/M0000000000000A000000T0j[2E1`00000[0?ooo`L00000=@3oool006X0oooo00<0
0000081FUP20EYH01`20EYH4000000X0SH?30`000007089HU`030000003oool0oooo00<0000000<0
S<_m0000000000005P0000040>Z`U@P0000000<0>:Cd0000000000009P3oool7000003T0oooo001Z
0?ooo`0300000020EYH0P5JF00<0P5JF1000000@08f3``0300000022F9L0PURG00D0PURG00D00000
0?ooo`3oool0oooo0000000208c;o@8000000P2<bodC000000<0j[2E100000050>Z`U@<0000000<0
dUP>0000000000007`3oool8000003d0oooo001Z0?ooo`0300000020EYH0000000<00000502=Pl<0
0`000000PURG089HU`03089HU`<00000103oool6000000D0j;2G3`00000=0>Z`U@8000000P3BF0h2
000001T0oooo200000110?ooo`00J03oool500000140SH?31000000309:_jPD0000000@0F@0d0000
003oool0oooo200000080>R`U`/000000P3JbLT2000000/0j[2E0P0000040=9H3P030000003oool0
oooo0180oooo200000150?ooo`00I@3oool8000000d0SH?31000000809:_jP030000001I03@0F@0d
0080F@0d1000000409a]V`0300000033SYd0`hjM00@000001P3X/9L9000000@0f/W90P0000090>Z`
U@030000003oool0000000@0dUP>00<000000?ooo`3oool0303oool9000004T0oooo001Q0?ooo``0
00002@2=Pl<4000000d0TZoZ1@00000204l^R@030000002LKI/0W6fK0080W6fK00<000000<>>W@33
SYd00P33SYd010000000j[2E0000000000060>R`U`L000001P3JbLT2000000L0j[2E00<000000?oo
o`0000000P0000030=9H3P030000003oool0oooo00L0oooo2@00001=0?ooo`00H@3oool<000000D0
SH?31000000;09:_jP@0000000<0H=G[0000000000000`3oool010000000Cbj904l^R@00000409a]
V`0300000033SYd0`hjM0080`hjM00@000000>Z`U@3Z/9D000001`3X/9L00`000000f/W900000002
000000T0f/W90P0000040>Z`U@040000003oool0oooo00000080j[2E0P0000000`3BF0h000000?oo
o`040?ooo`T00000D@3oool00640oooo300000000`2=Pl<0000000000002000000/0TZoZ1`000007
0?ooo`040000001?;XT0Cbj9000000@0W6fK00<000000<>>W@33SYd00P33SYd010000000j[2E0>Z`
U@0000050>R`U`80000000D0]];_000000000000f/W90000000;0=[9b@8000000P3Z/9D010000000
oooo0?ooo`0000040>Z`U@`00000E@3oool00640oooo200000030?ooo`8000002`2B[nX7000000/0
oooo00@0000004l^R@1?;XT00000102LKI/00`000000`hjM0<>>W@020<>>W@030000003Z/9D0j[2E
00<0000000<0j;2G0000000000001@2fd^l2000000d0f/W9100000000`3oool000000>Z`U@040>Z`
U@L00000F@3oool00640oooo1@0000070?ooo`030000002B[nX0TZoZ00D0TZoZ1`00000?0?ooo`04
0000001?;XT0Cbj9000000@0W6fK00<000000<>>W@33SYd00P33SYd00`000000j[2E0>Z`U@040000
00T0]];_0P00000=0=[9b@@000000`3Z/9D5000005d0oooo001^0?ooo`030000002B[nX0TZoZ00L0
00003`3oool500000080Cbj900<0000009a]V`2LKI/00P2LKI/00`000000`hjM0<>>W@020<>>W@04
0000003Z/9D0j[2E000000<0:Ik_0P0000090;KBk`8000002`3JbLT4000000040>Z`U@0000000000
000000<0j[2E00<000000?ooo`3oool0F`3oool006l0oooo1@00000?0?ooo`H000000P3oool01000
0000Cbj904l^R@00000409a]V`0300000033SYd0`hjM0080`hjM00<000000>Z`U@3Z/9D00`000003
02VNk`8000002@2fd^l2000000P0f/W91`0000050>Z`U@030000003oool0oooo05/0oooo001o0?oo
o`H000001P3oool010000000Cbj904l^R@00000409a]V`0300000033SYd0`hjM0080`hjM00@00000
0>Z`U@3Z/9D000000P3oool2000000<0:Ik_0P0000090;KBk`8000001P3JbLT4000000<0f/W90P00
00020>Z`U@030000003oool0oooo05`0oooo001l0?ooo`D000002P3oool010000000Cbj904l^R@00
000409a]V`0300000033SYd0`hjM0080`hjM00@000000>Z`U@3Z/9D00000103oool300000080:Ik_
0P0000090;KBk`8000000`3JbLT5000000D0f/W90`00001N0?ooo`00NP3oool3000000h0oooo00@0
000004l^R@1?;XT00000102LKI/00`000000`hjM0<>>W@020<>>W@040000003Z/9D0j[2E000000L0
oooo0P00000202VNk`8000002@2fd^l2000000030=[9b@000000000000800000203JbLT00`000000
oooo0?ooo`1L0?ooo`00R`3oool00`000000Cbj90000000409a]V`0300000033SYd0`hjM00<0`hjM
00@000000>Z`U@3Z/9D000001@3oool600000080:Ik_0P0000090;KBk`D00000203JbLT3000005`0
oooo002;0?ooo`030000001?;XT0000000@0W6fK00<000000<>>W@33SYd00P33SYd01P000000j[2E
0>Z`U@3Z/9D000000?ooo`D000001@3oool200000080:Ik_0P0000050;KBk`8000000`3oool00`00
0000f/W90=[9b@060=[9b@P00000F03oool008X0oooo00@0000004l^R@1?;XT00000102LKI/00`00
0000`hjM0<>>W@020<>>W@030000003Z/9D0j[2E00@000002`3oool6000000030;KBk`0000000000
00<0oooo0P0000000`2fd^l00000000000060=[9b@80000000<0d[c50000000000001`00001D0?oo
o`00RP3oool010000000Cbj904l^R@00000409a]V`0300000033SYd0`hjM0080`hjM00<000000>Z`
U@3Z/9D00P00000A0?ooo`D0000000<0oooo0000000000001@2fd^l2000000<0f/W9100000020=:l
a@80000000D0gjNJ00000000000000000=5T>@0200000580oooo002:0?ooo`040000001?;XT0Cbj9
000000@0W6fK00<000000<>>W@33SYd00P33SYd00`000000j[2E0>Z`U@0200000180oooo1@000009
0;KBk`80000000<0f/W90000003oool0100000020=:la@<0000000<0gjNJ0000000000000P00001A
0?ooo`00RP3oool010000000Cbj904l^R@00000409a]V`0300000033SYd0`hjM0080`hjM00<00000
0>Z`U@3Z/9D00P00000D0?ooo`80000000<0:Ik_0000000000002@2fd^l010000000oooo0?ooo`3o
ool2000000030;?3iP000000d[c500<0d[c50P0000020=nWVP800000D03oool008P0oooo0`000002
04l^R@030000002LKI/0W6fK0080W6fK00<000000<>>W@33SYd00P33SYd00`000000j[2E0>Z`U@02
000001H0oooo0P0000000`0YW^l00000000000050;KBk`8000001@3oool5000000@0d[c50P000000
0`3OYiX000000?ooo`1?0?ooo`00Q03oool5000000050?ooo`000000Cbj904l^R@000000102LKI/0
0`000000`hjM0<>>W@020<>>W@030000003Z/9D0j[2E00800000603oool5000000030;KBk`000000
000000P0oooo00@00000052RmP000000/l?V0P0000040=:la@800000D03oool00800oooo1@000005
0?ooo`040000001?;XT0Cbj9000000@0W6fK00<000000<>>W@33SYd00P33SYd00`000000j[2E0>Z`
U@02000001/0oooo0`00000;0?ooo`<000000P2c`nH01@000000d[c50=:la@3B_<D000000540oooo
001n0?ooo`<000002@3oool010000000Cbj904l^R@00000409a]V`8000000`33SYd00`000000j[2E
0>Z`U@02000002/0oooo0`0000001@2c`nH000000000003B_<D000000540oooo002:0?ooo`030000
001?;XT0Cbj900P000000P33SYd00`000000j[2E0>Z`U@02000002`0oooo00@00000052RmP000000
/l?V0P00001B0?ooo`00RP3oool3000000030>R`U`000000`XjN0080`XjN0P0000000`2MKY`00000
00000002000000030>Z`U@000000000002d0oooo0`00001D0?ooo`00RP3oool200000080j;2G00@0
00000<:>WP32SYh0`XjN0P00000409e^W0@00000Q03oool008X0oooo0P0000020>R`U`0400000032
SYh0`XjN0<:>WP800000102MKY`010000000Dc:;0000000000240?ooo`00R`3oool2000000030>R`
U`000000`XjN0080`XjN0P00000409e^W0040000001C<X/00000000008@0oooo002=0?ooo`@00000
00<0`XjN0000000000000P2MKY`4000008H0oooo002A0?ooo`D00000RP3oool00980oooo0P00002<
0?ooo`00TP3oool2000008`0oooo002B0?ooo`800000S03oool00980oooo0P00002<0?ooo`00TP3o
ool2000008`0oooo002B0?ooo`800000S03oool00980oooo0P00002<0?ooo`00TP3oool2000008`0
oooo002B0?ooo`800000S03oool00940oooo0`00002<0?ooo`00TP3oool00`000000oooo0?ooo`2;
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.49128 .65238 m .50023 .65491 L .49965 .63135 L closepath p .308 .674 .975 r
F P
0 g
s
.4826 .65526 m .49128 .65238 L .49965 .63135 L closepath p .586 .936 .938 r
F P
0 g
s
.50023 .65491 m .50604 .66189 L .49965 .63135 L closepath p 0 .179 .713 r
F P
0 g
s
.47748 .66246 m .4826 .65526 L .49965 .63135 L closepath p 0 0 0 r
F P
0 g
s
.50604 .66189 m .5065 .67067 L .49965 .63135 L closepath p .811 .622 .066 r
F P
0 g
s
.4779 .67126 m .47748 .66246 L .49965 .63135 L closepath p 0 0 .43 r
F P
0 g
s
.5065 .67067 m .50141 .67791 L .49965 .63135 L closepath p .936 .963 .746 r
F P
0 g
s
.48371 .67828 m .4779 .67126 L .49965 .63135 L closepath p .299 .408 .806 r
F P
0 g
s
.50141 .67791 m .4927 .68082 L .49965 .63135 L closepath p .759 .876 .932 r
F P
0 g
s
.4927 .68082 m .48371 .67828 L .49965 .63135 L closepath p .551 .688 .93 r
F P
0 g
s
.54147 .61793 m .7274 .61451 L .73531 .6212 L p .361 0 0 r
F P
0 g
s
.48007 .5868 m .4772 .60219 L .49829 .59531 L p .718 .921 .961 r
F P
0 g
s
.49829 .59531 m .5015 .57984 L .48007 .5868 L p .718 .921 .961 r
F P
0 g
s
.5015 .57984 m .49829 .59531 L .52001 .60143 L p .477 .698 .965 r
F P
0 g
s
.52001 .60143 m .52358 .58606 L .5015 .57984 L p .477 .698 .965 r
F P
0 g
s
.52358 .58606 m .52001 .60143 L .53418 .61826 L p .147 .343 .802 r
F P
0 g
s
.46739 .60439 m .46472 .61954 L .4772 .60219 L p .864 .977 .673 r
F P
0 g
s
.4772 .60219 m .48007 .5868 L .46739 .60439 L p .864 .977 .673 r
F P
0 g
s
.53418 .61826 m .53801 .60314 L .52358 .58606 L p .147 .343 .802 r
F P
0 g
s
.53801 .60314 m .53418 .61826 L .53541 .63949 L p 0 0 .263 r
F P
0 g
s
.73531 .6212 m .54608 .62474 L .54147 .61793 L p .361 0 0 r
F P
0 g
s
.46838 .626 m .46569 .64084 L .46472 .61954 L p 0 0 .196 r
F P
0 g
s
.46472 .61954 m .46739 .60439 L .46838 .626 L p 0 0 .196 r
F P
0 g
s
.53541 .63949 m .53927 .62468 L .53801 .60314 L p 0 0 .263 r
F P
0 g
s
.53927 .62468 m .53541 .63949 L .52308 .65706 L p .831 .962 .631 r
F P
0 g
s
.26771 .62298 m .4579 .61947 L .461 .62633 L p .361 0 0 r
F P
0 g
s
.48281 .64334 m .47987 .65792 L .46569 .64084 L p .097 .316 .792 r
F P
0 g
s
.46569 .64084 m .46838 .626 L .48281 .64334 L p .097 .316 .792 r
F P
0 g
s
.52308 .65706 m .52675 .64248 L .53927 .62468 L p .831 .962 .631 r
F P
0 g
s
.52675 .64248 m .52308 .65706 L .50184 .66413 L p .706 .931 .964 r
F P
0 g
s
.50515 .64965 m .50184 .66413 L .47987 .65792 L p .455 .697 .971 r
F P
0 g
s
.47987 .65792 m .48281 .64334 L .50515 .64965 L p .455 .697 .971 r
F P
0 g
s
.50184 .66413 m .50515 .64965 L .52675 .64248 L p .706 .931 .964 r
F P
0 g
s
.461 .62633 m .26734 .62995 L .26771 .62298 L p .361 0 0 r
F P
0 g
s
.48806 .54384 m .48116 .5809 L .50273 .5739 L p .718 .921 .961 r
F P
0 g
s
.50273 .5739 m .51047 .53664 L .48806 .54384 L p .718 .921 .961 r
F P
0 g
s
.51047 .53664 m .50273 .5739 L .52496 .58016 L p .477 .698 .965 r
F P
0 g
s
.52496 .58016 m .53357 .54314 L .51047 .53664 L p .477 .698 .965 r
F P
0 g
s
.53357 .54314 m .52496 .58016 L .53948 .59733 L p .147 .343 .802 r
F P
0 g
s
.47482 .56208 m .46841 .59858 L .48116 .5809 L p .864 .977 .673 r
F P
0 g
s
.48116 .5809 m .48806 .54384 L .47482 .56208 L p .864 .977 .673 r
F P
0 g
s
.53948 .59733 m .5487 .5609 L .53357 .54314 L p .147 .343 .802 r
F P
0 g
s
.5487 .5609 m .53948 .59733 L .54075 .61899 L p 0 0 .263 r
F P
0 g
s
.47589 .58453 m .46941 .62031 L .46841 .59858 L p 0 0 .196 r
F P
0 g
s
.46841 .59858 m .47482 .56208 L .47589 .58453 L p 0 0 .196 r
F P
0 g
s
.54075 .61899 m .55006 .58327 L .5487 .5609 L p 0 0 .263 r
F P
0 g
s
.55006 .58327 m .54075 .61899 L .52816 .63689 L p .831 .962 .631 r
F P
0 g
s
.49101 .60257 m .48393 .63774 L .46941 .62031 L p .097 .316 .792 r
F P
0 g
s
.46941 .62031 m .47589 .58453 L .49101 .60257 L p .097 .316 .792 r
F P
0 g
s
.5441 .45535 m .67293 .32908 L .6793 .30844 L p .855 .997 .799 r
F P
0 g
s
.52816 .63689 m .53699 .60175 L .55006 .58327 L p .831 .962 .631 r
F P
0 g
s
.53699 .60175 m .52816 .63689 L .50642 .64409 L p .706 .931 .964 r
F P
0 g
s
.55244 .58541 m .68769 .5831 L .69442 .58882 L p .328 0 0 r
F P
0 g
s
.5144 .60917 m .50642 .64409 L .48393 .63774 L p .455 .697 .971 r
F P
0 g
s
.48393 .63774 m .49101 .60257 L .5144 .60917 L p .455 .697 .971 r
F P
0 g
s
.50642 .64409 m .5144 .60917 L .53699 .60175 L p .706 .931 .964 r
F P
0 g
s
.69442 .58882 m .55692 .5912 L .55244 .58541 L p .328 0 0 r
F P
0 g
s
.32356 .58932 m .46141 .58696 L .46436 .59281 L p .328 0 0 r
F P
0 g
s
.32974 .33127 m .47472 .45615 L .47772 .43713 L p .253 .456 .865 r
F P
0 g
s
.47772 .43713 m .33014 .31037 L .32974 .33127 L p .253 .456 .865 r
F P
0 g
s
.46436 .59281 m .32418 .59524 L .32356 .58932 L p .328 0 0 r
F P
0 g
s
.6793 .30844 m .54834 .43637 L .5441 .45535 L p .855 .997 .799 r
F P
0 g
s
.51244 .5206 m .50854 .44939 L .49272 .44733 L p .788 .571 .607 r
F P
0 g
s
.50854 .44939 m .51244 .5206 L .5293 .51826 L p .649 .464 .62 r
F P
0 g
s
.5293 .51826 m .52518 .44697 L .50854 .44939 L p .649 .464 .62 r
F P
0 g
s
.52518 .44697 m .5293 .51826 L .54074 .51254 L p .428 .296 .598 r
F P
0 g
s
.54074 .51254 m .53645 .44095 L .52518 .44697 L p .428 .296 .598 r
F P
0 g
s
.49272 .44733 m .49643 .51872 L .51244 .5206 L p .788 .571 .607 r
F P
0 g
s
.49643 .51872 m .49272 .44733 L .48364 .44154 L p .948 .7 .528 r
F P
0 g
s
.53645 .44095 m .54074 .51254 L .54237 .50556 L p 0 0 .254 r
F P
0 g
s
.54237 .50556 m .53803 .43357 L .53645 .44095 L p 0 0 .254 r
F P
0 g
s
.48364 .44154 m .48726 .51329 L .49643 .51872 L p .948 .7 .528 r
F P
0 g
s
.48726 .51329 m .48364 .44154 L .48486 .43414 L p 0 0 .206 r
F P
0 g
s
.53803 .43357 m .54237 .50556 L .53337 .49998 L p .954 .701 .517 r
F P
0 g
s
.53337 .49998 m .52912 .42763 L .53803 .43357 L p .954 .701 .517 r
F P
0 g
s
.55924 .55283 m .63732 .5516 L .63766 .53471 L p .726 .633 .755 r
F P
0 g
s
.63732 .5516 m .55924 .55283 L .56025 .56896 L p .72 .519 .617 r
F P
0 g
s
.56025 .56896 m .63855 .56768 L .63732 .5516 L p .72 .519 .617 r
F P
0 g
s
.48851 .5063 m .48486 .43414 L .49608 .42798 L p .417 .285 .592 r
F P
0 g
s
.48486 .43414 m .48851 .5063 L .48726 .51329 L p 0 0 .206 r
F P
0 g
s
.55944 .53588 m .63766 .53471 L .63945 .52327 L p .691 .751 .898 r
F P
0 g
s
.63766 .53471 m .55944 .53588 L .55924 .55283 L p .726 .633 .755 r
F P
0 g
s
.63855 .56768 m .56025 .56896 L .56211 .57826 L p .653 .286 .338 r
F P
0 g
s
.56211 .57826 m .6409 .57694 L .63855 .56768 L p .653 .286 .338 r
F P
0 g
s
.63945 .52327 m .56079 .52442 L .55944 .53588 L p .691 .751 .898 r
F P
0 g
s
.5151 .56768 m .51446 .55605 L .53101 .55379 L p .649 .464 .62 r
F P
0 g
s
.51446 .55605 m .51433 .54351 L .5276 .54168 L p .667 .554 .718 r
F P
0 g
s
.5276 .54168 m .53101 .55379 L .51446 .55605 L p .667 .554 .718 r
F P
0 g
s
.49936 .56596 m .49875 .5543 L .51446 .55605 L p .788 .571 .607 r
F P
0 g
s
.51446 .55605 m .5151 .56768 L .49936 .56596 L p .788 .571 .607 r
F P
0 g
s
.03 w
.50505 .60653 m
.51355 .56751 L
s
.5 Mabswid
.51433 .54351 m .51446 .55605 L .49875 .5543 L p .785 .65 .713 r
F P
0 g
s
.52912 .42763 m .53337 .49998 L .5171 .498 L p .79 .571 .604 r
F P
0 g
s
.5171 .498 m .51305 .42548 L .52912 .42763 L p .79 .571 .604 r
F P
0 g
s
.51433 .54351 m .51474 .53247 L .52212 .53145 L p .673 .64 .809 r
F P
0 g
s
.52212 .53145 m .5276 .54168 L .51433 .54351 L p .673 .64 .809 r
F P
0 g
s
.49875 .5543 m .50174 .54208 L .51433 .54351 L p .785 .65 .713 r
F P
0 g
s
.51474 .53247 m .51433 .54351 L .50174 .54208 L p .764 .717 .809 r
F P
0 g
s
.4999 .50043 m .49608 .42798 L .51305 .42548 L p .647 .461 .617 r
F P
0 g
s
.01 w
.51133 .44772 m
.51382 .49266 L
s
.5 Mabswid
.49608 .42798 m .4999 .50043 L .48851 .5063 L p .417 .285 .592 r
F P
0 g
s
.53101 .55379 m .53168 .56544 L .5151 .56768 L p .649 .464 .62 r
F P
0 g
s
.53168 .56544 m .53101 .55379 L .54224 .54836 L p .428 .296 .598 r
F P
0 g
s
.53101 .55379 m .5276 .54168 L .53659 .53728 L p .498 .45 .734 r
F P
0 g
s
.53659 .53728 m .54224 .54836 L .53101 .55379 L p .498 .45 .734 r
F P
0 g
s
.5276 .54168 m .52212 .53145 L .5271 .52898 L p .548 .581 .839 r
F P
0 g
s
.5271 .52898 m .53659 .53728 L .5276 .54168 L p .548 .581 .839 r
F P
0 g
s
.51612 .57617 m .5151 .56768 L .53168 .56544 L p .605 .324 .464 r
F P
0 g
s
.50346 .57481 m .49936 .56596 L .5151 .56768 L p .766 .441 .436 r
F P
0 g
s
.5151 .56768 m .51612 .57617 L .50346 .57481 L p .766 .441 .436 r
F P
0 g
s
.56079 .52442 m .63945 .52327 L .64204 .52169 L p .217 .73 .879 r
F P
0 g
s
.3447 .5562 m .45809 .55442 L .45812 .5374 L p .726 .633 .755 r
F P
0 g
s
.45809 .55442 m .3447 .5562 L .34511 .57249 L p .72 .519 .617 r
F P
0 g
s
.34511 .57249 m .45882 .57062 L .45809 .55442 L p .72 .519 .617 r
F P
0 g
s
.48976 .54917 m .49456 .53792 L .50174 .54208 L p .916 .793 .71 r
F P
0 g
s
.50174 .54208 m .49875 .5543 L .48976 .54917 L p .916 .793 .71 r
F P
0 g
s
.50774 .53166 m .50174 .54208 L .49456 .53792 L p .847 .839 .837 r
F P
0 g
s
.50174 .54208 m .50774 .53166 L .51474 .53247 L p .764 .717 .809 r
F P
0 g
s
.49036 .5609 m .48976 .54917 L .49875 .5543 L p .948 .7 .528 r
F P
0 g
s
.49875 .5543 m .49936 .56596 L .49036 .5609 L p .948 .7 .528 r
F P
0 g
s
.51305 .42548 m .5171 .498 L .4999 .50043 L p .647 .461 .617 r
F P
0 g
s
.01 w
.51414 .49842 m
.51526 .51862 L
s
.5 Mabswid
.5271 .52898 m .52212 .53145 L .51474 .53247 L p .601 .822 .984 r
F P
0 g
s
.52776 .526 m .5271 .52898 L p .51474 .53247 L .601 .822 .984 r
F P
0 g
s
.52383 .52364 m .52776 .526 L p .51474 .53247 L .601 .822 .984 r
F P
0 g
s
.51678 .52281 m .52383 .52364 L p .51474 .53247 L .601 .822 .984 r
F P
0 g
s
.50933 .52385 m .51678 .52281 L p .51474 .53247 L .601 .822 .984 r
F P
0 g
s
.01 w
.51526 .51862 m
.5155 .52299 L
s
.5 Mabswid
.50437 .52634 m .50933 .52385 L p .51474 .53247 L .601 .822 .984 r
F P
0 g
s
.50377 .52933 m .50437 .52634 L p .51474 .53247 L .601 .822 .984 r
F P
0 g
s
.51474 .53247 m .50774 .53166 L .50377 .52933 L p .601 .822 .984 r
F P
0 g
s
.53168 .56544 m .52948 .57438 L .51612 .57617 L p .605 .324 .464 r
F P
0 g
s
.52948 .57438 m .53168 .56544 L .54294 .56006 L p .295 .042 .35 r
F P
0 g
s
.54224 .54836 m .54294 .56006 L .53168 .56544 L p .428 .296 .598 r
F P
0 g
s
.6409 .57694 m .56211 .57826 L .56413 .57709 L p .166 .7 .841 r
F P
0 g
s
.56413 .57709 m .64351 .57576 L .6409 .57694 L p .166 .7 .841 r
F P
0 g
s
.34453 .53911 m .45812 .5374 L .45889 .5259 L p .691 .751 .898 r
F P
0 g
s
.45812 .5374 m .34453 .53911 L .3447 .5562 L p .726 .633 .755 r
F P
0 g
s
.49456 .53792 m .50377 .52933 L .50774 .53166 L p .847 .839 .837 r
F P
0 g
s
.49625 .57078 m .49036 .5609 L .49936 .56596 L p .889 .467 .174 r
F P
0 g
s
.49936 .56596 m .50346 .57481 L .49625 .57078 L p .889 .467 .174 r
F P
0 g
s
.45882 .57062 m .34511 .57249 L .34559 .58189 L p .653 .286 .338 r
F P
0 g
s
.34559 .58189 m .46004 .57997 L .45882 .57062 L p .653 .286 .338 r
F P
0 g
s
.64204 .52169 m .5628 .52284 L .56079 .52442 L p .217 .73 .879 r
F P
0 g
s
.54224 .54836 m .53659 .53728 L .53784 .53194 L p 0 .17 .689 r
F P
0 g
s
.53659 .53728 m .5271 .52898 L .52776 .526 L p .289 .504 .891 r
F P
0 g
s
.52776 .526 m .53784 .53194 L .53659 .53728 L p .289 .504 .891 r
F P
0 g
s
.51735 .57983 m .51612 .57617 L .52948 .57438 L p .423 0 .044 r
F P
0 g
s
.01 w
.5189 .58444 m
.51912 .58853 L
s
.5 Mabswid
.51029 .57907 m .50346 .57481 L .51612 .57617 L p .593 .07 0 r
F P
0 g
s
.51612 .57617 m .51735 .57983 L .51029 .57907 L p .593 .07 0 r
F P
0 g
s
.54294 .56006 m .54224 .54836 L .54384 .54176 L p 0 0 .254 r
F P
0 g
s
.53784 .53194 m .54384 .54176 L .54224 .54836 L p 0 .17 .689 r
F P
0 g
s
.49558 .53257 m .50437 .52634 L .50377 .52933 L p .831 .997 .842 r
F P
0 g
s
.50377 .52933 m .49456 .53792 L .49558 .53257 L p .831 .997 .842 r
F P
0 g
s
.02 w
.5496 .55083 m
.64147 .5494 L
s
.48086 .55191 m
.48445 .55185 L
s
.28751 .55493 m
.48086 .55191 L
s
.5 Mabswid
.52948 .57438 m .52479 .57883 L .51735 .57983 L p .423 0 .044 r
F P
0 g
s
.52479 .57883 m .52948 .57438 L .53852 .57009 L p 0 0 0 r
F P
0 g
s
.54294 .56006 m .53852 .57009 L .52948 .57438 L p .295 .042 .35 r
F P
0 g
s
.49101 .54256 m .49558 .53257 L .49456 .53792 L p .821 .877 .442 r
F P
0 g
s
.49456 .53792 m .48976 .54917 L .49101 .54256 L p .821 .877 .442 r
F P
0 g
s
.52115 .67954 m .51703 .60427 L .50079 .6026 L p .788 .571 .607 r
F P
0 g
s
.51703 .60427 m .52115 .67954 L .5385 .67736 L p .649 .464 .62 r
F P
0 g
s
.5385 .67736 m .53414 .602 L .51703 .60427 L p .649 .464 .62 r
F P
0 g
s
.5063 .57684 m .49625 .57078 L .50346 .57481 L p .405 0 0 r
F P
0 g
s
.50346 .57481 m .51029 .57907 L .5063 .57684 L p .405 0 0 r
F P
0 g
s
.54384 .54176 m .54455 .55352 L .54294 .56006 L p 0 0 .254 r
F P
0 g
s
.53852 .57009 m .54294 .56006 L .54455 .55352 L p .782 .849 .396 r
F P
0 g
s
.02 w
.54439 .55091 m
.5496 .55083 L
s
.5 Mabswid
.49161 .55435 m .49101 .54256 L .48976 .54917 L p 0 0 .207 r
F P
0 g
s
.48976 .54917 m .49036 .5609 L .49161 .55435 L p 0 0 .207 r
F P
0 g
s
.02 w
.49148 .55174 m
.54339 .55093 L
s
.48445 .55185 m
.49068 .55175 L
s
.5 Mabswid
.45889 .5259 m .34465 .52756 L .34453 .53911 L p .691 .751 .898 r
F P
0 g
s
.53784 .53194 m .52776 .526 L .52383 .52364 L p 0 .211 .619 r
F P
0 g
s
.53414 .602 m .5385 .67736 L .55031 .67232 L p .428 .296 .598 r
F P
0 g
s
.55031 .67232 m .54578 .59664 L .53414 .602 L p .428 .296 .598 r
F P
0 g
s
.5628 .52284 m .64204 .52169 L .64445 .53077 L p .648 .273 .321 r
F P
0 g
s
.34465 .52756 m .45889 .5259 L .46014 .52433 L p .217 .73 .879 r
F P
0 g
s
.50453 .52808 m .50933 .52385 L .50437 .52634 L p 0 0 0 r
F P
0 g
s
.50437 .52634 m .49558 .53257 L .50453 .52808 L p 0 0 0 r
F P
0 g
s
.49729 .56558 m .49161 .55435 L .49036 .5609 L p 0 .141 .672 r
F P
0 g
s
.49036 .5609 m .49625 .57078 L .49729 .56558 L p 0 .141 .672 r
F P
0 g
s
.52383 .52364 m .53077 .52769 L .53784 .53194 L p 0 .211 .619 r
F P
0 g
s
.54384 .54176 m .53784 .53194 L .53077 .52769 L p .883 .452 .138 r
F P
0 g
s
.50079 .6026 m .50471 .67807 L .52115 .67954 L p .788 .571 .607 r
F P
0 g
s
.50471 .67807 m .50079 .6026 L .49151 .59759 L p .948 .7 .528 r
F P
0 g
s
.51029 .57907 m .51735 .57983 L .52479 .57883 L p .591 .826 .989 r
F P
0 g
s
.53852 .57009 m .52982 .57645 L .52479 .57883 L p 0 0 0 r
F P
0 g
s
.52982 .57645 m .53852 .57009 L .53979 .56489 L p .819 .999 .83 r
F P
0 g
s
.54455 .55352 m .53979 .56489 L .53852 .57009 L p .782 .849 .396 r
F P
0 g
s
.64351 .57576 m .56413 .57709 L .56553 .56569 L p .689 .756 .903 r
F P
0 g
s
.56553 .56569 m .64537 .56439 L .64351 .57576 L p .689 .756 .903 r
F P
0 g
s
.53077 .52769 m .52383 .52364 L .51678 .52281 L p .573 .037 0 r
F P
0 g
s
.46004 .57997 m .34559 .58189 L .34598 .58074 L p .166 .7 .841 r
F P
0 g
s
.34598 .58074 m .46129 .57881 L .46004 .57997 L p .166 .7 .841 r
F P
0 g
s
.5063 .57684 m .51029 .57907 L p .52479 .57883 L .591 .826 .989 r
F P
0 g
s
.50691 .57398 m .5063 .57684 L p .52479 .57883 L .591 .826 .989 r
F P
0 g
s
.51192 .57157 m .50691 .57398 L p .52479 .57883 L .591 .826 .989 r
F P
0 g
s
.51943 .57056 m .51192 .57157 L p .52479 .57883 L .591 .826 .989 r
F P
0 g
s
.01 w
.51839 .57522 m
.5189 .58444 L
s
.5 Mabswid
.52654 .57133 m .51943 .57056 L p .52479 .57883 L .591 .826 .989 r
F P
0 g
s
.5305 .57359 m .52654 .57133 L p .52479 .57883 L .591 .826 .989 r
F P
0 g
s
.52479 .57883 m .52982 .57645 L .5305 .57359 L p .591 .826 .989 r
F P
0 g
s
.51802 .52621 m .51678 .52281 L .50933 .52385 L p .399 0 .004 r
F P
0 g
s
.50933 .52385 m .50453 .52808 L .51802 .52621 L p .399 0 .004 r
F P
0 g
s
.5022 .537 m .50453 .52808 L .49558 .53257 L p .272 .016 .33 r
F P
0 g
s
.49558 .53257 m .49101 .54256 L .5022 .537 L p .272 .016 .33 r
F P
0 g
s
.51678 .52281 m .51802 .52621 L .53077 .52769 L p .573 .037 0 r
F P
0 g
s
.01 w
.51576 .52766 m
.51814 .57073 L
s
.5 Mabswid
.64445 .53077 m .5647 .53196 L .5628 .52284 L p .648 .273 .321 r
F P
0 g
s
.50691 .57398 m .49729 .56558 L .49625 .57078 L p .263 .494 .891 r
F P
0 g
s
.49625 .57078 m .5063 .57684 L .50691 .57398 L p .263 .494 .891 r
F P
0 g
s
.54455 .55352 m .54384 .54176 L .53503 .5365 L p .954 .701 .517 r
F P
0 g
s
.53077 .52769 m .53503 .5365 L .54384 .54176 L p .883 .452 .138 r
F P
0 g
s
.53979 .56489 m .5305 .57359 L .52982 .57645 L p .819 .999 .83 r
F P
0 g
s
.46014 .52433 m .34503 .52599 L .34465 .52756 L p .217 .73 .879 r
F P
0 g
s
.54578 .59664 m .55031 .67232 L .55205 .66629 L p 0 0 .254 r
F P
0 g
s
.55205 .66629 m .54746 .59015 L .54578 .59664 L p 0 0 .254 r
F P
0 g
s
.53979 .56489 m .54455 .55352 L .53572 .54833 L p .921 .799 .708 r
F P
0 g
s
.53503 .5365 m .53572 .54833 L .54455 .55352 L p .954 .701 .517 r
F P
0 g
s
.50282 .54884 m .5022 .537 L .49101 .54256 L p .417 .285 .592 r
F P
0 g
s
.49101 .54256 m .49161 .55435 L .50282 .54884 L p .417 .285 .592 r
F P
0 g
s
.53503 .5365 m .53077 .52769 L .51802 .52621 L p .766 .435 .425 r
F P
0 g
s
.5647 .53196 m .64445 .53077 L .64573 .54714 L p .72 .517 .614 r
F P
0 g
s
.5305 .57359 m .53979 .56489 L .53269 .56078 L p .85 .846 .839 r
F P
0 g
s
.53572 .54833 m .53269 .56078 L .53979 .56489 L p .921 .799 .708 r
F P
0 g
s
.51907 .53467 m .51802 .52621 L .50453 .52808 L p .601 .315 .455 r
F P
0 g
s
.50453 .52808 m .5022 .537 L .51907 .53467 L p .601 .315 .455 r
F P
0 g
s
.49151 .59759 m .49533 .67346 L .50471 .67807 L p .948 .7 .528 r
F P
0 g
s
.49533 .67346 m .49151 .59759 L .49281 .59109 L p 0 0 .206 r
F P
0 g
s
.64537 .56439 m .56553 .56569 L .56575 .54838 L p .726 .635 .756 r
F P
0 g
s
.56575 .54838 m .64573 .54714 L .64537 .56439 L p .726 .635 .756 r
F P
0 g
s
.53269 .56078 m .52654 .57133 L .5305 .57359 L p .85 .846 .839 r
F P
0 g
s
.34503 .52599 m .46014 .52433 L .46138 .53349 L p .648 .273 .321 r
F P
0 g
s
.5063 .5612 m .50282 .54884 L .49161 .55435 L p .491 .445 .734 r
F P
0 g
s
.49161 .55435 m .49729 .56558 L .5063 .5612 L p .491 .445 .734 r
F P
0 g
s
.51802 .52621 m .51907 .53467 L .53503 .5365 L p .766 .435 .425 r
F P
0 g
s
.49729 .56558 m .50691 .57398 L .51192 .57157 L p .542 .58 .842 r
F P
0 g
s
.51192 .57157 m .5063 .5612 L .49729 .56558 L p .542 .58 .842 r
F P
0 g
s
.64573 .54714 m .56575 .54838 L .5647 .53196 L p .72 .517 .614 r
F P
0 g
s
.46129 .57881 m .34598 .58074 L .34611 .56926 L p .689 .756 .903 r
F P
0 g
s
.34611 .56926 m .46209 .56737 L .46129 .57881 L p .689 .756 .903 r
F P
0 g
s
.53572 .54833 m .53503 .5365 L .51907 .53467 L p .79 .571 .604 r
F P
0 g
s
.52654 .57133 m .53269 .56078 L .51986 .55936 L p .765 .721 .811 r
F P
0 g
s
.51986 .55936 m .51943 .57056 L .52654 .57133 L p .765 .721 .811 r
F P
0 g
s
.5063 .5612 m .51192 .57157 L .51943 .57056 L p .672 .642 .812 r
F P
0 g
s
.51974 .54652 m .51907 .53467 L .5022 .537 L p .647 .461 .617 r
F P
0 g
s
.03 w
.51478 .56186 m
.51829 .54573 L
s
.5 Mabswid
.5022 .537 m .50282 .54884 L .51974 .54652 L p .647 .461 .617 r
F P
0 g
s
.51943 .57056 m .51986 .55936 L .5063 .5612 L p .672 .642 .812 r
F P
0 g
s
.53269 .56078 m .53572 .54833 L .51974 .54652 L p .786 .651 .713 r
F P
0 g
s
.51907 .53467 m .51974 .54652 L .53572 .54833 L p .79 .571 .604 r
F P
0 g
s
.51974 .54652 m .51986 .55936 L .53269 .56078 L p .786 .651 .713 r
F P
0 g
s
.54746 .59015 m .55205 .66629 L .54286 .66156 L p .954 .701 .517 r
F P
0 g
s
.54286 .66156 m .53837 .58501 L .54746 .59015 L p .954 .701 .517 r
F P
0 g
s
.46138 .53349 m .34552 .53521 L .34503 .52599 L p .648 .273 .321 r
F P
0 g
s
.50282 .54884 m .5063 .5612 L .51986 .55936 L p .666 .554 .719 r
F P
0 g
s
.51986 .55936 m .51974 .54652 L .50282 .54884 L p .666 .554 .719 r
F P
0 g
s
.53946 .47998 m .52868 .47696 L .51947 .54031 L closepath p .545 .69 .934 r
F P
0 g
s
.54651 .48817 m .53946 .47998 L .51947 .54031 L closepath p .285 .401 .805 r
F P
0 g
s
.54713 .49843 m .54651 .48817 L .51947 .54031 L closepath p 0 0 .412 r
F P
0 g
s
.54107 .50685 m .54713 .49843 L .51947 .54031 L closepath p .612 .833 .445 r
F P
0 g
s
.53062 .51018 m .54107 .50685 L .51947 .54031 L closepath p .603 .939 .947 r
F P
0 g
s
.52868 .47696 m .51827 .48025 L .51947 .54031 L closepath p .757 .882 .935 r
F P
0 g
s
.51978 .50714 m .53062 .51018 L .51947 .54031 L closepath p .328 .68 .978 r
F P
0 g
s
.51217 .48861 m .51273 .49889 L .51947 .54031 L closepath p .779 .596 .029 r
F P
0 g
s
.51827 .48025 m .51217 .48861 L .51947 .54031 L closepath p .934 .967 .739 r
F P
0 g
s
.51273 .49889 m .51978 .50714 L .51947 .54031 L closepath p 0 .202 .73 r
F P
0 g
s
.03 w
.51941 .54059 m
.51947 .54031 L
s
.5 Mabswid
.34552 .53521 m .46138 .53349 L .46213 .54999 L p .72 .517 .614 r
F P
0 g
s
.49668 .66742 m .49281 .59109 L .5044 .58559 L p .417 .285 .592 r
F P
0 g
s
.49281 .59109 m .49668 .66742 L .49533 .67346 L p 0 0 .206 r
F P
0 g
s
.46209 .56737 m .34611 .56926 L .34593 .55179 L p .726 .635 .756 r
F P
0 g
s
.34593 .55179 m .46213 .54999 L .46209 .56737 L p .726 .635 .756 r
F P
0 g
s
.46213 .54999 m .34593 .55179 L .34552 .53521 L p .72 .517 .614 r
F P
0 g
s
.53837 .58501 m .54286 .66156 L .52615 .66001 L p .79 .571 .604 r
F P
0 g
s
.52615 .66001 m .52186 .58325 L .53837 .58501 L p .79 .571 .604 r
F P
0 g
s
.50844 .66226 m .5044 .58559 L .52186 .58325 L p .647 .461 .617 r
F P
0 g
s
.5044 .58559 m .50844 .66226 L .49668 .66742 L p .417 .285 .592 r
F P
0 g
s
.52186 .58325 m .52615 .66001 L .50844 .66226 L p .647 .461 .617 r
F P
0 g
s
.01 w
.5231 .66039 m
.52608 .71423 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00`P3oool00`000000oooo0?ooo`1K0?ooo`00GP3o
ool00`000000oooo0?ooo`1P0?ooo`800000G@3oool005h0oooo0P00001P0?ooo`030000003Jol`0
000005d0oooo001N0?ooo`0300000010M=d0000005h0oooo00@000000=[oc03Jol`00000G@3oool0
05h0oooo00<00000041dg@10M=d00P00001K0?ooo`040000003Jol`0f_o<000005h0oooo001N0?oo
o`0300000010M=d0@7CM0080@7CM00<000000?ooo`3oool0E`3oool01@000000f_o<0=[oc03Jol`0
000005h0oooo001N0?ooo`0300000010M=d0@7CM00<0@7CM00<000000?ooo`3oool0E@3oool00`00
0000f_o<0=[oc0020=[oc0030000003oool0oooo05`0oooo001N0?ooo`0300000010M=d0@7CM00@0
@7CM00<000000?ooo`3oool0D`3oool00`000000f_o<0=[oc0020=[oc0030000003oool0oooo05d0
oooo001O0?ooo`0300000010M=d0@7CM00@0@7CM00<000000?ooo`3oool0D@3oool00`000000f_o<
0=[oc0020=[oc0030000003oool0oooo05h0oooo001P0?ooo`0300000010M=d0@7CM00@0@7CM0P00
001@0?ooo`030000003Jol`0f_o<0080f_o<00<000000?ooo`3oool0G`3oool00640oooo0P000006
041dg@030000003oool0oooo04`0oooo00<000000=[oc03Jol`00P3Jol`00`000000oooo0?ooo`1P
0?ooo`00H`3oool00`000000@7CM041dg@04041dg@030000003oool0oooo04X0oooo00<000000=[o
c03Jol`00P3Jol`00`000000oooo0?ooo`1Q0?ooo`00I03oool00`000000@7CM041dg@04041dg@03
0000003oool0oooo04P0oooo00<000000=[oc03Jol`00P3Jol`00`000000oooo0?ooo`1R0?ooo`00
I@3oool00`000000@7CM041dg@04041dg@030000003oool0oooo04H0oooo00<000000=[oc03Jol`0
0P3Jol`00`000000oooo0?ooo`1S0?ooo`00IP3oool00`000000@7CM041dg@04041dg@800000A@3o
ool00`000000f_o<0=[oc0020=[oc0030000003oool0oooo06@0oooo001W0?ooo`8000001P10M=d0
0`000000oooo0?ooo`110?ooo`030000003Jol`0f_o<0080f_o<00<000000?ooo`3oool0I@3oool0
06T0oooo00<00000041dg@10M=d01010M=d00`000000oooo0?ooo`0o0?ooo`030000003Jol`0f_o<
0080f_o<00<000000?ooo`3oool0IP3oool006X0oooo00<00000041dg@10M=d01010M=d00`000000
oooo0?ooo`0m0?ooo`030000003Jol`0f_o<0080f_o<00<000000?ooo`3oool0I`3oool006/0oooo
00<00000041dg@10M=d01010M=d00`000000oooo0?ooo`0k0?ooo`030000003Jol`0f_o<0080f_o<
00<000000?ooo`3oool0J03oool006`0oooo00<00000041dg@10M=d01010M=d2000003X0oooo00<0
00000=[oc03Jol`00P3Jol`00`000000oooo0?ooo`1Y0?ooo`00K@3oool2000000H0@7CM00<00000
0?ooo`3oool0=P3oool00`000000f_o<0=[oc0020=[oc0030000003oool0oooo06X0oooo001_0?oo
o`0300000010M=d0@7CM00@0@7CM00<000000?ooo`3oool0=03oool00`000000f_o<0=[oc0020=[o
c0030000003oool0oooo06/0oooo001`0?ooo`0300000010M=d0@7CM00@0@7CM00<000000?ooo`3o
ool0<P3oool00`000000f_o<0=[oc0020=[oc0030000003oool0oooo06`0oooo001a0?ooo`030000
0010M=d0@7CM00@0@7CM00<000000?ooo`3oool0<03oool00`000000f_o<0=[oc0020=[oc0030000
003oool0oooo06d0oooo001b0?ooo`0300000010M=d0@7CM00@0@7CM0P00000_0?ooo`040000003J
ol`0f_o<0=[oc0800000L03oool007<0oooo0P000006041dg@030000003oool0oooo02/0oooo00D0
00000=[oc03Jol`0f_o<0000001b0?ooo`00M@3oool00`000000@7CM041dg@04041dg@030000003o
ool0oooo02T0oooo00D000000=[oc03Jol`0f_o<0000001c0?ooo`00MP3oool00`000000@7CM041d
g@04041dg@030000003oool0oooo02L0oooo00D000000=[oc03Jol`0f_o<0000001d0?ooo`00M`3o
ool00`000000@7CM041dg@04041dg@030000003oool0oooo02D0oooo00D000000=[oc03Jol`0f_o<
0000001e0?ooo`00N03oool00`000000@7CM041dg@04041dg@800000903oool01@000000f_o<0=[o
c03Jol`0000007H0oooo001i0?ooo`8000001P10M=d00`000000oooo0?ooo`0P0?ooo`050000003J
ol`0f_o<0=[oc0000000M`3oool007/0oooo00<00000041dg@10M=d01010M=d00`000000oooo0?oo
o`0N0?ooo`050000003Jol`0f_o<0=[oc0000000N03oool007`0oooo00<00000041dg@10M=d01010
M=d00`000000oooo0?ooo`0L0?ooo`050000003Jol`0f_o<0=[oc0000000N@3oool007d0oooo00<0
0000041dg@10M=d01010M=d00`000000oooo0?ooo`0J0?ooo`050000003Jol`0f_o<0=[oc0000000
NP3oool007h0oooo00<00000041dg@10M=d01010M=d2000000L0oooo2P0000080?ooo`050000003J
ol`0f_o<0=[oc0000000N`3oool007l0oooo0P000006041dg@030000003oool0oooo0080oooo0`00
00040:EfW@040000003:TYX0bY:J0<ZBVP<000001@3oool01@000000f_o<0=[oc03Jol`0000007`0
oooo00210?ooo`0300000010M=d0@7CM00@0@7CM00@000000?ooo`3oool000000P1ZB9L00`000000
YGJM0:EfW@020:EfW@050000003:TYX0bY:J0<ZBVP0000000P3d/h@01@000000oooo0?ooo`3oool0
000000<0f_o<00<000000?ooo`3oool0N`3oool00880oooo00<00000041dg@10M=d01010M=d00`00
0000oooo0000000206Y8U`030000002UMYd0YGJM0080YGJM00D000000<ZBVP3:TYX0bY:J00000002
0?BcQ0040000003oool0oooo000000<0f_o<00<000000?ooo`3oool0O03oool008<0oooo00<00000
041dg@10M=d00`10M=d300000080JTRG00<000000:EfW@2UMYd00P2UMYd01@000000bY:J0<ZBVP3:
TYX000000080m;>400@000000?ooo`3oool000000P3Jol`00`000000oooo0?ooo`1m0?ooo`00Q03o
ool00`000000@7CM041dg@02041dg@<000000P1ZB9L010000000YGJM0:EfW@2UMYd2000000<0bY:J
00@000000?BcQ03d/h@000000P3oool00`000000f_o<000000200?ooo`00Q@3oool200000003041d
g@000000oooo008000000P1ZB9L01P000000YGJM0:EfW@000000YGJM000000@0bY:J00L000000?Bc
Q0000000oooo0000003Jol`000000840oooo00270?ooo`80000000<0oooo0000000000000P1ZB9L0
0`000000YGJM0:EfW@020:EfW@030000003:TYX0bY:J0080bY:J00@000000?BcQ0000000oooo0P00
00220?ooo`00R03oool010000000oooo00000000000206Y8U`030000002UMYd0YGJM0080YGJM00<0
00000<ZBVP3:TYX00P3:TYX01@000000m;>40000003oool0000008<0oooo002:0?ooo`8000000P1Z
B9L00`000000YGJM0:EfW@020:EfW@030000003:TYX0bY:J0080bY:J00<000000?BcQ0000000Q@3o
ool008X0oooo0P00000206Y8U`030000002UMYd0YGJM0080YGJM00<000000<ZBVP3:TYX00P3:TYX0
0`000000m;>4000000250?ooo`00RP3oool2000000<0JTRG00<000000:EfW@2UMYd00P2UMYd01`00
0000bY:J0<ZBVP3:TYX000000?BcQ0000000Q@3oool008X0oooo0P00000306Y8U`030000002UMYd0
YGJM0080YGJM00L000000<ZBVP3:TYX0bY:J0000003d/h@0000008D0oooo002:0?ooo`0300000000
03@000000080JTRG00<000000:EfW@2UMYd00P2UMYd01@000000bY:J0<ZBVP3:TYX000000080m;>4
00<000000?ooo`3oool0PP3oool008X0oooo00<000000000=00000000P1ZB9L00`000000YGJM0:Ef
W@020:EfW@030000003:TYX00000008000000P3d/h@00`000000oooo0?ooo`220?ooo`00R`3oool0
1@0003@0000006Y8U`1ZB9L0000000@0YGJM0P0000000`31hNl0000008^`k`03000008@0oooo002;
0?ooo`050000=0000000JTRG06Y8U`0000000`2UMYd200000080`N7_00<0000008^`k`2;/>l00P00
00240?ooo`00R`3oool01@0003@0000006Y8U`1ZB9L0000000<0YGJM0P0000020<7Qk`050000002;
/>l0000004QVcP000000Q03oool008/0oooo00D0000d0000001ZB9L0JTRG000000020:EfW@030000
003_mkd000000080`N7_00<0000008^`k`0000000P18I/h00`000000oooo0?ooo`210?ooo`00R`3o
ool01@0003@0000006Y8U`1ZB9L000000080YGJM00D000000>og_@000000`N7_0000000208^`k`04
00000018I/h0B6K>000008<0oooo002;0?ooo`050000=0000000JTRG06Y8U`0000000P2UMYd01@00
0000koNm00000031hNl000000080Rk3_00D0000004QVcP000000001Y000000220?ooo`00R`3oool0
100003@0000006Y8U`1ZB9L6000000040<7Qk`000000Rk3_00000080B6K>00<000000000J@000000
PP3oool008/0oooo00@0000d00000000000000000`39TY/3000000080<7Qk`000000Rk3_00000018
I/h000000000J@0000230?ooo`00R`3oool0100003@000000?:cQ`0000030<VBV`80000000H003>j
000000000000Rk3_00000018I/h3000008<0oooo002;0?ooo`040000=0000000l[>7000000<0bI:K
0P0000000`00<kX0000005>^nP05000008@0oooo002;0?ooo`80000000<0l[>700000039TY/00P39
TY/400000080Djkj00@0000009[`lP0000000000Q03oool008d0oooo100000000`39TY/000000000
00020000000305>^nP000000V_3b00800000Q@3oool00940oooo1@000000101C[_X0000009[`lP00
000C0?ooo``00000I`3oool006<0oooo8P00000<0?ooo`D0000000<0Djkj0000000000001`3oool=
000000/0YDEB00<000000?ooo`3oool0I@3oool00680oooo0P00000P0:E5DP030000003oool0oooo
00P0oooo2`0000060?ooo`8000005P2UAE800`000000oooo0?ooo`1U0?ooo`00HP3oool200000200
YDEB00<000000?ooo`3oool01`3oool00`000000A@AD0000000:000000D0oooo00<000000;30i@00
00005P00001W0?ooo`00HP3ooolS000000P0oooo00<0000004D4E01515@02P0000000`3RLb<00000
0?ooo`030?ooo`<000005@2hQ9d00`000000oooo0?ooo`1U0?ooo`00HP3oool200000200^8BM00<0
00000?ooo`3oool01P3oool?000000@0oooo00<000000;VR`@0000005@2hQ9d00`000000oooo0?oo
o`1U0?ooo`00HP3oool200000200^8BM00<000000?ooo`3oool01@3oool200000080JTRG2P000002
0?BcQ0070000003oool0oooo0?ooo`000000^J;10000000F0;R4W@800000I@3oool00680oooo0P00
000P0;R4W@T000000`1ZB9L:00000080m;>41`00000F0;R4W@800000I@3oool00500oooo5000000@
0;R4WAT000000`1ZB9L;000000030?BcQ0000000000001d00000I@3oool00500oooo9000000@0;VR
`AH0000000<0jlbe0000000000001P00000F0;VR`@800000I@3oool00500oooo5000000P0;VR`@X0
00000P1mLK/9000000<0jlbe1`00000F0;VR`@800000I@3oool00500oooo5000000P0;VR`@X00000
0P1mLK/2000000030:Z=^0000000000000@000000P3[c;D8000001H0^J;100<000000?ooo`3oool0
I03oool00500oooo5000000P0;VR`@050000003oool0oooo0?ooo`0000000P3MnZ`00`000000]n_f
0000000500000080[:C?1@000000103[c;D0000002EGc@0000020?ooo`030000002hQ9d0000000/0
^J;13000001V0?ooo`00H`3oool00`000000^J;10;VR`@0>0;VR`A4000000`3oool01@000000gOZ/
0=gj[0000000]n_f00H000000P2/Y<l300000080fMSF00@0000002EGc@00000000000P3oool00`00
0000^8BM0000000;000000/0/<7W00<000000?ooo`3oool0I03oool006<0oooo4@00000@0;31i`05
0000003oool0oooo0?ooo`0000000P3MnZ`00`000000]n_f0;O[mP0:000000040=WHeP0000000000
02EGc@8000000P3oool3000001H0/<7W00<000000?ooo`3oool0I03oool006<0oooo00<000000;31
i`2``NL07P2``NL00`000000oooo0?ooo`02000000030=gj[0000000]n_f00<0]n_f200000000`2G
dod000000000000202EGc@8000000P3oool2000001H0/<7W00<000000?ooo`3oool0I@3oool006<0
oooo00<000000;31i`2``NL07P2``NL00`000000oooo0?ooo`02000000030=gj[0000000]n_f00H0
000000<0Um?m0000000000001000000302EGc@8000000`3ooolH000006L0oooo001S0?ooob800000
0P3oool2000000030=gj[000000000000080oooo1`0000000`2Gdod0000002EGc@0302EGc@030000
000004<000000880oooo001S0?oooa4000004`3oool3000000030?ooo`000000000000l0000000<0
00130000003oool04`3ooolD000005X0oooo001`0?oooaD000000P3oool4000000<0]n_f1@000002
0:EfW@030000003:TYX0bY:J0080bY:J600000000`1C000000000000000C000005P0oooo001L0?oo
oa@00000501C00001`000000oooo000000000380000001Q@bP0000000P2gjoH20000000306Y8U`00
0000YGJM00<0YGJM00<000000<ZBVP3:TYX00P3:TYX01@000000m;>40?BcQ0000000oooo01@00000
K@3oool005d0oooo:`00000201Q@bP040000002gjoH0]n_f00000080JTRG00<000000:EfW@2UMYd0
0P2UMYd00`000000bY:J0<ZBVP020<ZBVP040000003d/h@0m;>400000880oooo00260?ooo`800000
0`0HD<X300000080JTRG00<000000:EfW@2UMYd00P2UMYd00`000000bY:J0<ZBVP020<ZBVP040000
003d/h@0m;>400000880oooo00260?ooo`800000100HD<X200000080JTRG00<000000:EfW@2UMYd0
0P2UMYd00`000000bY:J0<ZBVP020<ZBVP040000003d/h@0m;>400000880oooo00260?ooo`800000
100HD<X200000080JTRG00<000000:EfW@2UMYd00`2UMYd01@000000bY:J0<ZBVP3:TYX000000080
m;>400<000000?ooo`3oool0P03oool008H0oooo0P00000401Q@bP8000000P1ZB9L00`000000YGJM
0:EfW@030:EfW@050000003:TYX0bY:J0<ZBVP0000000P3d/h@00`000000oooo0?ooo`200?ooo`00
QP3oool2000000<0653:0`00000206Y8U`030000002UMYd0YGJM00<0YGJM00D000000<ZBVP3:TYX0
bY:J000000020?BcQ0030000003oool0oooo0800oooo00250?ooo`800000100HD<X300000080JTRG
00<000000:EfW@2UMYd00`2UMYd01@000000bY:J0<ZBVP3:TYX000000080m;>400<000000?ooo`3o
ool05P3ooolK000004l0oooo001X0?oooa`0000000<0oooo000000000000100HD<X300000080JTRG
00<000000:EfW@2UMYd00`2UMYd01@000000bY:J0<ZBVP3:TYX000000080m;>46@00000K05`00080
0000C@3oool004`0oooo7000000K05`000040000003oool00000000000@0653:00<0000007Bbn000
00000P1ZB9L00`000000YGJM0:EfW@030:EfW@050000003:TYX0bY:J0<ZBVP0000000P3d/h@00`00
0000G00005`0000H05`001`00000C03oool004`0oooo00<0000005`0001L00006@1L000P000000<0
653:00<0000007Bbn00000000P1ZB9L00`000000YGJM0:EfW@030:EfW@030000003:TYX0bY:J0080
bY:J00<000000?BcQ00000006P00001X0?ooo`00C03ooolL000001d0oooo1000000201Q@bP030000
001d/_P0000000<0JTRG00<000000:EfW@2UMYd00P2UMYd00`000000bY:J0<ZBVP020<ZBVP030000
003d/h@000000880oooo00250?ooo`80000000@0653:0000000HD<X000000P1d/_P200000080JTRG
00<000000:EfW@2UMYd00P2UMYd00`000000bY:J0<ZBVP020<ZBVP040000003d/h@0m;>400000840
oooo00250?ooo`030000000HD<X0653:00<000000P1d/_P200000080JTRG00<000000:EfW@2UMYd0
0P2UMYd00`000000bY:J0<ZBVP020<ZBVP040000003d/h@0m;>400000840oooo00250?ooo`040000
000HD<X0653:01Q@bPH000000P1ZB9L00`000000YGJM0:EfW@020:EfW@030000003:TYX0bY:J0080
bY:J00@000000?BcQ03d/h@00000P@3oool008H0oooo00@0000001Q@bP0HD<X0653:0P0000000`3o
ool000000000000206Y8U`030000002UMYd0YGJM00<0YGJM00D000000<ZBVP3:TYX0bY:J00000002
0?BcQ0030000003oool0oooo07l0oooo00270?ooo`050000000HD<X0653:0000001d/_P00`000002
06Y8U`030000002UMYd0YGJM00<0YGJM00D000000<ZBVP3:TYX0bY:J000000020?BcQ0030000003o
ool0oooo07l0oooo00270?ooo`040000000HD<X0653:000000<0M;;h00@0000006Y8U`1ZB9L00000
1@2UMYd01@000000bY:J0<ZBVP3:TYX000000080m;>400<000000?ooo`3oool0O`3oool008P0oooo
0P00000407Bbn0040000001ZB9L0JTRG000000D0YGJM00D000000<ZBVP3:TYX0bY:J000000020?Bc
Q0030000003oool0oooo07l0oooo00290?ooo`8000000`1d/_P010000000JTRG06Y8U`0000050:Ef
W@050000003:TYX0bY:J0<ZBVP0000000P3d/h@00`000000oooo0?ooo`1o0?ooo`00RP3oool50000
0080JTRG00<000000:EfW@2UMYd0200000020?BcQ0030000003oool0oooo07l0oooo00290?ooo`80
000000D0C6S>0000002=/>h0000006Y8U`04000000030<VBV`000000000000<0YWJN00<0000006e;
V@0000000P0000210?ooo`00R@3oool300000080SK3^0`0000040<VBV`8000000`2VMYh00`000000
KD^I06e;V@0200000840oooo00290?ooo`040000001<J<h0000008f`kP80000000<0l[>700000039
TY/00`39TY/2000000<0YWJN00@0000006e;V@1]BiT00000PP3oool008T0oooo0P00000208f`kP80
000000<0l[>700000039TY/00`39TY/2000000<0YWJN0`0000230?ooo`00RP3oool20000000308f`
kP000000000000@000000P39TY/2000000040:IfWP0000000000000008D0oooo002<0?ooo`800000
1@3oool5000008P0oooo002E0?ooo`800000R@3oool009D0oooo0P0000290?ooo`00U@3oool20000
08T0oooo002E0?ooo`800000R@3oool009D0oooo0P0000290?ooo`00U@3oool2000008T0oooo002E
0?ooo`800000R@3oool009D0oooo0P0000290?ooo`00U@3oool2000008T0oooo002E0?ooo`800000
R@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.39208 .60838 m .51848 .63401 L .54702 .64378 L p .354 0 0 r
F P
0 g
s
.54702 .64378 m .42077 .61842 L .39208 .60838 L p .354 0 0 r
F P
0 g
s
.51015 .45778 m .58211 .35983 L .614 .34536 L p .199 0 .077 r
F P
0 g
s
.29422 .64128 m .29508 .65052 L .35714 .61481 L closepath p .427 .319 .628 r
F P
0 g
s
.28936 .63306 m .29422 .64128 L .35714 .61481 L closepath p .506 .525 .81 r
F P
0 g
s
.28234 .62897 m .28936 .63306 L .35714 .61481 L closepath p .516 .723 .967 r
F P
0 g
s
.29508 .65052 m .29162 .6573 L .35714 .61481 L closepath p .168 0 .203 r
F P
0 g
s
.42959 .61293 m .42209 .62917 L p .48739 .59295 L .347 .052 .314 r
F P
0 g
s
.55 .60302 m .57706 .61182 L p .46566 .5845 L .31 0 0 r
F P
0 g
s
.46495 .58422 m .55 .60302 L p .46566 .5845 L .31 0 0 r
F P
0 g
s
.57706 .61182 m .48797 .59225 L .47251 .58716 L p .31 0 0 r
F P
0 g
s
.47251 .58716 m .46076 .5833 L p .46566 .5845 L .31 0 0 r
F P
0 g
s
.57706 .61182 m .47251 .58716 L .46566 .5845 L .31 0 0 r
F
.42209 .62917 m .49449 .60149 L .49665 .59655 L p .347 .052 .314 r
F P
0 g
s
.49665 .59655 m .50168 .58502 L p .48739 .59295 L .347 .052 .314 r
F P
0 g
s
.42209 .62917 m .49665 .59655 L .48739 .59295 L .347 .052 .314 r
F
.50168 .58502 m .4843 .59175 L p .48739 .59295 L F P
0 g
s
.4843 .59175 m .42959 .61293 L p .48739 .59295 L .347 .052 .314 r
F P
0 g
s
.46076 .5833 m .46495 .58422 L p .46566 .5845 L .31 0 0 r
F P
0 g
s
.2758 .63058 m .28234 .62897 L .35714 .61481 L closepath p 0 0 0 r
F P
0 g
s
.29162 .6573 m .28511 .65901 L .35714 .61481 L closepath p .614 .954 .908 r
F P
0 g
s
.27226 .63733 m .2758 .63058 L .35714 .61481 L closepath p .448 .149 .365 r
F P
0 g
s
.28511 .65901 m .27803 .65495 L .35714 .61481 L closepath p .666 .749 .912 r
F P
0 g
s
.51352 .44291 m .49657 .44542 L p .50493 .46779 L .682 .504 .638 r
F P
0 g
s
.52289 .51583 m .51567 .45967 L p .50493 .46779 L .682 .504 .638 r
F P
0 g
s
.614 .34536 m .55064 .43327 L p .51015 .45778 L .199 0 .077 r
F P
0 g
s
.52886 .44972 m .51015 .45778 L p .55064 .43327 L .199 0 .077 r
F P
0 g
s
.51567 .45967 m .51352 .44291 L p .50493 .46779 L .682 .504 .638 r
F P
0 g
s
.55064 .43327 m .54326 .44352 L .52886 .44972 L p .199 0 .077 r
F P
0 g
s
.27311 .64666 m .27226 .63733 L .35714 .61481 L closepath p .556 .414 .643 r
F P
0 g
s
.27803 .65495 m .27311 .64666 L .35714 .61481 L closepath p .612 .573 .786 r
F P
0 g
s
.40395 .57535 m .37353 .58765 L .38496 .60733 L p .57 .554 .797 r
F P
0 g
s
.03 w
.35714 .61481 m
.37614 .60727 L
s
.5 Mabswid
.38496 .60733 m .41545 .59527 L .40395 .57535 L p .57 .554 .797 r
F P
0 g
s
.41545 .59527 m .38496 .60733 L .38731 .6293 L p .505 .378 .64 r
F P
0 g
s
.38764 .56508 m .35721 .57757 L .37353 .58765 L p .609 .74 .938 r
F P
0 g
s
.37353 .58765 m .40395 .57535 L .38764 .56508 L p .609 .74 .938 r
F P
0 g
s
.38731 .6293 m .41793 .61745 L .41545 .59527 L p .505 .378 .64 r
F P
0 g
s
.41793 .61745 m .38731 .6293 L .37964 .6454 L p .347 .052 .314 r
F P
0 g
s
.37259 .56848 m .34209 .58104 L .35721 .57757 L p .417 .865 .843 r
F P
0 g
s
.35721 .57757 m .38764 .56508 L .37259 .56848 L p .417 .865 .843 r
F P
0 g
s
.37964 .6454 m .41038 .63365 L .41793 .61745 L p .347 .052 .314 r
F P
0 g
s
.41038 .63365 m .37964 .6454 L .36466 .64942 L p .35 .824 .787 r
F P
0 g
s
.48715 .54169 m .41553 .57066 L .42707 .59068 L p .57 .554 .797 r
F P
0 g
s
.42707 .59068 m .49885 .56228 L .48715 .54169 L p .57 .554 .797 r
F P
0 g
s
.49885 .56228 m .42707 .59068 L .42959 .61293 L p .505 .378 .64 r
F P
0 g
s
.36462 .58455 m .334 .59701 L .34209 .58104 L p .318 .016 .284 r
F P
0 g
s
.34209 .58104 m .37259 .56848 L .36462 .58455 L p .318 .016 .284 r
F P
0 g
s
.47086 .53089 m .39922 .56032 L .41553 .57066 L p .609 .74 .938 r
F P
0 g
s
.41553 .57066 m .48715 .54169 L .47086 .53089 L p .609 .74 .938 r
F P
0 g
s
.36466 .64942 m .39548 .63762 L .41038 .63365 L p .35 .824 .787 r
F P
0 g
s
.39548 .63762 m .36466 .64942 L .34803 .63955 L p .6 .745 .946 r
F P
0 g
s
.42959 .61293 m .50168 .58502 L .49885 .56228 L p .505 .378 .64 r
F P
0 g
s
.52583 .55817 m .57599 .57021 L .58175 .55446 L p .869 .784 .765 r
F P
0 g
s
.57599 .57021 m .52583 .55817 L .52792 .57449 L p .896 .655 .567 r
F P
0 g
s
.52792 .57449 m .57814 .58616 L .57599 .57021 L p .896 .655 .567 r
F P
0 g
s
.36699 .60721 m .33625 .61945 L .334 .59701 L p .496 .368 .636 r
F P
0 g
s
.334 .59701 m .36462 .58455 L .36699 .60721 L p .496 .368 .636 r
F P
0 g
s
.5317 .54202 m .58175 .55446 L .59327 .54482 L p .755 .862 .928 r
F P
0 g
s
.58175 .55446 m .5317 .54202 L .52583 .55817 L p .869 .784 .765 r
F P
0 g
s
.45605 .53412 m .3842 .5637 L .39922 .56032 L p .417 .865 .843 r
F P
0 g
s
.39922 .56032 m .47086 .53089 L .45605 .53412 L p .417 .865 .843 r
F P
0 g
s
.34803 .63955 m .37885 .62756 L .39548 .63762 L p .6 .745 .946 r
F P
0 g
s
.37885 .62756 m .34803 .63955 L .33625 .61945 L p .563 .552 .8 r
F P
0 g
s
.57814 .58616 m .52792 .57449 L .53723 .58483 L p .789 .325 .136 r
F P
0 g
s
.53723 .58483 m .58744 .5963 L .57814 .58616 L p .789 .325 .136 r
F P
0 g
s
.49449 .60149 m .42209 .62917 L .40722 .63312 L p .35 .824 .787 r
F P
0 g
s
.33625 .61945 m .36699 .60721 L .37885 .62756 L p .563 .552 .8 r
F P
0 g
s
.17984 .56533 m .33085 .59596 L .35955 .60612 L p .354 0 0 r
F P
0 g
s
.54333 .53209 m .59327 .54482 L .60626 .54497 L p .197 .69 .921 r
F P
0 g
s
.59327 .54482 m .54333 .53209 L .5317 .54202 L p .755 .862 .928 r
F P
0 g
s
.58744 .5963 m .53723 .58483 L .55029 .5852 L p .149 .665 .892 r
F P
0 g
s
.55029 .5852 m .60043 .59672 L .58744 .5963 L p .149 .665 .892 r
F P
0 g
s
.60626 .54497 m .55639 .53219 L .54333 .53209 L p .197 .69 .921 r
F P
0 g
s
.55639 .53219 m .60626 .54497 L .61575 .55501 L p .782 .305 .101 r
F P
0 g
s
.37628 .5798 m .3842 .5637 L p .3852 .56349 L .318 .016 .284 r
F P
0 g
s
.40092 .56977 m .37628 .5798 L p .3852 .56349 L .318 .016 .284 r
F P
0 g
s
.37628 .5798 m .44844 .55043 L .45116 .57368 L p .496 .368 .636 r
F P
0 g
s
.29344 .54632 m .39683 .56917 L .41217 .57426 L p .31 0 0 r
F P
0 g
s
.45116 .57368 m .3787 .60254 L .37628 .5798 L p .496 .368 .636 r
F P
0 g
s
.41217 .57426 m .4241 .57822 L p .41893 .57696 L .31 0 0 r
F P
0 g
s
.41893 .57696 m .29344 .54632 L .41217 .57426 L .31 0 0 r
F
.44844 .55043 m .40092 .56977 L p .3852 .56349 L .318 .016 .284 r
F P
0 g
s
.3842 .5637 m .45605 .53412 L .44844 .55043 L p .318 .016 .284 r
F P
0 g
s
.40722 .63312 m .47984 .60531 L .49449 .60149 L p .35 .824 .787 r
F P
0 g
s
.47984 .60531 m .40722 .63312 L .39059 .62299 L p .6 .745 .946 r
F P
0 g
s
.60043 .59672 m .55029 .5852 L .56212 .57531 L p .753 .87 .933 r
F P
0 g
s
.56212 .57531 m .61215 .58711 L .60043 .59672 L p .753 .87 .933 r
F P
0 g
s
.56589 .54242 m .61575 .55501 L .61803 .57114 L p .9 .656 .56 r
F P
0 g
s
.61575 .55501 m .56589 .54242 L .55639 .53219 L p .782 .305 .101 r
F P
0 g
s
.61215 .58711 m .56212 .57531 L .56811 .55892 L p .873 .79 .766 r
F P
0 g
s
.56811 .55892 m .61803 .57114 L .61215 .58711 L p .873 .79 .766 r
F P
0 g
s
.61803 .57114 m .56811 .55892 L .56589 .54242 L p .9 .656 .56 r
F P
0 g
s
.35955 .60612 m .20839 .57576 L .17984 .56533 L p .354 0 0 r
F P
0 g
s
.39059 .62299 m .46323 .59474 L .47984 .60531 L p .6 .745 .946 r
F P
0 g
s
.46323 .59474 m .39059 .62299 L .3787 .60254 L p .563 .552 .8 r
F P
0 g
s
.03 w
.37614 .60727 m
.38046 .60556 L
s
.5 Mabswid
.50575 .51835 m .49657 .44542 L .48172 .44397 L p .817 .599 .608 r
F P
0 g
s
.49657 .44542 m .50575 .51835 L .52289 .51583 L p .682 .504 .638 r
F P
0 g
s
.3787 .60254 m .45116 .57368 L .46323 .59474 L p .563 .552 .8 r
F P
0 g
s
.03 w
.45294 .57679 m
.49238 .56114 L
s
.5 Mabswid
.51352 .44291 m .52289 .51583 L .53584 .51054 L p .504 .376 .639 r
F P
0 g
s
.53584 .51054 m .5263 .43734 L .51352 .44291 L p .504 .376 .639 r
F P
0 g
s
.49078 .51716 m .48172 .44397 L .47457 .43904 L p .979 .712 .453 r
F P
0 g
s
.48172 .44397 m .49078 .51716 L .50575 .51835 L p .817 .599 .608 r
F P
0 g
s
.5263 .43734 m .53584 .51054 L .53969 .50443 L p 0 0 .49 r
F P
0 g
s
.53969 .50443 m .53004 .43079 L .5263 .43734 L p 0 0 .49 r
F P
0 g
s
.3465 .27857 m .46318 .44433 L .46745 .44244 L p .583 .596 .831 r
F P
0 g
s
.47457 .43904 m .47782 .46548 L p .48197 .47471 L .979 .712 .453 r
F P
0 g
s
.47457 .43904 m .47798 .43246 L p .47948 .45376 L 0 0 .464 r
F P
0 g
s
.47782 .46548 m .48362 .51267 L p .48197 .47471 L .979 .712 .453 r
F P
0 g
s
.48362 .51267 m .47782 .46548 L p .47948 .45376 L 0 0 .464 r
F P
0 g
s
.47782 .46548 m .47457 .43904 L p .47948 .45376 L 0 0 .464 r
F P
0 g
s
.48362 .51267 m .49078 .51716 L p .48197 .47471 L .979 .712 .453 r
F P
0 g
s
.48712 .50653 m .47798 .43246 L .49081 .42676 L p .497 .37 .637 r
F P
0 g
s
.47798 .43246 m .48712 .50653 L .48362 .51267 L p 0 0 .464 r
F P
0 g
s
.46745 .44244 m .48199 .436 L p .43284 .36551 L .583 .596 .831 r
F P
0 g
s
.50014 .50111 m .49081 .42676 L .50814 .42418 L p .682 .502 .636 r
F P
0 g
s
.49081 .42676 m .50014 .50111 L .48712 .50653 L p .497 .37 .637 r
F P
0 g
s
.48199 .436 m .49648 .42959 L p .48459 .41762 L .583 .596 .831 r
F P
0 g
s
.48459 .41762 m .43284 .36551 L .48199 .436 L .583 .596 .831 r
F
.43284 .36551 m .3465 .27857 L .46745 .44244 L F
.53004 .43079 m .53969 .50443 L .5328 .49982 L p .982 .711 .434 r
F P
0 g
s
.5328 .49982 m .52316 .42574 L .53004 .43079 L p .982 .711 .434 r
F P
0 g
s
.4973 .56543 m .49583 .55353 L .51048 .55456 L p .817 .599 .608 r
F P
0 g
s
.51048 .55456 m .51198 .56642 L .4973 .56543 L p .817 .599 .608 r
F P
0 g
s
.51028 .54208 m .51048 .55456 L .49583 .55353 L p .816 .684 .719 r
F P
0 g
s
.51198 .56642 m .51048 .55456 L .52729 .55211 L p .682 .504 .638 r
F P
0 g
s
.51048 .55456 m .51028 .54208 L .52376 .54011 L p .698 .59 .731 r
F P
0 g
s
.52376 .54011 m .52729 .55211 L .51048 .55456 L p .698 .59 .731 r
F P
0 g
s
.52729 .55211 m .52881 .56397 L .51198 .56642 L p .682 .504 .638 r
F P
0 g
s
.52881 .56397 m .52729 .55211 L .54 .54709 L p .504 .376 .639 r
F P
0 g
s
.02 w
.53845 .55652 m
.53899 .55665 L
s
.53899 .55665 m
.5665 .56332 L
s
.5 Mabswid
.52729 .55211 m .52376 .54011 L .53395 .53604 L p .552 .501 .753 r
F P
0 g
s
.53395 .53604 m .54 .54709 L .52729 .55211 L p .552 .501 .753 r
F P
0 g
s
.49583 .55353 m .49853 .54122 L .51028 .54208 L p .816 .684 .719 r
F P
0 g
s
.51141 .53138 m .51028 .54208 L .49853 .54122 L p .795 .759 .82 r
F P
0 g
s
.51028 .54208 m .51141 .53138 L .51891 .53028 L p .703 .677 .822 r
F P
0 g
s
.51891 .53028 m .52376 .54011 L .51028 .54208 L p .703 .677 .822 r
F P
0 g
s
.52376 .54011 m .51891 .53028 L .52456 .528 L p .587 .62 .852 r
F P
0 g
s
.52456 .528 m .53395 .53604 L .52376 .54011 L p .587 .62 .852 r
F P
0 g
s
.50269 .57461 m .4973 .56543 L .51198 .56642 L p .789 .463 .438 r
F P
0 g
s
.51198 .56642 m .51448 .57538 L .50269 .57461 L p .789 .463 .438 r
F P
0 g
s
.51448 .57538 m .51198 .56642 L .52881 .56397 L p .645 .379 .501 r
F P
0 g
s
.52881 .56397 m .52803 .57341 L .51448 .57538 L p .645 .379 .501 r
F P
0 g
s
.52803 .57341 m .52881 .56397 L .54156 .55899 L p .418 .189 .457 r
F P
0 g
s
.54 .54709 m .54156 .55899 L .52881 .56397 L p .504 .376 .639 r
F P
0 g
s
.52316 .42574 m .5328 .49982 L .51766 .49853 L p .82 .6 .605 r
F P
0 g
s
.51766 .49853 m .50814 .42418 L .52316 .42574 L p .82 .6 .605 r
F P
0 g
s
.01 w
.50489 .45542 m
.50946 .4914 L
s
.5 Mabswid
.51891 .53028 m .51141 .53138 L .50488 .53088 L p .593 .859 .994 r
F P
0 g
s
.49853 .54122 m .50488 .53088 L .51141 .53138 L p .795 .759 .82 r
F P
0 g
s
.48884 .54937 m .49295 .53782 L .49853 .54122 L p .959 .842 .684 r
F P
0 g
s
.49853 .54122 m .49583 .55353 L .48884 .54937 L p .959 .842 .684 r
F P
0 g
s
.50488 .53088 m .49853 .54122 L .49295 .53782 L p .88 .899 .84 r
F P
0 g
s
.52456 .528 m .51891 .53028 L p .50488 .53088 L .593 .859 .994 r
F P
0 g
s
.49031 .56134 m .48884 .54937 L .49583 .55353 L p .979 .712 .453 r
F P
0 g
s
.49583 .55353 m .4973 .56543 L .49031 .56134 L p .979 .712 .453 r
F P
0 g
s
.03 w
.49657 .55948 m
.49706 .55928 L
s
.5 Mabswid
.54 .54709 m .53395 .53604 L .53696 .53138 L p .177 .307 .759 r
F P
0 g
s
.53395 .53604 m .52456 .528 L .5262 .52539 L p .36 .556 .909 r
F P
0 g
s
.5262 .52539 m .53696 .53138 L .53395 .53604 L p .36 .556 .909 r
F P
0 g
s
.54156 .55899 m .54 .54709 L .54381 .54134 L p 0 0 .489 r
F P
0 g
s
.53696 .53138 m .54381 .54134 L .54 .54709 L p .177 .307 .759 r
F P
0 g
s
.5262 .52539 m .52456 .528 L p .50488 .53088 L .593 .859 .994 r
F P
0 g
s
.52318 .52346 m .5262 .52539 L p .50488 .53088 L .593 .859 .994 r
F P
0 g
s
.51661 .52294 m .52318 .52346 L p .50488 .53088 L .593 .859 .994 r
F P
0 g
s
.50904 .52405 m .51661 .52294 L p .50488 .53088 L .593 .859 .994 r
F P
0 g
s
.01 w
.51283 .51795 m
.51352 .52339 L
s
.5 Mabswid
.50338 .52636 m .50904 .52405 L p .50488 .53088 L .593 .859 .994 r
F P
0 g
s
.50488 .53088 m .5018 .52897 L .50338 .52636 L p .593 .859 .994 r
F P
0 g
s
.49295 .53782 m .5018 .52897 L .50488 .53088 L p .88 .899 .84 r
F P
0 g
s
.51095 .57924 m .50269 .57461 L .51448 .57538 L p .621 .112 .018 r
F P
0 g
s
.51448 .57538 m .51752 .57966 L .51095 .57924 L p .621 .112 .018 r
F P
0 g
s
.51752 .57966 m .51448 .57538 L .52803 .57341 L p .505 .079 .166 r
F P
0 g
s
.4971 .57137 m .49031 .56134 L .4973 .56543 L p .859 .408 .037 r
F P
0 g
s
.4973 .56543 m .50269 .57461 L .4971 .57137 L p .859 .408 .037 r
F P
0 g
s
.52803 .57341 m .52507 .57856 L .51752 .57966 L p .505 .079 .166 r
F P
0 g
s
.52507 .57856 m .52803 .57341 L .53828 .56944 L p .171 0 0 r
F P
0 g
s
.54156 .55899 m .53828 .56944 L .52803 .57341 L p .418 .189 .457 r
F P
0 g
s
.50814 .42418 m .51766 .49853 L .50014 .50111 L p .682 .502 .636 r
F P
0 g
s
.01 w
.5105 .49958 m
.51283 .51795 L
s
.5 Mabswid
.4241 .57822 m .32071 .55552 L .29344 .54632 L p .31 0 0 r
F P
0 g
s
.53828 .56944 m .54156 .55899 L .54538 .55332 L p 0 0 0 r
F P
0 g
s
.54381 .54134 m .54538 .55332 L .54156 .55899 L p 0 0 .489 r
F P
0 g
s
.52609 .67995 m .51648 .60361 L .50137 .60273 L p .817 .599 .608 r
F P
0 g
s
.51648 .60361 m .52609 .67995 L .54364 .67744 L p .682 .504 .638 r
F P
0 g
s
.54364 .67744 m .53383 .6011 L .51648 .60361 L p .682 .504 .638 r
F P
0 g
s
.53383 .6011 m .54364 .67744 L .55699 .67278 L p .504 .376 .639 r
F P
0 g
s
.55699 .67278 m .547 .59613 L .53383 .6011 L p .504 .376 .639 r
F P
0 g
s
.49575 .53315 m .50338 .52636 L .5018 .52897 L p .704 .957 .69 r
F P
0 g
s
.5018 .52897 m .49295 .53782 L .49575 .53315 L p .704 .957 .69 r
F P
0 g
s
.50787 .57745 m .4971 .57137 L .50269 .57461 L p 0 .228 .628 r
F P
0 g
s
.50269 .57461 m .51095 .57924 L .50787 .57745 L p 0 .228 .628 r
F P
0 g
s
.53696 .53138 m .5262 .52539 L .52318 .52346 L p 0 .273 .681 r
F P
0 g
s
.49231 .54361 m .49575 .53315 L .49295 .53782 L p 0 0 0 r
F P
0 g
s
.49295 .53782 m .48884 .54937 L .49231 .54361 L p 0 0 0 r
F P
0 g
s
.53828 .56944 m .53077 .57636 L .52507 .57856 L p .171 0 0 r
F P
0 g
s
.54538 .55332 m .54132 .56494 L .53828 .56944 L p 0 0 0 r
F P
0 g
s
.53077 .57636 m .53828 .56944 L .54132 .56494 L p .665 .933 .65 r
F P
0 g
s
.52318 .52346 m .53154 .52791 L .53696 .53138 L p 0 .273 .681 r
F P
0 g
s
.54381 .54134 m .53696 .53138 L .53154 .52791 L p .842 .384 0 r
F P
0 g
s
.4938 .55565 m .49231 .54361 L .48884 .54937 L p 0 0 .465 r
F P
0 g
s
.48884 .54937 m .49031 .56134 L .4938 .55565 L p 0 0 .465 r
F P
0 g
s
.50787 .57745 m .51095 .57924 L .51752 .57966 L p .578 .862 .996 r
F P
0 g
s
.50948 .57497 m .50787 .57745 L p .51752 .57966 L .578 .862 .996 r
F P
0 g
s
.51519 .57275 m .50948 .57497 L p .51752 .57966 L .578 .862 .996 r
F P
0 g
s
.52282 .57164 m .51519 .57275 L p .51752 .57966 L .578 .862 .996 r
F P
0 g
s
.52941 .57208 m .52282 .57164 L p .51752 .57966 L .578 .862 .996 r
F P
0 g
s
.53244 .57388 m .52941 .57208 L p .51752 .57966 L .578 .862 .996 r
F P
0 g
s
.53077 .57636 m .53244 .57388 L p .51752 .57966 L .578 .862 .996 r
F P
0 g
s
.51752 .57966 m .52507 .57856 L .53077 .57636 L p .578 .862 .996 r
F P
0 g
s
.01 w
.52015 .57567 m
.52049 .57835 L
s
.52049 .57835 m
.52134 .58506 L
s
.5 Mabswid
.51085 .67936 m .50137 .60273 L .49419 .59877 L p .979 .712 .453 r
F P
0 g
s
.50137 .60273 m .51085 .67936 L .52609 .67995 L p .817 .599 .608 r
F P
0 g
s
.50597 .529 m .50904 .52405 L .50338 .52636 L p .132 0 0 r
F P
0 g
s
.50338 .52636 m .49575 .53315 L .50597 .529 L p .132 0 0 r
F P
0 g
s
.53154 .52791 m .52318 .52346 L .51661 .52294 L p .604 .082 0 r
F P
0 g
s
.54538 .55332 m .54381 .54134 L .53708 .53707 L p .982 .711 .434 r
F P
0 g
s
.53154 .52791 m .53708 .53707 L .54381 .54134 L p .842 .384 0 r
F P
0 g
s
.547 .59613 m .55699 .67278 L .56108 .66767 L p 0 0 .49 r
F P
0 g
s
.56108 .66767 m .55098 .59055 L .547 .59613 L p 0 0 .49 r
F P
0 g
s
.49993 .56686 m .4938 .55565 L .49031 .56134 L p .147 .289 .753 r
F P
0 g
s
.49031 .56134 m .4971 .57137 L .49993 .56686 L p .147 .289 .753 r
F P
0 g
s
.54132 .56494 m .53244 .57388 L .53077 .57636 L p .665 .933 .65 r
F P
0 g
s
.51968 .52699 m .51661 .52294 L .50904 .52405 L p .489 .053 .136 r
F P
0 g
s
.50904 .52405 m .50597 .529 L .51968 .52699 L p .489 .053 .136 r
F P
0 g
s
.51661 .52294 m .51968 .52699 L .53154 .52791 L p .604 .082 0 r
F P
0 g
s
.01 w
.51408 .52781 m
.5197 .57209 L
s
.5 Mabswid
.54132 .56494 m .54538 .55332 L .53865 .54911 L p .964 .849 .679 r
F P
0 g
s
.53708 .53707 m .53865 .54911 L .54538 .55332 L p .982 .711 .434 r
F P
0 g
s
.49648 .42959 m .37928 .2614 L .3465 .27857 L p .583 .596 .831 r
F P
0 g
s
.50948 .57497 m .49993 .56686 L .4971 .57137 L p .339 .55 .911 r
F P
0 g
s
.4971 .57137 m .50787 .57745 L .50948 .57497 L p .339 .55 .911 r
F P
0 g
s
.50509 .53846 m .50597 .529 L .49575 .53315 L p .405 .173 .446 r
F P
0 g
s
.49575 .53315 m .49231 .54361 L .50509 .53846 L p .405 .173 .446 r
F P
0 g
s
.53244 .57388 m .54132 .56494 L .53591 .56163 L p .882 .908 .841 r
F P
0 g
s
.53865 .54911 m .53591 .56163 L .54132 .56494 L p .964 .849 .679 r
F P
0 g
s
.53708 .53707 m .53154 .52791 L .51968 .52699 L p .79 .458 .427 r
F P
0 g
s
.53591 .56163 m .52941 .57208 L .53244 .57388 L p .882 .908 .841 r
F P
0 g
s
.50661 .55055 m .50509 .53846 L .49231 .54361 L p .497 .37 .637 r
F P
0 g
s
.02 w
.50638 .54875 m
.5344 .55554 L
s
.5 Mabswid
.49231 .54361 m .4938 .55565 L .50661 .55055 L p .497 .37 .637 r
F P
0 g
s
.02 w
.49281 .54546 m
.49523 .54605 L
s
.49523 .54605 m
.49944 .54707 L
s
.48557 .54371 m
.49281 .54546 L
s
.5 Mabswid
.49419 .59877 m .50366 .67588 L .51085 .67936 L p .979 .712 .453 r
F P
0 g
s
.50366 .67588 m .49419 .59877 L .49782 .59317 L p 0 0 .464 r
F P
0 g
s
.52226 .53595 m .51968 .52699 L .50597 .529 L p .642 .372 .494 r
F P
0 g
s
.50597 .529 m .50509 .53846 L .52226 .53595 L p .642 .372 .494 r
F P
0 g
s
.49993 .56686 m .50948 .57497 L .51519 .57275 L p .583 .621 .855 r
F P
0 g
s
.53865 .54911 m .53708 .53707 L .52226 .53595 L p .819 .6 .605 r
F P
0 g
s
.03 w
.49706 .55928 m
.53336 .54487 L
s
.5 Mabswid
.51968 .52699 m .52226 .53595 L .53708 .53707 L p .79 .458 .427 r
F P
0 g
s
.52941 .57208 m .53591 .56163 L .524 .56081 L p .797 .764 .823 r
F P
0 g
s
.524 .56081 m .52282 .57164 L .52941 .57208 L p .797 .764 .823 r
F P
0 g
s
.55098 .59055 m .56108 .66767 L .55417 .66408 L p .982 .711 .434 r
F P
0 g
s
.55417 .66408 m .54407 .58646 L .55098 .59055 L p .982 .711 .434 r
F P
0 g
s
.51022 .56281 m .50661 .55055 L .4938 .55565 L p .547 .499 .754 r
F P
0 g
s
.4938 .55565 m .49993 .56686 L .51022 .56281 L p .547 .499 .754 r
F P
0 g
s
.51519 .57275 m .51022 .56281 L .49993 .56686 L p .583 .621 .855 r
F P
0 g
s
.63162 .49609 m .62465 .49107 L .5384 .54287 L closepath p .664 .752 .916 r
F P
0 g
s
.63682 .5055 m .63162 .49609 L .5384 .54287 L closepath p .611 .573 .787 r
F P
0 g
s
.63831 .51574 m .63682 .5055 L .5384 .54287 L closepath p .553 .41 .641 r
F P
0 g
s
.6355 .52297 m .63831 .51574 L .5384 .54287 L closepath p .439 .137 .354 r
F P
0 g
s
.62944 .52439 m .6355 .52297 L .5384 .54287 L closepath p 0 0 0 r
F P
0 g
s
.62241 .51942 m .62944 .52439 L .5384 .54287 L closepath p .524 .722 .963 r
F P
0 g
s
.61713 .50991 m .62241 .51942 L .5384 .54287 L closepath p .511 .527 .809 r
F P
0 g
s
.61566 .49956 m .61713 .50991 L .5384 .54287 L closepath p .434 .326 .631 r
F P
0 g
s
.62465 .49107 m .61855 .49237 L .5384 .54287 L closepath p .595 .948 .896 r
F P
0 g
s
.61855 .49237 m .61566 .49956 L .5384 .54287 L closepath p .19 0 .223 r
F P
0 g
s
.03 w
.53786 .54309 m
.5384 .54287 L
s
.5 Mabswid
.53591 .56163 m .53865 .54911 L .52381 .54804 L p .819 .687 .719 r
F P
0 g
s
.52226 .53595 m .52381 .54804 L .53865 .54911 L p .819 .6 .605 r
F P
0 g
s
.51022 .56281 m .51519 .57275 L .52282 .57164 L p .702 .679 .825 r
F P
0 g
s
.52381 .54804 m .524 .56081 L .53591 .56163 L p .819 .687 .719 r
F P
0 g
s
.52282 .57164 m .524 .56081 L .51022 .56281 L p .702 .679 .825 r
F P
0 g
s
.52381 .54804 m .52226 .53595 L .50509 .53846 L p .682 .502 .636 r
F P
0 g
s
.50509 .53846 m .50661 .55055 L .52381 .54804 L p .682 .502 .636 r
F P
0 g
s
.37628 .52227 m .45758 .54179 L .46358 .5251 L p .869 .784 .765 r
F P
0 g
s
.45758 .54179 m .37628 .52227 L .37815 .53968 L p .896 .655 .567 r
F P
0 g
s
.37815 .53968 m .45957 .5586 L .45758 .54179 L p .896 .655 .567 r
F P
0 g
s
.38245 .50493 m .46358 .5251 L .47535 .51478 L p .755 .862 .928 r
F P
0 g
s
.46358 .5251 m .38245 .50493 L .37628 .52227 L p .869 .784 .765 r
F P
0 g
s
.50661 .55055 m .51022 .56281 L .524 .56081 L p .698 .591 .732 r
F P
0 g
s
.524 .56081 m .52381 .54804 L .50661 .55055 L p .698 .591 .732 r
F P
0 g
s
.45957 .5586 m .37815 .53968 L .3874 .5506 L p .789 .325 .136 r
F P
0 g
s
.3874 .5506 m .46886 .56921 L .45957 .5586 L p .789 .325 .136 r
F P
0 g
s
.50739 .67077 m .49782 .59317 L .51104 .58808 L p .497 .37 .637 r
F P
0 g
s
.49782 .59317 m .50739 .67077 L .50366 .67588 L p 0 0 .464 r
F P
0 g
s
.54407 .58646 m .55417 .66408 L .53876 .66342 L p .82 .6 .605 r
F P
0 g
s
.53876 .66342 m .52879 .58551 L .54407 .58646 L p .82 .6 .605 r
F P
0 g
s
.39436 .49414 m .47535 .51478 L .48849 .51479 L p .197 .69 .921 r
F P
0 g
s
.47535 .51478 m .39436 .49414 L .38245 .50493 L p .755 .862 .928 r
F P
0 g
s
.46886 .56921 m .3874 .5506 L .4006 .55081 L p .149 .665 .892 r
F P
0 g
s
.4006 .55081 m .48201 .56951 L .46886 .56921 L p .149 .665 .892 r
F P
0 g
s
.52081 .66599 m .51104 .58808 L .52879 .58551 L p .682 .502 .636 r
F P
0 g
s
.01 w
.52134 .58506 m
.52153 .58656 L
s
.5 Mabswid
.51104 .58808 m .52081 .66599 L .50739 .67077 L p .497 .37 .637 r
F P
0 g
s
.52879 .58551 m .53876 .66342 L .52081 .66599 L p .682 .502 .636 r
F P
0 g
s
.01 w
.53142 .66447 m
.53804 .71661 L
s
.5 Mabswid
.48849 .51479 m .40756 .49404 L .39436 .49414 L p .197 .69 .921 r
F P
0 g
s
.40756 .49404 m .48849 .51479 L .49799 .52527 L p .782 .305 .101 r
F P
0 g
s
.48201 .56951 m .4006 .55081 L .41272 .54006 L p .753 .87 .933 r
F P
0 g
s
.41272 .54006 m .49398 .55923 L .48201 .56951 L p .753 .87 .933 r
F P
0 g
s
.41703 .50483 m .49799 .52527 L .50011 .54229 L p .9 .656 .56 r
F P
0 g
s
.49799 .52527 m .41703 .50483 L .40756 .49404 L p .782 .305 .101 r
F P
0 g
s
.49398 .55923 m .41272 .54006 L .41902 .52245 L p .873 .79 .766 r
F P
0 g
s
.41902 .52245 m .50011 .54229 L .49398 .55923 L p .873 .79 .766 r
F P
0 g
s
.50011 .54229 m .41902 .52245 L .41703 .50483 L p .9 .656 .56 r
F P
0 g
s
.02 w
.35449 .51195 m
.41733 .52717 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00J`3oool2
00000;<0oooo001Y0?ooo`8000000P2EV=@00`000000oooo0?ooo`2`0?ooo`00I`3oool2000000@0
UISD00<000000?ooo`3oool0/03oool006D0oooo0P00000709FHe0030000003oool0oooo0:l0oooo
001S0?ooo`8000002P2EV=@00`000000oooo0?ooo`2^0?ooo`00I03oool<09FHe0030000003oool0
oooo0:d0oooo001T0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0[@3oool006D0
oooo00<0000009FHe02EV=@02@2EV=@00`000000oooo0?ooo`2/0?ooo`00IP3oool<09FHe0030000
003oool0oooo0:/0oooo001V0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0Z`3o
ool006L0oooo00<0000009FHe02EV=@02@2EV=@00`000000oooo0?ooo`2Z0?ooo`00J03oool00`00
0000UISD09FHe00909FHe0030000003oool0oooo0:T0oooo001X0?ooo`030000002EV=@0UISD00T0
UISD00<000000?ooo`3oool0Z@3oool006T0oooo00<0000009FHe02EV=@02@2EV=@00`000000oooo
0?ooo`2X0?ooo`00JP3oool00`000000UISD09FHe00909FHe0030000003oool0oooo0:L0oooo001[
0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0YP3oool006/0oooo00<0000009FH
e02EV=@02@2EV=@00`000000oooo0?ooo`2V0?ooo`00K03oool00`000000UISD09FHe00909FHe003
0000003oool0oooo0:D0oooo001]0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0
Y03oool006d0oooo00<0000009FHe02EV=@02@2EV=@00`000000oooo0?ooo`2T0?ooo`00KP3oool0
0`000000UISD09FHe00909FHe0030000003oool0oooo0:<0oooo001_0?ooo`030000002EV=@0UISD
00T0UISD00<000000?ooo`3oool0XP3oool006l0oooo00<0000009FHe02EV=@02P2EV=@00`000000
oooo0?ooo`2Q0?ooo`00L03oool00`000000UISD09FHe00909FHe0030000003oool0oooo0:40oooo
001a0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0;`3oool2000006l0oooo001a
0?ooo`030000002EV=@0UISD00X0UISD00<000000?ooo`3oool0;03oool300000700oooo001b0?oo
o`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0:P3oool200000080<P0C00<000000?oo
o`3oool0KP3oool007<0oooo00<0000009FHe02EV=@02@2EV=@00`000000oooo0?ooo`0W0?ooo`80
00000`0b01<00`000000oooo0?ooo`1_0?ooo`00L`3oool00`000000UISD09FHe00:09FHe0030000
003oool0oooo02@0oooo0P00000403804`030000003oool0oooo0700oooo001d0?ooo`030000002E
V=@0UISD00X0UISD00<000000?ooo`3oool08P3oool00`000000<P0C03804`0303804`030000003o
ool0oooo0740oooo001e0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool08P3oool0
0`000000<P0C03804`0303804`030000003oool0oooo0740oooo001f0?ooo`030000002EV=@0UISD
00T0UISD00<000000?ooo`3oool0803oool00`000000<P0C03804`0303804`030000003oool0oooo
0780oooo001f0?ooo`030000002EV=@0UISD00X0UISD00<000000?ooo`3oool07P3oool00`000000
<P0C03804`0303804`030000003oool0oooo07<0oooo001g0?ooo`030000002EV=@0UISD00T0UISD
00<000000?ooo`3oool07@3oool00`000000<P0C03804`0403804`030000003oool0oooo07<0oooo
001h0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool0703oool00`000000<P0C0380
4`0303804`030000003oool0oooo07@0oooo001h0?ooo`030000002EV=@0UISD00X0UISD00<00000
0?ooo`3oool06P3oool00`000000<P0C03804`0303804`030000003oool0oooo07D0oooo001i0?oo
o`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool06@3oool00`000000<P0C03804`030380
4`030000003oool0oooo07H0oooo001j0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3o
ool05`3oool00`000000<P0C03804`0403804`030000003oool0oooo07H0oooo001j0?ooo`030000
002EV=@0UISD00X0UISD00<000000?ooo`3oool05P3oool00`000000<P0C03804`0303804`030000
003oool0oooo07L0oooo001k0?ooo`030000002EV=@0UISD00X0UISD00<000000?ooo`3oool0503o
ool00`000000<P0C03804`0303804`030000003oool0oooo07P0oooo001l0?ooo`030000002EV=@0
UISD00T0UISD00<000000?ooo`3oool04`3oool00`000000<P0C03804`0303804`030000003oool0
oooo07T0oooo001l0?ooo`030000002EV=@0UISD00X0UISD00<000000?ooo`3oool04@3oool00`00
0000<P0C03804`0403804`030000003oool0oooo07T0oooo001m0?ooo`030000002EV=@0UISD00X0
UISD00<000000?ooo`3oool0403oool00`000000<P0C03804`0303804`030000003oool0oooo07X0
oooo001n0?ooo`030000002EV=@0UISD00T0UISD00<000000?ooo`3oool03`3oool00`000000<P0C
03804`0303804`030000003oool0oooo07/0oooo001n0?ooo`030000002EV=@0UISD00X0UISD00<0
00000?ooo`3oool03@3oool00`000000<P0C03804`0403804`030000003oool0oooo07/0oooo001o
0?ooo`030000002EV=@0UISD00X0UISD00<000000?ooo`3oool02`3oool00`000000<P0C03804`04
03804`030000003oool0oooo07`0oooo00200?ooo`030000002EV=@0UISD00X0UISD00<000000?oo
o`000000100000060?ooo`030000000b01<0<P0C00<0<P0C00<000000?ooo`3oool0O@3oool00840
oooo00<0000009FHe02EV=@02@2EV=@200000080[X2R00<000000=6IVP3AVIX00`0000020?ooo`03
0000000b01<0<P0C00<0<P0C00<000000?ooo`3oool0OP3oool00840oooo00<0000009FHe02EV=@0
2@2EV=@200000080[X2R00<000000=6IVP3AVIX00P3AVIX3000000H0<P0C00<000000?ooo`3oool0
OP3oool00880oooo00<0000009FHe02EV=@01P2EV=@2000000@0[X2R00<000000=6IVP3AVIX00P3A
VIX00`000000nkI_0000000503804`030000003oool0oooo07l0oooo00230?ooo`030000002EV=@0
UISD0080UISD0`0000000`1oGZ<000000:j0XP040:j0XP070000003AVIX0dIVJ0=6IVP000000nkI_
0000000403804`030000003oool0oooo0800oooo00230?ooo`030000002EV=@0000000@000000`1o
GZ<00`000000[X2R0:j0XP020:j0XP070000003AVIX0dIVJ0=6IVP000000nkI_0000000303804`03
0000003oool0oooo0840oooo00240?ooo`040000003oool0oooo0?ooo`8000000`1oGZ<00`000000
[X2R0:j0XP020:j0XP080000003AVIX0dIVJ0=6IVP000000nkI_0000000b01<2000008@0oooo0028
0?ooo`8000000`1oGZ<00`000000[X2R0:j0XP020:j0XP030000003AVIX0dIVJ0080dIVJ0`000026
0?ooo`00R03oool2000000<0OejS00H000000:j0XP2^P:8000000:j0XP0000040=6IVP030000003k
]Vl0000008H0oooo00290?ooo`8000000P1oGZ<01P000000[X2R000000000000[X2R000000@0dIVJ
00<000000?^fK`000000QP3oool008T0oooo0P00000207mNX`060000002^P:80[X2R0000002^P:80
0000103AVIX00`000000nkI_000000260?ooo`00R@3oool200000080OejS00<000000:j0XP2^P:80
0P2^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl0000008H0oooo00290?ooo`8000000`1o
GZ<00`000000[X2R0:j0XP020:j0XP070000003AVIX0dIVJ0=6IVP000000nkI_000000260?ooo`00
R@3oool2000000<0OejS00<000000:j0XP2^P:800P2^P:801`000000dIVJ0=6IVP3AVIX000000?^f
K`000000QP3oool008T0oooo0P00000307mNX`030000002^P:80[X2R0080[X2R00L000000=6IVP3A
VIX0dIVJ0000003k]Vl0000008H0oooo00290?ooo`8000000`1oGZ<00`000000[X2R0:j0XP020:j0
XP070000003AVIX0dIVJ0=6IVP000000nkI_000000260?ooo`00R@3oool2000000<0OejS00<00000
0:j0XP2^P:800P2^P:801`000000dIVJ0=6IVP3AVIX000000?^fK`000000QP3oool008T0oooo0P00
000307mNX`030000002^P:80[X2R0080[X2R00<000000=6IVP3AVIX00P3AVIX2000008H0oooo0029
0?ooo`8000000`1oGZ<00`000000[X2R0:j0XP020:j0XP030000003AVIX0dIVJ0080dIVJ00<00000
0?^fK`000000Q@3oool008T0oooo00<000000000MP0000000`1oGZ<00`000000[X2R0:j0XP020:j0
XP070000003AVIX0dIVJ0=6IVP000000nkI_0000000G0?ooo`800000K03oool00740oooo1@00000D
0?ooo`030000MP000000OejS0080OejS00<000000:j0XP2^P:800P2^P:801`000000dIVJ0=6IVP3A
VIX000000?^fK`0000005P3oool2000000030:W0jP000000oooo06X0oooo001_0?ooo`8000000P31
g>d3000000040<Q>6@000000000000000100oooo00<0001f0000001oGZ<00P1oGZ<01P000000[X2R
0:j0XP000000[X2R000000<0dIVJ00<000000?^fK`000000503oool300000080ZL3Z0P00001Z0?oo
o`00KP3oool00`000000`Mc]0<7Lk@050<7Lk@0400000038CQT0b4hI0<Q>6@@00000303oool01000
07H0000007mNX`1oGZ<;000000030?^fK`000000oooo0140oooo0P0000000`0`03T000000:W0jP02
0000000309bBb@000000oooo06T0oooo001S0?ooo`D000001@3oool00`000000`Mc]0<7Lk@070<7L
k@8000001@38CQT4000000P0oooo00@0001f00000000000000000P3AVI/01P000000[X6S00000000
0000[X6S000000<0PF2S0P00000A0?ooo`030000000`03T0000000<00000102LT/T00`000000oooo
0?ooo`1W0?ooo`00H`3oool800000080oooo00<000000=k8``0000000`0000040<7Lk@030000003V
Yhl0iZN?00<000001@38CQT4000000@0oooo00<0001f000000000000103AVI/3000000030:j1X`00
000000000080PF2S0P00000?0?ooo`@000000`1_Dj4010000000W9;909bBb@2LT/T2000006T0oooo
001S0?ooo``00000103Nb<<5000000D0iZN?100000050<Q>6@@0000000<0001f000000000000103A
VI/300000080[X6S00@00000085PX`21H:<000003P3oool4000000@0Ke>Q1@0000000`2=J:@00000
0?ooo`1X0?ooo`00H`3oool?000000D0g/S30P0000080>JWS`@000001@38CQT3000000@0dIVK0`00
00020:j1X`<000003P3oool3000000@0Ke>Q0P0000000`22Q/l0000008eXY00408eXY0030000003o
ool0oooo06H0oooo001S0?oooa<000000P3Nb<<00`000000iZN?0>JWS`0:0>JWS`@000001038CQT:
000000h0oooo0`00000306mCX@<000001022Q/l00`000000SFRT08eXY003000006P0oooo001W0?oo
oa<000003`3VYhl5000000@0oooo0P00000@0?ooo`8000000`1_Dj42000000D0PXK?1@000002070S
FP030000003oool0oooo06H0oooo001[0?oooa<000003`3VYhl200000080oooo1`00000:0?ooo`<0
000000@0Ke>Q00000000000000000`22Q/l400000080Q[Sf1@00001Y0?ooo`00K03oool00`000000
iJNA0000000;000000@0gl[41000000<0>JWS`030000003oool0000000T000001P3oool600000080
PXK?100000000`26^?H0000000000005000006`0oooo001/0?ooo`030000003UYi40iJNA00<0iJNA
200000080=o:a0@00000203VYhl4000000<0Y5mn3P0000000`22Q/l000000000000800000780oooo
001/0?ooo`030000003UYi40iJNA00H0iJNA1@00000<0=o:a0@000001@3VYhl200000080Y5mn5@00
001h0?ooo`00K03oool2000000P0iJNA00<000000=o:a03Ob/@04@3Ob/@4000000030>JWS`000000
0000008000000P2^P:800`000000dIVJ0000000;00000080b4hI0`00001h0?ooo`00K@3oool50000
00@0iJNA0`00000E0=o:a0<00000102^P:800`000000dIVJ0=6IVP06000000@0`Mc]0P0000040<Q>
6@@00000M03oool005@0oooo0`00000F0?ooo`0300000039Db80bE<R0080bE<R100000030<3NkP@0
00004P3Ob/@2000000D0[X2R00<000000=6IVP3AVIX01@0000040<7Lk@030000003VYhl0000000<0
00001038CQT200000780oooo001F0?ooo`80000000<0C`000000000000004`3oool00`000000bE<R
0<UC8P020<UC8P0300000030g^h0`=k^00L0`=k^1@00000<0=o:a0@000000P2^P:8=000000030<7L
k@000000iZN?00@0iZN?0`0000030<Q>6@030000003oool0oooo06l0oooo001H0?ooo`<000000P1?
000200000100oooo1P00000=0<3NkPD000001`3Ob/@600000080/YNk00@000000=6_^03A[kP0dJnh
2P0000070>JWS`D00000L03oool005/0oooo1000000204l0008000003`3oool8000000d0`=k^1000
00020=o:a08000000P2<Ol400`000000/YNk0;:G^`020;:G^`040000003A[kP0dJnh0=6_^0/00000
2P3VYhl2000006l0oooo001O0?ooo`D0000000<0C`000000000000002@3oool2000000@0D@A82000
000=0<3NkP@000000`2<Ol400`000000/YNk00000003000000030=6_^0000000000000/000002P3V
Yhl00`000000oooo0?ooo`1]0?ooo`00I03oool50000000304l000000000oooo0080oooo0P000007
0544B08000000P1nGZ88000000T0`=k^0`00000208ao`@<000000P2c[M<00`000000c<?B0000000<
000000030=o:a00000000000008000001P3VYhl00`000000oooo0?ooo`1]0?ooo`00<`3oool30000
03<0oooo100000000`1?000000000544B0050544B0800000201nGZ830000000302JZi00000000000
00<000000`30g^h60000000309FNfP000000/jgC0080/jgC00@000000<c3dP000000hNSG2`000005
0=o:a0D000000P3VYhl00`000000oooo0?ooo`1/0?ooo`00=@3oool20000000405X0000000000000
000002h0oooo3000000907iNXQ<000000P2EW]X01@000000/jgC0;>]d`000000c<?B00<000001@3U
Yi45000000X0gl[40`00001^0?ooo`00=`3oool3000000<0FP000P00000W0?ooo`<0000000@0D@A8
0000002K_O00Vkg`0`1A14P8000000H0OUjR500000000`2EW]X0000000000005000000L0iJNA00<0
00000=o:a03Ob/@03@3Ob/@00`000000oooo0?ooo`1/0?ooo`00>P3oool4000000@0FP000P00000P
0?ooo`8000000`1A14P01@000000Vkg`09^ml0000000D@A8008000001`1nGZ83000000@0OUjR4000
00000`21H:<000000?ooo`020000000409?LoP000000000009?LoPH000000`3UYi44000000`0gl[4
00<000000?ooo`3oool0K@3oool003h0oooo1P00000205X000<000006@3oool2000000D0D@A800@0
000009^ml02K_O0000003P1nGZ8300000003092=c0000000000000X000001021H:<00`000000oooo
0?ooo`0500000080oooo00@000000<UC8P39Db80bE<R0`0000040<3NkP@00000203Ob/@00`000000
oooo0?ooo`1]0?ooo`00A03oool500000080FP000`00000C0?ooo`030000001A14P0D@A800<0D@A8
100000000`2K_O00000007iNXP0:07iNXP<00000102@SL`:000000D0PF2S0P0000040?ooo`800000
103oool5000000T0`=k^1@0000020=o:a0030000003oool0oooo06h0oooo00190?ooo`H0000000@0
FP0000000000000000003P3oool010000000D@A80544B01A14P20000000407iNXP000000oooo0?oo
o`8000002@1nGZ82000000L0T8g<1`000006085PX`80000000<0F0e@0000003oool04P00000:0<3N
kP<00000L03oool004l0oooo1@0000000`1J00000000000000090?ooo`030000001A14P0D@A80080
00000`1nGZ800`000000oooo0?ooo`05000000<0OUjR0`00000:092=c0@000001@21H:<3000000<0
F0e@0P0000000`1oGZ<000000:j0XP02000000030:j0XP000000dIVJ00<0dIVJ0`0000000`3oool0
000000000005000000L0`=k^00<000000?ooo`3oool0K`3oool005@0oooo200000040?ooo`<00000
1@1nGZ800`000000oooo0?ooo`0800000140T8g<00<00000085PX`21H:<00P00000505P=D0050000
001oGZ<0OejS07mNX`000000102^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl0nkI_00@0
oooo0`0000000`0VZ^@000000000000200000080`=k^00<000000?ooo`3oool0L03oool005X0oooo
1`00000807iNXPL000004@2@SL`200000080VKkb0P00000605P=D08000000`1oGZ<00`000000[X2R
0:j0XP020:j0XP030000003AVIX0dIVJ0080dIVJ00<000000?^fK`3k]Vl0203oool6000007<0oooo
001O0?ooo`H000000P1nGZ8:000000d0T8g<0`00000609VnlP8000000P1H3E04000000@0OejS00<0
00000:j0XP2^P:800P2^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl0oooo0800oooo001O
0?ooo`030000001nGZ80OUjR00<0OUjR3@00000:092=c08000002`2I__83000000030?ooo`000000
000000@0OejS00<000000:j0XP2^P:800P2^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl0
00000800oooo001O0?ooo`030000001nGZ80OUjR00D0OUjR2`000007092=c0<000002P2I__840000
00<0oooo00<000000000MP0000000`1oGZ<00`000000[X2R0:j0XP020:j0XP030000003AVIX0dIVJ
0080dIVJ00<000000?^fK`0000000`00001m0?ooo`00H03oool00`000000OUjR07iNXP0207iNXPd0
00001@2@SL`2000000X0VKkb100000070?ooo`8000000`1oGZ<00`000000[X2R0:j0XP020:j0XP03
0000003AVIX0dIVJ0080dIVJ00<000000?^fK`0000000`3oool3000007X0oooo001P0?ooo`030000
001nGZ800000008000000`2@SL`8000000@0T8g<0`00000909VnlPD000002@3oool2000000<0OejS
00<000000:j0XP2^P:800P2^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl000000800oooo
001N0?ooo`@000001`2@SL`700000080T8g<0P00000:09VnlP@00000303oool2000000<0OejS00<0
00000:j0XP2^P:800P2^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl000000800oooo001H
0?ooo`T00000202@SL`3000000<0oooo0`00000909VnlPD000000P1J0006000000H0oooo0P000003
07mNX`030000002^P:80[X2R0080[X2R00<000000=6IVP3AVIX00P3AVIX00`000000nkI_00000020
0?ooo`00DP3oool:0000000308iYY0000000000000<000002@2@SL`01`000000oooo0?ooo`3oool0
0000085PX`0000001P2I__85000000<0oooo1@00000305X000D0000000<0oooo0000000000000`1o
GZ<00`000000[X2R0:j0XP020:j0XP030000003AVIX0dIVJ0080dIVJ00<000000?^fK`000000P03o
ool004l0oooo0`000002078VG@@000000P2>JJ@8000000T0T8g<0`000000103oool000000000001H
3E0200000080VKkb1@00000:0?ooo`D000000`1J0003000000@0OejS00<000000:j0XP2^P:800P2^
P:800`000000dIVJ0=6IVP020=6IVP800000P03oool004l0oooo1@00000408iYY080000000D0W9;9
000000000000Z[oY000000030?ooo`030000002@SL`0T8g<00<0T8g<0`00000309VnlP8000000`1H
3E04000001<0oooo1P00000407mNX`030000002^P:80[X2R0080[X2R00<000000=6IVP3AVIX00P3A
VIX00`000000nkI_0000001o0?ooo`00CP3oool2000000D0SVVT0`000000102LT/T000000000002Z
_nT2000000@0oooo00<00000092=c02@SL`00`00000809VnlP@000006P3oool00`000000001f0000
000307mNX`030000002^P:80[X2R0080[X2R00<000000=6IVP3AVIX00P3AVIX00`000000nkI_0000
001o0?ooo`00CP3oool010000000SVVT08iYY02>JJ@300000080W9;90P0000000`2Z_nT000000000
00070?ooo`8000002@2I__84000001d0oooo0P00000307mNX`030000002^P:80[X2R0080[X2R00<0
00000=6IVP3AVIX00P3AVIX00`000000nkI_0000001o0?ooo`00CP3oool010000000SVVT00000000
000309bBb@8000000P2Z_nT2000000T0oooo0P00000609VnlP@000007`3oool2000000<0OejS00<0
00000:j0XP2^P:800P2^P:800`000000dIVJ0=6IVP020=6IVP030000003k]Vl0000007l0oooo001>
0?ooo`8000000`2LT/T200000080Z[oY0P00000=0?ooo`8000000P2I__8400000240oooo0P000003
07mNX`030000002^P:80[X2R0080[X2R00<000000=6IVP3AVIX00P3AVIX00`000000nkI_0000001o
0?ooo`00CP3oool00`000000W9;909bBb@02000000<0Z[oY00<000000?ooo`3oool03`3oool20000
02D0oooo0P00000307mNX`030000002^P:80[X2R0080[X2R00<000000=6IVP3AVIX00P3AVIX00`00
0000nkI_0000001o0?ooo`00C`3oool2000000<0Z[oY0P00000i0?ooo`8000000`1oGZ<00`000000
[X2R0:j0XP030:j0XP030000003AVIX0dIVJ0080dIVJ0P00001o0?ooo`00D03oool010000000Z[oY
00000000000k0?ooo`800000101oGZ<00`000000[X2R0:j0XP020:j0XP030000003AVIX0dIVJ0080
dIVJ00<000000?^fK`000000OP3oool00540oooo00<000000?ooo`3oool0>`3oool00`000000001f
0000000307mNX`060000002^P:80[X2R0000002^P:800000103AVIX00`000000nkI_0000001n0?oo
o`00T03oool00`0007H0000007mNX`0207mNX`030000002^P:80000000P0000000<0nkI_0000003o
ool0O@3oool00900oooo00<0001f0000001oGZ<01`0000020:j1X`0300000021H:<0PF2S00<00000
OP3oool00900oooo00<0001f0000000000000`3AVI/010000000[X6S0000000000020:j1X`030000
0021H:<0PF2S00800000O`3oool00900oooo00<000000?ZfL`0000000`3AVI/010000000[X6S0000
000000020:j1X`0400000021H:<0000000000800oooo002A0?ooo`<000000P3AVI/00`000000[X6S
0000000500000880oooo002D0?ooo`H00000QP3oool009P0oooo0P0000260?ooo`00V03oool20000
08H0oooo002I0?ooo`800000Q@3oool009T0oooo0P0000250?ooo`00V@3oool2000008D0oooo002I
0?ooo`800000Q@3oool009T0oooo0P0000250?ooo`00V@3oool2000008D0oooo002I0?ooo`800000
Q@3oool009T0oooo0`0000240?ooo`00VP3oool00`000000oooo0?ooo`230?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.29909 .57278 m .30911 .61126 L .34703 .62771 L p .11 .545 .915 r
F P
0 g
s
.50399 .35413 m .5248 .44695 L .48056 .4515 L p .618 .255 .332 r
F P
0 g
s
.48056 .4515 m .46271 .35826 L .50399 .35413 L p .618 .255 .332 r
F P
0 g
s
.34703 .62771 m .34023 .5906 L .29909 .57278 L p .11 .545 .915 r
F P
0 g
s
.39649 .56408 m .39818 .59207 L .43309 .60717 L p .149 .563 .929 r
F P
0 g
s
.43309 .60717 m .43348 .58006 L .39649 .56408 L p .149 .563 .929 r
F P
0 g
s
.51213 .53382 m .50941 .55067 L .52579 .55402 L p .329 .711 .982 r
F P
0 g
s
.50941 .55067 m .51213 .53382 L .49643 .54071 L p .639 .959 .924 r
F P
0 g
s
.49643 .54071 m .4942 .55736 L .50941 .55067 L p .639 .959 .924 r
F P
0 g
s
.52579 .55402 m .52906 .53728 L .51213 .53382 L p .329 .711 .982 r
F P
0 g
s
.52906 .53728 m .52579 .55402 L .53713 .56614 L p 0 .27 .776 r
F P
0 g
s
.4942 .55736 m .49643 .54071 L .48791 .55536 L p .789 .915 .527 r
F P
0 g
s
.48791 .55536 m .48595 .57157 L .4942 .55736 L p .789 .915 .527 r
F P
0 g
s
.54077 .54978 m .53713 .56614 L .5391 .58244 L p 0 0 .243 r
F P
0 g
s
.53713 .56614 m .54077 .54978 L .52906 .53728 L p 0 .27 .776 r
F P
0 g
s
.48595 .57157 m .48791 .55536 L .48987 .57221 L p 0 0 .192 r
F P
0 g
s
.48987 .57221 m .48785 .5879 L .48595 .57157 L p 0 0 .192 r
F P
0 g
s
.5391 .58244 m .54281 .5666 L .54077 .54978 L p 0 0 .243 r
F P
0 g
s
.54281 .5666 m .5391 .58244 L .53091 .59671 L p .749 .887 .482 r
F P
0 g
s
.48785 .5879 m .48987 .57221 L .50159 .5848 L p 0 .239 .754 r
F P
0 g
s
.50159 .5848 m .49919 .6001 L .48785 .5879 L p 0 .239 .754 r
F P
0 g
s
.53435 .58131 m .53091 .59671 L .51565 .60347 L p .614 .954 .909 r
F P
0 g
s
.53091 .59671 m .53435 .58131 L .54281 .5666 L p .749 .887 .482 r
F P
0 g
s
.49919 .6001 m .50159 .5848 L .5186 .58828 L p .296 .701 .975 r
F P
0 g
s
.5186 .58828 m .51565 .60347 L .49919 .6001 L p .296 .701 .975 r
F P
0 g
s
.51565 .60347 m .5186 .58828 L .53435 .58131 L p .614 .954 .909 r
F P
0 g
s
.51947 .5125 m .51043 .43688 L .49329 .43864 L p .714 .546 .66 r
F P
0 g
s
.51043 .43688 m .51947 .5125 L .53388 .50867 L p .558 .433 .666 r
F P
0 g
s
.53388 .50867 m .5247 .43278 L .51043 .43688 L p .558 .433 .666 r
F P
0 g
s
.50222 .51431 m .49329 .43864 L .47964 .43739 L p .848 .641 .623 r
F P
0 g
s
.49329 .43864 m .50222 .51431 L .51947 .5125 L p .714 .546 .66 r
F P
0 g
s
.5247 .43278 m .53388 .50867 L .54002 .50421 L p .147 .133 .583 r
F P
0 g
s
.54002 .50421 m .53073 .42784 L .5247 .43278 L p .147 .133 .583 r
F P
0 g
s
.48852 .5134 m .47964 .43739 L .47465 .43357 L p .99 .735 .379 r
F P
0 g
s
.47964 .43739 m .48852 .5134 L .50222 .51431 L p .848 .641 .623 r
F P
0 g
s
.3575 .56411 m .45841 .55347 L .45643 .5312 L p .723 .663 .79 r
F P
0 g
s
.45841 .55347 m .3575 .56411 L .35998 .58788 L p .714 .546 .66 r
F P
0 g
s
.35998 .58788 m .4611 .57715 L .45841 .55347 L p .714 .546 .66 r
F P
0 g
s
.4611 .57715 m .35998 .58788 L .36159 .60441 L p .662 .363 .456 r
F P
0 g
s
.36159 .60441 m .46351 .59355 L .4611 .57715 L p .662 .363 .456 r
F P
0 g
s
.45643 .5312 m .35508 .54182 L .3575 .56411 L p .723 .663 .79 r
F P
0 g
s
.29557 .57064 m .34063 .56589 L .33814 .5436 L p .723 .663 .79 r
F P
0 g
s
.34063 .56589 m .29557 .57064 L .29791 .59447 L p .714 .546 .66 r
F P
0 g
s
.29791 .59447 m .34307 .58967 L .34063 .56589 L p .714 .546 .66 r
F P
0 g
s
.53073 .42784 m .54002 .50421 L .5354 .50083 L p .986 .728 .349 r
F P
0 g
s
.5354 .50083 m .52607 .42393 L .53073 .42784 L p .986 .728 .349 r
F P
0 g
s
.50834 .56397 m .5069 .55176 L .52378 .54998 L p .714 .546 .66 r
F P
0 g
s
.52378 .54998 m .52524 .56219 L .50834 .56397 L p .714 .546 .66 r
F P
0 g
s
.02 w
.51252 .577 m
.51495 .56328 L
s
.5 Mabswid
.52101 .53804 m .52378 .54998 L .5069 .55176 L p .723 .626 .75 r
F P
0 g
s
.52524 .56219 m .52378 .54998 L .5379 .54637 L p .558 .433 .666 r
F P
0 g
s
.52378 .54998 m .52101 .53804 L .53232 .5351 L p .585 .537 .768 r
F P
0 g
s
.53232 .5351 m .5379 .54637 L .52378 .54998 L p .585 .537 .768 r
F P
0 g
s
.49495 .56332 m .49351 .55105 L .5069 .55176 L p .848 .641 .623 r
F P
0 g
s
.5069 .55176 m .50834 .56397 L .49495 .56332 L p .848 .641 .623 r
F P
0 g
s
.50745 .53946 m .5069 .55176 L .49351 .55105 L p .845 .73 .737 r
F P
0 g
s
.5069 .55176 m .50745 .53946 L .52101 .53804 L p .723 .626 .75 r
F P
0 g
s
.35508 .54182 m .45643 .5312 L .45588 .51857 L p .678 .807 .944 r
F P
0 g
s
.33814 .5436 m .29288 .54835 L .29557 .57064 L p .723 .663 .79 r
F P
0 g
s
.65602 .53492 m .65552 .52533 L .54539 .54835 L closepath p .755 .688 .787 r
F P
0 g
s
.65736 .54509 m .65602 .53492 L .54539 .54835 L closepath p .743 .566 .655 r
F P
0 g
s
.51151 .57376 m .50834 .56397 L .52524 .56219 L p .687 .438 .54 r
F P
0 g
s
.52524 .56219 m .5251 .57231 L .51151 .57376 L p .687 .438 .54 r
F P
0 g
s
.5251 .57231 m .52524 .56219 L .53938 .55862 L p .51 .295 .523 r
F P
0 g
s
.5379 .54637 m .53938 .55862 L .52524 .56219 L p .558 .433 .666 r
F P
0 g
s
.51744 .52866 m .52101 .53804 L .50745 .53946 L p .718 .713 .844 r
F P
0 g
s
.52101 .53804 m .51744 .52866 L .52373 .52701 L p .601 .647 .868 r
F P
0 g
s
.52373 .52701 m .53232 .5351 L .52101 .53804 L p .601 .647 .868 r
F P
0 g
s
.47465 .43357 m .48355 .5101 L .48852 .5134 L p .99 .735 .379 r
F P
0 g
s
.48355 .5101 m .47465 .43357 L .48039 .42859 L p .116 .108 .57 r
F P
0 g
s
.49351 .55105 m .49671 .53885 L .50745 .53946 L p .845 .73 .737 r
F P
0 g
s
.50989 .52945 m .50745 .53946 L .49671 .53885 L p .814 .81 .847 r
F P
0 g
s
.50745 .53946 m .50989 .52945 L .51744 .52866 L p .718 .713 .844 r
F P
0 g
s
.50075 .57327 m .49495 .56332 L .50834 .56397 L p .822 .51 .461 r
F P
0 g
s
.50834 .56397 m .51151 .57376 L .50075 .57327 L p .822 .51 .461 r
F P
0 g
s
.01 w
.504 .44156 m
.50969 .48939 L
s
.5 Mabswid
.65905 .552 m .65736 .54509 L .54539 .54835 L closepath p .7 .385 .44 r
F P
0 g
s
.34307 .58967 m .29791 .59447 L .29903 .61108 L p .662 .363 .456 r
F P
0 g
s
.29903 .61108 m .34455 .60623 L .34307 .58967 L p .662 .363 .456 r
F P
0 g
s
.65552 .52533 m .65607 .51991 L .54539 .54835 L closepath p .723 .849 .941 r
F P
0 g
s
.45588 .51857 m .3536 .52926 L .35508 .54182 L p .678 .807 .944 r
F P
0 g
s
.29288 .54835 m .33814 .5436 L .3365 .53105 L p .678 .807 .944 r
F P
0 g
s
.53938 .55862 m .5379 .54637 L .54393 .54226 L p .147 .132 .583 r
F P
0 g
s
.5379 .54637 m .53232 .5351 L .53713 .53175 L p .267 .365 .778 r
F P
0 g
s
.53713 .53175 m .54393 .54226 L .5379 .54637 L p .267 .365 .778 r
F P
0 g
s
.53232 .5351 m .52373 .52701 L .52637 .52513 L p .367 .568 .915 r
F P
0 g
s
.52637 .52513 m .53713 .53175 L .53232 .5351 L p .367 .568 .915 r
F P
0 g
s
.5393 .67822 m .52997 .60025 L .51258 .60211 L p .714 .546 .66 r
F P
0 g
s
.52997 .60025 m .5393 .67822 L .55401 .67499 L p .558 .433 .666 r
F P
0 g
s
.55401 .67499 m .54454 .59673 L .52997 .60025 L p .558 .433 .666 r
F P
0 g
s
.51579 .57919 m .51151 .57376 L .5251 .57231 L p .596 .21 .282 r
F P
0 g
s
.5251 .57231 m .52337 .57838 L .51579 .57919 L p .596 .21 .282 r
F P
0 g
s
.52337 .57838 m .5251 .57231 L .53647 .56948 L p .377 .012 .211 r
F P
0 g
s
.53938 .55862 m .53647 .56948 L .5251 .57231 L p .51 .295 .523 r
F P
0 g
s
.51744 .52866 m .50989 .52945 L p .50182 .5277 L .495 .86 .987 r
F P
0 g
s
.52373 .52701 m .51744 .52866 L p .50182 .5277 L .495 .86 .987 r
F P
0 g
s
.50989 .52945 m .50393 .52909 L .50182 .5277 L p .495 .86 .987 r
F P
0 g
s
.49671 .53885 m .50393 .52909 L .50989 .52945 L p .814 .81 .847 r
F P
0 g
s
.50981 .57893 m .50075 .57327 L .51151 .57376 L p .689 .213 .114 r
F P
0 g
s
.51151 .57376 m .51579 .57919 L .50981 .57893 L p .689 .213 .114 r
F P
0 g
s
.52179 .68013 m .51258 .60211 L .49882 .60162 L p .848 .641 .623 r
F P
0 g
s
.51258 .60211 m .52179 .68013 L .5393 .67822 L p .714 .546 .66 r
F P
0 g
s
.53647 .56948 m .53938 .55862 L .54543 .55459 L p 0 0 .262 r
F P
0 g
s
.54393 .54226 m .54543 .55459 L .53938 .55862 L p .147 .132 .583 r
F P
0 g
s
.3365 .53105 m .29082 .53582 L .29288 .54835 L p .678 .807 .944 r
F P
0 g
s
.49013 .56044 m .48869 .54809 L .49351 .55105 L p .99 .735 .379 r
F P
0 g
s
.49351 .55105 m .49495 .56332 L .49013 .56044 L p .99 .735 .379 r
F P
0 g
s
.49671 .53885 m .49351 .55105 L .48869 .54809 L p .981 .903 .655 r
F P
0 g
s
.66045 .55301 m .65905 .552 L .54539 .54835 L closepath p .238 0 0 r
F P
0 g
s
.48869 .54809 m .49287 .53641 L .49671 .53885 L p .981 .903 .655 r
F P
0 g
s
.50393 .52909 m .49671 .53885 L .49287 .53641 L p .878 .969 .846 r
F P
0 g
s
.49692 .57101 m .49013 .56044 L .49495 .56332 L p .839 .395 0 r
F P
0 g
s
.49495 .56332 m .50075 .57327 L .49692 .57101 L p .839 .395 0 r
F P
0 g
s
.52637 .52513 m .52373 .52701 L p .50182 .5277 L .495 .86 .987 r
F P
0 g
s
.46351 .59355 m .36159 .60441 L .36172 .60736 L p .2 0 0 r
F P
0 g
s
.36172 .60736 m .46472 .59638 L .46351 .59355 L p .2 0 0 r
F P
0 g
s
.65607 .51991 m .65746 .52078 L .54539 .54835 L closepath p .094 0 0 r
F P
0 g
s
.49287 .53641 m .50182 .5277 L .50393 .52909 L p .878 .969 .846 r
F P
0 g
s
.52607 .42393 m .52943 .4516 L p .52466 .44802 L .851 .643 .62 r
F P
0 g
s
.52161 .49984 m .51234 .42259 L .52607 .42393 L p .851 .643 .62 r
F P
0 g
s
.51234 .42259 m .52161 .49984 L .50396 .50168 L p .714 .545 .659 r
F P
0 g
s
.50396 .50168 m .49481 .42438 L .51234 .42259 L p .714 .545 .659 r
F P
0 g
s
.46852 .24483 m .4809 .41523 L p .52777 .42832 L .721 .693 .822 r
F P
0 g
s
.48939 .50562 m .48039 .42859 L .49481 .42438 L p .554 .429 .664 r
F P
0 g
s
.50396 .50168 m .48939 .50562 L p .49337 .44596 L .554 .429 .664 r
F P
0 g
s
.49481 .42438 m .49692 .44219 L p .49337 .44596 L .554 .429 .664 r
F P
0 g
s
.49692 .44219 m .50396 .50168 L p .49337 .44596 L .554 .429 .664 r
F P
0 g
s
.5019 .43097 m .50809 .43034 L p .4809 .41523 L .721 .693 .822 r
F P
0 g
s
.50809 .43034 m .52777 .42832 L p .51369 .42439 L .721 .693 .822 r
F P
0 g
s
.51369 .42439 m .4809 .41523 L .50809 .43034 L .721 .693 .822 r
F
.4809 .41523 m .48219 .43299 L .5019 .43097 L p F P
0 g
s
.5354 .50083 m .52161 .49984 L p .52466 .44802 L .851 .643 .62 r
F P
0 g
s
.52943 .4516 m .5354 .50083 L p .52466 .44802 L .851 .643 .62 r
F P
0 g
s
.01 w
.51107 .50094 m
.51296 .51687 L
s
.5 Mabswid
.53647 .56948 m .5297 .57681 L .52337 .57838 L p .377 .012 .211 r
F P
0 g
s
.5297 .57681 m .53647 .56948 L .54131 .5663 L p 0 0 0 r
F P
0 g
s
.54543 .55459 m .54131 .5663 L .53647 .56948 L p 0 0 .262 r
F P
0 g
s
.48039 .42859 m .48939 .50562 L .48355 .5101 L p .116 .108 .57 r
F P
0 g
s
.54454 .59673 m .55401 .67499 L .56039 .67163 L p .147 .133 .583 r
F P
0 g
s
.56039 .67163 m .5508 .59285 L .54454 .59673 L p .147 .133 .583 r
F P
0 g
s
.50771 .57769 m .49692 .57101 L .50075 .57327 L p .389 0 0 r
F P
0 g
s
.50075 .57327 m .50981 .57893 L .50771 .57769 L p .389 0 0 r
F P
0 g
s
.52337 .57838 m .5297 .57681 L p .50981 .57893 L .469 .856 .979 r
F P
0 g
s
.50981 .57893 m .51579 .57919 L .52337 .57838 L p .469 .856 .979 r
F P
0 g
s
.52432 .52373 m .52637 .52513 L p .50182 .5277 L .495 .86 .987 r
F P
0 g
s
.01 w
.51296 .51687 m
.514 .52555 L
s
.5 Mabswid
.53713 .53175 m .52637 .52513 L .52432 .52373 L p 0 .219 .639 r
F P
0 g
s
.50797 .68001 m .49882 .60162 L .49388 .59893 L p .99 .735 .379 r
F P
0 g
s
.49882 .60162 m .50797 .68001 L .52179 .68013 L p .848 .641 .623 r
F P
0 g
s
.66102 .54767 m .66045 .55301 L .54539 .54835 L closepath p .624 .769 .95 r
F P
0 g
s
.34455 .60623 m .29903 .61108 L .2985 .6141 L p .2 0 0 r
F P
0 g
s
.2985 .6141 m .3445 .60919 L .34455 .60623 L p .2 0 0 r
F P
0 g
s
.52432 .52373 m .53349 .52926 L .53713 .53175 L p 0 .219 .639 r
F P
0 g
s
.54393 .54226 m .53713 .53175 L .53349 .52926 L p .813 .365 0 r
F P
0 g
s
.3536 .52926 m .45588 .51857 L .45702 .5206 L p .131 0 0 r
F P
0 g
s
.51834 .52335 m .52432 .52373 L p .50182 .5277 L .495 .86 .987 r
F P
0 g
s
.51072 .52415 m .51834 .52335 L p .50182 .5277 L .495 .86 .987 r
F P
0 g
s
.50182 .5277 m .50441 .52582 L .51072 .52415 L p .495 .86 .987 r
F P
0 g
s
.49749 .53304 m .50441 .52582 L .50182 .5277 L p 0 0 0 r
F P
0 g
s
.50182 .5277 m .49287 .53641 L .49749 .53304 L p 0 0 0 r
F P
0 g
s
.54543 .55459 m .54393 .54226 L .53944 .53922 L p .986 .728 .35 r
F P
0 g
s
.53349 .52926 m .53944 .53922 L .54393 .54226 L p .813 .365 0 r
F P
0 g
s
.49444 .54396 m .49749 .53304 L .49287 .53641 L p 0 0 .228 r
F P
0 g
s
.49287 .53641 m .48869 .54809 L .49444 .54396 L p 0 0 .228 r
F P
0 g
s
.54131 .5663 m .53237 .57507 L .5297 .57681 L p 0 0 0 r
F P
0 g
s
.5297 .57681 m .53237 .57507 L p .50981 .57893 L .469 .856 .979 r
F P
0 g
s
.65746 .52078 m .65917 .52767 L .54539 .54835 L closepath p .619 .331 .458 r
F P
0 g
s
.66053 .53797 m .66102 .54767 L .54539 .54835 L closepath p .691 .64 .793 r
F P
0 g
s
.65917 .52767 m .66053 .53797 L .54539 .54835 L closepath p .684 .524 .663 r
F P
0 g
s
.03 w
.54468 .54842 m
.54539 .54835 L
s
.5 Mabswid
.51033 .57595 m .50771 .57769 L .50981 .57893 L p .469 .856 .979 r
F P
0 g
s
.51668 .57436 m .51033 .57595 L p .50981 .57893 L .469 .856 .979 r
F P
0 g
s
.52434 .57355 m .51668 .57436 L p .50981 .57893 L .469 .856 .979 r
F P
0 g
s
.53033 .57382 m .52434 .57355 L p .50981 .57893 L .469 .856 .979 r
F P
0 g
s
.53237 .57507 m .53033 .57382 L p .50981 .57893 L .469 .856 .979 r
F P
0 g
s
.01 w
.52004 .57638 m
.52119 .58603 L
s
.5 Mabswid
.54131 .5663 m .54543 .55459 L .54094 .55163 L p .982 .908 .643 r
F P
0 g
s
.53944 .53922 m .54094 .55163 L .54543 .55459 L p .986 .728 .35 r
F P
0 g
s
.49589 .55639 m .49444 .54396 L .48869 .54809 L p .117 .108 .57 r
F P
0 g
s
.48869 .54809 m .49013 .56044 L .49589 .55639 L p .117 .108 .57 r
F P
0 g
s
.03 w
.44521 .55892 m
.48941 .55426 L
s
.49557 .55361 m
.54061 .54885 L
s
.5 Mabswid
.53349 .52926 m .52432 .52373 L .51834 .52335 L p .679 .19 .079 r
F P
0 g
s
.01 w
.5141 .52641 m
.51977 .57403 L
s
.5 Mabswid
.45702 .5206 m .35365 .53141 L .3536 .52926 L p .131 0 0 r
F P
0 g
s
.50891 .53005 m .51072 .52415 L .50441 .52582 L p .356 0 .183 r
F P
0 g
s
.50441 .52582 m .49749 .53304 L .50891 .53005 L p .356 0 .183 r
F P
0 g
s
.53237 .57507 m .54131 .5663 L .53769 .564 L p .875 .977 .842 r
F P
0 g
s
.54094 .55163 m .53769 .564 L .54131 .5663 L p .982 .908 .643 r
F P
0 g
s
.29082 .53582 m .3365 .53105 L .33636 .53322 L p .131 0 0 r
F P
0 g
s
.50157 .56782 m .49589 .55639 L .49013 .56044 L p .244 .352 .776 r
F P
0 g
s
.49013 .56044 m .49692 .57101 L .50157 .56782 L p .244 .352 .776 r
F P
0 g
s
.17507 .58567 m .17596 .59601 L .28891 .57542 L closepath p .683 .523 .662 r
F P
0 g
s
.17368 .57604 m .17507 .58567 L .28891 .57542 L closepath p .691 .641 .795 r
F P
0 g
s
.53769 .564 m .53033 .57382 L .53237 .57507 L p .875 .977 .842 r
F P
0 g
s
.51033 .57595 m .50157 .56782 L .49692 .57101 L p .347 .563 .917 r
F P
0 g
s
.49692 .57101 m .50771 .57769 L .51033 .57595 L p .347 .563 .917 r
F P
0 g
s
.33636 .53322 m .29019 .53805 L .29082 .53582 L p .131 0 0 r
F P
0 g
s
.51834 .52335 m .5227 .5286 L .53349 .52926 L p .679 .19 .079 r
F P
0 g
s
.5227 .5286 m .51834 .52335 L .51072 .52415 L p .587 .193 .262 r
F P
0 g
s
.51072 .52415 m .50891 .53005 L .5227 .5286 L p .587 .193 .262 r
F P
0 g
s
.17596 .59601 m .17603 .60319 L .28891 .57542 L closepath p .617 .325 .452 r
F P
0 g
s
.5508 .59285 m .56039 .67163 L .55584 .66942 L p .986 .728 .349 r
F P
0 g
s
.55584 .66942 m .54622 .59009 L .5508 .59285 L p .986 .728 .349 r
F P
0 g
s
.53944 .53922 m .53349 .52926 L .5227 .5286 L p .824 .506 .451 r
F P
0 g
s
.17232 .57076 m .17368 .57604 L .28891 .57542 L closepath p .62 .772 .954 r
F P
0 g
s
.52777 .42832 m .51643 .24018 L .46852 .24483 L p .721 .693 .822 r
F P
0 g
s
.50871 .54026 m .50891 .53005 L .49749 .53304 L p .503 .285 .516 r
F P
0 g
s
.49749 .53304 m .49444 .54396 L .50871 .54026 L p .503 .285 .516 r
F P
0 g
s
.49388 .59893 m .50307 .67787 L .50797 .68001 L p .99 .735 .379 r
F P
0 g
s
.50307 .67787 m .49388 .59893 L .49985 .59503 L p .116 .108 .57 r
F P
0 g
s
.53033 .57382 m .53769 .564 L .52688 .56347 L p .816 .817 .85 r
F P
0 g
s
.52688 .56347 m .52434 .57355 L .53033 .57382 L p .816 .817 .85 r
F P
0 g
s
.46472 .59638 m .36172 .60736 L .36028 .5952 L p .672 .815 .952 r
F P
0 g
s
.36028 .5952 m .46425 .58415 L .46472 .59638 L p .672 .815 .952 r
F P
0 g
s
.50157 .56782 m .51033 .57595 L .51668 .57436 L p .596 .648 .872 r
F P
0 g
s
.54094 .55163 m .53944 .53922 L .52597 .53844 L p .851 .643 .62 r
F P
0 g
s
.5227 .5286 m .52597 .53844 L .53944 .53922 L p .824 .506 .451 r
F P
0 g
s
.17603 .60319 m .17524 .60445 L .28891 .57542 L closepath p .059 0 0 r
F P
0 g
s
.17151 .57187 m .17232 .57076 L .28891 .57542 L closepath p .269 0 0 r
F P
0 g
s
.17156 .57903 m .17151 .57187 L .28891 .57542 L closepath p .701 .389 .446 r
F P
0 g
s
.17247 .58951 m .17156 .57903 L .28891 .57542 L closepath p .743 .566 .656 r
F P
0 g
s
.17388 .59924 m .17247 .58951 L .28891 .57542 L closepath p .754 .686 .786 r
F P
0 g
s
.17524 .60445 m .17388 .59924 L .28891 .57542 L closepath p .725 .845 .938 r
F P
0 g
s
.03 w
.28891 .57542 m
.44521 .55892 L
s
.5 Mabswid
.53769 .564 m .54094 .55163 L .52747 .55091 L p .848 .734 .737 r
F P
0 g
s
.52747 .55091 m .52688 .56347 L .53769 .564 L p .848 .734 .737 r
F P
0 g
s
.52597 .53844 m .52747 .55091 L .54094 .55163 L p .851 .643 .62 r
F P
0 g
s
.51018 .55273 m .50871 .54026 L .49444 .54396 L p .554 .429 .664 r
F P
0 g
s
.49444 .54396 m .49589 .55639 L .51018 .55273 L p .554 .429 .664 r
F P
0 g
s
.52597 .53844 m .5227 .5286 L .50891 .53005 L p .686 .434 .535 r
F P
0 g
s
.52434 .57355 m .52688 .56347 L .51304 .56493 L p .718 .716 .847 r
F P
0 g
s
.51304 .56493 m .51668 .57436 L .52434 .57355 L p .718 .716 .847 r
F P
0 g
s
.51668 .57436 m .51304 .56493 L .50157 .56782 L p .596 .648 .872 r
F P
0 g
s
.50891 .53005 m .50871 .54026 L .52597 .53844 L p .686 .434 .535 r
F P
0 g
s
.02 w
.52054 .53171 m
.52261 .51997 L
s
.5 Mabswid
.49589 .55639 m .50157 .56782 L .51304 .56493 L p .581 .536 .769 r
F P
0 g
s
.51304 .56493 m .51018 .55273 L .49589 .55639 L p .581 .536 .769 r
F P
0 g
s
.3445 .60919 m .2985 .6141 L .29646 .60198 L p .672 .815 .952 r
F P
0 g
s
.29646 .60198 m .3429 .59705 L .3445 .60919 L p .672 .815 .952 r
F P
0 g
s
.35365 .53141 m .45702 .5206 L .45945 .53691 L p .658 .352 .443 r
F P
0 g
s
.52747 .55091 m .52597 .53844 L .50871 .54026 L p .714 .545 .659 r
F P
0 g
s
.52688 .56347 m .52747 .55091 L .51018 .55273 L p .723 .628 .751 r
F P
0 g
s
.02 w
.51607 .55697 m
.51614 .55656 L
s
.5 Mabswid
.51018 .55273 m .51304 .56493 L .52688 .56347 L p .723 .628 .751 r
F P
0 g
s
.54622 .59009 m .55584 .66942 L .54194 .66924 L p .851 .643 .62 r
F P
0 g
s
.54194 .66924 m .53237 .58953 L .54622 .59009 L p .851 .643 .62 r
F P
0 g
s
.50871 .54026 m .51018 .55273 L .52747 .55091 L p .714 .545 .659 r
F P
0 g
s
.02 w
.51808 .54558 m
.5182 .54494 L
s
.5 Mabswid
.45945 .53691 m .35525 .54786 L .35365 .53141 L p .658 .352 .443 r
F P
0 g
s
.29019 .53805 m .33636 .53322 L .33782 .54969 L p .658 .352 .443 r
F P
0 g
s
.49985 .59503 m .50914 .6745 L .50307 .67787 L p .116 .108 .57 r
F P
0 g
s
.50914 .6745 m .49985 .59503 L .51458 .59142 L p .554 .429 .664 r
F P
0 g
s
.33782 .54969 m .29128 .55457 L .29019 .53805 L p .658 .352 .443 r
F P
0 g
s
.46425 .58415 m .36028 .5952 L .3578 .57237 L p .724 .666 .792 r
F P
0 g
s
.3578 .57237 m .46222 .56133 L .46425 .58415 L p .724 .666 .792 r
F P
0 g
s
.53237 .58953 m .54194 .66924 L .52402 .67119 L p .714 .545 .659 r
F P
0 g
s
.01 w
.52119 .58603 m
.5274 .63816 L
s
.5 Mabswid
.52402 .67119 m .51458 .59142 L .53237 .58953 L p .714 .545 .659 r
F P
0 g
s
.01 w
.53123 .67041 m
.53717 .72033 L
s
.5 Mabswid
.51458 .59142 m .52402 .67119 L .50914 .6745 L p .554 .429 .664 r
F P
0 g
s
.35525 .54786 m .45945 .53691 L .46222 .56133 L p .714 .545 .659 r
F P
0 g
s
.3429 .59705 m .29646 .60198 L .29369 .57914 L p .724 .666 .792 r
F P
0 g
s
.29369 .57914 m .34033 .57421 L .3429 .59705 L p .724 .666 .792 r
F P
0 g
s
.46222 .56133 m .3578 .57237 L .35525 .54786 L p .714 .545 .659 r
F P
0 g
s
.29128 .55457 m .33782 .54969 L .34033 .57421 L p .714 .545 .659 r
F P
0 g
s
.34033 .57421 m .29369 .57914 L .29128 .55457 L p .714 .545 .659 r
F P
0 g
s
.52053 .48194 m .51591 .51045 L .53359 .51406 L p .329 .711 .982 r
F P
0 g
s
.51591 .51045 m .52053 .48194 L .50328 .48946 L p .639 .959 .924 r
F P
0 g
s
.50328 .48946 m .49951 .51763 L .51591 .51045 L p .639 .959 .924 r
F P
0 g
s
.53359 .51406 m .53911 .48574 L .52053 .48194 L p .329 .711 .982 r
F P
0 g
s
.02 w
.52261 .51997 m
.52668 .49699 L
s
.5 Mabswid
.53911 .48574 m .53359 .51406 L .54582 .5271 L p 0 .27 .776 r
F P
0 g
s
.49951 .51763 m .50328 .48946 L .49394 .50547 L p .789 .915 .527 r
F P
0 g
s
.49394 .50547 m .49063 .53289 L .49951 .51763 L p .789 .915 .527 r
F P
0 g
s
.39317 .50923 m .39524 .5435 L .43376 .56012 L p .149 .563 .929 r
F P
0 g
s
.55199 .49941 m .54582 .5271 L .54796 .54462 L p 0 0 .243 r
F P
0 g
s
.54582 .5271 m .55199 .49941 L .53911 .48574 L p 0 .27 .776 r
F P
0 g
s
.43376 .56012 m .43423 .52691 L .39317 .50923 L p .149 .563 .929 r
F P
0 g
s
.49063 .53289 m .49394 .50547 L .4961 .52389 L p 0 0 .192 r
F P
0 g
s
.4961 .52389 m .49268 .55045 L .49063 .53289 L p 0 0 .192 r
F P
0 g
s
.28116 .50399 m .29406 .55349 L .33682 .572 L p .11 .545 .915 r
F P
0 g
s
.54796 .54462 m .55425 .5178 L .55199 .49941 L p 0 0 .243 r
F P
0 g
s
.55425 .5178 m .54796 .54462 L .53914 .55995 L p .749 .887 .482 r
F P
0 g
s
.33682 .572 m .32807 .52424 L .28116 .50399 L p .11 .545 .915 r
F P
0 g
s
.49268 .55045 m .4961 .52389 L .50899 .53767 L p 0 .239 .754 r
F P
0 g
s
.50899 .53767 m .50492 .56358 L .49268 .55045 L p 0 .239 .754 r
F P
0 g
s
.54497 .53388 m .53914 .55995 L .52269 .56721 L p .614 .954 .909 r
F P
0 g
s
.53914 .55995 m .54497 .53388 L .55425 .5178 L p .749 .887 .482 r
F P
0 g
s
.50492 .56358 m .50899 .53767 L .52768 .54149 L p .296 .701 .975 r
F P
0 g
s
.02 w
.51912 .53974 m
.52054 .53171 L
s
.5 Mabswid
.52768 .54149 m .52269 .56721 L .50492 .56358 L p .296 .701 .975 r
F P
0 g
s
.52269 .56721 m .52768 .54149 L .54497 .53388 L p .614 .954 .909 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00T@3oool4000008/0oooo002:0?ooo`L000000`2h
/M800`000000oooo0?ooo`290?ooo`00QP3oool4000000X0^;7B00<000000?ooo`3oool0R@3oool0
08H0oooo00<000000;RadP2h/M802`2h/M800`000000oooo0?ooo`290?ooo`00QP3oool00`000000
^;7B0;RadP0;0;RadP030000003oool0oooo08T0oooo00260?ooo`030000002h/M80^;7B00/0^;7B
00<000000?ooo`3oool0R@3oool008H0oooo00<000000;RadP2h/M802`2h/M800`000000oooo0?oo
o`290?ooo`00QP3oool00`000000^;7B0;RadP0;0;RadP030000003oool0oooo08T0oooo00260?oo
o`030000002h/M80^;7B00/0^;7B00<000000?ooo`3oool0R@3oool008L0oooo00<000000;RadP2h
/M802P2h/M800`000000oooo0?ooo`290?ooo`00Q`3oool00`000000^;7B0;RadP0;0;RadP030000
003oool0oooo08P0oooo00270?ooo`030000002h/M80^;7B00/0^;7B00<000000?ooo`3oool0R03o
ool008L0oooo00<000000;RadP2h/M802`2h/M800`000000oooo0?ooo`280?ooo`00Q`3oool00`00
0000^;7B0;RadP0;0;RadP030000003oool0oooo08P0oooo00270?ooo`030000002h/M80^;7B00/0
^;7B00<000000?ooo`3oool0R03oool008L0oooo00<000000;RadP2h/M802`2h/M800`000000oooo
0?ooo`280?ooo`00Q`3oool00`000000^;7B0;RadP0;0;RadP030000003oool0oooo08P0oooo0027
0?ooo`030000002h/M80^;7B00/0^;7B00<000000?ooo`3oool0R03oool008L0oooo00<000000;Ra
dP2h/M802`2h/M800`000000oooo0?ooo`280?ooo`00Q`3oool00`000000^;7B0;RadP0;0;RadP03
0000003oool0oooo08P0oooo00270?ooo`030000002h/M80^;7B00/0^;7B00<000000?ooo`3oool0
R03oool008P0oooo00<000000;RadP2h/M802P2h/M800`000000oooo0?ooo`280?ooo`00R03oool0
0`000000^;7B0;RadP0:0;RadP030000003oool0oooo08P0oooo00280?ooo`030000002h/M80^;7B
00X0^;7B00<000000?ooo`3oool0R03oool008P0oooo00<000000;RadP2h/M802P2h/M800`000000
oooo0?ooo`280?ooo`00R03oool00`000000^;7B0;RadP0:0;RadP030000003oool0oooo08P0oooo
00280?ooo`030000002h/M80^;7B00X0^;7B00<000000?ooo`3oool0R03oool008P0oooo00<00000
0;RadP2h/M802P2h/M800`000000oooo0?ooo`280?ooo`00R03oool00`000000^;7B0;RadP0;0;Ra
dP030000003oool0oooo08L0oooo00280?ooo`030000002h/M80^;7B00/0^;7B00<000000?ooo`3o
ool0Q`3oool008P0oooo00<000000;RadP2h/M802`2h/M800`000000oooo0?ooo`270?ooo`00R03o
ool00`000000^;7B0;RadP0;0;RadP030000003oool0oooo08L0oooo00280?ooo`030000002h/M80
^;7B00/0^;7B00<000000?ooo`3oool0Q`3oool008T0oooo00<000000;RadP2h/M802P2h/M800`00
0000oooo0?ooo`270?ooo`00Q03oool6000000`0^;7B00<000000?ooo`3oool0Q`3oool008@0oooo
00<0000009i1E02N@E@00P2N@E@00`000000^;7B0;RadP0:0;RadP030000003oool0oooo08L0oooo
00240?ooo`030000002N@E@0WT5D0080WT5D00<000000;RadP2h/M802P2h/M800`000000oooo0?oo
o`270?ooo`00Q@3oool01@000000WT5D09i1E02N@E@0000000`0^;7B00<000000?ooo`3oool0Q`3o
ool008D0oooo00D0000009i1E02N@E@0WT5D0000000<0;RadP030000003oool0oooo08L0oooo0025
0?ooo`050000002N@E@0WT5D09i1E0000000302h/M800`000000oooo0?ooo`270?ooo`00Q@3oool0
1@000000WT5D09i1E02N@E@0000000`0^;7B00<000000?ooo`3oool0Q`3oool008D0oooo00D00000
09i1E02N@E@0WT5D0000000<0;RadP030000003oool0oooo08L0oooo00250?ooo`050000002N@E@0
WT5D09i1E0000000302h/M800`000000oooo0?ooo`270?ooo`00QP3oool010000000WT5D09i1E000
000<0;RadP030000003oool0oooo08L0oooo00260?ooo`040000002N@E@0WT5D000000`0^;7B00<0
00000?ooo`3oool0Q`3oool008H0oooo00D0000009i1E02N@E@0WT5D0000000;0;RadP030000003o
ool0oooo08L0oooo00260?ooo`050000002N@E@0WT5D09i1E0000000302h/M800`000000oooo0?oo
o`260?ooo`00QP3oool01@000000WT5D09i1E02N@E@0000000`0^;7B00<000000?ooo`3oool0QP3o
ool008L0oooo00@0000009i1E02N@E@00000302h/M800`000000oooo0?ooo`260?ooo`00Q`3oool0
10000000WT5D09i1E000000<0;RadP030000003oool0oooo08H0oooo00270?ooo`040000002N@E@0
WT5D000000`0^;7B00<000000?ooo`3oool0QP3oool008L0oooo00@0000009i1E02N@E@00000302h
/M800`000000oooo0?ooo`260?ooo`00Q`3oool010000000WT5D09i1E000000<0;RadP030000003o
ool0oooo08H0oooo00280?ooo`030000002N@E@0000000`0^;7B00<000000?ooo`3oool0QP3oool0
08P0oooo00<0000009i1E00000002@2h/M85000008L0oooo00280?ooo`<000000P2h/M8700000080
fJBN00<000000?bjF@3l^UT0Q`3oool008P0oooo1@0000000`2=KJT000000;J;Z0030;J;Z0040000
003IY9h0fJBN00000080o;YIQ`3oool008P0oooo0P00000408e]Z@030000002fRjP0]X^X0080]X^X
00<000000=VTWP3IY9h00P0000000`3l^UT0oooo0?ooo`250?ooo`00R03oool2000000@0SFfY00<0
00000;J;Z02fRjP00P2fRjP01P000000fJBN0=VTWP3IY9h000000?bjFHL0oooo00280?ooo`030000
000M6i40000000<0SFfY0P0000040;J;Z0050000003IY9h0fJBN0000003l^UT0Q`3oool008P0oooo
00<0000001dKT@0000000`2=KJT2000000@0]X^X00H000000=VTWP3IY9h000000?bjF@0000260?oo
o`00R03oool00`0000007A^A0000000308e]Z@800000102fRjP01P000000fJBN0=VTWP000000o;YI
000008H0oooo00290?ooo`8000000`2=KJT2000000@0]X^X00H000000=VTWP3IY9h000000?bjF@00
00260?ooo`00R@3oool2000000@0SFfY00<000000;J;Z02fRjP00P2fRjP01P000000fJBN0=VTWP00
0000o;YI000008H0oooo00290?ooo`800000102=KJT00`000000]X^X0;J;Z0020;J;Z0060000003I
Y9h0fJBN0000003l^UT00000QP3oool008T0oooo0P00000408e]Z@030000002fRjP0]X^X0080]X^X
00@000000=VTWP3IY9h0fJBN0P0000260?ooo`00R@3oool2000000@0SFfY00<000000;J;Z02fRjP0
0P2fRjP010000000fJBN0=VTWP3IY9h2000008H0oooo00290?ooo`030000000M6i40000000<0SFfY
00<000000;J;Z02fRjP00P2fRjP010000000fJBN0=VTWP3IY9h2000008H0oooo00290?ooo`030000
000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP010000000fJBN0=VTWP3IY9h2000008H0
oooo00290?ooo`030000000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP010000000fJBN
0=VTWP3IY9h2000008H0oooo00290?ooo`030000000M6i40000000<0SFfY0P0000030;J;Z0H00000
QP3oool008T0oooo00<0000001dKT@000000102=KJT01P000000]X^X000000000000XoG/00000080
E;Kk0`0000250?ooo`00R@3oool00`0000007A^A0000000408e]Z@8000000`2SmN`7000008@0oooo
002:0?ooo`0301dKT@000000SFfY0080SFfY0P0000040:?ek0H0000000<004G60000003oool0PP3o
ool008X0oooo0P0M6i400`000000SFfY08e]Z@02000000@0XoG/1P0000020015aP030000003oool0
oooo0800oooo002:0?ooo`807A^A00D0000008e]Z@000000bNZ6000000030:?ek0L000000`00ALH0
0`000000oooo0?ooo`1o0?ooo`00D03oool2000003P0oooo0P0M6i43000000030<WZQP000000XoG/
0080XoG/1P0000040015aP030000003oool0oooo07l0oooo001@0?ooo`040000000LRnX000000000
03H0oooo00H07A^A00000000000000000<WZQP0000040:?ek0H000001000ALH00`000000oooo0?oo
o`1o0?ooo`00D@3oool00`00000078_Z01b;jP02000001X0oooo0P00000H0?ooo`060000003m_640
000000000039jXH000000`2SmN`7000000<004G600<000000000?P000000P03oool00540oooo00<0
000001b;jP0LRnX00P0LRnX3000001L0oooo00@0000002J@k@00000000005`3oool3000000030<WZ
QP000000XoG/00T000000`00ALH00`000000000n000000200?ooo`00D@3oool00`00000078_Z01b;
jP0501b;jP8000005@3oool0100000009Y3]02J@k@0VT>d2000000P0oooo1@00000:0?ooo`@00000
00<0oooo000000000000100000020?ooo`0600000000ALH004G60000000003h00000P03oool00540
oooo00<0000001b;jP0LRnX01`0LRnX2000001<0oooo00<0000002J@k@0VT>d00`0VT>d>000000P0
oooo00<000000000<@0000000`3oool600000080oooo00<000000015aP00ALH00`00000J0?ooo`<0
0000H`3oool00580oooo00<0000001b;jP0LRnX0200LRnX2000000/0oooo1`00000802J@k@D00000
1@2XFW400`000000oooo0?ooo`060?ooo`0400000000034000000?ooo`P000000`3oool200000003
0000?P000000000001H0oooo1000000209iDM@030000003oool0oooo0640oooo001B0?ooo`030000
000LRnX078_Z00T078_Z00<000000?ooo`3oool0103oool00`0000008@0002400002024000P00000
2@0VT>d2000000H0Z5Ya00<000000?ooo`3oool01P3oool010000000000a00000000000205/0;PP0
00000P3oool3000001<0oooo1000000509iDM@<00000HP3oool00580oooo00<0000001b;jP0LRnX0
2@0LRnX3000000@0oooo1@0000070:QJL@030000000VT>d09Y3]00P09Y3]00<000000:QJL@2XFW40
102XFW400`000000oooo0?ooo`060?ooo`040000000003400000000m`@P0000000@0dX5c00000000
0000oooo0`00000?0?ooo`@000000`2NE7D600000080[hJY00<000000?ooo`3oool0H03oool005<0
oooo00<0000001b;jP0LRnX0200LRnX3000000@0oooo00<000000:QJL@2XFW402@2XFW400`000000
9Y3]02J@k@0802J@k@030000002XFW40Z5Ya00@0Z5Ya00<000000?ooo`3oool01P3oool00`000000
000a00000002000m`@L000000P3BPG<3000000030;oSN`000000oooo00X0oooo1000000209iDM@D0
0000202_QZT00`000000oooo0?ooo`1P0?ooo`00D`3oool00`00000078_Z01b;jP0901b;jP800000
103oool00`000000Z5Ya0:QJL@090:QJL@030000000VT>d09Y3]00P09Y3]00<000000:QJL@000000
1@0000080?ooo`8000001000?L490000000309gdj0000000_n=k008000001P3oool:000000P0[hJY
1P00001R0?ooo`00D`3oool00`00000078_Z01b;jP0901b;jP<000000`3oool00`000000Z5Ya0:QJ
L@090:QJL@8000002@0VT>d2000000D0]X^X00<000000?ooo`3oool0103oool4000000<003g12000
000209gdj0030000002ohg/00000008000000P3oool8000000<0[hJY2`0000050;2Sb`030000003o
ool0oooo0600oooo001C0?ooo`030000000LRnX078_Z00T078_Z0`0000030?ooo`030000002XFW40
Z5Ya0080Z5Ya2`00000702J@k@030000002fRjP0]X^X00@0]X^X2`000003000m`@030000001;/oT0
00000080000000<0Bk?i0000002Mm>P00P2Mm>P00`000000_n=k0000000?00000100/:?;00<00000
0?ooo`3oool0H03oool005<0oooo0P00000:01b;jP<000000`3oool5000000/0]X^X0P00000502J@
k@030000002fRjP0]X^X00@0]X^X2`000003000m`@030000001;/oT0Bk?i00<0Bk?i00@0000009gd
j02Mm>P0WOCX8`00001R0?ooo`00D`3oool2000000X078_Z0`0000030?ooo`030000002fRjP0]X^X
00l0]X^X0P00000302J@k@030000002fRjP0]X^X00D0]X^X2`000002000m`@030000001;/oT0Bk?i
00<0Bk?i00@0000009gdj02Mm>P0WOCX1@00000=0?oooa400000HP3oool005<0oooo1000000801b;
jP<000000P3oool2000001<0]X^X0P0000000`0VT>d000000;J;Z0060;J;Z0/000000P00?L400`00
0000Bk?i04^cn@0204^cn@040000002Mm>P0WOCX09gdj0H00000P03oool005<0oooo00@000000;J;
Z02fRjP0]X^X0P00000601b;jPL000005@2fRjP2000000L0]X^X2@000000100nF/H0000000000000
000504^cn@030000002Mm>P0WOCX00L00000P03oool00580oooo0P0000050;J;Z08000001@0LRnX7
000001P0]X^X3`0000000`0nF/H0000000000002000000<0Bk?i2P0000200?ooo`00CP3oool60000
00L0]X^X0P00000301b;jPL000003P2fRjP:000000D0^J[:2P0000000`0nF/H00000000000070000
00040=3Af@000000go[G000008@0oooo000a0?ooo`T00000503oool7000000P0]X^X0P0000000`0L
RnX0000000000005000000@0]X^X2P00000?0;VZbPT0000000@0oooo0000001HT>X000000P2HYMl0
10000000]kOH0;Ngf00000020=3Af@<00000Q03oool00340oooo6@0000040?ooo`L000002@2fRjP=
000001T0^J[:00<000000?ooo`3oool0103oool200000080oooo0`0000000`2HYMl0000000000007
000008@0oooo000a0?ooo`030000002cHg80/f=b00h0/f=b4`0000030;J;Z0H000000`2iZ/X60000
01h0^J[:00<000000?ooo`3oool00`3oool300000080oooo0`0000000`1hfoX000000000000207SK
nP030000003oool0000008D0oooo000a0?oooa400000102nT:LB000000T0^J[:1P00000N0;VZbP03
0000003oool0oooo00<0oooo0P0000001000?L4000000?ooo`3oool500000080oooo0`0000250?oo
o`00<@3oool00`000000_Y2W0;j@Y`0:0;j@Y`h000000`3oool6000000`0^J[:100000000`3oool0
00000;VZbP0H0;VZbPH000001P3oool00`00000003g1000m`@090000000309gdj0000000000008D0
oooo000a0?ooo`030000002nT:L0_Y2W0080_Y2W200000000`31[lT0000000000007000000L0oooo
1P00000=0;VZbP030000003oool0oooo0080oooo00<000000;VZbP2iZ/X0302iZ/X:000000D0[=3c
00<000000?ooo`3oool0103oool01000000003g1000m`@00000204^cn@D000000P2Mm>P2000008D0
oooo000a0?ooo`D000001031[lT5000000030;WHl00000000000008000002`3oool4000000030?oo
o`000000^J[:00`0^J[:00<000000?ooo`3oool00P3oool00`000000^J[:0;VZbP020;VZbPX00000
3`2/d?<00`000000oooo0?ooo`050?ooo`0400000000?L40000004^cn@`00000P`3oool00340oooo
00<000000<6_b@31[lT01P0000020;WHl0@000005@3oool00`000000^J[:0;VZbP0:0;VZbP030000
003oool0oooo0080oooo1@00000I0:c@l`030000003oool0oooo00D0oooo1000000208e]Z@030000
002fRjP0]X^X0080]X^X00@000000=VTWP3IY9h0fJBN0`0000210?ooo`00<@3oool3000000@0^MS`
1000000I0?ooo`030000002iZ/X0^J[:00@0^J[:1`0000040?ooo`030000002/d?<0[=3c01H0[=3c
1P0000070?ooo`030000000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP01@000000fJBN
0=VTWP3IY9h000000080o;YIP@3oool00340oooo00<000000;WHl02if?001000000M0?ooo`L00000
1P2/d?<00`000000oooo0?ooo`020?ooo`030000002/d?<0[=3c00`0[=3c2P00000=0?ooo`030000
000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP01@000000fJBN0=VTWP3IY9h000000080
o;YIP@3oool00380oooo0P00000Q0?ooo`030000002/d?<0[=3c00X0[=3c00<000000?ooo`3oool0
0P3oool00`000000[=3c0:c@l`020:c@l`X000000`3oool20000000302J@k@000000oooo00l0oooo
00<0000001dKT@000000102=KJT00`000000]X^X0;J;Z0020;J;Z0060000003IY9h0fJBN0=VTWP00
0000o;YIP@3oool005D0oooo00<000000:c@l`2/d?<01`2/d?<4000000@0oooo1@00000?0?ooo`80
0000403oool0100000007A^A01dKT@00000308e]Z@030000002fRjP0]X^X0080]X^X00H000000=VT
WP3IY9h0fJBN0000003l^UV10?ooo`00E@3oool010000000[=3c0:c@l`2/d?<6000000<078_Z00<0
00000?ooo`3oool0:@3oool00`0000007A^A0000000308e]Z@030000002fRjP0]X^X0080]X^X00H0
00000=VTWP3IY9h0fJBN0000003l^UV10?ooo`00E@3oool4000000030?ooo`000000000000H078_Z
00<000000?ooo`3oool0:@3oool00`0000007A^A0000000308e]Z@030000002fRjP0]X^X0080]X^X
00L000000=VTWP3IY9h0fJBN0000003l^UT000000800oooo001L0?ooo`800000100LRnX00`000000
oooo0?ooo`0Y0?ooo`030000000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP01`000000
fJBN0=VTWP3IY9h000000?bjF@000000P03oool005h0oooo0P00000301b;jP030000003oool0oooo
02P0oooo00<0000001dKT@0000000`2=KJT00`000000]X^X0;J;Z0020;J;Z0070000003IY9h0fJBN
0=VTWP000000o;YI000000200?ooo`00H03oool20000000301b;jP000000oooo02T0oooo00<00000
01dKT@0000000`2=KJT00`000000]X^X0;J;Z0020;J;Z0070000003IY9h0fJBN0=VTWP000000o;YI
000000200?ooo`00HP3oool2000002X0oooo00<0000001dKT@0000000`2=KJT00`000000]X^X0;J;
Z0020;J;Z0070000003IY9h0fJBN0=VTWP000000o;YI000000200?ooo`00SP3oool00`0000007A^A
0000000408e]Z@030000002fRjP000000080]X^X00@000000=VTWP3IY9h0fJBN0P0000200?ooo`00
SP3oool0100000007A^A01dKT@00000308e]Z@030000002fRjP000000080]X^X00@000000=VTWP3I
Y9h0fJBN0P0000200?ooo`00S`3oool00`0000007A^A0000000308e]Z@060000002fRjP000000000
002fRjP000000`3IY9h200000800oooo002?0?ooo`030000000M6i40000000<0SFfY00<000000;J;
Z00000000P2fRjP010000000fJBN0=VTWP3IY9h200000800oooo002?0?ooo`030000000M6i400000
00<0SFfY00<000000;J;Z02fRjP00P2fRjP010000000fJBN0=VTWP3IY9h200000800oooo002?0?oo
o`030000000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP010000000fJBN0=VTWP3IY9h2
00000800oooo002?0?ooo`030000000M6i40000000<0SFfY00<000000;J;Z02fRjP00P2fRjP01`00
0000fJBN0=VTWP3IY9h000000?bjF@000000O`3oool008l0oooo00<0000001dKT@0000000`2=KJT0
0`000000]X^X0;J;Z0020;J;Z0070000003IY9h0fJBN0=VTWP000000o;YI0000001o0?ooo`00S`3o
ool00`0000007A^A0000000408e]Z@030000002fRjP0]X^X0080]X^X00@000000=VTWP3IY9h0fJBN
0P00001o0?ooo`00S`3oool0100000007A^A01dKT@00000308e]Z@030000002fRjP0]X^X0080]X^X
00@000000=VTWP3IY9h0fJBN0P00001o0?ooo`00T03oool201dKT@070000002=KJT0SFfY08e]Z@00
0000]X^X000000020;J;Z0040000003IY9h0fJBN0=VTWP800000O`3oool00900oooo0P0M6i400`00
0000SFfY0000000<000007l0oooo002@0?ooo`0601dKT@00000000000000003IY9l000000P2fRjP3
0000000408i^ZP000000000000000840oooo002@0?ooo`8000000`3IY9l00`000000]X^X0;J;Z004
000008@0oooo002A0?ooo`T00000QP3oool009P0oooo0P0000260?ooo`00V03oool2000008H0oooo
002H0?ooo`800000QP3oool009P0oooo0`0000250?ooo`00V@3oool2000008D0oooo002I0?ooo`80
0000Q@3oool009T0oooo0P0000250?ooo`00V@3oool2000008D0oooo002I0?ooo`800000Q@3oool0
09T0oooo0P0000250?ooo`00V@3oool3000008@0oooo002J0?ooo`030000003oool0oooo08<0oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.4057 .33097 m .50491 .44489 L .48695 .44209 L p .792 .358 .217 r
F P
0 g
s
.51812 .43273 m .50103 .43263 L p .50609 .45326 L .741 .582 .677 r
F P
0 g
s
.52008 .51029 m .51883 .46069 L p .50609 .45326 L .741 .582 .677 r
F P
0 g
s
.51883 .46069 m .51812 .43273 L p .50609 .45326 L .741 .582 .677 r
F P
0 g
s
.48695 .44209 m .47308 .43993 L p .46735 .43066 L .792 .358 .217 r
F P
0 g
s
.46735 .43066 m .4057 .33097 L .48695 .44209 L .792 .358 .217 r
F
.47308 .43993 m .37411 .32475 L .4057 .33097 L p F P
0 g
s
.60116 .55854 m .6053 .54979 L .53688 .55352 L closepath p .884 .867 .817 r
F P
0 g
s
.60146 .56855 m .60116 .55854 L .53688 .55352 L closepath p .921 .725 .621 r
F P
0 g
s
.6061 .57605 m .60146 .56855 L .53688 .55352 L closepath p .866 .467 .277 r
F P
0 g
s
.6053 .54979 m .61234 .54562 L .53688 .55352 L closepath p .639 .941 .96 r
F P
0 g
s
.50355 .54975 m .44932 .5582 L .44968 .57494 L p .485 .378 .658 r
F P
0 g
s
.44932 .5582 m .50355 .54975 L .49606 .53509 L p .505 .539 .825 r
F P
0 g
s
.49606 .53509 m .44187 .5439 L .44932 .5582 L p .505 .539 .825 r
F P
0 g
s
.61334 .57817 m .6061 .57605 L .53688 .55352 L closepath p 0 .41 .71 r
F P
0 g
s
.50397 .56687 m .44968 .57494 L .44278 .58785 L p .418 .148 .395 r
F P
0 g
s
.44968 .57494 m .50397 .56687 L .50355 .54975 L p .485 .378 .658 r
F P
0 g
s
.61234 .54562 m .61962 .54765 L .53688 .55352 L closepath p .444 0 0 r
F P
0 g
s
.44187 .5439 m .49606 .53509 L .48425 .52842 L p .469 .73 .983 r
F P
0 g
s
.48425 .52842 m .43008 .53742 L .44187 .5439 L p .469 .73 .983 r
F P
0 g
s
.62043 .57406 m .61334 .57817 L .53688 .55352 L closepath p .663 .837 .967 r
F P
0 g
s
.61962 .54765 m .62433 .55515 L .53688 .55352 L closepath p .805 .474 .428 r
F P
0 g
s
.49713 .58006 m .44278 .58785 L .43118 .59201 L p .078 0 0 r
F P
0 g
s
.44278 .58785 m .49713 .58006 L .50397 .56687 L p .418 .148 .395 r
F P
0 g
s
.62464 .56526 m .62043 .57406 L .53688 .55352 L closepath p .816 .773 .813 r
F P
0 g
s
.62433 .55515 m .62464 .56526 L .53688 .55352 L closepath p .846 .665 .658 r
F P
0 g
s
.43008 .53742 m .48425 .52842 L .47257 .53237 L p .026 0 0 r
F P
0 g
s
.47257 .53237 m .41839 .54132 L .43008 .53742 L p .026 0 0 r
F P
0 g
s
.43118 .59201 m .48554 .58427 L .49713 .58006 L p .078 0 0 r
F P
0 g
s
.48554 .58427 m .43118 .59201 L .41925 .58571 L p .451 .729 .986 r
F P
0 g
s
.41839 .54132 m .47257 .53237 L .46552 .54557 L p .404 .129 .379 r
F P
0 g
s
.46552 .54557 m .4113 .55425 L .41839 .54132 L p .404 .129 .379 r
F P
0 g
s
.47359 .57778 m .41925 .58571 L .41162 .57125 L p .497 .537 .828 r
F P
0 g
s
.41925 .58571 m .47359 .57778 L .48554 .58427 L p .451 .729 .986 r
F P
0 g
s
.39545 .53682 m .29995 .55295 L .32669 .57537 L p .478 .66 .942 r
F P
0 g
s
.4113 .55425 m .46552 .54557 L .46591 .56297 L p .477 .371 .656 r
F P
0 g
s
.46591 .56297 m .41162 .57125 L .4113 .55425 L p .477 .371 .656 r
F P
0 g
s
.32669 .57537 m .42241 .56037 L .40723 .54711 L p .478 .66 .942 r
F P
0 g
s
.32669 .57537 m .40723 .54711 L .3925 .53848 L .478 .66 .942 r
F
.37275 .55561 m .38328 .57468 L p .4384 .56537 L .837 .479 .378 r
F P
0 g
s
.44979 .56345 m .43203 .56164 L p .4384 .56537 L .837 .479 .378 r
F P
0 g
s
.43203 .56164 m .37275 .55561 L p .4384 .56537 L .837 .479 .378 r
F P
0 g
s
.40723 .54711 m .39545 .53682 L p .3925 .53848 L .478 .66 .942 r
F P
0 g
s
.41162 .57125 m .46591 .56297 L .47359 .57778 L p .497 .537 .828 r
F P
0 g
s
.51812 .43273 m .52008 .51029 L .53571 .50874 L p .597 .467 .675 r
F P
0 g
s
.53571 .50874 m .53367 .43094 L .51812 .43273 L p .597 .467 .675 r
F P
0 g
s
.31993 .52682 m .1864 .55076 L .21765 .57597 L p .466 .66 .946 r
F P
0 g
s
.21765 .57597 m .35167 .55392 L .33839 .54258 L p .466 .66 .946 r
F P
0 g
s
.32313 .55056 m .33359 .56999 L p .35896 .55453 L .837 .479 .378 r
F P
0 g
s
.35941 .55425 m .35828 .55414 L p .35896 .55453 L .837 .479 .378 r
F P
0 g
s
.35828 .55414 m .32313 .55056 L p .35896 .55453 L .837 .479 .378 r
F P
0 g
s
.33839 .54258 m .31993 .52682 L p .31519 .5291 L .466 .66 .946 r
F P
0 g
s
.21765 .57597 m .33839 .54258 L .31519 .5291 L .466 .66 .946 r
F
.50291 .51028 m .50103 .43263 L .48874 .43065 L p .88 .693 .645 r
F P
0 g
s
.50103 .43263 m .50291 .51028 L .52008 .51029 L p .741 .582 .677 r
F P
0 g
s
.53367 .43094 m .53571 .50874 L .54396 .5062 L p .276 .213 .603 r
F P
0 g
s
.54396 .5062 m .54187 .42789 L .53367 .43094 L p .276 .213 .603 r
F P
0 g
s
.48874 .43065 m .49058 .50871 L .50291 .51028 L p .88 .693 .645 r
F P
0 g
s
.49058 .50871 m .48874 .43065 L .48595 .42752 L p .955 .757 .302 r
F P
0 g
s
.50448 .56112 m .50417 .54865 L .52095 .54861 L p .741 .582 .677 r
F P
0 g
s
.52095 .54861 m .52126 .56106 L .50448 .56112 L p .741 .582 .677 r
F P
0 g
s
.51987 .53669 m .52095 .54861 L .50417 .54865 L p .738 .655 .767 r
F P
0 g
s
.52126 .56106 m .52095 .54861 L .53623 .54722 L p .597 .467 .675 r
F P
0 g
s
.52095 .54861 m .51987 .53669 L .53214 .53554 L p .604 .554 .771 r
F P
0 g
s
.53214 .53554 m .53623 .54722 L .52095 .54861 L p .604 .554 .771 r
F P
0 g
s
.50726 .5717 m .50448 .56112 L .52126 .56106 L p .728 .489 .564 r
F P
0 g
s
.52126 .56106 m .52076 .57165 L .50726 .5717 L p .728 .489 .564 r
F P
0 g
s
.52076 .57165 m .52126 .56106 L .53656 .55971 L p .575 .359 .55 r
F P
0 g
s
.53623 .54722 m .53656 .55971 L .52126 .56106 L p .597 .467 .675 r
F P
0 g
s
.49242 .55985 m .49213 .54732 L .50417 .54865 L p .88 .693 .645 r
F P
0 g
s
.02 w
.46583 .55924 m
.49231 .55516 L
s
.5 Mabswid
.50417 .54865 m .50448 .56112 L .49242 .55985 L p .88 .693 .645 r
F P
0 g
s
.02 w
.49832 .55423 m
.52066 .55078 L
s
.5 Mabswid
.5064 .5367 m .50417 .54865 L .49213 .54732 L p .865 .779 .765 r
F P
0 g
s
.50417 .54865 m .5064 .5367 L .51987 .53669 L p .738 .655 .767 r
F P
0 g
s
.51824 .52758 m .51987 .53669 L .5064 .5367 L p .716 .734 .865 r
F P
0 g
s
.51987 .53669 m .51824 .52758 L .52506 .52693 L p .596 .65 .874 r
F P
0 g
s
.52506 .52693 m .53214 .53554 L .51987 .53669 L p .596 .65 .874 r
F P
0 g
s
.49759 .57073 m .49242 .55985 L .50448 .56112 L p .864 .567 .484 r
F P
0 g
s
.50448 .56112 m .50726 .5717 L .49759 .57073 L p .864 .567 .484 r
F P
0 g
s
.52435 .67886 m .52235 .59979 L .50509 .59989 L p .741 .582 .677 r
F P
0 g
s
.52235 .59979 m .52435 .67886 L .54014 .67786 L p .597 .467 .675 r
F P
0 g
s
.54014 .67786 m .53806 .59853 L .52235 .59979 L p .597 .467 .675 r
F P
0 g
s
.49213 .54732 m .49674 .53558 L .5064 .5367 L p .865 .779 .765 r
F P
0 g
s
.51074 .52758 m .5064 .5367 L .49674 .53558 L p .81 .854 .882 r
F P
0 g
s
.5064 .5367 m .51074 .52758 L .51824 .52758 L p .716 .734 .865 r
F P
0 g
s
.62908 .25723 m .53389 .41309 L p .55564 .43476 L .825 .836 .857 r
F P
0 g
s
.52923 .50199 m .52719 .42268 L .53947 .42474 L p .884 .695 .642 r
F P
0 g
s
.52719 .42268 m .52923 .50199 L .51168 .50197 L p .741 .582 .677 r
F P
0 g
s
.51168 .50197 m .50971 .42256 L .52719 .42268 L p .741 .582 .677 r
F P
0 g
s
.53389 .41309 m .52384 .42955 L .53769 .43182 L p .825 .836 .857 r
F P
0 g
s
.54187 .42789 m .54262 .45612 L p .54177 .45193 L .933 .739 .26 r
F P
0 g
s
.54156 .50362 m .53947 .42474 L .54187 .42789 L p .933 .739 .26 r
F P
0 g
s
.53947 .42474 m .54156 .50362 L .52923 .50199 L p .884 .695 .642 r
F P
0 g
s
.53769 .43182 m .55564 .43476 L p .53389 .41309 L .825 .836 .857 r
F P
0 g
s
.54396 .5062 m .54156 .50362 L p .54177 .45193 L .933 .739 .26 r
F P
0 g
s
.54262 .45612 m .54396 .5062 L p .54177 .45193 L .933 .739 .26 r
F P
0 g
s
.53656 .55971 m .53623 .54722 L .54429 .54499 L p .276 .213 .603 r
F P
0 g
s
.53623 .54722 m .53214 .53554 L .53858 .53369 L p .322 .379 .766 r
F P
0 g
s
.53858 .53369 m .54429 .54499 L .53623 .54722 L p .322 .379 .766 r
F P
0 g
s
.51199 .57834 m .50726 .5717 L .52076 .57165 L p .672 .305 .343 r
F P
0 g
s
.52076 .57165 m .51952 .57831 L .51199 .57834 L p .672 .305 .343 r
F P
0 g
s
.51952 .57831 m .52076 .57165 L .53305 .57059 L p .505 .155 .306 r
F P
0 g
s
.53656 .55971 m .53305 .57059 L .52076 .57165 L p .575 .359 .55 r
F P
0 g
s
.50702 .67906 m .50509 .59989 L .49271 .5988 L p .88 .693 .645 r
F P
0 g
s
.50509 .59989 m .50702 .67906 L .52435 .67886 L p .741 .582 .677 r
F P
0 g
s
.53305 .57059 m .53656 .55971 L .54463 .55756 L p .205 .003 .369 r
F P
0 g
s
.54429 .54499 m .54463 .55756 L .53656 .55971 L p .276 .213 .603 r
F P
0 g
s
.48595 .42752 m .48779 .50615 L .49058 .50871 L p .955 .757 .302 r
F P
0 g
s
.53214 .53554 m .52506 .52693 L .52861 .52587 L p .355 .545 .902 r
F P
0 g
s
.52861 .52587 m .53858 .53369 L .53214 .53554 L p .355 .545 .902 r
F P
0 g
s
.50662 .57782 m .49759 .57073 L .50726 .5717 L p .761 .307 .172 r
F P
0 g
s
.50726 .5717 m .51199 .57834 L .50662 .57782 L p .761 .307 .172 r
F P
0 g
s
.51824 .52758 m .51074 .52758 L p .50773 .52483 L .326 .785 .946 r
F P
0 g
s
.52506 .52693 m .51824 .52758 L p .50773 .52483 L .326 .785 .946 r
F P
0 g
s
.01 w
.51583 .50197 m
.51618 .51612 L
s
.5 Mabswid
.51074 .52758 m .50538 .52694 L p .50773 .52483 L .326 .785 .946 r
F P
0 g
s
.49674 .53558 m .50538 .52694 L .51074 .52758 L p .81 .854 .882 r
F P
0 g
s
.53806 .59853 m .54014 .67786 L .5485 .67643 L p .276 .213 .603 r
F P
0 g
s
.5485 .67643 m .54637 .59658 L .53806 .59853 L p .276 .213 .603 r
F P
0 g
s
.53305 .57059 m .52636 .57773 L .51952 .57831 L p .505 .155 .306 r
F P
0 g
s
.01 w
.51795 .5867 m
.52136 .72281 L
s
.5 Mabswid
.52636 .57773 m .53305 .57059 L .53951 .56892 L p .066 0 0 r
F P
0 g
s
.54463 .55756 m .53951 .56892 L .53305 .57059 L p .205 .003 .369 r
F P
0 g
s
.48971 .55772 m .48941 .5451 L .49213 .54732 L p .954 .757 .301 r
F P
0 g
s
.49213 .54732 m .49242 .55985 L .48971 .55772 L p .954 .757 .301 r
F P
0 g
s
.49674 .53558 m .49213 .54732 L .48941 .5451 L p .938 .947 .618 r
F P
0 g
s
.52861 .52587 m .52506 .52693 L p .50773 .52483 L .326 .785 .946 r
F P
0 g
s
.48941 .5451 m .4946 .53374 L .49674 .53558 L p .938 .947 .618 r
F P
0 g
s
.50538 .52694 m .49674 .53558 L .4946 .53374 L p .793 .999 .838 r
F P
0 g
s
.48779 .50615 m .48595 .42752 L .49391 .42442 L p .255 .195 .595 r
F P
0 g
s
.49544 .56908 m .48971 .55772 L .49242 .55985 L p .803 .404 0 r
F P
0 g
s
.49242 .55985 m .49759 .57073 L .49544 .56908 L p .803 .404 0 r
F P
0 g
s
.50538 .52694 m .50422 .52589 L .50773 .52483 L p .326 .785 .946 r
F P
0 g
s
.4946 .53374 m .50422 .52589 L .50538 .52694 L p .793 .999 .838 r
F P
0 g
s
.49759 .57073 m .50662 .57782 L .50546 .57693 L p .441 0 0 r
F P
0 g
s
.51952 .57831 m .52636 .57773 L p .50546 .57693 L .286 .767 .923 r
F P
0 g
s
.51199 .57834 m .51952 .57831 L p .50546 .57693 L .286 .767 .923 r
F P
0 g
s
.49271 .5988 m .49459 .67839 L .50702 .67906 L p .88 .693 .645 r
F P
0 g
s
.50546 .57693 m .50662 .57782 L .51199 .57834 L p .286 .767 .923 r
F P
0 g
s
.50546 .57693 m .49544 .56908 L .49759 .57073 L p .441 0 0 r
F P
0 g
s
.55564 .43476 m .66052 .26512 L .62908 .25723 L p .825 .836 .857 r
F P
0 g
s
.49459 .67839 m .49271 .5988 L .48992 .5969 L p .955 .757 .302 r
F P
0 g
s
.53858 .53369 m .52861 .52587 L .52753 .52482 L p 0 .14 .607 r
F P
0 g
s
.52753 .52482 m .53667 .53183 L .53858 .53369 L p 0 .14 .607 r
F P
0 g
s
.54429 .54499 m .53858 .53369 L .53667 .53183 L p .764 .368 0 r
F P
0 g
s
.54463 .55756 m .54429 .54499 L .54195 .54275 L p .934 .739 .26 r
F P
0 g
s
.53667 .53183 m .54195 .54275 L .54429 .54499 L p .764 .368 0 r
F P
0 g
s
.52753 .52482 m .52861 .52587 L p .50773 .52483 L .326 .785 .946 r
F P
0 g
s
.01 w
.51618 .51612 m
.5164 .52482 L
s
.5 Mabswid
.53951 .56892 m .52993 .57682 L .52636 .57773 L p .066 0 0 r
F P
0 g
s
.52636 .57773 m .52993 .57682 L p .50546 .57693 L .286 .767 .923 r
F P
0 g
s
.53951 .56892 m .54463 .55756 L .54229 .55541 L p .924 .943 .592 r
F P
0 g
s
.54195 .54275 m .54229 .55541 L .54463 .55756 L p .934 .739 .26 r
F P
0 g
s
.52993 .57682 m .53951 .56892 L .5376 .56726 L p .774 .997 .821 r
F P
0 g
s
.54229 .55541 m .5376 .56726 L .53951 .56892 L p .924 .943 .592 r
F P
0 g
s
.5009 .53186 m .50773 .52483 L .50422 .52589 L p .02 0 0 r
F P
0 g
s
.50422 .52589 m .4946 .53374 L .5009 .53186 L p .02 0 0 r
F P
0 g
s
.49391 .42442 m .49581 .50357 L .48779 .50615 L p .255 .195 .595 r
F P
0 g
s
.54637 .59658 m .5485 .67643 L .54611 .6751 L p .933 .739 .26 r
F P
0 g
s
.54611 .6751 m .54398 .59466 L .54637 .59658 L p .933 .739 .26 r
F P
0 g
s
.52993 .57682 m .52884 .57593 L p .50546 .57693 L .286 .767 .923 r
F P
0 g
s
.01 w
.51643 .52588 m
.51769 .5764 L
s
.51771 .57687 m
.51795 .5867 L
s
.5 Mabswid
.5376 .56726 m .52884 .57593 L .52993 .57682 L p .774 .997 .821 r
F P
0 g
s
.49725 .54283 m .5009 .53186 L .4946 .53374 L p .176 0 .348 r
F P
0 g
s
.4946 .53374 m .48941 .5451 L .49725 .54283 L p .176 0 .348 r
F P
0 g
s
.52217 .52416 m .52753 .52482 L p .50773 .52483 L .326 .785 .946 r
F P
0 g
s
.53667 .53183 m .52753 .52482 L .52217 .52416 L p .755 .289 .141 r
F P
0 g
s
.49581 .50357 m .49391 .42442 L .50971 .42256 L p .594 .464 .674 r
F P
0 g
s
.49756 .55553 m .49725 .54283 L .48941 .5451 L p .255 .196 .595 r
F P
0 g
s
.48941 .5451 m .48971 .55772 L .49756 .55553 L p .255 .196 .595 r
F P
0 g
s
.03 w
.48509 .54782 m
.49332 .54873 L
s
.5 Mabswid
.48992 .5969 m .4918 .67708 L .49459 .67839 L p .955 .757 .302 r
F P
0 g
s
.50773 .52483 m .5146 .52417 L .52217 .52416 L p .326 .785 .946 r
F P
0 g
s
.51331 .53068 m .5146 .52417 L .50773 .52483 L p .494 .135 .286 r
F P
0 g
s
.50773 .52483 m .5009 .53186 L .51331 .53068 L p .494 .135 .286 r
F P
0 g
s
.51588 .57542 m .50899 .57601 L .50546 .57693 L p .286 .767 .923 r
F P
0 g
s
.52347 .57539 m .51588 .57542 L p .50546 .57693 L .286 .767 .923 r
F P
0 g
s
.52884 .57593 m .52347 .57539 L p .50546 .57693 L .286 .767 .923 r
F P
0 g
s
.49544 .56908 m .50546 .57693 L .50899 .57601 L p .335 .539 .904 r
F P
0 g
s
.50176 .56739 m .49756 .55553 L .48971 .55772 L p .303 .369 .765 r
F P
0 g
s
.48971 .55772 m .49544 .56908 L .50176 .56739 L p .303 .369 .765 r
F P
0 g
s
.50899 .57601 m .50176 .56739 L .49544 .56908 L p .335 .539 .904 r
F P
0 g
s
.54195 .54275 m .53667 .53183 L .52702 .53067 L p .867 .565 .475 r
F P
0 g
s
.52217 .52416 m .52702 .53067 L .53667 .53183 L p .755 .289 .141 r
F P
0 g
s
.52702 .53067 m .52217 .52416 L .5146 .52417 L p .667 .293 .327 r
F P
0 g
s
.5146 .52417 m .51331 .53068 L .52702 .53067 L p .667 .293 .327 r
F P
0 g
s
.52884 .57593 m .5376 .56726 L .52793 .56626 L p .811 .862 .886 r
F P
0 g
s
.52793 .56626 m .52347 .57539 L .52884 .57593 L p .811 .862 .886 r
F P
0 g
s
.4918 .67708 m .48992 .5969 L .49799 .59491 L p .255 .195 .595 r
F P
0 g
s
.54229 .55541 m .54195 .54275 L .52991 .54136 L p .884 .695 .642 r
F P
0 g
s
.52702 .53067 m .52991 .54136 L .54195 .54275 L p .867 .565 .475 r
F P
0 g
s
.50971 .42256 m .51168 .50197 L .49581 .50357 L p .594 .464 .674 r
F P
0 g
s
.5376 .56726 m .54229 .55541 L .53024 .55409 L p .868 .785 .766 r
F P
0 g
s
.53024 .55409 m .52793 .56626 L .5376 .56726 L p .868 .785 .766 r
F P
0 g
s
.50176 .56739 m .50899 .57601 L .51588 .57542 L p .591 .652 .879 r
F P
0 g
s
.37232 .53018 m .44927 .53881 L .459 .51718 L p .846 .813 .817 r
F P
0 g
s
.44927 .53881 m .37232 .53018 L .37275 .55561 L p .879 .692 .646 r
F P
0 g
s
.37275 .55561 m .44979 .56345 L .44927 .53881 L p .879 .692 .646 r
F P
0 g
s
.52991 .54136 m .53024 .55409 L .54229 .55541 L p .884 .695 .642 r
F P
0 g
s
.02 w
.52066 .55078 m
.53012 .54933 L
s
.53611 .5484 m
.54065 .5477 L
s
.54065 .5477 m
.54327 .5473 L
s
.5 Mabswid
.51277 .54139 m .51331 .53068 L .5009 .53186 L p .571 .353 .545 r
F P
0 g
s
.5009 .53186 m .49725 .54283 L .51277 .54139 L p .571 .353 .545 r
F P
0 g
s
.52347 .57539 m .52793 .56626 L .5142 .5663 L p .716 .739 .869 r
F P
0 g
s
.5142 .5663 m .51588 .57542 L .52347 .57539 L p .716 .739 .869 r
F P
0 g
s
.51588 .57542 m .5142 .5663 L .50176 .56739 L p .591 .652 .879 r
F P
0 g
s
.38328 .57468 m .46041 .58196 L .44979 .56345 L p .837 .479 .378 r
F P
0 g
s
.52991 .54136 m .52702 .53067 L .51331 .53068 L p .729 .486 .56 r
F P
0 g
s
.49756 .55553 m .50176 .56739 L .5142 .5663 L p .601 .553 .773 r
F P
0 g
s
.54398 .59466 m .54611 .6751 L .53369 .6744 L p .884 .695 .642 r
F P
0 g
s
.53369 .6744 m .5316 .59351 L .54398 .59466 L p .884 .695 .642 r
F P
0 g
s
.51308 .55413 m .51277 .54139 L .49725 .54283 L p .594 .464 .674 r
F P
0 g
s
.03 w
.513 .55089 m
.53021 .55279 L
s
.5 Mabswid
.49725 .54283 m .49756 .55553 L .51308 .55413 L p .594 .464 .674 r
F P
0 g
s
.03 w
.49332 .54873 m
.49741 .54918 L
s
.5 Mabswid
.66437 .5247 m .57711 .53829 L .57762 .55593 L p .485 .378 .658 r
F P
0 g
s
.57711 .53829 m .66437 .5247 L .65677 .50899 L p .505 .539 .825 r
F P
0 g
s
.65677 .50899 m .56956 .52315 L .57711 .53829 L p .505 .539 .825 r
F P
0 g
s
.51331 .53068 m .51277 .54139 L .52991 .54136 L p .729 .486 .56 r
F P
0 g
s
.38212 .50781 m .459 .51718 L .47545 .50664 L p .67 .891 .978 r
F P
0 g
s
.459 .51718 m .38212 .50781 L .37232 .53018 L p .846 .813 .817 r
F P
0 g
s
.5142 .5663 m .51308 .55413 L .49756 .55553 L p .601 .553 .773 r
F P
0 g
s
.49799 .59491 m .49992 .67563 L .4918 .67708 L p .255 .195 .595 r
F P
0 g
s
.66499 .54295 m .57762 .55593 L .57086 .56948 L p .418 .148 .395 r
F P
0 g
s
.57762 .55593 m .66499 .54295 L .66437 .5247 L p .485 .378 .658 r
F P
0 g
s
.52793 .56626 m .53024 .55409 L .51308 .55413 L p .739 .656 .768 r
F P
0 g
s
.51308 .55413 m .5142 .5663 L .52793 .56626 L p .739 .656 .768 r
F P
0 g
s
.53024 .55409 m .52991 .54136 L .51277 .54139 L p .741 .582 .677 r
F P
0 g
s
.56956 .52315 m .65677 .50899 L .64497 .50172 L p .469 .73 .983 r
F P
0 g
s
.64497 .50172 m .55774 .51621 L .56956 .52315 L p .469 .73 .983 r
F P
0 g
s
.51277 .54139 m .51308 .55413 L .53024 .55409 L p .741 .582 .677 r
F P
0 g
s
.49992 .67563 m .49799 .59491 L .51396 .59361 L p .594 .464 .674 r
F P
0 g
s
.46041 .58196 m .38328 .57468 L .40011 .58011 L p .368 0 0 r
F P
0 g
s
.40011 .58011 m .47729 .58727 L .46041 .58196 L p .368 0 0 r
F P
0 g
s
.65836 .55693 m .57086 .56948 L .55932 .57377 L p .078 0 0 r
F P
0 g
s
.57086 .56948 m .65836 .55693 L .66499 .54295 L p .418 .148 .395 r
F P
0 g
s
.5316 .59351 m .53369 .6744 L .51597 .6746 L p .741 .582 .677 r
F P
0 g
s
.51597 .6746 m .51396 .59361 L .5316 .59351 L p .741 .582 .677 r
F P
0 g
s
.51396 .59361 m .51597 .6746 L .49992 .67563 L p .594 .464 .674 r
F P
0 g
s
.47545 .50664 m .39858 .49685 L .38212 .50781 L p .67 .891 .978 r
F P
0 g
s
.39858 .49685 m .47545 .50664 L .49249 .51139 L p .303 0 0 r
F P
0 g
s
.55774 .51621 m .64497 .50172 L .63342 .50579 L p .026 0 0 r
F P
0 g
s
.63342 .50579 m .54611 .52022 L .55774 .51621 L p .026 0 0 r
F P
0 g
s
.55932 .57377 m .64691 .5613 L .65836 .55693 L p .078 0 0 r
F P
0 g
s
.64691 .5613 m .55932 .57377 L .54736 .56702 L p .451 .729 .986 r
F P
0 g
s
.47729 .58727 m .40011 .58011 L .41689 .56954 L p .656 .899 .981 r
F P
0 g
s
.41689 .56954 m .49405 .57708 L .47729 .58727 L p .656 .899 .981 r
F P
0 g
s
.54611 .52022 m .63342 .50579 L .62657 .51978 L p .404 .129 .379 r
F P
0 g
s
.62657 .51978 m .53914 .53378 L .54611 .52022 L p .404 .129 .379 r
F P
0 g
s
.49249 .51139 m .41558 .50169 L .39858 .49685 L p .303 0 0 r
F P
0 g
s
.49249 .51139 m .50353 .52991 L p .41703 .50215 L .839 .47 .355 r
F P
0 g
s
.42654 .52077 m .50353 .52991 L .50414 .55511 L p .885 .696 .642 r
F P
0 g
s
.50353 .52991 m .42654 .52077 L .41558 .50169 L p .839 .47 .355 r
F P
0 g
s
.57472 .50654 m .46392 .52526 L .47929 .5391 L p .478 .66 .942 r
F P
0 g
s
.50414 .55511 m .42706 .5468 L .42654 .52077 L p .885 .696 .642 r
F P
0 g
s
.47929 .5391 m .49099 .54963 L p .49423 .54796 L .478 .66 .942 r
F P
0 g
s
.49423 .54796 m .57472 .50654 L .47929 .5391 L .478 .66 .942 r
F
.41558 .50169 m .41642 .5018 L p .41703 .50215 L .839 .47 .355 r
F P
0 g
s
.41642 .5018 m .49249 .51139 L p .41703 .50215 L .839 .47 .355 r
F P
0 g
s
.63496 .55425 m .54736 .56702 L .53961 .55171 L p .497 .537 .828 r
F P
0 g
s
.54736 .56702 m .63496 .55425 L .64691 .5613 L p .451 .729 .986 r
F P
0 g
s
.53914 .53378 m .62657 .51978 L .62715 .53835 L p .477 .371 .656 r
F P
0 g
s
.62715 .53835 m .53961 .55171 L .53914 .53378 L p .477 .371 .656 r
F P
0 g
s
.02 w
.62703 .53438 m
.69204 .52435 L
s
.5 Mabswid
.53961 .55171 m .62715 .53835 L .63496 .55425 L p .497 .537 .828 r
F P
0 g
s
.49405 .57708 m .41689 .56954 L .42706 .5468 L p .851 .822 .82 r
F P
0 g
s
.42706 .5468 m .50414 .55511 L .49405 .57708 L p .851 .822 .82 r
F P
0 g
s
.03 w
.36799 .53493 m
.42695 .54142 L
s
.5 Mabswid
.49099 .54963 m .60188 .53225 L .57472 .50654 L p .478 .66 .942 r
F P
0 g
s
.32277 .52462 m .359 .52868 L .36881 .50618 L p .846 .813 .817 r
F P
0 g
s
.359 .52868 m .32277 .52462 L .32313 .55056 L p .879 .692 .646 r
F P
0 g
s
.32313 .55056 m .35941 .55425 L .359 .52868 L p .879 .692 .646 r
F P
0 g
s
.33359 .56999 m .36993 .57342 L .35941 .55425 L p .837 .479 .378 r
F P
0 g
s
.3326 .50177 m .36881 .50618 L .38527 .49516 L p .67 .891 .978 r
F P
0 g
s
.36881 .50618 m .3326 .50177 L .32277 .52462 L p .846 .813 .817 r
F P
0 g
s
.36993 .57342 m .33359 .56999 L .35037 .5755 L p .368 0 0 r
F P
0 g
s
.35037 .5755 m .38674 .57887 L .36993 .57342 L p .368 0 0 r
F P
0 g
s
.38527 .49516 m .34905 .49055 L .3326 .50177 L p .67 .891 .978 r
F P
0 g
s
.34905 .49055 m .38527 .49516 L .40226 .50001 L p .303 0 0 r
F P
0 g
s
.38674 .57887 m .35037 .5755 L .36715 .56467 L p .656 .899 .981 r
F P
0 g
s
.36715 .56467 m .40353 .56823 L .38674 .57887 L p .656 .899 .981 r
F P
0 g
s
.40226 .50001 m .36601 .49544 L .34905 .49055 L p .303 0 0 r
F P
0 g
s
.36601 .49544 m .40226 .50001 L .4132 .51918 L p .839 .47 .355 r
F P
0 g
s
.40353 .56823 m .36715 .56467 L .37735 .54144 L p .851 .822 .82 r
F P
0 g
s
.37735 .54144 m .41371 .54536 L .40353 .56823 L p .851 .822 .82 r
F P
0 g
s
.3769 .51487 m .4132 .51918 L .41371 .54536 L p .885 .696 .642 r
F P
0 g
s
.4132 .51918 m .37807 .51501 L p .36601 .49544 L .839 .47 .355 r
F P
0 g
s
.5465 .48621 m .38499 .51516 L .39853 .52704 L p .466 .66 .946 r
F P
0 g
s
.39853 .52704 m .41691 .54319 L p .42209 .54091 L .466 .66 .946 r
F P
0 g
s
.42209 .54091 m .5465 .48621 L .39853 .52704 L .466 .66 .946 r
F
.37807 .51501 m .3769 .51487 L .37644 .51406 L p .839 .47 .355 r
F P
0 g
s
.37644 .51406 m .36601 .49544 L p .37807 .51501 L .839 .47 .355 r
F P
0 g
s
.41371 .54536 m .37735 .54144 L .3769 .51487 L p .885 .696 .642 r
F P
0 g
s
.41691 .54319 m .57865 .51657 L .5465 .48621 L p .466 .66 .946 r
F P
0 g
s
.24207 .53846 m .24922 .5408 L .3451 .53241 L closepath p .422 0 0 r
F P
0 g
s
.23761 .52982 m .24207 .53846 L .3451 .53241 L closepath p .806 .47 .42 r
F P
0 g
s
.2375 .51817 m .23761 .52982 L .3451 .53241 L closepath p .848 .667 .656 r
F P
0 g
s
.24178 .50792 m .2375 .51817 L .3451 .53241 L closepath p .817 .777 .815 r
F P
0 g
s
.24885 .50292 m .24178 .50792 L .3451 .53241 L closepath p .658 .841 .97 r
F P
0 g
s
.25603 .50514 m .24885 .50292 L .3451 .53241 L closepath p .21 0 0 r
F P
0 g
s
.26057 .51378 m .25603 .50514 L .3451 .53241 L closepath p .866 .474 .293 r
F P
0 g
s
.26069 .52555 m .26057 .51378 L .3451 .53241 L closepath p .917 .723 .625 r
F P
0 g
s
.25634 .53588 m .26069 .52555 L .3451 .53241 L closepath p .881 .862 .816 r
F P
0 g
s
.24922 .5408 m .25634 .53588 L .3451 .53241 L closepath p .651 .94 .964 r
F P
0 g
s
.03 w
.3451 .53241 m
.36799 .53493 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00]03oool2000006X0oooo002c0?ooo`030000003C
e]/0dmKK00<00000I`3oool00;<0oooo00<000000=?Ff`3Ce]/00`3Ce]/3000006@0oooo002b0?oo
o`030000003Ce]/0dmKK00L0dmKK0P00001R0?ooo`00/P3oool00`000000dmKK0=?Ff`070=?Ff`03
0000003oool0oooo0640oooo002a0?ooo`030000003Ce]/0dmKK00P0dmKK00<000000?ooo`3oool0
H@3oool00;00oooo00<000000=?Ff`3Ce]/0203Ce]/00`000000oooo0?ooo`1R0?ooo`00/03oool0
0`000000dmKK0=?Ff`080=?Ff`030000003oool0oooo0680oooo002_0?ooo`030000003Ce]/0dmKK
00P0dmKK00<000000?ooo`3oool0H`3oool00:l0oooo00<000000=?Ff`3Ce]/01`3Ce]/00`000000
oooo0?ooo`1T0?ooo`00[P3oool00`000000dmKK0=?Ff`080=?Ff`030000003oool0oooo06@0oooo
002]0?ooo`030000003Ce]/0dmKK00P0dmKK00<000000?ooo`3oool0I@3oool00:d0oooo00<00000
0=?Ff`3Ce]/01`3Ce]/00`000000oooo0?ooo`1V0?ooo`00[03oool00`000000dmKK0=?Ff`080=?F
f`030000003oool0oooo06H0oooo002/0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?ooo`3o
ool0I`3oool00:/0oooo00<000000=?Ff`3Ce]/0203Ce]/00`000000oooo0?ooo`1W0?ooo`00ZP3o
ool00`000000dmKK0=?Ff`080=?Ff`030000003oool0oooo06P0oooo002Z0?ooo`030000003Ce]/0
dmKK00L0dmKK00<000000?ooo`3oool0J@3oool00:T0oooo00<000000=?Ff`3Ce]/0203Ce]/00`00
0000oooo0?ooo`1Y0?ooo`00Z@3oool00`000000dmKK0=?Ff`070=?Ff`030000003oool0oooo06X0
oooo001[0?ooo`<00000>P3oool00`000000dmKK0=?Ff`070=?Ff`030000003oool0oooo06/0oooo
001/0?ooo`030000003:FcL0000000<00000=@3oool00`000000dmKK0=?Ff`080=?Ff`030000003o
ool0oooo06/0oooo001]0?ooo`030000003:FcL0bU/g0080bU/g0`00000b0?ooo`030000003Ce]/0
dmKK00L0dmKK00<000000?ooo`3oool0K03oool006h0oooo00<000000<YK=`3:FcL0103:FcL00`00
0000oooo0?ooo`0^0?ooo`030000003Ce]/0dmKK00P0dmKK00<000000?ooo`3oool0K03oool006h0
oooo00<000000<YK=`3:FcL01@3:FcL00`000000oooo0?ooo`0]0?ooo`030000003Ce]/0dmKK00L0
dmKK00<000000?ooo`3oool0K@3oool006l0oooo00<000000<YK=`3:FcL01@3:FcL00`000000oooo
0?ooo`0[0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?ooo`3oool0KP3oool00700oooo00<0
00000<YK=`3:FcL0103:FcL00`000000oooo0?ooo`0Z0?ooo`030000003Ce]/0dmKK00P0dmKK00<0
00000?ooo`3oool0KP3oool00740oooo00<000000<YK=`3:FcL0103:FcL00`000000oooo0?ooo`0Y
0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?ooo`3oool0K`3oool00780oooo00<000000<YK
=`3:FcL0103:FcL00`000000oooo0?ooo`0W0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?oo
o`3oool0L03oool007<0oooo00<000000<YK=`3:FcL0103:FcL00`000000oooo0?ooo`0V0?ooo`03
0000003Ce]/0dmKK00L0dmKK00<000000?ooo`3oool0L03oool007<0oooo00<000000<YK=`3:FcL0
0`3:FcL00`3oool0bU/g0000000V0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?ooo`3oool0
L@3oool007@0oooo00<000000<YK=`3:FcL01@3:FcL00`000000oooo0?ooo`0R0?ooo`030000003C
e]/0dmKK00P0dmKK00<000000?ooo`3oool0L@3oool007D0oooo00<000000<YK=`3:FcL01@3:FcL0
0`000000oooo0?ooo`0Q0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?ooo`3oool0LP3oool0
07H0oooo00<000000<YK=`3:FcL00P3:FcL0103oool0bU/g0<YK=`00000Q0?ooo`030000003Ce]/0
dmKK00L0dmKK00<000000?ooo`3oool0L`3oool007L0oooo00<000000<YK=`3:FcL0103:FcL00`00
0000oooo0?ooo`0O0?ooo`030000003Ce]/0dmKK00L0dmKK00<000000?ooo`3oool0L`3oool007P0
oooo00D000000<YK=`3:FcL0bU/g0?ooo`020<YK=`030000003oool0oooo01d0oooo00<000000=?F
f`3Ce]/01`3Ce]/00`000000oooo0?ooo`1d0?ooo`00N@3oool00`000000bU/g0<YK=`040<YK=`03
0000003oool0oooo01/0oooo00<000000=?Ff`3Ce]/01`3Ce]/00`000000oooo0?ooo`1e0?ooo`00
N@3oool00`000000bU/g0<YK=`050<YK=`030000003oool0oooo01X0oooo00<000000=?Ff`3Ce]/0
1`3Ce]/00`000000oooo0?ooo`1e0?ooo`00NP3oool01@000000bU/g0<YK=`3:FcL0oooo00<0bU/g
00<000000?ooo`3oool0603oool00`000000dmKK0=?Ff`070=?Ff`030000003oool0oooo07H0oooo
001k0?ooo`030000003:FcL0bU/g00D0bU/g00<000000?ooo`3oool05`3oool00`000000dmKK0=?F
f`070=?Ff`030000003oool0oooo07H0oooo001l0?ooo`030000003:FcL0bU/g00D0bU/g00<00000
0?ooo`3oool05@3oool00`000000dmKK0=?Ff`070=?Ff`030000003oool0oooo07L0oooo001m0?oo
o`040000003:FcL0bU/g0?ooo`@0bU/g00<000000?ooo`3oool04`3oool00`000000dmKK0=?Ff`07
0=?Ff`030000003oool0oooo07P0oooo001n0?ooo`030000003:FcL0bU/g00@0bU/g00<000000?oo
o`3oool04`3oool00`000000dmKK0=?Ff`070=?Ff`030000003oool0oooo07P0oooo001o0?ooo`03
0000003:FcL0oooo00@0bU/g00<000000?ooo`3oool04@3oool00`000000dmKK0=?Ff`070=?Ff`03
0000003oool0oooo07T0oooo001o0?ooo`040000003:FcL0bU/g0?ooo`@0bU/g00<000000?ooo`3o
ool0403oool00`000000dmKK0=?Ff`060=?Ff`030000003oool0oooo07X0oooo00200?ooo`030000
003:FcL0bU/g00D0bU/g00<000000?ooo`3oool03P3oool00`000000dmKK0=?Ff`070=?Ff`030000
003oool0oooo07X0oooo00210?ooo`030000003:FcL0oooo00D0bU/g00<000000?ooo`3oool0303o
ool00`000000dmKK0=?Ff`070=?Ff`030000003oool0oooo07/0oooo00220?ooo`030000003:FcL0
oooo00D0bU/g00<000000?ooo`3oool02`3oool00`000000dmKK0=?Ff`070=?Ff`030000003oool0
oooo07/0oooo00230?ooo`030000003oool0bU/g00D0bU/g3@0000090=?Ff`030000003oool0oooo
07`0oooo00240?ooo`030000003oool0bU/g00@0bU/g00<00000044aV0000000102HMZ`00`000000
_IB]0;fD[@020;fD[@030000003Ce]/0dmKK00H0dmKK00<000000?ooo`3oool0O@3oool008@0oooo
00<000000<YK=`3:FcL0103:FcL00`000000@C6H0000000409Qf[0040000002mU:d0_IB]0;fD[@L0
00000`3Ce]/00`000000oooo0?ooo`1m0?ooo`00Q@3oool00`000000oooo0<YK=`030<YK=`030000
0011<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY002000000040?oo
o`000000000000000800oooo00260?ooo`030000003:FcL0bU/g0080bU/g00<00000044aV0000000
102HMZ`00`000000_IB]0;fD[@020;fD[@030000003R/J@0h[6T00800000Q03oool008L0oooo1@00
00000`11<IP0000009Qf[00309Qf[0030000002mU:d0_IB]0080_IB]00<000000>:aY03R/J@00P00
00240?ooo`00R`3oool00`000000@C6H0000000409Qf[0030000002mU:d0_IB]0080_IB]00<00000
0>:aY03R/J@00P0000240?ooo`00R`3oool00`000000@C6H0000000409Qf[0030000002mU:d0_IB]
0080_IB]00<000000>:aY03R/J@00P0000240?ooo`00R`3oool00`000000@C6H0000000409Qf[003
0000002mU:d0_IB]0080_IB]00<000000>:aY03R/J@00P0000240?ooo`00R`3oool00`000000@C6H
0000000409Qf[0030000002mU:d0_IB]0080_IB]00<000000>:aY03R/J@00P0000240?ooo`00R`3o
ool00`000000@C6H0000000409Qf[0030000002mU:d0_IB]0080_IB]00<000000>:aY03R/J@00P00
00240?ooo`00R`3oool00`000000@C6H0000000409Qf[0030000002mU:d0_IB]0080_IB]00<00000
0>:aY03R/J@00P0000240?ooo`00R`3oool010000000@C6H044aV000000309Qf[0030000002mU:d0
_IB]0080_IB]00D000000>:aY03R/J@0h[6T000000240?ooo`00R`3oool010000000@C6H044aV000
000309Qf[0030000002mU:d0_IB]0080_IB]00@000000>:aY03R/J@0h[6T0P0000230?ooo`00R`3o
ool010000000@C6H044aV000000309Qf[0030000002mU:d0_IB]0080_IB]00@000000>:aY03R/J@0
h[6T0P0000230?ooo`00R`3oool010000000@C6H044aV000000309Qf[0030000002mU:d0_IB]0080
_IB]00@000000>:aY03R/J@0h[6T0P0000230?ooo`00R`3oool010000000@C6H044aV000000309Qf
[0030000002mU:d0_IB]0080_IB]00@000000>:aY03R/J@0h[6T0P0000230?ooo`00R`3oool01000
0000@C6H044aV000000309Qf[0030000002mU:d0_IB]0080_IB]00H000000>:aY03R/J@0h[6T0>jm
@P0000230?ooo`00R`3oool010000000@C6H044aV000000309Qf[0030000002mU:d0_IB]0080_IB]
00<000000>:aY03R/J@00`0000230?ooo`00I03oool3000002@0oooo00@00000044aV011<IP00000
0`2HMZ`00`000000_IB]00000004000000@0MjSb00<000000?ooo`3oool0P03oool006<0oooo00<0
00000:_TnP2[i?X00P000000101=0000000000000000000O0?ooo`0300000011<IP0@C6H00H00000
2P1gZ?800`000000oooo0?ooo`1o0?ooo`00H@3oool2000000D0ZnCj2@0000000`3oool000000000
000200000180oooo1P00000A07NXlP030000003oool0oooo07h0oooo001P0?ooo`030000002[i?X0
ZnCj00L0ZnCj00@000000=IhFP3FN5X0eWQJ1P0000000`2[i?X0000000000006000000H0oooo1@00
000H07NXlP030000003oool0oooo07d0oooo00160?ooo`D00000503oool5000000H0ZnCj00<00000
0=IhFP3FN5X01P3FN5X010000000ZnCj0:_TnP2[i?X<000001h0MjSb0P00000C0?ooo`@00000IP3o
ool004D0oooo0`0000000`2XeoP000000=eiB`0300000140oooo00<000000=S@d@3Hd=400P3Hd=46
000000030?ooo`000000eWQJ00L0eWQJ00<000000:_TnP2[i?X01P00000V07NXlP8000002`3oool7
000000<0N;[k0P00001T0?ooo`00A@3oool00`000000dLK@0=76d003000000<0gGU;1000000<0?oo
o`030000003Hd=40f=3A00P0f=3A00<000000?ooo`0000001@3FN5X6000002d0MjSb0P0000040?oo
o`P000000`1W8F4010000000N;[k07Rjn`1h^_/4000006<0oooo00140?ooo`030000003Aa]00dLK@
00<0dLK@0`0000050=eiB`<000002@3oool00`000000f=3A0=S@d@070=S@d@040000003oool0oooo
0?ooo`D00000=01gZ?87000000P0Ib5Q1@0000030869d`030000003oool0oooo0640oooo00140?oo
o`@000000P3Aa]000`000000j[VO0>ZiW`05000000<0gGU;0`0000050?ooo`030000003Hd=40f=3A
00@00000103Hd=401@000000oooo0?ooo`3oool000000080h[:T00<0000007NXlP1gZ?80<@1gZ?85
000000`0Ib5Q00<000000869d`21RM<01P21RM<00`000000oooo0?ooo`030?ooo`H00000E`3oool0
04@0oooo00@000000=VZY`3IZZL0fJZW0`0000070>ZiW`D0000000@0gGU;00000000000000000P3o
ool00`000000f=3A0=S@d@0:000000030?ooo`000000000000<0h[:T00<0000007NXlP1gZ?80:@1g
Z?87000000D0NZSa0P00000606LQH@@000002@21RM<<000005L0oooo00140?ooo`030000003IZZL0
fJZW00<0fJZW1`0000060>ZiWaL000000`3R/Z@00`000000MjSb07NXlP0R07NXlPH000003P1jZ?46
000000<0NUjW00<000000869d`21RM<04`00001G0?ooo`00A03oool00`000000fJZW0=VZY`030=VZ
Y`030000003Qg=00hMc@00@0hMc@7@0000040>:bY1d0MjSb1`00000E07ZXl@030000001jGZL0NUjW
00<0NUjW6000001G0?ooo`00A03oool6000000`0hMc@600000050>:bY0030000001gZ?80MjSb0180
MjSb1`00000J07ZXl@@00000101jGZLH000005L0oooo00140?ooo`030000003>N6/0cWQ[0080cWQ[
9@0000060>:bY0800000301gZ?87000001X0NZSa1P00000807YNYa<00000G03oool004D0oooo1000
00030:K`mPT000001`1gZ?800`000000hK6U0>6aY@0>000000T0h[:T00<0000007NXlP1gZ?800P1g
Z?87000000L0h[:T4`1jZ?47000000d0NUjW3@0000000`1lH:P000000?ooo`1P0?ooo`00@`3oool9
00000100MjSb00<000000>6aY@3Q/JD04P0000050>:bY0T000002`3R/Z@00`000000NZSa07ZXl@09
07ZXl@H000003P1jGZL6000000@0OhWC0`00000407aPZ0@00000H@3oool003h0oooo1@00000I07NX
lP030000003Q/JD0hK6U00@0hK6U2P0000040=WBd@d000003@3R/Z@00`000000NZSa07ZXl@0207ZX
l@H000000P2mU:d3000000T0NUjW1P00000:07n9d`L000000`1[9FD00`000000oooo0?ooo`1O0?oo
o`00>03oool6000001h0MjSb00<000000>6aY@3Q/JD0203Q/JD00`000000NZSa00000003000000T0
fM;A3`0000070>:bY0P00000102mU:d3000000<0NUjW1P00000A07n9d`030000001[9FD0JbEU00D0
JbEU00<000000?ooo`3oool0H03oool003D0oooo0`00000T07NXlPH000001@3Q/JD00`000000NZSa
07ZXl@02000000T0fM;A2@0000070=WBd@P000000`3R/Z@4000000@0_IB]1P00000G07n9d`030000
001[9FD0JbEU00D0JbEU00<000000?ooo`3oool0H03oool003H0oooo00<0000007NXlP1gZ?808`1g
Z?82000000<0eWYP1`00000207ZXl@030000003Id]40fM;A00P0fM;A00@000000>6aY@3Q/JD0hK6U
1@00000?0=WBd@l000005P1oRM<500000080JbEU1000001S0?ooo`00=`3oool2000001h0MjSb1@00
00000`1jZ?4000000=IjH0090=IjH0030000001jZ?40000000T0fM;A1@00000G0=WBd@040000002I
SLD0VHg5000000@0_JO41000000>07n9d`P000001@1c^_`20000000301<000000000000006@0oooo
000i0?ooo`030000001gZ?80MjSb01D0MjSb1P0000020?ooo`030000001jZ?40NZSa0080NZSa00<0
00000=IjH03FNV001`3FNV02000000X0fM;A00D000000=IjH03FNV00eWYP0000000F0=WBd@<00000
00<0VHg50000002mYl@00P2mYl@6000000D0OhWC2000000?07>jo0030000003oool0oooo06@0oooo
000j0?ooo`030000001gZ?80MjSb00l0MjSb1@0000090?ooo`050000001jZ?40NZSa07ZXl@000000
2P3FNV05000000D0fM;A00D000000=IjH03FNV00eWYP0000000G0=WBd@d0000000<0oooo00000000
00000`00000;07>jo0P00000J`3oool003/0oooo0P00000:07NXlPD000003`3oool010000000NZSa
07ZXl@1jZ?4600000080eWYP0P0000050:OVn`H000000`3FNV0600000140fM;A00H0000005F9i`1E
RNL0000009NVh@0000030;NmgP040000003?g>800000000000<0oooo0P00000507>jo0/000000`3@
aM000`000000oooo0?ooo`1Z0?ooo`00?@3oool00`000000MjSb07NXlP0207NXlPD000005@3oool0
10000000NZSa07ZXl@1jZ?4300000080GP000P00000:0:OVn`8000000P3FNV02000000H0YnKk2`00
00060=WBd@80000000P0EHWW0000002GY^40UjKQ0000002g_Mh000000<oLhP8000001P3oool50000
00@0oooo1P000000102Ye_L0000000000000001]0?ooo`00?P3oool3000001`0oooo0`0000030?oo
o`L000001P2Wi_/00`000000GP0000000002000001<0YnKk1P0000000`1[9FD000000?ooo`080000
01<0oooo1@00001_0?ooo`00JP3oool6000000030?ooo`000000000000D000004`2Wi_/4000000@0
oooo0P00002;0?ooo`00N03oool;000000H0YnKk100000060?ooo`800000R`3oool007P0oooo0`00
000407>jo0X000002P3oool3000008X0oooo001j0?ooo`D00000503oool3000008X0oooo002=0?oo
oa000000P`3oool008`0oooo00<00000044aV0000000102HMZ`00`000000_IB]0;fD[@020;fD[@05
0000003R/J@0h[6T0>:aY0000000P`3oool008`0oooo00<00000044aV0000000102HMZ`00`000000
_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:aY0000000P`3oool008`0oooo00<00000044aV000
0000102HMZ`00`000000_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:aY0000000P`3oool008`0
oooo00<00000044aV0000000102HMZ`00`000000_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:a
Y0000000P`3oool008`0oooo00<00000044aV0000000102HMZ`00`000000_IB]0;fD[@020;fD[@05
0000003R/J@0h[6T0>:aY0000000P`3oool008`0oooo00<00000044aV0000000102HMZ`00`000000
_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:aY0000000P`3oool008`0oooo00<00000044aV000
0000102HMZ`00`000000_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:aY0000000P`3oool008`0
oooo00<00000044aV0000000102HMZ`00`000000_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:a
Y0000000P`3oool008`0oooo00<00000044aV0000000102HMZ`00`000000_IB]0;fD[@020;fD[@05
0000003R/J@0h[6T0>:aY0000000P`3oool008`0oooo00<00000044aV0000000102HMZ`00`000000
_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:aY0000000P`3oool008`0oooo00<00000044aV000
0000102HMZ`00`000000_IB]0;fD[@020;fD[@050000003R/J@0h[6T0>:aY0000000P`3oool008`0
oooo00@00000044aV011<IP00000102HMZ`00`000000_IB]0;fD[@020;fD[@040000003R/J@0h[6T
000008<0oooo002=0?ooo`0300000011<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`00
0000h[6T0>:aY00200000880oooo002=0?ooo`0300000011<IP0000000@0V7J/00<000000;fD[@2m
U:d00P2mU:d00`000000h[6T0>:aY00200000880oooo002=0?ooo`0300000011<IP0000000@0V7J/
00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY00200000880oooo002=0?ooo`0300000011
<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY00200000880oooo002=
0?ooo`0300000011<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY002
00000880oooo002=0?ooo`0300000011<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`00
0000h[6T0>:aY00200000880oooo002=0?ooo`0300000011<IP0000000@0V7J/00<000000;fD[@2m
U:d00P2mU:d00`000000h[6T0>:aY00200000880oooo002=0?ooo`0300000011<IP0000000@0V7J/
00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY00200000880oooo002=0?ooo`0300000011
<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY00200000880oooo002=
0?ooo`0300000011<IP0000000@0V7J/00<000000;fD[@2mU:d00P2mU:d00`000000h[6T0>:aY002
00000880oooo002=0?oooa400000PP3oool008d0oooo4@0000220?ooo`00U03oool2000008X0oooo
002D0?ooo`800000RP3oool009@0oooo0P00002:0?ooo`00U03oool2000008X0oooo002D0?ooo`80
0000RP3oool009@0oooo0P00002:0?ooo`00U03oool2000008X0oooo002D0?ooo`800000RP3oool0
09@0oooo0P00002:0?ooo`00U03oool2000008X0oooo002D0?ooo`800000RP3oool009@0oooo0P00
002:0?ooo`00U03oool3000008T0oooo002E0?ooo`030000003oool0oooo08P0oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.5127 .55696 m .52246 .55494 L .51782 .55543 L closepath p .153 .691 .703 r
F P
0 g
s
.52246 .55494 m .53154 .55899 L .51782 .55543 L closepath p .338 0 0 r
F P
0 g
s
.50597 .56427 m .5127 .55696 L .51782 .55543 L closepath p 0 0 0 r
F P
0 g
s
.53154 .55899 m .53648 .56757 L .51782 .55543 L closepath p .794 .368 0 r
F P
0 g
s
.50484 .5741 m .50597 .56427 L .51782 .55543 L closepath p 0 0 .141 r
F P
0 g
s
.53648 .56757 m .53537 .5774 L .51782 .55543 L closepath p .973 .837 .429 r
F P
0 g
s
.50976 .58269 m .50484 .5741 L .51782 .55543 L closepath p 0 .12 .668 r
F P
0 g
s
.53537 .5774 m .52864 .58473 L .51782 .55543 L closepath p .868 .992 .82 r
F P
0 g
s
.51885 .58675 m .50976 .58269 L .51782 .55543 L closepath p .254 .593 .949 r
F P
0 g
s
.52864 .58473 m .51885 .58675 L .51782 .55543 L closepath p .604 .89 .99 r
F P
0 g
s
.37112 .28604 m .49543 .43888 L .49378 .43006 L p 0 .086 .634 r
F P
0 g
s
.49378 .43006 m .36709 .27436 L .37112 .28604 L p 0 .086 .634 r
F P
0 g
s
.56544 .44628 m .72234 .32222 L .72512 .31117 L p .723 .987 .816 r
F P
0 g
s
.52286 .51113 m .5316 .43419 L .51511 .43142 L p .765 .606 .682 r
F P
0 g
s
.5316 .43419 m .52286 .51113 L .5392 .51202 L p .629 .483 .665 r
F P
0 g
s
.5392 .51202 m .54789 .43488 L .5316 .43419 L p .629 .483 .665 r
F P
0 g
s
.50626 .5085 m .51511 .43142 L .50453 .42758 L p .909 .743 .663 r
F P
0 g
s
.51511 .43142 m .50626 .5085 L .52286 .51113 L p .765 .606 .682 r
F P
0 g
s
.54789 .43488 m .5392 .51202 L .5492 .51082 L p .366 .251 .588 r
F P
0 g
s
.5492 .51082 m .5579 .43321 L .54789 .43488 L p .366 .251 .588 r
F P
0 g
s
.72512 .31117 m .56516 .43758 L .56544 .44628 L p .723 .987 .816 r
F P
0 g
s
.47395 .54183 m .39571 .53341 L .39363 .55053 L p .701 .548 .676 r
F P
0 g
s
.39571 .53341 m .47395 .54183 L .4751 .52639 L p .679 .641 .805 r
F P
0 g
s
.4751 .52639 m .39659 .51797 L .39571 .53341 L p .679 .641 .805 r
F P
0 g
s
.47195 .55898 m .39363 .55053 L .39112 .56297 L p .693 .409 .489 r
F P
0 g
s
.39363 .55053 m .47195 .55898 L .47395 .54183 L p .701 .548 .676 r
F P
0 g
s
.50453 .42758 m .49559 .50509 L .50626 .5085 L p .909 .743 .663 r
F P
0 g
s
.50085 .55903 m .50227 .54665 L .5185 .54915 L p .765 .606 .682 r
F P
0 g
s
.5185 .54915 m .5171 .56151 L .50085 .55903 L p .765 .606 .682 r
F P
0 g
s
.51963 .53721 m .5185 .54915 L .50227 .54665 L p .749 .668 .772 r
F P
0 g
s
.5171 .56151 m .5185 .54915 L .53447 .55011 L p .629 .483 .665 r
F P
0 g
s
.5185 .54915 m .51963 .53721 L .53245 .53796 L p .621 .554 .758 r
F P
0 g
s
.53245 .53796 m .53447 .55011 L .5185 .54915 L p .621 .554 .758 r
F P
0 g
s
.49559 .50509 m .50453 .42758 L .50397 .42411 L p .819 .73 .202 r
F P
0 g
s
.39112 .56297 m .46985 .57148 L .47195 .55898 L p .693 .409 .489 r
F P
0 g
s
.50262 .56994 m .50085 .55903 L .5171 .56151 L p .767 .524 .566 r
F P
0 g
s
.5171 .56151 m .51568 .57191 L .50262 .56994 L p .767 .524 .566 r
F P
0 g
s
.51568 .57191 m .5171 .56151 L .53307 .5625 L p .624 .391 .545 r
F P
0 g
s
.53447 .55011 m .53307 .5625 L .5171 .56151 L p .629 .483 .665 r
F P
0 g
s
.68746 .5648 m .57487 .55269 L .57298 .56988 L p .701 .548 .676 r
F P
0 g
s
.57487 .55269 m .68746 .5648 L .68938 .54938 L p .679 .641 .805 r
F P
0 g
s
.68938 .54938 m .57639 .53726 L .57487 .55269 L p .679 .641 .805 r
F P
0 g
s
.5579 .43321 m .5492 .51082 L .54897 .50796 L p .773 .692 .149 r
F P
0 g
s
.54897 .50796 m .55774 .42977 L .5579 .43321 L p .773 .692 .149 r
F P
0 g
s
.39659 .51797 m .4751 .52639 L .47498 .51845 L p .564 .751 .965 r
F P
0 g
s
.47498 .51845 m .39593 .50998 L .39659 .51797 L p .564 .751 .965 r
F P
0 g
s
.50227 .54665 m .5066 .53518 L .51963 .53721 L p .749 .668 .772 r
F P
0 g
s
.52025 .52798 m .51963 .53721 L .5066 .53518 L p .707 .731 .87 r
F P
0 g
s
.51963 .53721 m .52025 .52798 L .52739 .52839 L p .595 .633 .859 r
F P
0 g
s
.52739 .52839 m .53245 .53796 L .51963 .53721 L p .595 .633 .859 r
F P
0 g
s
.49038 .55599 m .49182 .54354 L .50227 .54665 L p .909 .743 .663 r
F P
0 g
s
.50227 .54665 m .50085 .55903 L .49038 .55599 L p .909 .743 .663 r
F P
0 g
s
.5066 .53518 m .50227 .54665 L .49182 .54354 L p .872 .816 .791 r
F P
0 g
s
.68568 .58203 m .57298 .56988 L .57141 .58246 L p .693 .409 .489 r
F P
0 g
s
.57298 .56988 m .68568 .58203 L .68746 .5648 L p .701 .548 .676 r
F P
0 g
s
.53307 .5625 m .53447 .55011 L .54421 .54917 L p .366 .251 .588 r
F P
0 g
s
.53447 .55011 m .53245 .53796 L .54025 .53715 L p .381 .381 .735 r
F P
0 g
s
.54025 .53715 m .54421 .54917 L .53447 .55011 L p .381 .381 .735 r
F P
0 g
s
.49421 .56755 m .49038 .55599 L .50085 .55903 L p .911 .622 .484 r
F P
0 g
s
.50085 .55903 m .50262 .56994 L .49421 .56755 L p .911 .622 .484 r
F P
0 g
s
.50382 .6785 m .51275 .59997 L .49605 .5975 L p .765 .606 .682 r
F P
0 g
s
.51275 .59997 m .50382 .6785 L .52029 .67984 L p .629 .483 .665 r
F P
0 g
s
.52029 .67984 m .52916 .60109 L .51275 .59997 L p .629 .483 .665 r
F P
0 g
s
.49182 .54354 m .49823 .53264 L .5066 .53518 L p .872 .816 .791 r
F P
0 g
s
.513 .52685 m .5066 .53518 L .49823 .53264 L p .786 .866 .908 r
F P
0 g
s
.5066 .53518 m .513 .52685 L .52025 .52798 L p .707 .731 .87 r
F P
0 g
s
.53307 .5625 m .52852 .57274 L .51568 .57191 L p .624 .391 .545 r
F P
0 g
s
.52852 .57274 m .53307 .5625 L .54282 .56164 L p .33 .085 .383 r
F P
0 g
s
.54421 .54917 m .54282 .56164 L .53307 .5625 L p .366 .251 .588 r
F P
0 g
s
.53245 .53796 m .52739 .52839 L .53171 .52791 L p .381 .514 .867 r
F P
0 g
s
.53171 .52791 m .54025 .53715 L .53245 .53796 L p .381 .514 .867 r
F P
0 g
s
.50725 .57725 m .50262 .56994 L .51568 .57191 L p .731 .353 .336 r
F P
0 g
s
.51568 .57191 m .51453 .57834 L .50725 .57725 L p .731 .353 .336 r
F P
0 g
s
.51453 .57834 m .51568 .57191 L .52852 .57274 L p .581 .212 .307 r
F P
0 g
s
.46985 .57148 m .39112 .56297 L .38912 .56599 L p .436 0 0 r
F P
0 g
s
.57141 .58246 m .6847 .59471 L .68568 .58203 L p .693 .409 .489 r
F P
0 g
s
.57639 .53726 m .68938 .54938 L .69072 .54156 L p .564 .751 .965 r
F P
0 g
s
.69072 .54156 m .57696 .52937 L .57639 .53726 L p .564 .751 .965 r
F P
0 g
s
.48702 .67618 m .49605 .5975 L .48525 .5946 L p .909 .743 .663 r
F P
0 g
s
.49605 .5975 m .48702 .67618 L .50382 .6785 L p .765 .606 .682 r
F P
0 g
s
.50397 .42411 m .49495 .50219 L .49559 .50509 L p .819 .73 .202 r
F P
0 g
s
.01 w
.52104 .51639 m
.52976 .43975 L
s
.49769 .72166 m
.50985 .61471 L
s
.5 Mabswid
.50259 .57594 m .49421 .56755 L .50262 .56994 L p .814 .353 .132 r
F P
0 g
s
.50262 .56994 m .50725 .57725 L .50259 .57594 L p .814 .353 .132 r
F P
0 g
s
.52025 .52798 m .513 .52685 L p .51962 .52413 L .255 .717 .95 r
F P
0 g
s
.52739 .52839 m .52025 .52798 L p .51962 .52413 L .255 .717 .95 r
F P
0 g
s
.52916 .60109 m .52029 .67984 L .53027 .67969 L p .366 .251 .588 r
F P
0 g
s
.53027 .67969 m .53916 .60044 L .52916 .60109 L p .366 .251 .588 r
F P
0 g
s
.38912 .56599 m .46844 .57457 L .46985 .57148 L p .436 0 0 r
F P
0 g
s
.52852 .57274 m .52168 .57881 L .51453 .57834 L p .581 .212 .307 r
F P
0 g
s
.01 w
.50985 .61471 m
.51307 .58645 L
s
.5 Mabswid
.52168 .57881 m .52852 .57274 L .53632 .57209 L p .23 0 0 r
F P
0 g
s
.54282 .56164 m .53632 .57209 L .52852 .57274 L p .33 .085 .383 r
F P
0 g
s
.513 .52685 m .50837 .52541 L p .51962 .52413 L .255 .717 .95 r
F P
0 g
s
.49823 .53264 m .50837 .52541 L .513 .52685 L p .786 .866 .908 r
F P
0 g
s
.53171 .52791 m .52739 .52839 L p .51962 .52413 L .255 .717 .95 r
F P
0 g
s
.6847 .59471 m .57141 .58246 L .57076 .58563 L p .436 0 0 r
F P
0 g
s
.48972 .55352 m .49117 .54098 L .49182 .54354 L p .819 .729 .201 r
F P
0 g
s
.49182 .54354 m .49038 .55599 L .48972 .55352 L p .819 .729 .201 r
F P
0 g
s
.49823 .53264 m .49182 .54354 L .49117 .54098 L p .816 .942 .583 r
F P
0 g
s
.49117 .54098 m .49775 .53052 L .49823 .53264 L p .816 .942 .583 r
F P
0 g
s
.50837 .52541 m .49823 .53264 L .49775 .53052 L p .67 .975 .842 r
F P
0 g
s
.49495 .50219 m .50397 .42411 L .51383 .42235 L p .351 .237 .581 r
F P
0 g
s
.39593 .50998 m .47498 .51845 L .4736 .52115 L p .402 0 0 r
F P
0 g
s
.4736 .52115 m .39396 .51261 L .39593 .50998 L p .402 0 0 r
F P
0 g
s
.49371 .56564 m .48972 .55352 L .49038 .55599 L p 0 0 .241 r
F P
0 g
s
.49038 .55599 m .49421 .56755 L .49371 .56564 L p 0 0 .241 r
F P
0 g
s
.51453 .57834 m .52168 .57881 L p .50662 .57455 L .214 .699 .929 r
F P
0 g
s
.50725 .57725 m .51453 .57834 L p .50662 .57455 L .214 .699 .929 r
F P
0 g
s
.54421 .54917 m .54025 .53715 L .54002 .53506 L p 0 0 .295 r
F P
0 g
s
.54025 .53715 m .53171 .52791 L .53155 .52673 L p 0 .151 .676 r
F P
0 g
s
.53155 .52673 m .54002 .53506 L .54025 .53715 L p 0 .151 .676 r
F P
0 g
s
.54002 .53506 m .54395 .54666 L .54421 .54917 L p 0 0 .295 r
F P
0 g
s
.54282 .56164 m .54421 .54917 L .54395 .54666 L p .773 .693 .149 r
F P
0 g
s
.50837 .52541 m .50814 .52422 L p .51962 .52413 L .255 .717 .95 r
F P
0 g
s
.49775 .53052 m .50814 .52422 L .50837 .52541 L p .67 .975 .842 r
F P
0 g
s
.55774 .42977 m .54897 .50796 L .53839 .5045 L p .914 .747 .66 r
F P
0 g
s
.53839 .5045 m .54726 .42587 L .55774 .42977 L p .914 .747 .66 r
F P
0 g
s
.53155 .52673 m .53171 .52791 L p .51962 .52413 L .255 .717 .95 r
F P
0 g
s
.01 w
.52015 .52425 m
.52104 .51639 L
s
.5 Mabswid
.50259 .57594 m .50725 .57725 L p .50662 .57455 L .214 .699 .929 r
F P
0 g
s
.53632 .57209 m .54282 .56164 L .54254 .55921 L p .782 .921 .544 r
F P
0 g
s
.54395 .54666 m .54254 .55921 L .54282 .56164 L p .773 .693 .149 r
F P
0 g
s
.57076 .58563 m .6849 .59798 L .6847 .59471 L p .436 0 0 r
F P
0 g
s
.53632 .57209 m .526 .57847 L .52168 .57881 L p .23 0 0 r
F P
0 g
s
.52168 .57881 m .526 .57847 L p .50662 .57455 L .214 .699 .929 r
F P
0 g
s
.48525 .5946 m .47612 .67373 L .48702 .67618 L p .909 .743 .663 r
F P
0 g
s
.02 w
.54338 .55417 m
.54628 .55448 L
s
.49077 .54851 m
.54311 .55414 L
s
.54628 .55448 m
.74497 .57587 L
s
.481 .54746 m
.49031 .54846 L
s
.39253 .53793 m
.481 .54746 L
s
.5 Mabswid
.50233 .57491 m .49371 .56564 L .49421 .56755 L p 0 .11 .634 r
F P
0 g
s
.49421 .56755 m .50259 .57594 L .50233 .57491 L p 0 .11 .634 r
F P
0 g
s
.47612 .67373 m .48525 .5946 L .48454 .59235 L p .819 .73 .202 r
F P
0 g
s
.526 .57847 m .53632 .57209 L .53607 .57021 L p .638 .963 .816 r
F P
0 g
s
.54254 .55921 m .53607 .57021 L .53632 .57209 L p .782 .921 .544 r
F P
0 g
s
.57696 .52937 m .69072 .54156 L .69096 .54444 L p .402 0 0 r
F P
0 g
s
.69096 .54444 m .57634 .53216 L .57696 .52937 L p .402 0 0 r
F P
0 g
s
.46844 .57457 m .38912 .56599 L .3884 .55824 L p .553 .754 .971 r
F P
0 g
s
.53916 .60044 m .53027 .67969 L .5299 .67808 L p .773 .692 .149 r
F P
0 g
s
.5299 .67808 m .53885 .59824 L .53916 .60044 L p .773 .692 .149 r
F P
0 g
s
.50662 .57455 m .50233 .57491 L .50259 .57594 L p .214 .699 .929 r
F P
0 g
s
.50814 .52422 m .51243 .52373 L .51962 .52413 L p .255 .717 .95 r
F P
0 g
s
.50546 .52967 m .51243 .52373 L .50814 .52422 L p .195 0 0 r
F P
0 g
s
.50814 .52422 m .49775 .53052 L .50546 .52967 L p .195 0 0 r
F P
0 g
s
.526 .57847 m .52582 .57744 L p .50662 .57455 L .214 .699 .929 r
F P
0 g
s
.01 w
.51307 .58645 m
.51418 .57669 L
s
.5 Mabswid
.53607 .57021 m .52582 .57744 L .526 .57847 L p .638 .963 .816 r
F P
0 g
s
.51962 .52413 m .52694 .52528 L .53155 .52673 L p .255 .717 .95 r
F P
0 g
s
.01 w
.51429 .57571 m
.51994 .52607 L
s
.5 Mabswid
.54002 .53506 m .53155 .52673 L .52694 .52528 L p .807 .333 .095 r
F P
0 g
s
.51383 .42235 m .5048 .50091 L .49495 .50219 L p .351 .237 .581 r
F P
0 g
s
.3884 .55824 m .46826 .56687 L .46844 .57457 L p .553 .754 .971 r
F P
0 g
s
.50077 .53998 m .50546 .52967 L .49775 .53052 L p .31 .061 .365 r
F P
0 g
s
.49775 .53052 m .49117 .54098 L .50077 .53998 L p .31 .061 .365 r
F P
0 g
s
.5048 .50091 m .51383 .42235 L .53043 .42302 L p .627 .48 .663 r
F P
0 g
s
.54395 .54666 m .54002 .53506 L .53171 .53248 L p .915 .621 .472 r
F P
0 g
s
.52694 .52528 m .53171 .53248 L .54002 .53506 L p .807 .333 .095 r
F P
0 g
s
.54726 .42587 m .53839 .5045 L .52146 .50179 L p .766 .607 .681 r
F P
0 g
s
.52146 .50179 m .53043 .42302 L .54726 .42587 L p .766 .607 .681 r
F P
0 g
s
.51847 .53041 m .51962 .52413 L .51243 .52373 L p .572 .195 .288 r
F P
0 g
s
.51243 .52373 m .50546 .52967 L .51847 .53041 L p .572 .195 .288 r
F P
0 g
s
.6849 .59798 m .57076 .58563 L .57129 .578 L p .553 .754 .971 r
F P
0 g
s
.49932 .55259 m .50077 .53998 L .49117 .54098 L p .352 .237 .581 r
F P
0 g
s
.49117 .54098 m .48972 .55352 L .49932 .55259 L p .352 .237 .581 r
F P
0 g
s
.53171 .53248 m .52694 .52528 L .51962 .52413 L p .728 .342 .319 r
F P
0 g
s
.49371 .56564 m .50233 .57491 L .50662 .57455 L p .363 .508 .869 r
F P
0 g
s
.48454 .59235 m .47533 .67208 L .47612 .67373 L p .819 .73 .202 r
F P
0 g
s
.52582 .57744 m .52118 .57612 L p .50662 .57455 L .214 .699 .929 r
F P
0 g
s
.52582 .57744 m .53607 .57021 L .52772 .56779 L p .786 .874 .912 r
F P
0 g
s
.52772 .56779 m .52118 .57612 L .52582 .57744 L p .786 .874 .912 r
F P
0 g
s
.39396 .51261 m .4736 .52115 L .47147 .53366 L p .691 .403 .481 r
F P
0 g
s
.47147 .53366 m .39141 .52506 L .39396 .51261 L p .691 .403 .481 r
F P
0 g
s
.50142 .56495 m .49932 .55259 L .48972 .55352 L p .368 .373 .733 r
F P
0 g
s
.48972 .55352 m .49371 .56564 L .50142 .56495 L p .368 .373 .733 r
F P
0 g
s
.50662 .57455 m .50142 .56495 L .49371 .56564 L p .363 .508 .869 r
F P
0 g
s
.51962 .52413 m .51847 .53041 L .53171 .53248 L p .728 .342 .319 r
F P
0 g
s
.54254 .55921 m .54395 .54666 L .53359 .5435 L p .914 .747 .66 r
F P
0 g
s
.53171 .53248 m .53359 .5435 L .54395 .54666 L p .915 .621 .472 r
F P
0 g
s
.53607 .57021 m .54254 .55921 L .53216 .55613 L p .876 .823 .793 r
F P
0 g
s
.53216 .55613 m .52772 .56779 L .53607 .57021 L p .876 .823 .793 r
F P
0 g
s
.53043 .42302 m .52146 .50179 L .5048 .50091 L p .627 .48 .663 r
F P
0 g
s
.53359 .5435 m .53216 .55613 L .54254 .55921 L p .914 .747 .66 r
F P
0 g
s
.57129 .578 m .68622 .59042 L .6849 .59798 L p .553 .754 .971 r
F P
0 g
s
.52118 .57612 m .51383 .57502 L .50662 .57455 L p .214 .699 .929 r
F P
0 g
s
.50142 .56495 m .50662 .57455 L .51383 .57502 L p .59 .634 .863 r
F P
0 g
s
.52118 .57612 m .52772 .56779 L .51445 .56577 L p .706 .735 .874 r
F P
0 g
s
.51445 .56577 m .51383 .57502 L .52118 .57612 L p .706 .735 .874 r
F P
0 g
s
.47533 .67208 m .48454 .59235 L .49438 .59164 L p .351 .237 .581 r
F P
0 g
s
.46826 .56687 m .3884 .55824 L .38928 .54256 L p .678 .642 .808 r
F P
0 g
s
.51703 .54094 m .51847 .53041 L .50546 .52967 L p .621 .386 .539 r
F P
0 g
s
.50546 .52967 m .50077 .53998 L .51703 .54094 L p .621 .386 .539 r
F P
0 g
s
.57634 .53216 m .69096 .54444 L .68999 .55713 L p .691 .403 .481 r
F P
0 g
s
.68999 .55713 m .57476 .54475 L .57634 .53216 L p .691 .403 .481 r
F P
0 g
s
.51383 .57502 m .51445 .56577 L .50142 .56495 L p .59 .634 .863 r
F P
0 g
s
.53359 .5435 m .53171 .53248 L .51847 .53041 L p .768 .522 .561 r
F P
0 g
s
.53885 .59824 m .5299 .67808 L .5191 .6756 L p .914 .747 .66 r
F P
0 g
s
.5191 .6756 m .52815 .5953 L .53885 .59824 L p .914 .747 .66 r
F P
0 g
s
.38928 .54256 m .46942 .5512 L .46826 .56687 L p .678 .642 .808 r
F P
0 g
s
.51847 .53041 m .51703 .54094 L .53359 .5435 L p .768 .522 .561 r
F P
0 g
s
.49932 .55259 m .50142 .56495 L .51445 .56577 L p .619 .554 .759 r
F P
0 g
s
.39141 .52506 m .47147 .53366 L .46942 .5512 L p .701 .547 .675 r
F P
0 g
s
.46942 .5512 m .38928 .54256 L .39141 .52506 L p .701 .547 .675 r
F P
0 g
s
.51559 .55359 m .51703 .54094 L .50077 .53998 L p .627 .48 .663 r
F P
0 g
s
.50077 .53998 m .49932 .55259 L .51559 .55359 L p .627 .48 .663 r
F P
0 g
s
.52772 .56779 m .53216 .55613 L .51559 .55359 L p .749 .67 .773 r
F P
0 g
s
.51559 .55359 m .51445 .56577 L .52772 .56779 L p .749 .67 .773 r
F P
0 g
s
.53216 .55613 m .53359 .5435 L .51703 .54094 L p .766 .607 .681 r
F P
0 g
s
.68622 .59042 m .57129 .578 L .57282 .56234 L p .678 .642 .808 r
F P
0 g
s
.51445 .56577 m .51559 .55359 L .49932 .55259 L p .619 .554 .759 r
F P
0 g
s
.51703 .54094 m .51559 .55359 L .53216 .55613 L p .766 .607 .681 r
F P
0 g
s
.03 w
.51507 .54054 m
.51623 .5468 L
s
.51623 .5468 m
.51631 .54726 L
s
.5 Mabswid
.49438 .59164 m .48516 .67187 L .47533 .67208 L p .351 .237 .581 r
F P
0 g
s
.57282 .56234 m .68817 .57477 L .68622 .59042 L p .678 .642 .808 r
F P
0 g
s
.57476 .54475 m .68999 .55713 L .68817 .57477 L p .701 .547 .675 r
F P
0 g
s
.68817 .57477 m .57282 .56234 L .57476 .54475 L p .701 .547 .675 r
F P
0 g
s
.48516 .67187 m .49438 .59164 L .5111 .59277 L p .627 .48 .663 r
F P
0 g
s
.52815 .5953 m .5191 .6756 L .50194 .67322 L p .766 .607 .681 r
F P
0 g
s
.50194 .67322 m .5111 .59277 L .52815 .5953 L p .766 .607 .681 r
F P
0 g
s
.5111 .59277 m .50194 .67322 L .48516 .67187 L p .627 .48 .663 r
F P
0 g
s
.51728 .48445 m .52008 .50267 L .5431 .51289 L p .033 .502 .882 r
F P
0 g
s
.52008 .50267 m .51728 .48445 L .49138 .4898 L p .47 .877 .95 r
F P
0 g
s
.49138 .4898 m .49534 .50778 L .52008 .50267 L p .47 .877 .95 r
F P
0 g
s
.49534 .50778 m .49138 .4898 L .4735 .50914 L p .771 .981 .724 r
F P
0 g
s
.4735 .50914 m .47826 .52627 L .49534 .50778 L p .771 .981 .724 r
F P
0 g
s
.5431 .51289 m .54138 .49513 L .51728 .48445 L p .033 .502 .882 r
F P
0 g
s
.54138 .49513 m .5431 .51289 L .55563 .53457 L p 0 0 .492 r
F P
0 g
s
.47826 .52627 m .4735 .50914 L .47046 .53516 L p .828 .736 .212 r
F P
0 g
s
.47046 .53516 m .47537 .55115 L .47826 .52627 L p .828 .736 .212 r
F P
0 g
s
.55563 .53457 m .5545 .51781 L .54138 .49513 L p 0 0 .492 r
F P
0 g
s
.5545 .51781 m .55563 .53457 L .55285 .5595 L p .763 .684 .138 r
F P
0 g
s
.47537 .55115 m .47046 .53516 L .48349 .55794 L p 0 0 .423 r
F P
0 g
s
.48349 .55794 m .48782 .57293 L .47537 .55115 L p 0 0 .423 r
F P
0 g
s
.55159 .54388 m .55285 .5595 L .53576 .57811 L p .727 .959 .677 r
F P
0 g
s
.55285 .5595 m .55159 .54388 L .5545 .51781 L p .763 .684 .138 r
F P
0 g
s
.48782 .57293 m .48349 .55794 L .50765 .56874 L p 0 .462 .843 r
F P
0 g
s
.50765 .56874 m .5109 .58325 L .48782 .57293 L p 0 .462 .843 r
F P
0 g
s
.53369 .56336 m .53576 .57811 L .5109 .58325 L p .42 .859 .921 r
F P
0 g
s
.53576 .57811 m .53369 .56336 L .55159 .54388 L p .727 .959 .677 r
F P
0 g
s
.5109 .58325 m .50765 .56874 L .53369 .56336 L p .42 .859 .921 r
F P
0 g
s
.46472 .51691 m .31479 .50085 L .31631 .52784 L p .622 .717 .914 r
F P
0 g
s
.31631 .52784 m .46408 .54374 L .46472 .51691 L p .622 .717 .914 r
F P
0 g
s
.71647 .54387 m .56514 .52766 L .56304 .55439 L p .622 .717 .914 r
F P
0 g
s
.56304 .55439 m .71216 .57044 L .71647 .54387 L p .622 .717 .914 r
F P
0 g
s
.46201 .49853 m .23818 .47463 L .24122 .50633 L p .618 .72 .918 r
F P
0 g
s
.24122 .50633 m .46131 .52996 L .46201 .49853 L p .618 .72 .918 r
F P
0 g
s
.51544 .47245 m .51679 .48124 L .54108 .492 L p .033 .502 .882 r
F P
0 g
s
.51679 .48124 m .51544 .47245 L .48877 .47795 L p .47 .877 .95 r
F P
0 g
s
.48877 .47795 m .49068 .48663 L .51679 .48124 L p .47 .877 .95 r
F P
0 g
s
.49068 .48663 m .48877 .47795 L .47036 .49786 L p .771 .981 .724 r
F P
0 g
s
.47036 .49786 m .47266 .50613 L .49068 .48663 L p .771 .981 .724 r
F P
0 g
s
.54108 .492 m .54025 .48343 L .51544 .47245 L p .033 .502 .882 r
F P
0 g
s
.54025 .48343 m .54108 .492 L .5543 .51486 L p 0 0 .492 r
F P
0 g
s
.47266 .50613 m .47036 .49786 L .46722 .52463 L p .828 .736 .212 r
F P
0 g
s
.46722 .52463 m .46959 .53235 L .47266 .50613 L p .828 .736 .212 r
F P
0 g
s
.5543 .51486 m .55376 .50676 L .54025 .48343 L p 0 0 .492 r
F P
0 g
s
.55376 .50676 m .5543 .51486 L .55137 .54113 L p .763 .684 .138 r
F P
0 g
s
.46959 .53235 m .46722 .52463 L .48063 .54807 L p 0 0 .423 r
F P
0 g
s
.48063 .54807 m .48273 .55531 L .46959 .53235 L p 0 0 .423 r
F P
0 g
s
.55076 .53359 m .55137 .54113 L .53333 .56076 L p .727 .959 .677 r
F P
0 g
s
.55137 .54113 m .55076 .53359 L .55376 .50676 L p .763 .684 .138 r
F P
0 g
s
.48273 .55531 m .48063 .54807 L .50552 .55917 L p 0 .462 .843 r
F P
0 g
s
.50552 .55917 m .50708 .56618 L .48273 .55531 L p 0 .462 .843 r
F P
0 g
s
.53233 .55363 m .53333 .56076 L .50708 .56618 L p .42 .859 .921 r
F P
0 g
s
.53333 .56076 m .53233 .55363 L .55076 .53359 L p .727 .959 .677 r
F P
0 g
s
.50708 .56618 m .50552 .55917 L .53233 .55363 L p .42 .859 .921 r
F P
0 g
s
.78863 .53341 m .56209 .50922 L .55971 .54053 L p .618 .72 .918 r
F P
0 g
s
.55971 .54053 m .78241 .56444 L .78863 .53341 L p .618 .72 .918 r
F P
0 g
s
.49279 .50789 m .50408 .5129 L .5103 .51468 L closepath p .301 0 0 r
F P
0 g
s
.48669 .49727 m .49279 .50789 L .5103 .51468 L closepath p .769 .343 0 r
F P
0 g
s
.4881 .48512 m .48669 .49727 L .5103 .51468 L closepath p .964 .83 .407 r
F P
0 g
s
.49647 .47607 m .4881 .48512 L .5103 .51468 L closepath p .863 .995 .813 r
F P
0 g
s
.5086 .47356 m .49647 .47607 L .5103 .51468 L closepath p .593 .892 .989 r
F P
0 g
s
.51988 .47856 m .5086 .47356 L .5103 .51468 L closepath p .232 .585 .946 r
F P
0 g
s
.526 .48915 m .51988 .47856 L .5103 .51468 L closepath p 0 .096 .651 r
F P
0 g
s
.52462 .50132 m .526 .48915 L .5103 .51468 L closepath p 0 0 .107 r
F P
0 g
s
.51625 .51039 m .52462 .50132 L .5103 .51468 L closepath p 0 0 0 r
F P
0 g
s
.50408 .5129 m .51625 .51039 L .5103 .51468 L closepath p .19 .72 .739 r
F P
0 g
s
.03 w
.5103 .51468 m
.51507 .54054 L
s
.50838 .50424 m
.50976 .51173 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00J@3oool00`000000oooo0?ooo`2d0?ooo`00J@3o
ool200000;D0oooo001Y0?ooo`03000000005Z8000000;@0oooo001Z0?ooo`800000]03oool006X0
oooo00<00000000FXP000000/`3oool006/0oooo0P005Z800`000000oooo0?ooo`2`0?ooo`00K03o
ool2000FXP030000003oool0oooo0:l0oooo001]0?ooo`8001JR00<000000?ooo`3oool0[P3oool0
06d0oooo00<00000000FXP000000/03oool006h0oooo00<00000000FXP000000[`3oool006l0oooo
00<00000000FXP000000[P3oool00700oooo0P005Z800`000000oooo0?ooo`1K0?ooo`030000003o
ool0oooo04d0oooo001a0?ooo`8001JR00<000000?ooo`3oool0F@3oool2000004l0oooo001b0?oo
o`03000FXP000000oooo05P0oooo0`00001@0?ooo`00LP3oool00`00000001JR0000001G0?ooo`04
0000002io=00^Oc@00000500oooo001c0?ooo`03000000005Z80000005D0oooo00@000000;Wld02i
o=000000D@3oool007@0oooo00<00000000FXP000000DP3oool2000000030;Wld000000000000580
oooo001e0?ooo`03000000005Z8000000500oooo00@000000;Wld02io=000000E03oool007H0oooo
00<001JR0000003oool0CP3oool010000000^Oc@0;Wld000001E0?ooo`00M`3oool00`005Z800000
0?ooo`1<0?ooo`040000002io=00^Oc@000005H0oooo001g0?ooo`03000000005Z80000004X0oooo
0P0000000`2io=0000000000001G0?ooo`00N03oool00`00000001JR000000180?ooo`040000002i
o=00^Oc@000005T0oooo001i0?ooo`03000000005Z80000004H0oooo00@000000;Wld02io=000000
FP3oool007X0oooo0P0000150?ooo`040000002io=00^Oc@000005/0oooo001k0?ooo`800000@P3o
ool2000000030;Wld0000000000005`0oooo001l0?ooo`03000FXP000000oooo03l0oooo00@00000
0;Wld02io=000000GP3oool007`0oooo00<00000000FXP000000?P3oool010000000^Oc@0;Wld000
001O0?ooo`00O@3oool00`00000001JR0000000k0?ooo`8000000P2io=000`000000oooo0?ooo`1N
0?ooo`00OP3oool2000003X0oooo00<000000;Wld02io=000P00001Q0?ooo`00O`3oool2000003P0
oooo00@000000;Wld02io=000000H`3oool00800oooo0P00000f0?ooo`040000002io=00^Oc@0000
06@0oooo00210?ooo`800000<`3oool200000080^Oc@00<000000?ooo`3oool0H`3oool00840oooo
00<00000000FXP000000<@3oool00`000000^Oc@0;Wld002000006H0oooo00220?ooo`800000<03o
ool010000000^Oc@0;Wld000001X0?ooo`00P`3oool2000002d0oooo0P0000020;Wld0030000003o
ool0oooo06L0oooo00240?ooo`800000:`3oool01@000000^Oc@0;Wld02io=00000006X0oooo0025
0?ooo`800000:@3oool00`000000^Oc@0;Wld002000006/0oooo00260?ooo`8000009`3oool01000
0000^Oc@0;Wld000001]0?ooo`00QP3oool2000002D0oooo0P0000020;Wld0030000003oool0oooo
06`0oooo00270?ooo`8000008`3oool01@000000^Oc@0;Wld02io=00000006l0oooo00280?ooo`80
00008@3oool00`000000^Oc@0;Wld00200000700oooo00290?ooo`8000007`3oool010000000^Oc@
0;Wld000001b0?ooo`00RP3oool2000001`0oooo0P0000020;Wld0030000003oool0oooo0740oooo
002;0?ooo`030000003oool0oooo0080oooo2`00000<0?ooo`050000002io=00^Oc@0;Wld0000000
M03oool008/0oooo0P0000030?ooo`040000001I?9@0FCbD000000@0X7ZY00<000000<BK[P34Vjh0
100000070?ooo`050000002io=00^Oc@0;Wld0000000M@3oool008`0oooo0P0000020?ooo`040000
001I?9@0FCbD000000@0X7ZY00<000000<BK[P34Vjh00P34Vjh010000000jKnX0000000000030?oo
o`8000000P2io=000`000000oooo0?ooo`1e0?ooo`00S@3oool010000000oooo0?ooo`00000205Tl
U0030000002PNZT0X7ZY0080X7ZY00<000000<BK[P34Vjh00P34Vjh010000000jKnX0>VoZ0000002
0?ooo`050000002io=00^Oc@0;Wld0000000N03oool008h0oooo00D000000?ooo`000000FCbD0000
00040:1jZ@0300000034Vjh0a9^^00<0a9^^00H000000>VoZ03Y_jP000000?ooo`0000030;Wld003
0000003oool0oooo07L0oooo002@0?ooo`030000001I?9@0000000@0X7ZY00<000000<BK[P34Vjh0
0P34Vjh01`000000jKnX0>VoZ03Y_jP000000?ooo`0000000P2io=000`000000oooo0?ooo`1h0?oo
o`00S`3oool010000000FCbD05TlU00000040:1jZ@0300000034Vjh0a9^^0080a9^^00<000000>Vo
Z03Y_jP00P0000000`3oool000000;Wld01l0?ooo`00S`3oool010000000FCbD05TlU00000040:1j
Z@0300000034Vjh0a9^^0080a9^^00@000000>VoZ03Y_jP000000P3oool00`000000oooo0?ooo`1k
0?ooo`00S`3oool010000000FCbD05TlU00000040:1jZ@0300000034Vjh0a9^^0080a9^^00@00000
0>VoZ03Y_jP00000P03oool008l0oooo00@0000005TlU01I?9@00000102PNZT00`000000a9^^0<BK
[P020<BK[P040000003Y_jP0jKnX00000800oooo002?0?ooo`040000001I?9@0FCbD000000@0X7ZY
00<000000<BK[P34Vjh00P34Vjh010000000jKnX0>VoZ00000200?ooo`00S`3oool010000000FCbD
05TlU00000040:1jZ@0300000034Vjh0a9^^0080a9^^00@000000>VoZ03Y_jP00000P03oool008l0
oooo00<0000005TlU0000000102PNZT00`000000a9^^0<BK[P030<BK[P040000003Y_jP0jKnX0000
0800oooo002?0?ooo`030000001I?9@0000000@0X7ZY00<000000<BK[P34Vjh00P34Vjh01@000000
jKnX0>VoZ03Y_jP000000800oooo002?0?ooo`H0000000<0X7ZY00000034Vjh00`34Vjh00`000000
jKnX0>VoZ00200000800oooo00140?ooo`D00000A@3oool20000000509OTo@000000000000000008
P>400P0000040<BK[P040000003Y_jP0jKnX00000840oooo00140?ooo`030000002N^>/0W[S[0080
W[S[2@00000j0?ooo`<000000P2Gi?d00`000000>iGb03^ElP020000000600R0h@00000000000000
0034Vjh000000P3Y_jP00`000000oooo0?ooo`1o0?ooo`00A03oool00`000000W[S[09jhj`0;09jh
j`T00000<03oool3000000040=cnd0000000UnCm000000<0>iGb00<0000000R0h@08P>400P08P>42
00000080jKnX00<000000?ooo`3oool0O`3oool004@0oooo00<0000009jhj`2N^>/0502N^>/90000
02D0oooo0P0000001`35nkT000000=cnd03Lo]00000009OTo@0000000P0kUO801000000001RV0000
0000000300R0h@040000003Y_jP0jKnX00000840oooo00140?ooo`030000002N^>/0W[S[01d0W[S[
2P00000J0?ooo`0300000035nkT0aO^i00<0000000<0g?k@0000002Gi?d0100000000`006:H00000
000000020000000500R0h@00000000000>VoZ0000000P@3oool004D0oooo00<0000009jhj`2N^>/0
9P2N^>/900000100oooo00<000000<Gk^@35nkT00P0000000`3fe6P000000=cnd0080000000300R0
h@000000000000<0000000<0jKnX0000003oool0P03oool004D0oooo00<0000009jhj`2N^>/0;`2N
^>/9000000H0oooo00@000000<Gk^@35nkT0aO^i0P0000000`3fe6P0000000000008000000<0283Q
1@0000210?ooo`00A@3oool00`000000W[S[09jhj`0h09jhj`D0000000@0oooo00000035nkT0aO^i
0P0000000`35nkT0000000000009000000@0283Q0`0000220?ooo`00A@3oool00`000000W[S[09jh
j`0l09jhj`030000003oool0000000<000000P35nkT:000000D0283Q100000210?ooo`00A@3oool5
000003X0W[S[00<000000?ooo`0000000P0000040<Gk^@/000000`08P>4010000000001m00000000
00210?ooo`00BP3oool900000340W[S[00@000000?ooo`00000000001@35nkT=0000000500R0h@00
0000001m0000O@0000000P3oool5000007X0oooo001C0?ooo`T00000:02N^>/010000000oooo0000
000000040<Gk^@030000003oool0000000P000000`3oool200000080001m0P0000000`3oool00000
09jhj`0309jhj`T00000L@3oool005X0oooo00<0000009ngj@0000002000000O09jhj`D000000`35
nkT00`000000oooo0?ooo`08000000D0oooo00H000000000O@00000000000?ooo`00000=09jhj`X0
0000I`3oool005X0oooo00<0000009ngj@2O]nT0202O]nT9000001H0W[S[1@0000020<Gk^@040000
003oool0oooo0?ooo`P000001@3oool01P000000001m000000000000oooo000001L0W[S[2@00001N
0?ooo`00FP3oool00`000000WkOY09ngj@0A09ngj@T000003@2N^>/4000000030=>l=P0000000000
00@0oooo2@0000050?ooo`<0000000<0oooo0000002N^>/07`2N^>/9000005D0oooo001J0?ooo`D0
0000602O]nT9000000@0W[S[100000000`3C_3H000000?ooo`040?ooo`X000001@3oool3000002X0
W[S[2P00001;0?ooo`00G`3oool8000001T0WkOY200000000`3C_3H000000?ooo`030?ooo``00000
103oool3000003@0W[S[2@0000120?ooo`00I`3oool9000001D0WkOY0`0000000`3C_3H000000?oo
o`020?ooo`030000001?3ed0000000/000000`3oool3000003d0W[S[1@00000m0?ooo`00KP3oool;
000000`0WkOY00<000000;><[00000000P0000030?ooo`/0000000D0a8F?0000003ZWWP000000?oo
o`0400000440W[S[00<000000?ooo`3oool0>`3oool006h0oooo1@0000060;><[0P00000102O]nT0
0`000000/hb/0000000E000000030;[e[@000000000000H00000?02N^>/00`000000oooo0?ooo`0k
0?ooo`00KP3oool2000000<0[JC>200000060;><[0`000000P1J?9@<00000080^_F]0`0000000`3o
ool0000009ngj@0309ngj@X00000<@2N^>/00`000000oooo0?ooo`0l0?ooo`00K`3oool00`000000
[JC>0:fTcP090:fTcPP000000`2cS:`700000080FSbD2`0000020;[e[@H000003P2O]nT;000002H0
W[S[00<000000?ooo`3oool0?03oool006l0oooo00<000000:fTcP2]Y<h04@2]Y<h700000003001f
e`000000000000`000000P2jmJd2000000030;[e[@0000000000008000006@2O]nT;000001/0W[S[
00<000000?ooo`3oool0?03oool006l0oooo00<000000:fTcP2]Y<h0502]Y<h600000003001fe`00
0000000000P0000000<0Jm_[0000002jmJd00P0000020;[e[@T000007`2O]nT:00000140W[S[00<0
00000?ooo`3oool0?03oool006l0oooo1P00000A0:fTcP80000000<0oooo0000000000000`000003
001fe`800000101[fn/4000000<0^_F]1`0000020;><[0/000006P2O]nT010000000oooo0?ooo`3o
ool;000000D0W[S[00<000000?ooo`3oool0?@3oool006l0oooo00<0000008g1n02=`OP00`2=`OP<
000000D0[JC>0P0000020?ooo`0300000000M]L0000000<0000000<007KG0000001[fn/01`000003
0;[e[@d00000202cS:`:00000100WkOY00<000000?ooo`3oool0303oool6000003l0oooo001_0?oo
o`H00000302=`OP7000000<0oooo00<00000001fe`00M]L02@00000206_Kj`040000002jmJd0^_F]
000000@0oooo100000050:fTcP/000001`2cS:`;000000D0WkOY1@00001?0?ooo`00M@3oool<0000
00D0SL7h00<000000?ooo`3oool00P3oool00`00000007KG001fe`02001fe`<000001P1[fn/00`00
0000^_F]000000080?ooo`030000002]Y<h0[JC>00h0[JC>2`0000050;><[1<00000B03oool00840
oooo1P0000050?ooo`0300000000M]L007KG008007KG00<0000006_Kj`1[fn/01@1[fn/2000000P0
oooo00<000000:fTcP2]Y<h06P2]Y<hH000004P0oooo002=0?ooo`8000000P00M]L00`000000Jm_[
06_Kj`0406_Kj`8000002@3oool5000001d0[JC>4`0000180?ooo`00S`3oool200000003001fe`00
0000Jm_[00D000002P3oool00`000000SL7h08g1n00208g1n0P000005@2]Y<h00`000000oooo0000
000@000004P0oooo002A0?ooo`@0000000<0V^?m0000000000002`3oool00`000000SL7h08g1n00:
08g1n0P00000302]Y<h00`000000oooo0?ooo`0:0?ooo`L00000B03oool00980oooo1000000=0?oo
o`H000003`2=`OP8000000@0[JC>00<000000?ooo`3oool0F@3oool008`0oooo100000020?ooo`80
00005@3oool;000000`0SL7h1@00001K0?ooo`00R`3oool00`000000FCbD000000020:1jZ@T00000
6`3oool;000000D0SL7h00<000000?ooo`3oool0F@3oool008/0oooo00<0000005TlU0000000102P
NZT00`000000a9^^0<BK[P020<BK[P040000003Y_jP00000000002@0oooo1P00001K0?ooo`00R`3o
ool00`000000FCbD000000040:1jZ@0300000034Vjh0a9^^0080a9^^00@000000>VoZ03Y_jP00000
Q@3oool008/0oooo00<0000005TlU0000000102PNZT00`000000a9^^0<BK[P020<BK[P040000003Y
_jP0jKnX000008D0oooo002:0?ooo`040000001I?9@0FCbD000000@0X7ZY00D000000<BK[P34Vjh0
a9^^000000030>VoZ0030000003oool0oooo08<0oooo002:0?ooo`030000001I?9@0000000D0X7ZY
00D000000<BK[P34Vjh0a9^^000000030>VoZ0030000003oool0oooo08<0oooo002:0?ooo`030000
001I?9@0000000@0X7ZY00<000000<BK[P34Vjh00P34Vjh01@000000jKnX0>VoZ03Y_jP0000008D0
oooo002:0?ooo`030000001I?9@0000000@0X7ZY00<000000<BK[P34Vjh00P34Vjh00`000000jKnX
0>VoZ002000008D0oooo002:0?ooo`030000001I?9@0000000@0X7ZY00<000000<BK[P34Vjh00P34
Vjh010000000jKnX0>VoZ00000260?ooo`00RP3oool00`000000FCbD000000040:1jZ@0300000034
Vjh0a9^^0080a9^^00@000000>VoZ03Y_jP00000QP3oool008X0oooo00<0000005TlU0000000102P
NZT00`000000a9^^0<BK[P020<BK[P040000003Y_jP0jKnX000008H0oooo002:0?ooo`030000001I
?9@0000000@0X7ZY00<000000<BK[P34Vjh00P34Vjh010000000jKnX0>VoZ00000260?ooo`00R@3o
ool010000000FCbD05TlU00000040:1jZ@0500000034Vjh0a9^^0<BK[P0000000`3Y_jP00`000000
oooo0?ooo`240?ooo`00R@3oool010000000FCbD05TlU00000040:1jZ@0500000034Vjh0a9^^0<BK
[P0000000`3Y_jP00`000000oooo0?ooo`240?ooo`00R@3oool010000000FCbD05TlU00000040:1j
Z@0500000034Vjh0a9^^0<BK[P0000000`3Y_jP00`000000oooo0?ooo`240?ooo`00R@3oool01000
0000FCbD05TlU00000040:1jZ@0500000034Vjh0a9^^0<BK[P0000000`3Y_jP00`000000oooo0?oo
o`240?ooo`00R@3oool010000000FCbD05TlU00000040:1jZ@0500000034Vjh0a9^^0<BK[P000000
0`3Y_jP00`000000oooo0?ooo`240?ooo`00R@3oool00`000000FCbD000000050:1jZ@0500000034
Vjh0a9^^0<BK[P0000000`3Y_jP00`000000oooo0?ooo`240?ooo`00R@3oool205TlU0030000002P
NZT0X7ZY0080X7ZY00<000000<BK[P34Vjh00P34Vjh01@000000jKnX0>VoZ03Y_jP0000008H0oooo
00280?ooo`040000001I?9@0FCbD000000@0X7ZY00<000000<BK[P34Vjh00P34Vjh00`000000jKnX
0>VoZ002000008H0oooo00280?ooo`040000001I?9@0FCbD000000@0X7ZY00D000000<BK[P34Vjh0
a9^^000000030>VoZ0030000003oool0oooo08D0oooo00280?ooo`040000001I?9@0FCbD000000@0
X7ZY00D000000<BK[P34Vjh0a9^^000000030>VoZ0030000003oool0oooo08D0oooo00280?ooo`H0
00000P2PNZT01@000000a9^^0<BK[P34Vjh0000000<0jKnX00<000000?ooo`3oool0Q@3oool008P0
oooo0P000000103X_ZT000000<>K[P33Vjh800000080jKnX00<000000?ooo`3oool0Q@3oool008X0
oooo2@0000020:5kZP@00000Q`3oool008l0oooo0P0000020?ooo`H00000Q`3oool008l0oooo0P00
002?0?ooo`00S`3oool2000008l0oooo002?0?ooo`800000S`3oool008l0oooo0P00002?0?ooo`00
SP3oool200000900oooo002>0?ooo`800000T03oool008h0oooo0P00002@0?ooo`00SP3oool20000
0900oooo002>0?ooo`800000T03oool008h0oooo0P00002@0?ooo`00SP3oool200000900oooo002=
0?ooo`<00000T03oool008h0oooo00<000000?ooo`3oool0S`3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.55161 .4578 m .67549 .37975 L .70578 .37506 L p .232 0 0 r
F P
0 g
s
.55674 .44467 m .5402 .44232 L p .54023 .46639 L .659 .485 .638 r
F P
0 g
s
.54029 .51808 m .55295 .46158 L p .54023 .46639 L .659 .485 .638 r
F P
0 g
s
.70578 .37506 m .59453 .44585 L p .55161 .4578 L .232 0 0 r
F P
0 g
s
.56859 .45566 m .55161 .4578 L p .59453 .44585 L .232 0 0 r
F P
0 g
s
.55295 .46158 m .55674 .44467 L p .54023 .46639 L .659 .485 .638 r
F P
0 g
s
.59453 .44585 m .5817 .45401 L .56859 .45566 L p .232 0 0 r
F P
0 g
s
.53815 .57917 m .616 .61386 L .61938 .59796 L p .859 .69 .671 r
F P
0 g
s
.61938 .59796 m .54178 .56287 L .53815 .57917 L p .859 .69 .671 r
F P
0 g
s
.54178 .56287 m .61938 .59796 L .62892 .58471 L p .793 .757 .821 r
F P
0 g
s
.55146 .54917 m .62892 .58471 L .64107 .57909 L p .623 .782 .957 r
F P
0 g
s
.62892 .58471 m .55146 .54917 L .54178 .56287 L p .793 .757 .821 r
F P
0 g
s
.54196 .59199 m .62007 .62648 L .616 .61386 L p .872 .523 .386 r
F P
0 g
s
.616 .61386 m .53815 .57917 L .54196 .59199 L p .872 .523 .386 r
F P
0 g
s
.44008 .55897 m .43784 .5685 L .49847 .55286 L closepath p .324 .168 .509 r
F P
0 g
s
.43748 .54935 m .44008 .55897 L .49847 .55286 L closepath p .354 .375 .744 r
F P
0 g
s
.43103 .54325 m .43748 .54935 L .49847 .55286 L closepath p .276 .546 .923 r
F P
0 g
s
.43784 .5685 m .43161 .57431 L .49847 .55286 L closepath p .134 0 0 r
F P
0 g
s
.42314 .54303 m .43103 .54325 L .49847 .55286 L closepath p .18 0 0 r
F P
0 g
s
.64107 .57909 m .5636 .54322 L .55146 .54917 L p .623 .782 .957 r
F P
0 g
s
.5636 .54322 m .64107 .57909 L .65126 .58332 L p 0 .333 .694 r
F P
0 g
s
.55186 .59643 m .63014 .63098 L .62007 .62648 L p .293 0 0 r
F P
0 g
s
.62007 .62648 m .54196 .59199 L .55186 .59643 L p .293 0 0 r
F P
0 g
s
.43161 .57431 m .42373 .57418 L .49847 .55286 L closepath p .412 .839 .956 r
F P
0 g
s
.41684 .54881 m .42314 .54303 L .49847 .55286 L closepath p .463 .109 .28 r
F P
0 g
s
.42373 .57418 m .4172 .56811 L .49847 .55286 L closepath p .523 .653 .917 r
F P
0 g
s
.41457 .55841 m .41684 .54881 L .49847 .55286 L closepath p .503 .334 .585 r
F P
0 g
s
.4172 .56811 m .41457 .55841 L .49847 .55286 L closepath p .517 .484 .759 r
F P
0 g
s
.65126 .58332 m .57363 .54736 L .5636 .54322 L p 0 .333 .694 r
F P
0 g
s
.57363 .54736 m .65126 .58332 L .65554 .59593 L p .874 .517 .369 r
F P
0 g
s
.56414 .59064 m .64242 .62552 L .63014 .63098 L p .616 .787 .963 r
F P
0 g
s
.63014 .63098 m .55186 .59643 L .56414 .59064 L p .616 .787 .963 r
F P
0 g
s
.65554 .59593 m .57766 .56016 L .57363 .54736 L p .874 .517 .369 r
F P
0 g
s
.57766 .56016 m .65554 .59593 L .65217 .6121 L p .863 .693 .669 r
F P
0 g
s
.57403 .57675 m .65217 .6121 L .64242 .62552 L p .795 .762 .823 r
F P
0 g
s
.02 w
.65198 .61236 m
.67291 .62182 L
s
.5 Mabswid
.64242 .62552 m .56414 .59064 L .57403 .57675 L p .795 .762 .823 r
F P
0 g
s
.65217 .6121 m .57403 .57675 L .57766 .56016 L p .863 .693 .669 r
F P
0 g
s
.52364 .51557 m .5402 .44232 L .52489 .43696 L p .791 .618 .666 r
F P
0 g
s
.5402 .44232 m .52364 .51557 L .54029 .51808 L p .659 .485 .638 r
F P
0 g
s
.55674 .44467 m .54029 .51808 L .55191 .51695 L p .434 .27 .558 r
F P
0 g
s
.55191 .51695 m .56835 .44314 L .55674 .44467 L p .434 .27 .558 r
F P
0 g
s
.50816 .51035 m .52489 .43696 L .51653 .43057 L p .939 .781 .658 r
F P
0 g
s
.52489 .43696 m .50816 .51035 L .52364 .51557 L p .791 .618 .666 r
F P
0 g
s
.60687 .57249 m .70541 .61778 L .73458 .59733 L p .702 .79 .919 r
F P
0 g
s
.56835 .44314 m .55191 .51695 L .55405 .51255 L p 0 0 0 r
F P
0 g
s
.55405 .51255 m .57059 .43824 L .56835 .44314 L p 0 0 0 r
F P
0 g
s
.49962 .50436 m .50816 .51035 L p .51271 .46703 L .939 .781 .658 r
F P
0 g
s
.51653 .43057 m .51045 .4571 L p .51271 .46703 L .939 .781 .658 r
F P
0 g
s
.51045 .4571 m .49962 .50436 L p .51271 .46703 L .939 .781 .658 r
F P
0 g
s
.42562 .24333 m .50099 .43288 L .50482 .43234 L p .459 .485 .798 r
F P
0 g
s
.51653 .43057 m .51839 .42557 L p .5134 .44653 L 0 0 0 r
F P
0 g
s
.49962 .50436 m .51045 .4571 L p .5134 .44653 L 0 0 0 r
F P
0 g
s
.51045 .4571 m .51653 .43057 L p .5134 .44653 L 0 0 0 r
F P
0 g
s
.50138 .49986 m .51839 .42557 L .52995 .42391 L p .422 .258 .552 r
F P
0 g
s
.51839 .42557 m .50138 .49986 L .49962 .50436 L p 0 0 0 r
F P
0 g
s
.50482 .43234 m .51787 .43049 L p .48605 .34969 L .459 .485 .798 r
F P
0 g
s
.51294 .49861 m .52995 .42391 L .54683 .42628 L p .658 .483 .636 r
F P
0 g
s
.52995 .42391 m .51294 .49861 L .50138 .49986 L p .422 .258 .552 r
F P
0 g
s
.51787 .43049 m .53091 .42864 L p .52251 .41386 L .459 .485 .798 r
F P
0 g
s
.52251 .41386 m .48605 .34969 L .51787 .43049 L .459 .485 .798 r
F
.48605 .34969 m .42562 .24333 L .50482 .43234 L F
.73458 .59733 m .64083 .55299 L p .60687 .57249 L .702 .79 .919 r
F P
0 g
s
.6234 .56029 m .60687 .57249 L p .64083 .55299 L .702 .79 .919 r
F P
0 g
s
.65289 .56752 m .59684 .5714 L p .56547 .58703 L .348 0 .183 r
F P
0 g
s
.59684 .5714 m .58008 .57256 L .56985 .5827 L p .348 0 .183 r
F P
0 g
s
.56985 .5827 m .56547 .58703 L p .59684 .5714 L .348 0 .183 r
F P
0 g
s
.64083 .55299 m .63623 .55082 L .6234 .56029 L p .702 .79 .919 r
F P
0 g
s
.49758 .55877 m .50029 .54689 L .51547 .5519 L p .791 .618 .666 r
F P
0 g
s
.51547 .5519 m .51279 .56376 L .49758 .55877 L p .791 .618 .666 r
F P
0 g
s
.51846 .53993 m .51547 .5519 L .50029 .54689 L p .763 .669 .758 r
F P
0 g
s
.02 w
.51342 .54969 m
.51412 .55001 L
s
.5075 .54701 m
.51342 .54969 L
s
.01 w
.53064 .49122 m
.5411 .44489 L
s
.5 Mabswid
.51279 .56376 m .51547 .5519 L .53176 .55443 L p .659 .485 .638 r
F P
0 g
s
.51547 .5519 m .51846 .53993 L .53154 .54195 L p .646 .549 .731 r
F P
0 g
s
.53154 .54195 m .53176 .55443 L .51547 .5519 L p .646 .549 .731 r
F P
0 g
s
.50029 .54689 m .50629 .53589 L .51846 .53993 L p .763 .669 .758 r
F P
0 g
s
.52119 .53015 m .51846 .53993 L .50629 .53589 L p .712 .714 .85 r
F P
0 g
s
.51846 .53993 m .52119 .53015 L .52847 .53127 L p .617 .614 .825 r
F P
0 g
s
.52847 .53127 m .53154 .54195 L .51846 .53993 L p .617 .614 .825 r
F P
0 g
s
.4987 .56925 m .49758 .55877 L .51279 .56376 L p .806 .538 .533 r
F P
0 g
s
.51279 .56376 m .51093 .57324 L .4987 .56925 L p .806 .538 .533 r
F P
0 g
s
.51093 .57324 m .51279 .56376 L .52909 .56632 L p .659 .394 .507 r
F P
0 g
s
.53176 .55443 m .52909 .56632 L .51279 .56376 L p .659 .485 .638 r
F P
0 g
s
.57059 .43824 m .55405 .51255 L .54569 .5065 L p .945 .786 .654 r
F P
0 g
s
.54569 .5065 m .5624 .43178 L .57059 .43824 L p .945 .786 .654 r
F P
0 g
s
.52909 .56632 m .53176 .55443 L .54309 .55353 L p .433 .27 .558 r
F P
0 g
s
.02 w
.55063 .56652 m
.57384 .57702 L
s
.5 Mabswid
.53176 .55443 m .53154 .54195 L .54062 .54117 L p .45 .391 .699 r
F P
0 g
s
.54062 .54117 m .54309 .55353 L .53176 .55443 L p .45 .391 .699 r
F P
0 g
s
.53154 .54195 m .52847 .53127 L .53351 .53081 L p .452 .505 .823 r
F P
0 g
s
.53351 .53081 m .54062 .54117 L .53154 .54195 L p .452 .505 .823 r
F P
0 g
s
.48914 .55319 m .49188 .54124 L .50029 .54689 L p .939 .781 .658 r
F P
0 g
s
.50029 .54689 m .49758 .55877 L .48914 .55319 L p .939 .781 .658 r
F P
0 g
s
.50629 .53589 m .50029 .54689 L .49188 .54124 L p .878 .833 .799 r
F P
0 g
s
.49188 .54124 m .49958 .53131 L .50629 .53589 L p .878 .833 .799 r
F P
0 g
s
.51442 .52789 m .50629 .53589 L .49958 .53131 L p .776 .848 .906 r
F P
0 g
s
.50629 .53589 m .51442 .52789 L .52119 .53015 L p .712 .714 .85 r
F P
0 g
s
.52909 .56632 m .52405 .57531 L .51093 .57324 L p .659 .394 .507 r
F P
0 g
s
.52405 .57531 m .52909 .56632 L .54043 .56548 L p .388 .095 .34 r
F P
0 g
s
.54309 .55353 m .54043 .56548 L .52909 .56632 L p .433 .27 .558 r
F P
0 g
s
.02 w
.51412 .55001 m
.53608 .55994 L
s
.54115 .56223 m
.55063 .56652 L
s
.5 Mabswid
.49192 .56481 m .48914 .55319 L .49758 .55877 L p .956 .655 .422 r
F P
0 g
s
.49758 .55877 m .4987 .56925 L .49192 .56481 L p .956 .655 .422 r
F P
0 g
s
.52119 .53015 m .51442 .52789 L p .53071 .52637 L .366 .712 .987 r
F P
0 g
s
.52847 .53127 m .52119 .53015 L p .53071 .52637 L .366 .712 .987 r
F P
0 g
s
.50346 .57625 m .4987 .56925 L .51093 .57324 L p .766 .335 .227 r
F P
0 g
s
.51093 .57324 m .51028 .57847 L .50346 .57625 L p .766 .335 .227 r
F P
0 g
s
.51028 .57847 m .51093 .57324 L .52405 .57531 L p .609 .184 .21 r
F P
0 g
s
.53351 .53081 m .52847 .53127 L p .53071 .52637 L .366 .712 .987 r
F P
0 g
s
.48719 .67686 m .50437 .60084 L .48868 .5958 L p .791 .618 .666 r
F P
0 g
s
.50437 .60084 m .48719 .67686 L .50408 .67974 L p .659 .485 .638 r
F P
0 g
s
.50408 .67974 m .52115 .60355 L .50437 .60084 L p .659 .485 .638 r
F P
0 g
s
.51442 .52789 m .51072 .52533 L p .53071 .52637 L .366 .712 .987 r
F P
0 g
s
.01 w
.51559 .55788 m
.52253 .52713 L
s
.5 Mabswid
.49958 .53131 m .51072 .52533 L .51442 .52789 L p .776 .848 .906 r
F P
0 g
s
.67349 .56816 m .81284 .63407 L .8469 .61115 L p .7 .796 .924 r
F P
0 g
s
.52405 .57531 m .51759 .57963 L .51028 .57847 L p .609 .184 .21 r
F P
0 g
s
.51759 .57963 m .52405 .57531 L .53314 .57468 L p .236 0 0 r
F P
0 g
s
.54043 .56548 m .53314 .57468 L .52405 .57531 L p .388 .095 .34 r
F P
0 g
s
.4997 .57381 m .49192 .56481 L .4987 .56925 L p .779 .28 0 r
F P
0 g
s
.4987 .56925 m .50346 .57625 L .4997 .57381 L p .779 .28 0 r
F P
0 g
s
.54309 .55353 m .54062 .54117 L .54223 .53785 L p 0 0 .458 r
F P
0 g
s
.54062 .54117 m .53351 .53081 L .53438 .52894 L p .011 .271 .772 r
F P
0 g
s
.53438 .52894 m .54223 .53785 L .54062 .54117 L p .011 .271 .772 r
F P
0 g
s
.52115 .60355 m .50408 .67974 L .51572 .67952 L p .434 .27 .558 r
F P
0 g
s
.01 w
.5033 .61231 m
.50945 .58507 L
s
.5 Mabswid
.51572 .67952 m .53278 .60289 L .52115 .60355 L p .434 .27 .558 r
F P
0 g
s
.54043 .56548 m .54309 .55353 L .54512 .54948 L p 0 0 0 r
F P
0 g
s
.03 w
.54711 .54888 m
.55046 .5486 L
s
.5 Mabswid
.54223 .53785 m .54512 .54948 L .54309 .55353 L p 0 0 .458 r
F P
0 g
s
.53071 .52637 m .53438 .52894 L .53351 .53081 L p .366 .712 .987 r
F P
0 g
s
.5624 .43178 m .54569 .5065 L .52994 .50115 L p .793 .619 .665 r
F P
0 g
s
.52994 .50115 m .54683 .42628 L .5624 .43178 L p .793 .619 .665 r
F P
0 g
s
.01 w
.52462 .51787 m
.53064 .49122 L
s
.5 Mabswid
.49354 .5371 m .50095 .52794 L .49958 .53131 L p .713 .922 .583 r
F P
0 g
s
.49958 .53131 m .49188 .54124 L .49354 .5371 L p .713 .922 .583 r
F P
0 g
s
.51072 .52533 m .49958 .53131 L .50095 .52794 L p .646 .966 .899 r
F P
0 g
s
.47132 .67198 m .48868 .5958 L .47994 .59028 L p .939 .781 .658 r
F P
0 g
s
.48868 .5958 m .47132 .67198 L .48719 .67686 L p .791 .618 .666 r
F P
0 g
s
.51072 .52533 m .51152 .52344 L p .53071 .52637 L .366 .712 .987 r
F P
0 g
s
.01 w
.52297 .52519 m
.52462 .51787 L
s
.5 Mabswid
.50095 .52794 m .51152 .52344 L .51072 .52533 L p .646 .966 .899 r
F P
0 g
s
.49078 .54913 m .49354 .5371 L .49188 .54124 L p 0 0 0 r
F P
0 g
s
.49188 .54124 m .48914 .55319 L .49078 .54913 L p 0 0 0 r
F P
0 g
s
.54512 .54948 m .54244 .56151 L .54043 .56548 L p 0 0 0 r
F P
0 g
s
.53314 .57468 m .54043 .56548 L .54244 .56151 L p .67 .892 .537 r
F P
0 g
s
.51028 .57847 m .51759 .57963 L p .51287 .57287 L .339 .706 .983 r
F P
0 g
s
.50346 .57625 m .51028 .57847 L p .51287 .57287 L .339 .706 .983 r
F P
0 g
s
.49326 .56162 m .49078 .54913 L .48914 .55319 L p 0 0 .422 r
F P
0 g
s
.48914 .55319 m .49192 .56481 L .49326 .56162 L p 0 0 .422 r
F P
0 g
s
.54683 .42628 m .52994 .50115 L .51294 .49861 L p .658 .483 .636 r
F P
0 g
s
.53314 .57468 m .52262 .57929 L .51759 .57963 L p .236 0 0 r
F P
0 g
s
.51759 .57963 m .52262 .57929 L p .51287 .57287 L .339 .706 .983 r
F P
0 g
s
.54223 .53785 m .53438 .52894 L .53071 .52637 L p .753 .247 0 r
F P
0 g
s
.52262 .57929 m .53314 .57468 L .53471 .57155 L p .617 .958 .88 r
F P
0 g
s
.54244 .56151 m .53471 .57155 L .53314 .57468 L p .67 .892 .537 r
F P
0 g
s
.4997 .57381 m .50346 .57625 L p .51287 .57287 L .339 .706 .983 r
F P
0 g
s
.01 w
.50945 .58507 m
.51157 .57568 L
s
.5 Mabswid
.51152 .52344 m .51654 .52296 L p .53071 .52637 L .366 .712 .987 r
F P
0 g
s
.51 .52708 m .51654 .52296 L .51152 .52344 L p .197 0 0 r
F P
0 g
s
.51152 .52344 m .50095 .52794 L .51 .52708 L p .197 0 0 r
F P
0 g
s
.50047 .57207 m .49326 .56162 L .49192 .56481 L p 0 .244 .757 r
F P
0 g
s
.49192 .56481 m .4997 .57381 L .50047 .57207 L p 0 .244 .757 r
F P
0 g
s
.54512 .54948 m .54223 .53785 L .53563 .53324 L p .96 .653 .404 r
F P
0 g
s
.53071 .52637 m .53563 .53324 L .54223 .53785 L p .753 .247 0 r
F P
0 g
s
.53278 .60289 m .51572 .67952 L .51762 .67624 L p 0 0 0 r
F P
0 g
s
.51762 .67624 m .53479 .59908 L .53278 .60289 L p 0 0 0 r
F P
0 g
s
.52262 .57929 m .52346 .57757 L p .51287 .57287 L .339 .706 .983 r
F P
0 g
s
.53471 .57155 m .52346 .57757 L .52262 .57929 L p .617 .958 .88 r
F P
0 g
s
.51654 .52296 m .52389 .52408 L .53071 .52637 L p .366 .712 .987 r
F P
0 g
s
.53563 .53324 m .53071 .52637 L .52389 .52408 L p .762 .319 .201 r
F P
0 g
s
.50482 .53608 m .51 .52708 L .50095 .52794 L p .372 .072 .322 r
F P
0 g
s
.50095 .52794 m .49354 .5371 L .50482 .53608 L p .372 .072 .322 r
F P
0 g
s
.50047 .57207 m .4997 .57381 L p .51287 .57287 L .339 .706 .983 r
F P
0 g
s
.01 w
.51221 .57282 m
.51559 .55788 L
s
.5 Mabswid
.52329 .52911 m .52389 .52408 L .51654 .52296 L p .599 .163 .184 r
F P
0 g
s
.51654 .52296 m .51 .52708 L .52329 .52911 L p .599 .163 .184 r
F P
0 g
s
.47994 .59028 m .46239 .66688 L .47132 .67198 L p .939 .781 .658 r
F P
0 g
s
.46239 .66688 m .47994 .59028 L .48156 .58637 L p 0 0 0 r
F P
0 g
s
.40363 .51923 m .46408 .54617 L .46795 .52949 L p .859 .69 .671 r
F P
0 g
s
.46795 .52949 m .40771 .50225 L .40363 .51923 L p .859 .69 .671 r
F P
0 g
s
.40771 .50225 m .46795 .52949 L .47776 .51536 L p .793 .757 .821 r
F P
0 g
s
.54244 .56151 m .54512 .54948 L .53688 .54378 L p .945 .786 .654 r
F P
0 g
s
.53563 .53324 m .53688 .54378 L .54512 .54948 L p .96 .653 .404 r
F P
0 g
s
.52389 .52408 m .52329 .52911 L .53563 .53324 L p .762 .319 .201 r
F P
0 g
s
.50206 .54818 m .50482 .53608 L .49354 .5371 L p .423 .258 .552 r
F P
0 g
s
.02 w
.50281 .54489 m
.5075 .54701 L
s
.5 Mabswid
.49354 .5371 m .49078 .54913 L .50206 .54818 L p .423 .258 .552 r
F P
0 g
s
.02 w
.4932 .54054 m
.49779 .54262 L
s
.49055 .53935 m
.4932 .54054 L
s
.5 Mabswid
.53471 .57155 m .54244 .56151 L .53417 .55588 L p .882 .84 .8 r
F P
0 g
s
.53688 .54378 m .53417 .55588 L .54244 .56151 L p .945 .786 .654 r
F P
0 g
s
.03 w
.53937 .54951 m
.54711 .54888 L
s
.5 Mabswid
.41762 .48777 m .47776 .51536 L .48987 .50908 L p .623 .782 .957 r
F P
0 g
s
.47776 .51536 m .41762 .48777 L .40771 .50225 L p .793 .757 .821 r
F P
0 g
s
.8469 .61115 m .71482 .54655 L p .67349 .56816 L .7 .796 .924 r
F P
0 g
s
.68793 .55771 m .67349 .56816 L p .71482 .54655 L .7 .796 .924 r
F P
0 g
s
.69994 .56425 m .6666 .56657 L p .65085 .58167 L .348 0 .183 r
F P
0 g
s
.6666 .56657 m .66552 .56664 L .66491 .56726 L p .348 0 .183 r
F P
0 g
s
.66491 .56726 m .65085 .58167 L p .6666 .56657 L .348 0 .183 r
F P
0 g
s
.71482 .54655 m .70798 .5432 L .68793 .55771 L p .7 .796 .924 r
F P
0 g
s
.53091 .42864 m .45507 .23611 L .42562 .24333 L p .459 .485 .798 r
F P
0 g
s
.40695 .53238 m .46763 .55917 L .46408 .54617 L p .872 .523 .386 r
F P
0 g
s
.46408 .54617 m .40363 .51923 L .40695 .53238 L p .872 .523 .386 r
F P
0 g
s
.52346 .57757 m .51974 .57511 L .51287 .57287 L p .339 .706 .983 r
F P
0 g
s
.52346 .57757 m .53471 .57155 L .52804 .56708 L p .776 .856 .91 r
F P
0 g
s
.52804 .56708 m .51974 .57511 L .52346 .57757 L p .776 .856 .91 r
F P
0 g
s
.53417 .55588 m .52804 .56708 L .53471 .57155 L p .882 .84 .8 r
F P
0 g
s
.51287 .57287 m .5055 .5717 L .50047 .57207 L p .339 .706 .983 r
F P
0 g
s
.49326 .56162 m .50047 .57207 L .5055 .5717 L p .441 .501 .825 r
F P
0 g
s
.50231 .56092 m .50206 .54818 L .49078 .54913 L p .441 .384 .698 r
F P
0 g
s
.49078 .54913 m .49326 .56162 L .50231 .56092 L p .441 .384 .698 r
F P
0 g
s
.5055 .5717 m .50231 .56092 L .49326 .56162 L p .441 .501 .825 r
F P
0 g
s
.53688 .54378 m .53563 .53324 L .52329 .52911 L p .808 .536 .527 r
F P
0 g
s
.52144 .53864 m .52329 .52911 L .51 .52708 L p .657 .388 .5 r
F P
0 g
s
.51 .52708 m .50482 .53608 L .52144 .53864 L p .657 .388 .5 r
F P
0 g
s
.51974 .57511 m .52804 .56708 L .51564 .56301 L p .712 .717 .853 r
F P
0 g
s
.51564 .56301 m .51287 .57287 L .51974 .57511 L p .712 .717 .853 r
F P
0 g
s
.50231 .56092 m .5055 .5717 L .51287 .57287 L p .614 .614 .828 r
F P
0 g
s
.658 .54317 m .58521 .54902 L .58008 .57256 L p .436 .272 .56 r
F P
0 g
s
.58521 .54902 m .658 .54317 L .65172 .51851 L p .455 .443 .756 r
F P
0 g
s
.65172 .51851 m .57903 .5252 L .58521 .54902 L p .455 .443 .756 r
F P
0 g
s
.52329 .52911 m .52144 .53864 L .53688 .54378 L p .808 .536 .527 r
F P
0 g
s
.51287 .57287 m .51564 .56301 L .50231 .56092 L p .614 .614 .828 r
F P
0 g
s
.53479 .59908 m .51762 .67624 L .50887 .67111 L p .945 .786 .654 r
F P
0 g
s
.50887 .67111 m .52623 .59351 L .53479 .59908 L p .945 .786 .654 r
F P
0 g
s
.53417 .55588 m .53688 .54378 L .52144 .53864 L p .793 .619 .665 r
F P
0 g
s
.03 w
.50215 .55256 m
.53003 .55028 L
s
.53553 .54983 m
.53937 .54951 L
s
.5 Mabswid
.57903 .5252 m .65172 .51851 L .63634 .50269 L p .435 .617 .927 r
F P
0 g
s
.63634 .50269 m .56378 .50996 L .57903 .5252 L p .435 .617 .927 r
F P
0 g
s
.48987 .50908 m .42969 .48121 L .41762 .48777 L p .623 .782 .957 r
F P
0 g
s
.42969 .48121 m .48987 .50908 L .49972 .51313 L p 0 .333 .694 r
F P
0 g
s
.5187 .55076 m .52144 .53864 L .50482 .53608 L p .658 .483 .636 r
F P
0 g
s
.50482 .53608 m .50206 .54818 L .5187 .55076 L p .658 .483 .636 r
F P
0 g
s
.4165 .53666 m .47734 .56353 L .46763 .55917 L p .293 0 0 r
F P
0 g
s
.46763 .55917 m .40695 .53238 L .4165 .53666 L p .293 0 0 r
F P
0 g
s
.52804 .56708 m .53417 .55588 L .5187 .55076 L p .765 .671 .76 r
F P
0 g
s
.5187 .55076 m .51564 .56301 L .52804 .56708 L p .765 .671 .76 r
F P
0 g
s
.4639 .66351 m .48156 .58637 L .49313 .58561 L p .422 .258 .552 r
F P
0 g
s
.48156 .58637 m .4639 .66351 L .46239 .66688 L p 0 0 0 r
F P
0 g
s
.52144 .53864 m .5187 .55076 L .53417 .55588 L p .793 .619 .665 r
F P
0 g
s
.50206 .54818 m .50231 .56092 L .51564 .56301 L p .645 .549 .731 r
F P
0 g
s
.58008 .57256 m .65289 .56752 L .658 .54317 L p .436 .272 .56 r
F P
0 g
s
.51564 .56301 m .5187 .55076 L .50206 .54818 L p .645 .549 .731 r
F P
0 g
s
.56378 .50996 m .63634 .50269 L .61753 .50183 L p .177 .706 .851 r
F P
0 g
s
.49972 .51313 m .43938 .48517 L .42969 .48121 L p 0 .333 .694 r
F P
0 g
s
.43938 .48517 m .49972 .51313 L .50349 .52611 L p .874 .517 .369 r
F P
0 g
s
.50349 .52611 m .44292 .4983 L .43938 .48517 L p .874 .517 .369 r
F P
0 g
s
.45421 .46474 m .42468 .48876 L p .49112 .50236 L .702 .79 .919 r
F P
0 g
s
.54509 .50917 m .56378 .50996 L p .61701 .50191 L .177 .706 .851 r
F P
0 g
s
.61674 .50191 m .54509 .50917 L p .61701 .50191 L .177 .706 .851 r
F P
0 g
s
.61753 .50183 m .61674 .50191 L p .61701 .50191 L .177 .706 .851 r
F P
0 g
s
.54509 .50917 m .61753 .50183 L .60247 .51653 L p .315 0 .14 r
F P
0 g
s
.53009 .52341 m .54509 .50917 L p .5871 .51456 L .315 0 .14 r
F P
0 g
s
.60247 .51653 m .57675 .51898 L p .5871 .51456 L .315 0 .14 r
F P
0 g
s
.57675 .51898 m .53009 .52341 L p .5871 .51456 L .315 0 .14 r
F P
0 g
s
.53009 .52341 m .60247 .51653 L .59709 .54131 L p .42 .255 .55 r
F P
0 g
s
.59709 .54131 m .5247 .54737 L .53009 .52341 L p .42 .255 .55 r
F P
0 g
s
.42468 .48876 m .53199 .53808 L p .56632 .51776 L .702 .79 .919 r
F P
0 g
s
.53199 .53808 m .53686 .54032 L .5496 .53057 L p .702 .79 .919 r
F P
0 g
s
.5496 .53057 m .56632 .51776 L p .53199 .53808 L .702 .79 .919 r
F P
0 g
s
.56632 .51776 m .53344 .50221 L p .49112 .50236 L .702 .79 .919 r
F P
0 g
s
.53344 .50221 m .45421 .46474 L p .49112 .50236 L .702 .79 .919 r
F P
0 g
s
.52623 .59351 m .50887 .67111 L .49271 .66611 L p .793 .619 .665 r
F P
0 g
s
.49271 .66611 m .51026 .58834 L .52623 .59351 L p .793 .619 .665 r
F P
0 g
s
.47547 .66319 m .49313 .58561 L .51026 .58834 L p .658 .483 .636 r
F P
0 g
s
.49313 .58561 m .47547 .66319 L .4639 .66351 L p .422 .258 .552 r
F P
0 g
s
.4287 .53028 m .48959 .55741 L .47734 .56353 L p .616 .787 .963 r
F P
0 g
s
.47734 .56353 m .4165 .53666 L .4287 .53028 L p .616 .787 .963 r
F P
0 g
s
.56547 .58703 m .63822 .58246 L .65289 .56752 L p .348 0 .183 r
F P
0 g
s
.63822 .58246 m .56547 .58703 L .54676 .5868 L p .102 .656 .789 r
F P
0 g
s
.51026 .58834 m .49271 .66611 L .47547 .66319 L p .658 .483 .636 r
F P
0 g
s
.01 w
.47986 .7161 m
.4912 .66585 L
s
.5 Mabswid
.44292 .4983 m .50349 .52611 L .49962 .54308 L p .863 .693 .669 r
F P
0 g
s
.43884 .51558 m .49962 .54308 L .48959 .55741 L p .795 .762 .823 r
F P
0 g
s
.48959 .55741 m .4287 .53028 L .43884 .51558 L p .795 .762 .823 r
F P
0 g
s
.02 w
.42312 .50885 m
.43864 .51587 L
s
.5 Mabswid
.49962 .54308 m .43884 .51558 L .44292 .4983 L p .863 .693 .669 r
F P
0 g
s
.6194 .58218 m .54676 .5868 L .53111 .57167 L p .413 .613 .932 r
F P
0 g
s
.54676 .5868 m .6194 .58218 L .63822 .58246 L p .102 .656 .789 r
F P
0 g
s
.6036 .56649 m .53111 .57167 L .5247 .54737 L p .442 .435 .756 r
F P
0 g
s
.53111 .57167 m .6036 .56649 L .6194 .58218 L p .413 .613 .932 r
F P
0 g
s
.5247 .54737 m .59709 .54131 L .6036 .56649 L p .442 .435 .756 r
F P
0 g
s
.03 w
.59797 .54471 m
.65754 .53983 L
s
.5 Mabswid
.70502 .53939 m .67062 .54216 L .66552 .56664 L p .436 .272 .56 r
F P
0 g
s
.67062 .54216 m .70502 .53939 L .69869 .51419 L p .455 .443 .756 r
F P
0 g
s
.69869 .51419 m .66433 .51735 L .67062 .54216 L p .455 .443 .756 r
F P
0 g
s
.66433 .51735 m .69869 .51419 L .68324 .498 L p .435 .617 .927 r
F P
0 g
s
.68324 .498 m .64893 .50143 L .66433 .51735 L p .435 .617 .927 r
F P
0 g
s
.66552 .56664 m .69994 .56425 L .70502 .53939 L p .436 .272 .56 r
F P
0 g
s
.64893 .50143 m .68324 .498 L .66438 .49708 L p .177 .706 .851 r
F P
0 g
s
.66438 .49708 m .63011 .50055 L .64893 .50143 L p .177 .706 .851 r
F P
0 g
s
.65085 .58167 m .68525 .5795 L .69994 .56425 L p .348 0 .183 r
F P
0 g
s
.68525 .5795 m .65085 .58167 L .632 .58138 L p .102 .656 .789 r
F P
0 g
s
.63011 .50055 m .66438 .49708 L .64928 .51208 L p .315 0 .14 r
F P
0 g
s
.61503 .51533 m .63011 .50055 L p .64892 .51186 L .315 0 .14 r
F P
0 g
s
.64818 .51218 m .61503 .51533 L p .64892 .51186 L .315 0 .14 r
F P
0 g
s
.61503 .51533 m .64928 .51208 L .64392 .5374 L p .42 .255 .55 r
F P
0 g
s
.64392 .5374 m .60966 .54026 L .61503 .51533 L p .42 .255 .55 r
F P
0 g
s
.44185 .45859 m .5991 .53297 L p .64099 .51043 L .7 .796 .924 r
F P
0 g
s
.5991 .53297 m .60636 .5364 L .62631 .52144 L p .7 .796 .924 r
F P
0 g
s
.62631 .52144 m .64099 .51043 L p .5991 .53297 L .7 .796 .924 r
F P
0 g
s
.64928 .51208 m .64818 .51218 L p .64892 .51186 L .315 0 .14 r
F P
0 g
s
.66637 .5792 m .632 .58138 L .61619 .56559 L p .413 .613 .932 r
F P
0 g
s
.632 .58138 m .66637 .5792 L .68525 .5795 L p .102 .656 .789 r
F P
0 g
s
.6505 .56314 m .61619 .56559 L .60966 .54026 L p .442 .435 .756 r
F P
0 g
s
.61619 .56559 m .6505 .56314 L .66637 .5792 L p .413 .613 .932 r
F P
0 g
s
.60966 .54026 m .64392 .5374 L .6505 .56314 L p .442 .435 .756 r
F P
0 g
s
.77496 .549 m .78131 .54223 L .67921 .53805 L closepath p .453 .095 .265 r
F P
0 g
s
.76684 .54876 m .77496 .549 L .67921 .53805 L closepath p .144 0 0 r
F P
0 g
s
.76004 .54154 m .76684 .54876 L .67921 .53805 L closepath p .294 .552 .923 r
F P
0 g
s
.78349 .53106 m .7807 .51971 L .67921 .53805 L closepath p .513 .482 .76 r
F P
0 g
s
.78131 .54223 m .78349 .53106 L .67921 .53805 L closepath p .498 .328 .582 r
F P
0 g
s
.75721 .53008 m .76004 .54154 L .67921 .53805 L closepath p .364 .381 .745 r
F P
0 g
s
.7807 .51971 m .77399 .51247 L .67921 .53805 L closepath p .517 .654 .92 r
F P
0 g
s
.75944 .51882 m .75721 .53008 L .67921 .53805 L closepath p .336 .18 .516 r
F P
0 g
s
.77399 .51247 m .76587 .5121 L .67921 .53805 L closepath p .388 .83 .944 r
F P
0 g
s
.76587 .5121 m .75944 .51882 L .67921 .53805 L closepath p .159 0 .019 r
F P
0 g
s
.03 w
.65754 .53983 m
.67921 .53805 L
s
.5 Mabswid
.64099 .51043 m .47668 .43006 L .44185 .45859 L p .7 .796 .924 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00P03oool3000009d0oooo001l0?ooo`@000000P1eO<`00`000000oooo
0?ooo`2K0?ooo`00NP3oool2000000L0MGc<00<000000?ooo`3oool0VP3oool007X0oooo00<00000
07Elc01eO<`01P1eO<`00`000000oooo0?ooo`2J0?ooo`00N`3oool907Elc0030000003oool0oooo
09T0oooo001k0?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3oool0V@3oool007`0oooo
201eO<`00`000000oooo0?ooo`2I0?ooo`00O03oool907Elc0030000003oool0oooo09P0oooo001l
0?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3oool0V03oool007d0oooo2@1eO<`00`00
0000oooo0?ooo`2G0?ooo`00O@3oool00`000000MGc<07Elc00607Elc0030000003oool0oooo09L0
oooo001m0?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3oool0U`3oool007h0oooo2@1e
O<`00`000000oooo0?ooo`2F0?ooo`00OP3oool00`000000MGc<07Elc00607Elc0030000003oool0
oooo09H0oooo001o0?ooo`P0MGc<00<000000?ooo`3oool0UP3oool007l0oooo00<0000007Elc01e
O<`01P1eO<`00`000000oooo0?ooo`2E0?ooo`00O`3oool00`000000MGc<07Elc00607Elc0030000
003oool0oooo09D0oooo00200?ooo`T0MGc<00<000000?ooo`3oool0U03oool00800oooo00<00000
07Elc01eO<`01P1eO<`00`000000oooo0?ooo`2D0?ooo`00P03oool00`000000MGc<07Elc00607El
c0030000003oool0oooo09@0oooo00210?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3o
ool0T`3oool00840oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?ooo`2C0?ooo`00PP3o
ool307Elc0030?ooo`1eO<`0MGc<00<0MGc<00<000000?ooo`3oool0TP3oool00880oooo00<00000
07Elc01eO<`01P1eO<`00`000000oooo0?ooo`2B0?ooo`00PP3oool00`000000MGc<07Elc00607El
c0030000003oool0oooo0980oooo00230?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3o
ool0T@3oool008<0oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?ooo`2A0?ooo`00Q03o
ool907Elc0030000003oool0oooo0900oooo00240?ooo`030000001eO<`0MGc<00H0MGc<00<00000
0?ooo`3oool0T03oool008@0oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?ooo`2@0?oo
o`00Q@3oool00`000000MGc<07Elc00607Elc0030000003oool0oooo08l0oooo00250?ooo`030000
001eO<`0MGc<0080MGc<00D0oooo07Elc01eO<`0MGc<0000002A0?ooo`00Q@3oool00`000000MGc<
07Elc00707Elc0030000003oool0oooo08h0oooo00260?ooo`030000001eO<`0MGc<0080MGc<00D0
oooo07Elc01eO<`0MGc<0000002@0?ooo`00QP3oool00`000000MGc<07Elc00607Elc0030000003o
ool0oooo08h0oooo00270?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3oool0S@3oool0
08L0oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?ooo`2=0?ooo`00Q`3oool00`000000
MGc<07Elc00707Elc0030000003oool0oooo08`0oooo00280?ooo`030000001eO<`0MGc<00H0MGc<
00<000000?ooo`3oool0S03oool008P0oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?oo
o`2<0?ooo`00R@3oool00`000000MGc<07Elc00307Elc0040?ooo`1eO<`0MGc<000003D0oooo0`00
001E0?ooo`00R@3oool00`000000MGc<07Elc00607Elc0030000003oool0oooo02l0oooo1P00001F
0?ooo`00R@3oool00`000000MGc<07Elc00407Elc0030?ooo`1eO<`0000002h0oooo0`00000203/0
00800000F03oool008X0oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?ooo`0Y0?ooo`80
0000100k00000`000000oooo0?ooo`1H0?ooo`00RP3oool00`000000MGc<07Elc00607Elc0030000
003oool0oooo02P0oooo00<0000003/0000k00000P0k0002000005/0oooo002:0?ooo`030000001e
O<`0MGc<00L0MGc<00<000000?ooo`3oool09@3oool2000000@0>`0000<000000?ooo`3oool0F`3o
ool008/0oooo00<0000007Elc01eO<`01P1eO<`00`000000oooo0?ooo`0S0?ooo`800000100k0002
000005h0oooo002;0?ooo`030000001eO<`0MGc<00H0MGc<00<000000?ooo`3oool08P3oool00`00
0000>`0003/0000203/000800000H03oool008`0oooo00<0000007Elc01eO<`01P1eO<`00`000000
oooo0?ooo`0O0?ooo`800000100k00000`000000oooo0?ooo`1P0?ooo`00S03oool00`000000MGc<
07Elc00507Elc0030?ooo`000000oooo01l0oooo00<0000003/0000k00000P0k0002000006<0oooo
002<0?ooo`030000001eO<`0MGc<00L0MGc<00<000000?ooo`3oool06`3oool2000000@0>`0000<0
00000?ooo`3oool0H`3oool008d0oooo00<0000007Elc01eO<`01@1eO<`00`3oool000000?ooo`0J
0?ooo`800000100k0002000006H0oooo002=0?ooo`030000001eO<`0MGc<00H0MGc<00<000000?oo
o`3oool0603oool00`000000>`0003/0000203/000800000J03oool008d0oooo00<0000007Elc01e
O<`01`1eO<`00`000000oooo0?ooo`0E0?ooo`800000100k00000`000000oooo0?ooo`1X0?ooo`00
SP3oool00`000000MGc<07Elc00607Elc0<00000503oool00`000000>`0003/0000203/000800000
J`3oool008h0oooo00<0000007Elc01eO<`01`1eO<`00`000000Z7^R00000004000000d0oooo0P00
000403/000030000003oool0oooo06/0oooo00280?ooo`8000001@3oool00`000000MGc<07Elc007
000000<0Z7^R00<000000<^NZP3;WZX00`0000080?ooo`800000100k0002000006h0oooo00270?oo
o`030000002cbn`0/l_/008000000`3oool300000080oooo00@0000006a2S@1/@Xd00000102XNj80
0`000000bijZ0<^NZP020<^NZP8000001P3oool00`000000>`0003/0000203/000800000L03oool0
08D0oooo0P0000050;?;k08000001@3oool01@000000K4:=06a2S@1/@Xd0000000<0Z7^R00<00000
0<^NZP3;WZX00`3;WZX00`000000lLVW000000030?ooo`800000100k00000`000000oooo0?ooo`1`
0?ooo`00Q03oool00`000000/l_/0;?;k0070;?;k08000000`3oool01@000000K4:=06a2S@1/@Xd0
000000<0Z7^R00<000000<^NZP3;WZX00P3;WZX010000000lLVW0?79Y`0000020?ooo`030000000k
0000>`000080>`000P00001c0?ooo`00P`3oool00`000000/l_/0;?;k00:0;?;k080000000<0oooo
0000001/@Xd00P1/@Xd01@000000Z7^R0:QkXP2XNj80000000@0bijZ00<000000?79Y`3abJL00`00
000403/000030000003oool0oooo07<0oooo00220?ooo`030000002cbn`0/l_/00d0/l_/0P000002
06a2S@030000002XNj80Z7^R0080Z7^R00<000000<^NZP3;WZX00P3;WZX010000000lLVW00000000
000403/000800000MP3oool00800oooo0P00000B0;?;k0<00000102XNj800`000000bijZ0<^NZP02
0<^NZP040000003abJL00000000000<0>`0000<000000?ooo`3oool0MP3oool007l0oooo00<00000
0;?;k02cbn`0502cbn`200000080Z7^R00<000000<^NZP3;WZX00P3;WZX00`000000lLVW0?79Y`05
000007T0oooo001n0?ooo`030000002cbn`0/l_/01L0/l_/0`0000040<^NZP040000003abJL0lLVW
000007d0oooo00200?ooo`800000602cbn`2000000<0bijZ00@000000?79Y`3abJL00000O@3oool0
0880oooo0P00000H0;?;k080000000D0bijZ0000003abJL0lLVW0000001m0?ooo`00P@3oool00`00
0000/l[[0;?:j`02000001P0/l_/0P0000000`3abJL000000?ooo`1m0?ooo`00O`3oool2000000D0
/l[[0P00000H0;?;k0800000OP3oool007h0oooo00<000000;?:j`2cb^/01`2cb^/2000001P0/l_/
0P00001l0?ooo`00O@3oool00`000000/l[[0;?:j`0:0;?:j`800000602cbn`2000007X0oooo001j
0?ooo`<000003`2cb^/3000001L0/l_/0P00001h0?ooo`00N03oool3000001<0/l[[0`00000G0;?;
k0800000MP3oool007L0oooo00@0000009o8m000000000005@2cb^/3000001L0/l_/0P00001d0?oo
o`00M`3oool00`000000bl7B00000003000001D0/l[[0`00000G0;?;k0800000LP3oool007H0oooo
00<000000<_1dP3;`M800P3;`M84000001D0/l[[0`00000G0;?;k08000002@3oool<000005/0oooo
001f0?ooo`030000003;`M80000000D0bl7B0`00000E0;?:j`<000005`2cbn`200000080oooo1@00
000405008`8000001P1_WNd00`000000oooo0?ooo`1H0?ooo`00M@3oool00`000000bl7B0<_1dP03
000000@0bl7B00@000000=baZ`00000000005@2cb^/3000001L0/l_/0P00000805008`030000001_
WNd0Kig]00L0Kig]00<000000?ooo`3oool0E`3oool007D0oooo00<000000=^`Z`0000001@000000
0`3;`M8000000=baZ`030=baZ`<000005@2cb^/3000001H0/l_/0P00000505008`8000002@1_WNd0
0`000000oooo0?ooo`1G0?ooo`00M03oool00`000000fk2[0=^`Z`08000000H0g;6[0`00000E0;?:
j`<000005P2cbn`5000000030?ooo`000000Kig]00T0Kig]00<000000?ooo`3oool0403oool30000
04<0oooo001d0?ooo`030000003K/:/0000000P00000203L/J/3000001D0/l[[0`00000C0;?;k080
00000`1[@H`010000000oooo0?ooo`00000506nMk@H000003P3oool40000000406?Dl@0000000000
00000440oooo001c0?ooo`030000003K/:/0fk2[0080fk2[2@0000080=baZ`<000005@2cb^/30000
0100/l_/00<0000006]1S01[@H`00`1[@H`200000080oooo1@00000507Aa`@030000003oool0oooo
00T0oooo0`0000000`0X00@0000000000002000000<0Q:O[00<000000?ooo`3oool0?P3oool007<0
oooo0P0000050=^`Z`H0000000<0bl?B000000000000203L/J/400000180/l[[1@00000=0;?;k003
0000001[@H`0Jd6<00<0Jd6<00<0000007Aa`@0000000P3oool00`000000M77107Aa`@0807Aa`@03
0000003oool0oooo00D0oooo1`0000000`1F;X@0000008BWj`0208BWj`@00000?`3oool007<0oooo
00@000000=n5HP00000000001@3K/:/3000000@0bl?B0P0000080=baZ`@000003P2cb^/2000000D0
Jd6<0P00000:0;?;k0030000001[@H`0Jd6<00@0Jd6<00<0000007Aa`@0000001000000907Aa`@04
0000003oool0oooo0?ooo`L000001@1F;X@4000000<0Pg_200<000000?ooo`3oool0?@3oool007@0
oooo00<000000=n5HP3OQF800`0000001@3K/:/000000<_3dP3;`m80000000H0bl?B0`0000070=ba
Z`@000002`2cb^/00`000000Jd6<06]1S00706]1S08000001P2cbn`2000000H0Jd6<3P00000307Aa
`@L000002@1F;X@00`000000Pg_208=k`P0408=k`P030000003oool0oooo03d0oooo001d0?ooo`80
0000103OQF83000000/0bl?B0P0000060=baZ`80000000<0Z6=o000000000000202cb^/00`000000
Jd6<06]1S00:06]1S0<000000P2cbn`00`000000Jd6<06]1S00606]1S0h0000000<0M77100000000
00000`00000805H^Q0d00000?`3oool007D0oooo1@00000309g9mP8000002`3;`m82000000@0g;6[
0`0000020:QSO`8000001@2cb^/00`000000Jd6<06]1S00806]1S0T00000201[@H`L000000D0GF6n
00<0000007mCU01oDi@0101oDi@00`000000oooo0?ooo`0m0?ooo`00M`3oool2000000H0WLWf0`00
000:0<_3dP80000000<0g;6[0000000000000P2XNj8600000080/l[[00<0000006]1S01[@H`02@1[
@H`8000000@0Jd6<6`00000<05eQ_P030000001oDi@0Oe>D00<0Oe>D00<000000?ooo`3oool0?@3o
ool007T0oooo0P00000709g9mP8000002P3;`m83000000@0Z7^R0`0000000`1[@H`000000000000;
06]1S0d000001@1aKl4>0000000306m5S`000000000001P00000?`3oool007P0oooo00<0000007HK
A`1f6dL00`00000609g9mP800000203;`m83000000@0Z7^R0P00000506]1S0X0000000<0LFo10000
000000001P000009075_`@h000000`1_AHl2000000040;?;k000000000000?ooo`T000000`1;SN`0
1@000000LaQ307<H@`1c64<000000400oooo001g0?ooo`T000001P2MbOH3000000D0bl?B10000002
0:QkXP030000003;WZX0000000D00000301aKl48000000P0LFo13P00000306m5S`030000002cbn`0
/l_/0080/l_/0P0000080?ooo`L00000@@3oool007L0oooo00<00000081EU@20EID01P20EID30000
00H0WLWf0P0000020<_3dP@0000000<0YHbk0000000000000`00000A075_`@P00000201aKl4>0000
00<0KdF?00<000000;?;k02cbn`0102cbn`2000004h0oooo001f0?ooo`0300000020EID0P5FE00@0
P5FE2@00000509g9mPH000000`2US;/010000000`j_20<>[`P00000@075_`@P000002@1aKl400`00
0000KdF?000000030?ooo`030000001_AHl0KdF?00L0KdF?00<000000;?;k02cbn`01P2cbn`20000
04`0oooo001f0?ooo`L000001P24Nl8500000080WLWf200000000`2US;/000000<>[`P020<>[`P03
0000001aKl40LFo100h0LFo11@00000206m5S`030000001aKl40LFo100P0LFo10`0000020?ooo`03
0000001_AHl0KdF?00H0KdF?00<000000;?;k02cbn`02@2cbn`2000004X0oooo001f0?ooo`030000
0024Nl80Q7_200H0Q7_2200000000`3oool00000000000030?ooo`P000000P33Zl800`000000LFo1
075_`@0C075_`@040000001_AHl0KdF?000000@0LFo11`0000000`2cb^/000000000000406m5S`H0
00003@2cbn`2000004P0oooo001g0?ooo`0300000024Nl80Q7_200X000002@3oool400000080WIgC
00<000000;JgfP0000000P00000@075_`@H000000P1_AHl5000000H0JIc^00<000000;?:j`2cb^/0
1P00000305T0;P030000002cbn`0/l_/00h0/l_/0P0000160?ooo`00M`3oool30000000308FWjP00
0000000000<000003P3oool01P000000L83C0720d`000000WIgC00000080][OJ00<000000<KKj000
00001@1aKl4:000000H0JIc^1000000:06VLkP800000201I02h00`000000/l_/0;?;k00A0;?;k080
0000A03oool007P0oooo1@00000B0?ooo`D000000P2f]mX00`000000a]_X0000000500000140JIc^
00<0000005T0;P1I02h00P00000906VLkP030000001I02h0F@0^00H0F@0^00<000000;?;k02cbn`0
4`2cbn`200000480oooo002@0?ooo`P0000000<0oooo0000001YW>h0501YW>h00`000000F@0^05T0
;P0205T0;P030000001YW>h0JIc^00L0JIc^00<0000005T0;P1I02h0101I02h2000001L0/l_/0P00
00100?ooo`00T@3oool5000000@0oooo00<0000006VLkP1YW>h04`1YW>h00`000000F@0^05T0;P02
05T0;Q0000000P2cb^/2000001L0/l_/0P00000n0?ooo`00T@3oool3000000H0oooo0P00000;06VL
kQ4000004@2cb^/2000001L0/l_/0P00000l0?ooo`00RP3oool:000000L0oooo4P0000080=baZ`<0
00004`2cb^/3000001H0/l_/0P00000j0?ooo`00R@3oool200000080K4:=00<000000:QkXP2XNj80
0P2XNj8010000000bijZ0000000000050?ooo`8000000`3OQF83000000X0bl?B0P0000080=baZ`<0
00004`2cb^/3000001H0/l_/0P00000h0?ooo`00R@3oool200000080K4:=00<000000:QkXP2XNj80
0P2XNj8010000000bijZ0<^NZP3;WZX2000000@0oooo1@00000209g9mP8000002P3;`m82000000P0
g;6[0`00000C0;?:j`<000005P2cbn`2000003H0oooo00290?ooo`040000001/@Xd0K4:=000000@0
Z7^R00<000000<^NZP3;WZX00`3;WZX3000000@0oooo0P00000509g9mP8000002P3;`m82000000P0
g;6[1000000B0;?:j`<000005P2cbn`2000003@0oooo00280?ooo`8000000P1/@Xd00`000000Z7^R
0:QkXP020:QkXP030000003;WZX0bijZ00<0bijZ00<000000?79Y`0000001P3oool2000000D0WLWf
0`0000090<_3dP<00000103L/J/00`000000g;6[000000020?ooo`8000003`2cb^/200000080oooo
0`00000E0;?;k0800000<P3oool008P0oooo0P00000206a2S@030000002XNj80Z7^R0080Z7^R00<0
00000<^NZP3;WZX00P3;WZX010000000lLVW0?79Y`0000080?ooo`8000001P2MbOH2000000X0bl?B
0P0000020=baZ`<00000103oool2000000`0/l[[00<000000?ooo`3oool01@3oool2000001D0/l_/
0P00000`0?ooo`00R03oool200000080K4:=00<000000:QkXP2XNj800P2XNj800`000000bijZ0<^N
ZP020<^NZP030000003abJL0000000/0oooo0P00000609g9mP8000002P3;`m87000000@0oooo0P00
00090;?:j`030000003oool0oooo00P0oooo0P00000E0;?;k0800000;P3oool008P0oooo00@00000
06a2S@1/@Xd00000102XNj800`000000bijZ0<^NZP030<^NZP030000003abJL0000000d0oooo0P00
000609g9mP8000002@3;`m88000000@0oooo0P0000050;?:j`8000003@3oool2000001D0/l_/0P00
000/0?ooo`00Q`3oool200000080K4:=00<000000:QkXP2XNj800P2XNj800`000000bijZ0<^NZP03
0<^NZP030000003abJL0000000l0oooo0`00000509g9mP<000001@3;`m8;000000@0oooo0P000002
0;?:j`030000003oool0oooo00l0oooo0P00000B0;?;k0800000;@3oool008L0oooo0P00000206a2
S@030000002XNj80Z7^R0080Z7^R00<000000<^NZP3;WZX00P3;WZX010000000lLVW0?79Y`00000B
0?ooo`8000001P2MbOH2000000D0bl?B2`0000040?ooo`800000503oool3000000d0/l_/0P00000_
0?ooo`00Q`3oool200000080K4:=00<000000:QkXP2XNj800P2XNj800`000000bijZ0<^NZP020<^N
ZP030000003abJL0000001D0oooo0P00000609g9mP8000000P3;`m800`000000oooo0?ooo`080000
01h0oooo0P00000:0;?;k0030000003oool0oooo02l0oooo00270?ooo`8000000P1/@Xd00`000000
Z7^R0:QkXP020:QkXP030000003;WZX0bijZ0080bijZ00<000000?79Y`0000005`3oool2000000H0
WLWf0P0000050?ooo`H00000803oool2000000H0/l_/0P00000b0?ooo`00Q`3oool010000000K4:=
06a2S@0000040:QkXP030000003;WZX0bijZ00<0bijZ00<000000?79Y`0000006@3oool200000080
WLWf0P0000090?ooo`<000008`3oool200000080/l_/0P00000d0?ooo`00QP3oool200000080K4:=
00<000000:QkXP2XNj800P2XNj800`000000bijZ0<^NZP030<^NZP030000003abJL0000001/0oooo
0P00000=0?ooo`030000003oool0oooo02<0oooo0P00000f0?ooo`00QP3oool200000080K4:=00<0
00000:QkXP2XNj800P2XNj800`000000bijZ0<^NZP020<^NZP040000003abJL0lLVW000008P0oooo
00260?ooo`8000000P1/@Xd00`000000Z7^R0:QkXP020:QkXP030000003;WZX0bijZ0080bijZ00<0
00000?79Y`000000R@3oool008H0oooo00@0000006a2S@1/@Xd000001@2XNj800`000000bijZ0<^N
ZP020<^NZP030000003abJL0000008T0oooo00250?ooo`8000000P1/@Xd00`000000Z7^R0:QkXP02
0:QkXP030000003;WZX0bijZ00<0bijZ00<000000?79Y`000000R@3oool008D0oooo0P00000206a2
S@030000002XNj80Z7^R0080Z7^R00<000000<^NZP3;WZX00P3;WZX010000000lLVW0?79Y`000029
0?ooo`00Q@3oool200000080K4:=00<000000:QkXP2XNj800P2XNj800`000000bijZ0<^NZP020<^N
ZP040000003abJL0lLVW000008T0oooo00250?ooo`040000001/@Xd0K4:=000000D0Z7^R00<00000
0<^NZP3;WZX00P3;WZX00`000000lLVW0000002:0?ooo`00Q03oool200000080K4:=00<000000:Qk
XP2XNj800P2XNj800`000000bijZ0<^NZP030<^NZP030000003abJL0000008X0oooo00240?ooo`L0
000000<0Z7^R000000000000103;WZX010000000lLVW0?79Y`00002:0?ooo`00Q03oool200000080
l<NX0`3:WZX500000080bijZ00@000000?79Y`3abJL00000RP3oool008H0oooo0P0000030<ZNZP80
00000`2XO:<3000000030?79Y`000000000008X0oooo00280?ooo`80000000<0bYjZ000000000000
0`2XO:<00`000000KdF>06m5SP02000008/0oooo002:0?ooo`@000000P2XO:<01@000000KdF>06m5
SP1_AHh0000008/0oooo002;0?ooo`80000000<0oooo0000000000001@00002;0?ooo`00RP3oool2
000009@0oooo002:0?ooo`800000U03oool008X0oooo0P00002D0?ooo`00RP3oool2000009@0oooo
002:0?ooo`800000U03oool008T0oooo0P00002E0?ooo`00R@3oool2000009D0oooo00290?ooo`80
0000U@3oool008T0oooo0P00002E0?ooo`00R03oool3000009D0oooo00290?ooo`030000003oool0
oooo09@0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.51952 .46436 m .55213 .41316 L .59227 .41917 L p .577 .088 .056 r
F P
0 g
s
.59227 .41917 m .56591 .46551 L p .51952 .46436 L .577 .088 .056 r
F P
0 g
s
.54406 .46812 m .51952 .46436 L p .56591 .46551 L .577 .088 .056 r
F P
0 g
s
.53424 .45413 m .52019 .44725 L p .51979 .47102 L .824 .619 .625 r
F P
0 g
s
.51892 .5221 m .53073 .46971 L p .51979 .47102 L .824 .619 .625 r
F P
0 g
s
.53073 .46971 m .53424 .45413 L p .51979 .47102 L .824 .619 .625 r
F P
0 g
s
.56591 .46551 m .56279 .47099 L .54406 .46812 L p .577 .088 .056 r
F P
0 g
s
.72955 .67531 m .73529 .59511 L .69265 .60919 L p .725 .896 .957 r
F P
0 g
s
.69265 .60919 m .69002 .68849 L .72955 .67531 L p .725 .896 .957 r
F P
0 g
s
.50854 .55342 m .51465 .60032 L .53099 .59824 L p .656 .824 .964 r
F P
0 g
s
.53099 .59824 m .52558 .55126 L .50854 .55342 L p .656 .824 .964 r
F P
0 g
s
.52558 .55126 m .53099 .59824 L .54536 .60527 L p .347 .575 .926 r
F P
0 g
s
.49586 .56417 m .5025 .61071 L .51465 .60032 L p .872 .951 .859 r
F P
0 g
s
.51465 .60032 m .50854 .55342 L .49586 .56417 L p .872 .951 .859 r
F P
0 g
s
.54536 .60527 m .54057 .5585 L .52558 .55126 L p .347 .575 .926 r
F P
0 g
s
.54057 .5585 m .54536 .60527 L .55231 .61878 L p 0 0 .574 r
F P
0 g
s
.49236 .57948 m .49917 .62553 L .5025 .61071 L p .941 .849 .416 r
F P
0 g
s
.5025 .61071 m .49586 .56417 L .49236 .57948 L p .941 .849 .416 r
F P
0 g
s
.63909 .63942 m .63812 .58167 L .59983 .59424 L p .729 .889 .953 r
F P
0 g
s
.59983 .59424 m .6028 .65143 L .63909 .63942 L p .729 .889 .953 r
F P
0 g
s
.55231 .61878 m .5478 .57245 L .54057 .5585 L p 0 0 .574 r
F P
0 g
s
.5478 .57245 m .55231 .61878 L .54913 .63367 L p .918 .833 .377 r
F P
0 g
s
.49947 .59354 m .506 .63914 L .49917 .62553 L p 0 0 .541 r
F P
0 g
s
.49917 .62553 m .49236 .57948 L .49947 .59354 L p 0 0 .541 r
F P
0 g
s
.54913 .63367 m .54446 .58783 L .5478 .57245 L p .918 .833 .377 r
F P
0 g
s
.54446 .58783 m .54913 .63367 L .53695 .64421 L p .872 .96 .857 r
F P
0 g
s
.51453 .60092 m .52045 .6463 L .506 .63914 L p .324 .569 .928 r
F P
0 g
s
.506 .63914 m .49947 .59354 L .51453 .60092 L p .324 .569 .928 r
F P
0 g
s
.53695 .64421 m .53175 .59874 L .54446 .58783 L p .872 .96 .857 r
F P
0 g
s
.53175 .59874 m .53695 .64421 L .52045 .6463 L p .65 .83 .969 r
F P
0 g
s
.52045 .6463 m .51453 .60092 L .53175 .59874 L p .65 .83 .969 r
F P
0 g
s
.02 w
.51885 .56594 m
.52301 .59985 L
s
.5 Mabswid
.53424 .45413 m .51892 .5221 L .53589 .52476 L p .688 .479 .599 r
F P
0 g
s
.53589 .52476 m .55098 .45668 L .53424 .45413 L p .688 .479 .599 r
F P
0 g
s
.55098 .45668 m .53589 .52476 L .54921 .5223 L p .483 .284 .534 r
F P
0 g
s
.54921 .5223 m .56419 .45394 L .55098 .45668 L p .483 .284 .534 r
F P
0 g
s
.50463 .51534 m .52019 .44725 L .51412 .43858 L p .978 .802 .598 r
F P
0 g
s
.52019 .44725 m .50463 .51534 L .51892 .5221 L p .824 .619 .625 r
F P
0 g
s
.56419 .45394 m .54921 .5223 L .55383 .5156 L p 0 0 .162 r
F P
0 g
s
.55383 .5156 m .56884 .44688 L .56419 .45394 L p 0 0 .162 r
F P
0 g
s
.51412 .43858 m .49837 .50696 L .50463 .51534 L p .978 .802 .598 r
F P
0 g
s
.49837 .50696 m .51412 .43858 L .51845 .43139 L p 0 0 .116 r
F P
0 g
s
.56884 .44688 m .55383 .5156 L .54782 .50714 L p .983 .807 .588 r
F P
0 g
s
.54782 .50714 m .563 .43812 L .56884 .44688 L p .983 .807 .588 r
F P
0 g
s
.51845 .43139 m .5317 .42849 L p .52402 .44743 L .474 .273 .527 r
F P
0 g
s
.51602 .49751 m .5317 .42849 L .54878 .43106 L p .687 .477 .596 r
F P
0 g
s
.5317 .42849 m .51602 .49751 L .50266 .50012 L p .474 .273 .527 r
F P
0 g
s
.53716 .23024 m .51575 .43067 L .54096 .43448 L p .664 .598 .771 r
F P
0 g
s
.53334 .5002 m .54878 .43106 L .563 .43812 L p .827 .62 .622 r
F P
0 g
s
.54878 .43106 m .53334 .5002 L .51602 .49751 L p .687 .477 .596 r
F P
0 g
s
.54096 .43448 m .5602 .43739 L p .5584 .42116 L .664 .598 .771 r
F P
0 g
s
.5584 .42116 m .53716 .23024 L .54096 .43448 L .664 .598 .771 r
F
.50266 .50012 m .51279 .45601 L p .52402 .44743 L .474 .273 .527 r
F P
0 g
s
.51279 .45601 m .51845 .43139 L p .52402 .44743 L .474 .273 .527 r
F P
0 g
s
.51845 .43139 m .50266 .50012 L .49837 .50696 L p 0 0 .116 r
F P
0 g
s
.38137 .53202 m .37904 .54122 L .48916 .54692 L closepath p .652 .443 .588 r
F P
0 g
s
.3826 .52183 m .38137 .53202 L .48916 .54692 L closepath p .638 .546 .734 r
F P
0 g
s
.563 .43812 m .54782 .50714 L .53334 .5002 L p .827 .62 .622 r
F P
0 g
s
.38227 .51449 m .3826 .52183 L .48916 .54692 L closepath p .565 .629 .874 r
F P
0 g
s
.37904 .54122 m .37648 .54597 L .48916 .54692 L closepath p .584 .186 .254 r
F P
0 g
s
.67686 .58172 m .57665 .56582 L .57206 .58754 L p .688 .48 .6 r
F P
0 g
s
.57665 .56582 m .67686 .58172 L .68034 .55783 L p .672 .577 .74 r
F P
0 g
s
.68034 .55783 m .57991 .54205 L .57665 .56582 L p .672 .577 .74 r
F P
0 g
s
.49479 .56062 m .49734 .54946 L .5114 .556 L p .824 .619 .625 r
F P
0 g
s
.5114 .556 m .50889 .56714 L .49479 .56062 L p .824 .619 .625 r
F P
0 g
s
.51502 .54397 m .5114 .556 L .49734 .54946 L p .791 .669 .729 r
F P
0 g
s
.50889 .56714 m .5114 .556 L .52806 .55864 L p .688 .479 .599 r
F P
0 g
s
.5114 .556 m .51502 .54397 L .52837 .54608 L p .679 .549 .7 r
F P
0 g
s
.52837 .54608 m .52806 .55864 L .5114 .556 L p .679 .549 .7 r
F P
0 g
s
.49734 .54946 m .50375 .5387 L .51502 .54397 L p .791 .669 .729 r
F P
0 g
s
.51904 .53336 m .51502 .54397 L .50375 .5387 L p .741 .704 .817 r
F P
0 g
s
.01 w
.52408 .52005 m
.5287 .49948 L
s
.5 Mabswid
.51502 .54397 m .51904 .53336 L .52647 .53453 L p .658 .61 .79 r
F P
0 g
s
.52647 .53453 m .52837 .54608 L .51502 .54397 L p .658 .61 .79 r
F P
0 g
s
.57991 .54205 m .68034 .55783 L .68184 .54074 L p .616 .668 .877 r
F P
0 g
s
.68184 .54074 m .58064 .52494 L .57991 .54205 L p .616 .668 .877 r
F P
0 g
s
.38048 .51279 m .38227 .51449 L .48916 .54692 L closepath p .027 .54 .868 r
F P
0 g
s
.52806 .55864 m .52837 .54608 L .53883 .54423 L p .517 .414 .676 r
F P
0 g
s
.52837 .54608 m .52647 .53453 L .53227 .53348 L p .535 .523 .788 r
F P
0 g
s
.53227 .53348 m .53883 .54423 L .52837 .54608 L p .535 .523 .788 r
F P
0 g
s
.52806 .55864 m .52558 .5698 L .50889 .56714 L p .688 .479 .599 r
F P
0 g
s
.52558 .5698 m .52806 .55864 L .5411 .55639 L p .482 .284 .534 r
F P
0 g
s
.53883 .54423 m .5411 .55639 L .52806 .55864 L p .517 .414 .676 r
F P
0 g
s
.37648 .54597 m .37467 .54441 L .48916 .54692 L closepath p .293 .757 .947 r
F P
0 g
s
.49662 .57001 m .49479 .56062 L .50889 .56714 L p .84 .518 .442 r
F P
0 g
s
.50889 .56714 m .50798 .57524 L .49662 .57001 L p .84 .518 .442 r
F P
0 g
s
.50798 .57524 m .50889 .56714 L .52558 .5698 L p .678 .363 .434 r
F P
0 g
s
.51904 .53336 m .51279 .53041 L p .53423 .53059 L .52 .721 .964 r
F P
0 g
s
.52647 .53453 m .51904 .53336 L p .53423 .53059 L .52 .721 .964 r
F P
0 g
s
.50375 .5387 m .51279 .53041 L .51904 .53336 L p .741 .704 .817 r
F P
0 g
s
.49115 .54144 m .49883 .53222 L .50375 .5387 L p .903 .843 .776 r
F P
0 g
s
.50375 .5387 m .49734 .54946 L .49115 .54144 L p .903 .843 .776 r
F P
0 g
s
.51279 .53041 m .50375 .5387 L .49883 .53222 L p .798 .833 .879 r
F P
0 g
s
.67269 .60363 m .57206 .58754 L .56782 .59915 L p .653 .265 .297 r
F P
0 g
s
.57206 .58754 m .67269 .60363 L .67686 .58172 L p .688 .48 .6 r
F P
0 g
s
.53423 .53059 m .53227 .53348 L .52647 .53453 L p .52 .721 .964 r
F P
0 g
s
.48857 .55264 m .49115 .54144 L .49734 .54946 L p .978 .802 .598 r
F P
0 g
s
.49734 .54946 m .49479 .56062 L .48857 .55264 L p .978 .802 .598 r
F P
0 g
s
.52558 .5698 m .52141 .57739 L .50798 .57524 L p .678 .363 .434 r
F P
0 g
s
.52141 .57739 m .52558 .5698 L .53865 .5676 L p .396 .059 .273 r
F P
0 g
s
.5411 .55639 m .53865 .5676 L .52558 .5698 L p .482 .284 .534 r
F P
0 g
s
.51279 .53041 m .51008 .5268 L p .53423 .53059 L .52 .721 .964 r
F P
0 g
s
.49883 .53222 m .51008 .5268 L .51279 .53041 L p .798 .833 .879 r
F P
0 g
s
.5411 .55639 m .53883 .54423 L .5424 .53908 L p .072 .103 .587 r
F P
0 g
s
.53883 .54423 m .53227 .53348 L .53423 .53059 L p .287 .401 .804 r
F P
0 g
s
.53423 .53059 m .5424 .53908 L .53883 .54423 L p .287 .401 .804 r
F P
0 g
s
.37791 .51746 m .38048 .51279 L .48916 .54692 L closepath p .706 .317 .309 r
F P
0 g
s
.73869 .59152 m .69368 .58438 L .68958 .60633 L p .688 .48 .6 r
F P
0 g
s
.69368 .58438 m .73869 .59152 L .7423 .56757 L p .672 .577 .74 r
F P
0 g
s
.7423 .56757 m .69719 .56048 L .69368 .58438 L p .672 .577 .74 r
F P
0 g
s
.49163 .56365 m .48857 .55264 L .49479 .56062 L p .945 .6 .196 r
F P
0 g
s
.49479 .56062 m .49662 .57001 L .49163 .56365 L p .945 .6 .196 r
F P
0 g
s
.53865 .5676 m .5411 .55639 L .54559 .55003 L p 0 0 .161 r
F P
0 g
s
.5424 .53908 m .54559 .55003 L .5411 .55639 L p .072 .103 .587 r
F P
0 g
s
.5602 .43739 m .58302 .23662 L .53716 .23024 L p .664 .598 .771 r
F P
0 g
s
.51008 .5268 m .51198 .52389 L p .53423 .53059 L .52 .721 .964 r
F P
0 g
s
.01 w
.52251 .52706 m
.52408 .52005 L
s
.5 Mabswid
.5022 .527 m .51198 .52389 L .51008 .5268 L p .708 .969 .933 r
F P
0 g
s
.51008 .5268 m .49883 .53222 L .5022 .527 L p .708 .969 .933 r
F P
0 g
s
.50252 .57578 m .49662 .57001 L .50798 .57524 L p .698 .162 0 r
F P
0 g
s
.01 w
.50782 .59254 m
.50995 .58303 L
s
.5 Mabswid
.50798 .57524 m .50885 .57869 L .50252 .57578 L p .698 .162 0 r
F P
0 g
s
.50885 .57869 m .50798 .57524 L .52141 .57739 L p .542 .021 0 r
F P
0 g
s
.37467 .54441 m .3743 .53706 L .48916 .54692 L closepath p .657 .706 .883 r
F P
0 g
s
.69719 .56048 m .7423 .56757 L .74429 .55049 L p .616 .668 .877 r
F P
0 g
s
.74429 .55049 m .69883 .54339 L .69719 .56048 L p .616 .668 .877 r
F P
0 g
s
.52141 .57739 m .51634 .57989 L .50885 .57869 L p .542 .021 0 r
F P
0 g
s
.51634 .57989 m .52141 .57739 L .53191 .57565 L p .068 0 0 r
F P
0 g
s
.53865 .5676 m .53191 .57565 L .52141 .57739 L p .396 .059 .273 r
F P
0 g
s
.49531 .53496 m .5022 .527 L .49883 .53222 L p .667 .901 .56 r
F P
0 g
s
.49883 .53222 m .49115 .54144 L .49531 .53496 L p .667 .901 .56 r
F P
0 g
s
.52528 .52399 m .53157 .52696 L .53423 .53059 L p .52 .721 .964 r
F P
0 g
s
.51779 .52281 m .52528 .52399 L p .53423 .53059 L .52 .721 .964 r
F P
0 g
s
.51198 .52389 m .51779 .52281 L p .53423 .53059 L .52 .721 .964 r
F P
0 g
s
.5424 .53908 m .53423 .53059 L .53157 .52696 L p 0 .104 .635 r
F P
0 g
s
.68958 .60633 m .73478 .61356 L .73869 .59152 L p .688 .48 .6 r
F P
0 g
s
.58064 .52494 m .68184 .54074 L .68077 .53698 L p .197 .673 .935 r
F P
0 g
s
.68077 .53698 m .57851 .52104 L .58064 .52494 L p .197 .673 .935 r
F P
0 g
s
.54559 .55003 m .54312 .5613 L .53865 .5676 L p 0 0 .161 r
F P
0 g
s
.53191 .57565 m .53865 .5676 L .54312 .5613 L p .619 .865 .512 r
F P
0 g
s
.56782 .59915 m .66936 .61547 L .67269 .60363 L p .653 .265 .297 r
F P
0 g
s
.37554 .52675 m .37791 .51746 L .48916 .54692 L closepath p .72 .511 .606 r
F P
0 g
s
.49977 .57225 m .49163 .56365 L .49662 .57001 L p 0 .06 .59 r
F P
0 g
s
.49662 .57001 m .50252 .57578 L .49977 .57225 L p 0 .06 .59 r
F P
0 g
s
.49273 .54623 m .49531 .53496 L .49115 .54144 L p 0 0 .116 r
F P
0 g
s
.49115 .54144 m .48857 .55264 L .49273 .54623 L p 0 0 .116 r
F P
0 g
s
.48458 .67451 m .50087 .60221 L .48628 .59558 L p .824 .619 .625 r
F P
0 g
s
.50087 .60221 m .48458 .67451 L .50205 .67741 L p .688 .479 .599 r
F P
0 g
s
.50205 .67741 m .5181 .60499 L .50087 .60221 L p .688 .479 .599 r
F P
0 g
s
.51268 .52505 m .51779 .52281 L .51198 .52389 L p .015 0 0 r
F P
0 g
s
.51198 .52389 m .5022 .527 L .51268 .52505 L p .015 0 0 r
F P
0 g
s
.73478 .61356 m .68958 .60633 L .6864 .6182 L p .653 .265 .297 r
F P
0 g
s
.53157 .52696 m .53763 .53256 L .5424 .53908 L p 0 .104 .635 r
F P
0 g
s
.54559 .55003 m .5424 .53908 L .53763 .53256 L p .933 .583 .155 r
F P
0 g
s
.3743 .53706 m .37554 .52675 L .48916 .54692 L closepath p .702 .605 .745 r
F P
0 g
s
.03 w
.48916 .54692 m
.48986 .54703 L
s
.5 Mabswid
.5181 .60499 m .50205 .67741 L .51563 .67563 L p .483 .284 .534 r
F P
0 g
s
.51563 .67563 m .53156 .60288 L .5181 .60499 L p .483 .284 .534 r
F P
0 g
s
.53763 .53256 m .53157 .52696 L .52528 .52399 L p .676 .129 0 r
F P
0 g
s
.53191 .57565 m .52218 .57892 L .51634 .57989 L p .068 0 0 r
F P
0 g
s
.52218 .57892 m .53191 .57565 L .53547 .57063 L p .691 .971 .924 r
F P
0 g
s
.54312 .5613 m .53547 .57063 L .53191 .57565 L p .619 .865 .512 r
F P
0 g
s
.49499 .55855 m .49273 .54623 L .48857 .55264 L p .035 .075 .572 r
F P
0 g
s
.48857 .55264 m .49163 .56365 L .49499 .55855 L p .035 .075 .572 r
F P
0 g
s
.52625 .52718 m .52528 .52399 L .51779 .52281 L p .52 0 0 r
F P
0 g
s
.51779 .52281 m .51268 .52505 L .52625 .52718 L p .52 0 0 r
F P
0 g
s
.50885 .57869 m .51634 .57989 L p .52141 .57261 L .508 .722 .969 r
F P
0 g
s
.50252 .57578 m .50885 .57869 L p .52141 .57261 L .508 .722 .969 r
F P
0 g
s
.52528 .52399 m .52625 .52718 L .53763 .53256 L p .676 .129 0 r
F P
0 g
s
.66936 .61547 m .56782 .59915 L .56554 .59602 L p .131 .64 .899 r
F P
0 g
s
.51634 .57989 m .52218 .57892 L p .52141 .57261 L .508 .722 .969 r
F P
0 g
s
.54312 .5613 m .54559 .55003 L .53963 .54194 L p .983 .807 .588 r
F P
0 g
s
.53763 .53256 m .53963 .54194 L .54559 .55003 L p .933 .583 .155 r
F P
0 g
s
.03 w
.49296 .54752 m
.54204 .55529 L
s
.5 Mabswid
.46972 .66802 m .48628 .59558 L .4798 .58756 L p .978 .802 .598 r
F P
0 g
s
.48628 .59558 m .46972 .66802 L .48458 .67451 L p .824 .619 .625 r
F P
0 g
s
.6864 .6182 m .73202 .62553 L .73478 .61356 L p .653 .265 .297 r
F P
0 g
s
.5084 .53256 m .51268 .52505 L .5022 .527 L p .378 .034 .25 r
F P
0 g
s
.5022 .527 m .49531 .53496 L .5084 .53256 L p .378 .034 .25 r
F P
0 g
s
.49977 .57225 m .50252 .57578 L p .52141 .57261 L .508 .722 .969 r
F P
0 g
s
.01 w
.50995 .58303 m
.51194 .5742 L
s
.5 Mabswid
.50165 .56945 m .49499 .55855 L .49163 .56365 L p .265 .389 .803 r
F P
0 g
s
.49163 .56365 m .49977 .57225 L .50165 .56945 L p .265 .389 .803 r
F P
0 g
s
.52218 .57892 m .52413 .57614 L .52141 .57261 L p .508 .722 .969 r
F P
0 g
s
.53547 .57063 m .52413 .57614 L .52218 .57892 L p .691 .971 .924 r
F P
0 g
s
.53547 .57063 m .54312 .5613 L .53714 .55325 L p .907 .851 .776 r
F P
0 g
s
.53963 .54194 m .53714 .55325 L .54312 .5613 L p .983 .807 .588 r
F P
0 g
s
.53963 .54194 m .53763 .53256 L .52625 .52718 L p .843 .514 .431 r
F P
0 g
s
.69883 .54339 m .74429 .55049 L .74387 .54682 L p .197 .673 .935 r
F P
0 g
s
.74387 .54682 m .69793 .53966 L .69883 .54339 L p .197 .673 .935 r
F P
0 g
s
.53156 .60288 m .51563 .67563 L .52016 .66978 L p 0 0 .162 r
F P
0 g
s
.52016 .66978 m .53614 .59662 L .53156 .60288 L p 0 0 .162 r
F P
0 g
s
.50583 .54388 m .5084 .53256 L .49531 .53496 L p .474 .273 .527 r
F P
0 g
s
.49531 .53496 m .49273 .54623 L .50583 .54388 L p .474 .273 .527 r
F P
0 g
s
.50165 .56945 m .49977 .57225 L p .52141 .57261 L .508 .722 .969 r
F P
0 g
s
.01 w
.51261 .5712 m
.52215 .5287 L
s
.5 Mabswid
.52413 .57614 m .53547 .57063 L .53063 .56422 L p .799 .84 .883 r
F P
0 g
s
.53714 .55325 m .53063 .56422 L .53547 .57063 L p .907 .851 .776 r
F P
0 g
s
.5254 .53523 m .52625 .52718 L .51268 .52505 L p .675 .355 .424 r
F P
0 g
s
.51268 .52505 m .5084 .53256 L .5254 .53523 L p .675 .355 .424 r
F P
0 g
s
.52625 .52718 m .5254 .53523 L .53963 .54194 L p .843 .514 .431 r
F P
0 g
s
.53063 .56422 m .52141 .57261 L .52413 .57614 L p .799 .84 .883 r
F P
0 g
s
.56554 .59602 m .66815 .61248 L .66936 .61547 L p .131 .64 .899 r
F P
0 g
s
.50551 .55672 m .50583 .54388 L .49273 .54623 L p .511 .409 .675 r
F P
0 g
s
.49273 .54623 m .49499 .55855 L .50551 .55672 L p .511 .409 .675 r
F P
0 g
s
.53714 .55325 m .53963 .54194 L .5254 .53523 L p .827 .62 .622 r
F P
0 g
s
.57851 .52104 m .68077 .53698 L .67746 .54837 L p .644 .243 .269 r
F P
0 g
s
.67746 .54837 m .57426 .53221 L .57851 .52104 L p .644 .243 .269 r
F P
0 g
s
.4798 .58756 m .46304 .66034 L .46972 .66802 L p .978 .802 .598 r
F P
0 g
s
.46304 .66034 m .4798 .58756 L .48404 .58117 L p 0 0 .116 r
F P
0 g
s
.50749 .56846 m .50165 .56945 L p .52141 .57261 L .508 .722 .969 r
F P
0 g
s
.49499 .55855 m .50165 .56945 L .50749 .56846 L p .53 .521 .79 r
F P
0 g
s
.73202 .62553 m .6864 .6182 L .68538 .61525 L p .131 .64 .899 r
F P
0 g
s
.50749 .56846 m .50551 .55672 L .49499 .55855 L p .53 .521 .79 r
F P
0 g
s
.52141 .57261 m .51505 .56966 L .50749 .56846 L p .508 .722 .969 r
F P
0 g
s
.52141 .57261 m .53063 .56422 L .51916 .55889 L p .741 .708 .82 r
F P
0 g
s
.51916 .55889 m .51505 .56966 L .52141 .57261 L p .741 .708 .82 r
F P
0 g
s
.52286 .54657 m .5254 .53523 L .5084 .53256 L p .687 .477 .596 r
F P
0 g
s
.5084 .53256 m .50583 .54388 L .52286 .54657 L p .687 .477 .596 r
F P
0 g
s
.02 w
.51417 .52773 m
.51546 .53824 L
s
.51635 .54554 m
.51828 .56121 L
s
.51546 .53824 m
.51562 .53955 L
s
.5 Mabswid
.53063 .56422 m .53714 .55325 L .52286 .54657 L p .793 .671 .73 r
F P
0 g
s
.5254 .53523 m .52286 .54657 L .53714 .55325 L p .827 .62 .622 r
F P
0 g
s
.50551 .55672 m .50749 .56846 L .51505 .56966 L p .656 .611 .792 r
F P
0 g
s
.52286 .54657 m .51916 .55889 L .53063 .56422 L p .793 .671 .73 r
F P
0 g
s
.51505 .56966 m .51916 .55889 L .50551 .55672 L p .656 .611 .792 r
F P
0 g
s
.68538 .61525 m .73148 .62265 L .73202 .62553 L p .131 .64 .899 r
F P
0 g
s
.53614 .59662 m .52016 .66978 L .51374 .66203 L p .983 .807 .588 r
F P
0 g
s
.51374 .66203 m .52991 .58853 L .53614 .59662 L p .983 .807 .588 r
F P
0 g
s
.66815 .61248 m .56554 .59602 L .56617 .57894 L p .61 .671 .883 r
F P
0 g
s
.51916 .55889 m .52286 .54657 L .50583 .54388 L p .678 .548 .7 r
F P
0 g
s
.50583 .54388 m .50551 .55672 L .51916 .55889 L p .678 .548 .7 r
F P
0 g
s
.49759 .46939 m .50257 .50763 L .5203 .50538 L p .656 .824 .964 r
F P
0 g
s
.5203 .50538 m .51589 .46707 L .49759 .46939 L p .656 .824 .964 r
F P
0 g
s
.02 w
.50993 .49314 m
.51215 .51125 L
s
.5 Mabswid
.51589 .46707 m .5203 .50538 L .53588 .51282 L p .347 .575 .926 r
F P
0 g
s
.48395 .48076 m .48937 .51872 L .50257 .50763 L p .872 .951 .859 r
F P
0 g
s
.50257 .50763 m .49759 .46939 L .48395 .48076 L p .872 .951 .859 r
F P
0 g
s
.85872 .60765 m .86039 .59723 L .74367 .58721 L closepath p .702 .605 .746 r
F P
0 g
s
.85725 .61726 m .85872 .60765 L .74367 .58721 L closepath p .72 .509 .604 r
F P
0 g
s
.85655 .62245 m .85725 .61726 L .74367 .58721 L closepath p .703 .308 .296 r
F P
0 g
s
.85815 .6139 m .85689 .6212 L .74367 .58721 L closepath p .569 .628 .871 r
F P
0 g
s
.85985 .60335 m .85815 .6139 L .74367 .58721 L closepath p .639 .547 .734 r
F P
0 g
s
.86039 .59723 m .86165 .58993 L .74367 .58721 L closepath p .655 .708 .886 r
F P
0 g
s
.86133 .59364 m .85985 .60335 L .74367 .58721 L closepath p .653 .445 .59 r
F P
0 g
s
.86165 .58993 m .86201 .58853 L .74367 .58721 L closepath p .265 .744 .932 r
F P
0 g
s
.86201 .58853 m .86133 .59364 L .74367 .58721 L closepath p .59 .198 .269 r
F P
0 g
s
.85689 .6212 m .85655 .62245 L .74367 .58721 L closepath p .062 .559 .888 r
F P
0 g
s
.03 w
.54436 .55566 m
.74367 .58721 L
s
.5 Mabswid
.46722 .65436 m .48404 .58117 L .49754 .57891 L p .474 .273 .527 r
F P
0 g
s
.48404 .58117 m .46722 .65436 L .46304 .66034 L p 0 0 .116 r
F P
0 g
s
.69793 .53966 m .74387 .54682 L .74116 .55835 L p .644 .243 .269 r
F P
0 g
s
.74116 .55835 m .69479 .55109 L .69793 .53966 L p .644 .243 .269 r
F P
0 g
s
.53588 .51282 m .53197 .47467 L .51589 .46707 L p .347 .575 .926 r
F P
0 g
s
.53197 .47467 m .53588 .51282 L .54339 .52718 L p 0 0 .574 r
F P
0 g
s
.48015 .49692 m .48571 .5345 L .48937 .51872 L p .941 .849 .416 r
F P
0 g
s
.48937 .51872 m .48395 .48076 L .48015 .49692 L p .941 .849 .416 r
F P
0 g
s
.57426 .53221 m .67746 .54837 L .67317 .5708 L p .687 .476 .596 r
F P
0 g
s
.67317 .5708 m .56952 .55442 L .57426 .53221 L p .687 .476 .596 r
F P
0 g
s
.52991 .58853 m .51374 .66203 L .49868 .65537 L p .827 .62 .622 r
F P
0 g
s
.49868 .65537 m .51513 .58173 L .52991 .58853 L p .827 .62 .622 r
F P
0 g
s
.56617 .57894 m .6696 .59543 L .66815 .61248 L p .61 .671 .883 r
F P
0 g
s
.73148 .62265 m .68538 .61525 L .68696 .5982 L p .61 .671 .883 r
F P
0 g
s
.54339 .52718 m .53971 .48937 L .53197 .47467 L p 0 0 .574 r
F P
0 g
s
.53971 .48937 m .54339 .52718 L .5399 .54304 L p .918 .833 .377 r
F P
0 g
s
.48775 .51175 m .49309 .54898 L .48571 .5345 L p 0 0 .541 r
F P
0 g
s
.48571 .5345 m .48015 .49692 L .48775 .51175 L p 0 0 .541 r
F P
0 g
s
.6696 .59543 m .56617 .57894 L .56952 .55442 L p .67 .576 .741 r
F P
0 g
s
.48084 .65244 m .49754 .57891 L .51513 .58173 L p .687 .477 .596 r
F P
0 g
s
.49754 .57891 m .48084 .65244 L .46722 .65436 L p .474 .273 .527 r
F P
0 g
s
.51513 .58173 m .49868 .65537 L .48084 .65244 L p .687 .477 .596 r
F P
0 g
s
.01 w
.48198 .70774 m
.4939 .65459 L
s
.5 Mabswid
.68696 .5982 m .73342 .60561 L .73148 .62265 L p .61 .671 .883 r
F P
0 g
s
.56952 .55442 m .67317 .5708 L .6696 .59543 L p .67 .576 .741 r
F P
0 g
s
.5399 .54304 m .53609 .50561 L .53971 .48937 L p .918 .833 .377 r
F P
0 g
s
.53609 .50561 m .5399 .54304 L .52666 .5543 L p .872 .96 .857 r
F P
0 g
s
.50391 .51951 m .50874 .55658 L .49309 .54898 L p .324 .569 .928 r
F P
0 g
s
.49309 .54898 m .48775 .51175 L .50391 .51951 L p .324 .569 .928 r
F P
0 g
s
.69479 .55109 m .74116 .55835 L .73714 .5809 L p .687 .476 .596 r
F P
0 g
s
.73714 .5809 m .69057 .57355 L .69479 .55109 L p .687 .476 .596 r
F P
0 g
s
.52666 .5543 m .52241 .51716 L .53609 .50561 L p .872 .96 .857 r
F P
0 g
s
.52241 .51716 m .52666 .5543 L .50874 .55658 L p .65 .83 .969 r
F P
0 g
s
.50874 .55658 m .50391 .51951 L .52241 .51716 L p .65 .83 .969 r
F P
0 g
s
.02 w
.51215 .51125 m
.51302 .51835 L
s
.5 Mabswid
.6374 .53951 m .63623 .46991 L .59409 .48354 L p .729 .889 .953 r
F P
0 g
s
.59409 .48354 m .59767 .55249 L .6374 .53951 L p .729 .889 .953 r
F P
0 g
s
.73342 .60561 m .68696 .5982 L .69057 .57355 L p .67 .576 .741 r
F P
0 g
s
.69057 .57355 m .73714 .5809 L .73342 .60561 L p .67 .576 .741 r
F P
0 g
s
.73814 .55525 m .74538 .45404 L .69727 .46964 L p .725 .896 .957 r
F P
0 g
s
.69727 .46964 m .69395 .56977 L .73814 .55525 L p .725 .896 .957 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00VP3oool7000007l0oooo002J0?ooo`030000002YVLD0ZIW500@0ZIW51`00001h0?ooo`00
VP3oool00`000000ZIW50:VIa@0:0:VIa@030000003oool0oooo07H0oooo002J0?ooo`030000002Y
VLD0ZIW500X0ZIW500<000000?ooo`3oool0MP3oool009X0oooo00<000000:VIa@2YVLD02P2YVLD0
0`000000oooo0?ooo`1f0?ooo`00V@3oool00`000000ZIW50:VIa@0;0:VIa@030000003oool0oooo
07H0oooo002I0?ooo`030000002YVLD0ZIW500X0ZIW500<000000?ooo`3oool0M`3oool009T0oooo
00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1g0?ooo`00V@3oool00`000000ZIW50:VI
a@0:0:VIa@030000003oool0oooo07L0oooo002I0?ooo`030000002YVLD0ZIW500X0ZIW500<00000
0?ooo`3oool0M`3oool009T0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1g0?oo
o`00V@3oool00`000000ZIW50:VIa@0:0:VIa@030000003oool0oooo07L0oooo002I0?ooo`030000
002YVLD0ZIW500X0ZIW500<000000?ooo`3oool0M`3oool009T0oooo00<000000:VIa@2YVLD02P2Y
VLD00`000000oooo0?ooo`1g0?ooo`00V@3oool00`000000ZIW50:VIa@090:VIa@030000003oool0
oooo07P0oooo002H0?ooo`030000002YVLD0ZIW500X0ZIW500<000000?ooo`3oool0N03oool009P0
oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1h0?ooo`00V03oool00`000000ZIW5
0:VIa@0:0:VIa@030000003oool0oooo07P0oooo002H0?ooo`030000002YVLD0ZIW500X0ZIW500<0
00000?ooo`3oool0N03oool009P0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1h
0?ooo`00V03oool00`000000ZIW50:VIa@0:0:VIa@030000003oool0oooo07P0oooo002H0?ooo`03
0000002YVLD0ZIW500X0ZIW500<000000?ooo`3oool0N03oool009P0oooo00<000000:VIa@2YVLD0
2@2YVLD00`000000oooo0?ooo`1i0?ooo`00V03oool00`000000ZIW50:VIa@090:VIa@030000003o
ool0oooo07T0oooo002G0?ooo`030000002YVLD0ZIW500X0ZIW500<000000?ooo`3oool0N@3oool0
09L0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1i0?ooo`00U`3oool00`000000
ZIW50:VIa@0:0:VIa@030000003oool0oooo07T0oooo002G0?ooo`030000002YVLD0ZIW500X0ZIW5
00<000000?ooo`3oool0N@3oool009L0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?oo
o`1i0?ooo`00U`3oool00`000000ZIW50:VIa@0:0:VIa@030000003oool0oooo07T0oooo002G0?oo
o`030000002YVLD0ZIW500X0ZIW500<000000?ooo`3oool0N@3oool009L0oooo00<000000:VIa@2Y
VLD02@2YVLD00`000000oooo0?ooo`1j0?ooo`00U`3oool00`000000ZIW50:VIa@090:VIa@030000
003oool0oooo07X0oooo002G0?ooo`030000002YVLD0ZIW500T0ZIW500<000000?ooo`3oool0NP3o
ool009H0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1j0?ooo`00UP3oool00`00
0000ZIW50:VIa@0:0:VIa@030000003oool0oooo07X0oooo002F0?ooo`030000002YVLD0ZIW500X0
ZIW500<000000?ooo`3oool0NP3oool009H0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo
0?ooo`1j0?ooo`00UP3oool00`000000ZIW50:VIa@0:0:VIa@030000003oool0oooo07X0oooo002F
0?ooo`030000002YVLD0ZIW500T0ZIW500<000000?ooo`3oool0N`3oool009H0oooo00<000000:VI
a@2YVLD02@2YVLD00`000000oooo0?ooo`1k0?ooo`00UP3oool00`000000ZIW50:VIa@090:VIa@03
0000003oool0oooo07/0oooo002F0?ooo`030000002YVLD0ZIW500T0ZIW500<000000?ooo`3oool0
N`3oool009D0oooo00<000000:VIa@2YVLD02P2YVLD00`000000oooo0?ooo`1k0?ooo`00U@3oool0
0`000000ZIW50:VIa@0:0:VIa@030000003oool0oooo07/0oooo002E0?ooo`030000002YVLD0ZIW5
00X0ZIW500<000000?ooo`3oool0N`3oool009D0oooo00<000000:VIa@2YVLD02P2YVLD00`000000
oooo0?ooo`1k0?ooo`00U@3oool00`000000ZIW50:VIa@090:VIa@030000003oool0oooo07`0oooo
002E0?ooo`030000002YVLD0ZIW500T0ZIW500<000000?ooo`3oool0O03oool009D0oooo00<00000
0:VIa@2YVLD02@2YVLD00`000000oooo0?ooo`1l0?ooo`00U@3oool00`000000ZIW50:VIa@090:VI
a@030000003oool0oooo07`0oooo002E0?ooo`030000002YVLD0ZIW500T0ZIW500<000000?ooo`3o
ool0O03oool009D0oooo00<000000:VIa@2YVLD02@2YVLD00`000000oooo0?ooo`1l0?ooo`00U03o
ool00`000000ZIW50:VIa@0:0:VIa@H00000N@3oool009@0oooo00<000000:VIa@2YVLD02P2YVLD0
0`000000TaH>09<F3P0309<F3P<00000MP3oool009@0oooo00<000000:VIa@2YVLD02@2YVLD00`00
0000TaH>09<F3P0509<F3P030000003oool0oooo07D0oooo002D0?ooo`030000002YVLD0ZIW500T0
ZIW500<0000009<F3P2C5Ph01@2C5Ph00`000000oooo0?ooo`1e0?ooo`00U03oool4000000P0ZIW5
00<0000009<F3P2C5Ph0102C5Ph00`000000oooo0?ooo`1f0?ooo`00U03oool010000000NDF607U5
QP1iAHH600000080ZIW500<0000009<F3P2C5Ph0102C5Ph00`000000oooo0?ooo`1f0?ooo`00T`3o
ool200000080NDF600<000000:mjV02_NYP00`2_NYP5000000@0TaH>00<000000?ooo`3oool0M`3o
ool009<0oooo0P00000207U5QP030000002_NYP0[gZH0080[gZH00<000000=>NW`3CWYl00P3CWYl2
000000<0TaH>00<000000?ooo`3oool0M`3oool009<0oooo00D0000007U5QP1iAHH0NDF600000004
0:mjV0030000003CWYl0dijO0080dijO0P00000209<F3P030000003oool0oooo07P0oooo002B0?oo
o`8000000`1iAHH00`000000[gZH0:mjV0020:mjV0050000003CWYl0dijO0=>NW`0000000P3kcYH0
0`000000TaH>0000001j0?ooo`00TP3oool2000000<0NDF600<000000:mjV02_NYP00P2_NYP01@00
0000dijO0=>NW`3CWYl000000080nljF0P00001k0?ooo`00TP3oool200000080NDF600<000000:mj
V02_NYP00`2_NYP01@000000dijO0=>NW`3CWYl000000080nljF00<0TaH>0000003oool0;P3oool2
000004X0oooo002B0?ooo`8000000P1iAHH00`000000[gZH0:mjV0020:mjV0030000003CWYl0dijO
0080dijO00@000000?_>UP0000000000;@3oool3000000030;WUm0000000oooo04T0oooo002B0?oo
o`8000000P1iAHH00`000000[gZH0:mjV0020:mjV0030000003CWYl0dijO0080dijO00@000000?_>
UP0000000000:@3oool4000000@0^NGd00<000000?ooo`3oool0B03oool00940oooo0P00000307U5
QP030000002_NYP0[gZH0080[gZH00D000000=>NW`3CWYl0dijO000000020?_>UP030000003oool0
oooo02D0oooo0`0000080;WUm0030000003oool0oooo04P0oooo002>0?ooo`L0000000<0NDF60000
002_NYP00`2_NYP01P000000dijO0=>NW`3CWYl000000?_>UP8000004P3oool200000140oooo0P00
000;0;WUm0030000003oool0oooo04P0oooo002<0?ooo`<000001@2Wd_H3000000@0[gZH00L00000
0=>NW`3CWYl0dijO0000003kcYH000000100oooo0`0000000`2jho<000000?ooo`0@0?ooo`030000
002iiO@0^NGd00X0^NGd00<000000?ooo`3oool0B03oool008/0oooo00@000000=ocf`3Olm/00000
1@2Wd_H00`000000F9?]05RCk@02000000030:mjV0000000dijO00<0dijO00<000000?_>UP000000
3@3oool3000000@0^^?c00<000000?ooo`3oool03`3oool00`000000^NGd0;WUm00:0;WUm0030000
003oool0oooo04P0oooo002:0?ooo`030000003Olm/0go?K0080go?K00<000000:OBmP2Wd_H00P2W
d_H01`000000F9?]05RCk@1HTnd000000:mjV0000000103CWYl00`000000nljF0000000:0?ooo`<0
00001`2jho<00`000000oooo0?ooo`0?0?ooo`030000002iiO@0^NGd00X0^NGd00<000000?ooo`3o
ool0B03oool008X0oooo00<000000=ocf`3Olm/00P3Olm/00`000000Ym;f0:OBmP020:OBmP040000
001HTnd0F9?]05RCk@<000000`3CWYl00`000000nljF000000090?ooo`8000002P2jho<00`000000
oooo0?ooo`0?0?ooo`030000002iiO@0^NGd00T0^NGd00<000000?ooo`3oool0B@3oool008X0oooo
00<000000=ocf`3Olm/00P3Olm/6000000<0F9?]0`0000030=>NW`030000003kcYH0000000T0oooo
00<000000;[Sl`2jho<02@2jho<00`000000oooo0?ooo`0?0?ooo`030000002iiO@0^NGd00T0^NGd
00<000000?ooo`3oool0B@3oool008T0oooo00<000000?3IJP0000000`3Olm/700000080F9?]00<0
00000000TP0000000`3CWYl00`000000nljF000000090?ooo`030000002jho<0^^?c00T0^^?c00<0
00000?ooo`3oool03`3oool00`000000^NGd0;WUm0090;WUm0030000003oool0oooo04T0oooo0029
0?ooo`030000003`fFX0000000<0go?K1`00000205RCk@03000000000980000000<0dijO00<00000
0?_>UP0000002@3oool00`000000^^?c0;[Sl`090;[Sl`030000003oool0oooo00l0oooo00<00000
0;WUm02iiO@02@2iiO@00`000000oooo0?ooo`190?ooo`00R@3oool00`000000l=UZ000000030=oc
f`L000000`1HTnd2000000<0dijO0P00000:0?ooo`030000002jho<0^^?c00T0^^?c00<000000?oo
o`3oool03`3oool00`000000^NGd0;WUm0090;WUm0030000003oool0oooo04T0oooo00290?ooo`03
0000003`fFX0000000@0go?K1P00000305RCk@8000000P3CWYl00`000000nljF0000000:0?ooo`03
0000002jho<0^^?c00T0^^?c00<000000?ooo`3oool03`3oool00`000000^NGd0;WUm0090;WUm003
0000003oool0oooo04T0oooo00290?ooo`<00000103Olm/6000000<0F9?]0`000000103CWYl00000
0?_>UP00000:0?ooo`030000002jho<0^^?c00T0^^?c00<000000?ooo`3oool03`3oool00`000000
^NGd0;WUm0090;WUm0030000003oool0oooo04T0oooo002:0?ooo`8000000`3Olm/7000000<0F9?]
0P0000001@1kB8P000000000003kcYH0000000X0oooo00<000000;[Sl`2jho<02@2jho<00`000000
oooo0?ooo`0?0?ooo`030000002iiO@0^NGd00T0^NGd00<000000?ooo`3oool0B@3oool008X0oooo
0`0000000`3Olm/000000000000:000000030>_EH0000000NdR8008000002`3oool00`000000^^?c
0;[Sl`090;[Sl`030000003oool0oooo00l0oooo00<000000;WUm02iiO@02@2iiO@00`000000oooo
0?ooo`190?ooo`00K@3oool2000001/0oooo100000020?ooo`L000000P3OmM/010000000jmEP0000
001kB8P2000000/0oooo00<000000;[Sl`2jho<02@2jho<00`000000oooo0?ooo`0?0?ooo`030000
002iiO@0^NGd00T0^NGd00<000000?ooo`3oool0B@3oool006`0oooo0P0000000`2dDDl000000000
0002000001L0oooo0P00000205:Ak@P000000`3OmM/010000000jmEP0000001kB8P2000000/0oooo
00<000000;[Sl`2jho<02@2jho<00`000000oooo0?ooo`0?0?ooo`030000002iiO@0^NGd00T0^NGd
00<000000?ooo`3oool0B@3oool006`0oooo00<000000;R2V`0000000`000000102dDDl000000000
0000000D0?ooo`030000000008X0000000<0DY7]1`0000020=oef`030000003[eF00000000800000
203oool300000080oooo00<000000;[Sl`2jho<0202jho<00`000000oooo0?ooo`0>0?ooo`030000
002iiO@0^NGd00X0^NGd00<000000?ooo`3oool0B@3oool006/0oooo00<000000;R2V`2hPY/0102h
PY/800000100oooo00<000000000RP0000000`1BTNd00`000000Y]Ch00000003000000<0goGK00<0
00000>_EH00000002@3oool00`000000Y3i40:@nA0020:@nA08000002P2jho<00`000000oooo0?oo
o`0>0?ooo`030000002iiO@0^NGd00X0^NGd00<000000?ooo`3oool0B@3oool006/0oooo10000007
0;R2V`L000003P3oool2000000<0DY7]00<000000:KDn00000000`2Ve?P010000000goGK0=oef`3O
mM/2000000T0oooo00<000000:@nA02T?T@00`2T?T@00`000000^^?c0;[Sl`080;[Sl`030000003o
ool0oooo00h0oooo00<000000;WUm02iiO@02P2iiO@00`000000oooo0?ooo`190?ooo`00J`3oool0
10000000/iZn0;>J_P2cV[h6000000D0^8:K1P00000;0?ooo`800000101BTNd00`000000Y]Ch0:KD
n0020:KDn0040000003OmM/0goGK0=oef`800000203oool3000000@0Y3i400<000000;[Sl`2jho<0
202jho<5000000`0oooo00<000000;WUm02iiO@02@2iiO@00`000000oooo0?ooo`1:0?ooo`00J`3o
ool00`000000/iZn0;>J_P070;>J_PL000000P2hPY/6000000@0oooo1@00000405:Ak@030000002V
e?P0Y]Ch0080Y]Ch00@000000=oef`3OmM/0goGK0P0000080?ooo`030000002_NIP0[gVH00D00000
2P2jho<00`000000Y3i40:@nA0020:@nA0H000001P3oool00`000000^NGd0;WUm0090;WUm0030000
003oool0oooo04X0oooo001[0?ooo`T00000202cV[h;000000030?ooo`000000000000<00000101B
TNd00`000000Y]Ch0:KDn0020:KDn0040000003OmM/0goGK0=oef`800000203oool00`000000[gVH
0:miV0040:miV0030000002jho<0^^?c00L0^^?c0P00000:0:@nA0<000000`3oool00`000000^NGd
0;WUm0090;WUm0030000003oool0oooo04X0oooo001[0?ooo`030000002X]>80Z;CR00H0Z;CR6P00
000305:Ak@030000002Ve?P0Y]Ch0080Y]Ch00@000000=oef`3OmM/0goGK0`0000070?ooo`030000
002_NIP0[gVH00@0[gVH00<000000;[Sl`2jho<0102jho<7000000X0Y3i400D000000?ooo`3oool0
oooo0000000;0;WUm0030000003oool0oooo04X0oooo001[0?ooob<000000`1BTNd00`000000Y]Ch
0:KDn0020:KDn0030000003OmM/0goGK00/000001`2_NIP00`000000^^?c0;[Sl`020;[Sl`800000
1`2_NIP6000000<0Y3i40P0000030?ooo`030000002iiO@0^NGd00T0^NGd0`00001:0?ooo`00R03o
ool7000000<0DY7]00<000000:KDn02Ve?P00P2Ve?P00`000000goGK0000000:000000L0[gVH00<0
00000;[Sl`0000000P00000?0:miV0D000000`3oool00`000000^NGd0;WUm0090;WUm0030000002T
?T@0000004X0oooo00280?ooo`H0000000D0PVR/000000000000DY7]000000040:KDn0d000001`2_
NIP2000001D0[gVH0P0000030?ooo`030000002iiO@0^NGd00T0^NGd00<000000:@nA0000000BP3o
ool008P0oooo1`0000000`22J:`000000000000E000001/0[gVH0P0000030?ooo`030000002iiO@0
^NGd00P0^NGd1000001:0?ooo`00R03oool80000000308N5bP000000Yic:00<000000P3;ZkX<0000
00<0Zi>m2000000C0:miV08000000`3oool00`000000^NGd0;WUm0050;WUm0L00000BP3oool008P0
oooo1`00000208N5bP030000002WW<X0Yic:010000002`2[Tkd7000000/0[gVH0`0000030?ooo`03
0000002iiO@0^NGd0080^NGd0`0000050:miV0800000BP3oool008d0oooo0`0000000`27QLX00000
0:NLbP0A00000180Zi>m200000030:miV0L0000000@0^NGd0000000000000000202_NIP2000004X0
oooo002>0?ooo`T000000P3<en800`000000F9?]00000007000001/0Zi>m2`00000;0:miV0800000
BP3oool008d0oooo0`00000308:hn0<0000000P0c=OR000000000000000005RCk@000000002B0000
00@0oooo00<000000:^C_@2[Tkd0702[Tkd9000000T0[gVH0`00001:0?ooo`00S@3oool00`000000
l=UZ00000003000000<0P[Sh0`00000205RCk@03000000000980000000@0oooo00<000000:^C_@2[
Tkd0702[Tkd6000000<0Zi>m1P0000030:miV0L00000AP3oool008X0oooo3P00000305RCk@030000
00000980000000@0oooo1000000K0:^C_@H000002@2[Tkd:000004H0oooo002:0?ooo`050000001i
AHH0NDF607U5QP000000102_NYP00`000000dijO00000002000000@0F9?]0P0000040?ooo`040000
002LZn80W:_R09b[hPP000004P2[Tkd7000000`0Zi>m1`0000160?ooo`00R@3oool2000000<0NDF6
00<000000:mjV02_NYP00P2_NYP010000000dijO0=>NW`3CWYl2000000<0F9?]0P0000040?ooo`03
0000002LZn80W:_R00T0W:_R1`00000;0:^C_@H000003@2[TkdU000002P0oooo00290?ooo`050000
001iAHH0NDF607U5QP000000102_NYP00`000000dijO0=>NW`030=>NW`030000001HTnd0000000<0
0000103oool00`000000W:_R09b[hP0@09b[hPP000000`2[Tkd00`000000/7ZI00000003000000d0
Zi>m7000000809LbA0030000003oool0oooo02H0oooo00290?ooo`050000001iAHH0NDF607U5QP00
0000102_NYP00`000000dijO0=>NW`030=>NW`8000000P3OmM/2000000@0oooo00<0000009b[hP2L
Zn80602LZn85000000<0oooo00<000000:^C_@2[Tkd02P2[Tkd7000000030?ooo`000000000000X0
00002@2WLIL9000002P0oooo00280?ooo`8000000`1iAHH00`000000[gZH0:mjV0020:mjV0030000
003CWYl0dijO0080dijO00<000000?_>UP0000000P3OmM/00`000000jmEP000000030?ooo`@00000
6P2LZn82000000<0oooo100000090:^C_@L00000103oool700000080Xhbk1`00000:0:MaU`030000
003oool0oooo02H0oooo00280?ooo`8000000`1iAHH00`000000[gZH0:mjV0020:mjV0030000003C
WYl0dijO0080dijO00<000000?_>UP0000000P3OmM/00`000000jmEP000000060?ooo`P000004`2L
Zn82000000<0oooo00@0000009b[hP2LZn80W:_R1P0000030:^C_@80000000<0oooo000000000000
0P0000080?ooo`L000001@2SS;/6000000<0Yg6G00<000000?ooo`3oool09`3oool008P0oooo0P00
000307U5QP030000002_NYP0[gZH0080[gZH00<000000=>NW`3CWYl00P3CWYl00`000000nljF0000
00020=oef`030000003[eF00000000`0oooo2P00000:09b[hP030000002W@d`0000000<0oooo00<0
000009b[hP2LZn801`2LZn8500000100oooo0`0000000`2AX=h0000000000002000000L0Xhbk1000
000Y0?ooo`00R03oool01@000000NDF607U5QP1iAHH0000000D0[gZH00<000000=>NW`3CWYl00P3C
WYl2000000<0goGK00<000000>_EH00000003@3oool00`000000^^?c0;[Sl`020;[Sl`<0000000<0
8J?V0000000000001@00000309b[hP030000002W@d`000000080oooo00<0000009b[hP2LZn802`2L
Zn82000001<0oooo0`000002096PgP@000001P2SS;/00`000000oooo0?ooo`0W0?ooo`00Q`3oool2
000000<0NDF600<000000:mjV02_NYP00P2_NYP00`000000dijO0=>NW`020=>NW`040000003kcYH0
0000000000<0goGK0P00000=0?ooo`030000002jho<0^^?c00P0^^?c0`000002026SiPD000000`3o
ool00`000000W:_R09b[hP0;09b[hP8000005P3oool3000000<0TJ3N100000020:><^`030000003o
ool0oooo02L0oooo00270?ooo`8000000`1iAHH00`000000[gZH0:mjV0020:mjV0030000003CWYl0
dijO0080dijO00@000000?_>UP00000000000`3OmM/2000000d0oooo00<000000;[Sl`2jho<0202j
ho<00`000000oooo0?ooo`030?ooo`@000000`3oool4000000T0W:_R0P00000J0?ooo`@000000`2A
X=h3000002T0oooo00270?ooo`8000000`1iAHH00`000000[gZH0:mjV0020:mjV0030000003CWYl0
dijO0080dijO00@000000?_>UP00000000000`3OmM/2000000d0oooo00<000000;[Sl`2jho<0202j
ho<00`000000oooo0?ooo`0:0?ooo`X000000`2LZn82000001h0oooo0`000002096PgP030000003o
ool0oooo02L0oooo00270?ooo`0300007@000000NDF60080NDF600<000000:mjV02_NYP00P2_NYP0
0`000000dijO0=>NW`020=>NW`040000003kcYH00000000000<0goGK0P00000=0?ooo`030000002j
ho<0^^?c00P0^^?c00<000000?ooo`3oool0303oool00`000000^NGd0000000:00000240oooo0P00
000Z0?ooo`00QP3oool00`000000000M0000000307U5QP030000002_NYP0[gZH0080[gZH00T00000
0=>NW`3CWYl0dijO0000003kcYH000000:KDn00000000`3OmM/2000000d0oooo00<000000;[Sl`2j
ho<0202jho<00`000000oooo0?ooo`0<0?ooo`030000002iiO@0^NGd00H0^NGd1000001=0?ooo`00
QP3oool2000000<0NDF600<000000:mjV02_NYP00P2_NYP00`000000dijO0=>NW`020=>NW`050000
003kcYH000000:KDn00000000`3OmM/00`000000oooo0?ooo`0<0?ooo`030000002jho<0^^?c00P0
^^?c00<000000?ooo`3oool0303oool00`000000^NGd0;WUm0090;WUm0030000003oool0oooo04/0
oooo00260?ooo`8000000`1iAHH00`000000[gZH0:mjV0020:mjV0030000003CWYl0dijO0080dijO
00<000000?_>UP0000000P2Ve?P010000000goGK0=oef`00000>0?ooo`030000002jho<0^^?c00P0
^^?c00<000000?ooo`3oool0303oool00`000000^NGd0;WUm0090;WUm0030000003oool0oooo04/0
oooo00260?ooo`0300007@000000NDF60080NDF600<000000:mjV02_NYP00P2_NYP00`000000dijO
0=>NW`020=>NW`030000003kcYH000000080Y]Ch00<000000=oef`0000003`3oool00`000000^^?c
0;[Sl`080;[Sl`030000003oool0oooo00`0oooo00<000000;WUm02iiO@02@2iiO@00`000000oooo
0?ooo`1;0?ooo`00Q@3oool00`000000000M0000000307U5QP030000002_NYP0[gZH0080[gZH00D0
00000=>NW`3CWYl0dijO000000020?_>UP030000002Ve?P0Y]Ch00800000403oool00`000000^^?c
0;[Sl`070;[Sl`8000003P3oool00`000000^NGd0;WUm0090;WUm0030000003oool0oooo04/0oooo
00250?ooo`030000000001d0000000<0NDF600<000000:mjV02_NYP00P2_NYP01@000000dijO0=>N
W`3CWYl000000080nljF1000000A0?ooo`030000002jho<0^^?c00<0^^?c1000000@0?ooo`030000
002iiO@0^NGd00T0^NGd00<000000?ooo`3oool0B`3oool008D0oooo0P00000307U5QP030000002_
NYP0[gZH00<0[gZH00H000000=>NW`3CWYl0dijO0000003kcYH2000001@0oooo00<000000;[Sl`00
00000`00000D0?ooo`030000002iiO@0^NGd00T0^NGd00<000000?ooo`3oool0B`3oool008D0oooo
00<0000M0000001iAHH00P1iAHH01P000000[gZH0:mjV0000000[gZH000000@0dijO00<000000?_>
UP0000005@3oool2000001P0oooo00<000000;WUm02iiO@02@2iiO@00`000000oooo0?ooo`1;0?oo
o`00Q03oool00`000000000M00000009000000<0dijO00@000000?_>UP3kcYH00000;`3oool00`00
0000^NGd0;WUm0090;WUm0030000003oool0oooo04/0oooo00240?ooo`80000000<0n/fI0000003B
WYl00`3BWYl500000080dijO00@000000?_>UP3kcYH00000;`3oool00`000000^NGd0;WUm0080;WU
m0030000003oool0oooo04`0oooo00240?ooo`030000003jcIT0n/fI00D0dYjO0P0000030;1jV@<0
00000P3kcYH00`000000oooo0?ooo`0]0?ooo`030000002iiO@0^NGd00P0^NGd00<000000?ooo`3o
ool0C03oool008D0oooo00<000000?[=V@3BWYl0103BWYl2000000<0/7ZI00<0000007]8R01kB8P0
0P00000`0?ooo`030000002iiO@0^NGd00P0^NGd00<000000?ooo`3oool0C03oool008H0oooo0P00
00030=:NW`<000000`2`NYT00`000000NdR807]8R00200000300oooo00<000000;WUm02iiO@0202i
iO@00`000000oooo0?ooo`1<0?ooo`00R03oool2000000040=:NW`000000000000000080/7ZI00<0
000007]8R01kB8P00`00000`0?ooo`030000002iiO@0^NGd00P0^NGd00<000000?ooo`3oool0C03o
ool008X0oooo100000020;1jV@040000001kB8P0000000000380oooo00<000000;WUm02iiO@01`2i
iO@2000004h0oooo002;0?ooo`80000000<0oooo0000000000000P00000d0?ooo`030000002iiO@0
^NGd00@0^NGd0`00001@0?ooo`00R`3oool2000003T0oooo00<000000;WUm02iiO@00P2iiO@20000
05<0oooo002;0?ooo`800000>@3oool00`000000^NGd00000002000005D0oooo002;0?ooo`800000
>@3oool2000005P0oooo002:0?ooo`800000U03oool008X0oooo0P00002D0?ooo`00RP3oool20000
09@0oooo002:0?ooo`800000U03oool008X0oooo0P00002D0?ooo`00R@3oool3000009@0oooo002:
0?ooo`030000003oool0oooo09<0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52446 .70624 m .64233 .64099 L p .62037 .64269 L .58 .936 .93 r
F P
0 g
s
.63228 .64054 m .62037 .64269 L p .64233 .64099 L .58 .936 .93 r
F P
0 g
s
.65522 .65518 m .62411 .64017 L p .63212 .65092 L .744 .229 0 r
F P
0 g
s
.62411 .64017 m .62308 .63967 L .62346 .64014 L p .744 .229 0 r
F P
0 g
s
.62346 .64014 m .63212 .65092 L p .62411 .64017 L .744 .229 0 r
F P
0 g
s
.64233 .64099 m .64842 .63762 L .63228 .64054 L p .58 .936 .93 r
F P
0 g
s
.62037 .64269 m .4963 .71192 L .52446 .70624 L p .58 .936 .93 r
F P
0 g
s
.43889 .42871 m .51657 .48061 L .49736 .47074 L p .46 0 0 r
F P
0 g
s
.52887 .46526 m .51195 .46403 L p .51559 .48112 L .711 .472 .562 r
F P
0 g
s
.5258 .52909 m .52778 .48807 L p .51559 .48112 L .711 .472 .562 r
F P
0 g
s
.52778 .48807 m .52887 .46526 L p .51559 .48112 L .711 .472 .562 r
F P
0 g
s
.49736 .47074 m .4826 .46316 L p .47882 .46018 L .46 0 0 r
F P
0 g
s
.47882 .46018 m .43889 .42871 L .49736 .47074 L .46 0 0 r
F
.4826 .46316 m .40652 .41197 L .43889 .42871 L p F P
0 g
s
.48959 .65623 m .57272 .60763 L p .55018 .6095 L .603 .94 .943 r
F P
0 g
s
.56531 .60708 m .55018 .6095 L p .57272 .60763 L .603 .94 .943 r
F P
0 g
s
.55018 .6095 m .46293 .66094 L .48959 .65623 L p .603 .94 .943 r
F P
0 g
s
.61087 .63378 m .55374 .60622 L p .54419 .60868 L .744 .229 0 r
F P
0 g
s
.55374 .60622 m .53567 .5975 L .54163 .60532 L p .744 .229 0 r
F P
0 g
s
.54163 .60532 m .54419 .60868 L p .55374 .60622 L .744 .229 0 r
F P
0 g
s
.57272 .60763 m .5768 .60525 L .56531 .60708 L p .603 .94 .943 r
F P
0 g
s
.75458 .66418 m .76113 .65815 L .68389 .63362 L closepath p .748 .794 .89 r
F P
0 g
s
.75063 .67311 m .75458 .66418 L .68389 .63362 L closepath p .846 .739 .745 r
F P
0 g
s
.75076 .68159 m .75063 .67311 L .68389 .63362 L closepath p .903 .642 .533 r
F P
0 g
s
.76113 .65815 m .76781 .65731 L .68389 .63362 L closepath p .368 .748 .989 r
F P
0 g
s
.75495 .68638 m .75076 .68159 L .68389 .63362 L closepath p .694 .161 0 r
F P
0 g
s
.76781 .65731 m .77207 .66204 L .68389 .63362 L closepath p .728 .235 .069 r
F P
0 g
s
.76163 .68564 m .75495 .68638 L .68389 .63362 L closepath p .438 .658 .953 r
F P
0 g
s
.77207 .66204 m .77225 .67056 L .68389 .63362 L closepath p .825 .573 .559 r
F P
0 g
s
.76826 .67959 m .76163 .68564 L .68389 .63362 L closepath p .702 .7 .845 r
F P
0 g
s
.77225 .67056 m .76826 .67959 L .68389 .63362 L closepath p .786 .662 .727 r
F P
0 g
s
.63303 .59821 m .66488 .61401 L .68005 .59942 L p .725 .741 .864 r
F P
0 g
s
.62348 .61959 m .65544 .6352 L .66488 .61401 L p .813 .696 .736 r
F P
0 g
s
.66488 .61401 m .63303 .59821 L .62348 .61959 L p .813 .696 .736 r
F P
0 g
s
.03 w
.66393 .62378 m
.68389 .63362 L
s
.5 Mabswid
.62308 .63967 m .65522 .65518 L .65544 .6352 L p .86 .606 .554 r
F P
0 g
s
.65544 .6352 m .62348 .61959 L .62308 .63967 L p .86 .606 .554 r
F P
0 g
s
.68005 .59942 m .64821 .5834 L .63303 .59821 L p .725 .741 .864 r
F P
0 g
s
.64821 .5834 m .68005 .59942 L .69537 .59695 L p .429 .709 .982 r
F P
0 g
s
.48252 .55031 m .41433 .59355 L .42653 .60377 L p .595 .645 .87 r
F P
0 g
s
.42653 .60377 m .49494 .56095 L .48252 .55031 L p .595 .645 .87 r
F P
0 g
s
.49494 .56095 m .42653 .60377 L .4334 .61882 L p .51 .457 .733 r
F P
0 g
s
.63212 .65092 m .66444 .66644 L .65522 .65518 L p .744 .229 0 r
F P
0 g
s
.4334 .61882 m .5021 .57644 L .49494 .56095 L p .51 .457 .733 r
F P
0 g
s
.5021 .57644 m .4334 .61882 L .43237 .63309 L p .364 .187 .503 r
F P
0 g
s
.46947 .54854 m .40135 .59204 L .41433 .59355 L p .658 .872 .979 r
F P
0 g
s
.41433 .59355 m .48252 .55031 L .46947 .54854 L p .658 .872 .979 r
F P
0 g
s
.43237 .63309 m .50132 .59099 L .5021 .57644 L p .364 .187 .503 r
F P
0 g
s
.50132 .59099 m .43237 .63309 L .42373 .64118 L p 0 0 0 r
F P
0 g
s
.69537 .59695 m .66341 .58078 L .64821 .5834 L p .429 .709 .982 r
F P
0 g
s
.66341 .58078 m .69537 .59695 L .70499 .6078 L p .718 .187 0 r
F P
0 g
s
.46074 .55643 m .39252 .59992 L .40135 .59204 L p 0 0 0 r
F P
0 g
s
.40135 .59204 m .46947 .54854 L .46074 .55643 L p 0 0 0 r
F P
0 g
s
.54643 .55522 m .62093 .5922 L .63611 .57731 L p .725 .741 .864 r
F P
0 g
s
.53658 .57714 m .61134 .61366 L .62093 .5922 L p .813 .696 .736 r
F P
0 g
s
.62093 .5922 m .54643 .55522 L .53658 .57714 L p .813 .696 .736 r
F P
0 g
s
.53567 .5975 m .61087 .63378 L .61134 .61366 L p .86 .606 .554 r
F P
0 g
s
.61134 .61366 m .53658 .57714 L .53567 .5975 L p .86 .606 .554 r
F P
0 g
s
.64735 .64882 m .67978 .66449 L .66444 .66644 L p .398 .705 .984 r
F P
0 g
s
.66444 .66644 m .63212 .65092 L .64735 .64882 L p .398 .705 .984 r
F P
0 g
s
.42373 .64118 m .49279 .5991 L .50132 .59099 L p 0 0 0 r
F P
0 g
s
.49279 .5991 m .42373 .64118 L .41069 .63989 L p .648 .878 .983 r
F P
0 g
s
.63611 .57731 m .56159 .53983 L .54643 .55522 L p .725 .741 .864 r
F P
0 g
s
.56159 .53983 m .63611 .57731 L .65127 .57463 L p .429 .709 .982 r
F P
0 g
s
.45977 .57107 m .39131 .61428 L .39252 .59992 L p .349 .171 .493 r
F P
0 g
s
.39252 .59992 m .46074 .55643 L .45977 .57107 L p .349 .171 .493 r
F P
0 g
s
.54419 .60868 m .61984 .64502 L .61087 .63378 L p .744 .229 0 r
F P
0 g
s
.67286 .59159 m .66341 .58078 L p .70425 .60731 L .718 .187 0 r
F P
0 g
s
.70399 .60729 m .67286 .59159 L p .70425 .60731 L .718 .187 0 r
F P
0 g
s
.67286 .59159 m .70499 .6078 L .70505 .62803 L p .865 .606 .545 r
F P
0 g
s
.826 .52795 m .6865 .6058 L p .70797 .60465 L .58 .936 .93 r
F P
0 g
s
.70505 .62803 m .67274 .61194 L .67286 .59159 L p .865 .606 .545 r
F P
0 g
s
.6865 .6058 m .68005 .60939 L .6963 .60663 L p .58 .936 .93 r
F P
0 g
s
.6963 .60663 m .70797 .60465 L p .6865 .6058 L .58 .936 .93 r
F P
0 g
s
.70499 .6078 m .70399 .60729 L p .70425 .60731 L .718 .187 0 r
F P
0 g
s
.41069 .63989 m .47968 .59755 L .49279 .5991 L p .648 .878 .983 r
F P
0 g
s
.47968 .59755 m .41069 .63989 L .39826 .6296 L p .591 .646 .874 r
F P
0 g
s
.46702 .58683 m .39826 .6296 L .39131 .61428 L p .504 .453 .733 r
F P
0 g
s
.02 w
.37979 .63699 m
.3968 .62638 L
s
.5 Mabswid
.39131 .61428 m .45977 .57107 L .46702 .58683 L p .504 .453 .733 r
F P
0 g
s
.66295 .63391 m .69538 .6498 L .67978 .66449 L p .724 .747 .87 r
F P
0 g
s
.67978 .66449 m .64735 .64882 L .66295 .63391 L p .724 .747 .87 r
F P
0 g
s
.52887 .46526 m .5258 .52909 L .5405 .52445 L p .526 .318 .54 r
F P
0 g
s
.5405 .52445 m .54332 .46049 L .52887 .46526 L p .526 .318 .54 r
F P
0 g
s
.50856 .52784 m .51195 .46403 L .49885 .45724 L p .861 .606 .552 r
F P
0 g
s
.51195 .46403 m .50856 .52784 L .5258 .52909 L p .711 .472 .562 r
F P
0 g
s
.39826 .6296 m .46702 .58683 L .47968 .59755 L p .591 .646 .874 r
F P
0 g
s
.70797 .60465 m .85347 .52411 L .826 .52795 L p .58 .936 .93 r
F P
0 g
s
.73837 .51079 m .71201 .51409 L p .67726 .54016 L .603 .94 .943 r
F P
0 g
s
.57648 .53677 m .56159 .53983 L p .65044 .5743 L .429 .709 .982 r
F P
0 g
s
.65049 .57423 m .57648 .53677 L p .65044 .5743 L .429 .709 .982 r
F P
0 g
s
.65127 .57463 m .65049 .57423 L p .65044 .5743 L .429 .709 .982 r
F P
0 g
s
.65127 .57463 m .66065 .58543 L p .639 .57291 L .718 .187 0 r
F P
0 g
s
.57648 .53677 m .65049 .57423 L p .639 .57291 L .718 .187 0 r
F P
0 g
s
.65049 .57423 m .65127 .57463 L p .639 .57291 L .718 .187 0 r
F P
0 g
s
.66065 .58543 m .58541 .54748 L .57648 .53677 L p .718 .187 0 r
F P
0 g
s
.58541 .54748 m .66065 .58543 L .66045 .60582 L p .865 .606 .545 r
F P
0 g
s
.71201 .51409 m .6166 .57034 L p .63884 .56898 L .603 .94 .943 r
F P
0 g
s
.66045 .60582 m .58477 .56811 L .58541 .54748 L p .865 .606 .545 r
F P
0 g
s
.6166 .57034 m .61228 .57289 L .62391 .57118 L p .603 .94 .943 r
F P
0 g
s
.62391 .57118 m .63884 .56898 L p .6166 .57034 L .603 .94 .943 r
F P
0 g
s
.63884 .56898 m .66802 .55192 L p .67726 .54016 L .603 .94 .943 r
F P
0 g
s
.66802 .55192 m .73837 .51079 L p .67726 .54016 L .603 .94 .943 r
F P
0 g
s
.54332 .46049 m .5405 .52445 L .54712 .51563 L p .046 0 .395 r
F P
0 g
s
.54712 .51563 m .54983 .45146 L .54332 .46049 L p .046 0 .395 r
F P
0 g
s
.67274 .61194 m .70505 .62803 L .69538 .6498 L p .816 .7 .737 r
F P
0 g
s
.4952 .52118 m .49885 .45724 L .49454 .44741 L p .993 .765 .395 r
F P
0 g
s
.49885 .45724 m .4952 .52118 L .50856 .52784 L p .861 .606 .552 r
F P
0 g
s
.69538 .6498 m .66295 .63391 L .67274 .61194 L p .816 .7 .737 r
F P
0 g
s
.55908 .60617 m .63502 .64286 L .61984 .64502 L p .398 .705 .984 r
F P
0 g
s
.61984 .64502 m .54419 .60868 L .55908 .60617 L p .398 .705 .984 r
F P
0 g
s
.54983 .45146 m .54712 .51563 L .543 .50591 L p .987 .758 .365 r
F P
0 g
s
.62587 .25383 m .53687 .41555 L p .5614 .45123 L .796 .709 .769 r
F P
0 g
s
.52958 .49906 m .53264 .43457 L .54581 .44154 L p .864 .606 .546 r
F P
0 g
s
.53264 .43457 m .52958 .49906 L .512 .49778 L p .71 .469 .558 r
F P
0 g
s
.512 .49778 m .51539 .4333 L .53264 .43457 L p .71 .469 .558 r
F P
0 g
s
.53687 .41555 m .5272 .43313 L .54206 .441 L p .796 .709 .769 r
F P
0 g
s
.54581 .44154 m .54983 .45146 L p .54768 .46859 L .987 .758 .365 r
F P
0 g
s
.54517 .45625 m .54581 .44154 L p .54768 .46859 L .987 .758 .365 r
F P
0 g
s
.54581 .44154 m .543 .50591 L .52958 .49906 L p .864 .606 .546 r
F P
0 g
s
.54206 .441 m .5614 .45123 L p .53687 .41555 L .796 .709 .769 r
F P
0 g
s
.543 .50591 m .54517 .45625 L p .54768 .46859 L .987 .758 .365 r
F P
0 g
s
.49454 .44741 m .49079 .51155 L .4952 .52118 L p .993 .765 .395 r
F P
0 g
s
.49079 .51155 m .49454 .44741 L .50081 .43824 L p .006 0 .37 r
F P
0 g
s
.57466 .59065 m .65062 .62787 L .63502 .64286 L p .724 .747 .87 r
F P
0 g
s
.63502 .64286 m .55908 .60617 L .57466 .59065 L p .724 .747 .87 r
F P
0 g
s
.03 w
.5942 .58938 m
.66393 .62378 L
s
.5 Mabswid
.49716 .50259 m .50081 .43824 L .51539 .4333 L p .52 .309 .534 r
F P
0 g
s
.50081 .43824 m .49716 .50259 L .49079 .51155 L p .006 0 .37 r
F P
0 g
s
.5614 .45123 m .6593 .27385 L .62587 .25383 L p .796 .709 .769 r
F P
0 g
s
.58477 .56811 m .66045 .60582 L .65062 .62787 L p .816 .7 .737 r
F P
0 g
s
.65062 .62787 m .57466 .59065 L .58477 .56811 L p .816 .7 .737 r
F P
0 g
s
.51539 .4333 m .512 .49778 L .49716 .50259 L p .52 .309 .534 r
F P
0 g
s
.5071 .55977 m .50961 .5476 L .52321 .54858 L p .715 .559 .675 r
F P
0 g
s
.01 w
.51972 .49855 m
.51973 .49835 L
s
.5 Mabswid
.52321 .54858 m .52407 .56098 L .5071 .55977 L p .715 .559 .675 r
F P
0 g
s
.52114 .53671 m .52321 .54858 L .50961 .5476 L p .707 .628 .767 r
F P
0 g
s
.01 w
.51855 .52185 m
.51972 .49855 L
s
.5 Mabswid
.52407 .56098 m .52321 .54858 L .53479 .54498 L p .578 .455 .675 r
F P
0 g
s
.52321 .54858 m .52114 .53671 L .52756 .53469 L p .61 .561 .775 r
F P
0 g
s
.52756 .53469 m .53479 .54498 L .52321 .54858 L p .61 .561 .775 r
F P
0 g
s
.49395 .55333 m .49909 .54241 L .50961 .5476 L p .832 .676 .69 r
F P
0 g
s
.50961 .5476 m .5071 .55977 L .49395 .55333 L p .832 .676 .69 r
F P
0 g
s
.51358 .53616 m .50961 .5476 L .49909 .54241 L p .786 .717 .787 r
F P
0 g
s
.50961 .5476 m .51358 .53616 L .52114 .53671 L p .707 .628 .767 r
F P
0 g
s
.50654 .57032 m .5071 .55977 L .52407 .56098 L p .711 .472 .562 r
F P
0 g
s
.52407 .56098 m .52356 .57154 L .50654 .57032 L p .711 .472 .562 r
F P
0 g
s
.52356 .57154 m .52407 .56098 L .53853 .55653 L p .526 .318 .54 r
F P
0 g
s
.53479 .54498 m .53853 .55653 L .52407 .56098 L p .578 .455 .675 r
F P
0 g
s
.49335 .56391 m .49395 .55333 L .5071 .55977 L p .861 .606 .552 r
F P
0 g
s
.5071 .55977 m .50654 .57032 L .49335 .56391 L p .861 .606 .552 r
F P
0 g
s
.02 w
.4655 .58352 m
.49536 .56488 L
s
.5 Mabswid
.52756 .53469 m .52114 .53671 L .51358 .53616 L p .632 .749 .932 r
F P
0 g
s
.51358 .53616 m .50775 .53326 L p .52756 .53469 L .632 .749 .932 r
F P
0 g
s
.49909 .54241 m .50775 .53326 L .51358 .53616 L p .786 .717 .787 r
F P
0 g
s
.53853 .55653 m .53479 .54498 L .53997 .53813 L p .311 .294 .678 r
F P
0 g
s
.53479 .54498 m .52756 .53469 L .53042 .53087 L p .462 .503 .815 r
F P
0 g
s
.53042 .53087 m .53997 .53813 L .53479 .54498 L p .462 .503 .815 r
F P
0 g
s
.52858 .52669 m .53042 .53087 L .52756 .53469 L p .632 .749 .932 r
F P
0 g
s
.52274 .52375 m .52858 .52669 L p .52756 .53469 L .632 .749 .932 r
F P
0 g
s
.51512 .5232 m .52274 .52375 L p .52756 .53469 L .632 .749 .932 r
F P
0 g
s
.50867 .52525 m .51512 .5232 L p .52756 .53469 L .632 .749 .932 r
F P
0 g
s
.01 w
.51847 .52344 m
.51855 .52185 L
s
.5 Mabswid
.50586 .5291 m .50867 .52525 L p .52756 .53469 L .632 .749 .932 r
F P
0 g
s
.50775 .53326 m .50586 .5291 L p .52756 .53469 L .632 .749 .932 r
F P
0 g
s
.48961 .54405 m .49564 .53494 L .49909 .54241 L p .954 .863 .71 r
F P
0 g
s
.49909 .54241 m .49395 .55333 L .48961 .54405 L p .954 .863 .71 r
F P
0 g
s
.50775 .53326 m .49909 .54241 L .49564 .53494 L p .848 .849 .843 r
F P
0 g
s
.49564 .53494 m .50586 .5291 L .50775 .53326 L p .848 .849 .843 r
F P
0 g
s
.50806 .57721 m .50654 .57032 L .52356 .57154 L p .669 .306 .347 r
F P
0 g
s
.52356 .57154 m .52177 .57819 L .50806 .57721 L p .669 .306 .347 r
F P
0 g
s
.52177 .57819 m .52356 .57154 L .53807 .56711 L p .396 .052 .26 r
F P
0 g
s
.53853 .55653 m .53807 .56711 L .52356 .57154 L p .526 .318 .54 r
F P
0 g
s
.49744 .57207 m .49335 .56391 L .50654 .57032 L p .84 .427 .257 r
F P
0 g
s
.50654 .57032 m .50806 .57721 L .49744 .57207 L p .84 .427 .257 r
F P
0 g
s
.53807 .56711 m .53853 .55653 L .54504 .54803 L p .045 0 .395 r
F P
0 g
s
.03 w
.53974 .56252 m
.54062 .56296 L
s
.54062 .56296 m
.54264 .56395 L
s
.54264 .56395 m
.57867 .58172 L
s
.5 Mabswid
.53997 .53813 m .54504 .54803 L .53853 .55653 L p .311 .294 .678 r
F P
0 g
s
.48899 .55466 m .48961 .54405 L .49395 .55333 L p .993 .765 .395 r
F P
0 g
s
.49395 .55333 m .49335 .56391 L .48899 .55466 L p .993 .765 .395 r
F P
0 g
s
.53997 .53813 m .53042 .53087 L .52858 .52669 L p .162 .431 .867 r
F P
0 g
s
.50067 .528 m .50867 .52525 L .50586 .5291 L p .772 .987 .898 r
F P
0 g
s
.50586 .5291 m .49564 .53494 L .50067 .528 L p .772 .987 .898 r
F P
0 g
s
.53344 .57464 m .53807 .56711 L .54458 .55865 L p 0 0 0 r
F P
0 g
s
.54504 .54803 m .54458 .55865 L .53807 .56711 L p .045 0 .395 r
F P
0 g
s
.53807 .56711 m .53344 .57464 L .52177 .57819 L p .396 .052 .26 r
F P
0 g
s
.54504 .54803 m .53997 .53813 L .5367 .5306 L p 0 0 .388 r
F P
0 g
s
.52858 .52669 m .5367 .5306 L .53997 .53813 L p .162 .431 .867 r
F P
0 g
s
.49395 .56467 m .48899 .55466 L .49335 .56391 L p 0 0 .335 r
F P
0 g
s
.49335 .56391 m .49744 .57207 L .49395 .56467 L p 0 0 .335 r
F P
0 g
s
.49587 .53542 m .50067 .528 L .49564 .53494 L p 0 0 0 r
F P
0 g
s
.49564 .53494 m .48961 .54405 L .49587 .53542 L p 0 0 0 r
F P
0 g
s
.5367 .5306 m .52858 .52669 L .52274 .52375 L p 0 .281 .657 r
F P
0 g
s
.51137 .57903 m .50806 .57721 L .52177 .57819 L p .332 0 0 r
F P
0 g
s
.52177 .57819 m .51902 .57958 L .51137 .57903 L p .332 0 0 r
F P
0 g
s
.51902 .57958 m .52177 .57819 L .53344 .57464 L p 0 0 0 r
F P
0 g
s
.50546 .57617 m .49744 .57207 L .50806 .57721 L p .345 0 0 r
F P
0 g
s
.50806 .57721 m .51137 .57903 L .50546 .57617 L p .345 0 0 r
F P
0 g
s
.51233 .5243 m .51512 .5232 L .50867 .52525 L p 0 0 0 r
F P
0 g
s
.50867 .52525 m .50067 .528 L .51233 .5243 L p 0 0 0 r
F P
0 g
s
.5367 .5306 m .54097 .53867 L .54504 .54803 L p 0 0 .388 r
F P
0 g
s
.54458 .55865 m .54504 .54803 L .54097 .53867 L p .987 .758 .366 r
F P
0 g
s
.52274 .52375 m .52613 .5253 L .5367 .5306 L p 0 .281 .657 r
F P
0 g
s
.52613 .5253 m .52274 .52375 L .51512 .5232 L p .288 0 0 r
F P
0 g
s
.51512 .5232 m .51233 .5243 L .52613 .5253 L p .288 0 0 r
F P
0 g
s
.49526 .54607 m .49587 .53542 L .48961 .54405 L p .006 0 .371 r
F P
0 g
s
.48961 .54405 m .48899 .55466 L .49526 .54607 L p .006 0 .371 r
F P
0 g
s
.54458 .55865 m .53866 .56787 L .53344 .57464 L p 0 0 0 r
F P
0 g
s
.53344 .57464 m .52552 .5776 L .51902 .57958 L p 0 0 0 r
F P
0 g
s
.52552 .5776 m .53344 .57464 L .53866 .56787 L p .757 .99 .888 r
F P
0 g
s
.50355 .57207 m .49395 .56467 L .49744 .57207 L p .126 .414 .86 r
F P
0 g
s
.49744 .57207 m .50546 .57617 L .50355 .57207 L p .126 .414 .86 r
F P
0 g
s
.54097 .53867 m .5367 .5306 L .52613 .5253 L p .838 .415 .231 r
F P
0 g
s
.51046 .53081 m .51233 .5243 L .50067 .528 L p .377 .026 .237 r
F P
0 g
s
.50067 .528 m .49587 .53542 L .51046 .53081 L p .377 .026 .237 r
F P
0 g
s
.52214 .60499 m .51881 .67415 L .53409 .66985 L p .526 .318 .54 r
F P
0 g
s
.53409 .66985 m .53715 .60053 L .52214 .60499 L p .526 .318 .54 r
F P
0 g
s
.51881 .67415 m .52214 .60499 L .50453 .60374 L p .711 .472 .562 r
F P
0 g
s
.53866 .56787 m .54458 .55865 L .54051 .54932 L p .959 .871 .706 r
F P
0 g
s
.54097 .53867 m .54051 .54932 L .54458 .55865 L p .987 .758 .366 r
F P
0 g
s
.50085 .6729 m .50453 .60374 L .49086 .59723 L p .861 .606 .552 r
F P
0 g
s
.50453 .60374 m .50085 .6729 L .51881 .67415 L p .711 .472 .562 r
F P
0 g
s
.01 w
.51432 .60575 m
.51555 .58133 L
s
.5 Mabswid
.51902 .57958 m .52552 .5776 L .5284 .57385 L p .628 .753 .938 r
F P
0 g
s
.51137 .57903 m .51902 .57958 L p .5284 .57385 L .628 .753 .938 r
F P
0 g
s
.50546 .57617 m .51137 .57903 L p .5284 .57385 L .628 .753 .938 r
F P
0 g
s
.49902 .55782 m .49526 .54607 L .48899 .55466 L p .293 .28 .674 r
F P
0 g
s
.48899 .55466 m .49395 .56467 L .49902 .55782 L p .293 .28 .674 r
F P
0 g
s
.53866 .56787 m .5284 .57385 L .52552 .5776 L p .757 .99 .888 r
F P
0 g
s
.52613 .5253 m .52775 .53205 L .54097 .53867 L p .838 .415 .231 r
F P
0 g
s
.52775 .53205 m .52613 .5253 L .51233 .5243 L p .665 .294 .331 r
F P
0 g
s
.51233 .5243 m .51046 .53081 L .52775 .53205 L p .665 .294 .331 r
F P
0 g
s
.50355 .57207 m .50546 .57617 L p .5284 .57385 L .628 .753 .938 r
F P
0 g
s
.60108 .47514 m .54769 .50899 L .56031 .52004 L p .595 .645 .87 r
F P
0 g
s
.56031 .52004 m .61386 .48653 L .60108 .47514 L p .595 .645 .87 r
F P
0 g
s
.61386 .48653 m .56031 .52004 L .56776 .53594 L p .51 .457 .733 r
F P
0 g
s
.5284 .57385 m .53866 .56787 L .53535 .56042 L p .851 .857 .846 r
F P
0 g
s
.54051 .54932 m .53535 .56042 L .53866 .56787 L p .959 .871 .706 r
F P
0 g
s
.54051 .54932 m .54097 .53867 L .52775 .53205 L p .864 .606 .546 r
F P
0 g
s
.02 w
.54055 .53669 m
.54754 .53233 L
s
.5 Mabswid
.53715 .60053 m .53409 .66985 L .54095 .66155 L p .046 0 .395 r
F P
0 g
s
.54095 .66155 m .54389 .59197 L .53715 .60053 L p .046 0 .395 r
F P
0 g
s
.50638 .56829 m .49902 .55782 L .49395 .56467 L p .452 .499 .817 r
F P
0 g
s
.49395 .56467 m .50355 .57207 L .50638 .56829 L p .452 .499 .817 r
F P
0 g
s
.5099 .54148 m .51046 .53081 L .49587 .53542 L p .52 .309 .534 r
F P
0 g
s
.49587 .53542 m .49526 .54607 L .5099 .54148 L p .52 .309 .534 r
F P
0 g
s
.03 w
.50206 .54394 m
.53538 .56037 L
s
.5 Mabswid
.56776 .53594 m .62153 .50276 L .61386 .48653 L p .51 .457 .733 r
F P
0 g
s
.62153 .50276 m .56776 .53594 L .56722 .55075 L p .364 .187 .503 r
F P
0 g
s
.48691 .66654 m .49086 .59723 L .48633 .58786 L p .993 .765 .395 r
F P
0 g
s
.49086 .59723 m .48691 .66654 L .50085 .6729 L p .861 .606 .552 r
F P
0 g
s
.50638 .56829 m .50355 .57207 L p .5284 .57385 L .628 .753 .938 r
F P
0 g
s
.01 w
.51609 .57074 m
.51807 .53136 L
s
.5 Mabswid
.51291 .56628 m .50638 .56829 L p .5284 .57385 L .628 .753 .938 r
F P
0 g
s
.52062 .56683 m .51291 .56628 L p .5284 .57385 L .628 .753 .938 r
F P
0 g
s
.01 w
.51555 .58133 m
.51598 .57296 L
s
.5 Mabswid
.5284 .57385 m .52654 .56973 L .52062 .56683 L p .628 .753 .938 r
F P
0 g
s
.53535 .56042 m .52654 .56973 L .5284 .57385 L p .851 .857 .846 r
F P
0 g
s
.58794 .47288 m .53458 .50695 L .54769 .50899 L p .658 .872 .979 r
F P
0 g
s
.54769 .50899 m .60108 .47514 L .58794 .47288 L p .658 .872 .979 r
F P
0 g
s
.02 w
.59863 .50045 m
.60042 .49933 L
s
.5 Mabswid
.41118 .47943 m .40509 .48103 L .49501 .54046 L closepath p .426 .656 .956 r
F P
0 g
s
.41452 .48399 m .41118 .47943 L .49501 .54046 L closepath p .715 .186 0 r
F P
0 g
s
.40509 .48103 m .39857 .48811 L .49501 .54046 L closepath p .702 .702 .847 r
F P
0 g
s
.41379 .49301 m .41452 .48399 L .49501 .54046 L closepath p .9 .642 .539 r
F P
0 g
s
.39857 .48811 m .39408 .49799 L .49501 .54046 L closepath p .787 .664 .727 r
F P
0 g
s
.40925 .50301 m .41379 .49301 L .49501 .54046 L closepath p .844 .736 .745 r
F P
0 g
s
.39331 .50695 m .39656 .5116 L .49501 .54046 L closepath p .72 .219 .043 r
F P
0 g
s
.39408 .49799 m .39331 .50695 L .49501 .54046 L closepath p .827 .573 .555 r
F P
0 g
s
.40265 .51012 m .40925 .50301 L .49501 .54046 L closepath p .748 .79 .887 r
F P
0 g
s
.39656 .5116 m .40265 .51012 L .49501 .54046 L closepath p .388 .753 .992 r
F P
0 g
s
.03 w
.49501 .54046 m
.49556 .54074 L
s
.5 Mabswid
.53535 .56042 m .54051 .54932 L .52725 .54273 L p .835 .678 .689 r
F P
0 g
s
.02 w
.50135 .56114 m
.52805 .54448 L
s
.5 Mabswid
.52775 .53205 m .52725 .54273 L .54051 .54932 L p .864 .606 .546 r
F P
0 g
s
.02 w
.53602 .53951 m
.5382 .53815 L
s
.5382 .53815 m
.54055 .53669 L
s
.53413 .54069 m
.53602 .53951 L
s
.5 Mabswid
.51077 .55417 m .5099 .54148 L .49526 .54607 L p .575 .451 .674 r
F P
0 g
s
.49526 .54607 m .49902 .55782 L .51077 .55417 L p .575 .451 .674 r
F P
0 g
s
.52725 .54273 m .52775 .53205 L .51046 .53081 L p .71 .469 .558 r
F P
0 g
s
.51046 .53081 m .5099 .54148 L .52725 .54273 L p .71 .469 .558 r
F P
0 g
s
.52654 .56973 m .53535 .56042 L .5247 .55517 L p .788 .721 .789 r
F P
0 g
s
.5247 .55517 m .52062 .56683 L .52654 .56973 L p .788 .721 .789 r
F P
0 g
s
.52725 .54273 m .5247 .55517 L .53535 .56042 L p .835 .678 .689 r
F P
0 g
s
.49902 .55782 m .50638 .56829 L .51291 .56628 L p .607 .56 .776 r
F P
0 g
s
.56722 .55075 m .62122 .51777 L .62153 .50276 L p .364 .187 .503 r
F P
0 g
s
.62122 .51777 m .56722 .55075 L .55882 .55886 L p 0 0 0 r
F P
0 g
s
.51291 .56628 m .51077 .55417 L .49902 .55782 L p .607 .56 .776 r
F P
0 g
s
.52062 .56683 m .5247 .55517 L .51077 .55417 L p .707 .629 .768 r
F P
0 g
s
.51077 .55417 m .51291 .56628 L .52062 .56683 L p .707 .629 .768 r
F P
0 g
s
.54389 .59197 m .54095 .66155 L .53662 .65235 L p .987 .758 .365 r
F P
0 g
s
.53662 .65235 m .53967 .58251 L .54389 .59197 L p .987 .758 .365 r
F P
0 g
s
.5247 .55517 m .52725 .54273 L .5099 .54148 L p .716 .558 .675 r
F P
0 g
s
.5099 .54148 m .51077 .55417 L .5247 .55517 L p .716 .558 .675 r
F P
0 g
s
.48633 .58786 m .48226 .65743 L .48691 .66654 L p .993 .765 .395 r
F P
0 g
s
.48226 .65743 m .48633 .58786 L .49281 .57917 L p .006 0 .37 r
F P
0 g
s
.57945 .48074 m .52597 .51483 L .53458 .50695 L p 0 0 0 r
F P
0 g
s
.53458 .50695 m .58794 .47288 L .57945 .48074 L p 0 0 0 r
F P
0 g
s
.55882 .55886 m .61294 .52588 L .62122 .51777 L p 0 0 0 r
F P
0 g
s
.61294 .52588 m .55882 .55886 L .54566 .55706 L p .648 .878 .983 r
F P
0 g
s
.53967 .58251 m .53662 .65235 L .5226 .64581 L p .864 .606 .546 r
F P
0 g
s
.5226 .64581 m .52593 .57582 L .53967 .58251 L p .864 .606 .546 r
F P
0 g
s
.57894 .49584 m .52525 .52973 L .52597 .51483 L p .349 .171 .493 r
F P
0 g
s
.52597 .51483 m .57945 .48074 L .57894 .49584 L p .349 .171 .493 r
F P
0 g
s
.48884 .64899 m .49281 .57917 L .50796 .57453 L p .52 .309 .534 r
F P
0 g
s
.49281 .57917 m .48884 .64899 L .48226 .65743 L p .006 0 .37 r
F P
0 g
s
.54566 .55706 m .59975 .52387 L .61294 .52588 L p .648 .878 .983 r
F P
0 g
s
.59975 .52387 m .54566 .55706 L .53279 .54592 L p .591 .646 .874 r
F P
0 g
s
.52593 .57582 m .5226 .64581 L .50428 .64452 L p .71 .469 .558 r
F P
0 g
s
.01 w
.50955 .70048 m
.51234 .64509 L
s
.51391 .61396 m
.51432 .60575 L
s
.5 Mabswid
.50428 .64452 m .50796 .57453 L .52593 .57582 L p .71 .469 .558 r
F P
0 g
s
.50796 .57453 m .50428 .64452 L .48884 .64899 L p .52 .309 .534 r
F P
0 g
s
.58672 .51238 m .53279 .54592 L .52525 .52973 L p .504 .453 .733 r
F P
0 g
s
.52525 .52973 m .57894 .49584 L .58672 .51238 L p .504 .453 .733 r
F P
0 g
s
.02 w
.58508 .5089 m
.59863 .50045 L
s
.5 Mabswid
.53279 .54592 m .58672 .51238 L .59975 .52387 L p .591 .646 .874 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00/`3oool00`000000oooo0?ooo`1Z0?ooo`00/P3oool010000000bkG4
00000000001Z0?ooo`00/P3oool010000000bkG40<^ea03;]L@2000006P0oooo002a0?ooo`030000
003;]L@0bkG400@0bkG400<000000?ooo`3oool0I@3oool00;40oooo00<000000<^ea03;]L@01@3;
]L@2000006D0oooo002`0?ooo`030000003;]L@0bkG400P0bkG40P00001S0?ooo`00/03oool00`00
0000bkG40<^ea00:0<^ea0030000003oool0oooo0600oooo002_0?ooo`030000003;]L@0bkG400X0
bkG400<000000?ooo`3oool0H@3oool00:l0oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo
0?ooo`1Q0?ooo`00[P3oool00`000000bkG40<^ea00:0<^ea0030000003oool0oooo0680oooo002^
0?ooo`030000003;]L@0bkG400X0bkG400<000000?ooo`3oool0HP3oool00:d0oooo00<000000<^e
a03;]L@02P3;]L@00`000000oooo0?ooo`1S0?ooo`00[@3oool00`000000bkG40<^ea00:0<^ea003
0000003oool0oooo06<0oooo002/0?ooo`030000003;]L@0bkG400X0bkG400<000000?ooo`3oool0
I03oool00:`0oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo0?ooo`1T0?ooo`00Z`3oool0
0`000000bkG40<^ea00:0<^ea0030000003oool0oooo06D0oooo002Z0?ooo`030000003;]L@0bkG4
00/0bkG400<000000?ooo`3oool0I@3oool00:X0oooo00<000000<^ea03;]L@02P3;]L@00`000000
oooo0?ooo`1V0?ooo`00Z@3oool00`000000bkG40<^ea00:0<^ea0030000003oool0oooo06L0oooo
002Y0?ooo`030000003;]L@0bkG400X0bkG400<000000?ooo`3oool0I`3oool00:P0oooo00<00000
0<^ea03;]L@02P3;]L@00`000000oooo0?ooo`1X0?ooo`00Z03oool00`000000bkG40<^ea00:0<^e
a0030000003oool0oooo06P0oooo002W0?ooo`030000003;]L@0bkG400X0bkG400<000000?ooo`3o
ool0J@3oool00:L0oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo0?ooo`1Y0?ooo`00YP3o
ool00`000000bkG40<^ea00:0<^ea0030000003oool0oooo06X0oooo002V0?ooo`030000003;]L@0
bkG400X0bkG400<000000?ooo`3oool0JP3oool00:D0oooo00<000000<^ea03;]L@02P3;]L@00`00
0000oooo0?ooo`1[0?ooo`00Y@3oool00`000000bkG40<^ea0090<^ea0030000003oool0oooo06`0
oooo002T0?ooo`030000003;]L@0bkG400X0bkG400<000000?ooo`3oool0K03oool00:@0oooo00<0
00000<^ea03;]L@02@3;]L@00`000000oooo0?ooo`1]0?ooo`00X`3oool00`000000bkG40<^ea00:
0<^ea0030000003oool0oooo06d0oooo002S0?ooo`030000003;]L@0bkG400T0bkG400<000000?oo
o`3oool0KP3oool00:80oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo0?ooo`1^0?ooo`00
X@3oool00`000000bkG40<^ea00:0<^ea0030000003oool0oooo06l0oooo002Q0?ooo`030000003;
]L@0bkG400X0bkG400<000000?ooo`3oool0K`3oool00:00oooo00<000000<^ea03;]L@02P3;]L@0
0`000000oooo0?ooo`1`0?ooo`00X03oool00`000000bkG40<^ea00:0<^ea0030000003oool0oooo
0700oooo002O0?ooo`030000003;]L@0bkG400X0bkG400<000000?ooo`3oool0L@3oool009l0oooo
00<000000<^ea03;]L@02@3;]L@00`000000oooo0?ooo`1b0?ooo`00WP3oool00`000000bkG40<^e
a00:0<^ea0030000003oool0oooo0780oooo002N0?ooo`030000003;]L@0bkG400T0bkG400<00000
0?ooo`3oool0L`3oool009d0oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo0?ooo`1c0?oo
o`00W@3oool00`000000bkG40<^ea0090<^ea0030000003oool0oooo07@0oooo002L0?ooo`030000
003;]L@0bkG400X0bkG400<000000?ooo`3oool0M03oool009`0oooo00<000000<^ea03;]L@02@3;
]L@00`000000oooo0?ooo`1e0?ooo`00V`3oool00`000000bkG40<^ea00:0<^ea0030000003oool0
oooo07D0oooo001d0?ooo`030000003oool0oooo02@0oooo00<000000<^ea03;]L@02@3;]L@00`00
0000oooo0?ooo`1f0?ooo`00M@3oool2000002<0oooo00<000000<^ea03;]L@02@3;]L@00`000000
oooo0?ooo`1g0?ooo`00M`3oool200000200oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo
0?ooo`1g0?ooo`00N03oool3000001h0oooo00<000000<^ea03;]L@02@3;]L@00`000000oooo0?oo
o`1h0?ooo`00NP3oool3000001/0oooo00<000000<^ea03;]L@02P3;]L@00`000000oooo0?ooo`1h
0?ooo`00O03oool2000001X0oooo00<000000<^ea03;]L@02@3;]L@00`000000oooo0?ooo`1i0?oo
o`00O@3oool300000140oooo1`00000<0<^ea0030000003oool0oooo07T0oooo001o0?ooo`<00000
3@3oool200000080QDn800<000000;EhSP2eN8h00P2eN8h2000000T0bkG400<000000?ooo`3oool0
NP3oool00800oooo0`00000;0?ooo`8000000`25ChP00`000000]GR>0;EhSP020;EhSP040000003M
Vh/00000000000L0bkG400<000000?ooo`3oool0NP3oool00880oooo0`0000090?ooo`8000000`25
ChP00`000000]GR>0;EhSP020;EhSP040000003MVh/0gI^;0=fKR`800000103;]L@00`000000oooo
0?ooo`1k0?ooo`00P`3oool4000000H0oooo00<000000040GP0000000`25ChP00`000000]GR>0;Eh
SP020;EhSP040000003MVh/0gI^;0=fKR`@000000P3;]L@00`000000oooo0?ooo`1k0?ooo`00Q@3o
ool3000000D0oooo00<000000040GP0000000`25ChP00`000000]GR>0;EhSP020;EhSP040000003M
Vh/0gI^;0=fKR`8000000P3oool2000007h0oooo00270?ooo`<000000`3oool00`0000000@1N0000
000308E?R0030000002eN8h0]GR>0080]GR>00@000000=fKR`3MVh/0gI^;0P0000220?ooo`00R03o
ool300000080oooo00<000000040GP0000000`25ChP00`000000]GR>0;EhSP020;EhSP040000003M
Vh/0gI^;0=fKR`800000PP3oool008T0oooo00<0M@000000000000000P0000000`0105h0000008E?
R00208E?R0030000002eN8h0]GR>0080]GR>00@000000=fKR`3MVh/0gI^;0P0000220?ooo`00R`3o
ool207D000030000000105h0000000<0QDn800<000000;EhSP2eN8h00P2eN8h010000000gI^;0=fK
R`3MVh/200000880oooo002<0?ooo`80000000D00@1N00000025ChP0QDn8000000040;EhSP030000
003MVh/0gI^;0080gI^;0P0000220?ooo`00S@3oool2000000<0QDn800<000000;EhSP2eN8h00P2e
N8h00`000000gI^;0=fKR`020=fKR`8000002P3oool2000007H0oooo002=0?ooo`8000000`25ChP0
0`000000]GR>0;EhSP020;EhSP040000003MVh/0gI^;0=fKR`<00000203oool200000080Z=oj0`00
001c0?ooo`00M@3oool2000001H0oooo0P00000308E?R0030000002eN8h0]GR>0080]GR>00@00000
0=fKR`3MVh/0gI^;0`0000070?ooo`8000000`2XgoX20000000309RUgP000000oooo0740oooo001d
0?ooo`040000001]Yo@00000000001@0oooo00<000000040GP0000000`25ChP00`000000]GR>0;Eh
SP020;EhSP070000003MVh/0gI^;0=fKR`000000o<9M000000050?ooo`@000000P2XgoX00`000000
V:GN09RUgP0209RUgP800000L03oool007<0oooo00<000000;>cf00000001000000B0?ooo`030000
000105h0000000<0QDn800<000000;EhSP2eN8h00P2eN8h01`000000gI^;0=fKR`3MVh/000000?c2
G@000000103oool200000080FB]n0`00000709RUgP030000003oool0oooo06d0oooo001b0?ooo`05
0000002c/mP0/k?H0;>cf00000000P3VY8T200000140oooo00<000000040GP0000000`25ChP00`00
0000]GR>0;EhSP020;EhSP070000003MVh/0gI^;0=fKR`000000o<9M000000020?ooo`800000101I
:gh00`000000V:GN09RUgP0209RUgP060000002HYMh0V:GN00000022M;/00000K`3oool00780oooo
0`0000000`2c/mP000000>JTR@020>JTR@800000403oool00`0000000@1N0000000308E?R0030000
002eN8h0]GR>0080]GR>00P000000=fKR`3MVh/0gI^;0000003l`Ud000000?ooo`8000001@1I:gh0
0`000000V:GN09RUgP0600000080PWBk00<000000?ooo`3oool0K03oool00740oooo0P0000020<VY
^P@000000P3VY8T3000000h0oooo00<000000040GP0000000P25ChP5000000030;EhSP000000gI^;
0080gI^;00@000000?c2G@00000000001`1I:gh00`000000V:GN09RUgP0600000080PWBk00<00000
0?ooo`3oool0K03oool00740oooo00<000000=>BSP0000000P0000030=Rl_P8000000P3VY8T20000
00d0oooo00<000000040GP0000000`0000020;IhS`@000000`3MVh/3000000H0FB]n2`000003089d
^`030000003oool0oooo06/0oooo001`0?ooo`030000003CTXh0di:>0080di:>0P0000040=Rl_P03
0000003VY8T0iZB900800000303oool00`0000000@1N000000020=bKS@030000002fN8l0]WR?00<0
000000<0QU6:0000000000000P00000605T[OP8000000P21Lk/9000000<0PWBk00<000000?ooo`3o
ool0J`3oool00700oooo0P0000020=>BSP030000002ob^<0_l[S008000000`3H_;h200000080iZB9
0P00000:0?ooo`<000000P3LVhd00`000000]WR?0;IhS`0300000080QU6:00<0000005T[OP1I:gh0
1@1I:gh010000000PG>k085c^`21Lk/:00000004089d^`000000GBn0000006d0oooo001a0?ooo`@0
0000102ob^<300000080f;bn0P0000000`3VY8T00000000000090?ooo`030000003n`fD000000080
g9^=00<000000;IhS`2fN8l01@00000605T[OP8000000`21Lk/800000080PWBk0P00000205d_P003
0000003oool0oooo01/0oooo1000001<0?ooo`00L`3oool5000000<0_l[S0`0000020=Rl_P@00000
2@3oool200000080g9^=00<000000;IhS`2fN8l00`00000705T[OP0300000021Lk/0PG>k00@0PG>k
1@000002089d^`800000101M;h000`000000oooo0?ooo`0G0?ooo`@0000000<0V_3a000000000000
C@3oool007H0oooo1@0000020;o:h`<000000P3H_;h010000000iZB90000000000070?ooo`800000
0P3LVhd00`000000]WR?0;IhS`03000000D0FB]n0P000008085c^`80000000@0UjGO000000000000
00001P1M;h000`000000oooo0?ooo`0E0?ooo`8000000`2Jl?42000004l0oooo001j0?ooo`@00000
0P2ob^<2000000030=Rl_P0000000000008000001`3oool01@000000g9^=0=bKS@000000]WR?00@0
00000`1I:gh2000000P0PG>k0P00000409NUg`800000101M;h02000001H0oooo0P00000409[`l@03
0000003oool0oooo04l0oooo001m0?ooo`@0000000@0_l[S000000000000f;bn0`0000070?ooo`P0
00000P1I:gh00`000000PG>k085c^`06085c^`800000202GYMl4000001H0oooo0P00000409[`l@80
00008`3oool4000002/0oooo00200?ooo`X00000103oool300000080H0Hl00<000000:Y;E02ZBe@0
0`000007085c^`800000202GYMl2000000030:GPn`000000000001H0oooo00<0000009[`l@2Jl?40
0P2Jl?4200000240oooo100000000`2Dknh000000000000/0?ooo`00P`3ooolD000000P0PG>k00<0
000009NUg`2GYMl01P2GYMl200000080YN3k00<000000?ooo`3oool0503oool2000000@0V_3a00<0
00000?ooo`3oool07`3oool00`000000U>o^09C_kP0209C_kP800000;P3oool008H0oooo3@000003
0;EhSP0300000021Lk/0PG>k00@0PG>k0P00000709NUg`8000000P2Uh?/2000001D0oooo0P000004
09[`l@800000803oool00`000000U>o^09C_kP0209C_kP800000<03oool008X0oooo2@0000040;Eh
SP0400000021Lk/0PG>k085c^`8000001`2GYMl2000000<0YN3k00<000000?ooo`3oool04`3oool2
00000080V_3a00@0oooo09[`l@0000000000803oool2000000<0U>o^0P00000b0?ooo`00RP3oool>
00000003085c^`000000000000P0UjGO00@000000:GPn`2Uh?/0YN3k0P00000E0?ooo`030000002J
l?40V_3a00<0V_3a00<000000?ooo`3oool07P3oool2000000@0U>o^00<000000?ooo`3oool0<P3o
ool008X0oooo1P00000209=c[0030000002gSZ`0]hj/0080]hj/0P00000809NUg`8000000`2Uh?/2
000000030;L_0000000000000140oooo0P00000409[`l@8000007`3oool2000000@0U>o^0P00000e
0?ooo`00QP3oool9000000<0Tg>/00<000000;N>[02gSZ`00P2gSZ`3000000D0UjGO0P0000030:GP
n`D000000P2g;`02000000d0oooo0P00000309[`l@030?ooo`00000000000200oooo00<0000009C_
kP2Dknh00P2Dknh2000003L0oooo00240?ooo`8000000P2XgoX7000000<0Tg>/00D000000;N>[02g
SZ`0]hj/000000030=F]/080000000<0UjGO000000000000102Uh?/00`000000^KgM0;Vmg@020;Vm
g@050000003MVh/000000;L_001]]O/00P0000090?ooo`8000001@2Jl?400`000000oooo0?ooo`0N
0?ooo`8000000`2Dknh2000003T0oooo00230?ooo`8000000P2XgoX00`000000V:GN09RUgP060000
000309=c[0000000000000D000000P3E[K04000000<0YN3k0P0000050;Vmg@030000003MVh/0gI^;
008000000P2g;`02000000H0oooo00<0000009[`l@2Jl?400`2Jl?42000001l0oooo0P00000409C_
kP030000003oool0oooo03T0oooo00210?ooo`H000001@2HYMh50000000309^?aP000000]:740080
]:7400<000000<Vhb@0000002P0000050;Vmg@030000003MVh/0gI^;0080gI^;0P0000020;L_0080
00000P3oool2000000@0V_3a0P00000O0?ooo`800000102Dknh2000003`0oooo001o0?ooo`<00000
0P1I:gh00`000000V:GN09RUgP0409RUgPH000000P2KSlH00`000000]:74000000020<Vhb@d00000
0P2i_Md00`000000gI^;0=fKR`050=fKR`80000000@0KKGk0;L_0000000000001@2Jl?400`000000
oooo0?ooo`0M0?ooo`800000102Dknh2000003h0oooo001n0?ooo`<000000P1I:gh00`000000V:GN
09RUgP0309RUgPP0000000<0Vho60000000000000P0000020<VhbA0000002@3MVh/2000000D0V_3a
0P00000O0?ooo`030000002Dknh0U>o^0080U>o^0P0000100?ooo`00O03oool3000000@0FB]n00<0
000009RUgP2HYMh00P2HYMh:00000080X<3`00<000000:30l00000004`0000060=fKR`T000007P3o
ool2000000<0U>o^0P0000120?ooo`00N`3oool3000000<0FB]n0P0000000`21Lk/0000009RUgP0@
000000030:30l0000000000001<000000`3MVh/2000000@0gI^;0P0000020;L_008000006P3oool2
000000@0U>o^00<000000?ooo`3oool0@P3oool007T0oooo0`00000405T[OP0400000021Lk/0PG>k
085c^``0000000@0QDn80000002eN8h0]GR>6@00000:0=fKR`8000000P2g;`000`000000oooo0?oo
o`0E0?ooo`800000102Dknh2000004D0oooo001g0?ooo`<00000101I:gh200000080PG>k2P000000
0`22M;/0000008E?R00208E?R0030000002eN8h0]GR>0080]GR>1P0000000`3@/[`000000000000<
00000080d;>l0P00000:0=fKR`H000004P3oool2000000@0U>o^0P0000170?ooo`00MP3oool30000
00@0FB]n00<00000085c^`21Lk/00`21Lk/800000003089d^`000000000000<0QDn800<000000;Eh
SP2eN8h00P2eN8h00`000000gI^;0=fKR`02000000040=bKS@00000000000=2b_0/000001@3@/k`2
000000X0gI^;0P00000206fen`8000003P3oool2000000@0U>o^0P0000190?ooo`00M03oool30000
00@0FB]n0P000006085c^`H000000P22M;/00`0000000@1N0000000308E?R0030000002eN8h0]GR>
0080]GR>00@000000=fKR`3MVh/0gI^;0P0000020=bKS@80000000<0d;:l0000000000001`000007
0=2c_0<000002@3MVh/00`000000KKGk06fen`03000000/0oooo00<0000009C_kP2Dknh00`2Dknh0
0`000000oooo0?ooo`190?ooo`00L`3oool3000000@0FB]n00<00000085c^`21Lk/01`21Lk/40000
0006089d^`00000000000000000105h000000`25ChP00`000000]GR>0;EhSP020;EhSP070000003M
Vh/0gI^;0=fKR`000000o<9M000000030=bKS@80000000<0d;:l0000000000001@00000:0=2c_080
00001`3MVh/200000080KKGk00@000000;L_0000000000001`3oool2000000@0U>o^0P00001<0?oo
o`00LP3oool2000000D0FB]n00<00000085c^`21Lk/01P21Lk/3000000<0UjGO00H0000005d_P01M
;h0000000040GP00000308E?R0030000002eN8h0]GR>0080]GR>00L000000=fKR`3MVh/0gI^;0000
003l`Ud0000000D0g9^=0P0000000`2i_mh0000000000002000000d0d;>l0P0000050=fKR`030000
002i_Md0000000@0000000<0]bl00000000000000`3oool2000000@0U>o^0P00001>0?ooo`00L@3o
ool2000000@0FB]n0P000008085c^`030000002GYMl0UjGO00D0UjGO0`0000000`0105h0000008E?
R00208E?R0030000002eN8h0]GR>0080]GR>00L000000=fKR`3MVh/0gI^;0000003l`Ud0000000D0
g9^=00@000000;VogP2i_mh0^KoN0`00000?0=2c_08000000`3MVh/01@000000^KgM0;Vmg@2i_Md0
00000080gI^;0P000000102g;`00000000000000000409C_kP800000D03oool00700oooo00<00000
05T[OP1I:gh00`1I:gh00`000000PG>k085c^`06085c^`8000001P2GYMl200000080YN3k00<00000
0040GP0000000`25ChP00`000000]GR>0;EhSP020;EhSP070000003MVh/0gI^;0=fKR`000000o<9M
000000040=bKS@030000002i_mh0^KoN00@0^KoN0`00000?0=2c_080000000<0gI^;0000002i_Md0
0P2i_Md00`000000gI^;0=fKR`020=fKR`800000102Dknh200000580oooo001`0?ooo`040000001I
:gh0FB]n05T[OP8000001`21Lk/2000000H0UjGO0P0000030:GPn`80000000<00@1N00000025ChP0
0P25ChP00`000000]GR>0;EhSP020;EhSP060000003MVh/0gI^;0=fKR`000000o<9M1@0000090;Vo
gP<000003`3@/k`2000000<0^KgM00<000000=fKR`3MVh/00P00000309C_kP<00000E03oool00700
oooo00@0000005T[OP1I:gh000002021Lk/00`000000UjGO09NUg`0509NUg`040000002Uh?/0YN3k
0:GPn`80000000@0oooo0000000105h000000`25ChP00`000000]GR>0;EhSP020;EhSP060000003M
Vh/0gI^;0=fKR`000000o<9M0P00000306Fdn`8000002@2i_mh3000000h0d;>l00<000000;Vmg@2i
_Md00P0000000`3MVh/0000000000004000000030=fKR`000000oooo05@0oooo001`0?ooo`<00000
1`21Lk/2000000H0UjGO0P0000030:GPn`070000003oool0oooo0?ooo`0000000@1N0000000208E?
R0040000002eN8h0]GR>00000080]GR>00H000000=fKR`3MVh/0gI^;0000003l`Ud3000000@0IKCk
0P0000090;VogP<000002`3@/k`4000000030?ooo`000000gI^;00L0gI^;00<000000?ooo`3oool0
D`3oool00700oooo0P000006085c^`8000001P2GYMl2000000<0YN3k0P0000040?ooo`0300000001
05h000000080QDn800H000000;EhSP2eN8h000000;EhSP0000040=fKR`030000003l`Ud000000080
V_3a0P00000406Fdn`8000002@2i_mh3000000T0d;>l200000060=fKR`030000003oool0oooo05<0
oooo001`0?ooo`<000001021Lk/00`000000UjGO09NUg`0509NUg`040000002Uh?/0YN3k0:GPn`80
00001P3oool2000000<0QDn800H000000;EhSP2eN8h000000;EhSP0000040=fKR`040000003l`Ud0
000009[`l@80000000<0oooo000000000000101U]?/2000000T0^KoN0`0000060=2c_0P0000000<0
d;>l000000000000103MVh/00`000000oooo0?ooo`1C0?ooo`00K`3oool500000003085c^`000000
000000H0UjGO0P0000030:GPn`030000003oool0oooo00H0oooo0P00000308E?R0030000002eN8h0
]GR>0080]GR>00<000000=fKR`3MVh/00P3MVh/010000000o<9M0000000000050?ooo`800000101U
]?/2000000T0^KoN0`0000040=2c_0P000000`3@/k`200000080gI^;00<000000?ooo`3oool0D`3o
ool006d0oooo2000000609NUg`8000000`2Uh?/2000000P0oooo00<000000040GP0000000`25ChP0
0`000000]GR>0;EhSP020;EhSP030000003MVh/0gI^;0080gI^;00<000000?c2G@000000203oool2
000000@0IKCk0P0000090;VogP<0000000<0d;>l0000000000001`0000050=2c_0<00000E@3oool0
06`0oooo2000000609NUg`030000002Uh?/0YN3k0080YN3k00<000000?ooo`3oool0203oool00`00
00000@1N0000000308E?R0030000002eN8h0]GR>0080]GR>00<000000=fKR`3MVh/00P3MVh/20000
00/0oooo0P00000406Fdn`8000002@2i_mh:000000P0d;>l00<000000?ooo`3oool0D`3oool006/0
oooo2@00000409NUg`8000000`2Uh?/2000000/0oooo00<000000040GP0000000`25ChP00`000000
]GR>0;EhSP020;EhSP030000003MVh/0gI^;0080gI^;0P00000=0?ooo`800000101U]?/2000000P0
^KoN2@0000080=2c_0030000003oool0oooo05<0oooo001Z0?ooo`P000000P3oool010000000UjGO
0000000000040:GPn`030000003oool0oooo00/0oooo00<000000040GP0000000`25ChP00`000000
]GR>0;EhSP020;EhSP030000003MVh/0gI^;0080gI^;0P00000?0?ooo`800000101U]?/2000000D0
^KoN00<000000=bKS@3LVhd01P0000080=2c_0030000003oool0oooo05@0oooo001[0?ooo`D00000
1@3oool2000000<0YN3k0P00000>0?ooo`030000000105h0000000<0QDn800<000000;EhSP2eN8h0
0P2eN8h00`000000gI^;0=fKR`020=fKR`8000004@3oool2000000@0IKCk0P0000020;VogP030000
003LVhd0g9^=0080g9^=00<000000;VogP000000100000060=2c_0@00000D`3oool006`0oooo0`00
00080?ooo`<00000403oool00`0000000@1N0000000208E?R0D0000000<0]GR>0000003MVh/00`3M
Vh/2000001<0oooo0P00000306Fdn`<00000103LVhd00`000000^KoN0;VogP050;VogP8000000`3@
/k`800000500oooo001]0?ooo`030000003oool0oooo01X0oooo00<000000040GP0000000`000002
0;IhS`D000000`3MVh/2000001@0oooo1`0000030=bKS@030000002i_mh0^KoN00P0^KoN0P000000
0`3@/k`000000000000:000004`0oooo00290?ooo`80000000D00@1N0000003LVhd0g9^=00000002
0;IhS`<000000P26DHX2000000030=fKR`00000000000180oooo0P00000209C_kP80000000<0oooo
0000000000001000000<0;VogP030000003oool0oooo00@0000000<0bJVj0000000000001P000019
0?ooo`00Q`3oool20000000309[`l@000000000000<0g9^=00<000000;IhS`2fN8l00`00000408IA
RP<00000403oool200000080U>o^0P0000040?ooo`8000000`1U]?/2000000T0^KoN00<000000?oo
o`3oool00`3oool4000000040<VY^P00000000000=>BS`L00000A@3oool008D0oooo0P0000000`2J
l?40000000000002000000<0g9^=00<000000;IhS`2fN8l00`00000408IARP<000003P3oool20000
00<0U>o^00<000000?ooo`3oool01P3oool2000000<0IKCk0`0000050;VogP030000003oool0oooo
00D0oooo0P000000102c/mP000000<VY^P39ZKX3000000030=>BS`00000000000080^S`A0P000013
0?ooo`00Q03oool400000080oooo0P0000030=bKS@030000002fN8l0]WR?00<000001026DHX00`00
00002`1U0000000=0?ooo`040000002Dknh0U>o^09C_kP8000002`3oool2000000@0IKCk0P000002
0;VogP030000003oool0oooo00L0oooo1@0000030<VY^P80000000<0di:?0000000000000P000013
0?ooo`00R`3oool01@000000g9^=0=bKS@3LVhd000000080]WR?0`00000408IARP800000303oool2
00000080U>o^0P00000?0?ooo`8000000`1U]?/3000000`0oooo0P0000000`2c/mP0000000000003
0<VY^P8000000P3CTXl200000480oooo002;0?ooo`050000003LVhd0g9^=0=bKS@0000000P2fN8l3
000000@0QU6:0P00000:0?ooo`8000000P2Dknh2000001<0oooo0`00000@0?ooo`<0000000<0/k?H
00000039ZKX00`39ZKX2000000030=>BS`000000oooo0440oooo002<0?ooo`80000000@0g9^=0000
002fN8l0]WR?0`00000208IARP<000002@3oool200000080U>o^0P00000Y0?ooo`<0000000<0/k?H
0000000000001039ZKX200000480oooo002>0?ooo`T000002P3oool2000000<0U>o^00<000000?oo
o`3oool0:`3oool3000000030;>cf0000000000000<0bJVj00<000000?ooo`3oool0@03oool00980
oooo0P00000<0?ooo`040000002Dknh0U>o^09C_kP800000;`3oool00`000000L:Sc000000020;>c
f0<00000@`3oool00980oooo0P00000:0?ooo`8000000P2Dknh200000380oooo100000000`2c/mP0
0000000000130?ooo`00TP3oool2000000P0oooo0P00000209C_kP800000=P3oool3000004D0oooo
002B0?ooo`8000001P3oool2000000<0U>o^00<000000?ooo`3oool0OP3oool00980oooo0P000004
0?ooo`8000000`2Dknh200000840oooo002B0?ooo`8000000`3oool010000000U>o^09C_kP2Dknh2
000008<0oooo002B0?ooo`80000000<0oooo0000000000000`2Dknh00`000000oooo0?ooo`230?oo
o`00T@3oool4000000<0U>o^00<000000?ooo`3oool0Q@3oool00940oooo0P000000102Dknh00000
0000000000290?ooo`00S`3oool5000008`0oooo002>0?ooo`800000T03oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.55864 .69342 m .56789 .69376 L .548 .65876 L closepath p .518 .772 .989 r
F P
0 g
s
.55057 .69806 m .55864 .69342 L .548 .65876 L closepath p .797 .938 .922 r
F P
0 g
s
.54675 .70593 m .55057 .69806 L .548 .65876 L closepath p .939 .943 .607 r
F P
0 g
s
.56789 .69376 m .57482 .69895 L .548 .65876 L closepath p 0 .327 .807 r
F P
0 g
s
.54864 .71404 m .54675 .70593 L .548 .65876 L closepath p 0 0 .363 r
F P
0 g
s
.57482 .69895 m .57678 .70705 L .548 .65876 L closepath p .924 .594 .135 r
F P
0 g
s
.55556 .71929 m .54864 .71404 L .548 .65876 L closepath p .312 .46 .847 r
F P
0 g
s
.57678 .70705 m .57298 .71496 L .548 .65876 L closepath p .955 .849 .697 r
F P
0 g
s
.56487 .71965 m .55556 .71929 L .548 .65876 L closepath p .62 .706 .906 r
F P
0 g
s
.57298 .71496 m .56487 .71965 L .548 .65876 L closepath p .806 .817 .859 r
F P
0 g
s
.51417 .61587 m .52037 .63626 L .53991 .62513 L p .81 .869 .891 r
F P
0 g
s
.53991 .62513 m .53402 .6046 L .51417 .61587 L p .81 .869 .891 r
F P
0 g
s
.53402 .6046 m .53991 .62513 L .56225 .62582 L p .591 .738 .946 r
F P
0 g
s
.50461 .63489 m .51098 .65507 L .52037 .63626 L p .973 .906 .686 r
F P
0 g
s
.52037 .63626 m .51417 .61587 L .50461 .63489 L p .973 .906 .686 r
F P
0 g
s
.56225 .62582 m .5567 .60526 L .53402 .6046 L p .591 .738 .946 r
F P
0 g
s
.5567 .60526 m .56225 .62582 L .57903 .63812 L p .188 .431 .862 r
F P
0 g
s
.32014 .70193 m .50386 .65617 L .50233 .65689 L p 0 0 0 r
F P
0 g
s
.50233 .65689 m .31522 .70349 L .32014 .70193 L p 0 0 0 r
F P
0 g
s
.50906 .65454 m .5154 .67452 L .51098 .65507 L p .772 .491 0 r
F P
0 g
s
.51098 .65507 m .50461 .63489 L .50906 .65454 L p .772 .491 0 r
F P
0 g
s
.57903 .63812 m .57371 .61767 L .5567 .60526 L p .188 .431 .862 r
F P
0 g
s
.57371 .61767 m .57903 .63812 L .5838 .6575 L p .7 .431 0 r
F P
0 g
s
.58573 .63579 m .77042 .58979 L .77383 .58928 L p 0 0 0 r
F P
0 g
s
.77383 .58928 m .58572 .63613 L .58573 .63579 L p 0 0 0 r
F P
0 g
s
.52602 .66727 m .53212 .68714 L .5154 .67452 L p .141 .409 .855 r
F P
0 g
s
.5154 .67452 m .50906 .65454 L .52602 .66727 L p .141 .409 .855 r
F P
0 g
s
.5838 .6575 m .57854 .63724 L .57371 .61767 L p .7 .431 0 r
F P
0 g
s
.57854 .63724 m .5838 .6575 L .57458 .67658 L p .976 .914 .672 r
F P
0 g
s
.54904 .66806 m .55479 .68795 L .53212 .68714 L p .58 .743 .954 r
F P
0 g
s
.53212 .68714 m .52602 .66727 L .54904 .66806 L p .58 .743 .954 r
F P
0 g
s
.57458 .67658 m .56915 .65654 L .57854 .63724 L p .976 .914 .672 r
F P
0 g
s
.56915 .65654 m .57458 .67658 L .55479 .68795 L p .811 .88 .896 r
F P
0 g
s
.55479 .68795 m .54904 .66806 L .56915 .65654 L p .811 .88 .896 r
F P
0 g
s
.30844 .40173 m .465 .47863 L .45756 .45458 L p .331 .543 .908 r
F P
0 g
s
.45756 .45458 m .29877 .37725 L .30844 .40173 L p .331 .543 .908 r
F P
0 g
s
.49694 .55921 m .5118 .60806 L .53176 .59674 L p .81 .869 .891 r
F P
0 g
s
.53176 .59674 m .51766 .54754 L .49694 .55921 L p .81 .869 .891 r
F P
0 g
s
.51766 .54754 m .53176 .59674 L .55457 .59739 L p .591 .738 .946 r
F P
0 g
s
.53214 .46178 m .63744 .31881 L .63297 .29293 L p .938 .908 .765 r
F P
0 g
s
.48689 .5788 m .50217 .62716 L .5118 .60806 L p .973 .906 .686 r
F P
0 g
s
.5118 .60806 m .49694 .55921 L .48689 .5788 L p .973 .906 .686 r
F P
0 g
s
.55457 .59739 m .54127 .54812 L .51766 .54754 L p .591 .738 .946 r
F P
0 g
s
.54127 .54812 m .55457 .59739 L .57168 .60983 L p .188 .431 .862 r
F P
0 g
s
.49144 .59898 m .50663 .64689 L .50217 .62716 L p .772 .491 0 r
F P
0 g
s
.50217 .62716 m .48689 .5788 L .49144 .59898 L p .772 .491 0 r
F P
0 g
s
.57168 .60983 m .55895 .5608 L .54127 .54812 L p .188 .431 .862 r
F P
0 g
s
.55895 .5608 m .57168 .60983 L .57652 .62948 L p .7 .431 0 r
F P
0 g
s
.50905 .61201 m .52368 .65966 L .50663 .64689 L p .141 .409 .855 r
F P
0 g
s
.50663 .64689 m .49144 .59898 L .50905 .61201 L p .141 .409 .855 r
F P
0 g
s
.57652 .62948 m .5639 .58089 L .55895 .5608 L p .7 .431 0 r
F P
0 g
s
.5639 .58089 m .57652 .62948 L .56706 .64886 L p .976 .914 .672 r
F P
0 g
s
.53303 .61273 m .54683 .66044 L .52368 .65966 L p .58 .743 .954 r
F P
0 g
s
.52368 .65966 m .50905 .61201 L .53303 .61273 L p .58 .743 .954 r
F P
0 g
s
.56706 .64886 m .55403 .60079 L .5639 .58089 L p .976 .914 .672 r
F P
0 g
s
.55403 .60079 m .56706 .64886 L .54683 .66044 L p .811 .88 .896 r
F P
0 g
s
.63297 .29293 m .5258 .43744 L .53214 .46178 L p .938 .908 .765 r
F P
0 g
s
.54683 .66044 m .53303 .61273 L .55403 .60079 L p .811 .88 .896 r
F P
0 g
s
.35448 .64626 m .48761 .61304 L .48591 .61297 L p .201 .724 .716 r
F P
0 g
s
.48591 .61297 m .35049 .64676 L .35448 .64626 L p .201 .724 .716 r
F P
0 g
s
.57656 .59085 m .71028 .55749 L .71241 .55646 L p .201 .724 .716 r
F P
0 g
s
.71241 .55646 m .57639 .59039 L .57656 .59085 L p .201 .724 .716 r
F P
0 g
s
.51247 .52864 m .4976 .46551 L .48109 .4666 L p .732 .484 .553 r
F P
0 g
s
.4976 .46551 m .51247 .52864 L .52766 .52187 L p .58 .39 .588 r
F P
0 g
s
.52766 .52187 m .51248 .45872 L .4976 .46551 L p .58 .39 .588 r
F P
0 g
s
.48109 .4666 m .4957 .52987 L .51247 .52864 L p .732 .484 .553 r
F P
0 g
s
.4957 .52987 m .48109 .4666 L .46914 .46157 L p .887 .58 .461 r
F P
0 g
s
.51248 .45872 m .52766 .52187 L .53557 .51205 L p .298 .212 .587 r
F P
0 g
s
.53557 .51205 m .52018 .44875 L .51248 .45872 L p .298 .212 .587 r
F P
0 g
s
.4836 .52506 m .46914 .46157 L .46631 .45224 L p .762 .483 0 r
F P
0 g
s
.46914 .46157 m .4836 .52506 L .4957 .52987 L p .887 .58 .461 r
F P
0 g
s
.52018 .44875 m .53557 .51205 L .53312 .50287 L p .71 .44 0 r
F P
0 g
s
.53312 .50287 m .51768 .43934 L .52018 .44875 L p .71 .44 0 r
F P
0 g
s
.46631 .45224 m .48082 .51597 L .4836 .52506 L p .762 .483 0 r
F P
0 g
s
.48082 .51597 m .46631 .45224 L .47386 .44213 L p .279 .195 .579 r
F P
0 g
s
.51768 .43934 m .53312 .50287 L .52107 .49787 L p .891 .577 .449 r
F P
0 g
s
.52107 .49787 m .50576 .43411 L .51768 .43934 L p .891 .577 .449 r
F P
0 g
s
.48858 .50601 m .47386 .44213 L .48897 .43517 L p .576 .384 .584 r
F P
0 g
s
.47386 .44213 m .48858 .50601 L .48082 .51597 L p .279 .195 .579 r
F P
0 g
s
.50576 .43411 m .52107 .49787 L .50399 .49907 L p .732 .481 .549 r
F P
0 g
s
.50399 .49907 m .48897 .43517 L .50576 .43411 L p .732 .481 .549 r
F P
0 g
s
.48897 .43517 m .50399 .49907 L .48858 .50601 L p .576 .384 .584 r
F P
0 g
s
.46032 .55463 m .35101 .58197 L .35534 .5988 L p .706 .589 .722 r
F P
0 g
s
.35534 .5988 m .46459 .57149 L .46032 .55463 L p .706 .589 .722 r
F P
0 g
s
.46459 .57149 m .35534 .5988 L .35809 .61342 L p .661 .44 .574 r
F P
0 g
s
.45655 .54168 m .34671 .56917 L .35101 .58197 L p .723 .724 .851 r
F P
0 g
s
.35101 .58197 m .46032 .55463 L .45655 .54168 L p .723 .724 .851 r
F P
0 g
s
.35809 .61342 m .46778 .58602 L .46459 .57149 L p .661 .44 .574 r
F P
0 g
s
.51988 .56018 m .51688 .54805 L .52886 .54275 L p .635 .513 .697 r
F P
0 g
s
.01 w
.50475 .49901 m
.50477 .49913 L
s
.5 Mabswid
.51688 .54805 m .51392 .53656 L .52057 .53361 L p .672 .616 .784 r
F P
0 g
s
.01 w
.50477 .49913 m
.5102 .52218 L
s
.5 Mabswid
.52057 .53361 m .52886 .54275 L .51688 .54805 L p .672 .616 .784 r
F P
0 g
s
.5034 .56144 m .50367 .54905 L .51688 .54805 L p .753 .586 .669 r
F P
0 g
s
.51688 .54805 m .51988 .56018 L .5034 .56144 L p .753 .586 .669 r
F P
0 g
s
.51392 .53656 m .51688 .54805 L .50367 .54905 L p .758 .668 .763 r
F P
0 g
s
.52234 .5706 m .51988 .56018 L .53484 .55358 L p .58 .39 .588 r
F P
0 g
s
.03 w
.52254 .57034 m
.5345 .61189 L
s
.5 Mabswid
.52886 .54275 m .53484 .55358 L .51988 .56018 L p .635 .513 .697 r
F P
0 g
s
.50581 .57189 m .5034 .56144 L .51988 .56018 L p .732 .484 .553 r
F P
0 g
s
.51988 .56018 m .52234 .5706 L .50581 .57189 L p .732 .484 .553 r
F P
0 g
s
.6357 .51076 m .5589 .52997 L .56312 .54686 L p .706 .589 .722 r
F P
0 g
s
.56312 .54686 m .63989 .52767 L .6357 .51076 L p .706 .589 .722 r
F P
0 g
s
.63989 .52767 m .56312 .54686 L .56671 .56131 L p .661 .44 .574 r
F P
0 g
s
.63277 .49758 m .5556 .51689 L .5589 .52997 L p .723 .724 .851 r
F P
0 g
s
.5589 .52997 m .6357 .51076 L .63277 .49758 L p .723 .724 .851 r
F P
0 g
s
.49153 .55687 m .49418 .54534 L .50367 .54905 L p .88 .694 .646 r
F P
0 g
s
.50367 .54905 m .5034 .56144 L .49153 .55687 L p .88 .694 .646 r
F P
0 g
s
.50657 .53711 m .50367 .54905 L .49418 .54534 L p .844 .759 .768 r
F P
0 g
s
.50367 .54905 m .50657 .53711 L .51392 .53656 L p .758 .668 .763 r
F P
0 g
s
.56671 .56131 m .64379 .54205 L .63989 .52767 L p .661 .44 .574 r
F P
0 g
s
.53484 .55358 m .52886 .54275 L .5351 .53511 L p .46 .436 .745 r
F P
0 g
s
.52886 .54275 m .52057 .53361 L .52401 .52935 L p .566 .59 .837 r
F P
0 g
s
.52401 .52935 m .5351 .53511 L .52886 .54275 L p .566 .59 .837 r
F P
0 g
s
.52401 .52935 m .52057 .53361 L .51392 .53656 L p .71 .816 .931 r
F P
0 g
s
.52291 .5254 m .52401 .52935 L p .51392 .53656 L .71 .816 .931 r
F P
0 g
s
.51766 .52328 m .52291 .5254 L p .51392 .53656 L .71 .816 .931 r
F P
0 g
s
.51026 .52382 m .51766 .52328 L p .51392 .53656 L .71 .816 .931 r
F P
0 g
s
.01 w
.5102 .52218 m
.51058 .5238 L
s
.5 Mabswid
.50356 .52681 m .51026 .52382 L p .51392 .53656 L .71 .816 .931 r
F P
0 g
s
.50015 .5311 m .50356 .52681 L p .51392 .53656 L .71 .816 .931 r
F P
0 g
s
.50131 .53503 m .50015 .5311 L p .51392 .53656 L .71 .816 .931 r
F P
0 g
s
.51392 .53656 m .50657 .53711 L .50131 .53503 L p .71 .816 .931 r
F P
0 g
s
.49393 .56736 m .49153 .55687 L .5034 .56144 L p .887 .58 .461 r
F P
0 g
s
.5034 .56144 m .50581 .57189 L .49393 .56736 L p .887 .58 .461 r
F P
0 g
s
.49418 .54534 m .50131 .53503 L .50657 .53711 L p .844 .759 .768 r
F P
0 g
s
.46778 .58602 m .35809 .61342 L .35822 .62035 L p .474 .064 .181 r
F P
0 g
s
.53484 .55358 m .53734 .56401 L .52234 .5706 L p .58 .39 .588 r
F P
0 g
s
.53734 .56401 m .53484 .55358 L .54266 .54409 L p .298 .212 .587 r
F P
0 g
s
.5351 .53511 m .54266 .54409 L .53484 .55358 L p .46 .436 .745 r
F P
0 g
s
.52377 .57731 m .52234 .5706 L .53734 .56401 L p .461 .164 .375 r
F P
0 g
s
.51046 .57835 m .50581 .57189 L .52234 .5706 L p .661 .292 .335 r
F P
0 g
s
.52234 .5706 m .52377 .57731 L .51046 .57835 L p .661 .292 .335 r
F P
0 g
s
.35822 .62035 m .46869 .59276 L .46778 .58602 L p .474 .064 .181 r
F P
0 g
s
.4547 .53756 m .34405 .56526 L .34671 .56917 L p .594 .905 .983 r
F P
0 g
s
.34671 .56917 m .45655 .54168 L .4547 .53756 L p .594 .905 .983 r
F P
0 g
s
.64379 .54205 m .56671 .56131 L .56831 .56788 L p .474 .064 .181 r
F P
0 g
s
.49204 .5383 m .50015 .5311 L .50131 .53503 L p .918 .91 .797 r
F P
0 g
s
.50131 .53503 m .49418 .54534 L .49204 .5383 L p .918 .91 .797 r
F P
0 g
s
.5351 .53511 m .52401 .52935 L .52291 .5254 L p .383 .589 .925 r
F P
0 g
s
.50092 .57474 m .49393 .56736 L .50581 .57189 L p .775 .282 .047 r
F P
0 g
s
.50581 .57189 m .51046 .57835 L .50092 .57474 L p .775 .282 .047 r
F P
0 g
s
.48884 .54813 m .49204 .5383 L .49418 .54534 L p .994 .866 .534 r
F P
0 g
s
.49418 .54534 m .49153 .55687 L .48884 .54813 L p .994 .866 .534 r
F P
0 g
s
.56831 .56788 m .64594 .54849 L .64379 .54205 L p .474 .064 .181 r
F P
0 g
s
.53734 .56401 m .53586 .57201 L .52377 .57731 L p .461 .164 .375 r
F P
0 g
s
.53586 .57201 m .53734 .56401 L .5452 .55454 L p 0 0 .189 r
F P
0 g
s
.54266 .54409 m .5452 .55454 L .53734 .56401 L p .298 .212 .587 r
F P
0 g
s
.54266 .54409 m .5351 .53511 L .53317 .52801 L p 0 .229 .746 r
F P
0 g
s
.52291 .5254 m .53317 .52801 L .5351 .53511 L p .383 .589 .925 r
F P
0 g
s
.63222 .49312 m .55448 .51258 L .5556 .51689 L p .594 .905 .983 r
F P
0 g
s
.5556 .51689 m .63277 .49758 L .63222 .49312 L p .594 .905 .983 r
F P
0 g
s
.49124 .55866 m .48884 .54813 L .49153 .55687 L p .761 .482 0 r
F P
0 g
s
.49153 .55687 m .49393 .56736 L .49124 .55866 L p .761 .482 0 r
F P
0 g
s
.49818 .53057 m .50356 .52681 L .50015 .5311 L p .718 .966 .711 r
F P
0 g
s
.50015 .5311 m .49204 .5383 L .49818 .53057 L p .718 .966 .711 r
F P
0 g
s
.53317 .52801 m .52291 .5254 L .51766 .52328 L p 0 .524 .845 r
F P
0 g
s
.53317 .52801 m .5403 .53526 L .54266 .54409 L p 0 .229 .746 r
F P
0 g
s
.5452 .55454 m .54266 .54409 L .5403 .53526 L p .711 .441 0 r
F P
0 g
s
.52389 .57893 m .52377 .57731 L .53586 .57201 L p 0 0 0 r
F P
0 g
s
.51647 .57952 m .51046 .57835 L .52377 .57731 L p .253 0 0 r
F P
0 g
s
.52377 .57731 m .52389 .57893 L .51647 .57952 L p .253 0 0 r
F P
0 g
s
.51117 .57751 m .50092 .57474 L .51046 .57835 L p 0 .488 .806 r
F P
0 g
s
.51046 .57835 m .51647 .57952 L .51117 .57751 L p 0 .488 .806 r
F P
0 g
s
.46869 .59276 m .35822 .62035 L .35563 .61679 L p .573 .906 .978 r
F P
0 g
s
.53586 .57201 m .53063 .57598 L .52389 .57893 L p 0 0 0 r
F P
0 g
s
.5452 .55454 m .54218 .56443 L .53586 .57201 L p 0 0 .189 r
F P
0 g
s
.53063 .57598 m .53586 .57201 L .54218 .56443 L p .681 .945 .674 r
F P
0 g
s
.5103 .52516 m .51026 .52382 L .50356 .52681 L p 0 0 0 r
F P
0 g
s
.50356 .52681 m .49818 .53057 L .5103 .52516 L p 0 0 0 r
F P
0 g
s
.02 w
.54558 .54421 m
.63908 .52083 L
s
.48857 .55847 m
.49106 .55784 L
s
.48533 .55927 m
.48857 .55847 L
s
.5 Mabswid
.51766 .52328 m .5237 .52418 L .53317 .52801 L p 0 .524 .845 r
F P
0 g
s
.5237 .52418 m .51766 .52328 L .51026 .52382 L p .207 0 0 r
F P
0 g
s
.4988 .56778 m .49124 .55866 L .49393 .56736 L p 0 .199 .727 r
F P
0 g
s
.49393 .56736 m .50092 .57474 L .4988 .56778 L p 0 .199 .727 r
F P
0 g
s
.49652 .5385 m .49818 .53057 L .49204 .5383 L p 0 0 .151 r
F P
0 g
s
.49204 .5383 m .48884 .54813 L .49652 .5385 L p 0 0 .151 r
F P
0 g
s
.54218 .56443 m .5452 .55454 L .54285 .54575 L p .989 .865 .511 r
F P
0 g
s
.5403 .53526 m .54285 .54575 L .5452 .55454 L p .711 .441 0 r
F P
0 g
s
.02 w
.49139 .55776 m
.54265 .54494 L
s
.54275 .54492 m
.54558 .54421 L
s
.5 Mabswid
.35563 .61679 m .46692 .58899 L .46869 .59276 L p .573 .906 .978 r
F P
0 g
s
.51026 .52382 m .5103 .52516 L .5237 .52418 L p .207 0 0 r
F P
0 g
s
.5403 .53526 m .53317 .52801 L .5237 .52418 L p .763 .258 .005 r
F P
0 g
s
.45551 .54401 m .34409 .5719 L .34405 .56526 L p .457 .037 .152 r
F P
0 g
s
.34405 .56526 m .4547 .53756 L .45551 .54401 L p .457 .037 .152 r
F P
0 g
s
.02 w
.29596 .60662 m
.48533 .55927 L
s
.5 Mabswid
.64594 .54849 m .56831 .56788 L .56728 .56392 L p .573 .906 .978 r
F P
0 g
s
.54621 .67183 m .53014 .60361 L .51305 .605 L p .732 .484 .553 r
F P
0 g
s
.53014 .60361 m .54621 .67183 L .56208 .66511 L p .58 .39 .588 r
F P
0 g
s
.56208 .66511 m .54568 .59686 L .53014 .60361 L p .58 .39 .588 r
F P
0 g
s
.56728 .56392 m .64548 .54439 L .64594 .54849 L p .573 .906 .978 r
F P
0 g
s
.63431 .49927 m .55601 .51886 L .55448 .51258 L p .457 .037 .152 r
F P
0 g
s
.55448 .51258 m .63222 .49312 L .63431 .49927 L p .457 .037 .152 r
F P
0 g
s
.51002 .57365 m .4988 .56778 L .50092 .57474 L p .363 .584 .928 r
F P
0 g
s
.50092 .57474 m .51117 .57751 L .51002 .57365 L p .363 .584 .928 r
F P
0 g
s
.51647 .57952 m .52389 .57893 L .53063 .57598 L p .707 .822 .936 r
F P
0 g
s
.49895 .54906 m .49652 .5385 L .48884 .54813 L p .279 .195 .579 r
F P
0 g
s
.48884 .54813 m .49124 .55866 L .49895 .54906 L p .279 .195 .579 r
F P
0 g
s
.54218 .56443 m .53414 .57177 L .53063 .57598 L p .681 .945 .674 r
F P
0 g
s
.53414 .57177 m .54218 .56443 L .54027 .55742 L p .921 .919 .795 r
F P
0 g
s
.54285 .54575 m .54027 .55742 L .54218 .56443 L p .989 .865 .511 r
F P
0 g
s
.51305 .605 m .52883 .67338 L .54621 .67183 L p .732 .484 .553 r
F P
0 g
s
.01 w
.52972 .60511 m
.52983 .60555 L
s
.5 Mabswid
.52883 .67338 m .51305 .605 L .50078 .60049 L p .887 .58 .461 r
F P
0 g
s
.54285 .54575 m .5403 .53526 L .52848 .5305 L p .891 .577 .449 r
F P
0 g
s
.5237 .52418 m .52848 .5305 L .5403 .53526 L p .763 .258 .005 r
F P
0 g
s
.51117 .57751 m .51647 .57952 L p .53063 .57598 L .707 .822 .936 r
F P
0 g
s
.54568 .59686 m .56208 .66511 L .5705 .65568 L p .298 .212 .587 r
F P
0 g
s
.5705 .65568 m .55386 .58724 L .54568 .59686 L p .298 .212 .587 r
F P
0 g
s
.51002 .57365 m .51117 .57751 L p .53063 .57598 L .707 .822 .936 r
F P
0 g
s
.5135 .56941 m .51002 .57365 L p .53063 .57598 L .707 .822 .936 r
F P
0 g
s
.52028 .56643 m .5135 .56941 L p .53063 .57598 L .707 .822 .936 r
F P
0 g
s
.52776 .56585 m .52028 .56643 L p .53063 .57598 L .707 .822 .936 r
F P
0 g
s
.01 w
.5221 .57271 m
.52404 .58098 L
s
.5 Mabswid
.53305 .5679 m .52776 .56585 L p .53063 .57598 L .707 .822 .936 r
F P
0 g
s
.53063 .57598 m .53414 .57177 L .53305 .5679 L p .707 .822 .936 r
F P
0 g
s
.5117 .53174 m .5103 .52516 L .49818 .53057 L p .448 .146 .36 r
F P
0 g
s
.49818 .53057 m .49652 .5385 L .5117 .53174 L p .448 .146 .36 r
F P
0 g
s
.52848 .5305 m .5237 .52418 L .5103 .52516 L p .657 .28 .319 r
F P
0 g
s
.5103 .52516 m .5117 .53174 L .52848 .5305 L p .657 .28 .319 r
F P
0 g
s
.01 w
.51244 .53168 m
.52061 .5664 L
s
.5 Mabswid
.50502 .56011 m .49895 .54906 L .49124 .55866 L p .451 .431 .745 r
F P
0 g
s
.49124 .55866 m .4988 .56778 L .50502 .56011 L p .451 .431 .745 r
F P
0 g
s
.54027 .55742 m .53305 .5679 L .53414 .57177 L p .921 .919 .795 r
F P
0 g
s
.54027 .55742 m .54285 .54575 L .53101 .54104 L p .885 .697 .643 r
F P
0 g
s
.52848 .5305 m .53101 .54104 L .54285 .54575 L p .891 .577 .449 r
F P
0 g
s
.46692 .58899 m .35563 .61679 L .35128 .60393 L p .723 .728 .854 r
F P
0 g
s
.35128 .60393 m .46311 .57598 L .46692 .58899 L p .723 .728 .854 r
F P
0 g
s
.45873 .55872 m .34685 .58671 L .34409 .5719 L p .659 .436 .57 r
F P
0 g
s
.34409 .5719 m .45551 .54401 L .45873 .55872 L p .659 .436 .57 r
F P
0 g
s
.5135 .56941 m .50502 .56011 L .4988 .56778 L p .561 .59 .84 r
F P
0 g
s
.4988 .56778 m .51002 .57365 L .5135 .56941 L p .561 .59 .84 r
F P
0 g
s
.51418 .5423 m .5117 .53174 L .49652 .5385 L p .576 .384 .584 r
F P
0 g
s
.49652 .5385 m .49895 .54906 L .51418 .5423 L p .576 .384 .584 r
F P
0 g
s
.53305 .5679 m .54027 .55742 L .53075 .55368 L p .848 .763 .769 r
F P
0 g
s
.53101 .54104 m .53075 .55368 L .54027 .55742 L p .885 .697 .643 r
F P
0 g
s
.53101 .54104 m .52848 .5305 L .5117 .53174 L p .732 .481 .549 r
F P
0 g
s
.51642 .66914 m .50078 .60049 L .49805 .5917 L p .762 .483 0 r
F P
0 g
s
.50078 .60049 m .51642 .66914 L .52883 .67338 L p .887 .58 .461 r
F P
0 g
s
.01 w
.52404 .58098 m
.52972 .60511 L
s
.5 Mabswid
.64548 .54439 m .56728 .56392 L .56397 .55078 L p .723 .728 .854 r
F P
0 g
s
.53075 .55368 m .52776 .56585 L .53305 .5679 L p .848 .763 .769 r
F P
0 g
s
.55386 .58724 m .5705 .65568 L .56818 .64708 L p .71 .44 0 r
F P
0 g
s
.56818 .64708 m .55147 .57836 L .55386 .58724 L p .71 .44 0 r
F P
0 g
s
.56397 .55078 m .64255 .53114 L .64548 .54439 L p .723 .728 .854 r
F P
0 g
s
.63826 .51382 m .55964 .53349 L .55601 .51886 L p .659 .436 .57 r
F P
0 g
s
.55601 .51886 m .63431 .49927 L .63826 .51382 L p .659 .436 .57 r
F P
0 g
s
.5117 .53174 m .51418 .5423 L .53101 .54104 L p .732 .481 .549 r
F P
0 g
s
.03 w
.51445 .54228 m
.52111 .56538 L
s
.5 Mabswid
.50502 .56011 m .5135 .56941 L .52028 .56643 L p .671 .617 .786 r
F P
0 g
s
.51725 .55471 m .51418 .5423 L .49895 .54906 L p .633 .511 .697 r
F P
0 g
s
.49895 .54906 m .50502 .56011 L .51725 .55471 L p .633 .511 .697 r
F P
0 g
s
.52776 .56585 m .53075 .55368 L .51725 .55471 L p .759 .67 .764 r
F P
0 g
s
.51725 .55471 m .52028 .56643 L .52776 .56585 L p .759 .67 .764 r
F P
0 g
s
.46311 .57598 m .35128 .60393 L .34685 .58671 L p .706 .589 .722 r
F P
0 g
s
.53075 .55368 m .53101 .54104 L .51418 .5423 L p .754 .586 .668 r
F P
0 g
s
.34685 .58671 m .45873 .55872 L .46311 .57598 L p .706 .589 .722 r
F P
0 g
s
.52028 .56643 m .51725 .55471 L .50502 .56011 L p .671 .617 .786 r
F P
0 g
s
.50247 .46023 m .49155 .46004 L .51283 .53664 L closepath p .617 .708 .91 r
F P
0 g
s
.51056 .4659 m .50247 .46023 L .51283 .53664 L closepath p .298 .453 .848 r
F P
0 g
s
.51272 .47492 m .51056 .4659 L .51283 .53664 L closepath p 0 0 .333 r
F P
0 g
s
.50808 .48385 m .51272 .47492 L .51283 .53664 L closepath p .947 .945 .623 r
F P
0 g
s
.49155 .46004 m .48193 .46538 L .51283 .53664 L closepath p .807 .821 .862 r
F P
0 g
s
.4984 .48926 m .50808 .48385 L .51283 .53664 L closepath p .799 .932 .92 r
F P
0 g
s
.48193 .46538 m .47726 .47425 L .51283 .53664 L closepath p .959 .854 .694 r
F P
0 g
s
.4874 .48904 m .4984 .48926 L .51283 .53664 L closepath p .528 .771 .986 r
F P
0 g
s
.47726 .47425 m .47933 .48329 L .51283 .53664 L closepath p .91 .579 .104 r
F P
0 g
s
.47933 .48329 m .4874 .48904 L .51283 .53664 L closepath p 0 .346 .821 r
F P
0 g
s
.03 w
.51283 .53664 m
.51294 .53701 L
s
.5 Mabswid
.51418 .5423 m .51725 .55471 L .53075 .55368 L p .754 .586 .668 r
F P
0 g
s
.64255 .53114 m .56397 .55078 L .55964 .53349 L p .706 .589 .722 r
F P
0 g
s
.55964 .53349 m .63826 .51382 L .64255 .53114 L p .706 .589 .722 r
F P
0 g
s
.49805 .5917 m .51374 .66064 L .51642 .66914 L p .762 .483 0 r
F P
0 g
s
.51374 .66064 m .49805 .5917 L .50607 .58194 L p .279 .195 .579 r
F P
0 g
s
.55147 .57836 m .56818 .64708 L .55582 .64265 L p .891 .577 .449 r
F P
0 g
s
.55582 .64265 m .53926 .57365 L .55147 .57836 L p .891 .577 .449 r
F P
0 g
s
.522 .65107 m .50607 .58194 L .52186 .57501 L p .576 .384 .584 r
F P
0 g
s
.50607 .58194 m .522 .65107 L .51374 .66064 L p .279 .195 .579 r
F P
0 g
s
.53926 .57365 m .55582 .64265 L .53812 .64417 L p .732 .481 .549 r
F P
0 g
s
.53812 .64417 m .52186 .57501 L .53926 .57365 L p .732 .481 .549 r
F P
0 g
s
.01 w
.5389 .6441 m
.55172 .69857 L
s
.5 Mabswid
.52186 .57501 m .53812 .64417 L .522 .65107 L p .576 .384 .584 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00]@3oool00`000000oooo0?oo
o`1X0?ooo`00]03oool2000006X0oooo002c0?ooo`030000003`j<<0000006X0oooo002c0?ooo`03
0000003`j<<0000006X0oooo002b0?ooo`050000003`j<<0l>S30?3X``000000J@3oool00;40oooo
00<000000?3X``3`j<<00P3`j<<00`000000oooo0?ooo`1W0?ooo`00/03oool00`000000l>S30?3X
``030?3X``030000003oool0oooo06L0oooo002`0?ooo`030000003`j<<0l>S300<0l>S300<00000
0?ooo`3oool0I`3oool00:l0oooo00<000000?3X``3`j<<00`3`j<<00`000000oooo0?ooo`1X0?oo
o`00[P3oool00`000000l>S30?3X``040?3X``030000003oool0oooo06P0oooo002]0?ooo`030000
003`j<<0l>S300@0l>S300<000000?ooo`3oool0J@3oool00:d0oooo00<000000?3X``3`j<<00`3`
j<<00`000000oooo0?ooo`1Z0?ooo`00[03oool00`000000l>S30?3X``030?3X``030000003oool0
oooo06/0oooo002[0?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0J`3oool00:X0
oooo00<000000?3X``3`j<<0103`j<<00`000000oooo0?ooo`1/0?ooo`00ZP3oool00`000000l>S3
0?3X``030?3X``030000003oool0oooo06d0oooo002Y0?ooo`030000003`j<<0l>S300<0l>S300<0
00000?ooo`3oool0KP3oool00:P0oooo00<000000?3X``3`j<<0103`j<<00`000000oooo0?ooo`1^
0?ooo`00Y`3oool00`000000l>S30?3X``040?3X``030000003oool0oooo06l0oooo002W0?ooo`03
0000003`j<<0l>S300<0l>S300<000000?ooo`3oool0L03oool00:H0oooo00<000000?3X``3`j<<0
0`3`j<<00`000000oooo0?ooo`1a0?ooo`00Y@3oool00`000000l>S30?3X``040?3X``030000003o
ool0oooo0740oooo002T0?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0LP3oool0
0:@0oooo00<000000?3X``3`j<<00`3`j<<00`000000oooo0?ooo`1c0?ooo`00E@3oool2000004`0
oooo00<000000?3X``3`j<<0103`j<<00`000000oooo0?ooo`1c0?ooo`00E@3oool010000000E8_X
0000000000190?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0M03oool005H0oooo
00<0000005B;j01DRnP00P0000160?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0
M@3oool005H0oooo00<0000005B;j01DRnP00P1DRnP2000004@0oooo00<000000?3X``3`j<<00`3`
j<<00`000000oooo0?ooo`1f0?ooo`00E`3oool00`000000E8_X05B;j00305B;j0800000@@3oool0
0`000000l>S30?3X``040?3X``030000003oool0oooo07H0oooo001G0?ooo`030000001DRnP0E8_X
00D0E8_X0P00000n0?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0M`3oool005P0
oooo00<0000005B;j01DRnP01P1DRnP2000003/0oooo00<000000?3X``3`j<<0103`j<<00`000000
oooo0?ooo`1h0?ooo`00F03oool00`000000E8_X05B;j00805B;j0800000>@3oool00`000000l>S3
0?3X``030?3X``030000003oool0oooo07T0oooo001J0?ooo`030000001DRnP0E8_X00P0E8_X0P00
000f0?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0N@3oool005`0oooo0P000009
05B;j0800000<`3oool00`000000l>S30?3X``040?3X``030000003oool0oooo07X0oooo001N0?oo
o`8000002@1DRnP200000300oooo00<000000?3X``3`j<<0103`j<<00`000000oooo0?ooo`1k0?oo
o`00H03oool2000000T0E8_X0`00000]0?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3o
ool0N`3oool00680oooo0P00000:05B;j0800000:P3oool00`000000l>S30?3X``040?3X``030000
003oool0oooo07`0oooo001T0?ooo`8000002P1DRnP2000002L0oooo00<000000?3X``3`j<<0103`
j<<00`000000oooo0?ooo`1m0?ooo`00IP3oool2000000X0E8_X0P00000T0?ooo`030000003`j<<0
l>S300@0l>S300<000000?ooo`3oool0OP3oool006P0oooo0P00000:05B;j08000008P3oool00`00
0000l>S30?3X``040?3X``030000003oool0oooo07h0oooo001Z0?ooo`8000002P1DRnP2000001<0
oooo1`0000050?ooo`030000003`j<<0l>S300@0l>S300<000000?ooo`3oool0O`3oool006`0oooo
0P00000:05B;j08000003`3oool20000000309=RU@000000^g^<00<0^g^<0`0000020?ooo`030000
003`j<<0l>S300@0l>S300<000000?ooo`3oool0P03oool006h0oooo0P00000:05B;j0800000303o
ool01@000000Tf:E09=RU@2CHYD0000000@0^g^<00H000000>BCLP3TTg8000000?ooo`0000050?3X
``030000003oool0oooo0840oooo001`0?ooo`8000002P1DRnP2000000T0oooo0P00000409=RU@03
0000002kNh`0^g^<0080^g^<00<000000>BCLP3TTg800P3oool00`000000l>S30?3X``020?3X``03
0000003oool0oooo0840oooo001b0?ooo`8000002P1DRnP2000000H0oooo00<0000004LaU0000000
102CHYD00`000000^g^<0;]kS0020;]kS0060000003TTg80i9=b0000003oool000000`3`j<<00`00
0000oooo0?ooo`220?ooo`00M03oool2000000X0E8_X0P0000030?ooo`0500000017<I@0Ac6D04La
U00000000`2CHYD00`000000^g^<0;]kS0020;]kS0060000003TTg80i9=b0000003oool000000P3`
j<<00`000000oooo0?ooo`230?ooo`00MP3oool2000000X0E8_X0P0000000`3oool0000004LaU002
04LaU0050000002CHYD0Tf:E09=RU@000000102kNh`01P000000i9=b0>BCLP000000oooo00000080
l>S3QP3oool007P0oooo0P00000905B;j0030000003oool0000000<0Ac6D00D0000009=RU@2CHYD0
Tf:E000000050;]kS0050000003TTg8000000000003oool00P0000260?ooo`00NP3oool2000000P0
E8_X00<000000?ooo`0000000P17<I@00`000000Tf:E09=RU@0500000080^g^<00H000000>BCLP3T
Tg8000000?ooo`0000270?ooo`00O03oool2000000H0E8_X00<000000?ooo`0000000P17<I@30000
00040<kBg0000000WKGX09fej0@000000P3TTg800`000000oooo0?ooo`270?ooo`00OP3oool20000
00@0E8_X00<000000?ooo`0000000P17<I@2000000<0c];L00@0000009fej0000000C7?I0P000002
0>BCLP030000003oool0oooo08L0oooo00200?ooo`8000000P1DRnP00`000000oooo0000000204La
U0030000003ef[4000000080c];L00@0000009fej0000000C7?I0P0000020>BCLP800000R03oool0
0880oooo0P0000001@1DRnP0000000000017<I@000000080mMZa00@000000<kBg03>d]`000000P2M
]NP400000080i9=b00<000000?ooo`3oool0QP3oool008@0oooo0P000000103oool0000000000000
00020?GJ/@030000003>d]`000000080WKGX100000020>BCLP030000003oool0oooo08H0oooo0027
0?ooo`0300000017<I@000000080mMZa00L000000<kBg03>d]`0000009fej0000000l_6O00800000
0P3TTg800`000000oooo0?ooo`260?ooo`00Q`3oool010000000Ac6D04LaU00000020?GJ/@030000
003>d]`000000080000000<0l_6O0000000000000`3TTg800`000000oooo0?ooo`250?ooo`00Q`3o
ool00`000000Ac6D04LaU006000000060<c^j`000000l_6O0000002kNh`000000P3TTg800`000000
oooo0?ooo`250?ooo`00R03oool00`000000Ac6D04LaU00200000080QlGl00L000000<c^j`000000
l_6O0000002kNh`000000080i9=b00<000000?ooo`3oool06@3oool2000006X0oooo00280?ooo`03
00000017<I@0Ac6D008000000`27aO`2000000040?;aW`000000000000000080i9=b00<000000?oo
o`3oool05@3oool40000000307@99P000000oooo06T0oooo00280?ooo`0400000017<I@0Ac6D04La
U08000000P27aO`010000000c>k[00000000000209ASUP80000000<0i9=b0000003oool04@3oool4
000000@0M0TV0`00001Y0?ooo`00R03oool01P000000Ac6D04LaU017<I@0Tf:E00000080QlGl00@0
00000<c^j`00000000000P2DHiH010000000C3JF00000000000?0?ooo`<00000101d2BH400000080
Z6nA00<000000?ooo`3oool0I`3oool008P0oooo00@0000004LaU017<I@0Ac6D0`0000000`27aO`0
00000<c^j`0200000080U6>F00@0000004`fUP1<=YH000002`3oool400000080M0TV1@0000060:Q_
T@030000003oool0oooo06L0oooo00290?ooo`80Ac6D00@000000>>DMP00000000000P27aO`30000
0080U6>F00@0000004`fUP1<=YH000001`3oool40000000307@99P000000000000<00000302XKi40
0`000000oooo0?ooo`1V0?ooo`00R@3oool02017<I@000000>>DMP3SU7H000000;]kS@000000QlGl
0`00000309ASUP8000001P3oool20000000307@99P000000000000800000402XKi44000006H0oooo
00290?ooo`8000000P3SU7H00`000000^g^=00000004000000<0U6>F0P0000060?ooo`<00000402X
Ki44000000040;BF^00000000000000006H0oooo00290?ooo`8000000P3SU7H01@000000^g^=0;]k
S@000000QlGl008000000P2DHiH2000000L0oooo00<000000:Q_T@2XKi40302XKi44000000D0]9Jh
0`00001V0?ooo`00RP3oool01P000000hiAf0>>DMP3SU7H000000;]kS@P000001`3oool00`000000
Z6nA0:Q_T@080:Q_T@@000002P2dU[P2000006H0oooo002;0?ooo`80000000<0hiAf000000000000
1`0000000`33@P400000000000060?ooo`030000002XKi40Z6nA00<0Z6nA1000000>0;BF^0800000
IP3oool008d0oooo300000000`33@P4000000?ooo`040?ooo`030000002XKi40000000<000004P2d
U[P00`000000oooo0?ooo`1U0?ooo`00SP3oool:000000040>BCLP000000000000000080oooo1000
000A0;BF^0@0000000<0^K[J0000003oool0IP3oool00800oooo0`00000:0?ooo`X0000000@0^g^<
0000003TTg80i9=b1P00000>0;BF^0@000001@2i^]X00`000000oooo0?ooo`1U0?ooo`00O03oool4
00000080M0TV0P0000090?ooo`d0000000<0i9=b0000000000001000000:0;BF^0@000002P2i^]X0
0`000000oooo0?ooo`1T0?ooo`00N03oool4000000@0M0TV100000080?ooo`80000000<0Ac6D0000
000000000`0000001P31UZ/0000000000031UZ/000000>:bY0P000001@2dU[P4000000h0^K[J00<0
00000?ooo`3oool0I03oool007@0oooo1000000407@99P@000000P2XKi42000000P0oooo00<00000
04LaU017<I@01@0000040<6FZ`030000003R/Z@0h[:T00L0000000<0]9Jh0000000000000P00000<
0;VjfP@000000P2BioX00`000000oooo0?ooo`1T0?ooo`00L03oool4000000@0M0TV100000060:Q_
T@030000002i^MT0000000@0oooo100000000`17<I@0000000000005000000030<6FZ`0000000000
0080000000<0h[:T0000000000000P0000020?ooo`8000002`2i^]X50000000409;WnP0000000000
000006T0oooo001/0?ooo`@00000101d2BH4000000/0Z6nA2`00000207=^_P030000002RP[800000
00<000000P32Zl<00`000000fL?40000000200000005031^g000000000000?ooo`0000001`2i^]X:
000001P0oooo0P00001C0?ooo`00J03oool4000000@0M0TV1000000=0:Q_T@`000000`1cK[h20000
0080Zig900H000000<:[``32Zl<0`Z_30000003I`l@3000000<0<6kL00<000000?ooo`0000000P2i
^]X40000000309;WnP0000000000008000006@3oool5000005@0oooo001T0?ooo`@00000101d2BH4
000000d0Z6nA100000020;BF^0`0000000<0Lfjn0000000000000`2[WLT00`000000`Z_300000002
000000030>_[b`000000000000<0<6kL00<000000?ooo`0000000P0000000`2BioX0000000000002
000001T0oooo1P00001G0?ooo`00HP3oool2000000@0M0TV1000000=0:Q_T@@000001P2dU[P=0000
000408nGe`00000000000:^Mb@L0000000<0Ukcb0000000`K]`00P0`K]`2000000040?ooo`000000
0000000001T0oooo1P00001K0?ooo`00HP3oool00`000000M0TV00000003000000d0Z6nA1000000;
0;BF^0H000000`3oool>00000080Ukcb00<00000031^g00`K]`00P00000I0?ooo`H00000G`3oool0
0680oooo0P00000=0:Q_T@@000003`2dU[P2000000H0oooo00<000000?WW[`3iijl00P0000000`1L
UNd00000000000080000000309NllP000000<6kL0080<6kL00<000000?ooo`3oool04`3oool60000
06<0oooo001R0?ooo`030000002XKi40Z6nA00P0Z6nA1000000C0;BF^08000001P3oool01@000000
nNN_0?WW[`000000cmkT00L000000P2kNh`00`000000i9=b0000000200000080<6kL00<000000?oo
o`3oool03`3oool5000006P0oooo001R0?ooo`030000002XKi40Z6nA00@0Z6nA1000000A0;BF^0@0
00000P2i^]X2000000D0oooo00<000000?WW[`3iijl00P3iijl01P000000cmkT000000000000Tf:E
000000@0^g^<00<000000>BCLP3TTg800P3TTg82031^g0800000303oool5000006`0oooo001S0?oo
o`030000002XKi40000000<000004@2dU[P4000000L0^K[J0P0000040?ooo`030000003iijl0nNN_
0080nNN_0P00000409=RU@030000002kNh`0^g^<0080^g^<00@000000>BCLP3TTg80i9=b0P0`K]`2
000000P0oooo1@00001`0?ooo`00HP3oool300000140]9Jh1000000;0;VjfP8000001@3oool00`00
0000nNN_0?WW[`03000000@0Tf:E00<000000;]kS02kNh`00P2kNh`010000000i9=b0>BCLP3TTg82
000000030?WY[0000000oooo00<0oooo1@00001d0?ooo`00GP3oool6000000h0]9Jh1000000@0;Vj
fP030000003oool0oooo00<0oooo00<000000?WW[`0000000P17<I@00`000000Tf:E09=RU@0209=R
U@030000002kNh`0^g^<0080^g^<00@000000>BCLP3TTg80i9=b0P000000103ijJ`000000?ooo`3o
ool3000003<0oooo100000110?ooo`00FP3oool:000000X0]9Jh1000000>0;VjfP@000000P2BioX0
0`000000oooo0?ooo`040?ooo`8000000`17<I@01@000000Tf:E09=RU@2CHYD0000000@0^g^<00@0
00000>BCLP3TTg80i9=b0P0000000`3ijJ`000000000000c0?ooo`D00000A03oool005H0oooo3`00
00050;BF^0@000003P2i^]X400000080T^Oj0P0000090?ooo`8000000`17<I@00`000000Tf:E09=R
U@0209=RU@030000002kNh`0^g^<0080^g^<00@000000>BCLP3TTg8000000P3ijJ`2000002l0oooo
1@0000180?ooo`00DP3ooolC000000030;BF^00000000000008000003P2i^]X40000000409;WnP00
00000000000000d0oooo0`00000204LaU0030000002CHYD0Tf:E0080Tf:E00<000000;]kS02kNh`0
0P2kNh`01@000000i9=b0>BCLP3TTg8000000080nNV/00<000000?ooo`3oool0:@3oool5000004`0
oooo001B0?oooa40000000<0oooo0000000000003P2i^]X40000000409;WnP000000000000000180
oooo0P00000204LaU0030000002CHYD0Tf:E0080Tf:E00<000000;]kS02kNh`00P2kNh`01@000000
i9=b0>BCLP3TTg8000000080nNV/00<000000?ooo`3oool09@3oool500000500oooo001B0?ooo`d0
00001@3oool00`000000^K[J0;VjfP090;VjfPP000005P3oool200000080Ac6D00<0000009=RU@2C
HYD00P2CHYD00`000000^g^<0;]kS0020;]kS0050000003TTg80i9=b0>BCLP0000000P3ijJ`20000
0280oooo1@00001D0?ooo`00DP3oool9000000X0oooo00<000000;VjfP2i^]X0102i^]X8000001H0
oooo0P0000020?ooo`8000000`17<I@00`000000Tf:E09=RU@0209=RU@030000002kNh`0^g^<0080
^g^<00@000000>BCLP3TTg8000000`3ijJ`00`000000oooo0?ooo`0L0?ooo`D00000F03oool00580
oooo1@00000>0?ooo`030000002i^]X0^K[J00P000005P3oool4000000@0oooo00<0000002AXfP00
00000P17<I@00`000000Tf:E09=RU@0209=RU@030000002kNh`0^g^<0080^g^<00D000000>BCLP3T
Tg80i9=b000000020?WY[0030000003oool0oooo01P0oooo1000001M0?ooo`00IP3oool6000001H0
oooo100000090?ooo`8000000P17<I@00`000000Tf:E09=RU@0209=RU@030000002kNh`0^g^<0080
^g^<00D000000>BCLP3TTg80i9=b000000020?WY[0030000003oool0oooo01@0oooo1000001Q0?oo
o`00IP3oool2000001H0oooo1000000=0?ooo`8000000P17<I@00`000000Tf:E09=RU@0209=RU@03
0000002kNh`0^g^<0080^g^<00D000000>BCLP3TTg80i9=b000000020?WY[08000004@3oool40000
06D0oooo001j0?ooo`@000004@3oool2000000<0Ac6D00<0000009=RU@2CHYD00P2CHYD00`000000
^g^<0;]kS0020;]kS0040000003TTg80i9=b000000<0nNV/00<000000?ooo`3oool02`3oool40000
06T0oooo001f0?ooo`@000005P3oool200000080Ac6D00<0000009=RU@2CHYD00P2CHYD00`000000
^g^<0;]kS0020;]kS0050000003TTg80i9=b0>BCLP0000000P3ijJ`00`000000oooo0?ooo`070?oo
o`@00000K@3oool00780oooo1@00000I0?ooo`8000000P17<I@00`000000Tf:E09=RU@0209=RU@03
0000002kNh`0^g^<0080^g^<00D000000>BCLP3TTg80i9=b000000020?WY[0800000103oool40000
0740oooo001^0?ooo`D000007@3oool200000080Ac6D00<0000009=RU@2CHYD00P2CHYD00`000000
^g^<0;]kS0020;]kS0060000003TTg80i9=b0>BCLP000000nNV/0`000000103oool0000000000000
001e0?ooo`00JP3oool500000240oooo0P00000204LaU0030000002CHYD0Tf:E00<0Tf:E00<00000
0;]kS02kNh`00P2kNh`020000000i9=b0>BCLP000000nNV/0000003oool00000N@3oool006H0oooo
1@00000V0?ooo`8000000P17<I@409=RU@P000000P3TTg8010000000oooo00000000001i0?ooo`00
I03oool3000002X0oooo0P00000204LaU080Tf:E0P0000000`2kNhd000000000000409ASUP@00000
00<0oooo000000000000N@3oool00940oooo0P00000204LaU08000000`2kNhd2000000@0U6>F00<0
000004`fUP0000000P0000020?WY[0030000003oool0oooo07H0oooo002B0?ooo`0500000017<I@0
00000>>DMP0000000`2kNhd2000000@0U6>F00<0000004`fUP1<=YH00P0000020?WY[0030000003o
ool0oooo07H0oooo002>0?ooo`<0000000H0oooo00000017<I@000000>>DMP0000030;]kS@<00000
0`2DHiH010000000C3JF04`fUP0000030?WY[0030000003oool0oooo07H0oooo002:0?ooo`@00000
103oool200000080hiAf00<000000;]kS@2kNhd00P2kNhd2000000@0U6>F0`0000030?WY[0030000
003oool0oooo07H0oooo00260?ooo`@00000203oool200000080hiAf00<000000;]kS@2kNhd00P2k
Nhd2000000<0U6>F0P0000001@3?hND000000?WY[03ijJ`0000007T0oooo00220?ooo`@000003@3o
ool200000080hiAf00@000000;]kS@2kNhd0^g^=0P0000000`2DHiH00000000000030<oQi@040000
003ijJ`0nNV/000007T0oooo001n0?ooo`@000004@3oool3000000040>>DMP000000^g^=0;]kS@@0
00001P3?hND2000007X0oooo001j0?ooo`@000005@3oool00`00000096SJ02AXfP0400000080U;kd
0`0000050<oQi@800000NP3oool007D0oooo1@00000J0?ooo`040000000TJ=X096SJ000000@0U;kd
0`0000050<oQi@030000003oool0oooo07T0oooo001a0?ooo`D000007`3oool3000000@0U;kd0`00
00030<oQi@800000O03oool006d0oooo1@00000U0?ooo`8000000`2D__@6000007h0oooo001Y0?oo
o`D00000:P3oool9000000030?CI/P000000oooo07`0oooo001U0?ooo`D00000<P3oool300000005
09jdi`00000000000?CI/P000000O03oool00640oooo1@00000f0?ooo`<0000000D0W[CW00000000
0000m=Vb0000001l0?ooo`00G@3oool5000003X0oooo1@000000103>dM/000000?CI/P00001k0?oo
o`00FP3oool4000003h0oooo0`00000209jdi`80000000<0m=Vb0000003oool0NP3oool009`0oooo
0P000000201?MMP0000009jdi`000000c]7K0000003dfK800000NP3oool009`0oooo0P000000201?
MMP0000009jdi`000000c]7K0000003dfK800000NP3oool009d0oooo00D0000004mef0000000W[CW
000000020<kAf`030000003oool0oooo07T0oooo002N0?ooo`8000000P2N]>L3000007/0oooo002O
0?ooo`@00000O@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.43498 .63972 m .57528 .62118 L .60277 .62226 L p .183 0 0 r
F P
0 g
s
.60277 .62226 m .462 .64112 L .43498 .63972 L p .183 0 0 r
F P
0 g
s
.35899 .6995 m .36238 .708 L .40142 .65736 L closepath p .352 .33 .695 r
F P
0 g
s
.35175 .6933 m .35899 .6995 L .40142 .65736 L closepath p .512 .585 .865 r
F P
0 g
s
.34341 .69175 m .35175 .6933 L .40142 .65736 L closepath p .608 .818 .98 r
F P
0 g
s
.36238 .708 m .36064 .71559 L .40142 .65736 L closepath p 0 0 .217 r
F P
0 g
s
.33711 .69545 m .34341 .69175 L .40142 .65736 L closepath p .363 .793 .612 r
F P
0 g
s
.36064 .71559 m .35439 .71938 L .40142 .65736 L closepath p .809 .999 .844 r
F P
0 g
s
.33529 .70305 m .33711 .69545 L .40142 .65736 L closepath p .303 .078 .398 r
F P
0 g
s
.35439 .71938 m .34599 .71787 L .40142 .65736 L closepath p .725 .789 .903 r
F P
0 g
s
.33869 .71162 m .33529 .70305 L .40142 .65736 L closepath p .506 .414 .686 r
F P
0 g
s
.34599 .71787 m .33869 .71162 L .40142 .65736 L closepath p .616 .603 .815 r
F P
0 g
s
.48902 .46264 m .54053 .34244 L .56364 .31894 L p 0 0 .079 r
F P
0 g
s
.46677 .63367 m .46319 .65178 L p .5093 .59822 L .167 0 .346 r
F P
0 g
s
.5862 .58428 m .61209 .58484 L p .49103 .59571 L .138 0 0 r
F P
0 g
s
.49044 .59563 m .5862 .58428 L p .49103 .59571 L .138 0 0 r
F P
0 g
s
.61209 .58484 m .51135 .59692 L .49679 .5965 L p .138 0 0 r
F P
0 g
s
.49679 .5965 m .48574 .59619 L p .49103 .59571 L .138 0 0 r
F P
0 g
s
.61209 .58484 m .49679 .5965 L .49103 .59571 L .138 0 0 r
F
.46319 .65178 m .5161 .60479 L .5171 .59929 L p .167 0 .346 r
F P
0 g
s
.5171 .59929 m .51943 .58646 L p .5093 .59822 L .167 0 .346 r
F P
0 g
s
.46319 .65178 m .5171 .59929 L .5093 .59822 L .167 0 .346 r
F
.51943 .58646 m .50671 .59786 L p .5093 .59822 L F P
0 g
s
.50671 .59786 m .46677 .63367 L p .5093 .59822 L .167 0 .346 r
F P
0 g
s
.48574 .59619 m .49044 .59563 L p .49103 .59571 L .138 0 0 r
F P
0 g
s
.03 w
.40142 .65736 m
.41508 .64484 L
s
.5 Mabswid
.48629 .44779 m .47125 .45557 L p .48531 .47432 L .638 .48 .652 r
F P
0 g
s
.51556 .51468 m .49301 .46316 L p .48531 .47432 L .638 .48 .652 r
F P
0 g
s
.56364 .31894 m .51813 .42677 L p .48902 .46264 L 0 0 .079 r
F P
0 g
s
.50247 .44945 m .48902 .46264 L p .51813 .42677 L 0 0 .079 r
F P
0 g
s
.49301 .46316 m .48629 .44779 L p .48531 .47432 L .638 .48 .652 r
F P
0 g
s
.51813 .42677 m .51285 .43929 L .50247 .44945 L p 0 0 .079 r
F P
0 g
s
.4323 .60576 m .41043 .6261 L .42768 .64102 L p .576 .597 .837 r
F P
0 g
s
.42768 .64102 m .44974 .62089 L .4323 .60576 L p .576 .597 .837 r
F P
0 g
s
.44974 .62089 m .42768 .64102 L .43605 .66122 L p .448 .385 .694 r
F P
0 g
s
.41241 .60153 m .39068 .62202 L .41043 .6261 L p .683 .803 .939 r
F P
0 g
s
.41043 .6261 m .4323 .60576 L .41241 .60153 L p .683 .803 .939 r
F P
0 g
s
.43605 .66122 m .45829 .64128 L .44974 .62089 L p .448 .385 .694 r
F P
0 g
s
.45829 .64128 m .43605 .66122 L .43233 .67919 L p .167 0 .346 r
F P
0 g
s
.39754 .60993 m .37583 .63046 L .39068 .62202 L p .669 .971 .805 r
F P
0 g
s
.39068 .62202 m .41241 .60153 L .39754 .60993 L p .669 .971 .805 r
F P
0 g
s
.43233 .67919 m .45467 .65935 L .45829 .64128 L p .167 0 .346 r
F P
0 g
s
.45467 .65935 m .43233 .67919 L .41774 .68808 L p .62 .947 .76 r
F P
0 g
s
.39348 .62798 m .37168 .64843 L .37583 .63046 L p .122 0 .312 r
F P
0 g
s
.37583 .63046 m .39754 .60993 L .39348 .62798 L p .122 0 .312 r
F P
0 g
s
.41774 .68808 m .44005 .66821 L .45467 .65935 L p .62 .947 .76 r
F P
0 g
s
.44005 .66821 m .41774 .68808 L .39771 .68426 L p .678 .811 .947 r
F P
0 g
s
.49241 .54985 m .44064 .598 L .45815 .61321 L p .576 .597 .837 r
F P
0 g
s
.45815 .61321 m .51038 .56557 L .49241 .54985 L p .576 .597 .837 r
F P
0 g
s
.51038 .56557 m .45815 .61321 L .46677 .63367 L p .448 .385 .694 r
F P
0 g
s
.47217 .54516 m .4207 .59371 L .44064 .598 L p .683 .803 .939 r
F P
0 g
s
.44064 .598 m .49241 .54985 L .47217 .54516 L p .683 .803 .939 r
F P
0 g
s
.40201 .64881 m .38003 .66906 L .37168 .64843 L p .434 .374 .691 r
F P
0 g
s
.37168 .64843 m .39348 .62798 L .40201 .64881 L p .434 .374 .691 r
F P
0 g
s
.46677 .63367 m .51943 .58646 L .51038 .56557 L p .448 .385 .694 r
F P
0 g
s
.39771 .68426 m .41988 .66423 L .44005 .66821 L p .678 .811 .947 r
F P
0 g
s
.41988 .66423 m .39771 .68426 L .38003 .66906 L p .569 .597 .842 r
F P
0 g
s
.20346 .67031 m .36767 .64861 L .39439 .65017 L p .183 0 0 r
F P
0 g
s
.38003 .66906 m .40201 .64881 L .41988 .66423 L p .569 .597 .842 r
F P
0 g
s
.45723 .55343 m .40582 .60209 L .4207 .59371 L p .669 .971 .805 r
F P
0 g
s
.4207 .59371 m .47217 .54516 L .45723 .55343 L p .669 .971 .805 r
F P
0 g
s
.5161 .60479 m .46319 .65178 L .44857 .66062 L p .62 .947 .76 r
F P
0 g
s
.40179 .62018 m .40582 .60209 L p .40655 .60162 L .122 0 .312 r
F P
0 g
s
.41939 .60367 m .40179 .62018 L p .40655 .60162 L .122 0 .312 r
F P
0 g
s
.40179 .62018 m .45344 .57172 L .46248 .59309 L p .434 .374 .691 r
F P
0 g
s
.29986 .61822 m .41433 .60465 L .42859 .60513 L p .138 0 0 r
F P
0 g
s
.46248 .59309 m .4104 .64108 L .40179 .62018 L p .434 .374 .691 r
F P
0 g
s
.42859 .60513 m .43969 .60551 L p .43412 .60602 L .138 0 0 r
F P
0 g
s
.43412 .60602 m .29986 .61822 L .42859 .60513 L .138 0 0 r
F
.45344 .57172 m .41939 .60367 L p .40655 .60162 L .122 0 .312 r
F P
0 g
s
.40582 .60209 m .45723 .55343 L .45344 .57172 L p .122 0 .312 r
F P
0 g
s
.53311 .55356 m .59037 .54757 L .59066 .5308 L p .86 .726 .713 r
F P
0 g
s
.59037 .54757 m .53311 .55356 L .53967 .56854 L p .83 .562 .532 r
F P
0 g
s
.53967 .56854 m .59693 .56222 L .59037 .54757 L p .83 .562 .532 r
F P
0 g
s
.53335 .53643 m .59066 .5308 L .5977 .51819 L p .825 .867 .876 r
F P
0 g
s
.59066 .5308 m .53335 .53643 L .53311 .55356 L p .86 .726 .713 r
F P
0 g
s
.59693 .56222 m .53967 .56854 L .5506 .57574 L p .663 .204 .152 r
F P
0 g
s
.5506 .57574 m .60791 .56923 L .59693 .56222 L p .663 .204 .152 r
F P
0 g
s
.44857 .66062 m .50144 .61353 L .5161 .60479 L p .62 .947 .76 r
F P
0 g
s
.50144 .61353 m .44857 .66062 L .42835 .65659 L p .678 .811 .947 r
F P
0 g
s
.54031 .52355 m .5977 .51819 L .6089 .51453 L p .386 .842 .905 r
F P
0 g
s
.5977 .51819 m .54031 .52355 L .53335 .53643 L p .825 .867 .876 r
F P
0 g
s
.39439 .65017 m .22928 .67229 L .20346 .67031 L p .183 0 0 r
F P
0 g
s
.60791 .56923 m .5506 .57574 L .56182 .57232 L p .342 .82 .874 r
F P
0 g
s
.56182 .57232 m .61919 .56585 L .60791 .56923 L p .342 .82 .874 r
F P
0 g
s
.42835 .65659 m .48091 .60912 L .50144 .61353 L p .678 .811 .947 r
F P
0 g
s
.48091 .60912 m .42835 .65659 L .4104 .64108 L p .569 .597 .842 r
F P
0 g
s
.4104 .64108 m .46248 .59309 L .48091 .60912 L p .569 .597 .842 r
F P
0 g
s
.03 w
.46713 .59713 m
.49911 .5678 L
s
.5 Mabswid
.6089 .51453 m .55143 .51984 L .54031 .52355 L p .386 .842 .905 r
F P
0 g
s
.55143 .51984 m .6089 .51453 L .62003 .52136 L p .654 .182 .121 r
F P
0 g
s
.61919 .56585 m .56182 .57232 L .56898 .55944 L p .827 .875 .88 r
F P
0 g
s
.56898 .55944 m .62643 .55322 L .61919 .56585 L p .827 .875 .88 r
F P
0 g
s
.50032 .52246 m .47125 .45557 L .45593 .45917 L p .763 .536 .589 r
F P
0 g
s
.47125 .45557 m .50032 .52246 L .51556 .51468 L p .638 .48 .652 r
F P
0 g
s
.56252 .52686 m .62003 .52136 L .62676 .53617 L p .833 .56 .525 r
F P
0 g
s
.62003 .52136 m .56252 .52686 L .55143 .51984 L p .654 .182 .121 r
F P
0 g
s
.48629 .44779 m .51556 .51468 L .52498 .50585 L p .446 .383 .693 r
F P
0 g
s
.52498 .50585 m .49545 .43872 L .48629 .44779 L p .446 .383 .693 r
F P
0 g
s
.62643 .55322 m .56898 .55944 L .56926 .54202 L p .864 .73 .713 r
F P
0 g
s
.02 w
.55198 .54774 m
.56919 .54596 L
s
.5 Mabswid
.56926 .54202 m .62676 .53617 L .62643 .55322 L p .864 .73 .713 r
F P
0 g
s
.48491 .52632 m .45593 .45917 L .44605 .45723 L p .907 .581 .416 r
F P
0 g
s
.45593 .45917 m .48491 .52632 L .50032 .52246 L p .763 .536 .589 r
F P
0 g
s
.62676 .53617 m .56926 .54202 L .56252 .52686 L p .833 .56 .525 r
F P
0 g
s
.49545 .43872 m .52498 .50585 L .52494 .49929 L p 0 0 .533 r
F P
0 g
s
.52494 .49929 m .49521 .43176 L .49545 .43872 L p 0 0 .533 r
F P
0 g
s
.44605 .45723 m .4751 .52477 L .48491 .52632 L p .907 .581 .416 r
F P
0 g
s
.44605 .45723 m .44546 .45038 L p .45333 .47013 L 0 0 .497 r
F P
0 g
s
.47471 .51833 m .44546 .45038 L .45455 .44119 L p .436 .376 .692 r
F P
0 g
s
.44546 .45038 m .47471 .51833 L .4751 .52477 L p 0 0 .497 r
F P
0 g
s
.2682 .34927 m .43523 .46636 L .44855 .45293 L p .604 .645 .864 r
F P
0 g
s
.48406 .50938 m .45455 .44119 L .46989 .43323 L p .636 .477 .65 r
F P
0 g
s
.45455 .44119 m .48406 .50938 L .47471 .51833 L p .436 .376 .692 r
F P
0 g
s
.44855 .45293 m .45882 .44258 L p .44361 .43513 L .604 .645 .864 r
F P
0 g
s
.44361 .43513 m .2682 .34927 L .44855 .45293 L .604 .645 .864 r
F
.4751 .52477 m .45648 .48147 L p .45333 .47013 L 0 0 .497 r
F P
0 g
s
.45648 .48147 m .44605 .45723 L p .45333 .47013 L 0 0 .497 r
F P
0 g
s
.49521 .43176 m .52494 .49929 L .51528 .49756 L p .911 .577 .4 r
F P
0 g
s
.51528 .49756 m .48547 .42963 L .49521 .43176 L p .911 .577 .4 r
F P
0 g
s
.50451 .57049 m .49979 .55955 L .51485 .55567 L p .763 .536 .589 r
F P
0 g
s
.51485 .55567 m .51958 .56657 L .50451 .57049 L p .763 .536 .589 r
F P
0 g
s
.51056 .54394 m .51485 .55567 L .49979 .55955 L p .794 .64 .691 r
F P
0 g
s
.51958 .56657 m .51485 .55567 L .52982 .54808 L p .638 .48 .652 r
F P
0 g
s
.02 w
.54147 .54882 m
.55198 .54774 L
s
.5 Mabswid
.51485 .55567 m .51056 .54394 L .52256 .53784 L p .683 .584 .738 r
F P
0 g
s
.52256 .53784 m .52982 .54808 L .51485 .55567 L p .683 .584 .738 r
F P
0 g
s
.49979 .55955 m .49847 .54703 L .51056 .54394 L p .794 .64 .691 r
F P
0 g
s
.50753 .53363 m .51056 .54394 L .49847 .54703 L p .809 .738 .785 r
F P
0 g
s
.51056 .54394 m .50753 .53363 L .5142 .53023 L p .72 .689 .819 r
F P
0 g
s
.5142 .53023 m .52256 .53784 L .51056 .54394 L p .72 .689 .819 r
F P
0 g
s
.52982 .54808 m .53458 .55897 L .51958 .56657 L p .638 .48 .652 r
F P
0 g
s
.53458 .55897 m .52982 .54808 L .53912 .53959 L p .446 .383 .693 r
F P
0 g
s
.52982 .54808 m .52256 .53784 L .52998 .531 L p .539 .536 .799 r
F P
0 g
s
.52998 .531 m .53912 .53959 L .52982 .54808 L p .539 .536 .799 r
F P
0 g
s
.52256 .53784 m .5142 .53023 L .51831 .52641 L p .617 .673 .881 r
F P
0 g
s
.51831 .52641 m .52998 .531 L .52256 .53784 L p .617 .673 .881 r
F P
0 g
s
.51173 .5777 m .50451 .57049 L .51958 .56657 L p .697 .378 .433 r
F P
0 g
s
.51958 .56657 m .52385 .57452 L .51173 .5777 L p .697 .378 .433 r
F P
0 g
s
.52385 .57452 m .51958 .56657 L .53458 .55897 L p .561 .329 .52 r
F P
0 g
s
.43969 .60551 m .32469 .6193 L .29986 .61822 L p .138 0 0 r
F P
0 g
s
.48547 .42963 m .51528 .49756 L .49962 .50141 L p .764 .534 .585 r
F P
0 g
s
.49962 .50141 m .46989 .43323 L .48547 .42963 L p .764 .534 .585 r
F P
0 g
s
.01 w
.47474 .45408 m
.49312 .49632 L
s
.5 Mabswid
.49847 .54703 m .5008 .53533 L .50753 .53363 L p .809 .738 .785 r
F P
0 g
s
.49027 .55824 m .49083 .54592 L .49847 .54703 L p .933 .736 .614 r
F P
0 g
s
.49847 .54703 m .49979 .55955 L .49027 .55824 L p .933 .736 .614 r
F P
0 g
s
.5008 .53533 m .49847 .54703 L .49083 .54592 L p .91 .84 .764 r
F P
0 g
s
.53458 .55897 m .53592 .56842 L .52385 .57452 L p .561 .329 .52 r
F P
0 g
s
.53592 .56842 m .53458 .55897 L .54393 .55053 L p .289 .144 .504 r
F P
0 g
s
.53912 .53959 m .54393 .55053 L .53458 .55897 L p .446 .383 .693 r
F P
0 g
s
.495 .56924 m .49027 .55824 L .49979 .55955 L p .907 .581 .416 r
F P
0 g
s
.49979 .55955 m .50451 .57049 L .495 .56924 L p .907 .581 .416 r
F P
0 g
s
.03 w
.50215 .56502 m
.50251 .56468 L
s
.5 Mabswid
.5142 .53023 m .50753 .53363 L .5008 .53533 L p .726 .928 .958 r
F P
0 g
s
.51831 .52641 m .5142 .53023 L p .5008 .53533 L .726 .928 .958 r
F P
0 g
s
.51827 .52362 m .51831 .52641 L p .5008 .53533 L .726 .928 .958 r
F P
0 g
s
.51407 .52294 m .51827 .52362 L p .5008 .53533 L .726 .928 .958 r
F P
0 g
s
.5073 .52464 m .51407 .52294 L p .5008 .53533 L .726 .928 .958 r
F P
0 g
s
.50056 .52808 m .5073 .52464 L p .5008 .53533 L .726 .928 .958 r
F P
0 g
s
.01 w
.50372 .52068 m
.50578 .52541 L
s
.5 Mabswid
.49647 .53191 m .50056 .52808 L p .5008 .53533 L .726 .928 .958 r
F P
0 g
s
.5008 .53533 m .49657 .53468 L .49647 .53191 L p .726 .928 .958 r
F P
0 g
s
.49083 .54592 m .49657 .53468 L .5008 .53533 L p .91 .84 .764 r
F P
0 g
s
.50412 .57673 m .495 .56924 L .50451 .57049 L p .768 .28 .069 r
F P
0 g
s
.50451 .57049 m .51173 .5777 L .50412 .57673 L p .768 .28 .069 r
F P
0 g
s
.53912 .53959 m .52998 .531 L .52998 .52599 L p .116 .392 .847 r
F P
0 g
s
.52998 .531 m .51831 .52641 L .51827 .52362 L p .408 .674 .97 r
F P
0 g
s
.51827 .52362 m .52998 .52599 L .52998 .531 L p .408 .674 .97 r
F P
0 g
s
.52006 .57974 m .51173 .5777 L .52385 .57452 L p .463 0 .039 r
F P
0 g
s
.01 w
.53054 .58231 m
.53458 .59159 L
s
.5 Mabswid
.52385 .57452 m .52681 .57797 L .52006 .57974 L p .463 0 .039 r
F P
0 g
s
.52681 .57797 m .52385 .57452 L .53592 .56842 L p .337 0 .182 r
F P
0 g
s
.46989 .43323 m .49962 .50141 L .48406 .50938 L p .636 .477 .65 r
F P
0 g
s
.01 w
.49612 .50321 m
.50372 .52068 L
s
.5 Mabswid
.54393 .55053 m .53912 .53959 L .53918 .5334 L p 0 0 .533 r
F P
0 g
s
.52998 .52599 m .53918 .5334 L .53912 .53959 L p .116 .392 .847 r
F P
0 g
s
.53592 .56842 m .53354 .57457 L .52681 .57797 L p .337 0 .182 r
F P
0 g
s
.53354 .57457 m .53592 .56842 L .54344 .56167 L p 0 0 0 r
F P
0 g
s
.54393 .55053 m .54344 .56167 L .53592 .56842 L p .289 .144 .504 r
F P
0 g
s
.56485 .67098 m .53434 .60077 L .51884 .60492 L p .763 .536 .589 r
F P
0 g
s
.53434 .60077 m .56485 .67098 L .58055 .66319 L p .638 .48 .652 r
F P
0 g
s
.58055 .66319 m .54983 .59299 L .53434 .60077 L p .638 .48 .652 r
F P
0 g
s
.49061 .54098 m .49647 .53191 L .49657 .53468 L p .913 .962 .64 r
F P
0 g
s
.49657 .53468 m .49083 .54592 L .49061 .54098 L p .913 .962 .64 r
F P
0 g
s
.48999 .55216 m .49061 .54098 L .49083 .54592 L p .779 .658 .103 r
F P
0 g
s
.02 w
.48121 .55504 m
.48944 .55419 L
s
.5 Mabswid
.49083 .54592 m .49027 .55824 L .48999 .55216 L p .779 .658 .103 r
F P
0 g
s
.53918 .5334 m .54402 .54439 L .54393 .55053 L p 0 0 .533 r
F P
0 g
s
.54344 .56167 m .54393 .55053 L .54402 .54439 L p .728 .616 .049 r
F P
0 g
s
.51586 .57921 m .50412 .57673 L .51173 .5777 L p .238 0 0 r
F P
0 g
s
.51173 .5777 m .52006 .57974 L .51586 .57921 L p .238 0 0 r
F P
0 g
s
.54983 .59299 m .58055 .66319 L .59054 .65493 L p .446 .383 .693 r
F P
0 g
s
.59054 .65493 m .55954 .58445 L .54983 .59299 L p .446 .383 .693 r
F P
0 g
s
.49475 .56322 m .48999 .55216 L .49027 .55824 L p 0 0 .497 r
F P
0 g
s
.49027 .55824 m .495 .56924 L .49475 .56322 L p 0 0 .497 r
F P
0 g
s
.52998 .52599 m .51827 .52362 L .51407 .52294 L p .184 0 0 r
F P
0 g
s
.54927 .6754 m .51884 .60492 L .50912 .60386 L p .907 .581 .416 r
F P
0 g
s
.51884 .60492 m .54927 .6754 L .56485 .67098 L p .763 .536 .589 r
F P
0 g
s
.498 .53407 m .50056 .52808 L .49647 .53191 L p 0 0 0 r
F P
0 g
s
.49647 .53191 m .49061 .54098 L .498 .53407 L p 0 0 0 r
F P
0 g
s
.54344 .56167 m .53772 .57082 L .53354 .57457 L p 0 0 0 r
F P
0 g
s
.53772 .57082 m .54344 .56167 L .54351 .55681 L p .895 .955 .613 r
F P
0 g
s
.54402 .54439 m .54351 .55681 L .54344 .56167 L p .728 .616 .049 r
F P
0 g
s
.51586 .57921 m .52006 .57974 L .52681 .57797 L p .718 .935 .959 r
F P
0 g
s
.51581 .57656 m .51586 .57921 L p .52681 .57797 L .718 .935 .959 r
F P
0 g
s
.51998 .5728 m .51581 .57656 L p .52681 .57797 L .718 .935 .959 r
F P
0 g
s
.52677 .56936 m .51998 .5728 L p .52681 .57797 L .718 .935 .959 r
F P
0 g
s
.53357 .56759 m .52677 .56936 L p .52681 .57797 L .718 .935 .959 r
F P
0 g
s
.53774 .56815 m .53357 .56759 L p .52681 .57797 L .718 .935 .959 r
F P
0 g
s
.53772 .57082 m .53774 .56815 L p .52681 .57797 L .718 .935 .959 r
F P
0 g
s
.52681 .57797 m .53354 .57457 L .53772 .57082 L p .718 .935 .959 r
F P
0 g
s
.01 w
.52679 .57369 m
.53054 .58231 L
s
.5 Mabswid
.50398 .57195 m .49475 .56322 L .495 .56924 L p .077 .373 .838 r
F P
0 g
s
.495 .56924 m .50412 .57673 L .50398 .57195 L p .077 .373 .838 r
F P
0 g
s
.53918 .5334 m .52998 .52599 L .52244 .52477 L p .757 .257 .029 r
F P
0 g
s
.51407 .52294 m .52244 .52477 L .52998 .52599 L p .184 0 0 r
F P
0 g
s
.52244 .52477 m .51407 .52294 L .5073 .52464 L p .441 0 0 r
F P
0 g
s
.45882 .44258 m .28999 .3234 L .2682 .34927 L p .604 .645 .864 r
F P
0 g
s
.51019 .52785 m .5073 .52464 L .50056 .52808 L p .312 0 .151 r
F P
0 g
s
.50056 .52808 m .498 .53407 L .51019 .52785 L p .312 0 .151 r
F P
0 g
s
.51581 .57656 m .50398 .57195 L .50412 .57673 L p .387 .671 .972 r
F P
0 g
s
.50412 .57673 m .51586 .57921 L .51581 .57656 L p .387 .671 .972 r
F P
0 g
s
.54402 .54439 m .53918 .5334 L .5298 .53191 L p .911 .577 .4 r
F P
0 g
s
.52244 .52477 m .5298 .53191 L .53918 .5334 L p .757 .257 .029 r
F P
0 g
s
.01 w
.50745 .52925 m
.52524 .57013 L
s
.5 Mabswid
.5073 .52464 m .51019 .52785 L .52244 .52477 L p .441 0 0 r
F P
0 g
s
.49923 .54356 m .498 .53407 L .49061 .54098 L p .269 .124 .492 r
F P
0 g
s
.49061 .54098 m .48999 .55216 L .49923 .54356 L p .269 .124 .492 r
F P
0 g
s
.55954 .58445 m .59054 .65493 L .59097 .64929 L p 0 0 .533 r
F P
0 g
s
.59097 .64929 m .55975 .57837 L .55954 .58445 L p 0 0 .533 r
F P
0 g
s
.54351 .55681 m .53774 .56815 L .53772 .57082 L p .895 .955 .613 r
F P
0 g
s
.54351 .55681 m .54402 .54439 L .53466 .54298 L p .938 .74 .609 r
F P
0 g
s
.5298 .53191 m .53466 .54298 L .54402 .54439 L p .911 .577 .4 r
F P
0 g
s
.5298 .53191 m .52244 .52477 L .51019 .52785 L p .695 .37 .422 r
F P
0 g
s
.50403 .55467 m .49923 .54356 L .48999 .55216 L p .437 .376 .692 r
F P
0 g
s
.48999 .55216 m .49475 .56322 L .50403 .55467 L p .437 .376 .692 r
F P
0 g
s
.02 w
.48944 .55419 m
.4922 .5539 L
s
.4922 .5539 m
.49476 .55364 L
s
.49476 .55364 m
.49699 .55341 L
s
.5 Mabswid
.53774 .56815 m .54351 .55681 L .536 .55573 L p .915 .848 .763 r
F P
0 g
s
.53466 .54298 m .536 .55573 L .54351 .55681 L p .938 .74 .609 r
F P
0 g
s
.02 w
.50321 .55277 m
.53534 .54946 L
s
.5 Mabswid
.50912 .60386 m .53963 .67478 L .54927 .6754 L p .907 .581 .416 r
F P
0 g
s
.53963 .67478 m .50912 .60386 L .50897 .5979 L p 0 0 .497 r
F P
0 g
s
.536 .55573 m .53357 .56759 L .53774 .56815 L p .915 .848 .763 r
F P
0 g
s
.51449 .5358 m .51019 .52785 L .498 .53407 L p .556 .32 .514 r
F P
0 g
s
.498 .53407 m .49923 .54356 L .51449 .5358 L p .556 .32 .514 r
F P
0 g
s
.51146 .56512 m .50403 .55467 L .49475 .56322 L p .534 .534 .801 r
F P
0 g
s
.03 w
.50251 .56468 m
.50307 .56417 L
s
.5 Mabswid
.49475 .56322 m .50398 .57195 L .51146 .56512 L p .534 .534 .801 r
F P
0 g
s
.50398 .57195 m .51581 .57656 L .51998 .5728 L p .613 .675 .885 r
F P
0 g
s
.51019 .52785 m .51449 .5358 L .5298 .53191 L p .695 .37 .422 r
F P
0 g
s
.51998 .5728 m .51146 .56512 L .50398 .57195 L p .613 .675 .885 r
F P
0 g
s
.36413 .57123 m .45566 .56166 L .45583 .54403 L p .86 .726 .713 r
F P
0 g
s
.45566 .56166 m .36413 .57123 L .37066 .58722 L p .83 .562 .532 r
F P
0 g
s
.37066 .58722 m .46222 .5771 L .45566 .56166 L p .83 .562 .532 r
F P
0 g
s
.53466 .54298 m .5298 .53191 L .51449 .5358 L p .764 .534 .586 r
F P
0 g
s
.03 w
.50774 .55989 m
.52856 .5408 L
s
.5 Mabswid
.53357 .56759 m .536 .55573 L .52373 .55891 L p .811 .742 .787 r
F P
0 g
s
.52373 .55891 m .52677 .56936 L .53357 .56759 L p .811 .742 .787 r
F P
0 g
s
.3642 .55302 m .45583 .54403 L .46267 .53081 L p .825 .867 .876 r
F P
0 g
s
.45583 .54403 m .3642 .55302 L .36413 .57123 L p .86 .726 .713 r
F P
0 g
s
.51146 .56512 m .51998 .5728 L .52677 .56936 L p .72 .691 .822 r
F P
0 g
s
.59961 .46464 m .59064 .46229 L .53262 .53708 L closepath p .724 .793 .907 r
F P
0 g
s
.60777 .47188 m .59961 .46464 L .53262 .53708 L closepath p .614 .604 .817 r
F P
0 g
s
.61206 .48128 m .60777 .47188 L .53262 .53708 L closepath p .501 .411 .685 r
F P
0 g
s
.61084 .4893 m .61206 .48128 L .53262 .53708 L closepath p .289 .062 .386 r
F P
0 g
s
.60452 .49287 m .61084 .4893 L .53262 .53708 L closepath p .4 .823 .649 r
F P
0 g
s
.59549 .49057 m .60452 .49287 L .53262 .53708 L closepath p .615 .814 .977 r
F P
0 g
s
.58723 .48326 m .59549 .49057 L .53262 .53708 L closepath p .518 .586 .863 r
F P
0 g
s
.58294 .47377 m .58723 .48326 L .53262 .53708 L closepath p .362 .337 .696 r
F P
0 g
s
.59064 .46229 m .58426 .46576 L .53262 .53708 L closepath p .799 .999 .835 r
F P
0 g
s
.58426 .46576 m .58294 .47377 L .53262 .53708 L closepath p 0 0 .241 r
F P
0 g
s
.03 w
.53223 .53744 m
.53262 .53708 L
s
.5 Mabswid
.55975 .57837 m .59097 .64929 L .5815 .64849 L p .911 .577 .4 r
F P
0 g
s
.5815 .64849 m .55019 .57712 L .55975 .57837 L p .911 .577 .4 r
F P
0 g
s
.52677 .56936 m .52373 .55891 L .51146 .56512 L p .72 .691 .822 r
F P
0 g
s
.536 .55573 m .53466 .54298 L .51933 .5469 L p .796 .641 .69 r
F P
0 g
s
.51449 .5358 m .51933 .5469 L .53466 .54298 L p .764 .534 .586 r
F P
0 g
s
.51933 .5469 m .51449 .5358 L .49923 .54356 L p .636 .477 .65 r
F P
0 g
s
.49923 .54356 m .50403 .55467 L .51933 .5469 L p .636 .477 .65 r
F P
0 g
s
.51933 .5469 m .52373 .55891 L .536 .55573 L p .796 .641 .69 r
F P
0 g
s
.46222 .5771 m .37066 .58722 L .3814 .59498 L p .663 .204 .152 r
F P
0 g
s
.3814 .59498 m .47307 .58456 L .46222 .5771 L p .663 .204 .152 r
F P
0 g
s
.50403 .55467 m .51146 .56512 L .52373 .55891 L p .683 .584 .739 r
F P
0 g
s
.52373 .55891 m .51933 .5469 L .50403 .55467 L p .683 .584 .739 r
F P
0 g
s
.5397 .66926 m .50897 .5979 L .51862 .58925 L p .436 .376 .692 r
F P
0 g
s
.50897 .5979 m .5397 .66926 L .53963 .67478 L p 0 0 .497 r
F P
0 g
s
.37088 .5394 m .46267 .53081 L .47367 .52704 L p .386 .842 .905 r
F P
0 g
s
.46267 .53081 m .37088 .5394 L .3642 .55302 L p .825 .867 .876 r
F P
0 g
s
.47307 .58456 m .3814 .59498 L .39232 .59145 L p .342 .82 .874 r
F P
0 g
s
.39232 .59145 m .48417 .58108 L .47307 .58456 L p .342 .82 .874 r
F P
0 g
s
.55019 .57712 m .5815 .64849 L .56566 .65292 L p .764 .534 .585 r
F P
0 g
s
.56566 .65292 m .53443 .58128 L .55019 .57712 L p .764 .534 .585 r
F P
0 g
s
.54963 .6609 m .51862 .58925 L .53443 .58128 L p .636 .477 .65 r
F P
0 g
s
.51862 .58925 m .54963 .6609 L .5397 .66926 L p .436 .376 .692 r
F P
0 g
s
.47367 .52704 m .38171 .53554 L .37088 .5394 L p .386 .842 .905 r
F P
0 g
s
.38171 .53554 m .47367 .52704 L .48468 .5343 L p .654 .182 .121 r
F P
0 g
s
.53443 .58128 m .56566 .65292 L .54963 .6609 L p .636 .477 .65 r
F P
0 g
s
.01 w
.56205 .65472 m
.58321 .70333 L
s
.5 Mabswid
.48417 .58108 m .39232 .59145 L .3992 .57781 L p .827 .875 .88 r
F P
0 g
s
.3992 .57781 m .49121 .56785 L .48417 .58108 L p .827 .875 .88 r
F P
0 g
s
.3926 .5431 m .48468 .5343 L .49142 .54992 L p .833 .56 .525 r
F P
0 g
s
.48468 .5343 m .3926 .5431 L .38171 .53554 L p .654 .182 .121 r
F P
0 g
s
.49121 .56785 m .3992 .57781 L .39932 .55928 L p .864 .73 .713 r
F P
0 g
s
.02 w
.33327 .57029 m
.39929 .56348 L
s
.5 Mabswid
.39932 .55928 m .49142 .54992 L .49121 .56785 L p .864 .73 .713 r
F P
0 g
s
.49142 .54992 m .39932 .55928 L .3926 .5431 L p .833 .56 .525 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00X@3oool00`000000oooo0?ooo`1l0?ooo`00D`3oool00`000000oooo0?ooo`1:0?ooo`80
0000OP3oool00580oooo00@0000009ZUg@0000000000B@3oool2000007l0oooo001A0?ooo`030000
002JYMd0VZGM0080VZGM00<000000?ooo`3oool0A@3oool00`000000000D0000001o0?ooo`00D03o
ool00`000000VZGM09ZUg@0409ZUg@030000003oool0oooo04@0oooo0P0000200?ooo`00D03oool0
0`000000VZGM09ZUg@0509ZUg@800000@`3oool00`000000000D000000200?ooo`00C`3oool00`00
0000VZGM09ZUg@0809ZUg@030000003oool0oooo03l0oooo00<00000000050000000P@3oool004h0
oooo00<0000009ZUg@2JYMd02P2JYMd00`000000oooo0?ooo`0m0?ooo`040000000001@0000D0000
0840oooo001=0?ooo`030000002JYMd0VZGM00`0VZGM0P00000m0?ooo`040000000001@0000D0000
0840oooo001<0?ooo`030000002JYMd0VZGM00l0VZGM00<000000?ooo`3oool0>@3oool010000000
000D0000500000220?ooo`00C@3oool00`000000VZGM09ZUg@0?09ZUg@800000>@3oool010000000
000D0000500000220?ooo`00C`3oool00`000000VZGM09ZUg@0?09ZUg@030000003oool0oooo03D0
oooo00@000000000500001@00000P`3oool00500oooo0P00000@09ZUg@030000003oool0oooo03@0
oooo00@000000000500001@00000P`3oool00580oooo00<0000009ZUg@2JYMd03P2JYMd2000003<0
oooo00D000000000500001@0000D000000230?ooo`00D`3oool00`000000VZGM09ZUg@0?09ZUg@03
0000003oool0oooo0300oooo00@000000000500001@00000Q03oool005@0oooo0P00000@09ZUg@03
0000003oool0oooo02h0oooo00D000000000500001@0000D000000240?ooo`00EP3oool00`000000
VZGM09ZUg@0>09ZUg@800000;P3oool010000000000D0000500000250?ooo`00E`3oool200000100
VZGM00<000000?ooo`3oool0:`3oool010000000000D0000500000250?ooo`00F@3oool00`000000
VZGM09ZUg@0>09ZUg@030000003oool0oooo02T0oooo00@000000000500001@00000QP3oool005X0
oooo0P00000?09ZUg@800000:@3oool010000000000D0000500000260?ooo`00G03oool00`000000
VZGM09ZUg@0>09ZUg@030000003oool0oooo02D0oooo00D000000000500001@0000D000000260?oo
o`00G@3oool2000000l0VZGM0P00000U0?ooo`040000000001@0000D000008L0oooo001O0?ooo`03
0000002JYMd0VZGM00h0VZGM00<000000?ooo`3oool08@3oool01@000000000D0000500001@00000
08L0oooo001P0?ooo`8000003`2JYMd00`000000oooo0?ooo`0P0?ooo`040000000001@0000D0000
08P0oooo001R0?ooo`030000002JYMd0VZGM00d0VZGM0P00000P0?ooo`040000000001@0000D0000
08P0oooo001S0?ooo`030000002JYMd0VZGM00h0VZGM00<000000?ooo`3oool0703oool01@000000
000D0000500001@0000008P0oooo001T0?ooo`8000003`2JYMd00`000000oooo0?ooo`0K0?ooo`04
0000000001@0000D000008T0oooo001V0?ooo`030000002JYMd0VZGM00d0VZGM0P00000J0?ooo`05
0000000001@0000D000050000000R@3oool006L0oooo0P00000?09ZUg@030000003oool0oooo01L0
oooo00@000000000500001@00000RP3oool006T0oooo00<0000009ZUg@2JYMd03@2JYMd2000001H0
oooo00D000000000500001@0000D0000002:0?ooo`00JP3oool2000000l0VZGM00<000000?ooo`3o
ool04`3oool010000000000D00005000002;0?ooo`00K03oool00`000000VZGM09ZUg@0=09ZUg@03
0000003oool0oooo0140oooo00D000000000500001@0000D0000002;0?ooo`00K@3oool2000000h0
VZGM0P00000:0?ooo`H0000000<0oooo0000000001@00P0001@00`000000oooo0?ooo`290?ooo`00
K`3oool00`000000VZGM09ZUg@0=09ZUg@030000003oool0oooo00<0oooo100000030<>8U@<0jI=V
00<0oooo0000000001@00P0001@00`000000oooo0?ooo`290?ooo`00L03oool2000000h0VZGM00<0
00000?ooo`3oool00P0000000`2RNZH000000<>8U@040<>8U@040000003YTfH0jI=V000000<0000D
00<000000?ooo`3oool0RP3oool00780oooo00<0000009ZUg@2JYMd0302JYMd2000000@0XWZV00<0
00000<>8U@33R9D00P33R9D010000000jI=V0>VCIP000003000050030000003oool0oooo08X0oooo
001c0?ooo`030000002JYMd0VZGM00d0VZGM00D000000:9jYP2RNZH0XWZV000000050<>8U@060000
003YTfH0jI=V0000000001@00000S@3oool007@0oooo0P00000<09ZUg@800000102RNZH00`000000
`hRE0<>8U@020<>8U@030000003YTfH0jI=V00800000SP3oool007H0oooo00<0000009ZUg@2JYMd0
202JYMd00`000000Kf2a000000040:9jYP0300000033R9D0`hRE00<0`hRE00<000000>VCIP000000
S`3oool007L0oooo0P00000709ZUg@050000001_H;40Kf2a06mP/@0000000P2RNZH00`000000XWZV
000000040<>8U@040000003YTfH0jI=V000008h0oooo001i0?ooo`030000002JYMd0VZGM0080VZGM
0`00000306mP/@030000002RNZH0XWZV0080XWZV00<000000<>8U@33R9D00P33R9D010000000jI=V
0>VCIP00002>0?ooo`00NP3oool20000000509ZUg@000000oooo0?ooo`0000000`1_H;400`000000
XWZV0:9jYP030:9jYP0300000033R9D0`hRE0080`hRE00@000000>VCIP3YTfH000005@3oool30000
07D0oooo001l0?ooo`030000003oool0oooo0080oooo00D0000006mP/@1_H;40Kf2a000000040:9j
YP0300000033R9D0`hRE0080`hRE00@000000>VCIP3YTfH00000503oool200000080^L_X0P00001c
0?ooo`00P@3oool01@000000Kf2a06mP/@1_H;40000000D0XWZV00<000000<>8U@33R9D00P33R9D0
0`000000jI=V0000000C0?ooo`8000000`2ibnP00`000000WI[A0000001b0?ooo`00PP3oool01@00
0000Kf2a06mP/@1_H;40000000@0XWZV00<000000<>8U@33R9D00P33R9D010000000jI=V0>VCIP00
000B0?ooo`8000000P2ibnP01@000000WI[A09fJd@2MV]4000000740oooo00220?ooo`050000001_
H;40Kf2a06mP/@0000001@2RNZH01@000000`hRE0<>8U@33R9D000000080jI=V00<000000?ooo`3o
ool03`3oool3000000030;W;j0000000WI[A0080WI[A0P00001a0?ooo`00P`3oool010000000Kf2a
06mP/@0000050:9jYP0300000033R9D0`hRE0080`hRE00@000000>VCIP3YTfH000003`3oool20000
0080G5Jb00D0000009fJd@2MV]40WI[A00000002081Y[`030000003oool0oooo06h0oooo00230?oo
o`050000001_H;40Kf2a06mP/@0000001@2RNZH01@000000`hRE0<>8U@33R9D000000080jI=V00<0
00000?ooo`3oool0303oool00`000000000m0000000205aF/P040000002MV]400000000000<0P6V_
00<000000?ooo`3oool0KP3oool008<0oooo0P00000206mP/@030000002RNZH0XWZV00<0XWZV00<0
00000<>8U@33R9D00P33R9D00`000000jI=V0000000>0?ooo`8000000P1LE[800`000000Q9KL0000
0003081Y[`<00000L03oool008@0oooo00D0000006mP/@1_H;40Kf2a000000050:9jYP0500000033
R9D0`hRE0<>8U@0000000P3YTfH00`000000oooo0?ooo`0:0?ooo`8000000P1LE[8010000000Q9KL
08BFg024U]`30000000304T?HP00000000000700oooo00240?ooo`8000000P1_H;400`000000XWZV
0:9jYP030:9jYP0300000033R9D0`hRE0080`hRE00<000000>VCIP0000002`3oool200000080G5Jb
00D0000008BFg024U]`0Q9KL0000000209g@nP<00000L@3oool008D0oooo00@0000006mP/@1_H;40
00001P2RNZH00`000000`hRE00000003000000030>VCIP000000oooo00T0oooo00@0000005aF/P1L
E[8000000P24U]`200000080WM3j0P00001c0?ooo`00Q@3oool200000080Kf2a00<000000:9jYP2R
NZH00P2RNZH4000000<0LV:a0P0000090?ooo`80000000D0G5Jb00000024U]`0Q9KL0000000209g@
nP800000M@3oool008D0oooo0P00000206mP/@040000002RNZH0XWZV0:9jYP<000000P2SNZH01@00
0000LV:a079R/@1bH[40000000P0oooo0P0000001@1LE[80000008BFg024U]`000000080WM3j0P00
001f0?ooo`00QP3oool200000080Kf2a00<0XWZV0000000000000`0000020:=jYP050000001bH[40
LV:a079R/@0000001`3oool20000000305aF/P000000Q9KL0080000000<0WM3j000000000000N03o
ool008H0oooo0P00000206mP/@0400000033RIH0`hVF0<>9UP8000000`2SNZH3000000P0oooo00D0
000005aF/P000000Q9KL0000000209g@nP030000003oool0oooo07P0oooo00270?ooo`030000001_
H;40000000@0`hVF0`0000000`2SNZH00000000000090?ooo`<0000000<0Q9KL0000002Md?X00P00
00050?ooo`D00000L@3oool008L0oooo0P0000000`3XU6X000000<>9UP030<>9UP<000002P3oool3
0000000308BFg0000000000000P000001@2W;Qh2000006l0oooo00280?ooo`030000003XU6X00000
00<0`hVF1000000:0?ooo`H000002`2W;Qh5000006h0oooo00280?ooo`80000000@0j9AZ00000000
000000000P3oool900000080oooo1P0000040:L^7PP00000103EShH00`000000oooo0?ooo`1/0?oo
o`00P@3oool700000080oooo0P0000030?ooo`l000000`3CgN04000000d0eHn600<000000?ooo`3o
ool0J`3oool007@0oooo3@0000070:L^7P800000103oool30000000308iAP`000000/Ei/00T00000
103CgN000`000000eHn60=F?QP0>0=F?QP030000003oool0oooo06/0oooo001/0?ooo`P000004@2W
;Qh7000000030?ooo`000000000000@0SU633P0000000`3L^KH000000=F?QP0;0=F?QPD00000K03o
ool006X0oooo1P0000070:L^7Ph000001P3EShH010000000oooo00000000000208iAP`80000000<0
XWZV00000033R9H01P0000050=bi]P800000103EShH8000000@0gKZf00<000000?ooo`3oool0JP3o
ool006X0oooo00<000000=?Mh03CgN000`3CgN07000001D0eHn60P0000000`147gd0000000000003
0:9jYP0300000033R9H0`hRF01000000303M^[H00`000000oooo0?ooo`1Z0?ooo`00J@3oool00`00
0000dmgP0=?Mh0040=?Mh0030000003EShH0eHn601T0eHn6100000050:9jYP8000000P3;Y;0=0000
00d0gKZf00<000000?ooo`3oool0JP3oool006T0oooo00<000000=?Mh03CgN000`3CgN03000001L0
eHn61`0000030:9jYP<000000`3;Y;0=000000d0gKZf00<000000?ooo`3oool0JP3oool006P0oooo
1`0000020=bi]P030000003EShH0eHn600`0eHn62@0000040=fj]PH000000P2^UKd010000000bjB`
0<^T/03;Y;0=000000T0gKZf1@00001/0?ooo`00J03oool00`000000g;Vf0=bi]P030=bi]PD00000
103EShH9000000d0gKZf100000050:jE_@030000003;Y;00000000P000000P3DShP010000000gKZf
0=fj]P3M^[H8000000@0dmoQ00<000000?ooo`3oool0JP3oool006@0oooo4`00000E0=fj]PH00000
0`2^UKd3000000040<nmb@000000j]W3000000L0e8n81000000;0=?Oh@030000003oool0oooo06/0
oooo001M0?oooaP000005`3M^[H6000000050:jE_@00000000000;R`dP0000000P3?_LT00`000000
j]W3000000070=B?R0030000003Cgn40dmoQ00`0dmoQ00<000000?ooo`3oool0J`3oool005d0oooo
6000000C0=fj]P/00000102h/=85000000<0e8n81000000:0=?Oh@D00000KP3oool005d0oooo6000
000:0=fj]PT00000103Cgn49000000030;R`dP00000000000080]noe1@0000030:Td9P030000003C
gn40dmoQ00P0000000<0Em7O000000000000L03oool005d0oooo4@0000040=B?R0030000003M^[H0
gKZf0080gKZf2000000<0=?Oh@P000000P2L[>85000000030?ooo`000000000000<0ZC@V2P00001f
0?ooo`00G@3oool7000000D0oooo00<000000=B?R03DShP01P3DShP5000001@0dmoQ2P0000020;O_
m@8000000P3oool7000007h0oooo001Y0?ooo`030000003DShP0e8n800H0e8n800<000000=?Oh@3C
gn404@3Cgn4@000000030?ooo`0000000000008000000`33R9D30>VCIWl0oooo001Z0?ooo`030000
003DShP0e8n80080e8n80`00000;0=?Oh@T0000000<0Em7O0000000000001`000004079R/@030000
003oool0oooo00<000001033R9D010000000jI=V0>VCIP0000020?ooo``00000L03oool006X0oooo
1@0000020:Td9P040000003Cgn40dmoQ0=?OhAX000001P1bH[42000000<0XWZV00D000000<>8U@33
R9D0`hRE000000020>VCIP<000000`0S0005000007@0oooo001[0?ooo`8000000P2Y=2H;00000080
7`1?00<0000006mO/01_Gk00101_Gk0;000000H0LV:a00<000000:9jYP2RNZH00`2RNZH00`000000
`hRE0<>8U@020<>8U@030000003YTfH0jI=V00<00000N`3oool006d0oooo1@0000040?ooo`030000
000O04l07`1?00807`1?00<0000006mO/01_Gk00101_Gk0;000000D0LV:a0`0000060:9jYP050000
0033R9D0`hRE0<>8U@0000000P3YTfH00`000000oooo0?ooo`1k0?ooo`00M@3oool00`0000007`1?
01l0C`0201l0C`030000001_Gk00Ken`00@0Ken`2`000005079R/@8000000P1_H;400`000000XWZV
0:9jYP030:9jYP0300000033R9D0`hRE0080`hRE00@000000>VCIP3YTfH00000O03oool007@0oooo
00<0000001l0C`0O04l00P0O04l00`000000Ken`06mO/00606mO/0T000001@1bH[400`000000:P1H
0000000206mP/@030000002RNZH0XWZV00@0XWZV00D000000<>8U@33R9D0`hRE000000020>VCIP03
0000003oool0oooo07X0oooo001b0?ooo`d0000000@0Ken`000000000000TISG1`000005079R/@03
0000000Z05P0:P1H008000000P1_H;400`000000XWZV0:9jYP030:9jYP0500000033R9D0`hRE0<>8
U@0000000P3YTfH00`000000oooo0?ooo`1j0?ooo`00JP3oool@000000D0Ken`00<00000096He`2A
V=L00P2AV=L500000004096He`0000000000079R/@8000000`0Z05P200000080Kf2a00<000000:9j
YP2RNZH00`2RNZH00`000000`hRE0<>8U@020<>8U@040000003YTfH0jI=V000007/0oooo001R0?oo
oa80000000<07`1?0000001_Gk001`1_Gk000`000000TISG096He`04096He`<0000000@0TISG0000
002]co80[Lob0P00000202X0F0D000000P1_H;400`000000XWZV0:9jYP030:9jYP0500000033R9D0
`hRE0<>8U@0000000P3YTfH00`000000oooo0?ooo`1i0?ooo`00FP3oool6000000808`0020000006
0?ooo`D00000201_Gk000`000000TISG096He`06096He`030000002AV=L0000000D0[Lob0P000000
0`2Nl/8000000?ooo`0200000080Kf2a00<000000:9jYP2RNZH00`2RNZH00`000000`hRE0<>8U@02
0<>8U@040000003YTfH0jI=V000007X0oooo001F0?ooo``000003@3oool01@0000007`1?0000002^
cO00000000P0Ken`00<00000096He`2AV=L01`2AV=L2000000H0[Lob0P0000040?ooo`050000001_
H;40Kf2a06mP/@0000001@2RNZH01@000000`hRE0<>8U@33R9D000000080jI=V00<000000?ooo`3o
ool0N03oool006h0oooo00<0000001l0C`0O04l00`00000706mO/0030000002AV=L0TISG00L0TISG
00<000000:g?lP2]co801@2]co82000000D0oooo0P00000206mP/@030000002RNZH0XWZV00<0XWZV
00<000000<>8U@33R9D00P33R9D00`000000jI=V0>VCIP07000007<0oooo001/0?ooo`8000000P0O
04l00`000000oooo0?ooo`02000000D0Ken`00<00000096He`2AV=L01`2AV=L00`000000[Lob0:g?
lP040:g?lP<000001P3oool200000080Kf2a00<000000:9jYP2RNZH0102RNZH01@000000`hRE0<>8
U@33R9D000000080jI=V0P00001h0?ooo`00J`3oool00`0000007`1?01l0C`0201l0C`050000003o
ool0oooo0?ooo`0000000`1_Gk02000000T0TISG00<000000:g?lP2]co80102]co800`000000W_;2
000000040?ooo`D000000`1_H;400`000000XWZV0:9jYP030:9jYP0500000033R9D0`hRE0<>8U@00
00000P3YTfH00`000000oooo0?ooo`1g0?ooo`00J`3oool0100000007`1?01l0C`0O04l2000000<0
oooo00@0000006mO/01_Gk0000002P2AV=L00`000000[Lob0:g?lP040:g?lP030000002Nl/800000
00/000000P1_H;400`000000XWZV0:9jYP030:9jYP0300000033R9D0`hRE0080`hRE00@000000>VC
IP3YTfH00000N03oool006/0oooo00@0000001l0C`0O04l000000P1_Gk0010000000oooo0?ooo`3o
ool2000000X0TISG00<000000:g?lP2]co80102]co800`000000W_;200000005000000H0oooo00D0
000006mP/@1_H;40Kf2a000000050:9jYP0500000033R9D0`hRE0<>8U@0000000P3YTfH00`000000
oooo0?ooo`1f0?ooo`00J`3oool00`0000007`1?0000000306mO/0030000003oool0000000800000
2P2AV=L00`000000[Lob0:g?lP040:g?lP<00000303oool200000080Kf2a00<000000:9jYP2RNZH0
0`2RNZH00`000000`hRE0<>8U@020<>8U@040000003YTfH0jI=V000007L0oooo001Z0?ooo`030000
000O04l0000000D0Ken`1@000007096He`8000001P2]co82000000h0oooo0P00000306mP/@030000
002RNZH0XWZV00<0XWZV00D000000<>8U@33R9D0`hRE000000020>VCIP030000003oool0oooo07D0
oooo001Z0?ooo`8000001P1_Gk06000000D0TISG00<000000:g?lP2]co801@2]co8200000100oooo
00D0000006mP/@1_H;40Kf2a000000050:9jYP0300000033R9D0`hRE0080`hRE00@000000>VCIP3Y
TfH00000MP3oool006H0oooo300000000`1_Gk00000000000004000000<0TISG00<000000:g?lP2]
co80102]co8300000140oooo0P00000306mP/@030000002RNZH0XWZV0080XWZV0P0000000`33R9D0
000000000004000007H0oooo001N0?ooo`l000001@1_Gk000`000000TISG0000000500000003096H
e`000000[Lob00D0[Lob0`00000C0?ooo`050000001_H;40Kf2a06mP/@0000000`2RNZH400000003
0:=jYP000000LV:a0080LV:a00<000000?ooo`3oool0M03oool005H0oooo3`0000060?ooo`030000
001_Gk00Ken`00<0Ken`00@00000096He`2AV=L0TISG200000040:g?lP8000005@3oool00`000000
Kf2a06mP/@0206mP/@80XWZV100000020:=jYP040000001bH[40LV:a000007L0oooo001>0?ooo`l0
00003P3oool00`000000Ken`06mO/00206mO/0030000002AV=L0TISG00@0TISG0P0000040?ooo`H0
00005@3oool2000000<0Kf2a0P0000020<>9UP8000000`2SNZH2000007P0oooo00160?ooo`l00000
5`3oool010000000Ken`06mO/0000008096He`<000000P3oool00`000000:P1H00000002000001L0
oooo00@0000006mP/@1_H;4000001033RIH3000000030:=jYP000000000007T0oooo000n0?ooo`H0
000000<0;P000000000000001P00000O0?ooo`030000001_Gk00000000P0TISG00@000000:g?lP2]
co80[Lob100000000`2Nl/8000000?ooo`0G0?ooo`040000001_H;400000000000D0`hVF0`00001k
0?ooo`00>P3oool;000002L0oooo0P000008096He`030000002]co80[Lob00@0[Lob0P00000K0?oo
o`040000003XU6X0j9AZ00000080`hVF1@00001k0?ooo`00JP3oool5000000H0TISG00<000000:g?
lP2]co80102]co82000001`0oooo1P0000030?ooo`800000N`3oool006P0oooo0`0000000`21JJl0
000009fJd003000000<0TISG00<000000:g?lP2]co800`2]co83000002H0oooo0`00001j0?ooo`00
I`3oool01P000000CA=U00000021JJl0000009fJd08000000P3oool00`000000TISG000000050:g?
lP<00000:03oool2000007X0oooo001U0?ooo`@0000000<0PFV_0000002MV]000P0000040?ooo`<0
00000`2]co82000002X0oooo0P00001j0?ooo`00H`3oool20000000604dCI@000000PFV_085Y[`00
0000WI[@0`0000070?ooo`<00000;@3oool2000007T0oooo001Q0?ooo`80000000<0CA=U00000000
00000P21JJl00`000000WI[@00000002000003P0oooo0P00001i0?ooo`00H03oool010000000CA=U
04dCI@000003085Y[`030000002MV]00000000800000>P3oool2000007P0oooo001P0?ooo`<00000
0P21JJl20000000309fJd0000000^LWW00800000>P3oool2000007P0oooo001P0?ooo`0500000021
JJl0PFV_085Y[`0000000P2MV]0010000000^LWW00000000000k0?ooo`<00000M`3oool00600oooo
00@00000085Y[`21JJl000000`2MV]03000003d0oooo00<000000?ooo`3oool0MP3oool00640oooo
0P00000309fJd0<00000]`3oool00640oooo00H0000009fJd02MV]00WI[@0000002ibNL200000;L0
oooo001R0?ooo`040000002MV]0000000;W9i`800000^03oool006<0oooo0`00002j0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.3212 .61815 m .35784 .6095 L .39774 .6157 L p .281 0 0 r
F P
0 g
s
.39774 .6157 m .36444 .6249 L .3212 .61815 L p .281 0 0 r
F P
0 g
s
.41027 .58411 m .43158 .57982 L .46863 .5855 L p .236 0 0 r
F P
0 g
s
.46863 .5855 m .4495 .59014 L .41027 .58411 L p .236 0 0 r
F P
0 g
s
.45884 .45302 m .4287 .33126 L .46763 .31532 L p .57 .307 .478 r
F P
0 g
s
.46763 .31532 m .50028 .43636 L .45884 .45302 L p .57 .307 .478 r
F P
0 g
s
.4945 .5522 m .50398 .55077 L .50812 .53458 L p .899 .87 .431 r
F P
0 g
s
.50398 .55077 m .4945 .5522 L .50081 .56829 L p .883 .526 .039 r
F P
0 g
s
.50081 .56829 m .51008 .56634 L .50398 .55077 L p .883 .526 .039 r
F P
0 g
s
.51008 .56634 m .50081 .56829 L .51531 .57761 L p .567 0 0 r
F P
0 g
s
.51531 .57761 m .52412 .57536 L .51008 .56634 L p .567 0 0 r
F P
0 g
s
.49877 .53546 m .50812 .53458 L .52093 .52393 L p .601 .925 .697 r
F P
0 g
s
.50812 .53458 m .49877 .53546 L .4945 .5522 L p .899 .87 .431 r
F P
0 g
s
.52412 .57536 m .51531 .57761 L .53247 .57659 L p .011 0 0 r
F P
0 g
s
.53247 .57659 m .54073 .57437 L .52412 .57536 L p .011 0 0 r
F P
0 g
s
.51201 .52446 m .52093 .52393 L .53755 .5229 L p .045 .613 .707 r
F P
0 g
s
.52093 .52393 m .51201 .52446 L .49877 .53546 L p .601 .925 .697 r
F P
0 g
s
.54073 .57437 m .53247 .57659 L .54575 .5656 L p .555 .894 .652 r
F P
0 g
s
.54575 .5656 m .55358 .56374 L .54073 .57437 L p .555 .894 .652 r
F P
0 g
s
.53755 .5229 m .52918 .52339 L .51201 .52446 L p .045 .613 .707 r
F P
0 g
s
.52918 .52339 m .53755 .5229 L .55162 .53191 L p .523 0 0 r
F P
0 g
s
.55358 .56374 m .54575 .5656 L .55005 .54883 L p .869 .848 .388 r
F P
0 g
s
.55005 .54883 m .55775 .54751 L .55358 .56374 L p .869 .848 .388 r
F P
0 g
s
.54372 .5327 m .55162 .53191 L .55775 .54751 L p .854 .496 0 r
F P
0 g
s
.55162 .53191 m .54372 .5327 L .52918 .52339 L p .523 0 0 r
F P
0 g
s
.55775 .54751 m .55005 .54883 L .54372 .5327 L p .854 .496 0 r
F P
0 g
s
.34765 .5849 m .30669 .60118 L .31666 .61873 L p .723 .703 .831 r
F P
0 g
s
.31666 .61873 m .35739 .60259 L .34765 .5849 L p .723 .703 .831 r
F P
0 g
s
.35739 .60259 m .31666 .61873 L .32539 .64114 L p .683 .561 .711 r
F P
0 g
s
.32539 .64114 m .36616 .62504 L .35739 .60259 L p .683 .561 .711 r
F P
0 g
s
.36616 .62504 m .32539 .64114 L .32969 .66019 L p .612 .389 .555 r
F P
0 g
s
.32969 .66019 m .37073 .64403 L .36616 .62504 L p .612 .389 .555 r
F P
0 g
s
.45601 .54181 m .36305 .57877 L .37272 .59651 L p .723 .703 .831 r
F P
0 g
s
.37272 .59651 m .46518 .55986 L .45601 .54181 L p .723 .703 .831 r
F P
0 g
s
.46518 .55986 m .37272 .59651 L .38149 .61898 L p .683 .561 .711 r
F P
0 g
s
.38149 .61898 m .47402 .58243 L .46518 .55986 L p .683 .561 .711 r
F P
0 g
s
.47402 .58243 m .38149 .61898 L .38616 .63795 L p .612 .389 .555 r
F P
0 g
s
.20784 .6686 m .21158 .67824 L .30837 .63394 L closepath p .651 .544 .72 r
F P
0 g
s
.20329 .6612 m .20784 .6686 L .30837 .63394 L closepath p .686 .69 .848 r
F P
0 g
s
.21158 .67824 m .21311 .6865 L .30837 .63394 L closepath p .568 .359 .557 r
F P
0 g
s
.34052 .57862 m .29918 .59507 L .30669 .60118 L p .698 .911 .969 r
F P
0 g
s
.30669 .60118 m .34765 .5849 L .34052 .57862 L p .698 .911 .969 r
F P
0 g
s
.19965 .65885 m .20329 .6612 L .30837 .63394 L closepath p .605 .883 .991 r
F P
0 g
s
.21311 .6865 m .21185 .69026 L .30837 .63394 L closepath p .185 0 .015 r
F P
0 g
s
.37073 .64403 m .32969 .66019 L .32789 .66875 L p .319 0 .068 r
F P
0 g
s
.38616 .63795 m .4793 .60126 L .47402 .58243 L p .612 .389 .555 r
F P
0 g
s
.32789 .66875 m .36933 .65244 L .37073 .64403 L p .319 0 .068 r
F P
0 g
s
.44992 .53507 m .35607 .57243 L .36305 .57877 L p .698 .911 .969 r
F P
0 g
s
.36305 .57877 m .45601 .54181 L .44992 .53507 L p .698 .911 .969 r
F P
0 g
s
.4793 .60126 m .38616 .63795 L .38492 .64631 L p .319 0 .068 r
F P
0 g
s
.19832 .6625 m .19965 .65885 L .30837 .63394 L closepath p .399 0 .063 r
F P
0 g
s
.21185 .69026 m .20823 .68802 L .30837 .63394 L closepath p .761 .935 .942 r
F P
0 g
s
.49563 .51204 m .46683 .43865 L .4524 .44359 L p .803 .617 .651 r
F P
0 g
s
.46683 .43865 m .49563 .51204 L .51173 .50563 L p .683 .561 .711 r
F P
0 g
s
.51173 .50563 m .48289 .43218 L .46683 .43865 L p .683 .561 .711 r
F P
0 g
s
.19984 .67081 m .19832 .6625 L .30837 .63394 L closepath p .647 .409 .545 r
F P
0 g
s
.4524 .44359 m .48129 .51726 L .49563 .51204 L p .803 .617 .651 r
F P
0 g
s
.48289 .43218 m .51173 .50563 L .52362 .5004 L p .511 .468 .745 r
F P
0 g
s
.52362 .5004 m .49462 .42657 L .48289 .43218 L p .511 .468 .745 r
F P
0 g
s
.38492 .64631 m .47899 .60929 L .4793 .60126 L p .319 0 .068 r
F P
0 g
s
.20823 .68802 m .20363 .68058 L .30837 .63394 L closepath p .755 .717 .817 r
F P
0 g
s
.5006 .56508 m .496 .55334 L .50994 .54812 L p .803 .617 .651 r
F P
0 g
s
.02 w
.52079 .55075 m
.53083 .54914 L
s
.5 Mabswid
.50994 .54812 m .51452 .55981 L .5006 .56508 L p .803 .617 .651 r
F P
0 g
s
.50674 .53704 m .50994 .54812 L .496 .55334 L p .832 .721 .743 r
F P
0 g
s
.51452 .55981 m .50994 .54812 L .52565 .5419 L p .683 .561 .711 r
F P
0 g
s
.50994 .54812 m .50674 .53704 L .51937 .53203 L p .712 .655 .792 r
F P
0 g
s
.51937 .53203 m .52565 .5419 L .50994 .54812 L p .712 .655 .792 r
F P
0 g
s
.50845 .57413 m .5006 .56508 L .51452 .55981 L p .755 .497 .542 r
F P
0 g
s
.51452 .55981 m .51962 .56987 L .50845 .57413 L p .755 .497 .542 r
F P
0 g
s
.51962 .56987 m .51452 .55981 L .53025 .5536 L p .641 .454 .615 r
F P
0 g
s
.52565 .5419 m .53025 .5536 L .51452 .55981 L p .683 .561 .711 r
F P
0 g
s
.5575 .66973 m .5286 .59607 L .51437 .60161 L p .803 .617 .651 r
F P
0 g
s
.5286 .59607 m .5575 .66973 L .57368 .66345 L p .683 .561 .711 r
F P
0 g
s
.57368 .66345 m .54474 .58972 L .5286 .59607 L p .683 .561 .711 r
F P
0 g
s
.3388 .58644 m .29705 .60304 L .29918 .59507 L p .279 0 .012 r
F P
0 g
s
.29918 .59507 m .34052 .57862 L .3388 .58644 L p .279 0 .012 r
F P
0 g
s
.20363 .68058 m .19984 .67081 L .30837 .63394 L closepath p .71 .574 .7 r
F P
0 g
s
.53025 .5536 m .52565 .5419 L .53732 .53698 L p .511 .468 .745 r
F P
0 g
s
.52565 .5419 m .51937 .53203 L .52871 .52804 L p .552 .591 .847 r
F P
0 g
s
.52871 .52804 m .53732 .53698 L .52565 .5419 L p .552 .591 .847 r
F P
0 g
s
.53025 .5536 m .53226 .56488 L .51962 .56987 L p .641 .454 .615 r
F P
0 g
s
.53226 .56488 m .53025 .5536 L .54194 .54873 L p .455 .328 .618 r
F P
0 g
s
.53732 .53698 m .54194 .54873 L .53025 .5536 L p .511 .468 .745 r
F P
0 g
s
.51437 .60161 m .54336 .67555 L .5575 .66973 L p .803 .617 .651 r
F P
0 g
s
.54474 .58972 m .57368 .66345 L .58591 .65901 L p .511 .468 .745 r
F P
0 g
s
.58591 .65901 m .55681 .58492 L .54474 .58972 L p .511 .468 .745 r
F P
0 g
s
.36933 .65244 m .32789 .66875 L .3205 .66325 L p .684 .92 .972 r
F P
0 g
s
.48129 .51726 m .4524 .44359 L .445 .44514 L p .947 .658 .457 r
F P
0 g
s
.496 .55334 m .49554 .5412 L .50674 .53704 L p .832 .721 .743 r
F P
0 g
s
.50556 .5287 m .50674 .53704 L .49554 .5412 L p .841 .843 .846 r
F P
0 g
s
.50674 .53704 m .50556 .5287 L .51259 .52591 L p .732 .773 .886 r
F P
0 g
s
.51259 .52591 m .51937 .53203 L .50674 .53704 L p .732 .773 .886 r
F P
0 g
s
.51804 .57872 m .50845 .57413 L .51962 .56987 L p .648 .292 .354 r
F P
0 g
s
.51962 .56987 m .52425 .57634 L .51804 .57872 L p .648 .292 .354 r
F P
0 g
s
.52425 .57634 m .51962 .56987 L .53226 .56488 L p .553 .274 .445 r
F P
0 g
s
.51937 .53203 m .51259 .52591 L .51777 .52368 L p .582 .735 .948 r
F P
0 g
s
.51777 .52368 m .52871 .52804 L .51937 .53203 L p .582 .735 .948 r
F P
0 g
s
.445 .44514 m .47408 .51932 L .48129 .51726 L p .947 .658 .457 r
F P
0 g
s
.53226 .56488 m .53129 .57357 L .52425 .57634 L p .553 .274 .445 r
F P
0 g
s
.53129 .57357 m .53226 .56488 L .54166 .56102 L p .346 .102 .395 r
F P
0 g
s
.54194 .54873 m .54166 .56102 L .53226 .56488 L p .455 .328 .618 r
F P
0 g
s
.44931 .54249 m .35451 .58019 L .35607 .57243 L p .279 0 .012 r
F P
0 g
s
.35607 .57243 m .44992 .53507 L .44931 .54249 L p .279 0 .012 r
F P
0 g
s
.3205 .66325 m .36234 .64677 L .36933 .65244 L p .684 .92 .972 r
F P
0 g
s
.4937 .56741 m .48907 .5556 L .496 .55334 L p .948 .658 .457 r
F P
0 g
s
.496 .55334 m .5006 .56508 L .4937 .56741 L p .948 .658 .457 r
F P
0 g
s
.49554 .5412 m .496 .55334 L .48907 .5556 L p .981 .828 .617 r
F P
0 g
s
.50295 .57605 m .4937 .56741 L .5006 .56508 L p .847 .437 .26 r
F P
0 g
s
.5006 .56508 m .50845 .57413 L .50295 .57605 L p .847 .437 .26 r
F P
0 g
s
.54336 .67555 m .51437 .60161 L .50738 .60425 L p .947 .658 .457 r
F P
0 g
s
.47899 .60929 m .38492 .64631 L .37808 .64057 L p .684 .92 .972 r
F P
0 g
s
.49462 .42657 m .52362 .5004 L .52677 .49833 L p 0 .071 .621 r
F P
0 g
s
.52677 .49833 m .49756 .42396 L .49462 .42657 L p 0 .071 .621 r
F P
0 g
s
.50738 .60425 m .53657 .67871 L .54336 .67555 L p .947 .658 .457 r
F P
0 g
s
.48907 .5556 m .48997 .54294 L .49554 .5412 L p .981 .828 .617 r
F P
0 g
s
.49932 .53101 m .49554 .5412 L .48997 .54294 L p .93 .964 .763 r
F P
0 g
s
.49554 .5412 m .49932 .53101 L .50556 .5287 L p .841 .843 .846 r
F P
0 g
s
.51502 .5798 m .50295 .57605 L .50845 .57413 L p .616 .091 0 r
F P
0 g
s
.50845 .57413 m .51804 .57872 L .51502 .5798 L p .616 .091 0 r
F P
0 g
s
.54194 .54873 m .53732 .53698 L .54049 .53523 L p 0 .071 .621 r
F P
0 g
s
.53732 .53698 m .52871 .52804 L .5312 .52658 L p .003 .345 .823 r
F P
0 g
s
.5312 .52658 m .54049 .53523 L .53732 .53698 L p .003 .345 .823 r
F P
0 g
s
.54166 .56102 m .54194 .54873 L .54515 .54707 L p 0 0 .333 r
F P
0 g
s
.54049 .53523 m .54515 .54707 L .54194 .54873 L p 0 .071 .621 r
F P
0 g
s
.55681 .58492 m .58591 .65901 L .58953 .65813 L p 0 .071 .621 r
F P
0 g
s
.58953 .65813 m .56021 .58348 L .55681 .58492 L p 0 .071 .621 r
F P
0 g
s
.50556 .5287 m .49932 .53101 L .49624 .53194 L p .343 .813 .74 r
F P
0 g
s
.51259 .52591 m .50556 .5287 L p .49624 .53194 L .343 .813 .74 r
F P
0 g
s
.51777 .52368 m .51259 .52591 L p .49624 .53194 L .343 .813 .74 r
F P
0 g
s
.51804 .57872 m .52425 .57634 L .53129 .57357 L p .292 .775 .691 r
F P
0 g
s
.52871 .52804 m .51777 .52368 L .51912 .52286 L p .144 .6 .928 r
F P
0 g
s
.51912 .52286 m .5312 .52658 L .52871 .52804 L p .144 .6 .928 r
F P
0 g
s
.54166 .56102 m .53652 .57144 L .53129 .57357 L p .346 .102 .395 r
F P
0 g
s
.53129 .57357 m .53652 .57144 L p .51804 .57872 L .292 .775 .691 r
F P
0 g
s
.53652 .57144 m .54166 .56102 L .54423 .55976 L p 0 0 0 r
F P
0 g
s
.54515 .54707 m .54423 .55976 L .54166 .56102 L p 0 0 .333 r
F P
0 g
s
.48997 .54294 m .49624 .53194 L .49932 .53101 L p .93 .964 .763 r
F P
0 g
s
.51636 .57916 m .51502 .5798 L .51804 .57872 L p .292 .775 .691 r
F P
0 g
s
.52159 .57703 m .51636 .57916 L p .51804 .57872 L .292 .775 .691 r
F P
0 g
s
.5287 .57423 m .52159 .57703 L p .51804 .57872 L .292 .775 .691 r
F P
0 g
s
.53495 .57183 m .5287 .57423 L p .51804 .57872 L .292 .775 .691 r
F P
0 g
s
.54423 .55976 m .53793 .57077 L .53652 .57144 L p 0 0 0 r
F P
0 g
s
.53793 .57077 m .53495 .57183 L p .51804 .57872 L .292 .775 .691 r
F P
0 g
s
.53652 .57144 m .53793 .57077 L p .51804 .57872 L .292 .775 .691 r
F P
0 g
s
.51912 .52286 m .51777 .52368 L p .49624 .53194 L .343 .813 .74 r
F P
0 g
s
.47408 .51932 m .445 .44514 L .44757 .44265 L p 0 .035 .597 r
F P
0 g
s
.37808 .64057 m .47307 .60315 L .47899 .60929 L p .684 .92 .972 r
F P
0 g
s
.03 w
.30837 .63394 m
.47554 .56777 L
s
.5 Mabswid
.44757 .44265 m .47688 .51739 L .47408 .51932 L p 0 .035 .597 r
F P
0 g
s
.49657 .56588 m .4919 .55398 L .48907 .5556 L p 0 .035 .598 r
F P
0 g
s
.48907 .5556 m .4937 .56741 L .49657 .56588 L p 0 .035 .598 r
F P
0 g
s
.03 w
.47554 .56777 m
.49138 .5615 L
s
.5 Mabswid
.48997 .54294 m .48907 .5556 L .4919 .55398 L p 0 0 .296 r
F P
0 g
s
.50531 .57487 m .49657 .56588 L .4937 .56741 L p 0 .318 .806 r
F P
0 g
s
.4937 .56741 m .50295 .57605 L .50531 .57487 L p 0 .318 .806 r
F P
0 g
s
.4919 .55398 m .49225 .54157 L .48997 .54294 L p 0 0 .296 r
F P
0 g
s
.49624 .53194 m .48997 .54294 L .49225 .54157 L p 0 0 0 r
F P
0 g
s
.34331 .60568 m .30128 .62235 L .29705 .60304 L p .607 .381 .548 r
F P
0 g
s
.29705 .60304 m .3388 .58644 L .34331 .60568 L p .607 .381 .548 r
F P
0 g
s
.01 w
.52646 .57529 m
.53007 .58449 L
s
.49365 .49167 m
.50407 .51821 L
s
.4754 .44517 m
.49365 .49167 L
s
.53007 .58449 m
.53167 .58856 L
s
.54052 .6111 m
.57976 .71109 L
s
.5 Mabswid
.53657 .67871 m .50738 .60425 L .51043 .60296 L p 0 .035 .597 r
F P
0 g
s
.51636 .57916 m .50531 .57487 L .50295 .57605 L p .097 .577 .907 r
F P
0 g
s
.50295 .57605 m .51502 .5798 L .51636 .57916 L p .097 .577 .907 r
F P
0 g
s
.51609 .52377 m .51912 .52286 L p .49624 .53194 L .343 .813 .74 r
F P
0 g
s
.50981 .52609 m .51609 .52377 L p .49624 .53194 L .343 .813 .74 r
F P
0 g
s
.50271 .52891 m .50981 .52609 L p .49624 .53194 L .343 .813 .74 r
F P
0 g
s
.01 w
.50767 .5274 m
.5264 .57513 L
s
.50407 .51821 m
.50751 .527 L
s
.5 Mabswid
.49624 .53194 m .49752 .53115 L .50271 .52891 L p .343 .813 .74 r
F P
0 g
s
.49225 .54157 m .49752 .53115 L .49624 .53194 L p 0 0 0 r
F P
0 g
s
.36234 .64677 m .3205 .66325 L .31029 .64549 L p .723 .707 .835 r
F P
0 g
s
.51043 .60296 m .53984 .67797 L .53657 .67871 L p 0 .035 .597 r
F P
0 g
s
.01 w
.53167 .58856 m
.54052 .6111 L
s
.5 Mabswid
.64891 .49391 m .6454 .48588 L .54348 .54088 L closepath p .755 .719 .819 r
F P
0 g
s
.6528 .50376 m .64891 .49391 L .54348 .54088 L closepath p .71 .574 .7 r
F P
0 g
s
.49756 .42396 m .52677 .49833 L .51981 .50028 L p .952 .657 .441 r
F P
0 g
s
.51981 .50028 m .4904 .42539 L .49756 .42396 L p .952 .657 .441 r
F P
0 g
s
.65559 .51174 m .6528 .50376 L .54348 .54088 L closepath p .645 .406 .542 r
F P
0 g
s
.5312 .52658 m .51912 .52286 L .51609 .52377 L p .597 .058 0 r
F P
0 g
s
.53793 .57077 m .54423 .55976 L .53889 .56162 L p .927 .971 .754 r
F P
0 g
s
.53889 .56162 m .53495 .57183 L .53793 .57077 L p .927 .971 .754 r
F P
0 g
s
.54049 .53523 m .5312 .52658 L .52579 .52826 L p .845 .425 .235 r
F P
0 g
s
.51609 .52377 m .52579 .52826 L .5312 .52658 L p .597 .058 0 r
F P
0 g
s
.54423 .55976 m .54515 .54707 L .53848 .5493 L p .986 .833 .607 r
F P
0 g
s
.53848 .5493 m .53889 .56162 L .54423 .55976 L p .986 .833 .607 r
F P
0 g
s
.54515 .54707 m .54049 .53523 L .5338 .53738 L p .952 .657 .441 r
F P
0 g
s
.03 w
.49439 .56032 m
.53967 .54239 L
s
.5 Mabswid
.52579 .52826 m .5338 .53738 L .54049 .53523 L p .845 .425 .235 r
F P
0 g
s
.6454 .48588 m .64358 .48272 L .54348 .54088 L closepath p .757 .94 .943 r
F P
0 g
s
.65623 .51482 m .65559 .51174 L .54348 .54088 L closepath p .383 0 .038 r
F P
0 g
s
.65445 .51177 m .65623 .51482 L .54348 .54088 L closepath p .615 .881 .99 r
F P
0 g
s
.6509 .50369 m .65445 .51177 L .54348 .54088 L closepath p .687 .688 .845 r
F P
0 g
s
.64697 .49371 m .6509 .50369 L .54348 .54088 L closepath p .652 .545 .72 r
F P
0 g
s
.64417 .48569 m .64697 .49371 L .54348 .54088 L closepath p .571 .364 .56 r
F P
0 g
s
.64358 .48272 m .64417 .48569 L .54348 .54088 L closepath p .209 0 .043 r
F P
0 g
s
.03 w
.54282 .54115 m
.54348 .54088 L
s
.5 Mabswid
.5338 .53738 m .53848 .5493 L .54515 .54707 L p .952 .657 .441 r
F P
0 g
s
.31029 .64549 m .35236 .62887 L .36234 .64677 L p .723 .707 .835 r
F P
0 g
s
.45457 .56156 m .35912 .59941 L .35451 .58019 L p .607 .381 .548 r
F P
0 g
s
.35451 .58019 m .44931 .54249 L .45457 .56156 L p .607 .381 .548 r
F P
0 g
s
.56021 .58348 m .58953 .65813 L .583 .6612 L p .952 .657 .441 r
F P
0 g
s
.583 .6612 m .55348 .58603 L .56021 .58348 L p .952 .657 .441 r
F P
0 g
s
.50161 .53757 m .50271 .52891 L .49752 .53115 L p .328 .08 .378 r
F P
0 g
s
.49752 .53115 m .49225 .54157 L .50161 .53757 L p .328 .08 .378 r
F P
0 g
s
.47307 .60315 m .37808 .64057 L .36818 .62261 L p .723 .707 .835 r
F P
0 g
s
.50531 .57487 m .51636 .57916 L .52159 .57703 L p .574 .738 .953 r
F P
0 g
s
.52579 .52826 m .51609 .52377 L .50981 .52609 L p .643 .279 .338 r
F P
0 g
s
.53495 .57183 m .53889 .56162 L .52759 .56592 L p .844 .851 .849 r
F P
0 g
s
.52759 .56592 m .5287 .57423 L .53495 .57183 L p .844 .851 .849 r
F P
0 g
s
.50359 .54903 m .50161 .53757 L .49225 .54157 L p .446 .319 .614 r
F P
0 g
s
.49225 .54157 m .4919 .55398 L .50359 .54903 L p .446 .319 .614 r
F P
0 g
s
.51446 .53246 m .50981 .52609 L .50271 .52891 L p .547 .262 .435 r
F P
0 g
s
.50271 .52891 m .50161 .53757 L .51446 .53246 L p .547 .262 .435 r
F P
0 g
s
.47688 .51739 m .44757 .44265 L .45932 .43701 L p .505 .464 .746 r
F P
0 g
s
.52159 .57703 m .51472 .571 L .50531 .57487 L p .574 .738 .953 r
F P
0 g
s
.49657 .56588 m .50531 .57487 L .51472 .571 L p .546 .59 .85 r
F P
0 g
s
.50981 .52609 m .51446 .53246 L .52579 .52826 L p .643 .279 .338 r
F P
0 g
s
.51472 .571 m .52159 .57703 L .5287 .57423 L p .731 .778 .89 r
F P
0 g
s
.35236 .62887 m .31029 .64549 L .30128 .62235 L p .682 .56 .711 r
F P
0 g
s
.30128 .62235 m .34331 .60568 L .35236 .62887 L p .682 .56 .711 r
F P
0 g
s
.5287 .57423 m .52759 .56592 L .51472 .571 L p .731 .778 .89 r
F P
0 g
s
.45932 .43701 m .48879 .51212 L .47688 .51739 L p .505 .464 .746 r
F P
0 g
s
.50829 .56099 m .50359 .54903 L .4919 .55398 L p .505 .464 .746 r
F P
0 g
s
.4919 .55398 m .49657 .56588 L .50829 .56099 L p .505 .464 .746 r
F P
0 g
s
.51472 .571 m .50829 .56099 L .49657 .56588 L p .546 .59 .85 r
F P
0 g
s
.5338 .53738 m .52579 .52826 L .51446 .53246 L p .755 .494 .537 r
F P
0 g
s
.53984 .67797 m .51043 .60296 L .52253 .59814 L p .505 .464 .746 r
F P
0 g
s
.53889 .56162 m .53848 .5493 L .52436 .55463 L p .835 .725 .743 r
F P
0 g
s
.52436 .55463 m .52759 .56592 L .53889 .56162 L p .835 .725 .743 r
F P
0 g
s
.4904 .42539 m .51981 .50028 L .50526 .50556 L p .805 .618 .649 r
F P
0 g
s
.50526 .50556 m .47575 .43038 L .4904 .42539 L p .805 .618 .649 r
F P
0 g
s
.52253 .59814 m .55211 .67354 L .53984 .67797 L p .505 .464 .746 r
F P
0 g
s
.36818 .62261 m .4637 .58487 L .47307 .60315 L p .723 .707 .835 r
F P
0 g
s
.53848 .5493 m .5338 .53738 L .51967 .54267 L p .805 .618 .649 r
F P
0 g
s
.51446 .53246 m .51967 .54267 L .5338 .53738 L p .755 .494 .537 r
F P
0 g
s
.51967 .54267 m .52436 .55463 L .53848 .5493 L p .805 .618 .649 r
F P
0 g
s
.4637 .58487 m .36818 .62261 L .35912 .59941 L p .682 .56 .711 r
F P
0 g
s
.35912 .59941 m .45457 .56156 L .4637 .58487 L p .682 .56 .711 r
F P
0 g
s
.51967 .54267 m .51446 .53246 L .50161 .53757 L p .639 .451 .612 r
F P
0 g
s
.50161 .53757 m .50359 .54903 L .51967 .54267 L p .639 .451 .612 r
F P
0 g
s
.25567 .63361 m .30283 .62248 L .34774 .62951 L p .281 0 0 r
F P
0 g
s
.55348 .58603 m .583 .6612 L .56866 .6671 L p .805 .618 .649 r
F P
0 g
s
.56866 .6671 m .53905 .59164 L .55348 .58603 L p .805 .618 .649 r
F P
0 g
s
.50829 .56099 m .51472 .571 L .52759 .56592 L p .712 .657 .794 r
F P
0 g
s
.52759 .56592 m .52436 .55463 L .50829 .56099 L p .712 .657 .794 r
F P
0 g
s
.48879 .51212 m .45932 .43701 L .47575 .43038 L p .682 .56 .711 r
F P
0 g
s
.47575 .43038 m .50526 .50556 L .48879 .51212 L p .682 .56 .711 r
F P
0 g
s
.34774 .62951 m .30486 .64135 L .25567 .63361 L p .281 0 0 r
F P
0 g
s
.52436 .55463 m .51967 .54267 L .50359 .54903 L p .682 .56 .711 r
F P
0 g
s
.50359 .54903 m .50829 .56099 L .52436 .55463 L p .682 .56 .711 r
F P
0 g
s
.02 w
.50562 .55317 m
.5068 .55298 L
s
.5068 .55298 m
.51323 .55195 L
s
.51323 .55195 m
.51397 .55183 L
s
.5 Mabswid
.55211 .67354 m .52253 .59814 L .53905 .59164 L p .682 .56 .711 r
F P
0 g
s
.53905 .59164 m .56866 .6671 L .55211 .67354 L p .682 .56 .711 r
F P
0 g
s
.36874 .30158 m .44866 .4513 L .49136 .43411 L p .73 .744 .863 r
F P
0 g
s
.36842 .59254 m .39458 .58727 L .43542 .59356 L p .236 0 0 r
F P
0 g
s
.49136 .43411 m .41406 .28289 L .36874 .30158 L p .73 .744 .863 r
F P
0 g
s
.43542 .59356 m .41194 .59926 L .36842 .59254 L p .236 0 0 r
F P
0 g
s
.46525 .55659 m .48134 .55417 L .4858 .53669 L p .899 .87 .431 r
F P
0 g
s
.48134 .55417 m .46525 .55659 L .47218 .57429 L p .883 .526 .039 r
F P
0 g
s
.47218 .57429 m .48793 .57099 L .48134 .55417 L p .883 .526 .039 r
F P
0 g
s
.02 w
.48784 .556 m
.50562 .55317 L
s
.5 Mabswid
.48793 .57099 m .47218 .57429 L .48811 .58455 L p .567 0 0 r
F P
0 g
s
.48811 .58455 m .50307 .58073 L .48793 .57099 L p .567 0 0 r
F P
0 g
s
.46994 .53818 m .4858 .53669 L .49962 .52518 L p .601 .925 .697 r
F P
0 g
s
.4858 .53669 m .46994 .53818 L .46525 .55659 L p .899 .87 .431 r
F P
0 g
s
.50307 .58073 m .48811 .58455 L .50697 .58344 L p .011 0 0 r
F P
0 g
s
.50697 .58344 m .521 .57967 L .50307 .58073 L p .011 0 0 r
F P
0 g
s
.48448 .52607 m .49962 .52518 L .51755 .52407 L p .045 .613 .707 r
F P
0 g
s
.49962 .52518 m .48448 .52607 L .46994 .53818 L p .601 .925 .697 r
F P
0 g
s
.521 .57967 m .50697 .58344 L .52157 .57135 L p .555 .894 .652 r
F P
0 g
s
.52157 .57135 m .53487 .56819 L .521 .57967 L p .555 .894 .652 r
F P
0 g
s
.51755 .52407 m .50334 .5249 L .48448 .52607 L p .045 .613 .707 r
F P
0 g
s
.50334 .5249 m .51755 .52407 L .53274 .5338 L p .523 0 0 r
F P
0 g
s
.53487 .56819 m .52157 .57135 L .52629 .55289 L p .869 .848 .388 r
F P
0 g
s
.52629 .55289 m .53936 .55066 L .53487 .56819 L p .869 .848 .388 r
F P
0 g
s
.51932 .53514 m .53274 .5338 L .53936 .55066 L p .854 .496 0 r
F P
0 g
s
.53274 .5338 m .51932 .53514 L .50334 .5249 L p .523 0 0 r
F P
0 g
s
.53936 .55066 m .52629 .55289 L .51932 .53514 L p .854 .496 0 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00M@3oool200000:T0oooo001c0?ooo`8000000P2j_]`00`000000oooo0?ooo`2V0?ooo`00
L03oool3000000@0^[kL00<000000?ooo`3oool0YP3oool006d0oooo0`0000080;Zng0030000003o
ool0oooo0:D0oooo001[0?ooo`8000002`2j_]`00`000000oooo0?ooo`2U0?ooo`00J@3oool20000
00h0^[kL00<000000?ooo`3oool0Y03oool006X0oooo3`2j_]`00`000000oooo0?ooo`2T0?ooo`00
JP3oool00`000000^[kL0;Zng00=0;Zng0030000003oool0oooo0:<0oooo001[0?ooo`030000002j
_]`0^[kL00`0^[kL00<000000?ooo`3oool0X`3oool006/0oooo00<000000;Zng02j_]`03@2j_]`0
0`000000oooo0?ooo`070?ooo`800000V@3oool006`0oooo00<000000;Zng02j_]`0302j_]`00`00
0000oooo0?ooo`050?ooo`80000000<0TDij0000003oool0V03oool006`0oooo00<000000;Zng02j
_]`03@2j_]`00`000000oooo0?ooo`020?ooo`800000102ACWX00`000000oooo0?ooo`2F0?ooo`00
K@3oool00`000000^[kL0;Zng00<0;Zng0030000003oool0oooo008000001P2ACWX00`000000oooo
0?ooo`2F0?ooo`00K@3oool00`000000^[kL0;Zng00=0;Zng0800000202ACWX00`000000oooo0?oo
o`2F0?ooo`00KP3oool00`000000^[kL0;Zng00<0;Zng0030000002ACWX0TDij00L0TDij00<00000
0?ooo`3oool0UP3oool006h0oooo00<000000;Zng02j_]`03@2j_]`00`000000TDij095>NP07095>
NP030000003oool0oooo09D0oooo001_0?ooo`030000002j_]`0^[kL00d0^[kL00<00000095>NP2A
CWX01P2ACWX00`000000oooo0?ooo`2E0?ooo`00K`3oool00`000000^[kL0;Zng00=0;Zng0030000
002ACWX0TDij00H0TDij00<000000?ooo`3oool0U@3oool00700oooo00<000000;Zng02j_]`03@2j
_]`00`000000TDij095>NP05095>NP030000003oool0oooo09D0oooo001`0?ooo`030000002j_]`0
^[kL00d0^[kL00<00000095>NP2ACWX01P2ACWX00`000000oooo0?ooo`2D0?ooo`00L@3oool00`00
0000^[kL0;Zng00=0;Zng0030000002ACWX0TDij00D0TDij00<000000?ooo`3oool0U03oool00780
oooo00<000000;Zng02j_]`0302j_]`00`000000TDij095>NP05095>NP030000003oool0oooo09@0
oooo001b0?ooo`030000002j_]`0^[kL00d0^[kL00<00000095>NP2ACWX0102ACWX00`000000oooo
0?ooo`2D0?ooo`00L`3oool00`000000^[kL0;Zng00<0;Zng0030000002ACWX0TDij00D0TDij00<0
00000?ooo`3oool0T`3oool007<0oooo00<000000;Zng02j_]`03@2j_]`00`000000TDij095>NP04
095>NP030000003oool0oooo09<0oooo001d0?ooo`030000002j_]`0^[kL00`0^[kL00<00000095>
NP2ACWX0102ACWX00`000000oooo0?ooo`2C0?ooo`00M03oool00`000000^[kL0;Zng00=0;Zng003
0000002ACWX0TDij00<0TDij00<000000?ooo`3oool0T`3oool007D0oooo00<000000;Zng02j_]`0
302j_]`00`000000TDij095>NP04095>NP030000003oool0oooo0980oooo001e0?ooo`030000002j
_]`0^[kL00d0^[kL00<00000095>NP2ACWX00`2ACWX00`000000oooo0?ooo`2B0?ooo`00MP3oool0
0`000000^[kL0;Zng00=0;Zng0030000002ACWX0TDij0080TDij00<000000?ooo`3oool0TP3oool0
07H0oooo00<000000;Zng02j_]`03@2j_]`00`000000TDij095>NP02095>NP030000003oool0oooo
0980oooo001g0?ooo`030000002j_]`0^[kL00d0^[kL00<00000095>NP2ACWX00P2ACWX00`000000
oooo0?ooo`2A0?ooo`00M`3oool00`000000^[kL0;Zng00=0;Zng0030000002ACWX0TDij0080TDij
00<000000?ooo`3oool0T@3oool007P0oooo00<000000;Zng02j_]`03@2j_]`01@000000TDij095>
NP2ACWX0000009<0oooo001i0?ooo`030000002j_]`0^[kL00`0^[kL00D00000095>NP2ACWX0TDij
0000002C0?ooo`00N@3oool00`000000^[kL0;Zng00=0;Zng0050000002ACWX0TDij095>NP000000
TP3oool007X0oooo00<000000;Zng02j_]`0302j_]`01@000000TDij095>NP2ACWX000000980oooo
001j0?ooo`030000002j_]`0^[kL00d0^[kL00@00000095>NP2ACWX00000TP3oool007/0oooo00<0
00000;Zng02j_]`0302j_]`010000000TDij095>NP00002B0?ooo`00N`3oool00`000000^[kL0;Zn
g00=0;Zng0040000002ACWX0TDij00000940oooo001l0?ooo`030000002j_]`0^[kL00`0^[kL00@0
0000095>NP0000000000T@3oool007`0oooo00<000000;Zng02j_]`03@2j_]`00`000000ljQ`0?>X
L02A0?ooo`00O@3oool00`000000^[kL0;Zng00<0;Zng0040000003cZ700ljQ`00000900oooo001m
0?ooo`030000002j_]`0^[kL00`0^[kL0P0000000`3cZ70000000?ooo`2?0?ooo`00OP3oool00`00
0000^[kL0;Zng0090;Zng080000000D0cYjV0000003cZ700ljQ`0000002?0?ooo`00OP3oool00`00
0000^[kL0;Zng0060;Zng0<00000103>WZH00`000000ljQ`0000002?0?ooo`00O`3oool00`000000
^[kL0;Zng0020;Zng0<000000`2^SkH01`000000cYjV0<jNYP3>WZH000000?>XL0000000S`3oool0
07l0oooo00<000000;Zng02j_]`00`0000050:j?]P030000003>WZH0cYjV0080cYjV00<000000?>X
L0000000SP3oool00800oooo0P000003085f_P030000002^SkH0[Xnf0080[Xnf00<000000<jNYP3>
WZH00P3>WZH00`000000ljQ`0000002>0?ooo`00P03oool2000000<0PGJn00<000000:j?]P2^SkH0
0`2^SkH01@000000cYjV0<jNYP3>WZH000000080ljQ`00<000000?ooo`3oool0R`3oool00840oooo
0P000003085f_P030000002^SkH0[Xnf0080[Xnf00<000000<jNYP3>WZH00P3>WZH00`000000ljQ`
0000002=0?ooo`00P@3oool2000000<0PGJn00<000000:j?]P2^SkH00`2^SkH01`000000cYjV0<jN
YP3>WZH000000?>XL0000000S@3oool00840oooo0P000003085f_P030000002^SkH0[Xnf00<0[Xnf
00<000000<jNYP3>WZH00P3>WZH00`000000ljQ`0000002<0?ooo`00PP3oool2000000<0PGJn00<0
00000:j?]P2^SkH00P2^SkH00`000000cYjV0<jNYP020<jNYP030000003cZ700000008`0oooo0022
0?ooo`8000000`21M[h00`000000[Xnf0:j?]P030:j?]P030000003>WZH0cYjV0080cYjV00<00000
0?>XL0000000R`3oool008<0oooo00<00000085f_P21M[h00P21M[h00`000000[Xnf0:j?]P020:j?
]P030000003>WZH0cYjV0080cYjV00<000000?>XL0000000R`3oool008<0oooo0P000003085f_P03
0000002^SkH0[Xnf00<0[Xnf00D000000<jNYP3>WZH0cYjV000000020?>XL0030000003oool0oooo
08P0oooo00230?ooo`8000001021M[h00`000000[Xnf0:j?]P020:j?]P030000003>WZH0cYjV0080
cYjV00<000000?>XL00000008P3oool00`000000oooo0?ooo`1U0?ooo`00Q03oool2000000<0PGJn
00<000000:j?]P2^SkH00`2^SkH01`000000cYjV0<jNYP3>WZH000000?>XL0000000803oool40000
06H0oooo00240?ooo`8000000`21M[h00`000000[Xnf0:j?]P030:j?]P030000003>WZH0cYjV0080
cYjV00<000000?>XL00000007@3oool6000006H0oooo00250?ooo`0300000021M[h0PGJn0080PGJn
00<000000:j?]P2^SkH00P2^SkH00`000000cYjV0<jNYP020<jNYP030000003cZ700000001`0oooo
0`000002099MS`<00000I@3oool008D0oooo0P000003085f_P030000002^SkH0[Xnf00<0[Xnf00<0
00000<jNYP3>WZH00P3>WZH00`000000ljQ`0000000I0?ooo`<000000P2BGHl2000000030:J;^000
0000000006D0oooo00260?ooo`0300000021M[h0PGJn0080PGJn00<000000:j?]P2^SkH00P2^SkH0
10000000cYjV0<jNYP3>WZH4000001L0oooo0`000002099MS`800000102VRkP2000006@0oooo0026
0?ooo`0300000021M[h0PGJn0080PGJn00<000000:j?]P2^SkH00`2^SkH4000001P0oooo0`000002
099MS`8000001@2VRkP3000006@0oooo00260?ooo`8000001021M[h30:j?]P@000006@3oool30000
0003099MS`000000000000@0YX^h0`0000000`2_/=P000000000001T0?ooo`00Q`3oool010000000
PGJn085f_P21M[h6000001T0oooo0`0000000`2BGHl00000000000030:J;^0<00000102_/=P30000
06<0oooo00270?ooo`0300000021M[h0000000<000000P3oool2000001L0oooo0`0000000`2BGHl0
0000000000030:J;^08000000`2_/=P7000006<0oooo00280?ooo`<00000103oool3000001D0oooo
1@0000020:J;^0<000000P2_/=P7000006H0oooo00280?ooo`030000003oool0oooo00D0oooo0P00
000C0?ooo`@000000P2VRkP3000000030:n`f0000000000000D00000JP3oool008/0oooo40000000
0`3oool000000?ooo`050?ooo`@0000000<0YX^h0000000000002000001^0?ooo`00RP3oool01000
0000VNbb09W//P2Ik;8500000080Q@00200000040?ooo`d00000LP3oool008P0oooo0P00000309W/
/P80000000<0DaAP0000002<@fl00`0000000`250000000000000007000000030?ooo`0000000000
00P00000MP3oool00800oooo0P0000050?ooo`030000002Ik;80VNbb0080VNbb1P0000020:=cW180
0000NP3oool007h0oooo0P0000000`1700<000000?ooo`030?ooo`H0000000@0oooo000000000000
0000102SLi`200000080fWh02P00001n0?ooo`00N`3oool30000000304L00`000000000000800000
0`3oool00`000000i]i^0>KNKP020>KNKP<0000000<0LU6M0000002SLi`00`2SLi`300000080fWh0
1`0000200?ooo`00N@3oool200000080A`030P0000001@2KHH`000000;Vce02i/m@000000080oooo
00<000000>KNKP3VgVh00P3VgVh300000003079AW@000000000000H000000P3JOP06000000030=Yn
00000000oooo07h0oooo001f0?ooo`<0000000@0A`030000000000000000102KHH`01@000000^K?D
0000003oool0000000@0i]i^30000000103>WZH000000=Yn003JOP07000007l0oooo001d0?ooo`80
00000P1700<2000000L0Vf6<00<000000;Vce02i/m@00P0000040>KNKQD0000000<0g]US0000003o
ool0OP3oool00780oooo0P000000101700<0000000000000000909]QS0030000002i/m@0^K?D01@0
00000P3NfF<600000800oooo001_0?ooo`<0000000<0A`030000000000003@2KHH`4000000@0hXH9
3@0000030=kIH`<000000P3NfF<00`000000oooo0?ooo`1n0?ooo`00K@3oool200000080A`030P00
000>09]QS0H000000`3RQPT500000004085f_P0000000000000000<0]ZS;00<000000=kIH`3NfF<0
1P0000210?ooo`00JP3oool30000000404L00`0000000000000000h0Vf6<0P0000000`2^SkH00000
00000003000000@0hXH91@00000208^Gf@040000002fZ</0]ZS;000000<0g]US1@0000220?ooo`00
J03oool200000080A`030P00000>09]QS0<00000102^SkH500000080hXH91`0000000`2;UmT00000
00000009000008<0oooo001V0?ooo`80000000@0A`0300000000000000003P2KHH`2000000L0[Xnf
1`000003094000<0000000D0057>0000002B_?<0T[cc0000000208kTYPD00000Q03oool006H0oooo
0`00000>09]QS0<000002P2^SkH6000000@0T@001P00000208kTYP@00000QP3oool00600oooo0P00
00030?ooo`8000003P2KHH`2000000d0[Xnf1@0000000`3oool0000000000002094000P0000000<0
oooo000000000000Q`3oool005d0oooo0`0000001P1700<00000000000000000oooo000000d0Vf6<
0P00000@0:j?]P@000000`3oool7000000@0oooo0`0000050?ooo`800000O`3oool005X0oooo0`00
000304L00`8000000P2i/m@00`000000oooo0000000809]QS0D000003P2^SkH2000000050;Vde@00
0000000009aSSP0000003P3oool300000080oooo0`0000020?>XL7l0oooo001G0?ooo`<000001017
00<20000000709]QS0000000^K?D0;Vce0000000oooo0000000409]QS0@000001@0l0006000000D0
[Xnf0`0000040;Vde@030000002LHhh0000000h0oooo1@0000030<jNYP80ljQ`00<000000?ooo`3o
ool0O03oool005D0oooo0P00000404L00`<000000`2KHH`010000000^K?D0;Vce02i/m@200000080
Vf6<1`00000903`000H000001`2i]=D010000000W6>>09aSSP00000=0?ooo`80000000<0[Xnf0000
003>WZH00`3>WZH00`000000ljQ`0000001n0?ooo`00E@3oool010000000A`0304L00`1700<20000
00L0Vf6<00L000000;Vce02i/m@000000?ooo`000000Vf6<008000001@2^SkH9000000040:j?]P00
00000000000000T0^KCE00@0000009aSSP2LHhh000002`3oool2000000@0[Xnf00D000000<jNYP3>
WZH0cYjV000000020?>XL0030000003oool0oooo07/0oooo001E0?ooo`040000001700<000000000
00T0Vf6<00<000000;Vce00000001000000>0:j?]P<000003@2i]=D3000000P0oooo100000050:j?
]P030000003>WZH0cYjV0080cYjV00<000000?>XL0000000O@3oool005D0oooo0P00000:09]QS0L0
00003@2^SkH200000100^KCE00<0000005404@0000001`3oool2000000<0PGJn00<000000:j?]P2^
SkH00`2^SkH01@000000cYjV0<jNYP3>WZH000000080ljQ`00<000000?ooo`3oool0NP3oool005D0
oooo00<0000009]QS02KHH`01`2KHH`2000000030:j?]P000000000000D000002@2^SkH3000000h0
^KCE0`0000020:o[n08000001`3oool2000000<0PGJn00<000000:j?]P2^SkH00`2^SkH00`000000
cYjV0<jNYP020<jNYP030000003cZ700000007`0oooo001E0?ooo`030000002KHH`0Vf6<00@0Vf6<
0`0000040:j?]PH000001`2^SkH2000000l0^KCE0P0000030:o[n08000002P3oool2000000<0PGJn
00<000000:j?]P2^SkH00P2^SkH00`000000cYjV0<jNYP020<jNYP030000003cZ700000007`0oooo
001F0?ooo`040000002KHH`0Vf6<09]QS08000001`2^SkH6000000@0[Xnf0`00000>0;Vde@<00000
0P2_joP3000000`0oooo0P000003085f_P030000002^SkH0[Xnf00<0[Xnf00D000000<jNYP3>WZH0
cYjV000000020?>XL0030000003oool0oooo07T0oooo001F0?ooo`040000002KHH`00000000000X0
[Xnf1P0000000`2^SkH000000000000>0;Vde@<000000`2_joP200000100oooo0P000002085f_P03
0000002^SkH0[Xnf00<0[Xnf00<000000<jNYP3>WZH00P3>WZH00`000000ljQ`0000001k0?ooo`00
E03oool6000000X0[Xnf1`00000>0;Vde@8000000`2_joP300000180oooo0P000003085f_P030000
002^SkH0[Xnf00<0[Xnf00D000000<jNYP3>WZH0cYjV000000020?>XL0030000003oool0oooo07P0
oooo001@0?ooo`@000001P170006000000D0[Xnf1P00000;0;Vde@<000000`2_joP2000001D0oooo
0P000003085f_P030000002^SkH0[Xnf00<0[Xnf00<000000<jNYP3>WZH00P3>WZH00`000000ljQ`
0000001j0?ooo`00C03oool400000100A`00200000000`2LHhh00000000000080;Vde@<00000102_
joP2000001P0oooo0P000003085f_P030000002^SkH0[Xnf0080[Xnf00<000000<jNYP3>WZH00P3>
WZH010000000ljQ`0?>XL000001i0?ooo`00B@3oool3000001<0A`001@0000020;Vde@060000002L
Hhh0W6>>0000003oool000001@2i]=D2000000@0[n_h0`00000J0?ooo`8000000`21M[h00`000000
[Xnf0:j?]P030:j?]P030000003>WZH0cYjV0080cYjV00<000000?>XL0000000N@3oool004`0oooo
1000000<04L000H00000102i]=D010000000W6>>09aSSP2LHhh200000080^KCE0`0000040:o[n080
00007@3oool2000000<0PGJn00<000000:j?]P2^SkH00`2^SkH00`000000cYjV0<jNYP020<jNYP03
0000003cZ700000007T0oooo001?0?ooo`H0000010170003000000030:j?]P000000000000P0^KCE
00D0000009aSSP2LHhh000000?ooo`02000000@0[n_h0`00000P0?ooo`8000000`21M[h00`000000
[Xnf0:j?]P030:j?]P050000003>WZH0cYjV0<jNYP0000000P3cZ7000`000000oooo0?ooo`1f0?oo
o`00B`3oool9000000030?ooo`000000000000<0000000<0[Xnf0000000000002P2i]=D010000000
W6>>0000000000020?ooo`030000002_joP0[n_h008000008`3oool2000000<0PGJn00<000000:j?
]P2^SkH00`2^SkH00`000000cYjV0<jNYP020<jNYP030000003cZ700000007P0oooo00170?ooo``0
00000`3oool5000000d0^KCE00<0000005404@0000000`3oool2000002H0oooo00<000RH00000021
M[h00P21M[h00`000000[Xnf0:j?]P030:j?]P050000003>WZH0cYjV0<jNYP0000000P3cZ7000`00
0000oooo0?ooo`1e0?ooo`00@`3oool5000000050:EXR`00000000000000002eT[<0100000050?oo
o`050000003oool0oooo0?ooo`0000002P2i]=D200000080[n_h0P00000[0?ooo`8000000`21M[h0
0`000000[Xnf0:j?]P030:j?]P030000003>WZH0cYjV0080cYjV00<000000?>XL0000000M`3oool0
03l0oooo1P000000102UJ8/000000000000000020;FB/`@000002`3oool00`000000^KCE0;Vde@05
0;Vde@<000001@2_joP00`000000oooo0?ooo`0Y0?ooo`8000001021M[h00`000000[Xnf0:j?]P02
0:j?]P030000003>WZH0cYjV0080cYjV00@000000?>XL03cZ7000000MP3oool003/0oooo1P000002
0:EXR`<000000P2eT[<6000000d0oooo00<000000;Vde@2i]=D00P2i]=D2000000@0[n_h0`00000^
0?ooo`030008V0000000PGJn0080PGJn00<000000:j?]P2^SkH00`2^SkH00`000000cYjV0<jNYP02
0<jNYP<00000MP3oool003T0oooo1@0000030:EXR`8000000`2eT[<2000000040<6gd@0000000000
000000l0oooo00<000000;Vde@2i]=D00P0000030:o[n0<00000<@3oool2000000<0PGJn00<00000
0:j?]P2^SkH00`2^SkH010000000cYjV0<jNYP3>WZH3000007L0oooo000h0?ooo`800000102UJ8/3
000000<0]I:c0P0000001031]m40000000000000000B0?ooo`8000000P2_joP3000003@0oooo0P00
0004085f_P030000002^SkH0[Xnf00<0[Xnf0`00001j0?ooo`00>03oool00`000000YFR;0:EXR`03
000000@0]I:c0P0000000`31]m40000000000002000001@0oooo0`00000h0?ooo`030008V0000000
PGJn0080PGJn00<000000:j?]P2^SkH00P2^SkH2000007`0oooo000i0?ooo`8000001@2eT[<20000
0080`KOA00<000000<;_l@000000D@3oool2000000@0PGJn0P2^SkH3000007d0oooo000i0?ooo`03
0000002eT[<0]I:c0080]I:c0P0000020<6gd@@00000D`3oool00`0029P0PGJn085f_P0400000003
0?ooo`000000000007d0oooo000j0?ooo`040000002eT[<0000000000080`KOA1000001E0?ooo`<0
00001P3oool2000007`0oooo000j0?ooo`8000000P31]m42000000030<;_l@000000oooo05l0oooo
0P00001l0?ooo`00>P3oool01@000000`KOA000000000000`^oa00800000H@3oool3000007/0oooo
000k0?ooo`0400000032ko400000000006@0oooo0P00001k0?ooo`00?03oool00`000000oooo0?oo
o`1T0?ooo`800000N`3oool00:@0oooo0P00001j0?ooo`00Y03oool2000007X0oooo002T0?ooo`80
0000NP3oool00:D0oooo0P00001i0?ooo`00Y@3oool2000007T0oooo002U0?ooo`<00000N03oool0
0:H0oooo00<000000?ooo`3oool0M`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.51403 .54864 m .47059 .53955 L .46398 .55483 L p .412 .229 .52 r
F P
0 g
s
.47059 .53955 m .51403 .54864 L .51215 .53189 L p .365 .358 .719 r
F P
0 g
s
.51215 .53189 m .46869 .52323 L .47059 .53955 L p .365 .358 .719 r
F P
0 g
s
.50729 .56436 m .46398 .55483 L .45133 .56333 L p .422 .038 .202 r
F P
0 g
s
.46398 .55483 m .50729 .56436 L .51403 .54864 L p .412 .229 .52 r
F P
0 g
s
.46869 .52323 m .51215 .53189 L .50233 .5204 L p .24 .493 .896 r
F P
0 g
s
.50233 .5204 m .45897 .51201 L .46869 .52323 L p .24 .493 .896 r
F P
0 g
s
.38886 .56151 m .31574 .54431 L .34746 .55613 L p 0 .471 .795 r
F P
0 g
s
.49444 .57311 m .45133 .56333 L .43739 .56175 L p .23 0 0 r
F P
0 g
s
.45133 .56333 m .49444 .57311 L .50729 .56436 L p .422 .038 .202 r
F P
0 g
s
.43739 .56175 m .4803 .57153 L .49444 .57311 L p .23 0 0 r
F P
0 g
s
.4803 .57153 m .43739 .56175 L .42749 .55059 L p .21 .481 .893 r
F P
0 g
s
.47029 .56011 m .42749 .55059 L .4255 .53409 L p .35 .348 .717 r
F P
0 g
s
.42749 .55059 m .47029 .56011 L .4803 .57153 L p .21 .481 .893 r
F P
0 g
s
.43224 .51863 m .47519 .52726 L .46832 .54316 L p .399 .214 .511 r
F P
0 g
s
.46832 .54316 m .4255 .53409 L .43224 .51863 L p .399 .214 .511 r
F P
0 g
s
.4255 .53409 m .46832 .54316 L .47029 .56011 L p .35 .348 .717 r
F P
0 g
s
.44745 .54699 m .45316 .52918 L p .38452 .55884 L .826 .864 .875 r
F P
0 g
s
.34746 .55613 m .41792 .57292 L p .38886 .56151 L 0 .471 .795 r
F P
0 g
s
.40735 .56846 m .38886 .56151 L p .41792 .57292 L 0 .471 .795 r
F P
0 g
s
.35999 .56943 m .39086 .56151 L p .38452 .55884 L .826 .864 .875 r
F P
0 g
s
.39086 .56151 m .44745 .54699 L p .38452 .55884 L .826 .864 .875 r
F P
0 g
s
.41792 .57292 m .42142 .57375 L .40735 .56846 L p 0 .471 .795 r
F P
0 g
s
.30329 .58288 m .20454 .55677 L .24104 .56978 L p 0 .436 .754 r
F P
0 g
s
.345 .57328 m .35013 .55515 L p .30522 .58319 L .826 .864 .875 r
F P
0 g
s
.24104 .56978 m .33631 .59521 L p .30329 .58288 L 0 .436 .754 r
F P
0 g
s
.31942 .58868 m .30329 .58288 L p .33631 .59521 L 0 .436 .754 r
F P
0 g
s
.30439 .5837 m .30569 .58337 L p .30522 .58319 L .826 .864 .875 r
F P
0 g
s
.30569 .58337 m .345 .57328 L p .30522 .58319 L .826 .864 .875 r
F P
0 g
s
.33631 .59521 m .34133 .59655 L .31942 .58868 L p 0 .436 .754 r
F P
0 g
s
.45897 .51201 m .50233 .5204 L .48821 .51858 L p .177 0 0 r
F P
0 g
s
.48821 .51858 m .44505 .51021 L .45897 .51201 L p .177 0 0 r
F P
0 g
s
.02 w
.46914 .54125 m
.49061 .54577 L
s
.5 Mabswid
.50385 .50224 m .52127 .50043 L p .5021 .4447 L .702 .612 .753 r
F P
0 g
s
.40846 .28321 m .4931 .41568 L p .48155 .43553 L .773 .492 .509 r
F P
0 g
s
.4931 .41568 m .50271 .43072 L .48663 .43438 L p .773 .492 .509 r
F P
0 g
s
.48663 .43438 m .48155 .43553 L p .4931 .41568 L .773 .492 .509 r
F P
0 g
s
.48155 .43553 m .46527 .43924 L p .4605 .42615 L .773 .492 .509 r
F P
0 g
s
.4605 .42615 m .40846 .28321 L .48155 .43553 L .773 .492 .509 r
F
.48059 .42759 m .47459 .43107 L p .47941 .45522 L .993 .8 .54 r
F P
0 g
s
.48949 .5058 m .48266 .44582 L p .47941 .45522 L .993 .8 .54 r
F P
0 g
s
.48266 .44582 m .48059 .42759 L p .47941 .45522 L .993 .8 .54 r
F P
0 g
s
.49509 .42432 m .49714 .44248 L p .5021 .4447 L .702 .612 .753 r
F P
0 g
s
.49714 .44248 m .50385 .50224 L p .5021 .4447 L .702 .612 .753 r
F P
0 g
s
.46527 .43924 m .37139 .28989 L .40846 .28321 L p .773 .492 .509 r
F P
0 g
s
.44505 .51021 m .48821 .51858 L .47519 .52726 L p .404 .009 .174 r
F P
0 g
s
.47519 .52726 m .43224 .51863 L .44505 .51021 L p .404 .009 .174 r
F P
0 g
s
.62032 .52502 m .61931 .51511 L .54013 .54527 L closepath p .87 .731 .706 r
F P
0 g
s
.62478 .53371 m .62032 .52502 L .54013 .54527 L closepath p .823 .556 .535 r
F P
0 g
s
.61931 .51511 m .62215 .50771 L .54013 .54527 L closepath p .865 .914 .862 r
F P
0 g
s
.63102 .53789 m .62478 .53371 L .54013 .54527 L closepath p .657 .205 .166 r
F P
0 g
s
.62215 .50771 m .62779 .50565 L .54013 .54527 L closepath p 0 0 0 r
F P
0 g
s
.63669 .53594 m .63102 .53789 L .54013 .54527 L closepath p .373 .832 .912 r
F P
0 g
s
.62779 .50565 m .63408 .50977 L .54013 .54527 L closepath p .625 .266 .34 r
F P
0 g
s
.6396 .52855 m .63669 .53594 L .54013 .54527 L closepath p .789 .827 .882 r
F P
0 g
s
.63408 .50977 m .6386 .51853 L .54013 .54527 L closepath p .763 .537 .591 r
F P
0 g
s
.6386 .51853 m .6396 .52855 L .54013 .54527 L closepath p .804 .685 .733 r
F P
0 g
s
.4995 .59375 m .50812 .66948 L .52218 .66531 L p .834 .706 .722 r
F P
0 g
s
.52218 .66531 m .5137 .58986 L .4995 .59375 L p .834 .706 .722 r
F P
0 g
s
.5137 .58986 m .52218 .66531 L .53933 .66359 L p .702 .612 .753 r
F P
0 g
s
.53933 .66359 m .53097 .5881 L .5137 .58986 L p .702 .612 .753 r
F P
0 g
s
.53097 .5881 m .53933 .66359 L .55321 .66493 L p .531 .485 .75 r
F P
0 g
s
.49373 .59833 m .50246 .67454 L .50812 .66948 L p .993 .8 .54 r
F P
0 g
s
.50812 .66948 m .4995 .59375 L .49373 .59833 L p .993 .8 .54 r
F P
0 g
s
.55321 .66493 m .54492 .58911 L .53097 .5881 L p .531 .485 .75 r
F P
0 g
s
.54492 .58911 m .55321 .66493 L .55857 .66889 L p 0 .065 .579 r
F P
0 g
s
.49875 .60186 m .5075 .67859 L .50246 .67454 L p 0 .032 .56 r
F P
0 g
s
.50246 .67454 m .49373 .59833 L .49875 .60186 L p 0 .032 .56 r
F P
0 g
s
.50135 .5674 m .49578 .55611 L .50969 .55246 L p .81 .603 .622 r
F P
0 g
s
.01 w
.52397 .61317 m
.53531 .71479 L
s
.5 Mabswid
.50969 .55246 m .5125 .56443 L .50135 .5674 L p .81 .603 .622 r
F P
0 g
s
.50832 .54027 m .50969 .55246 L .49578 .55611 L p .834 .706 .722 r
F P
0 g
s
.5125 .56443 m .50969 .55246 L .52659 .55072 L p .693 .532 .663 r
F P
0 g
s
.50969 .55246 m .50832 .54027 L .52524 .53852 L p .702 .612 .753 r
F P
0 g
s
.52524 .53852 m .52659 .55072 L .50969 .55246 L p .702 .612 .753 r
F P
0 g
s
.52659 .55072 m .52607 .56303 L .5125 .56443 L p .693 .532 .663 r
F P
0 g
s
.52607 .56303 m .52659 .55072 L .54022 .55155 L p .54 .402 .642 r
F P
0 g
s
.52659 .55072 m .52524 .53852 L .53888 .5393 L p .531 .485 .75 r
F P
0 g
s
.53888 .5393 m .54022 .55155 L .52659 .55072 L p .531 .485 .75 r
F P
0 g
s
.55857 .66889 m .55027 .59256 L .54492 .58911 L p 0 .065 .579 r
F P
0 g
s
.55027 .59256 m .55857 .66889 L .55321 .67399 L p .997 .803 .524 r
F P
0 g
s
.51003 .57554 m .50135 .5674 L .5125 .56443 L p .757 .464 .487 r
F P
0 g
s
.5125 .56443 m .51623 .57388 L .51003 .57554 L p .757 .464 .487 r
F P
0 g
s
.51623 .57388 m .5125 .56443 L .52607 .56303 L p .667 .421 .539 r
F P
0 g
s
.49578 .55611 m .49438 .54388 L .50832 .54027 L p .834 .706 .722 r
F P
0 g
s
.02 w
.49061 .54577 m
.4947 .54663 L
s
.5 Mabswid
.50866 .5302 m .50832 .54027 L .49438 .54388 L p .839 .811 .823 r
F P
0 g
s
.50832 .54027 m .50866 .5302 L .52228 .5288 L p .698 .695 .844 r
F P
0 g
s
.52228 .5288 m .52524 .53852 L .50832 .54027 L p .698 .695 .844 r
F P
0 g
s
.52607 .56303 m .52378 .5731 L .51623 .57388 L p .667 .421 .539 r
F P
0 g
s
.52378 .5731 m .52607 .56303 L .53701 .56374 L p .534 .294 .498 r
F P
0 g
s
.54022 .55155 m .53701 .56374 L .52607 .56303 L p .54 .402 .642 r
F P
0 g
s
.52524 .53852 m .52228 .5288 L .53323 .52938 L p .503 .572 .858 r
F P
0 g
s
.53323 .52938 m .53888 .5393 L .52524 .53852 L p .503 .572 .858 r
F P
0 g
s
.49684 .57084 m .49011 .56034 L .49578 .55611 L p .934 .614 .408 r
F P
0 g
s
.49578 .55611 m .50135 .5674 L .49684 .57084 L p .934 .614 .408 r
F P
0 g
s
.49438 .54388 m .49578 .55611 L .49011 .56034 L p .993 .8 .54 r
F P
0 g
s
.03 w
.47593 .56216 m
.48005 .56107 L
s
.5 Mabswid
.50756 .57748 m .49684 .57084 L .50135 .5674 L p .809 .391 .253 r
F P
0 g
s
.50135 .5674 m .51003 .57554 L .50756 .57748 L p .809 .391 .253 r
F P
0 g
s
.51623 .57388 m .52378 .5731 L p .50756 .57748 L .381 0 0 r
F P
0 g
s
.50756 .57748 m .51003 .57554 L .51623 .57388 L p .381 0 0 r
F P
0 g
s
.49438 .54388 m .49746 .53307 L .50866 .5302 L p .839 .811 .823 r
F P
0 g
s
.51067 .52423 m .50866 .5302 L .49746 .53307 L p .769 .934 .938 r
F P
0 g
s
.50866 .5302 m .51067 .52423 L .51826 .52344 L p .645 .808 .961 r
F P
0 g
s
.51826 .52344 m .52228 .5288 L .50866 .5302 L p .645 .808 .961 r
F P
0 g
s
.52378 .5731 m .52985 .57352 L p .50756 .57748 L .381 0 0 r
F P
0 g
s
.53701 .56374 m .52985 .57352 L .52378 .5731 L p .534 .294 .498 r
F P
0 g
s
.48059 .42759 m .48949 .5058 L .50385 .50224 L p .834 .706 .722 r
F P
0 g
s
.50385 .50224 m .49509 .42432 L .48059 .42759 L p .834 .706 .722 r
F P
0 g
s
.52228 .5288 m .51826 .52344 L .52435 .52376 L p .399 .677 .973 r
F P
0 g
s
.52435 .52376 m .53323 .52938 L .52228 .5288 L p .399 .677 .973 r
F P
0 g
s
.53701 .56374 m .54022 .55155 L .54542 .55466 L p .12 0 .43 r
F P
0 g
s
.54022 .55155 m .53888 .5393 L .54408 .54233 L p 0 .064 .579 r
F P
0 g
s
.54408 .54233 m .54542 .55466 L .54022 .55155 L p 0 .064 .579 r
F P
0 g
s
.52127 .50043 m .51264 .42248 L .49509 .42432 L p .702 .612 .753 r
F P
0 g
s
.01 w
.50457 .43939 m
.51008 .48875 L
s
.5 Mabswid
.51264 .42248 m .52127 .50043 L .5353 .50106 L p .531 .485 .75 r
F P
0 g
s
.52985 .57352 m .53701 .56374 L .54115 .5663 L p .23 0 .257 r
F P
0 g
s
.54542 .55466 m .54115 .5663 L .53701 .56374 L p .12 0 .43 r
F P
0 g
s
.49011 .56034 m .4887 .54802 L .49438 .54388 L p .993 .8 .54 r
F P
0 g
s
.49746 .53307 m .49438 .54388 L .4887 .54802 L p .95 .951 .652 r
F P
0 g
s
.53888 .5393 m .53323 .52938 L .53737 .53176 L p 0 .142 .688 r
F P
0 g
s
.53737 .53176 m .54408 .54233 L .53888 .5393 L p 0 .142 .688 r
F P
0 g
s
.52985 .57352 m .53213 .57496 L p .50756 .57748 L .381 0 0 r
F P
0 g
s
.54115 .5663 m .53213 .57496 L .52985 .57352 L p .23 0 .257 r
F P
0 g
s
.5128 .60296 m .52148 .68003 L .5075 .67859 L p .525 .482 .75 r
F P
0 g
s
.01 w
.52091 .58575 m
.52397 .61317 L
s
.5 Mabswid
.5075 .67859 m .49875 .60186 L .5128 .60296 L p .525 .482 .75 r
F P
0 g
s
.55321 .67399 m .54481 .59716 L .55027 .59256 L p .997 .803 .524 r
F P
0 g
s
.54481 .59716 m .55321 .67399 L .53902 .67826 L p .837 .709 .722 r
F P
0 g
s
.4887 .54802 m .49291 .53634 L .49746 .53307 L p .95 .951 .652 r
F P
0 g
s
.50444 .52582 m .49746 .53307 L .49291 .53634 L p .618 .915 .644 r
F P
0 g
s
.49746 .53307 m .50444 .52582 L .51067 .52423 L p .769 .934 .938 r
F P
0 g
s
.53323 .52938 m .52435 .52376 L .52662 .52506 L p 0 .211 .631 r
F P
0 g
s
.52662 .52506 m .53737 .53176 L .53323 .52938 L p 0 .211 .631 r
F P
0 g
s
.47459 .43107 m .4836 .5098 L .48949 .5058 L p .993 .8 .54 r
F P
0 g
s
.51586 .57937 m .50977 .57894 L .50756 .57748 L p .381 0 0 r
F P
0 g
s
.5235 .57859 m .51586 .57937 L p .50756 .57748 L .381 0 0 r
F P
0 g
s
.01 w
.52015 .57893 m
.52091 .58575 L
s
.5 Mabswid
.52971 .5769 m .5235 .57859 L p .50756 .57748 L .381 0 0 r
F P
0 g
s
.53213 .57496 m .52971 .5769 L p .50756 .57748 L .381 0 0 r
F P
0 g
s
.49684 .57084 m .50756 .57748 L .50977 .57894 L p .398 0 0 r
F P
0 g
s
.51067 .52423 m .50444 .52582 L p .50414 .52893 L .352 0 0 r
F P
0 g
s
.51826 .52344 m .51067 .52423 L p .50414 .52893 L .352 0 0 r
F P
0 g
s
.52435 .52376 m .51826 .52344 L p .50414 .52893 L .352 0 0 r
F P
0 g
s
.5353 .50106 m .52674 .42274 L .51264 .42248 L p .531 .485 .75 r
F P
0 g
s
.01 w
.51008 .48875 m
.5132 .5167 L
s
.5 Mabswid
.52674 .42274 m .5353 .50106 L .54062 .5039 L p 0 .065 .579 r
F P
0 g
s
.53213 .57496 m .54115 .5663 L .53683 .56976 L p .57 .881 .596 r
F P
0 g
s
.53683 .56976 m .52971 .5769 L .53213 .57496 L p .57 .881 .596 r
F P
0 g
s
.50977 .57894 m .50078 .57345 L .49684 .57084 L p .398 0 0 r
F P
0 g
s
.49011 .56034 m .49684 .57084 L .50078 .57345 L p 0 .106 .659 r
F P
0 g
s
.54115 .5663 m .54542 .55466 L .54005 .5589 L p .941 .95 .632 r
F P
0 g
s
.54005 .5589 m .53683 .56976 L .54115 .5663 L p .941 .95 .632 r
F P
0 g
s
.36311 .59391 m .45029 .57093 L .44745 .54699 L p .834 .705 .722 r
F P
0 g
s
.45029 .57093 m .36311 .59391 L .37336 .61574 L p .791 .548 .569 r
F P
0 g
s
.37336 .61574 m .46057 .59216 L .45029 .57093 L p .791 .548 .569 r
F P
0 g
s
.50078 .57345 m .49499 .56353 L .49011 .56034 L p 0 .106 .659 r
F P
0 g
s
.4887 .54802 m .49011 .56034 L .49499 .56353 L p 0 .032 .56 r
F P
0 g
s
.49291 .53634 m .50193 .52761 L .50444 .52582 L p .618 .915 .644 r
F P
0 g
s
.50444 .52582 m .50193 .52761 L .50414 .52893 L p .352 0 0 r
F P
0 g
s
.53047 .60115 m .53902 .67826 L .52148 .68003 L p .702 .613 .754 r
F P
0 g
s
.52148 .68003 m .5128 .60296 L .53047 .60115 L p .702 .613 .754 r
F P
0 g
s
.52662 .52506 m .52435 .52376 L p .50414 .52893 L .352 0 0 r
F P
0 g
s
.53902 .67826 m .53047 .60115 L .54481 .59716 L p .837 .709 .722 r
F P
0 g
s
.54542 .55466 m .54408 .54233 L .53869 .54649 L p .997 .803 .525 r
F P
0 g
s
.53869 .54649 m .54005 .5589 L .54542 .55466 L p .997 .803 .525 r
F P
0 g
s
.49499 .56353 m .49358 .55113 L .4887 .54802 L p 0 .032 .56 r
F P
0 g
s
.03 w
.48005 .56107 m
.49176 .558 L
s
.5 Mabswid
.49291 .53634 m .4887 .54802 L .49358 .55113 L p .087 0 .409 r
F P
0 g
s
.50078 .57345 m .50977 .57894 L .51586 .57937 L p .376 .673 .974 r
F P
0 g
s
.01 w
.51437 .52717 m
.51984 .57622 L
s
.5 Mabswid
.52971 .5769 m .53683 .56976 L .52559 .57279 L p .764 .942 .94 r
F P
0 g
s
.52559 .57279 m .5235 .57859 L .52971 .5769 L p .764 .942 .94 r
F P
0 g
s
.54408 .54233 m .53737 .53176 L .53302 .53504 L p .938 .611 .39 r
F P
0 g
s
.53302 .53504 m .53869 .54649 L .54408 .54233 L p .938 .611 .39 r
F P
0 g
s
.44745 .54699 m .35999 .56943 L .36311 .59391 L p .834 .705 .722 r
F P
0 g
s
.49358 .55113 m .49685 .53877 L .49291 .53634 L p .087 0 .409 r
F P
0 g
s
.50193 .52761 m .49291 .53634 L .49685 .53877 L p .201 0 .229 r
F P
0 g
s
.46057 .59216 m .37336 .61574 L .38701 .62683 L p .648 .251 .28 r
F P
0 g
s
.38701 .62683 m .47455 .6028 L .46057 .59216 L p .648 .251 .28 r
F P
0 g
s
.53737 .53176 m .52662 .52506 L .52418 .52686 L p .807 .378 .228 r
F P
0 g
s
.52418 .52686 m .53302 .53504 L .53737 .53176 L p .807 .378 .228 r
F P
0 g
s
.49685 .53877 m .50414 .52893 L .50193 .52761 L p .201 0 .229 r
F P
0 g
s
.51178 .57421 m .51586 .57937 L .5235 .57859 L p .639 .814 .967 r
F P
0 g
s
.51586 .57937 m .51178 .57421 L .50078 .57345 L p .376 .673 .974 r
F P
0 g
s
.5235 .57859 m .52559 .57279 L .51178 .57421 L p .639 .814 .967 r
F P
0 g
s
.52418 .52686 m .52662 .52506 L p .50414 .52893 L .352 0 0 r
F P
0 g
s
.01 w
.5132 .5167 m
.51427 .52634 L
s
.5 Mabswid
.49499 .56353 m .50078 .57345 L .51178 .57421 L p .494 .57 .861 r
F P
0 g
s
.47955 .43344 m .48859 .51273 L .4836 .5098 L p 0 .032 .56 r
F P
0 g
s
.4836 .5098 m .47459 .43107 L .47955 .43344 L p 0 .032 .56 r
F P
0 g
s
.53683 .56976 m .54005 .5589 L .526 .56265 L p .842 .817 .826 r
F P
0 g
s
.526 .56265 m .52559 .57279 L .53683 .56976 L p .842 .817 .826 r
F P
0 g
s
.54062 .5039 m .53204 .42504 L .52674 .42274 L p 0 .065 .579 r
F P
0 g
s
.53204 .42504 m .54062 .5039 L .53505 .50792 L p .997 .803 .524 r
F P
0 g
s
.51792 .52846 m .52418 .52686 L p .50414 .52893 L .352 0 0 r
F P
0 g
s
.50414 .52893 m .51025 .52926 L .51792 .52846 L p .352 0 0 r
F P
0 g
s
.50787 .5394 m .51025 .52926 L .50414 .52893 L p .527 .284 .49 r
F P
0 g
s
.50414 .52893 m .49685 .53877 L .50787 .5394 L p .527 .284 .49 r
F P
0 g
s
.53302 .53504 m .52418 .52686 L .51792 .52846 L p .758 .459 .479 r
F P
0 g
s
.51178 .57421 m .50872 .56442 L .49499 .56353 L p .494 .57 .861 r
F P
0 g
s
.49358 .55113 m .49499 .56353 L .50872 .56442 L p .525 .482 .75 r
F P
0 g
s
.03 w
.49917 .55605 m
.53832 .54575 L
s
.5 Mabswid
.54005 .5589 m .53869 .54649 L .52462 .5502 L p .837 .709 .722 r
F P
0 g
s
.52462 .5502 m .526 .56265 L .54005 .5589 L p .837 .709 .722 r
F P
0 g
s
.02 w
.50205 .54818 m
.52493 .553 L
s
.53236 .55456 m
.53812 .55577 L
s
.5 Mabswid
.50732 .55197 m .50787 .5394 L .49685 .53877 L p .535 .397 .64 r
F P
0 g
s
.49685 .53877 m .49358 .55113 L .50732 .55197 L p .535 .397 .64 r
F P
0 g
s
.50872 .56442 m .50732 .55197 L .49358 .55113 L p .525 .482 .75 r
F P
0 g
s
.03 w
.49176 .558 m
.49428 .55733 L
s
.5 Mabswid
.50872 .56442 m .51178 .57421 L .52559 .57279 L p .697 .698 .847 r
F P
0 g
s
.52173 .53797 m .51792 .52846 L .51025 .52926 L p .665 .416 .533 r
F P
0 g
s
.51025 .52926 m .50787 .5394 L .52173 .53797 L p .665 .416 .533 r
F P
0 g
s
.52559 .57279 m .526 .56265 L .50872 .56442 L p .697 .698 .847 r
F P
0 g
s
.51792 .52846 m .52173 .53797 L .53302 .53504 L p .758 .459 .479 r
F P
0 g
s
.53869 .54649 m .53302 .53504 L .52173 .53797 L p .812 .603 .619 r
F P
0 g
s
.52173 .53797 m .52462 .5502 L .53869 .54649 L p .812 .603 .619 r
F P
0 g
s
.36521 .55135 m .45316 .52918 L .46542 .52433 L p .33 .813 .802 r
F P
0 g
s
.45316 .52918 m .36521 .55135 L .35999 .56943 L p .826 .864 .875 r
F P
0 g
s
.03 w
.43143 .57386 m
.47593 .56216 L
s
.5 Mabswid
.47455 .6028 m .38701 .62683 L .39897 .62276 L p .256 .762 .736 r
F P
0 g
s
.39897 .62276 m .48702 .59861 L .47455 .6028 L p .256 .762 .736 r
F P
0 g
s
.50732 .55197 m .50872 .56442 L .526 .56265 L p .702 .613 .754 r
F P
0 g
s
.52462 .5502 m .52173 .53797 L .50787 .5394 L p .693 .53 .662 r
F P
0 g
s
.50787 .5394 m .50732 .55197 L .52462 .5502 L p .693 .53 .662 r
F P
0 g
s
.526 .56265 m .52462 .5502 L .50732 .55197 L p .702 .613 .754 r
F P
0 g
s
.49375 .43376 m .50272 .51341 L .48859 .51273 L p .525 .482 .75 r
F P
0 g
s
.48859 .51273 m .47955 .43344 L .49375 .43376 L p .525 .482 .75 r
F P
0 g
s
.52636 .42853 m .53204 .42504 L p .533 .45157 L .997 .803 .524 r
F P
0 g
s
.52839 .44704 m .52636 .42853 L p .533 .45157 L .997 .803 .524 r
F P
0 g
s
.52636 .42853 m .53505 .50792 L .52054 .51157 L p .837 .709 .722 r
F P
0 g
s
.52054 .51157 m .51171 .43188 L .52636 .42853 L p .837 .709 .722 r
F P
0 g
s
.57978 .30149 m .51297 .43191 L p .5441 .43643 L .799 .906 .916 r
F P
0 g
s
.51171 .43188 m .52054 .51157 L .50272 .51341 L p .702 .613 .754 r
F P
0 g
s
.50272 .51341 m .49375 .43376 L .51171 .43188 L p .702 .613 .754 r
F P
0 g
s
.51297 .43191 m .50614 .44523 L .52265 .44141 L p .799 .906 .916 r
F P
0 g
s
.52265 .44141 m .5441 .43643 L p .51297 .43191 L .799 .906 .916 r
F P
0 g
s
.53505 .50792 m .52839 .44704 L p .533 .45157 L .997 .803 .524 r
F P
0 g
s
.64488 .57603 m .5735 .56109 L .56658 .57739 L p .412 .229 .52 r
F P
0 g
s
.5735 .56109 m .64488 .57603 L .64309 .55798 L p .365 .358 .719 r
F P
0 g
s
.64309 .55798 m .57166 .54375 L .5735 .56109 L p .365 .358 .719 r
F P
0 g
s
.63774 .59304 m .56658 .57739 L .55346 .58651 L p .422 .038 .202 r
F P
0 g
s
.56658 .57739 m .63774 .59304 L .64488 .57603 L p .412 .229 .52 r
F P
0 g
s
.57166 .54375 m .64309 .55798 L .633 .54567 L p .24 .493 .896 r
F P
0 g
s
.633 .54567 m .56171 .53188 L .57166 .54375 L p .24 .493 .896 r
F P
0 g
s
.46542 .52433 m .37696 .54658 L .36521 .55135 L p .33 .813 .802 r
F P
0 g
s
.37696 .54658 m .46542 .52433 L .47965 .53462 L p .639 .229 .25 r
F P
0 g
s
.62433 .6026 m .55346 .58651 L .53907 .58494 L p .23 0 0 r
F P
0 g
s
.55346 .58651 m .62433 .6026 L .63774 .59304 L p .422 .038 .202 r
F P
0 g
s
.5441 .43643 m .61955 .29375 L .57978 .30149 L p .799 .906 .916 r
F P
0 g
s
.56171 .53188 m .633 .54567 L .61836 .54383 L p .177 0 0 r
F P
0 g
s
.61836 .54383 m .54734 .53005 L .56171 .53188 L p .177 0 0 r
F P
0 g
s
.48702 .59861 m .39897 .62276 L .40457 .60474 L p .828 .876 .88 r
F P
0 g
s
.47259 .5864 m .49311 .58086 L .48883 .59334 L p .828 .876 .88 r
F P
0 g
s
.49311 .58086 m .40457 .60474 L .40148 .5796 L p .838 .709 .722 r
F P
0 g
s
.40148 .5796 m .4903 .55629 L .49311 .58086 L p .838 .709 .722 r
F P
0 g
s
.52883 .59444 m .44561 .57486 L p .47502 .58652 L 0 .471 .795 r
F P
0 g
s
.44561 .57486 m .44189 .57398 L .45638 .57946 L p 0 .471 .795 r
F P
0 g
s
.45638 .57946 m .47502 .58652 L p .44561 .57486 L 0 .471 .795 r
F P
0 g
s
.40457 .60474 m .47259 .5864 L p .48702 .59861 L .828 .876 .88 r
F P
0 g
s
.48883 .59334 m .48702 .59861 L p .47259 .5864 L .828 .876 .88 r
F P
0 g
s
.53907 .58494 m .60967 .60104 L .62433 .6026 L p .23 0 0 r
F P
0 g
s
.60967 .60104 m .53907 .58494 L .52892 .57314 L p .21 .481 .893 r
F P
0 g
s
.54734 .53005 m .61836 .54383 L .60475 .55331 L p .404 .009 .174 r
F P
0 g
s
.60475 .55331 m .53404 .53909 L .54734 .53005 L p .404 .009 .174 r
F P
0 g
s
.47965 .53462 m .39085 .5573 L .37696 .54658 L p .639 .229 .25 r
F P
0 g
s
.39085 .5573 m .47965 .53462 L .4903 .55629 L p .793 .546 .563 r
F P
0 g
s
.59936 .5888 m .52892 .57314 L .52698 .55559 L p .35 .348 .717 r
F P
0 g
s
.52892 .57314 m .59936 .5888 L .60967 .60104 L p .21 .481 .893 r
F P
0 g
s
.53404 .53909 m .60475 .55331 L .59746 .57052 L p .399 .214 .511 r
F P
0 g
s
.59746 .57052 m .52698 .55559 L .53404 .53909 L p .399 .214 .511 r
F P
0 g
s
.30769 .60851 m .34816 .59785 L .345 .57328 L p .834 .705 .722 r
F P
0 g
s
.34816 .59785 m .30769 .60851 L .31791 .63073 L p .791 .548 .569 r
F P
0 g
s
.31791 .63073 m .3584 .61978 L .34816 .59785 L p .791 .548 .569 r
F P
0 g
s
.52698 .55559 m .59746 .57052 L .59936 .5888 L p .35 .348 .717 r
F P
0 g
s
.02 w
.59834 .56845 m
.65914 .58126 L
s
.5 Mabswid
.4903 .55629 m .40148 .5796 L .39085 .5573 L p .793 .546 .563 r
F P
0 g
s
.345 .57328 m .30439 .5837 L .30769 .60851 L p .834 .705 .722 r
F P
0 g
s
.3584 .61978 m .31791 .63073 L .33134 .64211 L p .648 .251 .28 r
F P
0 g
s
.33134 .64211 m .372 .63095 L .3584 .61978 L p .648 .251 .28 r
F P
0 g
s
.47502 .58652 m .56281 .60743 L .52883 .59444 L p 0 .471 .795 r
F P
0 g
s
.30928 .56544 m .35013 .55515 L .36178 .5504 L p .33 .813 .802 r
F P
0 g
s
.35013 .55515 m .30928 .56544 L .30439 .5837 L p .826 .864 .875 r
F P
0 g
s
.03 w
.34658 .59618 m
.40173 .58167 L
s
.5 Mabswid
.372 .63095 m .33134 .64211 L .34296 .63812 L p .256 .762 .736 r
F P
0 g
s
.34296 .63812 m .38387 .6269 L .372 .63095 L p .256 .762 .736 r
F P
0 g
s
.36178 .5504 m .32068 .56074 L .30928 .56544 L p .33 .813 .802 r
F P
0 g
s
.32068 .56074 m .36178 .5504 L .37562 .56119 L p .639 .229 .25 r
F P
0 g
s
.38387 .6269 m .34296 .63812 L .34823 .61993 L p .828 .876 .88 r
F P
0 g
s
.38809 .60918 m .38938 .60883 L .38915 .60959 L p .828 .876 .88 r
F P
0 g
s
.38938 .60883 m .34823 .61993 L .34494 .59444 L p .838 .709 .722 r
F P
0 g
s
.34494 .59444 m .38623 .5836 L .38938 .60883 L p .838 .709 .722 r
F P
0 g
s
.47512 .62832 m .35741 .59719 L p .39082 .60976 L 0 .436 .754 r
F P
0 g
s
.35741 .59719 m .35208 .59579 L .37462 .60392 L p 0 .436 .754 r
F P
0 g
s
.37462 .60392 m .39082 .60976 L p .35741 .59719 L 0 .436 .754 r
F P
0 g
s
.34823 .61993 m .38809 .60918 L p .38387 .6269 L .828 .876 .88 r
F P
0 g
s
.38915 .60959 m .38387 .6269 L p .38809 .60918 L .828 .876 .88 r
F P
0 g
s
.37562 .56119 m .33434 .57174 L .32068 .56074 L p .639 .229 .25 r
F P
0 g
s
.33434 .57174 m .37562 .56119 L .38623 .5836 L p .793 .546 .563 r
F P
0 g
s
.21119 .64379 m .21676 .64888 L .32086 .60294 L closepath p .622 .257 .33 r
F P
0 g
s
.2068 .63388 m .21119 .64379 L .32086 .60294 L closepath p .764 .537 .589 r
F P
0 g
s
.20522 .62287 m .2068 .63388 L .32086 .60294 L closepath p .806 .687 .734 r
F P
0 g
s
.20706 .61491 m .20522 .62287 L .32086 .60294 L closepath p .79 .832 .884 r
F P
0 g
s
.21166 .61305 m .20706 .61491 L .32086 .60294 L closepath p .344 .818 .893 r
F P
0 g
s
.21727 .61805 m .21166 .61305 L .32086 .60294 L closepath p .662 .218 .185 r
F P
0 g
s
.22174 .62806 m .21727 .61805 L .32086 .60294 L closepath p .821 .557 .539 r
F P
0 g
s
.22331 .6392 m .22174 .62806 L .32086 .60294 L closepath p .867 .728 .706 r
F P
0 g
s
.21676 .64888 m .2214 .64715 L .32086 .60294 L closepath p 0 0 0 r
F P
0 g
s
.2214 .64715 m .22331 .6392 L .32086 .60294 L closepath p .863 .908 .861 r
F P
0 g
s
.03 w
.32086 .60294 m
.34521 .59654 L
s
.5 Mabswid
.38623 .5836 m .34494 .59444 L .33434 .57174 L p .793 .546 .563 r
F P
0 g
s
.39082 .60976 m .51544 .64303 L .47512 .62832 L p 0 .436 .754 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00L`3oool300000:X0oooo001]0?ooo`H000000`35OH800`000000oooo0?ooo`2W0?ooo`00
JP3oool3000000T0aGf200<000000?ooo`3oool0Y`3oool006/0oooo00<000000<EmPP35OH802@35
OH800`000000oooo0?ooo`0e0?ooo`<00000KP3oool006/0oooo00<000000<EmPP35OH802P35OH80
0`000000oooo0?ooo`0^0?ooo`H0000000<0c>OZ0000003oool0KP3oool006`0oooo00<000000<Em
PP35OH802@35OH800`000000oooo0?ooo`0[0?ooo`<000001`3<inX00`000000oooo0?ooo`1]0?oo
o`00K@3oool00`000000aGf20<EmPP090<EmPP030000003oool0oooo02T0oooo00<000000<cWjP3<
inX01`3<inX00`000000oooo0?ooo`1^0?ooo`00K@3oool00`000000aGf20<EmPP090<EmPP030000
003oool0oooo02T0oooo00<000000<cWjP3<inX01`3<inX00`000000oooo0?ooo`1^0?ooo`00KP3o
ool00`000000aGf20<EmPP090<EmPP030000003oool0oooo02L0oooo00<000000<cWjP3<inX01`3<
inX00`000000oooo0?ooo`1_0?ooo`00KP3oool00`000000aGf20<EmPP0:0<EmPP030000003oool0
oooo02H0oooo00<000000<cWjP3<inX01`3<inX00`000000oooo0?ooo`1_0?ooo`00K`3oool00`00
0000aGf20<EmPP090<EmPP030000003oool0oooo02D0oooo00<000000<cWjP3<inX01`3<inX00`00
0000oooo0?ooo`1`0?ooo`00L03oool00`000000aGf20<EmPP060<EmPP040?ooo`35OH80aGf20000
02H0oooo00<000000<cWjP3<inX01`3<inX00`000000oooo0?ooo`1`0?ooo`00L03oool00`000000
aGf20<EmPP0:0<EmPP030000003oool0oooo0280oooo00<000000<cWjP3<inX01`3<inX00`000000
oooo0?ooo`1a0?ooo`00L@3oool00`000000aGf20<EmPP090<EmPP030000003oool0oooo0280oooo
00<000000<cWjP3<inX01`3<inX00`000000oooo0?ooo`1a0?ooo`00LP3oool00`000000aGf20<Em
PP050<EmPP050?ooo`35OH80aGf20<EmPP0000008P3oool00`000000c>OZ0<cWjP070<cWjP030000
003oool0oooo0780oooo001b0?ooo`0300000035OH80aGf200T0aGf200<000000?ooo`3oool0803o
ool00`000000c>OZ0<cWjP070<cWjP030000003oool0oooo0780oooo001c0?ooo`0300000035OH80
aGf200T0aGf200<000000?ooo`3oool07P3oool00`000000c>OZ0<cWjP070<cWjP030000003oool0
oooo07<0oooo001c0?ooo`0300000035OH80aGf200X0aGf200<000000?ooo`3oool07@3oool00`00
0000c>OZ0<cWjP070<cWjP030000003oool0oooo07<0oooo001d0?ooo`0300000035OH80aGf200T0
aGf200<000000?ooo`3oool0703oool00`000000c>OZ0<cWjP070<cWjP030000003oool0oooo07@0
oooo001e0?ooo`0300000035OH80aGf200T0aGf200<000000?ooo`3oool06`3oool00`000000c>OZ
0<cWjP070<cWjP030000003oool0oooo07@0oooo001e0?ooo`0300000035OH80aGf200X0aGf200<0
00000?ooo`3oool06@3oool00`000000c>OZ0<cWjP070<cWjP030000003oool0oooo07D0oooo001f
0?ooo`0300000035OH80aGf200T0aGf200<000000?ooo`3oool06@3oool00`000000c>OZ0<cWjP07
0<cWjP030000003oool0oooo07D0oooo001g0?ooo`0300000035OH80aGf200<0aGf200<0oooo0<Em
PP35OH800`35OH800`000000oooo0?ooo`0G0?ooo`030000003<inX0c>OZ00L0c>OZ00<000000?oo
o`3oool0MP3oool007L0oooo00<000000<EmPP35OH802P35OH800`000000oooo0?ooo`0F0?ooo`03
0000003<inX0c>OZ00L0c>OZ00<000000?ooo`3oool0MP3oool007P0oooo00<000000<EmPP35OH80
2@35OH800`000000oooo0?ooo`0E0?ooo`030000003<inX0c>OZ00L0c>OZ00<000000?ooo`3oool0
M`3oool007P0oooo00<000000<EmPP35OH800`35OH800`3oool0aGf20<EmPP040<EmPP030000003o
ool0oooo01@0oooo00<000000<cWjP3<inX01`3<inX00`000000oooo0?ooo`1g0?ooo`00N@3oool0
0`000000aGf20<EmPP090<EmPP030000003oool0oooo01<0oooo00<000000<cWjP3<inX01`3<inX0
0`000000oooo0?ooo`1h0?ooo`00NP3oool00`000000aGf20<EmPP090<EmPP030000003oool0oooo
0180oooo00<000000<cWjP3<inX01`3<inX00`000000oooo0?ooo`1h0?ooo`00NP3oool00`000000
aGf20<EmPP020<EmPP030?ooo`35OH80aGf200D0aGf200<000000?ooo`3oool0403oool00`000000
c>OZ0<cWjP070<cWjP030000003oool0oooo07T0oooo001k0?ooo`0300000035OH80aGf200T0aGf2
00<000000?ooo`3oool0403oool00`000000c>OZ0<cWjP070<cWjP030000003oool0oooo07T0oooo
001l0?ooo`0300000035OH80aGf200T0aGf200<000000?ooo`3oool03P3oool00`000000c>OZ0<cW
jP070<cWjP030000003oool0oooo07X0oooo001l0?ooo`0300000035OH80aGf200X0aGf200<00000
0?ooo`3oool03@3oool00`000000c>OZ0<cWjP070<cWjP030000003oool0oooo07X0oooo001m0?oo
o`0300000035OH80aGf200T0aGf200<000000?ooo`3oool0303oool00`000000c>OZ0<cWjP070<cW
jP030000003oool0oooo07/0oooo001m0?ooo`0500000035OH80aGf20<EmPP3oool02035OH800`00
0000oooo0?ooo`0;0?ooo`030000003<inX0c>OZ00L0c>OZ00<000000?ooo`3oool0N`3oool007h0
oooo00<000000<EmPP35OH802@35OH800`000000oooo0?ooo`0:0?ooo`030000003<inX0c>OZ00L0
c>OZ00<000000?ooo`3oool0O03oool007l0oooo00<000000<EmPP35OH802@35OH800`000000oooo
0?ooo`090?ooo`030000003<inX0c>OZ00L0c>OZ00<000000?ooo`3oool0O03oool007l0oooo00@0
00000<EmPP35OH80oooo2@35OH800`000000oooo0?ooo`070?ooo`030000003<inX0c>OZ00L0c>OZ
00<000000?ooo`3oool0O@3oool00800oooo00<000000<EmPP35OH802@35OH800`000000oooo0?oo
o`070?ooo`030000003<inX0c>OZ00L0c>OZ00<000000?ooo`3oool0O@3oool00840oooo00<00000
0<EmPP35OH802@35OH800`000000oooo0?ooo`050?ooo`030000003<inX0c>OZ00L0c>OZ00<00000
0?ooo`3oool0OP3oool00840oooo00<000000<EmPP3oool02P35OH800`000000oooo0?ooo`040?oo
o`030000003<inX0c>OZ00L0c>OZ00<000000?ooo`3oool0OP3oool00880oooo00<000000<EmPP35
OH801`35OH89000000T0c>OZ00<000000?ooo`3oool0O`3oool00880oooo00<000000<EmPP35OH80
1035OH8300000080eKBh00<000000;>L`02cW<000P2cW<02000000T0c>OZ00<000000?ooo`3oool0
O`3oool008<0oooo00<000000?ooo`35OH800P35OH82000000@0eKBh00<000000;>L`00000000`00
00090<cWjP030000003oool0oooo0800oooo00240?ooo`0400000035OH80aGf20<EmPPP000000P2c
W<42000000T0c>OZ00<000000?ooo`3oool0P03oool008@0oooo00@000000<EmPP35OH80aGf20P00
000308Ik_`030000002cW<40/ic10080/ic100<000000<cWjP3<inX0103<inX4000008<0oooo0025
0?ooo`D000000`26Nkl00`000000/ic10;>L`@020;>L`@030000003<inX0000000D00000QP3oool0
08P0oooo0P00000308Ik_`040000002cW<40/ic10;>L`@<000000`3F]KP3000008H0oooo00280?oo
o`030000000028l0000000<0QW^o00<000000;>L`@2cW<400P2cW<4010000000e[Fh0=Je^03F]KP3
000008H0oooo00290?ooo`8000000`26Nkl00`000000/ic10;>L`@020;>L`@040000003F]KP0e[Fh
0=Je^0<00000QP3oool008T0oooo0P00000308Ik_`030000002cW<40/ic10080/ic100L000000=Je
^03F]KP0e[Fh0000003ocHH0000008H0oooo00290?ooo`8000000`26Nkl00`000000/ic10;>L`@02
0;>L`@070000003F]KP0e[Fh0=Je^0000000olf6000000260?ooo`00R@3oool2000000<0QW^o00<0
00000;>L`@2cW<400P2cW<401`000000e[Fh0=Je^03F]KP000000?o=QP000000QP3oool008T0oooo
0P00000308Ik_`030000002cW<40/ic10080/ic100<000000=Je^03F]KP00P3F]KP2000008H0oooo
00290?ooo`8000000`26Nkl00`000000/ic10;>L`@020;>L`@030000003F]KP0e[Fh0080e[Fh00<0
00000?o=QP000000Q@3oool008T0oooo0P00000308Ik_`030000002cW<40/ic100<0/ic100L00000
0=Je^03F]KP0e[Fh0000003ocHH0000008D0oooo00290?ooo`030000000028l0000000<0QW^o00<0
00000;>L`@2cW<400P2cW<401`000000e[Fh0=Je^03F]KP000000?o=QP000000Q@3oool008T0oooo
00<000000008S`0000000`26Nkl00`000000/ic10;>L`@020;>L`@070000003F]KP0e[Fh0=Je^000
0000olf6000000250?ooo`00R@3oool00`00000000R?0000000308Ik_`030000002cW<40/ic10080
/ic100L000000=Je^03F]KP0e[Fh0000003ocHH0000008D0oooo00290?ooo`030000000028l00000
00<0QW^o00<000000;>L`@2cW<400P2cW<401`000000e[Fh0=Je^03F]KP000000?o=QP000000Q@3o
ool008T0oooo00<000000008S`0000000`26Nkl00`000000/ic10;>L`@020;>L`@040000003F]KP0
e[Fh0=Je^0<00000Q@3oool008X0oooo0P00000308Ik_`030000002cW<40/ic10080/ic100<00000
0=Je^03F]KP00P3F]KP00`000000olf6000000240?ooo`00RP3oool2000000<0QW^o00<000000;>L
`@2cW<400P2cW<400`000000e[Fh0=Je^0020=Je^0030000003ocHH0000008@0oooo002:0?ooo`80
00000`26Nkl00`000000/ic10;>L`@030;>L`@070000003F]KP0e[Fh0=Je^0000000olf600000024
0?ooo`00RP3oool00`00000000R?0000000308Ik_`030000002cW<40/ic10080/ic100@000000=Je
^03F]KP0e[Fh0`0000240?ooo`00RP3oool00`00000000R?0000000308Ik_`030000002cW<40/ic1
0080/ic100<000000=Je^00000000P00000G0?ooo`@00000J`3oool007l0oooo1`0000040?ooo`03
0000000028l0000000<0QW^o00<000000;>L`@2cW<401000000H0?ooo`@0000000<0WdAG00000000
0000JP3oool007d0oooo0P00000406L2;0L0000000<0oooo0000000000001`00000I0?ooo`@00000
00<0WdAG0000000000000P33RIL00`000000oooo0?ooo`1W0?ooo`00O03oool2000000/0I`8/1@00
00040?ooo`<000005P3oool7000000@0`hVG0P00001X0?ooo`00O03oool00`000000ISJ200000003
000000P0I`8/0P00000203eni@<0000000<0oooo0000000000005@3oool6000000<0`hVG10000000
0`3=[k/000000?ooo`1W0?ooo`00N`3oool00`000000ISJ206HfPP0406HfPP@000000`1W0R`00`00
0000?GkU03eni@0403eni@P000003`3oool5000000<0`hVG0`0000050<f_^`030000003oool0oooo
06H0oooo001k0?ooo`040000001V=X80ISJ206HfPP@000000`2S>Sl90000000309kZY00000000000
00D0000000<0cV0j0000000000002`3oool5000000030<>9U`0000000000008000001P3=[k/30000
06P0oooo001j0?ooo`D00000202S>Sl2000000D0GE^h0P00000208I8O@030000002ZJXP000000080
`WEj00<000000<iP>P0000003@0000001033RIL000000000000000040<f_^`H000000P39dn400`00
0000oooo0?ooo`1V0?ooo`00M`3oool4000000`0XcXo0`00000305eK^0050000000c03X0000008I8
O@0000000`2ZJXP00`000000`WEj00000004000000@0I`8/3`0000030<WCh@D00000J@3oool007<0
oooo1000000<0:<j?`@000000P3;Ri040000000301H0J0000000000000L000000P3?VYh3000000T0
I`8/4@00001Z0?ooo`00K`3oool4000000`0XcXo100000070<^;T0<0000000D05P1X00000028IJ<0
R6FS000000030;67Z@050000003?VYh0ciZN0<nJWP0000000P1V=X85000000T0I`8/2@00001]0?oo
o`00FP3oool3000000h0oooo0P00000>0:<j?`@000002`3;Ri08000000@0/HNY00<000000<nJWP00
0000201V=X85000000T0I`8/1`00001Z0?ooo`00G03oool5000000D0oooo0P000000103oool00000
0000001Dd<d2000000T0XcXo1000000@0<^;T0L000000P2aQjT5000000d0ISJ21@00000306L2;080
00001P0mO^D00`000000oooo0?ooo`1W0?ooo`00G`3oool700000080XcXo0P0000040=?Mg`800000
0`2S>Sl4000001@0bh^@2@0000020;>L`@8000004`1V=X86000000D0?GkU00<000000?ooo`3oool0
I`3oool003X0oooo0P00000R0?ooo`@000001`2S>Sl00`000000dmgO0=?Mg`040=?Mg`<00000603;
Ri07000000@0/ic11000000C06HfPP040000001MFkP0GE^h05eK^0D0000000<0?GkU0000003oool0
I`3oool003`0oooo1000000K0?ooo`<00000302S>Sl00`000000dmgO0=?Mg`030=?Mg`030000003;
Ri00bh^@01@0bh^@100000000`3F]KP00000000000030000000308Ik_`000000/ic10080/ic10P00
000205UI]`D000003@1V=X800`000000GE^h05eK^00705eK^0<00000I`3oool003l0oooo1@00000E
0?ooo`D000002`2S>Sl3000000060=?Mg`00000000000000003E];P000004P3;Ri03000000D0e[Fh
3000000705UI]`D000001@1V=X86000000T0GE^h00<000000?ooo`3oool0I@3oool00440oooo1P00
000A0?ooo`8000000`3CgMl00`000000XcXo0:<j?`050:<j?`@000000P3;Ri02000000@0eKBh00<0
00000<^;T00000000P00000:0<^;T0@00000203F]KP7000000<0/[;H0P00000<05UI]a4000000`1M
FkP00`000000oooo0?ooo`1U0?ooo`00A03oool7000000d0oooo00<000000=?Mg`3CgMl00`3CgMl0
0`000000XcXo0:<j?`04000000L0bh^@00@000000=Fd^03E];P0eKBh1`0000050<^;T0@000003@3F
]KP40000000307jAg0000000/[;H0080/[;H0P00000A05UI]a800000I@3oool004L0oooo1`00000:
0?ooo`030000003CgMl0dmgO00@0dmgO0P00000;0<^;T0/000000P3;Ri0300000080e[Fh0`00000<
0=Je^0d000003`1IFKLG00000600oooo001;0?ooo`L000001@3oool00`000000dmgO0=?Mg`030=?M
g`@00000303;Ri0<000000H0e[Fh0P0000001000N</000000000000000080=Je^0030000003oool0
oooo0080000000@0H:ci0000002Sd?L0Xm3g0`0000000`0eNn@0000000000003000000X0FEVg5`00
001P0?ooo`00C`3oool7000000030?ooo`000000dmgO00@000000`3E];P00`000000bh^@0<^;T00:
0<^;T0/000002@3F]KP300000003001hb`000000000000800000103F]KP00`000000oooo0?ooo`02
0?ooo`D000000P3oool00`000000=G_T03Eki00303Eki0H000001`1IFKL00`000000JCZ50000000A
00000600oooo001C0?ooo`H00000203E];P00`000000bh^@0<^;T0090<^;T0/00000303F]KP30000
008007S;1@0000060?ooo`800000103oool2000000T0=G_T1@00000205UI]`030000001Y>XD0JCZ5
00D0JCZ53000001P0?ooo`00E`3oool00`000000eKBh0=Fd^0050=Fd^0@000001P3;Ri0400000003
0=Je^0000000000000P000003@3F]KP60000008007S;100000030?ooo`H000000P3oool4000000X0
=G_T1`00000706TjQ@030000003oool0000000D00000H03oool005L0oooo00<000000=Fd^03E];P0
0P3E];P700000080bh^@100000050=Je^0T000002P3F]KP5000000D0dn3Q10000002001hb`H00000
00<0/ic000000027O;l00`0000030?ooo`@00000200eNn@00`000000K0Tc06`9<`0206`9<`@00000
0P1Y>XD00`000000oooo0?ooo`1V0?ooo`00E`3oool@000000L0e[Fh1`0000080=Je^0D000002P3C
h>400`000000oooo00000004000000@007S;0P00000308Ml_`8000001P3oool4000000D0=G_T00<0
000006`9<`1/2C<01P1/2C<2000006P0oooo001H0?oooa0000001`3F]KP2000000<0bXbA00<00000
0=Je^03F]KP00`3F]KP4000000d0dn3Q00D000000?ooo`000000o/b:000000030=Fd^0@000000P00
N</4000000030?o=QP3oool0oooo00P0oooo100000000`0eNn@0000000000002000000<0K0Tc0P00
001Z0?ooo`00F03ooolD000000<0e[Fh00<000000<Z<T@3:S9400P3:S9400`000000e[Fh00000003
000000`0dn3Q1@0000020?ooo`@000000P3E];P00`000000/ic000000008000000h0oooo2000001/
0?ooo`00E03ooolD00000080e[Fh1P0000040<Z<T@8000003@3Ch>4300000080@L>l00<000000?oo
o`3oool00P3oool01000000000R?00000026Nkl500000080/ic100<000000=Je^03F]KP01@000020
0?ooo`00A03ooolT000000D0e[Fh2000000:0=?Ph@@0000000<0@L>l0000000000001`3oool00`00
000000R?0000000308Ik_`030000002cW<40/ic10080/ic100H000000=Je^03F]KP0e[Fh0000003o
cHH4000007h0oooo000l0?ooo`P000001P2Y=bl7000000030=:>R@0000000000010000001@3F]KP4
00000080dn3Q0`000002001_`@<00000103Ch>44000000030473_0000000000000`0oooo0P000003
08Ik_`030000002cW<40/ic10080/ic100L000000=Je^03F]KP0e[Fh0000003ocHH000000840oooo
000k0?ooo`<00000102Y=bl8000000@0dXj9100000000`3M^[@000000000000200000080oooo2000
00020<Z<T@030000003F]KP0000000<000001P3Ch>400`000000YD170:E0A`0400000003001_`@00
0000000000D00000403oool2000000<0QW^o00<000000;>L`@2cW<400P2cW<401`000000e[Fh0=Je
^03F]KP000000?o=QP000000P@3oool003/0oooo00<000000<[DhP3:e>80100000080=:>R@@00000
0P3M^[@4000000D0oooo100000060<Z<T@8000002@3Ch>401P000000YD170:E0A`2U@4L000000=?P
h@H0000000<006o10000000000000P00000?0?ooo`8000000`26Nkl00`000000/ic10;>L`@020;>L
`@030000003F]KP0e[Fh0080e[Fh0P0000210?ooo`00>P3oool5000000L0dXj9100000030=fj]0D0
0000203oool00`000000bXbA0<Z<T@050<Z<T@8000002P3Ch>400`000000YD170:E0A`05000000@0
oooo100000000`00Kl40000000000002000000/0oooo00<000000008S`0000000P26Nkl00`000000
/ic10;>L`@030;>L`@040000003F]KP0e[Fh0=Je^0800000P@3oool003X0oooo00<000000<j_^`3>
[k/00P3>[k/00`000000dXj90=:>R@04000000@0gKZd1P00000:0?ooo`030000003:S940bXbA00<0
bXbA0P0000000`2U@4L000000=?Ph@080=?Ph@D00000303oool40000008006o10`0000070?ooo`03
0000000028l0000000<0QW^o00<000000;>L`@2cW<400P2cW<4010000000e[Fh0=Je^03F]KP20000
0840oooo000k0?ooo`030000003>[k/0cZnk00@000001@3M^[@6000000h0oooo00<000000<Z<T@00
00000P0000030:E0A`030000003Ch>40dn3Q00@0dn3Q0`00000E0?ooo`@000000P00Kl42000000@0
oooo00<000000008S`0000000`26Nkl00`000000/ic10;>L`@020;>L`@040000003F]KP0e[Fh0=Je
^0800000P@3oool003/0oooo0`0000000`33RIH000000=fj]0040=fj]080000000@0g>SL00000000
00000000403oool2000000D0YD1700<000000=?Ph@3Ch>400P3Ch>44000001/0oooo1`000000103o
ool000000008S`00000308Ik_`030000002cW<40/ic10080/ic100L000000=Je^03F]KP0e[Fh0000
003ocHH000000800oooo000k0?ooo`0300000033RIH0`hVF0080`hVF00<000000=fj]00000000P00
0000103Lj=`0000000000000000C0?ooo`030000002U@4L0YD1700<0YD1700<000000=?Ph@000000
1000000Q0?ooo`D0000000<000R?00000026Nkl00P26Nkl00`000000/ic10;>L`@020;>L`@070000
003F]KP0e[Fh0=Je^0000000olf6000000200?ooo`00?03oool00`000000`hVF0000000300000003
0=cXg00000000000008000005P3oool200000080YD171000000Y0?ooo`@000000P26Nkl00`000000
/ic10;>L`@020;>L`@070000003F]KP0e[Fh0=Je^0000000olf6000000200?ooo`00?03oool20000
0080Wd5D1000000K0?ooo`800000;P3oool20000000408Ik_`0000000000000000@0/ic100L00000
0=Je^03F]KP0e[Fh0000003ocHH000000800oooo000m0?ooo`030000002O@E@0000000800000C@3o
ool2000000<0QW^o00<000000;>L`@2cW<400P2cW<401`000000e[Fh0=Je^03F]KP000000?o=QP00
0000P03oool003h0oooo0P00001?0?ooo`8000000`26Nkl00`000000/ic10;>L`@020;>L`@070000
003F]KP0e[Fh0=Je^0000000olf6000000200?ooo`00S`3oool2000000<0QW^o00<000000;>L`@2c
W<400P2cW<401`000000e[Fh0=Je^03F]KP000000?o=QP000000P03oool008l0oooo0P00000308Ik
_`030000002cW<40/ic10080/ic100<000000=Je^03F]KP00P3F]KP00`000000olf60000001o0?oo
o`00S`3oool00`00000000R?0000000208Ik_`030000002cW<40/ic100<0/ic100L000000=Je^03F
]KP0e[Fh0000003ocHH0000007l0oooo002@0?ooo`8000000`26Nkl00`000000/ic10;>L`@020;>L
`@070000003F]KP0e[Fh0=Je^0000000olf60000001o0?ooo`00T03oool2000000<0QW^o00<00000
0;>L`@2cW<400P2cW<401`000000e[Fh0=Je^03F]KP000000?o=QP000000O`3oool00900oooo0P00
000308Ik_`030000002cW<40/ic10080/ic100@000000=Je^03F]KP0e[Fh0P0000200?ooo`00T03o
ool2000000<0QW^o00<000000;>L`@2cW<400P2cW<400`000000e[Fh0000000200000840oooo002A
0?ooo`8000000P26Nkl00`000000/ic10;>L`@04000008@0oooo002C0?ooo`L00000QP3oool009P0
oooo0P0000260?ooo`00V03oool2000008H0oooo002H0?ooo`800000QP3oool009P0oooo0P000026
0?ooo`00V03oool2000008H0oooo002H0?ooo`800000QP3oool009P0oooo0P0000260?ooo`00V03o
ool2000008H0oooo002H0?ooo`800000QP3oool009P0oooo0`0000250?ooo`00V@3oool00`000000
oooo0?ooo`240?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.54378 .54104 m .54084 .5315 L .52529 .54733 L closepath p .949 .635 .203 r
F P
0 g
s
.55152 .54719 m .54378 .54104 L .52529 .54733 L closepath p .705 .168 0 r
F P
0 g
s
.54084 .5315 m .54382 .52222 L .52529 .54733 L closepath p .847 .871 .427 r
F P
0 g
s
.56113 .54763 m .55152 .54719 L .52529 .54733 L closepath p .058 0 0 r
F P
0 g
s
.54382 .52222 m .55161 .51672 L .52529 .54733 L closepath p 0 0 0 r
F P
0 g
s
.56895 .54215 m .56113 .54763 L .52529 .54733 L closepath p .691 .98 .887 r
F P
0 g
s
.55161 .51672 m .56124 .51711 L .52529 .54733 L closepath p .478 0 0 r
F P
0 g
s
.57197 .53285 m .56895 .54215 L .52529 .54733 L closepath p .957 .918 .729 r
F P
0 g
s
.56124 .51711 m .56903 .52328 L .52529 .54733 L closepath p .812 .409 .285 r
F P
0 g
s
.56903 .52328 m .57197 .53285 L .52529 .54733 L closepath p .954 .7 .514 r
F P
0 g
s
.48139 .53998 m .41066 .51294 L .40326 .52723 L p .686 .481 .603 r
F P
0 g
s
.41066 .51294 m .48139 .53998 L .48648 .52383 L p .64 .548 .734 r
F P
0 g
s
.48648 .52383 m .41559 .49688 L .41066 .51294 L p .64 .548 .734 r
F P
0 g
s
.49533 .58407 m .47235 .65623 L .48884 .6611 L p .706 .619 .757 r
F P
0 g
s
.48884 .6611 m .51193 .58903 L .49533 .58407 L p .706 .619 .757 r
F P
0 g
s
.51193 .58903 m .48884 .6611 L .50214 .668 L p .558 .461 .701 r
F P
0 g
s
.48177 .58266 m .45879 .65517 L .47235 .65623 L p .835 .762 .782 r
F P
0 g
s
.47235 .65623 m .49533 .58407 L .48177 .58266 L p .835 .762 .782 r
F P
0 g
s
.41559 .49688 m .48648 .52383 L .48751 .51202 L p .54 .606 .868 r
F P
0 g
s
.48751 .51202 m .41621 .48501 L .41559 .49688 L p .54 .606 .868 r
F P
0 g
s
.47413 .55445 m .40326 .52723 L .39615 .53441 L p .705 .33 .335 r
F P
0 g
s
.40326 .52723 m .47413 .55445 L .48139 .53998 L p .686 .481 .603 r
F P
0 g
s
.50214 .668 m .52542 .5957 L .51193 .58903 L p .558 .461 .701 r
F P
0 g
s
.52542 .5957 m .50214 .668 L .50724 .67434 L p .173 .07 .487 r
F P
0 g
s
.4764 .58539 m .4533 .65839 L .45879 .65517 L p .96 .942 .646 r
F P
0 g
s
.45879 .65517 m .48177 .58266 L .4764 .58539 L p .96 .942 .646 r
F P
0 g
s
.41621 .48501 m .48751 .51202 L .48402 .50907 L p 0 .468 .826 r
F P
0 g
s
.48402 .50907 m .41223 .48188 L .41621 .48501 L p 0 .468 .826 r
F P
0 g
s
.39615 .53441 m .46741 .56186 L .47413 .55445 L p .705 .33 .335 r
F P
0 g
s
.46741 .56186 m .39615 .53441 L .39201 .53164 L p 0 .432 .787 r
F P
0 g
s
.50724 .67434 m .53073 .6016 L .52542 .5957 L p .173 .07 .487 r
F P
0 g
s
.53073 .6016 m .50724 .67434 L .50206 .67771 L p .953 .943 .626 r
F P
0 g
s
.50524 .56062 m .50697 .54838 L .52322 .55325 L p .733 .57 .671 r
F P
0 g
s
.52322 .55325 m .51828 .56453 L .50524 .56062 L p .733 .57 .671 r
F P
0 g
s
.52695 .5416 m .52322 .55325 L .50697 .54838 L p .706 .619 .757 r
F P
0 g
s
.02 w
.43136 .5186 m
.43977 .52182 L
s
.5 Mabswid
.51828 .56453 m .52322 .55325 L .53647 .55965 L p .604 .423 .61 r
F P
0 g
s
.52322 .55325 m .52695 .5416 L .54023 .54796 L p .558 .461 .701 r
F P
0 g
s
.54023 .54796 m .53647 .55965 L .52322 .55325 L p .558 .461 .701 r
F P
0 g
s
.48141 .59127 m .45811 .66473 L .4533 .65839 L p .143 .043 .471 r
F P
0 g
s
.4533 .65839 m .4764 .58539 L .48141 .59127 L p .143 .043 .471 r
F P
0 g
s
.49463 .55943 m .49376 .54684 L .50697 .54838 L p .853 .685 .673 r
F P
0 g
s
.50697 .54838 m .50524 .56062 L .49463 .55943 L p .853 .685 .673 r
F P
0 g
s
.51069 .53671 m .50697 .54838 L .49376 .54684 L p .835 .762 .782 r
F P
0 g
s
.02 w
.48414 .53876 m
.48739 .54001 L
s
.5 Mabswid
.50697 .54838 m .51069 .53671 L .52695 .5416 L p .706 .619 .757 r
F P
0 g
s
.50582 .57109 m .50524 .56062 L .51828 .56453 L p .749 .497 .551 r
F P
0 g
s
.51828 .56453 m .51308 .57326 L .50582 .57109 L p .749 .497 .551 r
F P
0 g
s
.51308 .57326 m .51828 .56453 L .5289 .56969 L p .643 .367 .487 r
F P
0 g
s
.53647 .55965 m .5289 .56969 L .51828 .56453 L p .604 .423 .61 r
F P
0 g
s
.52876 .53181 m .52695 .5416 L .51069 .53671 L p .659 .664 .844 r
F P
0 g
s
.52695 .5416 m .52876 .53181 L .53944 .53689 L p .484 .495 .793 r
F P
0 g
s
.53944 .53689 m .54023 .54796 L .52695 .5416 L p .484 .495 .793 r
F P
0 g
s
.49993 .57045 m .49463 .55943 L .50524 .56062 L p .846 .575 .528 r
F P
0 g
s
.50524 .56062 m .50582 .57109 L .49993 .57045 L p .846 .575 .528 r
F P
0 g
s
.49376 .54684 m .49748 .53512 L .51069 .53671 L p .835 .762 .782 r
F P
0 g
s
.51568 .52787 m .51069 .53671 L .49748 .53512 L p .782 .831 .89 r
F P
0 g
s
.51069 .53671 m .51568 .52787 L .52876 .53181 L p .659 .664 .844 r
F P
0 g
s
.41223 .48188 m .48402 .50907 L .47727 .51627 L p .702 .318 .318 r
F P
0 g
s
.47727 .51627 m .40508 .48886 L .41223 .48188 L p .702 .318 .318 r
F P
0 g
s
.02 w
.40417 .50822 m
.43136 .5186 L
s
.5 Mabswid
.5289 .56969 m .53647 .55965 L .54174 .56519 L p .324 .079 .379 r
F P
0 g
s
.53647 .55965 m .54023 .54796 L .54553 .55343 L p .172 .069 .487 r
F P
0 g
s
.02 w
.54693 .56275 m
.55023 .56401 L
s
.5 Mabswid
.54553 .55343 m .54174 .56519 L .53647 .55965 L p .172 .069 .487 r
F P
0 g
s
.5289 .56969 m .51898 .57615 L .51308 .57326 L p .643 .367 .487 r
F P
0 g
s
.51898 .57615 m .5289 .56969 L .53307 .57418 L p .451 .085 .252 r
F P
0 g
s
.54174 .56519 m .53307 .57418 L .5289 .56969 L p .324 .079 .379 r
F P
0 g
s
.46376 .55927 m .39201 .53164 L .39251 .51979 L p .533 .606 .872 r
F P
0 g
s
.39201 .53164 m .46376 .55927 L .46741 .56186 L p 0 .432 .787 r
F P
0 g
s
.02 w
.43977 .52182 m
.48414 .53876 L
s
.5 Mabswid
.51308 .57326 m .51898 .57615 L p .49988 .5741 L .62 .085 0 r
F P
0 g
s
.50582 .57109 m .51308 .57326 L p .49988 .5741 L .62 .085 0 r
F P
0 g
s
.49993 .57045 m .50582 .57109 L p .49988 .5741 L .62 .085 0 r
F P
0 g
s
.52827 .52579 m .52876 .53181 L .51568 .52787 L p .524 .707 .954 r
F P
0 g
s
.52876 .53181 m .52827 .52579 L .53422 .52862 L p .3 .515 .896 r
F P
0 g
s
.53422 .52862 m .53944 .53689 L .52876 .53181 L p .3 .515 .896 r
F P
0 g
s
.5458 .42558 m .52203 .50021 L .53877 .50526 L p .706 .619 .757 r
F P
0 g
s
.53877 .50526 m .56265 .43071 L .5458 .42558 L p .706 .619 .757 r
F P
0 g
s
.56265 .43071 m .53877 .50526 L .55249 .51167 L p .558 .461 .701 r
F P
0 g
s
.54023 .54796 m .53944 .53689 L .54369 .54122 L p 0 .052 .581 r
F P
0 g
s
.54369 .54122 m .54553 .55343 L .54023 .54796 L p 0 .052 .581 r
F P
0 g
s
.49748 .53512 m .50507 .52656 L .51568 .52787 L p .782 .831 .89 r
F P
0 g
s
.52098 .5236 m .51568 .52787 L .50507 .52656 L p .591 .867 .994 r
F P
0 g
s
.51568 .52787 m .52098 .5236 L .52827 .52579 L p .524 .707 .954 r
F P
0 g
s
.49049 .56144 m .48858 .54925 L .49376 .54684 L p .997 .786 .492 r
F P
0 g
s
.49376 .54684 m .49463 .55943 L .49049 .56144 L p .997 .786 .492 r
F P
0 g
s
.49748 .53512 m .49376 .54684 L .48858 .54925 L p .96 .942 .646 r
F P
0 g
s
.49765 .5716 m .49049 .56144 L .49463 .55943 L p .931 .57 .309 r
F P
0 g
s
.49463 .55943 m .49993 .57045 L .49765 .5716 L p .931 .57 .309 r
F P
0 g
s
.53226 .42339 m .50848 .49839 L .52203 .50021 L p .835 .762 .782 r
F P
0 g
s
.52203 .50021 m .5458 .42558 L .53226 .42339 L p .835 .762 .782 r
F P
0 g
s
.67901 .6155 m .57395 .57535 L .56689 .59008 L p .686 .481 .603 r
F P
0 g
s
.57395 .57535 m .67901 .6155 L .68456 .59915 L p .64 .548 .734 r
F P
0 g
s
.68456 .59915 m .57926 .55911 L .57395 .57535 L p .64 .548 .734 r
F P
0 g
s
.50206 .67771 m .52568 .60447 L .53073 .6016 L p .953 .943 .626 r
F P
0 g
s
.52568 .60447 m .50206 .67771 L .48841 .67675 L p .838 .767 .783 r
F P
0 g
s
.51898 .57615 m .52126 .57866 L p .49988 .5741 L .62 .085 0 r
F P
0 g
s
.53307 .57418 m .52126 .57866 L .51898 .57615 L p .451 .085 .252 r
F P
0 g
s
.48858 .54925 m .49232 .53745 L .49748 .53512 L p .96 .942 .646 r
F P
0 g
s
.02 w
.48739 .54001 m
.49041 .54116 L
s
.49041 .54116 m
.49106 .54141 L
s
.5 Mabswid
.50507 .52656 m .49748 .53512 L .49232 .53745 L p .735 .976 .734 r
F P
0 g
s
.49988 .5741 m .49765 .5716 L .49993 .57045 L p .62 .085 0 r
F P
0 g
s
.49505 .59808 m .47155 .67177 L .45811 .66473 L p .553 .457 .7 r
F P
0 g
s
.45811 .66473 m .48141 .59127 L .49505 .59808 L p .553 .457 .7 r
F P
0 g
s
.57926 .55911 m .68456 .59915 L .68674 .58751 L p .54 .606 .868 r
F P
0 g
s
.68674 .58751 m .58082 .54738 L .57926 .55911 L p .54 .606 .868 r
F P
0 g
s
.53944 .53689 m .53422 .52862 L .53656 .531 L p 0 .013 .573 r
F P
0 g
s
.53656 .531 m .54369 .54122 L .53944 .53689 L p 0 .013 .573 r
F P
0 g
s
.67216 .63051 m .56689 .59008 L .56068 .59778 L p .705 .33 .335 r
F P
0 g
s
.56689 .59008 m .67216 .63051 L .67901 .6155 L p .686 .481 .603 r
F P
0 g
s
.55249 .51167 m .57657 .43688 L .56265 .43071 L p .558 .461 .701 r
F P
0 g
s
.57657 .43688 m .55249 .51167 L .55803 .51705 L p .173 .07 .487 r
F P
0 g
s
.40508 .48886 m .47727 .51627 L .46985 .53099 L p .686 .478 .6 r
F P
0 g
s
.46985 .53099 m .39752 .50338 L .40508 .48886 L p .686 .478 .6 r
F P
0 g
s
.49232 .53745 m .50098 .52838 L .50507 .52656 L p .735 .976 .734 r
F P
0 g
s
.50507 .52656 m .51509 .52286 L .52098 .5236 L p .591 .867 .994 r
F P
0 g
s
.51509 .52286 m .50507 .52656 L .50098 .52838 L p 0 0 0 r
F P
0 g
s
.52126 .57866 m .51905 .57983 L p .49988 .5741 L .62 .085 0 r
F P
0 g
s
.01 w
.46715 .7075 m
.50863 .57774 L
s
.50863 .57774 m
.50893 .57681 L
s
.5 Mabswid
.52126 .57866 m .53307 .57418 L .52913 .57628 L p 0 0 0 r
F P
0 g
s
.52913 .57628 m .51905 .57983 L .52126 .57866 L p 0 0 0 r
F P
0 g
s
.52827 .52579 m .52098 .5236 L p .52111 .52908 L .6 .053 0 r
F P
0 g
s
.53422 .52862 m .52827 .52579 L p .52111 .52908 L .6 .053 0 r
F P
0 g
s
.01 w
.52471 .52743 m
.52765 .51821 L
s
.5 Mabswid
.53307 .57418 m .54174 .56519 L .53687 .56774 L p .701 .959 .7 r
F P
0 g
s
.53687 .56774 m .52913 .57628 L .53307 .57418 L p .701 .959 .7 r
F P
0 g
s
.52098 .5236 m .51509 .52286 L p .52111 .52908 L .6 .053 0 r
F P
0 g
s
.49049 .56144 m .49765 .5716 L .49988 .5741 L p 0 0 .527 r
F P
0 g
s
.46468 .54748 m .39251 .51979 L .39752 .50338 L p .639 .547 .735 r
F P
0 g
s
.39251 .51979 m .46468 .54748 L .46376 .55927 L p .533 .606 .872 r
F P
0 g
s
.52715 .42499 m .50325 .50053 L .50848 .49839 L p .96 .942 .646 r
F P
0 g
s
.50848 .49839 m .53226 .42339 L .52715 .42499 L p .96 .942 .646 r
F P
0 g
s
.54174 .56519 m .54553 .55343 L .54069 .5559 L p .953 .943 .627 r
F P
0 g
s
.54069 .5559 m .53687 .56774 L .54174 .56519 L p .953 .943 .627 r
F P
0 g
s
.02 w
.52165 .55309 m
.53941 .55987 L
s
.54121 .56056 m
.54693 .56275 L
s
.5 Mabswid
.51203 .60314 m .48841 .67675 L .47155 .67177 L p .706 .619 .758 r
F P
0 g
s
.48841 .67675 m .51203 .60314 L .52568 .60447 L p .838 .767 .783 r
F P
0 g
s
.43637 .24342 m .52543 .42849 L .51204 .43276 L p .952 .607 .308 r
F P
0 g
s
.51204 .43276 m .42129 .24418 L .43637 .24342 L p .952 .607 .308 r
F P
0 g
s
.49988 .5741 m .49449 .56591 L .49049 .56144 L p 0 0 .527 r
F P
0 g
s
.48858 .54925 m .49049 .56144 L .49449 .56591 L p 0 .018 .56 r
F P
0 g
s
.47155 .67177 m .49505 .59808 L .51203 .60314 L p .706 .619 .758 r
F P
0 g
s
.53656 .531 m .53422 .52862 L p .52111 .52908 L .6 .053 0 r
F P
0 g
s
.39752 .50338 m .46985 .53099 L .46468 .54748 L p .639 .547 .735 r
F P
0 g
s
.54553 .55343 m .54369 .54122 L .5398 .54314 L p .999 .786 .473 r
F P
0 g
s
.5398 .54314 m .54069 .5559 L .54553 .55343 L p .999 .786 .473 r
F P
0 g
s
.51509 .52286 m .51284 .52386 L p .52111 .52908 L .6 .053 0 r
F P
0 g
s
.50098 .52838 m .51284 .52386 L .51509 .52286 L p 0 0 0 r
F P
0 g
s
.51905 .57983 m .51314 .57921 L p .49988 .5741 L .62 .085 0 r
F P
0 g
s
.01 w
.50946 .57513 m
.51912 .54491 L
s
.5 Mabswid
.51905 .57983 m .52913 .57628 L .51847 .57513 L p .575 .87 .995 r
F P
0 g
s
.51847 .57513 m .51314 .57921 L .51905 .57983 L p .575 .87 .995 r
F P
0 g
s
.49449 .56591 m .49357 .55477 L .48858 .54925 L p 0 .018 .56 r
F P
0 g
s
.49232 .53745 m .48858 .54925 L .49357 .55477 L p .144 .043 .471 r
F P
0 g
s
.02 w
.49304 .54216 m
.52165 .55309 L
s
.5 Mabswid
.51314 .57921 m .5058 .57701 L .49988 .5741 L p .62 .085 0 r
F P
0 g
s
.49449 .56591 m .49988 .5741 L .5058 .57701 L p .274 .506 .896 r
F P
0 g
s
.54369 .54122 m .53656 .531 L .53438 .53203 L p .931 .562 .283 r
F P
0 g
s
.53438 .53203 m .5398 .54314 L .54369 .54122 L p .931 .562 .283 r
F P
0 g
s
.58082 .54738 m .68674 .58751 L .68468 .58506 L p 0 .468 .826 r
F P
0 g
s
.68468 .58506 m .57799 .54466 L .58082 .54738 L p 0 .468 .826 r
F P
0 g
s
.02 w
.55023 .56401 m
.59567 .58136 L
s
.5 Mabswid
.49357 .55477 m .49734 .54289 L .49232 .53745 L p .144 .043 .471 r
F P
0 g
s
.50098 .52838 m .49232 .53745 L .49734 .54289 L p .304 .055 .361 r
F P
0 g
s
.53438 .53203 m .53656 .531 L p .52111 .52908 L .6 .053 0 r
F P
0 g
s
.01 w
.51912 .54491 m
.52398 .52972 L
s
.5 Mabswid
.51314 .57921 m .51847 .57513 L .5052 .57116 L p .512 .708 .96 r
F P
0 g
s
.5052 .57116 m .5058 .57701 L .51314 .57921 L p .512 .708 .96 r
F P
0 g
s
.49734 .54289 m .50505 .5327 L .50098 .52838 L p .304 .055 .361 r
F P
0 g
s
.51284 .52386 m .50098 .52838 L .50505 .5327 L p .435 .061 .228 r
F P
0 g
s
.5058 .57701 m .5052 .57116 L .49449 .56591 L p .274 .506 .896 r
F P
0 g
s
.56068 .59778 m .66655 .63856 L .67216 .63051 L p .705 .33 .335 r
F P
0 g
s
.66655 .63856 m .56068 .59778 L .55769 .59543 L p 0 .432 .787 r
F P
0 g
s
.51284 .52386 m .51513 .52624 L .52111 .52908 L p .6 .053 0 r
F P
0 g
s
.50505 .5327 m .51513 .52624 L .51284 .52386 L p .435 .061 .228 r
F P
0 g
s
.52913 .57628 m .53687 .56774 L .52357 .56627 L p .783 .838 .894 r
F P
0 g
s
.52357 .56627 m .51847 .57513 L .52913 .57628 L p .783 .838 .894 r
F P
0 g
s
.55803 .51705 m .58232 .44179 L .57657 .43688 L p .173 .07 .487 r
F P
0 g
s
.58232 .44179 m .55803 .51705 L .55313 .51933 L p .953 .943 .626 r
F P
0 g
s
.49357 .55477 m .49449 .56591 L .5052 .57116 L p .476 .491 .794 r
F P
0 g
s
.52111 .52908 m .52848 .5313 L .53438 .53203 L p .6 .053 0 r
F P
0 g
s
.5398 .54314 m .53438 .53203 L .52848 .5313 L p .849 .574 .521 r
F P
0 g
s
.53261 .42986 m .5085 .50588 L .50325 .50053 L p .143 .043 .471 r
F P
0 g
s
.50325 .50053 m .52715 .42499 L .53261 .42986 L p .143 .043 .471 r
F P
0 g
s
.01 w
.52765 .51821 m
.5362 .49148 L
s
.5 Mabswid
.53687 .56774 m .54069 .5559 L .52739 .55437 L p .838 .767 .783 r
F P
0 g
s
.52739 .55437 m .52357 .56627 L .53687 .56774 L p .838 .767 .783 r
F P
0 g
s
.76583 .36559 m .5788 .45742 L .59103 .45266 L p .36 .812 .689 r
F P
0 g
s
.59103 .45266 m .77482 .36246 L .76583 .36559 L p .36 .812 .689 r
F P
0 g
s
.51582 .53786 m .52111 .52908 L .51513 .52624 L p .64 .36 .479 r
F P
0 g
s
.51513 .52624 m .50505 .5327 L .51582 .53786 L p .64 .36 .479 r
F P
0 g
s
.54069 .5559 m .5398 .54314 L .52914 .54186 L p .857 .687 .672 r
F P
0 g
s
.52848 .5313 m .52914 .54186 L .5398 .54314 L p .849 .574 .521 r
F P
0 g
s
.52914 .54186 m .52739 .55437 L .54069 .5559 L p .857 .687 .672 r
F P
0 g
s
.51847 .57513 m .52357 .56627 L .50696 .56129 L p .657 .666 .847 r
F P
0 g
s
.50696 .56129 m .5052 .57116 L .51847 .57513 L p .657 .666 .847 r
F P
0 g
s
.5052 .57116 m .50696 .56129 L .49357 .55477 L p .476 .491 .794 r
F P
0 g
s
.03 w
.49051 .56429 m
.49538 .56191 L
s
.5 Mabswid
.49734 .54289 m .49357 .55477 L .50696 .56129 L p .553 .457 .7 r
F P
0 g
s
.52914 .54186 m .52848 .5313 L .52111 .52908 L p .749 .495 .546 r
F P
0 g
s
.52111 .52908 m .51582 .53786 L .52914 .54186 L p .749 .495 .546 r
F P
0 g
s
.51076 .54938 m .51582 .53786 L .50505 .5327 L p .601 .419 .607 r
F P
0 g
s
.50505 .5327 m .49734 .54289 L .51076 .54938 L p .601 .419 .607 r
F P
0 g
s
.50696 .56129 m .51076 .54938 L .49734 .54289 L p .553 .457 .7 r
F P
0 g
s
.57799 .54466 m .68468 .58506 L .67909 .59292 L p .702 .318 .318 r
F P
0 g
s
.67909 .59292 m .57178 .55216 L .57799 .54466 L p .702 .318 .318 r
F P
0 g
s
.02 w
.59567 .58136 m
.60439 .58469 L
s
.5 Mabswid
.52357 .56627 m .52739 .55437 L .51076 .54938 L p .706 .619 .758 r
F P
0 g
s
.03 w
.51715 .5513 m
.52509 .54743 L
s
.5 Mabswid
.51076 .54938 m .50696 .56129 L .52357 .56627 L p .706 .619 .758 r
F P
0 g
s
.03 w
.50369 .55786 m
.50795 .55578 L
s
.50795 .55578 m
.50886 .55534 L
s
.5 Mabswid
.66434 .63649 m .55769 .59543 L .55916 .58373 L p .533 .606 .872 r
F P
0 g
s
.55769 .59543 m .66434 .63649 L .66655 .63856 L p 0 .432 .787 r
F P
0 g
s
.52739 .55437 m .52914 .54186 L .51582 .53786 L p .733 .569 .67 r
F P
0 g
s
.55313 .51933 m .57756 .44354 L .58232 .44179 L p .953 .943 .626 r
F P
0 g
s
.57756 .44354 m .55313 .51933 L .53949 .51757 L p .838 .767 .783 r
F P
0 g
s
.01 w
.5362 .49148 m
.5513 .44424 L
s
.5 Mabswid
.51582 .53786 m .51076 .54938 L .52739 .55437 L p .733 .569 .67 r
F P
0 g
s
.54669 .43615 m .52237 .51241 L .5085 .50588 L p .553 .457 .7 r
F P
0 g
s
.5085 .50588 m .53261 .42986 L .54669 .43615 L p .553 .457 .7 r
F P
0 g
s
.57178 .55216 m .67909 .59292 L .67209 .60818 L p .686 .478 .6 r
F P
0 g
s
.67209 .60818 m .56455 .56714 L .57178 .55216 L p .686 .478 .6 r
F P
0 g
s
.43772 .54184 m .30372 .49036 L .31166 .50559 L p .247 .594 .95 r
F P
0 g
s
.46849 .53444 m .48793 .52056 L p .4487 .54158 L .541 .908 .724 r
F P
0 g
s
.31166 .50559 m .43746 .5541 L p .43772 .54184 L .247 .594 .95 r
F P
0 g
s
.441 .55015 m .43772 .54184 L p .43746 .5541 L .247 .594 .95 r
F P
0 g
s
.43436 .54926 m .44656 .54396 L p .4487 .54158 L .541 .908 .724 r
F P
0 g
s
.44656 .54396 m .46849 .53444 L p .4487 .54158 L .541 .908 .724 r
F P
0 g
s
.43746 .5541 m .44349 .55642 L .441 .55015 L p .247 .594 .95 r
F P
0 g
s
.56394 .44139 m .53949 .51757 L .52237 .51241 L p .706 .619 .758 r
F P
0 g
s
.53949 .51757 m .56394 .44139 L .57756 .44354 L p .838 .767 .783 r
F P
0 g
s
.66643 .6249 m .55916 .58373 L .56455 .56714 L p .639 .547 .735 r
F P
0 g
s
.55916 .58373 m .66643 .6249 L .66434 .63649 L p .533 .606 .872 r
F P
0 g
s
.52237 .51241 m .54669 .43615 L .56394 .44139 L p .706 .619 .758 r
F P
0 g
s
.56455 .56714 m .67209 .60818 L .66643 .6249 L p .639 .547 .735 r
F P
0 g
s
.02 w
.67138 .61028 m
.72965 .63253 L
s
.5 Mabswid
.43459 .5987 m .4686 .58181 L .46115 .55781 L p .978 .696 .417 r
F P
0 g
s
.4686 .58181 m .43459 .5987 L .45481 .61501 L p .801 .337 .131 r
F P
0 g
s
.45481 .61501 m .48802 .5974 L .4686 .58181 L p .801 .337 .131 r
F P
0 g
s
.42678 .57364 m .46115 .55781 L .46849 .53444 L p .961 .942 .65 r
F P
0 g
s
.46115 .55781 m .42678 .57364 L .43459 .5987 L p .978 .696 .417 r
F P
0 g
s
.48802 .5974 m .45481 .61501 L .47987 .61638 L p .348 0 0 r
F P
0 g
s
.47987 .61638 m .51211 .59866 L .48802 .5974 L p .348 0 0 r
F P
0 g
s
.46849 .53444 m .43436 .54926 L .42678 .57364 L p .961 .942 .65 r
F P
0 g
s
.51211 .59866 m .47987 .61638 L .50026 .60216 L p .473 .861 .659 r
F P
0 g
s
.6701 .63113 m .53554 .57943 L p .53353 .59114 L .247 .594 .95 r
F P
0 g
s
.50809 .57766 m .5393 .5615 L .53173 .58498 L p .951 .943 .622 r
F P
0 g
s
.53554 .57943 m .52928 .57702 L .53114 .58322 L p .247 .594 .95 r
F P
0 g
s
.52454 .58891 m .53173 .58498 L .51795 .59459 L p .473 .861 .659 r
F P
0 g
s
.53173 .58498 m .50026 .60216 L .50809 .57766 L p .951 .943 .622 r
F P
0 g
s
.53114 .58322 m .53353 .59114 L p .53554 .57943 L .247 .594 .95 r
F P
0 g
s
.50026 .60216 m .52454 .58891 L p .51211 .59866 L .473 .861 .659 r
F P
0 g
s
.51795 .59459 m .51211 .59866 L p .52454 .58891 L .473 .861 .659 r
F P
0 g
s
.48793 .52056 m .45454 .53481 L .43436 .54926 L p .541 .908 .724 r
F P
0 g
s
.45454 .53481 m .48793 .52056 L .51214 .52158 L p .292 0 0 r
F P
0 g
s
.47973 .53593 m .51214 .52158 L .53181 .53723 L p .79 .309 .08 r
F P
0 g
s
.51214 .52158 m .47973 .53593 L .45454 .53481 L p .292 0 0 r
F P
0 g
s
.5393 .5615 m .50809 .57766 L .50024 .5523 L p .98 .691 .386 r
F P
0 g
s
.50024 .5523 m .53181 .53723 L .5393 .5615 L p .98 .691 .386 r
F P
0 g
s
.03 w
.49538 .56191 m
.50219 .55859 L
s
.5 Mabswid
.53181 .53723 m .50024 .5523 L .47973 .53593 L p .79 .309 .08 r
F P
0 g
s
.53353 .59114 m .67195 .64451 L .6701 .63113 L p .247 .594 .95 r
F P
0 g
s
.40524 .55653 m .2074 .47993 L .21838 .49764 L p .215 .583 .944 r
F P
0 g
s
.21838 .49764 m .41255 .57311 L .40524 .55653 L p .215 .583 .944 r
F P
0 g
s
.41226 .60978 m .42862 .60166 L .42075 .57642 L p .978 .696 .417 r
F P
0 g
s
.42862 .60166 m .41226 .60978 L .43302 .62657 L p .801 .337 .131 r
F P
0 g
s
.43302 .62657 m .44899 .6181 L .42862 .60166 L p .801 .337 .131 r
F P
0 g
s
.40423 .58403 m .42075 .57642 L .42837 .55186 L p .961 .942 .65 r
F P
0 g
s
.42075 .57642 m .40423 .58403 L .41226 .60978 L p .978 .696 .417 r
F P
0 g
s
.44899 .6181 m .43302 .62657 L .45871 .62802 L p .348 0 0 r
F P
0 g
s
.45871 .62802 m .47422 .61949 L .44899 .6181 L p .348 0 0 r
F P
0 g
s
.41195 .55899 m .42837 .55186 L .44869 .53732 L p .541 .908 .724 r
F P
0 g
s
.42837 .55186 m .41195 .55899 L .40423 .58403 L p .961 .942 .65 r
F P
0 g
s
.47422 .61949 m .45871 .62802 L .4796 .61344 L p .473 .861 .659 r
F P
0 g
s
.4796 .61344 m .49474 .60517 L .47422 .61949 L p .473 .861 .659 r
F P
0 g
s
.44869 .53732 m .43263 .54417 L .41195 .55899 L p .541 .908 .724 r
F P
0 g
s
.43263 .54417 m .44869 .53732 L .47405 .53845 L p .292 0 0 r
F P
0 g
s
.49474 .60517 m .4796 .61344 L .48759 .58827 L p .951 .943 .622 r
F P
0 g
s
.48759 .58827 m .50261 .5805 L .49474 .60517 L p .951 .943 .622 r
F P
0 g
s
.45846 .54535 m .47405 .53845 L .4947 .55495 L p .79 .309 .08 r
F P
0 g
s
.47405 .53845 m .45846 .54535 L .43263 .54417 L p .292 0 0 r
F P
0 g
s
.70696 .67335 m .496 .59167 L .50158 .60772 L p .215 .583 .944 r
F P
0 g
s
.50158 .60772 m .70836 .68809 L .70696 .67335 L p .215 .583 .944 r
F P
0 g
s
.50261 .5805 m .48759 .58827 L .47951 .56221 L p .98 .691 .386 r
F P
0 g
s
.03 w
.48533 .56681 m
.49051 .56429 L
s
.5 Mabswid
.47951 .56221 m .4947 .55495 L .50261 .5805 L p .98 .691 .386 r
F P
0 g
s
.4947 .55495 m .47951 .56221 L .45846 .54535 L p .79 .309 .08 r
F P
0 g
s
.38593 .61861 m .39534 .62624 L .44366 .58712 L closepath p .812 .401 .27 r
F P
0 g
s
.38227 .60691 m .38593 .61861 L .44366 .58712 L closepath p .957 .701 .506 r
F P
0 g
s
.38575 .59558 m .38227 .60691 L .44366 .58712 L closepath p .959 .923 .725 r
F P
0 g
s
.39507 .58893 m .38575 .59558 L .44366 .58712 L closepath p .675 .977 .876 r
F P
0 g
s
.40668 .58953 m .39507 .58893 L .44366 .58712 L closepath p .095 0 0 r
F P
0 g
s
.41614 .59718 m .40668 .58953 L .44366 .58712 L closepath p .723 .191 0 r
F P
0 g
s
.39534 .62624 m .40692 .62689 L .44366 .58712 L closepath p .463 0 0 r
F P
0 g
s
.41981 .60894 m .41614 .59718 L .44366 .58712 L closepath p .958 .645 .229 r
F P
0 g
s
.40692 .62689 m .41628 .6203 L .44366 .58712 L closepath p 0 0 0 r
F P
0 g
s
.41628 .6203 m .41981 .60894 L .44366 .58712 L closepath p .869 .886 .456 r
F P
0 g
s
.03 w
.44366 .58712 m
.48151 .56867 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00N`3oool300000:80oooo001h
0?ooo`<000000`3cVdjR0?ooo`00N03oool00`000000li]>0?>KCP030?>KCP030000003oool0oooo
09l0oooo001i0?ooo`030000003cVdh0li]>00<0li]>X@3oool007T0oooo00<000000?>KCP3cVdh0
0`3cVdh00`000000oooo0?ooo`2N0?ooo`00NP3oool00`000000li]>0?>KCP020?>KCP030000003o
ool0oooo09h0oooo001j0?ooo`030000003cVdh0li]>00<0li]>00<000000?ooo`3oool0W@3oool0
07/0oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo0?ooo`2M0?ooo`00N`3oool00`000000
li]>0?>KCP030?>KCP030000003oool0oooo09`0oooo001l0?ooo`030000003cVdh0li]>0080li]>
00<000000?ooo`3oool0W03oool007`0oooo00<000000?>KCP3cVdh00`3cVdh00`000000oooo0?oo
o`2K0?ooo`00O@3oool00`000000li]>0?>KCP020?>KCP030000003oool0oooo09/0oooo001m0?oo
o`030000003cVdh0li]>00<0li]>00<000000?ooo`3oool0VP3oool007h0oooo00<000000?>KCP3c
Vdh00P3cVdh00`000000oooo0?ooo`2J0?ooo`00OP3oool00`000000li]>0?>KCP030?>KCP030000
003oool0oooo09T0oooo001o0?ooo`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0V@3o
ool007l0oooo00<000000?>KCP3cVdh00`3cVdh00`000000oooo0?ooo`2H0?ooo`00P03oool00`00
0000li]>0?>KCP020?>KCP030000003oool0oooo09P0oooo00200?ooo`030000003cVdh0li]>0080
li]>00<000000?ooo`3oool0V03oool00840oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo
0?ooo`2G0?ooo`00P@3oool00`000000li]>0?>KCP020?>KCP030000003oool0oooo09L0oooo0022
0?ooo`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0UP3oool00880oooo00<000000?>K
CP3cVdh00P3cVdh00`000000oooo0?ooo`2F0?ooo`00P`3oool00`000000li]>0?>KCP020?>KCP03
0000003oool0oooo09D0oooo00230?ooo`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0
U@3oool008@0oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo0?ooo`2D0?ooo`00Q03oool0
0`000000li]>0?>KCP020?>KCP030000003oool0oooo09@0oooo00250?ooo`030000003cVdh0li]>
0080li]>00<000000?ooo`3oool0T`3oool008D0oooo00<000000?>KCP3cVdh00P3cVdh00`000000
oooo0?ooo`2C0?ooo`00Q@3oool00`000000li]>0?>KCP030?>KCP030000003oool0oooo0980oooo
00260?ooo`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0TP3oool008H0oooo00<00000
0?>KCP3cVdh00`3cVdh00`000000oooo0?ooo`2A0?ooo`00Q`3oool00`000000li]>0?>KCP020?>K
CP030000003oool0oooo0940oooo00270?ooo`030000003cVdh0li]>00<0li]>00<000000?ooo`3o
ool0T03oool008P0oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo0?ooo`2@0?ooo`00R03o
ool00`000000li]>0?>KCP030?>KCP030000003oool0oooo04X0oooo100000110?ooo`00R@3oool0
0`000000li]>0?>KCP020?>KCP030000003oool0oooo04P0oooo0P1Lck02000004<0oooo00290?oo
o`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0AP3oool205c?/0800000A@3oool008X0
oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo0?ooo`130?ooo`80G<n`0P0000170?ooo`00
RP3oool00`000000li]>0?>KCP020?>KCP030000003oool0oooo0440oooo0P1Lck02000004T0oooo
002;0?ooo`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0?P3oool205c?/0800000B`3o
ool008/0oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo0?ooo`0l0?ooo`80G<n`0P00001=
0?ooo`00S03oool00`000000li]>0?>KCP020?>KCP030000003oool0oooo03T0oooo0P1Lck020000
04l0oooo002<0?ooo`030000003cVdh0li]>0080li]>00<000000?ooo`3oool0=`3oool0101Lck00
000000000000001A0?ooo`00S@3oool00`000000li]>0?>KCP020?>KCP030000003oool0oooo03@0
oooo00<0G<n`000000000000E03oool008d0oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo
0?ooo`0b0?ooo`0305c?/0000000000005H0oooo002>0?ooo`030000003cVdh0li]>0080li]>00<0
00000?ooo`3oool0;`3oool00`1Lck0000000000001H0?ooo`00SP3oool00`000000li]>0?>KCP02
0?>KCP030000003oool0oooo02d0oooo00<0G<n`000000000000FP3oool008l0oooo00<000000?>K
CP3cVdh00P3cVdh00`000000oooo0?ooo`0Z0?ooo`0305c?/0000000000005`0oooo002?0?ooo`03
0000003cVdh0li]>0080li]>00<000000?ooo`3oool0:03oool00`1Lck0000000000001N0?ooo`00
T03oool00`000000li]>0?>KCP020?>KCP030000003oool0oooo02D0oooo00<0G<n`000000000000
H03oool00900oooo00<000000?>KCP3cVdh00P3cVdh00`000000oooo0?ooo`0S0?ooo`0305c?/000
000000000680oooo002A0?ooo`030000003cVdh0li]>0080li]>1000000O0?ooo`<00000I03oool0
0940oooo00@000000?>KCP3cVdh0li]>100000000`3E`lP0000000000003000001P0oooo0P00001W
0?ooo`00TP3oool3000000040?ooo`00000090]h000000<0eL?800<000000;BN`@2dW/400`00000C
0?ooo`800000J@3oool00980oooo00H000000?ooo`3oool0oooo0000000T2gP4000000D0]9k100<0
SWJc0000000000003`3oool2000006/0oooo002F0?ooo`8000000`2=M;<4000000030;BN`@000000
SWJc0080SWJc0P00000;0?ooo`800000K@3oool009D0oooo00<0000002@;N0000000102=M;<00`00
0000]9k20;BN`P0400000080SWJc00<0;15l0000000000001`3oool2000006l0oooo002E0?ooo`03
0000000T2gP0000000<0SGBc00<000000;BN`P2dW/800`2dW/800`000000e/C80000000200000003
0??aX0000000oooo00@0oooo0P00001a0?ooo`00U@3oool2000000@0SGBc00<000000;BN`P2dW/80
0P2dW/800`000000e/C80=K4b0020=K4b0030000003clJ00oooo00<0oooo0P00001c0?ooo`00U03o
ool00`00000090]h0000000408ed/`030000002dW/80]9k20080]9k200L000000=K4b03Fa<P0e/C8
0000003clJ0000000080oooo0P00001e0?ooo`00U03oool00`00000090]h0000000308ed/`030000
002dW/80]9k200<0]9k200H000000=K4b03Fa<P0e/C80000003clJ03000007L0oooo002D0?ooo`80
0000102=M;<00`000000]9k20;BN`P020;BN`P030000003Fa<P0e/C80080e/C800<000000??aX000
0000N@3oool009@0oooo0P00000408ed/`030000002dW/80]9k20080]9k200L000000=K4b03Fa<P0
e/C80000003clJ00000007X0oooo002C0?ooo`030000000T2gP0000000<0SGBc00<000000;BN`P2d
W/800`2dW/801`000000e/C80=K4b03Fa<P000000??aX0000000NP3oool009<0oooo00<0000002@;
N00000000`2=M;<00`000000]9k20;BN`P020;BN`P030000003Fa<P0e/C80080e/C80P00001k0?oo
o`00T`3oool2000000@0SGBc00<000000;BN`P2dW/800P2dW/801`000000e/C80=K4b03Fa<P00000
0??aX0000000N`3oool00980oooo00<0000002@;N0000000102=M;<00`000000]9k20;BN`P020;BN
`P070000003Fa<P0e/C80=K4b0000000lo6P0000001k0?ooo`00>`3oool2000005D0oooo00<00000
02@;N00000000`2=M;<00`000000]9k20;BN`P030;BN`P070000003Fa<P0e/C80=K4b0000000lo6P
0000001k0?ooo`00?03oool3000003L0oooo0P00000J0?ooo`800000102=M;<00`000000]9k20;BN
`P020;BN`P030000003Fa<P0e/C80080e/C80P00001l0?ooo`00?03oool00`000000=iGa03NEl@03
000003<0oooo00<000000;=AD@2cDE400P00000G0?ooo`030000000T2gP0000000@0SGBc00<00000
0;BN`P2dW/800P2dW/801`000000e/C80=K4b03Fa<P000000??aX0000000O03oool003d0oooo00<0
000003NEl@0gUO400P0gUO4300000180oooo0P00000K0?ooo`800000102cDE43000001@0oooo00<0
000002@;N00000000`2=M;<00`000000]9k20;BN`P030;BN`P070000003Fa<P0e/C80=K4b0000000
lo6P0000001l0?ooo`00?@3oool00`000000=iGa03NEl@0503NEl@800000403oool010000000?iSc
00000000000I0?ooo`040000002_NYT00000000000D0/e5A0P00000B0?ooo`800000102=M;<00`00
0000]9k20;BN`P020;BN`P030000003Fa<P0e/C80080e/C80P00001m0?ooo`00?P3oool2000000L0
=iGa0`00000>0?ooo`030000000oV?<0?iSc00<000005@3oool00`000000[gZI0:mjV@020:mjV@<0
0000102cDE43000000h0oooo00<0000002@;N0000000102=M;<00`000000]9k20;BN`P020;BN`P07
0000003Fa<P0e/C80=K4b0000000lo6P0000001m0?ooo`00@03oool2000000P0=iGa0P00000<0?oo
o`030000000oV?<0?iSc00<0?iSc0P00000C0?ooo`030000002_NYT0[gZI00D0[gZI0P0000050;=A
D@800000303oool00`00000090]h0000000308ed/`030000002dW/80]9k200<0]9k200L000000=K4
b03Fa<P0e/C80000003clJ00000007d0oooo00120?ooo`<000001`0gUO43000000X0oooo00<00000
03nHl`0oV?<0100oV?<3000000l0oooo0P0000090:mjV@<00000102cDE43000000T0oooo0P000004
08ed/`030000002dW/80]9k20080]9k200<000000=K4b03Fa<P00P3Fa<P2000007h0oooo00150?oo
o`800000200gUO43000000L0oooo0P00000803nHl`8000003@3oool010000000Xhbl00000000000:
0:mjV@8000001@2cDE43000000L0oooo00<0000008ed/`2=M;<00P2=M;<00`000000]9k20;BN`P02
0;BN`P070000003Fa<P0e/C80=K4b0000000lo6P0000001n0?ooo`00A`3oool3000000P0=iGa0P00
00070?ooo`800000200oV?<3000000T0oooo00<000000:><_02SS;`00P2SS;`3000000T0[gZI0`00
00040;=AD@<000001P3oool20000000308ed/`000000]9k200@0]9k200L000000=K4b03Fa<P0e/C8
0000003clJ00000007h0oooo001:0?ooo`800000200gUO43000000H0oooo0`00000803nHl`800000
1`3oool00`000000Xhbl0:><_0050:><_08000002P2_NYT200000080/e5A00<0000008ZKgP000000
203oool400000080]9k200<000000=K4b03Fa<P00P3Fa<P2000007l0oooo001<0?ooo`<00000200g
UO42000000L0oooo0P00000803nHl`<000000`3oool00`000000Xhbl0:><_0080:><_0<000002@2_
NYT200000080RY_N00<000000?ooo`3oool0203oool600000080e/C81000001n0?ooo`00C`3oool3
000000L0=iGa0`0000060?ooo`<00000200oV?<5000000`0Xhbl0P0000080:mjV@80000000<0RY_N
0000000000001P0000030?ooo`800000103oool30000000407X000000000cfQ8000007d0oooo001B
0?ooo`800000200gUO42000000L0oooo0`00000803nHl`@00000302SS;`3000000@0[gZI00@00000
0:><^`0000000000101:000200000080bTlD1@0000030?ooo`80000000<0NP000000000000000`3?
J4P00`000000oooo0?ooo`1j0?ooo`00E03oool3000000L0=iGa0`0000070?ooo`800000200oV?<5
000000`0Xhbl0P000000102_NYT0000000000000000404X0008000001@3:Ca@6000000040?ooo`00
0000NP00000000<0cfQ80`00001l0?ooo`00E`3oool2000000P0=iGa0`0000060?ooo`<00000200o
V?<5000000X0Xhbl0P00000504X000800000203:Ca@60000000407X000000000cfQ80<mXB0800000
0P3d/h<2000007/0oooo001I0?ooo`<00000200gUO42000000L0oooo0P00000803nHl`D000001P2S
S;`9000000`0bTlD1@000000103?J4P000000000003d/h<3000000030?C[^P000000oooo07X0oooo
001L0?ooo`800000200gUO43000000H0oooo0`00000803nHla400000303:Ca@2000000030=VBQ@00
0000000000@000000`3djkX00`000000oooo0?ooo`1j0?ooo`00GP3oool3000000P0=iGa0P000007
0?ooo`8000002@0oV?<2000000H0BP000P0000020<Y?50<000002@3:Ca@2000000030?Z`HP000000
000000<000000`3djkX4000007`0oooo001Q0?ooo`800000200gUO43000000H0oooo0`00000503nH
l`T000001@3:Ca@4000000D0bTlD0P0000040?Z`HP80000000<0olUi0000000000000P0000020;3j
h`030000003oool0oooo00800000N@3oool006<0oooo0`00000803NEl@<000001P3oool7000000H0
m_6V00<000000<Y?503:Ca@0103:Ca@400000080bTlD0P0000060?Z`HP80000000<0olUi00000000
0000100000030?ooo`030000002cDE40/e5A00800000MP3oool006H0oooo0P00000903NEl@800000
1P3oool4000000P0m_6V00<000000<Y?503:Ca@00P3:Ca@:000000D0n[1R100000070?ooo`800000
102cDE43000007<0oooo001X0?ooo`<000002@0gUO400`000000oooo0?ooo`02000000030?KaYP00
0000000000P0m_6V100000020<Y?50X000001@3j/687000000@0oooo00@000000:mjV@0000000000
1@2cDE4200000740oooo001[0?ooo`<000001P0gUO400`000000oooo000000020?KaYP030000003o
ool0000000L0m_6V0`0000000`2dE5D000000000000<000000D0n[1R200000000`3oool000000:mj
V@030:mjV@<00000102cDE43000006h0oooo001^0?ooo`8000001@0gUO4200000080m_6V00<00000
0?ooo`0000001@3flJH2000000030?ZbJP000000000000l00000103j/68;000000L0[gZI0P000005
0;=AD@<00000J`3oool00700oooo0`00000203NEl@070000003flJH0m_6V0?KaYP000000oooo0000
00020?KaYP<000000P3j/VXB00000080n[1R0P0000000`3clIl0000000000008000000T0[gZI0`00
00050;=AD@<00000J03oool007<0oooo0`0000030?KaYP80000000<0m_6V0000000000000`3j/VXB
00000080n[1R0P0000020??aW`X0000000<0Xhbl0000000000002P2_NYT2000000H0/e5A0`00001U
0?ooo`00M@3oool01@000000m_6V0?KaYP000000oooo008000000`3j/VXC000000030?Z`HP000000
000000@0lo6O00D000000?ooo`3oool000000?ooo`04000000@0Xhbl0`0000090:mjV@<000001P2c
DE42000006<0oooo001e0?ooo`070000003flJH000000000003oool000000?ZbJP0G000000@0lo6O
00<000000??aW`0000001`3oool00`000000Xhbl0:><_0050:><_08000002P2_NYT2000000H0/e5A
0`00001P0?ooo`00M03oool3000000030?ZbJP000000oooo01@0000000@0n[1R0000000000000000
1@3clIl4000000D0oooo00<000000:><_02SS;`0202SS;`3000000T0[gZI0`0000060;=AD@<00000
G@3oool007@0oooo00<000000?ZbJP3j/VX00P3j/VX00`000000oooo0000000@000000050?Z`HP00
000000000??aW`0000001`3clIl00`000000?iSc03nHl`02000000<0oooo0P00000<0:><_0800000
2P2_NYT2000000L0/e5A0P00001K0?ooo`00M03oool010000000n[9Z0?ZbJP3j/VXA000000040?Ga
Y@000000000000000080lo6O0P0000050??aW`<00000100oV?<40000000308RKg`000000000000`0
Xhbl0`0000090:mjV@<00000102cDE43000005X0oooo001`0?ooo`X0000000<0^C00000000000000
2P0000020<eF8@<000000P3clIl3000000<0lo6O0`0000020?ooo`8000001@0oV?<30000000408RK
g`0000000000000000`0Xhbl0P00000:0:mjV@8000000P2cDE400`000000RY_N0000001J0?ooo`00
KP3oool500000080mNbi0P0000020;T`0080000000<0mJDj0000000000001`0000060<eF8@050000
003clIl0lo6O0000000gUO401`0000040?ooo`8000001P0oV?<200000080R9_O0`00000;0:><_0<0
00002@2_NYT20000000308ZKgP000000oooo05X0oooo001^0?ooo`030000003ek;T0mNbi00@0mNbi
100000020?FU>PP000001`3=ER401@000000lo6O0??aW`3clIl0000000<0=iGa0`0000000`2>M[<0
;15l000000050?ooo`<000001@0oV?<300000080R9_O0P00000<0:><_0800000202_NYT3000005/0
oooo001^0?ooo`040000003ek;T0mNbi0?G/^@<000000P3d/h401@000000mJDj0?FU>P000000g^9d
00@000002@3=ER4200000080lo6O00<0000005T0000000001@0gUO44000000L0oooo0`00000503nH
l`8000000P28Vml3000000/0Xhbl0`0000020:mjV@030000002_NYT000000080Xhbk00<000000?oo
o`3oool0F@3oool006d0oooo00<000000?G/^@0000000P0000030?BcP@80000000@0cfI500000000
0000g^9d100000080<eF8@80000000@0F@000000003clIl0lo6O0`00000703NEl@<000002@3oool2
000000D0?iSc0`00000208RKg`800000302SS;`5000000030:><^`000000oooo05/0oooo001]0?oo
o`800000103d/h4200000080cfI50P0000001P3NhW@000000<eF8@3=ER4000000?ooo`800000103=
ER42000000<0F@00100000000`2dW/8000000000000903NEl@8000002@3oool3000000D0?iSc0`00
00001028Vml0000000000000000:0:><_0L00000F`3oool006d0oooo00@000000?BcP@3d/h40m;>1
0P0000030<mVA@040000001f00000000000000@0cEHQ00D000000?ooo`3oool000000<eF8@020000
00@0F@000`0000000`2=M;<000000;BN`P020;BN`P8000002@0gUO43000000T0oooo0P00000603nH
l`8000000P28Vml2000000P0Xhbl2P00001H0?ooo`00KP3oool3000000@0cfI500<0000007H00000
00000P0000050<eF8@030000003oool0oooo00P000000P2=M;<00`000000]9k20;BN`P020;BN`P03
0000003Fa<P00000008000002@0gUO42000000T0oooo0`00000503nHl`<0000000@0R9_O00000000
00000000102SS;`>000005D0oooo001^0?ooo`030000003?ITD0cfI50080cfI50P0000000`1f0000
000000000002000000D0cEHQ2P00000308ed/`030000002dW/80]9k20080]9k200@000000=K4b03F
a<P0e/C81000000803NEl@<000002@3oool3000000D0?iSc0P00000208RKg`<000000`2SS;`?0000
0580oooo001_0?ooo`80000000@0cfI50000001f0000MP000`0000020?ooo`80000000<0cEHQ0000
000000001`1I0002000000@0SGBc00<000000;BN`P2dW/800P2dW/8010000000e/C80=K4b03Fa<P2
00000080oooo0P00000903NEl@8000002P3oool2000000D0?iSc0`00000208RKg`80000000<0Xhbl
0000002_NiX04000001?0?ooo`00L@3oool5000000H0oooo1000000405T00080000000<090]h0000
002=M;<00P2=M;<00`000000]9k20;BN`P020;BN`P070000003Fa<P0e/C80=K4b0000000lo6P0000
00040?ooo`<00000200gUO43000000T0oooo0`00000503nHl`<0000000D0R9_O000000000000[g^J
000000020?ooo`l00000C@3oool00800oooo1@0000000`0T2gP0000008ed/`0308ed/`030000002d
W/80]9k20080]9k200H000000=K4b03Fa<P0e/C80000003clJ080?ooo`8000002@0gUO42000000X0
oooo0P00000603nHl`@000001P3oool>000004/0oooo00240?ooo`030000000T2gP0000000@0SGBc
00<000000;BN`P2dW/800P2dW/8010000000e/C80=K4b03Fa<P2000000X0oooo0`00000803NEl@<0
00002@3oool3000000H0?iSc00<000000?ooo`3oool01`3oool:000004`0oooo00240?ooo`030000
000T2gP0000000<0SGBc00<000000;BN`P2dW/800P2dW/801`000000e/C80=K4b03Fa<P000000??a
X00000003@3oool3000000P0=iGa0P00000:0?ooo`<000000`0oV?<00`000000oooo0?ooo`0:0?oo
o`L00000C03oool008@0oooo0P00000408ed/`030000002dW/80]9k20080]9k200@000000=K4b03F
a<P0e/C80P00000A0?ooo`800000200gUO43000000X0oooo0P0000000`0oV?<000000?ooo`0>0?oo
o`<00000C@3oool008<0oooo00<0000002@;N0000000102=M;<00`000000]9k20;BN`P020;BN`P04
0000003Fa<P0e/C80=K4b08000004`3oool3000000P0=iGa0P00000:0?ooo`8000004@3oool00`00
0000oooo0?ooo`1;0?ooo`00P`3oool00`00000090]h0000000308ed/`030000002dW/80]9k200<0
]9k200@000000=K4b03Fa<P0e/C80P00000F0?ooo`800000200gUO43000006P0oooo00230?ooo`80
0000102=M;<00`000000]9k20;BN`P020;BN`P040000003Fa<P0e/C80=K4b08000006@3oool30000
00P0=iGa0P00001V0?ooo`00PP3oool00`00000090]h0000000408ed/`030000002dW/80]9k20080
]9k200@000000=K4b03Fa<P0e/C80P00000L0?ooo`<000001`0gUO43000006<0oooo00220?ooo`03
0000000T2gP0000000<0SGBc00<000000;BN`P2dW/800`2dW/8010000000e/C80=K4b03Fa<P20000
01l0oooo0P00000803NEl@800000H@3oool00880oooo0P00000408ed/`030000002dW/80]9k20080
]9k200@000000=K4b03Fa<P0e/C80P00000R0?ooo`<000001`0gUO43000005h0oooo00230?ooo`03
0000002=M;<0SGBc0080SGBc00<000000;BN`P2dW/800P2dW/8010000000e/C80=K4b03Fa<P20000
02D0oooo0`00000703NEl@800000G03oool008@0oooo0P0000000`2=M;<000000;BN`P040;BN`P04
0000003Fa<P0e/C80=K4b0800000:03oool2000000L0=iGa0`00001I0?ooo`00QP3oool3000000@0
]9k200D000000=K4b03Fa<P0e/C80000000[0?ooo`<000001`0gUO42000005L0oooo00280?ooo`<0
000000<0]9k20000003Fa<P00P3Fa<P2000002h0oooo0P00000803NEl@030000003oool0oooo05<0
oooo00280?ooo`80000000<0oooo0000000000001000000a0?ooo`<000001@0gUO400`000000oooo
0?ooo`1C0?ooo`00R03oool2000003/0oooo0`00000203NEl@030000003oool0oooo05<0oooo0027
0?ooo`<00000?P3oool20000000303NEl@000000oooo05<0oooo00270?ooo`800000@@3oool20000
05@0oooo00270?ooo`800000U`3oool008L0oooo0P00002G0?ooo`00QP3oool2000009P0oooo0026
0?ooo`800000V03oool008H0oooo0P00002H0?ooo`00Q@3oool3000009P0oooo00260?ooo`030000
003oool0oooo09L0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.48436 .52895 m .47814 .53675 L .5073 .54556 L closepath p .077 0 .148 r
F P
0 g
s
.48523 .51914 m .48436 .52895 L .5073 .54556 L closepath p 0 0 .405 r
F P
0 g
s
.47814 .53675 m .46892 .53959 L .5073 .54556 L closepath p .168 0 0 r
F P
0 g
s
.48041 .51105 m .48523 .51914 L .5073 .54556 L closepath p 0 0 .48 r
F P
0 g
s
.46892 .53959 m .46021 .53636 L .5073 .54556 L closepath p 0 .479 .808 r
F P
0 g
s
.47171 .50777 m .48041 .51105 L .5073 .54556 L closepath p .646 .095 0 r
F P
0 g
s
.46021 .53636 m .45533 .52827 L .5073 .54556 L closepath p .148 .359 .815 r
F P
0 g
s
.46245 .51058 m .47171 .50777 L .5073 .54556 L closepath p .528 .121 .213 r
F P
0 g
s
.45533 .52827 m .45619 .51842 L .5073 .54556 L closepath p .29 .24 .628 r
F P
0 g
s
.45619 .51842 m .46245 .51058 L .5073 .54556 L closepath p .405 .168 .438 r
F P
0 g
s
.60473 .47871 m .78627 .4542 L .80635 .46158 L p .389 0 0 r
F P
0 g
s
.54182 .58569 m .61856 .64987 L .62906 .63658 L p .779 .673 .747 r
F P
0 g
s
.62906 .63658 m .55256 .57217 L .54182 .58569 L p .779 .673 .747 r
F P
0 g
s
.55256 .57217 m .62906 .63658 L .64149 .62818 L p .666 .675 .849 r
F P
0 g
s
.53673 .59891 m .61389 .66312 L .61856 .64987 L p .859 .635 .597 r
F P
0 g
s
.61856 .64987 m .54182 .58569 L .53673 .59891 L p .859 .635 .597 r
F P
0 g
s
.56495 .56337 m .64149 .62818 L .6512 .62786 L p .329 .576 .931 r
F P
0 g
s
.64149 .62818 m .56495 .56337 L .55256 .57217 L p .666 .675 .849 r
F P
0 g
s
.53925 .60685 m .61688 .67133 L .61389 .66312 L p .841 .376 .069 r
F P
0 g
s
.61389 .66312 m .53673 .59891 L .53925 .60685 L p .841 .376 .069 r
F P
0 g
s
.6512 .62786 m .57436 .56263 L .56495 .56337 L p .329 .576 .931 r
F P
0 g
s
.57436 .56263 m .6512 .62786 L .65445 .63588 L p .828 .353 .026 r
F P
0 g
s
.61015 .46838 m .5611 .53008 L .56749 .53353 L p .29 .032 .338 r
F P
0 g
s
.61216 .48214 m .60473 .47871 L p .62108 .47732 L .389 0 0 r
F P
0 g
s
.56749 .53353 m .61688 .4714 L .61015 .46838 L p .29 .032 .338 r
F P
0 g
s
.56749 .53353 m .5655 .53018 L p .60329 .48694 L .865 .995 .763 r
F P
0 g
s
.61688 .4714 m .60545 .48577 L p .60329 .48694 L .865 .995 .763 r
F P
0 g
s
.60545 .48577 m .56749 .53353 L p .60329 .48694 L .865 .995 .763 r
F P
0 g
s
.80635 .46158 m .62211 .48674 L .61216 .48214 L p .389 0 0 r
F P
0 g
s
.62108 .47732 m .80635 .46158 L .61216 .48214 L .389 0 0 r
F
.54857 .60638 m .62651 .67129 L .61688 .67133 L p .305 .568 .931 r
F P
0 g
s
.61688 .67133 m .53925 .60685 L .54857 .60638 L p .305 .568 .931 r
F P
0 g
s
.65445 .63588 m .57715 .57037 L .57436 .56263 L p .828 .353 .026 r
F P
0 g
s
.57715 .57037 m .65445 .63588 L .64986 .64928 L p .863 .636 .592 r
F P
0 g
s
.56117 .59755 m .63915 .66286 L .62651 .67129 L p .664 .678 .853 r
F P
0 g
s
.62651 .67129 m .54857 .60638 L .56117 .59755 L p .664 .678 .853 r
F P
0 g
s
.64986 .64928 m .57213 .58373 L .57715 .57037 L p .863 .636 .592 r
F P
0 g
s
.57213 .58373 m .64986 .64928 L .63915 .66286 L p .78 .675 .748 r
F P
0 g
s
.02 w
.64342 .65744 m
.67158 .68109 L
s
.5 Mabswid
.63915 .66286 m .56117 .59755 L .57213 .58373 L p .78 .675 .748 r
F P
0 g
s
.54886 .52123 m .59775 .45979 L .58432 .44886 L p .73 .598 .709 r
F P
0 g
s
.59775 .45979 m .54886 .52123 L .5611 .53008 L p .61 .429 .612 r
F P
0 g
s
.5611 .53008 m .61015 .46838 L .59775 .45979 L p .61 .429 .612 r
F P
0 g
s
.53536 .51033 m .58432 .44886 L .57484 .43964 L p .83 .76 .785 r
F P
0 g
s
.58432 .44886 m .53536 .51033 L .54886 .52123 L p .73 .598 .709 r
F P
0 g
s
.57484 .43964 m .52562 .5014 L .53536 .51033 L p .83 .76 .785 r
F P
0 g
s
.50363 .55062 m .51145 .5408 L .52464 .55143 L p .73 .598 .709 r
F P
0 g
s
.52464 .55143 m .51683 .56124 L .50363 .55062 L p .73 .598 .709 r
F P
0 g
s
.53097 .54158 m .52464 .55143 L .51145 .5408 L p .668 .606 .777 r
F P
0 g
s
.51683 .56124 m .52464 .55143 L .53649 .56017 L p .61 .429 .612 r
F P
0 g
s
.52464 .55143 m .53097 .54158 L .54051 .54857 L p .544 .444 .692 r
F P
0 g
s
.54051 .54857 m .53649 .56017 L .52464 .55143 L p .544 .444 .692 r
F P
0 g
s
.49843 .5606 m .50363 .55062 L .51683 .56124 L p .782 .579 .625 r
F P
0 g
s
.51683 .56124 m .50904 .56914 L .49843 .5606 L p .782 .579 .625 r
F P
0 g
s
.50904 .56914 m .51683 .56124 L .52866 .57003 L p .666 .404 .514 r
F P
0 g
s
.53649 .56017 m .52866 .57003 L .51683 .56124 L p .61 .429 .612 r
F P
0 g
s
.49396 .54209 m .50182 .53223 L .51145 .5408 L p .83 .76 .785 r
F P
0 g
s
.51145 .5408 m .50363 .55062 L .49396 .54209 L p .83 .76 .785 r
F P
0 g
s
.52038 .53304 m .51145 .5408 L .50182 .53223 L p .745 .761 .866 r
F P
0 g
s
.51145 .5408 m .52038 .53304 L .53097 .54158 L p .668 .606 .777 r
F P
0 g
s
.49064 .5538 m .49396 .54209 L .50363 .55062 L p .895 .735 .676 r
F P
0 g
s
.50363 .55062 m .49843 .5606 L .49064 .5538 L p .895 .735 .676 r
F P
0 g
s
.4434 .65376 m .49273 .59177 L .47916 .58089 L p .73 .598 .709 r
F P
0 g
s
.49273 .59177 m .4434 .65376 L .45529 .66315 L p .61 .429 .612 r
F P
0 g
s
.45529 .66315 m .50478 .6009 L .49273 .59177 L p .61 .429 .612 r
F P
0 g
s
.42977 .6429 m .47916 .58089 L .46911 .57229 L p .83 .76 .785 r
F P
0 g
s
.47916 .58089 m .42977 .6429 L .4434 .65376 L p .73 .598 .709 r
F P
0 g
s
.53461 .5336 m .53097 .54158 L .52038 .53304 L p .56 .599 .849 r
F P
0 g
s
.53097 .54158 m .53461 .5336 L .53992 .53748 L p .432 .449 .777 r
F P
0 g
s
.53992 .53748 m .54051 .54857 L .53097 .54158 L p .432 .449 .777 r
F P
0 g
s
.54459 .23087 m .55574 .43578 L .56515 .43992 L p .113 .144 .614 r
F P
0 g
s
.57484 .43964 m .57292 .43562 L p .56028 .4532 L .877 .993 .778 r
F P
0 g
s
.55707 .46194 m .57484 .43964 L p .56028 .4532 L .877 .993 .778 r
F P
0 g
s
.57292 .43562 m .52333 .49782 L .52562 .5014 L p .877 .993 .778 r
F P
0 g
s
.52562 .5014 m .55707 .46194 L p .56028 .4532 L .877 .993 .778 r
F P
0 g
s
.52333 .49782 m .57292 .43562 L .57945 .43843 L p .267 .004 .317 r
F P
0 g
s
.56515 .43992 m .57244 .44313 L p .57021 .42613 L .113 .144 .614 r
F P
0 g
s
.57021 .42613 m .54459 .23087 L .56515 .43992 L .113 .144 .614 r
F
.50182 .53223 m .51269 .52613 L .52038 .53304 L p .745 .761 .866 r
F P
0 g
s
.52871 .52884 m .52038 .53304 L .51269 .52613 L p .597 .729 .936 r
F P
0 g
s
.52038 .53304 m .52871 .52884 L .53461 .5336 L p .56 .599 .849 r
F P
0 g
s
.49687 .56883 m .49843 .5606 L .50904 .56914 L p .834 .526 .468 r
F P
0 g
s
.50904 .56914 m .50279 .57358 L .49687 .56883 L p .834 .526 .468 r
F P
0 g
s
.50279 .57358 m .50904 .56914 L .51852 .57622 L p .722 .345 .335 r
F P
0 g
s
.52866 .57003 m .51852 .57622 L .50904 .56914 L p .666 .404 .514 r
F P
0 g
s
.49253 .56506 m .49064 .5538 L .49843 .5606 L p .94 .65 .464 r
F P
0 g
s
.49843 .5606 m .49687 .56883 L .49253 .56506 L p .94 .65 .464 r
F P
0 g
s
.52866 .57003 m .53649 .56017 L .54257 .56375 L p .29 .031 .338 r
F P
0 g
s
.53649 .56017 m .54051 .54857 L .54541 .55138 L p .194 .084 .492 r
F P
0 g
s
.54541 .55138 m .54257 .56375 L .53649 .56017 L p .194 .084 .492 r
F P
0 g
s
.46911 .57229 m .41945 .63459 L .42977 .6429 L p .83 .76 .785 r
F P
0 g
s
.51852 .57622 m .52866 .57003 L .53468 .57367 L p .373 0 .147 r
F P
0 g
s
.54257 .56375 m .53468 .57367 L .52866 .57003 L p .29 .031 .338 r
F P
0 g
s
.02 w
.53827 .56915 m
.53994 .57055 L
s
.53994 .57055 m
.56553 .59204 L
s
.5 Mabswid
.50478 .6009 m .45529 .66315 L .46097 .66755 L p .29 .032 .338 r
F P
0 g
s
.46097 .66755 m .5108 .60486 L .50478 .6009 L p .29 .032 .338 r
F P
0 g
s
.54051 .54857 m .53992 .53748 L .54264 .539 L p .065 .142 .634 r
F P
0 g
s
.54264 .539 m .54541 .55138 L .54051 .54857 L p .065 .142 .634 r
F P
0 g
s
.4915 .5389 m .49941 .52897 L .50182 .53223 L p .877 .993 .778 r
F P
0 g
s
.50182 .53223 m .49396 .54209 L .4915 .5389 L p .877 .993 .778 r
F P
0 g
s
.51269 .52613 m .50182 .53223 L .49941 .52897 L p .695 .967 .935 r
F P
0 g
s
.48865 .5513 m .4915 .5389 L .49396 .54209 L p .96 .892 .51 r
F P
0 g
s
.49396 .54209 m .49064 .5538 L .48865 .5513 L p .96 .892 .51 r
F P
0 g
s
.51852 .57622 m .50805 .57753 L .50279 .57358 L p .722 .345 .335 r
F P
0 g
s
.50805 .57753 m .51852 .57622 L .5233 .57918 L p .443 0 0 r
F P
0 g
s
.53468 .57367 m .5233 .57918 L .51852 .57622 L p .373 0 .147 r
F P
0 g
s
.53461 .5336 m .52871 .52884 L p .53743 .53371 L 0 .226 .704 r
F P
0 g
s
.53992 .53748 m .53461 .5336 L p .53743 .53371 L 0 .226 .704 r
F P
0 g
s
.52871 .52884 m .52445 .52499 L p .53743 .53371 L 0 .226 .704 r
F P
0 g
s
.51269 .52613 m .52445 .52499 L .52871 .52884 L p .597 .729 .936 r
F P
0 g
s
.49941 .52897 m .51082 .52348 L .51269 .52613 L p .695 .967 .935 r
F P
0 g
s
.52445 .52499 m .51269 .52613 L .51082 .52348 L p .409 .811 .982 r
F P
0 g
s
.41945 .63459 m .46911 .57229 L .4664 .56923 L p .877 .993 .778 r
F P
0 g
s
.50279 .57358 m .50805 .57753 L p .49931 .56929 L 0 .186 .662 r
F P
0 g
s
.49687 .56883 m .50279 .57358 L p .49931 .56929 L 0 .186 .662 r
F P
0 g
s
.5655 .53018 m .61526 .46759 L .61688 .4714 L p .865 .995 .763 r
F P
0 g
s
.49143 .56371 m .48865 .5513 L .49064 .5538 L p .888 .608 .094 r
F P
0 g
s
.49064 .5538 m .49253 .56506 L .49143 .56371 L p .888 .608 .094 r
F P
0 g
s
.49253 .56506 m .49687 .56883 L p .49931 .56929 L 0 .186 .662 r
F P
0 g
s
.54264 .539 m .53992 .53748 L p .53743 .53371 L 0 .226 .704 r
F P
0 g
s
.52445 .52499 m .52345 .52351 L p .53743 .53371 L 0 .226 .704 r
F P
0 g
s
.51082 .52348 m .52345 .52351 L .52445 .52499 L p .409 .811 .982 r
F P
0 g
s
.41272 .47771 m .4702 .52578 L .48116 .51205 L p .779 .673 .747 r
F P
0 g
s
.48116 .51205 m .42386 .46381 L .41272 .47771 L p .779 .673 .747 r
F P
0 g
s
.42386 .46381 m .48116 .51205 L .4935 .50287 L p .666 .675 .849 r
F P
0 g
s
.4664 .56923 m .41636 .632 L .41945 .63459 L p .877 .993 .778 r
F P
0 g
s
.01 w
.54576 .5153 m
.58787 .46239 L
s
.53343 .53079 m
.53918 .52355 L
s
.53918 .52355 m
.54576 .5153 L
s
.5 Mabswid
.5233 .57918 m .51067 .57918 L .50805 .57753 L p .443 0 0 r
F P
0 g
s
.50805 .57753 m .51067 .57918 L p .49931 .56929 L 0 .186 .662 r
F P
0 g
s
.40688 .49086 m .46469 .53896 L .4702 .52578 L p .859 .635 .597 r
F P
0 g
s
.4702 .52578 m .41272 .47771 L .40688 .49086 L p .859 .635 .597 r
F P
0 g
s
.49143 .56371 m .49253 .56506 L p .49931 .56929 L 0 .186 .662 r
F P
0 g
s
.54257 .56375 m .54541 .55138 L .54372 .54886 L p .945 .884 .478 r
F P
0 g
s
.53743 .53371 m .5417 .53757 L .54264 .539 L p 0 .226 .704 r
F P
0 g
s
.54541 .55138 m .54264 .539 L .5417 .53757 L p .854 .577 .042 r
F P
0 g
s
.5417 .53757 m .54372 .54886 L .54541 .55138 L p .854 .577 .042 r
F P
0 g
s
.53468 .57367 m .54257 .56375 L .54045 .5607 L p .866 .995 .763 r
F P
0 g
s
.54372 .54886 m .54045 .5607 L .54257 .56375 L p .945 .884 .478 r
F P
0 g
s
.5233 .57918 m .53468 .57367 L .5325 .57069 L p .677 .968 .926 r
F P
0 g
s
.54045 .5607 m .5325 .57069 L .53468 .57367 L p .866 .995 .763 r
F P
0 g
s
.02 w
.5142 .54893 m
.53555 .56686 L
s
.5 Mabswid
.51067 .57918 m .5233 .57918 L .52149 .57682 L p .375 .802 .97 r
F P
0 g
s
.5325 .57069 m .52149 .57682 L .5233 .57918 L p .677 .968 .926 r
F P
0 g
s
.52345 .52351 m .52613 .525 L p .53743 .53371 L 0 .226 .704 r
F P
0 g
s
.51559 .52616 m .52613 .525 L .52345 .52351 L p .413 0 0 r
F P
0 g
s
.52345 .52351 m .51082 .52348 L .51559 .52616 L p .413 0 0 r
F P
0 g
s
.57945 .43843 m .52952 .50108 L .52333 .49782 L p .267 .004 .317 r
F P
0 g
s
.5108 .60486 m .46097 .66755 L .45818 .66519 L p .865 .995 .763 r
F P
0 g
s
.45818 .66519 m .50838 .60203 L .5108 .60486 L p .865 .995 .763 r
F P
0 g
s
.51067 .57918 m .50963 .57787 L p .49931 .56929 L 0 .186 .662 r
F P
0 g
s
.01 w
.4993 .57366 m
.50106 .57145 L
s
.5 Mabswid
.52149 .57682 m .50963 .57787 L .51067 .57918 L p .375 .802 .97 r
F P
0 g
s
.50529 .53236 m .51559 .52616 L .51082 .52348 L p .351 0 .115 r
F P
0 g
s
.51082 .52348 m .49941 .52897 L .50529 .53236 L p .351 0 .115 r
F P
0 g
s
.01 w
.5014 .57102 m
.53305 .53126 L
s
.5 Mabswid
.43616 .45432 m .4935 .50287 L .5026 .50172 L p .329 .576 .931 r
F P
0 g
s
.4935 .50287 m .43616 .45432 L .42386 .46381 L p .666 .675 .849 r
F P
0 g
s
.57528 .60648 m .6751 .69014 L .70274 .68315 L p .488 .64 .923 r
F P
0 g
s
.49732 .54236 m .50529 .53236 L .49941 .52897 L p .267 .004 .317 r
F P
0 g
s
.02 w
.50095 .53781 m
.5142 .54893 L
s
.5 Mabswid
.49941 .52897 m .4915 .5389 L .49732 .54236 L p .267 .004 .317 r
F P
0 g
s
.02 w
.49631 .53391 m
.49837 .53564 L
s
.49393 .53191 m
.49631 .53391 L
s
.5 Mabswid
.49931 .56929 m .49402 .56532 L .49143 .56371 L p 0 .186 .662 r
F P
0 g
s
.48865 .5513 m .49143 .56371 L .49402 .56532 L p .027 .115 .62 r
F P
0 g
s
.4933 .55414 m .49732 .54236 L .4915 .5389 L p .167 .058 .477 r
F P
0 g
s
.4915 .5389 m .48865 .5513 L .4933 .55414 L p .167 .058 .477 r
F P
0 g
s
.49402 .56532 m .4933 .55414 L .48865 .5513 L p .027 .115 .62 r
F P
0 g
s
.40859 .4983 m .46677 .54664 L .46469 .53896 L p .841 .376 .069 r
F P
0 g
s
.46469 .53896 m .40688 .49086 L .40859 .4983 L p .841 .376 .069 r
F P
0 g
s
.54372 .54886 m .5417 .53757 L .53743 .53371 L p .944 .649 .449 r
F P
0 g
s
.41636 .632 m .4664 .56923 L .47221 .573 L p .267 .004 .317 r
F P
0 g
s
.52613 .525 m .53147 .5289 L .53743 .53371 L p 0 .226 .704 r
F P
0 g
s
.52523 .53322 m .53147 .5289 L .52613 .525 L p .719 .333 .317 r
F P
0 g
s
.52613 .525 m .51559 .52616 L .52523 .53322 L p .719 .333 .317 r
F P
0 g
s
.61526 .46759 m .5655 .53018 L .55574 .52119 L p .833 .765 .787 r
F P
0 g
s
.55574 .52119 m .60577 .4583 L .61526 .46759 L p .833 .765 .787 r
F P
0 g
s
.50963 .57787 m .50529 .57409 L .49931 .56929 L p 0 .186 .662 r
F P
0 g
s
.50963 .57787 m .52149 .57682 L .51369 .56998 L p .59 .732 .942 r
F P
0 g
s
.51369 .56998 m .50529 .57409 L .50963 .57787 L p .59 .732 .942 r
F P
0 g
s
.4933 .55414 m .49402 .56532 L .49931 .56929 L p .421 .443 .778 r
F P
0 g
s
.53602 .54192 m .53743 .53371 L .53147 .5289 L p .837 .523 .457 r
F P
0 g
s
.53743 .53371 m .53602 .54192 L .54372 .54886 L p .944 .649 .449 r
F P
0 g
s
.54045 .5607 m .54372 .54886 L .53602 .54192 L p .9 .739 .673 r
F P
0 g
s
.47221 .573 m .42183 .63622 L .41636 .632 L p .267 .004 .317 r
F P
0 g
s
.01 w
.41007 .68576 m
.4993 .57366 L
s
.5 Mabswid
.53147 .5289 m .52523 .53322 L .53602 .54192 L p .837 .523 .457 r
F P
0 g
s
.52952 .50108 m .57945 .43843 L .59203 .44712 L p .608 .425 .609 r
F P
0 g
s
.52149 .57682 m .5325 .57069 L .52281 .56212 L p .745 .766 .87 r
F P
0 g
s
.52281 .56212 m .51369 .56998 L .52149 .57682 L p .745 .766 .87 r
F P
0 g
s
.50529 .57409 m .51369 .56998 L .50288 .56129 L p .554 .599 .853 r
F P
0 g
s
.50288 .56129 m .49931 .56929 L .50529 .57409 L p .554 .599 .853 r
F P
0 g
s
.49931 .56929 m .50288 .56129 L .4933 .55414 L p .421 .443 .778 r
F P
0 g
s
.51731 .54121 m .52523 .53322 L .51559 .52616 L p .665 .398 .508 r
F P
0 g
s
.51559 .52616 m .50529 .53236 L .51731 .54121 L p .665 .398 .508 r
F P
0 g
s
.5325 .57069 m .54045 .5607 L .53079 .55208 L p .833 .765 .787 r
F P
0 g
s
.03 w
.53293 .56072 m
.53471 .56177 L
s
.5 Mabswid
.53602 .54192 m .53079 .55208 L .54045 .5607 L p .9 .739 .673 r
F P
0 g
s
.53079 .55208 m .52281 .56212 L .5325 .57069 L p .833 .765 .787 r
F P
0 g
s
.49732 .54236 m .4933 .55414 L .50288 .56129 L p .539 .44 .691 r
F P
0 g
s
.59203 .44712 m .54193 .51003 L .52952 .50108 L p .608 .425 .609 r
F P
0 g
s
.5026 .50172 m .44501 .45283 L .43616 .45432 L p .329 .576 .931 r
F P
0 g
s
.44501 .45283 m .5026 .50172 L .50495 .50918 L p .828 .353 .026 r
F P
0 g
s
.50838 .60203 m .45818 .66519 L .44782 .65685 L p .833 .765 .787 r
F P
0 g
s
.44782 .65685 m .4983 .59339 L .50838 .60203 L p .833 .765 .787 r
F P
0 g
s
.50931 .55125 m .51731 .54121 L .50529 .53236 L p .608 .425 .609 r
F P
0 g
s
.03 w
.50754 .54571 m
.50822 .54611 L
s
.5 Mabswid
.50529 .53236 m .49732 .54236 L .50931 .55125 L p .608 .425 .609 r
F P
0 g
s
.60577 .4583 m .55574 .52119 L .54193 .51003 L p .73 .599 .709 r
F P
0 g
s
.54193 .51003 m .59203 .44712 L .60577 .4583 L p .73 .599 .709 r
F P
0 g
s
.50288 .56129 m .50931 .55125 L .49732 .54236 L p .539 .44 .691 r
F P
0 g
s
.53079 .55208 m .53602 .54192 L .52523 .53322 L p .784 .579 .623 r
F P
0 g
s
.41733 .4971 m .47577 .54577 L .46677 .54664 L p .305 .568 .931 r
F P
0 g
s
.46677 .54664 m .40859 .4983 L .41733 .4971 L p .305 .568 .931 r
F P
0 g
s
.52523 .53322 m .51731 .54121 L .53079 .55208 L p .784 .579 .623 r
F P
0 g
s
.51369 .56998 m .52281 .56212 L .50931 .55125 L p .667 .606 .778 r
F P
0 g
s
.50931 .55125 m .50288 .56129 L .51369 .56998 L p .667 .606 .778 r
F P
0 g
s
.42183 .63622 m .47221 .573 L .48442 .58225 L p .608 .425 .609 r
F P
0 g
s
.52281 .56212 m .53079 .55208 L .51731 .54121 L p .73 .599 .709 r
F P
0 g
s
.03 w
.51175 .54819 m
.52051 .55338 L
s
.52789 .55774 m
.53293 .56072 L
s
.5268 .5571 m
.52789 .55774 L
s
.5 Mabswid
.51731 .54121 m .50931 .55125 L .52281 .56212 L p .73 .599 .709 r
F P
0 g
s
.48442 .58225 m .43387 .64573 L .42183 .63622 L p .608 .425 .609 r
F P
0 g
s
.57244 .44313 m .56145 .23456 L .54459 .23087 L p .113 .144 .614 r
F P
0 g
s
.4983 .59339 m .44782 .65685 L .43387 .64573 L p .73 .599 .709 r
F P
0 g
s
.43387 .64573 m .48442 .58225 L .4983 .59339 L p .73 .599 .709 r
F P
0 g
s
.50495 .50918 m .44699 .46006 L .44501 .45283 L p .828 .353 .026 r
F P
0 g
s
.44699 .46006 m .50495 .50918 L .49951 .52251 L p .863 .636 .592 r
F P
0 g
s
.02 w
.45595 .50002 m
.49393 .53191 L
s
.5 Mabswid
.70274 .68315 m .60223 .59812 L .57528 .60648 L p .488 .64 .923 r
F P
0 g
s
.42983 .48756 m .48832 .53654 L .47577 .54577 L p .664 .678 .853 r
F P
0 g
s
.47577 .54577 m .41733 .4971 L .42983 .48756 L p .664 .678 .853 r
F P
0 g
s
.61214 .59955 m .57209 .5762 L .55651 .59584 L p .294 .037 .342 r
F P
0 g
s
.57209 .5762 m .61214 .59955 L .61469 .57397 L p .148 .114 .56 r
F P
0 g
s
.61469 .57397 m .57446 .55163 L .57209 .5762 L p .148 .114 .56 r
F P
0 g
s
.59591 .62005 m .55651 .59584 L .53355 .60315 L p .413 0 .043 r
F P
0 g
s
.55651 .59584 m .59591 .62005 L .61214 .59955 L p .294 .037 .342 r
F P
0 g
s
.57446 .55163 m .61469 .57397 L .60254 .55292 L p 0 .203 .73 r
F P
0 g
s
.60254 .55292 m .56266 .53137 L .57446 .55163 L p 0 .203 .73 r
F P
0 g
s
.49951 .52251 m .44121 .47335 L .44699 .46006 L p .863 .636 .592 r
F P
0 g
s
.44121 .47335 m .49951 .52251 L .48832 .53654 L p .78 .675 .748 r
F P
0 g
s
.48832 .53654 m .42983 .48756 L .44121 .47335 L p .78 .675 .748 r
F P
0 g
s
.02 w
.42681 .47555 m
.43436 .48189 L
s
.5 Mabswid
.57209 .62776 m .53355 .60315 L .51184 .59528 L p .444 0 0 r
F P
0 g
s
.53355 .60315 m .57209 .62776 L .59591 .62005 L p .413 0 .043 r
F P
0 g
s
.56266 .53137 m .60254 .55292 L .58016 .54446 L p .377 0 0 r
F P
0 g
s
.58016 .54446 m .54103 .52317 L .56266 .53137 L p .377 0 0 r
F P
0 g
s
.51184 .59528 m .54961 .61966 L .57209 .62776 L p .444 0 0 r
F P
0 g
s
.54961 .61966 m .51184 .59528 L .49972 .57506 L p 0 .157 .698 r
F P
0 g
s
.54103 .52317 m .58016 .54446 L .55604 .552 L p .379 0 0 r
F P
0 g
s
.5178 .53033 m .54103 .52317 L p .552 .54425 L .379 0 0 r
F P
0 g
s
.54238 .54426 m .5178 .53033 L p .552 .54425 L .379 0 0 r
F P
0 g
s
.5178 .53033 m .55604 .552 L .53955 .57275 L p .262 0 .312 r
F P
0 g
s
.53955 .57275 m .50197 .5502 L .5178 .53033 L p .262 0 .312 r
F P
0 g
s
.3972 .45722 m .5011 .5443 L p .5323 .53898 L .488 .64 .923 r
F P
0 g
s
.5011 .5443 m .50589 .54831 L .51728 .54429 L p .488 .64 .923 r
F P
0 g
s
.51728 .54429 m .5323 .53898 L p .5011 .5443 L .488 .64 .923 r
F P
0 g
s
.55604 .552 m .54238 .54426 L p .552 .54425 L .379 0 0 r
F P
0 g
s
.53712 .59866 m .49972 .57506 L .50197 .5502 L p .104 .078 .54 r
F P
0 g
s
.03 w
.54394 .56723 m
.54856 .56996 L
s
.5 Mabswid
.49972 .57506 m .53712 .59866 L .54961 .61966 L p 0 .157 .698 r
F P
0 g
s
.61031 .629 m .75565 .75108 L .78856 .74403 L p .477 .64 .927 r
F P
0 g
s
.03 w
.54856 .56996 m
.55413 .57326 L
s
.5 Mabswid
.50197 .5502 m .53955 .57275 L .53712 .59866 L p .104 .078 .54 r
F P
0 g
s
.78856 .74403 m .64919 .62571 L p .61031 .629 L .477 .64 .927 r
F P
0 g
s
.62357 .62512 m .61031 .629 L p .64919 .62571 L .477 .64 .927 r
F P
0 g
s
.62171 .6359 m .6034 .62465 L p .57884 .63207 L .413 0 .043 r
F P
0 g
s
.6034 .62465 m .60281 .62429 L .60181 .62461 L p .413 0 .043 r
F P
0 g
s
.60181 .62461 m .57884 .63207 L p .6034 .62465 L .413 0 .043 r
F P
0 g
s
.64919 .62571 m .6421 .61969 L .62357 .62512 L p .477 .64 .927 r
F P
0 g
s
.5323 .53898 m .42273 .44629 L .3972 .45722 L p .488 .64 .923 r
F P
0 g
s
.63835 .61484 m .61915 .60364 L .60281 .62429 L p .294 .037 .342 r
F P
0 g
s
.61915 .60364 m .63835 .61484 L .64104 .5886 L p .148 .114 .56 r
F P
0 g
s
.64104 .5886 m .62174 .57789 L .61915 .60364 L p .148 .114 .56 r
F P
0 g
s
.60281 .62429 m .62171 .6359 L .63835 .61484 L p .294 .037 .342 r
F P
0 g
s
.62174 .57789 m .64104 .5886 L .62867 .56704 L p 0 .203 .73 r
F P
0 g
s
.62867 .56704 m .60953 .5567 L .62174 .57789 L p 0 .203 .73 r
F P
0 g
s
.59732 .64387 m .57884 .63207 L .55623 .62392 L p .444 0 0 r
F P
0 g
s
.57884 .63207 m .59732 .64387 L .62171 .6359 L p .413 0 .043 r
F P
0 g
s
.60953 .5567 m .62867 .56704 L .60579 .55841 L p .377 0 0 r
F P
0 g
s
.60579 .55841 m .58701 .54819 L .60953 .5567 L p .377 0 0 r
F P
0 g
s
.55623 .62392 m .57435 .63562 L .59732 .64387 L p .444 0 0 r
F P
0 g
s
.57435 .63562 m .55623 .62392 L .54367 .60279 L p 0 .157 .698 r
F P
0 g
s
.58701 .54819 m .60579 .55841 L .5811 .56621 L p .379 0 0 r
F P
0 g
s
.56274 .5558 m .58701 .54819 L p .58121 .56587 L .379 0 0 r
F P
0 g
s
.5805 .56587 m .56274 .5558 L p .58121 .56587 L .379 0 0 r
F P
0 g
s
.56274 .5558 m .5811 .56621 L .56417 .58753 L p .262 0 .312 r
F P
0 g
s
.56417 .58753 m .54613 .57671 L .56274 .5558 L p .262 0 .312 r
F P
0 g
s
.37995 .43552 m .53484 .56562 L p .57335 .56132 L .477 .64 .927 r
F P
0 g
s
.53484 .56562 m .54214 .57175 L .56008 .56576 L p .477 .64 .927 r
F P
0 g
s
.56008 .56576 m .57335 .56132 L p .53484 .56562 L .477 .64 .927 r
F P
0 g
s
.5811 .56621 m .5805 .56587 L p .58121 .56587 L .379 0 0 r
F P
0 g
s
.56162 .61411 m .54367 .60279 L .54613 .57671 L p .104 .078 .54 r
F P
0 g
s
.54367 .60279 m .56162 .61411 L .57435 .63562 L p 0 .157 .698 r
F P
0 g
s
.54613 .57671 m .56417 .58753 L .56162 .61411 L p .104 .078 .54 r
F P
0 g
s
.64189 .64792 m .65215 .65163 L .60392 .6027 L closepath p .63 .071 0 r
F P
0 g
s
.63628 .63825 m .64189 .64792 L .60392 .6027 L closepath p 0 0 .512 r
F P
0 g
s
.66314 .648 m .67068 .63844 L .60392 .6027 L closepath p .395 .156 .429 r
F P
0 g
s
.65215 .65163 m .66314 .648 L .60392 .6027 L closepath p .52 .106 .195 r
F P
0 g
s
.6375 .62631 m .63628 .63825 L .60392 .6027 L closepath p 0 0 .424 r
F P
0 g
s
.67193 .62657 m .66639 .61688 L .60392 .6027 L closepath p .125 .347 .811 r
F P
0 g
s
.67068 .63844 m .67193 .62657 L .60392 .6027 L closepath p .277 .23 .623 r
F P
0 g
s
.6451 .61669 m .6375 .62631 L .60392 .6027 L closepath p .103 0 .172 r
F P
0 g
s
.66639 .61688 m .65615 .6131 L .60392 .6027 L closepath p 0 .453 .78 r
F P
0 g
s
.65615 .6131 m .6451 .61669 L .60392 .6027 L closepath p .197 0 0 r
F P
0 g
s
.03 w
.56868 .58186 m
.60392 .6027 L
s
.5 Mabswid
.57335 .56132 m .40962 .42232 L .37995 .43552 L p .477 .64 .927 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00W03oool300000840oooo002L0?ooo`030000000L99d072BM00<00000OP3oool009`0oooo
00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1l0?ooo`00W03oool00`00000072BM01`T
W@0201`TW@030000003oool0oooo07`0oooo002L0?ooo`030000000L99d072BM008072BM00<00000
0?ooo`3oool0O03oool009`0oooo00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1l0?oo
o`00W03oool00`00000072BM01`TW@0201`TW@030000003oool0oooo07`0oooo002L0?ooo`030000
000L99d072BM008072BM00<000000?ooo`3oool0O03oool009`0oooo00<000000?ooo`0L99d00P0L
99d00`000000oooo0?ooo`1l0?ooo`00W03oool00`00000072BM01`TW@0201`TW@030000003oool0
oooo07`0oooo002M0?ooo`@072BM00<000000?ooo`3oool0O03oool009d0oooo00D0000001`TW@0L
99d072BM0000001n0?ooo`00W@3oool00`00000072BM01`TW@0201`TW@030000003oool0oooo07/0
oooo002M0?ooo`030000000L99d072BM008072BM00<000000?ooo`3oool0N`3oool009d0oooo00<0
000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1k0?ooo`00W@3oool00`00000072BM01`TW@02
01`TW@030000003oool0oooo07/0oooo002M0?ooo`030000003oool072BM008072BM00<000000?oo
o`3oool0N`3oool009d0oooo00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1k0?ooo`00
W@3oool00`00000072BM01`TW@0201`TW@030000003oool0oooo07/0oooo002M0?ooo`030000000L
99d072BM008072BM00<000000?ooo`3oool0N`3oool009d0oooo00<0000001`TW@0L99d00P0L99d0
0`000000oooo0?ooo`1k0?ooo`00W@3oool00`00000072BM01`TW@0201`TW@030000003oool0oooo
07/0oooo002M0?ooo`030000000L99d072BM008072BM00<000000?ooo`3oool0N`3oool009d0oooo
00<0000001`TW@3oool00P0L99d00`000000oooo0?ooo`1k0?ooo`00W@3oool00`00000072BM0?oo
o`0201`TW@030000003oool0oooo07/0oooo002M0?ooo`030000000L99d072BM008072BM00<00000
0?ooo`3oool0N`3oool009d0oooo00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1k0?oo
o`00W@3oool00`00000072BM01`TW@0201`TW@030000003oool0oooo07/0oooo002M0?ooo`030000
000L99d072BM008072BM00<000000?ooo`3oool0N`3oool009d0oooo00<0000001`TW@0L99d00P0L
99d00`000000oooo0?ooo`1k0?ooo`00WP3oool01@00000072BM01`TW@0L99d0000007d0oooo002N
0?ooo`050000000L99d0oooo01`TW@000000O@3oool009h0oooo00<0000001`TW@3oool00P0L99d0
0`000000oooo0?ooo`1j0?ooo`00WP3oool00`00000072BM01`TW@0201`TW@030000003oool0oooo
07X0oooo002N0?ooo`030000000L99d072BM008072BM00<000000?ooo`3oool0NP3oool009h0oooo
00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1j0?ooo`00WP3oool00`00000072BM01`T
W@0201`TW@030000003oool0oooo07X0oooo002N0?ooo`030000000L99d072BM008072BM00<00000
0?ooo`3oool0NP3oool009h0oooo00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1j0?oo
o`00WP3oool01P00000072BM01`TW@3oool072BM000007`0oooo002N0?ooo`060000000L99d072BM
0?ooo`0L99d00000O03oool009h0oooo00<0000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1j
0?ooo`00WP3oool00`00000072BM01`TW@0201`TW@030000003oool0oooo07X0oooo002N0?ooo`03
0000000L99d072BM008072BM00<000000?ooo`3oool0NP3oool009h0oooo00<0000001`TW@0L99d0
0P0L99d00`000000oooo0?ooo`1j0?ooo`00WP3oool00`00000072BM01`TW@0201`TW@030000003o
ool0oooo07X0oooo002N0?ooo`060000000L99d072BM01`TW@3oool00000O03oool009h0oooo00H0
000001`TW@0L99d072BM0?ooo`00001l0?ooo`00WP3oool01P00000072BM01`TW@0L99d0oooo0000
07`0oooo002N0?ooo`030000000L99d072BM008072BM00<000000?ooo`3oool0NP3oool009l0oooo
00D0000001`TW@0L99d072BM0000001l0?ooo`00W`3oool01@00000072BM01`TW@0L99d0000007`0
oooo002O0?ooo`030000000L99d072BM008072BM00<000000?ooo`3oool0N@3oool009l0oooo00<0
000001`TW@0L99d00P0L99d00`000000oooo0?ooo`1i0?ooo`00W`3oool01P00000072BM01`TW@0L
99d0oooo000007/0oooo001d0?ooo`800000:@3oool01P00000072BM01`TW@0L99d0oooo000007/0
oooo001b0?ooo`8000000P1jXnd00`000000oooo0?ooo`0V0?ooo`060000000L99d072BM01`TW@3o
ool00000N`3oool00700oooo0P00000507ZSk@030000003oool0oooo02D0oooo00<0000001`TW@0L
99d00P0L99d00`000000oooo0?ooo`1i0?ooo`00KP3oool2000000P0NZ?]0P00000U0?ooo`030000
000L99d072BM008072BM00<000000?ooo`3oool0N@3oool006d0oooo00<0000007ZSk@1jXnd02P1j
Xnd00`000000oooo0?ooo`0R0?ooo`8000000`0L99d3000007T0oooo001^0?ooo`030000001jXnd0
NZ?]00X0NZ?]00<000000?ooo`3oool08`3oool20000000501`TW@000000000009]/V`000000N03o
ool006l0oooo00<0000007ZSk@1jXnd02P1jXnd00`000000oooo0?ooo`0S0?ooo`<000000`2KK9/0
0`000000oooo0?ooo`1e0?ooo`00L03oool2000000/0NZ?]00<000000?ooo`3oool08P3oool00`00
0000A05A0000000409]/V`030000003oool0oooo07@0oooo001b0?ooo`030000001jXnd0NZ?]00T0
NZ?]0P00000Q0?ooo`03000000140E40000000@0VfbK00<000000;ZI]@000000M@3oool007<0oooo
00<0000007ZSk@1jXnd02@1jXnd2000001l0oooo00<0000004@1D@000000102KK9/010000000^YVe
0;ZI]@2jVKD200000340oooo1@00000m0?ooo`00LP3oool3000000`0NZ?]00<000000?ooo`3oool0
6`3oool00`000000A05A0000000509]/V`030000002jVKD0^YVe00<0^YVe00<000000?ooo`3oool0
9P3oool8000000D0H`000`00000j0?ooo`00L`3oool00`000000O:?/0000000<07ZSk@030000003o
ool0oooo01T0oooo00<0000004@1D@0000001@2KK9/00`000000^YVe0;ZI]@030;ZI]@030000003E
`lT000000200oooo1`00000>06<000@00000>03oool007@0oooo00@0000007bSk000000000002`1j
Xnd2000001P0oooo00<0000004@1D@0000001@2KK9/00`000000^YVe0;ZI]@030;ZI]@050000003E
`lT0eL?90=G3b@0000005`3oool8000000d0H`0000<0000006<0000000001@00000l0?ooo`00M@3o
ool20000000307bSk0000000NZ?]00X0NZ?]0P00000G0?ooo`03000000140E40000000@0VfbK00<0
00000;ZI]@2jVKD0102jVKD00`000000eL?90=G3b@020=G3b@030000003oool0oooo00d0oooo1`00
000906<00080oooo0`1S0007000004@0oooo001g0?ooo`030000001lXn`0000000/0NZ?]0P00000E
0?ooo`03000000140E40000000D0VfbK00<000000;ZI]@2jVKD00`2jVKD00`000000eL?90=G3b@02
0=G3b@030000003Mo/<0000000L0oooo1`00000506<000<0oooo1@1S0008000004/0oooo001g0?oo
o`80000000<0O:?/0000001jXnd02`1jXnd00`000000oooo0?ooo`0A0?ooo`03000000140E400000
00D0VfbK00<000000;ZI]@2jVKD00`2jVKD00`000000eL?90=G3b@020=G3b@030000003Mo/<0gOk3
00P00000103oool806<000P00000D`3oool007H0oooo00H000000<N/_`000000000007bSk000000<
07ZSk@030000003oool0oooo00l0oooo00<0000004@1D@0000001@2KK9/00`000000^YVe0;ZI]@03
0;ZI]@030000003E`lT0eL?900<0eL?900@000000=gn``000000oooo301S0007000005/0oooo001e
0?ooo`040000003KXYP000000<N/_`80000000<0O:?/0000000000002`1jXnd00`000000oooo0?oo
o`0=0?ooo`03000000140E40000000D0VfbK00<000000;ZI]@2jVKD0102jVKD00`000000eL?90=G3
b@020=G3b@040000003Mo/<00000000000D0H`002000001R0?ooo`00M@3oool00`000000fj:H0=^R
V00400000080O:?/00<0000007ZSk@1jXnd02@1jXnd00`000000oooo0?ooo`0;0?ooo`0300000014
0E40000000D0VfbK00<000000;ZI]@2jVKD0102jVKD00`000000eL?90=G3b@020=G3b@030000003M
o/<000000080oooo1@00001Z0?ooo`00M03oool00`000000fj:H0=^RV0020=^RV0D0000000<0O:?/
0000001jXnd02P1jXnd2000000/0oooo0P140E400`000000VfbK09]/V`0309]/V`030000002jVKD0
^YVe00<0^YVe00<000000=G3b@3E`lT00P3E`lT00`000000gOk30000001b0?ooo`00M03oool20000
0080fj:H00@000000:V]fP2Y[MX0ZJgJ0`0000000`1lXn`0000007ZSk@0:07ZSk@8000002@3oool2
04@1D@030000002KK9/0VfbK00<0VfbK00<000000;ZI]@2jVKD00`2jVKD00`000000eL?90=G3b@03
0=G3b@800000L`3oool007D0oooo0`0000070:V]fP030000001lXn`0000000`0NZ?]00<000000?oo
o`3oool01@3oool00`000000A05A0000000509]/V`030000002jVKD0^YVe00<0^YVe00<000000=G3
b@3E`lT00`3E`lT2000007@0oooo001e0?ooo`040000001>TNh0CY7^000000L0ZJgJ00<0000007bS
k0000000301jXnd00`000000oooo0?ooo`040?ooo`8000001@2KK9/00`000000^YVe0;ZI]@040;ZI
]@030000003E`lT0eL?90080eL?90P00001e0?ooo`00MP3oool00`000000CY7^04jAkP02000000H0
ZJgJ00@0000007bSk000000000002`1jXnd00`000000oooo0?ooo`040?ooo`800000102KK9/00`00
0000^YVe0;ZI]@030;ZI]@030000003E`lT0eL?90080eL?900<000000=gn``000000M@3oool007L0
oooo0P00000204jAkP030000002Y[MX0ZJgJ00@0ZJgJ00@0000007bSk01lXn`000002`1jXnd00`00
0000oooo0?ooo`040?ooo`<0000000<0VfbK0000002jVKD0102jVKD00`000000eL?90=G3b@020=G3
b@030000003Mo/<0000007H0oooo001i0?ooo`040000001>TNh0CY7^000000H0ZJgJ00@0000007bS
k01lXn`000002`1jXnd00`000000oooo0?ooo`040?ooo`030000002jVKD0000000D0^YVe00<00000
0=G3b@3E`lT00`3E`lT2000007L0oooo001j0?ooo`040000001>TNh0CY7^000000H0ZJgJ0P000000
0`1lXn`0000007ZSk@0:07ZSk@8000001@3oool3000000@0^YVe00<000000=G3b@3E`lT00P3E`lT2
000007P0oooo001k0?ooo`040000001>TNh0CY7^000000L0ZJgJ00<0000007bSk0000000301jXnd0
0`000000oooo0?ooo`030?ooo`@0000000<0^YVe0000003E`lT00`3E`lT2000007T0oooo001l0?oo
o`030000001>TNh0CY7^008000001P2Y[MX010000000O:?/00000000000;07ZSk@040000003oool0
oooo0?ooo`80000000@0oooo0000002LKI`00000103E`lT2000007X0oooo001m0?ooo`8000000P1>
TNh00`000000ZJgJ0:V]fP040:V]fP040000001lXn`0O:?/000000/0NZ?]00<000000?ooo`000000
0`000000103oool0000009a]W00000030=G3b@800000NP3oool007l0oooo00@0000004jAkP1>TNh0
00001P2Y[MX010000000O:?/07bSk000000;07ZSk@8000000P1Q0006000000030=G3b@0000000000
07/0oooo00200?ooo`040000001>TNh0CY7^000000H0ZJgJ00@0000007bSk01lXn`000002`1jXnd2
000000<0H@001P00001l0?ooo`00P@3oool010000000CY7^04jAkP0000060:V]fP80000000<0O:?/
0000001jXnd02`1jXnd00`000000H@000640000206400080000000<0H0000000003oool0N`3oool0
0880oooo0P0000000`1>TNh00000000000030:V]fP@0000000<0O:?/0000000000002`1jXnd00`00
0000H@0006400003064000@00000NP3oool008@0oooo00D0000004jAkP1>TNh000000:V]fP060000
0080O:?/00<0000007ZSk@1jXnd02@1jXnd00`000000H@0006400004064000@00000N03oool008D0
oooo100000040?ooo`8000000`1lXn`00`000000NZ?]07ZSk@0907ZSk@030000001Q0000H@0000@0
H@001@00001f0?ooo`00S03oool8000000/0NZ?]00<000000640000000000`000002000c^PD00000
M03oool008`0oooo1`0000000`1304l0000007ZSk@0:07ZSk@80000000<0oooo0000000000000P00
0002064000@00000L`3oool008`0oooo1@00000201XCRP040000001304l00000000000/0NZ?]00<0
00000640001Q00001P1Q000400000740oooo002<0?ooo`D000000`0J4hX010000000@`1?04<0C`00
000;07ZSk@030000001Q0000H@0000H0H@001@00001_0?ooo`00S@3oool010000000Jg7706]aa`00
000401XCRP80000000<0@`1?0000001jXnd0201jXnd400000080H@0010000002000c^PD00000K@3o
ool008d0oooo00<0000006]aa`0000001`0J4hX2000000L0NZ?]1@0000000`1304l0000000000003
02DMS`8000000P00<kX20000008003>j0P00001[0?ooo`00Q@3oool00`000000oooo0?ooo`060?oo
o`800000200J4hX300000080NZ?]0P00000204<0C`D000001`0U7Hl3000000050?ooo`00000003>j
000c^P000000J`3oool008@0oooo00@0000004@1D@00000000001P3oool2000000X06Q>:10000002
04<0C`P000001`0U7Hl3000000<003>j00<000000?ooo`3oool0J03oool008<0oooo00H0000004@1
D@140E40000009]/V`0000040?ooo`<000002P0J4hX300000080@`1?2`00000602DMS`030000003o
ool00000008003>j00<000000?ooo`3oool0J03oool008<0oooo00<0000004@1D@0000000`2KK9/2
00000080oooo0P0000000`3oool000000000000801XCRQ4000001@0U7Hl00`000000oooo00000002
00000003000c^P000000oooo06P0oooo00220?ooo`04000000140E40A05A000000D0VfbK0`000002
0?ooo`0400000000:;800000000000H06Q>:00@000000?ooo`0000006Q>:3`00000302DMS`030000
003oool0000000809Af?0P00001Y0?ooo`00P@3oool010000000A05A04@1D@00000509]/V`040000
002jVKD00000000000<0oooo00<00000000X/P00:;800P00000401XCRP<000000P0J4hX@00000004
02DMS`000000oooo000000@09Af?00<000000?ooo`3oool0IP3oool00800oooo00@0000004@1D@14
0E4000001@2KK9/010000000^YVe0;ZI]@2jVKD200000080oooo00<00000000X/P00:;800P00:;82
000000806Q>:0`00000401XCRPl000000P3oool00`0000009Af?02DMS`0202DMS`030000003oool0
oooo06H0oooo00200?ooo`03000000140E40000000H0VfbK00<000000;ZI]@2jVKD00`2jVKD01000
0000oooo0?ooo`000005000X/P<0000000<0fj:H0000000J4hX00`0J4hXA000000D09Af?00<00000
0?ooo`3oool0IP3oool007l0oooo00@0000004@1D@140E4000001@2KK9/00`000000^YVe0;ZI]@03
0;ZI]@030000003E`lT000000080oooo0P000005000X/P030000003KXYP0000000@06Q>:00<00000
04/9E`1;2EL03`00000402DMS`030000003oool0oooo06H0oooo001n0?ooo`04000000140E40A05A
000000D0VfbK00<000000;ZI]@2jVKD00`2jVKD01@000000eL?90=G3b@3E`lT0000000<0oooo00<0
0000000X/P00:;800P00:;83000000@06Q>:00<0000004/9E`1;2EL00P1;2EL<000000D09Af?00<0
00000?ooo`3oool0IP3oool007d0oooo00@0000004@1D@140E4000001@2KK9/00`000000^YVe0;ZI
]@040;ZI]@060000003E`lT0eL?90000003Mo/<000000`3oool2000000<002Rb0P00000401XCRP<0
00000`1;2EL>000000809Af?00<000000?ooo`3oool0IP3oool007`0oooo00@0000004@1D@140E40
00001@2KK9/00`000000^YVe0;ZI]@040;ZI]@040000003E`lT0eL?900000080gOk31P3oool20000
0003000X/P0000000000008000000P0J4hX00`000000J@0;06T02`02000000<0B`UG200000000`0J
02`0000000000006000006H0oooo001l0?ooo`03000000140E40000000D0VfbK00<000000;ZI]@2j
VKD0102jVKD01P000000eL?90=G3b@3E`lT000000=gn``T0oooo00D00000000X/P0000000000000X
/P03000000@0J@0;0P00000304/9E`D0000000<0001/0000000J02`00P0J02`300000080<P000`00
001S0?ooo`00N`3oool010000000A05A04@1D@00000509]/V`030000002jVKD0^YVe00<0^YVe00L0
00000=G3b@3E`lT0eL?90000003Mo/<0000000X0oooo0`000003000X/P030000001Y00/0J@0;00@0
J@0;0P00000204/9E`D0000000<0001/0000000J02`0100J02`700000640oooo001j0?ooo`040000
00140E40A05A000000D0VfbK00<000000;ZI]@2jVKD00`2jVKD01`000000eL?90=G3b@3E`lT00000
0=gn``0000003@3oool20000008002Rb00<0000006T02`1Y00/01P1Y00/200000080O:?/00D00000
04/9E`1;2EL000000000K002000000<06P0/00@0000004HjW`00000000000P0OF<l200000600oooo
001i0?ooo`04000000140E40A05A000000D0VfbK00<000000;ZI]@2jVKD00`2jVKD01`000000eL?9
0=G3b@3E`lT000000=gn``0000003`3oool01@00000002Rb000X/P00:;80000000D0J@0;0`000002
07bSk0030000001;2EL0B`UG0080B`UG00D000000000K00006`0000001X0;002000000<0ASZO1000
001P0?ooo`00N@3oool204@1D@030000002KK9/0VfbK00<0VfbK00<000000;ZI]@2jVKD0102jVKD0
10000000eL?90=G3b@3E`lT200000140oooo00<00000000X/P00:;800P00000206T02`8000000P2Y
[MX3000000H0B`UG00@000000000K00006`000000P1U9fd00`000000ASZO04HjW`0304HjW`800000
G`3oool007P0oooo0`140E400`000000VfbK09]/V`0209]/V`030000002jVKD0^YVe00@0^YVe00L0
00000=G3b@3E`lT0eL?90000003Mo/<000000180oooo0P0000001000:;8000000000000000020:V]
fP<000000P1Y00/2000000D0B`UG00<000000000K00000000P0000000`1U9fd000000000000404Hj
W`030000003oool0oooo05d0oooo001g0?ooo`04000000140E40A05A000000@0VfbK00<000000;ZI
]@2jVKD0102jVKD01`000000eL?90=G3b@3E`lT000000=gn``0000005@3oool20000000407400000
00000000000000L0J@0;0P00000204/9E`80000000D0001/000000256c40QA/a0000000206DWK@80
00000P16>Yl00`000000oooo0?ooo`1M0?ooo`00N03oool2000000D0VfbK00<000000;ZI]@2jVKD0
0`2jVKD01`000000eL?90=G3b@3E`lT000000=gn``000000603oool2000000030740000000000000
00P0J@0;0P00000207ZSk@8000000`256c4010000000IBM]06DWK@1U9fd3000005l0oooo001i0?oo
o`8000000`2KK9/00`000000^YVe0;ZI]@030;ZI]@070000003E`lT0eL?90=G3b@000000gOk30000
000J0?ooo`H000000P1Y00/40000000307bSk000000000000080NZ?]0P00000308DK<@8000000`1U
9fd00`000000oooo0?ooo`1M0?ooo`00N`3oool00`000000VfbK000000050;ZI]@030000003E`lT0
eL?90080eL?90P00000M0?ooo`030000001>TNh0000000<000000`2Y[MX200000080O:?/00<00000
07ZSk@1jXnd00P00000408DK<@040000001U9fd00000000005l0oooo001l0?ooo`030000002jVKD0
^YVe00@0^YVe00L000000=G3b@3E`lT0eL?90000003Mo/<0000001h0oooo00@0000004jAkP000000
00001@2Y[MX200000080O:?/00<0000007ZSk@1jXnd00P00000408DK<@040000001jXnd0NZ?]0000
05h0oooo001l0?ooo`800000102jVKD01`000000eL?90=G3b@3E`lT000000=gn``000000803oool0
10000000CY7^04jAkP0000050:V]fP8000000P1lXn`00`000000NZ?]07ZSk@020000000308DK<@00
0000000000@0NZ?]00<000000?ooo`3oool0F`3oool007`0oooo100000000`2jVKD000000=G3b@02
0=G3b@030000003Mo/<000000280oooo0P0000000`1>TNh000000:V]fP040:V]fP8000000P1lXn`0
1@000000NZ?]07ZSk@1jXnd0000000L0NZ?]00<000000?ooo`3oool0FP3oool007/0oooo0P000003
0?ooo`030000003E`lT0eL?90080eL?90P00000U0?ooo`030000001>TNh0000000H0ZJgJ00@00000
07bSk01lXn`000002`1jXnd2000005X0oooo001j0?ooo`8000001@3oool2000000040=G3b@000000
gOk3000002H0oooo00<0000004jAkP0000001P2Y[MX20000000307bSk0000000000000/0NZ?]00<0
00000?ooo`3oool0E`3oool007T0oooo0`0000060?ooo`80000000<0gOk30000003oool09`3oool4
000000@0ZJgJ0`00000207bSk0030000001jXnd0NZ?]00T0NZ?]00<000000?ooo`3oool0EP3oool0
07P0oooo0`0000080?ooo`800000:`3oool010000000CY7^0000002Y[MX200000080oooo0P000002
07bSk0030000001jXnd0NZ?]00T0NZ?]00<000000?ooo`3oool0E@3oool007L0oooo0`00000g0?oo
o`<000001@3oool200000080O:?/00<0000007ZSk@1jXnd02@1jXnd00`000000oooo0?ooo`1D0?oo
o`00M`3oool200000440oooo0P00000207bSk0030000001jXnd0NZ?]00T0NZ?]0P00001D0?ooo`00
MP3oool2000004@0oooo00@0000007bSk01lXn`00000301jXnd00`000000oooo0?ooo`1A0?ooo`00
M@3oool3000004D0oooo0P0000000`1lXn`000000000000;07ZSk@030000003oool0oooo0500oooo
001d0?ooo`<00000A`3oool200000080O:?/00<0000007ZSk@1jXnd02@1jXnd00`000000oooo0?oo
o`1?0?ooo`00M@3oool00`000000oooo0?ooo`170?ooo`8000000P1lXn`00`000000NZ?]07ZSk@09
07ZSk@030000003oool0oooo04h0oooo00300?ooo`<0000000<0oooo0000001jXnd02P1jXnd00`00
0000oooo0?ooo`1=0?ooo`00a@3oool00`000000NZ?]07ZSk@0907ZSk@800000C@3oool00<H0oooo
0P00000;07ZSk@030000003oool0oooo04X0oooo00380?ooo`030000001jXnd0NZ?]00T0NZ?]00<0
00000?ooo`3oool0B@3oool00<T0oooo00<0000007ZSk@1jXnd02@1jXnd00`000000oooo0?ooo`18
0?ooo`00bP3oool00`000000NZ?]07ZSk@0907ZSk@030000003oool0oooo04L0oooo003;0?ooo`03
0000001jXnd0NZ?]00T0NZ?]00<000000?ooo`3oool0AP3oool00<`0oooo00<0000007ZSk@1jXnd0
2@1jXnd2000004H0oooo003=0?ooo`8000002`1jXnd00`000000oooo0?ooo`130?ooo`00c`3oool0
0`000000NZ?]07ZSk@0907ZSk@030000003oool0oooo0480oooo003@0?ooo`030000001jXnd0NZ?]
00T0NZ?]00<000000?ooo`3oool0@@3oool00=40oooo00<0000007ZSk@1jXnd02@1jXnd00`000000
oooo0?ooo`100?ooo`00dP3oool00`000000NZ?]07ZSk@0907ZSk@800000@03oool00=<0oooo00<0
000007ZSk@1jXnd02P1jXnd00`000000oooo0?ooo`0m0?ooo`00e03oool2000000/0NZ?]00<00000
0?ooo`3oool0?03oool00=H0oooo00<0000007ZSk@1jXnd01`1jXnd3000003d0oooo003G0?ooo`04
0000001jXnd0NZ?]07ZSk@D00000@03oool00=P0oooo0`0000150?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.57337 .50519 m .66307 .52972 L .69618 .54527 L p .45 0 0 r
F P
0 g
s
.58923 .49871 m .57776 .48618 L p .56614 .50387 L .787 .571 .608 r
F P
0 g
s
.54101 .54214 m .5782 .50864 L p .56614 .50387 L .787 .571 .608 r
F P
0 g
s
.69618 .54527 m .6173 .52412 L p .57337 .50519 L .45 0 0 r
F P
0 g
s
.59297 .51449 m .57337 .50519 L p .6173 .52412 L .45 0 0 r
F P
0 g
s
.5782 .50864 m .58923 .49871 L p .56614 .50387 L .787 .571 .608 r
F P
0 g
s
.6173 .52412 m .60803 .52163 L .59297 .51449 L p .45 0 0 r
F P
0 g
s
.52354 .57303 m .53273 .65116 L .54827 .65454 L p .565 .619 .865 r
F P
0 g
s
.50694 .57708 m .51667 .65515 L .53273 .65116 L p .75 .756 .857 r
F P
0 g
s
.53273 .65116 m .52354 .57303 L .50694 .57708 L p .75 .756 .857 r
F P
0 g
s
.49598 .58697 m .50609 .66503 L .51667 .65515 L p .913 .858 .773 r
F P
0 g
s
.51667 .65515 m .50694 .57708 L .49598 .58697 L p .913 .858 .773 r
F P
0 g
s
.54827 .65454 m .53956 .57633 L .52354 .57303 L p .565 .619 .865 r
F P
0 g
s
.53956 .57633 m .54827 .65454 L .55743 .66405 L p .171 .298 .753 r
F P
0 g
s
.49485 .59903 m .50505 .67712 L .50609 .66503 L p .914 .734 .239 r
F P
0 g
s
.50609 .66503 m .49598 .58697 L .49485 .59903 L p .914 .734 .239 r
F P
0 g
s
.55743 .66405 m .54898 .58577 L .53956 .57633 L p .171 .298 .753 r
F P
0 g
s
.54898 .58577 m .55743 .66405 L .55666 .67616 L p .883 .708 .191 r
F P
0 g
s
.50413 .60866 m .51408 .68681 L .50505 .67712 L p .14 .28 .746 r
F P
0 g
s
.50505 .67712 m .49485 .59903 L .50413 .60866 L p .14 .28 .746 r
F P
0 g
s
.55666 .67616 m .54814 .59785 L .54898 .58577 L p .883 .708 .191 r
F P
0 g
s
.54814 .59785 m .55666 .67616 L .54612 .68623 L p .918 .865 .773 r
F P
0 g
s
.52035 .61209 m .5298 .69032 L .51408 .68681 L p .559 .619 .869 r
F P
0 g
s
.51408 .68681 m .50413 .60866 L .52035 .61209 L p .559 .619 .869 r
F P
0 g
s
.54612 .68623 m .53721 .60794 L .54814 .59785 L p .918 .865 .773 r
F P
0 g
s
.53721 .60794 m .54612 .68623 L .5298 .69032 L p .751 .761 .861 r
F P
0 g
s
.02 w
.53352 .68939 m
.53572 .70783 L
s
.5 Mabswid
.5298 .69032 m .52035 .61209 L .53721 .60794 L p .751 .761 .861 r
F P
0 g
s
.52934 .52937 m .57776 .48618 L .57251 .47208 L p .877 .748 .716 r
F P
0 g
s
.57776 .48618 m .52934 .52937 L .54101 .54214 L p .787 .571 .608 r
F P
0 g
s
.58923 .49871 m .54101 .54214 L .55448 .54873 L p .649 .357 .463 r
F P
0 g
s
.55448 .54873 m .60264 .50503 L .58923 .49871 L p .649 .357 .463 r
F P
0 g
s
.42034 .49835 m .41563 .5074 L .4952 .54051 L closepath p .545 .379 .607 r
F P
0 g
s
.42129 .48934 m .42034 .49835 L .4952 .54051 L closepath p .438 .422 .744 r
F P
0 g
s
.41563 .5074 m .40893 .51309 L .4952 .54051 L closepath p .594 .278 .404 r
F P
0 g
s
.41809 .48378 m .42129 .48934 L .4952 .54051 L closepath p .034 .36 .832 r
F P
0 g
s
.40893 .51309 m .40276 .51324 L .4952 .54051 L closepath p .459 0 0 r
F P
0 g
s
.52382 .51518 m .57251 .47208 L .5755 .46171 L p .896 .98 .808 r
F P
0 g
s
.57251 .47208 m .52382 .51518 L .52934 .52937 L p .877 .748 .716 r
F P
0 g
s
.58068 .62518 m .59021 .72379 L .6296 .72621 L p .631 .676 .875 r
F P
0 g
s
.60264 .50503 m .55448 .54873 L .5647 .5466 L p .191 0 .033 r
F P
0 g
s
.5647 .5466 m .61297 .50268 L .60264 .50503 L p .191 0 .033 r
F P
0 g
s
.6296 .72621 m .62209 .63202 L p .58068 .62518 L .631 .676 .875 r
F P
0 g
s
.60385 .62642 m .58068 .62518 L p .62209 .63202 L .631 .676 .875 r
F P
0 g
s
.63905 .6498 m .57585 .61783 L p .54302 .60938 L .632 .104 0 r
F P
0 g
s
.57585 .61783 m .55674 .60816 L .54714 .60901 L p .632 .104 0 r
F P
0 g
s
.54714 .60901 m .54302 .60938 L p .57585 .61783 L .632 .104 0 r
F P
0 g
s
.62209 .63202 m .62172 .62738 L .60385 .62642 L p .631 .676 .875 r
F P
0 g
s
.41193 .48383 m .41809 .48378 L .4952 .54051 L closepath p .726 .241 .091 r
F P
0 g
s
.40276 .51324 m .39949 .50775 L .4952 .54051 L closepath p .355 .592 .935 r
F P
0 g
s
.65662 .66317 m .66586 .80237 L .71007 .80533 L p .628 .678 .878 r
F P
0 g
s
.5755 .46171 m .52657 .50488 L .52382 .51518 L p .896 .98 .808 r
F P
0 g
s
.5755 .46171 m .58572 .45909 L p .5701 .47118 L .155 0 0 r
F P
0 g
s
.53668 .50248 m .58572 .45909 L .59933 .46535 L p .646 .349 .454 r
F P
0 g
s
.58572 .45909 m .53668 .50248 L .52657 .50488 L p .155 0 0 r
F P
0 g
s
.64714 .26571 m .56841 .45297 L .58838 .46216 L p .577 .449 .669 r
F P
0 g
s
.55034 .50902 m .59933 .46535 L .61102 .47813 L p .789 .571 .605 r
F P
0 g
s
.59933 .46535 m .55034 .50902 L .53668 .50248 L p .646 .349 .454 r
F P
0 g
s
.58838 .46216 m .60374 .46924 L p .60723 .45287 L .577 .449 .669 r
F P
0 g
s
.60723 .45287 m .64714 .26571 L .58838 .46216 L .577 .449 .669 r
F
.52657 .50488 m .55801 .47714 L p .5701 .47118 L .155 0 0 r
F P
0 g
s
.55801 .47714 m .5755 .46171 L p .5701 .47118 L .155 0 0 r
F P
0 g
s
.61297 .50268 m .5647 .5466 L .56772 .53643 L p .891 .986 .799 r
F P
0 g
s
.56772 .53643 m .61622 .49243 L .61297 .50268 L p .891 .986 .799 r
F P
0 g
s
.40516 .48951 m .41193 .48383 L .4952 .54051 L closepath p .689 .415 .502 r
F P
0 g
s
.71007 .80533 m .70386 .67272 L p .65662 .66317 L .628 .678 .878 r
F P
0 g
s
.67634 .66428 m .65662 .66317 L p .70386 .67272 L .628 .678 .878 r
F P
0 g
s
.69126 .67622 m .65434 .65754 L p .63992 .65864 L .632 .104 0 r
F P
0 g
s
.65434 .65754 m .65314 .65693 L .65259 .65701 L p .632 .104 0 r
F P
0 g
s
.65259 .65701 m .63992 .65864 L p .65434 .65754 L .632 .104 0 r
F P
0 g
s
.70386 .67272 m .70354 .66582 L .67634 .66428 L p .628 .678 .878 r
F P
0 g
s
.39949 .50775 m .4004 .49867 L .4952 .54051 L closepath p .554 .53 .783 r
F P
0 g
s
.4004 .49867 m .40516 .48951 L .4952 .54051 L closepath p .628 .476 .656 r
F P
0 g
s
.61622 .49243 m .56772 .53643 L .56224 .52204 L p .881 .752 .715 r
F P
0 g
s
.56224 .52204 m .61102 .47813 L .61622 .49243 L p .881 .752 .715 r
F P
0 g
s
.61102 .47813 m .56224 .52204 L .55034 .50902 L p .789 .571 .605 r
F P
0 g
s
.49976 .53722 m .51117 .5329 L .51556 .54404 L p .786 .712 .782 r
F P
0 g
s
.51556 .54404 m .50529 .55111 L .49976 .53722 L p .786 .712 .782 r
F P
0 g
s
.52614 .5384 m .51556 .54404 L .51117 .5329 L p .689 .664 .82 r
F P
0 g
s
.50529 .55111 m .51556 .54404 L .52476 .55411 L p .724 .575 .686 r
F P
0 g
s
.02 w
.5202 .57761 m
.52419 .61115 L
s
.5 Mabswid
.51556 .54404 m .52614 .5384 L .53125 .544 L p .652 .568 .747 r
F P
0 g
s
.53125 .544 m .52476 .55411 L .51556 .54404 L p .652 .568 .747 r
F P
0 g
s
.52476 .55411 m .51676 .56367 L .50529 .55111 L p .724 .575 .686 r
F P
0 g
s
.51676 .56367 m .52476 .55411 L .53532 .55934 L p .612 .415 .591 r
F P
0 g
s
.02 w
.5196 .57263 m
.5202 .57761 L
s
.5 Mabswid
.52476 .55411 m .53125 .544 L .53712 .54688 L p .565 .454 .686 r
F P
0 g
s
.53712 .54688 m .53532 .55934 L .52476 .55411 L p .565 .454 .686 r
F P
0 g
s
.60374 .46924 m .68359 .28025 L .64714 .26571 L p .577 .449 .669 r
F P
0 g
s
.49172 .54434 m .49976 .53722 L .50529 .55111 L p .877 .748 .716 r
F P
0 g
s
.50529 .55111 m .49729 .55824 L .49172 .54434 L p .877 .748 .716 r
F P
0 g
s
.49729 .55824 m .50529 .55111 L .51676 .56367 L p .787 .571 .608 r
F P
0 g
s
.51676 .56367 m .5088 .57084 L .49729 .55824 L p .787 .571 .608 r
F P
0 g
s
.5088 .57084 m .51676 .56367 L .52992 .57024 L p .649 .357 .463 r
F P
0 g
s
.53532 .55934 m .52992 .57024 L .51676 .56367 L p .612 .415 .591 r
F P
0 g
s
.52614 .5384 m .52372 .53221 L p .54278 .54153 L .42 .505 .84 r
F P
0 g
s
.53125 .544 m .52614 .5384 L p .54278 .54153 L .42 .505 .84 r
F P
0 g
s
.51117 .5329 m .52372 .53221 L .52614 .5384 L p .689 .664 .82 r
F P
0 g
s
.53712 .54688 m .53125 .544 L p .54278 .54153 L .42 .505 .84 r
F P
0 g
s
.50233 .52723 m .51327 .52489 L .51117 .5329 L p .785 .881 .916 r
F P
0 g
s
.51117 .5329 m .49976 .53722 L .50233 .52723 L p .785 .881 .916 r
F P
0 g
s
.52372 .53221 m .51117 .5329 L .51327 .52489 L p .657 .752 .92 r
F P
0 g
s
.52992 .57024 m .53532 .55934 L .54327 .55772 L p .32 .098 .412 r
F P
0 g
s
.53532 .55934 m .53712 .54688 L .54153 .54595 L p .377 .284 .621 r
F P
0 g
s
.54153 .54595 m .54327 .55772 L .53532 .55934 L p .377 .284 .621 r
F P
0 g
s
.52372 .53221 m .52492 .52777 L p .54278 .54153 L .42 .505 .84 r
F P
0 g
s
.01 w
.53499 .53528 m
.55662 .51589 L
s
.53484 .53541 m
.53499 .53528 L
s
.5 Mabswid
.51327 .52489 m .52492 .52777 L .52372 .53221 L p .657 .752 .92 r
F P
0 g
s
.54278 .54153 m .54153 .54595 L .53712 .54688 L p .42 .505 .84 r
F P
0 g
s
.48864 .5529 m .49172 .54434 L .49729 .55824 L p .973 .757 .55 r
F P
0 g
s
.49729 .55824 m .49314 .56407 L .48864 .5529 L p .973 .757 .55 r
F P
0 g
s
.49314 .56407 m .49729 .55824 L .5088 .57084 L p .855 .54 .454 r
F P
0 g
s
.5088 .57084 m .50241 .57422 L .49314 .56407 L p .855 .54 .454 r
F P
0 g
s
.50241 .57422 m .5088 .57084 L .52196 .57745 L p .667 .23 .203 r
F P
0 g
s
.52992 .57024 m .52196 .57745 L .5088 .57084 L p .649 .357 .463 r
F P
0 g
s
.49425 .53436 m .50233 .52723 L .49976 .53722 L p .896 .98 .808 r
F P
0 g
s
.49976 .53722 m .49172 .54434 L .49425 .53436 L p .896 .98 .808 r
F P
0 g
s
.52196 .57745 m .52992 .57024 L .53983 .56827 L p .191 0 .033 r
F P
0 g
s
.03 w
.55211 .5687 m
.55601 .57063 L
s
.5 Mabswid
.54327 .55772 m .53983 .56827 L .52992 .57024 L p .32 .098 .412 r
F P
0 g
s
.52492 .52777 m .5293 .52678 L p .54278 .54153 L .42 .505 .84 r
F P
0 g
s
.52115 .52309 m .5293 .52678 L .52492 .52777 L p .394 .745 .993 r
F P
0 g
s
.52492 .52777 m .51327 .52489 L .52115 .52309 L p .394 .745 .993 r
F P
0 g
s
.54327 .55772 m .54153 .54595 L .54278 .54153 L p 0 0 .484 r
F P
0 g
s
.49066 .54491 m .49425 .53436 L .49172 .54434 L p .768 .799 .31 r
F P
0 g
s
.49172 .54434 m .48864 .5529 L .49066 .54491 L p .768 .799 .31 r
F P
0 g
s
.52196 .57745 m .51298 .57955 L .50241 .57422 L p .667 .23 .203 r
F P
0 g
s
.51298 .57955 m .52196 .57745 L .53185 .57553 L p 0 0 0 r
F P
0 g
s
.53983 .56827 m .53185 .57553 L .52196 .57745 L p .191 0 .033 r
F P
0 g
s
.51212 .525 m .52115 .52309 L .51327 .52489 L p .167 .7 .707 r
F P
0 g
s
.51327 .52489 m .50233 .52723 L .51212 .525 L p .167 .7 .707 r
F P
0 g
s
.54278 .54153 m .54554 .54978 L .54327 .55772 L p 0 0 .484 r
F P
0 g
s
.53983 .56827 m .54327 .55772 L .54554 .54978 L p .72 .76 .258 r
F P
0 g
s
.49118 .56121 m .48864 .5529 L .49314 .56407 L p .777 .438 0 r
F P
0 g
s
.49314 .56407 m .49369 .56743 L .49118 .56121 L p .777 .438 0 r
F P
0 g
s
.49369 .56743 m .49314 .56407 L .50241 .57422 L p .787 .296 0 r
F P
0 g
s
.50241 .57422 m .49886 .57309 L .49369 .56743 L p .787 .296 0 r
F P
0 g
s
.49886 .57309 m .50241 .57422 L .51298 .57955 L p .397 0 0 r
F P
0 g
s
.5293 .52678 m .53521 .52966 L p .54278 .54153 L .42 .505 .84 r
F P
0 g
s
.53183 .52829 m .53521 .52966 L .5293 .52678 L p .344 0 0 r
F P
0 g
s
.5293 .52678 m .52115 .52309 L .53183 .52829 L p .344 0 0 r
F P
0 g
s
.53521 .52966 m .54037 .5353 L .54278 .54153 L p .42 .505 .84 r
F P
0 g
s
.54554 .54978 m .54278 .54153 L .54037 .5353 L p .729 .397 0 r
F P
0 g
s
.58343 .57196 m .66586 .61252 L .66949 .59077 L p .507 .484 .766 r
F P
0 g
s
.66949 .59077 m .58656 .5505 L .58343 .57196 L p .507 .484 .766 r
F P
0 g
s
.66586 .61252 m .58343 .57196 L .5721 .59387 L p .593 .434 .636 r
F P
0 g
s
.50402 .53217 m .51212 .525 L .50233 .52723 L p .155 0 0 r
F P
0 g
s
.50233 .52723 m .49425 .53436 L .50402 .53217 L p .155 0 0 r
F P
0 g
s
.54117 .53852 m .54037 .5353 L .53521 .52966 L p .76 .263 0 r
F P
0 g
s
.53521 .52966 m .53183 .52829 L .54117 .53852 L p .76 .263 0 r
F P
0 g
s
.01 w
.51268 .55527 m
.53322 .53686 L
s
.5 Mabswid
.54037 .5353 m .54117 .53852 L .54554 .54978 L p .729 .397 0 r
F P
0 g
s
.6543 .63494 m .5721 .59387 L .55674 .60816 L p .65 .359 .465 r
F P
0 g
s
.5721 .59387 m .6543 .63494 L .66586 .61252 L p .593 .434 .636 r
F P
0 g
s
.53185 .57553 m .53983 .56827 L .54265 .5584 L p .891 .986 .799 r
F P
0 g
s
.54554 .54978 m .54265 .5584 L .53983 .56827 L p .72 .76 .258 r
F P
0 g
s
.49231 .55679 m .49066 .54491 L .48864 .5529 L p 0 0 .457 r
F P
0 g
s
.48864 .5529 m .49118 .56121 L .49231 .55679 L p 0 0 .457 r
F P
0 g
s
.51298 .57955 m .50475 .57606 L .49886 .57309 L p .397 0 0 r
F P
0 g
s
.53185 .57553 m .52089 .57802 L .51298 .57955 L p 0 0 0 r
F P
0 g
s
.50475 .57606 m .51298 .57955 L .52089 .57802 L p .365 .739 .989 r
F P
0 g
s
.41953 .62734 m .47185 .58067 L .46599 .56637 L p .877 .748 .716 r
F P
0 g
s
.47185 .58067 m .41953 .62734 L .43165 .64063 L p .787 .571 .608 r
F P
0 g
s
.43165 .64063 m .48375 .59371 L .47185 .58067 L p .787 .571 .608 r
F P
0 g
s
.48375 .59371 m .43165 .64063 L .44522 .64788 L p .649 .357 .463 r
F P
0 g
s
.44522 .64788 m .49728 .60064 L .48375 .59371 L p .649 .357 .463 r
F P
0 g
s
.52547 .53152 m .53183 .52829 L .52115 .52309 L p .659 .211 .177 r
F P
0 g
s
.52115 .52309 m .51212 .525 L .52547 .53152 L p .659 .211 .177 r
F P
0 g
s
.02 w
.51242 .51239 m
.51387 .52451 L
s
.5 Mabswid
.54265 .5584 m .54554 .54978 L .54117 .53852 L p .979 .76 .538 r
F P
0 g
s
.49849 .5432 m .50402 .53217 L .49425 .53436 L p .3 .075 .396 r
F P
0 g
s
.03 w
.49575 .54078 m
.49782 .54181 L
s
.5 Mabswid
.49425 .53436 m .49066 .54491 L .49849 .5432 L p .3 .075 .396 r
F P
0 g
s
.49369 .56743 m .49886 .57309 L p .5078 .56454 L .407 .5 .842 r
F P
0 g
s
.49118 .56121 m .49369 .56743 L p .5078 .56454 L .407 .5 .842 r
F P
0 g
s
.49886 .57309 m .50475 .57606 L p .5078 .56454 L .407 .5 .842 r
F P
0 g
s
.01 w
.49438 .57166 m
.50071 .56599 L
s
.5 Mabswid
.52089 .57802 m .53185 .57553 L .53463 .56567 L p .784 .889 .92 r
F P
0 g
s
.54265 .5584 m .53463 .56567 L .53185 .57553 L p .891 .986 .799 r
F P
0 g
s
.49231 .55679 m .49118 .56121 L p .5078 .56454 L .407 .5 .842 r
F P
0 g
s
.01 w
.50429 .56279 m
.51268 .55527 L
s
.5 Mabswid
.50475 .57606 m .50912 .5752 L p .5078 .56454 L .407 .5 .842 r
F P
0 g
s
.52089 .57802 m .50912 .5752 L .50475 .57606 L p .365 .739 .989 r
F P
0 g
s
.58656 .5505 m .66949 .59077 L .66373 .57781 L p .238 .505 .904 r
F P
0 g
s
.66373 .57781 m .58021 .53749 L .58656 .5505 L p .238 .505 .904 r
F P
0 g
s
.53717 .54432 m .54117 .53852 L .53183 .52829 L p .858 .537 .442 r
F P
0 g
s
.53183 .52829 m .52547 .53152 L .53717 .54432 L p .858 .537 .442 r
F P
0 g
s
.54117 .53852 m .53717 .54432 L .54265 .5584 L p .979 .76 .538 r
F P
0 g
s
.49666 .55587 m .49849 .5432 L .49066 .54491 L p .363 .271 .616 r
F P
0 g
s
.49066 .54491 m .49231 .55679 L .49666 .55587 L p .363 .271 .616 r
F P
0 g
s
.41336 .61296 m .46599 .56637 L .46844 .55617 L p .896 .98 .808 r
F P
0 g
s
.46599 .56637 m .41336 .61296 L .41953 .62734 L p .877 .748 .716 r
F P
0 g
s
.50912 .5752 m .52089 .57802 L .52307 .57011 L p .653 .757 .926 r
F P
0 g
s
.53463 .56567 m .52307 .57011 L .52089 .57802 L p .784 .889 .92 r
F P
0 g
s
.55674 .60816 m .63905 .6498 L .6543 .63494 L p .65 .359 .465 r
F P
0 g
s
.50752 .43687 m .51474 .49824 L .53122 .50145 L p .565 .619 .865 r
F P
0 g
s
.49 .441 m .49763 .50233 L .51474 .49824 L p .75 .756 .857 r
F P
0 g
s
.51474 .49824 m .50752 .43687 L .49 .441 L p .75 .756 .857 r
F P
0 g
s
.51738 .53873 m .52547 .53152 L .51212 .525 L p .646 .35 .454 r
F P
0 g
s
.51212 .525 m .50402 .53217 L .51738 .53873 L p .646 .35 .454 r
F P
0 g
s
.02 w
.51387 .52451 m
.51448 .52968 L
s
.51545 .53779 m
.51935 .57054 L
s
.51448 .52968 m
.51474 .53184 L
s
.5 Mabswid
.49728 .60064 m .44522 .64788 L .45516 .6463 L p .191 0 .033 r
F P
0 g
s
.45516 .6463 m .50736 .59879 L .49728 .60064 L p .191 0 .033 r
F P
0 g
s
.53463 .56567 m .54265 .5584 L .53717 .54432 L p .881 .752 .715 r
F P
0 g
s
.03 w
.49892 .54235 m
.53526 .56036 L
s
.53864 .56203 m
.5392 .56231 L
s
.54103 .56321 m
.55211 .5687 L
s
.5392 .56231 m
.54103 .56321 L
s
.5 Mabswid
.47836 .45087 m .4863 .51222 L .49763 .50233 L p .913 .858 .773 r
F P
0 g
s
.49763 .50233 m .49 .441 L .47836 .45087 L p .913 .858 .773 r
F P
0 g
s
.49666 .55587 m .49231 .55679 L p .5078 .56454 L .407 .5 .842 r
F P
0 g
s
.50912 .5752 m .5103 .5708 L .5078 .56454 L p .407 .5 .842 r
F P
0 g
s
.52307 .57011 m .5103 .5708 L .50912 .5752 L p .653 .757 .926 r
F P
0 g
s
.53122 .50145 m .52438 .44 L .50752 .43687 L p .565 .619 .865 r
F P
0 g
s
.52438 .44 m .53122 .50145 L .54089 .5108 L p .171 .298 .753 r
F P
0 g
s
.50919 .5485 m .51738 .53873 L .50402 .53217 L p .609 .41 .587 r
F P
0 g
s
.50402 .53217 m .49849 .5432 L .50919 .5485 L p .609 .41 .587 r
F P
0 g
s
.52307 .57011 m .53463 .56567 L .52911 .55158 L p .788 .715 .784 r
F P
0 g
s
.53717 .54432 m .52911 .55158 L .53463 .56567 L p .881 .752 .715 r
F P
0 g
s
.52911 .55158 m .53717 .54432 L .52547 .53152 L p .789 .571 .605 r
F P
0 g
s
.52547 .53152 m .51738 .53873 L .52911 .55158 L p .789 .571 .605 r
F P
0 g
s
.5078 .56454 m .50259 .55883 L .49666 .55587 L p .407 .5 .842 r
F P
0 g
s
.49849 .5432 m .49666 .55587 L .50259 .55883 L p .561 .451 .685 r
F P
0 g
s
.5103 .5708 m .52307 .57011 L .51861 .55881 L p .688 .666 .823 r
F P
0 g
s
.51861 .55881 m .5078 .56454 L .5103 .5708 L p .688 .666 .823 r
F P
0 g
s
.50259 .55883 m .50919 .5485 L .49849 .5432 L p .561 .451 .685 r
F P
0 g
s
.52911 .55158 m .51861 .55881 L .52307 .57011 L p .788 .715 .784 r
F P
0 g
s
.47706 .46281 m .48508 .52422 L .4863 .51222 L p .914 .734 .239 r
F P
0 g
s
.4863 .51222 m .47836 .45087 L .47706 .46281 L p .914 .734 .239 r
F P
0 g
s
.50919 .5485 m .50259 .55883 L .5078 .56454 L p .651 .567 .748 r
F P
0 g
s
.5078 .56454 m .51861 .55881 L .50919 .5485 L p .651 .567 .748 r
F P
0 g
s
.46844 .55617 m .41553 .60286 L .41336 .61296 L p .896 .98 .808 r
F P
0 g
s
.41553 .60286 m .46844 .55617 L .4784 .55404 L p .155 0 0 r
F P
0 g
s
.01 w
.47593 .58821 m
.49438 .57166 L
s
.5 Mabswid
.50736 .59879 m .45516 .6463 L .4576 .63635 L p .891 .986 .799 r
F P
0 g
s
.4576 .63635 m .51008 .58873 L .50736 .59879 L p .891 .986 .799 r
F P
0 g
s
.51861 .55881 m .52911 .55158 L .51738 .53873 L p .725 .575 .686 r
F P
0 g
s
.51738 .53873 m .50919 .5485 L .51861 .55881 L p .725 .575 .686 r
F P
0 g
s
.54089 .5108 m .53425 .44927 L .52438 .44 L p .171 .298 .753 r
F P
0 g
s
.53425 .44927 m .54089 .5108 L .53998 .52283 L p .883 .708 .191 r
F P
0 g
s
.58021 .53749 m .66282 .57737 L p .63183 .5678 L .604 .057 0 r
F P
0 g
s
.65056 .57879 m .56659 .53808 L .58021 .53749 L p .604 .057 0 r
F P
0 g
s
.56659 .53808 m .65056 .57879 L .63493 .59366 L p .645 .348 .452 r
F P
0 g
s
.63493 .59366 m .55084 .55238 L .56659 .53808 L p .645 .348 .452 r
F P
0 g
s
.56286 .44085 m .57339 .54974 L p .61608 .5567 L .631 .676 .875 r
F P
0 g
s
.57339 .54974 m .57386 .55466 L .59218 .55554 L p .631 .676 .875 r
F P
0 g
s
.59218 .55554 m .61608 .5567 L p .57339 .54974 L .631 .676 .875 r
F P
0 g
s
.66373 .57781 m .65056 .57879 L p .63183 .5678 L .604 .057 0 r
F P
0 g
s
.66282 .57737 m .66373 .57781 L p .63183 .5678 L .604 .057 0 r
F P
0 g
s
.03 w
.55601 .57063 m
.58611 .58555 L
s
.5 Mabswid
.54302 .60938 m .62576 .65143 L .63905 .6498 L p .632 .104 0 r
F P
0 g
s
.62576 .65143 m .54302 .60938 L .53622 .59676 L p .193 .487 .899 r
F P
0 g
s
.48677 .47228 m .4946 .53377 L .48508 .52422 L p .14 .28 .746 r
F P
0 g
s
.48508 .52422 m .47706 .46281 L .48677 .47228 L p .14 .28 .746 r
F P
0 g
s
.42534 .60098 m .4784 .55404 L .49213 .56092 L p .646 .349 .454 r
F P
0 g
s
.4784 .55404 m .42534 .60098 L .41553 .60286 L p .155 0 0 r
F P
0 g
s
.51008 .58873 m .4576 .63635 L .45148 .62175 L p .881 .752 .715 r
F P
0 g
s
.45148 .62175 m .50427 .57423 L .51008 .58873 L p .881 .752 .715 r
F P
0 g
s
.53998 .52283 m .53328 .46123 L .53425 .44927 L p .883 .708 .191 r
F P
0 g
s
.53328 .46123 m .53998 .52283 L .52868 .53292 L p .918 .865 .773 r
F P
0 g
s
.50385 .47555 m .51129 .53712 L .4946 .53377 L p .559 .619 .869 r
F P
0 g
s
.4946 .53377 m .48677 .47228 L .50385 .47555 L p .559 .619 .869 r
F P
0 g
s
.43911 .60819 m .49213 .56092 L .50427 .57423 L p .789 .571 .605 r
F P
0 g
s
.49213 .56092 m .43911 .60819 L .42534 .60098 L p .646 .349 .454 r
F P
0 g
s
.50427 .57423 m .45148 .62175 L .43911 .60819 L p .789 .571 .605 r
F P
0 g
s
.01 w
.40441 .65229 m
.44564 .61535 L
s
.5 Mabswid
.52868 .53292 m .52167 .47131 L .53328 .46123 L p .918 .865 .773 r
F P
0 g
s
.52167 .47131 m .52868 .53292 L .51129 .53712 L p .751 .761 .861 r
F P
0 g
s
.61954 .63889 m .53622 .59676 L .53917 .57491 L p .497 .479 .768 r
F P
0 g
s
.53622 .59676 m .61954 .63889 L .62576 .65143 L p .193 .487 .899 r
F P
0 g
s
.51129 .53712 m .50385 .47555 L .52167 .47131 L p .751 .761 .861 r
F P
0 g
s
.02 w
.5057 .45603 m
.50792 .47458 L
s
.5 Mabswid
.67997 .61946 m .71813 .63824 L .7221 .61631 L p .507 .484 .766 r
F P
0 g
s
.7221 .61631 m .68369 .59766 L .67997 .61946 L p .507 .484 .766 r
F P
0 g
s
.71813 .63824 m .67997 .61946 L .66837 .64198 L p .593 .434 .636 r
F P
0 g
s
.70642 .66099 m .66837 .64198 L .65314 .65693 L p .65 .359 .465 r
F P
0 g
s
.66837 .64198 m .70642 .66099 L .71813 .63824 L p .593 .434 .636 r
F P
0 g
s
.55084 .55238 m .63493 .59366 L .62302 .61675 L p .588 .429 .633 r
F P
0 g
s
.03 w
.58611 .58555 m
.59044 .58769 L
s
.62833 .60646 m
.67815 .63115 L
s
.5 Mabswid
.62302 .61675 m .53917 .57491 L .55084 .55238 L p .588 .429 .633 r
F P
0 g
s
.53917 .57491 m .62302 .61675 L .61954 .63889 L p .497 .479 .768 r
F P
0 g
s
.68369 .59766 m .7221 .61631 L .71673 .6034 L p .238 .505 .904 r
F P
0 g
s
.71673 .6034 m .67804 .58471 L .68369 .59766 L p .238 .505 .904 r
F P
0 g
s
.65314 .65693 m .69126 .67622 L .70642 .66099 L p .65 .359 .465 r
F P
0 g
s
.61608 .5567 m .60697 .4426 L .56286 .44085 L p .631 .676 .875 r
F P
0 g
s
.67804 .58471 m .71673 .6034 L .7044 .60458 L p .604 .057 0 r
F P
0 g
s
.70338 .60426 m .67804 .58471 L .7044 .60458 L .604 .057 0 r
F
.70386 .60463 m .66494 .58576 L .67804 .58471 L p F P
0 g
s
.66494 .58576 m .70386 .60463 L .68832 .61988 L p .645 .348 .452 r
F P
0 g
s
.68832 .61988 m .64934 .60074 L .66494 .58576 L p .645 .348 .452 r
F P
0 g
s
.64105 .42874 m .65164 .5883 L p .70037 .59809 L .628 .678 .878 r
F P
0 g
s
.65164 .5883 m .65213 .59562 L .68001 .59705 L p .628 .678 .878 r
F P
0 g
s
.68001 .59705 m .70037 .59809 L p .65164 .5883 L .628 .678 .878 r
F P
0 g
s
.7044 .60458 m .70386 .60463 L p .70338 .60426 L .604 .057 0 r
F P
0 g
s
.63992 .65864 m .67826 .67812 L .69126 .67622 L p .632 .104 0 r
F P
0 g
s
.67826 .67812 m .63992 .65864 L .63382 .64611 L p .193 .487 .899 r
F P
0 g
s
.67244 .66564 m .63382 .64611 L .63738 .62392 L p .497 .479 .768 r
F P
0 g
s
.63382 .64611 m .67244 .66564 L .67826 .67812 L p .193 .487 .899 r
F P
0 g
s
.80589 .70147 m .81108 .69135 L .70238 .64315 L closepath p .627 .474 .656 r
F P
0 g
s
.79944 .70833 m .80589 .70147 L .70238 .64315 L closepath p .689 .411 .497 r
F P
0 g
s
.79415 .70929 m .79944 .70833 L .70238 .64315 L closepath p .719 .225 .066 r
F P
0 g
s
.79401 .69428 m .79206 .70394 L .70238 .64315 L closepath p .445 .426 .745 r
F P
0 g
s
.81108 .69135 m .81306 .68176 L .70238 .64315 L closepath p .551 .529 .784 r
F P
0 g
s
.79927 .68403 m .79401 .69428 L .70238 .64315 L closepath p .548 .383 .609 r
F P
0 g
s
.81306 .68176 m .81105 .67633 L .70238 .64315 L closepath p .34 .588 .936 r
F P
0 g
s
.80579 .67717 m .79927 .68403 L .70238 .64315 L closepath p .597 .286 .412 r
F P
0 g
s
.81105 .67633 m .80579 .67717 L .70238 .64315 L closepath p .481 0 0 r
F P
0 g
s
.79206 .70394 m .79415 .70929 L .70238 .64315 L closepath p .063 .375 .841 r
F P
0 g
s
.03 w
.67815 .63115 m
.70238 .64315 L
s
.5 Mabswid
.64934 .60074 m .68832 .61988 L .67625 .64331 L p .588 .429 .633 r
F P
0 g
s
.67625 .64331 m .63738 .62392 L .64934 .60074 L p .588 .429 .633 r
F P
0 g
s
.63738 .62392 m .67625 .64331 L .67244 .66564 L p .497 .479 .768 r
F P
0 g
s
.70037 .59809 m .69253 .43071 L .64105 .42874 L p .628 .678 .878 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00^@3oool2000006D0oooo002i0?ooo`80Tg:[0`00001R0?ooo`00^03oool00`000000Tg:[
09=bZ`0309=bZ`800000H03oool00;P0oooo00<0000009=bZ`2CLZ/01@2CLZ/3000005d0oooo002g
0?ooo`030000002CLZ/0Tg:[00T0Tg:[0P00001K0?ooo`00]`3oool00`000000Tg:[09=bZ`0:09=b
Z`030000003oool0oooo05T0oooo002g0?ooo`030000002CLZ/0Tg:[00T0Tg:[00<000000?ooo`3o
ool0FP3oool00;H0oooo00<0000009=bZ`2CLZ/02P2CLZ/00`000000oooo0?ooo`1J0?ooo`00]P3o
ool00`000000Tg:[09=bZ`0909=bZ`030000003oool0oooo05/0oooo002e0?ooo`030000002CLZ/0
Tg:[00X0Tg:[00<000000?ooo`3oool0F`3oool00;D0oooo00<0000009=bZ`2CLZ/02@2CLZ/00`00
0000oooo0?ooo`1L0?ooo`00]@3oool00`000000Tg:[09=bZ`0909=bZ`030000003oool0oooo05`0
oooo002d0?ooo`030000002CLZ/0Tg:[00X0Tg:[00<000000?ooo`3oool0G03oool00;@0oooo00<0
000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?ooo`1M0?ooo`00/`3oool00`000000Tg:[09=bZ`0:
09=bZ`030000003oool0oooo05d0oooo002c0?ooo`030000002CLZ/0Tg:[00T0Tg:[00<000000?oo
o`3oool0GP3oool00;80oooo00<0000009=bZ`2CLZ/02P2CLZ/00`000000oooo0?ooo`1N0?ooo`00
/P3oool00`000000Tg:[09=bZ`0909=bZ`030000003oool0oooo05l0oooo002b0?ooo`030000002C
LZ/0Tg:[00T0Tg:[00<000000?ooo`3oool0G`3oool00;40oooo00<0000009=bZ`2CLZ/02P2CLZ/0
0`000000oooo0?ooo`1O0?ooo`00/@3oool00`000000Tg:[09=bZ`0909=bZ`030000003oool0oooo
0600oooo002`0?ooo`030000002CLZ/0Tg:[00X0Tg:[00<000000?ooo`3oool0H03oool00;00oooo
00<0000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?ooo`1Q0?ooo`00/03oool00`000000Tg:[09=b
Z`0909=bZ`030000003oool0oooo0640oooo002_0?ooo`030000002CLZ/0Tg:[00T0Tg:[00<00000
0?ooo`3oool0HP3oool00:l0oooo00<0000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?ooo`1R0?oo
o`00[P3oool00`000000Tg:[09=bZ`0:09=bZ`030000003oool0oooo0680oooo002^0?ooo`030000
002CLZ/0Tg:[00T0Tg:[00<000000?ooo`3oool0H`3oool00:h0oooo00<0000009=bZ`2CLZ/02@2C
LZ/00`000000oooo0?ooo`1S0?ooo`00[@3oool00`000000Tg:[09=bZ`0909=bZ`030000003oool0
oooo06@0oooo002]0?ooo`030000002CLZ/0Tg:[00T0Tg:[00<000000?ooo`3oool0I03oool00:`0
oooo00<0000009=bZ`2CLZ/02P2CLZ/00`000000oooo0?ooo`1T0?ooo`00[03oool00`000000Tg:[
09=bZ`0909=bZ`030000003oool0oooo06D0oooo002/0?ooo`030000002CLZ/0Tg:[00T0Tg:[00<0
00000?ooo`3oool0I@3oool00:/0oooo00<0000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?ooo`1V
0?ooo`00Z`3oool00`000000Tg:[09=bZ`0909=bZ`030000003oool0oooo06H0oooo002Z0?ooo`03
0000002CLZ/0Tg:[00T0Tg:[00<000000?ooo`3oool0I`3oool00:X0oooo00<0000009=bZ`2CLZ/0
2@2CLZ/00`000000oooo0?ooo`1W0?ooo`00ZP3oool00`000000Tg:[09=bZ`0909=bZ`030000003o
ool0oooo06L0oooo002Y0?ooo`030000002CLZ/0Tg:[00T0Tg:[00<000000?ooo`3oool0J03oool0
0:T0oooo00<0000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?ooo`1X0?ooo`00Z03oool00`000000
Tg:[09=bZ`0909=bZ`030000003oool0oooo06T0oooo002X0?ooo`030000002CLZ/0Tg:[00T0Tg:[
00<000000?ooo`3oool0J@3oool00:L0oooo00<0000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?oo
o`1Z0?ooo`00Y`3oool00`000000Tg:[09=bZ`0909=bZ`030000003oool0oooo06X0oooo002W0?oo
o`030000002CLZ/0Tg:[00T0Tg:[00<000000?ooo`3oool0JP3oool00:H0oooo00<0000009=bZ`2C
LZ/02@2CLZ/00`000000oooo0?ooo`1[0?ooo`00YP3oool00`000000Tg:[09=bZ`0909=bZ`030000
003oool0oooo0080oooo4000001I0?ooo`00Y@3oool00`000000Tg:[09=bZ`0909=bZ`030000003o
ool0oooo00<0oooo00<000000:2]h02P[N00302P[N000`000000oooo0?ooo`1G0?ooo`00S`3oool5
00000140oooo00<0000009=bZ`2CLZ/02@2CLZ/00`000000oooo0?ooo`030?ooo`030000002P[N00
X:gP00`0X:gP00<000000?ooo`3oool0E`3oool008`0oooo0`0000020;o1f`030000002@W]d0T9kM
00<000002P3oool7000000P0Tg:[00<000000?ooo`3oool0103oool00`000000X:gP0:2]h00<0:2]
h0030000003oool0oooo05L0oooo002;0?ooo`800000102o`M/00`000000T9kM092Ng@02092Ng@<0
0000203oool00`000000XJgO0:6]g`040:6]g`L0000000<0Tg:[0000003oool01@3oool00`000000
X:gP0:2]h00<0:2]h0030000003oool0oooo05L0oooo002:0?ooo`030000003YflD000000080_l7K
1@000002092Ng@040000000[C<00:dc0000000L0oooo00<000000:6]g`2Q[Ml02P2Q[Ml00`000000
Tg:[000000060?ooo`030000002P[N00X:gP00`0X:gP00<000000?ooo`3oool0E`3oool008T0oooo
00@000000>WKa@3YflD000000P2o`M/500000080T9kM00@0000002]<`00[C<0000001`3oool00`00
0000XJgO0:6]g`0:0:6]g`800000203oool00`000000X:gP0:2]h00;0:2]h0030000003oool0oooo
05L0oooo00290?ooo`040000003YflD0jM_500000080_l7K1@000002092Ng@040000000[C<00:dc0
000000L0oooo00<000000:6]g`2Q[Ml02P2Q[Ml2000000P0oooo00<000000:2]h02P[N002`2P[N00
0`000000oooo0?ooo`1G0?ooo`00R03oool2000000<0jM_500<000000;o1f`00000010000003092N
g@030000000[C<00000000L0oooo00<000000:6]g`2Q[Ml02P2Q[Ml00`000000oooo0?ooo`070?oo
o`030000002P[N00X:gP00/0X:gP00<000000?ooo`3oool0E`3oool008P0oooo0P0000030>WKa@03
0000002o`M/0000000@000000`2@W]d00`000000:dc0000000080?ooo`030000002Q[Ml0XJgO00T0
XJgO00<000000?ooo`3oool01`3oool00`000000X:gP0:2]h00;0:2]h0030000003oool0oooo05L0
oooo00280?ooo`8000000`3YflD00`000000_l7K00000004000000<0T9kM100000070?ooo`030000
002Q[Ml0XJgO00T0XJgO00<000000?ooo`3oool01`3oool00`000000X:gP0:2]h00;0:2]h0030000
003oool0oooo05L0oooo00280?ooo`030000000SAkh000000080jM_500<000000;o1f`0000001000
0002092Ng@030000003[gLD0jmg5008000001`3oool00`000000XJgO0:6]g`090:6]g`030000003o
ool0oooo00L0oooo00<000000:2]h02P[N002`2P[N000`000000oooo0?ooo`1G0?ooo`00R03oool0
0`0000008dNn02=7_P03000000030;o1f`000000000000D000000`3[gLD2000000H0oooo0P00000;
0:6]g`030000003oool0oooo00L0oooo00<000000:2]h02P[N002`2P[N000`000000oooo0?ooo`1G
0?ooo`00R@3oool00`0000008dNn0000000208nNgPH0000000<0`<;L0000003[gLD00P3[gLD20000
00D0oooo00<0000002L000000000302Q[Ml00`000000oooo0?ooo`060?ooo`030000002P[N00X:gP
00`0X:gP00<000000?ooo`3oool0EP3oool008T0oooo00<0000002=7_P0000000`2?W]h500000003
0<32g0000000jmg50080jmg50P0000040?ooo`040000000W00000000000000`0XJgO00<000000?oo
o`3oool01P3oool00`000000X:gP0:2]h00<0:2]h0030000003oool0oooo05H0oooo001f0?ooo`<0
0000403oool00`0000008dNn0000000308nNgPD0000000<0`<;L0000003[gLD00P3[gLD2000000<0
oooo00D0000002L000000000YEUd0000000<0:6]g`030000003oool0oooo00H0oooo00<000000:2]
h02P[N00302P[N000`000000oooo0?ooo`1F0?ooo`00M@3oool00`000000/6Z000000002000000l0
oooo00<0000002=7_P000000102?W]h00`000000`<;L0<32g0020<32g0040000003[gLD0jmg50>_M
a@8000000P3oool00`0000009`00000000020:EIM0030000002Q[Ml0XJgO00X0XJgO00<000000?oo
o`3oool01P3oool00`000000X:gP0:2]h00<0:2]h0030000003oool0oooo05H0oooo001d0?ooo`03
0000002`JX00/6Z00080/6Z00`00000=0?ooo`040000000SAkh08dNn000000<0SikN00<000000<32
g030`]`00`30`]`00`000000jmg50>_Ma@040000000302L000000000YEUd0080YEUd00<000000:6]
g`2Q[Ml02P2Q[Ml2000000P0oooo00<000000:2]h02P[N002`2P[N000`000000oooo0?ooo`1F0?oo
o`00L`3oool010000000X7VW0000000000030;1ZP0030000002i?AL0000000`0oooo00@0000002=7
_P0SAkh00000102?W]h00`000000`<;L0<32g0020<32g0030000003[gLD0jmg5008000000P0W0000
0`000000YEUd0:EIM0020:EIM0030000002Q[Ml0XJgO00X0XJgO0P0000080?ooo`030000002P[N00
X:gP00/0X:gP00<000000?ooo`3oool0EP3oool007<0oooo00@000000:1iY`2PNJL0X7VW0P000002
0;1ZP0<00000303oool00`0000008dNn0000000408nNgP0300000030`]`0`<;L0080`<;L00@00000
0>_Ma@3[gLD0jmg50`0000040:EIM00300000039TYX0000000/0XJgO0P0000080?ooo`030000002P
[N00X:gP00/0X:gP00<000000?ooo`3oool0EP3oool00780oooo0P0000050:1iY`8000000P2`JX03
000000X0oooo00<0000002=7_P000000102?W]h00`000000`<;L0<32g0020<32g0040000003[gLD0
jmg50>_Ma@800000102UFG@010000000bI:J0<VBVP00000;0:6]g`030000003oool0oooo00L0oooo
00<000000:2]h02P[N002`2P[N000`000000oooo0?ooo`1F0?ooo`00LP3oool010000000SHO80000
000000050:1iY`030000002`JX00/6Z000<000002@3oool00`0000008dNn0000000408nNgP030000
0030`]`0`<;L0080`<;L00@000000>_Ma@3[gLD0jmg50P0000030:EIM00500000039TYX0bI:J0<VB
VP0000002`2Q[Ml00`000000oooo0?ooo`070?ooo`030000002P[N00X:gP00/0X:gP00<000000?oo
o`3oool0EP3oool00780oooo0P00000208f7b0800000102PNJL200000080/6Z00P0000080?ooo`03
0000000SAkh0000000@0SikN00<000000<32g030`]`00P30`]`010000000jmg50>_Ma@3[gLD30000
00030:EIM0000000bI:J00<0bI:J00<000000:6]g`2Q[Ml02@2Q[Ml00`000000oooo0?ooo`070?oo
o`030000002P[N00X:gP00/0X:gP00<000000?ooo`3oool0EP3oool00780oooo00<0000005ZGk`00
00000P000000102=QlP000000000000000030:1iY`80000000<0/6Z00000000000001`3oool00`00
00008dNn0000000408nNgP0300000030`]`0`<;L0080`<;L00@000000>_Ma@3[gLD0jmg50P000000
0`3P_kL000000<VBVP040<VBVP030000002Q[Ml0XJgO00T0XJgO00<000000?ooo`3oool01`3oool0
0`000000X:gP0:2]h00;0:2]h0030000003oool0oooo05H0oooo001c0?ooo`8000000P1JUnl20000
0080SHO80P0000030:1iY`030000002`JX000000008000001@3oool00`0000008dNn0000000408nN
gP0300000030`]`0`<;L0080`<;L00@000000>_Ma@3[gLD0jmg50`0000000`39TY/0000000000003
0<VBVP030000002Q[Ml0XJgO00T0XJgO00<000000?ooo`3oool01`3oool00`000000X:gP0:2]h00;
0:2]h0030000003oool0oooo05H0oooo001e0?ooo`L0000000<0SHO80000000000000P2PNJL20000
00030;1ZP0000000000000D0oooo0P00000408nNgP0300000030`]`0`<;L00<0`<;L00<000000>_M
a@3[gLD00P0000020<VBV`<0000000<0bI:J0000000000002`2Q[Ml2000000P0oooo00<000000:2]
h02P[N002`2P[N000`000000oooo0?ooo`1F0?ooo`00N@3oool9000000030:1iY`00000000000080
0000103oool00`0000008dNn0000000308nNgP0300000030`]`0`<;L00<0`<;L00@000000>_Ma@3[
gLD000000P39TY/3000000040<VBV`000000hL2g000000/0XJgO00<0000007<0000000000`000004
0?ooo`030000002P[N00X:gP00/0X:gP00<000000?ooo`3oool0EP3oool007`0oooo200000000`2P
NJL000000000000200000080oooo00<0000002=7_P000000102?W]h00`000000`<;L0<32g0020<32
g0050000003[gLD0jmg500000039TY/00`0000001@39TY/000000000003Q`;L0000000/0XJgO1000
000207<000D000003@2P[N000`000000oooo0?ooo`1F0?ooo`00O`3oool7000000040:1iY`000000
000000000080oooo0P00000408nNgP0300000030`]`0`<;L0080`<;L1P0000020<VBV`<0000000<0
hL2g0000002Q[Ml02P2Q[Ml010000000oooo0?ooo`3oool400000080L`0000<000000:2]h02P[N00
2`2P[N000`000000oooo0?ooo`1F0?ooo`00P`3oool;000000@0SikN00@000000<32g030`]`0`<;L
0P000000103KRG4000000000000000020<VBV`8000000P2VFgH3000000/0XJgO00<000000?ooo`3o
ool0103oool4000000`0X:gP00<000000?ooo`3oool0EP3oool008H0oooo2P00000208nNgP060000
0030`]`0000000000039TYX000000P3KRG42000000030<VBV`000000YU]f00<0YU]f00<000000>Cl
c00000002`2Q[Ml00`000000oooo0?ooo`070?ooo`030000002P[N00X:gP00X0X:gP00<000000?oo
o`3oool0EP3oool008T0oooo300000030<VBVP030000003KRG40fhUa008000001@2VFgH3000000/0
XJgO00<000000?ooo`3oool01`3oool00`000000X:gP0:2]h00:0:2]h0030000003oool0oooo05H0
oooo002:0?ooo`H000000`2KJ9H00`000000^I>_000000030<VBVP030000003KRG40000000D0YU]f
00@000000:EIL`2UFG<000002`2Q[Ml00`000000oooo0?ooo`070?ooo`030000002P[N00X:gP00X0
X:gP00<000000?ooo`3oool0EP3oool008X0oooo20000000102KJ9H000000;VC[`0000040<VBVP04
0000003j`XT0000000000080YU]f00D000000:EIL`2UFG<0YEUc0000000;0:6]g`030000003oool0
oooo00L0oooo00<000000:2]h02P[N002P2P[N000`000000oooo0?ooo`1F0?ooo`00RP3oool60000
0080Sg>_00H000000;VC[`2iTjl0^I>_00000039TYX5000000030?ooo`000000000000@0YEUc00<0
00000:6]g`2Q[Ml02@2Q[Ml00`000000oooo0?ooo`070?ooo`030000002P[N00X:gP00X0X:gP00<0
00000?ooo`3oool0EP3oool008X0oooo1@00000208mc[`030000002VTKl0000000<0^I>_00<00000
0>70]`3Q`;L01@0000050:EIL`030000002Q[Ml0XJgO00T0XJgO00<000000?ooo`3oool01`3oool0
0`000000X:gP0:2]h00:0:2]h0030000003oool0oooo05H0oooo00260?ooo`T000000P2?Ljl01000
0000YY6o0000002iTjl300000080hL2g1000000209I]XP040000002UFG<0YEUc0:EIL`h00000203o
ool00`000000X:gP0:2]h00:0:2]h0030000003oool0oooo05H0oooo00250?ooo`040000000W0000
9`0000000080YEUd0`0000000`1XOmL00000000000030:JA_`0600000039]lP0bKO80<Vgb0000000
hL2g1000000309I]XP8000002P2UFG<20000000309X>000lPNL0?87W00<000001@3oool00`000000
X:gP0:2]h00;0:2]h0030000003oool0oooo05D0oooo00240?ooo`040000000W00009`00000000@0
YEUd00<000000<VBVP0000000P0000001@2VTKl000000000002`Z]8000000080bKO800<000000>70
]`0000000P00000609I]XP8000002P2UFG<20000000409X>000lPNL0?87W09X>008000000`3oool0
0`000000X:gP0:2]h00;0:2]h0030000003oool0oooo05D0oooo00230?ooo`040000000W00000000
000000@0YEUd00<000000<VBVP39TYX0100000030;2ZdP0300000039]lP0bKO800D00000202FKJ82
000000X0YEUc0P000000102J3P00?87W09X>002J3P02000000030?ooo`000000X:gP00`0X:gP00<0
00000?ooo`3oool0E@3oool00880oooo00<0000002L0000000001@2UFG@00`000000bI:J0<VBVP02
0<VBVP030000001XOmL0J7oG00X000002`2FKJ82000000X0YEUc0P00000203b1i`80VPh00`00000<
0:2]h0030000003oool0oooo05D0oooo00210?ooo`030000000W0000000000D0YEUd00<000000<VB
VP39TYX01039TYX010000000J7oG0000002W`Nd8000000d0UVfR0P00000:0:EIL`80000000D0?87W
09X>002J3P00VPh00000000<0:2]h0030000003oool0oooo05D0oooo00200?ooo`030000000W0000
000000D0YEUd00<000000<VBVP39TYX01039TYX<000000/0UVfR1`00000:0:EIL`8000000P2J3P00
0`000000X:gP0:2]h00:0:2]h0030000003oool0oooo05D0oooo001n0?ooo`80000000<09`000000
002UFG@0102UFG@00`000000bI:J0<VBVP040<VBVP030000003Q`;L0hL2g00L000000P2@W]d30000
00X0UVfR2000000:0:EIL`<00000302P[N000`000000oooo0?ooo`1E0?ooo`00O@3oool010000000
9`0002L0000000040:EIM08000001P39TYX01P000000hL2g0>70]`3Q`;L000000;o1f`D000000P2@
W]d00`000000Og[407mja002000000T0UVfR1@00000209I]XP800000202UFG<00`000000PG_40000
000<0:2]h0030000003oool0oooo05D0oooo001l0?ooo`040000000W00009`00000000@0YEUd00<0
00000<VBVP39TYX01@39TYX00`000000hL2g0>70]`030>70]`H000000P2@W]d00`000000Og[407mj
a00207mja0800000202FKJ84000000@0UVfR0P0000050:EIL`0400000021Nl@0PG_4000000`0X:gP
00<000000?ooo`3oool0E@3oool007/0oooo00@0000002L0000000000000102UFG@00`000000bI:J
0<VBVP050<VBVP030000003Q`;L0hL2g00<0hL2g1`0000000`2@W]d0000007mja00607mja0800000
1`2FKJ83000000H0UVfR0P0000020:EIL`0500000021Nl@0PG_4085ka0000000302P[N000`000000
oooo0?ooo`1E0?ooo`00NP3oool00`0000009`00000000050:EIM00300000039TYX0bI:J00D0bI:J
00<000000>70]`3Q`;L00`3Q`;L:000000T0Og[40P00000609I]XP8000001@2FKJ85000000@0PG_4
100000090:2]h0030000003oool0oooo05D0oooo001i0?ooo`030000000W0000000000D0YEUd00<0
00000<VBVP39TYX01039TYX2000000D0hL2g00D000000>Clc000000000000;o1f`06000000/0Og[4
0P00000509I]XP030000002FKJ80UVfR00<0UVfR1P000003085ka0040000002UFG<0YEUc0:EIL``0
0000E@3oool007P0oooo0`0000050:EIM00300000039TYX0bI:J00@0bI:J00<000000>70]`3Q`;L0
103Q`;L01P000000i?c<0000003YflD000000;o1f`D0000000<0T9kM0000000000002`1oN/@20000
00P0UVfR2`00000:0:EIL`8000000`2J3P02000005<0oooo001g0?ooo`8000000P3P_kL200000080
YEUd00<000000<VBVP39TYX01039TYX00`000000hL2g0>70]`040>70]`030000003To<`000000080
jM_500<000000;o1f`000000100000000`2@W]d00000035liP02000000/0Og[40P00000609I]XPT0
00000P2FKJ82000000X0YEUc1P00001B0?ooo`00M`3oool00`000000h;ng0>2o]`030>2o]`800000
1P39TYX00`000000hL2g0>70]`040>70]`040000003To<`0000002=7_P<0000000<0_l7K00000000
00001P000002035liP8000002`1oN/@2000000<0UVfR2P00000409I]XP800000202UFG<010000000
PG_400000000000203b1i`030000003oool0oooo04l0oooo001f0?ooo`030000003P_kL0h;ng00@0
h;ng00<000000<VBV`0000001039TYX00`000000hL2g0>70]`030>70]`80000000D0i?c<00000000
00008dNn0000000208nNgPH0000000<0`<;L0000003[gLD00P000002035liP8000002`1oN/@20000
000309I]XP000000000000L000001`2FKJ82000000D0YEUc00<00000085ka021Nl@00P21Nl@30000
0540oooo001f0?ooo`030000003P_kL0h;ng00<0h;ng00<000000<VBV`0000000P0000020<VBVP03
0000003Q`;L0hL2g00<0hL2g00P000000>Clc03To<`000000?ooo`0000008dNn000000<0SikN1@00
00001030`]`000000>_Ma@3[gLD300000080<GcV0P00000;07mja0X000002@2FKJ8200000080YEUc
00<00000085ka021Nl@01@21Nl@200000500oooo001g0?ooo`060000003P_kL0h;ng0>2o]`000000
bI:K100000000`39TYX000000>70]`040>70]`040000003To<`0i?c<000000<0oooo0P00000308nN
gPD0000000<0`<;L0000003[gLD00P3[gLD010000000oooo000000000002035liP8000002`1oN/@7
000000`0UVfR0P000009085ka0030000003oool0oooo04h0oooo001g0?ooo`050000003P_kL0h;ng
00000039TY/00`0000020<VBV`030000003Q`;L0hL2g00<0hL2g00@000000>Clc00000000000103o
ool00`0000008dNn0000000308nNgP0300000030`]`0`<;L0080`<;L00D000000>_Ma@3[gLD0jmg5
000000030?ooo`8000000P0aO>H2000000X0Og[41P00000=09I]XP0300000021Nl@0PG_400L0PG_4
00<000000?ooo`3oool0CP3oool007P0oooo0P0000001039TY/000000000000000020<VBV`800000
103Q`;L00`000000i?c<000000060?ooo`030000000SAkh0000000@0SikN00D000000<32g030`]`0
`<;L000000030>_Ma@030000003oool0oooo00<0oooo0P000002035liP800000201oN/@00`000000
YU]g0:IKM`03000000`0UVfR10000007085ka0030000003oool0oooo04h0oooo001h0?ooo`030000
0039TY/000000080000000<0bI:K0000000000000P2VFgH01P000000hL2g0>70]`000000i?c<0000
00L0oooo00<0000002=7_P000000102?W]h00`000000`<;L0<32g0020<32g0040000003[gLD0jmg5
000000L0oooo0P000002035liP8000001P1oN/@01P000000YU]g0:IKM`2VFgL0000007mja0800000
2P2FKJ86000000@0PG_400<000000?ooo`3oool0C`3oool007T0oooo0`0000000`39TY/000000:IK
MP030:IKMP050000003Q`;L000000>Clc0000000203oool00`0000008dNn0000000408nNgP030000
0030`]`0`<;L0080`<;L00@000000>_Ma@3[gLD000001`3oool010000000XJgO000000000002035l
iP8000000`1oN/@00`000000YU]g0:IKM`020:IKM`040000001oN/@0Og[407mja08000001`2FKJ8:
00000003085ka0000000oooo0500oooo001h0?ooo`<0000000<0bI:K0000002VFgH0102VFgH20000
00030>Clc0000000oooo00P0oooo00<0000002=7_P000000102?W]h00`000000`<;L0<32g0020<32
g0040000003[gLD0jmg5000000L0oooo00@000000:6]g`2Q[Ml0XJgO0P000002035liP80000000<0
Og[40000002VFgL00`2VFgL00`000000Og[407mja00307mja0<00000102FKJ8<00000540oooo001g
0?ooo`<0000000<0oooo0000002VFgH0102VFgH010000000<00800000000000:0?ooo`030000000S
Akh0000000@0SikN00<000000<32g030`]`00P30`]`010000000jmg50>_Ma@0000070?ooo`030000
002Q[Ml0XJgO00<0XJgO0P000002035liP8000000`2VFgL00`000000Og[407mja00707mja0800000
00<0UVfR0000000000002`00001A0?ooo`00MP3oool3000000<0oooo0P0000020:IKMP040000000`
00P00000000000/0oooo00<0000002=7_P000000102?W]h00`000000`<;L0<32g0020<32g0040000
003[gLD0jmg5000000P0oooo00<000000:6]g`2Q[Ml0102Q[Ml200000080<GcV0P0000000`2VFgL0
000007mja00:07mja0d00000DP3oool007D0oooo0`0000060?ooo`D00000303oool00`0000008dNn
0000000408nNgP0300000030`]`0`<;L0080`<;L00<000000>_Ma@3[gLD00P0000070?ooo`030000
002Q[Ml0XJgO00H0XJgO0`0000020:4J00030000001oN/@0Og[400X0Og[43000001B0?ooo`00M03o
ool3000001P0oooo00@0000002=7_P0SAkh000000`2?W]h00`000000`<;L0<32g0020<32g0030000
003[gLD0jmg5008000001`3oool00`000000XJgO0:6]g`080:6]g`H000002@1oN/@00`000000YU]g
0000000=000004l0oooo001c0?ooo`<000006@3oool0100000008dNn02=7_P00000408nNgP050000
0030`]`0`<;L0<32g00000000P3[gLD2000000L0oooo00<000000:6]g`2Q[Ml0202Q[Ml01P000000
oooo0?ooo`3oool00000035liP8000001`1oN/@010000000YU]g0:IKM`2VFgL?000004`0oooo001d
0?ooo`030000003oool0oooo01P0oooo00@0000002=7_P0SAkh00000102?W]h01@000000`<;L0<32
g030`]`000000080jmg50P0000070?ooo`030000002Q[Ml0XJgO00T0XJgO00@000000?ooo`3oool0
00000`0aO>H2000000D0Og[400<000000:IKM`2VFgL00`2VFgL500000080oooo0`0000000`2<HY/0
000000000003000004T0oooo002@0?ooo`030000000SAkh0000000@0SikN00D000000<32g030`]`0
`<;L000000030>_Ma@030000003oool0oooo00D0oooo00<000000:6]g`2Q[Ml02@2Q[Ml010000000
oooo0?ooo`3oool2000000<0<GcV0P00000307mja0030000002VFgL0YU]g00H0YU]g0P0000040?oo
o`<0000000@0S6:K000000000000V4UY100000150?ooo`00T03oool00`0000008dNn0000000408nN
gP0500000030`]`0`<;L0<32g00000000`3[gLD00`000000oooo0?ooo`050?ooo`030000002Q[Ml0
XJgO00T0XJgO00<000000?ooo`3oool00`3oool2000000<0<GcV0`0000080:IKM`030000003oool0
oooo00D0oooo100000001@2<HY/00000000000000000V4UY00@00000@P3oool00900oooo00<00000
02=7_P000000102?W]h00`000000`<;L0<32g0020<32g0040000003[gLD0jmg5000000L0oooo00<0
00000:6]g`2Q[Ml02@2Q[Ml00`000000oooo0?ooo`050?ooo`8000000`0aO>H2000000H0YU]g0P00
00080?ooo`80000000<0LFfn0000002<HY/00P2<HY/200000080V4UY1000000o0?ooo`00T03oool0
0`0000008dNn0000000408nNgP0300000030`]`0`<;L0080`<;L00@000000>_Ma@3[gLD000001`3o
ool00`000000XJgO0:6]g`090:6]g`030000003oool0oooo00H0oooo0`000002035liP<00000102V
FgL2000000X0oooo1000000308aRV`8000000`2HBFT4000003`0oooo002@0?ooo`030000000SAkh0
000000@0SikN00<000000<32g030`]`00P30`]`010000000jmg50>_Ma@0000070?ooo`030000002Q
[Ml0XJgO00T0XJgO00<000000?ooo`3oool01P3oool00`000000X:gP0:2]h00300000080XAX00P00
0000102VFgL000000:2]h000000;0?ooo`80000000<0LFfn0000000000000`2<HY/3000000<0V4UY
1000000i0?ooo`00T03oool0100000008dNn02=7_P00000308nNgP0300000030`]`0`<;L0080`<;L
00@000000>_Ma@3[gLD00000203oool00`000000XJgO0:6]g`080:6]g`030000003oool0oooo00H0
oooo00<000000:2]h02P[N000P2P[N0600000080X:gP00<000000?ooo`3oool02P3oool300000003
075]_P000000000000@0S6:K0P00000409Q9J@<00000=`3oool00940oooo00<0000002=7_P000000
0`2?W]h8000000T0oooo00<000000:6]g`2Q[Ml0202Q[Ml00`000000oooo0?ooo`060?ooo`030000
002P[N00X:gP00X0X:gP00<000000?ooo`3oool0303oool200000080LFfn00<0000008aRV`2<HY/0
0`2<HY/200000080V4UY00@0000008f7b00000000000=P3oool00980oooo0P00000308nNgPH00000
2`3oool00`000000XJgO0:6]g`080:6]g`030000003oool0oooo00H0oooo00<000000:2]h02P[N00
2P2P[N000`000000oooo0?ooo`0=0?ooo`<0000000<0LFfn0000000000001@2<HY/2000000<0SHO8
00<000000?ooo`3oool0=03oool009<0oooo0`0000000`2?W]h0000000000003000000`0oooo00<0
00000:6]g`2Q[Ml0202Q[Ml00`000000oooo0?ooo`070?ooo`030000002P[N00X:gP00T0X:gP00<0
00000?ooo`3oool03`3oool200000080LFfn0P00000308aRV`<0000000<0SHO80000003oool0=P3o
ool009H0oooo1P00000<0?ooo`030000002Q[Ml0XJgO00P0XJgO00<000000?ooo`3oool01`3oool0
0`000000X:gP0:2]h0090:2]h0030000003oool0oooo0100oooo0P000003075]_P80000000@0S6:K
0000002PNJL0X7VW0P00000g0?ooo`00U`3oool5000000`0oooo00<000000:6]g`2Q[Ml0202Q[Ml0
0`000000oooo0?ooo`070?ooo`030000002P[N00X:gP00T0X:gP00<000000?ooo`3oool04@3oool3
000000<0LFfn0P0000030:1iY`030000003oool0oooo03D0oooo002G0?ooo`D00000303oool00`00
0000XJgO0:6]g`080:6]g`030000003oool0oooo00L0oooo00<000000:2]h02P[N002@2P[N000`00
0000oooo0?ooo`0C0?ooo`8000000P1aKKh00`000000/6Uo00000002000003P0oooo002G0?ooo`D0
0000303oool00`000000XJgO0:6]g`080:6]g`030000003oool0oooo00L0oooo00<000000:2]h02P
[N002@2P[N000`000000oooo0?ooo`0D0?ooo`@000000`2`JGl00`000000oooo0?ooo`0f0?ooo`00
U`3oool5000000`0oooo00<000000:6]g`2Q[Ml02@2Q[Ml00`000000oooo0?ooo`060?ooo`030000
002P[N00X:gP00T0X:gP00<000000?ooo`3oool05@3oool4000000030;1YO`000000oooo03P0oooo
002G0?ooo`D000003@3oool00`000000XJgO0:6]g`080:6]g`030000003oool0oooo00H0oooo00<0
00000:2]h02P[N002P2P[N000`000000oooo0?ooo`0F0?ooo`<00000>P3oool009L0oooo1@00000=
0?ooo`030000002Q[Ml0XJgO00P0XJgO00<000000?ooo`3oool01P3oool00`000000X:gP0:2]h00:
0:2]h0030000003oool0oooo05<0oooo002G0?ooo`D000003@3oool00`000000XJgO0:6]g`080:6]
g`030000003oool0oooo00H0oooo00<000000:2]h02P[N002P2P[N000`000000oooo0?ooo`1C0?oo
o`00Z@3oool00`000000XJgO0:6]g`080:6]g`030000003oool0oooo00H0oooo00<000000:2]h02P
[N002P2P[N000`000000oooo0?ooo`1C0?ooo`00Z@3oool6000000D0XJgO00<000000?ooo`3oool0
1P3oool00`000000X:gP0:2]h00:0:2]h0030000003oool0oooo05<0oooo002_0?ooo`H00000203o
ool00`000000X:gP0:2]h00:0:2]h0030000003oool0oooo05<0oooo002m0?ooo`030000002P[N00
X:gP00X0X:gP00<000000?ooo`3oool0D`3oool00;d0oooo00<000000:2]h02P[N002P2P[N000`00
0000oooo0?ooo`1C0?ooo`00_P3oool00`000000X:gP0:2]h0090:2]h0030000003oool0oooo05<0
oooo002n0?ooo`030000002P[N00X:gP00T0X:gP00<000000?ooo`3oool0D`3oool00;h0oooo00<0
00000:2]h02P[N002@2P[N000`000000oooo0?ooo`1C0?ooo`00_P3oool00`000000X:gP0:2]h009
0:2]h0030000003oool0oooo05<0oooo002n0?ooo`030000002P[N00X:gP00T0X:gP00<000000?oo
o`3oool0D`3oool00;h0oooo00<000000:2]h02P[N002@2P[N000`000000oooo0?ooo`1C0?ooo`00
_P3oool00`000000X:gP0:2]h0090:2]h0030000003oool0oooo05<0oooo002n0?ooo`030000002P
[N00X:gP00T0X:gP00<000000?ooo`3oool0D`3oool00;h0oooo00<000000:2]h02P[N002@2P[N00
0`000000oooo0?ooo`1C0?ooo`00_P3oool00`000000X:gP0:2]h0090:2]h0030000003oool0oooo
05<0oooo002n0?ooo`030000002P[N00X:gP00T0X:gP00<000000?ooo`3oool0D`3oool00;h0oooo
00<000000:2]h02P[N002P2P[N000`000000oooo0?ooo`1B0?ooo`00_P3oool00`000000X:gP0:2]
h00:0:2]h0030000003oool0oooo0580oooo002o0?ooo`030000002P[N00X:gP00T0X:gP00<00000
0?ooo`3oool0DP3oool00;l0oooo00<000000:2]h02P[N002@2P[N000`000000oooo0?ooo`1B0?oo
o`00_`3oool00`000000X:gP0:2]h0090:2]h0030000003oool0oooo0580oooo002o0?ooo`030000
002P[N00X:gP00T0X:gP00<000000?ooo`3oool0DP3oool00;l0oooo00<000000:2]h02P[N002@2P
[N000`000000oooo0?ooo`1B0?ooo`00_`3oool00`000000X:gP0:2]h0090:2]h0030000003oool0
oooo0580oooo002o0?ooo`H000001P2P[N000`000000oooo0?ooo`1B0?ooo`00a@3oool7000005@0
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.50187 .5936 m .54262 .54857 L .52286 .53382 L p .293 .529 .908 r
F P
0 g
s
.52032 .5592 m .53709 .56032 L p .53827 .53888 L .56 .12 .159 r
F P
0 g
s
.53868 .53135 m .53452 .53765 L p .53827 .53888 L .56 .12 .159 r
F P
0 g
s
.53452 .53765 m .52032 .5592 L p .53827 .53888 L .56 .12 .159 r
F P
0 g
s
.5198 .5061 m .52439 .49142 L p .51342 .5109 L .884 .908 .501 r
F P
0 g
s
.50781 .52259 m .5073 .52871 L .51202 .53026 L .293 .529 .908 r
F
.51233 .52596 m .50781 .52259 L p .51202 .53026 L F P
0 g
s
.50781 .52259 m .46961 .56955 L .50187 .5936 L p .293 .529 .908 r
F P
0 g
s
.50083 .53325 m .51307 .51573 L p .51342 .5109 L .884 .908 .501 r
F P
0 g
s
.51307 .51573 m .5198 .5061 L p .51342 .5109 L .884 .908 .501 r
F P
0 g
s
.52286 .53382 m .51233 .52596 L p .51202 .53026 L .293 .529 .908 r
F P
0 g
s
.5073 .52871 m .50187 .5936 L .52286 .53382 L .293 .529 .908 r
F
.58068 .49927 m .68657 .35381 L .65233 .32811 L p .75 .569 .65 r
F P
0 g
s
.65233 .32811 m .54544 .47292 L .58068 .49927 L p .75 .569 .65 r
F P
0 g
s
.55631 .84224 m .66853 .70874 L .63289 .69494 L p .737 .742 .856 r
F P
0 g
s
.63289 .69494 m .521 .83014 L .55631 .84224 L p .737 .742 .856 r
F P
0 g
s
.52032 .5592 m .53868 .53135 L .52527 .52133 L p .827 .442 .322 r
F P
0 g
s
.53709 .56032 m .55498 .53239 L .53868 .53135 L p .56 .12 .159 r
F P
0 g
s
.5065 .54888 m .52527 .52133 L .5198 .5061 L p .981 .714 .448 r
F P
0 g
s
.52527 .52133 m .5065 .54888 L .52032 .5592 L p .827 .442 .322 r
F P
0 g
s
.55498 .53239 m .53709 .56032 L .55046 .55177 L p 0 0 0 r
F P
0 g
s
.55046 .55177 m .56801 .52401 L .55498 .53239 L p 0 0 0 r
F P
0 g
s
.5198 .5061 m .50083 .53325 L .5065 .54888 L p .981 .714 .448 r
F P
0 g
s
.56801 .52401 m .55046 .55177 L .5553 .53675 L p .854 .889 .461 r
F P
0 g
s
.5553 .53675 m .57276 .50935 L .56801 .52401 L p .854 .889 .461 r
F P
0 g
s
.52439 .49142 m .5055 .51821 L .50083 .53325 L p .884 .908 .501 r
F P
0 g
s
.5055 .51821 m .52439 .49142 L .53738 .48289 L p 0 0 0 r
F P
0 g
s
.57276 .50935 m .5553 .53675 L .54969 .52097 L p .983 .713 .428 r
F P
0 g
s
.54969 .52097 m .56735 .49398 L .57276 .50935 L p .983 .713 .428 r
F P
0 g
s
.51882 .5095 m .53738 .48289 L .55381 .48386 L p .547 .095 .129 r
F P
0 g
s
.53738 .48289 m .51882 .5095 L .5055 .51821 L p 0 0 0 r
F P
0 g
s
.56735 .49398 m .54969 .52097 L .53573 .51054 L p .827 .433 .302 r
F P
0 g
s
.53573 .51054 m .55381 .48386 L .56735 .49398 L p .827 .433 .302 r
F P
0 g
s
.55381 .48386 m .53573 .51054 L .51882 .5095 L p .547 .095 .129 r
F P
0 g
s
.47875 .57325 m .41955 .65116 L .43392 .65865 L p .699 .675 .823 r
F P
0 g
s
.43392 .65865 m .4933 .58108 L .47875 .57325 L p .699 .675 .823 r
F P
0 g
s
.4933 .58108 m .43392 .65865 L .44541 .6704 L p .584 .508 .735 r
F P
0 g
s
.51149 .74858 m .58893 .65253 L .5562 .63964 L p .737 .738 .852 r
F P
0 g
s
.5562 .63964 m .47899 .73681 L .51149 .74858 L p .737 .738 .852 r
F P
0 g
s
.44541 .6704 m .50514 .59293 L .4933 .58108 L p .584 .508 .735 r
F P
0 g
s
.50514 .59293 m .44541 .6704 L .4497 .68202 L p .377 .233 .555 r
F P
0 g
s
.46692 .57238 m .40763 .65073 L .41955 .65116 L p .817 .873 .887 r
F P
0 g
s
.41955 .65116 m .47875 .57325 L .46692 .57238 L p .817 .873 .887 r
F P
0 g
s
.4497 .68202 m .50984 .60439 L .50514 .59293 L p .377 .233 .555 r
F P
0 g
s
.50984 .60439 m .4497 .68202 L .44509 .68914 L p 0 0 0 r
F P
0 g
s
.46231 .57891 m .40273 .65764 L .40763 .65073 L p 0 0 0 r
F P
0 g
s
.40763 .65073 m .46692 .57238 L .46231 .57891 L p 0 0 0 r
F P
0 g
s
.44509 .68914 m .50554 .61112 L .50984 .60439 L p 0 0 0 r
F P
0 g
s
.50554 .61112 m .44509 .68914 L .43317 .68892 L p .818 .882 .891 r
F P
0 g
s
.46685 .59044 m .40686 .66935 L .40273 .65764 L p .363 .218 .547 r
F P
0 g
s
.40273 .65764 m .46231 .57891 L .46685 .59044 L p .363 .218 .547 r
F P
0 g
s
.43317 .68892 m .49371 .61046 L .50554 .61112 L p .818 .882 .891 r
F P
0 g
s
.49371 .61046 m .43317 .68892 L .41852 .68134 L p .699 .677 .825 r
F P
0 g
s
.47888 .60254 m .41852 .68134 L .40686 .66935 L p .581 .506 .736 r
F P
0 g
s
.02 w
.3973 .70776 m
.41796 .68077 L
s
.5 Mabswid
.40686 .66935 m .46685 .59044 L .47888 .60254 L p .581 .506 .736 r
F P
0 g
s
.41852 .68134 m .47888 .60254 L .49371 .61046 L p .699 .677 .825 r
F P
0 g
s
.6514 .66016 m .68724 .6869 L .70193 .66788 L p .694 .588 .733 r
F P
0 g
s
.63943 .6781 m .67546 .70497 L .68724 .6869 L p .768 .558 .615 r
F P
0 g
s
.68724 .6869 m .6514 .66016 L .63943 .6781 L p .768 .558 .615 r
F P
0 g
s
.70193 .66788 m .66605 .64109 L .6514 .66016 L p .694 .588 .733 r
F P
0 g
s
.55714 .58982 m .63795 .65012 L .65258 .63103 L p .694 .588 .733 r
F P
0 g
s
.54469 .60744 m .62591 .66802 L .63795 .65012 L p .768 .558 .615 r
F P
0 g
s
.63795 .65012 m .55714 .58982 L .54469 .60744 L p .768 .558 .615 r
F P
0 g
s
.66605 .64109 m .70193 .66788 L .71416 .65488 L p .572 .593 .836 r
F P
0 g
s
.65258 .63103 m .57167 .57062 L .55714 .58982 L p .694 .588 .733 r
F P
0 g
s
.71416 .65488 m .67802 .62788 L .66605 .64109 L p .572 .593 .836 r
F P
0 g
s
.57167 .57062 m .65258 .63103 L .66445 .61775 L p .572 .593 .836 r
F P
0 g
s
.66445 .61775 m .58297 .55688 L .57167 .57062 L p .572 .593 .836 r
F P
0 g
s
.63461 .68827 m .67099 .71539 L .67546 .70497 L p .827 .444 .326 r
F P
0 g
s
.67546 .70497 m .63943 .6781 L .63461 .68827 L p .827 .444 .326 r
F P
0 g
s
.53896 .61695 m .62097 .67809 L .62591 .66802 L p .827 .444 .326 r
F P
0 g
s
.62591 .66802 m .54469 .60744 L .53896 .61695 L p .827 .444 .326 r
F P
0 g
s
.51991 .55266 m .51385 .54814 L p .53309 .5494 L .645 .594 .783 r
F P
0 g
s
.53309 .5494 m .52726 .55315 L .51991 .55266 L p .645 .594 .783 r
F P
0 g
s
.50439 .55585 m .51385 .54814 L .51991 .55266 L p .74 .573 .667 r
F P
0 g
s
.51991 .55266 m .51533 .56401 L .50439 .55585 L p .74 .573 .667 r
F P
0 g
s
.51533 .56401 m .51991 .55266 L .52726 .55315 L p .657 .479 .632 r
F P
0 g
s
.51385 .54814 m .51137 .54129 L p .53309 .5494 L .645 .594 .783 r
F P
0 g
s
.49991 .5435 m .51137 .54129 L .51385 .54814 L p .791 .67 .731 r
F P
0 g
s
.51385 .54814 m .50439 .55585 L .49991 .5435 L p .791 .67 .731 r
F P
0 g
s
.52726 .55315 m .52858 .5649 L .51533 .56401 L p .657 .479 .632 r
F P
0 g
s
.52858 .5649 m .52726 .55315 L .53309 .5494 L p .546 .398 .632 r
F P
0 g
s
.51137 .54129 m .51343 .53473 L p .53309 .5494 L .645 .594 .783 r
F P
0 g
s
.01 w
.52394 .54106 m
.54146 .51483 L
s
.5 Mabswid
.5036 .53164 m .51343 .53473 L .51137 .54129 L p .794 .756 .818 r
F P
0 g
s
.51137 .54129 m .49991 .5435 L .5036 .53164 L p .794 .756 .818 r
F P
0 g
s
.78652 .75613 m .79292 .74796 L .69965 .6876 L closepath p .717 .622 .751 r
F P
0 g
s
.78165 .76407 m .78652 .75613 L .69965 .6876 L closepath p .796 .595 .631 r
F P
0 g
s
.49738 .56271 m .50439 .55585 L .51533 .56401 L p .79 .54 .558 r
F P
0 g
s
.51533 .56401 m .51107 .57292 L .49738 .56271 L p .79 .54 .558 r
F P
0 g
s
.51107 .57292 m .51533 .56401 L .52858 .5649 L p .644 .368 .486 r
F P
0 g
s
.49175 .54727 m .49991 .5435 L .50439 .55585 L p .885 .71 .66 r
F P
0 g
s
.50439 .55585 m .49738 .56271 L .49175 .54727 L p .885 .71 .66 r
F P
0 g
s
.67802 .62788 m .71416 .65488 L .71931 .65287 L p .037 .418 .863 r
F P
0 g
s
.79292 .74796 m .79847 .74262 L .69965 .6876 L closepath p .596 .638 .863 r
F P
0 g
s
.53271 .53597 m .53518 .54284 L .53309 .5494 L p .645 .594 .783 r
F P
0 g
s
.52663 .53142 m .53271 .53597 L p .53309 .5494 L .645 .594 .783 r
F P
0 g
s
.51926 .53095 m .52663 .53142 L p .53309 .5494 L .645 .594 .783 r
F P
0 g
s
.51343 .53473 m .51926 .53095 L p .53309 .5494 L .645 .594 .783 r
F P
0 g
s
.53913 .55816 m .53309 .5494 L .53518 .54284 L p .419 .356 .681 r
F P
0 g
s
.53309 .5494 m .53913 .55816 L .52858 .5649 L p .546 .398 .632 r
F P
0 g
s
.71931 .65287 m .68279 .62559 L .67802 .62788 L p .037 .418 .863 r
F P
0 g
s
.58297 .55688 m .66445 .61775 L .66908 .61535 L p .037 .418 .863 r
F P
0 g
s
.51411 .5248 m .51926 .53095 L .51343 .53473 L p .72 .796 .911 r
F P
0 g
s
.51343 .53473 m .5036 .53164 L .51411 .5248 L p .72 .796 .911 r
F P
0 g
s
.52858 .5649 m .52765 .57405 L .51107 .57292 L p .644 .368 .486 r
F P
0 g
s
.52765 .57405 m .52858 .5649 L .53913 .55816 L p .411 .171 .437 r
F P
0 g
s
.49635 .53242 m .5036 .53164 L .49991 .5435 L p .906 .884 .801 r
F P
0 g
s
.49991 .5435 m .49175 .54727 L .49635 .53242 L p .906 .884 .801 r
F P
0 g
s
.78017 .76877 m .78165 .76407 L .69965 .6876 L closepath p .872 .497 .331 r
F P
0 g
s
.66908 .61535 m .58674 .55384 L .58297 .55688 L p .037 .418 .863 r
F P
0 g
s
.53518 .54284 m .54292 .54631 L .53913 .55816 L p .419 .356 .681 r
F P
0 g
s
.54292 .54631 m .53518 .54284 L .53271 .53597 L p .328 .4 .784 r
F P
0 g
s
.52745 .52564 m .52663 .53142 L .51926 .53095 L p .549 .728 .958 r
F P
0 g
s
.51926 .53095 m .51411 .5248 L .52745 .52564 L p .549 .728 .958 r
F P
0 g
s
.53271 .53597 m .53847 .53387 L .54292 .54631 L p .328 .4 .784 r
F P
0 g
s
.53847 .53387 m .53271 .53597 L .52663 .53142 L p .37 .554 .904 r
F P
0 g
s
.02 w
.54047 .52077 m
.54299 .51748 L
s
.5 Mabswid
.52663 .53142 m .52745 .52564 L .53847 .53387 L p .37 .554 .904 r
F P
0 g
s
.4942 .56738 m .49738 .56271 L .51107 .57292 L p .827 .442 .322 r
F P
0 g
s
.51107 .57292 m .50796 .57764 L .4942 .56738 L p .827 .442 .322 r
F P
0 g
s
.02 w
.49882 .57516 m
.50094 .5724 L
s
.4783 .60196 m
.49882 .57516 L
s
.5 Mabswid
.50796 .57764 m .51107 .57292 L .52765 .57405 L p .56 .119 .159 r
F P
0 g
s
.48854 .55187 m .49175 .54727 L .49738 .56271 L p .981 .714 .448 r
F P
0 g
s
.49738 .56271 m .4942 .56738 L .48854 .55187 L p .981 .714 .448 r
F P
0 g
s
.79847 .74262 m .80104 .74216 L .69965 .6876 L closepath p .038 .48 .883 r
F P
0 g
s
.54085 .56563 m .53913 .55816 L .54292 .54631 L p .009 0 .415 r
F P
0 g
s
.53913 .55816 m .54085 .56563 L .52765 .57405 L p .411 .171 .437 r
F P
0 g
s
.50951 .52385 m .51411 .5248 L .5036 .53164 L p .698 .965 .938 r
F P
0 g
s
.5036 .53164 m .49635 .53242 L .50951 .52385 L p .698 .965 .938 r
F P
0 g
s
.52765 .57405 m .52461 .57878 L .50796 .57764 L p .56 .119 .159 r
F P
0 g
s
.52461 .57878 m .52765 .57405 L .54085 .56563 L p 0 0 0 r
F P
0 g
s
.40119 .46858 m .39548 .47594 L .49418 .53426 L closepath p .741 .52 .593 r
F P
0 g
s
.40739 .46019 m .40119 .46858 L .49418 .53426 L closepath p .669 .553 .715 r
F P
0 g
s
.49315 .53697 m .49635 .53242 L .49175 .54727 L p .883 .908 .5 r
F P
0 g
s
.49175 .54727 m .48854 .55187 L .49315 .53697 L p .883 .908 .5 r
F P
0 g
s
.41175 .45391 m .40739 .46019 L .49418 .53426 L closepath p .536 .547 .813 r
F P
0 g
s
.63895 .6866 m .67571 .71401 L .67099 .71539 L p 0 .382 .837 r
F P
0 g
s
.67099 .71539 m .63461 .68827 L .63895 .6866 L p 0 .382 .837 r
F P
0 g
s
.78267 .76842 m .78017 .76877 L .69965 .6876 L closepath p 0 .32 .808 r
F P
0 g
s
.54292 .54631 m .54562 .55081 L .54085 .56563 L p .009 0 .415 r
F P
0 g
s
.54562 .55081 m .54292 .54631 L .53847 .53387 L p 0 0 .426 r
F P
0 g
s
.52622 .5249 m .52745 .52564 L .51411 .5248 L p .067 .622 .815 r
F P
0 g
s
.51411 .5248 m .50951 .52385 L .52622 .5249 L p .067 .622 .815 r
F P
0 g
s
.5423 .61452 m .62516 .67631 L .62097 .67809 L p 0 .382 .837 r
F P
0 g
s
.62097 .67809 m .53896 .61695 L .5423 .61452 L p 0 .382 .837 r
F P
0 g
s
.39548 .47594 m .3924 .47949 L .49418 .53426 L closepath p .779 .371 .278 r
F P
0 g
s
.53847 .53387 m .54004 .53522 L .54562 .55081 L p 0 0 .426 r
F P
0 g
s
.54004 .53522 m .53847 .53387 L .52745 .52564 L p .45 0 0 r
F P
0 g
s
.52745 .52564 m .52622 .5249 L .54004 .53522 L p .45 0 0 r
F P
0 g
s
.54085 .56563 m .53787 .57034 L .52461 .57878 L p 0 0 0 r
F P
0 g
s
.53787 .57034 m .54085 .56563 L .54562 .55081 L p .854 .889 .461 r
F P
0 g
s
.03 w
.53936 .56798 m
.54181 .56981 L
s
.54181 .56981 m
.54395 .57141 L
s
.5 Mabswid
.80104 .74216 m .79963 .7468 L .69965 .6876 L closepath p .78 .379 .292 r
F P
0 g
s
.49553 .56891 m .4942 .56738 L .50796 .57764 L p .502 0 0 r
F P
0 g
s
.50796 .57764 m .50662 .57718 L .49553 .56891 L p .502 0 0 r
F P
0 g
s
.50662 .57718 m .50796 .57764 L .52461 .57878 L p .013 .584 .768 r
F P
0 g
s
.79473 .75482 m .78824 .7631 L .69965 .6876 L closepath p .67 .553 .714 r
F P
0 g
s
.79963 .7468 m .79473 .75482 L .69965 .6876 L closepath p .741 .521 .595 r
F P
0 g
s
.78824 .7631 m .78267 .76842 L .69965 .6876 L closepath p .54 .548 .812 r
F P
0 g
s
.03 w
.54395 .57141 m
.69965 .6876 L
s
.5 Mabswid
.57887 .44152 m .53422 .50027 L .54892 .50842 L p .699 .675 .823 r
F P
0 g
s
.54892 .50842 m .59369 .44993 L .57887 .44152 L p .699 .675 .823 r
F P
0 g
s
.59369 .44993 m .54892 .50842 L .56109 .52035 L p .584 .508 .735 r
F P
0 g
s
.49097 .55642 m .48854 .55187 L .4942 .56738 L p 0 0 .378 r
F P
0 g
s
.4942 .56738 m .49553 .56891 L .49097 .55642 L p 0 0 .378 r
F P
0 g
s
.50636 .52837 m .50951 .52385 L .49635 .53242 L p 0 0 0 r
F P
0 g
s
.49635 .53242 m .49315 .53697 L .50636 .52837 L p 0 0 0 r
F P
0 g
s
.03 w
.49564 .53535 m
.53893 .56766 L
s
.5 Mabswid
.4126 .45214 m .41175 .45391 L .49418 .53426 L closepath p 0 .301 .795 r
F P
0 g
s
.52461 .57878 m .52004 .57811 L .50662 .57718 L p .013 .584 .768 r
F P
0 g
s
.52004 .57811 m .52461 .57878 L .53787 .57034 L p .681 .967 .93 r
F P
0 g
s
.56109 .52035 m .60614 .46193 L .59369 .44993 L p .584 .508 .735 r
F P
0 g
s
.02 w
.58595 .46138 m
.58744 .45943 L
s
.5 Mabswid
.60614 .46193 m .56109 .52035 L .5662 .53164 L p .377 .233 .555 r
F P
0 g
s
.49469 .54442 m .49315 .53697 L .48854 .55187 L p 0 0 .39 r
F P
0 g
s
.48854 .55187 m .49097 .55642 L .49469 .54442 L p 0 0 .39 r
F P
0 g
s
.56719 .43986 m .52247 .49897 L .53422 .50027 L p .817 .873 .887 r
F P
0 g
s
.53422 .50027 m .57887 .44152 L .56719 .43986 L p .817 .873 .887 r
F P
0 g
s
.68279 .62559 m .71931 .65287 L .7152 .66293 L p .827 .431 .298 r
F P
0 g
s
.40957 .45561 m .4126 .45214 L .49418 .53426 L closepath p .871 .502 .344 r
F P
0 g
s
.4038 .46304 m .40957 .45561 L .49418 .53426 L closepath p .794 .595 .632 r
F P
0 g
s
.39752 .47155 m .4038 .46304 L .49418 .53426 L closepath p .717 .621 .75 r
F P
0 g
s
.39316 .47783 m .39752 .47155 L .49418 .53426 L closepath p .599 .638 .861 r
F P
0 g
s
.3924 .47949 m .39316 .47783 L .49418 .53426 L closepath p .07 .496 .895 r
F P
0 g
s
.03 w
.49418 .53426 m
.49475 .53469 L
s
.5 Mabswid
.54562 .55081 m .54265 .55546 L .53787 .57034 L p .854 .889 .461 r
F P
0 g
s
.54265 .55546 m .54562 .55081 L .54004 .53522 L p .983 .713 .429 r
F P
0 g
s
.7152 .66293 m .67832 .63539 L .68279 .62559 L p .827 .431 .298 r
F P
0 g
s
.58674 .55384 m .66908 .61535 L .66448 .62506 L p .827 .431 .298 r
F P
0 g
s
.52315 .52943 m .52622 .5249 L .50951 .52385 L p .547 .095 .129 r
F P
0 g
s
.50951 .52385 m .50636 .52837 L .52315 .52943 L p .547 .095 .129 r
F P
0 g
s
.66448 .62506 m .58134 .56297 L .58674 .55384 L p .827 .431 .298 r
F P
0 g
s
.7212 .64608 m .84663 .49686 L .81064 .48018 L p .737 .742 .856 r
F P
0 g
s
.81064 .48018 m .68544 .63145 L .7212 .64608 L p .737 .742 .856 r
F P
0 g
s
.53071 .5713 m .53787 .57034 L .54265 .55546 L p .91 .893 .801 r
F P
0 g
s
.53787 .57034 m .53071 .5713 L .52004 .57811 L p .681 .967 .93 r
F P
0 g
s
.54004 .53522 m .53704 .5398 L .54265 .55546 L p .983 .713 .429 r
F P
0 g
s
.53704 .5398 m .54004 .53522 L .52622 .5249 L p .827 .433 .302 r
F P
0 g
s
.02 w
.53707 .52522 m
.54047 .52077 L
s
.5 Mabswid
.52622 .5249 m .52315 .52943 L .53704 .5398 L p .827 .433 .302 r
F P
0 g
s
.02 w
.53322 .53023 m
.53707 .52522 L
s
.53162 .53234 m
.53322 .53023 L
s
.5 Mabswid
.50533 .53752 m .50636 .52837 L .49315 .53697 L p .397 .154 .424 r
F P
0 g
s
.49315 .53697 m .49469 .54442 L .50533 .53752 L p .397 .154 .424 r
F P
0 g
s
.50117 .56695 m .49553 .56891 L .50662 .57718 L p .35 .548 .906 r
F P
0 g
s
.50662 .57718 m .50736 .57157 L .50117 .56695 L p .35 .548 .906 r
F P
0 g
s
.02 w
.50368 .56882 m
.52995 .53451 L
s
.5 Mabswid
.50736 .57157 m .50662 .57718 L .52004 .57811 L p .538 .731 .963 r
F P
0 g
s
.49863 .55999 m .49097 .55642 L .49553 .56891 L p .309 .389 .783 r
F P
0 g
s
.49553 .56891 m .50117 .56695 L .49863 .55999 L p .309 .389 .783 r
F P
0 g
s
.6429 .58558 m .72764 .48048 L .69456 .46549 L p .737 .738 .852 r
F P
0 g
s
.69456 .46549 m .61002 .57189 L .6429 .58558 L p .737 .738 .852 r
F P
0 g
s
.52004 .57811 m .51484 .57208 L .50736 .57157 L p .538 .731 .963 r
F P
0 g
s
.51484 .57208 m .52004 .57811 L .53071 .5713 L p .718 .802 .917 r
F P
0 g
s
.50071 .55332 m .49469 .54442 L .49097 .55642 L p .408 .347 .678 r
F P
0 g
s
.49097 .55642 m .49863 .55999 L .50071 .55332 L p .408 .347 .678 r
F P
0 g
s
.5662 .53164 m .61157 .47307 L .60614 .46193 L p .377 .233 .555 r
F P
0 g
s
.61157 .47307 m .5662 .53164 L .56219 .53801 L p 0 0 0 r
F P
0 g
s
.54265 .55546 m .53454 .55932 L .53071 .5713 L p .91 .893 .801 r
F P
0 g
s
.53454 .55932 m .54265 .55546 L .53704 .5398 L p .889 .713 .657 r
F P
0 g
s
.56313 .44568 m .51816 .50511 L .52247 .49897 L p 0 0 0 r
F P
0 g
s
.52247 .49897 m .56719 .43986 L .56313 .44568 L p 0 0 0 r
F P
0 g
s
.65101 .67342 m .68804 .70104 L .67571 .71401 L p .565 .593 .841 r
F P
0 g
s
.67571 .71401 m .63895 .6866 L .65101 .67342 L p .565 .593 .841 r
F P
0 g
s
.51884 .53839 m .52315 .52943 L .50636 .52837 L p .641 .361 .479 r
F P
0 g
s
.50636 .52837 m .50533 .53752 L .51884 .53839 L p .641 .361 .479 r
F P
0 g
s
.55364 .60078 m .63712 .66305 L .62516 .67631 L p .565 .593 .841 r
F P
0 g
s
.62516 .67631 m .5423 .61452 L .55364 .60078 L p .565 .593 .841 r
F P
0 g
s
.52077 .56828 m .53071 .5713 L .53454 .55932 L p .796 .761 .821 r
F P
0 g
s
.53071 .5713 m .52077 .56828 L .51484 .57208 L p .718 .802 .917 r
F P
0 g
s
.50664 .54949 m .50533 .53752 L .49469 .54442 L p .541 .393 .629 r
F P
0 g
s
.49469 .54442 m .50071 .55332 L .50664 .54949 L p .541 .393 .629 r
F P
0 g
s
.53704 .5398 m .53001 .54673 L .53454 .55932 L p .889 .713 .657 r
F P
0 g
s
.53001 .54673 m .53704 .5398 L .52315 .52943 L p .792 .538 .554 r
F P
0 g
s
.52315 .52943 m .51884 .53839 L .53001 .54673 L p .792 .538 .554 r
F P
0 g
s
.50736 .57157 m .51484 .57208 L p .52289 .56161 L .643 .594 .785 r
F P
0 g
s
.50117 .56695 m .50736 .57157 L p .52289 .56161 L .643 .594 .785 r
F P
0 g
s
.49863 .55999 m .50117 .56695 L p .52289 .56161 L .643 .594 .785 r
F P
0 g
s
.01 w
.50562 .56847 m
.50828 .56449 L
s
.5 Mabswid
.51484 .57208 m .52077 .56828 L .52289 .56161 L p .643 .594 .785 r
F P
0 g
s
.50071 .55332 m .49863 .55999 L p .52289 .56161 L .643 .594 .785 r
F P
0 g
s
.01 w
.51274 .55782 m
.52326 .54207 L
s
.5 Mabswid
.53454 .55932 m .52289 .56161 L .52077 .56828 L p .796 .761 .821 r
F P
0 g
s
.52289 .56161 m .53454 .55932 L .53001 .54673 L p .793 .673 .731 r
F P
0 g
s
.67832 .63539 m .7152 .66293 L .70321 .68141 L p .77 .557 .611 r
F P
0 g
s
.51415 .54999 m .51884 .53839 L .50533 .53752 L p .655 .476 .63 r
F P
0 g
s
.50533 .53752 m .50664 .54949 L .51415 .54999 L p .655 .476 .63 r
F P
0 g
s
.70321 .68141 m .66614 .65374 L .67832 .63539 L p .77 .557 .611 r
F P
0 g
s
.50664 .54949 m .50071 .55332 L p .52289 .56161 L .643 .594 .785 r
F P
0 g
s
.58134 .56297 m .66448 .62506 L .65223 .64336 L p .77 .557 .611 r
F P
0 g
s
.53001 .54673 m .52036 .55462 L .52289 .56161 L p .793 .673 .731 r
F P
0 g
s
.52036 .55462 m .53001 .54673 L .51884 .53839 L p .741 .573 .666 r
F P
0 g
s
.51884 .53839 m .51415 .54999 L .52036 .55462 L p .741 .573 .666 r
F P
0 g
s
.51415 .54999 m .50664 .54949 L p .52289 .56161 L .643 .594 .785 r
F P
0 g
s
.01 w
.50828 .56449 m
.51074 .5608 L
s
.5 Mabswid
.52289 .56161 m .52036 .55462 L .51415 .54999 L p .643 .594 .785 r
F P
0 g
s
.65223 .64336 m .56865 .58097 L .58134 .56297 L p .77 .557 .611 r
F P
0 g
s
.56219 .53801 m .60782 .47912 L .61157 .47307 L p 0 0 0 r
F P
0 g
s
.60782 .47912 m .56219 .53801 L .55046 .53691 L p .818 .882 .891 r
F P
0 g
s
.56839 .45688 m .52309 .51646 L .51816 .50511 L p .363 .218 .547 r
F P
0 g
s
.51816 .50511 m .56313 .44568 L .56839 .45688 L p .363 .218 .547 r
F P
0 g
s
.47698 .62496 m .49793 .59317 L .48361 .58249 L p .827 .442 .322 r
F P
0 g
s
.49793 .59317 m .47698 .62496 L .49483 .62628 L p .56 .12 .159 r
F P
0 g
s
.49483 .62628 m .51526 .59439 L .49793 .59317 L p .56 .12 .159 r
F P
0 g
s
.46218 .61394 m .48361 .58249 L .47768 .56637 L p .981 .714 .448 r
F P
0 g
s
.48361 .58249 m .46218 .61394 L .47698 .62496 L p .827 .442 .322 r
F P
0 g
s
.66614 .65374 m .70321 .68141 L .68804 .70104 L p .693 .588 .733 r
F P
0 g
s
.68804 .70104 m .65101 .67342 L .66614 .65374 L p .693 .588 .733 r
F P
0 g
s
.56865 .58097 m .65223 .64336 L .63712 .66305 L p .693 .588 .733 r
F P
0 g
s
.63712 .66305 m .55364 .60078 L .56865 .58097 L p .693 .588 .733 r
F P
0 g
s
.51526 .59439 m .49483 .62628 L .50899 .61736 L p 0 0 0 r
F P
0 g
s
.50899 .61736 m .52904 .58565 L .51526 .59439 L p 0 0 0 r
F P
0 g
s
.45602 .59737 m .47768 .56637 L .48245 .55089 L p .884 .908 .501 r
F P
0 g
s
.47768 .56637 m .45602 .59737 L .46218 .61394 L p .981 .714 .448 r
F P
0 g
s
.55046 .53691 m .59617 .47766 L .60782 .47912 L p .818 .882 .891 r
F P
0 g
s
.59617 .47766 m .55046 .53691 L .53547 .52866 L p .699 .677 .825 r
F P
0 g
s
.52904 .58565 m .50899 .61736 L .51403 .6015 L p .854 .889 .461 r
F P
0 g
s
.51403 .6015 m .53399 .57019 L .52904 .58565 L p .854 .889 .461 r
F P
0 g
s
.58105 .46915 m .53547 .52866 L .52309 .51646 L p .581 .506 .736 r
F P
0 g
s
.52309 .51646 m .56839 .45688 L .58105 .46915 L p .581 .506 .736 r
F P
0 g
s
.02 w
.58045 .46856 m
.58595 .46138 L
s
.5 Mabswid
.48245 .55089 m .46087 .58149 L .45602 .59737 L p .884 .908 .501 r
F P
0 g
s
.46087 .58149 m .48245 .55089 L .49618 .54197 L p 0 0 0 r
F P
0 g
s
.53547 .52866 m .58105 .46915 L .59617 .47766 L p .699 .677 .825 r
F P
0 g
s
.53399 .57019 m .51403 .6015 L .50793 .58476 L p .983 .713 .428 r
F P
0 g
s
.50793 .58476 m .52812 .55391 L .53399 .57019 L p .983 .713 .428 r
F P
0 g
s
.47498 .57238 m .49618 .54197 L .51365 .54311 L p .547 .095 .129 r
F P
0 g
s
.49618 .54197 m .47498 .57238 L .46087 .58149 L p 0 0 0 r
F P
0 g
s
.52812 .55391 m .50793 .58476 L .49298 .57361 L p .827 .433 .302 r
F P
0 g
s
.01 w
.47242 .61816 m
.49912 .57819 L
s
.5 Mabswid
.49298 .57361 m .51365 .54311 L .52812 .55391 L p .827 .433 .302 r
F P
0 g
s
.51365 .54311 m .49298 .57361 L .47498 .57238 L p .547 .095 .129 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00^`3oool00`000000oooo0?oo
o`1R0?ooo`00^P3oool010000000_i6V00000000001R0?ooo`00^@3oool00`000000_i6V0;nAYP02
0;nAYP030000003oool0oooo05l0oooo002i0?ooo`030000002oTJH0_i6V00<0_i6V00<000000?oo
o`3oool0GP3oool00;P0oooo00<000000;nAYP2oTJH01@2oTJH2000005h0oooo002g0?ooo`030000
002oTJH0_i6V00P0_i6V00<000000?ooo`3oool0F`3oool00;H0oooo00<000000;nAYP2oTJH02P2o
TJH2000005/0oooo002f0?ooo`030000002oTJH0_i6V00`0_i6V00<000000?ooo`3oool0F03oool0
0;D0oooo00<000000;nAYP2oTJH0302oTJH00`000000oooo0?ooo`1I0?ooo`00]03oool00`000000
_i6V0;nAYP0=0;nAYP030000003oool0oooo05T0oooo002c0?ooo`030000002oTJH0_i6V00d0_i6V
00<000000?ooo`3oool0FP3oool00;<0oooo00<000000;nAYP2oTJH0302oTJH00`000000oooo0?oo
o`1K0?ooo`00/P3oool00`000000_i6V0;nAYP0<0;nAYP030000003oool0oooo05`0oooo002a0?oo
o`030000002oTJH0_i6V00d0_i6V00<000000?ooo`3oool0G03oool00;00oooo00<000000;nAYP2o
TJH03@2oTJH00`000000oooo0?ooo`1M0?ooo`00/03oool00`000000_i6V0;nAYP0<0;nAYP030000
003oool0oooo05h0oooo002_0?ooo`030000002oTJH0_i6V00`0_i6V00<000000?ooo`3oool0G`3o
ool00:h0oooo00<000000;nAYP2oTJH03@2oTJH00`000000oooo0?ooo`1O0?ooo`00[@3oool00`00
0000_i6V0;nAYP0=0;nAYP030000003oool0oooo0600oooo002]0?ooo`030000002oTJH0_i6V00`0
_i6V00<000000?ooo`3oool0H@3oool00:`0oooo00<000000;nAYP2oTJH0302oTJH00`000000oooo
0?ooo`1R0?ooo`00Z`3oool00`000000_i6V0;nAYP0=0;nAYP030000003oool0oooo0680oooo002Z
0?ooo`030000002oTJH0_i6V00d0_i6V00<000000?ooo`3oool0H`3oool00:X0oooo00<000000;nA
YP2oTJH0302oTJH00`000000oooo0?ooo`1T0?ooo`00Z@3oool00`000000_i6V0;nAYP0<0;nAYP03
0000003oool0oooo06D0oooo002X0?ooo`030000002oTJH0_i6V00d0_i6V00<000000?ooo`3oool0
I@3oool00:L0oooo00<000000;nAYP2oTJH03@2oTJH00`000000oooo0?ooo`1V0?ooo`00Y`3oool0
0`000000_i6V0;nAYP0<0;nAYP030000003oool0oooo06L0oooo002V0?ooo`030000002oTJH0_i6V
00d0_i6V00<000000?ooo`3oool0I`3oool00:D0oooo00<000000;nAYP2oTJH03@2oTJH00`000000
oooo0?ooo`1X0?ooo`00Y03oool00`000000_i6V0;nAYP0=0;nAYP030000003oool0oooo06T0oooo
002T0?ooo`030000002oTJH0_i6V00`0_i6V00<000000?ooo`3oool0JP3oool00:80oooo1@00000<
0;nAYP030000003oool0oooo06X0oooo002Q0?ooo`070000003Agn<0dMoS0=7Oh`000000/ZcB0000
000:0;nAYP030000003oool0oooo06/0oooo002P0?ooo`8000000P3Agn<010000000/ZcB0;:/dP2b
[=82000000L0_i6V00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool09P3oool0
1`000000G3N<05`gS0000000dMoS0000002b[=801@0000050;nAYP030000003oool0oooo06d0oooo
001e0?ooo`030000003NP5P0000002L0oooo00<0000005`gS01L=h`00P0000020;:/dPH00000102o
TJH00`000000oooo0?ooo`1]0?ooo`00M03oool01@000000biRQ0000003NP5P0000002D0oooo00<0
000005`gS01L=h`00P1L=h`00`000000/ZcB0;:/dP050000000509F2_0000000_i6V0;nAYP000000
L03oool007<0oooo00L000000<^HX@3;V:40biRQ0000003NP5P0000002<0oooo00<0000005`gS01L
=h`00P1L=h`00`000000U86l000000070000000309F2_000000000000740oooo001c0?ooo`800000
0`3;V:400`000000gX1H0000000Q0?ooo`030000001L=h`0G3N<0080G3N<00<0000009B1_02DPK`0
1`000000102EP[`00000060kSP00000H0?ooo`800000E`3oool00780oooo00<000000;NN_`2gW[l0
0P0000020<^HX@030000003NP5P000000200oooo00<0000005`gS01L=h`00P1L=h`00`000000U86l
000000070000000409F2_01P>hh0H3^>000001L0oooo00<000000;blfP2l_=X00P00001E0?ooo`00
LP3oool00`000000]ijo0;NN_`020;NN_`060000003;V:40biRQ0000003NP5P000007P3oool00`00
0000G3N<05`gS00205`gS0040000002DPK`0U86l09B1_080000000<0/ZgC0000000000000P2EP[`0
1@000000H3^>060kSP1P>hh0000001D0oooo00<000000;blfP2l_=X00`2l_=X2000005<0oooo001a
0?ooo`040000002IXm`00000000000<0]ijo00H000000<^HX@3;V:4000000=j0F000000L0?ooo`03
0000001L=h`0G3N<0080G3N<00<0000009B1_02DPK`00P2DPK`00`000000/ZgC0;:]d`020;:]d`80
00000`1P>hh2000001D0oooo00<000000;blfP2l_=X01@2l_=X200000540oooo001`0?ooo`030000
002IXm`0VJ?L0080VJ?L00D000000;NN_`2gW[l0]ijo000000020<^HX@030000003NP5P0000001X0
oooo00<0000005`gS01L=h`00P1L=h`00`000000U86l09B1_00309B1_0030000002b[M<0/ZgC00@0
/ZgC1000000E0?ooo`030000002l_=X0_;cJ00P0_;cJ0P00000G0?ooo`030000003oool0oooo03D0
oooo001a0?ooo`8000000`2IXm`200000080]ijo0P000000103;V:4000000=j0F000000I0?ooo`03
0000001L=h`0G3N<0080G3N<00<0000009B1_02DPK`00P2DPK`00`000000/ZgC0;:]d`040;:]d`04
0000003AhN@0dN7T000001D0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0E0?oo
o`040000002l_M/00000000003D0oooo001c0?ooo`8000000`2IXm`02@000000]ijo0;NN_`2gW[l0
00000<^HX@000000gX1H0000000G0?ooo`030000001L=h`0G3N<0080G3N<00<0000009B1_02DPK`0
0P2DPK`00`000000/ZgC0;:]d`040;:]d`040000003AhN@0dN7T000001D0oooo00<000000;blfP2l
_=X02@2l_=X00`000000oooo0?ooo`0E0?ooo`030000002l_M/0_;gK0080_;gK0P00000c0?ooo`00
M@3oool200000080VJ?L0P0000020;NN_`050000003;V:4000000=j0F00000005@3oool00`000000
G3N<05`gS00205`gS0030000002DPK`0U86l0080U86l00<000000;:]d`2b[M<01@2b[M<010000000
dN7T0=7Qi000000E0?ooo`030000002l_=X0_;cJ00T0_;cJ00<000000?ooo`3oool05@3oool00`00
0000_;gK0;bmf`040;bmf`800000<@3oool007L0oooo0P00000209VSg0050000002gW[l0]ijo0000
003;V:400P00000D0?ooo`030000001L=h`0G3N<0080G3N<00<0000009B1_02DPK`00`2DPK`00`00
0000/ZgC0;:]d`040;:]d`040000003AhN@0dN7T000001D0oooo00<000000;blfP2l_=X02@2l_=X0
0`000000oooo0?ooo`0E0?ooo`030000002l_M/0_;gK00L0_;gK0P00000_0?ooo`00N@3oool00`00
0000VJ?L09VSg002000000030;NN_`000000biRQ008000004P3oool2000000@0G3N<00<0000009B1
_02DPK`00P2DPK`00`000000/ZgC0;:]d`040;:]d`040000003AhN@0dN7T000001D0oooo00<00000
0;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0E0?ooo`030000002l_M/0_;gK00X0_;gK0P00000]
0?ooo`00NP3oool200000080VJ?L00H000000;NN_`00000000000<^HX@00000A0?ooo`030000001L
=h`0G3N<0080G3N<00<0000009B1_02DPK`00P2DPK`00`000000/ZgC0;:]d`040;:]d`040000003A
hN@0dN7T000001D0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0E0?ooo`030000
002l_M/0_;gK00/0_;gK00<000000?ooo`3oool0;03oool007`0oooo0P0000001`2IXm`000000000
002gW[l000000<^HX@0000003`3oool00`000000G3N<05`gS00205`gS0030000002DPK`0U86l0080
U86l00<000000;:]d`2b[M<0102b[M<01@000000dN7T0=7Qi03AhN@0000001@0oooo00<000000;bl
fP2l_=X02P2l_=X00`000000oooo0?ooo`0D0?ooo`030000002l_M/0_;gK00/0_;gK00<000000?oo
o`3oool0;@3oool007h0oooo0P0000001P2IXm`000000;NN_`000000biRQ000000d0oooo0P000003
05`gS0030000002DPK`0U86l00<0U86l00<000000;:]d`2b[M<00`2b[M<01@000000dN7T0=7Qi03A
hN@0000001D0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0D0?ooo`030000002l
_M/0_;gK00/0_;gK00<000000?ooo`3oool0;P3oool00800oooo1@0000000`3;V:4000000?ooo`0:
0?ooo`@000000P1L=h`00`000000U86l09B1_00209B1_0030000002b[M<0/ZgC00@0/ZgC00@00000
0=7Qi03AhN@000005@3oool00`000000_;cJ0;blfP090;blfP030000003oool0oooo01D0oooo00<0
00000;bmf`2l_M/02`2l_M/00`000000oooo0?ooo`0^0?ooo`00PP3oool6000000X0oooo10000000
0`1L=h`0000009B1_00309B1_0030000002b[M<0/ZgC00@0/ZgC00@000000=7Qi03AhN@000005@3o
ool00`000000_;cJ0;blfP090;blfP030000003oool0oooo01D0oooo00<000000;bmf`2l_M/02`2l
_M/00`000000oooo0?ooo`0_0?ooo`00Q03oool5000000@0oooo00L000000?ooo`3oool0oooo0000
003Rj80000000080nkIb00<0000009B1_02DPK`00P2DPK`00`000000/ZgC0;:]d`040;:]d`050000
003AhN@0dN7T0=7Qi0000000503oool00`000000_;cJ0;blfP090;blfP030000003oool0oooo01D0
oooo00<000000;bmf`2l_M/02`2l_M/00`000000oooo0?ooo`0`0?ooo`00Q@3oool500000080oooo
100000000`3oool00000000000030?^fLP8000000`2DPK`00`000000/ZgC0;:]d`030;:]d`050000
003AhN@0dN7T0=7Qi00000005@3oool00`000000_;cJ0;blfP090;blfP030000003oool0oooo01@0
oooo00<000000;bmf`2l_M/02`2l_M/00`000000oooo0?ooo`0a0?ooo`00Q`3ooolB0000000309B1
_0000000/ZgC00@0/ZgC00D000000=7Qi03AhN@0dN7T0000000E0?ooo`030000002l_=X0_;cJ00T0
_;cJ00<000000?ooo`3oool0503oool00`000000_;gK0;bmf`0;0;bmf`030000003oool0oooo0380
oooo00290?oooa4000001@2b[M<01@000000dN7T0=7Qi03AhN@0000001D0oooo00<000000;blfP2l
_=X02@2l_=X00`000000oooo0?ooo`0E0?ooo`030000002l_M/0_;gK00X0_;gK00<000000?ooo`3o
ool0<`3oool008T0oooo2@0000030:ALNP030000003:RHd0000000<00000102b[M<01@000000dN7T
0=7Qi03AhN@0000001@0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0E0?ooo`03
0000002l_M/0_;gK00/0_;gK00<000000?ooo`3oool0<`3oool008T0oooo1P00000206DWK0050000
002TG7X0Y5aj0:ALNP0000000P3:RHd5000000030;:]d`000000dN7T0080dN7T00<000000?ooo`3o
ool04`3oool00`000000_;cJ0;blfP090;blfP030000003oool0oooo01@0oooo00<000000;bmf`2l
_M/02`2l_M/00`000000oooo0?ooo`0d0?ooo`00R@3oool500000080IBM/1@0000000`3:RHd00000
0<Z9S@020<Z9S@80000000<0SahX0000000000000`00000E0?ooo`030000002l_=X0_;cJ00T0_;cJ
00<000000?ooo`3oool0503oool00`000000_;gK0;bmf`0;0;bmf`030000003oool0oooo03D0oooo
00290?ooo`l0000000D0bXV=000000000000000008lN:003000001H0oooo00<000000;blfP2l_=X0
2@2l_=X00`000000oooo0?ooo`0D0?ooo`030000002l_M/0_;gK00/0_;gK00<000000?ooo`3oool0
=P3oool008T0oooo1@00000408`H8@030000003CKTd000000080_I:Z0P000000103S]ZP000000000
002?7RP3000001D0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0D0?ooo`030000
002l_M/0_;gK00/0_;gK00<000000?ooo`3oool0=`3oool008T0oooo1@00000408`H8@030000003C
KTd0dfi=00@000000P3S]ZP4000001D0oooo00<000000;blfP2l_=X02P2l_=X00`000000oooo0?oo
o`0D0?ooo`030000002l_M/0_;gK00X0_;gK00<000000?ooo`3oool0>03oool008X0oooo0`000004
08`H8@030000003CKTd0dfi=00<0dfi=0P0000020>>fZ0<000002P3oool00`000000oooo0?ooo`09
0?ooo`030000002l_=X0_;cJ00T0_;cJ00<000000?ooo`3oool0503oool00`000000_;gK0;bmf`0;
0;bmf`030000003oool0oooo03P0oooo00290?ooo`<00000102<62400`000000dfi=0==^C@030==^
C@80000000<0bjbk0000000000000`0000090?ooo`030000003CKT`0dfi<00T0oooo00<000000;bl
fP2l_=X02@2l_=X00`000000oooo0?ooo`0D0?ooo`030000002l_M/0_;gK00/0_;gK00<000000?oo
o`3oool0>@3oool008P0oooo1000000408`H8@030000003CKTd0dfi=00<0dfi=00D000000?^fK@00
000000000>STc@05000000H0oooo0P0000030==^C0030000003oool0oooo00@0oooo00<000000;bl
fP2l_=X02@2l_=X00`000000oooo0?ooo`0D0?ooo`030000002l_M/0_;gK00/0_;gK00<000000?oo
o`3oool0>P3oool008P0oooo0`00000408`H8@030000003CKTd0dfi=00<0dfi=00<000000?^fK@3k
]Vd00P0000000`3Xi<d0000000000003000000H0oooo00<000000==^C03CKT`00`3CKT`00`000000
oooo0?ooo`020?ooo`030000002l_=X0_;cJ00T0_;cJ00<000000?ooo`3oool0503oool00`000000
_;gK0;bmf`0;0;bmf`030000003oool0oooo03/0oooo00270?ooo`<00000102<62400`000000dfi=
0==^C@030==^C@030000003k]Vd0nkI]0080nkI]2@0000030?ooo`0300000035SY`0000000D0dfi<
00D000000?ooo`3oool0oooo0000000;0;blfP030000003oool0oooo01@0oooo00<000000;bmf`2l
_M/02P2l_M/00`000000oooo0?ooo`0l0?ooo`00QP3oool4000000@0S1PQ00<000000==^C@3CKTd0
0`3CKTd00`000000nkI]0?^fK@020?^fK@X0000000<0oooo0000000000000P35SY`2000000@0dfi<
0`00000;0;blfP030000003oool0oooo01@0oooo00<000000;bmf`2l_M/02P2l_M/00`000000oooo
0?ooo`0m0?ooo`00QP3oool8000000030==^C@000000dfi=0080dfi=00<000000?^fK@3k]Vd00P3k
]Vd=000000D0aHjL00<000000==^C03CKT`00P3CKT`2000000X0_;cJ00<000000?ooo`3oool0503o
ool00`000000_;gK0;bmf`0;0;bmf`030000003oool0oooo03d0oooo00250?ooo`<000000P3k]W87
000000030==^C@000000nkI]00@0nkI]3@0000060<F>W0030000003CKT`0dfi<00<0dfi<0P000007
0;blfP030000003oool0oooo01@0oooo00<000000;bmf`2l_M/02`2l_M/00`000000oooo0?ooo`0n
0?ooo`00Q03oool00`000000h^R0000000030?^fLPL0000000<0dfi=0000003k]Vd00`3k]Vd=0000
00P0aHjL0P0000040==^C0<000001@2l_=X00`000000oooo0?ooo`0C0?ooo`030000002l_M/0_;gK
00/0_;gK00<000000?ooo`3oool0?`3oool008<0oooo0`0000040?^fLPP00000103k]Vd=00000003
0;6F^`000000aHjL00P0aHjL00<000000==^C03CKT`00`3CKT`300000080_;cJ00<000000?ooo`3o
ool04`3oool00`000000_;gK0;bmf`0;0;bmf`030000003oool0oooo0400oooo00220?ooo`<00000
103k]W800`000000dg5B000000040000000304^7j0000000nkI]00<0nkI]0P0000040?ooo`H00000
0`2aU[/2000000P0aHjL00<000000==^C03CKT`00`3CKT`010000000oooo00000000000F0?ooo`03
0000002l_M/0_;gK00X0_;gK00<000000?ooo`3oool0@@3oool00880oooo0`0000040?^fLP030000
003CLE80dg5B00@0000000<0BhOX0000000000000P3k]Vd2000000L0oooo100000050;6F^`030000
0035SY`0aHjL00H0aHjL0P0000040==^C08000005P3oool00`000000_;gK0;bmf`0:0;bmf`030000
003oool0oooo0480oooo00210?ooo`<00000103k]W800`000000dg5B0==aDP02000000030==aDP00
0000000000<0000000@0nkI]0000003JhgH000001`3oool3000000L0/IJk00<000000<F>W035SY`0
1`35SY`00`000000dfi<0==^C0030==^C0030000003oool0oooo0180oooo00<000000;bmf`2l_M/0
2`2l_M/00`000000oooo0?ooo`120?ooo`00P03oool00`000000G3N<000000040?^fLP030000003C
LE80dg5B00@00000102?7RP4000000P0oooo0P0000090;6F^`8000002035SY`00`000000dfi<0==^
C0030==^C0030000003oool0oooo0100oooo00<000000;bmf`2l_M/02`2l_M/00`000000oooo0?oo
o`130?ooo`00O`3oool010000000G3N<05`gS00000040?^fLP030000003CLE80dg5B0080000000<0
dg5B0000002?7RP00`2?7RP2000000030=[SMP000000oooo00H0oooo0P00000<0;6F^`0300000035
SY`0aHjL00H0aHjL0P0000040==^C08000003`3oool00`000000_;gK0;bmf`0;0;bmf`030000003o
ool0oooo04@0oooo001o0?ooo`030000001L=h`0G3N<008000000P3k]W800`000000dg5B0==aDP02
000000030==aDP000000SahX00<0SahX100000080?ooo`030000002@UmL0000000`0/IJk00<00000
0<F>W035SY`01`35SY`00`000000dfi<0==^C0030==^C0030000003oool0oooo00`0oooo00<00000
0;bmf`2l_M/02P2l_M/00`000000oooo0?ooo`150?ooo`00OP3oool020000000G3N<05`gS0000000
U86l0000003k]W8000000P3CLE84000000D0SahX100000070?ooo`8000000P2@UmL2000000/0/IJk
0P0000080<F>W0030000003CKT`0dfi<00<0dfi<00<000000?ooo`3oool02P3oool00`000000_;gK
0;bmf`0:0;bmf`030000003oool0oooo04H0oooo001m0?ooo`050000001L=h`0G3N<05`gS0000000
0P2DPK`200000080dg5B0P0000000`3CLE80000008lN:00308lN:0@000001`3oool2000000D0T9OG
00<000000;6F^`2aU[/02P2aU[/00`000000aHjL0<F>W0060<F>W0800000103CKT`2000000T0oooo
00<000000;bmf`2l_M/02P2l_M/00`000000oooo0?ooo`170?ooo`00O03oool01@000000G3N<05`g
S01L=h`0000000<0U86l00<000000==aDP3CLE800P0000000`3CLE80000008lN:00408lN:0@00000
1`3oool00`000000T9OG092Ge`05092Ge`030000002aU[/0/IJk00X0/IJk00<000000<F>W035SY`0
1`35SY`00`000000dfi<0==^C0030==^C0030000003oool0oooo00D0oooo00<000000;bmf`2l_M/0
2`2l_M/00`000000oooo0?ooo`170?ooo`00O03oool010000000G3N<05`gS000000509B1_0D00000
1@2?7RP4000000L0oooo00<00000001QeP0000001`2@UmL2000000/0/IJk0P0000080<F>W0050000
003CKT`0dfi<0==^C00000001`3oool00`000000_;gK0;bmf`0;0;bmf`030000003oool0oooo04P0
oooo001k0?ooo`040000001L=h`0G3N<000000H0U86l0`0000000`3CLE80000008lN:00408lN:080
00002P3oool4000000L0T9OG00<000000;6F^`2aU[/02P2aU[/00`000000aHjL0<F>W0060<F>W080
000000<0dfi<0000003oool01@3oool00`000000_;gK0;bmf`0;0;bmf`030000003oool0oooo04T0
oooo001j0?ooo`050000001L=h`0G3N<05`gS00000001@2DPK`010000000/ZgC0;:]d`2b[M<70000
00h0oooo00<00000001QeP0000001`2@UmL00`000000/IJk0;6F^`0:0;6F^`0300000035SY`0aHjL
00L0aHjL00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00000<0;bmf`030000003oool0
oooo04X0oooo001i0?ooo`050000001L=h`0G3N<05`gS00000001@2DPK`00`000000/ZgC0;:]d`03
0;:]d`050000003AhN@0dN7T0=7Qi0000000403oool00`000000067F00000007092Ge`8000002`2a
U[/2000000H0aHjL00<000000?ooo`3oool00P3oool4000000`0_;gK00<000000?ooo`3oool0B`3o
ool007P0oooo00D0000005`gS01L=h`0G3N<0000000509B1_0030000002b[M<0/ZgC00<0/ZgC00D0
00000=7Qi03AhN@0dN7T0000000B0?ooo`@000001`2@UmL00`000000/IJk0;6F^`0:0;6F^`030000
0035SY`0aHjL00<0aHjL00@000000?ooo`3oool0oooo0P0000000`3CKT`000000000000;0;bmf`03
0000003oool0oooo04`0oooo001h0?ooo`040000001L=h`0G3N<000000H0U86l00<000000;:]d`2b
[M<00`2b[M<010000000dN7T0=7Qi000000E0?ooo`0300000000HMH0000000L0T9OG00<000000;6F
^`2aU[/02P2aU[/01@000000aHjL0<F>W035SY`0000000<0oooo00<0000009:GeP0000000`3CKT`2
000000T0_;gK00<000000?ooo`3oool0C03oool007L0oooo00D0000005`gS01L=h`0G3N<00000005
09B1_0030000002b[M<0/ZgC00<0/ZgC00@000000=7Qi03AhN@00000503oool2000000040?ooo`00
00000000000000L0T9OG0P00000;0;6F^`80000000P0aHjL0000003oool0oooo0000002BUmH00000
0<F>W08000000`3CKT`3000000D0_;gK00<000000?ooo`3oool0C@3oool007H0oooo00D0000005`g
S01L=h`0G3N<0000000509B1_0030000002b[M<0/ZgC00<0/ZgC00D000000=7Qi03AhN@0dN7T0000
000C0?ooo`030000002l_=X0_;cJ0080000000@0oooo00000000000000001`2@UmL00`000000/IJk
0;6F^`0:0;6F^`@0000000<0/IJk0000000000000`35SY`00`000000dfi<0==^C0020==^C0<00000
0P2l_M/00`000000oooo0?ooo`1>0?ooo`00M@3oool01@000000G3N<05`gS01L=h`0000000D0U86l
00<000000;:]d`2b[M<00`2b[M<01@000000dN7T0=7Qi03AhN@0000001<0oooo00<000000;blfP2l
_=X00`2l_=X300000003001QeP000000T9OG00H0T9OG00<000000;6F^`2aU[/0202aU[/7000000D0
aHjL00<000000==^C03CKT`00P3CKT`010000000oooo00000000001A0?ooo`00M@3oool010000000
G3N<05`gS000000609B1_0030000002b[M<0/ZgC00<0/ZgC00@000000=7Qi03AhN@00000503oool0
0`000000_;cJ0;blfP060;blfP<000001`2@UmL2000000L0/IJk200000060<F>W08000000`3CKT`2
00000580oooo001d0?ooo`050000001L=h`0G3N<05`gS00000001@2DPK`00`000000/ZgC0;:]d`03
0;:]d`040000003AhN@0dN7T000001@0oooo00<000000;blfP2l_=X02@2l_=X3000000L0T9OG00<0
00000;6F^`2aU[/0102aU[/7000000T0aHjL00<000000==^C03CKT`00P3CKT`00`000000oooo0?oo
o`1?0?ooo`00L`3oool01@000000G3N<05`gS01L=h`0000000D0U86l00<000000;:]d`2b[M<00`2b
[M<010000000dN7T0=7Qi000000D0?ooo`030000002l_=X0_;cJ00X0_;cJ10000007092Ge`030000
002aU[/0/IJk0080/IJk1`0000000`2aU[/000000<F>W0080<F>W0050000003CKT`0dfi<0==^C000
0000D@3oool007<0oooo00@0000005`gS01L=h`000001@2DPK`00`000000/ZgC0;:]d`030;:]d`05
0000003AhN@0dN7T0=7Qi00000004`3oool00`000000_;cJ0;blfP0:0;blfP040000003oool0oooo
0?ooo`8000001`2@UmL2000000030;6F^`000000000000D000000`2aU[/2000000P0aHjL0`00001B
0?ooo`00L`3oool00`000000G3N<0000000609B1_0030000002b[M<0/ZgC0080/ZgC00D000000=7Q
i03AhN@0dN7T0000000D0?ooo`030000002l_=X0_;cJ00T0_;cJ00<000000?ooo`3oool00`3oool3
000000L0T9OG00<000000?ooo`3oool01@0000050;6F^`0300000035SY`0aHjL00L0aHjL00<00000
0?ooo`3oool0D03oool007@0oooo0P00000509B1_0030000002b[M<0/ZgC00<0/ZgC00@000000=7Q
i03AhN@00000503oool00`000000_;cJ0;blfP0:0;blfP030000003oool0oooo00D0oooo0P000005
092Ge`040000003oool0oooo0?ooo`@000001`2aU[/00`000000aHjL0<F>W0050<F>W0030000003o
ool0oooo0540oooo001d0?ooo`030000002DPK`0000000<0U86l00<000000;:]d`2b[M<00`2b[M<0
10000000dN7T0=7Qi000000D0?ooo`030000002l_=X0_;cJ00X0_;cJ00<000000?ooo`3oool01`3o
ool2000000@0T9OG00@000000?ooo`3oool000000P34SYd00`000000/IJk0;6F^`070;6F^`030000
0035SY`0aHjL00<0aHjL00<000000?ooo`3oool0DP3oool007D0oooo1@0000050;:]d`030000003A
hN@0dN7T008000004`3oool00`000000_;cJ0;blfP0:0;blfP030000003oool0oooo00T0oooo0`00
00000`2@UmL000000?ooo`020?ooo`0300000034SYd0000000/0/IJk0P0000030<F>W0030000003o
ool0oooo0580oooo001e0?ooo`H000000`2b[M<00`000000dN7T0=7Qi002000001<0oooo00<00000
0;blfP2l_=X02P2l_=X00`000000oooo0?ooo`0<0?ooo`8000000`3oool010000000a8jM0000002@
UmL2000000/0/IJk00<000000<F>W0000000E@3oool007D0oooo1@0000040;:]d`040000003AhN@0
dN7T000001@0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0B0?ooo`<000000`2@
UmL00`000000/IJk0;6F^`090;6F^`<00000E03oool007@0oooo1`0000020;:]d`040000003AhN@0
dN7T000001@0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0B0?ooo`030000003C
LE<0000000D0T9OG00<000000;6F^`2aU[/01`2aU[/600000580oooo001c0?ooo`H000000P3oool5
000001@0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0C0?ooo`8000001`2@UmL2
000000L0/IJk1P00001B0?ooo`00L`3oool6000001X0oooo00<000000;blfP2l_=X02P2l_=X00`00
0000oooo0?ooo`0D0?ooo`<000001`2@UmL00`000000/IJk0;6F^`030;6F^`H00000D`3oool00780
oooo1P00000J0?ooo`030000002l_=X0_;cJ00X0_;cJ00<000000?ooo`3oool04`3oool200000004
0?ooo`0000000000000000L0T9OG00@000000;6F^`2aU[/0/IJk1`00001C0?ooo`00L@3oool60000
01/0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0C0?ooo`030000002l_M/0_;gK
0080000000<0oooo0000000000001`2@UmL2000000030;6F^`000000000000L00000D@3oool00740
oooo1P00000J0?ooo`030000002l_=X0_;cJ00T0_;cJ00<000000?ooo`3oool04`3oool00`000000
_;gK0;bmf`030;bmf`D000001`2@UmL00`000000oooo0000000200000080oooo1@00001?0?ooo`00
L03oool6000001X0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0D0?ooo`030000
002l_M/0_;gK00H0_;gK00<00000001QeP000000102@UmL2000000<0oooo0P0000030?ooo`H00000
C@3oool00700oooo1@00000J0?ooo`030000002l_=X0_;cJ00T0_;cJ00<000000?ooo`3oool0503o
ool00`000000_;gK0;bmf`080;bmf`@0000000<0T9OG0000003oool02P3oool7000004/0oooo001_
0?ooo`H000006P3oool00`000000_;cJ0;blfP090;blfP030000003oool0oooo01<0oooo00<00000
0;bmf`2l_M/02P2l_M/200000003001QeP000000oooo00`0oooo00<0000008Z<c`0000001@000019
0?ooo`00L@3oool3000001X0oooo00<000000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0C0?oo
o`030000002l_M/0_;gK00X0_;gK00@000000?ooo`3oool000003`3oool010000000RXc?0000002[
SKH5000004L0oooo001c0?ooo`030000003oool0oooo01L0oooo00<000000;blfP2l_=X02@2l_=X0
0`000000oooo0?ooo`0C0?ooo`030000002l_M/0_;gK00X0_;gK00<000000?ooo`3oool04P3oool0
1P000000RXc?0000002[SKH000000;f5V0@00000A@3oool008`0oooo00<000000;blfP2l_=X02@2l
_=X00`000000oooo0?ooo`0C0?ooo`030000002l_M/0_;gK00/0_;gK00<000000?ooo`3oool04`3o
ool010000000RXc?0000002[SKH2000000030;f5V0000000af5:00800000@`3oool008/0oooo00<0
00000;blfP2l_=X02@2l_=X00`000000oooo0?ooo`0D0?ooo`030000002l_M/0_;gK00X0_;gK00<0
00000?ooo`3oool05@3oool01`000000RXc?000000000000Zhff0000002mQIP00P0000000`37HDX0
0000000000110?ooo`00R`3oool00`000000_;cJ0;blfP080;blfP030000003oool0oooo01@0oooo
00<000000;bmf`2l_M/02P2l_M/00`000000oooo0?ooo`0G0?ooo`80000000<0RXc?0000002[SKH0
0P000000102mQIP0000000000037HDX2000003l0oooo002:0?ooo`030000002l_=X0_;cJ00P0_;cJ
00<000000?ooo`3oool0503oool00`000000_;gK0;bmf`0:0;bmf`030000003oool0oooo01T0oooo
0P0000001@2:S<l000000:^=]P2[SKH000000080_HFH0P0000000`37HDX000000000000m0?ooo`00
R@3oool2000000X0_;cJ00<000000?ooo`3oool04`3oool00`000000_;gK0;bmf`0:0;bmf`030000
003oool0oooo01/0oooo0P000000102:S<l000000:^=]P2[SKH200000080_HFH00<000000<MQBP37
HDX00P00000k0?ooo`00R`3oool3000000H0_;cJ00<000000?ooo`3oool04`3oool00`000000_;gK
0;bmf`0:0;bmf`030000003oool0oooo01d0oooo0P0000000`2:S<l00000000000020:^=]P030000
002mQIP0_HFH008000000P37HDX00`000000oooo0?ooo`0h0?ooo`00SP3oool300000080_;cJ00<0
00000?ooo`3oool0503oool00`000000_;gK0;bmf`0:0;bmf`030000003oool0oooo01h0oooo0P00
000208Z<c`030000002[SKH0Zhff008000000P2mQIP3000003X0oooo002A0?ooo`8000005P3oool0
0`000000_;gK0;bmf`0:0;bmf`030000003oool0oooo0200oooo0P00000208Z<c`050000002[SKH0
Zhff0:^=]P0000000`2mQIP00`000000oooo0?ooo`0h0?ooo`00Z03oool00`000000_;gK0;bmf`0:
0;bmf`030000003oool0oooo0280oooo0P00000208Z<c`040000002[SKH0Zhff0:^=]P80000000<0
_HFH0000003oool0>@3oool00:L0oooo00<000000;bmf`2l_M/02P2l_M/00`000000oooo0?ooo`0T
0?ooo`8000000P2:S<l2000000<0Zhff00<000000?ooo`3oool0>@3oool00:H0oooo00<000000;bm
f`2l_M/02P2l_M/00`000000oooo0?ooo`0V0?ooo`8000000`2:S<l00`000000Zhff0000000l0?oo
o`00Y@3oool00`000000_;gK0;bmf`0:0;bmf`030000003oool0oooo02P0oooo0P00000308Z<c`03
0000003oool0oooo03/0oooo002U0?ooo`030000002l_M/0_;gK00X0_;gK00<000000?ooo`3oool0
:@3oool20000000308Z<c`000000oooo03d0oooo002T0?ooo`030000002l_M/0_;gK00X0_;gK00<0
00000?ooo`3oool0:`3oool2000003l0oooo002S0?ooo`030000002l_M/0_;gK00X0_;gK00<00000
0?ooo`3oool0K@3oool00:80oooo00<000000;bmf`2l_M/02P2l_M/00`000000oooo0?ooo`1^0?oo
o`00X@3oool00`000000_;gK0;bmf`0:0;bmf`030000003oool0oooo06l0oooo002P0?ooo`030000
002l_M/0_;gK00X0_;gK00<000000?ooo`3oool0L03oool00:00oooo00<000000;bmf`2l_M/02@2l
_M/00`000000oooo0?ooo`1a0?ooo`00W`3oool00`000000_;gK0;bmf`0:0;bmf`030000003oool0
oooo0740oooo002N0?ooo`030000002l_M/0_;gK00X0_;gK00<000000?ooo`3oool0LP3oool009d0
oooo00<000000;bmf`2l_M/02P2l_M/00`000000oooo0?ooo`1c0?ooo`00W03oool00`000000_;gK
0;bmf`0:0;bmf`030000003oool0oooo07@0oooo002L0?ooo`030000002l_M/0_;gK00T0_;gK00<0
00000?ooo`3oool0M@3oool009/0oooo00<000000;bmf`2l_M/02@2l_M/00`000000oooo0?ooo`1f
0?ooo`00VP3oool00`000000_;gK0;bmf`0:0;bmf`030000003oool0oooo07H0oooo002I0?ooo`03
0000002l_M/0_;gK00X0_;gK00<000000?ooo`3oool0M`3oool009P0oooo00<000000;bmf`2l_M/0
2P2l_M/00`000000oooo0?ooo`1h0?ooo`00U`3oool00`000000_;gK0;bmf`0:0;bmf`030000003o
ool0oooo07T0oooo002G0?ooo`030000002l_M/0_;gK00T0_;gK00<000000?ooo`3oool0NP3oool0
09H0oooo00<000000;bmf`2l_M/02@2l_M/00`000000oooo0?ooo`1k0?ooo`00U@3oool2000000/0
_;gK00<000000?ooo`3oool0N`3oool009L0oooo0`0000070;bmf`030000003oool0oooo07`0oooo
002J0?ooo`@000000P2l_M/00`000000oooo0?ooo`1m0?ooo`00WP3oool200000800oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.51318 .51977 m .5679 .41205 L .54859 .37931 L p .93 .693 .558 r
F P
0 g
s
.50415 .50516 m .51318 .51977 L p .51616 .50792 L .93 .693 .558 r
F P
0 g
s
.51726 .51751 m .48864 .49886 L .49674 .51193 L p 0 .195 .726 r
F P
0 g
s
.51726 .51751 m .50241 .51255 L p .49222 .50242 L .478 0 0 r
F P
0 g
s
.48864 .49886 m .49512 .50309 L p .49222 .50242 L .478 0 0 r
F P
0 g
s
.49512 .50309 m .51726 .51751 L p .49222 .50242 L .478 0 0 r
F P
0 g
s
.54859 .37931 m .4922 .48581 L .50415 .50516 L p .93 .693 .558 r
F P
0 g
s
.51616 .50792 m .54859 .37931 L .50415 .50516 L .93 .693 .558 r
F
.30542 .60291 m .45877 .55967 L .43725 .52586 L p .607 .624 .842 r
F P
0 g
s
.43725 .52586 m .28362 .57086 L .30542 .60291 L p .607 .624 .842 r
F P
0 g
s
.66426 .79377 m .67297 .78917 L .6219 .72004 L closepath p .738 .711 .826 r
F P
0 g
s
.65819 .80053 m .66426 .79377 L .6219 .72004 L closepath p .867 .748 .729 r
F P
0 g
s
.67297 .78917 m .68104 .78846 L .6219 .72004 L closepath p .536 .637 .897 r
F P
0 g
s
.65706 .8069 m .65819 .80053 L .6219 .72004 L closepath p .987 .72 .422 r
F P
0 g
s
.68104 .78846 m .68541 .79194 L .6219 .72004 L closepath p 0 .152 .675 r
F P
0 g
s
.66135 .81045 m .65706 .8069 L .6219 .72004 L closepath p 0 .192 .713 r
F P
0 g
s
.64783 .68432 m .7997 .56932 L .79414 .54613 L p .845 .872 .861 r
F P
0 g
s
.68541 .79194 m .68437 .79831 L .6219 .72004 L closepath p .923 .616 .444 r
F P
0 g
s
.66946 .80979 m .66135 .81045 L .6219 .72004 L closepath p .545 .56 .821 r
F P
0 g
s
.68437 .79831 m .67827 .80515 L .6219 .72004 L closepath p .822 .662 .685 r
F P
0 g
s
.67827 .80515 m .66946 .80979 L .6219 .72004 L closepath p .713 .637 .771 r
F P
0 g
s
.56868 .68711 m .58904 .71946 L .60368 .70385 L p .842 .701 .707 r
F P
0 g
s
.60368 .70385 m .58353 .67152 L .56868 .68711 L p .842 .701 .707 r
F P
0 g
s
.58353 .67152 m .60368 .70385 L .62419 .69287 L p .725 .671 .796 r
F P
0 g
s
.62419 .69287 m .60418 .66041 L .58353 .67152 L p .725 .671 .796 r
F P
0 g
s
.60418 .66041 m .62419 .69287 L .64303 .69057 L p .547 .597 .855 r
F P
0 g
s
.52413 .54762 m .49544 .52819 L .48526 .54148 L p .342 .104 .401 r
F P
0 g
s
.49544 .52819 m .52413 .54762 L .52552 .53091 L p .18 .154 .591 r
F P
0 g
s
.52552 .53091 m .49674 .51193 L .49544 .52819 L p .18 .154 .591 r
F P
0 g
s
.51364 .56132 m .48526 .54148 L .47003 .54681 L p .467 .041 .146 r
F P
0 g
s
.48526 .54148 m .51364 .56132 L .52413 .54762 L p .342 .104 .401 r
F P
0 g
s
.49674 .51193 m .52552 .53091 L .51726 .51751 L p 0 .195 .726 r
F P
0 g
s
.56521 .70144 m .58577 .73394 L .58904 .71946 L p .956 .668 .45 r
F P
0 g
s
.58904 .71946 m .56868 .68711 L .56521 .70144 L p .956 .668 .45 r
F P
0 g
s
.47003 .54681 m .49802 .56684 L .51364 .56132 L p .467 .041 .146 r
F P
0 g
s
.49802 .56684 m .47003 .54681 L .4555 .5421 L p .517 0 0 r
F P
0 g
s
.50241 .51255 m .47413 .49399 L .48864 .49886 L p .478 0 0 r
F P
0 g
s
.64303 .69057 m .62304 .65789 L .60418 .66041 L p .547 .597 .855 r
F P
0 g
s
.62304 .65789 m .64303 .69057 L .65311 .69797 L p 0 .202 .73 r
F P
0 g
s
.4555 .5421 m .48315 .56206 L .49802 .56684 L p .517 0 0 r
F P
0 g
s
.48315 .56206 m .4555 .5421 L .44724 .52907 L p 0 .161 .701 r
F P
0 g
s
.79414 .54613 m .63983 .66259 L .64783 .68432 L p .845 .872 .861 r
F P
0 g
s
.47413 .49399 m .50241 .51255 L .48664 .51802 L p .449 .012 .114 r
F P
0 g
s
.48664 .51802 m .45876 .49926 L .47413 .49399 L p .449 .012 .114 r
F P
0 g
s
.47472 .5487 m .44724 .52907 L .44847 .51268 L p .151 .131 .579 r
F P
0 g
s
.44724 .52907 m .47472 .5487 L .48315 .56206 L p 0 .161 .701 r
F P
0 g
s
.51364 .59967 m .56096 .67484 L .57588 .65926 L p .842 .701 .707 r
F P
0 g
s
.57588 .65926 m .52905 .58414 L .51364 .59967 L p .842 .701 .707 r
F P
0 g
s
.52905 .58414 m .57588 .65926 L .59659 .6481 L p .725 .671 .796 r
F P
0 g
s
.59659 .6481 m .55008 .57268 L .52905 .58414 L p .725 .671 .796 r
F P
0 g
s
.55008 .57268 m .59659 .6481 L .61546 .64549 L p .547 .597 .855 r
F P
0 g
s
.45876 .49926 m .48664 .51802 L .47604 .53185 L p .324 .082 .384 r
F P
0 g
s
.01 w
.48039 .52618 m
.50229 .5412 L
s
.5 Mabswid
.47604 .53185 m .44847 .51268 L .45876 .49926 L p .324 .082 .384 r
F P
0 g
s
.44847 .51268 m .47604 .53185 L .47472 .5487 L p .151 .131 .579 r
F P
0 g
s
.57471 .70903 m .59538 .74178 L .58577 .73394 L p 0 .154 .695 r
F P
0 g
s
.58577 .73394 m .56521 .70144 L .57471 .70903 L p 0 .154 .695 r
F P
0 g
s
.42078 .85624 m .57895 .73648 L .56983 .71541 L p .845 .872 .861 r
F P
0 g
s
.03 w
.60925 .6997 m
.6219 .72004 L
s
.5 Mabswid
.50963 .61356 m .55742 .68911 L .56096 .67484 L p .956 .668 .45 r
F P
0 g
s
.56096 .67484 m .51364 .59967 L .50963 .61356 L p .956 .668 .45 r
F P
0 g
s
.65311 .69797 m .63302 .66504 L .62304 .65789 L p 0 .202 .73 r
F P
0 g
s
.60634 .61165 m .71539 .5301 L .7091 .50825 L p .843 .864 .858 r
F P
0 g
s
.63302 .66504 m .65311 .69797 L .65035 .71245 L p .962 .666 .426 r
F P
0 g
s
.61546 .64549 m .569 .56954 L .55008 .57268 L p .547 .597 .855 r
F P
0 g
s
.569 .56954 m .61546 .64549 L .6254 .65256 L p 0 .202 .73 r
F P
0 g
s
.59378 .70678 m .61443 .73975 L .59538 .74178 L p .538 .596 .86 r
F P
0 g
s
.59538 .74178 m .57471 .70903 L .59378 .70678 L p .538 .596 .86 r
F P
0 g
s
.5188 .62049 m .56687 .69662 L .55742 .68911 L p 0 .154 .695 r
F P
0 g
s
.55742 .68911 m .50963 .61356 L .5188 .62049 L p 0 .154 .695 r
F P
0 g
s
.65035 .71245 m .63006 .67936 L .63302 .66504 L p .962 .666 .426 r
F P
0 g
s
.63006 .67936 m .65035 .71245 L .63554 .7285 L p .847 .705 .706 r
F P
0 g
s
.7091 .50825 m .59843 .59073 L .60634 .61165 L p .843 .864 .858 r
F P
0 g
s
.6254 .65256 m .57868 .57602 L .569 .56954 L p 0 .202 .73 r
F P
0 g
s
.57868 .57602 m .6254 .65256 L .62237 .66682 L p .962 .666 .426 r
F P
0 g
s
.61504 .69539 m .63554 .7285 L .61443 .73975 L p .726 .674 .799 r
F P
0 g
s
.61443 .73975 m .59378 .70678 L .61504 .69539 L p .726 .674 .799 r
F P
0 g
s
.56983 .71541 m .40902 .83677 L .42078 .85624 L p .845 .872 .861 r
F P
0 g
s
.63554 .7285 m .61504 .69539 L .63006 .67936 L p .847 .705 .706 r
F P
0 g
s
.41966 .75124 m .53242 .66692 L .5234 .64665 L p .843 .864 .858 r
F P
0 g
s
.53792 .61759 m .58595 .69427 L .56687 .69662 L p .538 .596 .86 r
F P
0 g
s
.56687 .69662 m .5188 .62049 L .53792 .61759 L p .538 .596 .86 r
F P
0 g
s
.03 w
.5653 .62897 m
.60869 .69879 L
s
.5 Mabswid
.55217 .53188 m .61417 .48619 L .60439 .47209 L p .75 .613 .707 r
F P
0 g
s
.61417 .48619 m .55217 .53188 L .56249 .54334 L p .658 .447 .587 r
F P
0 g
s
.56249 .54334 m .62466 .49742 L .61417 .48619 L p .658 .447 .587 r
F P
0 g
s
.54227 .51775 m .60439 .47209 L .59895 .46035 L p .82 .778 .814 r
F P
0 g
s
.60439 .47209 m .54227 .51775 L .55217 .53188 L p .75 .613 .707 r
F P
0 g
s
.62237 .66682 m .57519 .58988 L .57868 .57602 L p .962 .666 .426 r
F P
0 g
s
.57519 .58988 m .62237 .66682 L .60727 .68283 L p .847 .705 .706 r
F P
0 g
s
.62466 .49742 m .56249 .54334 L .56939 .5478 L p .407 .076 .288 r
F P
0 g
s
.56939 .5478 m .63193 .50155 L .62466 .49742 L p .407 .076 .288 r
F P
0 g
s
.55958 .60584 m .60727 .68283 L .58595 .69427 L p .726 .674 .799 r
F P
0 g
s
.58595 .69427 m .53792 .61759 L .55958 .60584 L p .726 .674 .799 r
F P
0 g
s
.59895 .46035 m .53648 .50617 L .54227 .51775 L p .82 .778 .814 r
F P
0 g
s
.53648 .50617 m .59895 .46035 L .59994 .45541 L p .754 .995 .854 r
F P
0 g
s
.60727 .68283 m .55958 .60584 L .57519 .58988 L p .847 .705 .706 r
F P
0 g
s
.5234 .64665 m .40893 .73198 L .41966 .75124 L p .843 .864 .858 r
F P
0 g
s
.51858 .54089 m .51797 .54821 L .51338 .55421 L p .785 .69 .758 r
F P
0 g
s
.52101 .5638 m .51338 .55421 L .51797 .54821 L p .671 .521 .672 r
F P
0 g
s
.51797 .54821 m .5293 .55296 L .52101 .5638 L p .671 .521 .672 r
F P
0 g
s
.5293 .55296 m .51797 .54821 L .51858 .54089 L p .635 .556 .749 r
F P
0 g
s
.51496 .53504 m .51858 .54089 L p .51338 .55421 L .785 .69 .758 r
F P
0 g
s
.50847 .5329 m .51496 .53504 L p .51338 .55421 L .785 .69 .758 r
F P
0 g
s
.5016 .5353 m .50847 .5329 L p .51338 .55421 L .785 .69 .758 r
F P
0 g
s
.49698 .54134 m .5016 .5353 L p .51338 .55421 L .785 .69 .758 r
F P
0 g
s
.49639 .54868 m .49698 .54134 L p .51338 .55421 L .785 .69 .758 r
F P
0 g
s
.50005 .55452 m .49639 .54868 L p .51338 .55421 L .785 .69 .758 r
F P
0 g
s
.51338 .55421 m .50653 .55663 L .50005 .55452 L p .785 .69 .758 r
F P
0 g
s
.50867 .56817 m .50653 .55663 L .51338 .55421 L p .735 .529 .613 r
F P
0 g
s
.51338 .55421 m .52101 .5638 L .50867 .56817 L p .735 .529 .613 r
F P
0 g
s
.51858 .54089 m .53042 .53976 L .5293 .55296 L p .635 .556 .749 r
F P
0 g
s
.53042 .53976 m .51858 .54089 L .51496 .53504 L p .633 .636 .835 r
F P
0 g
s
.49695 .56439 m .50005 .55452 L .50653 .55663 L p .823 .586 .581 r
F P
0 g
s
.50653 .55663 m .50867 .56817 L .49695 .56439 L p .823 .586 .581 r
F P
0 g
s
.52791 .57097 m .52101 .5638 L .5293 .55296 L p .566 .38 .588 r
F P
0 g
s
.5293 .55296 m .53828 .55741 L .52791 .57097 L p .566 .38 .588 r
F P
0 g
s
.53828 .55741 m .5293 .55296 L .53042 .53976 L p .493 .431 .715 r
F P
0 g
s
.51248 .57647 m .50867 .56817 L .52101 .5638 L p .667 .377 .471 r
F P
0 g
s
.52101 .5638 m .52791 .57097 L .51248 .57647 L p .667 .377 .471 r
F P
0 g
s
.63193 .50155 m .56939 .5478 L .57018 .54346 L p .733 .991 .836 r
F P
0 g
s
.57018 .54346 m .63318 .4969 L .63193 .50155 L p .733 .991 .836 r
F P
0 g
s
.51496 .53504 m .5239 .52919 L .53042 .53976 L p .633 .636 .835 r
F P
0 g
s
.5239 .52919 m .51496 .53504 L .50847 .5329 L p .679 .758 .911 r
F P
0 g
s
.49033 .55385 m .49639 .54868 L .50005 .55452 L p .916 .7 .595 r
F P
0 g
s
.50005 .55452 m .49695 .56439 L .49033 .55385 L p .916 .7 .595 r
F P
0 g
s
.53042 .53976 m .53969 .5409 L .53828 .55741 L p .493 .431 .715 r
F P
0 g
s
.53969 .5409 m .53042 .53976 L .5239 .52919 L p .439 .543 .866 r
F P
0 g
s
.49781 .57176 m .49695 .56439 L .50867 .56817 L p .807 .432 .346 r
F P
0 g
s
.50867 .56817 m .51248 .57647 L .49781 .57176 L p .807 .432 .346 r
F P
0 g
s
.59994 .45541 m .53702 .50154 L .53648 .50617 L p .754 .995 .854 r
F P
0 g
s
.02 w
.48679 .57364 m
.48814 .57264 L
s
.5 Mabswid
.50847 .5329 m .51219 .5253 L .5239 .52919 L p .679 .758 .911 r
F P
0 g
s
.51219 .5253 m .50847 .5329 L .5016 .5353 L p .781 .887 .921 r
F P
0 g
s
.49139 .54056 m .49698 .54134 L .49639 .54868 L p .961 .845 .682 r
F P
0 g
s
.49639 .54868 m .49033 .55385 L .49139 .54056 L p .961 .845 .682 r
F P
0 g
s
.3803 .65853 m .47142 .59139 L .46137 .57721 L p .75 .613 .707 r
F P
0 g
s
.47142 .59139 m .3803 .65853 L .39017 .67062 L p .658 .447 .587 r
F P
0 g
s
.39017 .67062 m .48153 .60314 L .47142 .59139 L p .658 .447 .587 r
F P
0 g
s
.53272 .57433 m .52791 .57097 L .53828 .55741 L p .342 .104 .4 r
F P
0 g
s
.53828 .55741 m .54314 .56071 L .53272 .57433 L p .342 .104 .4 r
F P
0 g
s
.54314 .56071 m .53828 .55741 L .53969 .5409 L p .179 .154 .591 r
F P
0 g
s
.5016 .5353 m .49976 .52964 L .51219 .5253 L p .781 .887 .921 r
F P
0 g
s
.49976 .52964 m .5016 .5353 L .49698 .54134 L p .903 .931 .823 r
F P
0 g
s
.51722 .57986 m .51248 .57647 L .52791 .57097 L p .467 .04 .145 r
F P
0 g
s
.52791 .57097 m .53272 .57433 L .51722 .57986 L p .467 .04 .145 r
F P
0 g
s
.03 w
.5316 .57473 m
.55311 .60935 L
s
.5 Mabswid
.49698 .54134 m .49139 .54056 L .49976 .52964 L p .903 .931 .823 r
F P
0 g
s
.53702 .50154 m .59994 .45541 L .60712 .4593 L p .39 .051 .266 r
F P
0 g
s
.5239 .52919 m .53156 .52767 L .53969 .5409 L p .439 .543 .866 r
F P
0 g
s
.53156 .52767 m .5239 .52919 L .51219 .5253 L p .403 .736 .992 r
F P
0 g
s
.37009 .6443 m .46137 .57721 L .45512 .56585 L p .82 .778 .814 r
F P
0 g
s
.46137 .57721 m .37009 .6443 L .3803 .65853 L p .75 .613 .707 r
F P
0 g
s
.48951 .55858 m .49033 .55385 L .49695 .56439 L p .939 .571 .203 r
F P
0 g
s
.49695 .56439 m .49781 .57176 L .48951 .55858 L p .939 .571 .203 r
F P
0 g
s
.53969 .5409 m .54456 .54412 L .54314 .56071 L p .179 .154 .591 r
F P
0 g
s
.54456 .54412 m .53969 .5409 L .53156 .52767 L p 0 .195 .725 r
F P
0 g
s
.50249 .57514 m .49781 .57176 L .51248 .57647 L p .516 0 0 r
F P
0 g
s
.51248 .57647 m .51722 .57986 L .50249 .57514 L p .516 0 0 r
F P
0 g
s
.51219 .5253 m .51691 .52279 L .53156 .52767 L p .403 .736 .992 r
F P
0 g
s
.51691 .52279 m .51219 .5253 L .49976 .52964 L p .386 .845 .795 r
F P
0 g
s
.48153 .60314 m .39017 .67062 L .396 .67603 L p .407 .076 .288 r
F P
0 g
s
.396 .67603 m .48793 .60805 L .48153 .60314 L p .407 .076 .288 r
F P
0 g
s
.49084 .54192 m .49139 .54056 L .49033 .55385 L p .78 .688 .143 r
F P
0 g
s
.49033 .55385 m .48951 .55858 L .49084 .54192 L p .78 .688 .143 r
F P
0 g
s
.63318 .4969 m .57018 .54346 L .56443 .53182 L p .822 .784 .816 r
F P
0 g
s
.56443 .53182 m .62779 .48508 L .63318 .4969 L p .822 .784 .816 r
F P
0 g
s
.02 w
.54718 .52917 m
.61596 .47852 L
s
.5 Mabswid
.53447 .57316 m .53272 .57433 L .54314 .56071 L p 0 0 0 r
F P
0 g
s
.54314 .56071 m .54287 .56217 L .53447 .57316 L p 0 0 0 r
F P
0 g
s
.54287 .56217 m .54314 .56071 L .54456 .54412 L p .73 .647 .088 r
F P
0 g
s
.53156 .52767 m .53641 .53083 L .54456 .54412 L p 0 .195 .725 r
F P
0 g
s
.02 w
.543 .53225 m
.54718 .52917 L
s
.54036 .53419 m
.543 .53225 L
s
.53906 .53515 m
.54036 .53419 L
s
.5 Mabswid
.53641 .53083 m .53156 .52767 L .51691 .52279 L p .478 0 0 r
F P
0 g
s
.49976 .52964 m .50133 .52822 L .51691 .52279 L p .386 .845 .795 r
F P
0 g
s
.50133 .52822 m .49976 .52964 L .49139 .54056 L p 0 0 0 r
F P
0 g
s
.52198 .57761 m .51722 .57986 L .53272 .57433 L p .336 .811 .751 r
F P
0 g
s
.53272 .57433 m .53447 .57316 L .52198 .57761 L p .336 .811 .751 r
F P
0 g
s
.49139 .54056 m .49084 .54192 L .50133 .52822 L p 0 0 0 r
F P
0 g
s
.49417 .5619 m .48951 .55858 L .49781 .57176 L p 0 .162 .701 r
F P
0 g
s
.02 w
.48814 .57264 m
.49368 .56856 L
s
.5 Mabswid
.49781 .57176 m .50249 .57514 L .49417 .5619 L p 0 .162 .701 r
F P
0 g
s
.02 w
.49368 .56856 m
.496 .56685 L
s
.5 Mabswid
.45512 .56585 m .36331 .6332 L .37009 .6443 L p .82 .778 .814 r
F P
0 g
s
.36331 .6332 m .45512 .56585 L .45506 .56163 L p .754 .995 .854 r
F P
0 g
s
.60712 .4593 m .54382 .50577 L .53702 .50154 L p .39 .051 .266 r
F P
0 g
s
.54456 .54412 m .54402 .5488 L .54287 .56217 L p .73 .647 .088 r
F P
0 g
s
.54402 .5488 m .54456 .54412 L .53641 .53083 L p .93 .556 .165 r
F P
0 g
s
.02 w
.49688 .56621 m
.53805 .53589 L
s
.5 Mabswid
.54382 .50577 m .60712 .4593 L .6178 .47066 L p .657 .444 .583 r
F P
0 g
s
.51013 .57381 m .50249 .57514 L .51722 .57986 L p .377 .731 .99 r
F P
0 g
s
.51722 .57986 m .52198 .57761 L .51013 .57381 L p .377 .731 .99 r
F P
0 g
s
.51691 .52279 m .5217 .52594 L .53641 .53083 L p .478 0 0 r
F P
0 g
s
.5217 .52594 m .51691 .52279 L .50133 .52822 L p .449 .012 .114 r
F P
0 g
s
.49552 .54517 m .49084 .54192 L .48951 .55858 L p .151 .131 .579 r
F P
0 g
s
.48951 .55858 m .49417 .5619 L .49552 .54517 L p .151 .131 .579 r
F P
0 g
s
.62779 .48508 m .56443 .53182 L .55432 .51736 L p .751 .614 .707 r
F P
0 g
s
.55432 .51736 m .6178 .47066 L .62779 .48508 L p .751 .614 .707 r
F P
0 g
s
.53641 .53083 m .53745 .53811 L .54402 .5488 L p .93 .556 .165 r
F P
0 g
s
.53745 .53811 m .53641 .53083 L .5217 .52594 L p .807 .424 .328 r
F P
0 g
s
.48793 .60805 m .396 .67603 L .39549 .67259 L p .733 .991 .836 r
F P
0 g
s
.39549 .67259 m .48812 .60412 L .48793 .60805 L p .733 .991 .836 r
F P
0 g
s
.53276 .56762 m .53447 .57316 L .54287 .56217 L p .905 .94 .821 r
F P
0 g
s
.54287 .56217 m .53745 .56149 L .53276 .56762 L p .905 .94 .821 r
F P
0 g
s
.53745 .56149 m .54287 .56217 L .54402 .5488 L p .967 .852 .676 r
F P
0 g
s
.50133 .52822 m .50606 .53141 L .5217 .52594 L p .449 .012 .114 r
F P
0 g
s
.50606 .53141 m .50133 .52822 L .49084 .54192 L p .324 .082 .384 r
F P
0 g
s
.52581 .5701 m .52198 .57761 L .53447 .57316 L p .779 .895 .926 r
F P
0 g
s
.53447 .57316 m .53276 .56762 L .52581 .5701 L p .779 .895 .926 r
F P
0 g
s
.50346 .56315 m .49417 .5619 L .50249 .57514 L p .426 .539 .869 r
F P
0 g
s
.50249 .57514 m .51013 .57381 L .50346 .56315 L p .426 .539 .869 r
F P
0 g
s
.49084 .54192 m .49552 .54517 L .50606 .53141 L p .324 .082 .384 r
F P
0 g
s
.6178 .47066 m .55432 .51736 L .54382 .50577 L p .657 .444 .583 r
F P
0 g
s
.54402 .5488 m .53809 .55404 L .53745 .56149 L p .967 .852 .676 r
F P
0 g
s
.53809 .55404 m .54402 .5488 L .53745 .53811 L p .922 .703 .589 r
F P
0 g
s
.51922 .56797 m .51013 .57381 L .52198 .57761 L p .676 .763 .916 r
F P
0 g
s
.52198 .57761 m .52581 .5701 L .51922 .56797 L p .676 .763 .916 r
F P
0 g
s
.03 w
.5053 .5324 m
.52819 .56925 L
s
.5 Mabswid
.45026 .42959 m .44089 .43481 L .50334 .52926 L closepath p .713 .638 .772 r
F P
0 g
s
.45842 .42777 m .45026 .42959 L .50334 .52926 L closepath p .541 .56 .823 r
F P
0 g
s
.46226 .43006 m .45842 .42777 L .50334 .52926 L closepath p 0 .173 .702 r
F P
0 g
s
.46027 .43562 m .46226 .43006 L .50334 .52926 L closepath p .985 .721 .436 r
F P
0 g
s
.45315 .44234 m .46027 .43562 L .50334 .52926 L closepath p .865 .745 .729 r
F P
0 g
s
.44089 .43481 m .43382 .44145 L .50334 .52926 L closepath p .824 .664 .684 r
F P
0 g
s
.44365 .44762 m .45315 .44234 L .50334 .52926 L closepath p .737 .709 .824 r
F P
0 g
s
.43382 .44145 m .43173 .44703 L .50334 .52926 L closepath p .926 .615 .434 r
F P
0 g
s
.43546 .4494 m .44365 .44762 L .50334 .52926 L closepath p .541 .636 .894 r
F P
0 g
s
.43173 .44703 m .43546 .4494 L .50334 .52926 L closepath p 0 .179 .699 r
F P
0 g
s
.03 w
.50334 .52926 m
.50369 .52981 L
s
.5 Mabswid
.5217 .52594 m .52561 .5342 L .53745 .53811 L p .807 .424 .328 r
F P
0 g
s
.52561 .5342 m .5217 .52594 L .50606 .53141 L p .665 .37 .463 r
F P
0 g
s
.45506 .56163 m .36256 .62945 L .36331 .6332 L p .754 .995 .854 r
F P
0 g
s
.36256 .62945 m .45506 .56163 L .46134 .5663 L p .39 .051 .266 r
F P
0 g
s
.50455 .54968 m .49552 .54517 L .49417 .5619 L p .485 .425 .715 r
F P
0 g
s
.49417 .5619 m .50346 .56315 L .50455 .54968 L p .485 .425 .715 r
F P
0 g
s
.53745 .53811 m .53442 .5481 L .53809 .55404 L p .922 .703 .589 r
F P
0 g
s
.53442 .5481 m .53745 .53811 L .52561 .5342 L p .826 .586 .576 r
F P
0 g
s
.51552 .56203 m .50346 .56315 L .51013 .57381 L p .63 .637 .839 r
F P
0 g
s
.51013 .57381 m .51922 .56797 L .51552 .56203 L p .63 .637 .839 r
F P
0 g
s
.52581 .5701 m .53276 .56762 L .53745 .56149 L p .787 .692 .759 r
F P
0 g
s
.51922 .56797 m .52581 .5701 L p .53745 .56149 L .787 .692 .759 r
F P
0 g
s
.51552 .56203 m .51922 .56797 L p .53745 .56149 L .787 .692 .759 r
F P
0 g
s
.51614 .55455 m .51552 .56203 L p .53745 .56149 L .787 .692 .759 r
F P
0 g
s
.52084 .5484 m .51614 .55455 L p .53745 .56149 L .787 .692 .759 r
F P
0 g
s
.01 w
.5075 .54478 m
.51807 .55203 L
s
.5 Mabswid
.52783 .54593 m .52084 .5484 L p .53745 .56149 L .787 .692 .759 r
F P
0 g
s
.53442 .5481 m .52783 .54593 L p .53745 .56149 L .787 .692 .759 r
F P
0 g
s
.01 w
.52682 .55803 m
.53062 .56064 L
s
.5 Mabswid
.53745 .56149 m .53809 .55404 L .53442 .5481 L p .787 .692 .759 r
F P
0 g
s
.50606 .53141 m .51303 .53861 L .52561 .5342 L p .665 .37 .463 r
F P
0 g
s
.51303 .53861 m .50606 .53141 L .49552 .54517 L p .562 .374 .584 r
F P
0 g
s
.49552 .54517 m .50455 .54968 L .51303 .53861 L p .562 .374 .584 r
F P
0 g
s
.52561 .5342 m .52783 .54593 L .53442 .5481 L p .826 .586 .576 r
F P
0 g
s
.52783 .54593 m .52561 .5342 L .51303 .53861 L p .736 .528 .611 r
F P
0 g
s
.51614 .55455 m .50455 .54968 L .50346 .56315 L p .633 .556 .75 r
F P
0 g
s
.50346 .56315 m .51552 .56203 L .51614 .55455 L p .633 .556 .75 r
F P
0 g
s
.48812 .60412 m .39549 .67259 L .38873 .66144 L p .822 .784 .816 r
F P
0 g
s
.38873 .66144 m .4819 .59271 L .48812 .60412 L p .822 .784 .816 r
F P
0 g
s
.51303 .53861 m .52084 .5484 L .52783 .54593 L p .736 .528 .611 r
F P
0 g
s
.52084 .5484 m .51303 .53861 L .50455 .54968 L p .67 .52 .671 r
F P
0 g
s
.50455 .54968 m .51614 .55455 L .52084 .5484 L p .67 .52 .671 r
F P
0 g
s
.5918 .59346 m .5591 .5713 L .54825 .5855 L p .342 .104 .401 r
F P
0 g
s
.5591 .5713 m .5918 .59346 L .59343 .57569 L p .18 .154 .591 r
F P
0 g
s
.59343 .57569 m .56061 .55405 L .5591 .5713 L p .18 .154 .591 r
F P
0 g
s
.58061 .60811 m .54825 .5855 L .53215 .59127 L p .467 .041 .146 r
F P
0 g
s
.54825 .5855 m .58061 .60811 L .5918 .59346 L p .342 .104 .401 r
F P
0 g
s
.36826 .63463 m .46134 .5663 L .47163 .5782 L p .657 .444 .583 r
F P
0 g
s
.46134 .5663 m .36826 .63463 L .36256 .62945 L p .39 .051 .266 r
F P
0 g
s
.56061 .55405 m .59343 .57569 L .58482 .56151 L p 0 .195 .726 r
F P
0 g
s
.58482 .56151 m .55217 .54024 L .56061 .55405 L p 0 .195 .726 r
F P
0 g
s
.53215 .59127 m .56407 .61412 L .58061 .60811 L p .467 .041 .146 r
F P
0 g
s
.56407 .61412 m .53215 .59127 L .51686 .5864 L p .517 0 0 r
F P
0 g
s
.4819 .59271 m .38873 .66144 L .37828 .64688 L p .751 .614 .707 r
F P
0 g
s
.02 w
.33262 .68715 m
.3814 .65123 L
s
.40941 .63061 m
.48679 .57364 L
s
.5 Mabswid
.37828 .64688 m .47163 .5782 L .4819 .59271 L p .751 .614 .707 r
F P
0 g
s
.47163 .5782 m .37828 .64688 L .36826 .63463 L p .657 .444 .583 r
F P
0 g
s
.55217 .54024 m .58482 .56151 L .56918 .55636 L p .478 0 0 r
F P
0 g
s
.56918 .55636 m .53691 .53518 L .55217 .54024 L p .478 0 0 r
F P
0 g
s
.51686 .5864 m .5484 .60917 L .56407 .61412 L p .517 0 0 r
F P
0 g
s
.5484 .60917 m .51686 .5864 L .50824 .57265 L p 0 .161 .701 r
F P
0 g
s
.53691 .53518 m .56918 .55636 L .55247 .56231 L p .449 .012 .114 r
F P
0 g
s
.55247 .56231 m .52064 .5409 L .53691 .53518 L p .449 .012 .114 r
F P
0 g
s
.53961 .59505 m .50824 .57265 L .50967 .55524 L p .151 .131 .579 r
F P
0 g
s
.50824 .57265 m .53961 .59505 L .5484 .60917 L p 0 .161 .701 r
F P
0 g
s
.52064 .5409 m .55247 .56231 L .54114 .57712 L p .324 .082 .384 r
F P
0 g
s
.01 w
.54579 .57105 m
.58591 .59857 L
s
.53062 .56064 m
.53258 .56198 L
s
.5 Mabswid
.54114 .57712 m .50967 .55524 L .52064 .5409 L p .324 .082 .384 r
F P
0 g
s
.50967 .55524 m .54114 .57712 L .53961 .59505 L p .151 .131 .579 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00W@3oool00`000000oooo0?ooo`200?ooo`00W03o
ool200000880oooo002L0?ooo`030000003^/Hh000000840oooo002K0?ooo`040000003^/Hh0k[6>
00000840oooo002K0?ooo`050000003^/Hh0k[6>0>jaSP000000P03oool009X0oooo00<000000>ja
SP3^/Hh00P3^/Hh00`000000oooo0?ooo`1n0?ooo`00VP3oool00`000000k[6>0>jaSP030>jaSP03
0000003oool0oooo07d0oooo002I0?ooo`030000003^/Hh0k[6>00@0k[6>00<000000?ooo`3oool0
O@3oool009T0oooo00<000000>jaSP3^/Hh01@3^/Hh00`000000oooo0?ooo`1l0?ooo`00V03oool0
0`000000k[6>0>jaSP060>jaSP030000003oool0oooo07`0oooo002H0?ooo`030000003^/Hh0k[6>
00L0k[6>00<000000?ooo`3oool0N`3oool009L0oooo00<000000>jaSP3^/Hh0203^/Hh00`000000
oooo0?ooo`1k0?ooo`00U`3oool00`000000k[6>0>jaSP070>jaSP030000003oool0oooo07`0oooo
002F0?ooo`030000003^/Hh0k[6>00P0k[6>00<000000?ooo`3oool0O03oool00880oooo0P00000B
0?ooo`030000003^/Hh0k[6>00L0k[6>00<000000?ooo`3oool0O@3oool00800oooo0P0000000`2:
Sm8000000000000@0?ooo`030000003^/Hh0k[6>00P0k[6>00<000000?ooo`3oool0O@3oool007h0
oooo0P0000020;JSa@030000002:Sm8000000100oooo00<000000>jaSP3^/Hh01`3^/Hh00`000000
oooo0?ooo`1n0?ooo`00O@3oool00`000000dZV_000000020;JSa@@000003P3oool00`000000k[6>
0>jaSP080>jaSP030000003oool0oooo07h0oooo001l0?ooo`040000003BZJl0dZV_00000080]Z?5
00@000000=fn^P00000000003P3oool00`000000k[6>0>jaSP070>jaSP030000003oool0oooo07l0
oooo001l0?ooo`8000000P3BZJl2000000030;bedP000000gKjj00800000303oool00`000000k[6>
0>jaSP080>jaSP030000003oool0oooo07l0oooo001k0?ooo`D000000`2l]M8010000000gKjj0000
0000000<0?ooo`030000003^/Hh0k[6>00L0k[6>00<000000?ooo`3oool0P03oool007`0oooo0P00
000208ZRi0060000002l]M80_;GB0;bedP000000gKjj0P00000:0?ooo`030000003^/Hh0k[6>00P0
k[6>00<000000?ooo`3oool0P03oool007d0oooo0P0000000`2:X^@000000;bedP020;bedP040000
003M_[X00000000000X0oooo00<000000>jaSP3^/Hh01`3^/Hh00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo0740oooo001n0?ooo`80000000<0RZ;T0000002l]M800P2l]M800`000000gKjj
000000090?ooo`030000003^/Hh0k[6>00P0k[6>00<000000?ooo`3oool02`3oool20000000306<=
A000000000000740oooo001o0?ooo`040000002:X^@0RZ;T00000080_;GB00@000000=fn^P000000
0000203oool00`000000k[6>0>jaSP070>jaSP030000003oool0oooo00/0oooo00L0000006<=A01S
3D@0H`e40000002XLID000000700oooo00200?ooo`040000002:X^@0RZ;T00000080_;GB00<00000
0=fn^P0000001`3oool00`000000k[6>0>jaSP080>jaSP030000003oool0oooo00X0oooo00<00000
06<=A01S3D@00P0000020:QaU@030000003oool0oooo06h0oooo00200?ooo`80000000H0RZ;T0000
002l]M80_;GB0000003M_[X2000000H0oooo00<000000>jaSP3^/Hh01`3^/Hh00`000000oooo0?oo
o`090?ooo`8000000P1S3D@00`000000Z76E0:QaU@030:QaU@030000003oool0oooo06d0oooo0021
0?ooo`80000000L0RZ;T0000002l]M80_;GB0000003M_[X0000000D0oooo00<000000>jaSP3^/Hh0
203^/Hh00`000000oooo0?ooo`080?ooo`050000001S3D@0H`e406<=A00000001`2XLID00`000000
oooo0?ooo`1/0?ooo`00PP3oool20000000408ZRi0000000_;GB0;bedP<00000103oool00`000000
k[6>0>jaSP070>jaSP030000003oool0oooo00L0oooo0P00000206<=A08000001P2XLID200000003
0<2M]0000000oooo06`0oooo00230?ooo`80000000H0RZ;T0000002l]M8000000=fn^P0000030?oo
o`030000003^/Hh0k[6>00P0k[6>00<000000?ooo`3oool01P3oool01@000000H`e406<=A01S3D@0
000000L0Z76E00@000000<2M]030WK@0`9fd0P00001/0?ooo`00Q03oool300000080_;GB0P000003
0?ooo`030000003^/Hh0k[6>00L0k[6>00<000000?ooo`3oool01P3oool01@000000H`e406<=A01S
3D@0000000L0Z76E00<000000<2M]030WK@00`30WK@00`000000oooo0?ooo`1Z0?ooo`00Q@3oool3
000000060;bedP00000000000000003oool000002P3^/Hh00`000000oooo0?ooo`040?ooo`800000
0`1S3D@00`000000Z76E0:QaU@040:QaU@8000001`30WK@00`000000oooo0?ooo`1Y0?ooo`00QP3o
ool010000000RZ;T0000002l]M8200000080oooo00<000000>jaSP3^/Hh01P3^/Hh00`000000oooo
0?ooo`040?ooo`040000001S3D@0H`e406<=A08000001P2XLID00`000000`9fd0<2M]0050<2M]0<0
0000J`3oool008L0oooo00<0000008ZRi00000000`0000000`3oool000000>jaSP070>jaSP030000
003oool0oooo00<0oooo00D0000006<=A01S3D@0H`e4000000060:QaU@8000001`30WK@01@000000
d/S@0=;8d03Bb=00000006X0oooo00250?ooo`80000000@0LP<M000000000000_;GB0P0000020?oo
o`030000003^/Hh0k[6>00@0k[6>00<000000?ooo`3oool00P3oool00`000000H`e406<=A00206<=
A0030000002XLID0Z76E00@0Z76E00<000000<2M]030WK@01@30WK@2000000@0d/S@00<000000?oo
o`3oool0J03oool008<0oooo0P00000407837@80000000D0_;GB000000000000oooo000000060>ja
SP050000003oool0oooo0?ooo`0000000`1S3D@2000000H0Z76E00<000000<2M]030WK@01@30WK@0
0`000000d/S@0=;8d0020=;8d0<00000JP3oool00880oooo00@00000058DHP0000000000101b0ad5
000000030?ooo`3^/Hh0k[6>00<0k[6>00<000000?ooo`3oool00P3oool20000000306<=A0000000
Z76E00D0Z76E0P0000060<2M]0800000103Bb=000`000000^ogF0000001[0?ooo`00PP3oool01@00
0000DQAR058DHP1B5680000000@0LP<M0`000000101j000000000000000000030>jaSP050000003o
ool0oooo0?ooo`0000000P3Aam000`000000Z76E0:QaU@040:QaU@0300000030WK@0`9fd00D0`9fd
00<000000=;8d03Bb=000`3Bb=03000001L0oooo00<000000?ooo`3oool0DP3oool00840oooo00<0
0000058DHP1B56800`1B568200000080LP<M1@0000001@1j000000000>jaSP3^/Hh0000000D0oooo
00@000000=77d03Aam000000102XLID00`000000`9fd0<2M]0050<2M]0030000003Bb=00d/S@0080
d/S@0`00000G0?ooo`<00000E03oool00800oooo00<00000058DHP1B56801P1B5682000000030783
7@000000000000L000001@3oool00`000000dLO@00000002000000030:QaU@000000000000H0`9fd
0P0000040=;8d0030000002koMH0000001L0oooo00D000000=OMf`3GgM/0emgK0000001C0?ooo`00
P03oool3000000P0DQAR2P0000060?ooo`030000002oW;@00000008000001`30WK@00`000000d/S@
0=;8d0020=;8d0@000005`3oool00`000000emgK0=OMf`020=OMf`030000003oool0oooo0540oooo
00200?ooo`040000000V8I@09R6D000000H0DQAR00<000000?ooo`000000200000070?ooo`@00000
1@30WK@2000000@0d/S@00<000000;_meP0000005`3oool2000000D0emgK00<000000?ooo`3oool0
D@3oool007`0oooo0P0000020?ooo`040000000V8I@09R6D02HQU08000000`1B5682000000030?oo
o`000000000000P000000`3oool8000000<0`9fd00<000000=;8d03Bb=000`3Bb=000`000000^ogF
0000000G0?ooo`030000003GgM/0emgK00D0emgK00<000000?ooo`3oool0D@3oool007P0oooo1000
000209^Oe`030000003oool0000000D09R6D3P0000000`2ZGWH000000<i/D`0:000000030<2M]000
0000000000@0d/S@0P0000000`2koMH000000?ooo`0F0?ooo`030000003GgM/0emgK00L0emgK00<0
00000?ooo`3oool0D03oool007D0oooo0`00000609^Oe`040000003oool00000000000H09R6D2P00
00040:YNMP030000003>K5<0000000T000001@3Bb=0010000000^ogF00000000000F0?ooo`800000
2P3GgM/00`000000oooo0?ooo`1@0?ooo`00LP3oool3000000X0VioG00<000000?ooo`0000000P00
000402HQU0030000003oool0oooo00H0000000@0SenE0000002ZGWH0ZUif0`0000000`3>K5<00000
0000000500000080Z7:F00L000000=;8d03Bb=00d/S@0000002koMH0000001L0oooo00<000000=OM
f`3GgM/0203GgM/2000005<0oooo001^0?ooo`@000003@2KWmL00`000000oooo00000002000Y/`05
0000000V8I@09R6D02HQU00000000`3oool500000080SenE0P000000102lQi`00000000000000002
07837@<000000P3oool010000000Z7:F0000003Bb=02000000030;_meP000000oooo01H0oooo00<0
00000=OMf`3GgM/0203GgM/00`000000oooo0?ooo`1C0?ooo`00J`3oool300000180VioG00<00000
0?ooo`0000000P00:K<00`0000009R6D02HQU00800000080SenE00<000000:^5Z`0000000P000006
07837@8000000P3oool010000000J1=90000002koMH2000001H0oooo0P00000:0=OMf`030000003o
ool0oooo05@0oooo001W0?ooo`@000005P2KWmL00`000000oooo00000002000Y/`<000000`1g2RD3
00000080SenE00D000000:^5Z`2[QJ/00000058DHP02000000H0LP<M0`000000103oool000000000
0000000G0?ooo`030000003GgM/0emgK00P0emgK0P00000J0?ooo`030000003oool0oooo03X0oooo
001T0?ooo`<000006P2KWmL00`000000oooo0?ooo`020000008002Vc00H0000007L:9@1g2RD0M`XU
0000000V8I@3000000<0ZhF[00D00000058DHP1B5680DQAR0000000707837@80000000<0oooo0000
003oool05P3oool00`000000emgK0=OMf`080=OMf`030000003oool0oooo01T0oooo0P00000l0?oo
o`00H@3oool3000001h0VioG00H000000?ooo`3oool0oooo00000000:K<200000080M`XU00@00000
02HQU0000000O6bg10000005058DHP8000001P1b0ad3000001D0oooo0P00000:0=OMf`030000003o
ool0oooo01P0oooo0P0000020=SOg0030000003oool0oooo03T0oooo001M0?ooo`@000008@2KWmL0
0`000000oooo0?ooo`020?ooo`0500000000:K<000000000001g2RD00P00000207a/]`030000002R
S[l0000000P0DQAR00<0000007837@1b0ad0101b0ad3000001<0oooo00<000000=OMf`3GgM/0203G
gM/2000001X0oooo00<000000=SOg03Hgm`00P3Hgm`00`000000oooo0?ooo`0i0?ooo`00FP3oool3
000002D0VioG0P0000040?ooo`80000000@0Q00000000000000000000P1lK;L00`000000XXjo0000
0002000000<0DQAR00@00000058DHP1B5680DQAR0P00000207837@<0000000@0036i000000000000
0000403oool00`000000emgK0=OMf`080=OMf`030000003oool0oooo01T0oooo00<000000=SOg03H
gm`00`3Hgm`00`000000oooo0?ooo`0i0?ooo`00E`3oool3000002@0VioG1@0000070?ooo`T00000
0P0V8I@00`000000DQAR058DHP06058DHP<000000P0^9iL200000003000a^@000000000000d0oooo
0P00000:0=OMf`030000003oool0oooo01P0oooo0P0000060=SOg0030000003oool0oooo03T0oooo
001C0?ooo`@00000902KWmL300000080oooo0P0000000`1S3D@00000000000040?ooo`H000000P1]
RMh00`0000009R6D02HQU00202HQU0800000101B568200000080oooo00<0000002hWU`0^9iL00P0^
9iL010000000036i000a^@00000;0?ooo`030000003GgM/0emgK00P0emgK0P00000J0?ooo`030000
003Hgm`0f=oL00L0f=oL00<000000?ooo`3oool0>03oool00540oooo0P00000U09^Oe`<00000103o
ool00`000000H`e406<=A002000000030:QaU@000000oooo0080oooo1P00000206f9gP030000000V
8I@09R6D00@09R6D00<00000058DHP1B56800`0000020?ooo`030000000^9iL0;RNG00<0;RNG0`00
000:0?ooo`030000003GgM/0emgK00P0emgK00<000000?ooo`3oool06@3oool00`000000f=oL0=SO
g0080=SOg0030000003oool0oooo03P0oooo001B0?ooo`030000002KWmL0VioG01l0VioG10000006
0?ooo`040000001S3D@0H`e4000000@0Z76E2P0000000`1]RMh0000002HQU00602HQU080000000<0
DQAR0000000000000P0000000`1G6VH0000002hWU`0502hWU`8000001`3oool2000000X0emgK00<0
00000?ooo`3oool0603oool2000000T0f=oL0P00000k0?ooo`00DP3oool00`000000VioG09^Oe`0L
09^Oe`<00000203oool200000080H`e400<000000:QaU@2XLID00`2XLID>000000L09R6D1P000000
0`1G6VH000000000000602hWU`030000003oool0oooo00<0oooo00<000000=OMf`3GgM/0203GgM/2
000001X0oooo00<000000=SOg03Hgm`0203Hgm`00`000000oooo0?ooo`0k0?ooo`00D`3oool00`00
0000VioG09^Oe`0G09^Oe`@000002P3oool00`000000H`e406<=A002000000@0Z76E0`0000000`30
WK@0000000000005000000<0oooo00<00000000Y/`0000001P0V8I@80000000305LJIP000000;RNG
00@0;RNG00<000000?ooo`3oool00P3oool00`000000emgK0=OMf`080=OMf`030000003oool0oooo
01T0oooo00<000000=SOg03Hgm`0203Hgm`00`000000oooo0?ooo`0l0?ooo`00D`3oool00`000000
VioG09^Oe`0D09^Oe`<000003@3oool010000000H`e406<=A00000050:QaU@8000000`30WK@50000
00H0oooo00@00000000Y/`0000000000100V8I@400000080EaYV0`0000000`1G6VH0000002hWU`03
02hWU`030000003oool0oooo008000002P3GgM/00`000000oooo0?ooo`0I0?ooo`030000003Hgm`0
f=oL00L0f=oL0P00000o0?ooo`00E03oool00`000000VioG09^Oe`0@09^Oe`<000003P3oool20000
0080H`e400<000000:QaU@2XLID0102XLID00`000000`9fd0<2M]0030<2M]0030000003oool0oooo
00P0oooo00@00000000Y/`00:K<000000P0V8I@4000000@0EaYV1P0000001@0^9iL000000?ooo`3o
ool0000000X0emgK0P00000J0?ooo`8000002@3Hgm`00`000000oooo0?ooo`0o0?ooo`00E@3oool0
0`000000VioG09^Oe`0;09^Oe`@00000403oool00`000000H`e406<=A002000000D0Z76E0P000006
0<2M]0030000003oool0oooo00T0oooo0P0000001000:K<0000000000000000307L:9@800000101G
6VH30000000505LJIP00000000000?ooo`0000002P3GgM/00`000000oooo0?ooo`0I0?ooo`030000
003Hgm`0f=oL00P0f=oL00<000000?ooo`3oool0@03oool005D0oooo00<0000009^Oe`2KWmL0202K
WmL300000180oooo0P00000206<=A0030000002XLID0Z76E00@0Z76E00<000000<2M]030WK@01`30
WK@00`000000oooo0?ooo`080?ooo`030000003G/k@00000008002Vc00<0000007L:9@1g2RD00`1g
2RD00`000000EaYV05LJIP0205LJIPD0000000<0oooo0000003GgM/0203GgM/00`000000oooo0?oo
o`0I0?ooo`030000003Hgm`0f=oL00L0f=oL0P0000130?ooo`00EP3oool00`000000VioG09^Oe`04
09^Oe`<00000503oool01@000000H`e406<=A01S3D@0000000H0Z76E00<000000<2M]030WK@01P30
WK@2000000030=;8d0000000oooo00L0oooo00@000000=Nc]03G/k@0ek>d0P0000000`00:K<00000
07L:9@0407L:9@800000101G6VH4000000030?ooo`000000emgK00D0emgK0P00000J0?ooo`800000
2@3Hgm`00`000000oooo0?ooo`130?ooo`00EP3oool00`000000VioG09^Oe`04000001H0oooo00<0
000006<=A01S3D@00P0000050:QaU@8000002030WK@01@000000d/S@0=;8d03Bb=00000000L0oooo
00<000000=Nc]03G/k@00`3G/k@4000000H0M`XU00<0000005LJIP1G6VH00P1G6VH01@000000mZY]
0000003oool0000000D0emgK00<000000?ooo`3oool06@3oool00`000000f=oL0=SOg0080=SOg003
0000003oool0oooo04@0oooo001G0?ooo`800000603oool200000080H`e400<000000:QaU@2XLID0
102XLID00`000000`9fd0<2M]0070<2M]0030000003Bb=00d/S@00<0d/S@00<000000?ooo`3oool0
103oool2000000@0ek>d1@00000607L:9@80000000<0EaYV0000003fZVd00P3fZVd00`000000oooo
000000030=OMf`030000003oool0oooo01T0oooo00<000000=SOg03Hgm`01`3Hgm`2000004L0oooo
001`0?ooo`050000001S3D@0H`e406<=A00000001P2XLID00`000000`9fd0<2M]0060<2M]0800000
1@3Bb=02000000H0oooo0P0000050=Nc]0H000001@1g2RD2000000080=Rd]0000000mZY]0?JZK@00
0000oooo0000003GgM/2000001/0oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`17
0?ooo`00K`3oool00`000000H`e406<=A002000000D0Z76E0P0000050<2M]00400000030WK@0`9fd
000000D0d/S@00<000000;_meP0000001P3oool010000000m:]c0?B[L`0000040=Nc]0L000000P1g
2RD2000000@0f;Bd00H000000?JZK@3fZVd000000?ooo`00000K0?ooo`8000002@3Hgm`00`000000
oooo0?ooo`180?ooo`00K@3oool200000080H`e400<000000:QaU@2XLID0102XLID00`000000`9fd
0<2M]0030<2M]00300000030WK@0`9fd008000001@3Bb=000`000000^ogF0?ooo`070?ooo`040000
003dZg<0m:]c000000D0ek>d200000060=Rd]0040000003fZVd0mZY]000001`0oooo00<000000=SO
g03Hgm`01`3Hgm`2000004/0oooo001/0?ooo`050000001S3D@0H`e406<=A00000001P2XLID00`00
0000`9fd0<2M]0020<2M]08000000P30WK@00`000000d/S@0=;8d0030=;8d0<000002P3oool00`00
0000m:]c0?B[L`05000000030;V/c0000000000000<000000P2i[<`00`000000f;Bd0=Rd]0040=Rd
]0040000003fZVd0mZY]000001X0oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`1;
0?ooo`00J`3oool00`000000H`e406<=A002000000D0Z76E0P0000030<2M]0<0000000<0`9fd0000
000000001@3Bb=000`000000^ogF0000000;0?ooo`@000001029V=`5000000<0^Jc<00<000000=Rd
]03H];@0103H];@01@000000mZY]0?JZK@3fZVd0000001L0oooo0P0000090=SOg0030000003oool0
oooo04`0oooo001Y0?ooo`050000001S3D@0H`e406<=A00000001P2XLID010000000`9fd0<2M]030
WK@300000080`9fd00<000000=;8d03Bb=00103Bb=02000000h0oooo0P00000508VHg0030000002i
[<`0000000H0^Jc<00<000000=Rd]03H];@0103H];@010000000mZY]0?JZK@00000F0?ooo`030000
003Hgm`0f=oL00L0f=oL0P00001?0?ooo`00J03oool01@000000H`e406<=A01S3D@0000000H0Z76E
00<000000<2M]030WK@0100000020<2M]0030000003Bb=00d/S@00<0d/S@0`00000?0?ooo`800000
1P29V=`00`000000^Jc<0;V/c0050;V/c0030000003H];@0f;Bd00@0f;Bd00D000000?JZK@3fZVd0
mZY]0000000D0?ooo`030000003Hgm`0f=oL00L0f=oL00<000000?ooo`3oool0C`3oool006P0oooo
00<0000006<=A00000001P2XLID2000000030<2M]00000000000008000000P30WK@2000000D0d/S@
00<000000;_meP0000004@3oool2000000H0RISL00<000000;V/c02i[<`01@2i[<`00`000000f;Bd
0=Rd]0040=Rd]0040000003fZVd0mZY]00000180oooo0P0000090=SOg0030000003oool0oooo0500
oooo001Y0?ooo`030000002XLID0Z76E00@0Z76E00@000000<2M]030WK@0`9fd0`0000020<2M]003
0000003Bb=00d/S@00@0d/S@0P00000D0?ooo`8000001@29V=`00`000000^Jc<0;V/c0060;V/c003
0000003H];@0f;Bd00@0f;Bd00@000000?JZK@3fZVd00000403oool00`000000f=oL0=SOg0070=SO
g0800000D`3oool006T0oooo0P0000040:QaU@0300000030WK@0`9fd00<0`9fd00@000000<2M]000
000000001@3Bb=03000001D0oooo0P00000608VHg0030000002i[<`0^Jc<00D0^Jc<00<000000=Rd
]03H];@0103H];@01@000000mZY]0?JZK@3fZVd0000000h0oooo00<000000=SOg03Hgm`01`3Hgm`0
0`000000oooo0?ooo`1C0?ooo`00JP3oool2000000030:QaU@000000000000L0`9fd00<000000=;8
d03Bb=00103Bb=03000001L0oooo0P00000508VHg0030000002i[<`0^Jc<00H0^Jc<00<000000=Rd
]03H];@0103H];@010000000mZY]0?JZK@00000=0?ooo`030000003Hgm`0f=oL00L0f=oL00<00000
0?ooo`3oool0E03oool006/0oooo1@0000040<2M]08000001P3Bb=02000001P0oooo00@000000?oo
o`00000000001@29V=`00`000000^Jc<0;V/c0060;V/c0030000003H];@0f;Bd00<0f;Bd00D00000
0?JZK@3fZVd0mZY]0000000:0?ooo`800000203Hgm`2000005L0oooo001Y0?ooo`P000000P30WK@0
0`000000d/S@0=;8d0040=;8d0<00000603oool2000000030?ooo`000000000000H0RISL00<00000
0;V/c02i[<`01@2i[<`00`000000f;Bd0=Rd]0040=Rd]0040000003fZVd0mZY]000000T0oooo00<0
00000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`1G0?ooo`00J03oool800000080`9fd00<00000
0=;8d03Bb=00103Bb=03000001L0oooo0P0000020=OMf`040000003oool00000000000D0RISL00<0
00000;V/c02i[<`01P2i[<`00`000000f;Bd0=Rd]0040=Rd]0040000003fZVd0mZY]000000L0oooo
00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`1H0?ooo`00I`3oool8000000030<2M]000
0000000000H0d/S@0P00000H0?ooo`030000003GgM/0emgK0080emgK00D000000?ooo`00000002Na
0000000508VHg0030000002i[<`0^Jc<00H0^Jc<00<000000=Rd]03H];@00`3H];@010000000mZY]
0?JZK@0000050?ooo`800000203Hgm`2000005/0oooo001V0?ooo`P0000000<0Z7:F0000003Bb=00
1@3Bb=03000001P0oooo00<000000=OMf`3GgM/00`3GgM/00`000000oooo0?ooo`02000000H0RISL
00<000000;V/c02i[<`01@2i[<`00`000000f;Bd0=Rd]0040=Rd]0040000003fZVd00000000000<0
oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`1K0?ooo`00I03oool800000080oooo
0P0000050=;8d0<000005`3oool2000000L0emgK00<000000?ooo`3oool00P00000508VHg0030000
002i[<`0^Jc<00H0^Jc<00<000000=Rd]03H];@00`3H];@300000004000c^P000000oooo000000T0
f=oL00<000000?ooo`3oool0G03oool006<0oooo200000030?ooo`030000002XLYH0000000<0d/S@
0P00000H0?ooo`030000003GgM/0emgK00L0emgK00H000000?ooo`3oool00000000W/@00000508VH
g0030000002i[<`0^Jc<00D0^Jc<00<000000=Rd]03H];@0103H];@00`000000S9SJ000000030000
00L0f=oL0P00001O0?ooo`00HP3oool8000000D0oooo0P000000103Bb=00000000000000000H0?oo
o`030000003GgM/0emgK00H0emgK0P0000040?ooo`8000001P29V=`00`000000^Jc<0;V/c0050;V/
c0030000003H];@0f;Bd0080f;Bd00<0000008bHfP2<V=X00`0000000`3oool000000=SOg0040=SO
g0030000003oool0oooo05l0oooo001Q0?ooo`P000001`3oool4000001L0oooo0P0000080=OMf`03
0000003oool0oooo00D0oooo0P00000508VHg0030000002i[<`0^Jc<00H0^Jc<00@000000=Rd]03H
];@000000`2<V=X00`000000mZY]0?JZK@02000000@0f=oL00<000000?ooo`3oool0H03oool005l0
oooo2000000:0?ooo`030000003oool0oooo01H0oooo00<000000=OMf`3GgM/01`3GgM/00`000000
oooo0?ooo`060?ooo`03000000009k40000000D0RISL00<000000;V/c02i[<`01@2i[<`010000000
f;Bd00000000000308bHfP030000003fZVd0mZY]008000000`3Hgm`00`000000oooo0?ooo`1Q0?oo
o`00GP3oool8000002<0oooo00<000000=OMf`3GgM/01P3GgM/2000000X0oooo0P00000508VHg003
0000002i[<`0^Jc<00H0^Jc<0P0000001P2iZl/0000008bHfP000000f;Bd00000080mZY]0P000000
0`3Hgm`0oooo0?ooo`1S0?ooo`00G@3oool800000280oooo0P0000080=OMf`030000003oool0oooo
00X0oooo00<00000000W/@0000001@29V=`00`000000^Jc<0;V/c0030;V/c0D0000000D0^J_;0000
003H];@0f;Bd000000030?JZK@030000003oool0oooo06@0oooo001L0?ooo`P000008P3oool00`00
0000emgK0=OMf`070=OMf`030000003oool0oooo00`0oooo00<00000000W/@0000001@29V=`01000
0000^Jc<0;V/c02i[<`6000000030;V[b`000000f;Bd0080f;Bd00@000000?JZK@3fZVd00000IP3o
ool005d0oooo1@00000S0?ooo`030000003GgM/0emgK00H0emgK0P00000@0?ooo`8000001@29V=`0
0`000000^Jc<00000008000000@0f;Bd00D000000?JZK@3fZVd0mZY]0000001U0?ooo`00GP3oool3
00000280oooo0P0000080=OMf`030000003oool0oooo0180oooo4@0000040=Rd]0040000003fZVd0
mZY]000006D0oooo001O0?ooo`030000003oool0oooo0200oooo00<000000=OMf`3GgM/01`3GgM/0
0`000000oooo0?ooo`0C0?ooo`040000003dZg<0m:]c000000@0ek>d2@0000050=Rd]0040000003f
ZVd0mZY]000006@0oooo00210?ooo`030000003GgM/0emgK00H0emgK0P00000F0?ooo`050000003d
Zg<0m:]c0?B[L`0000000`3G/k@:000000@0f;Bd00@000000?JZK@3fZVd00000I03oool007l0oooo
0P0000080=OMf`030000003oool0oooo01L0oooo00<000000?B[L`3dZg<03@0000060=Rd]0030000
003fZVd0000006@0oooo001n0?ooo`030000003GgM/0emgK00L0emgK00<000000?ooo`3oool0603o
ool4000000@0RISL1P0000000`2i[<`000000=Rd]0050=Rd]0800000I@3oool007d0oooo00<00000
0=OMf`3GgM/01P3GgM/2000001`0oooo0P00000508VHg0D000000`2i[<`00`000000f;Bd0=Rd]004
0=Rd]0030000003oool0oooo06<0oooo001k0?ooo`800000203GgM/00`000000oooo0?ooo`0K0?oo
o`030000003oool0000000H0RISL0P0000060;V/c0030000003H];@0f;Bd0080f;Bd00<000000?oo
o`3oool0I03oool007X0oooo00<000000=OMf`3GgM/01`3GgM/00`000000oooo0?ooo`0K0?ooo`80
000000<0oooo0000000000001@29V=`00`000000^Jc<0;V/c0050;V/c0050000003H];@0f;Bd0=Rd
]0000000I`3oool007T0oooo00<000000=OMf`3GgM/01P3GgM/2000001`0oooo0P0000020=SOg004
0000003oool00000000000D0RISL00<000000;V/c02i[<`01@2i[<`010000000f;Bd0=Rd]000001W
0?ooo`00M`3oool2000000P0emgK00<000000?ooo`3oool06`3oool00`000000f=oL0=SOg0020=SO
g0040000003oool0oooo000000H0RISL00<000000;V/c02i[<`0102i[<`00`000000f;Bd0000001X
0?ooo`00MP3oool00`000000emgK0=OMf`070=OMf`030000003oool0oooo01/0oooo00<000000=SO
g03Hgm`0103Hgm`010000000oooo00000000000508VHg0030000002i[<`0^Jc<00@0^Jc<0P00001Y
0?ooo`00M@3oool00`000000emgK0=OMf`060=OMf`800000703oool2000000L0f=oL00<000000?oo
o`3oool00P00000508VHg0040000002i[<`0^Jc<0;V/c0<00000JP3oool007H0oooo00<000000=OM
f`3GgM/0103GgM/00`000000oooo0?ooo`0K0?ooo`030000003Hgm`0f=oL00P0f=oL00@000000?oo
o`3oool000001@29V=`01@000000^Jc<000000000000oooo00<00000J@3oool007H0oooo00<00000
0=OMf`3GgM/00`3GgM/00`000000oooo0?ooo`0K0?ooo`030000003Hgm`0f=oL00L0f=oL0P000004
0?ooo`L000000`3oool4000006P0oooo001g0?ooo`030000003GgM/0emgK00800000703oool20000
00T0f=oL00<000000?ooo`3oool03`3oool4000006L0oooo001g0?ooo`030000003GgM/0000001d0
oooo00<000000=SOg03Hgm`0203Hgm`00`000000oooo0?ooo`0@0?ooo`D00000IP3oool007P0oooo
00<000000?ooo`3oool06`3oool00`000000f=oL0=SOg0070=SOg0800000503oool5000006D0oooo
002D0?ooo`8000002@3Hgm`00`000000oooo0?ooo`0D0?ooo`<0000000<0dZV_000000000000I03o
ool009<0oooo00<000000=SOg03Hgm`0203Hgm`00`000000oooo0?ooo`0E0?ooo`@0000000<0dZV_
0000003oool0H`3oool00980oooo00<000000=SOg03Hgm`01`3Hgm`2000001T0oooo0P000000102f
XlD0000000000000001S0?ooo`00T03oool2000000T0f=oL00<000000?ooo`3oool06@3oool01@00
0000RhoB000000000000dZV_00800000HP3oool008l0oooo00<000000=SOg03Hgm`0203Hgm`00`00
0000oooo0?ooo`0K0?ooo`050000002;Sm8000000000003BZJl00P00001Q0?ooo`00SP3oool00`00
0000f=oL0=SOg0070=SOg08000007P3oool01P000000RhoB0000002fXlD000000=:Y[`800000H03o
ool008`0oooo0P0000090=SOg0030000003oool0oooo01h0oooo0P0000000`2;Sm80000000000002
0=:Y[`800000G`3oool008/0oooo00<000000=SOg03Hgm`0203Hgm`00`000000oooo0?ooo`0P0?oo
o`090000002;Sm8000000;JSa@000000dZV_0000003/WG40000005h0oooo002:0?ooo`030000003H
gm`0f=oL00L0f=oL0P00000S0?ooo`80000000D0RhoB0000002fXlD000000=:Y[`02000005h0oooo
00290?ooo`030000003Hgm`0f=oL00L0f=oL00<000000?ooo`3oool0903oool01@000000RhoB0000
002fXlD000000080dZV_0P00001M0?ooo`00Q`3oool2000000T0f=oL00<000000?ooo`3oool09@3o
ool01P000000RhoB08^?dP000000]Z?500000080dZV_0P00001L0?ooo`00QP3oool00`000000f=oL
0=SOg0070=SOg0800000:03oool20000000408^?dP000000]Z?500000080dZV_00<000000>bML@00
0000F`3oool008D0oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`0Y0?ooo`060000
002;Sm80RhoB0000002fXlD000000P3BZJl2000005/0oooo00230?ooo`800000203Hgm`2000002`0
oooo0P0000001@2;Sm8000000;JSa@2fXlD000000080dZV_00<000000?ooo`3oool0F@3oool00880
oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`0]0?ooo`080000002;Sm80RhoB0000
002fXlD000000=:Y[`00001L0?ooo`00P@3oool00`000000f=oL0=SOg0070=SOg0030000003oool0
oooo02h0oooo0P0000000`2;Sm8000000;JSa@02000005d0oooo001o0?ooo`800000203Hgm`20000
0380oooo1000001O0?ooo`00OP3oool00`000000f=oL0=SOg0070=SOg0030000003oool0oooo09D0
oooo001m0?ooo`030000003Hgm`0f=oL00L0f=oL00<000000?ooo`3oool0UP3oool007/0oooo0P00
00080=SOg0800000V@3oool007X0oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`2I
0?ooo`00N@3oool00`000000f=oL0=SOg0070=SOg0030000003oool0oooo09X0oooo001g0?ooo`80
0000203Hgm`2000009d0oooo001f0?ooo`030000003Hgm`0f=oL00L0f=oL00<000000?ooo`3oool0
W@3oool007D0oooo00<000000=SOg03Hgm`01`3Hgm`00`000000oooo0?ooo`2N0?ooo`00MP3oool0
0`000000f=oL0=SOg0040=SOg0800000X@3oool007H0oooo00<000000=SOg03Hgm`00`3Hgm`00`00
0000oooo0?ooo`2Q0?ooo`00M`3oool01@000000f=oL0=SOg03Hgm`000000:@0oooo001g0?ooo`04
0000003Hgm`0f=oL00000:D0oooo001h0?ooo`030000003oool0oooo0:D0oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.52832 .70303 m .6189 .61101 L .63794 .58733 L p .655 .909 .593 r
F P
0 g
s
.63794 .58733 m .54739 .67904 L .5393 .68922 L p .655 .909 .593 r
F P
0 g
s
.63794 .58733 m .5393 .68922 L .53327 .6978 L .655 .909 .593 r
F
.54412 .71573 m .55382 .7285 L p .54476 .68143 L .141 .194 .658 r
F P
0 g
s
.5446 .68057 m .54458 .68169 L p .54476 .68143 L .141 .194 .658 r
F P
0 g
s
.54458 .68169 m .54412 .71573 L p .54476 .68143 L .141 .194 .658 r
F P
0 g
s
.5393 .68922 m .52832 .70303 L p .53327 .6978 L .655 .909 .593 r
F P
0 g
s
.43781 .52388 m .39552 .43009 L .39456 .39377 L p 0 0 .476 r
F P
0 g
s
.42509 .51355 m .41998 .52984 L p .44269 .53125 L .61 .474 .672 r
F P
0 g
s
.49163 .53428 m .44035 .5183 L p .44269 .53125 L .61 .474 .672 r
F P
0 g
s
.39456 .39377 m .43274 .47629 L p .43781 .52388 L 0 0 .476 r
F P
0 g
s
.43748 .50244 m .43781 .52388 L p .43274 .47629 L 0 0 .476 r
F P
0 g
s
.44035 .5183 m .42509 .51355 L p .44269 .53125 L .61 .474 .672 r
F P
0 g
s
.43274 .47629 m .43722 .48596 L .43748 .50244 L p 0 0 .476 r
F P
0 g
s
.59678 .56167 m .61431 .53901 L p .53457 .62167 L .693 .935 .632 r
F P
0 g
s
.53415 .62232 m .59678 .56167 L p .53457 .62167 L .693 .935 .632 r
F P
0 g
s
.61431 .53901 m .5486 .60238 L .53864 .61541 L p .693 .935 .632 r
F P
0 g
s
.53864 .61541 m .53106 .62531 L p .53457 .62167 L .693 .935 .632 r
F P
0 g
s
.61431 .53901 m .53864 .61541 L .53457 .62167 L .693 .935 .632 r
F
.55462 .67975 m .55599 .597 L .55296 .59334 L p .141 .194 .658 r
F P
0 g
s
.55296 .59334 m .54591 .58482 L p .54747 .60181 L .141 .194 .658 r
F P
0 g
s
.55462 .67975 m .55296 .59334 L .54747 .60181 L .141 .194 .658 r
F
.54478 .6672 m .55462 .67975 L p .54747 .60181 L F P
0 g
s
.54591 .58482 m .54564 .60463 L p .54747 .60181 L .141 .194 .658 r
F P
0 g
s
.54564 .60463 m .54478 .6672 L p .54747 .60181 L .141 .194 .658 r
F P
0 g
s
.53106 .62531 m .53415 .62232 L p .53457 .62167 L .693 .935 .632 r
F P
0 g
s
.51886 .81045 m .52731 .81356 L .51601 .73503 L closepath p .513 .564 .844 r
F P
0 g
s
.50914 .81103 m .51886 .81045 L .51601 .73503 L closepath p .712 .724 .86 r
F P
0 g
s
.50183 .8151 m .50914 .81103 L .51601 .73503 L closepath p .876 .865 .825 r
F P
0 g
s
.52731 .81356 m .53131 .81921 L .51601 .73503 L closepath p 0 .124 .649 r
F P
0 g
s
.49971 .82114 m .50183 .8151 L .51601 .73503 L closepath p .856 .83 .356 r
F P
0 g
s
.53131 .81921 m .52929 .82528 L .51601 .73503 L closepath p .999 .814 .476 r
F P
0 g
s
.50364 .82684 m .49971 .82114 L .51601 .73503 L closepath p .227 .216 .637 r
F P
0 g
s
.52929 .82528 m .52197 .82941 L .51601 .73503 L closepath p .864 .769 .755 r
F P
0 g
s
.51215 .83002 m .50364 .82684 L .51601 .73503 L closepath p .567 .531 .775 r
F P
0 g
s
.52197 .82941 m .51215 .83002 L .51601 .73503 L closepath p .724 .665 .792 r
F P
0 g
s
.50091 .67495 m .50086 .71005 L .52395 .70875 L p .72 .691 .822 r
F P
0 g
s
.52395 .70875 m .52423 .67366 L .50091 .67495 L p .72 .691 .822 r
F P
0 g
s
.52423 .67366 m .52395 .70875 L .54412 .71573 L p .548 .548 .807 r
F P
0 g
s
.48325 .68397 m .48338 .71919 L .50086 .71005 L p .87 .81 .788 r
F P
0 g
s
.50086 .71005 m .50091 .67495 L .48325 .68397 L p .87 .81 .788 r
F P
0 g
s
.54412 .71573 m .5446 .68057 L .52423 .67366 L p .548 .548 .807 r
F P
0 g
s
.47796 .69746 m .47814 .73284 L .48338 .71919 L p .976 .853 .459 r
F P
0 g
s
.48338 .71919 m .48325 .68397 L .47796 .69746 L p .976 .853 .459 r
F P
0 g
s
.55382 .7285 m .5544 .69318 L .5446 .68057 L p .141 .194 .658 r
F P
0 g
s
.5544 .69318 m .55382 .7285 L .54915 .7423 L p .955 .84 .413 r
F P
0 g
s
.50105 .57938 m .50093 .6616 L .52433 .66032 L p .72 .691 .822 r
F P
0 g
s
.52433 .66032 m .52499 .57815 L .50105 .57938 L p .72 .691 .822 r
F P
0 g
s
.52499 .57815 m .52433 .66032 L .54478 .6672 L p .548 .548 .807 r
F P
0 g
s
.48291 .58808 m .48321 .67058 L .50093 .6616 L p .87 .81 .788 r
F P
0 g
s
.50093 .6616 m .50105 .57938 L .48291 .58808 L p .87 .81 .788 r
F P
0 g
s
.48734 .71035 m .48743 .74476 L p .47814 .73284 L .095 .162 .643 r
F P
0 g
s
.48704 .74533 m .47814 .73284 L p .48743 .74476 L .095 .162 .643 r
F P
0 g
s
.48743 .74588 m .48734 .71035 L .50803 .71758 L p .54 .546 .81 r
F P
0 g
s
.37611 .85766 m .48442 .74763 L .49238 .73756 L p .655 .909 .593 r
F P
0 g
s
.49238 .73756 m .50346 .72354 L p .49822 .72906 L .655 .909 .593 r
F P
0 g
s
.49822 .72906 m .37611 .85766 L .49238 .73756 L .655 .909 .593 r
F
.48743 .74476 m .48743 .74588 L .48704 .74533 L p .095 .162 .643 r
F P
0 g
s
.47814 .73284 m .47796 .69746 L .48734 .71035 L p .095 .162 .643 r
F P
0 g
s
.51989 .53861 m .55815 .50391 L .55383 .48878 L p .926 .755 .651 r
F P
0 g
s
.55815 .50391 m .51989 .53861 L .53192 .55098 L p .822 .548 .523 r
F P
0 g
s
.53192 .55098 m .5699 .51598 L .55815 .50391 L p .822 .548 .523 r
F P
0 g
s
.5699 .51598 m .53192 .55098 L .54694 .55568 L p .644 .285 .347 r
F P
0 g
s
.54694 .55568 m .58468 .52045 L .5699 .51598 L p .644 .285 .347 r
F P
0 g
s
.54478 .6672 m .54591 .58482 L .52499 .57815 L p .548 .548 .807 r
F P
0 g
s
.51535 .52319 m .55383 .48878 L .55861 .47625 L p .915 .98 .749 r
F P
0 g
s
.55383 .48878 m .51535 .52319 L .51989 .53861 L p .926 .755 .651 r
F P
0 g
s
.58468 .52045 m .54694 .55568 L .55932 .55086 L p .091 0 0 r
F P
0 g
s
.55932 .55086 m .59693 .51559 L .58468 .52045 L p .091 0 0 r
F P
0 g
s
.47747 .6011 m .47789 .68315 L p .48321 .67058 L .976 .853 .459 r
F P
0 g
s
.47834 .68289 m .48321 .67058 L p .47789 .68315 L .976 .853 .459 r
F P
0 g
s
.48321 .67058 m .48291 .58808 L .47747 .6011 L p .976 .853 .459 r
F P
0 g
s
.47789 .68315 m .47789 .68401 L .47834 .68289 L p .976 .853 .459 r
F P
0 g
s
.48731 .69684 m .47789 .68401 L p .47804 .68292 L .095 .162 .643 r
F P
0 g
s
.48711 .61356 m .48724 .66834 L p .47804 .68292 L .095 .162 .643 r
F P
0 g
s
.48724 .66834 m .48731 .69684 L p .47804 .68292 L .095 .162 .643 r
F P
0 g
s
.47789 .68401 m .47747 .6011 L .48711 .61356 L p .095 .162 .643 r
F P
0 g
s
.48731 .69684 m .48711 .61356 L .50836 .62054 L p .54 .546 .81 r
F P
0 g
s
.48397 .6709 m .49382 .65792 L p .45404 .69686 L .693 .935 .632 r
F P
0 g
s
.50836 .62054 m .50808 .70403 L .48731 .69684 L p .54 .546 .81 r
F P
0 g
s
.49382 .65792 m .50148 .64782 L p .49778 .65165 L .693 .935 .632 r
F P
0 g
s
.49778 .65165 m .45404 .69686 L .49382 .65792 L .693 .935 .632 r
F
.4078 .74465 m .46172 .69245 L p .45404 .69686 L F P
0 g
s
.46172 .69245 m .48397 .6709 L p .45404 .69686 L .693 .935 .632 r
F P
0 g
s
.54915 .7423 m .54969 .70682 L .5544 .69318 L p .955 .84 .413 r
F P
0 g
s
.54969 .70682 m .54915 .7423 L .5316 .7518 L p .875 .819 .79 r
F P
0 g
s
.50803 .71758 m .50791 .75318 L .48743 .74588 L p .54 .546 .81 r
F P
0 g
s
.55861 .47625 m .52007 .51052 L .51535 .52319 L p .915 .98 .749 r
F P
0 g
s
.52007 .51052 m .55861 .47625 L .57079 .47115 L p .046 0 0 r
F P
0 g
s
.59693 .51559 m .55932 .55086 L .56427 .53825 L p .907 .983 .734 r
F P
0 g
s
.56427 .53825 m .60194 .50312 L .59693 .51559 L p .907 .983 .734 r
F P
0 g
s
.55599 .597 m .55462 .67975 L .54989 .69333 L p .955 .84 .413 r
F P
0 g
s
.5316 .7518 m .53196 .71621 L .54969 .70682 L p .875 .819 .79 r
F P
0 g
s
.53196 .71621 m .5316 .7518 L .50791 .75318 L p .72 .695 .826 r
F P
0 g
s
.50791 .75318 m .50803 .71758 L .53196 .71621 L p .72 .695 .826 r
F P
0 g
s
.53237 .50546 m .57079 .47115 L .58575 .47553 L p .639 .272 .331 r
F P
0 g
s
.57079 .47115 m .53237 .50546 L .52007 .51052 L p .046 0 0 r
F P
0 g
s
.60194 .50312 m .56427 .53825 L .5598 .52263 L p .932 .76 .646 r
F P
0 g
s
.5598 .52263 m .59768 .48778 L .60194 .50312 L p .932 .76 .646 r
F P
0 g
s
.48645 .55081 m .41998 .52984 L .41139 .54172 L p .642 .377 .503 r
F P
0 g
s
.41998 .52984 m .48645 .55081 L .49163 .53428 L p .61 .474 .672 r
F P
0 g
s
.42509 .51355 m .49163 .53428 L .49162 .5195 L p .547 .548 .807 r
F P
0 g
s
.49162 .5195 m .42481 .49889 L .42509 .51355 L p .547 .548 .807 r
F P
0 g
s
.54758 .51006 m .58575 .47553 L .59768 .48778 L p .825 .546 .516 r
F P
0 g
s
.58575 .47553 m .54758 .51006 L .53237 .50546 L p .639 .272 .331 r
F P
0 g
s
.59768 .48778 m .5598 .52263 L .54758 .51006 L p .825 .546 .516 r
F P
0 g
s
.478 .56294 m .41139 .54172 L .40249 .54467 L p .589 .084 .021 r
F P
0 g
s
.41139 .54172 m .478 .56294 L .48645 .55081 L p .642 .377 .503 r
F P
0 g
s
.42481 .49889 m .49162 .5195 L .48635 .51203 L p .297 .606 .953 r
F P
0 g
s
.48635 .51203 m .41919 .49139 L .42481 .49889 L p .297 .606 .953 r
F P
0 g
s
.54989 .69333 m .55116 .61017 L .55599 .597 L p .955 .84 .413 r
F P
0 g
s
.55116 .61017 m .54989 .69333 L .5321 .70268 L p .875 .819 .79 r
F P
0 g
s
.50346 .72354 m .39494 .83345 L .37611 .85766 L p .655 .909 .593 r
F P
0 g
s
.5321 .70268 m .53296 .61924 L .55116 .61017 L p .875 .819 .79 r
F P
0 g
s
.53296 .61924 m .5321 .70268 L .50808 .70403 L p .72 .695 .826 r
F P
0 g
s
.03 w
.51611 .71712 m
.51619 .70358 L
s
.5 Mabswid
.40249 .54467 m .46941 .56608 L .478 .56294 L p .589 .084 .021 r
F P
0 g
s
.40249 .54467 m .39669 .53742 L p .41595 .54501 L .267 .597 .951 r
F P
0 g
s
.46396 .55886 m .39669 .53742 L .3963 .52261 L p .541 .546 .809 r
F P
0 g
s
.39669 .53742 m .46396 .55886 L .46941 .56608 L p .267 .597 .951 r
F P
0 g
s
.19868 .58311 m .40059 .55564 L .40003 .53391 L p .755 .719 .819 r
F P
0 g
s
.46383 .54392 m .3963 .52261 L .40151 .50597 L p .607 .472 .671 r
F P
0 g
s
.3963 .52261 m .46383 .54392 L .46396 .55886 L p .541 .546 .809 r
F P
0 g
s
.40003 .53391 m .39959 .5172 L p .38359 .52245 L .755 .719 .819 r
F P
0 g
s
.38359 .52245 m .19868 .58311 L .40003 .53391 L .755 .719 .819 r
F
.46941 .56608 m .42646 .55234 L p .41595 .54501 L .267 .597 .951 r
F P
0 g
s
.42646 .55234 m .40249 .54467 L p .41595 .54501 L .267 .597 .951 r
F P
0 g
s
.41919 .49139 m .48635 .51203 L .47776 .51485 L p .571 .053 0 r
F P
0 g
s
.47776 .51485 m .41029 .49404 L .41919 .49139 L p .571 .053 0 r
F P
0 g
s
.50808 .70403 m .50836 .62054 L .53296 .61924 L p .72 .695 .826 r
F P
0 g
s
.41029 .49404 m .47776 .51485 L .46913 .52704 L p .639 .371 .496 r
F P
0 g
s
.46913 .52704 m .40151 .50597 L .41029 .49404 L p .639 .371 .496 r
F P
0 g
s
.40151 .50597 m .46913 .52704 L .46383 .54392 L p .607 .472 .671 r
F P
0 g
s
.51148 .57301 m .50169 .56529 L .50827 .55573 L p .749 .515 .577 r
F P
0 g
s
.50827 .55573 m .51965 .56106 L .51148 .57301 L p .749 .515 .577 r
F P
0 g
s
.4986 .54952 m .50827 .55573 L .50169 .56529 L p .833 .635 .635 r
F P
0 g
s
.51965 .56106 m .50827 .55573 L .51235 .54271 L p .706 .576 .707 r
F P
0 g
s
.50827 .55573 m .4986 .54952 L .50087 .54228 L p .792 .67 .729 r
F P
0 g
s
.50087 .54228 m .51235 .54271 L .50827 .55573 L p .792 .67 .729 r
F P
0 g
s
.51235 .54271 m .52474 .54483 L .51965 .56106 L p .706 .576 .707 r
F P
0 g
s
.52474 .54483 m .51235 .54271 L .51241 .5311 L p .672 .653 .823 r
F P
0 g
s
.51235 .54271 m .50087 .54228 L .50088 .53583 L p .776 .738 .817 r
F P
0 g
s
.50088 .53583 m .51241 .5311 L .51235 .54271 L p .776 .738 .817 r
F P
0 g
s
.5224 .57649 m .51148 .57301 L .51965 .56106 L p .642 .377 .503 r
F P
0 g
s
.51965 .56106 m .53055 .5645 L .5224 .57649 L p .642 .377 .503 r
F P
0 g
s
.53055 .5645 m .51965 .56106 L .52474 .54483 L p .61 .474 .672 r
F P
0 g
s
.52474 .54483 m .53565 .54823 L .53055 .5645 L p .61 .474 .672 r
F P
0 g
s
.53565 .54823 m .52474 .54483 L .52485 .53035 L p .547 .548 .807 r
F P
0 g
s
.02 w
.53169 .53798 m
.53375 .5361 L
s
.53375 .5361 m
.55449 .51717 L
s
.5 Mabswid
.51241 .5311 m .52485 .53035 L .52474 .54483 L p .672 .653 .823 r
F P
0 g
s
.50087 .54228 m .4986 .54952 L .49492 .55482 L p .956 .871 .713 r
F P
0 g
s
.50169 .56529 m .49492 .55482 L .4986 .54952 L p .833 .635 .635 r
F P
0 g
s
.50088 .53583 m .50087 .54228 L p .49492 .55482 L .956 .871 .713 r
F P
0 g
s
.53232 .57502 m .5224 .57649 L .53055 .5645 L p .445 .147 .364 r
F P
0 g
s
.53055 .5645 m .53886 .56536 L .53232 .57502 L p .445 .147 .364 r
F P
0 g
s
.53886 .56536 m .53055 .5645 L .53565 .54823 L p .451 .313 .601 r
F P
0 g
s
.53565 .54823 m .54296 .55226 L .53886 .56536 L p .451 .313 .601 r
F P
0 g
s
.54296 .55226 m .53565 .54823 L .5358 .53373 L p .327 .359 .742 r
F P
0 g
s
.52485 .53035 m .5358 .53373 L .53565 .54823 L p .547 .548 .807 r
F P
0 g
s
.50326 .57616 m .49506 .56776 L .50169 .56529 L p .81 .414 .303 r
F P
0 g
s
.50169 .56529 m .51148 .57301 L .50326 .57616 L p .81 .414 .303 r
F P
0 g
s
.49492 .55482 m .50169 .56529 L .49506 .56776 L p .912 .626 .488 r
F P
0 g
s
.52485 .53035 m .51241 .5311 L .50838 .52529 L p .601 .789 .971 r
F P
0 g
s
.51241 .5311 m .50088 .53583 L .49861 .53263 L p .779 .863 .912 r
F P
0 g
s
.49861 .53263 m .50838 .52529 L .51241 .5311 L p .779 .863 .912 r
F P
0 g
s
.51423 .57966 m .50326 .57616 L .51148 .57301 L p .589 .084 .021 r
F P
0 g
s
.51148 .57301 m .5224 .57649 L .51423 .57966 L p .589 .084 .021 r
F P
0 g
s
.03 w
.51667 .6201 m
.51691 .57862 L
s
.5 Mabswid
.5358 .53373 m .52485 .53035 L .5199 .52308 L p .296 .606 .953 r
F P
0 g
s
.50838 .52529 m .5199 .52308 L .52485 .53035 L p .601 .789 .971 r
F P
0 g
s
.49861 .53263 m .50088 .53583 L p .49492 .55482 L .956 .871 .713 r
F P
0 g
s
.49492 .53391 m .49861 .53263 L p .49492 .55482 L .956 .871 .713 r
F P
0 g
s
.49121 .53922 m .49492 .53391 L p .49492 .55482 L .956 .871 .713 r
F P
0 g
s
.48892 .54653 m .49121 .53922 L p .49492 .55482 L .956 .871 .713 r
F P
0 g
s
.01 w
.46648 .53548 m
.49006 .54287 L
s
.5 Mabswid
.48893 .55301 m .48892 .54653 L p .49492 .55482 L .956 .871 .713 r
F P
0 g
s
.49492 .55482 m .49123 .55616 L .48893 .55301 L p .956 .871 .713 r
F P
0 g
s
.49506 .56776 m .49123 .55616 L .49492 .55482 L p .912 .626 .488 r
F P
0 g
s
.52581 .57756 m .51423 .57966 L .5224 .57649 L p .061 0 0 r
F P
0 g
s
.5224 .57649 m .53232 .57502 L .52581 .57756 L p .061 0 0 r
F P
0 g
s
.5358 .53373 m .54311 .54061 L .54296 .55226 L p .327 .359 .742 r
F P
0 g
s
.54311 .54061 m .5358 .53373 L .53091 .52647 L p 0 .138 .665 r
F P
0 g
s
.5199 .52308 m .53091 .52647 L .5358 .53373 L p .296 .606 .953 r
F P
0 g
s
.53929 .56883 m .53232 .57502 L .53886 .56536 L p 0 0 0 r
F P
0 g
s
.53886 .56536 m .54293 .56346 L .53929 .56883 L p 0 0 0 r
F P
0 g
s
.54293 .56346 m .53886 .56536 L .54296 .55226 L p 0 0 .332 r
F P
0 g
s
.54296 .55226 m .54522 .55615 L .54293 .56346 L p 0 0 .332 r
F P
0 g
s
.54522 .55615 m .54296 .55226 L .54311 .54061 L p 0 0 .392 r
F P
0 g
s
.49092 .56211 m .48893 .55301 L .49123 .55616 L p .916 .568 .112 r
F P
0 g
s
.49123 .55616 m .49506 .56776 L .49092 .56211 L p .916 .568 .112 r
F P
0 g
s
.50838 .52529 m .49861 .53263 L .49492 .53391 L p .685 .98 .847 r
F P
0 g
s
.39959 .5172 m .19552 .54419 L .19868 .58311 L p .755 .719 .819 r
F P
0 g
s
.49813 .56914 m .49092 .56211 L .49506 .56776 L p 0 .097 .625 r
F P
0 g
s
.49506 .56776 m .50326 .57616 L .49813 .56914 L p 0 .097 .625 r
F P
0 g
s
.49492 .53391 m .50175 .52757 L .50838 .52529 L p .685 .98 .847 r
F P
0 g
s
.5199 .52308 m .50838 .52529 L .50175 .52757 L p .009 0 0 r
F P
0 g
s
.50148 .64782 m .4252 .72139 L .4078 .74465 L p .693 .935 .632 r
F P
0 g
s
.6355 .59784 m .56479 .57553 L .55651 .58796 L p .642 .377 .503 r
F P
0 g
s
.56479 .57553 m .6355 .59784 L .64084 .58079 L p .61 .474 .672 r
F P
0 g
s
.64084 .58079 m .57005 .55872 L .56479 .57553 L p .61 .474 .672 r
F P
0 g
s
.57005 .55872 m .64084 .58079 L .64144 .56572 L p .547 .548 .807 r
F P
0 g
s
.01 w
.57321 .56895 m
.57367 .56909 L
s
.5 Mabswid
.64144 .56572 m .57035 .54379 L .57005 .55872 L p .547 .548 .807 r
F P
0 g
s
.53569 .57023 m .52581 .57756 L .53232 .57502 L p .656 .969 .823 r
F P
0 g
s
.53232 .57502 m .53929 .56883 L .53569 .57023 L p .656 .969 .823 r
F P
0 g
s
.54311 .54061 m .5453 .54967 L .54522 .55615 L p 0 0 .392 r
F P
0 g
s
.53091 .52647 m .53921 .53481 L .54311 .54061 L p 0 .138 .665 r
F P
0 g
s
.5453 .54967 m .54311 .54061 L .53921 .53481 L p .894 .544 .064 r
F P
0 g
s
.4909 .55041 m .48892 .54653 L .48893 .55301 L p 0 0 .353 r
F P
0 g
s
.48893 .55301 m .49092 .56211 L .4909 .55041 L p 0 0 .353 r
F P
0 g
s
.50175 .52757 m .49492 .53391 L .49121 .53922 L p 0 0 0 r
F P
0 g
s
.50916 .57265 m .49813 .56914 L .50326 .57616 L p .267 .597 .951 r
F P
0 g
s
.50326 .57616 m .51423 .57966 L .50916 .57265 L p .267 .597 .951 r
F P
0 g
s
.53091 .52647 m .5199 .52308 L .51168 .52592 L p .572 .054 0 r
F P
0 g
s
.50175 .52757 m .51168 .52592 L .5199 .52308 L p .009 0 0 r
F P
0 g
s
.49505 .53717 m .49121 .53922 L .48892 .54653 L p 0 0 .302 r
F P
0 g
s
.48892 .54653 m .4909 .55041 L .49505 .53717 L p 0 0 .302 r
F P
0 g
s
.49121 .53922 m .49505 .53717 L .50175 .52757 L p 0 0 0 r
F P
0 g
s
.53569 .57023 m .53929 .56883 L .54293 .56346 L p .961 .879 .708 r
F P
0 g
s
.5335 .56708 m .53569 .57023 L p .54293 .56346 L .961 .879 .708 r
F P
0 g
s
.53357 .56057 m .5335 .56708 L p .54293 .56346 L .961 .879 .708 r
F P
0 g
s
.53588 .55319 m .53357 .56057 L p .54293 .56346 L .961 .879 .708 r
F P
0 g
s
.53954 .5478 m .53588 .55319 L p .54293 .56346 L .961 .879 .708 r
F P
0 g
s
.54314 .54647 m .53954 .5478 L p .54293 .56346 L .961 .879 .708 r
F P
0 g
s
.5453 .54967 m .54314 .54647 L p .54293 .56346 L .961 .879 .708 r
F P
0 g
s
.54293 .56346 m .54522 .55615 L .5453 .54967 L p .961 .879 .708 r
F P
0 g
s
.01 w
.53942 .55835 m
.54806 .56106 L
s
.5 Mabswid
.5218 .57192 m .50916 .57265 L .51423 .57966 L p .591 .793 .976 r
F P
0 g
s
.51423 .57966 m .52581 .57756 L .5218 .57192 L p .591 .793 .976 r
F P
0 g
s
.53921 .53481 m .53091 .52647 L .52274 .52934 L p .809 .404 .282 r
F P
0 g
s
.51168 .52592 m .52274 .52934 L .53091 .52647 L p .572 .054 0 r
F P
0 g
s
.62739 .61055 m .55651 .58796 L .54829 .59131 L p .589 .084 .021 r
F P
0 g
s
.55651 .58796 m .62739 .61055 L .6355 .59784 L p .642 .377 .503 r
F P
0 g
s
.57035 .54379 m .64144 .56572 L .63701 .55832 L p .297 .606 .953 r
F P
0 g
s
.63701 .55832 m .56552 .53635 L .57035 .54379 L p .297 .606 .953 r
F P
0 g
s
.53921 .53481 m .54314 .54647 L .5453 .54967 L p .894 .544 .064 r
F P
0 g
s
.49814 .55451 m .4909 .55041 L .49092 .56211 L p .309 .348 .74 r
F P
0 g
s
.49092 .56211 m .49813 .56914 L .49814 .55451 L p .309 .348 .74 r
F P
0 g
s
.51168 .52592 m .50175 .52757 L .49505 .53717 L p .432 .128 .348 r
F P
0 g
s
.5335 .56708 m .5218 .57192 L .52581 .57756 L p .778 .871 .916 r
F P
0 g
s
.52581 .57756 m .53569 .57023 L .5335 .56708 L p .778 .871 .916 r
F P
0 g
s
.54314 .54647 m .53921 .53481 L .5327 .53715 L p .916 .625 .477 r
F P
0 g
s
.01 w
.49492 .5444 m
.53472 .55688 L
s
.5 Mabswid
.52274 .52934 m .5327 .53715 L .53921 .53481 L p .809 .404 .282 r
F P
0 g
s
.5327 .53715 m .53954 .5478 L .54314 .54647 L p .916 .625 .477 r
F P
0 g
s
.50333 .53794 m .49505 .53717 L .4909 .55041 L p .442 .303 .596 r
F P
0 g
s
.4909 .55041 m .49814 .55451 L .50333 .53794 L p .442 .303 .596 r
F P
0 g
s
.49505 .53717 m .50333 .53794 L .51168 .52592 L p .432 .128 .348 r
F P
0 g
s
.50921 .558 m .49814 .55451 L .49813 .56914 L p .541 .546 .809 r
F P
0 g
s
.49813 .56914 m .50916 .57265 L .50921 .558 L p .541 .546 .809 r
F P
0 g
s
.02 w
.49025 .57582 m
.49861 .5682 L
s
.50921 .55851 m
.53025 .5393 L
s
.49861 .5682 m
.50365 .56359 L
s
.5 Mabswid
.52274 .52934 m .51168 .52592 L .50333 .53794 L p .639 .371 .496 r
F P
0 g
s
.03 w
.51695 .5722 m
.51718 .5318 L
s
.5 Mabswid
.51066 .41853 m .50251 .42202 L .5172 .52701 L closepath p .866 .772 .756 r
F P
0 g
s
.52148 .41804 m .51066 .41853 L .5172 .52701 L closepath p .724 .667 .793 r
F P
0 g
s
.53092 .42073 m .52148 .41804 L .5172 .52701 L closepath p .564 .53 .776 r
F P
0 g
s
.53539 .4256 m .53092 .42073 L .5172 .52701 L closepath p .211 .203 .631 r
F P
0 g
s
.53315 .43082 m .53539 .4256 L .5172 .52701 L closepath p .879 .846 .386 r
F P
0 g
s
.52499 .43438 m .53315 .43082 L .5172 .52701 L closepath p .874 .859 .823 r
F P
0 g
s
.51403 .43488 m .52499 .43438 L .5172 .52701 L closepath p .712 .722 .857 r
F P
0 g
s
.50453 .43213 m .51403 .43488 L .5172 .52701 L closepath p .518 .565 .842 r
F P
0 g
s
.50251 .42202 m .50015 .42721 L .5172 .52701 L closepath p .997 .812 .46 r
F P
0 g
s
.50015 .42721 m .50453 .43213 L .5172 .52701 L closepath p 0 .143 .66 r
F P
0 g
s
.03 w
.5172 .52763 m
.5172 .52701 L
s
.5 Mabswid
.5218 .57192 m .5335 .56708 L .53357 .56057 L p .778 .742 .82 r
F P
0 g
s
.53954 .5478 m .5327 .53715 L .52606 .54685 L p .836 .637 .633 r
F P
0 g
s
.52606 .54685 m .53588 .55319 L .53954 .5478 L p .836 .637 .633 r
F P
0 g
s
.52189 .56017 m .50921 .558 L .50916 .57265 L p .671 .654 .825 r
F P
0 g
s
.50916 .57265 m .5218 .57192 L .52189 .56017 L p .671 .654 .825 r
F P
0 g
s
.5327 .53715 m .52274 .52934 L .51442 .54139 L p .75 .513 .573 r
F P
0 g
s
.50333 .53794 m .51442 .54139 L .52274 .52934 L p .639 .371 .496 r
F P
0 g
s
.54829 .59131 m .61952 .6141 L .62739 .61055 L p .589 .084 .021 r
F P
0 g
s
.61952 .6141 m .54829 .59131 L .54328 .58414 L p .267 .597 .951 r
F P
0 g
s
.56552 .53635 m .63701 .55832 L .62916 .56155 L p .571 .053 0 r
F P
0 g
s
.62916 .56155 m .55731 .53938 L .56552 .53635 L p .571 .053 0 r
F P
0 g
s
.01 w
.54806 .56106 m
.57321 .56895 L
s
.5 Mabswid
.53357 .56057 m .52189 .56017 L .5218 .57192 L p .778 .742 .82 r
F P
0 g
s
.51442 .54139 m .52606 .54685 L .5327 .53715 L p .75 .513 .573 r
F P
0 g
s
.51442 .54139 m .50333 .53794 L .49814 .55451 L p .607 .472 .671 r
F P
0 g
s
.49814 .55451 m .50921 .558 L .51442 .54139 L p .607 .472 .671 r
F P
0 g
s
.52189 .56017 m .53357 .56057 L .53588 .55319 L p .794 .672 .73 r
F P
0 g
s
.53588 .55319 m .52606 .54685 L .52189 .56017 L p .794 .672 .73 r
F P
0 g
s
.40582 .64205 m .46783 .58582 L .46299 .57003 L p .926 .755 .651 r
F P
0 g
s
.46783 .58582 m .40582 .64205 L .41868 .65534 L p .822 .548 .523 r
F P
0 g
s
.41868 .65534 m .48024 .59861 L .46783 .58582 L p .822 .548 .523 r
F P
0 g
s
.48024 .59861 m .41868 .65534 L .43441 .66072 L p .644 .285 .347 r
F P
0 g
s
.43441 .66072 m .49559 .60362 L .48024 .59861 L p .644 .285 .347 r
F P
0 g
s
.52606 .54685 m .51442 .54139 L .50921 .558 L p .706 .576 .707 r
F P
0 g
s
.50921 .558 m .52189 .56017 L .52606 .54685 L p .706 .576 .707 r
F P
0 g
s
.40061 .62583 m .46299 .57003 L .46761 .55717 L p .915 .98 .749 r
F P
0 g
s
.46299 .57003 m .40061 .62583 L .40582 .64205 L p .926 .755 .651 r
F P
0 g
s
.49559 .60362 m .43441 .66072 L .44708 .65611 L p .091 0 0 r
F P
0 g
s
.44708 .65611 m .50811 .59888 L .49559 .60362 L p .091 0 0 r
F P
0 g
s
.61492 .60698 m .54328 .58414 L .54348 .56905 L p .541 .546 .809 r
F P
0 g
s
.54328 .58414 m .61492 .60698 L .61952 .6141 L p .267 .597 .951 r
F P
0 g
s
.55731 .53938 m .62916 .56155 L .62088 .57433 L p .639 .371 .496 r
F P
0 g
s
.62088 .57433 m .54886 .55189 L .55731 .53938 L p .639 .371 .496 r
F P
0 g
s
.46761 .55717 m .40508 .61276 L .40061 .62583 L p .915 .98 .749 r
F P
0 g
s
.40508 .61276 m .46761 .55717 L .48004 .55218 L p .046 0 0 r
F P
0 g
s
.50811 .59888 m .44708 .65611 L .45182 .64312 L p .907 .983 .734 r
F P
0 g
s
.45182 .64312 m .51298 .58609 L .50811 .59888 L p .907 .983 .734 r
F P
0 g
s
.61542 .59176 m .54348 .56905 L .54886 .55189 L p .607 .472 .671 r
F P
0 g
s
.54348 .56905 m .61542 .59176 L .61492 .60698 L p .541 .546 .809 r
F P
0 g
s
.54886 .55189 m .62088 .57433 L .61542 .59176 L p .607 .472 .671 r
F P
0 g
s
.01 w
.61815 .58304 m
.67001 .5993 L
s
.5 Mabswid
.41766 .60788 m .48004 .55218 L .49558 .55709 L p .639 .272 .331 r
F P
0 g
s
.48004 .55218 m .41766 .60788 L .40508 .61276 L p .046 0 0 r
F P
0 g
s
.51298 .58609 m .45182 .64312 L .44668 .62668 L p .932 .76 .646 r
F P
0 g
s
.44668 .62668 m .50821 .57009 L .51298 .58609 L p .932 .76 .646 r
F P
0 g
s
.02 w
.47586 .58897 m
.49025 .57582 L
s
.5 Mabswid
.43359 .61317 m .49558 .55709 L .50821 .57009 L p .825 .546 .516 r
F P
0 g
s
.49558 .55709 m .43359 .61317 L .41766 .60788 L p .639 .272 .331 r
F P
0 g
s
.50821 .57009 m .44668 .62668 L .43359 .61317 L p .825 .546 .516 r
F P
0 g
s
.02 w
.39338 .66428 m
.44099 .62081 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00L@3oool00`000000oooo0?ooo`2/0?ooo`00L@3o
ool00`000000oooo0?ooo`2/0?ooo`00L@3oool200000:d0oooo001a0?ooo`800000[@3oool00740
oooo00<000000000N@000000[03oool00740oooo00<000000000N@000000[03oool00740oooo00@0
00000000N@0007T000007`3oool3000008T0oooo001a0?ooo`040000000007T0001i000001`0oooo
0`0000000`2iZ//000000927aP02000008L0oooo001a0?ooo`050000000007T0001i0000N@000000
6P3oool00`000000gLG1000000020;VZb`040000002@QlH0T8O6000008L0oooo001a0?ooo`050000
000007T0001i0000N@0000006@3oool2000000050=g5`@000000^J[;0;VZb`0000000P2@QlH20000
08H0oooo001a0?ooo`030000000007T0001i0080001i00<000000?ooo`3oool05P3oool200000005
0=g5`@000000^J[;0;VZb`0000000P2@QlH2000008H0oooo001a0?ooo`030000000007T0001i0080
001i00<000000?ooo`3oool05P3oool9000000030=oKdP000000oooo08D0oooo001b0?ooo`030000
000007T0001i0080001i00<000000?ooo`3oool05P3oool20000000508B@e`000000][SK0;Jhf`00
00000P3Ofm800`000000oooo0?ooo`240?ooo`00LP3oool00`000000001i0000N@020000N@030000
003oool0oooo01H0oooo0P0000001`24T=L000000;Jhf`2f^=/000000=oKdP000000Q`3oool007<0
oooo00<000000000N@0007T00P0007T00`000000oooo0?ooo`0E0?ooo`80000000L0Q93G0000002f
^=/0][SK0000003Ofm80000008L0oooo001c0?ooo`030000000007T0001i0080001i00<000000?oo
o`3oool05@3oool20000000708B@e`000000][SK0;Jhf`000000gm_B000000270?ooo`00M03oool0
0`000000001i0000N@020000N@030000003oool0oooo01@0oooo0P0000001`24T=L000000;Jhf`2f
^=/000000=oKdP000000Q`3oool007@0oooo00<000000000N@0007T00P0007T00`000000oooo0?oo
o`0D0?ooo`80000000L0Q93G0000002f^=/0][SK0000003Ofm80000008L0oooo001e0?ooo`030000
000007T0001i0080001i00<000000?ooo`3oool0503oool01@000000Q93G0000002f^=/000000080
gm_B00<000000?ooo`3oool0Q@3oool007D0oooo00<000000000N@0007T00P0007T00`000000oooo
0?ooo`0D0?ooo`0700000024T=L000000;Jhf`000000gm_B000000280?ooo`00M@3oool00`000000
001i0000N@030000N@030000003oool0oooo01<0oooo0`000000102f^=/000000=oKdP0000280?oo
o`00MP3oool00`000000001i0000N@020000N@030000003oool0oooo01<0oooo0`000000102f^=/0
00000=oKdP0000280?ooo`00MP3oool00`000000001i0000N@030000N@030000003oool0oooo0180
oooo0`000000102f^=/000000=oKdP00000:0?ooo`@00000NP3oool007L0oooo00<000000000N@00
07T00P0007T00`000000oooo0?ooo`0B0?ooo`<0000000@0][SK0000003Ofm800000203oool30000
00<0XdED0`00001g0?ooo`00M`3oool00`000000001i0000N@020000N@030000003oool0oooo01<0
oooo0P000000102f^=/000000=oKdP0000070?ooo`030000000;0000000000D0XdED00<000000=>;
Q0000000MP3oool007P0oooo00<000000000N@0007T00P0007T00`000000oooo0?ooo`0B0?ooo`03
00000024T=L00000008000001`3oool00`0000002`00000000050:=5E0040000003CRh@0dh^40000
07H0oooo001h0?ooo`030000000007T0001i0080001i00<000000?ooo`3oool04P3oool00`000000
Q93G00000002000000H0oooo00<0000000/0000000001@2SAE@00`000000dh^40=>;Q0020=>;Q003
0000003oool0oooo07<0oooo001i0?ooo`050000000007T0001i0000N@000000503oool5000000D0
oooo0`0000050:=5E0030000003CRh@0dh^400@0dh^400<000000?ooo`3oool0LP3oool007D0oooo
1@0000030000N@030000003oool0oooo0180oooo1@0000030?ooo`<000001@2SAE@2000000H0dh^4
0P00001d0?ooo`00M@3oool00`000000Xein0000000200000004098=000000000000000001@0oooo
1@0000020?ooo`030000000;0000000000D0XdED00<000000=>;Q03CRh@01@3CRh@00`000000k/:U
0000001d0?ooo`00M03oool00`000000Xein0:=NOP030:=NOPP000004@3oool300000080oooo00<0
000000/0000000001@2SAE@00`000000dh^40=>;Q0050=>;Q0050000003^`ZD0k/:U0>k2Y@000000
L`3oool007@0oooo00<000000:=NOP2SGWh01`2SGWh300000003098=000000000000008000003@3o
ool3000000040?ooo`0000002`00000000D0XdED00<000000=>;Q03CRh@01@3CRh@00`000000k/:U
0>k2Y@020>k2Y@030000003oool0oooo0740oooo001c0?ooo`800000302SGWh300000080TPd01000
00090?ooo`P000000`2SAE@2000000D0dh^40P0000040>k2Y@800000L`3oool007<0oooo00<00000
09]hZ`0000000P00000<0:=NOP@000000P2B3@02000000L0oooo1@0000030>g1YPH000000`3CRh@0
0`000000k/:U0>k2Y@030>k2Y@800000M03oool00780oooo00<0000009]hZ`2KN:/00`2KN:/30000
00d0Xein0P00000204bKl`030000003oool0oooo00@0oooo100000060>g1YPD0000000<0dh^40000
003^`ZD0103^`ZD00`000000j?^k0000001d0?ooo`00K`3oool4000000P0VgR[100000090:=NOPD0
00000`3oool8000000@0kL6V1`0000050>k2Y@030000003Xnk/0000007D0oooo001X0?ooo`L00000
0`31^=400`000000VgR[09]hZ`0:09]hZ`<000001P2SGWh010000000S8c>08b<cP2<S<h200000080
oooo200000020>g1YPP00000103^`ZD2000000030>Sk^`000000oooo07D0oooo001P0?ooo`P00000
2P31^=44000000`0VgR[0`0000020:=NOP030000002<S<h0S8c>00<0S8c>00<000000?ooo`3oool0
200000000`3]`JH0000000000006000000@0k/:U00@000000>Sk^`3Xnk/00000M`3oool005T0oooo
1`00000B0<6hd@040000002:Rll0RX_?08Z;c`<00000302KN:/4000000@0S8c>00<000000?ooo`3o
ool04@0000030>k2Y@040000003Xnk/0j?^k000007P0oooo001B0?ooo`L000006@31^=400`000000
RX_?08Z;c`0408Z;c`8000002P2KN:/200000080W7V/0`0000000`2<S<h000000?ooo`0500000003
0:=NOP000000_h>B00X000000P3^`ZD010000000j?^k0>Sk^`00001i0?ooo`00B`3oool700000200
`KSA00<0000008Z;c`2:Rll01P2:Rll3000000H0VgR[1@00000309ai[0<0000000<0KR1I00000000
00000`2SGWh00`000000_h>B0000000700000080Y4QH0`0000000`3Xnk/000000?ooo`1i0?ooo`00
@`3oool8000002L0`KSA00<0000008Z;c`2:Rll02@2:Rll3000000@0VgR[3@0000020:=NOP040000
002oPi80_h>B0;n3TPD000000P2TB5P2000000@0TPd00P0000090?ooo`030000003oool0oooo06d0
oooo000l0?ooo`L00000;`31^=44000000/0RX_?0`0000000`2KN:/0000009ai[00209ai[0D00000
0P1aCIP00`000000VgR[0000000200000080_h>B00<000000=JSXP0000000P0000030:A8F0030000
002SGWh00000008000000`2B3@03000000D0oooo00<0/NnQ0?ooo`3oool0KP3oool003P0oooo1000
000f0<6hd@<0000000<0A9Sc0000000000000P00000:08Z;c`<000001@2LNJ`200000003075=V000
0000VgR[0080VgR[00@000000;BC]000000000000P3FXj800`000000jYmj000000020:A8F0030000
002SGWh0Xein00<0Xein0`000003098=008000000P3oool00`2akj4000000?ooo`1_0?ooo`00>03o
ool00`000000`KSA0<6hd@0g0<6hd@030000003oool0oooo00@0000000@0A9Sc0000000000000000
202:Rll00`000000Y620000000020000000309ai[000000000000080LDfH00D0000009]hZ`2KN:/0
VgR[000000020;BC]0<0000000H0eZ>R0000003fhKD000000:A8F00000080:=NOP<000000P2B3@03
00000740oooo000h0?ooo`0300000031^=40`KSA03L0`KSA00<000000?ooo`3oool00`3oool40000
000404BHl`0000000000000000D0RX_?00<000000:APP02TH8001`00000309]hZ`050000002dTk@0
]9>d0;BC]00000000P3;[;X00`000000m^6e0?KQ]@03000000/0Xein0`000002098=00<00000KP3o
ool003P0oooo00<000000<6hd@31^=40=031^=44000000P0oooo100000000`14V?<0000000000002
0000000308Z;c`0000000000008000000`2SAE@400000080VgR[00@000000;BC]02dTk@000000`3;
[;X2000000040?KQ]@000000000009]hZ`@000002P2SGWh300000080TPd00`00001[0?ooo`00>03o
ool00`000000`KSA0<6hd@0]0<6hd@L00000403oool300000080A9Sc0P0000000`0;000000000:=5
E0040:=5E0030000003CRh@0000000d000001P2KN:/3000000X0Xein0`000002098=00800000J@3o
ool003P0oooo00<000000<6hd@31^=409P31^=47000001X0oooo0`0000000`0;000000000:=5E004
0:=5E0030000003CRh@0dh^400@000000P2[Ym<010000000akgA0<Nmd@37_M44000000T0VgR[1000
00090:=NOPD00000J03oool003T0oooo00<000000<6hd@31^=407P31^=4700000280oooo0`000005
0:=5E0030000003CRh@0dh^40080dh^40`0000020:^Wd`0300000037_M40akgA0080000000<0m^6e
0000002KN:/03@2KN:/3000000H0Xein00@0000008b<cP2<S<h0S8c>0P00001W0?ooo`00>@3oool0
0`000000`KSA0<6hd@0F0<6hd@P000009`3oool3000000D0XdED0P0000060=>;Q08000000P2[Ym<3
000000030<ONjP000000000000800000402KN:/400000080Xein00<0000008b<cP2<S<h00P2<S<h0
0`000000oooo0?ooo`1U0?ooo`00>@3oool00`000000`KSA0<6hd@0?0<6hd@L00000;P3oool00`00
00002`00000000050:=5E0030000003CRh@0dh^400D0dh^42P0000000`3oool0000008Z;c`040000
0100VgR[0P00000508b<cP030000003oool0oooo06D0oooo000i0?ooo`0300000031^=40`KSA00P0
`KSA1`00000d0?ooo`030000000;0000000000D0XdED00<000000=>;Q03CRh@01@3CRh@00`000000
k/:U0>k2Y@0700000080oooo00<0000008Z;c`2:Rll00`2:Rll3000000h0VgR[100000000`2<S<h0
00000?ooo`1W0?ooo`00>@3oool00`000000`KSA0<6hd@020<6hd@H00000>P3oool00`0000002`00
000000050:=5E0030000003CRh@0dh^400D0dh^400@000000>k2Y@3^`ZD0k/:U2P00000808Z;c`@0
00002@2KN:/00`000000W7V/09ai[00209ai[0800000J03oool003T0oooo100000100?ooo`030000
000;0000000000D0XdED00<000000=>;Q03CRh@01@3CRh@00`000000k/:U0>k2Y@030>k2Y@D00000
0`2<S<h2000000/0RX_?0`00000509]hZ`D000000P2LNJ`00`000000oooo0?ooo`1V0?ooo`00O03o
ool00`0000002`00000000050:=5E0030000003CRh@0dh^400D0dh^400<000000>k2Y@3^`ZD0103^
`ZD5000000@0S8c>1000000;08Z;c`@0000000<0VgR[0000000000001P00001X0?ooo`00N`3oool0
0`0000002`00000000050:=5E0030000003CRh@0dh^400D0dh^400<000000>k2Y@3^`ZD0103^`ZD6
000000@0S8c>0`0000001014V?<0000000000000000<08Z;c`8000000`2LNJ`7000006D0oooo001j
0?ooo`<000001@2SAE@00`000000dh^40=>;Q0050=>;Q0030000003^`ZD0k/:U00@0k/:U1`000004
08b<cP030000000T<JP0000000<0000000@0A9Sc00000000000000002P2:Rll50000000309ai[000
0000000000H00000HP3oool007P0oooo00<0000000/0000000001@2SAE@2000000H0dh^40P000006
0>k2Y@P00000102<S<h00`000000936X02@aZ002000000050?ooo`000000000000000014V?<00`00
000708Z;c`030000002TH800Y62000<0Y62000@000000?ooo`3oool0oooo1`00001O0?ooo`00M`3o
ool00`0000002`00000000050:=5E0030000003CRh@0dh^400D0dh^40P0000050>k2Y@X00000102<
S<h010000000936X02@aZ00000050?ooo`8000000P14V?<3000000@0RX_?00<000000:APP02TH800
0`2TH8000`000000oooo0?ooo`040?ooo`D00000GP3oool007H0oooo00<0000000/0000000001@2S
AE@00`000000dh^40=>;Q0050=>;Q0030000003^`ZD0k/:U00@0k/:U00<000000>Sk^`0000002000
000408b<cP040000000T<JP0936X000000L0oooo0`00000204BHl`<0000000<0RX_?0000002TH800
0`2TH8000`000000oooo0?ooo`080?ooo`030000003oool0oooo05d0oooo001e0?ooo`D000000`2S
AE@00`000000dh^40=>;Q0050=>;Q0030000003^`ZD0k/:U00@0k/:U00<000000>Sk^`0000002@00
000408b<cP040000000T<JP00000000000X0oooo0`00000204BHl`@000000P2TH8000`000000oooo
0?ooo`1X0?ooo`00M03oool400000080kL6V0`0000000`3CRh@000000=>;Q0040=>;Q0030000003^
`ZD0k/:U00@0k/:U00@000000>Sk^`000000g/o92@00000408b<cP@000003@3oool20000000404BH
l`000000UQD509HE1@800000J`3oool007@0oooo0P0000070>g1YP<000000`3CRh@00`000000k/:U
0>k2Y@040>k2Y@030000003Xnk/000000080g/o92@00000208b<cP<0000000<0gm7:000000000000
3`3oool0102Wj9L0000000000000001]0?ooo`00L`3oool2000000L0kL6V1@0000000`3CRh@00000
0>k2Y@050>k2Y@040000003Xnk/0000008Z;c`d00000103OdLX2000000h0oooo00<0YnRG0000003o
ool0K`3oool007<0oooo00<000000>g1YP3]`JH01@3]`JH7000000H0k/:U00@000000>Sk^`000000
0000102:Rll9000000D0gm7:0P00000=0?ooo`030:OXU`000000oooo0700oooo001b0?ooo`030000
003]`JH0kL6V00@0kL6V200000060>k2Y@050000003Xnk/0000001PYY0000000102:Rll9000000D0
gm7:0P00000<0?ooo`030:OXU`000000oooo0740oooo001b0?ooo`030000003]`JH0kL6V00<0kL6V
2@0000040>k2Y@80000000D0j?^k00000000000062VT0000000408Z;c`T000001@3OdLX2000000/0
oooo00<0YnRG0000003oool0LP3oool007<0oooo00@000000>g1YP3]`JH0kL6V2P0000030>k2Y@08
0000003Xnk/0j?^k0000003oool0000001PYY000000408Z;c`T000001@3OdLX2000000X0oooo00<0
YnRG0000003oool0L`3oool007<0oooo00<000000>g1YP3]`JH02@0000020:A8F0030000003^`ZD0
00000080j?^k00H000000?ooo`3oool0000001PYY000000508Z;c`030000002h/M<0^;7C00@0^;7C
00<000000=oAbP3OdLX00`3OdLX2000000T0oooo00<0YnRG0000003oool0M03oool007@0oooo2P00
00030:A8F08000000P3Xnk/01`000000oooo0?ooo`3oool0000001PYY00000001@2:Rll00`000000
^;7C0;Rad`040;Rad`030000003OdLX0gm7:00<0gm7:0P0000080?ooo`030:OXU`000000oooo07D0
oooo001d0?ooo`L0000000<0dXb50000002TB5P00`2TB5P010000000j?^k0>Sk^`0000040?ooo`03
0000000H:J@0000000D0RX_?00<000000;Rad`2h/M<0102h/M<00`000000gm7:0=oAbP030=oAbP80
00001`3oool00`2Wj9L000000?ooo`1f0?ooo`00LP3oool8000000030=:<Q@000000Y4QH00<0Y4QH
0P0000000`3Xnk/000000?ooo`040?ooo`030000000H:J@0000000<0RX_?00<0000008Z;c`000000
1P2h/M<00`000000gm7:0=oAbP030=oAbP8000001P3oool20:OXUgP0oooo001a0?ooo`P0000000<0
dXb50000002TB5P00`2TB5P0100000005`000000000000060?ooo`030000000H:J@000000080RX_?
00@0000008Z;c`2:Rll000001P2h/M<00`000000gm7:0=oAbP030=oAbP8000001@3oool20:OXUgT0
oooo001`0?ooo`P0000000<0dXb50000002TB5P00`2TB5P0100000005`000000000000070?ooo`04
0000000H:J@0000008Z;c`8000000P2:Rll00`000000^;7C0;Rad`040;Rad`030000003OdLX0gm7:
0080gm7:00<000000?CGJ@000000103oool20:OXUgX0oooo001_0?ooo`P0000000<0oooo00000000
00000`2TB5P4000000P0oooo00<0000001PYY00000000P00000308Z;c`030000002h/M<0^;7C00@0
^;7C00<000000=oAbP3OdLX00P3OdLX00`000000m=MY000000030?ooo`80YnRGN`3oool006h0oooo
200000040?ooo`@000002`3oool01000000062VT00000000000408Z;c`030000002h/M<0^;7C00@0
^;7C00<000000=oAbP3OdLX00P3OdLX00`000000m=MY000000020?ooo`80YnRGO03oool006d0oooo
1`00000E0?ooo`80000000<0/NnQ0000002:Rll00`2:Rll00`000000^;7C0;Rad`040;Rad`030000
003OdLX0gm7:0080gm7:00@000000?CGJ@000000oooo0P2Wj9Mm0?ooo`00KP3oool5000001H0oooo
00<000000;7_X@0000001@2:Rll00`000000^;7C0;Rad`040;Rad`030000003OdLX0gm7:0080gm7:
00<000000?CGJ@0000000P2Wj9Mn0?ooo`00K`3oool3000001H0oooo00@000000;7_X@0000000000
1@2:Rll00`000000^;7C0;Rad`040;Rad`030000003OdLX0gm7:0080gm7:00@000000?CGJ@000000
YnRGO`3oool00700oooo00<000000?ooo`3oool0503oool01@000000/NnQ0000000H:J@0000000D0
RX_?00<000000;Rad`2h/M<0102h/M<00`000000gm7:0=oAbP020=oAbP030000003defT000000800
oooo00260?ooo`060000002akj4000000000000H:J@000001@2:Rll00`000000^;7C0;Rad`040;Ra
d`030000003OdLX0gm7:0080gm7:00<000000?CGJ@000000P03oool008D0oooo00L000000;7_X@00
0000oooo0000000H:J@0000000D0RX_?00<000000;Rad`2h/M<0102h/M<00`000000gm7:0=oAbP02
0=oAbP030000003defT000000800oooo00250?ooo`8000000P3oool00`00000062VT0000000508Z;
c`030000002h/M<0^;7C00@0^;7C00<000000=oAbP3OdLX00P3OdLX200000840oooo00240?ooo`80
0000103oool00`0H:J@0000008Z;c`0408Z;c`030000002h/M<0^;7C00@0^;7C00<000000=oAbP3O
dLX00P3OdLX200000840oooo00230?ooo`8000001@3oool2000000@0RX_?0P0000000`2h/M<00000
00000004000000@0gm7:00<0000002@aZ0000000P03oool00880oooo0P0000050?ooo`<00000102:
Rll900000080gm7:0P00000202@aZ0030000003oool0oooo07h0oooo00210?ooo`8000001P3oool2
000000030=k?b@00000000000080RX_?2`0000000`2<S<h0000002@aZ00200000800oooo00200?oo
o`8000001`3oool2000000<0g/o92`00000308b<cP040000000T<JP0000000000800oooo001o0?oo
o`800000203oool2000000@0g/o92@00000408b<cP80000000<0m=MY0000003oool0O`3oool007h0
oooo0P0000090?ooo`040000000H:J@0000000000080g/o92@00000308b<cP<0000000<0m=MY0000
003oool0O`3oool007d0oooo0P00000:0?ooo`040000000H:J@0000008Z;c`h000000P3OdLX00`00
0000m=MY0?ooo`200?ooo`00O03oool2000000/0oooo00<0000001PYY0000000102:Rll9000000@0
gm7:00<000000?CGJ@3oool0P03oool007/0oooo0P00000<0?ooo`030000000H:J@0000000@0RX_?
2@0000040=oAbP800000P@3oool007X0oooo0P00000=0?ooo`030000000H:J@0000000@0RX_?2@00
00040=oAbP800000P@3oool007T0oooo0P00000>0?ooo`030000000H:J@0000000<0RX_?2P000004
0=oAbP800000P@3oool007P0oooo0P00000?0?ooo`030000000H:J@000000080RX_?00<0000008Z;
c`000000200000040=oAbP800000P@3oool007P0oooo00<000000?ooo`3oool03P3oool01@000000
62VT0000002:Rll0000000<0RX_?00<000000;Rad`2h/M<0102h/M<00`000000gm7:0=oAbP020=oA
bP800000P@3oool007L0oooo00<000000?ooo`3oool0403oool3000000@0RX_?00<000000;Rad`2h
/M<0102h/M<00`000000gm7:0=oAbP020=oAbP800000P@3oool007H0oooo00<000000?ooo`3oool0
4@3oool2000000030:OXU`2:Rll0RX_?0080RX_?00<000000;Rad`2h/M<0102h/M<00`000000gm7:
0=oAbP020=oAbP030000003oool0oooo0800oooo001e0?ooo`030000003oool0oooo0180oooo0P00
000508Z;c`030000002h/M<0^;7C00@0^;7C00@000000=oAbP3OdLX0gm7:0P0000220?ooo`00R@3o
ool010000000YnRG00000000000408Z;c`030000002h/M<0^;7C00@0^;7C00@000000=oAbP000000
0000Q03oool008P0oooo00<000000:OXU`0000000P3oool30000000308Z;c`000000^;7C0080^;7C
1@0000260?ooo`00Q`3oool00`000000YnRG000000060?ooo`H00000RP3oool008H0oooo00<00000
0:OXU`0000002P3oool3000008X0oooo00250?ooo`030000002Wj9L0000000X0oooo1000002:0?oo
o`00Q03oool00`000000YnRG0000000;0?ooo`@00000RP3oool008<0oooo00<000000:OXU`000000
303oool5000008T0oooo00220?ooo`030000002Wj9L0000000d0oooo1@0000290?ooo`00P@3oool0
0`000000YnRG0000000>0?ooo`D00000R@3oool00840oooo0P00000>0?ooo`H00000R@3oool00800
oooo0P00000?0?ooo`@0000000<0gLC10000003oool0R03oool007l0oooo0P00000@0?ooo`<00000
00<0^J[:000000000000R@3oool007h0oooo0P00000A0?ooo`<0000000@0^J[:0000000000000000
R03oool007d0oooo0P00000B0?ooo`040000002AQlH000000;VZbP<00000R03oool007`0oooo0P00
000B0?ooo`80000000<0THO60000002iZ/X00`0000280?ooo`00N`3oool2000001<0oooo0P000000
0`2AQlH000000;VZbP03000008P0oooo001j0?ooo`800000503oool2000000030967aP000000^J[:
00<00000R03oool007T0oooo0P00000E0?ooo`80000000<0THO60000002iZ/X00`0000280?ooo`00
N03oool2000001H0oooo0`0000020;VZbP040000003Ma<400000000008L0oooo001g0?ooo`800000
5P3oool010000000>SNS0000000000020;VZbP040000003Ma<400000000008L0oooo001f0?ooo`80
00005`3oool2000000060967aP000000^J[:0;VZbP000000gLC10P0000270?ooo`00M@3oool20000
01P0oooo0P0000001P2AQlH000000;VZbP2iZ/X000000=g4`@800000Q`3oool007@0oooo0P00000I
0?ooo`80000000L0THO60000002iZ/X0^J[:0000003Ma<40000008P0oooo001c0?ooo`8000006`3o
ool00`000000THO6000000020;VZbP800000R@3oool00780oooo0P00000M0?ooo`D00000RP3oool0
0740oooo0P00002]0?ooo`00L03oool200000:h0oooo001_0?ooo`800000[`3oool006h0oooo0P00
002`0?ooo`00KP3oool00`000000oooo0?ooo`2_0?ooo`00K@3oool00`000000oooo0?ooo`2`0?oo
o`00K03oool00`000000oooo0?ooo`2a0?ooo`00J`3oool00`000000oooo0?ooo`2b0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.41151 .70122 m .39757 .60958 L .43061 .58764 L p .402 .105 .343 r
F P
0 g
s
.43061 .58764 m .44625 .67339 L p .41151 .70122 L .402 .105 .343 r
F P
0 g
s
.42646 .69142 m .41151 .70122 L p .44625 .67339 L .402 .105 .343 r
F P
0 g
s
.42836 .6717 m .41201 .67226 L p .41007 .70634 L .858 .856 .838 r
F P
0 g
s
.41004 .70696 m .41062 .70585 L p .41007 .70634 L .858 .856 .838 r
F P
0 g
s
.41062 .70585 m .42836 .6717 L p .41007 .70634 L .858 .856 .838 r
F P
0 g
s
.44625 .67339 m .44708 .67791 L .42646 .69142 L p .402 .105 .343 r
F P
0 g
s
.45227 .62358 m .44012 .56113 L .471 .54057 L p .387 .085 .326 r
F P
0 g
s
.471 .54057 m .48417 .59919 L p .45227 .62358 L .387 .085 .326 r
F P
0 g
s
.47767 .57682 m .46141 .57665 L p .44197 .63748 L .858 .856 .838 r
F P
0 g
s
.4353 .65835 m .44987 .63031 L p .44197 .63748 L .858 .856 .838 r
F P
0 g
s
.47066 .61145 m .45227 .62358 L p .48417 .59919 L .387 .085 .326 r
F P
0 g
s
.44987 .63031 m .47767 .57682 L p .44197 .63748 L .858 .856 .838 r
F P
0 g
s
.48417 .59919 m .48483 .60211 L .47066 .61145 L p .387 .085 .326 r
F P
0 g
s
.37948 .81357 m .38723 .81929 L .42135 .73381 L closepath p .57 .522 .762 r
F P
0 g
s
.37037 .81046 m .37948 .81357 L .42135 .73381 L closepath p .707 .692 .833 r
F P
0 g
s
.38723 .81929 m .39069 .82548 L .42135 .73381 L closepath p .291 .215 .597 r
F P
0 g
s
.36332 .81115 m .37037 .81046 L .42135 .73381 L closepath p .835 .894 .882 r
F P
0 g
s
.39069 .82548 m .38852 .8298 L .42135 .73381 L closepath p .797 .845 .385 r
F P
0 g
s
.36104 .81541 m .36332 .81115 L .42135 .73381 L closepath p 0 0 0 r
F P
0 g
s
.52491 .55275 m .51581 .51889 L .49942 .52237 L p .55 .174 .281 r
F P
0 g
s
.51581 .51889 m .52491 .55275 L .53682 .54099 L p .273 .017 .331 r
F P
0 g
s
.53682 .54099 m .52736 .50741 L .51581 .51889 L p .273 .017 .331 r
F P
0 g
s
.50803 .55635 m .49942 .52237 L .48439 .51655 L p .763 .317 .192 r
F P
0 g
s
.49942 .52237 m .50803 .55635 L .52491 .55275 L p .55 .174 .281 r
F P
0 g
s
.52736 .50741 m .53682 .54099 L .53925 .52548 L p 0 0 .323 r
F P
0 g
s
.53925 .52548 m .52969 .49225 L .52736 .50741 L p 0 0 .323 r
F P
0 g
s
.49256 .55042 m .48439 .51655 L .4764 .50358 L p .858 .452 0 r
F P
0 g
s
.48439 .51655 m .49256 .55042 L .50803 .55635 L p .763 .317 .192 r
F P
0 g
s
.38852 .8298 m .38148 .83056 L .42135 .73381 L closepath p .875 .829 .799 r
F P
0 g
s
.36444 .82164 m .36104 .81541 L .42135 .73381 L closepath p .421 .264 .562 r
F P
0 g
s
.42836 .6717 m .41004 .70696 L .43137 .71457 L p .726 .676 .801 r
F P
0 g
s
.43137 .71457 m .44978 .67947 L .42836 .6717 L p .726 .676 .801 r
F P
0 g
s
.44978 .67947 m .43137 .71457 L .44979 .72778 L p .601 .52 .736 r
F P
0 g
s
.52969 .49225 m .53925 .52548 L .53119 .51211 L p .829 .422 0 r
F P
0 g
s
.53119 .51211 m .52183 .47916 L .52969 .49225 L p .829 .422 0 r
F P
0 g
s
.4764 .50358 m .48436 .53717 L .49256 .55042 L p .858 .452 0 r
F P
0 g
s
.48436 .53717 m .4764 .50358 L .47858 .48835 L p 0 0 .284 r
F P
0 g
s
.44979 .72778 m .46838 .69266 L .44978 .67947 L p .601 .52 .736 r
F P
0 g
s
.46838 .69266 m .44979 .72778 L .45848 .74174 L p .373 .252 .584 r
F P
0 g
s
.41201 .67226 m .39366 .70779 L .41004 .70696 L p .858 .856 .838 r
F P
0 g
s
.38148 .83056 m .37226 .82744 L .42135 .73381 L closepath p .741 .664 .774 r
F P
0 g
s
.37226 .82744 m .36444 .82164 L .42135 .73381 L closepath p .622 .515 .711 r
F P
0 g
s
.52183 .47916 m .53119 .51211 L .51564 .50604 L p .758 .3 .163 r
F P
0 g
s
.51564 .50604 m .50672 .4732 L .52183 .47916 L p .758 .3 .163 r
F P
0 g
s
.48663 .52159 m .47858 .48835 L .49016 .47671 L p .249 0 .309 r
F P
0 g
s
.47858 .48835 m .48663 .52159 L .48436 .53717 L p 0 0 .284 r
F P
0 g
s
.50672 .4732 m .51564 .50604 L .49859 .50967 L p .54 .155 .26 r
F P
0 g
s
.49859 .50967 m .49016 .47671 L .50672 .4732 L p .54 .155 .26 r
F P
0 g
s
.49016 .47671 m .49859 .50967 L .48663 .52159 L p .249 0 .309 r
F P
0 g
s
.47767 .57682 m .4353 .65835 L .45675 .66618 L p .726 .676 .801 r
F P
0 g
s
.45675 .66618 m .49933 .58502 L .47767 .57682 L p .726 .676 .801 r
F P
0 g
s
.49933 .58502 m .45675 .66618 L .47542 .67937 L p .601 .52 .736 r
F P
0 g
s
.45848 .74174 m .47727 .70644 L .46838 .69266 L p .373 .252 .584 r
F P
0 g
s
.39985 .51464 m .26285 .40571 L .2803 .36815 L p .554 .467 .711 r
F P
0 g
s
.47727 .70644 m .45848 .74174 L .45395 .75121 L p 0 0 0 r
F P
0 g
s
.40701 .68112 m .38851 .71694 L .39366 .70779 L p .661 .807 .363 r
F P
0 g
s
.39366 .70779 m .41201 .67226 L .40701 .68112 L p .661 .807 .363 r
F P
0 g
s
.47542 .67937 m .51841 .59817 L .49933 .58502 L p .601 .52 .736 r
F P
0 g
s
.02 w
.50574 .50815 m
.51167 .53076 L
s
.5 Mabswid
.51841 .59817 m .47542 .67937 L .48439 .69308 L p .373 .252 .584 r
F P
0 g
s
.46141 .57665 m .41896 .65882 L .4353 .65835 L p .858 .856 .838 r
F P
0 g
s
.2803 .36815 m .40478 .46539 L p .39985 .51464 L .554 .467 .711 r
F P
0 g
s
.41064 .49301 m .40806 .49819 L p .40478 .46539 L .554 .467 .711 r
F P
0 g
s
.40806 .49819 m .39985 .51464 L p .40133 .49981 L .554 .467 .711 r
F P
0 g
s
.40133 .49981 m .40478 .46539 L .40806 .49819 L .554 .467 .711 r
F
.47703 .51638 m .48421 .50896 L p .42594 .49389 L .577 .721 .941 r
F P
0 g
s
.40478 .46539 m .41892 .47644 L .41643 .48142 L p .554 .467 .711 r
F P
0 g
s
.41643 .48142 m .41064 .49301 L p .40732 .47737 L .554 .467 .711 r
F P
0 g
s
.40732 .47737 m .40478 .46539 L .41643 .48142 L .554 .467 .711 r
F
.48421 .50896 m .4115 .48073 L .4047 .4884 L p .577 .721 .941 r
F P
0 g
s
.48421 .50896 m .48834 .51165 L p .44671 .4949 L .391 0 0 r
F P
0 g
s
.4115 .48073 m .43795 .491 L p .44671 .4949 L .391 0 0 r
F P
0 g
s
.43795 .491 m .48421 .50896 L p .44671 .4949 L .391 0 0 r
F P
0 g
s
.4047 .4884 m .42159 .49494 L p .42594 .49389 L .577 .721 .941 r
F P
0 g
s
.42159 .49494 m .47703 .51638 L p .42594 .49389 L .577 .721 .941 r
F P
0 g
s
.39732 .50323 m .3921 .51967 L p .41708 .52332 L .78 .614 .675 r
F P
0 g
s
.46953 .53098 m .41419 .50971 L p .41708 .52332 L .78 .614 .675 r
F P
0 g
s
.41419 .50971 m .39732 .50323 L p .41708 .52332 L .78 .614 .675 r
F P
0 g
s
.45395 .75121 m .4729 .71563 L .47727 .70644 L p 0 0 0 r
F P
0 g
s
.48439 .69308 m .52786 .61145 L .51841 .59817 L p .373 .252 .584 r
F P
0 g
s
.52786 .61145 m .48439 .69308 L .48007 .70217 L p 0 0 0 r
F P
0 g
s
.4568 .58472 m .41401 .66757 L .41896 .65882 L p .661 .807 .363 r
F P
0 g
s
.41896 .65882 m .46141 .57665 L .4568 .58472 L p .661 .807 .363 r
F P
0 g
s
.4729 .71563 m .45395 .75121 L .43763 .75241 L p .862 .868 .842 r
F P
0 g
s
.41557 .69506 m .39686 .73106 L .38851 .71694 L p .353 .233 .575 r
F P
0 g
s
.38851 .71694 m .40701 .68112 L .41557 .69506 L p .353 .233 .575 r
F P
0 g
s
.54546 .57822 m .61483 .6047 L .61951 .58862 L p .78 .614 .675 r
F P
0 g
s
.61951 .58862 m .55031 .56202 L .54546 .57822 L p .78 .614 .675 r
F P
0 g
s
.55031 .56202 m .61951 .58862 L .62726 .57448 L p .726 .676 .802 r
F P
0 g
s
.54522 .59024 m .61497 .61675 L .61483 .6047 L p .803 .49 .46 r
F P
0 g
s
.61483 .6047 m .54546 .57822 L .54522 .59024 L p .803 .49 .46 r
F P
0 g
s
.62726 .57448 m .55794 .54767 L .55031 .56202 L p .726 .676 .802 r
F P
0 g
s
.55794 .54767 m .62726 .57448 L .63519 .56757 L p .577 .721 .941 r
F P
0 g
s
.43763 .75241 m .45601 .7177 L p .4729 .71563 L .862 .868 .842 r
F P
0 g
s
.45662 .71656 m .43763 .75241 L .41571 .74469 L p .726 .679 .804 r
F P
0 g
s
.43577 .86078 m .41914 .75145 L p .45521 .72254 L .402 .105 .343 r
F P
0 g
s
.41914 .75145 m .41839 .74651 L .43967 .73266 L p .402 .105 .343 r
F P
0 g
s
.43967 .73266 m .45521 .72254 L p .41914 .75145 L .402 .105 .343 r
F P
0 g
s
.45601 .7177 m .45662 .71656 L .4573 .71652 L p .862 .868 .842 r
F P
0 g
s
.4573 .71652 m .4729 .71563 L p .45601 .7177 L .862 .868 .842 r
F P
0 g
s
.03 w
.42135 .73381 m
.43295 .71168 L
s
.5 Mabswid
.4346 .70868 m .41571 .74469 L .39686 .73106 L p .597 .518 .736 r
F P
0 g
s
.39686 .73106 m .41557 .69506 L .4346 .70868 L p .597 .518 .736 r
F P
0 g
s
.54974 .59348 m .61995 .62015 L .61497 .61675 L p .439 0 0 r
F P
0 g
s
.61497 .61675 m .54522 .59024 L .54974 .59348 L p .439 0 0 r
F P
0 g
s
.48007 .70217 m .52391 .61987 L .52786 .61145 L p 0 0 0 r
F P
0 g
s
.52391 .61987 m .48007 .70217 L .4638 .70299 L p .862 .868 .842 r
F P
0 g
s
.03 w
.47317 .63502 m
.47945 .62304 L
s
.5 Mabswid
.46592 .59814 m .42265 .68143 L .41401 .66757 L p .353 .233 .575 r
F P
0 g
s
.41401 .66757 m .4568 .58472 L .46592 .59814 L p .353 .233 .575 r
F P
0 g
s
.03 w
.43455 .70864 m
.47317 .63502 L
s
.5 Mabswid
.63519 .56757 m .56553 .54053 L .55794 .54767 L p .577 .721 .941 r
F P
0 g
s
.56553 .54053 m .63519 .56757 L .64032 .57062 L p .391 0 0 r
F P
0 g
s
.41571 .74469 m .4346 .70868 L .45662 .71656 L p .726 .679 .804 r
F P
0 g
s
.55737 .58654 m .62794 .61344 L .61995 .62015 L p .569 .724 .946 r
F P
0 g
s
.61995 .62015 m .54974 .59348 L .55737 .58654 L p .569 .724 .946 r
F P
0 g
s
.52354 .56638 m .51112 .56471 L .51593 .54886 L p .693 .521 .65 r
F P
0 g
s
.02 w
.51167 .53076 m
.51288 .53537 L
s
.5 Mabswid
.51593 .54886 m .52738 .55366 L .52354 .56638 L p .693 .521 .65 r
F P
0 g
s
.50469 .54455 m .51593 .54886 L .51112 .56471 L p .78 .614 .675 r
F P
0 g
s
.03 w
.49554 .59237 m
.49766 .58833 L
s
.02 w
.51288 .53537 m
.51329 .53693 L
s
.5 Mabswid
.52738 .55366 m .51593 .54886 L .52332 .53476 L p .644 .573 .76 r
F P
0 g
s
.51593 .54886 m .50469 .54455 L .51206 .53041 L p .726 .676 .802 r
F P
0 g
s
.51206 .53041 m .52332 .53476 L .51593 .54886 L p .726 .676 .802 r
F P
0 g
s
.45521 .72254 m .47575 .83519 L .43577 .86078 L p .402 .105 .343 r
F P
0 g
s
.4638 .70299 m .49723 .63988 L p .52391 .61987 L .862 .868 .842 r
F P
0 g
s
.50774 .62004 m .4638 .70299 L .44175 .69504 L p .726 .679 .804 r
F P
0 g
s
.44175 .69504 m .48547 .61171 L .50774 .62004 L p .726 .679 .804 r
F P
0 g
s
.47567 .74387 m .46174 .67224 L p .4949 .64691 L .387 .085 .326 r
F P
0 g
s
.46174 .67224 m .46111 .66905 L .47577 .65944 L p .387 .085 .326 r
F P
0 g
s
.47577 .65944 m .4949 .64691 L p .46174 .67224 L .387 .085 .326 r
F P
0 g
s
.49723 .63988 m .50774 .62004 L .51911 .61992 L p .862 .868 .842 r
F P
0 g
s
.51911 .61992 m .52391 .61987 L p .49723 .63988 L .862 .868 .842 r
F P
0 g
s
.48547 .61171 m .44175 .69504 L .42265 .68143 L p .597 .518 .736 r
F P
0 g
s
.42265 .68143 m .46592 .59814 L .48547 .61171 L p .597 .518 .736 r
F P
0 g
s
.03 w
.48541 .61168 m
.49554 .59237 L
s
.5 Mabswid
.53472 .56511 m .52354 .56638 L .52738 .55366 L p .579 .404 .608 r
F P
0 g
s
.52738 .55366 m .53685 .55803 L .53472 .56511 L p .579 .404 .608 r
F P
0 g
s
.53685 .55803 m .52738 .55366 L .53333 .54236 L p .535 .442 .696 r
F P
0 g
s
.52332 .53476 m .53333 .54236 L .52738 .55366 L p .644 .573 .76 r
F P
0 g
s
.64032 .57062 m .57021 .54341 L .56553 .54053 L p .391 0 0 r
F P
0 g
s
.57021 .54341 m .64032 .57062 L .64061 .58265 L p .805 .486 .45 r
F P
0 g
s
.51112 .56471 m .49986 .56041 L .50469 .54455 L p .78 .614 .675 r
F P
0 g
s
.49583 .54154 m .50469 .54455 L .49986 .56041 L p .87 .717 .689 r
F P
0 g
s
.50469 .54455 m .49583 .54154 L .50174 .53016 L p .813 .792 .833 r
F P
0 g
s
.50174 .53016 m .51206 .53041 L .50469 .54455 L p .813 .792 .833 r
F P
0 g
s
.52325 .57577 m .5107 .57641 L .51112 .56471 L p .685 .387 .463 r
F P
0 g
s
.51112 .56471 m .52354 .56638 L .52325 .57577 L p .685 .387 .463 r
F P
0 g
s
.49986 .56041 m .51112 .56471 L .5107 .57641 L p .803 .49 .46 r
F P
0 g
s
.53459 .57032 m .52325 .57577 L .52354 .56638 L p .54 .268 .451 r
F P
0 g
s
.52354 .56638 m .53472 .56511 L .53459 .57032 L p .54 .268 .451 r
F P
0 g
s
.53333 .54236 m .52332 .53476 L .53055 .52769 L p .486 .564 .86 r
F P
0 g
s
.52332 .53476 m .51206 .53041 L .51924 .5233 L p .577 .721 .941 r
F P
0 g
s
.51924 .5233 m .53055 .52769 L .52332 .53476 L p .577 .721 .941 r
F P
0 g
s
.53333 .54236 m .54017 .55175 L .53685 .55803 L p .535 .442 .696 r
F P
0 g
s
.54017 .55175 m .53333 .54236 L .53918 .53673 L p .378 .387 .743 r
F P
0 g
s
.53055 .52769 m .53918 .53673 L .53333 .54236 L p .486 .564 .86 r
F P
0 g
s
.5107 .57641 m .49937 .57211 L .49986 .56041 L p .803 .49 .46 r
F P
0 g
s
.49193 .5543 m .49986 .56041 L .49937 .57211 L p .921 .606 .43 r
F P
0 g
s
.49986 .56041 m .49193 .5543 L .49583 .54154 L p .87 .717 .689 r
F P
0 g
s
.53472 .56511 m .53685 .55803 L .54017 .55175 L p .063 0 .342 r
F P
0 g
s
.51206 .53041 m .50174 .53016 L .50746 .52445 L p .661 .886 .98 r
F P
0 g
s
.50746 .52445 m .51924 .5233 L .51206 .53041 L p .661 .886 .98 r
F P
0 g
s
.53652 .57166 m .53459 .57032 L .53472 .56511 L p .063 0 .342 r
F P
0 g
s
.53979 .5686 m .53652 .57166 L p .53472 .56511 L .063 0 .342 r
F P
0 g
s
.54314 .56227 m .53979 .5686 L p .53472 .56511 L .063 0 .342 r
F P
0 g
s
.54528 .55513 m .54314 .56227 L p .53472 .56511 L .063 0 .342 r
F P
0 g
s
.54539 .54992 m .54528 .55513 L p .53472 .56511 L .063 0 .342 r
F P
0 g
s
.54343 .54865 m .54539 .54992 L p .53472 .56511 L .063 0 .342 r
F P
0 g
s
.54017 .55175 m .54343 .54865 L p .53472 .56511 L .063 0 .342 r
F P
0 g
s
.53918 .53673 m .54343 .54865 L .54017 .55175 L p .378 .387 .743 r
F P
0 g
s
.49109 .54045 m .49583 .54154 L .49193 .5543 L p .978 .864 .657 r
F P
0 g
s
.49583 .54154 m .49109 .54045 L .49438 .53411 L p .91 .949 .813 r
F P
0 g
s
.49438 .53411 m .50174 .53016 L .49583 .54154 L p .91 .949 .813 r
F P
0 g
s
.56518 .57195 m .63586 .59907 L .62794 .61344 L p .726 .679 .804 r
F P
0 g
s
.62794 .61344 m .55737 .58654 L .56518 .57195 L p .726 .679 .804 r
F P
0 g
s
.3921 .51967 m .46448 .5473 L .46953 .53098 L p .78 .614 .675 r
F P
0 g
s
.39732 .50323 m .46953 .53098 L .47703 .51638 L p .726 .676 .802 r
F P
0 g
s
.64061 .58265 m .5701 .55541 L .57021 .54341 L p .805 .486 .45 r
F P
0 g
s
.5701 .55541 m .64061 .58265 L .63586 .59907 L p .781 .615 .674 r
F P
0 g
s
.01 w
.63641 .59717 m
.66694 .6089 L
s
.5 Mabswid
.53652 .57166 m .52667 .57823 L .52325 .57577 L p .259 0 .042 r
F P
0 g
s
.52325 .57577 m .53459 .57032 L .53652 .57166 L p .259 0 .042 r
F P
0 g
s
.5107 .57641 m .52325 .57577 L .52667 .57823 L p .373 0 0 r
F P
0 g
s
.49937 .57211 m .4915 .56368 L .49193 .5543 L p .921 .606 .43 r
F P
0 g
s
.48891 .54756 m .49193 .5543 L .4915 .56368 L p .969 .715 .285 r
F P
0 g
s
.49193 .5543 m .48891 .54756 L .49109 .54045 L p .978 .864 .657 r
F P
0 g
s
.52667 .57823 m .51488 .57949 L .5107 .57641 L p .373 0 0 r
F P
0 g
s
.49937 .57211 m .5107 .57641 L .51488 .57949 L p .438 0 0 r
F P
0 g
s
.03 w
.50373 .57677 m
.50481 .5747 L
s
.49766 .58833 m
.50373 .57677 L
s
.5 Mabswid
.50174 .53016 m .49438 .53411 L .49754 .53094 L p .644 .961 .793 r
F P
0 g
s
.49754 .53094 m .50746 .52445 L .50174 .53016 L p .644 .961 .793 r
F P
0 g
s
.54343 .54865 m .53918 .53673 L .54269 .53897 L p 0 .025 .587 r
F P
0 g
s
.53918 .53673 m .53055 .52769 L .53488 .53043 L p 0 .127 .648 r
F P
0 g
s
.53488 .53043 m .54269 .53897 L .53918 .53673 L p 0 .127 .648 r
F P
0 g
s
.54269 .53897 m .54539 .54992 L .54343 .54865 L p 0 .025 .587 r
F P
0 g
s
.39099 .53162 m .46379 .55929 L .46448 .5473 L p .803 .49 .46 r
F P
0 g
s
.46448 .5473 m .3921 .51967 L .39099 .53162 L p .803 .49 .46 r
F P
0 g
s
.01 w
.4588 .52896 m
.45927 .52914 L
s
.5 Mabswid
.63586 .59907 m .56518 .57195 L .5701 .55541 L p .781 .615 .674 r
F P
0 g
s
.01 w
.54339 .56145 m
.56575 .57004 L
s
.5 Mabswid
.53055 .52769 m .51924 .5233 L .5235 .52601 L p .392 0 0 r
F P
0 g
s
.5235 .52601 m .53488 .53043 L .53055 .52769 L p .392 0 0 r
F P
0 g
s
.51488 .57949 m .50348 .57516 L .49937 .57211 L p .438 0 0 r
F P
0 g
s
.4915 .56368 m .49937 .57211 L .50348 .57516 L p 0 .085 .603 r
F P
0 g
s
.47703 .51638 m .4047 .4884 L .39732 .50323 L p .726 .676 .802 r
F P
0 g
s
.51924 .5233 m .50746 .52445 L .51081 .52663 L p .338 0 0 r
F P
0 g
s
.51081 .52663 m .5235 .52601 L .51924 .5233 L p .338 0 0 r
F P
0 g
s
.52667 .57823 m .53652 .57166 L .53979 .5686 L p .606 .942 .759 r
F P
0 g
s
.4915 .56368 m .48867 .55276 L .48891 .54756 L p .969 .715 .285 r
F P
0 g
s
.49109 .54045 m .48891 .54756 L .48867 .55276 L p .026 0 .316 r
F P
0 g
s
.49438 .53411 m .49109 .54045 L p .48867 .55276 L .026 0 .316 r
F P
0 g
s
.54539 .54992 m .54269 .53897 L .54248 .54835 L p .953 .7 .246 r
F P
0 g
s
.54248 .54835 m .54528 .55513 L .54539 .54992 L p .953 .7 .246 r
F P
0 g
s
.50348 .57516 m .49476 .56608 L .4915 .56368 L p 0 .085 .603 r
F P
0 g
s
.48867 .55276 m .4915 .56368 L .49476 .56608 L p 0 0 .559 r
F P
0 g
s
.49754 .53094 m .49438 .53411 L p .48867 .55276 L .026 0 .316 r
F P
0 g
s
.50746 .52445 m .49754 .53094 L .49936 .53217 L p .227 0 0 r
F P
0 g
s
.49936 .53217 m .51081 .52663 L .50746 .52445 L p .227 0 0 r
F P
0 g
s
.53979 .5686 m .53254 .57272 L .52667 .57823 L p .606 .942 .759 r
F P
0 g
s
.51488 .57949 m .52667 .57823 L .53254 .57272 L p .65 .892 .983 r
F P
0 g
s
.53254 .57272 m .53979 .5686 L .54314 .56227 L p .91 .958 .809 r
F P
0 g
s
.54528 .55513 m .54248 .54835 L .5386 .56128 L p .982 .87 .648 r
F P
0 g
s
.01 w
.53988 .5601 m
.53998 .56014 L
s
.5 Mabswid
.5386 .56128 m .54314 .56227 L .54528 .55513 L p .982 .87 .648 r
F P
0 g
s
.54269 .53897 m .53488 .53043 L .53458 .54211 L p .925 .603 .414 r
F P
0 g
s
.53458 .54211 m .54248 .54835 L .54269 .53897 L p .925 .603 .414 r
F P
0 g
s
.39446 .5345 m .46776 .56234 L .46379 .55929 L p .439 0 0 r
F P
0 g
s
.46379 .55929 m .39099 .53162 L .39446 .5345 L p .439 0 0 r
F P
0 g
s
.01 w
.45927 .52914 m
.48511 .53907 L
s
.5 Mabswid
.49936 .53217 m .49754 .53094 L p .48867 .55276 L .026 0 .316 r
F P
0 g
s
.49914 .53736 m .49936 .53217 L p .48867 .55276 L .026 0 .316 r
F P
0 g
s
.49695 .54454 m .49914 .53736 L p .48867 .55276 L .026 0 .316 r
F P
0 g
s
.01 w
.4972 .54371 m
.53905 .55978 L
s
.48511 .53907 m
.494 .54248 L
s
.5 Mabswid
.49363 .55093 m .49695 .54454 L p .48867 .55276 L .026 0 .316 r
F P
0 g
s
.48867 .55276 m .49046 .55406 L .49363 .55093 L p .026 0 .316 r
F P
0 g
s
.49476 .56608 m .49046 .55406 L .48867 .55276 L p 0 0 .559 r
F P
0 g
s
.54314 .56227 m .5386 .56128 L .53254 .57272 L p .91 .958 .809 r
F P
0 g
s
.53254 .57272 m .52215 .57261 L .51488 .57949 L p .65 .892 .983 r
F P
0 g
s
.50348 .57516 m .51488 .57949 L .52215 .57261 L p .569 .724 .946 r
F P
0 g
s
.53488 .53043 m .5235 .52601 L .52313 .53768 L p .805 .486 .45 r
F P
0 g
s
.03 w
.50504 .57426 m
.52475 .53668 L
s
.5 Mabswid
.52313 .53768 m .53458 .54211 L .53488 .53043 L p .805 .486 .45 r
F P
0 g
s
.52215 .57261 m .51069 .56824 L .50348 .57516 L p .569 .724 .946 r
F P
0 g
s
.49476 .56608 m .50348 .57516 L .51069 .56824 L p .477 .562 .863 r
F P
0 g
s
.4949 .64691 m .51148 .72068 L .47567 .74387 L p .387 .085 .326 r
F P
0 g
s
.56642 .42144 m .56485 .42432 L .52951 .52762 L closepath p .768 .822 .351 r
F P
0 g
s
.57329 .42207 m .56642 .42144 L .52951 .52762 L closepath p .877 .834 .8 r
F P
0 g
s
.58282 .42593 m .57329 .42207 L .52951 .52762 L closepath p .742 .665 .775 r
F P
0 g
s
.59143 .43157 m .58282 .42593 L .52951 .52762 L closepath p .621 .514 .711 r
F P
0 g
s
.59588 .43687 m .59143 .43157 L .52951 .52762 L closepath p .413 .256 .557 r
F P
0 g
s
.59443 .43982 m .59588 .43687 L .52951 .52762 L closepath p 0 0 0 r
F P
0 g
s
.58758 .43926 m .59443 .43982 L .52951 .52762 L closepath p .834 .888 .88 r
F P
0 g
s
.57794 .43536 m .58758 .43926 L .52951 .52762 L closepath p .707 .69 .831 r
F P
0 g
s
.56923 .42964 m .57794 .43536 L .52951 .52762 L closepath p .573 .523 .761 r
F P
0 g
s
.56485 .42432 m .56923 .42964 L .52951 .52762 L closepath p .303 .226 .602 r
F P
0 g
s
.03 w
.52919 .52822 m
.52951 .52762 L
s
.5 Mabswid
.50049 .56048 m .49363 .55093 L .49046 .55406 L p .364 .378 .742 r
F P
0 g
s
.49046 .55406 m .49476 .56608 L .50049 .56048 L p .364 .378 .742 r
F P
0 g
s
.51069 .56824 m .50049 .56048 L .49476 .56608 L p .477 .562 .863 r
F P
0 g
s
.52215 .57261 m .53254 .57272 L .5386 .56128 L p .815 .797 .835 r
F P
0 g
s
.5235 .52601 m .51081 .52663 L .51046 .53599 L p .683 .38 .455 r
F P
0 g
s
.51046 .53599 m .52313 .53768 L .5235 .52601 L p .683 .38 .455 r
F P
0 g
s
.51081 .52663 m .49936 .53217 L .49914 .53736 L p .532 .256 .441 r
F P
0 g
s
.54248 .54835 m .53458 .54211 L .5297 .55828 L p .874 .721 .688 r
F P
0 g
s
.5297 .55828 m .5386 .56128 L .54248 .54835 L p .874 .721 .688 r
F P
0 g
s
.49914 .53736 m .51046 .53599 L .51081 .52663 L p .532 .256 .441 r
F P
0 g
s
.5386 .56128 m .5297 .55828 L .52215 .57261 L p .815 .797 .835 r
F P
0 g
s
.50651 .54896 m .49695 .54454 L .49363 .55093 L p .53 .438 .695 r
F P
0 g
s
.49363 .55093 m .50049 .56048 L .50651 .54896 L p .53 .438 .695 r
F P
0 g
s
.51046 .53599 m .49914 .53736 L .49695 .54454 L p .575 .399 .605 r
F P
0 g
s
.51069 .56824 m .52215 .57261 L .5297 .55828 L p .726 .679 .804 r
F P
0 g
s
.49695 .54454 m .50651 .54896 L .51046 .53599 L p .575 .399 .605 r
F P
0 g
s
.40128 .52703 m .41849 .53359 L p .4192 .53654 L .569 .724 .946 r
F P
0 g
s
.46776 .56234 m .39446 .5345 L .40128 .52703 L p .569 .724 .946 r
F P
0 g
s
.47497 .55512 m .40128 .52703 L .40883 .51195 L p .726 .679 .804 r
F P
0 g
s
.27073 .56248 m .40514 .54635 L .41626 .52424 L p .893 .912 .83 r
F P
0 g
s
.40883 .51195 m .48264 .54028 L .47497 .55512 L p .726 .679 .804 r
F P
0 g
s
.48264 .54028 m .40883 .51195 L .41414 .49516 L p .781 .615 .674 r
F P
0 g
s
.41626 .52424 m .42479 .50729 L p .4132 .51144 L .893 .912 .83 r
F P
0 g
s
.4132 .51144 m .27073 .56248 L .41626 .52424 L .893 .912 .83 r
F
.47497 .55512 m .46776 .56234 L p .4192 .53654 L .569 .724 .946 r
F P
0 g
s
.41849 .53359 m .47497 .55512 L p .4192 .53654 L .569 .724 .946 r
F P
0 g
s
.53458 .54211 m .52313 .53768 L .51823 .55388 L p .781 .615 .674 r
F P
0 g
s
.51823 .55388 m .5297 .55828 L .53458 .54211 L p .781 .615 .674 r
F P
0 g
s
.51823 .55388 m .50651 .54896 L .50049 .56048 L p .642 .573 .761 r
F P
0 g
s
.02 w
.514 .53966 m
.51767 .55364 L
s
.5 Mabswid
.50049 .56048 m .51069 .56824 L .51823 .55388 L p .642 .573 .761 r
F P
0 g
s
.5297 .55828 m .51823 .55388 L .51069 .56824 L p .726 .679 .804 r
F P
0 g
s
.02 w
.52019 .56326 m
.52137 .56776 L
s
.52137 .56776 m
.52333 .57521 L
s
.5 Mabswid
.52313 .53768 m .51046 .53599 L .50651 .54896 L p .693 .52 .649 r
F P
0 g
s
.48834 .51165 m .41514 .48324 L .4115 .48073 L p .391 0 0 r
F P
0 g
s
.41514 .48324 m .48834 .51165 L .48776 .5236 L p .805 .486 .45 r
F P
0 g
s
.50651 .54896 m .51823 .55388 L .52313 .53768 L p .693 .52 .649 r
F P
0 g
s
.48776 .5236 m .41414 .49516 L .41514 .48324 L p .805 .486 .45 r
F P
0 g
s
.41414 .49516 m .48776 .5236 L .48264 .54028 L p .781 .615 .674 r
F P
0 g
s
.55259 .65579 m .53744 .59939 L .51989 .60314 L p .55 .174 .281 r
F P
0 g
s
.53744 .59939 m .55259 .65579 L .56562 .6432 L p .273 .017 .331 r
F P
0 g
s
.56562 .6432 m .54986 .58725 L .53744 .59939 L p .273 .017 .331 r
F P
0 g
s
.53423 .65972 m .51989 .60314 L .50383 .59708 L p .763 .317 .192 r
F P
0 g
s
.51989 .60314 m .53423 .65972 L .55259 .65579 L p .55 .174 .281 r
F P
0 g
s
.54986 .58725 m .56562 .6432 L .56837 .62667 L p 0 0 .323 r
F P
0 g
s
.56837 .62667 m .55243 .57127 L .54986 .58725 L p 0 0 .323 r
F P
0 g
s
.51745 .65352 m .50383 .59708 L .49534 .58346 L p .858 .452 0 r
F P
0 g
s
.50383 .59708 m .51745 .65352 L .53423 .65972 L p .763 .317 .192 r
F P
0 g
s
.55243 .57127 m .56837 .62667 L .55969 .61247 L p .829 .422 0 r
F P
0 g
s
.55969 .61247 m .54408 .55752 L .55243 .57127 L p .829 .422 0 r
F P
0 g
s
.49534 .58346 m .50861 .63946 L .51745 .65352 L p .858 .452 0 r
F P
0 g
s
.50861 .63946 m .49534 .58346 L .49773 .5674 L p 0 0 .284 r
F P
0 g
s
.54408 .55752 m .55969 .61247 L .54281 .6061 L p .758 .3 .163 r
F P
0 g
s
.54281 .6061 m .52793 .55131 L .54408 .55752 L p .758 .3 .163 r
F P
0 g
s
.51117 .62285 m .49773 .5674 L .51019 .55509 L p .249 0 .309 r
F P
0 g
s
.49773 .5674 m .51117 .62285 L .50861 .63946 L p 0 0 .284 r
F P
0 g
s
.52793 .55131 m .54281 .6061 L .52424 .61007 L p .54 .155 .26 r
F P
0 g
s
.02 w
.53203 .6084 m
.53216 .60889 L
s
.53216 .60889 m
.54633 .66291 L
s
.5 Mabswid
.52424 .61007 m .51019 .55509 L .52793 .55131 L p .54 .155 .26 r
F P
0 g
s
.51019 .55509 m .52424 .61007 L .51117 .62285 L p .249 0 .309 r
F P
0 g
s
.42479 .50729 m .29094 .52032 L .27073 .56248 L p .893 .912 .83 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00D03oool0
0`000000oooo0?ooo`3=0?ooo`00D03oool200000<h0oooo001?0?ooo`030000002=MkH0SGNf0080
0000c03oool004l0oooo00<0000008eg]P2=MkH00P2=MkH00`000000oooo0?ooo`390?ooo`00CP3o
ool00`000000SGNf08eg]P0408eg]P030000003oool0oooo0<P0oooo001>0?ooo`030000002=MkH0
SGNf00D0SGNf0P0000380?ooo`00C@3oool00`000000SGNf08eg]P0808eg]P030000003oool0oooo
0<D0oooo001=0?ooo`030000002=MkH0SGNf00T0SGNf00<000000?ooo`3oool0a03oool004`0oooo
00<0000008eg]P2=MkH02`2=MkH00`000000oooo0?ooo`330?ooo`00C03oool00`000000SGNf08eg
]P0<08eg]P800000``3oool004/0oooo00<0000008eg]P2=MkH03`2=MkH00`000000oooo0?ooo`30
0?ooo`00B`3oool00`000000SGNf08eg]P0@08eg]P030000003oool0oooo0;l0oooo001<0?ooo`03
0000002=MkH0SGNf0100SGNf0P00002o0?ooo`00C@3oool200000180SGNf00<000000?ooo`3oool0
_03oool004l0oooo00<0000008eg]P2=MkH0402=MkH00`000000oooo0?ooo`2k0?ooo`00D03oool0
0`000000SGNf08eg]P0@08eg]P030000003oool0oooo03`0oooo00<000000?ooo`3oool0N`3oool0
0540oooo00<0000008eg]P2=MkH0402=MkH2000003`0oooo1000001j0?ooo`00DP3oool200000180
SGNf00<000000?ooo`3oool0>03oool2000000030>3Ec0000000_J[600800000N03oool005@0oooo
00<0000008eg]P2=MkH0402=MkH00`000000oooo0?ooo`0g0?ooo`030000001=>IX000000080_J[6
00@0000009j3]P0000000000MP3oool005D0oooo00<0000008eg]P2=MkH0402=MkH2000003L0oooo
00<0000004diVP0000000`000000102NPkH0000006U1SP00001e0?ooo`00EP3oool00`000000SGNf
08eg]P0A08eg]P030000003oool0oooo03<0oooo0`0000000`2BQL8000000;B`e00300000080JD6>
00<000000?ooo`3oool0LP3oool005L0oooo0P00000B08eg]P030000003oool0oooo0380oooo00D0
000004diVP000000TXG2000000030;B`e0<00000M@3oool005T0oooo00<0000008eg]P2=MkH0402=
MkH00`000000oooo0?ooo`0a0?ooo`80000000<0TXG20000002d/=@00P2d/=@00`000000eN?Q0000
001f0?ooo`00FP3oool00`000000SGNf08eg]P0@08eg]P800000<03oool01@000000CCVJ0000002B
QL80000000<0];3D0`00001f0?ooo`00F`3oool00`000000SGNf08eg]P0A08eg]P030000003oool0
oooo02d0oooo0P0000000`2BQL8000000;B`e0020;B`e0030000003Ehn40000007L0oooo001L0?oo
o`8000004P2=MkH00`000000oooo0?ooo`0[0?ooo`<0000000L0TXG20000002d/=@0];3D0000003E
hn40000007P0oooo001N0?ooo`030000002=MkH0SGNf0100SGNf0P00000[0?ooo`040000001=>IX0
0000000000<0];3D0P00001i0?ooo`00G`3oool00`000000SGNf08eg]P0A08eg]P030000003oool0
oooo02P0oooo0P000000102BQL8000000;B`e02d/=@3000007T0oooo001P0?ooo`8000004P2=MkH0
0`000000oooo0?ooo`0V0?ooo`@000000P2d/=@00`000000eN?Q0000001j0?ooo`00HP3oool00`00
0000SGNf08eg]P0@08eg]P030000003oool0oooo02D0oooo0P000000102BQL8000000;B`e02d/=@2
000007/0oooo001S0?ooo`030000002=MkH0SGNf0100SGNf0P00000G0?ooo`<000002`3oool30000
0080];3D0P00001l0?ooo`00I03oool00`000000SGNf08eg]P0A08eg]P030000003oool0oooo0140
oooo0`00000208XW@P<00000203oool20000000309:5`P000000];3D00<00000O03oool006D0oooo
0P00000?08eg]P<000004P3oool2000000@0RRM200<000000<9<:@32C2T00P0000060?ooo`<00000
0P2d/=@2000007d0oooo001W0?ooo`030000002=MkH0SGNf00/0SGNf00<0000009>hl00000000P00
000A0?ooo`030000000o04l0000000@0RRM200<000000<9<:@32C2T00P0000050?ooo`<0000000<0
];3D000000000000OP3oool006P0oooo00<0000008eg]P2=MkH02P2=MkH010000000TkS`0000003>
O7<3000000h0oooo00@0000003l0C`0o04l00000102:9d801@000000`T`Y0<9<:@32C2T0000000@0
oooo0`0000000`2d/=@000000000001o0?ooo`00J@3oool00`000000SGNf08eg]P0708eg]P050?oo
o`000000000009>hl00000000`3>O7<4000000X0oooo00D0000003l0C`0o04l0?`1?0000000408XW
@P0400000032C2T0`T`Y0<9<:@8000000`3oool500000800oooo001Z0?ooo`8000001`2=MkH0103o
ool000000;V]c@0000070<ilL`<00000203oool01@000000?`1?03l0C`0o04l0000000@0RRM200L0
00000<9<:@32C2T0`T`Y0000003DK00000000080oooo0P0000000`2d/=@00000000000200?ooo`00
K03oool00`000000SGNf08eg]P0408eg]P030000002i[Ld0^Jg=008000002@3>O7<2000000H0oooo
00<0000003l0C`0o04l00P0o04l01@000000RRM208XW@P2:9d80000000@0`T`Y0P0000000`3oool0
00000000000300000840oooo001]0?ooo`030000002=MkH0SGNf00<0SGNf00D000000;V]c@2i[Ld0
00000<NM[002000000T0cWac0`0000020?ooo`030000000004P0000000<0?`1?1P0000030<9<:@80
000000<0oooo0000000000000P0000220?ooo`00KP3oool01@000000SGNf08eg]P2=MkH0000000<0
^Jg=00@000000<NM[037WJ`0aif/0`0000090<ilL`<0000000<000180000000o04l00P0o04l60000
00<0`T`Y00<000000=A/000000000`0000230?ooo`00K`3oool20000000308eg]P000000000000H0
00000`37WJ`3000000T0cWac0P00000403l0C`L000000P32C2T5000008<0oooo001[0?ooo`X00000
103TjM@00`000000aif/0<NM[0040<NM[08000002@3>O7<200000080?`1?1@0000020?ooo`H00000
Q03oool00680oooo2@00000=0>CYe00300000037WJ`0aif/00L0aif/0`0000070<ilL`P0000000@0
oooo0000001515@0A@AD0`0000250?ooo`00F03oool:000001H0i>WD0`00000:0<NM[0<00000103>
O7<00`000000oooo0?ooo`0<000008D0oooo001C0?ooo`D000007`3TjM@010000000^Jg=0;V]c@2i
[Ld3000000X0aif/0P0000000`3>O7<000000<=A<@0>000008D0oooo001C0?ooo`030000003TjM@0
i>WD0240i>WD00<000000;V]c@2i[Ld0102i[Ld2000000X0aif/0P0000030<=A<@`00000Q@3oool0
0580oooo00<000000>CYe03TjM@08P3TjM@00`000000^Jg=0;V]c@060;V]c@8000002@37WJ`20000
0080`e4a00<0000003X0000000000P0000020:iQM0D00000Q@3oool00580oooo00<000000>CYe03T
jM@08@3TjM@00`000000^Jg=0;V]c@090;V]c@<000001P37WJ`2000000030<=A<@000000000000/0
0000Q@3oool00540oooo00<000000>CYe03TjM@08P3TjM@4000000/0^Jg=0P0000030<NM[0@00000
00<01P1@00000028@G002`0000240?ooo`00D@3oool00`000000i>WD0>CYe00Q0>CYe0050000002A
^O80TKWb096ilP3=OGD00`00000:0;V]c@80000000<0aif/0000000000000P0000000`0605000000
00000002000000030;65YP000000000000H00000Q03oool00500oooo00<000000>CYe03TjM@08P3T
jM@3000000<0TKWb00@0cGee00000000000000002P2i[Ld70000000309=VVP000000000000<0/HFV
00<000000<NM[00000000`0000060?ooo`<00000N`3oool00500oooo00<000000>CYe03TjM@07P3T
jM@4000000<0oooo0`000002096ilP030<emM@2A^O80000000800000202i[Ld00`000000oooo00H0
D0030000000309=VVP000000/HFV0080/HFV0P0000020<NM[0@00000103oool010000000TkS`0000
003>O7<2000007T0oooo001?0?ooo`030000003TjM@0i>WD01L0i>WD2000000:0?ooo`8000001@2A
^O83000000@0^Jg=00<000000?ooo`3oool00P0605000`000000Qg2a0000000200000080/HFV0P00
00020<NM[0040000003O^;000000000000<0oooo00@0000009>hl02C^?0000000`3>O7<3000007H0
oooo001?0?ooo`030000003TjM@0i>WD00l0i>WD2000000D0?ooo`<00000102A^O8300000080^Jg=
00<000000?ooo`3oool00P00000208M`/@030000002TT/80000000H000000P3O^;0200000080oooo
00<000000;V]c@2i[Ld00P0000060<ilL`800000M03oool004h0oooo00<000000>CYe03TjM@0203T
jM@8000001l0oooo0`000004096ilP8000000`3oool01P000000GF2m00000027L;4000000:BB`P<0
00000P2:9d800`000000`T`Y0000000300000080oooo00@000000;V]c@2i[Ld0^Jg=0P0000070<il
L`<00000L@3oool004h0oooo00<000000>CYe03TjM@02000000V0?ooo`8000000P1S5E<200000080
TKWb0P0000030?ooo`030000001MH;d0GF2m00@000001@2:9d800`000000`T`Y0<9<:@0200000003
0?ooo`000000^Jg=00<0^Jg=00@000000<NM[00000000000203>O7<3000006h0oooo001=0?ooo`@0
0000;@3oool00`000000HaEC06<ED`0406<ED`80000000<0HaEC0000003oool00P3oool400000080
?`1?00<0000008XW@P2:9d800`2:9d8010000000`T`Y0<9<:@32C2T3000000@0^Jg=00@000000<NM
[037WJ`0aif/0`0000070<ilL`@00000J`3oool007h0oooo00<0000006<ED`1S5E<01`1S5E<01000
0000oooo0?ooo`3oool3000000@0?`1?00<0000008XW@P2:9d800P2:9d800`000000`T`Y0<9<:@02
0<9<:@H000001`37WJ`2000000P0cWac0`00001Y0?ooo`00OP3oool00`000000HaEC06<ED`0706<E
D`040000003oool0oooo0?ooo`<00000100o04l00`000000RRM208XW@P0208XW@P0300000032C2T0
`T`Y0080`T`Y1`0000080<NM[0<000001`3>O7<2000006P0oooo001o0?ooo`030000001S5E<0HaEC
00L0HaEC00<000000?ooo`3oool00`00000403l0C`030000002:9d80RRM200<0RRM200H000000<9<
:@32C2T0`T`Y0000003DK0030<NM[08000002`37WJ`2000000H0cWac00<000000?ooo`3oool0IP3o
ool007l0oooo00<0000006<ED`1S5E<00P1S5E<<000000<0?`1?00<0000008XW@P2:9d800`2:9d80
2@000000`T`Y0<9<:@32C2T000000=A/00000000aif/000000020;V]c@<000002P37WJ`3000000<0
cWac00<000000?ooo`3oool0IP3oool007l0oooo00<0000006<ED`1S5E<00P1S5E<01P000000fm_F
0=_KeP3KfmH000000;V]c@H00000100o04l00`000000RRM208XW@P0208XW@P0300000032C2T0`T`Y
0080`T`Y0P0000000`37WJ`000000;V]c@040;V]c@<000002P37WJ`2000000030<ilL`000000oooo
06L0oooo001o0?ooo`050000001S5E<0HaEC06<ED`000000103KfmH00`000000^Jg=000000050000
00@0?`1?00<0000008XW@P2:9d800P2:9d800`000000`T`Y0<9<:@020<9<:@<000002@2i[Ld20000
00X0aif/0P00001X0?ooo`00N`3oool01@000000oooo0?ooo`3oool000000080HaEC0P0000030=_K
eP030000002i[Ld0^Jg=00H00000100o04l00`000000RRM208XW@P0308XW@P0700000032C2T0`T`Y
0<9<:@000000e6`00000000;0;V]c@<000002037WJ`00`000000oooo0?ooo`1V0?ooo`00N@3oool3
000000<0oooo00H0000006<ED`1S5E<0000005XkT`0000020=_KeP030000002i[Ld0000000D00000
00<000180000000o04l00P0o04l00`000000RRM208XW@P0308XW@P0600000032C2T0`T`Y0<9<:@00
0000e6`00`00000<0;V]c@<000001@37WJ`00`000000oooo0?ooo`1V0?ooo`00N03oool010000000
IQYG06HJE`0000040?ooo`8000000P1J>i<00`000000fm_F000000030;V]c@L00000100o04l00`00
0000RRM208XW@P0208XW@P0300000032C2T0`T`Y0080`T`Y0P000002096ilP<00000302i[Ld30000
00030<NM[0000000oooo06P0oooo001f0?ooo`800000101V6UL010000000oooo0?ooo`3oool20000
00<0FS^C0P0000020;V]c@P00000100o04l00`000000RRM208XW@P0208XW@P0300000032C2T0`T`Y
0080`T`Y0`000004096ilP<00000302i[Ld5000006H0oooo001e0?ooo`030000001V6UL0IQYG00@0
IQYG00D000000?ooo`3oool0oooo0000000405XkT`<0000000<0^Jg=0000000000001P00000403l0
C`030000002:9d80000000@000000`32C2T00`000000e6`000000003000000@0TKWb0P00000;0;V]
c@L00000H`3oool007<0oooo0P00000706HJE`050000003oool0oooo0?ooo`0000000`1J>i<01000
0000V8Bl09R4_02HQ;`8000000030000B0000000?`1?0080?`1?00<0000008XW@P0000001@000002
0<9<:@030000003DK000000000<0oooo0P000004096ilP<000001`2i[Ld010000000oooo0?ooo`3o
ool700000600oooo001b0?ooo`030000001V6UL0IQYG00L0IQYG00@000000?ooo`3oool00000101J
>i<00`000000V8Bl09R4_009000000030000B0000000?`1?00<0?`1?1@00000204D4E080000000<0
`T`Y0000000000001@3oool3000000@0TKWb0`0000040;V]c@030000003oool0oooo00@0oooo1@00
001O0?ooo`00LP3oool00`000000IQYG06HJE`0706HJE`040000003oool0oooo000000<0FS^C00@0
000009R4_02HQ;`0V8Bl2@0000000`0004P0000003l0C`0303l0C`H000000`1515@2000000030=A/
00000000oooo00H0oooo0`000004096ilP80000000<0^Jg=0000003oool02@3oool00`000000oooo
0?ooo`1N0?ooo`00LP3oool00`000000IQYG06HJE`0806HJE`800000101J>i<00`000000V8Bl09R4
_00:000000040000B0000000?`1?03l0C`P000000`1515@010000000001B00000000000:0?ooo`<0
00000`2A^O82000006/0oooo001b0?ooo`030000001V6UL0IQYG00P0IQYG0P00000305XkT`030000
002HQ;`0V8Bl0080V8Bl200000001@2i[Ld000000000B00o04l000000080`e4a1P00000404D4E0<0
0000303oool4000006d0oooo001c0?ooo`030000001V6UL0IQYG00L0IQYG00<0000005XkT`1J>i<0
0P1J>i<00`000000V8Bl09R4_00409R4_0D000000P2i[Ld00`0000000018000000030<=A<@H00000
101515@010000000001B00000000001l0?ooo`00L`3oool00`000000IQYG06HJE`0706HJE`050000
001J>i<0FS^C05XkT`0000001`2HQ;`500000080^Jg=00<000000000B00000000`33DC47000000<0
A@AD00@000000000DP0005800000O03oool007<0oooo00<0000006HJE`1V6UL01P1V6UL00`000000
FS^C05XkT`0205XkT`030000002HQ;`0V8Bl00@0V8Bl00D000000;V]c@2i[Ld0^Jg=000000030;V]
c@030000000004P0000000@0`e4a1P00000404D4E003000000000580000007`0oooo001c0?ooo`03
0000001V6UL0IQYG00D0IQYG00<0000005XkT`1J>i<00P1J>i<00`000000V8Bl09R4_00509R4_003
0000002i[Ld0^Jg=00@0^Jg=00@000000=cNe`000000fg<01033DC46000000@0A@AD00<000000000
DP000000O03oool007<0oooo00<0000006HJE`1V6UL01@1V6UL00`000000FS^C05XkT`0205XkT`03
0000002HQ;`0V8Bl00@0V8Bl00<000000;V]c@2i[Ld01@2i[Ld20=cNe`030000003KL`00000000<0
`e4a1P00000404D4E0800000O@3oool007<0oooo00<0000006HJE`1V6UL0101V6UL00`000000FS^C
05XkT`0205XkT`030000002HQ;`0V8Bl00D0V8Bl00<000000;V]c@2i[Ld0102i[Ld01P000000g=kG
0=cNe`000000fg<0000000<0`e4a1`00000404D4E0030000003oool0oooo07/0oooo001c0?ooo`03
0000001V6UL0IQYG00@0IQYG00<0000005XkT`1J>i<00P1J>i<00`000000V8Bl09R4_00409R4_003
0000002i[Ld0^Jg=00D0^Jg=00H000000=cNe`3Lg]L0g=kG0000003KL`040<=A<@H00000101515@0
0`000000oooo0?ooo`1k0?ooo`00M03oool00`000000IQYG06HJE`0206HJE`030000001J>i<0FS^C
0080FS^C00<0000009R4_02HQ;`01@2HQ;`00`000000^Jg=0;V]c@040;V]c@8000000`3Lg]L00`00
0000fg<00<=A<@030<=A<@H000000`1515@00`000000oooo0?ooo`1l0?ooo`00M03oool00`000000
IQYG06HJE`0206HJE`030000001J>i<0FS^C0080FS^C00<0000009R4_02HQ;`0102HQ;`00`000000
^Jg=0;V]c@040;V]c@<000000P3Lg]L010000000oooo0000000000030<=A<@H000000P1515@00`00
0000oooo0?ooo`1m0?ooo`00M03oool01@000000IQYG06HJE`1V6UL0000000@0FS^C00<0000009R4
_02HQ;`01@2HQ;`00`000000^Jg=0;V]c@030;V]c@040000001S5E<0HaEC00000080g=kG00<00000
0?ooo`3oool00P0000020<=A<@P00000P03oool007@0oooo00D0000006HJE`1V6UL0IQYG00000004
05XkT`030000002HQ;`0V8Bl00@0V8Bl00<000000;V]c@2i[Ld00P2i[Ld2000000@0HaEC0P000005
0?ooo`80000000<0`e4a000000000000100000210?ooo`00M03oool010000000IQYG06HJE`000004
05XkT`030000002HQ;`0V8Bl00@0V8Bl00<000000;V]c@2i[Ld00P2i[Ld00`000000HaEC06<ED`04
06<ED`8000001`3oool700000840oooo001d0?ooo`040000001V6UL0IQYG000000@0FS^C00<00000
09R4_02HQ;`0102HQ;`00`000000^Jg=0;V]c@02000000L0HaEC00<000000?ooo`3oool0203oool5
00000840oooo001e0?ooo`800000101J>i<00`000000V8Bl09R4_00409R4_0040000002i[Ld0^Jg=
000000T0HaEC00<000000?ooo`3oool0203oool500000840oooo001e0?ooo`<000000`1J>i<00`00
0000V8Bl09R4_00409R4_0030000002i[Ld0000000X0HaEC00<000000?ooo`3oool0203oool50000
0840oooo001e0?ooo`030000003KfmH000000080FS^C00<0000009R4_02HQ;`0102HQ;`010000000
^Jg=0;V]c@00000;06<ED`030000003oool0oooo08d0oooo001e0?ooo`060000003KfmH0fm_F0000
001J>i<000001P2HQ;`010000000^Jg=0;V]c@00000;06<ED`030000003oool0oooo08d0oooo001d
0?ooo`030000003KfmH0fm_F0080fm_F00<0000009R4_02HQ;`0102HQ;`00`000000^Jg=0;V]c@02
0;V]c@030000001S5E<0HaEC00P0HaEC00<000000?ooo`3oool0S@3oool007@0oooo0P0000020=_K
eP030000002i[Ld0000000D0V8Bl00<000000;V]c@2i[Ld00P2i[Ld00`000000HaEC06<ED`0806<E
D`030000003oool0oooo08d0oooo001c0?ooo`030000001J>i<000000080fm_F00<000000;V]c@2i
[Ld00P00000209R4_0030000002i[Ld0^Jg=00<0^Jg=00<0000006<ED`1S5E<0201S5E<00`000000
oooo0?ooo`2=0?ooo`00L`3oool00`000000FS^C05XkT`02000000<0^Jg=0`0000000`2HQ;`00000
0;V]c@040;V]c@030000001S5E<0HaEC00P0HaEC00<000000?ooo`3oool0S@3oool00780oooo00<0
000005XkT`1J>i<00P1J>i<00`000000^Jg=0;V]c@06000000D0^Jg=00<0000006<ED`1S5E<02@1S
5E<00`000000oooo0?ooo`2<0?ooo`00LP3oool020000000FS^C05XkT`1J>i<0000009R4_0000000
^Jg=2P0000020;V]c@030000001S5E<0HaEC00P0HaEC00<000000?ooo`3oool0S03oool00740oooo
00<0000005XkT`1J>i<00P1J>i<00`000000V8Bl09R4_00900000080VHFl0`00000:06<ED`030000
003oool0oooo08`0oooo001a0?ooo`050000001J>i<0FS^C05XkT`0000000`2HQ;`900000080VHFl
00<0000005m0U@0000002P1S5E<00`000000oooo0?ooo`2<0?ooo`00L03oool00`000000FS^C05Xk
T`0205XkT`030000002HQ;`0V8Bl00X000000P2IQK`00`000000Gd2E0000000:06<ED`030000003o
ool0oooo08`0oooo001`0?ooo`050000001J>i<0FS^C05XkT`0000000P2HQ;`6000000030;V]c@00
000000000080000000D0VHFl0000001O@9D0Gd2E0000000;06<ED`030000003oool0oooo08/0oooo
001_0?ooo`050000001J>i<0FS^C05XkT`000000102HQ;`4000000H0^Jg=1@00000;06<ED`030000
003oool0oooo08/0oooo001_0?ooo`050000001J>i<0FS^C05XkT`0000001P2HQ;`2000000H0^Jg=
00<000000=cNe`3Lg]L00P3Lg]L00`000000HaEC06<ED`0806<ED`030000003oool0oooo08/0oooo
001`0?ooo`030000001J>i<0000000L0V8Bl00<000000;V]c@2i[Ld01@2i[Ld010000000g=kG0=cN
e`3Lg]L2000000P0HaEC0P00002>0?ooo`00L03oool00`000000FS^C0000000709R4_0030000002i
[Ld0^Jg=00<0^Jg=0`0000030=cNe`8000001`1S5E<00`000000oooo0?ooo`2>0?ooo`00L@3oool0
0`000000V8Bl09R4_00509R4_0070000002i[Ld0^Jg=0;V]c@000000^Jg=0000000206HJE`060000
003Lg]L0g=kG0000003oool000001@1S5E<200000940oooo001b0?ooo`8000001@2HQ;`01P000000
^Jg=0;V]c@000000^Jg=000000@0IQYG00D000000=cNe`000000oooo0000000406<ED`030000003o
ool0oooo0940oooo001c0?ooo`8000000`2HQ;`00`000000^Jg=00000003000000D0IQYG0P000003
0?ooo`040000001S5E<0HaEC000009@0oooo001d0?ooo`<0000000<0V8Bl0000000000000P000007
06HJE`8000000`3oool3000009D0oooo001f0?ooo`D00000201V6UL00`000000oooo0?ooo`020?oo
o`030000003oool0oooo09D0oooo001e0?ooo`H00000201V6UL00`000000oooo0?ooo`2J0?ooo`00
M03oool3000000030?ooo`000000000000T0IQYG00<000000?ooo`3oool0VP3oool007@0oooo0`00
00000`3oool0000006HJE`0:06HJE`030000003oool0oooo09T0oooo001c0?ooo`@0000000<0oooo
0000001V6UL02P1V6UL00`000000oooo0?ooo`2I0?ooo`00LP3oool5000000030?ooo`000000IQYG
00X0IQYG00<000000?ooo`3oool0V@3oool00740oooo1@0000030?ooo`030000001V6UL0IQYG00P0
IQYG00<000000?ooo`3oool0V@3oool00740oooo1@0000030?ooo`030000001V6UL0IQYG00P0IQYG
00<000000?ooo`3oool0V@3oool00700oooo0`0000000`2mZLH00000000000030?ooo`030000001V
6UL0IQYG00T0IQYG00<000000?ooo`3oool0V03oool006l0oooo0P000000102OPkH0000000000000
00040?ooo`030000001V6UL0IQYG00T0IQYG00<000000?ooo`3oool0V03oool006l0oooo0`000000
0`2mZLH00000000000040?ooo`030000001V6UL0IQYG00T0IQYG00<000000?ooo`3oool0V03oool0
06h0oooo0P0000000`2OPkH000000;fYaP02000000@0oooo00<0000006HJE`1V6UL02@1V6UL00`00
0000oooo0?ooo`2H0?ooo`00K@3oool20000000309n3]P000000_JW6008000001P3oool00`000000
IQYG06HJE`0806HJE`030000003oool0oooo09P0oooo001/0?ooo`<0000000<0Wh>f0000002mZLH0
0P0000060?ooo`030000001V6UL0IQYG00T0IQYG00<000000?ooo`3oool0U`3oool006`0oooo0P00
00001P2OPkH000000;fYaP000000gmC<000000H0oooo00<0000006HJE`1V6UL02@1V6UL00`000000
oooo0?ooo`2G0?ooo`00J`3oool200000080Wh>f00@000000;fYaP00000000001`3oool00`000000
IQYG06HJE`0906HJE`030000003oool0oooo09L0oooo001Z0?ooo`<0000000@0Wh>f0000002mZLH0
_JW60P0000070?ooo`030000001V6UL0IQYG00T0IQYG00<000000?ooo`3oool0U`3oool006T0oooo
0`00000209n3]P050000002mZLH000000=oDc00000001`3oool00`000000IQYG06HJE`0906HJE`03
0000003oool0oooo09L0oooo001Y0?ooo`050000001[@hl0000009n3]P0000000P2mZLH3000000L0
oooo00<0000006HJE`1V6UL02@1V6UL00`000000oooo0?ooo`2G0?ooo`00J03oool00`000000Jd>?
0000000209n3]P050000002mZLH000000=oDc00000002@3oool00`000000IQYG06HJE`0906HJE`03
0000003oool0oooo09H0oooo001X0?ooo`8000000P2OPkH01P000000_JW60;fYaP000000gmC<0000
00T0oooo00<0000006HJE`1V6UL02@1V6UL00`000000oooo0?ooo`2F0?ooo`00I`3oool00`000000
Jd>?0000000209n3]P030000002mZLH0_JW600<000002@3oool00`000000IQYG06HJE`0906HJE`03
0000003oool0oooo09H0oooo001X0?ooo`040000002OPkH0Wh>f00000080_JW600<000000=oDc000
00002P3oool00`000000IQYG06HJE`0906HJE`030000003oool0oooo09H0oooo001Y0?ooo`030000
002OPkH000000080_JW600<000000=oDc00000002P3oool00`000000IQYG06HJE`0906HJE`030000
003oool0oooo09H0oooo001Z0?ooo`80000000<0_JW60000003Oe<`00P00000:0?ooo`030000001V
6UL0IQYG00X0IQYG00<000000?ooo`3oool0U@3oool006`0oooo1000000<0?ooo`030000001V6UL0
IQYG00T0IQYG00<000000?ooo`3oool0U@3oool007`0oooo00<0000006HJE`1V6UL02@1V6UL00`00
0000oooo0?ooo`2E0?ooo`00O03oool00`000000IQYG06HJE`0706HJE`800000V03oool007`0oooo
00<0000006HJE`1V6UL01P1V6UL00`000000oooo0?ooo`2H0?ooo`00O03oool00`000000IQYG06HJ
E`0506HJE`030000003oool0oooo09T0oooo001l0?ooo`030000001V6UL0IQYG00<0IQYG0P00002L
0?ooo`00O@3oool01@000000IQYG06HJE`1V6UL0000009h0oooo001m0?ooo`040000001V6UL0IQYG
000009l0oooo001m0?ooo`<00000X03oool007d0oooo00<000000?ooo`3oool0X03oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.3374 .68275 m .22398 .5655 L .25988 .54552 L p .682 .413 .508 r
F P
0 g
s
.25988 .54552 m .37407 .66088 L .3374 .68275 L p .682 .413 .508 r
F P
0 g
s
.50942 .57466 m .53998 .60118 L .54293 .58541 L p .969 .8 .619 r
F P
0 g
s
.54293 .58541 m .51251 .55849 L .50942 .57466 L p .969 .8 .619 r
F P
0 g
s
.51251 .55849 m .54293 .58541 L .55422 .573 L p .86 .864 .842 r
F P
0 g
s
.55422 .573 m .52413 .54573 L .51251 .55849 L p .86 .864 .842 r
F P
0 g
s
.52413 .54573 m .55422 .573 L .56962 .56863 L p .649 .827 .968 r
F P
0 g
s
.51607 .58814 m .54656 .61439 L .53998 .60118 L p .881 .458 .054 r
F P
0 g
s
.53998 .60118 m .50942 .57466 L .51607 .58814 L p .881 .458 .054 r
F P
0 g
s
.56962 .56863 m .5399 .54118 L .52413 .54573 L p .649 .827 .968 r
F P
0 g
s
.5399 .54118 m .56962 .56863 L .58333 .574 L p .083 .511 .902 r
F P
0 g
s
.40276 .60904 m .32024 .52826 L .35232 .51029 L p .681 .408 .502 r
F P
0 g
s
.35232 .51029 m .43528 .5899 L .40276 .60904 L p .681 .408 .502 r
F P
0 g
s
.53001 .59376 m .56023 .61995 L .54656 .61439 L p .035 .487 .882 r
F P
0 g
s
.54656 .61439 m .51607 .58814 L .53001 .59376 L p .035 .487 .882 r
F P
0 g
s
.58333 .574 m .55388 .5466 L .5399 .54118 L p .083 .511 .902 r
F P
0 g
s
.55388 .5466 m .58333 .574 L .59009 .58716 L p .863 .433 .006 r
F P
0 g
s
.54595 .58927 m .57579 .61565 L .56023 .61995 L p .642 .832 .974 r
F P
0 g
s
.56023 .61995 m .53001 .59376 L .54595 .58927 L p .642 .832 .974 r
F P
0 g
s
.59009 .58716 m .56073 .56002 L .55388 .5466 L p .863 .433 .006 r
F P
0 g
s
.56073 .56002 m .59009 .58716 L .58722 .60309 L p .975 .805 .61 r
F P
0 g
s
.55771 .57636 m .58722 .60309 L .57579 .61565 L p .863 .873 .844 r
F P
0 g
s
.57579 .61565 m .54595 .58927 L .55771 .57636 L p .863 .873 .844 r
F P
0 g
s
.58722 .60309 m .55771 .57636 L .56073 .56002 L p .975 .805 .61 r
F P
0 g
s
.50033 .53577 m .45269 .49213 L .43959 .5021 L p .649 .414 .549 r
F P
0 g
s
.45269 .49213 m .50033 .53577 L .50925 .52164 L p .544 .421 .663 r
F P
0 g
s
.50925 .52164 m .46136 .47817 L .45269 .49213 L p .544 .421 .663 r
F P
0 g
s
.48707 .54601 m .43959 .5021 L .42692 .50436 L p .746 .368 .338 r
F P
0 g
s
.43959 .5021 m .48707 .54601 L .50033 .53577 L p .649 .414 .549 r
F P
0 g
s
.46136 .47817 m .50925 .52164 L .51049 .5089 L p .342 .397 .773 r
F P
0 g
s
.51049 .5089 m .46234 .46543 L .46136 .47817 L p .342 .397 .773 r
F P
0 g
s
.47442 .54853 m .42692 .50436 L .4195 .49792 L p .516 0 0 r
F P
0 g
s
.42692 .50436 m .47442 .54853 L .48707 .54601 L p .746 .368 .338 r
F P
0 g
s
.46234 .46543 m .51049 .5089 L .50346 .50238 L p 0 .051 .538 r
F P
0 g
s
.50346 .50238 m .45514 .45875 L .46234 .46543 L p 0 .051 .538 r
F P
0 g
s
.4195 .49792 m .46717 .54226 L .47442 .54853 L p .516 0 0 r
F P
0 g
s
.46717 .54226 m .4195 .49792 L .42027 .48514 L p .325 .387 .772 r
F P
0 g
s
.45514 .45875 m .50346 .50238 L .49074 .5047 L p .744 .358 .321 r
F P
0 g
s
.49074 .5047 m .4424 .46081 L .45514 .45875 L p .744 .358 .321 r
F P
0 g
s
.4682 .52948 m .42027 .48514 L .42903 .47091 L p .539 .416 .662 r
F P
0 g
s
.42027 .48514 m .4682 .52948 L .46717 .54226 L p .325 .387 .772 r
F P
0 g
s
.4424 .46081 m .49074 .5047 L .47722 .51507 L p .647 .409 .544 r
F P
0 g
s
.47722 .51507 m .42903 .47091 L .4424 .46081 L p .647 .409 .544 r
F P
0 g
s
.42903 .47091 m .47722 .51507 L .4682 .52948 L p .539 .416 .662 r
F P
0 g
s
.38098 .66345 m .35065 .69677 L .36801 .71136 L p .762 .667 .758 r
F P
0 g
s
.36801 .71136 m .39822 .67817 L .38098 .66345 L p .762 .667 .758 r
F P
0 g
s
.39822 .67817 m .36801 .71136 L .38505 .72767 L p .666 .515 .671 r
F P
0 g
s
.38505 .72767 m .41534 .6944 L .39822 .67817 L p .666 .515 .671 r
F P
0 g
s
.46061 .57595 m .39235 .65095 L .40955 .66572 L p .762 .667 .758 r
F P
0 g
s
.40955 .66572 m .47755 .59101 L .46061 .57595 L p .762 .667 .758 r
F P
0 g
s
.47755 .59101 m .40955 .66572 L .4267 .68192 L p .666 .515 .671 r
F P
0 g
s
.4267 .68192 m .49488 .60702 L .47755 .59101 L p .666 .515 .671 r
F P
0 g
s
.41534 .6944 m .38505 .72767 L .39549 .73973 L p .496 .278 .512 r
F P
0 g
s
.39549 .73973 m .42603 .70619 L .41534 .6944 L p .496 .278 .512 r
F P
0 g
s
.49488 .60702 m .4267 .68192 L .43748 .6936 L p .496 .278 .512 r
F P
0 g
s
.43748 .6936 m .50622 .6181 L .49488 .60702 L p .496 .278 .512 r
F P
0 g
s
.36996 .65568 m .33936 .6893 L .35065 .69677 L p .859 .863 .841 r
F P
0 g
s
.35065 .69677 m .38098 .66345 L .36996 .65568 L p .859 .863 .841 r
F P
0 g
s
.4503 .56739 m .38143 .64307 L .39235 .65095 L p .859 .863 .841 r
F P
0 g
s
.39235 .65095 m .46061 .57595 L .4503 .56739 L p .859 .863 .841 r
F P
0 g
s
.51604 .56364 m .51739 .55656 L .52249 .55096 L p .6 .42 .61 r
F P
0 g
s
.50641 .55068 m .51739 .55656 L .51604 .56364 L p .763 .576 .646 r
F P
0 g
s
.51739 .55656 m .50641 .55068 L .51559 .54059 L p .726 .609 .726 r
F P
0 g
s
.51559 .54059 m .52249 .55096 L .51739 .55656 L p .726 .609 .726 r
F P
0 g
s
.52249 .55096 m .52939 .54897 L p .51604 .56364 L .6 .42 .61 r
F P
0 g
s
.52249 .55096 m .51559 .54059 L .52804 .53698 L p .65 .585 .769 r
F P
0 g
s
.52804 .53698 m .52939 .54897 L .52249 .55096 L p .65 .585 .769 r
F P
0 g
s
.51604 .56364 m .50395 .56344 L .50641 .55068 L p .763 .576 .646 r
F P
0 g
s
.49747 .54491 m .50641 .55068 L .50395 .56344 L p .858 .674 .652 r
F P
0 g
s
.50641 .55068 m .49747 .54491 L .50896 .53229 L p .792 .719 .784 r
F P
0 g
s
.50896 .53229 m .51559 .54059 L .50641 .55068 L p .792 .719 .784 r
F P
0 g
s
.51559 .54059 m .50896 .53229 L .52452 .52775 L p .666 .69 .863 r
F P
0 g
s
.52452 .52775 m .52804 .53698 L .51559 .54059 L p .666 .69 .863 r
F P
0 g
s
.52505 .57193 m .51896 .56951 L .51604 .56364 L p .6 .42 .61 r
F P
0 g
s
.53198 .56995 m .52505 .57193 L p .51604 .56364 L .6 .42 .61 r
F P
0 g
s
.5371 .56433 m .53198 .56995 L p .51604 .56364 L .6 .42 .61 r
F P
0 g
s
.01 w
.53462 .56705 m
.55201 .58262 L
s
.5 Mabswid
.53844 .55722 m .5371 .56433 L p .51604 .56364 L .6 .42 .61 r
F P
0 g
s
.53549 .55135 m .53844 .55722 L p .51604 .56364 L .6 .42 .61 r
F P
0 g
s
.52939 .54897 m .53549 .55135 L p .51604 .56364 L .6 .42 .61 r
F P
0 g
s
.50395 .56344 m .51604 .56364 L .51896 .56951 L p .746 .478 .524 r
F P
0 g
s
.52939 .54897 m .52804 .53698 L .53905 .54124 L p .527 .494 .763 r
F P
0 g
s
.53905 .54124 m .53549 .55135 L .52939 .54897 L p .527 .494 .763 r
F P
0 g
s
.51896 .56951 m .50918 .57405 L .50395 .56344 L p .746 .478 .524 r
F P
0 g
s
.49438 .56086 m .50395 .56344 L .50918 .57405 L p .848 .507 .407 r
F P
0 g
s
.50395 .56344 m .49438 .56086 L .49747 .54491 L p .858 .674 .652 r
F P
0 g
s
.52804 .53698 m .52452 .52775 L .53829 .53306 L p .421 .539 .87 r
F P
0 g
s
.53829 .53306 m .53905 .54124 L .52804 .53698 L p .421 .539 .87 r
F P
0 g
s
.50918 .57405 m .51896 .56951 L .52505 .57193 L p .64 .287 .358 r
F P
0 g
s
.53549 .55135 m .53905 .54124 L .5444 .55182 L p .353 .307 .667 r
F P
0 g
s
.5444 .55182 m .53844 .55722 L .53549 .55135 L p .353 .307 .667 r
F P
0 g
s
.49234 .54036 m .49747 .54491 L .49438 .56086 L p .969 .8 .619 r
F P
0 g
s
.49747 .54491 m .49234 .54036 L .50388 .52768 L p .86 .864 .842 r
F P
0 g
s
.02 w
.47737 .51496 m
.49631 .53232 L
s
.5 Mabswid
.50388 .52768 m .50896 .53229 L .49747 .54491 L p .86 .864 .842 r
F P
0 g
s
.02 w
.49631 .53232 m
.49813 .53399 L
s
.5 Mabswid
.50896 .53229 m .50388 .52768 L .5195 .52311 L p .649 .827 .968 r
F P
0 g
s
.5195 .52311 m .52452 .52775 L .50896 .53229 L p .649 .827 .968 r
F P
0 g
s
.28751 .80193 m .29478 .80908 L .36336 .72021 L closepath p .643 .515 .692 r
F P
0 g
s
.27988 .79578 m .28751 .80193 L .36336 .72021 L closepath p .741 .671 .782 r
F P
0 g
s
.52017 .57845 m .52505 .57193 L .53198 .56995 L p .409 .026 .198 r
F P
0 g
s
.52505 .57193 m .52017 .57845 L .50918 .57405 L p .64 .287 .358 r
F P
0 g
s
.53844 .55722 m .5444 .55182 L .54199 .56469 L p .178 .04 .443 r
F P
0 g
s
.54199 .56469 m .5371 .56433 L .53844 .55722 L p .178 .04 .443 r
F P
0 g
s
.61176 .44568 m .60467 .43893 L .53629 .53022 L closepath p .783 .666 .734 r
F P
0 g
s
.6194 .45244 m .61176 .44568 L .53629 .53022 L closepath p .685 .512 .647 r
F P
0 g
s
.29478 .80908 m .29895 .81455 L .36336 .72021 L closepath p .453 .265 .534 r
F P
0 g
s
.42603 .70619 m .39549 .73973 L .39528 .74291 L p 0 0 0 r
F P
0 g
s
.39528 .74291 m .42615 .709 L .42603 .70619 L p 0 0 0 r
F P
0 g
s
.50622 .6181 m .43748 .6936 L .43772 .69629 L p 0 0 0 r
F P
0 g
s
.53272 .57488 m .53198 .56995 L .5371 .56433 L p .179 0 .211 r
F P
0 g
s
.02 w
.54379 .57582 m
.55017 .58168 L
s
.5 Mabswid
.53198 .56995 m .53272 .57488 L .52017 .57845 L p .409 .026 .198 r
F P
0 g
s
.5371 .56433 m .54199 .56469 L .53272 .57488 L p .179 0 .211 r
F P
0 g
s
.50918 .57405 m .50089 .57414 L .49438 .56086 L p .848 .507 .407 r
F P
0 g
s
.50089 .57414 m .50918 .57405 L .52017 .57845 L p .564 .014 0 r
F P
0 g
s
.43772 .69629 m .50719 .61998 L .50622 .6181 L p 0 0 0 r
F P
0 g
s
.27476 .79295 m .27988 .79578 L .36336 .72021 L closepath p .826 .874 .88 r
F P
0 g
s
.53905 .54124 m .53829 .53306 L .545 .54628 L p 0 .054 .607 r
F P
0 g
s
.545 .54628 m .5444 .55182 L .53905 .54124 L p 0 .054 .607 r
F P
0 g
s
.48922 .55638 m .49438 .56086 L .50089 .57414 L p .881 .458 .053 r
F P
0 g
s
.49438 .56086 m .48922 .55638 L .49234 .54036 L p .969 .8 .619 r
F P
0 g
s
.52452 .52775 m .5195 .52311 L .53331 .52843 L p .082 .511 .902 r
F P
0 g
s
.53331 .52843 m .53829 .53306 L .52452 .52775 L p .082 .511 .902 r
F P
0 g
s
.62472 .45666 m .6194 .45244 L .53629 .53022 L closepath p .518 .267 .473 r
F P
0 g
s
.60467 .43893 m .60079 .43473 L .53629 .53022 L closepath p .893 .864 .804 r
F P
0 g
s
.36947 .65796 m .33855 .69194 L .33936 .6893 L p 0 0 0 r
F P
0 g
s
.33936 .6893 m .36996 .65568 L .36947 .65796 L p 0 0 0 r
F P
0 g
s
.45068 .56873 m .38107 .64522 L .38143 .64307 L p 0 0 0 r
F P
0 g
s
.38143 .64307 m .4503 .56739 L .45068 .56873 L p 0 0 0 r
F P
0 g
s
.49206 .53795 m .49234 .54036 L .48922 .55638 L p .816 .764 .252 r
F P
0 g
s
.49234 .54036 m .49206 .53795 L .50136 .52773 L p .783 .987 .742 r
F P
0 g
s
.50136 .52773 m .50388 .52768 L .49234 .54036 L p .783 .987 .742 r
F P
0 g
s
.50388 .52768 m .50136 .52773 L .51394 .52404 L p .303 .796 .791 r
F P
0 g
s
.51394 .52404 m .5195 .52311 L .50388 .52768 L p .303 .796 .791 r
F P
0 g
s
.29895 .81455 m .29842 .81624 L .36336 .72021 L closepath p 0 0 0 r
F P
0 g
s
.52017 .57845 m .51463 .57965 L .50089 .57414 L p .564 .014 0 r
F P
0 g
s
.51463 .57965 m .52017 .57845 L .53272 .57488 L p .251 .759 .744 r
F P
0 g
s
.5444 .55182 m .545 .54628 L .54198 .5624 L p .77 .728 .2 r
F P
0 g
s
.54198 .5624 m .54199 .56469 L .5444 .55182 L p .77 .728 .2 r
F P
0 g
s
.27412 .79455 m .27476 .79295 L .36336 .72021 L closepath p 0 0 0 r
F P
0 g
s
.62568 .45673 m .62472 .45666 L .53629 .53022 L closepath p 0 0 0 r
F P
0 g
s
.50089 .57414 m .49574 .5697 L .48922 .55638 L p .881 .458 .053 r
F P
0 g
s
.49574 .5697 m .50089 .57414 L .51463 .57965 L p .036 .487 .883 r
F P
0 g
s
.53829 .53306 m .53331 .52843 L .54003 .5417 L p .863 .434 .007 r
F P
0 g
s
.54003 .5417 m .545 .54628 L .53829 .53306 L p .863 .434 .007 r
F P
0 g
s
.53035 .57518 m .53272 .57488 L .54199 .56469 L p .755 .975 .713 r
F P
0 g
s
.53272 .57488 m .53035 .57518 L .51463 .57965 L p .251 .759 .744 r
F P
0 g
s
.54199 .56469 m .54198 .5624 L .53035 .57518 L p .755 .975 .713 r
F P
0 g
s
.48922 .55638 m .48954 .55085 L .49206 .53795 L p .816 .764 .252 r
F P
0 g
s
.48954 .55085 m .48922 .55638 L .49574 .5697 L p 0 .018 .582 r
F P
0 g
s
.60079 .43473 m .60164 .43469 L .53629 .53022 L closepath p 0 0 0 r
F P
0 g
s
.5195 .52311 m .51394 .52404 L .52505 .52833 L p .539 0 0 r
F P
0 g
s
.52505 .52833 m .53331 .52843 L .5195 .52311 L p .539 0 0 r
F P
0 g
s
.03 w
.49886 .57134 m
.53496 .53168 L
s
.49627 .57419 m
.49833 .57193 L
s
.48341 .58831 m
.49627 .57419 L
s
.45792 .61633 m
.48341 .58831 L
s
.5 Mabswid
.27826 .80002 m .27412 .79455 L .36336 .72021 L closepath p .523 .274 .479 r
F P
0 g
s
.28562 .80727 m .27826 .80002 L .36336 .72021 L closepath p .685 .513 .648 r
F P
0 g
s
.29334 .81348 m .28562 .80727 L .36336 .72021 L closepath p .782 .665 .734 r
F P
0 g
s
.29842 .81624 m .29334 .81348 L .36336 .72021 L closepath p .891 .858 .803 r
F P
0 g
s
.03 w
.36336 .72021 m
.45792 .61633 L
s
.5 Mabswid
.60164 .43469 m .60694 .43889 L .53629 .53022 L closepath p .46 .272 .539 r
F P
0 g
s
.62185 .45256 m .62568 .45673 L .53629 .53022 L closepath p .825 .868 .878 r
F P
0 g
s
.61468 .44573 m .62185 .45256 L .53629 .53022 L closepath p .74 .67 .781 r
F P
0 g
s
.60694 .43889 m .61468 .44573 L .53629 .53022 L closepath p .644 .516 .692 r
F P
0 g
s
.03 w
.53581 .53075 m
.53629 .53022 L
s
.5 Mabswid
.50952 .57522 m .51463 .57965 L .53035 .57518 L p .642 .832 .974 r
F P
0 g
s
.51463 .57965 m .50952 .57522 L .49574 .5697 L p .036 .487 .883 r
F P
0 g
s
.545 .54628 m .54003 .5417 L .53699 .55788 L p .975 .805 .61 r
F P
0 g
s
.53699 .55788 m .54198 .5624 L .545 .54628 L p .975 .805 .61 r
F P
0 g
s
.49676 .53818 m .49206 .53795 L .48954 .55085 L p .149 .011 .424 r
F P
0 g
s
.49206 .53795 m .49676 .53818 L .50195 .53248 L p .146 0 .179 r
F P
0 g
s
.50195 .53248 m .50136 .52773 L .49206 .53795 L p .146 0 .179 r
F P
0 g
s
.50136 .52773 m .50195 .53248 L .50896 .53043 L p .389 0 .17 r
F P
0 g
s
.50896 .53043 m .51394 .52404 L .50136 .52773 L p .389 0 .17 r
F P
0 g
s
.49574 .5697 m .4948 .56157 L .48954 .55085 L p 0 .018 .582 r
F P
0 g
s
.4948 .56157 m .49574 .5697 L .50952 .57522 L p .408 .535 .873 r
F P
0 g
s
.53331 .52843 m .52505 .52833 L .53043 .539 L p .851 .502 .393 r
F P
0 g
s
.53043 .539 m .54003 .5417 L .53331 .52843 L p .851 .502 .393 r
F P
0 g
s
.63874 .66258 m .56416 .59425 L .55072 .60485 L p .649 .414 .549 r
F P
0 g
s
.56416 .59425 m .63874 .66258 L .64841 .64799 L p .544 .421 .663 r
F P
0 g
s
.64841 .64799 m .57342 .57991 L .56416 .59425 L p .544 .421 .663 r
F P
0 g
s
.49536 .54537 m .48954 .55085 L .4948 .56157 L p .338 .295 .663 r
F P
0 g
s
.48954 .55085 m .49536 .54537 L .49676 .53818 L p .149 .011 .424 r
F P
0 g
s
.51394 .52404 m .50896 .53043 L .51514 .53283 L p .635 .275 .343 r
F P
0 g
s
.51514 .53283 m .52505 .52833 L .51394 .52404 L p .635 .275 .343 r
F P
0 g
s
.42615 .709 m .39528 .74291 L .3842 .73573 L p .863 .874 .844 r
F P
0 g
s
.52531 .57071 m .53035 .57518 L .54198 .5624 L p .863 .872 .844 r
F P
0 g
s
.02 w
.53989 .57225 m
.54379 .57582 L
s
.5 Mabswid
.53035 .57518 m .52531 .57071 L .50952 .57522 L p .642 .832 .974 r
F P
0 g
s
.54198 .5624 m .53699 .55788 L .52531 .57071 L p .863 .872 .844 r
F P
0 g
s
.02 w
.5355 .56823 m
.53989 .57225 L
s
.50067 .53632 m
.53118 .56427 L
s
.53366 .56655 m
.5355 .56823 L
s
.5 Mabswid
.3842 .73573 m .41534 .70151 L .42615 .709 L p .863 .874 .844 r
F P
0 g
s
.50719 .61998 m .43772 .69629 L .42702 .68868 L p .863 .874 .844 r
F P
0 g
s
.42702 .68868 m .49712 .61167 L .50719 .61998 L p .863 .874 .844 r
F P
0 g
s
.62508 .67361 m .55072 .60485 L .53809 .60774 L p .746 .368 .338 r
F P
0 g
s
.55072 .60485 m .62508 .67361 L .63874 .66258 L p .649 .414 .549 r
F P
0 g
s
.57342 .57991 m .64841 .64799 L .65047 .63527 L p .342 .397 .773 r
F P
0 g
s
.65047 .63527 m .57503 .56717 L .57342 .57991 L p .342 .397 .773 r
F P
0 g
s
.38001 .6697 m .34883 .70396 L .33855 .69194 L p .484 .262 .501 r
F P
0 g
s
.33855 .69194 m .36947 .65796 L .38001 .6697 L p .484 .262 .501 r
F P
0 g
s
.52148 .87302 m .39132 .73848 L .42831 .71568 L p .682 .413 .508 r
F P
0 g
s
.42831 .71568 m .5592 .84792 L .52148 .87302 L p .682 .413 .508 r
F P
0 g
s
.46189 .57973 m .39171 .65685 L .38107 .64522 L p .484 .262 .501 r
F P
0 g
s
.38107 .64522 m .45068 .56873 L .46189 .57973 L p .484 .262 .501 r
F P
0 g
s
.50588 .56598 m .50952 .57522 L .52531 .57071 L p .664 .692 .866 r
F P
0 g
s
.50952 .57522 m .50588 .56598 L .4948 .56157 L p .408 .535 .873 r
F P
0 g
s
.54003 .5417 m .53043 .539 L .52797 .55202 L p .862 .676 .649 r
F P
0 g
s
.52797 .55202 m .53699 .55788 L .54003 .5417 L p .862 .676 .649 r
F P
0 g
s
.4948 .56157 m .4983 .55133 L .49536 .54537 L p .338 .295 .663 r
F P
0 g
s
.4983 .55133 m .4948 .56157 L .50588 .56598 L p .521 .491 .763 r
F P
0 g
s
.52505 .52833 m .51514 .53283 L .51811 .53877 L p .747 .474 .518 r
F P
0 g
s
.51811 .53877 m .53043 .539 L .52505 .52833 L p .747 .474 .518 r
F P
0 g
s
.49676 .53818 m .49536 .54537 L .4983 .55133 L p .597 .415 .607 r
F P
0 g
s
.50195 .53248 m .49676 .53818 L p .4983 .55133 L .597 .415 .607 r
F P
0 g
s
.50896 .53043 m .50195 .53248 L p .4983 .55133 L .597 .415 .607 r
F P
0 g
s
.55306 .75621 m .46085 .66593 L .49367 .64593 L p .681 .408 .502 r
F P
0 g
s
.49367 .64593 m .5863 .73482 L .55306 .75621 L p .681 .408 .502 r
F P
0 g
s
.51514 .53283 m .50896 .53043 L p .4983 .55133 L .597 .415 .607 r
F P
0 g
s
.51857 .56234 m .52531 .57071 L .53699 .55788 L p .793 .723 .786 r
F P
0 g
s
.52531 .57071 m .51857 .56234 L .50588 .56598 L p .664 .692 .866 r
F P
0 g
s
.53699 .55788 m .52797 .55202 L .51857 .56234 L p .793 .723 .786 r
F P
0 g
s
.51811 .53877 m .51514 .53283 L p .4983 .55133 L .597 .415 .607 r
F P
0 g
s
.01 w
.50928 .54437 m
.52341 .55702 L
s
.5 Mabswid
.51673 .54599 m .51811 .53877 L p .4983 .55133 L .597 .415 .607 r
F P
0 g
s
.01 w
.50269 .53847 m
.50557 .54105 L
s
.50557 .54105 m
.50672 .54208 L
s
.5 Mabswid
.51151 .55173 m .51673 .54599 L p .4983 .55133 L .597 .415 .607 r
F P
0 g
s
.4983 .55133 m .50446 .55376 L .51151 .55173 L p .597 .415 .607 r
F P
0 g
s
.50588 .56598 m .50446 .55376 L .4983 .55133 L p .521 .491 .763 r
F P
0 g
s
.50446 .55376 m .50588 .56598 L .51857 .56234 L p .648 .585 .771 r
F P
0 g
s
.53043 .539 m .51811 .53877 L .51673 .54599 L p .764 .576 .644 r
F P
0 g
s
.51673 .54599 m .52797 .55202 L .53043 .539 L p .764 .576 .644 r
F P
0 g
s
.61251 .67694 m .53809 .60774 L .53108 .60171 L p .516 0 0 r
F P
0 g
s
.53809 .60774 m .61251 .67694 L .62508 .67361 L p .746 .368 .338 r
F P
0 g
s
.57503 .56717 m .65047 .63527 L .64402 .62926 L p 0 .051 .538 r
F P
0 g
s
.64402 .62926 m .56826 .56087 L .57503 .56717 L p 0 .051 .538 r
F P
0 g
s
.43766 .51239 m .47228 .54243 L .47557 .5258 L p .969 .8 .619 r
F P
0 g
s
.47557 .5258 m .44113 .49533 L .43766 .51239 L p .969 .8 .619 r
F P
0 g
s
.44113 .49533 m .47557 .5258 L .48757 .51261 L p .86 .864 .842 r
F P
0 g
s
.48757 .51261 m .4535 .48174 L .44113 .49533 L p .86 .864 .842 r
F P
0 g
s
.4535 .48174 m .48757 .51261 L .50378 .50782 L p .649 .827 .968 r
F P
0 g
s
.51857 .56234 m .51151 .55173 L .50446 .55376 L p .648 .585 .771 r
F P
0 g
s
.51151 .55173 m .51857 .56234 L .52797 .55202 L p .727 .61 .726 r
F P
0 g
s
.52797 .55202 m .51673 .54599 L .51151 .55173 L p .727 .61 .726 r
F P
0 g
s
.44445 .52651 m .479 .55624 L .47228 .54243 L p .881 .458 .054 r
F P
0 g
s
.47228 .54243 m .43766 .51239 L .44445 .52651 L p .881 .458 .054 r
F P
0 g
s
.41534 .70151 m .3842 .73573 L .36636 .72078 L p .763 .67 .759 r
F P
0 g
s
.50378 .50782 m .47012 .47672 L .4535 .48174 L p .649 .827 .968 r
F P
0 g
s
.47012 .47672 m .50378 .50782 L .5181 .51329 L p .083 .511 .902 r
F P
0 g
s
.36636 .72078 m .39763 .68643 L .41534 .70151 L p .763 .67 .759 r
F P
0 g
s
.49712 .61167 m .42702 .68868 L .40936 .67355 L p .763 .67 .759 r
F P
0 g
s
.40936 .67355 m .47973 .59622 L .49712 .61167 L p .763 .67 .759 r
F P
0 g
s
.39763 .68643 m .36636 .72078 L .34883 .70396 L p .664 .513 .669 r
F P
0 g
s
.34883 .70396 m .38001 .6697 L .39763 .68643 L p .664 .513 .669 r
F P
0 g
s
.47973 .59622 m .40936 .67355 L .39171 .65685 L p .664 .513 .669 r
F P
0 g
s
.39171 .65685 m .46189 .57973 L .47973 .59622 L p .664 .513 .669 r
F P
0 g
s
.53108 .60171 m .60581 .67121 L .61251 .67694 L p .516 0 0 r
F P
0 g
s
.60581 .67121 m .53108 .60171 L .53248 .58893 L p .325 .387 .772 r
F P
0 g
s
.56826 .56087 m .64402 .62926 L .6314 .63239 L p .744 .358 .321 r
F P
0 g
s
.6314 .63239 m .55558 .56356 L .56826 .56087 L p .744 .358 .321 r
F P
0 g
s
.45902 .53224 m .49328 .56193 L .479 .55624 L p .035 .487 .882 r
F P
0 g
s
.479 .55624 m .44445 .52651 L .45902 .53224 L p .035 .487 .882 r
F P
0 g
s
.5181 .51329 m .48474 .48223 L .47012 .47672 L p .083 .511 .902 r
F P
0 g
s
.48474 .48223 m .5181 .51329 L .52503 .52704 L p .863 .433 .006 r
F P
0 g
s
.50967 .55721 m .49328 .56193 L p .48059 .53675 L .642 .832 .974 r
F P
0 g
s
.48386 .5344 m .50967 .55721 L p .48059 .53675 L .642 .832 .974 r
F P
0 g
s
.49328 .56193 m .45902 .53224 L .47583 .5273 L p .642 .832 .974 r
F P
0 g
s
.50967 .55721 m .47583 .5273 L .48836 .51353 L p .863 .873 .844 r
F P
0 g
s
.50948 .58284 m .47579 .54718 L .49418 .52697 L p 0 0 .002 r
F P
0 g
s
.49175 .49628 m .52503 .52704 L .52183 .54385 L p .975 .805 .61 r
F P
0 g
s
.48836 .51353 m .52183 .54385 L .50967 .55721 L p .863 .873 .844 r
F P
0 g
s
.52183 .54385 m .48836 .51353 L .49175 .49628 L p .975 .805 .61 r
F P
0 g
s
.49418 .52697 m .50818 .51159 L p .50827 .51683 L 0 0 .002 r
F P
0 g
s
.50827 .51683 m .50948 .58284 L .49418 .52697 L 0 0 .002 r
F
.47583 .5273 m .48386 .5344 L p .48059 .53675 L .642 .832 .974 r
F P
0 g
s
.01 w
.46957 .50883 m
.48229 .52021 L
s
.5 Mabswid
.52503 .52704 m .49175 .49628 L .48474 .48223 L p .863 .433 .006 r
F P
0 g
s
.60765 .65846 m .53248 .58893 L .54186 .5743 L p .539 .416 .662 r
F P
0 g
s
.53248 .58893 m .60765 .65846 L .60581 .67121 L p .325 .387 .772 r
F P
0 g
s
.55558 .56356 m .6314 .63239 L .61745 .64358 L p .647 .409 .544 r
F P
0 g
s
.02 w
.6176 .64346 m
.66732 .68902 L
s
.5 Mabswid
.61745 .64358 m .54186 .5743 L .55558 .56356 L p .647 .409 .544 r
F P
0 g
s
.54186 .5743 m .61745 .64358 L .60765 .65846 L p .539 .416 .662 r
F P
0 g
s
.30409 .32578 m .46212 .46993 L .43029 .50491 L p .74 .632 .739 r
F P
0 g
s
.43029 .50491 m .27162 .3615 L .30409 .32578 L p .74 .632 .739 r
F P
0 g
s
.50818 .51159 m .54512 .54369 L .50948 .58284 L p 0 0 .002 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00E`3oool00`000000oooo0?ooo`360?ooo`00EP3o
ool00`000000_J6m000000370?ooo`00E@3oool01@000000_J6m0;fQ_@2mXKd000000<H0oooo001D
0?ooo`030000002mXKd0_J6m00<0_J6m00<000000?ooo`3oool0``3oool005<0oooo00<000000;fQ
_@2mXKd01@2mXKd00`000000oooo0?ooo`320?ooo`00DP3oool00`000000_J6m0;fQ_@070;fQ_@80
0000`P3oool00540oooo00<000000;fQ_@2mXKd02P2mXKd00`000000oooo0?ooo`2o0?ooo`00D03o
ool00`000000_J6m0;fQ_@0<0;fQ_@030000003oool0oooo0;h0oooo001?0?ooo`030000002mXKd0
_J6m00h0_J6m00<000000?ooo`3oool0_@3oool004h0oooo00<000000;fQ_@2mXKd0402mXKd00`00
0000oooo0?ooo`2l0?ooo`00C@3oool00`000000_J6m0;fQ_@0B0;fQ_@030000003oool0oooo0;/0
oooo001>0?ooo`030000002mXKd0_J6m0180_J6m00<000000?ooo`3oool0^P3oool004l0oooo00<0
00000;fQ_@2mXKd04P2mXKd00`000000oooo0?ooo`2i0?ooo`00D03oool00`000000_J6m0;fQ_@0B
0;fQ_@030000003oool0oooo0;P0oooo001A0?ooo`8000004`2mXKd00`000000oooo0?ooo`2g0?oo
o`00D`3oool00`000000_J6m0;fQ_@0A0;fQ_@800000]`3oool005@0oooo00<000000;fQ_@2mXKd0
4P2mXKd00`000000oooo0?ooo`2d0?ooo`00E@3oool00`000000_J6m0;fQ_@0B0;fQ_@030000003o
ool0oooo0;<0oooo001F0?ooo`030000002mXKd0_J6m0180_J6m00<000000?ooo`3oool0/P3oool0
05L0oooo00<000000;fQ_@2mXKd04P2mXKd00`000000oooo0?ooo`2a0?ooo`00F03oool00`000000
_J6m0;fQ_@0B0;fQ_@030000003oool0oooo0;00oooo001I0?ooo`030000002mXKd0_J6m0180_J6m
00<000000?ooo`3oool0[`3oool005X0oooo0P00000C0;fQ_@030000003oool0oooo0:h0oooo001L
0?ooo`030000002mXKd0_J6m0140_J6m00<000000?ooo`3oool0[@3oool005d0oooo00<000000;fQ
_@2mXKd04@2mXKd00`000000oooo0?ooo`2/0?ooo`00GP3oool00`000000_J6m0;fQ_@0A0;fQ_@03
0000003oool0oooo0:/0oooo001O0?ooo`030000002mXKd0_J6m0140_J6m0P00002[0?ooo`00H03o
ool00`000000_J6m0;fQ_@0B0;fQ_@030000003oool0oooo0:P0oooo001Q0?ooo`030000002mXKd0
_J6m0180_J6m00<000000?ooo`3oool0Y`3oool00680oooo00<000000;fQ_@2mXKd04P2mXKd00`00
0000oooo0?ooo`2V0?ooo`00H`3oool00`000000_J6m0;fQ_@0B0;fQ_@030000003oool0oooo0:D0
oooo001T0?ooo`8000004`2mXKd00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0740oooo
001V0?ooo`030000002mXKd0_J6m0140_J6m00<000000?ooo`3oool0;P3oool010000000MDF90000
0000001a0?ooo`00I`3oool00`000000_J6m0;fQ_@0A0;fQ_@030000003oool0oooo02d0oooo00D0
000007E5R@000000Y8Ba0000001`0?ooo`00J03oool00`000000_J6m0;fQ_@0A0;fQ_@030000003o
ool0oooo02/0oooo00<0000007E5R@0000000`2TQ;400`000000oooo0?ooo`1]0?ooo`00J@3oool0
0`000000_J6m0;fQ_@0A0;fQ_@030000003oool0oooo02T0oooo00@0000007E5R@1eAHT000000P2T
Q;400`000000_J_70000001^0?ooo`00JP3oool00`000000_J6m0;fQ_@0A0;fQ_@800000:@3oool0
0`000000MDF9000000020:B4/@050000002mZlL0_J_70;f[a`000000K@3oool006/0oooo00<00000
0;fQ_@2mXKd04P2mXKd00`000000oooo0?ooo`0U0?ooo`030000001eAHT000000080Y8Ba00@00000
0;f[a`2mZlL0_J_70P00001]0?ooo`00K03oool00`000000_J6m0;fQ_@0B0;fQ_@800000903oool0
0`000000MDF9000000020:B4/@050000002mZlL0_J_70;f[a`0000000P3Cg^000`000000oooo0?oo
o`1Z0?ooo`00K@3oool2000001<0_J6m0P00000S0?ooo`050000001eAHT000000:B4/@0000000`2m
ZlL010000000dmkP0=?Nh000001]0?ooo`00K`3oool00`000000_J6m0;fQ_@0A0;fQ_@8000008@3o
ool01@000000MDF90000002TQ;40000000<0_J_700@000000=?Nh00000000000KP3oool00700oooo
00<000000;fQ_@2mXKd04@2mXKd2000001l0oooo00<0000007E5R@0000000P2TQ;401P000000_J_7
0;f[a`000000dmkP00000700oooo001a0?ooo`030000002mXKd0_J6m00l0_J6m00@000000;iKDP2n
Fe8000007P3oool200000080Y8Ba00H000000;f[a`00000000000=?Nh000001a0?ooo`00LP3oool0
0`000000_J6m0;fQ_@0=0;fQ_@80000000@0_U]B0000000000000000703oool200000080Y8Ba00<0
00000;f[a`0000000P3Cg^000`000000oooo0?ooo`1`0?ooo`00L`3oool00`000000_J6m0;fQ_@0;
0;fQ_@040000002UJ8/0000000000080Y]?g0`00000I0?ooo`080000001eAHT000000:B4/@000000
_J_70000003Cg^02000007<0oooo001d0?ooo`030000002mXKd0_J6m00T0_J6m00<000000:EXR`00
00001@2VdoL0100000005H;V00000000000G0?ooo`80000000H0Y8Ba0000002mZlL000000=?Nh000
001e0?ooo`00M@3oool00`000000_J6m0;fQ_@080;fQ_@80000000<0g=gG0000002VdoL0102VdoL0
100000005H;V00000000000E0?ooo`80000000H0Y8Ba0000002mZlL000000=?Nh000001f0?ooo`00
MP3oool2000000L0_J6m0P0000030=cMe`030000002VdoL0Y]?g00<0Y]?g00@0000001F2iP000000
00004`3oool2000000060:B4/@000000_J_70000003Cg^000000M`3oool007P0oooo00<000000;fQ
_@2mXKd00`2mXKd2000000D0g=gG00<000000:KCm`2VdoL00`2VdoL2000000030=a^0@000000oooo
0100oooo00D0000007E5R@00000000000;f[a`03000007P0oooo001h0?ooo`8000000`2mXKd20000
00L0g=gG00<000000:KCm`2VdoL0102VdoL00`000000g6h10000000@0?ooo`<0000000<0_J_70000
00000000NP3oool007T0oooo0P0000000`2mXKd0000000000002000000L0g=gG00<000000:KCm`2V
doL00`2VdoL2000000030=a^0@000000oooo00d0oooo0`0000000`2mZlL000000000001k0?ooo`00
NP3oool200000080Df?500@000000?S<WP00000000001P3LgML00`000000Y]?g0:KCm`020:KCm`05
0000003icY`000000=a^0@000000303oool3000000030;f[a`000000000007`0oooo001k0?ooo`03
0000001CHlD0000000@0n<bN00D000000=cMe`3LgML0g=gG000000020=cMe`040000002VdoL0Y]?g
000000<0nLjL00<000000=a^0@0000002`3oool2000000030;f[a`000000000007d0oooo001T0?oo
o`8000005P3oool2000000D0n<bN00<000000=cMe`0000000P0000020=cMe`030000002VdoL00000
00@0nLjL00<000000=a^0@0000002@3oool5000007h0oooo001R0?ooo`8000000P2^J8000`000000
oooo0?ooo`0D0?ooo`030000003hc9h0n<bN00@0n<bN00<000000=cMe`0000000P0000020=cMe`80
00000`3icY`01@000000nLjL0000003LKP40000000@0oooo00<000000?ooo`3oool0100000200?oo
o`00H03oool2000000D0[VR000<000000?ooo`3oool04`3oool2000000H0n<bN1`0000000`3LgmP0
00000?W>W002000000040?W>W00000000000000000<0oooo0`000000103oool00000000000000021
0?ooo`00GP3oool2000000P0[VR000<000000?ooo`3oool04`3oool3000000H0n<bN00<000000=cM
e`0000000P0000020=cOf1000000PP3oool005`0oooo0P00000;0:iXP0030000003oool0oooo0180
oooo00@000000>5e3@3QM@d000001P3hc9h3000000<0g=oH3`0000230?ooo`00F`3oool00`000000
[VR00:iXP00<0:iXP0030000003oool0oooo0180oooo0P0000000`3QM@d000000?S<WP020?S<WP<0
0000103LgmPA00000880oooo001L0?ooo`030000002^J800[VR000`0[VR000<000000?ooo`3oool0
4P3oool6000000<0Y=Ci00<000000=cOf03LgmP04`0000210?ooo`00G@3oool00`000000[VR00:iX
P00<0:iXP0030000003oool0oooo0180oooo0P0000000`08O>4000000:CDn@040:CDnA@00000PP3o
ool005h0oooo00<000000:iXP02^J800302^J8000`000000oooo0?ooo`0C0?ooo`0300000008O>40
000000D0Y=Ci4P0000230?ooo`00G`3oool00`000000[VR00:iXP00<0:iXP0030000003oool0oooo
01<0oooo00<0000000Qlh@0000000`2Te?TC000008<0oooo001:0?ooo`030000003oool0oooo01<0
oooo00<000000:iXP02^J800302^J8000`000000oooo0?ooo`0C0?ooo`0400000008O>4000000:CD
nAH00000P@3oool004P0oooo0P0000000`2^JH8000000?ooo`0D0?ooo`030000002^J800[VR000`0
[VR000<000000?ooo`3oool04`3ooolG0000000301F2iP00000000000800oooo00160?ooo`800000
102^JH800`000000oooo0?ooo`0C0?ooo`030000002^J800[VR000`0[VR000<000000?ooo`3oool0
503ooolC000000040?W>W0000000000001F2iP800000O`3oool004D0oooo00<000000:iYPP2^JH80
1@2^JH800`000000oooo0?ooo`0C0?ooo`030000002^J800[VR000`0[VR000<000000?ooo`3oool0
503ooolD000000050:KCm`00000000000=a^0@000000OP3oool004<0oooo0P0000090:iYPP030000
003oool0oooo01<0oooo00<000000:iXP02^J800302^J8000`000000oooo0?ooo`0D0?ooo`l00000
00@0bkW900000000000000000`2VdoL4000007`0oooo00110?ooo`800000302^JH800`000000oooo
0?ooo`0C0?ooo`030000002^J800[VR000`0[VR000<000000?ooo`3oool04`3ooolC00000080Y]?g
0P0000030;iKDP030000003oool0oooo07T0oooo00100?ooo`030000002^JH80[VV200d0[VV200<0
00000?ooo`3oool04`3oool00`000000[VR00:iXP00<0:iXP0030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01P3ooolE000000030:EXR`000000_U]B00<0_U]B00<000000?ooo`3oool0N03o
ool00440oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?ooo`0C0?ooo`8000003@2^J800
0`000000oooo0?ooo`070?ooo`<000001`3ooolC000000@0YFR;00<000000;iKDP2nFe800P2nFe80
0`000000oooo0?ooo`1g0?ooo`00@P3oool00`000000[VV20:iYPP0=0:iYPP030000003oool0oooo
01@0oooo00<000000:iXP02^J8002`2^J8000`000000oooo0?ooo`050?ooo`80000000<0Nd>00000
000000001@3oool=000000030:CDn@000000000000<000001P2UJ8/00`000000_U]B0;iKDP020;iK
DP030000003oool0oooo07H0oooo00130?ooo`030000002^JH80[VV200d0[VV200<000000?ooo`3o
ool0503oool00`000000[VR00:iXP00;0:iXP0030000003oool0oooo00<0oooo0P00000307]3P080
00000`3oool=00000080Y=Ci100000000`29JZT000000:EXR`050:EXR`030000002nFe80_U]B0080
_U]B00<000000?ooo`3oool0M@3oool004@0oooo00<000000:iYPP2^JH803@2^JH800`000000oooo
0?ooo`0D0?ooo`030000002^J800[VR000/0[VR000@000000?ooo`3oool0oooo0P00000507]3P080
000000<0oooo0000000000003@0000030?S<WP8000000P29JZT00`000000YFR;0:EXR`040:EXR`80
00000`2nFe800`000000oooo0?ooo`1d0?ooo`00A@3oool00`000000[VV20:iYPP0=0:iYPP030000
003oool0oooo01@0oooo00<000000:iXP02^J8002`2^J80010000000oooo00000000000507]3P003
0000002YPj/0000000h0000000<0hGD=0000003hc9h00P3hc9h00`000000RFZY08UZZ@0208UZZ@03
0000002UJ8/0YFR;00D0YFR;00D000000;iKDP2nFe80_U]B0000001e0?ooo`00AP3oool00`000000
[VV20:iYPP0=0:iYPP030000003oool0oooo01@0oooo00<000000:iXP02^J8002`2^J802000000D0
Nd>000@000000:V3Z`2YPj/0ZH>[3@000000103oool000000>5e3@0000020?S<WP0300000029JZT0
RFZY00<0RFZY00<000000:EXR`2UJ8/01@2UJ8/01@000000_U]B0;iKDP2nFe80000007@0oooo0017
0?ooo`030000002^JH80[VV200d0[VV200<000000?ooo`3oool0503oool00`000000[VR00:iXP00:
0:iXP0800000101k@h000`000000ZH>[0:V3Z`030:V3Z`P000001P3oool4000000L0RFZY0P000006
0:EXR`050000002nFe80_U]B0;iKDP000000L`3oool004P0oooo00<000000:iYPP2^JH803@2^JH80
0`000000oooo0?ooo`0D0?ooo`030000002^J800[VR000P0[VR00P00000407]3P0030000002YPj/0
ZH>[00D0ZH>[1P0000080?ooo`@000002029JZT00`000000YFR;0:EXR`040:EXR`040000002nFe80
_U]B0;iKDP800000L@3oool004T0oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?ooo`0D
0?ooo`030000002^J800[VR000D0[VR00`00000407]3P0030000002YPj/0ZH>[00L0ZH>[1000000:
0?ooo`80000000<0Df?500000029JZT01`29JZT00`000000YFR;0:EXR`040:EXR`030000002nFe80
_U]B0080_U]B00<000000?ooo`3oool0KP3oool004X0oooo00<000000:iYPP2^JH803@2^JH800`00
0000oooo0?ooo`0D0?ooo`030000002^J800[VR00080[VR01000000507]3P0030000002YPj/0ZH>[
00H0ZH>[00<000000<>[`P0000000P00000;0?ooo`030000001CHlD0Df?5008000001`29JZT00`00
0000YFR;0:EXR`040:EXR`030000002nFe80_U]B0080_U]B00<000000?ooo`3oool0K@3oool004/0
oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?ooo`0D0?ooo`050000002^J80000000000
003oool00P00000507]3P0030000002YPj/0ZH>[00H0ZH>[00@000000<>[`P33Zl80`j_20`00000;
0?ooo`050000001CHlD0Df?505=Sa@0000001`29JZT00`000000YFR;0:EXR`040:EXR`030000002n
Fe80_U]B0080_U]B00<000000?ooo`3oool0K03oool004`0oooo00<000000:iYPP2^JH803@2^JH80
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo008000001@1k@h000`000000ZH>[0:V3Z`06
0:V3Z`0300000033Zl80`j_200@0`j_20P00000;0?ooo`050000001CHlD0Df?505=Sa@0000001`29
JZT00`000000YFR;0:EXR`040:EXR`030000002nFe80_U]B0080_U]B00<000000?ooo`3oool0J`3o
ool004d0oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?ooo`0E0?ooo`8000001@1k@h00
0`000000ZH>[0:V3Z`060:V3Z`0300000033Zl80`j_200H0`j_20P00000;0?ooo`050000001CHlD0
Df?505=Sa@0000001`29JZT00`000000YFR;0:EXR`040:EXR`030000002nFe80_U]B0080_U]B00<0
00000?ooo`3oool0JP3oool004h0oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?ooo`0C
0?ooo`8000001@1k@h000`000000ZH>[0:V3Z`060:V3Z`0300000033Zl80`j_200H0`j_200@00000
0=cOf000000000002`3oool01@000000Df?505=Sa@1CHlD0000000L0RFZY00<000000:EXR`2UJ8/0
102UJ8/2000000<0_U]B00<000000?ooo`3oool0J@3oool004l0oooo00<000000:iYPP2^JH803@2^
JH800`000000oooo0?ooo`0A0?ooo`8000001@1k@h000`000000ZH>[0:V3Z`070:V3Z`0300000033
Zl80`j_200D0`j_200<000000=cOf03LgmP00P3LgmP00`000000oooo0?ooo`090?ooo`050000001C
HlD0Df?505=Sa@0000001`29JZT00`000000YFR;0:EXR`050:EXR`050000002nFe80_U]B0;iKDP00
0000JP3oool00500oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?ooo`0?0?ooo`800000
1@1k@h000`000000ZH>[0:V3Z`070:V3Z`0300000033Zl80`j_200D0`j_200<000000=cOf03LgmP0
0P3LgmP00`000000oooo0?ooo`0;0?ooo`050000001CHlD0Df?505=Sa@0000001`29JZT00`000000
YFR;0:EXR`050:EXR`050000002nFe80_U]B0;iKDP000000J@3oool00500oooo00<000000:iYPP2^
JH803P2^JH800`000000oooo0?ooo`0>0?ooo`030000001k@h00Nd>000<0Nd>000<000000:V3Z`2Y
Pj/01`2YPj/00`000000`j_20<>[`P050<>[`P030000003LgmP0g=oH0080g=oH00<000000?ooo`3o
ool03@3oool010000000Df?505=Sa@1CHlD2000000H0RFZY0P0000060:EXR`050000002nFe80_U]B
0;iKDP000000J03oool00540oooo00<000000:iYPP2^JH803P2^JH800`000000oooo0?ooo`0<0?oo
o`800000101k@h000`000000ZH>[0:V3Z`070:V3Z`0300000033Zl80`j_200D0`j_200<000000=cO
f03LgmP00P3LgmP00`000000oooo0?ooo`0?0?ooo`030000001CHlD0Df?50080Df?500<0000008UZ
Z@29JZT01@29JZT00`000000YFR;0:EXR`040:EXR`030000002nFe80_U]B00800000I`3oool00580
oooo00<000000:iYPP2^JH803P2^JH800`000000oooo0?ooo`0:0?ooo`800000101k@h000`000000
ZH>[0:V3Z`070:V3Z`0300000033Zl80`j_200H0`j_200D000000=cOf03LgmP0g=oH0000000C0?oo
o`030000001CHlD0Df?50080Df?500<0000008UZZ@29JZT01@29JZT010000000YFR;0:EXR`000003
0:EXR`8000000P1GILD00`000000oooo0?ooo`1T0?ooo`00D`3oool00`000000[VV20:iYPP0>0:iY
PP030000003oool0oooo00P0oooo0P00000407]3P0030000002YPj/0ZH>[00L0ZH>[00<000000<>[
`P33Zl801P33Zl801@000000g=oH0=cOf03LgmP0000001D0oooo0P00000305=Sa@0300000029JZT0
RFZY00D0RFZY1P0000000`2;JjT000000000000205MUa@030000003oool0oooo06<0oooo001D0?oo
o`030000002^JH80[VV200h0[VV200<000000?ooo`3oool01P3oool2000000D0Nd>000<000000:V3
Z`2YPj/01P2YPj/00`000000`j_20<>[`P060<>[`P030000003LgmP0g=oH0080g=oH00<000000?oo
o`3oool0503oool2000000<0Df?500<0000008UZZ@29JZT01@29JZT4000000@0Rf^Y00<0000005MU
a@000000I@3oool005D0oooo00<000000:iYPP2^JH803P2^JH800`000000oooo0?ooo`040?ooo`80
00001@1k@h000`000000ZH>[0:V3Z`060:V3Z`0300000033Zl80`j_200H0`j_200<000000=cOf03L
gmP00P3LgmP00`000000oooo0?ooo`0F0?ooo`8000000`1CHlD00`000000RFZY08UZZ@0508UZZ@@0
0000102;JjT2000006D0oooo001F0?ooo`030000002^JH80[VV200h0[VV200<000000?ooo`3oool0
0`3oool00`000000Nd>007]3P00307]3P0030000002YPj/0ZH>[00H0ZH>[00<000000<>[`P33Zl80
1P33Zl800`000000g=oH0=cOf0020=cOf0040000003oool0oooo000001P0oooo00@0000005=Sa@1C
HlD0Df?50P00000408UZZ@H00000102;JjT00`000000oooo0?ooo`1S0?ooo`00E`3oool00`000000
[VV20:iYPP0>0:iYPP030000003oool0oooo00<0oooo00D0000007]3P01k@h00Nd>0000000080:V3
Z`0300000033Zl80`j_200H0`j_200<000000=cOf03LgmP00P3LgmP01P000000oooo000000000000
[VR0000001P0oooo00<0000005=Sa@1CHlD00P1CHlD010000000RFZY08UZZ@29JZT700000080Rf^Y
00<000000?ooo`3oool0I03oool005P0oooo00<000000:iYPP2^JH803P2^JH800`000000oooo0?oo
o`030?ooo`030000001k@h00000000P0ZH>[00<000000<>[`P33Zl801P33Zl800`000000g=oH0=cO
f0020=cOf0030000003oool0000000@0[VR000<000000?ooo`3oool05P3oool00`000000Df?505=S
a@0205=Sa@0400000029JZT000000:IYS0L0000000<0Rf^Y0000003oool0I@3oool005T0oooo00<0
00000:iYPP2^JH803P2^JH800`000000oooo0?ooo`030?ooo`030000002YPj/0ZH>[00L0ZH>[00<0
00000<>[`P33Zl801@33Zl800`000000g=oH0=cOf0020=cOf0<000001P2^J8000`000000oooo0?oo
o`0F0?ooo`030000001CHlD0Df?50080Df?500@000000:IYS02VJH`0YVV<1`00001W0?ooo`00FP3o
ool00`000000[VV20:iYPP0<0:iYPP040000001k@h000000000000@0oooo00<000000:V3Z`2YPj/0
1@2YPj/00`000000`j_20<>[`P050<>[`P030000003LgmP0g=oH0080g=oH0P0000090:iXP0030000
003oool0oooo01H0oooo00@0000005=Sa@1CHlD0Df?50P0000030:IYS0P00000I@3oool005/0oooo
00<000000:iYPP2^JH802P2^JH801P000000Nd>007]3P0000000fmcG000000@0oooo00<000000:V3
Z`2YPj/00`2YPj/00`000000`j_20<>[`P050<>[`P030000003LgmP0g=oH0080g=oH0P00000;0:iX
P0030000003oool0oooo01H0oooo00H0000005=Sa@1CHlD000000;iNEP0000030:IYS0P00000I03o
ool005`0oooo00<000000:iYPP2^JH80202^JH800`000000Nd>007]3P00207]3P00300000033Z/80
00000080oooo0`0000030:V3Z`0300000033Zl80`j_200D0`j_200<000000=cOf03LgmP00P3LgmP0
0`000000[VR00:iXP00<0:iXP08000005`3oool2000000<0_UiF00@000000:IYS02VJH`0YVV<2000
001S0?ooo`00G@3oool00`000000[VV20:iYPP050:iYPP8000001P1k@h000`000000`j[200000005
000000030:V3Z`000000`j_200L0`j_200L000000=cOf03LgmP0g=oH0000003oool0000000l0[VR0
00<000000?ooo`3oool05@3oool00`000000_UiF0;iNEP020;iNEP040000002VJH`000000?ooo`P0
0000HP3oool005h0oooo00<000000:iYPP2^JH800P2^JH84000000D0Nd>000<000000:V3Z`000000
1`0000080<>[`P050000003LgmP0g=oH0=cOf00000000`3oool00`000000[VR00:iXP00=0:iXP003
0000003oool0oooo01D0oooo00<000000;iNEP2nGUH00`0000040?ooo`L00000H@3oool005l0oooo
00D000000:iYPP00000000000?ooo`02000000D0Nd>000@000000:V3Z`2YPj/0ZH>[200000060<>[
`P030000003LgmP0g=oH0080g=oH00<000000?ooo`3oool00P3oool00`000000[VR00:iXP00=0:iX
P0030000003oool0oooo01D0oooo0P0000080?ooo`L00000H03oool00600oooo00<000000?ooo`3o
ool00P00000507]3P0030000002YPj/0ZH>[00@0ZH>[200000030<>[`P030000003LgmP0g=oH0080
g=oH00<000000?ooo`3oool0103oool00`000000[VR00:iXP00=0:iXP0030000003oool0oooo01l0
oooo1`00001O0?ooo`00HP3oool2000000D0Nd>000<000000:V3Z`2YPj/01P2YPj/500000080oooo
00<000000<>[`P000000103LgmP00`000000oooo0?ooo`060?ooo`030000002^J800[VR000d0[VR0
00<000000?ooo`3oool07`3oool7000005h0oooo001Q0?ooo`8000001P1k@h000`000000ZH>[0:V3
Z`050:V3Z`0300000033Zl80000000800000103oool00`000000g=oH0=cOf0020=cOf0030000003o
ool0oooo00P0oooo00<000000:iXP02^J8003@2^J8000`000000oooo0?ooo`0O0?ooo`L00000G@3o
ool00640oooo00<0000007]3P01k@h00101k@h000`000000ZH>[0:V3Z`050:V3Z`0700000033Zl80
`j_20<>[`P000000ZX>[000000040?ooo`80000000<0g=oH0000003oool02`3oool00`000000[VR0
0:iXP00=0:iXP0030000003oool0oooo01l0oooo1@00001N0?ooo`00HP3oool00`000000Nd>007]3
P00207]3P0030000002YPj/0ZH>[00D0ZH>[00<000000<>[`P33Zl800`33Zl800`000000ZX>[0000
00050?ooo`030000003oool0oooo00`0oooo00<000000:iXP02^J8003@2^J8000`000000oooo0?oo
o`0O0?ooo`<00000G`3oool00680oooo00D0000007]3P01k@h00Nd>0000000070:V3Z`0300000033
Zl80`j_200D0`j_200<0000007i7P`000000503oool00`000000[VR00:iXP00=0:iXP0030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0GP3oool006<0oooo00<0000007]3P0000000202YPj/0
0`000000`j_20<>[`P060<>[`P030000001nAh<0000001@0oooo00<000000:iXP02^J8003@2^J800
0`000000oooo0?ooo`1o0?ooo`00I03oool00`000000ZH>[0:V3Z`060:V3Z`0300000033Zl80`j_2
00H0`j_200<000000=cOf00000000P00000D0?ooo`030000002^J800[VR000d0[VR000<000000?oo
o`3oool0OP3oool006D0oooo00<000000:V3Z`2YPj/0102YPj/00`000000`j_20<>[`P060<>[`P03
0000003LgmP0g=oH0080g=oH00<000000?ooo`3oool04`3oool00`000000[VR00:iXP00=0:iXP003
0000003oool0oooo07d0oooo001U0?ooo`<000000`2YPj/00`000000`j_20<>[`P060<>[`P030000
003LgmP0g=oH0080g=oH00<000000?ooo`3oool05@3oool00`000000[VR00:iXP00=0:iXP0800000
O@3oool006@0oooo1@0000000`2YPj/000000<>[`P070<>[`P030000003LgmP0g=oH0080g=oH00<0
00000?ooo`0000005`3oool00`000000[VR00:iXP00>0:iXP0030000003oool0oooo07X0oooo001S
0?ooo`L000002@33Zl8010000000g=oH0=cOf03LgmP3000000030:iYPP000000oooo01H0oooo00<0
00000:iXP02^J8003P2^J8000`000000oooo0?ooo`1i0?ooo`00I03oool7000000L0`j_200@00000
0=cOf03LgmP0g=oH0P0000040:iYPP030000003oool0oooo01D0oooo00<000000:iXP02^J8003P2^
J8000`000000oooo0?ooo`1h0?ooo`00I@3oool7000000D0`j_200D000000=cOf03LgmP0g=oH0000
00070:iYPP030000003oool0oooo01D0oooo00<000000:iXP02^J8003P2^J8000`000000oooo0?oo
o`1g0?ooo`00I03oool7000000030?ooo`000000`j_20080`j_200<000000=cOf03LgmP00P000009
0:iYPP030000003oool0oooo01D0oooo00<000000:iXP02^J8003P2^J8000`000000oooo0?ooo`1f
0?ooo`00H`3oool3000000040?ooo`0000000000000000<0oooo00@000000<>[`P000000g=oH0P00
000<0:iYPP030000003oool0oooo01D0oooo00<000000:iXP02^J8003P2^J8000`000000oooo0?oo
o`1e0?ooo`00HP3oool400000080oooo00<000000?ooo`3oool00`3oool00`000000g=oH0000000?
0:iYPP030000003oool0oooo01D0oooo00<000000:iXP02^J8002`2^J802000007P0oooo001P0?oo
o`<0000000<0b:Zk0000003oool02@3oool3000000l0[VV200<000000?ooo`3oool05@3oool00`00
0000[VR00:iXP0090:iXP0030000003oool0oooo07P0oooo001O0?ooo`80000000<0[h>U00000000
00003@3oool2000000l0[VV200<000000?ooo`3oool05@3oool00`000000[VR00:iXP0060:iXP080
0000N`3oool005h0oooo0P000000102_PjD0000000000000000?0?ooo`030000002^JH80[VV200d0
[VV200<000000?ooo`3oool05@3oool00`000000[VR00:iXP0040:iXP0030000003oool0oooo07/0
oooo001M0?ooo`80000000@0[h>U00000000000000004@3oool00`000000[VV20:iYPP0=0:iYPP03
0000003oool0oooo01D0oooo00<000000:iXP02^J8000P2^J8000`000000oooo0?ooo`1l0?ooo`00
F`3oool3000000040:n3Y@000000b:Zk000001<0oooo00<000000:iYPP2^JH803@2^JH800`000000
oooo0?ooo`0E0?ooo`040000002^J8000000000007l0oooo001J0?ooo`<0000000<0[h>U00000038
Z[/00P00000D0?ooo`030000002^JH80[VV200d0[VV200<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`1o0?ooo`00F@3oool3000000030:n3Y@000000b:Zk008000005P3oool00`000000[VV2
0:iYPP0=0:iYPP030000003oool0oooo09H0oooo001H0?ooo`<0000000<0[h>U00000038Z[/00P00
000H0?ooo`030000002^JH80[VV200d0[VV200<000000?ooo`3oool0U@3oool005L0oooo0`000000
102_PjD000000<RZ^`38Z[/2000001T0oooo00<000000:iYPP2^JH803@2^JH800`000000oooo0?oo
o`2D0?ooo`00E@3oool20000000408E6NP000000[h>U00000080b:Zk0P00000J0?ooo`030000002^
JH80[VV200h0[VV200<000000?ooo`3oool0T`3oool005@0oooo0P0000001025AWX000000:n3Y@00
00020<RZ^`800000703oool00`000000[VV20:iYPP0>0:iYPP030000003oool0oooo0980oooo001C
0?ooo`@0000000@0[h>U00000038Z[/0b:Zk0P00000N0?ooo`030000002^JH80[VV200h0[VV200<0
00000?ooo`3oool0T@3oool00580oooo0`0000020:n3Y@0400000038Z[/0b:Zk0<RZ^`8000007`3o
ool00`000000[VV20:iYPP0>0:iYPP030000003oool0oooo0900oooo001@0?ooo`@000000`2_PjD0
0`000000b:Zk0<RZ^`0200000240oooo00<000000:iYPP2^JH803P2^JH800`000000oooo0?ooo`2?
0?ooo`00C`3oool20000000308E6NP000000[h>U0080[h>U00<000000<RZ^`38Z[/00P00000S0?oo
o`030000002^JH80[VV200h0[VV200<000000?ooo`3oool0SP3oool004h0oooo0P0000000`25AWX0
00000:n3Y@020:n3Y@0600000038Z[/0b:Zk0000003Tfld00000903oool00`000000[VV20:iYPP0>
0:iYPP030000003oool0oooo08d0oooo001>0?ooo`0300000025AWX0000000<0[h>U00@000000<RZ
^`38Z[/0b:Zk0P00000V0?ooo`030000002^JH80[VV200h0[VV200<000000?ooo`3oool0S03oool0
04l0oooo00D000000:n3Y@2_PjD0[h>U000000030<RZ^`800000:03oool00`000000[VV20:iYPP0>
0:iYPP030000003oool0oooo08/0oooo001@0?ooo`030000002_PjD0000000<0b:Zk00<000000>CK
c@000000:@3oool00`000000[VV20:iYPP0>0:iYPP030000003oool0oooo08X0oooo001A0?ooo`07
00000038Z[/0b:Zk0<RZ^`000000i=_=0000000[0?ooo`030000002^JH80[VV200h0[VV200<00000
0?ooo`3oool0R@3oool00580oooo0P0000000`38Z[/000000000000]0?ooo`030000002^JH80[VV2
00h0[VV200<000000?ooo`3oool0R03oool005@0oooo00<000000>CKc@000000;P3oool00`000000
[VV20:iYPP0>0:iYPP030000003oool0oooo08L0oooo001E0?ooo`030000003oool0oooo02h0oooo
00<000000:iYPP2^JH803P2^JH800`000000oooo0?ooo`260?ooo`00Q`3oool00`000000[VV20:iY
PP0>0:iYPP030000003oool0oooo08D0oooo00280?ooo`030000002^JH80[VV200h0[VV200<00000
0?ooo`3oool0Q03oool008T0oooo00<000000:iYPP2^JH803P2^JH800`000000oooo0?ooo`230?oo
o`00RP3oool00`000000[VV20:iYPP0>0:iYPP030000003oool0oooo0880oooo002;0?ooo`030000
002^JH80[VV200h0[VV200<000000?ooo`3oool0P@3oool008`0oooo00<000000:iYPP2^JH803P2^
JH800`000000oooo0?ooo`200?ooo`00S03oool00`000000[VV20:iYPP0?0:iYPP030000003oool0
oooo07l0oooo002=0?ooo`030000002^JH80[VV200l0[VV200<000000?ooo`3oool0OP3oool008h0
oooo00<000000:iYPP2^JH803`2^JH800`000000oooo0?ooo`1m0?ooo`00S`3oool00`000000[VV2
0:iYPP0<0:iYPP800000P03oool00900oooo00<000000:iYPP2^JH802P2^JH800`000000oooo0?oo
o`200?ooo`00T@3oool00`000000[VV20:iYPP070:iYPP800000P`3oool00980oooo00<000000:iY
PP2^JH80102^JH82000008D0oooo002C0?ooo`030000002^JH80[VV20080[VV200<000000?ooo`3o
ool0Q@3oool009@0oooo00@000000:iYPP0000000000R03oool009D0oooo00<000000?ooo`3oool0
R03oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {273.938, 0}} -> {0.0309293, -6.5484*^-17, \
0.00316094, 0.00316094}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95481 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0342748 1.10268 7.22079e-17 1.10268 [
[ 0 0 0 0 ]
[ 1 .95481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95481 L
0 .95481 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.50634 .53475 m .4808 .55191 L .49476 .5607 L p .37 .605 .939 r
F P
0 g
s
.49476 .5607 m .52069 .54383 L .50634 .53475 L p .37 .605 .939 r
F P
0 g
s
.52069 .54383 m .49476 .5607 L .50168 .57591 L p .233 .314 .742 r
F P
0 g
s
.50168 .57591 m .52784 .5595 L .52069 .54383 L p .233 .314 .742 r
F P
0 g
s
.52784 .5595 m .50168 .57591 L .49895 .59181 L p .042 0 .388 r
F P
0 g
s
.49018 .53573 m .46506 .5529 L .4808 .55191 L p .475 .862 .976 r
F P
0 g
s
.4808 .55191 m .50634 .53475 L .49018 .53573 L p .475 .862 .976 r
F P
0 g
s
.49895 .59181 m .52508 .57586 L .52784 .5595 L p .042 0 .388 r
F P
0 g
s
.52508 .57586 m .49895 .59181 L .48754 .60236 L p 0 0 0 r
F P
0 g
s
.47838 .54646 m .45354 .56336 L .46506 .5529 L p 0 0 0 r
F P
0 g
s
.46506 .5529 m .49018 .53573 L .47838 .54646 L p 0 0 0 r
F P
0 g
s
.48754 .60236 m .51339 .58669 L .52508 .57586 L p 0 0 0 r
F P
0 g
s
.51339 .58669 m .48754 .60236 L .47175 .60348 L p .443 .854 .963 r
F P
0 g
s
.47549 .56289 m .45068 .57933 L .45354 .56336 L p .001 0 .362 r
F P
0 g
s
.45354 .56336 m .47838 .54646 L .47549 .56289 L p .001 0 .362 r
F P
0 g
s
.49719 .58781 m .47175 .60348 L .45765 .59469 L p .349 .6 .941 r
F P
0 g
s
.47175 .60348 m .49719 .58781 L .51339 .58669 L p .443 .854 .963 r
F P
0 g
s
.48268 .57871 m .45765 .59469 L .45068 .57933 L p .207 .298 .737 r
F P
0 g
s
.45068 .57933 m .47549 .56289 L .48268 .57871 L p .207 .298 .737 r
F P
0 g
s
.45765 .59469 m .48268 .57871 L .49719 .58781 L p .349 .6 .941 r
F P
0 g
s
.60484 .46915 m .59965 .46096 L .53624 .53372 L closepath p .849 .679 .672 r
F P
0 g
s
.61241 .47574 m .60484 .46915 L .53624 .53372 L closepath p .747 .503 .562 r
F P
0 g
s
.61951 .47824 m .61241 .47574 L .53624 .53372 L closepath p .555 .213 .343 r
F P
0 g
s
.59965 .46096 m .59881 .45425 L .53624 .53372 L closepath p .939 .899 .76 r
F P
0 g
s
.62346 .47567 m .61951 .47824 L .53624 .53372 L closepath p 0 0 0 r
F P
0 g
s
.59881 .45425 m .60267 .45158 L .53624 .53372 L closepath p 0 0 0 r
F P
0 g
s
.62269 .46896 m .62346 .47567 L .53624 .53372 L closepath p .863 .866 .84 r
F P
0 g
s
.60267 .45158 m .6098 .45402 L .53624 .53372 L closepath p .537 .277 .469 r
F P
0 g
s
.61747 .46067 m .62269 .46896 L .53624 .53372 L closepath p .798 .672 .725 r
F P
0 g
s
.6098 .45402 m .61747 .46067 L .53624 .53372 L closepath p .708 .515 .625 r
F P
0 g
s
.54438 .60001 m .61791 .68456 L .6308 .67305 L p .731 .594 .703 r
F P
0 g
s
.6308 .67305 m .55737 .58852 L .54438 .60001 L p .731 .594 .703 r
F P
0 g
s
.55737 .58852 m .6308 .67305 L .64295 .66407 L p .615 .574 .785 r
F P
0 g
s
.53512 .60939 m .60904 .69434 L .61791 .68456 L p .827 .588 .577 r
F P
0 g
s
.61791 .68456 m .54438 .60001 L .53512 .60939 L p .827 .588 .577 r
F P
0 g
s
.64295 .66407 m .56927 .57919 L .55737 .58852 L p .615 .574 .785 r
F P
0 g
s
.56927 .57919 m .64295 .66407 L .6498 .661 L p .305 .463 .854 r
F P
0 g
s
.51667 .54933 m .5198 .5562 L p .49693 .55766 L .778 .595 .652 r
F P
0 g
s
.51038 .54535 m .51667 .54933 L p .49693 .55766 L .778 .595 .652 r
F P
0 g
s
.52597 .54151 m .51667 .54933 L .51038 .54535 L p .698 .635 .782 r
F P
0 g
s
.51667 .54933 m .52597 .54151 L .53163 .55391 L p .644 .537 .718 r
F P
0 g
s
.53163 .55391 m .5198 .5562 L .51667 .54933 L p .644 .537 .718 r
F P
0 g
s
.01 w
.51853 .5504 m
.51943 .54981 L
s
.5 Mabswid
.5198 .5562 m .51858 .56336 L p .49693 .55766 L .778 .595 .652 r
F P
0 g
s
.01 w
.48085 .57468 m
.50426 .55959 L
s
.5 Mabswid
.5198 .5562 m .53163 .55391 L .52945 .56683 L p .622 .446 .624 r
F P
0 g
s
.52945 .56683 m .51858 .56336 L .5198 .5562 L p .622 .446 .624 r
F P
0 g
s
.50332 .54579 m .51038 .54535 L p .49693 .55766 L .778 .595 .652 r
F P
0 g
s
.01 w
.50839 .55693 m
.51853 .5504 L
s
.5 Mabswid
.51462 .53433 m .51038 .54535 L .50332 .54579 L p .778 .727 .806 r
F P
0 g
s
.51038 .54535 m .51462 .53433 L .52597 .54151 L p .698 .635 .782 r
F P
0 g
s
.51858 .56336 m .51347 .56807 L p .49693 .55766 L .778 .595 .652 r
F P
0 g
s
.51858 .56336 m .52945 .56683 L .52023 .57537 L p .641 .38 .509 r
F P
0 g
s
.52023 .57537 m .51347 .56807 L .51858 .56336 L p .641 .38 .509 r
F P
0 g
s
.53357 .53559 m .52597 .54151 L .51462 .53433 L p .607 .645 .862 r
F P
0 g
s
.52597 .54151 m .53357 .53559 L .54065 .5511 L p .517 .473 .747 r
F P
0 g
s
.54065 .5511 m .53163 .55391 L .52597 .54151 L p .517 .473 .747 r
F P
0 g
s
.53312 .61312 m .60759 .69868 L .60904 .69434 L p .861 .409 .075 r
F P
0 g
s
.60904 .69434 m .53512 .60939 L .53312 .61312 L p .861 .409 .075 r
F P
0 g
s
.42579 .46364 m .47782 .52347 L .49089 .51201 L p .731 .594 .703 r
F P
0 g
s
.49089 .51201 m .43894 .4522 L .42579 .46364 L p .731 .594 .703 r
F P
0 g
s
.43894 .4522 m .49089 .51201 L .50258 .50236 L p .615 .574 .785 r
F P
0 g
s
.53163 .55391 m .54065 .5511 L .53794 .56727 L p .456 .295 .573 r
F P
0 g
s
.53794 .56727 m .52945 .56683 L .53163 .55391 L p .456 .295 .573 r
F P
0 g
s
.49693 .55766 m .49818 .55049 L .50332 .54579 L p .778 .595 .652 r
F P
0 g
s
.50187 .5351 m .50332 .54579 L .49818 .55049 L p .873 .789 .765 r
F P
0 g
s
.50332 .54579 m .50187 .5351 L .51462 .53433 L p .778 .727 .806 r
F P
0 g
s
.41589 .47238 m .4682 .53249 L .47782 .52347 L p .827 .588 .577 r
F P
0 g
s
.47782 .52347 m .42579 .46364 L .41589 .47238 L p .827 .588 .577 r
F P
0 g
s
.51347 .56807 m .5064 .56854 L p .49693 .55766 L .778 .595 .652 r
F P
0 g
s
.51347 .56807 m .52023 .57537 L .50744 .57623 L p .713 .371 .397 r
F P
0 g
s
.50744 .57623 m .5064 .56854 L .51347 .56807 L p .713 .371 .397 r
F P
0 g
s
.51937 .52659 m .51462 .53433 L .50187 .5351 L p .737 .823 .918 r
F P
0 g
s
.51462 .53433 m .51937 .52659 L .53357 .53559 L p .607 .645 .862 r
F P
0 g
s
.6498 .661 m .57563 .57552 L .56927 .57919 L p .305 .463 .854 r
F P
0 g
s
.49257 .54357 m .49818 .55049 L .49693 .55766 L p .943 .767 .634 r
F P
0 g
s
.49818 .55049 m .49257 .54357 L .50187 .5351 L p .873 .789 .765 r
F P
0 g
s
.52945 .56683 m .53794 .56727 L .52641 .57797 L p .427 .095 .298 r
F P
0 g
s
.52641 .57797 m .52023 .57537 L .52945 .56683 L p .427 .095 .298 r
F P
0 g
s
.5064 .56854 m .50008 .56456 L .49693 .55766 L p .778 .595 .652 r
F P
0 g
s
.5064 .56854 m .50744 .57623 L .496 .56903 L p .829 .459 .355 r
F P
0 g
s
.496 .56903 m .50008 .56456 L .5064 .56854 L p .829 .459 .355 r
F P
0 g
s
.50258 .50236 m .45044 .4423 L .43894 .4522 L p .615 .574 .785 r
F P
0 g
s
.49031 .55654 m .49693 .55766 L .50008 .56456 L p .93 .631 .453 r
F P
0 g
s
.49693 .55766 m .49031 .55654 L .49257 .54357 L p .943 .767 .634 r
F P
0 g
s
.50008 .56456 m .496 .56903 L .49031 .55654 L p .93 .631 .453 r
F P
0 g
s
.50342 .52753 m .50187 .5351 L .49257 .54357 L p .896 .964 .827 r
F P
0 g
s
.50187 .5351 m .50342 .52753 L .51937 .52659 L p .737 .823 .918 r
F P
0 g
s
.53797 .53273 m .53357 .53559 L .51937 .52659 L p .37 .605 .939 r
F P
0 g
s
.53357 .53559 m .53797 .53273 L .54509 .54831 L p .233 .313 .742 r
F P
0 g
s
.54509 .54831 m .54065 .5511 L .53357 .53559 L p .233 .313 .742 r
F P
0 g
s
.45044 .4423 m .50258 .50236 L .50849 .49814 L p .305 .463 .854 r
F P
0 g
s
.54065 .5511 m .54509 .54831 L .54238 .56456 L p .041 0 .388 r
F P
0 g
s
.54238 .56456 m .53794 .56727 L .54065 .5511 L p .041 0 .388 r
F P
0 g
s
.52023 .57537 m .52641 .57797 L .51041 .57905 L p .446 0 0 r
F P
0 g
s
.51041 .57905 m .50744 .57623 L .52023 .57537 L p .446 0 0 r
F P
0 g
s
.02 w
.53847 .57597 m
.54082 .57868 L
s
.5 Mabswid
.52371 .52368 m .51937 .52659 L .50342 .52753 L p .474 .862 .976 r
F P
0 g
s
.51937 .52659 m .52371 .52368 L .53797 .53273 L p .37 .605 .939 r
F P
0 g
s
.39406 .66056 m .46521 .59527 L .45226 .57609 L p .821 .675 .702 r
F P
0 g
s
.46521 .59527 m .39406 .66056 L .41201 .67708 L p .727 .511 .599 r
F P
0 g
s
.41201 .67708 m .48301 .61134 L .46521 .59527 L p .727 .511 .599 r
F P
0 g
s
.57563 .57552 m .6498 .661 L .64864 .66512 L p .848 .387 .031 r
F P
0 g
s
.49177 .53813 m .49257 .54357 L .49031 .55654 L p .929 .828 .375 r
F P
0 g
s
.49257 .54357 m .49177 .53813 L .50342 .52753 L p .896 .964 .827 r
F P
0 g
s
.41299 .47511 m .46569 .53566 L .4682 .53249 L p .861 .409 .075 r
F P
0 g
s
.4682 .53249 m .41589 .47238 L .41299 .47511 L p .861 .409 .075 r
F P
0 g
s
.50849 .49814 m .456 .43766 L .45044 .4423 L p .305 .463 .854 r
F P
0 g
s
.53794 .56727 m .54238 .56456 L .5308 .5753 L p 0 0 0 r
F P
0 g
s
.5308 .5753 m .52641 .57797 L .53794 .56727 L p 0 0 0 r
F P
0 g
s
.02 w
.53473 .57166 m
.53847 .57597 L
s
.52569 .56127 m
.53439 .57127 L
s
.5 Mabswid
.50744 .57623 m .51041 .57905 L .49606 .57004 L p .524 0 0 r
F P
0 g
s
.49606 .57004 m .496 .56903 L .50744 .57623 L p .524 0 0 r
F P
0 g
s
.48893 .55438 m .49031 .55654 L .496 .56903 L p .708 .339 0 r
F P
0 g
s
.49031 .55654 m .48893 .55438 L .49177 .53813 L p .929 .828 .375 r
F P
0 g
s
.48301 .61134 m .41201 .67708 L .42789 .68474 L p .552 .257 .42 r
F P
0 g
s
.42789 .68474 m .49913 .61837 L .48301 .61134 L p .552 .257 .42 r
F P
0 g
s
.53928 .60965 m .61426 .69583 L .60759 .69868 L p .282 .454 .854 r
F P
0 g
s
.60759 .69868 m .53312 .61312 L .53928 .60965 L p .282 .454 .854 r
F P
0 g
s
.50342 .52753 m .50768 .52462 L .52371 .52368 L p .474 .862 .976 r
F P
0 g
s
.50768 .52462 m .50342 .52753 L .49177 .53813 L p 0 0 0 r
F P
0 g
s
.496 .56903 m .49606 .57004 L .48893 .55438 L p .708 .339 0 r
F P
0 g
s
.64864 .66512 m .57392 .57902 L .57563 .57552 L p .848 .387 .031 r
F P
0 g
s
.02 w
.54082 .57868 m
.66571 .72238 L
s
.5 Mabswid
.53826 .53353 m .53797 .53273 L .52371 .52368 L p .477 0 0 r
F P
0 g
s
.53797 .53273 m .53826 .53353 L .54401 .5461 L p .656 .295 0 r
F P
0 g
s
.54401 .5461 m .54509 .54831 L .53797 .53273 L p .656 .295 0 r
F P
0 g
s
.38062 .64128 m .45226 .57609 L .44901 .56088 L p .899 .879 .807 r
F P
0 g
s
.45226 .57609 m .38062 .64128 L .39406 .66056 L p .821 .675 .702 r
F P
0 g
s
.54509 .54831 m .54401 .5461 L .54182 .55919 L p .903 .809 .334 r
F P
0 g
s
.54182 .55919 m .54238 .56456 L .54509 .54831 L p .903 .809 .334 r
F P
0 g
s
.52641 .57797 m .5308 .5753 L .51473 .57639 L p .444 .854 .964 r
F P
0 g
s
.51473 .57639 m .51041 .57905 L .52641 .57797 L p .444 .854 .964 r
F P
0 g
s
.52677 .52624 m .52371 .52368 L .50768 .52462 L p .417 0 0 r
F P
0 g
s
.52371 .52368 m .52677 .52624 L .53826 .53353 L p .477 0 0 r
F P
0 g
s
.49599 .53526 m .49177 .53813 L .48893 .55438 L p .002 0 .363 r
F P
0 g
s
.49177 .53813 m .49599 .53526 L .50768 .52462 L p 0 0 0 r
F P
0 g
s
.02 w
.49995 .53165 m
.52569 .56127 L
s
.49781 .52918 m
.49972 .53138 L
s
.49562 .52666 m
.49781 .52918 L
s
.5 Mabswid
.456 .43766 m .50849 .49814 L .50627 .50107 L p .848 .387 .031 r
F P
0 g
s
.54238 .56456 m .54182 .55919 L .53249 .56783 L p .894 .972 .823 r
F P
0 g
s
.53249 .56783 m .5308 .5753 L .54238 .56456 L p .894 .972 .823 r
F P
0 g
s
.51041 .57905 m .51473 .57639 L .50032 .56732 L p .349 .6 .941 r
F P
0 g
s
.50032 .56732 m .49606 .57004 L .51041 .57905 L p .349 .6 .941 r
F P
0 g
s
.03 w
.49428 .57228 m
.4961 .5706 L
s
.5 Mabswid
.57392 .57902 m .64864 .66512 L .63977 .67497 L p .829 .587 .573 r
F P
0 g
s
.51386 .527 m .50768 .52462 L .49599 .53526 L p .412 .072 .277 r
F P
0 g
s
.50768 .52462 m .51386 .527 L .52677 .52624 L p .417 0 0 r
F P
0 g
s
.49315 .55158 m .48893 .55438 L .49606 .57004 L p .208 .298 .738 r
F P
0 g
s
.48893 .55438 m .49315 .55158 L .49599 .53526 L p .002 0 .363 r
F P
0 g
s
.50627 .50107 m .45339 .44014 L .456 .43766 L p .848 .387 .031 r
F P
0 g
s
.49606 .57004 m .50032 .56732 L .49315 .55158 L p .208 .298 .738 r
F P
0 g
s
.03 w
.4961 .5706 m
.49818 .56869 L
s
.5 Mabswid
.41834 .47065 m .4714 .53164 L .46569 .53566 L p .282 .454 .854 r
F P
0 g
s
.46569 .53566 m .41299 .47511 L .41834 .47065 L p .282 .454 .854 r
F P
0 g
s
.02 w
.43452 .45636 m
.49562 .52666 L
s
.5 Mabswid
.53433 .5379 m .53826 .53353 L .52677 .52624 L p .83 .452 .337 r
F P
0 g
s
.53826 .53353 m .53433 .5379 L .53753 .54491 L p .934 .629 .439 r
F P
0 g
s
.53753 .54491 m .54401 .5461 L .53826 .53353 L p .934 .629 .439 r
F P
0 g
s
.5308 .5753 m .53249 .56783 L .51955 .56869 L p .735 .83 .923 r
F P
0 g
s
.51955 .56869 m .51473 .57639 L .5308 .5753 L p .735 .83 .923 r
F P
0 g
s
.55135 .60021 m .62658 .68675 L .61426 .69583 L p .613 .574 .787 r
F P
0 g
s
.61426 .69583 m .53928 .60965 L .55135 .60021 L p .613 .574 .787 r
F P
0 g
s
.54401 .5461 m .53753 .54491 L .5363 .5522 L p .949 .772 .628 r
F P
0 g
s
.5363 .5522 m .54182 .55919 L .54401 .5461 L p .949 .772 .628 r
F P
0 g
s
.49913 .61837 m .42789 .68474 L .43568 .68049 L p 0 0 0 r
F P
0 g
s
.43568 .68049 m .50749 .61354 L .49913 .61837 L p 0 0 0 r
F P
0 g
s
.52792 .53384 m .52677 .52624 L .51386 .527 L p .711 .362 .384 r
F P
0 g
s
.52677 .52624 m .52792 .53384 L .53433 .5379 L p .83 .452 .337 r
F P
0 g
s
.03 w
.50012 .5669 m
.53277 .53691 L
s
.5 Mabswid
.63977 .67497 m .56464 .58846 L .57392 .57902 L p .829 .587 .573 r
F P
0 g
s
.50446 .53558 m .49599 .53526 L .49315 .55158 L p .446 .284 .567 r
F P
0 g
s
.49599 .53526 m .50446 .53558 L .51386 .527 L p .412 .072 .277 r
F P
0 g
s
.54182 .55919 m .5363 .5522 L .53111 .557 L p .877 .795 .765 r
F P
0 g
s
.53111 .557 m .53249 .56783 L .54182 .55919 L p .877 .795 .765 r
F P
0 g
s
.48733 .64329 m .58218 .75195 L .56576 .77278 L p .86 .573 .5 r
F P
0 g
s
.51473 .57639 m .51955 .56869 L .50796 .56138 L p .603 .647 .866 r
F P
0 g
s
.50796 .56138 m .50032 .56732 L .51473 .57639 L p .603 .647 .866 r
F P
0 g
s
.44901 .56088 m .3767 .62634 L .38062 .64128 L p .899 .879 .807 r
F P
0 g
s
.3767 .62634 m .44901 .56088 L .45689 .55546 L p 0 0 0 r
F P
0 g
s
.52073 .53428 m .51386 .527 L .50446 .53558 L p .638 .374 .502 r
F P
0 g
s
.51386 .527 m .52073 .53428 L .52792 .53384 L p .711 .362 .384 r
F P
0 g
s
.56464 .58846 m .63977 .67497 L .62658 .68675 L p .731 .594 .703 r
F P
0 g
s
.50219 .54872 m .49315 .55158 L .50032 .56732 L p .511 .469 .747 r
F P
0 g
s
.49315 .55158 m .50219 .54872 L .50446 .53558 L p .446 .284 .567 r
F P
0 g
s
.50032 .56732 m .50796 .56138 L .50219 .54872 L p .511 .469 .747 r
F P
0 g
s
.62658 .68675 m .55135 .60021 L .56464 .58846 L p .731 .594 .703 r
F P
0 g
s
.45339 .44014 m .50627 .50107 L .49662 .51014 L p .829 .587 .573 r
F P
0 g
s
.53249 .56783 m .53111 .557 L .52391 .55747 L p .78 .731 .808 r
F P
0 g
s
.52391 .55747 m .51955 .56869 L .53249 .56783 L p .78 .731 .808 r
F P
0 g
s
.53433 .5379 m .52792 .53384 L p .51747 .5534 L .779 .595 .651 r
F P
0 g
s
.53753 .54491 m .53433 .5379 L p .51747 .5534 L .779 .595 .651 r
F P
0 g
s
.5363 .5522 m .53753 .54491 L p .51747 .5534 L .779 .595 .651 r
F P
0 g
s
.52792 .53384 m .52073 .53428 L p .51747 .5534 L .779 .595 .651 r
F P
0 g
s
.01 w
.52592 .54564 m
.52937 .54341 L
s
.5 Mabswid
.51551 .53905 m .50446 .53558 L .50219 .54872 L p .619 .443 .621 r
F P
0 g
s
.50446 .53558 m .51551 .53905 L .52073 .53428 L p .638 .374 .502 r
F P
0 g
s
.53111 .557 m .5363 .5522 L p .51747 .5534 L .779 .595 .651 r
F P
0 g
s
.56576 .77278 m .46945 .66263 L .48733 .64329 L p .86 .573 .5 r
F P
0 g
s
.43 .46062 m .48324 .52187 L .4714 .53164 L p .613 .574 .787 r
F P
0 g
s
.4714 .53164 m .41834 .47065 L .43 .46062 L p .613 .574 .787 r
F P
0 g
s
.49662 .51014 m .44345 .44891 L .45339 .44014 L p .829 .587 .573 r
F P
0 g
s
.51955 .56869 m .52391 .55747 L .51747 .5534 L p .698 .636 .784 r
F P
0 g
s
.51747 .5534 m .50796 .56138 L .51955 .56869 L p .698 .636 .784 r
F P
0 g
s
.52073 .53428 m .51551 .53905 L p .51747 .5534 L .779 .595 .651 r
F P
0 g
s
.51747 .5534 m .52391 .55747 L .53111 .557 L p .779 .595 .651 r
F P
0 g
s
.51426 .54636 m .50219 .54872 L .50796 .56138 L p .642 .535 .718 r
F P
0 g
s
.50219 .54872 m .51426 .54636 L .51551 .53905 L p .619 .443 .621 r
F P
0 g
s
.50796 .56138 m .51747 .5534 L .51426 .54636 L p .642 .535 .718 r
F P
0 g
s
.51551 .53905 m .51426 .54636 L .51747 .5534 L p .779 .595 .651 r
F P
0 g
s
.32756 .46029 m .42368 .57038 L .40482 .5887 L p .86 .573 .5 r
F P
0 g
s
.44345 .44891 m .49662 .51014 L .48324 .52187 L p .731 .594 .703 r
F P
0 g
s
.56675 .49417 m .53753 .5138 L .55236 .52324 L p .37 .605 .939 r
F P
0 g
s
.55236 .52324 m .58203 .50395 L .56675 .49417 L p .37 .605 .939 r
F P
0 g
s
.58203 .50395 m .55236 .52324 L .55979 .53947 L p .233 .314 .742 r
F P
0 g
s
.48324 .52187 m .43 .46062 L .44345 .44891 L p .731 .594 .703 r
F P
0 g
s
.55979 .53947 m .58972 .5207 L .58203 .50395 L p .233 .314 .742 r
F P
0 g
s
.58972 .5207 m .55979 .53947 L .55699 .55638 L p .042 0 .388 r
F P
0 g
s
.50749 .61354 m .43568 .68049 L .43216 .66564 L p .904 .891 .807 r
F P
0 g
s
.43216 .66564 m .50465 .59839 L .50749 .61354 L p .904 .891 .807 r
F P
0 g
s
.54962 .49509 m .52087 .51475 L .53753 .5138 L p .475 .862 .976 r
F P
0 g
s
.53753 .5138 m .56675 .49417 L .54962 .49509 L p .475 .862 .976 r
F P
0 g
s
.34931 .70163 m .38196 .67167 L .36843 .65237 L p .821 .675 .702 r
F P
0 g
s
.38196 .67167 m .34931 .70163 L .36735 .71843 L p .727 .511 .599 r
F P
0 g
s
.36735 .71843 m .39993 .68827 L .38196 .67167 L p .727 .511 .599 r
F P
0 g
s
.55699 .55638 m .5869 .53813 L .58972 .5207 L p .042 0 .388 r
F P
0 g
s
.5869 .53813 m .55699 .55638 L .54498 .56755 L p 0 0 0 r
F P
0 g
s
.38399 .62149 m .45689 .55546 L .47313 .5622 L p .541 .239 .403 r
F P
0 g
s
.45689 .55546 m .38399 .62149 L .3767 .62634 L p 0 0 0 r
F P
0 g
s
.03 w
.44643 .61623 m
.49428 .57228 L
s
.5 Mabswid
.40482 .5887 m .30722 .47706 L .32756 .46029 L p .86 .573 .5 r
F P
0 g
s
.39993 .68827 m .36735 .71843 L .38306 .7265 L p .552 .257 .42 r
F P
0 g
s
.38306 .7265 m .41576 .69604 L .39993 .68827 L p .552 .257 .42 r
F P
0 g
s
.53716 .50645 m .50872 .52581 L .52087 .51475 L p 0 0 0 r
F P
0 g
s
.52087 .51475 m .54962 .49509 L .53716 .50645 L p 0 0 0 r
F P
0 g
s
.33556 .68229 m .36843 .65237 L .36439 .63749 L p .899 .879 .807 r
F P
0 g
s
.36843 .65237 m .33556 .68229 L .34931 .70163 L p .821 .675 .702 r
F P
0 g
s
.54498 .56755 m .57458 .54961 L .5869 .53813 L p 0 0 0 r
F P
0 g
s
.57458 .54961 m .54498 .56755 L .52826 .56866 L p .443 .854 .963 r
F P
0 g
s
.41905 .7038 m .55693 .86095 L .53796 .88627 L p .857 .574 .508 r
F P
0 g
s
.5342 .52397 m .50579 .5428 L .50872 .52581 L p .001 0 .362 r
F P
0 g
s
.50872 .52581 m .53716 .50645 L .5342 .52397 L p .001 0 .362 r
F P
0 g
s
.5574 .5507 m .52826 .56866 L .51327 .5592 L p .349 .6 .941 r
F P
0 g
s
.52826 .56866 m .5574 .5507 L .57458 .54961 L p .443 .854 .963 r
F P
0 g
s
.50465 .59839 m .43216 .66564 L .41848 .64582 L p .825 .678 .701 r
F P
0 g
s
.41848 .64582 m .49148 .57868 L .50465 .59839 L p .825 .678 .701 r
F P
0 g
s
.54194 .5409 m .51327 .5592 L .50579 .5428 L p .207 .298 .737 r
F P
0 g
s
.50579 .5428 m .5342 .52397 L .54194 .5409 L p .207 .298 .737 r
F P
0 g
s
.01 w
.53997 .53658 m
.5578 .52509 L
s
.5 Mabswid
.51327 .5592 m .54194 .5409 L .5574 .5507 L p .349 .6 .941 r
F P
0 g
s
.39997 .62887 m .47313 .5622 L .49148 .57868 L p .728 .509 .594 r
F P
0 g
s
.47313 .5622 m .39997 .62887 L .38399 .62149 L p .541 .239 .403 r
F P
0 g
s
.41576 .69604 m .38306 .7265 L .39048 .72262 L p 0 0 0 r
F P
0 g
s
.39048 .72262 m .42345 .69188 L .41576 .69604 L p 0 0 0 r
F P
0 g
s
.53796 .88627 m .39769 .72668 L .41905 .7038 L p .857 .574 .508 r
F P
0 g
s
.49148 .57868 m .41848 .64582 L .39997 .62887 L p .728 .509 .594 r
F P
0 g
s
.36439 .63749 m .3312 .66753 L .33556 .68229 L p .899 .879 .807 r
F P
0 g
s
.3312 .66753 m .36439 .63749 L .37158 .63273 L p 0 0 0 r
F P
0 g
s
.21707 .47361 m .35726 .63338 L .33482 .65515 L p .857 .574 .508 r
F P
0 g
s
.33482 .65515 m .19217 .49285 L .21707 .47361 L p .857 .574 .508 r
F P
0 g
s
.42345 .69188 m .39048 .72262 L .38654 .70797 L p .904 .891 .807 r
F P
0 g
s
.38654 .70797 m .41982 .67709 L .42345 .69188 L p .904 .891 .807 r
F P
0 g
s
.03 w
.37733 .67971 m
.41635 .64387 L
s
.5 Mabswid
.37158 .63273 m .33811 .66304 L .3312 .66753 L p 0 0 0 r
F P
0 g
s
.33811 .66304 m .37158 .63273 L .38751 .64022 L p .541 .239 .403 r
F P
0 g
s
.26064 .77112 m .26684 .77953 L .35655 .6988 L closepath p .799 .674 .726 r
F P
0 g
s
.25845 .76498 m .26064 .77112 L .35655 .6988 L closepath p .865 .871 .841 r
F P
0 g
s
.26114 .76346 m .25845 .76498 L .35655 .6988 L closepath p 0 0 0 r
F P
0 g
s
.26774 .76719 m .26114 .76346 L .35655 .6988 L closepath p .56 .223 .354 r
F P
0 g
s
.26684 .77953 m .27472 .78703 L .35655 .6988 L closepath p .708 .514 .624 r
F P
0 g
s
.27572 .77478 m .26774 .76719 L .35655 .6988 L closepath p .746 .504 .565 r
F P
0 g
s
.27472 .78703 m .28131 .79081 L .35655 .6988 L closepath p .532 .269 .462 r
F P
0 g
s
.28198 .78328 m .27572 .77478 L .35655 .6988 L closepath p .846 .678 .673 r
F P
0 g
s
.28131 .79081 m .2841 .7894 L .35655 .6988 L closepath p 0 0 0 r
F P
0 g
s
.2841 .7894 m .28198 .78328 L .35655 .6988 L closepath p .936 .893 .762 r
F P
0 g
s
.03 w
.35655 .6988 m
.37733 .67971 L
s
.5 Mabswid
.73106 .65531 m .56696 .56789 L .59869 .53822 L p .607 .328 .468 r
F P
0 g
s
.59869 .53822 m .76323 .62313 L .73106 .65531 L p .607 .328 .468 r
F P
0 g
s
.41982 .67709 m .38654 .70797 L .37252 .68808 L p .825 .678 .701 r
F P
0 g
s
.37252 .68808 m .40605 .65725 L .41982 .67709 L p .825 .678 .701 r
F P
0 g
s
.50114 .31922 m .54986 .48181 L .51766 .51107 L p .89 .83 .781 r
F P
0 g
s
.35391 .67084 m .38751 .64022 L .40605 .65725 L p .728 .509 .594 r
F P
0 g
s
.38751 .64022 m .35391 .67084 L .33811 .66304 L p .541 .239 .403 r
F P
0 g
s
.40605 .65725 m .37252 .68808 L .35391 .67084 L p .728 .509 .594 r
F P
0 g
s
.51766 .51107 m .46628 .34905 L .50114 .31922 L p .89 .83 .781 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->0,
  ImageSize->{288, 274.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00S`3oool00`000000oooo0?ooo`2>0?ooo`00SP3oool00`000000hmC70?ooo`2?0?ooo`00
S@3oool010000000hmC70>?Da`00002?0?ooo`00S03oool01@000000hmC70>?Da`3Se<L0000008l0
oooo002:0?ooo`800000103Se<L00`000000oooo0?ooo`2=0?ooo`00R@3oool00`000000hmC70>?D
a`040>?Da`030000003oool0oooo08d0oooo00280?ooo`030000003Se<L0hmC700H0hmC700<00000
0?ooo`3oool0S03oool008L0oooo00<000000>?Da`3Se<L01`3Se<L00`000000oooo0?ooo`2<0?oo
o`00QP3oool00`000000hmC70>?Da`080>?Da`030000003oool0oooo08`0oooo00250?ooo`030000
003Se<L0hmC700X0hmC700<000000?ooo`3oool0R`3oool008D0oooo00<000000>?Da`3Se<L02P3S
e<L00`000000oooo0?ooo`2;0?ooo`00QP3oool00`000000hmC70>?Da`090>?Da`030000003oool0
oooo08/0oooo00260?ooo`030000003Se<L0hmC700X0hmC700<000000?ooo`3oool0RP3oool008H0
oooo00<000000>?Da`3Se<L02P3Se<L00`000000oooo0?ooo`2:0?ooo`00Q`3oool00`000000hmC7
0>?Da`090>?Da`030000003oool0oooo08X0oooo00270?ooo`030000003Se<L0hmC700T0hmC700<0
00000?ooo`3oool0RP3oool008L0oooo00<000000>?Da`3Se<L02P3Se<L00`000000oooo0?ooo`29
0?ooo`00R03oool00`000000hmC70>?Da`090>?Da`030000003oool0oooo08T0oooo00280?ooo`03
0000003Se<L0hmC700T0hmC700<000000?ooo`3oool0R@3oool008P0oooo00<000000>?Da`3Se<L0
2P3Se<L00`000000oooo0?ooo`280?ooo`00R@3oool00`000000hmC70>?Da`090>?Da`030000003o
ool0oooo08P0oooo00290?ooo`030000003Se<L0hmC700T0hmC700<000000?ooo`3oool0R03oool0
08T0oooo00<000000>?Da`3Se<L02P3Se<L00`000000oooo0?ooo`270?ooo`00RP3oool00`000000
hmC70>?Da`090>?Da`030000003oool0oooo08L0oooo002:0?ooo`030000003Se<L0hmC700T0hmC7
00<000000?ooo`3oool0Q`3oool008X0oooo00<000000>?Da`3Se<L02@3Se<L00`000000oooo0?oo
o`270?ooo`00R`3oool00`000000hmC70>?Da`090>?Da`030000003oool0oooo08H0oooo002;0?oo
o`030000003Se<L0hmC700T0hmC700<000000?ooo`3oool0QP3oool008/0oooo00<000000>?Da`3S
e<L02@3Se<L00`000000oooo0?ooo`260?ooo`00S03oool00`000000hmC70>?Da`090>?Da`030000
003oool0oooo08D0oooo002<0?ooo`030000003Se<L0hmC700T0hmC700<000000?ooo`3oool0Q@3o
ool008`0oooo00<000000>?Da`3Se<L02@3Se<L00`000000oooo0?ooo`250?ooo`00S03oool00`00
0000hmC70>?Da`0:0>?Da`030000003oool0oooo08@0oooo002=0?ooo`030000003Se<L0hmC700T0
hmC700<000000?ooo`3oool0Q03oool00880oooo00<000000?ooo`3oool0203oool00`000000hmC7
0>?Da`090>?Da`030000003oool0oooo08@0oooo00210?ooo`<000002@3oool00`000000hmC70>?D
a`090>?Da`030000003oool0oooo08@0oooo001l0?ooo`030000003oool0oooo00<0000000<0e9JB
0000000000002@3oool00`000000hmC70>?Da`090>?Da`030000003oool0oooo08<0oooo001k0?oo
o`D00000103DUY82000000P0oooo00<000000>?Da`3Se<L02@3Se<L00`000000oooo0?ooo`230?oo
o`00NP3oool5000000030;^H/`000000e9JB00<0e9JB0P0000070?ooo`030000003Se<L0hmC700T0
hmC700<000000?ooo`3oool03`3oool200000780oooo001i0?ooo`D000000`2kV;<00`000000e9JB
0=BFTP020=BFTP030000003oool0oooo00H0oooo00<000000>?Da`3Se<L02@3Se<L00`000000oooo
0?ooo`0=0?ooo`0300000029AWP0RDIh00800000L03oool007X0oooo0`0000040;^H/`030000003D
UY80e9JB0080e9JB0P0000070?ooo`030000003Se<L0hmC700T0hmC700<000000?ooo`3oool0303o
ool01`000000RDIh08U6N029AWP000000;F3W`000000K`3oool005h0oooo00<000000?ooo`3oool0
6P3oool00`000000^iRc0;^H/`040;^H/`030000003DUY80e9JB0080e9JB0P0000060?ooo`030000
003Se<L0hmC700T0hmC700<000000?ooo`3oool02`3oool200000080RDIh00D000000;F3W`2ePil0
]H>O0000001^0?ooo`00G03oool2000000030=bBO`000000oooo01T0oooo00<0000009bBb@000000
1P2kV;<00`000000e9JB0=BFTP020=BFTP8000001P3oool00`000000hmC70>?Da`090>?Da`030000
003oool0oooo00X0oooo00@0000008U6N029AWP000000`2ePil2000006h0oooo001K0?ooo`030000
003LTWl0g99o0080g99o00<000000?ooo`3oool05@3oool2000000<0W9;900<000000;^H/`2kV;<0
102kV;<00`000000e9JB0=BFTP020=BFTP8000001@3oool00`000000hmC70>?Da`090>?Da`030000
003oool0oooo00T0oooo00@0000008U6N029AWP000000`2ePil010000000c:bi0<b/^@00001]0?oo
o`00?P3oool00`000000oooo0?ooo`0H0?ooo`8000001P3LTWl00`000000oooo0?ooo`0C0?ooo`80
00001@2LT/T00`000000^iRc0;^H/`040;^H/`030000003DUY80e9JB0080e9JB0P0000040?ooo`03
0000003Se<L0hmC700T0hmC700<000000?ooo`3oool0203oool010000000RDIh08U6N00000020;F3
W`8000000P3<[;T2000006d0oooo000m0?ooo`030000003KTX80000001P0oooo00<000000=bBO`3L
TWl01P3LTWl00`000000oooo0?ooo`0B0?ooo`0400000018M=X0B7CJ000000D0W9;900<000000;^H
/`2kV;<0102kV;<00`000000e9JB0=BFTP020=BFTP800000103oool00`000000hmC70>?Da`080>?D
a`030000003oool0oooo00L0oooo00@0000008U6N029AWP000000P2ePil00`000000c:bi0<b/^@02
000000030=cMe`000000oooo06`0oooo000l0?ooo`050000003KTX80fi:20=^BPP000000603oool0
0`000000g99o0=bBO`060=bBO`030000003oool0oooo0180oooo00@0000004QdfP18M=X00000102L
T/T00`000000^iRc0;^H/`040;^H/`030000003DUY80e9JB00<0e9JB0P0000030?ooo`030000003S
e<L0hmC700T0hmC700<000000?ooo`3oool01P3oool00`000000RDIh000000020;F3W`050000003<
[;T0c:bi0000003LgML00P00001^0?ooo`00>P3oool2000000D0fi:200<000000?ooo`3oool05P3o
ool00`000000g99o0=bBO`060=bBO`030000003oool0oooo0180oooo00@0000004QdfP18M=X00000
102LT/T00`000000^iRc0;^H/`040;^H/`030000003DUY80e9JB00<0e9JB00D000000?ooo`3oool0
oooo0000000;0>?Da`030000003oool0oooo00D0oooo00<0000008U6N00000000P2ePil01@000000
c:bi0<b/^@000000g=gG00800000K`3oool003T0oooo00<000000=^BPP3KTX801@3KTX800`000000
oooo0?ooo`0G0?ooo`030000003LTWl0g99o00H0g99o00<000000?ooo`3oool04P3oool010000000
B7CJ04QdfP00000409bBb@030000002kV;<0^iRc00@0^iRc00<000000=BFTP3DUY800P3DUY820000
00<0oooo00<000000>?Da`3Se<L01`3Se<L00`000000oooo0?ooo`050?ooo`0300000029AWP00000
0080]H>O00<000000<b/^@0000000`00001a0?ooo`00>03oool00`000000fi:20=^BPP070=^BPP03
0000003oool0oooo01H0oooo00<000000=bBO`3LTWl01`3LTWl00`000000oooo0?ooo`0B0?ooo`03
00000018M=X0000000D0W9;900<000000;^H/`2kV;<0102kV;<00`000000e9JB0=BFTP020=BFTP80
00000P3oool00`000000hmC70>?Da`060>?Da`030000003oool0oooo00D0oooo00<0000008U6N000
00000P2ePil010000000c:bi0000003LgML200000780oooo000g0?ooo`030000003KTX80fi:200T0
fi:200<000000?ooo`3oool05P3oool00`000000g99o0=bBO`070=bBO`030000003oool0oooo0140
oooo00@0000004QdfP18M=X000001@2LT/T00`000000^iRc0;^H/`040;^H/`030000003DUY80e9JB
0080e9JB0P0000000`3oool000000>?Da`060>?Da`030000003oool0oooo00<0oooo1@0000020;F3
W`030000003<[;T0000000800000M03oool003P0oooo00<000000=^BPP3KTX802@3KTX800`000000
oooo0?ooo`0F0?ooo`030000003LTWl0g99o00L0g99o00<000000?ooo`3oool04@3oool010000000
B7CJ04QdfP00000509bBb@030000002kV;<0^iRc00@0^iRc00<000000=BFTP3DUY800P3DUY820000
00030?ooo`000000hmC700<0hmC70P0000030?ooo`D0000000<0GY[`0000000000001P00001e0?oo
o`00>@3oool00`000000fi:20=^BPP090=^BPP030000003oool0oooo01H0oooo00<000000=bBO`3L
TWl01`3LTWl00`000000oooo0?ooo`0A0?ooo`0400000018M=X0B7CJ000000D0W9;900<000000;^H
/`2kV;<00`2kV;<00`000000e9JB0=BFTP030=BFTP030000003oool0000000<0hmC700@000000?oo
o`3oool0oooo0P00000207WLn@030000001NV_00GY[`00<0GY[`1000001g0?ooo`00>P3oool00`00
0000fi:20=^BPP090=^BPP030000003oool0oooo01H0oooo00<000000=bBO`3LTWl01P3LTWl00`00
0000oooo0?ooo`0B0?ooo`0400000018M=X0B7CJ000000D0W9;900<000000;^H/`2kV;<00`2kV;<0
1@000000e9JB0=BFTP3DUY8000000080oooo00@000000>?Da`3Se<L000000P3oool300000080NMci
00<0000005jJl01NV_001P1NV_000`000000oooo0?ooo`1f0?ooo`00>P3oool00`000000fi:20=^B
PP0:0=^BPP030000003oool0oooo01H0oooo00<000000=bBO`3LTWl01P3LTWl00`000000oooo0?oo
o`0B0?ooo`0400000018M=X0B7CJ000000@0W9;900<000000;^H/`2kV;<0102kV;<00`000000e9JB
000000040?ooo`8000000P3oool30000000307WLn@000000000000L0GY[`0`00001h0?ooo`00>`3o
ool00`000000fi:20=^BPP0:0=^BPP030000003oool0oooo01H0oooo00<000000=bBO`3LTWl01P3L
TWl00`000000oooo0?ooo`0B0?ooo`0400000018M=X0B7CJ000000@0W9;900<000000;^H/`2kV;<0
102kV;<00`000000oooo0?ooo`030?ooo`030000003oool0000000D00000201NV_001@000000>e2m
03]@_@0kD;d0000007L0oooo000l0?ooo`030000003KTX80fi:200T0fi:200<000000?ooo`3oool0
5`3oool00`000000g99o0=bBO`060=bBO`030000003oool0oooo0180oooo00@0000004QdfP18M=X0
0000102LT/T010000000^iRc0;^H/`2kV;<2000000L0oooo0`0000020000G0030000001NV_00GY[`
00D0GY[`0P00000403]@_@030000003oool0oooo07D0oooo000m0?ooo`030000003KTX80fi:200T0
fi:200<000000?ooo`3oool05P3oool00`000000g99o0=bBO`070=bBO`030000003oool0oooo0180
oooo00<0000004QdfP0000001@2LT/T00`000000^iRc00000003000000D0oooo0P0000030000G003
0000003oool0000000D0GY[`00<0000003]@_@0kD;d01@0kD;d00`000000oooo0?ooo`1d0?ooo`00
?P3oool00`000000fi:20=^BPP090=^BPP030000003oool0oooo01H0oooo00<000000=bBO`3LTWl0
1`3LTWl00`000000oooo0?ooo`0A0?ooo`0400000018M=X0B7CJ000000D0W9;91`0000020?ooo`80
0000100005`00`000000oooo0?ooo`020000000305jJl0000000000000P0>e2m00<000000?ooo`3o
ool0M03oool003l0oooo00<000000=^BPP3KTX802@3KTX800`000000oooo0?ooo`0F0?ooo`030000
003LTWl0g99o00L0g99o00<000000?ooo`3oool04@3oool010000000B7CJ04QdfP00000309bBb@X0
00001P0005`00`000000oooo00000006000000D0>e2m00<0000000X0H`000000MP3oool00400oooo
00<000000=^BPP3KTX802@3KTX800`000000oooo0?ooo`0F0?ooo`030000003LTWl0g99o00L0g99o
00<000000?ooo`3oool04@3oool