(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3488442,     103159]*)
(*NotebookOutlinePosition[   3489092,     103182]*)
(*  CellTagsIndexPosition[   3489048,     103178]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Mechanics: Small Oscillations:", "Title"],

Cell[CellGroupData[{

Cell[TextData[{
  "1 Eigenvalues and eigenvectors for small oscillating systems ",
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]],
  " ",
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]]
}], "Subsection",
  Evaluatable->False,
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(smallOsc[T_, V_, coord_List, equlib_List, 
        t_:  t] := \[IndentingNewLine]Module[{q, p, dim, equlibRule, Vij, 
          Tij, matrix, \[Omega]2Sol, freq, vector, eqs, 
          vSol}, \[IndentingNewLine]q = coord; \[IndentingNewLine]p = 
          D[coord, t]; 
        dim = Length[q]; \[IndentingNewLine]equlibRule = 
          Thread[coord \[Rule] equlib]; \[IndentingNewLine]Vij = 
          Outer[D[V, #1, #2] &, q, q\ ]; \[IndentingNewLine]Tij = 
          Outer[D[T, #1, #2] &, \ p, p\ ]; \[IndentingNewLine]matrix = 
          Vij - \[Omega]2\ Tij /. 
            equlibRule; \[IndentingNewLine]\[Omega]2Sol = 
          Simplify[
            Solve[Det[matrix] == 
                0, \[Omega]2]]; \[IndentingNewLine]freq = \[Omega]2 /. \
\[Omega]2Sol; 
        vector = Array[a, dim]; \[IndentingNewLine]eqs = 
          Simplify[
            ExpandAll[
              Thread[0 == matrix . vector]]]; \[IndentingNewLine]vSol = 
          Table[\[IndentingNewLine]\(Solve[
                Join[eqs /. \[Omega]2Sol[\([i]\)], {vector . vector == 
                      1}]\[IndentingNewLine], vector]\)[\([2]\)], {i, 1, 
              dim}]; \[IndentingNewLine]{freq, vSol}\ ]\)], "Input"],

Cell["Protect[smallOsc ];", "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    RowBox[{
      RowBox[{"T", "=", 
        FormBox[
          RowBox[{
            RowBox[{\(1\/2\), " ", "m", " ", 
              SuperscriptBox[
                RowBox[{
                  SuperscriptBox["q1", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], "2"]}], "+", 
            RowBox[{\(1\/2\), " ", "m", " ", 
              SuperscriptBox[
                RowBox[{
                  SuperscriptBox["q2", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], "2"]}]}],
          "TraditionalForm"]}], ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"V", "=", 
        FormBox[\(1\/2\ k1\ \((q2(t) - q1(t))\)\^2\),
          "TraditionalForm"]}], ";"}]}], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(smallOsc[T, V, {q1[t], q2[t]}, {0, 0}, t]\)], "Input",
  Hyphenation->False],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", \(\(2\ k1\)\/m\)},
            {\({a(1) \[Rule] 1\/\@2, 
                a(2) \[Rule] 1\/\@2}\), \({a(1) \[Rule] 1\/\@2, 
                a(2) \[Rule] \(-\(1\/\@2\)\)}\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Problem 2: Three Coupled Oscillators along a Line  ",
  StyleBox[" ",
    FontColor->RGBColor[0, 1, 0]]
}], "Subsection",
  Evaluatable->False,
  Hyphenation->False,
  AspectRatioFixed->True],

Cell["Remarks and outline ", "Subsubsection",
  Evaluatable->False,
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
  Evaluatable->False,
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input",
  Hyphenation->False],

Cell[BoxData[
    FormBox[
      RowBox[{\(Clear::"wrsym"\), \(\(:\)\(\ \)\), "\<\"Symbol \
\\!\\(TraditionalForm\\`diffSeriesOne\\) is Protected.\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    FormBox[
      RowBox[{\(Clear::"wrsym"\), \(\(:\)\(\ \)\), "\<\"Symbol \
\\!\\(TraditionalForm\\`doublePlot\\) is Protected.\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    FormBox[
      RowBox[{\(Clear::"wrsym"\), \(\(:\)\(\ \)\), "\<\"Symbol \
\\!\\(TraditionalForm\\`phasePlot\\) is Protected.\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    FormBox[
      RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(TraditionalForm\\`\\(Clear :: \\\"wrsym\\\"\\)\\) will be suppressed \
during this calculation.\"\>"}], TraditionalForm]], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part a", "Subsubsection",
  Hyphenation->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"T", "=", 
        RowBox[{
          RowBox[{\(1\/2\), " ", "m", " ", 
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  RowBox[{
                    SuperscriptBox[\(x[1]\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
                SuperscriptBox[
                  RowBox[{
                    SuperscriptBox[\(x[3]\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], "2"]}], 
              ")"}]}], "+", 
          RowBox[{\(1\/2\), " ", "M", " ", 
            SuperscriptBox[
              RowBox[{
                SuperscriptBox[\(x[2]\), "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "2"]}]}]}], " ", 
      ";", "\n", \(V = 
        1\/2\ k\ \((\((\(x[2]\)[t] - \(x[1]\)[t])\)\^2 + \((\(x[3]\)[t] - \
\(x[2]\)[t])\)\^2)\)\), " ", ";"}]], "Input",
  Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(solution\)\(=\)\(smallOsc[T, 
        V, {\(x[1]\)[t], \(x[2]\)[t], \(x[3]\)[t]}, {0, 0, 0}, 
        t]\)\(\ \)\)\)], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", \(k\/m\), \(k\ \((2\/M + 1\/m)\)\)},
            {\({a(1) \[Rule] 1\/\@3, a(3) \[Rule] 1\/\@3, 
                a(2) \[Rule] 1\/\@3}\), \({a(1) \[Rule] 1\/\@2, 
                a(3) \[Rule] \(-\(1\/\@2\)\), 
                a(2) \[Rule] 0}\), \({a(1) \[Rule] 
                  M\/\(\@2\ \@\(2\ m\^2 + M\^2\)\), 
                a(3) \[Rule] M\/\(\@2\ \@\(2\ m\^2 + M\^2\)\), 
                a(2) \[Rule] \(-\(\(\@2\ m\)\/\@\(2\ m\^2 + M\^2\)\)\)}\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part b", "Subsubsection",
  Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(eigenmatrix = \(\(Array[a, 
          3]\)\(/.\)\(solution[\([2]\)]\)\(\ \)\)\)], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(1\/\@3\), \(1\/\@3\), \(1\/\@3\)},
            {\(1\/\@2\), "0", \(-\(1\/\@2\)\)},
            {\(M\/\(\@2\ \@\(2\ m\^2 + M\^2\)\)\), \(-\(\(\@2\ m\)\/\@\(2\ \
m\^2 + M\^2\)\)\), \(M\/\(\@2\ \@\(2\ m\^2 + M\^2\)\)\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xRule = {x1[t], x2[t], x3[t]} \[Rule] 
          Transpose[eigenmatrix] . {c1\ t + \[Phi]1, 
              c2\ Cos[\[Omega]2\ t + \[Phi]2], 
              c3\ Cos[\[Omega]3\ t + \[Phi]3]}\  // Thread\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{x1(
          t) \[Rule] \(c1\ t + \[Phi]1\)\/\@3 + \(c2\ \(cos(\[Phi]2 + t\ \
\[Omega]2)\)\)\/\@2 + \(c3\ M\ \(cos(\[Phi]3 + t\ \[Omega]3)\)\)\/\(\@2\ \
\@\(2\ m\^2 + M\^2\)\), 
      x2(t) \[Rule] \(c1\ t + \[Phi]1\)\/\@3 - \(\@2\ c3\ m\ \(cos(\[Phi]3 + \
t\ \[Omega]3)\)\)\/\@\(2\ m\^2 + M\^2\), 
      x3(t) \[Rule] \(c1\ t + \[Phi]1\)\/\@3 - \(c2\ \(cos(\[Phi]2 + t\ \
\[Omega]2)\)\)\/\@2 + \(c3\ M\ \(cos(\[Phi]3 + t\ \[Omega]3)\)\)\/\(\@2\ \
\@\(2\ m\^2 + M\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(freqrule = {\[Omega]1, \[Omega]2, \[Omega]3} \[Rule] \
\@solution[\([1]\)]\  // Thread\)], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`{\[Omega]1 \[Rule] 
        0, \[Omega]2 \[Rule] \@\(k\/m\), \[Omega]3 \[Rule] \@\(k\ \((2\/M + 1\
\/m)\)\)}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(values = {k \[Rule] 1, m \[Rule] 1, 
          M \[Rule] 3, \[Phi]1 \[Rule] 0, \[Phi]2 \[Rule] 0, \[Phi]3 \[Rule] 
            0};\)\)], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(allRules = Join[xRule, freqrule, values];\)\)], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(xPlot[C1_, C2_, C3_] := 
        Plot[\({x1[t] + 2, x2[t], x3[t] - 2} //. 
                allRules\) //. {c1 \[Rule] C1, c2 \[Rule] C2, 
                c3 \[Rule] C3}\  // Evaluate, \[IndentingNewLine]{t, 0, 
            20}, \[IndentingNewLine]PlotStyle \[Rule] \
{\[IndentingNewLine]{Thickness[0.010], 
                Hue[ .3]}, \[IndentingNewLine]{Thickness[0.009], 
                Hue[ .6]}, \[IndentingNewLine]{Thickness[0.007], 
                Hue[ .9]}}, \[IndentingNewLine]AxesLabel \[Rule] {t\ , 
              x}, \[IndentingNewLine]DisplayFunction -> 
            Identity];\)\)], "Input"],

Cell[BoxData[
    \(\(xLPlot[C1_, C2_, C3_, opts___] := 
        ParametricPlot3D[\({x1[t], x2[t], x3[t]} //. 
                allRules\) //. {c1 \[Rule] C1, c2 \[Rule] C2, 
                c3 \[Rule] C3}\  // Evaluate, \[IndentingNewLine]{t, 0, 
            20}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 
              1}, \[IndentingNewLine]AxesLabel \[Rule] {x1, x2, 
              x3}, \[IndentingNewLine]opts, \
\[IndentingNewLine]DisplayFunction -> Identity];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{xPlot[1, 0, 0], \ 
            xLPlot[1, 0, 0\ \ , Ticks \[Rule] None\ ]}]];\)\)], "Input",
  Hyphenation->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0904343 0.0378596 [
[.2619 .07793 -3 -9 ]
[.2619 .07793 3 0 ]
[.5 .07793 -6 -9 ]
[.5 .07793 6 0 ]
[.7381 .07793 -6 -9 ]
[.7381 .07793 6 0 ]
[.97619 .07793 -6 -9 ]
[.97619 .07793 6 0 ]
[1.025 .09043 0 -4.90625 ]
[1.025 .09043 10 4.90625 ]
[.01131 .18508 -18 -4.5 ]
[.01131 .18508 0 4.5 ]
[.01131 .27973 -6 -4.5 ]
[.01131 .27973 0 4.5 ]
[.01131 .37438 -18 -4.5 ]
[.01131 .37438 0 4.5 ]
[.01131 .46903 -12 -4.5 ]
[.01131 .46903 0 4.5 ]
[.01131 .56368 -24 -4.5 ]
[.01131 .56368 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .09043 m
.2619 .09668 L
s
[(5)] .2619 .07793 0 1 Mshowa
.5 .09043 m
.5 .09668 L
s
[(10)] .5 .07793 0 1 Mshowa
.7381 .09043 m
.7381 .09668 L
s
[(15)] .7381 .07793 0 1 Mshowa
.97619 .09043 m
.97619 .09668 L
s
[(20)] .97619 .07793 0 1 Mshowa
.125 Mabswid
.07143 .09043 m
.07143 .09418 L
s
.11905 .09043 m
.11905 .09418 L
s
.16667 .09043 m
.16667 .09418 L
s
.21429 .09043 m
.21429 .09418 L
s
.30952 .09043 m
.30952 .09418 L
s
.35714 .09043 m
.35714 .09418 L
s
.40476 .09043 m
.40476 .09418 L
s
.45238 .09043 m
.45238 .09418 L
s
.54762 .09043 m
.54762 .09418 L
s
.59524 .09043 m
.59524 .09418 L
s
.64286 .09043 m
.64286 .09418 L
s
.69048 .09043 m
.69048 .09418 L
s
.78571 .09043 m
.78571 .09418 L
s
.83333 .09043 m
.83333 .09418 L
s
.88095 .09043 m
.88095 .09418 L
s
.92857 .09043 m
.92857 .09418 L
s
.25 Mabswid
0 .09043 m
1 .09043 L
s
gsave
1.025 .09043 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .18508 m
.03006 .18508 L
s
[(2.5)] .01131 .18508 1 0 Mshowa
.02381 .27973 m
.03006 .27973 L
s
[(5)] .01131 .27973 1 0 Mshowa
.02381 .37438 m
.03006 .37438 L
s
[(7.5)] .01131 .37438 1 0 Mshowa
.02381 .46903 m
.03006 .46903 L
s
[(10)] .01131 .46903 1 0 Mshowa
.02381 .56368 m
.03006 .56368 L
s
[(12.5)] .01131 .56368 1 0 Mshowa
.125 Mabswid
.02381 .01472 m
.02756 .01472 L
s
.02381 .03364 m
.02756 .03364 L
s
.02381 .05257 m
.02756 .05257 L
s
.02381 .0715 m
.02756 .0715 L
s
.02381 .10936 m
.02756 .10936 L
s
.02381 .12829 m
.02756 .12829 L
s
.02381 .14722 m
.02756 .14722 L
s
.02381 .16615 m
.02756 .16615 L
s
.02381 .20401 m
.02756 .20401 L
s
.02381 .22294 m
.02756 .22294 L
s
.02381 .24187 m
.02756 .24187 L
s
.02381 .2608 m
.02756 .2608 L
s
.02381 .29866 m
.02756 .29866 L
s
.02381 .31759 m
.02756 .31759 L
s
.02381 .33652 m
.02756 .33652 L
s
.02381 .35545 m
.02756 .35545 L
s
.02381 .39331 m
.02756 .39331 L
s
.02381 .41224 m
.02756 .41224 L
s
.02381 .43117 m
.02756 .43117 L
s
.02381 .4501 m
.02756 .4501 L
s
.02381 .48796 m
.02756 .48796 L
s
.02381 .50689 m
.02756 .50689 L
s
.02381 .52582 m
.02756 .52582 L
s
.02381 .54475 m
.02756 .54475 L
s
.02381 .58261 m
.02756 .58261 L
s
.02381 .60154 m
.02756 .60154 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 1 0 r
.01 w
.02381 .16615 m
.06244 .18389 L
.10458 .20323 L
.14415 .22139 L
.18221 .23886 L
.22272 .25746 L
.26171 .27536 L
.30316 .29438 L
.34309 .31271 L
.3815 .33034 L
.42237 .3491 L
.46172 .36716 L
.49955 .38453 L
.53984 .40302 L
.57861 .42082 L
.61984 .43974 L
.65954 .45797 L
.69774 .4755 L
.73838 .49416 L
.77751 .51212 L
.81909 .53121 L
.85916 .5496 L
.89771 .5673 L
.93871 .58612 L
.97619 .60332 L
s
0 .4 1 r
.009 w
.02381 .09043 m
.06244 .10817 L
.10458 .12751 L
.14415 .14567 L
.18221 .16314 L
.22272 .18174 L
.26171 .19964 L
.30316 .21866 L
.34309 .23699 L
.3815 .25462 L
.42237 .27338 L
.46172 .29144 L
.49955 .30881 L
.53984 .3273 L
.57861 .3451 L
.61984 .36402 L
.65954 .38225 L
.69774 .39978 L
.73838 .41844 L
.77751 .4364 L
.81909 .45549 L
.85916 .47388 L
.89771 .49158 L
.93871 .5104 L
.97619 .5276 L
s
1 0 .6 r
.007 w
.02381 .01472 m
.06244 .03245 L
.10458 .05179 L
.14415 .06996 L
.18221 .08742 L
.22272 .10602 L
.26171 .12392 L
.30316 .14294 L
.34309 .16127 L
.3815 .1789 L
.42237 .19766 L
.46172 .21572 L
.49955 .23309 L
.53984 .25158 L
.57861 .26938 L
.61984 .28831 L
.65954 .30653 L
.69774 .32406 L
.73838 .34272 L
.77751 .36068 L
.81909 .37977 L
.85916 .39816 L
.89771 .41586 L
.93871 .43468 L
.97619 .45188 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 7.96346e-17 1.16608 [
[.30907 .06148 -14.3775 -9.8125 ]
[.30907 .06148 1.62253 0 ]
[.2142 1.04697 -8.70051 0 ]
[.2142 1.04697 7.29949 9.8125 ]
[-0.03373 .52941 -16 -3.08918 ]
[-0.03373 .52941 0 6.72332 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
gsave
.30907 .06148 -75.3775 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
0 .80374 m
.40037 1.0855 L
s
gsave
.2142 1.04697 -69.7005 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
.08846 .24555 m
0 .80374 L
s
gsave
-0.03373 .52941 -77 -7.08918 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x3) show
1.000 setlinewidth
grestore
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.10855 .26104 m
.11945 .26944 L
s
.11945 .26944 m
.13036 .27785 L
s
.13036 .27785 m
.1413 .28628 L
s
.1413 .28628 m
.15226 .29473 L
s
.15226 .29473 m
.16324 .30319 L
s
.16324 .30319 m
.17424 .31167 L
s
.17424 .31167 m
.18526 .32017 L
s
.18526 .32017 m
.19631 .32868 L
s
.19631 .32868 m
.20737 .33721 L
s
.20737 .33721 m
.21846 .34576 L
s
.21846 .34576 m
.22957 .35432 L
s
.22957 .35432 m
.2407 .3629 L
s
.2407 .3629 m
.25186 .3715 L
s
.25186 .3715 m
.26303 .38011 L
s
.26303 .38011 m
.27423 .38874 L
s
.27423 .38874 m
.28545 .39739 L
s
.28545 .39739 m
.29669 .40605 L
s
.29669 .40605 m
.30796 .41474 L
s
.30796 .41474 m
.31924 .42344 L
s
.31924 .42344 m
.33055 .43215 L
s
.33055 .43215 m
.34189 .44089 L
s
.34189 .44089 m
.35324 .44964 L
s
.35324 .44964 m
.36462 .45841 L
s
.36462 .45841 m
.37602 .46719 L
s
.37602 .46719 m
.38744 .476 L
s
.38744 .476 m
.39889 .48482 L
s
.39889 .48482 m
.41035 .49366 L
s
.41035 .49366 m
.42185 .50252 L
s
.42185 .50252 m
.43336 .51139 L
s
.43336 .51139 m
.4449 .52029 L
s
.4449 .52029 m
.45646 .5292 L
s
.45646 .5292 m
.46804 .53812 L
s
.46804 .53812 m
.47965 .54707 L
s
.47965 .54707 m
.49128 .55604 L
s
.49128 .55604 m
.50294 .56502 L
s
.50294 .56502 m
.51461 .57402 L
s
.51461 .57402 m
.52632 .58304 L
s
.52632 .58304 m
.53804 .59208 L
s
.53804 .59208 m
.54979 .60113 L
s
.54979 .60113 m
.56156 .61021 L
s
.56156 .61021 m
.57336 .6193 L
s
.57336 .6193 m
.58518 .62841 L
s
.58518 .62841 m
.59703 .63754 L
s
.59703 .63754 m
.60889 .64669 L
s
.60889 .64669 m
.62079 .65586 L
s
.62079 .65586 m
.63271 .66504 L
s
.63271 .66504 m
.64465 .67425 L
s
.64465 .67425 m
.65661 .68347 L
s
.65661 .68347 m
.6686 .69271 L
s
.6686 .69271 m
.68062 .70197 L
s
.68062 .70197 m
.69266 .71125 L
s
.69266 .71125 m
.70472 .72055 L
s
.70472 .72055 m
.71681 .72987 L
s
.71681 .72987 m
.72893 .73921 L
s
.72893 .73921 m
.74107 .74856 L
s
.74107 .74856 m
.75323 .75794 L
s
.75323 .75794 m
.76542 .76733 L
s
.76542 .76733 m
.77764 .77675 L
s
.77764 .77675 m
.78988 .78618 L
s
.78988 .78618 m
.80214 .79564 L
s
.80214 .79564 m
.81443 .80511 L
s
.81443 .80511 m
.82675 .8146 L
s
.82675 .8146 m
.83909 .82412 L
s
.83909 .82412 m
.85146 .83365 L
s
.85146 .83365 m
.86385 .8432 L
s
.86385 .8432 m
.87627 .85277 L
s
.87627 .85277 m
.88872 .86237 L
s
.88872 .86237 m
.90119 .87198 L
s
.90119 .87198 m
.91369 .88161 L
s
.91369 .88161 m
.92621 .89126 L
s
.92621 .89126 m
.93876 .90094 L
s
.93876 .90094 m
.95134 .91063 L
s
.95134 .91063 m
.96394 .92034 L
s
.96394 .92034 m
.97657 .93008 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
gsave
.30907 .06148 -75.3775 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
0 .80374 m
.40037 1.0855 L
s
gsave
.2142 1.04697 -69.7005 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{647, 190.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:70000_R000`400?l00000o`00003oo`3ooooo
0?ooohT0oooo003o0?ooool0ooooR@3oool00?l0ooooo`3ooon90?ooo`00o`3ooooo0?ooohT0oooo
003o0?ooool0ooooR@3oool00?l0ooooo`3oool;0?ooo`800000O03oool00?l0ooooo`3oool90?oo
o`80000000<0oooo000000000000N`3oool00?l0ooooo`3oool70?ooo`8000000`3oool2000007/0
oooo000[0?ooo`030000003oool0oooo0?l0ooooU@3oool2000000030?ooo`00000000000080oooo
1000000e0?ooo`<000001@3oool00`000000oooo0000001j0?ooo`00:`3oool00`000000oooo0?oo
o`3o0?oooiH0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0b0?ooo`800000203o
ool00`000000oooo0000001j0?ooo`00:`3oool00`000000oooo0?ooo`3o0?oooiL0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0_0?ooo`<000002P3oool010000000oooo0?ooo`00
001i0?ooo`00:`3oool00`000000oooo0?ooo`3o0?oooiH0oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`0]0?ooo`8000003@3oool01@000000oooo0?ooo`3oool0000007P0oooo000[
0?ooo`80o`2Io`3ooonF0?ooo`80000000<0oooo000000000000103oool00`000000oooo0?ooo`0[
0?ooo`8000003`3oool01@000000oooo0?ooo`3oool0000007P0oooo000[0?ooo`040000003oool0
o`2I0?l0VOl0ooooV`3oool3000002X0oooo0`00000A0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0M@3oool002/0oooo00@000000?ooo`3oool0oooo0`3o09Wo0?oooiX0oooo00<0
00000?ooo`3oool09P3oool2000001@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1d0?ooo`00:`3oool00`000000oooo0?ooo`040?ooo`80o`2Io`3ooono0?ooo`8000005`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo07@0oooo000[0?ooo`030000003oool0oooo
00H0oooo0`3o09Wo0?oookT0oooo0`00000I0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0L`3oool002/0oooo0P0000090?ooo`<0o`2Io`3ooone0?ooo`800000703oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo07<0oooo000[0?ooo`030000003oool0oooo00/0oooo
0P3o09Wo0?oook00oooo0`00000N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
LP3oool002/0oooo00<000000?ooo`3oool03@3oool20?l0VOl0oooo[03oool200000240oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1a0?ooo`00:`3oool00`000000oooo0?ooo`0?
0?ooo`<0o`2Io`3ooonW0?ooo`8000008`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0740oooo000[0?ooo`030000003oool0oooo0140oooo0`3o09TT0?ooo`<00000=P3oool40000
00<0oooo0P00000d0?ooo`@000000P3oool3000003<0oooo100000030?ooo`800000`P3oool30000
02D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1`0?ooo`00:`3oool2000001@0
oooo0`3o09TU0?ooo`030000003oool0oooo03D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000_`3oool2000002P0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1`0?ooo`00:`3oool00`000000oooo0?ooo`0E0?oo
o`<0o`2I8`3oool00`000000oooo0?ooo`0e0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo00000;d0oooo0P00000Z0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0K`3oool002/0oooo00<000000?ooo`3oool05`3oool3
0?l0VAh0oooo0`00000h0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0c0?ooo`040000003oool0oooo0?ooo`<00000=@3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool0^03oool3000002`0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`1^0?ooo`00:`3oool00`000000oooo0?ooo`0I0?ooo`<0o`2I703oool00`000000oooo
0?ooo`0h0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0c0?ooo`05
0000003oool0oooo0?ooo`000000>03oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo0;H0oooo0P00000_0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0KP3oool0
02/0oooo0P00000L0?ooo`<0o`2I6P3oool00`000000oooo0?ooo`0f0?ooo`<000000`3oool01000
0000oooo0?ooo`00000c0?ooo`<000000`3oool00`000000oooo0?ooo`0c0?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000]@3oool300000340oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`1]0?ooo`00:`3oool00`000000oooo0?ooo`0N0?ooo`80o`2I603o
ool4000003L0oooo00<000000?ooo`3oool00P3oool2000003H0oooo00@000000?ooo`3oool0oooo
1000000c0?ooo`800000103oool200000;@0oooo0P00000d0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0K@3oool002/0oooo00<000000?ooo`3oool0803oool30?l0VOl0ooooP`3o
ool2000003H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1/0?ooo`00:`3oool0
0`000000oooo0?ooo`0S0?ooo`80o`2Io`3ooomn0?ooo`<00000>03oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo06/0oooo000[0?ooo`03001Vo`3oool0oooo02D0oooo0`3o09WI0?oo
o`800000W@3oool2000003/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1[0?oo
o`009@3oool5000000@006Ko9`0000030?l0VLd000002@3oool010000000oooo0?ooo`00002J0?oo
o`800000?@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo06X0oooo000[0?ooo`D0
06Ko1`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0103oool30?l0V@80oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo09P0oooo0`00000o0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0J@3oool002/0oooo00<000000?ooo`00I_l01000I_lW0?ooo`<0o`2I303oool00`000000oooo
0?ooo`0i0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo09H0oooo0P0000120?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0J@3oool002/0oooo00@000000?ooo`3oool0oooo1@00I_lW0?ooo`<0o`2I
c`3oool4000009<0oooo0`0000150?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
J03oool002/0oooo00<000000?ooo`3oool00`3oool5001VobL0oooo0`3o09W>0?ooo`030000003o
ool0oooo0940oooo0P0000180?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0J03o
ool002/0oooo0P0000060?ooo`D006Ko9`3oool30?l0VL`0oooo00<000000?ooo`3oool0S`3oool2
000004X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1W0?ooo`00:`3oool00`00
0000oooo0?ooo`070?ooo`D006Ko9`3oool30?l0VOl0ooooFP3oool3000004`0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`1V0?ooo`00:`3oool00`000000oooo0?ooo`090?ooo`D0
06Ko9`3oool30?l0VOl0ooooEP3oool2000004l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`1V0?ooo`00:`3oool00`000000oooo0?ooo`0<0?ooo`D006Ko9P3oool30?l0VOl0oooo
DP3oool200000540oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1U0?ooo`00:`3o
ool00`000000oooo0?ooo`0>0?ooo`D006Ko9P3oool30?l0VOl0ooooC@3oool3000005<0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`1U0?ooo`00:`3oool200000140oooo1@00I_lV
0?ooo`<0o`2Io`3ooom90?ooo`800000EP3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo06@0oooo000[0?ooo`030000003oool0oooo0180oooo1P00I_lU0?ooo`<0o`2Io`3ooom40?oo
o`<00000F03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo06<0oooo000[0?ooo`03
0000003oool0oooo01D0oooo1@00I_lU0?ooo`<0o`2Io`3ooom00?ooo`800000F`3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo06<0oooo000[0?ooo`030000003oool0oooo01L0oooo
1P00I_lT0?ooo`<0o`2Io`3oooll0?ooo`800000G@3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0680oooo000[0?ooo`030000003oool0oooo01X0oooo1@00I_lT0?ooo`<0o`2Io`3o
oolh0?ooo`800000G`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0680oooo000[
0?ooo`8000007@3oool5001VobD0oooo0P3o09Wo0?ooocH0oooo0P00001O0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0H@3oool002/0oooo00<000000?ooo`3oool07P3oool5001V
obD0oooo0`3o09Wo0?oooc<0oooo00@000000?ooo`0000000000G@3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo0600oooo000[0?ooo`030000003oool0oooo0200oooo1@00I_lV0?oo
o`80o`2Io`3ooola0?ooo`030000003oool0oooo00800000G03oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo0600oooo000[0?ooo`0303?o003oool0oooo0280oooo1@00I_lV0?ooo`<0
o`2Io`3oool]0?ooo`030000003oool0oooo0080oooo0P00001K0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0G`3oool002X0oooo100co`0T0?ooo`D006Ko9P3oool30?l0VOl0oooo
:`3oool00`000000oooo0?ooo`030?ooo`<00000F@3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo05h0oooo000[0?ooo`D0<ol0903oool6001VobD0oooo0`3o09Wo0?ooobT0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0000001H0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0GP3oool002/0oooo00<000000?ooo`0co`00100co`0U0?ooo`D006Ko9@3oool3
0?l0VOl0oooo9`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000005L0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`1M0?ooo`005`3oool4000000<0oooo00<000000?oo
o`3oool00P3oool3000000D0oooo00@000000?ooo`3oool0oooo1@0co`0U0?ooo`H006Ko903oool3
0?l0VOl0oooo9@3oool00`000000oooo0?ooo`060?ooo`030000003oool0000005L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`1M0?ooo`005`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool503?o02H0oooo1@00I_lT0?oo
o`<0o`2Io`3ooolS0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`0000000000E@3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo05`0oooo000H0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool00P3oool3000000D0oooo1@0co`0V0?ooo`D006Ko9@3oool30?l0
VOl0oooo7`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00800000D`3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo05/0oooo000I0?ooo`030000003oool0oooo00L0
oooo0`0000050?ooo`030000003oool0oooo00L0oooo1@0co`0V0?ooo`D006Ko9P3oool20?l0VOl0
oooo7@3oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo000005<0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`1K0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool503?o02H0oooo1@00I_lV0?ooo`<0
o`2Io`3ooolJ0?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool00000DP3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo05X0oooo000G0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`D0<ol09@3oool5001V
obL0oooo0`3o09Wo0?oooaL0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`020000
0500oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1J0?ooo`00603oool2000000T0
oooo100000040?ooo`030000003oool0oooo00h0oooo1@0co`0U0?ooo`D006Ko9`3oool30?l0VOl0
oooo5@3oool00`000000oooo0?ooo`0=0?ooo`050000003oool0oooo0?ooo`000000C`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo05T0oooo000[0?ooo`8000004@3oool503?o02D0
oooo1@00I_lW0?ooo`<0o`2Io`3ooolC0?ooo`030000003oool0oooo00h0oooo00D000000?ooo`3o
ool0oooo0000001>0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0F03oool002/0
oooo00<000000?ooo`3oool04P3oool603?o02@0oooo1@00I_lW0?ooo`<0o`2Io`3oool@0?ooo`03
0000003oool0oooo0100oooo00@000000?ooo`3oool0oooo0P00001<0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0F03oool002/0oooo00<000000?ooo`3oool05@3oool503?o02@0
oooo1@00I_lW0?ooo`<0o`2Io`3oool>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool00P3oool2000004X0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1G0?ooo`00
:`3oool00`000000oooo0?ooo`0G0?ooo`H0<ol08`3oool5001VobL0oooo0`3o09Wo0?ooo``0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1G0?ooo`00:`3oool00`000000oooo0?oo
o`0J0?ooo`D0<ol08`3oool5001VobP0oooo0P3o09Wo0?ooo`X0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`1F0?ooo`00:`3oool2000001d0oooo1@0co`0S0?ooo`H006Ko9`3oool2
0?l0VOl0oooo203oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo0P000017
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0E@3oool002/0oooo00<000000?oo
o`3oool07P3oool503?o02@0oooo1@00I_lW0?ooo`80o`2Io`3oool60?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool0E@3oool002/0oooo00<000000?ooo`3oool0803oool503?o02@0
oooo1P00I_lV0?ooo`<0o`2Io`3oool20?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool0E03oool002/0oooo00<000000?ooo`3oool08P3oool503?o02D0oooo1@00I_lV0?ooo`<0o`2I
o`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo0P0000130?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool0D`3oool002/0oooo00<000000?ooo`3oool0903o
ool503?o02D0oooo1@00I_lV0?ooo`<0o`2Io@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00@0oooo0P0000110?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0D`3o
ool002/0oooo0P00000W0?ooo`D0<ol09@3oool5001VobH0oooo0`3o09Wk0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0
oooo0280oooo00<000000?ooo`3oool0DP3oool002/0oooo00<000000?ooo`3oool0:03oool503?o
02D0oooo1@00I_lV0?ooo`<0o`2In@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
0580oooo000[0?ooo`030000003oool0oooo02X0oooo1@0co`0U0?ooo`D006Ko9P3oool30?l0VOL0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03d0
oooo00<000000?ooo`3oool08@3oool2000005<0oooo000[0?ooo`030000003oool0oooo02`0oooo
1@0co`0U0?ooo`D006Ko9P3oool30?l0VO@0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool07P3oool3000000030?oo
o`000000oooo0580oooo000[0?ooo`800000;`3oool503?o02D0oooo1@00I_lV0?ooo`<0o`2IlP3o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0>`3o
ool00`000000oooo0?ooo`0K0?ooo`<00000103oool00`000000oooo0?ooo`1A0?ooo`00:`3oool0
0`000000oooo0?ooo`0`0?ooo`H0<ol0903oool5001VobH0oooo0`3o09W`0?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool01P3oool2000003/0oooo00<000000?ooo`3oool0603oool3
000000L0oooo00<000000?ooo`3oool0D@3oool002/0oooo00<000000?ooo`3oool0<`3oool503?o
02D0oooo1@00I_lU0?ooo`<0o`2IkP3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo
00L0oooo0P00000i0?ooo`030000003oool0oooo01D0oooo0`00000;0?ooo`030000003oool0oooo
0500oooo000S0?ooo`<000001@3oool00`000000oooo0?ooo`0e0?ooo`H0<ol0903oool5001VobD0
oooo0`3o09W/0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo0180oooo0`00000>0?ooo`030000003oool0oooo0500
oooo000V0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0>03oool503?o02@0oooo
1@00I_lV0?ooo`<0o`2Ij@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0?0?ooo`<000004@3oool00`000000oooo
0?ooo`1@0?ooo`009P3oool00`000000oooo0?ooo`020?ooo`<00000>P3oool503?o02@0oooo1P00
I_lV0?ooo`80o`2IiP3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00P0oooo0P00
000e0?ooo`030000003oool0oooo00/0oooo1000000D0?ooo`030000003oool0oooo0500oooo000S
0?ooo`<000001@3oool00`000000oooo0?ooo`0l0?ooo`D0<ol09@3oool5001VobH0oooo0`3o09WS
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0b
0?ooo`030000003oool0oooo00P0oooo0`00000H0?ooo`030000003oool0oooo0500oooo000S0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?P3oool503?o02D0oooo1P00I_lV0?oo
o`<0o`2Ih03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`050?ooo`<000006`3oool00`000000oooo0?ooo`1@0?oo
o`008`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0400oooo1@0co`0V0?ooo`D0
06Ko9P3oool30?l0VMh0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool00P3oool3000001h0oooo00<000000?ooo`3o
ool0D03oool002<0oooo100000040?ooo`030000003oool0oooo0480oooo1@0co`0V0?ooo`@006Ko
9`3oool30?l0VM`0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02l0oooo00<000000?ooo`0000000P00000R0?ooo`030000003oool0oooo04l0oooo
000[0?ooo`800000A@3oool503?o02H0oooo1000I_lW0?ooo`<0o`2IfP3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0;@3oool3000002D0oooo00<0
00000?ooo`3oool0C`3oool002/0oooo00<000000?ooo`3oool0AP3oool503?o02H0oooo1000I_lW
0?ooo`<0o`2Ie`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00T0oooo0P00000Z
0?ooo`<0000000<0oooo0000003oool09@3oool00`000000oooo0?ooo`1?0?ooo`00:`3oool00`00
0000oooo0?ooo`180?ooo`D0<ol09P3oool4001VobL0oooo0`3o09WE0?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0T0?ooo`<00000103oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo04l0oooo000[0?ooo`030000003oool0oooo04X0
oooo1@0co`0U0?ooo`D006Ko9`3oool30?l0VM<0oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0200oooo0`0000070?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool0C`3oool002/0oooo00<000000?ooo`3oool0C03oool503?o02D0oooo
1P00I_lV0?ooo`<0o`2Id@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00X0oooo
0P00000M0?ooo`<000002P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo04l0oooo
000[0?ooo`800000C`3oool603?o02D0oooo1@00I_lV0?ooo`<0o`2Ic`3oool00`000000oooo0?oo
o`0_0?ooo`030000003oool0oooo00/0oooo0P00000H0?ooo`<000003@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo04l0oooo000[0?ooo`030000003oool0oooo0540oooo1@0co`0U
0?ooo`H006Ko9@3oool30?l0VLd0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0180oooo0`00000@0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool0C`3oool002/0oooo00<000000?ooo`3oool0D`3oool603?o02D0oooo1@00I_lU0?oo
o`<0o`2I/03oool2000000030?ooo`000000000000<0oooo0P00000@0?ooo`030000003oool0oooo
0380oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`<00000503oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo04h0oooo000[0?ooo`030000003oool0oooo05H0
oooo1@0co`0U0?ooo`D006Ko9P3oool20?l0VJl0oooo00<000000?ooo`0000000`3oool010000000
oooo0?ooo`00000?0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0303oool20000
00X0oooo1000000G0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0CP3oool002/0
oooo00<000000?ooo`3oool0F03oool503?o02D0oooo1@00I_lV0?ooo`<0o`2I[@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00D0oooo0`00000K0?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool0CP3oool002/0oooo0P00001K0?ooo`D0<ol09@3oool5001VobL0oooo
0P3o09VZ0?ooo`030000003oool0000000@0oooo0P00000@0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool0303oool010000000oooo0?ooo`3oool3000001h0oooo00<000000?ooo`3o
ool0903oool00`000000oooo0?ooo`1>0?ooo`00:`3oool00`000000oooo0?ooo`1M0?ooo`D0<ol0
903oool5001VobL0oooo0`3o09VV0?ooo`80000000<0oooo0000000000001@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0303oool300000240oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`1>0?ooo`00:`3oool00`000000oooo0?oo
o`1O0?ooo`D0<ol0903oool5001VobL0oooo0`3o09V[0?ooo`040000003oool0oooo000000l0oooo
00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`080?ooo`<000000P3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0CP3oool002/0oooo00<0
00000?ooo`3oool0H@3oool503?o02@0oooo1@00I_lW0?ooo`<0o`2IZP3oool2000000l0oooo00<0
00000?ooo`3oool0>@3oool00`000000oooo0?ooo`040?ooo`<000001P3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0CP3oool002/0oooo00<00000
0?ooo`3oool0H`3oool503?o02@0oooo1@00I_lW0?ooo`<0o`2I^@3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo00<000002P3oool2000001h0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`1=0?ooo`00:`3oool2000006H0oooo1@0co`0U0?ooo`D006Ko9P3oool30?l0
VKL0oooo00<000000?ooo`3oool0>`3oool2000000l0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo04d0oooo000[0?ooo`030000003oool0oooo06L0
oooo1@0co`0U0?ooo`D006Ko9P3oool30?l0VKD0oooo00<000000?ooo`3oool0>`3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo0P00000W0?ooo`030000003oool0oooo04d0
oooo000H0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool3000000D0oooo
00<000000?ooo`3oool0J@3oool503?o02D0oooo1@00I_lV0?ooo`<0o`2I/`3oool00`000000oooo
0?ooo`0k0?ooo`030000003oool0oooo0100oooo0P00000F0?ooo`<000000P3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo04d0oooo000H0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1[0?ooo`D0<ol09@3oool6001VobH0oooo0P3o
09Va0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0@0?ooo`<000001P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo04d0oooo000I
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool3000006d0oooo1@0co`0V
0?ooo`D006Ko9P3oool20?l0VJh0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00/0oooo100000090?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0C@3oool001T0oooo00<000000?ooo`3oool01`3oool3000000D0oooo00<000000?oo
o`3oool0L03oool403?o02H0oooo1P00I_lU0?ooo`<0o`2IZ`3oool00`000000oooo0?ooo`0l0?oo
o`030000003oool0oooo01@0oooo0P0000080?ooo`<000003P3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo04d0oooo000J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`1b0?ooo`D0<ol09P3oool5001VobD0oooo0`3o09VY0?ooo`03
0000003oool0oooo03`0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`020?ooo`<0
00004P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo04`0oooo000G0?ooo`040000
003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1d0?ooo`D0
<ol09P3oool5001VobH0oooo0P3o09VW0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3o
ool05`3oool4000001H0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1<0?ooo`00
5`3oool4000000P0oooo100000040?ooo`030000003oool0oooo07H0oooo1@0co`0V0?ooo`D006Ko
9P3oool30?l0VJ@0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0E0?ooo`D00000
603oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo04`0oooo000[0?ooo`800000N@3o
ool503?o02H0oooo1@00I_lW0?ooo`80o`2IXP3oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo0140oooo100000050?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`1<0?ooo`00:`3oool00`000000oooo0?ooo`1j0?ooo`D0<ol09P3oool5
001VobL0oooo0`3o09VN0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03P3oool3
000000X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo04`0oooo000[0?ooo`030000003oool0oooo07`0oooo1@0co`0V0?ooo`D006Ko9`3oool30?l0
VI`0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0;0?ooo`<000003P3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0C03oool002/0
oooo00<000000?ooo`3oool0OP3oool503?o02H0oooo1@00I_lW0?ooo`<0o`2IVP3oool00`000000
oooo0?ooo`0m0?ooo`030000003oool0oooo00P0oooo0`00000B0?ooo`8000005P3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo04`0oooo000[0?ooo`030000003oool0oooo0800oooo
1P0co`0U0?ooo`D006Ko9`3oool30?l0VIP0oooo00<000000?ooo`3oool0?@3oool00`000000oooo
0?ooo`050?ooo`<000005`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool0B`3oool002/0oooo0P0000240?ooo`D0<ol09@3oool5001VobL0oooo0`3o
09VF0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool00P3oool4000001/0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo04/0oooo000[
0?ooo`030000003oool0oooo08D0oooo1P0co`0T0?ooo`D006Ko9`3oool30?l0VI@0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0000000200000200oooo0P00000D0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0B`3oool002/0oooo00<000000?ooo`3oool0R03oool503?o
02@0oooo1@00I_lW0?ooo`<0o`2IT@3oool00`000000oooo0?ooo`0l0?ooo`<000009@3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0B`3oool002/0
oooo00<000000?ooo`3oool0RP3oool503?o02@0oooo1P00I_lV0?ooo`<0o`2IS`3oool00`000000
oooo0?ooo`0i0?ooo`<0000000<0oooo0000003oool09P3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0B`3oool002/0oooo00<000000?ooo`3oool0
S03oool503?o02D0oooo1@00I_lV0?ooo`<0o`2IS@3oool00`000000oooo0?ooo`0f0?ooo`<00000
103oool00`000000oooo0?ooo`0V0?ooo`8000004`3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo04/0oooo000[0?ooo`800000T03oool503?o02@0oooo1P00I_lU0?ooo`<0o`2IR`3o
ool00`000000oooo0?ooo`0b0?ooo`@000001`3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1;0?ooo`00:`3oool0
0`000000oooo0?ooo`2A0?ooo`D0<ol09@3oool5001VobD0oooo0`3o09V90?ooo`030000003oool0
oooo02l0oooo0`00000;0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo04/0oooo000[0?ooo`030000003oool0oooo
09<0oooo1@0co`0U0?ooo`D006Ko9P3oool20?l0VHL0oooo00<000000?ooo`3oool0;03oool30000
00h0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0BP3oool002/0oooo00<000000?ooo`3oool0U@3oool503?o02D0
oooo1@00I_lV0?ooo`80o`2IQ03oool00`000000oooo0?ooo`0Z0?ooo`<000004@3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`1:0?ooo`00:`3oool00`000000oooo0?ooo`2G0?ooo`D0<ol09P3oool5001VobD0oooo
0P3o09V20?ooo`030000003oool0oooo02L0oooo0`00000D0?ooo`030000003oool0oooo02`0oooo
0P00000A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0BP3oool002/0oooo0P00
002J0?ooo`D0<ol09P3oool5001VobD0oooo0P3o09V00?ooo`030000003oool0oooo02<0oooo1000
000G0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo04X0oooo000[0?ooo`030000003oool0oooo09/0oooo1@0co`0V
0?ooo`D006KoY@3oool00`000000oooo0?ooo`0P0?ooo`<000006`3oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1:
0?ooo`007@3oool4000000<0oooo0P0000050?ooo`030000003oool0oooo09d0oooo1@0co`0V0?oo
o`D006KoX`3oool00`000000oooo0?ooo`0M0?ooo`<000007P3oool00`000000oooo0?ooo`0`0?oo
o`8000003`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo04X0oooo000O0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
09l0oooo1P0co`0U0?ooo`D006KoX@3oool00`000000oooo0?ooo`0J0?ooo`<000008@3oool00`00
0000oooo0?ooo`0b0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`1:0?ooo`007`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool00P3oool300000:80oooo1@0co`0U0?ooo`D006KoWP3oool00`000000oooo0?ooo`0H0?oo
o`<00000903oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`190?ooo`007`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`2T0?ooo`H0<ol0903oool5001V
oi`0oooo00<000000?ooo`3oool0503oool4000002L0oooo00<000000?ooo`3oool0=03oool20000
00h0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`190?ooo`007`3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`2W0?oo
o`D0<ol0903oool5001VoiX0oooo00<000000?ooo`3oool04@3oool3000002/0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0B@3oool001d0oooo0`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool0Z@3oool503?o02@0oooo1P00I_nG0?ooo`030000003oool0oooo00h0oooo0`00000^0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo04T0oooo000O0?ooo`030000003oool0oooo0080oooo0P0000050?ooo`03
0000003oool0oooo0:/0oooo1@0co`0U0?ooo`D006KoU@3oool00`000000oooo0?ooo`0;0?ooo`<0
0000<@3oool00`000000oooo0?ooo`0h0?ooo`800000303oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo04T0oooo000[0?ooo`800000[P3oool503?o02D0oooo1P00I_nB0?ooo`030000
003oool0oooo00P0oooo0`00000d0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo04T0oooo000[0?ooo`030000003o
ool0oooo0:l0oooo1@0co`0V0?ooo`D006KoS`3oool00`000000oooo0?ooo`050?ooo`@00000=`3o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`190?ooo`00:`3oool00`000000oooo0?ooo`2a0?ooo`D0<ol09P3oool5
001Vohd0oooo00<000000?ooo`3oool00P3oool3000003/0oooo00<000000?ooo`3oool0?03oool2
000000/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`180?ooo`00:`3oool00`00
0000oooo0?ooo`2c0?ooo`H0<ol09@3oool5001Voh/0oooo00<000000?ooo`0000000P00000n0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo04P0oooo000[0?ooo`030000003oool0oooo0;H0oooo1@0co`0U0?ooo`D0
06KoR@3oool200000440oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0B03oool002/0oooo0P00002i0?ooo`H0<ol0
903oool5001VohP0oooo0P0000100?ooo`030000003oool0oooo0400oooo0P0000090?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0B03oool002/0oooo00<000000?ooo`3oool0^`3o
ool503?o02@0oooo1@00I_n80?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0@P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0B03o
ool002/0oooo00<000000?ooo`3oool0_@3oool503?o02@0oooo1@00I_n70?ooo`800000?@3oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`180?ooo`00:`3oool00`000000oooo0?ooo`2o0?ooo`D0<ol09@3oool4001V
ohL0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`140?ooo`800000203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo04P0oooo000[0?ooo`030000003oool0oooo0<80
oooo1@0co`0T0?ooo`D006KoQ@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo04L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04L0
oooo000[0?ooo`800000a@3oool503?o02@0oooo1000I_n50?ooo`800000>03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`170?ooo`00:`3oool00`000000oooo0?ooo`360?ooo`D0<ol0903oool00`00I_l0oooo0?oo
o`260?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0A`3oool002/0oooo00<00000
0?ooo`3oool0b03oool503?o0:`0oooo0P00000e0?ooo`030000003oool0oooo04X0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04L0oooo000[0?oo
o`030000003oool0oooo0<X0oooo1@0co`2/0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool0B`3oool2000000H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`170?oo
o`00:`3oool00`000000oooo0?ooo`3<0?ooo`D0<ol0Z`3oool200000380oooo00<000000?ooo`3o
ool0C@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0A`3oool002/0oooo0P00003?0?ooo`D0<ol0Z`3oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo04h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo04L0oooo000[0?ooo`030000003oool0oooo0=00oooo1@0co`2Z0?ooo`800000;`3o
ool00`000000oooo0?ooo`1?0?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo04L0oooo000[0?ooo`030000003oool0oooo0=80oooo1P0co`2Y0?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0AP3oool00140oooo100000020?ooo`@000000`3oool00`00
0000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`3E0?ooo`D0<ol0Z03oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo04H0oooo000C0?ooo`050000003oool0oooo0?oo
o`0000003P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0=L0oooo1P0co`2V0?oo
o`800000:`3oool00`000000oooo0?ooo`1C0?ooo`8000000P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo04H0oooo000C0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`020?ooo`<00000fP3oool503?o0:H0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`1E0?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool0AP3oool001<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`<0
00001@3oool00`000000oooo0?ooo`3L0?ooo`D0<ol0Y@3oool2000002P0oooo00<000000?ooo`3o
ool0EP3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo04H0oooo000C0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0=h0oooo1@0co`2U0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool0E`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo04H0oooo000A0?ooo`<0
00000`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0h03oool503?o0:@0oooo0P00000U0?ooo`030000003oool0oooo05P0oooo00H000000?oo
o`3oool000000?ooo`0000180?ooo`004`3oool00`000000oooo0?ooo`020?ooo`8000002@3oool4
000000@0oooo0P00003S0?ooo`D0<ol0Y03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0
oooo05T0oooo0P000000103oool000000?ooo`0000170?ooo`00:`3oool00`000000oooo0?ooo`3T
0?ooo`D0<ol0X`3oool200000280oooo00<000000?ooo`3oool0G03oool00`000000oooo00000017
0?ooo`00:`3oool00`000000oooo0?ooo`3V0?ooo`@0<ol0Y03oool00`000000oooo0?ooo`0O0?oo
o`030000003oool0oooo05d0oooo0P0000170?ooo`00:`3oool00`000000oooo0?ooo`3X0?ooo`@0
<ol0X`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo05`0oooo0`0000170?ooo`00
:`3oool00`000000oooo0?ooo`3Z0?ooo`@0<ol0XP3oool2000001h0oooo00<000000?ooo`3oool0
F03oool4000004X0oooo000[0?ooo`800000k@3oool403?o0:80oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`1C0?ooo`D00000CP3oool002/0oooo00<000000?ooo`3oool0k@3oool4
03?o0:80oooo0P00000K0?ooo`030000003oool0oooo04l0oooo1000001C0?ooo`00:`3oool00`00
0000oooo0?ooo`3_0?ooo`0303?o003oool0oooo0:<0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`1:0?ooo`D00000E`3oool002/0oooo00<000000?ooo`3oool0o`3ooonG0?ooo`80
0000603oool00`000000oooo0?ooo`160?ooo`@00000G03oool002/0oooo00<000000?ooo`3oool0
o`3ooonI0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0@P3oool400000600oooo
003o0?ooolP0oooo0P00000E0?ooo`030000003oool0oooo03d0oooo1@00001T0?ooo`00o`3oooo:
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>@3oool4000006T0oooo003o0?oo
ol/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0e0?ooo`D00000K@3oool00?l0
ooooc03oool200000100oooo00<000000?ooo`3oool0<@3oool400000780oooo003o0?ooolh0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0/0?ooo`D00000MP3oool00?l0ooooc`3o
ool2000000d0oooo00<000000?ooo`3oool0:03oool4000007/0oooo003o0?ooom40oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0S0?ooo`D00000O`3oool00?l0oooodP3oool20000
00X0oooo00<000000?ooo`3oool07`3oool4000008@0oooo003o0?ooom@0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0J0?ooo`D00000R03oool002P0oooo0P0000000`3oool00000
0000003o0?ooojP0oooo0P0000070?ooo`030000003oool0oooo01H0oooo1000002=0?ooo`00:@3o
ool00`000000oooo0000003o0?oooj/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0B0?ooo`@00000T@3oool002X0oooo00<000000?ooo`3oool0o`3ooon[0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool03@3oool5000009D0oooo000Y0?ooo`030000003oool00000
0?l0oooo[@3oool2000000<0oooo00<000000?ooo`3oool02@3oool4000009X0oooo000X0?ooo`80
000000<0oooo000000000000o`3ooon<0?ooo`80000000<0oooo0000000000000P3oool4000001L0
oooo00@000000?ooo`3oool000001P3oool5000009h0oooo003o0?oookX0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`0I0?ooo`<000000P3oool400000:<0oooo003o0?oook/0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0J0?ooo`<00000Y`3oool00?l0oooo^P3o
ool00`000000oooo000000050?ooo`030000003oool0oooo0<<0oooo003o0?oookT0oooo0P000000
0`3oool00000000000050?ooo`030000003oool0oooo0<80oooo003o0?oool00oooo00@000000?oo
o`3oool00000a03oool00?l0oooo`@3oool200000<D0oooo003o0?ooool0ooooR@3oool00?l0oooo
o`3ooon90?ooo`00o`3ooooo0?ooohT0oooo003o0?ooool0ooooR@3oool00001\
\>"],
  ImageRangeCache->{{{0, 646}, {189.375, 0}} -> {-0.054129, -0.0147182, \
0.00326356, 0.00326356}, {{16.5625, 308.375}, {184.812, 4.5}} -> {-3.61186, \
-3.2239, 0.0825706, 0.103856}, {{337.562, 629.375}, {184.812, 4.5}} -> \
{-2.12514, -0.0240309, 0.00526606, 0.00526606}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{xPlot[0, 1, 0], \ 
            xLPlot[0, 1, 0\ , Ticks \[Rule] None, 
              ViewPoint \[Rule] {1, 1, 
                  1}]}\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",\

  Hyphenation->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.309017 0.108715 [
[.2619 .29652 -3 -9 ]
[.2619 .29652 3 0 ]
[.5 .29652 -6 -9 ]
[.5 .29652 6 0 ]
[.7381 .29652 -6 -9 ]
[.7381 .29652 6 0 ]
[.97619 .29652 -6 -9 ]
[.97619 .29652 6 0 ]
[1.025 .30902 0 -4.90625 ]
[1.025 .30902 10 4.90625 ]
[.01131 .09159 -12 -4.5 ]
[.01131 .09159 0 4.5 ]
[.01131 .2003 -12 -4.5 ]
[.01131 .2003 0 4.5 ]
[.01131 .41773 -6 -4.5 ]
[.01131 .41773 0 4.5 ]
[.01131 .52645 -6 -4.5 ]
[.01131 .52645 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30902 m
.2619 .31527 L
s
[(5)] .2619 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(10)] .5 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(15)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(20)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .09159 m
.03006 .09159 L
s
[(-2)] .01131 .09159 1 0 Mshowa
.02381 .2003 m
.03006 .2003 L
s
[(-1)] .01131 .2003 1 0 Mshowa
.02381 .41773 m
.03006 .41773 L
s
[(1)] .01131 .41773 1 0 Mshowa
.02381 .52645 m
.03006 .52645 L
s
[(2)] .01131 .52645 1 0 Mshowa
.125 Mabswid
.02381 .11333 m
.02756 .11333 L
s
.02381 .13507 m
.02756 .13507 L
s
.02381 .15682 m
.02756 .15682 L
s
.02381 .17856 m
.02756 .17856 L
s
.02381 .22205 m
.02756 .22205 L
s
.02381 .24379 m
.02756 .24379 L
s
.02381 .26553 m
.02756 .26553 L
s
.02381 .28727 m
.02756 .28727 L
s
.02381 .33076 m
.02756 .33076 L
s
.02381 .3525 m
.02756 .3525 L
s
.02381 .37425 m
.02756 .37425 L
s
.02381 .39599 m
.02756 .39599 L
s
.02381 .43947 m
.02756 .43947 L
s
.02381 .46122 m
.02756 .46122 L
s
.02381 .48296 m
.02756 .48296 L
s
.02381 .5047 m
.02756 .5047 L
s
.02381 .06984 m
.02756 .06984 L
s
.02381 .0481 m
.02756 .0481 L
s
.02381 .02636 m
.02756 .02636 L
s
.02381 .00462 m
.02756 .00462 L
s
.02381 .54819 m
.02756 .54819 L
s
.02381 .56993 m
.02756 .56993 L
s
.02381 .59167 m
.02756 .59167 L
s
.02381 .61342 m
.02756 .61342 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 1 0 r
.01 w
.02381 .60332 m
.02499 .6033 L
.02605 .60323 L
.02729 .60311 L
.02846 .60295 L
.03053 .60255 L
.03279 .60196 L
.03527 .6011 L
.0379 .59998 L
.04262 .5974 L
.05205 .59019 L
.06244 .57938 L
.0842 .54935 L
.10458 .51683 L
.12312 .48861 L
.13291 .47574 L
.14335 .46439 L
.1491 .45937 L
.15431 .45567 L
.15683 .45419 L
.15955 .45281 L
.1621 .45173 L
.16449 .45092 L
.16691 .45029 L
.1682 .45003 L
.16957 .44982 L
.17027 .44974 L
.17102 .44967 L
.17173 .44962 L
.17239 .44959 L
.17363 .44957 L
.17495 .44961 L
.17609 .44969 L
.17731 .44983 L
.17847 .45001 L
.17953 .45021 L
.18199 .45082 L
.18458 .45168 L
.18958 .45396 L
.19412 .45673 L
.20432 .46521 L
.21377 .47557 L
.22268 .48719 L
.26115 .54708 L
.28064 .57484 L
.29171 .5873 L
.29702 .59215 L
.30207 .59601 L
.30682 .59892 L
.30933 .60017 L
Mistroke
.312 .60127 L
.31447 .60209 L
.3167 .60265 L
.31778 .60286 L
.31895 .60304 L
.32005 .60317 L
.32107 .60325 L
.32225 .60331 L
.32352 .60331 L
.32471 .60327 L
.3258 .60319 L
.32708 .60304 L
.32847 .60281 L
.331 .60224 L
.33364 .60141 L
.33644 .60028 L
.34147 .59761 L
.35087 .59053 L
.36098 .58014 L
.37928 .55562 L
.39896 .52459 L
.42047 .49123 L
.43042 .47782 L
.44103 .46586 L
.44619 .4611 L
.45105 .45732 L
.45575 .45434 L
.46014 .45219 L
.46238 .45134 L
.46479 .45061 L
.46616 .45028 L
.46746 .45002 L
.46862 .44984 L
.46989 .4497 L
.47112 .44961 L
.47183 .44958 L
.47248 .44957 L
.47318 .44958 L
.47381 .4496 L
.47451 .44963 L
.47524 .44969 L
.47647 .44983 L
.47761 .45 L
.4802 .45055 L
.4826 .45126 L
.48487 .45211 L
.48912 .45415 L
.4937 .45699 L
.49866 .4608 L
.50811 .46997 L
Mistroke
.51851 .48261 L
.53955 .51382 L
.5606 .54748 L
.57986 .57487 L
.58937 .58575 L
.59439 .59057 L
.59975 .59493 L
.60489 .59829 L
.60955 .60062 L
.6118 .60149 L
.61424 .60224 L
.61535 .60252 L
.61653 .60277 L
.61763 .60296 L
.61865 .6031 L
.61987 .60323 L
.62051 .60327 L
.6212 .6033 L
.62235 .60332 L
.62361 .60329 L
.62474 .60321 L
.62595 .60308 L
.62709 .60292 L
.62814 .60272 L
.6305 .60216 L
.63309 .60132 L
.6383 .59897 L
.6429 .59618 L
.6478 .59248 L
.65664 .58408 L
.678 .55632 L
.69816 .52459 L
.71649 .49587 L
.7269 .48129 L
.73664 .4696 L
.74624 .46039 L
.75162 .45638 L
.75653 .45349 L
.75904 .45232 L
.7617 .4513 L
.76324 .45082 L
.76463 .45045 L
.76604 .45014 L
.76733 .44991 L
.76857 .44975 L
.76987 .44964 L
.77118 .44958 L
.77192 .44957 L
.77262 .44958 L
.77387 .44965 L
Mistroke
.77502 .44975 L
.77633 .44992 L
.77758 .45014 L
.77996 .4507 L
.78219 .45139 L
.78727 .45359 L
.79222 .45653 L
.79755 .46053 L
.80717 .46982 L
.81598 .48035 L
.85568 .541 L
.8757 .57055 L
.88442 .58128 L
.89386 .59081 L
.89913 .59506 L
.90398 .59823 L
.90862 .60057 L
.91096 .60148 L
.91353 .60227 L
.91493 .60261 L
.91626 .60287 L
.91746 .60305 L
.91876 .6032 L
.91943 .60325 L
.92017 .60329 L
.92094 .60332 L
.92167 .60332 L
.92297 .60328 L
.9237 .60323 L
.92437 .60317 L
.92559 .60302 L
.92672 .60284 L
.9293 .60227 L
.93181 .60149 L
.93449 .60043 L
.93982 .59764 L
.94473 .59428 L
.95583 .58409 L
.97598 .55813 L
.97619 .55782 L
Mfstroke
0 .4 1 r
.009 w
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.007 w
.02381 .01472 m
.02499 .01474 L
.02605 .0148 L
.02729 .01492 L
.02846 .01508 L
.03053 .01548 L
.03279 .01608 L
.03527 .01693 L
.0379 .01805 L
.04262 .02063 L
.05205 .02784 L
.06244 .03866 L
.0842 .06868 L
.10458 .1012 L
.12312 .12943 L
.13291 .1423 L
.14335 .15365 L
.1491 .15866 L
.15431 .16236 L
.15683 .16385 L
.15955 .16523 L
.1621 .1663 L
.16449 .16711 L
.16691 .16775 L
.1682 .168 L
.16957 .16821 L
.17027 .16829 L
.17102 .16836 L
.17173 .16841 L
.17239 .16844 L
.17363 .16846 L
.17495 .16842 L
.17609 .16834 L
.17731 .1682 L
.17847 .16803 L
.17953 .16783 L
.18199 .16722 L
.18458 .16636 L
.18958 .16407 L
.19412 .1613 L
.20432 .15283 L
.21377 .14247 L
.22268 .13085 L
.26115 .07095 L
.28064 .04319 L
.29171 .03073 L
.29702 .02588 L
.30207 .02203 L
.30682 .01912 L
.30933 .01787 L
Mistroke
.312 .01676 L
.31447 .01595 L
.3167 .01539 L
.31778 .01518 L
.31895 .01499 L
.32005 .01486 L
.32107 .01478 L
.32225 .01472 L
.32352 .01472 L
.32471 .01476 L
.3258 .01485 L
.32708 .015 L
.32847 .01522 L
.331 .01579 L
.33364 .01662 L
.33644 .01775 L
.34147 .02042 L
.35087 .0275 L
.36098 .03789 L
.37928 .06242 L
.39896 .09345 L
.42047 .1268 L
.43042 .14021 L
.44103 .15217 L
.44619 .15693 L
.45105 .16072 L
.45575 .16369 L
.46014 .16584 L
.46238 .1667 L
.46479 .16743 L
.46616 .16776 L
.46746 .16801 L
.46862 .16819 L
.46989 .16834 L
.47112 .16842 L
.47183 .16845 L
.47248 .16846 L
.47318 .16846 L
.47381 .16844 L
.47451 .1684 L
.47524 .16834 L
.47647 .16821 L
.47761 .16804 L
.4802 .16749 L
.4826 .16677 L
.48487 .16593 L
.48912 .16389 L
.4937 .16104 L
.49866 .15724 L
.50811 .14807 L
Mistroke
.51851 .13542 L
.53955 .10422 L
.5606 .07056 L
.57986 .04317 L
.58937 .03228 L
.59439 .02746 L
.59975 .02311 L
.60489 .01974 L
.60955 .01741 L
.6118 .01654 L
.61424 .01579 L
.61535 .01551 L
.61653 .01526 L
.61763 .01507 L
.61865 .01493 L
.61987 .01481 L
.62051 .01476 L
.6212 .01473 L
.62235 .01472 L
.62361 .01475 L
.62474 .01482 L
.62595 .01495 L
.62709 .01512 L
.62814 .01531 L
.6305 .01588 L
.63309 .01671 L
.6383 .01906 L
.6429 .02186 L
.6478 .02555 L
.65664 .03395 L
.678 .06171 L
.69816 .09344 L
.71649 .12217 L
.7269 .13674 L
.73664 .14844 L
.74624 .15764 L
.75162 .16165 L
.75653 .16454 L
.75904 .16571 L
.7617 .16674 L
.76324 .16722 L
.76463 .16759 L
.76604 .1679 L
.76733 .16812 L
.76857 .16828 L
.76987 .1684 L
.77118 .16845 L
.77192 .16846 L
.77262 .16845 L
.77387 .16839 L
Mistroke
.77502 .16829 L
.77633 .16811 L
.77758 .1679 L
.77996 .16734 L
.78219 .16664 L
.78727 .16444 L
.79222 .1615 L
.79755 .1575 L
.80717 .14822 L
.81598 .13769 L
.85568 .07703 L
.8757 .04749 L
.88442 .03676 L
.89386 .02722 L
.89913 .02297 L
.90398 .0198 L
.90862 .01747 L
.91096 .01656 L
.91353 .01577 L
.91493 .01543 L
.91626 .01516 L
.91746 .01498 L
.91876 .01483 L
.91943 .01478 L
.92017 .01474 L
.92094 .01472 L
.92167 .01472 L
.92297 .01476 L
.9237 .0148 L
.92437 .01486 L
.92559 .01501 L
.92672 .01519 L
.9293 .01577 L
.93181 .01654 L
.93449 .0176 L
.93982 .02039 L
.94473 .02375 L
.95583 .03394 L
.97598 .05991 L
.97619 .06022 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0773503 1.1547 -2.1413e-17 1.1547 [
[.28173 1.02423 -8.92376 0 ]
[.28173 1.02423 7.07624 9.8125 ]
[.22213 .16489 -16 -8.5482 ]
[.22213 .16489 0 1.2643 ]
[.99614 .54294 0 -7.03072 ]
[.99614 .54294 16 2.78178 ]
[ 0 0 0 0 ]
[ 1 .98974 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5 .98974 m
0 .86603 L
s
gsave
.28173 1.02423 -69.9238 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
.14286 .37115 m
.5 0 L
s
gsave
.22213 .16489 -77 -12.5482 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
.85714 .37115 m
1 .86603 L
s
gsave
.99614 .54294 -61 -11.0307 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x3) show
1.000 setlinewidth
grestore
.5 .57735 m
.5 .98974 L
s
.5 .98974 m
1 .86603 L
s
1 .86603 m
.85714 .37115 L
s
.85714 .37115 m
.5 .57735 L
s
.14286 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
0 .86603 L
s
0 .86603 m
.14286 .37115 L
s
.5 .57735 m
.5 .98974 L
s
.5 .98974 m
0 .86603 L
s
0 .86603 m
.14286 .37115 L
s
.14286 .37115 m
.5 .57735 L
s
.85714 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
1 .86603 L
s
1 .86603 m
.85714 .37115 L
s
0 0 m
1 0 L
1 .98974 L
0 .98974 L
closepath
clip
newpath
.5 Mabswid
.31292 .25333 m
.33737 .29567 L
s
.30206 .23452 m
.31292 .25333 L
s
.30159 .23369 m
.30879 .24617 L
s
.30343 .23688 m
.31777 .26172 L
s
.30336 .23677 m
.30343 .23688 L
s
.30558 .2406 m
.30206 .23452 L
s
.32321 .27115 m
.30558 .2406 L
s
.31777 .26172 m
.34534 .30947 L
s
.31758 .26139 m
.30336 .23677 L
s
.34504 .30896 m
.31758 .26139 L
s
.32988 .2827 m
.36333 .34063 L
s
.30879 .24617 m
.32988 .2827 L
s
.30567 .24077 m
.32343 .27152 L
s
.30203 .23446 m
.30567 .24077 L
s
.31277 .25305 m
.30203 .23446 L
s
.3371 .2952 m
.31277 .25305 L
s
.33737 .29567 m
.37363 .35846 L
s
.37326 .35783 m
.3371 .2952 L
s
.35369 .32393 m
.32321 .27115 L
s
.39479 .39511 m
.35369 .32393 L
s
.34534 .30947 m
.38415 .37669 L
s
.32343 .27152 m
.35401 .32448 L
s
.38376 .37602 m
.34504 .30896 L
s
.35401 .32448 m
.39519 .39581 L
s
.44353 .47954 m
.39479 .39511 L
s
.36333 .34063 m
.4067 .41575 L
s
.43092 .45771 m
.38376 .37602 L
s
.41863 .43641 m
.37326 .35783 L
s
.37363 .35846 m
.41906 .43716 L
s
.39519 .39581 m
.44398 .48033 L
s
.38415 .37669 m
.43137 .45848 L
s
.4067 .41575 m
.45685 .50261 L
s
.46991 .52523 m
.41863 .43641 L
s
.4831 .54808 m
.43092 .45771 L
s
.43137 .45848 m
.48358 .5489 L
s
.44398 .48033 m
.49685 .57189 L
s
.49637 .57107 m
.44353 .47954 L
s
.45685 .50261 m
.51013 .5949 L
s
.52338 .61784 m
.46991 .52523 L
s
.53651 .64059 m
.4831 .54808 L
s
.48358 .5489 m
.53698 .6414 L
s
.54949 .66306 m
.49637 .57107 L
s
.49685 .57189 m
.54995 .66386 L
s
.51013 .5949 m
.56269 .68593 L
s
.57515 .70751 m
.52338 .61784 L
s
.58728 .72852 m
.53651 .64059 L
s
.53698 .6414 m
.5877 .72925 L
s
.54995 .66386 m
.59942 .74955 L
s
.59901 .74884 m
.54949 .66306 L
s
.56269 .68593 m
.61069 .76908 L
s
.62147 .78775 m
.57515 .70751 L
s
.5877 .72925 m
.63206 .80609 L
s
.63171 .80547 m
.58728 .72852 L
s
.64135 .82217 m
.59901 .74884 L
s
.65898 .85271 m
.62147 .78775 L
s
.61069 .76908 m
.65067 .83832 L
s
.59942 .74955 m
.64168 .82275 L
s
.63206 .80609 m
.66684 .86632 L
s
.68495 .89769 m
.65898 .85271 L
s
.69749 .91942 m
.68495 .89769 L
s
.66658 .86587 m
.63171 .80547 L
s
.65067 .83832 m
.67971 .88861 L
s
.64168 .82275 m
.67366 .87814 L
s
.67343 .87774 m
.64135 .82217 L
s
.69292 .9115 m
.67343 .87774 L
s
.66684 .86632 m
.6895 .90558 L
s
.68936 .90533 m
.66658 .86587 L
s
.67971 .88861 m
.6957 .91632 L
s
.69841 .92101 m
.69292 .9115 L
s
.6895 .90558 m
.69841 .92101 L
s
.67366 .87814 m
.69303 .91169 L
s
.6957 .91632 m
.69749 .91942 L
s
.6984 .92098 m
.68936 .90533 L
s
.69303 .91169 m
.6984 .92098 L
s
.25 Mabswid
.14286 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
0 .86603 L
s
0 .86603 m
.14286 .37115 L
s
.85714 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
1 .86603 L
s
1 .86603 m
.85714 .37115 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{653, 192.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:=0000`2000`400?l00000o`00003oo`3ooooo
0?ooohl0oooo003o0?ooool0ooooS`3oool00?l0ooooo`3ooon?0?ooo`00o`3ooooo0?ooohl0oooo
003o0?ooool0ooooS`3oool00200oooo00<000000?ooo`3oool0o`3ooonn0?ooo`030000003oool0
oooo0:X0oooo000P0?ooo`800000o`3ooonn0?ooo`<00000Z`3oool00200oooo00<000000?ooo`3o
ool0o`3ooonl0?ooo`050000003oool000000?ooo`000000ZP3oool00200oooo00<000000?ooo`3o
ool0o`3ooonk0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0Y`3oool00200
oooo103o09U90?ooo`L0o`2IBP3oool70?l0VDT0oooo1P3o09W80?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`2V0?ooo`00803oool010000000oooo0?ooo`3oool20?l0
VDH0oooo0P3o09T60?ooo`80o`2IA@3oool30?l0V@H0oooo0P3o09U60?ooo`80o`2I1P3oool30?l0
VL@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0:D0oooo000P0?ooo`030000003oool0oooo00<0oooo0P3o09U20?ooo`80o`2I2P3oool20?l0VD80
oooo0P3o09T:0?ooo`030?l0V@3oool0oooo0440oooo0P3o09T:0?ooo`80o`2I`P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0Y03oool00200oooo
0P0000060?ooo`030?l0V@3oool0oooo03h0oooo0P3o09T=0?ooo`030?l0V@3oool0oooo03h0oooo
00<0o`2I0?ooo`3oool02`3oool00`3o09T0oooo0?ooo`0o0?ooo`80o`2I3@3oool00`3o09T0oooo
0?ooo`2n0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`2S0?ooo`00803oool00`000000oooo0?ooo`060?ooo`030?l0V@3oool0oooo03`0oooo00<0
o`2I0?ooo`3oool03P3oool00`3o09T0oooo0?ooo`0l0?ooo`80o`2I3P3oool20?l0VCh0oooo00<0
o`2I0?ooo`3oool03P3oool00`3o09T0oooo0?ooo`2l0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`2R0?ooo`00803oool00`000000oooo0?ooo`06
0?ooo`030?l0V@3oool0oooo03/0oooo00<0o`2I0?ooo`3oool03`3oool00`3o09T0oooo0?ooo`0l
0?ooo`030?l0V@3oool0oooo00l0oooo00<0o`2I0?ooo`3oool0>`3oool00`3o09T0oooo0?ooo`0?
0?ooo`030?l0V@3oool0oooo0;X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0:40oooo000P0?ooo`030000003oool0oooo00L0oooo00<0o`2I0?oo
o`3oool0>@3oool20?l0VA80oooo00<0o`2I0?ooo`3oool0>P3oool00`3o09T0oooo0?ooo`0A0?oo
o`030?l0V@3oool0oooo03T0oooo00<0o`2I0?ooo`3oool04@3oool00`3o09T0oooo0?ooo`2h0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`2P0?oo
o`00803oool00`000000oooo0?ooo`080?ooo`030?l0V@3oool0oooo03P0oooo00<0o`2I0?ooo`3o
ool04P3oool00`3o09T0oooo0?ooo`0h0?ooo`030?l0V@3oool0oooo0180oooo0P3o09Ti0?ooo`03
0?l0V@3oool0oooo0180oooo0P3o09Vh0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`2O0?ooo`00803oool00`000000oooo0?ooo`080?ooo`80o`2I
>03oool00`3o09T0oooo0?ooo`0C0?ooo`80o`2I>03oool00`3o09T0oooo0?ooo`0D0?ooo`030?l0
V@3oool0oooo03H0oooo00<0o`2I0?ooo`3oool0503oool00`3o09T0oooo0?ooo`2e0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`2N0?ooo`00803o
ool2000000X0oooo00<0o`2I0?ooo`3oool0=@3oool00`3o09T0oooo0?ooo`0E0?ooo`030?l0V@3o
ool0oooo03D0oooo00<0o`2I0?ooo`3oool05P3oool00`3o09T0oooo0?ooo`0d0?ooo`030?l0V@3o
ool0oooo01H0oooo00<0o`2I0?ooo`3oool0/`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0W@3oool00200oooo00<000000?ooo`3oool02P3oool0
0`3o09T0oooo0?ooo`0c0?ooo`80o`2I603oool00`3o09T0oooo0?ooo`0c0?ooo`80o`2I603oool2
0?l0VC@0oooo00<0o`2I0?ooo`3oool05`3oool20?l0VK<0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo09`0oooo000P0?ooo`030000003oool0oooo
00/0oooo00<0o`2I0?ooo`3oool0<P3oool00`3o09T0oooo0?ooo`0G0?ooo`80o`2I=03oool00`3o
09T0oooo0?ooo`0H0?ooo`030?l0V@3oool0oooo0380oooo00<0o`2I0?ooo`3oool0603oool00`3o
09T0oooo0?ooo`2`0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`2K0?ooo`00803oool00`000000oooo0?ooo`0;0?ooo`80o`2I<P3oool00`3o09T0
oooo0?ooo`0I0?ooo`030?l0V@3oool0oooo0340oooo00<0o`2I0?ooo`3oool06P3oool00`3o09T0
oooo0?ooo`0`0?ooo`030?l0V@3oool0oooo0<`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo09/0oooo000P0?ooo`030000003oool0oooo00`0oooo
00<0o`2I0?ooo`3oool0;`3oool20?l0VA`0oooo00<0o`2I0?ooo`3oool0;`3oool20?l0VAd0oooo
00<0o`2I0?ooo`3oool0;P3oool20?l0VLd0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo09X0oooo000P0?ooo`030000003oool0oooo00d0oooo00<0
o`2I0?ooo`3oool0;P3oool00`3o09T0oooo0?ooo`0L0?ooo`030?l0V@3oool0oooo02h0oooo00<0
o`2I0?ooo`3oool0703oool00`3o09T0oooo0?ooo`0^0?ooo`030?l0V@3oool0oooo0</0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo09T0oooo000P
0?ooo`8000003`3oool00`3o09T0oooo0?ooo`0/0?ooo`030?l0V@3oool0oooo01d0oooo0P3o09T^
0?ooo`030?l0V@3oool0oooo01h0oooo00<0o`2I0?ooo`3oool0;03oool00`3o09T0oooo0?ooo`3;
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`2H
0?ooo`00803oool00`000000oooo0?ooo`0>0?ooo`030?l0V@3oool0oooo02/0oooo00<0o`2I0?oo
o`3oool07`3oool00`3o09T0oooo0?ooo`0[0?ooo`030?l0V@3oool0oooo0200oooo00<0o`2I0?oo
o`3oool0:`3oool00`3o09T0oooo0?ooo`3:0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`2G0?ooo`00803oool00`000000oooo0?ooo`0?0?ooo`03
0?l0V@3oool0oooo02X0oooo00<0o`2I0?ooo`3oool0803oool00`3o09T0oooo0?ooo`0Z0?ooo`03
0?l0V@3oool0oooo0200oooo00<0o`2I0?ooo`3oool0:P3oool00`3o09T0oooo0?ooo`3:0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`2F0?ooo`00
603oool4000000@0oooo00<000000?ooo`3oool0403oool00`3o09T0oooo0?ooo`0X0?ooo`030?l0
V@3oool0oooo0280oooo00<0o`2I0?ooo`3oool0:03oool00`3o09T0oooo0?ooo`0R0?ooo`030?l0
V@3oool0oooo02P0oooo00<0o`2I0?ooo`3oool0bP3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0U@3oool001P0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0@0?ooo`030?l0V@3oool0oooo02L0oooo00<0o`2I0?ooo`3oool08`3o
ool20?l0VBP0oooo00<0o`2I0?ooo`3oool0903oool00`3o09T0oooo0?ooo`0W0?ooo`030?l0V@3o
ool0oooo0:80oooo0P0000000`3oool00000000000020?ooo`@00000703oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0U03oool001T0oooo00<00000
0?ooo`3oool0103oool300000140oooo00<0o`2I0?ooo`3oool09@3oool20?l0VBH0oooo00<0o`2I
0?ooo`3oool09P3oool00`3o09T0oooo0?ooo`0T0?ooo`030?l0V@3oool0oooo02H0oooo00<0o`2I
0?ooo`3oool0Y03oool00`000000oooo000000030?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo09<0oooo000B0?oo
o`@00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0180oooo00<0o`2I0?oo
o`3oool0903oool00`3o09T0oooo0?ooo`0V0?ooo`030?l0V@3oool0oooo02@0oooo00<0o`2I0?oo
o`3oool09P3oool00`3o09T0oooo0?ooo`0T0?ooo`030?l0V@3oool0oooo0:H0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`2B0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0180oooo00<0o`2I0?ooo`3oool08`3oool00`3o09T0oooo0?ooo`0W0?ooo`80
o`2I903oool00`3o09T0oooo0?ooo`0X0?ooo`030?l0V@3oool0oooo0280oooo0P3o09VW0?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool0T@3oool001P0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`0C0?ooo`030?l0V@3oool0oooo0240oooo0P3o09TZ0?ooo`03
0?l0V@3oool0oooo0280oooo00<0o`2I0?ooo`3oool0:03oool00`3o09T0oooo0?ooo`0R0?ooo`03
0?l0V@3oool0oooo0:D0oooo0P0000000`3oool00000000000050?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0900
oooo000I0?ooo`8000001@3oool00`000000oooo0?ooo`0D0?ooo`030?l0V@3oool0oooo0200oooo
00<0o`2I0?ooo`3oool0:P3oool00`3o09T0oooo0?ooo`0P0?ooo`030?l0V@3oool0oooo02X0oooo
00<0o`2I0?ooo`3oool0803oool00`3o09T0oooo0?ooo`2]0?ooo`040000003oool0oooo000001L0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo08l0
oooo000P0?ooo`030000003oool0oooo01@0oooo00<0o`2I0?ooo`3oool07`3oool00`3o09T0oooo
0?ooo`0[0?ooo`030?l0V@3oool0oooo01l0oooo00<0o`2I0?ooo`3oool0:`3oool20?l0VB00oooo
0P3o09V`0?ooo`8000005`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0SP3oool00200oooo0P00000F0?ooo`030?l0V@3oool0oooo01d0oooo0P3o
09T^0?ooo`030?l0V@3oool0oooo01h0oooo00<0o`2I0?ooo`3oool0;03oool00`3o09T0oooo0?oo
o`0N0?ooo`030?l0V@3oool0oooo0<L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo08d0oooo000P0?ooo`030000003oool0oooo01D0oooo0P3o09TN
0?ooo`030?l0V@3oool0oooo02d0oooo00<0o`2I0?ooo`3oool07@3oool00`3o09T0oooo0?ooo`0^
0?ooo`030?l0V@3oool0oooo01`0oooo00<0o`2I0?ooo`3oool0a`3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0S03oool00200oooo00<000000?oo
o`3oool05P3oool00`3o09T0oooo0?ooo`0K0?ooo`030?l0V@3oool0oooo02l0oooo00<0o`2I0?oo
o`3oool06`3oool20?l0VC00oooo00<0o`2I0?ooo`3oool06`3oool20?l0VLP0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo08/0oooo000P0?ooo`03
0000003oool0oooo01L0oooo00<0o`2I0?ooo`3oool06@3oool00`3o09T0oooo0?ooo`0`0?ooo`80
o`2I703oool00`3o09T0oooo0?ooo`0`0?ooo`030?l0V@3oool0oooo01X0oooo00<0o`2I0?ooo`3o
ool0aP3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0RP3oool00200oooo00<000000?ooo`3oool05`3oool00`3o09T0oooo0?ooo`0I0?ooo`030?l0
V@3oool0oooo0340oooo00<0o`2I0?ooo`3oool06@3oool00`3o09T0oooo0?ooo`0a0?ooo`80o`2I
6P3oool00`3o09T0oooo0?ooo`360?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`290?ooo`00803oool00`000000oooo0?ooo`0H0?ooo`030?l0V@3o
ool0oooo01L0oooo00<0o`2I0?ooo`3oool0<`3oool00`3o09T0oooo0?ooo`0H0?ooo`030?l0V@3o
ool0oooo0380oooo00<0o`2I0?ooo`3oool05`3oool00`3o09T0oooo0?ooo`360?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`280?ooo`00803oool2
000001X0oooo00<0o`2I0?ooo`3oool05@3oool00`3o09T0oooo0?ooo`0e0?ooo`030?l0V@3oool0
oooo01H0oooo00<0o`2I0?ooo`3oool0<`3oool20?l0VAP0oooo00<0o`2I0?ooo`3oool0a@3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0Q`3oool0
0200oooo00<000000?ooo`3oool06@3oool00`3o09T0oooo0?ooo`0E0?ooo`030?l0V@3oool0oooo
03H0oooo00<0o`2I0?ooo`3oool0503oool00`3o09T0oooo0?ooo`0e0?ooo`030?l0V@3oool0oooo
01D0oooo00<0o`2I0?ooo`3oool0a@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0QP3oool00200oooo00<000000?ooo`3oool06P3oool00`3o09T0
oooo0?ooo`0C0?ooo`030?l0V@3oool0oooo03P0oooo00<0o`2I0?ooo`3oool04P3oool20?l0VCP0
oooo00<0o`2I0?ooo`3oool04`3oool00`3o09T0oooo0?ooo`350?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`250?ooo`00803oool00`000000oooo
0?ooo`0K0?ooo`030?l0V@3oool0oooo0140oooo00<0o`2I0?ooo`3oool0>@3oool20?l0VA<0oooo
00<0o`2I0?ooo`3oool0>03oool00`3o09T0oooo0?ooo`0B0?ooo`030?l0V@3oool0oooo0<@0oooo
00D000000?ooo`3oool0oooo0000000Q0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0Q03oool00200oooo00<000000?ooo`3oool0703oool00`3o09T0oooo0?ooo`0?0?ooo`030?l0
V@3oool0oooo03/0oooo00<0o`2I0?ooo`3oool0403oool00`3o09T0oooo0?ooo`0j0?ooo`030?l0
V@3oool0oooo0100oooo00<0o`2I0?ooo`3oool0a03oool00`000000oooo0?ooo`020?ooo`800000
803oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo08<0oooo000P0?ooo`030000003o
ool0oooo01d0oooo0P3o09T>0?ooo`030?l0V@3oool0oooo03d0oooo00<0o`2I0?ooo`3oool03@3o
ool20?l0VCh0oooo0P3o09T>0?ooo`80o`2IaP3oool00`000000oooo0?ooo`040?ooo`8000007`3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0880oooo000P0?ooo`8000007`3oool2
0?l0V@`0oooo00<0o`2I0?ooo`3oool0?`3oool20?l0V@`0oooo00<0o`2I0?ooo`3oool0@03oool0
0`3o09T0oooo0?ooo`0:0?ooo`030?l0V@3oool0oooo0<D0oooo00<000000?ooo`3oool01@3oool2
000001l0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`210?ooo`00803oool00`00
0000oooo0?ooo`0P0?ooo`030?l0V@3oool0oooo00L0oooo0P3o09U30?ooo`80o`2I2P3oool00`3o
09T0oooo0?ooo`120?ooo`030?l0V@3oool0oooo00P0oooo00<0o`2I0?ooo`3oool0a@3oool00`00
0000oooo0?ooo`070?ooo`8000007P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
0800oooo000P0?ooo`030000003oool0oooo0240oooo0P3o09T50?ooo`<0o`2IAP3oool20?l0V@H0
oooo0P3o09U60?ooo`80o`2I1P3oool20?l0VLL0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0L0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0O`3oool00200oooo
00<000000?ooo`3oool08`3oool50?l0VD/0oooo1P3o09U:0?ooo`L0o`2Ia`3oool00`000000oooo
0?ooo`0:0?ooo`8000007@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo07h0oooo
000P0?ooo`030000003oool0oooo0?l0ooooT@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`1m0?ooo`00803oool0
0`000000oooo0?ooo`3o0?oooi40oooo00<000000?ooo`3oool0303oool2000001`0oooo00<00000
0?ooo`3oool0:P3oool00`000000oooo0?ooo`1m0?ooo`00803oool200000?l0ooooT@3oool00`00
0000oooo0?ooo`0>0?ooo`8000006`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo
07`0oooo000P0?ooo`030000003oool0oooo0?l0ooooS`3oool00`000000oooo0?ooo`0?0?ooo`80
00006`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo07/0oooo000P0?ooo`030000
003oool0oooo0?l0ooooSP3oool00`000000oooo0?ooo`0A0?ooo`8000006P3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo07X0oooo000P0?ooo`030000003oool0oooo0?l0ooooS@3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0;P3o
ool00`000000oooo0?ooo`1i0?ooo`00603oool4000000@0oooo00<000000?ooo`3oool0o`3ooon<
0?ooo`030000003oool0oooo01@0oooo0P00000I0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool0N03oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?oo
oh/0oooo00<000000?ooo`3oool05P3oool2000001P0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`1g0?ooo`006P3oool00`000000oooo0?ooo`030?ooo`<00000o`3ooon:0?ooo`03
0000003oool0oooo01L0oooo0P00000H0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3o
ool0MP3oool00180oooo100000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
o`3ooon90?ooo`030000003oool0oooo01T0oooo0P00000G0?ooo`030000003oool0oooo0380oooo
00<000000?ooo`3oool0M@3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`3o0?ooohP0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool0M03oool001P0oooo0`0000050?ooo`030000003oool0
oooo0?l0ooooQ`3oool00`000000oooo0?ooo`0L0?ooo`8000005P3oool00`000000oooo0?ooo`0d
0?ooo`030000003oool0oooo07<0oooo000J0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0o`3ooon60?ooo`030000003oool0oooo01h0oooo0P00000E0?ooo`030000003oool0oooo
03D0oooo00<000000?ooo`3oool0LP3oool00200oooo0P00003o0?ooohH0oooo00<000000?ooo`3o
ool07`3oool2000001D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`1a0?ooo`00
803oool00`000000oooo0?ooo`3o0?oooh@0oooo00<000000?ooo`3oool08@3oool2000001@0oooo
00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`1`0?ooo`00803oool00`000000oooo0?oo
o`3o0?oooh<0oooo00<000000?ooo`3oool08P3oool3000001<0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`1_0?ooo`00803oool00`000000oooo0?ooo`3o0?oooh80oooo00<00000
0?ooo`3oool0903oool2000001<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`1^
0?ooo`00803oool00`000000oooo0?ooo`3o0?oooh80oooo0`00000U0?ooo`8000004P3oool00`00
0000oooo0?ooo`0g0?ooo`<00000L03oool00200oooo00<000000?ooo`3oool0o`3ooon10?ooo`04
0000003oool0oooo0?ooo`8000008`3oool200000180oooo00<000000?ooo`3oool0=@3oool20000
00<0oooo00<000000?ooo`3oool0K@3oool00200oooo0P00003o0?oooh80oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0Q0?ooo`8000004@3oool00`000000oooo0?ooo`0c0?ooo`80
00001@3oool00`000000oooo0?ooo`1]0?ooo`00803oool00`000000oooo0?ooo`3o0?oooh40oooo
00<000000?ooo`3oool0103oool200000240oooo0P00000A0?ooo`030000003oool0oooo0380oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1]0?ooo`00803oool00`000000oooo0?oo
o`3o0?oooh40oooo00<000000?ooo`3oool01P3oool200000200oooo0P00000@0?ooo`030000003o
ool0oooo0300oooo0P0000080?ooo`030000003oool0oooo06d0oooo000P0?ooo`030000003oool0
oooo0?l0ooooP03oool00`000000oooo0?ooo`090?ooo`8000007`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo02h0oooo0P00000;0?ooo`030000003oool0oooo06`0oooo000P0?oo
o`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
01`0oooo0P00000?0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`1/0?ooo`00803oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3o
ool0303oool2000001d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0[0?ooo`80
00003P3oool00`000000oooo0?ooo`1/0?ooo`00803oool200000?l0ooooP03oool00`000000oooo
0?ooo`0?0?ooo`8000006`3oool2000000h0oooo00<000000?ooo`3oool0:@3oool200000140oooo
00<000000?ooo`3oool0J`3oool00200oooo00<000000?ooo`3oool0>`3oool3000003X0oooo1000
00030?ooo`800000=P3oool400000080oooo0`00000g0?ooo`@000000`3oool2000007h0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool09`3oool2000001<0oooo00<000000?ooo`3oool0J`3oool00200oooo00<00000
0?ooo`3oool0?P3oool00`000000oooo0?ooo`0i0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0=03o
ool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000007d0oooo00<000000?ooo`3oool0
4P3oool2000001T0oooo0P00000=0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`1[0?ooo`00803oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo03T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool00000O@3oool00`000000oooo0?ooo`0D0?ooo`800000603oool2000000`0
oooo00<000000?ooo`3oool0903oool2000001H0oooo00<000000?ooo`3oool0J`3oool00200oooo
00<000000?ooo`3oool0>`3oool3000003`0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo03D0oooo00@000000?ooo`3oool0oooo0`00000i0?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo01L0oooo0P00000G
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool08P3oool2000001T0oooo00<00000
0?ooo`3oool0JP3oool00200oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0l0?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0e0?ooo`050000003oool0
oooo0?ooo`000000?03oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo07X0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0D0?ooo`8000002`3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0JP3oool00200oooo0P00
000l0?ooo`030000003oool0oooo03X0oooo0`0000030?ooo`040000003oool0oooo000003D0oooo
0`0000030?ooo`030000003oool0oooo03L0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00001l0?ooo`030000003oool0oooo01X0oooo0P00000E0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool07`3oool2000001`0oooo00<000000?ooo`3oool0JP3oool00200
oooo00<000000?ooo`3oool0>`3oool4000003/0oooo00<000000?ooo`3oool00P3oool2000003P0
oooo00@000000?ooo`3oool0oooo1000000g0?ooo`800000103oool2000007`0oooo00<000000?oo
o`3oool07@3oool2000001<0oooo0P00000:0?ooo`030000003oool0oooo01d0oooo0P00000O0?oo
o`030000003oool0oooo06T0oooo000P0?ooo`030000003oool0oooo0?l0ooooO@3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo0140oooo0P0000090?ooo`030000003oool0oooo01/0
oooo0P00000Q0?ooo`030000003oool0oooo06T0oooo000P0?ooo`030000003oool0oooo0?l0oooo
O@3oool00`000000oooo0?ooo`0P0?ooo`8000004@3oool2000000T0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo06T0oooo000P0?ooo`030000003o
ool0oooo0?l0oooo3`3oool2000006`0oooo00<000000?ooo`3oool08P3oool200000100oooo0P00
00080?ooo`030000003oool0oooo01P0oooo0P00000T0?ooo`030000003oool0oooo06T0oooo000P
0?ooo`030000003oool0oooo0?l0oooo3P3oool010000000oooo0?ooo`00001Z0?ooo`030000003o
ool0oooo02D0oooo0P00000?0?ooo`8000001`3oool00`000000oooo0?ooo`0F0?ooo`8000009`3o
ool00`000000oooo0?ooo`1X0?ooo`006P3oool500000?l006Ko0P00I_l7000000T0oooo00<00000
0?ooo`3oool0J`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00`0oooo0P000007
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`1X
0?ooo`007`3ooooo001Vo`8006Ko403oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo
02P0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0C0?ooo`800000:P3oool00`00
0000oooo0?ooo`1X0?ooo`00803oool00`000000oooo0?ooo`3o0?ooo`d0oooo1000001Z0?ooo`03
0000003oool0oooo02/0oooo0P00000;0?ooo`8000001P3oool00`000000oooo0?ooo`0A0?ooo`80
0000;@3oool00`000000oooo0?ooo`1W0?ooo`00803oool00`000000oooo0?ooo`3o0?ooo`h0oooo
00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00T0oooo
0P0000050?ooo`030000003oool0oooo00l0oooo0P00000_0?ooo`030000003oool0oooo06L0oooo
000P0?ooo`030000003oool0oooo0?l0oooo3P3oool00`000000oooo0?ooo`1Z0?ooo`030000003o
ool0oooo02h0oooo0P00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo06L0oooo000P0?ooo`030000003oool0
oooo0?l0ooooN`3oool00`000000oooo0?ooo`0`0?ooo`800000203oool2000000@0oooo00<00000
0?ooo`3oool0303oool200000380oooo00<000000?ooo`3oool03`3oool2000000030?ooo`000000
000000<0oooo0P00001>0?ooo`00803oool200000?l0ooooN`3oool00`000000oooo0?ooo`0c0?oo
o`8000001`3oool2000000<0oooo00<000000?ooo`3oool02P3oool2000003D0oooo00<000000?oo
o`3oool03`3oool00`000000oooo000000030?ooo`040000003oool0oooo000004d0oooo000P0?oo
o`030000003oool0oooo0?l0ooooNP3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
00@0oooo0P0000030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0=@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0B`3oool00200
oooo00<000000?ooo`3oool0o`3ooomj0?ooo`030000003oool0oooo03H0oooo0P0000050?ooo`80
00000P3oool00`000000oooo0?ooo`070?ooo`800000>03oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0000000@0oooo0P00001>0?ooo`00803oool00`000000oooo0?ooo`3o0?ooogT0oooo
00<000000?ooo`3oool0>@3oool2000000@0oooo00@000000?ooo`3oool000001`3oool2000003/0
oooo00<000000?ooo`3oool03@3oool2000000030?ooo`000000000000D0oooo00<000000?ooo`3o
ool0B`3oool00200oooo00<000000?ooo`3oool0o`3ooomi0?ooo`030000003oool0oooo03/0oooo
00@000000?ooo`3oool0oooo0P0000000`3oool000000?ooo`040?ooo`800000?@3oool00`000000
oooo0?ooo`0D0?ooo`040000003oool0oooo000004d0oooo000P0?ooo`800000o`3ooomj0?ooo`03
0000003oool0oooo03`0oooo0P0000020?ooo`030000003oool0000000@0oooo00<000000?ooo`3o
ool0?@3oool00`000000oooo0?ooo`0E0?ooo`800000CP3oool00200oooo00<000000?ooo`3oool0
o`3ooomi0?ooo`030000003oool0oooo03h0oooo1@0000020?ooo`800000@03oool00`000000oooo
0?ooo`1U0?ooo`00803oool00`000000oooo0?ooo`3o0?ooogP0oooo00<000000?ooo`3oool0@@3o
ool5000004<0oooo00<000000?ooo`3oool0I03oool00200oooo00<000000?ooo`3oool0o`3ooomh
0?ooo`030000003oool0oooo0480oooo0P0000150?ooo`030000003oool0oooo06@0oooo000P0?oo
o`030000003oool0oooo0?l0ooooN03oool00`000000oooo0?ooo`110?ooo`D00000@`3oool00`00
0000oooo0?ooo`1T0?ooo`00803oool00`000000oooo0?ooo`3o0?ooogL0oooo00<000000?ooo`3o
ool0@03oool200000080oooo0P0000000`3oool00000000000120?ooo`030000003oool0oooo06<0
oooo000P0?ooo`800000o`3ooomh0?ooo`030000003oool0oooo03h0oooo0P0000040?ooo`<00000
0P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo06<0oooo000P0?ooo`030000003o
ool0oooo0?l0ooooM`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`0000000`3oool2000003l0oooo00<000000?ooo`3oool0H`3oool00200oooo00<00000
0?ooo`3oool0o`3ooomg0?ooo`030000003oool0oooo03/0oooo0P0000070?ooo`040000003oool0
0000000000@0oooo0P00000m0?ooo`030000003oool0oooo06<0oooo000P0?ooo`030000003oool0
oooo0?l0ooooMP3oool00`000000oooo0?ooo`0j0?ooo`8000002@3oool010000000oooo0?ooo`00
00060?ooo`800000?03oool00`000000oooo0?ooo`1R0?ooo`00803oool00`000000oooo0?ooo`3o
0?ooogH0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo008000001`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0680oooo000P0?oo
o`030000003oool0oooo0?l0ooooMP3oool00`000000oooo0?ooo`0g0?ooo`800000303oool01000
0000oooo0?ooo`3oool2000000L0oooo0P00000i0?ooo`030000003oool0oooo0680oooo000P0?oo
o`800000o`3ooomf0?ooo`030000003oool0oooo03H0oooo0P00000>0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01`3oool2000003P0oooo00<000000?ooo`3oool0H@3oool00200
oooo00<000000?ooo`3oool0o`3ooome0?ooo`030000003oool0oooo03@0oooo0P00000@0?ooo`03
0000003oool0oooo0080oooo0P00000:0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3o
ool0H@3oool00200oooo00<000000?ooo`3oool0o`3ooome0?ooo`030000003oool0oooo03<0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo
0P00000e0?ooo`030000003oool0oooo0640oooo000P0?ooo`030000003oool0oooo0?l0ooooM@3o
ool00`000000oooo0?ooo`0a0?ooo`8000004`3oool00`000000oooo0?ooo`030?ooo`800000303o
ool2000003<0oooo00<000000?ooo`3oool0H@3oool001P0oooo100000040?ooo`030000003oool0
oooo0?l0ooooM03oool00`000000oooo0?ooo`0`0?ooo`8000005@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00`0oooo0P00000b0?ooo`030000003oool0oooo0600oooo000J0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooomd0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`040?ooo`8000003`3oool00`00
0000oooo0?ooo`0_0?ooo`030000003oool0oooo0600oooo000J0?ooo`030000003oool0oooo00<0
oooo0`00003o0?ooog@0oooo00<000000?ooo`3oool0;@3oool2000001P0oooo00<000000?ooo`3o
ool01@3oool2000000l0oooo0P00000_0?ooo`030000003oool0oooo0600oooo000J0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooomc0?ooo`030000003oool0oooo02`0oooo
0P00000J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool2000002h0oooo
00<000000?ooo`3oool0G`3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`3o0?ooog<0oooo00<000000?ooo`3oool0:P3oool2000001`0oooo00<000000?ooo`3oool01P3o
ool200000180oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1O0?ooo`00603oool3
000000D0oooo00<000000?ooo`3oool0o`3ooomc0?ooo`030000003oool0oooo02T0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0140oooo0P00000[
0?ooo`030000003oool0oooo05l0oooo000J0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0o`3ooomc0?ooo`030000003oool0oooo02L0oooo0P00000O0?ooo`030000003oool0oooo
00L0oooo0P00000D0?ooo`800000:@3oool00`000000oooo0?ooo`1O0?ooo`00803oool00`000000
oooo0?ooo`3o0?ooog80oooo00<000000?ooo`3oool09P3oool200000240oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0D0?ooo`800000:03oool00`000000oooo0?ooo`1N0?ooo`00
803oool200000?l0ooooL`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0240oooo
00<000000?ooo`3oool0203oool2000001L0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`1N0?ooo`00803oool00`000000oooo0?ooo`3o0?ooog80oooo00<000000?ooo`3oool08`3o
ool2000002@0oooo00<000000?ooo`3oool02@3oool2000001L0oooo0P00000U0?ooo`030000003o
ool0oooo05h0oooo000P0?ooo`030000003oool0oooo02<0oooo1@0co`1;0?ooo`D0<ol0B`3oool5
03?o0:P0oooo00<000000?ooo`3oool08P3oool2000002H0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0G0?ooo`800000903oool00`000000oooo0?ooo`1M0?ooo`00803oool00`00
0000oooo0?ooo`0P0?ooo`X0<ol0A`3oool:03?o04D0oooo300co`2T0?ooo`030000003oool0oooo
0200oooo0P00000X0?ooo`030000003oool0oooo00X0oooo0P00000J0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0G@3oool00200oooo00<000000?ooo`3oool07`3oool503?o00<0
oooo1P0co`110?ooo`L0<ol00P3oool603?o0480oooo1P0co`020?ooo`H0<ol0X`3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0I0?ooo`8000008@3oool00`000000oooo0?ooo`1M0?ooo`00803oool2000001h0oooo
1@0co`070?ooo`@0<ol0@03oool503?o00P0oooo100co`100?ooo`<0<ol02P3oool303?o0:80oooo
00<000000?ooo`3oool07@3oool2000002/0oooo00<000000?ooo`3oool02`3oool2000001`0oooo
0P00000O0?ooo`030000003oool0oooo05d0oooo000P0?ooo`030000003oool0oooo01`0oooo100c
o`0<0?ooo`80<ol0?`3oool203?o00d0oooo0`0co`0n0?ooo`<0<ol0303oool303?o0:00oooo00<0
00000?ooo`3oool0703oool2000002d0oooo00<000000?ooo`3oool0303oool2000001d0oooo0P00
000N0?ooo`030000003oool0oooo05`0oooo000P0?ooo`030000003oool0oooo01/0oooo0`0co`0>
0?ooo`<0<ol0?@3oool303?o00h0oooo0`0co`0l0?ooo`<0<ol03P3oool303?o09l0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00`0oooo0P00000O
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0G03oool00200oooo00<000000?oo
o`3oool06P3oool303?o0100oooo100co`0j0?ooo`<0<ol0403oool303?o03X0oooo0`0co`0@0?oo
o`<0<ol0WP3oool00`000000oooo0?ooo`0I0?ooo`800000<03oool00`000000oooo0?ooo`0=0?oo
o`8000007`3oool2000001/0oooo00<000000?ooo`3oool0G03oool00200oooo00<000000?ooo`3o
ool06@3oool303?o01<0oooo0`0co`0h0?ooo`<0<ol04P3oool303?o03P0oooo0`0co`0B0?ooo`80
<ol0W@3oool00`000000oooo0?ooo`0H0?ooo`800000<P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01l0oooo0P00000J0?ooo`030000003oool0oooo05/0oooo000P0?ooo`030000
003oool0oooo01T0oooo0P0co`0E0?ooo`80<ol0=`3oool303?o01@0oooo0`0co`0f0?ooo`<0<ol0
503oool203?o09`0oooo00<000000?ooo`3oool05P3oool2000003@0oooo00<000000?ooo`3oool0
3P3oool200000280oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1K0?ooo`00803o
ool2000001T0oooo0`0co`0F0?ooo`80<ol0=@3oool303?o01H0oooo0`0co`0d0?ooo`<0<ol05@3o
ool303?o09/0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool08@3oool2000001L0oooo00<000000?ooo`3oool0F`3o
ool00200oooo00<000000?ooo`3oool0603oool203?o01L0oooo0`0co`0d0?ooo`80<ol0603oool2
03?o03@0oooo0P0co`0G0?ooo`80<ol0V`3oool00`000000oooo0?ooo`0C0?ooo`800000=`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0280oooo0P00000E0?ooo`030000003oool0
oooo05/0oooo000P0?ooo`030000003oool0oooo01L0oooo0`0co`0H0?ooo`80<ol0<`3oool203?o
01T0oooo0`0co`0b0?ooo`<0<ol0603oool203?o09T0oooo00<000000?ooo`3oool04P3oool20000
03T0oooo00<000000?ooo`3oool0403oool2000002D0oooo0P00000D0?ooo`030000003oool0oooo
05X0oooo000P0?ooo`030000003oool0oooo01L0oooo0P0co`0J0?ooo`80<ol0<@3oool303?o01X0
oooo0P0co`0b0?ooo`80<ol06@3oool303?o09P0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0i0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo05X0oooo000P0?ooo`030000003oool0oooo01H0oooo
0P0co`0K0?ooo`<0<ol0<03oool203?o01`0oooo0P0co`0`0?ooo`<0<ol06P3oool203?o09P0oooo
00<000000?ooo`3oool03`3oool2000003`0oooo00<000000?ooo`3oool04@3oool2000002L0oooo
0P00000A0?ooo`030000003oool0oooo05X0oooo000P0?ooo`030000003oool0oooo01D0oooo0`0c
o`0L0?ooo`80<ol0;`3oool203?o01d0oooo0P0co`0`0?ooo`80<ol0703oool203?o09H0oooo00<0
00000?ooo`3oool03P3oool2000003h0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0W0?ooo`800000403oool00`000000oooo0?ooo`1I0?ooo`00803oool2000001D0oooo0`0co`0N
0?ooo`80<ol0;@3oool303?o01h0oooo0P0co`0^0?ooo`80<ol07@3oool303?o09D0oooo00<00000
0?ooo`3oool0303oool200000400oooo00<000000?ooo`3oool04P3oool2000002X0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`1I0?ooo`00803oool00`000000oooo0?ooo`0D0?oo
o`80<ol07`3oool303?o02`0oooo0P0co`0O0?ooo`<0<ol0;03oool303?o01h0oooo0`0co`2D0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0C0?oo
o`800000:P3oool2000000d0oooo00<000000?ooo`3oool0F@3oool00200oooo00<000000?ooo`3o
ool04`3oool203?o0240oooo0`0co`0Z0?ooo`<0<ol0803oool203?o02/0oooo0`0co`0P0?ooo`80
<ol0U03oool00`000000oooo0?ooo`090?ooo`800000@`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo02X0oooo0P00000;0?ooo`030000003oool0oooo05T0oooo000P0?ooo`030000
003oool0oooo0180oooo0`0co`0R0?ooo`80<ol0:P3oool203?o0240oooo0`0co`0Z0?ooo`80<ol0
8@3oool303?o0980oooo00<000000?ooo`3oool0203oool2000004D0oooo00<000000?ooo`3oool0
503oool2000002d0oooo0P00000:0?ooo`030000003oool0oooo05P0oooo000H0?ooo`@00000103o
ool00`000000oooo0?ooo`0B0?ooo`80<ol08`3oool303?o02P0oooo0P0co`0S0?ooo`80<ol0:@3o
ool203?o02<0oooo0`0co`2A0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0A@3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`1H0?ooo`00603oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0140oooo0P0co`0U0?ooo`<0<ol09P3oool303?o02@0oooo0P0co`0W0?ooo`<0<ol0903oool2
03?o0940oooo00<000000?ooo`3oool01@3oool2000004P0oooo00<000000?ooo`3oool05@3oool2
000002l0oooo0P0000070?ooo`030000003oool0oooo05P0oooo000I0?ooo`030000003oool0oooo
00@0oooo0`00000@0?ooo`<0<ol09P3oool203?o02H0oooo0P0co`0U0?ooo`<0<ol09P3oool203?o
02H0oooo0P0co`2?0?ooo`030000003oool0oooo00@0oooo0P00001:0?ooo`030000003oool0oooo
01H0oooo0P00000`0?ooo`8000001P3oool00`000000oooo0?ooo`1G0?ooo`006P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0100oooo0P0co`0X0?ooo`80<ol0903oool203?o02L0
oooo0P0co`0U0?ooo`80<ol09`3oool303?o08h0oooo00<000000?ooo`3oool00P3oool2000004`0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0E`3oool001/0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0?0?ooo`80<ol0:@3oool303?o0280oooo0`0co`0X0?ooo`80<ol08`3oool303?o02P0oooo
0P0co`2>0?ooo`050000003oool0oooo0?ooo`000000CP3oool00`000000oooo0?ooo`0G0?ooo`80
0000<P3oool2000000<0oooo00<000000?ooo`3oool0E`3oool001P0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`0>0?ooo`<0<ol0:P3oool203?o0280oooo0P0co`0Y0?ooo`<0
<ol08P3oool203?o02X0oooo0P0co`2=0?ooo`040000003oool00000000004l0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0b0?ooo`80000000<0oooo0000003oool0F03oool001T0
oooo0P0000050?ooo`030000003oool0oooo00h0oooo0P0co`0/0?ooo`80<ol0803oool203?o02/0
oooo0P0co`0Q0?ooo`80<ol0:`3oool303?o08/0oooo0`00001A0?ooo`030000003oool0oooo01P0
oooo0P00000e0?ooo`<00000F03oool00200oooo00<000000?ooo`3oool03@3oool203?o02d0oooo
0`0co`0N0?ooo`<0<ol0;03oool203?o01l0oooo0`0co`0/0?ooo`80<ol0R`3oool300000540oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`<00000F03oool00200oooo0P00
000=0?ooo`<0<ol0;P3oool203?o01h0oooo0P0co`0]0?ooo`<0<ol07P3oool203?o02h0oooo0P0c
o`2=0?ooo`@00000C@3oool00`000000oooo0?ooo`0I0?ooo`800000<03oool4000005/0oooo000P
0?ooo`030000003oool0oooo00/0oooo0`0co`0`0?ooo`80<ol0703oool203?o02l0oooo0P0co`0M
0?ooo`80<ol0;`3oool303?o0900oooo100000190?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool0:P3oool4000005l0oooo000P0?ooo`030000003oool0oooo00/0oooo0P0co`0a0?oo
o`<0<ol06P3oool303?o0300oooo0P0co`0K0?ooo`<0<ol0<03oool203?o01/0oooo00<0<ol00?oo
o`3oool0MP3oool4000004D0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0U0?oo
o`@00000H`3oool00200oooo00<000000?ooo`3oool02P3oool203?o03<0oooo0P0co`0I0?ooo`<0
<ol0<@3oool303?o01X0oooo0P0co`0a0?ooo`<0<ol06P3oool203?o07/0oooo100000110?ooo`03
0000003oool0oooo01/0oooo0P00000R0?ooo`@00000I`3oool00200oooo00<000000?ooo`3oool0
2@3oool303?o03<0oooo0`0co`0H0?ooo`80<ol0<`3oool303?o01P0oooo0P0co`0c0?ooo`80<ol0
6@3oool203?o0800oooo1@00000l0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
6`3oool5000006/0oooo000P0?ooo`030000003oool0oooo00P0oooo0`0co`0e0?ooo`80<ol05`3o
ool203?o03D0oooo0P0co`0G0?ooo`<0<ol0=03oool203?o01L0oooo0`0co`250?ooo`@00000>03o
ool00`000000oooo0?ooo`0L0?ooo`800000603oool400000700oooo000P0?ooo`8000002@3oool2
03?o03L0oooo0P0co`0E0?ooo`80<ol0=`3oool203?o01D0oooo0`0co`0e0?ooo`<0<ol05@3oool3
03?o08X0oooo1000000d0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool04P3oool4
000007@0oooo000P0?ooo`030000003oool0oooo00L0oooo0P0co`0h0?ooo`<0<ol04`3oool303?o
03L0oooo0`0co`0D0?ooo`80<ol0=`3oool303?o01@0oooo0P0co`2?0?ooo`@00000<03oool00`00
0000oooo0?ooo`0M0?ooo`8000003`3oool4000007P0oooo000P0?ooo`030000003oool0oooo00H0
oooo0`0co`0i0?ooo`<0<ol04@3oool303?o03T0oooo0`0co`0B0?ooo`80<ol0>@3oool303?o0180
oooo0P0co`2D0?ooo`@00000;03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00T0
oooo1000001l0?ooo`00803oool00`000000oooo0?ooo`060?ooo`80<ol0>`3oool303?o0100oooo
0P0co`0k0?ooo`<0<ol0403oool303?o03X0oooo0`0co`0@0?ooo`<0<ol0V03oool5000002L0oooo
00<000000?ooo`3oool09@3oool500000800oooo000P0?ooo`030000003oool0oooo00D0oooo0P0c
o`0m0?ooo`<0<ol03P3oool203?o03d0oooo0`0co`0>0?ooo`<0<ol0?03oool303?o00h0oooo0`0c
o`2N0?ooo`@000008`3oool00`000000oooo0?ooo`0Q0?ooo`@00000Q@3oool00200oooo0P000005
0?ooo`<0<ol0?P3oool203?o00d0oooo0`0co`0n0?ooo`<0<ol0303oool303?o03h0oooo100co`0;
0?ooo`<0<ol0X`3oool4000001l0oooo00<000000?ooo`3oool07@3oool4000008T0oooo000P0?oo
o`030000003oool0oooo0080oooo100co`0o0?ooo`@0<ol02@3oool403?o0400oooo100co`090?oo
o`<0<ol0@03oool403?o00P0oooo100co`2X0?ooo`@000006`3oool00`000000oooo0?ooo`0I0?oo
o`@00000S@3oool00200oooo00@000000?ooo`3oool0oooo0`0co`120?ooo`D0<ol01P3oool303?o
04<0oooo100co`050?ooo`D0<ol0@`3oool303?o00H0oooo100co`2]0?ooo`@000005`3oool00`00
0000oooo0?ooo`0E0?ooo`@00000T@3oool00200oooo1P0co`150?ooo`/0<ol0AP3oool;03?o04D0
oooo2P0co`2c0?ooo`D000004P3oool00`000000oooo0?ooo`0@0?ooo`D00000U@3oool001l0oooo
1P0co`170?ooo`T0<ol0B03oool703?o04T0oooo200co`2i0?ooo`@000003P3oool00`000000oooo
0?ooo`0<0?ooo`@00000VP3oool001l0oooo0`0co`1=0?ooo`<0<ol0CP3oool203?o04h0oooo0P0c
o`300?ooo`@000002P3oool00`000000oooo0?ooo`080?ooo`@00000WP3oool00200oooo0P00003o
0?oookD0oooo100000060?ooo`030000003oool0oooo00@0oooo1000002R0?ooo`00803oool00`00
0000oooo0?ooo`3o0?oookP0oooo100000020?ooo`030000003oool0oooo00@00000YP3oool00?l0
oooog`3oool500000:X0oooo003o0?ooool0ooooS`3oool00?l0ooooo`3ooon?0?ooo`00o`3ooooo
0?ooohl0oooo003o0?ooool0ooooS`3oool00?l0ooooo`3ooon?0?ooo`00o`3ooooo0?ooohl0oooo
003o0?ooool0ooooS`3oool00?l0ooooo`3ooon?0?ooo`00o`3ooooo0?ooohl0oooo000M0?ooo`80
000000<0oooo000000000000o`3ooonC0?ooo`80000000<0oooo0000000000000P3oool400000<h0
oooo000N0?ooo`030000003oool000000?l0ooooU@3oool00`000000oooo000000050?ooo`030000
003oool0oooo0<d0oooo000O0?ooo`030000003oool0oooo0?l0ooooU@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0<d0oooo000N0?ooo`030000003oool000000?l0ooooU@3oool0
0`000000oooo000000050?ooo`030000003oool0oooo0<d0oooo000M0?ooo`80000000<0oooo0000
00000000o`3ooonC0?ooo`80000000<0oooo000000000000103oool00`000000oooo0?ooo`3=0?oo
o`00o`3ooonl0?ooo`<00000c`3oool00?l0oooo_P3oool00`000000oooo0?ooo`3=0?ooo`00o`3o
oooo0?ooohl0oooo003o0?ooool0ooooS`3oool00?l0ooooo`3ooon?0?ooo`00o`3ooooo0?ooohl0
oooo0000\
\>"],
  ImageRangeCache->{{{0, 652}, {191.125, 0}} -> {-0.0541781, -0.0147182, \
0.00323368, 0.00323368}, {{16.75, 311.25}, {186.562, 4.5}} -> {-2.55414, \
-2.99915, 0.0783964, 0.0343389}, {{340.688, 635.188}, {186.562, 4.5}} -> \
{-1.97316, -0.0234995, 0.0051496, 0.0051496}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{xPlot[0, 0, 1], 
            xLPlot[0, 0, 1\ , Ticks \[Rule] None\ ]}]];\)\)], "Input",
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.309017 0.111495 [
[.2619 .29652 -3 -9 ]
[.2619 .29652 3 0 ]
[.5 .29652 -6 -9 ]
[.5 .29652 6 0 ]
[.7381 .29652 -6 -9 ]
[.7381 .29652 6 0 ]
[.97619 .29652 -6 -9 ]
[.97619 .29652 6 0 ]
[1.025 .30902 0 -4.90625 ]
[1.025 .30902 10 4.90625 ]
[.01131 .08603 -12 -4.5 ]
[.01131 .08603 0 4.5 ]
[.01131 .19752 -12 -4.5 ]
[.01131 .19752 0 4.5 ]
[.01131 .42051 -6 -4.5 ]
[.01131 .42051 0 4.5 ]
[.01131 .53201 -6 -4.5 ]
[.01131 .53201 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30902 m
.2619 .31527 L
s
[(5)] .2619 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(10)] .5 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(15)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(20)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .08603 m
.03006 .08603 L
s
[(-2)] .01131 .08603 1 0 Mshowa
.02381 .19752 m
.03006 .19752 L
s
[(-1)] .01131 .19752 1 0 Mshowa
.02381 .42051 m
.03006 .42051 L
s
[(1)] .01131 .42051 1 0 Mshowa
.02381 .53201 m
.03006 .53201 L
s
[(2)] .01131 .53201 1 0 Mshowa
.125 Mabswid
.02381 .10833 m
.02756 .10833 L
s
.02381 .13063 m
.02756 .13063 L
s
.02381 .15292 m
.02756 .15292 L
s
.02381 .17522 m
.02756 .17522 L
s
.02381 .21982 m
.02756 .21982 L
s
.02381 .24212 m
.02756 .24212 L
s
.02381 .26442 m
.02756 .26442 L
s
.02381 .28672 m
.02756 .28672 L
s
.02381 .33132 m
.02756 .33132 L
s
.02381 .35361 m
.02756 .35361 L
s
.02381 .37591 m
.02756 .37591 L
s
.02381 .39821 m
.02756 .39821 L
s
.02381 .44281 m
.02756 .44281 L
s
.02381 .46511 m
.02756 .46511 L
s
.02381 .48741 m
.02756 .48741 L
s
.02381 .50971 m
.02756 .50971 L
s
.02381 .06373 m
.02756 .06373 L
s
.02381 .04143 m
.02756 .04143 L
s
.02381 .01913 m
.02756 .01913 L
s
.02381 .55431 m
.02756 .55431 L
s
.02381 .5766 m
.02756 .5766 L
s
.02381 .5989 m
.02756 .5989 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 1 0 r
.01 w
.02381 .60332 m
.02499 .60328 L
.02605 .60319 L
.02729 .603 L
.02846 .60275 L
.03053 .60214 L
.03279 .60122 L
.03527 .59991 L
.0379 .59818 L
.04262 .59425 L
.05205 .58342 L
.06244 .56765 L
.08274 .53008 L
.09394 .50887 L
.10458 .49063 L
.11464 .47652 L
.12033 .47029 L
.12562 .46582 L
.12813 .46416 L
.1305 .46289 L
.13263 .46199 L
.13494 .46129 L
.13613 .46103 L
.13745 .46083 L
.13811 .46076 L
.13883 .46071 L
.14011 .4607 L
.14139 .46077 L
.1426 .46092 L
.14368 .46111 L
.14487 .4614 L
.1472 .46217 L
.14972 .46331 L
.15427 .46619 L
.15968 .47091 L
.16464 .4764 L
.18565 .50925 L
.20618 .54838 L
.21618 .56638 L
.22527 .58059 L
.22982 .58664 L
.23475 .59226 L
.23901 .59625 L
.2437 .59966 L
.24627 .60106 L
.24867 .60208 L
.25 .60251 L
.25121 .60282 L
.25188 .60296 L
.25261 .60309 L
Mistroke
.2533 .60318 L
.25394 .60325 L
.25518 .60331 L
.25634 .6033 L
.25738 .60323 L
.25851 .60309 L
.25975 .60286 L
.26105 .60253 L
.26338 .60172 L
.26594 .60052 L
.26836 .59908 L
.27289 .5956 L
.27776 .5908 L
.28306 .58441 L
.30141 .55499 L
.32083 .51794 L
.33114 .4992 L
.34224 .48191 L
.3474 .47532 L
.35283 .46958 L
.35747 .46575 L
.36012 .46403 L
.36253 .46277 L
.36371 .46226 L
.36499 .46178 L
.36609 .46144 L
.3673 .46114 L
.36859 .46091 L
.3693 .46082 L
.36995 .46075 L
.37113 .4607 L
.3724 .46072 L
.37357 .46081 L
.37485 .461 L
.37607 .46125 L
.37719 .46156 L
.37931 .46231 L
.38156 .46336 L
.38644 .4665 L
.39091 .4704 L
.40101 .48239 L
.41928 .5127 L
.43978 .55183 L
.44978 .56945 L
.45887 .58313 L
.46341 .58884 L
.46833 .59407 L
.47298 .59799 L
.47727 .60068 L
.47962 .60177 L
Mistroke
.48182 .60252 L
.48308 .60285 L
.48423 .60307 L
.48487 .60316 L
.48556 .60324 L
.48682 .60331 L
.48751 .60332 L
.48816 .6033 L
.48937 .60321 L
.49067 .60303 L
.4914 .60288 L
.49207 .60273 L
.49444 .602 L
.49695 .60091 L
.4995 .59947 L
.50191 .59782 L
.50643 .59396 L
.5166 .58202 L
.53494 .55172 L
.55317 .51684 L
.56355 .49809 L
.57329 .4829 L
.58281 .47132 L
.58817 .46654 L
.59071 .46475 L
.59308 .46337 L
.59544 .46227 L
.59665 .46182 L
.59797 .46141 L
.59872 .46122 L
.59941 .46107 L
.60006 .46095 L
.60077 .46085 L
.60201 .46073 L
.60331 .46069 L
.60403 .46071 L
.60472 .46075 L
.606 .4609 L
.60672 .46102 L
.60738 .46115 L
.60888 .46154 L
.6114 .46245 L
.61409 .46378 L
.61947 .46751 L
.62441 .47216 L
.63556 .48641 L
.65574 .5216 L
.67622 .56035 L
.68621 .57682 L
.6953 .589 L
Mistroke
.69983 .59382 L
.70475 .598 L
.707 .59953 L
.70939 .60087 L
.71143 .60179 L
.71368 .60255 L
.71499 .60288 L
.71623 .60311 L
.71735 .60324 L
.71857 .60331 L
.71989 .6033 L
.72063 .60326 L
.7213 .60319 L
.7226 .60299 L
.72383 .60273 L
.72499 .60241 L
.72621 .60199 L
.7284 .60106 L
.73335 .59806 L
.7383 .59386 L
.74282 .58906 L
.75298 .57528 L
.77131 .54302 L
.79199 .50386 L
.80109 .48871 L
.80593 .48168 L
.81114 .47506 L
.81614 .46979 L
.82072 .46595 L
.8251 .46323 L
.8273 .46223 L
.82972 .46142 L
.83105 .4611 L
.8323 .46088 L
.83343 .46076 L
.83466 .4607 L
.83529 .4607 L
.83599 .46072 L
.83672 .46078 L
.83741 .46085 L
.83863 .46105 L
.83994 .46134 L
.84116 .4617 L
.84249 .46217 L
.84491 .46327 L
.84946 .46613 L
.85478 .47074 L
.85979 .47625 L
.86916 .4892 L
.89014 .52667 L
Mistroke
.90855 .56135 L
.91899 .57834 L
.92409 .58537 L
.92873 .59088 L
.93335 .59545 L
.93837 .59928 L
.94113 .60086 L
.94368 .60198 L
.94494 .60241 L
.94612 .60273 L
.94734 .603 L
.948 .60311 L
.9487 .6032 L
.94934 .60326 L
.95003 .6033 L
.95126 .60331 L
.95202 .60328 L
.95273 .60323 L
.95337 .60315 L
.95406 .60305 L
.95549 .60275 L
.957 .60233 L
.9597 .60127 L
.96218 .59998 L
.9645 .59849 L
.96978 .59413 L
.97619 .58714 L
Mfstroke
0 .4 1 r
.009 w
.02381 .26148 m
.02499 .2615 L
.02605 .26156 L
.02729 .26169 L
.02846 .26185 L
.03053 .26226 L
.03279 .26288 L
.03527 .26375 L
.0379 .2649 L
.04262 .26752 L
.05205 .27474 L
.06244 .28526 L
.08274 .3103 L
.09394 .32444 L
.10458 .3366 L
.11464 .34601 L
.12033 .35016 L
.12562 .35314 L
.12813 .35424 L
.1305 .35509 L
.13263 .35569 L
.13494 .35616 L
.13613 .35634 L
.13745 .35647 L
.13811 .35652 L
.13883 .35655 L
.14011 .35656 L
.14139 .35651 L
.1426 .35641 L
.14368 .35628 L
.14487 .35609 L
.1472 .35558 L
.14972 .35481 L
.15427 .35289 L
.15968 .34975 L
.16464 .34609 L
.18565 .32419 L
.20618 .2981 L
.21618 .2861 L
.22527 .27663 L
.22982 .27259 L
.23475 .26885 L
.23901 .26618 L
.2437 .26392 L
.24627 .26298 L
.24867 .2623 L
.25 .26202 L
.25121 .26181 L
.25188 .26171 L
.25261 .26163 L
Mistroke
.2533 .26157 L
.25394 .26152 L
.25518 .26148 L
.25634 .26149 L
.25738 .26153 L
.25851 .26163 L
.25975 .26178 L
.26105 .262 L
.26338 .26254 L
.26594 .26334 L
.26836 .2643 L
.27289 .26662 L
.27776 .26982 L
.28306 .27408 L
.30141 .2937 L
.32083 .31839 L
.33114 .33089 L
.34224 .34242 L
.3474 .34681 L
.35283 .35063 L
.35747 .35319 L
.36012 .35434 L
.36253 .35518 L
.36371 .35552 L
.36499 .35583 L
.36609 .35606 L
.3673 .35626 L
.36859 .35642 L
.3693 .35648 L
.36995 .35652 L
.37113 .35656 L
.3724 .35654 L
.37357 .35648 L
.37485 .35636 L
.37607 .35619 L
.37719 .35598 L
.37931 .35548 L
.38156 .35478 L
.38644 .35269 L
.39091 .35009 L
.40101 .34209 L
.41928 .32189 L
.43978 .2958 L
.44978 .28405 L
.45887 .27494 L
.46341 .27113 L
.46833 .26764 L
.47298 .26503 L
.47727 .26323 L
.47962 .26251 L
Mistroke
.48182 .262 L
.48308 .26179 L
.48423 .26164 L
.48487 .26158 L
.48556 .26153 L
.48682 .26148 L
.48751 .26148 L
.48816 .26149 L
.48937 .26155 L
.49067 .26167 L
.4914 .26176 L
.49207 .26187 L
.49444 .26236 L
.49695 .26308 L
.4995 .26404 L
.50191 .26514 L
.50643 .26771 L
.5166 .27568 L
.53494 .29588 L
.55317 .31913 L
.56355 .33163 L
.57329 .34176 L
.58281 .34947 L
.58817 .35266 L
.59071 .35386 L
.59308 .35478 L
.59544 .35551 L
.59665 .35581 L
.59797 .35608 L
.59872 .35621 L
.59941 .35631 L
.60006 .35639 L
.60077 .35645 L
.60201 .35653 L
.60331 .35656 L
.60403 .35655 L
.60472 .35652 L
.606 .35642 L
.60672 .35634 L
.60738 .35625 L
.60888 .356 L
.6114 .35539 L
.61409 .3545 L
.61947 .35201 L
.62441 .34892 L
.63556 .33942 L
.65574 .31596 L
.67622 .29012 L
.68621 .27914 L
.6953 .27102 L
Mistroke
.69983 .26781 L
.70475 .26502 L
.707 .264 L
.70939 .26311 L
.71143 .26249 L
.71368 .26198 L
.71499 .26177 L
.71623 .26162 L
.71735 .26153 L
.71857 .26148 L
.71989 .26149 L
.72063 .26152 L
.7213 .26156 L
.7226 .26169 L
.72383 .26187 L
.72499 .26208 L
.72621 .26236 L
.7284 .26298 L
.73335 .26498 L
.7383 .26778 L
.74282 .27098 L
.75298 .28017 L
.77131 .30167 L
.79199 .32778 L
.80109 .33788 L
.80593 .34257 L
.81114 .34698 L
.81614 .3505 L
.82072 .35306 L
.8251 .35487 L
.8273 .35554 L
.82972 .35608 L
.83105 .35629 L
.8323 .35643 L
.83343 .35652 L
.83466 .35656 L
.83529 .35656 L
.83599 .35654 L
.83672 .3565 L
.83741 .35645 L
.83863 .35632 L
.83994 .35613 L
.84116 .35589 L
.84249 .35557 L
.84491 .35484 L
.84946 .35294 L
.85478 .34986 L
.85979 .34619 L
.86916 .33755 L
.89014 .31258 L
Mistroke
.90855 .28945 L
.91899 .27813 L
.92409 .27344 L
.92873 .26977 L
.93335 .26672 L
.93837 .26417 L
.94113 .26311 L
.94368 .26237 L
.94494 .26208 L
.94612 .26187 L
.94734 .26169 L
.948 .26162 L
.9487 .26156 L
.94934 .26151 L
.95003 .26149 L
.95126 .26148 L
.95202 .2615 L
.95273 .26154 L
.95337 .26159 L
.95406 .26166 L
.95549 .26185 L
.957 .26213 L
.9597 .26284 L
.96218 .2637 L
.9645 .2647 L
.96978 .2676 L
.97619 .27226 L
Mfstroke
1 0 .6 r
.007 w
.02381 .15734 m
.02499 .1573 L
.02605 .15721 L
.02729 .15702 L
.02846 .15677 L
.03053 .15616 L
.03279 .15524 L
.03527 .15393 L
.0379 .1522 L
.04262 .14827 L
.05205 .13744 L
.06244 .12167 L
.08274 .0841 L
.09394 .06289 L
.10458 .04465 L
.11464 .03054 L
.12033 .02431 L
.12562 .01984 L
.12813 .01818 L
.1305 .01691 L
.13263 .01602 L
.13494 .01531 L
.13613 .01505 L
.13745 .01485 L
.13811 .01478 L
.13883 .01473 L
.14011 .01472 L
.14139 .01479 L
.1426 .01494 L
.14368 .01513 L
.14487 .01542 L
.1472 .01619 L
.14972 .01733 L
.15427 .02021 L
.15968 .02493 L
.16464 .03042 L
.18565 .06327 L
.20618 .1024 L
.21618 .1204 L
.22527 .13461 L
.22982 .14066 L
.23475 .14628 L
.23901 .15028 L
.2437 .15368 L
.24627 .15508 L
.24867 .1561 L
.25 .15653 L
.25121 .15684 L
.25188 .15698 L
.25261 .15711 L
Mistroke
.2533 .1572 L
.25394 .15727 L
.25518 .15734 L
.25634 .15732 L
.25738 .15725 L
.25851 .15711 L
.25975 .15688 L
.26105 .15655 L
.26338 .15575 L
.26594 .15454 L
.26836 .1531 L
.27289 .14962 L
.27776 .14482 L
.28306 .13843 L
.30141 .10901 L
.32083 .07197 L
.33114 .05322 L
.34224 .03593 L
.3474 .02934 L
.35283 .0236 L
.35747 .01977 L
.36012 .01805 L
.36253 .01679 L
.36371 .01628 L
.36499 .01581 L
.36609 .01547 L
.3673 .01516 L
.36859 .01493 L
.3693 .01484 L
.36995 .01477 L
.37113 .01472 L
.3724 .01474 L
.37357 .01483 L
.37485 .01502 L
.37607 .01527 L
.37719 .01558 L
.37931 .01633 L
.38156 .01738 L
.38644 .02052 L
.39091 .02442 L
.40101 .03641 L
.41928 .06672 L
.43978 .10585 L
.44978 .12347 L
.45887 .13715 L
.46341 .14286 L
.46833 .14809 L
.47298 .15201 L
.47727 .15471 L
.47962 .15579 L
Mistroke
.48182 .15655 L
.48308 .15687 L
.48423 .15709 L
.48487 .15718 L
.48556 .15726 L
.48682 .15733 L
.48751 .15734 L
.48816 .15732 L
.48937 .15723 L
.49067 .15705 L
.4914 .15691 L
.49207 .15675 L
.49444 .15602 L
.49695 .15493 L
.4995 .15349 L
.50191 .15184 L
.50643 .14798 L
.5166 .13604 L
.53494 .10574 L
.55317 .07086 L
.56355 .05211 L
.57329 .03692 L
.58281 .02534 L
.58817 .02056 L
.59071 .01877 L
.59308 .01739 L
.59544 .01629 L
.59665 .01584 L
.59797 .01543 L
.59872 .01524 L
.59941 .01509 L
.60006 .01497 L
.60077 .01487 L
.60201 .01475 L
.60331 .01472 L
.60403 .01473 L
.60472 .01477 L
.606 .01492 L
.60672 .01504 L
.60738 .01517 L
.60888 .01556 L
.6114 .01647 L
.61409 .0178 L
.61947 .02153 L
.62441 .02618 L
.63556 .04043 L
.65574 .07562 L
.67622 .11437 L
.68621 .13084 L
.6953 .14302 L
Mistroke
.69983 .14784 L
.70475 .15202 L
.707 .15355 L
.70939 .15489 L
.71143 .15581 L
.71368 .15658 L
.71499 .1569 L
.71623 .15713 L
.71735 .15726 L
.71857 .15733 L
.71989 .15732 L
.72063 .15728 L
.7213 .15721 L
.7226 .15702 L
.72383 .15675 L
.72499 .15643 L
.72621 .15601 L
.7284 .15508 L
.73335 .15208 L
.7383 .14788 L
.74282 .14308 L
.75298 .1293 L
.77131 .09704 L
.79199 .05788 L
.80109 .04273 L
.80593 .0357 L
.81114 .02908 L
.81614 .02381 L
.82072 .01997 L
.8251 .01725 L
.8273 .01625 L
.82972 .01544 L
.83105 .01512 L
.8323 .0149 L
.83343 .01478 L
.83466 .01472 L
.83529 .01472 L
.83599 .01474 L
.83672 .0148 L
.83741 .01487 L
.83863 .01507 L
.83994 .01536 L
.84116 .01572 L
.84249 .01619 L
.84491 .01729 L
.84946 .02015 L
.85478 .02476 L
.85979 .03027 L
.86916 .04322 L
.89014 .08069 L
Mistroke
.90855 .11537 L
.91899 .13236 L
.92409 .13939 L
.92873 .1449 L
.93335 .14947 L
.93837 .1533 L
.94113 .15488 L
.94368 .156 L
.94494 .15643 L
.94612 .15675 L
.94734 .15702 L
.948 .15713 L
.9487 .15722 L
.94934 .15728 L
.95003 .15732 L
.95126 .15733 L
.95202 .1573 L
.95273 .15725 L
.95337 .15717 L
.95406 .15707 L
.95549 .15678 L
.957 .15635 L
.9597 .15529 L
.96218 .154 L
.9645 .15251 L
.96978 .14815 L
.97619 .14116 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 5.12828e-17 1.16608 [
[.30907 .06148 -14.3775 -9.8125 ]
[.30907 .06148 1.62253 0 ]
[.2142 1.04697 -8.70051 0 ]
[.2142 1.04697 7.29949 9.8125 ]
[-0.03373 .52941 -16 -3.08918 ]
[-0.03373 .52941 0 6.72332 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
gsave
.30907 .06148 -75.3775 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
0 .80374 m
.40037 1.0855 L
s
gsave
.2142 1.04697 -69.7005 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
.08846 .24555 m
0 .80374 L
s
gsave
-0.03373 .52941 -77 -7.08918 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x3) show
1.000 setlinewidth
grestore
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.42216 .58164 m
.42725 .58171 L
s
.42733 .58171 m
.42216 .58164 L
s
.42216 .58164 m
.42717 .58171 L
s
.42741 .58171 m
.42216 .58164 L
s
.42216 .58164 m
.4271 .58171 L
s
.42749 .58171 m
.42216 .58164 L
s
.42216 .58164 m
.42702 .58171 L
s
.42757 .58171 m
.42216 .58164 L
s
.42702 .58171 m
.44221 .58191 L
s
.4271 .58171 m
.44237 .58191 L
s
.42717 .58171 m
.44253 .58191 L
s
.42725 .58171 m
.44269 .58192 L
s
.44284 .58192 m
.42733 .58171 L
s
.443 .58192 m
.42741 .58171 L
s
.44316 .58192 m
.42749 .58171 L
s
.44332 .58192 m
.42757 .58171 L
s
.44221 .58191 m
.46785 .58225 L
s
.44237 .58191 m
.46809 .58226 L
s
.44253 .58191 m
.46832 .58226 L
s
.44269 .58192 m
.46856 .58226 L
s
.4688 .58227 m
.44284 .58192 L
s
.46904 .58227 m
.443 .58192 L
s
.46928 .58227 m
.44316 .58192 L
s
.46952 .58228 m
.44332 .58192 L
s
.46785 .58225 m
.50367 .58273 L
s
.46809 .58226 m
.50398 .58274 L
s
.46832 .58226 m
.50429 .58274 L
s
.46856 .58226 m
.5046 .58275 L
s
.50491 .58275 m
.4688 .58227 L
s
.50523 .58276 m
.46904 .58227 L
s
.50554 .58276 m
.46928 .58227 L
s
.50585 .58276 m
.46952 .58228 L
s
.50367 .58273 m
.54826 .58333 L
s
.50398 .58274 m
.54863 .58334 L
s
.50429 .58274 m
.549 .58334 L
s
.5046 .58275 m
.54936 .58335 L
s
.54973 .58335 m
.50491 .58275 L
s
.5501 .58336 m
.50523 .58276 L
s
.55047 .58336 m
.50554 .58276 L
s
.55084 .58337 m
.50585 .58276 L
s
.54826 .58333 m
.59793 .584 L
s
.54863 .58334 m
.59831 .58401 L
s
.549 .58334 m
.5987 .58401 L
s
.54936 .58335 m
.59908 .58402 L
s
.59947 .58402 m
.54973 .58335 L
s
.59985 .58403 m
.5501 .58336 L
s
.60023 .58403 m
.55047 .58336 L
s
.60062 .58404 m
.55084 .58337 L
s
.59793 .584 m
.64563 .58464 L
s
.59831 .58401 m
.64596 .58465 L
s
.5987 .58401 m
.64629 .58465 L
s
.59908 .58402 m
.64663 .58466 L
s
.64696 .58466 m
.59947 .58402 L
s
.64729 .58466 m
.59985 .58403 L
s
.64762 .58467 m
.60023 .58403 L
s
.64794 .58467 m
.60062 .58404 L
s
.64563 .58464 m
.68132 .58512 L
s
.64596 .58465 m
.68151 .58512 L
s
.64629 .58465 m
.68171 .58513 L
s
.64663 .58466 m
.68191 .58513 L
s
.68211 .58513 m
.64696 .58466 L
s
.6823 .58513 m
.64729 .58466 L
s
.68249 .58514 m
.64762 .58467 L
s
.68268 .58514 m
.64794 .58467 L
s
.68287 .58514 m
.64827 .58468 L
s
.68132 .58512 m
.69519 .58531 L
s
.68151 .58512 m
.69519 .58531 L
s
.68171 .58513 m
.6952 .58531 L
s
.68191 .58513 m
.6952 .58531 L
s
.6952 .58531 m
.68211 .58513 L
s
.6952 .58531 m
.6823 .58513 L
s
.6952 .58531 m
.68249 .58514 L
s
.69519 .58531 m
.68268 .58514 L
s
.69519 .58531 m
.68287 .58514 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
gsave
.30907 .06148 -75.3775 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
0 .80374 m
.40037 1.0855 L
s
gsave
.2142 1.04697 -69.7005 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{670, 197.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:N0000aB000`400?l00000o`00003oo`3ooooo
0?oooj00oooo003o0?ooool0ooooX03oool00?l0ooooo`3ooonP0?ooo`00o`3ooooo0?oooj00oooo
003o0?ooool0ooooX03oool00240oooo00<000000?ooo`3oool0o`3ooooh0?ooo`800000P@3oool0
0240oooo00<000000?ooo`3oool0o`3oooof0?ooo`80000000<0oooo000000000000P03oool00240
oooo00<000000?ooo`3oool0o`3ooood0?ooo`8000000`3oool200000800oooo000Q0?ooo`030000
003oool0oooo0?l0ooool@3oool3000000D0oooo00<000000?ooo`000000O`3oool00240oooo00<0
00000?ooo`3oool06`3oool40?l0VC`0oooo103o09Tk0?ooo`D0o`2I?03oool40?l0VLl0oooo0P00
00000`3oool00000000000020?ooo`@00000=@3oool2000000P0oooo00<000000?ooo`000000O`3o
ool00240oooo0P00000J0?ooo`80o`2I103oool20?l0VCP0oooo0P3o09T40?ooo`030?l0V@3oool0
oooo03L0oooo0P3o09T30?ooo`<0o`2I>03oool20?l0V@<0oooo0P3o09W?0?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool0<P3oool2000000X0oooo00@000000?ooo`3oool00000OP3o
ool00240oooo00<000000?ooo`3oool0603oool20?l0V@H0oooo0P3o09Tf0?ooo`80o`2I1P3oool2
0?l0VCH0oooo00<0o`2I0?ooo`3oool01@3oool20?l0VCH0oooo00<0o`2I0?ooo`3oool01@3oool0
0`3o09T0oooo0?ooo`3=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;`3oool3
000000`0oooo00D000000?ooo`3oool0oooo0000001m0?ooo`008@3oool00`000000oooo0?ooo`0G
0?ooo`80o`2I2@3oool00`3o09T0oooo0?ooo`0b0?ooo`80o`2I203oool20?l0VC@0oooo00<0o`2I
0?ooo`3oool0203oool00`3o09T0oooo0?ooo`0a0?ooo`80o`2I2@3oool20?l0VL`0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`0]0?ooo`8000003`3oool01@000000oooo0?ooo`3o
ool0000007d0oooo000Q0?ooo`030000003oool0oooo01H0oooo00<0o`2I0?ooo`3oool02P3oool0
0`3o09T0oooo0?ooo`0`0?ooo`030?l0V@3oool0oooo00X0oooo00<0o`2I0?ooo`3oool0<03oool0
0`3o09T0oooo0?ooo`0:0?ooo`030?l0V@3oool0oooo02l0oooo0P3o09T;0?ooo`80o`2IbP3oool2
000000030?ooo`000000000000@0oooo00<000000?ooo`3oool0:P3oool300000140oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`1j0?ooo`008@3oool00`000000oooo0?ooo`0E0?oo
o`030?l0V@3oool0oooo00`0oooo00<0o`2I0?ooo`3oool0;P3oool00`3o09T0oooo0?ooo`0<0?oo
o`030?l0V@3oool0oooo02h0oooo00<0o`2I0?ooo`3oool02`3oool20?l0VBl0oooo0P3o09T=0?oo
o`80o`2Id03oool3000002X0oooo0P00000E0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0N@3oool00240oooo00<000000?ooo`3oool0503oool20?l0V@h0oooo00<0o`2I0?ooo`3o
ool0;@3oool00`3o09T0oooo0?ooo`0>0?ooo`030?l0V@3oool0oooo02`0oooo00<0o`2I0?ooo`3o
ool03@3oool00`3o09T0oooo0?ooo`0]0?ooo`030?l0V@3oool0oooo00d0oooo00<0o`2I0?ooo`3o
ool0d03oool00`000000oooo0?ooo`0V0?ooo`8000005`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo07T0oooo000Q0?ooo`8000005@3oool00`3o09T0oooo0?ooo`0>0?ooo`030?l0
V@3oool0oooo02/0oooo00<0o`2I0?ooo`3oool0403oool00`3o09T0oooo0?ooo`0Z0?ooo`030?l0
V@3oool0oooo00l0oooo00<0o`2I0?ooo`3oool0:`3oool20?l0V@l0oooo0P3o09Wg0?ooo`<00000
6@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo07P0oooo000Q0?ooo`030000003o
ool0oooo01<0oooo00<0o`2I0?ooo`3oool0403oool00`3o09T0oooo0?ooo`0Z0?ooo`030?l0V@3o
ool0oooo0100oooo00<0o`2I0?ooo`3oool0:@3oool20?l0VA80oooo00<0o`2I0?ooo`3oool0:P3o
ool00`3o09T0oooo0?ooo`0?0?ooo`030?l0V@3oool0oooo0?<0oooo0P00000L0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0N03oool00240oooo00<000000?ooo`3oool04P3oool0
0`3o09T0oooo0?ooo`0A0?ooo`030?l0V@3oool0oooo02T0oooo00<0o`2I0?ooo`3oool04P3oool0
0`3o09T0oooo0?ooo`0X0?ooo`030?l0V@3oool0oooo0140oooo00<0o`2I0?ooo`3oool0:@3oool0
0`3o09T0oooo0?ooo`0A0?ooo`030?l0V@3oool0oooo0?00oooo0P00000N0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0M`3oool00240oooo00<000000?ooo`3oool04P3oool00`3o
09T0oooo0?ooo`0B0?ooo`030?l0V@3oool0oooo02P0oooo00<0o`2I0?ooo`3oool04P3oool20?l0
VBP0oooo00<0o`2I0?ooo`3oool04`3oool00`3o09T0oooo0?ooo`0W0?ooo`80o`2I4`3oool00`3o
09T0oooo0?ooo`3]0?ooo`<00000803oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
07H0oooo000Q0?ooo`030000003oool0oooo0140oooo00<0o`2I0?ooo`3oool0503oool00`3o09T0
oooo0?ooo`0V0?ooo`030?l0V@3oool0oooo01@0oooo00<0o`2I0?ooo`3oool09@3oool20?l0VAD0
oooo00<0o`2I0?ooo`3oool09`3oool00`3o09T0oooo0?ooo`0C0?ooo`030?l0V@3oool0oooo0>X0
oooo0P00000S0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0MP3oool00240oooo
00<000000?ooo`3oool04@3oool00`3o09T0oooo0?ooo`0D0?ooo`030?l0V@3oool0oooo02D0oooo
00<0o`2I0?ooo`3oool05P3oool00`3o09T0oooo0?ooo`0T0?ooo`030?l0V@3oool0oooo01D0oooo
00<0o`2I0?ooo`3oool09@3oool00`3o09T0oooo0?ooo`0D0?ooo`030?l0V@3oool0oooo0>P0oooo
0P00000U0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0M@3oool00240oooo00<0
00000?ooo`3oool0403oool00`3o09T0oooo0?ooo`0F0?ooo`030?l0V@3oool0oooo02@0oooo00<0
o`2I0?ooo`3oool05P3oool00`3o09T0oooo0?ooo`0S0?ooo`80o`2I603oool00`3o09T0oooo0?oo
o`0S0?ooo`80o`2I5`3oool00`3o09T0oooo0?ooo`3T0?ooo`<000009`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo07D0oooo000Q0?ooo`800000403oool20?l0VAP0oooo0P3o09TT
0?ooo`030?l0V@3oool0oooo01P0oooo00<0o`2I0?ooo`3oool08P3oool00`3o09T0oooo0?ooo`0G
0?ooo`030?l0V@3oool0oooo02<0oooo00<0o`2I0?ooo`3oool05`3oool00`3o09T0oooo0?ooo`3Q
0?ooo`800000:P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo07@0oooo000Q0?oo
o`030000003oool0oooo00l0oooo00<0o`2I0?ooo`3oool0603oool00`3o09T0oooo0?ooo`0R0?oo
o`030?l0V@3oool0oooo01P0oooo0P3o09TR0?ooo`80o`2I6P3oool00`3o09T0oooo0?ooo`0Q0?oo
o`030?l0V@3oool0oooo01P0oooo00<0o`2I0?ooo`3oool0g`3oool2000002`0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`1c0?ooo`008@3oool00`000000oooo0?ooo`0>0?ooo`80
o`2I6`3oool00`3o09T0oooo0?ooo`0P0?ooo`030?l0V@3oool0oooo01X0oooo00<0o`2I0?ooo`3o
ool0803oool00`3o09T0oooo0?ooo`0I0?ooo`030?l0V@3oool0oooo0240oooo00<0o`2I0?ooo`3o
ool06@3oool00`3o09T0oooo0?ooo`3K0?ooo`<00000;P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo07<0oooo000Q0?ooo`030000003oool0oooo00h0oooo00<0o`2I0?ooo`3oool0
6P3oool00`3o09T0oooo0?ooo`0O0?ooo`80o`2I703oool00`3o09T0oooo0?ooo`0O0?ooo`80o`2I
703oool00`3o09T0oooo0?ooo`0O0?ooo`030?l0V@3oool0oooo01X0oooo00<0o`2I0?ooo`3oool0
f@3oool200000340oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1b0?ooo`00603o
ool4000000D0oooo00<000000?ooo`3oool03@3oool20?l0VAd0oooo00<0o`2I0?ooo`3oool07P3o
ool00`3o09T0oooo0?ooo`0L0?ooo`030?l0V@3oool0oooo01h0oooo00<0o`2I0?ooo`3oool06`3o
ool20?l0VB00oooo00<0o`2I0?ooo`3oool06`3oool00`3o09T0oooo0?ooo`3E0?ooo`<00000<`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0740oooo000H0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool03@3oool00`3o09T0oooo0?ooo`0L0?ooo`030?l0V@3oool0
oooo01d0oooo0P3o09TN0?ooo`030?l0V@3oool0oooo01d0oooo00<0o`2I0?ooo`3oool07@3oool0
0`3o09T0oooo0?ooo`0M0?ooo`030?l0V@3oool0oooo01`0oooo0P3o09WD0?ooo`800000=P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0740oooo000I0?ooo`030000003oool0oooo
00D0oooo0P00000=0?ooo`80o`2I7`3oool00`3o09T0oooo0?ooo`0L0?ooo`030?l0V@3oool0oooo
01h0oooo00<0o`2I0?ooo`3oool0703oool00`3o09T0oooo0?ooo`0M0?ooo`030?l0V@3oool0oooo
01d0oooo00<0o`2I0?ooo`3oool07@3oool00`3o09T0oooo0?ooo`3@0?ooo`800000>03oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0700oooo000B0?ooo`@00000103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<0o`2I0?ooo`3oool07P3oool00`3o09T0
oooo0?ooo`0K0?ooo`80o`2I803oool00`3o09T0oooo0?ooo`0K0?ooo`030?l0V@3oool0oooo01l0
oooo00<0o`2I0?ooo`3oool06`3oool00`3o09T0oooo0?ooo`0N0?ooo`80o`2IcP3oool3000003/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1`0?ooo`006`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00/0oooo00<0o`2I0?ooo`3oool0803oool00`3o09T0oooo
0?ooo`0J0?ooo`030?l0V@3oool0oooo0200oooo00<0o`2I0?ooo`3oool06P3oool00`3o09T0oooo
0?ooo`0O0?ooo`030?l0V@3oool0oooo01X0oooo0P3o09TQ0?ooo`030?l0V@3oool0oooo0<X0oooo
0P00000n0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0K`3oool001P0oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`0;0?ooo`030?l0V@3oool0oooo0200oooo
0P3o09TJ0?ooo`80o`2I8P3oool00`3o09T0oooo0?ooo`0I0?ooo`030?l0V@3oool0oooo0240oooo
00<0o`2I0?ooo`3oool06@3oool00`3o09T0oooo0?ooo`0P0?ooo`80o`2Ib@3oool200000400oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1^0?ooo`006@3oool2000000H0oooo00<0
00000?ooo`3oool02P3oool00`3o09T0oooo0?ooo`0R0?ooo`030?l0V@3oool0oooo01P0oooo00<0
o`2I0?ooo`3oool08@3oool20?l0VAT0oooo0P3o09TS0?ooo`030?l0V@3oool0oooo01P0oooo0P3o
09TS0?ooo`030?l0V@3oool0oooo0<@0oooo0`0000120?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0KP3oool00240oooo00<000000?ooo`3oool02P3oool00`3o09T0oooo0?ooo`0S
0?ooo`030?l0V@3oool0oooo01H0oooo0P3o09TT0?ooo`030?l0V@3oool0oooo01L0oooo00<0o`2I
0?ooo`3oool08`3oool00`3o09T0oooo0?ooo`0G0?ooo`030?l0V@3oool0oooo0280oooo0P3o09W3
0?ooo`800000A@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo06d0oooo000Q0?oo
o`8000002P3oool00`3o09T0oooo0?ooo`0T0?ooo`030?l0V@3oool0oooo01H0oooo00<0o`2I0?oo
o`3oool0903oool00`3o09T0oooo0?ooo`0E0?ooo`80o`2I9@3oool00`3o09T0oooo0?ooo`0F0?oo
o`030?l0V@3oool0oooo02@0oooo00<0o`2I0?ooo`3oool0_`3oool2000004L0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`1]0?ooo`008@3oool00`000000oooo0?ooo`090?ooo`03
0?l0V@3oool0oooo02D0oooo00<0o`2I0?ooo`3oool0503oool00`3o09T0oooo0?ooo`0U0?ooo`03
0?l0V@3oool0oooo01D0oooo00<0o`2I0?ooo`3oool0903oool20?l0VAL0oooo00<0o`2I0?ooo`3o
ool0903oool20?l0VKd0oooo0`0000190?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0K03oool00240oooo00<000000?ooo`3oool0203oool00`3o09T0oooo0?ooo`0V0?ooo`030?l0
V@3oool0oooo01@0oooo00<0o`2I0?ooo`3oool09P3oool00`3o09T0oooo0?ooo`0C0?ooo`030?l0
V@3oool0oooo02H0oooo00<0o`2I0?ooo`3oool0503oool00`3o09T0oooo0?ooo`0V0?ooo`030?l0
V@3oool0oooo0;T0oooo0P00001<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
J`3oool00240oooo00<000000?ooo`3oool01`3oool20?l0VBT0oooo00<0o`2I0?ooo`3oool04P3o
ool00`3o09T0oooo0?ooo`0W0?ooo`030?l0V@3oool0oooo01<0oooo00<0o`2I0?ooo`3oool09`3o
ool00`3o09T0oooo0?ooo`0C0?ooo`030?l0V@3oool0oooo02L0oooo00<0o`2I0?ooo`3oool0]P3o
ool2000004h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1[0?ooo`008@3oool0
0`000000oooo0?ooo`070?ooo`030?l0V@3oool0oooo02P0oooo0P3o09TB0?ooo`80o`2I:P3oool0
0`3o09T0oooo0?ooo`0A0?ooo`030?l0V@3oool0oooo02P0oooo0P3o09TC0?ooo`030?l0V@3oool0
oooo02P0oooo0P3o09Vd0?ooo`<00000D03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo06X0oooo000Q0?ooo`030000003oool0oooo00H0oooo00<0o`2I0?ooo`3oool0:P3oool00`3o
09T0oooo0?ooo`0@0?ooo`030?l0V@3oool0oooo02T0oooo0P3o09TB0?ooo`030?l0V@3oool0oooo
02T0oooo00<0o`2I0?ooo`3oool0403oool20?l0VB/0oooo00<0o`2I0?ooo`3oool0/03oool20000
05<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1Z0?ooo`008@3oool2000000H0
oooo0P3o09T/0?ooo`80o`2I403oool00`3o09T0oooo0?ooo`0[0?ooo`030?l0V@3oool0oooo00l0
oooo00<0o`2I0?ooo`3oool0:`3oool00`3o09T0oooo0?ooo`0?0?ooo`030?l0V@3oool0oooo02/0
oooo00<0o`2I0?ooo`3oool0[03oool3000005D0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`1Y0?ooo`008@3oool00`000000oooo0?ooo`050?ooo`030?l0V@3oool0oooo02`0oooo
00<0o`2I0?ooo`3oool03P3oool00`3o09T0oooo0?ooo`0[0?ooo`80o`2I3`3oool20?l0VBh0oooo
00<0o`2I0?ooo`3oool03@3oool00`3o09T0oooo0?ooo`0/0?ooo`80o`2IZ`3oool2000005P0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1X0?ooo`008@3oool00`000000oooo0?oo
o`040?ooo`030?l0V@3oool0oooo02d0oooo0P3o09T>0?ooo`030?l0V@3oool0oooo02d0oooo0P3o
09T>0?ooo`030?l0V@3oool0oooo02h0oooo00<0o`2I0?ooo`3oool0303oool00`3o09T0oooo0?oo
o`0]0?ooo`030?l0V@3oool0oooo0:L0oooo0P00001J0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0J03oool00240oooo00<000000?ooo`3oool00`3oool00`3o09T0oooo0?ooo`0_
0?ooo`80o`2I303oool20?l0VC00oooo0P3o09T<0?ooo`030?l0V@3oool0oooo0300oooo00<0o`2I
0?ooo`3oool02P3oool00`3o09T0oooo0?ooo`0_0?ooo`030?l0V@3oool0oooo00/0oooo00<0o`2I
0?ooo`3oool0U@3oool3000005`0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`1W
0?ooo`008@3oool00`000000oooo0?ooo`030?ooo`030?l0V@3oool0oooo0300oooo0P3o09T:0?oo
o`80o`2I<P3oool20?l0V@/0oooo00<0o`2I0?ooo`3oool0<03oool20?l0V@X0oooo00<0o`2I0?oo
o`3oool0<@3oool00`3o09T0oooo0?ooo`090?ooo`030?l0V@3oool0oooo09@0oooo0P00001O0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool0IP3oool00240oooo00<000000?ooo`3o
ool00P3oool00`3o09T0oooo0?ooo`0c0?ooo`030?l0V@3oool0oooo00H0oooo0P3o09Td0?ooo`03
0?l0V@3oool0oooo00L0oooo0P3o09Td0?ooo`030?l0V@3oool0oooo00L0oooo00<0o`2I0?ooo`3o
ool0<`3oool00`3o09T0oooo0?ooo`070?ooo`030?l0V@3oool0oooo09<0oooo0P00001Q0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0IP3oool00240oooo0P0000000`3oool0o`2I
0?l0V@0g0?ooo`030?l0V@3oool0oooo00@0oooo00<0o`2I0?ooo`3oool0=@3oool00`3o09T0oooo
0?ooo`050?ooo`80o`2I=P3oool20?l0V@H0oooo00<0o`2I0?ooo`3oool0=@3oool00`3o09T0oooo
0?ooo`040?ooo`80o`2IU03oool2000006@0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`1U0?ooo`008@3oool30?l0VCX0oooo1P3o09Ti0?ooo`L0o`2I>@3oool70?l0VCT0oooo1P3o
09VF0?ooo`800000I03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo06D0oooo000Q
0?ooo`030000003oool0oooo0?l0ooooUP3oool00`000000oooo0000001S0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0I03oool00240oooo00<000000?ooo`3oool0o`3ooonF0?oo
o`040000003oool0oooo00000680oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1S
0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooiD0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`1O0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0H`3oool00240
oooo00<000000?ooo`3oool0o`3ooonE0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0GP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0680oooo000Q0?ooo`800000
o`3ooonF0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0G@3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo0680oooo000Q0?ooo`030000003oool0oooo0?l0ooooU@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`1Q0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooiD0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool0H03oool00240oooo00<000000?ooo`3oool0o`3ooonE0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
0600oooo000H0?ooo`@000001@3oool00`000000oooo0?ooo`3o0?oooiD0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0G`3oool001X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooi@0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool0GP3oool001X0oooo00<000000?ooo`3oool0103oool200000?l0ooooU@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`1N0?ooo`004P3oool4000000@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`3o0?oooi@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0G@3oool001X0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`3o0?oooi@0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0G@3oool001P0
oooo0`0000060?ooo`030000003oool0oooo0?l0ooooU03oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo05@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1L0?ooo`00
6P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooU03oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`1K0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooi<0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0F`3o
ool00240oooo00<000000?ooo`3oool0o`3ooonC0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0DP3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo05X0oooo000Q0?oo
o`800000o`3ooonD0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0D@3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo05X0oooo000Q0?ooo`030000003oool0oooo0?l0
ooooT`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`1I0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooi<0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool0F03oool00240oooo00<000000?ooo`3oool0o`3ooonC0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo05P0oooo000Q0?ooo`030000003oool0oooo0?l0ooooT`3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1G
0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooi80oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`1<0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0EP3oool00240
oooo0P00003o0?oooi<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1;0?ooo`03
0000003oool0oooo0280oooo00<000000?ooo`3oool0EP3oool00240oooo00<000000?ooo`3oool0
o`3ooonB0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0BP3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo05D0oooo000Q0?ooo`030000003oool0oooo0?l0ooooTP3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`1E0?ooo`008@3oool00`000000oooo0?ooo`3o0?oooi80oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo02<0oooo0P00001F
0?ooo`008@3oool00`000000oooo0?ooo`1j0?ooo`03001Vo`3oool0oooo0?l0oooo5@3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0803oool30000
00030?ooo`000000oooo05D0oooo000P0?ooo`D006Ko>03oool7001VocT0oooo2000I_lg0?ooo`T0
06Ko=`3oool8001Voi40oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`160?ooo`03
0000003oool0oooo01d0oooo0`0000040?ooo`030000003oool0oooo05@0oooo000P0?ooo`L006Ko
=03oool=001Voc<0oooo3000I_ld0?ooo`/006Ko=03oool<001Vohh0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo01X0oooo0`0000070?ooo`030000
003oool0oooo05@0oooo000Q0?ooo`030000003oool0oooo00@006Ko<@3oool5001Vo`D0oooo1P00
I_la0?ooo`@006Ko1P3oool4001Voc80oooo1000I_l60?ooo`@006Ko<03oool5001Vo`H0oooo1@00
I_n<0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`0G0?ooo`<000002`3oool00`000000oooo0?ooo`1C0?ooo`008@3oool00`000000oooo0?ooo`02
0?ooo`<006Ko;`3oool4001Vo`@0oooo0`0000040?ooo`8006Ko;`3oool4001Vo`<0oooo10000003
0?ooo`<006Ko<03oool3001Vo`@0oooo100000000`3oool006Ko001Vo`02001Vobh0oooo1000I_l7
0?ooo`<000001000I_l2000008T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo01<0oooo0`00000>0?ooo`030000003oool0oooo05<0oooo000Q0?oo
o`030000003oool0oooo00<0oooo0`00I_l]0?ooo`<006Ko2@3oool010000000oooo0?ooo`3oool3
001Vobd0oooo1000I_l60?ooo`060000003oool0oooo0?ooo`000000oooo0`00I_l]0?ooo`@006Ko
1`3oool00`000000oooo0?ooo`020?ooo`<006Ko;@3oool2001Vo`T0oooo00<000000?ooo`3oool0
0P3oool01@00I_l000000?ooo`3oool0000008P0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`130?ooo`030000003oool0oooo0100oooo0`00000A0?ooo`030000003oool0oooo05<0
oooo000Q0?ooo`030000003oool0oooo00@0oooo0`00I_l/0?ooo`8006Ko2P3oool00`000000oooo
0?ooo`020?ooo`<006Ko:`3oool3001Vo`P0oooo00D000000?ooo`3oool0oooo000000020?ooo`<0
06Ko:`3oool3001Vo`T0oooo00<000000?ooo`3oool00`3oool3001Vob/0oooo0`00I_l:0?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool00000R03oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool0303oool4000001@0oooo00<000000?oo
o`3oool0D`3oool00240oooo00<000000?ooo`3oool01@3oool3001VobX0oooo0P00I_l80?ooo`<0
00001P3oool3001VobT0oooo0`00I_l90?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
000006Ko001Vo`0Z0?ooo`<006Ko2P3oool010000000oooo0?ooo`3oool3000000<006Ko:@3oool3
001Vo``0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo08H0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00T0oooo0`00
000H0?ooo`030000003oool0oooo05<0oooo000Q0?ooo`8000001`3oool3001VobP0oooo0`00I_l8
0?ooo`030000003oool0oooo00L0oooo0`00I_lW0?ooo`<006Ko2P3oool01@000000oooo0?ooo`3o
ool000000080oooo00@000000?ooo`00I_l006Ko:03oool3001Vo`/0oooo00D000000?ooo`3oool0
oooo000000030?ooo`8006Ko:03oool3001Vo`h0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`250?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0@03oool00`00
0000oooo0?ooo`060?ooo`<000006`3oool00`000000oooo0?ooo`1C0?ooo`008@3oool00`000000
oooo0?ooo`070?ooo`<006Ko9P3oool3001Vo`T0oooo00<000000?ooo`3oool0203oool3001VobD0
oooo0`00I_l90?ooo`<000000`3oool010000000oooo0?ooo`0000020?ooo`8006Ko9P3oool3001V
o`X0oooo0`0000030?ooo`030000003oool0oooo0080oooo0P00I_lV0?ooo`<006Ko303oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000008L0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00<0oooo0`00000N0?ooo`030000003o
ool0oooo05<0oooo000Q0?ooo`030000003oool0oooo00P0oooo0`00I_lT0?ooo`<006Ko2P3oool4
000000P0oooo0`00I_lS0?ooo`<006Ko303oool00`000000oooo0?ooo`020?ooo`8000000`3oool3
001VobD0oooo0P00I_l=0?ooo`040000003oool0oooo0?ooo`@000000P3oool2001Vob@0oooo0`00
I_l>0?ooo`800000103oool2000008P0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`0n0?ooo`030000003oool0oooo00<000008P3oool00`000000oooo0?ooo`1B0?ooo`008@3oool0
0`000000oooo0?ooo`090?ooo`<006Ko8P3oool3001VoaP0oooo0P00I_lS0?ooo`8006Ko603oool3
001Vob<0oooo0P00I_lH0?ooo`<006Ko8`3oool2001Voil0oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`0m0?ooo`<000009@3oool00`000000oooo0?ooo`1B0?ooo`008@3oool00`00
0000oooo0?ooo`0:0?ooo`<006Ko803oool3001VoaX0oooo0P00I_lQ0?ooo`8006Ko6P3oool3001V
ob40oooo0`00I_lI0?ooo`<006Ko8@3oool2001Voj00oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`0i0?ooo`@000009`3oool00`000000oooo0?ooo`1B0?ooo`008@3oool00`000000
oooo0?ooo`0;0?ooo`<006Ko7P3oool3001Voa/0oooo0`00I_lO0?ooo`<006Ko6`3oool2001Vob00
oooo0`00I_lK0?ooo`<006Ko7`3oool2001VobL0oooo0P00001h0?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool0=@3oool3000000<0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`1B0?ooo`006P3ooolF000000<006Ko7@000002001Voad000000`00I_lN0000008006Ko
7@000002001Voal000000P00I_lM000000<006Ko7@000003001Voa`000002P3oool010000000oooo
0?ooo`00001g0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0<@3oool3000000H0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?ooo`008@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo008006Ko203oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00@0oooo0P00I_l40?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2P3oool00`00000006Ko001Vo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
0P3oool3001Vo`D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`8006Ko
303oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo0?ooo`8006Ko1`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo0P00I_l00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00@00000001Vo`00I_l006Ko2@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo02d0oooo0`0000090?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0DP3oool00240oooo00<000000?ooo`3oool03P3oool2001VoaX0oooo0`00I_lA0?ooo`03
0000003oool0oooo00`0oooo0P00I_lL0?ooo`8006Ko4`3oool00`000000oooo0?ooo`090?ooo`<0
06Ko6`3oool3001Voa@0oooo00<000000?ooo`3oool02@3oool2001VoaX0oooo0`00I_lG0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo02T0oooo0`00000<0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool0DP3oool00240oooo00<000000?ooo`3oool03P3oool3001VoaP0oooo0`00I_lQ0?ooo`<006Ko
6P3oool2001Vob40oooo0`00I_lI0?ooo`<006Ko8@3oool3001VoaP0oooo0`00I_lX0?ooo`@00000
M`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo02D0oooo0`00000?0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0D@3oool00240oooo00<000000?ooo`3oool03`3o
ool3001VoaH0oooo0`00I_lS0?ooo`<006Ko603oool3001Vob80oooo0`00I_lG0?ooo`<006Ko8`3o
ool3001VoaL0oooo0P00I_lZ0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`0Q0?ooo`<000004P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo0540oooo000Q0?ooo`030000003oool0oooo0100oooo0P00I_lE0?ooo`<006Ko9@3oool3
001VoaH0oooo0`00I_lT0?ooo`<006Ko5@3oool3001VobD0oooo0`00I_lE0?ooo`8006Ko:`3oool0
0`000000oooo0?ooo`1L0?ooo`80000000<0oooo0000000000000`3oool200000140oooo00<00000
0?ooo`3oool0=03oool00`000000oooo0?ooo`0M0?ooo`<000005@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo0540oooo000Q0?ooo`8000004P3oool2001Voa<0oooo0`00I_lW0?oo
o`<006Ko503oool3001VobH0oooo0`00I_lC0?ooo`<006Ko9`3oool3001Voa<0oooo0`00I_n;0?oo
o`030000003oool0000000<0oooo00@000000?ooo`3oool00000403oool00`000000oooo0?ooo`0e
0?ooo`030000003oool0oooo01P0oooo1000000I0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool0D@3oool00240oooo00<000000?ooo`3oool04@3oool3001Voa40oooo0`00I_lY0?oo
o`<006Ko4P3oool3001VobP0oooo0`00I_lA0?ooo`<006Ko:@3oool3001Voa40oooo0`00I_n=0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo01@0oooo0`00000M0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0D@3oool00240oooo00<000000?ooo`3oool04P3oool3001Vo`l0oooo0`00I_l[0?ooo`<0
06Ko403oool3001VobX0oooo0`00I_l?0?ooo`<006Ko:`3oool3001Vo`l0oooo0`00I_n=0?ooo`03
0000003oool0000000@0oooo0P00000@0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool0403oool300000200oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1A0?ooo`00
8@3oool00`000000oooo0?ooo`0C0?ooo`@006Ko303oool3001Vobd0oooo0`00I_l>0?ooo`<006Ko
;03oool3001Vo`d0oooo0`00I_l]0?ooo`<006Ko3@3oool3001Vohd0oooo0P0000000`3oool00000
000000050?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0>@3oool00`000000oooo
0?ooo`0<0?ooo`<000008`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0540oooo
000Q0?ooo`030000003oool0oooo01D0oooo0`00I_l:0?ooo`<006Ko;`3oool3001Vo`/0oooo1000
I_l^0?ooo`@006Ko2P3oool3001Vobl0oooo0P00I_l;0?ooo`@006KoU@3oool010000000oooo0?oo
o`00000?0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0203oool3000002H0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`1@0?ooo`008@3oool00`000000oooo0?oo
o`0F0?ooo`@006Ko1`3oool3001Voc40oooo0`00I_l80?ooo`@006Ko<P3oool3001Vo`P0oooo0`00
I_l`0?ooo`@006Ko203oool4001VoiL0oooo0P00000@0?ooo`030000003oool0oooo03/0oooo00<0
00000?ooo`3oool0103oool3000002T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`1@0?ooo`008@3oool2000001P0oooo0`00I_l50?ooo`@006Ko<`3oool4001Vo`D0oooo1000I_ld
0?ooo`<006Ko1@3oool4001Voc80oooo1@00I_l50?ooo`<006KoZ`3oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo00<00000;03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo0500oooo000Q0?ooo`030000003oool0oooo01P0oooo2P00I_le0?ooo`X006Ko=`3oool:001V
ocD0oooo2P00I_n/0?ooo`030000003oool0oooo03d0oooo3000000U0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0D03oool00240oooo00<000000?ooo`3oool06@3oool7001VocT0
oooo1`00I_li0?ooo`L006Ko>@3oool7001Vojd0oooo00<000000?ooo`3oool0?@3oool00`000000
oooo0?ooo`040?ooob/00000:03oool00`000000oooo0?ooo`1@0?ooo`008@3oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0Z0?ooo`<00000
0P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0500oooo000Q0?ooo`030000003o
ool0oooo0?l0ooooS@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo02H0oooo1000
00060?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0D03oool00240oooo00<00000
0?ooo`3oool0o`3ooon=0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool08`3oool3
000000X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1?0?ooo`008@3oool00`00
0000oooo0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0P0?oo
o`<000003P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo04l0oooo000Q0?ooo`80
0000o`3ooon>0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool07@3oool300000180
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1?0?ooo`008@3oool00`000000oooo
0?ooo`3o0?ooohd0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0J0?ooo`<00000
5P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo04l0oooo000Q0?ooo`030000003o
ool0oooo0?l0ooooS03oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo01H0oooo1000
000J0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0C`3oool00240oooo00<00000
0?ooo`3oool0o`3ooon<0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool04`3oool3
000001l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1?0?ooo`008@3oool00`00
0000oooo0?ooo`3o0?oooh`0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0@0?oo
o`<000008P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo04l0oooo000Q0?ooo`03
0000003oool0oooo0?l0ooooS03oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00d0
oooo0`00000V0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0CP3oool00240oooo
0P00003o0?ooohd0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0:0?ooo`<00000
:P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo04h0oooo000Q0?ooo`030000003o
ool0oooo0?l0ooooS03oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo1000
000^0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0CP3oool00240oooo00<00000
0?ooo`3oool0o`3ooon<0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool00`3oool3
000003<0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1>0?ooo`008@3oool00`00
0000oooo0?ooo`3o0?oooh/0oooo00<000000?ooo`3oool0?`3oool010000000oooo0?ooo`3oool3
000003H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1>0?ooo`00603oool40000
00D0oooo00<000000?ooo`3oool0o`3ooon;0?ooo`030000003oool0oooo03l0oooo1000000j0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool0CP3oool001X0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`3o0?oooh/0oooo00<000000?ooo`3oool0?03oool4000003h0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1>0?ooo`006P3oool00`000000oooo
0?ooo`040?ooo`800000o`3ooon<0?ooo`030000003oool0oooo03T0oooo0`0000030?ooo`030000
003oool0oooo03d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1=0?ooo`006P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooR`3oool00`000000oooo0?oo
o`0f0?ooo`<000001P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool0C@3oool001X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o
0?oooh/0oooo00<000000?ooo`3oool0<`3oool3000000T0oooo00<000000?ooo`3oool0?`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo04d0oooo000H0?ooo`<000001P3oool00`00
0000oooo0?ooo`3o0?oooh/0oooo00<000000?ooo`3oool0<03oool3000000`0oooo00<000000?oo
o`3oool0?`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo04d0oooo000J0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooon:0?ooo`030000003oool0oooo02d0
oooo1000000?0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`1=0?ooo`008@3oool00`000000oooo0?ooo`3o0?ooohX0oooo00<000000?ooo`3oool0
:P3oool3000001<0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo04d0oooo000Q0?ooo`800000o`3ooon;0?ooo`030000003oool0oooo02L0oooo0`00
000F0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`1<0?ooo`008@3oool00`000000oooo0?ooo`3o0?ooohX0oooo00<000000?ooo`3oool0903oool3
000001T0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo04`0oooo000Q0?ooo`030000003oool0oooo0?l0ooooRP3oool00`000000oooo0?ooo`0P0?oo
o`@00000703oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0C03oool00240oooo00<000000?ooo`3oool0o`3ooon:0?ooo`030000003oool0oooo01d0
oooo0`00000P0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`1<0?ooo`008@3oool00`000000oooo0?ooo`3o0?ooohT0oooo00<000000?ooo`3oool0
6`3oool3000002<0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo04`0oooo000Q0?ooo`030000003oool0oooo01T0oooo1`0co`0i0?ooo`L0<ol0>@3o
ool703?o03T0oooo1`0co`2X0?ooo`030000003oool0oooo01P0oooo0`00000V0?ooo`030000003o
ool0oooo04H0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`1<0?ooo`008@3oool2
000001T0oooo2`0co`0d0?ooo`/0<ol0=@3oool;03?o03D0oooo2`0co`2V0?ooo`030000003oool0
oooo01D0oooo0`00000Y0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`1<0?ooo`008@3oool00`000000oooo0?ooo`0G0?ooo`<0<ol01@3oool403?o
03<0oooo100co`050?ooo`@0<ol0=03oool303?o00D0oooo100co`0c0?ooo`@0<ol01@3oool303?o
0:H0oooo00<000000?ooo`3oool04@3oool4000002`0oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo04/0oooo000Q0?ooo`030000003oool0oooo01H0
oooo0`0co`080?ooo`<0<ol0<P3oool203?o00T0oooo0`0co`0b0?ooo`<0<ol0203oool303?o0340
oooo0`0co`080?ooo`@0<ol0Y03oool00`000000oooo0?ooo`0>0?ooo`<00000<03oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0B`3oool00240oooo
00<000000?ooo`3oool05@3oool303?o00X0oooo0`0co`0`0?ooo`<0<ol02P3oool303?o0300oooo
0`0co`0:0?ooo`80<ol0<03oool303?o00X0oooo100co`2S0?ooo`030000003oool0oooo00/0oooo
0`00000c0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`1;0?ooo`008@3oool00`000000oooo0?ooo`0D0?ooo`<0<ol0303oool203?o02l0oooo0`0c
o`0<0?ooo`<0<ol0;P3oool303?o00`0oooo0P0co`0_0?ooo`80<ol03@3oool203?o0:<0oooo00<0
00000?ooo`3oool0203oool3000003H0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo04/0oooo000Q0?ooo`030000003oool0oooo01@0oooo0P0co`0>
0?ooo`80<ol0;@3oool303?o00h0oooo0`0co`0/0?ooo`<0<ol03@3oool303?o02d0oooo0`0co`0=
0?ooo`<0<ol0X@3oool00`000000oooo0?ooo`060?ooo`<00000>@3oool00`000000oooo0?ooo`1;
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0B`3oool00240oooo0P00000D0?oo
o`80<ol03`3oool303?o02/0oooo0`0co`0@0?ooo`80<ol0:`3oool303?o00l0oooo0`0co`0/0?oo
o`80<ol03`3oool203?o0:40oooo00<000000?ooo`3oool00P3oool4000003`0oooo00<000000?oo
o`3oool0C03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo04/0oooo000Q0?ooo`03
0000003oool0oooo0180oooo0`0co`0@0?ooo`80<ol0:`3oool203?o0180oooo0P0co`0Z0?ooo`80
<ol04@3oool203?o02/0oooo0`0co`0?0?ooo`<0<ol0X03oool00`000000oooo0000000200000400
oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo04/0
oooo000Q0?ooo`030000003oool0oooo0180oooo0P0co`0B0?ooo`80<ol0:@3oool203?o01<0oooo
0`0co`0X0?ooo`80<ol04`3oool203?o02T0oooo0`0co`0A0?ooo`80<ol0X03oool2000004<0oooo
00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo04X0oooo
000Q0?ooo`030000003oool0oooo0140oooo0P0co`0C0?ooo`<0<ol09`3oool303?o01@0oooo0P0c
o`0W0?ooo`<0<ol04`3oool203?o02T0oooo0P0co`0C0?ooo`80<ol0X03oool200000480oooo00<0
00000?ooo`3oool0CP3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo04X0oooo000Q
0?ooo`030000003oool0oooo0140oooo0P0co`0D0?ooo`80<ol09`3oool203?o01D0oooo0`0co`0V
0?ooo`80<ol05@3oool203?o02L0oooo0P0co`0D0?ooo`80<ol0XP3oool00`000000oooo0?ooo`0o
0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1:
0?ooo`008@3oool00`000000oooo0?ooo`0@0?ooo`80<ol05P3oool203?o02D0oooo0`0co`0F0?oo
o`80<ol09@3oool203?o01H0oooo0`0co`0U0?ooo`<0<ol05@3oool203?o0:80oooo00<000000?oo
o`3oool0?P3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0BP3oool00240oooo0P00000@0?ooo`<0<ol05P3oool303?o02@0oooo0P0co`0H0?ooo`80
<ol0903oool203?o01L0oooo0P0co`0U0?ooo`80<ol05P3oool303?o0:80oooo0P00000n0?ooo`03
0000003oool0oooo0540oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1:0?ooo`00
8@3oool00`000000oooo0?ooo`0?0?ooo`80<ol0603oool203?o02<0oooo0`0co`0H0?ooo`<0<ol0
8P3oool203?o01T0oooo0P0co`0S0?ooo`<0<ol05`3oool203?o0:@0oooo00<000000?ooo`3oool0
>`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
BP3oool00240oooo00<000000?ooo`3oool03P3oool303?o01P0oooo0`0co`0R0?ooo`80<ol06P3o
ool203?o0240oooo0`0co`0I0?ooo`80<ol08`3oool203?o01T0oooo0P0co`2T0?ooo`800000>P3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0BP3o
ool00240oooo00<000000?ooo`3oool03P3oool203?o01X0oooo0P0co`0Q0?ooo`<0<ol06P3oool3
03?o0200oooo0P0co`0K0?ooo`80<ol08@3oool203?o01X0oooo0P0co`2V0?ooo`030000003oool0
oooo03L0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo04T0oooo000Q0?ooo`030000003oool0oooo00d0oooo0`0co`0K0?ooo`80<ol0803oool203?o
01`0oooo0P0co`0O0?ooo`<0<ol06`3oool303?o0200oooo0P0co`0K0?ooo`80<ol0YP3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`190?ooo`00603oool4000000D0oooo00<000000?ooo`3oool03@3oool203?o01`0
oooo0P0co`0O0?ooo`<0<ol0703oool203?o01l0oooo0P0co`0M0?ooo`80<ol07`3oool203?o01`0
oooo0`0co`2V0?ooo`800000=P3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0B@3oool001P0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0<0?ooo`<0<ol07@3oool203?o01h0oooo0P0co`0N0?ooo`80<ol07@3oool303?o01d0oooo
0`0co`0N0?ooo`80<ol07@3oool203?o0:P0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0B@3oool001T0oooo00<0
00000?ooo`3oool01@3oool2000000d0oooo0P0co`0N0?ooo`80<ol07@3oool303?o01h0oooo0P0c
o`0M0?ooo`80<ol07`3oool203?o01d0oooo0P0co`0N0?ooo`<0<ol0Z03oool2000003<0oooo00<0
00000?ooo`3oool0E`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04T0oooo000J
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool203?o0200oooo0P0co`0L
0?ooo`80<ol0803oool203?o01/0oooo0`0co`0O0?ooo`<0<ol06`3oool303?o01l0oooo0P0co`2Z
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo04T0oooo000K0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool02`3oool203?o0200oooo0`0co`0J0?ooo`<0<ol0803oool203?o01/0oooo0P0co`0Q0?oo
o`80<ol06`3oool203?o0200oooo0`0co`2Z0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool0F@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04T0oooo000H0?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`3oool02P3oool203?o0280oooo0P0co`0J0?oo
o`80<ol08@3oool303?o01T0oooo0`0co`0Q0?ooo`<0<ol06@3oool303?o0240oooo0P0co`2[0?oo
o`800000;`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0B03oool001T0oooo0P0000060?ooo`030000003oool0oooo00T0oooo0`0co`0R0?ooo`<0
<ol0603oool303?o0280oooo0P0co`0I0?ooo`80<ol08`3oool203?o01T0oooo0P0co`0R0?ooo`<0
<ol0[03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`180?ooo`008@3oool00`000000oooo0?ooo`090?ooo`80<ol0
903oool203?o01P0oooo0P0co`0S0?ooo`<0<ol05`3oool303?o02<0oooo0`0co`0G0?ooo`80<ol0
903oool203?o0:d0oooo0P00000/0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`180?ooo`008@3oool2000000T0oooo0P0co`0V0?ooo`80<ol05P3o
ool303?o02@0oooo0P0co`0G0?ooo`80<ol09@3oool203?o01H0oooo0`0co`0T0?ooo`<0<ol0[P3o
ool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`180?ooo`008@3oool00`000000oooo0?ooo`080?ooo`80<ol09P3oool2
03?o01H0oooo0P0co`0V0?ooo`80<ol05@3oool203?o02H0oooo0`0co`0E0?ooo`80<ol09P3oool2
03?o0:l0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`1M0?ooo`050000003oool0
oooo0?ooo`000000BP3oool00240oooo00<000000?ooo`3oool01`3oool203?o02P0oooo0P0co`0D
0?ooo`80<ol09`3oool203?o01@0oooo0`0co`0W0?ooo`80<ol0503oool303?o02H0oooo0`0co`2_
0?ooo`800000:03oool00`000000oooo0?ooo`1N0?ooo`040000003oool0oooo000004X0oooo000Q
0?ooo`030000003oool0oooo00H0oooo0`0co`0X0?ooo`<0<ol04P3oool303?o02P0oooo0P0co`0C
0?ooo`80<ol0:@3oool203?o01<0oooo0P0co`0X0?ooo`80<ol0/@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`000000BP3oool00240oooo00<000000?oo
o`3oool01P3oool203?o02X0oooo0P0co`0B0?ooo`80<ol0:@3oool303?o0140oooo0`0co`0Y0?oo
o`80<ol04P3oool203?o02X0oooo0P0co`2a0?ooo`8000009@3oool00`000000oooo0?ooo`1P0?oo
o`030000003oool0000004T0oooo000Q0?ooo`030000003oool0oooo00D0oooo0P0co`0[0?ooo`<0
<ol0403oool303?o02X0oooo0P0co`0A0?ooo`80<ol0:`3oool203?o0100oooo0`0co`0Z0?ooo`<0
<ol0/P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0600oooo00<000000?ooo`00
0000B@3oool00240oooo0P0000060?ooo`80<ol0;03oool203?o0100oooo0P0co`0[0?ooo`<0<ol0
3`3oool203?o02`0oooo0`0co`0?0?ooo`80<ol0;03oool303?o0;80oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`1Q0?ooo`800000B@3oool00240oooo00<000000?ooo`3oool0103o
ool203?o02d0oooo0`0co`0>0?ooo`80<ol0;@3oool203?o00h0oooo0`0co`0]0?ooo`<0<ol03@3o
ool303?o02d0oooo0P0co`2c0?ooo`8000008@3oool00`000000oooo0?ooo`1P0?ooo`<00000B@3o
ool00240oooo00<000000?ooo`3oool00`3oool303?o02h0oooo0P0co`0=0?ooo`<0<ol0;@3oool4
03?o00`0oooo0P0co`0_0?ooo`<0<ol0303oool203?o02h0oooo0`0co`0=0?ooo`0303?o003oool0
oooo0:@0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1L0?ooo`@00000C03oool0
0240oooo00<000000?ooo`3oool00`3oool203?o02l0oooo100co`0;0?ooo`80<ol0;`3oool403?o
00X0oooo0`0co`0`0?ooo`<0<ol02P3oool303?o02l0oooo0`0co`0;0?ooo`<0<ol0YP3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo05P0oooo1000001@0?ooo`008@3oool00`000000
oooo0?ooo`020?ooo`80<ol0<@3oool403?o00P0oooo100co`0a0?ooo`80<ol02P3oool203?o0380
oooo0P0co`090?ooo`<0<ol0<@3oool303?o00T0oooo0`0co`2X0?ooo`8000007@3oool00`000000
oooo0?ooo`1D0?ooo`@00000E03oool00240oooo00@000000?ooo`3oool0oooo0`0co`0c0?ooo`<0
<ol01P3oool403?o0380oooo0`0co`070?ooo`@0<ol0<P3oool303?o00L0oooo0`0co`0c0?ooo`<0
<ol01`3oool303?o0:/0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1?0?ooo`D0
0000F03oool00240oooo0P00000403?o03D0oooo0`0co`030?ooo`@0<ol0=@3oool403?o00<0oooo
1@0co`0d0?ooo`@0<ol0103oool303?o03D0oooo100co`030?ooo`@0<ol0[@3oool2000001X0oooo
00<000000?ooo`3oool0B`3oool4000005d0oooo000P0?ooo`H0<ol0=`3oool803?o03L0oooo2@0c
o`0g0?ooo`T0<ol0=`3oool903?o0;00oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`170?ooo`@00000H@3oool00200oooo100co`0j0?ooo`H0<ol0>@3oool603?o03/0oooo1P0co`0j
0?ooo`D0<ol0/`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo04<0oooo1000001U
0?ooo`008@3oool00`000000oooo0?ooo`3o0?oook@0oooo0P00000F0?ooo`030000003oool0oooo
03h0oooo1@00001Y0?ooo`008@3oool00`000000oooo0?ooo`3o0?oookH0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0j0?ooo`@00000KP3oool00240oooo00<000000?ooo`3oool0
o`3ooong0?ooo`8000004P3oool00`000000oooo0?ooo`0g0?ooo`@00000LP3oool00?l0oooog@3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03<0oooo1000001f0?ooo`00o`3ooooN
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0;P3oool5000007X0oooo003o0?oo
oml0oooo0P00000>0?ooo`030000003oool0oooo02X0oooo1000001o0?ooo`00o`3ooooQ0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool09P3oool4000008<0oooo003o0?ooon80oooo
0P00000;0?ooo`030000003oool0oooo0280oooo100000270?ooo`00o`3ooooT0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool07@3oool5000008/0oooo003o0?ooonD0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`@00000T03oool00?l0ooooiP3oool20000
00L0oooo00<000000?ooo`3oool05@3oool4000009@0oooo003o0?ooonP0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0A0?ooo`@00000V03oool00?l0ooooj@3oool2000000@0oooo
00<000000?ooo`3oool0303oool5000009`0oooo000N0?ooo`80000000<0oooo000000000000o`3o
oonV0?ooo`80000000<0oooo0000000000000P3oool4000001L0oooo00D000000?ooo`3oool0oooo
0000000:0?ooo`@00000X@3oool001l0oooo00<000000?ooo`000000o`3ooonX0?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`0000060?ooo`@00000
Y@3oool00200oooo00<000000?ooo`3oool0o`3ooonX0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool06@3oool300000080oooo1000002Y0?ooo`007`3oool00`000000oooo0000003o
0?ooojP0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0J0?ooo`<00000[@3oool0
01h0oooo0P0000000`3oool000000000003o0?ooojH0oooo0P0000000`3oool00000000000050?oo
o`030000003oool0oooo0<T0oooo003o0?ooom00oooo00@000000?ooo`3oool00000b`3oool00?l0
ooood@3oool200000<`0oooo003o0?ooool0ooooX03oool00?l0ooooo`3ooonP0?ooo`00o`3ooooo
0?oooj00oooo003o0?ooool0ooooX03oool00001\
\>"],
  ImageRangeCache->{{{0, 669}, {196.125, 0}} -> {-0.0540885, -0.0147182, \
0.00315124, 0.00315124}, {{17.125, 319.375}, {191.438, 4.625}} -> {-2.53125, \
-2.92434, 0.0762925, 0.0325842}, {{349.562, 651.812}, {191.438, 4.625}} -> \
{-2.11744, -0.0237827, 0.00507267, 0.00507267}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[\ \ xPlot[0, 1, 1]\ , 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input",
  Hyphenation->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.307528 0.0883827 [
[.2619 .29503 -3 -9 ]
[.2619 .29503 3 0 ]
[.5 .29503 -6 -9 ]
[.5 .29503 6 0 ]
[.7381 .29503 -6 -9 ]
[.7381 .29503 6 0 ]
[.97619 .29503 -6 -9 ]
[.97619 .29503 6 0 ]
[1.025 .30753 0 -4.90625 ]
[1.025 .30753 10 4.90625 ]
[.01131 .04238 -12 -4.5 ]
[.01131 .04238 0 4.5 ]
[.01131 .13076 -12 -4.5 ]
[.01131 .13076 0 4.5 ]
[.01131 .21914 -12 -4.5 ]
[.01131 .21914 0 4.5 ]
[.01131 .39591 -6 -4.5 ]
[.01131 .39591 0 4.5 ]
[.01131 .48429 -6 -4.5 ]
[.01131 .48429 0 4.5 ]
[.01131 .57268 -6 -4.5 ]
[.01131 .57268 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30753 m
.2619 .31378 L
s
[(5)] .2619 .29503 0 1 Mshowa
.5 .30753 m
.5 .31378 L
s
[(10)] .5 .29503 0 1 Mshowa
.7381 .30753 m
.7381 .31378 L
s
[(15)] .7381 .29503 0 1 Mshowa
.97619 .30753 m
.97619 .31378 L
s
[(20)] .97619 .29503 0 1 Mshowa
.125 Mabswid
.07143 .30753 m
.07143 .31128 L
s
.11905 .30753 m
.11905 .31128 L
s
.16667 .30753 m
.16667 .31128 L
s
.21429 .30753 m
.21429 .31128 L
s
.30952 .30753 m
.30952 .31128 L
s
.35714 .30753 m
.35714 .31128 L
s
.40476 .30753 m
.40476 .31128 L
s
.45238 .30753 m
.45238 .31128 L
s
.54762 .30753 m
.54762 .31128 L
s
.59524 .30753 m
.59524 .31128 L
s
.64286 .30753 m
.64286 .31128 L
s
.69048 .30753 m
.69048 .31128 L
s
.78571 .30753 m
.78571 .31128 L
s
.83333 .30753 m
.83333 .31128 L
s
.88095 .30753 m
.88095 .31128 L
s
.92857 .30753 m
.92857 .31128 L
s
.25 Mabswid
0 .30753 m
1 .30753 L
s
gsave
1.025 .30753 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .04238 m
.03006 .04238 L
s
[(-3)] .01131 .04238 1 0 Mshowa
.02381 .13076 m
.03006 .13076 L
s
[(-2)] .01131 .13076 1 0 Mshowa
.02381 .21914 m
.03006 .21914 L
s
[(-1)] .01131 .21914 1 0 Mshowa
.02381 .39591 m
.03006 .39591 L
s
[(1)] .01131 .39591 1 0 Mshowa
.02381 .48429 m
.03006 .48429 L
s
[(2)] .01131 .48429 1 0 Mshowa
.02381 .57268 m
.03006 .57268 L
s
[(3)] .01131 .57268 1 0 Mshowa
.125 Mabswid
.02381 .06006 m
.02756 .06006 L
s
.02381 .07773 m
.02756 .07773 L
s
.02381 .09541 m
.02756 .09541 L
s
.02381 .11309 m
.02756 .11309 L
s
.02381 .14844 m
.02756 .14844 L
s
.02381 .16612 m
.02756 .16612 L
s
.02381 .18379 m
.02756 .18379 L
s
.02381 .20147 m
.02756 .20147 L
s
.02381 .23682 m
.02756 .23682 L
s
.02381 .2545 m
.02756 .2545 L
s
.02381 .27217 m
.02756 .27217 L
s
.02381 .28985 m
.02756 .28985 L
s
.02381 .3252 m
.02756 .3252 L
s
.02381 .34288 m
.02756 .34288 L
s
.02381 .36056 m
.02756 .36056 L
s
.02381 .37823 m
.02756 .37823 L
s
.02381 .41359 m
.02756 .41359 L
s
.02381 .43126 m
.02756 .43126 L
s
.02381 .44894 m
.02756 .44894 L
s
.02381 .46662 m
.02756 .46662 L
s
.02381 .50197 m
.02756 .50197 L
s
.02381 .51965 m
.02756 .51965 L
s
.02381 .53732 m
.02756 .53732 L
s
.02381 .555 m
.02756 .555 L
s
.02381 .0247 m
.02756 .0247 L
s
.02381 .00703 m
.02756 .00703 L
s
.02381 .59035 m
.02756 .59035 L
s
.02381 .60803 m
.02756 .60803 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 1 0 r
.01 w
.02381 .60332 m
.02499 .60327 L
.02605 .60314 L
.02729 .6029 L
.02846 .60257 L
.03053 .60176 L
.03279 .60055 L
.03527 .59881 L
.0379 .59653 L
.04262 .59132 L
.05205 .57687 L
.06244 .55558 L
.08274 .50321 L
.10458 .44368 L
.11537 .41807 L
.12562 .39825 L
.13007 .39132 L
.13482 .38518 L
.13755 .38226 L
.14003 .38 L
.14253 .37812 L
.14487 .37672 L
.14719 .37567 L
.14842 .37525 L
.14974 .37492 L
.1504 .37479 L
.15113 .37468 L
.15244 .37457 L
.15371 .37457 L
.15489 .37467 L
.15599 .37483 L
.15702 .37506 L
.15815 .37538 L
.15936 .37582 L
.16184 .37699 L
.16411 .3784 L
.16896 .38242 L
.17426 .38834 L
.18493 .40454 L
.20454 .44522 L
.22549 .49436 L
.23574 .51667 L
.24684 .53745 L
.25193 .54543 L
.25733 .55265 L
.26238 .55818 L
.26699 .56215 L
.26931 .56374 L
.27183 .56516 L
.27422 .56621 L
Mistroke
.27643 .56693 L
.27776 .56724 L
.27901 .56745 L
.28013 .56757 L
.28134 .56763 L
.28197 .56764 L
.28266 .56762 L
.28339 .56758 L
.28406 .56751 L
.28527 .56734 L
.28657 .56708 L
.28779 .56676 L
.28893 .5664 L
.29149 .56537 L
.29615 .56274 L
.30039 .55956 L
.30488 .55542 L
.32439 .53033 L
.34268 .50134 L
.3612 .47339 L
.37168 .46036 L
.37679 .45506 L
.38142 .4509 L
.38609 .44739 L
.39114 .44435 L
.39391 .44303 L
.39647 .44204 L
.39892 .44127 L
.40027 .44093 L
.4015 .44067 L
.4027 .44046 L
.40401 .44028 L
.40473 .4402 L
.40539 .44015 L
.4067 .44007 L
.40782 .44005 L
.40906 .44006 L
.41035 .44013 L
.41156 .44023 L
.41221 .44029 L
.41291 .44038 L
.41433 .4406 L
.41688 .44112 L
.41985 .44193 L
.42261 .44287 L
.43312 .44779 L
.44305 .45392 L
.46163 .46681 L
.47133 .47312 L
.48162 .47877 L
Mistroke
.4904 .48244 L
.49539 .484 L
.50006 .48509 L
.50264 .48555 L
.50503 .48587 L
.50638 .48602 L
.50766 .48613 L
.50836 .48618 L
.50912 .48623 L
.50981 .48627 L
.51045 .48629 L
.51164 .48633 L
.51295 .48634 L
.51423 .48634 L
.51494 .48632 L
.51559 .4863 L
.51676 .48626 L
.51802 .48619 L
.52032 .48601 L
.52254 .48579 L
.52499 .48548 L
.52995 .4847 L
.53885 .48291 L
.54829 .48082 L
.55821 .47892 L
.56073 .47854 L
.56341 .4782 L
.56496 .47804 L
.56636 .47792 L
.56779 .47782 L
.5691 .47775 L
.5703 .47771 L
.57156 .47768 L
.57284 .47768 L
.57356 .47768 L
.57423 .4777 L
.57545 .47774 L
.57657 .4778 L
.57786 .47789 L
.57908 .478 L
.58168 .47831 L
.58413 .47871 L
.5887 .47973 L
.59362 .48123 L
.59894 .48332 L
.60853 .48829 L
.61734 .49403 L
.63782 .51005 L
.64781 .51797 L
.6569 .52443 L
Mistroke
.66143 .5272 L
.66635 .52975 L
.67099 .53167 L
.67306 .53236 L
.67528 .53296 L
.6765 .53324 L
.67762 .53346 L
.67876 .53364 L
.67982 .53378 L
.68105 .53389 L
.68169 .53393 L
.68238 .53397 L
.68366 .53398 L
.68482 .53396 L
.68613 .53387 L
.68733 .53375 L
.68864 .53356 L
.69003 .5333 L
.69237 .53271 L
.69494 .53185 L
.70018 .5294 L
.70514 .52621 L
.71445 .518 L
.72446 .50616 L
.73536 .49035 L
.75473 .4579 L
.76503 .4405 L
.77613 .42343 L
.78669 .41019 L
.79131 .40562 L
.79637 .40162 L
.79869 .40017 L
.80117 .39889 L
.8035 .39795 L
.80563 .39733 L
.80688 .39708 L
.80804 .39691 L
.8093 .3968 L
.80994 .39678 L
.81064 .39677 L
.81182 .39683 L
.81309 .39697 L
.81429 .39718 L
.81538 .39744 L
.81789 .39827 L
.82016 .3993 L
.82278 .40084 L
.82525 .40261 L
.83439 .41192 L
.83959 .41903 L
Mistroke
.84436 .42664 L
.85513 .44713 L
.87558 .49443 L
.89466 .53987 L
.90409 .55958 L
.91301 .57513 L
.91794 .58211 L
.9233 .58822 L
.92566 .5904 L
.92817 .59234 L
.93032 .5937 L
.93267 .59485 L
.93391 .59532 L
.93506 .59567 L
.93627 .59594 L
.93757 .59613 L
.93878 .59621 L
.93992 .59619 L
.94095 .59611 L
.94206 .59594 L
.94328 .59566 L
.94462 .59524 L
.94732 .59403 L
.94983 .59249 L
.95217 .59069 L
.95678 .58612 L
.96099 .58082 L
.97046 .56519 L
.97619 .5535 L
Mfstroke
0 .4 1 r
.009 w
.02381 .26984 m
.02499 .26986 L
.02605 .26991 L
.02729 .27001 L
.02846 .27014 L
.03053 .27047 L
.03279 .27095 L
.03527 .27164 L
.0379 .27256 L
.04262 .27464 L
.05205 .28036 L
.06244 .28869 L
.08274 .30854 L
.09394 .31976 L
.10458 .32939 L
.11464 .33685 L
.12033 .34014 L
.12562 .34251 L
.12813 .34338 L
.1305 .34405 L
.13263 .34453 L
.13494 .3449 L
.13613 .34504 L
.13745 .34514 L
.13811 .34518 L
.13883 .3452 L
.14011 .34521 L
.14139 .34517 L
.1426 .3451 L
.14368 .34499 L
.14487 .34484 L
.1472 .34444 L
.14972 .34383 L
.15427 .34231 L
.15968 .33981 L
.16464 .33691 L
.18565 .31955 L
.20618 .29887 L
.21618 .28936 L
.22527 .28185 L
.22982 .27866 L
.23475 .27569 L
.23901 .27357 L
.2437 .27178 L
.24627 .27103 L
.24867 .2705 L
.25 .27027 L
.25121 .2701 L
.25188 .27003 L
.25261 .26996 L
Mistroke
.2533 .26991 L
.25394 .26988 L
.25518 .26984 L
.25634 .26985 L
.25738 .26989 L
.25851 .26996 L
.25975 .27008 L
.26105 .27026 L
.26338 .27068 L
.26594 .27132 L
.26836 .27208 L
.27289 .27392 L
.27776 .27646 L
.28306 .27983 L
.30141 .29538 L
.32083 .31496 L
.33114 .32486 L
.34224 .334 L
.3474 .33749 L
.35283 .34052 L
.35747 .34254 L
.36012 .34345 L
.36253 .34412 L
.36371 .34439 L
.36499 .34464 L
.36609 .34482 L
.3673 .34498 L
.36859 .3451 L
.3693 .34515 L
.36995 .34518 L
.37113 .34521 L
.3724 .3452 L
.37357 .34515 L
.37485 .34505 L
.37607 .34492 L
.37719 .34476 L
.37931 .34436 L
.38156 .34381 L
.38644 .34215 L
.39091 .34009 L
.40101 .33375 L
.41928 .31773 L
.43978 .29705 L
.44978 .28774 L
.45887 .28051 L
.46341 .27749 L
.46833 .27473 L
.47298 .27266 L
.47727 .27123 L
.47962 .27066 L
Mistroke
.48182 .27026 L
.48308 .27009 L
.48423 .26997 L
.48487 .26993 L
.48556 .26988 L
.48682 .26984 L
.48751 .26984 L
.48816 .26985 L
.48937 .2699 L
.49067 .27 L
.4914 .27007 L
.49207 .27015 L
.49444 .27054 L
.49695 .27112 L
.4995 .27187 L
.50191 .27275 L
.50643 .27478 L
.5166 .2811 L
.53494 .29711 L
.55317 .31554 L
.56355 .32545 L
.57329 .33348 L
.58281 .3396 L
.58817 .34213 L
.59071 .34307 L
.59308 .3438 L
.59544 .34438 L
.59665 .34462 L
.59797 .34483 L
.59872 .34494 L
.59941 .34501 L
.60006 .34508 L
.60077 .34513 L
.60201 .34519 L
.60331 .34521 L
.60403 .3452 L
.60472 .34518 L
.606 .34511 L
.60672 .34504 L
.60738 .34497 L
.60888 .34477 L
.6114 .34429 L
.61409 .34359 L
.61947 .34161 L
.62441 .33916 L
.63556 .33163 L
.65574 .31303 L
.67622 .29255 L
.68621 .28384 L
.6953 .27741 L
Mistroke
.69983 .27486 L
.70475 .27265 L
.707 .27185 L
.70939 .27114 L
.71143 .27065 L
.71368 .27025 L
.71499 .27007 L
.71623 .26995 L
.71735 .26988 L
.71857 .26984 L
.71989 .26985 L
.72063 .26987 L
.7213 .26991 L
.7226 .27001 L
.72383 .27015 L
.72499 .27032 L
.72621 .27054 L
.7284 .27104 L
.73335 .27262 L
.7383 .27484 L
.74282 .27738 L
.75298 .28466 L
.77131 .30171 L
.79199 .3224 L
.80109 .33041 L
.80593 .33413 L
.81114 .33762 L
.81614 .34041 L
.82072 .34244 L
.8251 .34387 L
.8273 .3444 L
.82972 .34483 L
.83105 .345 L
.8323 .34512 L
.83343 .34518 L
.83466 .34521 L
.83529 .34521 L
.83599 .3452 L
.83672 .34517 L
.83741 .34513 L
.83863 .34503 L
.83994 .34487 L
.84116 .34468 L
.84249 .34443 L
.84491 .34385 L
.84946 .34234 L
.85478 .3399 L
.85979 .33699 L
.86916 .33015 L
.89014 .31035 L
Mistroke
.90855 .29202 L
.91899 .28304 L
.92409 .27933 L
.92873 .27641 L
.93335 .274 L
.93837 .27197 L
.94113 .27114 L
.94368 .27055 L
.94494 .27032 L
.94612 .27015 L
.94734 .27001 L
.948 .26995 L
.9487 .2699 L
.94934 .26987 L
.95003 .26985 L
.95126 .26984 L
.95202 .26986 L
.95273 .26989 L
.95337 .26993 L
.95406 .26998 L
.95549 .27014 L
.957 .27036 L
.9597 .27092 L
.96218 .27161 L
.9645 .27239 L
.96978 .2747 L
.97619 .27839 L
Mfstroke
1 0 .6 r
.007 w
.02381 .1248 m
.06244 .11599 L
.07216 .11234 L
.08255 .10885 L
.08852 .1073 L
.09135 .10672 L
.09396 .1063 L
.09658 .10598 L
.09796 .10586 L
.09866 .10581 L
.09942 .10577 L
.10069 .10572 L
.10187 .10571 L
.1026 .10571 L
.10329 .10573 L
.10458 .10578 L
.10586 .10587 L
.10707 .10598 L
.10933 .10627 L
.11176 .10672 L
.11439 .10735 L
.11914 .1089 L
.1235 .11079 L
.13354 .11686 L
.14415 .12571 L
.18212 .16915 L
.19214 .18011 L
.20163 .18872 L
.20687 .19247 L
.20964 .19411 L
.21257 .19557 L
.21504 .19656 L
.21634 .197 L
.21775 .1974 L
.21904 .1977 L
.22023 .19792 L
.22136 .19807 L
.22255 .19818 L
.22378 .19824 L
.22448 .19824 L
.22512 .19823 L
.2263 .19816 L
.22755 .19802 L
.22867 .19785 L
.22971 .19763 L
.23209 .19697 L
.23466 .19599 L
.23701 .19485 L
.24229 .19142 L
.2468 .18755 L
Mistroke
.25171 .18239 L
.26066 .1706 L
.28037 .13592 L
.30135 .09291 L
.31167 .07285 L
.32281 .05417 L
.32792 .04706 L
.33332 .0408 L
.33793 .03655 L
.34056 .03462 L
.34299 .03316 L
.34551 .032 L
.34684 .03152 L
.34825 .03113 L
.34947 .03088 L
.35061 .03073 L
.35187 .03065 L
.35257 .03064 L
.35322 .03066 L
.35434 .03076 L
.35539 .03091 L
.35654 .03115 L
.35776 .0315 L
.36026 .03249 L
.36254 .0337 L
.36771 .0376 L
.37331 .04355 L
.38346 .05866 L
.39295 .07721 L
.40338 .10142 L
.42444 .15635 L
.43528 .18401 L
.44556 .20743 L
.45556 .22613 L
.45996 .23274 L
.46483 .23876 L
.46707 .24105 L
.46948 .24316 L
.47157 .24469 L
.47385 .24603 L
.47628 .24709 L
.47761 .24749 L
.47885 .24777 L
.48001 .24793 L
.48107 .24799 L
.48229 .24797 L
.48344 .24786 L
.48461 .24766 L
.48589 .24733 L
.48724 .24686 L
Mistroke
.4885 .24631 L
.49074 .24507 L
.49316 .24335 L
.49867 .23801 L
.5037 .23145 L
.51356 .21437 L
.5227 .19421 L
.54343 .13878 L
.56224 .0865 L
.57214 .06211 L
.58258 .04076 L
.5879 .03206 L
.59374 .02442 L
.59631 .02174 L
.59905 .01934 L
.60163 .01753 L
.60401 .01626 L
.60527 .01574 L
.60661 .0153 L
.60725 .01513 L
.60795 .01498 L
.60871 .01486 L
.60943 .01478 L
.61074 .01472 L
.61139 .01473 L
.61211 .01478 L
.61338 .01494 L
.61456 .0152 L
.61582 .01557 L
.617 .01602 L
.61922 .0171 L
.6216 .01863 L
.62418 .02069 L
.62908 .02573 L
.63366 .03173 L
.64408 .0495 L
.66512 .09806 L
.68371 .14601 L
.70397 .19171 L
.7093 .20126 L
.71497 .20995 L
.71987 .21614 L
.72516 .22136 L
.72799 .22351 L
.7306 .22508 L
.73309 .22622 L
.73434 .22665 L
.73571 .22703 L
.73696 .22728 L
.7381 .22743 L
Mistroke
.73941 .22751 L
.74066 .22749 L
.7418 .2274 L
.74287 .22725 L
.74403 .22701 L
.74526 .22668 L
.74778 .22574 L
.75017 .22453 L
.75467 .22146 L
.75951 .21704 L
.76479 .21099 L
.78309 .18227 L
.80439 .14099 L
.82372 .10573 L
.83339 .09141 L
.83848 .0851 L
.84386 .07947 L
.84857 .07546 L
.85107 .07369 L
.85374 .07207 L
.8562 .07084 L
.85844 .06993 L
.8607 .06922 L
.86284 .06873 L
.86397 .06854 L
.8652 .0684 L
.86636 .06832 L
.86742 .06829 L
.8686 .0683 L
.86989 .06838 L
.87054 .06844 L
.87123 .06853 L
.87248 .06873 L
.87381 .069 L
.87525 .06936 L
.87786 .0702 L
.88274 .07238 L
.88739 .07513 L
.89232 .07867 L
.90115 .08637 L
.91941 .10554 L
.93903 .12615 L
.94899 .13492 L
.95844 .14157 L
.96693 .14595 L
.97174 .14774 L
.97619 .14896 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o403IfMT0
0`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100
fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@2D0=WIf@<0o`2I
MP3IfMT00100fMWI00<000000=WIf@3IfMT0T`3IfMT20?l0V@040=WIf@3o09T0o`2I0?l0VG@0fMWI
000@0=WIf@030000003IfMT0fMWI0940fMWI0P3o09T60=WIf@030?l0V@3IfMT0fMWI0740fMWI000@
0=WIf@030000003IfMT0fMWI0940fMWI00<0o`2I0=WIf@3IfMT01P3IfMT00`3o09T0fMWI0=WIf@1`
0=WIf@00403IfMT00`000000fMWI0=WIf@2@0=WIf@030?l0V@3IfMT0fMWI00L0fMWI0P3o09Ua0=WI
f@00403IfMT00`000000fMWI0=WIf@1?0=WIf@L0o`2I>@3IfMT00`3o09T0fMWI0=WIf@090=WIf@03
0?l0V@3IfMT0fMWI06l0fMWI00080=WIf@8000001P3IfMT00`000000fMWI0=WIf@1>0=WIf@80o`2I
1P3IfMT00`3o09T0fMWI0=WIf@0e0=WIf@80o`2I303IfMT00`3o09T0fMWI0=WIf@1^0=WIf@001`3I
fMT010000000fMWI0=WIf@0000050=WIf@030000003IfMT0fMWI04d0fMWI00<0o`2I0=WIf@3IfMT0
1P3IfMT20?l0VCH0fMWI00<0o`2I0=WIf@3IfMT02`3IfMT20?l0VFl0fMWI000:0=WIf@030000003I
fMT0fMWI00<0fMWI0P00001=0=WIf@80o`2I2@3IfMT00`3o09T0fMWI0=WIf@0c0=WIf@80o`2I3P3I
fMT00`3o09T0fMWI0=WIf@1]0=WIf@0000<0fMWI0000000000000P0000030=WIf@8000001P3IfMT0
0`000000fMWI0=WIf@1<0=WIf@030?l0V@3IfMT0fMWI00T0fMWI00<0o`2I0=WIf@3IfMT0<P3IfMT0
0`3o09T0fMWI0=WIf@0>0=WIf@030?l0V@3IfMT0fMWI06`0fMWI000:0=WIf@030000003IfMT0fMWI
00<0fMWI00<000000=WIf@3IfMT0B`3IfMT00`3o09T0fMWI0=WIf@0:0=WIf@80o`2I<P3IfMT20?l0
VA00fMWI00<0o`2I0=WIf@3IfMT0K03IfMT000L0fMWI00@000000=WIf@3IfMT000001@3IfMT00`00
0000fMWI0=WIf@1:0=WIf@030?l0V@3IfMT0fMWI00`0fMWI00<0o`2I0=WIf@3IfMT0<03IfMT00`3o
09T0fMWI0=WIf@0@0=WIf@030?l0V@3IfMT0fMWI06/0fMWI00080=WIf@8000001P3IfMT00`000000
fMWI0=WIf@190=WIf@030?l0V@3IfMT0fMWI00h0fMWI00<0o`2I0=WIf@3IfMT0;P3IfMT20?l0VA80
fMWI00<0o`2I0=WIf@3IfMT0J`3IfMT00100fMWI00<000000=WIf@3IfMT0B03IfMT20?l0VA00fMWI
00<0o`2I0=WIf@3IfMT0;P3IfMT00`3o09T0fMWI0=WIf@0B0=WIf@030?l0V@3IfMT0fMWI06X0fMWI
000@0=WIf@030000003IfMT0fMWI04P0fMWI00<0o`2I0=WIf@3IfMT0403IfMT00`3o09T0fMWI0=WI
f@0/0=WIf@80o`2I503IfMT00`3o09T0fMWI0=WIf@0d0=WIf@<0o`2I<`3IfMT00100fMWI00<00000
0=WIf@3IfMT0A`3IfMT00`3o09T0fMWI0=WIf@0A0=WIf@030?l0V@3IfMT0fMWI02`0fMWI00<0o`2I
0=WIf@3IfMT04`3IfMT00`3o09T0fMWI0=WIf@0a0=WIf@<0o`2I0`3IfMT30?l0VC00fMWI000@0=WI
f@030000003IfMT0fMWI04L0fMWI00<0o`2I0=WIf@3IfMT04P3IfMT00`3o09T0fMWI0=WIf@0Z0=WI
f@80o`2I5P3IfMT00`3o09T0fMWI0=WIf@0_0=WIf@80o`2I203IfMT00`3o09T0fMWI0=WIf@0]0=WI
f@00403IfMT00`000000fMWI0=WIf@160=WIf@030?l0V@3IfMT0fMWI01<0fMWI00<0o`2I0=WIf@3I
fMT0:P3IfMT00`3o09T0fMWI0=WIf@0E0=WIf@030?l0V@3IfMT0fMWI02h0fMWI00<0o`2I0=WIf@3I
fMT02@3IfMT00`3o09T0fMWI0=WIf@0/0=WIf@00403IfMT00`000000fMWI0=WIf@160=WIf@030?l0
V@3IfMT0fMWI01<0fMWI0P3o09TZ0=WIf@80o`2I5`3IfMT00`3o09T0fMWI0=WIf@0]0=WIf@030?l0
V@3IfMT0fMWI00/0fMWI0P3o09T/0=WIf@00403IfMT00`000000fMWI0=WIf@160=WIf@030?l0V@3I
fMT0fMWI01@0fMWI00<0o`2I0=WIf@3IfMT0:03IfMT00`3o09T0fMWI0=WIf@0G0=WIf@030?l0V@3I
fMT0fMWI02/0fMWI00<0o`2I0=WIf@3IfMT03P3IfMT00`3o09T0fMWI0=WIf@0Y0=WIf@00403IfMT0
0`000000fMWI0=WIf@150=WIf@030?l0V@3IfMT0fMWI01D0fMWI0P3o09TY0=WIf@030?l0V@3IfMT0
fMWI01L0fMWI00<0o`2I0=WIf@3IfMT0:P3IfMT00`3o09T0fMWI0=WIf@0@0=WIf@030?l0V@3IfMT0
fMWI02P0fMWI000@0=WIf@030000003IfMT0fMWI04D0fMWI00<0o`2I0=WIf@3IfMT05P3IfMT00`3o
09T0fMWI0=WIf@0V0=WIf@030?l0V@3IfMT0fMWI01T0fMWI00<0o`2I0=WIf@3IfMT0:03IfMT00`3o
09T0fMWI0=WIf@0A0=WIf@80o`2I:@3IfMT00100fMWI00<000000=WIf@3IfMT0A03IfMT20?l0VAP0
fMWI0P3o09TW0=WIf@030?l0V@3IfMT0fMWI01T0fMWI00<0o`2I0=WIf@3IfMT09`3IfMT20?l0VA@0
fMWI0P3o09TX0=WIf@00403IfMT00`000000fMWI0=WIf@140=WIf@030?l0V@3IfMT0fMWI01P0fMWI
00<0o`2I0=WIf@3IfMT09@3IfMT00`3o09T0fMWI0=WIf@0I0=WIf@030?l0V@3IfMT0fMWI02L0fMWI
00<0o`2I0=WIf@3IfMT0503IfMT00`3o09T0fMWI0=WIf@0V0=WIf@00403IfMT00`000000fMWI0=WI
f@0=0=WIf@P0o`2I;P3IfMT00`3o09T0fMWI0=WIf@0I0=WIf@030?l0V@3IfMT0fMWI02D0fMWI00<0
o`2I0=WIf@3IfMT06P3IfMT00`3o09T0fMWI0=WIf@0U0=WIf@030?l0V@3IfMT0fMWI01H0fMWI00<0
o`2I0=WIf@3IfMT09@3IfMT00100fMWI00<000000=WIf@3IfMT02`3IfMT20?l0V@P0fMWI0P3o09T/
0=WIf@030?l0V@3IfMT0fMWI01X0fMWI00<0o`2I0=WIf@3IfMT08`3IfMT00`3o09T0fMWI0=WIf@0K
0=WIf@030?l0V@3IfMT0fMWI02@0fMWI0P3o09TI0=WIf@030?l0V@3IfMT0fMWI02@0fMWI000@0=WI
f@030000003IfMT0fMWI00P0fMWI0`3o09T<0=WIf@80o`2I:@3IfMT00`3o09T0fMWI0=WIf@0K0=WI
f@030?l0V@3IfMT0fMWI02<0fMWI00<0o`2I0=WIf@3IfMT0703IfMT00`3o09T0fMWI0=WIf@0S0=WI
f@030?l0V@3IfMT0fMWI01T0fMWI00<0o`2I0=WIf@3IfMT08`3IfMT00100fMWI00<000000=WIf@3I
fMT01@3IfMT40?l0VA00fMWI00<0o`2I0=WIf@3IfMT09P3IfMT00`3o09T0fMWI0=WIf@0L0=WIf@03
0?l0V@3IfMT0fMWI0280fMWI00<0o`2I0=WIf@3IfMT0703IfMT00`3o09T0fMWI0=WIf@0R0=WIf@03
0?l0V@3IfMT0fMWI01/0fMWI00<0o`2I0=WIf@3IfMT08P3IfMT00100fMWI00<000000=WIf@3IfMT0
1@3o09TE0=WIf@80o`2I9@3IfMT00`3o09T0fMWI0=WIf@0M0=WIf@030?l0V@3IfMT0fMWI0240fMWI
00<0o`2I0=WIf@3IfMT07@3IfMT00`3o09T0fMWI0=WIf@0R0=WIf@030?l0V@3IfMT0fMWI01`0fMWI
00<0o`2I0=WIf@3IfMT08@3IfMT000L0fMWI100000050=WIf@<0o`2I703IfMT00`3o09T0fMWI0=WI
f@0R0=WIf@030?l0V@3IfMT0fMWI01h0fMWI00<0o`2I0=WIf@3IfMT0803IfMT00`3o09T0fMWI0=WI
f@0N0=WIf@030?l0V@3IfMT0fMWI0200fMWI00<0o`2I0=WIf@3IfMT07P3IfMT00`3o09T0fMWI0=WI
f@0P0=WIf@001`3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI01d0fMWI00<0o`2I
0=WIf@3IfMT0803IfMT00`3o09T0fMWI0=WIf@0O0=WIf@030?l0V@3IfMT0fMWI0200fMWI00<0o`2I
0=WIf@3IfMT07P3IfMT00`3o09T0fMWI0=WIf@0P0=WIf@030?l0V@3IfMT0fMWI01l0fMWI00<0o`2I
0=WIf@3IfMT07`3IfMT000P0fMWI00<000000=WIf@3IfMT01@3IfMT2000001l0fMWI00<0o`2I0=WI
f@3IfMT07P3IfMT20?l0VB40fMWI00<0o`2I0=WIf@3IfMT0803IfMT00`3o09T0fMWI0=WIf@0N0=WI
f@030?l0V@3IfMT0fMWI01l0fMWI00<0o`2I0=WIf@3IfMT08@3IfMT00`3o09T0fMWI0=WIf@0N0=WI
f@0000<0fMWI0000000000000P0000040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT07P3IfMT20?l0VAl0fMWI00<0o`2I0=WIf@3IfMT08@3IfMT00`3o09T0fMWI0=WIf@0N0=WIf@03
0?l0V@3IfMT0fMWI0200fMWI00<0o`2I0=WIf@3IfMT07@3IfMT20?l0VB@0fMWI0P3o09TN0=WIf@00
2P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI01l0fMWI00<0o`2I0=WIf@3IfMT0
703IfMT20?l0VB<0fMWI00<0o`2I0=WIf@3IfMT07P3IfMT00`3o09T0fMWI0=WIf@0P0=WIf@030?l0
V@3IfMT0fMWI01d0fMWI00<0o`2I0=WIf@3IfMT0903IfMT30?l0VA`0fMWI00070=WIf@040000003I
fMT0fMWI000000D0fMWI00<000000=WIf@3IfMT0803IfMT00`3o09T0fMWI0=WIf@0K0=WIf@030?l0
V@3IfMT0fMWI02<0fMWI00<0o`2I0=WIf@3IfMT07@3IfMT00`3o09T0fMWI0=WIf@0Q0=WIf@030?l0
V@3IfMT0fMWI01/0fMWI0P3o09TY0=WIf@80o`2I6P3IfMT000P0fMWI0P0000060=WIf@030000003I
fMT0fMWI0240fMWI00<0o`2I0=WIf@3IfMT06@3IfMT00`3o09T0fMWI0=WIf@0T0=WIf@030?l0V@3I
fMT0fMWI01`0fMWI00<0o`2I0=WIf@3IfMT08P3IfMT00`3o09T0fMWI0=WIf@0K0=WIf@030?l0V@3I
fMT0fMWI02X0fMWI0P3o09TH0=WIf@00403IfMT00`000000fMWI0=WIf@0R0=WIf@030?l0V@3IfMT0
fMWI01P0fMWI00<0o`2I0=WIf@3IfMT09@3IfMT00`3o09T0fMWI0=WIf@0K0=WIf@030?l0V@3IfMT0
fMWI0280fMWI0P3o09TL0=WIf@030?l0V@3IfMT0fMWI04@0fMWI000@0=WIf@030000003IfMT0fMWI
02<0fMWI00<0o`2I0=WIf@3IfMT05P3IfMT00`3o09T0fMWI0=WIf@0V0=WIf@030?l0V@3IfMT0fMWI
01X0fMWI00<0o`2I0=WIf@3IfMT0903IfMT00`3o09T0fMWI0=WIf@0I0=WIf@030?l0V@3IfMT0fMWI
04D0fMWI000@0=WIf@030000003IfMT0fMWI02<0fMWI0P3o09TG0=WIf@030?l0V@3IfMT0fMWI02H0
fMWI00<0o`2I0=WIf@3IfMT06P3IfMT00`3o09T0fMWI0=WIf@0T0=WIf@030?l0V@3IfMT0fMWI01T0
fMWI00<0o`2I0=WIf@3IfMT0A@3IfMT00100fMWI00<000000=WIf@3IfMT0903IfMT00`3o09T0fMWI
0=WIf@0D0=WIf@030?l0V@3IfMT0fMWI02P0fMWI00<0o`2I0=WIf@3IfMT0603IfMT00`3o09T0fMWI
0=WIf@0V0=WIf@030?l0V@3IfMT0fMWI01L0fMWI00<0o`2I0=WIf@3IfMT0AP3IfMT00100fMWI00<0
00000=WIf@3IfMT09@3IfMT00`3o09T0fMWI0=WIf@0B0=WIf@80o`2I:P3IfMT00`3o09T0fMWI0=WI
f@0H0=WIf@030?l0V@3IfMT0fMWI02H0fMWI00<0o`2I0=WIf@3IfMT05`3IfMT00`3o09T0fMWI0=WI
f@160=WIf@00403IfMT00`000000fMWI0=WIf@0V0=WIf@030?l0V@3IfMT0fMWI0140fMWI00<0o`2I
0=WIf@3IfMT0:@3IfMT00`3o09T0fMWI0=WIf@0H0=WIf@030?l0V@3IfMT0fMWI02L0fMWI00<0o`2I
0=WIf@3IfMT05@3IfMT00`3o09T0fMWI0=WIf@170=WIf@00403IfMT00`000000fMWI0=WIf@0W0=WI
f@030?l0V@3IfMT0fMWI00l0fMWI00<0o`2I0=WIf@3IfMT0:P3IfMT00`3o09T0fMWI0=WIf@0G0=WI
f@030?l0V@3IfMT0fMWI02P0fMWI00<0o`2I0=WIf@3IfMT05@3IfMT00`3o09T0fMWI0=WIf@170=WI
f@00403IfMT00`000000fMWI0=WIf@0X0=WIf@030?l0V@3IfMT0fMWI00h0fMWI00<0o`2I0=WIf@3I
fMT0:`3IfMT00`3o09T0fMWI0=WIf@0F0=WIf@030?l0V@3IfMT0fMWI02T0fMWI00<0o`2I0=WIf@3I
fMT04`3IfMT20?l0VDT0fMWI000@0=WIf@030000003IfMT0fMWI02T0fMWI00<0o`2I0=WIf@3IfMT0
2`3IfMT20?l0VBh0fMWI00<0o`2I0=WIf@3IfMT05@3IfMT00`3o09T0fMWI0=WIf@0Z0=WIf@030?l0
V@3IfMT0fMWI01<0fMWI00<0o`2I0=WIf@3IfMT0B03IfMT00100fMWI00<000000=WIf@3IfMT0:P3I
fMT00`3o09T0fMWI0=WIf@090=WIf@80o`2I;`3IfMT20?l0VAH0fMWI00<0o`2I0=WIf@3IfMT0:P3I
fMT20?l0VA<0fMWI00<0o`2I0=WIf@3IfMT0B@3IfMT00100fMWI00<000000=WIf@3IfMT0:`3IfMT0
0`3o09T0fMWI0=WIf@070=WIf@030?l0V@3IfMT0fMWI0300fMWI00<0o`2I0=WIf@3IfMT04`3IfMT0
0`3o09T0fMWI0=WIf@0/0=WIf@030?l0V@3IfMT0fMWI0100fMWI0P3o09U;0=WIf@00403IfMT00`00
0000fMWI0=WIf@0/0=WIf@<0o`2I103IfMT20?l0VC<0fMWI0P3o09TD0=WIf@030?l0V@3IfMT0fMWI
02d0fMWI00<0o`2I0=WIf@3IfMT03`3IfMT00`3o09T0fMWI0=WIf@1:0=WIf@00403IfMT00`000000
fMWI0=WIf@0^0=WIf@H0o`2I=@3IfMT00`3o09T0fMWI0=WIf@0B0=WIf@030?l0V@3IfMT0fMWI02d0
fMWI00<0o`2I0=WIf@3IfMT03P3IfMT00`3o09T0fMWI0=WIf@1;0=WIf@00403IfMT00`000000fMWI
0=WIf@1Y0=WIf@80o`2I4P3IfMT00`3o09T0fMWI0=WIf@0_0=WIf@030?l0V@3IfMT0fMWI00`0fMWI
0P3o09U=0=WIf@00403IfMT00`000000fMWI0=WIf@1Z0=WIf@030?l0V@3IfMT0fMWI0100fMWI00<0
o`2I0=WIf@3IfMT0;`3IfMT20?l0V@d0fMWI00<0o`2I0=WIf@3IfMT0C03IfMT00100fMWI00<00000
0=WIf@3IfMT0J`3IfMT00`3o09T0fMWI0=WIf@0>0=WIf@030?l0V@3IfMT0fMWI0340fMWI00<0o`2I
0=WIf@3IfMT02P3IfMT00`3o09T0fMWI0=WIf@1=0=WIf@001`3IfMT4000000D0fMWI00<000000=WI
f@3IfMT0J`3IfMT00`3o09T0fMWI0=WIf@0>0=WIf@030?l0V@3IfMT0fMWI0340fMWI0P3o09T:0=WI
f@80o`2IC`3IfMT000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@1/0=WIf@03
0?l0V@3IfMT0fMWI00`0fMWI00<0o`2I0=WIf@3IfMT0<`3IfMT20?l0V@P0fMWI0P3o09U@0=WIf@00
2@3IfMT00`000000fMWI0=WIf@040=WIf@800000K@3IfMT00`3o09T0fMWI0=WIf@0<0=WIf@030?l0
V@3IfMT0fMWI03@0fMWI0P3o09T60=WIf@80o`2ID@3IfMT000030=WIf@000000000000800000103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI06d0fMWI00<0o`2I0=WIf@3IfMT02P3I
fMT00`3o09T0fMWI0=WIf@0g0=WIf@80o`2I0P3IfMT20?l0VE<0fMWI00090=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0K@3IfMT20?l0V@/0fMWI00<0o`2I0=WIf@3IfMT0>@3IfMT3
0?l0VE@0fMWI00070=WIf@<000001P3IfMT00`000000fMWI0=WIf@1^0=WIf@030?l0V@3IfMT0fMWI
00P0fMWI00<0o`2I0=WIf@3IfMT0T@3IfMT000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@1^0=WIf@80o`2I203IfMT00`3o09T0fMWI0=WIf@2B0=WIf@00403IfMT00`000000fMWI
0=WIf@1_0=WIf@80o`2I1P3IfMT20?l0VI@0fMWI000@0=WIf@030000003IfMT0fMWI0700fMWI0P3o
09T40=WIf@80o`2IU@3IfMT00100fMWI00<000000=WIf@3IfMT0L@3IfMT50?l0VIL0fMWI000@0=WI
f@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00
403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3I
fMT00100fMWI00<000000=WIf@3IfMT0>03IfMT3000003P0fMWI100000030=WIf@800000=@3IfMT4
00000080fMWI0`00000e0=WIf@@000000`3IfMT2000001D0fMWI000?0=WIf@H006Ko<P3IfMT:001V
oc80fMWI2`00I_l00`3IfMT000000=WIf@0^0=WIf@/006Ko0`3IfMT00`000000fMWI0=WIf@0/0=WI
f@X006Ko0P3IfMT010000000fMWI0=WIf@00000D0=WIf@003`3IfMT9001Vobd0fMWI3`00I_l^0=WI
f@d006Ko00<000000=WIf@3IfMT0;03IfMT=001Vo`80fMWI00<000000=WIf@3IfMT0:P3IfMT>001V
o`040000003IfMT0fMWI000001@0fMWI000@0=WIf@040000003IfMT0fMWI0=WIf@D006Ko:`3IfMT4
001Vo`<0fMWI0`0000020=WIf@D006Ko:`3IfMT4001Vo`@0fMWI00D000000=WIf@3IfMT0fMWI0000
0004001Vob/0fMWI1000I_l60=WIf@030000003IfMT0fMWI00<006Ko00<000000=WIf@3IfMT0:@3I
fMT5001Vo`L0fMWI00<00000001Vo`00I_l00P00I_l20=WIf@030000003IfMT0fMWI0180fMWI000@
0=WIf@030000003IfMT0fMWI00@0fMWI0`00I_lY0=WIf@<006Ko1@3IfMT00`000000fMWI0=WIf@05
0=WIf@<006Ko:03IfMT5001Vo`D0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@<006Ko:@3I
fMT4001Vo`L0fMWI00@000000=WIf@3IfMT0fMWI1000I_lY0=WIf@@006Ko2P3IfMT010000000fMWI
001Vo`0000020=WIf@030000003IfMT0fMWI0180fMWI000@0=WIf@030000003IfMT0fMWI00D0fMWI
0`00I_lW0=WIf@<006Ko1P3IfMT00`000000fMWI0=WIf@060=WIf@@006Ko9@3IfMT3001Vo`H0fMWI
0`0000030=WIf@040000003IfMT0fMWI000000<006Ko9`3IfMT3001Vo`L0fMWI0`0000030=WIf@03
0000003IfMT006Ko008006Ko9P3IfMT4001Vo`T0fMWI00@000000=WIf@3IfMT000000P3IfMT01000
0000fMWI0=WIf@00000D0=WIf@00403IfMT00`000000fMWI0=WIf@060=WIf@<006Ko9@3IfMT3001V
o`L0fMWI100000070=WIf@<006Ko903IfMT2001Vo`T0fMWI00<000000=WIf@3IfMT00P3IfMT20000
0080fMWI0`00I_lU0=WIf@<006Ko2P3IfMT010000000fMWI0=WIf@3IfMT3000000<006Ko903IfMT3
001Vo``0fMWI0P0000040=WIf@8000005@3IfMT00100fMWI00<000000=WIf@3IfMT01`3IfMT3001V
ob80fMWI1000I_lD0=WIf@<006Ko8P3IfMT2001Voa@0fMWI0`00I_lS0=WIf@<006Ko4`3IfMT4001V
ob40fMWI0`00I_lZ0=WIf@00403IfMT00`000000fMWI0=WIf@080=WIf@<006Ko803IfMT3001VoaL0
fMWI0`00I_lP0=WIf@<006Ko5@3IfMT3001Vob40fMWI0`00I_lF0=WIf@<006Ko803IfMT2001Vob/0
fMWI000@0=WIf@030000003IfMT0fMWI00T0fMWI0`00I_lN0=WIf@<006Ko6@3IfMT3001Voah0fMWI
0`00I_lG0=WIf@<006Ko7`3IfMT3001VoaP0fMWI0`00I_lN0=WIf@8006Ko9@3IfMT2000000D0fMWI
00090=WIfA@000000`00I_lM0000008006Ko6`000003001Voa`000000`00I_lI000000<006Ko7@00
0003001VoaX000000`00I_lL000000<006Ko6P00000:0=WIf@040000003IfMT0fMWI000000@0fMWI
000@0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@00I_l00P00I_l70=WIf@030000003I
fMT0fMWI00X0fMWI00<000000=WIf@3IfMT0103IfMT2001Vo`<0fMWI00<000000=WIf@3IfMT02@3I
fMT00`000000fMWI0=WIf@0:0=WIf@0400000000I_l006Ko001Vo`P0fMWI00<000000=WIf@3IfMT0
2P3IfMT010000000fMWI0=WIf@3IfMT3001Vo`D0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000
fMWI0=WIf@080=WIf@<006Ko2`3IfMT00`000000fMWI0=WIf@090=WIf@040000003IfMT0fMWI0=WI
f@<006Ko1P3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00L0fMWI0`00I_l00`00
0000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@00I_l00P00I_l80=WI
f@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@050=WI
f@00403IfMT00`000000fMWI0=WIf@0<0=WIf@<006Ko6@3IfMT2001Voa00fMWI00<000000=WIf@3I
fMT0303IfMT3001VoaL0fMWI0`00I_lB0=WIf@030000003IfMT0fMWI00T0fMWI0`00I_lI0=WIf@<0
06Ko4`3IfMT00`000000fMWI0=WIf@080=WIf@<006Ko603IfMT3001VoaD0fMWI00<000000=WIf@3I
fMT03P3IfMT00`000000fMWI0=WIf@050=WIf@00403IfMT00`000000fMWI0=WIf@0=0=WIf@<006Ko
5`3IfMT3001Vob00fMWI0P00I_lF0=WIf@<006Ko803IfMT3001VoaL0fMWI0`00I_lP0=WIf@<006Ko
5P3IfMT3001VobH0fMWI100000050=WIf@00403IfMT00`000000fMWI0=WIf@0>0=WIf@<006Ko5@3I
fMT3001Vob80fMWI0P00I_lD0=WIf@<006Ko8P3IfMT4001Voa@0fMWI0`00I_lR0=WIf@<006Ko4`3I
fMT3001VobT0fMWI00<000000=WIf@3IfMT01@3IfMT00100fMWI00<000000=WIf@3IfMT03`3IfMT4
001Voa40fMWI1000I_lS0=WIf@<006Ko4P3IfMT3001VobD0fMWI0`00I_lB0=WIf@<006Ko903IfMT4
001Voa00fMWI0`00I_lZ0=WIf@030000003IfMT0fMWI00D0fMWI000@0=WIf@030000003IfMT0fMWI
0140fMWI0`00I_l?0=WIf@<006Ko9P3IfMT4001Vo`l0fMWI0`00I_lW0=WIf@<006Ko403IfMT3001V
obL0fMWI0`00I_l>0=WIf@<006Ko<`3IfMT00100fMWI00<000000=WIf@3IfMT04P3IfMT3001Vo``0
fMWI1000I_lY0=WIf@@006Ko303IfMT3001VobT0fMWI0`00I_l>0=WIf@<006Ko:@3IfMT3001Vo``0
fMWI0`00I_ld0=WIf@00403IfMT00`000000fMWI0=WIf@0C0=WIf@@006Ko2@3IfMT3001Vob`0fMWI
1000I_l90=WIf@@006Ko:`3IfMT4001Vo`X0fMWI1000I_l[0=WIf@<006Ko2@3IfMT4001VocD0fMWI
000@0=WIf@030000003IfMT0fMWI01@0fMWI1000I_l60=WIf@@006Ko;`3IfMT3001Vo`H0fMWI1000
I_l_0=WIf@@006Ko1@3IfMT5001Vobh0fMWI1000I_l60=WIf@@006Ko=P3IfMT00100fMWI00<00000
0=WIf@3IfMT05P3IfMT;001Voc40fMWI2`00I_la0=WIf@`006Ko<03IfMT;001VocP0fMWI000@0=WI
f@030000003IfMT0fMWI01L0fMWI2000I_ld0=WIf@P006Ko=@3IfMT7001VocD0fMWI2000I_li0=WI
f@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI
3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o
0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I
fMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@0K0=WIf@H0<ol0k03IfMT00100fMWI00<0
00000=WIf@3IfMT06P3IfMT903?o0>X0fMWI000@0=WIf@030000003IfMT0fMWI01T0fMWI0`0co`04
0=WIf@D0<ol0j03IfMT000L0fMWI100000050=WIf@030000003IfMT0fMWI01P0fMWI0`0co`070=WI
f@@0<ol0i`3IfMT000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0G0=WIf@<0
<ol02P3IfMT203?o0>L0fMWI00090=WIf@030000003IfMT0fMWI00@0fMWI0P00000H0=WIf@80<ol0
2`3IfMT203?o0>L0fMWI00090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT05P3I
fMT303?o00`0fMWI0P0co`2O0=WIf@L0<ol0@03IfMT000T0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@0F0=WIf@80<ol03@3IfMT203?o09d0fMWI2`0co`0n0=WIf@001`3IfMT30000
00H0fMWI00<000000=WIf@3IfMT05@3IfMT203?o00h0fMWI0`0co`2K0=WIf@@0<ol01@3IfMT303?o
03h0fMWI00090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT05@3IfMT203?o00l0
fMWI0P0co`2J0=WIf@<0<ol02@3IfMT203?o03d0fMWI000@0=WIf@030000003IfMT0fMWI01@0fMWI
0P0co`0@0=WIf@<0<ol0V03IfMT303?o00X0fMWI100co`0k0=WIf@00403IfMT00`000000fMWI0=WI
f@0C0=WIf@<0<ol04@3IfMT203?o09P0fMWI0P0co`0<0=WIf@@0<ol0>P3IfMT00100fMWI00<00000
0=WIf@3IfMT04`3IfMT203?o0180fMWI0`0co`2F0=WIf@80<ol03`3IfMT203?o03X0fMWI000@0=WI
f@030000003IfMT0fMWI01<0fMWI0P0co`0C0=WIf@80<ol0U@3IfMT303?o00l0fMWI0`0co`0i0=WI
f@00403IfMT00`000000fMWI0=WIf@0C0=WIf@80<ol04`3IfMT303?o09<0fMWI0`0co`0A0=WIf@80
<ol0>@3IfMT00100fMWI00<000000=WIf@3IfMT04P3IfMT203?o01D0fMWI0P0co`2C0=WIf@80<ol0
4P3IfMT303?o03P0fMWI000@0=WIf@030000003IfMT0fMWI0180fMWI0P0co`0E0=WIf@<0<ol0T@3I
fMT203?o01@0fMWI0P0co`0h0=WIf@00403IfMT00`000000fMWI0=WIf@0B0=WIf@80<ol05P3IfMT2
03?o0300fMWI2@0co`1G0=WIf@<0<ol0503IfMT303?o03L0fMWI000@0=WIf@030000003IfMT0fMWI
0140fMWI0`0co`0F0=WIf@<0<ol0;P3IfMT=03?o05@0fMWI0P0co`0F0=WIf@80<ol0=`3IfMT00100
fMWI00<000000=WIf@3IfMT04@3IfMT203?o01P0fMWI0P0co`0/0=WIf@D0<ol01P3IfMT503?o0580
fMWI0P0co`0G0=WIf@<0<ol0=P3IfMT00100fMWI00<000000=WIf@3IfMT04@3IfMT203?o01P0fMWI
0`0co`0Z0=WIf@@0<ol02`3IfMT303?o0540fMWI0P0co`0H0=WIf@80<ol0=P3IfMT00100fMWI00<0
00000=WIf@3IfMT0403IfMT203?o01X0fMWI0P0co`0Y0=WIf@<0<ol03P3IfMT303?o04l0fMWI0P0c
o`0I0=WIf@80<ol0=P3IfMT00100fMWI00<000000=WIf@3IfMT0403IfMT203?o01X0fMWI0P0co`0X
0=WIf@<0<ol0403IfMT403?o04`0fMWI0`0co`0J0=WIf@80<ol0=@3IfMT00100fMWI00<000000=WI
f@3IfMT03`3IfMT303?o01/0fMWI0P0co`0V0=WIf@<0<ol04`3IfMT403?o04X0fMWI0P0co`0K0=WI
f@80<ol0=@3IfMT00100fMWI00<000000=WIf@3IfMT03`3IfMT203?o01`0fMWI0P0co`0V0=WIf@80
<ol05P3IfMT303?o04P0fMWI0P0co`0L0=WIf@<0<ol0=03IfMT00100fMWI00<000000=WIf@3IfMT0
3`3IfMT203?o01d0fMWI0P0co`0T0=WIf@80<ol0603IfMT403?o04D0fMWI0`0co`0M0=WIf@80<ol0
=03IfMT000L0fMWI100000050=WIf@030000003IfMT0fMWI00h0fMWI0P0co`0N0=WIf@80<ol08`3I
fMT303?o01X0fMWI1@0co`120=WIf@80<ol07P3IfMT203?o03@0fMWI00070=WIf@030000003IfMT0
fMWI00H0fMWI00<000000=WIf@3IfMT03P3IfMT203?o01l0fMWI0P0co`0R0=WIf@80<ol0703IfMT6
03?o00h0fMWI3@0co`0T0=WIf@<0<ol07`3IfMT203?o03<0fMWI00080=WIf@030000003IfMT0fMWI
00D0fMWI0P00000>0=WIf@<0<ol07`3IfMT203?o0240fMWI0P0co`0P0=WIf@D0<ol01`3IfMTE03?o
0240fMWI0P0co`0P0=WIf@80<ol0<`3IfMT000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@0=0=WIf@80<ol0803IfMT303?o01l0fMWI0`0co`0R0=WIfA00<ol02`3IfMT503?o01l0
fMWI0P0co`0R0=WIf@80<ol0<P3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI
0=WIf@0=0=WIf@80<ol08@3IfMT203?o01h0fMWI0`0co`0U0=WIf@T0<ol04`3IfMT403?o01`0fMWI
0`0co`0R0=WIf@80<ol0<P3IfMT000L0fMWI00@000000=WIf@3IfMT000001@3IfMT00`000000fMWI
0=WIf@0<0=WIf@80<ol08P3IfMT303?o01d0fMWI0P0co`140=WIf@<0<ol06`3IfMT203?o02<0fMWI
0`0co`0a0=WIf@00203IfMT2000000H0fMWI00<000000=WIf@3IfMT0303IfMT203?o02<0fMWI0P0c
o`0L0=WIf@80<ol0AP3IfMT303?o01T0fMWI0`0co`0T0=WIf@80<ol0<@3IfMT00100fMWI00<00000
0=WIf@3IfMT02`3IfMT303?o02<0fMWI0`0co`0J0=WIf@<0<ol0A`3IfMT403?o01L0fMWI0P0co`0U
0=WIf@80<ol0<@3IfMT00100fMWI00<000000=WIf@3IfMT02`3IfMT203?o02D0fMWI0P0co`0J0=WI
f@80<ol0BP3IfMT303?o01D0fMWI0`0co`0V0=WIf@80<ol0<03IfMT00100fMWI00<000000=WIf@3I
fMT02`3IfMT203?o02D0fMWI0`0co`0H0=WIf@<0<ol0B`3IfMT303?o01<0fMWI0`0co`0W0=WIf@80
<ol0<03IfMT00100fMWI00<000000=WIf@3IfMT02P3IfMT203?o02L0fMWI0P0co`0H0=WIf@80<ol0
C@3IfMT403?o0100fMWI0`0co`0X0=WIf@<0<ol0;`3IfMT00100fMWI00<000000=WIf@3IfMT02P3I
fMT203?o02L0fMWI0`0co`0F0=WIf@80<ol0D03IfMT303?o00h0fMWI0`0co`0Z0=WIf@80<ol0;`3I
fMT00100fMWI00<000000=WIf@3IfMT02P3IfMT203?o02P0fMWI0P0co`0E0=WIf@<0<ol0D@3IfMT3
03?o00`0fMWI0`0co`0[0=WIf@80<ol0;`3IfMT00100fMWI00<000000=WIf@3IfMT02@3IfMT203?o
02T0fMWI0P0co`0E0=WIf@80<ol0D`3IfMT303?o00T0fMWI100co`0]0=WIf@80<ol0;P3IfMT00100
fMWI00<000000=WIf@3IfMT02@3IfMT203?o02X0fMWI0P0co`0C0=WIf@<0<ol0E03IfMT503?o00D0
fMWI100co`0^0=WIf@80<ol0;P3IfMT00100fMWI00<000000=WIf@3IfMT02@3IfMT203?o02X0fMWI
0P0co`0C0=WIf@80<ol0EP3IfMT;03?o0340fMWI0P0co`0]0=WIf@00403IfMT00`000000fMWI0=WI
f@080=WIf@80<ol0:`3IfMT303?o0140fMWI0P0co`1J0=WIf@L0<ol0<P3IfMT203?o02d0fMWI000@
0=WIf@030000003IfMT0fMWI00P0fMWI0P0co`0/0=WIf@<0<ol03`3IfMT303?o09<0fMWI0`0co`0/
0=WIf@00403IfMT00`000000fMWI0=WIf@080=WIf@80<ol0;@3IfMT303?o00d0fMWI0`0co`2E0=WI
f@80<ol0;03IfMT00100fMWI00<000000=WIf@3IfMT01`3IfMT203?o02l0fMWI0P0co`0=0=WIf@80
<ol0UP3IfMT203?o01<0fMWI00<0<ol00=WIf@3IfMT05P3IfMT00100fMWI00<000000=WIf@3IfMT0
1`3IfMT203?o02l0fMWI0`0co`0;0=WIf@80<ol0V03IfMT203?o0140fMWI0`0co`0G0=WIf@00403I
fMT00`000000fMWI0=WIf@060=WIf@<0<ol0<03IfMT303?o00P0fMWI100co`2H0=WIf@80<ol04@3I
fMT203?o01P0fMWI000@0=WIf@030000003IfMT0fMWI00H0fMWI0P0co`0b0=WIf@<0<ol01P3IfMT4
03?o09T0fMWI0`0co`0@0=WIf@80<ol0603IfMT000P0fMWI0P0000060=WIf@030000003IfMT0fMWI
00D0fMWI0P0co`0d0=WIf@@0<ol00`3IfMT303?o09`0fMWI0P0co`0?0=WIf@<0<ol0603IfMT000L0
fMWI00@000000=WIf@3IfMT000001@3IfMT00`000000fMWI0=WIf@050=WIf@80<ol0=@3IfMT803?o
09h0fMWI0P0co`0>0=WIf@80<ol06@3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT2000000D0
fMWI0P0co`0g0=WIf@H0<ol0W`3IfMT303?o00`0fMWI0P0co`0J0=WIf@00203IfMT2000000H0fMWI
00<000000=WIf@3IfMT00`3IfMT303?o0=d0fMWI0`0co`0;0=WIf@80<ol06P3IfMT000X0fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0<ol0g`3IfMT203?o00X0fMWI0P0c
o`0K0=WIf@001`3IfMT010000000fMWI0=WIf@0000050=WIf@030000003IfMT0fMWI0080fMWI0P0c
o`3P0=WIf@<0<ol0203IfMT303?o01/0fMWI00080=WIf@8000001P3IfMT010000000fMWI0=WIf@3I
fMT203?o0>80fMWI0`0co`060=WIf@<0<ol0703IfMT00100fMWI00<000000=WIf@3IfMT00`0co`3S
0=WIf@<0<ol0103IfMT303?o01d0fMWI000@0=WIf@030000003IfMT0fMWI0080<ol0i@3IfMT803?o
01h0fMWI000@0=WIf@030000003IfMT0<ol00080<ol0iP3IfMT603?o01l0fMWI000?0=WIf@D0<ol0
j@3IfMT203?o0240fMWI000?0=WIf@@0<ol0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o
0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I
fMT0o`3IfMT>0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI
f@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI
f@003@3IfMT2000000030=WIf@00000000000?l0fMWI3`3IfMT000h0fMWI00<000000=WIf@000000
o`3IfMT@0=WIf@003`3IfMT00`000000fMWI0=WIf@3o0=WIf@l0fMWI000>0=WIf@030000003IfMT0
00000?l0fMWI403IfMT000d0fMWI0P0000000`3IfMT000000000003o0=WIf@l0fMWI003o0=WIfB40
fMWI003o0=WIfB40fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-1.2944, -3.47954, \
0.0808005, 0.0435338}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        xLPlot[0, 1, 1, 
          ViewPoint \[Rule] {1\ , 1, 
              1\ }], \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .98974 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0773503 1.1547 -1.28478e-17 1.1547 [
[.83978 .3328 0 -7.23502 ]
[.83978 .3328 12 1.76498 ]
[.72665 .21491 0 -7.80382 ]
[.72665 .21491 6 1.19618 ]
[.58196 .06436 0 -8.67134 ]
[.58196 .06436 6 .32866 ]
[.77787 .16489 0 -8.5482 ]
[.77787 .16489 16 1.2643 ]
[.51948 .99939 -11.8747 0 ]
[.51948 .99939 12.1253 9 ]
[.60813 .97761 -11.2962 0 ]
[.60813 .97761 12.7038 9 ]
[.70999 .95253 -2.65359 0 ]
[.70999 .95253 3.34641 9 ]
[.82825 .92336 -7.34904 0 ]
[.82825 .92336 10.651 9 ]
[.96719 .88901 -6.60422 0 ]
[.96719 .88901 11.3958 9 ]
[.71827 1.02423 -7.07624 0 ]
[.71827 1.02423 8.92376 9.8125 ]
[.88407 .41359 0 -6.93839 ]
[.88407 .41359 12 2.06161 ]
[.92964 .57066 0 -6.45143 ]
[.92964 .57066 6 2.54857 ]
[.98764 .77116 0 -5.86705 ]
[.98764 .77116 6 3.13295 ]
[.99614 .54294 0 -7.03072 ]
[.99614 .54294 16 2.78178 ]
[ 0 0 0 0 ]
[ 1 .98974 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.85714 .37115 m
.5 0 L
s
.82745 .34029 m
.82128 .34404 L
s
[(-1)] .83978 .3328 -1 .60778 Mshowa
.71502 .22345 m
.7092 .22772 L
s
[(0)] .72665 .21491 -1 .73418 Mshowa
.57137 .07417 m
.56608 .07908 L
s
[(1)] .58196 .06436 -1 .92696 Mshowa
.125 Mabswid
.80696 .319 m
.80329 .32131 L
s
.78554 .29674 m
.78191 .29911 L
s
.76312 .27345 m
.75954 .27588 L
s
.73964 .24904 m
.7361 .25154 L
s
.68916 .19658 m
.68572 .19921 L
s
.66198 .16833 m
.6586 .17104 L
s
.63336 .13859 m
.63005 .14138 L
s
.60321 .10725 m
.59996 .11012 L
s
.84707 .36068 m
.84333 .36288 L
s
.53772 .0392 m
.53463 .04223 L
s
.5021 .00218 m
.49909 .00529 L
s
gsave
.77787 .16489 -61 -12.5482 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
.25 Mabswid
.5 .98974 m
1 .86603 L
s
.51933 .98496 m
.51925 .97774 L
s
[(-0.4)] .51948 .99939 -0.01044 -1 Mshowa
.60728 .9632 m
.60686 .95599 L
s
[(-0.2)] .60813 .97761 -0.05865 -1 Mshowa
.70833 .93819 m
.70751 .93102 L
s
[(0)] .70999 .95253 -0.11547 -1 Mshowa
.82564 .90917 m
.82434 .90207 L
s
[(0.2)] .82825 .92336 -0.18344 -1 Mshowa
.96347 .87506 m
.96162 .86809 L
s
[(0.4)] .96719 .88901 -0.2662 -1 Mshowa
.125 Mabswid
.54023 .97979 m
.54014 .97546 L
s
.56183 .97444 m
.56169 .97012 L
s
.58417 .96892 m
.58397 .96459 L
s
.63121 .95728 m
.6309 .95296 L
s
.65599 .95114 m
.65562 .94683 L
s
.68169 .94479 m
.68125 .94048 L
s
.73599 .93135 m
.73543 .92706 L
s
.76472 .92424 m
.76409 .91996 L
s
.79458 .91685 m
.79387 .91258 L
s
.85798 .90117 m
.85712 .89692 L
s
.89167 .89283 m
.89073 .8886 L
s
.9268 .88414 m
.92578 .87993 L
s
gsave
.71827 1.02423 -68.0762 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
.25 Mabswid
.85714 .37115 m
1 .86603 L
s
.87138 .42047 m
.86503 .42391 L
s
[(-1)] .88407 .41359 -1 .54187 Mshowa
.91639 .57641 m
.90977 .57928 L
s
[(0)] .92964 .57066 -1 .43365 Mshowa
.97383 .77536 m
.96692 .77746 L
s
[(1)] .98764 .77116 -1 .30379 Mshowa
.125 Mabswid
.87959 .4489 m
.87575 .4509 L
s
.88816 .47862 m
.88429 .48055 L
s
.89714 .5097 m
.89323 .51158 L
s
.90654 .54227 m
.9026 .54407 L
s
.92674 .61224 m
.92273 .61388 L
s
.93761 .64991 m
.93357 .65146 L
s
.94905 .68954 m
.94498 .691 L
s
.96111 .7313 m
.957 .73266 L
s
.86352 .39324 m
.85974 .39536 L
s
.98727 .82192 m
.98309 .82307 L
s
gsave
.99614 .54294 -61 -11.0307 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x3) show
1.000 setlinewidth
grestore
.25 Mabswid
.5 .57735 m
.5 .98974 L
s
.5 .98974 m
1 .86603 L
s
1 .86603 m
.85714 .37115 L
s
.85714 .37115 m
.5 .57735 L
s
.14286 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
0 .86603 L
s
0 .86603 m
.14286 .37115 L
s
.5 .57735 m
.5 .98974 L
s
.5 .98974 m
0 .86603 L
s
0 .86603 m
.14286 .37115 L
s
.14286 .37115 m
.5 .57735 L
s
.85714 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
1 .86603 L
s
1 .86603 m
.85714 .37115 L
s
0 0 m
1 0 L
1 .98974 L
0 .98974 L
closepath
clip
newpath
.5 Mabswid
.31697 .92503 m
.32175 .89412 L
s
.34005 .92303 m
.31697 .92503 L
s
.38847 .88876 m
.34005 .92303 L
s
.32175 .89412 m
.35324 .83296 L
s
.3028 .86224 m
.37177 .86587 L
s
.26192 .83069 m
.3028 .86224 L
s
.25288 .77302 m
.26192 .83069 L
s
.45633 .82603 m
.38847 .88876 L
s
.37177 .86587 m
.46152 .84269 L
s
.35324 .83296 m
.40682 .74727 L
s
.27547 .69384 m
.25288 .77302 L
s
.24496 .76069 m
.19804 .72127 L
s
.32411 .77956 m
.24496 .76069 L
s
.19804 .72127 m
.1876 .66362 L
s
.42739 .77791 m
.32411 .77956 L
s
.46152 .84269 m
.5619 .79642 L
s
.53505 .74143 m
.45633 .82603 L
s
.1876 .66362 m
.21358 .59234 L
s
.32567 .60021 m
.27547 .69384 L
s
.54365 .75797 m
.42739 .77791 L
s
.16238 .62221 m
.23695 .63584 L
s
.12611 .598 m
.16238 .62221 L
s
.13155 .56448 m
.12611 .598 L
s
.40682 .74727 m
.47497 .64528 L
s
.10665 .5647 m
.12822 .56126 L
s
.17743 .52458 m
.13155 .56448 L
s
.12822 .56126 m
.19052 .55166 L
s
.5619 .79642 m
.66113 .73298 L
s
.21358 .59234 m
.27176 .51393 L
s
.19052 .55166 m
.28669 .53799 L
s
.65991 .72378 m
.54365 .75797 L
s
.61437 .64364 m
.53505 .74143 L
s
.25804 .48258 m
.17743 .52458 L
s
.39617 .50101 m
.32567 .60021 L
s
.28669 .53799 m
.40609 .52338 L
s
.47497 .64528 m
.5482 .53693 L
s
.27176 .51393 m
.3543 .43617 L
s
.66113 .73298 m
.74709 .6597 L
s
.76286 .68058 m
.65991 .72378 L
s
.36384 .4437 m
.25804 .48258 L
s
.40609 .52338 m
.53551 .51153 L
s
.68361 .54252 m
.61437 .64364 L
s
.47729 .40606 m
.39617 .50101 L
s
.84034 .63413 m
.76286 .68058 L
s
.4826 .41341 m
.36384 .4437 L
s
.3543 .43617 m
.45066 .36736 L
s
.74709 .6597 m
.80886 .58456 L
s
.5482 .53693 m
.61631 .43289 L
s
.53551 .51153 m
.66065 .50612 L
s
.88287 .58997 m
.84034 .63413 L
s
.73308 .44808 m
.68361 .54252 L
s
.60079 .39676 m
.4826 .41341 L
s
.55827 .3251 m
.47729 .40606 L
s
.66065 .50612 m
.76777 .5102 L
s
.80886 .58456 m
.83807 .51519 L
s
.45066 .36736 m
.54897 .31535 L
s
.88485 .55273 m
.88287 .58997 L
s
.61631 .43289 m
.66968 .34344 L
s
.76777 .5102 m
.84522 .52565 L
s
.70516 .39763 m
.60079 .39676 L
s
.84522 .52565 m
.88485 .55273 L
s
.83807 .51519 m
.83001 .45814 L
s
.75536 .3694 m
.73308 .44808 L
s
.62858 .26676 m
.55827 .3251 L
s
.54897 .31535 m
.63742 .28666 L
s
.78432 .41813 m
.70516 .39763 L
s
.83001 .45814 m
.78432 .41813 L
s
.66968 .34344 m
.70056 .27736 L
s
.7463 .3137 m
.75536 .3694 L
s
.63742 .28666 m
.7057 .2856 L
s
.67926 .23752 m
.62858 .26676 L
s
.7057 .2856 m
.7463 .3137 L
s
.70056 .27736 m
.70414 .24098 L
s
.70414 .24098 m
.67926 .23752 L
s
.25 Mabswid
.14286 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
0 .86603 L
s
0 .86603 m
.14286 .37115 L
s
.85714 .37115 m
.5 0 L
s
.5 0 m
.5 .57735 L
s
.5 .57735 m
1 .86603 L
s
1 .86603 m
.85714 .37115 L
s
.85714 .37115 m
.5 0 L
s
.82745 .34029 m
.82128 .34404 L
s
[(-1)] .83978 .3328 -1 .60778 Mshowa
.71502 .22345 m
.7092 .22772 L
s
[(0)] .72665 .21491 -1 .73418 Mshowa
.57137 .07417 m
.56608 .07908 L
s
[(1)] .58196 .06436 -1 .92696 Mshowa
.125 Mabswid
.80696 .319 m
.80329 .32131 L
s
.78554 .29674 m
.78191 .29911 L
s
.76312 .27345 m
.75954 .27588 L
s
.73964 .24904 m
.7361 .25154 L
s
.68916 .19658 m
.68572 .19921 L
s
.66198 .16833 m
.6586 .17104 L
s
.63336 .13859 m
.63005 .14138 L
s
.60321 .10725 m
.59996 .11012 L
s
.84707 .36068 m
.84333 .36288 L
s
.53772 .0392 m
.53463 .04223 L
s
.5021 .00218 m
.49909 .00529 L
s
gsave
.77787 .16489 -61 -12.5482 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x1) show
1.000 setlinewidth
grestore
.25 Mabswid
.5 .98974 m
1 .86603 L
s
.51933 .98496 m
.51925 .97774 L
s
[(-0.4)] .51948 .99939 -0.01044 -1 Mshowa
.60728 .9632 m
.60686 .95599 L
s
[(-0.2)] .60813 .97761 -0.05865 -1 Mshowa
.70833 .93819 m
.70751 .93102 L
s
[(0)] .70999 .95253 -0.11547 -1 Mshowa
.82564 .90917 m
.82434 .90207 L
s
[(0.2)] .82825 .92336 -0.18344 -1 Mshowa
.96347 .87506 m
.96162 .86809 L
s
[(0.4)] .96719 .88901 -0.2662 -1 Mshowa
.125 Mabswid
.54023 .97979 m
.54014 .97546 L
s
.56183 .97444 m
.56169 .97012 L
s
.58417 .96892 m
.58397 .96459 L
s
.63121 .95728 m
.6309 .95296 L
s
.65599 .95114 m
.65562 .94683 L
s
.68169 .94479 m
.68125 .94048 L
s
.73599 .93135 m
.73543 .92706 L
s
.76472 .92424 m
.76409 .91996 L
s
.79458 .91685 m
.79387 .91258 L
s
.85798 .90117 m
.85712 .89692 L
s
.89167 .89283 m
.89073 .8886 L
s
.9268 .88414 m
.92578 .87993 L
s
gsave
.71827 1.02423 -68.0762 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x2) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 285},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00017B000`400?l00000o`00003oR03IfMT0
0`000000fMWI0=WIf@2E0=WIf@00Q`3IfMT3000009H0fMWI00260=WIf@<0000000<0fMWI0000003I
fMT0U03IfMT008D0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@2B0=WIf@00
Q03IfMT01@000000fMWI0=WIf@3IfMT0000000<0fMWI00<000000=WIf@3IfMT0T@3IfMT008<0fMWI
00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0900fMWI
00220=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI
f@2?0=WIf@00P@3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0SP3IfMT00800fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@050=WI
f@030000003IfMT0fMWI08d0fMWI001o0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00OP3IfMT00`000000fMWI0=WIf@070=WIf@030000
003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00T0fMWI1000001n0=WIf@00O03IfMT0
0`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@000000303IfMT0
0`000000fMWI0=WIf@1m0=WIf@00O03IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI
00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@1m0=WIf@00N`3IfMT00`000000
fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@1m0=WIf@00NP3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00/0fMWI
00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@1m0=WIf@00N@3IfMT00`000000fMWI0=WI
f@0<0=WIf@030000003IfMT0fMWI00`0fMWI00<000000=WIf@3IfMT0103IfMT3000007l0fMWI001h
0=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT03@3IfMT00`000000fMWI0=WIf@05
0=WIf@030000003IfMT0fMWI07d0fMWI001g0=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WI
f@3IfMT03P3IfMT00`000000fMWI0=WIf@240=WIf@00MP3IfMT00`000000fMWI0=WIf@0?0=WIf@03
0000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT0P`3IfMT007D0fMWI00<000000=WIf@3IfMT0
403IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI0880fMWI001d0=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI000000230=WIf@00L`3IfMT0
0`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI00h0fMWI00D000000=WIf@3IfMT0fMWI0000
00220=WIf@00LP3IfMT00`000000fMWI0=WIf@0C0=WIf@030000003IfMT0fMWI01<0fMWI00<00000
0=WIf@3IfMT0O`3IfMT00740fMWI00<000000=WIf@3IfMT0503IfMT00`000000fMWI0=WIf@0D0=WI
f@030000003IfMT0fMWI07h0fMWI001`0=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3I
fMT05@3IfMT00`000000fMWI0=WIf@1m0=WIf@00K`3IfMT00`000000fMWI0=WIf@0F0=WIf@030000
003IfMT0fMWI01H0fMWI00<000000=WIf@3IfMT0O03IfMT006h0fMWI00<000000=WIf@3IfMT05`3I
fMT00`000000fMWI0=WIf@0G0=WIf@030000003IfMT0fMWI07/0fMWI001]0=WIf@030000003IfMT0
fMWI01P0fMWI00<000000=WIf@3IfMT0603IfMT00`000000fMWI0=WIf@1j0=WIf@00K03IfMT00`00
0000fMWI0=WIf@0I0=WIf@030000003IfMT0fMWI01P0fMWI0P00001k0=WIf@00J`3IfMT00`000000
fMWI0=WIf@0J0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@000000N`3IfMT006X0fMWI
00<000000=WIf@3IfMT06`3IfMT00`000000fMWI0=WIf@0J0=WIf@030000003IfMT0fMWI07P0fMWI
001Y0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT06`3IfMT00`000000fMWI0=WI
f@1g0=WIf@00J03IfMT00`000000fMWI0=WIf@0M0=WIf@030000003IfMT0fMWI01`0fMWI00<00000
0=WIf@3IfMT0MP3IfMT006L0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0M0=WI
f@030000003IfMT0fMWI07D0fMWI001V0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@1d0=WIf@00I@3IfMT00`000000fMWI0=WIf@0P0=WIf@030000
003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT0L`3IfMT006@0fMWI00<000000=WIf@3IfMT08@3I
fMT00`000000fMWI0=WIf@0P0=WIf@030000003IfMT0fMWI0780fMWI001T0=WIf@030000003IfMT0
fMWI0240fMWI00<000000=WIf@3IfMT07`3IfMT3000007<0fMWI001S0=WIf@030000003IfMT0fMWI
0280fMWI00<000000=WIf@3IfMT08P3IfMT00`000000fMWI0=WIf@1`0=WIf@00HP3IfMT00`000000
fMWI0=WIf@0S0=WIf@030000003IfMT0fMWI02<0fMWI00<000000=WIf@3IfMT08`3IfMT200000003
0=WIf@00000000000080fMWI100000110=WIf@00H@3IfMT00`000000fMWI0=WIf@0T0=WIf@030000
003IfMT0fMWI02@0fMWI00<000000=WIf@3IfMT08`3IfMT00`000000fMWI000000050=WIf@030000
003IfMT0fMWI0400fMWI001P0=WIf@030000003IfMT0fMWI02D0fMWI00<000000=WIf@3IfMT09@3I
fMT00`000000fMWI0=WIf@0S0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0@03I
fMT005l0fMWI00<000000=WIf@3IfMT09P3IfMT00`000000fMWI0=WIf@0V0=WIf@030000003IfMT0
fMWI0240fMWI00<000000=WIf@0000001@3IfMT00`000000fMWI0=WIf@100=WIf@00GP3IfMT00`00
0000fMWI0=WIf@0W0=WIf@030000003IfMT0fMWI02L0fMWI00<000000=WIf@3IfMT07`3IfMT20000
00030=WIf@000000000000@0fMWI00<000000=WIf@3IfMT0@03IfMT005d0fMWI00<000000=WIf@3I
fMT0:03IfMT00`000000fMWI0=WIf@0X0=WIf@030000003IfMT0fMWI02D0fMWI0`0000120=WIf@00
G03IfMT00`000000fMWI0=WIf@0Y0=WIf@030000003IfMT0fMWI02L0fMWI0`00000X0=WIf@030000
003IfMT0fMWI0400fMWI001K0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0:P3I
fMT00`000000fMWI0=WIf@1X0=WIf@00FP3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0
fMWI02/0fMWI00<000000=WIf@3IfMT0I`3IfMT005T0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI06H0fMWI001H0=WIf@030000003IfMT0fMWI02d0
fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@1V0=WIf@00E`3IfMT00`000000fMWI
0=WIf@0^0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0I@3IfMT005H0fMWI00<0
00000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0fMWI00X0fMWI0P00
001H0=WIf@00E@3IfMT00`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI02l0fMWI00<00000
0=WIf@3IfMT0203IfMT010000000fMWI0=WIf@00001G0=WIf@00E03IfMT00`000000fMWI0=WIf@0a
0=WIf@030000003IfMT0fMWI02h0fMWI00<000000=WIf@0000002@3IfMT010000000fMWI0=WIf@00
001G0=WIf@00D`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI0340fMWI00<00000
0=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@00001G0=WIf@00DP3IfMT00`000000fMWI0=WIf@0c
0=WIf@030000003IfMT0fMWI0380fMWI00<000000=WIf@3IfMT01@3IfMT010000000fMWI0=WIf@00
001G0=WIf@00D@3IfMT00`000000fMWI0=WIf@0d0=WIf@030000003IfMT0fMWI03<0fMWI00<00000
0=WIf@3IfMT0103IfMT010000000fMWI0=WIf@00001G0=WIf@00D03IfMT00`000000fMWI0=WIf@0e
0=WIf@030000003IfMT0fMWI03@0fMWI00<000000=WIf@3IfMT0103IfMT2000005P0fMWI001?0=WI
f@030000003IfMT0fMWI03H0fMWI00<000000=WIf@3IfMT0=@3IfMT00`000000fMWI0=WIf@1M0=WI
f@00CP3IfMT00`000000fMWI0=WIf@0g0=WIf@030000003IfMT0fMWI03H0fMWI00<000000=WIf@3I
fMT0G03IfMT004d0fMWI00<000000=WIf@3IfMT0>03IfMT00`000000fMWI0=WIf@0e0=WIf@030000
003IfMT0000005d0fMWI001<0=WIf@030000003IfMT0fMWI03T0fMWI00<000000=WIf@3IfMT0>03I
fMT00`000000fMWI0=WIf@1J0=WIf@00C03IfMT00`000000fMWI0=WIf@0i0=WIf@030000003IfMT0
fMWI03T0fMWI00<000000=WIf@3IfMT0F@3IfMT004/0fMWI00<000000=WIf@3IfMT0>P3IfMT00`00
0000fMWI0=WIf@0]0=WIf@<000002P3IfMT00`000000fMWI0=WIf@1H0=WIf@00BP3IfMT00`000000
fMWI0=WIf@0k0=WIf@030000003IfMT0fMWI02/0fMWI0P0000030=WIf@@000001`3IfMT00`000000
fMWI0=WIf@1G0=WIf@00B@3IfMT00`000000fMWI0=WIf@0l0=WIf@030000003IfMT0fMWI02T0fMWI
0P0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0EP3IfMT004P0fMWI00<0
00000=WIf@3IfMT0?@3IfMT00`000000fMWI0=WIf@0W0=WIf@8000002P3IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI05D0fMWI00170=WIf@030000003IfMT0fMWI03h0fMWI00<00000
0=WIf@3IfMT09P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@000000EP3IfMT004H0fMWI00<000000=WIf@3IfMT0?`3IfMT00`000000fMWI0=WIf@0T0=WI
f@8000003@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI05<0fMWI00150=WIf@03
0000003IfMT0fMWI0400fMWI00<000000=WIf@3IfMT08P3IfMT2000000l0fMWI00<000000=WIf@3I
fMT02@3IfMT00`000000fMWI0=WIf@1C0=WIf@00A03IfMT00`000000fMWI0=WIf@110=WIf@030000
003IfMT0fMWI0200fMWI0P00000@0=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT0
DP3IfMT004<0fMWI00<000000=WIf@3IfMT0@P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003I
fMT0fMWI0100fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@1A0=WIf@00@P3IfMT0
0`000000fMWI0=WIf@130=WIf@030000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT04@3IfMT0
0`000000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI0500fMWI00110=WIf@030000003IfMT0fMWI
04@0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI
00d0fMWI0P00001A0=WIf@00@03IfMT00`000000fMWI0=WIf@150=WIf@030000003IfMT0fMWI01/0
fMWI0P00000E0=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT0CP3IfMT003l0fMWI
00<000000=WIf@3IfMT0AP3IfMT00`000000fMWI0=WIf@0J0=WIf@030000003IfMT0fMWI01D0fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@1=0=WIf@00?P3IfMT00`000000fMWI0=WI
f@170=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT0103IfMTE00000140fMWI00<0
00000=WIf@3IfMT0C03IfMT003d0fMWI00<000000=WIf@3IfMT0B03IfMT00`000000fMWI0=WIf@0H
0=WIf@030000003IfMT0fMWI0080fMWI0`00000A0=WIf@040000003IfMT0fMWI0=WIf@800000403I
fMT00`000000fMWI0=WIf@1;0=WIf@00?03IfMT00`000000fMWI0=WIf@190=WIf@030000003IfMT0
fMWI01L0fMWI00<000000=WIf@3IfMT00`00000C0=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@1:0=WIf@00>`3IfMT00`000000fMWI0=WIf@1:0=WI
f@030000003IfMT0fMWI01D0fMWI1@00000F0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WI
f@3IfMT03P3IfMT00`000000fMWI0=WIf@190=WIf@00>P3IfMT00`000000fMWI0=WIf@1;0=WIf@03
0000003IfMT0fMWI01@0fMWI0`00000H0=WIf@030000003IfMT0fMWI00L0fMWI0P00000=0=WIf@03
0000003IfMT0000004X0fMWI000i0=WIf@030000003IfMT0fMWI04`0fMWI00<000000=WIf@3IfMT0
4P3IfMT3000001X0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000
003IfMT0fMWI04L0fMWI000h0=WIf@030000003IfMT0fMWI04d0fMWI00<000000=WIf@3IfMT03`3I
fMT4000001/0fMWI00<000000=WIf@3IfMT02`3IfMT2000000h0fMWI00<000000=WIf@3IfMT0AP3I
fMT003L0fMWI00<000000=WIf@3IfMT0CP3IfMT00`000000fMWI0=WIf@0<0=WIf@<000000P3IfMT0
0`000000fMWI0=WIf@0J0=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT0303IfMT0
0`000000fMWI0=WIf@150=WIf@00=P3IfMT00`000000fMWI0=WIf@1?0=WIf@030000003IfMT0fMWI
00X0fMWI0P0000030=WIf@800000703IfMT00`000000fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI
00d0fMWI00<000000=WIf@3IfMT03@3IfMT4000003<0fMWI000e0=WIf@030000003IfMT0fMWI0500
fMWI00<000000=WIf@3IfMT0203IfMT2000000@0fMWI00<000000=WIf@3IfMT0703IfMT00`000000
fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3IfMT03P3IfMT00`000000
fMWI0=WIf@0b0=WIf@00=03IfMT00`000000fMWI0=WIf@1A0=WIf@030000003IfMT0fMWI00H0fMWI
0P0000050=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI
0=WIf@0<0=WIf@030000003IfMT0000000l0fMWI00<000000=WIf@3IfMT0<P3IfMT003@0fMWI00<0
00000=WIf@3IfMT0D@3IfMT00`000000fMWI0=WIf@040=WIf@8000001P3IfMT00`000000fMWI0=WI
f@0M0=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WI
f@040=WIf@@00000103IfMT00`000000fMWI0=WIf@0b0=WIf@00<`3IfMT00`000000fMWI0=WIf@1B
0=WIf@030000003IfMT0fMWI0080fMWI0P0000070=WIf@030000003IfMT0fMWI01d0fMWI00<00000
0=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00/0fMWI00<00000
0=WIf@3IfMT0<P3IfMT00380fMWI00<000000=WIf@3IfMT0D`3IfMT00`000000fMWI0=WIf@020000
00P0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI
0100fMWI00<000000=WIf@3IfMT02@3IfMT3000003@0fMWI000a0=WIf@030000003IfMT0fMWI05@0
fMWI0`0000090=WIf@030000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT04P3IfMT00`000000
fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0<P3IfMT00300fMWI
00<000000=WIf@3IfMT0E03IfMT2000000X0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI
0=WIf@0C0=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT0?P3IfMT002l0fMWI00<0
00000=WIf@3IfMT0D`3IfMT2000000030=WIf@000000fMWI00P0fMWI00<000000=WIf@3IfMT07`3I
fMT00`000000fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@000000?`3I
fMT002h0fMWI00<000000=WIf@3IfMT0DP3IfMT2000000<0fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@0P0=WIf@030000003IfMT0fMWI01@0fMWI00<000000=WIf@3IfMT04`3IfMT0
0`000000fMWI0=WIf@0l0=WIf@00;@3IfMT00`000000fMWI0=WIf@1A0=WIf@8000001@3IfMT00`00
0000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0200fMWI00<000000=WIf@3IfMT05@3IfMT00`00
0000fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI03/0fMWI000/0=WIf@030000003IfMT0fMWI0500
fMWI0P0000070=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000
fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT0>P3IfMT002/0fMWI
00<000000=WIf@3IfMT0C`3IfMT2000000T0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI
0=WIf@0Q0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3IfMT05@3IfMT00`000000fMWI
0=WIf@0i0=WIf@00:P3IfMT00`000000fMWI0=WIf@1>0=WIf@8000002`3IfMT010000000fMWI0=WI
f@3IfMT2000002@0fMWI00<000000=WIf@3IfMT05`3IfMT00`000000fMWI0=WIf@0D0=WIf@030000
003IfMT0000003X0fMWI000Y0=WIf@030000003IfMT0fMWI04h0fMWI00<000000=WIf@3IfMT02`3I
fMT010000000fMWI0=WIf@00000U0=WIf@030000003IfMT0fMWI01P0fMWI00<000000=WIf@3IfMT0
5`3IfMT00`000000fMWI0=WIf@0g0=WIf@00:03IfMT00`000000fMWI0=WIf@1=0=WIf@8000003P3I
fMT00`000000fMWI0000000U0=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT0603I
fMT00`000000fMWI0=WIf@0f0=WIf@00:03IfMT3000004`0fMWI00<000000=WIf@3IfMT03P3IfMT2
000002H0fMWI00<000000=WIf@3IfMT0603IfMT00`000000fMWI0=WIf@0G0=WIf@<00000>03IfMT0
02L0fMWI00@000000=WIf@3IfMT0fMWI0P0000190=WIf@030000003IfMT0fMWI00l0fMWI00<00000
0=WIf@3IfMT0903IfMT00`000000fMWI0=WIf@0I0=WIf@030000003IfMT0fMWI01D0fMWI0P000003
0=WIf@030000003IfMT0fMWI03D0fMWI000W0=WIf@030000003IfMT0fMWI00<0fMWI0P0000150=WI
f@8000004@3IfMT2000002H0fMWI00<000000=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0C0=WI
f@8000001@3IfMT00`000000fMWI0=WIf@0e0=WIf@009`3IfMT00`000000fMWI0=WIf@050=WIf@03
0000003IfMT0fMWI0440fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0000000U0=WIf@03
0000003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@050=WIf@03
0000003IfMT0fMWI03D0fMWI000W0=WIf@030000003IfMT0fMWI00H0fMWI0P00000o0=WIf@800000
4P3IfMT010000000fMWI0=WIf@00000T0=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3I
fMT04@3IfMT2000000P0fMWI00<000000=WIf@3IfMT0=@3IfMT002H0fMWI00<000000=WIf@3IfMT0
2@3IfMT2000003`0fMWI00<000000=WIf@3IfMT04@3IfMT01@000000fMWI0=WIf@3IfMT0000002@0
fMWI00<000000=WIf@3IfMT06P3IfMT00`000000fMWI0=WIf@0?0=WIf@8000002P3IfMT2000003H0
fMWI000V0=WIf@030000003IfMT0fMWI00/0fMWI0P00000i0=WIf@030000003IfMT0fMWI0140fMWI
00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0D0=WIfB8000002@3IfMT00`000000fMWI
0=WIf@0>0=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT02@3IfMT4000002L0fMWI
000V0=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT0=03IfMT2000001<0fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0<0=WIf@P000003@3IfMT00`000000fMWI0=WI
f@0B0=WIf@@00000103IfMT00`000000fMWI0=WIf@0=0=WIf@8000003P3IfMT00`000000fMWI0=WI
f@0;0=WIf@030000003IfMT0fMWI02H0fMWI000U0=WIf@030000003IfMT0fMWI00l0fMWI0P00000c
0=WIf@030000003IfMT0fMWI0180fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@P00000503IfMT00`000000fMWI0=WIf@0G0=WIf@D000003@3IfMT200000140fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@0V0=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WI
f@800000<03IfMT00`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI00@0fMWI2000000L0=WI
f@030000003IfMT0fMWI01/0fMWI1@0000070=WIf@8000004`3IfMT00`000000fMWI0=WIf@020=WI
f@@00000103IfMT00`000000fMWI0=WIf@0V0=WIf@009@3IfMT00`000000fMWI0=WIf@0C0=WIf@80
0000;03IfMT2000001@0fMWI00<000000=WIf@0000001@0000000`3IfMT000000=WIf@0P0=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI00<000000=WIf@3I
fMT04`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI02H0fMWI000U0=WIf@030000
003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT0:03IfMT00`000000fMWI0=WIf@0B0=WIf@@00000
1`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT0
1`3IfMT3000001D0fMWI00<000000=WIf@3IfMT0203IfMT3000002P0fMWI000T0=WIf@030000003I
fMT0fMWI01L0fMWI0P00000V0=WIf@8000004@3IfMT4000000030=WIf@000000fMWI00P0fMWI00<0
00000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0fMWI00D0fMWI0P00
00030=WIf@030000003IfMT0fMWI0180fMWI0P00000;0=WIf@030000003IfMT0fMWI02H0fMWI000T
0=WIf@030000003IfMT0fMWI01T0fMWI0P00000S0=WIf@030000003IfMT0fMWI00d0fMWI10000004
0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0M
0=WIf@030000003IfMT0fMWI00<0fMWI0P0000060=WIf@030000003IfMT0fMWI0100fMWI00<00000
0=WIf@000000=03IfMT002@0fMWI00<000000=WIf@3IfMT06`3IfMT200000200fMWI00<000000=WI
f@3IfMT02P3IfMT4000000L0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0M0=WI
f@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@070=WI
f@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT0<P3IfMT002<0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0K0=WIf@8000002@3IfMT4000000X0fMWI00<000000=WIf@3I
fMT02P3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WIf@3I
fMT0fMWI0P00000;0=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT0<@3IfMT002<0
fMWI00<000000=WIf@3IfMT07`3IfMT2000001X0fMWI00<000000=WIf@3IfMT01@3IfMT4000000h0
fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@0K0=WIf@030000003IfMT0fMWI01h0
fMWI00@000000=WIf@00000000003P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI
0340fMWI000S0=WIf@030000003IfMT0fMWI0240fMWI0P00000G0=WIf@030000003IfMT0fMWI0080
fMWI1000000A0=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT06`3IfMT00`000000
fMWI0=WIf@0N0=WIf@8000004@3IfMT200000100fMWI00<000000=WIf@3IfMT0<@3IfMT002<0fMWI
00<000000=WIf@3IfMT08`3IfMT2000001@0fMWI00<000000=WIf@3IfMT00`00000D0=WIf@030000
003IfMT0fMWI00`0fMWI00<000000=WIf@3IfMT06P3IfMT00`000000fMWI0=WIf@0N0=WIf@800000
503IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI0340fMWI000R0=WIf@030000003I
fMT0fMWI02H0fMWI00<000000=WIf@3IfMT0403IfMT010000000fMWI00000000000F0=WIf@030000
003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0M0=WIf@<00000
5P3IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI0300fMWI000R0=WIf@030000003I
fMT0fMWI02L0fMWI0P00000?0=WIf@<000005`3IfMT00`000000fMWI0=WIf@0>0=WIf@030000003I
fMT0fMWI01T0fMWI00<000000=WIf@3IfMT06`3IfMT200000080fMWI00<000000=WIf@3IfMT05@3I
fMT00`000000fMWI0=WIf@0;0=WIf@800000<P3IfMT00280fMWI00<000000=WIf@3IfMT0:@3IfMT2
000000/0fMWI0P00000J0=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3IfMT0603IfMT0
0`000000fMWI0=WIf@0K0=WIf@050000003IfMT0fMWI0=WIf@0000006@3IfMT00`000000fMWI0=WI
f@0;0=WIf@030000003IfMT0fMWI0300fMWI000Q0=WIf@030000003IfMT0fMWI02`0fMWI0P000006
0=WIf@<000006`3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI01L0fMWI00<00000
0=WIf@3IfMT06P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0603IfMT00`000000fMWI0=WIf@0;
0=WIf@030000003IfMT0fMWI02l0fMWI000Q0=WIf@030000003IfMT0fMWI02h0fMWI00<000000=WI
f@3IfMT00`0000000`3IfMT000000=WIf@0J0=WIf@030000003IfMT0fMWI0100fMWI00<000000=WI
f@3IfMT05`3IfMT00`000000fMWI0=WIf@0H0=WIf@8000001@3IfMT00`000000fMWI0=WIf@0I0=WI
f@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT0;`3IfMT00240fMWI00<000000=WIf@3I
fMT0;`3IfMT2000000<0fMWI00<000000=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0A0=WIf@03
0000003IfMT0fMWI01H0fMWI00<000000=WIf@3IfMT05`3IfMT2000000L0fMWI00<000000=WIf@3I
fMT06@3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI02l0fMWI000Q0=WIf@030000
003IfMT0fMWI02`0fMWI0`0000020=WIf@<000006`3IfMT00`000000fMWI0=WIf@0B0=WIf@030000
003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT05`3IfMT00`000000fMWI0=WIf@060=WIf@030000
003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WIf@0_0=WIf@00803I
fMT00`000000fMWI0=WIf@0[0=WIf@8000001P3IfMT2000001X0fMWI00<000000=WIf@3IfMT04`3I
fMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI01D0fMWI0P0000090=WIf@030000003I
fMT0fMWI01/0fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WIf@0^0=WIf@00803IfMT0
0`000000fMWI0=WIf@0X0=WIf@<000001`3IfMT00`000000fMWI0=WIf@02000001P0fMWI00<00000
0=WIf@3IfMT04`3IfMT00`000000fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI01@0fMWI0P00000:
0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WIf@0^
0=WIf@00803IfMT00`000000fMWI0=WIf@0V0=WIf@8000002@3IfMT00`000000fMWI0=WIf@030=WI
f@8000005@3IfMT00`000000fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI01<0fMWI00<000000=WI
f@3IfMT0503IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WI
f@3IfMT02P3IfMT200000300fMWI000O0=WIf@030000003IfMT0fMWI02@0fMWI0`00000:0=WIf@03
0000003IfMT0fMWI00H0fMWI0P00000B0=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3I
fMT04`3IfMT00`000000fMWI0=WIf@0B0=WIf@800000303IfMT00`000000fMWI0=WIf@0M0=WIf@03
0000003IfMT0fMWI00`0fMWI00<000000=WIf@3IfMT0;@3IfMT001l0fMWI00<000000=WIf@3IfMT0
8P3IfMT2000000`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI01H0fMWI00<000000=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@0A0=WIf@800000
3P3IfMT00`000000fMWI0=WIf@0M0=WIf@030000003IfMT0fMWI00`0fMWI00<000000=WIf@3IfMT0
;@3IfMT001l0fMWI00<000000=WIf@3IfMT0803IfMT2000000d0fMWI00<000000=WIf@3IfMT02`3I
fMT2000000d0fMWI00<000000=WIf@3IfMT05`3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003I
fMT0fMWI0100fMWI0P00000?0=WIf@030000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT0303I
fMT00`000000fMWI0=WIf@0]0=WIf@007`3IfMT00`000000fMWI0=WIf@0N0=WIf@8000003@3IfMT2
00000100fMWI0P00000;0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3IfMT0403IfMT0
0`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT07P3IfMT0
0`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI02d0fMWI000N0=WIf@030000003IfMT0fMWI
01d0fMWI0P00000>0=WIf@030000003IfMT0fMWI0180fMWI0P0000080=WIf@030000003IfMT0fMWI
01P0fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@0>0=WIf@8000004@3IfMT00`00
0000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT0;03IfMT001h0
fMWI00<000000=WIf@3IfMT06`3IfMT2000000l0fMWI00<000000=WIf@3IfMT05@3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT03`3IfMT00`000000
fMWI0=WIf@0=0=WIf@8000004`3IfMT00`000000fMWI0=WIf@0P0=WIf@030000003IfMT0fMWI00`0
fMWI00<000000=WIf@3IfMT0;03IfMT001h0fMWI00<000000=WIf@3IfMT06@3IfMT200000100fMWI
00<000000=WIf@3IfMT05`3IfMT2000000<0fMWI00<000000=WIf@3IfMT06P3IfMT00`000000fMWI
0=WIf@0>0=WIf@030000003IfMT0fMWI00H0fMWI7`00000Q0=WIf@030000003IfMT0fMWI00`0fMWI
00<000000=WIf@3IfMT0;03IfMT001d0fMWI00<000000=WIf@3IfMT0603IfMT200000140fMWI00<0
00000=WIf@3IfMT06P3IfMT2000000030=WIf@000000fMWI01/0fMWI00<000000=WIf@3IfMT00P3I
fMTE000000D0fMWI00<000000=WIf@3IfMT0503IfMT00`000000fMWI0=WIf@0A00000100fMWI00<0
00000=WIf@3IfMT0303IfMT2000002d0fMWI000M0=WIf@030000003IfMT0fMWI01H0fMWI0P00000B
0=WIf@030000003IfMT0fMWI01d0fMWI0P00000H0=WIf@T000002`3IfMT00`000000fMWI0=WIf@0:
0=WIf@8000005P3IfMT00`000000fMWI0=WIf@0B0=WIf@D000002`3IfMT00`000000fMWI0=WIf@0=
0=WIf@030000003IfMT0fMWI02/0fMWI000M0=WIf@030000003IfMT0fMWI01@0fMWI0P00000C0=WI
f@030000003IfMT0fMWI01d0fMWI00@000000=WIf@3IfMT000003`3IfMT8000000@0fMWI00<00000
0=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@090=WIf@800000603IfMT00`000000fMWI0=WIf@0G
0=WIf@H000001@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI02/0fMWI000L0=WI
f@030000003IfMT0fMWI01<0fMWI0P00000E0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WI
f@3IfMT00P3IfMT2000000@0fMWI2@00000<0=WIf@030000003IfMT0fMWI00`0fMWI00<000000=WI
f@3IfMT0203IfMT00`000000fMWI0=WIf@0G0=WIf@030000003IfMT0fMWI01h0fMWI1@00000A0=WI
f@030000003IfMT0fMWI02X0fMWI000L0=WIf@030000003IfMT0fMWI0180fMWI00<000000=WIf@3I
fMT0503IfMT00`000000fMWI0=WIf@0M0=WIf@030000003IfMT0000000P000005@3IfMT00`000000
fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00L0fMWI0P00000J0=WIf@030000003IfMT0fMWI0280
fMWI1000000>0=WIf@030000003IfMT0fMWI02X0fMWI000L0=WIf@030000003IfMT0fMWI0140fMWI
00<000000=WIf@3IfMT0503IfMT00`000000fMWI0=WIf@0H0=WIf@P000001`3IfMT2000001D0fMWI
00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@060=WIf@8000006`3IfMT00`000000fMWI
0=WIf@0R0=WIf@030000003IfMT0fMWI0080fMWI0P00000<0=WIf@030000003IfMT0fMWI01P0fMWI
0P0000000`3IfMT00000000000030=WIf@800000203IfMT001`0fMWI00<000000=WIf@3IfMT0403I
fMT00`000000fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI0140fMWI200000040=WIf@030000003I
fMT0fMWI00X0fMWI00<000000=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003I
fMT0fMWI00@0fMWI0P00000M0=WIf@030000003IfMT0fMWI0280fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@0000000`3I
fMT010000000fMWI0=WIf@0000070=WIf@006`3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003I
fMT0fMWI01D0fMWI00<000000=WIf@3IfMT02@3IfMT8000000/0fMWI00<000000=WIf@3IfMT0303I
fMT200000180fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI01`0fMWI00<000000=WIf@3IfMT08P3IfMT00`000000fMWI0=WIf@060=WIf@8000002P3I
fMT00`000000fMWI0=WIf@0I0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT01@3I
fMT001/0fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0
fMWI0080fMWI2000000C0=WIf@030000003IfMT0fMWI00h0fMWI0P00000@0=WIf@030000003IfMT0
fMWI00P0fMWI00<000000=WIf@3IfMT00`3IfMT2000001l0fMWI00<000000=WIf@3IfMT08P3IfMT0
0`000000fMWI0=WIf@080=WIf@800000203IfMT00`000000fMWI0=WIf@0H0=WIf@030000003IfMT0
000000@0fMWI0P0000080=WIf@006`3IfMT00`000000fMWI0=WIf@0=0=WIf@8000005@3IfMT80000
01X0fMWI00<000000=WIf@3IfMT04@3IfMT2000000h0fMWI00<000000=WIf@3IfMT0203IfMT01000
0000fMWI0=WIf@3IfMT200000200fMWI00<000000=WIf@3IfMT08`3IfMT00`000000fMWI0=WIf@0:
0=WIf@030000003IfMT0fMWI00@0fMWI0P00000I0=WIf@80000000<0fMWI0000000000001@3IfMT0
0`000000fMWI0=WIf@050=WIf@006P3IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI
00d0fMWI200000020=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT0503IfMT00`00
0000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT00P00000Q0=WI
f@030000003IfMT0fMWI02<0fMWI00<000000=WIf@3IfMT0303IfMT2000000H0fMWI00<000000=WI
f@3IfMT07@3IfMT010000000fMWI0=WIf@0000070=WIf@006P3IfMT00`000000fMWI0=WIf@0<0=WI
f@030000003IfMT0fMWI00L0fMWI1`0000090=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WI
f@3IfMT05@3IfMT2000000/0fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@00000S
0=WIf@030000003IfMT0fMWI02<0fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000080=WIf@006P3IfMT00`000000fMWI0=WIf@0;0=WI
f@030000003IfMT0fMWI0080fMWI1P00000?0=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WI
f@3IfMT0603IfMT2000000T0fMWI00<000000=WIf@3IfMT01P3IfMT3000002<0fMWI00<000000=WI
f@3IfMT08`3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT01@3IfMT200000240fMWI000J0=WIf@030000003IfMT0fMWI00X0fMWI1P00000D0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT06`3IfMT2000000L0fMWI00<000000=WIf@3I
fMT01@3IfMT2000002@0fMWI00<000000=WIf@3IfMT0903IfMT00`000000fMWI0=WIf@0?0=WIf@03
0000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT010000000fMWI0=WIf@00000P0=WI
f@006@3IfMT00`000000fMWI0=WIf@050=WIf@H000006P3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI02<0fMWI00<000000=WIf@3IfMT09@3IfMT00`000000fMWI0=WIf@0?0=WIf@03
0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@00000P0=WI
f@006@3IfMT00`000000fMWI0=WIf@020=WIf@<00000103IfMT00`000000fMWI0=WIf@0H0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT07`3IfMT2000000@0fMWI00<000000=WIf@3I
fMT00P3IfMT3000002D0fMWI00<000000=WIf@3IfMT0903IfMT00`000000fMWI0=WIf@0@0=WIf@03
0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@00000P0=WI
f@006@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3I
fMT07@3IfMT00`000000fMWI0=WIf@0R0=WIf@8000000P3IfMT00`000000fMWI0=WIf@0200000003
0=WIf@000000fMWI02@0fMWI00<000000=WIf@3IfMT09@3IfMT00`000000fMWI0=WIf@0@0=WIf@03
0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@00000P0=WI
f@00603IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3I
fMT0703IfMT00`000000fMWI0=WIf@0U0=WIf@D000000P3IfMT00`000000fMWI0=WIf@0S0=WIf@03
0000003IfMT0fMWI02D0fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@060=WIf@03
0000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000803IfMT001P0fMWI00<000000=WIf@3I
fMT02@3IfMT00`000000fMWI0=WIf@0G0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3I
fMT0:03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI02<0fMWI00<000000=WIf@3I
fMT09@3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00D0fMWI0P0000050=WIf@80
00008@3IfMT001P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0F0=WIf@030000
003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT09P3IfMT5000000030=WIf@000000fMWI02@0fMWI
00<000000=WIf@3IfMT09@3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00@0fMWI
00<000000=WIf@000000:03IfMT001P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI
f@0E0=WIf@030000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT09@3IfMT200000080fMWI00<0
00000=WIf@3IfMT00P00000T0=WIf@030000003IfMT0fMWI02H0fMWI00<000000=WIf@3IfMT04@3I
fMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI02H0fMWI000G0=WIf@030000003IfMT0
fMWI00X0fMWI00<000000=WIf@3IfMT05@3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0
fMWI02@0fMWI0P0000040=WIf@050000003IfMT0fMWI0000003IfMT00P00000R0=WIf@030000003I
fMT0fMWI02D0fMWI00<000000=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI02D0fMWI000G0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT05@3IfMT0
0`000000fMWI0=WIf@0L0=WIf@030000003IfMT0fMWI02@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI000000040=WIf@030000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT09@3IfMT0
0`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT09@3IfMT0
01L0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI
01`0fMWI00<000000=WIf@3IfMT08P3IfMT2000000L0fMWI00<000000=WIf@0000001@3IfMT20000
01d0fMWI00<000000=WIf@3IfMT09P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI
00T0fMWI00<000000=WIf@3IfMT09@3IfMT001H0fMWI00<000000=WIf@3IfMT02P3IfMT00`000000
fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT08@3IfMT2000000T0
fMWI0P0000080=WIf@8000006P3IfMT00`000000fMWI0=WIf@0V0=WIf@030000003IfMT0fMWI0140
fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WIf@0T0=WIf@005P3IfMT00`000000fMWI
0=WIf@0;0=WIf@800000503IfMT00`000000fMWI0=WIf@0K0=WIf@030000003IfMT0fMWI0200fMWI
0P00000;0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT05`3IfMT00`000000fMWI
0=WIf@0U0=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI
0=WIf@0T0=WIf@005P3IfMT00`000000fMWI0=WIf@0=0=WIf@8000004P3IfMT00`000000fMWI0=WI
f@0K0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WI
f@0:0=WIf@8000005P3IfMT00`000000fMWI0=WIf@0U0=WIf@030000003IfMT0fMWI0140fMWI00<0
00000=WIf@3IfMT03@3IfMT00`000000fMWI0=WIf@0T0=WIf@005P3IfMT00`000000fMWI0=WIf@0?
0=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3IfMT06`3IfMT00`000000fMWI0=WIf@0N
0=WIf@8000003@3IfMT2000000h0fMWI0P00000C0=WIf@030000003IfMT0fMWI02D0fMWI00<00000
0=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@0=0=WIf@8000009@3IfMT001D0fMWI00<000000=WI
f@3IfMT04@3IfMT2000000h0fMWI00<000000=WIf@3IfMT06`3IfMT00`000000fMWI0=WIf@0L0=WI
f@8000003P3IfMT00`000000fMWI0000000@0=WIf@8000004@3IfMT00`000000fMWI0=WIf@0U0=WI
f@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT03P3IfMT2000002D0fMWI000E0=WIf@03
0000003IfMT0fMWI01<0fMWI0P00000;0=WIf@030000003IfMT0fMWI01/0fMWI00<000000=WIf@3I
fMT06`3IfMT200000100fMWI00<000000=WIf@0000004P3IfMT00`000000fMWI0=WIf@0=0=WIf@03
0000003IfMT0fMWI02D0fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@0@0=WIf@03
0000003IfMT0fMWI02<0fMWI000E0=WIf@030000003IfMT0fMWI01D0fMWI0`0000080=WIf@030000
003IfMT0fMWI01/0fMWI00<000000=WIf@3IfMT06P3IfMT00`000000fMWI0=WIf@0?0=WIf@040000
003IfMT0fMWI000001<0fMWI0P00000<0=WIf@030000003IfMT0fMWI02D0fMWI00<000000=WIf@3I
fMT04@3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI02<0fMWI000D0=WIf@030000
003IfMT0fMWI01T0fMWI1@0000030=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT0
6@3IfMT200000140fMWI00D000000=WIf@3IfMT0fMWI0000000E0=WIf@8000002P3IfMT00`000000
fMWI0=WIf@0T0=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT04`3IfMT00`000000
fMWI0=WIf@0R0=WIf@00503IfMT00`000000fMWI0=WIf@0N0=WIf@D000006`3IfMT00`000000fMWI
0=WIf@0G0=WIf@8000004`3IfMT01@000000fMWI0=WIf@3IfMT0000001L0fMWI0P0000070=WIf@03
0000003IfMT0fMWI02@0fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@0D0=WIf@03
0000003IfMT0fMWI0280fMWI000D0=WIf@030000003IfMT0fMWI0200fMWI00<000000=WIf@3IfMT0
1@00000E0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3IfMT04P3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI
0=WIf@0U0=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT05@3IfMT00`000000fMWI
0=WIf@0R0=WIf@00503IfMT00`000000fMWI0=WIf@0P0=WIf@030000003IfMT0fMWI00D0fMWI0`00
000A0=WIf@030000003IfMT0fMWI01H0fMWI0P00000D0=WIf@030000003IfMT0fMWI00<0fMWI00<0
00000=WIf@3IfMT0603IfMT200000080fMWI00<000000=WIf@3IfMT09@3IfMT00`000000fMWI0=WI
f@0?0=WIf@800000603IfMT00`000000fMWI0=WIf@0R0=WIf@004`3IfMT00`000000fMWI0=WIf@0P
0=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT0503IfMT2000001H0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0J0=WIf@<000009P3IfMT00`000000fMWI0=WIf@0>
0=WIf@8000006`3IfMT00`000000fMWI0=WIf@0Q0=WIf@004`3IfMT00`000000fMWI0=WIf@0P0=WI
f@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT04`3IfMT2000001L0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@0K0=WIf@8000009@3IfMT00`000000fMWI0=WIf@0>0=WI
f@030000003IfMT0fMWI01/0fMWI00<000000=WIf@3IfMT08@3IfMT001<0fMWI00<000000=WIf@3I
fMT07`3IfMT00`000000fMWI0=WIf@0J0=WIf@030000003IfMT0fMWI0180fMWI00<000000=WIf@3I
fMT05P3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3I
fMT00P00000R0=WIf@030000003IfMT0fMWI00d0fMWI0P00000N0=WIf@8000008P3IfMT00180fMWI
00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0I0=WIf@030000003IfMT0fMWI0140fMWI
0P00000I0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT06@3IfMT00`000000fMWI
0=WIf@030=WIf@800000803IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI01h0fMWI
0P00000R0=WIf@004P3IfMT00`000000fMWI0=WIf@0P0=WIf@030000003IfMT0fMWI01T0fMWI00<0
00000=WIf@3IfMT03`3IfMT2000001X0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WI
f@0I0=WIf@030000003IfMT0fMWI00D0fMWI0P00000M0=WIf@030000003IfMT0fMWI00/0fMWI0P00
000R0=WIf@030000003IfMT0fMWI0200fMWI000B0=WIf@030000003IfMT0fMWI01l0fMWI00<00000
0=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@0>0=WIf@8000006`3IfMT00`000000fMWI0=WIf@07
0=WIf@030000003IfMT0fMWI01P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0I
0=WIf@030000003IfMT0fMWI00X0fMWI0P00000T0=WIf@030000003IfMT0fMWI0200fMWI000B0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT0603IfMT00`000000fMWI0=WIf@0>0=WI
f@030000003IfMT0fMWI01/0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@0G0=WI
f@030000003IfMT0fMWI00X0fMWI0P00000H0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0903IfMT00`000000fMWI0=WIf@0P0=WIf@004@3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI01P0fMWI00<000000=WIf@3IfMT0303IfMT2000001d0fMWI00<000000=WIf@3I
fMT0203IfMT00`000000fMWI0=WIf@0F0=WIf@030000003IfMT0fMWI00d0fMWI0P00000E0=WIf@03
0000003IfMT0fMWI00T0fMWI0P00000X0=WIf@030000003IfMT0fMWI01l0fMWI000A0=WIf@030000
003IfMT0fMWI0200fMWI00<000000=WIf@3IfMT05`3IfMT00`000000fMWI0=WIf@0;0=WIf@800000
7`3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT0
403IfMT200000140fMWI0P00000;0=WIf@030000003IfMT0fMWI02P0fMWI00<000000=WIf@3IfMT0
7`3IfMT00140fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0F0=WIf@030000003I
fMT0fMWI00T0fMWI0P00000P0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT05@3I
fMT00`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT02@3I
fMT2000002/0fMWI00<000000=WIf@3IfMT07`3IfMT00100fMWI00<000000=WIf@3IfMT08P3IfMT0
0`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT07`3IfMT0
0`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI01@0fMWI00<000000=WIf@3IfMT0503IfMT2
000000`0fMWI00<000000=WIf@3IfMT0203IfMT2000002h0fMWI00<000000=WIf@3IfMT07P3IfMT0
0100fMWI00<000000=WIf@3IfMT08P3IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI
00L0fMWI0P00000R0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT04`3IfMT00`00
0000fMWI0=WIf@0G0=WIf@8000002@3IfMT00`000000fMWI0=WIf@070=WIf@800000<03IfMT00`00
0000fMWI0=WIf@0N0=WIf@00403IfMT00`000000fMWI0=WIf@0R0=WIf@030000003IfMT0fMWI01@0
fMWI00<000000=WIf@3IfMT01P3IfMT2000002<0fMWI00<000000=WIf@3IfMT02`3IfMT00`000000
fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000
fMWI0=WIf@060=WIf@800000<P3IfMT00`000000fMWI0=WIf@0N0=WIf@00403IfMT00`000000fMWI
0=WIf@0R0=WIf@030000003IfMT0fMWI01@0fMWI00<000000=WIf@3IfMT0103IfMT2000002@0fMWI
00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI01`0fMWI
0P0000040=WIf@030000003IfMT0fMWI00@0fMWI0`00000d0=WIf@8000007`3IfMT000l0fMWI00<0
00000=WIf@3IfMT08`3IfMT00`000000fMWI0=WIf@0C0=WIf@030000003IfMT0fMWI00@0fMWI00<0
00000=WIf@3IfMT0903IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI0140fMWI00<0
00000=WIf@3IfMT07P3IfMT2000000030=WIf@000000fMWI00@0fMWI0P00000h0=WIf@030000003I
fMT0fMWI01d0fMWI000?0=WIf@030000003IfMT0fMWI02@0fMWI00<000000=WIf@3IfMT04P3IfMT0
0`000000fMWI0=WIf@020=WIf@8000009P3IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0
fMWI0100fMWI00<000000=WIf@3IfMT0803IfMT300000080fMWI0`00000j0=WIf@030000003IfMT0
fMWI01d0fMWI000?0=WIf@030000003IfMT0fMWI02@0fMWI00<000000=WIf@3IfMT04@3IfMT01000
0000fMWI0=WIf@3IfMT2000002L0fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@0?
0=WIf@030000003IfMT0fMWI0200fMWI00<000000=WIf@3IfMT00`00000m0=WIf@030000003IfMT0
fMWI01d0fMWI000>0=WIf@030000003IfMT0fMWI02D0fMWI00<000000=WIf@3IfMT04@3IfMT01000
0000fMWI00000000000Y0=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3IfMT03P3IfMT0
0`000000fMWI0=WIf@0P0=WIf@040000003IfMT0000000000080fMWI0P00000m0=WIf@030000003I
fMT0fMWI01`0fMWI000>0=WIf@030000003IfMT0fMWI02D0fMWI00<000000=WIf@3IfMT04@3IfMT2
000002X0fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0
fMWI0200fMWI0`0000060=WIf@800000>`3IfMT00`000000fMWI0=WIf@0L0=WIf@003P3IfMT00`00
0000fMWI0=WIf@0U0=WIf@030000003IfMT0fMWI0100fMWI0P00000Z0=WIf@030000003IfMT0fMWI
0100fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0O0=WIf@8000002`3IfMT20000
03T0fMWI00<000000=WIf@3IfMT0703IfMT000h0fMWI00<000000=WIf@3IfMT09P3IfMT00`000000
fMWI0=WIf@0=0=WIf@<00000:`3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00`0
fMWI00<000000=WIf@3IfMT0703IfMT4000000h0fMWI00<000000=WIf@3IfMT0=P3IfMT00`000000
fMWI0=WIf@0L0=WIf@003@3IfMT00`000000fMWI0=WIf@0W0=WIf@030000003IfMT0fMWI00/0fMWI
0P0000020=WIf@030000003IfMT0fMWI02P0fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI
0=WIf@0;0=WIf@030000003IfMT0fMWI01/0fMWI0P0000020=WIf@030000003IfMT0fMWI00h0fMWI
0P00000g0=WIf@030000003IfMT0fMWI01/0fMWI000=0=WIf@030000003IfMT0fMWI02L0fMWI00<0
00000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI02P0fMWI00<0
00000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI01T0fMWI0`00
00020=WIf@8000004`3IfMT2000003D0fMWI00<000000=WIf@3IfMT06`3IfMT000d0fMWI00<00000
0=WIf@3IfMT0:03IfMT00`000000fMWI0=WIf@070=WIf@800000103IfMT00`000000fMWI0=WIf@0X
0=WIf@030000003IfMT0fMWI0180fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0F
0=WIf@@00000103IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI0380fMWI00<00000
0=WIf@3IfMT06`3IfMT000`0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI0=WIf@040=WI
f@8000001P3IfMT00`000000fMWI0=WIf@0W0=WIf@030000003IfMT0fMWI01<0fMWI00<000000=WI
f@3IfMT0203IfMT00`000000fMWI0=WIf@0D0=WIf@<000001`3IfMT00`000000fMWI0=WIf@0G0=WI
f@800000<`3IfMT00`000000fMWI0=WIf@0J0=WIf@00303IfMT00`000000fMWI0=WIf@0[0=WIf@80
00000`3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI02L0fMWI00<000000=WIf@3I
fMT04`3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0100fMWI100000090=WIf@03
0000003IfMT0fMWI01X0fMWI0P00000`0=WIf@800000703IfMT000`0fMWI00<000000=WIf@3IfMT0
;@3IfMT3000000T0fMWI00<000000=WIf@3IfMT09P3IfMT00`000000fMWI0=WIf@0D0=WIf@030000
003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT03P3IfMT3000000/0fMWI0P00000O0=WIf@800000
;`3IfMT00`000000fMWI0=WIf@0J0=WIf@00303IfMT00`000000fMWI0=WIf@0/0=WIf@<000002@3I
fMT00`000000fMWI0=WIf@0V0=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@0<0=WIf@<000003@3IfMT00`000000fMWI0=WIf@0Q0=WIf@030000003I
fMT0fMWI02`0fMWI00<000000=WIf@3IfMT06P3IfMT000/0fMWI00<000000=WIf@3IfMT0:`3IfMT2
000000<0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@0V0=WIf@030000003IfMT0
fMWI01D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@090=WIf@@000003P3IfMT2
000002D0fMWI0P00000]0=WIf@030000003IfMT0fMWI01T0fMWI000;0=WIf@030000003IfMT0fMWI
02X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI
02D0fMWI00<000000=WIf@3IfMT05P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI
00L0fMWI0`00000@0=WIf@800000:@3IfMT2000002/0fMWI00<000000=WIf@3IfMT06@3IfMT000/0
fMWI00<000000=WIf@3IfMT0:03IfMT2000000P0fMWI0P0000040=WIf@030000003IfMT0fMWI02D0
fMWI00<000000=WIf@3IfMT05`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0
fMWI1000000B0=WIf@030000003IfMT0fMWI02/0fMWI0P00000Y0=WIf@030000003IfMT0fMWI01T0
fMWI000:0=WIf@030000003IfMT0fMWI02L0fMWI0P00000<0=WIf@050000003IfMT0fMWI0=WIf@00
00009`3IfMT00`000000fMWI0=WIf@0G0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3I
fMT0fMWI1000000D0=WIf@800000<03IfMT00`000000fMWI0=WIf@0W0=WIf@030000003IfMT0fMWI
00<0fMWI1000000A0=WIf@002P3IfMT00`000000fMWI0=WIf@0U0=WIf@8000003`3IfMT4000002H0
fMWI00<000000=WIf@3IfMT0603IfMT010000000fMWI0=WIf@3IfMT5000001L0fMWI00<000000=WI
f@3IfMT0<@3IfMT2000002L0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@0@0=WI
f@002P3IfMT00`000000fMWI0=WIf@0T0=WIf@030000003IfMT0fMWI0180fMWI1000000R0=WIf@03
0000003IfMT0fMWI01P0fMWI1P00000I0=WIf@800000=P3IfMT2000002D0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@0@0=WIf@002@3IfMT00`000000fMWI0=WIf@0S0=WIf@800000
503IfMT00`000000fMWI0=WIf@020=WIf@@000007P3IfMT00`000000fMWI0=WIf@0B0=WIf@H00000
00D0fMWI0000003IfMT0fMWI0000000H0=WIf@800000>P3IfMT00`000000fMWI0=WIf@0S0=WIf@03
0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0403IfMT000T0fMWI00<000000=WIf@3IfMT0
8@3IfMT2000001H0fMWI00<000000=WIf@3IfMT01P3IfMT4000001T0fMWI00<000000=WIf@3IfMT0
3P3IfMT5000000L0fMWI00<000000=WIf@000000603IfMT00`000000fMWI0=WIf@0k0=WIf@800000
8`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0100fMWI00090=WIf@030000003I
fMT0fMWI01l0fMWI0P00000H0=WIf@030000003IfMT0fMWI00X0fMWI1000000D0=WIf@030000003I
fMT0fMWI00X0fMWI1@00000<0=WIf@8000005`3IfMT200000400fMWI0P00000Q0=WIf@030000003I
fMT0fMWI0080fMWI0`00000B0=WIf@002@3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0
fMWI01P0fMWI00<000000=WIf@3IfMT03P3IfMTQ00000140fMWI00<000000=WIf@3IfMT05@3IfMT0
0`000000fMWI0=WIf@120=WIf@8000007P3IfMT2000000H0fMWI00<000000=WIf@3IfMT0403IfMT0
00P0fMWI00<000000=WIf@3IfMT07@3IfMT2000001`0fMWI00<000000=WIf@3IfMT0803IfMT00`00
0000fMWI0=WIf@0K0=WIf@8000005@3IfMT2000004L0fMWI00<000000=WIf@3IfMT07@3IfMT00`00
0000fMWI0=WIf@0F0=WIf@00203IfMT00`000000fMWI0=WIf@0K0=WIf@8000007P3IfMT00`000000
fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01/0fMWI00<000000=WIf@0000004`3IfMT2000004X0
fMWI0P00000M0=WIf@030000003IfMT0fMWI01H0fMWI00080=WIf@030000003IfMT0fMWI01T0fMWI
0P00000P0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT06P3IfMT010000000fMWI
0=WIf@00000B0=WIf@030000003IfMT0fMWI04`0fMWI0P00000K0=WIf@030000003IfMT0fMWI01H0
fMWI00070=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI
0=WIf@0N0=WIf@030000003IfMT0fMWI01X0fMWI00D000000=WIf@3IfMT0fMWI0000000@0=WIf@80
0000D@3IfMT2000001X0fMWI00<000000=WIf@3IfMT05@3IfMT000L0fMWI00<000000=WIf@3IfMT0
5`3IfMT2000002<0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0J0=WIf@030000
003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT2000005D0fMWI00<000000=WIf@3IfMT0
5`3IfMT00`000000fMWI0=WIf@0E0=WIf@001`3IfMT00`000000fMWI0=WIf@0E0=WIf@8000009@3I
fMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT00`3I
fMT00`000000fMWI0=WIf@0:0=WIf@800000F03IfMT2000001L0fMWI00<000000=WIf@3IfMT05@3I
fMT000L0fMWI00<000000=WIf@3IfMT04`3IfMT2000002P0fMWI00<000000=WIf@3IfMT06`3IfMT0
0`000000fMWI0=WIf@0I0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT2
000005`0fMWI0P00000E0=WIf@030000003IfMT0fMWI01D0fMWI00060=WIf@030000003IfMT0fMWI
01<0fMWI00<000000=WIf@3IfMT0:03IfMT00`000000fMWI0=WIf@0J0=WIf@030000003IfMT0fMWI
01X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@060=WIf@800000H03IfMT00`00
0000fMWI0=WIf@0C0=WIf@030000003IfMT0fMWI01@0fMWI00060=WIf@030000003IfMT0fMWI0140
fMWI0P00000[0=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT06P3IfMT00`000000
fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI0`00001S0=WIf@8000004`3IfMT00`000000
fMWI0=WIf@0D0=WIf@001P3IfMT00`000000fMWI0=WIf@0?0=WIf@800000;@3IfMT00`000000fMWI
0=WIf@0I0=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI
0=WIf@3IfMT2000006P0fMWI0P00000A0=WIf@030000003IfMT0fMWI01@0fMWI00050=WIf@030000
003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000fMWI0=WIf@0H0=WIf@030000
003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI00000000001/0=WIf@80
0000403IfMT00`000000fMWI0=WIf@0C0=WIf@001@3IfMT00`000000fMWI0=WIf@0=0=WIf@800000
<@3IfMT00`000000fMWI0=WIf@0F0=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT0
203IfMT200000700fMWI00<000000=WIf@3IfMT0303IfMT2000001D0fMWI00050=WIf@030000003I
fMT0fMWI00/0fMWI0P00000c0=WIf@030000003IfMT0fMWI01H0fMWI00<000000=WIf@3IfMT0603I
fMT00`000000fMWI0=WIf@060=WIf@@00000LP3IfMT2000000d0fMWI00<000000=WIf@3IfMT04`3I
fMT000D0fMWI00<000000=WIf@3IfMT02@3IfMT2000003D0fMWI00<000000=WIf@3IfMT05@3IfMT0
0`000000fMWI0=WIf@0H0=WIf@030000003IfMT0fMWI00D0fMWI0P0000030=WIf@030000003IfMT0
fMWI0780fMWI0P00000;0=WIf@030000003IfMT0fMWI01<0fMWI00040=WIf@030000003IfMT0fMWI
00T0fMWI00<000000=WIf@3IfMT0=P3IfMT2000001D0fMWI00<000000=WIf@3IfMT05`3IfMT00`00
0000fMWI0=WIf@040=WIf@8000001@3IfMT00`000000fMWI0=WIf@1d0=WIf@8000002P3IfMT00`00
0000fMWI0=WIf@0B0=WIf@00103IfMT00`000000fMWI0=WIf@070=WIf@800000>`3IfMT00`000000
fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3IfMT00`3IfMT2000000L0
fMWI00<000000=WIf@3IfMT0MP3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI0180
fMWI00040=WIf@030000003IfMT0fMWI00D0fMWI0P00000n0=WIf@030000003IfMT0fMWI0100fMWI
00<000000=WIf@3IfMT05@3IfMT200000080fMWI100000090=WIf@030000003IfMT0fMWI07L0fMWI
0P0000070=WIf@030000003IfMT0fMWI0180fMWI00030=WIf@030000003IfMT0fMWI00@0fMWI0P00
00110=WIf@8000003`3IfMT00`000000fMWI0=WIf@0E0=WIf@D000003@3IfMT00`000000fMWI0=WI
f@1i0=WIf@8000001P3IfMT00`000000fMWI0=WIf@0A0=WIf@000`3IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI04<0fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0B
0=WIf@@000004@3IfMT00`000000fMWI0=WIf@1k0=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT04@3IfMT000<0fMWI00@000000=WIf@3IfMT0fMWI0P0000170=WIf@030000003IfMT0
fMWI00X0fMWI00<000000=WIf@3IfMT03`3IfMT4000000030=WIf@000000fMWI0180fMWI00<00000
0=WIf@3IfMT0O03IfMT2000000<0fMWI00<000000=WIf@3IfMT04@3IfMT000<0fMWI00@000000=WI
f@0000000000BP3IfMT2000000X0fMWI00<000000=WIf@3IfMT02`3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@1n0=WIf@80000000<0fMWI0000003IfMT04P3IfMT0
0080fMWI0`00001>0=WIf@X000002P3IfMT4000000L0fMWI00<000000=WIf@3IfMT04`3IfMT00`00
0000fMWI0=WIf@200=WIf@<000004P3IfMT00080fMWI0`00001G0=WIf@/000002P3IfMT00`000000
fMWI0=WIf@0D0=WIf@030000003IfMT0fMWI0800fMWI0`00000B0=WIf@001@3IfMT400000580fMWI
00<000000=WIf@3IfMT04P3IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI07P0fMWI
00@000000=WIf@3IfMT0fMWI1000000E0=WIf@002@3IfMT4000004h0fMWI00<000000=WIf@3IfMT0
403IfMT2000001P0fMWI00<000000=WIf@3IfMT0N03IfMT4000001T0fMWI000=0=WIf@@00000B@3I
fMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI01P0fMWI00<000000=WIf@3IfMT0M03I
fMT4000000030=WIf@000000fMWI01X0fMWI000A0=WIf@@00000A@3IfMT00`000000fMWI0=WIf@0?
0=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT0KP3IfMT00`000000fMWI00000003
00000240fMWI000E0=WIf@@00000@03IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI
01X0fMWI00<000000=WIf@3IfMT0K03IfMT4000002D0fMWI000I0=WIf@@00000?03IfMT00`000000
fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI01/0fMWI00<000000=WIf@3IfMT0I@3IfMT00`000000
fMWI0=WIf@04000002T0fMWI000M0=WIf@@00000=`3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT0I03IfMT4000002d0fMWI000Q0=WIf@@00000<`3I
fMT00`000000fMWI0=WIf@0<0=WIf@8000007`3IfMT00`000000fMWI0=WIf@1P0=WIf@@0000000<0
fMWI0000003IfMT0;P3IfMT002D0fMWI1000000_0=WIf@030000003IfMT0fMWI00/0fMWI00<00000
0=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@1L0=WIf@@000005@3IfMT2000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0@0=WIf@00:@3IfMT4000002/0fMWI00<000000=WI
f@3IfMT02P3IfMT00`000000fMWI0=WIf@0P0=WIf@030000003IfMT0fMWI05<0fMWI00<000000=WI
f@3IfMT00P3IfMT5000001L0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@0@
0=WIf@00;@3IfMT4000002L0fMWI00<000000=WIf@3IfMT0203IfMT2000002<0fMWI00<000000=WI
f@3IfMT0D`3IfMT5000001`0fMWI00@000000=WIf@3IfMT000001`3IfMT500000140fMWI000a0=WI
f@@000008`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI02<0fMWI00<000000=WI
f@3IfMT0D03IfMT5000001l0fMWI00@000000=WIf@3IfMT000001`3IfMT010000000fMWI0=WIf@00
000B0=WIf@00=@3IfMT4000001h0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@0T
0=WIf@030000003IfMT0fMWI04/0fMWI1@00000T0=WIf@040000003IfMT0fMWI000000P0fMWI00<0
00000=WIf@0000004P3IfMT003T0fMWI1000000J0=WIf@030000003IfMT0fMWI00D0fMWI0P00000W
0=WIf@030000003IfMT0fMWI04P0fMWI1000000X0=WIf@040000003IfMT0fMWI000000T0fMWI0P00
000B0=WIf@00?@3IfMT4000001H0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0W
0=WIf@030000003IfMT0fMWI04<0fMWI1@00000]0=WIf@8000002`3IfMT00`000000fMWI0=WIf@0@
0=WIf@00@@3IfMT400000180fMWI1`00000Z0=WIf@030000003IfMT0fMWI0400fMWI1000001A0=WI
f@00A@3IfMT5000003h0fMWI00<000000=WIf@3IfMT0?03IfMT4000005D0fMWI001:0=WIf@@00000
>P3IfMT00`000000fMWI0=WIf@0d0=WIf@040000003IfMT0fMWI0=WIf@D00000F03IfMT004h0fMWI
1000000f0=WIf@030000003IfMT0fMWI03@0fMWI1000000G0=WIf@800000103IfMT00`000000fMWI
0=WIf@020=WIf@@00000=`3IfMT00580fMWI1000000b0=WIf@030000003IfMT0fMWI02d0fMWI00<0
00000=WIf@3IfMT01@00000I0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0
>03IfMT005H0fMWI1000000^0=WIf@030000003IfMT0fMWI02`0fMWI1000000N0=WIf@040000003I
fMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0=`3IfMT005X0fMWI1000000Z0=WIf@030000003I
fMT0fMWI02H0fMWI00<000000=WIf@0000000`00000R0=WIf@040000003IfMT0fMWI000000X0fMWI
00<000000=WIf@3IfMT0=P3IfMT005h0fMWI1000000V0=WIf@030000003IfMT0fMWI02@0fMWI1000
000V0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT0=@3IfMT00680fMWI1000
000R0=WIf@030000003IfMT0fMWI01T0fMWI00<000000=WIf@3IfMT0103IfMT4000002X0fMWI00@0
00000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000g0=WIf@00IP3IfMT4000001h0fMWI
00<000000=WIf@3IfMT06@3IfMT00`000000fMWI0=WIf@05000002h0fMWI0P00000:0=WIf@800000
>03IfMT006X0fMWI1000000J0=WIf@030000003IfMT0fMWI01P0fMWI1000000H0=WIf@800000G`3I
fMT006h0fMWI1000000F0=WIf@030000003IfMT0fMWI01<0fMWI1@00000K0=WIf@040000003IfMT0
fMWI000005h0fMWI001b0=WIf@@000004P3IfMT00`000000fMWI0=WIf@0=0=WIf@030000003IfMT0
fMWI00@000007`3IfMT010000000fMWI0=WIf@00001N0=WIf@00MP3IfMT4000000h0fMWI00<00000
0=WIf@3IfMT0303IfMT4000002<0fMWI00@000000=WIf@3IfMT00000GP3IfMT007X0fMWI1000000:
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT00P3IfMT5000002L0fMWI00@00000
0=WIf@3IfMT00000GP3IfMT007h0fMWI100000060=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@0000000`00000[0=WIf@040000003IfMT0fMWI000005h0fMWI00220=WIf@@000000P3IfMT0
0`000000fMWI0=WIf@0400000300fMWI0P00001O0=WIf@00QP3IfMT5000001H0fMWI0P0000040=WI
f@030000003IfMT0fMWI0080fMWI1000001`0=WIf@00X03IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI0740fMWI002P0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI
f@3IfMT0L03IfMT009X0fMWI100000020=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WI
f@3IfMT0K`3IfMT00:00fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@1^0=WI
f@00X03IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000700fMWI00290=WI
f@800000103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00P0fMWI0P00000:0=WI
f@800000L@3IfMT008P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@270=WI
f@00R03IfMT010000000fMWI0=WIf@0000070=WIf@D00000R03IfMT00880fMWI100000020=WIf@04
0000003IfMT0fMWI000000L0fMWI00@000000=WIf@3IfMT00000R@3IfMT008P0fMWI00@000000=WI
f@3IfMT00000203IfMT00`000000fMWI000000290=WIf@00R03IfMT010000000fMWI0=WIf@000009
0=WIf@800000R@3IfMT008T0fMWI0P00000;0=WIf@030000003IfMT0fMWI08L0fMWI002m0=WIf@80
000000<0fMWI0000000000000P3IfMT4000005P0fMWI002n0=WIf@030000003IfMT0000000<0fMWI
00<000000=WIf@3IfMT0F@3IfMT00;l0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI
f@1H0=WIf@00_P3IfMT00`000000fMWI000000050=WIf@030000003IfMT0fMWI05L0fMWI002m0=WI
f@80000000<0fMWI0000000000001@3IfMT00`000000fMWI0=WIf@1F0=WIf@00a03IfMT010000000
fMWI0=WIf@00001H0=WIf@00a@3IfMT2000005T0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {284, 0}} -> {0.0599755, -4.43509*^-6, \
0.00323508, 0.00323508}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part c", "Subsubsection",
  Evaluatable->False,
  Hyphenation->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(number = 16\ \ \  (*\ 
        for\ more\ frames\ make\ number\ larger\ *) ;\)\)], "Input",
  Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(Do[
        ListPlot[\[IndentingNewLine]\({{x1[t] - 2, 0}, {x2[t], 
                    0}, {x3[t] + 2, 0}} //. 
                allRules\)\[IndentingNewLine] //. {c1 \[Rule] 0, 
                c2 \[Rule] 1, c3 \[Rule] 0}\ \[IndentingNewLine] // 
            Evaluate, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
                0.05]}, \[IndentingNewLine]PlotRange \[Rule] {{\(-4\), 
                4}, {\(-1\), 1}}], \[IndentingNewLine]{t, 0, 
          2\ \[Pi] \((1 - 1/number)\), 2\ \[Pi]\ /number}];\)\)\)], "Input",
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.33839 .30902 Mdot
.5 .30902 Mdot
.66161 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0>0=WIf@H0
00002P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@050=WIf@H0
00005@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000003P3IfMT:000000H0fMWI0`00000I0=WIf@X000006P3IfMT3000000D0fMWI2P00000@0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000003`3IfMT:000000P0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT00`3IfMT:00000140fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00G`3IfMT<00000200fMWI3000000P0=WI
f@`00000G@3IfMT005l0fMWI3000000P0=WIf@`00000803IfMT<000005d0fMWI001O0=WIf@`00000
803IfMT<00000200fMWI3000001M0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00l0fMWI300000040=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI0080fMWI3000000A0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00H03IfMT:00000280fMWI2P00000R0=WIf@X00000GP3IfMT00600fMWI2P00000R0=WIf@X00000
8P3IfMT:000005h0fMWI001R0=WIf@H000009P3IfMT6000002H0fMWI1P00001P0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.33669 .30902 Mdot
.5 .30902 Mdot
.66331 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0>0=WIf@H0
00002P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@060=WIf@H0
0000503IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000003P3IfMT:000000H0fMWI0`00000I0=WIf@X000006P3IfMT3000000H0fMWI2P00000?0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000003`3IfMT:000000P0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT0103IfMT:00000100fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00G`3IfMT<00000200fMWI3000000Q0=WI
f@`00000G03IfMT005l0fMWI3000000P0=WIf@`000008@3IfMT<000005`0fMWI001O0=WIf@`00000
803IfMT<00000240fMWI3000001L0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT00`3IfMT<000000<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00l0fMWI300000040=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI00<0fMWI3000000@0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00H03IfMT:00000280fMWI2P00000S0=WIf@X00000G@3IfMT00600fMWI2P00000R0=WIf@X00000
8`3IfMT:000005d0fMWI001R0=WIf@H000009P3IfMT6000002L0fMWI1P00001O0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.33166 .30902 Mdot
.5 .30902 Mdot
.66834 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0=0=WIf@H0
00002`3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@070=WIf@H0
00004`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000003@3IfMT:000000L0fMWI0`00000I0=WIf@X000006P3IfMT3000000L0fMWI2P00000>0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000003P3IfMT:000000T0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT01@3IfMT:000000l0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00GP3IfMT<00000240fMWI3000000R0=WI
f@`00000F`3IfMT005h0fMWI3000000Q0=WIf@`000008P3IfMT<000005/0fMWI001N0=WIf@`00000
8@3IfMT<00000280fMWI3000001K0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00@00000
0=WIf@3IfMT0fMWI300000050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003I
fMT0fMWI00@0fMWI300000020=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0
fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0>0=WIf@`000001@3IfMT0
0`000000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@040=WIf@`000003`3IfMT0
0`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT0
05l0fMWI2P00000S0=WIf@X00000903IfMT:000005`0fMWI001O0=WIf@X000008`3IfMT:000002@0
fMWI2P00001L0=WIf@00H@3IfMT6000002L0fMWI1P00000X0=WIf@H00000GP3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@03
0000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m
0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<
0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@03
0=WIf@800000S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<00000
0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00
0000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0
fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI
0=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;
0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI
00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00
002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03I
fMT4000000D0fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0
fMWI00<000000=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00
002E0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.32349 .30902 Mdot
.5 .30902 Mdot
.67651 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0:0=WIf@H0
00003P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@090=WIf@H0
00004@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000002P3IfMT:000000X0fMWI0`00000I0=WIf@X000006P3IfMT3000000T0fMWI2P00000<0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000002`3IfMT:000000`0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT01`3IfMT:000000d0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00F`3IfMT<000002@0fMWI3000000T0=WI
f@`00000F@3IfMT005/0fMWI3000000T0=WIf@`00000903IfMT<000005T0fMWI001K0=WIf@`00000
903IfMT<000002@0fMWI3000001I0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI3@000000
0`3IfMT000000=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@000000300000060=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT02`3IfMT<000000P0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT01P3IfMT<000000d0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI001L0=WIf@X0
00009P3IfMT:000002H0fMWI2P00001J0=WIf@00G03IfMT:000002H0fMWI2P00000V0=WIf@X00000
FP3IfMT005h0fMWI1P00000Z0=WIf@H00000:P3IfMT6000005`0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.3125 .30902 Mdot
.5 .30902 Mdot
.6875 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@070=WIf@H0
00004@3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0<0=WIf@H0
00003P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000001`3IfMT:000000d0fMWI0`00000I0=WIf@X000006P3IfMT3000000`0fMWI2P0000090=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@800000203IfMT:000000l0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT02P3IfMT:000000X0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00F03IfMT<000002L0fMWI3000000W0=WI
f@`00000EP3IfMT005P0fMWI3000000W0=WIf@`000009`3IfMT<000005H0fMWI001H0=WIf@`00000
9`3IfMT<000002L0fMWI3000001F0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI30000004
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@`00000103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00P0fMWI3000000;0=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI00T0fMWI3000000:0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00F@3IfMT:000002T0fMWI2P00000Y0=WIf@X00000E`3IfMT005T0fMWI2P00000Y0=WIf@X00000
:@3IfMT:000005L0fMWI001K0=WIf@H00000;@3IfMT6000002d0fMWI1P00001I0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.29911 .30902 Mdot
.5 .30902 Mdot
.70089 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@040=WIf@H0
0000503IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0@0=WIf@H0
00002P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT00000103IfMT:00000100fMWI0`00000I0=WIf@X000006P3IfMT300000100fMWI2P0000050=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000001@3IfMT:00000180fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT03P3IfMT:000000H0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00E@3IfMT<000002X0fMWI3000000[0=WI
f@`00000DP3IfMT005D0fMWI3000000Z0=WIf@`00000:`3IfMT<00000580fMWI001E0=WIf@`00000
:P3IfMT<000002/0fMWI3000001B0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0000000`000001P3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0000000<000000D0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT<000000h0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT03@3IfMT<000000H0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI001F0=WIf@X0
0000;03IfMT:000002d0fMWI2P00001C0=WIf@00EP3IfMT:000002`0fMWI2P00000]0=WIf@X00000
D`3IfMT005P0fMWI1P00000`0=WIf@H00000<@3IfMT6000005D0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.28382 .30902 Mdot
.5 .30902 Mdot
.71618 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@06000001P0
fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0503IfMT6000000H0
fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0
fMWI000;0=WIf@8000007`3IfMT010000000fMWI0=WIf@00000N0=WIf@030000003IfMT0fMWI00/0
0000503IfMT3000001T0fMWI2P00000J0=WIf@<00000503IfMT:000000050=WIf@000000fMWI0=WI
f@0000007P3IfMT010000000fMWI0=WIf@00000O0=WIf@8000001`3IfMT000`0fMWI00<000000=WI
f@3IfMT07P3IfMT200000200fMWI0P0000000`3IfMT0000000000008000001H0fMWI00<000000=WI
f@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT04P3IfMT:00000080fMWI0P00000P0=WI
f@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00D@3IfMT<000002h0fMWI3000000_0=WIf@`0
0000CP3IfMT00540fMWI3000000^0=WIf@`00000;`3IfMT<000004h0fMWI001A0=WIf@`00000;P3I
fMT<000002l0fMWI3000001>0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT010000000fMWI0=WIf@3IfMT<000000@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@`000000P3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI
01l0fMWI00<000000=WIf@3IfMT07`3IfMT010000000fMWI0=WIf@3IfMT<00000180fMWI00<00000
0=WIf@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT04@3IfMT<00000080fMWI00<00000
0=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI001B0=WI
f@X00000<03IfMT:00000340fMWI2P00001?0=WIf@00DP3IfMT:00000300fMWI2P00000a0=WIf@X0
0000C`3IfMT005@0fMWI1P00000d0=WIf@H00000=@3IfMT600000540fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0
fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI
00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WI
f@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WI
f@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WI
f@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2
000000@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT0
07`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT2
000008d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0
fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0
fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@800000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI
f@3IfMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WI
f@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3
000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT0
10000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0
fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000
003IfMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI1000
00050=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@03
0000003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3I
fMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.26724 .30902 Mdot
.5 .30902 Mdot
.73276 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07@3IfMT6000001d0fMWI00<000000=WIf@3I
fMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0603IfMT600000080fMWI00<000000=WIf@3I
fMT07`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0fMWI000;0=WIf@800000
7`3IfMT010000000fMWI0=WIf@00000M0=WIf@X000006@3IfMT3000001T0fMWI2P00000J0=WIf@<0
0000603IfMT;000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@X000006`3IfMT00`000000fMWI0=WIf@0G0=WIf@X0
0000703IfMT00`000000fMWI0=WIf@0F0=WIf@X00000803IfMT200000240fMWI00<000000=WIf@3I
fMT01@3IfMT004`0fMWI3000000c0=WIf@`00000<`3IfMT<000004X0fMWI001<0=WIf@`00000<`3I
fMT<000003<0fMWI3000001:0=WIf@00C03IfMT<000003<0fMWI3000000c0=WIf@`00000BP3IfMT0
00T0fMWIo`00000A000000L0fMWI00090=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI300000020=WIf@03
0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00`000001@3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01h0fMWI
3000000G0=WIf@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI01D0fMWI
3000000P0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT004d0fMWI2P00
000e0=WIf@X00000=@3IfMT:000004/0fMWI001=0=WIf@X00000=@3IfMT:000003D0fMWI2P00001;
0=WIf@00C`3IfMT6000003T0fMWI1P00000i0=WIf@H00000C@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0
fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2
000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3IfMT0fMWI0`00
00060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000/0fMWI00@0
00000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WI
f@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT2000008d0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@800000
103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03I
fMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0
S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@800000
S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0
S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000
003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P00
00040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WI
f@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00
002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000
003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
0000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WI
f@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03IfMT4000000D0
fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI
0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0fMWI00<00000
0=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00002E0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.25 .30902 Mdot
.5 .30902 Mdot
.75 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT0603IfMT6000000030=WIf@000000fMWI01l0
fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT07@3IfMT6000001l0
fMWI00<000000=WIf@3IfMT0703IfMT00`000000fMWI000000070=WIf@002`3IfMT2000001l0fMWI
00@000000=WIf@3IfMT00000603IfMT:000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001d0
fMWI2P00000J0=WIf@040000003IfMT0fMWI000001l0fMWI0P0000070=WIf@00303IfMT00`000000
fMWI0=WIf@0N0=WIf@8000006@3IfMT:00000200fMWI00<000000=WIf@3IfMT05`3IfMT:000001`0
fMWI00<000000=WIf@3IfMT06`3IfMT:000001/0fMWI0P00000Q0=WIf@030000003IfMT0fMWI00D0
fMWI00170=WIf@`00000>03IfMT<000003P0fMWI300000150=WIf@00A`3IfMT<000003P0fMWI3000
000h0=WIf@`00000A@3IfMT004L0fMWI3000000h0=WIf@`00000>03IfMT<000004D0fMWI00090=WI
fOl000004@0000070=WIf@002@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0
fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0
fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI01l0fMWI
00<000000=WIf@3IfMT06@3IfMT<000001`0fMWI00<000000=WIf@3IfMT06@3IfMT<000001/0fMWI
00<000000=WIf@3IfMT06P3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI
0=WIf@050=WIf@00B03IfMT:000003X0fMWI2P00000j0=WIf@X00000AP3IfMT004P0fMWI2P00000j
0=WIf@X00000>P3IfMT:000004H0fMWI001:0=WIf@H00000?P3IfMT6000003h0fMWI1P0000180=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT4
00000080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT0
0`000000fMWI0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT0
10000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI
100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000
003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT0
0`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000
003IfMT0fMWI00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000
003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000
203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3I
fMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000
S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI
f@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00
00090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI
f@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<0
00000=WIf@3IfMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@0
00000=WIf@3IfMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003I
fMT0fMWI000000/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI
f@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@0
00001@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI00280=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00
002=0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WI
f@00R03IfMT3000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.23276 .30902 Mdot
.5 .30902 Mdot
.76724 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT0503IfMT6000000D0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0000000D000006P3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0
fMWI000;0=WIf@8000007`3IfMT010000000fMWI0=WIf@00000D0=WIf@/000000P3IfMT00`000000
fMWI0=WIf@0L0=WIf@<000006@3IfMT:000001X0fMWI0`00000O0=WIf@030000003IfMT0fMWI00X0
00005@3IfMT010000000fMWI0=WIf@00000O0=WIf@8000001`3IfMT000`0fMWI00<000000=WIf@3I
fMT07P3IfMT2000001D0fMWI2P0000000`3IfMT000000000000Q0=WIf@030000003IfMT0fMWI01L0
fMWI2P00000L0=WIf@030000003IfMT0fMWI01h0fMWI3000000F0=WIf@8000008@3IfMT00`000000
fMWI0=WIf@050=WIf@00@`3IfMT<000003`0fMWI3000000m0=WIf@`00000@03IfMT004<0fMWI3000
000l0=WIf@`00000?@3IfMT<00000400fMWI00130=WIf@`00000?03IfMT<000003d0fMWI30000010
0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@040000003IfMT0fMWI0=WIf@`00000103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT00`3IfMT<00000080fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WI
f@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3I
fMT05@3IfMT<00000200fMWI00<000000=WIf@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3I
fMT07`3IfMT<000001H0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WIf@00
A03IfMT:000003h0fMWI2P00000o0=WIf@X00000@@3IfMT004@0fMWI2P00000n0=WIf@X00000?`3I
fMT:00000440fMWI00160=WIf@H00000@P3IfMT6000004<0fMWI1P0000130=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000
S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI0`00
00060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00<0
00000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f
0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WI
f@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WI
f@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000
2`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WI
f@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0
fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0
fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`000000
fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0
fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0fMWI
0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@030000
003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3I
fMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0
0`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3IfMT0
fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000/0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000
fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI00280=WI
f@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00RP3I
fMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT30000
09D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.21618 .30902 Mdot
.5 .30902 Mdot
.78382 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT03`3IfMT6000000X0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00<0fMWI1P00000F0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000l0fMWI2P0000050=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT000000`3IfMT:00000140fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000@0=WIf@X000001P3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000@0fMWI2P00000B
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00?P3IfMT<00000440fMWI300000110=WI
f@`00000?03IfMT003h0fMWI300000110=WIf@`00000@@3IfMT<000003`0fMWI000n0=WIf@`00000
@@3IfMT<00000440fMWI3000000l0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@`000000`3IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI0=WIf@`000001@3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0
fMWI01l0fMWI00<000000=WIf@3IfMT0403IfMT<000000<0fMWI00<000000=WIf@3IfMT07`3IfMT0
0`000000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@0O0=WIf@040000003IfMT0
fMWI0=WIf@`000004P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000o
0=WIf@X00000@`3IfMT:000004<0fMWI2P00000m0=WIf@00?`3IfMT:000004<0fMWI2P0000130=WI
f@X00000?@3IfMT00440fMWI1P0000170=WIf@H00000A`3IfMT6000003l0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0
fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI
0=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;
0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI
00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00
002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3I
fMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03I
fMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003I
fMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3I
fMT2000008d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003I
fMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003I
fMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g
0=WIf@800000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`000006
0=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<00000
0=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WI
f@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3I
fMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3I
fMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003I
fMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@03
0000003IfMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000
S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI
100000050=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<0
00000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WI
f@030000003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000
U@3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.20089 .30902 Mdot
.5 .30902 Mdot
.79911 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT02`3IfMT6000000h0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00P0fMWI1P00000A0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000/0fMWI2P0000090=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT00000203IfMT:000000`0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000<0=WIf@X000002P3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000T0fMWI2P00000=
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00>P3IfMT<000004D0fMWI300000160=WI
f@`00000=`3IfMT003X0fMWI300000150=WIf@`00000AP3IfMT<000003L0fMWI000j0=WIf@`00000
A@3IfMT<000004H0fMWI3000000g0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0000000<000000H0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
000000`000001P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI00`0fMWI300000070=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@060=WI
f@`000003@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000k0=WIf@X0
0000A`3IfMT:000004P0fMWI2P00000h0=WIf@00>`3IfMT:000004L0fMWI2P0000180=WIf@X00000
>03IfMT003d0fMWI1P00001;0=WIf@H00000C03IfMT6000003X0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.1875 .30902 Mdot
.5 .30902 Mdot
.8125 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT01`3IfMT600000180fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00/0fMWI1P00000>0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000L0fMWI2P00000=0=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT000002`3IfMT:000000T0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000080=WIf@X000003P3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000`0fMWI2P00000:
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00=P3IfMT<000004T0fMWI300000190=WI
f@`00000=03IfMT003H0fMWI300000190=WIf@`00000B@3IfMT<000003@0fMWI000f0=WIf@`00000
B@3IfMT<000004T0fMWI3000000d0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@080=WIf@`000002`3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WI
f@3IfMT02@3IfMT<000000X0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00=`3IfMT:000004/0fMWI2P00001;0=WIf@X00000=@3IfMT003L0fMWI2P00001;0=WIf@X00000
B`3IfMT:000003D0fMWI000i0=WIf@H00000C`3IfMT6000004l0fMWI1P00000g0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.17651 .30902 Mdot
.5 .30902 Mdot
.82349 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT0103IfMT6000001D0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00h0fMWI1P00000;0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000@0fMWI2P00000@0=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT000003P3IfMT:000000H0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000050=WIf@X000004@3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000l0fMWI2P000007
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00<`3IfMT<000004`0fMWI3000001<0=WI
f@`00000<@3IfMT003<0fMWI3000001<0=WIf@`00000C03IfMT<00000340fMWI000c0=WIf@`00000
C03IfMT<000004`0fMWI3000000a0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@000000300000060=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI3@0000000`3IfMT000000=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI00D0fMWI3000000>0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0<0=WI
f@`000001`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000d0=WIf@X0
0000CP3IfMT:000004h0fMWI2P00000b0=WIf@00=03IfMT:000004h0fMWI2P00001>0=WIf@X00000
<P3IfMT003H0fMWI1P00001B0=WIf@H00000DP3IfMT6000003@0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.16834 .30902 Mdot
.5 .30902 Mdot
.83166 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT00P3IfMT6000001L0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI0100fMWI1P0000090=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI00000080fMWI2P00000B0=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT00000403IfMT:000000@0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000030=WIf@X000004`3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT200000140fMWI2P000005
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00<@3IfMT<000004h0fMWI3000001>0=WI
f@`00000;`3IfMT00340fMWI3000001>0=WIf@`00000CP3IfMT<000002l0fMWI000a0=WIf@`00000
CP3IfMT<000004h0fMWI3000000_0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI30000002
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0<000000D0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI
01l0fMWI00<000000=WIf@3IfMT00`3IfMT<00000100fMWI00<000000=WIf@3IfMT07`3IfMT00`00
0000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI
00h0fMWI300000050=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT00380
fMWI2P00001@0=WIf@X00000D03IfMT:00000300fMWI000b0=WIf@X00000D03IfMT:00000500fMWI
2P00000`0=WIf@00=03IfMT6000005@0fMWI1P00001D0=WIf@H00000<P3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000
003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3I
fMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0
0`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3IfMT0
fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000/0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000
fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m0=WI
f@800000103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WI
f@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WI
f@800000S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WI
f@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WI
f@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WI
f@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0
fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0
fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000
fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI
00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WI
f@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WI
f@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WI
f@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03IfMT4
000000D0fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT00`00
0000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0fMWI
00<000000=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00002E
0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.16331 .30902 Mdot
.5 .30902 Mdot
.83669 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00@000000=WIf@3IfMT0fMWI1P00000H0=WIf@030000003IfMT0fMWI
01h0fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0803IfMT00`00
0000fMWI0=WIf@0B0=WIf@H000001`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT00000
00L0fMWI000;0=WIf@8000007`3IfMT01@000000fMWI0=WIf@000000fMWI00X000004`3IfMT01000
0000fMWI0=WIf@00000N0=WIf@<000006@3IfMT:000001X0fMWI0`00000O0=WIf@040000003IfMT0
fMWI00000180fMWI2P0000020=WIf@040000003IfMT0fMWI000001l0fMWI0P0000070=WIf@00303I
fMT00`000000fMWI0=WIf@0N0=WIf@8000000P3IfMT:000001@0fMWI0P00000Q0=WIf@030000003I
fMT0fMWI01L0fMWI2P00000L0=WIf@030000003IfMT0fMWI01h0fMWI0P00000C0=WIf@X000000`3I
fMT200000240fMWI00<000000=WIf@3IfMT01@3IfMT00300fMWI3000001?0=WIf@`00000D03IfMT<
000002d0fMWI000`0=WIf@`00000C`3IfMT<00000500fMWI3000000]0=WIf@00<03IfMT<000004l0
fMWI3000001@0=WIf@`00000;@3IfMT000T0fMWIo`00000A000000L0fMWI00090=WIf@030000003I
fMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@`000000`3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT<000000<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0
fMWI01l0fMWI00<000000=WIf@3IfMT00P3IfMT<00000140fMWI00<000000=WIf@3IfMT07`3IfMT0
0`000000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0
fMWI0100fMWI300000030=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT0
0340fMWI2P00001A0=WIf@X00000DP3IfMT:000002h0fMWI000a0=WIf@X00000D@3IfMT:00000580
fMWI2P00000^0=WIf@00<`3IfMT6000005D0fMWI1P00001F0=WIf@H00000<03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@03
0000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m
0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<
0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@03
0=WIf@800000S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<00000
0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00
0000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0
fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI
0=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;
0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI
00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00
002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03I
fMT4000000D0fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0
fMWI00<000000=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00
002E0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.16161 .30902 Mdot
.5 .30902 Mdot
.83839 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT01P00000I0=WIf@030000003IfMT0fMWI01h0
fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0803IfMT00`000000
fMWI0=WIf@0B0=WIf@H000001`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0
fMWI000;0=WIf@8000007`3IfMT00`000000fMWI0=WIf@0;000001@0fMWI00@000000=WIf@3IfMT0
00007P3IfMT3000001T0fMWI2P00000J0=WIf@<000007`3IfMT010000000fMWI0=WIf@00000B0=WI
f@X000000P3IfMT010000000fMWI0=WIf@00000O0=WIf@8000001`3IfMT000`0fMWI00<000000=WI
f@3IfMT07P3IfMT2000000030=WIf@000000000000P000005@3IfMT200000240fMWI00<000000=WI
f@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000001<0fMWI2P0000030=WI
f@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00;`3IfMT<00000500fMWI3000001@0=WIf@`0
0000;@3IfMT002l0fMWI3000001@0=WIf@`00000D03IfMT<000002d0fMWI000_0=WIf@`00000D03I
fMT<00000500fMWI3000000]0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI0=WIf@`00000103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT<000000<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI
01l0fMWI00@000000=WIf@3IfMT0fMWI3000000B0=WIf@030000003IfMT0fMWI01l0fMWI00<00000
0=WIf@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0@
0=WIf@`000000`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000`0=WI
f@X00000DP3IfMT:00000580fMWI2P00000^0=WIf@00<03IfMT:00000580fMWI2P00001B0=WIf@X0
0000;P3IfMT00380fMWI1P00001F0=WIf@H00000EP3IfMT600000300fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0
fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI
00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WI
f@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WI
f@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WI
f@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2
000000@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT0
07`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT2
000008d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0
fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0
fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@800000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI
f@3IfMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WI
f@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3
000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT0
10000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0
fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000
003IfMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI1000
00050=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@03
0000003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3I
fMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.16331 .30902 Mdot
.5 .30902 Mdot
.83669 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00@000000=WIf@3IfMT0fMWI1P00000H0=WIf@030000003IfMT0fMWI
01h0fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0803IfMT00`00
0000fMWI0=WIf@0B0=WIf@H000001`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT00000
00L0fMWI000;0=WIf@8000007`3IfMT01@000000fMWI0=WIf@000000fMWI00X000004`3IfMT01000
0000fMWI0=WIf@00000N0=WIf@<000006@3IfMT:000001X0fMWI0`00000O0=WIf@040000003IfMT0
fMWI00000180fMWI2P0000020=WIf@040000003IfMT0fMWI000001l0fMWI0P0000070=WIf@00303I
fMT00`000000fMWI0=WIf@0N0=WIf@8000000P3IfMT:000001@0fMWI0P00000Q0=WIf@030000003I
fMT0fMWI01L0fMWI2P00000L0=WIf@030000003IfMT0fMWI01h0fMWI0P00000C0=WIf@X000000`3I
fMT200000240fMWI00<000000=WIf@3IfMT01@3IfMT00300fMWI3000001?0=WIf@`00000D03IfMT<
000002d0fMWI000`0=WIf@`00000C`3IfMT<00000500fMWI3000000]0=WIf@00<03IfMT<000004l0
fMWI3000001@0=WIf@`00000;@3IfMT000T0fMWIo`00000A000000L0fMWI00090=WIf@030000003I
fMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@`000000`3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT<000000<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0
fMWI01l0fMWI00<000000=WIf@3IfMT00P3IfMT<00000140fMWI00<000000=WIf@3IfMT07`3IfMT0
0`000000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0
fMWI0100fMWI300000030=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT0
0340fMWI2P00001A0=WIf@X00000DP3IfMT:000002h0fMWI000a0=WIf@X00000D@3IfMT:00000580
fMWI2P00000^0=WIf@00<`3IfMT6000005D0fMWI1P00001F0=WIf@H00000<03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@03
0000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m
0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<
0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@03
0=WIf@800000S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<00000
0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00
0000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0
fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI
0=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;
0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI
00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00
002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03I
fMT4000000D0fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0
fMWI00<000000=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00
002E0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.16834 .30902 Mdot
.5 .30902 Mdot
.83166 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT00P3IfMT6000001L0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI0100fMWI1P0000090=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI00000080fMWI2P00000B0=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT00000403IfMT:000000@0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000030=WIf@X000004`3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT200000140fMWI2P000005
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00<@3IfMT<000004h0fMWI3000001>0=WI
f@`00000;`3IfMT00340fMWI3000001>0=WIf@`00000CP3IfMT<000002l0fMWI000a0=WIf@`00000
CP3IfMT<000004h0fMWI3000000_0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI30000002
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0<000000D0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI
01l0fMWI00<000000=WIf@3IfMT00`3IfMT<00000100fMWI00<000000=WIf@3IfMT07`3IfMT00`00
0000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI
00h0fMWI300000050=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT00380
fMWI2P00001@0=WIf@X00000D03IfMT:00000300fMWI000b0=WIf@X00000D03IfMT:00000500fMWI
2P00000`0=WIf@00=03IfMT6000005@0fMWI1P00001D0=WIf@H00000<P3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000
003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3I
fMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0
0`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3IfMT0
fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000/0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000
fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m0=WI
f@800000103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WI
f@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WI
f@800000S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WI
f@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WI
f@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WI
f@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0
fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0
fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000
fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI
00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WI
f@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WI
f@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WI
f@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03IfMT4
000000D0fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT00`00
0000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0fMWI
00<000000=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00002E
0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.17651 .30902 Mdot
.5 .30902 Mdot
.82349 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT0103IfMT6000001D0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00h0fMWI1P00000;0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000@0fMWI2P00000@0=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT000003P3IfMT:000000H0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000050=WIf@X000004@3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000l0fMWI2P000007
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00<`3IfMT<000004`0fMWI3000001<0=WI
f@`00000<@3IfMT003<0fMWI3000001<0=WIf@`00000C03IfMT<00000340fMWI000c0=WIf@`00000
C03IfMT<000004`0fMWI3000000a0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@000000300000060=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI3@0000000`3IfMT000000=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI00D0fMWI3000000>0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0<0=WI
f@`000001`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000d0=WIf@X0
0000CP3IfMT:000004h0fMWI2P00000b0=WIf@00=03IfMT:000004h0fMWI2P00001>0=WIf@X00000
<P3IfMT003H0fMWI1P00001B0=WIf@H00000DP3IfMT6000003@0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.1875 .30902 Mdot
.5 .30902 Mdot
.8125 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT01`3IfMT600000180fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00/0fMWI1P00000>0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000L0fMWI2P00000=0=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT000002`3IfMT:000000T0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P0000080=WIf@X000003P3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000`0fMWI2P00000:
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00=P3IfMT<000004T0fMWI300000190=WI
f@`00000=03IfMT003H0fMWI300000190=WIf@`00000B@3IfMT<000003@0fMWI000f0=WIf@`00000
B@3IfMT<000004T0fMWI3000000d0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@080=WIf@`000002`3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WI
f@3IfMT02@3IfMT<000000X0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00=`3IfMT:000004/0fMWI2P00001;0=WIf@X00000=@3IfMT003L0fMWI2P00001;0=WIf@X00000
B`3IfMT:000003D0fMWI000i0=WIf@H00000C`3IfMT6000004l0fMWI1P00000g0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.20089 .30902 Mdot
.5 .30902 Mdot
.79911 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT02`3IfMT6000000h0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00P0fMWI1P00000A0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000/0fMWI2P0000090=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT00000203IfMT:000000`0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000<0=WIf@X000002P3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000T0fMWI2P00000=
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00>P3IfMT<000004D0fMWI300000160=WI
f@`00000=`3IfMT003X0fMWI300000150=WIf@`00000AP3IfMT<000003L0fMWI000j0=WIf@`00000
A@3IfMT<000004H0fMWI3000000g0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0000000<000000H0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0
000000`000001P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI00`0fMWI300000070=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@060=WI
f@`000003@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000k0=WIf@X0
0000A`3IfMT:000004P0fMWI2P00000h0=WIf@00>`3IfMT:000004L0fMWI2P0000180=WIf@X00000
>03IfMT003d0fMWI1P00001;0=WIf@H00000C03IfMT6000003X0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.21618 .30902 Mdot
.5 .30902 Mdot
.78382 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT03`3IfMT6000000X0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0fMWI00<0fMWI1P00000F0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000000l0fMWI2P0000050=WIf@04
0000003IfMT0fMWI000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001l0fMWI00@000000=WI
f@3IfMT000000`3IfMT:00000140fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000@0=WIf@X000001P3IfMT200000240fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT07P3IfMT2000000@0fMWI2P00000B
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00?P3IfMT<00000440fMWI300000110=WI
f@`00000?03IfMT003h0fMWI300000110=WIf@`00000@@3IfMT<000003`0fMWI000n0=WIf@`00000
@@3IfMT<00000440fMWI3000000l0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@`000000`3IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@040000003IfMT0fMWI0=WIf@`000001@3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0
fMWI01l0fMWI00<000000=WIf@3IfMT0403IfMT<000000<0fMWI00<000000=WIf@3IfMT07`3IfMT0
0`000000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@0O0=WIf@040000003IfMT0
fMWI0=WIf@`000004P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI000o
0=WIf@X00000@`3IfMT:000004<0fMWI2P00000m0=WIf@00?`3IfMT:000004<0fMWI2P0000130=WI
f@X00000?@3IfMT00440fMWI1P0000170=WIf@H00000A`3IfMT6000003l0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0
fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI
0=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;
0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI
00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00
002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3I
fMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03I
fMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003I
fMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3I
fMT2000008d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003I
fMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003I
fMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g
0=WIf@800000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`000006
0=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<00000
0=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WI
f@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3I
fMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3I
fMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003I
fMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@03
0000003IfMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000
S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI
100000050=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<0
00000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WI
f@030000003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000
U@3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.23276 .30902 Mdot
.5 .30902 Mdot
.76724 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT0503IfMT6000000D0fMWI00<000000=WIf@3I
fMT07P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0P0=WIf@03
0000003IfMT0000000D000006P3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0
fMWI000;0=WIf@8000007`3IfMT010000000fMWI0=WIf@00000D0=WIf@/000000P3IfMT00`000000
fMWI0=WIf@0L0=WIf@<000006@3IfMT:000001X0fMWI0`00000O0=WIf@030000003IfMT0fMWI00X0
00005@3IfMT010000000fMWI0=WIf@00000O0=WIf@8000001`3IfMT000`0fMWI00<000000=WIf@3I
fMT07P3IfMT2000001D0fMWI2P0000000`3IfMT000000000000Q0=WIf@030000003IfMT0fMWI01L0
fMWI2P00000L0=WIf@030000003IfMT0fMWI01h0fMWI3000000F0=WIf@8000008@3IfMT00`000000
fMWI0=WIf@050=WIf@00@`3IfMT<000003`0fMWI3000000m0=WIf@`00000@03IfMT004<0fMWI3000
000l0=WIf@`00000?@3IfMT<00000400fMWI00130=WIf@`00000?03IfMT<000003d0fMWI30000010
0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@040000003IfMT0fMWI0=WIf@`00000103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT00`3IfMT<00000080fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WI
f@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3I
fMT05@3IfMT<00000200fMWI00<000000=WIf@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3I
fMT07`3IfMT<000001H0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WIf@00
A03IfMT:000003h0fMWI2P00000o0=WIf@X00000@@3IfMT004@0fMWI2P00000n0=WIf@X00000?`3I
fMT:00000440fMWI00160=WIf@H00000@P3IfMT6000004<0fMWI1P0000130=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000
S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI0`00
00060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00<0
00000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f
0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WI
f@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WI
f@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000
2`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WI
f@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0
fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0
fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`000000
fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0
fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0fMWI
0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@030000
003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3I
fMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0
0`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3IfMT0
fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000/0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000
fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI00280=WI
f@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00RP3I
fMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT30000
09D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.25 .30902 Mdot
.5 .30902 Mdot
.75 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT0603IfMT6000000030=WIf@000000fMWI01l0
fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT07@3IfMT6000001l0
fMWI00<000000=WIf@3IfMT0703IfMT00`000000fMWI000000070=WIf@002`3IfMT2000001l0fMWI
00@000000=WIf@3IfMT00000603IfMT:000001h0fMWI0`00000I0=WIf@X000006P3IfMT3000001d0
fMWI2P00000J0=WIf@040000003IfMT0fMWI000001l0fMWI0P0000070=WIf@00303IfMT00`000000
fMWI0=WIf@0N0=WIf@8000006@3IfMT:00000200fMWI00<000000=WIf@3IfMT05`3IfMT:000001`0
fMWI00<000000=WIf@3IfMT06`3IfMT:000001/0fMWI0P00000Q0=WIf@030000003IfMT0fMWI00D0
fMWI00170=WIf@`00000>03IfMT<000003P0fMWI300000150=WIf@00A`3IfMT<000003P0fMWI3000
000h0=WIf@`00000A@3IfMT004L0fMWI3000000h0=WIf@`00000>03IfMT<000004D0fMWI00090=WI
fOl000004@0000070=WIf@002@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0
fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0
fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0
fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI01l0fMWI
00<000000=WIf@3IfMT06@3IfMT<000001`0fMWI00<000000=WIf@3IfMT06@3IfMT<000001/0fMWI
00<000000=WIf@3IfMT06P3IfMT<000001/0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI
0=WIf@050=WIf@00B03IfMT:000003X0fMWI2P00000j0=WIf@X00000AP3IfMT004P0fMWI2P00000j
0=WIf@X00000>P3IfMT:000004H0fMWI001:0=WIf@H00000?P3IfMT6000003h0fMWI1P0000180=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT4
00000080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT0
0`000000fMWI0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT0
10000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI
100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000
003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT0
0`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000
003IfMT0fMWI00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000
003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000
203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3I
fMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000
S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI
f@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00
00090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI
f@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<0
00000=WIf@3IfMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@0
00000=WIf@3IfMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003I
fMT0fMWI000000/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI
f@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@0
00001@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI00280=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00
002=0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WI
f@00R03IfMT3000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.26724 .30902 Mdot
.5 .30902 Mdot
.73276 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07@3IfMT6000001d0fMWI00<000000=WIf@3I
fMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0603IfMT600000080fMWI00<000000=WIf@3I
fMT07`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0fMWI000;0=WIf@800000
7`3IfMT010000000fMWI0=WIf@00000M0=WIf@X000006@3IfMT3000001T0fMWI2P00000J0=WIf@<0
0000603IfMT;000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@X000006`3IfMT00`000000fMWI0=WIf@0G0=WIf@X0
0000703IfMT00`000000fMWI0=WIf@0F0=WIf@X00000803IfMT200000240fMWI00<000000=WIf@3I
fMT01@3IfMT004`0fMWI3000000c0=WIf@`00000<`3IfMT<000004X0fMWI001<0=WIf@`00000<`3I
fMT<000003<0fMWI3000001:0=WIf@00C03IfMT<000003<0fMWI3000000c0=WIf@`00000BP3IfMT0
00T0fMWIo`00000A000000L0fMWI00090=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI300000020=WIf@03
0000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@03
0000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00`000001@3IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000
fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01h0fMWI
3000000G0=WIf@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI01D0fMWI
3000000P0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT004d0fMWI2P00
000e0=WIf@X00000=@3IfMT:000004/0fMWI001=0=WIf@X00000=@3IfMT:000003D0fMWI2P00001;
0=WIf@00C`3IfMT6000003T0fMWI1P00000i0=WIf@H00000C@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0
fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2
000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3IfMT0fMWI0`00
00060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000/0fMWI00@0
00000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WI
f@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT2000008d0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@800000
103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03I
fMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0
S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@800000
S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0
S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000
003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P00
00040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WI
f@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00
002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<00000
1P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000
003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
0000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WI
f@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03IfMT4000000D0
fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI
0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0fMWI00<00000
0=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00002E0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.28382 .30902 Mdot
.5 .30902 Mdot
.71618 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@06000001P0
fMWI00<000000=WIf@3IfMT06@3IfMT6000001h0fMWI00<000000=WIf@3IfMT0503IfMT6000000H0
fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0L0=WIf@030000003IfMT0000000L0
fMWI000;0=WIf@8000007`3IfMT010000000fMWI0=WIf@00000N0=WIf@030000003IfMT0fMWI00/0
0000503IfMT3000001T0fMWI2P00000J0=WIf@<00000503IfMT:000000050=WIf@000000fMWI0=WI
f@0000007P3IfMT010000000fMWI0=WIf@00000O0=WIf@8000001`3IfMT000`0fMWI00<000000=WI
f@3IfMT07P3IfMT200000200fMWI0P0000000`3IfMT0000000000008000001H0fMWI00<000000=WI
f@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT04P3IfMT:00000080fMWI0P00000P0=WI
f@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00D@3IfMT<000002h0fMWI3000000_0=WIf@`0
0000CP3IfMT00540fMWI3000000^0=WIf@`00000;`3IfMT<000004h0fMWI001A0=WIf@`00000;P3I
fMT<000002l0fMWI3000001>0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0103IfMT010000000fMWI0=WIf@3IfMT<000000@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@`000000P3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0fMWI
01l0fMWI00<000000=WIf@3IfMT07`3IfMT010000000fMWI0=WIf@3IfMT<00000180fMWI00<00000
0=WIf@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT04@3IfMT<00000080fMWI00<00000
0=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI001B0=WI
f@X00000<03IfMT:00000340fMWI2P00001?0=WIf@00DP3IfMT:00000300fMWI2P00000a0=WIf@X0
0000C`3IfMT005@0fMWI1P00000d0=WIf@H00000=@3IfMT600000540fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0
fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000
fMWI0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI
00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0
fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WI
f@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WI
f@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WI
f@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<0
00000=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2
000000@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT0
07`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT2
000008d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0
fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0
fMWI00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@800000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI
f@3IfMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WI
f@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3
000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT0
10000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0
fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000
003IfMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI1000
00050=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@03
0000003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3I
fMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.29911 .30902 Mdot
.5 .30902 Mdot
.70089 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@040=WIf@H0
0000503IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0@0=WIf@H0
00002P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT00000103IfMT:00000100fMWI0`00000I0=WIf@X000006P3IfMT300000100fMWI2P0000050=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000001@3IfMT:00000180fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT03P3IfMT:000000H0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00E@3IfMT<000002X0fMWI3000000[0=WI
f@`00000DP3IfMT005D0fMWI3000000Z0=WIf@`00000:`3IfMT<00000580fMWI001E0=WIf@`00000
:P3IfMT<000002/0fMWI3000001B0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0000000`000001P3IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0000000<000000D0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT<000000h0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT03@3IfMT<000000H0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI001F0=WIf@X0
0000;03IfMT:000002d0fMWI2P00001C0=WIf@00EP3IfMT:000002`0fMWI2P00000]0=WIf@X00000
D`3IfMT005P0fMWI1P00000`0=WIf@H00000<@3IfMT6000005D0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.3125 .30902 Mdot
.5 .30902 Mdot
.6875 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@070=WIf@H0
00004@3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@0<0=WIf@H0
00003P3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000001`3IfMT:000000d0fMWI0`00000I0=WIf@X000006P3IfMT3000000`0fMWI2P0000090=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@800000203IfMT:000000l0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT02P3IfMT:000000X0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00F03IfMT<000002L0fMWI3000000W0=WI
f@`00000EP3IfMT005P0fMWI3000000W0=WIf@`000009`3IfMT<000005H0fMWI001H0=WIf@`00000
9`3IfMT<000002L0fMWI3000001F0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI30000004
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@`00000103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00P0fMWI3000000;0=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI00T0fMWI3000000:0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00F@3IfMT:000002T0fMWI2P00000Y0=WIf@X00000E`3IfMT005T0fMWI2P00000Y0=WIf@X00000
:@3IfMT:000005L0fMWI001K0=WIf@H00000;@3IfMT6000002d0fMWI1P00001I0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.32349 .30902 Mdot
.5 .30902 Mdot
.67651 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0:0=WIf@H0
00003P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@090=WIf@H0
00004@3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000002P3IfMT:000000X0fMWI0`00000I0=WIf@X000006P3IfMT3000000T0fMWI2P00000<0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000002`3IfMT:000000`0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT01`3IfMT:000000d0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00F`3IfMT<000002@0fMWI3000000T0=WI
f@`00000F@3IfMT005/0fMWI3000000T0=WIf@`00000903IfMT<000005T0fMWI001K0=WIf@`00000
903IfMT<000002@0fMWI3000001I0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI3@000000
0`3IfMT000000=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00@0fMWI00<000000=WIf@000000300000060=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@002@3IfMT00`000000fMWI0=WIf@0O0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT02`3IfMT<000000P0fMWI00<000000=WI
f@3IfMT06@3IfMT<000001/0fMWI00<000000=WIf@3IfMT01P3IfMT<000000d0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00D0fMWI001L0=WIf@X0
00009P3IfMT:000002H0fMWI2P00001J0=WIf@00G03IfMT:000002H0fMWI2P00000V0=WIf@X00000
FP3IfMT005h0fMWI1P00000Z0=WIf@H00000:P3IfMT6000005`0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI001g0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@@000000P3IfMT3000000H0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI
0=WIf@060=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@04
0000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3I
fMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT20000
00@0fMWI00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT20000
08d0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000090=WIf@@000001@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@80
0000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@03
0000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I
fMT01@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000
003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@80
0000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT01000
0000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI
000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003I
fMT0fMWI08`0fMWI001g0=WIf@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT0
0940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<
0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0
fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT008P0fMWI10000005
0=WIf@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI
f@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT2000008d0fMWI002:0=WIf@030000
003IfMT0fMWI09<0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI00280=WIf@<00000U@3IfMT0
08X0fMWI00<000000=WIf@3IfMT0T`3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.33166 .30902 Mdot
.5 .30902 Mdot
.66834 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0=0=WIf@H0
00002`3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@070=WIf@H0
00004`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000003@3IfMT:000000L0fMWI0`00000I0=WIf@X000006P3IfMT3000000L0fMWI2P00000>0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000003P3IfMT:000000T0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT01@3IfMT:000000l0fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00GP3IfMT<00000240fMWI3000000R0=WI
f@`00000F`3IfMT005h0fMWI3000000Q0=WIf@`000008P3IfMT<000005/0fMWI001N0=WIf@`00000
8@3IfMT<00000280fMWI3000001K0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00@00000
0=WIf@3IfMT0fMWI300000050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI3P0000060=WIf@030000003I
fMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003I
fMT0fMWI00@0fMWI300000020=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103I
fMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0fMWI00090=WIf@030000003IfMT0
fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0>0=WIf@`000001@3IfMT0
0`000000fMWI0=WIf@0I0=WIf@`000006`3IfMT00`000000fMWI0=WIf@040=WIf@`000003`3IfMT0
0`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT01@3IfMT0
05l0fMWI2P00000S0=WIf@X00000903IfMT:000005`0fMWI001O0=WIf@X000008`3IfMT:000002@0
fMWI2P00001L0=WIf@00H@3IfMT6000002L0fMWI1P00000X0=WIf@H00000GP3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3I
fMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT20000
08d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI
002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI100000020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000080=WIf@03
0000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000X0fMWI0P0000030=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI001m
0=WIf@800000103IfMT00`000000fMWI0=WIf@020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<
0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@03
0=WIf@800000S@3IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<00000
0=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<00000
0=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT30000
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002@3IfMT00`00
0000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0S03IfMT007H0
fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00MP3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI
0=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;
0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@00000
0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI
00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000090=WIf@@000000P3IfMT4000000D0fMWI0P00
002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI
08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WI
f@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00R03I
fMT4000000D0fMWI00<000000=WIf@3IfMT0S03IfMT008X0fMWI00<000000=WIf@3IfMT0103IfMT0
0`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT008X0
fMWI00<000000=WIf@3IfMT0T`3IfMT008X0fMWI00<000000=WIf@3IfMT0T`3IfMT008P0fMWI0`00
002E0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.33669 .30902 Mdot
.5 .30902 Mdot
.66331 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3IfMTQ
0=WIf@00o`3IfMTQ0=WIf@00R03IfMT4000009@0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI
002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00PP3IfMT4000000@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI00280=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
RP3IfMT00`000000fMWI0=WIf@040=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT00P3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@0
00000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI
00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI
0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00L03IfMT400000080fMWI00@0
00000=WIf@3IfMT000002P3IfMT010000000fMWI0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3I
fMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT000002`3IfMT010000000fMWI0=WIf@0000080=WI
f@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WI
f@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001g0=WI
f@8000002@3IfMT400000080fMWI100000050=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007d0fMWI0P0000040=WIf@030000003IfMT0fMWI
0080fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001l0=WIf@040000003IfMT0fMWI0000
00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00O03IfMT010000000
fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00<0fMWI0P00002=0=WIf@00MP3IfMT400000080
fMWI00@000000=WIf@3IfMT00000203IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0
fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT01P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O@3IfMT2000000T0fMWI100000050=WIf@800000S@3IfMT00940fMWI
00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00
T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT007L0fMWI0P0000040=WIf@03
0000003IfMT0fMWI0080fMWI100000020=WIf@<000001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT2000008d0fMWI001`0=WIf@@00000
0P3IfMT010000000fMWI0=WIf@00000:0=WIf@040000003IfMT0fMWI0=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@00000;0=WIf@040000003IfMT0fMWI
000000P0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT00000203IfMT0
10000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT0S03I
fMT007L0fMWI0P00000:0=WIf@8000000`3IfMT4000000D0fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI000<0=WIf@030000003IfMT0fMWI01h0fMWI0P00000O0=WIf@@0
00007P3IfMT4000001d0fMWI00<000000=WIf@3IfMT0703IfMT4000001h0fMWI1000000O0=WIf@80
00008@3IfMT00`000000fMWI0=WIf@050=WIf@00303IfMT00`000000fMWI0=WIf@0M0=WIf@040000
003IfMT0fMWI000001h0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@0L0=WIf@03
0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@0O0=WIf@04
0000003IfMT0fMWI00000200fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI1@00000Q0=WIf@03
0000003IfMT0fMWI01d0fMWI00<000000=WIf@3IfMT0803IfMT00`000000fMWI0=WIf@0L0=WIf@80
00007`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000003IfMT0fMWI0240fMWI00<000000=WIf@3I
fMT06`3IfMT5000000H0fMWI00040=WIf@@0000000D0fMWI0000003IfMT0fMWI0000000I0=WIf@@0
00000`3IfMT2000001T0fMWI100000040=WIf@030000003IfMT0fMWI01L0fMWI100000040=WIf@03
0000003IfMT0fMWI01`0fMWI00<000000=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@0O0=WIf@03
0000003IfMT0fMWI01h0fMWI0P00000N0=WIf@040000003IfMT0fMWI000000L0fMWI000:0=WIf@03
0000003IfMT000000280fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@0>0=WIf@H0
00002P3IfMT00`000000fMWI0=WIf@0I0=WIf@H000007P3IfMT00`000000fMWI0=WIf@060=WIf@H0
0000503IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI01`0fMWI00<000000=WIf@00
00001`3IfMT000/0fMWI0P00000O0=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3I
fMT000003P3IfMT:000000H0fMWI0`00000I0=WIf@X000006P3IfMT3000000H0fMWI2P00000?0=WI
f@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000007`3IfMT2000000L0fMWI000<
0=WIf@030000003IfMT0fMWI01h0fMWI0P00000P0=WIf@8000003`3IfMT:000000P0fMWI00<00000
0=WIf@3IfMT05`3IfMT:000001`0fMWI00<000000=WIf@3IfMT0103IfMT:00000100fMWI0P00000P
0=WIf@8000008@3IfMT00`000000fMWI0=WIf@050=WIf@00G`3IfMT<00000200fMWI3000000Q0=WI
f@`00000G03IfMT005l0fMWI3000000P0=WIf@`000008@3IfMT<000005`0fMWI001O0=WIf@`00000
803IfMT<00000240fMWI3000001L0=WIf@002@3IfMWo0000014000001`3IfMT000T0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00@0fMWI00<00000
0=WIf@3IfMT00P3IfMT<000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT>000000H0fMWI00<00000
0=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT00`3IfMT<000000<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@04
0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT000T0fMWI00<000000=WI
f@3IfMT07`3IfMT00`000000fMWI0=WIf@0O0=WIf@030000003IfMT0fMWI00l0fMWI300000040=WI
f@030000003IfMT0fMWI01T0fMWI3000000K0=WIf@030000003IfMT0fMWI00<0fMWI3000000@0=WI
f@030000003IfMT0fMWI01l0fMWI00<000000=WIf@3IfMT07`3IfMT00`000000fMWI0=WIf@050=WI
f@00H03IfMT:00000280fMWI2P00000S0=WIf@X00000G@3IfMT00600fMWI2P00000R0=WIf@X00000
8`3IfMT:000005d0fMWI001R0=WIf@H000009P3IfMT6000002L0fMWI1P00001O0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A
0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@80
0000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03I
fMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00P3IfMT400000080fMWI
0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI000000P0fMWI
00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI08`0fMWI
001f0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI
0=WIf@030=WIf@800000S@3IfMT007H0fMWI00@000000=WIf@3IfMT000002P3IfMT010000000fMWI
0=WIf@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0S03IfMT007H0fMWI00@000000=WIf@3IfMT0
00002`3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@04
0000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@06
0=WIf@030000003IfMT0fMWI08`0fMWI001g0=WIf@8000002P3IfMT2000000<0fMWI100000050=WI
f@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0
S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI
0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WI
f@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000
003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT0
07d0fMWI0P0000040=WIf@030000003IfMT0fMWI0080fMWI0`0000060=WIf@030000003IfMT0fMWI
08`0fMWI001l0=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT00`3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI
00<0fMWI0P00002=0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@<000001P3IfMT00`00
0000fMWI0=WIf@2<0=WIf@00O03IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI
00H0fMWI00<000000=WIf@3IfMT0S03IfMT007`0fMWI00@000000=WIf@3IfMT00000203IfMT00`00
0000fMWI0=WIf@060=WIf@030000003IfMT0fMWI08`0fMWI001m0=WIf@8000002@3IfMT4000000D0
fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WI
f@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@03
0000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003I
fMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940
fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<0
00000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WI
f@00M`3IfMT2000000@0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@<0
00001P3IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT010000000fMWI0=WIf@0000090=WIf@03
0000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@2<0=WIf@00
MP3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3I
fMT00`3IfMT2000008d0fMWI001f0=WIf@040000003IfMT0fMWI000000X0fMWI00@000000=WIf@3I
fMT0fMWI0`0000060=WIf@030000003IfMT0fMWI08`0fMWI001f0=WIf@040000003IfMT0fMWI0000
00/0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@2<0=WIf@00MP3IfMT01000
0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01P3I
fMT00`000000fMWI0=WIf@2<0=WIf@00M`3IfMT2000000T0fMWI100000020=WIf@@000001@3IfMT2
000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@030000003IfMT0fMWI08`0
fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI002A0=WIf@800000S@3IfMT00940fMWI00<00000
0=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI00<000000=WIf@3I
fMT0S03IfMT00940fMWI00<000000=WIf@3IfMT0S03IfMT00940fMWI0P00002=0=WIf@00T@3IfMT0
0`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000fMWI0=WIf@2<0=WIf@00T@3IfMT00`000000
fMWI0=WIf@2<0=WIf@00T@3IfMT2000008d0fMWI002A0=WIf@030000003IfMT0fMWI08`0fMWI0028
0=WIf@@000001@3IfMT00`000000fMWI0=WIf@2<0=WIf@00RP3IfMT00`000000fMWI0=WIf@040=WI
f@030000003IfMT0fMWI08`0fMWI002:0=WIf@030000003IfMT0fMWI00@0fMWI0P00002=0=WIf@00
RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00RP3IfMT00`000000fMWI0=WIf@2C0=WIf@00R03IfMT3
000009D0fMWI002:0=WIf@030000003IfMT0fMWI09<0fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.875, 0}} -> {-4.26898, -1.0536, \
0.0294412, 0.0119092}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(Do[
        ListPlot[\[IndentingNewLine]\({{x1[t] - 2, 0}, {x2[t], 
                    0}, {x3[t] + 2, 0}} //. 
                allRules\)\[IndentingNewLine] //. {c1 \[Rule] 0, 
                c2 \[Rule] 0, c3 \[Rule] 1}\ \[IndentingNewLine] // 
            Evaluate, \[IndentingNewLine]PlotStyle \[Rule] {PointSize[
                0.05]}, \[IndentingNewLine]PlotRange \[Rule] {{\(-4\), 
                4}, {\(-1\), 1}}], \[IndentingNewLine]{t, 0, 
          2\ \[Pi] \((1 - 1/number)\)/Sqrt[5/3], 
          2\ \(\[Pi]\ /number\)/Sqrt[5/3]}];\)\)\)], "Input",
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.32995 .30902 Mdot
.4467 .30902 Mdot
.82995 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P00000E0=WIf@T000003P3IfMT2000000030=WIf@000000fMWI01@0fMWI2@00000@0=WIf@030000
003IfMT0fMWI02`0fMWI0P0000000`3IfMT000000=WIf@0^0=WIf@8000000`3IfMT2000001X0fMWI
2@00000?0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3IfMT200000300fMWI1000
000_0=WIf@<000005@3IfMT<000000l0fMWI0P00000C0=WIf@`000003`3IfMT00`000000fMWI0=WI
f@0^0=WIf@800000<@3IfMT3000001X0fMWI3000000:0=WIf@@00000<03IfMT2000000X0fMWI002=
0=WIf@l000008@3IfMT?000000d0fMWI00<000000=WIf@3IfMT0O@3IfMT?000004P0fMWI002<0=WI
fA000000803IfMT@000000d0fMWI0`00001l0=WIfA000000B03IfMT008`0fMWI4@00000O0=WIfA40
0000303IfMT00`000000fMWI0=WIf@1l0=WIfA400000A`3IfMT008/0fMWI4`00000M0=WIfA<00000
2`3IfMT00`000000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008/0fMWI4`00000M0=WIfA<000002`3I
fMT00`000000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008/0fMWI4`00000M0=WIfA<000002`3IfMT0
0`000000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008/0fMWI4`00000M0=WIfA<000002`3IfMT00`00
0000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008X0fMWI5000000L0=WIfA@000002`3IfMT00`000000
fMWI0=WIf@1j0=WIfA@00000AP3IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI01<00000203IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI4`00
00000`3IfMT000000=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI01<00000203IfMT00`000000fMWI0=WI
f@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT000d0fMWI00<00000
0=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI01D0fMWI4`000008
0=WIf@030000003IfMT0fMWI0180fMWI4`00000;0=WIf@030000003IfMT0fMWI0300fMWI00<00000
0=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0E0=WIfA<00000203IfMT00`000000fMWI0=WIf@0`
0=WIf@030000003IfMT0fMWI00P0fMWI002;0=WIfA<000007@3IfMTC000000/0fMWI00<000000=WI
f@3IfMT0N`3IfMTC000004H0fMWI002<0=WIfA4000007`3IfMTA000000`0fMWI00<000000=WIf@3I
fMT0O03IfMTA000004L0fMWI002<0=WIfA000000803IfMT@000000d0fMWI00<000000=WIf@3IfMT0
O03IfMT@000004P0fMWI002=0=WIf@l000008@3IfMT?000000d0fMWI0`00001m0=WIf@l00000B03I
fMT008h0fMWI3000000T0=WIf@`000003`3IfMT00`000000fMWI0=WIf@1n0=WIf@`00000BP3IfMT0
0900fMWI2@00000W0=WIf@T00000403IfMT00`000000fMWI0=WIf@200=WIf@T00000B`3IfMT009@0
fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI08@0
fMWI00<000000=WIf@3IfMT0C@3IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT30000
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:l0fMWI100000070=WIf@8000001@3IfMT7000000@0fMWI1@0000080=WIf@030000003IfMT0fMWI
0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000060=WIf@030000003IfMT0fMWI
0080fMWI00<000000=WIf@3IfMT01P3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0=0=WIf@050000003IfMT0fMWI0=WI
f@0000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@0:0=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000
003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI
00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI0080fMWI00<0
00000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@02
0=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@02
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WIf@030000003IfMT0fMWI00X0fMWI00<00000
0=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<000001P3IfMT5000000P0fMWI0`00003D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000L0fMWI0P0000060=WIf@D00000203I
fMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT010000000fMWI0=WIf@0000070=WIf@8000002P3I
fMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT0
0`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0e03IfMT0
0;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI
00D0fMWI1000003C0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0
fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WIf@3I
fMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3I
fMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03I
fMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003I
fMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0
fMWI0P0000080=WIf@030000003IfMT0fMWI00D0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0
fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000080=WIf@030000003IfMT0fMWI00T0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00D0fMWI
00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI
f@0?0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@04
0=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5
000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT02P3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100
fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0
fMWI002_0=WIf@040000003IfMT0fMWI000000h0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI
1000000>0=WIf@L00000103IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00
003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00b`3IfMT7000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<000000=WIf@3I
fMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000
003IfMT0fMWI0=@0fMWI003>0=WIf@030000003IfMT0fMWI00P0fMWI1000003C0=WIf@00cP3IfMT0
0`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000
fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00b`3IfMT2000000030=WIf@00
0000fMWI0>00fMWI003=0=WIf@800000h@3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.32841 .30902 Mdot
.44772 .30902 Mdot
.82841 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P00000D0=WIf@T000003`3IfMT2000000030=WIf@000000fMWI01@0fMWI2@00000@0=WIf@030000
003IfMT0fMWI02`0fMWI0P0000000`3IfMT000000=WIf@0^0=WIf@8000000`3IfMT2000001X0fMWI
2@00000?0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3IfMT200000300fMWI1000
000_0=WIf@<00000503IfMT<00000100fMWI0P00000C0=WIf@`000003`3IfMT00`000000fMWI0=WI
f@0^0=WIf@800000<@3IfMT3000001X0fMWI3000000:0=WIf@@00000<03IfMT2000000X0fMWI002<
0=WIf@l000008P3IfMT?000000d0fMWI00<000000=WIf@3IfMT0O@3IfMT?000004P0fMWI002;0=WI
fA0000008@3IfMT@000000d0fMWI0`00001l0=WIfA000000B03IfMT008/0fMWI4@00000P0=WIfA40
0000303IfMT00`000000fMWI0=WIf@1l0=WIfA400000A`3IfMT008X0fMWI4`00000N0=WIfA<00000
2`3IfMT00`000000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008X0fMWI4`00000N0=WIfA<000002`3I
fMT00`000000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008X0fMWI4`00000N0=WIfA<000002`3IfMT0
0`000000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008X0fMWI4`00000N0=WIfA<000002`3IfMT00`00
0000fMWI0=WIf@1k0=WIfA<00000AP3IfMT008T0fMWI5000000M0=WIfA@000002`3IfMT00`000000
fMWI0=WIf@1j0=WIfA@00000AP3IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT00000018000002@3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI4`00
00000`3IfMT000000=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI01<00000203IfMT00`000000fMWI0=WI
f@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT000d0fMWI00<00000
0=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI01@0fMWI4`000009
0=WIf@030000003IfMT0fMWI0180fMWI4`00000;0=WIf@030000003IfMT0fMWI0300fMWI00<00000
0=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0E0=WIfA<00000203IfMT00`000000fMWI0=WIf@0`
0=WIf@030000003IfMT0fMWI00P0fMWI002:0=WIfA<000007P3IfMTC000000/0fMWI00<000000=WI
f@3IfMT0N`3IfMTC000004H0fMWI002;0=WIfA400000803IfMTA000000`0fMWI00<000000=WIf@3I
fMT0O03IfMTA000004L0fMWI002;0=WIfA0000008@3IfMT@000000d0fMWI00<000000=WIf@3IfMT0
O03IfMT@000004P0fMWI002<0=WIf@l000008P3IfMT?000000d0fMWI0`00001m0=WIf@l00000B03I
fMT008d0fMWI3000000U0=WIf@`000003`3IfMT00`000000fMWI0=WIf@1n0=WIf@`00000BP3IfMT0
08l0fMWI2@00000X0=WIf@T00000403IfMT00`000000fMWI0=WIf@200=WIf@T00000B`3IfMT009<0
fMWI00<000000=WIf@3IfMT0;P3IfMT00`000000fMWI0=WIf@0B0=WIf@030000003IfMT0fMWI08@0
fMWI00<000000=WIf@3IfMT0C@3IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT30000
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:l0fMWI100000070=WIf@8000001@3IfMT7000000@0fMWI1@0000080=WIf@030000003IfMT0fMWI
0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000060=WIf@030000003IfMT0fMWI
0080fMWI00<000000=WIf@3IfMT01P3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0=0=WIf@050000003IfMT0fMWI0=WI
f@0000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@0:0=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000
003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI
00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI0080fMWI00<0
00000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@02
0=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@02
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WIf@030000003IfMT0fMWI00X0fMWI00<00000
0=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<000001P3IfMT5000000P0fMWI0`00003D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000L0fMWI0P0000060=WIf@D00000203I
fMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT010000000fMWI0=WIf@0000070=WIf@8000002P3I
fMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT0
0`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0e03IfMT0
0;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI
00D0fMWI1000003C0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0
fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WIf@3I
fMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3I
fMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03I
fMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003I
fMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0
fMWI0P0000080=WIf@030000003IfMT0fMWI00D0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0
fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000080=WIf@030000003IfMT0fMWI00T0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00D0fMWI
00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI
f@0?0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@04
0=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5
000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT02P3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100
fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0
fMWI002_0=WIf@040000003IfMT0fMWI000000h0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI
1000000>0=WIf@L00000103IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00
003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00b`3IfMT7000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<000000=WIf@3I
fMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000
003IfMT0fMWI0=@0fMWI003>0=WIf@030000003IfMT0fMWI00P0fMWI1000003C0=WIf@00cP3IfMT0
0`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000
fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00b`3IfMT2000000030=WIf@00
0000fMWI0>00fMWI003=0=WIf@800000h@3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.32386 .30902 Mdot
.45076 .30902 Mdot
.82386 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P00000C0=WIf@T00000403IfMT2000000030=WIf@000000fMWI01D0fMWI2@00000?0=WIf@030000
003IfMT0fMWI02`0fMWI0P0000000`3IfMT000000=WIf@0^0=WIf@8000000`3IfMT2000001P0fMWI
2@00000A0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3IfMT200000300fMWI1000
000_0=WIf@<000004`3IfMT<00000140fMWI0P00000D0=WIf@`000003P3IfMT00`000000fMWI0=WI
f@0^0=WIf@800000<@3IfMT3000001P0fMWI3000000<0=WIf@@00000<03IfMT2000000X0fMWI002;
0=WIf@l00000903IfMT?000000`0fMWI00<000000=WIf@3IfMT0N`3IfMT?000004X0fMWI002:0=WI
fA0000008`3IfMT@000000`0fMWI0`00001j0=WIfA000000BP3IfMT008X0fMWI4@00000R0=WIfA40
00002`3IfMT00`000000fMWI0=WIf@1j0=WIfA400000B@3IfMT008T0fMWI4`00000P0=WIfA<00000
2P3IfMT00`000000fMWI0=WIf@1i0=WIfA<00000B03IfMT008T0fMWI4`00000P0=WIfA<000002P3I
fMT00`000000fMWI0=WIf@1i0=WIfA<00000B03IfMT008T0fMWI4`00000P0=WIfA<000002P3IfMT0
0`000000fMWI0=WIf@1i0=WIfA<00000B03IfMT008T0fMWI4`00000P0=WIfA<000002P3IfMT00`00
0000fMWI0=WIf@1i0=WIfA<00000B03IfMT008P0fMWI5000000O0=WIfA@000002P3IfMT00`000000
fMWI0=WIf@1h0=WIfA@00000B03IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIfAD000002@3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI5@0000090=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIfAD000002@3I
fMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT000d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0`0=WIf@030000003IfMT0
fMWI01<0fMWI4`00000:0=WIf@030000003IfMT0fMWI01<0fMWI4`00000:0=WIf@030000003IfMT0
fMWI0300fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0C0=WIfA<000002P3IfMT0
0`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI00P0fMWI00290=WIfA<00000803IfMTC0000
00X0fMWI00<000000=WIf@3IfMT0N@3IfMTC000004P0fMWI002:0=WIfA4000008P3IfMTA000000/0
fMWI00<000000=WIf@3IfMT0NP3IfMTA000004T0fMWI002:0=WIfA0000008`3IfMT@000000`0fMWI
00<000000=WIf@3IfMT0NP3IfMT@000004X0fMWI002;0=WIf@l00000903IfMT?000000`0fMWI0`00
001k0=WIf@l00000BP3IfMT008`0fMWI3000000W0=WIf@`000003P3IfMT00`000000fMWI0=WIf@1l
0=WIf@`00000C03IfMT008h0fMWI2@00000Z0=WIf@T000003`3IfMT00`000000fMWI0=WIf@1n0=WI
f@T00000C@3IfMT00980fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0A0=WIf@03
0000003IfMT0fMWI0880fMWI00<000000=WIf@3IfMT0C`3IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@8000001@3IfMT7000000@0fMWI1@0000080=WI
f@030000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000060=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT01P3IfMT2000000L0fMWI00<000000=WI
f@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0=0=WIf@05
0000003IfMT0fMWI0=WIf@0000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI
0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03P3IfMT00`000000
fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00D0fMWI1000003C0=WIf@00[P3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003IfMT0fMWI0=WIf@80
00001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000
003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0
e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003I
fMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WIf@030000003IfMT0
fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<000001P3IfMT50000
00P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000L0fMWI0P00
00060=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT010000000fMWI0=WIf@00
00070=WIf@8000002P3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<00000
0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00D0fMWI00<00000
0=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WI
f@030000003IfMT0fMWI00D0fMWI1000003C0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@03
0000003IfMT0fMWI00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI
0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI
0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<0
00000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WI
f@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI0`00003D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00
003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00[`3IfMT4000000L0fMWI0P0000080=WIf@030000003IfMT0fMWI00D0fMWI1@0000080=WIf@03
0000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000080=WIf@03
0000003IfMT0fMWI00T0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000
003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000
003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3I
fMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT01@3I
fMT400000=<0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT0
0`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WI
f@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<00000
0=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WI
f@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@03
0000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@03
0000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000h0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3I
fMT0e03IfMT00:l0fMWI1000000>0=WIf@L00000103IfMT5000000P0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00b`3IfMT7000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0
fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI
0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI003>0=WIf@030000003IfMT0fMWI00P0fMWI1000
003C0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WI
f@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00b`3I
fMT2000000030=WIf@000000fMWI0>00fMWI003=0=WIf@800000h@3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.31648 .30902 Mdot
.45568 .30902 Mdot
.81648 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P00000@0=WIf@T000004`3IfMT2000000030=WIf@000000fMWI01L0fMWI2@00000=0=WIf@030000
003IfMT0fMWI02`0fMWI0P0000000`3IfMT000000=WIf@0^0=WIf@8000000`3IfMT2000001D0fMWI
2@00000D0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3IfMT200000300fMWI1000
000_0=WIf@<00000403IfMT<000001@0fMWI0P00000F0=WIf@`00000303IfMT00`000000fMWI0=WI
f@0^0=WIf@800000<@3IfMT3000001D0fMWI3000000?0=WIf@@00000<03IfMT2000000X0fMWI0028
0=WIf@l00000:@3IfMT?000000X0fMWI00<000000=WIf@3IfMT0N03IfMT?000004d0fMWI00270=WI
fA000000:03IfMT@000000X0fMWI0`00001g0=WIfA000000C@3IfMT008L0fMWI4@00000W0=WIfA40
00002@3IfMT00`000000fMWI0=WIf@1g0=WIfA400000C03IfMT008H0fMWI4`00000U0=WIfA<00000
203IfMT00`000000fMWI0=WIf@1f0=WIfA<00000B`3IfMT008H0fMWI4`00000U0=WIfA<00000203I
fMT00`000000fMWI0=WIf@1f0=WIfA<00000B`3IfMT008H0fMWI4`00000U0=WIfA<00000203IfMT0
0`000000fMWI0=WIf@1f0=WIfA<00000B`3IfMT008H0fMWI4`00000U0=WIfA<00000203IfMT00`00
0000fMWI0=WIf@1f0=WIfA<00000B`3IfMT008D0fMWI5000000T0=WIfA@00000203IfMT00`000000
fMWI0=WIf@1e0=WIfA@00000B`3IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@060=WIfA<000000`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@0C000000P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@080=WIf@030000003IfMT0fMWI00D0fMWI4`0000030=WIf@030000003IfMT0fMWI00L0fMWI00<0
00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<0
00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI000=
0=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0@
0=WIfA<000003@3IfMT00`000000fMWI0=WIf@0E0=WIfA<00000203IfMT00`000000fMWI0=WIf@0`
0=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0403IfMTC000000d0fMWI00<00000
0=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@080=WIf@00QP3IfMTC000002D0fMWI4`0000080=WI
f@030000003IfMT0fMWI07H0fMWI4`00001;0=WIf@00Q`3IfMTA000002L0fMWI4@0000090=WIf@03
0000003IfMT0fMWI07L0fMWI4@00001<0=WIf@00Q`3IfMT@000002P0fMWI4000000:0=WIf@030000
003IfMT0fMWI07L0fMWI4000001=0=WIf@00R03IfMT?000002T0fMWI3`00000:0=WIf@<00000N03I
fMT?000004d0fMWI00290=WIf@`00000;03IfMT<000000`0fMWI00<000000=WIf@3IfMT0N@3IfMT<
000004l0fMWI002;0=WIf@T00000;`3IfMT9000000d0fMWI00<000000=WIf@3IfMT0N`3IfMT90000
0500fMWI002?0=WIf@030000003IfMT0fMWI03D0fMWI00<000000=WIf@3IfMT03`3IfMT00`000000
fMWI0=WIf@1o0=WIf@030000003IfMT0fMWI0580fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI002_0=WIf@@000001`3IfMT2000000D0fMWI1`0000040=WIf@D00000203IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@8000001P3IfMT00`00
0000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI0P0000070=WIf@030000003IfMT0fMWI
0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03@3IfMT01@000000
fMWI0=WIf@3IfMT0000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3I
fMT02P3IfMT00`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00:h0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@8000001@3IfMT010000000fMWI0=WIf@3IfMT2000000L0
fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI
0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI
002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<00000
0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00<0fMWI00<00000
0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WI
f@040000003IfMT0fMWI000000h0fMWI0P0000030=WIf@800000103IfMT00`000000fMWI0=WIf@0:
0=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@@00000403IfMT3000000H0fMWI1@0000080=WI
f@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI100000070=WIf@8000001P3I
fMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WIf@3IfMT000001`3I
fMT2000000X0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0
fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`00
0000fMWI0=WIf@050=WIf@@00000d`3IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000
fMWI0=WIf@0<0=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WI
f@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0fMWI1@0000080=WIf@03
0000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0
303IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003I
fMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0:0=WIf@030000003I
fMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000l0fMWI00<000000=WIf@3IfMT02P3I
fMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000l0fMWI1@0000080=WIf@<00000e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0
fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@050=WIf@D00000203IfMT00`000000
fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@800000203IfMT00`000000
fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI
0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<0
00000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00D0fMWI1000
003C0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<00000
0=WIf@3IfMT0103IfMT010000000fMWI0=WIf@3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03I
fMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0
fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI
0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI
00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000
fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT02P3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@00000>0=WIf@030000003IfMT0fMWI00<0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0
fMWI002_0=WIf@@000003P3IfMT7000000@0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00</0fMWI1`0000070=WIf@030000003IfMT0fMWI0=@0fMWI003>0=WIf@03
0000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<000000=WIf@3IfMT0
203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@@00000d`3I
fMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0
fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00</0fMWI0P00
00000`3IfMT000000=WIf@3P0=WIf@00c@3IfMT200000>40fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.30653 .30902 Mdot
.46231 .30902 Mdot
.80653 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P00000<0=WIf@T000005`3IfMT2000000030=WIf@000000fMWI01X0fMWI2@00000:0=WIf@030000
003IfMT0fMWI02`0fMWI0P0000000`3IfMT000000=WIf@0^0=WIf@8000000`3IfMT200000140fMWI
2@00000H0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3IfMT200000300fMWI1000
000_0=WIf@<00000303IfMT<000001P0fMWI0P00000I0=WIf@`000002@3IfMT00`000000fMWI0=WI
f@0^0=WIf@800000<@3IfMT300000140fMWI3000000C0=WIf@@00000<03IfMT2000000X0fMWI0024
0=WIf@l00000<03IfMT?000000L0fMWI00<000000=WIf@3IfMT0M03IfMT?00000540fMWI00230=WI
fA000000;`3IfMT@000000L0fMWI0`00001c0=WIfA000000D@3IfMT008<0fMWI4@00000^0=WIfA40
00001P3IfMT00`000000fMWI0=WIf@1c0=WIfA400000D03IfMT00880fMWI4`00000/0=WIfA<00000
1@3IfMT00`000000fMWI0=WIf@1b0=WIfA<00000C`3IfMT00880fMWI4`00000/0=WIfA<000001@3I
fMT00`000000fMWI0=WIf@1b0=WIfA<00000C`3IfMT00880fMWI4`00000/0=WIfA<000001@3IfMT0
0`000000fMWI0=WIf@1b0=WIfA<00000C`3IfMT00880fMWI4`00000/0=WIfA<000001@3IfMT00`00
0000fMWI0=WIf@1b0=WIfA<00000C`3IfMT00840fMWI5000000[0=WIfA@000001@3IfMT00`000000
fMWI0=WIf@1a0=WIfA@00000C`3IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@020=WIfA<000001`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@030=WIfA<000001@3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00@000000=WIf@3IfMT0fMWI4`0000070=WIf@030000003IfMT0fMWI00L0fMWI
00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI
00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI
000=0=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WI
f@0<0=WIfA<000004@3IfMT00`000000fMWI0=WIf@0H0=WIfA<000001@3IfMT00`000000fMWI0=WI
f@0`0=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0303IfMTC00000140fMWI00<0
00000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@080=WIf@00PP3IfMTC000002`0fMWI4`000005
0=WIf@030000003IfMT0fMWI0780fMWI4`00001?0=WIf@00P`3IfMTA000002h0fMWI4@0000060=WI
f@030000003IfMT0fMWI07<0fMWI4@00001@0=WIf@00P`3IfMT@000002l0fMWI400000070=WIf@03
0000003IfMT0fMWI07<0fMWI4000001A0=WIf@00Q03IfMT?00000300fMWI3`0000070=WIf@<00000
M03IfMT?00000540fMWI00250=WIf@`00000<`3IfMT<000000T0fMWI00<000000=WIf@3IfMT0M@3I
fMT<000005<0fMWI00270=WIf@T00000=P3IfMT9000000X0fMWI00<000000=WIf@3IfMT0M`3IfMT9
000005@0fMWI002;0=WIf@030000003IfMT0fMWI03`0fMWI00<000000=WIf@3IfMT0303IfMT00`00
0000fMWI0=WIf@1k0=WIf@030000003IfMT0fMWI05H0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI002_0=WIf@@000001`3IfMT2000000D0fMWI1`0000040=WIf@D00000203IfMT0
0`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@8000001P3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI0P0000070=WIf@030000003IfMT0
fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03@3IfMT01@00
0000fMWI0=WIf@3IfMT0000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WI
f@3IfMT02P3IfMT00`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00:h0fMWI00<000000=WIf@3I
fMT00P3IfMT00`000000fMWI0=WIf@0?0=WIf@8000001@3IfMT010000000fMWI0=WIf@3IfMT20000
00L0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000
fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0
fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00<0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_
0=WIf@040000003IfMT0fMWI000000h0fMWI0P0000030=WIf@800000103IfMT00`000000fMWI0=WI
f@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@@00000403IfMT3000000H0fMWI1@000008
0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI100000070=WIf@800000
1P3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WIf@3IfMT00000
1`3IfMT2000000X0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003I
fMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@050=WIf@030000003I
fMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT0
0`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0<0=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0fMWI1@0000080=WI
f@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I
fMT0303IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000
003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000l0fMWI00<000000=WIf@3IfMT0
2P3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000l0fMWI1@0000080=WIf@<00000e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@050=WIf@D00000203IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@800000203IfMT00`00
0000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000
fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000
fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00D0fMWI
1000003C0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<0
00000=WIf@3IfMT0103IfMT010000000fMWI0=WIf@3IfMT2000000L0fMWI00<000000=WIf@3IfMT0
e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003I
fMT0fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT02P3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@00000>0=WIf@030000003IfMT0fMWI
00<0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI
0=@0fMWI002_0=WIf@@000003P3IfMT7000000@0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00</0fMWI1`0000070=WIf@030000003IfMT0fMWI0=@0fMWI003>0=WI
f@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<000000=WIf@3I
fMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@@00000
d`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT0
0<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00</0fMWI
0P0000000`3IfMT000000=WIf@3P0=WIf@00c@3IfMT200000>40fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.29442 .30902 Mdot
.47039 .30902 Mdot
.79442 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P0000070=WIf@T00000703IfMT2000000030=WIf@000000fMWI01d0fMWI2@0000070=WIf@030000
003IfMT0fMWI02`0fMWI0P0000000`3IfMT000000=WIf@0^0=WIf@8000000`3IfMT2000000`0fMWI
2@00000M0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3IfMT200000300fMWI1000
000_0=WIf@<000001`3IfMT<000001d0fMWI0P00000L0=WIf@`000001P3IfMT00`000000fMWI0=WI
f@0^0=WIf@800000<@3IfMT3000000`0fMWI3000000H0=WIf@@00000<03IfMT2000000X0fMWI001o
0=WIf@l00000>03IfMT?000000@0fMWI00<000000=WIf@3IfMT0K`3IfMT?000005H0fMWI001n0=WI
fA000000=`3IfMT@000000@0fMWI0`00001^0=WIfA000000EP3IfMT007h0fMWI4@00000f0=WIfA40
00000`3IfMT00`000000fMWI0=WIf@1^0=WIfA400000E@3IfMT007d0fMWI4`00000d0=WIfA<00000
0P3IfMT00`000000fMWI0=WIf@1]0=WIfA<00000E03IfMT007d0fMWI4`00000d0=WIfA<000000P3I
fMT00`000000fMWI0=WIf@1]0=WIfA<00000E03IfMT007d0fMWI4`00000d0=WIfA<000000P3IfMT0
0`000000fMWI0=WIf@1]0=WIfA<00000E03IfMT007d0fMWI4`00000d0=WIfA<000000P3IfMT00`00
0000fMWI0=WIf@1]0=WIfA<00000E03IfMT007`0fMWI5000000c0=WIfA@000000P3IfMT00`000000
fMWI0=WIf@1/0=WIfA@00000E03IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMTC00000080fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@060=WIfA<000000P3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI4`0000020=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT000d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0`0=WIf@030000003IfMT0
fMWI00L0fMWI4`00000F0=WIf@030000003IfMT0fMWI01/0fMWI4`0000020=WIf@030000003IfMT0
fMWI0300fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@070=WIfA<000005P3IfMT0
0`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI00P0fMWI001m0=WIfA<00000=03IfMTC0000
0080fMWI00<000000=WIf@3IfMT0K@3IfMTC000005@0fMWI001n0=WIfA400000=P3IfMTA000000<0
fMWI00<000000=WIf@3IfMT0KP3IfMTA000005D0fMWI001n0=WIfA000000=`3IfMT@000000@0fMWI
00<000000=WIf@3IfMT0KP3IfMT@000005H0fMWI001o0=WIf@l00000>03IfMT?000000@0fMWI0`00
001_0=WIf@l00000EP3IfMT00800fMWI3000000k0=WIf@`000001P3IfMT00`000000fMWI0=WIf@1`
0=WIf@`00000F03IfMT00880fMWI2@00000n0=WIf@T000001`3IfMT00`000000fMWI0=WIf@1b0=WI
f@T00000F@3IfMT008H0fMWI00<000000=WIf@3IfMT0A03IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI07H0fMWI00<000000=WIf@3IfMT0F`3IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@8000001@3IfMT7000000@0fMWI1@0000080=WI
f@030000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000060=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT01P3IfMT2000000L0fMWI00<000000=WI
f@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0=0=WIf@05
0000003IfMT0fMWI0=WIf@0000002@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI
0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03P3IfMT00`000000
fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00D0fMWI1000003C0=WIf@00[P3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003IfMT0fMWI0=WIf@80
00001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000
003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0
e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003I
fMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT00`3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WIf@030000003IfMT0
fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<000001P3IfMT50000
00P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000L0fMWI0P00
00060=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT010000000fMWI0=WIf@00
00070=WIf@8000002P3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<00000
0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00D0fMWI00<00000
0=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WI
f@030000003IfMT0fMWI00D0fMWI1000003C0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@03
0000003IfMT0fMWI00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI
0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI
0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<0
00000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WI
f@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI0`00003D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00
003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00[`3IfMT4000000L0fMWI0P0000080=WIf@030000003IfMT0fMWI00D0fMWI1@0000080=WIf@03
0000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0fMWI0P0000080=WIf@03
0000003IfMT0fMWI00T0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000
003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000
003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3I
fMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT01@3I
fMT400000=<0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT0
0`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WI
f@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<00000
0=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WI
f@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI
f@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@03
0000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@03
0000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000h0fMWI00<000000=WIf@3I
fMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3I
fMT0e03IfMT00:l0fMWI1000000>0=WIf@L00000103IfMT5000000P0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00b`3IfMT7000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0
fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI
0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI003>0=WIf@030000003IfMT0fMWI00P0fMWI1000
003C0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WI
f@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00b`3I
fMT2000000030=WIf@000000fMWI0>00fMWI003=0=WIf@800000h@3IfMT00001\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.2806 .30902 Mdot
.4796 .30902 Mdot
.7806 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT2000000<0fMWI
0P0000000`3IfMT000000000000700000280fMWI0P0000000`3IfMT000000=WIf@0Q0=WIf@T00000
0`3IfMT00`000000fMWI0=WIf@0/0=WIf@80000000<0fMWI0000003IfMT0;P3IfMT2000000<0fMWI
0P0000060=WIf@T000008`3IfMT00`000000fMWI0=WIf@0]0=WIf@8000002P3IfMT00140fMWI0P00
000`0=WIf@@00000;`3IfMT3000000030=WIf@000000000000X000008`3IfMT200000200fMWI3000
00020=WIf@030000003IfMT0fMWI02h0fMWI0P00000a0=WIf@<000001P3IfMT<000001h0fMWI1000
000`0=WIf@8000002P3IfMT007T0fMWI3`0000120=WIfA000000J`3IfMT?000005`0fMWI001h0=WI
fA000000@@3IfMTC000006P0fMWI4000001L0=WIf@00N03IfMTA00000400fMWI4@00001Z0=WIfA40
0000F`3IfMT007L0fMWI4`00000n0=WIfA<00000J03IfMTC000005X0fMWI001g0=WIfA<00000?P3I
fMTC000006P0fMWI4`00001J0=WIf@00M`3IfMTC000003h0fMWI4`00001X0=WIfA<00000FP3IfMT0
07L0fMWI4`00000n0=WIfA<00000J03IfMTC000005X0fMWI001f0=WIfA@00000?@3IfMTD000006L0
fMWI5000001J0=WIf@003@3IfMWo000009X000002P3IfMT000d0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT010000000fMWI0=WIf@3IfMTC000000P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI
0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI
0=WIf@070=WIf@030000003IfMT0fMWI01<00000203IfMT00`000000fMWI0=WIf@080=WIf@030000
003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000
003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000
003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@3IfMTC000000P0
fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0
fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0
fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@003@3IfMT00`000000fMWI
0=WIf@0`0=WIf@030000003IfMT0fMWI0300fMWI00@000000=WIf@3IfMT0fMWI4`00000L0=WIf@03
0000003IfMT0fMWI01l0fMWI4`00000a0=WIf@030000003IfMT0fMWI0300fMWI00@000000=WIf@3I
fMT0fMWI4`00000L0=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0203IfMT007L0
fMWI4`00000n0=WIfA<00000J03IfMTC000005X0fMWI001h0=WIfA400000@03IfMTA000006X0fMWI
4@00001K0=WIf@00N03IfMT@00000440fMWI4@00001Z0=WIfA000000G03IfMT007T0fMWI3`000012
0=WIfA800000J@3IfMT?000005`0fMWI001j0=WIf@`00000A@3IfMT<00000080fMWI00<000000=WI
f@3IfMT0JP3IfMT<000005h0fMWI001l0=WIf@T00000B03IfMT9000000<0fMWI00<000000=WIf@3I
fMT0K03IfMT9000005l0fMWI00200=WIf@030000003IfMT0fMWI04h0fMWI00<000000=WIf@3IfMT0
1@3IfMT00`000000fMWI0=WIf@1`0=WIf@030000003IfMT0fMWI0640fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI002_0=WIf@@000001`3IfMT2000000D0fMWI1`0000040=WIf@D0
0000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@80
00001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI0P0000070=WIf@03
0000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0
3@3IfMT01@000000fMWI0=WIf@3IfMT0000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00h0fMWI
00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00:h0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0?0=WIf@8000001@3IfMT010000000fMWI0=WI
f@3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3I
fMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI1@0000080=WIf@030000003I
fMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI
00<0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI
0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000h0fMWI0P0000030=WIf@800000103IfMT00`00
0000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@@00000403IfMT3000000H0
fMWI1@0000080=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI10000007
0=WIf@8000001P3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WI
f@3IfMT000001`3IfMT2000000X0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@050=WI
f@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I
fMT04@3IfMT00`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0fMWI
1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<0
00000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002h
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0:
0=WIf@030000003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000l0fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000l0fMWI1@0000080=WI
f@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@050=WIf@D00000
203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@800000
203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT02@3I
fMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0
fMWI00D0fMWI1000003C0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00l0fMWI00<000000=WIf@3IfMT0103IfMT010000000fMWI0=WIf@3IfMT2000000L0fMWI00<00000
0=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WI
f@030000003IfMT0fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0
2P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@00000>0=WIf@030000
003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002_0=WIf@@000003P3IfMT7000000@0fMWI1@0000080=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0=T0fMWI00<000000=WIf@3IfMT0e03IfMT00</0fMWI1`0000070=WIf@030000003IfMT0fMWI0=@0
fMWI003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<0
00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@08
0=WIf@@00000d`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3I
fMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3I
fMT00</0fMWI0P0000000`3IfMT000000=WIf@3P0=WIf@00c@3IfMT200000>40fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.2656 .30902 Mdot
.4896 .30902 Mdot
.7656 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT0:P3IfMT;000002P0fMWI
0P0000000`3IfMT000000=WIf@0U0=WIf@T00000;P3IfMT2000000030=WIf@000000fMWI02h0fMWI
0P0000030=WIf@/00000:@3IfMT00`000000fMWI0=WIf@0]0=WIf@8000002P3IfMT00140fMWI0P00
000`0=WIf@@00000;@3IfMT<000002T0fMWI0P00000T0=WIf@`00000;`3IfMT200000340fMWI3`00
000T0=WIf@@00000<03IfMT2000000X0fMWI001c0=WIf@l00000C03IfMT?00000680fMWI3`00001R
0=WIf@00LP3IfMT@000004/0fMWI4000001Q0=WIfA000000HP3IfMT00780fMWI4@00001:0=WIfA40
0000H03IfMTA00000640fMWI001a0=WIfA<00000B03IfMTC000005h0fMWI4`00001P0=WIf@00L@3I
fMTC000004P0fMWI4`00001N0=WIfA<00000H03IfMT00740fMWI4`0000180=WIfA<00000GP3IfMTC
00000600fMWI001a0=WIfA<00000B03IfMTC000005h0fMWI4`00001P0=WIf@00L03IfMTD000004L0
fMWI5000001M0=WIfA@00000H03IfMT000d0fMWIo`00002J000000X0fMWI000=0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00D0fMWI4`0000040=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00@0fMWI4`0000040=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@050=WIfA<00000103I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3I
fMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203I
fMT000d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0^0=WIfA<000008P3IfMT0
0`000000fMWI0=WIf@0S0=WIfA<00000;@3IfMT00`000000fMWI0=WIf@0^0=WIfA<000008P3IfMT0
0`000000fMWI0=WIf@0`0=WIf@030000003IfMT0fMWI00P0fMWI001a0=WIfA<00000B03IfMTC0000
05h0fMWI4`00001P0=WIf@00LP3IfMTA000004X0fMWI4@00001P0=WIfA400000H@3IfMT00780fMWI
4000001;0=WIfA000000H@3IfMT@00000680fMWI001c0=WIf@l00000C03IfMT?00000680fMWI3`00
001R0=WIf@00M03IfMT<000004l0fMWI3000001U0=WIf@`00000I03IfMT007H0fMWI2@00001B0=WI
f@T00000J03IfMT9000006D0fMWI001j0=WIf@030000003IfMT0fMWI05P0fMWI00D000000=WIf@3I
fMT0fMWI0000001/0=WIf@030000003IfMT0fMWI06L0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI002_0=WIf@@000001`3IfMT2000000D0fMWI1`0000040=WIf@D00000203IfMT0
0`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@8000001P3IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI0P0000070=WIf@030000003IfMT0
fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03@3IfMT01@00
0000fMWI0=WIf@3IfMT0000000T0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WI
f@3IfMT02P3IfMT00`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00:h0fMWI00<000000=WIf@3I
fMT00P3IfMT00`000000fMWI0=WIf@0?0=WIf@8000001@3IfMT010000000fMWI0=WIf@3IfMT20000
00L0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000
fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0
fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0;0=WIf@030000003IfMT0fMWI00<0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_
0=WIf@040000003IfMT0fMWI000000h0fMWI0P0000030=WIf@800000103IfMT00`000000fMWI0=WI
f@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@@00000403IfMT3000000H0fMWI1@000008
0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI100000070=WIf@800000
1P3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WIf@3IfMT00000
1`3IfMT2000000X0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003I
fMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT00`000000fMWI0=WIf@050=WIf@030000003I
fMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT04@3IfMT0
0`000000fMWI0=WIf@050=WIf@@00000d`3IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0<0=WIf@040000003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0fMWI1@0000080=WI
f@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I
fMT0303IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000
003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000l0fMWI00<000000=WIf@3IfMT0
2P3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT4000000l0fMWI1@0000080=WIf@<00000e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI
003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WI
f@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000
e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@050=WIf@D00000203IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@0000070=WIf@800000203IfMT00`00
0000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000
fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000
fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00D0fMWI
1000003C0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<0
00000=WIf@3IfMT0103IfMT010000000fMWI0=WIf@3IfMT2000000L0fMWI00<000000=WIf@3IfMT0
e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003I
fMT0fMWI00<0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0
fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT02P3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@00000>0=WIf@030000003IfMT0fMWI
00<0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI
0=@0fMWI002_0=WIf@@000003P3IfMT7000000@0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00</0fMWI1`0000070=WIf@030000003IfMT0fMWI0=@0fMWI003>0=WI
f@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<000000=WIf@3I
fMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@@00000
d`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT0
0<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00<h0fMWI00<000000=WIf@3IfMT0g`3IfMT00</0fMWI
0P0000000`3IfMT000000=WIf@3P0=WIf@00c@3IfMT200000>40fMWI0000\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.25 .30902 Mdot
.5 .30902 Mdot
.75 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@800000203IfMT00`000000fMWI0=WIf@05
0=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT010000000fMWI0=WIf@000007
0=WIf@800000203IfMT00`000000fMWI0=WIf@090=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<000000=WI
f@3IfMT02@3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@03
0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@090=WIf@03
0000003IfMT0fMWI00D0fMWI1000003C0=WIf@00Y@3IfMT3000000H0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00@0fMWI00@000000=WIf@3IfMT0
fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI
00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@030=WIf@D00000203IfMT00`000000fMWI
0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<0
00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002^
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0403IfMT00`000000fMWI0=WIf@03
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WI
f@3IfMT000003P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000h0fMWI1`0000040=WI
f@D00000203IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000
003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0
fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI002i0=WIf@@000001`3IfMT2000000H0fMWI1@0000080=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@040000003IfMT0fMWI000000L0fMWI0P00000:0=WIf@800000
1`3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT00`000000fMWI0=WIf@020=WIf@030000003I
fMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^03IfMT0
0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0140fMWI00<000000=WIf@3IfMT01@3IfMT4
00000=<0fMWI002_0=WIf@<000001P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI
00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0fMWI002h0=WI
f@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0303IfMT5000000P0fMWI00<000000=WI
f@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@03
0000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000
003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000050=WIf@L00000103IfMT5000000P0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000001`3IfMT2000000H0
fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@060=WIf@8000001`3IfMT00`000000
fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00d0fMWI
00D000000=WIf@3IfMT0fMWI000000090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I
fMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000
003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT01@3IfMT400000=<0fMWI002U0=WIf@<000001P3I
fMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000003I
fMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WI
f@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<0
00000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A
0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D
0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WI
f@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WI
f@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P0000040=WI
f@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WIf@<0
00001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3I
fMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI
0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI000@0=WIf@@00000;`3IfMT4000002d0fMWI1`00000/
0=WIf@L00000:`3IfMT00`000000fMWI0=WIf@0/0=WIf@L00000;03IfMT7000002h0fMWI1000000_
0=WIf@@000002@3IfMT00180fMWI00<000000=WIf@3IfMT0;@3IfMT010000000fMWI0=WIf@3IfMT2
000002d0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0
fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0^0=WIf@030000003IfMT0
fMWI0080fMWI00<000000=WIf@3IfMT0:`3IfMT010000000fMWI0=WIf@3IfMT200000300fMWI00<0
00000=WIf@3IfMT0203IfMT000h0fMWI1P00000c0=WIf@030000003IfMT0fMWI02`0fMWI00D00000
0=WIf@3IfMT0fMWI0000000_0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3I
fMT00`000000fMWI0=WIf@0_0=WIf@050000003IfMT0fMWI0=WIf@000000<P3IfMT00`000000fMWI
0=WIf@0Z0=WIf@H000002@3IfMT000h0fMWI00D000000=WIf@3IfMT0fMWI0000000d0=WIf@030000
003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0/0=WIf@030000
003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0<03IfMT00`000000fMWI0=WIf@0c0=WIf@030000
003IfMT0fMWI02X0fMWI00D000000=WIf@3IfMT0fMWI0000000:0=WIf@001P3IfMT3000000H0fMWI
00@000000=WIf@3IfMT000009P3IfMT3000000X0fMWI0P00000T0=WIf@<000002@3IfMT2000002D0
fMWI0`0000080=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0;`3IfMT00`000000
fMWI0=WIf@0a0=WIf@800000<P3IfMT2000002d0fMWI00@000000=WIf@3IfMT000002P3IfMT000l0
fMWI00@000000=WIf@3IfMT00000<P3IfMT200000380fMWI00<000000=WIf@3IfMT0;P3IfMT00`00
0000fMWI0=WIf@0/0=WIf@<00000;`3IfMT00`000000fMWI0=WIf@0b0=WIf@030000003IfMT0fMWI
02l0fMWI0P00000^0=WIf@040000003IfMT0fMWI000000X0fMWI000@0=WIf@030000003IfMT00000
03<0fMWI0P00000b0=WIf@030000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0;03IfMT00`00
0000fMWI0=WIf@0_0=WIf@030000003IfMT0fMWI03<0fMWI00<000000=WIf@3IfMT0;`3IfMT20000
02h0fMWI00<000000=WIf@0000002P3IfMT00100fMWI00<000000=WIf@000000=03IfMT00`000000
fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@0/0=WIf@030000003IfMT0fMWI02l0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000
fMWI0=WIf@030=WIf@030000003IfMT0fMWI0300fMWI00<000000=WIf@3IfMT0;03IfMT00`000000
fMWI0000000:0=WIf@004@3IfMT2000003@0fMWI00<000000=WIf@3IfMT09@3IfMT9000000030=WI
f@000000000002`0fMWI0P0000000`3IfMT000000=WIf@0Z0=WIf@T00000:@3IfMT2000000030=WI
f@000000fMWI02h0fMWI2P00000_0=WIf@030000003IfMT0fMWI02d0fMWI0P00000:0=WIf@004@3I
fMT200000300fMWI1000000V0=WIf@`00000<03IfMT2000002T0fMWI3000000Z0=WIf@800000;P3I
fMT<000002X0fMWI1000000`0=WIf@8000002P3IfMT006`0fMWI3`00001H0=WIf@l00000E`3IfMT?
000006P0fMWI001[0=WIfA000000E`3IfMT@000005H0fMWI4000001X0=WIf@00J`3IfMTA000005H0
fMWI4@00001E0=WIfA400000I`3IfMT006X0fMWI4`00001D0=WIfA<00000D`3IfMTC000006H0fMWI
001Z0=WIfA<00000E03IfMTC000005<0fMWI4`00001V0=WIf@00JP3IfMTC000005@0fMWI4`00001C
0=WIfA<00000IP3IfMT006X0fMWI4`00001D0=WIfA<00000D`3IfMTC000006H0fMWI001Y0=WIfA@0
0000D`3IfMTD00000580fMWI5000001V0=WIf@003@3IfMWo000009X000002P3IfMT000d0fMWI00<0
00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI00<0
00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<0
00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI5@00
000:0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI
f@070=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@0000004P00000:0=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00P0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003I
fMT0fMWI00L0fMWI00<000000=WIf@0000004`0000090=WIf@030000003IfMT0fMWI00L0fMWI00<0
00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00P0fMWI00<0
00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0fMWI00L0fMWI00<0
00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@080=WIf@003@3IfMT00`000000fMWI0=WIf@0`
0=WIf@030000003IfMT0fMWI02L0fMWI4`00000Y0=WIf@030000003IfMT0fMWI02P0fMWI4`00000X
0=WIf@030000003IfMT0fMWI02P0fMWI4`00000X0=WIf@030000003IfMT0fMWI0300fMWI00<00000
0=WIf@3IfMT0203IfMT006X0fMWI4`00001D0=WIfA<00000D`3IfMTC000006H0fMWI001[0=WIfA40
0000EP3IfMTA000005D0fMWI4@00001W0=WIf@00J`3IfMT@000005L0fMWI4000001F0=WIfA000000
J03IfMT006`0fMWI3`00001H0=WIf@l00000E`3IfMT?000006P0fMWI001]0=WIf@`00000F`3IfMT<
000005X0fMWI3000001Z0=WIf@00K`3IfMT9000005h0fMWI2@00001M0=WIf@T00000J`3IfMT007<0
fMWI00<000000=WIf@3IfMT0H`3IfMT2000006D0fMWI00<000000=WIf@3IfMT0K@3IfMT00=T0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI100000070=WIf@8000001@3IfMT70000
00@0fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI0000
00L0fMWI0P0000060=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT01P3IfMT20000
00L0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000
fMWI0=WIf@0=0=WIf@050000003IfMT0fMWI0=WIf@0000002@3IfMT00`000000fMWI0=WIf@050=WI
f@030000003IfMT0fMWI0=@0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I
fMT03P3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00D0fMWI1000003C0=WIf@00
[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI0P0000050=WIf@040000
003IfMT0fMWI0=WIf@8000001`3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI
0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI
00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI
f@0A0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WI
f@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00/0fMWI00<00000
0=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<00000
0=WIf@3IfMT0e03IfMT00:l0fMWI00@000000=WIf@3IfMT000003P3IfMT2000000<0fMWI0P000004
0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000@0=WI
f@<000001P3IfMT5000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WI
f@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3I
fMT4000000L0fMWI0P0000060=WIf@D00000203IfMT00`000000fMWI0=WIf@3D0=WIf@00^@3IfMT0
10000000fMWI0=WIf@0000070=WIf@8000002P3IfMT2000000L0fMWI00<000000=WIf@3IfMT0e03I
fMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0A0=WIf@030000003IfMT0
fMWI00D0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`00
0000fMWI0=WIf@0A0=WIf@030000003IfMT0fMWI00D0fMWI1000003C0=WIf@00^03IfMT00`000000
fMWI0=WIf@020=WIf@030000003IfMT0fMWI00`0fMWI00@000000=WIf@3IfMT0fMWI0P0000070=WI
f@030000003IfMT0fMWI0=@0fMWI002h0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I
fMT0303IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT00;P0fMWI00<000000=WIf@3IfMT0
0P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0
e03IfMT00;P0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003I
fMT0fMWI00X0fMWI00<000000=WIf@3IfMT0e03IfMT00;T0fMWI00@000000=WIf@3IfMT000003`3I
fMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002i0=WIf@@000003`3IfMT5
000000P0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@03
0000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003I
fMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI
0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<0
00000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WI
f@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0
e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`00
0000fMWI0=WIf@3D0=WIf@00[`3IfMT4000000L0fMWI0P0000080=WIf@030000003IfMT0fMWI00D0
fMWI1@0000080=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000L0
fMWI0P0000080=WIf@030000003IfMT0fMWI00T0fMWI0P0000070=WIf@030000003IfMT0fMWI0=@0
fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03`3IfMT00`000000fMWI
0=WIf@090=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0e03IfMT00:h0fMWI00<0
00000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0?0=WIf@030000003IfMT0fMWI00T0fMWI00<0
00000=WIf@3IfMT01@3IfMT400000=<0fMWI002^0=WIf@030000003IfMT0fMWI0080fMWI00<00000
0=WIf@3IfMT03`3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI0=WIf@8000001`3I
fMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0
fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT5000000P0fMWI00<000000=WIf@3IfMT0e03IfMT0
0:h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0@0=WIf@030000003IfMT0fMWI
00<0fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@3D0=WIf@00[P3IfMT00`000000
fMWI0=WIf@020=WIf@030000003IfMT0fMWI0100fMWI00<000000=WIf@3IfMT00`3IfMT00`000000
fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI0=@0fMWI002_0=WIf@040000003IfMT0fMWI000000h0
fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0
fMWI00<000000=WIf@3IfMT0e03IfMT00:l0fMWI1000000>0=WIf@L00000103IfMT5000000P0fMWI
00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D
0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00
f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT3
00000=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@030000003IfMT0fMWI0=@0fMWI003I
0=WIf@030000003IfMT0fMWI0=@0fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03I
fMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0
fMWI0`00003D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT7000000L0fMWI00<000000=WI
f@3IfMT0e03IfMT00<h0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00
cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI003>0=WIf@030000003I
fMT0fMWI00P0fMWI1000003C0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`00
0000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI0=WIf@3O0=WIf@00cP3IfMT00`000000fMWI
0=WIf@3O0=WIf@00b`3IfMT2000000030=WIf@000000fMWI0>00fMWI003=0=WIf@800000h@3IfMT0
0001\
\>"],
  ImageRangeCache->{{{0, 287.312}, {177.25, 0}} -> {-4.26595, -1.0535, \
0.0293866, 0.0118871}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.309017 0.309017 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.375 .29652 -6 -9 ]
[.375 .29652 6 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-4)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-3)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-2)] .25 .29652 0 1 Mshowa
.375 .30902 m
.375 .31527 L
s
[(-1)] .375 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(1)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(2)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(3)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(4)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.05 w
.2344 .30902 Mdot
.5104 .30902 Mdot
.7344 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3IfMVa
0=WIf@00o`3IfMVa0=WIf@00o`3IfMVa0=WIf@00b`3IfMT700000=h0fMWI003>0=WIf@030000003I
fMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI0=l0fMWI003>0=WIf@030000003IfMT0fMWI
00P0fMWI1000003C0=WIf@00``3IfMT3000000P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000
fMWI0=WIf@3D0=WIf@00cP3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0=@0fMWI
003>0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0e03IfMT00<h0fMWI00<00000
0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3D0=WIf@00b`3IfMT2000000030=WIf@000000fMWI
00T0fMWI00<000000=WIf@3IfMT0e03IfMT00<d0fMWI0P00000:0=WIf@030000003IfMT0fMWI0=@0
fMWI003I0=WIf@<00000e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<00000
0=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI00<000000=WIf@3I
fMT0e03IfMT00=T0fMWI00<000000=WIf@3IfMT0e03IfMT00=T0fMWI0`00003D0=WIf@00f@3IfMT0
0`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000
fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WIf@3D0=WIf@00f@3IfMT00`000000fMWI0=WI
f@3D0=WIf@00f@3IfMT300000=@0fMWI003I0=WIf@030