(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2731280,      65569]*)
(*NotebookOutlinePosition[   2748599,      66217]*)
(*  CellTagsIndexPosition[   2748507,      66211]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Setup and definitions:", "Section",
  InitializationCell->True],

Cell[BoxData[
    \(Needs["\<Graphics`Graphics`\>"]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"colors", "=", 
        RowBox[{\({red, green, blue, cyan, magenta, yellow}\), "=", "\n", 
          "\t", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"RGBColor", 
                StyleBox["[",
                  FontSlant->"Italic"], 
                StyleBox[\(1, 0, 0\),
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontSlant->"Italic"]}], "\n", "\t", ",", 
              RowBox[{"RGBColor", 
                StyleBox["[",
                  FontSlant->"Italic"], 
                StyleBox[\(0, 1, 0\),
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontSlant->"Italic"]}], "\n", "\t", ",", 
              RowBox[{"RGBColor", 
                StyleBox["[",
                  FontSlant->"Italic"], 
                StyleBox[\(0, 0, 1\),
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontSlant->"Italic"]}], "\n", "\t", ",", 
              RowBox[{"RGBColor", 
                StyleBox["[",
                  FontSlant->"Italic"], 
                StyleBox[\(0, 1, 1\),
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontSlant->"Italic"]}], "\n", "\t", ",", 
              RowBox[{"RGBColor", 
                StyleBox["[",
                  FontSlant->"Italic"], 
                StyleBox[\(1, 0, 1\),
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontSlant->"Italic"]}], "\n", "\t", ",", 
              RowBox[{"RGBColor", 
                StyleBox["[",
                  FontSlant->"Italic"], 
                StyleBox[\(1, 1, 0\),
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontSlant->"Italic"]}]}], "\n", "\t", "}"}]}]}], ";", 
      "\n", \(Plot[\ Table[i\ x, {i, 1, 6}]\  // Evaluate, \ {x, 0, 1}, 
        PlotStyle -> colors]\), ";"}]], "Input",
  InitializationCell->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0981006 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .11282 -6 -4.5 ]
[.01131 .11282 0 4.5 ]
[.01131 .21092 -6 -4.5 ]
[.01131 .21092 0 4.5 ]
[.01131 .30902 -6 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .40712 -6 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .50522 -6 -4.5 ]
[.01131 .50522 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11282 m
.03006 .11282 L
s
[(1)] .01131 .11282 1 0 Mshowa
.02381 .21092 m
.03006 .21092 L
s
[(2)] .01131 .21092 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(3)] .01131 .30902 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(4)] .01131 .40712 1 0 Mshowa
.02381 .50522 m
.03006 .50522 L
s
[(5)] .01131 .50522 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(6)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .0932 m
.02756 .0932 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .17168 m
.02756 .17168 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .32864 m
.02756 .32864 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .56408 m
.02756 .56408 L
s
.02381 .5837 m
.02756 .5837 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.06244 .01869 L
.10458 .02303 L
.14415 .02711 L
.18221 .03103 L
.22272 .0352 L
.26171 .03922 L
.30316 .04349 L
.34309 .0476 L
.3815 .05156 L
.42237 .05577 L
.46172 .05982 L
.49955 .06372 L
.53984 .06787 L
.57861 .07186 L
.61984 .07611 L
.65954 .0802 L
.69774 .08413 L
.73838 .08832 L
.77751 .09235 L
.81909 .09663 L
.85916 .10076 L
.89771 .10473 L
.93871 .10896 L
.97619 .11282 L
s
0 1 0 r
.02381 .01472 m
.06244 .02267 L
.10458 .03135 L
.14415 .03951 L
.18221 .04735 L
.22272 .05569 L
.26171 .06373 L
.30316 .07226 L
.34309 .08049 L
.3815 .0884 L
.42237 .09682 L
.46172 .10493 L
.49955 .11272 L
.53984 .12102 L
.57861 .12901 L
.61984 .1375 L
.65954 .14568 L
.69774 .15355 L
.73838 .16193 L
.77751 .16999 L
.81909 .17855 L
.85916 .18681 L
.89771 .19475 L
.93871 .2032 L
.97619 .21092 L
s
0 0 1 r
.02381 .01472 m
.06244 .02665 L
.10458 .03967 L
.14415 .0519 L
.18221 .06366 L
.22272 .07618 L
.26171 .08823 L
.30316 .10104 L
.34309 .11338 L
.3815 .12525 L
.42237 .13788 L
.46172 .15004 L
.49955 .16173 L
.53984 .17418 L
.57861 .18616 L
.61984 .1989 L
.65954 .21117 L
.69774 .22297 L
.73838 .23553 L
.77751 .24762 L
.81909 .26047 L
.85916 .27285 L
.89771 .28477 L
.93871 .29744 L
.97619 .30902 L
s
0 1 1 r
.02381 .01472 m
.06244 .03063 L
.10458 .04799 L
.14415 .0643 L
.18221 .07998 L
.22272 .09667 L
.26171 .11274 L
.30316 .12981 L
.34309 .14626 L
.3815 .16209 L
.42237 .17893 L
.46172 .19514 L
.49955 .21073 L
.53984 .22733 L
.57861 .24331 L
.61984 .26029 L
.65954 .27665 L
.69774 .29239 L
.73838 .30914 L
.77751 .32526 L
.81909 .34239 L
.85916 .3589 L
.89771 .37478 L
.93871 .39168 L
.97619 .40712 L
s
1 0 1 r
.02381 .01472 m
.06244 .03461 L
.10458 .05631 L
.14415 .07669 L
.18221 .09629 L
.22272 .11716 L
.26171 .13724 L
.30316 .15859 L
.34309 .17915 L
.3815 .19894 L
.42237 .21998 L
.46172 .24025 L
.49955 .25974 L
.53984 .28049 L
.57861 .30045 L
.61984 .32169 L
.65954 .34214 L
.69774 .36181 L
.73838 .38274 L
.77751 .40289 L
.81909 .42431 L
.85916 .44494 L
.89771 .4648 L
.93871 .48592 L
.97619 .50522 L
s
1 1 0 r
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00?03oool2000000@0oooo00<000000?ooo`3oool00P3oool4000002D0
oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08`3oool2000000@0
oooo00<000000?ooo`3oool00`3oool2000002H0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0P00000[0?ooo`@00000303oool003/0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`0U0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool08P3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000002@0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`00000/0?ooo`030000003oool0oooo00/0oooo000k0?ooo`040000
003oool0oooo000000T0oooo00<000000?ooo`3oool0903oool010000000oooo0?ooo`0000070?oo
o`D000008`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000002@0oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`00000/0?ooo`030000003oool0oooo00/0
oooo000k0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool08`3oool010000000
oooo0?ooo`0000070?ooo`040000003oool0oooo000002@0oooo00@000000?ooo`3oool00000203o
ool3000002D0oooo00@000000?ooo`3oool000002@3oool2000002d0oooo00<000000?ooo`3oool0
2`3oool003/0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0R0?ooo`040000
003oool0oooo000000P0oooo00<000000?ooo`000000903oool010000000oooo0?ooo`0000080?oo
o`030000003oool0oooo02D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
000/0?ooo`030000003oool0oooo00/0oooo000k0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool00000903oool010000000oooo0?ooo`0000090?ooo`800000903oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo02D0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`00000Z0?ooo`<000003@3oool000l0oooo00<000000?ooo`3oool0:P3oool2
000000X0oooo0P00000V0?ooo`8000002`3oool00`000000oooo0?ooo`0S0?ooo`8000002P3oool3
000002D0oooo0P00000:0?ooo`800000;@3oool00`000000oooo0?ooo`0;0?ooo`003`3oool00`00
0000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo
00<000000?ooo`3oool0o`3oool?0?ooo`002@3oool6000000030?oo0000ool00?l00080o`00o`00
0006000000L0oooo000?0?ooo`050000003oo`00ool0003oo`000?l00`00o`080?l000X0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02`3oool000l0oooo00<000000?ooo`3oool00P3oo`02003oo`80003o1000o`03
0?ooo``0o`00603oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0300oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00/0oooo000?0?oo
o`030000003oool0oooo0080oooo00@0ool00?l0o`00ool00?oo0`000?l00`3oool00?l0003o0004
003o00T0oooo2P3o003[0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`80ool000@0o`3o003o
o`00ool00?oo0`000?l40?ooo`D00?l03P3oool80?l00><0oooo000?0?ooo`8000001P3oool20?oo
00050?l0o`3oool00?oo003oo`3oool00`000?l60?ooo`@00?l04P3oool60?l00=d0oooo000?0?oo
o`030000003oool0oooo00L0oooo00@0ool00?l0o`3o0?l0oooo0P00ool20?ooo`<0003o1`3oool4
003o01@0oooo203o003E0?ooo`003`3oool00`000000oooo0?ooo`080?ooo`80ool00P3o0?l0103o
ool00?oo003oo`00ool20?ooo`<0003o203oool4003o01P0oooo2`3o003:0?ooo`003`3oool00`00
0000oooo0?ooo`0:0?ooo`040?oo003oool0o`3o0?l0o`80oooo0P00ool30?ooo`@0003o203oool5
003o01h0oooo2`3o002o0?ooo`003`3oool00`000000oooo0?ooo`0;0?ooo`80ool000<0oooo0?l0
o`3o0?l00P3oool3003oo`@0oooo10000?l90?ooo`D00?l0903oool:0?l00;D0oooo000?0?ooo`03
0000003oool0oooo00d0oooo00<0ool00?ooo`3oool00P3o0?l30?ooo`<00?oo1@3oool30000o`/0
oooo1P00o`0X0?ooo`/0o`00ZP3oool000l0oooo0P00000?0?ooo`80ool00P3oool20?l0o`@0oooo
0P00ool60?ooo`<0003o3P3oool5003o02h0oooo2`3o002O0?ooo`003`3oool00`000000oooo0?oo
o`0@0?ooo`040?oo003oool0oooo0?ooo`80o`3o103oool3003oo`H0oooo10000?l?0?ooo`H00?l0
<`3oool:0?l009D0oooo000?0?ooo`030000003oool0oooo0140oooo0P3oo`030?ooo`80o`3o1@3o
ool2003oo`P0oooo0`000?lB0?ooo`@00?l0>@3oool;0?l008X0oooo000?0?ooo`030000003oool0
oooo01<0oooo00<0ool00?ooo`3oool00P3oool20?l0o`D0oooo0P00ool90?ooo`<0003o4`3oool4
003o0400oooo2`3o001o0?ooo`003`3oool00`000000oooo0?ooo`0D0?ooo`80ool0103oool20?l0
o`D0oooo0P00ool:0?ooo`80003o5@3oool4003o04L0oooo203o001g0?ooo`003`3oool2000001L0
oooo0P3oo`040?ooo`80o`3o1@3oool2003oo`X0oooo0`000?lF0?ooo`@00?l0B`3oool60?l00740
oooo000?0?ooo`030000003oool0oooo01P0oooo0P3oo`040?ooo`030?l0o`3oool0oooo00@0oooo
0P00ool;0?ooo`<0003o5`3oool6003o04/0oooo203o001Y0?ooo`003`3oool00`000000oooo0?oo
o`0J0?ooo`80ool00`3oool20?l0o`H0oooo0`00ool;0?ooo`@0003o6@3oool5003o04h0oooo2P3o
001O0?ooo`003`3oool00`000000oooo0?ooo`0L0?ooo`80ool00`3oool20?l0o`L0oooo0`00ool<
0?ooo`@0003o6P3oool5003o05<0oooo2`3o001D0?ooo`003`3oool00`000000oooo0?ooo`0N0?oo
o`030?oo003oool0oooo0080oooo0P3o0?l80?ooo`800?oo3P3oool30000oa`0oooo1@00o`1I0?oo
o`/0o`00B@3oool000l0oooo0P00000P0?ooo`80ool0103oool20?l0o`P0oooo0`00ool>0?ooo`@0
003o7@3oool6003o05h0oooo2`3o000n0?ooo`003`3oool00`000000oooo0?ooo`0Q0?ooo`030?oo
003oool0oooo00<0oooo0P3o0?l90?ooo`<00?oo3`3oool40000oal0oooo1@00o`1T0?ooo`/0o`00
<`3oool000l0oooo00<000000?ooo`3oool08P3oool00`3oo`00oooo0?ooo`040?ooo`80o`3o2P3o
ool2003ooa40oooo0`000?lQ0?ooo`H00?l0J@3oool;0?l002P0oooo000?0?ooo`030000003oool0
oooo02<0oooo0P3oo`060?ooo`80o`3o2P3oool2003ooa80oooo0`000?lT0?ooo`@00?l0L03oool8
0?l00200oooo00070?ooo`@00000103oool00`000000oooo0?ooo`0U0?ooo`030?oo003oool0oooo
00D0oooo0P3o0?l:0?ooo`800?oo4`3oool20000obH0oooo0`00o`1e0?ooo`H0o`006P3oool000T0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0V0?ooo`80ool01`3oool20?l0o`X0
oooo0P00oolC0?ooo`<0003o9P3oool4003o07L0oooo1`3o000C0?ooo`002@3oool00`000000oooo
0?ooo`030?ooo`<00000:03oool00`3oo`00oooo0?ooo`060?ooo`80o`3o2P3oool3003ooa<0oooo
0`000?lW0?ooo`@00?l0NP3oool60?l000d0oooo00090?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0:@3oool20?oo00P0oooo0P3o0?l;0?ooo`<00?oo4`3oool30000obP0oooo1P00
o`270?ooo`002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02/0oooo0P3oo`08
0?ooo`80o`3o303oool2003ooa@0oooo10000?lZ0?ooo`D00?l0PP3oool000L0oooo0`0000050?oo
o`030000003oool0oooo02d0oooo0P3oo`080?ooo`80o`3o303oool3003ooaD0oooo0`000?l/0?oo
o`H00?l0O03oool000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0_0?ooo`80
ool0203oool20?l0o`d0oooo0`00oolE0?ooo`@0003o;P3oool5003o07L0oooo000?0?ooo`800000
<P3oool20?oo00P0oooo0P3o0?l>0?ooo`800?oo5`3oool40000obl0oooo1P00o`1a0?ooo`003`3o
ool00`000000oooo0?ooo`0c0?ooo`030?oo003oool0oooo00L0oooo0P3o0?l>0?ooo`800?oo6@3o
ool30000oc80oooo1000o`1]0?ooo`003`3oool00`000000oooo0?ooo`0d0?ooo`80ool02@3oool2
0?l0o`h0oooo0P00oolJ0?ooo`<0003o<`3oool4003o06T0oooo000?0?ooo`030000003oool0oooo
03H0oooo00<0ool00?ooo`3oool0203oool20?l0o`h0oooo0P00oolK0?ooo`80003o=@3oool4003o
06D0oooo000?0?ooo`030000003oool0oooo03L0oooo0P3oo`0:0?ooo`80o`3o3P3oool3003ooaX0
oooo0`000?lf0?ooo`@00?l0H@3oool000l0oooo0P00000j0?ooo`80ool02P3oool20?l0o`l0oooo
0P00oolK0?ooo`<0003o=`3oool5003o05`0oooo000?0?ooo`030000003oool0oooo03/0oooo00<0
ool00?ooo`3oool02@3oool20?l0o`l0oooo0`00oolK0?ooo`<0003o>@3oool5003o05L0oooo000?
0?ooo`030000003oool0oooo03`0oooo0P3oo`0;0?ooo`030?l0o`3oool0oooo00l0oooo0P00oolL
0?ooo`@0003o>P3oool6003o0540oooo000?0?ooo`030000003oool0oooo03h0oooo00<0ool00?oo
o`3oool02@3oool20?l0oa40oooo0`00oolM0?ooo`<0003o?@3oool5003o04`0oooo000?0?ooo`03
0000003oool0oooo03l0oooo0P3oo`0;0?ooo`80o`3o4P3oool2003ooah0oooo10000?ln0?ooo`H0
0?l0AP3oool000l0oooo00<000000?ooo`3oool0@@3oool00`3oo`00oooo0?ooo`0:0?ooo`80o`3o
4P3oool2003oob00oooo10000?m00?ooo`@00?l0@P3oool000l0oooo0P0000130?ooo`80ool0303o
ool20?l0oa80oooo0P00oolR0?ooo`<0003o@@3oool4003o03h0oooo000?0?ooo`030000003oool0
oooo04@0oooo0P3oo`0<0?ooo`80o`3o4P3oool2003oob<0oooo0`000?m20?ooo`@00?l0>P3oool0
00l0oooo00<000000?ooo`3oool0AP3oool00`3oo`00oooo0?ooo`0;0?ooo`030?l0o`3oool0oooo
0140oooo0`00oolS0?ooo`80003oA03oool4003o03H0oooo000?0?ooo`030000003oool0oooo04L0
oooo0P3oo`0<0?ooo`80o`3o503oool3003oob80oooo0`000?m50?ooo`H00?l0<03oool000l0oooo
00<000000?ooo`3oool0B@3oool00`3oo`00oooo0?ooo`0;0?ooo`80o`3o5@3oool2003oob<0oooo
0`000?m80?ooo`D00?l0:`3oool000l0oooo0P00001;0?ooo`80ool03@3oool20?l0oaD0oooo0`00
oolS0?ooo`@0003oB@3oool6003o02D0oooo000?0?ooo`030000003oool0oooo04`0oooo00<0ool0
0?ooo`3oool0303oool20?l0oaH0oooo0`00oolT0?ooo`@0003oB`3oool5003o0200oooo000?0?oo
o`030000003oool0oooo04d0oooo0P3oo`0>0?ooo`80o`3o5`3oool2003oobH0oooo0`000?m=0?oo
o`H00?l06P3oool000L0oooo100000040?ooo`030000003oool0oooo04l0oooo0P3oo`0>0?ooo`80
o`3o5`3oool3003oobH0oooo10000?m?0?ooo`D00?l05@3oool000L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1A0?ooo`030?oo003oool0oooo00d0oooo0P3o0?lH0?ooo`800?oo
:03oool40000oe00oooo1@00o`0@0?ooo`00203oool00`000000oooo0?ooo`040?ooo`<00000DP3o
ool20?oo00l0oooo0P3o0?lH0?ooo`<00?oo:@3oool30000oe80oooo0`00o`0=0?ooo`002@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo05@0oooo00<0ool00?ooo`3oool03P3oool2
0?l0oaT0oooo0P00oolZ0?ooo`80003oH03oool000X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`1E0?ooo`80ool0403oool20?l0oaT0oooo0P00oolZ0?ooo`<0003oG@3oool000L0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1G0?ooo`80ool0403oool20?l0
oaT0oooo0P00ool[0?ooo`80003oF`3oool000P0oooo0P0000050?ooo`030000003oool0oooo05T0
oooo00<0ool00?ooo`3oool03`3oool20?l0oaT0oooo0P00ool[0?ooo`<0003oF03oool000l0oooo
00<000000?ooo`3oool0FP3oool20?oo0140oooo0P3o0?lI0?ooo`<00?oo:`3oool40000oe@0oooo
000?0?ooo`800000G@3oool20?oo0140oooo0P3o0?lJ0?ooo`<00?oo;03oool40000oe00oooo000?
0?ooo`030000003oool0oooo05h0oooo00<0ool00?ooo`3oool0403oool20?l0oa/0oooo0P00ool^
0?ooo`<0003oC@3oool000l0oooo00<000000?ooo`3oool0G`3oool20?oo0180oooo0P3o0?lK0?oo
o`<00?oo;P3oool40000odT0oooo000?0?ooo`030000003oool0oooo0640oooo00<0ool00?ooo`3o
ool04@3oool20?l0oa`0oooo0`00ool_0?ooo`@0003oA@3oool000l0oooo00<000000?ooo`3oool0
HP3oool20?oo01<0oooo0P3o0?lM0?ooo`800?oo<@3oool30000od80oooo000?0?ooo`800000I@3o
ool20?oo01<0oooo00<0o`3o0?ooo`3oool0703oool2003ooc80oooo0`000?lo0?ooo`003`3oool0
0`000000oooo0?ooo`1V0?ooo`030?oo003oool0oooo0140oooo0P3o0?lN0?ooo`800?oo<`3oool2
0000ocd0oooo000?0?ooo`030000003oool0oooo06L0oooo0P3oo`0C0?ooo`80o`3o7P3oool2003o
oc<0oooo0`000?lj0?ooo`003`3oool00`000000oooo0?ooo`1Y0?ooo`030?oo003oool0oooo0180
oooo0P3o0?lN0?ooo`<00?oo<`3oool30000ocL0oooo000?0?ooo`030000003oool0oooo06X0oooo
0P3oo`0D0?ooo`80o`3o7`3oool3003ooc<0oooo10000?lc0?ooo`003`3oool2000006d0oooo00<0
ool00?ooo`3oool04`3oool20?l0ob00oooo0P00oole0?ooo`@0003o;`3oool000l0oooo00<00000
0?ooo`3oool0K@3oool20?oo01D0oooo0P3o0?lP0?ooo`<00?oo=P3oool30000ob`0oooo000?0?oo
o`030000003oool0oooo06l0oooo0P3oo`0E0?ooo`80o`3o8@3oool3003oocH0oooo10000?lX0?oo
o`003`3oool00`000000oooo0?ooo`1a0?ooo`030?oo003oool0oooo01@0oooo0P3o0?lR0?ooo`80
0?oo>03oool40000ob@0oooo000?0?ooo`030000003oool0oooo0780oooo0P3oo`0F0?ooo`80o`3o
8P3oool3003oocT0oooo0`000?lQ0?ooo`003`3oool00`000000oooo0?ooo`1d0?ooo`030?oo003o
ool0oooo01D0oooo0P3o0?lS0?ooo`800?oo>P3oool30000oah0oooo000?0?ooo`800000MP3oool2
0?oo01L0oooo0P3o0?lS0?ooo`<00?oo>P3oool20000oa`0oooo000?0?ooo`030000003oool0oooo
07L0oooo0P3oo`0G0?ooo`80o`3o903oool2003oocX0oooo0`000?lI0?ooo`003`3oool00`000000
oooo0?ooo`1i0?ooo`030?oo003oool0oooo01H0oooo0P3o0?lT0?ooo`800?oo>`3oool30000oaH0
oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`1j0?ooo`80ool0603oool20?l0ob@0oooo
0P00ooll0?ooo`<0003o4`3oool000L0oooo00@000000?ooo`3oool00000103oool00`000000oooo
0?ooo`1l0?ooo`80ool0603oool20?l0ob@0oooo0P00oolm0?ooo`@0003o3`3oool000X0oooo00<0
00000?ooo`3oool00P3oool3000007h0oooo00<0ool00?ooo`3oool05`3oool20?l0ob@0oooo0`00
ooln0?ooo`80003o3@3oool000P0oooo0P0000050?ooo`030000003oool0oooo07l0oooo0P3oo`0I
0?ooo`80o`3o9@3oool3003oodX0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0P@3oool00`3oo`00oooo0?ooo`0H0?ooo`80o`3o9P3oool2003oodP0oooo00070?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0PP3oool20?oo01X0oooo0P3o0?lV0?oo
o`<00?ooA@3oool000P0oooo0P0000050?ooo`030000003oool0oooo08@0oooo0P3oo`0J0?ooo`80
o`3o9`3oool3003ood80oooo000?0?ooo`800000Q`3oool00`3oo`00oooo0?ooo`0I0?ooo`80o`3o
:03oool2003ood00oooo000?0?ooo`030000003oool0oooo08L0oooo0P3oo`0K0?ooo`80o`3o:03o
ool2003ooch0oooo000?0?ooo`030000003oool0oooo08T0oooo00<0ool00?ooo`3oool06P3oool2
0?l0obP0oooo0P00ooll0?ooo`003`3oool00`000000oooo0?ooo`2:0?ooo`80ool0703oool20?l0
obP0oooo0P00oolj0?ooo`003`3oool00`000000oooo0?ooo`2<0?ooo`80ool0703oool00`3o0?l0
oooo0?ooo`0W0?ooo`<00?oo=`3oool000l0oooo00<000000?ooo`3oool0SP3oool20?oo01/0oooo
0P3o0?lZ0?ooo`800?oo=@3oool000l0oooo0P00002A0?ooo`80ool06`3oool20?l0obX0oooo0P00
oolc0?ooo`003`3oool00`000000oooo0?ooo`2B0?ooo`80ool06`3oool20?l0obX0oooo0P00oola
0?ooo`003`3oool00`000000oooo0?ooo`2D0?ooo`030?oo003oool0oooo01X0oooo0P3o0?lZ0?oo
o`800?oo;`3oool000l0oooo00<000000?ooo`3oool0U@3oool20?oo01`0oooo0P3o0?lZ0?ooo`<0
0?oo;03oool000l0oooo00<000000?ooo`3oool0U`3oool00`3oo`00oooo0?ooo`0K0?ooo`80o`3o
:`3oool3003oobT0oooo000?0?ooo`800000V@3oool20?oo01d0oooo0P3o0?l/0?ooo`800?oo9`3o
ool000l0oooo00<000000?ooo`3oool0VP3oool20?oo01d0oooo0P3o0?l/0?ooo`<00?oo903oool0
00l0oooo00<000000?ooo`3oool0W03oool00`3oo`00oooo0?ooo`0L0?ooo`80o`3o;@3oool3003o
ob40oooo000?0?ooo`030000003oool0oooo09d0oooo0P3oo`0N0?ooo`80o`3o;P3oool3003ooah0
oooo000?0?ooo`030000003oool0oooo09l0oooo00<0ool00?ooo`3oool07@3oool00`3o0?l0oooo
0?ooo`0^0?ooo`800?oo703oool000l0oooo0P00002Q0?ooo`80ool07P3oool20?l0oc00oooo0`00
oolI0?ooo`003`3oool00`000000oooo0?ooo`2R0?ooo`030?oo003oool0oooo01d0oooo0P3o0?la
0?ooo`800?oo5`3oool000l0oooo00<000000?ooo`3oool0X`3oool20?oo01l0oooo0P3o0?la0?oo
o`800?oo5@3oool000l0oooo00<000000?ooo`3oool0Y@3oool20?oo01l0oooo0P3o0?la0?ooo`80
0?oo4`3oool000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2W0?ooo`030?oo
003oool0oooo01h0oooo0P3o0?la0?ooo`800?oo4@3oool000T0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`2X0?ooo`80ool0803oool20?l0oc40oooo0P00ool?0?ooo`001P3oool5
000000@0oooo0`00002Z0?ooo`030?oo003oool0oooo01l0oooo0P3o0?la0?ooo`800?oo3@3oool0
00H0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`2[0?ooo`80ool08@3oool2
0?l0och0oooo00070?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0[@3oool20?oo
0240oooo0P3o0?ll0?ooo`00203oool2000000D0oooo00<000000?ooo`3oool0[`3oool00`3oo`00
oooo0?ooo`0P0?ooo`80o`3o>P3oool000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`2`0?ooo`80ool08P3oool20?l0ocP0oooo000?0?ooo`800000/`3oool20?oo0280oooo0P3o
0?lf0?ooo`003`3oool00`000000oooo0?ooo`2d0?ooo`030?oo003oool0oooo0240oooo0P3o0?ld
0?ooo`003`3oool00`000000oooo0?ooo`2e0?ooo`80ool08`3oool20?l0oc80oooo000?0?ooo`03
0000003oool0oooo0;L0oooo00<0ool00?ooo`3oool08P3oool20?l0oc00oooo000?0?ooo`030000
003oool0oooo0;P0oooo0P3oo`0T0?ooo`80o`3o;P3oool000l0oooo0P00002k0?ooo`80ool0903o
ool20?l0ob`0oooo000?0?ooo`030000003oool0oooo0;`0oooo00<0ool00?ooo`3oool08`3oool2
0?l0obX0oooo000?0?ooo`030000003oool0oooo0;d0oooo0P3oo`0U0?ooo`80o`3o:03oool000l0
oooo00<000000?ooo`3oool0_`3oool00`3oo`00oooo0?ooo`0T0?ooo`80o`3o9P3oool000l0oooo
00<000000?ooo`3oool0`03oool20?oo02H0oooo0P3o0?lT0?ooo`003`3oool00`000000oooo0?oo
o`320?ooo`030?oo003oool0oooo02D0oooo0P3o0?lR0?ooo`003`3oool200000<@0oooo0P3oo`0W
0?ooo`80o`3o803oool000l0oooo00<000000?ooo`3oool0a@3oool20?oo02L0oooo0P3o0?lN0?oo
o`003`3oool00`000000oooo0?ooo`370?ooo`030?oo003oool0oooo02H0oooo0P3o0?lL0?ooo`00
3`3oool00`000000oooo0?ooo`380?ooo`80ool0:03oool20?l0oaX0oooo000?0?ooo`030000003o
ool0oooo0<X0oooo00<0ool00?ooo`3oool09`3oool20?l0oaP0oooo000?0?ooo`800000c03oool2
0?oo02T0oooo00<0o`3o0?ooo`3oool05@3oool000l0oooo00<000000?ooo`3oool0c@3oool00`3o
o`00oooo0?ooo`0W0?ooo`80o`3o5@3oool000l0oooo00<000000?ooo`3oool0cP3oool20?oo02T0
oooo0P3o0?lC0?ooo`001`3oool3000000D0oooo00<000000?ooo`3oool0d03oool20?oo02T0oooo
0P3o0?lA0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0=80oooo00<0
ool00?ooo`3oool0:03oool20?l0o`l0oooo000:0?ooo`030000003oool0oooo0080oooo0`00003C
0?ooo`80ool0:P3oool20?l0o`d0oooo00070?ooo`<000001@3oool00`000000oooo0?ooo`3E0?oo
o`030?oo003oool0oooo03H0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0eP3oool20?oo03H0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
f03oool20?oo03@0oooo00070?ooo`@00000103oool00`000000oooo0?ooo`3J0?ooo`80ool0<P3o
ool000l0oooo00<000000?ooo`3oool0g03oool20?oo0300oooo000?0?ooo`800000g`3oool20?oo
02h0oooo000?0?ooo`030000003oool0oooo0>00oooo00<0ool00?ooo`3oool0:`3oool000l0oooo
00<000000?ooo`3oool0h@3oool20?oo02/0oooo000?0?ooo`030000003oool0oooo0><0oooo00<0
ool00?ooo`3oool0:03oool000l0oooo00<000000?ooo`3oool0i03oool20?oo02P0oooo000?0?oo
o`800000i`3oool20?oo02H0oooo000?0?ooo`030000003oool0oooo0>P0oooo00<0ool00?ooo`3o
ool08`3oool000l0oooo00<000000?ooo`3oool0j@3oool20?oo02<0oooo000?0?ooo`030000003o
ool0oooo0>/0oooo00<0ool00?ooo`3oool0803oool000l0oooo00<000000?ooo`3oool0k03oool2
0?oo0200oooo000?0?ooo`800000k`3oool00`3oo`00oooo0?ooo`0M0?ooo`003`3oool00`000000
oooo0?ooo`3_0?ooo`80ool07@3oool000l0oooo00<000000?ooo`3oool0l@3oool20?oo01/0oooo
000?0?ooo`030000003oool0oooo0?<0oooo00<0ool00?ooo`3oool0603oool000l0oooo00<00000
0?ooo`3oool0m03oool20?oo01P0oooo000?0?ooo`030000003oool0oooo0?H0oooo00<0ool00?oo
o`3oool05@3oool000l0oooo0P00003h0?ooo`80ool05@3oool000l0oooo00<000000?ooo`3oool0
n@3oool20?oo01<0oooo000?0?ooo`030000003oool0oooo0?/0oooo00<0ool00?ooo`3oool0403o
ool000P0oooo0P0000050?ooo`030000003oool0oooo0?`0oooo0P3oo`0@0?ooo`001`3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo0?h0oooo0P3oo`0>0?ooo`001`3oool01000
0000oooo0?ooo`0000040?ooo`<00000o`3oool10?ooo`030?oo003oool0oooo00/0oooo00070?oo
o`<000001@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo00070?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0o`3oool?0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0?l0oooo3`3oool000P0oooo0`0000040?ooo`030000003oool0oooo0?l0oooo3`3o
ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0598145, -0.46482, \
0.00386179, 0.0374911}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Out of phase waves", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f = 3;  (*\ Frequency\ *) \nphase = 0;\), "\n", 
    \(\(Plot[Sin[\ 2\ \[Pi]\ f\ \ t + \ phase], {t, 0, 1}];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309016 0.294303 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.04262 .41606 L
.06244 .51276 L
.07286 .5519 L
.08255 .57915 L
.08813 .59036 L
.09076 .59448 L
.0932 .5976 L
.096 .60036 L
.09748 .60145 L
.09824 .60191 L
.09905 .60234 L
.09976 .60265 L
.10041 .60288 L
.10168 .60319 L
.10239 .60328 L
.10317 .60332 L
.1039 .60329 L
.10458 .60321 L
.10587 .6029 L
.10651 .60268 L
.10722 .60237 L
.10848 .6017 L
.10966 .6009 L
.11231 .59853 L
.11515 .59509 L
.12035 .58647 L
.1251 .57604 L
.13466 .54801 L
.14371 .51358 L
.18204 .31193 L
.20142 .20156 L
.21172 .14833 L
.22282 .09846 L
.23339 .06036 L
.23801 .04701 L
.24307 .03492 L
.24787 .02599 L
.25234 .01998 L
.25481 .01761 L
.25705 .01607 L
.25829 .01546 L
.259 .0152 L
.25964 .01501 L
.26083 .01478 L
.26209 .01472 L
.2633 .01483 L
.26462 .01514 L
.26586 .01562 L
.26702 .01622 L
Mistroke
.2692 .01778 L
.27152 .02003 L
.27427 .02348 L
.27684 .02749 L
.28166 .03693 L
.29046 .06049 L
.29997 .09438 L
.31995 .1885 L
.34103 .30762 L
.36093 .42068 L
.37905 .50916 L
.3891 .54783 L
.3986 .57578 L
.40382 .58716 L
.40863 .59506 L
.41115 .59815 L
.41392 .60072 L
.41532 .60169 L
.41605 .60211 L
.41682 .60248 L
.41749 .60275 L
.41823 .60299 L
.41953 .60325 L
.42017 .60331 L
.42086 .60332 L
.42208 .6032 L
.42339 .60288 L
.42414 .60261 L
.42483 .6023 L
.42724 .6008 L
.4286 .59967 L
.42983 .59846 L
.43463 .5921 L
.43918 .58372 L
.44922 .55747 L
.46014 .51783 L
.47989 .42306 L
.50089 .30381 L
.52056 .19252 L
.53861 .10537 L
.54802 .06955 L
.55794 .04079 L
.56309 .02985 L
.56789 .02227 L
.57065 .01909 L
.57315 .01693 L
.57454 .01605 L
.57527 .01568 L
.57605 .01535 L
.57672 .01512 L
Mistroke
.57747 .01492 L
.57878 .01473 L
.58007 .01474 L
.58127 .01492 L
.58259 .01531 L
.58332 .01561 L
.58399 .01594 L
.58653 .01767 L
.58893 .01997 L
.59339 .02597 L
.59821 .03494 L
.6035 .04765 L
.60909 .06418 L
.61909 .10109 L
.65708 .29942 L
.67824 .41987 L
.69753 .51344 L
.70711 .54968 L
.71216 .56538 L
.71752 .57926 L
.7222 .58887 L
.72468 .59301 L
.72736 .5967 L
.72981 .59937 L
.73088 .60032 L
.73205 .60122 L
.73309 .60188 L
.7342 .60244 L
.73537 .60289 L
.73645 .60316 L
.73769 .60331 L
.73839 .60331 L
.73905 .60327 L
.73974 .60316 L
.74037 .60302 L
.7411 .6028 L
.74179 .60253 L
.74301 .60193 L
.74414 .60121 L
.74671 .59905 L
.74953 .59581 L
.75209 .5921 L
.75782 .58118 L
.76281 .5688 L
.7682 .55259 L
.77797 .51632 L
.81905 .29977 L
.83953 .18454 L
.84952 .13458 L
.85861 .09497 L
Mistroke
.86742 .06317 L
.87699 .03711 L
.88224 .02689 L
.88455 .02336 L
.88709 .02016 L
.88949 .01781 L
.89173 .01621 L
.89297 .01557 L
.8941 .01514 L
.89541 .01483 L
.89665 .01472 L
.89789 .01478 L
.89859 .01489 L
.89924 .01505 L
.90042 .01546 L
.90168 .01607 L
.90385 .01755 L
.90623 .0198 L
.90878 .02291 L
.91151 .02706 L
.91645 .03663 L
.92606 .06263 L
.93483 .09413 L
.95391 .18339 L
.97467 .30013 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool001<0oooo100000040?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000E0?ooo`030000003oool0
oooo00<0oooo0P00000l0?ooo`@00000D03oool400000540oooo1000000J0?ooo`003@3oool40000
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0j0?ooo`040000003oool0oooo
0?ooo`800000CP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04`0oooo0P000004
0?ooo`030000003oool0oooo01L0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0>@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04`0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool05`3oool001<0oooo0`0000050?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0BP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo000E0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo04T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`190?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool05P3oool001/0oooo00<000000?ooo`3oool0=`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05@3o
ool001/0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo04L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`170?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool05@3oool001/0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`170?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05@3oool001/0
oooo0P00000g0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0AP3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0D0?ooo`006`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04D0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0D0?ooo`006`3oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0C0?ooo`006`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0@`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04<0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`006`3oool00`000000oooo0?ooo`0e0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?oo
o`006`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0@@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0B0?ooo`006`3oool00`000000oooo0?ooo`0d0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo0440oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`006`3o
ool2000003D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`100?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo0140oooo000K0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?`3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo
03@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0140oooo000K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0o0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0?`3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo03<0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
000K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0n0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0100oooo000K0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0?@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo000K0?oo
o`030000003oool0oooo0380oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0100oooo000K0?ooo`800000<`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo03d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0403oool001/0oooo00<000000?ooo`3oool0
<P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
3`3oool001/0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo03`0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool03`3oool001/0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool0
01/0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
03/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool03`3oool001/0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool03`3oool001/0oooo
00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool03P3oool001/0oooo0P00000a
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0>
0?ooo`006`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0>0?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0>0?ooo`00
6`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo03P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`006`3oool0
0`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0=0?ooo`00203oool2000000@0oooo00<000000?ooo`3oool00P3oool30000
00D0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool03@3oool000L0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00070?ooo`040000003oool0oooo0000
00/0oooo00<000000?ooo`3oool00P3oool2000002l0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00000`3oool000000000000200000080
oooo00@000000?ooo`3oool00000203oool3000000D0oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0303oool000L0
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
02h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
00`0oooo00070?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=03oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0<0?ooo`00203oool2000000T0oooo100000040?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00/0
oooo000K0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=03oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00/0oooo000K0?ooo`030000003oool0oooo02d0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00/0oooo000K
0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0b
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00/0oooo000K0?ooo`800000;@3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool02`3oool001/0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool02P3oool001/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02P3o
ool001/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo0300oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool02@3oool001/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`0`0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool001/0oooo0P00
000/0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`090?ooo`006`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0200oooo00<00000
0?ooo`3oool0;`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?ooo`0[0?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`090?oo
o`006`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool0;P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool08@3oool00`000000oooo0?ooo`080?ooo`006`3oool00`000000oooo0?ooo`0Z0?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?ooo`030000
003oool0oooo02h0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`006`3o
ool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0;P3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool08@3o
ool00`000000oooo0?ooo`080?ooo`006`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
oooo02h0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`006`3oool20000
02/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
00P0oooo000K0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0oooo000K0?ooo`030000003oool0oooo02X0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00L0oooo
000K0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`0S0?ooo`030000003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo02T0oooo00<00000
0?ooo`3oool08`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00L0oooo000K0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0/0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0S0?oo
o`030000003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo02P0oooo0P0000040?ooo`03
0000003oool0oooo0080oooo1000000H0?ooo`030000003oool0oooo00T0oooo0P0000040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`80
0000103oool00`000000oooo0?ooo`030?ooo`800000203oool00`000000oooo0?ooo`0I0?ooo`80
0000103oool00`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`0S0?ooo`@0
00001P3oool001/0oooo00<000000?ooo`3oool09`3oool010000000oooo0000000000080?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000:0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool03@3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`3oool0603oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool09@3oool2000000L0
oooo000K0?ooo`800000:03oool010000000oooo0000000000090?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000070?ooo`D000004`3oool00`00
0000oooo0?ooo`0=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000001`3o
ool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`0U0?ooo`8000001`3oool001/0oooo00<000000?ooo`3oool0
9`3oool2000000030?ooo`000000oooo00T0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`070?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool00000503oool00`00
0000oooo0?ooo`0=0?ooo`040000003oool0oooo000000P0oooo0`0000080?ooo`030000003oool0
oooo01P0oooo00@000000?ooo`3oool000002@3oool2000000<0oooo00<000000?ooo`3oool09@3o
ool2000000L0oooo000K0?ooo`030000003oool0oooo02L0oooo0P0000000`3oool000000?ooo`0:
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00
00080?ooo`030000003oool0000001@0oooo00<000000?ooo`3oool03@3oool010000000oooo0?oo
o`0000080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0603oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool09@3oool20000
00L0oooo000K0?ooo`030000003oool0oooo02L0oooo0P0000000`3oool000000?ooo`070?ooo`04
0000003oool0oooo000001T0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`000009
0?ooo`800000503oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo000000P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0T0?ooo`<000001`3oool001/0oooo
00<000000?ooo`3oool0:03oool2000000X0oooo0P00000J0?ooo`030000003oool0oooo00P0oooo
0P00000;0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool2000000X0oooo
0`0000080?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`8000000P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo00D0oooo000K0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0:03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00D0oooo000K
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0X
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo00D0oooo000K0?ooo`030000003oool0oooo02L0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00D0oooo000D0?ooool0
00003@00000001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?oo
o`000000303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo0P00000;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?oo
o`006`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00D0oooo000K0?ooo`800000
:03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0300oooo000K0?ooo`8000009`3o
ool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0:03o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0300oooo000K0?ooo`8000009`3oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0300oooo000K0?ooo`8000009`3oool00`00
0000oooo0?ooo`0Y0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0:@3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo0340oooo000K0?ooo`8000009`3oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0:P3oool00`000000
oooo0?ooo`0T0?ooo`030000003oool0oooo0340oooo000K0?ooo`8000009`3oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo0340oooo000K0?ooo`030000003oool0000002D0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`0a0?ooo`006`3oool00`000000oooo0000000U
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0<@3oool001/0oooo00<000000?oo
o`0000009@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0380oooo000K0?ooo`03
0000003oool0000002D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo02`0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0b0?ooo`00
6`3oool00`000000oooo0000000U0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0
<P3oool001/0oooo00<000000?ooo`0000009@3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo0380oooo000K0?ooo`040000003oool0oooo000002<0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool08P3o
ool00`000000oooo0?ooo`0b0?ooo`006`3oool2000000030?ooo`000000oooo0280oooo00<00000
0?ooo`3oool0;@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02`0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`0b0?ooo`006`3oool010000000oooo0?ooo`00000S
0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0]
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0<`3oool001/0oooo00@000000?oo
o`3oool000008`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0200oooo00<00000
0?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03<0oooo000K0?oo
o`040000003oool0oooo000002<0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0c
0?ooo`006`3oool010000000oooo0?ooo`00000R0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0200oooo00<00000
0?ooo`3oool0<`3oool001/0oooo00D000000?ooo`3oool0oooo0000000Q0?ooo`030000003oool0
oooo02l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0<`3oool001/0oooo00D000000?ooo`3oool0oooo0000000Q
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0=03oool001/0oooo00D000000?oo
o`3oool0oooo0000000Q0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0=03oool0
01/0oooo0P0000020?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0d0?ooo`006`3oool01@000000oooo0?ooo`3oool000000200oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0d0?ooo`006`3oool01@000000oooo0?ooo`3oool00000
0200oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
0300oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0d0?ooo`006`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0e0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0380oooo
00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0e0?ooo`006`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0e0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo00<00000
0?ooo`3oool0<P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0e0?ooo`006`3oool2000000<0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo03D0oooo000K0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0c0?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo03H0oooo000K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03H0oooo000K0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo03H0oooo000K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=03oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03H0oooo000K0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
03H0oooo00080?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0g0?ooo`001`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0=`3oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0=`3oool000L0oooo00@000000?ooo`3oool00000203oool3000000D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0=`3oool000L0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0g0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo03L0oooo00070?ooo`040000003oool0oooo000000P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0g0?ooo`00203oool2000000T0oooo
100000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0g0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=`3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo03P0oooo000K0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo000K
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0h
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo03P0oooo000K0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo000K0?ooo`80
00001`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0>03oool001/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo03T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0i0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0>@3oool001/0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>@3o
ool001/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo03T0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0>@3oool001/0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>@3oool001/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0>@3oool001/0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0k0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>P3oool001/0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03/0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0>P3oool001/0oooo0P0000080?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0j0?ooo`006`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo03d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?oo
o`006`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool0?@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0j0?ooo`006`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo03h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0k0?ooo`006`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0k0?ooo`006`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo03l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0k0?ooo`006`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0k0?ooo`006`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0k0?ooo`006`3oool2000000X0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03`0oooo
000K0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`110?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo03`0oooo000K0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03`0oooo000K0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`130?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo03`0oooo000K0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0@`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03d0oooo000K0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`140?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo03d0oooo000K0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03h0oooo000K0?ooo`800000303oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0?P3oool0
01/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
04H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0?`3oool001/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`170?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0?`3oool001/0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0?`3oool001/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`190?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0@03oool001/0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04T0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0@03oool001<0oooo100000040?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0BP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0440oooo000E0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo04d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1<0?ooo`80
00000`3oool00`000000oooo0?ooo`120?ooo`005@3oool00`000000oooo0?ooo`030?ooo`800000
4@3oool500000500oooo1000001@0?ooo`@00000A@3oool001D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`3o0?ooo`<0oooo000E0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0o`3oool30?ooo`004`3oool3000000D0oooo00<000000?ooo`3oool0o`3oool30?oo
o`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo0`3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -1.13007, \
0.00394728, 0.0127736}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f = 3; \  (*\ Frequency\ *) \nphase = \[Pi];\), "\n", 
    \(\(Plot[Sin[\ 2\ \[Pi]\ f\ \ t + \ phase], {t, 0, 1}];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309018 0.294303 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.04262 .20198 L
.06244 .10527 L
.07286 .06613 L
.08255 .03889 L
.08813 .02767 L
.09076 .02355 L
.0932 .02044 L
.096 .01768 L
.09748 .01658 L
.09824 .01612 L
.09905 .0157 L
.09976 .01539 L
.10041 .01516 L
.10168 .01484 L
.10239 .01475 L
.10317 .01472 L
.1039 .01475 L
.10458 .01483 L
.10587 .01513 L
.10651 .01536 L
.10722 .01566 L
.10848 .01634 L
.10966 .01713 L
.11231 .01951 L
.11515 .02294 L
.12035 .03156 L
.1251 .042 L
.13466 .07002 L
.14371 .10445 L
.18204 .3061 L
.20142 .41647 L
.21172 .4697 L
.22282 .51957 L
.23339 .55767 L
.23801 .57103 L
.24307 .58312 L
.24787 .59204 L
.25234 .59806 L
.25481 .60042 L
.25705 .60196 L
.25829 .60257 L
.259 .60283 L
.25964 .60303 L
.26083 .60325 L
.26209 .60332 L
.2633 .60321 L
.26462 .6029 L
.26586 .60242 L
.26702 .60181 L
Mistroke
.2692 .60026 L
.27152 .598 L
.27427 .59456 L
.27684 .59055 L
.28166 .58111 L
.29046 .55754 L
.29997 .52366 L
.31995 .42954 L
.34103 .31041 L
.36093 .19736 L
.37905 .10888 L
.3891 .0702 L
.3986 .04226 L
.40382 .03087 L
.40863 .02298 L
.41115 .01989 L
.41392 .01731 L
.41532 .01634 L
.41605 .01593 L
.41682 .01556 L
.41749 .01528 L
.41823 .01505 L
.41953 .01479 L
.42017 .01473 L
.42086 .01472 L
.42208 .01483 L
.42339 .01515 L
.42414 .01542 L
.42483 .01573 L
.42724 .01723 L
.4286 .01836 L
.42983 .01958 L
.43463 .02593 L
.43918 .03432 L
.44922 .06056 L
.46014 .1002 L
.47989 .19497 L
.50089 .31422 L
.52056 .42551 L
.53861 .51267 L
.54802 .54848 L
.55794 .57724 L
.56309 .58818 L
.56789 .59576 L
.57065 .59895 L
.57315 .6011 L
.57454 .60198 L
.57527 .60236 L
.57605 .60269 L
.57672 .60292 L
Mistroke
.57747 .60311 L
.57878 .6033 L
.58007 .60329 L
.58127 .60311 L
.58259 .60272 L
.58332 .60242 L
.58399 .60209 L
.58653 .60037 L
.58893 .59806 L
.59339 .59206 L
.59821 .58309 L
.6035 .57038 L
.60909 .55385 L
.61909 .51694 L
.65708 .31862 L
.67824 .19817 L
.69753 .1046 L
.70711 .06836 L
.71216 .05265 L
.71752 .03878 L
.7222 .02916 L
.72468 .02502 L
.72736 .02133 L
.72981 .01867 L
.73088 .01771 L
.73205 .01682 L
.73309 .01616 L
.7342 .01559 L
.73537 .01514 L
.73645 .01487 L
.73769 .01472 L
.73839 .01472 L
.73905 .01477 L
.73974 .01487 L
.74037 .01501 L
.7411 .01523 L
.74179 .0155 L
.74301 .01611 L
.74414 .01682 L
.74671 .01898 L
.74953 .02222 L
.75209 .02593 L
.75782 .03685 L
.76281 .04923 L
.7682 .06544 L
.77797 .10172 L
.81905 .31826 L
.83953 .4335 L
.84952 .48346 L
.85861 .52307 L
Mistroke
.86742 .55486 L
.87699 .58092 L
.88224 .59114 L
.88455 .59468 L
.88709 .59788 L
.88949 .60022 L
.89173 .60183 L
.89297 .60246 L
.8941 .60289 L
.89541 .6032 L
.89665 .60332 L
.89789 .60325 L
.89859 .60314 L
.89924 .60299 L
.90042 .60257 L
.90168 .60197 L
.90385 .60048 L
.90623 .59824 L
.90878 .59512 L
.91151 .59097 L
.91645 .5814 L
.92606 .55541 L
.93483 .52391 L
.95391 .43464 L
.97467 .3179 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool001<0oooo100000040?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000E0?ooo`030000003oool0
oooo00<0oooo0P00000A0?ooo`D00000D03oool400000500oooo100000150?ooo`003@3oool40000
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`8000000`3oool00`00
0000oooo0?ooo`1=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0C@3oool01@00
0000oooo0?ooo`3oool0000004@0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04/0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`1;0?ooo`8000001@3oool00`000000oooo0?ooo`110?oo
o`004`3oool3000000D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo04X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1:0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0@03oool001D0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
B03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`100?ooo`006`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo04P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0o0?ooo`006`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0AP3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0o0?ooo`006`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
04H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0o0?ooo`006`3oool2000000`0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03h0
oooo000K0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo03h0oooo000K0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03h0oooo000K
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo03d0oooo000K0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0@`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03d0oooo000K0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`120?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo03`0oooo000K0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03`0oooo000K0?ooo`8000002P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?03o
ool001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo0400oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`100?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0>`3oool001/0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`100?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0>`3oool001/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03l0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0>`3oool001/0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0o0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0>`3oool001/0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03h0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0>`3oool001/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0m
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool001/0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0>P3oool001/0oooo0P0000080?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0?03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0j0?ooo`006`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo03`0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0j0?ooo`006`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>`3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0j0?ooo`006`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo03/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0i0?ooo`006`3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0i0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0i0?ooo`006`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0>@3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0i0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0>@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03T0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0i0?ooo`006`3oool2000000L0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0>@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03P0oooo000K0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo03P0oooo000K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo000K0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0g0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo03P0oooo000K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo000K0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo03L0oooo00080?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=`3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0g0?ooo`001`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0=`3oool000L0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0=`3oool000030?ooo`0000000000008000000P3oool010000000
oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0g0?ooo`001`3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0e0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=`3oool000L0
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
03H0oooo00080?ooo`8000002@3oool4000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=P3oool001/0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo03@0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0=P3oool001/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=P3oool001/0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo03<0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool0=P3oool001/0oooo0P0000040?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0e0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0e0?ooo`00
6`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0
<P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`0e0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0e0?ooo`006`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`0e0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
0300oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0d0?ooo`006`3oool01@000000
oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0d0?oo
o`006`3oool01@000000oooo0?ooo`3oool000000240oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0d0?ooo`006`3oool200000080oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0<03oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo03@0oooo000K0?ooo`050000003oool0oooo0?ooo`00
00008@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool0;`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo03@0oooo000K0?ooo`050000
003oool0oooo0?ooo`0000008@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03<0
oooo000K0?ooo`050000003oool0oooo0?ooo`0000008@3oool00`000000oooo0?ooo`0_0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo03<0oooo000K0?ooo`040000003oool0oooo000002<0oooo00<000000?ooo`3o
ool0;P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0c0?ooo`006`3oool010000000oooo0?ooo`00000S0?ooo`03
0000003oool0oooo02h0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0<`3oool001/0oooo00@000000?ooo`3oool0
00008`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03<0oooo000K0?ooo`800000
00<0oooo0000003oool08P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0280oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0380oooo
000K0?ooo`040000003oool0oooo000002<0oooo00<000000?ooo`3oool0;@3oool00`000000oooo
0?ooo`0R0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool08P3oool00`000000oooo
0?ooo`0b0?ooo`006`3oool010000000oooo0?ooo`00000T0?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo
00<000000?ooo`3oool0<P3oool001/0oooo00<000000?ooo`0000009@3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo0380oooo000K0?ooo`030000003oool0000002D0oooo00<00000
0?ooo`3oool0:`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02`0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`0b0?ooo`006`3oool00`000000oooo0000000U0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0[0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool0<P3oool001/0oooo00<000000?ooo`00
00009@3oool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`3oool00P3oool4000001`0
oooo00<000000?ooo`3oool01@3oool2000000@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0P00000;0?ooo`030000003oool0oooo01H0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0`00000Y0?ooo`@000001P3oool001/0oooo00<000000?ooo`0000009@3oool00`000000oooo
000000020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`040?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0@0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000002P3oool0
0`000000oooo0?ooo`0E0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
:`3oool00`000000oooo0?ooo`050?ooo`006`3oool2000002L0oooo0P0000020?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`040000003o
ool0oooo000000L0oooo1@00000@0?ooo`030000003oool0oooo0100oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo01D0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000[0?ooo`030000003oool0oooo00D0oooo000K
0?ooo`8000009`3oool200000080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool000001`3oool010000000oooo0?oo
o`00000A0?ooo`030000003oool0oooo0100oooo00@000000?ooo`3oool00000203oool3000000/0
oooo00<000000?ooo`3oool05@3oool010000000oooo0?ooo`0000090?ooo`<00000:`3oool00`00
0000oooo0?ooo`050?ooo`006`3oool2000002L0oooo0P0000020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`0000004P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo
000000P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0E0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool00000:`3oool00`000000oooo0?ooo`050?ooo`006`3o
ool2000002L0oooo0P0000020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool00000
6`3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000T0oooo0P00000B0?ooo`03
0000003oool0oooo00l0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo01D0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`02
000002P0oooo0`0000070?ooo`006`3oool2000002L0oooo00@000000?ooo`00000000002P3oool2
000001`0oooo00<000000?ooo`3oool01P3oool2000000/0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`8000002P3oool3000000T0oooo00<000000?ooo`3oool05`3oool2
000000X0oooo0P0000000`3oool000000?ooo`0Y0?ooo`030000003oool0oooo00D0oooo000K0?oo
o`800000:03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0300oooo000K0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0`0?ooo`00
6`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
<03oool001@0ooooo`00000=000000006`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool0000000L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00D0
00000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool2000000/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`050000
003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000`0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo000K0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
1@3oool001/0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01P3oool0
01/0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02X0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool01P3oool001/0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`0Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01P3oool001/0oooo
0P00000Y0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`060?ooo`006`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`060?ooo`006`3oool00`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`07
0?ooo`006`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0;03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`070?ooo`006`3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo02`0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`070?ooo`00
6`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`070?ooo`006`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo02`0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`070?ooo`006`3oool0
0`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;03oool0
0`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`080?ooo`006`3oool2000002/0oooo00<000000?ooo`3oool08P3oool00`00
0000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;@3oool00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0oooo000K0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0
oooo000K0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`0^0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo00P0oooo000K0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool0;P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0oooo000K
0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo00P0oooo000K0?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0200oooo00<000000?oo
o`3oool0;`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00T0oooo000K0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo00T0oooo000K0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
<03oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00T0oooo000K0?ooo`800000;03o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3o
ool001/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo0300oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool02@3oool001/0oooo00<000000?ooo`3oool0:`3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0b0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0oooo00<0
00000?ooo`3oool0;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0380oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0b
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0oooo0P00000]0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0;0?oo
o`006`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`0;0?ooo`006`3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo03@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0;0?ooo`006`3o
ool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0;0?ooo`006`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo03@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0;0?ooo`006`3oool00`00
0000oooo0?ooo`0]0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=03oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0<0?ooo`00203oool2000000@0oooo00<000000?ooo`3oool00P3oool3000000D0
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03@0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0303oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00070?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool00P3oool2000002l0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00070?ooo`040000003oool0oooo000000P0
oooo0`0000050?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00070?ooo`040000003oool0oooo000000P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0=0?ooo`001`3oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool03@3oool000P0oooo
0P0000090?ooo`@00000103oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?oo
o`0_0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0=0?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo03P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0>0?oo
o`006`3oool200000340oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0i0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00h0oooo000K0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000003o
ool0oooo0300oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00h0oooo000K0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00l0oooo000K0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
00l0oooo000K0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>`3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo000K0?ooo`030000003oool0oooo0340oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo
000K0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0?03oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo00l0oooo000K0?ooo`800000<`3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0403oool001/0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0403oool001/0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo03h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0m0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0403oool001/0oooo00<000000?ooo`3oool0
<`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
403oool001/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0403oool001/0oooo00<000000?ooo`3oool0<`3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool0
01/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool04@3oool001/0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0o0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool001/0oooo
0P00000e0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0A0?ooo`006`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0440oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`006`3oool00`000000oooo0?ooo`0e
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B
0?ooo`006`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0440oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`006`3oool00`000000oooo0?ooo`0e0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo04<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`00
6`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
A03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0C0?ooo`006`3oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo04D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`006`3oool2
000003L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`160?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo01@0oooo000K0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`160?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0AP3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo01@0oooo000K0?ooo`030000003oool0oooo03L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01D0
oooo000K0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo03L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo000K
0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1:
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo01H0oooo000C0?ooo`@00000103oool00`000000oooo0?ooo`0i0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo04/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0G0?oo
o`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0C03oool2000000@0oooo00<000000?ooo`3oool05`3oool001D0oooo00<000000?ooo`3oool0
0`3oool2000003/0oooo1@00001@0?ooo`D00000D03oool4000001X0oooo000E0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0o`3oool30?ooo`005@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0?l0oooo0`3oool001<0oooo0`0000050?ooo`030000003oool0oooo
0?l0oooo0`3oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -1.13006, \
0.00394728, 0.0127736}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = 3; \  (*\ Frequency\ *) \n
    Plot[Sin[\ 2\ \[Pi]\ f\ \ t + \ 0] + 
        Sin[\ 2\ \[Pi]\ f\ \ t + \ \[Pi]]\n\t, {t, 0, 1}\n, 
      PlotRange -> {\(-2\), 2}\n\t, 
      PlotStyle -> {Thickness[0.012], red}\n\t];\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.154508 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .07725 -24 -4.5 ]
[.01131 .07725 0 4.5 ]
[.01131 .15451 -12 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .23176 -24 -4.5 ]
[.01131 .23176 0 4.5 ]
[.01131 .38627 -18 -4.5 ]
[.01131 .38627 0 4.5 ]
[.01131 .46353 -6 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .54078 -18 -4.5 ]
[.01131 .54078 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 0 m
.03006 0 L
s
[(-2)] .01131 0 1 0 Mshowa
.02381 .07725 m
.03006 .07725 L
s
[(-1.5)] .01131 .07725 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-1)] .01131 .15451 1 0 Mshowa
.02381 .23176 m
.03006 .23176 L
s
[(-0.5)] .01131 .23176 1 0 Mshowa
.02381 .38627 m
.03006 .38627 L
s
[(0.5)] .01131 .38627 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(1)] .01131 .46353 1 0 Mshowa
.02381 .54078 m
.03006 .54078 L
s
[(1.5)] .01131 .54078 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(2)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .01545 m
.02756 .01545 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .04635 m
.02756 .04635 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .10816 m
.02756 .10816 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .13906 m
.02756 .13906 L
s
.02381 .16996 m
.02756 .16996 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20086 m
.02756 .20086 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26266 m
.02756 .26266 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .29357 m
.02756 .29357 L
s
.02381 .32447 m
.02756 .32447 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .35537 m
.02756 .35537 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .41717 m
.02756 .41717 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .44807 m
.02756 .44807 L
s
.02381 .47898 m
.02756 .47898 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .50988 m
.02756 .50988 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57168 m
.02756 .57168 L
s
.02381 .58713 m
.02756 .58713 L
s
.02381 .60258 m
.02756 .60258 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.012 w
.02381 .30902 m
.02499 .30902 L
.02605 .30902 L
.02729 .30902 L
.02846 .30902 L
.02946 .30902 L
.03053 .30902 L
.0317 .30902 L
.03279 .30902 L
.03395 .30902 L
.0352 .30902 L
.03638 .30902 L
.03746 .30902 L
.03873 .30902 L
.03944 .30902 L
.04011 .30902 L
.04132 .30902 L
.04262 .30902 L
.04327 .30902 L
.04396 .30902 L
.04519 .30902 L
.04588 .30902 L
.04652 .30902 L
.04722 .30902 L
.04797 .30902 L
.04862 .30902 L
.04933 .30902 L
.05061 .30902 L
.05186 .30902 L
.05302 .30902 L
.05414 .30902 L
.05519 .30902 L
.05644 .30902 L
.05759 .30902 L
.05873 .30902 L
.05993 .30902 L
.06244 .30902 L
.06371 .30902 L
.06435 .30902 L
.06505 .30902 L
.06581 .30902 L
.06652 .30902 L
.06717 .30902 L
.06787 .30902 L
.06853 .30902 L
.06925 .30902 L
.07055 .30902 L
.07182 .30902 L
.073 .30902 L
.07377 .30902 L
Mistroke
.0745 .30902 L
.07515 .30902 L
.07586 .30902 L
.07663 .30902 L
.07745 .30902 L
.07814 .30902 L
.0789 .30902 L
.07959 .30902 L
.08025 .30902 L
.081 .30902 L
.08168 .30902 L
.08292 .30902 L
.08357 .30902 L
.08427 .30902 L
.08553 .30902 L
.08671 .30902 L
.08739 .30902 L
.08811 .30902 L
.08939 .30902 L
.09004 .30902 L
.09074 .30902 L
.09199 .30902 L
.09483 .30902 L
.10458 .30902 L
.10952 .30902 L
.11087 .30902 L
.1123 .30902 L
.11352 .30902 L
.11422 .30902 L
.11486 .30902 L
.11612 .30902 L
.11731 .30902 L
.11838 .30902 L
.11954 .30902 L
.1208 .30902 L
.12144 .30902 L
.12215 .30902 L
.12339 .30902 L
.12456 .30902 L
.12562 .30902 L
.12677 .30902 L
.12798 .30902 L
.12911 .30902 L
.13016 .30902 L
.13112 .30902 L
.13223 .30902 L
.13328 .30902 L
.13442 .30902 L
.13563 .30902 L
.13666 .30902 L
Mistroke
.13779 .30902 L
.13901 .30902 L
.14032 .30902 L
.14156 .30902 L
.14269 .30902 L
.14387 .30902 L
.14515 .30902 L
.14635 .30902 L
.14746 .30902 L
.14876 .30902 L
.14941 .30902 L
.15013 .30902 L
.15138 .30902 L
.15254 .30902 L
.15373 .30902 L
.15485 .30902 L
.15586 .30902 L
.15696 .30902 L
.16169 .30902 L
.16299 .30902 L
.16371 .30902 L
.16438 .30902 L
.16559 .30902 L
.16691 .30902 L
.1682 .30902 L
.1689 .30902 L
.16955 .30902 L
.17029 .30902 L
.17096 .30902 L
.17173 .30902 L
.17246 .30902 L
.17367 .30902 L
.17495 .30902 L
.17604 .30902 L
.17724 .30902 L
.17853 .30902 L
.17925 .30902 L
.17991 .30902 L
.1812 .30902 L
.18242 .30902 L
.18367 .30902 L
.18437 .30902 L
.18502 .30902 L
.18621 .30902 L
.18747 .30902 L
.1886 .30902 L
.18965 .30902 L
.1908 .30902 L
.19204 .30902 L
.19336 .30902 L
Mistroke
.19411 .30902 L
.19479 .30902 L
.19606 .30902 L
.1967 .30902 L
.1974 .30902 L
.19861 .30902 L
.19992 .30902 L
.20228 .30902 L
.20463 .30902 L
.2072 .30902 L
.20838 .30902 L
.20963 .30902 L
.21081 .30902 L
.21189 .30902 L
.21302 .30902 L
.21406 .30902 L
.21521 .30902 L
.21641 .30902 L
.2174 .30902 L
.21845 .30902 L
.2196 .30902 L
.22068 .30902 L
.2219 .30902 L
.22259 .30902 L
.22324 .30902 L
.22455 .30902 L
.22529 .30902 L
.22596 .30902 L
.2271 .30902 L
.22834 .30902 L
.23085 .30902 L
.23153 .30902 L
.23227 .30902 L
.23297 .30902 L
.23362 .30902 L
.23437 .30902 L
.23517 .30902 L
.23584 .30902 L
.23658 .30902 L
.23727 .30902 L
.23791 .30902 L
.23864 .30902 L
.23933 .30902 L
.24057 .30902 L
.24191 .30902 L
.26203 .30902 L
.2644 .30902 L
.26691 .30902 L
.26822 .30902 L
.26896 .30902 L
Mistroke
.26966 .30902 L
.27088 .30902 L
.27218 .30902 L
.27341 .30902 L
.27411 .30902 L
.27475 .30902 L
.27593 .30902 L
.27718 .30902 L
.2783 .30902 L
.27935 .30902 L
.28173 .30902 L
.28243 .30902 L
.28308 .30902 L
.28376 .30902 L
.2845 .30902 L
.28573 .30902 L
.28703 .30902 L
.28777 .30902 L
.28857 .30902 L
.28933 .30902 L
.29003 .30902 L
.29135 .30902 L
.29201 .30902 L
.29274 .30902 L
.29404 .30902 L
.29523 .30902 L
.29589 .30902 L
.2966 .30902 L
.2979 .30902 L
.29911 .30902 L
.3004 .30902 L
.3015 .30902 L
.30272 .30902 L
.31212 .30902 L
.31725 .30902 L
.32203 .30902 L
.32332 .30902 L
.32454 .30902 L
.32521 .30902 L
.32594 .30902 L
.32722 .30902 L
.3279 .30902 L
.32865 .30902 L
.32944 .30902 L
.33017 .30902 L
.33149 .30902 L
.33222 .30902 L
.3329 .30902 L
.33417 .30902 L
.33534 .30902 L
Mistroke
.33664 .30902 L
.33736 .30902 L
.33801 .30902 L
.33922 .30902 L
.34052 .30902 L
.34174 .30902 L
.34287 .30902 L
.34414 .30902 L
.34533 .30902 L
.34641 .30902 L
.34758 .30902 L
.34884 .30902 L
.34949 .30902 L
.35019 .30902 L
.35144 .30902 L
.35261 .30902 L
.35373 .30902 L
.3549 .30902 L
.3559 .30902 L
.35699 .30902 L
.35817 .30902 L
.35943 .30902 L
.36062 .30902 L
.3617 .30902 L
.36299 .30902 L
.36364 .30902 L
.36436 .30902 L
.36562 .30902 L
.36681 .30902 L
.36752 .30902 L
.3682 .30902 L
.36947 .30902 L
.37018 .30902 L
.37084 .30902 L
.37157 .30902 L
.37234 .30902 L
.37364 .30902 L
.37437 .30902 L
.37505 .30902 L
.37629 .30902 L
.3776 .30902 L
.37988 .30902 L
.38117 .30902 L
.38237 .30902 L
.38364 .30902 L
.38428 .30902 L
.38498 .30902 L
.38624 .30902 L
.38739 .30902 L
.38809 .30902 L
Mistroke
.38875 .30902 L
.38951 .30902 L
.39021 .30902 L
.39147 .30902 L
.39214 .30902 L
.39285 .30902 L
.39414 .30902 L
.39486 .30902 L
.39553 .30902 L
.39675 .30902 L
.39805 .30902 L
.39921 .30902 L
.4003 .30902 L
.40149 .30902 L
.40277 .30902 L
.40401 .30902 L
.40515 .30902 L
.40641 .30902 L
.40705 .30902 L
.40775 .30902 L
.40893 .30902 L
.41019 .30902 L
.41138 .30902 L
.41248 .30902 L
.41355 .30902 L
.41454 .30902 L
.41563 .30902 L
.41679 .30902 L
.42134 .30902 L
.42392 .30902 L
.42522 .30902 L
.42597 .30902 L
.42666 .30902 L
.42789 .30902 L
.42902 .30902 L
.43033 .30902 L
.43157 .30902 L
.44266 .30902 L
.46281 .30902 L
.47241 .30902 L
.47768 .30902 L
.48264 .30902 L
.48489 .30902 L
.48613 .30902 L
.48727 .30902 L
.48852 .30902 L
.48918 .30902 L
.48989 .30902 L
.49114 .30902 L
.49229 .30902 L
Mistroke
.49341 .30902 L
.49444 .30902 L
.49557 .30902 L
.49678 .30902 L
.49782 .30902 L
.4988 .30902 L
.49987 .30902 L
.50103 .30902 L
.50229 .30902 L
.50343 .30902 L
.50466 .30902 L
.50536 .30902 L
.506 .30902 L
.50715 .30902 L
.50837 .30902 L
.51062 .30902 L
.52109 .30902 L
.53127 .30902 L
.53688 .30902 L
.5422 .30902 L
.5471 .30902 L
.54844 .30902 L
.54987 .30902 L
.55057 .30902 L
.55122 .30902 L
.55244 .30902 L
.55358 .30902 L
.55479 .30902 L
.55581 .30902 L
.55694 .30902 L
.56179 .30902 L
.58011 .30902 L
.58538 .30902 L
.59036 .30902 L
.59483 .30902 L
.59605 .30902 L
.59735 .30902 L
.59846 .30902 L
.59968 .30902 L
.60035 .30902 L
.60108 .30902 L
.60176 .30902 L
.6024 .30902 L
.60361 .30902 L
.60489 .30902 L
.61049 .30902 L
.62062 .30902 L
.6309 .30902 L
.63631 .30902 L
.63927 .30902 L
Mistroke
.64203 .30902 L
.64444 .30902 L
.64514 .30902 L
.6458 .30902 L
.64703 .30902 L
.6477 .30902 L
.6484 .30902 L
.64967 .30902 L
.65032 .30902 L
.65103 .30902 L
.6518 .30902 L
.65253 .30902 L
.6537 .30902 L
.65499 .30902 L
.65563 .30902 L
.65633 .30902 L
.65757 .30902 L
.65882 .30902 L
.65999 .30902 L
.66105 .30902 L
.6622 .30902 L
.6634 .30902 L
.66455 .30902 L
.66518 .30902 L
.66587 .30902 L
.66708 .30902 L
.66823 .30902 L
.66946 .30902 L
.67061 .30902 L
.67166 .30902 L
.67231 .30902 L
.673 .30902 L
.67424 .30902 L
.67492 .30902 L
.67556 .30902 L
.67627 .30902 L
.67702 .30902 L
.67767 .30902 L
.67838 .30902 L
.67966 .30902 L
.68091 .30902 L
.68207 .30902 L
.68327 .30902 L
.68457 .30902 L
.6858 .30902 L
.68692 .30902 L
.68817 .30902 L
.68888 .30902 L
.68953 .30902 L
.69023 .30902 L
Mistroke
.69086 .30902 L
.69159 .30902 L
.69228 .30902 L
.70311 .30902 L
.70554 .30902 L
.70815 .30902 L
.70941 .30902 L
.71061 .30902 L
.71168 .30902 L
.71285 .30902 L
.71409 .30902 L
.7154 .30902 L
.71653 .30902 L
.71776 .30902 L
.71846 .30902 L
.7191 .30902 L
.71981 .30902 L
.72055 .30902 L
.72179 .30902 L
.7225 .30902 L
.72316 .30902 L
.72431 .30902 L
.72556 .30902 L
.72674 .30902 L
.72783 .30902 L
.72881 .30902 L
.7299 .30902 L
.73102 .30902 L
.73208 .30902 L
.73703 .30902 L
.74162 .30902 L
.74286 .30902 L
.74403 .30902 L
.74467 .30902 L
.74537 .30902 L
.74659 .30902 L
.74725 .30902 L
.74796 .30902 L
.74871 .30902 L
.74941 .30902 L
.75067 .30902 L
.75137 .30902 L
.75201 .30902 L
.75328 .30902 L
.75395 .30902 L
.75466 .30902 L
.75596 .30902 L
.75718 .30902 L
.75825 .30902 L
.75941 .30902 L
Mistroke
.7607 .30902 L
.76188 .30902 L
.76296 .30902 L
.76412 .30902 L
.76521 .30902 L
.76619 .30902 L
.76736 .30902 L
.76862 .30902 L
.76981 .30902 L
.77091 .30902 L
.77205 .30902 L
.77311 .30902 L
.77427 .30902 L
.77553 .30902 L
.77684 .30902 L
.77808 .30902 L
.77919 .30902 L
.78041 .30902 L
.78106 .30902 L
.78175 .30902 L
.78298 .30902 L
.7843 .30902 L
.78505 .30902 L
.78575 .30902 L
.78639 .30902 L
.7871 .30902 L
.78837 .30902 L
.78961 .30902 L
.79076 .30902 L
.79181 .30902 L
.79296 .30902 L
.79416 .30902 L
.79529 .30902 L
.79651 .30902 L
.79762 .30902 L
.79891 .30902 L
.80013 .30902 L
.80145 .30902 L
.80265 .30902 L
.80331 .30902 L
.80403 .30902 L
.80534 .30902 L
.80656 .30902 L
.80785 .30902 L
.80895 .30902 L
.81017 .30902 L
.8109 .30902 L
.8116 .30902 L
.8129 .30902 L
.81363 .30902 L
Mistroke
.8143 .30902 L
.81504 .30902 L
.81583 .30902 L
.81713 .30902 L
.81835 .30902 L
.819 .30902 L
.81968 .30902 L
.82043 .30902 L
.82112 .30902 L
.82236 .30902 L
.82305 .30902 L
.82369 .30902 L
.82487 .30902 L
.82612 .30902 L
.82724 .30902 L
.82828 .30902 L
.82943 .30902 L
.83066 .30902 L
.83197 .30902 L
.8327 .30902 L
.83339 .30902 L
.83598 .30902 L
.84085 .30902 L
.84326 .30902 L
.84552 .30902 L
.84755 .30902 L
.84869 .30902 L
.84974 .30902 L
.85088 .30902 L
.85194 .30902 L
.85435 .30902 L
.8567 .30902 L
.85802 .30902 L
.85921 .30902 L
.8604 .30902 L
.86151 .30902 L
.86403 .30902 L
.86533 .30902 L
.86599 .30902 L
.8667 .30902 L
.86797 .30902 L
.86915 .30902 L
.87027 .30902 L
.87128 .30902 L
.87246 .30902 L
.87356 .30902 L
.87466 .30902 L
.87583 .30902 L
.87712 .30902 L
.87833 .30902 L
Mistroke
.87964 .30902 L
.88085 .30902 L
.8815 .30902 L
.88222 .30902 L
.88352 .30902 L
.88472 .30902 L
.886 .30902 L
.8883 .30902 L
.8991 .30902 L
.90844 .30902 L
.911 .30902 L
.9124 .30902 L
.9137 .30902 L
.91481 .30902 L
.91601 .30902 L
.91853 .30902 L
.9368 .30902 L
.94651 .30902 L
.95705 .30902 L
.96188 .30902 L
.96452 .30902 L
.967 .30902 L
.96911 .30902 L
.97029 .30902 L
.97137 .30902 L
.97255 .30902 L
.97384 .30902 L
.97506 .30902 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`004`3oool400000?l0oooo2P3o
ool001<0oooo00<000000?ooo`3oool0o`3oool;0?ooo`00503oool00`000000oooo0?ooo`040?oo
o`800000o`3oool40?ooo`003@3oool4000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`3o0?ooo`<0oooo000F0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
o`3oool30?ooo`004`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo
0`3oool001@0oooo0P0000050?ooo`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o
0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3o
ool0o`3oool30?ooo`006`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo
0?l0oooo0`3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o
0?ooo`<0oooo000K0?ooo`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo00070?ooo`@000000`3oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo
0?ooo`3o0?ooo`<0oooo00090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`3o0?ooo`<0oooo00090?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool00P3oool200000?l0oooo103oool000030?ooo`000000000000800000103oool00`00
0000oooo0?ooo`070?ooo`<000001@3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00090?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo00070?ooo`<000002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo
0`3oool000T0oooo00<000000?ooo`3oool01`3oool4000000@0oooo0P00003o0?ooo`@0oooo000K
0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool0
01/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo000K0?ooo`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K
0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`004`3o
ool4000000@0oooo00<000000?ooo`3oool0o`3oool30?ooo`005@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<000000?ooo`3oool00`3oool20000
0?l0oooo103oool000d0oooo100000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0o`3oool30?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo
0`3oool001<0oooo0`0000050?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<00000
0?ooo`3oool00`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool0
01/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo000K0?ooo`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K
0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`00203o
ool2000000@0oooo00<000000?ooo`3oool00P3oool3000000D0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`001`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0o`3oool30?ooo`001`3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo0080oooo0P00003o0?ooo`@0oooo00000`3oool000000000000200000080oooo00@00000
0?ooo`3oool00000203oool3000000D0oooo00<000000?ooo`3oool0o`3oool30?ooo`001`3oool0
10000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0o`3oool30?ooo`00203oool2000000T0oooo100000040?ooo`030000003oool0
oooo0?l0oooo0`3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?oo
o`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?oo
o`<0oooo000K0?ooo`030000003oool0oooo02P0oooo0P0000040?ooo`030000003oool0oooo0080
oooo1000000T0?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0
oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P00000T0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`800000:P3oool4000000H0oooo000K0?ooo`030000003oool0oooo02L0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool08P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000280oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000[0?ooo`03
0000003oool0oooo00D0oooo000K0?ooo`800000:03oool010000000oooo0?ooo`0000090?ooo`03
0000003oool0oooo02<0oooo00@000000?ooo`3oool000001`3oool5000002<0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000R0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool00000:`3oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo
0?ooo`0W0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool08P3oool010000000
oooo0?ooo`0000070?ooo`040000003oool0oooo000002@0oooo00@000000?ooo`3oool00000203o
ool3000002<0oooo00@000000?ooo`3oool000002@3oool2000002`0oooo00<000000?ooo`3oool0
1@3oool001/0oooo00<000000?ooo`3oool09`3oool010000000oooo0?ooo`00000;0?ooo`030000
003oool0oooo0240oooo00@000000?ooo`3oool00000203oool00`000000oooo0000000T0?ooo`04
0000003oool0oooo000000P0oooo00<000000?ooo`3oool08`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002/0oooo00<000000?ooo`3oool01@3oool001/0oooo00<00000
0?ooo`3oool09`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000002<0oooo
00@000000?ooo`3oool000002@3oool2000002@0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`0S0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000:@3o
ool3000000L0oooo000K0?ooo`800000:@3oool2000000X0oooo0P00000U0?ooo`8000002`3oool0
0`000000oooo0?ooo`0S0?ooo`8000002P3oool3000002<0oooo0P00000:0?ooo`800000;03oool0
0`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`03
0000003oool0oooo0?l0oooo0`3oool001X0ooooo`3o00070?ooo`00503oool600000?l0o`001`00
000001X0ooooo`3o00070?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo
0300oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo
0300oooo00<000000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`00
6`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool0
0`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0
oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<0
00000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?oo
o`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000
003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool2
00000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000
oooo0?ooo`3o0?ooo`<0oooo00080?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<00000
1@3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00070?ooo`040000003oool0oooo000000/0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00070?ooo`040000003o
ool0oooo000000/0oooo00<000000?ooo`3oool00P3oool200000?l0oooo103oool000L0oooo00@0
00000?ooo`3oool00000203oool3000000D0oooo00<000000?ooo`3oool0o`3oool30?ooo`001`3o
ool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
o`3oool30?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0o`3oool30?ooo`00203oool2000000T0oooo100000040?ooo`800000o`3o
ool40?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo
0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool200000?l0oooo
103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o
0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo0P00003o0?ooo`@0
oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?oo
o`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000C0?ooo`@00000103oool00`000000oooo
0?ooo`3o0?ooo`<0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`005@3oool00`000000oooo0?ooo`030?ooo`800000o`3oool40?ooo`005@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000C0?ooo`<000001@3oool00`000000oooo
0?ooo`3o0?ooo`<0oooo000E0?ooo`030000003oool0oooo00<0oooo0P00003o0?ooo`@0oooo000K
0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?ooo`006`3o
ool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool0
01/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool200000?l0oooo103oool001/0oooo
00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K
0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`001`3o
ool4000000<0oooo00<000000?ooo`3oool00P3oool3000000D0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0o`3oool30?ooo`002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0080oooo0P00003o0?ooo`@0oooo00090?ooo`030000003oool0oooo00L0oooo0`0000050?ooo`03
0000003oool0oooo0?l0oooo0`3oool000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0oooo0`3oool000L0oooo0`0000090?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0o`3oool30?ooo`002@3oool00`000000oooo0?ooo`07
0?ooo`@00000103oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool0
01/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo000K0?ooo`800000o`3oool40?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K
0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?oo
o`006`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`004`3o
ool4000000@0oooo00<000000?ooo`3oool0o`3oool30?ooo`004`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0?l0oooo0`3oool001@0oooo00<000000?ooo`3oool0103oool20000
0?l0oooo103oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005P3oool00`000000oooo
0?ooo`3o0?ooo`P0oooo000C0?ooo`040000003oool0oooo00000?l0oooo2P3oool001@0oooo0P00
003o0?ooo`/0oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -2.15254, \
0.00394728, 0.0243309}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = 3;  (*\ Frequency\ *) \n
    Plot[Sin[\ 2\ \[Pi]\ f\ \ t + \ 0] + Sin[\ 2\ \[Pi]\ f\ \ t + 0]\n\t, {t, 
        0, 1}\n, PlotRange -> {\(-2\), 2}\n\t, 
      PlotStyle -> {Thickness[0.012], red}\n\t];\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.154508 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .07725 -24 -4.5 ]
[.01131 .07725 0 4.5 ]
[.01131 .15451 -12 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .23176 -24 -4.5 ]
[.01131 .23176 0 4.5 ]
[.01131 .38627 -18 -4.5 ]
[.01131 .38627 0 4.5 ]
[.01131 .46353 -6 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .54078 -18 -4.5 ]
[.01131 .54078 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 0 m
.03006 0 L
s
[(-2)] .01131 0 1 0 Mshowa
.02381 .07725 m
.03006 .07725 L
s
[(-1.5)] .01131 .07725 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-1)] .01131 .15451 1 0 Mshowa
.02381 .23176 m
.03006 .23176 L
s
[(-0.5)] .01131 .23176 1 0 Mshowa
.02381 .38627 m
.03006 .38627 L
s
[(0.5)] .01131 .38627 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(1)] .01131 .46353 1 0 Mshowa
.02381 .54078 m
.03006 .54078 L
s
[(1.5)] .01131 .54078 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(2)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .01545 m
.02756 .01545 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .04635 m
.02756 .04635 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .10816 m
.02756 .10816 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .13906 m
.02756 .13906 L
s
.02381 .16996 m
.02756 .16996 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20086 m
.02756 .20086 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26266 m
.02756 .26266 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .29357 m
.02756 .29357 L
s
.02381 .32447 m
.02756 .32447 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .35537 m
.02756 .35537 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .41717 m
.02756 .41717 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .44807 m
.02756 .44807 L
s
.02381 .47898 m
.02756 .47898 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .50988 m
.02756 .50988 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57168 m
.02756 .57168 L
s
.02381 .58713 m
.02756 .58713 L
s
.02381 .60258 m
.02756 .60258 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.012 w
.02381 .30902 m
.04262 .42141 L
.06244 .52295 L
.07286 .56405 L
.08255 .59265 L
.08813 .60443 L
.09076 .60876 L
.0932 .61203 L
.096 .61493 L
.09748 .61607 L
.09824 .61656 L
.09905 .617 L
.09976 .61733 L
.10041 .61757 L
.10168 .6179 L
.10239 .618 L
.10317 .61803 L
.1039 .618 L
.10458 .61791 L
.10587 .6176 L
.10651 .61736 L
.10722 .61704 L
.10848 .61633 L
.10966 .61549 L
.11231 .613 L
.11515 .6094 L
.12035 .60034 L
.1251 .58939 L
.13466 .55996 L
.14371 .52381 L
.18204 .31208 L
.20142 .19619 L
.21172 .1403 L
.22282 .08793 L
.23339 .04793 L
.23801 .03391 L
.24307 .02121 L
.24787 .01184 L
.25234 .00553 L
.25481 .00304 L
.25705 .00142 L
.25829 .00079 L
.259 .00051 L
.25964 .00031 L
.26083 7e-05 L
.26209 0 L
.2633 .00012 L
.26462 .00045 L
.26586 .00095 L
.26702 .00158 L
Mistroke
.2692 .00322 L
.27152 .00558 L
.27427 .0092 L
.27684 .01341 L
.28166 .02333 L
.29046 .04807 L
.29997 .08365 L
.31995 .18247 L
.34103 .30755 L
.36093 .42626 L
.37905 .51916 L
.3891 .55977 L
.3986 .58912 L
.40382 .60107 L
.40863 .60936 L
.41115 .6126 L
.41392 .61531 L
.41532 .61632 L
.41605 .61676 L
.41682 .61715 L
.41749 .61744 L
.41823 .61768 L
.41953 .61796 L
.42017 .61802 L
.42086 .61803 L
.42208 .61791 L
.42339 .61757 L
.42414 .61729 L
.42483 .61697 L
.42724 .61539 L
.4286 .6142 L
.42983 .61293 L
.43463 .60625 L
.43918 .59745 L
.44922 .56989 L
.46014 .52827 L
.47989 .42877 L
.50089 .30355 L
.52056 .1867 L
.53861 .09519 L
.54802 .05758 L
.55794 .02738 L
.56309 .0159 L
.56789 .00794 L
.57065 .00459 L
.57315 .00233 L
.57454 .00141 L
.57527 .00101 L
.57605 .00067 L
.57672 .00042 L
Mistroke
.57747 .00022 L
.57878 2e-05 L
.58007 3e-05 L
.58127 .00022 L
.58259 .00063 L
.58332 .00095 L
.58399 .00129 L
.58653 .0031 L
.58893 .00552 L
.59339 .01182 L
.59821 .02124 L
.6035 .03459 L
.60909 .05194 L
.61909 .09069 L
.65708 .29894 L
.67824 .42541 L
.69753 .52366 L
.70711 .56171 L
.71216 .5782 L
.71752 .59277 L
.7222 .60287 L
.72468 .60721 L
.72736 .61108 L
.72981 .61389 L
.73088 .61489 L
.73205 .61583 L
.73309 .61652 L
.7342 .61711 L
.73537 .61758 L
.73645 .61787 L
.73769 .61802 L
.73839 .61803 L
.73905 .61798 L
.73974 .61787 L
.74037 .61772 L
.7411 .61749 L
.74179 .61721 L
.74301 .61657 L
.74414 .61582 L
.74671 .61356 L
.74953 .61015 L
.75209 .60626 L
.75782 .59479 L
.76281 .58179 L
.7682 .56477 L
.77797 .52668 L
.81905 .29931 L
.83953 .17832 L
.84952 .12586 L
.85861 .08427 L
Mistroke
.86742 .05088 L
.87699 .02352 L
.88224 .01279 L
.88455 .00908 L
.88709 .00571 L
.88949 .00325 L
.89173 .00157 L
.89297 .0009 L
.8941 .00045 L
.89541 .00012 L
.89665 0 L
.89789 7e-05 L
.89859 .00019 L
.89924 .00035 L
.90042 .00078 L
.90168 .00142 L
.90385 .00298 L
.90623 .00534 L
.90878 .00861 L
.91151 .01297 L
.91645 .02301 L
.92606 .05031 L
.93483 .08338 L
.95391 .17711 L
.97467 .29969 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`004`3oool400000?l0oooo2P3o
ool001<0oooo00<000000?ooo`3oool0@P3oool60?l004h0oooo1P3o001?0?ooo`D0o`006P3oool0
01@0oooo00<000000?ooo`3oool0103oool2000003X0oooo203o001<0?ooo`P0o`00C03oool90?l0
01P0oooo000=0?ooo`@00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03P0
oooo2@3o001<0?ooo`P0o`00C03oool90?l001P0oooo000F0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0=`3oool50?l000030?ooo`3o0000o`0000<0o`00BP3oool40?l00080oooo
103o001:0?ooo`D0o`0000<0oooo0?l0003o00000`3o000G0?ooo`004`3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo03L0oooo103o00030?ooo`@0o`00B@3oool50?l000<0oooo
103o00190?ooo`@0o`000`3oool40?l001L0oooo000D0?ooo`8000001@3oool2000003L0oooo103o
00050?ooo`<0o`00B@3oool40?l000@0oooo1@3o00180?ooo`<0o`001@3oool30?l001L0oooo000K
0?ooo`030000003oool0oooo03H0oooo0`3o00070?ooo`<0o`00B03oool30?l000H0oooo103o0017
0?ooo`<0o`001`3oool30?l001H0oooo000K0?ooo`030000003oool0oooo03H0oooo0`3o00070?oo
o`<0o`00A`3oool30?l000P0oooo0`3o00170?ooo`<0o`001`3oool30?l001H0oooo000K0?ooo`03
0000003oool0oooo03D0oooo103o00070?ooo`@0o`00AP3oool30?l000P0oooo103o00150?ooo`@0
o`001`3oool40?l001D0oooo000K0?ooo`800000=P3oool30?l000T0oooo0`3o00160?ooo`<0o`00
2@3oool30?l004D0oooo0`3o00090?ooo`<0o`005@3oool001/0oooo00<000000?ooo`3oool0=@3o
ool30?l000T0oooo0`3o00150?ooo`<0o`002P3oool30?l004D0oooo0`3o00090?ooo`<0o`005@3o
ool001/0oooo00<000000?ooo`3oool0=@3oool30?l000X0oooo0`3o00140?ooo`<0o`002P3oool4
0?l004<0oooo0`3o000;0?ooo`<0o`00503oool001/0oooo00<000000?ooo`3oool0=03oool40?l0
00X0oooo0`3o00130?ooo`@0o`002`3oool30?l004<0oooo0`3o000;0?ooo`<0o`00503oool001/0
oooo0P00000e0?ooo`<0o`002`3oool40?l00480oooo0`3o000<0?ooo`<0o`00@P3oool40?l000/0
oooo103o000C0?ooo`006`3oool00`000000oooo0?ooo`0d0?ooo`<0o`00303oool30?l00480oooo
0`3o000<0?ooo`@0o`00@@3oool30?l000d0oooo0`3o000C0?ooo`006`3oool00`000000oooo0?oo
o`0d0?ooo`<0o`00303oool30?l00440oooo0`3o000>0?ooo`<0o`00@@3oool30?l000d0oooo0`3o
000C0?ooo`006`3oool00`000000oooo0?ooo`0c0?ooo`<0o`003@3oool30?l00440oooo0`3o000>
0?ooo`<0o`00@@3oool30?l000d0oooo0`3o000C0?ooo`006`3oool2000003@0oooo0`3o000>0?oo
o`<0o`00@03oool30?l000h0oooo0`3o00100?ooo`<0o`003`3oool30?l00180oooo000K0?ooo`03
0000003oool0oooo03<0oooo0`3o000>0?ooo`<0o`00@03oool30?l000l0oooo0`3o000o0?ooo`<0
o`003`3oool30?l00180oooo00070?ooo`@000000`3oool00`000000oooo0?ooo`020?ooo`<00000
1@3oool00`000000oooo0?ooo`0b0?ooo`@0o`003P3oool30?l003l0oooo0`3o000@0?ooo`<0o`00
?`3oool30?l000l0oooo0`3o000B0?ooo`002@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0<P3oool30?l000l0oooo0`3o000o0?ooo`<0o`00403o
ool30?l003l0oooo0`3o000?0?ooo`<0o`004P3oool000T0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`020?ooo`800000<`3oool30?l00100oooo0`3o000n0?ooo`<0o`00403oool3
0?l003h0oooo0`3o000A0?ooo`<0o`004@3oool000030?ooo`000000000000800000103oool00`00
0000oooo0?ooo`070?ooo`<000001@3oool00`000000oooo0?ooo`0b0?ooo`<0o`00403oool30?l0
03h0oooo0`3o000@0?ooo`<0o`00?P3oool30?l00140oooo0`3o000A0?ooo`002@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<@3oool30?l00140
oooo0`3o000n0?ooo`<0o`004@3oool30?l003d0oooo0`3o000A0?ooo`<0o`004@3oool000L0oooo
0`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<@3oool30?l00140oooo
0`3o000m0?ooo`<0o`004P3oool30?l003d0oooo0`3o000A0?ooo`<0o`004@3oool000T0oooo00<0
00000?ooo`3oool01`3oool4000000@0oooo0P00000b0?ooo`<0o`004@3oool40?l003`0oooo0`3o
000B0?ooo`<0o`00?03oool40?l00140oooo0`3o000A0?ooo`006`3oool00`000000oooo0?ooo`0a
0?ooo`<0o`004P3oool30?l003`0oooo0`3o000B0?ooo`<0o`00?03oool30?l001<0oooo0`3o000@
0?ooo`006`3oool00`000000oooo0?ooo`0`0?ooo`<0o`004`3oool30?l003`0oooo0`3o000B0?oo
o`<0o`00?03oool30?l001<0oooo0`3o000@0?ooo`006`3oool00`000000oooo0?ooo`0`0?ooo`<0
o`004`3oool30?l003`0oooo0`3o000C0?ooo`<0o`00>`3oool30?l001<0oooo0`3o000@0?ooo`00
6`3oool00`000000oooo0?ooo`0`0?ooo`<0o`004`3oool30?l003/0oooo0`3o000D0?ooo`<0o`00
>P3oool30?l001@0oooo0`3o000@0?ooo`006`3oool200000340oooo0`3o000D0?ooo`<0o`00>P3o
ool30?l001@0oooo0`3o000j0?ooo`<0o`00503oool30?l00100oooo000K0?ooo`030000003oool0
oooo02l0oooo103o000D0?ooo`<0o`00>P3oool30?l001@0oooo0`3o000j0?ooo`<0o`005@3oool3
0?l000l0oooo000K0?ooo`030000003oool0oooo02l0oooo0`3o000E0?ooo`<0o`00>P3oool30?l0
01@0oooo0`3o000i0?ooo`@0o`005@3oool30?l000l0oooo000K0?ooo`030000003oool0oooo02l0
oooo0`3o000E0?ooo`<0o`00>P3oool30?l001@0oooo0`3o000i0?ooo`<0o`005P3oool30?l000l0
oooo000K0?ooo`800000<03oool30?l001D0oooo103o000h0?ooo`<0o`005P3oool30?l003P0oooo
0`3o000F0?ooo`<0o`003`3oool001/0oooo00<000000?ooo`3oool0;`3oool30?l001H0oooo0`3o
000h0?ooo`<0o`005P3oool30?l003P0oooo0`3o000F0?ooo`<0o`003`3oool001/0oooo00<00000
0?ooo`3oool0;P3oool30?l001L0oooo0`3o000h0?ooo`<0o`005P3oool30?l003P0oooo0`3o000G
0?ooo`<0o`003P3oool001/0oooo00<000000?ooo`3oool0;P3oool30?l001L0oooo0`3o000h0?oo
o`<0o`005P3oool30?l003P0oooo0`3o000G0?ooo`<0o`003P3oool001/0oooo0P00000_0?ooo`<0
o`005`3oool40?l003H0oooo103o000F0?ooo`<0o`00=`3oool30?l001P0oooo0`3o000>0?ooo`00
6`3oool00`000000oooo0?ooo`0^0?ooo`<0o`00603oool30?l003H0oooo0`3o000H0?ooo`<0o`00
=P3oool30?l001P0oooo0`3o000>0?ooo`004`3oool4000000@0oooo00<000000?ooo`3oool0;P3o
ool30?l001P0oooo0`3o000f0?ooo`<0o`00603oool30?l003H0oooo0`3o000H0?ooo`<0o`003P3o
ool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0]0?ooo`<0o`006@3oool3
0?l003H0oooo0`3o000H0?ooo`<0o`00=P3oool30?l001T0oooo0`3o000=0?ooo`005@3oool00`00
0000oooo0?ooo`030?ooo`800000;P3oool30?l001T0oooo0`3o000f0?ooo`<0o`00603oool30?l0
03H0oooo0`3o000I0?ooo`<0o`003@3oool000d0oooo100000040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0;@3oool30?l001X0oooo0`3o000d0?ooo`<0o`006@3oool30?l003H0
oooo0`3o000I0?ooo`<0o`003@3oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0]0?ooo`<0o`006P3oool30?l003@0oooo0`3o000I0?ooo`<0o`00=P3oool30?l001T0oooo
0`3o000=0?ooo`004`3oool3000000D0oooo00<000000?ooo`3oool0;@3oool30?l001X0oooo0`3o
000d0?ooo`<0o`006P3oool30?l003@0oooo0`3o000J0?ooo`<0o`003@3oool001D0oooo00<00000
0?ooo`3oool00`3oool2000002d0oooo0`3o000K0?ooo`<0o`00=03oool30?l001X0oooo0`3o000d
0?ooo`<0o`006`3oool30?l000`0oooo000K0?ooo`030000003oool0oooo02`0oooo0`3o000K0?oo
o`@0o`00<`3oool30?l001X0oooo0`3o000d0?ooo`<0o`006`3oool30?l000`0oooo000K0?ooo`03
0000003oool0oooo02`0oooo0`3o000L0?ooo`<0o`00<P3oool30?l001/0oooo0`3o000d0?ooo`<0
o`006`3oool30?l000`0oooo000K0?ooo`030000003oool0oooo02`0oooo0`3o000L0?ooo`<0o`00
<P3oool30?l001/0oooo0`3o000d0?ooo`<0o`006`3oool30?l000`0oooo000K0?ooo`800000;@3o
ool30?l001`0oooo0`3o000b0?ooo`<0o`00703oool30?l003<0oooo0`3o000K0?ooo`<0o`00303o
ool001/0oooo00<000000?ooo`3oool0:`3oool30?l001d0oooo0`3o000b0?ooo`<0o`00703oool3
0?l00380oooo0`3o000M0?ooo`<0o`002`3oool001/0oooo00<000000?ooo`3oool0:`3oool30?l0
01d0oooo0`3o000b0?ooo`<0o`00703oool30?l00380oooo0`3o000M0?ooo`<0o`002`3oool001/0
oooo00<000000?ooo`3oool0:`3oool30?l001h0oooo0`3o000a0?ooo`<0o`00703oool30?l00380
oooo0`3o000M0?ooo`<0o`002`3oool001/0oooo0P00000/0?ooo`<0o`007P3oool30?l00300oooo
0`3o000M0?ooo`<0o`00<P3oool30?l001d0oooo0`3o000;0?ooo`006`3oool00`000000oooo0?oo
o`0[0?ooo`<0o`007P3oool30?l00300oooo0`3o000M0?ooo`<0o`00<P3oool30?l001d0oooo0`3o
000;0?ooo`006`3oool00`000000oooo0?ooo`0Z0?ooo`@0o`007P3oool30?l00300oooo0`3o000N
0?ooo`<0o`00<03oool40?l001d0oooo0`3o000;0?ooo`006`3oool00`000000oooo0?ooo`0Z0?oo
o`<0o`007`3oool30?l00300oooo0`3o000N0?ooo`<0o`00<03oool30?l001l0oooo0`3o000:0?oo
o`006`3oool2000002/0oooo0`3o000O0?ooo`<0o`00<03oool30?l001h0oooo0`3o000`0?ooo`<0
o`007`3oool30?l000X0oooo000K0?ooo`030000003oool0oooo02X0oooo0`3o000O0?ooo`<0o`00
<03oool30?l001h0oooo0`3o000`0?ooo`<0o`007`3oool30?l000X0oooo00080?ooo`800000103o
ool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`0Z0?ooo`<0o`00803o
ool30?l002h0oooo0`3o000O0?ooo`<0o`00<03oool30?l001l0oooo0`3o000:0?ooo`001`3oool0
10000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0:P3o
ool30?l00200oooo0`3o000^0?ooo`<0o`00803oool30?l002l0oooo0`3o000O0?ooo`<0o`002P3o
ool000L0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`800000:`3o
ool30?l00200oooo0`3o000^0?ooo`<0o`00803oool30?l002h0oooo0`3o000Q0?ooo`<0o`002@3o
ool000030?ooo`0000000000008000000P3oool010000000oooo0?ooo`0000080?ooo`<000001@3o
ool00`000000oooo0?ooo`0Y0?ooo`<0o`008@3oool30?l002h0oooo0`3o000P0?ooo`<0o`00;P3o
ool30?l00240oooo0`3o00090?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0:@3oool30?l00240oooo0`3o000^0?ooo`<0o`00803o
ool30?l002h0oooo0`3o000Q0?ooo`<0o`002@3oool000L0oooo00@000000?ooo`3oool00000203o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02T0oooo0`3o000Q0?ooo`<0o`00;P3o
ool30?l00200oooo0`3o000^0?ooo`<0o`008@3oool30?l000T0oooo00080?ooo`8000002@3oool4
000000@0oooo00<000000?ooo`3oool0:@3oool30?l00240oooo103o000/0?ooo`@0o`00803oool3
0?l002h0oooo0`3o000Q0?ooo`<0o`002@3oool001/0oooo0P00000Z0?ooo`<0o`008P3oool30?l0
02`0oooo0`3o000R0?ooo`<0o`00;03oool30?l00280oooo0`3o00090?ooo`006`3oool00`000000
oooo0?ooo`0Y0?ooo`<0o`008P3oool30?l002`0oooo0`3o000R0?ooo`<0o`00;03oool30?l002<0
oooo0`3o00080?ooo`006`3oool00`000000oooo0?ooo`0X0?ooo`<0o`008`3oool30?l002`0oooo
0`3o000R0?ooo`<0o`00;03oool30?l002<0oooo0`3o00080?ooo`006`3oool00`000000oooo0?oo
o`0X0?ooo`<0o`008`3oool30?l002`0oooo0`3o000R0?ooo`<0o`00;03oool30?l002<0oooo0`3o
00080?ooo`006`3oool2000002T0oooo0`3o000S0?ooo`<0o`00;03oool30?l00280oooo0`3o000/
0?ooo`<0o`008`3oool30?l000P0oooo000K0?ooo`030000003oool0oooo02P0oooo0`3o000S0?oo
o`<0o`00;03oool30?l002<0oooo0`3o000Z0?ooo`@0o`008`3oool30?l000P0oooo000K0?ooo`03
0000003oool0oooo02P0oooo0`3o00030?ooo`030000003oool0oooo0080oooo1000000H0?ooo`<0
o`002@3oool2000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`<0
o`003`3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000L0oooo0`3o000J0?ooo`80
0000103oool00`000000oooo0?ooo`030?ooo`8000000P3oool30?l002D0oooo0`3o00000`000000
oooo0?ooo`040?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`040000003o0000o`000?l000P0
oooo00<000000?ooo`3oool06@3oool30?l000P0oooo00@000000?ooo`3oool000002P3oool00`00
0000oooo0?ooo`0A0?ooo`<0o`003P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000000H0oooo0`3o000I0?ooo`040000003oool0oooo000000P0oooo00D000000?ooo`3oool0
00000?ooo`030?l002D0oooo0`3o00070?ooo`006`3oool2000002P0oooo0`3o00000`000000oooo
0?ooo`070?ooo`030000003oool0oooo01P0oooo0`3o00080?ooo`040000003oool0oooo000000L0
oooo1@00000B0?ooo`<0o`003P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000000H0oooo0`3o000I0?ooo`040000003oool0oooo000000P0oooo00D000000?ooo`3oool00000
0?ooo`030?l002D0oooo0`3o00070?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`<0o`0000<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`<0o`00203oool010000000oooo0?oo
o`0000070?ooo`040000003oool0oooo000001<0oooo0`3o000>0?ooo`040000003oool0oooo0000
00P0oooo0`0000070?ooo`<0o`006@3oool010000000oooo0?ooo`0000090?ooo`8000000P3oool3
0?l002D0oooo0`3o00070?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`<0o`0000<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`<0o`00203oool010000000oooo0?ooo`000008
0?ooo`030000003oool0000001<0oooo0`3o000>0?ooo`040000003oool0oooo000000P0oooo00<0
00000?ooo`3oool01`3oool30?l001T0oooo00@000000?ooo`3oool00000203oool01@000000oooo
0?ooo`000000oooo00<0o`009@3oool30?l000L0oooo000K0?ooo`030000003oool0oooo02L0oooo
0`3o00000`000000oooo0?ooo`060?ooo`040000003oool0oooo000001P0oooo0`3o00080?ooo`04
0000003oool0oooo000000T0oooo0P00000C0?ooo`<0o`003P3oool010000000oooo0?ooo`000008
0?ooo`030000003oool0oooo00P0oooo0`3o000H0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000`3o000V0?ooo`<0o`001`3oool001/0oooo0P00000X0?ooo`<0o`002P3o
ool2000001T0oooo0`3o00090?ooo`8000002`3oool00`000000oooo0?ooo`0@0?ooo`<0o`00403o
ool2000000X0oooo0`0000070?ooo`<0o`006@3oool2000000X0oooo0P000000103oool0o`000?l0
003o000W0?ooo`<0o`001P3oool001/0oooo00<000000?ooo`3oool09`3oool30?l002H0oooo0`3o
000X0?ooo`<0o`009P3oool30?l002P0oooo0`3o000W0?ooo`<0o`001P3oool001/0oooo00<00000
0?ooo`3oool09P3oool40?l002H0oooo0`3o000X0?ooo`<0o`009P3oool30?l002P0oooo0`3o000W
0?ooo`<0o`001P3oool001X0oooo0`3o000W0?ooo`<0o`009`3oool30?l002P0oooo0`3o000V0?oo
o`<0o`00:03oool30?l002L0oooo0`3o00060?ooo`00503oool6000000<0o`009`0000030?l002L0
00000`3o000X000000<0o`009`0000030?l002H000000`3o000X000000<0o`001P00000001X0oooo
0`3o000:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`030?l000H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00@0oooo0`3o00020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`<0o`002P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00@000000?ooo`3oool0oooo0`3o00060?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`<0o`000`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool30?l000H0
oooo000J0?ooo`<0o`009`3oool30?l000H0oooo00<000000?ooo`3oool07P3oool30?l000l0oooo
00<000000?ooo`3oool05@3oool30?l001P0oooo00<000000?ooo`3oool03@3oool30?l001l0oooo
00<000000?ooo`3oool0103oool30?l002T0oooo00<000000?ooo`3oool01@3oool001X0oooo103o
000V0?ooo`<0o`00:03oool30?l002H0oooo0`3o000X0?ooo`<0o`009P3oool30?l00340oooo000K
0?ooo`<0o`009@3oool30?l002T0oooo0`3o000V0?ooo`<0o`00:03oool30?l002H0oooo0`3o000a
0?ooo`006`3oool30?l002D0oooo0`3o000Y0?ooo`<0o`009P3oool30?l002P0oooo0`3o000V0?oo
o`<0o`00<@3oool001/0oooo0`3o000U0?ooo`<0o`00:@3oool30?l002H0oooo0`3o000Y0?ooo`<0
o`00903oool30?l00380oooo000K0?ooo`<0o`009@3oool30?l002T0oooo0`3o000V0?ooo`<0o`00
:@3oool30?l002@0oooo0`3o000b0?ooo`006`3oool30?l002D0oooo0`3o000Z0?ooo`<0o`00903o
ool30?l002X0oooo0`3o000T0?ooo`<0o`00<P3oool001/0oooo103o000T0?ooo`<0o`00:P3oool3
0?l002@0oooo0`3o000Z0?ooo`<0o`00903oool30?l00380oooo000K0?ooo`040000003o0000o`00
0?l002<0oooo0`3o000[0?ooo`<0o`00903oool30?l002X0oooo0`3o000T0?ooo`<0o`00<P3oool0
01/0oooo00@000000?l0003o0000o`008`3oool30?l002/0oooo0`3o000T0?ooo`<0o`00:P3oool3
0?l002<0oooo0`3o000c0?ooo`006`3oool010000000o`000?l0003o000S0?ooo`<0o`00:`3oool3
0?l002@0oooo0`3o000[0?ooo`<0o`008P3oool30?l003<0oooo000K0?ooo`040000003o0000o`00
0?l002<0oooo0`3o000[0?ooo`@0o`008P3oool30?l002`0oooo0`3o000R0?ooo`<0o`00<`3oool0
01/0oooo00@000000?l0003o0000o`008`3oool30?l002`0oooo0`3o000R0?ooo`<0o`00;03oool3
0?l00280oooo0`3o000c0?ooo`006`3oool00`000000o`000?l000020?l00240oooo103o000/0?oo
o`<0o`008P3oool30?l002`0oooo0`3o000R0?ooo`<0o`00<`3oool001/0oooo0P0000030?l00240
oooo0`3o000]0?ooo`<0o`008P3oool30?l002`0oooo0`3o000R0?ooo`<0o`00<`3oool001/0oooo
00<000000?ooo`3o00000P3o000Q0?ooo`<0o`00;@3oool30?l00280oooo0`3o000]0?ooo`<0o`00
803oool30?l003@0oooo000K0?ooo`030000003oool0o`000080o`008@3oool30?l002d0oooo103o
000Q0?ooo`<0o`00;@3oool30?l00200oooo0`3o000d0?ooo`00203oool2000000@0oooo00<00000
0?ooo`3oool00P3oool3000000D0oooo00<000000?ooo`3o00000P3o000Q0?ooo`<0o`00;P3oool3
0?l00200oooo0`3o000^0?ooo`<0o`00803oool30?l003@0oooo00070?ooo`040000003oool0oooo
000000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?l000020?l00240oooo0`3o000^
0?ooo`<0o`00803oool30?l002h0oooo0`3o000P0?ooo`<0o`00=03oool000L0oooo00@000000?oo
o`3oool000002`3oool00`000000oooo0?ooo`020?ooo`800000103o000O0?ooo`<0o`00;`3oool3
0?l00200oooo0`3o000^0?ooo`<0o`00803oool30?l003@0oooo00070?ooo`040000003oool0oooo
000000P0oooo0`0000050?ooo`030000003oool0oooo00<0o`007`3oool30?l002l0oooo0`3o000P
0?ooo`<0o`00;P3oool30?l001l0oooo103o000d0?ooo`001`3oool010000000oooo0?ooo`000008
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3o000O0?ooo`<0o`00;`3oool3
0?l00200oooo0`3o000_0?ooo`<0o`007P3oool30?l003D0oooo00070?ooo`040000003oool0oooo
000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?l001l0oooo0`3o000`
0?ooo`<0o`007P3oool30?l00300oooo0`3o000N0?ooo`<0o`00=@3oool000P0oooo0P0000090?oo
o`@00000103oool2000000040?ooo`3o0000o`000?l001l0oooo0`3o000`0?ooo`<0o`007P3oool3
0?l00300oooo0`3o000N0?ooo`<0o`00=@3oool001/0oooo00<000000?ooo`3oool00`3o000O0?oo
o`<0o`00<03oool30?l001h0oooo0`3o000`0?ooo`<0o`007P3oool30?l003D0oooo000K0?ooo`03
0000003oool0oooo00@0o`007@3oool30?l00340oooo0`3o000N0?ooo`<0o`00<03oool30?l001h0
oooo0`3o000e0?ooo`006`3oool010000000oooo0?ooo`3oool30?l001d0oooo0`3o000a0?ooo`<0
o`007P3oool30?l00300oooo0`3o000M0?ooo`<0o`00=P3oool001/0oooo0P0000020?ooo`<0o`00
7@3oool30?l00380oooo0`3o000M0?ooo`<0o`00<@3oool30?l001`0oooo0`3o000f0?ooo`006`3o
ool010000000oooo0?ooo`3oool30?l001d0oooo0`3o000b0?ooo`<0o`00703oool30?l00380oooo
0`3o000L0?ooo`<0o`00=P3oool001/0oooo00@000000?ooo`3oool0oooo0`3o000M0?ooo`<0o`00
<P3oool30?l001`0oooo0`3o000b0?ooo`<0o`00703oool30?l003H0oooo000K0?ooo`040000003o
ool0oooo0?ooo`<0o`00703oool30?l003<0oooo0`3o000L0?ooo`<0o`00<P3oool30?l001`0oooo
0`3o000f0?ooo`006`3oool2000000<0oooo0`3o000K0?ooo`<0o`00<`3oool30?l001`0oooo0`3o
000b0?ooo`<0o`006`3oool40?l003H0oooo000K0?ooo`030000003oool0oooo0080oooo0`3o000K
0?ooo`<0o`00<`3oool30?l001`0oooo0`3o000c0?ooo`<0o`006P3oool30?l003L0oooo000K0?oo
o`030000003oool0oooo0080oooo0`3o000K0?ooo`<0o`00=03oool30?l001X0oooo0`3o000d0?oo
o`<0o`006P3oool30?l003L0oooo000K0?ooo`030000003oool0oooo0080oooo0`3o000K0?ooo`<0
o`00=03oool30?l001X0oooo0`3o000d0?ooo`<0o`006P3oool30?l003L0oooo000K0?ooo`800000
0`3oool30?l001/0oooo0`3o000d0?ooo`<0o`006P3oool30?l003@0oooo0`3o000J0?ooo`<0o`00
=`3oool001/0oooo00<000000?ooo`3oool00P3oool40?l001T0oooo0`3o000e0?ooo`<0o`006P3o
ool30?l003@0oooo0`3o000J0?ooo`<0o`00=`3oool001<0oooo100000040?ooo`030000003oool0
oooo00<0oooo0`3o000I0?ooo`<0o`00=@3oool30?l001X0oooo0`3o000e0?ooo`<0o`00603oool3
0?l003P0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool30?l0
01T0oooo0`3o000e0?ooo`<0o`006@3oool30?l003H0oooo0`3o000H0?ooo`<0o`00>03oool001D0
oooo00<000000?ooo`3oool00`3oool2000000@0oooo0`3o000I0?ooo`<0o`00=P3oool30?l001P0
oooo0`3o000f0?ooo`<0o`00603oool30?l003P0oooo000E0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00`3oool30?l001T0oooo0`3o000f0?ooo`<0o`00603oool30?l003H0oooo
0`3o000H0?ooo`<0o`00>03oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`<0o`00603oool40?l003H0oooo0`3o000H0?ooo`<0o`00=P3oool30?l001P0oooo0`3o
000h0?ooo`004`3oool3000000D0oooo00<000000?ooo`3oool0103oool30?l001L0oooo0`3o000g
0?ooo`<0o`00603oool30?l003H0oooo103o000G0?ooo`<0o`00>03oool001D0oooo00<000000?oo
o`3oool00`3oool2000000D0oooo0`3o000G0?ooo`<0o`00=`3oool30?l001L0oooo103o000g0?oo
o`<0o`005P3oool30?l003T0oooo000K0?ooo`030000003oool0oooo00@0oooo0`3o000G0?ooo`<0
o`00=`3oool30?l001L0oooo0`3o000h0?ooo`<0o`005P3oool30?l003T0oooo000K0?ooo`030000
003oool0oooo00@0oooo0`3o000G0?ooo`<0o`00>03oool30?l001H0oooo0`3o000h0?ooo`<0o`00
5P3oool30?l003T0oooo000K0?ooo`030000003oool0oooo00@0oooo0`3o000G0?ooo`<0o`00>03o
ool30?l001H0oooo0`3o000h0?ooo`<0o`005P3oool30?l003T0oooo000K0?ooo`8000001@3oool4
0?l001D0oooo0`3o000i0?ooo`<0o`005P3oool30?l003P0oooo0`3o000F0?ooo`<0o`00>@3oool0
01/0oooo00<000000?ooo`3oool01@3oool30?l001D0oooo0`3o000i0?ooo`<0o`005P3oool30?l0
03T0oooo0`3o000D0?ooo`<0o`00>P3oool001/0oooo00<000000?ooo`3oool01@3oool30?l001D0
oooo0`3o000i0?ooo`<0o`005@3oool30?l003X0oooo0`3o000D0?ooo`<0o`00>P3oool001/0oooo
00<000000?ooo`3oool01@3oool30?l001D0oooo0`3o000i0?ooo`<0o`005@3oool30?l003X0oooo
0`3o000D0?ooo`<0o`00>P3oool001/0oooo0P0000060?ooo`<0o`005@3oool30?l003X0oooo0`3o
000D0?ooo`<0o`00>P3oool30?l001@0oooo0`3o000j0?ooo`006`3oool00`000000oooo0?ooo`05
0?ooo`<0o`005@3oool30?l003X0oooo0`3o000D0?ooo`<0o`00>P3oool30?l001@0oooo0`3o000j
0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`<0o`004`3oool30?l003/0oooo0`3o000D0?oo
o`<0o`00>`3oool30?l001<0oooo0`3o000j0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`<0
o`004`3oool30?l003/0oooo0`3o000C0?ooo`<0o`00?03oool30?l00180oooo0`3o000k0?ooo`00
6`3oool00`000000oooo0?ooo`060?ooo`<0o`004`3oool30?l003/0oooo0`3o000C0?ooo`<0o`00
?03oool30?l00180oooo0`3o000k0?ooo`006`3oool2000000L0oooo0`3o000C0?ooo`<0o`00>`3o
ool40?l00180oooo0`3o000l0?ooo`<0o`004P3oool30?l003/0oooo000K0?ooo`030000003oool0
oooo00H0oooo103o000A0?ooo`<0o`00?@3oool30?l00180oooo0`3o000m0?ooo`<0o`004@3oool3
0?l003/0oooo00070?ooo`@000000`3oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`00
0000oooo0?ooo`070?ooo`<0o`004@3oool30?l003d0oooo0`3o000A0?ooo`@0o`00?@3oool30?l0
0140oooo0`3o000k0?ooo`002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01`3oool30?l00140oooo0`3o000m0?ooo`<0o`004@3oool30?l003h0
oooo0`3o000@0?ooo`<0o`00?03oool000T0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`020?ooo`800000203oool30?l00100oooo103o000n0?ooo`<0o`00403oool30?l003h0oooo
103o000?0?ooo`<0o`00?03oool000T0oooo00<000000?ooo`3oool01`3oool3000000D0oooo00<0
00000?ooo`3oool0203oool30?l000l0oooo0`3o000o0?ooo`<0o`00403oool30?l003l0oooo0`3o
000?0?ooo`<0o`00?03oool000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00P0oooo0`3o000?0?ooo`<0o`00?`3oool30?l000l0oooo0`3o0010
0?ooo`<0o`003`3oool30?l003`0oooo00070?ooo`<000002@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00P0oooo0`3o000?0?ooo`<0o`00?`3oool40?l000h0oooo0`3o00100?oo
o`<0o`003`3oool30?l003`0oooo00090?ooo`030000003oool0oooo00L0oooo100000040?ooo`80
00002@3oool40?l000d0oooo0`3o00110?ooo`<0o`003P3oool30?l00440oooo0`3o000=0?ooo`<0
o`00?@3oool001/0oooo00<000000?ooo`3oool02@3oool30?l000d0oooo0`3o00110?ooo`<0o`00
3@3oool40?l00440oooo0`3o000=0?ooo`<0o`00?@3oool001/0oooo00<000000?ooo`3oool02@3o
ool30?l000d0oooo0`3o00110?ooo`<0o`003@3oool30?l00480oooo0`3o000=0?ooo`<0o`00?@3o
ool001/0oooo00<000000?ooo`3oool02@3oool30?l000`0oooo103o00120?ooo`<0o`00303oool3
0?l00480oooo0`3o000<0?ooo`@0o`00?@3oool001/0oooo0P00000;0?ooo`<0o`002`3oool30?l0
04<0oooo0`3o000<0?ooo`<0o`00@`3oool30?l000/0oooo0`3o000n0?ooo`006`3oool00`000000
oooo0?ooo`0:0?ooo`<0o`002`3oool30?l004<0oooo103o000:0?ooo`<0o`00A03oool30?l000/0
oooo0`3o000n0?ooo`006`3oool00`000000oooo0?ooo`0:0?ooo`<0o`002`3oool30?l004@0oooo
0`3o000:0?ooo`<0o`00A03oool30?l000X0oooo103o000n0?ooo`006`3oool00`000000oooo0?oo
o`0:0?ooo`<0o`002P3oool40?l004@0oooo0`3o00090?ooo`@0o`00A03oool30?l000X0oooo0`3o
000o0?ooo`006`3oool2000000`0oooo0`3o00090?ooo`<0o`00AP3oool30?l000P0oooo0`3o0015
0?ooo`@0o`002@3oool30?l003l0oooo000K0?ooo`030000003oool0oooo00/0oooo0`3o00090?oo
o`<0o`00AP3oool30?l000P0oooo0`3o00160?ooo`<0o`00203oool30?l00400oooo000K0?ooo`03
0000003oool0oooo00/0oooo103o00080?ooo`<0o`00AP3oool30?l000L0oooo0`3o00170?ooo`@0
o`001`3oool30?l00400oooo000K0?ooo`030000003oool0oooo00`0oooo0`3o00070?ooo`<0o`00
B03oool30?l000H0oooo0`3o00170?ooo`D0o`001P3oool30?l00400oooo000K0?ooo`8000003@3o
ool40?l000D0oooo103o00180?ooo`<0o`001@3oool40?l004P0oooo103o00050?ooo`<0o`00@@3o
ool001/0oooo00<000000?ooo`3oool03@3oool40?l000<0oooo1@3o00180?ooo`@0o`00103oool3
0?l004X0oooo103o00030?ooo`@0o`00@@3oool001<0oooo100000040?ooo`030000003oool0oooo
00d0oooo1@3o00000`3oool0o`000?l000030?l004X0oooo103o00020?ooo`@0o`00BP3oool50?l0
00030?ooo`3o0000o`0000<0o`00@@3oool001<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0>0?ooo`T0o`00B`3oool90?l004`0oooo2@3o00120?ooo`00503oool00`000000oooo
0?ooo`040?ooo`8000003`3oool80?l004d0oooo203o001=0?ooo`L0o`00@`3oool001D0oooo00<0
00000?ooo`3oool05@3oool70?l004h0oooo1P3o001>0?ooo`H0o`00A03oool001H0oooo00<00000
0?ooo`3oool0o`3oool80?ooo`004`3oool010000000oooo0?ooo`00003o0?ooo`X0oooo000D0?oo
o`800000o`3oool;0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -2.15254, \
0.00394728, 0.0243309}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Listen Interference and Beats", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Play[Sin[\ 2\ \[Pi]\ 440\ t], {t, 0, 1}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
8192 8192 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound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pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`00000Q
0000000000<000000?ooo`3oool0o`00000N0000000000<000000?ooo`000000o`00000N00000000
00<000000?ooo`000000o`00000N0000000000<000000?ooo`0000000P0000000`3oool000000000
0007000000030?ooo`000000000000T0000000<0oooo000000000000;P0000000`3oool000000000
0007000000030?ooo`000000000000T0000000<0oooo000000000000;P0000000`3oool000000000
0007000000030?ooo`000000000000T0000000<0oooo000000000000;P0000000`3oool000000000
0007000000030?ooo`000000000000T0000000<0oooo000000000000;@00000000030000003oool0
000000d0000000<0oooo0000000000001`0000000`3oool000000000000T000000030?ooo`000000
00000080000000<0oooo0000000000003P0000000`3oool0000000000007000000030?ooo`000000
000002@0000000<0oooo0000000000000P0000000`3oool000000000000>000000030?ooo`000000
000000L0000000<0oooo000000000000900000000`3oool0000000000002000000030?ooo`000000
000000h0000000<0oooo0000000000001`0000000`3oool000000000000T000000030?ooo`000000
00000080000000<0oooo0000000000000P00000000030000003oool0000000L0000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`000000000000T0000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`000000000000T0000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`00000000000080000000<0oooo0000
000000002@0000000`3oool0000000000002000000030?ooo`00000000000080000000<0oooo0000
000000002@0000000`3oool0000000000002000000030?ooo`00000000000080000000<0oooo0000
000000002@0000000`3oool0000000000002000000030?ooo`00000000000080000000<0oooo0000
000000000P0000000`3oool0000000000009000000030?ooo`00000000000080000000<0oooo0000
000000000P0000000`3oool0000000000009000000030?ooo`00000000000080000000<0oooo0000
000000000P0000000`3oool0000000000009000000030?ooo`00000000000080000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`000000000000T0000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`000000000000T0000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`000000000000T0000000<0oooo0000
000000000P0000000`3oool0000000000002000000030?ooo`00000000000080000000<0oooo0000
000000000`00000000030000003oool0000000H0000000<0oooo0000000000004`0000000`3oool0
00000000000C000000030?ooo`00000000000080000000<0oooo0000000000004`0000000`3oool0
00000000000C000000030?ooo`000000000001<0000000<0oooo0000000000000P0000000`3oool0
00000000000C000000030?ooo`000000000001<0000000<0oooo0000000000004`0000000`3oool0
000000000002000000030?ooo`000000000001<0000000<0oooo0000000000004`0000000`3oool0
00000000000C000000030?ooo`00000000000080000000<0oooo0000000000003P00000000030000
003oool000000?l000007P00000000030000003oool000000?l000007P00000000030000003oool0
00000?l000007P00000000030000003oool0000000L0000000<0oooo0000000000004`0000000`3o
ool000000000000^000000030?ooo`000000000001<0000000<0oooo000000000000;P0000000`3o
ool000000000000C000000030?ooo`000000000002h0000000<0oooo0000000000004`0000000`3o
ool000000000000X0000000000<000000?ooo`0000001P0000000`3oool000000000000900000003
0?ooo`000000000001<0000000<0oooo000000000000600000000`3oool000000000000700000003
0?ooo`000000000000T0000000<0oooo0000000000004`0000000`3oool000000000000H00000003
0?ooo`000000000000L0000000<0oooo0000000000002@0000000`3oool000000000000C00000003
0?ooo`000000000001P0000000<0oooo0000000000001`0000000`3oool000000000000900000003
0?ooo`000000000001<0000000<0oooo000000000000600000000`3oool000000000000200000000
00<000000?ooo`000000o`00000N0000000000<000000?ooo`000000o`00000N0000000000<00000
0?ooo`000000o`00000N0000000000<000000?ooo`000000o`00000L00000040oooo0@0000000003
0000003oool0oooo0?l0oooo7@3oool10000000000<000000?ooo`3oool0o`3ooolL0?ooo`800000
00000`000000oooo0?ooo`3o0?oooa/0oooo0@0000010?ooo`40000000000`000000oooo0?ooo`3o
0?oooad0oooo0@0000000?l000008@00000000030000003oool0oooo0?l000007P00000000030000
003oool000000?l000007P00000000030000003oool0oooo00@0000000<0oooo0000003oool00P00
00000`3oool0000000000002000000040?ooo`000000000000000080oooo100000001@3oool00000
0?ooo`000000oooo0080000000<0oooo0000000000000P0000000`3oool000000000000200000008
0?ooo`00000000000?ooo`000000oooo0000003oool500000080oooo0P0000000`3oool000000000
0002000000080?ooo`00000000000?ooo`000000oooo0000003oool4000000030?ooo`000000oooo
0080000000<0oooo0000000000000P000000103oool000000000000000020?ooo`@0000000D0oooo
0000003oool000000?ooo`02000000030?ooo`00000000000080000000<0oooo0000000000000P00
0000203oool000000000003oool000000?ooo`000000oooo1@0000020?ooo`80000000<0oooo0000
000000000P000000203oool000000000003oool000000?ooo`000000oooo100000000`3oool00000
0?ooo`02000000030?ooo`00000000000080000000@0oooo00000000000000000P3oool400000005
0?ooo`000000oooo0000003oool00P0000000`3oool0000000000002000000030?ooo`0000000000
0080000000P0oooo000000000000oooo0000003oool000000?ooo`D000000P3oool2000000030?oo
o`00000000000080000000P0oooo000000000000oooo0000003oool000000?ooo`@0000000<0oooo
0000003oool00P0000000`3oool0000000000002000000040?ooo`000000000000000080oooo1000
00001@3oool000000?ooo`000000oooo0080000000<0oooo0000000000000P0000000`3oool00000
00000002000000080?ooo`00000000000?ooo`000000oooo0000003oool500000080oooo0P000000
0`3oool0000000000002000000080?ooo`00000000000?ooo`000000oooo0000003oool100000000
00<000000?ooo`3oool00P0000000`3oool000000?ooo`0200000080oooo0P000000103oool00000
0000000000020?ooo`070000003oool000000000003oool000000?ooo`02000000040?ooo`000000
00000?ooo`<0000000@0oooo00000000000000000P3oool01`000000oooo000000000000oooo0000
003oool00P0000001P3oool000000000003oool000000?ooo`80000000L0oooo0000000000000000
0?ooo`000000oooo0080000000<0oooo0000003oool00P0000001P3oool000000000003oool00000
0?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo00L000000?ooo`0000000000
0?ooo`000000oooo0080000000@0oooo000000000000oooo0`000000103oool00000000000000002
0?ooo`070000003oool000000000003oool000000?ooo`02000000060?ooo`00000000000?ooo`00
0000oooo0P0000001`3oool00000000000000000oooo0000003oool00P0000000`3oool000000?oo
o`02000000060?ooo`00000000000?ooo`000000oooo0P0000020?ooo`80000000@0oooo00000000
000000000P3oool01`000000oooo000000000000oooo0000003oool00P000000103oool000000000
003oool3000000040?ooo`000000000000000080oooo00L000000?ooo`00000000000?ooo`000000
oooo0080000000H0oooo000000000000oooo0000003oool2000000070?ooo`00000000000000003o
ool000000?ooo`02000000030?ooo`000000oooo0080000000H0oooo000000000000oooo0000003o
ool200000080oooo0P000000103oool000000000000000020?ooo`070000003oool000000000003o
ool000000?ooo`02000000040?ooo`00000000000?ooo`<0000000@0oooo00000000000000000P3o
ool01`000000oooo000000000000oooo0000003oool00P0000001P3oool000000000003oool00000
0?ooo`80000000L0oooo00000000000000000?ooo`000000oooo0080000000<0oooo0000003oool0
0P0000010?ooo`40000000001@000000oooo000000000000oooo00@000000P3oool2000000060?oo
o`00000000000?ooo`000000oooo100000000`3oool0000000000005000000050?ooo`0000000000
0000003oool00`0000020?ooo`@000000P3oool6000000030?ooo`00000000000080000000D0oooo
00000000000000000?ooo`04000000030?ooo`000000000000D0000000<0oooo0000000000000P00
00020?ooo`80000000H0oooo000000000000oooo0000003oool4000000030?ooo`000000000000D0
000000D0oooo00000000000000000?ooo`0300000080oooo100000020?ooo`H0000000<0oooo0000
000000000P0000001@3oool00000000000000000oooo00@0000000<0oooo0000000000001@000000
0`3oool000000000000200000080oooo0P0000001P3oool000000000003oool000000?ooo`@00000
00<0oooo0000000000001@0000001@3oool00000000000000000oooo00<000000P3oool400000080
oooo1P0000000`3oool0000000000002000000050?ooo`00000000000000003oool0100000000`3o
ool0000000000005000000030?ooo`0000000000008000000P3oool2000000060?ooo`0000000000
0?ooo`000000oooo100000000`3oool0000000000005000000050?ooo`00000000000000003oool0
0`0000020?ooo`@000000P3oool6000000030?ooo`00000000000080000000D0oooo000000000000
00000?ooo`04000000030?ooo`000000000000<000000@3oool10000000000<000000?ooo`000000
0P3oool010000000oooo0000003oool200000080oooo0P000000203oool000000?ooo`3oool00000
0?ooo`000000oooo0P0000020?ooo`040000003oool000000?ooo`8000000P3oool00`000000oooo
000000030?ooo`040000003oool000000?ooo`8000000P3oool00`000000oooo000000020?ooo`04
0000003oool000000?ooo`8000000P3oool2000000030?ooo`000000oooo008000000P3oool00`00
0000oooo000000020?ooo`040000003oool000000?ooo`8000000P3oool2000000080?ooo`000000
oooo0?ooo`000000oooo0000003oool200000080oooo00@000000?ooo`000000oooo0P0000020?oo
o`030000003oool0000000<0oooo00@000000?ooo`000000oooo0P0000020?ooo`030000003oool0
00000080oooo00@000000?ooo`000000oooo0P0000020?ooo`80000000<0oooo0000003oool00P00
00020?ooo`030000003oool000000080oooo00@000000?ooo`000000oooo0P0000020?ooo`800000
00P0oooo0000003oool0oooo0000003oool000000?ooo`8000000P3oool010000000oooo0000003o
ool200000080oooo00<000000?ooo`0000000`3oool010000000oooo0000003oool200000080oooo
00<000000?ooo`0000000P3oool010000000oooo0000003oool200000080oooo0P0000000`3oool0
00000?ooo`0200000080oooo00<000000?ooo`0000000P3oool010000000oooo0000003oool20000
0080oooo0P000000203oool000000?ooo`3oool000000?ooo`000000oooo0P0000020?ooo`040000
003oool000000?ooo`8000000P3oool00`000000oooo000000030?ooo`040000003oool000000?oo
o`8000000P3oool00`000000oooo000000020?ooo`040000003oool000000?ooo`8000000P3oool2
000000030?ooo`000000oooo008000000P3oool00`000000oooo0?ooo`010000000000@000000?oo
o`3oool0oooo0P0000001P3oool000000000003oool000000?ooo`80000000D0oooo0000003oool0
oooo000000020?ooo`80000000@0oooo0000003oool000000`3oool010000000oooo0000003oool2
000000050?ooo`000000oooo0?ooo`0000000P3oool2000000040?ooo`000000oooo00000080oooo
00D000000?ooo`00000000000?ooo`02000000030?ooo`000000oooo008000000`3oool01@000000
oooo0000003oool000000080oooo00D000000?ooo`00000000000?ooo`02000000030?ooo`000000
oooo0080000000D0oooo0000003oool0oooo000000020?ooo`80000000@0oooo0000003oool00000
0`3oool010000000oooo0000003oool2000000050?ooo`000000oooo0?ooo`0000000P3oool20000
00040?ooo`000000oooo00000080oooo00D000000?ooo`00000000000?ooo`02000000030?ooo`00
0000oooo008000000`3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`000000
00000?ooo`02000000030?ooo`000000oooo0080000000D0oooo0000003oool0oooo000000020?oo
o`80000000@0oooo0000003oool000000`3oool010000000oooo0000003oool2000000050?ooo`00
0000oooo0?ooo`0000000P3oool2000000040?ooo`000000oooo00000080oooo00D000000?ooo`00
000000000?ooo`02000000030?ooo`000000oooo008000000`3oool01@000000oooo0000003oool0
00000080oooo00D000000?ooo`00000000000?ooo`02000000030?ooo`000000oooo0080000000D0
oooo0000003oool0oooo000000020?ooo`80000000@0oooo0000003oool000000`3oool010000000
oooo0000003oool2000000050?ooo`000000oooo0?ooo`0000000P3oool2000000040?ooo`000000
oooo00000080oooo00D000000?ooo`00000000000?ooo`02000000030?ooo`000000oooo00800000
0`3oool01@000000oooo0000003oool000000080oooo0P00000000030000003oool0oooo00800000
00H0oooo000000000000oooo0000003oool2000000030?ooo`000000oooo008000000P3oool00`00
0000oooo0?ooo`03000000<0oooo00<000000?ooo`0000000P3oool010000000oooo0000003oool2
00000080oooo00<000000?ooo`3oool0100000000`3oool0000000000002000000060?ooo`000000
00000?ooo`000000oooo0P0000020?ooo`80000000@0oooo0000003oool000000P3oool400000006
0?ooo`00000000000?ooo`000000oooo0P0000000`3oool000000?ooo`0200000080oooo00<00000
0?ooo`3oool00`0000030?ooo`030000003oool000000080oooo00@000000?ooo`000000oooo0P00
00020?ooo`030000003oool0oooo00@0000000<0oooo0000000000000P0000001P3oool000000000
003oool000000?ooo`8000000P3oool2000000040?ooo`000000oooo00000080oooo100000001P3o
ool000000000003oool000000?ooo`80000000<0oooo0000003oool00P0000020?ooo`030000003o
ool0oooo00<000000`3oool00`000000oooo000000020?ooo`040000003oool000000?ooo`800000
0P3oool00`000000oooo0?ooo`04000000030?ooo`00000000000080000000H0oooo000000000000
oooo0000003oool200000080oooo0P000000103oool000000?ooo`0000020?ooo`@0000000H0oooo
000000000000oooo0000003oool2000000030?ooo`000000oooo008000000P3oool00`000000oooo
0?ooo`03000000<0oooo00<000000?ooo`0000000P3oool010000000oooo0000003oool200000080
oooo00<000000?ooo`3oool0100000000`3oool0000000000002000000060?ooo`00000000000?oo
o`000000oooo0P0000020?ooo`80000000@0oooo0000003oool000000P3oool30000000000@00000
0?ooo`3oool0oooo0`0000030?ooo`8000000`3oool01@000000oooo0000003oool0000000<0oooo
00H000000?ooo`3oool000000?ooo`0000040?ooo`090000003oool0oooo0?ooo`000000oooo0000
003oool0000000<0oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo0000
00<0oooo00@000000?ooo`000000oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool3000000<0oooo0P0000030?ooo`050000003oool000000?ooo`0000000`3oool01P000000oooo
0?ooo`000000oooo000000@0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000
0`3oool00`000000oooo000000020?ooo`060000003oool0oooo0000003oool000000`3oool01000
0000oooo0000003oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`<000000`3o
ool2000000<0oooo00D000000?ooo`000000oooo000000030?ooo`060000003oool0oooo0000003o
ool00000103oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000030?ooo`030000
003oool000000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool00000
0?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo0`0000030?ooo`8000000`3o
ool01@000000oooo0000003oool0000000<0oooo00H000000?ooo`3oool000000?ooo`0000040?oo
o`090000003oool0oooo0?ooo`000000oooo0000003oool0000000<0oooo00<000000?ooo`000000
0P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`000000oooo0P000003
0?ooo`060000003oool0oooo0?ooo`000000oooo0@00000000030000003oool0oooo00800000103o
ool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool01P000000oooo
0?ooo`000000oooo000000<0oooo0P0000030?ooo`050000003oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`060000003oool0oooo0000003oool000000`3oool00`000000oooo
000000020?ooo`030000003oool0oooo008000000`3oool00`000000oooo0?ooo`02000000@0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo00H000000?ooo`3o
ool000000?ooo`0000030?ooo`8000000`3oool01@000000oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`02000000<0oooo00<000000?ooo`3oool00P0000040?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`060000003oool0oooo
0000003oool000000`3oool2000000<0oooo00D000000?ooo`000000oooo000000030?ooo`030000
003oool0oooo0080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`030000003oool00000
0080oooo00<000000?ooo`3oool00P0000030?ooo`030000003oool0oooo00800000103oool00`00
0000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool01P000000oooo0?ooo`00
0000oooo000000<0oooo0P0000030?ooo`050000003oool000000?ooo`0000000`3oool00`000000
oooo0?ooo`020?ooo`060000003oool0oooo0000003oool000000`3oool00`000000oooo00000002
0?ooo`030000003oool0oooo008000000`3oool00`000000oooo0?ooo`010000000000T000000?oo
o`3oool0oooo0000003oool000000?ooo`0000000P3oool3000000<0oooo00D000000?ooo`000000
oooo000000030?ooo`80000000<0oooo0000003oool00P000000103oool000000?ooo`0000030?oo
o`050000003oool000000?ooo`0000000P3oool3000000@0oooo00D000000?ooo`000000oooo0000
00030?ooo`<0000000L0oooo000000000000oooo0000003oool0000000@0oooo00D000000?ooo`00
0000oooo000000020?ooo`<000000`3oool01@000000oooo0000003oool0000000<0oooo0P000000
0`3oool000000?ooo`02000000040?ooo`000000oooo000000<0oooo00D000000?ooo`000000oooo
000000020?ooo`<00000103oool01@000000oooo0000003oool0000000<0oooo0`0000001`3oool0
00000000003oool000000?ooo`000000103oool01@000000oooo0000003oool000000080oooo0`00
00030?ooo`050000003oool000000?ooo`0000000`3oool2000000030?ooo`000000oooo00800000
00@0oooo0000003oool000000`3oool01@000000oooo0000003oool000000080oooo0`0000040?oo
o`050000003oool000000?ooo`0000000`3oool3000000070?ooo`00000000000?ooo`000000oooo
000000040?ooo`050000003oool000000?ooo`0000000P3oool3000000<0oooo00D000000?ooo`00
0000oooo000000030?ooo`80000000<0oooo0000003oool00P000000103oool000000?ooo`000003
0?ooo`050000003oool000000?ooo`0000000P3oool3000000@0oooo00D000000?ooo`000000oooo
000000030?ooo`<0000000L0oooo000000000000oooo0000003oool0000000<0oooo0@0000000008
0000003oool0oooo0000003oool000000?ooo`0000020?ooo`800000103oool01@000000oooo0000
003oool0000000<0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool00000
00<0oooo00D000000?ooo`000000oooo000000020?ooo`800000103oool2000000040?ooo`000000
oooo000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo
0P000000103oool000000?ooo`0000020?ooo`800000103oool01@000000oooo0000003oool00000
00<0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool0000000<0oooo00D0
00000?ooo`000000oooo000000020?ooo`800000103oool2000000040?ooo`000000oooo000000<0
oooo00<000000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo0P000000103o
ool000000?ooo`0000020?ooo`800000103oool01@000000oooo0000003oool0000000<0oooo00@0
00000?ooo`3oool000000P3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`00
0000oooo000000020?ooo`800000103oool2000000040?ooo`000000oooo000000<0oooo00<00000
0?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo0P000000103oool000000?oo
o`0000020?ooo`800000103oool01@000000oooo0000003oool0000000<0oooo00@000000?ooo`3o
ool000000P3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`000000oooo0000
00020?ooo`800000103oool2000000040?ooo`000000oooo000000<0oooo00<000000?ooo`000000
0P3oool01@000000oooo0000003oool0000000<0oooo0P00000000030000003oool0oooo00<0oooo
00<000000?ooo`0000001P3oool020000000oooo0?ooo`3oool000000?ooo`000000oooo0P000004
0?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000<0oooo00<000000?ooo`00
00001P3oool2000000<0oooo00D000000?ooo`000000oooo000000040?ooo`8000000P3oool01000
0000oooo0000003oool2000000<0oooo00<000000?ooo`0000001P3oool020000000oooo0?ooo`3o
ool000000?ooo`000000oooo0P0000040?ooo`090000003oool0oooo0?ooo`000000oooo0000003o
ool0000000<0oooo00<000000?ooo`0000001P3oool2000000<0oooo00D000000?ooo`000000oooo
000000040?ooo`8000000P3oool010000000oooo0000003oool2000000<0oooo00<000000?ooo`00
00001P3oool020000000oooo0?ooo`3oool000000?ooo`000000oooo0P0000040?ooo`090000003o
ool0oooo0?ooo`000000oooo0000003oool0000000<0oooo00<000000?ooo`0000001P3oool20000
00<0oooo00D000000?ooo`000000oooo000000040?ooo`8000000P3oool010000000oooo0000003o
ool2000000<0oooo00<000000?ooo`0000001P3oool020000000oooo0?ooo`3oool000000?ooo`00
0000oooo0P0000040?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000<0oooo
00<000000?ooo`0000001P3oool2000000<0oooo00D000000?ooo`000000oooo000000040?ooo`80
00000P3oool010000000oooo0000003oool30000000000@000000?ooo`3oool0oooo0P0000001@3o
ool000000?ooo`3oool000000080oooo0P0000030?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00`0000020?ooo`80000000@0oooo0000003oool000000`3oool00`000000oooo0000
00020?ooo`060000003oool0oooo0000003oool000000P3oool2000000040?ooo`000000oooo0000
00<0oooo0`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P0000001@3o
ool000000?ooo`3oool000000080oooo0P0000030?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00`0000020?ooo`80000000@0oooo0000003oool000000`3oool00`000000oooo0000
00020?ooo`060000003oool0oooo0000003oool000000P3oool2000000040?ooo`000000oooo0000
00<0oooo0`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P0000001@3o
ool000000?ooo`3oool000000080oooo0P0000030?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00`0000020?ooo`80000000@0oooo0000003oool000000`3oool00`000000oooo0000
00020?ooo`060000003oool0oooo0000003oool000000P3oool2000000040?ooo`000000oooo0000
00<0oooo0`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P0000001@3o
ool000000?ooo`3oool000000080oooo0P0000030?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00`0000020?ooo`80000000@0oooo0000003oool000000`3oool00`000000oooo0000
00020?ooo`060000003oool0oooo0000003oool000000P3oool2000000040?ooo`000000oooo0000
00<0oooo0`0000020?ooo`030000003oool000000080oooo0@0000010?ooo`40000000000`000000
oooo0?ooo`02000000@0oooo00<000000?ooo`3oool00P0000030?ooo`030000003oool0oooo00<0
oooo00@000000?ooo`00000000000`3oool2000000<0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`80000000@0oooo0000003oool000000P3oool2000000D0oooo00<000000?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?oo
o`02000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0000000000030?ooo`800000
0`3oool01@000000oooo0?ooo`3oool0000000@0oooo0P000000103oool000000?ooo`0000020?oo
o`8000001@3oool00`000000oooo000000040?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P0000040?ooo`030000003oool0oooo008000000`3oool00`000000oooo0?ooo`030?oo
o`040000003oool00000000000<0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000103o
ool2000000040?ooo`000000oooo00000080oooo0P0000050?ooo`030000003oool0000000@0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`3oool0
0P0000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`00000000000`3oool2000000<0
oooo00D000000?ooo`3oool0oooo000000040?ooo`80000000@0oooo0000003oool000000P3oool2
000000D0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0040000000000`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool00P0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0000000<0oooo00D000000?ooo`000000oooo0000
00040?ooo`8000001@3oool2000000@0oooo00<000000?ooo`000000103oool00`000000oooo0000
00030?ooo`030000003oool0oooo008000001@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool00000103oool00`000000oooo000000030?ooo`050000
003oool000000?ooo`000000103oool2000000D0oooo0P0000040?ooo`030000003oool0000000@0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`02000000D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`0000000`3oool01@000000oooo0000003oool0000000@0oooo0P0000050?ooo`800000103oool0
0`000000oooo000000040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P000005
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0000000<0oooo00D000000?ooo`000000oooo000000040?ooo`800000
1@3oool2000000@0oooo00@000000?ooo`000000oooo0@00000000080000003oool0oooo0000003o
ool000000?ooo`0000030?ooo`030000003oool0oooo00800000103oool2000000<0oooo00D00000
0?ooo`000000oooo000000030?ooo`060000003oool0oooo0000003oool000000P3oool00`000000
oooo000000030?ooo`050000003oool000000?ooo`0000000`3oool2000000<0oooo00<000000?oo
o`3oool00P0000040?ooo`030000003oool000000080oooo00D000000?ooo`000000oooo00000003
0?ooo`030000003oool0oooo00800000103oool2000000<0oooo00D000000?ooo`000000oooo0000
00030?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`05
0000003oool000000?ooo`0000000`3oool2000000<0oooo00<000000?ooo`3oool00P0000040?oo
o`030000003oool000000080oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0
oooo00800000103oool2000000<0oooo00D000000?ooo`000000oooo000000030?ooo`060000003o
ool0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`050000003oool000000?oo
o`0000000`3oool2000000<0oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool00000
0080oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00800000103oool2
000000<0oooo00D000000?ooo`000000oooo000000030?ooo`060000003oool0oooo0000003oool0
00000P3oool00`000000oooo000000030?ooo`050000003oool000000?ooo`0000000`3oool20000
00<0oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool000000080oooo0@0000000004
0000003oool0000000000080oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool0
oooo0000003oool00P0000030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool00000
00@0oooo00<000000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo00@00000
0?ooo`000000oooo0P0000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo
000000040?ooo`8000000P3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`3o
ool000000?ooo`02000000<0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000
103oool00`000000oooo000000020?ooo`050000003oool000000?ooo`0000000`3oool010000000
oooo0000003oool2000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0
000000@0oooo0P0000020?ooo`050000003oool000000?ooo`0000000`3oool01@000000oooo0?oo
o`000000oooo008000000`3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo00000004
0?ooo`030000003oool000000080oooo00D000000?ooo`000000oooo000000030?ooo`040000003o
ool000000?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`00
0000103oool200000080oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool0oooo
0000003oool00P0000030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0
oooo00<000000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo00@000000?oo
o`000000oooo0P0000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo0000
00050?ooo`40000000000`000000oooo000000020?ooo`030000003oool0000000D0oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`02000000<0oooo00<000000?ooo`0000001@3o
ool2000000070?ooo`000000oooo0?ooo`000000oooo000000050?ooo`030000003oool000000080
oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0000000D0oooo0`0000020?ooo`03
0000003oool0000000D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020000
00<0oooo00<000000?ooo`0000001@3oool2000000070?ooo`000000oooo0?ooo`000000oooo0000
00050?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P0000040?ooo`030000003o
ool0000000D0oooo0`0000020?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`02000000<0oooo00<000000?ooo`0000001@3oool2000000070?oo
o`000000oooo0?ooo`000000oooo000000050?ooo`030000003oool000000080oooo00<000000?oo
o`3oool00P0000040?ooo`030000003oool0000000D0oooo0`0000020?ooo`030000003oool00000
00D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`02000000<0oooo00<00000
0?ooo`0000001@3oool2000000070?ooo`000000oooo0?ooo`000000oooo000000050?ooo`030000
003oool000000080oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0000000D0oooo
0P0000010?ooo`400000000010000000oooo0?ooo`3oool2000000<0oooo00D000000?ooo`3oool0
oooo000000040?ooo`80000000<0oooo000000000000103oool01@000000oooo0?ooo`3oool00000
0080oooo0P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`80000000<0oooo000000000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo008000000`3oool2000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`80000000<0
oooo000000000000103oool01@000000oooo0?ooo`3oool000000080oooo0P0000040?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`80000000<0oooo00000000
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000000`3oool2000000<0
oooo00D000000?ooo`3oool0oooo000000040?ooo`80000000<0oooo000000000000103oool01@00
0000oooo0?ooo`3oool000000080oooo0P0000040?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`80000000<0oooo000000000000103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo008000000`3oool2000000<0oooo00D000000?ooo`3oool0oooo
000000040?ooo`80000000<0oooo000000000000103oool01@000000oooo0?ooo`3oool000000080
oooo0P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?oo
o`80000000<0oooo000000000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
008000000P3oool10000000000<000000?ooo`3oool00P0000030?ooo`040000003oool000000?oo
o`8000000`3oool200000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`050000003o
ool000000?ooo`0000000P3oool00`000000oooo000000040?ooo`050000003oool000000?ooo`00
00000`3oool200000080oooo00D000000?ooo`3oool000000?ooo`02000000<0oooo00D000000?oo
o`000000oooo000000020?ooo`<000000`3oool010000000oooo0000003oool2000000<0oooo0P00
00020?ooo`060000003oool0oooo0000003oool000000`3oool01@000000oooo0000003oool00000
0080oooo00<000000?ooo`000000103oool01@000000oooo0000003oool0000000<0oooo0P000002
0?ooo`050000003oool0oooo0000003oool00P0000030?ooo`050000003oool000000?ooo`000000
0P3oool3000000<0oooo00@000000?ooo`000000oooo0P0000030?ooo`8000000P3oool01P000000
oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`000000oooo000000020?ooo`030000003o
ool0000000@0oooo00D000000?ooo`000000oooo000000030?ooo`8000000P3oool01@000000oooo
0?ooo`000000oooo008000000`3oool01@000000oooo0000003oool000000080oooo0`0000030?oo
o`040000003oool000000?ooo`8000000`3oool200000080oooo00H000000?ooo`3oool000000?oo
o`0000030?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo000000040?ooo`05
0000003oool000000?ooo`0000000`3oool200000080oooo00D000000?ooo`3oool000000?ooo`02
000000<0oooo00D000000?ooo`000000oooo000000020?ooo`80000000000`000000oooo0?ooo`04
0?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool01P000000oooo0?oo
o`000000oooo000000<0oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool010000000oooo0?ooo`0000020?ooo`80000000@0oooo0000003oool000000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool01P00
0000oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`000000oooo000000020?ooo`030000
003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`0000020?ooo`80000000@0oooo0000003oool000000P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000
103oool01P000000oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`000000oooo00000002
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`80000000@0oooo0000003o
ool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool000000080oooo00@000000?oo
o`3oool00000103oool01P000000oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`000000
oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`80000000@0
oooo0000003oool000000P3oool100000040oooo0@00000000030000003oool0oooo00<0oooo0P00
00060?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0
oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0oooo00@000000?oo
o`3oool000000`3oool2000000H0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool01@3oool2000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`80
00001@3oool010000000oooo0?ooo`0000030?ooo`8000001P3oool00`000000oooo000000030?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`800000103oool01@000000oooo0?oo
o`3oool000000080oooo0P0000050?ooo`040000003oool0oooo000000<0oooo0P0000060?ooo`03
0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0oooo0P000004
0?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0oooo00<000000?ooo`3oool00P00
000000040000003oool0oooo0?ooo`<00000103oool200000080oooo00D000000?ooo`000000oooo
000000030?ooo`040000003oool0oooo000000H0oooo00T000000?ooo`3oool0oooo0000003oool0
00000?ooo`000000103oool01@000000oooo0000003oool000000080oooo00<000000?ooo`000000
0`3oool00`000000oooo000000060?ooo`8000000P3oool00`000000oooo0?ooo`03000000@0oooo
0P0000020?ooo`050000003oool000000?ooo`0000000`3oool010000000oooo0?ooo`0000060?oo
o`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0oooo00D000000?ooo`000000
oooo000000020?ooo`030000003oool0000000<0oooo00<000000?ooo`0000001P3oool200000080
oooo00<000000?ooo`3oool00`0000040?ooo`8000000P3oool01@000000oooo0000003oool00000
00<0oooo00@000000?ooo`3oool000001P3oool02@000000oooo0?ooo`3oool000000?ooo`000000
oooo000000040?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo000000030?oo
o`030000003oool0000000H0oooo0P0000020?ooo`030000003oool0oooo00<00000103oool20000
0080oooo00D000000?ooo`000000oooo000000030?ooo`040000003oool0oooo000000H0oooo00T0
00000?ooo`3oool0oooo0000003oool000000?ooo`000000103oool01@000000oooo0000003oool0
00000080oooo00<000000?ooo`0000000`3oool00`000000oooo000000060?ooo`8000000P3oool1
00000040oooo0@00000000030000003oool0oooo008000001@3oool2000000@0oooo00<000000?oo
o`0000001P3oool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo000000040?oo
o`030000003oool0000000@0oooo00<000000?ooo`0000001@3oool010000000oooo0?ooo`000002
0?ooo`8000001P3oool2000000D0oooo0P0000040?ooo`030000003oool0000000H0oooo00<00000
0?ooo`0000000`3oool2000000D0oooo00<000000?ooo`000000103oool00`000000oooo00000004
0?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool000000P3oool2000000H0oooo0P00
00050?ooo`800000103oool00`000000oooo000000060?ooo`030000003oool0000000<0oooo0P00
00050?ooo`030000003oool0000000@0oooo00<000000?ooo`000000103oool00`000000oooo0000
00050?ooo`040000003oool0oooo00000080oooo0P0000060?ooo`8000001@3oool2000000@0oooo
00<000000?ooo`0000001P3oool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo
000000040?ooo`030000003oool0000000@0oooo00<000000?ooo`0000001@3oool010000000oooo
0?ooo`0000020?ooo`8000001P3oool10000000000<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`80
00001`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0080oooo0P0000070?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool2000000L0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`8000001`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`010000000000T000000?ooo`3oool0oooo0000003o
ool000000?ooo`000000103oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo00000006
0?ooo`040000003oool0oooo000000<0oooo00T000000?ooo`3oool0oooo0000003oool000000?oo
o`000000103oool2000000<0oooo00D000000?ooo`000000oooo000000050?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000@0oooo
00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000001P3oool010000000oooo0?ooo`00
00030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0oooo0P0000030?oo
o`050000003oool000000?ooo`0000001@3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`000000oooo000000040?ooo`090000003oool0oooo0?ooo`00
0000oooo0000003oool0000000H0oooo00@000000?ooo`3oool000000`3oool02@000000oooo0?oo
o`3oool000000?ooo`000000oooo000000040?ooo`8000000`3oool01@000000oooo0000003oool0
000000D0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool000000?ooo`000000103oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo00000006
0?ooo`040000003oool0oooo000000<0oooo00T000000?ooo`3oool0oooo0000003oool000000?oo
o`000000103oool2000000<0oooo00D000000?ooo`000000oooo000000050?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool0oooo0@00000000060000003oool0oooo0000003oool0
00001@3oool2000000<0oooo00<000000?ooo`0000001P3oool00`000000oooo000000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`0000001@3oool2000000@0oooo00<000000?oo
o`0000001P3oool200000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo00000005
0?ooo`8000000`3oool00`000000oooo000000060?ooo`030000003oool000000080oooo00@00000
0?ooo`3oool00000103oool00`000000oooo000000050?ooo`800000103oool00`000000oooo0000
00060?ooo`8000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0000000D0oooo
0P0000030?ooo`030000003oool0000000H0oooo00<000000?ooo`0000000P3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0000000D0oooo0P0000040?ooo`030000003oool0000000H0
oooo0P0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`0000001@3oool20000
00<0oooo00<000000?ooo`0000001P3oool00`000000oooo000000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`0000001@3oool2000000@0oooo00<000000?ooo`0000001P3oool2
00000080oooo00@000000?ooo`3oool000001@3oool10000000000<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`02000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo
0P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000040?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000`3oool01@000000oooo
0?ooo`3oool000000080oooo0P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000060?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`02000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo0P00
00040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000
003oool0000000<0oooo0P00000000030000003oool0oooo00<0oooo00<000000?ooo`0000001P3o
ool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`8000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001P3oool2000000<0oooo00D00000
0?ooo`000000oooo000000040?ooo`8000000P3oool010000000oooo0?ooo`3oool2000000<0oooo
00<000000?ooo`0000001P3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo00000005
0?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001P3o
ool2000000<0oooo00D000000?ooo`000000oooo000000040?ooo`8000000P3oool010000000oooo
0?ooo`3oool2000000<0oooo00<000000?ooo`0000001P3oool02@000000oooo0?ooo`3oool00000
0?ooo`000000oooo000000050?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`0000001P3oool2000000<0oooo00D000000?ooo`000000oooo000000040?ooo`80
00000P3oool010000000oooo0?ooo`3oool2000000<0oooo00<000000?ooo`0000001P3oool02@00
0000oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`8000000P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`0000001P3oool2000000<0oooo00D000000?ooo`00
0000oooo000000040?ooo`8000000P3oool010000000oooo0?ooo`3oool30000000000<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool01@000000oooo0?ooo`3o
ool0000000<0oooo0P0000050?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0000000D0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?ooo`00
00001@3oool010000000oooo0?ooo`0000020?ooo`8000001@3oool01@000000oooo0?ooo`3oool0
000000<0oooo0P0000050?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0000000D0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?ooo`000000
1@3oool010000000oooo0?ooo`0000020?ooo`8000001@3oool01@000000oooo0?ooo`3oool00000
00<0oooo0P0000050?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
000000D0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?ooo`0000001@3o
ool010000000oooo0?ooo`0000020?ooo`8000001@3oool01@000000oooo0?ooo`3oool0000000<0
oooo0P0000050?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool00000
00D0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00@000000?ooo`000000oooo0@00
000000040000003oool0oooo0?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000050?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`0000001@3oool2000000<0oooo00@00000
0?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo
00<000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00`3oool2000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool00000
00D0oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo000000050?ooo`8000000`3oool010000000oooo0?ooo`0000050?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000001@3oool00`000000oooo00000005
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`000000103oool10000000000<0
00000?ooo`3oool00P0000050?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001@3oool0
10000000oooo0000000000030?ooo`8000000`3oool00`000000oooo0?ooo`02000000D0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool000000080oooo0P0000050?ooo`040000003oool00000000000<0oooo0P00
00030?ooo`030000003oool0oooo008000001@3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool2
000000D0oooo00@000000?ooo`00000000000`3oool2000000<0oooo00<000000?ooo`3oool00P00
00050?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001@3oool010000000oooo00000000
00030?ooo`8000000`3oool00`000000oooo0?ooo`010000000000<000000?ooo`3oool01@3oool2
00000080oooo00@000000?ooo`3oool000001P3oool02@000000oooo0?ooo`3oool000000?ooo`00
0000oooo000000030?ooo`040000003oool0oooo000000H0oooo00L000000?ooo`3oool0oooo0000
003oool0000000H0oooo0P0000020?ooo`030000003oool0oooo00<000000`3oool00`000000oooo
000000060?ooo`8000000P3oool010000000oooo0?ooo`0000060?ooo`090000003oool0oooo0?oo
o`000000oooo0000003oool0000000<0oooo00@000000?ooo`3oool000001P3oool01`000000oooo
0?ooo`3oool000000?ooo`0000001P3oool200000080oooo00<000000?ooo`3oool00`0000030?oo
o`030000003oool0000000H0oooo0P0000020?ooo`040000003oool0oooo000000H0oooo00T00000
0?ooo`3oool0oooo0000003oool000000?ooo`0000000`3oool010000000oooo0?ooo`0000060?oo
o`070000003oool0oooo0?ooo`000000oooo000000060?ooo`8000000P3oool00`000000oooo0?oo
o`03000000<0oooo00<000000?ooo`0000001P3oool200000080oooo00@000000?ooo`3oool00000
1P3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000030?ooo`040000003oool0
oooo000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000H0oooo0P0000020?ooo`03
0000003oool0oooo00<000000`3oool010000000oooo0000003oool10000000000@000000?ooo`3o
ool000000P3oool2000000H0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?oo
o`0000001P3oool00`000000oooo000000030?ooo`8000001@3oool010000000oooo0?ooo`000002
0?ooo`8000001P3oool2000000H0oooo00@000000?ooo`3oool000000P3oool2000000H0oooo00<0
00000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000001P3oool00`000000oooo0000
00030?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`8000001P3oool2000000H0oooo
00@000000?ooo`3oool000000P3oool2000000H0oooo00<000000?ooo`0000000`3oool2000000D0
oooo00<000000?ooo`0000001P3oool00`000000oooo000000030?ooo`8000001@3oool010000000
oooo0?ooo`0000020?ooo`8000001P3oool2000000H0oooo00@000000?ooo`3oool000000P3oool2
000000H0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000001P3oool0
0`000000oooo000000030?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`8000001P3o
ool2000000H0oooo00<000000?ooo`3oool00@00000000030000003oool000000080oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00P3oool10000000000@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00@000000?ooo`3oool000000`3oool02@000000oooo0?ooo`3oool000000?oo
o`000000oooo000000060?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000
oooo000000050?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool01000
0000oooo0?ooo`0000030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000H0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000D0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000<0
oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000001P3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`020?ooo`050000003oool000000?ooo`0000001@3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000`3oool02@000000oooo0?oo
o`3oool000000?ooo`000000oooo000000060?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00D0
00000?ooo`000000oooo000000050?ooo`40000000000`000000oooo000000020?ooo`040000003o
ool0oooo000000D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0000000P0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`80
00000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000L0oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool000000080oooo00<000000?oo
o`3oool01@3oool00`000000oooo000000080?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00`3oool200000080oooo00<000000?ooo`3oool01P3oool00`000000oooo00000007
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0000
00020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000203oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`0000001`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000P0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0000000P0oooo0@00000000030000003oool0oooo00@0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`8000002`3oool2000000H0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`800000303oool2000000D0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`8000002`3oool2000000H0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`800000303oool2000000D0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`8000002`3oool2000000H0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`800000303oool2000000D0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`8000002`3oool2000000H0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`800000303oool200000040
oooo0@00000000040000003oool0oooo0?ooo`8000000P3oool01@000000oooo0?ooo`3oool00000
00D0oooo0P0000000`3oool00000000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool2
000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo0P00
00000`3oool00000000000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P00
00030?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo0P0000000`3oool00000
000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000@0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo0080oooo0P0000000`3oool00000000000040?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000030?ooo`8000000P3oool01@00
0000oooo0?ooo`3oool0000000D0oooo0P0000000`3oool00000000000040?ooo`050000003oool0
oooo0?ooo`0000000P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo0080oooo0P0000000`3oool00000000000040?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P0000030?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000D0
oooo0P0000000`3oool00000000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool20000
00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo0P000000
0`3oool00000000000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P000002
0?ooo`40000000000`000000oooo0?ooo`02000000`0oooo0P0000070?ooo`070000003oool0oooo
0?ooo`000000oooo000000060?ooo`030000003oool0oooo00X0oooo0P0000070?ooo`8000000`3o
ool00`000000oooo000000050?ooo`800000303oool2000000L0oooo00L000000?ooo`3oool0oooo
0000003oool0000000H0oooo00<000000?ooo`3oool02P3oool2000000L0oooo0P0000030?ooo`03
0000003oool0000000D0oooo0P00000<0?ooo`8000001`3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000001P3oool00`000000oooo0?ooo`0:0?ooo`8000001`3oool2000000<0oooo00<00000
0?ooo`0000001@3oool2000000`0oooo0P0000070?ooo`070000003oool0oooo0?ooo`000000oooo
000000060?ooo`030000003oool0oooo00X0oooo0P0000070?ooo`8000000`3oool00`000000oooo
000000050?ooo`40000000000`000000oooo0?ooo`070?ooo`040000003oool0oooo000000L0oooo
00<000000?ooo`3oool00P0000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool01P3oool00`000000oooo000000070?ooo`060000003oool0oooo0000003oool000001@3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000
1`3oool00`000000oooo0?ooo`02000000D0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000L0oooo00H000000?ooo`3oool000000?ooo`000005
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool010000000oooo0?oo
o`0000070?ooo`030000003oool0oooo008000001@3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`0000001`3oool01P000000oooo0?ooo`000000oooo
000000D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`040000003o
ool0oooo000000L0oooo00<000000?ooo`3oool00P0000050?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool01P3oool00`000000oooo000000070?ooo`060000003oool0oooo0000
003oool000001@3oool010000000oooo0?ooo`0000020?ooo`80000000000`000000oooo0?ooo`04
0?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P0000030?ooo`040000003oool0
oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo
0P000000103oool000000?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`030?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool00P0000030?ooo`040000003oool0oooo000000D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo0P000000103oool00000
0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?oo
o`8000000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00P0000030?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo00<0oooo0P000000103oool000000?ooo`0000030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool01000
0000oooo0?ooo`0000050?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P000003
0?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo00<0oooo0P000000103oool000000?ooo`0000030?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool01@000000oooo0?ooo`000000
oooo0040000000000`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo0P0000040?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000P3oool2000000L0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool000000080oooo0P0000050?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool01@3oool2000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001`3oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`050?ooo`800000103oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000070?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001@3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo0P0000040?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000P3oool2000000L0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool00000
0080oooo0P0000050?ooo`030000003oool0oooo0080000000000`000000oooo0?ooo`080?ooo`80
00001P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`0000001P3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000001P3oool200000080oooo00<000000?ooo`3oool01`3oool2000000H0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000080?ooo`030000003oool0000000H0oooo00L000000?ooo`3oool0oooo0000003o
ool0000000H0oooo0P0000020?ooo`030000003oool0oooo00L0oooo0P0000060?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
0000203oool00`000000oooo000000060?ooo`070000003oool0oooo0?ooo`000000oooo00000006
0?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`8000001P3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000P0oooo
00<000000?ooo`0000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3oool20000
0080oooo0@0000010?ooo`400000000010000000oooo0?ooo`3oool2000000@0oooo0P0000050?oo
o`030000003oool0000000D0oooo00<000000?ooo`0000000`3oool2000000H0oooo00<000000?oo
o`0000000`3oool00`000000oooo000000050?ooo`8000001@3oool010000000oooo0?ooo`000002
0?ooo`8000001`3oool2000000@0oooo0P0000050?ooo`030000003oool0000000D0oooo00<00000
0?ooo`0000000`3oool2000000H0oooo00<000000?ooo`0000000`3oool00`000000oooo00000005
0?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`8000001`3oool2000000@0oooo0P00
00050?ooo`030000003oool0000000D0oooo00<000000?ooo`0000000`3oool2000000H0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000050?ooo`8000001@3oool010000000oooo0?oo
o`0000020?ooo`8000001`3oool2000000@0oooo0P0000050?ooo`030000003oool0000000D0oooo
00<000000?ooo`0000000`3oool2000000H0oooo00<000000?ooo`0000000`3oool00`000000oooo
000000050?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`8000001P3oool100000000
00<000000?ooo`3oool00P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000
oooo000000070?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo000000030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000080?ooo`040000003oool0oooo
000000P0oooo0P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo0000
00070?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo000000030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P0000080?ooo`040000003oool0oooo000000P0
oooo0P0000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo000000070?oo
o`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo000000030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P0000080?ooo`040000003oool0oooo000000P0oooo0P00
00040?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo000000070?ooo`050000
003oool0oooo0?ooo`0000001`3oool00`000000oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P0000080?ooo`040000003oool0oooo000000P0oooo0@0000000003
0000003oool0oooo00D0oooo0P0000030?ooo`8000001`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00@0oooo0P0000030?ooo`030000003oool0000000L0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`050?ooo`8000000`3oool2000000L0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`040?ooo`8000000`3oool00`000000oooo000000070?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool2000000<0oooo0P0000070?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool2000000<0oooo00<000000?ooo`00
00001`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`80
00001`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`03
0000003oool0000000L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0100000000
00@000000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`090000003oool0oooo0?oo
o`000000oooo0000003oool0000000H0oooo00@000000?ooo`3oool000000`3oool02@000000oooo
0?ooo`3oool000000?ooo`000000oooo000000050?ooo`090000003oool0oooo0?ooo`000000oooo
0000003oool0000000D0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`000000103oool02@000000oooo0?ooo`3oool000000?ooo`000000
oooo000000060?ooo`040000003oool0oooo000000<0oooo00T000000?ooo`3oool0oooo0000003o
ool000000?ooo`0000001@3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo00000005
0?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0000000@0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000001P3oool0
10000000oooo0?ooo`0000030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool00000
00D0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000001@3oool010000000oooo
0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000040?oo
o`090000003oool0oooo0?ooo`000000oooo0000003oool0000000H0oooo00@000000?ooo`3oool0
00000`3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`090000003o
ool0oooo0?ooo`000000oooo0000003oool0000000D0oooo00@000000?ooo`3oool000000`3oool0
10000000oooo0?ooo`3oool10000000000<000000?ooo`0000000P3oool00`000000oooo0?ooo`03
0?ooo`8000000`3oool00`000000oooo000000050?ooo`80000000D0oooo0000003oool0oooo0000
00020?ooo`8000000`3oool00`000000oooo000000050?ooo`800000103oool00`000000oooo0000
00050?ooo`<000000P3oool00`000000oooo0?ooo`02000000<0oooo00@000000?ooo`3oool00000
1@3oool2000000<0oooo00<000000?ooo`0000001@3oool2000000050?ooo`000000oooo0?ooo`00
00000P3oool2000000<0oooo00<000000?ooo`0000001@3oool2000000@0oooo00<000000?ooo`00
00001@3oool300000080oooo00<000000?ooo`3oool00P0000030?ooo`040000003oool0oooo0000
00D0oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000001@3oool000000?ooo`3oool0
00000080oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000040?ooo`030000003oool0
000000D0oooo0`0000020?ooo`030000003oool0oooo008000000`3oool010000000oooo0?ooo`00
00050?ooo`8000000`3oool00`000000oooo000000050?ooo`80000000D0oooo0000003oool0oooo
000000020?ooo`8000000`3oool00`000000oooo000000050?ooo`800000103oool00`000000oooo
000000050?ooo`<000000P3oool00`000000oooo0?ooo`02000000@0oooo0@00000000030000003o
ool0oooo00L0oooo0P0000080?ooo`030000003oool0oooo008000001`3oool2000000@0oooo00<0
00000?ooo`3oool0103oool2000000T0oooo00<000000?ooo`3oool00P0000060?ooo`800000103o
ool00`000000oooo0?ooo`050?ooo`800000203oool00`000000oooo0?ooo`02000000L0oooo0P00
00040?ooo`030000003oool0oooo00@0oooo0P0000090?ooo`030000003oool0oooo008000001P3o
ool2000000@0oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool00P00
00070?ooo`800000103oool00`000000oooo0?ooo`040?ooo`8000002@3oool00`000000oooo0?oo
o`02000000H0oooo0P0000040?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`030000003o
ool0oooo008000001`3oool2000000@0oooo00<000000?ooo`3oool0103oool2000000T0oooo00<0
00000?ooo`3oool00P0000060?ooo`800000103oool20000000000<000000?ooo`3oool0103oool2
000000H0oooo0P0000020?ooo`030000003oool0oooo00L0oooo0P0000060?ooo`030000003oool0
oooo0080oooo0P0000070?ooo`050000003oool0oooo0?ooo`000000203oool2000000H0oooo00<0
00000?ooo`3oool00`3oool2000000H0oooo0P0000020?ooo`030000003oool0oooo00L0oooo0P00
00060?ooo`030000003oool0oooo0080oooo0P0000070?ooo`050000003oool0oooo0?ooo`000000
203oool2000000H0oooo00<000000?ooo`3oool00`3oool2000000H0oooo0P0000020?ooo`030000
003oool0oooo00L0oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000070?ooo`050000
003oool0oooo0?ooo`000000203oool2000000H0oooo00<000000?ooo`3oool00`3oool2000000H0
oooo0P0000020?ooo`030000003oool0oooo00L0oooo0P0000060?ooo`030000003oool0oooo0080
oooo0P0000070?ooo`050000003oool0oooo0?ooo`000000203oool2000000H0oooo0@0000010?oo
o`40000000000`000000oooo0?ooo`030?ooo`8000001P3oool2000000D0oooo00<000000?ooo`00
0000103oool2000000D0oooo00<000000?ooo`0000000`3oool2000000L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo000000030?ooo`8000001@3oool010000000oooo0?ooo`0000030?oo
o`8000001P3oool2000000D0oooo00<000000?ooo`000000103oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo000000030?oo
o`8000001@3oool010000000oooo0?ooo`0000030?ooo`8000001P3oool2000000D0oooo00<00000
0?ooo`000000103oool2000000D0oooo00<000000?ooo`0000000`3oool2000000L0oooo00<00000
0?ooo`3oool0103oool00`000000oooo000000030?ooo`8000001@3oool010000000oooo0?ooo`00
00030?ooo`8000001P3oool2000000D0oooo00<000000?ooo`000000103oool2000000D0oooo00<0
00000?ooo`0000000`3oool2000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0000
00030?ooo`8000001@3oool00`000000oooo0?ooo`020000000000<000000?ooo`3oool01`3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0000003oool0000000P0oooo00@000000?ooo`3oool000001`3oool00`000000
oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`060?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`050000003oool000000?ooo`000000203oool010000000oooo0?ooo`00
00070?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000
00020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool000001P3oool00`000000oooo
000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000080?ooo`04
0000003oool0oooo000000L0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool000000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`000006
0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003o
ool0000000P0oooo00@000000?ooo`3oool000001`3oool00`000000oooo000000030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`0000000P3oool100000040oooo0@00000000040000003o
ool0oooo0?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00H0oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo0P0000060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01P3oool2000000<0oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
1P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool2000000H0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`8000000`3oool010000000
oooo0?ooo`0000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`03
0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo0@000000
00030000003oool0oooo008000001@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0
oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool000000080oooo0P000005
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001@3oool010000000oooo0?ooo`000004
0?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000050?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo
000000020?ooo`8000001@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0oooo00@0
00000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool000000080oooo0@00000000030000
003oool0oooo00H0oooo00@000000?ooo`3oool000002@3oool01@000000oooo0?ooo`3oool00000
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000080?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`070000003o
ool0oooo0?ooo`000000oooo000000070?ooo`040000003oool0oooo000000T0oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`040?ooo`050000003oool0oooo0?ooo`000000203oool200000080oooo00<000000?ooo`3oool0
0P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001`3oool010000000oooo0?ooo`000009
0?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000P0oooo0P0000020?ooo`03
0000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000L0oooo00@00000
0?ooo`3oool000002@3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000080?oo
o`8000000P3oool00`000000oooo0?ooo`020?ooo`080000003oool0oooo0?ooo`000000oooo0000
003oool10000000000<000000?ooo`3oool00`3oool00`000000oooo000000060?ooo`800000103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00`3o
ool2000000H0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`8000001@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0000000H0oooo0P0000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`030?ooo`8000001P3o
ool00`000000oooo000000030?ooo`030000003oool0oooo00D0oooo0P0000050?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`0000001P3oool2000000@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo000000050?ooo`030000003oool0oooo00<0oooo0P0000060?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool01@3oool2000000D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo000000060?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool00`3oool2000000H0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`050?ooo`8000001@3oool00`000000oooo0?ooo`010000000000P00000
0?ooo`3oool000000?ooo`000000oooo000000<0oooo00<000000?ooo`3oool00P0000040?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P0000040?ooo`050000003oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`02
0?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`02000000@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`02000000@0oooo00D000000?ooo`000000oooo000000030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0oooo0080
oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00800000103oool00`00
0000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00800000103oool01@000000oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P0000040?ooo`030000
003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P0000040?ooo`050000003oool000000?ooo`0000000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`020?oo
o`40000000000`000000oooo000000070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool00P3oool2000000H0oooo0P0000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000H0oooo0P0000030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`80
00001P3oool2000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`0000001P3oool2000000<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo0P0000060?ooo`80
00000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000060?ooo`8000000`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool2000000H0oooo0P0000030?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0000000H0oooo0P0000040?ooo`400000000010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00@000000?ooo`3oool000002@3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`00000:0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`040?ooo`040000003oool0oooo000000T0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000002P3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool010000000oooo0?ooo`0000090?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000X0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00@0
00000?ooo`3oool000002@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00`3oool10000000000<000000?ooo`0000000P3oool010000000oooo
0?ooo`0000050?ooo`030000003oool000000080oooo00@000000?ooo`3oool000001@3oool00`00
0000oooo000000050?ooo`030000003oool000000080oooo00@000000?ooo`3oool000001@3oool2
00000080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`0000050?ooo`800000
0P3oool010000000oooo0?ooo`0000050?ooo`030000003oool000000080oooo00@000000?ooo`3o
ool000001@3oool00`000000oooo000000050?ooo`030000003oool000000080oooo00@000000?oo
o`3oool000001@3oool200000080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?oo
o`0000050?ooo`8000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool000000080
oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000050?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool000001@3oool200000080oooo00@000000?ooo`3oool000001@3o
ool010000000oooo0?ooo`0000050?ooo`8000000P3oool010000000oooo0?ooo`0000050?ooo`03
0000003oool000000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000050?oo
o`030000003oool000000080oooo00@000000?ooo`3oool000001@3oool200000080oooo00@00000
0?ooo`3oool000001@3oool010000000oooo0?ooo`0000050?ooo`4000000@3oool10000000000<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo000000030?ooo`040000003oool0oooo0000
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`010000000000<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000000`3oool10000000000D000000?ooo`3oool0oooo000000030?ooo`05
0000003oool000000?ooo`000000103oool00`000000oooo000000060?ooo`070000003oool0oooo
0?ooo`000000oooo000000070?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool00000
00<0oooo00<000000?ooo`0000001P3oool2000000<0oooo00<000000?ooo`0000001P3oool02@00
0000oooo0?ooo`3oool000000?ooo`000000oooo000000040?ooo`030000003oool0000000H0oooo
00L000000?ooo`3oool0oooo0000003oool0000000L0oooo00T000000?ooo`3oool0oooo0000003o
ool000000?ooo`0000000`3oool00`000000oooo000000060?ooo`8000000`3oool00`000000oooo
000000060?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0oooo00<00000
0?ooo`0000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001`3oool02@000000oooo
0?ooo`3oool000000?ooo`000000oooo000000030?ooo`030000003oool0000000H0oooo0P000003
0?ooo`030000003oool0000000H0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`00
0000103oool00`000000oooo000000060?ooo`070000003oool0oooo0?ooo`000000oooo00000007
0?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000<0oooo00<000000?ooo`00
00001P3oool2000000<0oooo00<000000?ooo`0000001@3oool10000000000@000000?ooo`3oool0
00001@3oool00`000000oooo000000060?ooo`040000003oool0oooo00000080oooo0P0000050?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`000000oooo00000005
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool010000000oooo0?oo
o`0000020?ooo`8000001@3oool00`000000oooo000000060?ooo`040000003oool0oooo00000080
oooo0P0000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`00
0000oooo000000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool0
10000000oooo0?ooo`0000020?ooo`8000001@3oool00`000000oooo000000060?ooo`040000003o
ool0oooo00000080oooo0P0000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
00001@3oool00`000000oooo000000050?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000001@3oool010000000oooo0?ooo`0000020?ooo`8000001@3oool00`000000oooo00000006
0?ooo`040000003oool0oooo00000080oooo0P0000050?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`0000001@3oool00`000000oooo000000050?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`0000001@3oool010000000oooo0?ooo`0000020?ooo`80000000000`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`0000090?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0203oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000090?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool01@3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00
00050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000090?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool01@3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
00090?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool01@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`000000oooo
0040000000000`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo000000040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool00000
00L0oooo0P0000040?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`040000003oool0oooo
0?ooo`8000001P3oool00`000000oooo000000040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000L0oooo0P0000040?ooo`030000003o
ool0oooo00D0oooo0P0000070?ooo`040000003oool0oooo0?ooo`8000001P3oool00`000000oooo
000000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool01@000000oooo
0?ooo`3oool0000000L0oooo0P0000040?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`04
0000003oool0oooo0?ooo`8000001P3oool00`000000oooo000000040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000L0oooo0P000004
0?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`80000000000`000000oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo0P0000020?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo008000001@3oool00`000000oooo000000040?ooo`030000
003oool0oooo0080oooo0P0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`020?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo008000001@3oool00`000000oooo000000040?ooo`030000003oool0
oooo0080oooo0P0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`020?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo008000001@3oool00`000000oooo000000040?ooo`030000003oool0oooo0080
oooo0P0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo008000001@3oool010000000oooo0000003oool10000000000D000000?ooo`3oool0oooo
000000050?ooo`8000001`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00`3oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000060?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`0000001P3oool2000000D0oooo00<000000?ooo`3o
ool00`3oool2000000L0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
00<0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0000000H0oooo0P0000050?ooo`030000003oool0oooo
00<0oooo0P0000070?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`03
0?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000060?ooo`8000001@3oool00`000000oooo0?ooo`03
0?ooo`8000001`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3o
ool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000001P3oool2000000@0oooo0@00000000060000003oool0
oooo0000003oool000002`3oool2000000H0oooo00<000000?ooo`0000000`3oool00`000000oooo
0?ooo`040?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0103oool010000000
oooo0?ooo`0000020?ooo`8000001P3oool00`000000oooo0000000;0?ooo`8000001P3oool00`00
0000oooo000000030?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000002`3oool0
0`000000oooo0?ooo`040?ooo`040000003oool0oooo00000080oooo0P0000060?ooo`030000003o
ool0000000/0oooo0P0000060?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0
00000P3oool2000000H0oooo00<000000?ooo`0000002`3oool2000000H0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000/0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000020?ooo`8000001P3oool10000000000D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000@3oool10000000000<00000
0?ooo`3oool01@3oool2000000<0oooo0P0000060?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`0:
0?ooo`8000001`3oool2000000<0oooo0P0000060?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`0:
0?ooo`8000001`3oool2000000<0oooo0P0000060?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`0:
0?ooo`8000001`3oool2000000<0oooo0P0000060?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`0:
0?ooo`8000000P3oool10000000000@000000?ooo`3oool000000P3oool00`000000oooo00000004
0?ooo`070000003oool0oooo0?ooo`000000oooo000000080?ooo`040000003oool0oooo000000L0
oooo00D000000?ooo`000000oooo000000050?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool01@3oool010000000oooo0?ooo`0000070?ooo`060000003oool0oooo0000003oool0
0000103oool01`000000oooo0?ooo`3oool000000?ooo`000000203oool010000000oooo0?ooo`00
00070?ooo`050000003oool000000?ooo`0000001@3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00D0oooo00@000000?ooo`3oool000001`3oool01P000000oooo0?ooo`000000
oooo000000@0oooo00L000000?ooo`3oool0oooo0000003oool0000000P0oooo00@000000?ooo`3o
ool000001`3oool01@000000oooo0000003oool0000000D0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000L0oooo00H000000?ooo`3oool0
00000?ooo`0000040?ooo`070000003oool0oooo0?ooo`000000oooo000000080?ooo`040000003o
ool0oooo000000L0oooo00D000000?ooo`000000oooo000000050?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000070?ooo`40000000000`00
0000oooo000000020?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`030000003oool00000
00H0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
000000D0oooo0P0000030?ooo`040000003oool0oooo000000H0oooo0P0000020?ooo`040000003o
ool0oooo000000@0oooo00@000000?ooo`3oool000001@3oool2000000<0oooo00<000000?ooo`00
00001P3oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`0000001@3oool2000000<0oooo00@000000?ooo`3oool000001P3oool200000080oooo00@00000
0?ooo`3oool00000103oool010000000oooo0?ooo`0000050?ooo`8000000`3oool00`000000oooo
000000060?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool00`000000
oooo000000050?ooo`8000000`3oool010000000oooo0?ooo`0000060?ooo`8000000P3oool01000
0000oooo0?ooo`0000040?ooo`040000003oool0oooo000000D0oooo0P0000030?ooo`030000003o
ool0000000H0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0000000D0oooo0P0000030?ooo`040000003oool0oooo000000H0oooo0P0000020?ooo`04
0000003oool0oooo000000D0oooo0@00000000030000003oool0oooo00L0oooo0P0000080?ooo`05
0000003oool0oooo0?ooo`0000001`3oool00`000000oooo0000000:0?ooo`8000002@3oool01@00
0000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`0000002`3oool2000000`0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0000000:0?ooo`8000002@3oool01@000000oooo0?ooo`3o
ool0000000H0oooo00<000000?ooo`0000002`3oool2000000P0oooo00D000000?ooo`3oool0oooo
000000070?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0103oool2000000d0oooo
00<000000?ooo`3oool0103oool00`000000oooo0000000;0?ooo`800000203oool01@000000oooo
0?ooo`3oool0000000L0oooo00<000000?ooo`0000002P3oool2000000T0oooo00D000000?ooo`3o
ool0oooo000000060?ooo`030000003oool0000000@0oooo0@00000000030000003oool0oooo00@0
oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00<0oooo0P0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000009
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool200000080oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000090?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`030?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool01`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
0P3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`80
00000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002@3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo0P0000020?ooo`030000003oool0
oooo0080oooo0P00000000030000003oool0oooo00<0oooo00<000000?ooo`0000001P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo0P0000050?ooo`030000003oool00000
00<0oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo0P0000050?ooo`030000003oool0000000@0oooo00<000000?ooo`0000001P3oool02@00
0000oooo0?ooo`3oool000000?ooo`000000oooo000000040?ooo`8000001@3oool00`000000oooo
000000030?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo
000000030?ooo`8000001@3oool00`000000oooo000000040?ooo`030000003oool0000000H0oooo
00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`8000001@3oool00`000000oooo
000000030?ooo`030000003oool0000000L0oooo00T000000?ooo`3oool0oooo0000003oool00000
0?ooo`0000000`3oool2000000D0oooo00<000000?ooo`000000103oool00`000000oooo00000006
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool2000000D0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000070?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000`3oool2000000D0oooo00@000000?ooo`000000oooo0@00000000030000003oool0
oooo00@0oooo00@000000?ooo`3oool000000P3oool2000000D0oooo00<000000?ooo`0000002`3o
ool00`000000oooo000000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000
1@3oool00`000000oooo0000000:0?ooo`030000003oool0000000H0oooo00@000000?ooo`3oool0
00000P3oool2000000D0oooo00<000000?ooo`0000002`3oool00`000000oooo000000050?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`000000oooo0000000:0?oo
o`030000003oool0000000H0oooo00@000000?ooo`3oool000000P3oool2000000D0oooo00<00000
0?ooo`0000002`3oool00`000000oooo000000050?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`0000001@3oool00`000000oooo0000000:0?ooo`030000003oool0000000H0oooo00@0
00000?ooo`3oool000000P3oool2000000D0oooo00<000000?ooo`0000002`3oool00`000000oooo
000000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`000000
oooo0000000:0?ooo`030000003oool000000080oooo0@00000000050000003oool0oooo0?ooo`00
0000103oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`05
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`4000000000
1P000000oooo0?ooo`000000oooo000000@0oooo00@000000?ooo`3oool000000`3oool2000000H0
oooo00<000000?ooo`0000000`3oool2000000H0oooo0P0000040?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`050?ooo`8000000`3oool2000000H0oooo00<000000?oo
o`000000103oool010000000oooo0?ooo`0000030?ooo`8000001P3oool00`000000oooo00000003
0?ooo`8000001P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00D0oooo0P0000030?ooo`8000001P3oool00`000000oooo000000040?ooo`040000003o
ool0oooo000000<0oooo0P0000060?ooo`030000003oool0000000<0oooo0P0000060?ooo`800000
103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool2000000<0
oooo0P0000060?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000`3oool20000
00H0oooo00<000000?ooo`0000000`3oool2000000H0oooo0P0000040?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`8000000`3oool2000000H0oooo0@000000
00050000003oool0oooo0?ooo`0000000`3oool200000080oooo00H000000?ooo`3oool000000?oo
o`0000030?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool02@000000oooo
0?ooo`3oool000000?ooo`000000oooo000000030?ooo`8000000`3oool01@000000oooo0000003o
ool0000000@0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo0080oooo
0P0000020?ooo`040000003oool0oooo0?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo
000000<0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`090000003oool0
oooo0?ooo`000000oooo0000003oool0000000<0oooo0P0000030?ooo`050000003oool000000?oo
o`000000103oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool00P3oool2
00000080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`060000003oool0oooo0000003oool0
00000`3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00T000000?ooo`3o
ool0oooo0000003oool000000?ooo`0000000`3oool2000000<0oooo00D000000?ooo`000000oooo
000000040?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`80
00000P3oool010000000oooo0?ooo`3oool200000080oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool02@000000oooo0?oo
o`3oool000000?ooo`000000oooo000000030?ooo`8000000`3oool01@000000oooo0000003oool0
000000@0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo0080oooo0P00
00010?ooo`40000000000`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000001@3oool2000000@0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000001@3oool2000000@0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000001@3oool2000000@0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000001@3oool2000000@0oooo0P0000020?ooo`400000000010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003o
ool0000000P0oooo00D000000?ooo`3oool0oooo000000090?ooo`040000003oool0oooo000000L0
oooo0P0000090?ooo`040000003oool0oooo000000T0oooo00D000000?ooo`3oool0oooo00000006
0?ooo`030000003oool0000000P0oooo00D000000?ooo`3oool0oooo000000090?ooo`040000003o
ool0oooo000000L0oooo0P0000090?ooo`040000003oool0oooo000000T0oooo00D000000?ooo`3o
ool0oooo000000060?ooo`030000003oool0000000P0oooo00D000000?ooo`3oool0oooo00000009
0?ooo`040000003oool0oooo000000L0oooo0P0000090?ooo`040000003oool0oooo000000T0oooo
00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0000000P0oooo00D000000?ooo`3o
ool0oooo000000090?ooo`040000003oool0oooo000000L0oooo0P0000090?ooo`40000000000`00
0000oooo000000020?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`8000001`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00`3oool200000080oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool2000000L0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00<0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`00
0000oooo0?ooo`020?ooo`400000000010000000oooo0?ooo`0000060?ooo`800000203oool01@00
0000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo0P0000070?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool2000000P0oooo00D000000?ooo`3oool0oooo
000000070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`060?ooo`040000003oool0oooo0?ooo`8000001`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo0P0000080?ooo`050000003oool0oooo0?ooo`0000001`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool01000
0000oooo0?ooo`3oool2000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`800000203oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo
0P0000070?ooo`030000003oool0oooo00<0oooo0@00000000030000003oool0000000<0oooo00<0
00000?ooo`0000001@3oool01P000000oooo0?ooo`000000oooo000000P0oooo00<000000?ooo`00
00001`3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool01@000000oooo0000003o
ool0000000P0oooo00@000000?ooo`3oool000001P3oool01`000000oooo0?ooo`3oool000000?oo
o`0000001@3oool01P000000oooo0?ooo`000000oooo000000P0oooo00<000000?ooo`0000001`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool01@000000oooo0000003oool00000
00P0oooo00@000000?ooo`3oool000001P3oool01`000000oooo0?ooo`3oool000000?ooo`000000
1@3oool01P000000oooo0?ooo`000000oooo000000P0oooo00<000000?ooo`0000001`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000001@3oool01@000000oooo0000003oool0000000P0oooo
00@000000?ooo`3oool000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool0
1P000000oooo0?ooo`000000oooo000000P0oooo00<000000?ooo`0000001`3oool01`000000oooo
0?ooo`3oool000000?ooo`0000001@3oool01@000000oooo0000003oool0000000P0oooo00@00000
0?ooo`3oool000001`3oool10000000000<000000?ooo`3oool00P3oool00`000000oooo00000005
0?ooo`040000003oool0oooo000000D0oooo0P0000030?ooo`030000003oool0000000D0oooo0P00
00040?ooo`030000003oool0000000D0oooo00<000000?ooo`0000001@3oool2000000<0oooo00@0
00000?ooo`3oool000001@3oool2000000<0oooo00<000000?ooo`0000001@3oool010000000oooo
0?ooo`0000050?ooo`8000000`3oool00`000000oooo000000050?ooo`800000103oool00`000000
oooo000000050?ooo`030000003oool0000000D0oooo0P0000030?ooo`040000003oool0oooo0000
00D0oooo0P0000030?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool000001@3oool2
000000<0oooo00<000000?ooo`0000001@3oool2000000@0oooo00<000000?ooo`0000001@3oool0
0`000000oooo000000050?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`8000000`3o
ool00`000000oooo000000050?ooo`040000003oool0oooo000000D0oooo0P0000030?ooo`030000
003oool0000000D0oooo0P0000040?ooo`030000003oool0000000D0oooo00<000000?ooo`000000
1@3oool2000000<0oooo00@000000?ooo`3oool000001@3oool200000040oooo0@00000000030000
003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000070?ooo`800000103oool01@000000
oooo0?ooo`3oool000000080oooo0P0000090?ooo`050000003oool0oooo0?ooo`0000001P3oool2
000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`800000203oool01@000000oooo0?oo
o`3oool0000000L0oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000T0
oooo00D000000?ooo`3oool0oooo000000060?ooo`8000001@3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000080?ooo`050000003oool0oooo0?ooo`0000001`3oool2000000@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`8000002@3oool01@000000oooo0?ooo`3oool0000000H0
oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000P0oooo00D000000?oo
o`3oool0oooo000000070?ooo`800000103oool01@000000oooo0?ooo`3oool000000080oooo0P00
00090?ooo`050000003oool0oooo0?ooo`0000001P3oool2000000D0oooo00D000000?ooo`3oool0
oooo000000020?ooo`8000000P3oool10000000000@000000?ooo`3oool0oooo0P0000020?ooo`05
0000003oool0oooo0?ooo`0000001@3oool2000000H0oooo00D000000?ooo`3oool0oooo00000009
0?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000070?ooo`050000003o
ool0oooo0?ooo`000000203oool200000080oooo00D000000?ooo`3oool0oooo000000050?ooo`80
00001P3oool01@000000oooo0?ooo`3oool0000000T0oooo0P0000020?ooo`050000003oool0oooo
0?ooo`000000103oool2000000L0oooo00D000000?ooo`3oool0oooo000000080?ooo`8000000P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo0P0000060?ooo`050000003oool0oooo0?ooo`00
00002@3oool200000080oooo00D000000?ooo`3oool0oooo000000040?ooo`8000001`3oool01@00
0000oooo0?ooo`3oool0000000P0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool2000000H0oooo00D000000?ooo`3oool0oooo000000090?ooo`8000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo0P0000070?ooo`050000003oool0oooo0?ooo`0000001`3oool10000
000000<000000?ooo`3oool00P0000050?ooo`030000003oool0000000@0oooo0P0000050?ooo`03
0000003oool0000000D0oooo00<000000?ooo`000000103oool2000000D0oooo00<000000?ooo`00
00000`3oool2000000D0oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000030?oo
o`8000001@3oool00`000000oooo000000040?ooo`8000001@3oool00`000000oooo000000050?oo
o`030000003oool0000000@0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000050?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<00000
0?ooo`000000103oool2000000D0oooo00<000000?ooo`0000001@3oool00`000000oooo00000004
0?ooo`8000001@3oool00`000000oooo000000030?ooo`8000001@3oool010000000oooo0?ooo`00
00050?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000@0oooo0P00
00050?ooo`030000003oool0000000D0oooo00<000000?ooo`000000103oool2000000D0oooo00<0
00000?ooo`0000000`3oool2000000D0oooo00@000000?ooo`3oool000001@3oool00`000000oooo
000000030?ooo`40000000000`000000oooo0?ooo`060?ooo`030000003oool0000000T0oooo00D0
00000?ooo`000000oooo000000050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo000000080?ooo`030000003oool000000080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000
2@3oool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`0000000`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0000000P0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0103oool00`000000
oooo000000090?ooo`050000003oool000000?ooo`0000001@3oool00`000000oooo000000030?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`000000203oool00`000000oooo000000020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0000000T0oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool0
000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000080?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`80000000000`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo000000080?ooo`8000001P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00D00000
0?ooo`3oool0oooo000000080?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00D0oooo0P0000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo
000000080?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo
0P0000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000080?ooo`80
00001P3oool100000040oooo0@00000000030000003oool0oooo00<0oooo00<000000?ooo`3oool0
1@3oool2000000D0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001@3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00D0oooo0P0000050?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool20000
00D0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`050?ooo`8000001@3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool000000080oooo0P0000050?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool01@3oool2000000D0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000001@3oool00`000000oooo
0?ooo`020000000000<000000?ooo`3oool0203oool2000000L0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000H0oooo0P0000020?oo
o`030000003oool0oooo00L0oooo0P0000070?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00`3oool2000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo00000006
0?ooo`070000003oool0oooo0?ooo`000000oooo000000060?ooo`8000000P3oool00`000000oooo
0?ooo`070?ooo`8000001`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0
oooo0P0000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001P3oool01`000000
oooo0?ooo`3oool000000?ooo`0000001P3oool200000080oooo00<000000?ooo`3oool01`3oool2
000000L0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0000000H0oooo00L000000?ooo`3oool0oooo
0000003oool0000000H0oooo0P0000020?ooo`4000000@3oool10000000000@000000?ooo`3oool0
oooo0P0000040?ooo`8000001@3oool00`000000oooo000000050?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`030000003oool0000000D0
oooo0P0000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool2000000@0
oooo0P0000050?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0000000<0oooo00<000000?ooo`0000001@3oool2000000D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`800000103oool2000000D0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000050?ooo`8000001@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo0P0000040?ooo`8000001@3oool00`000000
oooo000000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo000000030?ooo`030000003oool0000000D0oooo0P0000050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool10000000000<000000?ooo`3oool00P0000040?ooo`030000
003oool0oooo0080oooo00D000000?ooo`000000oooo000000040?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P0000040?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`000000oooo000000040?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0
oooo0080oooo00D000000?ooo`000000oooo000000040?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool00@00000000030000003oool0oooo00D0oooo
0P0000030?ooo`8000001`3oool020000000oooo0?ooo`3oool000000?ooo`000000oooo0P000003
0?ooo`8000001P3oool2000000<0oooo00<000000?ooo`0000001P3oool2000000<0oooo0P000000
0`3oool00000000000030?ooo`030000003oool0000000H0oooo0P0000030?ooo`8000001`3oool0
20000000oooo0?ooo`3oool000000?ooo`000000oooo0P0000030?ooo`8000001P3oool2000000<0
oooo00<000000?ooo`0000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`03
0000003oool0000000H0oooo0P0000030?ooo`8000001`3oool020000000oooo0?ooo`3oool00000
0?ooo`000000oooo0P0000030?ooo`8000001P3oool2000000<0oooo00<000000?ooo`0000001P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`030000003oool0000000H0oooo0P00
00030?ooo`8000001`3oool020000000oooo0?ooo`3oool000000?ooo`000000oooo0P0000030?oo
o`8000001P3oool2000000<0oooo00<000000?ooo`0000001P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`040000003oool000000?ooo`40000000000`000000oooo0?ooo`030?oo
o`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000D0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000050?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000001@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000D0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
000000D0oooo00<000000?ooo`3oool00@00000000060000003oool0oooo0000003oool000001@3o
ool2000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00<0oooo0P0000050?ooo`8000000`3oool01@000000oooo0?ooo`3oool0000000D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000D0
oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`030?ooo`8000001@3oool2000000<0oooo00D000000?ooo`3oool0oooo00000005
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000005
0?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`3oool2000000D0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000
1@3oool2000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00<0oooo0P0000050?ooo`8000000`3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`400000000010000000
oooo0000000000060?ooo`8000001P3oool00`000000oooo000000030?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`8000001`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool20000
00H0oooo0P0000060?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo000000030?ooo`030000003oool0oooo00@0oooo0P0000070?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo000000030?ooo`8000001P3oool20000
00H0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool0103oool2000000L0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0000000<0oooo0P0000060?ooo`8000001P3oool00`00
0000oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`040?ooo`8000001`3oool00`000000oooo000000030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`000000103oool10000000000<000000?ooo`000000103oool00`000000
oooo0?ooo`060?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool20000
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool00P3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`03
0?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo0P0000020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool200000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo0?ooo`030?ooo`40000000000`00
0000oooo0?ooo`030?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`8000001`3oool01`000000oooo0?ooo`3oool000000?ooo`0000001`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo0P0000070?ooo`070000003oool0oooo0?ooo`000000oooo000000070?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000L0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool2000000L0oooo00L000000?ooo`3oool0oooo0000003oool0000000L0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`8000001`3oool01`000000oooo0?ooo`3oool000000?ooo`0000001`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`4000000@3oool10000000000<0
00000?ooo`3oool0103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P0000050?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000060?ooo`040000003oool0
oooo00000080oooo0P0000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`02000000D0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo000000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`02000000H0oooo00@000000?ooo`3oool000000P3oool2000000D0oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo008000001@3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000001P3oool010000000
oooo0?ooo`0000020?ooo`8000001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P0000050?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`0000001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P0000020?ooo`400000000010000000oooo0?ooo`3oool2000000<0oooo
00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool00`3oool010000000oooo0?ooo`0000050?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`030?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`040000
003oool0oooo000000D0oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool2000000<0oooo
00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000050?ooo`8000000`3oool01000
0000oooo0?ooo`0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`030?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo00@000000?oo
o`3oool000001@3oool2000000<0oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000050?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool01000
0000oooo0?ooo`0000040?ooo`040000003oool0oooo000000@0oooo0@00000000030000003oool0
oooo008000001@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`800000203oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00@0oooo0P0000050?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000080?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0103oool2000000D0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000P0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`8000001@3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`80
0000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0@00000000030000
003oool0oooo00D0oooo0P0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo00000005
0?ooo`8000000`3oool00`000000oooo000000060?ooo`050000003oool000000?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`8000001P3oool200000080oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0
oooo0000003oool0000000D0oooo0P0000030?ooo`030000003oool0000000H0oooo00D000000?oo
o`000000oooo000000040?ooo`030000003oool0oooo0080oooo0P0000060?ooo`8000000P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`00
00001P3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool00P3oool20000
00H0oooo0P0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000050?ooo`800000
0`3oool00`000000oooo000000060?ooo`050000003oool000000?ooo`000000103oool00`000000
oooo0?ooo`020?ooo`8000000@3oool10000000000<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo
000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0000000D0oooo0P0000040?ooo`8000001P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo
000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0000000D0oooo0P0000040?ooo`8000001P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo
000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0000000D0oooo0P0000040?ooo`8000001P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo
000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0000000D0oooo0P0000040?ooo`8000000P3oool10000000000@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`00
0000103oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000T0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`02000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000090?ooo`050000
003oool0oooo0?ooo`000000103oool01@000000oooo0000003oool0000000<0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000000T0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000090?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0000003oool00000
00<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000T0oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000090?ooo`050000003oool0oooo0?ooo`000000103oool01@000000
oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
000000T0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`02000000@0oooo00<0
00000?ooo`3oool00P3oool10000000000H000000?ooo`00000000000?ooo`0000050?ooo`800000
0P3oool010000000oooo0?ooo`3oool2000000<0oooo0P0000060?ooo`8000000`3oool01@000000
oooo0000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000`3oool0
0`000000oooo000000060?ooo`8000000`3oool2000000030?ooo`000000oooo00@0oooo0P000002
0?ooo`040000003oool0oooo0?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`050000003o
ool000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo0P0000030?ooo`03
0000003oool0000000H0oooo0P0000030?ooo`80000000<0oooo0000003oool0103oool200000080
oooo00@000000?ooo`3oool0oooo0P0000030?ooo`8000001P3oool2000000<0oooo00D000000?oo
o`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000<0oooo00<0
00000?ooo`0000001P3oool2000000<0oooo0P0000000`3oool000000?ooo`040?ooo`8000000P3o
ool010000000oooo0?ooo`3oool2000000<0oooo0P0000060?ooo`8000000`3oool01@000000oooo
0000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000`3oool00`00
0000oooo000000060?ooo`800000103oool10000000000<000000?ooo`0000000`3oool010000000
oooo0?ooo`3oool2000000D0oooo00<000000?ooo`000000103oool02@000000oooo0?ooo`3oool0
00000?ooo`000000oooo000000050?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000050?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`000000103oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000050?ooo`030000003oool0
000000@0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000001@3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`8000001@3oool00`000000oooo000000040?ooo`090000003oool0oooo0?ooo`000000
oooo0000003oool0000000D0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000
00040?ooo`050000003oool0oooo0?ooo`0000000`3oool2000000D0oooo00<000000?ooo`000000
103oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000050?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`000000103oool20000000000<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000050?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo000000060?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
00H0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000H0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000001P3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080
oooo00<000000?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000006
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000060?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo000000H0oooo0@0000010?ooo`40000000000`000000oooo
0?ooo`040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo
000000040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`010000000000@000000?ooo`3oool0oooo0P000002
0?ooo`050000003oool0oooo0?ooo`0000001@3oool200000080oooo00D000000?ooo`3oool0oooo
000000030?ooo`050000003oool0oooo0?ooo`0000001@3oool200000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool01@000000oooo0?ooo`3o
ool0000000D0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000000D0oooo0P0000020?ooo`050000003oool0oooo0?ooo`000000103oool20000
0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`3oool00P3oool200000080oooo00D000000?ooo`3oool0oooo000000050?ooo`8000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`80
00000P3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000020?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo0P000002
0?ooo`050000003oool0oooo0?ooo`0000001@3oool200000080oooo00D000000?ooo`3oool0oooo
000000030?ooo`050000003oool0oooo0?ooo`0000001@3oool200000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000`3oool010000000oooo0?ooo`3oool10000000000<000000?ooo`3oool00P000005
0?ooo`030000003oool0000000@0oooo0P0000050?ooo`030000003oool0000000D0oooo00<00000
0?ooo`000000103oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<00000
0?ooo`0000001P3oool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo00000004
0?ooo`8000001@3oool00`000000oooo000000050?ooo`030000003oool0000000@0oooo0P000005
0?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000H0oooo00<00000
0?ooo`0000000`3oool2000000D0oooo00<000000?ooo`000000103oool2000000D0oooo00<00000
0?ooo`0000001@3oool00`000000oooo000000040?ooo`8000001@3oool00`000000oooo00000003
0?ooo`8000001@3oool00`000000oooo000000060?ooo`030000003oool0000000<0oooo0P000005
0?ooo`030000003oool0000000@0oooo0P0000050?ooo`030000003oool0000000D0oooo00<00000
0?ooo`000000103oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<00000
0?ooo`0000001P3oool00`000000oooo000000030?ooo`40000000000`000000oooo0?ooo`040?oo
o`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
00000?ooo`0000000`3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0000003oool0000000<0oooo0P000000103oool000000?ooo`0000030?ooo`030000003oool0
oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`000000oooo000000030?ooo`050000003oool000000?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`020?oo
o`050000003oool000000?ooo`0000000`3oool2000000040?ooo`000000oooo000000<0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`000000oooo000000030?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0
oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`80000000@0oooo0000003oool00000
0`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`050000003oool000000?ooo`0000000`3oool01@000000oooo0000003oool0
000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo0P000000103oool00000
0?ooo`0000030?ooo`80000000000`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo
000000030?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`00
0000oooo000000030?ooo`8000001P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo
008000001@3oool010000000oooo0000000000030?ooo`8000001P3oool00`000000oooo00000003
0?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`000000oooo
000000030?ooo`8000001P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00800000
1@3oool010000000oooo0000000000030?ooo`8000001P3oool00`000000oooo000000030?ooo`80
00000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`000000oooo00000003
0?ooo`8000001P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo008000001@3oool0
10000000oooo0000000000030?ooo`8000001P3oool00`000000oooo000000030?ooo`8000000P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`000000oooo000000030?ooo`80
00001P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo008000001@3oool00`000000
oooo000000020000000000<000000?ooo`3oool00`3oool01`000000oooo0?ooo`3oool000000?oo
o`0000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000T0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool00000
00@0oooo00D000000?ooo`3oool0oooo000000090?ooo`040000003oool0oooo000000@0oooo00L0
00000?ooo`3oool0oooo0000003oool000000080oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`0000090?ooo`050000003oool0oooo0?ooo`000000103oool02@000000oooo0?ooo`3o
ool000000?ooo`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000002@3oool01000
0000oooo0?ooo`0000040?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool000002@3oool01@000000oooo0?ooo`3oool00000
00@0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000103oool01@000000oooo
0?ooo`3oool0000000T0oooo00@000000?ooo`3oool00000103oool01`000000oooo0?ooo`3oool0
00000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000T0oooo
00D000000?ooo`3oool0oooo000000040?ooo`090000003oool0oooo0?ooo`000000oooo0000003o
ool0000000@0oooo00D000000?ooo`3oool0oooo000000090?ooo`050000003oool0oooo0000003o
ool00@00000000040000003oool0oooo0?ooo`8000000`3oool00`000000oooo000000050?ooo`03
0000003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000<0oooo00<000000?ooo`0000001@3oool2000000H0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`8000000`3oool00`000000oooo000000050?ooo`03
0000003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000<0oooo00<000000?ooo`0000001@3oool2000000H0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`8000000`3oool00`000000oooo000000050?ooo`03
0000003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000<0oooo00<000000?ooo`0000001@3oool2000000H0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`8000000`3oool00`000000oooo000000050?ooo`03
0000003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000<0oooo00<000000?ooo`0000001@3oool2000000H0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`030?ooo`40000000000`000000oooo0?ooo`02000000@0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo0P000000103oool0
00000?ooo`0000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo00000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool00P0000030?ooo`80000000<0oooo000000000000103oool0
0`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3oool2000000040?ooo`00
0000oooo000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`02000000<0oooo0P0000000`3oool00000000000040?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`80000000@0oooo0000
003oool000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool00`000000oooo0000
00020?ooo`030000003oool0oooo008000000`3oool2000000030?ooo`000000000000@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo0P000000103oool00000
0?ooo`0000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool00000
0080oooo00<000000?ooo`3oool00P0000030?ooo`8000000@3oool10000000000<000000?ooo`3o
ool01@3oool2000000<0oooo0P0000060?ooo`8000000`3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<000000?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`0000001P3oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo0P0000070?ooo`8000000`3oool2
000000H0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?oo
o`050?ooo`8000000`3oool00`000000oooo000000060?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool00000103oool2000000L0oooo0P0000030?ooo`8000001P3oool2000000<0oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`03
0000003oool0000000H0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?oo
o`8000001`3oool2000000<0oooo0P0000060?ooo`8000000`3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`0000001P3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`4000000000
10000000oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00L000000?ooo`3oool0oooo
0000003oool0000000P0oooo00<000000?ooo`000000203oool01@000000oooo0000003oool00000
00D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`040000003oool0
oooo000000L0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`070000003oool0oooo0?oo
o`000000oooo000000080?ooo`030000003oool0000000P0oooo00D000000?ooo`000000oooo0000
00050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool010000000oooo
0?ooo`0000070?ooo`060000003oool0oooo0000003oool00000103oool01`000000oooo0?ooo`3o
ool000000?ooo`000000203oool00`000000oooo000000080?ooo`050000003oool000000?ooo`00
00001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00@000000?oo
o`3oool000001`3oool01P000000oooo0?ooo`000000oooo000000@0oooo00L000000?ooo`3oool0
oooo0000003oool0000000P0oooo00<000000?ooo`000000203oool01@000000oooo0000003oool0
000000D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`040000003o
ool0oooo000000L0oooo0@00000000060000003oool000000000003oool000001@3oool2000000<0
oooo00D000000?ooo`000000oooo000000030?ooo`80000000@0oooo0000003oool000000`3oool2
000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00H000000?ooo`3oool000000?oo
o`0000030?ooo`<000000P3oool00`000000oooo0?ooo`02000000<0oooo0P0000000`3oool00000
0?ooo`040?ooo`8000000`3oool01@000000oooo0000003oool0000000<0oooo0P000000103oool0
00000?ooo`0000030?ooo`8000000`3oool00`000000oooo000000050?ooo`8000000`3oool01P00
0000oooo0?ooo`000000oooo000000<0oooo0`0000020?ooo`030000003oool0oooo008000000`3o
ool2000000030?ooo`000000oooo00@0oooo0P0000030?ooo`050000003oool000000?ooo`000000
0`3oool2000000040?ooo`000000oooo000000<0oooo0P0000030?ooo`030000003oool0000000D0
oooo0P0000030?ooo`060000003oool0oooo0000003oool000000`3oool300000080oooo00<00000
0?ooo`3oool00P0000030?ooo`80000000<0oooo0000003oool0103oool2000000<0oooo00D00000
0?ooo`000000oooo000000030?ooo`80000000@0oooo0000003oool000000`3oool2000000<0oooo
00<000000?ooo`0000001@3oool2000000<0oooo00H000000?ooo`3oool000000?ooo`0000030?oo
o`<000000P3oool00`000000oooo0?ooo`02000000@0oooo0@00000000030000003oool0000000@0
oooo00<000000?ooo`3oool00P0000040?ooo`040000003oool0oooo000000<0oooo0P0000070?oo
o`8000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000001@3oool01000
0000oooo0?ooo`0000030?ooo`8000001P3oool2000000@0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`02000000@0oooo00@000000?ooo`3oool000000`3oool2000000L0oooo0P00
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000050?ooo`040000003o
ool0oooo000000<0oooo0P0000060?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00800000103oool010000000oooo0?ooo`0000030?ooo`8000001`3oool2000000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000D0oooo00@000000?ooo`3o
ool000000`3oool2000000H0oooo0P0000040?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P0000040?ooo`040000003oool0oooo000000<0oooo0P0000070?ooo`8000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo008000001@3oool010000000oooo0?ooo`00
00030?ooo`8000001P3oool2000000D0oooo0@00000000030000003oool0oooo00<0oooo00<00000
0?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo0P000006
0?ooo`070000003oool0oooo0?ooo`000000oooo000000060?ooo`8000001@3oool00`000000oooo
0?ooo`040?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000H0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`8000001P3oool01`000000oooo
0?ooo`3oool000000?ooo`0000001P3oool2000000D0oooo00<000000?ooo`3oool0103oool20000
00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000060?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool01@3oool2000000H0oooo00L000000?ooo`3oool0oooo0000003o
ool0000000H0oooo0P0000050?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00D0oooo0P0000060?ooo`070000003oool0oooo0?ooo`000000oooo000000060?ooo`80
00001@3oool00`000000oooo0?ooo`040?ooo`8000001P3oool100000040oooo0@00000000050000
003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`8000000`3oool00`00
0000oooo000000020?ooo`050000003oool0oooo0000003oool00P0000020?ooo`030000003oool0
oooo008000000`3oool00`000000oooo000000020?ooo`030000003oool0oooo00800000103oool0
0`000000oooo000000020?ooo`030000003oool0oooo00<000000P3oool00`000000oooo0?ooo`02
000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`02000000<0oooo00<0
00000?ooo`0000000P3oool01@000000oooo0?ooo`000000oooo008000000P3oool00`000000oooo
0?ooo`02000000<0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`02000000@0oooo
00<000000?ooo`0000000P3oool00`000000oooo0?ooo`0300000080oooo00<000000?ooo`3oool0
0P0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P0000030?ooo`03
0000003oool000000080oooo00D000000?ooo`3oool000000?ooo`0200000080oooo00<000000?oo
o`3oool00P0000030?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P0000040?oo
o`030000003oool000000080oooo00<000000?ooo`3oool00`0000020?ooo`030000003oool0oooo
008000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo008000000`3oool0
0`000000oooo000000020?ooo`050000003oool0oooo0000003oool00P0000020?ooo`030000003o
ool0oooo008000000`3oool00`000000oooo000000020?ooo`030000003oool0oooo00800000103o
ool00`000000oooo000000020?ooo`030000003oool0oooo00<000000P3oool00`000000oooo0?oo
o`0200000080oooo0@00000000060000003oool0oooo0000003oool000000`3oool010000000oooo
0?ooo`0000040?ooo`8000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo0P000000
0`3oool000000?ooo`030?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`8000000`3o
ool00`000000oooo0?ooo`02000000<0oooo0P0000000`3oool000000?ooo`030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool00000103oool2000000<0oooo00H000000?ooo`3oool0
00000?ooo`0000030?ooo`80000000<0oooo0000003oool00`3oool2000000<0oooo00@000000?oo
o`3oool000001@3oool2000000<0oooo00<000000?ooo`3oool00P0000030?ooo`80000000<0oooo
0000003oool00`3oool00`000000oooo000000030?ooo`040000003oool0oooo000000@0oooo0P00
00030?ooo`060000003oool0oooo0000003oool000000`3oool2000000030?ooo`000000oooo00<0
oooo0P0000030?ooo`040000003oool0oooo000000D0oooo0P0000030?ooo`030000003oool0oooo
008000000`3oool2000000030?ooo`000000oooo00<0oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`0000040?ooo`8000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo
0P0000000`3oool000000?ooo`030?ooo`8000000`3oool010000000oooo0?ooo`0000050?ooo`80
00000`3oool00`000000oooo0?ooo`02000000<0oooo0P0000000`3oool000000?ooo`030?ooo`40
000000001@000000oooo0?ooo`3oool0000000D0oooo00@000000?ooo`3oool000000`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`090000003o
ool0oooo0?ooo`000000oooo0000003oool0000000D0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0oooo00L000000?ooo`3o
ool0oooo0000003oool000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00030?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`030000003oool0oooo0080
oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000001@3oool01@000000oooo0?oo
o`3oool0000000<0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000103oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`040000
003oool0oooo000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00<00000
0?ooo`3oool00P3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`05
0000003oool0oooo0?ooo`0000000`3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo
000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`030000003oool0oooo
00<0oooo00@000000?ooo`3oool000000`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
0P3oool00`000000oooo0?ooo`020?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0
000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`090000003oool0oooo0?ooo`000000
oooo0000003oool0000000@0oooo00P000000?ooo`3oool0oooo0000003oool000000?ooo`400000
000010000000oooo0?ooo`0000020?ooo`040000003oool0000000000080oooo00<000000?ooo`3o
ool00P0000030?ooo`030000003oool0000000D0oooo00<000000?ooo`0000000`3oool01@000000
oooo0000003oool0000000<0oooo0`0000030?ooo`050000003oool000000?ooo`0000000P3oool2
000000030?ooo`000000oooo00@0oooo0P0000030?ooo`030000003oool000000080oooo00D00000
0?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool00P0000030?ooo`030000003o
ool0000000D0oooo00<000000?ooo`0000000`3oool01@000000oooo0000003oool0000000<0oooo
0`0000030?ooo`050000003oool000000?ooo`0000000P3oool2000000030?ooo`000000oooo00@0
oooo0P0000030?ooo`030000003oool000000080oooo00D000000?ooo`3oool000000?ooo`020000
0080oooo00<000000?ooo`3oool00P0000030?ooo`030000003oool0000000D0oooo00<000000?oo
o`0000000`3oool01@000000oooo0000003oool0000000<0oooo0`0000030?ooo`050000003oool0
00000?ooo`0000000P3oool2000000030?ooo`000000oooo00@0oooo0P0000030?ooo`030000003o
ool000000080oooo00D000000?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool0
0P0000030?ooo`030000003oool0000000D0oooo00<000000?ooo`0000000`3oool01@000000oooo
0000003oool0000000<0oooo0`0000030?ooo`050000003oool000000?ooo`0000000P3oool20000
00030?ooo`000000oooo00@0oooo0P0000030?ooo`030000003oool000000080oooo0@0000000003
0000003oool000000080oooo00<000000?ooo`0000001P3oool2000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0000003oool0000000@0oooo00@000000?ooo`3oool000000`3oool2
000000H0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00800000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000001P3o
ool2000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000@0oooo
00@000000?ooo`3oool000000`3oool2000000H0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00800000103oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`0000001P3oool2000000<0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0000003oool0000000@0oooo00@000000?ooo`3oool000000`3oool2000000H0oooo00<0
00000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00800000103o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000001P3oool2000000<0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000@0oooo00@000000?ooo`3o
ool000000`3oool2000000H0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00800000103oool00`000000oooo0?ooo`020?ooo`400000000010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003oool00000
00@0oooo0P0000070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000001P3oool2
000000@0oooo00@000000?ooo`3oool00000103oool2000000@0oooo00<000000?ooo`000000103o
ool2000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000060?ooo`800000
103oool010000000oooo0?ooo`0000040?ooo`800000103oool00`000000oooo000000040?ooo`80
00001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000H0oooo0P0000040?oo
o`040000003oool0oooo000000@0oooo0P0000040?ooo`030000003oool0000000@0oooo0P000007
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000001P3oool2000000@0oooo0@00
000000030000003oool000000080oooo00D000000?ooo`3oool000000?ooo`0200000080oooo00D0
00000?ooo`000000oooo000000030?ooo`<000000`3oool01@000000oooo0000003oool000000080
oooo0P000000103oool000000?ooo`0000030?ooo`030000003oool0000000<0oooo0P0000020?oo
o`030000003oool0oooo0080000000D0oooo0000003oool0oooo000000020?ooo`030000003oool0
00000080oooo0`0000020?ooo`050000003oool0oooo0000003oool00P0000020?ooo`050000003o
ool000000?ooo`0000000`3oool3000000<0oooo00D000000?ooo`000000oooo000000020?ooo`80
000000@0oooo0000003oool000000`3oool00`000000oooo000000030?ooo`8000000P3oool00`00
0000oooo0?ooo`02000000050?ooo`000000oooo0?ooo`0000000P3oool00`000000oooo00000002
0?ooo`<000000P3oool01@000000oooo0?ooo`000000oooo008000000P3oool01@000000oooo0000
003oool0000000<0oooo0`0000030?ooo`050000003oool000000?ooo`0000000P3oool200000004
0?ooo`000000oooo000000<0oooo00<000000?ooo`0000000`3oool200000080oooo00<000000?oo
o`3oool00P0000001@3oool000000?ooo`3oool000000080oooo00<000000?ooo`0000000P3oool3
00000080oooo00D000000?ooo`3oool000000?ooo`0200000080oooo00D000000?ooo`000000oooo
000000030?ooo`<000000`3oool01@000000oooo0000003oool000000080oooo0P000000103oool0
00000?ooo`0000030?ooo`030000003oool0000000<0oooo0P0000020?ooo`030000003oool0oooo
0080000000D0oooo0000003oool0oooo000000020?ooo`030000003oool000000080oooo0P000001
0?ooo`400000000010000000oooo0?ooo`3oool2000000040?ooo`000000oooo000000<0oooo0P00
00030?ooo`80000000<0oooo000000000000103oool01@000000oooo0000003oool000000080oooo
0P0000030?ooo`070000003oool000000?ooo`000000oooo000000030?ooo`040000003oool0oooo
0?ooo`80000000<0oooo000000000000103oool2000000040?ooo`000000oooo00000080oooo0P00
00030?ooo`80000000@0oooo0000003oool000000`3oool2000000<0oooo0P0000000`3oool00000
000000040?ooo`050000003oool000000?ooo`0000000P3oool2000000<0oooo00L000000?ooo`00
0000oooo0000003oool0000000<0oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000000
00040?ooo`80000000@0oooo0000003oool000000P3oool2000000<0oooo0P000000103oool00000
0?ooo`0000030?ooo`8000000`3oool2000000030?ooo`000000000000@0oooo00D000000?ooo`00
0000oooo000000020?ooo`8000000`3oool01`000000oooo0000003oool000000?ooo`0000000`3o
ool010000000oooo0?ooo`3oool2000000030?ooo`000000000000@0oooo0P000000103oool00000
0?ooo`0000020?ooo`8000000`3oool2000000040?ooo`000000oooo000000<0oooo0P0000030?oo
o`80000000<0oooo000000000000103oool01@000000oooo0000003oool000000080oooo0P000003
0?ooo`070000003oool000000?ooo`000000oooo000000030?ooo`040000003oool0oooo0?ooo`80
000000<0oooo000000000000103oool2000000040?ooo`000000oooo00000080oooo0P0000020?oo
o`40000000000`000000oooo0?ooo`02000000<0oooo00@000000?ooo`000000oooo0P0000030?oo
o`8000001`3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool00`000000oooo0000
00030?ooo`050000003oool000000?ooo`0000000`3oool2000000L0oooo0P0000030?ooo`030000
003oool0000000D0oooo0P0000030?ooo`040000003oool000000?ooo`8000000`3oool2000000L0
oooo00L000000?ooo`3oool0oooo0000003oool0000000D0oooo00<000000?ooo`0000000`3oool0
1@000000oooo0000003oool0000000<0oooo0P0000070?ooo`8000000`3oool00`000000oooo0000
00050?ooo`8000000`3oool010000000oooo0000003oool2000000<0oooo0P0000070?ooo`070000
003oool0oooo0?ooo`000000oooo000000050?ooo`030000003oool0000000<0oooo00D000000?oo
o`000000oooo000000030?ooo`8000001`3oool2000000<0oooo00<000000?ooo`0000001@3oool2
000000<0oooo00@000000?ooo`000000oooo0P0000030?ooo`8000001`3oool01`000000oooo0?oo
o`3oool000000?ooo`0000001@3oool00`000000oooo000000030?ooo`050000003oool000000?oo
o`0000000`3oool2000000L0oooo0P0000030?ooo`030000003oool0000000D0oooo0@0000000003
0000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P0000030?ooo`030000003oool000000080oooo00@000000?oo
o`3oool000001@3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`02000000@0oooo00<000000?ooo`0000000P3oool010000000oooo0?oo
o`0000040?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo008000000`3oool00`000000oooo000000020?ooo`040000003oool0oooo0000
00D0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P0000040?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103o
ool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`02000000<0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000050?ooo`05
0000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00800000103oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo00D00000
0?ooo`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P00
00030?ooo`030000003oool000000080oooo00@000000?ooo`3oool000001@3oool01@000000oooo
0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020000000000<000000?ooo`3oool0
0`3oool200000080oooo00L000000?ooo`000000oooo0000003oool0000000<0oooo0P0000000`3o
ool00000000000030?ooo`030000003oool0oooo0080oooo0P000000103oool000000?ooo`000003
0?ooo`8000000P3oool010000000oooo0000003oool2000000<0oooo0P0000000`3oool000000000
00040?ooo`030000003oool0oooo0080oooo0P0000000`3oool00000000000030?ooo`8000000P3o
ool01`000000oooo0000003oool000000?ooo`0000000`3oool2000000030?ooo`000000000000<0
oooo00<000000?ooo`3oool00P3oool2000000040?ooo`000000oooo000000<0oooo0P0000020?oo
o`040000003oool000000?ooo`8000000`3oool2000000030?ooo`000000000000@0oooo00<00000
0?ooo`3oool00P3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`070000003oool0
00000?ooo`000000oooo000000030?ooo`80000000<0oooo0000000000000`3oool00`000000oooo
0?ooo`020?ooo`80000000@0oooo0000003oool000000`3oool200000080oooo00@000000?ooo`00
0000oooo0P0000030?ooo`80000000<0oooo000000000000103oool00`000000oooo0?ooo`020?oo
o`80000000<0oooo0000000000000`3oool200000080oooo00L000000?ooo`000000oooo0000003o
ool0000000<0oooo0P0000000`3oool00000000000030?ooo`030000003oool0oooo0080oooo0P00
0000103oool000000?ooo`0000030?ooo`8000000P3oool010000000oooo0000003oool2000000<0
oooo0P0000000`3oool00000000000040?ooo`030000003oool0oooo0080oooo0P0000000`3oool0
0000000000010000000000L000000?ooo`3oool0oooo0000003oool000000080oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`3oool200000080oooo00@000000?ooo`3oool000001@3o
ool2000000<0oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080
oooo00@000000?ooo`3oool0oooo0P0000020?ooo`040000003oool0oooo000000H0oooo0P000002
0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`040000
003oool0oooo0?ooo`8000000P3oool010000000oooo0?ooo`0000050?ooo`8000000`3oool00`00
0000oooo000000020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?oo
o`3oool200000080oooo00@000000?ooo`3oool000001P3oool200000080oooo00H000000?ooo`3o
ool000000?ooo`0000020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0oooo0P00
00020?ooo`040000003oool0oooo000000D0oooo0P0000030?ooo`030000003oool000000080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`8000000P3oool0
10000000oooo0?ooo`0000060?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo00000080
oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`3oool200000080oooo00@000000?oo
o`3oool000001@3oool2000000<0oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`00
0000oooo00000080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`040000003oool0oooo0000
00H0oooo0P0000020?ooo`4000000@3oool10000000000H000000?ooo`3oool000000?ooo`000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000040?ooo`050000003oool0
00000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool000000080oooo00D0
00000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo000000020?ooo`030000003oool0oooo008000000`3oool01P000000oooo0?ooo`000000oooo
000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000@0oooo00D00000
0?ooo`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool00P0000030?ooo`060000003oool0oooo0000
003oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00800000103oool0
1@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`02000000<0oooo00H000000?ooo`3o
ool000000?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P000004
0?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo000000020?ooo`030000003oool0oooo008000000`3oool00`000000
oooo0?ooo`010000000000<000000?ooo`3oool00P000000103oool000000?ooo`0000040?ooo`80
000000D0oooo000000000000oooo000000020?ooo`090000003oool0oooo0?ooo`000000oooo0000
003oool0000000@0oooo0P0000020?ooo`<000000P3oool02@000000oooo0?ooo`3oool000000?oo
o`000000oooo000000020?ooo`040000003oool00000000000<0oooo0P0000000`3oool000000000
00030?ooo`040000003oool000000?ooo`80000000@0oooo0000003oool00000103oool200000005
0?ooo`00000000000?ooo`0000000P3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo
000000040?ooo`8000000P3oool300000080oooo00T000000?ooo`3oool0oooo0000003oool00000
0?ooo`0000000P3oool010000000oooo0000000000030?ooo`80000000<0oooo0000000000000`3o
ool010000000oooo0000003oool2000000040?ooo`000000oooo000000@0oooo0P0000001@3oool0
00000000003oool000000080oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000
103oool200000080oooo0`0000020?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0
00000080oooo00@000000?ooo`00000000000`3oool2000000030?ooo`000000000000<0oooo00@0
00000?ooo`000000oooo0P000000103oool000000?ooo`0000040?ooo`80000000D0oooo00000000
0000oooo000000020?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0oooo
0P0000020?ooo`<000000P3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo00000002
0?ooo`040000003oool00000000000<0oooo0P0000000`3oool00000000000030?ooo`040000003o
ool000000?ooo`40000000000`000000oooo000000020?ooo`030000003oool0000000<0oooo0`00
00020?ooo`030000003oool000000080oooo00T000000?ooo`3oool0oooo0000003oool000000?oo
o`0000000`3oool00`000000oooo000000020?ooo`030000003oool000000080oooo00<000000?oo
o`3oool00P000000103oool000000?ooo`0000020?ooo`040000003oool0oooo000000<0oooo0P00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`000000oooo
000000030?ooo`<000000P3oool00`000000oooo000000020?ooo`090000003oool0oooo0?ooo`00
0000oooo0000003oool0000000<0oooo00<000000?ooo`0000000P3oool00`000000oooo00000002
0?ooo`030000003oool0oooo0080000000@0oooo0000003oool000000P3oool010000000oooo0?oo
o`0000030?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080
oooo00<000000?ooo`0000000`3oool300000080oooo00<000000?ooo`0000000P3oool02@000000
oooo0?ooo`3oool000000?ooo`000000oooo000000030?ooo`030000003oool000000080oooo00<0
00000?ooo`0000000P3oool00`000000oooo0?ooo`02000000040?ooo`000000oooo00000080oooo
00@000000?ooo`3oool000000`3oool200000080oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo000000020?ooo`030000003oool0000000<0oooo0`0000020?ooo`030000003oool00000
0080oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000000`3oool00`000000oooo
000000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P000000103oool00000
0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo0P0000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00@00000000040000003oool0oooo000000<0oooo0P000000
0`3oool00000000000030?ooo`8000000`3oool010000000oooo0?ooo`3oool2000000<0oooo0P00
0000103oool000000?ooo`0000030?ooo`040000003oool0oooo0?ooo`80000000<0oooo00000000
00000`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool20000
00040?ooo`000000oooo000000@0oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000000
00030?ooo`8000000`3oool010000000oooo0?ooo`3oool2000000<0oooo0P000000103oool00000
0?ooo`0000030?ooo`040000003oool0oooo0?ooo`80000000<0oooo0000000000000`3oool00`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool2000000040?ooo`000000
oooo000000@0oooo00@000000?ooo`3oool0oooo0P0000000`3oool00000000000030?ooo`800000
0`3oool010000000oooo0?ooo`3oool2000000<0oooo0P000000103oool000000?ooo`0000030?oo
o`040000003oool0oooo0?ooo`80000000<0oooo0000000000000`3oool00`000000oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000`3oool2000000040?ooo`000000oooo000000@0oooo
00@000000?ooo`3oool0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool010000000
oooo0?ooo`3oool2000000<0oooo0P000000103oool000000?ooo`0000030?ooo`040000003oool0
oooo0?ooo`80000000<0oooo0000000000000`3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool2000000040?ooo`000000oooo000000@0oooo0@00000000030000
003oool000000080oooo0`0000020?ooo`030000003oool0oooo00<000000P3oool2000000030?oo
o`000000oooo0080000000<0oooo0000003oool00P0000020?ooo`80000000@0oooo0000003oool0
00000P3oool300000080oooo00<000000?ooo`3oool00P000000103oool000000?ooo`3oool20000
00040?ooo`000000oooo00000080oooo0`0000020?ooo`80000000<0oooo0000003oool00P000002
0?ooo`<000000P3oool00`000000oooo0?ooo`0300000080oooo0P0000000`3oool000000?ooo`02
000000030?ooo`000000oooo008000000P3oool2000000040?ooo`000000oooo00000080oooo0`00
00020?ooo`030000003oool0oooo0080000000@0oooo0000003oool0oooo0P000000103oool00000
0?ooo`0000020?ooo`<000000P3oool2000000030?ooo`000000oooo008000000P3oool300000080
oooo00<000000?ooo`3oool00`0000020?ooo`80000000<0oooo0000003oool00P0000000`3oool0
00000?ooo`0200000080oooo0P000000103oool000000?ooo`0000020?ooo`<000000P3oool00`00
0000oooo0?ooo`02000000040?ooo`000000oooo0?ooo`80000000@0oooo0000003oool000000P3o
ool300000080oooo0P0000000`3oool000000?ooo`0200000080oooo0`0000020?ooo`030000003o
ool0oooo00<000000P3oool2000000030?ooo`000000oooo0080000000<0oooo0000003oool00P00
00020?ooo`80000000@0oooo0000003oool000000P3oool300000080oooo00<000000?ooo`3oool0
0P000000103oool000000?ooo`3oool2000000040?ooo`000000oooo00000080oooo0`0000020?oo
o`80000000D0oooo0000003oool000000?ooo`010000000000@000000?ooo`3oool0oooo0P000003
0?ooo`80000000<0oooo0000000000000`3oool2000000040?ooo`000000oooo00000080oooo00<0
00000?ooo`0000000`3oool2000000040?ooo`000000oooo00000080oooo0P0000030?ooo`800000
00@0oooo0000003oool000000`3oool2000000040?ooo`000000oooo00000080oooo0P0000030?oo
o`80000000@0oooo0000003oool000000`3oool2000000<0oooo0P0000000`3oool0000000000003
0?ooo`80000000@0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`80000000@0
oooo0000003oool000000P3oool2000000<0oooo0P000000103oool000000?ooo`0000030?ooo`80
000000@0oooo0000003oool000000P3oool2000000<0oooo0P000000103oool000000?ooo`000003
0?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000000103oool000000?ooo`00
00020?ooo`030000003oool0000000<0oooo0P000000103oool000000?ooo`0000020?ooo`800000
0`3oool2000000040?ooo`000000oooo000000<0oooo0P000000103oool000000?ooo`0000020?oo
o`8000000`3oool2000000040?ooo`000000oooo000000<0oooo0P0000030?ooo`80000000<0oooo
0000000000000`3oool2000000040?ooo`000000oooo00000080oooo00<000000?ooo`0000000`3o
ool2000000040?ooo`000000oooo00000080oooo0P0000030?ooo`80000000@0oooo0000003oool0
00000`3oool2000000040?ooo`000000oooo00000080oooo0P0000030?ooo`80000000@0oooo0000
003oool000000P3oool10000000000P000000?ooo`3oool0oooo0000003oool000000?ooo`800000
0P3oool00`000000oooo0?ooo`03000000<0oooo00<000000?ooo`0000000P3oool010000000oooo
0000003oool2000000<0oooo00D000000?ooo`000000oooo000000020?ooo`<000000`3oool01000
0000oooo0000003oool2000000<0oooo00D000000?ooo`000000oooo000000020?ooo`<000000`3o
ool00`000000oooo000000020?ooo`040000003oool000000?ooo`8000000P3oool00`000000oooo
0?ooo`03000000<0oooo00<000000?ooo`0000000P3oool010000000oooo0000003oool2000000<0
oooo00D000000?ooo`000000oooo000000020?ooo`<000000`3oool010000000oooo0000003oool2
000000<0oooo00D000000?ooo`000000oooo000000020?ooo`<000000`3oool00`000000oooo0000
00020?ooo`040000003oool000000?ooo`8000000P3oool00`000000oooo0?ooo`03000000<0oooo
00<000000?ooo`0000000P3oool010000000oooo0000003oool2000000<0oooo00D000000?ooo`00
0000oooo000000020?ooo`<000000`3oool010000000oooo0000003oool2000000<0oooo00D00000
0?ooo`000000oooo000000020?ooo`<000000`3oool00`000000oooo000000020?ooo`040000003o
ool000000?ooo`8000000P3oool00`000000oooo0?ooo`03000000<0oooo00<000000?ooo`000000
0P3oool010000000oooo0000003oool2000000<0oooo00D000000?ooo`000000oooo000000020?oo
o`<000000`3oool010000000oooo0000003oool2000000<0oooo00D000000?ooo`000000oooo0000
00020?ooo`<000000`3oool010000000oooo0000003oool10000000000D000000?ooo`3oool00000
0?ooo`03000000<0oooo0P0000001P3oool000000000003oool000000?ooo`80000000T0oooo0000
003oool0oooo0000003oool000000?ooo`0000000`3oool2000000030?ooo`000000oooo00800000
00<0oooo000000000000103oool010000000oooo0000003oool200000080oooo0P0000000`3oool0
00000?ooo`02000000030?ooo`000000000000@0oooo00<000000?ooo`0000000P3oool00`000000
oooo00000002000000<0oooo0P0000001P3oool000000000003oool000000?ooo`80000000T0oooo
0000003oool0oooo0000003oool000000?ooo`0000000`3oool2000000030?ooo`000000oooo0080
000000<0oooo000000000000103oool010000000oooo0000003oool200000080oooo0P0000000`3o
ool000000?ooo`02000000030?ooo`000000000000@0oooo00<000000?ooo`0000000P3oool00`00
0000oooo00000002000000<0oooo0P0000001P3oool000000000003oool000000?ooo`80000000T0
oooo0000003oool0oooo0000003oool000000?ooo`0000000`3oool2000000030?ooo`000000oooo
0080000000<0oooo000000000000103oool010000000oooo0000003oool200000080oooo0P000000
0`3oool000000?ooo`02000000030?ooo`000000000000@0oooo00<000000?ooo`0000000P3oool0
0`000000oooo00000002000000<0oooo0P0000001P3oool000000000003oool000000?ooo`800000
00T0oooo0000003oool0oooo0000003oool000000?ooo`0000000`3oool2000000030?ooo`000000
oooo0080000000<0oooo000000000000103oool010000000oooo0000003oool200000080oooo0P00
00000`3oool000000?ooo`02000000030?ooo`000000000000@0oooo00<000000?ooo`0000000P3o
ool10000000000<000000?ooo`0000000P3oool01@000000oooo0?ooo`000000oooo008000000P3o
ool010000000oooo0000003oool200000080oooo0`0000030?ooo`040000003oool000000?ooo`80
00000P3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`0000000`3oool200000080
oooo0P0000000`3oool000000000000200000080oooo00H000000?ooo`3oool000000?ooo`000002
0?ooo`<000000P3oool01@000000oooo0?ooo`000000oooo008000000P3oool010000000oooo0000
003oool200000080oooo0`0000030?ooo`040000003oool000000?ooo`8000000P3oool300000003
0?ooo`000000oooo0080oooo00<000000?ooo`0000000`3oool200000080oooo0P0000000`3oool0
00000000000200000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`<000000P3oool0
1@000000oooo0?ooo`000000oooo008000000P3oool010000000oooo0000003oool200000080oooo
0`0000030?ooo`040000003oool000000?ooo`8000000P3oool3000000030?ooo`000000oooo0080
oooo00<000000?ooo`0000000`3oool200000080oooo0P0000000`3oool000000000000200000080
oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`<000000P3oool01@000000oooo0?ooo`00
0000oooo008000000P3oool010000000oooo0000003oool200000080oooo0`0000030?ooo`040000
003oool000000?ooo`8000000P3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`00
00000`3oool200000080oooo0P0000000`3oool000000000000200000080oooo00H000000?ooo`3o
ool000000?ooo`0000020?ooo`8000000@3oool10000000000@000000?ooo`3oool0oooo0P000000
0`3oool000000?ooo`02000000040?ooo`0000000000000000<0oooo0P0000001P3oool000000000
003oool000000?ooo`80000000<0oooo0000003oool00P0000000`3oool00000000000030?ooo`06
0000003oool000000?ooo`000000oooo0P0000000`3oool00000000000030?ooo`80000000H0oooo
000000000000oooo0000003oool3000000030?ooo`000000oooo0080000000<0oooo000000000000
0`3oool2000000030?ooo`000000oooo0080000000@0oooo00000000000000000`3oool200000006
0?ooo`00000000000?ooo`000000oooo0P0000000`3oool000000?ooo`02000000030?ooo`000000
000000<0oooo00H000000?ooo`000000oooo0000003oool2000000030?ooo`000000000000<0oooo
0P0000001P3oool000000000003oool000000?ooo`<0000000<0oooo0000003oool00P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000003oool00P000000103oool00000000000000003
0?ooo`80000000H0oooo000000000000oooo0000003oool2000000030?ooo`000000oooo00800000
00<0oooo0000000000000`3oool01P000000oooo0000003oool000000?ooo`80000000<0oooo0000
000000000`3oool2000000060?ooo`00000000000?ooo`000000oooo0`0000000`3oool000000?oo
o`02000000030?ooo`000000000000<0oooo0P0000000`3oool000000?ooo`02000000040?ooo`00
00000000000000<0oooo0P0000001P3oool000000000003oool000000?ooo`80000000<0oooo0000
003oool00P0000000`3oool00000000000030?ooo`060000003oool000000?ooo`000000oooo0P00
00000`3oool00000000000030?ooo`80000000H0oooo000000000000oooo0000003oool300000003
0?ooo`000000oooo0080000000<0oooo0000000000000P3oool10000000000<000000?ooo`3oool0
0P0000020?ooo`L000000P3oool300000080oooo00<000000?ooo`0000000`0000020?ooo`<00000
00<0oooo0000000000000P3oool2000000040?ooo`000000oooo0?ooo`H000000P3oool300000080
oooo00<000000?ooo`0000000P000000103oool000000?ooo`3oool3000000030?ooo`0000000000
0080oooo0`0000020?ooo`L000000P3oool300000080oooo00<000000?ooo`0000000`0000020?oo
o`<0000000<0oooo0000000000000P3oool2000000040?ooo`000000oooo0?ooo`H000000P3oool3
00000080oooo00<000000?ooo`0000000P000000103oool000000?ooo`3oool3000000030?ooo`00
000000000080oooo0`0000020?ooo`L000000P3oool300000080oooo00<000000?ooo`0000000`00
00020?ooo`<0000000<0oooo0000000000000P3oool2000000040?ooo`000000oooo0?ooo`H00000
0P3oool300000080oooo00<000000?ooo`0000000P000000103oool000000?ooo`3oool300000003
0?ooo`00000000000080oooo0`0000020?ooo`L000000P3oool300000080oooo00<000000?ooo`00
00000`0000020?ooo`<0000000<0oooo0000000000000P3oool2000000040?ooo`000000oooo0?oo
o`H000000P3oool300000080oooo00<000000?ooo`0000000P000000103oool000000?ooo`3oool3
000000030?ooo`00000000000080oooo0P00000000040000003oool0oooo0?ooo`<0000000D0oooo
000000000000oooo000000020?ooo`80000000<0oooo0000003oool00P0000000`3oool000000000
00020?ooo`<0000000<0oooo0000000000000P0000020?ooo`80000000<0oooo0000003oool00P00
00001P3oool000000000003oool000000?ooo`80000000<0oooo0000000000000P0000020?ooo`05
0000003oool0oooo0000003oool00P0000000`3oool000000?ooo`02000000030?ooo`0000000000
0080oooo0`0000001@3oool000000000003oool000000080oooo0P0000000`3oool000000?ooo`02
000000030?ooo`00000000000080oooo0`0000000`3oool000000000000200000080oooo0P000000
0`3oool000000?ooo`02000000060?ooo`00000000000?ooo`000000oooo0P0000000`3oool00000
0000000200000080oooo00D000000?ooo`3oool000000?ooo`02000000030?ooo`000000oooo0080
000000<0oooo0000000000000P3oool3000000050?ooo`00000000000?ooo`0000000P3oool20000
00030?ooo`000000oooo0080000000<0oooo0000000000000P3oool3000000030?ooo`0000000000
008000000P3oool2000000030?ooo`000000oooo0080000000H0oooo000000000000oooo0000003o
ool2000000030?ooo`0000000000008000000P3oool01@000000oooo0?ooo`000000oooo00800000
00<0oooo0000003oool00P0000000`3oool00000000000020?ooo`<0000000D0oooo000000000000
oooo000000020?ooo`80000000<0oooo0000003oool00P0000000`3oool00000000000020?ooo`<0
000000<0oooo0000000000000P0000020?ooo`80000000<0oooo0000003oool00P0000001P3oool0
00000000003oool000000?ooo`80000000<0oooo0000000000000P0000020?ooo`050000003oool0
oooo0000003oool00P0000000`3oool000000?ooo`02000000040?ooo`00000000000?ooo`400000
00000`000000oooo0?ooo`03000000030?ooo`00000000000080oooo0`0000020?ooo`030000003o
ool0000000@000000P3oool3000000050?ooo`00000000000000003oool00`0000020?ooo`<00000
0P3oool2000000030?ooo`00000000000080000000D0oooo00000000000000000?ooo`0300000080
oooo0`0000020?ooo`030000003oool0000000@000000P3oool3000000030?ooo`00000000000080
oooo0`0000020?ooo`030000003oool0000000@000000P3oool3000000050?ooo`00000000000000
003oool00`0000020?ooo`<000000P3oool2000000030?ooo`00000000000080000000D0oooo0000
0000000000000?ooo`0300000080oooo0`0000020?ooo`030000003oool0000000@000000P3oool3
000000030?ooo`00000000000080oooo0`0000020?ooo`030000003oool0000000@000000P3oool3
000000050?ooo`00000000000000003oool00`0000020?ooo`<000000P3oool2000000030?ooo`00
000000000080000000D0oooo00000000000000000?ooo`0300000080oooo0`0000020?ooo`030000
003oool0000000@000000P3oool3000000030?ooo`00000000000080oooo0`0000020?ooo`030000
003oool0000000@000000P3oool3000000050?ooo`00000000000000003oool00`0000020?ooo`<0
00000P3oool2000000030?ooo`00000000000080000000D0oooo00000000000000000?ooo`030000
0080oooo0`0000020?ooo`030000003oool0000000@000000P3oool10000000000<000000?ooo`00
00000P3oool01@000000oooo000000000000oooo0080000000<0oooo0000003oool00P0000001P3o
ool000000000003oool000000?ooo`80000000L0oooo00000000000000000?ooo`000000oooo0080
000000<0oooo0000003oool00P0000000`3oool000000?ooo`020000000:0?ooo`00000000000?oo
o`000000oooo0000003oool000000?ooo`80000000<0oooo0000003oool00P0000000`3oool00000
0?ooo`02000000060?ooo`00000000000?ooo`000000oooo0P0000020?ooo`050000003oool00000
0000003oool00P0000000`3oool000000?ooo`02000000060?ooo`00000000000?ooo`000000oooo
0P0000001`3oool00000000000000000oooo0000003oool00P0000000`3oool000000?ooo`020000
00030?ooo`000000oooo0080000000X0oooo000000000000oooo0000003oool000000?ooo`000000
oooo0P0000000`3oool000000?ooo`02000000030?ooo`000000oooo0080000000H0oooo00000000
0000oooo0000003oool200000080oooo00D000000?ooo`00000000000?ooo`02000000030?ooo`00
0000oooo0080000000H0oooo000000000000oooo0000003oool2000000070?ooo`00000000000000
003oool000000?ooo`02000000030?ooo`000000oooo0080000000<0oooo0000003oool00P000000
2P3oool000000000003oool000000?ooo`000000oooo0000003oool2000000030?ooo`000000oooo
0080000000<0oooo0000003oool00P0000001P3oool000000000003oool000000?ooo`8000000P3o
ool01@000000oooo000000000000oooo0080000000<0oooo0000003oool00P0000001P3oool00000
0000003oool000000?ooo`80000000L0oooo00000000000000000?ooo`000000oooo0080000000<0
oooo0000003oool00P0000000`3oool000000?ooo`020000000:0?ooo`00000000000?ooo`000000
oooo0000003oool000000?ooo`80000000<0oooo0000003oool00P0000000`3oool000000?ooo`02
000000080?ooo`00000000000?ooo`000000oooo0000003oool10000000000<000000?ooo`3oool0
2P0000000`3oool0000000000002000000030?ooo`000000000000h0000000<0oooo000000000000
0P0000000`3oool000000000000C000000030?ooo`000000000001<0000000<0oooo000000000000
0P0000000`3oool000000000000>000000030?ooo`00000000000080000000<0oooo000000000000
4`0000000`3oool000000000000C000000030?ooo`00000000000080000000<0oooo000000000000
3P0000000`3oool0000000000002000000030?ooo`000000000001<0000000<0oooo000000000000
4`0000000`3oool0000000000002000000030?ooo`000000000000h0000000<0oooo000000000000
0P0000000`3oool000000000000C000000030?ooo`000000000000X0000000000`000000oooo0000
0009000000030?ooo`000000oooo0080000000<0oooo0000000000003P0000000`3oool000000000
0002000000030?ooo`000000000001<0000000<0oooo0000003oool04`0000000`3oool000000?oo
o`02000000030?ooo`000000000000h0000000<0oooo0000000000000P0000000`3oool000000000
000C000000030?ooo`000000oooo01<0000000<0oooo0000003oool00P0000000`3oool000000000
000>000000030?ooo`00000000000080000000<0oooo0000000000004`0000000`3oool000000?oo
o`0C000000030?ooo`000000oooo0080000000<0oooo0000000000003P0000000`3oool000000000
0002000000030?ooo`000000000001<0000000<0oooo0000003oool02@0000010?ooo`4000000000
0`000000oooo0?ooo`3o0?oooad0oooo0@0000000?l000008@0000000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250052, \
0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["XSound", "\<\
000P0040800Z0Dl1K05l0Gl1L`5I0CH13@7R0KX1V`660H01Q`6M0Kd1i@4@0CT1
G05d0Gl1O05Z0Dd19`7l0M81[@6A0H81P@6>0JP1c07e0B01A`5V0GX1O`5g0F01
?`4G0N`1``6Q0HX1P0640IH1]@7K0@H1<05D0Fl1OP5n0G01E@4`0@L1g06e0IL1
Q0600HX1X@720N/15P4o0F01MP5o0GX1I`580B41mP7<0JP1SP610H81T@6/0M41
o04V0D`1JP5k0Gl1M05L0CX14@7V0Kh1W@680H01QP6J0KX1h@4<0CH1F@5b0Gl1
O@5/0E01:`400MH1/06C0H<1P06<0JD1b07a0A`1A05T0GT1O`5h0F<1@`4K0O01
a`6T0H/1P0630I@1/@7G0@81;05A0Fd1O@5n0G41F04d0@X1h06h0IT1Q@600HP1
WP6o0NL14P4k0Ed1M@5o0G/1J@5;0BD1nP7@0J/1T0620H41S`6Z0Lh1n04R0DT1
J05j0Gl1MP5O0Cd15@7Z0L41X0690H01Q@6H0KH1g@480C81EP5`0Gh1O@5^0E<1
;P440MX1/`6F0H@1P06:0J81a@7]0AP1@@5Q0GL1O`5i0FD1AP4O0O@1bP6W0Hd1
P@620I81[P7D0Oh1:05>0F/1O05o0G<1F`4h0@h1h`6l0I`1Q`600HL1W06l0N<1
3P4h0E/1L`5o0G`1J`5>0BP1oP7D0Jh1TP620H41S@6W0LX1m04O0DH1I@5i0Gl1
M`5Q0D41607]0LD1XP6:0H01Q06F0K<1fP440Bh1D`5^0Gd1OP5`0EH1<P480Md1
]P6H0HD1P0690J01`@7Z0AD1?@5O0GH1O`5j0FP1B@4R0OP1cP6Z0Hl1P@620I01
Z`7@0OX19@5;0FT1N`5o0GD1G@4k0A81i`6o0Ih1R0600HD1V@6h0N012P4d0EP1
L@5n0Gd1K@5A0B`10P7G0K41U0630H01R`6T0LL1l04K0D<1H`5h0Gl1N@5T0D@1
707a0LP1Y@6<0H01P`6C0K01eP400B/1D05/0Gd1O`5b0ET1=P4<0N41^P6J0HH1
P0680Id1_P7V0A41>P5L0G@1O`5k0FX1C04V0O`1d@6/0I41PP610Hh1Z07<0OH1
8@580FL1NP5o0GH1H04o0AH1j`720J41RP600H@1U`6e0M`11`4`0ED1L05n0Gh1
K`5D0C011P7K0KD1UP640H01RP6Q0L<1k04G0Cl1H05g0Gl1NP5V0DL1807e0L`1
Z06>0H41PP6A0Jd1dP7l0BL1C@5Z0G`1O`5d0E`1>@4@0ND1_@6M0HL1P0660I/1
^P7R0@d1=P5I0G<1O`5l0F`1C`4Z0Ol1e@6`0I<1P`600H`1YP790O817@550F@1
N@5o0GP1HP520AX1k`760J<1R`600H<1U@6b0MP10`4]0E81KP5m0Gh1L@5G0C<1
2P7O0KP1V@650H01R06O0L01j04C0C`1GP5e0Gl1N`5Y0DX1907i0Ll1Z`6@0H41
P@6?0JX1c`7h0B<1BP5X0G/1O`5e0Eh1?@4D0NT1`06O0HT1P0650IP1]`7N0@T1
<`5G0G41OP5m0Fh1D`4^0@<1f@6c0ID1Q0600H/1X`750Nh16@510F81M`5o0GT1
I@550Ah1l`790JH1S@600H81T`6_0M@1o`4Y0Dl1K05l0Gl1L`5J0CL13P7S0K/1
V`660H01Q`6L0K`1i04?0CP1F`5d0Gl1O05[0Dh1:07m0M<1[P6B0H81P@6>0JL1
b`7e0Al1A`5V0GX1O`5g0F41@04H0Nd1a06R0HX1P0640IH1]07J0@D1;`5D0Fl1
O@5n0G01E@4a0@L1g@6f0IL1Q@600HT1X0720NX15@4n0El1MP5o0GX1I`590B81
m`7=0JT1S`610H81T@6/0M41n`4U0D`1J@5k0Gl1M@5M0CX14P7W0Kh1WP680H01
QP6J0KT1h04;0CD1F05b0Gh1O@5]0E41:`410ML1/@6D0H<1P06<0J@1a`7a0A`1
@`5S0GP1O`5h0F<1@`4L0O41a`6T0H`1P0630I@1/@7G0@41:`5A0Fd1O@5n0G81
F04e0@/1h06i0IX1QP600HP1WP6n0NL14P4j0Ed1M@5o0G/1J@5<0BD1n`7A0J`1
T@620H41S`6Y0Ld1m`4R0DT1I`5j0Gl1MP5O0Ch15@7Z0L81X0690H01Q@6G0KH1
g@470C41E@5`0Gh1O@5_0E@1;`450MX1]06F0H@1P06:0J81a07]0AP1@05Q0GL1
O`5j0FH1A`4O0OD1b`6W0Hh1P@620I81[P7C0Od1:05>0F/1O05o0G@1F`4h0@l1
i06l0I`1Q`600HH1V`6k0N<13P4g0EX1L`5o0G`1K05?0BT1o`7D0Jl1T`620H01
S@6V0LT1l`4N0DD1I@5i0Gl1M`5R0D416@7^0LD1X`6;0H01Q06E0K<1f@430Bh1
D`5^0Gd1OP5a0EL1<`490Mh1]`6H0HD1P0690Il1`07Y0A@1?@5N0GD1O`5k0FP1
BP4S0OP1c`6Z0Hl1P@610I01Z`7?0OT1905:0FT1N`5o0GD1GP4l0A<1j0700Il1
R0600HD1V@6h0Ml12P4c0EL1L@5n0Gd1KP5B0Bd10`7H0K81U@630H01R`6S0LH1
k`4J0D81HP5h0Gl1N@5T0DD17@7b0LT1YP6<0H01P`6C0K01e@400BX1C`5/0G`1
O`5c0ET1=P4=0N81^P6K0HH1P0670Id1_@7U0A01>@5L0G@1O`5l0FX1C@4W0O`1
dP6]0I41PP610Hh1Z07<0OD180570FH1NP5o0GL1H04o0AL1k0730J41RP600H@1
UP6e0M/11P4`0E@1K`5n0Gh1L05E0C011`7L0KD1U`640H01RP6Q0L81j`4F0Cl1
H05f0Gl1NP5W0DP18@7f0L`1Z06>0H41PP6A0J`1d@7l0BH1C05Z0G/1O`5d0E`1
>P4A0NH1_P6M0HP1P0660IX1^P7Q0@`1=P5I0G81O`5m0F`1D04[0@01eP6`0I<1
P`600H`1Y@780O4170540F@1N@5o0GP1H`530A/1l0770J@1R`600H<1U06a0ML1
0P4/0E41K@5m0Gh1L@5H0C@12P7P0KP1V@650H01R06N0Kl1i`4B0C/1G@5e0Gl1
N`5Y0D/19@7j0M01Z`6@0H81P@6?0JX1cP7h0B81B@5X0GX1O`5f0El1?@4E0NX1
`@6P0HT1P0650IP1]P7M0@P1<P5F0G01OP5m0Fh1D`4^0@@1fP6c0IH1Q0600HX1
XP750Nd160510F41M`5o0GT1I@560Al1m07:0JL1S@610H81TP6^0M@1oP4X0Dh1
J`5l0Gl1L`5K0CP13P7S0K`1W0670H01Q`6L0K`1h`4>0CP1F`5c0Gl1O05[0Dh1
:07n0M@1[P6B0H81P@6=0JL1bP7d0Al1AP5U0GT1O`5g0F41@@4H0Nd1a@6R0HX1
P0640IH1/`7J0@@1;P5C0Fh1O@5n0G01EP4b0@P1g@6f0IP1Q@600HT1X0710NX1
5@4m0El1MP5o0GX1J0590B81n07>0JX1S`610H81T06[0M01nP4U0D/1J@5k0Gl1
M@5M0C/14P7W0Kl1WP680H01Q@6I0KP1h04:0C@1F05a0Gh1O@5]0E41;0420ML1
/@6D0H<1P06;0J@1a`7`0A/1@`5S0GP1O`5i0F@1A04L0O41b06U0H`1P0630I<1
/07F0@01:`5@0F`1O@5o0G81F@4f0@`1h@6j0IX1QP600HP1W@6n0NH14@4j0E`1
M05o0G/1JP5<0BH1o07A0J`1T@620H41SP6X0L`1mP4Q0DP1I`5j0Gl1MP5P0Cl1
5P7[0L81X@6:0H01Q06G0KD1g0470C01E@5`0Gh1OP5_0E@1<0460M/1]@6F0H@1
P06:0J41``7/0AL1?`5P0GL1O`5j0FH1A`4P0OD1c06X0Hh1P@620I41[@7B0O`1
9`5=0FX1O05o0G@1G04i0A01i@6m0Id1Q`600HH1V`6j0N813@4f0ET1L`5o0G`1
K05?0BX1o`7E0K01T`630H01S06V0LT1lP4M0DD1I05i0Gl1N05R0D816P7_0LH1
X`6;0H01P`6E0K81f0430Bd1DP5^0Gd1OP5a0EL1<`4:0Ml1^06I0HD1P0680Il1
`07X0A<1?05N0GD1O`5k0FT1BP4T0OT1c`6[0I01P@610Hl1ZP7?0OP18`5:0FP1
N`5o0GD1GP4m0A@1j@700Il1R@600HD1V06g0Mh12@4c0EL1L@5n0Gd1KP5C0Bh1
0`7I0K<1U@640H01R`6S0LD1kP4I0D41HP5g0Gl1N@5U0DD17P7c0LT1YP6=0H01
PP6C0Jl1e07o0BT1C`5/0G`1O`5c0EX1=`4>0N<1^`6K0HH1P0670I`1_07T0@l1
>05K0G@1O`5l0F/1CP4X0Od1d`6^0I81PP610Hh1Y`7;0OD17`570FH1NP5o0GL1
H@500AP1k@740J81RP600H@1UP6d0MX11@4_0E@1K`5m0Gh1L05E0C411`7M0KH1
U`650H01R@6P0L81jP4E0Ch1G`5f0Gl1NP5W0DT18P7g0Ld1Z@6?0H41PP6A0J`1
d@7k0BD1C05Y0G/1O`5e0Ed1>P4B0NL1_P6N0HP1P0660IX1^@7P0@/1=@5H0G81
OP5m0Fd1D@4[0@41e`6a0I@1P`600H`1Y0770O4170530F<1N05o0GP1H`530A`1
l@770J@1S0600H<1U06a0ML10@4[0E41K@5m0Gh1LP5H0CD12`7P0KT1VP660H01
R06N0Kh1i`4B0CX1G@5e0Gl1N`5Y0D`19@7k0M41[06A0H81P@6?0JT1c@7g0B81
B@5W0GX1O`5f0El1?P4E0NX1`P6P0HT1P0650IL1]P7M0@L1<@5E0G01OP5m0Fl1
E04_0@D1fP6d0IH1Q0600HX1XP740Nd160500F41M`5o0GX1IP570Al1m@7;0JL1
SP610H81TP6^0M<1o@4X0Dh1J`5l0Gl1M05K0CP13`7T0K`1W0670H01QP6K0K/1
h`4>0CL1FP5c0Gl1O05/0Dl1:@7o0M@1[`6C0H81P06=0JH1b@7c0Ah1A@5U0GT1
O`5g0F81@@4I0Nh1a@6S0H/1P0640ID1/`7I0@<1;P5C0Fh1O@5n0G41E`4c0@T1
gP6g0IP1Q@600HT1W`700NT1504m0Eh1M@5o0G/1J05:0B<1n07?0JX1S`610H41
T06[0Ll1n@4T0DX1J@5k0Gl1M@5N0C`14`7X0L01W`680H01Q@6I0KP1g`4:0C<1
E`5a0Gh1O@5^0E81;@430MP1/P6E0H<1P06;0J<1aP7_0AX1@P5R0GP1O`5i0F@1
A@4M0O81b@6V0H`1P0630I<1/07E0@01:P5?0F`1O05o0G<1F@4f0@d1hP6j0I/1
QP600HL1W@6m0ND1404i0E`1M05o0G`1JP5=0BL1o07B0Jd1T@620H41SP6X0L`1
m@4P0DL1IP5j0Gl1M`5P0Cl15`7/0L<1X@6:0H01Q06F0KD1f`460C01E05_0Gh1
OP5`0ED1<0470M`1]@6G0H@1P06:0J41`P7[0AH1?`5P0GH1O`5j0FL1B04Q0OH1
c06X0Hh1P@620I41[07A0O`19P5<0FX1N`5o0G@1G04j0A41iP6n0Id1R0600HH1
VP6j0N41304f0ET1LP5o0Gd1K05@0B/1007F0K01T`630H01S06U0LP1l@4L0D@1
I05i0Gl1N05S0D<16`7`0LL1Y06;0H01P`6D0K41e`420B`1D@5]0Gd1OP5a0EP1
=04:0N01^06I0HD1P0680Ih1_`7W0A81>`5M0GD1O`5k0FT1B`4U0OX1d06[0I01
PP610Hl1ZP7>0OP18P590FP1NP5o0GH1G`4m0AD1jP710J01R@600HD1V06f0Md1
204b0EH1L05n0Gd1KP5C0Bh1107J0K<1UP640H01RP6R0LD1k@4H0D41H@5g0Gl1
N@5U0DH17`7d0LX1Y`6=0H41PP6B0Jh1e07n0BP1CP5[0G`1O`5c0E/1>04>0N<1
_06L0HL1P0670I`1_07S0@h1>05K0G<1O`5l0F/1CP4X0Oh1e06^0I81PP610Hd1
Y`7:0O@17`560FD1N@5o0GL1H@510AP1k@750J81RP600H@1UP6c0MX1104^0E<1
KP5m0Gh1L05F0C81207M0KH1V0650H01R@6P0L41jP4E0Cd1G`5f0Gl1NP5X0DT1
8P7h0Lh1ZP6?0H41PP6@0J/1d07j0BD1B`5Y0G/1O`5e0Ed1>`4B0NL1_`6N0HP1
P0650IT1^07P0@X1=05H0G41OP5m0Fd1D@4/0@81e`6a0I@1P`600H/1Y0770O01
6`530F<1N05o0GT1I0540A`1l@780JD1S0600H<1T`6`0MH1004[0E01K05m0Gl1
LP5I0CH1307Q0KX1VP660H01R06M0Kh1iP4A0CX1G05d0Gl1N`5Z0D`19P7l0M41
[06A0H81P@6>0JP1c07f0B41B05W0GX1O`5f0F01?`4F0N/1`P6Q0HX1P0640IL1
]@7L0@L1<05E0G01OP5n0Fl1E04`0@H1f`6e0IH1Q0600HX1X@730N`15`4o0F01
M`5o0GX1IP570B01m@7<0JP1SP610H81T@6]0M81o04W0Dd1JP5l0Gl1M05L0CT1
407U0Kd1W@670H01QP6K0KX1hP4=0CH1F@5c0Gl1O05/0Dl1:P400MD1/06C0H<1
P06<0JH1b@7b0Ad1A@5T0GT1O`5h0F81@P4J0Nl1aP6S0H/1P0630ID1/P7H0@<1
;@5B0Fh1O@5n0G41E`4c0@X1g`6h0IT1Q@600HP1W`700NP14`4l0Eh1M@5o0G/1
J@5:0B@1n@7?0J/1T0610H41S`6Z0Ll1n04S0DX1J05k0Gl1M@5N0Cd1507Y0L01
W`690H01Q@6H0KL1gP490C<1E`5a0Gh1O@5^0E<1;P430MT1/`6E0H@1P06;0J<1
a@7^0AT1@@5R0GL1O`5i0FD1A@4N0O<1b@6V0Hd1P0620I<1[`7D0Ol1:@5?0F`1
O05o0G<1FP4g0@h1h`6k0I/1QP600HL1W06l0N@13`4h0E/1M05o0G`1J`5>0BP1
o@7C0Jh1TP620H41SP6W0L/1m@4O0DL1IP5j0Gl1M`5Q0D01607]0L@1XP6:0H01
Q06F0K@1fP450Bl1E05_0Gd1OP5`0ED1<@470Md1]P6G0HD1P0690J01`P7Z0AD1
?P5O0GH1O`5j0FL1B@4R0OL1c@6Y0Hl1P@620I41[07A0O/19@5<0FT1N`5o0GD1
G@4j0A81i`6n0Ih1R0600HH1VP6i0N012`4e0EP1LP5n0Gd1K@5A0B/10@7G0K41
U0630H01S06T0LL1l@4L0D<1H`5h0Gl1N05S0D<1707a0LL1Y06<0H01P`6D0K41
e`410B/1D@5]0Gd1OP5b0EP1=@4;0N01^@6J0HH1P0680Ih1_P7W0A81>P5M0GD1
O`5k0FT1C04U0O/1d@6/0I41PP610Hl1Z@7=0OL18P590FL1NP5o0GH1G`4n0AD1
jP720J01R@600HD1U`6f0Md11`4a0ED1L05n0Gd1K`5D0Bl11@7J0K@1UP640H01
RP6R0L@1k@4H0D01H@5g0Gl1NP5V0DL17`7e0L/1Y`6>0H41PP6B0Jh1d`7m0BP1
CP5[0G`1O`5d0E/1>04?0N@1_06L0HL1P0660I/1^`7S0@h1=`5J0G<1O`5l0F`1
C`4Y0Ol1e06_0I<1PP600Hd1YP790O<17P550FD1N@5o0GL1HP510AT1kP750J<1
R`600H@1U@6c0MT10`4^0E<1KP5m0Gh1L@5G0C<12@7N0KL1V0650H01R@6O0L01
j@4D0Cd1GP5e0Gl1N`5X0DX18`7h0Ll1ZP6?0H41P@6@0J/1c`7i0B@1BP5Y0G/1
O`5e0Eh1?04C0NP1`06O0HP1P0650IT1^07O0@X1<`5G0G41OP5m0Fh1DP4]0@<1
f06b0ID1P`600H/1X`760Nl16P520F81N05o0GT1I0550Ad1lP790JH1S0600H<1
T`6`0MD1004Z0Dl1K05l0Gl1L`5I0CH13@7R0KX1V`660H01Q`6M0Kd1i@4@0CT1
G05d0Gl1O05Z0Dd19`7l0M81[@6A0H81P@6>0JP1c07e0B01A`5V0GX1O`5g0F01
?`4G0N`1``6Q0HX1P0640IH1]@7K0@H1<05D0Fl1OP5n0G01E@4`0@L1g06e0IL1
Q0600HX1X@720N/15P4o0F01MP5o0GX1I`580B41mP7<0JP1SP610H81T@6/0M41
o04V0D`1JP5k0Gl1M05L0CX14@7V0Kh1W@680H01QP6J0KX1h@4<0CH1F@5b0Gl1
O@5/0E01:`400MH1/06C0H<1P06<0JD1b07a0A`1A05T0GT1O`5h0F<1@`4K0O01
a`6T0H/1P0630I@1/@7G0@81;05A0Fd1O@5n0G41F04d0@X1h06h0IT1Q@600HP1
WP6o0NL14P4k0Ed1M@5o0G/1J@5;0BD1nP7@0J/1T0620H41S`6Z0Lh1n04R0DT1
J05j0Gl1MP5O0Cd15@7Z0L41X0690H01Q@6H0KH1g@480C81EP5`0Gh1O@5^0E<1
;P440MX1/`6F0H@1P06:0J81a@7]0AP1@@5Q0GL1O`5i0FD1AP4O0O@1bP6W0Hd1
P@620I81[P7D0Oh1:05>0F/1O05o0G<1F`4h0@h1h`6l0I`1Q`600HL1W06l0N<1
3P4h0E/1L`5o0G`1J`5>0BP1oP7D0Jh1TP620H41S@6W0LX1m04O0DH1I@5i0Gl1
M`5Q0D41607]0LD1XP6:0H01Q06F0K<1fP440Bh1D`5^0Gd1OP5`0EH1<P480Md1
]P6H0HD1P0690J01`@7Z0AD1?@5O0GH1O`5j0FP1B@4R0OP1cP6Z0Hl1P@620I01
Z`7@0OX19@5;0FT1N`5o0GD1G@4k0A81i`6o0Ih1R0600HD1V@6h0N012P4d0EP1
L@5n0Gd1K@5A0B`10P7G0K41U0630H01R`6T0LL1l04K0D<1H`5h0Gl1N@5T0D@1
707a0LP1Y@6<0H01P`6C0K01eP400B/1D05/0Gd1O`5b0ET1=P4<0N41^P6J0HH1
P0680Id1_P7V0A41>P5L0G@1O`5k0FX1C04V0O`1d@6/0I41PP610Hh1Z07<0OH1
8@580FL1NP5o0GH1H04o0AH1j`720J41RP600H@1U`6e0M`11`4`0ED1L05n0Gh1
K`5D0C011P7K0KD1UP640H01RP6Q0L<1k04G0Cl1H05g0Gl1NP5V0DL1807e0L`1
Z06>0H41PP6A0Jd1dP7l0BL1C@5Z0G`1O`5d0E`1>@4@0ND1_@6M0HL1P0660I/1
^P7R0@d1=P5I0G<1O`5l0F`1C`4Z0Ol1e@6`0I<1P`600H`1YP790O817@550F@1
N@5o0GP1HP520AX1k`760J<1R`600H<1U@6b0MP10`4]0E81KP5m0Gh1L@5G0C<1
2P7O0KP1V@650H01R06O0L01j04C0C`1GP5e0Gl1N`5Y0DX1907i0Ll1Z`6@0H41
P@6?0JX1c`7h0B<1BP5X0G/1O`5e0Eh1?@4D0NT1`06O0HT1P0650IP1]`7N0@T1
<`5G0G41OP5m0Fh1D`4^0@<1f@6c0ID1Q0600H/1X`750Nh16@510F81M`5o0GT1
I@550Ah1l`790JH1S@600H81T`6_0M@1o`4Y0Dl1K05l0Gl1L`5J0CL13P7S0K/1
V`660H01Q`6L0K`1i04?0CP1F`5d0Gl1O05[0Dh1:07m0M<1[P6B0H81P@6>0JL1
b`7e0Al1A`5V0GX1O`5g0F41@04H0Nd1a06R0HX1P0640IH1]07J0@D1;`5D0Fl1
O@5n0G01E@4a0@L1g@6f0IL1Q@600HT1X0720NX15@4n0El1MP5o0GX1I`590B81
m`7=0JT1S`610H81T@6/0M41n`4U0D`1J@5k0Gl1M@5M0CX14P7W0Kh1WP680H01
QP6J0KT1h04;0CD1F05b0Gh1O@5]0E41:`410ML1/@6D0H<1P06<0J@1a`7a0A`1
@`5S0GP1O`5h0F<1@`4L0O41a`6T0H`1P0630I@1/@7G0@41:`5A0Fd1O@5n0G81
F04e0@/1h06i0IX1QP600HP1WP6n0NL14P4j0Ed1M@5o0G/1J@5<0BD1n`7A0J`1
T@620H41S`6Y0Ld1m`4R0DT1I`5j0Gl1MP5O0Ch15@7Z0L81X0690H01Q@6G0KH1
g@470C41E@5`0Gh1O@5_0E@1;`450MX1]06F0H@1P06:0J81a07]0AP1@05Q0GL1
O`5j0FH1A`4O0OD1b`6W0Hh1P@620I81[P7C0Od1:05>0F/1O05o0G@1F`4h0@l1
i06l0I`1Q`600HH1V`6k0N<13P4g0EX1L`5o0G`1K05?0BT1o`7D0Jl1T`620H01
S@6V0LT1l`4N0DD1I@5i0Gl1M`5R0D416@7^0LD1X`6;0H01Q06E0K<1f@430Bh1
D`5^0Gd1OP5a0EL1<`490Mh1]`6H0HD1P0690Il1`07Y0A@1?@5N0GD1O`5k0FP1
BP4S0OP1c`6Z0Hl1P@610I01Z`7?0OT1905:0FT1N`5o0GD1GP4l0A<1j0700Il1
R0600HD1V@6h0Ml12P4c0EL1L@5n0Gd1KP5B0Bd10`7H0K81U@630H01R`6S0LH1
k`4J0D81HP5h0Gl1N@5T0DD17@7b0LT1YP6<0H01P`6C0K01e@400BX1C`5/0G`1
O`5c0ET1=P4=0N81^P6K0HH1P0670Id1_@7U0A01>@5L0G@1O`5l0FX1C@4W0O`1
dP6]0I41PP610Hh1Z07<0OD180570FH1NP5o0GL1H04o0AL1k0730J41RP600H@1
UP6e0M/11P4`0E@1K`5n0Gh1L05E0C011`7L0KD1U`640H01RP6Q0L81j`4F0Cl1
H05f0Gl1NP5W0DP18@7f0L`1Z06>0H41PP6A0J`1d@7l0BH1C05Z0G/1O`5d0E`1
>P4A0NH1_P6M0HP1P0660IX1^P7Q0@`1=P5I0G81O`5m0F`1D04[0@01eP6`0I<1
P`600H`1Y@780O4170540F@1N@5o0GP1H`530A/1l0770J@1R`600H<1U06a0ML1
0P4/0E41K@5m0Gh1L@5H0C@12P7P0KP1V@650H01R06N0Kl1i`4B0C/1G@5e0Gl1
N`5Y0D/19@7j0M01Z`6@0H81P@6?0JX1cP7h0B81B@5X0GX1O`5f0El1?@4E0NX1
`@6P0HT1P0650IP1]P7M0@P1<P5F0G01OP5m0Fh1D`4^0@@1fP6c0IH1Q0600HX1
XP750Nd160510F41M`5o0GT1I@560Al1m07:0JL1S@610H81TP6^0M@1oP4X0Dh1
J`5l0Gl1L`5K0CP13P7S0K`1W0670H01Q`6L0K`1h`4>0CP1F`5c0Gl1O05[0Dh1
:07n0M@1[P6B0H81P@6=0JL1bP7d0Al1AP5U0GT1O`5g0F41@@4H0Nd1a@6R0HX1
P0640IH1/`7J0@@1;P5C0Fh1O@5n0G01EP4b0@P1g@6f0IP1Q@600HT1X0710NX1
5@4m0El1MP5o0GX1J0590B81n07>0JX1S`610H81T06[0M01nP4U0D/1J@5k0Gl1
M@5M0C/14P7W0Kl1WP680H01Q@6I0KP1h04:0C@1F05a0Gh1O@5]0E41;0420ML1
/@6D0H<1P06;0J@1a`7`0A/1@`5S0GP1O`5i0F@1A04L0O41b06U0H`1P0630I<1
/07F0@01:`5@0F`1O@5o0G81F@4f0@`1h@6j0IX1QP600HP1W@6n0NH14@4j0E`1
M05o0G/1JP5<0BH1o07A0J`1T@620H41SP6X0L`1mP4Q0DP1I`5j0Gl1MP5P0Cl1
5P7[0L81X@6:0H01Q06G0KD1g0470C01E@5`0Gh1OP5_0E@1<0460M/1]@6F0H@1
P06:0J41``7/0AL1?`5P0GL1O`5j0FH1A`4P0OD1c06X0Hh1P@620I41[@7B0O`1
9`5=0FX1O05o0G@1G04i0A01i@6m0Id1Q`600HH1V`6j0N813@4f0ET1L`5o0G`1
K05?0BX1o`7E0K01T`630H01S06V0LT1lP4M0DD1I05i0Gl1N05R0D816P7_0LH1
X`6;0H01P`6E0K81f0430Bd1DP5^0Gd1OP5a0EL1<`4:0Ml1^06I0HD1P0680Il1
`07X0A<1?05N0GD1O`5k0FT1BP4T0OT1c`6[0I01P@610Hl1ZP7?0OP18`5:0FP1
N`5o0GD1GP4m0A@1j@700Il1R@600HD1V06g0Mh12@4c0EL1L@5n0Gd1KP5C0Bh1
0`7I0K<1U@640H01R`6S0LD1kP4I0D41HP5g0Gl1N@5U0DD17P7c0LT1YP6=0H01
PP6C0Jl1e07o0BT1C`5/0G`1O`5c0EX1=`4>0N<1^`6K0HH1P0670I`1_07T0@l1
>05K0G@1O`5l0F/1CP4X0Od1d`6^0I81PP610Hh1Y`7;0OD17`570FH1NP5o0GL1
H@500AP1k@740J81RP600H@1UP6d0MX11@4_0E@1K`5m0Gh1L05E0C411`7M0KH1
U`650H01R@6P0L81jP4E0Ch1G`5f0Gl1NP5W0DT18P7g0Ld1Z@6?0H41PP6A0J`1
d@7k0BD1C05Y0G/1O`5e0Ed1>P4B0NL1_P6N0HP1P0660IX1^@7P0@/1=@5H0G81
OP5m0Fd1D@4[0@41e`6a0I@1P`600H`1Y0770O4170530F<1N05o0GP1H`530A`1
l@770J@1S0600H<1U06a0ML10@4[0E41K@5m0Gh1LP5H0CD12`7P0KT1VP660H01
R06N0Kh1i`4B0CX1G@5e0Gl1N`5Y0D`19@7k0M41[06A0H81P@6?0JT1c@7g0B81
B@5W0GX1O`5f0El1?P4E0NX1`P6P0HT1P0650IL1]P7M0@L1<@5E0G01OP5m0Fl1
E04_0@D1fP6d0IH1Q0600HX1XP740Nd160500F41M`5o0GX1IP570Al1m@7;0JL1
SP610H81TP6^0M<1o@4X0Dh1J`5l0Gl1M05K0CP13`7T0K`1W0670H01QP6K0K/1
h`4>0CL1FP5c0Gl1O05/0Dl1:@7o0M@1[`6C0H81P06=0JH1b@7c0Ah1A@5U0GT1
O`5g0F81@@4I0Nh1a@6S0H/1P0640ID1/`7I0@<1;P5C0Fh1O@5n0G41E`4c0@T1
gP6g0IP1Q@600HT1W`700NT1504m0Eh1M@5o0G/1J05:0B<1n07?0JX1S`610H41
T06[0Ll1n@4T0DX1J@5k0Gl1M@5N0C`14`7X0L01W`680H01Q@6I0KP1g`4:0C<1
E`5a0Gh1O@5^0E81;@430MP1/P6E0H<1P06;0J<1aP7_0AX1@P5R0GP1O`5i0F@1
A@4M0O81b@6V0H`1P0630I<1/07E0Ol1:P5?0F`1O05o0G<1F@4f0@d1hP6j0I/1
QP600HL1W@6m0ND1404i0E`1M05o0G`1JP5=0BL1o07B0Jd1T@620H41SP6X0L`1
m@4P0DL1IP5j0Gl1M`5P0Cl15`7/0L<1X@6:0H01Q06F0KD1f`460C01E05_0Gh1
OP5`0ED1<0470M`1]@6G0H@1P06:0J41`P7[0AH1?`5P0GH1O`5j0FL1B04Q0OH1
c06X0Hh1P@620I41[07A0O`19P5<0FX1N`5o0G@1G04j0A41iP6n0Id1R0600HH1
VP6j0N41304f0ET1LP5o0Gd1K05@0B/1007F0K01T`630H01S06U0LP1l@4L0D@1
I05i0Gl1N05S0D<16`7`0LL1Y06;0H01P`6D0K41e`420B`1D@5]0Gd1OP5a0EP1
=04:0N01^06I0HD1P0680Ih1_`7W0A81>`5M0GD1O`5k0FT1B`4U0OX1d06[0I01
PP610Hl1ZP7>0OP18P590FP1NP5o0GH1G`4m0AD1jP710J01R@600HD1V06f0Md1
204b0EH1L05n0Gd1KP5C0Bh1107J0K<1UP640H01RP6R0LD1k@4H0D41H@5g0Gl1
N@5U0DH17`7d0LX1Y`6=0H41PP6B0Jh1e07n0BP1CP5[0G`1O`5c0E/1>04>0N<1
_06L0HL1P0670I`1_07S0@h1>05K0G<1O`5l0F/1CP4X0Oh1e06^0I81PP610Hd1
Y`7:0O@17`560FD1N@5o0GL1H@510AP1k@750J81RP600H@1UP6c0MX1104^0E<1
KP5m0Gh1L05F0C81207M0KH1V0650H01R@6P0L41jP4E0Cd1G`5f0Gl1NP5X0DT1
8P7h0Lh1ZP6?0H41PP6@0J/1d07j0BD1B`5Y0G/1O`5e0Ed1>`4B0NL1_`6N0HP1
P0650IT1^07P0@X1=05H0G41OP5m0Fd1D@4/0@81e`6a0I@1P`600H/1Y0770O01
6`530F<1N05o0GT1I0540A`1l@780JD1S0600H<1T`6`0MH1004[0E01K05m0Gl1
LP5I0CH1307Q0KX1VP660H01R06M0Kh1iP4A0CX1G05d0Gl1N`5Z0D`19P7l0M41
[06A0H81P@6>0JP1c07f0B41B05W0GX1O`5f0F01?`4F0N/1`P6Q0HX1P0640IL1
]@7L0@L1<05E0G01OP5n0Fl1E04`0@H1f`6e0IH1Q0600HX1X@730N`15`4o0F01
M`5o0GX1IP570B01m@7<0JP1SP610H81T@6]0M81o04W0Dd1JP5l0Gl1M05L0CT1
407U0Kd1W@670H01QP6K0KX1hP4=0CH1F@5c0Gl1O05/0Dl1:P400MD1/06C0H<1
P06<0JH1b@7b0Ad1A@5T0GT1O`5h0F81@P4J0Nl1aP6S0H/1P0630ID1/P7H0@<1
;@5B0Fh1O@5n0G41E`4c0@X1g`6h0IT1Q@600HP1W`700NP14`4l0Eh1M@5o0G/1
J@5:0B@1n@7?0J/1T0610H41S`6Z0Ll1n04S0DX1J05k0Gl1M@5N0Cd1507Y0L01
W`690H01Q@6H0KL1gP490C<1E`5a0Gh1O@5^0E<1;P430MT1/`6E0H@1P06;0J<1
a@7^0AT1@@5R0GL1O`5i0FD1A@4N0O<1b@6V0Hd1P0620I<1[`7D0Ol1:@5?0F`1
O05o0G<1FP4g0@h1h`6k0I/1QP600HL1W06l0N@13`4h0E/1M05o0G`1J`5>0BP1
o@7C0Jh1TP620H41SP6W0L/1m@4O0DL1IP5j0Gl1M`5Q0D01607]0L@1XP6:0H01
Q06F0K@1fP450Bl1E05_0Gd1OP5`0ED1<@470Md1]P6G0HD1P0690J01`P7Z0AD1
?P5O0GH1O`5j0FL1B@4R0OL1c@6Y0Hl1P@620I41[07A0O/19@5<0FT1N`5o0GD1
G@4j0A81i`6n0Ih1R0600HH1VP6i0N012`4e0EP1LP5n0Gd1K@5A0B/10@7G0K41
U0630H01S06T0LL1l@4L0D<1H`5h0Gl1N05S0D<1707a0LL1Y06<0H01P`6D0K41
e`410B/1D@5]0Gd1OP5b0EP1=@4;0N01^@6J0HH1P0680Ih1_P7W0A81>P5M0GD1
O`5k0FT1C04U0O/1d@6/0I41PP610Hl1Z@7=0OL18P590FL1NP5o0GH1G`4n0AD1
jP720J01R@600HD1U`6f0Md11`4a0ED1L05n0Gd1K`5D0Bl11@7J0K@1UP640H01
RP6R0L@1k@4H0D01H@5g0Gl1NP5V0DL17`7e0L/1Y`6>0H41PP6B0Jh1d`7m0BP1
CP5[0G`1O`5d0E/1>04?0N@1_06L0HL1P0660I/1^`7S0@h1=`5J0G<1O`5l0F`1
C`4Y0Ol1e06_0I<1PP600Hd1YP790O<17P550FD1N@5o0GL1HP510AT1kP750J<1
R`600H@1U@6c0MT10`4^0E<1KP5m0Gh1L@5G0C<12@7N0KL1V0650H01R@6O0L01
j@4D0Cd1GP5e0Gl1N`5X0DX18`7h0Ll1ZP6?0H41P@6@0J/1c`7i0B@1BP5Y0G/1
O`5e0Eh1?04C0NP1`06O0HP1P0650IT1^07O0@X1<`5G0G41OP5m0Fh1DP4]0@<1
f06b0ID1P`600H/1X`760Nl16P520F81N05o0GT1I0550Ad1lP790JH1S0600H<1
T`6`0MD1004Z0Dl1K05l0Gl1L`5I0CH13@7R0KX1V`660H01Q`6M0Kd1i@4@0CT1
G05d0Gl1O05Z0Dd19`7l0M81[@6A0H81P@6>0JP1c07e0B01A`5V0GX1O`5g0F01
?`4G0N`1``6Q0HX1P0640IH1]@7K0@H1<05D0Fl1OP5n0G01E@4`0@L1g06e0IL1
Q0600HX1X@720N/15P4o0F01MP5o0GX1I`580B41mP7<0JP1SP610H81T@6/0M41
o04V0D`1JP5k0Gl1M05L0CX14@7V0Kh1W@680H01QP6J0KX1h@4<0CH1F@5b0Gl1
O@5/0E01:`400MH1/06C0H<1P06<0JD1b07a0A`1A05T0GT1O`5h0F<1@`4K0O01
a`6T0H/1P0630I@1/@7G0@81;05A0Fd1O@5n0G41F04d0@X1h06h0IT1Q@600HP1
WP6o0NL14P4k0Ed1M@5o0G/1J@5;0BD1nP7@0J/1T0620H41S`6Z0Lh1n04R0DT1
J05j0Gl1MP5O0Cd15@7Z0L41X0690H01Q@6H0KH1g@480C81EP5`0Gh1O@5^0E<1
;P440MX1/`6F0H@1P06:0J81a@7]0AP1@@5Q0GL1O`5i0FD1AP4O0O@1bP6W0Hd1
P@620I81[P7D0Oh1:05>0F/1O05o0G<1F`4h0@h1h`6l0I`1Q`600HL1W06l0N<1
3P4h0E/1L`5o0G`1J`5>0BP1oP7D0Jh1TP620H41S@6W0LX1m04O0DH1I@5i0Gl1
M`5Q0D41607]0LD1XP6:0H01Q06F0K<1fP440Bh1D`5^0Gd1OP5`0EH1<P480Md1
]P6H0HD1P0690J01`@7Z0AD1?@5O0GH1O`5j0FP1B@4R0OP1cP6Z0Hl1P@620I01
Z`7@0OX19@5;0FT1N`5o0GD1G@4k0A81i`6o0Ih1R0600HD1V@6h0N012P4d0EP1
L@5n0Gd1K@5A0B`10P7G0K41U0630H01R`6T0LL1l04K0D<1H`5h0Gl1N@5T0D@1
707a0LP1Y@6<0H01P`6C0K01eP400B/1D05/0Gd1O`5b0ET1=P4<0N41^P6J0HH1
P0680Id1_P7V0A41>P5L0G@1O`5k0FX1C04V0O`1d@6/0I41PP610Hh1Z07<0OH1
8@580FL1NP5o0GH1H04o0AH1j`720J41RP600H@1U`6e0M`11`4`0ED1L05n0Gh1
K`5D0C011P7K0KD1UP640H01RP6Q0L<1k04G0Cl1H05g0Gl1NP5V0DL1807e0L`1
Z06>0H41PP6A0Jd1dP7l0BL1C@5Z0G`1O`5d0E`1>@4@0ND1_@6M0HL1P0660I/1
^P7R0@d1=P5I0G<1O`5l0F`1C`4Z0Ol1e@6`0I<1P`600H`1YP790O817@550F@1
N@5o0GP1HP520AX1k`760J<1R`600H<1U@6b0MP10`4]0E81KP5m0Gh1L@5G0C<1
2P7O0KP1V@650H01R06O0L01j04C0C`1GP5e0Gl1N`5Y0DX1907i0Ll1Z`6@0H41
P@6?0JX1c`7h0B<1BP5X0G/1O`5e0Eh1?@4D0NT1`06O0HT1P0650IP1]`7N0@T1
<`5G0G41OP5m0Fh1D`4^0@<1f@6c0ID1Q0600H/1X`750Nh16@510F81M`5o0GT1
I@550Ah1l`790JH1S@600H81T`6_0M@1o`4Y0Dl1K05l0Gl1L`5J0CL13P7S0K/1
V`660H01Q`6L0K`1i04?0CP1F`5d0Gl1O05[0Dh1:07m0M<1[P6B0H81P@6>0JL1
b`7e0Al1A`5V0GX1O`5g0F41@04H0Nd1a06R0HX1P0640IH1]07J0@D1;`5D0Fl1
O@5n0G01E@4a0@L1g@6f0IL1Q@600HT1X0720NX15@4n0El1MP5o0GX1I`590B81
m`7=0JT1S`610H81T@6/0M41n`4U0D`1J@5k0Gl1M@5M0CX14P7W0Kh1WP680H01
QP6J0KT1h04;0CD1F05b0Gh1O@5]0E41:`410ML1/@6D0H<1P06<0J@1a`7a0A`1
@`5S0GP1O`5h0F<1@`4L0O41a`6T0H`1P0630I@1/@7G0@41:`5A0Fd1O@5n0G81
F04e0@/1h06i0IX1QP600HP1WP6n0NL14P4j0Ed1M@5o0G/1J@5<0BD1n`7A0J`1
T@620H41S`6Y0Ld1m`4R0DT1I`5j0Gl1MP5O0Ch15@7Z0L81X0690H01Q@6G0KH1
g@470C41E@5`0Gh1O@5_0E@1;`450MX1]06F0H@1P06:0J81a07]0AP1@05Q0GL1
O`5j0FH1A`4O0OD1b`6W0Hh1P@620I81[P7C0Od1:05>0F/1O05o0G@1F`4h0@l1
i06l0I`1Q`600HH1V`6k0N<13P4g0EX1L`5o0G`1K05?0BT1o`7D0Jl1T`620H01
S@6V0LT1l`4N0DD1I@5i0Gl1M`5R0D416@7^0LD1X`6;0H01Q06E0K<1f@430Bh1
D`5^0Gd1OP5a0EL1<`490Mh1]`6H0HD1P0690Il1`07Y0A@1?@5N0GD1O`5k0FP1
BP4S0OP1c`6Z0Hl1P@610I01Z`7?0OT1905:0FT1N`5o0GD1GP4l0A<1j0700Il1
R0600HD1V@6h0Ml12P4c0EL1L@5n0Gd1KP5B0Bd10`7H0K81U@630H01R`6S0LH1
k`4J0D81HP5h0Gl1N@5T0DD17@7b0LT1YP6<0H01P`6C0K01e@400BX1C`5/0G`1
O`5c0ET1=P4=0N81^P6K0HH1P0670Id1_@7U0A01>@5L0G@1O`5l0FX1C@4W0O`1
dP6]0I41PP610Hh1Z07<0OD180570FH1NP5o0GL1H04o0AL1k0730J41RP600H@1
UP6e0M/11P4`0E@1K`5n0Gh1L05E0C011`7L0KD1U`640H01RP6Q0L81j`4F0Cl1
H05f0Gl1NP5W0DP18@7f0L`1Z06>0H41PP6A0J`1d@7l0BH1C05Z0G/1O`5d0E`1
>P4A0NH1_P6M0HP1P0660IX1^P7Q0@`1=P5I0G81O`5m0F`1D04[0@01eP6`0I<1
P`600H`1Y@780O4170540F@1N@5o0GP1H`530A/1l0770J@1R`600H<1U06a0ML1
0P4/0E41K@5m0Gh1L@5H0C@12P7P0KP1V@650H01R06N0Kl1i`4B0C/1G@5e0Gl1
N`5Y0D/19@7j0M01Z`6@0H81P@6?0JX1cP7h0B81B@5X0GX1O`5f0El1?@4E0NX1
`@6P0HT1P0650IP1]P7M0@P1<P5F0G01OP5m0Fh1D`4^0@@1fP6c0IH1Q0600HX1
XP750Nd160510F41M`5o0GT1I@560Al1m07:0JL1S@610H81TP6^0M@1oP4X0Dh1
J`5l0Gl1L`5K0CP13P7S0K`1W0670H01Q`6L0K`1h`4>0CP1F`5c0Gl1O05[0Dh1
:07n0M@1[P6B0H81P@6=0JL1bP7d0Al1AP5U0GT1O`5g0F41@@4H0Nd1a@6R0HX1
P0640IH1/`7J0@@1;P5C0Fh1O@5n0G01EP4b0@P1g@6f0IP1Q@600HT1X0710NX1
5@4m0El1MP5o0GX1J0590B81n07>0JX1S`610H81T06[0M01nP4U0D/1J@5k0Gl1
M@5M0C/14P7W0Kl1WP680H01Q@6I0KP1h04:0C@1F05a0Gh1O@5]0E41;0420ML1
/@6D0H<1P06;0J@1a`7`0A/1@`5S0GP1O`5i0F@1A04L0O41b06U0H`1P0630I<1
/07F0@01:`5@0F`1O@5o0G81F@4f0@`1h@6j0IX1QP600HP1W@6n0NH14@4j0E`1
M05o0G/1JP5<0BH1o07A0J`1T@620H41SP6X0L`1mP4Q0DP1I`5j0Gl1MP5P0Cl1
5P7[0L81X@6:0H01Q06G0KD1g0470C01E@5`0Gh1OP5_0E@1<0460M/1]@6F0H@1
P06:0J41``7/0AL1?`5P0GL1O`5j0FH1A`4P0OD1c06X0Hh1P@620I41[@7B0O`1
9`5=0FX1O05o0G@1G04i0A01i@6m0Id1Q`600HH1V`6j0N813@4f0ET1L`5o0G`1
K05?0BX1o`7E0K01T`630H01S06V0LT1lP4M0DD1I05i0Gl1N05R0D816P7_0LH1
X`6;0H01P`6E0K81f0430Bd1DP5^0Gd1OP5a0EL1<`4:0Ml1^06I0HD1P0680Il1
`07X0A<1?05N0GD1O`5k0FT1BP4T0OT1c`6[0I01P@610Hl1ZP7?0OP18`5:0FP1
N`5o0GD1GP4m0A@1j@700Il1R@600HD1V06g0Mh12@4c0EL1L@5n0Gd1KP5C0Bh1
0`7I0K<1U@640H01R`6S0LD1kP4I0D41HP5g0Gl1N@5U0DD17P7c0LT1YP6=0H01
PP6C0Jl1e07o0BT1C`5/0G`1O`5c0EX1=`4>0N<1^`6K0HH1P0670I`1_07T0@l1
>05K0G@1O`5l0F/1CP4X0Od1d`6^0I81PP610Hh1Y`7;0OD17`570FH1NP5o0GL1
H@500AP1k@740J81RP600H@1UP6d0MX11@4_0E@1K`5m0Gh1L05E0C411`7M0KH1
U`650H01R@6P0L81jP4E0Ch1G`5f0Gl1NP5W0DT18P7g0Ld1Z@6?0H41PP6A0J`1
d@7k0BD1C05Y0G/1O`5e0Ed1>P4B0NL1_P6N0HP1P0660IX1^@7P0@/1=@5H0G81
OP5m0Fd1D@4[0@41e`6a0I@1P`600H`1Y0770O4170530F<1N05o0GP1H`530A`1
l@770J@1S0600H<1U06a0ML10@4[0E41K@5m0Gh1LP5H0CD12`7P0KT1VP660H01
R06N0Kh1i`4B0CX1G@5e0Gl1N`5Y0D`19@7k0M41[06A0H81P@6?0JT1c@7g0B81
B@5W0GX1O`5f0El1?P4E0NX1`P6P0HT1P0650IL1]P7M0@L1<@5E0G01OP5m0Fl1
E04_0@D1fP6d0IH1Q0600HX1XP740Nd160500F41M`5o0GX1IP570Al1m@7;0JL1
SP610H81TP6^0M<1o@4X0Dh1J`5l0Gl1M05K0CP13`7T0K`1W0670H01QP6K0K/1
h`4>0CL1FP5c0Gl1O05/0Dl1:@7o0M@1[`6C0H81P06=0JH1b@7c0Ah1A@5U0GT1
O`5g0F81@@4I0Nh1a@6S0H/1P0640ID1/`7I0@<1;P5C0Fh1O@5n0G41E`4c0@T1
gP6g0IP1Q@600HT1W`700NT1504m0Eh1M@5o0G/1J05:0B<1n07?0JX1S`610H41
T06[0Ll1n@4T0DX1J@5k0Gl1M@5N0C`14`7X0L01W`680H01Q@6I0KP1g`4:0C<1
E`5a0Gh1O@5^0E81;@430MP1/P6E0H<1P06;0J<1aP7_0AX1@P5R0GP1O`5i0F@1
A@4M0O81b@6V0H`1P0630I<1/07E0@01\>"]},
  ImageCacheContents->"Sound"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Play[Sin[\ 2\ \[Pi]\ 444\ t], {t, 0, 1}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
8192 8192 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound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pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`00000Q
0000000000<000000?ooo`3oool0o`00000N0000000000<000000?ooo`000000o`00000N00000000
00<000000?ooo`000000o`00000N0000000000<000000?ooo`000000o`00000N0000000000<00000
0?ooo`0000008`0000000`3oool0000000000014000000030?ooo`000000000004@0000000<0oooo
000000000000A00000000`3oool000000000000R0000000000<000000?ooo`000000=P0000000`3o
ool0000000000014000000030?ooo`000000000004@0000000<0oooo000000000000A00000000`3o
ool000000000000?0000000000<000000?ooo`0000004`0000000`3oool000000000000:00000003
0?ooo`000000000003L0000000<0oooo0000000000002P0000000`3oool000000000000g00000003
0?ooo`000000000000X0000000<0oooo000000000000=`0000000`3oool000000000000:00000003
0?ooo`000000000002D0000000000`000000oooo0000000;000000030?ooo`000000000000X00000
00<0oooo000000000000100000000`3oool000000000000`000000030?ooo`000000000000X00000
00<0oooo000000000000100000000`3oool000000000000`000000030?ooo`000000000000X00000
00<0oooo000000000000100000000`3oool000000000000`000000030?ooo`000000000000X00000
00<0oooo000000000000100000000`3oool000000000000V0000000000<000000?ooo`0000005`00
00000`3oool0000000000014000000030?ooo`000000000004@0000000<0oooo000000000000A000
00000`3oool000000000000^0000000000<000000?ooo`000000200000000`3oool0000000000004
000000030?ooo`00000000000300000000<0oooo0000000000002P0000000`3oool0000000000004
000000030?ooo`00000000000300000000<0oooo0000000000002P0000000`3oool0000000000004
000000030?ooo`00000000000300000000<0oooo0000000000002P0000000`3oool0000000000004
000000030?ooo`00000000000300000000<0oooo0000000000000`00000000040000003oool00000
0?ooocT0000000<0oooo0000000000002P0000000`3oool000000000000g000000030?ooo`000000
000000X0000000<0oooo000000000000=`0000000`3oool000000000000:000000030?ooo`000000
000003L0000000<0oooo0000000000002@0000010?ooo`40000000000`000000oooo0?ooo`0i0000
00030?ooo`000000000000<0000000<0oooo000000000000?P0000000`3oool00000000000030000
00030?ooo`000000000003h0000000<0oooo0000000000000`0000000`3oool000000000000n0000
00030?ooo`000000000000<0000000<0oooo0000000000001P00000000030000003oool000000?l0
00007P00000000030000003oool000000?l000007P00000000030000003oool000000?l000007P00
000000030000003oool000000?l000007P00000000030000003oool000000?l000007P0000000003
0000003oool000000?l000007P00000000030000003oool0oooo0?l0oooo6`3oool100000040oooo
0@00000000030000003oool0oooo0?l0oooo7@3oool100000000o`00000Q0000000000<000000?oo
o`3oool0o`00000N0000000000<000000?ooo`000000o`00000N0000000000<000000?ooo`3oool0
1P0000001@3oool00000000000000000oooo0080000000<0oooo0000000000000`0000000`3oool0
0000000000020?ooo`80000000@0oooo000000000000oooo0P0000000`3oool00000000000020?oo
o`80000000D0oooo00000000000000000?ooo`06000000030?ooo`000000000000<0000000@0oooo
000000000000oooo0`0000000`3oool0000000000002000000030?ooo`000000oooo00H0000000D0
oooo00000000000000000?ooo`02000000030?ooo`000000000000<0000000<0oooo000000000000
0P3oool2000000040?ooo`00000000000?ooo`80000000<0oooo0000000000000P3oool200000005
0?ooo`00000000000000003oool01P0000000`3oool0000000000003000000040?ooo`0000000000
0?ooo`<0000000<0oooo0000000000000P0000000`3oool000000?ooo`06000000050?ooo`000000
00000000003oool00P0000000`3oool0000000000003000000030?ooo`00000000000080oooo0P00
0000103oool000000000003oool2000000030?ooo`00000000000080oooo0P0000001@3oool00000
000000000000oooo00H0000000<0oooo0000000000000`000000103oool000000000003oool30000
00030?ooo`00000000000080000000<0oooo0000003oool01P0000001@3oool00000000000000000
oooo0080000000<0oooo0000000000000`0000000`3oool00000000000020?ooo`80000000@0oooo
000000000000oooo0P0000000`3oool00000000000020?ooo`80000000D0oooo0000000000000000
0?ooo`06000000030?ooo`000000000000<0000000@0oooo000000000000oooo0`0000000`3oool0
000000000002000000030?ooo`000000oooo0040000000000`000000oooo0?ooo`02000000040?oo
o`000000oooo0?ooo`80000000D0oooo00000000000000000?ooo`02000000030?ooo`000000oooo
008000000P3oool3000000060?ooo`000000oooo0?ooo`000000oooo0P0000020?ooo`D000000P3o
ool00`000000oooo000000020?ooo`030000003oool0000000<0000000<0oooo0000003oool01000
0000103oool000000?ooo`3oool2000000040?ooo`00000000000?ooo`<0000000@0oooo0000003o
ool0oooo0P0000001@3oool00000000000000000oooo0080000000<0oooo0000003oool00P000002
0?ooo`<0000000H0oooo0000003oool0oooo0000003oool200000080oooo1@0000020?ooo`030000
003oool000000080oooo00<000000?ooo`0000000`0000000`3oool000000?ooo`04000000040?oo
o`000000oooo0?ooo`80000000@0oooo000000000000oooo0`000000103oool000000?ooo`3oool2
000000050?ooo`00000000000000003oool00P0000000`3oool000000?ooo`0200000080oooo0`00
00001P3oool000000?ooo`3oool000000?ooo`8000000P3oool500000080oooo00<000000?ooo`00
00000P3oool00`000000oooo00000003000000030?ooo`000000oooo00@0000000@0oooo0000003o
ool0oooo0P000000103oool000000000003oool3000000040?ooo`000000oooo0?ooo`80000000D0
oooo00000000000000000?ooo`02000000030?ooo`000000oooo008000000P3oool3000000060?oo
o`000000oooo0?ooo`000000oooo0P0000020?ooo`D000000P3oool00`000000oooo000000020?oo
o`030000003oool0000000<0000000<0oooo0000003oool010000000103oool000000?ooo`3oool2
000000040?ooo`00000000000?ooo`80000000000`000000oooo000000020?ooo`@000000P3oool5
00000080oooo0`0000000`3oool000000?ooo`0500000080oooo00@000000?ooo`00000000000P3o
ool4000000<0oooo00L000000?ooo`00000000000?ooo`000000oooo00<000000P3oool00`000000
oooo0000000200000080oooo0P000000103oool000000?ooo`3oool500000080oooo100000020?oo
o`D000000P3oool3000000030?ooo`000000oooo00D000000P3oool010000000oooo000000000002
0?ooo`@000000`3oool01`000000oooo000000000000oooo0000003oool00`0000020?ooo`030000
003oool00000008000000P3oool2000000040?ooo`000000oooo0?ooo`D000000P3oool400000080
oooo1@0000020?ooo`<0000000<0oooo0000003oool01@0000020?ooo`040000003oool000000000
0080oooo100000030?ooo`070000003oool000000000003oool000000?ooo`0300000080oooo00<0
00000?ooo`0000000P0000020?ooo`80000000@0oooo0000003oool0oooo1@0000020?ooo`@00000
0P3oool500000080oooo0`0000000`3oool000000?ooo`0500000080oooo00@000000?ooo`000000
00000P3oool4000000<0oooo00L000000?ooo`00000000000?ooo`000000oooo00<000000P3oool0
0`000000oooo0000000200000080oooo0P000000103oool000000?ooo`3oool60000000000D00000
0?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool00P0000020?ooo`060000003o
ool000000000003oool000000`3oool200000080oooo00<000000?ooo`3oool00P0000030?ooo`<0
000000@0oooo0000003oool0oooo0`0000040?ooo`80000000@0oooo0000003oool0oooo0`000003
0?ooo`050000003oool000000?ooo`0000000P3oool01P000000oooo0000003oool000000?ooo`80
00000P3oool00`000000oooo0?ooo`0200000080oooo00H000000?ooo`00000000000?ooo`000003
0?ooo`8000000P3oool00`000000oooo0?ooo`02000000<0oooo0`000000103oool000000?ooo`3o
ool3000000@0oooo0P000000103oool000000?ooo`3oool3000000<0oooo00D000000?ooo`000000
oooo000000020?ooo`060000003oool000000?ooo`000000oooo0P0000020?ooo`030000003oool0
oooo008000000P3oool01P000000oooo000000000000oooo000000<0oooo0P0000020?ooo`030000
003oool0oooo008000000`3oool3000000040?ooo`000000oooo0?ooo`<00000103oool200000004
0?ooo`000000oooo0?ooo`<000000`3oool01@000000oooo0000003oool000000080oooo00H00000
0?ooo`000000oooo0000003oool200000080oooo00<000000?ooo`3oool00P0000020?ooo`060000
003oool000000000003oool000000`3oool200000080oooo00<000000?ooo`3oool00P0000030?oo
o`<0000000@0oooo0000003oool0oooo0`0000040?ooo`80000000@0oooo0000003oool0oooo0`00
00030?ooo`050000003oool000000?ooo`0000000P3oool010000000oooo0000003oool100000000
00@000000?ooo`000000oooo0P0000020?ooo`040000003oool00000000000<0oooo00@000000?oo
o`0000000000103oool2000000<0oooo00@000000?ooo`0000000000103oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00P3oool300000080oooo00@000000?ooo`000000
0000103oool300000080oooo00@000000?ooo`00000000000`3oool010000000oooo000000000002
0?ooo`040000003oool00000000000<0oooo00@000000?ooo`0000000000103oool2000000<0oooo
00@000000?ooo`0000000000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool00P3oool300000080oooo00@000000?ooo`0000000000103oool300000080oooo00@00000
0?ooo`00000000000`3oool010000000oooo0000000000020?ooo`040000003oool00000000000<0
oooo00@000000?ooo`0000000000103oool2000000<0oooo00@000000?ooo`0000000000103oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool300000080oooo00@0
00000?ooo`0000000000103oool300000080oooo00@000000?ooo`00000000000`3oool010000000
oooo0000000000020?ooo`040000003oool00000000000<0oooo00@000000?ooo`0000000000103o
ool2000000<0oooo00@000000?ooo`0000000000103oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00P3oool300000080oooo00@000000?ooo`0000000000103oool30000
0080oooo00@000000?ooo`0000000000103oool10000000000<000000?ooo`3oool00P000000103o
ool000000?ooo`3oool3000000@0oooo0`0000030?ooo`030000003oool0000000@0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000040?ooo`030000003oool000000080oooo0`000000
103oool000000?ooo`3oool2000000040?ooo`000000oooo0?ooo`<0000000@0oooo0000003oool0
oooo0P0000000`3oool000000?ooo`020?ooo`80000000@0oooo0000003oool0oooo0`0000040?oo
o`<000000`3oool00`000000oooo000000040?ooo`030000003oool0000000<0oooo00<000000?oo
o`000000103oool00`000000oooo000000020?ooo`<0000000@0oooo0000003oool0oooo0P000000
103oool000000?ooo`3oool3000000040?ooo`000000oooo0?ooo`80000000<0oooo0000003oool0
0P3oool2000000040?ooo`000000oooo0?ooo`<00000103oool3000000<0oooo00<000000?ooo`00
0000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`00
00000P3oool3000000040?ooo`000000oooo0?ooo`80000000@0oooo0000003oool0oooo0`000000
103oool000000?ooo`3oool2000000030?ooo`000000oooo0080oooo0P000000103oool000000?oo
o`3oool3000000@0oooo0`0000030?ooo`030000003oool0000000@0oooo00<000000?ooo`000000
0`3oool00`000000oooo000000040?ooo`030000003oool000000080oooo0`000000103oool00000
0?ooo`3oool2000000040?ooo`000000oooo0?ooo`<0000000@0oooo0000003oool0oooo0P000000
0`3oool000000?ooo`020?ooo`40000000001P000000oooo0?ooo`000000oooo00000080oooo00<0
00000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`000000
oooo000000020?ooo`030000003oool0000000<0oooo00D000000?ooo`000000oooo000000020?oo
o`070000003oool000000?ooo`000000oooo000000020?ooo`030000003oool0oooo0080000000<0
oooo0000003oool00P0000030?ooo`030000003oool0oooo0080000000D0oooo0000003oool00000
0?ooo`02000000070?ooo`000000oooo0?ooo`000000oooo000000020?ooo`050000003oool00000
0?ooo`0000000`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`0000000`3o
ool01@000000oooo0000003oool000000080oooo00L000000?ooo`000000oooo0000003oool00000
0080oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`02000000<0oooo00<000000?oo
o`3oool00P0000001@3oool000000?ooo`000000oooo0080000000L0oooo0000003oool0oooo0000
003oool000000080oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool000000?oo
o`0000000P3oool00`000000oooo000000030?ooo`050000003oool000000?ooo`0000000P3oool0
1`000000oooo0000003oool000000?ooo`0000000P3oool00`000000oooo0?ooo`02000000030?oo
o`000000oooo008000000`3oool00`000000oooo0?ooo`02000000050?ooo`000000oooo0000003o
ool00P0000001`3oool000000?ooo`3oool000000?ooo`0000000P3oool01@000000oooo0000003o
ool0000000<0oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool0000000<0oooo
00D000000?ooo`000000oooo000000020?ooo`070000003oool000000?ooo`000000oooo00000002
0?ooo`030000003oool0oooo0080000000<0oooo0000003oool00P0000030?ooo`030000003oool0
oooo0080000000D0oooo0000003oool000000?ooo`020000000000<000000?ooo`3oool0103oool2
000000<0oooo00<000000?ooo`0000001@3oool200000080oooo00@000000?ooo`3oool00000103o
ool00`000000oooo000000020?ooo`040000003oool00000000000<0oooo00<000000?ooo`000000
1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000050?ooo`800000
0P3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@000000?ooo`00
000000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo0P0000030?oo
o`030000003oool0000000D0oooo0P0000020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`0000000P3oool010000000oooo0000000000030?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3oool200000080oooo00@0
00000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000003oool00000000000<0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool00P3oool010000000oooo0000003oool10000000000<000000?ooo`3o
ool00`3oool3000000<0oooo0P0000000`3oool000000?ooo`020?ooo`<000000`3oool200000004
0?ooo`000000oooo0?ooo`@000000`3oool010000000oooo0?ooo`0000030?ooo`800000103oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`030000003o
ool0000000<0oooo0`0000030?ooo`80000000<0oooo0000003oool00P3oool3000000<0oooo0P00
0000103oool000000?ooo`3oool4000000<0oooo00@000000?ooo`3oool000000`3oool2000000@0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`00
0000oooo000000030?ooo`<000000`3oool2000000030?ooo`000000oooo0080oooo0`0000030?oo
o`80000000@0oooo0000003oool0oooo100000030?ooo`040000003oool0oooo000000<0oooo0P00
00040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool3000000@0oooo
00<000000?ooo`0000000`3oool3000000<0oooo0P0000000`3oool000000?ooo`020?ooo`<00000
0`3oool2000000040?ooo`000000oooo0?ooo`@000000`3oool010000000oooo0?ooo`0000030?oo
o`800000103oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo0`000004
0?ooo`030000003oool000000040000000000`000000oooo0?ooo`020?ooo`<0000000@0oooo0000
003oool000000P3oool010000000oooo0?ooo`3oool3000000040?ooo`000000oooo00000080oooo
00/000000?ooo`3oool0oooo0000003oool000000?ooo`000000oooo000000020?ooo`040000003o
ool0oooo0?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`800000103oool00`000000oooo000000030?ooo`<0000000@0oooo
0000003oool000000P3oool010000000oooo0?ooo`3oool3000000040?ooo`000000oooo00000080
oooo00/000000?ooo`3oool0oooo0000003oool000000?ooo`000000oooo000000020?ooo`040000
003oool0oooo0?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`800000103oool00`000000oooo000000030?ooo`<0000000@0
oooo0000003oool000000P3oool010000000oooo0?ooo`3oool3000000040?ooo`000000oooo0000
0080oooo00/000000?ooo`3oool0oooo0000003oool000000?ooo`000000oooo000000020?ooo`04
0000003oool0oooo0?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`800000103oool00`000000oooo000000030?ooo`<00000
00@0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool3000000040?ooo`000000oooo
00000080oooo00/000000?ooo`3oool0oooo0000003oool000000?ooo`000000oooo000000020?oo
o`040000003oool0oooo0?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`800000103oool010000000oooo0000003oool10000
000000D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000@0oooo0P000003
0?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003oool00000000000@0oooo
00<000000?ooo`0000000P3oool010000000oooo0000000000040?ooo`030000003oool000000080
oooo00@000000?ooo`0000000000103oool2000000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P00
00030?ooo`040000003oool00000000000@0oooo00<000000?ooo`0000000P3oool010000000oooo
0000000000040?ooo`030000003oool000000080oooo00@000000?ooo`0000000000103oool20000
00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P000003
0?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003oool00000000000@0oooo
00<000000?ooo`0000000P3oool010000000oooo0000000000040?ooo`030000003oool000000080
oooo00@000000?ooo`0000000000103oool2000000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P00
00030?ooo`040000003oool00000000000@0oooo00<000000?ooo`0000000P3oool010000000oooo
0000000000040?ooo`030000003oool000000080oooo00@000000?ooo`0000000000103oool20000
00@0oooo0@00000000060000003oool0oooo0000003oool00000103oool2000000<0oooo00@00000
0?ooo`0000000000103oool00`000000oooo0?ooo`020?ooo`040000003oool00000000000<0oooo
0P0000040?ooo`030000003oool0000000@0oooo0P0000040?ooo`<00000103oool00`000000oooo
000000030?ooo`<00000103oool00`000000oooo000000040?ooo`8000000`3oool010000000oooo
0000000000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`00000000000`3oool20000
00@0oooo00<000000?ooo`000000103oool2000000@0oooo0`0000040?ooo`030000003oool00000
00<0oooo0`0000040?ooo`030000003oool0000000@0oooo0P0000030?ooo`040000003oool00000
000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0000000000030?ooo`800000103o
ool00`000000oooo000000040?ooo`800000103oool3000000@0oooo00<000000?ooo`0000000`3o
ool3000000@0oooo00<000000?ooo`000000103oool2000000<0oooo00@000000?ooo`0000000000
103oool00`000000oooo0?ooo`020?ooo`040000003oool00000000000<0oooo0P0000040?ooo`03
0000003oool0000000@0oooo0P0000040?ooo`<00000103oool00`000000oooo000000030?ooo`<0
0000103oool10000000000<000000?ooo`3oool00P0000040?ooo`80000000<0oooo0000003oool0
0P3oool2000000@0oooo00@000000?ooo`3oool000000P3oool3000000@0oooo00@000000?ooo`3o
ool000000P3oool2000000@0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo0P000004
0?ooo`80000000<0oooo0000003oool00P3oool2000000@0oooo0P0000000`3oool000000?ooo`02
0?ooo`800000103oool010000000oooo0?ooo`0000020?ooo`<00000103oool010000000oooo0?oo
o`0000020?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`8000001@3oool2000000@0
oooo0P0000000`3oool000000?ooo`020?ooo`800000103oool2000000030?ooo`000000oooo0080
oooo0P0000040?ooo`040000003oool0oooo00000080oooo0`0000040?ooo`040000003oool0oooo
00000080oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P0000050?ooo`800000103o
ool2000000030?ooo`000000oooo0080oooo0P0000040?ooo`80000000<0oooo0000003oool00P3o
ool2000000@0oooo00@000000?ooo`3oool000000P3oool3000000@0oooo00@000000?ooo`3oool0
00000P3oool2000000@0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo0P0000040?oo
o`80000000<0oooo0000003oool00P3oool10000000000<000000?ooo`0000000`3oool01P000000
oooo0?ooo`000000oooo000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo
00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000003oool000000000
00@0oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool000000080oooo00@00000
0?ooo`3oool000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003o
ool000000080oooo00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000
003oool00000000000@0oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000<0oooo00L000000?ooo`3o
ool0oooo0000003oool000000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0000
00020?ooo`040000003oool00000000000@0oooo00D000000?ooo`000000oooo000000020?ooo`03
0000003oool000000080oooo00@000000?ooo`3oool000000`3oool01P000000oooo0?ooo`000000
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000<0oooo
00L000000?ooo`3oool0oooo0000003oool000000080oooo00@000000?ooo`3oool00000103oool0
0`000000oooo000000020?ooo`040000003oool00000000000@0oooo00D000000?ooo`000000oooo
000000020?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000`3oool01P000000
oooo0?ooo`000000oooo000000<0oooo0P00000000030000003oool0oooo0080oooo00@000000?oo
o`0000000000103oool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<00000
0?ooo`000000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<00000
0?ooo`0000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo
0P0000030?ooo`040000003oool00000000000@0oooo0P0000030?ooo`030000003oool0000000D0
oooo0P0000030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000040?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000`3oool01000
0000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo0000000000040?ooo`8000000`3o
ool00`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000040?ooo`030000003o
ool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo000000020?ooo`040000003o
ool0oooo000000<0oooo00@000000?ooo`3oool00000103oool2000000<0oooo00@000000?ooo`00
00000000103oool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<000000?oo
o`000000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?oo
o`0000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo0P00
00010?ooo`40000000000`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P000000
0`3oool000000?ooo`020?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`030000003oool0
oooo00@0oooo0P0000040?ooo`<000000`3oool3000000@0oooo0`0000030?ooo`<000000`3oool2
000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool00`3oool2000000030?ooo`000000
oooo0080oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool0103oool2
000000@0oooo0`0000030?ooo`<00000103oool3000000<0oooo0`0000030?ooo`80000000<0oooo
0000003oool00P3oool00`000000oooo0?ooo`030?ooo`80000000<0oooo0000003oool00P3oool0
0`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`040?ooo`800000103oool3
000000<0oooo0`0000040?ooo`<000000`3oool3000000<0oooo0P0000000`3oool000000?ooo`02
0?ooo`030000003oool0oooo00<0oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0
oooo00<0oooo0`0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`<000000`3oool3
000000@0oooo0`0000030?ooo`<000000`3oool200000040oooo0@0000010000000000<000000?oo
o`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00@00000
0?ooo`3oool000000P3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000@0oooo0`00
00030?ooo`030000003oool0000000D0oooo0P0000030?ooo`050000003oool000000?ooo`000000
0P3oool00`000000oooo000000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
0000103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool00`000000oooo000000030?oo
o`800000103oool3000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00D000000?oo
o`000000oooo000000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo000000040?ooo`040000003oool0oooo00000080oooo0P0000050?ooo`030000
003oool0000000<0oooo0P0000040?ooo`<000000`3oool00`000000oooo000000050?ooo`800000
0`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`000000103oool010000000
oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool2
000000D0oooo00<000000?ooo`0000000`3oool2000000@0oooo0`0000030?ooo`030000003oool0
000000D0oooo0P0000030?ooo`050000003oool000000?ooo`0000000P3oool010000000oooo0000
003oool10000000000H000000?ooo`3oool000000?ooo`0000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
1@000000oooo0000003oool000000080oooo0P0000030?ooo`030000003oool0000000@0oooo00<0
00000?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool000000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool000000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`050000003oool000000?ooo`0000000P3oool2000000<0oooo00<000000?ooo`000000103o
ool00`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00D000000?ooo`000000oooo000000020?ooo`8000000`3oool00`000000oooo0000
00040?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0000003oool000000080oooo0P0000030?ooo`030000003o
ool0000000@0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000
003oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`40000000001@000000oooo
0000003oool0000000D0oooo0P0000030?ooo`040000003oool00000000000@0oooo0P0000030?oo
o`030000003oool0000000@0oooo0P0000030?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000003oool0000000D0oooo0P00
00030?ooo`030000003oool0000000D0oooo0P0000030?ooo`040000003oool00000000000@0oooo
0P0000030?ooo`030000003oool0000000@0oooo0P0000030?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000003oool00000
00D0oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000030?ooo`040000003oool00000
000000@0oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000030?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000
003oool0000000D0oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000030?ooo`040000
003oool00000000000@0oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000030?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`0000000`3oool010000000oooo000000000003
0?ooo`030000003oool0000000D0oooo0P0000040?ooo`40000000001@000000oooo0?ooo`3oool0
000000@0oooo0P0000050?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`8000001P3oool2
000000<0oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000050?ooo`800000103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0
oooo00@0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000060?ooo`030000003oool0
oooo0080oooo0P0000050?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`8000001P3oool2
000000<0oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000050?ooo`800000103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0
oooo00@0oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000050?ooo`40000000001000
0000oooo0?ooo`0000050?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000040?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0
000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000003o
ool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo000000030?ooo`8000001@3o
ool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo000000030?ooo`800000103o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000
103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`000000
0`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`000000
0`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000@0oooo00<000000?ooo`0000000`3oool00`000000oooo000000040?ooo`03
0000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000050?ooo`03
0000003oool0000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0@0000000003
0000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool00000
0?ooo`0000000`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`000000103o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo00000002
0?ooo`050000003oool000000?ooo`0000000`3oool01@000000oooo0000003oool000000080oooo
00D000000?ooo`000000oooo000000030?ooo`050000003oool000000?ooo`0000000P3oool00`00
0000oooo000000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo
0000003oool000000080oooo00D000000?ooo`000000oooo000000030?ooo`050000003oool00000
0?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo00D000000?ooo`000000oooo
000000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo000000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo
00D000000?ooo`000000oooo000000020?ooo`050000003oool000000?ooo`0000000`3oool01@00
0000oooo0000003oool000000080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`00
00020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`040000003oool00000
0?ooo`80000000000`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`0000002@3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@0
00000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0
oooo0P0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0000000T0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`000000
0P3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo00000009
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`0000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool2000000<0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000030?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`0000002@3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool000000080oooo00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000
003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0oooo000000<0oooo00@000000?oo
o`000000oooo0@00000000030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`8000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0P000005
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo
000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`030?ooo`8000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo0@0000010?ooo`40
000000000`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<00000
103oool00`000000oooo0?ooo`030?ooo`<000000`3oool2000000D0oooo00<000000?ooo`000000
0`3oool2000000D0oooo0P0000040?ooo`<00000103oool2000000@0oooo0`0000040?ooo`030000
003oool0oooo00<0oooo0`0000040?ooo`030000003oool0oooo00<0oooo0`0000030?ooo`800000
1@3oool00`000000oooo000000030?ooo`8000001@3oool2000000@0oooo0`0000040?ooo`800000
103oool3000000@0oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool0
0`3oool3000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000050?ooo`800000
103oool3000000@0oooo0P0000040?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<00000
103oool00`000000oooo0?ooo`030?ooo`<000000`3oool2000000D0oooo00<000000?ooo`000000
0`3oool2000000D0oooo0P0000040?ooo`<00000103oool200000040oooo0@00000000030000003o
ool0oooo00<0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001`3o
ool01P000000oooo0?ooo`000000oooo000000@0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo000000040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool2
000000D0oooo00<000000?ooo`3oool00`3oool2000000@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo000000070?ooo`060000003oool0oooo0000003oool00000103oool010000000oooo
0?ooo`0000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`800000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000L0oooo00H000000?ooo`3oool000000?ooo`00
00040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo
0?ooo`0000030?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo00<0
oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001`3oool01P000000
oooo0?ooo`000000oooo000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000
00040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool2000000D0oooo
00<000000?ooo`3oool00@00000000030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool01P000000oooo0?ooo`000000
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000L0oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool01P000000oooo0?ooo`000000
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000L0oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool01P000000oooo0?ooo`000000
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000L0oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool01P000000oooo0?ooo`000000
oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000L0oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0080000000001@000000oooo0?ooo`3oool0
000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0000000000030?ooo`040000
003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@00000
0?ooo`3oool00000103oool200000080oooo00@000000?ooo`3oool000000`3oool010000000oooo
0?ooo`0000020?ooo`040000003oool00000000000<0oooo00@000000?ooo`3oool00000103oool2
000000<0oooo00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`80
00000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`00000000000`3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo
0?ooo`0000040?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool00`00
0000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0000000000030?ooo`04
0000003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@0
00000?ooo`3oool00000103oool200000080oooo0@0000010?ooo`40000000000`000000oooo0?oo
o`02000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0000000D0oooo0P0000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3o
ool2000000D0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000050?ooo`030000003o
ool0oooo0080oooo0P0000050?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo0P0000030?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool00P3oool2000000D0oooo0@00000000040000003oool0
oooo000000H0oooo0P0000050?ooo`800000103oool2000000D0oooo0P0000030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool2000000D0oooo0P0000040?ooo`030000003o
ool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`800000103o
ool2000000D0oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3o
ool2000000D0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003o
ool0oooo00@0oooo0P0000050?ooo`800000103oool2000000D0oooo0P0000030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool2000000D0oooo0P0000040?ooo`030000003o
ool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`800000103o
ool2000000D0oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3o
ool2000000D0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`4000000000
1P000000oooo0?ooo`000000oooo000000<0oooo0P0000000`3oool000000?ooo`020?ooo`800000
103oool2000000040?ooo`000000oooo0?ooo`<00000103oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000030?ooo`000000oooo
0080oooo0P0000040?ooo`80000000@0oooo0000003oool0oooo0`0000040?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`8000001@3o
ool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo000000030?ooo`80000000<0
oooo0000003oool00P3oool2000000@0oooo0P000000103oool000000?ooo`3oool3000000@0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0
oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0
oooo0P0000000`3oool000000?ooo`020?ooo`800000103oool2000000040?ooo`000000oooo0?oo
o`<00000103oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo0@000000
00070000003oool000000?ooo`000000oooo000000020?ooo`030000003oool0000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool000000080oooo00@000000?ooo`3oool00000103oool00`00
0000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0000003o
ool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`040000
003oool0oooo00000080oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool00000
00<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00@000000?ooo`3oool00000
103oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo00000004
0?ooo`040000003oool0oooo00000080oooo00D000000?ooo`000000oooo000000020?ooo`030000
003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool01@000000oooo0000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo000000040?ooo`040000003oool0oooo00000080oooo00D000000?ooo`000000oooo00000002
0?ooo`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo
00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0000003oool0000000@0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo000000040?ooo`040000003oool0oooo000000<0oooo0@00000000030000003o
ool0oooo0080oooo00@000000?ooo`3oool000002@3oool00`000000oooo0000000:0?ooo`030000
003oool0000000D0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool010000000oooo0?ooo`0000090?ooo`030000003oool0000000X0oooo00<0
00000?ooo`0000001@3oool2000000<0oooo00@000000?ooo`3oool00000103oool200000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`0000002P3oool0
0`000000oooo000000050?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000002@3oool00`000000oooo0000000:0?oo
o`030000003oool0000000D0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`040000003o
ool0oooo0?ooo`80000000000`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0P00
000;0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`800000
2`3oool2000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00P3oool2000000D0oooo00<000000?ooo`3oool00`3oool2000000/0
oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo0080oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P00000;0?oo
o`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool00P3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`020?ooo`8000000@3oool10000000000<000000?ooo`3oool00`3oool00`00
0000oooo000000030?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`<00000103oool20000
00D0oooo0P0000040?ooo`8000001@3oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000060?ooo`030000003oool0oooo
0080oooo0`0000040?ooo`8000001@3oool2000000@0oooo0P0000050?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`8000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool20000
00H0oooo00<000000?ooo`3oool00P3oool3000000@0oooo0P0000050?ooo`800000103oool20000
00D0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`8000001@3oool00`00
0000oooo000000030?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`<00000103oool20000
00D0oooo0P0000040?ooo`8000001@3oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00<0oooo0P0000020?ooo`40000000000`000000oooo0?ooo`040?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo0P0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo0P0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020000000000<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000040?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000040?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000040?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000040?ooo`040000
003oool0oooo000000@0oooo0@0000010?ooo`40000000001P000000oooo0?ooo`000000oooo0000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`050000003oool000000?ooo`0000000`3oool01`000000oooo
0?ooo`3oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00@00000
0?ooo`3oool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0000003oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00D000000?ooo`000000oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000
003oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool000000?ooo`0000000`3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool10000000000<000000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool00`000000oooo0?oo
o`050?ooo`050000003oool0oooo0?ooo`0000001`3oool2000000X0oooo00@000000?ooo`3oool0
00001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool2000000<0oooo00<00000
0?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000L0oooo0P00000:0?ooo`040000003o
ool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P0000030?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000070?ooo`8000002P3oool0
10000000oooo0?ooo`0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`80
00000`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001`3oool20000
00X0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`40000000001@00
0000oooo0?ooo`3oool0000000D0oooo0P0000050?ooo`030000003oool0oooo0080oooo0P000006
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`8000001@3o
ool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`8000001P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo
000000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000D0oooo
00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00P3oool2000000H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
0000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`03
0000003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool00000
00P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`800000103oool10000
000000<000000?ooo`3oool00P0000040?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3o
ool0103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000050?ooo`80
0000103oool3000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`03
0000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`03
0000003oool0oooo00@0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0`0000040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`80
0000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`80
00000`3oool2000000D0oooo0P0000040?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3o
ool0103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000050?ooo`40
0000000010000000oooo0000000000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`03
0000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?ooo`04
0000003oool0oooo00000080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000050?oo
o`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?oo
o`040000003oool0oooo00000080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P000005
0?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P000004
0?ooo`040000003oool0oooo00000080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P00
00050?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P00
00040?ooo`040000003oool0oooo000000<0oooo0@00000000030000003oool0oooo00<0oooo00@0
00000?ooo`3oool00000203oool01@000000oooo0?ooo`3oool0000000P0oooo00D000000?ooo`3o
ool0oooo000000050?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`030000
003oool0oooo00D0oooo00@000000?ooo`3oool00000203oool01@000000oooo0?ooo`3oool00000
00P0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0000000@0oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo000000030?ooo`070000003oool0oooo0?ooo`000000
oooo000000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000203oool01@00
0000oooo0?ooo`3oool0000000P0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003o
ool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000030?ooo`070000
003oool0oooo0?ooo`000000oooo000000020?ooo`030000003oool0oooo00D0oooo00@000000?oo
o`3oool00000203oool01@000000oooo0?ooo`3oool0000000P0oooo00D000000?ooo`3oool0oooo
000000050?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`030000003oool0
oooo0080oooo0@00000000030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool0
1@000000oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003oool0oooo0?oo
o`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`05
0000003oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00L000000?ooo`3oool0oooo
0000003oool000000080oooo00@000000?ooo`3oool00000103oool2000000<0oooo00@000000?oo
o`3oool00000103oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo00D0
00000?ooo`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01`000000oooo0?ooo`3oool0
00000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo
0?ooo`0000040?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool01@00
0000oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003oool0oooo0?ooo`00
0000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`0000000@00000000030000003oool0oooo00D0oooo00L00000
0?ooo`3oool0oooo0000003oool0000000D0oooo0P0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3o
ool200000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000060?ooo`07
0000003oool0oooo0?ooo`000000oooo000000050?ooo`8000000P3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0000000H0oooo00L000000?ooo`3oool0oooo0000003oool00000
00D0oooo0P0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00@000000?ooo`000000oooo
0@00000000030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`020?ooo`8000001@3oool2000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo0P0000050?ooo`8000000`3oool010000000oooo
0?ooo`0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool2000000D0
oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00@000000?ooo`3oool000001@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0@0000010?ooo`40000000000`00
0000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo0P0000060?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo0P0000050?ooo`800000103oool2000000D0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000060?ooo`800000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000050?ooo`800000103oool20000
00D0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo0P0000060?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo0P0000050?ooo`800000103oool2000000D0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000060?ooo`800000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000050?ooo`800000103oool20000
00D0oooo0P0000010?ooo`40000000000`000000oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`040000003oool0oooo
000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P0000040?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0000000@0oooo00@000000?ooo`3oool000000`3oool2000000@0oooo00@000000?oo
o`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000
00030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo
0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo000000040?ooo`040000003oool0oooo000000<0oooo0P0000040?ooo`040000
003oool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000040?ooo`030000003oool0oooo0040000000000`000000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`070?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool2000000@0oooo00@000000?ooo`3oool00000103oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo
0P0000040?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00L0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`800000103oool010000000oooo
0?ooo`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`070?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool2000000@0oooo00<000000?ooo`3oool00P00000000030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000080?ooo`050000003oool0oooo0?ooo`00
0000203oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P3oool010000000oooo0?oo
o`0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00P0oooo00D000000?ooo`3oool0oooo000000080?ooo`070000003oool0oooo0?ooo`000000oooo
000000060?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo000000020?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`050000003oool0oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000000P0oooo
00L000000?ooo`3oool0oooo0000003oool0000000H0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000080?ooo`05
0000003oool0oooo0?ooo`000000203oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000
0P3oool010000000oooo0?ooo`0000040?ooo`060000003oool0oooo0?ooo`000000oooo0@000000
00050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000050?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool010000000oooo
0?ooo`0000040?ooo`8000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo0080oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P0000060?ooo`07
0000003oool0oooo0?ooo`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool2000000<0oooo
00@000000?ooo`3oool00000103oool2000000H0oooo00L000000?ooo`3oool0oooo0000003oool0
000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`80
00001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0000000@0oooo0@00000000030000003oool0oooo008000001@3oool00`00
0000oooo0?ooo`030?ooo`8000001@3oool2000000<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool20000
00D0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00`3oool20000
00D0oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0P0000050?ooo`030000003oool0oooo
00<0oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`8000000`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`090?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`00
0000oooo0?ooo`030?ooo`8000001@3oool2000000<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool20000
00D0oooo00<000000?ooo`3oool00`3oool10000000000@000000?ooo`3oool000001P3oool20000
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`8000000`3oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`030000003oool0oooo
00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo
00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool2000000<0oooo00<000000?ooo`3oool0103oool20000
00@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`8000000`3oool00`000000oooo0?ooo`040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`800000103oool10000
000000H000000?ooo`3oool000000?ooo`0000030?ooo`8000001@3oool00`000000oooo00000004
0?ooo`030000003oool0000000<0oooo0P0000040?ooo`040000003oool0oooo00000080oooo0P00
00050?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P00
00050?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000003oool0000000@0oooo00<0
00000?ooo`0000000`3oool2000000@0oooo00@000000?ooo`3oool000000P3oool2000000D0oooo
00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo
00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`000000103oool00`000000oooo
000000030?ooo`800000103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool00`000000
oooo000000030?ooo`8000001@3oool00`000000oooo000000030?ooo`8000001@3oool00`000000
oooo000000030?ooo`8000001@3oool00`000000oooo000000040?ooo`030000003oool0000000<0
oooo0P0000040?ooo`040000003oool0oooo00000080oooo0P0000050?ooo`030000003oool00000
00<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000050?ooo`40000000001@000000
oooo0000003oool0000000L0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`0000002P3oool00`000000oooo000000070?ooo`060000
003oool0oooo0000003oool000001`3oool01P000000oooo0?ooo`000000oooo000000@0oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0000000:0?ooo`030000003oool0000000L0oooo
00H000000?ooo`3oool000000?ooo`0000070?ooo`060000003oool0oooo0000003oool00000103o
ool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000X0oooo00<000000?ooo`000000
1`3oool01P000000oooo0?ooo`000000oooo000000L0oooo00H000000?ooo`3oool000000?ooo`00
00040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000002P3oool00`000000oooo
000000070?ooo`040000003oool0oooo0?ooo`40000000000`000000oooo0?ooo`030?ooo`060000
003oool0oooo0000003oool000001`3oool00`000000oooo000000050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00H0oooo00@000000?ooo`3oool000002@3oool00`000000oooo000000070?ooo`060000003oool0
oooo0000003oool000001`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo
00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo000000070?ooo`060000003oool0oooo0000
003oool000001`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo000000070?ooo`060000003oool0oooo0000003oool0
00001`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo000000040?ooo`40000000000`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000@0oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000030?oo
o`030000003oool0000000D0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`8000000P3o
ool010000000oooo0?ooo`0000040?ooo`8000000`3oool00`000000oooo000000050?ooo`800000
0`3oool00`000000oooo000000050?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`80
00000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool20000
0080oooo00@000000?ooo`3oool00000103oool2000000<0oooo00<000000?ooo`0000001@3oool2
000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00@000000?ooo`3oool00000103o
ool200000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo
0P0000020?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`030000003oool0000000D0
oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000030?ooo`040000003oool0oooo0000
00@0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo00000005
0?ooo`<0000000000`000000oooo0?ooo`090?ooo`8000002`3oool2000000/0oooo0P0000060?oo
o`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool01`000000oooo0?ooo`3oool0
00000?ooo`0000001@3oool2000000X0oooo0P00000;0?ooo`8000002`3oool2000000H0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000050?ooo`070000003oool0oooo0?ooo`000000
oooo000000050?ooo`8000002P3oool2000000/0oooo0P00000;0?ooo`8000001P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000D0oooo00L000000?ooo`3oool0oooo0000003oool0
000000D0oooo0P00000:0?ooo`8000002`3oool2000000/0oooo0P0000060?ooo`030000003oool0
oooo0080oooo00<000000?ooo`0000001@3oool01`000000oooo0?ooo`3oool000000?ooo`000000
1@3oool200000040oooo0@00000000030000003oool0oooo00@0oooo0P00000;0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02@3oool2000000D0oooo0P0000040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`0000002`3oool2000000/0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`090?ooo`8000001@3oool2000000@0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0000000;0?ooo`8000002`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo0P0000050?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000/0oooo0P00000;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3o
ool2000000D0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001`3o
ool10000000000<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`800000103oool0
0`000000oooo000000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`8000001@3o
ool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo000000030?ooo`030000003o
ool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003o
ool0000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P0000050?ooo`030000
003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`000000
0`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?ooo`00
00000`3oool2000000D0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`80
0000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo000000030?ooo`80
0000103oool010000000oooo0?ooo`0000030?ooo`8000001@3oool00`000000oooo000000010000
000000<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0
oooo00@000000?ooo`3oool000000P3oool2000000L0oooo00@000000?ooo`3oool0oooo0P000006
0?ooo`050000003oool0oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000000H0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo
00@000000?ooo`3oool000000P3oool2000000L0oooo00@000000?ooo`3oool0oooo0P0000060?oo
o`050000003oool0oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000000H0oooo00<0
00000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00@0
00000?ooo`3oool000000P3oool2000000L0oooo00@000000?ooo`3oool0oooo0P0000060?ooo`05
0000003oool0oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000000H0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00@00000
0?ooo`3oool000000P3oool2000000L0oooo00@000000?ooo`3oool0oooo0P0000060?ooo`050000
003oool0oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000000H0oooo00@000000?oo
o`000000oooo0@00000000030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?oo
o`02000000L0oooo00@000000?ooo`3oool000002@3oool010000000oooo0?ooo`0000090?ooo`04
0000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`02000000L0oooo00@0
00000?ooo`3oool000002@3oool010000000oooo0?ooo`0000090?ooo`040000003oool0oooo0000
00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`3oool000001`3oool00`000000oooo0?ooo`02000000L0oooo00@000000?ooo`3oool00000
2@3oool010000000oooo0?ooo`0000090?ooo`040000003oool0oooo000000D0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001`3o
ool00`000000oooo0?ooo`02000000L0oooo00@000000?ooo`3oool000002@3oool010000000oooo
0?ooo`0000090?ooo`040000003oool0oooo000000<0oooo0@00000000060000003oool0oooo0000
003oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0000000@0oooo00<0
00000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`8000000P3oool010000000oooo
0?ooo`0000050?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`000000103oool00`000000oooo000000020?ooo`040000003o
ool0oooo000000@0oooo0P0000020?ooo`040000003oool0oooo000000D0oooo0P0000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`000004
0?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0000
00040?ooo`030000003oool000000080oooo00@000000?ooo`3oool00000103oool200000080oooo
00@000000?ooo`3oool000001@3oool200000080oooo00@000000?ooo`3oool00000103oool00`00
0000oooo000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P3o
ool010000000oooo0?ooo`0000040?ooo`8000000P3oool010000000oooo0?ooo`0000050?ooo`80
00000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@000000?oo
o`3oool00000103oool10000000000D000000?ooo`000000oooo000000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`000000103oool00`000000oooo000000050?ooo`030000003oool0
oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000060?ooo`070000003oool0
oooo0?ooo`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`000000103oool00`000000oooo000000050?ooo`030000
003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000060?ooo`070000
003oool0oooo0?ooo`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`000000103oool00`000000oooo000000050?oo
o`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000060?oo
o`070000003oool0oooo0?ooo`000000oooo000000050?ooo`8000000`3oool00`000000oooo0000
00050?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000103oool00`000000oooo0000
00050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P00
00060?ooo`070000003oool0oooo0?ooo`000000oooo000000050?ooo`800000103oool100000000
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo0P0000060?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool2000000H0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`090?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00T0oooo0P0000050?ooo`400000000010000000oooo0?ooo`0000070?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000002`3oool2000000/0oooo0P00000:0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000;0?ooo`80
00002`3oool2000000X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000/0oooo0P00000;0?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000002`3oool2000000/0oooo0P00000:0?ooo`40
000000000`000000oooo000000060?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`80
0000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000@0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`040?ooo`800000103oool010000000oooo0?ooo`00
00030?ooo`800000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000@0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`800000103oool010000000
oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2
000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`800000103o
ool010000000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`00
00000`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool10000000000<000000?ooo`3o
ool00`3oool00`000000oooo000000080?ooo`050000003oool0oooo0?ooo`000000203oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000
003oool000000080oooo00<000000?ooo`3oool01@3oool00`000000oooo000000080?ooo`050000
003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`000000103oool010000000oooo0?ooo`0000020?ooo`030000003oool00000
00<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo000000080?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool010000000oooo
0?ooo`0000020?ooo`030000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0
00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo000000080?ooo`050000003oool0
oooo0?ooo`000000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`000000103oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000<0oooo
00L000000?ooo`3oool0oooo0000003oool000000080oooo00<000000?ooo`3oool00P3oool10000
000000<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000T0
oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo0P00
00030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0000000T0oooo00@000000?ooo`3oool000001@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo0080oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000T0oooo00@000000?oo
o`3oool000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0000000T0oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo0080oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000@000000
00030000003oool0oooo00@0oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000020?oo
o`040000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo0080oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3o
ool200000080oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00P3oool2000000D0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`050?ooo`8000000`3oool00`000000oooo000000050?ooo`8000000`3oool00`000000
oooo000000050?ooo`8000000P3oool010000000oooo0?ooo`0000050?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`030000003oool0000000D0oooo0P000003
0?ooo`030000003oool0000000D0oooo0P0000020?ooo`040000003oool0oooo000000D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P0000050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool01@3oool2000000<0oooo00@000000?ooo`000000
oooo0@00000000030000003oool0oooo00<0oooo0P0000060?ooo`030000003oool0oooo0080oooo
0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool010000000oooo
0?ooo`3oool2000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`80
00001P3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`80
00001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3o
ool0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool20000
00H0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool00P3oool20000
00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo
0?ooo`8000001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo0P000006
0?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P000006
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3o
ool2000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`8000001P3o
ool100000040oooo0@00000000030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool2
000000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00D0oooo00@000000?ooo`3oool0oooo0P0000050?ooo`8000001@3oool00`000000oooo0?oo
o`030?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`8000002`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?oo
o`3oool2000000D0oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000
003oool0oooo00<0oooo0P00000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo0?ooo`8000001@3oool2000000D0
oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00`3oool2000000/0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0
oooo00@000000?ooo`3oool0oooo0P0000050?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`8000000@3oool10000000000<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`80
0000103oool010000000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000003
0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P00
00040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo
0?ooo`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0103oool2000000@0oooo
00@000000?ooo`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`040?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103o
ool00`000000oooo0?ooo`010000000000<000000?ooo`3oool0103oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?oo
o`3oool0000000L0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000040?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool0103oool00`000000oooo00000003
0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`060?oo
o`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080000000000`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0000000:0?ooo`040000003oool0oooo000000T0oooo
00@000000?ooo`3oool000001`3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0000000:0?ooo`040000003oool0oooo000000T0oooo
00@000000?ooo`3oool000001`3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0000000:0?ooo`040000003oool0oooo000000T0oooo
00@000000?ooo`3oool000001`3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0000000:0?ooo`040000003oool0oooo000000T0oooo
00@000000?ooo`3oool000001`3oool100000040oooo0@00000000050000003oool0oooo0?ooo`00
0000103oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`020?ooo`8000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000003oool0
oooo000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool2000000<0oooo
00<000000?ooo`3oool01@3oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@0
00000?ooo`3oool00000103oool2000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo
000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`80
00000`3oool00`000000oooo0?ooo`050?ooo`030000003oool000000080oooo00@000000?ooo`3o
ool00000103oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P000004
0?ooo`40000000001@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`060?ooo`070000003oool0oooo0?ooo`000000oooo000000050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?oo
o`8000001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00L000000?oo
o`3oool0oooo0000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000
00050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool2000000D0
oooo0@00000000030000003oool0oooo008000001P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000/0oooo0P0000060?ooo`030000
003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`8000002`3oool2000000H0oooo00<000000?ooo`3oool0
0P3oool2000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo0P00000;0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`800000
1P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0`3oool2000000/0oooo0P0000060?ooo`030000003oool0oooo0080oooo0@00000000060000003o
ool0oooo0000003oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo0@00000000030000003oool0oooo00800000103oool010000000oooo0?ooo`0000030?ooo`80
0000103oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`8000001@3oool00`000000oooo000000030?ooo`8000001@3oool0
0`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo0P0000040?ooo`040000003o
ool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
00000`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000050?ooo`030000003oool00000
00<0oooo0P0000050?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool2
000000@0oooo00@000000?ooo`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0
oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool010000000
oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`8000001@3oool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo
000000030?ooo`040000003oool0oooo000000<0oooo0@00000000030000003oool0000000P0oooo
00D000000?ooo`3oool0oooo000000080?ooo`040000003oool0oooo000000T0oooo00@000000?oo
o`3oool00000103oool01@000000oooo0000003oool0000000@0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo000000040?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
1P3oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?ooo`3oool000002@3oool01000
0000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool010000000oooo0?oo
o`0000020?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000`3oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`000000203oool010000000oooo0?ooo`0000090?oo
o`040000003oool0oooo000000@0oooo00D000000?ooo`000000oooo000000040?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`000000103oool00`000000oooo000000030?ooo`030000
003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000080?ooo`040000003oool0oooo0000
00T0oooo00@000000?ooo`3oool00000103oool01@000000oooo0000003oool0000000@0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`030000003oool0000000@0oooo
0@00000000030000003oool0oooo00<0oooo00@000000?ooo`3oool000002@3oool00`000000oooo
0000000:0?ooo`030000003oool0000000T0oooo00@000000?ooo`3oool00000103oool200000080
oooo00D000000?ooo`3oool0oooo000000040?ooo`8000002P3oool010000000oooo0?ooo`000009
0?ooo`030000003oool0000000X0oooo00<000000?ooo`0000002@3oool010000000oooo0?ooo`00
00040?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo0P00000:0?ooo`040000
003oool0oooo000000T0oooo00<000000?ooo`0000002P3oool00`000000oooo000000090?ooo`04
0000003oool0oooo000000@0oooo0P0000020?ooo`050000003oool0oooo0?ooo`000000103oool2
000000X0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0000000:0?ooo`030000003o
ool0000000T0oooo00@000000?ooo`3oool00000103oool200000080oooo00D000000?ooo`3oool0
oooo000000040?ooo`8000001`3oool10000000000<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000040?ooo`8000000`3oool00`000000oooo000000050?ooo`8000000`3oool00`000000
oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool00`000000oooo000000050?oo
o`8000000`3oool00`000000oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool0
0`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000050?ooo`8000001@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`020?ooo`8000000`3oool00`000000oooo000000050?ooo`8000000`3oool00`000000oooo0000
00050?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`4000000@3oool10000000000<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`02
0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo0P000006
0?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P000006
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`02
0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`02
0?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0040000000000`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo
0080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool20000
00H0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo
0080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo000000040?ooo`030000003oool0oooo0040000000000`000000oooo0?ooo`030?ooo`80
0000103oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000040?oo
o`040000003oool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P00
00040?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo
000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000@0oooo
00@000000?ooo`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool20000
00@0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`800000103oool0
10000000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000
103oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000040?ooo`04
0000003oool0oooo000000<0oooo0P0000040?ooo`030000003oool0oooo0080000000000`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool0103oool2000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo00H0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool0103oool2000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?oo
o`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo0080oooo0@0000010?ooo`400000000010000000oooo0?ooo`0000040?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo0P00000:0?ooo`040000
003oool0oooo000000P0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3o
ool2000000X0oooo00@000000?ooo`3oool00000203oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`020?ooo`8000002P3oool010000000oooo0?ooo`0000080?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo000000050?ooo`030000003oool0oooo0080oooo0P00000:0?ooo`040000003oool0oooo
000000P0oooo00D000000?ooo`3oool0oooo000000030?ooo`40000000000`000000oooo00000002
0?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000003oool0000000D0oooo0P000003
0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`05
0?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0000000D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000
003oool0000000D0oooo0P0000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`050?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo0P0000030?ooo`030000003oool0000000D0oooo0P0000030?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`8000000P3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000003oool0000000D0oooo0P00
00030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`050?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool00P3oool10000000000D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`800000
1P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool2000000D0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool00P3oool2000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000D0oooo0P00
00050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`070000003oool0oooo0?ooo`000000
oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`8000001P3oool01`000000
oooo0?ooo`3oool000000?ooo`0000001@3oool2000000@0oooo0@00000000050000003oool0oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P000006
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P000003
0?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`04
0?ooo`8000000`3oool2000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<00000
0?ooo`3oool0103oool2000000<0oooo0P0000050?ooo`400000000010000000oooo0?ooo`000005
0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`03
0?ooo`8000001@3oool00`000000oooo000000030?ooo`8000001`3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000003o
ool0oooo00<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000070?ooo`050000003o
ool0oooo0?ooo`0000001@3oool00`000000oooo000000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo
00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000L0oooo
00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo000000030?ooo`80
00001`3oool010000000oooo0?ooo`3oool10000000000<000000?ooo`0000001P3oool2000000@0
oooo00@000000?ooo`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`0000002P3o
ool00`000000oooo000000030?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`040000003o
ool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000090?ooo`030000003oool0000000X0oooo00<000000?oo
o`0000000`3oool00`000000oooo0?ooo`040?ooo`800000103oool010000000oooo0?ooo`000003
0?ooo`800000103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool000002@3oool00`000000oooo0000000:0?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool0103oool2000000@0oooo00@000000?ooo`3oool000000`3oool2000000@0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
000000T0oooo00<000000?ooo`0000002P3oool00`000000oooo000000040?ooo`40000000000`00
0000oooo0?ooo`030?ooo`030000003oool0000000H0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000203oool01`000000oooo
0?ooo`3oool000000?ooo`0000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3o
ool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`0000080?ooo`070000003oool0oooo0?ooo`000000oooo000000060?ooo`070000003o
ool0oooo0?ooo`000000oooo000000060?ooo`030000003oool0000000<0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000P0oooo00L000000?ooo`3oool0oooo
0000003oool0000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000H0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000203oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3oool20000000000<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000040?ooo`8000002P3oool010000000oooo0?ooo`00
00040?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo
00@000000?ooo`3oool00000103oool2000000<0oooo00@000000?ooo`3oool00000103oool20000
00<0oooo00@000000?ooo`3oool00000103oool2000000X0oooo00@000000?ooo`3oool00000103o
ool200000080oooo00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`040000
003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P0000030?oo
o`040000003oool0oooo000000@0oooo0P00000:0?ooo`040000003oool0oooo000000@0oooo0P00
00020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`0000000P3oool010000000oooo
0?ooo`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool01000
0000oooo0?ooo`0000040?ooo`8000002P3oool010000000oooo0?ooo`0000040?ooo`8000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@000000?ooo`3oool0
0000103oool2000000<0oooo00@000000?ooo`3oool00000103oool200000040oooo0@0000000003
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`80
00001@3oool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
00001@3oool2000000D0oooo00<000000?ooo`3oool00P3oool2000000D0oooo0P0000030?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0000000D0oooo0P0000050?ooo`030000003oool0oooo0080oooo0P0000050?ooo`80
00000`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`80
00001@3oool2000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool00P3oool010000000oooo0000003oool10000
000000<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`800000103oool2000000D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000@0
oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0
oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000
oooo0?ooo`040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool200000040
oooo0@00000000030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool2000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo
0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo000000030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo
0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool2000000@0oooo00<000000?ooo`3oool00@00000000040000003o
ool0oooo00000080oooo0P0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
0000103oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo000000040?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool00`3oool2000000D0oooo00@000000?ooo`3oool000000P3oool2000000@0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`0000020?ooo`030000003oool0
000000@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`8000001@3o
ool010000000oooo0?ooo`0000020?ooo`800000103oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000040?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`040000003oool0oooo00000080oooo
0P0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000
oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo000000040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3o
ool2000000D0oooo00<000000?ooo`3oool00@00000000030000003oool000000080oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000090?ooo`040000003oool0oooo000000L0oooo
00<000000?ooo`0000000P3oool00`000000oooo0?ooo`050?ooo`060000003oool0oooo0000003o
ool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
2@3oool010000000oooo0?ooo`0000070?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool01@3oool01P000000oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`030?ooo`040000003oool0oooo000000T0oooo00@000000?ooo`3oool000001`3oool00`00
0000oooo000000020?ooo`030000003oool0oooo00D0oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000090?oo
o`040000003oool0oooo000000L0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`05
0?ooo`060000003oool0oooo0000003oool000000`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`3oool10000000000D000000?ooo`3o
ool0oooo000000050?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo00000008
0?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`0000000P3oool010000000oooo0?oo
o`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000001@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000080?oo
o`040000003oool0oooo000000L0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`00
00040?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000001@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000080?ooo`04
0000003oool0oooo000000L0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`000004
0?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000001@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000080?ooo`040000
003oool0oooo000000L0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?oo
o`8000000`3oool010000000oooo0?ooo`0000040?ooo`800000103oool10000000000D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo0080oooo0P0000050?ooo`8000000`3oool00`000000oooo0000
00050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P00
00060?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00P3oool2000000D0oooo0P0000030?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool0
0P3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000
oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P0000050?oo
o`8000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo0P0000060?oo
o`030000003oool0oooo0080oooo0P0000050?ooo`400000000010000000oooo0?ooo`0000060?oo
o`800000103oool2000000D0oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000050?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool2000000@0oooo0P0000050?oo
o`8000000`3oool00`000000oooo000000040?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo0P0000040?ooo`8000001@3oool2000000<0oooo00<000000?oo
o`000000103oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`800000103oool2000000D0oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000050?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo0@00000000030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
00002`3oool2000000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000;0?ooo`80
00002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000/0oooo0P00000;0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000002`3oool2000000/0oooo00<000000?ooo`3o
ool00P3oool20000000000<000000?ooo`3oool00P0000040?ooo`040000003oool0oooo000000<0
oooo0P0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool000000080oooo0P0000050?ooo`030000003oool0000000<0oooo0P000005
0?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool2000000@0oooo00@0
00000?ooo`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`000003
0?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?oo
o`0000020?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`80
00001@3oool00`000000oooo000000030?ooo`8000001@3oool00`000000oooo000000030?ooo`04
0000003oool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P000004
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`3oool01@000000oooo0?oo
o`3oool000000080oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000050?ooo`030000
003oool0000000<0oooo00@000000?ooo`3oool000000`3oool10000000000<000000?ooo`000000
203oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?ooo`3oool000002@3oool01000
0000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool02@000000oooo0?oo
o`3oool000000?ooo`000000oooo000000040?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool01P3oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?ooo`3oool000002@3o
ool010000000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool02@000000
oooo0?ooo`3oool000000?ooo`000000oooo000000040?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?ooo`3oool0
00002@3oool010000000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool0
2@000000oooo0?ooo`3oool000000?ooo`000000oooo000000040?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?oo
o`3oool000002@3oool010000000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000
103oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000040?ooo`030000003oool0
000000@0oooo0@00000000030000003oool0oooo00<0oooo00<000000?ooo`0000002P3oool00`00
0000oooo0000000:0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000001@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0000000X0oooo00<000000?ooo`0000002P3o
ool00`000000oooo000000040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
103oool2000000<0oooo00@000000?ooo`3oool00000103oool2000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0000000:0?ooo`030000003oool0000000X0oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo0P0000030?oo
o`040000003oool0oooo000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000002P3oool00`000000oooo0000000:0?ooo`030000003oool0000000@0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo0?oo
o`0000040?ooo`8000001@3oool100000040oooo0@00000000030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<0
00000?ooo`000000103oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<0
00000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<0
00000?ooo`000000103oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<0
00000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<0
00000?ooo`000000103oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<0
00000?ooo`0000001@3oool2000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo00<0
00000?ooo`000000103oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`8000001@3oool200000040oooo0@00
000000030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool2000000D0oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P000005
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool2000000D0oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P000005
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool2000000D0oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P000005
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool2000000D0oooo0P0000050?ooo`030000003oool0oooo00<0oooo0P000005
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000004
0?ooo`030000003oool0oooo0040000000000`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo
00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
0040000000000`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`000000103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool00`000000oooo00000003
0?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000
oooo0?ooo`0000020?ooo`030000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool2
000000D0oooo00<000000?ooo`0000000`3oool2000000@0oooo00@000000?ooo`3oool000000`3o
ool2000000@0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000040?oo
o`040000003oool0oooo00000080oooo0P0000050?ooo`030000003oool0000000<0oooo0P000004
0?ooo`040000003oool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool0
0`000000oooo000000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`00
0000oooo0@00000000030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo000000L0oooo00D000000?ooo`000000oooo0000
00080?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00H000000?ooo`3oool0
00000?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
1`3oool01@000000oooo0000003oool0000000P0oooo0P0000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000070?ooo`050000003oool000000?ooo`000000203oool2
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`060000003oool0oooo0000003oool0
00000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000L0oooo00D0
00000?ooo`000000oooo000000080?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@0
00000?ooo`3oool0oooo0@00000000060000003oool0oooo0000003oool000001@3oool00`000000
oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<000000?ooo`3oool01@3oool2000000<0
oooo00<000000?ooo`3oool01@3oool200000080oooo00@000000?ooo`3oool00000103oool00`00
0000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<000000?ooo`3oool01@3oool20000
00<0oooo00<000000?ooo`3oool01@3oool200000080oooo00@000000?ooo`3oool00000103oool0
0`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<000000?ooo`3oool01@3oool2
000000<0oooo00<000000?ooo`3oool01@3oool200000080oooo00@000000?ooo`3oool00000103o
ool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`020?ooo`8000001@3oool2000000<0oooo00<000000?ooo`3oool01@3o
ool2000000<0oooo00<000000?ooo`3oool01@3oool200000080oooo00@000000?ooo`3oool00000
103oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo0@00000000050000003o
ool000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`<00000103oool2000000H0oooo
00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool00P3oool2000000H0oooo
00L000000?ooo`3oool0oooo0000003oool0000000D0oooo0P0000030?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool00P3oool3000000@0oooo0P0000060?ooo`030000003oool0oooo
0080oooo0P0000060?ooo`030000003oool0oooo0080oooo0P0000060?ooo`070000003oool0oooo
0?ooo`000000oooo000000050?ooo`8000000`3oool00`000000oooo000000050?ooo`030000003o
ool0oooo0080oooo0`0000040?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`8000001P3o
ool00`000000oooo0?ooo`020?ooo`8000001P3oool01`000000oooo0?ooo`3oool000000?ooo`00
00001@3oool2000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`<0
0000103oool2000000H0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3o
ool00P3oool2000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000D0oooo0P000004
0?ooo`40000000000`000000oooo0?ooo`02000000@0oooo00<000000?ooo`000000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0103oool20000
00@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00<0oooo0P0000050?ooo`800000103oool00`000000oooo000000040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`8000000`3oool20000
00D0oooo0P0000040?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo000000040?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo
00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`8000001@3oool20000
00@0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00@0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000050?ooo`400000000010000000
oooo0000000000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool00000
00<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?ooo`040000003oool0oooo
00000080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0
000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?ooo`040000003oool0
oooo00000080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003o
ool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?ooo`040000003o
ool0oooo00000080oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000
003oool0000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P0000040?ooo`040000
003oool0oooo000000<0oooo0@00000000030000003oool0oooo00<0oooo00@000000?ooo`3oool0
00002@3oool010000000oooo0?ooo`0000080?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1P000000oooo0?ooo`000000oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000T0oooo00@000000?ooo`3oool0
0000203oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000030?ooo`070000
003oool0oooo0?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
10000000oooo0?ooo`0000090?ooo`040000003oool0oooo000000P0oooo00D000000?ooo`3oool0
oooo000000020?ooo`060000003oool0oooo0000003oool000000`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`00
00000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000002@3oool0
10000000oooo0?ooo`0000080?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo
0?ooo`000000oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00@000000?ooo`3oool0
oooo0P00000000030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000
oooo000000020?ooo`040000003oool00000000000@0oooo00D000000?ooo`000000oooo00000002
0?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo0?oo
o`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool010000000
oooo0?ooo`0000040?ooo`030000003oool000000080oooo00@000000?ooo`0000000000103oool0
1@000000oooo0000003oool000000080oooo0P0000020?ooo`040000003oool0oooo000000@0oooo
0P0000030?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0oooo0000
00@0oooo0P0000030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`0000000P3oool0
10000000oooo0000000000040?ooo`050000003oool000000?ooo`0000000P3oool200000080oooo
00@000000?ooo`3oool00000103oool2000000<0oooo00@000000?ooo`3oool00000103oool20000
00<0oooo00@000000?ooo`3oool00000103oool2000000<0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo000000020?ooo`040000003oool00000000000@0oooo00D000000?ooo`000000
oooo000000020?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool01000
0000oooo0?ooo`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000000@3o
ool10000000000<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000@0oooo0P0000040?ooo`030000003oool0000000@0oooo0P0000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`000000103oool2000000@0oooo00<000000?ooo`000000103oool2
000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000040?ooo`800000103oool0
0`000000oooo000000040?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000@0oooo0P0000040?ooo`030000003oool0000000@0oooo0P0000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool10000000000<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0P000004
0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0000000<0oooo0P000005
0?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00T0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P000004
0?ooo`030000003oool0000000<0oooo0P0000050?ooo`800000103oool2000000H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0P000004
0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0000000<0oooo0P000005
0?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00T0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P000004
0?ooo`030000003oool0000000<0oooo0P0000050?ooo`800000103oool2000000H0oooo0@000001
0?ooo`40000000000`000000oooo0?ooo`040?ooo`8000000`3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000030?ooo`000000oooo0080oooo00<000000?ooo`0000000`3oool20000
00030?ooo`000000oooo0080oooo0P0000040?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000003oool0oooo00@0oooo0P000003
0?ooo`8000001@3oool00`000000oooo000000030?ooo`80000000<0oooo0000003oool00P3oool0
0`000000oooo000000030?ooo`80000000<0oooo0000003oool00P3oool2000000@0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<0
00000?ooo`3oool0103oool2000000<0oooo0P0000050?ooo`030000003oool0000000<0oooo0P00
00000`3oool000000?ooo`020?ooo`030000003oool0000000<0oooo0P0000000`3oool000000?oo
o`020?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`8000000`3oool2000000D0oooo
00<000000?ooo`0000000`3oool2000000030?ooo`000000oooo0080oooo00<000000?ooo`000000
0`3oool2000000030?ooo`000000oooo0080oooo0P0000040?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000003oool0oooo0040
0000000010000000oooo0?ooo`0000020?ooo`8000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`000000103oool00`000000oooo000000030?ooo`030000003oool00000
00@0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool00000
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`000000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`000000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000020?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`00
0000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0@000000
00030000003oool000000080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000H0oooo00L000000?ooo`3oool0
oooo0000003oool0000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo0P00
00030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000040?ooo`050000003oool0oooo0?ooo`0000000`3oool01`000000oooo0?ooo`3oool0
00000?ooo`0000001P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3oool01`000000
oooo0?ooo`3oool000000?ooo`000000103oool2000000<0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0
oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000060?ooo`070000003oool0
oooo0?ooo`000000oooo000000060?ooo`070000003oool0oooo0?ooo`000000oooo000000040?oo
o`8000000`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0
oooo0000003oool0000000H0oooo00L000000?ooo`3oool0oooo0000003oool0000000H0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000@0oooo0P0000030?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool00`3oool10000000000D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo0080oooo0P0000030?ooo`040000003oool00000000000@0oooo0P0000030?ooo`030000003o
ool0000000@0oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo0080oooo0P0000030?ooo`040000003oool00000000000@0
oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000060?ooo`030000003oool0oooo0080
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P0000030?oo
o`040000003oool00000000000@0oooo0P0000030?ooo`030000003oool0000000@0oooo0P000006
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo0080oooo0P0000030?ooo`040000003oool00000000000@0oooo0P0000030?ooo`030000
003oool0000000@0oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000
103oool10000000000@000000?ooo`3oool000001P3oool2000000@0oooo0P0000050?ooo`800000
0`3oool00`000000oooo000000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0
103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0
103oool2000000@0oooo0P0000050?ooo`8000000`3oool00`000000oooo000000040?ooo`800000
103oool2000000D0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0
103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo0P0000050?ooo`800000
0`3oool00`000000oooo000000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0
103oool2000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0
103oool2000000@0oooo0P0000050?ooo`8000000`3oool00`000000oooo000000040?ooo`800000
103oool2000000D0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<000000?ooo`3oool0
103oool2000000@0oooo0@00000000060000003oool0oooo0000003oool00000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool01000
0000oooo0?ooo`0000020?ooo`8000001@3oool00`000000oooo000000040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`0000020?ooo`800000
1@3oool00`000000oooo000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000
103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
0000103oool010000000oooo0?ooo`0000020?ooo`8000001@3oool00`000000oooo000000040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?oo
o`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo0?ooo`00
00020?ooo`8000001@3oool00`000000oooo000000040?ooo`030000003oool0oooo00<0oooo0@00
000000050000003oool000000?ooo`0000000`3oool200000080oooo00@000000?ooo`3oool0oooo
0P0000000`3oool000000?ooo`0200000080oooo00X000000?ooo`3oool000000?ooo`000000oooo
0000003oool000000P3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`000000oooo000000040?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`0000000`3oool200000080oooo00@00000
0?ooo`3oool0oooo0P0000000`3oool000000?ooo`0200000080oooo00X000000?ooo`3oool00000
0?ooo`000000oooo0000003oool000000P3oool010000000oooo0?ooo`3oool200000080oooo00<0
00000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`000000
oooo000000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`3oool20000
0080oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000?ooo`0200000080oooo00X00000
0?ooo`3oool000000?ooo`000000oooo0000003oool000000P3oool010000000oooo0?ooo`3oool2
00000080oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D0
00000?ooo`000000oooo000000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
00000`3oool200000080oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000?ooo`020000
0080oooo00X000000?ooo`3oool000000?ooo`000000oooo0000003oool000000P3oool010000000
oooo0?ooo`3oool200000080oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00D000000?ooo`000000oooo000000040?ooo`040000003oool0oooo000000<0oooo
0@00000000030000003oool0oooo00<0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3o
ool000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool2
000000<0oooo00@000000?ooo`3oool00000103oool200000080oooo00<000000?ooo`3oool01@3o
ool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000050?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool010000000oooo0?ooo`00
00040?ooo`8000000P3oool00`000000oooo0?ooo`050?ooo`8000000`3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo0080oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`030000003o
ool0oooo00D0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
000000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000001@3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool2000000<0oooo00@00000
0?ooo`3oool00000103oool200000080oooo00<000000?ooo`3oool00P3oool10000000000<00000
0?ooo`3oool00P3oool00`000000oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`03
0?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00L00000
0?ooo`3oool0oooo0000003oool0000000D0oooo0P0000050?ooo`030000003oool0oooo00<0oooo
0P0000050?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo0080oooo
00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`8000001P3oool01`000000oooo
0?ooo`3oool000000?ooo`0000001@3oool2000000D0oooo00<000000?ooo`3oool00`3oool20000
00D0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo000000050?ooo`030000003oool0oooo0080oooo0P0000060?ooo`070000003oool0oooo
0?ooo`000000oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`8000001@3o
ool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool00P3oool2000000H0oooo0@0000010?ooo`4000000000
0`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo0P0000000`3oool000000?ooo`02
0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`800000103oool3000000@0oooo0P000005
0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`80000000<0oooo0000003oool00P3oool0
0`000000oooo0?ooo`030?ooo`<00000103oool2000000@0oooo0`0000040?ooo`8000001@3oool2
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000040?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool2000000030?ooo`000000oooo0080oooo00<00000
0?ooo`3oool00`3oool3000000@0oooo0P0000040?ooo`<00000103oool2000000D0oooo0P000004
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo00000003
0?ooo`030000003oool0000000<0oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0
oooo00<0oooo0`0000040?ooo`800000103oool3000000@0oooo0P0000050?ooo`800000103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000@000000
00030000003oool0oooo00<0oooo0P0000001`3oool000000?ooo`3oool000000?ooo`000000103o
ool010000000oooo0?ooo`0000020?ooo`800000103oool200000080oooo00<000000?ooo`3oool0
0P0000020?ooo`060000003oool000000000003oool000000`3oool2000000050?ooo`000000oooo
0?ooo`0000000P3oool010000000oooo0?ooo`3oool2000000070?ooo`000000oooo0?ooo`000000
oooo000000040?ooo`80000000L0oooo0000003oool0oooo0000003oool0000000@0oooo00@00000
0?ooo`3oool000000P3oool2000000@0oooo0P0000020?ooo`030000003oool0oooo008000000P3o
ool01P000000oooo000000000000oooo000000<0oooo0P0000001@3oool000000?ooo`3oool00000
0080oooo00@000000?ooo`3oool0oooo0P0000001`3oool000000?ooo`3oool000000?ooo`000000
103oool2000000070?ooo`000000oooo0?ooo`000000oooo000000040?ooo`040000003oool0oooo
00000080oooo0P0000040?ooo`8000000P3oool00`000000oooo0?ooo`0200000080oooo00H00000
0?ooo`00000000000?ooo`0000030?ooo`80000000D0oooo0000003oool0oooo000000020?ooo`04
0000003oool0oooo0?ooo`80000000L0oooo0000003oool0oooo0000003oool0000000@0oooo0P00
00001`3oool000000?ooo`3oool000000?ooo`000000103oool010000000oooo0?ooo`0000020?oo
o`800000103oool200000080oooo00<000000?ooo`3oool00P0000020?ooo`060000003oool00000
0000003oool000000`3oool2000000050?ooo`000000oooo0?ooo`0000000P3oool010000000oooo
0?ooo`3oool2000000080?ooo`000000oooo0?ooo`000000oooo0000003oool10000000000H00000
0?ooo`3oool000000?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo000000020?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00@0
00000?ooo`3oool000000P3oool01@000000oooo0000003oool000000080oooo00@000000?ooo`3o
ool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool000000080oooo00@00000
0?ooo`3oool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool000000080oooo
00@000000?ooo`3oool00000103oool00`000000oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo0P000003
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool00000
0080oooo00@000000?ooo`3oool00000103oool10000000000<000000?ooo`0000000P3oool00`00
0000oooo0?ooo`020?ooo`8000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00P3oool2000000<0oooo00@000000?ooo`3oool00000103oool2000000<0oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo0P0000030?ooo`040000
003oool0oooo000000@0oooo0P0000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`020?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`8000000`3oool0
0`000000oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool2000000@0oooo0@00
000000030000003oool0oooo00800000103oool010000000oooo0?ooo`0000030?ooo`800000103o
ool3000000@0oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool00`3o
ool3000000@0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000000`3oool000000?oo
o`020?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000103oool3000000@0oooo
00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool00`3oool3000000@0oooo
00<000000?ooo`3oool0103oool2000000<0oooo0P0000000`3oool000000?ooo`020?ooo`800000
103oool010000000oooo0?ooo`0000030?ooo`800000103oool3000000@0oooo00<000000?ooo`3o
ool00`3oool3000000@0oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3o
ool0103oool2000000<0oooo0P0000000`3oool000000?ooo`020?ooo`800000103oool010000000
oooo0?ooo`0000030?ooo`800000103oool3000000@0oooo00<000000?ooo`3oool00`3oool30000
00@0oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool0103oool20000
00<0oooo0P0000000`3oool000000?ooo`020?ooo`400000000010000000oooo0000000000050?oo
o`030000003oool0000000<0oooo0P0000020?ooo`030000003oool0oooo00800000103oool01000
0000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`8000001@3o
ool00`000000oooo000000030?ooo`800000103oool00`000000oooo000000030?ooo`8000001@3o
ool00`000000oooo000000030?ooo`8000000P3oool00`000000oooo0?ooo`02000000@0oooo00@0
00000?ooo`3oool000000`3oool2000000@0oooo00@000000?ooo`3oool000000`3oool2000000D0
oooo00<000000?ooo`0000000`3oool2000000@0oooo00<000000?ooo`0000000`3oool2000000D0
oooo00<000000?ooo`0000000`3oool200000080oooo00<000000?ooo`3oool00P0000040?ooo`04
0000003oool0oooo000000<0oooo0P0000040?ooo`040000003oool0oooo000000<0oooo0P000005
0?ooo`030000003oool0000000<0oooo0P0000040?ooo`030000003oool0000000<0oooo0P000005
0?ooo`030000003oool0000000<0oooo0P0000020?ooo`030000003oool0oooo00800000103oool0
10000000oooo0?ooo`0000030?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`800000
1@3oool00`000000oooo000000030?ooo`800000103oool00`000000oooo000000040?ooo`400000
00000`000000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P3o
ool010000000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool01P000000
oooo0?ooo`000000oooo00000080oooo00D000000?ooo`000000oooo000000030?ooo`0:0000003o
ool000000000003oool000000?ooo`000000oooo000000<0oooo00<000000?ooo`000000103oool0
0`000000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool01P000000oooo
0?ooo`000000oooo00000080oooo00D000000?ooo`000000oooo000000030?ooo`0:0000003oool0
00000000003oool000000?ooo`000000oooo000000<0oooo00<000000?ooo`000000103oool00`00
0000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P3oool01000
0000oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool01P000000oooo0?oo
o`000000oooo00000080oooo00D000000?ooo`000000oooo000000030?ooo`0:0000003oool00000
0000003oool000000?ooo`000000oooo000000<0oooo00<000000?ooo`000000103oool00`000000
oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P3oool010000000
oooo0?ooo`0000040?ooo`050000003oool000000?ooo`000000103oool01P000000oooo0?ooo`00
0000oooo00000080oooo00D000000?ooo`000000oooo000000030?ooo`0:0000003oool000000000
003oool000000?ooo`000000oooo000000<0oooo00<000000?ooo`000000103oool00`000000oooo
000000010000000000<000000?ooo`3oool00P3oool010000000oooo0000000000030?ooo`030000
003oool0000000D0oooo0P0000030?ooo`<000001@3oool200000080oooo00@000000?ooo`000000
00000`3oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`00
00000`3oool00`000000oooo000000040?ooo`030000003oool0000000<0oooo00@000000?ooo`00
000000000`3oool00`000000oooo000000050?ooo`8000000`3oool3000000D0oooo0P0000020?oo
o`040000003oool00000000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000004
0?ooo`030000003oool0000000<0oooo00<000000?ooo`000000103oool00`000000oooo00000003
0?ooo`040000003oool00000000000<0oooo00<000000?ooo`0000001@3oool2000000<0oooo0`00
00050?ooo`8000000P3oool010000000oooo0000000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`000000103oool00`000000oooo000000030?ooo`030000003oool0000000@0oooo
00<000000?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000003oool0000000D0
oooo0P0000030?ooo`<000001@3oool200000080oooo00@000000?ooo`00000000000`3oool00`00
0000oooo000000030?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000040?ooo`040000003oool000000?ooo`40000000000`000000oooo0?ooo`030?oo
o`<00000103oool00`000000oooo0?ooo`030?ooo`<000000`3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo0P0000040?oo
o`8000001@3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?oo
o`<000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000D0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`<00000103oool00`000000oooo0?ooo`030?ooo`<000000`3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo0P0000040?oo
o`8000001@3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?oo
o`<000000`3oool2000000D0oooo00<000000?ooo`0000000`3oool2000000D0oooo00<000000?oo
o`0000000`3oool2000000D0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`010000
000000D000000?ooo`3oool000000?ooo`03000000@0oooo00@000000?ooo`3oool000000P3oool0
1@000000oooo0000003oool000000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo
0000003oool000000080oooo00@000000?ooo`3oool000000`3oool2000000050?ooo`000000oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`0000000000
0P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000800000103oool010000000
oooo0?ooo`0000020?ooo`050000003oool000000?ooo`0000000P3oool010000000oooo0?ooo`00
00020?ooo`050000003oool000000?ooo`0000000P3oool010000000oooo0?ooo`0000030?ooo`80
000000D0oooo0000003oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0000000000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`000000
0P0000040?ooo`040000003oool0oooo00000080oooo00D000000?ooo`000000oooo000000020?oo
o`040000003oool0oooo00000080oooo00D000000?ooo`000000oooo000000020?ooo`040000003o
ool0oooo000000<0oooo0P0000001@3oool000000?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0000000000080oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo00000002000000@0oooo00@000000?ooo`3oool000000P3oool01@000000oooo
0000003oool000000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool0
00000080oooo00@000000?ooo`3oool000000`3oool2000000050?ooo`000000oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`00000000000P3oool01000
0000oooo0?ooo`0000030?ooo`40000000001@000000oooo0000003oool0000000D0oooo0P000002
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool01@000000oooo
0000003oool000000080oooo00@000000?ooo`00000000000P3oool01@000000oooo0000003oool0
00000080oooo00@000000?ooo`00000000000P3oool00`000000oooo0000000200000080oooo00<0
00000?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000003oool0000000D0oooo
0P0000020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool01@00
0000oooo0000003oool000000080oooo00@000000?ooo`00000000000P3oool01@000000oooo0000
003oool000000080oooo00@000000?ooo`00000000000P3oool00`000000oooo0000000200000080
oooo00<000000?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000003oool00000
00D0oooo0P0000020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3o
ool01@000000oooo0000003oool000000080oooo00@000000?ooo`00000000000P3oool01@000000
oooo0000003oool000000080oooo00@000000?ooo`00000000000P3oool00`000000oooo00000002
00000080oooo00<000000?ooo`0000000`3oool010000000oooo0000000000030?ooo`030000003o
ool0000000D0oooo0P0000020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0
00000P3oool01@000000oooo0000003oool000000080oooo00@000000?ooo`00000000000P3oool0
1@000000oooo0000003oool000000080oooo00@000000?ooo`00000000000P3oool00`000000oooo
0000000200000080oooo00<000000?ooo`0000000`3oool010000000oooo0000000000040?ooo`40
0000000010000000oooo0?ooo`0000050?ooo`<00000103oool2000000D0oooo0P0000030?ooo`03
0000003oool0000000@0oooo0P0000040?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`<0
0000103oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<0
0000103oool2000000D0oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000040?ooo`@0
00000`3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<0
0000103oool00`000000oooo0?ooo`030?ooo`<00000103oool2000000D0oooo0P0000030?ooo`03
0000003oool0000000@0oooo0P0000040?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`<0
0000103oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<0
0000103oool2000000D0oooo0P0000030?ooo`030000003oool0000000@0oooo0P0000040?ooo`@0
00000`3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<0
0000103oool10000000000H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool00000
0080oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool000000080oooo0P0000000`3o
ool000000?ooo`020?ooo`040000003oool0oooo00000080oooo00D000000?ooo`000000oooo0000
00020?ooo`040000003oool0oooo00000080oooo0P0000020?ooo`060000003oool0oooo0000003o
ool000000`3oool2000000030?ooo`000000oooo0080oooo00<000000?ooo`000000103oool00`00
0000oooo000000020?ooo`80000000<0oooo0000003oool00`3oool00`000000oooo000000020?oo
o`80000000<0oooo0000003oool00P3oool010000000oooo0?ooo`0000020?ooo`050000003oool0
00000?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`8000000P3oool01P000000oooo
0?ooo`000000oooo000000<0oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool00000
00@0oooo00<000000?ooo`0000000P3oool2000000030?ooo`000000oooo00<0oooo00<000000?oo
o`0000000P3oool2000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000P3oool0
1@000000oooo0000003oool000000080oooo00@000000?ooo`3oool000000P3oool200000080oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`80000000<0oooo0000003oool00P3oool00`00
0000oooo000000040?ooo`030000003oool000000080oooo0P0000000`3oool000000?ooo`030?oo
o`030000003oool000000080oooo0P0000000`3oool000000?ooo`020?ooo`040000003oool0oooo
00000080oooo00D000000?ooo`000000oooo000000020?ooo`040000003oool0oooo00000080oooo
0P0000020?ooo`060000003oool0oooo0000003oool000000`3oool2000000030?ooo`000000oooo
0080oooo0@00000000060000003oool000000?ooo`000000oooo100000000`3oool000000?ooo`02
00000080oooo00@000000?ooo`000000oooo0P0000000`3oool000000?ooo`0200000080oooo00<0
00000?ooo`0000000P0000020?ooo`040000003oool00000000000<0oooo00@000000?ooo`000000
00000P3oool010000000oooo0000000000030?ooo`060000003oool000000000003oool000000P3o
ool200000080oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`04000000030?ooo`00
0000oooo008000000P3oool010000000oooo0000003oool2000000030?ooo`000000oooo00800000
0P3oool00`000000oooo0000000200000080oooo00@000000?ooo`00000000000`3oool010000000
oooo0000000000020?ooo`040000003oool00000000000<0oooo00H000000?ooo`00000000000?oo
o`0000020?ooo`8000000P3oool00`000000oooo0?ooo`02000000030?ooo`000000oooo00@00000
00<0oooo0000003oool00P0000020?ooo`040000003oool000000?ooo`80000000<0oooo0000003o
ool00P0000020?ooo`030000003oool00000008000000P3oool010000000oooo0000000000030?oo
o`040000003oool0000000000080oooo00@000000?ooo`00000000000`3oool01P000000oooo0000
00000000oooo00000080oooo0P0000020?ooo`030000003oool0oooo0080000000<0oooo0000003o
ool0100000000`3oool000000?ooo`0200000080oooo00@000000?ooo`000000oooo0P0000000`3o
ool000000?ooo`0200000080oooo00<000000?ooo`0000000P0000020?ooo`040000003oool00000
000000<0oooo00@000000?ooo`00000000000P3oool010000000oooo0000000000030?ooo`060000
003oool000000000003oool000000P3oool200000080oooo00D000000?ooo`3oool000000?ooo`01
0000000000<000000?ooo`3oool00P3oool4000000<0oooo0P0000001`3oool000000?ooo`3oool0
00000?ooo`000000103oool2000000040?ooo`000000oooo0?ooo`<00000103oool3000000@0oooo
0P0000040?ooo`<00000103oool2000000@0oooo00<000000?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`@000000`3oool2000000070?ooo`000000oooo0?ooo`000000oooo000000040?oo
o`80000000@0oooo0000003oool0oooo0`0000040?ooo`<00000103oool2000000@0oooo0`000004
0?ooo`800000103oool00`000000oooo000000040?ooo`030000003oool0oooo0080oooo10000003
0?ooo`80000000L0oooo0000003oool0oooo0000003oool0000000@0oooo0P000000103oool00000
0?ooo`3oool3000000@0oooo0`0000040?ooo`800000103oool3000000@0oooo0P0000040?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool00P3oool4000000<0oooo0P0000001`3oool0
00000?ooo`3oool000000?ooo`000000103oool2000000040?ooo`000000oooo0?ooo`<00000103o
ool3000000@0oooo0P0000040?ooo`<00000103oool2000000@0oooo00<000000?ooo`000000103o
ool00`000000oooo0?ooo`010000000000@000000?ooo`3oool000000P3oool2000000090?ooo`00
0000oooo0?ooo`000000oooo0000003oool000000080oooo00D000000?ooo`3oool000000?ooo`02
000000050?ooo`000000oooo0000003oool00P0000020?ooo`030000003oool00000008000000P3o
ool01`000000oooo000000000000oooo0000003oool0100000001@3oool000000?ooo`3oool00000
0080oooo0P0000001P3oool00000000000000000oooo00000080oooo00<000000?ooo`3oool00P00
00020?ooo`80000000T0oooo0000003oool0oooo0000003oool000000?ooo`0000000P3oool01@00
0000oooo0?ooo`000000oooo0080000000D0oooo0000003oool000000?ooo`0200000080oooo00<0
00000?ooo`0000000P0000020?ooo`070000003oool000000000003oool000000?ooo`0400000005
0?ooo`000000oooo0?ooo`0000000P3oool2000000060?ooo`00000000000000003oool000000P3o
ool00`000000oooo0?ooo`0200000080oooo0P0000002@3oool000000?ooo`3oool000000?ooo`00
0000oooo000000020?ooo`050000003oool0oooo0000003oool00P0000001@3oool000000?ooo`00
0000oooo008000000P3oool00`000000oooo0000000200000080oooo00L000000?ooo`0000000000
0?ooo`000000oooo00@0000000D0oooo0000003oool0oooo000000020?ooo`80000000H0oooo0000
0000000000000?ooo`0000020?ooo`030000003oool0oooo008000000P3oool2000000090?ooo`00
0000oooo0?ooo`000000oooo0000003oool000000080oooo00D000000?ooo`3oool000000?ooo`02
000000050?ooo`000000oooo0000003oool00P0000020?ooo`030000003oool00000008000000P3o
ool01`000000oooo000000000000oooo0000003oool0100000001@3oool000000?ooo`3oool00000
0080oooo0P0000001P3oool00000000000000000oooo00000080oooo00<000000?ooo`3oool00P00
000000060000003oool000000000003oool000000P3oool00`000000oooo0000000200000080oooo
100000020?ooo`040000003oool00000000000<0oooo0`0000030?ooo`040000003oool000000000
00<0oooo0`0000020?ooo`030000003oool00000008000000P3oool010000000oooo0?ooo`000002
0?ooo`80000000<0oooo0000000000000P3oool00`000000oooo00000002000000060?ooo`000000
00000000003oool000000P3oool00`000000oooo0000000200000080oooo100000020?ooo`040000
003oool00000000000<0oooo0`0000030?ooo`040000003oool00000000000<0oooo0`0000020?oo
o`030000003oool00000008000000P3oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo
0000000000000P3oool00`000000oooo00000002000000060?ooo`00000000000000003oool00000
0P3oool00`000000oooo0000000200000080oooo100000020?ooo`040000003oool00000000000<0
oooo0`0000030?ooo`040000003oool00000000000<0oooo0`0000020?ooo`030000003oool00000
008000000P3oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo0000000000000P3oool0
0`000000oooo00000002000000060?ooo`00000000000000003oool000000P3oool00`000000oooo
0000000200000080oooo100000020?ooo`040000003oool00000000000<0oooo0`0000030?ooo`04
0000003oool00000000000<0oooo0`0000020?ooo`030000003oool00000008000000P3oool01000
0000oooo0?ooo`0000020?ooo`80000000<0oooo0000000000000P3oool00`000000oooo00000002
000000030?ooo`000000oooo0040000000001P000000oooo0000003oool000000?ooo`@0000000D0
oooo0000003oool000000?ooo`0200000080oooo1@0000020?ooo`090000003oool000000000003o
ool000000?ooo`000000oooo0080000000<0oooo0000003oool00`0000000`3oool0000000000004
000000030?ooo`000000000000<0000000<0oooo000000000000100000000`3oool0000000000004
000000070?ooo`00000000000000003oool000000?ooo`04000000050?ooo`000000oooo0000003o
ool00P0000020?ooo`D000000P3oool02@000000oooo000000000000oooo0000003oool000000?oo
o`02000000030?ooo`000000oooo00<0000000<0oooo000000000000100000000`3oool000000000
0003000000030?ooo`000000000000@0000000<0oooo000000000000100000001`3oool000000000
00000000oooo0000003oool0100000001@3oool000000?ooo`000000oooo008000000P3oool50000
0080oooo00T000000?ooo`00000000000?ooo`000000oooo0000003oool00P0000000`3oool00000
0?ooo`03000000030?ooo`000000000000@0000000<0oooo0000000000000`0000000`3oool00000
00000004000000030?ooo`000000000000@0000000L0oooo00000000000000000?ooo`000000oooo
00@0000000D0oooo0000003oool000000?ooo`0200000080oooo1@0000020?ooo`090000003oool0
00000000003oool000000?ooo`000000oooo0080000000<0oooo0000003oool00`0000000`3oool0
000000000004000000030?ooo`000000000000<0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`00000000000080000000000`000000oooo0?ooo`020?ooo`@00000
0`3oool00`000000oooo000000030?ooo`@000000`3oool300000080oooo00D000000?ooo`000000
oooo000000020?ooo`060000003oool000000?ooo`000000oooo1@0000020?ooo`D0000000<0oooo
0000000000000`0000020?ooo`D000000P3oool3000000<0oooo100000030?ooo`030000003oool0
000000<0oooo100000030?ooo`<000000P3oool01@000000oooo0000003oool000000080oooo00H0
00000?ooo`000000oooo0000003oool500000080oooo1@0000000`3oool000000000000300000080
oooo1@0000020?ooo`<000000`3oool4000000<0oooo00<000000?ooo`0000000`3oool4000000<0
oooo0`0000020?ooo`050000003oool000000?ooo`0000000P3oool01P000000oooo0000003oool0
00000?ooo`D000000P3oool5000000030?ooo`000000000000<000000P3oool500000080oooo0`00
00030?ooo`@000000`3oool00`000000oooo000000030?ooo`@000000`3oool300000080oooo00D0
00000?ooo`000000oooo000000020?ooo`060000003oool000000?ooo`000000oooo1@0000020?oo
o`D0000000<0oooo0000000000000`0000020?ooo`D000000P3oool300000040oooo0@0000000003
0000003oool0oooo00<0000000@0oooo0000003oool0oooo100000000`3oool000000?ooo`020000
00050?ooo`000000oooo0000003oool00`0000000`3oool0000000000002000000050?ooo`000000
oooo0000003oool00P0000002@3oool000000?ooo`000000oooo0000003oool000000?ooo`020000
00050?ooo`000000oooo0000003oool00`0000000`3oool000000?ooo`04000000030?ooo`000000
oooo0080000000@0oooo0000003oool0oooo0`000000103oool000000?ooo`3oool4000000030?oo
o`000000oooo0080000000D0oooo0000003oool000000?ooo`03000000030?ooo`00000000000080
000000D0oooo0000003oool000000?ooo`02000000090?ooo`000000oooo0000003oool000000?oo
o`000000oooo0080000000D0oooo0000003oool000000?ooo`03000000030?ooo`000000oooo00@0
000000<0oooo0000003oool00P000000103oool000000?ooo`3oool3000000040?ooo`000000oooo
0?ooo`@0000000<0oooo0000003oool00P0000001@3oool000000?ooo`000000oooo00<0000000<0
oooo0000000000000P0000001@3oool000000?ooo`000000oooo0080000000T0oooo0000003oool0
00000?ooo`000000oooo0000003oool00P0000001@3oool000000?ooo`000000oooo00<0000000<0
oooo0000003oool0100000000`3oool000000?ooo`02000000040?ooo`000000oooo0?ooo`<00000
00@0oooo0000003oool0oooo100000000`3oool000000?ooo`02000000050?ooo`000000oooo0000
003oool00`0000000`3oool0000000000002000000050?ooo`000000oooo0000003oool00P000000
2@3oool000000?ooo`000000oooo0000003oool000000?ooo`02000000050?ooo`000000oooo0000
003oool00`0000000`3oool000000?ooo`04000000030?ooo`000000oooo0080000000@0oooo0000
003oool0oooo0@00000000030000003oool0000000l0000000<0oooo000000000000100000000`3o
ool000000000000m000000030?ooo`000000000000@0000000<0oooo000000000000?@0000000`3o
ool0000000000004000000030?ooo`000000000003d0000000<0oooo000000000000100000000`3o
ool000000000000_0000000000@000000?ooo`000000oooo1P0000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo000000000000500000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000000`0000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000001@0000000<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000000<0000000<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000D0000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000000000030000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo000000000000500000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000000`0000000`3oool00000000000030000
0040oooo0@00000000030000003oool0oooo0?l0oooo7@3oool100000000o`00000Q00000000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250052, \
0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["XSound", "\<\
000P0040800Z0E01K@5m0Gh1L@5G0C<12@7N0KL1V0650H01R@6Q0L<1k04G0D01
H@5g0Gl1N@5U0DD17@7a0LP1Y06<0H01P`6E0K81f@440Bh1D`5_0Gh1OP5_0E@1
;`450MX1/`6E0H@1P06;0J@1a`7`0A`1A05T0GT1O`5h0F81@@4H0Nd1a06Q0HX1
P0640IL1]P7M0@P1<P5G0G41OP5m0Fd1D@4[0@41eP6`0I<1P`600Hd1Y`7;0OD1
80570FL1NP5o0GH1G`4m0A@1j@700Il1R0600HH1VP6i0N41304f0EX1L`5o0G`1
J`5>0BL1o07B0J`1T@620H41S`6Z0Ll1n@4T0D/1J@5k0Gl1M05L0CT1407U0K`1
W0670H01Q`6L0Kd1i@4A0CX1G@5e0Gl1N`5Y0DX18`7h0Lh1Z@6?0H41PP6A0Jd1
d`7m0BP1CP5[0G`1O`5c0ET1=P4<0N01^@6I0HD1P0690Il1`@7Z0AD1?P5P0GH1
O`5j0FH1A`4O0O@1bP6V0Hd1P0630I<1/07G0@41;05B0Fh1O@5n0G41EP4b0@L1
g06e0IL1Q0600HX1XP750Nh16@520F81N05o0GP1H`530A/1k`760J<1R`600H@1
UP6d0M/11P4`0ED1L05n0Gd1KP5C0Bh10`7H0K81U0630H01S06U0LP1lP4M0DD1
I@5i0Gl1M`5Q0Cl15`7[0L81X0690H01Q@6H0KL1g`4:0C@1F05b0Gh1O@5/0Dl1
:P7o0M@1[P6B0H81P@6>0JP1c07f0B81B@5X0G/1O`5e0Eh1>`4B0NL1_P6M0HP1
P0660I/1^`7S0@h1>05K0G@1O`5l0FX1C04U0OX1d06[0I01P@610I01Z`7@0O/1
9P5<0FX1O05o0G@1F`4h0@h1h`6k0I/1QP600HP1WP6o0NL14`4l0Eh1M@5o0GX1
I`590B41mP7<0JP1SP610H81TP6_0M@1o`4Z0E01K05m0Gh1LP5H0C@12P7N0KL1
V0650H01R@6P0L81k04G0D01H@5g0Gl1N@5U0DD17@7b0LP1Y@6<0H01P`6D0K81
f0430Bh1D`5_0Gd1OP5`0ED1<0450MX1]06F0H@1P06;0J<1aP7`0A/1@`5T0GT1
O`5h0F81@@4I0Nd1a06R0HX1P0640IL1]@7M0@P1<P5F0G41OP5m0Fd1D@4/0@41
eP6`0I<1P`600Hd1YP7:0O@17`570FH1NP5o0GH1G`4n0AD1j@700Il1R0600HD1
V@6i0N41304f0ET1L`5o0G`1J`5>0BP1o@7B0Jd1T@620H41S`6Z0Lh1n04T0DX1
J@5k0Gl1M@5L0CX1407U0Kd1W0670H01Q`6L0Kd1i@4@0CX1G05e0Gl1N`5Y0DX1
907h0Lh1ZP6?0H41PP6A0Jd1dP7m0BP1CP5[0G`1O`5c0ET1=P4<0N41^@6I0HD1
P0680Il1`07Y0AD1?P5O0GH1O`5j0FH1A`4O0O@1bP6V0Hd1P0630I<1/07F0@41
;05A0Fd1O@5n0G41EP4b0@P1g@6e0IL1Q0600HX1XP740Nd16@510F81N05o0GT1
I0530A/1l0760J<1R`600H@1UP6d0MX11@4`0ED1L05n0Gd1K`5C0Bh10`7H0K81
U0630H01S06U0LP1lP4M0DD1I@5i0Gl1M`5Q0D015`7/0L81X0690H01Q@6H0KL1
gP4:0C@1F05b0Gh1O@5/0E01:P7o0M@1[`6B0H81P@6>0JP1c07f0B41B@5W0GX1
O`5e0Eh1?04C0NL1_`6N0HP1P0660I/1^`7S0@h1>05K0G@1O`5l0FX1C04V0O/1
d06[0I01P@610I01Z`7@0OX19@5<0FX1O05o0G@1F`4h0@h1h`6k0I/1QP600HP1
W@6n0NL14P4k0Eh1M@5o0G/1J0590B81mP7<0JP1SP610H81TP6^0M@1o`4Z0Dl1
K05m0Gh1LP5H0C@12P7O0KL1V0650H01R@6P0L81j`4G0Cl1H@5g0Gl1N@5U0DD1
7@7b0LP1Y@6<0H01P`6D0K81f0430Bh1D`5^0Gd1OP5`0ED1<0460M/1]06F0H@1
P06;0J<1aP7_0A/1@`5S0GP1O`5h0F81@P4I0Nh1a@6R0HX1P0640IL1]@7L0@L1
<P5F0G41OP5m0Fh1DP4/0@41e`6`0I<1P`600Hd1YP7:0O@17`570FH1NP5o0GH1
H04n0AD1jP710Il1R@600HD1V@6i0N01304f0ET1L`5o0G`1J`5>0BP1o@7C0Jd1
T@620H41S`6Y0Lh1n04S0DX1J@5k0Gl1M@5M0CX14@7U0Kd1W0670H01Q`6L0K`1
i@4@0CT1G05d0Gl1N`5Y0D/1907i0Ll1ZP6?0H41PP6A0J`1dP7l0BL1CP5[0G`1
O`5c0EX1=P4<0N41^@6J0HH1P0680Il1`07Y0A@1?@5O0GH1O`5j0FL1A`4P0OD1
b`6W0Hd1P0630I<1/07F0@41:`5A0Fd1O@5n0G41E`4b0@P1g@6f0IL1Q0600HX1
X@740Nd160510F81N05o0GT1I0540A`1l0770J@1R`600H@1U@6c0MX11@4_0E@1
K`5n0Gh1K`5C0Bh1107I0K81U@630H01S06T0LP1l@4M0DD1I@5i0Gl1M`5Q0D01
5`7/0L<1X@690H01Q@6H0KL1gP490C<1E`5a0Gh1O@5]0E01:P7o0MD1[`6B0H81
P@6>0JP1c07f0B41B05W0GX1O`5f0Eh1?04C0NP1_`6N0HP1P0660IX1^P7R0@h1
=`5K0G<1O`5l0FX1C@4V0O/1d@6/0I01P@610I01Z`7@0OX19@5<0FX1N`5o0G@1
F`4h0@l1h`6k0I/1QP600HL1W@6n0NL14P4k0Eh1M@5o0G/1J0590B81m`7=0JP1
SP610H81TP6^0M@1oP4Y0Dl1K05l0Gl1LP5H0C@12P7O0KP1V0650H01R@6P0L81
j`4F0Cl1H05g0Gl1N@5U0DH17P7c0LT1Y@6<0H01P`6D0K41f0430Bd1D`5^0Gd1
OP5`0ED1<0460M/1]06F0H@1P06;0J<1aP7_0AX1@`5S0GP1O`5h0F<1@P4J0Nh1
a@6R0HX1P0640IH1]@7L0@L1<@5F0G01OP5m0Fh1DP4/0@81e`6a0I@1P`600H`1
YP790O<17`560FH1NP5o0GH1H04n0AD1jP710Il1R@600HD1V@6h0N012`4e0ET1
LP5o0G`1K05?0BP1oP7C0Jd1T@620H41SP6Y0Ld1n04S0DX1J05k0Gl1M@5M0CX1
4@7V0Kd1W@670H01Q`6L0K`1i04@0CT1G05d0Gl1N`5Y0D/1907i0Ll1ZP6?0H41
PP6A0J`1d@7l0BL1C@5[0G`1O`5c0EX1=`4=0N81^P6J0HH1P0680Ih1`07X0A@1
?@5O0GH1O`5j0FL1B04P0OD1b`6W0Hd1P@620I<1/07E0@01:`5A0Fd1O@5n0G41
E`4c0@T1g@6f0IL1Q0600HX1X@740Nd160510F81M`5o0GT1I0540A`1l@770J@1
R`600H<1U@6c0MX11@4_0E@1K`5n0Gh1K`5D0Bl1107I0K<1U@630H01R`6T0LL1
l@4L0D@1I05i0Gl1M`5Q0D01607/0L<1X@6:0H01Q@6H0KH1gP490C<1E`5a0Gh1
O@5]0E01:`400MD1[`6C0H81P@6=0JL1b`7e0B41B05W0GX1O`5f0El1?@4C0NP1
_`6N0HP1P0660IX1^P7R0@d1=`5J0G<1O`5l0F/1C@4W0O`1d@6/0I01PP610Hl1
ZP7?0OX19@5;0FT1N`5o0G@1G04i0@l1i06l0I/1QP600HL1W@6n0NH14P4k0Ed1
M@5o0G/1J05:0B81m`7=0JT1SP610H81TP6^0M<1oP4Y0Dl1K05l0Gl1LP5I0CD1
2`7P0KP1V@650H01R@6P0L41jP4F0Cl1H05g0Gl1NP5V0DH17P7c0LT1YP6<0H01
P`6D0K41e`420Bd1DP5^0Gd1OP5`0ED1<@470M/1]@6F0H@1P06:0J<1a@7_0AX1
@P5S0GP1O`5h0F<1@P4J0Nl1a@6S0HX1P0640IH1]@7K0@L1<@5E0G01OP5m0Fh1
DP4]0@81e`6a0I@1P`600H`1YP790O<17P560FH1NP5o0GL1H04o0AH1jP710J01
R@600HD1V@6h0N012`4e0ET1LP5o0G`1K05?0BT1oP7C0Jh1TP620H41SP6Y0Ld1
m`4R0DX1J05k0Gl1M@5M0C/14P7V0Kh1W@670H01QP6K0K`1i04?0CT1G05d0Gl1
N`5Y0D/19@7j0Ll1ZP6?0H41PP6@0J`1d@7l0BL1C@5[0G`1O`5c0EX1=`4=0N81
^P6J0HH1P0680Ih1_`7X0A<1?@5O0GH1O`5j0FL1B04Q0OD1b`6W0Hd1P@620I<1
[`7E0@01:`5@0Fd1O@5n0G41E`4c0@T1gP6f0IP1Q@600HX1X@730N`160500F41
M`5o0GT1I0540A`1l@770J@1R`600H<1U@6c0MT1104_0E@1K`5n0Gh1K`5D0Bl1
1@7J0K<1U@630H01R`6T0LL1l@4L0D@1I05i0Gl1M`5R0D41607]0L@1X@6:0H01
Q06G0KH1g@490C<1E`5a0Gh1O@5]0E41:`400MD1/06C0H81P@6=0JL1b`7e0B01
B05W0GX1O`5f0El1?@4D0NP1`06N0HP1P0660IX1^P7R0@d1=`5J0G<1O`5l0F/1
C@4W0O`1d@6/0I41PP610Hl1ZP7?0OT1905;0FT1N`5o0G@1G04i0A01i06l0I`1
Q`600HL1W@6m0NH14@4j0Ed1M@5o0G/1J05:0B<1n07=0JT1SP610H81T@6]0M<1
oP4X0Dl1K05l0Gl1LP5I0CD12`7P0KP1V@650H01R@6O0L41jP4E0Ch1H05f0Gl1
NP5V0DH17`7c0LT1YP6<0H01P`6D0K41e`420B`1DP5^0Gd1OP5`0EH1<@470M`1
]@6F0H@1P06:0J81a@7^0AX1@P5S0GP1O`5h0F<1@`4J0Nl1aP6S0H/1P0640IH1
]07K0@H1<05E0G01OP5m0Fh1D`4]0@<1f06a0I@1P`600H`1Y@790O<17P560FD1
N@5o0GL1H04o0AH1j`720J01R@600HD1V06h0Ml12P4d0EP1LP5o0G`1K05?0BT1
oP7D0Jh1TP620H41SP6X0Ld1m`4R0DT1J05k0Gl1M@5N0C/14P7W0Kh1W@670H01
QP6K0K/1h`4?0CP1F`5d0Gl1N`5Z0D`19@7j0M01Z`6@0H41P@6@0J`1d@7k0BH1
C@5Z0G`1O`5c0E/1=`4>0N81^P6J0HH1P0680Ih1_`7X0A<1?05N0GH1O`5j0FL1
B04Q0OH1c06X0Hh1P@620I81[`7E0Ol1:P5@0Fd1O@5n0G41E`4c0@T1gP6g0IP1
Q@600HT1X@730N`15`500F41M`5o0GT1I@550Ad1l@780J@1S0600H<1U@6b0MT1
104^0E<1K`5n0Gh1K`5D0Bl11@7J0K<1U@640H01R`6T0LL1l04L0D@1I05i0Gl1
N05R0D41607]0L@1X@6:0H01Q06G0KH1g@480C81E`5a0Gh1O@5]0E41:`410MH1
/06C0H<1P06=0JL1b`7e0B01A`5W0GX1O`5f0El1?@4D0NT1`06O0HP1P0660IX1
^@7Q0@`1=P5J0G<1O`5l0F/1CP4W0O`1dP6/0I41PP610Hl1ZP7?0OT1905;0FT1
N`5o0G@1G04i0A01i@6l0I`1Q`600HL1W06m0ND14@4j0Ed1M@5o0G/1J@5:0B<1
n07>0JT1S`610H81T@6]0M<1o@4X0Dh1J`5l0Gl1L`5I0CH1307P0KT1V@650H01
R@6O0L41jP4E0Ch1H05f0Gl1NP5V0DL17`7d0LX1YP6=0H01P`6C0K01e`410B`1
DP5^0Gd1OP5a0EH1<P470M`1]@6G0H@1P06:0J81a@7^0AT1@P5R0GP1O`5h0F<1
@`4K0Nl1aP6S0H/1P0640IH1]07K0@H1<05E0G01OP5m0Fh1D`4^0@<1f06b0I@1
P`600H`1Y@780O817@550FD1N@5o0GL1H@4o0AL1j`720J01R@600HD1V06g0Ml1
2P4d0EP1LP5n0Gd1K05?0BX1o`7D0Jh1TP620H41SP6X0L`1mP4R0DT1J05k0Gl1
M@5N0C/14P7W0Kh1W@680H01QP6K0K/1h`4>0CP1F`5d0Gl1O05Z0D`19@7j0M01
Z`6@0H41P@6@0J/1d07k0BH1C05Z0G`1O`5d0E/1>04>0N<1^`6K0HH1P0680Ih1
_`7W0A<1?05N0GD1O`5j0FL1B@4Q0OH1c06X0Hh1P@620I81[`7D0Ol1:P5@0F`1
O@5n0G81F04d0@X1gP6g0IP1Q@600HT1X0720N`15`500F41M`5o0GT1I@550Ad1
lP780JD1S0600H<1U06b0MP10`4^0E<1K`5m0Gh1L05E0C011@7J0K@1UP640H01
R`6S0LH1l04K0D<1I05i0Gl1N05R0D416@7]0L@1XP6:0H01Q06G0KD1g@480C81
EP5a0Gh1O@5]0E41;0410MH1/06C0H<1P06=0JH1bP7d0Al1A`5V0GX1O`5f0El1
?P4E0NT1`06O0HP1P0650IT1^@7Q0@`1=P5I0G<1O`5l0F/1CP4X0Od1dP6]0I41
PP610Hl1ZP7>0OP1905:0FT1N`5o0GD1G04j0A01i@6m0I`1Q`600HL1W06m0ND1
404j0E`1M@5o0G/1J@5:0B@1n07>0JX1S`610H81T@6]0M81o@4X0Dh1J`5l0Gl1
L`5I0CH1307Q0KT1V@650H01R06O0L01j@4E0Ch1G`5f0Gl1NP5V0DL17`7d0LX1
YP6=0H01P`6C0K01eP410B`1D@5]0Gd1OP5a0EH1<P480Md1]@6G0H@1P06:0J81
a07]0AT1@@5R0GP1O`5i0F@1@`4K0O01aP6S0H/1P0640IH1]07J0@D1<05E0G01
OP5m0Fl1D`4^0@<1f06b0I@1P`600H`1Y@780O817@550FD1N@5o0GL1H@500AL1
k0720J01R@600HD1V06g0Mh12P4d0EP1LP5n0Gd1K05@0BX1o`7D0Jl1TP620H41
SP6X0L`1mP4Q0DT1I`5j0Gl1M@5N0C`14`7W0Kl1WP680H01QP6K0K/1h`4>0CP1
F`5d0Gl1O05Z0D`19P7k0M01Z`6@0H41P@6@0J/1d07j0BD1C05Z0G`1O`5d0E/1
>04>0N<1^`6K0HH1P0680Id1_P7W0A81>`5N0GD1O`5k0FP1B@4R0OH1c06X0Hh1
P@620I81[P7D0Ol1:P5?0F`1O@5n0G81F04d0@X1g`6g0IP1Q@600HT1X0720N/1
5`4o0F41M`5o0GT1I@550Ad1lP780JD1S0600H<1U06b0MP10`4^0E<1KP5m0Gh1
L05E0C011P7K0K@1UP640H01R`6S0LH1k`4K0D<1H`5h0Gl1N05R0D816@7^0LD1
XP6:0H01Q06G0KD1g0470C81EP5a0Gh1O@5^0E81;0410ML1/06C0H<1P06=0JH1
bP7d0Al1A`5V0GX1O`5f0F01?P4E0NX1`@6O0HT1P0650IT1^@7P0@`1=P5I0G<1
O`5l0F/1CP4X0Od1d`6]0I41PP610Hl1Z@7>0OP18`5:0FT1N`5o0GD1G@4j0A41
i@6m0I`1Q`600HL1W06l0ND1404i0E`1M05o0G/1J@5;0B@1n@7?0JX1S`610H81
T@6/0M81o04W0Dh1J`5l0Gl1L`5J0CH1307Q0KT1VP660H01R06O0L01j@4D0Cd1
G`5f0Gl1NP5W0DL1807e0L/1Y`6=0H01P`6C0K01eP410B/1D@5]0Gd1OP5a0EL1
<P480Md1]P6G0H@1P06:0J41a07]0AP1@@5R0GP1O`5i0F@1A04L0O01a`6T0H/1
P0640ID1/`7J0@D1;`5D0Fl1OP5n0Fl1D`4^0@@1f@6b0ID1P`600H`1Y0780O41
7@550FD1N@5o0GL1H@500AL1k0730J41R@600HD1V06g0Mh12@4c0EL1L@5n0Gd1
K@5@0BX1o`7E0Jl1TP620H41SP6X0L`1mP4Q0DP1I`5j0Gl1MP5N0C`14`7X0Kl1
WP680H01QP6J0KX1hP4>0CL1F`5c0Gl1O05Z0Dd19P7k0M41[06@0H41P@6@0J/1
d07j0BD1C05Z0G/1O`5d0E/1>04?0N<1^`6K0HH1P0670Id1_P7W0A81>`5N0GD1
O`5k0FP1B@4R0OL1c@6X0Hh1P@620I81[P7D0Oh1:@5?0F`1O05o0G81F04d0@X1
g`6h0IP1Q@600HT1X0720N/15P4o0F01M`5o0GT1I@560Ah1l`790JD1S0600H<1
U06a0MP10`4]0E<1KP5m0Gh1L05E0C011P7K0K@1UP640H01R`6S0LH1k`4J0D<1
H`5h0Gl1N05S0D816P7^0LD1XP6:0H01Q06F0KD1g0470C41EP5`0Gh1O@5^0E81
;0420ML1/@6D0H<1P06<0JH1b@7c0Al1AP5V0GX1O`5f0F01?P4E0NX1`@6O0HT1
P0650IT1^07P0@/1=@5I0G81O`5l0F`1C`4X0Oh1d`6]0I41PP610Hh1Z@7=0OP1
8`5:0FP1N`5o0GD1G@4j0A41iP6m0Id1Q`600HL1W06l0N@1404i0E`1M05o0G/1
J@5;0B@1n@7?0JX1S`610H81T@6/0M41o04W0Dd1J`5l0Gl1L`5J0CL13@7R0KX1
VP660H01R06N0L01j04D0Cd1G`5f0Gl1NP5W0DP1807e0L/1Y`6=0H41PP6C0K01
e@400B/1D@5]0Gd1OP5a0EL1<`490Md1]P6G0H@1P06:0J41a07]0AP1@@5R0GL1
O`5i0F@1A04L0O41a`6T0H/1P0630ID1/`7J0@D1;`5D0Fl1OP5n0Fl1E04_0@@1
f@6c0ID1P`600H/1Y0770O4170540F@1N@5o0GL1H@500AP1k0730J41RP600HD1
V06f0Mh12@4c0EL1L@5n0Gd1K@5@0B/1007E0Jl1T`620H41S@6W0L/1m@4Q0DP1
I`5j0Gl1MP5O0Cd14`7X0Kl1WP680H01QP6J0KX1hP4=0CL1FP5c0Gl1O05[0Dd1
9`7l0M41[06@0H81P@6?0JX1c`7j0BD1B`5Y0G/1O`5d0E`1>@4?0N@1_06K0HH1
P0670Id1_P7V0A81>`5M0GD1O`5k0FP1BP4R0OL1c@6Y0Hh1P@620I81[P7C0Oh1
:@5?0F`1O05o0G81F@4e0@/1h06h0IT1Q@600HT1X0710NX15P4o0F01M`5o0GX1
IP560Ah1l`790JH1S0600H<1U06a0ML10P4]0E81KP5m0Gh1L05E0C411`7K0KD1
UP640H01RP6S0LD1k`4J0D81H`5h0Gl1N05S0D816P7_0LD1X`6:0H01Q06F0KD1
f`470C41E@5`0Gh1O@5^0E81;@420ML1/@6D0H<1P06<0JH1b@7c0Ah1AP5V0GX1
O`5g0F01?`4F0NX1`@6P0HT1P0650IT1^07P0@/1=@5I0G81O`5l0F`1C`4Y0Oh1
d`6^0I81PP610Hh1Z@7=0OL18P5:0FP1N`5o0GD1G@4k0A81iP6n0Id1Q`600HH1
V`6l0N@13`4i0E`1M05o0G/1J@5;0BD1nP7?0JX1S`610H81T06/0M41o04W0Dd1
J`5l0Gl1L`5J0CL13@7R0KX1VP660H01R06N0Kl1j04C0Cd1G`5f0Gl1NP5W0DP1
8@7e0L/1Y`6=0H41PP6C0Jl1e@400B/1D05]0Gd1OP5a0EL1<`490Mh1]P6H0HD1
P06:0J41``7/0AP1@05Q0GL1O`5i0F@1A04L0O41a`6T0H/1P0630ID1/`7I0@@1
;`5D0Fl1OP5n0Fl1E04_0@D1fP6c0ID1P`600H/1Y0770O4170540F@1N@5o0GL1
HP510AP1k@740J41RP600H@1U`6f0Md12@4c0EL1L@5n0Gd1K@5A0B/1007E0K01
T`620H41S@6W0L/1m@4P0DP1I`5j0Gl1MP5O0Cd1507X0L01WP680H01QP6J0KX1
hP4=0CL1FP5c0Gl1O05[0Dd19`7l0M41[06A0H81P@6?0JX1c`7i0B@1B`5Y0G/1
O`5d0E`1>@4@0N@1_06L0HL1P0670Id1_@7V0A41>P5M0GD1O`5k0FP1BP4S0OP1
c@6Y0Hh1P@620I41[@7C0Oh1:05?0F`1O05o0G81F@4e0@/1h06h0IT1Q@600HT1
W`710NX15@4n0F01MP5o0GX1IP560Al1l`790JH1S0600H<1U06a0ML10P4/0E81
KP5m0Gh1L05F0C411`7L0KD1UP640H01RP6R0LD1kP4J0D81H`5h0Gl1N05S0D<1
6P7_0LH1X`6;0H01Q06F0K@1f`460C01E@5`0Gh1O@5^0E<1;@430MP1/@6D0H<1
P06<0JD1b@7c0Ah1AP5U0GT1O`5g0F01?`4F0N/1`P6P0HT1P0650IP1^07O0@X1
=05H0G81O`5l0F`1C`4Y0Oh1e06^0I81PP610Hh1Z07=0OL18P590FP1N`5o0GD1
GP4k0A81i`6n0Id1Q`600HH1V`6k0N<13`4h0E/1M05o0G/1JP5<0BD1nP7@0J/1
T0610H41T06/0M41n`4V0Dd1JP5l0Gl1L`5K0CL13P7R0KX1VP660H01R06N0Kl1
j04C0C`1GP5f0Gl1NP5W0DP18@7f0L`1Z06>0H41PP6B0Jl1e@7o0BX1D05]0Gd1
OP5a0EL1<`490Mh1]`6H0HD1P0690J41``7/0AL1@05Q0GL1O`5i0FD1A@4M0O41
b06T0H`1P0630ID1/P7I0@@1;P5C0Fl1OP5n0Fl1E04_0@D1fP6c0ID1Q0600H/1
Y0770O0170540F@1N@5o0GP1HP510AP1k@740J41RP600H@1U`6f0Md1204b0EL1
L@5n0Gd1K@5A0B/10@7F0K01T`630H01S@6W0L/1m@4P0DL1I`5j0Gl1MP5O0Cd1
507Y0L01W`680H01QP6J0KT1h@4<0CH1FP5c0Gl1O05[0Dh19`7l0M81[06A0H81
P@6?0JX1c`7i0B@1B`5Y0G/1O`5d0E`1>@4@0ND1_06L0HL1P0670I`1_@7U0A41
>P5M0GD1O`5k0FT1BP4S0OP1cP6Y0Hl1P@620I41[@7C0Od1:05>0F/1O05o0G<1
F@4f0@`1h06i0IT1Q@600HT1W`710NX15@4n0F01MP5o0GX1IP570Al1m07:0JH1
S@600H<1T`6`0ML10@4/0E81KP5m0Gh1L@5F0C811`7L0KD1U`640H01RP6R0LD1
kP4I0D81HP5h0Gl1N05S0D<16`7_0LH1X`6;0H01Q06F0K@1f`460C01E@5`0Gh1
O@5^0E<1;P430MP1/P6D0H<1P06<0JD1b07b0Ad1A@5U0GT1O`5g0F41?`4G0N/1
`P6P0HT1P0650IP1]`7O0@X1=05H0G81OP5m0F`1C`4Z0Ol1e06^0I81PP610Hh1
Z07<0OH18P590FP1N`5o0GD1GP4k0A81i`6n0Id1R0600HH1V`6k0N<13P4h0E/1
M05o0G`1JP5<0BD1nP7@0J/1T0610H41T06[0M01n`4V0D`1JP5l0Gl1M05K0CP1
3P7S0K/1V`660H01R06N0Kl1i`4C0C`1GP5e0Gl1NP5W0DT18@7f0L`1Z06>0H41
PP6B0Jl1e07o0BX1D05/0Gd1OP5b0EP1=04:0Mh1]`6H0HD1P0690J01`P7/0AL1
@05Q0GL1O`5i0FD1A@4M0O81b06U0H`1P0630I@1/P7H0@<1;P5C0Fl1O@5n0G01
E@4`0@D1fP6d0IH1Q0600H/1X`760O016`530F@1N@5o0GP1HP510AT1k@740J81
RP600H@1U`6e0Md1204b0EH1L@5n0Gd1K@5A0B`10@7F0K01T`630H01S@6V0LX1
m04O0DL1IP5j0Gl1MP5O0Ch15@7Y0L01W`680H01Q@6I0KT1h@4<0CH1F@5c0Gl1
O05[0Dh1:07m0M81[@6A0H81P@6?0JX1cP7h0B@1BP5Y0G/1O`5e0E`1>P4@0ND1
_@6L0HL1P0670I`1_@7U0A01>P5L0GD1O`5k0FT1BP4T0OP1cP6Z0Hl1P@620I41
[@7B0Od1:05>0F/1O05o0G<1F@4f0@`1h@6i0IT1Q@600HP1W`700NT15@4n0El1
MP5o0GX1IP570Al1m07:0JH1S@600H<1T`6`0MH10@4/0E41K@5m0Gh1L@5F0C81
207M0KD1U`640H01RP6R0L@1k@4I0D41HP5h0Gl1N@5T0D<16`7`0LH1X`6;0H01
Q06F0K@1fP450C01E@5`0Gh1O@5_0E<1;P430MP1/P6D0H<1P06<0JD1b07b0Ad1
A@5U0GT1O`5g0F41@04G0N`1`P6P0HT1P0650IP1]`7N0@X1=05H0G81OP5m0F`1
D04Z0Ol1e06_0I81PP610Hh1Z07<0OH18@590FL1NP5o0GD1GP4l0A<1i`6o0Ih1
R0600HH1V`6k0N<13P4h0E/1M05o0G`1JP5<0BH1n`7@0J/1T0610H41T06[0M01
nP4U0D`1JP5l0Gl1M05K0CP13P7S0K/1V`660H01R06M0Kh1i`4B0C/1GP5e0Gl1
N`5X0DT18P7f0L`1Z06>0H41PP6B0Jh1e07o0BX1C`5/0Gd1OP5b0EP1=04:0Ml1
]`6H0HD1P0690J01`P7[0AL1?`5Q0GL1O`5i0FD1A@4M0O81b06U0H`1P0630I@1
/P7H0@<1;P5C0Fh1O@5n0G01E@4`0@H1f`6d0IH1Q0600H/1X`760Nl16`530F<1
N05o0GP1HP520AT1kP750J81RP600H@1U`6e0M`11`4b0EH1L@5n0Gd1KP5B0B`1
0@7G0K01T`630H01S@6V0LX1m04O0DL1IP5j0Gl1MP5P0Ch15@7Z0L41W`690H01
Q@6I0KT1h04<0CH1F@5c0Gl1O05[0Dh1:07m0M<1[@6A0H81P@6?0JT1cP7h0B<1
BP5Y0G/1O`5e0Ed1>P4A0ND1_@6L0HL1P0670I`1_07U0A01>@5L0G@1O`5k0FT1
B`4T0OT1c`6Z0Hl1P@620I41[07B0O`19`5>0F/1O05o0G<1FP4f0@`1h@6i0IX1
QP600HP1W`700NT1504m0El1MP5o0GX1I`570B01m@7;0JL1S@600H<1T`6`0MH1
0@4[0E41K@5m0Gh1L@5G0C81207M0KH1U`640H01RP6Q0L@1k@4H0D41HP5h0Gl1
N@5T0D@1707`0LL1Y06;0H01Q06E0K<1fP450Bl1E05_0Gh1OP5_0E<1;P440MT1
/P6E0H<1P06<0J@1b07a0Ad1A@5U0GT1O`5g0F41@04G0N`1``6Q0HT1P0650IP1
]`7N0@T1<`5G0G41OP5m0Fd1D04Z0Ol1e@6_0I81PP610Hh1Z07<0OH18@580FL1
NP5o0GH1GP4l0A<1j06o0Ih1R0600HH1VP6j0N813P4g0E/1L`5o0G`1JP5=0BH1
n`7A0J`1T0610H41T06[0M01nP4U0D`1JP5k0Gl1M05K0CP13`7S0K/1V`660H01
Q`6M0Kh1i`4B0C/1GP5e0Gl1N`5X0DT18P7g0Ld1Z06>0H41PP6B0Jh1e07n0BT1
C`5/0G`1O`5b0EP1=04:0Ml1^06H0HD1P0690J01`P7[0AH1?`5P0GL1O`5i0FD1
AP4N0O<1b@6U0H`1P0630I@1/@7H0@<1;@5C0Fh1O@5n0G01E@4`0@H1f`6d0IH1
Q0600H/1X`760Nl16P530F<1N05o0GP1H`520AX1kP750J81RP600H@1UP6e0M`1
1`4a0EH1L05n0Gd1KP5B0B`10P7G0K41U0630H01S06V0LT1l`4O0DH1IP5j0Gl1
MP5P0Ch15@7Z0L41W`690H01Q@6I0KP1h04;0CD1F@5b0Gl1O05/0Dl1:07n0M<1
[@6A0H81P@6>0JT1c@7h0B<1BP5X0G/1O`5e0Ed1>P4A0NH1_@6M0HL1P0670I`1
_07T0A01>@5L0G@1O`5k0FT1B`4T0OT1c`6Z0Hl1P@620I41[07A0O`19`5=0F/1
O05o0G<1FP4g0@d1hP6j0IX1QP600HP1WP700NP1504m0El1MP5o0GX1I`580B01
m@7;0JL1S@610H81T`6`0MD1004[0E41K@5m0Gh1L@5G0C<12@7M0KH1U`640H01
RP6Q0L@1k@4H0D41HP5g0Gl1N@5T0D@1707a0LL1Y06;0H01P`6E0K<1fP450Bl1
E05_0Gh1OP5_0E@1;`440MT1/`6E0H<1P06;0J@1a`7a0A`1A05T0GT1O`5g0F41
@04H0N`1``6Q0HX1P0650IP1]P7N0@T1<`5G0G41OP5m0Fd1D04[0@01e@6_0I<1
PP610Hd1Y`7;0OD18@580FL1NP5o0GH1G`4m0A<1j06o0Ih1R0600HH1VP6j0N81
3@4g0EX1L`5o0G`1J`5=0BL1o07A0J`1T0620H41S`6Z0Ll1nP4U0D/1J@5k0Gl1
M05L0CT13`7T0K`1V`660H01Q`6M0Kh1iP4B0C/1G@5e0Gl1N`5X0DX18P7g0Ld1
Z@6>0H41PP6B0Jh1d`7n0BT1C`5/0G`1O`5b0ET1=@4;0N01^06I0HD1P0690J01
`@7Z0AH1?`5P0GL1O`5j0FH1AP4N0O<1b@6V0H`1P0630I@1/@7G0@81;@5B0Fh1
O@5n0G01E@4a0@L1f`6e0IH1Q0600HX1X`750Nl16P520F<1N05o0GP1H`520AX1
k`750J<1RP600H@1UP6e0M/11`4a0ED1L05n0Gd1KP5B0Bd10P7G0K41U0630H01
S06V0LT1l`4N0DH1IP5j0Gl1M`5P0Cl15P7Z0L41X0690H01Q@6I0KP1h04;0CD1
F@5b0Gl1O05/0Dl1:@7n0M<1[P6B0H81P@6>0JT1c@7g0B81BP5X0G/1O`5e0Ed1
>`4B0NH1_P6M0HL1P0660I/1_07T0@l1>@5L0G@1O`5k0FT1B`4U0OX1c`6Z0Hl1
P@620I01[07A0O`19`5=0F/1O05o0G<1FP4g0@d1hP6j0IX1QP600HP1WP6o0NP1
4`4m0El1MP5o0GX1I`580B41m@7;0JL1S@610H81T`6_0MD1004[0E01K@5m0Gh1
L@5G0C<12@7N0KH1V0650H01RP6Q0L<1k04H0D01H@5g0Gl1N@5T0D@1707a0LL1
Y06;0H01P`6E0K<1f@440Bl1E05_0Gh1OP5_0E@1;`450MX1/`6E0H<1P06;0J@1
a`7a0A`1A05T0GT1O`5g0F81@@4H0Nd1a06Q0HX1P0640IL1]P7M0@T1<`5G0G41
OP5m0Fd1D@4[0@01e@6`0I<1PP610Hd1Y`7;0OD180580FL1NP5o0GH1G`4m0A@1
j0700Ih1R0600HH1VP6j0N813@4g0EX1L`5o0G`1J`5=0BL1o07A0J`1T@620H41
S`6Z0Ll1n@4T0D/1J@5k0Gl1M05L0CT1407T0K`1W0670H01Q`6M0Kd1iP4A0CX1
G@5e0Gl1N`5X0DX18`7h0Ld1Z@6>0H41PP6A0Jd1d`7n0BP1C`5/0G`1O`5b0ET1
=@4;0N01^06I0HD1P0690Il1`@7Z0AD1?P5P0GH1O`5j0FH1AP4O0O<1b@6V0H`1
P0630I@1/@7G0@81;05B0Fh1O@5n0G01EP4a0@L1g06e0IH1Q0600HX1XP750Nh1
6P520F<1N05o0GP1H`530AX1k`760J<1R`600H@1UP6d0M/11P4`0ED1L05n0Gd1
KP5C0Bd10`7H0K41U0630H01S06U0LT1l`4N0DH1I@5i0Gl1M`5P0Cl15P7[0L81
X0690H01Q@6H0KP1g`4:0C@1F05b0Gl1O05/0Dl1:@7n0M@1[P6B0H81P@6>0JP1
c@7g0B81B@5X0G/1O`5e0Eh1>`4B0NL1_P6M0HL1P0660I/1^`7S0@l1>05K0G@1
O`5k0FX1C04U0OX1d06[0I01P@610I01[07A0O/19P5=0FX1O05o0G<1F`4g0@h1
hP6j0IX1QP600HP1WP6o0NP14`4l0Eh1MP5o0GX1I`580B41mP7<0JP1SP610H81
TP6_0MD1o`4Z0E01K@5m0Gh1L@5G0C<12@7N0KL1V0650H01R@6Q0L<1k04G0D01
H@5g0Gl1N@5U0DD17@7a0LP1Y06<0H01P`6E0K81f@440Bh1D`5_0Gh1OP5_0E@1
;`450MX1/`6E0H@1P06;0J@1a`7`0A`1A05T0GT1O`5h0F81@@4H0Nd1a06Q0HX1
P0640IL1]P7M0@P1<P5G0G41OP5m0Fd1D@4[0@41eP6`0I<1P`600Hd1Y`7;0OD1
80570FL1NP5o0GH1G`4m0A@1j@700Il1R0600HH1VP6i0N41304f0EX1L`5o0G`1
J`5>0BL1o07B0J`1T@620H41S`6Z0Ll1n@4T0D/1J@5k0Gl1M05L0CT1407U0K`1
W0670H01Q`6L0Kd1i@4A0CX1G@5e0Gl1N`5Y0DX18`7h0Lh1Z@6?0H41PP6A0Jd1
d`7m0BP1CP5[0G`1O`5c0ET1=P4<0N01^@6I0HD1P0690Il1`@7Z0AD1?P5P0GH1
O`5j0FH1A`4O0O@1bP6V0Hd1P0630I<1/07G0@41;05B0Fh1O@5n0G41EP4b0@L1
g06e0IL1Q0600HX1XP750Nh16@520F81N05o0GP1H`530A/1k`760J<1R`600H@1
UP6d0M/11P4`0ED1L05n0Gd1KP5C0Bh10`7H0K81U0630H01S06U0LP1lP4M0DD1
I@5i0Gl1M`5Q0Cl15`7[0L81X0690H01Q@6H0KL1g`4:0C@1F05b0Gh1O@5/0Dl1
:P7o0M@1[P6B0H81P@6>0JP1c07f0B81B@5X0G/1O`5e0Eh1>`4B0NL1_P6M0HP1
P0660I/1^`7S0@h1>05K0G@1O`5l0FX1C04U0OX1d06[0I01P@610I01Z`7@0O/1
9P5<0FX1O05o0G@1F`4h0@h1h`6k0I/1QP600HP1WP6o0NL14`4l0Eh1M@5o0GX1
I`590B41mP7<0JP1SP610H81TP6_0M@1o`4Z0E01K05m0Gh1LP5H0C@12P7N0KL1
V0650H01R@6P0L81k04G0D01H@5g0Gl1N@5U0DD17@7b0LP1Y@6<0H01P`6D0K81
f0430Bh1D`5_0Gd1OP5`0ED1<0450MX1]06F0H@1P06;0J<1aP7`0A/1@`5T0GT1
O`5h0F81@@4I0Nd1a06R0HX1P0640IL1]@7M0@P1<P5F0G41OP5m0Fd1D@4/0@41
eP6`0I<1P`600Hd1YP7:0O@17`570FH1NP5o0GH1G`4n0AD1j@700Il1R0600HD1
V@6i0N41304f0ET1L`5o0G`1J`5>0BP1o@7B0Jd1T@620H41S`6Z0Lh1n04T0DX1
J@5k0Gl1M@5L0CX1407U0Kd1W0670H01Q`6L0Kd1i@4@0CX1G05e0Gl1N`5Y0DX1
907h0Lh1ZP6?0H41PP6A0Jd1dP7m0BP1CP5[0G`1O`5c0ET1=P4<0N41^@6I0HD1
P0680Il1`07Y0AD1?P5O0GH1O`5j0FH1A`4O0O@1bP6V0Hd1P0630I<1/07F0@41
;05A0Fd1O@5n0G41EP4b0@P1g@6e0IL1Q0600HX1XP740Nd16@510F81N05o0GT1
I0530A/1l0760J<1R`600H@1UP6d0MX11@4`0ED1L05n0Gd1K`5C0Bh10`7H0K81
U0630H01S06U0LP1lP4M0DD1I@5i0Gl1M`5Q0D015`7/0L81X0690H01Q@6H0KL1
gP4:0C@1F05b0Gh1O@5/0E01:P7o0M@1[`6B0H81P@6>0JP1c07f0B41B@5W0GX1
O`5e0Eh1?04C0NL1_`6N0HP1P0660I/1^`7S0@h1>05K0G@1O`5l0FX1C04V0O/1
d06[0I01P@610I01Z`7@0OX19@5<0FX1O05o0G@1F`4h0@h1h`6k0I/1QP600HP1
W@6n0NL14P4k0Eh1M@5o0G/1J0590B81mP7<0JP1SP610H81TP6^0M@1o`4Z0Dl1
K05m0Gh1LP5H0C@12P7O0KL1V0650H01R@6P0L81j`4G0Cl1H@5g0Gl1N@5U0DD1
7@7b0LP1Y@6<0H01P`6D0K81f0430Bh1D`5^0Gd1OP5`0ED1<0460M/1]06F0H@1
P06;0J<1aP7_0A/1@`5S0GP1O`5h0F81@P4I0Nh1a@6R0HX1P0640IL1]@7L0@L1
<P5F0G41OP5m0Fh1DP4/0@41e`6`0I<1P`600Hd1YP7:0O@17`570FH1NP5o0GH1
H04n0AD1jP710Il1R@600HD1V@6i0N01304f0ET1L`5o0G`1J`5>0BP1o@7C0Jd1
T@620H41S`6Y0Lh1n04S0DX1J@5k0Gl1M@5M0CX14@7U0Kd1W0670H01Q`6L0K`1
i@4@0CT1G05d0Gl1N`5Y0D/1907i0Ll1ZP6?0H41PP6A0J`1dP7l0BL1CP5[0G`1
O`5c0EX1=P4<0N41^@6J0HH1P0680Il1`07Y0A@1?@5O0GH1O`5j0FL1A`4P0OD1
b`6W0Hd1P0630I<1/07F0@41:`5A0Fd1O@5n0G41E`4b0@P1g@6f0IL1Q0600HX1
X@740Nd160510F81N05o0GT1I0540A`1l0770J@1R`600H@1U@6c0MX11@4_0E@1
K`5n0Gh1K`5C0Bh1107I0K81U@630H01S06T0LP1l@4M0DD1I@5i0Gl1M`5Q0D01
5`7/0L<1X@690H01Q@6H0KL1gP490C<1E`5a0Gh1O@5]0E01:P7o0MD1[`6B0H81
P@6>0JP1c07f0B41B05W0GX1O`5f0Eh1?04C0NP1_`6N0HP1P0660IX1^P7R0@h1
=`5K0G<1O`5l0FX1C@4V0O/1d@6/0I01P@610I01Z`7@0OX19@5<0FX1N`5o0G@1
F`4h0@l1h`6k0I/1QP600HL1W@6n0NL14P4k0Eh1M@5o0G/1J0590B81m`7=0JP1
SP610H81TP6^0M@1oP4Y0Dl1K05l0Gl1LP5H0C@12P7O0KP1V0650H01R@6P0L81
j`4F0Cl1H05g0Gl1N@5U0DH17P7c0LT1Y@6<0H01P`6D0K41f0430Bd1D`5^0Gd1
OP5`0ED1<0460M/1]06F0H@1P06;0J<1aP7_0AX1@`5S0GP1O`5h0F<1@P4J0Nh1
a@6R0HX1P0640IH1]@7L0@L1<@5F0G01OP5m0Fh1DP4/0@81e`6a0I@1P`600H`1
YP790O<17`560FH1NP5o0GH1H04n0AD1jP710Il1R@600HD1V@6h0N012`4e0ET1
LP5o0G`1K05?0BP1oP7C0Jd1T@620H41SP6Y0Ld1n04S0DX1J05k0Gl1M@5M0CX1
4@7V0Kd1W@670H01Q`6L0K`1i04@0CT1G05d0Gl1N`5Y0D/1907i0Ll1ZP6?0H41
PP6A0J`1d@7l0BL1C@5[0G`1O`5c0EX1=`4=0N81^P6J0HH1P0680Ih1`07X0A@1
?@5O0GH1O`5j0FL1B04P0OD1b`6W0Hd1P@620I<1/07E0@01:`5A0Fd1O@5n0G41
E`4c0@T1g@6f0IL1Q0600HX1X@740Nd160510F81M`5o0GT1I0540A`1l@770J@1
R`600H<1U@6c0MX11@4_0E@1K`5n0Gh1K`5D0Bl1107I0K<1U@630H01R`6T0LL1
l@4L0D@1I05i0Gl1M`5Q0D01607/0L<1X@6:0H01Q@6H0KH1gP490C<1E`5a0Gh1
O@5]0E01:`400MD1[`6C0H81P@6=0JL1b`7e0B41B05W0GX1O`5f0El1?@4C0NP1
_`6N0HP1P0660IX1^P7R0@d1=`5J0G<1O`5l0F/1C@4W0O`1d@6/0I01PP610Hl1
ZP7?0OX19@5;0FT1N`5o0G@1G04i0@l1i06l0I/1QP600HL1W@6n0NH14P4k0Ed1
M@5o0G/1J05:0B81m`7=0JT1SP610H81TP6^0M<1oP4Y0Dl1K05l0Gl1LP5I0CD1
2`7P0KP1V@650H01R@6P0L41jP4F0Cl1H05g0Gl1NP5V0DH17P7c0LT1YP6<0H01
P`6D0K41e`420Bd1DP5^0Gd1OP5`0ED1<@470M/1]@6F0H@1P06:0J<1a@7_0AX1
@P5S0GP1O`5h0F<1@P4J0Nl1a@6S0HX1P0640IH1]@7K0@L1<@5E0G01OP5m0Fh1
DP4]0@81e`6a0I@1P`600H`1YP790O<17P560FH1NP5o0GL1H04o0AH1jP710J01
R@600HD1V@6h0N012`4e0ET1LP5o0G`1K05?0BT1oP7C0Jh1TP620H41SP6Y0Ld1
m`4R0DX1J05k0Gl1M@5M0C/14P7V0Kh1W@670H01QP6K0K`1i04?0CT1G05d0Gl1
N`5Y0D/19@7j0Ll1ZP6?0H41PP6@0J`1d@7l0BL1C@5[0G`1O`5c0EX1=`4=0N81
^P6J0HH1P0680Ih1_`7X0A<1?@5O0GH1O`5j0FL1B04Q0OD1b`6W0Hd1P@620I<1
[`7E0@01:`5@0Fd1O@5n0G41E`4c0@T1gP6f0IP1Q@600HX1X@730N`160500F41
M`5o0GT1I0540A`1l@770J@1R`600H<1U@6c0MT1104_0E@1K`5n0Gh1K`5D0Bl1
1@7J0K<1U@630H01R`6T0LL1l@4L0D@1I05i0Gl1M`5R0D41607]0L@1X@6:0H01
Q06G0KH1g@490C<1E`5a0Gh1O@5]0E41:`400MD1/06C0H81P@6=0JL1b`7e0B01
B05W0GX1O`5f0El1?@4D0NP1`06N0HP1P0660IX1^P7R0@d1=`5J0G<1O`5l0F/1
C@4W0O`1d@6/0I41PP610Hl1ZP7?0OT1905;0FT1N`5o0G@1G04i0A01i06l0I`1
Q`600HL1W@6m0NH14@4j0Ed1M@5o0G/1J05:0B<1n07=0JT1SP610H81T@6]0M<1
oP4X0Dl1K05l0Gl1LP5I0CD12`7P0KP1V@650H01R@6O0L41jP4E0Ch1H05f0Gl1
NP5V0DH17`7c0LT1YP6<0H01P`6D0K41e`420B`1DP5^0Gd1OP5`0EH1<@470M`1
]@6F0H@1P06:0J81a@7^0AX1@P5S0GP1O`5h0F<1@`4J0Nl1aP6S0H/1P0640IH1
]07K0@H1<05E0G01OP5m0Fh1D`4]0@<1f06a0I@1P`600H`1Y@790O<17P560FD1
N@5o0GL1H04o0AH1j`720J01R@600HD1V06h0Ml12P4d0EP1LP5o0G`1K05?0BT1
oP7D0Jh1TP620H41SP6X0Ld1m`4R0DT1J05k0Gl1M@5N0C/14P7W0Kh1W@670H01
QP6K0K/1h`4?0CP1F`5d0Gl1N`5Z0D`19@7j0M01Z`6@0H41P@6@0J`1d@7k0BH1
C@5Z0G`1O`5c0E/1=`4>0N81^P6J0HH1P0680Ih1_`7X0A<1?05N0GH1O`5j0FL1
B04Q0OH1c06X0Hh1P@620I81[`7E0Ol1\>"]},
  ImageCacheContents->"Sound"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Play[
        Sin[\ 2\ \[Pi]\ 440\ t] + Sin[\ 2\ \[Pi]\ 444\ t], {t, 0, 
          1}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
8192 8192 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound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pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`00000Q
0000000000<000000?ooo`3oool03000000_0?oooaP00000;`3ooolH000002l0oooo6000000_0?oo
o`d0000000000`000000oooo0000000@000002L0oooo8000000W0?ooob0000009`3ooolP000002L0
oooo4@00000000030000003oool0000001@000007`3ooolX000001l0oooo:000000O0?ooobP00000
7`3ooolE0000000000<000000?ooo`0000005`00000I0?ooobh000006@3oool^000001T0oooo;P00
000I0?oooaP0000000000`000000oooo0000000J000001<0oooo=000000C0?oooc@000004`3ooold
000001<0oooo6`00000000030000003oool0000001d000003@3ooolC000000030?ooo`0000000000
02@000003@3ooolC000000030?ooo`000000000002@000003@3ooolC000000030?ooo`0000000000
02@000003@3ooolC000000030?ooo`000000000000P0000000000`000000oooo0000000P000000L0
oooo@00000070?oood0000001`3ooom0000000L0oooo7`0000010?ooo`40000000000`000000oooo
0?ooo`0R00000080ooooA@0000020?ooodD000000P3ooom500000080oooo9000000000030000003o
ool000000400000000<0oooo000000000000A00000000`3oool0000000000014000000030?ooo`00
0000000004@0000000<0oooo0000000000001@00000000030000003oool000000?l0000070000001
0?ooo`40000000000`000000oooo0?ooo`0R000000030?ooo`00000000000200000000<0oooo0000
000000008@0000000`3oool000000000000P000000030?ooo`00000000000240000000<0oooo0000
00000000800000000`3oool000000000000Q000000030?ooo`0000000000020000000@3oool10000
0040000000000`000000oooo0000000O000000L0oooo@00000070?oood0000001`3ooom0000000L0
oooo8P00000000030000003oool0000001`000003@3ooolj000000d0oooo>P00000=0?ooocX00000
3@3ooolO0000000000<000000?ooo`3oool06@00000C0?oooc@000004`3ooold000001<0oooo=000
000C0?oooa`0000000000`000000oooo0000000F000001P0oooo;`00000H0?ooobl00000603oool_
000001P0oooo6P00000000030000003oool0000001<000007`3ooolX000001l0oooo:000000O0?oo
obP000007`3ooolF0000000000<000000?ooo`0000004000000U0?ooob8000009@3ooolR000002D0
oooo8P00000U0?oooa<0000000000`000000oooo0000000:00000300oooo5`00000`0?oooaL00000
<03ooolG00000300oooo3P00000000030000003oool0oooo04D0oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo04@0oooo0@0000010?ooo`4000000000
0`000000oooo0?ooo`3o0?oooad0oooo0@0000000?l000008@00000000030000003oool0oooo0080
000000<0oooo0000003oool0?P3oool6000000030?ooo`000000oooo03h0oooo1P0000000`3oool0
00000?ooo`0n0?ooo`H0000000<0oooo0000003oool0?P3oool50000000000<000000?ooo`000000
1@00000l0?ooo`/00000?03oool;000003`0oooo2`00000l0?ooo`L0000000000`000000oooo0?oo
o`04000000030?ooo`000000oooo03T0oooo0P0000001@3oool00000000000000000oooo00@00000
00<0oooo0000003oool0>@3oool2000000050?ooo`00000000000000003oool0100000000`3oool0
00000?ooo`0i0?ooo`80000000D0oooo00000000000000000?ooo`04000000030?ooo`000000oooo
03T0oooo0P0000001@3oool00000000000000000oooo00400000000010000000oooo0?ooo`000003
0?ooo`030000003oool0000003T0oooo1@0000000`3oool00000000000030?ooo`030000003oool0
000003T0oooo1@0000000`3oool00000000000030?ooo`030000003oool0000003T0oooo1@000000
0`3oool00000000000030?ooo`030000003oool0000003T0oooo1@0000010?ooo`4000000@000000
00030000003oool0000000T00000=P3oool3000000030?ooo`000000oooo00/00000=P3oool30000
00030?ooo`000000oooo00/00000=P3oool3000000030?ooo`000000oooo00/00000=P3oool30000
00050?ooo`000000oooo0000003oool00@00000000030000003oool0000000T00000=@3oool01000
0000oooo0?ooo`0000040?ooo`X00000=@3oool010000000oooo0?ooo`0000040?ooo`X00000=@3o
ool010000000oooo0?ooo`0000040?ooo`X00000=@3oool010000000oooo0?ooo`0000040?ooo`80
000000000`000000oooo0?ooo`040?ooo`80000000@0oooo0000000000000000<`3oool200000005
0?ooo`00000000000000003oool00P0000050?ooo`80000000@0oooo0000000000000000<`3oool2
000000050?ooo`00000000000000003oool00P0000050?ooo`80000000@0oooo0000000000000000
<`3oool2000000050?ooo`00000000000000003oool00P0000050?ooo`80000000@0oooo00000000
00000000<`3oool2000000050?ooo`00000000000000003oool00P0000010?ooo`40000000000`00
0000oooo0?ooo`030?ooo`030000003oool0000000D00000<@3oool2000000070?ooo`0000000000
0000003oool000000?ooo`02000000<0oooo00<000000?ooo`0000001@00000a0?ooo`80000000L0
oooo00000000000000000?ooo`000000oooo008000000`3oool00`000000oooo0000000500000340
oooo0P0000001`3oool00000000000000000oooo0000003oool00P0000030?ooo`030000003oool0
000000D00000<@3oool2000000070?ooo`00000000000000003oool000000?ooo`030000000000D0
00000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0?ooo`800000<@3oool500000080
oooo00@000000?ooo`00000000000P3oool010000000oooo0?ooo`0000030?ooo`800000<@3oool5
00000080oooo00@000000?ooo`00000000000P3oool010000000oooo0?ooo`0000030?ooo`800000
<@3oool500000080oooo00@000000?ooo`00000000000P3oool010000000oooo0?ooo`0000030?oo
o`800000<@3oool500000080oooo00D000000?ooo`00000000000?ooo`010000000000D000000?oo
o`3oool000000?ooo`03000000030?ooo`00000000000080oooo0P00000_0?ooo`@000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool000000080000000<0oooo0000000000000P3oool2
000002l0oooo100000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P000000
0`3oool00000000000020?ooo`800000;`3oool4000000<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo00000002000000030?ooo`00000000000080oooo0P00000_0?ooo`@000000`3oool0
0`000000oooo0?ooo`020?ooo`400000000010000000oooo0?ooo`3oool3000000030?ooo`000000
oooo00@00000;`3oool4000000<0oooo00<000000?ooo`3oool0103oool3000000030?ooo`000000
oooo00@00000;`3oool4000000<0oooo00<000000?ooo`3oool0103oool3000000030?ooo`000000
oooo00@00000;`3oool4000000<0oooo00<000000?ooo`3oool0103oool3000000030?ooo`000000
oooo00@00000;`3oool4000000<0oooo00<000000?ooo`3oool00`3oool10000000000@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`04000000030?ooo`000000000002`0oooo10000003
0?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`030000003oool0oooo00@0000000<0oooo
000000000000;03oool4000000<0oooo00<000000?ooo`3oool00`3oool200000080oooo00<00000
0?ooo`3oool0100000000`3oool000000000000/0?ooo`@000000`3oool00`000000oooo0?ooo`03
0?ooo`8000000P3oool00`000000oooo0?ooo`04000000030?ooo`000000000002`0oooo10000003
0?ooo`030000003oool0oooo00<0oooo0P00000000030000003oool0oooo0080oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`02000002d0oooo00<000000?ooo`0000000`3oool20000
00050?ooo`00000000000?ooo`0000000`3oool00`000000oooo000000020?ooo`030000003oool0
oooo00800000;@3oool00`000000oooo000000030?ooo`80000000D0oooo000000000000oooo0000
00030?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P00000]0?ooo`030000003o
ool0000000<0oooo0P0000001@3oool000000000003oool0000000<0oooo00<000000?ooo`000000
0P3oool00`000000oooo0?ooo`02000002d0oooo00<000000?ooo`0000000`3oool2000000060?oo
o`00000000000?ooo`000000oooo0@00000000030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool3000000030?ooo`000000oooo02T0oooo0`0000000`3oool000000000000200000007
0?ooo`00000000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00<0oooo0`000000
0`3oool000000?ooo`0Y0?ooo`<0000000<0oooo0000000000000P0000001`3oool000000000003o
ool000000?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`<0000000<0oooo0000003oool0
:@3oool3000000030?ooo`00000000000080000000L0oooo000000000000oooo0000003oool00000
00<0oooo00<000000?ooo`3oool00`3oool3000000030?ooo`000000oooo02T0oooo0`0000000`3o
ool0000000000002000000060?ooo`00000000000?ooo`000000oooo0P00000000030000003oool0
oooo00H0oooo00L000000?ooo`000000oooo0000003oool0000002/0oooo0P000000103oool00000
0000000000050?ooo`030000003oool0000000L0oooo00L000000?ooo`000000oooo0000003oool0
000002/0oooo0P000000103oool000000000000000050?ooo`030000003oool0000000L0oooo00L0
00000?ooo`000000oooo0000003oool0000002/0oooo0P000000103oool000000000000000050?oo
o`030000003oool0000000L0oooo00L000000?ooo`000000oooo0000003oool0000002/0oooo0P00
0000103oool000000000000000050?ooo`040000003oool000000?ooo`400000000010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000:@3oool200000005
0?ooo`000000oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0000000Y0?ooo`80000000D0oooo0000003oool0oooo0000
00040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000
003oool0000002T0oooo0P0000001@3oool000000?ooo`3oool0000000@0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000:@3oool20000
00050?ooo`000000oooo0?ooo`000000103oool010000000oooo0?ooo`3oool10000000000H00000
0?ooo`000000oooo0000003oool9000000040?ooo`0000000000000002L0oooo0P0000001@3oool0
00000?ooo`3oool0000000<0oooo0P0000030?ooo`040000003oool000000?ooo`T0000000@0oooo
00000000000000009`3oool2000000050?ooo`000000oooo0?ooo`0000000`3oool2000000<0oooo
00@000000?ooo`000000oooo2@000000103oool0000000000000000W0?ooo`80000000D0oooo0000
003oool0oooo000000030?ooo`8000000`3oool010000000oooo0000003oool9000000040?ooo`00
00000000000002L0oooo0P0000001@3oool000000?ooo`3oool0000000<0oooo0P0000040?ooo`40
000000000`000000oooo0?ooo`0;000000030?ooo`0000000000008000009`3oool00`000000oooo
000000030?ooo`040000003oool0oooo000000H0oooo2`0000000`3oool0000000000002000002L0
oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000060?ooo`/0000000<0oooo0000
000000000P00000W0?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000001P3oool;
000000030?ooo`0000000000008000009`3oool00`000000oooo000000030?ooo`040000003oool0
oooo000000H0oooo0@00000000030000003oool0oooo008000001P3oool2000000040?ooo`000000
00000?ooo`8000009P3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000
1P3oool2000000H0oooo0P000000103oool000000000003oool2000002H0oooo00<000000?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000H0oooo0P0000060?ooo`80000000@0oooo0000
00000000oooo0P00000V0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00060?ooo`8000001P3oool2000000040?ooo`00000000000?ooo`8000009P3oool00`000000oooo
000000030?ooo`050000003oool0oooo0?ooo`0000001P3oool10000000000<000000?ooo`000000
103oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo0000000000000P00000T0?ooo`03
0000003oool0000000<0oooo00@000000?ooo`000000oooo0`0000040?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool2000000030?ooo`000000000000800000903oool0
0`000000oooo000000030?ooo`040000003oool000000?ooo`<00000103oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo00000080oooo0P0000000`3oool0000000000002000002@0oooo
00<000000?ooo`0000000`3oool010000000oooo0000003oool3000000@0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo0000000000000P00000T0?oo
o`030000003oool0000000<0oooo00@000000?ooo`000000oooo0`0000040?ooo`80000000000`00
0000oooo0?ooo`030?ooo`030000003oool0000000@0oooo00@000000?ooo`000000oooo1000000T
0?ooo`080000003oool000000?ooo`000000oooo0000003oool3000000030?ooo`000000oooo0080
0000103oool00`000000oooo000000040?ooo`040000003oool000000?ooo`@00000903oool02000
0000oooo0000003oool000000?ooo`000000oooo0`0000000`3oool000000?ooo`02000000@0oooo
00<000000?ooo`000000103oool010000000oooo0000003oool4000002@0oooo00P000000?ooo`00
0000oooo0000003oool000000?ooo`<0000000<0oooo0000003oool00P0000040?ooo`030000003o
ool0000000@0oooo00@000000?ooo`000000oooo1000000T0?ooo`080000003oool000000?ooo`00
0000oooo0000003oool3000000030?ooo`000000oooo008000000@3oool10000000000<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`@00000903oool3
000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000070?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool0oooo1000000T0?ooo`<000000`3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`3oool4000002@0oooo0`0000030?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`@00000903o
ool3000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000030?ooo`400000
00000`000000oooo0?ooo`0<0?ooo`8000000`3oool00`000000oooo0?ooo`0P0?ooo`<000000P3o
ool200000080oooo00<000000?ooo`3oool00`3oool010000000oooo00000000000<0?ooo`800000
0`3oool00`000000oooo0?ooo`0P0?ooo`<000000P3oool200000080oooo00<000000?ooo`3oool0
0`3oool010000000oooo00000000000<0?ooo`8000000`3oool00`000000oooo0?ooo`0P0?ooo`<0
00000P3oool200000080oooo00<000000?ooo`3oool00`3oool010000000oooo00000000000<0?oo
o`8000000`3oool00`000000oooo0?ooo`0P0?ooo`<000000P3oool200000080oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000020000000000<000000?ooo`3oool01P3oool300000003
0?ooo`000000000000<0oooo1000000Q0?ooo`80000000@0oooo00000000000000000P3oool00`00
0000oooo0?ooo`030?ooo`040000003oool00000000000L0oooo0`0000000`3oool0000000000003
0?ooo`@000008@3oool2000000040?ooo`000000000000000080oooo00<000000?ooo`3oool00`3o
ool010000000oooo0000000000070?ooo`<0000000<0oooo0000000000000`3oool400000240oooo
0P000000103oool000000000000000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`00
000000001`3oool3000000030?ooo`000000000000<0oooo1000000Q0?ooo`80000000@0oooo0000
0000000000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool000000000003oool00@00
000000050000003oool0oooo0?ooo`0000000`3oool3000000040?ooo`000000000000000080oooo
00@000000?ooo`00000000008@3oool5000000T0oooo00<000000?ooo`3oool0103oool010000000
oooo0?ooo`3oool3000000040?ooo`000000000000000080oooo00@000000?ooo`00000000008@3o
ool5000000T0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`3oool3000000040?oo
o`000000000000000080oooo00@000000?ooo`00000000008@3oool5000000T0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`3oool3000000040?ooo`000000000000000080oooo00@0
00000?ooo`00000000008@3oool5000000T0oooo00<000000?ooo`3oool00`3oool10000000000D0
00000?ooo`3oool000000?ooo`03000000<0oooo00@000000?ooo`000000oooo0P0000000`3oool0
00000?ooo`03000001l0oooo0`000000103oool000000?ooo`0000020?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`0000000P0000030?ooo`040000003oool000000?ooo`80000000<0oooo
0000003oool00`00000O0?ooo`<0000000@0oooo0000003oool000000P3oool00`000000oooo0?oo
o`080?ooo`030000003oool00000008000000`3oool010000000oooo0000003oool2000000030?oo
o`000000oooo00<000007`3oool3000000040?ooo`000000oooo00000080oooo00<000000?ooo`3o
ool0203oool00`000000oooo00000002000000<0oooo00@000000?ooo`000000oooo0P0000000`3o
ool000000?ooo`03000001l0oooo0`000000103oool000000?ooo`0000020?ooo`030000003oool0
oooo00P0oooo0@00000000040000003oool0oooo0?ooo`800000103oool010000000oooo0?ooo`3o
ool2000000030?ooo`000000oooo00@000007`3oool2000000040?ooo`000000oooo00000080oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`800000103oool010000000oooo
0?ooo`3oool2000000030?ooo`000000oooo00@000007`3oool2000000040?ooo`000000oooo0000
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`800000103oool01000
0000oooo0?ooo`3oool2000000030?ooo`000000oooo00@000007`3oool2000000040?ooo`000000
oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`800000103o
ool010000000oooo0?ooo`3oool2000000030?ooo`000000oooo00@000007`3oool2000000040?oo
o`000000oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`40
0000000010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00P000000?ooo`00
0000oooo0000003oool000000?ooo`8000007`3oool2000000030?ooo`000000oooo00T0oooo00<0
00000?ooo`3oool0103oool010000000oooo0?ooo`0000050?ooo`080000003oool000000?ooo`00
0000oooo0000003oool2000001l0oooo0P0000000`3oool000000?ooo`090?ooo`030000003oool0
oooo00@0oooo00@000000?ooo`3oool000001@3oool020000000oooo0000003oool000000?ooo`00
0000oooo0P00000O0?ooo`80000000<0oooo0000003oool02@3oool00`000000oooo0?ooo`040?oo
o`040000003oool0oooo000000D0oooo00P000000?ooo`000000oooo0000003oool000000?ooo`80
00007`3oool2000000030?ooo`000000oooo00T0oooo00<000000?ooo`3oool0103oool100000000
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`000000oooo0000000O0?ooo`030000003oool0000000<0oooo00D000000?ooo`00
000000000?ooo`04000000D0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`03
0?ooo`050000003oool000000?ooo`0000007`3oool00`000000oooo000000030?ooo`050000003o
ool000000000003oool0100000050?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0000003oool0000001l0oooo00<000000?ooo`0000000`3oool01@00
0000oooo000000000000oooo00@000001@3oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`000000oooo0000000O0?ooo`030000003oool0000000<0oooo
00D000000?ooo`00000000000?ooo`04000000D0oooo0P00000000030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo00000000
0000703oool400000080oooo00D000000?ooo`00000000000?ooo`0400000080oooo0P0000000`3o
ool000000?ooo`040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool2
000000030?ooo`000000000001`0oooo100000020?ooo`050000003oool000000000003oool01000
00020?ooo`80000000<0oooo0000003oool0103oool00`000000oooo0?ooo`030?ooo`040000003o
ool0oooo00000080oooo0P0000000`3oool000000000000L0?ooo`@000000P3oool01@000000oooo
000000000000oooo00@000000P3oool2000000030?ooo`000000oooo00@0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo000000000000703oool40000
0080oooo00D000000?ooo`00000000000?ooo`0400000080oooo0P0000000`3oool000000?ooo`01
0000000000<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`0000000P0000000`3oool000000?ooo`0J0?ooo`040000003oool0
000000000080oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo0080000000<0
oooo0000003oool0103oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`0000000P0000000`3oool000000?ooo`0J0?ooo`040000003oool0000000000080
oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo0080000000<0oooo0000003o
ool0103oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000000P0000000`3oool000000?ooo`0J0?ooo`040000003oool0000000000080oooo0P000000
0`3oool000000?ooo`020?ooo`030000003oool0oooo0080000000<0oooo0000003oool0103oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P00
00000`3oool000000?ooo`0J0?ooo`040000003oool0000000000080oooo0P0000000`3oool00000
0?ooo`020?ooo`030000003oool0oooo0080000000@0oooo0000003oool0oooo0@00000000030000
003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool6000001`0oooo0`0000020?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo1P00000L0?ooo`<000000P3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`H00000703oool300000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool6000001`0oooo0`000002
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`010000000000<000000?ooo`3oool01@3oool2000000030?ooo`000000000000D0000000<0oooo
0000003oool01000000J0?ooo`<000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool000001@3oool2000000030?ooo`000000000000D0000000<0
oooo0000003oool01000000J0?ooo`<000000P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00<0oooo00@000000?ooo`3oool000001@3oool2000000030?ooo`000000000000D00000
00<0oooo0000003oool01000000J0?ooo`<000000P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`3oool000001@3oool2000000030?ooo`000000000000D0
000000<0oooo0000003oool01000000J0?ooo`<000000P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P00000000040000003oool0oooo000000@0
oooo00<000000?ooo`0000001@0000000`3oool000000?ooo`020?ooo`D000006@3oool00`000000
oooo0000000300000080oooo00D000000?ooo`3oool0oooo000000050?ooo`060000003oool0oooo
0000003oool00000103oool00`000000oooo00000005000000030?ooo`000000oooo0080oooo1@00
000I0?ooo`030000003oool0000000<000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo
00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool0000000D0000000<0oooo0000
003oool00P3oool5000001T0oooo00<000000?ooo`0000000`0000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool01P000000oooo0?ooo`000000oooo000000@0oooo00<000000?ooo`000000
1@0000000`3oool000000?ooo`020?ooo`D000006@3oool00`000000oooo0000000300000080oooo
00D000000?ooo`3oool0oooo000000050?ooo`050000003oool0oooo0000003oool00@0000000003
0000003oool0000000@0oooo00<000000?ooo`0000001P3oool00`000000oooo0000000200000004
0?ooo`0000000000000001T0oooo100000001@3oool000000?ooo`3oool0000000h0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000060?ooo`030000003oool000000080000000@0oooo
00000000000000006@3oool4000000050?ooo`000000oooo0?ooo`0000003P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0000000H0oooo00<000000?ooo`0000000P000000103oool00000
00000000000I0?ooo`@0000000D0oooo0000003oool0oooo0000000>0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000001P3oool00`000000oooo00000002000000040?ooo`0000000000
000001T0oooo100000001@3oool000000?ooo`3oool0000000l0oooo0@00000000070000003oool0
oooo0?ooo`000000oooo000000040?ooo`030000003oool0oooo0080oooo0`0000001@3oool00000
0?ooo`3oool0000001X0oooo0`0000000`3oool000000?ooo`060?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`030000003oool0oooo0080
oooo0`0000001@3oool000000?ooo`3oool0000001X0oooo0`0000000`3oool000000?ooo`060?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo000000040?oo
o`030000003oool0oooo0080oooo0`0000001@3oool000000?ooo`3oool0000001X0oooo0`000000
0`3oool000000?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool0
0`000000oooo000000040?ooo`030000003oool0oooo0080oooo0`0000001@3oool000000?ooo`3o
ool0000001X0oooo0`0000000`3oool000000?ooo`060?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool10000000000<000000?ooo`3oool00`0000040?ooo`030000003oool0
oooo0080oooo00H000000?ooo`3oool0oooo0000003oool200000080oooo00<000000?ooo`3oool0
5P3oool2000000040?ooo`000000oooo00000080oooo00<000000?ooo`000000100000020?ooo`03
0000003oool0oooo00@0oooo0`0000040?ooo`030000003oool0oooo0080oooo00H000000?ooo`3o
ool0oooo0000003oool200000080oooo00<000000?ooo`3oool05P3oool2000000040?ooo`000000
oooo00000080oooo00<000000?ooo`000000100000020?ooo`030000003oool0oooo00@0oooo0`00
00040?ooo`030000003oool0oooo0080oooo00H000000?ooo`3oool0oooo0000003oool200000080
oooo00<000000?ooo`3oool05P3oool2000000040?ooo`000000oooo00000080oooo00<000000?oo
o`000000100000020?ooo`030000003oool0oooo00@0oooo0`0000040?ooo`030000003oool0oooo
0080oooo00H000000?ooo`3oool0oooo0000003oool200000080oooo00<000000?ooo`3oool05P3o
ool2000000040?ooo`000000oooo00000080oooo00<000000?ooo`000000100000020?ooo`030000
003oool0oooo00@0oooo0@00000000030000003oool0oooo008000003`3oool200000080oooo00<0
00000?ooo`0000005P3oool2000000040?ooo`000000oooo00000080oooo00@000000?ooo`000000
oooo0`0000000`3oool00000000000070?ooo`8000003`3oool200000080oooo00<000000?ooo`00
00005P3oool2000000040?ooo`000000oooo00000080oooo00@000000?ooo`000000oooo0`000000
0`3oool00000000000070?ooo`8000003`3oool200000080oooo00<000000?ooo`0000005P3oool2
000000040?ooo`000000oooo00000080oooo00@000000?ooo`000000oooo0`0000000`3oool00000
000000070?ooo`8000003`3oool200000080oooo00<000000?ooo`0000005P3oool2000000040?oo
o`000000oooo00000080oooo00@000000?ooo`000000oooo0`0000000`3oool00000000000070?oo
o`400000000010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool00`000000oooo000000020?ooo`80000000<0oooo0000003oool05`3oool20000
00D0oooo0P0000000`3oool000000?ooo`020?ooo`040000003oool0oooo000000H0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P3o
ool2000000030?ooo`000000oooo01L0oooo0P0000050?ooo`80000000<0oooo0000003oool00P3o
ool010000000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`020?ooo`030000003oool000000080oooo0P0000000`3oool000000?ooo`0G0?ooo`80
00001@3oool2000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000001P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo00000002
0?ooo`80000000<0oooo0000003oool05`3oool2000000D0oooo0P0000000`3oool000000?ooo`02
0?ooo`040000003oool0oooo000000H0oooo0@00000000030000003oool0000000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3oool2000001D0oooo0P000000103oool000000?ooo`3oool300000080oooo00<0
00000?ooo`3oool00`3oool010000000oooo0000000000030?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool2000001D0oooo0P000000103oool000000?ooo`3oool300000080oooo00<000000?oo
o`3oool00`3oool010000000oooo0000000000030?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3o
ool2000001D0oooo0P000000103oool000000?ooo`3oool300000080oooo00<000000?ooo`3oool0
0`3oool010000000oooo0000000000030?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool20000
01D0oooo0P000000103oool000000?ooo`3oool300000080oooo00<000000?ooo`3oool00`3oool0
10000000oooo0000000000030?ooo`80000000000`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`D000005@3oool00`000000oooo0000
0003000000@0oooo00<000000?ooo`3oool00`3oool010000000oooo0000000000030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000@0
oooo1@00000E0?ooo`030000003oool0000000<00000103oool00`000000oooo0?ooo`030?ooo`04
0000003oool00000000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`000000103oool5000001D0oooo00<000000?ooo`0000000`000004
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`00000000000`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`D00000
5@3oool00`000000oooo00000003000000@0oooo00<000000?ooo`3oool00`3oool010000000oooo
0000000000030?ooo`4000000@3oool10000000000<000000?ooo`3oool0103oool00`000000oooo
0?ooo`030?ooo`<0000000<0oooo0000000000000P3oool7000001@0oooo00<000000?ooo`3oool0
0P0000000`3oool00000000000080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`<0000000<0oooo0000000000000P3oool7000001@0oooo
00<000000?ooo`3oool00P0000000`3oool00000000000080?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`<0000000<0oooo000000000000
0P3oool7000001@0oooo00<000000?ooo`3oool00P0000000`3oool00000000000080?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`<00000
00<0oooo0000000000000P3oool7000001@0oooo00<000000?ooo`3oool00P0000000`3oool00000
000000080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00@00000000030000003o
ool0oooo00H0oooo2@0000000`3oool00000000000030?ooo`@00000503oool300000080oooo0P00
00040?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo000000070?ooo`T00000
00<0oooo0000000000000`3oool4000001@0oooo0`0000020?ooo`800000103oool01@000000oooo
0?ooo`3oool0000000H0oooo00<000000?ooo`0000001`3oool9000000030?ooo`000000000000<0
oooo1000000D0?ooo`<000000P3oool2000000@0oooo00D000000?ooo`3oool0oooo000000060?oo
o`030000003oool0000000L0oooo2@0000000`3oool00000000000030?ooo`@00000503oool30000
0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001P3oool010000000oooo0000003o
ool10000000000<000000?ooo`3oool01@3oool3000000<0oooo00@000000?ooo`3oool0oooo0`00
00030?ooo`D000004P3oool300000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001`3oool3000000<0oooo00@0
00000?ooo`3oool0oooo0`0000030?ooo`D000004P3oool300000080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000
1`3oool3000000<0oooo00@000000?ooo`3oool0oooo0`0000030?ooo`D000004P3oool300000080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`0000001`3oool3000000<0oooo00@000000?ooo`3oool0oooo0`0000030?oo
o`D000004P3oool300000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool10000000000<000000?ooo`3o
ool01@3oool2000000030?ooo`000000oooo00H0oooo00<000000?ooo`3oool00`000000103oool0
000000000000000C0?ooo`@000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`80000000<0oooo0000003oool01P3oool0
0`000000oooo0?ooo`03000000040?ooo`0000000000000001<0oooo100000020?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo
0P0000000`3oool000000?ooo`060?ooo`030000003oool0oooo00<0000000@0oooo000000000000
00004`3oool400000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`05
0000003oool0oooo0?ooo`0000001@3oool2000000030?ooo`000000oooo00H0oooo00<000000?oo
o`3oool00`000000103oool0000000000000000C0?ooo`@000000P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo0P00000000040000003oool0
oooo00000080oooo0`0000000`3oool000000?ooo`040?ooo`030000003oool0oooo0080oooo0`00
00020?ooo`80000000<0oooo0000003oool0403oool400000080oooo00@000000?ooo`3oool0oooo
0P000000103oool000000000000000050?ooo`070000003oool0oooo0?ooo`000000oooo00000002
0?ooo`<0000000<0oooo0000003oool0103oool00`000000oooo0?ooo`020?ooo`<000000P3oool2
000000030?ooo`000000oooo0100oooo100000020?ooo`040000003oool0oooo0?ooo`80000000@0
oooo00000000000000001@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool30000
00030?ooo`000000oooo00@0oooo00<000000?ooo`3oool00P3oool300000080oooo0P0000000`3o
ool000000?ooo`0@0?ooo`@000000P3oool010000000oooo0?ooo`3oool2000000040?ooo`000000
0000000000D0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo0`0000000`3oool0
00000?ooo`040?ooo`030000003oool0oooo0080oooo0`0000020?ooo`80000000<0oooo0000003o
ool0403oool400000080oooo00@000000?ooo`3oool0oooo0P000000103oool00000000000000005
0?ooo`060000003oool0oooo0?ooo`000000oooo0@00000000030000003oool000000080oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`8000000P3oool2000000030?ooo`00
000000000140oooo0P0000070?ooo`80000000<0oooo0000000000000P00000:0?ooo`040000003o
ool0oooo000000T0oooo00<000000?ooo`3oool00`3oool200000080oooo0P0000000`3oool00000
0000000A0?ooo`8000001`3oool2000000030?ooo`0000000000008000002P3oool010000000oooo
0?ooo`0000090?ooo`030000003oool0oooo00<0oooo0P0000020?ooo`80000000<0oooo00000000
00004@3oool2000000L0oooo0P0000000`3oool0000000000002000000X0oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo0?ooo`030?ooo`8000000P3oool2000000030?ooo`0000000000
0140oooo0P0000070?ooo`80000000<0oooo0000000000000P00000;0?ooo`40000000000`000000
oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000030?ooo`030000003oool0000000<000004@3oool5000000030?ooo`000000oooo0080
0000103oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000
oooo0000000300000140oooo1@0000000`3oool000000?ooo`02000000@0oooo00<000000?ooo`3o
ool00P0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`00000A0?ooo`D0
000000<0oooo0000003oool00P0000040?ooo`030000003oool0oooo008000000P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000030?ooo`030000003oool0000000<000004@3oool5000000030?ooo`000000oooo0080
0000103oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool00`3oool100000000
00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool2000000040?ooo`00000000000?ooo`800000403oool5000000060?ooo`0000000000
0000003oool00000103oool01@000000oooo000000000000oooo008000001`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool2000000040?oo
o`00000000000?ooo`800000403oool5000000060?ooo`00000000000000003oool00000103oool0
1@000000oooo000000000000oooo008000001`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool2000000040?ooo`00000000000?ooo`800000
403oool5000000060?ooo`00000000000000003oool00000103oool01@000000oooo000000000000
oooo008000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00P3oool2000000040?ooo`00000000000?ooo`800000403oool5000000060?ooo`00
000000000000003oool00000103oool01@000000oooo000000000000oooo008000001P3oool10000
000000@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000003000000h0oooo10000000103o
ool000000?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo000000060?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo000000030?ooo`030000003oool0000000<000003P3oool4000000040?ooo`00
0000oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000H0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`0000000`00000>0?ooo`@0000000@0oooo0000003o
ool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`0000001P3oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo00000003000000h0oooo10000000103oool000000?ooo`00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0000
00060?ooo`40000000000`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00@00000
0?ooo`3oool0oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00<000003`3o
ool200000080oooo00@000000?ooo`00000000000P3oool01@000000oooo0?ooo`3oool0000000H0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000060?ooo`040000003oool0oooo
0?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`03000000l0oooo0P000002
0?ooo`040000003oool0000000000080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000
003oool0oooo00@0oooo00@000000?ooo`3oool000001P3oool010000000oooo0?ooo`3oool30000
00030?ooo`000000oooo0080oooo00<000000?ooo`3oool00`00000?0?ooo`8000000P3oool01000
0000oooo0000000000020?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`040?ooo`040000003oool0oooo000000H0oooo00@000000?ooo`3oool0oooo0`0000000`3oool0
00000?ooo`020?ooo`030000003oool0oooo00<000003`3oool200000080oooo00@000000?ooo`00
000000000P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0103oool2
0000000000<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`D0000000<0oooo0000
003oool00`0000020?ooo`040000003oool000000?ooo`8000003@3oool01@000000oooo0?ooo`00
0000oooo008000000P3oool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool500000003
0?ooo`000000oooo00<000000P3oool010000000oooo0000003oool2000000d0oooo00D000000?oo
o`3oool000000?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo
1@0000000`3oool000000?ooo`0300000080oooo00@000000?ooo`000000oooo0P00000=0?ooo`05
0000003oool0oooo0000003oool00P0000020?ooo`050000003oool0oooo0?ooo`0000001P3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`D0000000<0oooo0000003oool00`0000020?ooo`040000003oool000000?ooo`800000
3@3oool01@000000oooo0?ooo`000000oooo008000000P3oool01@000000oooo0?ooo`3oool00000
00H0oooo00D000000?ooo`3oool0oooo000000020?ooo`4000000@3oool10000000000<000000?oo
o`3oool00`3oool010000000oooo0?ooo`0000020?ooo`<000001@3oool3000000040?ooo`000000
oooo0?ooo`D000003@3oool00`000000oooo00000002000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool00000
00@0oooo00@000000?ooo`3oool000000P3oool3000000D0oooo0`000000103oool000000?ooo`3o
ool5000000d0oooo00<000000?ooo`0000000P0000030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00`3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000040?oo
o`040000003oool0oooo00000080oooo0`0000050?ooo`<0000000@0oooo0000003oool0oooo1@00
000=0?ooo`030000003oool00000008000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000103oool01000
0000oooo0?ooo`0000020?ooo`<000001@3oool3000000040?ooo`000000oooo0?ooo`D000003@3o
ool00`000000oooo00000002000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`030?ooo`0:0000003oool0oooo0?ooo`000000oooo0000003oool000000?ooo`40000000000`00
0000oooo0?ooo`050?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo00000006000000`0oooo1@000000103oool000000?ooo`0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000070?ooo`040000
003oool0oooo000000@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000060000
00`0oooo1@000000103oool000000?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo000000070?ooo`040000003oool0oooo000000@0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo00000006000000`0oooo1@000000103oool00000
0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000070?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo00000006000000`0oooo1@000000103oool000000?ooo`0000040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020?ooo`4000000000
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`03000000030?ooo`000000000000800000303oool3000000030?ooo`000000
000000D0oooo0P0000000`3oool000000?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0000000<0oooo
0000000000000P00000<0?ooo`<0000000<0oooo0000000000001@3oool2000000030?ooo`000000
oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`0000000`3oool0000000000002000000`0oooo0`000000
0`3oool00000000000050?ooo`80000000<0oooo0000003oool02`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
000000030?ooo`000000000000800000303oool3000000030?ooo`000000000000D0oooo0P000000
0`3oool000000?ooo`0;0?ooo`030000003oool0oooo0040000000000`000000oooo0?ooo`050?oo
o`<000001P3oool010000000oooo0?ooo`0000030?ooo`80000000<0oooo0000000000001000000:
0?ooo`<0000000<0oooo0000003oool00P3oool5000000030?ooo`000000oooo008000000P3oool0
0`000000oooo0?ooo`040?ooo`040000003oool0oooo000000D0oooo0`0000060?ooo`040000003o
ool0oooo000000<0oooo0P0000000`3oool0000000000004000000X0oooo0`0000000`3oool00000
0?ooo`020?ooo`D0000000<0oooo0000003oool00P0000020?ooo`030000003oool0oooo00@0oooo
00@000000?ooo`3oool000001@3oool3000000H0oooo00@000000?ooo`3oool000000`3oool20000
00030?ooo`000000000000@000002P3oool3000000030?ooo`000000oooo0080oooo1@0000000`3o
ool000000?ooo`0200000080oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`000005
0?ooo`<000001P3oool010000000oooo0?ooo`0000030?ooo`80000000<0oooo0000000000001000
000:0?ooo`<0000000<0oooo0000003oool00P3oool5000000030?ooo`000000oooo008000000P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080000000000`000000oooo0?ooo`04
0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool01`3oool3000000040?ooo`000000
0000000000/0oooo00D000000?ooo`3oool000000?ooo`0500000080oooo00@000000?ooo`000000
00000P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`0000001P3oool00`000000oooo0?ooo`070?ooo`<0000000@0oooo00000000000000002`3oool0
1@000000oooo0?ooo`000000oooo00D000000P3oool010000000oooo0000000000020?ooo`030000
003oool0oooo00@0oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000060?ooo`03
0000003oool0oooo00L0oooo0`000000103oool0000000000000000;0?ooo`050000003oool0oooo
0000003oool01@0000020?ooo`040000003oool0000000000080oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`0000050?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0
1`3oool3000000040?ooo`0000000000000000/0oooo00D000000?ooo`3oool000000?ooo`050000
0080oooo00@000000?ooo`00000000000P3oool00`000000oooo0?ooo`040?ooo`050000003oool0
oooo0000003oool00@00000000040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo
000000060?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool4000000X0
oooo10000000103oool000000?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3o
ool4000000X0oooo10000000103oool000000?ooo`0000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool4000000X0oooo10000000103oool000000?ooo`0000040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool000000P3oool4000000X0oooo10000000103oool000000?ooo`0000040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`40
000000001`000000oooo0000003oool000000?ooo`0000000`3oool00`000000oooo000000040?oo
o`050000003oool0oooo0000003oool00P000000103oool000000?ooo`3oool4000000030?ooo`00
0000oooo00P0oooo100000001@3oool000000000003oool000000080oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`3oool00`3oool01@000000
oooo0000003oool0000000<0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`000000
oooo0080000000@0oooo0000003oool0oooo100000000`3oool000000?ooo`080?ooo`@0000000D0
oooo000000000000oooo000000020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000
oooo000000020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000030?oo
o`030000003oool0000000@0oooo00D000000?ooo`3oool000000?ooo`02000000040?ooo`000000
oooo0?ooo`@0000000<0oooo0000003oool0203oool4000000050?ooo`00000000000?ooo`000000
0P3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo000000040?oo
o`050000003oool0oooo0000003oool00P000000103oool000000?ooo`3oool4000000030?ooo`00
0000oooo00P0oooo100000001@3oool000000000003oool000000080oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`3oool0103oool100000000
00H000000?ooo`3oool000000?ooo`0000050?ooo`030000003oool0oooo00@0oooo0P0000001@3o
ool000000000003oool000000080oooo0P0000000`3oool000000?ooo`02000000P0oooo1`000000
0`3oool000000?ooo`020?ooo`030000003oool0oooo00<0oooo00P000000?ooo`3oool000000?oo
o`000000oooo000000H0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`80
000000D0oooo000000000000oooo000000020?ooo`80000000<0oooo0000003oool00P0000080?oo
o`L0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`030?ooo`080000003oool0oooo
0000003oool000000?ooo`0000060?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0
103oool2000000050?ooo`00000000000?ooo`0000000P3oool2000000030?ooo`000000oooo0080
0000203oool7000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool00`3oool020000000
oooo0?ooo`000000oooo0000003oool000001P3oool00`000000oooo000000050?ooo`030000003o
ool0oooo00@0oooo0P0000001@3oool000000000003oool000000080oooo0P0000000`3oool00000
0?ooo`02000000P0oooo1`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00<0oooo
00P000000?ooo`3oool000000?ooo`000000oooo000000H0oooo0@00000000040000003oool0oooo
0?ooo`8000002`3oool2000000050?ooo`000000oooo0?ooo`0000000P3oool2000000030?ooo`00
0000oooo00<00000203oool5000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0000000P0oooo0P00000;0?ooo`80000000D0oooo0000003oool0
oooo000000020?ooo`80000000<0oooo0000003oool00`0000080?ooo`D000000`3oool010000000
oooo0?ooo`0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000203oool20000
00/0oooo0P0000001@3oool000000?ooo`3oool000000080oooo0P0000000`3oool000000?ooo`03
000000P0oooo1@0000030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo000000080?ooo`8000002`3oool2000000050?ooo`000000oooo0?ooo`000000
0P3oool2000000030?ooo`000000oooo00<00000203oool5000000<0oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000L0oooo0@00000000030000
003oool0oooo008000002@3oool300000080oooo00<000000?ooo`0000000`3oool2000000030?oo
o`000000000000<0000000<0oooo0000003oool01@3oool4000000050?ooo`000000oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`80
00002@3oool300000080oooo00<000000?ooo`0000000`3oool2000000030?ooo`000000000000<0
000000<0oooo0000003oool01@3oool4000000050?ooo`000000oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`8000002@3oool30000
0080oooo00<000000?ooo`0000000`3oool2000000030?ooo`000000000000<0000000<0oooo0000
003oool01@3oool4000000050?ooo`000000oooo0?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`8000002@3oool300000080oooo00<00000
0?ooo`0000000`3oool2000000030?ooo`000000000000<0000000<0oooo0000003oool01@3oool4
000000050?ooo`000000oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo0P0000060?ooo`400000000010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo00<0oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool400000080oooo
00<000000?ooo`3oool01@3oool500000080oooo00D000000?ooo`3oool0oooo000000050?ooo`03
0000003oool0oooo00@0oooo0P0000000`3oool000000?ooo`040?ooo`050000003oool0oooo0?oo
o`0000001@3oool2000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`@000000P3oool0
0`000000oooo0?ooo`050?ooo`D000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool0103oool2000000030?ooo`000000oooo00@0oooo00D000000?ooo`3oool0oooo
000000050?ooo`8000001@3oool01@000000oooo0?ooo`3oool000000080oooo100000020?ooo`03
0000003oool0oooo00D0oooo1@0000020?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`040?ooo`80000000<0oooo0000003oool0103oool01@000000oooo0?ooo`3oool0
000000D0oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool400000080oooo00<0
00000?ooo`3oool01@3oool500000080oooo00D000000?ooo`3oool0oooo000000050?ooo`030000
003oool0oooo00@0oooo0P0000000`3oool000000?ooo`040?ooo`40000000000`000000oooo0000
00030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000002`3oool00`000000oooo0000
00020?ooo`<000001`3oool2000000030?ooo`000000oooo00<0000000D0oooo0000000000000000
0?ooo`03000000H0oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool00000
00H0oooo00<000000?ooo`0000002`3oool00`000000oooo000000020?ooo`<000001`3oool20000
00030?ooo`000000oooo00<0000000D0oooo00000000000000000?ooo`03000000H0oooo00@00000
0?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`000000
2`3oool00`000000oooo000000020?ooo`<000001`3oool2000000030?ooo`000000oooo00<00000
00D0oooo00000000000000000?ooo`03000000H0oooo00@000000?ooo`3oool000001@3oool01@00
0000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`0000002`3oool00`000000oooo00000002
0?ooo`<000001`3oool2000000030?ooo`000000oooo00<0000000D0oooo00000000000000000?oo
o`03000000H0oooo00@000000?ooo`3oool000001@3oool20000000000<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`02000000040?ooo`000000oooo000000D0oooo00P000000?ooo`3oool0
oooo0000003oool000000?ooo`D000001P3oool5000000040?ooo`00000000000?ooo`<0000000<0
oooo0000000000000`0000040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
1P3oool00`000000oooo0?ooo`02000000040?ooo`000000oooo000000D0oooo00P000000?ooo`3o
ool0oooo0000003oool000000?ooo`D000001P3oool5000000040?ooo`00000000000?ooo`<00000
00<0oooo0000000000000`0000040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0
00001P3oool00`000000oooo0?ooo`02000000040?ooo`000000oooo000000D0oooo00P000000?oo
o`3oool0oooo0000003oool000000?ooo`D000001P3oool5000000040?ooo`00000000000?ooo`<0
000000<0oooo0000000000000`0000040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3o
ool000001P3oool00`000000oooo0?ooo`02000000040?ooo`000000oooo000000D0oooo00P00000
0?ooo`3oool0oooo0000003oool000000?ooo`D000001P3oool5000000040?ooo`00000000000?oo
o`<0000000<0oooo0000000000000`0000040?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool000000?ooo`010000000000<000000?ooo`3oool0103oool010000000oooo000000000004
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`000000oooo0P0000000`3oool000000000
0004000000030?ooo`000000oooo00<0oooo1@0000000`3oool000000?ooo`020?ooo`030000003o
ool0oooo0080oooo0`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
0P0000050?ooo`040000003oool00000000000@0oooo00<000000?ooo`3oool00`3oool010000000
oooo0000003oool2000000030?ooo`000000000000@0000000<0oooo0000003oool00`3oool50000
00030?ooo`000000oooo0080oooo00<000000?ooo`3oool00P3oool300000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`02000000D0oooo00@000000?ooo`0000000000103o
ool00`000000oooo0?ooo`030?ooo`040000003oool000000?ooo`80000000<0oooo000000000000
100000000`3oool000000?ooo`030?ooo`D0000000<0oooo0000003oool00P3oool00`000000oooo
0?ooo`020?ooo`<000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080
00001@3oool010000000oooo0000000000040?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`000000oooo0P0000000`3oool0000000000004000000030?ooo`000000oooo00<0oooo1@000000
0`3oool000000?ooo`020?ooo`030000003oool0oooo0080oooo0`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P0000010?ooo`40000000000`000000oooo0?ooo`05
0?ooo`800000203oool01P000000oooo0?ooo`3oool000000?ooo`80000000<0oooo0000003oool0
0P3oool010000000oooo0?ooo`0000050?ooo`040000003oool000000?ooo`8000000`3oool00`00
0000oooo0?ooo`030?ooo`060000003oool0oooo0?ooo`000000oooo0P0000070?ooo`8000001`3o
ool2000000P0oooo00H000000?ooo`3oool0oooo0000003oool2000000030?ooo`000000oooo0080
oooo00@000000?ooo`3oool000001@3oool010000000oooo0000003oool2000000<0oooo00<00000
0?ooo`3oool00`3oool01P000000oooo0?ooo`3oool000000?ooo`8000001`3oool2000000L0oooo
0P0000080?ooo`060000003oool0oooo0?ooo`000000oooo0P0000000`3oool000000?ooo`020?oo
o`040000003oool0oooo000000D0oooo00@000000?ooo`000000oooo0P0000030?ooo`030000003o
ool0oooo00<0oooo00H000000?ooo`3oool0oooo0000003oool2000000L0oooo0P0000070?ooo`80
0000203oool01P000000oooo0?ooo`3oool000000?ooo`80000000<0oooo0000003oool00P3oool0
10000000oooo0?ooo`0000050?ooo`040000003oool000000?ooo`8000000`3oool00`000000oooo
0?ooo`030?ooo`060000003oool0oooo0?ooo`000000oooo0P0000070?ooo`8000000P3oool10000
000000<000000?ooo`3oool01P3oool00`000000oooo000000050?ooo`080000003oool0oooo0?oo
o`000000oooo0000003oool200000080oooo0P0000020?ooo`030000003oool0000000@0oooo1@00
00001@3oool000000?ooo`3oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
000000070?ooo`030000003oool0000000L0oooo00<000000?ooo`0000001@3oool020000000oooo
0?ooo`3oool000000?ooo`000000oooo0P0000020?ooo`8000000P3oool00`000000oooo00000004
0?ooo`D0000000D0oooo0000003oool0oooo000000040?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`0000001`3oool00`000000oooo000000070?ooo`030000003oool0000000D0oooo00P0
00000?ooo`3oool0oooo0000003oool000000?ooo`8000000P3oool200000080oooo00<000000?oo
o`000000103oool5000000050?ooo`000000oooo0?ooo`000000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0000000L0oooo00<000000?ooo`0000001`3oool00`000000oooo00000005
0?ooo`080000003oool0oooo0?ooo`000000oooo0000003oool200000080oooo0P0000020?ooo`03
0000003oool0000000@0oooo1@0000001@3oool000000?ooo`3oool0000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000070?ooo`040000003oool000000?ooo`40000000000`00
0000oooo0?ooo`050?ooo`030000003oool0000000P0oooo0P0000030?ooo`040000003oool00000
0?ooo`80000000L0oooo000000000000oooo0000003oool000000080oooo1@0000001@3oool00000
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`05
0000003oool000000?ooo`0000001@3oool00`000000oooo000000080?ooo`8000000`3oool01000
0000oooo0000003oool2000000070?ooo`00000000000?ooo`000000oooo000000020?ooo`D00000
00D0oooo0000003oool0oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`000000203oool20000
00<0oooo00@000000?ooo`000000oooo0P0000001`3oool000000000003oool000000?ooo`000000
0P3oool5000000050?ooo`000000oooo0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool00000
00P0oooo0P0000030?ooo`040000003oool000000?ooo`80000000L0oooo000000000000oooo0000
003oool000000080oooo1@0000001@3oool000000?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`040000003oool000000?ooo`80000000000`000000
oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool2000000D0
oooo00<000000?ooo`3oool00P3oool2000000040?ooo`0000000000000000@0oooo0`0000000`3o
ool000000?ooo`02000000060?ooo`00000000000000003oool000001P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00P3oool200000004
0?ooo`0000000000000000@0oooo0`0000000`3oool000000?ooo`02000000060?ooo`0000000000
0000003oool000001P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0
oooo000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool2000000D0
oooo00<000000?ooo`3oool00P3oool2000000040?ooo`0000000000000000@0oooo0`0000000`3o
ool000000?ooo`02000000060?ooo`00000000000000003oool000001P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00P3oool200000004
0?ooo`0000000000000000@0oooo0`0000000`3oool000000?ooo`02000000060?ooo`0000000000
0000003oool000001P3oool01@000000oooo0?ooo`3oool0000000<0oooo00H000000?ooo`3oool0
oooo0000003oool10000000000@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001P3oool00`000000oooo00000002
0?ooo`<0000000@0oooo0000003oool0oooo200000001@3oool00000000000000000oooo00800000
1@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00060?ooo`030000003oool000000080oooo0`000000103oool000000?ooo`3oool8000000050?oo
o`00000000000000003oool00P0000050?ooo`070000003oool0oooo0?ooo`000000oooo00000002
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`030?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`0000000P3oool3000000040?oo
o`000000oooo0?ooo`P0000000D0oooo00000000000000000?ooo`02000000D0oooo00L000000?oo
o`3oool0oooo0000003oool000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001P3oool00`000000
oooo000000020?ooo`<0000000@0oooo0000003oool0oooo200000001@3oool00000000000000000
oooo008000001@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`40000000000`000000oooo000000020?ooo`030000003oool0oooo00D0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`050000003oool000000000003o
ool00`0000000`3oool00000000000020?ooo`L000001@3oool2000000030?ooo`00000000000080
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000050?ooo`040000003oool0oooo
000000L0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000040?ooo`050000003o
ool000000000003oool00`0000000`3oool00000000000020?ooo`L000001@3oool2000000030?oo
o`00000000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000050?ooo`04
0000003oool0oooo000000L0oooo00@000000?ooo`3oool000000P3oool00`000000oooo00000004
0?ooo`050000003oool000000000003oool00`0000000`3oool00000000000020?ooo`L000001@3o
ool2000000030?ooo`00000000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`0000050?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo000000040?ooo`050000003oool000000000003oool00`0000000`3oool0000000000002
0?ooo`L000001@3oool2000000030?ooo`00000000000080oooo00<000000?ooo`3oool00`3oool0
10000000oooo0?ooo`0000060?ooo`40000000000`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`80000000@0
oooo000000000000oooo2@0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0P0000020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0103oool200000004
0?ooo`00000000000?ooo`T000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
008000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo0P000000
103oool000000000003oool900000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0200000080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`800000
00@0oooo000000000000oooo2@0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P0000020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool100000000
00D000000?ooo`3oool0oooo000000090?ooo`030000003oool0oooo00H0oooo0P0000000`3oool0
00000?ooo`020?ooo`<0000000<0oooo0000000000001P0000001P3oool000000000003oool00000
0?ooo`8000001P3oool2000000L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo0P0000000`3oool000000?ooo`020?ooo`<0000000<0oooo
0000000000001P0000001P3oool000000000003oool000000?ooo`8000001P3oool2000000L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo
0P0000000`3oool000000?ooo`020?ooo`<0000000<0oooo0000000000001P0000001P3oool00000
0000003oool000000?ooo`8000001P3oool2000000L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo0P0000000`3oool000000?ooo`020?oo
o`<0000000<0oooo0000000000001P0000001P3oool000000000003oool000000?ooo`8000001P3o
ool2000000L0oooo00<000000?ooo`3oool01P3oool10000000000L000000?ooo`3oool0oooo0000
003oool0000000H0oooo00@000000?ooo`3oool000001@3oool4000000<0oooo0P0000000`3oool0
00000000000:000000030?ooo`000000oooo008000001P3oool2000000030?ooo`000000oooo00D0
oooo00<000000?ooo`0000001`3oool00`000000oooo000000060?ooo`040000003oool0oooo0000
00D0oooo100000030?ooo`80000000<0oooo0000000000002P0000000`3oool000000?ooo`020000
00H0oooo0P0000000`3oool000000?ooo`050?ooo`030000003oool0000000L0oooo00<000000?oo
o`0000001P3oool010000000oooo0?ooo`0000050?ooo`@000000`3oool2000000030?ooo`000000
000000X0000000<0oooo0000003oool00P0000060?ooo`80000000<0oooo0000003oool01@3oool0
0`000000oooo000000070?ooo`030000003oool0000000H0oooo00@000000?ooo`3oool000001@3o
ool4000000<0oooo0P0000000`3oool000000000000:000000030?ooo`000000oooo008000001P3o
ool2000000030?ooo`000000oooo00D0oooo00<000000?ooo`0000001P3oool10000000000H00000
0?ooo`3oool000000?ooo`0000060?ooo`040000003oool0oooo000000H0oooo0P0000000`3oool0
00000?ooo`040?ooo`030000003oool0000000P00000103oool2000000030?ooo`000000oooo00<0
oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000060?ooo`040000003oool0oooo000000H0oooo0P00
00000`3oool000000?ooo`040?ooo`030000003oool0000000P00000103oool2000000030?ooo`00
0000oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool000000080
oooo00<000000?ooo`3oool00P3oool00`000000oooo000000060?ooo`040000003oool0oooo0000
00H0oooo0P0000000`3oool000000?ooo`040?ooo`030000003oool0000000P00000103oool20000
00030?ooo`000000oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003o
ool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo000000060?ooo`040000003o
ool0oooo000000H0oooo0P0000000`3oool000000?ooo`040?ooo`030000003oool0000000P00000
103oool2000000030?ooo`000000oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000040?oo
o`030000003oool000000080oooo00<000000?ooo`3oool00P3oool10000000000<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00P0000020?oo
o`030000003oool0oooo00@0000000D0oooo00000000000000000?ooo`04000000030?ooo`000000
000000<000000P3oool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`000000
1@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo
00@0000000D0oooo00000000000000000?ooo`04000000030?ooo`000000000000<000000P3oool0
10000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@0000000D0oooo0000
0000000000000?ooo`04000000030?ooo`000000000000<000000P3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?oo
o`3oool00P0000020?ooo`030000003oool0oooo00@0000000D0oooo00000000000000000?ooo`04
000000030?ooo`000000000000<000000P3oool010000000oooo0?ooo`0000020?ooo`050000003o
ool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000@0oooo0P00000000030000
003oool0oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`040000003oool00000
000000H0oooo1@0000000`3oool000000000000<000000@0oooo00@000000?ooo`00000000001P3o
ool010000000oooo0?ooo`0000060?ooo`030000003oool0000000@0oooo00H000000?ooo`3oool0
00000?ooo`0000040?ooo`040000003oool00000000000H0oooo1@0000000`3oool000000000000<
000000@0oooo00@000000?ooo`00000000001P3oool010000000oooo0?ooo`0000060?ooo`030000
003oool0000000@0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`040000003oool00000
000000H0oooo1@0000000`3oool000000000000<000000@0oooo00@000000?ooo`00000000001P3o
ool010000000oooo0?ooo`0000060?ooo`030000003oool0000000@0oooo00H000000?ooo`3oool0
00000?ooo`0000040?ooo`040000003oool00000000000H0oooo1@0000000`3oool000000000000<
000000@0oooo00@000000?ooo`00000000001P3oool010000000oooo0?ooo`0000060?ooo`030000
003oool000000080000000000`000000oooo0?ooo`050?ooo`030000003oool0000000H0oooo0`00
00070?ooo`<0000000<0oooo0000000000001`0000001`3oool000000000003oool000000?ooo`00
0000103oool2000000H0oooo00@000000?ooo`3oool000001P3oool00`000000oooo000000070?oo
o`030000003oool0000000H0oooo0`0000070?ooo`<0000000<0oooo0000000000001`0000001`3o
ool000000000003oool000000?ooo`000000103oool2000000H0oooo00@000000?ooo`3oool00000
1P3oool00`000000oooo000000070?ooo`030000003oool0000000H0oooo0`0000070?ooo`<00000
00<0oooo0000000000001`0000001`3oool000000000003oool000000?ooo`000000103oool20000
00H0oooo00@000000?ooo`3oool000001P3oool00`000000oooo000000070?ooo`030000003oool0
000000H0oooo0`0000070?ooo`<0000000<0oooo0000000000001`0000001`3oool000000000003o
ool000000?ooo`000000103oool2000000H0oooo00@000000?ooo`3oool000001P3oool00`000000
oooo000000020?ooo`40000000000`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`80000000<0oooo00000000
00001P0000000`3oool000000000000600000080oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo0P0000000`3oool00000000000060000
00030?ooo`000000000000H000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00P3oool2000000030?ooo`000000000000H0000000<0oooo
0000000000001P0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`020?ooo`80000000<0oooo0000000000001P0000000`3oool000000000
000600000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo0040000000000`000000oooo0?ooo`050?ooo`80000000<0oooo0000003oool0103oool0
1P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool00P3oool;000000030?oo
o`000000000000H000000P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo0000
00H0oooo00<000000?ooo`0000001P3oool2000000030?ooo`000000oooo00@0oooo00H000000?oo
o`3oool000000?ooo`0000020?ooo`030000003oool0oooo0080oooo2`0000000`3oool000000000
000600000080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000060?ooo`03
0000003oool0000000H0oooo0P0000000`3oool000000?ooo`040?ooo`060000003oool0oooo0000
003oool000000P3oool00`000000oooo0?ooo`020?ooo`/0000000<0oooo0000000000001P000002
0?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000001P3oool00`000000oooo
000000060?ooo`80000000<0oooo0000003oool0103oool01P000000oooo0?ooo`000000oooo0000
0080oooo00<000000?ooo`3oool00P3oool;000000030?ooo`000000000000H000000P3oool01000
0000oooo0?ooo`0000040?ooo`040000003oool0oooo000000H0oooo00@000000?ooo`000000oooo
0@00000000030000003oool0oooo00@0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`06
0000003oool0oooo0?ooo`000000oooo100000020?ooo`<0000000<0oooo0000000000000P000002
0?ooo`D0000000D0oooo0000003oool0oooo000000050?ooo`030000003oool000000080oooo00H0
00000?ooo`3oool000000?ooo`0000040?ooo`030000003oool0000000H0oooo00H000000?ooo`3o
ool000000?ooo`0000040?ooo`060000003oool0oooo0?ooo`000000oooo100000020?ooo`<00000
00<0oooo0000000000000P0000020?ooo`D0000000D0oooo0000003oool0oooo000000050?ooo`03
0000003oool000000080oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool0
000000H0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`060000003oool0oooo0?ooo`00
0000oooo100000020?ooo`<0000000<0oooo0000000000000P0000020?ooo`D0000000D0oooo0000
003oool0oooo000000050?ooo`030000003oool000000080oooo00H000000?ooo`3oool000000?oo
o`0000040?ooo`030000003oool0000000H0oooo00H000000?ooo`3oool000000?ooo`0000040?oo
o`060000003oool0oooo0?ooo`000000oooo100000020?ooo`<0000000<0oooo0000000000000P00
00020?ooo`D0000000D0oooo0000003oool0oooo000000050?ooo`030000003oool000000080oooo
00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool000000080oooo0@0000000004
0000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`8000001@3oool4
000000030?ooo`000000000000L000000`3oool4000000030?ooo`000000oooo00@0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0000000000040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool0
oooo0P0000050?ooo`@0000000<0oooo0000000000001`0000030?ooo`@0000000<0oooo0000003o
ool0103oool00`000000oooo0?ooo`020?ooo`040000003oool00000000000@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
10000000oooo0?ooo`3oool2000000D0oooo100000000`3oool0000000000007000000<0oooo1000
00000`3oool000000?ooo`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`0000000000
103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`040000003oool0oooo0?ooo`8000001@3oool4000000030?ooo`0000000000
00L000000`3oool4000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0000000000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool1
0000000000<000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`030000003oool0000000<00000103oool0
10000000oooo0?ooo`3oool2000000060?ooo`000000oooo0000003oool00000103oool2000000L0
oooo00<000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool01@3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`0000000`000004
0?ooo`040000003oool0oooo0?ooo`80000000H0oooo0000003oool000000?ooo`0000040?ooo`80
00001`3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000001`3oool00`00
0000oooo0?ooo`050?ooo`040000003oool0oooo0?ooo`8000000P3oool00`000000oooo00000003
000000@0oooo00@000000?ooo`3oool0oooo0P0000001P3oool000000?ooo`000000oooo000000@0
oooo0P0000070?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000070?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`030000003oool0
000000<00000103oool010000000oooo0?ooo`3oool2000000060?ooo`000000oooo0000003oool0
0000103oool2000000L0oooo00<000000?ooo`0000001P3oool10000000000L000000?ooo`3oool0
oooo0000003oool0000000H0oooo0`0000050?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool000000?ooo`04000000<0oooo00<000000?ooo`0000001`0000001@3oool000000?ooo`00
0000oooo00<0000000<0oooo0000003oool0103oool010000000oooo0?ooo`0000070?ooo`030000
003oool0000000H0oooo0`0000050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
00000?ooo`04000000<0oooo00<000000?ooo`0000001`0000001@3oool000000?ooo`000000oooo
00<0000000<0oooo0000003oool0103oool010000000oooo0?ooo`0000070?ooo`030000003oool0
000000H0oooo0`0000050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool000000?oo
o`04000000<0oooo00<000000?ooo`0000001`0000001@3oool000000?ooo`000000oooo00<00000
00<0oooo0000003oool0103oool010000000oooo0?ooo`0000070?ooo`030000003oool0000000H0
oooo0`0000050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool000000?ooo`040000
00<0oooo00<000000?ooo`0000001`0000001@3oool000000?ooo`000000oooo00<0000000<0oooo
0000003oool0103oool010000000oooo0?ooo`0000060?ooo`40000000001P000000oooo0?ooo`00
0000oooo000000L0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0
00000?ooo`000000oooo00<00000103oool3000000030?ooo`000000000000<0000000@0oooo0000
00000000oooo0P0000020?ooo`030000003oool0oooo00H0oooo0P0000060?ooo`030000003oool0
000000L0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool000000?oo
o`000000oooo00<00000103oool3000000030?ooo`000000000000<0000000@0oooo000000000000
oooo0P0000020?ooo`030000003oool0oooo00H0oooo0P0000060?ooo`030000003oool0000000L0
oooo0P0000050?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool000000?ooo`000000
oooo00<00000103oool3000000030?ooo`000000000000<0000000@0oooo000000000000oooo0P00
00020?ooo`030000003oool0oooo00H0oooo0P0000060?ooo`030000003oool0000000L0oooo0P00
00050?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool000000?ooo`000000oooo00<0
0000103oool3000000030?ooo`000000000000<0000000@0oooo000000000000oooo0P0000020?oo
o`030000003oool0oooo00H0oooo0P0000060?ooo`400000000010000000oooo0?ooo`3oool20000
00L0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000D0oooo00<000000?ooo`3oool0
0P0000000`3oool0000000000002000000@0oooo0`0000001P3oool000000?ooo`3oool000000?oo
o`80000000<0oooo0000003oool01P3oool00`000000oooo0?ooo`020?ooo`800000203oool20000
00L0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000D0oooo00<000000?ooo`3oool0
0P0000000`3oool0000000000002000000@0oooo0`0000001P3oool000000?ooo`3oool000000?oo
o`80000000<0oooo0000003oool01P3oool00`000000oooo0?ooo`020?ooo`800000203oool20000
00L0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000D0oooo00<000000?ooo`3oool0
0P0000000`3oool0000000000002000000@0oooo0`0000001P3oool000000?ooo`3oool000000?oo
o`80000000<0oooo0000003oool01P3oool00`000000oooo0?ooo`020?ooo`800000203oool20000
00L0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000D0oooo00<000000?ooo`3oool0
0P0000000`3oool0000000000002000000@0oooo0`0000001P3oool000000?ooo`3oool000000?oo
o`80000000<0oooo0000003oool01P3oool00`000000oooo0?ooo`020?ooo`8000001`3oool10000
000000<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo0080oooo00L000000?ooo`3o
ool000000?ooo`000000oooo008000000`3oool200000080oooo0P0000000`3oool0000000000002
000000D0oooo1`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001@3oool200000080oooo00<0
00000?ooo`3oool00P3oool01`000000oooo0?ooo`000000oooo0000003oool00P0000030?ooo`80
00000P3oool2000000030?ooo`0000000000008000001@3oool700000080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000050?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo
0000003oool000000?ooo`02000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P00
00050?ooo`L000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo0P0000020?ooo`030000
003oool0oooo0080oooo00L000000?ooo`3oool000000?ooo`000000oooo008000000`3oool20000
0080oooo0P0000000`3oool0000000000002000000D0oooo1`0000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000001@3oool10000000000<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo0P000000203oool000000?ooo`000000oooo0000003oool00000
0P3oool5000000H0oooo1@0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1@3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo00@0oooo0P000000203oool000000?ooo`000000oooo
0000003oool000000P3oool5000000H0oooo1@0000020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo0P000000203oool00000
0?ooo`000000oooo0000003oool000000P3oool5000000H0oooo1@0000020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo0P00
0000203oool000000?ooo`000000oooo0000003oool000000P3oool5000000H0oooo1@0000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?oo
o`030000003oool0oooo00@0oooo0@00000000030000003oool0oooo00D0oooo00<000000?ooo`00
00001`3oool00`000000oooo000000020?ooo`80000000D0oooo0000003oool000000?ooo`020000
00030?ooo`000000oooo00L0oooo0P000000103oool000000?ooo`0000030?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo000000060?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo000000070?ooo`030000003oool000000080oooo0P0000001@3oool00000
0?ooo`000000oooo0080000000<0oooo0000003oool01`3oool2000000040?ooo`000000oooo0000
00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0000000H0oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0000000L0oooo00<000000?ooo`0000000P3o
ool2000000050?ooo`000000oooo0000003oool00P0000000`3oool000000?ooo`070?ooo`800000
00@0oooo0000003oool000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`0000001P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`0000001`3oool0
0`000000oooo000000020?ooo`80000000D0oooo0000003oool000000?ooo`02000000030?ooo`00
0000oooo00L0oooo0P000000103oool000000?ooo`0000030?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo000000060?ooo`040000003oool0oooo0?ooo`80000000000`000000
oooo0?ooo`040?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool00P3oool20000
00<0oooo00D000000?ooo`00000000000?ooo`02000000L0oooo00L000000?ooo`00000000000?oo
o`000000oooo00<000000`3oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`000000oooo
0?ooo`02000000D0oooo00@000000?ooo`00000000001P3oool00`000000oooo0?ooo`020?ooo`80
00000`3oool01@000000oooo000000000000oooo008000001`3oool01`000000oooo000000000000
oooo0000003oool00`0000030?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003o
ool0oooo008000001@3oool010000000oooo0000000000060?ooo`030000003oool0oooo0080oooo
0P0000030?ooo`050000003oool000000000003oool00P0000070?ooo`070000003oool000000000
003oool000000?ooo`03000000<0oooo00<000000?ooo`3oool0103oool2000000D0oooo00<00000
0?ooo`3oool00P0000050?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool00P3o
ool2000000<0oooo00D000000?ooo`00000000000?ooo`02000000L0oooo00L000000?ooo`000000
00000?ooo`000000oooo00<000000`3oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`00
0000oooo0?ooo`0200000040oooo0@00000000030000003oool0oooo00D0oooo0P0000060?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool00000
00800000203oool2000000030?ooo`000000oooo008000001`3oool00`000000oooo0?ooo`030000
00P0oooo0P0000070?ooo`8000001P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo00000002000000P0oooo0P0000000`3oool000000?ooo`02
000000L0oooo00<000000?ooo`3oool00`0000080?ooo`8000001`3oool2000000H0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000P00
00080?ooo`80000000<0oooo0000003oool00P0000070?ooo`030000003oool0oooo00<00000203o
ool2000000L0oooo0P0000060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0000000800000203oool2000000030?ooo`000000oooo00800000
1`3oool00`000000oooo0?ooo`03000000P0oooo0P0000020?ooo`40000000000`000000oooo0?oo
o`060?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`0000000`0000080?ooo`<0000000@0oooo000000000000oooo0P0000000`3oool0
000000000005000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo000000070?ooo`80
00001@3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000000`0000080?ooo`<0000000@0oooo000000000000oooo0P0000000`3oool0000000000005
000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo000000070?ooo`8000001@3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`00
00080?ooo`<0000000@0oooo000000000000oooo0P0000000`3oool0000000000005000000@0oooo
00<000000?ooo`3oool0103oool00`000000oooo000000070?ooo`8000001@3oool00`000000oooo
0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`0000080?ooo`<0
000000@0oooo000000000000oooo0P0000000`3oool0000000000005000000@0oooo00<000000?oo
o`3oool0103oool010000000oooo0000003oool10000000000<000000?ooo`3oool01@3oool20000
0080oooo00@000000?ooo`3oool000001@3oool020000000oooo0?ooo`3oool000000?ooo`000000
oooo100000090?ooo`80000000<0oooo0000000000000`0000001@3oool00000000000000000oooo
00@000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000L0oooo0P0000020?oo
o`040000003oool0oooo000000D0oooo00P000000?ooo`3oool0oooo0000003oool000000?ooo`@0
00002@3oool2000000030?ooo`000000000000<0000000D0oooo00000000000000000?ooo`040000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo000000070?ooo`8000000P3oool01000
0000oooo0?ooo`0000050?ooo`080000003oool0oooo0?ooo`000000oooo0000003oool4000000T0
oooo0P0000000`3oool0000000000003000000050?ooo`00000000000000003oool0100000030?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`0000001`3oool200000080oooo00@000000?oo
o`3oool000001@3oool020000000oooo0?ooo`3oool000000?ooo`000000oooo100000090?ooo`80
000000<0oooo0000000000000`0000001@3oool00000000000000000oooo00@000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool000000080oooo0@00000000030000003oool0oooo00@0
oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`000000103oool01`000000oooo0?oo
o`3oool000000?ooo`0000000P3oool4000000T0oooo00D000000?ooo`000000oooo000000030?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool00P3oool02@000000oooo0?ooo`3oool000000?ooo`00
0000oooo000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`@000002@3o
ool01@000000oooo0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?oo
o`090000003oool0oooo0?ooo`000000oooo0000003oool0000000@0oooo00L000000?ooo`3oool0
oooo0000003oool000000080oooo100000090?ooo`050000003oool000000?ooo`0000000`3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo0080oooo00T000000?ooo`3oool0oooo0000003oool00000
0?ooo`000000103oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool4000000T0oooo
00D000000?ooo`000000oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool01@3oool01@000000oooo0?ooo`3oool0000000<0oooo0P00000000030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool000000080oooo00<00000
0?ooo`3oool00`3oool010000000oooo0000003oool4000000X0oooo0`0000020?ooo`8000000P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool01@000000oooo
0000003oool000000080oooo00<000000?ooo`3oool00`3oool010000000oooo0000003oool40000
00X0oooo0`0000020?ooo`8000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`3oool00`3o
ool010000000oooo0000003oool4000000X0oooo0`0000020?ooo`8000000P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool00000
0080oooo00<000000?ooo`3oool00`3oool010000000oooo0000003oool4000000X0oooo0`000002
0?ooo`8000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`4000000@3oool10000000000H000000?ooo`3oool000000?oo
o`0000070?ooo`040000003oool000000?ooo`<0000000<0oooo0000000000000P0000001@3oool0
00000?ooo`000000oooo00<000002P3oool200000080oooo00@000000?ooo`3oool000000`3oool0
1@000000oooo0?ooo`3oool0000000L0oooo0P0000060?ooo`030000003oool0000000L0oooo00@0
00000?ooo`000000oooo0`0000000`3oool0000000000002000000050?ooo`000000oooo0000003o
ool00`00000:0?ooo`8000000P3oool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo
0?ooo`0000001`3oool2000000H0oooo00<000000?ooo`0000001`3oool010000000oooo0000003o
ool3000000030?ooo`00000000000080000000D0oooo0000003oool000000?ooo`03000000X0oooo
0P0000020?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000070?oo
o`8000001P3oool00`000000oooo000000070?ooo`040000003oool000000?ooo`<0000000<0oooo
0000000000000P0000001@3oool000000?ooo`000000oooo00<000002P3oool200000080oooo00@0
00000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000L0oooo0P0000060?ooo`40
000000000`000000oooo000000020?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0
oooo0`0000000`3oool000000000000200000080oooo00<000000?ooo`0000000`00000;0?ooo`03
0000003oool000000080000000H0oooo0000003oool000000?ooo`0000060?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000060?ooo`040000003o
ool0oooo0?ooo`<0000000<0oooo0000000000000P0000020?ooo`030000003oool0000000<00000
2`3oool00`000000oooo00000002000000060?ooo`000000oooo0000003oool000001P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool000001P3oool0
10000000oooo0?ooo`3oool3000000030?ooo`0000000000008000000P3oool00`000000oooo0000
0003000000/0oooo00<000000?ooo`0000000P0000001P3oool000000?ooo`000000oooo000000H0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo0000
00H0oooo00@000000?ooo`3oool0oooo0`0000000`3oool000000000000200000080oooo00<00000
0?ooo`0000000`00000;0?ooo`030000003oool000000080000000H0oooo0000003oool000000?oo
o`0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool10000000000D0
00000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0000000<000003@3oool3000000030?ooo`00000000000080
00001`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000L0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo00000003000000d0oooo0`0000000`3oool0000000000002000000L0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`000000
0`00000=0?ooo`<0000000<0oooo0000000000000P0000070?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000<000003@3oool30000
00030?ooo`0000000000008000001`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
000000H0oooo0@00000000070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`8000000`3oool00`000000oooo
0?ooo`0:0?ooo`D0000000<0oooo0000003oool00P0000020?ooo`030000003oool0oooo00@0oooo
0P0000000`3oool000000?ooo`070?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool0000000@0oooo0P0000030?ooo`030000003oool0oooo00X0
oooo1@0000000`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool0103oool200000003
0?ooo`000000oooo00L0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`000000103oool2000000<0oooo00<000000?ooo`3oool02P3oool50000
00030?ooo`000000oooo008000000P3oool00`000000oooo0?ooo`040?ooo`80000000<0oooo0000
003oool01`3oool00`000000oooo000000040?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000040?ooo`8000000`3oool00`000000oooo0?ooo`0:0?ooo`D0000000<0oooo
0000003oool00P0000020?ooo`030000003oool0oooo00@0oooo0P0000000`3oool000000?ooo`06
0?ooo`400000000020000000oooo0?ooo`000000oooo0000003oool000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00<000000?ooo`00
00003@3oool4000000030?ooo`000000oooo0080000000@0oooo00000000000000000P3oool50000
00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000<0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`030000003o
ool0000000d0oooo100000000`3oool000000?ooo`02000000040?ooo`000000000000000080oooo
1@0000050?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool00`00
0000oooo0000000=0?ooo`@0000000<0oooo0000003oool00P000000103oool00000000000000002
0?ooo`D000001@3oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000000`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo
00<000000?ooo`0000003@3oool4000000030?ooo`000000oooo0080000000@0oooo000000000000
00000P3oool5000000D0oooo00<000000?ooo`3oool00P3oool10000000000<000000?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`80000000@0oooo000000000000oooo0P00000=0?ooo`030000003oool0000000<0000000<0oooo
0000003oool00`0000000`3oool0000000000003000000H0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool000000080oooo0P000000103oool000000000003oool2000000d0oooo00<000000?ooo`00
00000`0000000`3oool000000?ooo`03000000030?ooo`000000000000<000001P3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`0000000P3oool2000000040?ooo`00000000000?ooo`8000003@3o
ool00`000000oooo00000003000000030?ooo`000000oooo00<0000000<0oooo0000000000000`00
00060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`80000000@0oooo00000000
0000oooo0P00000=0?ooo`030000003oool0000000<0000000<0oooo0000003oool00`0000000`3o
ool0000000000003000000H0oooo00<000000?ooo`3oool00`3oool10000000000<000000?ooo`3o
ool01P3oool2000000d0oooo0P000000103oool0000000000000000?0?ooo`80000000@0oooo0000
003oool000000`3oool00`000000oooo000000060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000001`3oool2000000d0oooo0P000000103oool0000000000000000?0?ooo`80000000@0
oooo0000003oool000000`3oool00`000000oooo000000060?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`0000001`3oool2000000d0oooo0P000000103oool0000000000000000?0?ooo`80
000000@0oooo0000003oool000000`3oool00`000000oooo000000060?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`0000001`3oool2000000d0oooo0P000000103oool0000000000000000?
0?ooo`80000000@0oooo0000003oool000000`3oool00`000000oooo000000060?ooo`030000003o
ool0oooo00@0oooo00@000000?ooo`000000oooo0@00000000030000003oool0oooo00D0oooo0P00
00000`3oool000000?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
0P3oool200000080oooo00<000000?ooo`3oool0303oool01@000000oooo0000003oool0000000<0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?oo
o`0000001`3oool2000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000020?ooo`8000000P3oool00`000000oooo0?ooo`0<0?ooo`050000003oool0
00000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
1P3oool00`000000oooo000000070?ooo`80000000<0oooo0000003oool00P3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo00000080oooo0P0000020?ooo`030000003oool0oooo00`0
oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000060?ooo`030000003oool0000000L0oooo0P0000000`3oool000000?ooo`02
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool200000080oooo00<0
00000?ooo`3oool0303oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`0000000P3oool100000000
00<000000?ooo`3oool01@3oool01`000000oooo0000003oool000000?ooo`000000103oool01000
0000oooo0000000000030?ooo`040000003oool0000000000100oooo00L000000?ooo`000000oooo
0000003oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00H0oooo00L000000?ooo`000000oooo0000003oool0000000@0oooo00@00000
0?ooo`00000000000`3oool010000000oooo00000000000@0?ooo`070000003oool000000?ooo`00
0000oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`060?ooo`070000003oool000000?ooo`000000oooo000000040?ooo`040000003o
ool00000000000<0oooo00@000000?ooo`0000000000403oool01`000000oooo0000003oool00000
0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01P3oool01`000000oooo0000003oool000000?ooo`000000103oool010000000oooo
0000000000030?ooo`040000003oool0000000000100oooo00L000000?ooo`000000oooo0000003o
ool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`040000003o
ool0oooo0?ooo`40000000000`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000
0P3oool3000000040?ooo`0000000000000000@0oooo1@00000A0?ooo`<0000000<0oooo0000003o
ool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`00
00001@3oool01@000000oooo0?ooo`3oool000000080oooo0`000000103oool00000000000000004
0?ooo`D000004@3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`<0000000@0oooo0000000000000000103oool500000140oooo0`0000000`3oool00000
0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo
000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool3000000040?ooo`00000000000000
00@0oooo1@00000A0?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00@000000?ooo`000000oooo0@00000000030000003oool0oooo
00@0oooo00<000000?ooo`3oool00`3oool3000000040?ooo`000000000000000080oooo00D00000
0?ooo`00000000000?ooo`0200000140oooo0P0000000`3oool00000000000020?ooo`8000001@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080000000<0oooo0000003oool01@3o
ool00`000000oooo0?ooo`030?ooo`<0000000@0oooo00000000000000000P3oool01@000000oooo
000000000000oooo008000004@3oool2000000030?ooo`00000000000080oooo0P0000050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`050?ooo`03
0000003oool0oooo00<0oooo0`000000103oool000000000000000020?ooo`050000003oool00000
0000003oool00P00000A0?ooo`80000000<0oooo0000000000000P3oool2000000D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`02000000030?ooo`000000oooo00D0oooo00<00000
0?ooo`3oool00`3oool3000000040?ooo`000000000000000080oooo00D000000?ooo`0000000000
0?ooo`0200000140oooo0P0000000`3oool00000000000020?ooo`8000001@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080000000@0oooo0000003oool0oooo0@00000000040000
003oool0oooo00000080oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000020?oo
o`050000003oool000000?ooo`0000004@3oool010000000oooo0000000000020?ooo`<00000103o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo00@000000?ooo`3oool0
00002`3oool010000000oooo0?ooo`0000020?ooo`050000003oool000000?ooo`0000004@3oool0
10000000oooo0000000000020?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo000000H0oooo00@000000?ooo`3oool000002`3oool010000000oooo0?ooo`0000020?oo
o`050000003oool000000?ooo`0000004@3oool010000000oooo0000000000020?ooo`<00000103o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo00@000000?ooo`3oool0
00002`3oool010000000oooo0?ooo`0000020?ooo`050000003oool000000?ooo`0000004@3oool0
10000000oooo0000000000020?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo000000H0oooo0@00000000030000003oool0000000<0oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool0000000D0oooo0`0000000`3oool000000000000B0?ooo`<00000
00@0oooo00000000000000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0
000000D0oooo0`0000000`3oool000000000000B0?ooo`<0000000@0oooo00000000000000000P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000050?ooo`050000003o
ool0oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000D0oooo0`0000000`3oool0
00000000000B0?ooo`<0000000@0oooo00000000000000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000001P3oool0
1@000000oooo0?ooo`3oool0000000D0oooo0`0000000`3oool000000000000B0?ooo`<0000000@0
oooo00000000000000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
0P0000060?ooo`400000000010000000oooo0?ooo`3oool2000000H0oooo00D000000?ooo`3oool0
oooo000000040?ooo`<000000P3oool2000001<0oooo100000040?ooo`060000003oool000000000
003oool000000P3oool010000000oooo0000000000080?ooo`8000001P3oool01@000000oooo0?oo
o`3oool0000000@0oooo0`0000020?ooo`8000004`3oool4000000@0oooo00H000000?ooo`000000
00000?ooo`0000020?ooo`040000003oool00000000000P0oooo0P0000060?ooo`050000003oool0
oooo0?ooo`000000103oool300000080oooo0P00000C0?ooo`@00000103oool01P000000oooo0000
00000000oooo00000080oooo00@000000?ooo`0000000000203oool2000000H0oooo00D000000?oo
o`3oool0oooo000000040?ooo`<000000P3oool2000001<0oooo100000040?ooo`060000003oool0
00000000003oool000000P3oool010000000oooo0000000000070?ooo`40000000000`000000oooo
0?ooo`03000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000020?ooo`800000
5@3oool010000000oooo0?ooo`0000040?ooo`80000000<0oooo0000003oool00P0000000`3oool0
00000?ooo`080?ooo`<000001P3oool00`000000oooo0?ooo`050?ooo`030000003oool000000080
oooo0P00000E0?ooo`040000003oool0oooo000000@0oooo0P0000000`3oool000000?ooo`020000
00030?ooo`000000oooo00P0oooo0`0000060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`0000000P3oool2000001D0oooo00@000000?ooo`3oool00000103oool2000000030?ooo`000000
oooo0080000000<0oooo0000003oool0203oool3000000H0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo000000020?ooo`8000005@3oool010000000oooo0?ooo`0000040?ooo`80000000<0
oooo0000003oool00P0000000`3oool000000?ooo`080?ooo`40000000000`000000oooo0?ooo`02
00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo0P00
00000`3oool000000?ooo`02000001D0oooo0P000000103oool000000?ooo`0000030?ooo`030000
003oool00000008000001@3oool00`000000oooo0?ooo`030?ooo`8000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool2000000030?ooo`000000oooo0080
00005@3oool2000000040?ooo`000000oooo000000<0oooo00<000000?ooo`0000000P0000050?oo
o`030000003oool0oooo00<0oooo0P0000020?ooo`050000003oool0oooo0?ooo`000000103oool0
0`000000oooo0?ooo`020?ooo`80000000<0oooo0000003oool00P00000E0?ooo`80000000@0oooo
0000003oool000000`3oool00`000000oooo00000002000000D0oooo00<000000?ooo`3oool00`3o
ool200000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo
0P0000000`3oool000000?ooo`02000001D0oooo0P000000103oool000000?ooo`0000030?ooo`03
0000003oool00000008000001@3oool00`000000oooo0?ooo`030?ooo`400000000010000000oooo
0?ooo`0000020?ooo`050000003oool000000?ooo`000000103oool010000000oooo0?ooo`3oool3
000000030?ooo`0000000000008000005@3oool4000000030?ooo`00000000000080oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0000000@0oooo00P000000?ooo`3oool00000
0?ooo`000000oooo000000@0oooo00@000000?ooo`3oool0oooo0`0000000`3oool0000000000002
000001D0oooo100000000`3oool00000000000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool00`000000oooo000000040?ooo`080000003oool0oooo0000003oool000000?ooo`0000040?oo
o`040000003oool0oooo0?ooo`<0000000<0oooo0000000000000P00000E0?ooo`@0000000<0oooo
0000000000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`000000103o
ool020000000oooo0?ooo`000000oooo0000003oool00000103oool010000000oooo0?ooo`3oool3
000000030?ooo`0000000000008000005@3oool4000000030?ooo`00000000000080oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0000000@0oooo0@00000000030000003oool0
000000@0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`020?ooo`@000005P3oool0
1@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000203oool00`000000oooo0?oo
o`020?ooo`@000005P3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000
203oool00`000000oooo0?ooo`020?ooo`@000005P3oool01@000000oooo0?ooo`3oool0000000T0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`020?ooo`@000005P3oool01@000000
oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`80000000000`000000oooo0?ooo`050?ooo`<0000000@0oooo0000003oool0oooo100000020?oo
o`040000003oool000000?ooo`8000005`3oool010000000oooo0000003oool300000080oooo00@0
00000?ooo`3oool00000203oool2000000H0oooo0`000000103oool000000?ooo`3oool400000080
oooo00@000000?ooo`000000oooo0P00000G0?ooo`040000003oool000000?ooo`<000000P3oool0
10000000oooo0?ooo`0000080?ooo`8000001P3oool3000000040?ooo`000000oooo0?ooo`@00000
0P3oool010000000oooo0000003oool2000001L0oooo00@000000?ooo`000000oooo0`0000020?oo
o`040000003oool0oooo000000P0oooo0P0000060?ooo`<0000000@0oooo0000003oool0oooo1000
00020?ooo`040000003oool000000?ooo`8000005`3oool010000000oooo0000003oool300000080
oooo00@000000?ooo`3oool00000203oool200000040oooo0@00000000030000003oool0oooo00D0
oooo0P0000000`3oool000000?ooo`06000000050?ooo`000000oooo0000003oool00P00000G0?oo
o`<0000000<0oooo0000000000000P0000000`3oool000000?ooo`050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000001P3oool2000000030?ooo`000000oooo00H0000000D0oooo0000
003oool000000?ooo`02000001L0oooo0`0000000`3oool0000000000002000000030?ooo`000000
oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000060?ooo`80000000<0oooo
0000003oool01P0000001@3oool000000?ooo`000000oooo008000005`3oool3000000030?ooo`00
000000000080000000<0oooo0000003oool01@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0000000H0oooo0P0000000`3oool000000?ooo`06000000050?ooo`000000oooo0000003oool0
0P00000G0?ooo`<0000000<0oooo0000000000000P0000000`3oool000000?ooo`050?ooo`030000
003oool0oooo0080oooo00@000000?ooo`000000oooo0@00000000030000003oool0oooo00D0oooo
00@000000?ooo`3oool0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool20000
01L0oooo0P0000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000@0oooo100000060?ooo`040000003oool0oooo0?ooo`8000000`3oool01@000000oooo
0?ooo`3oool000000080oooo0P00000G0?ooo`8000000P3oool01@000000oooo0000003oool00000
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`@000001P3oool010000000oooo0?ooo`3o
ool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000005`3oool200000080oooo
00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool40000
00H0oooo00@000000?ooo`3oool0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool2000001L0oooo0P0000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo100000010?ooo`40000000000`000000oooo0?ooo`040?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02000001X0oooo
0`0000020?ooo`040000003oool0oooo000000P0oooo0P0000000`3oool000000?ooo`050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02000001X0
oooo0`0000020?ooo`040000003oool0oooo000000P0oooo0P0000000`3oool000000?ooo`050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020000
01X0oooo0`0000020?ooo`040000003oool0oooo000000P0oooo0P0000000`3oool000000?ooo`05
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02
000001X0oooo0`0000020?ooo`040000003oool0oooo000000P0oooo0P000000103oool000000?oo
o`3oool10000000000<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00P000000?ooo`00000000000?ooo`000000oooo000001T0oooo00@000000?oo
o`000000oooo0P0000030?ooo`8000001@3oool00`000000oooo000000040?ooo`050000003oool0
oooo0?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`080000003oool000000000003oool0
00000?ooo`00000I0?ooo`040000003oool000000?ooo`8000000`3oool2000000D0oooo00<00000
0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00P3o
ool020000000oooo000000000000oooo0000003oool000006@3oool010000000oooo0000003oool2
000000<0oooo0P0000050?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo0000
00050?ooo`030000003oool0oooo0080oooo00P000000?ooo`00000000000?ooo`000000oooo0000
01T0oooo00@000000?ooo`000000oooo0P0000030?ooo`8000001@3oool00`000000oooo00000004
0?ooo`80000000001P000000oooo0?ooo`000000oooo000000D0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`000000oooo00@000006P3oool010000000oooo0000000000030?ooo`80
000000<0oooo0000000000000`0000000`3oool000000?ooo`030?ooo`050000003oool000000?oo
o`0000001@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0000003oool01000000J
0?ooo`040000003oool00000000000<0oooo0P0000000`3oool0000000000003000000030?ooo`00
0000oooo00<0oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool000000?ooo`04000001X0oooo00@000000?ooo`00000000000`3oool20000
00030?ooo`000000000000<0000000<0oooo0000003oool00`3oool01@000000oooo0000003oool0
000000D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`000000oooo00@000006P3o
ool010000000oooo0000000000030?ooo`80000000<0oooo0000000000000`0000000`3oool00000
0?ooo`030?ooo`4000000@3oool10000000000<000000?ooo`0000000P3oool00`000000oooo0?oo
o`0:0?ooo`80000000@0oooo0000000000000000803oool200000080oooo1@0000020?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`3oool00000303oool2000000040?ooo`00000000000000
0200oooo0P0000020?ooo`D000000P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000000`0oooo0P000000103oool0000000000000000P0?ooo`8000000P3oool500000080oooo00<0
00000?ooo`3oool00`3oool010000000oooo0?ooo`00000<0?ooo`80000000@0oooo000000000000
0000803oool200000080oooo1@0000020?ooo`030000003oool0oooo00@0oooo0@00000000070000
003oool0oooo0?ooo`000000oooo000000040?ooo`060000003oool0oooo0?ooo`000000oooo0P00
00020?ooo`<00000703oool00`000000oooo00000002000000H0oooo00@000000?ooo`3oool00000
203oool00`000000oooo000000040?ooo`060000003oool0oooo0?ooo`000000oooo0P0000020?oo
o`<00000703oool00`000000oooo00000002000000H0oooo00@000000?ooo`3oool00000203oool0
0`000000oooo000000040?ooo`060000003oool0oooo0?ooo`000000oooo0P0000020?ooo`<00000
703oool00`000000oooo00000002000000H0oooo00@000000?ooo`3oool00000203oool00`000000
oooo000000040?ooo`060000003oool0oooo0?ooo`000000oooo0P0000020?ooo`<00000703oool0
0`000000oooo00000002000000H0oooo00@000000?ooo`3oool000001`3oool10000000000@00000
0?ooo`3oool0oooo0P0000001@3oool000000000003oool0000000<0oooo0`0000030?ooo`<00000
703oool00`000000oooo00000002000000070?ooo`000000oooo0?ooo`000000oooo000000060?oo
o`030000003oool0oooo00<0oooo0P0000001@3oool000000000003oool0000000<0oooo0`000003
0?ooo`<00000703oool00`000000oooo00000002000000070?ooo`000000oooo0?ooo`000000oooo
000000060?ooo`030000003oool0oooo00<0oooo0P0000001@3oool000000000003oool0000000<0
oooo0`0000030?ooo`<00000703oool00`000000oooo00000002000000070?ooo`000000oooo0?oo
o`000000oooo000000060?ooo`030000003oool0oooo00<0oooo0P0000001@3oool000000000003o
ool0000000<0oooo0`0000030?ooo`<00000703oool00`000000oooo00000002000000070?ooo`00
0000oooo0?ooo`000000oooo000000060?ooo`030000003oool0oooo0080oooo0@00000000040000
003oool0oooo00000080oooo0P0000020?ooo`040000003oool0oooo0?ooo`80000000@0oooo0000
003oool0oooo0P0000000`3oool000000?ooo`0K0?ooo`8000000P3oool010000000oooo0?ooo`00
00080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P0000020?ooo`040000003o
ool0oooo0?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool000000?ooo`0K0?ooo`80
00000P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00P0000020?ooo`040000003oool0oooo0?ooo`80000000@0oooo0000003oool0oooo0P00
00000`3oool000000?ooo`0K0?ooo`8000000P3oool010000000oooo0?ooo`0000080?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00P0000020?ooo`040000003oool0oooo0?ooo`80
000000@0oooo0000003oool0oooo0P0000000`3oool000000?ooo`0K0?ooo`8000000P3oool01000
0000oooo0?ooo`0000080?ooo`030000003oool0oooo00<0oooo0@00000000030000003oool00000
00H0oooo00<000000?ooo`0000000P0000020?ooo`030000003oool0oooo00@000007`3oool30000
00030?ooo`000000oooo00@0oooo00<000000?ooo`3oool00`3oool010000000oooo000000000006
0?ooo`030000003oool00000008000000P3oool00`000000oooo0?ooo`04000001l0oooo0`000000
0`3oool000000?ooo`040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`00000000001P3o
ool00`000000oooo0000000200000080oooo00<000000?ooo`3oool01000000O0?ooo`<0000000<0
oooo0000003oool0103oool00`000000oooo0?ooo`030?ooo`040000003oool00000000000H0oooo
00<000000?ooo`0000000P0000020?ooo`030000003oool0oooo00@000007`3oool3000000030?oo
o`000000oooo00@0oooo00<000000?ooo`3oool00`3oool010000000oooo0000003oool100000000
00<000000?ooo`3oool01@3oool010000000oooo0000000000060?ooo`030000003oool000000080
00007P3oool3000000080?ooo`000000oooo0000003oool000000?ooo`0000050?ooo`030000003o
ool0000000L0oooo00@000000?ooo`00000000001P3oool00`000000oooo00000002000001h0oooo
0`000000203oool000000?ooo`000000oooo0000003oool000001@3oool00`000000oooo00000007
0?ooo`040000003oool00000000000H0oooo00<000000?ooo`0000000P00000N0?ooo`<0000000P0
oooo0000003oool000000?ooo`000000oooo000000D0oooo00<000000?ooo`0000001`3oool01000
0000oooo0000000000060?ooo`030000003oool00000008000007P3oool3000000080?ooo`000000
oooo0000003oool000000?ooo`0000050?ooo`030000003oool000000080oooo0@00000000030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00<000000?ooo`3oool07@3oool2000000050?ooo`000000oooo0000003oool00P000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`03
0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`0M0?ooo`800000
00D0oooo0000003oool000000?ooo`02000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00H000000?ooo`3oool000000?ooo`000002
0?ooo`030000003oool0oooo01d0oooo0P0000001@3oool000000?ooo`000000oooo008000000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3o
ool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool07@3oool200000005
0?ooo`000000oooo0000003oool00P0000030?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool0oooo0@00000000030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`000000oooo0080000000<0oooo0000000000008@3oool3000000040?ooo`000000
00000?ooo`<000000P3oool300000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0000003oool00P0000000`3oool000000000000Q0?ooo`<00000
00@0oooo000000000000oooo0`0000020?ooo`<000000P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool000000?ooo`02000000030?ooo`0000000000
0240oooo0`000000103oool000000000003oool300000080oooo0`0000020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`000000oooo0080000000<0
oooo0000000000008@3oool3000000040?ooo`00000000000?ooo`<000000P3oool300000080oooo
0@0000010?ooo`400000000010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0000000200000200oooo0`000000103oool00000
0?ooo`3oool200000080oooo0`0000030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000800000803oool30000
00040?ooo`000000oooo0?ooo`8000000P3oool3000000<0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P00
000P0?ooo`<0000000@0oooo0000003oool0oooo0P0000020?ooo`<000000`3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0000000200000200oooo0`000000103oool000000?ooo`3oool200000080oooo0`0000030?oo
o`030000003oool0oooo0040000000000`000000oooo000000030?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool0oooo0P0000020?ooo`8000008P3oool00`000000oooo000000030?oo
o`030000003oool0oooo00<000001P3oool01@000000oooo0?ooo`3oool0000000@0oooo00@00000
0?ooo`3oool0oooo0P0000020?ooo`8000008P3oool00`000000oooo000000030?ooo`030000003o
ool0oooo00<000001P3oool01@000000oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool0
oooo0P0000020?ooo`8000008P3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0
00001P3oool01@000000oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool0oooo0P000002
0?ooo`8000008P3oool00`000000oooo000000030?ooo`030000003oool0oooo00<000001`3oool1
0000000000@000000?ooo`3oool0oooo0P0000040?ooo`040000003oool0oooo0?ooo`80000000<0
oooo0000000000000P00000S0?ooo`D000000P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00@0oooo0P0000040?ooo`040000003oool0oooo0?ooo`80000000<0oooo000000000000
0P00000S0?ooo`D000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo
0P0000040?ooo`040000003oool0oooo0?ooo`80000000<0oooo0000000000000P00000S0?ooo`D0
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`04
0000003oool0oooo0?ooo`80000000<0oooo0000000000000P00000S0?ooo`D000000P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0@00000000030000003oool0oooo0080
00000P3oool4000000030?ooo`00000000000080oooo1000000S0?ooo`H0000000<0oooo0000003o
ool00`3oool00`000000oooo0?ooo`040?ooo`8000000P3oool4000000030?ooo`00000000000080
oooo1000000S0?ooo`H0000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`040?ooo`80
00000P3oool4000000030?ooo`00000000000080oooo1000000S0?ooo`H0000000<0oooo0000003o
ool00`3oool00`000000oooo0?ooo`040?ooo`8000000P3oool4000000030?ooo`00000000000080
oooo1000000S0?ooo`H0000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`040?ooo`40
0000000010000000oooo0?ooo`0000020?ooo`@0000000<0oooo0000000000000`3oool200000003
0?ooo`000000oooo02@0oooo0`0000000`3oool000000?ooo`020?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`04000000030?ooo`000000000000<0oooo0P0000000`3o
ool000000?ooo`0T0?ooo`<0000000<0oooo0000003oool00P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool0100000000`3oool00000000000030?ooo`80000000<0oooo
0000003oool0903oool3000000030?ooo`000000oooo0080oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo00@0000000<0oooo0000000000000`3oool2000000030?ooo`00
0000oooo02@0oooo0`0000000`3oool000000?ooo`020?ooo`050000003oool0oooo0?ooo`000000
103oool10000000000<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`80000000<0
oooo0000003oool0903oool3000000030?ooo`000000oooo0080oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool2000000030?oo
o`000000oooo02@0oooo0`0000000`3oool000000?ooo`020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000000`3oool0
00000?ooo`0T0?ooo`<0000000<0oooo0000003oool00P3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`80000000<0oooo0000
003oool0903oool3000000030?ooo`000000oooo0080oooo00D000000?ooo`3oool0oooo00000004
0?ooo`80000000000`000000oooo0?ooo`050?ooo`060000003oool0oooo0?ooo`000000oooo0P00
00000`3oool000000?ooo`0V0?ooo`<000000`3oool2000000D0oooo00<000000?ooo`0000001P3o
ool01P000000oooo0?ooo`3oool000000?ooo`80000000<0oooo0000003oool09P3oool3000000<0
oooo0P0000050?ooo`030000003oool0000000H0oooo00H000000?ooo`3oool0oooo0000003oool2
000000030?ooo`000000oooo02H0oooo0`0000030?ooo`8000001@3oool00`000000oooo00000006
0?ooo`060000003oool0oooo0?ooo`000000oooo0P0000000`3oool000000?ooo`0V0?ooo`<00000
0`3oool2000000D0oooo00@000000?ooo`000000oooo0@00000000030000003oool0oooo00@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`@000009`3oool3000000050?ooo`00000000000000
003oool00P000000103oool000000000003oool2000000D0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`@000009`3oool3000000050?ooo`00000000000000003oool00P000000103oool00000
0000003oool2000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`@000009`3oool30000
00050?ooo`00000000000000003oool00P000000103oool000000000003oool2000000D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`@000009`3oool3000000050?ooo`00000000000000003o
ool00P000000103oool000000000003oool200000040oooo0@00000000030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo00000004000002P0oooo00<000000?ooo`00
00000P000000103oool000000000003oool200000080oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0000000@00000:03oool00`000000oooo000000020000
00040?ooo`00000000000?ooo`8000000P3oool00`000000oooo000000030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`0000001000000X0?ooo`030000003oool000000080000000@0oooo
000000000000oooo0P0000020?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo00000004000002P0oooo00<000000?ooo`0000000P000000103oool000000000
003oool200000080oooo00<000000?ooo`0000000@00000000060000003oool0oooo0000003oool0
0000103oool010000000oooo0000000000020?ooo`030000003oool0oooo02P0oooo0P0000030?oo
o`040000003oool0oooo000000@0oooo00D000000?ooo`000000oooo000000040?ooo`040000003o
ool0000000000080oooo00<000000?ooo`3oool0:03oool2000000<0oooo00@000000?ooo`3oool0
0000103oool01@000000oooo0000003oool0000000@0oooo00@000000?ooo`00000000000P3oool0
0`000000oooo0?ooo`0X0?ooo`8000000`3oool010000000oooo0?ooo`0000040?ooo`050000003o
ool000000?ooo`000000103oool010000000oooo0000000000020?ooo`030000003oool0oooo02P0
oooo0P0000030?ooo`040000003oool0oooo000000@0oooo0@0000010?ooo`40000000000`000000
oooo000000020?ooo`@0000000H0oooo000000000000oooo0000003oool2000002T0oooo0`000000
0`3oool00000000000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01000
00001P3oool000000000003oool000000?ooo`800000:@3oool3000000030?ooo`00000000000080
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`04000000060?ooo`0000000000
0?ooo`000000oooo0P00000Y0?ooo`<0000000<0oooo0000000000000P3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00@0000000H0oooo000000000000oooo0000003oool20000
02T0oooo0`0000000`3oool00000000000020?ooo`040000003oool0oooo000000@0oooo0@000000
00040000003oool0oooo0?ooo`@0000000H0oooo000000000000oooo0000003oool2000002/0oooo
00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00@0oooo100000001P3oool0
00000000003oool000000?ooo`800000:`3oool01@000000oooo0000003oool0000000@0oooo00<0
00000?ooo`3oool0103oool4000000060?ooo`00000000000?ooo`000000oooo0P00000[0?ooo`05
0000003oool000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`@0000000H0oooo0000
00000000oooo0000003oool2000002/0oooo00D000000?ooo`000000oooo000000040?ooo`030000
003oool0oooo00<0oooo0@00000000040000003oool0oooo000000@0oooo00@000000?ooo`3oool0
oooo1000000]0?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`000000103oool010000000oooo0?ooo`3oool4000002d0oooo0P0000020?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`040000003oool0oooo0?ooo`@00000
;@3oool200000080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00@000000?ooo`3oool0oooo1000000]0?ooo`8000000P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo0?ooo`40000000000`000000oooo000000040?ooo`060000003oool0oooo
0?ooo`000000oooo0P00000]0?ooo`030000003oool0oooo0080000000@0oooo000000000000oooo
1@0000040?ooo`060000003oool0oooo0?ooo`000000oooo0P00000]0?ooo`030000003oool0oooo
0080000000@0oooo000000000000oooo1@0000040?ooo`060000003oool0oooo0?ooo`000000oooo
0P00000]0?ooo`030000003oool0oooo0080000000@0oooo000000000000oooo1@0000040?ooo`06
0000003oool0oooo0?ooo`000000oooo0P00000]0?ooo`030000003oool0oooo0080000000@0oooo
000000000000oooo100000010?ooo`40000000000`000000oooo0?ooo`040?ooo`030000003oool0
oooo0080oooo0`00000_0?ooo`80000000@0oooo000000000000oooo100000060?ooo`030000003o
ool0oooo0080oooo0`00000_0?ooo`80000000@0oooo000000000000oooo100000060?ooo`030000
003oool0oooo0080oooo0`00000_0?ooo`80000000@0oooo000000000000oooo100000060?ooo`03
0000003oool0oooo0080oooo0`00000_0?ooo`80000000@0oooo000000000000oooo100000020?oo
o`400000000010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`@00000;`3oool2
000000040?ooo`00000000000?ooo`8000000`3oool00`000000oooo000000020?ooo`040000003o
ool0oooo0?ooo`@00000;`3oool2000000040?ooo`00000000000?ooo`8000000`3oool00`000000
oooo000000020?ooo`040000003oool0oooo0?ooo`@00000;`3oool2000000040?ooo`0000000000
0?ooo`8000000`3oool00`000000oooo000000020?ooo`040000003oool0oooo0?ooo`@00000;`3o
ool2000000040?ooo`00000000000?ooo`8000000`3oool100000040oooo0@00000000040000003o
ool000000?ooo`80000000D0oooo00000000000000000?ooo`0200000380oooo0`0000000`3oool0
00000?ooo`020?ooo`040000003oool000000?ooo`80000000D0oooo00000000000000000?ooo`02
00000380oooo0`0000000`3oool000000?ooo`020?ooo`040000003oool000000?ooo`80000000D0
oooo00000000000000000?ooo`0200000380oooo0`0000000`3oool000000?ooo`020?ooo`040000
003oool000000?ooo`80000000D0oooo00000000000000000?ooo`0200000380oooo0`0000000`3o
ool000000?ooo`020?ooo`030000003oool0oooo0040000000000`000000oooo0?ooo`0200000004
0?ooo`000000000000000080oooo0P00000a0?ooo`<0000000D0oooo0000003oool0oooo00000004
0?ooo`80000000@0oooo00000000000000000P3oool200000340oooo0`0000001@3oool000000?oo
o`3oool0000000@0oooo0P000000103oool000000000000000020?ooo`800000<@3oool300000005
0?ooo`000000oooo0?ooo`000000103oool2000000040?ooo`000000000000000080oooo0P00000a
0?ooo`<0000000D0oooo0000003oool0oooo000000040?ooo`400000000010000000oooo0?ooo`00
00040?ooo`040000003oool00000000003D0oooo00H000000?ooo`00000000000?ooo`0000020?oo
o`800000103oool010000000oooo00000000000e0?ooo`060000003oool000000000003oool00000
0P3oool2000000@0oooo00@000000?ooo`0000000000=@3oool01P000000oooo000000000000oooo
00000080oooo0P0000040?ooo`040000003oool00000000003D0oooo00H000000?ooo`0000000000
0?ooo`0000020?ooo`80000000000`000000oooo000000030?ooo`<0000000<0oooo0000003oool0
=03oool01@000000oooo000000000000oooo0080000000<0oooo0000000000000`3oool300000003
0?ooo`000000oooo03@0oooo00D000000?ooo`00000000000?ooo`02000000030?ooo`0000000000
00<0oooo0`0000000`3oool000000?ooo`0d0?ooo`050000003oool000000000003oool00P000000
0`3oool00000000000030?ooo`<0000000<0oooo0000003oool0=03oool01@000000oooo00000000
0000oooo0080000000<0oooo0000003oool00@00000000050000003oool0oooo0000003oool01@00
000g0?ooo`D0000000<0oooo0000003oool00P0000000`3oool0000000000003000003L0oooo1@00
00000`3oool000000?ooo`02000000030?ooo`000000000000<00000=`3oool5000000030?ooo`00
0000oooo0080000000<0oooo0000000000000`00000g0?ooo`D0000000<0oooo0000003oool00P00
000000040000003oool000000?ooo`D00000>@3oool01P000000oooo0000003oool000000?ooo`80
000000<0oooo0000000000000`00000i0?ooo`060000003oool000000?ooo`000000oooo0P000000
0`3oool0000000000003000003T0oooo00H000000?ooo`000000oooo0000003oool2000000030?oo
o`000000000000<00000>@3oool020000000oooo0000003oool000000?ooo`000000oooo0@000000
00050000003oool0oooo0000003oool00`00000k0?ooo`030000003oool0000000<0000000<0oooo
0000003oool00`00000k0?ooo`030000003oool0000000<0000000<0oooo0000003oool00`00000k
0?ooo`030000003oool0000000<0000000<0oooo0000003oool00`00000k0?ooo`030000003oool0
000000<000000@3oool10000000000<000000?ooo`0000000`00000n0?ooo`T00000?P3oool90000
03h0oooo2@00000n0?ooo`L0000000000`000000oooo0000000200000400oooo00<000000?ooo`00
0000100000100?ooo`030000003oool0000000@00000@03oool00`000000oooo0000000400000400
oooo00D000000?ooo`00000000000?ooo`010000000000<000000?ooo`3oool0o`3ooolM0?ooo`40
0000003o0000024000000000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250052, \
0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["XSound", "\<\
000P0040800Z0E01K@5m0Gl1LP5I0CD12`7P0KT1V@650H01R06O0L01j@4D0Cd1
G`5f0Gl1N`5X0DT18P7g0Ld1Z@6>0H41PP6A0Jd1dP7m0BL1CP5[0G`1O`5c0E/1
>04>0N<1^`6K0HL1P0680Id1_P7V0A41>P5L0G@1O`5k0FT1B`4U0OX1d06[0I01
PP620I01Z`7@0OX1905;0FT1N`5n0G@1G04j0A41iP6n0Ih1R0610HL1W06l0N<1
3P4g0EX1LP5n0G/1JP5=0BL1o@7C0Jh1T`630H81T06Z0Ld1m`4Q0DP1IP5i0Gh1
M05M0C`1507Y0L41X06:0H81R06K0KX1h04;0C@1E`5`0G`1NP5Z0Dh1:@400MH1
/@6E0HD1P`6@0JT1b`7d0Ah1A@5S0GH1O05d0Eh1?P4F0N`1a06S0Hd1Q0680I/1
^07N0@P1<05D0Fd1NP5i0FX1C`4/0@<1f@6e0IP1R0650I01Z07:0O416`510F01
M05j0G<1GP4o0AT1k`780JL1T0660HT1V`6g0M`11@4]0E01JP5h0GP1JP5@0Bd1
1@7M0KP1W06;0HL1T@6W0LP1k`4H0Ch1G05a0GP1LP5N0D016`7b0L/1ZP6C0HP1
R`6K0KH1fP420BX1C05V0GD1MP5Y0E41;`480N01_06O0Hh1R@6B0JP1a`7]0AD1
>P5I0Fd1M@5`0Eh1@@4M0OD1c`6^0IL1R`6=0I`1]P7H0Ol19P580F81L@5c0FP1
D@4`0@X1h`700J<1T@6<0I@1Z0760N/14@4f0ED1J@5b0Fh1G@520Al1n07C0K81
V`6?0I01W@6f0ML1o@4S0D@1GP5]0G01IP5@0C413@7W0L@1Z06E0Hl1UP6Y0LD1
j@4>0C81D05U0Fl1J`5L0D81807k0MH1]`6O0I<1T`6O0KH1eP7j0Al1@05J0FT1
K@5T0Dl1<P4?0NX1b06/0IX1T`6I0JX1a@7W0@/1;P5<0F41J`5X0EX1@@4Q0Oh1
fP6k0J@1U`6F0J41]`7E0OP1704l0ED1I@5Y0F41CP4b0A41k@7<0K41WP6G0I`1
[0750NH12@4Z0DL1G05V0FD1F0510B81007N0L01Z@6L0IX1Y06h0MD1mP4H0CL1
D05P0FD1GP5<0C814P7`0M01]@6S0I`1W`6^0LH1i0460BH1@`5G0F41H@5E0D01
8`420N41a06^0J41WP6W0KX1e@7d0AD1<`5;0E/1H05J0DX1<P4C0O<1e06j0JT1
X@6S0K41a`7T0@<18`4n0E81G05L0E81?P4S0@@1i@790K<1YP6S0J/1_07E0O<1
4P4_0DH1EP5K0EH1B04a0A@1mP7H0Kl1[P6V0JP1]0780N<10@4O0CT1C05G0EP1
CP4l0B<11P7X0Lh1^06[0JP1[`6n0MH1l@4?0BX1@@5@0EH1DP550C015@7h0M`1
a@6d0J/1[@6g0LX1h`7o0A/1=0570E41D`5:0CX18`480N`1dP6n0K41[@6c0L41
e`7`0@`19P4k0DX1D05=0D41;P4F0O/1h07:0KT1/@6b0K/1c07S0Od1604_0D41
B`5=0DH1=`4R0@T1k`7G0L@1]`6c0KP1a07H0O012@4R0CH1A05:0DP1?P4/0AH1
o@7T0Ll1_`6g0KL1_`7?0N@1o04D0BX1>`550DL1@@4d0B412P7b0M/1b@6m0KT1
_@780MX1k`470Ah1<@4n0D@1@`4j0BX15@7o0NP1e0750Kd1_@740M81i@7k0A41
9@4e0Cl1@@4l0C417`4:0O@1h07?0L@1_`720L`1g07_0@D16P4[0CP1?P4m0CD1
9`4E0@01j`7I0L`1a0730LT1e@7V0OX13P4Q0Bl1>04k0CL1;@4M0@/1m`7T0MD1
bP760LP1d07N0O010`4F0BH1<@4g0CL1<04T0A@10@7_0Mh1dP7:0LT1cP7I0NP1
n@4;0A`1:@4b0CD1<@4Y0A/12`7i0NP1fP7A0L`1cP7E0N41l@410A81804[0C41
<@4[0B014P420O81h`7H0M41d07D0Md1jP7i0@T15`4S0B/1;P4[0B@1604:0O/1
k07P0ML1d`7D0MX1i07b0@013`4K0BD1:P4Z0BD17@4A0@<1m@7X0Mh1f07F0MX1
h@7/0OT11P4C0Ah1904W0BD17`4E0@T1o07`0ND1gP7J0M/1h07X0O<1o`4;0AH1
7P4S0B<1804I0@l10`7g0Nd1i07O0Md1h07V0Nl1n@450@l1604N0B017`4J0A81
207n0O<1j`7T0N41hP7U0N`1m@7o0@T14@4H0A`1704J0A@130430OX1l@7Z0NH1
i07V0N/1lP7j0@<12`4B0AL16@4H0A@13P470Ol1m`7`0N/1j07X0N/1l07g0Oh1
1P4=0A815@4E0A<13`490@<1o07e0O01k@7/0Nd1l07e0O/10P480@d1404B0A41
3`4:0@D1o`7j0OD1l@7_0Nl1l@7e0OT1oP440@P1304>0@h13@4:0@H10P7m0OT1
mP7d0O<1m07f0OT1o@410@@11`4:0@X12P490@H10`400O`1nP7h0OL1m`7h0OX1
o07o0@4110460@L11`460@D10`410Ol1o@7k0OX1nP7j0O/1o@7n0@010@420@<1
0`430@810P410@01o`7n0Oh1oP7n0Oh1o`7o0Ol100400@0100400Ol1o`7o0Ol1
00400@410@410@410@410@01o`7o0Oh1o@7l0O`1o07m0Oh1o`410@8110450@D1
1@440@810@7n0O`1nP7i0OP1n07j0O/1oP400@<11P480@T12@480@H10`7o0O`1
n@7g0OD1m@7f0OP1n`7o0@<11P4:0@`1304<0@T11P420Od1n@7e0O81l@7b0O@1
m`7l0@411P4:0@h1404@0@h12P450@01nP7e0O41kP7]0Nl1lP7h0Oh1104:0@l1
4P4D0A813`4:0@@1o@7f0O01k07Z0NX1k@7c0OT10@480@l1504G0AL1504?0@P1
007h0O41j`7W0NH1j07]0O@1o0450@h1504I0A/16@4E0@h11P7l0O<1j`7V0N<1
h`7W0Nh1m`410@X14`4J0Ah17P4K0AD130410OL1k@7U0N01g`7R0NL1l07k0@H1
4@4I0Al18P4P0A/14`480O`1l@7W0N01g07L0N41j@7d0@01304G0B01904U0B41
6P4?0@<1mP7Z0N01fP7H0M/1hP7/0OT11P4C0Ah19P4Y0BL18@4G0@X1o07_0N<1
fP7E0MD1f`7T0O41o`4>0A/19@4[0B`1:04O0A<1107e0NL1f`7D0M41e07L0NP1
mP460AH18P4[0Bl1;P4W0A`13@7m0Nd1g`7D0Ll1c`7D0Ml1k@7n0@l17P4Z0C41
<`4_0BD15`460OD1i07G0Lh1b`7=0MH1h`7d0@H1604V0C41=P4e0Bd18@4@0Oh1
j`7K0Ll1b0780Lh1f@7Y0O`13`4Q0Bl1=`4i0CD1:`4K0@P1m@7R0M81b0740LL1
d07O0O411P4I0BX1=P4l0C/1=04V0A@1o`7Z0MP1bP720L41a`7D0NH1nP4@0B<1
<`4m0D01?04`0Al12`7e0N01c`730Kh1`07:0MX1kP450A/1;@4k0D81@P4j0B/1
5`410NX1e@760K`1^`710Ll1hP7h0A019P4g0D81AP520CH1904=0OD1gP7;0Kh1
^06j0L@1e@7[0@<16`4`0D01B0580D01<04K0@81jP7C0L81]`6e0K/1b@7N0OH1
3`4W0C/1A`5<0DP1?04X0A01mP7M0LP1^@6b0K@1_P7@0NP10P4L0C<1A05>0Dh1
AP4e0Al11@7Z0M41_P6b0Jl1]@740MT1l`4?0BT1?P5<0E81CP510Bd14`7h0Md1
a@6e0Jd1[P6i0L/1i0400A`1=@580E<1E05<0C/18`470NX1d06j0Jd1Z@6_0Kh1
e@7`0@h1:P510E41E`5D0DL1<P4G0OT1g0730K41Z06X0K<1aP7P0Oh1704g0D/1
E`5I0E41@04W0@T1j`7>0KL1Z@6T0JX1^@7A0Nd13@4Z0D<1E@5L0ET1C04f0AX1
n`7L0L41[@6S0J<1[@710Md1o04L0CP1CP5L0El1E`550B/1307/0Lh1]@6U0Il1
Y06d0L`1jP4;0B/1A@5H0F41G`5A0C/17P7m0M`1`06Z0Ih1WP6X0Kd1f@7i0A/1
>@5A0F01H`5L0DX1;`4?0Nd1c@6c0J41VP6O0Jl1b07W0@T1:P570E/1I@5T0EL1
@04Q0Ol1g@6o0JP1V`6I0J<1^07E0OL16P4j0E<1H`5X0F41C`4c0A81k`7=0K41
WP6F0IX1ZP730N@11`4Z0DP1GP5Y0FP1F`540BD10P7N0Kh1Y@6G0ID1WP6c0M41
m04H0CX1E@5V0F`1I@5C0CL15@7`0Ld1/06K0I81UP6U0Kl1h0450BT1B@5P0F`1
K05P0DT1:@440Ml1_P6T0I@1T@6J0Jl1c@7a0AL1>P5F0FT1L05Z0EP1>`4H0O81
cP6_0IT1S`6B0J41^`7M0@<1:0590F81K`5`0F@1C@4/0@L1h@6n0J81T@6=0IH1
Z`790Nh15@4i0EL1J`5c0Fh1G04o0A`1m@7?0Jl1U`6<0Hh1W@6g0MT1004W0DT1
H`5b0G@1J05A0C012P7R0Kh1X@6?0HX1TP6V0LD1j`4C0CP1F05]0GH1L@5P0D<1
7`7g0M01[`6F0HX1R`6I0K<1eP7m0BD1B@5T0G@1M`5/0ED1=04=0N@1_`6Q0Hd1
Q`6>0J<1`P7W0A01=`5H0Fh1N05e0F@1A`4R0OX1dP6_0ID1R0680ID1[`7B0OX1
8`580FD1MP5i0Fl1F04g0A01i`700J41S0650H/1W`6n0N@13P4f0EL1K`5j0GL1
I`5;0BH1o@7D0K01U@660HD1TP6/0Ll1m`4Q0DL1I@5g0G`1LP5L0C/14`7Y0L81
X@6;0H<1R@6L0K/1h@4;0C@1E`5`0G`1NP5Z0Dh1:@7o0MH1/@6E0HD1P`6?0JP1
b`7d0Al1A@5T0GP1O@5e0El1?P4F0N`1``6R0H/1PP660IT1]`7N0@P1<P5E0Fl1
O@5l0Fd1D@4/0@81f06b0ID1Q0610Hd1Y@780O4170540F<1N05o0GL1HP510AT1
kP750J<1R`610HD1U`6d0M/11@4_0E@1K`5m0Gd1K`5D0Bl11@7K0K@1UP640H01
R`6S0LD1kP4I0D81HP5h0Gl1N@5T0D@1707a0LP1Y@6<0H01P`6D0K81f0430Bd1
DP5^0Gd1OP5a0EH1<P480Md1]P6G0HD1P0690J41`P7[0AL1?`5Q0GL1O`5j0FH1
A`4O0O@1bP6V0Hd1P0620I<1[`7E0@01:P5@0Fd1O@5o0G81F@4e0@/1h06i0IT1
Q@600HP1W`700NT1504m0El1MP5o0G/1J0590B81m`7=0JT1SP610H81T@6]0M81
o@4W0Dh1J`5l0Gl1L`5K0CP13P7S0K/1V`670H01R06M0Kh1iP4A0CX1G05d0Gl1
N`5Y0D/19@7j0M01Z`6@0H81PP6@0J/1d07j0B@1B`5Y0G/1OP5d0E`1>P4A0NH1
_P6N0HP1P@670I`1_07S0@h1=`5J0G81OP5k0FX1C@4W0Od1d`6^0I<1P`620I01
ZP7=0OL18@580FH1N@5n0G@1G@4l0A@1j@710J01RP620HP1V`6j0N012`4d0EL1
L05l0GX1JP5>0BT1007F0K41U@650H<1T06Y0L/1m04N0DD1H`5f0G`1M05N0Ch1
5P7/0L@1X`6=0H@1R06K0KP1gP480C01E05]0GX1N@5Z0Dl1;0430MT1]@6H0HP1
Q@6@0JP1bP7a0A/1@@5P0G@1NP5c0Eh1?`4I0Nl1b06W0I01QP690I/1]`7L0@D1
;@5@0FX1N05h0FX1D04]0@D1g@6h0I`1R`670I41Y`780Nl1604n0E`1L@5h0G81
GP500A/1lP7;0JX1T`680H/1V`6f0MX10P4Z0D`1IP5e0GH1J@5A0Bl1207P0K`1
W`6>0HT1TP6X0LL1k@4E0CX1F@5]0GD1L05N0D417@7e0Ll1[P6G0H/1S@6L0KH1
f07o0BH1B05R0G41L`5X0E41<04:0N<1`06S0I41S06D0JP1aP7[0A41=P5E0FT1
LP5^0Ed1@P4O0OP1d`6b0I/1S`6@0Id1]P7G0Od18`540Eh1K@5`0FH1D04a0@d1
i`740JP1U@6?0IH1Z@750NT13P4b0E01I@5_0F/1G0520B01n`7F0KL1W`6C0I<1
W`6f0MH1nP4O0D01FP5Y0Fd1I05?0C813`7Z0LP1[06J0I<1V@6Z0LD1i`4;0Bh1
C05Q0F/1J05J0D418@7n0MX1^`6T0IL1UP6Q0KL1e@7h0A`1?05E0FD1J@5Q0Dh1
<P4A0Nd1c06a0Ih1U`6L0J`1a@7V0@T1:P570E`1IP5U0EP1@@4R0@01gP700JT1
W06J0J@1^07E0OH1604g0E01H05U0Eh1C04b0A81l07@0KD1X`6L0Il1[P760N@1
1P4V0D<1E`5Q0F41E@500B<10P7Q0L@1[P6Q0Ih1Y`6j0MD1m04E0C<1B`5K0F01
FP5:0C814`7c0M@1^P6Y0J41X`6a0LL1i0430B<1?P5B0E`1G05B0Ch18`440ND1
b@6c0JH1X`6[0K`1e@7c0A81;`560EH1F`5F0DP1<@4D0OH1f06o0Jh1YP6X0K@1
b07S0@417`4i0D`1E`5H0Dh1?04S0@H1j07>0KP1Z`6X0Jl1_P7F0O413`4Z0D41
D05F0E81A@4`0AD1n07L0LD1]06[0Jd1]`7:0N<1o`4K0C@1A`5A0E<1BP4j0B<1
207/0M81_P6a0Jd1/`710ML1l04<0BH1>`5:0E01C@510Bh15P7k0N01bP6i0K41
/P6k0L`1h`7m0AP1;`510D/1C@560CL18P490Nl1e`740KL1/`6h0L@1f07`0@T1
8P4f0D@1BP580Ch1;04F0Od1i07?0Kl1]`6g0Kl1c`7T0O`1504Z0C/1A@570D41
=04Q0@X1lP7K0LT1_@6i0Kd1b07J0Nl11`4N0C41?P540D<1>P4Z0AD1o`7X0M@1
a@6m0Kd1a07B0ND1n`4A0BD1=@4o0D41?04a0Al12P7d0N01c`740Kl1`P7<0M`1
k`450AX1:`4h0Ch1?@4e0BL15@400N/1f@7<0L@1``790MD1iP7j0@h18@4_0CP1
>`4g0Bd17@4;0OL1i07E0LX1aP780M01gP7`0@<15P4V0C41=`4g0C01904D0@41
k`7N0M81bP790Lh1f@7X0OT12`4L0BT1<P4e0C41:@4K0@/1n@7X0MX1d@7<0Lh1
e@7Q0O410@4B0B01:`4a0C41:`4P0A810P7b0N<1f07A0M01e07M0NX1n@490AL1
8`4[0Bh1:`4T0AP12P7k0N`1h07G0M<1e07J0N@1lP400@l16`4U0BX1:P4U0Ad1
4@430OD1j07N0MP1eP7J0N41k07i0@H14`4N0B@19`4U0Al15@490O`1l07U0Mh1
fP7K0N01j07c0Ol12`4F0Ah18`4S0B016@4?0@<1m`7]0N@1g`7M0N01iP7_0OT1
1@4?0AP17P4P0Al16P4B0@P1oP7c0N/1i07Q0N81i@7/0OD1o`490A41604L0A`1
6P4D0@`10`7j0O41jP7V0N@1iP7[0O81nP430@/14P4G0AT1604D0@h11`7o0OL1
l07[0NP1j07[0O01m`7n0@H13@4B0AD15@4C0@l12@430O`1m@7`0Nd1k07]0O01
m@7k0@81204=0A014P4A0@l12P450Ol1nP7e0O41k`7_0O41m@7i0Oh110480@`1
3P4>0@d12P460@81o@7i0OH1m07c0O@1mP7i0Od10@440@L12P4:0@X12@460@<1
007l0OX1n07g0OL1n07j0O`1o`410@@11P470@L11P450@<10@7o0Od1n`7j0OX1
nP7k0Od1oP400@410P430@<10`420@810@400Ol1oP7n0Oh1oP7n0Ol1o`7o0@01
00400@01007o0Ol1o`7o0@0100410@410@410@410@400Ol1o`7n0Od1o07l0O`1
o@7n0Ol10@420@@11@450@D110420@41oP7l0OX1n@7h0OP1nP7k0Oh100430@H1
20490@T120460@<1o`7l0OT1m`7e0OD1mP7h0O/1o`430@H12P4<0@`130490@H1
0P7m0OT1m@7b0O41lP7d0OL1o0410@H12P4>0A01404>0@X11@400OX1m@7a0Nh1
k@7_0O81n07n0@@12P4?0A81504B0@l12P440Od1mP7`0N`1jP7Z0Nd1l`7i0@41
204?0A@15`4G0A@13`480@01n07a0N/1i`7V0NP1k@7d0O`11@4>0A@16@4K0AT1
5@4>0@H1o07c0N/1iP7S0N<1i`7^0OL10@4:0A<16P4N0Ah16`4E0@`10@7g0Nd1
i@7P0Ml1hP7W0O01n`460A416@4O0B81804K0A<1207l0O41i`7P0M`1g07Q0NT1
m0400@`15`4P0B@19@4Q0AX13`430OH1jP7P0MX1f07K0N81k07i0@H14`4N0BH1
:@4W0B415`4:0O`1k`7S0MX1e@7E0M/1i07a0Ol13P4K0BD1:`4/0BP17`4C0@@1
m@7W0M/1e07A0M@1g07X0OH11P4F0B81:`4_0Bh19`4L0@d1o@7]0Ml1e07?0Ll1
e07O0Nd1oP4?0Ah1:P4a0C<1;`4U0AL11P7e0N@1e`7>0L/1c@7F0N<1m0460AP1
9P4a0CH1=@4]0B41407n0N/1f`7?0LP1b07>0MT1j@7l0@l18@4_0CL1>@4e0B/1
6`480OD1hP7B0LP1a0770M01g`7a0@H16@4Z0CH1?04k0C@19P4D0Ol1jP7H0LX1
`P710LL1e07V0OX1404S0C<1?@500C`1<04O0@/1m@7P0Ll1``6n0L01bP7J0Nh1
1@4K0Bd1>`520D81>P4[0AL10@7Z0MD1aP6l0K/1`@7?0N81n04@0BH1=`520DH1
@P4f0B@13@7e0Mh1b`6n0KP1^P740MD1j`430A/1<0500DP1B0500C016`420NX1
d`720KL1]@6k0LT1gP7f0@l19`4k0DL1C0580C`1:04@0OH1g@780KT1/P6d0Kh1
d07X0@81704c0D@1CP5>0DH1=@4O0@D1jP7A0Kh1/P6_0KD1a07I0O<13`4Y0Ch1
C05B0Dh1@@4]0A<1n07M0LD1]@6]0Jh1^@7;0N@1004L0CD1B05C0E@1C04k0B<1
1`7Z0M01^P6]0JT1[`6n0MD1l04>0BX1@@5A0EL1E0570C815`7i0M`1``6a0JP1
Z06c0LH1h07n0A`1=`5;0EL1F@5A0D019`490N/1cP6g0JT1Y06Z0KT1d@7]0@d1
:P530ED1G05I0D`1=P4J0O/1g0710Jd1X`6S0Jd1`@7M0O`1704h0Dh1G05O0EL1
A@4[0@`1k07>0KD1Y@6O0J@1]07<0NX12`4[0DD1F05Q0El1D@4k0Ah1o@7L0L01
ZP6N0Ih1Z06m0MT1n@4K0CT1D@5P0F<1G05:0Bl13`7]0Ld1/`6Q0IX1W`6_0LP1
i`490BX1A`5K0FD1I05G0D018@7o0Md1_`6X0I/1V@6S0KP1e@7g0AX1>P5C0F<1
J05Q0Dl1<`4B0Nl1c@6a0Ih1UP6J0JX1``7T0@L1:P580Eh1J@5X0E/1A04U0@81
gP6n0JD1U`6E0Ih1/`7A0O@1604j0ED1IP5/0FD1D`4g0AD1l07=0K01V`6B0IH1
Y@6o0N011@4Y0DT1H05/0F`1H0590BT1107O0Kh1Y06D0I41VP6_0Ld1l@4G0CX1
EP5Y0G01JP5H0C/1607b0Lh1[`6I0Hl1TP6Q0K/1g@430BP1B@5R0Fl1L05T0Dd1
;0470N41_P6R0I41S@6F0J/1b@7^0AD1>@5G0F/1L`5^0E`1?`4L0OD1c`6_0IL1
S06>0Id1]`7I0@019`590F<1LP5d0FP1D@4`0@X1hP6n0J41S`6:0I81YP750N/1
4`4h0EP1K@5f0G41H0530Al1m`7@0Jl1UP6:0H/1V@6c0MH1o@4U0DT1I05d0GL1
K05E0C@13@7T0Kl1X@6=0HL1SP6S0L81i`4@0CL1F05^0GP1M@5T0DL18P7j0M81
[`6E0HP1R06E0Jl1dP7j0B<1B05U0GH1N@5_0EP1=`4@0NL1`06Q0H`1Q@6;0Il1
_P7T0@h1=P5G0Fl1NP5g0FL1B`4V0Od1e06`0ID1QP650I81[07?0OL18@570FD1
M`5l0G81G04k0A<1j@720J41R`630HT1W06k0N412`4d0EL1L05l0GX1JP5>0BT1
o`7F0K41U@650H<1S`6X0L/1m04O0DD1I05h0Gd1M@5O0Ch15P7/0L<1XP6;0H81
QP6I0KL1gP480C81E@5_0Gd1O05]0E41;0420MP1/P6E0H@1P@6=0JD1b07a0A`1
A05S0GP1O`5g0F81@@4I0Nh1a@6S0H/1P@650IL1]07K0@D1;`5D0Fl1O@5m0Fl1
E04_0@D1f`6d0IH1Q0600H/1X`750Nh16@520F81N05o0GT1I0540A`1l@780JD1
S0600H<1U06b0MP10`4]0E81KP5m0Gh1L@5F0C81207M0KH1U`650H01R@6Q0L81
j`4G0Cl1H@5g0Gl1NP5V0DL17`7d0LX1YP6=0H01PP6C0Jl1e@400BX1D05]0Gd1
O`5b0ET1=@4;0N01^@6I0HD1P0680Il1`07Y0A@1?@5O0GH1O`5k0FP1B@4R0OL1
c@6Y0Hh1P@620I41[@7B0Od19`5>0F/1O05o0G<1F`4h0@h1h`6k0I/1Q`600HP1
W@6n0NH14@4j0E`1M05o0G/1J@5;0BD1nP7@0J/1T0620H81T06[0M01nP4T0D/1
J@5k0Gh1M05L0CX14@7V0Kh1WP680H41Q`6L0K`1h`4>0CL1FP5b0Gh1N`5Z0Dd1
9`7m0M<1[P6C0H<1PP6@0JX1c@7g0B41B05V0GT1OP5d0Ed1?04D0NT1`@6P0HX1
PP680I/1^P7P0@/1=05G0G01O05j0FX1CP4Y0@01eP6a0ID1Q@630I01Z@7;0O@1
7P550F<1MP5l0G@1GP4n0AH1k0740J<1S@640HP1V`6h0Mh1204`0E@1K@5j0GT1
JP5?0B`10`7I0KD1V0680HD1T06X0LX1l@4K0D41H05d0GX1L`5N0Cl16@7_0LP1
Y`6@0HH1R@6K0KL1g0450Bd1D05Z0GP1N05Z0E01;@450Md1^06L0H/1Q`6A0JL1
b07_0AP1?P5L0G41N05b0Eh1@04K0O81b`6Z0I<1R06;0I/1]P7J0@81:P5<0FH1
M@5f0FT1D@4_0@P1h06l0Il1SP690I81Z0770Nd15@4j0ET1K@5e0G01GP510Ad1
m@7?0Jh1U`6;0Hd1W06f0MP1o`4V0DP1HP5a0G<1J05A0C012P7S0L01X`6A0H`1
U06X0LH1j`4A0CH1E@5Y0G81KP5M0D817`7h0M<1/P6K0Hl1T06M0KH1e`7m0B<1
A05N0Fd1L05V0E01<@4=0NL1a06X0ID1S`6F0JT1a@7Y0@h1<P5@0FD1K`5[0E`1
@P4P0O/1eP6g0Il1T`6C0Il1]P7F0OX17`500EX1J@5]0F@1C`4b0@l1jP780J`1
VP6C0IT1ZP750NL12`4^0D`1H@5[0FP1FP510B41oP7J0K/1Y06G0IH1X@6g0MD1
n04L0C`1E@5U0FT1H@5>0C814@7]0L`1/@6N0IL1W06/0LD1iP490BX1A`5L0FH1
I@5H0D418P400Mh1`06Y0I`1VP6T0KP1e@7f0AP1=`5@0F01I@5N0D`1<P4B0O01
d06e0J<1W06O0Jh1aP7T0@H19P530EL1H@5Q0ED1@04S0@81h@740Jh1X@6N0JL1
^P7E0O@15@4c0D/1F`5P0EX1BP4b0A<1l`7D0KX1Z@6Q0J<1/@770N@10`4S0Ch1
DP5L0E`1DP4n0B<1107U0LT1/`6V0J<1Z`6l0MD1l`4B0Bl1AP5F0E/1EP580C41
507f0MP1_`6^0JH1Z06d0LP1h`410Al1>@5<0EL1F05>0C`18`460NP1cP6h0J/1
Z06_0Kh1eP7a0@l1:P510E01EP5B0DD1<04E0OP1g0750K@1Z`6]0KL1bP7S0Ol1
6`4d0DL1D@5C0DX1>P4S0@P1k07B0Kh1/@6]0K<1`@7G0O01304V0C/1BP5@0Dd1
@@4^0AH1n`7P0LX1^@6a0K81^`7<0N<1o@4H0Bl1@@5;0Dd1AP4g0B812@7_0ML1
a06g0K<1^0740MP1l0490B81=P540DX1B04n0B`15P7m0N@1c`6o0KL1]`6o0Ll1
i07l0A@1:P4k0DD1A`510C@18@4:0O81f`790Kd1^@6m0LP1fP7_0@L17P4a0Ch1
A0530CX1:P4E0Ol1j07D0LD1_@6m0L@1dP7U0O/14@4U0CD1?`510C`1<@4O0@X1
m07P0Ll1a06o0L81c07L0Nl11@4J0B/1>04n0Cd1=@4W0AD1007[0MT1c0740L<1
b@7E0NH1nP4>0B41;`4h0C/1=`4]0Ad12`7g0N@1e@7:0LH1b07@0Mh1l0430AH1
9P4a0CL1=`4`0B@150410Nl1gP7B0LX1b@7>0MT1j07i0@/1704Y0C81=@4a0BT1
6`4;0OT1j07J0M41c07>0MD1h@7a0@414P4P0B/1<@4a0B/1804B0@81lP7S0MP1
d@7@0M@1g@7Z0OT12@4G0B<1:`4^0B/1904H0@X1n`7/0N01e`7C0M@1fP7T0O81
004?0A/19@4Z0BX19@4M0A410`7e0NP1gP7H0MH1fP7Q0N`1n@460A<17P4T0BL1
9@4O0AD12@7l0O01i@7N0MX1f`7P0NP1l`7o0@/15P4N0B<18`4P0AT13`430OL1
k@7T0Ml1g@7P0NH1k`7i0@D13`4H0Ah1804O0AX14P480Oh1l`7[0N@1h@7R0ND1
k07e0Ol12@4A0AP1704L0AX1504<0@<1nP7a0NX1iP7T0NH1j`7b0OX10`4;0A81
5`4I0AP1504>0@L1o`7g0O01j`7X0NP1j`7`0OL1oP460@d14P4E0AD14`4?0@T1
0`7l0OD1l07]0N`1k@7`0OD1n`420@P13@4@0A814@4?0@X11@7o0OX1m@7a0Nl1
k`7a0OD1n@7n0@@1204<0@h13P4=0@X11P420Od1n@7f0O@1l`7d0OH1n@7m0@41
10470@X12P4:0@T11P430@01o07j0OP1m`7g0OP1nP7l0Ol10@440@H11`470@H1
1@430@41o`7m0O/1nP7j0OX1n`7m0Oh100410@810`430@<10P420@41007o0Oh1
oP7n0Oh1oP7o0Ol1o`400@0100400@01o`7o0Ol1o`400@010@410@410@410@41
007o0Ol1oP7m0O`1o07l0Od1oP7o0@410P440@D11@450@@10P410Oh1o07j0OT1
n07h0OX1n`7n0@010`460@P12@490@P11P430Ol1o07i0OL1m@7e0OH1n07k0Ol1
0`460@X1304<0@`12@460@81o@7i0OD1lP7a0O81m07g0O`10@460@X13P4@0A01
3P4:0@D1007j0OD1l@7^0Nd1k`7b0OP1oP440@X13`4B0A@14P4?0@X1107m0OH1
l07/0NX1jP7]0O<1n@410@P13`4D0AL15`4D0@l120400OP1l@7[0NL1iP7X0Nd1
m07l0@D13P4D0AT16`4I0AD13P460O`1l`7[0NH1h`7S0NL1kP7g0@412P4C0AX1
7P4N0A/15@4<0@41m`7]0ND1h07O0N81i`7`0O/11P4A0AT17`4R0B016`4C0@P1
o07a0NL1h07L0M`1h@7Y0O@1004<0AL1804T0BD18@4J0@l10`7f0NX1h07J0MP1
f`7R0N`1n@460A<17P4V0BT19`4Q0AL12P7l0Nl1h`7J0MD1e@7K0N@1l@7o0@h1
6`4U0B/1;04X0Al14`440OD1i`7K0M@1d@7D0M`1j07f0@H15P4R0B/1;`4^0BL1
704=0Od1k@7O0M@1c`7?0M@1g`7]0Oh13`4N0BX1<@4c0Bl19@4G0@H1m@7T0ML1
cP7;0Ld1eP7S0O@11P4H0BH1<@4f0CD1;@4Q0A01oP7[0M/1c`780LP1cP7I0NT1
o04?0B41;`4g0CT1=@4[0A/1207e0N81dP780L@1a`7@0Ml1l@460AT1:P4f0C`1
>`4d0BH1507o0NX1f07:0L81`@770M@1iP7j0A018`4c0Cd1@04l0C017`4;0OD1
h07?0L<1_P700LX1fP7^0@D16`4]0C/1@P520CX1:`4G0@41jP7E0LH1_06k0L41
c`7R0OP1404V0CL1@P560D81=P4T0@d1m@7N0L/1_P6h0KX1a07E0N/10`4K0C01
@0580DP1@04`0A/10P7Z0M<1`P6g0KD1^`790Mh1mP4?0BL1>`570D`1B04l0BP1
407f0Md1b06i0K81]06n0M01j0420A`1<`540Dh1CP560CD17`450NX1d@6n0K81
[`6e0L@1f@7c0@l1:@4n0D`1DP5>0D41;@4C0OP1g@750KD1[@6^0KT1b`7T0@01
704e0DP1D`5D0D`1>`4S0@L1jP7@0KX1[@6Y0Jl1_P7E0O013P4Z0D41D@5G0E@1
A`4b0AL1n@7L0L<1/@6X0JP1/`760N01oP4L0CL1B`5G0ET1D@500BL12@7[0Lh1
]`6Y0J@1ZP6i0M41k@4=0BX1@`5E0E`1F@5<0CH16P7k0M`1`@6]0J<1X`6]0L41
g@7l0A`1>05>0E`1G`5G0DD1:`4<0N`1cP6e0JD1W`6T0K@1c07Z0@/1:`550EP1
H@5O0E41>`4N0Od1g0700JX1WP6N0JP1_@7I0OT16`4i0E41H05S0E`1BP4_0@l1
k@7=0K<1X@6J0Il1[`780NL12@4Z0DL1F`5U0F@1E`500B41o`7M0Kl1Z06K0IT1
X`6h0MD1m`4J0CX1D`5S0FP1H@5?0C<14P7_0Ld1/@6N0IH1VP6Z0L<1i0470BX1
B05N0FT1J05K0D@19@420Mh1_P6U0IL1U@6N0K<1d@7d0AP1>P5E0FH1K05U0E<1
=`4E0O01c@6`0I/1TP6F0JD1_`7P0@D1:@590F01K05/0F01B@4Y0@@1g`6n0J@1
U06A0IX1[`7=0O415`4j0EH1J@5`0FX1F04k0AP1lP7>0Jl1V@6?0I81X@6k0Md1
0`4X0DT1HP5_0G01I05=0B`11`7Q0Kh1XP6A0Hd1UP6[0LT1kP4E0CT1E`5[0G<1
KP5L0Cl1707e0Ll1[`6G0H`1SP6M0KL1f@400BL1B@5S0G81M05X0E41<04:0N81
_P6Q0Hl1RP6B0JH1a@7[0A<1>05H0Fd1MP5a0F01@`4O0OL1d06_0IH1RP6;0IT1
/`7F0Od19@590F@1M05g0F`1E@4d0@d1i06o0J41S@670Hh1X`720NL1404g0EP1
KP5h0GD1I0570B81nP7B0Jl1U@680HP1U@6_0M81nP4S0DP1I@5f0GT1K`5H0CL1
407W0L01X@6<0HD1R`6O0Kh1i04>0CH1E`5_0GX1M`5W0D/19P7m0M@1/06E0HH1
Q@6B0J`1c`7g0B41A`5U0GL1O05b0E`1>`4C0NT1`P6Q0H/1P`690I`1^`7Q0@/1
=05G0G01O05j0FX1CP4Y0Ol1eP6a0ID1Q@630Hl1Z07;0O@17`550F@1N05m0GD1
G`4n0AH1k0730J81R`620HH1V@6g0Mh1204b0ED1K`5m0G`1K@5A0B`10P7H0K81
U@640H41S@6U0LP1l@4L0D@1H`5h0Gl1M`5R0D416@7^0LD1X`6;0H41Q@6G0K@1
f`450Bl1E05_0Gd1O@5_0E@1;`450M/1]06F0H@1P06;0J<1a@7^0AT1@P5R0GP1
O`5i0F@1A04L0O41b06U0H`1P0630I@1/P7H0@<1;@5B0Fh1O@5n0G41EP4b0@P1
g@6f0IL1Q@600HT1X@720N/15`4o0F41M`5o0GX1IP570Al1m07:0JH1S@600H81
T`6_0MD1004Z0E01K@5m0Gl1LP5I0CD12`7P0KT1V@650H01R06O0L01j@4D0Cd1
G`5f0Gl1N`5X0DT18P7g0Ld1Z@6>0H41PP6A0Jd1dP7m0BL1CP5[0G`1O`5c0E/1
>04>0N<1^`6K0HL1P0680Id1_P7V0A41>P5L0G@1O`5k0FT1B`4U0OX1d06[0I01
PP620I01Z`7@0OX1905;0FT1N`5n0G@1G04j0A41iP6n0Ih1R0610HL1W06l0N<1
3P4g0EX1LP5n0G/1JP5=0BL1o@7C0Jh1T`630H81T06Z0Ld1m`4Q0DP1IP5i0Gh1
M05M0C`1507Y0L41X06:0H81R06K0KX1h04;0C@1E`5`0G`1NP5Z0Dh1:@400MH1
/@6E0HD1P`6@0JT1b`7d0Ah1A@5S0GH1O05d0Eh1?P4F0N`1a06S0Hd1Q0680I/1
^07N0@P1<05D0Fd1NP5i0FX1C`4/0@<1f@6e0IP1R0650I01Z07:0O416`510F01
M05j0G<1GP4o0AT1k`780JL1T0660HT1V`6g0M`11@4]0E01JP5h0GP1JP5@0Bd1
1@7M0KP1W06;0HL1T@6W0LP1k`4H0Ch1G05a0GP1LP5N0D016`7b0L/1ZP6C0HP1
R`6K0KH1fP420BX1C05V0GD1MP5Y0E41;`480N01_06O0Hh1R@6B0JP1a`7]0AD1
>P5I0Fd1M@5`0Eh1@@4M0OD1c`6^0IL1R`6=0I`1]P7H0Ol19P580F81L@5c0FP1
D@4`0@X1h`700J<1T@6<0I@1Z0760N/14@4f0ED1J@5b0Fh1G@520Al1n07C0K81
V`6?0I01W@6f0ML1o@4S0D@1GP5]0G01IP5@0C413@7W0L@1Z06E0Hl1UP6Y0LD1
j@4>0C81D05U0Fl1J`5L0D81807k0MH1]`6O0I<1T`6O0KH1eP7j0Al1@05J0FT1
K@5T0Dl1<P4?0NX1b06/0IX1T`6I0JX1a@7W0@/1;P5<0F41J`5X0EX1@@4Q0Oh1
fP6k0J@1U`6F0J41]`7E0OP1704l0ED1I@5Y0F41CP4b0A41k@7<0K41WP6G0I`1
[0750NH12@4Z0DL1G05V0FD1F0510B81007N0L01Z@6L0IX1Y06h0MD1mP4H0CL1
D05P0FD1GP5<0C814P7`0M01]@6S0I`1W`6^0LH1i0460BH1@`5G0F41H@5E0D01
8`420N41a06^0J41WP6W0KX1e@7d0AD1<`5;0E/1H05J0DX1<P4C0O<1e06j0JT1
X@6S0K41a`7T0@<18`4n0E81G05L0E81?P4S0@@1i@790K<1YP6S0J/1_07E0O<1
4P4_0DH1EP5K0EH1B04a0A@1mP7H0Kl1[P6V0JP1]0780N<10@4O0CT1C05G0EP1
CP4l0B<11P7X0Lh1^06[0JP1[`6n0MH1l@4?0BX1@@5@0EH1DP550C015@7h0M`1
a@6d0J/1[@6g0LX1h`7o0A/1=0570E41D`5:0CX18`480N`1dP6n0K41[@6c0L41
e`7`0@`19P4k0DX1D05=0D41;P4F0O/1h07:0KT1/@6b0K/1c07S0Od1604_0D41
B`5=0DH1=`4R0@T1k`7G0L@1]`6c0KP1a07H0O012@4R0CH1A05:0DP1?P4/0AH1
o@7T0Ll1_`6g0KL1_`7?0N@1o04D0BX1>`550DL1@@4d0B412P7b0M/1b@6m0KT1
_@780MX1k`470Ah1<@4n0D@1@`4j0BX15@7o0NP1e0750Kd1_@740M81i@7k0A41
9@4e0Cl1@@4l0C417`4:0O@1h07?0L@1_`720L`1g07_0@D16P4[0CP1?P4m0CD1
9`4E0@01j`7I0L`1a0730LT1e@7V0OX13P4Q0Bl1>04k0CL1;@4M0@/1m`7T0MD1
bP760LP1d07N0O010`4F0BH1<@4g0CL1<04T0A@10@7_0Mh1dP7:0LT1cP7I0NP1
n@4;0A`1:@4b0CD1<@4Y0A/12`7i0NP1fP7A0L`1cP7E0N41l@410A81804[0C41
<@4[0B014P420O81h`7H0M41d07D0Md1jP7i0@T15`4S0B/1;P4[0B@1604:0O/1
k07P0ML1d`7D0MX1i07b0@013`4K0BD1:P4Z0BD17@4A0@<1m@7X0Mh1f07F0MX1
h@7/0OT11P4C0Ah1904W0BD17`4E0@T1o07`0ND1gP7J0M/1h07X0O<1o`4;0AH1
7P4S0B<1804I0@l10`7g0Nd1i07O0Md1h07V0Nl1n@450@l1604N0B017`4J0A81
207n0O<1j`7T0N41hP7U0N`1m@7o0@T14@4H0A`1704J0A@130430OX1l@7Z0NH1
i07V0N/1lP7j0@<12`4B0AL16@4H0A@13P470Ol1m`7`0N/1j07X0N/1l07g0Oh1
1P4=0A815@4E0A<13`490@<1o07e0O01k@7/0Nd1l07e0O/10P480@d1404B0A41
3`4:0@D1o`7j0OD1l@7_0Nl1l@7e0OT1oP440@P1304>0@h13@4:0@H10P7m0OT1
mP7d0O<1m07f0OT1o@410@@11`4:0@X12P490@H10`400O`1nP7h0OL1m`7h0OX1
o07o0@4110460@L11`460@D10`410Ol1o@7k0OX1nP7j0O/1o@7n0@010@420@<1
0`430@810P410@01o`7n0Oh1oP7n0Oh1o`7o0Ol100400@0100400Ol1o`7o0Ol1
00400@410@410@410@410@01o`7o0Oh1o@7l0O`1o07m0Oh1o`410@8110450@D1
1@440@810@7n0O`1nP7i0OP1n07j0O/1oP400@<11P480@T12@480@H10`7o0O`1
n@7g0OD1m@7f0OP1n`7o0@<11P4:0@`1304<0@T11P420Od1n@7e0O81l@7b0O@1
m`7l0@411P4:0@h1404@0@h12P450@01nP7e0O41kP7]0Nl1lP7h0Oh1104:0@l1
4P4D0A813`4:0@@1o@7f0O01k07Z0NX1k@7c0OT10@480@l1504G0AL1504?0@P1
007h0O41j`7W0NH1j07]0O@1o0450@h1504I0A/16@4E0@h11P7l0O<1j`7V0N<1
h`7W0Nh1m`410@X14`4J0Ah17P4K0AD130410OL1k@7U0N01g`7R0NL1l07k0@H1
4@4I0Al18P4P0A/14`480O`1l@7W0N01g07L0N41j@7d0@01304G0B01904U0B41
6P4?0@<1mP7Z0N01fP7H0M/1hP7/0OT11P4C0Ah19P4Y0BL18@4G0@X1o07_0N<1
fP7E0MD1f`7T0O41o`4>0A/19@4[0B`1:04O0A<1107e0NL1f`7D0M41e07L0NP1
mP460AH18P4[0Bl1;P4W0A`13@7m0Nd1g`7D0Ll1c`7D0Ml1k@7n0@l17P4Z0C41
<`4_0BD15`460OD1i07G0Lh1b`7=0MH1h`7d0@H1604V0C41=P4e0Bd18@4@0Oh1
j`7K0Ll1b0780Lh1f@7Y0O`13`4Q0Bl1=`4i0CD1:`4K0@P1m@7R0M81b0740LL1
d07O0O411P4I0BX1=P4l0C/1=04V0A@1o`7Z0MP1bP720L41a`7D0NH1nP4@0B<1
<`4m0D01?04`0Al12`7e0N01c`730Kh1`07:0MX1kP450A/1;@4k0D81@P4j0B/1
5`410NX1e@760K`1^`710Ll1hP7h0A019P4g0D81AP520CH1904=0OD1gP7;0Kh1
^06j0L@1e@7[0@<16`4`0D01B0580D01<04K0@81jP7C0L81]`6e0K/1b@7N0OH1
3`4W0C/1A`5<0DP1?04X0A01mP7M0LP1^@6b0K@1_P7@0NP10P4L0C<1A05>0Dh1
AP4e0Al11@7Z0M41_P6b0Jl1]@740MT1l`4?0BT1?P5<0E81CP510Bd14`7h0Md1
a@6e0Jd1[P6i0L/1i0400A`1=@580E<1E05<0C/18`470NX1d06j0Jd1Z@6_0Kh1
e@7`0@h1:P510E41E`5D0DL1<P4G0OT1g0730K41Z06X0K<1aP7P0Oh1704g0D/1
E`5I0E41@04W0@T1j`7>0KL1Z@6T0JX1^@7A0Nd13@4Z0D<1E@5L0ET1C04f0AX1
n`7L0L41[@6S0J<1[@710Md1o04L0CP1CP5L0El1E`550B/1307/0Lh1]@6U0Il1
Y06d0L`1jP4;0B/1A@5H0F41G`5A0C/17P7m0M`1`06Z0Ih1WP6X0Kd1f@7i0A/1
>@5A0F01H`5L0DX1;`4?0Nd1c@6c0J41VP6O0Jl1b07W0@T1:P570E/1I@5T0EL1
@04Q0Ol1g@6o0JP1V`6I0J<1^07E0OL16P4j0E<1H`5X0F41C`4c0A81k`7=0K41
WP6F0IX1ZP730N@11`4Z0DP1GP5Y0FP1F`540BD10P7N0Kh1Y@6G0ID1WP6c0M41
m04H0CX1E@5V0F`1I@5C0CL15@7`0Ld1/06K0I81UP6U0Kl1h0450BT1B@5P0F`1
K05P0DT1:@440Ml1_P6T0I@1T@6J0Jl1c@7a0AL1>P5F0FT1L05Z0EP1>`4H0O81
cP6_0IT1S`6B0J41^`7M0@<1:0590F81K`5`0F@1C@4/0@L1h@6n0J81T@6=0IH1
Z`790Nh15@4i0EL1J`5c0Fh1G04o0A`1m@7?0Jl1U`6<0Hh1W@6g0MT1004W0DT1
H`5b0G@1J05A0C012P7R0Kh1X@6?0HX1TP6V0LD1j`4C0CP1F05]0GH1L@5P0D<1
7`7g0M01[`6F0HX1R`6I0K<1eP7m0BD1B@5T0G@1M`5/0ED1=04=0N@1_`6Q0Hd1
Q`6>0J<1`P7W0A01=`5H0Fh1N05e0F@1A`4R0OX1dP6_0ID1R0680ID1[`7B0OX1
8`580FD1MP5i0Fl1F04g0A01i`700J41S0650H/1W`6n0N@13P4f0EL1K`5j0GL1
I`5;0BH1o@7D0K01U@660HD1TP6/0Ll1m`4Q0DL1I@5g0G`1LP5L0C/14`7Y0L81
X@6;0H<1R@6L0K/1h@4;0C@1E`5`0G`1NP5Z0Dh1:@7o0MH1/@6E0HD1P`6?0JP1
b`7d0Al1A@5T0GP1O@5e0El1?P4F0N`1``6R0H/1PP660IT1]`7N0@P1<P5E0Fl1
O@5l0Fd1D@4/0@81f06b0ID1Q0610Hd1Y@780O4170540F<1N05o0GL1HP510AT1
kP750J<1R`610HD1U`6d0M/11@4_0E@1K`5m0Gd1K`5D0Bl11@7K0K@1UP640H01
R`6S0LD1kP4I0D81HP5h0Gl1N@5T0D@1707a0LP1Y@6<0H01P`6D0K81f0430Bd1
DP5^0Gd1OP5a0EH1<P480Md1]P6G0HD1P0690J41`P7[0AL1?`5Q0GL1O`5j0FH1
A`4O0O@1bP6V0Hd1P0620I<1[`7E0@01\>"]},
  ImageCacheContents->"Sound"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["View Interference and Beats", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f = 3;\)\), "\n", 
    \(\(Plot[Sin[\ 2\ \[Pi]\ f\ \ t], {t, 0, 1}, 
        PlotPoints -> 1000];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02474 .31442 L
.02575 .32032 L
.0267 .32585 L
.02761 .33116 L
.02859 .33681 L
.02952 .34224 L
.03052 .34799 L
.03148 .35352 L
.0324 .35883 L
.03338 .36446 L
.03433 .36985 L
.03524 .37502 L
.03621 .38051 L
.03714 .38576 L
.03813 .39131 L
.03908 .39663 L
.04 .40172 L
.04098 .4071 L
.04192 .41224 L
.04292 .41767 L
.04388 .42286 L
.0448 .42782 L
.04579 .43305 L
.04674 .43803 L
.04765 .44279 L
.04862 .4478 L
.04956 .45258 L
.05055 .4576 L
.05151 .46239 L
.05243 .46694 L
.05341 .47173 L
.05435 .47628 L
.05526 .4806 L
.05622 .48514 L
.05715 .48944 L
.05814 .49396 L
.05909 .49824 L
.06001 .50229 L
.06098 .50653 L
.06192 .51055 L
.06292 .51474 L
.06388 .51871 L
.0648 .52245 L
.06579 .52635 L
.06673 .53003 L
.06764 .53349 L
.06861 .5371 L
.06954 .5405 L
.07054 .54402 L
Mistroke
.07149 .54733 L
.07241 .55043 L
.07339 .55364 L
.07433 .55665 L
.07533 .55975 L
.07629 .56264 L
.07722 .56534 L
.07821 .56811 L
.07916 .57069 L
.08007 .57308 L
.08104 .57553 L
.08198 .5778 L
.08297 .58011 L
.08393 .58223 L
.08485 .58418 L
.08584 .58616 L
.08678 .58796 L
.08769 .5896 L
.08866 .59125 L
.08959 .59274 L
.09058 .59422 L
.09153 .59554 L
.09245 .59671 L
.09342 .59785 L
.09436 .59885 L
.09536 .5998 L
.09632 .60061 L
.09725 .60129 L
.09823 .60191 L
.09918 .6024 L
.10009 .60277 L
.1006 .60294 L
.10106 .60306 L
.10154 .60316 L
.10199 .60324 L
.10223 .60327 L
.10247 .60329 L
.10268 .6033 L
.1028 .60331 L
.10291 .60331 L
.10297 .60332 L
.10303 .60332 L
.10306 .60332 L
.10309 .60332 L
.1031 .60332 L
.10312 .60332 L
.10315 .60332 L
.10318 .60332 L
.1032 .60332 L
.10321 .60332 L
Mistroke
.10323 .60332 L
.10324 .60332 L
.10328 .60332 L
.10331 .60332 L
.10334 .60332 L
.1034 .60332 L
.10346 .60331 L
.10351 .60331 L
.10363 .60331 L
.10374 .6033 L
.10384 .60329 L
.10408 .60327 L
.10433 .60324 L
.10477 .60317 L
.10524 .60307 L
.10568 .60296 L
.10662 .60264 L
.10761 .60219 L
.10857 .60164 L
.10949 .60102 L
.11047 .60026 L
.11141 .59941 L
.11232 .59851 L
.11329 .59744 L
.11422 .59632 L
.11521 .59501 L
.11616 .59365 L
.11707 .59225 L
.11805 .59066 L
.11899 .58902 L
.11999 .58718 L
.12095 .5853 L
.12187 .5834 L
.12285 .58127 L
.1238 .57913 L
.12471 .57698 L
.12568 .5746 L
.12662 .57221 L
.12761 .56957 L
.12856 .56694 L
.12948 .56432 L
.13046 .56143 L
.1314 .55857 L
.1324 .55543 L
.13337 .55232 L
.1343 .54923 L
.13528 .54587 L
.13623 .54254 L
.13715 .53926 L
.13812 .53569 L
Mistroke
.13906 .53217 L
.14005 .52835 L
.14101 .52459 L
.14193 .52089 L
.14291 .51688 L
.14386 .51295 L
.14477 .5091 L
.14574 .50493 L
.14667 .50085 L
.14766 .49644 L
.14861 .49213 L
.14953 .48791 L
.1505 .48337 L
.15144 .47893 L
.15244 .47414 L
.1534 .46947 L
.15433 .46493 L
.15532 .46003 L
.15626 .45526 L
.15718 .45063 L
.15815 .44565 L
.15908 .4408 L
.16007 .4356 L
.16103 .43055 L
.16195 .42565 L
.16293 .42039 L
.16387 .41528 L
.16478 .41034 L
.16575 .40504 L
.16668 .39991 L
.16766 .39442 L
.16862 .3891 L
.16953 .38396 L
.1705 .37846 L
.17144 .37314 L
.17244 .36746 L
.1734 .36197 L
.17432 .35667 L
.17531 .35101 L
.17625 .34555 L
.17716 .34028 L
.17813 .33467 L
.17906 .32925 L
.18005 .32349 L
.18101 .31793 L
.18193 .31258 L
.18291 .30689 L
.18385 .30141 L
.18485 .29559 L
.18581 .28998 L
Mistroke
.18674 .2846 L
.18772 .27888 L
.18867 .27338 L
.18959 .26811 L
.19056 .26251 L
.19149 .25713 L
.19249 .25144 L
.19345 .24598 L
.19437 .24075 L
.19535 .2352 L
.19629 .22989 L
.1972 .22481 L
.19817 .21943 L
.1991 .21428 L
.20009 .20885 L
.20104 .20365 L
.20196 .19868 L
.20293 .19343 L
.20387 .18842 L
.20487 .18314 L
.20583 .1781 L
.20676 .1733 L
.20774 .16824 L
.20869 .16342 L
.2096 .15883 L
.21057 .154 L
.2115 .1494 L
.21249 .14458 L
.21345 .13999 L
.21437 .13563 L
.21535 .13106 L
.21629 .12672 L
.2172 .1226 L
.21816 .11829 L
.21909 .1142 L
.22008 .10993 L
.22103 .10589 L
.22194 .10207 L
.22292 .09807 L
.22385 .0943 L
.22485 .09038 L
.22581 .08668 L
.22673 .08319 L
.22771 .07957 L
.22866 .07616 L
.22957 .07296 L
.23054 .06963 L
.23147 .06652 L
.23246 .0633 L
.23341 .06028 L
Mistroke
.23433 .05747 L
.23531 .05456 L
.23625 .05185 L
.23725 .04907 L
.23821 .04649 L
.23914 .0441 L
.24012 .04165 L
.24107 .03938 L
.24198 .0373 L
.24295 .03518 L
.24389 .03323 L
.24488 .03126 L
.24584 .02947 L
.24676 .02784 L
.24774 .0262 L
.24868 .02473 L
.24959 .02341 L
.25056 .02211 L
.25149 .02095 L
.25248 .01983 L
.25343 .01885 L
.25434 .018 L
.25532 .01721 L
.25626 .01655 L
.25725 .01596 L
.25821 .0155 L
.25914 .01516 L
.25961 .01502 L
.26012 .0149 L
.26036 .01485 L
.26061 .01481 L
.26085 .01478 L
.26107 .01476 L
.26131 .01474 L
.26144 .01473 L
.26151 .01472 L
.26158 .01472 L
.26165 .01472 L
.26171 .01472 L
.26177 .01472 L
.2618 .01472 L
.26181 .01472 L
.26183 .01472 L
.26186 .01472 L
.26189 .01472 L
.26192 .01472 L
.26193 .01472 L
.26195 .01472 L
.26198 .01472 L
.262 .01472 L
Mistroke
.26203 .01472 L
.26206 .01472 L
.26212 .01472 L
.26218 .01472 L
.26231 .01472 L
.26242 .01473 L
.26255 .01474 L
.26278 .01476 L
.26299 .01478 L
.26345 .01485 L
.26395 .01496 L
.26494 .01525 L
.26589 .01563 L
.2668 .01609 L
.26777 .01669 L
.2687 .01737 L
.26969 .01821 L
.27065 .01911 L
.27157 .02009 L
.27255 .02122 L
.27349 .02242 L
.2744 .02367 L
.27537 .0251 L
.27629 .02657 L
.27728 .02824 L
.27823 .02995 L
.27915 .03169 L
.28012 .03364 L
.28106 .03561 L
.28206 .03781 L
.28302 .04003 L
.28394 .04226 L
.28492 .04473 L
.28587 .0472 L
.28678 .04966 L
.28775 .05238 L
.28868 .05508 L
.28967 .05804 L
.29062 .06099 L
.29154 .06391 L
.29252 .06711 L
.29346 .07027 L
.29446 .07372 L
.29542 .07713 L
.29635 .0805 L
.29734 .08416 L
.29828 .08776 L
.2992 .09131 L
.30017 .09516 L
.3011 .09894 L
Mistroke
.3021 .10303 L
.30306 .10705 L
.30398 .11099 L
.30496 .11525 L
.3059 .11943 L
.30681 .1235 L
.30778 .1279 L
.30871 .1322 L
.3097 .13684 L
.31065 .14137 L
.31156 .14579 L
.31254 .15054 L
.31348 .15518 L
.31448 .16016 L
.31544 .16502 L
.31636 .16974 L
.31735 .17481 L
.31829 .17975 L
.3192 .18453 L
.32017 .18967 L
.32111 .19466 L
.3221 .20001 L
.32306 .2052 L
.32397 .21023 L
.32495 .21562 L
.32589 .22084 L
.3269 .22642 L
.32786 .23182 L
.32879 .23705 L
.32978 .24264 L
.33073 .24805 L
.33164 .25326 L
.33261 .25884 L
.33355 .26422 L
.33455 .26996 L
.3355 .27551 L
.33643 .28085 L
.33741 .28655 L
.33835 .29204 L
.33926 .29733 L
.34023 .30297 L
.34116 .30839 L
.34215 .31416 L
.34311 .31971 L
.34402 .32505 L
.345 .33073 L
.34594 .33618 L
.34694 .34197 L
.3479 .34753 L
.34883 .35287 L
Mistroke
.34981 .35854 L
.35076 .36398 L
.35167 .36919 L
.35264 .37471 L
.35358 .38001 L
.35457 .38561 L
.35553 .39098 L
.35645 .39611 L
.35743 .40155 L
.35837 .40675 L
.35928 .41171 L
.36025 .41697 L
.36117 .42198 L
.36216 .42728 L
.36311 .43233 L
.36403 .43715 L
.365 .44224 L
.36594 .44709 L
.36694 .45219 L
.3679 .45705 L
.36882 .46168 L
.36981 .46654 L
.37075 .47117 L
.37166 .47557 L
.37263 .48019 L
.37356 .48458 L
.37456 .48918 L
.37551 .49355 L
.37643 .49769 L
.37741 .50202 L
.37835 .50613 L
.37935 .51041 L
.38031 .51447 L
.38124 .5183 L
.38223 .5223 L
.38318 .52607 L
.38409 .52963 L
.38506 .53334 L
.386 .53683 L
.38699 .54045 L
.38795 .54386 L
.38887 .54706 L
.38985 .55037 L
.3908 .55348 L
.39171 .55638 L
.39267 .55939 L
.3936 .5622 L
.39459 .56508 L
.39555 .56778 L
.39646 .57028 L
Mistroke
.39744 .57284 L
.39838 .57522 L
.39938 .57765 L
.40034 .57989 L
.40126 .58195 L
.40225 .58404 L
.40319 .58596 L
.40411 .58771 L
.40508 .58948 L
.40601 .59108 L
.407 .59267 L
.40796 .59411 L
.40888 .59539 L
.40986 .59665 L
.4108 .59776 L
.41171 .59874 L
.41267 .59967 L
.4136 .60047 L
.41459 .60121 L
.41554 .60182 L
.41645 .60231 L
.41743 .60273 L
.41836 .60302 L
.41888 .60314 L
.41911 .60319 L
.41936 .60323 L
.41959 .60326 L
.41984 .60328 L
.41995 .60329 L
.42007 .6033 L
.42017 .60331 L
.42028 .60331 L
.42035 .60331 L
.42041 .60332 L
.42044 .60332 L
.42047 .60332 L
.4205 .60332 L
.42053 .60332 L
.42056 .60332 L
.42057 .60332 L
.42059 .60332 L
.42061 .60332 L
.42063 .60332 L
.42065 .60332 L
.42066 .60332 L
.42068 .60332 L
.4207 .60332 L
.42071 .60332 L
.42073 .60332 L
.42076 .60332 L
Mistroke
.42079 .60332 L
.42085 .60332 L
.42091 .60331 L
.42104 .60331 L
.42116 .6033 L
.42127 .6033 L
.42153 .60327 L
.42177 .60325 L
.42221 .60318 L
.42269 .60307 L
.42314 .60296 L
.42408 .60263 L
.42499 .60222 L
.42596 .60168 L
.4269 .60106 L
.42789 .60029 L
.42884 .59944 L
.42976 .59853 L
.43074 .59745 L
.43168 .59631 L
.43268 .59499 L
.43365 .59361 L
.43458 .59219 L
.43556 .59057 L
.43651 .58891 L
.43743 .58721 L
.4384 .58531 L
.43934 .58339 L
.44033 .58124 L
.44129 .57907 L
.44221 .57689 L
.44319 .57447 L
.44414 .57205 L
.44505 .56963 L
.44601 .56696 L
.44695 .56431 L
.44794 .56139 L
.44889 .55849 L
.44981 .55561 L
.45078 .55247 L
.45172 .54935 L
.45272 .54594 L
.45368 .54258 L
.45461 .53926 L
.45559 .53564 L
.45654 .53208 L
.45745 .52858 L
.45842 .52477 L
.45936 .52103 L
.46035 .51698 L
Mistroke
.46131 .513 L
.46223 .5091 L
.46321 .50488 L
.46415 .50075 L
.46506 .49671 L
.46602 .49234 L
.46695 .48808 L
.46794 .48348 L
.46889 .47899 L
.46981 .47461 L
.47078 .46989 L
.47172 .46528 L
.47271 .46034 L
.47367 .45551 L
.4746 .45082 L
.47558 .44578 L
.47653 .44088 L
.47744 .43612 L
.47841 .431 L
.47934 .42604 L
.48033 .42072 L
.48128 .41556 L
.4822 .41055 L
.48318 .40519 L
.48412 .39999 L
.48512 .39444 L
.48608 .38905 L
.48701 .38384 L
.488 .37828 L
.48895 .37289 L
.48986 .36769 L
.49083 .36213 L
.49177 .35676 L
.49276 .35103 L
.49372 .3455 L
.49464 .34017 L
.49562 .33449 L
.49657 .329 L
.49747 .32372 L
.49844 .3181 L
.49937 .31268 L
.50036 .30692 L
.50131 .30137 L
.50223 .29604 L
.5032 .29036 L
.50414 .28491 L
.50514 .27912 L
.5061 .27356 L
.50703 .26821 L
.50801 .26255 L
Mistroke
.50896 .25711 L
.50987 .25189 L
.51084 .24636 L
.51177 .24106 L
.51277 .23545 L
.51372 .23007 L
.51464 .22492 L
.51562 .21947 L
.51656 .21426 L
.51747 .20928 L
.51843 .20402 L
.51936 .19898 L
.52035 .19367 L
.5213 .1886 L
.52221 .18376 L
.52319 .17865 L
.52412 .17378 L
.52512 .16866 L
.52608 .16377 L
.527 .15912 L
.52798 .15423 L
.52893 .14957 L
.52984 .14514 L
.53081 .14049 L
.53174 .13607 L
.53273 .13144 L
.53368 .12704 L
.5346 .12287 L
.53558 .1185 L
.53652 .11436 L
.53751 .11003 L
.53848 .10594 L
.5394 .10207 L
.54039 .09803 L
.54134 .09421 L
.54225 .09061 L
.54322 .08686 L
.54416 .08333 L
.54515 .07966 L
.54611 .0762 L
.54703 .07296 L
.54801 .0696 L
.54895 .06644 L
.54986 .06349 L
.55082 .06043 L
.55175 .05758 L
.55274 .05464 L
.55369 .05189 L
.55461 .04934 L
.55558 .04672 L
Mistroke
.55652 .04428 L
.55752 .0418 L
.55848 .0395 L
.5594 .03739 L
.56039 .03523 L
.56133 .03326 L
.56224 .03145 L
.56321 .02963 L
.56415 .02797 L
.56514 .02631 L
.56609 .02481 L
.56701 .02347 L
.56799 .02214 L
.56893 .02097 L
.56993 .01983 L
.5709 .01884 L
.57182 .01799 L
.57281 .01719 L
.57376 .01652 L
.57467 .01598 L
.57565 .01551 L
.57658 .01516 L
.57709 .01501 L
.57758 .0149 L
.57781 .01485 L
.57806 .01481 L
.57829 .01478 L
.5785 .01476 L
.57872 .01474 L
.57884 .01473 L
.57897 .01472 L
.57902 .01472 L
.57908 .01472 L
.57912 .01472 L
.57918 .01472 L
.57921 .01472 L
.57924 .01472 L
.57927 .01472 L
.5793 .01472 L
.57932 .01472 L
.57935 .01472 L
.57938 .01472 L
.57941 .01472 L
.57944 .01472 L
.57945 .01472 L
.57947 .01472 L
.5795 .01472 L
.57953 .01472 L
.57959 .01472 L
.57965 .01472 L
Mistroke
.57978 .01473 L
.57992 .01473 L
.58015 .01475 L
.5804 .01478 L
.58087 .01485 L
.58137 .01495 L
.58189 .01508 L
.58237 .01524 L
.58329 .0156 L
.58428 .0161 L
.58522 .01669 L
.58613 .01735 L
.5871 .01816 L
.58803 .01903 L
.58902 .02007 L
.58998 .02118 L
.59089 .02234 L
.59187 .02369 L
.59281 .02508 L
.59381 .02666 L
.59477 .0283 L
.5957 .02997 L
.59669 .03184 L
.59764 .03375 L
.59855 .03568 L
.59952 .03782 L
.60046 .03999 L
.60145 .04239 L
.60241 .0448 L
.60333 .0472 L
.60431 .04986 L
.60525 .05251 L
.60616 .05514 L
.60713 .05804 L
.60806 .06091 L
.60905 .06405 L
.61 .06717 L
.61091 .07025 L
.61189 .07362 L
.61283 .07694 L
.61383 .08056 L
.61479 .08413 L
.61571 .08764 L
.6167 .09145 L
.61764 .09521 L
.61855 .09889 L
.61952 .10288 L
.62046 .1068 L
.62145 .11103 L
.6224 .11519 L
Mistroke
.62332 .11925 L
.6243 .12364 L
.62524 .12793 L
.62624 .13256 L
.62721 .13709 L
.62814 .14151 L
.62912 .14626 L
.63007 .15091 L
.63099 .15542 L
.63196 .16028 L
.6329 .16502 L
.63389 .1701 L
.63485 .17505 L
.63577 .17986 L
.63676 .18502 L
.6377 .19003 L
.63861 .19489 L
.63958 .20011 L
.64051 .20517 L
.6415 .21058 L
.64245 .21584 L
.64337 .22092 L
.64435 .22636 L
.64529 .23163 L
.64628 .23726 L
.64725 .24271 L
.64817 .24797 L
.64916 .25359 L
.65011 .25903 L
.65102 .26427 L
.65199 .26987 L
.65292 .27527 L
.65392 .28103 L
.65487 .28658 L
.65579 .29193 L
.65677 .29763 L
.65772 .30312 L
.65862 .3084 L
.65959 .31402 L
.66052 .31943 L
.66151 .32518 L
.66246 .33072 L
.66337 .33603 L
.66435 .34167 L
.66529 .3471 L
.66628 .35285 L
.66724 .35837 L
.66817 .36367 L
.66915 .36928 L
.6701 .37467 L
Mistroke
.67101 .37982 L
.67198 .38529 L
.67291 .39052 L
.6739 .39605 L
.67485 .40135 L
.67577 .40641 L
.67675 .41177 L
.67769 .41689 L
.67869 .42229 L
.67965 .42745 L
.68058 .43237 L
.68157 .43756 L
.68252 .44251 L
.68343 .44723 L
.6844 .45221 L
.68534 .45694 L
.68633 .46192 L
.68729 .46666 L
.68821 .47117 L
.68919 .47591 L
.69014 .48041 L
.69105 .48468 L
.69201 .48917 L
.69294 .49342 L
.69393 .49788 L
.69489 .5021 L
.6958 .5061 L
.69678 .51028 L
.69772 .51424 L
.69872 .51836 L
.69968 .52226 L
.7006 .52594 L
.70159 .52977 L
.70253 .53338 L
.70345 .53678 L
.70442 .54032 L
.70535 .54364 L
.70634 .54709 L
.7073 .55032 L
.70822 .55335 L
.7092 .55648 L
.71014 .55941 L
.71104 .56214 L
.71201 .56496 L
.71294 .56759 L
.71393 .57028 L
.71488 .57279 L
.71579 .57511 L
.71676 .57748 L
.7177 .57967 L
Mistroke
.7187 .58189 L
.71966 .58394 L
.72058 .58581 L
.72156 .5877 L
.72251 .58942 L
.72342 .59099 L
.72438 .59255 L
.72532 .59396 L
.72631 .59535 L
.72726 .59658 L
.72818 .59767 L
.72916 .59872 L
.7301 .59964 L
.7311 .6005 L
.73206 .60122 L
.73298 .60181 L
.73397 .60234 L
.73492 .60274 L
.73583 .60302 L
.7363 .60313 L
.7368 .60322 L
.73705 .60326 L
.73731 .60328 L
.73744 .60329 L
.73756 .6033 L
.73767 .60331 L
.73773 .60331 L
.7378 .60331 L
.73785 .60332 L
.73791 .60332 L
.73795 .60332 L
.73798 .60332 L
.73801 .60332 L
.73804 .60332 L
.73807 .60332 L
.73809 .60332 L
.73812 .60332 L
.73815 .60332 L
.73817 .60332 L
.73821 .60332 L
.73824 .60332 L
.73826 .60332 L
.73833 .60332 L
.73838 .60331 L
.73852 .60331 L
.73864 .6033 L
.73876 .60329 L
.73901 .60327 L
.73928 .60324 L
.73976 .60316 L
Mistroke
.74024 .60305 L
.74075 .60291 L
.74166 .60259 L
.74264 .60213 L
.74357 .60159 L
.74457 .60091 L
.74553 .60014 L
.74645 .59931 L
.74743 .59831 L
.74837 .59725 L
.74928 .59613 L
.75025 .59484 L
.75118 .5935 L
.75217 .59197 L
.75312 .59039 L
.75404 .58878 L
.75502 .58697 L
.75596 .58512 L
.75696 .58305 L
.75792 .58096 L
.75884 .57885 L
.75983 .57651 L
.76078 .57416 L
.76169 .57181 L
.76266 .56922 L
.76359 .56663 L
.76459 .56379 L
.76554 .56095 L
.76646 .55814 L
.76744 .55505 L
.76838 .552 L
.76929 .54898 L
.77026 .54568 L
.77119 .54243 L
.77217 .53888 L
.77312 .53538 L
.77404 .53193 L
.77501 .52819 L
.77595 .52451 L
.77695 .52051 L
.77791 .51658 L
.77883 .51274 L
.77981 .50857 L
.78076 .50448 L
.78167 .50049 L
.78264 .49617 L
.78357 .49195 L
.78456 .48739 L
.78552 .48294 L
.78643 .47859 L
Mistroke
.78741 .47391 L
.78835 .46934 L
.78935 .46443 L
.79032 .45963 L
.79124 .45497 L
.79223 .44996 L
.79318 .44508 L
.79409 .44034 L
.79506 .43525 L
.796 .43031 L
.79699 .42501 L
.79795 .41986 L
.79887 .41487 L
.79985 .40952 L
.8008 .40433 L
.8017 .39932 L
.80267 .39394 L
.8036 .38874 L
.80459 .38318 L
.80554 .3778 L
.80646 .3726 L
.80743 .36704 L
.80837 .36167 L
.80937 .35594 L
.81033 .3504 L
.81126 .34506 L
.81224 .33937 L
.81319 .33388 L
.8141 .32859 L
.81507 .32295 L
.816 .31751 L
.81699 .31173 L
.81795 .30617 L
.81887 .30081 L
.81985 .29511 L
.82079 .28964 L
.82179 .28382 L
.82276 .27823 L
.82368 .27286 L
.82467 .26716 L
.82562 .26169 L
.82654 .25644 L
.82751 .25087 L
.82845 .24553 L
.82944 .23988 L
.8304 .23447 L
.83132 .22928 L
.8323 .22379 L
.83325 .21853 L
.83416 .21351 L
Mistroke
.83513 .2082 L
.83606 .20312 L
.83705 .19776 L
.838 .19263 L
.83892 .18774 L
.8399 .18258 L
.84084 .17766 L
.84184 .17248 L
.8428 .16754 L
.84372 .16283 L
.84471 .15788 L
.84566 .15317 L
.84657 .14868 L
.84754 .14397 L
.84848 .13949 L
.84947 .13479 L
.85043 .13033 L
.85135 .1261 L
.85233 .12166 L
.85327 .11746 L
.85418 .11348 L
.85514 .10931 L
.85607 .10537 L
.85706 .10125 L
.85801 .09736 L
.85893 .09369 L
.8599 .08986 L
.86084 .08626 L
.86184 .0825 L
.8628 .07897 L
.86372 .07566 L
.8647 .07221 L
.86565 .06898 L
.86656 .06595 L
.86753 .06281 L
.86846 .05988 L
.86945 .05685 L
.87041 .05403 L
.87133 .0514 L
.87231 .04869 L
.87325 .04618 L
.87425 .04361 L
.87521 .04123 L
.87614 .03904 L
.87713 .0368 L
.87808 .03475 L
.87899 .03286 L
.87996 .03096 L
.8809 .02922 L
.88189 .02748 L
Mistroke
.88285 .0259 L
.88377 .02448 L
.88475 .02308 L
.8857 .02182 L
.88661 .02071 L
.88757 .01964 L
.8885 .0187 L
.88949 .01781 L
.89045 .01706 L
.89136 .01643 L
.89234 .01587 L
.89328 .01544 L
.89376 .01526 L
.89428 .01509 L
.89473 .01497 L
.89524 .01486 L
.89572 .01479 L
.89598 .01476 L
.89622 .01474 L
.89634 .01473 L
.89641 .01473 L
.89647 .01472 L
.89653 .01472 L
.8966 .01472 L
.89666 .01472 L
.89668 .01472 L
.89671 .01472 L
.89674 .01472 L
.89676 .01472 L
.89679 .01472 L
.89682 .01472 L
.89685 .01472 L
.89688 .01472 L
.8969 .01472 L
.89692 .01472 L
.89695 .01472 L
.89698 .01472 L
.89704 .01472 L
.8971 .01472 L
.89716 .01472 L
.89728 .01473 L
.89741 .01473 L
.89764 .01475 L
.89787 .01478 L
.89809 .01481 L
.89858 .01489 L
.89903 .01499 L
.89999 .01529 L
.90092 .01568 L
.9019 .0162 L
Mistroke
.90285 .01681 L
.90377 .01749 L
.90474 .01832 L
.90567 .01921 L
.90667 .02028 L
.90762 .02141 L
.90854 .0226 L
.90953 .02396 L
.91047 .02538 L
.91138 .02684 L
.91234 .02849 L
.91327 .03017 L
.91426 .03207 L
.91521 .03399 L
.91613 .03594 L
.9171 .0381 L
.91804 .04029 L
.91904 .04271 L
.92 .04514 L
.92093 .04757 L
.92191 .05024 L
.92286 .05292 L
.92377 .05557 L
.92474 .05849 L
.92567 .06138 L
.92666 .06455 L
.92762 .0677 L
.92854 .0708 L
.92951 .07419 L
.93046 .07754 L
.93146 .08118 L
.93242 .08478 L
.93335 .08832 L
.93434 .09216 L
.93529 .09594 L
.9362 .09965 L
.93717 .10367 L
.93811 .10761 L
.9391 .11188 L
.94006 .11606 L
.94099 .12015 L
.94197 .12457 L
.94291 .12889 L
.94382 .13311 L
.94479 .13766 L
.94572 .1421 L
.94671 .14688 L
.94766 .15154 L
.94858 .15608 L
.94956 .16097 L
Mistroke
.9505 .16572 L
.9515 .17083 L
.95246 .1758 L
.95338 .18064 L
.95437 .18582 L
.95532 .19086 L
.95623 .19574 L
.9572 .20098 L
.95813 .20606 L
.95913 .2115 L
.96008 .21678 L
.961 .22189 L
.96198 .22735 L
.96293 .23264 L
.96383 .23775 L
.9648 .24322 L
.96573 .24851 L
.96672 .25415 L
.96767 .25961 L
.96858 .26487 L
.96956 .27049 L
.97049 .27591 L
.97149 .28168 L
.97245 .28726 L
.97337 .29263 L
.97436 .29834 L
.9753 .30385 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool001<0oooo100000040?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0l0?ooo`800000D`3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo01X0oooo000E0?ooo`030000003oool0oooo00<0oooo0P00000k
0?ooo`D00000D03oool400000500oooo1@00000J0?ooo`003@3oool4000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0i0?ooo`8000000`3oool2000004h0oooo0P0000030?oo
o`030000003oool0oooo04`0oooo0P0000030?ooo`8000006@3oool001D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0B`3oool2000000D0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01L0oooo000C0?ooo`<000001@3oool00`000000oooo0?ooo`0h0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`040?ooo`800000
B`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo000E0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo04P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo00D0oooo0P00000G0?ooo`006`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`060?ooo`800000B@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
01D0oooo000K0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`160?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0AP3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo000K0?ooo`800000=`3oool00`000000oooo
0?ooo`090?ooo`800000AP3oool2000000/0oooo00<000000?ooo`3oool0A@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo01@0oooo000K0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo000K
0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo00X0oooo0P0000150?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool04`3oool001/0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`130?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool001/0oooo00<000000?ooo`3o
ool0=@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool04P3oool001/0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`110?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool001/0oooo00<000000?ooo`3oool0=03o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0440oooo0P00000?0?ooo`030000003o
ool0oooo0440oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`006`3oool2
000003D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`100?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0180oooo000K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`100?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0?`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0140
oooo000K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0?`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo000K0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0?P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo000K
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0n
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0100oooo000K0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0?@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo000K0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00l0oooo000K0?ooo`800000<`3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo03`0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0l0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool001/0oooo00<000000?ooo`3oool0<@3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3o
ool001/0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo03/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0k0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool03`3oool001/0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0k0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool001/0
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool0<03oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool03P3oool001/0oooo00<0
00000?ooo`3oool0<03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0i
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool03P3oool001/0oooo0P00000a0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0=0?oo
o`006`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo03L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`006`3o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo03L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`00
0000oooo0?ooo`0_0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0<0?ooo`00203oool2000000@0oooo00<000000?ooo`3oool00P3oool3000000D0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0303oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00070?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool00P3oool2000002l0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00000`3oool000000000000200000080oooo
00@000000?ooo`3oool00000203oool3000000D0oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0303oool000L0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0
oooo00070?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0;0?ooo`00203oool2000000T0oooo100000040?ooo`030000003oool0oooo02d0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00/0oooo
000K0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo00/0oooo000K0?ooo`030000003oool0oooo02d0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0<`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00/0oooo000K0?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0b0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo00/0oooo000K0?ooo`800000;@3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0b0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0
2P3oool001/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo0380oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0;03oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02P3oool0
01/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool0;03oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02@3oool001/0oooo
00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0300oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01l0oooo
00<000000?ooo`3oool02@3oool001/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`0`0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool001/0oooo0P00000/
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`09
0?ooo`006`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0;`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?ooo`0[0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`090?ooo`00
6`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`080?ooo`006`3oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo0240oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`006`3oool0
0`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`080?ooo`006`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`006`3oool2000002/0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0
oooo000K0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool08P3oool00`000000oooo
0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;@3oool00`000000oooo
0?ooo`0R0?ooo`030000003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo02T0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0;03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00L0oooo000K
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0/
0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo02T0oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00L0oooo000K0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0[0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo02P0oooo0P0000040?ooo`030000
003oool0oooo0080oooo1000000H0?ooo`030000003oool0oooo00T0oooo0P0000040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0>0?ooo`800000
103oool00`000000oooo0?ooo`030?ooo`800000203oool00`000000oooo0?ooo`0I0?ooo`800000
103oool00`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`0S0?ooo`@00000
1P3oool001/0oooo00<000000?ooo`3oool09`3oool010000000oooo0000000000080?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool03@3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000L0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0903oool2000000L0oooo
000K0?ooo`800000:03oool2000000030?ooo`000000oooo00P0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000L0oooo1@00000C0?ooo`030000
003oool0oooo00d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000070?oo
o`030000003oool0oooo01P0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo02D0oooo0P0000070?ooo`006`3oool00`000000oooo0?ooo`0W
0?ooo`80000000<0oooo0000003oool02@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool000001`3oool010000000oooo0?ooo`00000D0?ooo`030000
003oool0oooo00d0oooo00@000000?ooo`3oool00000203oool3000000P0oooo00<000000?ooo`3o
ool0603oool010000000oooo0?ooo`0000090?ooo`8000000`3oool00`000000oooo0?ooo`0U0?oo
o`8000001`3oool001/0oooo00<000000?ooo`3oool09`3oool2000000030?ooo`000000oooo00X0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`000000503oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo
000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0U0?ooo`800000
1`3oool001/0oooo00<000000?ooo`3oool09`3oool2000000030?ooo`000000oooo00L0oooo00@0
00000?ooo`3oool000006@3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000T0
oooo0P00000C0?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo01L0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo02@0oooo0`0000070?ooo`006`3oool0
0`000000oooo0?ooo`0X0?ooo`8000002P3oool2000001X0oooo00<000000?ooo`3oool0203oool2
000000/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`8000002P3oool3
000000P0oooo00<000000?ooo`3oool0603oool2000000X0oooo0P0000030?ooo`030000003oool0
oooo02D0oooo0P0000070?ooo`006`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000
oooo0?ooo`0W0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool09`3oool00`000000
oooo0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02L0oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02P0oooo
00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`050?ooo`00503ooooo000000d00000000K
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00000<0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo00D0oooo000K0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool0:03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0_0?ooo`006`3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0X
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0<03oool001/0oooo0P00000W0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0<03oool001/0oooo0P00000W0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0<03oool001/0oooo0P00000W0?ooo`030000
003oool0oooo02X0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0Z0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0<03oool001/0oooo0P00000W0?ooo`030000003o
ool0oooo02X0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool0<03oool001/0oooo0P00000W0?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool0<03oool001/0oooo00<000000?ooo`0000009@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0:P3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo0340oooo000K0?ooo`030000003oool0000002D0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0a0?ooo`006`3oool00`000000oooo
0000000U0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0<@3oool001/0oooo00<0
00000?ooo`0000009@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0;03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0340oooo000K
0?ooo`030000003oool0000002D0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0a
0?ooo`006`3oool00`000000oooo0000000U0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool0<P3oool001/0oooo0P0000000`3oool000000?ooo`0R0?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool0<P3oool001/0oooo00@000000?ooo`3oool000008`3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo0380oooo000K0?ooo`040000003oool0oooo000002<0
oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0b0?ooo`006`3oool010000000oooo
0?ooo`00000S0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0^0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0<P3oool001/0oooo
00@000000?ooo`3oool000008`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0380
oooo000K0?ooo`040000003oool0oooo00000280oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0c0?ooo`006`3oool01@000000oooo0?ooo`3oool000000240oooo00<000000?ooo`3o
ool0;`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0c0?ooo`006`3oool01@000000oooo0?ooo`3oool000000240
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0c0?ooo`006`3oool200000080oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01l0oooo
00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03<0oooo
000K0?ooo`050000003oool0oooo0?ooo`0000008@3oool00`000000oooo0?ooo`0`0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo03<0oooo000K0?ooo`050000003oool0oooo0?ooo`0000008@3oool00`000000oooo
0?ooo`0`0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0<03oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo03<0oooo000K0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool0<@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03@0oooo000K
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo03@0oooo000K0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03@0oooo000K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0b0?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo03@0oooo000K0?ooo`8000000`3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo0380oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0=@3oool001/0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0=@3o
ool001/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo03<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0c0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0=@3oool001/0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0d0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=@3oool001/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo03@0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0=@3oool001/0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0d0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=P3oool000P0oooo0P00
00040?ooo`030000003oool0oooo0080oooo0`0000050?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03H0oooo0007
0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0f0?ooo`001`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo0P00
00050?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0f0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0f0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0=`3oool000L0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo03L0oooo00080?ooo`8000002@3oool4000000@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03L0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0=`3oool001/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=`3oool001/0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0=`3oool001/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0h0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0>03oool001/0oooo0P0000060?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo03P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0h0?ooo`006`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0>@3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0h0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0h0?ooo`006`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0h0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0i0?ooo`006`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0i0?ooo`006`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0>`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0i0?ooo`006`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo03`0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0i0?oo
o`006`3oool2000000P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo03X0oooo000K0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03X0oooo000K0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0m0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo03X0oooo000K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0?P3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo000K0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
03/0oooo000K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0o0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0?P3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo03/0oooo000K0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03/0oooo
000K0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0o0?ooo`800000403oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool0>`3oool001/0oooo0P00000:0?ooo`8000003`3oool00`000000oooo0?ooo`11
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo03`0oooo000K0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0@@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03`0oooo000K0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`110?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo03`0oooo000K0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
303oool2000004@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`120?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0?@3oool001/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`120?ooo`8000003@3oool00`000000oooo0?ooo`0m0?ooo`006`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0m0?ooo`006`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo0P0000160?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`0:0?ooo`800000?`3oool001/0oooo0P00000=0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04@0
oooo0P00000;0?ooo`030000003oool0oooo03h0oooo000K0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`150?ooo`8000002P3oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0?P3oool001/0oooo00<0
00000?ooo`3oool0303oool2000000T0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0o0?ooo`006`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0o0?ooo`006`3oool00`000000oooo0?ooo`0=0?oo
o`8000001`3oool2000004X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`180?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0@03oool001/0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04T0oooo0P0000060?ooo`03
0000003oool0oooo04X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`100?ooo`00
4`3oool4000000@0oooo00<000000?ooo`3oool03P3oool2000000D0oooo00<000000?ooo`3oool0
B`3oool00`000000oooo0?ooo`030?ooo`800000C03oool2000000D0oooo00<000000?ooo`3oool0
@@3oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`8000000`3o
ool2000004h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1<0?ooo`8000000`3o
ool2000004<0oooo000E0?ooo`030000003oool0oooo00<0oooo0P00000A0?ooo`D00000D03oool4
00000500oooo1@0000140?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0?l0oooo0`3oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`<0
oooo000C0?ooo`<000001@3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000E0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0o`3oool30?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -1.13006, \
0.00394728, 0.0127737}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Sin[\ 2\ \[Pi]\ 440\ t], {t, 0, 2/440}, 
        PlotPoints -> 1000];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 209.524 0.309017 0.294302 [
[.23333 .29652 -15 -9 ]
[.23333 .29652 15 0 ]
[.44286 .29652 -15 -9 ]
[.44286 .29652 15 0 ]
[.65238 .29652 -15 -9 ]
[.65238 .29652 15 0 ]
[.8619 .29652 -15 -9 ]
[.8619 .29652 15 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23333 .30902 m
.23333 .31527 L
s
[(0.001)] .23333 .29652 0 1 Mshowa
.44286 .30902 m
.44286 .31527 L
s
[(0.002)] .44286 .29652 0 1 Mshowa
.65238 .30902 m
.65238 .31527 L
s
[(0.003)] .65238 .29652 0 1 Mshowa
.8619 .30902 m
.8619 .31527 L
s
[(0.004)] .8619 .29652 0 1 Mshowa
.125 Mabswid
.06571 .30902 m
.06571 .31277 L
s
.10762 .30902 m
.10762 .31277 L
s
.14952 .30902 m
.14952 .31277 L
s
.19143 .30902 m
.19143 .31277 L
s
.27524 .30902 m
.27524 .31277 L
s
.31714 .30902 m
.31714 .31277 L
s
.35905 .30902 m
.35905 .31277 L
s
.40095 .30902 m
.40095 .31277 L
s
.48476 .30902 m
.48476 .31277 L
s
.52667 .30902 m
.52667 .31277 L
s
.56857 .30902 m
.56857 .31277 L
s
.61048 .30902 m
.61048 .31277 L
s
.69429 .30902 m
.69429 .31277 L
s
.73619 .30902 m
.73619 .31277 L
s
.7781 .30902 m
.7781 .31277 L
s
.82 .30902 m
.82 .31277 L
s
.90381 .30902 m
.90381 .31277 L
s
.94571 .30902 m
.94571 .31277 L
s
.98762 .30902 m
.98762 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02474 .31262 L
.02575 .31655 L
.0267 .32024 L
.02761 .32379 L
.02859 .32756 L
.02952 .33119 L
.03052 .33504 L
.03148 .33875 L
.0324 .34231 L
.03338 .3461 L
.03433 .34974 L
.03524 .35323 L
.03621 .35694 L
.03714 .36051 L
.03813 .36429 L
.03908 .36792 L
.04 .37141 L
.04098 .37511 L
.04192 .37866 L
.04292 .38243 L
.04388 .38604 L
.0448 .38951 L
.04579 .39318 L
.04674 .3967 L
.04765 .40008 L
.04862 .40365 L
.04956 .40708 L
.05055 .41071 L
.05151 .41419 L
.05243 .41753 L
.05341 .42105 L
.05435 .42443 L
.05526 .42766 L
.05622 .43109 L
.05715 .43436 L
.05814 .43782 L
.05909 .44114 L
.06001 .4443 L
.06098 .44765 L
.06192 .45085 L
.06292 .45423 L
.06388 .45747 L
.0648 .46055 L
.06579 .46381 L
.06673 .46693 L
.06764 .4699 L
.06861 .47304 L
.06954 .47603 L
.07054 .47919 L
Mistroke
.07149 .4822 L
.07241 .48507 L
.07339 .4881 L
.07433 .49099 L
.07533 .49402 L
.07629 .49692 L
.07722 .49968 L
.07821 .50258 L
.07916 .50534 L
.08007 .50797 L
.08104 .51074 L
.08198 .51337 L
.08297 .51613 L
.08393 .51876 L
.08485 .52125 L
.08584 .52388 L
.08678 .52637 L
.08769 .52873 L
.08866 .53121 L
.08959 .53356 L
.09058 .53603 L
.09153 .53836 L
.09245 .54058 L
.09342 .5429 L
.09436 .54509 L
.09536 .54739 L
.09632 .54956 L
.09725 .55161 L
.09823 .55375 L
.09918 .55578 L
.10009 .55769 L
.10106 .55968 L
.10199 .56157 L
.10299 .56352 L
.10394 .56537 L
.10486 .5671 L
.10584 .56891 L
.10678 .57061 L
.10769 .5722 L
.10866 .57386 L
.10958 .57541 L
.11057 .57702 L
.11152 .57852 L
.11244 .57993 L
.11341 .58138 L
.11435 .58274 L
.11535 .58414 L
.1163 .58544 L
.11723 .58665 L
.11821 .58789 L
Mistroke
.11916 .58904 L
.12007 .59011 L
.12103 .5912 L
.12197 .59221 L
.12296 .59323 L
.12391 .59417 L
.12483 .59503 L
.12581 .5959 L
.12675 .59669 L
.12775 .59749 L
.12871 .59821 L
.12964 .59885 L
.13062 .59949 L
.13157 .60006 L
.13248 .60057 L
.13345 .60106 L
.13439 .60148 L
.13538 .60189 L
.13634 .60223 L
.13726 .60252 L
.13824 .60277 L
.13919 .60297 L
.14009 .60312 L
.1406 .60319 L
.14106 .60324 L
.14151 .60327 L
.14174 .60329 L
.14199 .6033 L
.14212 .6033 L
.14224 .60331 L
.14235 .60331 L
.14246 .60331 L
.14252 .60332 L
.14259 .60332 L
.14265 .60332 L
.1427 .60332 L
.14274 .60332 L
.14277 .60332 L
.1428 .60332 L
.14283 .60332 L
.14285 .60332 L
.14286 .60332 L
.14288 .60332 L
.1429 .60332 L
.14293 .60332 L
.14295 .60332 L
.14297 .60332 L
.14303 .60332 L
.14308 .60332 L
.14314 .60332 L
Mistroke
.1432 .60332 L
.14331 .60331 L
.14342 .60331 L
.14368 .6033 L
.14392 .60329 L
.14437 .60326 L
.14486 .60322 L
.14583 .60309 L
.14676 .60293 L
.14775 .60271 L
.1487 .60244 L
.14962 .60215 L
.1506 .60179 L
.15154 .60139 L
.15254 .60092 L
.1535 .60042 L
.15442 .5999 L
.15541 .59929 L
.15636 .59866 L
.15727 .59801 L
.15824 .59728 L
.15917 .59652 L
.16017 .59568 L
.16112 .59481 L
.16204 .59394 L
.16302 .59296 L
.16397 .59198 L
.16487 .59099 L
.16584 .58989 L
.16677 .58879 L
.16776 .58758 L
.16871 .58636 L
.16962 .58515 L
.1706 .58382 L
.17154 .5825 L
.17253 .58105 L
.17349 .5796 L
.17442 .57817 L
.1754 .5766 L
.17635 .57505 L
.17726 .57352 L
.17822 .57185 L
.17916 .5702 L
.18015 .56841 L
.1811 .56663 L
.18202 .56489 L
.183 .56299 L
.18394 .56113 L
.18494 .5591 L
.1859 .55711 L
Mistroke
.18683 .55516 L
.18782 .55304 L
.18877 .55096 L
.18968 .54892 L
.19065 .54671 L
.19159 .54455 L
.19258 .54222 L
.19354 .53993 L
.19446 .53769 L
.19544 .53527 L
.19639 .53291 L
.19729 .53061 L
.19826 .52812 L
.19919 .52569 L
.20018 .52307 L
.20113 .52052 L
.20205 .51803 L
.20303 .51534 L
.20396 .51273 L
.20496 .50991 L
.20592 .50717 L
.20685 .5045 L
.20783 .50162 L
.20878 .49883 L
.20969 .49611 L
.21066 .49319 L
.2116 .49034 L
.21259 .48729 L
.21354 .48432 L
.21446 .48144 L
.21544 .47835 L
.21638 .47534 L
.21729 .47243 L
.21826 .4693 L
.21918 .46626 L
.22017 .46301 L
.22112 .45985 L
.22204 .45679 L
.22301 .45351 L
.22395 .45033 L
.22494 .44693 L
.2259 .44362 L
.22683 .44043 L
.22781 .437 L
.22875 .43369 L
.22966 .43048 L
.23063 .42705 L
.23156 .42372 L
.23255 .42017 L
.23351 .41673 L
Mistroke
.23442 .41341 L
.2354 .40985 L
.23634 .40642 L
.23734 .40275 L
.2383 .39919 L
.23923 .39576 L
.24021 .3921 L
.24116 .38856 L
.24208 .38514 L
.24305 .38149 L
.24398 .37797 L
.24498 .37421 L
.24593 .37058 L
.24685 .36708 L
.24783 .36334 L
.24878 .35974 L
.24968 .35627 L
.25065 .35256 L
.25158 .34899 L
.25257 .34518 L
.25352 .34151 L
.25444 .33797 L
.25541 .3342 L
.25635 .33057 L
.25735 .32671 L
.25831 .32298 L
.25923 .3194 L
.26021 .31558 L
.26116 .3119 L
.26207 .30837 L
.26304 .3046 L
.26397 .30098 L
.26497 .29713 L
.26592 .29343 L
.26684 .28986 L
.26782 .28608 L
.26876 .28243 L
.26976 .27857 L
.27072 .27485 L
.27165 .27127 L
.27264 .26748 L
.27359 .26383 L
.2745 .26032 L
.27547 .2566 L
.27641 .25303 L
.27741 .24924 L
.27836 .2456 L
.27929 .24211 L
.28027 .2384 L
.28121 .23485 L
Mistroke
.28212 .23144 L
.28309 .22782 L
.28402 .22435 L
.28501 .22068 L
.28596 .21716 L
.28688 .21378 L
.28786 .2102 L
.28879 .20677 L
.28979 .20315 L
.29076 .19967 L
.29168 .19634 L
.29267 .19282 L
.29361 .18945 L
.29452 .18622 L
.2955 .18281 L
.29643 .17954 L
.29742 .17609 L
.29838 .17278 L
.2993 .16963 L
.30028 .16629 L
.30122 .1631 L
.30213 .16005 L
.30309 .15683 L
.30402 .15376 L
.30501 .15051 L
.30596 .14741 L
.30688 .14445 L
.30785 .14133 L
.30879 .13835 L
.30978 .13522 L
.31074 .13222 L
.31167 .12937 L
.31265 .12636 L
.3136 .1235 L
.3145 .12077 L
.31547 .11789 L
.31641 .11515 L
.3174 .11227 L
.31835 .10953 L
.31927 .10693 L
.32025 .10418 L
.32119 .10158 L
.32219 .09884 L
.32315 .09624 L
.32408 .09377 L
.32506 .09118 L
.32601 .08872 L
.32692 .08638 L
.3279 .08393 L
.32883 .08161 L
Mistroke
.32983 .07918 L
.33078 .07687 L
.33171 .07469 L
.33269 .07241 L
.33363 .07025 L
.33454 .0682 L
.3355 .06606 L
.33643 .06404 L
.33742 .06194 L
.33838 .05995 L
.33929 .05807 L
.34027 .05611 L
.34121 .05427 L
.3422 .05235 L
.34316 .05054 L
.34409 .04885 L
.34507 .04708 L
.34602 .04543 L
.34693 .04387 L
.3479 .04226 L
.34883 .04075 L
.34983 .03919 L
.35078 .03773 L
.3517 .03636 L
.35268 .03496 L
.35362 .03364 L
.35462 .0323 L
.35559 .03104 L
.35652 .02988 L
.3575 .02869 L
.35845 .02759 L
.35937 .02657 L
.36034 .02553 L
.36128 .02458 L
.36227 .02361 L
.36323 .02272 L
.36415 .02191 L
.36514 .0211 L
.36608 .02036 L
.36699 .01969 L
.36796 .01903 L
.36889 .01843 L
.36988 .01785 L
.37083 .01733 L
.37175 .01688 L
.37273 .01645 L
.37367 .01607 L
.37467 .01573 L
.37563 .01544 L
.37655 .01521 L
Mistroke
.37754 .01501 L
.37803 .01493 L
.37849 .01487 L
.37896 .01482 L
.3794 .01478 L
.37963 .01476 L
.37989 .01474 L
.38012 .01473 L
.38034 .01472 L
.38044 .01472 L
.38056 .01472 L
.38062 .01472 L
.38069 .01472 L
.38075 .01472 L
.38081 .01472 L
.38084 .01472 L
.38086 .01472 L
.38088 .01472 L
.38091 .01472 L
.38094 .01472 L
.38097 .01472 L
.38099 .01472 L
.381 .01472 L
.38102 .01472 L
.38104 .01472 L
.38107 .01472 L
.3811 .01472 L
.38113 .01472 L
.3812 .01472 L
.38125 .01472 L
.38131 .01472 L
.38144 .01472 L
.38156 .01472 L
.38183 .01473 L
.38207 .01475 L
.38231 .01476 L
.38279 .0148 L
.38323 .01485 L
.38416 .01498 L
.38516 .01517 L
.38612 .0154 L
.38704 .01566 L
.38802 .01599 L
.38896 .01636 L
.38987 .01675 L
.39084 .01722 L
.39177 .01771 L
.39276 .01828 L
.39371 .01888 L
.39463 .01949 L
Mistroke
.39561 .0202 L
.39654 .02092 L
.39754 .02174 L
.3985 .02257 L
.39943 .02342 L
.40041 .02436 L
.40136 .02532 L
.40227 .02628 L
.40324 .02735 L
.40418 .02843 L
.40517 .02961 L
.40613 .0308 L
.40705 .03199 L
.40802 .03329 L
.40897 .03459 L
.40987 .03588 L
.41084 .0373 L
.41177 .03871 L
.41275 .04025 L
.41371 .04177 L
.41462 .04328 L
.41559 .04493 L
.41653 .04655 L
.41753 .04832 L
.41849 .05007 L
.41941 .0518 L
.42039 .05367 L
.42134 .05552 L
.42225 .05733 L
.42321 .0593 L
.42415 .06123 L
.42514 .06333 L
.42609 .06539 L
.42701 .06741 L
.42799 .06959 L
.42893 .07174 L
.42993 .07405 L
.43089 .07632 L
.43182 .07854 L
.4328 .08094 L
.43375 .08329 L
.43466 .08558 L
.43563 .08805 L
.43657 .09047 L
.43756 .09307 L
.43852 .09561 L
.43944 .09809 L
.44042 .10077 L
.44137 .10337 L
.44227 .10591 L
Mistroke
.44324 .10864 L
.44417 .1113 L
.44516 .11416 L
.44611 .11694 L
.44703 .11965 L
.448 .12257 L
.44894 .1254 L
.44994 .12844 L
.4509 .1314 L
.45182 .13428 L
.45281 .13737 L
.45375 .14037 L
.45466 .14328 L
.45563 .1464 L
.45657 .14943 L
.45756 .15268 L
.45851 .15584 L
.45943 .1589 L
.46041 .16218 L
.46135 .16536 L
.46235 .16876 L
.46332 .17207 L
.46424 .17526 L
.46523 .17869 L
.46618 .18201 L
.4671 .18522 L
.46807 .18865 L
.469 .19198 L
.47 .19554 L
.47096 .19898 L
.47188 .20231 L
.47286 .20587 L
.47381 .20932 L
.47472 .21264 L
.47568 .2162 L
.47661 .21964 L
.4776 .22331 L
.47856 .22686 L
.47948 .23028 L
.48045 .23394 L
.48139 .23748 L
.48239 .24124 L
.48335 .24489 L
.48428 .2484 L
.48526 .25215 L
.48621 .25576 L
.48712 .25925 L
.48809 .26297 L
.48903 .26656 L
.49002 .27038 L
Mistroke
.49098 .27406 L
.4919 .27761 L
.49288 .2814 L
.49382 .28504 L
.49473 .28855 L
.49569 .2923 L
.49662 .2959 L
.49761 .29973 L
.49856 .30343 L
.49948 .30698 L
.50045 .31076 L
.50139 .3144 L
.50238 .31827 L
.50334 .322 L
.50427 .32558 L
.50525 .32939 L
.5062 .33305 L
.50711 .33657 L
.50807 .34031 L
.50901 .34391 L
.51 .34773 L
.51095 .3514 L
.51187 .35493 L
.51285 .35867 L
.51379 .36227 L
.51479 .36608 L
.51575 .36975 L
.51668 .37327 L
.51767 .377 L
.51862 .38058 L
.51953 .38401 L
.5205 .38766 L
.52144 .39115 L
.52243 .39485 L
.52339 .3984 L
.52431 .40181 L
.52529 .40541 L
.52623 .40887 L
.52714 .41218 L
.52811 .41569 L
.52904 .41905 L
.53003 .4226 L
.53098 .426 L
.5319 .42926 L
.53287 .43271 L
.53381 .436 L
.53481 .43949 L
.53577 .44282 L
.5367 .44601 L
.53768 .44938 L
Mistroke
.53863 .45261 L
.53954 .45568 L
.54051 .45894 L
.54144 .46205 L
.54243 .46532 L
.54339 .46846 L
.54431 .47145 L
.54529 .4746 L
.54623 .47761 L
.54714 .48048 L
.5481 .48352 L
.54903 .4864 L
.55002 .48945 L
.55097 .49235 L
.55188 .49511 L
.55286 .49803 L
.55379 .5008 L
.55479 .50372 L
.55575 .5065 L
.55667 .50914 L
.55765 .51192 L
.5586 .51456 L
.55951 .51707 L
.56047 .51971 L
.56141 .52222 L
.5624 .52486 L
.56335 .52736 L
.56427 .52973 L
.56524 .53222 L
.56618 .53458 L
.56718 .53705 L
.56815 .5394 L
.56907 .54162 L
.57006 .54394 L
.57101 .54614 L
.57192 .54823 L
.57289 .5504 L
.57382 .55246 L
.57482 .55461 L
.57578 .55664 L
.5767 .55855 L
.57768 .56055 L
.57862 .56243 L
.57953 .5642 L
.58049 .56605 L
.58142 .56779 L
.58241 .5696 L
.58336 .57129 L
.58428 .57289 L
.58525 .57454 L
Mistroke
.58619 .57609 L
.58719 .5777 L
.58815 .5792 L
.58907 .5806 L
.59006 .58205 L
.591 .5834 L
.59191 .58466 L
.59288 .58595 L
.59381 .58716 L
.59481 .58839 L
.59576 .58954 L
.59668 .59059 L
.59766 .59168 L
.5986 .59267 L
.5996 .59368 L
.60056 .59461 L
.60149 .59546 L
.60248 .59631 L
.60343 .59709 L
.60434 .5978 L
.60531 .5985 L
.60625 .59913 L
.60724 .59976 L
.6082 .60031 L
.60913 .6008 L
.61011 .60127 L
.61105 .60168 L
.61196 .60203 L
.61293 .60236 L
.61386 .60263 L
.61485 .60287 L
.6158 .60305 L
.61672 .60318 L
.61719 .60323 L
.61769 .60327 L
.61794 .60329 L
.61821 .6033 L
.61833 .60331 L
.61846 .60331 L
.61858 .60331 L
.61869 .60332 L
.61875 .60332 L
.61881 .60332 L
.61887 .60332 L
.61892 .60332 L
.61895 .60332 L
.61897 .60332 L
.619 .60332 L
.61902 .60332 L
.61904 .60332 L
Mistroke
.61907 .60332 L
.61908 .60332 L
.6191 .60332 L
.61913 .60332 L
.61915 .60332 L
.61916 .60332 L
.61922 .60332 L
.61927 .60332 L
.61933 .60332 L
.61939 .60332 L
.61949 .60331 L
.6196 .60331 L
.61985 .6033 L
.62007 .60329 L
.62057 .60326 L
.62103 .60322 L
.62153 .60316 L
.6225 .60301 L
.62344 .60282 L
.62444 .60257 L
.62541 .60228 L
.62633 .60196 L
.62732 .60157 L
.62827 .60114 L
.62918 .60069 L
.63015 .60017 L
.63109 .59961 L
.63208 .59898 L
.63304 .59832 L
.63396 .59764 L
.63494 .59687 L
.63588 .59609 L
.63679 .59529 L
.63776 .5944 L
.63869 .59349 L
.63968 .59248 L
.64063 .59147 L
.64155 .59045 L
.64252 .58932 L
.64346 .58818 L
.64446 .58693 L
.64542 .58568 L
.64634 .58444 L
.64733 .58307 L
.64827 .58171 L
.64918 .58036 L
.65015 .57888 L
.65109 .57741 L
.65208 .57581 L
.65304 .57422 L
Mistroke
.65395 .57265 L
.65493 .57094 L
.65587 .56925 L
.65688 .56741 L
.65784 .5656 L
.65877 .56382 L
.65975 .56188 L
.66071 .55997 L
.66162 .5581 L
.66259 .55606 L
.66353 .55407 L
.66452 .55191 L
.66548 .54978 L
.66641 .54771 L
.66739 .54546 L
.66833 .54325 L
.66924 .5411 L
.67021 .53877 L
.67114 .53649 L
.67213 .53403 L
.67308 .53163 L
.674 .52928 L
.67498 .52675 L
.67592 .52428 L
.67692 .52162 L
.67788 .51901 L
.6788 .51648 L
.67979 .51375 L
.68074 .51109 L
.68165 .5085 L
.68262 .50571 L
.68355 .503 L
.68455 .50008 L
.68551 .49724 L
.68643 .49447 L
.68741 .49151 L
.68835 .48862 L
.68926 .48582 L
.69022 .4828 L
.69115 .47988 L
.69214 .47674 L
.69309 .47369 L
.69401 .47073 L
.69498 .46756 L
.69592 .46448 L
.69691 .46118 L
.69787 .45797 L
.6988 .45487 L
.69978 .45154 L
.70073 .44832 L
Mistroke
.70164 .44519 L
.70261 .44185 L
.70354 .43861 L
.70453 .43514 L
.70549 .43178 L
.7064 .42853 L
.70738 .42505 L
.70832 .42168 L
.70932 .41808 L
.71029 .4146 L
.71121 .41123 L
.7122 .40763 L
.71315 .40415 L
.71406 .40079 L
.71503 .39719 L
.71597 .39372 L
.71696 .39001 L
.71792 .38643 L
.71884 .38297 L
.71983 .37928 L
.72077 .37571 L
.72168 .37227 L
.72264 .3686 L
.72358 .36506 L
.72456 .36128 L
.72552 .35763 L
.72643 .35412 L
.72741 .35037 L
.72835 .34676 L
.72935 .34291 L
.73031 .3392 L
.73123 .33563 L
.73222 .33182 L
.73317 .32815 L
.73408 .32462 L
.73505 .32085 L
.73598 .31723 L
.73697 .31338 L
.73793 .30966 L
.73885 .30609 L
.73983 .30229 L
.74077 .29863 L
.74168 .29512 L
.74264 .29138 L
.74357 .28778 L
.74456 .28396 L
.74551 .28028 L
.74642 .27675 L
.7474 .27299 L
.74833 .26938 L
Mistroke
.74933 .26556 L
.75029 .26187 L
.75121 .25834 L
.75219 .25459 L
.75314 .25098 L
.75405 .24753 L
.75502 .24385 L
.75595 .24033 L
.75694 .2366 L
.75789 .23301 L
.75881 .22957 L
.75979 .22593 L
.76073 .22243 L
.76173 .21873 L
.76269 .21518 L
.76362 .21178 L
.7646 .20817 L
.76555 .20472 L
.76646 .20141 L
.76743 .19791 L
.76837 .19456 L
.76936 .19101 L
.77032 .18762 L
.77124 .18437 L
.77222 .18093 L
.77316 .17764 L
.77407 .1745 L
.77504 .17117 L
.77597 .16799 L
.77696 .16464 L
.77791 .16143 L
.77882 .15836 L
.7798 .15512 L
.78074 .15203 L
.78173 .14877 L
.7827 .14565 L
.78362 .14268 L
.7846 .13954 L
.78555 .13655 L
.78646 .1337 L
.78743 .13069 L
.78836 .12782 L
.78935 .1248 L
.79031 .12192 L
.79123 .11918 L
.79221 .11629 L
.79315 .11354 L
.79415 .11066 L
.79511 .10791 L
.79604 .10529 L
Mistroke
.79703 .10254 L
.79798 .09993 L
.79889 .09745 L
.79986 .09484 L
.8008 .09236 L
.8018 .08977 L
.80275 .0873 L
.80368 .08496 L
.80466 .08251 L
.8056 .08019 L
.80651 .07798 L
.80748 .07568 L
.80841 .07349 L
.8094 .07121 L
.81035 .06904 L
.81127 .067 L
.81225 .06486 L
.81319 .06285 L
.81418 .06074 L
.81515 .05876 L
.81607 .05688 L
.81706 .05493 L
.818 .0531 L
.81892 .05137 L
.81989 .04957 L
.82082 .04787 L
.82181 .04612 L
.82277 .04447 L
.82369 .04292 L
.82467 .04132 L
.82561 .03982 L
.82652 .03842 L
.82748 .03696 L
.82841 .03561 L
.8294 .03421 L
.83035 .03291 L
.83127 .0317 L
.83224 .03046 L
.83318 .02931 L
.83418 .02813 L
.83514 .02704 L
.83606 .02603 L
.83704 .02501 L
.83799 .02407 L
.8389 .0232 L
.83987 .02233 L
.8408 .02153 L
.84179 .02073 L
.84274 .02001 L
.84366 .01936 L
Mistroke
.84464 .01871 L
.84558 .01813 L
.84658 .01757 L
.84754 .01707 L
.84847 .01664 L
.84946 .01623 L
.85041 .01588 L
.85132 .01558 L
.85229 .01532 L
.85323 .01511 L
.85422 .01493 L
.85472 .01487 L
.85518 .01481 L
.85562 .01477 L
.85585 .01476 L
.8561 .01474 L
.85634 .01473 L
.85645 .01473 L
.85657 .01472 L
.85667 .01472 L
.85678 .01472 L
.85684 .01472 L
.8569 .01472 L
.85695 .01472 L
.85701 .01472 L
.85703 .01472 L
.85706 .01472 L
.85709 .01472 L
.85712 .01472 L
.85715 .01472 L
.85717 .01472 L
.85718 .01472 L
.85721 .01472 L
.85724 .01472 L
.85727 .01472 L
.85731 .01472 L
.85737 .01472 L
.85743 .01472 L
.85749 .01472 L
.85759 .01472 L
.8577 .01472 L
.85793 .01473 L
.85818 .01474 L
.8584 .01476 L
.85891 .01479 L
.85936 .01484 L
.85986 .0149 L
.86085 .01507 L
.86179 .01527 L
.8627 .01551 L
Mistroke
.86367 .01581 L
.8646 .01614 L
.86559 .01654 L
.86654 .01698 L
.86746 .01744 L
.86844 .01798 L
.86938 .01854 L
.87038 .01919 L
.87134 .01986 L
.87227 .02055 L
.87325 .02134 L
.8742 .02214 L
.87511 .02295 L
.87608 .02386 L
.87702 .02478 L
.87801 .0258 L
.87897 .02683 L
.87989 .02787 L
.88087 .02902 L
.88181 .03017 L
.88272 .03131 L
.88368 .03258 L
.88461 .03384 L
.8856 .03522 L
.88655 .0366 L
.88747 .03796 L
.88844 .03946 L
.88938 .04094 L
.89038 .04256 L
.89134 .04417 L
.89226 .04575 L
.89325 .04748 L
.89419 .04919 L
.8951 .05087 L
.89607 .05269 L
.897 .05449 L
.898 .05645 L
.89895 .05837 L
.89987 .06026 L
.90085 .06231 L
.90179 .06432 L
.90279 .0665 L
.90375 .06864 L
.90468 .07074 L
.90567 .073 L
.90662 .07523 L
.90753 .0774 L
.9085 .07975 L
.90944 .08204 L
.91043 .08452 L
Mistroke
.91139 .08694 L
.91231 .08931 L
.91329 .09186 L
.91424 .09436 L
.91515 .09678 L
.91611 .0994 L
.91704 .10196 L
.91803 .1047 L
.91899 .10738 L
.9199 .10999 L
.92088 .1128 L
.92182 .11553 L
.92282 .11847 L
.92378 .12133 L
.9247 .12411 L
.92569 .1271 L
.92664 .13001 L
.92755 .13283 L
.92852 .13586 L
.92945 .13881 L
.93044 .14197 L
.9314 .14504 L
.93232 .14802 L
.9333 .15121 L
.93424 .15432 L
.93515 .15732 L
.93611 .16054 L
.93704 .16367 L
.93803 .16701 L
.93898 .17026 L
.9399 .1734 L
.94087 .17677 L
.94181 .18003 L
.9428 .18352 L
.94376 .1869 L
.94469 .19017 L
.94567 .19367 L
.94661 .19706 L
.94752 .20033 L
.94849 .20383 L
.94942 .20722 L
.95041 .21084 L
.95137 .21434 L
.95229 .21772 L
.95326 .22134 L
.9542 .22483 L
.9552 .22856 L
.95617 .23216 L
.95709 .23564 L
.95808 .23935 L
Mistroke
.95903 .24294 L
.95994 .2464 L
.96091 .25009 L
.96185 .25365 L
.96284 .25745 L
.9638 .26111 L
.96472 .26464 L
.9657 .26841 L
.96664 .27204 L
.96755 .27554 L
.96852 .27927 L
.96945 .28287 L
.97044 .28669 L
.97139 .29038 L
.9723 .29393 L
.97328 .29772 L
.97422 .30136 L
.97522 .30523 L
.97618 .30896 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool001<0oooo100000040?ooo`030000003oool0oooo0?l0oooo0`3oool001D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo07`0oooo00<0
00000?ooo`3oool0903oool001D0oooo00<000000?ooo`3oool00`3oool2000005X0oooo1P00001i
0?ooo`H00000903oool000d0oooo100000040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0F03oool2000000D0oooo0P00001e0?ooo`<000001@3oool200000280oooo000E0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`060?ooo`80
0000L`3oool2000000P0oooo0P00000Q0?ooo`004`3oool3000000D0oooo00<000000?ooo`3oool0
EP3oool00`000000oooo0?ooo`080?ooo`800000L@3oool2000000X0oooo0P00000P0?ooo`005@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool02P3o
ool200000700oooo00<000000?ooo`3oool02P3oool2000001l0oooo000K0?ooo`030000003oool0
oooo05@0oooo0P00000=0?ooo`800000KP3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01d0oooo000K0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`1[0?ooo`8000003P3oool2000001h0oooo000K0?ooo`030000003oool0oooo05<0
oooo00<000000?ooo`3oool03P3oool2000006`0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0L0?ooo`006`3oool2000005<0oooo0P00000A0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`006`3oool00`000000oooo0?oo
o`1B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0I`3oool200000180oooo0P00
000L0?ooo`006`3oool00`000000oooo0?ooo`1A0?ooo`8000004`3oool00`000000oooo0?ooo`1W
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06P3oool001/0oooo00<000000?oo
o`3oool0D@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo06D0oooo0P00000D0?oo
o`8000006`3oool001/0oooo00<000000?ooo`3oool0D03oool2000001D0oooo00<000000?ooo`3o
ool0I@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo000K0?ooo`030000
003oool0oooo0500oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1T0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool06@3oool001/0oooo00<000000?ooo`3oool0C`3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0H0?ooo`006`3oool200000500oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`1R0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0603oool0
01/0oooo00<000000?ooo`3oool0CP3oool2000001T0oooo00<000000?ooo`3oool0H@3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo000K0?ooo`030000003oool0oooo04h0
oooo00<000000?ooo`3oool0603oool200000680oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0G0?ooo`006`3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0G`3oool2000001X0oooo0P00000H0?ooo`006`3oool00`000000oooo0?oo
o`1=0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo01H0oooo000K0?ooo`030000003oool0oooo04d0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool05P3oool001/0oooo00<000000?ooo`3oool0C03oool2000001d0oooo00<000000?oo
o`3oool0G@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01D0oooo000K0?ooo`03
0000003oool0oooo04`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1M0?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool05@3oool001/0oooo0P00001=0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo04/0oooo0P00000O0?ooo`030000003o
ool0oooo05/0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0D0?ooo`006`3oool0
0`000000oooo0?ooo`1;0?ooo`030000003oool0oooo01h0oooo0P00001L0?ooo`030000003oool0
oooo01h0oooo00<000000?ooo`3oool0503oool001/0oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0D0?ooo`006`3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01<0
oooo000K0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0803oool2000005X0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0C0?ooo`006`3oool00`000000oooo0?oo
o`1:0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo01<0oooo000K0?ooo`030000003oool0oooo04T0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo0280oooo00<00000
0?ooo`3oool04P3oool001/0oooo0P00001:0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool0E`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0180oooo000K0?ooo`03
0000003oool0oooo04T0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool04P3oool001/0oooo00<000000?ooo`3oool0
B03oool2000002D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo0140oooo000K0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool04@3o
ool001/0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo05<0oooo0P00000V0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0403oool000P0oooo0P0000040?ooo`030000003oool0oooo0080
oooo0`0000050?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`1C0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0403oool000L0oooo
00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04L0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0403oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`020?ooo`800000B03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0?0?ooo`0000<0oooo000000000000
0P0000020?ooo`040000003oool0oooo000000P0oooo0`0000050?ooo`030000003oool0oooo04H0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo02P0
oooo00<000000?ooo`3oool03`3oool000L0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`1A0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool03`3oool000L0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04H0
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool03P3oool000P0oooo0P0000090?ooo`@00000103oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0C`3oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0>
0?ooo`006`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool0C@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00d0oooo000K0?ooo`80
0000A@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`140?ooo`030000
003oool0oooo02d0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0/0?ooo`030000
003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0303o
ool001/0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0]0?ooo`030000003oool0
oooo04/0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?ooo`006`3oool00`00
0000oooo0?ooo`130?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo00`0oooo000K0?ooo`030000003oool0oooo04<0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool0303oool001/0oooo00<000000?ooo`3oool0@`3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0<03oool00`000000oooo
0?ooo`0;0?ooo`006`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo02l0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00/0oooo000K
0?ooo`800000@`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool0<03oool00`000000oooo0?ooo`0;0?ooo`006`3oool00`000000oooo0?ooo`120?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo00/0oooo000K0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3o
ool0<@3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool02P3oool001/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo04L0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0:0?ooo`006`3o
ool00`000000oooo0?ooo`110?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0AP3o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00X0oooo000K0?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`160?ooo`030000003oool0
oooo03<0oooo00<000000?ooo`3oool02@3oool001/0oooo00<000000?ooo`3oool0@@3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0=03oool00`00
0000oooo0?ooo`090?ooo`006`3oool200000440oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool02@3oool001/0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?oo
o`100?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`0e0?ooo`030000003oool0oooo00P0oooo000K0?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0=@3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool0203oool001/0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo04<0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`080?oo
o`006`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3o
ool0@P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00P0oooo000K0?ooo`030000
003oool0oooo02P0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000
0`3oool4000001`0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000
0`3oool4000001d0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000
103oool2000000`0oooo00<000000?ooo`3oool03`3oool2000000@0oooo00<000000?ooo`3oool0
0`3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
1`3oool001/0oooo00<000000?ooo`3oool09`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000000L0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000001`0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
2`3oool00`000000oooo0?ooo`0>0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool01`3oool001/0oooo0P00000X0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3o
ool06P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0000000L0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool03P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000080oooo00D000000?ooo`3oool000000?ooo`05000000h0oooo00<000000?ooo`3oool0
1`3oool001/0oooo00<000000?ooo`3oool09`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0
oooo01X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`0000006`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool2000000`0oooo00<0
00000?ooo`3oool03P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool01`3oool001/0oooo00<000000?ooo`3oool09`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`03
0000003oool0oooo01X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000D0oooo0P00000K0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool03`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000000@0?ooo`030000
003oool0oooo00H0oooo000K0?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080000000@0oooo00000000
00000000703oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`02000001/0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000002P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`800000403oool00`00
0000oooo0?ooo`060?ooo`006`3oool00`000000oooo0?ooo`0X0?ooo`8000002P3oool2000000@0
oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo01/0oooo0P00000:0?ooo`80
0000103oool2000000@0oooo0P0000000`3oool000000?ooo`0K0?ooo`8000002P3oool2000000@0
oooo0P0000040?ooo`8000002`3oool00`000000oooo0?ooo`0@0?ooo`8000002P3oool2000000@0
oooo0P0000050?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01P3oool001/0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03h0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`060?ooo`006`3oool00`000000oooo0?oo
o`0m0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo00D0oooo000K0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool01@3oool001@0ooooo`00000=000000006`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool00000
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`8000002@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool001/0
oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0S0?ooo`006`3oool2000003`0oooo
00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo04D0oooo
000K0?ooo`800000?03oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool0A@3oool001/0oooo0P00000l0?ooo`030000003oool0oooo03l0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`150?ooo`006`3oool2000003`0oooo00<000000?oo
o`3oool0?`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo04H0oooo000K0?ooo`03
0000003oool0000003X0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0i0?ooo`03
0000003oool0oooo04H0oooo000K0?ooo`<00000>P3oool00`000000oooo0?ooo`110?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool0AP3oool001/0oooo00<000000?ooo`000000>P3o
ool00`000000oooo0?ooo`110?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0AP3o
ool001/0oooo00<000000?ooo`000000>P3oool00`000000oooo0?ooo`110?ooo`030000003oool0
oooo03L0oooo00<000000?ooo`3oool0A`3oool001/0oooo00@000000?ooo`3oool00000>03oool0
0`000000oooo0?ooo`120?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0A`3oool0
01/0oooo00@000000?ooo`3oool00000>03oool00`000000oooo0?ooo`130?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool0A`3oool001/0oooo00@000000?ooo`3oool00000>03oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0B03oool0
01/0oooo00@000000?ooo`3oool00000=`3oool2000004D0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`180?ooo`006`3oool01@000000oooo0?ooo`3oool0000003H0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo04P0oooo000K0?oo
o`8000000P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo04D0oooo00<000000?oo
o`3oool0=03oool00`000000oooo0?ooo`180?ooo`006`3oool01@000000oooo0?ooo`3oool00000
03H0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo
04T0oooo000K0?ooo`050000003oool0oooo0?ooo`000000=@3oool00`000000oooo0?ooo`160?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0B@3oool001/0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`190?ooo`006`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0380oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo04T0oooo000K0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0<P3o
ool00`000000oooo0?ooo`170?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0BP3o
ool001/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`1:0?ooo`006`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo04X0oooo000K0?ooo`800000103oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`1;0?ooo`006`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0300oooo
00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo04/0oooo
000K0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`1:0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0B`3oool001/0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04X0oooo0P00000`
0?ooo`030000003oool0oooo04/0oooo000K0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool0C03oool001/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo04/0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`1<0?ooo`00
6`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0
C03oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo04`0oooo000K0?ooo`8000001P3o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`1<0?ooo`006`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo04d0oooo000K0?ooo`030000003oool0oooo00D0oooo0P00000/0?ooo`030000003oool0oooo
04h0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1=0?ooo`006`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0CP3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo04d0oooo000K0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo02T0oooo
0P00001?0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool0C`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo04h0oooo0008
0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0X
0?ooo`030000003oool0oooo04h0oooo00070?ooo`040000003oool0oooo000000/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo04h0oooo00070?oo
o`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool2000000P0oooo00<00000
0?ooo`3oool0:03oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool0C`3oool000L0oooo00@000000?ooo`3oool00000203oool3000000D0oooo00<00000
0?ooo`3oool01`3oool2000002P0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo04l0oooo00070?ooo`040000003oool0oooo000000P0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0D`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo04l0oooo00070?oo
o`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo0500oooo00080?ooo`8000002@3oool4000000@0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0U0?ooo`800000E@3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo0500oooo000K0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0903oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0D03oool001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool08`3oool200000580oooo000K0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1E0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool0D@3oool001/0oooo0P00000;0?ooo`030000003oool0
oooo0280oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0
oooo0540oooo000K0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool08P3oool00`00
0000oooo0?ooo`1G0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0D@3oool001/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo05L0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1B0?ooo`006`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0F03oool200000280oooo
00<000000?ooo`3oool0DP3oool001/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`1B0?ooo`006`3oool00`000000oooo0?ooo`0;0?ooo`8000008@3oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0D`3oool001/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo05X0oooo0P00000P0?oo
o`030000003oool0oooo05<0oooo000K0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo01d0oooo0P00001E0?ooo`00
6`3oool2000000h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1K0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool0E03oool001/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`1D0?ooo`006`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`0K0?ooo`800000EP3oool0
01/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
05h0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1E0?ooo`006`3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0G`3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo05D0oooo000K0?ooo`030000003oool0oooo00h0oooo
0P00000J0?ooo`800000H@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo05H0oooo
000K0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`1P0?ooo`8000006P3oool00`000000oooo0?ooo`1F0?ooo`006`3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`0G
0?ooo`800000F03oool001/0oooo0P00000A0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0HP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo05L0oooo000K0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1S0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool0E`3oool001/0oooo00<000000?ooo`3oool0
403oool2000001H0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo05P0oooo000K0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo01<0oooo0P00001J0?ooo`006`3oool0
0`000000oooo0?ooo`0A0?ooo`800000503oool2000006L0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`1I0?ooo`006`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`0A0?ooo`800000F`3oool001/0
oooo00<000000?ooo`3oool04P3oool200000180oooo0P00001Y0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0FP3oool001/0oooo0P00000D0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0?0?ooo`800000G03oool001/0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo06X0oooo0P00
000@0?ooo`030000003oool0oooo05/0oooo000K0?ooo`030000003oool0oooo01@0oooo0P00000>
0?ooo`800000K@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo05`0oooo000K0?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1/0?oo
o`8000003@3oool2000005h0oooo000K0?ooo`030000003oool0oooo01D0oooo0P00000<0?ooo`03
0000003oool0oooo06h0oooo0P00000<0?ooo`030000003oool0oooo05d0oooo000K0?ooo`030000
003oool0oooo01H0oooo0P00000:0?ooo`800000L@3oool2000000X0oooo00<000000?ooo`3oool0
GP3oool001<0oooo100000040?ooo`030000003oool0oooo01L0oooo0P0000080?ooo`800000L`3o
ool2000000P0oooo00<000000?ooo`3oool0G`3oool001D0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0H0?ooo`8000001P3oool2000007D0oooo0P0000050?ooo`800000HP3oool0
01D0oooo00<000000?ooo`3oool00`3oool2000001/0oooo1P00001h0?ooo`L00000H`3oool001D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000E0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0o`3oool30?ooo`004`3oool3000000D0oooo00<0
00000?ooo`3oool0o`3oool30?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0?l0oooo0`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.000490292, -1.13006, \
1.79422*^-5, 0.0127737}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[\n\t\(+\ Sin[\ 2\ \[Pi]\ 440\ t]\)\n + \ 
          Sin[\ 2\ \[Pi]\ 444\ t]\n\t, {t, 0, 1}, 
        PlotPoints -> 1000];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.147155 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -12 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -6 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60333 -6 -4.5 ]
[.01131 .60333 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-2)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-1)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(1)] .01131 .45617 1 0 Mshowa
.02381 .60333 m
.03006 .60333 L
s
[(2)] .01131 .60333 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .19129 m
.02756 .19129 L
s
.02381 .22072 m
.02756 .22072 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .5739 m
.02756 .5739 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02392 .40314 L
.02403 .48213 L
.02414 .55038 L
.02417 .56538 L
.0242 .57741 L
.02423 .58627 L
.02426 .59394 L
.02429 .59925 L
.02432 .60225 L
.02435 .60332 L
.02438 .60204 L
.02441 .59863 L
.02444 .59342 L
.02446 .58714 L
.02449 .57859 L
.02455 .55286 L
.02462 .51663 L
.02474 .43304 L
.02501 .20477 L
.02508 .15463 L
.02515 .10774 L
.02521 .0715 L
.02527 .04505 L
.0253 .03554 L
.02532 .02813 L
.02535 .02158 L
.02538 .0175 L
.02541 .01512 L
.02544 .01493 L
.02547 .01696 L
.02548 .01887 L
.0255 .02165 L
.02553 .0289 L
.02556 .03774 L
.02563 .06499 L
.02569 .09673 L
.02575 .13691 L
.026 .33682 L
.02612 .43645 L
.02623 .51461 L
.02628 .54427 L
.02633 .56706 L
.02638 .58519 L
.02641 .59233 L
.02644 .59802 L
.02647 .60161 L
.0265 .60313 L
.02653 .60226 L
.02656 .59945 L
Mistroke
.02658 .5948 L
.02661 .58899 L
.02667 .57069 L
.02673 .5429 L
.02678 .51087 L
.02691 .42052 L
.02714 .2286 L
.02726 .13188 L
.02733 .09267 L
.02738 .06304 L
.02744 .03894 L
.02747 .02911 L
.0275 .02215 L
.02752 .01942 L
.02754 .01725 L
.02757 .01521 L
.02759 .01513 L
.0276 .01572 L
.02762 .01713 L
.02764 .01952 L
.02767 .02514 L
.0277 .03217 L
.02776 .05431 L
.02782 .08217 L
.02787 .11422 L
.02812 .31189 L
.02825 .41839 L
.02837 .50464 L
.02843 .54239 L
.02849 .56959 L
.02853 .58166 L
.02856 .59066 L
.02858 .59432 L
.02859 .59749 L
.02861 .60012 L
.02863 .60175 L
.02866 .60272 L
.02869 .60169 L
.02872 .59845 L
.02875 .59267 L
.02877 .58568 L
.0288 .57758 L
.02886 .55376 L
.02892 .51939 L
.02898 .48175 L
.02911 .38106 L
.02933 .2001 L
.02944 .11465 L
.0295 .08061 L
.02955 .0551 L
Mistroke
.02961 .0349 L
.02964 .02674 L
.02967 .02103 L
.0297 .01712 L
.02973 .01565 L
.02976 .01643 L
.02978 .01795 L
.02979 .02 L
.02982 .0252 L
.02985 .0317 L
.02991 .05224 L
.02996 .07669 L
.03002 .1083 L
.03026 .29419 L
.03039 .40578 L
.03051 .49848 L
.03057 .53309 L
.03063 .56296 L
.03066 .57541 L
.0307 .58648 L
.03072 .59043 L
.03073 .59404 L
.03076 .5989 L
.03079 .6014 L
.03082 .60201 L
.03085 .60028 L
.03088 .59651 L
.03091 .59108 L
.03093 .5846 L
.03099 .56491 L
.03104 .53796 L
.0311 .5076 L
.03121 .42338 L
.03143 .24437 L
.03154 .15588 L
.0316 .11356 L
.03166 .07928 L
.03171 .05347 L
.03174 .04241 L
.03177 .03271 L
.0318 .0257 L
.03183 .02101 L
.03185 .01793 L
.03188 .01653 L
.03191 .01677 L
.03194 .01942 L
.03195 .02169 L
.03197 .0248 L
.032 .03219 L
.03203 .04179 L
Mistroke
.03206 .05284 L
.03212 .07839 L
.03224 .15661 L
.03237 .26323 L
.03249 .36371 L
.03262 .46426 L
.03268 .50604 L
.03274 .53989 L
.03279 .56456 L
.03285 .58461 L
.03288 .59237 L
.03291 .59733 L
.03293 .59921 L
.03294 .60054 L
.03298 .60109 L
.033 .5994 L
.03304 .59532 L
.03306 .58998 L
.03309 .58221 L
.03316 .55732 L
.03323 .52047 L
.03336 .43253 L
.0336 .22963 L
.03373 .13215 L
.0338 .08846 L
.03387 .0559 L
.03392 .0353 L
.03396 .02705 L
.03399 .02168 L
.03402 .01838 L
.03403 .01754 L
.03405 .01742 L
.03407 .01801 L
.03408 .01917 L
.0341 .02125 L
.03412 .02393 L
.03415 .02993 L
.03417 .03833 L
.03423 .05847 L
.03429 .0869 L
.03435 .12536 L
.03461 .33096 L
.03474 .43528 L
.03486 .51675 L
.03491 .54675 L
.03496 .56937 L
.03499 .57936 L
.03502 .58801 L
.03505 .59389 L
.03508 .59758 L
Mistroke
.03511 .59975 L
.03513 .5999 L
.03516 .59798 L
.03519 .59354 L
.03521 .59038 L
.03523 .58626 L
.03526 .57696 L
.03532 .55353 L
.03538 .52366 L
.03543 .49013 L
.03555 .39847 L
.0358 .19189 L
.03591 .11714 L
.03597 .08356 L
.03602 .05796 L
.03608 .037 L
.03611 .02902 L
.03612 .02579 L
.03614 .02297 L
.03617 .0197 L
.0362 .01863 L
.03623 .01949 L
.03625 .02192 L
.03628 .02687 L
.03631 .03358 L
.03636 .0513 L
.03642 .0774 L
.03648 .11326 L
.0367 .27881 L
.03694 .4686 L
.037 .51105 L
.03707 .5488 L
.0371 .56292 L
.03714 .5754 L
.03717 .58475 L
.0372 .59122 L
.03723 .59575 L
.03725 .59813 L
.03728 .59862 L
.03732 .59681 L
.03734 .59323 L
.03737 .58744 L
.0374 .5809 L
.03742 .57203 L
.03749 .54608 L
.03755 .50968 L
.03767 .42604 L
.03793 .21079 L
.03806 .11882 L
.03812 .08627 L
Mistroke
.03818 .05764 L
.03821 .04562 L
.03824 .03654 L
.03827 .02967 L
.03829 .0244 L
.03833 .02109 L
.03835 .02011 L
.03839 .02138 L
.0384 .02317 L
.03842 .02546 L
.03844 .02844 L
.03845 .0323 L
.03848 .04103 L
.03856 .06889 L
.03862 .10126 L
.03868 .1446 L
.03894 .34593 L
.03905 .43442 L
.03911 .47653 L
.03917 .51612 L
.03923 .54853 L
.03928 .57132 L
.03931 .57987 L
.03934 .58723 L
.03937 .59234 L
.03939 .59542 L
.03942 .59701 L
.03945 .59669 L
.03948 .59435 L
.03951 .58952 L
.03953 .58621 L
.03954 .58195 L
.03957 .57245 L
.03963 .54883 L
.0397 .51382 L
.03976 .47555 L
.03989 .3735 L
.04013 .17705 L
.04025 .09895 L
.04031 .06844 L
.04034 .05411 L
.04037 .04324 L
.0404 .03561 L
.04043 .02918 L
.04046 .02455 L
.04049 .02224 L
.04052 .02191 L
.04055 .02351 L
.04057 .02646 L
.0406 .03136 L
Mistroke
.04063 .03978 L
.04066 .05014 L
.04072 .07548 L
.04079 .11053 L
.04086 .15664 L
.0411 .35081 L
.04122 .4509 L
.04129 .49367 L
.04134 .52765 L
.0414 .5528 L
.04145 .5741 L
.04148 .58236 L
.04151 .58828 L
.04154 .59258 L
.04157 .59496 L
.04159 .59527 L
.0416 .59489 L
.04163 .59237 L
.04165 .58997 L
.04167 .58707 L
.0417 .57813 L
.04174 .56782 L
.04177 .55636 L
.04183 .52396 L
.04195 .44837 L
.04207 .35162 L
.0423 .16756 L
.04237 .1228 L
.04243 .08681 L
.04249 .06071 L
.04252 .04893 L
.04255 .03987 L
.04257 .03358 L
.0426 .02853 L
.04263 .02503 L
.04266 .02379 L
.04269 .0245 L
.04272 .02758 L
.04275 .03269 L
.04278 .03929 L
.04283 .05709 L
.04288 .07856 L
.04299 .14271 L
.04323 .33421 L
.04337 .43976 L
.04343 .48506 L
.04349 .52084 L
.04354 .54655 L
.0436 .56853 L
.04363 .57777 L
Mistroke
.04365 .58443 L
.04368 .58906 L
.04371 .59211 L
.04374 .5932 L
.04377 .59219 L
.0438 .58914 L
.04382 .5846 L
.04385 .57762 L
.04389 .56774 L
.04395 .54101 L
.0442 .37293 L
.04444 .18307 L
.04454 .11372 L
.0446 .08287 L
.04465 .0595 L
.04468 .04886 L
.04471 .04085 L
.04474 .03393 L
.04475 .03102 L
.04477 .02886 L
.0448 .02652 L
.04482 .02596 L
.04485 .02711 L
.04488 .03037 L
.04489 .03291 L
.04491 .03622 L
.04494 .04368 L
.04501 .06754 L
.04506 .09543 L
.04513 .13275 L
.04535 .30341 L
.04549 .41251 L
.04561 .50115 L
.04567 .53206 L
.04573 .55837 L
.04576 .56919 L
.04579 .57866 L
.04582 .58498 L
.04585 .58885 L
.04588 .59073 L
.04591 .59048 L
.04594 .58805 L
.04597 .58389 L
.046 .57801 L
.04602 .57118 L
.04608 .55093 L
.04614 .52192 L
.04621 .4832 L
.04632 .39818 L
.04656 .20558 L
Mistroke
.04669 .11807 L
.04676 .07973 L
.0468 .06493 L
.04683 .05334 L
.04686 .04448 L
.04689 .0369 L
.0469 .0339 L
.04692 .03166 L
.04694 .02992 L
.04695 .02876 L
.04698 .02852 L
.047 .02924 L
.04702 .03068 L
.04705 .03487 L
.04707 .04064 L
.0471 .04888 L
.04713 .0585 L
.04719 .08106 L
.04731 .15058 L
.04755 .3414 L
.04769 .44512 L
.04775 .48916 L
.04781 .52364 L
.04786 .54854 L
.04792 .56921 L
.04795 .57746 L
.04798 .58308 L
.04801 .58659 L
.04804 .5883 L
.04806 .58833 L
.04807 .58775 L
.04809 .58644 L
.04811 .5843 L
.04814 .57897 L
.04817 .57066 L
.0482 .56114 L
.04823 .54883 L
.04829 .52143 L
.04841 .44699 L
.04852 .36126 L
.04874 .19351 L
.04886 .11374 L
.04891 .08284 L
.04897 .06035 L
.04899 .05133 L
.04902 .04331 L
.04905 .03723 L
.04909 .03303 L
.0491 .0317 L
.04912 .03108 L
Mistroke
.04914 .03106 L
.04915 .03174 L
.04918 .03458 L
.0492 .03711 L
.04921 .04001 L
.04927 .05404 L
.04932 .07264 L
.04943 .13247 L
.04966 .30195 L
.04978 .39737 L
.04991 .48861 L
.04997 .52242 L
.05003 .55123 L
.05009 .56928 L
.05012 .57667 L
.05015 .58163 L
.05017 .58441 L
.0502 .58564 L
.05023 .58489 L
.05026 .58234 L
.05028 .57833 L
.05031 .57334 L
.05036 .55763 L
.05042 .53414 L
.05048 .50166 L
.05059 .42761 L
.05084 .23436 L
.05096 .14768 L
.05107 .0855 L
.0511 .07297 L
.05113 .06116 L
.05116 .05176 L
.05118 .04491 L
.05122 .03896 L
.05123 .03665 L
.05125 .0351 L
.05128 .03385 L
.05131 .03469 L
.05133 .03605 L
.05134 .03789 L
.05136 .04055 L
.05138 .04412 L
.05141 .05371 L
.05145 .06504 L
.05151 .09345 L
.05157 .12751 L
.05178 .27974 L
.05201 .45361 L
.05207 .49389 L
.05214 .52944 L
Mistroke
.0522 .55323 L
.05223 .56376 L
.05226 .57153 L
.05229 .57736 L
.05232 .58092 L
.05235 .58249 L
.05237 .58243 L
.0524 .58029 L
.05242 .5784 L
.05244 .57569 L
.05247 .56931 L
.05249 .56156 L
.05256 .53873 L
.05261 .51026 L
.05272 .44203 L
.05297 .25238 L
.05309 .16643 L
.05321 .09334 L
.05325 .07673 L
.05328 .06358 L
.05332 .0532 L
.05335 .04585 L
.05338 .04086 L
.05341 .03777 L
.05344 .03693 L
.05346 .03746 L
.05347 .03862 L
.05351 .04239 L
.05352 .04509 L
.05354 .04868 L
.0536 .06571 L
.05363 .07837 L
.05366 .09431 L
.05373 .12869 L
.05396 .30058 L
.05408 .38794 L
.0542 .47159 L
.05425 .50569 L
.05431 .5327 L
.05436 .55211 L
.05439 .56083 L
.05441 .5675 L
.05444 .57336 L
.05446 .57568 L
.05447 .57756 L
.05449 .57886 L
.05451 .57944 L
.05454 .57885 L
.05457 .57631 L
.05459 .57227 L
Mistroke
.05462 .566 L
.05465 .55727 L
.05472 .53265 L
.05478 .50225 L
.05492 .41211 L
.05515 .23457 L
.05528 .14376 L
.05534 .10742 L
.0554 .08039 L
.05543 .06957 L
.05546 .05965 L
.05549 .05267 L
.05551 .04675 L
.05555 .04252 L
.05556 .04111 L
.05558 .04038 L
.05561 .04049 L
.05564 .04264 L
.05565 .04468 L
.05567 .04713 L
.0557 .0546 L
.05573 .06334 L
.05577 .07481 L
.05589 .13339 L
.05601 .21376 L
.05612 .30006 L
.05633 .45626 L
.05644 .52007 L
.05647 .53387 L
.05651 .54664 L
.05654 .55663 L
.05656 .56409 L
.0566 .57035 L
.05661 .57274 L
.05663 .57458 L
.05666 .57605 L
.05668 .57597 L
.05669 .57529 L
.05672 .5725 L
.05675 .56822 L
.05678 .56163 L
.05681 .55264 L
.05687 .53283 L
.05692 .50579 L
.05703 .44419 L
.05726 .2708 L
.05738 .18307 L
.0575 .10716 L
.05757 .07786 L
.05761 .06499 L
Mistroke
.05764 .05562 L
.05766 .05212 L
.05767 .04935 L
.0577 .04565 L
.05774 .04383 L
.05775 .0438 L
.05777 .04443 L
.0578 .04684 L
.05783 .05135 L
.05786 .05739 L
.05788 .06443 L
.05794 .08603 L
.05801 .11612 L
.05812 .18953 L
.05825 .2858 L
.05837 .37442 L
.0585 .46178 L
.05855 .4956 L
.05862 .52566 L
.05867 .5459 L
.0587 .55493 L
.05872 .56183 L
.05874 .56508 L
.05876 .56796 L
.05879 .57131 L
.05881 .57223 L
.05883 .57245 L
.05884 .57193 L
.05886 .57084 L
.05889 .56705 L
.05891 .56395 L
.05893 .5605 L
.05899 .54237 L
.05904 .51962 L
.0591 .48834 L
.05923 .40927 L
.05947 .22887 L
.05959 .14916 L
.0597 .09216 L
.05976 .06967 L
.05979 .06116 L
.05981 .05717 L
.05982 .0541 L
.05984 .05161 L
.05986 .04955 L
.05987 .04818 L
.05989 .0475 L
.05991 .04756 L
.05993 .04829 L
.05994 .04963 L
Mistroke
.05996 .05138 L
.05999 .05645 L
.06002 .06294 L
.06008 .08369 L
.06014 .10851 L
.0602 .14067 L
.06044 .31179 L
.06056 .40102 L
.06067 .47385 L
.06078 .52491 L
.06083 .54558 L
.06086 .55269 L
.06088 .55881 L
.06091 .56394 L
.06094 .56701 L
.06097 .56854 L
.061 .56809 L
.06103 .56592 L
.06106 .56177 L
.06108 .55616 L
.06111 .54964 L
.06117 .52908 L
.06122 .50416 L
.06135 .43042 L
.06158 .26416 L
.0617 .17601 L
.06182 .10936 L
.06188 .08435 L
.06191 .07404 L
.06194 .06491 L
.06198 .05788 L
.062 .05511 L
.06201 .05322 L
.06205 .05149 L
.06206 .05146 L
.06208 .05202 L
.06211 .05443 L
.06213 .0583 L
.06216 .06432 L
.0622 .07279 L
.06226 .09621 L
.06232 .12415 L
.06254 .26895 L
.06267 .36253 L
.0628 .45375 L
.06291 .51474 L
.06295 .52771 L
.06298 .53966 L
.06301 .54883 L
.06304 .55553 L
Mistroke
.06307 .56005 L
.0631 .56318 L
.06311 .56417 L
.06313 .56457 L
.06316 .56393 L
.06319 .56127 L
.06322 .55705 L
.06325 .55049 L
.06328 .5414 L
.06333 .52191 L
.06338 .49892 L
.0635 .43229 L
.06375 .24839 L
.06388 .16384 L
.06394 .12914 L
.064 .10265 L
.06406 .08078 L
.06408 .07292 L
.06411 .06617 L
.06414 .06074 L
.06417 .05743 L
.0642 .0557 L
.06421 .05557 L
.06423 .056 L
.06425 .05696 L
.06426 .05862 L
.06429 .06322 L
.06432 .06966 L
.06435 .07728 L
.06442 .10022 L
.06448 .1324 L
.0647 .26984 L
.06493 .43537 L
.06505 .50148 L
.06511 .52651 L
.06514 .53793 L
.06517 .54635 L
.0652 .55243 L
.06523 .55661 L
.06526 .55934 L
.06529 .56034 L
.06531 .55953 L
.06534 .55698 L
.06537 .55343 L
.06539 .54809 L
.06543 .5394 L
.06546 .52912 L
.06552 .50485 L
.06565 .43018 L
.0659 .25896 L
Mistroke
.06601 .17865 L
.06613 .11732 L
.06619 .09178 L
.06622 .08117 L
.06626 .07222 L
.06628 .06651 L
.0663 .06405 L
.06632 .06227 L
.06634 .06033 L
.06637 .05997 L
.0664 .06144 L
.06643 .06444 L
.06646 .06953 L
.06649 .07693 L
.06655 .09381 L
.0666 .11842 L
.06671 .17783 L
.06681 .2454 L
.06693 .33087 L
.06706 .42065 L
.06712 .45705 L
.06719 .49091 L
.06725 .51699 L
.0673 .53549 L
.06733 .54277 L
.06736 .54875 L
.06739 .55296 L
.06741 .55453 L
.06742 .55546 L
.06745 .55581 L
.06748 .55464 L
.06751 .55153 L
.06753 .54686 L
.06756 .54129 L
.06759 .53396 L
.06764 .51732 L
.06775 .46486 L
.06798 .31235 L
.0681 .22419 L
.06822 .15221 L
.06832 .10476 L
.06835 .09418 L
.06838 .08558 L
.0684 .0791 L
.06843 .07332 L
.06845 .06885 L
.06848 .0658 L
.06851 .06454 L
.06853 .06472 L
.06856 .06663 L
Mistroke
.06859 .06997 L
.06862 .07567 L
.06865 .08288 L
.06871 .10096 L
.06877 .12622 L
.06887 .18476 L
.06912 .35063 L
.06925 .43948 L
.06932 .47639 L
.06938 .50479 L
.06944 .52529 L
.06946 .53357 L
.06949 .54073 L
.06953 .54608 L
.06955 .54939 L
.06957 .55059 L
.06959 .55116 L
.06962 .55072 L
.06965 .54868 L
.06968 .54477 L
.0697 .53948 L
.06973 .53329 L
.06979 .51418 L
.06985 .48751 L
.06997 .42205 L
.0701 .33591 L
.07021 .25945 L
.07033 .1827 L
.07038 .15204 L
.07044 .12394 L
.07049 .10383 L
.07054 .08706 L
.07057 .07959 L
.0706 .0745 L
.07063 .07109 L
.07066 .06944 L
.07067 .06921 L
.07069 .0695 L
.07072 .07143 L
.07074 .07327 L
.07075 .07551 L
.07079 .08238 L
.07081 .08936 L
.07084 .09822 L
.0709 .11775 L
.07101 .17678 L
.07126 .33837 L
.07139 .42603 L
.07145 .46333 L
.07152 .49272 L
Mistroke
.07157 .51534 L
.0716 .52466 L
.07163 .5329 L
.07167 .53923 L
.0717 .54337 L
.07171 .54503 L
.07173 .546 L
.07175 .54636 L
.07176 .54621 L
.07179 .54454 L
.07182 .54151 L
.07185 .53623 L
.07188 .52955 L
.07193 .51372 L
.07199 .49132 L
.0721 .43322 L
.07222 .35797 L
.07243 .21558 L
.07255 .14872 L
.0726 .12225 L
.07266 .10245 L
.07269 .09371 L
.07272 .08588 L
.07275 .07998 L
.07277 .0776 L
.07279 .07593 L
.07281 .07432 L
.07284 .07434 L
.07287 .07601 L
.0729 .07962 L
.07293 .08442 L
.07295 .09004 L
.07301 .10684 L
.07306 .12725 L
.07311 .15035 L
.07334 .2919 L
.07358 .44218 L
.07363 .47181 L
.07369 .49861 L
.07373 .51131 L
.07376 .52107 L
.07379 .52863 L
.07381 .53205 L
.07382 .53478 L
.07385 .53867 L
.07388 .54071 L
.07391 .54134 L
.07393 .54061 L
.07396 .5381 L
.07399 .53355 L
Mistroke
.07402 .52815 L
.07405 .52066 L
.07411 .50305 L
.07416 .47893 L
.07427 .42391 L
.07451 .26418 L
.07464 .18416 L
.07471 .14723 L
.07478 .11886 L
.07484 .09996 L
.07487 .09191 L
.0749 .08623 L
.07491 .08376 L
.07493 .08195 L
.07495 .08049 L
.07497 .07957 L
.07498 .07929 L
.075 .07956 L
.07503 .08147 L
.07506 .08484 L
.07509 .09005 L
.07511 .0958 L
.07514 .10348 L
.0752 .12541 L
.07526 .15137 L
.07548 .28012 L
.07571 .42726 L
.07583 .48674 L
.07586 .49949 L
.0759 .51126 L
.07593 .51969 L
.07596 .52697 L
.07599 .53182 L
.07602 .53471 L
.07605 .53605 L
.07607 .53603 L
.07608 .53553 L
.07611 .53349 L
.07614 .52963 L
.07617 .52445 L
.0762 .51837 L
.07626 .49957 L
.07631 .47656 L
.07644 .4083 L
.07671 .24017 L
.07683 .1712 L
.07688 .14291 L
.07694 .12106 L
.077 .10192 L
.07703 .09456 L
Mistroke
.07705 .09156 L
.07707 .08891 L
.07709 .08703 L
.0771 .08577 L
.07713 .08463 L
.07716 .08512 L
.07719 .08722 L
.07722 .09094 L
.07724 .09376 L
.07725 .09681 L
.07731 .11211 L
.07736 .13088 L
.07742 .15538 L
.07766 .29904 L
.07777 .37103 L
.07789 .43935 L
.07799 .48575 L
.07805 .50548 L
.0781 .51896 L
.07813 .52429 L
.07816 .52786 L
.07818 .52985 L
.07821 .53069 L
.07824 .53003 L
.07827 .52757 L
.0783 .52405 L
.07833 .51869 L
.07836 .51117 L
.07839 .50281 L
.07845 .47912 L
.07857 .42172 L
.07878 .29033 L
.0789 .21828 L
.07901 .16006 L
.07907 .13438 L
.0791 .12299 L
.07913 .11269 L
.07916 .10542 L
.07919 .09903 L
.07922 .09469 L
.07925 .09193 L
.07928 .09034 L
.0793 .09024 L
.07933 .0913 L
.07935 .0937 L
.07938 .09774 L
.07941 .10365 L
.07947 .11823 L
.07953 .13938 L
.07959 .16766 L
Mistroke
.0797 .23015 L
.07997 .39183 L
.08008 .45424 L
.08015 .48165 L
.08021 .50188 L
.08024 .51073 L
.08026 .51456 L
.08028 .51798 L
.0803 .52035 L
.08031 .5224 L
.08035 .52462 L
.08036 .52507 L
.08038 .52503 L
.0804 .52446 L
.08041 .5234 L
.08044 .52029 L
.08046 .51784 L
.08047 .51513 L
.08053 .50146 L
.08059 .48376 L
.08071 .42829 L
.08096 .27961 L
.08108 .2074 L
.08119 .15172 L
.08125 .12989 L
.08131 .11215 L
.08135 .10482 L
.08136 .102 L
.08138 .09986 L
.08141 .09706 L
.08142 .09622 L
.08144 .09582 L
.08147 .09625 L
.08149 .09784 L
.08152 .10108 L
.08155 .10555 L
.0816 .11667 L
.08165 .13323 L
.08177 .18552 L
.08189 .24758 L
.08201 .3223 L
.08214 .40061 L
.08226 .45863 L
.08232 .48165 L
.08235 .4926 L
.08238 .50104 L
.08241 .50739 L
.08244 .51279 L
.08245 .51508 L
.08247 .51676 L
Mistroke
.0825 .51885 L
.08253 .51933 L
.08255 .51846 L
.08258 .51601 L
.08261 .51228 L
.08264 .50756 L
.08267 .50135 L
.08272 .48719 L
.08283 .4425 L
.08307 .30265 L
.0832 .2308 L
.08331 .17322 L
.08341 .13325 L
.08346 .11879 L
.08349 .11247 L
.08352 .10784 L
.08355 .10428 L
.08357 .10228 L
.0836 .10165 L
.08363 .10221 L
.08366 .1043 L
.08369 .10817 L
.08371 .11281 L
.08374 .11933 L
.0838 .13713 L
.08386 .15823 L
.08399 .21936 L
.08422 .35334 L
.08434 .42282 L
.08446 .47362 L
.08452 .49212 L
.08455 .50009 L
.08458 .50576 L
.0846 .50815 L
.08462 .5102 L
.08464 .51187 L
.08465 .51287 L
.08469 .51336 L
.0847 .51288 L
.08472 .51193 L
.08475 .50903 L
.08477 .50674 L
.08478 .50426 L
.08484 .49147 L
.08487 .48204 L
.08491 .47014 L
.08497 .44446 L
.08521 .3164 L
.08532 .25152 L
.08544 .18903 L
Mistroke
.08549 .16356 L
.08555 .14326 L
.0856 .12863 L
.08563 .12202 L
.08565 .11693 L
.08568 .11272 L
.08571 .10954 L
.08574 .10793 L
.08577 .10785 L
.0858 .1092 L
.08583 .11205 L
.08585 .11563 L
.08588 .12072 L
.08594 .13683 L
.08601 .16035 L
.08613 .21614 L
.08639 .36529 L
.08651 .42526 L
.08658 .4538 L
.08664 .47567 L
.08669 .49133 L
.08673 .49787 L
.08676 .50238 L
.08679 .50556 L
.08681 .50664 L
.08682 .50718 L
.08685 .50701 L
.08687 .50626 L
.08688 .50518 L
.0869 .50354 L
.08692 .5013 L
.08695 .49602 L
.08698 .48858 L
.08702 .47839 L
.08715 .42869 L
.0874 .29178 L
.08752 .22584 L
.08763 .17393 L
.08769 .15308 L
.08775 .13482 L
.08778 .12747 L
.08781 .12198 L
.08784 .11769 L
.08786 .11597 L
.08788 .11484 L
.0879 .11388 L
.08793 .11423 L
.08796 .116 L
.08799 .11947 L
.08802 .12426 L
Mistroke
.08805 .13007 L
.0881 .14416 L
.08817 .16524 L
.08823 .19242 L
.08835 .25055 L
.08861 .39404 L
.08872 .44684 L
.08878 .46727 L
.08883 .4822 L
.08886 .48872 L
.0889 .49417 L
.08893 .49807 L
.08895 .49957 L
.08896 .5005 L
.08899 .50102 L
.08902 .50027 L
.08905 .4981 L
.08908 .49432 L
.08911 .48968 L
.08913 .48446 L
.08919 .46939 L
.08929 .4318 L
.08952 .31409 L
.08974 .19787 L
.08986 .1544 L
.08989 .14526 L
.08992 .13692 L
.08995 .13058 L
.08998 .12601 L
.09 .12402 L
.09001 .12236 L
.09003 .12106 L
.09005 .12039 L
.09007 .12019 L
.09008 .12046 L
.0901 .12118 L
.09012 .12223 L
.09014 .12521 L
.09018 .12996 L
.09021 .13653 L
.09024 .14409 L
.09036 .18371 L
.09048 .24148 L
.09072 .37234 L
.09085 .43228 L
.09092 .45633 L
.09096 .4678 L
.09099 .47663 L
.09102 .48293 L
.09105 .4883 L
Mistroke
.09107 .49046 L
.09109 .49206 L
.0911 .49334 L
.09112 .49422 L
.09114 .49458 L
.09115 .49453 L
.09118 .49327 L
.09121 .4906 L
.09124 .48691 L
.09127 .48204 L
.0913 .47648 L
.09135 .46031 L
.09147 .41472 L
.09169 .305 L
.09181 .24296 L
.09192 .19188 L
.09198 .1684 L
.09204 .15098 L
.09207 .14352 L
.0921 .13687 L
.09214 .13182 L
.09216 .12978 L
.09217 .12834 L
.0922 .12688 L
.09223 .12682 L
.09226 .12785 L
.09229 .13014 L
.09232 .13398 L
.09235 .13957 L
.09241 .1533 L
.09247 .17225 L
.09253 .19727 L
.09265 .25175 L
.09279 .32296 L
.09292 .38847 L
.09304 .43907 L
.09311 .46089 L
.09314 .46923 L
.09317 .47575 L
.0932 .48054 L
.09323 .48442 L
.09326 .48674 L
.09328 .48785 L
.09331 .48794 L
.09334 .48671 L
.09337 .48395 L
.0934 .48003 L
.09343 .47469 L
.09346 .46762 L
.09352 .45148 L
Mistroke
.09365 .40107 L
.09389 .28254 L
.09399 .2325 L
.0941 .18638 L
.09416 .16542 L
.09422 .15046 L
.09425 .14471 L
.09428 .14038 L
.0943 .13694 L
.09433 .13448 L
.09437 .13338 L
.09438 .13336 L
.0944 .13375 L
.09443 .13549 L
.09446 .13832 L
.09447 .14059 L
.09449 .14313 L
.09452 .14886 L
.09459 .16622 L
.0947 .20736 L
.09483 .26453 L
.09506 .37866 L
.09517 .42605 L
.09522 .44306 L
.09527 .45847 L
.09533 .47082 L
.09536 .47561 L
.09539 .47879 L
.09541 .48003 L
.09543 .48083 L
.09545 .48133 L
.09547 .48104 L
.09549 .48042 L
.0955 .47934 L
.09552 .47775 L
.09555 .47453 L
.09558 .46996 L
.09563 .45888 L
.09569 .44133 L
.09575 .42155 L
.09601 .30119 L
.09614 .24007 L
.09625 .19278 L
.09631 .1748 L
.09636 .15919 L
.09639 .1535 L
.09642 .14854 L
.09644 .14519 L
.09647 .14247 L
.0965 .14062 L
Mistroke
.09653 .14011 L
.09655 .14031 L
.09656 .14092 L
.09659 .14305 L
.09662 .14624 L
.09665 .15087 L
.09671 .16225 L
.09677 .17857 L
.09683 .20038 L
.09694 .24852 L
.0972 .37278 L
.09732 .41823 L
.09738 .43857 L
.09743 .454 L
.09747 .46095 L
.0975 .46691 L
.09752 .46901 L
.09753 .47086 L
.09756 .47324 L
.09759 .47438 L
.09762 .47431 L
.09765 .47298 L
.09767 .47166 L
.09769 .4701 L
.09772 .466 L
.09775 .46021 L
.09781 .44629 L
.09788 .4244 L
.09794 .40032 L
.09819 .28766 L
.09831 .23467 L
.09837 .20911 L
.09843 .18843 L
.09849 .17258 L
.09854 .16124 L
.09857 .15619 L
.09859 .15241 L
.09862 .14949 L
.09865 .14759 L
.09869 .14703 L
.09871 .14771 L
.09873 .14861 L
.09875 .14977 L
.09876 .1514 L
.09878 .15353 L
.09881 .15862 L
.09884 .16462 L
.09891 .18242 L
.09903 .22303 L
.09916 .27682 L
Mistroke
.0994 .38785 L
.09947 .41334 L
.09954 .43583 L
.0996 .45067 L
.09964 .45713 L
.09967 .46179 L
.0997 .46489 L
.09972 .46611 L
.09973 .46691 L
.09976 .4675 L
.09979 .4669 L
.09982 .46508 L
.09985 .46227 L
.09987 .45886 L
.0999 .45426 L
.09997 .4401 L
.10003 .42037 L
.10015 .37522 L
.10038 .27305 L
.10051 .2211 L
.10057 .19956 L
.10063 .18285 L
.10068 .17034 L
.10071 .16525 L
.10074 .16081 L
.10077 .15747 L
.10079 .15536 L
.10081 .15457 L
.10083 .15416 L
.10086 .15431 L
.10088 .15535 L
.10091 .15737 L
.10093 .16013 L
.10096 .16333 L
.10101 .17392 L
.10107 .18722 L
.10151 .36516 L
.10163 .41049 L
.1017 .43032 L
.10173 .43843 L
.10176 .44487 L
.10179 .44985 L
.10182 .45426 L
.10185 .45751 L
.10187 .45878 L
.10188 .45964 L
.10191 .46036 L
.10193 .46013 L
.10196 .45891 L
.10199 .45653 L
Mistroke
.10202 .45301 L
.10205 .44885 L
.10211 .43638 L
.10217 .42124 L
.10222 .40417 L
.10247 .30239 L
.10259 .25257 L
.10271 .20741 L
.10278 .18889 L
.10281 .18082 L
.10285 .17361 L
.10289 .1684 L
.10292 .16486 L
.10295 .1625 L
.10298 .16139 L
.10301 .1614 L
.10302 .1619 L
.10304 .16268 L
.10307 .16488 L
.1031 .16829 L
.10313 .17228 L
.10315 .17676 L
.10321 .18954 L
.10333 .22592 L
.10345 .27543 L
.10368 .37071 L
.10378 .40605 L
.10384 .42152 L
.1039 .43506 L
.10393 .44104 L
.10396 .4455 L
.10399 .44883 L
.10402 .45133 L
.10405 .45281 L
.10408 .45313 L
.10409 .45284 L
.10411 .45228 L
.10412 .45129 L
.10414 .45002 L
.10417 .44659 L
.10421 .44164 L
.10427 .42954 L
.10433 .41229 L
.10441 .38905 L
.10466 .28872 L
.10478 .24198 L
.10489 .20604 L
.10495 .19188 L
.10501 .18027 L
.10504 .17576 L
Mistroke
.10507 .17249 L
.1051 .17003 L
.10511 .16916 L
.10513 .1687 L
.10516 .16863 L
.10518 .16938 L
.10521 .17108 L
.10524 .17392 L
.10527 .17801 L
.1053 .18288 L
.10536 .19449 L
.10548 .23089 L
.1056 .27354 L
.10573 .32408 L
.10586 .37566 L
.10592 .39625 L
.10598 .41311 L
.10604 .42652 L
.10607 .43186 L
.10609 .43599 L
.10612 .43926 L
.10614 .44207 L
.10617 .4442 L
.1062 .44539 L
.10623 .44579 L
.10626 .44517 L
.10628 .4438 L
.10631 .44141 L
.10634 .43746 L
.10638 .43263 L
.10644 .42082 L
.1065 .40447 L
.10657 .38307 L
.10681 .2929 L
.10692 .25213 L
.10703 .21489 L
.1071 .19834 L
.10713 .1924 L
.10716 .18691 L
.10719 .18294 L
.10722 .17967 L
.10724 .17829 L
.10725 .17732 L
.10728 .17617 L
.10731 .17604 L
.10733 .17641 L
.10735 .17713 L
.10738 .17925 L
.10741 .18219 L
.10744 .18679 L
Mistroke
.10747 .19203 L
.10754 .20723 L
.10767 .24448 L
.10779 .2876 L
.10802 .37277 L
.10808 .39339 L
.10815 .40985 L
.1082 .42174 L
.10823 .42708 L
.10826 .43115 L
.10829 .43401 L
.10832 .43628 L
.10835 .43782 L
.10838 .43833 L
.10841 .43794 L
.10844 .43647 L
.10847 .43409 L
.10849 .43104 L
.10854 .42375 L
.1086 .41305 L
.10871 .38403 L
.10894 .29995 L
.10906 .25789 L
.10917 .22429 L
.10924 .20815 L
.1093 .19672 L
.10933 .19169 L
.10936 .18803 L
.10938 .18646 L
.1094 .18531 L
.10942 .18436 L
.10943 .18373 L
.10946 .1835 L
.10949 .1842 L
.10952 .18578 L
.10955 .18798 L
.10958 .19145 L
.10961 .1963 L
.10967 .20783 L
.11014 .35825 L
.11027 .39558 L
.11034 .41153 L
.11037 .41756 L
.1104 .4222 L
.11043 .42549 L
.11046 .42814 L
.11048 .42924 L
.11049 .43001 L
.11053 .43073 L
.11054 .43074 L
Mistroke
.11056 .43047 L
.11059 .4293 L
.11062 .42706 L
.11064 .42534 L
.11065 .42344 L
.11071 .41479 L
.11077 .40194 L
.11089 .3709 L
.11111 .29784 L
.11123 .25699 L
.1113 .2372 L
.11136 .22114 L
.11142 .20888 L
.11145 .20362 L
.11148 .19903 L
.11151 .19594 L
.11154 .19341 L
.11157 .19191 L
.1116 .1912 L
.11163 .19121 L
.11164 .19157 L
.11166 .19224 L
.11169 .19411 L
.11172 .19666 L
.11175 .20059 L
.11178 .20507 L
.11185 .218 L
.11196 .24782 L
.11209 .28635 L
.11221 .32684 L
.11232 .36286 L
.11243 .39212 L
.11248 .40235 L
.11253 .41141 L
.11256 .41492 L
.11258 .41801 L
.11261 .42049 L
.11264 .42207 L
.11266 .42264 L
.11267 .423 L
.1127 .42297 L
.11273 .42208 L
.11276 .4205 L
.11279 .41805 L
.11282 .41504 L
.11288 .40571 L
.11294 .39359 L
.11301 .3776 L
.11323 .30746 L
.11345 .24299 L
Mistroke
.11356 .21826 L
.11359 .21282 L
.11362 .20845 L
.11365 .20522 L
.11368 .20241 L
.11371 .20035 L
.11372 .19958 L
.11374 .1991 L
.11377 .19881 L
.1138 .1993 L
.11381 .19994 L
.11383 .20094 L
.11385 .20216 L
.11387 .20353 L
.11393 .21103 L
.11396 .21611 L
.11399 .22248 L
.11406 .23616 L
.11417 .26761 L
.11443 .34816 L
.11454 .37763 L
.11461 .39093 L
.11466 .40114 L
.1147 .40576 L
.11473 .4098 L
.11475 .41123 L
.11476 .41253 L
.11479 .41424 L
.11482 .41517 L
.11485 .41531 L
.11488 .41466 L
.1149 .41393 L
.11491 .41302 L
.11494 .41075 L
.11497 .40749 L
.11503 .39958 L
.1151 .38701 L
.11516 .37303 L
.11542 .29835 L
.11554 .26459 L
.1156 .24816 L
.11566 .23474 L
.11571 .22437 L
.11576 .21683 L
.11579 .21363 L
.11582 .2108 L
.11585 .20859 L
.11588 .20725 L
.1159 .20682 L
.11591 .20661 L
Mistroke
.11593 .20667 L
.11595 .20693 L
.11598 .20799 L
.11601 .20989 L
.11602 .21119 L
.11604 .21281 L
.11607 .21633 L
.11614 .22702 L
.11627 .25425 L
.11638 .28526 L
.1166 .34903 L
.11673 .37812 L
.11679 .3893 L
.11684 .39737 L
.11687 .40068 L
.1169 .40357 L
.11693 .40568 L
.11695 .4065 L
.11696 .40704 L
.11698 .4074 L
.117 .4075 L
.11703 .40705 L
.11705 .40644 L
.11706 .40566 L
.11708 .40455 L
.1171 .40311 L
.11716 .39676 L
.11721 .38851 L
.11734 .36268 L
.11759 .29496 L
.11771 .26253 L
.11777 .25002 L
.11783 .23798 L
.11788 .22966 L
.11793 .2226 L
.11796 .21961 L
.11799 .21746 L
.11801 .21594 L
.11804 .21492 L
.11807 .2145 L
.1181 .21473 L
.11813 .2156 L
.11815 .21692 L
.11818 .21912 L
.11821 .22228 L
.11827 .22995 L
.11874 .34152 L
.11887 .3704 L
.11894 .383 L
.11897 .38785 L
Mistroke
.11901 .39164 L
.11904 .39475 L
.11907 .39691 L
.11908 .39786 L
.1191 .39857 L
.11912 .39911 L
.11913 .39947 L
.11916 .3995 L
.11918 .39924 L
.1192 .39874 L
.11923 .39733 L
.11926 .39541 L
.11929 .39266 L
.11931 .38953 L
.11938 .38051 L
.11949 .35819 L
.11971 .30445 L
.11983 .27403 L
.11995 .24971 L
.12001 .23919 L
.12007 .23161 L
.1201 .22842 L
.12013 .22577 L
.12015 .22476 L
.12017 .22388 L
.12018 .22316 L
.1202 .22271 L
.12023 .22245 L
.12025 .22259 L
.12026 .22292 L
.12028 .22345 L
.1203 .22411 L
.12033 .22621 L
.12036 .22862 L
.12039 .23191 L
.12045 .23951 L
.12059 .26511 L
.12071 .29495 L
.12095 .35014 L
.12101 .3628 L
.12108 .37407 L
.12114 .38167 L
.12117 .38506 L
.1212 .38763 L
.12121 .38872 L
.12123 .38971 L
.12126 .39094 L
.12128 .39135 L
.1213 .39156 L
.12131 .39155 L
Mistroke
.12133 .39135 L
.12136 .39048 L
.12138 .3897 L
.12139 .38882 L
.12142 .38663 L
.12145 .38399 L
.12151 .37695 L
.12157 .36863 L
.12169 .34464 L
.12191 .29527 L
.12202 .27059 L
.12214 .24932 L
.1222 .24095 L
.12224 .23745 L
.12227 .23446 L
.12229 .23333 L
.12231 .23243 L
.12234 .2312 L
.12236 .23059 L
.12239 .23053 L
.12242 .23103 L
.12245 .23222 L
.12247 .23306 L
.12249 .23415 L
.12252 .23658 L
.12258 .24293 L
.12263 .25048 L
.12285 .29229 L
.12297 .31896 L
.12308 .34197 L
.12319 .36156 L
.12325 .37027 L
.12331 .3765 L
.12334 .37894 L
.12337 .38104 L
.12339 .38186 L
.1234 .38256 L
.12344 .38334 L
.12345 .38349 L
.12347 .38349 L
.1235 .38305 L
.12353 .38206 L
.12355 .38067 L
.12358 .37879 L
.12361 .37625 L
.12367 .37039 L
.12377 .35555 L
.124 .31074 L
.12412 .28596 L
.12424 .26291 L
Mistroke
.12431 .25397 L
.12436 .24722 L
.12442 .24274 L
.12445 .24091 L
.12448 .23968 L
.1245 .23888 L
.12453 .23858 L
.12456 .23875 L
.12458 .23908 L
.12459 .23952 L
.12462 .24074 L
.12465 .24262 L
.12469 .24517 L
.12472 .24807 L
.12484 .26498 L
.12498 .28935 L
.12523 .33723 L
.1253 .34861 L
.12537 .35889 L
.12543 .36591 L
.12546 .36906 L
.12549 .37149 L
.12553 .37323 L
.12554 .37399 L
.12556 .37455 L
.12559 .37519 L
.12562 .37539 L
.12565 .37506 L
.12568 .37423 L
.12569 .37353 L
.12571 .37275 L
.12575 .37052 L
.1258 .36584 L
.12586 .35912 L
.12598 .34141 L
.12622 .29732 L
.12634 .27685 L
.12645 .26153 L
.12651 .25506 L
.12654 .25243 L
.12658 .25014 L
.12659 .24917 L
.12661 .24842 L
.12664 .24735 L
.12666 .24697 L
.12668 .24676 L
.1267 .24673 L
.12671 .24687 L
.12674 .24751 L
.12677 .24859 L
Mistroke
.1268 .24993 L
.12683 .25177 L
.12689 .25732 L
.12695 .26399 L
.12719 .30094 L
.12732 .32362 L
.12744 .34289 L
.1275 .35019 L
.12756 .35671 L
.12759 .35953 L
.12762 .36217 L
.12765 .36412 L
.12768 .3655 L
.12771 .36641 L
.12774 .36701 L
.12777 .36722 L
.1278 .36701 L
.12782 .36645 L
.12785 .36548 L
.12788 .36422 L
.1279 .36279 L
.12796 .3584 L
.12802 .35232 L
.12813 .33837 L
.12837 .2996 L
.12847 .28407 L
.12858 .27008 L
.12864 .26384 L
.1287 .25949 L
.12873 .2579 L
.12876 .25654 L
.12879 .25563 L
.12881 .25512 L
.12885 .25492 L
.12886 .25499 L
.12888 .2552 L
.12891 .25588 L
.12894 .2569 L
.12897 .25855 L
.129 .26046 L
.12907 .26608 L
.12919 .28014 L
.12931 .29661 L
.12952 .32818 L
.12964 .34323 L
.1297 .34905 L
.12976 .35331 L
.12978 .35503 L
.12981 .35657 L
.12984 .35768 L
Mistroke
.12987 .35841 L
.1299 .35889 L
.12993 .35899 L
.12994 .3589 L
.12996 .35869 L
.12999 .35801 L
.13002 .35698 L
.13005 .35543 L
.13012 .35107 L
.13018 .34568 L
.13023 .33964 L
.13045 .3119 L
.13068 .28193 L
.13074 .27551 L
.13081 .26999 L
.13087 .26651 L
.1309 .26506 L
.13093 .26406 L
.13096 .26346 L
.13099 .26318 L
.13101 .26323 L
.13104 .26359 L
.13107 .26432 L
.13109 .26489 L
.13111 .26551 L
.13117 .26863 L
.13122 .27275 L
.13128 .2774 L
.1314 .2903 L
.13161 .31747 L
.13172 .33051 L
.13179 .3367 L
.13184 .34169 L
.1319 .34542 L
.13193 .34702 L
.13196 .34841 L
.13199 .34941 L
.13201 .35008 L
.13204 .35052 L
.13206 .35071 L
.13209 .35067 L
.13212 .35029 L
.13214 .34997 L
.13216 .34953 L
.13219 .34848 L
.13222 .34712 L
.13225 .34556 L
.1323 .34197 L
.13242 .3311 L
.13256 .31645 L
Mistroke
.13268 .30285 L
.1328 .2894 L
.13286 .28412 L
.13292 .27941 L
.13298 .27618 L
.13301 .27471 L
.13303 .27357 L
.13307 .27257 L
.13309 .27193 L
.13312 .27154 L
.13314 .27145 L
.13316 .27146 L
.13318 .27165 L
.13321 .27212 L
.13324 .2729 L
.13327 .27389 L
.13334 .27709 L
.1334 .28103 L
.13354 .29267 L
.13376 .3152 L
.13388 .32662 L
.134 .33513 L
.13406 .33866 L
.1341 .34016 L
.13413 .34121 L
.13416 .34185 L
.13419 .34228 L
.13421 .3424 L
.13422 .34244 L
.13425 .34231 L
.13429 .34192 L
.1343 .34158 L
.13432 .34119 L
.13438 .3391 L
.13444 .3364 L
.13449 .33281 L
.13474 .31262 L
.13486 .3018 L
.13497 .29278 L
.13507 .28628 L
.13513 .28353 L
.13518 .28166 L
.13521 .28087 L
.13523 .28032 L
.13526 .27993 L
.13529 .27976 L
.13532 .2798 L
.13535 .28001 L
.13537 .28041 L
.1354 .28105 L
Mistroke
.13543 .28194 L
.13546 .28296 L
.13553 .2859 L
.13565 .29313 L
.13587 .31021 L
.13599 .31962 L
.13611 .32691 L
.13617 .32973 L
.13624 .33203 L
.13627 .33294 L
.13629 .33332 L
.13631 .33361 L
.13634 .33397 L
.13635 .33407 L
.13637 .33412 L
.1364 .33405 L
.13642 .33393 L
.13643 .33376 L
.13646 .33327 L
.13648 .3329 L
.1365 .33251 L
.13656 .33062 L
.13662 .32824 L
.13674 .32132 L
.13688 .31225 L
.13701 .30359 L
.13714 .29647 L
.13719 .29391 L
.13725 .29166 L
.13728 .29069 L
.13731 .28979 L
.13734 .28918 L
.13737 .28866 L
.13738 .28845 L
.1374 .28829 L
.13743 .28811 L
.13746 .28808 L
.13749 .2882 L
.13752 .28849 L
.13755 .28892 L
.13758 .28954 L
.13761 .2904 L
.13767 .29224 L
.13773 .29465 L
.13784 .29987 L
.13809 .3131 L
.13822 .31937 L
.13828 .3218 L
.13835 .32357 L
.1384 .3248 L
Mistroke
.13843 .32523 L
.13845 .32543 L
.13847 .32557 L
.13848 .32569 L
.1385 .32576 L
.13853 .32579 L
.13854 .32576 L
.13856 .32569 L
.13858 .32557 L
.13859 .32541 L
.13862 .32508 L
.13865 .32463 L
.1387 .32354 L
.13876 .32185 L
.13882 .31998 L
.13903 .31128 L
.13926 .30217 L
.13933 .30022 L
.13939 .2987 L
.13944 .29765 L
.13947 .2972 L
.1395 .29687 L
.13952 .29664 L
.13955 .29649 L
.13957 .29641 L
.1396 .29641 L
.13963 .29651 L
.13966 .29669 L
.13969 .29692 L
.13972 .29725 L
.13978 .2983 L
.13984 .29955 L
.13997 .30313 L
.14021 .31049 L
.14033 .3136 L
.14039 .31498 L
.14045 .31601 L
.14051 .31668 L
.14053 .31697 L
.14056 .31718 L
.14059 .31734 L
.14062 .31745 L
.14065 .31749 L
.14068 .31746 L
.1407 .31737 L
.14074 .31722 L
.14076 .31701 L
.14079 .31677 L
.14085 .31606 L
.14092 .3151 L
Mistroke
.14118 .31025 L
.14129 .30808 L
.14141 .30641 L
.14147 .30571 L
.1415 .30541 L
.14153 .30514 L
.14156 .30496 L
.14158 .30488 L
.14159 .30481 L
.14162 .30471 L
.14165 .30466 L
.14168 .30464 L
.14171 .30465 L
.14174 .3047 L
.14175 .30475 L
.14177 .30479 L
.14183 .30505 L
.14188 .30539 L
.14209 .3072 L
.14221 .30827 L
.14233 .30907 L
.14238 .30937 L
.14241 .30949 L
.14245 .3096 L
.14246 .30965 L
.14248 .30968 L
.1425 .30971 L
.14251 .30974 L
.14254 .30976 L
.14256 .30976 L
.14258 .30976 L
.1426 .30975 L
.14263 .30971 L
.14266 .30966 L
.14269 .3096 L
.14279 .30927 L
.14291 .30882 L
.14296 .30863 L
.14302 .30845 L
.14305 .30839 L
.14308 .30833 L
.1431 .30831 L
.14311 .30829 L
.14314 .30827 L
.14316 .30827 L
.14317 .30828 L
.14319 .30829 L
.14321 .30831 L
.14324 .30836 L
.14326 .30841 L
Mistroke
.14327 .30845 L
.14333 .30868 L
.14339 .30897 L
.14351 .30987 L
.14373 .31181 L
.14379 .31229 L
.14385 .31274 L
.14388 .31291 L
.14391 .31307 L
.14393 .31319 L
.14396 .31329 L
.14399 .31336 L
.14402 .31339 L
.14404 .3134 L
.14405 .31339 L
.14408 .31334 L
.14411 .31326 L
.14414 .31315 L
.14416 .31299 L
.14419 .31278 L
.14425 .31225 L
.14431 .3116 L
.14441 .31006 L
.14466 .30547 L
.14479 .30306 L
.14485 .30209 L
.14491 .30138 L
.14494 .30112 L
.14497 .30089 L
.145 .30072 L
.14502 .30061 L
.14505 .30056 L
.14508 .30056 L
.14511 .30063 L
.14514 .30077 L
.14517 .301 L
.1452 .30131 L
.14526 .30207 L
.14533 .30317 L
.14539 .30468 L
.14562 .31126 L
.14584 .31762 L
.1459 .31899 L
.14596 .32017 L
.14599 .32066 L
.14602 .32109 L
.14604 .32124 L
.14606 .32137 L
.14609 .32155 L
.14611 .32163 L
Mistroke
.14615 .32161 L
.14618 .32149 L
.1462 .3213 L
.14623 .32105 L
.14625 .3207 L
.14631 .31974 L
.14637 .3182 L
.14643 .31643 L
.14657 .31146 L
.14681 .30111 L
.14693 .29692 L
.14699 .29507 L
.14702 .29431 L
.14705 .29371 L
.14707 .29323 L
.1471 .29282 L
.14713 .29251 L
.14716 .29231 L
.14719 .29224 L
.14722 .29228 L
.14724 .29242 L
.14727 .29263 L
.1473 .29303 L
.14733 .2936 L
.14739 .295 L
.14746 .29726 L
.14752 .2998 L
.14776 .31228 L
.14788 .31855 L
.14799 .32368 L
.14805 .32597 L
.1481 .32766 L
.14813 .32838 L
.14816 .32902 L
.14818 .32931 L
.1482 .32952 L
.14823 .32982 L
.14826 .32995 L
.14829 .32992 L
.1483 .32983 L
.14832 .32971 L
.14834 .32952 L
.14835 .32927 L
.14839 .32865 L
.14842 .3279 L
.14849 .32559 L
.14855 .32297 L
.1486 .32016 L
.14873 .3127 L
.14895 .29788 L
Mistroke
.14907 .29094 L
.14913 .28825 L
.14919 .2863 L
.14922 .28544 L
.14925 .2848 L
.14928 .28431 L
.1493 .28411 L
.14931 .28399 L
.14933 .28392 L
.14935 .28392 L
.14938 .28407 L
.1494 .28425 L
.14941 .28447 L
.14945 .28518 L
.14948 .28593 L
.1495 .28679 L
.14956 .28927 L
.14969 .29625 L
.14994 .31531 L
.15006 .32462 L
.15012 .32823 L
.15018 .3317 L
.15023 .33411 L
.15028 .33613 L
.15031 .33697 L
.15034 .33757 L
.15036 .33797 L
.15039 .33822 L
.15042 .33828 L
.15045 .33813 L
.15048 .33779 L
.1505 .33731 L
.15053 .33654 L
.15056 .33546 L
.15062 .33288 L
.15109 .29504 L
.15122 .28514 L
.15129 .28085 L
.15133 .27922 L
.15136 .27797 L
.15139 .27702 L
.15142 .27627 L
.15145 .27579 L
.15147 .27565 L
.15149 .27559 L
.15152 .2757 L
.15155 .27603 L
.15158 .27665 L
.15159 .27706 L
.15161 .27759 L
Mistroke
.15167 .28029 L
.15173 .28379 L
.15185 .2925 L
.1521 .31772 L
.15221 .32813 L
.15232 .33737 L
.15238 .34112 L
.15241 .34275 L
.15244 .34419 L
.15247 .34523 L
.1525 .34593 L
.15253 .34638 L
.15256 .34658 L
.15259 .34652 L
.1526 .34637 L
.15262 .34614 L
.15265 .34553 L
.15268 .3446 L
.15273 .34233 L
.15279 .33891 L
.15291 .32837 L
.15303 .31586 L
.15324 .29179 L
.15336 .28077 L
.15342 .27585 L
.15347 .27214 L
.15351 .27047 L
.15354 .26924 L
.15357 .26822 L
.15359 .26784 L
.1536 .26754 L
.15363 .26731 L
.15366 .26738 L
.15369 .26777 L
.15371 .26813 L
.15373 .26855 L
.15376 .26963 L
.15378 .2709 L
.15385 .27474 L
.1539 .27915 L
.15396 .28473 L
.1542 .31249 L
.15441 .3378 L
.15447 .34312 L
.15453 .34793 L
.15455 .34975 L
.15458 .3514 L
.15461 .35267 L
.15464 .35358 L
.15467 .35439 L
Mistroke
.15468 .35466 L
.1547 .35482 L
.15473 .35483 L
.15475 .35468 L
.15476 .35445 L
.15479 .35375 L
.15482 .35283 L
.15485 .35143 L
.15488 .34978 L
.15499 .34097 L
.15509 .32976 L
.15532 .29878 L
.15543 .28401 L
.15549 .2768 L
.15555 .27085 L
.15561 .26628 L
.15564 .26428 L
.15567 .26249 L
.15569 .26115 L
.15572 .26021 L
.15575 .25954 L
.15577 .25917 L
.1558 .25904 L
.15583 .25931 L
.15585 .25961 L
.15586 .26004 L
.15589 .26114 L
.15592 .26262 L
.15595 .26437 L
.15601 .26852 L
.15613 .28166 L
.15627 .30019 L
.15638 .31798 L
.15651 .33626 L
.15657 .34367 L
.15663 .35044 L
.15668 .35527 L
.15674 .35924 L
.15677 .36085 L
.1568 .36194 L
.15683 .36269 L
.15685 .36305 L
.15689 .36306 L
.15691 .36267 L
.15695 .3618 L
.15696 .36119 L
.15698 .36038 L
.15705 .35616 L
.15708 .35299 L
.15712 .34963 L
Mistroke
.15724 .3335 L
.15747 .29844 L
.15759 .27966 L
.1577 .26503 L
.15777 .25867 L
.1578 .25603 L
.15784 .2538 L
.15787 .25238 L
.15789 .25178 L
.1579 .25135 L
.15793 .2509 L
.15796 .25085 L
.15799 .25128 L
.15801 .25173 L
.15802 .25228 L
.15805 .25361 L
.15809 .25549 L
.15814 .2598 L
.1582 .26602 L
.15845 .30326 L
.15858 .32664 L
.1587 .3464 L
.15881 .35975 L
.15887 .36521 L
.1589 .3671 L
.15893 .36873 L
.15896 .37009 L
.15899 .3709 L
.15902 .37129 L
.15903 .37129 L
.15905 .37115 L
.15908 .37052 L
.15911 .36955 L
.15914 .36796 L
.15917 .366 L
.15922 .36138 L
.15928 .35478 L
.1594 .33736 L
.15961 .29851 L
.15973 .27705 L
.1598 .26707 L
.15986 .25802 L
.15992 .25159 L
.15995 .24884 L
.15998 .24643 L
.16002 .24472 L
.16004 .2436 L
.16007 .2429 L
.1601 .24265 L
.16012 .24279 L
Mistroke
.16015 .24343 L
.16018 .24449 L
.16021 .24584 L
.16024 .24787 L
.16027 .25062 L
.16033 .25701 L
.16046 .27592 L
.16058 .2979 L
.16079 .33946 L
.1609 .358 L
.16096 .36614 L
.16102 .37215 L
.16105 .37466 L
.16108 .37678 L
.1611 .37773 L
.16112 .37843 L
.16114 .37891 L
.16115 .37926 L
.16118 .37945 L
.1612 .37934 L
.16122 .37904 L
.16125 .37809 L
.16127 .37671 L
.1613 .37479 L
.16133 .37225 L
.16139 .36643 L
.16151 .34802 L
.16175 .30118 L
.16185 .2802 L
.16196 .26014 L
.16202 .25098 L
.16208 .24414 L
.16213 .23921 L
.16216 .23737 L
.16219 .23586 L
.16221 .23527 L
.16222 .23487 L
.16225 .23452 L
.16228 .23475 L
.1623 .23516 L
.16232 .23571 L
.16235 .23716 L
.16237 .23896 L
.16244 .24459 L
.16249 .25172 L
.16254 .25971 L
.16266 .28179 L
.16288 .32859 L
.16299 .35188 L
.16305 .36296 L
Mistroke
.16311 .37186 L
.16317 .37853 L
.16319 .38135 L
.16323 .38379 L
.16325 .38538 L
.16328 .38663 L
.16331 .38732 L
.16333 .38755 L
.16336 .38729 L
.16338 .38687 L
.16339 .38629 L
.16342 .3848 L
.16345 .38259 L
.16351 .37665 L
.16357 .36943 L
.1637 .34576 L
.16383 .3181 L
.16406 .26516 L
.16418 .2443 L
.16421 .23978 L
.16425 .23562 L
.16428 .23238 L
.16431 .22999 L
.16434 .22833 L
.16437 .22713 L
.1644 .22653 L
.16441 .22646 L
.16443 .22657 L
.16446 .22722 L
.16448 .2283 L
.16451 .23003 L
.16454 .23245 L
.16459 .23807 L
.16464 .24481 L
.16475 .26479 L
.165 .32426 L
.16513 .35304 L
.16518 .36416 L
.16524 .37485 L
.16529 .38229 L
.16535 .38858 L
.16538 .39122 L
.1654 .39311 L
.16543 .39448 L
.16546 .39528 L
.16549 .39558 L
.16552 .39528 L
.16554 .3944 L
.16557 .39311 L
.1656 .39099 L
Mistroke
.16563 .38798 L
.16569 .38073 L
.16616 .27371 L
.16629 .24583 L
.16636 .23374 L
.1664 .22913 L
.16643 .22556 L
.16646 .22288 L
.16649 .22065 L
.1665 .21979 L
.16652 .21918 L
.16654 .21874 L
.16655 .21849 L
.16659 .21864 L
.1666 .21899 L
.16662 .21959 L
.16665 .22118 L
.16668 .22326 L
.16671 .22624 L
.16674 .2296 L
.1668 .23918 L
.16692 .2627 L
.16713 .31908 L
.16726 .35101 L
.16737 .37635 L
.16743 .38648 L
.16749 .39494 L
.16753 .39854 L
.16755 .39996 L
.16756 .40107 L
.16759 .4026 L
.16761 .40312 L
.16763 .40345 L
.16766 .40346 L
.16767 .40315 L
.16769 .40265 L
.1677 .4019 L
.16772 .40102 L
.16775 .39839 L
.16778 .39543 L
.16782 .39149 L
.16787 .38253 L
.16801 .35277 L
.16814 .31853 L
.16826 .28479 L
.16839 .25159 L
.16845 .23808 L
.16851 .22737 L
.16857 .21983 L
.1686 .2165 L
Mistroke
.16863 .21405 L
.16865 .21223 L
.16868 .21099 L
.16871 .21054 L
.16874 .21074 L
.16876 .21143 L
.16879 .21274 L
.16882 .21472 L
.16884 .21711 L
.1689 .2245 L
.16896 .23343 L
.16908 .25992 L
.16933 .33259 L
.16945 .36328 L
.16951 .37749 L
.16957 .3905 L
.16963 .39999 L
.16966 .40331 L
.16969 .40631 L
.16971 .40853 L
.16974 .41004 L
.16977 .41104 L
.16979 .41143 L
.16982 .41106 L
.16984 .41049 L
.16986 .40975 L
.16989 .4078 L
.16992 .40496 L
.16997 .3982 L
.17003 .38822 L
.17015 .35982 L
.17029 .32177 L
.17053 .2514 L
.17059 .23657 L
.17065 .22325 L
.17072 .21346 L
.17074 .21009 L
.17077 .2072 L
.17079 .20586 L
.17081 .20466 L
.17084 .20323 L
.17086 .20282 L
.17087 .2027 L
.17089 .20288 L
.17091 .20329 L
.17094 .20478 L
.17096 .20602 L
.17097 .20742 L
.17104 .21481 L
.17109 .22442 L
Mistroke
.17115 .23562 L
.17127 .26758 L
.17152 .34426 L
.17164 .37832 L
.1717 .39206 L
.17176 .40239 L
.17181 .41084 L
.17185 .41428 L
.17188 .41672 L
.17189 .41768 L
.17191 .41845 L
.17194 .41917 L
.17196 .41922 L
.17197 .41902 L
.17199 .41855 L
.17201 .41773 L
.17204 .41576 L
.17206 .41321 L
.17209 .40964 L
.17213 .40498 L
.17224 .38208 L
.17234 .35477 L
.17245 .31992 L
.17268 .24892 L
.17279 .22079 L
.17286 .20888 L
.17288 .20466 L
.17292 .20091 L
.17293 .19918 L
.17295 .19784 L
.17296 .19681 L
.17298 .19594 L
.17301 .19506 L
.17304 .19504 L
.17306 .19544 L
.17307 .19606 L
.17309 .19709 L
.17311 .19837 L
.17314 .20137 L
.17318 .20565 L
.17324 .21572 L
.1733 .22963 L
.17342 .26141 L
.17366 .34299 L
.17379 .38207 L
.17386 .39946 L
.17393 .41227 L
.17396 .41682 L
.17399 .42038 L
.174 .42203 L
Mistroke
.17402 .42355 L
.17405 .42555 L
.17407 .42626 L
.17408 .42675 L
.1741 .42694 L
.17412 .42682 L
.17415 .42587 L
.17417 .42492 L
.17418 .4238 L
.17421 .42121 L
.17424 .41812 L
.1743 .40879 L
.17435 .39682 L
.17442 .38126 L
.17466 .3011 L
.17479 .25729 L
.17486 .23593 L
.17493 .21868 L
.17499 .20539 L
.17505 .19623 L
.17508 .19239 L
.17511 .18972 L
.17513 .18866 L
.17514 .18795 L
.17516 .18746 L
.17518 .18727 L
.17521 .18772 L
.17523 .1884 L
.17524 .18927 L
.17527 .19154 L
.1753 .19483 L
.17536 .20266 L
.17541 .21413 L
.17567 .29399 L
.1758 .34008 L
.17592 .37923 L
.17603 .40784 L
.17608 .4188 L
.17612 .4238 L
.17614 .4277 L
.17618 .43093 L
.1762 .43301 L
.17624 .43428 L
.17625 .43454 L
.17627 .4345 L
.1763 .4337 L
.17633 .43216 L
.17636 .42945 L
.17639 .42599 L
.17644 .41731 L
Mistroke
.1765 .40463 L
.17662 .3706 L
.17684 .29355 L
.17696 .2504 L
.17702 .22932 L
.17709 .21206 L
.17715 .19891 L
.17718 .19325 L
.17721 .18826 L
.17724 .18493 L
.17727 .18219 L
.1773 .18056 L
.17732 .1798 L
.17735 .17982 L
.17738 .18081 L
.17741 .18265 L
.17743 .18509 L
.17747 .18886 L
.1775 .19402 L
.17756 .2061 L
.17769 .24241 L
.17781 .28458 L
.17802 .36477 L
.17814 .40207 L
.1782 .41673 L
.17825 .42761 L
.17828 .43249 L
.17831 .43608 L
.17834 .4391 L
.17836 .44032 L
.17837 .44117 L
.1784 .44199 L
.17843 .44197 L
.17845 .4411 L
.17848 .43922 L
.17851 .43677 L
.17854 .43333 L
.17859 .42507 L
.17865 .412 L
.1787 .39735 L
.17896 .3047 L
.17907 .26106 L
.1792 .21884 L
.17925 .20356 L
.17931 .19012 L
.17934 .18512 L
.17937 .18069 L
.1794 .17737 L
.17942 .17506 L
.17945 .17324 L
Mistroke
.17948 .17231 L
.17951 .1724 L
.17953 .17332 L
.17956 .17542 L
.17959 .17831 L
.17962 .18252 L
.17966 .18812 L
.17972 .20097 L
.17978 .21839 L
.17989 .25738 L
.18016 .36045 L
.18027 .40134 L
.18034 .41951 L
.1804 .43305 L
.18043 .43856 L
.18047 .44329 L
.18048 .44531 L
.1805 .44701 L
.18052 .44811 L
.18054 .44895 L
.18055 .44938 L
.18057 .44948 L
.18059 .44925 L
.1806 .4487 L
.18063 .44691 L
.18065 .44544 L
.18067 .4438 L
.18072 .43526 L
.18078 .424 L
.1809 .38819 L
.18115 .29032 L
.18127 .24312 L
.18133 .22094 L
.1814 .20051 L
.18146 .18473 L
.18152 .17417 L
.18155 .17045 L
.18158 .16748 L
.18161 .16569 L
.18163 .16495 L
.18166 .16504 L
.18169 .16605 L
.18171 .16786 L
.18174 .17021 L
.18177 .17383 L
.1818 .17878 L
.18185 .19037 L
.18197 .22538 L
.18208 .26692 L
.1823 .35728 L
Mistroke
.18241 .39974 L
.18247 .41909 L
.18253 .43395 L
.18259 .44634 L
.18263 .45102 L
.18264 .45304 L
.18266 .45451 L
.18269 .45621 L
.18271 .45667 L
.18272 .45678 L
.18275 .45616 L
.18278 .45438 L
.18281 .45168 L
.18284 .44768 L
.1829 .43768 L
.18296 .42146 L
.18302 .40299 L
.18326 .30653 L
.1834 .25049 L
.18352 .20515 L
.18358 .18858 L
.18364 .17459 L
.18367 .16884 L
.1837 .16387 L
.18373 .16058 L
.18376 .15861 L
.18379 .15772 L
.18382 .15783 L
.18384 .15871 L
.18387 .16051 L
.18389 .16346 L
.18392 .16769 L
.18398 .17801 L
.18404 .19234 L
.18409 .20829 L
.1842 .25218 L
.18442 .3448 L
.18453 .39326 L
.1846 .41529 L
.18466 .43497 L
.1847 .443 L
.18473 .44946 L
.18476 .45466 L
.18478 .45845 L
.18481 .46115 L
.18484 .46303 L
.18487 .4639 L
.1849 .46365 L
.18493 .46213 L
.18496 .45959 L
Mistroke
.18499 .45556 L
.18502 .44989 L
.18508 .43734 L
.18514 .41939 L
.18537 .3302 L
.18549 .27228 L
.18563 .21651 L
.18574 .17951 L
.18577 .17171 L
.18581 .16464 L
.18584 .15927 L
.18587 .15542 L
.1859 .15266 L
.18593 .15097 L
.18596 .15056 L
.18598 .1509 L
.18599 .1516 L
.18602 .15378 L
.18605 .1568 L
.18608 .16148 L
.18611 .16707 L
.18622 .19526 L
.18633 .23831 L
.1866 .35765 L
.18672 .40891 L
.18683 .44496 L
.18689 .45763 L
.18692 .46249 L
.18695 .46659 L
.18698 .46938 L
.187 .47035 L
.18702 .47085 L
.18705 .47082 L
.18708 .46953 L
.1871 .46725 L
.18713 .46369 L
.18716 .45974 L
.18719 .45445 L
.18725 .43931 L
.18731 .42123 L
.18755 .31619 L
.18769 .25326 L
.18781 .20182 L
.18787 .18229 L
.18792 .1671 L
.18795 .1602 L
.18799 .15401 L
.18802 .1496 L
.18804 .14658 L
.18807 .14443 L
Mistroke
.1881 .14359 L
.18813 .14396 L
.18815 .14476 L
.18817 .14587 L
.18818 .1474 L
.1882 .14916 L
.18823 .15433 L
.18826 .16022 L
.1883 .1678 L
.18842 .20621 L
.18853 .25405 L
.18874 .35534 L
.18886 .4087 L
.18898 .44751 L
.18903 .46162 L
.18907 .46771 L
.18909 .47204 L
.18911 .47388 L
.18913 .47545 L
.18914 .47673 L
.18916 .47751 L
.18919 .4779 L
.18921 .47754 L
.18922 .47683 L
.18925 .47477 L
.18928 .4713 L
.18931 .46689 L
.18934 .46183 L
.18944 .43386 L
.18955 .39079 L
.18967 .33536 L
.18992 .21732 L
.18998 .1906 L
.19006 .16731 L
.19012 .15222 L
.19015 .14582 L
.19017 .14331 L
.19018 .14134 L
.19021 .1385 L
.19023 .13754 L
.19025 .13691 L
.19027 .13679 L
.19031 .13803 L
.19033 .14031 L
.19036 .144 L
.19039 .14863 L
.19042 .15384 L
.19048 .1688 L
.19054 .18982 L
.19067 .24396 L
Mistroke
.19091 .36425 L
.19103 .41744 L
.19114 .45532 L
.1912 .47029 L
.19123 .47591 L
.19127 .48053 L
.19128 .48228 L
.1913 .48347 L
.19132 .48435 L
.19134 .48469 L
.19137 .48414 L
.19139 .48316 L
.1914 .48182 L
.19143 .4782 L
.19146 .47349 L
.19152 .46145 L
.19158 .44407 L
.19164 .42071 L
.19187 .31294 L
.19199 .24936 L
.19211 .19604 L
.19218 .17133 L
.19221 .16033 L
.19225 .15037 L
.19228 .14345 L
.19232 .13743 L
.19235 .13347 L
.19238 .13109 L
.19241 .13003 L
.19243 .13003 L
.19244 .13044 L
.19247 .13221 L
.1925 .13505 L
.19252 .13733 L
.19253 .13987 L
.19256 .14559 L
.19263 .16281 L
.19287 .26443 L
.19312 .39451 L
.19323 .43879 L
.19328 .45834 L
.19334 .47303 L
.19337 .47951 L
.1934 .48501 L
.19343 .48854 L
.19346 .49056 L
.19349 .49133 L
.19352 .49091 L
.19355 .48905 L
.19358 .486 L
Mistroke
.19361 .48185 L
.19363 .47694 L
.19369 .46225 L
.19375 .44354 L
.19381 .41933 L
.19402 .31357 L
.19414 .2495 L
.19427 .18954 L
.19433 .16921 L
.19438 .15103 L
.19441 .14252 L
.19444 .13604 L
.19447 .13084 L
.1945 .12715 L
.19453 .12464 L
.19456 .12347 L
.19459 .12379 L
.19462 .12528 L
.19465 .12849 L
.19467 .13098 L
.19469 .1337 L
.19475 .14758 L
.19481 .16665 L
.19488 .19291 L
.19502 .25867 L
.19527 .39327 L
.19533 .42047 L
.19539 .44588 L
.19545 .46553 L
.1955 .48006 L
.19553 .48613 L
.19555 .49061 L
.19558 .49434 L
.19561 .49687 L
.19564 .49782 L
.19566 .49774 L
.19568 .49728 L
.19571 .49519 L
.19572 .49335 L
.19574 .49126 L
.1958 .48072 L
.19583 .4727 L
.19586 .46406 L
.19597 .42169 L
.19623 .28591 L
.19635 .21888 L
.19641 .19285 L
.19647 .16791 L
.19653 .14807 L
.19658 .13374 L
Mistroke
.19661 .12823 L
.19663 .12402 L
.19666 .12038 L
.19669 .11821 L
.19672 .11708 L
.19675 .11733 L
.19677 .11871 L
.1968 .12144 L
.19683 .1258 L
.19686 .13206 L
.19692 .14731 L
.19699 .16938 L
.19706 .19885 L
.19718 .26314 L
.19742 .39334 L
.19753 .44401 L
.19759 .4665 L
.19764 .48343 L
.19768 .49086 L
.19769 .49414 L
.19771 .49715 L
.19773 .49946 L
.19774 .50116 L
.19777 .5034 L
.1978 .50418 L
.19782 .50397 L
.19784 .50337 L
.19786 .50121 L
.19789 .4975 L
.19793 .49207 L
.19795 .48577 L
.19802 .46717 L
.19813 .41997 L
.1984 .27578 L
.19851 .21343 L
.19858 .18331 L
.19864 .15884 L
.19869 .14025 L
.19874 .12692 L
.19877 .12131 L
.1988 .11665 L
.19883 .11332 L
.19886 .11123 L
.19887 .11079 L
.19889 .11082 L
.19892 .11218 L
.19895 .11513 L
.19898 .11925 L
.19901 .12519 L
.19905 .13345 L
Mistroke
.19912 .15532 L
.19924 .20985 L
.19936 .27291 L
.19948 .34217 L
.19961 .41315 L
.19967 .44129 L
.19973 .46691 L
.19979 .48619 L
.19984 .49904 L
.19987 .50382 L
.1999 .50747 L
.19993 .50943 L
.19995 .51034 L
.19998 .50986 L
.2 .50893 L
.20001 .50767 L
.20004 .5041 L
.20007 .49939 L
.20013 .48679 L
.20018 .47125 L
.20029 .42405 L
.20052 .29299 L
.20065 .22278 L
.20071 .18851 L
.20078 .16071 L
.20084 .13863 L
.20089 .123 L
.20092 .11613 L
.20095 .11108 L
.20098 .1073 L
.201 .1059 L
.20101 .10506 L
.20104 .10465 L
.20106 .10534 L
.20109 .1073 L
.20112 .11076 L
.20115 .11589 L
.20118 .12214 L
.20123 .13732 L
.20134 .18084 L
.20146 .24133 L
.20167 .36474 L
.20177 .4237 L
.20189 .47467 L
.20192 .48571 L
.20196 .49564 L
.20199 .50319 L
.20202 .50873 L
.20205 .51259 L
.20208 .51524 L
Mistroke
.20209 .51606 L
.20211 .51638 L
.20214 .51575 L
.20217 .51378 L
.2022 .51017 L
.20223 .50539 L
.20225 .49986 L
.20231 .48194 L
.20237 .45952 L
.20262 .32746 L
.20274 .25518 L
.20285 .19268 L
.20295 .14686 L
.20301 .12696 L
.20306 .11306 L
.20309 .10755 L
.20312 .10359 L
.20314 .10057 L
.20317 .09892 L
.20319 .0987 L
.20321 .09894 L
.20324 .10062 L
.20327 .10381 L
.20329 .10809 L
.20332 .11411 L
.20335 .12105 L
.20341 .14128 L
.20354 .19848 L
.20375 .32269 L
.20386 .38966 L
.20398 .45189 L
.20404 .47876 L
.2041 .49811 L
.20413 .50553 L
.20416 .51209 L
.20419 .51682 L
.20422 .51989 L
.20425 .52183 L
.20427 .5222 L
.2043 .521 L
.20432 .51959 L
.20434 .51784 L
.20437 .51302 L
.2044 .50581 L
.20447 .48773 L
.20452 .46528 L
.20458 .44097 L
.2047 .37591 L
.20491 .2442 L
.20503 .17893 L
Mistroke
.20509 .14917 L
.20515 .1264 L
.2052 .11129 L
.20523 .10471 L
.20526 .09996 L
.20529 .09614 L
.20532 .09366 L
.20535 .09293 L
.20537 .09367 L
.2054 .09591 L
.20543 .1 L
.20546 .10542 L
.20549 .11168 L
.20555 .13078 L
.20562 .15717 L
.20587 .30367 L
.2061 .44029 L
.20617 .47138 L
.20623 .49524 L
.20629 .51146 L
.20632 .51825 L
.20635 .52295 L
.20637 .5258 L
.2064 .52753 L
.20643 .52789 L
.20645 .52714 L
.20648 .52494 L
.20651 .52095 L
.20654 .51569 L
.20656 .50955 L
.20662 .49388 L
.20667 .47158 L
.20679 .41301 L
.20702 .27248 L
.20714 .19814 L
.20726 .14134 L
.20732 .1186 L
.20735 .10917 L
.20738 .10077 L
.2074 .09686 L
.20742 .09384 L
.20743 .09152 L
.20745 .08956 L
.20748 .08761 L
.2075 .08734 L
.20752 .0876 L
.20755 .08945 L
.20758 .09288 L
.2076 .09731 L
.20763 .10357 L
Mistroke
.2077 .12275 L
.20776 .14646 L
.20798 .26935 L
.20821 .41575 L
.20833 .47742 L
.2084 .50359 L
.20843 .51343 L
.20846 .521 L
.20849 .52635 L
.20852 .53049 L
.20855 .5327 L
.20858 .53342 L
.2086 .53277 L
.20863 .53032 L
.20865 .52842 L
.20867 .52587 L
.2087 .51995 L
.20876 .50254 L
.20883 .47615 L
.20897 .40409 L
.20921 .24605 L
.20933 .1745 L
.2094 .14173 L
.20946 .11654 L
.20952 .09883 L
.20955 .09152 L
.20958 .08658 L
.20961 .08378 L
.20964 .08216 L
.20967 .08211 L
.2097 .08359 L
.20973 .08688 L
.20974 .08946 L
.20976 .09225 L
.20982 .10664 L
.20985 .11725 L
.20988 .13064 L
.20995 .1595 L
.21018 .30367 L
.2103 .3769 L
.21041 .44739 L
.21047 .47614 L
.21053 .49901 L
.21058 .51547 L
.2106 .52287 L
.21063 .52857 L
.21066 .53328 L
.21069 .5368 L
.21072 .53852 L
.21073 .53874 L
Mistroke
.21075 .53847 L
.21078 .53689 L
.2108 .53355 L
.21083 .52887 L
.21086 .52323 L
.21092 .50417 L
.21098 .48103 L
.21111 .41252 L
.21137 .23983 L
.21149 .17051 L
.21155 .13962 L
.21162 .11247 L
.21165 .10204 L
.21168 .09373 L
.21171 .08717 L
.21173 .08249 L
.21176 .07932 L
.21178 .0773 L
.21181 .0767 L
.21184 .07769 L
.21187 .08055 L
.2119 .08478 L
.21193 .09117 L
.21196 .09983 L
.21202 .11864 L
.21208 .14482 L
.21234 .30276 L
.21258 .45555 L
.21264 .4847 L
.2127 .50995 L
.21273 .52056 L
.21277 .53004 L
.21278 .53344 L
.2128 .53658 L
.21283 .54084 L
.21286 .54327 L
.21288 .54383 L
.21289 .54381 L
.21292 .54244 L
.21296 .53909 L
.21299 .53393 L
.21302 .52741 L
.21307 .51108 L
.21312 .48959 L
.21318 .46198 L
.21328 .40237 L
.21352 .24617 L
.21363 .17327 L
.21374 .1185 L
.21381 .09639 L
Mistroke
.21384 .08685 L
.21387 .08004 L
.2139 .07585 L
.21393 .07288 L
.21396 .07167 L
.21399 .07229 L
.21401 .07426 L
.21404 .07793 L
.21407 .08343 L
.2141 .09004 L
.21415 .10536 L
.2142 .12631 L
.21432 .18935 L
.21443 .25946 L
.21465 .41184 L
.21471 .44742 L
.21478 .48104 L
.21484 .507 L
.21489 .52629 L
.21492 .53457 L
.21494 .5382 L
.21496 .54148 L
.21499 .54582 L
.21502 .54814 L
.21503 .54873 L
.21505 .54877 L
.21508 .5473 L
.2151 .54553 L
.21512 .54295 L
.21515 .53653 L
.21518 .52941 L
.21521 .52009 L
.21527 .4991 L
.21539 .43418 L
.21564 .26847 L
.21577 .18361 L
.21584 .14387 L
.2159 .11295 L
.21596 .09192 L
.21599 .08276 L
.21602 .07615 L
.21604 .07335 L
.21606 .07091 L
.21607 .06888 L
.21609 .06761 L
.21611 .06692 L
.21612 .06684 L
.21615 .06816 L
.21618 .07109 L
.21621 .07593 L
Mistroke
.21624 .08147 L
.21627 .089 L
.21633 .111 L
.21639 .13748 L
.2166 .27238 L
.21683 .43047 L
.21696 .49591 L
.21699 .51016 L
.21702 .52345 L
.21705 .5331 L
.21709 .5416 L
.21712 .54744 L
.21715 .55116 L
.21718 .55324 L
.21719 .55358 L
.21721 .55337 L
.21724 .55176 L
.21727 .54823 L
.2173 .54322 L
.21732 .53719 L
.21738 .51798 L
.21744 .49401 L
.21757 .42159 L
.21783 .23898 L
.21795 .16249 L
.21807 .10595 L
.21813 .08386 L
.21816 .07463 L
.21818 .0711 L
.2182 .0683 L
.21823 .0644 L
.21825 .06252 L
.21828 .06227 L
.2183 .06294 L
.21832 .06407 L
.21835 .06777 L
.21838 .07302 L
.2184 .07916 L
.21843 .08731 L
.21849 .11094 L
.21855 .13874 L
.21877 .27905 L
.21889 .36776 L
.21903 .45471 L
.21909 .48977 L
.21915 .51729 L
.21921 .5364 L
.21924 .54468 L
.21927 .55063 L
.21929 .5548 L
Mistroke
.21932 .55744 L
.21935 .55813 L
.21938 .55721 L
.2194 .5551 L
.21943 .5514 L
.21946 .54601 L
.21948 .5396 L
.21954 .5202 L
.2196 .49713 L
.21972 .42955 L
.21997 .24786 L
.22009 .17236 L
.22015 .13773 L
.22021 .10625 L
.22027 .08361 L
.2203 .0758 L
.22033 .06881 L
.22035 .06372 L
.22038 .06036 L
.2204 .05828 L
.22043 .05772 L
.22046 .05905 L
.22048 .06068 L
.2205 .06273 L
.22053 .06787 L
.22056 .07523 L
.22061 .09242 L
.22067 .11742 L
.22079 .18757 L
.22093 .28039 L
.22117 .44952 L
.22123 .48461 L
.22129 .51589 L
.22133 .52848 L
.22135 .53864 L
.22138 .54624 L
.22141 .55295 L
.22143 .55583 L
.22144 .55835 L
.22146 .56036 L
.22148 .56165 L
.22149 .56235 L
.22151 .56247 L
.22154 .56132 L
.22155 .55984 L
.22157 .55762 L
.2216 .55199 L
.22164 .54361 L
.22168 .53168 L
.22174 .50596 L
Mistroke
.2218 .47661 L
.22192 .39472 L
.22216 .2246 L
.22227 .1506 L
.22234 .11684 L
.22239 .09081 L
.22245 .07233 L
.22248 .06457 L
.22251 .0592 L
.22253 .05602 L
.22256 .05398 L
.22259 .05348 L
.22261 .05451 L
.22264 .05764 L
.22266 .0603 L
.22268 .06335 L
.22271 .071 L
.22274 .07973 L
.22279 .10093 L
.22285 .12946 L
.22311 .30237 L
.22334 .46095 L
.22345 .52029 L
.22348 .53277 L
.22351 .54409 L
.22355 .55269 L
.22357 .55885 L
.22359 .56156 L
.22361 .56381 L
.22363 .56541 L
.22365 .56642 L
.22366 .56664 L
.22368 .5662 L
.2237 .56516 L
.22371 .56367 L
.22374 .55921 L
.22376 .5558 L
.22378 .55207 L
.22384 .53326 L
.2239 .50733 L
.22395 .47838 L
.22408 .39882 L
.2243 .23237 L
.22442 .15043 L
.22448 .11712 L
.22454 .09181 L
.2246 .07041 L
.22463 .06169 L
.22466 .05553 L
.22468 .05313 L
Mistroke
.2247 .05123 L
.22473 .04949 L
.22474 .04947 L
.22476 .05005 L
.22478 .05137 L
.2248 .05358 L
.22483 .05843 L
.22486 .0658 L
.22489 .07573 L
.22492 .08694 L
.22504 .14344 L
.22526 .29537 L
.22549 .46119 L
.22555 .49493 L
.22561 .52521 L
.22564 .5394 L
.22568 .55017 L
.22571 .55878 L
.22574 .56482 L
.22577 .56843 L
.2258 .57036 L
.22583 .57036 L
.22585 .56882 L
.22588 .56514 L
.2259 .56219 L
.22592 .55893 L
.22598 .54194 L
.22604 .51691 L
.2261 .4875 L
.22623 .40356 L
.22649 .20695 L
.22661 .12991 L
.22667 .09948 L
.22672 .07683 L
.22675 .06689 L
.22679 .05805 L
.22682 .0515 L
.22684 .04892 L
.22685 .04716 L
.22688 .04563 L
.22691 .04599 L
.22694 .04833 L
.22697 .05296 L
.227 .05931 L
.22704 .06831 L
.22709 .09 L
.2272 .14703 L
.22745 .32346 L
.22756 .40612 L
.22768 .48367 L
Mistroke
.22773 .51439 L
.22779 .53827 L
.22784 .55486 L
.22786 .56206 L
.22789 .56728 L
.22792 .57126 L
.22794 .57351 L
.22797 .57431 L
.228 .5732 L
.22803 .5701 L
.22806 .56469 L
.22809 .55838 L
.22812 .54971 L
.22818 .5254 L
.22825 .49144 L
.22837 .41367 L
.22863 .2145 L
.22875 .13734 L
.22881 .10157 L
.22887 .0749 L
.2289 .06474 L
.22893 .05675 L
.22895 .05306 L
.22896 .04963 L
.22899 .04512 L
.22902 .04245 L
.22904 .04195 L
.22906 .04212 L
.22909 .04412 L
.22912 .04804 L
.22914 .05086 L
.22915 .05457 L
.22919 .06394 L
.22925 .08675 L
.22932 .12233 L
.22939 .16292 L
.22962 .3354 L
.22975 .433 L
.22987 .50776 L
.22993 .53534 L
.22999 .55829 L
.23002 .56661 L
.23004 .57007 L
.23006 .57304 L
.23007 .57506 L
.23009 .57665 L
.23012 .57782 L
.23015 .57686 L
.23018 .57406 L
.2302 .57173 L
Mistroke
.23021 .56857 L
.23024 .56122 L
.2303 .54129 L
.23036 .51669 L
.23046 .45669 L
.23058 .37555 L
.23081 .1992 L
.23087 .15791 L
.23093 .11819 L
.23099 .08884 L
.23102 .07532 L
.23105 .06441 L
.23108 .05547 L
.23111 .04789 L
.23114 .04291 L
.23117 .03998 L
.23119 .03866 L
.23122 .03886 L
.23125 .04089 L
.23127 .04445 L
.2313 .05069 L
.23134 .05988 L
.2314 .08278 L
.23146 .1121 L
.23152 .14459 L
.23177 .33738 L
.23189 .42181 L
.23199 .49144 L
.23205 .52288 L
.23211 .55018 L
.23214 .55964 L
.23217 .56788 L
.2322 .57388 L
.23222 .57778 L
.23224 .57947 L
.23226 .58062 L
.23229 .58102 L
.2323 .58032 L
.23232 .57908 L
.23234 .57706 L
.23236 .57414 L
.23239 .56694 L
.23242 .55788 L
.23248 .53526 L
.23259 .47298 L
.23272 .38472 L
.23296 .19448 L
.23308 .11634 L
.23314 .08896 L
.23319 .06492 L
Mistroke
.23322 .05589 L
.23325 .04801 L
.23328 .0417 L
.23331 .03775 L
.23333 .03635 L
.23334 .03551 L
.23338 .03579 L
.23341 .0383 L
.23343 .04255 L
.23347 .04943 L
.2335 .05787 L
.23356 .08395 L
.23363 .11772 L
.2337 .16179 L
.23394 .34795 L
.23407 .44475 L
.23414 .49068 L
.23421 .52699 L
.23427 .55405 L
.23431 .5657 L
.23434 .57397 L
.23437 .5791 L
.2344 .5827 L
.23443 .58418 L
.23446 .58346 L
.23449 .58061 L
.23452 .57599 L
.23454 .57026 L
.23457 .56238 L
.23463 .53873 L
.23469 .51008 L
.23493 .34582 L
.23505 .24737 L
.23518 .1524 L
.23529 .08663 L
.23532 .0726 L
.23536 .05978 L
.23538 .05059 L
.23542 .04269 L
.23545 .03707 L
.23548 .03382 L
.2355 .03245 L
.23553 .03287 L
.23556 .03488 L
.23558 .03814 L
.23561 .04322 L
.23563 .05042 L
.2357 .0717 L
.23575 .09803 L
.23588 .17718 L
Mistroke
.23611 .3581 L
.23622 .44048 L
.23632 .50628 L
.23637 .53517 L
.23643 .55654 L
.23645 .5657 L
.23648 .57392 L
.23651 .58022 L
.23654 .58467 L
.23657 .58684 L
.2366 .58677 L
.23662 .58593 L
.23664 .58437 L
.23665 .58204 L
.23667 .57922 L
.2367 .57243 L
.23673 .56444 L
.23679 .5405 L
.23684 .51296 L
.2369 .47695 L
.23701 .39904 L
.23728 .19015 L
.23734 .14761 L
.2374 .10814 L
.23746 .07776 L
.23752 .05559 L
.23754 .04715 L
.23757 .0399 L
.23759 .03661 L
.2376 .03408 L
.23763 .03085 L
.23766 .02963 L
.23769 .0306 L
.23771 .0319 L
.23773 .03397 L
.23774 .03683 L
.23776 .04016 L
.23782 .05664 L
.23787 .078 L
.23799 .14523 L
.23825 .34694 L
.23838 .44505 L
.23843 .48277 L
.23849 .51853 L
.23855 .54733 L
.23858 .55781 L
.23861 .5677 L
.23863 .57495 L
.23866 .58115 L
.23869 .5859 L
Mistroke
.23871 .58862 L
.23874 .58969 L
.23876 .58933 L
.23878 .58838 L
.2388 .58511 L
.23883 .57946 L
.23887 .57178 L
.23889 .56267 L
.23895 .54101 L
.23907 .46964 L
.23919 .38524 L
.23931 .28396 L
.23944 .1794 L
.23951 .13583 L
.23957 .09996 L
.23963 .07108 L
.23965 .06049 L
.23968 .05043 L
.2397 .04308 L
.23973 .03668 L
.23976 .03167 L
.23978 .02864 L
.23981 .02717 L
.23984 .02779 L
.23987 .03008 L
.2399 .03442 L
.23991 .03772 L
.23993 .04198 L
.23996 .05146 L
.24002 .07502 L
.24009 .11131 L
.24016 .15187 L
.24039 .33926 L
.24051 .42775 L
.24061 .50027 L
.24067 .53293 L
.24073 .56106 L
.24076 .57075 L
.24079 .57913 L
.24082 .58467 L
.24085 .58902 L
.24086 .59067 L
.24088 .59173 L
.24091 .59189 L
.24093 .59101 L
.24094 .58957 L
.24096 .5873 L
.24098 .58409 L
.24101 .57627 L
.24104 .56654 L
Mistroke
.2411 .54252 L
.24122 .47682 L
.24134 .38463 L
.24159 .18597 L
.24171 .10539 L
.24176 .07746 L
.24182 .05323 L
.24185 .04314 L
.24188 .03571 L
.24191 .03037 L
.24194 .02664 L
.24195 .02544 L
.24197 .02486 L
.242 .02568 L
.24203 .02882 L
.24206 .0337 L
.24209 .0414 L
.24212 .05066 L
.24219 .07876 L
.24225 .11469 L
.24232 .16104 L
.24257 .35627 L
.2427 .45622 L
.24277 .50307 L
.24284 .53961 L
.24289 .56439 L
.24293 .57522 L
.24296 .58307 L
.24299 .58904 L
.243 .59143 L
.24302 .59301 L
.24304 .59399 L
.24305 .59427 L
.24307 .59386 L
.24309 .59275 L
.24312 .58938 L
.24314 .58375 L
.24317 .5773 L
.2432 .5685 L
.24326 .54276 L
.24332 .51166 L
.24354 .354 L
.24377 .1686 L
.24383 .12203 L
.2439 .08495 L
.24396 .0583 L
.24399 .04728 L
.24402 .03747 L
.24405 .03046 L
.24408 .02593 L
Mistroke
.24411 .02329 L
.24412 .02278 L
.24414 .02293 L
.24417 .02463 L
.2442 .02857 L
.24423 .03426 L
.24425 .04117 L
.24431 .06315 L
.24437 .09074 L
.2445 .1745 L
.24476 .38704 L
.24488 .47651 L
.24499 .54316 L
.24506 .56941 L
.24509 .5805 L
.24511 .58479 L
.24513 .58822 L
.24516 .59307 L
.24518 .59555 L
.24521 .59616 L
.24523 .59556 L
.24524 .5944 L
.24527 .59045 L
.2453 .58467 L
.24533 .57784 L
.24536 .56868 L
.24542 .54197 L
.24548 .51027 L
.2457 .34888 L
.24582 .24619 L
.24595 .14475 L
.24601 .10545 L
.24608 .07103 L
.24613 .0482 L
.24616 .03819 L
.24619 .03087 L
.24622 .02568 L
.24625 .02219 L
.24628 .02095 L
.24631 .0216 L
.24633 .02365 L
.24636 .0275 L
.24638 .03328 L
.24641 .04028 L
.24647 .06174 L
.24652 .08761 L
.24664 .16422 L
.2469 .37274 L
.24702 .4689 L
.24714 .53822 L
Mistroke
.24719 .56327 L
.24722 .57389 L
.24725 .58306 L
.24728 .58933 L
.24731 .59427 L
.24733 .59696 L
.24736 .59791 L
.24739 .597 L
.24742 .59404 L
.24744 .58964 L
.24747 .58304 L
.2475 .57375 L
.24753 .56157 L
.24759 .53406 L
.24772 .45662 L
.24783 .36687 L
.24795 .26217 L
.24809 .15518 L
.24815 .11523 L
.24821 .07899 L
.24827 .05195 L
.2483 .04246 L
.24833 .03413 L
.24834 .03034 L
.24836 .02681 L
.24839 .02224 L
.24841 .0206 L
.24842 .01959 L
.24844 .01935 L
.24846 .01974 L
.24849 .02215 L
.2485 .02446 L
.24852 .02721 L
.24855 .03375 L
.24858 .04279 L
.24863 .06327 L
.24869 .09179 L
.24879 .1578 L
.24902 .34724 L
.24913 .43666 L
.24925 .51747 L
.24932 .55326 L
.24938 .57751 L
.24941 .58611 L
.24943 .58981 L
.24944 .59307 L
.24947 .59732 L
.2495 .5992 L
.24953 .59898 L
.24956 .59666 L
Mistroke
.24958 .59452 L
.2496 .59149 L
.24963 .58414 L
.24966 .57522 L
.24969 .56357 L
.24974 .53739 L
.24988 .4479 L
.25001 .34674 L
.25023 .16302 L
.25035 .08927 L
.25041 .05756 L
.25044 .04617 L
.25047 .03589 L
.25049 .0311 L
.25051 .02732 L
.25052 .02436 L
.25054 .02173 L
.25057 .01882 L
.2506 .01801 L
.25062 .0186 L
.25063 .0198 L
.25065 .02184 L
.25067 .0248 L
.2507 .03166 L
.25073 .04178 L
.25079 .06596 L
.25086 .09997 L
.25097 .17867 L
.25122 .38223 L
.25135 .4812 L
.25142 .52583 L
.25149 .55926 L
.25154 .58085 L
.25158 .58962 L
.25161 .59543 L
.25162 .59778 L
.25164 .59933 L
.25165 .60035 L
.25167 .60064 L
.25169 .60014 L
.25171 .599 L
.25174 .5951 L
.25177 .58945 L
.2518 .58142 L
.25185 .56195 L
.25191 .53415 L
.25197 .49645 L
.25223 .28991 L
.25236 .18447 L
.25248 .10214 L
Mistroke
.25253 .07152 L
.25259 .04848 L
.25261 .03844 L
.25264 .03087 L
.25267 .02433 L
.2527 .01956 L
.25273 .01717 L
.25276 .01705 L
.25279 .01922 L
.25281 .02149 L
.25282 .02419 L
.25285 .03072 L
.25288 .04004 L
.25294 .06266 L
.253 .09286 L
.25306 .12674 L
.25318 .21939 L
.25343 .42799 L
.25354 .50693 L
.2536 .53865 L
.25365 .56284 L
.2537 .58378 L
.25373 .59168 L
.25375 .59485 L
.25377 .59759 L
.25379 .60053 L
.25382 .60163 L
.25385 .60083 L
.25388 .59809 L
.25391 .59287 L
.25394 .58587 L
.25399 .5675 L
.25405 .54056 L
.25411 .5038 L
.25433 .33514 L
.25457 .14341 L
.25463 .10092 L
.2547 .06356 L
.25474 .04902 L
.25477 .03754 L
.2548 .02925 L
.25483 .02245 L
.25485 .01996 L
.25486 .01794 L
.25489 .01607 L
.25492 .01648 L
.25495 .01878 L
.25498 .02336 L
.255 .02691 L
.25501 .03083 L
Mistroke
.25508 .05341 L
.25514 .0812 L
.25519 .1122 L
.25531 .19761 L
.25557 .41673 L
.25569 .50082 L
.25575 .53724 L
.25581 .5683 L
.25584 .57905 L
.25587 .58824 L
.2559 .59431 L
.25593 .59904 L
.25595 .60164 L
.25598 .60241 L
.25601 .60123 L
.25604 .59857 L
.25607 .59324 L
.25609 .58635 L
.25612 .57667 L
.25616 .56408 L
.25627 .5023 L
.25639 .4126 L
.25651 .31657 L
.25663 .21141 L
.2567 .16024 L
.25677 .11187 L
.25683 .07607 L
.25686 .06005 L
.2569 .04531 L
.25693 .0343 L
.25696 .02634 L
.25699 .02071 L
.25702 .01692 L
.25705 .01538 L
.25708 .01596 L
.25711 .0186 L
.25713 .02277 L
.25716 .02977 L
.2572 .03989 L
.25726 .06464 L
.25737 .13014 L
.25749 .22022 L
.2577 .4005 L
.25782 .48794 L
.25793 .55243 L
.25799 .57765 L
.25803 .58824 L
.25804 .59232 L
.25806 .59557 L
.25809 .60014 L
Mistroke
.25811 .60242 L
.25814 .60288 L
.25817 .60105 L
.2582 .59744 L
.25823 .5924 L
.25825 .58505 L
.25828 .57511 L
.25835 .54855 L
.2584 .5176 L
.25861 .36005 L
.25884 .17483 L
.25895 .0978 L
.25901 .06353 L
.25907 .03908 L
.2591 .02946 L
.25912 .02521 L
.25914 .0219 L
.25916 .0176 L
.2592 .01519 L
.25921 .0149 L
.25923 .01533 L
.25926 .01796 L
.25928 .02048 L
.25929 .02345 L
.25933 .03243 L
.25936 .04174 L
.25939 .05214 L
.25945 .08154 L
.25957 .16166 L
.25982 .36874 L
.25994 .46619 L
.26 .50704 L
.26006 .53886 L
.26011 .56294 L
.26016 .58299 L
.26019 .59119 L
.26022 .5969 L
.26024 .60067 L
.26027 .60285 L
.2603 .60315 L
.26033 .60134 L
.26036 .59764 L
.26038 .59259 L
.26041 .58467 L
.26044 .5737 L
.2605 .54776 L
.26097 .19055 L
.2611 .10057 L
.26117 .06192 L
.2612 .04727 L
Mistroke
.26123 .03597 L
.26127 .02732 L
.26129 .02138 L
.26132 .01697 L
.26134 .01554 L
.26136 .01484 L
.26137 .01476 L
.26139 .01533 L
.26142 .01802 L
.26145 .0233 L
.26147 .02739 L
.26148 .0319 L
.26154 .05277 L
.26161 .08394 L
.26172 .15959 L
.26194 .33883 L
.26206 .43974 L
.26213 .48875 L
.26219 .52851 L
.26225 .55849 L
.26231 .5797 L
.26233 .58846 L
.26236 .59555 L
.2624 .60039 L
.26241 .60211 L
.26243 .60304 L
.26246 .60301 L
.26247 .60212 L
.26249 .60044 L
.26252 .59574 L
.26255 .58935 L
.26258 .57942 L
.26261 .56814 L
.26268 .53555 L
.2628 .45572 L
.26292 .36259 L
.26304 .25962 L
.26315 .16799 L
.26326 .09343 L
.26331 .06737 L
.26337 .04434 L
.26339 .03536 L
.26342 .02748 L
.26345 .02119 L
.26348 .01722 L
.26349 .01581 L
.26351 .01496 L
.26354 .0152 L
.26357 .01766 L
.2636 .02188 L
Mistroke
.26363 .02839 L
.26365 .03635 L
.26372 .06091 L
.26378 .09275 L
.26384 .13463 L
.26407 .31879 L
.26428 .48799 L
.2644 .55308 L
.26443 .56734 L
.26446 .57872 L
.26448 .5871 L
.26451 .59433 L
.26454 .59955 L
.26456 .60144 L
.26458 .60257 L
.2646 .60309 L
.26463 .60146 L
.26465 .59958 L
.26467 .59673 L
.2647 .58946 L
.26474 .57983 L
.26477 .56875 L
.26483 .53732 L
.26489 .49994 L
.26501 .41433 L
.26527 .19563 L
.26539 .10834 L
.26545 .0743 L
.26551 .04941 L
.26554 .03922 L
.26557 .03011 L
.2656 .02278 L
.26563 .01806 L
.26564 .01646 L
.26566 .0154 L
.26568 .01508 L
.26569 .0155 L
.26572 .01801 L
.26574 .02041 L
.26576 .02321 L
.26578 .02957 L
.26581 .03832 L
.26587 .05891 L
.26593 .09094 L
.26598 .12623 L
.2662 .29729 L
.26643 .4786 L
.26654 .54717 L
.26657 .56172 L
.2666 .57503 L
Mistroke
.26663 .58523 L
.26666 .59265 L
.26668 .59588 L
.2667 .59873 L
.26671 .60083 L
.26673 .60222 L
.26675 .60271 L
.26677 .60248 L
.26678 .60154 L
.2668 .60007 L
.26683 .59573 L
.26686 .58865 L
.26689 .57872 L
.26692 .56724 L
.26704 .50626 L
.26716 .4167 L
.26741 .21068 L
.26754 .11565 L
.2676 .07737 L
.26764 .05908 L
.26768 .04498 L
.26771 .03481 L
.26774 .02611 L
.26776 .02243 L
.26777 .01972 L
.26779 .01776 L
.26781 .01636 L
.26782 .0157 L
.26784 .01569 L
.26787 .01752 L
.2679 .02159 L
.26793 .02728 L
.26796 .03487 L
.26798 .04358 L
.26804 .06895 L
.26816 .14079 L
.26838 .31592 L
.2685 .4153 L
.26861 .49715 L
.26867 .53496 L
.26873 .56298 L
.26876 .57498 L
.26879 .58569 L
.26883 .5938 L
.26884 .59708 L
.26886 .5994 L
.26889 .60176 L
.26892 .60186 L
.26895 .60019 L
.26897 .59652 L
Mistroke
.269 .59032 L
.26904 .58134 L
.2691 .55926 L
.26916 .52851 L
.26922 .4879 L
.26934 .39946 L
.26948 .28371 L
.26961 .17739 L
.26973 .09514 L
.2698 .05979 L
.26983 .04633 L
.26986 .03585 L
.26989 .02827 L
.26991 .02292 L
.26994 .01883 L
.26997 .01662 L
.27 .01661 L
.27003 .01878 L
.27006 .02345 L
.27009 .02999 L
.27012 .03894 L
.27015 .05075 L
.27021 .07763 L
.27034 .16127 L
.27058 .35722 L
.27068 .43986 L
.27079 .51562 L
.27086 .54993 L
.27091 .57421 L
.27094 .58325 L
.27097 .59107 L
.271 .59643 L
.27103 .59963 L
.27106 .60116 L
.27107 .60103 L
.27109 .60019 L
.27112 .59695 L
.27115 .59191 L
.27118 .58349 L
.27121 .57356 L
.27128 .54382 L
.2714 .46798 L
.27152 .37739 L
.27173 .19986 L
.27185 .11311 L
.27191 .07888 L
.27197 .0535 L
.27202 .0345 L
.27205 .02753 L
.27208 .02196 L
Mistroke
.27211 .01855 L
.27213 .01762 L
.27214 .01739 L
.27217 .01861 L
.2722 .02177 L
.27223 .02725 L
.27226 .03538 L
.27232 .05571 L
.27238 .0853 L
.27245 .12594 L
.27267 .30406 L
.27289 .47619 L
.273 .54622 L
.27304 .56091 L
.27307 .57414 L
.2731 .58346 L
.27312 .58755 L
.27313 .59126 L
.27316 .59657 L
.27319 .59933 L
.27322 .60004 L
.27325 .59874 L
.27328 .59575 L
.2733 .59065 L
.27333 .58406 L
.27336 .57662 L
.27342 .55061 L
.27348 .51905 L
.27361 .4263 L
.27386 .22413 L
.27397 .13966 L
.27403 .1002 L
.27409 .06891 L
.27414 .04617 L
.27417 .03618 L
.2742 .02886 L
.27423 .02382 L
.27425 .0207 L
.27428 .01885 L
.27431 .01883 L
.27434 .02074 L
.27437 .02516 L
.27438 .0283 L
.2744 .03233 L
.27443 .04133 L
.27449 .06483 L
.27454 .09271 L
.27468 .18137 L
.2748 .28289 L
.27503 .46916 L
Mistroke
.27515 .54073 L
.27518 .55595 L
.27522 .56994 L
.27525 .58065 L
.27528 .58845 L
.27531 .59342 L
.27533 .59693 L
.27536 .59863 L
.27539 .59816 L
.27542 .59561 L
.27545 .5905 L
.27548 .58347 L
.27551 .57514 L
.27556 .55618 L
.27561 .52952 L
.27572 .45988 L
.27596 .26587 L
.27608 .17198 L
.27619 .09907 L
.27625 .06739 L
.27631 .04198 L
.27633 .03663 L
.27635 .03167 L
.27637 .02801 L
.27639 .0249 L
.2764 .02275 L
.27642 .02112 L
.27645 .02012 L
.27648 .02151 L
.27651 .02487 L
.27653 .02757 L
.27654 .03119 L
.27658 .03953 L
.27664 .06181 L
.27669 .08915 L
.27693 .25683 L
.27705 .35982 L
.27718 .46089 L
.27729 .53246 L
.27736 .56254 L
.27739 .57381 L
.27742 .58249 L
.27744 .58868 L
.27747 .59349 L
.2775 .59613 L
.27752 .59708 L
.27755 .5965 L
.27758 .59394 L
.27761 .58914 L
.27763 .58272 L
Mistroke
.27766 .5741 L
.27769 .5644 L
.27775 .53668 L
.27786 .46849 L
.27807 .30272 L
.27818 .21241 L
.2783 .12809 L
.27836 .09163 L
.27843 .05954 L
.27845 .04834 L
.27849 .03845 L
.27852 .03118 L
.27854 .02634 L
.27856 .0243 L
.27858 .0228 L
.27861 .02183 L
.27862 .02225 L
.27864 .02326 L
.27865 .02506 L
.27867 .0278 L
.27871 .03474 L
.27874 .04371 L
.2788 .06653 L
.27886 .09667 L
.27891 .13035 L
.27904 .22221 L
.27925 .39899 L
.27936 .4822 L
.27943 .52025 L
.27948 .54963 L
.27955 .57392 L
.27958 .58321 L
.2796 .58697 L
.27962 .59028 L
.27963 .59257 L
.27965 .59407 L
.27968 .59527 L
.27971 .59434 L
.27974 .59125 L
.27977 .58637 L
.2798 .57901 L
.27985 .56035 L
.27992 .5298 L
.27998 .49473 L
.28019 .33089 L
.28042 .14856 L
.28049 .10788 L
.28055 .07577 L
.2806 .05297 L
.28063 .04364 L
Mistroke
.28066 .03539 L
.28069 .02962 L
.28072 .02599 L
.28074 .02403 L
.28077 .02407 L
.2808 .02611 L
.28083 .02981 L
.28085 .03458 L
.28088 .0413 L
.28094 .06489 L
.281 .09395 L
.28114 .18075 L
.28138 .37409 L
.28149 .46332 L
.28156 .50503 L
.28162 .53778 L
.28167 .56029 L
.28169 .5697 L
.28172 .5782 L
.28175 .58536 L
.28178 .59004 L
.28181 .5926 L
.28184 .59319 L
.28187 .59191 L
.2819 .58832 L
.28193 .58286 L
.28195 .57612 L
.28202 .55429 L
.28208 .52273 L
.28221 .44334 L
.28234 .33755 L
.28246 .24179 L
.28258 .14721 L
.28264 .11042 L
.2827 .0777 L
.28275 .05558 L
.28278 .04568 L
.28281 .03809 L
.28283 .03446 L
.28285 .03123 L
.28288 .02741 L
.2829 .0263 L
.28291 .02595 L
.28293 .02633 L
.28295 .02747 L
.28298 .03137 L
.283 .03461 L
.28301 .03823 L
.28308 .05739 L
.28313 .08165 L
Mistroke
.28319 .11503 L
.28332 .1996 L
.28356 .39459 L
.28368 .48085 L
.28379 .54244 L
.28385 .56685 L
.28388 .57608 L
.28391 .58371 L
.28393 .58663 L
.28395 .58865 L
.28397 .59018 L
.28398 .59086 L
.28401 .59018 L
.28403 .58873 L
.28405 .5867 L
.28408 .58111 L
.28411 .57376 L
.28417 .55485 L
.28422 .52741 L
.28429 .49044 L
.28452 .31991 L
.28464 .21916 L
.28476 .1345 L
.28483 .0952 L
.28486 .07766 L
.2849 .06172 L
.28493 .05061 L
.28496 .04087 L
.285 .03439 L
.28503 .03042 L
.28506 .0285 L
.28507 .02837 L
.28509 .02886 L
.28512 .03138 L
.28515 .03558 L
.28516 .03902 L
.28518 .04286 L
.28521 .05156 L
.28527 .07798 L
.28551 .23469 L
.28577 .43623 L
.28587 .50509 L
.28593 .53562 L
.28599 .55869 L
.28602 .56894 L
.28605 .57771 L
.28608 .58345 L
.28611 .58683 L
.28614 .58834 L
.28616 .58795 L
Mistroke
.28619 .58543 L
.28622 .58105 L
.28625 .57499 L
.28628 .56777 L
.28634 .54594 L
.28639 .51796 L
.28646 .48157 L
.28667 .3219 L
.28679 .22486 L
.28692 .13365 L
.28697 .1026 L
.28703 .07468 L
.28706 .06154 L
.28709 .05147 L
.28712 .04371 L
.28715 .03743 L
.28718 .03315 L
.28721 .03121 L
.28723 .03099 L
.28724 .03147 L
.28727 .03413 L
.2873 .03881 L
.28733 .04493 L
.28736 .05359 L
.28739 .06491 L
.28746 .09466 L
.28752 .12952 L
.28766 .22794 L
.28789 .41157 L
.28795 .45716 L
.28802 .50001 L
.28808 .53314 L
.28814 .5575 L
.28817 .56657 L
.2882 .57428 L
.28822 .57754 L
.28823 .58048 L
.28826 .58406 L
.28828 .58521 L
.2883 .58564 L
.28831 .58542 L
.28833 .5845 L
.28836 .58118 L
.28838 .57835 L
.28839 .57515 L
.28845 .55969 L
.28848 .54801 L
.28851 .53528 L
.28863 .46556 L
.28885 .30375 L
Mistroke
.28896 .21513 L
.28908 .13209 L
.28915 .094 L
.28921 .06676 L
.28924 .05635 L
.28927 .04725 L
.2893 .04077 L
.28933 .03666 L
.28936 .03434 L
.28938 .03387 L
.28941 .03526 L
.28944 .03894 L
.28946 .04164 L
.28948 .04521 L
.28951 .05335 L
.28956 .07415 L
.28962 .0992 L
.28968 .13266 L
.2898 .21499 L
.29001 .38328 L
.29013 .46816 L
.29019 .50704 L
.29025 .53692 L
.2903 .55701 L
.29033 .56517 L
.29036 .57229 L
.29039 .57801 L
.29042 .58135 L
.29045 .58266 L
.29048 .58216 L
.2905 .57975 L
.29054 .57503 L
.29056 .56857 L
.29059 .56102 L
.29066 .53621 L
.29072 .50505 L
.29098 .32226 L
.29121 .14929 L
.29126 .11545 L
.29132 .08478 L
.29136 .07034 L
.29139 .05924 L
.29142 .0507 L
.29144 .04686 L
.29145 .04379 L
.29148 .03973 L
.29151 .03758 L
.29153 .03691 L
.29156 .03766 L
.29159 .04026 L
Mistroke
.29162 .04503 L
.29164 .05071 L
.29167 .05865 L
.29173 .07948 L
.29179 .10878 L
.2919 .17683 L
.29214 .36279 L
.29227 .45609 L
.29234 .49933 L
.2924 .53275 L
.29247 .55679 L
.2925 .56669 L
.29252 .57043 L
.29254 .57335 L
.29256 .57711 L
.29259 .57923 L
.29262 .57927 L
.29265 .5771 L
.29268 .57295 L
.2927 .56972 L
.29272 .56616 L
.29278 .54797 L
.29283 .52528 L
.29289 .49541 L
.29312 .33315 L
.29324 .23531 L
.29336 .15296 L
.29346 .09648 L
.29352 .07251 L
.29357 .0562 L
.2936 .04936 L
.29362 .04472 L
.29365 .04149 L
.29368 .04021 L
.29371 .04091 L
.29374 .04308 L
.29376 .04712 L
.29379 .05337 L
.29382 .06189 L
.29385 .07159 L
.29392 .09955 L
.29404 .16876 L
.29426 .33496 L
.29438 .42826 L
.2945 .50179 L
.29457 .53327 L
.2946 .54663 L
.29464 .55815 L
.29467 .56572 L
.29468 .56891 L
Mistroke
.2947 .57168 L
.29473 .57493 L
.29476 .57608 L
.29479 .57534 L
.29481 .57405 L
.29482 .57226 L
.29485 .567 L
.29487 .56308 L
.29489 .5589 L
.29494 .53972 L
.295 .51265 L
.29513 .43625 L
.29527 .33361 L
.2954 .23342 L
.29552 .14878 L
.29564 .09002 L
.29567 .07766 L
.2957 .06656 L
.29573 .05808 L
.29575 .05202 L
.29578 .0474 L
.29581 .04473 L
.29584 .04372 L
.29587 .04476 L
.2959 .04747 L
.29593 .05217 L
.29595 .05764 L
.29598 .06521 L
.29604 .08767 L
.29611 .11976 L
.29623 .19464 L
.29647 .37547 L
.29659 .46353 L
.29666 .50359 L
.29673 .53403 L
.29676 .54528 L
.29679 .55517 L
.29681 .55947 L
.29683 .56352 L
.29685 .56658 L
.29686 .56883 L
.29689 .57162 L
.29692 .57245 L
.29695 .57121 L
.29698 .56824 L
.29701 .56358 L
.29704 .55676 L
.29709 .53989 L
.29715 .51262 L
.29721 .48189 L
Mistroke
.29748 .29528 L
.29759 .20933 L
.29772 .12845 L
.29777 .09995 L
.29783 .07568 L
.29786 .06647 L
.29789 .05937 L
.29792 .05438 L
.29794 .05046 L
.29797 .04807 L
.298 .04752 L
.29802 .04807 L
.29804 .04929 L
.29807 .0531 L
.2981 .05859 L
.29813 .0663 L
.29818 .08481 L
.29824 .1116 L
.2983 .14678 L
.29842 .22329 L
.29868 .41684 L
.2988 .49123 L
.29886 .52081 L
.29893 .54574 L
.29896 .55528 L
.29898 .55947 L
.299 .56273 L
.29902 .56512 L
.29903 .56703 L
.29905 .56812 L
.29907 .5686 L
.29908 .56851 L
.2991 .56787 L
.29913 .5652 L
.29916 .56022 L
.29918 .55647 L
.29919 .55243 L
.29925 .53369 L
.29931 .51041 L
.29943 .44006 L
.29968 .25913 L
.2998 .17478 L
.29986 .13643 L
.29993 .10231 L
.29999 .07903 L
.30002 .06879 L
.30005 .06128 L
.30008 .05623 L
.30011 .05316 L
.30014 .0515 L
Mistroke
.30017 .05179 L
.3002 .05383 L
.30022 .05715 L
.30025 .06271 L
.30028 .06959 L
.30033 .08569 L
.30038 .10827 L
.3005 .1765 L
.30062 .25389 L
.30083 .41349 L
.30095 .4873 L
.30101 .5161 L
.30107 .53728 L
.3011 .54678 L
.30113 .55472 L
.30115 .55773 L
.30116 .56037 L
.30118 .56254 L
.3012 .56388 L
.30123 .56456 L
.30125 .56411 L
.30127 .56301 L
.3013 .55951 L
.30132 .55449 L
.30136 .54701 L
.30138 .53814 L
.30144 .51707 L
.30156 .45134 L
.30178 .3024 L
.30189 .21782 L
.302 .14721 L
.30207 .11448 L
.30213 .08621 L
.30216 .07649 L
.3022 .06811 L
.30223 .06212 L
.30225 .05834 L
.30228 .05601 L
.30231 .0556 L
.30234 .05705 L
.30236 .05854 L
.30237 .06074 L
.3024 .0658 L
.30243 .07306 L
.30249 .09076 L
.30255 .11722 L
.30262 .15288 L
.30274 .23163 L
.30296 .39599 L
.30309 .47583 L
Mistroke
.30316 .508 L
.30319 .5234 L
.30323 .53531 L
.30326 .5437 L
.30329 .55096 L
.30332 .5562 L
.30334 .55818 L
.30335 .55944 L
.30338 .56034 L
.30341 .55951 L
.30344 .55662 L
.30347 .55202 L
.3035 .54603 L
.30353 .53788 L
.30358 .51883 L
.3037 .45729 L
.30395 .28681 L
.30406 .20841 L
.30418 .13693 L
.30423 .11312 L
.30428 .09189 L
.30431 .08201 L
.30434 .07449 L
.30437 .06872 L
.3044 .06418 L
.30442 .06116 L
.30446 .05991 L
.30449 .06061 L
.30451 .06284 L
.30454 .06736 L
.30456 .07081 L
.30458 .07456 L
.30464 .09349 L
.3047 .11913 L
.30477 .15431 L
.30491 .24196 L
.30503 .33469 L
.30516 .41947 L
.30522 .45511 L
.30528 .48845 L
.30533 .5126 L
.30539 .53313 L
.30542 .54166 L
.30545 .54778 L
.30548 .55206 L
.30551 .55486 L
.30553 .55586 L
.30556 .5555 L
.30558 .55366 L
.30561 .55005 L
Mistroke
.30564 .54418 L
.30568 .53557 L
.30574 .5143 L
.3058 .48718 L
.30585 .45722 L
.30611 .28239 L
.30624 .19611 L
.30636 .13032 L
.30641 .10612 L
.30646 .08821 L
.30649 .08043 L
.30651 .07467 L
.30654 .06975 L
.30657 .06625 L
.3066 .06459 L
.30663 .06471 L
.30666 .06666 L
.30668 .06835 L
.30669 .07076 L
.30672 .07609 L
.30675 .08355 L
.3068 .1014 L
.30687 .12871 L
.30694 .16542 L
.30706 .24586 L
.3073 .40965 L
.30736 .44748 L
.30743 .48327 L
.30749 .50939 L
.30752 .52122 L
.30755 .53058 L
.30758 .53813 L
.3076 .54354 L
.30763 .54789 L
.30767 .55057 L
.30769 .55123 L
.30772 .5503 L
.30775 .54785 L
.30777 .54426 L
.3078 .53856 L
.30783 .53061 L
.30789 .51166 L
.30796 .48211 L
.30802 .44929 L
.30828 .2761 L
.30839 .19993 L
.30846 .16279 L
.30851 .13228 L
.30857 .10853 L
.3086 .09809 L
Mistroke
.30863 .08872 L
.30866 .08219 L
.30868 .07652 L
.30871 .07275 L
.30873 .07044 L
.30876 .06922 L
.30878 .06939 L
.3088 .0701 L
.30883 .07277 L
.30886 .07755 L
.30889 .08344 L
.30891 .09036 L
.30897 .11086 L
.30904 .13962 L
.3091 .17128 L
.30923 .25592 L
.30945 .4053 L
.30957 .47434 L
.30963 .50122 L
.30969 .52092 L
.30972 .52983 L
.30975 .53723 L
.30977 .54004 L
.30978 .5425 L
.3098 .54451 L
.30982 .54573 L
.30984 .54629 L
.30985 .54632 L
.30988 .54487 L
.30991 .54158 L
.30994 .5369 L
.30997 .52988 L
.31 .5216 L
.31006 .50197 L
.31018 .44094 L
.3104 .30173 L
.31051 .223 L
.31062 .15771 L
.31069 .12743 L
.31072 .11388 L
.31076 .1015 L
.31079 .09279 L
.31082 .08506 L
.31085 .07979 L
.31088 .0764 L
.3109 .0745 L
.31093 .07428 L
.31096 .07552 L
.31099 .07838 L
.31102 .08322 L
Mistroke
.31105 .09033 L
.31111 .10801 L
.31117 .13313 L
.31124 .16675 L
.31136 .24052 L
.31159 .39298 L
.31172 .46639 L
.31178 .49563 L
.31182 .50949 L
.31185 .52009 L
.31188 .52753 L
.31191 .53386 L
.31193 .53652 L
.31195 .53847 L
.31198 .54085 L
.31201 .54128 L
.31204 .54016 L
.31207 .53708 L
.3121 .53248 L
.31212 .52653 L
.31215 .51855 L
.31221 .50017 L
.31233 .44172 L
.31258 .28279 L
.31269 .21061 L
.31281 .14579 L
.31286 .12444 L
.31291 .10569 L
.31294 .09708 L
.31297 .09064 L
.313 .08559 L
.31302 .08215 L
.31305 .07988 L
.31308 .07933 L
.31311 .08058 L
.31314 .08318 L
.31317 .08802 L
.31321 .09537 L
.31327 .11406 L
.31334 .14152 L
.31341 .17748 L
.31354 .25471 L
.31377 .40637 L
.31384 .44458 L
.3139 .47596 L
.31396 .49949 L
.31399 .51011 L
.31402 .51851 L
.31405 .52519 L
.31408 .52995 L
Mistroke
.3141 .53366 L
.31412 .53494 L
.31414 .53578 L
.31416 .53604 L
.31419 .53503 L
.31422 .53254 L
.31425 .52831 L
.31428 .52192 L
.31431 .51293 L
.31437 .49145 L
.31449 .43582 L
.31472 .29354 L
.31493 .16579 L
.31499 .13946 L
.31504 .11869 L
.31507 .10918 L
.3151 .10051 L
.31513 .09425 L
.31516 .08976 L
.31517 .08778 L
.31519 .08618 L
.31522 .08472 L
.31524 .08465 L
.31526 .08517 L
.31527 .08609 L
.31529 .08762 L
.31532 .09167 L
.31534 .09468 L
.31535 .09786 L
.31541 .11366 L
.31547 .1378 L
.31553 .16549 L
.31567 .24252 L
.31591 .39866 L
.31603 .45896 L
.31608 .48459 L
.31615 .50598 L
.31617 .51319 L
.3162 .51955 L
.31623 .52492 L
.31626 .52835 L
.31629 .53024 L
.31631 .53067 L
.31634 .52994 L
.31636 .52795 L
.31639 .52394 L
.31642 .51862 L
.31646 .51108 L
.31649 .5011 L
.31656 .47503 L
Mistroke
.31662 .44536 L
.31686 .30305 L
.31708 .17186 L
.31713 .14678 L
.31719 .12425 L
.31723 .11373 L
.31726 .10569 L
.31729 .09952 L
.31732 .09467 L
.31735 .09154 L
.31737 .09056 L
.31738 .09015 L
.31741 .09067 L
.31744 .09277 L
.31746 .09464 L
.31747 .09715 L
.31751 .10301 L
.31754 .11121 L
.31758 .1224 L
.3177 .1747 L
.31782 .23937 L
.31807 .39404 L
.31819 .45854 L
.31825 .48342 L
.3183 .50137 L
.31833 .50816 L
.31836 .51426 L
.31838 .5188 L
.31841 .5219 L
.31843 .52407 L
.31846 .52507 L
.31849 .52459 L
.31852 .52274 L
.31855 .51912 L
.31857 .5142 L
.31863 .50121 L
.31868 .48205 L
.31875 .45575 L
.31897 .3295 L
.31921 .18649 L
.31928 .15468 L
.31935 .12769 L
.31941 .11078 L
.31945 .10392 L
.31946 .10133 L
.31948 .09938 L
.31949 .09783 L
.31951 .09664 L
.31954 .09579 L
.31957 .0965 L
Mistroke
.3196 .09877 L
.31963 .10293 L
.31966 .10841 L
.31969 .11612 L
.31973 .12632 L
.32018 .36829 L
.3203 .43596 L
.32037 .46652 L
.32043 .48963 L
.32049 .50559 L
.32053 .51197 L
.32056 .51611 L
.32059 .5183 L
.32061 .51931 L
.32064 .5188 L
.32067 .51689 L
.3207 .51305 L
.32072 .51011 L
.32074 .5069 L
.3208 .49072 L
.32086 .47079 L
.32092 .44485 L
.32118 .2961 L
.3213 .22599 L
.32141 .16861 L
.32148 .14322 L
.32151 .132 L
.32154 .12184 L
.32158 .11422 L
.32161 .10883 L
.32164 .1049 L
.32166 .1026 L
.32169 .10168 L
.32172 .10216 L
.32175 .10434 L
.32178 .1079 L
.32181 .11254 L
.32183 .11785 L
.32189 .13339 L
.32195 .15519 L
.32201 .18417 L
.32213 .24742 L
.32236 .38097 L
.32247 .43829 L
.32257 .47904 L
.32262 .49447 L
.32265 .50064 L
.32268 .50593 L
.32271 .50984 L
.32274 .5122 L
Mistroke
.32275 .51303 L
.32277 .51337 L
.3228 .51289 L
.32283 .51084 L
.32284 .50921 L
.32286 .50696 L
.32289 .50184 L
.32292 .49575 L
.32298 .47764 L
.32305 .45202 L
.32331 .3121 L
.32344 .23837 L
.32355 .17987 L
.32361 .15618 L
.32367 .13531 L
.3237 .12615 L
.32373 .11929 L
.32376 .11418 L
.32379 .11037 L
.32383 .10819 L
.32384 .10771 L
.32386 .10774 L
.32389 .10908 L
.32392 .11188 L
.32394 .11412 L
.32396 .117 L
.32399 .12345 L
.32406 .14386 L
.32412 .16515 L
.32418 .19247 L
.32429 .25055 L
.32454 .39428 L
.32465 .44714 L
.32472 .47026 L
.32477 .48734 L
.32481 .49482 L
.32482 .49807 L
.32484 .50099 L
.32486 .50303 L
.32487 .50481 L
.3249 .50679 L
.32493 .50727 L
.32495 .50686 L
.32497 .50607 L
.325 .50339 L
.32502 .49947 L
.32505 .49413 L
.32509 .48671 L
.32515 .46701 L
.32527 .41811 L
Mistroke
.32553 .27285 L
.32565 .21009 L
.32571 .18037 L
.32577 .15678 L
.32583 .13905 L
.32588 .1268 L
.32591 .12157 L
.32594 .11785 L
.32596 .11523 L
.326 .11393 L
.32603 .11424 L
.32606 .11598 L
.32607 .1176 L
.32609 .11948 L
.32612 .12507 L
.32616 .13214 L
.32619 .1417 L
.32626 .16368 L
.32638 .21927 L
.3265 .28134 L
.32662 .34978 L
.32675 .41754 L
.32681 .44377 L
.32688 .46687 L
.32693 .48224 L
.32696 .48902 L
.32699 .49402 L
.32702 .49758 L
.32705 .50004 L
.32708 .501 L
.3271 .50071 L
.32713 .49947 L
.32715 .49706 L
.32718 .49337 L
.32721 .48885 L
.32726 .47496 L
.32732 .45807 L
.32744 .40774 L
.32766 .29042 L
.32778 .22636 L
.32789 .17529 L
.32796 .15258 L
.32799 .14283 L
.32803 .13432 L
.32806 .12865 L
.32807 .12623 L
.32809 .12407 L
.32812 .12142 L
.32815 .12028 L
.32818 .12051 L
Mistroke
.3282 .12131 L
.32821 .12249 L
.32824 .1257 L
.32827 .13061 L
.32831 .1369 L
.32833 .14409 L
.32839 .16064 L
.32883 .37863 L
.32895 .4341 L
.32902 .45831 L
.32905 .46817 L
.32908 .47599 L
.32911 .48204 L
.32914 .48737 L
.32917 .49127 L
.32919 .49278 L
.32921 .49379 L
.32923 .4946 L
.32926 .49425 L
.32929 .49256 L
.32932 .48969 L
.32935 .48526 L
.32937 .48007 L
.32944 .46455 L
.32949 .44575 L
.32955 .42461 L
.3298 .29901 L
.32991 .23768 L
.33004 .18236 L
.33011 .15976 L
.33014 .14995 L
.33018 .14123 L
.33021 .13497 L
.33024 .13076 L
.33027 .12801 L
.3303 .12679 L
.33033 .12688 L
.33036 .12826 L
.33039 .13079 L
.33041 .13414 L
.33044 .13897 L
.33047 .14558 L
.33053 .16284 L
.33066 .21223 L
.33078 .27005 L
.33099 .37949 L
.3311 .42868 L
.33117 .45046 L
.33122 .46677 L
.33126 .47411 L
Mistroke
.33129 .47952 L
.33132 .484 L
.33134 .48577 L
.33135 .48698 L
.33138 .488 L
.33141 .48772 L
.33144 .48606 L
.33146 .48451 L
.33148 .48274 L
.33151 .47817 L
.33153 .47277 L
.3316 .4566 L
.33165 .43812 L
.33171 .41491 L
.33195 .30119 L
.33216 .20004 L
.33222 .17898 L
.33228 .16008 L
.33231 .15297 L
.33234 .14657 L
.33236 .14168 L
.33239 .13816 L
.33242 .13533 L
.33245 .13365 L
.33248 .13336 L
.3325 .13427 L
.33254 .13669 L
.33257 .14026 L
.3326 .14561 L
.33263 .15292 L
.33269 .16838 L
.33275 .18945 L
.33286 .23687 L
.33307 .34101 L
.33318 .39298 L
.3333 .43895 L
.33337 .45865 L
.3334 .46598 L
.33343 .47155 L
.33346 .4759 L
.33348 .47769 L
.33349 .4792 L
.33352 .48094 L
.33355 .48132 L
.33357 .48104 L
.33358 .48035 L
.3336 .4792 L
.33362 .47773 L
.33365 .47418 L
.33368 .46907 L
Mistroke
.33375 .45261 L
.33381 .43235 L
.33406 .32403 L
.33428 .21831 L
.33439 .17707 L
.33446 .15974 L
.33449 .15365 L
.33452 .14825 L
.33453 .14583 L
.33455 .14396 L
.33457 .14241 L
.33458 .14135 L
.33461 .14022 L
.33464 .14035 L
.33466 .14102 L
.33468 .14201 L
.33469 .14352 L
.33471 .14557 L
.33474 .1501 L
.33478 .15657 L
.33484 .17146 L
.3349 .19201 L
.33502 .23869 L
.33526 .35508 L
.33539 .41048 L
.33546 .43516 L
.33553 .45343 L
.33558 .46489 L
.3356 .46727 L
.33562 .46942 L
.33565 .47233 L
.33566 .47338 L
.33568 .47412 L
.33571 .47444 L
.33573 .474 L
.33574 .47315 L
.33576 .47201 L
.33578 .4704 L
.33581 .46689 L
.33584 .46183 L
.3359 .44793 L
.33596 .43101 L
.33601 .4121 L
.33623 .31675 L
.33646 .2138 L
.33652 .18968 L
.33659 .17133 L
.33665 .15897 L
.33668 .15386 L
.33671 .1504 L
Mistroke
.33674 .14824 L
.33676 .1472 L
.33679 .14715 L
.33682 .14835 L
.33684 .14944 L
.33685 .151 L
.33689 .1548 L
.33691 .15966 L
.33694 .16516 L
.33706 .19836 L
.33719 .24943 L
.33745 .36881 L
.33757 .41573 L
.33763 .4354 L
.33767 .44435 L
.3377 .45144 L
.33773 .45707 L
.33776 .46116 L
.33779 .46453 L
.33781 .46585 L
.33782 .46674 L
.33785 .46747 L
.33788 .46722 L
.3379 .46593 L
.33793 .4634 L
.33796 .4598 L
.33799 .45465 L
.33805 .44213 L
.33816 .40893 L
.33841 .30529 L
.33851 .25658 L
.33863 .21029 L
.33869 .19267 L
.33874 .17729 L
.33879 .16704 L
.33882 .16253 L
.33885 .15914 L
.33887 .15631 L
.3389 .15473 L
.33893 .15408 L
.33896 .15463 L
.33899 .15616 L
.33902 .15886 L
.33904 .162 L
.33907 .16636 L
.33913 .17951 L
.3392 .19829 L
.33932 .24207 L
.33958 .35594 L
.33971 .40525 L
Mistroke
.33976 .42288 L
.33982 .43854 L
.33986 .44521 L
.33988 .45031 L
.33991 .45424 L
.33994 .45736 L
.33997 .45947 L
.34 .46033 L
.34003 .46005 L
.34005 .45933 L
.34007 .45832 L
.34008 .45696 L
.3401 .45514 L
.34013 .45094 L
.34017 .4451 L
.3402 .43714 L
.34033 .39879 L
.34058 .29494 L
.34069 .24878 L
.34081 .20578 L
.34087 .18971 L
.3409 .18226 L
.34093 .17621 L
.34096 .17144 L
.34099 .16728 L
.34102 .16443 L
.34104 .1626 L
.34107 .16145 L
.3411 .1613 L
.34113 .16217 L
.34116 .16429 L
.34117 .1658 L
.34119 .1678 L
.34122 .17232 L
.34128 .18381 L
.34135 .2011 L
.34141 .22017 L
.34154 .27148 L
.34178 .3714 L
.3419 .41166 L
.34196 .42756 L
.34199 .43511 L
.34202 .44089 L
.34205 .44501 L
.34208 .44855 L
.34211 .45121 L
.34214 .45269 L
.34216 .45315 L
.34219 .45266 L
.34222 .45145 L
Mistroke
.34224 .44928 L
.34226 .44759 L
.34228 .44541 L
.34231 .44054 L
.34237 .42844 L
.34244 .40985 L
.3425 .38893 L
.34275 .29296 L
.34287 .24502 L
.34293 .22277 L
.343 .2026 L
.34306 .18836 L
.34309 .18227 L
.34312 .17692 L
.34315 .17315 L
.34318 .17067 L
.34321 .16913 L
.34324 .16856 L
.34326 .16882 L
.34329 .17001 L
.34332 .17226 L
.34335 .1753 L
.3434 .18286 L
.34345 .19392 L
.34357 .2288 L
.34368 .26948 L
.3439 .35665 L
.34403 .39819 L
.34408 .41478 L
.34414 .42725 L
.34417 .43296 L
.3442 .43808 L
.34424 .44194 L
.34426 .4435 L
.34427 .44459 L
.3443 .44567 L
.34433 .44569 L
.34435 .4453 L
.34437 .44455 L
.3444 .44235 L
.34443 .43899 L
.34446 .43499 L
.34452 .42293 L
.34458 .40824 L
.34464 .39173 L
.34485 .31347 L
.34508 .22958 L
.34515 .21015 L
.34521 .19533 L
.34527 .18539 L
Mistroke
.3453 .18129 L
.34533 .17853 L
.34536 .17684 L
.34538 .17606 L
.34541 .17609 L
.34544 .17716 L
.34547 .17927 L
.34549 .18072 L
.34551 .1826 L
.34556 .1913 L
.34563 .20457 L
.34568 .21963 L
.34581 .26151 L
.34604 .34824 L
.34617 .3899 L
.34623 .40775 L
.34627 .41599 L
.3463 .42261 L
.34634 .42787 L
.34636 .43177 L
.3464 .43505 L
.34641 .43639 L
.34643 .43733 L
.34646 .43823 L
.34649 .43823 L
.34652 .43729 L
.34655 .43524 L
.34658 .43262 L
.34661 .42887 L
.34667 .41861 L
.34672 .40613 L
.34677 .39225 L
.34702 .30895 L
.34723 .23601 L
.34728 .21985 L
.34735 .20554 L
.3474 .19593 L
.34743 .19166 L
.34745 .18841 L
.34747 .18694 L
.34749 .18563 L
.34752 .18408 L
.34753 .18362 L
.34755 .18347 L
.34757 .18365 L
.34758 .18408 L
.34762 .18565 L
.34763 .18696 L
.34765 .18842 L
.34771 .19618 L
Mistroke
.34776 .20643 L
.34782 .22068 L
.34795 .25715 L
.34817 .33802 L
.34829 .37497 L
.34839 .40275 L
.34845 .41435 L
.34851 .42345 L
.34854 .42677 L
.34857 .42899 L
.34859 .42986 L
.3486 .4304 L
.34862 .43072 L
.34864 .43073 L
.34866 .43013 L
.34869 .42867 L
.34872 .42654 L
.34874 .42398 L
.3488 .41526 L
.34886 .40407 L
.34899 .37082 L
.3491 .33303 L
.34923 .28923 L
.34936 .24564 L
.34943 .22857 L
.34948 .21487 L
.34954 .20499 L
.34957 .20047 L
.3496 .19711 L
.34962 .19443 L
.34965 .19261 L
.34968 .19146 L
.34971 .1911 L
.34974 .19153 L
.34976 .19276 L
.34979 .19442 L
.34981 .19688 L
.34985 .20094 L
.34988 .20571 L
.34994 .21693 L
.35007 .25127 L
.35031 .32971 L
.35043 .3673 L
.35054 .39597 L
.3506 .40695 L
.35066 .41577 L
.35069 .41914 L
.35071 .42045 L
.35073 .42158 L
.35074 .42231 L
Mistroke
.35076 .42282 L
.35079 .42308 L
.35082 .42248 L
.35085 .42116 L
.35088 .41889 L
.35091 .41557 L
.35096 .40794 L
.35102 .39681 L
.35113 .36988 L
.35123 .33934 L
.35135 .30039 L
.35148 .25967 L
.35154 .24318 L
.35161 .22792 L
.35166 .21699 L
.35169 .2122 L
.35172 .2079 L
.35175 .20474 L
.35178 .20203 L
.3518 .20028 L
.35183 .19925 L
.35186 .19881 L
.35188 .19897 L
.35191 .19979 L
.35193 .2012 L
.35196 .20345 L
.35199 .20661 L
.35204 .21421 L
.3521 .22495 L
.35217 .23948 L
.35242 .31609 L
.35255 .35472 L
.35267 .38478 L
.35273 .39581 L
.35278 .40412 L
.35281 .40778 L
.35284 .41095 L
.35287 .41309 L
.35289 .41444 L
.35292 .41523 L
.35295 .41528 L
.35298 .41458 L
.35301 .41296 L
.35303 .41181 L
.35304 .4103 L
.35307 .40691 L
.35313 .39839 L
.35358 .27993 L
.3537 .24738 L
.35376 .23323 L
Mistroke
.35383 .22123 L
.35389 .21347 L
.35392 .21033 L
.35395 .20826 L
.35398 .20708 L
.35401 .20663 L
.35404 .20684 L
.35407 .20776 L
.35409 .20931 L
.35412 .21175 L
.35416 .21509 L
.35418 .21893 L
.35429 .23863 L
.35441 .26789 L
.35454 .30437 L
.35467 .34086 L
.3548 .37449 L
.35487 .38738 L
.35493 .39684 L
.35496 .40008 L
.35499 .40288 L
.35502 .40521 L
.35505 .40664 L
.35508 .40739 L
.35511 .40741 L
.35514 .40668 L
.35516 .4054 L
.35519 .40316 L
.35523 .39983 L
.35529 .39156 L
.35536 .37965 L
.35543 .36416 L
.35556 .3312 L
.35579 .26752 L
.35585 .25167 L
.35592 .23868 L
.35598 .22901 L
.35601 .22468 L
.35604 .22126 L
.35607 .21858 L
.3561 .21642 L
.35613 .21515 L
.35615 .21457 L
.35618 .21454 L
.35621 .21508 L
.35624 .21629 L
.35626 .218 L
.35629 .22074 L
.35632 .22403 L
.35638 .2319 L
Mistroke
.35651 .25663 L
.35672 .31021 L
.35683 .33943 L
.35695 .36705 L
.35701 .37875 L
.35707 .38742 L
.35712 .39364 L
.35715 .39596 L
.35718 .39785 L
.3572 .3986 L
.35721 .39911 L
.35724 .39956 L
.35727 .39931 L
.35729 .39883 L
.35731 .39817 L
.35733 .39661 L
.35736 .39426 L
.35743 .38753 L
.35748 .37894 L
.35754 .3694 L
.35765 .34332 L
.35787 .28904 L
.35798 .26213 L
.35805 .24951 L
.3581 .23952 L
.35816 .23208 L
.35819 .22898 L
.35822 .22634 L
.35825 .22463 L
.35827 .22332 L
.3583 .22264 L
.35832 .22245 L
.35836 .22284 L
.35837 .22337 L
.35839 .22405 L
.35842 .2258 L
.35845 .22833 L
.3585 .23429 L
.35856 .243 L
.3587 .26877 L
.35882 .29815 L
.35906 .35367 L
.35918 .37478 L
.35921 .37925 L
.35925 .3833 L
.35928 .3864 L
.35931 .38863 L
.35934 .39015 L
.35937 .39117 L
.3594 .39157 L
Mistroke
.35941 .39152 L
.35943 .3913 L
.35946 .39045 L
.35948 .38919 L
.35951 .38716 L
.35954 .38469 L
.35959 .37879 L
.35964 .37189 L
.35975 .35197 L
.35997 .30333 L
.36008 .2778 L
.3602 .25487 L
.36026 .24525 L
.3603 .24105 L
.36033 .23729 L
.36037 .23453 L
.3604 .23263 L
.36043 .23132 L
.36046 .23063 L
.36048 .2305 L
.36052 .23097 L
.36054 .23186 L
.36057 .23337 L
.3606 .23558 L
.36063 .23862 L
.3607 .24575 L
.36117 .34071 L
.3613 .36362 L
.36137 .37311 L
.36141 .37659 L
.36144 .3792 L
.36147 .38112 L
.3615 .38254 L
.36153 .38334 L
.36155 .38351 L
.36157 .38348 L
.3616 .38297 L
.36162 .382 L
.36164 .38126 L
.36166 .38029 L
.36169 .3781 L
.36174 .37235 L
.3618 .36529 L
.36193 .34425 L
.36218 .29176 L
.36229 .27121 L
.3624 .25382 L
.36246 .24707 L
.36249 .24425 L
.36253 .24185 L
Mistroke
.36256 .24021 L
.36259 .2392 L
.36261 .23867 L
.36264 .2386 L
.36267 .23897 L
.3627 .23989 L
.36273 .24123 L
.36275 .24284 L
.36281 .24831 L
.36287 .25534 L
.36299 .2737 L
.36312 .29805 L
.36323 .31987 L
.36335 .34184 L
.3634 .35068 L
.36346 .3588 L
.36351 .36467 L
.36356 .36962 L
.3636 .3719 L
.36363 .37349 L
.36366 .3746 L
.36368 .37522 L
.3637 .37537 L
.36372 .37538 L
.36375 .375 L
.36376 .37458 L
.36378 .37404 L
.36381 .37232 L
.36384 .37041 L
.36387 .3682 L
.36392 .36304 L
.36404 .34728 L
.36428 .30365 L
.36442 .27992 L
.36448 .26981 L
.36454 .26183 L
.3646 .2557 L
.36463 .25305 L
.36466 .2507 L
.36469 .24888 L
.36472 .24767 L
.36474 .24719 L
.36476 .24689 L
.36479 .24673 L
.36482 .24703 L
.36485 .24776 L
.36487 .24874 L
.3649 .25018 L
.36496 .25467 L
.36502 .26041 L
Mistroke
.36513 .27509 L
.36523 .29149 L
.36546 .33089 L
.36557 .34752 L
.36564 .35487 L
.36569 .36038 L
.36572 .36237 L
.36575 .36411 L
.36578 .36559 L
.36581 .36653 L
.36583 .36704 L
.36586 .36722 L
.36589 .36708 L
.36591 .36656 L
.36593 .36609 L
.36595 .36545 L
.36598 .36396 L
.36601 .36163 L
.36605 .35901 L
.36617 .34509 L
.36641 .3086 L
.36664 .27495 L
.36669 .26862 L
.36675 .26303 L
.36678 .26044 L
.36681 .2585 L
.36684 .25696 L
.36687 .25589 L
.36691 .25518 L
.36692 .25499 L
.36694 .25492 L
.36697 .25514 L
.367 .25575 L
.36702 .25626 L
.36703 .25694 L
.36706 .25848 L
.3671 .2606 L
.36713 .26343 L
.36726 .27651 L
.36737 .29226 L
.3675 .31053 L
.36763 .32968 L
.36774 .34386 L
.3678 .34951 L
.36784 .35221 L
.36787 .3543 L
.36789 .35587 L
.36792 .35723 L
.36794 .35781 L
.36796 .35825 L
Mistroke
.36799 .35882 L
.36801 .359 L
.36804 .35886 L
.36807 .35835 L
.3681 .35753 L
.36812 .35648 L
.36815 .35508 L
.3682 .35186 L
.36831 .34158 L
.36856 .30959 L
.36868 .29316 L
.36879 .27995 L
.36889 .27076 L
.36894 .2674 L
.36897 .26591 L
.369 .2648 L
.36903 .26392 L
.36906 .2634 L
.36908 .26318 L
.36911 .26323 L
.36914 .2636 L
.36917 .26436 L
.3692 .26542 L
.36923 .26666 L
.36929 .27037 L
.36934 .2748 L
.36947 .28774 L
.3697 .3162 L
.36982 .33095 L
.36994 .34183 L
.37 .34582 L
.37003 .34757 L
.37006 .34884 L
.37008 .34938 L
.3701 .34986 L
.37012 .35027 L
.37013 .35053 L
.37017 .35073 L
.37018 .35069 L
.3702 .35055 L
.37023 .35009 L
.37026 .3493 L
.37029 .34827 L
.37031 .3471 L
.37038 .34336 L
.37044 .3388 L
.37068 .31281 L
.3709 .28961 L
.37095 .28435 L
.37102 .27955 L
Mistroke
.37108 .27596 L
.37113 .27355 L
.37116 .2726 L
.37119 .27197 L
.37122 .27156 L
.37123 .27146 L
.37125 .27145 L
.37128 .27162 L
.37131 .27208 L
.37134 .27279 L
.37136 .27366 L
.37142 .27624 L
.37148 .28008 L
.37161 .29044 L
.37184 .31343 L
.37195 .32425 L
.37205 .33261 L
.37211 .33628 L
.37217 .3393 L
.3722 .34048 L
.37223 .34134 L
.37225 .34172 L
.37226 .342 L
.37228 .34223 L
.3723 .34238 L
.37233 .34244 L
.37235 .34227 L
.37238 .3419 L
.37241 .3414 L
.37243 .34059 L
.37247 .33947 L
.37252 .33683 L
.37265 .32843 L
.37278 .31701 L
.37291 .30553 L
.37303 .29572 L
.37308 .29153 L
.37314 .28756 L
.37319 .28472 L
.37325 .28228 L
.37328 .28129 L
.37331 .28057 L
.37335 .28006 L
.37336 .27988 L
.37338 .27978 L
.37341 .27977 L
.37344 .27996 L
.37347 .2804 L
.3735 .28101 L
.37352 .28178 L
Mistroke
.37355 .2828 L
.37361 .28513 L
.37371 .29093 L
.37394 .30802 L
.37406 .31716 L
.37418 .32556 L
.37425 .32876 L
.3743 .33116 L
.37436 .33273 L
.37439 .33337 L
.37441 .33378 L
.37445 .33406 L
.37447 .33412 L
.3745 .33402 L
.37453 .33374 L
.37456 .33324 L
.37459 .33249 L
.37465 .33063 L
.37472 .32789 L
.37478 .32477 L
.37492 .31625 L
.37504 .30817 L
.37517 .2999 L
.37523 .2966 L
.37529 .29359 L
.37535 .29147 L
.37538 .29054 L
.37541 .28973 L
.37544 .28913 L
.37547 .28863 L
.37549 .28831 L
.37552 .28814 L
.37554 .28807 L
.37557 .28812 L
.37559 .2883 L
.37562 .28859 L
.37565 .28904 L
.37568 .28966 L
.37573 .29112 L
.37579 .29315 L
.37585 .29584 L
.37609 .30847 L
.37621 .31472 L
.37632 .31967 L
.37639 .32205 L
.37645 .32374 L
.37648 .32448 L
.37651 .32503 L
.37653 .32526 L
.37655 .32546 L
Mistroke
.37657 .32562 L
.37658 .32572 L
.37661 .32579 L
.37664 .32574 L
.37667 .32557 L
.3767 .32531 L
.37673 .32489 L
.37676 .32429 L
.37682 .32286 L
.37705 .31474 L
.37729 .30457 L
.37736 .30202 L
.37743 .29997 L
.37749 .29849 L
.37752 .29781 L
.37756 .29731 L
.37759 .29691 L
.37762 .29664 L
.37764 .29653 L
.37765 .29646 L
.37767 .29642 L
.37769 .2964 L
.37771 .29645 L
.37774 .29658 L
.37777 .29682 L
.37781 .29717 L
.37787 .29814 L
.37793 .29934 L
.37806 .30283 L
.3783 .31023 L
.37841 .31328 L
.37852 .3155 L
.37857 .31632 L
.3786 .31666 L
.37863 .31696 L
.37866 .31721 L
.37868 .31731 L
.37869 .31738 L
.37872 .31746 L
.37875 .31749 L
.37878 .31744 L
.3788 .31739 L
.37881 .31732 L
.37884 .31713 L
.37888 .31685 L
.37894 .31617 L
.379 .31538 L
.37926 .31041 L
.37938 .30821 L
.37944 .3072 L
Mistroke
.37951 .30629 L
.37958 .30559 L
.37963 .30511 L
.37966 .30495 L
.37969 .3048 L
.37972 .30471 L
.37975 .30466 L
.37978 .30464 L
.37981 .30466 L
.37983 .3047 L
.37986 .30478 L
.37989 .3049 L
.37992 .30506 L
.37998 .30543 L
.3802 .30731 L
.38031 .3083 L
.38037 .30875 L
.38044 .30915 L
.38047 .30932 L
.38051 .30948 L
.38054 .30959 L
.38057 .30967 L
.38059 .3097 L
.3806 .30973 L
.38063 .30976 L
.38066 .30976 L
.38068 .30976 L
.3807 .30975 L
.38073 .30971 L
.38076 .30966 L
.38081 .30953 L
.38093 .3091 L
.38104 .3087 L
.38109 .30852 L
.38115 .30838 L
.38118 .30833 L
.38121 .30829 L
.38122 .30828 L
.38124 .30827 L
.38127 .30828 L
.3813 .3083 L
.38133 .30834 L
.38135 .30841 L
.38139 .30851 L
.38145 .30881 L
.38152 .30921 L
.38164 .31017 L
.38188 .31226 L
.38193 .31268 L
.38199 .31304 L
Mistroke
.38203 .3132 L
.38206 .3133 L
.38208 .31334 L
.38209 .31337 L
.38212 .3134 L
.38215 .31338 L
.38218 .31333 L
.38221 .31325 L
.38224 .31313 L
.38227 .31296 L
.3823 .31273 L
.38235 .31221 L
.38246 .31091 L
.38257 .30905 L
.38281 .30439 L
.38287 .30336 L
.38293 .3024 L
.38298 .30165 L
.38304 .3011 L
.38306 .30088 L
.3831 .3007 L
.38311 .30063 L
.38313 .30058 L
.38316 .30055 L
.38318 .30056 L
.3832 .3006 L
.38323 .30072 L
.38325 .30083 L
.38326 .30097 L
.3833 .30129 L
.38336 .30207 L
.38341 .30303 L
.38354 .30592 L
.38376 .31244 L
.38388 .31606 L
.38399 .31894 L
.38405 .32018 L
.38409 .32073 L
.38412 .32113 L
.38415 .3214 L
.38418 .32156 L
.3842 .32161 L
.38421 .32163 L
.38425 .3216 L
.38427 .32147 L
.38429 .32136 L
.38431 .32123 L
.38434 .32088 L
.38437 .32039 L
.38443 .3192 L
Mistroke
.38448 .3178 L
.38473 .30887 L
.38486 .30316 L
.38498 .29826 L
.38509 .29497 L
.38512 .29426 L
.38515 .29362 L
.38518 .29313 L
.3852 .29277 L
.38523 .29248 L
.38526 .29229 L
.38529 .29224 L
.38532 .2923 L
.38535 .2925 L
.38538 .29282 L
.38541 .2933 L
.38544 .29398 L
.3855 .29548 L
.38555 .29722 L
.38567 .30225 L
.38588 .31357 L
.386 .31986 L
.38606 .32281 L
.38613 .32551 L
.38619 .32741 L
.38622 .32822 L
.38625 .32893 L
.38628 .32943 L
.38631 .32974 L
.38634 .32991 L
.38637 .32996 L
.3864 .32985 L
.38641 .32972 L
.38643 .32956 L
.38646 .32915 L
.38649 .32856 L
.38654 .32716 L
.38659 .32511 L
.38672 .3189 L
.38684 .31157 L
.38705 .29761 L
.38716 .29127 L
.38722 .28847 L
.38728 .28638 L
.38731 .28546 L
.38733 .28506 L
.38735 .2847 L
.38736 .28444 L
.38738 .28422 L
.38741 .28397 L
Mistroke
.38744 .28391 L
.38746 .28396 L
.38747 .28406 L
.3875 .2844 L
.38753 .28489 L
.38756 .28557 L
.38759 .28647 L
.38764 .28856 L
.38777 .29526 L
.388 .31255 L
.38821 .32822 L
.38827 .33153 L
.38832 .33409 L
.38838 .33617 L
.38841 .33699 L
.38844 .33765 L
.38847 .33809 L
.38849 .33822 L
.3885 .33828 L
.38853 .33821 L
.38857 .33789 L
.38859 .33739 L
.38862 .33675 L
.38865 .33584 L
.38868 .33464 L
.38874 .33191 L
.3888 .32819 L
.38891 .31977 L
.38912 .30103 L
.38925 .2901 L
.38931 .2855 L
.38937 .28191 L
.38942 .27927 L
.38945 .27818 L
.38948 .27722 L
.38951 .27647 L
.38953 .27597 L
.38955 .27577 L
.38956 .27565 L
.38959 .27561 L
.38962 .2758 L
.38964 .27602 L
.38966 .2763 L
.38969 .27706 L
.38972 .27818 L
.38978 .28098 L
.38984 .28435 L
.38997 .2952 L
.3901 .30783 L
.39033 .33064 L
Mistroke
.39039 .33603 L
.39046 .34025 L
.39051 .34321 L
.39054 .34449 L
.39057 .3454 L
.3906 .346 L
.39063 .34641 L
.39065 .34658 L
.39068 .34655 L
.3907 .34629 L
.39073 .34572 L
.39076 .34493 L
.39079 .34397 L
.39084 .34143 L
.3909 .33772 L
.39102 .3277 L
.39124 .30268 L
.39137 .289 L
.39148 .27827 L
.39154 .27387 L
.39161 .27031 L
.39162 .26957 L
.39164 .26888 L
.39166 .26837 L
.39168 .26794 L
.39169 .26764 L
.39171 .26742 L
.39174 .2673 L
.39177 .26753 L
.3918 .26804 L
.39182 .26845 L
.39183 .26899 L
.39187 .27024 L
.39193 .27355 L
.39198 .27764 L
.39243 .33004 L
.39256 .34288 L
.39262 .34786 L
.39266 .35016 L
.39269 .35189 L
.39272 .35314 L
.39275 .35402 L
.39278 .35461 L
.39279 .3548 L
.39281 .35487 L
.39284 .35477 L
.39286 .35436 L
.39289 .35358 L
.39292 .35254 L
.39295 .35109 L
Mistroke
.39299 .34913 L
.39305 .34403 L
.39317 .33166 L
.39344 .29571 L
.39356 .28016 L
.39363 .27292 L
.39369 .26728 L
.39375 .26323 L
.39378 .26152 L
.39381 .26033 L
.39384 .25962 L
.39387 .25916 L
.39389 .25904 L
.39392 .25927 L
.39395 .25989 L
.39397 .26034 L
.39398 .26096 L
.39404 .26397 L
.39407 .26623 L
.39411 .26912 L
.39417 .27542 L
.39441 .30772 L
.39452 .32451 L
.39464 .34092 L
.3947 .34771 L
.39475 .35316 L
.3948 .35718 L
.39486 .36037 L
.39488 .36155 L
.39491 .36247 L
.39494 .36296 L
.39497 .36311 L
.395 .3629 L
.39502 .36235 L
.39506 .36128 L
.39509 .35984 L
.39512 .358 L
.39515 .35561 L
.39521 .35028 L
.39534 .33394 L
.3956 .29209 L
.39572 .27492 L
.39578 .26667 L
.39584 .2603 L
.3959 .25566 L
.39593 .25371 L
.39596 .25235 L
.396 .25138 L
.39601 .25104 L
.39603 .25086 L
Mistroke
.39606 .25088 L
.39607 .25106 L
.39609 .25138 L
.39611 .25186 L
.39613 .2525 L
.39616 .25404 L
.39619 .25623 L
.39623 .25923 L
.3963 .26612 L
.39636 .27406 L
.39659 .31198 L
.39671 .33303 L
.39684 .35228 L
.39691 .35964 L
.39694 .36289 L
.39697 .36583 L
.39701 .368 L
.39704 .36952 L
.39707 .37058 L
.3971 .37116 L
.39712 .37131 L
.39716 .37098 L
.39718 .37022 L
.39721 .36916 L
.39724 .36744 L
.39727 .36506 L
.39733 .35938 L
.39745 .34455 L
.39757 .32453 L
.39778 .28505 L
.3979 .26593 L
.39796 .25816 L
.39801 .25221 L
.39807 .24703 L
.3981 .24508 L
.39812 .2443 L
.39814 .24362 L
.39817 .2429 L
.3982 .24264 L
.39823 .2429 L
.39825 .24357 L
.39828 .24466 L
.39831 .24626 L
.39836 .25027 L
.39842 .25683 L
.39848 .26429 L
.3987 .30232 L
.39892 .34554 L
.39903 .36292 L
.3991 .37037 L
Mistroke
.39913 .37304 L
.39916 .37544 L
.39917 .37655 L
.39919 .37742 L
.39921 .3781 L
.39922 .37869 L
.39925 .37932 L
.39928 .37944 L
.3993 .37925 L
.39932 .37892 L
.39933 .37838 L
.39935 .37762 L
.39938 .37588 L
.39942 .37333 L
.39948 .3673 L
.39954 .35884 L
.39966 .33928 L
.3999 .28872 L
.40003 .26407 L
.4001 .25294 L
.40017 .24462 L
.40023 .23927 L
.40026 .23712 L
.40029 .2357 L
.40031 .23514 L
.40032 .23478 L
.40034 .23456 L
.40036 .23453 L
.40037 .2347 L
.40039 .23503 L
.40042 .2361 L
.40045 .23761 L
.40048 .23974 L
.40053 .24486 L
.40059 .25215 L
.40065 .26202 L
.40091 .31603 L
.40104 .34369 L
.40116 .36534 L
.40122 .37337 L
.40127 .37942 L
.4013 .38204 L
.40132 .38402 L
.40135 .38571 L
.40138 .38692 L
.40141 .38749 L
.40144 .3875 L
.40147 .38696 L
.4015 .38573 L
.40152 .38485 L
Mistroke
.40154 .38372 L
.40157 .38117 L
.40163 .37477 L
.40168 .36648 L
.40174 .3572 L
.40186 .33177 L
.40211 .27431 L
.40222 .25251 L
.40228 .24373 L
.40233 .23704 L
.40239 .23127 L
.40242 .22911 L
.40243 .22817 L
.40245 .2275 L
.40248 .22671 L
.40251 .22646 L
.40254 .22678 L
.40256 .22757 L
.40259 .22909 L
.40262 .23112 L
.40267 .23642 L
.40273 .24416 L
.4028 .25471 L
.40301 .30325 L
.40325 .3587 L
.40332 .37102 L
.40339 .38187 L
.40342 .38609 L
.40345 .38942 L
.40348 .39182 L
.40351 .39378 L
.40353 .39449 L
.40354 .39506 L
.40357 .39556 L
.4036 .3954 L
.40363 .39469 L
.40366 .39329 L
.40368 .39222 L
.40369 .39104 L
.40376 .38425 L
.40382 .37593 L
.40387 .36663 L
.40399 .34096 L
.40425 .27482 L
.40437 .2493 L
.40443 .23822 L
.40449 .22876 L
.40452 .2255 L
.40455 .22272 L
.40458 .22088 L
Mistroke
.40461 .21945 L
.40464 .21868 L
.40466 .21847 L
.40469 .21886 L
.40472 .2197 L
.40475 .22137 L
.40477 .22353 L
.4048 .22655 L
.40484 .23049 L
.40495 .2498 L
.40507 .27789 L
.40519 .3081 L
.40531 .3413 L
.40538 .3575 L
.40545 .37287 L
.40552 .38529 L
.40558 .39401 L
.40561 .39727 L
.40564 .40005 L
.40567 .40194 L
.4057 .40304 L
.40573 .40353 L
.40576 .40339 L
.40578 .40259 L
.40582 .40097 L
.40583 .39987 L
.40585 .39845 L
.40588 .39531 L
.40594 .38753 L
.40605 .36624 L
.40617 .33684 L
.40638 .27761 L
.40649 .25005 L
.40661 .2274 L
.40667 .21901 L
.4067 .21548 L
.40672 .21411 L
.40674 .21302 L
.40677 .21149 L
.40679 .21072 L
.40682 .21056 L
.40685 .21117 L
.40688 .21237 L
.40691 .21406 L
.40693 .21652 L
.40696 .21985 L
.40702 .22879 L
.40708 .23923 L
.40729 .29272 L
.40751 .35603 L
Mistroke
.40763 .38256 L
.40769 .39442 L
.40775 .40293 L
.40778 .40628 L
.4078 .40777 L
.40781 .40893 L
.40784 .41045 L
.40787 .41131 L
.40789 .41143 L
.40791 .41129 L
.40794 .41041 L
.40796 .40955 L
.40797 .40852 L
.40801 .40542 L
.40804 .40219 L
.40806 .39857 L
.40812 .38831 L
.40825 .36018 L
.4085 .287 L
.40862 .25225 L
.40868 .2376 L
.40873 .22615 L
.40878 .21746 L
.40884 .21019 L
.40887 .2072 L
.40889 .2051 L
.40892 .2037 L
.40895 .20287 L
.40898 .20272 L
.409 .20332 L
.40903 .20462 L
.40906 .20641 L
.40909 .20924 L
.40912 .21317 L
.40918 .22253 L
.40965 .35329 L
.40977 .38673 L
.40985 .40121 L
.40988 .40673 L
.40991 .411 L
.40994 .41429 L
.40997 .41657 L
.41 .41829 L
.41002 .41886 L
.41003 .41916 L
.41005 .41923 L
.41006 .41905 L
.41009 .41811 L
.41013 .41619 L
.41014 .4147 L
Mistroke
.41016 .41303 L
.41022 .40532 L
.41028 .39371 L
.4104 .36533 L
.41062 .29736 L
.41074 .25874 L
.41081 .23987 L
.41087 .22446 L
.41093 .21259 L
.41096 .20747 L
.41099 .20297 L
.41102 .19993 L
.41105 .1974 L
.41108 .19586 L
.4111 .19509 L
.41113 .19501 L
.41115 .19531 L
.41117 .19591 L
.4112 .19764 L
.41122 .20004 L
.41126 .20379 L
.41129 .20809 L
.41136 .2206 L
.41148 .25154 L
.41159 .28796 L
.41183 .36486 L
.41193 .39265 L
.41198 .40452 L
.41204 .41457 L
.41207 .41867 L
.4121 .42226 L
.41213 .42466 L
.41216 .42613 L
.41219 .42687 L
.41221 .42685 L
.41224 .426 L
.41227 .42439 L
.4123 .42186 L
.41233 .41823 L
.41239 .40942 L
.41245 .39688 L
.41252 .37979 L
.41273 .31013 L
.41296 .23589 L
.41301 .22114 L
.41307 .20791 L
.41311 .20166 L
.41314 .19689 L
.41317 .193 L
.4132 .19028 L
Mistroke
.41323 .18855 L
.41325 .18751 L
.41328 .18729 L
.41331 .18801 L
.41334 .18944 L
.41337 .19179 L
.4134 .19478 L
.41342 .19815 L
.41349 .20941 L
.41355 .22297 L
.41368 .26261 L
.41392 .34866 L
.41405 .38745 L
.41411 .40426 L
.41418 .41843 L
.41421 .42318 L
.41424 .42739 L
.41425 .42939 L
.41427 .43092 L
.4143 .43316 L
.41433 .43428 L
.41436 .43453 L
.41439 .43385 L
.41442 .43242 L
.41444 .43035 L
.41447 .42736 L
.41452 .42 L
.41458 .40817 L
.41463 .39469 L
.41486 .31822 L
.41508 .23989 L
.41515 .22109 L
.41521 .20603 L
.41526 .19513 L
.41529 .19022 L
.41532 .18645 L
.41535 .18322 L
.41537 .18193 L
.41538 .18087 L
.4154 .18012 L
.41542 .17976 L
.41544 .17972 L
.41545 .17999 L
.41548 .1813 L
.4155 .18237 L
.41552 .18386 L
.41555 .18727 L
.41558 .19136 L
.41564 .20257 L
.41569 .21577 L
Mistroke
.41582 .25392 L
.41604 .33567 L
.41616 .37858 L
.41627 .41162 L
.41634 .42563 L
.41637 .43176 L
.41641 .4362 L
.41643 .43899 L
.41647 .44104 L
.41648 .44166 L
.4165 .44202 L
.41653 .44185 L
.41656 .44061 L
.41658 .43945 L
.41659 .43807 L
.41662 .43479 L
.41665 .43027 L
.41671 .41883 L
.41677 .4055 L
.41701 .32154 L
.41715 .26963 L
.41727 .22602 L
.41738 .19696 L
.41741 .19045 L
.41744 .18513 L
.41746 .18114 L
.41749 .17756 L
.41752 .17483 L
.41755 .17299 L
.41758 .17227 L
.4176 .17246 L
.41764 .17376 L
.41767 .17596 L
.4177 .17947 L
.41773 .18437 L
.41779 .19569 L
.41784 .20882 L
.41796 .24649 L
.41817 .33 L
.41829 .37577 L
.41836 .39707 L
.41842 .41644 L
.41848 .43015 L
.41851 .43604 L
.41854 .44122 L
.41857 .4449 L
.4186 .44734 L
.41863 .44887 L
.41866 .44947 L
.41869 .44913 L
Mistroke
.4187 .44846 L
.41872 .44756 L
.41875 .44514 L
.41878 .44156 L
.41883 .43292 L
.41889 .42011 L
.41902 .38114 L
.41913 .33559 L
.41935 .24952 L
.41946 .21085 L
.41952 .19375 L
.41958 .181 L
.41961 .17532 L
.41964 .17116 L
.41965 .16937 L
.41967 .16776 L
.41969 .16644 L
.41971 .16555 L
.41974 .16489 L
.41975 .16501 L
.41977 .16543 L
.4198 .16707 L
.41983 .16961 L
.41986 .1732 L
.41989 .17805 L
.41994 .18934 L
.42 .20492 L
.42007 .22562 L
.4203 .31722 L
.42051 .40234 L
.42057 .41989 L
.42063 .43524 L
.42066 .44174 L
.4207 .44762 L
.42073 .45174 L
.42076 .45452 L
.42078 .4561 L
.42081 .45677 L
.42084 .45652 L
.42086 .45537 L
.42089 .45313 L
.42092 .44958 L
.42095 .44518 L
.42098 .4403 L
.42104 .42527 L
.4211 .40771 L
.42124 .35788 L
.42148 .25368 L
.42159 .21161 L
.42166 .19249 L
Mistroke
.42172 .17778 L
.42177 .16753 L
.4218 .16328 L
.42183 .16039 L
.42186 .15863 L
.42188 .1578 L
.42191 .15775 L
.42193 .15861 L
.42196 .16057 L
.42199 .16393 L
.42203 .16875 L
.42206 .17442 L
.42211 .18727 L
.42217 .20455 L
.42243 .30823 L
.42255 .36037 L
.42267 .4092 L
.42274 .4298 L
.42277 .43901 L
.42281 .44744 L
.42285 .4537 L
.42288 .45817 L
.42291 .46128 L
.42294 .46327 L
.42297 .46395 L
.423 .46352 L
.42301 .46285 L
.42303 .46178 L
.42306 .45893 L
.42309 .45521 L
.42312 .45019 L
.42317 .43856 L
.42329 .40128 L
.42342 .34731 L
.42366 .24027 L
.42378 .19627 L
.42384 .17932 L
.42389 .16707 L
.42392 .16159 L
.42395 .15687 L
.42397 .15482 L
.42398 .15329 L
.42402 .15125 L
.42403 .15071 L
.42405 .15054 L
.42406 .15071 L
.42408 .15132 L
.4241 .15242 L
.42412 .1539 L
.42415 .15781 L
Mistroke
.42418 .16237 L
.42421 .16835 L
.42427 .1819 L
.42439 .22411 L
.42464 .33274 L
.42476 .38585 L
.42487 .42716 L
.42492 .44243 L
.42497 .45407 L
.42499 .45928 L
.42502 .46388 L
.42505 .46709 L
.42508 .4692 L
.4251 .47061 L
.42513 .471 L
.42516 .47042 L
.42519 .46861 L
.42522 .46542 L
.42525 .46119 L
.4253 .45022 L
.42536 .43532 L
.42542 .41574 L
.42552 .3728 L
.42577 .25943 L
.42588 .21061 L
.42594 .18896 L
.42601 .17012 L
.42604 .16196 L
.42608 .15466 L
.42611 .14957 L
.42614 .14621 L
.42616 .14497 L
.42617 .14415 L
.4262 .14355 L
.42624 .14426 L
.42625 .14527 L
.42627 .1466 L
.4263 .15 L
.42633 .15436 L
.42638 .16543 L
.42644 .18128 L
.4265 .20269 L
.42672 .29937 L
.42685 .3638 L
.42698 .41734 L
.42704 .43661 L
.42709 .45342 L
.42712 .4606 L
.42716 .46711 L
.42719 .47174 L
Mistroke
.42722 .47491 L
.42725 .47702 L
.42726 .47767 L
.42728 .47792 L
.42731 .47748 L
.42734 .47577 L
.42736 .47317 L
.42739 .46982 L
.42744 .45899 L
.42751 .44267 L
.42756 .4239 L
.42769 .37103 L
.42795 .24414 L
.42808 .19088 L
.42813 .17227 L
.42819 .15613 L
.42822 .15003 L
.42825 .14479 L
.42828 .14132 L
.42831 .13861 L
.42833 .13714 L
.42836 .13671 L
.42839 .13741 L
.42841 .13898 L
.42844 .14207 L
.42847 .14607 L
.4285 .1517 L
.42853 .15906 L
.42865 .19527 L
.42877 .24771 L
.42889 .30433 L
.42901 .36661 L
.42915 .42619 L
.42921 .44681 L
.42927 .46439 L
.4293 .47107 L
.42933 .4762 L
.42935 .47981 L
.42938 .48261 L
.42941 .48431 L
.42943 .48468 L
.42945 .48464 L
.42946 .48419 L
.42948 .48341 L
.42949 .48208 L
.42951 .48039 L
.42954 .47641 L
.42957 .47161 L
.42963 .45689 L
.42969 .43871 L
Mistroke
.42974 .41815 L
.42985 .37263 L
.43008 .25638 L
.4302 .20058 L
.43031 .16033 L
.43037 .14589 L
.4304 .13974 L
.43043 .13541 L
.43044 .1335 L
.43046 .1321 L
.43048 .13097 L
.43049 .13023 L
.43052 .1301 L
.43054 .13063 L
.43056 .13153 L
.43058 .13382 L
.43061 .13746 L
.43064 .14252 L
.43067 .14835 L
.43077 .17871 L
.43088 .22489 L
.431 .28398 L
.43125 .40821 L
.43132 .4361 L
.43139 .46032 L
.43145 .4759 L
.43148 .48245 L
.4315 .48499 L
.43151 .48698 L
.43154 .48976 L
.43156 .49067 L
.43158 .49122 L
.43161 .49108 L
.43164 .48965 L
.43166 .48707 L
.43169 .48299 L
.43172 .47792 L
.43175 .47225 L
.43181 .45614 L
.43187 .4336 L
.432 .37584 L
.43224 .249 L
.43236 .1932 L
.43241 .17263 L
.43247 .15358 L
.43253 .13806 L
.43256 .13183 L
.4326 .12752 L
.43261 .12577 L
.43263 .12455 L
Mistroke
.43266 .12345 L
.43268 .12352 L
.43269 .12403 L
.43271 .12506 L
.43273 .12673 L
.43276 .13063 L
.4328 .13651 L
.43286 .15137 L
.43292 .17065 L
.43297 .19209 L
.43321 .31132 L
.43334 .38072 L
.43346 .43745 L
.43352 .45806 L
.43358 .4757 L
.43361 .48297 L
.43364 .48938 L
.43367 .49368 L
.4337 .49635 L
.43373 .49763 L
.43376 .49773 L
.43378 .49682 L
.43381 .49476 L
.43383 .49132 L
.43387 .48625 L
.43392 .47364 L
.43398 .45453 L
.43404 .43273 L
.43417 .37201 L
.4344 .24563 L
.43451 .19241 L
.43461 .15294 L
.43466 .13805 L
.43469 .13186 L
.43471 .12629 L
.43475 .12167 L
.43478 .11873 L
.4348 .11724 L
.43483 .11708 L
.43486 .11836 L
.43488 .1196 L
.4349 .12141 L
.43493 .12575 L
.43495 .13109 L
.43502 .14754 L
.43509 .17136 L
.43521 .22851 L
.43533 .29024 L
.43554 .40806 L
.43565 .45571 L
Mistroke
.43571 .47652 L
.43577 .49106 L
.4358 .49638 L
.43583 .50052 L
.43586 .50283 L
.43589 .50407 L
.43592 .50387 L
.43594 .50307 L
.43595 .5019 L
.43598 .49848 L
.43601 .49385 L
.43607 .48142 L
.43612 .46601 L
.43623 .4191 L
.43649 .2784 L
.43662 .21039 L
.43667 .18425 L
.43673 .1594 L
.43679 .13967 L
.43681 .13249 L
.43684 .12567 L
.43687 .12072 L
.43689 .11647 L
.43692 .11324 L
.43695 .1114 L
.43698 .11074 L
.43701 .11156 L
.43702 .11259 L
.43704 .11414 L
.43707 .11811 L
.4371 .12355 L
.43713 .13001 L
.43718 .14539 L
.43731 .19561 L
.43742 .25529 L
.43754 .32701 L
.43768 .40156 L
.43774 .43219 L
.4378 .45762 L
.43786 .47819 L
.43791 .49306 L
.43794 .4987 L
.43796 .50302 L
.43799 .50678 L
.43801 .50905 L
.43804 .51027 L
.43807 .51017 L
.4381 .50871 L
.43813 .50566 L
.43816 .50097 L
Mistroke
.43819 .49533 L
.43825 .47815 L
.43831 .45707 L
.43836 .43308 L
.43862 .28964 L
.43874 .2216 L
.43886 .16698 L
.43892 .14324 L
.43897 .12603 L
.439 .11872 L
.43903 .11262 L
.43905 .11027 L
.43907 .1082 L
.43909 .10647 L
.4391 .10537 L
.43913 .10464 L
.43916 .10532 L
.43919 .10758 L
.4392 .10931 L
.43922 .11166 L
.43925 .11667 L
.43928 .12348 L
.43933 .13939 L
.43944 .18416 L
.43954 .23649 L
.43977 .36697 L
.43989 .43217 L
.43995 .45907 L
.44 .47986 L
.44007 .49897 L
.4401 .50632 L
.44012 .50931 L
.44014 .51194 L
.44017 .51492 L
.4402 .51625 L
.44021 .51637 L
.44023 .516 L
.44026 .51403 L
.44029 .51067 L
.44032 .50553 L
.44035 .49988 L
.44037 .49236 L
.44044 .471 L
.4405 .44575 L
.44072 .32757 L
.44094 .19417 L
.44101 .16181 L
.44108 .13652 L
.44113 .11887 L
.44117 .11124 L
Mistroke
.4412 .10577 L
.44122 .10204 L
.44125 .09979 L
.44128 .09874 L
.44131 .09924 L
.44133 .10013 L
.44134 .10158 L
.44137 .1055 L
.4414 .11088 L
.44143 .1172 L
.44149 .13424 L
.44154 .15472 L
.44166 .21477 L
.44191 .36407 L
.44203 .43051 L
.4421 .46119 L
.44216 .48495 L
.44222 .5046 L
.44226 .51217 L
.44227 .51525 L
.44229 .51797 L
.44231 .51987 L
.44233 .52114 L
.44234 .5219 L
.44236 .52223 L
.44239 .52164 L
.44242 .51928 L
.44245 .51522 L
.44248 .50995 L
.44251 .50253 L
.44255 .49281 L
.44266 .44508 L
.44278 .3821 L
.44289 .31738 L
.44301 .239 L
.44315 .16652 L
.4432 .14232 L
.44326 .12119 L
.4433 .11154 L
.44333 .10443 L
.44336 .09897 L
.44339 .09539 L
.44342 .09351 L
.44344 .09295 L
.44348 .09404 L
.4435 .09662 L
.44353 .10037 L
.44356 .10493 L
.44361 .11898 L
.44367 .13831 L
Mistroke
.44373 .16467 L
.44385 .23089 L
.44411 .39317 L
.44424 .459 L
.44429 .48226 L
.44435 .50282 L
.44438 .51028 L
.44441 .51689 L
.44444 .52222 L
.44447 .52564 L
.44448 .52689 L
.4445 .52769 L
.44452 .52792 L
.44453 .52767 L
.44456 .52599 L
.44459 .52247 L
.44462 .51745 L
.44466 .51027 L
.44471 .49279 L
.44482 .44642 L
.44506 .30353 L
.44519 .22397 L
.44526 .1844 L
.44533 .15166 L
.44539 .12604 L
.44542 .11491 L
.44546 .10506 L
.44549 .0984 L
.4455 .09548 L
.44552 .09283 L
.44555 .08943 L
.44558 .0877 L
.4456 .08743 L
.44562 .08802 L
.44564 .08903 L
.44567 .09207 L
.4457 .09696 L
.44573 .10339 L
.44575 .11089 L
.44581 .12846 L
.44593 .18724 L
.44605 .25625 L
.44618 .33824 L
.44631 .42172 L
.44638 .45508 L
.44644 .48224 L
.44649 .50372 L
.44652 .51145 L
.44655 .5187 L
.44657 .52385 L
Mistroke
.4466 .52818 L
.44663 .53136 L
.44665 .53303 L
.44668 .53335 L
.44671 .53198 L
.44674 .52942 L
.44677 .52516 L
.4468 .51824 L
.44683 .50987 L
.44689 .48967 L
.44702 .42583 L
.44726 .27469 L
.44738 .19975 L
.4475 .14141 L
.44755 .1185 L
.44761 .09967 L
.44765 .09185 L
.44766 .08882 L
.44768 .08649 L
.44771 .08341 L
.44773 .08247 L
.44774 .08197 L
.44777 .08244 L
.4478 .08439 L
.44783 .08821 L
.44785 .09079 L
.44786 .09411 L
.44792 .10966 L
.44798 .12939 L
.44808 .17797 L
.44819 .24268 L
.44843 .40213 L
.4485 .44108 L
.44857 .47692 L
.44863 .50217 L
.44866 .513 L
.4487 .52245 L
.44873 .52897 L
.44874 .53177 L
.44876 .53424 L
.44879 .53729 L
.44882 .53862 L
.44885 .5384 L
.44887 .53659 L
.4489 .53363 L
.44893 .52904 L
.44896 .52228 L
.44899 .5129 L
.44906 .48806 L
.44918 .42679 L
Mistroke
.44942 .2712 L
.44954 .1962 L
.44965 .13826 L
.44971 .11315 L
.44977 .09319 L
.44981 .08584 L
.44984 .08086 L
.44986 .07888 L
.44987 .07761 L
.44989 .07685 L
.44991 .07674 L
.44994 .07793 L
.44997 .08099 L
.45 .08554 L
.45003 .09106 L
.45009 .10993 L
.45015 .13424 L
.45059 .40706 L
.45071 .47431 L
.45078 .50375 L
.45081 .51515 L
.45084 .52412 L
.45087 .53155 L
.4509 .53681 L
.45093 .54097 L
.45094 .54248 L
.45096 .54341 L
.45099 .54384 L
.45101 .5428 L
.45104 .54008 L
.45107 .53544 L
.4511 .52919 L
.45113 .52205 L
.45119 .50123 L
.4513 .4489 L
.45155 .28738 L
.45167 .20526 L
.45174 .16668 L
.45181 .13136 L
.45187 .10645 L
.4519 .09574 L
.45194 .08631 L
.45197 .07967 L
.452 .07531 L
.45203 .07271 L
.45206 .07166 L
.45209 .07237 L
.4521 .07355 L
.45212 .07513 L
.45215 .07928 L
Mistroke
.45218 .08538 L
.45223 .09998 L
.45229 .12158 L
.45241 .18692 L
.45253 .2633 L
.45274 .40706 L
.45285 .47168 L
.45291 .50031 L
.45297 .52175 L
.453 .53133 L
.45304 .5394 L
.45306 .5422 L
.45307 .54462 L
.4531 .54759 L
.45313 .5488 L
.45316 .54831 L
.45319 .54597 L
.45321 .54385 L
.45322 .54141 L
.45325 .53525 L
.45328 .52797 L
.45334 .50618 L
.45346 .44993 L
.45367 .30911 L
.4539 .15849 L
.45397 .12684 L
.45403 .10221 L
.45408 .08528 L
.45411 .07803 L
.45414 .07288 L
.45416 .06923 L
.45419 .06729 L
.45422 .06681 L
.45424 .06762 L
.45427 .0701 L
.4543 .0745 L
.45433 .07969 L
.45435 .08686 L
.45442 .1089 L
.45448 .13524 L
.45461 .21186 L
.45485 .37785 L
.45496 .45125 L
.45503 .48524 L
.45509 .51178 L
.45514 .52959 L
.45516 .53693 L
.45519 .54348 L
.45522 .54857 L
.45525 .55203 L
Mistroke
.45528 .55348 L
.45531 .55329 L
.45534 .55121 L
.45536 .54915 L
.45537 .5467 L
.4554 .5408 L
.45543 .53265 L
.45549 .51409 L
.45555 .48765 L
.45568 .41099 L
.45581 .32506 L
.45593 .24034 L
.45606 .15749 L
.45612 .12613 L
.45618 .09877 L
.45621 .088 L
.45624 .0795 L
.45626 .0733 L
.45629 .06805 L
.45632 .06447 L
.45635 .06261 L
.45637 .0622 L
.4564 .06354 L
.45643 .06642 L
.45646 .0706 L
.45648 .07553 L
.45651 .08212 L
.45657 .10187 L
.45663 .12937 L
.45674 .19276 L
.45696 .3507 L
.45708 .43111 L
.45715 .4695 L
.45721 .50016 L
.45726 .52409 L
.45732 .54063 L
.45735 .54772 L
.45737 .55275 L
.4574 .55629 L
.45742 .55747 L
.45744 .55804 L
.45746 .55788 L
.45748 .55653 L
.45751 .55371 L
.45754 .54914 L
.45757 .54268 L
.45759 .53501 L
.45765 .51674 L
.45789 .37281 L
.45813 .20591 L
Mistroke
.45823 .14325 L
.45829 .11488 L
.45834 .09302 L
.4584 .07491 L
.45842 .06785 L
.45844 .06494 L
.45846 .06232 L
.45849 .05913 L
.45851 .05778 L
.45854 .05803 L
.45857 .05963 L
.45859 .06289 L
.45862 .06813 L
.45865 .0747 L
.45867 .08204 L
.45874 .1051 L
.4588 .13319 L
.45904 .29356 L
.45917 .38493 L
.45928 .46215 L
.45935 .49769 L
.45942 .52839 L
.45945 .53906 L
.45948 .54824 L
.45951 .55433 L
.45954 .55909 L
.45956 .56068 L
.45958 .56185 L
.45961 .56245 L
.45964 .56115 L
.45966 .55829 L
.45969 .55345 L
.45972 .54603 L
.45976 .53603 L
.45979 .52461 L
.4599 .4712 L
.46002 .39498 L
.46025 .22829 L
.46036 .15518 L
.46046 .10247 L
.46052 .08037 L
.46054 .07232 L
.46057 .06531 L
.4606 .05957 L
.46063 .05594 L
.46066 .05382 L
.46068 .05345 L
.46069 .05365 L
.46071 .05438 L
.46072 .05577 L
Mistroke
.46075 .05989 L
.46078 .06584 L
.46081 .07303 L
.46088 .09498 L
.46094 .1263 L
.46108 .21041 L
.46121 .30419 L
.46132 .38889 L
.46145 .47136 L
.46151 .50305 L
.46157 .53069 L
.4616 .54147 L
.46163 .54998 L
.46166 .55613 L
.46168 .5613 L
.46171 .56489 L
.46173 .56603 L
.46175 .56657 L
.46177 .56623 L
.4618 .56402 L
.46182 .56207 L
.46184 .55934 L
.46187 .55193 L
.4619 .54287 L
.46193 .53262 L
.46205 .47931 L
.46215 .4149 L
.46238 .24596 L
.46249 .16559 L
.46256 .12805 L
.46262 .09858 L
.46267 .07843 L
.46269 .07002 L
.46272 .06244 L
.46275 .0561 L
.46278 .052 L
.46281 .04983 L
.46284 .04945 L
.46287 .05077 L
.4629 .0542 L
.46293 .05933 L
.46295 .06561 L
.46302 .08581 L
.46308 .11496 L
.4632 .18797 L
.46334 .28534 L
.46345 .37286 L
.46358 .45948 L
.46364 .49315 L
.4637 .52315 L
Mistroke
.46375 .54344 L
.46378 .55253 L
.46381 .55951 L
.46383 .56282 L
.46384 .56577 L
.46387 .56925 L
.46389 .57026 L
.46391 .57058 L
.46393 .57015 L
.46395 .56915 L
.46398 .56554 L
.46399 .56255 L
.46401 .5592 L
.46407 .54145 L
.46413 .51903 L
.46419 .4881 L
.46431 .40958 L
.46455 .22913 L
.46467 .14895 L
.46478 .09137 L
.46484 .06852 L
.46487 .05984 L
.46489 .05575 L
.46491 .05259 L
.46492 .05002 L
.46494 .04787 L
.46496 .04641 L
.46498 .04565 L
.46499 .04563 L
.46501 .0463 L
.46503 .04757 L
.46504 .04926 L
.46508 .05426 L
.4651 .06069 L
.46513 .0697 L
.46517 .08138 L
.46528 .13857 L
.46553 .31171 L
.46565 .40245 L
.46576 .47673 L
.46586 .52903 L
.46592 .55028 L
.46594 .55762 L
.46597 .56395 L
.466 .56928 L
.46602 .57251 L
.46605 .57417 L
.46608 .57383 L
.46611 .5717 L
.46614 .56756 L
Mistroke
.46617 .56191 L
.46619 .55532 L
.46625 .53443 L
.46631 .50902 L
.46643 .43355 L
.46666 .2626 L
.46679 .17155 L
.46691 .1025 L
.46696 .0765 L
.467 .06576 L
.46703 .05623 L
.46705 .05189 L
.46706 .04855 L
.46708 .04599 L
.4671 .04394 L
.46712 .04262 L
.46713 .04201 L
.46716 .04252 L
.46719 .04484 L
.46722 .04926 L
.46725 .05525 L
.46728 .06221 L
.46734 .08502 L
.4674 .11362 L
.46752 .18705 L
.46765 .28316 L
.46776 .36866 L
.46788 .45391 L
.46793 .48792 L
.46799 .51886 L
.46804 .54091 L
.46809 .55909 L
.46812 .56658 L
.46815 .57176 L
.46817 .57538 L
.4682 .57732 L
.46823 .57775 L
.46825 .57639 L
.46828 .57297 L
.46832 .56718 L
.46835 .55977 L
.46838 .54974 L
.46843 .52645 L
.46856 .45206 L
.46883 .25449 L
.46895 .16219 L
.46907 .09548 L
.46913 .06961 L
.46916 .06021 L
.46919 .05206 L
Mistroke
.46922 .04542 L
.46925 .04125 L
.46928 .03889 L
.4693 .03853 L
.46931 .03884 L
.46933 .03978 L
.46935 .04151 L
.46936 .04381 L
.46938 .04651 L
.46941 .05312 L
.46944 .06222 L
.46951 .08762 L
.46958 .12487 L
.46983 .30562 L
.46994 .3916 L
.47006 .47569 L
.47012 .50888 L
.47018 .53825 L
.47021 .54998 L
.47024 .55942 L
.47026 .56645 L
.47029 .57263 L
.47032 .57738 L
.47035 .58032 L
.47038 .58112 L
.4704 .58018 L
.47043 .57698 L
.47046 .57212 L
.47049 .56424 L
.47053 .55458 L
.47059 .53024 L
.47065 .49685 L
.47077 .4212 L
.47103 .21845 L
.47114 .14218 L
.4712 .10718 L
.47125 .08002 L
.47131 .05734 L
.47134 .04845 L
.47136 .04475 L
.47138 .04142 L
.47141 .03732 L
.47144 .0355 L
.47147 .03568 L
.47149 .03755 L
.47152 .04083 L
.47155 .04598 L
.47157 .05236 L
.4716 .05945 L
.47165 .08159 L
Mistroke
.47171 .10853 L
.47193 .26472 L
.47216 .44301 L
.47223 .48665 L
.47229 .52176 L
.47235 .54732 L
.47238 .55889 L
.47241 .56781 L
.47243 .5741 L
.47246 .57918 L
.47249 .58277 L
.47252 .58414 L
.47255 .58364 L
.47258 .58084 L
.47261 .57608 L
.47264 .56987 L
.47269 .5548 L
.47274 .53241 L
.47285 .47091 L
.4731 .28473 L
.47323 .18185 L
.4733 .13772 L
.47335 .10294 L
.47341 .0778 L
.47346 .05636 L
.47349 .04735 L
.47352 .04088 L
.47355 .03637 L
.47358 .03343 L
.4736 .03238 L
.47363 .0334 L
.47366 .03639 L
.47369 .04084 L
.47372 .04808 L
.47376 .0584 L
.47382 .08335 L
.47407 .24864 L
.4743 .43473 L
.47441 .5026 L
.47446 .53265 L
.47452 .55525 L
.47455 .56554 L
.47457 .57322 L
.4746 .57981 L
.47462 .58255 L
.47464 .58454 L
.47466 .58664 L
.47469 .58701 L
.47472 .58567 L
.47475 .58228 L
Mistroke
.47478 .57691 L
.4748 .57029 L
.47486 .54962 L
.47492 .52521 L
.47497 .49396 L
.47522 .30967 L
.47535 .20978 L
.47546 .12735 L
.47553 .09037 L
.47556 .07403 L
.4756 .05933 L
.47563 .04913 L
.47566 .04031 L
.4757 .03455 L
.47572 .03115 L
.47575 .02968 L
.47577 .02976 L
.47579 .03042 L
.47581 .0331 L
.47584 .038 L
.47587 .04413 L
.4759 .05136 L
.47595 .07298 L
.47602 .10357 L
.47607 .13751 L
.4762 .22961 L
.47641 .40105 L
.47653 .48458 L
.47659 .51872 L
.47664 .545 L
.4767 .56755 L
.47673 .57639 L
.47675 .58005 L
.47676 .58335 L
.47679 .58722 L
.47682 .58922 L
.47685 .58954 L
.47688 .58788 L
.4769 .58437 L
.47693 .5795 L
.47696 .57238 L
.47699 .56281 L
.47704 .53995 L
.4771 .51391 L
.47735 .32884 L
.47747 .2354 L
.47759 .1426 L
.47765 .10632 L
.47771 .07404 L
.47774 .06115 L
Mistroke
.47777 .05075 L
.4778 .04302 L
.47783 .03622 L
.47786 .03106 L
.47787 .02913 L
.47789 .02791 L
.47792 .02712 L
.47795 .0283 L
.47796 .02977 L
.47798 .03205 L
.478 .03517 L
.47801 .03874 L
.47804 .04667 L
.47808 .05747 L
.47813 .08244 L
.47819 .11194 L
.47829 .17986 L
.47852 .36329 L
.47863 .44787 L
.47875 .52282 L
.47881 .55501 L
.47885 .567 L
.47888 .5761 L
.47891 .58321 L
.47892 .58614 L
.47894 .58862 L
.47897 .59146 L
.479 .59206 L
.47901 .5916 L
.47903 .59045 L
.47905 .58855 L
.47906 .58614 L
.47909 .58027 L
.47912 .57185 L
.47919 .54469 L
.47926 .51121 L
.4795 .33167 L
.47973 .15564 L
.47984 .08672 L
.4799 .05772 L
.47993 .04751 L
.47996 .03846 L
.47998 .03441 L
.48 .03127 L
.48001 .02867 L
.48003 .02689 L
.48006 .02501 L
.48009 .02523 L
.48011 .02637 L
.48012 .02804 L
Mistroke
.48014 .03059 L
.48016 .03406 L
.48019 .0417 L
.48022 .05262 L
.48028 .0778 L
.48035 .11258 L
.48046 .19174 L
.48071 .38983 L
.48084 .48451 L
.48091 .52676 L
.48097 .5581 L
.48103 .57778 L
.48105 .58188 L
.48106 .58557 L
.48109 .59057 L
.48111 .59237 L
.48112 .59364 L
.48115 .5942 L
.48117 .59344 L
.48119 .59196 L
.48121 .59 L
.48122 .58721 L
.48125 .58115 L
.48128 .57239 L
.48134 .54832 L
.4814 .519 L
.48146 .48618 L
.48167 .32023 L
.4819 .14017 L
.48197 .09784 L
.48203 .06557 L
.48209 .04382 L
.48212 .03482 L
.48215 .02872 L
.48218 .02491 L
.48221 .02307 L
.48224 .02297 L
.48227 .0251 L
.48228 .02704 L
.4823 .02979 L
.48233 .03651 L
.48236 .04514 L
.48239 .05488 L
.48251 .11386 L
.48263 .20482 L
.4829 .41846 L
.48302 .50279 L
.48308 .53823 L
.48311 .55437 L
.48315 .56717 L
Mistroke
.48318 .57734 L
.4832 .58473 L
.48323 .59083 L
.48325 .59322 L
.48327 .59483 L
.4833 .59617 L
.48332 .59572 L
.48335 .59337 L
.48338 .58879 L
.48341 .58226 L
.48344 .5729 L
.4835 .55013 L
.48361 .48963 L
.48385 .29991 L
.48396 .21036 L
.48408 .12503 L
.48413 .09248 L
.48419 .06401 L
.48424 .04503 L
.48426 .03666 L
.48429 .03035 L
.48432 .0251 L
.48435 .02215 L
.48438 .02095 L
.48441 .02195 L
.48443 .0248 L
.48446 .0298 L
.48449 .03566 L
.48452 .04377 L
.48458 .0683 L
.48464 .10339 L
.48477 .18541 L
.48503 .39978 L
.48515 .49308 L
.48521 .52652 L
.48527 .55628 L
.4853 .56896 L
.48533 .57868 L
.48536 .58617 L
.48539 .59212 L
.48542 .59616 L
.48545 .59782 L
.48548 .5973 L
.4855 .59593 L
.48551 .59402 L
.48553 .59142 L
.48555 .58795 L
.48558 .57992 L
.48561 .56876 L
.48565 .55353 L
Mistroke
.48578 .47991 L
.48603 .27952 L
.48614 .19004 L
.48626 .1064 L
.48632 .07507 L
.48635 .06052 L
.48638 .04868 L
.48641 .03936 L
.48643 .0312 L
.48646 .0256 L
.48649 .022 L
.48652 .01974 L
.48654 .01943 L
.48657 .02111 L
.4866 .02524 L
.48662 .02821 L
.48664 .03212 L
.48667 .04099 L
.48673 .06356 L
.48679 .0976 L
.48685 .13522 L
.48699 .23675 L
.48723 .43549 L
.48734 .51597 L
.4874 .54786 L
.48744 .56301 L
.48747 .57465 L
.48749 .58294 L
.48752 .59007 L
.48755 .59545 L
.48758 .59845 L
.48761 .5994 L
.48764 .59844 L
.48766 .59603 L
.48769 .59168 L
.48771 .58828 L
.48772 .58389 L
.48775 .57408 L
.48781 .54963 L
.48788 .512 L
.48795 .46957 L
.48819 .27396 L
.48831 .17574 L
.48838 .13002 L
.48844 .08848 L
.4885 .05909 L
.48853 .04649 L
.48857 .03543 L
.4886 .02759 L
.48863 .02244 L
Mistroke
.48866 .01922 L
.48868 .01801 L
.48871 .01852 L
.48874 .02096 L
.48877 .0256 L
.48879 .03187 L
.48884 .04753 L
.4889 .0705 L
.48902 .14319 L
.48913 .22828 L
.48935 .41153 L
.48947 .49933 L
.48953 .5345 L
.48958 .56101 L
.48962 .57316 L
.48965 .58407 L
.48968 .59233 L
.4897 .59567 L
.48972 .59802 L
.48975 .60036 L
.48978 .60043 L
.48979 .59963 L
.48981 .59807 L
.48984 .5934 L
.48987 .58625 L
.4899 .57774 L
.48997 .55199 L
.49003 .52054 L
.49008 .48512 L
.4903 .31645 L
.49052 .13434 L
.49059 .09196 L
.49065 .05953 L
.49071 .03772 L
.49074 .02871 L
.49077 .0226 L
.4908 .01886 L
.49083 .0171 L
.49086 .01712 L
.49089 .01941 L
.49092 .02401 L
.49093 .02718 L
.49095 .0313 L
.49101 .05038 L
.49107 .07957 L
.49113 .1128 L
.49126 .20555 L
.49149 .39879 L
.49161 .49219 L
.49168 .53235 L
Mistroke
.49175 .56589 L
.49178 .57695 L
.49181 .58662 L
.49183 .59112 L
.49184 .59454 L
.49186 .59734 L
.49188 .59931 L
.49191 .60139 L
.49194 .60129 L
.49196 .59916 L
.49199 .59479 L
.49202 .5889 L
.49205 .58043 L
.49211 .55721 L
.49217 .5289 L
.49222 .49732 L
.49246 .30668 L
.49267 .13843 L
.49273 .10097 L
.49279 .06768 L
.49284 .04528 L
.49287 .03529 L
.4929 .02766 L
.49292 .02421 L
.49293 .02113 L
.49296 .01745 L
.49298 .01635 L
.493 .01596 L
.49301 .01635 L
.49303 .01732 L
.49306 .02091 L
.49308 .02393 L
.49309 .02732 L
.49312 .03563 L
.49315 .04537 L
.49321 .06931 L
.49327 .10272 L
.49339 .18851 L
.4936 .36721 L
.49372 .45692 L
.49384 .53469 L
.4939 .56472 L
.49393 .57734 L
.49397 .58817 L
.49398 .59204 L
.494 .59546 L
.49403 .59989 L
.49406 .60206 L
.49409 .60221 L
.49412 .59996 L
Mistroke
.49415 .59582 L
.49416 .59269 L
.49418 .58862 L
.49421 .57947 L
.49427 .5557 L
.49433 .52717 L
.49454 .36922 L
.49477 .17815 L
.49489 .09814 L
.49495 .06709 L
.495 .04429 L
.49503 .03434 L
.49506 .02598 L
.49508 .02227 L
.49509 .01949 L
.49513 .01618 L
.49515 .01532 L
.49518 .0164 L
.49521 .01963 L
.49524 .02535 L
.49527 .03235 L
.49529 .04026 L
.49535 .06318 L
.49545 .1206 L
.49568 .30156 L
.4959 .48089 L
.49602 .54855 L
.49605 .56287 L
.49608 .576 L
.49611 .58604 L
.49614 .59333 L
.49617 .59898 L
.49619 .60098 L
.49621 .60236 L
.49623 .60295 L
.49624 .6027 L
.49626 .60182 L
.49628 .60016 L
.49631 .59524 L
.49632 .59185 L
.49634 .58744 L
.4964 .56701 L
.49646 .53867 L
.49652 .50054 L
.49664 .41586 L
.49688 .21104 L
.49701 .11618 L
.49708 .07486 L
.49712 .05813 L
.49715 .04502 L
Mistroke
.49718 .03552 L
.49721 .02712 L
.49724 .02085 L
.49727 .01664 L
.49729 .0154 L
.4973 .01492 L
.49732 .01513 L
.49734 .01608 L
.49737 .01958 L
.49739 .02256 L
.4974 .02595 L
.49745 .04187 L
.49749 .05386 L
.49751 .06693 L
.49763 .13854 L
.49785 .31228 L
.49797 .41167 L
.49808 .49437 L
.49814 .53331 L
.49821 .56674 L
.49824 .57829 L
.49827 .58819 L
.4983 .59472 L
.49833 .59978 L
.49836 .60264 L
.49839 .60322 L
.49841 .6027 L
.49842 .60147 L
.49845 .59744 L
.49848 .59162 L
.49851 .58331 L
.49857 .5631 L
.49863 .53339 L
.49869 .49375 L
.49881 .4065 L
.49894 .29694 L
.49907 .18379 L
.49919 .09987 L
.49926 .0631 L
.49929 .04886 L
.49933 .03757 L
.49935 .02918 L
.49938 .02221 L
.49941 .01782 L
.49944 .01546 L
.49946 .01473 L
.49949 .01612 L
.49953 .02002 L
.49956 .02589 L
.49959 .03403 L
Mistroke
.49962 .04501 L
.49968 .07048 L
.49981 .15157 L
.50004 .34659 L
.50016 .44477 L
.50028 .52215 L
.50033 .54914 L
.50038 .57218 L
.50041 .58183 L
.50044 .59042 L
.50046 .59637 L
.50049 .60028 L
.50052 .60288 L
.50054 .6033 L
.50055 .60309 L
.50058 .60096 L
.50061 .59695 L
.50063 .59359 L
.50064 .58976 L
.50067 .58091 L
.50074 .5534 L
.5008 .52168 L
.50086 .48656 L
.50098 .39174 L
.50119 .21088 L
.50131 .12657 L
.50137 .08825 L
.50143 .05887 L
.50149 .03478 L
.50152 .02572 L
.50154 .0218 L
.50156 .01898 L
.50159 .01576 L
.5016 .01493 L
.50162 .0148 L
.50165 .01614 L
.50168 .01982 L
.50171 .02525 L
.50174 .03325 L
.50179 .05319 L
.50186 .0854 L
.50192 .12212 L
.50213 .29188 L
.50237 .47874 L
.50243 .52002 L
.50249 .55242 L
.50254 .57522 L
.50257 .58522 L
.5026 .59254 L
.50263 .59768 L
Mistroke
.50265 .60097 L
.50268 .60287 L
.50271 .60289 L
.50274 .6007 L
.50277 .59652 L
.50279 .59105 L
.50282 .58329 L
.50289 .55811 L
.50294 .52745 L
.50308 .43671 L
.50332 .23671 L
.50343 .14524 L
.5035 .10272 L
.50356 .06952 L
.50361 .04688 L
.50364 .03748 L
.50366 .02908 L
.5037 .02209 L
.50373 .01766 L
.50375 .01543 L
.50378 .01519 L
.50381 .01691 L
.50384 .02105 L
.50387 .0271 L
.5039 .03444 L
.50396 .0578 L
.50402 .0912 L
.50415 .17443 L
.50428 .28454 L
.5044 .38357 L
.50452 .48084 L
.50458 .51845 L
.50464 .55172 L
.5047 .57404 L
.50472 .58394 L
.50475 .59145 L
.50477 .59499 L
.50479 .5981 L
.50482 .60164 L
.50484 .60255 L
.50486 .60266 L
.50487 .60205 L
.50489 .60062 L
.50492 .59614 L
.50494 .59255 L
.50495 .58858 L
.50502 .56793 L
.50507 .54211 L
.50513 .50684 L
.50526 .4181 L
Mistroke
.5055 .21544 L
.50562 .12652 L
.50567 .09379 L
.50573 .06353 L
.50579 .03885 L
.50582 .02896 L
.50585 .02213 L
.50587 .01934 L
.50589 .0174 L
.50592 .01566 L
.50594 .01576 L
.50595 .01656 L
.50597 .01819 L
.50599 .02081 L
.50602 .02697 L
.50605 .03624 L
.50612 .05965 L
.50618 .09 L
.50623 .12371 L
.50647 .31105 L
.5066 .41971 L
.50672 .50825 L
.50678 .54037 L
.50684 .56781 L
.50687 .57911 L
.5069 .58904 L
.50693 .59569 L
.50696 .59981 L
.50699 .60176 L
.50701 .60189 L
.50704 .60044 L
.50707 .59722 L
.50709 .59184 L
.50712 .58396 L
.50718 .5644 L
.50724 .53472 L
.5073 .50094 L
.50742 .40706 L
.50766 .21258 L
.50777 .13102 L
.50787 .07076 L
.50792 .0481 L
.50795 .0387 L
.50797 .03026 L
.50801 .02329 L
.50804 .01889 L
.50806 .0167 L
.50809 .01653 L
.50812 .01857 L
.50814 .0205 L
Mistroke
.50815 .0233 L
.50819 .03 L
.50821 .03822 L
.50828 .06343 L
.50835 .0998 L
.50859 .28026 L
.5087 .37583 L
.50882 .46912 L
.50892 .53383 L
.50898 .5621 L
.50903 .58201 L
.50906 .59043 L
.50909 .59622 L
.50912 .59955 L
.50915 .60112 L
.50917 .60106 L
.50918 .6004 L
.5092 .59894 L
.50922 .59686 L
.50925 .59152 L
.50928 .58341 L
.50931 .57282 L
.50934 .55854 L
.50942 .52184 L
.50954 .43452 L
.5098 .22465 L
.50992 .13413 L
.51003 .06899 L
.51008 .04533 L
.51011 .03599 L
.51014 .02782 L
.51017 .02198 L
.51019 .01972 L
.51021 .01832 L
.51024 .01739 L
.51027 .01876 L
.5103 .02192 L
.51032 .02729 L
.51035 .03422 L
.51038 .04206 L
.51044 .06714 L
.5105 .09792 L
.51074 .27783 L
.51087 .3913 L
.511 .48638 L
.51111 .54985 L
.51114 .56383 L
.51117 .57512 L
.5112 .58426 L
.51123 .59079 L
Mistroke
.51126 .59608 L
.51127 .59805 L
.51129 .5993 L
.51131 .60004 L
.51134 .59872 L
.51136 .59714 L
.51138 .59471 L
.5114 .59139 L
.51141 .58759 L
.51148 .56772 L
.51151 .55444 L
.51154 .53767 L
.5116 .50153 L
.51172 .41798 L
.51198 .20171 L
.51209 .12281 L
.51215 .08841 L
.51221 .05885 L
.51224 .04616 L
.51227 .03493 L
.51229 .0309 L
.51231 .02721 L
.51234 .02221 L
.51235 .02044 L
.51237 .01919 L
.5124 .01874 L
.51243 .02053 L
.51246 .02413 L
.51249 .02992 L
.51252 .03838 L
.51257 .05929 L
.51264 .09288 L
.5127 .1308 L
.51296 .33668 L
.51308 .42954 L
.51318 .50489 L
.51324 .53882 L
.51327 .55394 L
.51331 .56766 L
.51333 .5774 L
.51336 .58603 L
.51339 .59198 L
.51342 .59584 L
.51343 .59743 L
.51345 .59843 L
.51347 .59869 L
.51348 .59832 L
.51351 .59607 L
.51354 .59145 L
.51356 .58818 L
Mistroke
.51358 .584 L
.51361 .57473 L
.51368 .54579 L
.51374 .51064 L
.5138 .47068 L
.51392 .38303 L
.51415 .193 L
.51421 .14819 L
.51427 .10542 L
.51433 .07441 L
.51436 .05962 L
.51439 .0478 L
.51442 .03781 L
.51445 .0306 L
.51448 .02494 L
.5145 .02274 L
.51451 .02127 L
.51454 .02012 L
.51457 .02073 L
.51459 .02324 L
.51462 .028 L
.51465 .03357 L
.51468 .04119 L
.51472 .05906 L
.51478 .08673 L
.51483 .11759 L
.51507 .30042 L
.5152 .40851 L
.51533 .49757 L
.51538 .5305 L
.51544 .55891 L
.51547 .57082 L
.51551 .58146 L
.51554 .58879 L
.51557 .59359 L
.5156 .59631 L
.51562 .59709 L
.51565 .5963 L
.51567 .59382 L
.5157 .58926 L
.51573 .58228 L
.51576 .57375 L
.51579 .56444 L
.5159 .50447 L
.51601 .42893 L
.51626 .22833 L
.51637 .14427 L
.51647 .08141 L
.51653 .05736 L
.51658 .03815 L
Mistroke
.5166 .03415 L
.51661 .03042 L
.51664 .02535 L
.51667 .02254 L
.5167 .02183 L
.51673 .02302 L
.51676 .02639 L
.51679 .03096 L
.51681 .03771 L
.51684 .04703 L
.51688 .05919 L
.51693 .08654 L
.51705 .15791 L
.51715 .23719 L
.51728 .34114 L
.51741 .44609 L
.51752 .52015 L
.51759 .55247 L
.51761 .56423 L
.51765 .57499 L
.51768 .58346 L
.51771 .58931 L
.51773 .59306 L
.51776 .59505 L
.51779 .59507 L
.51781 .59359 L
.51784 .59031 L
.51787 .58483 L
.5179 .57739 L
.51793 .56705 L
.51799 .53961 L
.51811 .47143 L
.51837 .26366 L
.51849 .16698 L
.51861 .09383 L
.51866 .06609 L
.51872 .04386 L
.51875 .03546 L
.51878 .02962 L
.5188 .02716 L
.51882 .0255 L
.51883 .02426 L
.51885 .02378 L
.51888 .02446 L
.51891 .02718 L
.51893 .03163 L
.51896 .03721 L
.51899 .04566 L
.51902 .05697 L
.51908 .08296 L
Mistroke
.51921 .16152 L
.51934 .26599 L
.51947 .37003 L
.51958 .45802 L
.51964 .49546 L
.5197 .53047 L
.51975 .55514 L
.51981 .57559 L
.51984 .58355 L
.51987 .58889 L
.5199 .59223 L
.51992 .59307 L
.51994 .59317 L
.51996 .59191 L
.51999 .58848 L
.52002 .58264 L
.52005 .57518 L
.52011 .55486 L
.52017 .52937 L
.52027 .46756 L
.52049 .28896 L
.52061 .19265 L
.52073 .11537 L
.52079 .08159 L
.52085 .05711 L
.52088 .04682 L
.52091 .03788 L
.52093 .03401 L
.52094 .03109 L
.52096 .02891 L
.52098 .02724 L
.52101 .02595 L
.52103 .02668 L
.52106 .02959 L
.52108 .03188 L
.5211 .03502 L
.52112 .04178 L
.52115 .05102 L
.52121 .07266 L
.52132 .13396 L
.52142 .20551 L
.52164 .38586 L
.52176 .47571 L
.52188 .54103 L
.52194 .56519 L
.52197 .57542 L
.522 .58257 L
.52202 .58566 L
.52203 .58789 L
.52205 .58964 L
Mistroke
.52207 .59069 L
.52209 .5909 L
.52211 .5904 L
.52214 .58763 L
.52217 .58299 L
.5222 .57593 L
.52225 .55796 L
.52231 .53147 L
.52238 .49477 L
.52264 .29786 L
.52277 .19598 L
.52289 .11543 L
.52294 .08522 L
.52299 .06217 L
.52305 .04419 L
.52308 .03731 L
.52311 .03205 L
.52314 .02919 L
.52315 .02846 L
.52317 .02838 L
.5232 .02995 L
.52322 .03184 L
.52323 .03418 L
.52326 .03986 L
.52329 .0481 L
.52335 .06841 L
.52341 .09617 L
.52346 .12767 L
.52358 .21481 L
.52383 .41441 L
.52395 .4912 L
.524 .52251 L
.52405 .54672 L
.52411 .56806 L
.52414 .57637 L
.52415 .5798 L
.52417 .58287 L
.5242 .58665 L
.52423 .58828 L
.52426 .58804 L
.52428 .58625 L
.52431 .5821 L
.52434 .57619 L
.52437 .56929 L
.5244 .56011 L
.52446 .53354 L
.52452 .50225 L
.52474 .3445 L
.52486 .24491 L
.52499 .1473 L
Mistroke
.52505 .10972 L
.52512 .07705 L
.52517 .05557 L
.5252 .04625 L
.52523 .03953 L
.52526 .03483 L
.52529 .03182 L
.52532 .03098 L
.52535 .03194 L
.52537 .03423 L
.5254 .03828 L
.52542 .04422 L
.52545 .05129 L
.52551 .07271 L
.52556 .09825 L
.52568 .17311 L
.52594 .37436 L
.52605 .45803 L
.52611 .49644 L
.52618 .53139 L
.52624 .55651 L
.52626 .5652 L
.52629 .57301 L
.52632 .57871 L
.52634 .58251 L
.52637 .58491 L
.5264 .58564 L
.52643 .58431 L
.52645 .5826 L
.52646 .58042 L
.52649 .57489 L
.52652 .56694 L
.52657 .54829 L
.52663 .52106 L
.52676 .4446 L
.52689 .34323 L
.52713 .15826 L
.52719 .11989 L
.52726 .08561 L
.52729 .07177 L
.52732 .06058 L
.52735 .05219 L
.52738 .04474 L
.52739 .04153 L
.52741 .0387 L
.52742 .03641 L
.52744 .03492 L
.52746 .03407 L
.52747 .03383 L
.5275 .03492 L
Mistroke
.52752 .03642 L
.52754 .03872 L
.52757 .04463 L
.5276 .05352 L
.52764 .06624 L
.5277 .09373 L
.52776 .1252 L
.52789 .21326 L
.52812 .39668 L
.52824 .47653 L
.5283 .51306 L
.52836 .54132 L
.52841 .56149 L
.52844 .57001 L
.52847 .57597 L
.5285 .57955 L
.52852 .58194 L
.52855 .58268 L
.52858 .58177 L
.52861 .57866 L
.52863 .57594 L
.52864 .5728 L
.52867 .56555 L
.5287 .55575 L
.52876 .53135 L
.52882 .50338 L
.52907 .31997 L
.5293 .15122 L
.52941 .0877 L
.52944 .07426 L
.52948 .06203 L
.52951 .05267 L
.52954 .04591 L
.52955 .04291 L
.52957 .04038 L
.52959 .03853 L
.52961 .0373 L
.52962 .03691 L
.52964 .03721 L
.52966 .03815 L
.52967 .03958 L
.5297 .04375 L
.52974 .05046 L
.52977 .05981 L
.5298 .07057 L
.52991 .12749 L
.53004 .21059 L
.53029 .40161 L
.53042 .48911 L
.53048 .52414 L
Mistroke
.53052 .54079 L
.53055 .55356 L
.53058 .56276 L
.53062 .57055 L
.53063 .57381 L
.53065 .57618 L
.53067 .57785 L
.53068 .579 L
.53071 .57941 L
.53074 .57794 L
.53077 .57426 L
.53079 .57125 L
.5308 .5679 L
.53086 .55242 L
.53092 .5286 L
.53104 .4618 L
.53128 .281 L
.5314 .19162 L
.53151 .12144 L
.53157 .09013 L
.53163 .06463 L
.53167 .05482 L
.5317 .04786 L
.53172 .04486 L
.53173 .04277 L
.53175 .04112 L
.53177 .04033 L
.5318 .04061 L
.53183 .04298 L
.53186 .04717 L
.53189 .05258 L
.53192 .06088 L
.53195 .07212 L
.53201 .09813 L
.53248 .42952 L
.53261 .50863 L
.53265 .52663 L
.53268 .54133 L
.53271 .55257 L
.53275 .5622 L
.53278 .56856 L
.53279 .57133 L
.53281 .57336 L
.53284 .57557 L
.53287 .57602 L
.53288 .57545 L
.5329 .57418 L
.53292 .57214 L
.53293 .5696 L
.53296 .5635 L
Mistroke
.533 .55484 L
.53306 .53124 L
.53312 .50267 L
.53325 .4188 L
.53349 .23562 L
.53361 .15666 L
.53371 .09772 L
.53377 .0754 L
.53379 .0661 L
.53382 .05774 L
.53384 .05385 L
.53386 .05079 L
.53389 .04636 L
.53392 .04419 L
.53395 .04383 L
.53398 .0455 L
.53399 .04734 L
.53401 .04965 L
.53404 .05598 L
.53407 .0652 L
.53414 .08802 L
.53419 .11509 L
.53433 .20108 L
.53446 .29827 L
.5347 .46789 L
.53475 .50063 L
.53482 .52986 L
.53485 .54345 L
.53488 .55371 L
.53492 .56185 L
.53495 .56748 L
.53498 .57097 L
.535 .57238 L
.53504 .57192 L
.53507 .56944 L
.53509 .5654 L
.53512 .56021 L
.53515 .55292 L
.53518 .54348 L
.53524 .51821 L
.5353 .48851 L
.53543 .40384 L
.53564 .24426 L
.53575 .16628 L
.53587 .10021 L
.53593 .07529 L
.53597 .06446 L
.536 .05665 L
.53603 .05157 L
.53606 .04867 L
Mistroke
.53609 .04746 L
.5361 .04763 L
.53612 .04842 L
.53615 .05153 L
.53618 .05621 L
.53621 .06375 L
.53624 .07291 L
.5363 .0939 L
.53636 .12285 L
.53659 .27843 L
.5368 .43517 L
.53692 .5015 L
.53698 .53012 L
.53701 .54113 L
.53704 .54976 L
.53706 .5569 L
.53709 .56193 L
.53712 .5659 L
.53715 .5682 L
.53717 .56859 L
.5372 .5673 L
.53723 .56445 L
.53725 .56046 L
.53728 .55417 L
.53731 .54553 L
.53737 .52519 L
.53744 .49373 L
.5375 .45913 L
.53775 .27699 L
.53787 .1939 L
.53793 .15342 L
.53799 .12027 L
.53804 .09477 L
.53809 .07619 L
.53812 .06834 L
.53815 .06142 L
.53818 .05626 L
.53821 .05281 L
.53823 .05182 L
.53824 .0514 L
.53826 .05162 L
.53827 .05235 L
.5383 .05514 L
.53833 .06005 L
.53837 .06753 L
.5384 .07652 L
.53847 .10377 L
.53858 .16693 L
.53871 .25223 L
.53895 .42924 L
Mistroke
.53902 .47071 L
.53909 .50802 L
.53915 .53316 L
.53918 .54382 L
.53922 .55275 L
.53925 .55851 L
.53926 .56094 L
.53928 .56265 L
.53931 .56436 L
.53934 .56435 L
.53935 .5635 L
.53937 .5619 L
.53939 .55974 L
.53941 .55719 L
.53944 .55094 L
.53947 .54231 L
.53952 .52162 L
.53958 .49684 L
.5397 .42442 L
.53995 .2442 L
.54007 .16214 L
.54013 .12844 L
.54019 .10263 L
.54024 .0824 L
.54029 .0683 L
.54032 .06272 L
.54034 .05898 L
.54037 .05643 L
.5404 .05554 L
.54043 .0564 L
.54046 .05914 L
.54049 .06343 L
.54051 .06877 L
.54054 .07671 L
.54057 .08734 L
.54063 .11168 L
.5411 .42184 L
.54123 .49591 L
.5413 .52677 L
.54133 .53816 L
.54136 .54672 L
.54139 .55259 L
.54142 .55706 L
.54144 .55877 L
.54145 .55981 L
.54149 .56027 L
.5415 .55976 L
.54152 .55865 L
.54155 .55525 L
.54158 .54958 L
Mistroke
.54161 .54098 L
.54168 .51942 L
.54174 .49241 L
.54185 .42757 L
.5421 .24875 L
.54221 .17808 L
.54232 .11668 L
.54238 .09034 L
.54244 .07321 L
.54247 .06738 L
.5425 .06294 L
.54253 .06055 L
.54256 .0599 L
.54259 .061 L
.54262 .06384 L
.54264 .06787 L
.54267 .0738 L
.5427 .08204 L
.54273 .09275 L
.54279 .11673 L
.54289 .17272 L
.54301 .24848 L
.54314 .34392 L
.54327 .4299 L
.54338 .49339 L
.54345 .52077 L
.54351 .53956 L
.54354 .54624 L
.54357 .55153 L
.5436 .55463 L
.54362 .55583 L
.54365 .55556 L
.54368 .55376 L
.54371 .55024 L
.54373 .54545 L
.54376 .53804 L
.54379 .52927 L
.54385 .50852 L
.54397 .44404 L
.54422 .27762 L
.54435 .18781 L
.54441 .14974 L
.54447 .11988 L
.54453 .09854 L
.54458 .0808 L
.54461 .07404 L
.54464 .06934 L
.54467 .06607 L
.5447 .06452 L
.54472 .06453 L
Mistroke
.54473 .06506 L
.54475 .06622 L
.54477 .06811 L
.5448 .07278 L
.54483 .08005 L
.54489 .0991 L
.54495 .12307 L
.54506 .18335 L
.54516 .25004 L
.54539 .40896 L
.54551 .47599 L
.54557 .50525 L
.54563 .52676 L
.54566 .53442 L
.54569 .541 L
.54572 .54637 L
.54575 .54958 L
.54577 .55102 L
.5458 .55113 L
.54582 .54989 L
.54585 .54698 L
.54587 .54459 L
.54588 .54147 L
.54591 .53443 L
.54598 .51192 L
.54604 .48571 L
.54611 .45056 L
.54635 .2931 L
.54647 .21333 L
.54658 .14913 L
.54664 .12052 L
.54669 .0995 L
.54672 .09041 L
.54675 .08232 L
.54677 .07867 L
.54678 .07583 L
.54681 .07171 L
.54685 .06954 L
.54687 .06933 L
.54689 .06999 L
.54691 .0711 L
.54692 .07296 L
.54694 .07531 L
.54697 .08164 L
.54701 .08943 L
.54708 .11355 L
.54714 .14114 L
.54719 .17067 L
.54732 .24835 L
.54754 .40215 L
Mistroke
.54766 .47314 L
.54772 .50058 L
.54778 .52043 L
.54781 .52876 L
.54784 .53604 L
.54786 .53923 L
.54787 .54166 L
.5479 .54498 L
.54794 .54635 L
.54795 .54623 L
.54797 .54553 L
.54799 .54418 L
.548 .5424 L
.54802 .53971 L
.54804 .53651 L
.5481 .52144 L
.54815 .50176 L
.54828 .43981 L
.54853 .2727 L
.54866 .19237 L
.54871 .16144 L
.54877 .13185 L
.54882 .11115 L
.54888 .09373 L
.54891 .08638 L
.54893 .08115 L
.54896 .07734 L
.54899 .07509 L
.54902 .07416 L
.54905 .07489 L
.54907 .0769 L
.5491 .08061 L
.54913 .08626 L
.54916 .09427 L
.54922 .11355 L
.54969 .39774 L
.54982 .47074 L
.54989 .50214 L
.54993 .51406 L
.54996 .52324 L
.54999 .53012 L
.55002 .53583 L
.55004 .53801 L
.55005 .53956 L
.55007 .54067 L
.55009 .54127 L
.5501 .54128 L
.55012 .54076 L
.55015 .53836 L
.55018 .53426 L
Mistroke
.55021 .52892 L
.55027 .51257 L
.55033 .48798 L
.55045 .42808 L
.55067 .28628 L
.55079 .2063 L
.55086 .16775 L
.55093 .13681 L
.55098 .11339 L
.55104 .09705 L
.55107 .09002 L
.5511 .08496 L
.55113 .08134 L
.55114 .08009 L
.55116 .07945 L
.55119 .07953 L
.55122 .08131 L
.55124 .0842 L
.55127 .08877 L
.5513 .09535 L
.55133 .10418 L
.55139 .12454 L
.55151 .17917 L
.55161 .24111 L
.55173 .32362 L
.55187 .40829 L
.55193 .442 L
.55199 .4737 L
.55205 .49656 L
.55208 .50738 L
.5521 .51595 L
.55213 .52303 L
.55216 .52893 L
.55219 .53266 L
.55222 .53521 L
.55225 .53609 L
.55227 .53557 L
.5523 .53368 L
.55232 .53077 L
.55235 .52582 L
.55238 .51982 L
.55244 .50139 L
.5525 .47752 L
.55257 .44638 L
.55283 .28514 L
.55294 .21322 L
.55301 .17663 L
.55307 .14668 L
.55313 .12132 L
.55319 .10354 L
Mistroke
.55322 .09618 L
.55325 .09083 L
.55328 .08695 L
.5533 .08558 L
.55331 .08484 L
.55333 .08461 L
.55335 .08497 L
.55336 .08588 L
.55338 .08721 L
.55341 .09101 L
.55344 .09681 L
.55348 .10504 L
.55351 .11452 L
.55358 .14204 L
.5537 .20466 L
.55381 .27322 L
.55393 .35175 L
.55406 .4289 L
.55418 .48303 L
.55421 .49476 L
.55424 .50568 L
.55427 .5136 L
.5543 .5206 L
.55433 .52544 L
.55436 .52854 L
.55439 .53034 L
.55442 .53058 L
.55444 .52922 L
.55447 .52655 L
.5545 .52302 L
.55452 .51802 L
.55458 .50196 L
.55465 .47754 L
.55478 .41049 L
.55502 .26099 L
.55515 .18755 L
.55521 .15682 L
.55526 .13275 L
.55532 .11522 L
.55534 .10794 L
.55537 .10143 L
.5554 .09593 L
.55543 .0924 L
.55546 .09052 L
.55549 .09014 L
.55552 .09124 L
.55555 .09416 L
.55558 .09854 L
.5556 .10387 L
.55567 .12213 L
Mistroke
.55573 .14566 L
.55586 .20732 L
.55599 .28853 L
.55611 .363 L
.55624 .43555 L
.5563 .46491 L
.55636 .48814 L
.55641 .50454 L
.55644 .51175 L
.55647 .51715 L
.5565 .52162 L
.55653 .5241 L
.55656 .5251 L
.55657 .52489 L
.55659 .5242 L
.55662 .522 L
.55665 .51809 L
.55668 .51237 L
.55671 .50555 L
.55677 .48448 L
.55683 .45948 L
.55697 .38755 L
.55719 .25102 L
.55732 .18307 L
.55743 .1336 L
.55749 .11536 L
.55752 .10761 L
.55755 .10218 L
.55758 .09829 L
.5576 .09688 L
.55762 .09609 L
.55764 .09579 L
.55765 .09602 L
.55767 .09686 L
.55769 .09822 L
.55772 .10169 L
.55775 .10698 L
.55777 .11278 L
.5578 .12049 L
.55787 .14236 L
.55793 .16812 L
.55814 .28886 L
.55837 .42398 L
.55844 .45661 L
.55851 .48196 L
.55856 .49957 L
.5586 .50714 L
.55863 .51252 L
.55865 .51619 L
.55868 .51835 L
Mistroke
.55871 .51932 L
.55874 .51871 L
.55876 .51777 L
.55877 .51626 L
.5588 .51225 L
.55883 .5068 L
.55886 .50044 L
.55892 .4822 L
.55898 .46021 L
.55911 .39597 L
.55937 .24049 L
.55948 .18049 L
.55954 .15335 L
.5596 .13266 L
.55966 .1158 L
.5597 .10945 L
.55972 .10671 L
.55973 .10472 L
.55976 .10242 L
.55978 .10179 L
.55979 .10165 L
.55982 .10248 L
.55985 .10487 L
.55988 .1087 L
.55991 .11452 L
.55997 .12932 L
.56003 .1486 L
.56008 .17029 L
.56032 .30379 L
.56053 .42357 L
.56059 .45051 L
.56065 .47447 L
.56071 .49077 L
.56074 .49811 L
.56076 .50377 L
.56079 .50848 L
.56082 .51141 L
.56085 .51311 L
.56087 .51339 L
.56088 .51323 L
.56091 .51204 L
.56094 .50941 L
.56097 .50521 L
.56099 .49995 L
.56105 .48601 L
.5611 .46935 L
.56121 .42019 L
.56147 .27475 L
.56159 .20602 L
.56171 .15536 L
Mistroke
.56176 .13663 L
.56179 .12851 L
.56182 .12132 L
.56185 .11623 L
.56188 .11199 L
.5619 .10937 L
.56193 .108 L
.56196 .10777 L
.56199 .10901 L
.56201 .11133 L
.56204 .11514 L
.56207 .12077 L
.5621 .12838 L
.56216 .14608 L
.56228 .19735 L
.5624 .25819 L
.56252 .33034 L
.56266 .40542 L
.56272 .43385 L
.56278 .46004 L
.56284 .47855 L
.5629 .49371 L
.56291 .49705 L
.56293 .50009 L
.56295 .50243 L
.56296 .50421 L
.56299 .50652 L
.56301 .50712 L
.56303 .50729 L
.56306 .50629 L
.56309 .50379 L
.56312 .50026 L
.56314 .49507 L
.5632 .48071 L
.56326 .4634 L
.56338 .41208 L
.56359 .29449 L
.56371 .22956 L
.56383 .17145 L
.56388 .15237 L
.56394 .13583 L
.56397 .12831 L
.564 .12279 L
.56403 .11855 L
.56405 .11577 L
.56408 .11416 L
.56411 .11398 L
.56413 .11452 L
.56415 .11557 L
.56418 .11869 L
Mistroke
.56421 .12334 L
.56424 .12914 L
.56429 .14353 L
.56436 .16577 L
.56442 .19094 L
.56455 .25981 L
.56467 .32802 L
.56481 .39865 L
.56487 .42716 L
.56493 .45325 L
.56499 .47176 L
.56502 .48017 L
.56505 .48689 L
.56507 .49213 L
.5651 .49648 L
.56513 .49919 L
.56516 .50063 L
.56518 .50103 L
.56521 .50041 L
.56523 .49857 L
.56526 .49575 L
.56529 .49139 L
.56532 .48543 L
.56537 .47143 L
.56543 .45194 L
.56549 .426 L
.56573 .30009 L
.56585 .23612 L
.56596 .18484 L
.56602 .16185 L
.56609 .14184 L
.56612 .13388 L
.56616 .12803 L
.56617 .12552 L
.56619 .12359 L
.56621 .12189 L
.56623 .12085 L
.56626 .12019 L
.56629 .12096 L
.56632 .12306 L
.56634 .1261 L
.56637 .13106 L
.56641 .13805 L
.56647 .15477 L
.56694 .38347 L
.56707 .44084 L
.56714 .46529 L
.56717 .47449 L
.5672 .48154 L
.56723 .48682 L
Mistroke
.56726 .49096 L
.5673 .49356 L
.56731 .49434 L
.56733 .49461 L
.56736 .49396 L
.56739 .49208 L
.56742 .48864 L
.56744 .48637 L
.56745 .48348 L
.56752 .46869 L
.56758 .44964 L
.56769 .40297 L
.56794 .27135 L
.56805 .21827 L
.56816 .17188 L
.56822 .1533 L
.56825 .1453 L
.56829 .13823 L
.56832 .13318 L
.56835 .12982 L
.56837 .12766 L
.5684 .12674 L
.56843 .12705 L
.56845 .12783 L
.56846 .12894 L
.56849 .13195 L
.56852 .13646 L
.56858 .14742 L
.56863 .16371 L
.56876 .21338 L
.56888 .27134 L
.56909 .38061 L
.5692 .42956 L
.56926 .45119 L
.56932 .46734 L
.56935 .47456 L
.56938 .47986 L
.56942 .48423 L
.56943 .48594 L
.56945 .4871 L
.56948 .48802 L
.56951 .48766 L
.56954 .48591 L
.56956 .48431 L
.56957 .48249 L
.5696 .47785 L
.56963 .47239 L
.5697 .45607 L
.56981 .41418 L
.57003 .30972 L
Mistroke
.57026 .19941 L
.57032 .17617 L
.57038 .15827 L
.57043 .14608 L
.57046 .14093 L
.57049 .13732 L
.57052 .135 L
.57054 .13372 L
.57057 .13334 L
.5706 .13412 L
.57063 .13611 L
.57066 .13951 L
.57068 .14344 L
.57071 .14879 L
.57077 .16524 L
.57083 .18464 L
.57097 .24044 L
.57121 .35929 L
.57132 .41157 L
.57139 .43546 L
.57145 .45385 L
.5715 .46605 L
.57152 .471 L
.57155 .47532 L
.57158 .47872 L
.57161 .48066 L
.57164 .48133 L
.57167 .48088 L
.5717 .47901 L
.57172 .47733 L
.57173 .47539 L
.57176 .47085 L
.57179 .46473 L
.57185 .45102 L
.57191 .43188 L
.57217 .31711 L
.57228 .26037 L
.57241 .20538 L
.57247 .18448 L
.57253 .16618 L
.57258 .15415 L
.57261 .1489 L
.57264 .14506 L
.57265 .1434 L
.57267 .14197 L
.57269 .14091 L
.5727 .14032 L
.57273 .14022 L
.57276 .14147 L
.57278 .14279 L
Mistroke
.5728 .14471 L
.57283 .14951 L
.57287 .15573 L
.5729 .16278 L
.57302 .19915 L
.57314 .25095 L
.57337 .35972 L
.57349 .41287 L
.57355 .4343 L
.57361 .45051 L
.57366 .46212 L
.57369 .46659 L
.57372 .47038 L
.57375 .47295 L
.57377 .47385 L
.57378 .47433 L
.57381 .47435 L
.57384 .47315 L
.57387 .47118 L
.57389 .46812 L
.57392 .46434 L
.57394 .46017 L
.574 .44714 L
.57405 .43141 L
.57449 .239 L
.57461 .19284 L
.57468 .17292 L
.57471 .1653 L
.57474 .15935 L
.57477 .15449 L
.5748 .15111 L
.57483 .14854 L
.57484 .14766 L
.57486 .14717 L
.57489 .14716 L
.57491 .14814 L
.57494 .1503 L
.57497 .15379 L
.575 .15837 L
.57503 .16352 L
.57509 .17833 L
.5752 .21491 L
.57545 .32546 L
.57557 .3807 L
.57564 .40639 L
.57571 .42969 L
.57577 .44594 L
.5758 .45284 L
.57584 .45884 L
.57585 .46103 L
Mistroke
.57587 .46299 L
.5759 .46562 L
.57593 .46706 L
.57596 .46748 L
.57599 .46662 L
.57602 .46463 L
.57603 .46314 L
.57605 .46115 L
.57608 .45602 L
.57614 .44302 L
.5762 .42693 L
.57643 .33876 L
.57655 .28258 L
.57669 .22578 L
.57675 .20366 L
.57681 .18392 L
.57684 .17595 L
.57687 .16951 L
.5769 .16431 L
.57693 .16039 L
.57696 .15728 L
.57699 .15506 L
.57702 .15413 L
.57704 .15413 L
.57705 .15446 L
.57708 .15584 L
.57711 .15845 L
.57714 .16198 L
.57716 .16613 L
.57722 .17834 L
.57729 .19611 L
.57742 .24324 L
.57765 .34289 L
.57776 .38895 L
.57786 .42399 L
.57792 .43857 L
.57798 .45025 L
.578 .4527 L
.57801 .45498 L
.57803 .45667 L
.57805 .45811 L
.57808 .45988 L
.57811 .46038 L
.57813 .4599 L
.57816 .45839 L
.57819 .45602 L
.57821 .45308 L
.57827 .44285 L
.57833 .42943 L
.57845 .38915 L
Mistroke
.57857 .3426 L
.5787 .28809 L
.57883 .23295 L
.57889 .21238 L
.57895 .19383 L
.57901 .18001 L
.57904 .17457 L
.57906 .1704 L
.57909 .16715 L
.57911 .16442 L
.57914 .16244 L
.57917 .16145 L
.57919 .16133 L
.57922 .16233 L
.57925 .16409 L
.57928 .16698 L
.57931 .17155 L
.57934 .17706 L
.5794 .1903 L
.57953 .23194 L
.57977 .32992 L
.57989 .37749 L
.58 .4147 L
.58007 .43064 L
.5801 .43745 L
.58013 .44337 L
.58016 .4473 L
.58018 .44899 L
.58019 .45048 L
.58022 .4523 L
.58025 .45308 L
.58028 .45292 L
.58031 .45181 L
.58034 .44955 L
.58035 .448 L
.58037 .44598 L
.58043 .43649 L
.58048 .4243 L
.58058 .39424 L
.58069 .35386 L
.58094 .25264 L
.58106 .21121 L
.58112 .19679 L
.58117 .18424 L
.58121 .17885 L
.58123 .17486 L
.58126 .17194 L
.58129 .16982 L
.58132 .16869 L
.58135 .16866 L
Mistroke
.58138 .16976 L
.5814 .17089 L
.58142 .17225 L
.58145 .17605 L
.58148 .18072 L
.58155 .19513 L
.58161 .21183 L
.58168 .23305 L
.58191 .31979 L
.58202 .36558 L
.58215 .4063 L
.5822 .41994 L
.58226 .43158 L
.58229 .43678 L
.58232 .44051 L
.58235 .44327 L
.58238 .44496 L
.5824 .4457 L
.58243 .44567 L
.58245 .44498 L
.58248 .44351 L
.5825 .44111 L
.58253 .43762 L
.58259 .42896 L
.58265 .41551 L
.58271 .39753 L
.58283 .35789 L
.58309 .25626 L
.58316 .2348 L
.58322 .21446 L
.58328 .19961 L
.58332 .19289 L
.58335 .18757 L
.58338 .1833 L
.5834 .18024 L
.58343 .17779 L
.58345 .17688 L
.58347 .1763 L
.58349 .17596 L
.58352 .1764 L
.58355 .17772 L
.58358 .18005 L
.5836 .18306 L
.58363 .18726 L
.58369 .19848 L
.5838 .2266 L
.58405 .31338 L
.58415 .35378 L
.58427 .3922 L
.58432 .40674 L
Mistroke
.58438 .41947 L
.58443 .4279 L
.58446 .43162 L
.58448 .43438 L
.5845 .43567 L
.58452 .43679 L
.58455 .43805 L
.58458 .43831 L
.5846 .43769 L
.58462 .43691 L
.58464 .4359 L
.58467 .4333 L
.5847 .42949 L
.58473 .42422 L
.58479 .41298 L
.58485 .39808 L
.58496 .36512 L
.5852 .27694 L
.58533 .23287 L
.5854 .21515 L
.58546 .20188 L
.58552 .19243 L
.58555 .1889 L
.58558 .18602 L
.58559 .18494 L
.58561 .18421 L
.58563 .18369 L
.58564 .18348 L
.58567 .18387 L
.58569 .18451 L
.58571 .18537 L
.58574 .18769 L
.58576 .19069 L
.58582 .19833 L
.58587 .20935 L
.58593 .22421 L
.58616 .29856 L
.58637 .37185 L
.58648 .40169 L
.58654 .41437 L
.5866 .42295 L
.58663 .42646 L
.58666 .42879 L
.58668 .42965 L
.58669 .43032 L
.58671 .4307 L
.58673 .43075 L
.58676 .4301 L
.58679 .42866 L
.58682 .42617 L
Mistroke
.58685 .42252 L
.58691 .41307 L
.58698 .39946 L
.58709 .36739 L
.58736 .27772 L
.58748 .24052 L
.58754 .22349 L
.5876 .21039 L
.58767 .19982 L
.5877 .19584 L
.58772 .19413 L
.58774 .19289 L
.58777 .1915 L
.58779 .19115 L
.58781 .19111 L
.58784 .19173 L
.58785 .19248 L
.58787 .1934 L
.5879 .1959 L
.58793 .19949 L
.58799 .20827 L
.58805 .22081 L
.58812 .23777 L
.58835 .31231 L
.58847 .35026 L
.58859 .38586 L
.58865 .39892 L
.58871 .40998 L
.58876 .41687 L
.58879 .41969 L
.58882 .42157 L
.58884 .42229 L
.58885 .42282 L
.58887 .42308 L
.58889 .42305 L
.58892 .42236 L
.58895 .42071 L
.58897 .41936 L
.58899 .41758 L
.58902 .4135 L
.58908 .40306 L
.58915 .39032 L
.58921 .37415 L
.58932 .34008 L
.58955 .26738 L
.58968 .23347 L
.58974 .22029 L
.5898 .21065 L
.58982 .20697 L
.58985 .20412 L
Mistroke
.58988 .20158 L
.58991 .19998 L
.58994 .19899 L
.58996 .19883 L
.58999 .19948 L
.59001 .20012 L
.59003 .20108 L
.59005 .20321 L
.59008 .20573 L
.59013 .21337 L
.59019 .2227 L
.59024 .23333 L
.59045 .29291 L
.59067 .36197 L
.59074 .37896 L
.5908 .39259 L
.59086 .40236 L
.59089 .40679 L
.59092 .41004 L
.59095 .41257 L
.59098 .41422 L
.59101 .41516 L
.59103 .41534 L
.59105 .41527 L
.59107 .41466 L
.5911 .41329 L
.59113 .411