(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    261713,       7316]*)
(*NotebookOutlinePosition[    262615,       7348]*)
(*  CellTagsIndexPosition[    262571,       7344]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(Off[General::spell]\), "\[IndentingNewLine]", 
    \(Off[General::spell1]\)}], "Input"],

Cell["Clear[\"Global`*\"];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  StyleBox["Replace  path with your specific  path:\n",
    FontSize->14],
  StyleBox["(Or, if you are in a hurry, just open up the file loadCTEQ5.m  \
and execute the initialization.)",
    FontSize->10,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Subsubsection",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell["<<\"/Net/thy2/olness/mathload/CTEQ5/loadCTEQ5.m\"", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    \(TraditionalForm\`"Loading Package: PDF"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"PDF's from CTEQ5"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"Eur.Phys.J.C12:375-392,2000 "\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"*** Warning *** Unofficial release. "\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"*** Cross-check with official Fortran code."\)], \
"Print"],

Cell[BoxData[
    \(TraditionalForm\`" Version 1.0: Written by Tamara Trout & Fred Olness, \
October 1, 2000"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`" "\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"In case of problems, contact:"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"Fred Olness: olness@mail.physics.smu.edu"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["pdf[x__]=cteq5pdf[x]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`cteq5pdf(x)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define LogLogPlot", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["Needs[\"Graphics`Graphics`\"]", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defined functions", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["?cteq5pdf", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`"cteq5pdf[iset, iparton, x, q] The function call is: \
cteq5pdf[iset, iparton, x, q]"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["??name", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`"name[iset] Gives the names of the pdf set "\)], \
"Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {\(Attributes[name] = {Protected}\)},
            {" "},
            {GridBox[{
                  {\(name(1) = "CTEQ5 Set  1: CTEQ5M. "\)},
                  {" "},
                  {\(name(2) = 
                      "CTEQ5 Set  2: CTEQ5D.  *** not yet implemented *** \
"\)},
                  {" "},
                  {\(name(3) = 
                      "CTEQ5 Set  3: CTEQ5L. LO (evolution) version of \
CTEQ5M."\)}
                  },
                GridBaseline->{Baseline, {1, 1}},
                ColumnWidths->0.999,
                ColumnAlignments->{Left}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        Definition[ name],
        Editable->False], TraditionalForm]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["parton[-3]", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`"s-bar quark"\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["{pdf[1,0,.1,10.],pdf[51,0,.1,10.]}", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`{11.627826082393835`, 
      cteq5pdf(51, 0, 0.1`, 10.`)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examine pdf vs. x", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
iset=1;
iparton=1;
q0=2;

Plot[x pdf[iset,iparton,x,q0] //Evaluate
 ,{x,0.01,1}
 ,PlotLabel->parton[iparton]
 ];\
\>", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.826262 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .09734 -18 -4.5 ]
[.01131 .09734 0 4.5 ]
[.01131 .17997 -18 -4.5 ]
[.01131 .17997 0 4.5 ]
[.01131 .26259 -18 -4.5 ]
[.01131 .26259 0 4.5 ]
[.01131 .34522 -18 -4.5 ]
[.01131 .34522 0 4.5 ]
[.01131 .42785 -18 -4.5 ]
[.01131 .42785 0 4.5 ]
[.01131 .51047 -18 -4.5 ]
[.01131 .51047 0 4.5 ]
[.01131 .5931 -18 -4.5 ]
[.01131 .5931 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09734 m
.03006 .09734 L
s
[(0.1)] .01131 .09734 1 0 Mshowa
.02381 .17997 m
.03006 .17997 L
s
[(0.2)] .01131 .17997 1 0 Mshowa
.02381 .26259 m
.03006 .26259 L
s
[(0.3)] .01131 .26259 1 0 Mshowa
.02381 .34522 m
.03006 .34522 L
s
[(0.4)] .01131 .34522 1 0 Mshowa
.02381 .42785 m
.03006 .42785 L
s
[(0.5)] .01131 .42785 1 0 Mshowa
.02381 .51047 m
.03006 .51047 L
s
[(0.6)] .01131 .51047 1 0 Mshowa
.02381 .5931 m
.03006 .5931 L
s
[(0.7)] .01131 .5931 1 0 Mshowa
.125 Mabswid
.02381 .03124 m
.02756 .03124 L
s
.02381 .04777 m
.02756 .04777 L
s
.02381 .06429 m
.02756 .06429 L
s
.02381 .08082 m
.02756 .08082 L
s
.02381 .11387 m
.02756 .11387 L
s
.02381 .13039 m
.02756 .13039 L
s
.02381 .14692 m
.02756 .14692 L
s
.02381 .16344 m
.02756 .16344 L
s
.02381 .19649 m
.02756 .19649 L
s
.02381 .21302 m
.02756 .21302 L
s
.02381 .22954 m
.02756 .22954 L
s
.02381 .24607 m
.02756 .24607 L
s
.02381 .27912 m
.02756 .27912 L
s
.02381 .29564 m
.02756 .29564 L
s
.02381 .31217 m
.02756 .31217 L
s
.02381 .32869 m
.02756 .32869 L
s
.02381 .36175 m
.02756 .36175 L
s
.02381 .37827 m
.02756 .37827 L
s
.02381 .3948 m
.02756 .3948 L
s
.02381 .41132 m
.02756 .41132 L
s
.02381 .44437 m
.02756 .44437 L
s
.02381 .4609 m
.02756 .4609 L
s
.02381 .47742 m
.02756 .47742 L
s
.02381 .49395 m
.02756 .49395 L
s
.02381 .527 m
.02756 .527 L
s
.02381 .54352 m
.02756 .54352 L
s
.02381 .56005 m
.02756 .56005 L
s
.02381 .57657 m
.02756 .57657 L
s
.02381 .60962 m
.02756 .60962 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03333 .35144 m
.05195 .41344 L
.07158 .46574 L
.09318 .51159 L
.1133 .54502 L
.1315 .56826 L
.15097 .58627 L
.16109 .59298 L
.16641 .59581 L
.17206 .59831 L
.177 .60006 L
.18243 .60155 L
.18481 .60206 L
.18737 .60251 L
.18979 .60284 L
.192 .60307 L
.19328 .60316 L
.19448 .60323 L
.19555 .60328 L
.19672 .60331 L
.19799 .60332 L
.19864 .60331 L
.19934 .6033 L
.20059 .60327 L
.20175 .60321 L
.20292 .60314 L
.20403 .60305 L
.20612 .60284 L
.20836 .60254 L
.2108 .60214 L
.21597 .60103 L
.22145 .59946 L
.23131 .59569 L
.24059 .59107 L
.25059 .58499 L
.26869 .57135 L
.30942 .53016 L
.34864 .48042 L
.38637 .42697 L
.42653 .36752 L
.46518 .31058 L
.50626 .25286 L
.54585 .20178 L
.58393 .15805 L
.62444 .11815 L
.66345 .08655 L
.70095 .06247 L
.72182 .05164 L
.74089 .04327 L
.77933 .03041 L
Mistroke
.79816 .02586 L
.81869 .02204 L
.8382 .01935 L
.84911 .0182 L
.85898 .01734 L
.86827 .01668 L
.87807 .01613 L
.88882 .01565 L
.8987 .01533 L
.90811 .0151 L
.91338 .01501 L
.91818 .01493 L
.92265 .01488 L
.92751 .01483 L
.9321 .0148 L
.93634 .01477 L
.94094 .01475 L
.94353 .01474 L
.9459 .01474 L
.95027 .01473 L
.95246 .01472 L
.95486 .01472 L
.95624 .01472 L
.95754 .01472 L
.95998 .01472 L
.96134 .01472 L
.9626 .01472 L
.96398 .01472 L
.96544 .01472 L
.96661 .01472 L
.96786 .01472 L
.96904 .01472 L
.97012 .01472 L
.97139 .01472 L
.9721 .01472 L
.97276 .01472 L
.97398 .01472 L
.97527 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo000n0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo1000000>0?ooo`00?@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`0=0?ooo`00?@3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`00000?0?ooo`007P3oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo
0=<0oooo000N0?ooo`030000003oool0oooo0=<0oooo000I0?ooom4000002P3oool001h0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`h000001`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool00P3oool4000001l0oooo00<000000?ooo`3oool03@3oool001h0oooo00<000000?oo
o`3oool0W03oool4000003<0oooo000N0?ooo`030000003oool0oooo09P0oooo1000000g0?ooo`00
7P3oool00`000000oooo0?ooo`2D0?ooo`@00000>`3oool001h0oooo00<000000?ooo`3oool0T@3o
ool3000003l0oooo000N0?ooo`030000003oool0oooo08l0oooo0P0000120?ooo`007P3oool00`00
0000oooo0?ooo`2=0?ooo`800000A03oool001h0oooo00<000000?ooo`3oool0R`3oool2000004H0
oooo000N0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0AP3oool001h0oooo00<0
00000?ooo`3oool0R03oool2000004T0oooo000N0?ooo`030000003oool0oooo08H0oooo0P00001;
0?ooo`007P3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo04/0oooo000N0?ooo`03
0000003oool0oooo08<0oooo0P00001>0?ooo`007P3oool00`000000oooo0?ooo`220?ooo`030000
003oool0oooo04h0oooo000;0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@00000103o
ool00`000000oooo0?ooo`210?ooo`030000003oool0oooo04l0oooo000:0?ooo`040000003oool0
oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`200?ooo`030000003o
ool0oooo0500oooo000:0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3o
ool2000007l0oooo0P00001C0?ooo`002P3oool010000000oooo0?ooo`00000:0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`1C0?ooo`002P3oool0
10000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0O03o
ool00`000000oooo0?ooo`1D0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`<000001@3o
ool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo05D0oooo000;0?ooo`8000002`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0EP3oool0
01h0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`1G0?ooo`007P3oool00`000000
oooo0?ooo`1h0?ooo`030000003oool0oooo05P0oooo000N0?ooo`030000003oool0oooo07L0oooo
00<000000?ooo`3oool0F@3oool001h0oooo00<000000?ooo`3oool0M@3oool2000005`0oooo000N
0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0G03oool001h0oooo00<000000?oo
o`3oool0L`3oool00`000000oooo0?ooo`1M0?ooo`007P3oool00`000000oooo0?ooo`1b0?ooo`03
0000003oool0oooo05h0oooo000N0?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool0
G`3oool001h0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`1P0?ooo`007P3oool0
0`000000oooo0?ooo`1_0?ooo`030000003oool0oooo0640oooo000;0?ooo`800000103oool00`00
0000oooo0?ooo`020?ooo`@00000103oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo
0680oooo000:0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`1]0?ooo`030000003oool0oooo06<0oooo000:0?ooo`040000003oool0oooo0000
00T0oooo00<000000?ooo`3oool0103oool2000006h0oooo00<000000?ooo`3oool0H`3oool000X0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
06`0oooo00<000000?ooo`3oool0I03oool000X0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0I@3oool000X0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo06X0oooo00<000000?ooo`3oool0IP3oool000/0oooo0P00000:0?ooo`8000001@3oool00`00
0000oooo0?ooo`1Y0?ooo`030000003oool0oooo06L0oooo000N0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0J03oool001h0oooo00<000000?ooo`3oool0J03oool00`000000oooo
0?ooo`1X0?ooo`007P3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo06T0oooo000N
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0JP3oool001h0oooo00<000000?oo
o`3oool0I@3oool00`000000oooo0?ooo`1[0?ooo`007P3oool00`000000oooo0?ooo`1U0?ooo`03
0000003oool0oooo06/0oooo000N0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0
K03oool001h0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1]0?ooo`007P3oool0
0`000000oooo0?ooo`1R0?ooo`030000003oool0oooo06h0oooo000N0?ooo`030000003oool0oooo
0680oooo00<000000?ooo`3oool0KP3oool000/0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0P0000050?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0K`3oool000X0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0600oooo00<000000?ooo`3oool0L03oool000X0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`020?ooo`800000H@3oool00`000000oooo0?ooo`1`0?ooo`002P3oool010000000
oooo0?ooo`0000090?ooo`8000001@3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo
0740oooo000:0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`1N0?ooo`030000003oool0oooo0780oooo000:0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1N0?ooo`030000003oool0
oooo0780oooo000;0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0G@3oool00`00
0000oooo0?ooo`1c0?ooo`007P3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo07@0
oooo000N0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0M03oool001h0oooo00<0
00000?ooo`3oool0F`3oool00`000000oooo0?ooo`1e0?ooo`007P3oool00`000000oooo0?ooo`1J
0?ooo`030000003oool0oooo07H0oooo000N0?ooo`030000003oool0oooo05X0oooo00<000000?oo
o`3oool0MP3oool001h0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1g0?ooo`00
7P3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo07P0oooo000N0?ooo`030000003o
ool0oooo05P0oooo00<000000?ooo`3oool0N03oool001h0oooo00<000000?ooo`3oool0E`3oool0
0`000000oooo0?ooo`1i0?ooo`007P3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo
07X0oooo000;0?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1j0?ooo`002P3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`1k0?ooo`002P3oool010000000oooo0?ooo`0000070?ooo`D00000103oool2000005D0
oooo00<000000?ooo`3oool0O03oool000X0oooo00@000000?ooo`3oool000001`3oool010000000
oooo0?ooo`0000050?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0O03oool000X0
oooo00@000000?ooo`3oool00000203oool00`000000oooo000000050?ooo`030000003oool00000
05<0oooo00<000000?ooo`3oool0O@3oool000X0oooo00@000000?ooo`3oool000002@3oool20000
00D0oooo00<000000?ooo`000000DP3oool00`000000oooo0?ooo`1n0?ooo`002`3oool2000000/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0000001B0?ooo`030000003oool0oooo07h0
oooo000N0?ooo`040000003oool0oooo00000500oooo00<000000?ooo`3oool0O`3oool001h0oooo
00@000000?ooo`3oool00000C`3oool00`000000oooo0?ooo`200?ooo`007P3oool010000000oooo
0?ooo`00001?0?ooo`030000003oool0oooo0800oooo000N0?ooo`040000003oool0oooo000004h0
oooo00<000000?ooo`3oool0P@3oool001h0oooo00D000000?ooo`3oool0oooo0000001<0?ooo`03
0000003oool0oooo0880oooo000N0?ooo`050000003oool0oooo0?ooo`000000B`3oool00`000000
oooo0?ooo`230?ooo`007P3oool01@000000oooo0?ooo`3oool0000004/0oooo00<000000?ooo`3o
ool0P`3oool001h0oooo00D000000?ooo`3oool0oooo0000001:0?ooo`030000003oool0oooo08@0
oooo000N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0AP3oool00`000000oooo
0?ooo`250?ooo`007P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0QP3oool000/0oooo0P0000040?ooo`030000003oool0oooo0080oooo0`000005
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`26
0?ooo`002P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo08L0oooo000:0?oo
o`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`280?ooo`002P3oool010000000oooo0?ooo`000008
0?ooo`<000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0R@3oool000X0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`29
0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo08X0oooo000;0?oo
o`8000002@3oool4000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo08/0oooo000N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`2<0?ooo`007P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0S03oool001h0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo08d0oooo000N0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`2>0?ooo`007P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0S`3oool001h0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo08l0
oooo000N0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0=@3oool00`000000oooo
0?ooo`2@0?ooo`007P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0T@3oool001h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0c
0?ooo`030000003oool0oooo0940oooo000N0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`2B0?ooo`007P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool0T`3oool000/0oooo0P0000040?ooo`030000
003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`2D0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo09@0oooo000:0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool00000103oool2000000`0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2E0?oo
o`002P3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0UP3oool000X0oooo00@000000?ooo`3o
ool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0:P3oool00`000000oooo0?ooo`2G0?ooo`002P3oool010000000oooo0?ooo`0000080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0Y0?oo
o`030000003oool0oooo09L0oooo000;0?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo09P0oooo000N0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2I0?ooo`007P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0VP3o
ool001h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo09/0oooo000N0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`2L0?ooo`007P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0W@3oool001h0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo09h0oooo000N0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`2O0?ooo`007P3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0X03oool001h0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0G0?ooo`800000X`3oool001h0oooo00<000000?ooo`3o
ool05@3oool2000001H0oooo00<000000?ooo`3oool0X`3oool000/0oooo0P0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo0140oooo0P00002V0?ooo`002P3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0>0?ooo`800000
Z03oool000X0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`800000
6P3oool2000000`0oooo0P00002Z0?ooo`002P3oool010000000oooo0?ooo`00000:0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool06`3oool3000000P0oooo00<000000?ooo`3oool0
ZP3oool000X0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01h0oooo2000002]0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0d`3oool000/0oooo0P0000090?ooo`@00000
103oool00`000000oooo0?ooo`3C0?ooo`007P3oool00`000000oooo0?ooo`3C0?ooo`00m03oool0
0?@0oooo003d0?ooo`00N`3oool3000007H0oooo001l0?ooo`030000003oool0oooo07D0oooo001^
0?ooo`80000000<0oooo0000003oool01`3oool3000000<0oooo0P000000103oool000000?ooo`3o
ool2000000030?ooo`000000oooo00@0000000@0oooo000000000000oooo0P00001O0?ooo`00K@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`000000H03oool006d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000000<0oooo0`0000030?ooo`030000003oool0oooo0080oooo
0P00001Q0?ooo`00K@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`000000H03oool006`0oooo0P0000000`3oool00000000000090?ooo`80000000D0oooo0000
0000000000000?ooo`02000000<0oooo0P0000030?ooo`030000003oool000000080000000<0oooo
0000003oool00P00001O0?ooo`00T@3oool00`000000oooo0?ooo`1P0?ooo`00T03oool200000680
oooo0000\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.15159, -0.0673946, \
0.00503853, 0.0058076}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
( Table[{i,pdf[i,1,0.1,3]} ,{i,1,3}] 
    //N[#,15]& 
    //TableForm
  )\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      TagBox[GridBox[{
            {"1.`", "6.519330955498005`"},
            {"2.`", \(cteq5pdf(2.`, 1.`, 0.1`, 3.`)\)},
            {"3.`", "6.036092553566975`"}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        (TableForm[ #]&)], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell["Examine pdf vs. Q", "Subsection",
  PageBreakAbove->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
x0=0.1;

Plot[x0 pdf[iset,iparton,x0,q] //Evaluate
 ,{q,2,1000}
 ,PlotLabel->parton[iparton]
 ];\
\>", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.000952381 -4.0512 7.14389 [
[.21429 .22264 -9 -9 ]
[.21429 .22264 9 0 ]
[.40476 .22264 -9 -9 ]
[.40476 .22264 9 0 ]
[.59524 .22264 -9 -9 ]
[.59524 .22264 9 0 ]
[.78571 .22264 -9 -9 ]
[.78571 .22264 9 0 ]
[.97619 .22264 -12 -9 ]
[.97619 .22264 12 0 ]
[.01131 .09226 -24 -4.5 ]
[.01131 .09226 0 4.5 ]
[.01131 .37801 -24 -4.5 ]
[.01131 .37801 0 4.5 ]
[.01131 .52089 -24 -4.5 ]
[.01131 .52089 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .23514 m
.21429 .24139 L
s
[(200)] .21429 .22264 0 1 Mshowa
.40476 .23514 m
.40476 .24139 L
s
[(400)] .40476 .22264 0 1 Mshowa
.59524 .23514 m
.59524 .24139 L
s
[(600)] .59524 .22264 0 1 Mshowa
.78571 .23514 m
.78571 .24139 L
s
[(800)] .78571 .22264 0 1 Mshowa
.97619 .23514 m
.97619 .24139 L
s
[(1000)] .97619 .22264 0 1 Mshowa
.125 Mabswid
.07143 .23514 m
.07143 .23889 L
s
.11905 .23514 m
.11905 .23889 L
s
.16667 .23514 m
.16667 .23889 L
s
.2619 .23514 m
.2619 .23889 L
s
.30952 .23514 m
.30952 .23889 L
s
.35714 .23514 m
.35714 .23889 L
s
.45238 .23514 m
.45238 .23889 L
s
.5 .23514 m
.5 .23889 L
s
.54762 .23514 m
.54762 .23889 L
s
.64286 .23514 m
.64286 .23889 L
s
.69048 .23514 m
.69048 .23889 L
s
.7381 .23514 m
.7381 .23889 L
s
.83333 .23514 m
.83333 .23889 L
s
.88095 .23514 m
.88095 .23889 L
s
.92857 .23514 m
.92857 .23889 L
s
.25 Mabswid
0 .23514 m
1 .23514 L
s
.02381 .09226 m
.03006 .09226 L
s
[(0.58)] .01131 .09226 1 0 Mshowa
.02381 .37801 m
.03006 .37801 L
s
[(0.62)] .01131 .37801 1 0 Mshowa
.02381 .52089 m
.03006 .52089 L
s
[(0.64)] .01131 .52089 1 0 Mshowa
.125 Mabswid
.02381 .12798 m
.02756 .12798 L
s
.02381 .1637 m
.02756 .1637 L
s
.02381 .19942 m
.02756 .19942 L
s
.02381 .27086 m
.02756 .27086 L
s
.02381 .30658 m
.02756 .30658 L
s
.02381 .34229 m
.02756 .34229 L
s
.02381 .41373 m
.02756 .41373 L
s
.02381 .44945 m
.02756 .44945 L
s
.02381 .48517 m
.02756 .48517 L
s
.02381 .05654 m
.02756 .05654 L
s
.02381 .02082 m
.02756 .02082 L
s
.02381 .55661 m
.02756 .55661 L
s
.02381 .59233 m
.02756 .59233 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02571 .60332 m
.03035 .54883 L
.03467 .49824 L
.03715 .47636 L
.03941 .45942 L
.04448 .42847 L
.05466 .38391 L
.06427 .35357 L
.08444 .30844 L
.09582 .28933 L
.10632 .27425 L
.1456 .23144 L
.18335 .20203 L
.22356 .17777 L
.26226 .15878 L
.3034 .14182 L
.34303 .12778 L
.38114 .11588 L
.42171 .10459 L
.46076 .0948 L
.50226 .08534 L
.54224 .07701 L
.58072 .06959 L
.62164 .06227 L
.66105 .0557 L
.69894 .04977 L
.73929 .04382 L
.77812 .03841 L
.8194 .03298 L
.85916 .02801 L
.89741 .02346 L
.93812 .01885 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo000J0?ooo`030000003oool0oooo0=L0oooo000J0?ooo`030000003oool0oooo0=L0oooo
000J0?ooo`030000003oool0oooo0=L0oooo000J0?ooo`030000003oool0oooo0<H0oooo1@00000<
0?ooo`006P3oool00`000000oooo0?ooo`2m0?ooo`T000004@3oool001X0oooo0P00002f0?ooo`P0
00006P3oool001X0oooo00<000000?ooo`3oool0[03oool900000280oooo000J0?ooo`030000003o
ool0oooo0:@0oooo2000000[0?ooo`006P3oool00`000000oooo0?ooo`2K0?ooo`T00000<`3oool0
01X0oooo00<000000?ooo`3oool0U@3oool6000003`0oooo000J0?ooo`030000003oool0oooo0940
oooo100000120?ooo`006P3oool00`000000oooo0?ooo`2:0?ooo`L00000AP3oool001X0oooo0P00
00230?ooo`P00000C@3oool001X0oooo00<000000?ooo`3oool0N`3oool7000005D0oooo000J0?oo
o`030000003oool0oooo07L0oooo1000001L0?ooo`006P3oool00`000000oooo0?ooo`1c0?ooo`@0
0000H03oool001X0oooo00<000000?ooo`3oool0K`3oool4000006@0oooo000J0?ooo`030000003o
ool0oooo06P0oooo1`00001X0?ooo`000P3oool2000000@0oooo00<000000?ooo`3oool00P3oool3
000000@0oooo0P0000040?ooo`030000003oool0oooo0680oooo1P00001_0?ooo`0000D0oooo0000
003oool0oooo0000000;0?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo
0000001P0?ooo`@00000M@3oool000050?ooo`000000oooo0?ooo`0000002`3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo0?ooo`<00000FP3oool4000007T0oooo00001@3oool0
00000?ooo`3oool0000000P0oooo0`0000040?ooo`800000103oool00`000000oooo0?ooo`1G0?oo
o`<00000O@3oool000050?ooo`000000oooo0?ooo`000000203oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0E@3oool200000800oooo00001@3o
ool000000?ooo`3oool0000000P0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo0540oooo100000220?ooo`000P3oool2000000T0oooo10000003
0?ooo`800000103oool00`000000oooo0?ooo`1=0?ooo`@00000QP3oool001X0oooo00<000000?oo
o`3oool0B03oool5000008X0oooo000J0?ooo`030000003oool0oooo04@0oooo1000002?0?ooo`00
6P3oool00`000000oooo0?ooo`110?ooo`<00000T`3oool001X0oooo0P0000100?ooo`800000UP3o
ool001X0oooo00<000000?ooo`3oool0?@3oool2000009P0oooo000J0?ooo`030000003oool0oooo
03/0oooo0P00002J0?ooo`006P3oool00`000000oooo0?ooo`0h0?ooo`<00000W03oool001X0oooo
00<000000?ooo`3oool0=@3oool3000009l0oooo000J0?ooo`030000003oool0oooo0380oooo0`00
002R0?ooo`006P3oool00`000000oooo0?ooo`0_0?ooo`<00000Y@3oool001X0oooo0P00000^0?oo
o`800000Z03oool001X0oooo00<000000?ooo`3oool0:`3oool200000:X0oooo000J0?ooo`030000
003oool0oooo02T0oooo0P00002/0?ooo`006P3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo0:`0oooo000J0?ooo`030000003oool0oooo02H0oooo0P00002_0?ooo`006P3oool00`00
0000oooo0?ooo`0T0?ooo`800000/@3oool001X0oooo00<000000?ooo`3oool07P3oool600000003
0?ooo`000000000000@0oooo0P00000L0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`80
00006`3oool2000000@0oooo0P0000040?ooo`8000006`3oool2000000@0oooo0P0000040?ooo`80
00005`3oool4000000<0oooo0P0000040?ooo`800000103oool2000000<0oooo000J0?ooo`030000
003oool0oooo01h0oooo00@000000?ooo`00000000000P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000001/0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool05`3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000603oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`4000000@3oool10?ooo`006P3oool200000200oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000001P0oooo1@0000020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000006@3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000603oool0
1@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`4000000@3oool10?ooo`006P3oool00`000000oooo0?ooo`0N0?ooo`030000
003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000H0?oo
o`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`00000I0?ooo`<000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
01X0oooo0P0000030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000603o
ool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`4000000@3oool10?ooo`006P3oool00`000000oooo0?ooo`0M0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000001T0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000001T0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000001T0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000001P0oooo00D000000?ooo`3oool0oooo000000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool100000040oooo0@3o
ool001X0oooo00<000000?ooo`3oool06`3oool2000000050?ooo`000000oooo0?ooo`0000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000001X0oooo0P0000030?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000006@3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000006@3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000005P3oool3
000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo000J0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
0P3oool2000000@0oooo0P0000040?ooo`800000703oool00`000000oooo0?ooo`020?ooo`800000
103oool2000001/0oooo0`0000030?ooo`800000103oool2000001/0oooo0P0000040?ooo`800000
103oool2000001T0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000040?ooo`800000
0`3oool001X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`2k0?ooo`006P3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0;`0oooo000J0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0_@3oool001D0oooof00000070?ooo`006P3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0:0?ooo`006P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0<00oooo000J
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0`@3oool001X0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`310?ooo`006P3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo0<80oooo000J0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
``3oool001X0oooo0P00000A0?ooo`030000003oool0oooo0<@0oooo000J0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0a@3oool001X0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`360?ooo`006P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0<H0
oooo000J0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0a`3oool001X0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`380?ooo`006P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0<P0oooo000J0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0b@3oool001X0oooo0P00000;0?ooo`030000003oool0oooo0<X0oooo000J0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0bP3oool001X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`3;0?ooo`006P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0</0oooo000J0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0c03oool001X0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`3<0?ooo`006P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0<`0oooo000J0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0c@3oool001X0oooo0P0000080?ooo`030000003oool0oooo0<d0oooo000J0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0cP3oool001X0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`3>0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0<h0oooo000J0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0c`3o
ool00080oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`@000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0<l0oooo00001@3oool000000?ooo`3oool0
000000P0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0c`3oool000050?ooo`000000oooo0?ooo`000000203o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`030000
003oool0oooo0=00oooo00001@3oool000000?ooo`3oool0000000P0oooo0`0000050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3@0?ooo`0000D0
oooo0000003oool0oooo000000080?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo0=00oooo00001@3oool000000?ooo`3oool0000000P0
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0d03oool00080oooo0P00000:0?ooo`<000000`3oool2000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3A0?ooo`006P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0=40oooo000J0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0d@3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3A
0?ooo`006P3oool2000000@0oooo00<000000?ooo`3oool0d@3oool001X0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`3B0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0=80oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0dP3o
ool001X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3B0?ooo`006P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0=80oooo000J0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0dP3oool001X0oooo00D000000?ooo`3oool0oooo0000003E0?ooo`00
6P3oool200000080oooo00<000000?ooo`3oool0d`3oool001X0oooo00D000000?ooo`3oool0oooo
0000003E0?ooo`006P3oool01@000000oooo0?ooo`3oool000000=D0oooo000J0?ooo`050000003o
ool0oooo0?ooo`000000e@3oool001X0oooo00@000000?ooo`3oool00000eP3oool001X0oooo00@0
00000?ooo`3oool00000eP3oool001X0oooo00@000000?ooo`3oool00000eP3oool001X0oooo0P00
00000`3oool000000?ooo`3E0?ooo`006P3oool010000000oooo0?ooo`00003F0?ooo`006P3oool0
10000000oooo0?ooo`00003F0?ooo`006P3oool010000000oooo0?ooo`00003F0?ooo`006P3oool0
10000000oooo0?ooo`00003F0?ooo`006P3oool010000000oooo0?ooo`00003F0?ooo`000P3oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`00003F0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00003F0?ooo`00
00D0oooo0000003oool0oooo000000080?ooo`050000003oool0oooo0000003oool01@0000030?oo
o`@00000eP3oool000050?ooo`000000oooo0?ooo`000000203oool300000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0000003G0?ooo`0000D0oooo0000003oool0oooo00000008
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000103oool00`000000oooo0000003G
0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`030000003oool0oooo00@0oooo0P000004
0?ooo`030000003oool000000=L0oooo00020?ooo`8000002P3oool3000000@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0000003G0?ooo`006P3oool00`000000oooo0000003G0?ooo`00
6P3oool00`000000oooo0000003G0?ooo`006P3oool300000=L0oooo000J0?ooo`030000003oool0
00000=L0oooo000J0?ooo`030000003oool000000=L0oooo000J0?ooo`030000003oool000000=L0
oooo000J0?ooo`030000003oool000000=L0oooo000J0?ooo`030000003oool000000=L0oooo000J
0?ooo`800000f03oool001X0oooo0P00003H0?ooo`006P3oool200000=P0oooo000J0?ooo`800000
f03oool001X0oooo0P00003H0?ooo`006P3oool200000=P0oooo000J0?ooo`030000003oool0oooo
0=L0oooo000J0?ooo`030000003oool0oooo0=L0oooo000J0?ooo`030000003oool0oooo0=L0oooo
003d0?ooo`00m03oool00?@0oooo001j0?ooo`<00000M`3oool007/0oooo00<000000?ooo`3oool0
MP3oool006d0oooo0P0000000`3oool000000?ooo`070?ooo`<000000`3oool2000000040?ooo`00
0000oooo0?ooo`80000000<0oooo0000003oool010000000103oool000000000003oool200000600
oooo001/0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0000001Q0?ooo`00K03oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000`3oool3000000<0oooo00<000000?ooo`3o
ool00P3oool200000680oooo001/0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000050?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0000001Q0?ooo`00J`3oool2000000030?ooo`000000000000T0oooo0P000000
1@3oool00000000000000000oooo008000000`3oool2000000<0oooo00<000000?ooo`0000000P00
00000`3oool000000?ooo`0200000600oooo002@0?ooo`030000003oool0oooo0640oooo002?0?oo
o`800000H`3oool00?@0oooo003d0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-130.594, 0.565563, 4.89437, \
0.000652488}}]
}, Open  ]],

Cell["Examine Evolution in Q", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
LogLogPlot[ 
  { x pdf[iset,iparton,x,2]
   ,x pdf[iset,iparton,x,10^2]
   ,x pdf[iset,iparton,x,10^4]
   } //Evaluate
 ,{x,0.01,0.3}
 ,PlotLabel->parton[iparton]
];\
\>", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.31332 0.644755 0.603319 0.949261 [
[.02381 -0.0125 -14 -9.8125 ]
[.02381 -0.0125 14 0 ]
[.2179 -0.0125 -14 -9.8125 ]
[.2179 -0.0125 14 0 ]
[.47447 -0.0125 -14 -9.8125 ]
[.47447 -0.0125 14 0 ]
[.66856 -0.0125 -11 -9.8125 ]
[.66856 -0.0125 11 0 ]
[.86265 -0.0125 -11 -9.8125 ]
[.86265 -0.0125 11 0 ]
[-0.0125 .10697 -22 -4.90625 ]
[-0.0125 .10697 0 4.90625 ]
[-0.0125 .31756 -22 -4.90625 ]
[-0.0125 .31756 0 4.90625 ]
[-0.0125 .45628 -22 -4.90625 ]
[-0.0125 .45628 0 4.90625 ]
[-0.0125 .60332 -10 -4.90625 ]
[-0.0125 .60332 0 4.90625 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ -0.0005 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
gsave
.02381 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
87.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2179 0 m
.2179 .00625 L
s
gsave
.2179 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.02) show
87.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.47447 0 m
.47447 .00625 L
s
gsave
.47447 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
87.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.66856 0 m
.66856 .00625 L
s
gsave
.66856 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
81.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.86265 0 m
.86265 .00625 L
s
gsave
.86265 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
81.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.33144 0 m
.33144 .00375 L
s
.41199 0 m
.41199 .00375 L
s
.52553 0 m
.52553 .00375 L
s
.56869 0 m
.56869 .00375 L
s
.60608 0 m
.60608 .00375 L
s
.63906 0 m
.63906 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .10697 m
.00625 .10697 L
s
gsave
-0.0125 .10697 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
81.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .31756 m
.00625 .31756 L
s
gsave
-0.0125 .31756 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
81.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .45628 m
.00625 .45628 L
s
gsave
-0.0125 .45628 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
81.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .60332 m
.00625 .60332 L
s
gsave
-0.0125 .60332 -71 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
69.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
0 .22557 m
.00375 .22557 L
s
0 .39273 m
.00375 .39273 L
s
0 .53632 m
.00375 .53632 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .23325 m
.1506 .25653 L
.24157 .27838 L
.37134 .31705 L
.45224 .34522 L
.51852 .37004 L
.57025 .38997 L
.61643 .40765 L
.6547 .42179 L
.68716 .43305 L
.718 .44279 L
.7448 .4502 L
.76835 .45566 L
.78064 .45804 L
.79143 .45982 L
.80227 .46129 L
.81197 .46231 L
.81701 .46272 L
.82151 .46302 L
.82642 .46327 L
.82908 .46336 L
.83036 .4634 L
.83156 .46343 L
.83272 .46345 L
.83377 .46347 L
.83493 .46349 L
.83557 .46349 L
.83617 .46349 L
.83675 .4635 L
.83737 .4635 L
.8379 .4635 L
.83848 .4635 L
.8388 .46349 L
.8391 .46349 L
.83976 .46349 L
.84035 .46348 L
.84096 .46347 L
.84198 .46346 L
.84306 .46344 L
.845 .46338 L
.84729 .4633 L
.84935 .46321 L
.85377 .46295 L
.8578 .46264 L
.86667 .4617 L
.87445 .46055 L
.88276 .45898 L
.89833 .45499 L
.91253 .45006 L
.92688 .44366 L
Mistroke
.94005 .43643 L
.95215 .42851 L
.96448 .41906 L
.97585 .409 L
.97619 .40868 L
Mfstroke
.02381 .48806 m
.1506 .45349 L
.24157 .43453 L
.31099 .42346 L
.37134 .41615 L
.41584 .41202 L
.45673 .40902 L
.52342 .40527 L
.57544 .4026 L
.61775 .3999 L
.63733 .39829 L
.65669 .39635 L
.68848 .39219 L
.71877 .38667 L
.74512 .38024 L
.77066 .37214 L
.79324 .36313 L
.81336 .35333 L
.8333 .3417 L
.85124 .32937 L
.86912 .31508 L
.88533 .30017 L
.90009 .2848 L
.91498 .26738 L
.92861 .2496 L
.94112 .23158 L
.95385 .21144 L
.96557 .19115 L
.97619 .17122 L
s
.02381 .56448 m
.24157 .47289 L
.37134 .43108 L
.45502 .40825 L
.51715 .39234 L
.57095 .37829 L
.6145 .36589 L
.65438 .35294 L
.68808 .34014 L
.71708 .32723 L
.74494 .31269 L
.76939 .29778 L
.79103 .28255 L
.81238 .26533 L
.83149 .24779 L
.85048 .22807 L
.86762 .20806 L
.88318 .18788 L
.89884 .16542 L
.91313 .14286 L
.92755 .11789 L
.94078 .09289 L
.95295 .06797 L
.96533 .04057 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000N2000`400?l00000o`00003o``3oool0
0<<0oooo00330?ooo`005P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool0oooo0`00000>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`3oool3000001T0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`8000004@3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo0?ooo`<00000503oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo0?ooo`<000005`3oool001D0oooo00<000000?ooo`0000001`3oool00`000000oooo0000
00030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`0000001`3oool00`000000oooo0000
00020?ooo`030000003oool0oooo01P0oooo00<000000?ooo`0000001`3oool00`000000oooo0000
00040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`000000203oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool05`3oool001D0oooo00<00000
0?ooo`0000001`3oool00`000000oooo000000030?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`0000001`3oool00`000000oooo000000030?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`0000001`3oool00`000000oooo000000040?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`000000203oool00`000000oooo0?ooo`0B0?ooo`030000003oool0000000P0oooo00<00000
0?ooo`3oool05P3oool001D0oooo00<000000?ooo`0000001`3oool00`000000oooo000000030?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`0000001`3oool00`000000oooo000000040?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`0000001`3oool00`000000oooo000000020?oo
o`800000403oool00`000000oooo000000080?ooo`030000003oool0oooo0180oooo00<000000?oo
o`0000002@3oool00`000000oooo0?ooo`0E0?ooo`005@3oool00`000000oooo000000070?ooo`03
0000003oool000000080oooo0P00000>0?ooo`030000003oool0000000L0oooo00<000000?ooo`00
00000P3oool00`000000oooo0000000H0?ooo`030000003oool0000000L0oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0000000L0oooo0P00000D0?ooo`03
0000003oool0000000L0oooo00<000000?ooo`0000005`3oool001H0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
1`3oool010000000oooo0?ooo`3oool300000100oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool00<<0oooo
000J0?oooj8000001`3oool001X0oooo00@000000?ooo`3oool000007`3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0K0?ooo`006P3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo00T0oooo000J0?oo
o`030000003oool0oooo09X0oooo00<000000?ooo`3oool02@3oool001X0oooo00<000000?ooo`3o
ool0VP3oool00`000000oooo0?ooo`090?ooo`006P3oool00`000000oooo0?ooo`2I0?ooo`030000
003oool0oooo00X0oooo000J0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool02P3o
ool001X0oooo00<000000?ooo`3oool0V@3oool00`000000oooo0?ooo`0:0?ooo`006P3oool00`00
0000oooo0?ooo`2H0?ooo`030000003oool0oooo00/0oooo000J0?ooo`030000003oool0oooo09P0
oooo00<000000?ooo`3oool02`3oool001X0oooo00<000000?ooo`3oool0U`3oool00`000000oooo
0?ooo`0<0?ooo`006P3oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo00`0oooo000J
0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool0303oool001X0oooo00<000000?oo
o`3oool0UP3oool00`000000oooo0?ooo`0=0?ooo`006P3oool00`000000oooo0?ooo`2F0?ooo`03
0000003oool0oooo00d0oooo000J0?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool0
3P3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`0?0?ooo`002@3oool0
0`000000oooo000000070?ooo`030000003oool0000000@0oooo0P00002E0?ooo`030000003oool0
oooo00l0oooo00090?ooo`030000003oool0000000T0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`2C0?ooo`030000003oool0oooo0100oooo00090?ooo`030000003oool0000000P0
oooo0P0000040?ooo`030000003oool0oooo0980oooo00<000000?ooo`3oool04@3oool000T0oooo
00<000000?ooo`0000001`3oool00`000000oooo000000040?ooo`030000003oool0oooo0980oooo
00<000000?ooo`3oool04@3oool000X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool04P3oool001X0oooo00<00000
0?ooo`3oool0T@3oool00`000000oooo0?ooo`0B0?ooo`006P3oool00`000000oooo0?ooo`2@0?oo
o`030000003oool0oooo01<0oooo000J0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3o
ool04`3oool001X0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0D0?ooo`006P3o
ool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo01@0oooo000J0?ooo`030000003oool0
oooo08h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`006P3oool00`00
0000oooo0?ooo`2=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool001X0
oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0
oooo000J0?ooo`030000003oool0oooo08/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`006P3oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02P3oool001X0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo000J0?ooo`030000003oool0oooo08T0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`006P3oool00`000000oooo0?ooo`280?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool001X0oooo00<000000?ooo`3oool0
R03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo000J0?ooo`030000003o
ool0oooo08L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`006P3oool0
0`000000oooo0?ooo`03000008<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>
0?ooo`006P3oool00`000000oooo0?ooo`030?ooo`D00000O@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00l0oooo000J0?ooo`030000003oool0oooo00P0oooo1P00001f0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03`3oool001X0oooo00<000000?ooo`3oool0
3P3oool500000700oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?ooo`006P3o
ool00`000000oooo0?ooo`0C0?ooo`@00000J`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo0140oooo000J0?ooo`030000003oool0oooo01L0oooo1000001V0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool04P3oool001X0oooo00<000000?ooo`3oool06`3oool40000
0600oooo0P00000?0?ooo`030000003oool0oooo01<0oooo000J0?ooo`030000003oool0oooo01l0
oooo1000001J0?ooo`800000403oool00`000000oooo0?ooo`0D0?ooo`006P3oool00`000000oooo
0?ooo`0S0?ooo`<00000EP3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo
000J0?ooo`030000003oool0oooo02H0oooo1000001A0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool05@3oool001X0oooo00<000000?ooo`3oool0:P3oool3000004d0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0F0?ooo`006P3oool00`000000oooo0?ooo`0]0?oo
o`@00000A`3oool200000180oooo00<000000?ooo`3oool05`3oool001X0oooo00<000000?ooo`3o
ool0<@3oool300000480oooo0P00000C0?ooo`030000003oool0oooo01P0oooo000:0?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool0oooo0P0000050?ooo`030000003oool0oooo03@0
oooo1000000m0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06@3oool000T0oooo
00<000000?ooo`0000002@3oool00`000000oooo0?ooo`020?ooo`800000>@3oool3000003P0oooo
0P00000D0?ooo`030000003oool0oooo01X0oooo00090?ooo`030000003oool0000000T0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0k0?ooo`800000=03oool2000001@0oooo0P00
000M0?ooo`002@3oool00`000000oooo000000070?ooo`8000001@3oool00`000000oooo0?ooo`0m
0?ooo`<00000;`3oool2000001D0oooo00<000000?ooo`3oool07@3oool000T0oooo00<000000?oo
o`0000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0400oooo0`00000Z0?oo
o`8000005@3oool200000200oooo000:0?ooo`030000003oool0oooo00H0oooo0`0000040?ooo`03
0000003oool0oooo04<0oooo0P00000V0?ooo`8000005P3oool00`000000oooo0?ooo`0P0?ooo`00
6P3oool00`000000oooo0?ooo`150?ooo`<00000803oool3000001H0oooo0P00000S0?ooo`006P3o
ool00`000000oooo0?ooo`180?ooo`8000006`3oool3000001L0oooo0P00000U0?ooo`006P3oool0
0`000000oooo0?ooo`1:0?ooo`<000005@3oool3000001L0oooo0`00000W0?ooo`006P3oool00`00
0000oooo0?ooo`1=0?ooo`800000403oool3000001P0oooo0P00000Z0?ooo`006P3oool00`000000
oooo0?ooo`1?0?ooo`<000002@3oool4000001P0oooo0`00000/0?ooo`006P3oool00`000000oooo
0?ooo`1B0?ooo`<000000P3oool4000001P0oooo1000000_0?ooo`006P3oool00`000000oooo0?oo
o`1C0?ooo`D000005`3oool4000003<0oooo000J0?ooo`030000003oool0oooo04l0oooo10000005
0?ooo`<000003`3oool5000003L0oooo000J0?ooo`030000003oool0oooo04/0oooo1000000<0?oo
o`l00000?03oool001X0oooo00<000000?ooo`3oool0B03oool3000000030?ooo`00000000000140
0000A`3oool001X0oooo00<000000?ooo`3oool0?@3oool?000001<0oooo0`00000g0?ooo`800000
2`3oool001X0oooo00<000000?ooo`3oool0=03oool9000000<0oooo1000000N0?ooo`<00000<`3o
ool00`000000oooo0?ooo`0;0?ooo`006P3oool00`000000oooo0?ooo`0]0?ooo`L00000203oool4
000002D0oooo0`00000_0?ooo`030000003oool0oooo00`0oooo000J0?ooo`030000003oool0oooo
02L0oooo1P00000;0?ooo`@00000;03oool3000002X0oooo0P00000?0?ooo`006P3oool00`000000
oooo0?ooo`0R0?ooo`D000003P3oool3000003<0oooo1000000T0?ooo`8000004@3oool001X0oooo
00<000000?ooo`3oool07@3oool500000100oooo0`00000j0?ooo`<000007`3oool2000001<0oooo
000J0?ooo`030000003oool0oooo01P0oooo1@00000B0?ooo`<00000@03oool2000001/0oooo0P00
000E0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`@00000503oool3000004D0oooo1P00000C
0?ooo`8000005`3oool000T0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`030?oo
o`8000004@3oool4000001D0oooo0`00001>0?ooo`L000000`3oool010000000oooo0?ooo`3oool5
000001T0oooo00090?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0=0?ooo`<000005P3oool3000005P0oooo1`00000N0?ooo`002@3oool00`000000
oooo000000090?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool4000001H0
oooo0`0000200?ooo`002@3oool00`000000oooo000000070?ooo`030000003oool0000000@0oooo
00<000000?ooo`3oool01P3oool3000001P0oooo0P0000230?ooo`002P3oool00`000000oooo0?oo
o`060?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`@00000603oool3000008D0oooo000J
0?ooo`030000003oool0oooo008000006P3oool2000008P0oooo000J0?ooo`030000003oool0oooo
01X0oooo0P00002:0?ooo`006P3oool00`000000oooo0?ooo`0G0?ooo`<00000S03oool001X0oooo
00<000000?ooo`3oool05@3oool2000008l0oooo000J0?ooo`030000003oool0oooo0180oooo0`00
002A0?ooo`006P3oool00`000000oooo0?ooo`0@0?ooo`800000U03oool001X0oooo00<000000?oo
o`3oool03P3oool2000009H0oooo000J0?ooo`030000003oool0oooo00/0oooo0`00002H0?ooo`00
6P3oool00`000000oooo0?ooo`090?ooo`800000V`3oool001X0oooo00<000000?ooo`3oool01P3o
ool3000009d0oooo000J0?ooo`030000003oool0oooo00@0oooo0P00002P0?ooo`006P3oool00`00
0000oooo0?ooo`020?ooo`800000XP3oool001X0oooo00<000000?ooo`3oool00P00002T0?ooo`00
6P3oool00`000000oooo0?ooo`2V0?ooo`006P3oool00`000000oooo0?ooo`2V0?ooo`006P3oool0
0`000000oooo0?ooo`2V0?ooo`006P3oool00`000000oooo0?ooo`2V0?ooo`004P3oool3000000D0
oooo00<000000?ooo`3oool0YP3oool001<0oooo00<000000?ooo`3oool0103oool200000:L0oooo
000C0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool001<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`004P3oool2000000H0oooo00<000000?oo
o`3oool0YP3oool001<0oooo00<000000?ooo`3oool0[@3oool00<<0oooo001U0?ooo`<00000F`3o
ool006H0oooo00<000000?ooo`3oool0FP3oool005/0oooo0P0000000`3oool000000?ooo`050?oo
o`8000000P3oool2000000080?ooo`000000oooo0?ooo`000000oooo0000003oool3000000040?oo
o`00000000000?ooo`800000A`3oool005/0oooo00<000000?ooo`0000001P3oool00`000000oooo
000000020?ooo`030000003oool000000080oooo00<000000?ooo`0000000`3oool010000000oooo
0?ooo`3oool3000004P0oooo001K0?ooo`030000003oool0000000H0oooo00<000000?ooo`000000
0P3oool00`000000oooo000000030?ooo`8000000`3oool010000000oooo0?ooo`3oool2000004T0
oooo001J0?ooo`80000000<0oooo0000003oool01P3oool00`000000oooo00000002000000040?oo
o`000000oooo0?ooo`8000000`3oool4000000040?ooo`000000oooo000004P0oooo001h0?ooo`03
0000003oool0oooo04P0oooo0000\
\>"],
  ImageRangeCache->{{{0, 194.188}, {119.562, 0}} -> {-2.28797, -0.699937, \
0.00768196, 0.00521772}}]
}, Open  ]],

Cell["Compute Momentum Fraction", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
mom= Table[
  NIntegrate[ x pdf[iset,ipart,x,q0]  
  ,{x,0,1}]
  ,{ipart,-6,6}]\
\>", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory try using the option Method->Oscillatory \
in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(TraditionalForm\`NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory try using the option Method->Oscillatory \
in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(TraditionalForm\`NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory try using the option Method->Oscillatory \
in NIntegrate."\)], "Message"],

Cell[BoxData[
    FormBox[
      RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(TraditionalForm\\`\\(NIntegrate :: \\\"ploss\\\"\\)\\) will be \
suppressed during this calculation.\"\>"}], TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`{0.`, 0.`, 0.004300080486786896`, 
      0.01784377869729041`, 0.03797739713424811`, 0.028912877140838084`, 
      0.4132554283531265`, 0.32137958991820165`, 0.15525792083736567`, 
      0.01784377869729041`, 0.004300080486786896`, 0.`, 0.`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\({Table[parton[i], {i, \(-6\), 6}], 100*\ mom}\  // Transpose\)\  // 
      TableForm\)], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[GridBox[{
            {"\<\"t-bar quark\"\>", "0.`"},
            {"\<\"b-bar quark\"\>", "0.`"},
            {"\<\"c-bar quark\"\>", "0.4300080486786896`"},
            {"\<\"s-bar quark\"\>", "1.784377869729041`"},
            {"\<\"d-bar quark\"\>", "3.7977397134248108`"},
            {"\<\"u-bar quark\"\>", "2.8912877140838082`"},
            {"\<\"gluon\"\>", "41.32554283531265`"},
            {"\<\"u quark\"\>", "32.13795899182016`"},
            {"\<\"d quark\"\>", "15.525792083736567`"},
            {"\<\"s quark\"\>", "1.784377869729041`"},
            {"\<\"c quark\"\>", "0.4300080486786896`"},
            {"\<\"b quark\"\>", "0.`"},
            {"\<\"t quark\"\>", "0.`"}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        (TableForm[ #]&)], TraditionalForm]], "Output"]
}, Open  ]],

Cell["Check Total Momentum Fraction", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plus @@ mom", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`1.0010709317519346`\)], "Output"]
}, Open  ]],

Cell["Compute 2S/(U-bar + D-bar)", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["2 mom[[4]]/(mom[[5]]+mom[[6]])", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`0.5335238609998185`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loop over Flavors:", "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
iset=1;
iparton=1;
q0=2;

Do[ 
Plot[x pdf[iset,ipart,x,q0] //Evaluate
 ,{x,0.01,1}
 ,PlotLabel->parton[ipart]
 ];
 ,{ipart,-2,6}];\
\>", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 48.1535 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .11102 -30 -4.5 ]
[.01131 .11102 0 4.5 ]
[.01131 .20733 -30 -4.5 ]
[.01131 .20733 0 4.5 ]
[.01131 .30364 -30 -4.5 ]
[.01131 .30364 0 4.5 ]
[.01131 .39994 -30 -4.5 ]
[.01131 .39994 0 4.5 ]
[.01131 .49625 -24 -4.5 ]
[.01131 .49625 0 4.5 ]
[.01131 .59256 -30 -4.5 ]
[.01131 .59256 0 4.5 ]
[.5 .63053 -35 0 ]
[.5 .63053 35 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11102 m
.03006 .11102 L
s
[(0.002)] .01131 .11102 1 0 Mshowa
.02381 .20733 m
.03006 .20733 L
s
[(0.004)] .01131 .20733 1 0 Mshowa
.02381 .30364 m
.03006 .30364 L
s
[(0.006)] .01131 .30364 1 0 Mshowa
.02381 .39994 m
.03006 .39994 L
s
[(0.008)] .01131 .39994 1 0 Mshowa
.02381 .49625 m
.03006 .49625 L
s
[(0.01)] .01131 .49625 1 0 Mshowa
.02381 .59256 m
.03006 .59256 L
s
[(0.012)] .01131 .59256 1 0 Mshowa
.125 Mabswid
.02381 .03879 m
.02756 .03879 L
s
.02381 .06287 m
.02756 .06287 L
s
.02381 .08695 m
.02756 .08695 L
s
.02381 .1351 m
.02756 .1351 L
s
.02381 .15918 m
.02756 .15918 L
s
.02381 .18325 m
.02756 .18325 L
s
.02381 .23141 m
.02756 .23141 L
s
.02381 .25548 m
.02756 .25548 L
s
.02381 .27956 m
.02756 .27956 L
s
.02381 .32771 m
.02756 .32771 L
s
.02381 .35179 m
.02756 .35179 L
s
.02381 .37587 m
.02756 .37587 L
s
.02381 .42402 m
.02756 .42402 L
s
.02381 .4481 m
.02756 .4481 L
s
.02381 .47217 m
.02756 .47217 L
s
.02381 .52033 m
.02756 .52033 L
s
.02381 .5444 m
.02756 .5444 L
s
.02381 .56848 m
.02756 .56848 L
s
.02381 .61663 m
.02756 .61663 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
69.000 11.250 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bar) show
99.000 11.250 moveto
(quark) show
129.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.3641 .61803 m
.36912 .5761 L
.38979 .43869 L
.41071 .33016 L
.4306 .25016 L
.45021 .18914 L
.46841 .14529 L
.48873 .10796 L
.50715 .08251 L
.52621 .06277 L
.54682 .04724 L
.56656 .03667 L
.5765 .03259 L
.58741 .02888 L
.60673 .02395 L
.61756 .02191 L
.62743 .0204 L
.64633 .01827 L
.657 .01741 L
.66688 .01679 L
.67577 .01634 L
.68536 .01595 L
.69588 .01563 L
.70575 .01539 L
.71523 .01522 L
.72559 .01508 L
.73641 .01497 L
.74648 .01489 L
.7569 .01484 L
.76673 .0148 L
.77556 .01478 L
.78513 .01476 L
.7945 .01474 L
.79983 .01474 L
.80481 .01473 L
.81486 .01473 L
.82049 .01472 L
.82564 .01472 L
.83038 .01472 L
.83542 .01472 L
.84448 .01472 L
.85003 .01472 L
.85525 .01472 L
.85991 .01472 L
.86501 .01472 L
.86969 .01472 L
.8747 .01472 L
.87999 .01472 L
.88492 .01472 L
.88985 .01472 L
Mistroke
.8945 .01472 L
.89868 .01472 L
.90322 .01472 L
.90804 .01472 L
.91255 .01472 L
.91751 .01472 L
.92284 .01472 L
.92814 .01472 L
.9337 .01472 L
.93846 .01472 L
.94115 .01472 L
.94365 .01472 L
.94787 .01472 L
.95024 .01472 L
.95243 .01472 L
.95451 .01472 L
.95646 .01472 L
.95848 .01472 L
.96071 .01472 L
.96167 .01472 L
.96271 .01472 L
.96364 .01472 L
.96461 .01472 L
.96549 .01472 L
.96647 .01472 L
.96735 .01472 L
.96818 .01472 L
.96916 .01472 L
.97019 .01472 L
.97107 .01472 L
.97203 .01472 L
.97307 .01472 L
.97419 .01472 L
.97524 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo00140?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo100000080?ooo`00@`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`070?ooo`00@`3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`0000090?ooo`00903oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo
0<d0oooo000T0?ooo`030000003oool0oooo0<d0oooo000O0?ooom400000103oool002@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01@3oool>000000L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`P000007`3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo0740oooo0`00001I0?oo
o`00903oool00`000000oooo0?ooo`1_0?ooo`800000G03oool002@0oooo00<000000?ooo`3oool0
K@3oool2000005h0oooo000T0?ooo`030000003oool0oooo06/0oooo0P00001P0?ooo`00903oool0
0`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0600oooo000T0?ooo`030000003oool0oooo
06P0oooo0P00001S0?ooo`00903oool00`000000oooo0?ooo`1V0?ooo`800000I@3oool002@0oooo
00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`1U0?ooo`00903oool00`000000oooo0?oo
o`1T0?ooo`030000003oool0oooo06H0oooo000T0?ooo`030000003oool0oooo06<0oooo00<00000
0?ooo`3oool0I`3oool002@0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`1X0?oo
o`00903oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo06T0oooo000T0?ooo`030000
003oool0oooo0600oooo00<000000?ooo`3oool0JP3oool002@0oooo00<000000?ooo`3oool0H03o
ool00`000000oooo0?ooo`1Z0?ooo`00903oool00`000000oooo0?ooo`1O0?ooo`030000003oool0
oooo06/0oooo00050?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000103oool20000
00<0oooo100000040?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0K03oool000@0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1N0?ooo`030000003o
ool0oooo06`0oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0oooo0P00001N0?ooo`03
0000003oool0oooo06d0oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0G@3oool00`000000oooo0?ooo`1]0?ooo`00103oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0KP3oool000@0oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1L0?ooo`030000003oool0
oooo06h0oooo00050?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`1K0?ooo`030000003oool0oooo06l0oooo000T0?ooo`030000003oool0oooo05/0
oooo00<000000?ooo`3oool0K`3oool002@0oooo00<000000?ooo`3oool0FP3oool00`000000oooo
0?ooo`1`0?ooo`00903oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0700oooo000T
0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0L@3oool002@0oooo00<000000?oo
o`3oool0F@3oool00`000000oooo0?ooo`1a0?ooo`00903oool00`000000oooo0?ooo`1H0?ooo`03
0000003oool0oooo0780oooo000T0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0
LP3oool002@0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1c0?ooo`00903oool0
0`000000oooo0?ooo`1G0?ooo`030000003oool0oooo07<0oooo000T0?ooo`030000003oool0oooo
05H0oooo00<000000?ooo`3oool0M03oool002@0oooo00<000000?ooo`3oool0EP3oool00`000000
oooo0?ooo`1d0?ooo`00903oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo07D0oooo
000T0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0M@3oool000D0oooo0P000004
0?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0M@3oool000@0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo07H0oooo
00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01@000000
oooo0?ooo`000000oooo00D00000103oool2000005D0oooo00<000000?ooo`3oool0MP3oool000@0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05@0oooo
00<000000?ooo`3oool0MP3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`1C0?ooo`030000003oool0oooo07L0oooo00040?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`8000001@3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo07L0oooo00050?ooo`8000002P3oool2
000000@0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0D`3oool0
0`000000oooo0?ooo`1g0?ooo`00903oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo
07P0oooo000T0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0N03oool002@0oooo
00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`1h0?ooo`00903oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo07T0oooo000T0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0N@3oool002@0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1i0?oo
o`00903oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo07T0oooo000T0?ooo`030000
003oool0oooo0500oooo00<000000?ooo`3oool0NP3oool002@0oooo00<000000?ooo`3oool0D03o
ool00`000000oooo0?ooo`1j0?ooo`00903oool00`000000oooo0?ooo`1@0?ooo`030000003oool0
oooo07X0oooo000T0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0NP3oool002@0
oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1k0?ooo`00903oool00`000000oooo
0?ooo`1?0?ooo`030000003oool0oooo07/0oooo000T0?ooo`030000003oool0oooo04l0oooo00<0
00000?ooo`3oool0N`3oool000D0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P000004
0?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1k
0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo04h0
oooo00<000000?ooo`3oool0O03oool000@0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103o
ool2000004l0oooo00<000000?ooo`3oool0O03oool000@0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`0000050?ooo`03
0000003oool0oooo04h0oooo00<000000?ooo`3oool0O03oool000@0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo07`0oooo00040?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0C@3oool00`000000oooo
0?ooo`1m0?ooo`001@3oool2000000X0oooo0P0000040?ooo`800000103oool3000000@0oooo00<0
00000?ooo`3oool0C@3oool00`000000oooo0?ooo`1m0?ooo`00903oool00`000000oooo0?ooo`1=
0?ooo`030000003oool0oooo07d0oooo000T0?ooo`030000003oool0oooo04d0oooo00<000000?oo
o`3oool0O@3oool002@0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1m0?ooo`00
903oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo07h0oooo000T0?ooo`030000003o
ool0oooo04`0oooo00<000000?ooo`3oool0OP3oool002@0oooo00<000000?ooo`3oool0C03oool0
0`000000oooo0?ooo`1n0?ooo`00903oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo
07h0oooo000T0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0OP3oool002@0oooo
00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`1n0?ooo`00903oool00`000000oooo0?oo
o`1;0?ooo`030000003oool0oooo07l0oooo000T0?ooo`030000003oool0oooo04/0oooo00<00000
0?ooo`3oool0O`3oool002@0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`1o0?oo
o`00903oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo07l0oooo00050?ooo`800000
103oool00`000000oooo0?ooo`030?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000
003oool0oooo04/0oooo00<000000?ooo`3oool0O`3oool000@0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo07l0oooo00040?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000000@0oooo0P00001;0?ooo`030000003oool0oooo0800
oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000030?ooo`8000001@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0
oooo0800oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool0BP3oool00`000000oooo0?ooo`200?ooo`00103oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0P03oool000D0oooo0P00000:
0?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo04X0oooo00<00000
0?ooo`3oool0P03oool002@0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`200?oo
o`00903oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0840oooo000T0?ooo`030000
003oool0oooo04T0oooo00<000000?ooo`3oool0P@3oool002@0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`210?ooo`00903oool00`000000oooo0?ooo`190?ooo`030000003oool0
oooo0840oooo000T0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0P@3oool002@0
oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`210?ooo`00903oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0880oooo000T0?ooo`030000003oool0oooo04P0oooo00<0
00000?ooo`3oool0PP3oool002@0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`22
0?ooo`00903oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0880oooo000T0?ooo`03
0000003oool0oooo04P0oooo00<000000?ooo`3oool0PP3oool002@0oooo00<000000?ooo`3oool0
B03oool00`000000oooo0?ooo`220?ooo`002`3oool2000000@0oooo00<000000?ooo`3oool00`3o
ool2000000<0oooo100000040?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0PP3o
ool000X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`230?ooo`002P3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00`3oool2000004P0oooo00<000000?ooo`3oool0P`3oool000X0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0A`3oool00`000000oooo0?ooo`230?ooo`002P3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`17
0?ooo`030000003oool0oooo08<0oooo000:0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool3000000D0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`230?ooo`002`3oool2000000X0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`230?ooo`00903oool00`000000oooo0?ooo`170?oo
o`030000003oool0oooo08<0oooo000T0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3o
ool0Q03oool002@0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`240?ooo`00903o
ool00`000000oooo0?ooo`160?ooo`030000003oool0oooo08@0oooo000T0?ooo`030000003oool0
oooo04H0oooo00<000000?ooo`3oool0Q03oool002@0oooo00<000000?ooo`3oool0AP3oool00`00
0000oooo0?ooo`240?ooo`00903oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo08@0
oooo000T0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0Q03oool002@0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`250?ooo`00903oool00`000000oooo0?ooo`15
0?ooo`030000003oool0oooo08D0oooo000T0?ooo`030000003oool0oooo04D0oooo00<000000?oo
o`3oool0Q@3oool002@0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`250?ooo`00
903oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo08D0oooo00050?ooo`800000103o
ool00`000000oooo0?ooo`030?ooo`8000000`3oool400000080oooo100000040?ooo`030000003o
ool0oooo04D0oooo00<000000?ooo`3oool0Q@3oool000@0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo08D0oooo00040?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00@0oooo0P0000160?ooo`030000003oool0oooo08D0oooo00040?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`260?ooo`00103oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0QP3o
ool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`<00000
0`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0QP3oool000D0oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`800000
1@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo08H0oooo000T0?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0QP3oool00?@0oooo003d0?ooo`00m03oool008d0oooo
0`00001T0?ooo`00SP3oool00`000000oooo0?ooo`1S0?ooo`00J03oool2000000030?ooo`000000
oooo00D0oooo100000040?ooo`80000000<0oooo0000003oool0100000090?ooo`<000000`3oool2
000000040?ooo`000000oooo0?ooo`80000000<0oooo0000003oool010000000103oool000000000
003oool2000004d0oooo001W0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0000001>0?ooo`00I`3oool010000000oooo0?oo
o`0000020?ooo`@000000P3oool010000000oooo0?ooo`0000030?ooo`<000000`3oool00`000000
oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool3
000000<0oooo00<000000?ooo`3oool00P3oool2000004l0oooo001W0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000X0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0000001>0?ooo`00J03oool3000000P0oooo0`0000040?oo
o`8000000`3oool00`000000oooo00000002000000P0oooo0P0000001@3oool00000000000000000
oooo008000000`3oool2000000<0oooo00<000000?ooo`0000000P0000000`3oool000000?ooo`02
000004d0oooo001Z0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0;@3oool00`00
0000oooo0?ooo`1>0?ooo`00J@3oool2000000L0oooo0P00000^0?ooo`800000D03oool00001\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.181821, -0.00115642, \
0.00503853, 9.96521*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 116.25 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13096 -30 -4.5 ]
[.01131 .13096 0 4.5 ]
[.01131 .24721 -30 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .36346 -30 -4.5 ]
[.01131 .36346 0 4.5 ]
[.01131 .47971 -30 -4.5 ]
[.01131 .47971 0 4.5 ]
[.01131 .59596 -30 -4.5 ]
[.01131 .59596 0 4.5 ]
[.5 .63053 -35 0 ]
[.5 .63053 35 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13096 m
.03006 .13096 L
s
[(0.001)] .01131 .13096 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.002)] .01131 .24721 1 0 Mshowa
.02381 .36346 m
.03006 .36346 L
s
[(0.003)] .01131 .36346 1 0 Mshowa
.02381 .47971 m
.03006 .47971 L
s
[(0.004)] .01131 .47971 1 0 Mshowa
.02381 .59596 m
.03006 .59596 L
s
[(0.005)] .01131 .59596 1 0 Mshowa
.125 Mabswid
.02381 .03797 m
.02756 .03797 L
s
.02381 .06122 m
.02756 .06122 L
s
.02381 .08446 m
.02756 .08446 L
s
.02381 .10771 m
.02756 .10771 L
s
.02381 .15421 m
.02756 .15421 L
s
.02381 .17746 m
.02756 .17746 L
s
.02381 .20071 m
.02756 .20071 L
s
.02381 .22396 m
.02756 .22396 L
s
.02381 .27046 m
.02756 .27046 L
s
.02381 .29371 m
.02756 .29371 L
s
.02381 .31696 m
.02756 .31696 L
s
.02381 .34021 m
.02756 .34021 L
s
.02381 .38671 m
.02756 .38671 L
s
.02381 .40996 m
.02756 .40996 L
s
.02381 .43321 m
.02756 .43321 L
s
.02381 .45646 m
.02756 .45646 L
s
.02381 .50296 m
.02756 .50296 L
s
.02381 .52621 m
.02756 .52621 L
s
.02381 .54946 m
.02756 .54946 L
s
.02381 .57271 m
.02756 .57271 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 11.250 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(bar) show
99.000 11.250 moveto
(quark) show
129.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.43361 .61803 m
.44702 .52499 L
.46691 .41134 L
.50472 .25016 L
.5242 .19037 L
.54496 .14069 L
.56616 .10236 L
.58613 .07555 L
.60601 .056 L
.62429 .04296 L
.64293 .03344 L
.65351 .02937 L
.66339 .02628 L
.67373 .02367 L
.68354 .02168 L
.70191 .01897 L
.71146 .01796 L
.72162 .01713 L
.73028 .01658 L
.73985 .0161 L
.74984 .01572 L
.75901 .01546 L
.76906 .01524 L
.77965 .01508 L
.7891 .01497 L
.7992 .01489 L
.80872 .01483 L
.81738 .0148 L
.82218 .01478 L
.82726 .01477 L
.83637 .01475 L
.84144 .01474 L
.84618 .01474 L
.85134 .01473 L
.85696 .01473 L
.86231 .01473 L
.86727 .01472 L
.8724 .01472 L
.87705 .01472 L
.88132 .01472 L
.88594 .01472 L
.89081 .01472 L
.8954 .01472 L
.90028 .01472 L
.90483 .01472 L
.90983 .01472 L
.91518 .01472 L
.91787 .01472 L
.92079 .01472 L
.92337 .01472 L
Mistroke
.9261 .01472 L
.92856 .01472 L
.93127 .01472 L
.93604 .01472 L
.93838 .01472 L
.94093 .01472 L
.94359 .01472 L
.94606 .01472 L
.94839 .01472 L
.9505 .01472 L
.95167 .01472 L
.95294 .01472 L
.95524 .01472 L
.95652 .01472 L
.95773 .01472 L
.95905 .01472 L
.96046 .01472 L
.96117 .01472 L
.96195 .01472 L
.96263 .01472 L
.96335 .01472 L
.96401 .01472 L
.96472 .01472 L
.96599 .01472 L
.96727 .01472 L
.96845 .01472 L
.96974 .01472 L
.97039 .01472 L
.9711 .01472 L
.9723 .01472 L
.97358 .01472 L
.9748 .01472 L
.9759 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo00140?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo100000080?ooo`00@`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`070?ooo`00@`3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`0000090?ooo`00903oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo
0<d0oooo000T0?ooo`030000003oool0oooo0<d0oooo000O0?ooom400000103oool002@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`l00000103oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00`0oooo1@00000C
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01`3oool002@0oooo00<000000?oo
o`3oool0O`3oool4000004X0oooo000T0?ooo`030000003oool0oooo07d0oooo0P00001>0?ooo`00
903oool00`000000oooo0?ooo`1k0?ooo`800000D03oool002@0oooo00<000000?ooo`3oool0NP3o
ool00`000000oooo0?ooo`1@0?ooo`00903oool00`000000oooo0?ooo`1h0?ooo`800000D`3oool0
02@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1C0?ooo`00903oool00`000000
oooo0?ooo`1f0?ooo`030000003oool0oooo05@0oooo000T0?ooo`030000003oool0oooo07D0oooo
00<000000?ooo`3oool0E@3oool002@0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?oo
o`1F0?ooo`00903oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo05L0oooo000T0?oo
o`030000003oool0oooo0780oooo00<000000?ooo`3oool0F03oool002@0oooo00<000000?ooo`3o
ool0L@3oool00`000000oooo0?ooo`1I0?ooo`00903oool00`000000oooo0?ooo`1a0?ooo`030000
003oool0oooo05T0oooo000T0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool0FP3o
ool002@0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`1K0?ooo`00903oool00`00
0000oooo0?ooo`1_0?ooo`030000003oool0oooo05/0oooo000T0?ooo`030000003oool0oooo06h0
oooo00<000000?ooo`3oool0G03oool002@0oooo00<000000?ooo`3oool0K@3oool00`000000oooo
0?ooo`1M0?ooo`00903oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo05d0oooo000T
0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0GP3oool000D0oooo0P0000040?oo
o`030000003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?oo
o`3oool0K03oool00`000000oooo0?ooo`1N0?ooo`00103oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0G`3oool000@0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00`3oool2000006/0oooo00<000000?ooo`3oool0H03oool000@0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0
oooo0600oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
J@3oool00`000000oooo0?ooo`1Q0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool3000000D0oooo00<000000?oo
o`3oool0J@3oool00`000000oooo0?ooo`1Q0?ooo`001@3oool2000000X0oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3o
ool0HP3oool002@0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`1R0?ooo`00903o
ool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo06<0oooo000T0?ooo`030000003oool0
oooo06L0oooo00<000000?ooo`3oool0H`3oool002@0oooo00<000000?ooo`3oool0I`3oool00`00
0000oooo0?ooo`1S0?ooo`00903oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo06@0
oooo000T0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0I03oool002@0oooo00<0
00000?ooo`3oool0I@3oool00`000000oooo0?ooo`1U0?ooo`00903oool00`000000oooo0?ooo`1U
0?ooo`030000003oool0oooo06D0oooo000T0?ooo`030000003oool0oooo06D0oooo00<000000?oo
o`3oool0I@3oool002@0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`1V0?ooo`00
903oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo06H0oooo000T0?ooo`030000003o
ool0oooo06@0oooo00<000000?ooo`3oool0IP3oool002@0oooo00<000000?ooo`3oool0H`3oool0
0`000000oooo0?ooo`1W0?ooo`00903oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo
06L0oooo000T0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0I`3oool002@0oooo
00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`1X0?ooo`00903oool00`000000oooo0?oo
o`1R0?ooo`030000003oool0oooo06P0oooo00050?ooo`800000103oool00`000000oooo0?ooo`03
0?ooo`800000103oool2000000<0oooo100000040?ooo`030000003oool0oooo0680oooo00<00000
0?ooo`3oool0J03oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`1Q0?ooo`030000003oool0oooo06T0oooo00040?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00@0oooo0P00001R0?ooo`030000003oool0oooo06T0oooo00040?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`1Y0?ooo`00103oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0640oooo00<000000?ooo`3o
ool0J@3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`1P0?ooo`030000003oool0oooo06X0oooo00050?ooo`8000002P3oool2000000@0oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo06X0oooo000T0?oo
o`030000003oool0oooo0600oooo00<000000?ooo`3oool0JP3oool002@0oooo00<000000?ooo`3o
ool0H03oool00`000000oooo0?ooo`1Z0?ooo`00903oool00`000000oooo0?ooo`1O0?ooo`030000
003oool0oooo06/0oooo000T0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0J`3o
ool002@0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`1[0?ooo`00903oool00`00
0000oooo0?ooo`1O0?ooo`030000003oool0oooo06/0oooo000T0?ooo`030000003oool0oooo05h0
oooo00<000000?ooo`3oool0K03oool002@0oooo00<000000?ooo`3oool0GP3oool00`000000oooo
0?ooo`1/0?ooo`00903oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo06`0oooo000T
0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0K03oool002@0oooo00<000000?oo
o`3oool0G@3oool00`000000oooo0?ooo`1]0?ooo`00903oool00`000000oooo0?ooo`1M0?ooo`03
0000003oool0oooo06d0oooo000T0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0
K@3oool002@0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`1]0?ooo`00903oool0
0`000000oooo0?ooo`1M0?ooo`030000003oool0oooo06d0oooo000T0?ooo`030000003oool0oooo
05`0oooo00<000000?ooo`3oool0KP3oool002@0oooo00<000000?ooo`3oool0G03oool00`000000
oooo0?ooo`1^0?ooo`001@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo
0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo06h0oooo
00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0G03oool0
0`000000oooo0?ooo`1^0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`800000
G03oool00`000000oooo0?ooo`1_0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?oo
o`3oool0F`3oool00`000000oooo0?ooo`1_0?ooo`00103oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0K`3oool000@0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo
06l0oooo00050?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`8000001@3oool00`000000
oooo0?ooo`1J0?ooo`030000003oool0oooo0700oooo000T0?ooo`030000003oool0oooo05X0oooo
00<000000?ooo`3oool0L03oool002@0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?oo
o`1`0?ooo`00903oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0700oooo000T0?oo
o`030000003oool0oooo05T0oooo00<000000?ooo`3oool0L@3oool002@0oooo00<000000?ooo`3o
ool0F@3oool00`000000oooo0?ooo`1a0?ooo`00903oool00`000000oooo0?ooo`1I0?ooo`030000
003oool0oooo0740oooo000T0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0L@3o
ool002@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1a0?ooo`00903oool00`00
0000oooo0?ooo`1I0?ooo`030000003oool0oooo0740oooo000T0?ooo`030000003oool0oooo05P0
oooo00<000000?ooo`3oool0LP3oool002@0oooo00<000000?ooo`3oool0F03oool00`000000oooo
0?ooo`1b0?ooo`00903oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo0780oooo000T
0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0LP3oool002@0oooo00<000000?oo
o`3oool0F03oool00`000000oooo0?ooo`1b0?ooo`00903oool00`000000oooo0?ooo`1H0?ooo`03
0000003oool0oooo0780oooo000T0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0
L`3oool002@0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1c0?ooo`001@3oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0P0000050?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1c0?ooo`00103oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0
L`3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0000003oool01@0000040?ooo`800000F03oool00`000000oooo0?ooo`1c0?oo
o`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
E`3oool00`000000oooo0?ooo`1c0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000050?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool0M03oool000@0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo0P00
00050?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0M03oool000D0oooo0P00000:
0?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo07@0oooo000T0?ooo`030000003oool0oooo05H0oooo00<000000?oo
o`3oool0M03oool002@0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1d0?ooo`00
903oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo07@0oooo000T0?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool0M@3oool002@0oooo00<000000?ooo`3oool0E@3oool0
0`000000oooo0?ooo`1e0?ooo`00903oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
07D0oooo000T0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0M@3oool002@0oooo
00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1e0?ooo`00903oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo07D0oooo000T0?ooo`030000003oool0oooo05@0oooo00<00000
0?ooo`3oool0MP3oool002@0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`1f0?oo
o`00903oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo07H0oooo000T0?ooo`030000
003oool0oooo05@0oooo00<000000?ooo`3oool0MP3oool002@0oooo00<000000?ooo`3oool0E03o
ool00`000000oooo0?ooo`1f0?ooo`00903oool00`000000oooo0?ooo`1D0?ooo`030000003oool0
oooo07H0oooo000T0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0M`3oool002@0
oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1g0?ooo`001@3oool2000000@0oooo
00<000000?ooo`3oool00`3oool2000000@0oooo0P0000030?ooo`<000001@3oool00`000000oooo
0?ooo`1C0?ooo`030000003oool0oooo07L0oooo00040?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1g0?ooo`00103oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3o
ool00`000000oooo0?ooo`020?ooo`800000E03oool00`000000oooo0?ooo`1g0?ooo`00103oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool3000000D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1g0?ooo`00
103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0580oooo00<00000
0?ooo`3oool0N03oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`1B0?ooo`030000003oool0oooo07P0oooo00050?ooo`8000002P3oool2000000@0oooo0P00
00030?ooo`@00000103oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo07P0oooo000T
0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0N03oool00?@0oooo003d0?ooo`00
m03oool008d0oooo0`00001T0?ooo`00SP3oool00`000000oooo0?ooo`1S0?ooo`00J03oool20000
00030?ooo`000000oooo00D0oooo100000040?ooo`80000000<0oooo0000003oool0100000090?oo
o`<000000`3oool2000000040?ooo`000000oooo0?ooo`80000000<0oooo0000003oool010000000
103oool000000000003oool2000004d0oooo001W0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000001>0?ooo`00I`3oool0
10000000oooo0?ooo`0000020?ooo`@000000P3oool010000000oooo0?ooo`0000030?ooo`<00000
0`3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000`3oool3000000<0oooo00<000000?ooo`3oool00P3oool2000004l0oooo001W0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3o
ool0000000X0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0000001>0?ooo`00IP3oool200000003
0?ooo`000000000000P0oooo0`0000040?ooo`8000000`3oool00`000000oooo00000002000000P0
oooo0P0000001@3oool00000000000000000oooo008000000`3oool2000000<0oooo00<000000?oo
o`0000000P0000000`3oool000000?ooo`02000004d0oooo001c0?ooo`030000003oool0oooo02d0
oooo00<000000?ooo`3oool0CP3oool00780oooo0P00000^0?ooo`800000D03oool00001\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.181821, -0.000479016, \
0.00503853, 4.12783*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.713264 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .15737 -18 -4.5 ]
[.01131 .15737 0 4.5 ]
[.01131 .30002 -18 -4.5 ]
[.01131 .30002 0 4.5 ]
[.01131 .44267 -18 -4.5 ]
[.01131 .44267 0 4.5 ]
[.01131 .58533 -18 -4.5 ]
[.01131 .58533 0 4.5 ]
[.5 .63053 -17 0 ]
[.5 .63053 17 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .15737 m
.03006 .15737 L
s
[(0.2)] .01131 .15737 1 0 Mshowa
.02381 .30002 m
.03006 .30002 L
s
[(0.4)] .01131 .30002 1 0 Mshowa
.02381 .44267 m
.03006 .44267 L
s
[(0.6)] .01131 .44267 1 0 Mshowa
.02381 .58533 m
.03006 .58533 L
s
[(0.8)] .01131 .58533 1 0 Mshowa
.125 Mabswid
.02381 .05038 m
.02756 .05038 L
s
.02381 .08604 m
.02756 .08604 L
s
.02381 .1217 m
.02756 .1217 L
s
.02381 .19303 m
.02756 .19303 L
s
.02381 .22869 m
.02756 .22869 L
s
.02381 .26436 m
.02756 .26436 L
s
.02381 .33568 m
.02756 .33568 L
s
.02381 .37135 m
.02756 .37135 L
s
.02381 .40701 m
.02756 .40701 L
s
.02381 .47834 m
.02756 .47834 L
s
.02381 .514 m
.02756 .514 L
s
.02381 .54966 m
.02756 .54966 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(gluon) show
93.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.18073 .61803 m
.19178 .5664 L
.23074 .43131 L
.2682 .33179 L
.30808 .25016 L
.34647 .18979 L
.38728 .14076 L
.42659 .10508 L
.4644 .07914 L
.50464 .05861 L
.54338 .04422 L
.56315 .03851 L
.58455 .03337 L
.62421 .0262 L
.64395 .02357 L
.6648 .02133 L
.68447 .01966 L
.7024 .01844 L
.72171 .01741 L
.74242 .01657 L
.76131 .016 L
.77108 .01576 L
.78186 .01554 L
.80144 .01524 L
.81217 .01511 L
.82224 .01502 L
.83197 .01495 L
.84222 .01488 L
.85182 .01484 L
.86054 .01481 L
.86999 .01478 L
.88008 .01476 L
.88944 .01474 L
.89827 .01473 L
.90285 .01473 L
.90789 .01473 L
.9128 .01472 L
.91808 .01472 L
.92301 .01472 L
.92752 .01472 L
.93205 .01472 L
.93635 .01472 L
.93892 .01472 L
.94134 .01472 L
.94586 .01472 L
.9484 .01472 L
.95073 .01472 L
.95329 .01472 L
.95599 .01472 L
.95817 .01472 L
Mistroke
.95936 .01472 L
.96049 .01472 L
.96154 .01472 L
.96269 .01472 L
.96372 .01472 L
.96468 .01472 L
.96583 .01472 L
.96709 .01472 L
.96831 .01472 L
.969 .01472 L
.96963 .01472 L
.9707 .01472 L
.97186 .01472 L
.97308 .01472 L
.97421 .01472 L
.97525 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo000n0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo1000000>0?ooo`00?@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`0=0?ooo`00?@3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`00000?0?ooo`007P3oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo
0=<0oooo000N0?ooo`030000003oool0oooo0=<0oooo000I0?ooom4000002P3oool001h0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?oooaT00000203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0=0?ooo`007P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`050?ooo`P000005`3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo07H0oooo1P00001G0?oo
o`007P3oool00`000000oooo0?ooo`1_0?ooo`L00000G@3oool001h0oooo00<000000?ooo`3oool0
K03oool3000006@0oooo000N0?ooo`030000003oool0oooo06X0oooo0P00001W0?ooo`007P3oool0
0`000000oooo0?ooo`1X0?ooo`800000J@3oool001h0oooo00<000000?ooo`3oool0I@3oool30000
06/0oooo000N0?ooo`030000003oool0oooo06<0oooo0P00001^0?ooo`007P3oool00`000000oooo
0?ooo`1P0?ooo`<00000L03oool001h0oooo00<000000?ooo`3oool0GP3oool2000007<0oooo000N
0?ooo`030000003oool0oooo05`0oooo0P00001e0?ooo`007P3oool00`000000oooo0?ooo`1J0?oo
o`800000M`3oool001h0oooo00<000000?ooo`3oool0F03oool2000007T0oooo000N0?ooo`030000
003oool0oooo05H0oooo0P00001k0?ooo`007P3oool00`000000oooo0?ooo`1E0?ooo`030000003o
ool0oooo07/0oooo000N0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0O03oool0
01h0oooo00<000000?ooo`3oool0DP3oool2000007l0oooo000N0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0O`3oool001h0oooo00<000000?ooo`3oool0D03oool00`000000oooo
0?ooo`200?ooo`007P3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo0840oooo000N
0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0PP3oool001h0oooo00<000000?oo
o`3oool0C03oool2000008D0oooo000N0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3o
ool0Q@3oool001h0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`260?ooo`007P3o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo08L0oooo000N0?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0R03oool000/0oooo0P0000040?ooo`030000003oool0oooo
0080oooo100000040?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0R@3oool000X0
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
04H0oooo00<000000?ooo`3oool0RP3oool000X0oooo00@000000?ooo`3oool000002@3oool00`00
0000oooo0?ooo`040?ooo`800000A`3oool00`000000oooo0?ooo`2:0?ooo`002P3oool010000000
oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0A@3oool00`00
0000oooo0?ooo`2;0?ooo`002P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2<0?ooo`002P3oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0@`3oool0
0`000000oooo0?ooo`2=0?ooo`002`3oool2000000X0oooo0P0000050?ooo`030000003oool0oooo
0480oooo00<000000?ooo`3oool0SP3oool001h0oooo00<000000?ooo`3oool0@P3oool00`000000
oooo0?ooo`2>0?ooo`007P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo08l0oooo
000N0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0T03oool001h0oooo00<00000
0?ooo`3oool0?`3oool00`000000oooo0?ooo`2A0?ooo`007P3oool00`000000oooo0?ooo`0o0?oo
o`030000003oool0oooo0940oooo000N0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3o
ool0TP3oool001h0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`2C0?ooo`007P3o
ool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo09<0oooo000N0?ooo`030000003oool0
oooo03`0oooo00<000000?ooo`3oool0U03oool001h0oooo00<000000?ooo`3oool0>`3oool00`00
0000oooo0?ooo`2E0?ooo`007P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo09D0
oooo000N0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0UP3oool001h0oooo00<0
00000?ooo`3oool0>@3oool00`000000oooo0?ooo`2G0?ooo`007P3oool00`000000oooo0?ooo`0i
0?ooo`030000003oool0oooo09L0oooo000N0?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool0V03oool001h0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`2H0?ooo`00
7P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo09T0oooo000N0?ooo`030000003o
ool0oooo03L0oooo00<000000?ooo`3oool0V@3oool001h0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`2J0?ooo`007P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
09X0oooo000N0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0V`3oool001h0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`2K0?ooo`007P3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo09`0oooo000;0?ooo`800000103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2L
0?ooo`002P3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0<`3oool00`000000oooo0?ooo`2M0?ooo`002P3oool010000000oooo0?ooo`000007
0?ooo`D00000103oool2000003@0oooo00<000000?ooo`3oool0W@3oool000X0oooo00@000000?oo
o`3oool000001`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0380oooo00<0
00000?ooo`3oool0WP3oool000X0oooo00@000000?ooo`3oool00000203oool00`000000oooo0000
00050?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0WP3oool000X0oooo00@00000
0?ooo`3oool000002@3oool2000000D0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`2O0?ooo`002`3oool2000000/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo09l0oooo000N0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool0X03oool001h0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`2P0?ooo`00
7P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0:00oooo000N0?ooo`030000003o
ool0oooo02l0oooo00<000000?ooo`3oool0X@3oool001h0oooo00<000000?ooo`3oool0;`3oool0
0`000000oooo0?ooo`2Q0?ooo`007P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
0:80oooo000N0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0XP3oool001h0oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`2R0?ooo`007P3oool00`000000oooo0?oo
o`0]0?ooo`030000003oool0oooo0:<0oooo000N0?ooo`030000003oool0oooo02d0oooo00<00000
0?ooo`3oool0X`3oool001h0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2S0?oo
o`007P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0:@0oooo000N0?ooo`030000
003oool0oooo02`0oooo00<000000?ooo`3oool0Y03oool001h0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`2U0?ooo`007P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo0:D0oooo000N0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0Y@3oool001h0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`2V0?ooo`007P3oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo0:H0oooo000N0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool0YP3oool001h0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`2W
0?ooo`007P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0:L0oooo000N0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool0Z03oool001h0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`2X0?ooo`002`3oool2000000@0oooo00<000000?ooo`3oool00`3o
ool2000000D0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`2X0?ooo`002P3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`2Y0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo0P00000X0?ooo`030000003oool0oooo0:T0oooo000:0?ooo`040000
003oool0oooo000000P0oooo0`0000050?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3o
ool0Z@3oool000X0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool0Z@3oool000X0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0ZP3oool000/0oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo0:X0oooo000N0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0ZP3o
ool001h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`2[0?ooo`007P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo0:/0oooo000N0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool0Z`3oool001h0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`2[0?ooo`007P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0:`0oooo000N
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0[03oool001h0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`2/0?ooo`007P3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo0:d0oooo000N0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
[@3oool001h0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`2]0?ooo`007P3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0:d0oooo000N0?ooo`030000003oool0oooo
0280oooo00<000000?ooo`3oool0[P3oool001h0oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`2^0?ooo`007P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0:h0oooo
000N0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0[`3oool001h0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`2_0?ooo`007P3oool00`000000oooo0?ooo`0Q0?oo
o`030000003oool0oooo0:l0oooo000N0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3o
ool0[`3oool001h0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`2`0?ooo`007P3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0;00oooo000N0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0/03oool000/0oooo0P0000040?ooo`030000003oool0oooo
00<0oooo0P0000050?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0/@3oool000X0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool0/@3oool000X0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000040?ooo`800000803oool00`000000oooo0?ooo`2a0?ooo`002P3oool0
10000000oooo0?ooo`0000090?ooo`8000001@3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo0;40oooo000:0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0;80oooo000:0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo0;80oooo000;0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`2b0?ooo`007P3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo0;80oooo000N0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0/`3oool0
01h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`2c0?ooo`00m03oool00?@0oooo
003d0?ooo`00L`3oool3000007h0oooo001f0?ooo`030000003oool0oooo07/0oooo001d0?ooo`<0
00000P3oool500000080oooo0P000000103oool000000?ooo`3oool200000080oooo0`0000000`3o
ool000000000001T0?ooo`00L`3oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo
0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool0H`3oool007<0oooo00@000000?ooo`3oool00000103oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo06<0oooo001c0?ooo`040000003oool0oooo000000@0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`1S0?ooo`00M03oool2000000030?ooo`000000oooo0080oooo
00<000000?ooo`3oool00P0000000`3oool00000000000030?ooo`8000000P3oool010000000oooo
00000000001V0?ooo`00N`3oool00`000000oooo0?ooo`1f0?ooo`00NP3oool2000007P0oooo0000
\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.15159, -0.0780715, \
0.00503853, 0.00672766}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.826262 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .09734 -18 -4.5 ]
[.01131 .09734 0 4.5 ]
[.01131 .17997 -18 -4.5 ]
[.01131 .17997 0 4.5 ]
[.01131 .26259 -18 -4.5 ]
[.01131 .26259 0 4.5 ]
[.01131 .34522 -18 -4.5 ]
[.01131 .34522 0 4.5 ]
[.01131 .42785 -18 -4.5 ]
[.01131 .42785 0 4.5 ]
[.01131 .51047 -18 -4.5 ]
[.01131 .51047 0 4.5 ]
[.01131 .5931 -18 -4.5 ]
[.01131 .5931 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09734 m
.03006 .09734 L
s
[(0.1)] .01131 .09734 1 0 Mshowa
.02381 .17997 m
.03006 .17997 L
s
[(0.2)] .01131 .17997 1 0 Mshowa
.02381 .26259 m
.03006 .26259 L
s
[(0.3)] .01131 .26259 1 0 Mshowa
.02381 .34522 m
.03006 .34522 L
s
[(0.4)] .01131 .34522 1 0 Mshowa
.02381 .42785 m
.03006 .42785 L
s
[(0.5)] .01131 .42785 1 0 Mshowa
.02381 .51047 m
.03006 .51047 L
s
[(0.6)] .01131 .51047 1 0 Mshowa
.02381 .5931 m
.03006 .5931 L
s
[(0.7)] .01131 .5931 1 0 Mshowa
.125 Mabswid
.02381 .03124 m
.02756 .03124 L
s
.02381 .04777 m
.02756 .04777 L
s
.02381 .06429 m
.02756 .06429 L
s
.02381 .08082 m
.02756 .08082 L
s
.02381 .11387 m
.02756 .11387 L
s
.02381 .13039 m
.02756 .13039 L
s
.02381 .14692 m
.02756 .14692 L
s
.02381 .16344 m
.02756 .16344 L
s
.02381 .19649 m
.02756 .19649 L
s
.02381 .21302 m
.02756 .21302 L
s
.02381 .22954 m
.02756 .22954 L
s
.02381 .24607 m
.02756 .24607 L
s
.02381 .27912 m
.02756 .27912 L
s
.02381 .29564 m
.02756 .29564 L
s
.02381 .31217 m
.02756 .31217 L
s
.02381 .32869 m
.02756 .32869 L
s
.02381 .36175 m
.02756 .36175 L
s
.02381 .37827 m
.02756 .37827 L
s
.02381 .3948 m
.02756 .3948 L
s
.02381 .41132 m
.02756 .41132 L
s
.02381 .44437 m
.02756 .44437 L
s
.02381 .4609 m
.02756 .4609 L
s
.02381 .47742 m
.02756 .47742 L
s
.02381 .49395 m
.02756 .49395 L
s
.02381 .527 m
.02756 .527 L
s
.02381 .54352 m
.02756 .54352 L
s
.02381 .56005 m
.02756 .56005 L
s
.02381 .57657 m
.02756 .57657 L
s
.02381 .60962 m
.02756 .60962 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03333 .35144 m
.05195 .41344 L
.07158 .46574 L
.09318 .51159 L
.1133 .54502 L
.1315 .56826 L
.15097 .58627 L
.16109 .59298 L
.16641 .59581 L
.17206 .59831 L
.177 .60006 L
.18243 .60155 L
.18481 .60206 L
.18737 .60251 L
.18979 .60284 L
.192 .60307 L
.19328 .60316 L
.19448 .60323 L
.19555 .60328 L
.19672 .60331 L
.19799 .60332 L
.19864 .60331 L
.19934 .6033 L
.20059 .60327 L
.20175 .60321 L
.20292 .60314 L
.20403 .60305 L
.20612 .60284 L
.20836 .60254 L
.2108 .60214 L
.21597 .60103 L
.22145 .59946 L
.23131 .59569 L
.24059 .59107 L
.25059 .58499 L
.26869 .57135 L
.30942 .53016 L
.34864 .48042 L
.38637 .42697 L
.42653 .36752 L
.46518 .31058 L
.50626 .25286 L
.54585 .20178 L
.58393 .15805 L
.62444 .11815 L
.66345 .08655 L
.70095 .06247 L
.72182 .05164 L
.74089 .04327 L
.77933 .03041 L
Mistroke
.79816 .02586 L
.81869 .02204 L
.8382 .01935 L
.84911 .0182 L
.85898 .01734 L
.86827 .01668 L
.87807 .01613 L
.88882 .01565 L
.8987 .01533 L
.90811 .0151 L
.91338 .01501 L
.91818 .01493 L
.92265 .01488 L
.92751 .01483 L
.9321 .0148 L
.93634 .01477 L
.94094 .01475 L
.94353 .01474 L
.9459 .01474 L
.95027 .01473 L
.95246 .01472 L
.95486 .01472 L
.95624 .01472 L
.95754 .01472 L
.95998 .01472 L
.96134 .01472 L
.9626 .01472 L
.96398 .01472 L
.96544 .01472 L
.96661 .01472 L
.96786 .01472 L
.96904 .01472 L
.97012 .01472 L
.97139 .01472 L
.9721 .01472 L
.97276 .01472 L
.97398 .01472 L
.97527 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo000n0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo1000000>0?ooo`00?@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`0=0?ooo`00?@3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`00000?0?ooo`007P3oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo
0=<0oooo000N0?ooo`030000003oool0oooo0=<0oooo000I0?ooom4000002P3oool001h0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`h000001`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool00P3oool4000001l0oooo00<000000?ooo`3oool03@3oool001h0oooo00<000000?oo
o`3oool0W03oool4000003<0oooo000N0?ooo`030000003oool0oooo09P0oooo1000000g0?ooo`00
7P3oool00`000000oooo0?ooo`2D0?ooo`@00000>`3oool001h0oooo00<000000?ooo`3oool0T@3o
ool3000003l0oooo000N0?ooo`030000003oool0oooo08l0oooo0P0000120?ooo`007P3oool00`00
0000oooo0?ooo`2=0?ooo`800000A03oool001h0oooo00<000000?ooo`3oool0R`3oool2000004H0
oooo000N0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0AP3oool001h0oooo00<0
00000?ooo`3oool0R03oool2000004T0oooo000N0?ooo`030000003oool0oooo08H0oooo0P00001;
0?ooo`007P3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo04/0oooo000N0?ooo`03
0000003oool0oooo08<0oooo0P00001>0?ooo`007P3oool00`000000oooo0?ooo`220?ooo`030000
003oool0oooo04h0oooo000;0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@00000103o
ool00`000000oooo0?ooo`210?ooo`030000003oool0oooo04l0oooo000:0?ooo`040000003oool0
oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`200?ooo`030000003o
ool0oooo0500oooo000:0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3o
ool2000007l0oooo0P00001C0?ooo`002P3oool010000000oooo0?ooo`00000:0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`1C0?ooo`002P3oool0
10000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0O03o
ool00`000000oooo0?ooo`1D0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`<000001@3o
ool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo05D0oooo000;0?ooo`8000002`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0EP3oool0
01h0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`1G0?ooo`007P3oool00`000000
oooo0?ooo`1h0?ooo`030000003oool0oooo05P0oooo000N0?ooo`030000003oool0oooo07L0oooo
00<000000?ooo`3oool0F@3oool001h0oooo00<000000?ooo`3oool0M@3oool2000005`0oooo000N
0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0G03oool001h0oooo00<000000?oo
o`3oool0L`3oool00`000000oooo0?ooo`1M0?ooo`007P3oool00`000000oooo0?ooo`1b0?ooo`03
0000003oool0oooo05h0oooo000N0?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool0
G`3oool001h0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`1P0?ooo`007P3oool0
0`000000oooo0?ooo`1_0?ooo`030000003oool0oooo0640oooo000;0?ooo`800000103oool00`00
0000oooo0?ooo`020?ooo`@00000103oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo
0680oooo000:0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`1]0?ooo`030000003oool0oooo06<0oooo000:0?ooo`040000003oool0oooo0000
00T0oooo00<000000?ooo`3oool0103oool2000006h0oooo00<000000?ooo`3oool0H`3oool000X0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
06`0oooo00<000000?ooo`3oool0I03oool000X0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0I@3oool000X0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo06X0oooo00<000000?ooo`3oool0IP3oool000/0oooo0P00000:0?ooo`8000001@3oool00`00
0000oooo0?ooo`1Y0?ooo`030000003oool0oooo06L0oooo000N0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0J03oool001h0oooo00<000000?ooo`3oool0J03oool00`000000oooo
0?ooo`1X0?ooo`007P3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo06T0oooo000N
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0JP3oool001h0oooo00<000000?oo
o`3oool0I@3oool00`000000oooo0?ooo`1[0?ooo`007P3oool00`000000oooo0?ooo`1U0?ooo`03
0000003oool0oooo06/0oooo000N0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0
K03oool001h0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1]0?ooo`007P3oool0
0`000000oooo0?ooo`1R0?ooo`030000003oool0oooo06h0oooo000N0?ooo`030000003oool0oooo
0680oooo00<000000?ooo`3oool0KP3oool000/0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0P0000050?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0K`3oool000X0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0600oooo00<000000?ooo`3oool0L03oool000X0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`020?ooo`800000H@3oool00`000000oooo0?ooo`1`0?ooo`002P3oool010000000
oooo0?ooo`0000090?ooo`8000001@3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo
0740oooo000:0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`1N0?ooo`030000003oool0oooo0780oooo000:0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1N0?ooo`030000003oool0
oooo0780oooo000;0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0G@3oool00`00
0000oooo0?ooo`1c0?ooo`007P3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo07@0
oooo000N0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0M03oool001h0oooo00<0
00000?ooo`3oool0F`3oool00`000000oooo0?ooo`1e0?ooo`007P3oool00`000000oooo0?ooo`1J
0?ooo`030000003oool0oooo07H0oooo000N0?ooo`030000003oool0oooo05X0oooo00<000000?oo
o`3oool0MP3oool001h0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1g0?ooo`00
7P3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo07P0oooo000N0?ooo`030000003o
ool0oooo05P0oooo00<000000?ooo`3oool0N03oool001h0oooo00<000000?ooo`3oool0E`3oool0
0`000000oooo0?ooo`1i0?ooo`007P3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo
07X0oooo000;0?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1j0?ooo`002P3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`1k0?ooo`002P3oool010000000oooo0?ooo`0000070?ooo`D00000103oool2000005D0
oooo00<000000?ooo`3oool0O03oool000X0oooo00@000000?ooo`3oool000001`3oool010000000
oooo0?ooo`0000050?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0O03oool000X0
oooo00@000000?ooo`3oool00000203oool00`000000oooo000000050?ooo`030000003oool00000
05<0oooo00<000000?ooo`3oool0O@3oool000X0oooo00@000000?ooo`3oool000002@3oool20000
00D0oooo00<000000?ooo`000000DP3oool00`000000oooo0?ooo`1n0?ooo`002`3oool2000000/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0000001B0?ooo`030000003oool0oooo07h0
oooo000N0?ooo`040000003oool0oooo00000500oooo00<000000?ooo`3oool0O`3oool001h0oooo
00@000000?ooo`3oool00000C`3oool00`000000oooo0?ooo`200?ooo`007P3oool010000000oooo
0?ooo`00001?0?ooo`030000003oool0oooo0800oooo000N0?ooo`040000003oool0oooo000004h0
oooo00<000000?ooo`3oool0P@3oool001h0oooo00D000000?ooo`3oool0oooo0000001<0?ooo`03
0000003oool0oooo0880oooo000N0?ooo`050000003oool0oooo0?ooo`000000B`3oool00`000000
oooo0?ooo`230?ooo`007P3oool01@000000oooo0?ooo`3oool0000004/0oooo00<000000?ooo`3o
ool0P`3oool001h0oooo00D000000?ooo`3oool0oooo0000001:0?ooo`030000003oool0oooo08@0
oooo000N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0AP3oool00`000000oooo
0?ooo`250?ooo`007P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0QP3oool000/0oooo0P0000040?ooo`030000003oool0oooo0080oooo0`000005
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`26
0?ooo`002P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo08L0oooo000:0?oo
o`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`280?ooo`002P3oool010000000oooo0?ooo`000008
0?ooo`<000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0R@3oool000X0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`29
0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo08X0oooo000;0?oo
o`8000002@3oool4000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo08/0oooo000N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`2<0?ooo`007P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0S03oool001h0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo08d0oooo000N0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`2>0?ooo`007P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0S`3oool001h0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo08l0
oooo000N0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0=@3oool00`000000oooo
0?ooo`2@0?ooo`007P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0T@3oool001h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0c
0?ooo`030000003oool0oooo0940oooo000N0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`2B0?ooo`007P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool0T`3oool000/0oooo0P0000040?ooo`030000
003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`2D0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo09@0oooo000:0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool00000103oool2000000`0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2E0?oo
o`002P3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0UP3oool000X0oooo00@000000?ooo`3o
ool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0:P3oool00`000000oooo0?ooo`2G0?ooo`002P3oool010000000oooo0?ooo`0000080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0Y0?oo
o`030000003oool0oooo09L0oooo000;0?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo09P0oooo000N0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2I0?ooo`007P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0VP3o
ool001h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo09/0oooo000N0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`2L0?ooo`007P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0W@3oool001h0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo09h0oooo000N0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`2O0?ooo`007P3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0X03oool001h0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0G0?ooo`800000X`3oool001h0oooo00<000000?ooo`3o
ool05@3oool2000001H0oooo00<000000?ooo`3oool0X`3oool000/0oooo0P0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo0140oooo0P00002V0?ooo`002P3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0>0?ooo`800000
Z03oool000X0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`800000
6P3oool2000000`0oooo0P00002Z0?ooo`002P3oool010000000oooo0?ooo`00000:0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool06`3oool3000000P0oooo00<000000?ooo`3oool0
ZP3oool000X0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01h0oooo2000002]0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0d`3oool000/0oooo0P0000090?ooo`@00000
103oool00`000000oooo0?ooo`3C0?ooo`007P3oool00`000000oooo0?ooo`3C0?ooo`00m03oool0
0?@0oooo003d0?ooo`00N`3oool3000007H0oooo001l0?ooo`030000003oool0oooo07D0oooo001^
0?ooo`80000000<0oooo0000003oool01`3oool3000000<0oooo0P000000103oool000000?ooo`3o
ool2000000030?ooo`000000oooo00@0000000@0oooo000000000000oooo0P00001O0?ooo`00K@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`000000H03oool006d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000000<0oooo0`0000030?ooo`030000003oool0oooo0080oooo
0P00001Q0?ooo`00K@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`000000H03oool006`0oooo0P0000000`3oool00000000000090?ooo`80000000D0oooo0000
0000000000000?ooo`02000000<0oooo0P0000030?ooo`030000003oool000000080000000<0oooo
0000003oool00P00001O0?ooo`00T@3oool00`000000oooo0?ooo`1P0?ooo`00T03oool200000680
oooo0000\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.15159, -0.0673946, \
0.00503853, 0.0058076}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 1.35087 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .1498 -18 -4.5 ]
[.01131 .1498 0 4.5 ]
[.01131 .28489 -18 -4.5 ]
[.01131 .28489 0 4.5 ]
[.01131 .41998 -18 -4.5 ]
[.01131 .41998 0 4.5 ]
[.01131 .55507 -18 -4.5 ]
[.01131 .55507 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .1498 m
.03006 .1498 L
s
[(0.1)] .01131 .1498 1 0 Mshowa
.02381 .28489 m
.03006 .28489 L
s
[(0.2)] .01131 .28489 1 0 Mshowa
.02381 .41998 m
.03006 .41998 L
s
[(0.3)] .01131 .41998 1 0 Mshowa
.02381 .55507 m
.03006 .55507 L
s
[(0.4)] .01131 .55507 1 0 Mshowa
.125 Mabswid
.02381 .04173 m
.02756 .04173 L
s
.02381 .06875 m
.02756 .06875 L
s
.02381 .09577 m
.02756 .09577 L
s
.02381 .12279 m
.02756 .12279 L
s
.02381 .17682 m
.02756 .17682 L
s
.02381 .20384 m
.02756 .20384 L
s
.02381 .23086 m
.02756 .23086 L
s
.02381 .25787 m
.02756 .25787 L
s
.02381 .31191 m
.02756 .31191 L
s
.02381 .33893 m
.02756 .33893 L
s
.02381 .36594 m
.02756 .36594 L
s
.02381 .39296 m
.02756 .39296 L
s
.02381 .447 m
.02756 .447 L
s
.02381 .47401 m
.02756 .47401 L
s
.02381 .50103 m
.02756 .50103 L
s
.02381 .52805 m
.02756 .52805 L
s
.02381 .58208 m
.02756 .58208 L
s
.02381 .6091 m
.02756 .6091 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03333 .50157 m
.05195 .5426 L
.06144 .55983 L
.07158 .57479 L
.08189 .58651 L
.09149 .59449 L
.09736 .59805 L
.10024 .59945 L
.10291 .60055 L
.10528 .60136 L
.10789 .60209 L
.11051 .60265 L
.11195 .60289 L
.1133 .60306 L
.11453 .60318 L
.11522 .60323 L
.11584 .60327 L
.11706 .60331 L
.11821 .60332 L
.11886 .60331 L
.11955 .60329 L
.12079 .60323 L
.12147 .60318 L
.12211 .60312 L
.12357 .60296 L
.12604 .60257 L
.12829 .60211 L
.13334 .60067 L
.13785 .59894 L
.14276 .59661 L
.15168 .59122 L
.17126 .5748 L
.19205 .55164 L
.22943 .49964 L
.26923 .43632 L
.30753 .37358 L
.34826 .30936 L
.38749 .25256 L
.42521 .20391 L
.46537 .1591 L
.50402 .12281 L
.54511 .0913 L
.58469 .06734 L
.62277 .04966 L
.64206 .04251 L
.66328 .03592 L
.70229 .02683 L
.72154 .02359 L
.74222 .02088 L
.76319 .01882 L
Mistroke
.78309 .01739 L
.7926 .01686 L
.80274 .01639 L
.82095 .01574 L
.83116 .01548 L
.84219 .01525 L
.8526 .01509 L
.86217 .01498 L
.87183 .01489 L
.88084 .01483 L
.89073 .01479 L
.89627 .01477 L
.90131 .01475 L
.90609 .01474 L
.91115 .01474 L
.91548 .01473 L
.92025 .01473 L
.92536 .01472 L
.92823 .01472 L
.93086 .01472 L
.93571 .01472 L
.93815 .01472 L
.94081 .01472 L
.94303 .01472 L
.94543 .01472 L
.9477 .01472 L
.94979 .01472 L
.95167 .01472 L
.95374 .01472 L
.95479 .01472 L
.95591 .01472 L
.95793 .01472 L
.95915 .01472 L
.96028 .01472 L
.96151 .01472 L
.96215 .01472 L
.96283 .01472 L
.96397 .01472 L
.96504 .01472 L
.96631 .01472 L
.96748 .01472 L
.96853 .01472 L
.9695 .01472 L
.97057 .01472 L
.97172 .01472 L
.97292 .01472 L
.97406 .01472 L
.97508 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo000n0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo1000000>0?ooo`00?@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool003d0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`0=0?ooo`00?@3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool03@3oool003d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`00000?0?ooo`007P3oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo
0=<0oooo000N0?ooo`030000003oool0oooo0=<0oooo000I0?ooom4000002P3oool001h0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00@0
00000?ooo`3oool0oooo4@0000090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0=0?ooo`007P3oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0E0?ooo`T000001P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0
oooo08P0oooo100000170?ooo`007P3oool00`000000oooo0?ooo`240?ooo`@00000B`3oool001h0
oooo00<000000?ooo`3oool0P03oool4000004l0oooo000N0?ooo`030000003oool0oooo07`0oooo
1000001C0?ooo`007P3oool00`000000oooo0?ooo`1j0?ooo`800000E`3oool001h0oooo00<00000
0?ooo`3oool0N03oool2000005T0oooo000N0?ooo`030000003oool0oooo07D0oooo0`00001K0?oo
o`007P3oool00`000000oooo0?ooo`1c0?ooo`800000GP3oool001h0oooo00<000000?ooo`3oool0
L@3oool200000600oooo000N0?ooo`030000003oool0oooo06l0oooo0P00001R0?ooo`007P3oool0
0`000000oooo0?ooo`1]0?ooo`800000I03oool001h0oooo00<000000?ooo`3oool0K03oool00`00
0000oooo0?ooo`1T0?ooo`007P3oool00`000000oooo0?ooo`1Z0?ooo`800000I`3oool001h0oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1W0?ooo`007P3oool00`000000oooo0?oo
o`1X0?ooo`030000003oool0oooo06P0oooo000N0?ooo`030000003oool0oooo06L0oooo00<00000
0?ooo`3oool0J@3oool001h0oooo00<000000?ooo`3oool0I@3oool2000006`0oooo000N0?ooo`03
0000003oool0oooo06@0oooo00<000000?ooo`3oool0K03oool001h0oooo00<000000?ooo`3oool0
H`3oool00`000000oooo0?ooo`1]0?ooo`007P3oool00`000000oooo0?ooo`1R0?ooo`030000003o
ool0oooo06h0oooo000N0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0K`3oool0
01h0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`1`0?ooo`007P3oool00`000000
oooo0?ooo`1O0?ooo`030000003oool0oooo0740oooo000N0?ooo`030000003oool0oooo05d0oooo
0P00001d0?ooo`002`3oool2000000@0oooo00<000000?ooo`3oool00P3oool4000000@0oooo00<0
00000?ooo`3oool0G03oool00`000000oooo0?ooo`1d0?ooo`002P3oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?oo
o`1e0?ooo`002P3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo0P00
001K0?ooo`030000003oool0oooo07H0oooo000:0?ooo`040000003oool0oooo000000X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo07L0oooo000:
0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1H0?ooo`030000003oool0oooo07P0oooo000:0?ooo`040000003oool0oooo000000P0oooo0`00
00050?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0N@3oool000/0oooo0P00000;
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1j
0?ooo`007P3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo07/0oooo000N0?ooo`03
0000003oool0oooo05D0oooo00<000000?ooo`3oool0N`3oool001h0oooo00<000000?ooo`3oool0
E03oool00`000000oooo0?ooo`1l0?ooo`007P3oool00`000000oooo0?ooo`1C0?ooo`030000003o
ool0oooo07d0oooo000N0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0OP3oool0
01h0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1o0?ooo`007P3oool00`000000
oooo0?ooo`1@0?ooo`030000003oool0oooo0800oooo000N0?ooo`030000003oool0oooo04l0oooo
00<000000?ooo`3oool0P@3oool001h0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?oo
o`220?ooo`007P3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0880oooo000N0?oo
o`030000003oool0oooo04d0oooo00<000000?ooo`3oool0P`3oool001h0oooo00<000000?ooo`3o
ool0C03oool00`000000oooo0?ooo`240?ooo`007P3oool00`000000oooo0?ooo`1;0?ooo`030000
003oool0oooo08D0oooo000N0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0QP3o
ool001h0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`260?ooo`007P3oool00`00
0000oooo0?ooo`190?ooo`030000003oool0oooo08L0oooo000N0?ooo`030000003oool0oooo04P0
oooo00<000000?ooo`3oool0R03oool001h0oooo00<000000?ooo`3oool0A`3oool00`000000oooo
0?ooo`290?ooo`007P3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo08T0oooo000N
0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0RP3oool001h0oooo00<000000?oo
o`3oool0A@3oool00`000000oooo0?ooo`2;0?ooo`002`3oool2000000@0oooo00<000000?ooo`3o
ool00P3oool4000000@0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`2;0?ooo`00
2P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0A03oool00`000000oooo0?ooo`2<0?ooo`002P3oool010000000oooo0?ooo`0000090?ooo`03
0000003oool0oooo00@0oooo0P0000140?ooo`030000003oool0oooo08d0oooo000:0?ooo`040000
003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`03
0000003oool0oooo08d0oooo000:0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo08h0oooo000:0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`110?oo
o`030000003oool0oooo08l0oooo000;0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3o
ool0@@3oool00`000000oooo0?ooo`2?0?ooo`007P3oool00`000000oooo0?ooo`100?ooo`030000
003oool0oooo0900oooo000N0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0T@3o
ool001h0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`2A0?ooo`007P3oool00`00
0000oooo0?ooo`0n0?ooo`030000003oool0oooo0980oooo000N0?ooo`030000003oool0oooo03h0
oooo00<000000?ooo`3oool0TP3oool001h0oooo00<000000?ooo`3oool0?@3oool00`000000oooo
0?ooo`2C0?ooo`007P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo09@0oooo000N
0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0U03oool001h0oooo00<000000?oo
o`3oool0>`3oool00`000000oooo0?ooo`2E0?ooo`007P3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo09H0oooo000N0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
UP3oool001h0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`2G0?ooo`007P3oool0
0`000000oooo0?ooo`0i0?ooo`030000003oool0oooo09L0oooo000N0?ooo`030000003oool0oooo
03P0oooo00<000000?ooo`3oool0V03oool001h0oooo00<000000?ooo`3oool0=`3oool00`000000
oooo0?ooo`2I0?ooo`007P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo09T0oooo
000N0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0VP3oool001h0oooo00<00000
0?ooo`3oool0=P3oool00`000000oooo0?ooo`2J0?ooo`007P3oool00`000000oooo0?ooo`0e0?oo
o`030000003oool0oooo09/0oooo000N0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3o
ool0W03oool001h0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2L0?ooo`002`3o
ool2000000@0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`2M0?ooo`002P3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`2N0?ooo`002P3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo0P00000c0?ooo`030000
003oool0oooo09h0oooo000:0?ooo`040000003oool0oooo000000T0oooo0P0000050?ooo`030000
003oool0oooo0340oooo00<000000?ooo`3oool0W`3oool000X0oooo00@000000?ooo`3oool00000
2`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
W`3oool000X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool0X03oool000/0oooo0P00000:0?ooo`800000
1@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0:40oooo000N0?ooo`030000003o
ool0oooo02l0oooo00<000000?ooo`3oool0X@3oool001h0oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`2R0?ooo`007P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
0:<0oooo000N0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0X`3oool001h0oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`2T0?ooo`007P3oool00`000000oooo0?oo
o`0[0?ooo`030000003oool0oooo0:D0oooo000N0?ooo`030000003oool0oooo02X0oooo00<00000
0?ooo`3oool0YP3oool001h0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`2V0?oo
o`007P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0:L0oooo000N0?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool0Z03oool001h0oooo00<000000?ooo`3oool0:03o
ool00`000000oooo0?ooo`2X0?ooo`007P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0
oooo0:T0oooo000N0?ooo`030000003oool0000002H0oooo00<000000?ooo`3oool0ZP3oool001h0
oooo00<000000?ooo`0000009P3oool00`000000oooo0?ooo`2Z0?ooo`007P3oool010000000oooo
0?ooo`00000T0?ooo`030000003oool0oooo0:/0oooo000N0?ooo`040000003oool0oooo000002<0
oooo00<000000?ooo`3oool0[03oool001h0oooo00@000000?ooo`3oool000008`3oool00`000000
oooo0?ooo`2/0?ooo`007P3oool01@000000oooo0?ooo`3oool000000240oooo00<000000?ooo`3o
ool0[@3oool001h0oooo00D000000?ooo`3oool0oooo0000000Q0?ooo`030000003oool0oooo0:d0
oooo000N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`2^0?ooo`007P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool0[`3oool000/0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0[`3oool000X0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`2`
0?ooo`002P3oool010000000oooo0?ooo`0000070?ooo`D00000103oool2000000@0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`2a0?ooo`002P3oool010000000oooo0?ooo`000007
0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo0;80oooo000:0?ooo`040000003oool0oooo000000P0oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0/`3oool000X0oooo00@000000?ooo`3oool000002@3oool2000000D0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0;@0oooo000;
0?ooo`8000002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`2e0?ooo`007P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00h0oooo0P00002h0?ooo`007P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0^03oool001h0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0;T0oooo000N0?ooo`030000003o
ool0oooo00X0oooo0P00000:0?ooo`030000003oool0oooo0;X0oooo000N0?ooo`030000003oool0
oooo00`0oooo0P0000050?ooo`<00000_@3oool001h0oooo00<000000?ooo`3oool03P3oool50000
0<00oooo000N0?ooo`030000003oool0oooo0=<0oooo000N0?ooo`030000003oool0oooo0=<0oooo
000N0?ooo`030000003oool0oooo0=<0oooo003d0?ooo`00m03oool00?@0oooo001k0?ooo`<00000
MP3oool007`0oooo00<000000?ooo`3oool0M@3oool006h0oooo0P0000000`3oool000000?ooo`07
0?ooo`<000000`3oool2000000040?ooo`000000oooo0?ooo`80000000<0oooo0000003oool01000
0000103oool000000000003oool2000005l0oooo001]0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000001P0?ooo`00K@3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0`3oool3000000<0oooo00<000000?ooo`3oool00P3oool200000640oooo001]0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0000001P0?ooo`00KP3oool30000
00T0oooo0P0000001@3oool00000000000000000oooo008000000`3oool2000000<0oooo00<00000
0?ooo`0000000P0000000`3oool000000?ooo`02000005l0oooo001`0?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool0H03oool006l0oooo0P00000O0?ooo`800000HP3oool00001\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.15159, -0.041222, \
0.00503853, 0.00355223}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 94.0551 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .10877 -30 -4.5 ]
[.01131 .10877 0 4.5 ]
[.01131 .20283 -30 -4.5 ]
[.01131 .20283 0 4.5 ]
[.01131 .29688 -30 -4.5 ]
[.01131 .29688 0 4.5 ]
[.01131 .39094 -30 -4.5 ]
[.01131 .39094 0 4.5 ]
[.01131 .48499 -30 -4.5 ]
[.01131 .48499 0 4.5 ]
[.01131 .57905 -30 -4.5 ]
[.01131 .57905 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .10877 m
.03006 .10877 L
s
[(0.001)] .01131 .10877 1 0 Mshowa
.02381 .20283 m
.03006 .20283 L
s
[(0.002)] .01131 .20283 1 0 Mshowa
.02381 .29688 m
.03006 .29688 L
s
[(0.003)] .01131 .29688 1 0 Mshowa
.02381 .39094 m
.03006 .39094 L
s
[(0.004)] .01131 .39094 1 0 Mshowa
.02381 .48499 m
.03006 .48499 L
s
[(0.005)] .01131 .48499 1 0 Mshowa
.02381 .57905 m
.03006 .57905 L
s
[(0.006)] .01131 .57905 1 0 Mshowa
.125 Mabswid
.02381 .03353 m
.02756 .03353 L
s
.02381 .05234 m
.02756 .05234 L
s
.02381 .07115 m
.02756 .07115 L
s
.02381 .08996 m
.02756 .08996 L
s
.02381 .12758 m
.02756 .12758 L
s
.02381 .14639 m
.02756 .14639 L
s
.02381 .1652 m
.02756 .1652 L
s
.02381 .18401 m
.02756 .18401 L
s
.02381 .22164 m
.02756 .22164 L
s
.02381 .24045 m
.02756 .24045 L
s
.02381 .25926 m
.02756 .25926 L
s
.02381 .27807 m
.02756 .27807 L
s
.02381 .31569 m
.02756 .31569 L
s
.02381 .3345 m
.02756 .3345 L
s
.02381 .35331 m
.02756 .35331 L
s
.02381 .37212 m
.02756 .37212 L
s
.02381 .40975 m
.02756 .40975 L
s
.02381 .42856 m
.02756 .42856 L
s
.02381 .44737 m
.02756 .44737 L
s
.02381 .46618 m
.02756 .46618 L
s
.02381 .5038 m
.02756 .5038 L
s
.02381 .52261 m
.02756 .52261 L
s
.02381 .54142 m
.02756 .54142 L
s
.02381 .56023 m
.02756 .56023 L
s
.02381 .59786 m
.02756 .59786 L
s
.02381 .61667 m
.02756 .61667 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.35144 .61803 m
.36713 .51576 L
.38843 .40268 L
.42774 .25016 L
.44721 .1958 L
.46798 .1499 L
.48917 .11354 L
.50914 .08717 L
.52902 .06707 L
.54731 .05293 L
.56594 .04198 L
.5864 .03314 L
.60571 .02716 L
.61654 .0246 L
.62642 .02267 L
.64531 .01987 L
.65599 .0187 L
.66587 .01783 L
.68434 .01664 L
.69486 .01616 L
.70474 .0158 L
.71447 .01553 L
.72472 .01532 L
.73347 .01517 L
.74304 .01505 L
.75321 .01495 L
.76246 .01489 L
.77312 .01483 L
.7832 .0148 L
.79282 .01477 L
.79767 .01476 L
.80301 .01475 L
.80756 .01475 L
.81245 .01474 L
.82128 .01473 L
.82648 .01473 L
.83131 .01473 L
.83705 .01472 L
.84224 .01472 L
.85188 .01472 L
.85717 .01472 L
.86214 .01472 L
.86716 .01472 L
.87183 .01472 L
.87671 .01472 L
.88206 .01472 L
.88668 .01472 L
.8909 .01472 L
.89576 .01472 L
.90036 .01472 L
Mistroke
.90492 .01472 L
.90994 .01472 L
.91519 .01472 L
.92011 .01472 L
.9247 .01472 L
.9289 .01472 L
.9311 .01472 L
.93351 .01472 L
.93836 .01472 L
.94073 .01472 L
.9433 .01472 L
.94572 .01472 L
.94795 .01472 L
.94997 .01472 L
.95219 .01472 L
.9545 .01472 L
.95666 .01472 L
.95787 .01472 L
.95919 .01472 L
.96043 .01472 L
.96159 .01472 L
.96262 .01472 L
.96377 .01472 L
.96496 .01472 L
.96608 .01472 L
.96732 .01472 L
.96862 .01472 L
.96973 .01472 L
.97094 .01472 L
.97163 .01472 L
.97226 .01472 L
.97298 .01472 L
.97366 .01472 L
.97487 .01472 L
.97556 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo00140?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo100000080?ooo`00@`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`070?ooo`00@`3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`0000090?ooo`00903oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo
0<d0oooo000T0?ooo`030000003oool0oooo0<d0oooo000O0?ooom400000103oool002@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01@3ooolB000000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00D000007`3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo
07@0oooo0`00001F0?ooo`00903oool00`000000oooo0?ooo`1a0?ooo`<00000F@3oool002@0oooo
00<000000?ooo`3oool0K`3oool2000005`0oooo000T0?ooo`030000003oool0oooo06d0oooo0P00
001N0?ooo`00903oool00`000000oooo0?ooo`1[0?ooo`800000H03oool002@0oooo00<000000?oo
o`3oool0JP3oool00`000000oooo0?ooo`1P0?ooo`00903oool00`000000oooo0?ooo`1X0?ooo`80
0000H`3oool002@0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1S0?ooo`00903o
ool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo06@0oooo000T0?ooo`030000003oool0
oooo06D0oooo00<000000?ooo`3oool0I@3oool002@0oooo00<000000?ooo`3oool0I03oool00`00
0000oooo0?ooo`1V0?ooo`00903oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo06L0
oooo000T0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0J03oool002@0oooo00<0
00000?ooo`3oool0H@3oool00`000000oooo0?ooo`1Y0?ooo`00903oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool0oooo06T0oooo00050?ooo`800000103oool00`000000oooo0?ooo`030?oo
o`800000103oool2000000<0oooo100000040?ooo`030000003oool0oooo0600oooo00<000000?oo
o`3oool0JP3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1O0?ooo`030000003oool0oooo06/0oooo00040?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0
oooo0P00001P0?ooo`030000003oool0oooo06/0oooo00040?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`1/0?ooo`00103oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0
K@3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo0`0000050?ooo`030000003oool0oooo05d0oooo00<000000?oo
o`3oool0K@3oool000D0oooo0P00000:0?ooo`800000103oool2000000D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo06h0oooo000T0?ooo`030000
003oool0oooo05`0oooo00<000000?ooo`3oool0KP3oool002@0oooo00<000000?ooo`3oool0F`3o
ool00`000000oooo0?ooo`1_0?ooo`00903oool00`000000oooo0?ooo`1J0?ooo`030000003oool0
oooo0700oooo000T0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0L03oool002@0
oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1a0?ooo`00903oool00`000000oooo
0?ooo`1I0?ooo`030000003oool0oooo0740oooo000T0?ooo`030000003oool0oooo05P0oooo00<0
00000?ooo`3oool0LP3oool002@0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1b
0?ooo`00903oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo07<0oooo000T0?ooo`03
0000003oool0oooo05L0oooo00<000000?ooo`3oool0L`3oool002@0oooo00<000000?ooo`3oool0
EP3oool00`000000oooo0?ooo`1d0?ooo`00903oool00`000000oooo0?ooo`1F0?ooo`030000003o
ool0oooo07@0oooo000T0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0M@3oool0
00D0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool40000
00@0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1e0?ooo`00103oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0M@3o
ool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool2000005D0oooo00<000000?ooo`3o
ool0MP3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1D
0?ooo`030000003oool0oooo07H0oooo00040?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`1f0?ooo`00103oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0M`3oool0
00D0oooo0P00000:0?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo
05<0oooo00<000000?ooo`3oool0M`3oool002@0oooo00<000000?ooo`3oool0DP3oool00`000000
oooo0?ooo`1h0?ooo`00903oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo07P0oooo
000T0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0N03oool002@0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`1i0?ooo`00903oool00`000000oooo0?ooo`1A0?oo
o`030000003oool0oooo07T0oooo000T0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3o
ool0N@3oool002@0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1i0?ooo`00903o
ool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo07X0oooo000T0?ooo`030000003oool0
oooo0500oooo00<000000?ooo`3oool0NP3oool002@0oooo00<000000?ooo`3oool0D03oool00`00
0000oooo0?ooo`1j0?ooo`00903oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo07X0
oooo000T0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0N`3oool000D0oooo0P00
00040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000103oool2000000D0oooo00<0
00000?ooo`3oool0C`3oool00`000000oooo0?ooo`1k0?ooo`00103oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0N`3oool000@0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000D0oooo00<000000?ooo`3oool00P3oool200000500oooo00<000000?ooo`3oool0N`3o
ool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000<0oooo0P0000050?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3o
ool0O03oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1>
0?ooo`030000003oool0oooo07`0oooo00040?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`1l0?ooo`001@3oool2000000X0oooo
0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0CP3oool00`000000oooo
0?ooo`1l0?ooo`00903oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo07d0oooo000T
0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0O@3oool002@0oooo00<000000?oo
o`3oool0C@3oool00`000000oooo0?ooo`1m0?ooo`00903oool00`000000oooo0?ooo`1=0?ooo`03
0000003oool0oooo07d0oooo000T0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0
OP3oool002@0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`1n0?ooo`00903oool0
0`000000oooo0?ooo`1<0?ooo`030000003oool0oooo07h0oooo000T0?ooo`030000003oool0oooo
04`0oooo00<000000?ooo`3oool0OP3oool002@0oooo00<000000?ooo`3oool0B`3oool00`000000
oooo0?ooo`1o0?ooo`00903oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo07l0oooo
000T0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0O`3oool002@0oooo00<00000
0?ooo`3oool0B`3oool00`000000oooo0?ooo`1o0?ooo`00903oool00`000000oooo0?ooo`1:0?oo
o`030000003oool0oooo0800oooo00050?ooo`800000103oool00`000000oooo0?ooo`030?ooo`80
0000103oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1:0?ooo`03
0000003oool0oooo0800oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0BP3oool00`000000oooo0?ooo`200?ooo`00103oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool000000?ooo`05000000@0oooo
0P00001;0?ooo`030000003oool0oooo0800oooo00040?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0840oooo00040?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0B@3oool00`000000oooo
0?ooo`210?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000000`3oool2000000D0oooo00<000000?ooo`3oool0B@3oool00`00
0000oooo0?ooo`210?ooo`001@3oool2000000X0oooo0P0000040?ooo`8000001@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0P@3oool002@0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`220?ooo`00903oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo0880oooo000T0?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool0PP3oool002@0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`220?oo
o`00903oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0880oooo000T0?ooo`030000
003oool0oooo04L0oooo00<000000?ooo`3oool0P`3oool002@0oooo00<000000?ooo`3oool0A`3o
ool00`000000oooo0?ooo`230?ooo`00903oool00`000000oooo0?ooo`170?ooo`030000003oool0
oooo08<0oooo000T0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0P`3oool002@0
oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`230?ooo`00903oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo08@0oooo000T0?ooo`030000003oool0oooo04H0oooo00<0
00000?ooo`3oool0Q03oool000D0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P000004
0?ooo`8000000`3oool3000000D0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`24
0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04H0oooo
00<000000?ooo`3oool0Q03oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3oool20000
04H0oooo00<000000?ooo`3oool0Q@3oool000@0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`0000050?ooo`030000003o
ool0oooo04D0oooo00<000000?ooo`3oool0Q@3oool000@0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo08D0oooo00040?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`25
0?ooo`001@3oool2000000X0oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?oo
o`3oool0A@3oool00`000000oooo0?ooo`250?ooo`00903oool00`000000oooo0?ooo`140?ooo`03
0000003oool0oooo08H0oooo000T0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0
QP3oool002@0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`260?ooo`00903oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo08H0oooo000T0?ooo`030000003oool0oooo
04@0oooo00<000000?ooo`3oool0QP3oool002@0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`260?ooo`00903oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo08L0oooo
000T0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0Q`3oool002@0oooo00<00000
0?ooo`3oool0@`3oool00`000000oooo0?ooo`270?ooo`00903oool00`000000oooo0?ooo`130?oo
o`030000003oool0oooo08L0oooo000T0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3o
ool0Q`3oool002@0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`270?ooo`00903o
ool00`000000oooo0?ooo`130?ooo`030000003oool0oooo08L0oooo00050?ooo`800000103oool0
0`000000oooo0?ooo`030?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0
oooo0480oooo00<000000?ooo`3oool0R03oool000@0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo08P0oooo00040?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000@0oooo0P0000130?ooo`030000003oool0oooo08P0oooo0004
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`<000001@3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo08P0
oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0@P3oool0
0`000000oooo0?ooo`280?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool0R03oool000D0oooo0P00000:0?ooo`800000103o
ool2000000@0oooo0`0000040?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0R03o
ool002@0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`290?ooo`00903oool00`00
0000oooo0?ooo`110?ooo`030000003oool0oooo08T0oooo000T0?ooo`030000003oool0oooo0440
oooo00<000000?ooo`3oool0R@3oool002@0oooo00<000000?ooo`3oool0@@3oool00`000000oooo
0?ooo`290?ooo`00m03oool00?@0oooo003d0?ooo`00P@3oool300000700oooo00220?ooo`030000
003oool0oooo06l0oooo001c0?ooo`<000002P3oool3000000<0oooo0P000000103oool000000?oo
o`3oool2000000030?ooo`000000oooo00@0000000@0oooo000000000000oooo0P00001I0?ooo`00
MP3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`000000FP3oool007@0oooo0P0000090?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000`3oool3000000<0oooo00<000000?ooo`3oool00P3oool2000005/0oooo001c
0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0000001J0?ooo`00
M03oool3000000T0oooo0P0000001@3oool00000000000000000oooo008000000`3oool2000000<0
oooo00<000000?ooo`0000000P0000000`3oool000000?ooo`02000005T0oooo002G0?ooo`030000
003oool0oooo05X0oooo002F0?ooo`800000G03oool00001\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.181821, -0.000592053, \
0.00503853, 5.1019*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 74.3311 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .16338 -30 -4.5 ]
[.01131 .16338 0 4.5 ]
[.01131 .31204 -30 -4.5 ]
[.01131 .31204 0 4.5 ]
[.01131 .4607 -30 -4.5 ]
[.01131 .4607 0 4.5 ]
[.01131 .60936 -30 -4.5 ]
[.01131 .60936 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .16338 m
.03006 .16338 L
s
[(0.002)] .01131 .16338 1 0 Mshowa
.02381 .31204 m
.03006 .31204 L
s
[(0.004)] .01131 .31204 1 0 Mshowa
.02381 .4607 m
.03006 .4607 L
s
[(0.006)] .01131 .4607 1 0 Mshowa
.02381 .60936 m
.03006 .60936 L
s
[(0.008)] .01131 .60936 1 0 Mshowa
.125 Mabswid
.02381 .05188 m
.02756 .05188 L
s
.02381 .08905 m
.02756 .08905 L
s
.02381 .12621 m
.02756 .12621 L
s
.02381 .20054 m
.02756 .20054 L
s
.02381 .23771 m
.02756 .23771 L
s
.02381 .27487 m
.02756 .27487 L
s
.02381 .3492 m
.02756 .3492 L
s
.02381 .38637 m
.02756 .38637 L
s
.02381 .42354 m
.02756 .42354 L
s
.02381 .49787 m
.02756 .49787 L
s
.02381 .53503 m
.02756 .53503 L
s
.02381 .5722 m
.02756 .5722 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.15083 .61803 m
.15225 .60641 L
.17147 .48682 L
.19214 .38705 L
.21306 .3087 L
.23295 .25016 L
.27076 .1696 L
.29024 .13957 L
.311 .11382 L
.33078 .0941 L
.35217 .07694 L
.39183 .05378 L
.41157 .04541 L
.43243 .03831 L
.47002 .02899 L
.48933 .02555 L
.51004 .02266 L
.53107 .02041 L
.55098 .01879 L
.5707 .01758 L
.58893 .01674 L
.60741 .01612 L
.61805 .01584 L
.6278 .01562 L
.64696 .0153 L
.65702 .01518 L
.66761 .01507 L
.67706 .01499 L
.68715 .01493 L
.69661 .01488 L
.70533 .01484 L
.71547 .01481 L
.72647 .01478 L
.73616 .01477 L
.74642 .01475 L
.75576 .01474 L
.76579 .01473 L
.77527 .01473 L
.78392 .01473 L
.7937 .01472 L
.80276 .01472 L
.8127 .01472 L
.81826 .01472 L
.82329 .01472 L
.82813 .01472 L
.83324 .01472 L
.84238 .01472 L
.84747 .01472 L
.85222 .01472 L
.85739 .01472 L
Mistroke
.86301 .01472 L
.8684 .01472 L
.87338 .01472 L
.87805 .01472 L
.88319 .01472 L
.89211 .01472 L
.897 .01472 L
.90158 .01472 L
.90624 .01472 L
.91134 .01472 L
.91665 .01472 L
.9216 .01472 L
.92625 .01472 L
.93047 .01472 L
.93534 .01472 L
.93993 .01472 L
.9443 .01472 L
.9491 .01472 L
.95152 .01472 L
.95412 .01472 L
.95636 .01472 L
.95881 .01472 L
.96123 .01472 L
.96347 .01472 L
.96562 .01472 L
.9667 .01472 L
.9679 .01472 L
.96897 .01472 L
.96995 .01472 L
.97103 .01472 L
.97217 .01472 L
.97317 .01472 L
.97409 .01472 L
.97511 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo00140?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000006@3oool2000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`800000103oool00`000000
oooo0?ooo`030?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000001l0
oooo100000080?ooo`00@`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000000L0oooo1@00000H0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool01`3oool004<0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo0000
00L0oooo00@000000?ooo`3oool000006@3oool010000000oooo0?ooo`0000080?ooo`<00000603o
ool010000000oooo0?ooo`0000090?ooo`8000008@3oool00`000000oooo0?ooo`070?ooo`00@`3o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0000000I0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool01`3oool004<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000H0?ooo`040000003oool0oooo000000T0oooo0P00000I0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000001h0oooo0`0000090?ooo`00903oool00`000000oooo0?ooo`0M0?ooo`8000002P3oool2
000001X0oooo0P00000;0?ooo`030000003oool0oooo01P0oooo0P00000:0?ooo`<00000603oool2
000000X0oooo0P00000Q0?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo
0<d0oooo000T0?ooo`030000003oool0oooo0<d0oooo000O0?ooom400000103oool002@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`050?oooa@000000P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo000T0?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0A0?ooo`P00000303oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01`3oool002@0oooo00<000000?oo
o`3oool0F03oool8000006d0oooo000T0?ooo`030000003oool0oooo05@0oooo1000001e0?ooo`00
903oool00`000000oooo0?ooo`1A0?ooo`<00000N@3oool002@0oooo00<000000?ooo`3oool0C`3o
ool2000007`0oooo000T0?ooo`030000003oool0oooo04/0oooo1000001n0?ooo`00903oool00`00
0000oooo0?ooo`190?ooo`800000PP3oool002@0oooo00<000000?ooo`3oool0A`3oool2000008@0
oooo000T0?ooo`030000003oool0oooo04D0oooo0P0000260?ooo`00903oool00`000000oooo0?oo
o`140?ooo`030000003oool0oooo08H0oooo000T0?ooo`030000003oool0oooo0480oooo0P000029
0?ooo`00903oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo08T0oooo000T0?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool0RP3oool002@0oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`2;0?ooo`00903oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo08`0oooo000T0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0S@3oool0
02@0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`2>0?ooo`00903oool00`000000
oooo0?ooo`0j0?ooo`800000T@3oool002@0oooo00<000000?ooo`3oool0>@3oool00`000000oooo
0?ooo`2A0?ooo`00903oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo0980oooo000T
0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0T`3oool002@0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`2D0?ooo`00903oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo09@0oooo000T0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0
U@3oool002@0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2F0?ooo`00903oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo09L0oooo000T0?ooo`030000003oool0oooo
03<0oooo00<000000?ooo`3oool0U`3oool000D0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool0<P3oool00`000000
oooo0?ooo`2H0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0380oooo00<000000?ooo`3oool0V03oool000@0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
103oool200000380oooo00<000000?ooo`3oool0V@3oool000@0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo09T0oooo00040?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`2J0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0300oooo00<000000?ooo`3oool0VP3oool000D0oooo0P00000:0?ooo`800000103oool2000000@0
oooo0P0000050?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0V`3oool002@0oooo
00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`2K0?ooo`00903oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo09`0oooo000T0?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`3oool0W03oool002@0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2M0?oo
o`00903oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo09d0oooo000T0?ooo`030000
003oool0oooo02`0oooo00<000000?ooo`3oool0WP3oool002@0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`2N0?ooo`00903oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo09l0oooo000T0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0W`3oool002@0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`2P0?ooo`00903oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo0:00oooo000T0?ooo`030000003oool0oooo02T0oooo00<0
00000?ooo`3oool0X@3oool002@0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`2Q
0?ooo`00903oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0:80oooo000T0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool0XP3oool002@0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`2S0?ooo`00903oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo0:<0oooo000T0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0X`3oool0
02@0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2T0?ooo`00903oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo0:@0oooo000T0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool0Y03oool002@0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`2T0?ooo`00903oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0:D0oooo000T0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool0Y@3oool000D0oooo0P0000040?ooo`03
0000003oool0oooo00<0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0Y@3oool000@0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0:H0oooo00040?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?oo
o`000000oooo00D00000103oool2000002D0oooo00<000000?ooo`3oool0YP3oool000@0oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000
003oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool0YP3oool000@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo0:H0oooo00040?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`8000001@3oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo0:L0oooo00050?ooo`8000002P3oool2000000@0
oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool08`3oool00`000000
oooo0?ooo`2W0?ooo`00903oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0:L0oooo
000T0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0Y`3oool002@0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`2X0?ooo`00903oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo0:P0oooo000T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool0Z03oool002@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`2X0?ooo`00903o
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0:T0oooo000T0?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool0Z@3oool002@0oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`2Y0?ooo`00903oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0:T0
oooo000T0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0ZP3oool002@0oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`2Z0?ooo`00903oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo0:X0oooo000T0?ooo`030000003oool0oooo0200oooo00<000000?oo
o`3oool0ZP3oool002@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`2[0?ooo`00
903oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0:/0oooo000T0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0Z`3oool002@0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`2[0?ooo`00903oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
0:`0oooo000T0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0[03oool002@0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2/0?ooo`00903oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo0:`0oooo000T0?ooo`030000003oool0oooo01d0oooo00<00000
0?ooo`3oool0[@3oool002@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`2]0?oo
o`001@3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0:d0oooo00040?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`2]0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`8000007@3oool00`00
0000oooo0?ooo`2^0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool3000000D0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`2^0?ooo`00103oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool0[P3oool000@0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0:h0oooo00050?oo
o`8000002P3oool2000000@0oooo0P0000040?ooo`<00000103oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo0:l0oooo000T0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0[`3oool002@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`2_0?ooo`00903o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0:l0oooo000T0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0[`3oool002@0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`2_0?ooo`00903oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0;00
oooo000T0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0/03oool002@0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`2`0?ooo`00903oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo0;00oooo000T0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool0/03oool002@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`2`0?ooo`00
903oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0;40oooo000T0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0/@3oool002@0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`2a0?ooo`00903oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
0;40oooo000T0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0/@3oool002@0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`2a0?ooo`00903oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo0;80oooo000T0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0/P3oool002@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`2b0?oo
o`00903oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0;80oooo000T0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0/P3oool002@0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`2b0?ooo`00903oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo0;<0oooo00050?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000103oool20000
00@0oooo0P0000050?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0/`3oool000@0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo0;<0oooo00040?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo0P00000H
0?ooo`030000003oool0oooo0;<0oooo00040?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`8000001@3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo0;<0oooo00040?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`2c0?ooo`00103oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`00003D0?ooo`001@3oool2000000X0oooo0P0000040?ooo`800000
103oool200000=D0oooo003d0?ooo`00P@3oool300000700oooo00220?ooo`030000003oool0oooo
06l0oooo001d0?ooo`8000002P3oool3000000<0oooo0P000000103oool000000?ooo`3oool20000
00030?ooo`000000oooo00@0000000@0oooo000000000000oooo0P00001I0?ooo`00L`3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
0000FP3oool007<0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000<0oooo0`0000030?ooo`030000003oool0oooo0080oooo0P00001K0?oo
o`00L`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`000000
FP3oool007@0oooo0P00000:0?ooo`80000000D0oooo00000000000000000?ooo`02000000<0oooo
0P0000030?ooo`030000003oool000000080000000<0oooo0000003oool00P00001I0?ooo`00U`3o
ool00`000000oooo0?ooo`1J0?ooo`00UP3oool2000005`0oooo0000\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.181821, -0.000749156, \
0.00503853, 6.45571*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.603319 311.248 [
[.21429 .59082 -9 -9 ]
[.21429 .59082 9 0 ]
[.40476 .59082 -9 -9 ]
[.40476 .59082 9 0 ]
[.59524 .59082 -9 -9 ]
[.59524 .59082 9 0 ]
[.78571 .59082 -9 -9 ]
[.78571 .59082 9 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.01131 .05864 -48 -4.5 ]
[.01131 .05864 0 4.5 ]
[.01131 .13645 -42 -4.5 ]
[.01131 .13645 0 4.5 ]
[.01131 .21426 -48 -4.5 ]
[.01131 .21426 0 4.5 ]
[.01131 .29207 -36 -4.5 ]
[.01131 .29207 0 4.5 ]
[.01131 .36988 -48 -4.5 ]
[.01131 .36988 0 4.5 ]
[.01131 .44769 -42 -4.5 ]
[.01131 .44769 0 4.5 ]
[.01131 .52551 -48 -4.5 ]
[.01131 .52551 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .60332 m
.21429 .60957 L
s
[(0.2)] .21429 .59082 0 1 Mshowa
.40476 .60332 m
.40476 .60957 L
s
[(0.4)] .40476 .59082 0 1 Mshowa
.59524 .60332 m
.59524 .60957 L
s
[(0.6)] .59524 .59082 0 1 Mshowa
.78571 .60332 m
.78571 .60957 L
s
[(0.8)] .78571 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(1)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.07143 .60332 m
.07143 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.16667 .60332 m
.16667 .60707 L
s
.2619 .60332 m
.2619 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.35714 .60332 m
.35714 .60707 L
s
.45238 .60332 m
.45238 .60707 L
s
.5 .60332 m
.5 .60707 L
s
.54762 .60332 m
.54762 .60707 L
s
.64286 .60332 m
.64286 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.7381 .60332 m
.7381 .60707 L
s
.83333 .60332 m
.83333 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.92857 .60332 m
.92857 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.02381 .05864 m
.03006 .05864 L
s
[(-0.00175)] .01131 .05864 1 0 Mshowa
.02381 .13645 m
.03006 .13645 L
s
[(-0.0015)] .01131 .13645 1 0 Mshowa
.02381 .21426 m
.03006 .21426 L
s
[(-0.00125)] .01131 .21426 1 0 Mshowa
.02381 .29207 m
.03006 .29207 L
s
[(-0.001)] .01131 .29207 1 0 Mshowa
.02381 .36988 m
.03006 .36988 L
s
[(-0.00075)] .01131 .36988 1 0 Mshowa
.02381 .44769 m
.03006 .44769 L
s
[(-0.0005)] .01131 .44769 1 0 Mshowa
.02381 .52551 m
.03006 .52551 L
s
[(-0.00025)] .01131 .52551 1 0 Mshowa
.125 Mabswid
.02381 .0742 m
.02756 .0742 L
s
.02381 .08976 m
.02756 .08976 L
s
.02381 .10532 m
.02756 .10532 L
s
.02381 .12088 m
.02756 .12088 L
s
.02381 .15201 m
.02756 .15201 L
s
.02381 .16757 m
.02756 .16757 L
s
.02381 .18313 m
.02756 .18313 L
s
.02381 .1987 m
.02756 .1987 L
s
.02381 .22982 m
.02756 .22982 L
s
.02381 .24538 m
.02756 .24538 L
s
.02381 .26095 m
.02756 .26095 L
s
.02381 .27651 m
.02756 .27651 L
s
.02381 .30763 m
.02756 .30763 L
s
.02381 .3232 m
.02756 .3232 L
s
.02381 .33876 m
.02756 .33876 L
s
.02381 .35432 m
.02756 .35432 L
s
.02381 .38545 m
.02756 .38545 L
s
.02381 .40101 m
.02756 .40101 L
s
.02381 .41657 m
.02756 .41657 L
s
.02381 .43213 m
.02756 .43213 L
s
.02381 .46326 m
.02756 .46326 L
s
.02381 .47882 m
.02756 .47882 L
s
.02381 .49438 m
.02756 .49438 L
s
.02381 .50994 m
.02756 .50994 L
s
.02381 .54107 m
.02756 .54107 L
s
.02381 .55663 m
.02756 .55663 L
s
.02381 .57219 m
.02756 .57219 L
s
.02381 .58776 m
.02756 .58776 L
s
.02381 .04307 m
.02756 .04307 L
s
.02381 .02751 m
.02756 .02751 L
s
.02381 .01195 m
.02756 .01195 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.28792 0 m
.28931 .01073 L
.30928 .13299 L
.34745 .30386 L
.36719 .36788 L
.38804 .42191 L
.42563 .4923 L
.44495 .51811 L
.46565 .53986 L
.48668 .55687 L
.5066 .56922 L
.52631 .57855 L
.54454 .58515 L
.56302 .59024 L
.58342 .5944 L
.60257 .59721 L
.61243 .59834 L
.62322 .59936 L
.64306 .60078 L
.65388 .60135 L
.66395 .60178 L
.67437 .60213 L
.6842 .6024 L
.7026 .60277 L
.71223 .6029 L
.72242 .60301 L
.73112 .60308 L
.74068 .60315 L
.75074 .6032 L
.75994 .60323 L
.77055 .60326 L
.78062 .60328 L
.79014 .60329 L
.79545 .6033 L
.80027 .6033 L
.80478 .60331 L
.80965 .60331 L
.81848 .60331 L
.82337 .60331 L
.82792 .60331 L
.83333 .60332 L
.83826 .60332 L
.84344 .60332 L
.84834 .60332 L
.85351 .60332 L
.85913 .60332 L
.86394 .60332 L
.86846 .60332 L
.87341 .60332 L
.87619 .60332 L
Mistroke
.87874 .60332 L
.88359 .60332 L
.88634 .60332 L
.88889 .60332 L
.89154 .60332 L
.89405 .60332 L
.89694 .60332 L
.89955 .60332 L
.90193 .60332 L
.90415 .60332 L
.90659 .60332 L
.9092 .60332 L
.91194 .60332 L
.91454 .60332 L
.91687 .60332 L
.91941 .60332 L
.92159 .60332 L
.92284 .60332 L
.92401 .60332 L
.92636 .60332 L
.92768 .60332 L
.9289 .60332 L
.93094 .60332 L
.9321 .60332 L
.93318 .60332 L
.9343 .60332 L
.93536 .60332 L
.93658 .60332 L
.93769 .60332 L
.93883 .60332 L
.94005 .60332 L
.9412 .60332 L
.94226 .60332 L
.9435 .60332 L
.94419 .60332 L
.94484 .60332 L
.94603 .60332 L
.9473 .60332 L
.94798 .60332 L
.94862 .60332 L
.94931 .60332 L
.95005 .60332 L
.95128 .60332 L
.95198 .60332 L
.95264 .60332 L
.95386 .60332 L
.95497 .60332 L
.95626 .60332 L
.95748 .60332 L
.95852 .60332 L
Mistroke
.95968 .60332 L
.96089 .60332 L
.96202 .60332 L
.96308 .60332 L
.96405 .60332 L
.96511 .60332 L
.96623 .60332 L
.96736 .60332 L
.96858 .60332 L
.96973 .60332 L
.97077 .60332 L
.972 .60332 L
.97269 .60332 L
.97333 .60332 L
.9745 .60332 L
.97574 .60332 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
0?@0oooo003d0?ooo`00m03oool00?@0oooo003d0?ooo`00m03oool00?@0oooo000b0?ooo`030000
003oool0oooo0340oooo00<000000?ooo`3oool0R`3oool00380oooo00<000000?ooo`3oool0<@3o
ool00`000000oooo0?ooo`2;0?ooo`00<P3oool200000380oooo00<000000?ooo`3oool0R`3oool0
0380oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`2;0?ooo`00<P3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo08/0oooo000b0?ooo`800000<P3oool00`000000oooo
0?ooo`2;0?ooo`00<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo08X0oooo000b
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0RP3oool00380oooo0P00000c0?oo
o`030000003oool0oooo08X0oooo00080?ooo`800000103oool00`000000oooo0?ooo`030?ooo`80
0000103oool2000000<0oooo100000030?ooo`030000003oool0oooo0080oooo0`0000040?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool0RP3oool000L0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000=03o
ool00`000000oooo0?ooo`2:0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo0P00000c0?ooo`030000003oool0oooo
08X0oooo00000`3oool000000000000200000080oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`3oool3000000@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`290?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo
000000H0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`290?ooo`001`3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool3000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`80
0000=03oool00`000000oooo0?ooo`290?ooo`00203oool2000000X0oooo0P0000040?ooo`800000
1@3oool010000000oooo0?ooo`3oool400000080oooo100000030?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool0R@3oool00380oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`290?ooo`00<P3oool2000003@0oooo00<000000?ooo`3oool0R@3oool00380oooo00<00000
0?ooo`3oool0=03oool00`000000oooo0?ooo`280?ooo`00<P3oool00`000000oooo0?ooo`0d0?oo
o`030000003oool0oooo08P0oooo000b0?ooo`800000=@3oool00`000000oooo0?ooo`280?ooo`00
<P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo08P0oooo000b0?ooo`030000003o
ool0oooo03@0oooo00<000000?ooo`3oool0R03oool00380oooo0P00000e0?ooo`030000003oool0
oooo08P0oooo000>0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000103oool20000
00<0oooo100000020?ooo`<00000103oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
08L0oooo000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
0000000g0?ooo`030000003oool0oooo08L0oooo000=0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
00@0oooo00@000000?ooo`3oool0oooo0P00000f0?ooo`030000003oool0oooo08L0oooo00070?oo
o`@000000P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool00000103oool010000000oooo0?ooo`3oool3000000@0oooo00<000000?ooo`3o
ool0=@3oool00`000000oooo0?ooo`270?ooo`003@3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3o
ool0000000H0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`270?ooo`003@3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool3000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo08H0oooo000>0?ooo`8000002P3oool2000000@0oooo0P0000050?ooo`040000
003oool0oooo0?ooo`@000000`3oool2000003L0oooo00<000000?ooo`3oool0QP3oool00380oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`260?ooo`00<P3oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo08H0oooo000b0?ooo`800000>03oool00`000000oooo0?ooo`25
0?ooo`00<P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo08D0oooo000b0?ooo`03
0000003oool0oooo03L0oooo00<000000?ooo`3oool0Q@3oool00380oooo0P00000h0?ooo`030000
003oool0oooo08D0oooo000b0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0Q03o
ool00380oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`240?ooo`00<P3oool20000
03T0oooo00<000000?ooo`3oool0Q03oool000P0oooo0P0000040?ooo`030000003oool0oooo00<0
oooo0P0000040?ooo`8000000`3oool400000080oooo100000020?ooo`<00000103oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo08@0oooo00070?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`050000003oool0
oooo0?ooo`000000203oool01@000000oooo0?ooo`3oool0000003/0oooo00<000000?ooo`3oool0
P`3oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?oo
o`040000003oool0oooo0?ooo`800000>P3oool00`000000oooo0?ooo`230?ooo`0000<0oooo0000
000000000P0000020?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0
oooo0`0000040?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0P`3oool000L0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000060?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool0P`3oool000L0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`0000030?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool0103oool2000003/0oooo00<000000?oo
o`3oool0PP3oool000P0oooo0P00000:0?ooo`800000103oool2000000D0oooo00<000000?ooo`3o
ool00P3oool2000000<0oooo100000030?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0PP3oool00380oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`220?ooo`00<P3o
ool2000003/0oooo00<000000?ooo`3oool0PP3oool00380oooo00<000000?ooo`3oool0>`3oool0
0`000000oooo0?ooo`210?ooo`00<P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo
0840oooo000b0?ooo`800000?03oool00`000000oooo0?ooo`210?ooo`00<P3oool00`000000oooo
0?ooo`0k0?ooo`030000003oool0oooo0840oooo000b0?ooo`030000003oool0oooo03`0oooo00<0
00000?ooo`3oool0P03oool00380oooo0P00000m0?ooo`030000003oool0oooo0800oooo000D0?oo
o`800000103oool00`000000oooo0?ooo`030?ooo`800000103oool2000000<0oooo100000030?oo
o`030000003oool0oooo03`0oooo00<000000?ooo`3oool0P03oool001<0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0800oooo000C
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo0080oooo0P00000n0?ooo`030000003oool0oooo07l0
oooo000=0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool0O`3oool001<0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo07l0oooo000C0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`<00000103oool2000003h0oooo00<000000?ooo`3oool0O`3oool001@0oooo0P00000:0?ooo`80
0000103oool2000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0n0?ooo`03
0000003oool0oooo07h0oooo000b0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0
OP3oool00380oooo0P00000o0?ooo`030000003oool0oooo07h0oooo000b0?ooo`030000003oool0
oooo03l0oooo00<000000?ooo`3oool0O@3oool00380oooo00<000000?ooo`3oool0?`3oool00`00
0000oooo0?ooo`1m0?ooo`00<P3oool200000400oooo00<000000?ooo`3oool0O@3oool00380oooo
00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`1m0?ooo`00<P3oool00`000000oooo0?oo
o`100?ooo`030000003oool0oooo07`0oooo000b0?ooo`800000@@3oool00`000000oooo0?ooo`1l
0?ooo`00203oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0P0000040?oo
o`800000103oool00`000000oooo0?ooo`020?ooo`<00000103oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo07`0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000004<0oooo00<000000?ooo`3o
ool0N`3oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`040?ooo`040000003oool0oooo0?ooo`800000@P3oool00`000000oooo0?ooo`1k0?ooo`0000<0
oooo0000000000000P0000020?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00@00000
0?ooo`3oool0oooo0`0000040?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0N`3o
ool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`000006
0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0NP3oool000L0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1j0?ooo`00203oool2000000X0
oooo0P0000040?ooo`800000103oool2000000<0oooo100000020?ooo`@000000`3oool2000004<0
oooo00<000000?ooo`3oool0NP3oool00380oooo00<000000?ooo`3oool0@`3oool00`000000oooo
0?ooo`1i0?ooo`00<P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo07T0oooo000b
0?ooo`800000A@3oool00`000000oooo0?ooo`1h0?ooo`00<P3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo07P0oooo000b0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0N03oool00380oooo0P0000160?ooo`030000003oool0oooo07L0oooo000b0?ooo`030000003o
ool0oooo04D0oooo00<000000?ooo`3oool0M`3oool00380oooo00<000000?ooo`3oool0A@3oool0
0`000000oooo0?ooo`1g0?ooo`00<P3oool2000004L0oooo00<000000?ooo`3oool0MP3oool000h0
oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000103oool2000000<0
oooo0`0000040?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0MP3oool000d0oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool0000004T0oooo
00<000000?ooo`3oool0M@3oool000d0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool0
10000000oooo0?ooo`3oool2000004P0oooo00<000000?ooo`3oool0M@3oool000L0oooo10000002
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`0000040?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0M03oool000d0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
M03oool000d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04
0?ooo`800000BP3oool00`000000oooo0?ooo`1c0?ooo`003P3oool2000000X0oooo0P0000040?oo
o`800000103oool2000000<0oooo100000030?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool0L`3oool00380oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`1b0?ooo`00
<P3oool2000004/0oooo00<000000?ooo`3oool0LP3oool00380oooo00<000000?ooo`3oool0B`3o
ool00`000000oooo0?ooo`1a0?ooo`00<P3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0
oooo0740oooo000b0?ooo`800000C@3oool00`000000oooo0?ooo`1`0?ooo`00<P3oool00`000000
oooo0?ooo`1=0?ooo`030000003oool0oooo06l0oooo000b0?ooo`030000003oool0oooo04h0oooo
00<000000?ooo`3oool0KP3oool00380oooo0P00001?0?ooo`030000003oool0oooo06h0oooo0008
0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000103oool2000000@0oooo0P000003
0?ooo`@000000P3oool3000000@0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1]
0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00H0
oooo00D000000?ooo`3oool0oooo0000001B0?ooo`030000003oool0oooo06`0oooo00070?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool010000000oooo
0?ooo`3oool200000580oooo00<000000?ooo`3oool0J`3oool000030?ooo`000000000000800000
0P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo0?ooo`<00000
103oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo06X0oooo00070?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000D0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?oo
o`1C0?ooo`030000003oool0oooo06T0oooo00070?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`800000E@3oool0
0`000000oooo0?ooo`1X0?ooo`00203oool2000000X0oooo0P0000040?ooo`800000103oool20000
00@0oooo0P0000030?ooo`@000000`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
06L0oooo000b0?ooo`030000003oool0oooo05H0oooo0P00001W0?ooo`00<P3oool2000001d0oooo
0P0000040?ooo`030000003oool0oooo0080oooo1000000F0?ooo`800000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0303oool2000000@0oooo
00<000000?ooo`3oool00`3oool2000001L0oooo0P0000040?ooo`030000003oool0oooo00<0oooo
0P00000M0?ooo`@00000103oool00380oooo00<000000?ooo`3oool06`3oool010000000oooo0?oo
o`0000080?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool000002P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`00000E0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
7P3oool00`000000oooo0?ooo`030?ooo`00<P3oool00`000000oooo0?ooo`0K0?ooo`040000003o
ool0oooo000000T0oooo00<000000?ooo`3oool05@3oool010000000oooo0?ooo`0000070?ooo`D0
00002P3oool2000000X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000E
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000007P3oool00`000000oooo
0?ooo`030?ooo`00<P3oool2000001`0oooo00@000000?ooo`3oool000002P3oool00`000000oooo
0?ooo`0D0?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool000003@3oool00`00
0000oooo0?ooo`070?ooo`040000003oool0oooo000000P0oooo0`00000F0?ooo`040000003oool0
oooo000000T0oooo0P00000O0?ooo`030000003oool0oooo00<0oooo000b0?ooo`030000003oool0
oooo01/0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0C0?ooo`040000003o
ool0oooo000000P0oooo00<000000?ooo`0000003P3oool2000000L0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`0F0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000007P3oool00`000000oooo0?ooo`030?ooo`00<P3oool00`000000oooo0?ooo`0K0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000005@3oool010000000oooo0?oo
o`0000090?ooo`800000403oool3000000@0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`0F0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000703oool3
000000D0oooo000b0?ooo`8000007@3oool2000000X0oooo0P00000G0?ooo`8000002`3oool00`00
0000oooo0?ooo`0A0?ooo`@0000000<0oooo0000000000002P3oool3000001H0oooo0P00000:0?oo
o`8000007`3oool00`000000oooo0?ooo`030?ooo`00<P3oool00`000000oooo0?ooo`1V0?ooo`<0
0000EP3oool00380oooo00<000000?ooo`3oool0J@3oool7000004l0oooo000b0?ooo`030000003o
ool0oooo0700oooo6`00000d0?ooo`00;@3oooo700000000<P3oool00`000000oooo0?ooo`0S0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool00`3oool00380oooo00<000000?ooo`3o
ool0_`3oool00?@0oooo003d0?ooo`00m03oool008X0oooo0`00001W0?ooo`00R`3oool00`000000
oooo0?ooo`1V0?ooo`00N`3oool4000000X0oooo0`0000030?ooo`80000000@0oooo0000003oool0
oooo0P0000000`3oool000000?ooo`04000000040?ooo`00000000000?ooo`800000D03oool007`0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000
003oool000000540oooo001l0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000030?ooo`<000000`3oool00`000000oooo0?ooo`020?oo
o`800000DP3oool007`0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool000000540oooo001l0?ooo`<000002P3oool2000000050?ooo`00000000000000003oool0
0P0000030?ooo`8000000`3oool00`000000oooo00000002000000030?ooo`000000oooo00800000
D03oool007`0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1A0?ooo`00N`3oool2
00000280oooo0P00001C0?ooo`00m03oool00?@0oooo003d0?ooo`00m03oool00?@0oooo003d0?oo
o`00m03oool00?@0oooo0000\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.268671, -0.00206528, \
0.00532377, 1.62901*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.294302 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 11.250 moveto
(quark) show
105.000 11.250 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03333 .30902 m
.07158 .30902 L
.1133 .30902 L
.15247 .30902 L
.19015 .30902 L
.23025 .30902 L
.26885 .30902 L
.30989 .30902 L
.34942 .30902 L
.38745 .30902 L
.4279 .30902 L
.46686 .30902 L
.50432 .30902 L
.5442 .30902 L
.58259 .30902 L
.6234 .30902 L
.66271 .30902 L
.70052 .30902 L
.74076 .30902 L
.7795 .30902 L
.82067 .30902 L
.86033 .30902 L
.8985 .30902 L
.93909 .30902 L
.97619 .30902 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{244, 150.75},
  ImageMargins->{{36, 0}, {0, 74}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003d0000UR000`400?l00000o`00003om03oool0
01/0oooo00<000000?ooo`3oool0eP3oool001<0oooo100000040?ooo`030000003oool0oooo0=H0
oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0eP3oool001D0oooo00<0
00000?ooo`3oool00`3oool200000=L0oooo000=0?ooo`@00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0=H0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0eP3oool001<0oooo0`0000050?ooo`030000003oool0oooo0=H0oooo000E0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3o
ool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo0P00003G0?ooo`006`3oool00`000000
oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?oo
o`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?oo
o`006`3oool200000=L0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003o
ool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo
0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo
000K0?ooo`800000e`3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?oo
o`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0
eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo0P00003G0?ooo`006`3oool00`00
0000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo
0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`00203oool2000000@0oooo00<00000
0?ooo`3oool00P3oool3000000D0oooo00<000000?ooo`3oool0eP3oool000L0oooo00@000000?oo
o`3oool000002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0=H0oooo00070?oo
o`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool200000=L0oooo00000`3o
ool000000000000200000080oooo00@000000?ooo`3oool00000203oool3000000D0oooo00<00000
0?ooo`3oool0eP3oool000L0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0=H0oooo00070?ooo`040000003oool0oooo000000P0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3F0?ooo`00203oool2000000T0oooo100000040?oo
o`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`800000
e`3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool0
01/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo
00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo0P00003G
0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`00
6`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool0
0`000000oooo0?ooo`3F0?ooo`006`3oool200000=L0oooo000K0?ooo`030000003oool0oooo0=H0
oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0200oooo0P00
00040?ooo`030000003oool0oooo0080oooo1000000K0?ooo`800000103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01X0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P00
000L0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000803oool4000000H0oooo000K
0?ooo`030000003oool0oooo01l0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`0K0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool06@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000001X0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`00000Q0?ooo`030000003oool0oooo00D0oooo000K0?ooo`030000003oool0
oooo01l0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0J0?ooo`040000003o
ool0oooo000000L0oooo1@00000J0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool000006P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000240oooo00<0
00000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool07`3oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool000001`3oool010000000oooo
0?ooo`00000K0?ooo`040000003oool0oooo000000P0oooo0`00000K0?ooo`040000003oool0oooo
000000T0oooo0P00000R0?ooo`030000003oool0oooo00D0oooo000K0?ooo`800000803oool01000
0000oooo0?ooo`00000;0?ooo`030000003oool0oooo01P0oooo00@000000?ooo`3oool00000203o
ool00`000000oooo0000000K0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool0
6`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000240oooo00<000000?oo
o`3oool01@3oool001/0oooo00<000000?ooo`3oool07`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000001X0oooo00@000000?ooo`3oool000002@3oool2000001/0oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`0K0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000007`3oool3000000L0oooo000K0?ooo`030000003oool0oooo0200
oooo0P00000:0?ooo`800000703oool2000000/0oooo00<000000?ooo`3oool06P3oool2000000X0
oooo0`00000K0?ooo`8000002P3oool200000280oooo00<000000?ooo`3oool01@3oool001/0oooo
00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<00000
0?ooo`3oool0eP3oool001H0oooog@0000010?ooo`006`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool0
eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool0
01/0oooo00<000000?ooo`3oool0eP3oool001/0oooo0P00003G0?ooo`006`3oool00`000000oooo
0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F
0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`00
6`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool200000=L0oooo000K0?ooo`030000003oool0
oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0
oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K
0?ooo`800000e`3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3o
ool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3o
ool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0
oooo0P00003G0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?oo
o`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`00203oool2000000@0oooo00<000000?oo
o`3oool00P3oool3000000D0oooo00<000000?ooo`3oool0eP3oool000L0oooo00@000000?ooo`3o
ool000002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0=H0oooo00070?ooo`04
0000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool200000=L0oooo00070?ooo`04
0000003oool0oooo000000P0oooo0`0000050?ooo`030000003oool0oooo0=H0oooo00070?ooo`04
0000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3F0?oo
o`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0eP3oool000P0oooo0P0000090?ooo`@00000103oool00`000000oooo0?ooo`3F0?ooo`00
6`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool2
00000=L0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0
oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K
0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`800000e`3oool001/0oooo00<000000?ooo`3o
ool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3o
ool001/0oooo00<000000?ooo`3oool0eP3oool001/0oooo00<000000?ooo`3oool0eP3oool001/0
oooo00<000000?ooo`3oool0eP3oool001/0oooo0P00003G0?ooo`006`3oool00`000000oooo0?oo
o`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?oo
o`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3oool00`000000oooo0?ooo`3F0?ooo`006`3o
ool200000=L0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo
0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo000K0?ooo`030000003oool0oooo0=H0oooo
000C0?ooo`@00000103oool00`000000oooo0?ooo`3F0?ooo`005@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0=H0oooo000E0?ooo`030000003oool0oooo00<0oooo0P00003G0?oo
o`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0=H0oooo000E0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0eP3oool001<0oooo0`0000050?ooo`030000003o
ool0oooo0=H0oooo000E0?ooo`030000003oool0oooo0=`0oooo003d0?ooo`00m03oool007h0oooo
0`00001c0?ooo`00O`3oool00`000000oooo0?ooo`1b0?ooo`00LP3oool2000000T0oooo0`000003
0?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool000000?ooo`04000000040?ooo`00
000000000?ooo`800000G03oool00740oooo00@000000?ooo`3oool000001`3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0000005d0oooo001a0?ooo`030000003oool0oooo
00P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`<000000`3o
ool00`000000oooo0?ooo`020?ooo`800000GP3oool00740oooo00<000000?ooo`3oool0203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0000005d0oooo001`0?ooo`@000002@3oool2000000050?oo
o`00000000000000003oool00P0000030?ooo`8000000`3oool00`000000oooo0000000200000003
0?ooo`000000oooo00800000G03oool00740oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`1M0?ooo`00L@3oool00`000000oooo0?ooo`0O0?ooo`800000G`3oool00001\
\>"],
  ImageRangeCache->{{{0, 243}, {149.75, 0}} -> {-0.131419, -1.06952, \
0.00477421, 0.0154497}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Table[{parton[i],pdf[1,i,0.1,5.]} ,{i,-6,6,1}]  //TableForm", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      TagBox[GridBox[{
            {"\<\"t-bar quark\"\>", "0"},
            {"\<\"b-bar quark\"\>", "0.014212488428688183`"},
            {"\<\"c-bar quark\"\>", "0.2477893315397323`"},
            {"\<\"s-bar quark\"\>", "0.6816649313341817`"},
            {"\<\"d-bar quark\"\>", "1.4391026169960603`"},
            {"\<\"u-bar quark\"\>", "0.9914169880020065`"},
            {"\<\"gluon\"\>", "12.609290002568398`"},
            {"\<\"u quark\"\>", "6.47752789002378`"},
            {"\<\"d quark\"\>", "4.192457843723166`"},
            {"\<\"s quark\"\>", "0.6816649313341817`"},
            {"\<\"c quark\"\>", "0.2477893315397323`"},
            {"\<\"b quark\"\>", "0.014212488428688183`"},
            {"\<\"t quark\"\>", "0"}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        (TableForm[ #]&)], TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Check Momentum Sum Rule:",
  StyleBox["\nWARNING: This takes a long time!!!!!!!!!",
    FontColor->RGBColor[1, 0, 0]]
}], "Subsection",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(q0list = {1.6, 3, 10, 30, 100, 300, 
          1000};\)\), "\[IndentingNewLine]", 
    \(\(isetList = {1, 3};\)\), "\[IndentingNewLine]", 
    \(Do[q0 = q0list[\([iq]\)]; \[IndentingNewLine]iset = 
        isetList[\([is]\)]; \[IndentingNewLine]temp = 
        NIntegrate[
          Sum[x\ pdf[iset, ipart, x, q0], {ipart, \(-6\), 6}], {x, 0, 
            1}]; \[IndentingNewLine]check[iq, is] = {iset, q0, 
          temp}; \[IndentingNewLine]Print[check[iq, is]];, {iq, 1, 
        Length[q0list]}, {is, 1, Length[isetList]}]\)}], "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`{1, 1.6`, 0.9978073051379673`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 1.6`, 0.9983595669733473`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1, 3, 1.0024568002952463`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 3, 1.0009639125319756`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1, 10, 1.0001647524613864`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 10, 1.0003698024048882`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1, 30, 0.9983443473443915`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 30, 0.999445595894996`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1, 100, 0.9981910515689587`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 100, 0.9988037679917595`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1, 300, 1.000419985119677`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 300, 0.9997588485871153`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1, 1000, 1.004994224981412`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3, 1000, 1.0025475042504728`}\)], "Print"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
ShowPageBreaks->False,
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{873, 832},
WindowMargins->{{Automatic, 102}, {Automatic, 39}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 108, 2, 35, "Input"],
Cell[1828, 53, 70, 1, 24, "Input"],
Cell[1901, 56, 402, 11, 49, "Subsubsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[2328, 71, 156, 3, 24, "Input",
  PageBreakAbove->False],
Cell[2487, 76, 72, 1, 20, "Print"],
Cell[2562, 79, 68, 1, 20, "Print"],
Cell[2633, 82, 80, 1, 20, "Print"],
Cell[2716, 85, 88, 1, 20, "Print"],
Cell[2807, 88, 97, 2, 20, "Print"],
Cell[2907, 92, 122, 2, 20, "Print"],
Cell[3032, 96, 53, 1, 20, "Print"],
Cell[3088, 99, 81, 1, 20, "Print"],
Cell[3172, 102, 92, 1, 20, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3301, 108, 70, 1, 24, "Input"],
Cell[3374, 111, 62, 1, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3473, 117, 98, 2, 41, "Subsection",
  PageBreakAbove->False],
Cell[3574, 121, 104, 2, 24, "Input",
  PageBreakAbove->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3715, 128, 98, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[3838, 134, 84, 2, 24, "Input",
  PageBreakAbove->False],
Cell[3925, 138, 135, 2, 20, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4097, 145, 81, 2, 24, "Input",
  PageBreakAbove->False],
Cell[4181, 149, 96, 2, 20, "Print"],
Cell[4280, 153, 821, 23, 119, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5138, 181, 85, 2, 24, "Input",
  PageBreakAbove->False],
Cell[5226, 185, 64, 1, 24, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5339, 192, 84, 1, 24, "Input"],
Cell[5426, 195, 108, 2, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5571, 202, 98, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[5694, 208, 195, 11, 93, "Input",
  PageBreakAbove->False],
Cell[5892, 221, 21353, 590, 232, 6278, 399, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27282, 816, 131, 6, 52, "Input"],
Cell[27416, 824, 388, 11, 57, "Output"]
}, Open  ]]
}, Open  ]],
Cell[27831, 839, 97, 2, 41, "Subsection",
  PageBreakAbove->True],

Cell[CellGroupData[{
Cell[27953, 845, 179, 9, 73, "Input",
  PageBreakAbove->False],
Cell[28135, 856, 16816, 428, 232, 4389, 270, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[44966, 1287, 103, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[45094, 1293, 248, 11, 93, "Input",
  PageBreakAbove->False],
Cell[45345, 1306, 27295, 890, 232, 15678, 742, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[72655, 2199, 106, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[72786, 2205, 162, 7, 52, "Input",
  PageBreakAbove->False],
Cell[72951, 2214, 412, 6, 32, "Message"],
Cell[73366, 2222, 412, 6, 32, "Message"],
Cell[73781, 2230, 412, 6, 32, "Message"],
Cell[74196, 2238, 248, 4, 20, "Message"],
Cell[74447, 2244, 292, 4, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74776, 2253, 119, 2, 24, "Input"],
Cell[74898, 2257, 928, 21, 231, "Output"]
}, Open  ]],
Cell[75841, 2281, 110, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[75976, 2287, 86, 2, 24, "Input",
  PageBreakAbove->False],
Cell[76065, 2291, 70, 1, 24, "Output"]
}, Open  ]],
Cell[76150, 2295, 107, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[76282, 2301, 105, 2, 24, "Input",
  PageBreakAbove->False],
Cell[76390, 2305, 70, 1, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76497, 2311, 99, 2, 41, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[76621, 2317, 213, 13, 113, "Input",
  PageBreakAbove->False],
Cell[76837, 2332, 22368, 577, 232, 6168, 373, "GraphicsData", "PostScript", \
"Graphics"],
Cell[99208, 2911, 21783, 567, 232, 6072, 369, "GraphicsData", "PostScript", \
"Graphics"],
Cell[120994, 3480, 17861, 470, 232, 4980, 306, "GraphicsData", "PostScript", \
"Graphics"],
Cell[138858, 3952, 21353, 590, 232, 6278, 399, "GraphicsData", "PostScript", \
"Graphics"],
Cell[160214, 4544, 19005, 526, 232, 5725, 358, "GraphicsData", "PostScript", \
"Graphics"],
Cell[179222, 5072, 21962, 582, 232, 6033, 381, "GraphicsData", "PostScript", \
"Graphics"],
Cell[201187, 5656, 19778, 509, 232, 5298, 326, "GraphicsData", "PostScript", \
"Graphics"],
Cell[220968, 6167, 23789, 648, 232, 6831, 434, "GraphicsData", "PostScript", \
"Graphics"],
Cell[244760, 6817, 13766, 396, 232, 4464, 277, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[258563, 7218, 109, 1, 24, "Input"],
Cell[258675, 7221, 961, 21, 221, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[259685, 7248, 212, 6, 54, "Subsection",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[259922, 7258, 622, 12, 99, "Input",
  PageBreakAbove->False],
Cell[260547, 7272, 80, 1, 20, "Print"],
Cell[260630, 7275, 80, 1, 20, "Print"],
Cell[260713, 7278, 77, 1, 20, "Print"],
Cell[260793, 7281, 77, 1, 20, "Print"],
Cell[260873, 7284, 78, 1, 20, "Print"],
Cell[260954, 7287, 78, 1, 20, "Print"],
Cell[261035, 7290, 78, 1, 20, "Print"],
Cell[261116, 7293, 77, 1, 20, "Print"],
Cell[261196, 7296, 79, 1, 20, "Print"],
Cell[261278, 7299, 79, 1, 20, "Print"],
Cell[261360, 7302, 78, 1, 20, "Print"],
Cell[261441, 7305, 79, 1, 20, "Print"],
Cell[261523, 7308, 79, 1, 20, "Print"],
Cell[261605, 7311, 80, 1, 20, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

