(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    163863,       4601]*)
(*NotebookOutlinePosition[    164513,       4624]*)
(*  CellTagsIndexPosition[    164469,       4620]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Raw Data:", "Subsection"],

Cell[BoxData[
    \(\(\(data1 = "\<16666.198848321954  16656.09084939795    \
361036.51339188917  16840.15152315313    16759.89904120122  \
14112.104101081153  12411.306801782483    5930.787518959634
7950.922436909456    7942.759366044109    170116.1294116369  8083.24730874216 \
   8024.280009437985    6728.350973702553  5915.128961472619    \
2743.376243479616
3778.465613678054    3771.871003546452    79610.32281438571  \
3878.920002346534    3835.7338148786193    3189.9846687729423  \
2799.308483845205    1256.7854432952563
1791.83556549931    1786.4989446833695    37036.91480427851  \
1867.940112858565    1836.395792803331    1505.364459350076  \
1315.8227619112643    570.3395209954119
848.1840204384823    843.8655997867821    17110.20708920304  \
905.6774096905242    882.707572153898    706.3870191309146  613.0922936085043 \
   255.82189681602293
400.0911106137609    396.5961824321505    7819.120873675382  \
443.39633689440774    426.70792690012587    328.384805983654  \
281.62801759239244    112.75491985162515
188.43983897047863    185.61491654881766    3532.145551977117  \
220.95913630421956    208.8354321213004    151.10932681121085  \
127.09799134488043    48.68993374355666
88.44142501908037    86.17213990919618    1567.510557893752  \
112.78354219001942    103.9421157753786    68.40844954565867  \
55.775253031491644    20.40339659793602
41.19364392396037    39.40536668949323    676.2446945924245  \
59.36666187700295    52.84343753337413    30.186514651088807  \
23.42808450253787    8.180601793003246
18.90625652656056    17.55764627441044    279.06476907439105  \
32.447290332750505    27.519064593621803    12.828749421616958  \
9.219543077215912    3.0804984374094744
8.412835081265431    7.46921935400943    107.2996162430381  18.45978330395068 \
   14.617457200320706    5.157601023537414  3.29935069120466    \
1.060123976267875
3.5191842456605844    2.907125542904127    37.15274885076178  \
10.835701720508766    7.796632772012512    1.9083653752067464  \
1.0376988403091074    0.32258572407155023
1.3014434956665881    0.9343165017642838    11.17963815544278  \
6.338836642414899    4.013076481883633    0.6134531543140775  \
0.2769697260818752    0.08336861411426583\>";\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(\(xlist = {0.0001, 0.00017782794100389227, 0.00031622776601683794, 
          0.0005623413251903491, 0.001, 0.0017782794100389228, 
          0.0031622776601683794, 0.005623413251903491, 0.01, 
          0.017782794100389226, 0.0316227766016838, 0.05623413251903491, 
          0.1};\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(stream = StringToStream[data1]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`InputStream[String, 4]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(SetStreamPosition[stream, 0];\)\), "\[IndentingNewLine]", 
    \(\(array = {};\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(Do[\[IndentingNewLine]tmp = 
        Read[stream, Table[Number, {i, 8}]]; \[IndentingNewLine]Print[
        tmp]; \[IndentingNewLine]If[tmp == EndOfFile, 
        Break[]]; \[IndentingNewLine]array = 
        Append[array, tmp];\[IndentingNewLine], {i, 1, 100}]\)}], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(TraditionalForm\\`array\\)\\\" is similar to \
existing symbol \\\"\\!\\(TraditionalForm\\`Array\\)\\\".\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    FormBox[
      RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(TraditionalForm\\`count\\)\\\" is similar to \
existing symbol \\\"\\!\\(TraditionalForm\\`Count\\)\\\".\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    \(TraditionalForm\`{16666.198848321954`, 16656.09084939795`, 
      361036.51339188917`, 16840.15152315313`, 16759.89904120122`, 
      14112.104101081153`, 12411.306801782483`, 
      5930.787518959634`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{7950.922436909456`, 7942.759366044109`, 
      170116.1294116369`, 8083.24730874216`, 8024.280009437985`, 
      6728.350973702553`, 5915.128961472619`, 2743.376243479616`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3778.465613678054`, 3771.871003546452`, 
      79610.32281438571`, 3878.920002346534`, 3835.7338148786193`, 
      3189.9846687729423`, 2799.308483845205`, 
      1256.7854432952563`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1791.83556549931`, 1786.4989446833695`, 
      37036.91480427851`, 1867.940112858565`, 1836.395792803331`, 
      1505.364459350076`, 1315.8227619112643`, 570.3395209954119`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{848.1840204384823`, 843.8655997867821`, 
      17110.20708920304`, 905.6774096905242`, 882.707572153898`, 
      706.3870191309146`, 613.0922936085043`, 255.82189681602293`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{400.0911106137609`, 396.5961824321505`, 
      7819.120873675382`, 443.39633689440774`, 426.70792690012587`, 
      328.384805983654`, 281.62801759239244`, 112.75491985162515`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{188.43983897047863`, 185.61491654881766`, 
      3532.145551977117`, 220.95913630421956`, 208.8354321213004`, 
      151.10932681121085`, 127.09799134488043`, 
      48.68993374355666`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{88.44142501908037`, 86.17213990919618`, 
      1567.510557893752`, 112.78354219001942`, 103.9421157753786`, 
      68.40844954565867`, 55.775253031491644`, 20.40339659793602`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{41.19364392396037`, 39.40536668949323`, 
      676.2446945924245`, 59.36666187700295`, 52.84343753337413`, 
      30.186514651088807`, 23.42808450253787`, 8.180601793003246`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{18.90625652656056`, 17.55764627441044`, 
      279.06476907439105`, 32.447290332750505`, 27.519064593621803`, 
      12.828749421616958`, 9.219543077215912`, 
      3.0804984374094744`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{8.412835081265431`, 7.46921935400943`, 
      107.2996162430381`, 18.45978330395068`, 14.617457200320706`, 
      5.157601023537414`, 3.29935069120466`, 1.060123976267875`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{3.5191842456605844`, 2.907125542904127`, 
      37.15274885076178`, 10.835701720508766`, 7.796632772012512`, 
      1.9083653752067464`, 1.0376988403091074`, 
      0.32258572407155023`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{1.3014434956665881`, 0.9343165017642838`, 
      11.17963815544278`, 6.338836642414899`, 4.013076481883633`, 
      0.6134531543140775`, 0.2769697260818752`, 
      0.08336861411426583`}\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`EndOfFile\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`13\)], "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({dbar, ubar, g, u, d, s, c, b} = \(tarray = 
        array\ \  // Transpose\)\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(TraditionalForm\\`ubar\\)\\\" is similar to \
existing symbol \\\"\\!\\(TraditionalForm\\`dbar\\)\\\".\"\>"}], 
      TraditionalForm]], "Message"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"16666.198848321954`", "7950.922436909456`", 
              "3778.465613678054`", "1791.83556549931`", "848.1840204384823`",
               "400.0911106137609`", "188.43983897047863`", 
              "88.44142501908037`", "41.19364392396037`", 
              "18.90625652656056`", "8.412835081265431`", 
              "3.5191842456605844`", "1.3014434956665881`"},
            {"16656.09084939795`", "7942.759366044109`", "3771.871003546452`",
               "1786.4989446833695`", "843.8655997867821`", 
              "396.5961824321505`", "185.61491654881766`", 
              "86.17213990919618`", "39.40536668949323`", 
              "17.55764627441044`", "7.46921935400943`", "2.907125542904127`",
               "0.9343165017642838`"},
            {"361036.51339188917`", "170116.1294116369`", 
              "79610.32281438571`", "37036.91480427851`", 
              "17110.20708920304`", "7819.120873675382`", 
              "3532.145551977117`", "1567.510557893752`", 
              "676.2446945924245`", "279.06476907439105`", 
              "107.2996162430381`", "37.15274885076178`", 
              "11.17963815544278`"},
            {"16840.15152315313`", "8083.24730874216`", "3878.920002346534`", 
              "1867.940112858565`", "905.6774096905242`", 
              "443.39633689440774`", "220.95913630421956`", 
              "112.78354219001942`", "59.36666187700295`", 
              "32.447290332750505`", "18.45978330395068`", 
              "10.835701720508766`", "6.338836642414899`"},
            {"16759.89904120122`", "8024.280009437985`", 
              "3835.7338148786193`", "1836.395792803331`", 
              "882.707572153898`", "426.70792690012587`", 
              "208.8354321213004`", "103.9421157753786`", 
              "52.84343753337413`", "27.519064593621803`", 
              "14.617457200320706`", "7.796632772012512`", 
              "4.013076481883633`"},
            {"14112.104101081153`", "6728.350973702553`", 
              "3189.9846687729423`", "1505.364459350076`", 
              "706.3870191309146`", "328.384805983654`", 
              "151.10932681121085`", "68.40844954565867`", 
              "30.186514651088807`", "12.828749421616958`", 
              "5.157601023537414`", "1.9083653752067464`", 
              "0.6134531543140775`"},
            {"12411.306801782483`", "5915.128961472619`", 
              "2799.308483845205`", "1315.8227619112643`", 
              "613.0922936085043`", "281.62801759239244`", 
              "127.09799134488043`", "55.775253031491644`", 
              "23.42808450253787`", "9.219543077215912`", "3.29935069120466`",
               "1.0376988403091074`", "0.2769697260818752`"},
            {"5930.787518959634`", "2743.376243479616`", 
              "1256.7854432952563`", "570.3395209954119`", 
              "255.82189681602293`", "112.75491985162515`", 
              "48.68993374355666`", "20.40339659793602`", 
              "8.180601793003246`", "3.0804984374094744`", 
              "1.060123976267875`", "0.32258572407155023`", 
              "0.08336861411426583`"}
            },
          ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = {xlist, u}\  // Transpose\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.0001`", "16840.15152315313`"},
            {"0.00017782794100389227`", "8083.24730874216`"},
            {"0.00031622776601683794`", "3878.920002346534`"},
            {"0.0005623413251903491`", "1867.940112858565`"},
            {"0.001`", "905.6774096905242`"},
            {"0.0017782794100389228`", "443.39633689440774`"},
            {"0.0031622776601683794`", "220.95913630421956`"},
            {"0.005623413251903491`", "112.78354219001942`"},
            {"0.01`", "59.36666187700295`"},
            {"0.017782794100389226`", "32.447290332750505`"},
            {"0.0316227766016838`", "18.45978330395068`"},
            {"0.05623413251903491`", "10.835701720508766`"},
            {"0.1`", "6.338836642414899`"}
            },
          ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["Compare Up Quark & Gluon", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(upQuark = 
      Interpolation[Transpose[{xlist, u}\ ]\  // Evaluate, 
        InterpolationOrder \[Rule] 1]\), "\[IndentingNewLine]", 
    \(pu = 
      LogLogPlot[upQuark[x], {x,  .0001,  .1}, PlotRange \[Rule] All, 
        PlotStyle \[Rule] RGBColor[1, 0, 0]]\)}], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{"InterpolatingFunction", "[", 
          RowBox[{
            RowBox[{"(", "\[NoBreak]", GridBox[{
                  {"0.0001`", "0.1`"}
                  },
                ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
            ",", "\<\"<>\"\>"}], "]"}],
        False,
        Editable->False], TraditionalForm]], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.29365 0.317462 -0.123142 0.171889 [
[.0238 -0.0125 -20 -9.8125 ]
[.0238 -0.0125 20 0 ]
[.2457 -0.0125 -20 -9.8125 ]
[.2457 -0.0125 20 0 ]
[.34127 -0.0125 -17 -9.8125 ]
[.34127 -0.0125 17 0 ]
[.56316 -0.0125 -17 -9.8125 ]
[.56316 -0.0125 17 0 ]
[.65873 -0.0125 -14 -9.8125 ]
[.65873 -0.0125 14 0 ]
[.88062 -0.0125 -14 -9.8125 ]
[.88062 -0.0125 14 0 ]
[.97619 -0.0125 -11 -9.8125 ]
[.97619 -0.0125 11 0 ]
[-0.0125 .04875 -16 -4.90625 ]
[-0.0125 .04875 0 4.90625 ]
[-0.0125 .16889 -16 -4.90625 ]
[-0.0125 .16889 0 4.90625 ]
[-0.0125 .22064 -22 -4.90625 ]
[-0.0125 .22064 0 4.90625 ]
[-0.0125 .34078 -22 -4.90625 ]
[-0.0125 .34078 0 4.90625 ]
[-0.0125 .39253 -28 -4.90625 ]
[-0.0125 .39253 0 4.90625 ]
[-0.0125 .51267 -28 -4.90625 ]
[-0.0125 .51267 0 4.90625 ]
[-0.0125 .56441 -34 -4.90625 ]
[-0.0125 .56441 0 4.90625 ]
[ -0.0005 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0238 0 m
.0238 .00625 L
s
gsave
.0238 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2457 0 m
.2457 .00625 L
s
gsave
.2457 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0005) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.56316 0 m
.56316 .00625 L
s
gsave
.56316 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.005) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65873 0 m
.65873 .00625 L
s
gsave
.65873 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88062 0 m
.88062 .00625 L
s
gsave
.88062 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.11937 0 m
.11937 .00375 L
s
.17527 0 m
.17527 .00375 L
s
.21494 0 m
.21494 .00375 L
s
.27084 0 m
.27084 .00375 L
s
.29209 0 m
.29209 .00375 L
s
.3105 0 m
.3105 .00375 L
s
.32674 0 m
.32674 .00375 L
s
.43683 0 m
.43683 .00375 L
s
.49273 0 m
.49273 .00375 L
s
.5324 0 m
.5324 .00375 L
s
.5883 0 m
.5883 .00375 L
s
.60955 0 m
.60955 .00375 L
s
.62796 0 m
.62796 .00375 L
s
.6442 0 m
.6442 .00375 L
s
.75429 0 m
.75429 .00375 L
s
.8102 0 m
.8102 .00375 L
s
.84986 0 m
.84986 .00375 L
s
.90576 0 m
.90576 .00375 L
s
.92701 0 m
.92701 .00375 L
s
.94543 0 m
.94543 .00375 L
s
.96166 0 m
.96166 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .04875 m
.00625 .04875 L
s
gsave
-0.0125 .04875 -77 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .16889 m
.00625 .16889 L
s
gsave
-0.0125 .16889 -77 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(50) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .22064 m
.00625 .22064 L
s
gsave
-0.0125 .22064 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .34078 m
.00625 .34078 L
s
gsave
-0.0125 .34078 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(500) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .39253 m
.00625 .39253 L
s
gsave
-0.0125 .39253 -89 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1000) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .51267 m
.00625 .51267 L
s
gsave
-0.0125 .51267 -89 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5000) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .56441 m
.00625 .56441 L
s
gsave
-0.0125 .56441 -95 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10000) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
0 .10049 m
.00375 .10049 L
s
0 .13076 m
.00375 .13076 L
s
0 .15223 m
.00375 .15223 L
s
0 .1825 m
.00375 .1825 L
s
0 .19401 m
.00375 .19401 L
s
0 .20398 m
.00375 .20398 L
s
0 .21277 m
.00375 .21277 L
s
0 .27238 m
.00375 .27238 L
s
0 .30265 m
.00375 .30265 L
s
0 .32412 m
.00375 .32412 L
s
0 .35439 m
.00375 .35439 L
s
0 .3659 m
.00375 .3659 L
s
0 .37587 m
.00375 .37587 L
s
0 .38466 m
.00375 .38466 L
s
0 .44427 m
.00375 .44427 L
s
0 .47454 m
.00375 .47454 L
s
0 .49601 m
.00375 .49601 L
s
0 .52628 m
.00375 .52628 L
s
0 .53779 m
.00375 .53779 L
s
0 .54776 m
.00375 .54776 L
s
0 .55655 m
.00375 .55655 L
s
0 .61616 m
.00375 .61616 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .60332 m
.53756 .26344 L
.63749 .20092 L
.69193 .16881 L
.72956 .14466 L
.76079 .12882 L
.78536 .11744 L
.80742 .10307 L
.81229 .09912 L
.81488 .09686 L
.81614 .09573 L
.81668 .09523 L
.81727 .09468 L
.81781 .09441 L
.8183 .09427 L
.81927 .09398 L
.82139 .09336 L
.82578 .092 L
.8414 .08659 L
.85568 .08064 L
.86939 .07376 L
.88142 .06646 L
.89208 .05869 L
.89457 .05666 L
.89592 .05552 L
.89624 .05524 L
.89658 .05495 L
.89687 .05473 L
.89719 .05463 L
.8979 .05443 L
.89867 .0542 L
.90001 .0538 L
.90259 .05302 L
.912 .04996 L
.92096 .04671 L
.92907 .04344 L
.9372 .0398 L
.9446 .03611 L
.95136 .03239 L
.95821 .02821 L
.9645 .02396 L
.97088 .01915 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`006P3oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0P0000040?ooo`8000000`3oool4
000001H0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000103oool4
000000030?ooo`0000000000008000001@3oool2000000@0oooo0P0000030?ooo`@000006`3oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0P0000030?ooo`<0000000<0oooo
000000000000103oool00`000000oooo0?ooo`030?ooo`8000000`3oool400000240oooo0P000004
0?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`<000001`3oool2000000@0oooo00<00000
0?ooo`3oool00P3oool4000000@0oooo000I0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool01P000000oooo000000000000oooo000000<0
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool07`3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo000I0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01P000000oooo000000000000
oooo000000<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool07`3oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool0
10000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo000I0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo
000000000000oooo00@000001@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool400000080oooo00<000000?ooo`3o
ool01P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo01l0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000020?ooo`<000001P3oool010000000oooo0?oo
o`00000:0?ooo`030000003oool0oooo00<0oooo000I0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo000000000000oooo
008000001`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool06@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00H0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0O0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`060?ooo`04
0000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool001T0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool3000001H0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00D000000?ooo`00000000000?oo
o`02000000L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`<0
00006`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00H0oooo
00@000000?ooo`3oool000000P3oool300000240oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool00000203o
ool3000000D0oooo000J0?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`8000001@3oool0
0`000000oooo0?ooo`0E0?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`@0000000<0oooo
0000000000000P0000050?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool06P3oool2
000000X0oooo0P0000040?ooo`8000000`3oool6000000X0oooo0P0000050?ooo`030000003oool0
oooo0200oooo0P00000:0?ooo`8000000`3oool4000000H0oooo0P00000;0?ooo`030000003oool0
oooo00<0oooo003o0?ooob40oooo003o0?ooob40oooo000U0?ooooD000001P3oool002D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000000F0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`090?ooo`009@3oool00`00
0000oooo0?ooo`3h0?ooo`009@3oool00`000000oooo0?ooo`3/0?ooo`030?l0003oool0oooo00T0
oooo000U0?ooo`030000003oool0oooo0>/0oooo00<0o`000?ooo`3oool02P3oool002D0oooo00<0
00000?ooo`3oool0jP3oool00`3o0000oooo0?ooo`0;0?ooo`009@3oool00`000000oooo0?ooo`3X
0?ooo`80o`003P3oool002D0oooo00<000000?ooo`3oool0iP3oool20?l00100oooo000U0?ooo`03
0000003oool0oooo0>D0oooo00<0o`000?ooo`3oool0403oool002D0oooo00<000000?ooo`3oool0
h`3oool20?l001<0oooo000E0?ooo`@000000`3oool2000000L0oooo00<000000?ooo`3oool0g`3o
ool40?l001D0oooo000G0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0=d0oooo0P3o000I0?ooo`005`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0103oool200000=`0oooo0P3o000K0?ooo`005`3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`3H0?ooo`<0o`007@3oool001L0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0e`3oool20?l001l0oooo000E0?ooo`<000000`3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo0=D0oooo0P3o000Q0?ooo`005`3oool0
0`000000oooo0?ooo`020?ooo`8000001`3oool00`000000oooo0?ooo`3D0?ooo`030?l0003oool0
oooo0240oooo000U0?ooo`030000003oool0oooo0=80oooo0P3o000T0?ooo`009@3oool00`000000
oooo0?ooo`3A0?ooo`030?l0003oool0oooo02@0oooo000U0?ooo`030000003oool0oooo0<l0oooo
0P3o000W0?ooo`009@3oool00`000000oooo0?ooo`3=0?ooo`80o`00:@3oool002D0oooo00<00000
0?ooo`3oool0b@3oool40?l002/0oooo000U0?ooo`030000003oool0oooo0<L0oooo0P3o000_0?oo
o`009@3oool00`000000oooo0?ooo`340?ooo`<0o`00<@3oool002D0oooo00<000000?ooo`3oool0
``3oool20?l003<0oooo000U0?ooo`030000003oool0oooo0<80oooo00<0o`000?ooo`3oool0<`3o
ool002D0oooo00<000000?ooo`3oool0`@3oool00`3o0000oooo0?ooo`0d0?ooo`009@3oool00`00
0000oooo0?ooo`2o0?ooo`80o`00=`3oool002D0oooo00<000000?ooo`3oool0_P3oool00`3o0000
oooo0?ooo`0g0?ooo`009@3oool00`000000oooo0?ooo`2l0?ooo`80o`00>P3oool002D0oooo00<0
00000?ooo`3oool0^@3oool30?l003`0oooo000U0?ooo`030000003oool0oooo0;H0oooo0`3o000o
0?ooo`009@3oool00`000000oooo0?ooo`2d0?ooo`80o`00@P3oool002D0oooo00<000000?ooo`3o
ool0/P3oool20?l004@0oooo000U0?ooo`030000003oool0oooo0;00oooo0P3o00160?ooo`009@3o
ool00`000000oooo0?ooo`2_0?ooo`030?l0003oool0oooo04H0oooo000U0?ooo`030000003oool0
oooo0:d0oooo0P3o00190?ooo`009@3oool00`000000oooo0?ooo`2/0?ooo`030?l0003oool0oooo
04T0oooo000U0?ooo`030000003oool0oooo0:X0oooo0P3o001<0?ooo`009@3oool00`000000oooo
0?ooo`2Y0?ooo`030?l0003oool0oooo04`0oooo000E0?ooo`<00000103oool2000000L0oooo00<0
00000?ooo`3oool0Y`3oool20?l004l0oooo000H0?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool0103oool200000:L0oooo00<0o`000?ooo`3oool0C`3oool001P0oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:@0oooo0P3o
001B0?ooo`005@3oool3000000<0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?oo
o`2R0?ooo`80o`00E03oool001D0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00060?ooo`030000003oool0oooo0:40oooo00<0o`000?ooo`3oool0E03oool001D0oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo09l0oooo0P3o
001G0?ooo`005@3oool4000000<0oooo0P0000070?ooo`030000003oool0oooo09h0oooo00<0o`00
0?ooo`3oool0E`3oool002D0oooo00<000000?ooo`3oool0W03oool20?l005X0oooo000U0?ooo`03
0000003oool0oooo09X0oooo0P3o001L0?ooo`009@3oool00`000000oooo0?ooo`2I0?ooo`030?l0
003oool0oooo05`0oooo000U0?ooo`030000003oool0oooo09L0oooo0P3o001O0?ooo`009@3oool0
0`000000oooo0?ooo`2E0?ooo`80o`00H@3oool000l0oooo100000030?ooo`800000103oool20000
00L0oooo00<000000?ooo`3oool0U03oool00`3o0000oooo0?ooo`1Q0?ooo`004@3oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0980oooo0P3o001T0?ooo`004@3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`800000T@3o
ool20?l006H0oooo000A0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0S`3oool00`3o0000oooo
0?ooo`1V0?ooo`004@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08d0oooo0P3o001Y0?ooo`00
3`3oool3000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000060?oo
o`030000003oool0oooo08/0oooo0P3o001[0?ooo`004@3oool00`000000oooo0?ooo`020?ooo`80
0000103oool2000000L0oooo00<000000?ooo`3oool0RP3oool00`3o0000oooo0?ooo`1[0?ooo`00
9@3oool00`000000oooo0?ooo`280?ooo`80o`00KP3oool002D0oooo00<000000?ooo`3oool0QP3o
ool20?l00700oooo000U0?ooo`030000003oool0oooo08D0oooo00<0o`000?ooo`3oool0L03oool0
02D0oooo00<000000?ooo`3oool0P`3oool20?l007<0oooo000U0?ooo`030000003oool0oooo0840
oooo0P3o001e0?ooo`009@3oool00`000000oooo0?ooo`200?ooo`030?l0003oool0oooo07D0oooo
000U0?ooo`030000003oool0oooo07h0oooo0P3o001h0?ooo`009@3oool00`000000oooo0?ooo`1m
0?ooo`030?l0003oool0oooo07P0oooo000U0?ooo`030000003oool0oooo07/0oooo0P3o001k0?oo
o`009@3oool00`000000oooo0?ooo`1j0?ooo`030?l0003oool0oooo07/0oooo000U0?ooo`030000
003oool0oooo07P0oooo0P3o001n0?ooo`009@3oool00`000000oooo0?ooo`1g0?ooo`030?l0003o
ool0oooo07h0oooo000U0?ooo`030000003oool0oooo07D0oooo0P3o00210?ooo`009@3oool00`00
0000oooo0?ooo`1d0?ooo`030?l0003oool0oooo0840oooo000U0?ooo`030000003oool0oooo0780
oooo0P3o00240?ooo`009@3oool00`000000oooo0?ooo`1a0?ooo`030?l0003oool0oooo08@0oooo
000U0?ooo`030000003oool0oooo06l0oooo0P3o00270?ooo`009@3oool00`000000oooo0?ooo`1^
0?ooo`030?l0003oool0oooo08L0oooo000U0?ooo`030000003oool0oooo06`0oooo0P3o002:0?oo
o`009@3oool00`000000oooo0?ooo`1[0?ooo`030?l0003oool0oooo08X0oooo000U0?ooo`030000
003oool0oooo06T0oooo0P3o002=0?ooo`009@3oool00`000000oooo0?ooo`1X0?ooo`030?l0003o
ool0oooo08d0oooo000U0?ooo`030000003oool0oooo06H0oooo0P3o002@0?ooo`003`3oool30000
00@0oooo0P0000040?ooo`8000001`3oool00`000000oooo0?ooo`1U0?ooo`030?l0003oool0oooo
0900oooo000B0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`040?ooo`800000I03oool20?l009<0oooo000B0?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0680oooo00<0o`000?ooo`3oool0T`3oool000l0oooo0`0000030?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`1P0?ooo`80o`00
UP3oool000l0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000H0oooo00<000000?ooo`3oool0G`3oool00`3o0000oooo0?ooo`2F0?ooo`00
3`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000001P3oool00`000000oooo0?ooo`1M0?ooo`80o`00V@3oool000l0oooo100000030?ooo`80
0000103oool2000000L0oooo00<000000?ooo`3oool0G03oool00`3o0000oooo0?ooo`2I0?ooo`00
9@3oool00`000000oooo0?ooo`1J0?ooo`80o`00W03oool002D0oooo00<000000?ooo`3oool0F@3o
ool00`3o0000oooo0?ooo`2L0?ooo`009@3oool00`000000oooo0?ooo`1G0?ooo`80o`00W`3oool0
02D0oooo00<000000?ooo`3oool0EP3oool00`3o0000oooo0?ooo`2O0?ooo`009@3oool00`000000
oooo0?ooo`1D0?ooo`80o`00XP3oool002D0oooo00<000000?ooo`3oool0D`3oool00`3o0000oooo
0?ooo`2R0?ooo`002@3oool4000000<0oooo0P0000040?ooo`800000103oool2000000L0oooo00<0
00000?ooo`3oool0D@3oool20?l00:D0oooo000;0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool0103oool200000540oooo00<0o`000?ooo`3oool0Y@3oool000/0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo04h0oooo0P3o002X0?ooo`002`3oool01@00
0000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0C@3oool00`3o0000oooo
0?ooo`2X0?ooo`002`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0B`3oool20?l00:/0oooo00090?ooo`<000000`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?oo
o`1:0?ooo`030?l0003oool0oooo0:/0oooo000;0?ooo`030000003oool0oooo0080oooo0P000004
0?ooo`800000103oool2000000L0oooo00<000000?ooo`3oool0B03oool20?l00:h0oooo000U0?oo
o`030000003oool0oooo04L0oooo00<0o`000?ooo`3oool0[P3oool002D0oooo00<000000?ooo`3o
ool0A@3oool20?l00;40oooo000U0?ooo`030000003oool0oooo04@0oooo00<0o`000?ooo`3oool0
/@3oool002D0oooo00<000000?ooo`3oool0@P3oool20?l00;@0oooo000U0?ooo`030000003oool0
oooo0440oooo00<0o`000?ooo`3oool0]03oool002D0oooo00<000000?ooo`3oool0?`3oool20?l0
0;L0oooo000U0?ooo`030000003oool0oooo03h0oooo00<0o`000?ooo`3oool0]`3oool002D0oooo
00<000000?ooo`3oool0?03oool20?l00;X0oooo000U0?ooo`030000003oool0oooo03/0oooo00<0
o`000?ooo`3oool0^P3oool002D0oooo00<000000?ooo`3oool0>@3oool20?l00;d0oooo000U0?oo
o`030000003oool0oooo03P0oooo00<0o`000?ooo`3oool0_@3oool002D0oooo00<000000?ooo`3o
ool0=P3oool20?l00<00oooo000U0?ooo`030000003oool0oooo03D0oooo00<0o`000?ooo`3oool0
`03oool002D0oooo00<000000?ooo`3oool0<`3oool20?l00<<0oooo000U0?ooo`030000003oool0
oooo0380oooo00<0o`000?ooo`3oool0``3oool002D0oooo00<000000?ooo`3oool0<03oool20?l0
0<H0oooo000U0?ooo`030000003oool0oooo02l0oooo00<0o`000?ooo`3oool0aP3oool002D0oooo
00<000000?ooo`3oool0;@3oool20?l00<T0oooo000U0?ooo`030000003oool0oooo02`0oooo00<0
o`000?ooo`3oool0b@3oool002D0oooo00<000000?ooo`3oool0:P3oool20?l00<`0oooo000U0?oo
o`030000003oool0oooo02T0oooo00<0o`000?ooo`3oool0c03oool002D0oooo00<000000?ooo`3o
ool09`3oool20?l00<l0oooo00090?ooo`<00000103oool2000000@0oooo0P0000040?ooo`800000
1`3oool00`000000oooo0?ooo`0V0?ooo`030?l0003oool0oooo0<l0oooo000<0?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo00@0oooo0P00000U0?ooo`80o`00dP3oool000`0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`030?l0003oool0oooo0=80oooo0009
0?ooo`<000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`0Q0?ooo`80o`00e@3oool000T0oooo
00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`0P0?ooo`030?l0003oool0
oooo0=D0oooo00090?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool0
7P3oool20?l00=P0oooo00090?ooo`@000000`3oool2000000@0oooo0P0000040?ooo`8000001`3o
ool00`000000oooo0?ooo`0M0?ooo`030?l0003oool0oooo0=P0oooo000U0?ooo`030000003oool0
oooo01/0oooo0P3o003K0?ooo`009@3oool00`000000oooo0?ooo`0J0?ooo`030?l0003oool0oooo
0=/0oooo000U0?ooo`030000003oool0oooo01P0oooo0P3o003N0?ooo`009@3oool00`000000oooo
0?ooo`0G0?ooo`030?l0003oool0oooo0=h0oooo000U0?ooo`030000003oool0oooo01D0oooo0P3o
003Q0?ooo`009@3oool00`000000oooo0?ooo`0D0?ooo`030?l0003oool0oooo0>40oooo00030?oo
o`@000000`3oool2000000@0oooo0P0000040?ooo`800000103oool2000000L0oooo00<000000?oo
o`3oool04P3oool20?l00>@0oooo00050?ooo`050000003oool0oooo0?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`040?ooo`8000004P3oool00`3o0000oooo0?ooo`3T0?ooo`001@3o
ool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0?0?ooo`80o`00i`3oool000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03P3oool00`3o0000
oooo0?ooo`3W0?ooo`001@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`80o`00jP3oool000<0oooo0`000003
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool02`3oool00`3o
0000oooo0?ooo`3Z0?ooo`001@3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000@0
oooo0P0000040?ooo`8000001`3oool00`000000oooo0?ooo`090?ooo`80o`00k@3oool002D0oooo
00<000000?ooo`3oool0203oool00`3o0000oooo0?ooo`3]0?ooo`009@3oool00`000000oooo0?oo
o`060?ooo`80o`00l03oool002D0oooo00<000000?ooo`3oool01@3oool00`3o0000oooo0?ooo`3`
0?ooo`009@3oool00`000000oooo0?ooo`030?ooo`80o`00l`3oool002D0oooo00<000000?ooo`3o
ool00P3oool00`3o0000oooo0?ooo`3c0?ooo`009@3oool00`000000oooo0?ooo`3h0?ooo`009@3o
ool00`000000oooo0?ooo`3h0?ooo`009@3oool00`000000oooo0?ooo`3h0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.55192, 0.258423, \
0.0128694, 0.0237685}}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(gluon = 
      Interpolation[Transpose[{xlist, g}\ ]\  // Evaluate, 
        InterpolationOrder \[Rule] 1]\), "\[IndentingNewLine]", 
    \(pg = 
      LogLogPlot[gluon[x], {x,  .0001,  .1}, PlotRange \[Rule] All, 
        PlotStyle \[Rule] RGBColor[0, 0, 1]]\)}], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{"InterpolatingFunction", "[", 
          RowBox[{
            RowBox[{"(", "\[NoBreak]", GridBox[{
                  {"0.0001`", "0.1`"}
                  },
                ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
            ",", "\<\"<>\"\>"}], "]"}],
        False,
        Editable->False], TraditionalForm]], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.29365 0.317462 -0.122143 0.130537 [
[.0238 -0.0125 -20 -9.8125 ]
[.0238 -0.0125 20 0 ]
[.2457 -0.0125 -20 -9.8125 ]
[.2457 -0.0125 20 0 ]
[.34127 -0.0125 -17 -9.8125 ]
[.34127 -0.0125 17 0 ]
[.56316 -0.0125 -17 -9.8125 ]
[.56316 -0.0125 17 0 ]
[.65873 -0.0125 -14 -9.8125 ]
[.65873 -0.0125 14 0 ]
[.88062 -0.0125 -14 -9.8125 ]
[.88062 -0.0125 14 0 ]
[.97619 -0.0125 -11 -9.8125 ]
[.97619 -0.0125 11 0 ]
[-0.0125 .00839 -16 -4.90625 ]
[-0.0125 .00839 0 4.90625 ]
[-0.0125 .13893 -22 -4.90625 ]
[-0.0125 .13893 0 4.90625 ]
[-0.0125 .26947 -28 -4.90625 ]
[-0.0125 .26947 0 4.90625 ]
[-0.0125 .4 -34 -4.90625 ]
[-0.0125 .4 0 4.90625 ]
[-0.0125 .53054 -46 -4.90625 ]
[-0.0125 .53054 0 4.90625 ]
[ -0.0005 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0238 0 m
.0238 .00625 L
s
gsave
.0238 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2457 0 m
.2457 .00625 L
s
gsave
.2457 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0005) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.56316 0 m
.56316 .00625 L
s
gsave
.56316 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.005) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65873 0 m
.65873 .00625 L
s
gsave
.65873 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88062 0 m
.88062 .00625 L
s
gsave
.88062 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.11937 0 m
.11937 .00375 L
s
.17527 0 m
.17527 .00375 L
s
.21494 0 m
.21494 .00375 L
s
.27084 0 m
.27084 .00375 L
s
.29209 0 m
.29209 .00375 L
s
.3105 0 m
.3105 .00375 L
s
.32674 0 m
.32674 .00375 L
s
.43683 0 m
.43683 .00375 L
s
.49273 0 m
.49273 .00375 L
s
.5324 0 m
.5324 .00375 L
s
.5883 0 m
.5883 .00375 L
s
.60955 0 m
.60955 .00375 L
s
.62796 0 m
.62796 .00375 L
s
.6442 0 m
.6442 .00375 L
s
.75429 0 m
.75429 .00375 L
s
.8102 0 m
.8102 .00375 L
s
.84986 0 m
.84986 .00375 L
s
.90576 0 m
.90576 .00375 L
s
.92701 0 m
.92701 .00375 L
s
.94543 0 m
.94543 .00375 L
s
.96166 0 m
.96166 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00839 m
.00625 .00839 L
s
gsave
-0.0125 .00839 -77 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .13893 m
.00625 .13893 L
s
gsave
-0.0125 .13893 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .26947 m
.00625 .26947 L
s
gsave
-0.0125 .26947 -89 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1000) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .4 m
.00625 .4 L
s
gsave
-0.0125 .4 -95 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10000) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .53054 m
.00625 .53054 L
s
gsave
-0.0125 .53054 -107 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100000.) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
0 .04769 m
.00375 .04769 L
s
0 .07068 m
.00375 .07068 L
s
0 .08698 m
.00375 .08698 L
s
0 .09963 m
.00375 .09963 L
s
0 .10997 m
.00375 .10997 L
s
0 .11871 m
.00375 .11871 L
s
0 .12628 m
.00375 .12628 L
s
0 .13296 m
.00375 .13296 L
s
0 .17823 m
.00375 .17823 L
s
0 .20121 m
.00375 .20121 L
s
0 .21752 m
.00375 .21752 L
s
0 .23017 m
.00375 .23017 L
s
0 .24051 m
.00375 .24051 L
s
0 .24925 m
.00375 .24925 L
s
0 .25682 m
.00375 .25682 L
s
0 .26349 m
.00375 .26349 L
s
0 .30876 m
.00375 .30876 L
s
0 .33175 m
.00375 .33175 L
s
0 .34806 m
.00375 .34806 L
s
0 .36071 m
.00375 .36071 L
s
0 .37104 m
.00375 .37104 L
s
0 .37978 m
.00375 .37978 L
s
0 .38735 m
.00375 .38735 L
s
0 .39403 m
.00375 .39403 L
s
0 .4393 m
.00375 .4393 L
s
0 .46228 m
.00375 .46228 L
s
0 .47859 m
.00375 .47859 L
s
0 .49124 m
.00375 .49124 L
s
0 .50158 m
.00375 .50158 L
s
0 .51032 m
.00375 .51032 L
s
0 .51789 m
.00375 .51789 L
s
0 .52457 m
.00375 .52457 L
s
0 .56984 m
.00375 .56984 L
s
0 .59282 m
.00375 .59282 L
s
0 .60913 m
.00375 .60913 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .60332 m
.53756 .32664 L
.63749 .26756 L
.69193 .23425 L
.72956 .20722 L
.76079 .18846 L
.78536 .17496 L
.79714 .16596 L
.80742 .15589 L
.81169 .15085 L
.81613 .14488 L
.81674 .14399 L
.81707 .14351 L
.81741 .143 L
.81774 .14283 L
.81804 .14272 L
.81861 .14252 L
.82085 .14173 L
.82513 .14013 L
.83345 .13674 L
.84176 .13291 L
.85633 .12481 L
.86902 .11574 L
.88136 .10417 L
.89227 .09023 L
.89496 .086 L
.89559 .08494 L
.89626 .08379 L
.89653 .08331 L
.89683 .0828 L
.89715 .08268 L
.89745 .08256 L
.89966 .08173 L
.90201 .08081 L
.90676 .07886 L
.91168 .07669 L
.92087 .07216 L
.92917 .06743 L
.93671 .06247 L
.94431 .05667 L
.95125 .05046 L
.95826 .04302 L
.96469 .03479 L
.97061 .02555 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`009P3oool2000000@0oooo00<000000?ooo`3oool0
0`3oool2000000@0oooo0P0000040?ooo`8000000`3oool4000001<0oooo0P0000040?ooo`030000
003oool0oooo00<0oooo0P0000040?ooo`800000103oool300000080oooo0`0000050?ooo`800000
103oool2000000<0oooo1000000H0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000
103oool2000000<0oooo1@0000040?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`@00000
7P3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000<0oooo0`0000060?ooo`800000
103oool00`000000oooo0?ooo`020?ooo`@00000103oool002D0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`0A0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`80000000<0oooo00000000
0000103oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo0P0000000`3oool0
00000?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0703oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo000U0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool200000003
0?ooo`000000000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`80
000000<0oooo0000003oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
01`0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`009@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0140oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo0P000000103oool000000000003oool3000000@0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`0000020?oo
o`030000003oool0oooo00H0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0L
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool3000000D0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`009@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo0140oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0P0000001@3o
ool000000000003oool0000000H0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`060?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0703o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool01@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo000U0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo0`00000C0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`80000000D0oooo
000000000000oooo000000060?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool3000001P0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo00000080oooo0`00000N0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo
000000P0oooo0`0000050?ooo`009P3oool2000000X0oooo0P0000040?ooo`800000103oool20000
00D0oooo00<000000?ooo`3oool04P3oool2000000X0oooo0P0000040?ooo`800000103oool30000
0080oooo100000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool05`3oool20000
00X0oooo0P0000040?ooo`8000000`3oool5000000X0oooo0P0000050?ooo`030000003oool0oooo
01d0oooo0P00000:0?ooo`8000000`3oool4000000D0oooo0P00000;0?ooo`030000003oool0oooo
00<0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo000Q0?ooo`@000000`3oool2
000000H0oooojP0000060?ooo`008`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool3000000<0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0`
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02@3oool002<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0k@3oool0
02<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0h@3oool00`000?l0oooo0?ooo`090?ooo`008`3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3P0?ooo`030000o`3oool0
oooo00X0oooo000Q0?ooo`<000000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0
oooo0=l0oooo00<0003o0?ooo`3oool02`3oool002<0oooo00<000000?ooo`3oool00P3oool20000
00H0oooo00<000000?ooo`3oool0g`3oool00`000?l0oooo0?ooo`0;0?ooo`00<03oool00`000000
oooo0?ooo`3N0?ooo`030000o`3oool0oooo00`0oooo000`0?ooo`030000003oool0oooo0=h0oooo
00<0003o0?ooo`3oool0303oool00300oooo00<000000?ooo`3oool0g@3oool00`000?l0oooo0?oo
o`0=0?ooo`00<03oool00`000000oooo0?ooo`3L0?ooo`030000o`3oool0oooo00h0oooo000`0?oo
o`800000g03oool00`000?l0oooo0?ooo`0?0?ooo`00<03oool00`000000oooo0?ooo`3J0?ooo`03
0000o`3oool0oooo0100oooo000`0?ooo`030000003oool0oooo0=P0oooo0P000?lC0?ooo`00<03o
ool00`000000oooo0?ooo`3G0?ooo`030000o`3oool0oooo01<0oooo000`0?ooo`030000003oool0
oooo0=D0oooo0P000?lF0?ooo`00<03oool200000=@0oooo0P000?lH0?ooo`00<03oool00`000000
oooo0?ooo`3A0?ooo`80003o6P3oool00300oooo00<000000?ooo`3oool0c`3oool20000oa`0oooo
000`0?ooo`030000003oool0oooo0<h0oooo0P000?lM0?ooo`00<03oool200000<h0oooo0P000?lN
0?ooo`00<03oool00`000000oooo0?ooo`3<0?ooo`030000o`3oool0oooo01h0oooo000`0?ooo`03
0000003oool0oooo0<`0oooo00<0003o0?ooo`3oool07P3oool00300oooo0P00003<0?ooo`030000
o`3oool0oooo01l0oooo000`0?ooo`030000003oool0oooo0<X0oooo00<0003o0?ooo`3oool0803o
ool00300oooo0P00003:0?ooo`030000o`3oool0oooo0240oooo000`0?ooo`030000003oool0oooo
0<P0oooo00<0003o0?ooo`3oool08P3oool00300oooo0P0000380?ooo`030000o`3oool0oooo02<0
oooo000`0?ooo`030000003oool0oooo0<H0oooo00<0003o0?ooo`3oool0903oool00300oooo0P00
00340?ooo`<0003o9`3oool001/0oooo100000030?ooo`800000103oool2000000H0oooo0P000031
0?ooo`<0003o:P3oool001d0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2n0?ooo`80003o;@3o
ool001d0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool00`3oool300000;`0oooo0P000?l_0?ooo`007@3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0;/0oooo0P000?l`0?ooo`007@3oool01@000000oooo0?ooo`3oool000000080
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0;/0oooo00<0003o0?ooo`3oool0;`3oool001/0oooo0`0000030?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`2j0?ooo`030000o`3oool0
oooo0300oooo000M0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`8000001P3oool00`00
0000oooo0?ooo`2i0?ooo`030000o`3oool0oooo0340oooo000`0?ooo`030000003oool0oooo0;P0
oooo00<0003o0?ooo`3oool0<P3oool00300oooo00<000000?ooo`3oool0]`3oool00`000?l0oooo
0?ooo`0c0?ooo`00<03oool00`000000oooo0?ooo`2e0?ooo`80003o=P3oool00300oooo00<00000
0?ooo`3oool0/`3oool20000ocP0oooo000`0?ooo`800000/P3oool20000ocX0oooo000`0?ooo`03
0000003oool0oooo0:l0oooo0P000?ll0?ooo`00<03oool00`000000oooo0?ooo`2^0?ooo`030000
o`3oool0oooo03`0oooo000`0?ooo`030000003oool0oooo0:`0oooo0P000?lo0?ooo`00<03oool0
0`000000oooo0?ooo`2[0?ooo`030000o`3oool0oooo03l0oooo000`0?ooo`800000Z`3oool00`00
0?l0oooo0?ooo`100?ooo`00<03oool00`000000oooo0?ooo`2X0?ooo`80003o@`3oool00300oooo
00<000000?ooo`3oool0Y`3oool00`000?l0oooo0?ooo`130?ooo`00<03oool00`000000oooo0?oo
o`2U0?ooo`80003oAP3oool00300oooo0P00002U0?ooo`030000o`3oool0oooo04H0oooo000`0?oo
o`030000003oool0oooo0:80oooo0P000?m90?ooo`00<03oool00`000000oooo0?ooo`2Q0?ooo`03
0000o`3oool0oooo04T0oooo000`0?ooo`800000X03oool20000od`0oooo000`0?ooo`030000003o
ool0oooo09h0oooo00<0003o0?ooo`3oool0C03oool00300oooo0P00002M0?ooo`80003oC`3oool0
0300oooo00<000000?ooo`3oool0V`3oool00`000?l0oooo0?ooo`1?0?ooo`00<03oool2000009X0
oooo0P000?mB0?ooo`00<03oool00`000000oooo0?ooo`2H0?ooo`030000o`3oool0oooo0580oooo
000`0?ooo`800000U`3oool20000oeD0oooo000`0?ooo`030000003oool0oooo09D0oooo00<0003o
0?ooo`3oool0E@3oool001D0oooo100000030?ooo`800000103oool2000000@0oooo0P0000060?oo
o`800000U03oool20000oeP0oooo000G0?ooo`050000003oool0oooo0?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3o
ool300000980oooo00<0003o0?ooo`3oool0F03oool001L0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0900oooo0P000?mK0?ooo`005`3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0SP3oool20000oed0oooo000G0?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2<0?ooo`80003o
G`3oool001D0oooo0`0000030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo08X0oooo0P000?mQ0?oo
o`005`3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000@0oooo0P0000060?ooo`03
0000003oool0oooo08P0oooo0P000?mS0?ooo`00<03oool00`000000oooo0?ooo`260?ooo`80003o
I@3oool00300oooo00<000000?ooo`3oool0Q@3oool00`000?l0oooo0?ooo`1U0?ooo`00<03oool0
0`000000oooo0?ooo`230?ooo`80003oJ03oool00300oooo0P0000220?ooo`80003oJP3oool00300
oooo00<000000?ooo`3oool0O`3oool20000of`0oooo000`0?ooo`030000003oool0oooo07d0oooo
0P000?m^0?ooo`00<03oool00`000000oooo0?ooo`1k0?ooo`80003oL03oool00300oooo00<00000
0?ooo`3oool0NP3oool00`000?l0oooo0?ooo`1`0?ooo`00<03oool00`000000oooo0?ooo`1h0?oo
o`80003oL`3oool00300oooo0P00001g0?ooo`80003oM@3oool00300oooo00<000000?ooo`3oool0
M03oool20000ogL0oooo000`0?ooo`030000003oool0oooo0780oooo0P000?mi0?ooo`00<03oool2
00000740oooo0P000?mk0?ooo`00<03oool00`000000oooo0?ooo`1_0?ooo`030000o`3oool0oooo
07/0oooo000`0?ooo`030000003oool0oooo06d0oooo0P000?mn0?ooo`00<03oool2000006`0oooo
0P000?n00?ooo`00<03oool00`000000oooo0?ooo`1Y0?ooo`80003oPP3oool00300oooo00<00000
0?ooo`3oool0I`3oool20000oh@0oooo000`0?ooo`800000IP3oool20000ohH0oooo000`0?ooo`03
0000003oool0oooo06@0oooo00<0003o0?ooo`3oool0QP3oool00300oooo0P00001S0?ooo`80003o
R@3oool00300oooo00<000000?ooo`3oool0H03oool20000oh/0oooo000`0?ooo`800000G`3oool2
0000ohd0oooo000?0?ooo`@000000`3oool2000000@0oooo0P0000040?ooo`800000103oool20000
00H0oooo0P00001M0?ooo`80003oS`3oool00140oooo00D000000?ooo`3oool0oooo000000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0FP3oool20000oi40oooo
000A0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`<00000F@3oool00`000?l0oooo0?ooo`2A0?ooo`004@3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1G0?ooo`80
003oU03oool00140oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0E@3oool20000oiH0oooo000?0?ooo`<000000`3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo05<0oooo0P000?nH0?oo
o`004@3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000@0oooo0P0000040?ooo`80
00001P3oool00`000000oooo0?ooo`1A0?ooo`80003oVP3oool00300oooo00<000000?ooo`3oool0
C`3oool20000oi`0oooo000`0?ooo`030000003oool0oooo04h0oooo00<0003o0?ooo`3oool0W03o
ool00300oooo00<000000?ooo`3oool0C03oool20000oil0oooo000`0?ooo`030000003oool0oooo
04X0oooo0P000?nQ0?ooo`00<03oool2000004T0oooo0P000?nS0?ooo`00<03oool00`000000oooo
0?ooo`160?ooo`80003oY@3oool00300oooo00<000000?ooo`3oool0A03oool20000ojL0oooo000`
0?ooo`030000003oool0oooo04<0oooo00<0003o0?ooo`3oool0Y`3oool00300oooo00<000000?oo
o`3oool0@@3oool20000ojX0oooo000`0?ooo`800000@03oool20000oj`0oooo000`0?ooo`030000
003oool0oooo03d0oooo0P000?n^0?ooo`00<03oool00`000000oooo0?ooo`0k0?ooo`80003o/03o
ool00300oooo00<000000?ooo`3oool0>P3oool00`000?l0oooo0?ooo`2`0?ooo`00<03oool20000
03T0oooo0P000?nc0?ooo`00<03oool00`000000oooo0?ooo`0f0?ooo`80003o]@3oool00300oooo
00<000000?ooo`3oool0=03oool20000okL0oooo000`0?ooo`800000<`3oool20000okT0oooo000`
0?ooo`030000003oool0oooo0300oooo0P000?nk0?ooo`00<03oool200000300oooo00<0003o0?oo
o`3oool0^`3oool00300oooo00<000000?ooo`3oool0;@3oool20000okh0oooo000`0?ooo`800000
;03oool20000ol00oooo000`0?ooo`030000003oool0oooo02T0oooo0P000?o20?ooo`00<03oool2
000002P0oooo0P000?o40?ooo`00<03oool00`000000oooo0?ooo`0U0?ooo`80003oaP3oool000<0
oooo100000030?ooo`800000103oool2000000@0oooo0P0000040?ooo`800000103oool2000000@0
oooo00<000000?ooo`3oool01@3oool2000002D0oooo00<0003o0?ooo`3oool0aP3oool000D0oooo
00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool02@3oool300000280oooo0P000?o90?ooo`001@3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo0200oooo0P000?o;0?ooo`001@3oool01@000000oooo0?ooo`3o
ool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo01h0oooo0P000?o=0?ooo`001@3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo01`0oooo0P000?o?0?ooo`000`3oool3000000<0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01X0
oooo0P000?oA0?ooo`001@3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000@0oooo
0P0000040?ooo`800000103oool2000000`0oooo00<000000?ooo`3oool06@3oool00`000?l0oooo
0?ooo`3A0?ooo`00<03oool00`000000oooo0?ooo`0G0?ooo`80003oe03oool00300oooo00<00000
0?ooo`3oool05@3oool20000omH0oooo000`0?ooo`030000003oool0oooo01<0oooo0P000?oH0?oo
o`00<03oool200000180oooo0P000?oJ0?ooo`00<03oool00`000000oooo0?ooo`0?0?ooo`80003o
g03oool00300oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`3L0?ooo`00<03oool0
0`000000oooo0?ooo`0<0?ooo`80003og`3oool00300oooo00<000000?ooo`3oool02P3oool20000
on40oooo000`0?ooo`8000002@3oool20000on<0oooo000`0?ooo`030000003oool0oooo00H0oooo
0P000?oU0?ooo`00<03oool00`000000oooo0?ooo`040?ooo`80003oi`3oool00300oooo00<00000
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3W0?ooo`00<03oool200000>h0oooo000`0?ooo`03
0000003oool0oooo0>d0oooo000`0?ooo`030000003oool0oooo0>d0oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.73724, 0.180158, \
0.0135408, 0.0329309}}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[pu, pg, PlotRange \[Rule] All];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.29365 0.317462 -0.0845516 0.123773 [
[.0238 -0.00838 -20 -9.8125 ]
[.0238 -0.00838 20 0 ]
[.2457 -0.00838 -20 -9.8125 ]
[.2457 -0.00838 20 0 ]
[.34127 -0.00838 -17 -9.8125 ]
[.34127 -0.00838 17 0 ]
[.56316 -0.00838 -17 -9.8125 ]
[.56316 -0.00838 17 0 ]
[.65873 -0.00838 -14 -9.8125 ]
[.65873 -0.00838 14 0 ]
[.88062 -0.00838 -14 -9.8125 ]
[.88062 -0.00838 14 0 ]
[.97619 -0.00838 -11 -9.8125 ]
[.97619 -0.00838 11 0 ]
[-0.0125 .03922 -16 -4.90625 ]
[-0.0125 .03922 0 4.90625 ]
[-0.0125 .16299 -22 -4.90625 ]
[-0.0125 .16299 0 4.90625 ]
[-0.0125 .28677 -28 -4.90625 ]
[-0.0125 .28677 0 4.90625 ]
[-0.0125 .41054 -34 -4.90625 ]
[-0.0125 .41054 0 4.90625 ]
[-0.0125 .53431 -46 -4.90625 ]
[-0.0125 .53431 0 4.90625 ]
[ -0.0005 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0238 .00412 m
.0238 .01037 L
s
gsave
.0238 -0.00838 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2457 .00412 m
.2457 .01037 L
s
gsave
.2457 -0.00838 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0005) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34127 .00412 m
.34127 .01037 L
s
gsave
.34127 -0.00838 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.56316 .00412 m
.56316 .01037 L
s
gsave
.56316 -0.00838 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.005) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65873 .00412 m
.65873 .01037 L
s
gsave
.65873 -0.00838 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88062 .00412 m
.88062 .01037 L
s
gsave
.88062 -0.00838 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 .00412 m
.97619 .01037 L
s
gsave
.97619 -0.00838 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.11937 .00412 m
.11937 .00787 L
s
.17527 .00412 m
.17527 .00787 L
s
.21494 .00412 m
.21494 .00787 L
s
.27084 .00412 m
.27084 .00787 L
s
.29209 .00412 m
.29209 .00787 L
s
.3105 .00412 m
.3105 .00787 L
s
.32674 .00412 m
.32674 .00787 L
s
.43683 .00412 m
.43683 .00787 L
s
.49273 .00412 m
.49273 .00787 L
s
.5324 .00412 m
.5324 .00787 L
s
.5883 .00412 m
.5883 .00787 L
s
.60955 .00412 m
.60955 .00787 L
s
.62796 .00412 m
.62796 .00787 L
s
.6442 .00412 m
.6442 .00787 L
s
.75429 .00412 m
.75429 .00787 L
s
.8102 .00412 m
.8102 .00787 L
s
.84986 .00412 m
.84986 .00787 L
s
.90576 .00412 m
.90576 .00787 L
s
.92701 .00412 m
.92701 .00787 L
s
.94543 .00412 m
.94543 .00787 L
s
.96166 .00412 m
.96166 .00787 L
s
.25 Mabswid
0 .00412 m
1 .00412 L
s
0 .03922 m
.00625 .03922 L
s
gsave
-0.0125 .03922 -77 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .16299 m
.00625 .16299 L
s
gsave
-0.0125 .16299 -83 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .28677 m
.00625 .28677 L
s
gsave
-0.0125 .28677 -89 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1000) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .41054 m
.00625 .41054 L
s
gsave
-0.0125 .41054 -95 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10000) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .53431 m
.00625 .53431 L
s
gsave
-0.0125 .53431 -107 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100000.) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
0 .07648 m
.00375 .07648 L
s
0 .09828 m
.00375 .09828 L
s
0 .11374 m
.00375 .11374 L
s
0 .12573 m
.00375 .12573 L
s
0 .13553 m
.00375 .13553 L
s
0 .14382 m
.00375 .14382 L
s
0 .151 m
.00375 .151 L
s
0 .15733 m
.00375 .15733 L
s
0 .20025 m
.00375 .20025 L
s
0 .22205 m
.00375 .22205 L
s
0 .23751 m
.00375 .23751 L
s
0 .24951 m
.00375 .24951 L
s
0 .25931 m
.00375 .25931 L
s
0 .26759 m
.00375 .26759 L
s
0 .27477 m
.00375 .27477 L
s
0 .2811 m
.00375 .2811 L
s
0 .32403 m
.00375 .32403 L
s
0 .34582 m
.00375 .34582 L
s
0 .36128 m
.00375 .36128 L
s
0 .37328 m
.00375 .37328 L
s
0 .38308 m
.00375 .38308 L
s
0 .39137 m
.00375 .39137 L
s
0 .39854 m
.00375 .39854 L
s
0 .40487 m
.00375 .40487 L
s
0 .4478 m
.00375 .4478 L
s
0 .46959 m
.00375 .46959 L
s
0 .48506 m
.00375 .48506 L
s
0 .49705 m
.00375 .49705 L
s
0 .50685 m
.00375 .50685 L
s
0 .51514 m
.00375 .51514 L
s
0 .52232 m
.00375 .52232 L
s
0 .52865 m
.00375 .52865 L
s
0 .57157 m
.00375 .57157 L
s
0 .59337 m
.00375 .59337 L
s
0 .60883 m
.00375 .60883 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
1 0 0 r
.5 Mabswid
.02381 .43855 m
.53756 .19382 L
.63749 .1488 L
.69193 .12568 L
.72956 .10828 L
.76079 .09688 L
.78536 .08869 L
.80742 .07834 L
.81229 .07549 L
.81488 .07387 L
.81614 .07305 L
.81668 .07269 L
.81727 .0723 L
.81781 .0721 L
.8183 .072 L
.81927 .07179 L
.82139 .07134 L
.82578 .07037 L
.8414 .06647 L
.85568 .06219 L
.86939 .05723 L
.88142 .05197 L
.89208 .04638 L
.89457 .04492 L
.89592 .0441 L
.89624 .0439 L
.89658 .04369 L
.89687 .04353 L
.89719 .04346 L
.8979 .04331 L
.89867 .04315 L
.90001 .04286 L
.90259 .0423 L
.912 .04009 L
.92096 .03775 L
.92907 .0354 L
.9372 .03277 L
.9446 .03012 L
.95136 .02744 L
.95821 .02443 L
.9645 .02137 L
.97088 .01791 L
.97619 .01472 L
s
0 0 1 r
.02381 .60332 m
.53756 .34098 L
.63749 .28496 L
.69193 .25337 L
.72956 .22775 L
.76079 .20996 L
.78536 .19716 L
.79714 .18862 L
.80742 .17907 L
.81169 .17429 L
.81613 .16863 L
.81674 .16779 L
.81707 .16734 L
.81741 .16685 L
.81774 .16669 L
.81804 .16659 L
.81861 .1664 L
.82085 .16564 L
.82513 .16413 L
.83345 .16092 L
.84176 .15729 L
.85633 .1496 L
.86902 .141 L
.88136 .13003 L
.89227 .11682 L
.89496 .1128 L
.89559 .1118 L
.89626 .11071 L
.89653 .11026 L
.89683 .10977 L
.89715 .10966 L
.89745 .10955 L
.89966 .10876 L
.90201 .10789 L
.90676 .10603 L
.91168 .10398 L
.92087 .09968 L
.92917 .09519 L
.93671 .09049 L
.94431 .08499 L
.95125 .07911 L
.95826 .07205 L
.96469 .06425 L
.97061 .05549 L
.97619 .04521 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`009P3oool2000000@0oooo00<0
00000?ooo`3oool00`3oool2000000@0oooo0P0000040?ooo`8000000`3oool4000001<0oooo0P00
00040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000103oool300000080oooo0`00
00050?ooo`800000103oool2000000<0oooo1000000H0?ooo`800000103oool00`000000oooo0?oo
o`030?ooo`800000103oool2000000<0oooo1@0000040?ooo`030000003oool0oooo00<0oooo0P00
00030?ooo`@000007P3oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000<0oooo0`00
00060?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@00000103oool002D0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0A0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`800000
00<0oooo000000000000103oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01H0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo
0P0000000`3oool000000?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool0703oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo000U
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool04@3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool2000000030?ooo`000000000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000040?ooo`80000000<0oooo0000003oool01`3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo01`0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?oo
o`030?ooo`009@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0140oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000080oooo0P000000103oool000000000003oool3000000@0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo01H0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo0`0000020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`0L0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool3000000D0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`009@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0140oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo0P0000001@3oool000000000003oool0000000H0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool0703oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool01@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0
oooo000U0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`00000C0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`80000000D0oooo000000000000oooo000000060?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool3000001P0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`060?ooo`040000003oool0oooo00000080oooo0`00000N0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo000000P0oooo0`0000050?ooo`009P3oool2000000X0oooo0P0000040?ooo`80
0000103oool2000000D0oooo00<000000?ooo`3oool04P3oool2000000X0oooo0P0000040?ooo`80
0000103oool300000080oooo100000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3o
ool05`3oool2000000X0oooo0P0000040?ooo`8000000`3oool5000000X0oooo0P0000050?ooo`03
0000003oool0oooo01d0oooo0P00000:0?ooo`8000000`3oool4000000D0oooo0P00000;0?ooo`03
0000003oool0oooo00<0oooo003o0?ooob40oooo000`0?ooo`030000003oool0oooo0>d0oooo000`
0?ooonX000001P3oool00300oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000005@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000002`3oool00300
oooo00<000000?ooo`3oool0h03oool20?l000/0oooo000`0?ooo`030000003oool0oooo0=l0oooo
00<0o`000?ooo`3oool02`3oool00300oooo00<000000?ooo`3oool0g@3oool20?l000h0oooo000`
0?ooo`030000003oool0oooo0=X0oooo0`3o000@0?ooo`00<03oool00`000000oooo0?ooo`3H0?oo
o`80o`004`3oool00240oooo100000030?ooo`8000001P3oool00`000000oooo0?ooo`3E0?ooo`<0
o`005@3oool002<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0
oooo0`00003A0?ooo`@0o`00603oool002<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0cP3oool30?l001`0oooo000S0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0<`0
oooo0P3o000C0?ooo`030000o`3oool0oooo00T0oooo000S0?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0<T0oooo0`3o000D0?ooo`03
0000o`3oool0oooo00X0oooo000Q0?ooo`<000000`3oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0oooo0<H0oooo0`3o000F0?ooo`030000o`3oool0oooo00/0oooo000S0?ooo`030000
003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0<<0oooo0`3o000I0?ooo`030000
o`3oool0oooo00/0oooo000`0?ooo`030000003oool0oooo0<00oooo0`3o000K0?ooo`030000o`3o
ool0oooo00`0oooo000`0?ooo`030000003oool0oooo0;d0oooo0`3o000M0?ooo`030000o`3oool0
oooo00d0oooo000`0?ooo`030000003oool0oooo0;/0oooo0P3o000O0?ooo`030000o`3oool0oooo
00h0oooo000`0?ooo`800000^P3oool20?l00200oooo00<0003o0?ooo`3oool03`3oool00300oooo
00<000000?ooo`3oool0]`3oool20?l00240oooo00<0003o0?ooo`3oool0403oool00300oooo00<0
00000?ooo`3oool0]@3oool20?l00240oooo0P000?lC0?ooo`00<03oool00`000000oooo0?ooo`2c
0?ooo`80o`008P3oool00`000?l0oooo0?ooo`0C0?ooo`00<03oool00`000000oooo0?ooo`2`0?oo
o`<0o`008P3oool20000oaH0oooo000`0?ooo`800000[P3oool30?l002<0oooo0P000?lH0?ooo`00
<03oool00`000000oooo0?ooo`2Y0?ooo`@0o`00903oool20000oaX0oooo000`0?ooo`030000003o
ool0oooo0:H0oooo0`3o000V0?ooo`80003o703oool00300oooo0P00002U0?ooo`80o`00:03oool0
0`000?l0oooo0?ooo`0L0?ooo`00<03oool00`000000oooo0?ooo`2R0?ooo`80o`00:@3oool00`00
0?l0oooo0?ooo`0M0?ooo`00<03oool00`000000oooo0?ooo`2P0?ooo`80o`00:P3oool00`000?l0
oooo0?ooo`0N0?ooo`00<03oool2000009h0oooo0`3o000[0?ooo`030000o`3oool0oooo01l0oooo
000`0?ooo`030000003oool0oooo09/0oooo0P3o000]0?ooo`030000o`3oool0oooo0200oooo000`
0?ooo`030000003oool0oooo09T0oooo0P3o000^0?ooo`030000o`3oool0oooo0240oooo000`0?oo
o`800000V03oool20?l00300oooo00<0003o0?ooo`3oool08@3oool00300oooo0P00002F0?ooo`80
o`00<@3oool00`000?l0oooo0?ooo`0R0?ooo`00<03oool00`000000oooo0?ooo`2C0?ooo`80o`00
<@3oool20000obD0oooo000`0?ooo`800000TP3oool20?l00340oooo0P000?lW0?ooo`00<03oool0
0`000000oooo0?ooo`2?0?ooo`80o`00<@3oool20000obT0oooo000K0?ooo`@000000`3oool20000
00@0oooo0P0000060?ooo`800000S@3oool30?l002l0oooo10000?l[0?ooo`007@3oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`<00000RP3oool20?l00340oooo00<0003o0?ooo`3oool0;@3oool001d0oooo00D000000?oo
o`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`280?ooo`80o`00<@3oool20000oc00oooo000M0?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0Q@3oool30?l003<0oooo00<0003o0?ooo`3oool0;`3oool001d0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`230?ooo`80o`00=@3oool00`000?l0oooo0?ooo`0`0?ooo`00
6`3oool3000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?oo
o`030000003oool0oooo0800oooo0`3o000f0?ooo`030000o`3oool0oooo0340oooo000M0?ooo`03
0000003oool0oooo0080oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`1n0?ooo`80
o`00>03oool00`000?l0oooo0?ooo`0b0?ooo`00<03oool00`000000oooo0?ooo`1l0?ooo`80o`00
>@3oool00`000?l0oooo0?ooo`0c0?ooo`00<03oool00`000000oooo0?ooo`1i0?ooo`<0o`00>@3o
ool20000ocH0oooo000`0?ooo`030000003oool0oooo07L0oooo0P3o000j0?ooo`80003o>03oool0
0300oooo0P00001f0?ooo`80o`00>P3oool20000ocX0oooo000`0?ooo`030000003oool0oooo07<0
oooo0P3o000j0?ooo`80003o?03oool00300oooo00<000000?ooo`3oool0L@3oool20?l003/0oooo
00<0003o0?ooo`3oool0?03oool00300oooo00<000000?ooo`3oool0K`3oool20?l003/0oooo0P00
0?lo0?ooo`00<03oool00`000000oooo0?ooo`1]0?ooo`80o`00>`3oool20000od40oooo000`0?oo
o`800000K03oool20?l003/0oooo0P000?m30?ooo`00<03oool00`000000oooo0?ooo`1Y0?ooo`80
o`00?03oool00`000?l0oooo0?ooo`130?ooo`00<03oool00`000000oooo0?ooo`1W0?ooo`80o`00
?03oool20000odH0oooo000`0?ooo`800000IP3oool20?l003d0oooo00<0003o0?ooo`3oool0AP3o
ool00300oooo00<000000?ooo`3oool0HP3oool30?l003d0oooo0P000?m90?ooo`00<03oool00`00
0000oooo0?ooo`1P0?ooo`80o`00?`3oool00`000?l0oooo0?ooo`190?ooo`00<03oool2000005l0
oooo0P3o000o0?ooo`80003oC03oool00300oooo00<000000?ooo`3oool0G03oool20?l00400oooo
00<0003o0?ooo`3oool0C03oool00300oooo0P00001K0?ooo`80o`00@03oool20000odl0oooo000`
0?ooo`030000003oool0oooo05P0oooo0P3o00100?ooo`80003oD@3oool00300oooo0P00001G0?oo
o`80o`00@03oool20000oe<0oooo000`0?ooo`030000003oool0oooo05@0oooo0P3o00110?ooo`03
0000o`3oool0oooo05<0oooo000`0?ooo`800000D`3oool20?l00440oooo0P000?mF0?ooo`005@3o
ool4000000<0oooo0P0000040?ooo`800000103oool2000000H0oooo0P00001A0?ooo`80o`00@@3o
ool20000oeP0oooo000G0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1>0?ooo`80o`00@P3oool00`000?l0oooo0?ooo`1H0?ooo`005`3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<0oooo0`00001<0?ooo`80o`00@P3oool20000oe/0oooo000G0?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`<0o`00
@P3oool20000oed0oooo000G0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`170?ooo`80o`00@`3oool20000oel0oooo000E0?ooo`<000000`3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3o
ool00`000000oooo0?ooo`150?ooo`80o`00@`3oool20000of40oooo000G0?ooo`030000003oool0
oooo0080oooo0P0000040?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0@`3oool2
0?l004<0oooo0P000?mS0?ooo`00<03oool00`000000oooo0?ooo`110?ooo`80o`00@`3oool20000
ofD0oooo000`0?ooo`030000003oool0oooo03l0oooo0P3o00140?ooo`030000o`3oool0oooo06D0
oooo000`0?ooo`030000003oool0oooo03d0oooo0P3o00140?ooo`80003oJ03oool00300oooo0P00
000l0?ooo`80o`00A03oool20000ofX0oooo000`0?ooo`030000003oool0oooo03T0oooo0P3o0014
0?ooo`80003oK03oool00300oooo00<000000?ooo`3oool0=`3oool20?l004@0oooo0P000?m^0?oo
o`00<03oool00`000000oooo0?ooo`0e0?ooo`80o`00A03oool20000og00oooo000`0?ooo`030000
003oool0oooo0380oooo0`3o00150?ooo`030000o`3oool0oooo0700oooo000`0?ooo`800000<@3o
ool20?l004H0oooo0P000?mc0?ooo`00<03oool00`000000oooo0?ooo`0^0?ooo`80o`00AP3oool2
0000ogD0oooo000`0?ooo`030000003oool0oooo02`0oooo0P3o00160?ooo`80003oM`3oool00300
oooo00<000000?ooo`3oool0:P3oool20?l004H0oooo0P000?mi0?ooo`00<03oool2000002T0oooo
0P3o00160?ooo`80003oN`3oool00300oooo00<000000?ooo`3oool09P3oool20?l004H0oooo0P00
0?mm0?ooo`00<03oool00`000000oooo0?ooo`0T0?ooo`80o`00AP3oool20000ogl0oooo000`0?oo
o`8000008`3oool20?l004H0oooo0P000?n10?ooo`00<03oool00`000000oooo0?ooo`0P0?ooo`80
o`00AP3oool20000oh<0oooo000`0?ooo`8000007`3oool20?l004H0oooo0P000?n50?ooo`00<03o
ool00`000000oooo0?ooo`0L0?ooo`80o`00AP3oool20000ohL0oooo000`0?ooo`8000006P3oool3
0?l004H0oooo0P000?n90?ooo`00<03oool00`000000oooo0?ooo`0G0?ooo`80o`00A`3oool20000
oh/0oooo000`0?ooo`8000005P3oool20?l004L0oooo0P000?n=0?ooo`003`3oool4000000<0oooo
0P0000040?ooo`800000103oool2000000@0oooo0P0000060?ooo`800000503oool20?l004L0oooo
0P000?n?0?ooo`004@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`80o`00A`3oool20000oi40oooo000A0?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`<0
00003`3oool20?l004L0oooo0P000?nC0?ooo`004@3oool01@000000oooo0?ooo`3oool000000080
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`80o`00A`3o
ool20000oiD0oooo000A0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo0P3o00170?ooo`80003oU`3oool000l0
oooo0`0000030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
2@3oool20?l004P0oooo00<0003o0?ooo`3oool0U`3oool00140oooo00<000000?ooo`3oool00P3o
ool2000000@0oooo0P0000040?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool01`3o
ool20?l004P0oooo0P000?nJ0?ooo`00<03oool00`000000oooo0?ooo`050?ooo`80o`00B03oool2
0000oi`0oooo000`0?ooo`030000003oool0oooo00<0oooo0P3o00180?ooo`80003oWP3oool00300
oooo00<000000?ooo`3oool0B`3oool20000oj00oooo000`0?ooo`800000BP3oool20000oj80oooo
000`0?ooo`030000003oool0oooo04L0oooo0P000?nT0?ooo`00<03oool00`000000oooo0?ooo`15
0?ooo`80003oYP3oool00300oooo00<000000?ooo`3oool0@`3oool20000ojP0oooo000`0?ooo`03
0000003oool0oooo0440oooo0P000?nZ0?ooo`00<03oool200000400oooo0P000?n/0?ooo`00<03o
ool00`000000oooo0?ooo`0m0?ooo`80003o[P3oool00300oooo00<000000?ooo`3oool0>`3oool2
0000ok00oooo000`0?ooo`030000003oool0oooo03T0oooo0P000?nb0?ooo`00<03oool2000003P0
oooo0P000?nd0?ooo`00<03oool00`000000oooo0?ooo`0e0?ooo`80003o]P3oool00300oooo00<0
00000?ooo`3oool0<`3oool20000okP0oooo000`0?ooo`800000<P3oool20000okX0oooo000`0?oo
o`030000003oool0oooo02l0oooo0P000?nl0?ooo`00<03oool2000002h0oooo0P000?nn0?ooo`00
<03oool00`000000oooo0?ooo`0[0?ooo`80003o`03oool00300oooo0P00000[0?ooo`030000o`3o
ool0oooo0<00oooo000`0?ooo`030000003oool0oooo02P0oooo0P000?o30?ooo`00<03oool20000
02L0oooo0P000?o50?ooo`000`3oool4000000<0oooo0P0000040?ooo`800000103oool2000000@0
oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`050?ooo`8000009@3oool20000olL0
oooo00050?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00T0oooo0`00000R0?ooo`80003ob@3oool000D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0P0?ooo`80003ob`3oool000D0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0N0?ooo`80003oc@3oool000D0oooo00D000000?oo
o`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0L0?ooo`80003oc`3oool000<0oooo0`0000030?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`0J0?ooo`80003od@3oool000D0oooo00<000000?ooo`3oool00P3oool2000000@0oooo
0P0000040?ooo`800000103oool2000000@0oooo0P00000<0?ooo`030000003oool0oooo01P0oooo
0P000?oC0?ooo`00<03oool00`000000oooo0?ooo`0F0?ooo`80003oe@3oool00300oooo00<00000
0?ooo`3oool0503oool20000omL0oooo000`0?ooo`030000003oool0oooo0180oooo0P000?oI0?oo
o`00<03oool200000140oooo0P000?oK0?ooo`00<03oool00`000000oooo0?ooo`0>0?ooo`80003o
g@3oool00300oooo00<000000?ooo`3oool0303oool20000oml0oooo000`0?ooo`030000003oool0
oooo00X0oooo0P000?oQ0?ooo`00<03oool00`000000oooo0?ooo`080?ooo`80003oh`3oool00300
oooo0P0000070?ooo`80003oi@3oool00300oooo00<000000?ooo`3oool0103oool20000onL0oooo
000`0?ooo`030000003oool0oooo00<0oooo00<0003o0?ooo`3oool0i`3oool00300oooo00<00000
0?ooo`3oool0k@3oool00300oooo0P00003^0?ooo`00<03oool00`000000oooo0?ooo`3]0?ooo`00
<03oool00`000000oooo0?ooo`3]0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.73724, -0.0970653, \
0.0135408, 0.0347305}}]
}, Open  ]],

Cell["Compare Up & Down", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u/d\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{1.0047883630894567`, 1.0073486093748993`, 
      1.0112589114761816`, 1.0171772992395502`, 1.026022023896971`, 
      1.0391096788745335`, 1.0580538659544956`, 1.0850610587314518`, 
      1.1234443603240039`, 1.1790840572492036`, 1.2628587209782063`, 
      1.3897924959869299`, 1.5795454362832413`}\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \({xlist, u/d}\  // Transpose\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.0001`", "1.0047883630894567`"},
            {"0.00017782794100389227`", "1.0073486093748993`"},
            {"0.00031622776601683794`", "1.0112589114761816`"},
            {"0.0005623413251903491`", "1.0171772992395502`"},
            {"0.001`", "1.026022023896971`"},
            {"0.0017782794100389228`", "1.0391096788745335`"},
            {"0.0031622776601683794`", "1.0580538659544956`"},
            {"0.005623413251903491`", "1.0850610587314518`"},
            {"0.01`", "1.1234443603240039`"},
            {"0.017782794100389226`", "1.1790840572492036`"},
            {"0.0316227766016838`", "1.2628587209782063`"},
            {"0.05623413251903491`", "1.3897924959869299`"},
            {"0.1`", "1.5795454362832413`"}
            },
          ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LogLinearListPlot[{xlist, u/d}\  // Transpose, 
      PlotJoined \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.29365 0.31746 -1.01428 1.02409 [
[.02381 -0.0125 -20 -9.8125 ]
[.02381 -0.0125 20 0 ]
[.2457 -0.0125 -20 -9.8125 ]
[.2457 -0.0125 20 0 ]
[.34127 -0.0125 -17 -9.8125 ]
[.34127 -0.0125 17 0 ]
[.56317 -0.0125 -17 -9.8125 ]
[.56317 -0.0125 17 0 ]
[.65873 -0.0125 -14 -9.8125 ]
[.65873 -0.0125 14 0 ]
[.88063 -0.0125 -14 -9.8125 ]
[.88063 -0.0125 14 0 ]
[.97619 -0.0125 -11 -9.8125 ]
[.97619 -0.0125 11 0 ]
[-0.0125 .00981 -6 -4.5 ]
[-0.0125 .00981 0 4.5 ]
[-0.0125 .11222 -18 -4.5 ]
[-0.0125 .11222 0 4.5 ]
[-0.0125 .21463 -18 -4.5 ]
[-0.0125 .21463 0 4.5 ]
[-0.0125 .31704 -18 -4.5 ]
[-0.0125 .31704 0 4.5 ]
[-0.0125 .41945 -18 -4.5 ]
[-0.0125 .41945 0 4.5 ]
[-0.0125 .52186 -18 -4.5 ]
[-0.0125 .52186 0 4.5 ]
[ 0 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
gsave
.02381 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2457 0 m
.2457 .00625 L
s
gsave
.2457 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0005) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.56317 0 m
.56317 .00625 L
s
gsave
.56317 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.005) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65873 0 m
.65873 .00625 L
s
gsave
.65873 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88063 0 m
.88063 .00625 L
s
gsave
.88063 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.11937 0 m
.11937 .00375 L
s
.17528 0 m
.17528 .00375 L
s
.21494 0 m
.21494 .00375 L
s
.27084 0 m
.27084 .00375 L
s
.29209 0 m
.29209 .00375 L
s
.3105 0 m
.3105 .00375 L
s
.32674 0 m
.32674 .00375 L
s
.43683 0 m
.43683 .00375 L
s
.49274 0 m
.49274 .00375 L
s
.5324 0 m
.5324 .00375 L
s
.5883 0 m
.5883 .00375 L
s
.60955 0 m
.60955 .00375 L
s
.62797 0 m
.62797 .00375 L
s
.6442 0 m
.6442 .00375 L
s
.7543 0 m
.7543 .00375 L
s
.8102 0 m
.8102 .00375 L
s
.84986 0 m
.84986 .00375 L
s
.90576 0 m
.90576 .00375 L
s
.92702 0 m
.92702 .00375 L
s
.94543 0 m
.94543 .00375 L
s
.96166 0 m
.96166 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00981 m
.00625 .00981 L
s
[(1)] -0.0125 .00981 1 0 Mshowa
0 .11222 m
.00625 .11222 L
s
[(1.1)] -0.0125 .11222 1 0 Mshowa
0 .21463 m
.00625 .21463 L
s
[(1.2)] -0.0125 .21463 1 0 Mshowa
0 .31704 m
.00625 .31704 L
s
[(1.3)] -0.0125 .31704 1 0 Mshowa
0 .41945 m
.00625 .41945 L
s
[(1.4)] -0.0125 .41945 1 0 Mshowa
0 .52186 m
.00625 .52186 L
s
[(1.5)] -0.0125 .52186 1 0 Mshowa
.125 Mabswid
0 .03029 m
.00375 .03029 L
s
0 .05078 m
.00375 .05078 L
s
0 .07126 m
.00375 .07126 L
s
0 .09174 m
.00375 .09174 L
s
0 .1327 m
.00375 .1327 L
s
0 .15318 m
.00375 .15318 L
s
0 .17367 m
.00375 .17367 L
s
0 .19415 m
.00375 .19415 L
s
0 .23511 m
.00375 .23511 L
s
0 .25559 m
.00375 .25559 L
s
0 .27608 m
.00375 .27608 L
s
0 .29656 m
.00375 .29656 L
s
0 .33752 m
.00375 .33752 L
s
0 .358 m
.00375 .358 L
s
0 .37848 m
.00375 .37848 L
s
0 .39897 m
.00375 .39897 L
s
0 .43993 m
.00375 .43993 L
s
0 .46041 m
.00375 .46041 L
s
0 .48089 m
.00375 .48089 L
s
0 .50138 m
.00375 .50138 L
s
0 .54234 m
.00375 .54234 L
s
0 .56282 m
.00375 .56282 L
s
0 .5833 m
.00375 .5833 L
s
0 .60378 m
.00375 .60378 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.10317 .01734 L
.18254 .02134 L
.2619 .0274 L
.34127 .03646 L
.42063 .04986 L
.5 .06926 L
.57937 .09692 L
.65873 .13623 L
.7381 .19321 L
.81746 .279 L
.89683 .40899 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`002`3oool2000000@0oooo00<0
00000?ooo`3oool00`3oool2000000@0oooo0P0000040?ooo`8000000`3oool4000001T0oooo0P00
00040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000103oool200000080oooo1000
00020?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool4000001l0oooo0P00
00040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool300000080oooo0P00
00040?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`@000009@3oool2000000@0oooo00<0
00000?ooo`3oool00`3oool2000000<0oooo0`0000080?ooo`800000103oool00`000000oooo0?oo
o`020?ooo`@00000103oool000X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`0G0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo008000000P3oool00`000000oooo
000000060?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`0M0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000050?ooo`8000000P3oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool08`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo00<0oooo000:0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool05`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0200000080oooo
00<000000?ooo`0000001P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000001@3oool200000080oooo00<000000?ooo`3oool0
1P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00@0oooo00@00000
0?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`002P3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo01L0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
0P000000103oool000000000000000070?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`0M0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`<0000000D0oooo0000003o
ool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool08`3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo0`0000070?ooo`040000
003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool000X0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
0080000000<0oooo000000000000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo02<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00L0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?oo
o`002P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`<000006@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`02000000030?ooo`000000000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`<000007`3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000020?ooo`<00000
9@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool01`3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool000/0oooo0P00000:0?oo
o`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo01P0oooo0P00000:0?oo
o`800000103oool2000000@0oooo0P0000020?ooo`D000001`3oool2000000@0oooo0P0000050?oo
o`030000003oool0oooo01h0oooo0P00000:0?ooo`800000103oool2000000<0oooo100000000`3o
ool000000000000:0?ooo`8000001@3oool00`000000oooo0?ooo`0T0?ooo`8000002P3oool20000
00<0oooo100000070?ooo`8000002`3oool00`000000oooo0?ooo`030?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`003@3oool4000000@0ooooo`000007000000D0oooo000?0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0
oooo0000000;0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo
0?ooo`0g0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=`3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`090?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo2@3o
ool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oooal00000iP3oool0
00d0oooo0`0000050?ooo`030000003oool0oooo0280oooo4000003F0?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0380oooo2P00003<0?ooo`005@3oool00`000000oooo
0?ooo`0l0?ooo`/00000`@3oool001D0oooo0P0000180?ooo`X00000]`3oool001D0oooo00<00000
0?ooo`3oool0D@3oool800000:l0oooo000E0?ooo`030000003oool0oooo05T0oooo1@00002Z0?oo
o`005@3oool00`000000oooo0?ooo`1N0?ooo`H00000Y03oool001D0oooo00<000000?ooo`3oool0
I03oool5000009l0oooo000E0?ooo`800000JP3oool4000009/0oooo000E0?ooo`030000003oool0
oooo06d0oooo1000002G0?ooo`005@3oool00`000000oooo0?ooo`1a0?ooo`@00000T`3oool001D0
oooo00<000000?ooo`3oool0M@3oool4000008l0oooo000E0?ooo`030000003oool0oooo07T0oooo
1000002;0?ooo`005@3oool00`000000oooo0?ooo`1m0?ooo`@00000Q`3oool001D0oooo0P000022
0?ooo`<00000Q03oool001D0oooo00<000000?ooo`3oool0Q03oool300000840oooo000E0?ooo`03
0000003oool0oooo08L0oooo0`00001n0?ooo`005@3oool00`000000oooo0?ooo`2:0?ooo`<00000
N`3oool001D0oooo00<000000?ooo`3oool0S@3oool3000007P0oooo000E0?ooo`800000T@3oool3
000007D0oooo000E0?ooo`030000003oool0oooo09<0oooo0`00001b0?ooo`005@3oool00`000000
oooo0?ooo`2F0?ooo`800000L03oool000030?ooo`0000000000008000000`3oool00`000000oooo
0?ooo`020?ooo`@00000103oool00`000000oooo0?ooo`2H0?ooo`800000KP3oool000<0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo09X0oooo0P00
001/0?ooo`000`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo0P00002M
0?ooo`800000JP3oool000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo09h0oooo0P00001X0?ooo`000`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0X03oool2000006H0oooo0000103oool00000
0000000000090?ooo`<000001@3oool00`000000oooo0?ooo`2R0?ooo`800000I03oool000<0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0:@0oooo
0P00001R0?ooo`005@3oool00`000000oooo0?ooo`2V0?ooo`800000H03oool001D0oooo0P00002Y
0?ooo`800000GP3oool001D0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`1K0?oo
o`005@3oool00`000000oooo0?ooo`2[0?ooo`800000F`3oool001D0oooo00<000000?ooo`3oool0
[@3oool00`000000oooo0?ooo`1H0?ooo`005@3oool00`000000oooo0?ooo`2^0?ooo`030000003o
ool0oooo05L0oooo000E0?ooo`800000/03oool2000005L0oooo000E0?ooo`030000003oool0oooo
0;40oooo00<000000?ooo`3oool0E03oool001D0oooo00<000000?ooo`3oool0/P3oool00`000000
oooo0?ooo`1C0?ooo`005@3oool00`000000oooo0?ooo`2c0?ooo`800000D`3oool001D0oooo00<0
00000?ooo`3oool0]@3oool00`000000oooo0?ooo`1@0?ooo`005@3oool200000;L0oooo00<00000
0?ooo`3oool0C`3oool001D0oooo00<000000?ooo`3oool0]`3oool2000004l0oooo000E0?ooo`03
0000003oool0oooo0;T0oooo00<000000?ooo`3oool0C03oool001D0oooo00<000000?ooo`3oool0
^P3oool00`000000oooo0?ooo`1;0?ooo`005@3oool00`000000oooo0?ooo`2k0?ooo`800000B`3o
ool001D0oooo00<000000?ooo`3oool0_@3oool00`000000oooo0?ooo`180?ooo`005@3oool20000
0;l0oooo00<000000?ooo`3oool0A`3oool001D0oooo00<000000?ooo`3oool0_`3oool00`000000
oooo0?ooo`160?ooo`005@3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo04D0oooo
00000`3oool0000000000002000000<0oooo00<000000?ooo`3oool00P3oool4000000@0oooo00<0
00000?ooo`3oool0`@3oool00`000000oooo0?ooo`140?ooo`000`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`13
0?ooo`000`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo0P0000330?oo
o`030000003oool0oooo04<0oooo00030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`330?ooo`030000003oool0oooo0480oooo00030?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`340?ooo`030000
003oool0oooo0440oooo0000103oool000000000000000090?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?ooo`100?ooo`000`3oool00`000000oooo
0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo03l0oooo
000E0?ooo`800000b03oool00`000000oooo0?ooo`0n0?ooo`005@3oool00`000000oooo0?ooo`38
0?ooo`030000003oool0oooo03d0oooo000E0?ooo`030000003oool0oooo0<T0oooo00<000000?oo
o`3oool0?03oool001D0oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`0k0?ooo`00
5@3oool00`000000oooo0?ooo`3;0?ooo`030000003oool0oooo03X0oooo000E0?ooo`030000003o
ool0oooo0<`0oooo00<000000?ooo`3oool0>@3oool001D0oooo0P00003>0?ooo`030000003oool0
oooo03P0oooo000E0?ooo`030000003oool0oooo0<d0oooo00<000000?ooo`3oool0>03oool001D0
oooo00<000000?ooo`3oool0cP3oool00`000000oooo0?ooo`0g0?ooo`005@3oool00`000000oooo
0?ooo`3?0?ooo`030000003oool0oooo03H0oooo000E0?ooo`030000003oool0oooo0=00oooo00<0
00000?ooo`3oool0=@3oool001D0oooo0P00003B0?ooo`030000003oool0oooo03@0oooo000E0?oo
o`030000003oool0oooo0=80oooo00<000000?ooo`3oool0<`3oool001D0oooo00<000000?ooo`3o
ool0d`3oool00`000000oooo0?ooo`0b0?ooo`005@3oool00`000000oooo0?ooo`3C0?ooo`030000
003oool0oooo0380oooo000E0?ooo`030000003oool0oooo0=@0oooo00<000000?ooo`3oool0<@3o
ool001D0oooo0P00003E0?ooo`030000003oool0oooo0340oooo000E0?ooo`030000003oool0oooo
0=D0oooo00<000000?ooo`3oool0<03oool001D0oooo00<000000?ooo`3oool0eP3oool00`000000
oooo0?ooo`0_0?ooo`005@3oool00`000000oooo0?ooo`3F0?ooo`030000003oool0oooo02l0oooo
00000`3oool0000000000002000000<0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<0
00000?ooo`3oool0e`3oool00`000000oooo0?ooo`0^0?ooo`000`3oool00`000000oooo0?ooo`07
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0f03oool00`000000oooo0?oo
o`0]0?ooo`000`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P00003I
0?ooo`030000003oool0oooo02d0oooo00030?ooo`030000003oool0oooo00P0oooo0P0000050?oo
o`030000003oool0oooo0=T0oooo00<000000?ooo`3oool0;03oool000<0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0=T0oooo00<000000?ooo`3o
ool0;03oool000040?ooo`0000000000000000T0oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`3J0?ooo`030000003oool0oooo02/0oooo00030?ooo`030000003oool0oooo00P0
oooo0P0000050?ooo`030000003oool0oooo0=/0oooo00<000000?ooo`3oool0:P3oool001D0oooo
0P00003L0?ooo`030000003oool0oooo02X0oooo000E0?ooo`030000003oool0oooo0=`0oooo00<0
00000?ooo`3oool0:@3oool001D0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`0Y
0?ooo`005@3oool00`000000oooo0?ooo`3M0?ooo`030000003oool0oooo02P0oooo000E0?ooo`03
0000003oool0oooo0=h0oooo00<000000?ooo`3oool09`3oool001D0oooo0P00003O0?ooo`030000
003oool0oooo02L0oooo000E0?ooo`030000003oool0oooo0=l0oooo00<000000?ooo`3oool09P3o
ool001D0oooo00<000000?ooo`3oool0h03oool00`000000oooo0?ooo`0U0?ooo`005@3oool00`00
0000oooo0?ooo`3P0?ooo`030000003oool0oooo02D0oooo000E0?ooo`030000003oool0oooo0>40
oooo00<000000?ooo`3oool0903oool001D0oooo00<000000?ooo`3oool0h@3oool00`000000oooo
0?ooo`0T0?ooo`005@3oool200000><0oooo00<000000?ooo`3oool08`3oool001D0oooo00<00000
0?ooo`3oool0h`3oool00`000000oooo0?ooo`0R0?ooo`005@3oool00`000000oooo0?ooo`3S0?oo
o`030000003oool0oooo0280oooo000E0?ooo`030000003oool0oooo0>@0oooo00<000000?ooo`3o
ool08@3oool001D0oooo00<000000?ooo`3oool0i@3oool00`000000oooo0?ooo`0P0?ooo`005@3o
ool200000>H0oooo00<000000?ooo`3oool0803oool001D0oooo00<000000?ooo`3oool0iP3oool0
0`000000oooo0?ooo`0O0?ooo`005@3oool00`000000oooo0?ooo`3V0?ooo`030000003oool0oooo
01l0oooo00000`3oool0000000000002000000<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0>L0oooo00<000000?ooo`3oool07P3oool000<0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0>L0oooo
00<000000?ooo`3oool07P3oool000<0oooo00<000000?ooo`3oool01P3oool5000000@0oooo0P00
003Y0?ooo`030000003oool0oooo01d0oooo00030?ooo`030000003oool0oooo00H0oooo00@00000
0?ooo`3oool000001@3oool00`000000oooo0?ooo`3X0?ooo`030000003oool0oooo01d0oooo0003
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`3Y
0?ooo`030000003oool0oooo01`0oooo0000103oool0000000000000000:0?ooo`8000001@3oool0
0`000000oooo0?ooo`3Y0?ooo`030000003oool0oooo01`0oooo00030?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3Z0?ooo`030000003oool0oooo
01/0oooo000E0?ooo`030000003oool0oooo0>X0oooo00<000000?ooo`3oool06`3oool001D0oooo
0P00003[0?ooo`030000003oool0oooo01/0oooo000E0?ooo`030000003oool0oooo0>/0oooo00<0
00000?ooo`3oool06P3oool001D0oooo00<000000?ooo`3oool0j`3oool00`000000oooo0?ooo`0J
0?ooo`005@3oool00`000000oooo0?ooo`3/0?ooo`030000003oool0oooo01T0oooo000E0?ooo`03
0000003oool0oooo0>`0oooo00<000000?ooo`3oool06@3oool001D0oooo0P00003]0?ooo`030000
003oool0oooo01T0oooo000E0?ooo`030000003oool0oooo0>d0oooo00<000000?ooo`3oool0603o
ool001D0oooo00<000000?ooo`3oool0k@3oool00`000000oooo0?ooo`0H0?ooo`005@3oool00`00
0000oooo0?ooo`3^0?ooo`030000003oool0oooo01L0oooo000E0?ooo`030000003oool0oooo0>h0
oooo00<000000?ooo`3oool05`3oool001D0oooo0P00003`0?ooo`030000003oool0oooo01H0oooo
000E0?ooo`030000003oool0oooo0>l0oooo00<000000?ooo`3oool05P3oool001D0oooo00<00000
0?ooo`3oool0k`3oool00`000000oooo0?ooo`0F0?ooo`005@3oool00`000000oooo0?ooo`3`0?oo
o`030000003oool0oooo01D0oooo000E0?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3o
ool05@3oool001D0oooo00<000000?ooo`3oool0l@3oool00`000000oooo0?ooo`0D0?ooo`005@3o
ool200000?80oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool0l@3oool0
0`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`3b0?ooo`030000003oool0oooo
01<0oooo00000`3oool0000000000002000000<0oooo00<000000?ooo`3oool00P3oool3000000D0
oooo00<000000?ooo`3oool0lP3oool00`000000oooo0?ooo`0C0?ooo`000`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0l`3oool00`000000oooo
0?ooo`0B0?ooo`000`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P00
003d0?ooo`030000003oool0oooo0180oooo00030?ooo`030000003oool0oooo00L0oooo0`000005
0?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool04@3oool000<0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?@0oooo00<000000?oo
o`3oool04@3oool000040?ooo`0000000000000000T0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3d0?ooo`030000003oool0oooo0140oooo00030?ooo`030000003oool0oooo00L0
oooo100000040?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0403oool001D0oooo
0P00003f0?ooo`030000003oool0oooo0100oooo000E0?ooo`030000003oool0oooo0?H0oooo00<0
00000?ooo`3oool03`3oool001D0oooo00<000000?ooo`3oool0mP3oool00`000000oooo0?ooo`0?
0?ooo`005@3oool00`000000oooo0?ooo`3g0?ooo`030000003oool0oooo00h0oooo000E0?ooo`03
0000003oool0oooo0?L0oooo00<000000?ooo`3oool03P3oool001D0oooo00<000000?ooo`3oool0
m`3oool00`000000oooo0?ooo`0>0?ooo`005@3oool200000?T0oooo00<000000?ooo`3oool03@3o
ool001D0oooo00<000000?ooo`3oool0n03oool00`000000oooo0?ooo`0=0?ooo`005@3oool00`00
0000oooo0?ooo`3i0?ooo`030000003oool0oooo00`0oooo000E0?ooo`030000003oool0oooo0?T0
oooo00<000000?ooo`3oool0303oool001D0oooo00<000000?ooo`3oool0n@3oool00`000000oooo
0?ooo`0<0?ooo`005@3oool200000?/0oooo00<000000?ooo`3oool02`3oool001D0oooo00<00000
0?ooo`3oool0nP3oool00`000000oooo0?ooo`0;0?ooo`005@3oool00`000000oooo0?ooo`3k0?oo
o`030000003oool0oooo00X0oooo000E0?ooo`030000003oool0oooo0?/0oooo00<000000?ooo`3o
ool02P3oool001D0oooo00<000000?ooo`3oool0o03oool00`000000oooo0?ooo`090?ooo`005@3o
ool200000?d0oooo00<000000?ooo`3oool02@3oool001D0oooo00<000000?ooo`3oool0o`3oool9
0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0
oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.33168, 0.936652, \
0.0120713, 0.00374202}}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell["Compare Strange ", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sRatio = s/\((\((ubar + dbar)\)/2)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{0.8470068671209459`, 0.8466698977768896`, 
      0.8449913773369158`, 0.8413771574828116`, 0.8349483498443415`, 
      0.8243756586807514`, 0.807952977907886`, 0.7835410676571182`, 
      0.749054223403831`, 0.7036410497054825`, 0.6494878914508839`, 
      0.5939226206002657`, 0.5487647645713324`}\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \({xlist, sRatio}\  // Transpose\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.0001`", "0.8470068671209459`"},
            {"0.00017782794100389227`", "0.8466698977768896`"},
            {"0.00031622776601683794`", "0.8449913773369158`"},
            {"0.0005623413251903491`", "0.8413771574828116`"},
            {"0.001`", "0.8349483498443415`"},
            {"0.0017782794100389228`", "0.8243756586807514`"},
            {"0.0031622776601683794`", "0.807952977907886`"},
            {"0.005623413251903491`", "0.7835410676571182`"},
            {"0.01`", "0.749054223403831`"},
            {"0.017782794100389226`", "0.7036410497054825`"},
            {"0.0316227766016838`", "0.6494878914508839`"},
            {"0.05623413251903491`", "0.5939226206002657`"},
            {"0.1`", "0.5487647645713324`"}
            },
          ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LogLinearListPlot[{xlist, sRatio}\  // Transpose, 
      PlotJoined \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.29365 0.31746 -1.06831 1.97358 [
[.02381 -0.0125 -20 -9.8125 ]
[.02381 -0.0125 20 0 ]
[.2457 -0.0125 -20 -9.8125 ]
[.2457 -0.0125 20 0 ]
[.34127 -0.0125 -17 -9.8125 ]
[.34127 -0.0125 17 0 ]
[.56317 -0.0125 -17 -9.8125 ]
[.56317 -0.0125 17 0 ]
[.65873 -0.0125 -14 -9.8125 ]
[.65873 -0.0125 14 0 ]
[.88063 -0.0125 -14 -9.8125 ]
[.88063 -0.0125 14 0 ]
[.97619 -0.0125 -11 -9.8125 ]
[.97619 -0.0125 11 0 ]
[-0.0125 .01715 -24 -4.5 ]
[-0.0125 .01715 0 4.5 ]
[-0.0125 .11583 -18 -4.5 ]
[-0.0125 .11583 0 4.5 ]
[-0.0125 .21451 -24 -4.5 ]
[-0.0125 .21451 0 4.5 ]
[-0.0125 .31319 -18 -4.5 ]
[-0.0125 .31319 0 4.5 ]
[-0.0125 .41187 -24 -4.5 ]
[-0.0125 .41187 0 4.5 ]
[-0.0125 .51055 -18 -4.5 ]
[-0.0125 .51055 0 4.5 ]
[-0.0125 .60923 -24 -4.5 ]
[-0.0125 .60923 0 4.5 ]
[ 0 -0.0005 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
gsave
.02381 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2457 0 m
.2457 .00625 L
s
gsave
.2457 -0.0125 -81 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0005) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.56317 0 m
.56317 .00625 L
s
gsave
.56317 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.005) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65873 0 m
.65873 .00625 L
s
gsave
.65873 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.88063 0 m
.88063 .00625 L
s
gsave
.88063 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.11937 0 m
.11937 .00375 L
s
.17528 0 m
.17528 .00375 L
s
.21494 0 m
.21494 .00375 L
s
.27084 0 m
.27084 .00375 L
s
.29209 0 m
.29209 .00375 L
s
.3105 0 m
.3105 .00375 L
s
.32674 0 m
.32674 .00375 L
s
.43683 0 m
.43683 .00375 L
s
.49274 0 m
.49274 .00375 L
s
.5324 0 m
.5324 .00375 L
s
.5883 0 m
.5883 .00375 L
s
.60955 0 m
.60955 .00375 L
s
.62797 0 m
.62797 .00375 L
s
.6442 0 m
.6442 .00375 L
s
.7543 0 m
.7543 .00375 L
s
.8102 0 m
.8102 .00375 L
s
.84986 0 m
.84986 .00375 L
s
.90576 0 m
.90576 .00375 L
s
.92702 0 m
.92702 .00375 L
s
.94543 0 m
.94543 .00375 L
s
.96166 0 m
.96166 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01715 m
.00625 .01715 L
s
[(0.55)] -0.0125 .01715 1 0 Mshowa
0 .11583 m
.00625 .11583 L
s
[(0.6)] -0.0125 .11583 1 0 Mshowa
0 .21451 m
.00625 .21451 L
s
[(0.65)] -0.0125 .21451 1 0 Mshowa
0 .31319 m
.00625 .31319 L
s
[(0.7)] -0.0125 .31319 1 0 Mshowa
0 .41187 m
.00625 .41187 L
s
[(0.75)] -0.0125 .41187 1 0 Mshowa
0 .51055 m
.00625 .51055 L
s
[(0.8)] -0.0125 .51055 1 0 Mshowa
0 .60923 m
.00625 .60923 L
s
[(0.85)] -0.0125 .60923 1 0 Mshowa
.125 Mabswid
0 .03689 m
.00375 .03689 L
s
0 .05662 m
.00375 .05662 L
s
0 .07636 m
.00375 .07636 L
s
0 .0961 m
.00375 .0961 L
s
0 .13557 m
.00375 .13557 L
s
0 .1553 m
.00375 .1553 L
s
0 .17504 m
.00375 .17504 L
s
0 .19477 m
.00375 .19477 L
s
0 .23425 m
.00375 .23425 L
s
0 .25398 m
.00375 .25398 L
s
0 .27372 m
.00375 .27372 L
s
0 .29345 m
.00375 .29345 L
s
0 .33293 m
.00375 .33293 L
s
0 .35266 m
.00375 .35266 L
s
0 .3724 m
.00375 .3724 L
s
0 .39213 m
.00375 .39213 L
s
0 .4316 m
.00375 .4316 L
s
0 .45134 m
.00375 .45134 L
s
0 .47108 m
.00375 .47108 L
s
0 .49081 m
.00375 .49081 L
s
0 .53028 m
.00375 .53028 L
s
0 .55002 m
.00375 .55002 L
s
0 .56975 m
.00375 .56975 L
s
0 .58949 m
.00375 .58949 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.10317 .60265 L
.18254 .59934 L
.2619 .59221 L
.34127 .57952 L
.42063 .55865 L
.5 .52624 L
.57937 .47806 L
.65873 .41 L
.7381 .32038 L
.81746 .2135 L
.89683 .10384 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`004@3oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0P0000040?ooo`8000000`3oool4
000001L0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`800000103oool2
00000080oooo100000020?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool4
000001d0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool3
00000080oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`@000008`3oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000<0oooo0`0000080?ooo`800000103oool0
0`000000oooo0?ooo`020?ooo`@00000103oool00100oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`0E0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo008000000P3o
ool00`000000oooo000000060?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`0K0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`8000000P3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool08@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0103oool01000
0000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo000@0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool05@3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`0200000080oooo00<000000?ooo`0000001P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool06`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool200000080oooo00<0
00000?ooo`3oool01P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0240oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
00@0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`00403oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo01D0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00P000000103oool000000000000000070?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0K0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`<00000
00D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool08@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo0`00
00070?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00100oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0E0?ooo`040000003oool0
oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo0080000000<0oooo000000000000203oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool06`3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000002P3oool00`000000
oooo0?ooo`030?ooo`00403oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`<000005`3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`02000000030?ooo`000000000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`<000007@3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00
00020?ooo`<000008`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool00140
oooo0P00000:0?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003oool0oooo01H0
oooo0P00000:0?ooo`800000103oool2000000@0oooo0P0000020?ooo`D000001`3oool2000000@0
oooo0P0000050?ooo`030000003oool0oooo01`0oooo0P00000:0?ooo`800000103oool2000000<0
oooo100000000`3oool000000000000:0?ooo`8000001@3oool00`000000oooo0?ooo`0R0?ooo`80
00002P3oool2000000<0oooo100000070?ooo`8000002`3oool00`000000oooo0?ooo`030?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`006`3ooooo0000004000001@3oool001/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`090?ooo`000P3oool2000000@0oooo00<000000?ooo`3oool00P3oool3000000<0oooo0`000005
0?ooo`030000003oool0oooo0?l0oooo0`3oool000050?ooo`000000oooo0?ooo`0000002`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0mP3oool0
0`000000oooo0?ooo`090?ooo`0000D0oooo0000003oool0oooo0000000;0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool200000?H0oooo00<000000?ooo`3oool02P3oool0
00050?ooo`000000oooo0?ooo`000000203oool3000000<0oooo0`0000050?ooo`030000003oool0
oooo0?@0oooo00<000000?ooo`3oool02`3oool000050?ooo`000000oooo0?ooo`000000203oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0l`3oool0
0`000000oooo0?ooo`0<0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3b0?ooo`030000003oool0
oooo00d0oooo00020?ooo`8000002@3oool400000080oooo100000040?ooo`030000003oool0oooo
0?40oooo00<000000?ooo`3oool03P3oool001/0oooo0P00003b0?ooo`030000003oool0oooo00h0
oooo000K0?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool03`3oool001/0oooo00<0
00000?ooo`3oool0k`3oool00`000000oooo0?ooo`0@0?ooo`006`3oool00`000000oooo0?ooo`3^
0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo0>d0oooo00<000000?oo
o`3oool04P3oool001/0oooo0P00003]0?ooo`030000003oool0oooo01<0oooo000K0?ooo`030000
003oool0oooo0>/0oooo00<000000?ooo`3oool0503oool001/0oooo00<000000?ooo`3oool0jP3o
ool00`000000oooo0?ooo`0E0?ooo`006`3oool00`000000oooo0?ooo`3Y0?ooo`030000003oool0
oooo01H0oooo000K0?ooo`030000003oool0oooo0>P0oooo00<000000?ooo`3oool05`3oool001/0
oooo0P00003X0?ooo`030000003oool0oooo01P0oooo000K0?ooo`030000003oool0oooo0>H0oooo
00<000000?ooo`3oool06@3oool001/0oooo00<000000?ooo`3oool0iP3oool00`000000oooo0?oo
o`0I0?ooo`006`3oool00`000000oooo0?ooo`3U0?ooo`030000003oool0oooo01X0oooo000K0?oo
o`030000003oool0oooo0>@0oooo00<000000?ooo`3oool06`3oool001/0oooo0P00003T0?ooo`03
0000003oool0oooo01`0oooo000K0?ooo`030000003oool0oooo0>80oooo00<000000?ooo`3oool0
7@3oool001/0oooo00<000000?ooo`3oool0h@3oool00`000000oooo0?ooo`0N0?ooo`00203oool2
000000@0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool0h03oool0
0`000000oooo0?ooo`0O0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool0h03oool00`000000oooo0?ooo`0O0?ooo`001`3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo0P00003P0?ooo`030000
003oool0oooo0200oooo00070?ooo`040000003oool0oooo000000P0oooo0`0000050?ooo`030000
003oool0oooo0=h0oooo00<000000?ooo`3oool08@3oool000L0oooo00@000000?ooo`3oool00000
203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0=d0oooo00<000000?ooo`3oool0
8P3oool000L0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0=d0oooo00<000000?ooo`3oool08P3oool000P0oooo0P00000:0?ooo`<00000103o
ool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo02<0oooo000K0?ooo`800000g03oool0
0`000000oooo0?ooo`0T0?ooo`006`3oool00`000000oooo0?ooo`3K0?ooo`030000003oool0oooo
02@0oooo000K0?ooo`030000003oool0oooo0=X0oooo00<000000?ooo`3oool09@3oool001/0oooo
00<000000?ooo`3oool0f@3oool00`000000oooo0?ooo`0V0?ooo`006`3oool00`000000oooo0?oo
o`3H0?ooo`030000003oool0oooo02L0oooo000K0?ooo`800000f@3oool00`000000oooo0?ooo`0W
0?ooo`006`3oool00`000000oooo0?ooo`3G0?ooo`030000003oool0oooo02P0oooo000K0?ooo`03
0000003oool0oooo0=H0oooo00<000000?ooo`3oool0:@3oool001/0oooo00<000000?ooo`3oool0
eP3oool00`000000oooo0?ooo`0Y0?ooo`006`3oool00`000000oooo0?ooo`3E0?ooo`030000003o
ool0oooo02X0oooo000K0?ooo`800000e@3oool00`000000oooo0?ooo`0[0?ooo`006`3oool00`00
0000oooo0?ooo`3C0?ooo`030000003oool0oooo02`0oooo000K0?ooo`030000003oool0oooo0=<0
oooo00<000000?ooo`3oool0;03oool001/0oooo00<000000?ooo`3oool0dP3oool00`000000oooo
0?ooo`0]0?ooo`006`3oool00`000000oooo0?ooo`3A0?ooo`030000003oool0oooo02h0oooo000K
0?ooo`800000dP3oool00`000000oooo0?ooo`0^0?ooo`006`3oool00`000000oooo0?ooo`3@0?oo
o`030000003oool0oooo02l0oooo000K0?ooo`030000003oool0oooo0<l0oooo00<000000?ooo`3o
ool0<03oool00080oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`<00000
1@3oool00`000000oooo0?ooo`3>0?ooo`030000003oool0oooo0340oooo00001@3oool000000?oo
o`3oool0000000P0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0<h0oooo00<000000?ooo`3oool0<@3oool000050?ooo`000000oooo0?ooo`00
0000203oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0080oooo0P00003>0?oo
o`030000003oool0oooo0380oooo00001@3oool000000?ooo`3oool0000000P0oooo0`0000030?oo
o`<000001@3oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo03<0oooo00001@3oool0
00000?ooo`3oool0000000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0<`3oool000050?ooo`000000oooo0?oo
o`000000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0b`3oool00`000000oooo0?ooo`0d0?ooo`000P3oool2000000X0oooo0`0000020?ooo`@0
0000103oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo03D0oooo000K0?ooo`800000
bP3oool00`000000oooo0?ooo`0f0?ooo`006`3oool00`000000oooo0?ooo`390?ooo`030000003o
ool0oooo03H0oooo000K0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool0=`3oool0
01/0oooo00<000000?ooo`3oool0a`3oool00`000000oooo0?ooo`0h0?ooo`006`3oool00`000000
oooo0?ooo`360?ooo`030000003oool0oooo03T0oooo000K0?ooo`800000a`3oool00`000000oooo
0?ooo`0i0?ooo`006`3oool00`000000oooo0?ooo`350?ooo`030000003oool0oooo03X0oooo000K
0?ooo`030000003oool0oooo0<@0oooo00<000000?ooo`3oool0>`3oool001/0oooo00<000000?oo
o`3oool0``3oool00`000000oooo0?ooo`0l0?ooo`006`3oool00`000000oooo0?ooo`330?ooo`03
0000003oool0oooo03`0oooo000K0?ooo`800000``3oool00`000000oooo0?ooo`0m0?ooo`006`3o
ool00`000000oooo0?ooo`310?ooo`030000003oool0oooo03h0oooo000K0?ooo`030000003oool0
oooo0<00oooo00<000000?ooo`3oool0?`3oool001/0oooo00<000000?ooo`3oool0`03oool00`00
0000oooo0?ooo`0o0?ooo`006`3oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo0400
oooo000K0?ooo`800000_`3oool00`000000oooo0?ooo`110?ooo`006`3oool00`000000oooo0?oo
o`2m0?ooo`030000003oool0oooo0480oooo000K0?ooo`030000003oool0oooo0;d0oooo00<00000
0?ooo`3oool0@P3oool000P0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo04<0oooo00070?ooo`04
0000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2k0?oo
o`030000003oool0oooo04@0oooo00070?ooo`040000003oool0oooo000000X0oooo00<000000?oo
o`3oool00`3oool200000;/0oooo00<000000?ooo`3oool0A@3oool000L0oooo00@000000?ooo`3o
ool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0;X0oooo00<000000?oo
o`3oool0A@3oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0;T0oooo00<000000?ooo`3oool0AP3oool000L0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0;P0oooo00<00000
0?ooo`3oool0A`3oool000P0oooo0P0000090?ooo`@00000103oool00`000000oooo0?ooo`2g0?oo
o`030000003oool0oooo04P0oooo000K0?ooo`800000]`3oool00`000000oooo0?ooo`190?ooo`00
6`3oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo04T0oooo000K0?ooo`030000003o
ool0oooo0;D0oooo00<000000?ooo`3oool0BP3oool001/0oooo00<000000?ooo`3oool0]03oool0
0`000000oooo0?ooo`1;0?ooo`006`3oool00`000000oooo0?ooo`2c0?ooo`030000003oool0oooo
04`0oooo000K0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool0C@3oool001/0oooo
0P00002b0?ooo`030000003oool0oooo04h0oooo000K0?ooo`030000003oool0oooo0;00oooo00<0
00000?ooo`3oool0C`3oool001/0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`1@
0?ooo`006`3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0500oooo000K0?ooo`03
0000003oool0oooo0:h0oooo00<000000?ooo`3oool0D@3oool001/0oooo0P00002^0?ooo`030000
003oool0oooo0580oooo000K0?ooo`030000003oool0oooo0:`0oooo00<000000?ooo`3oool0D`3o
ool001/0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`1D0?ooo`006`3oool00`00
0000oooo0?ooo`2Z0?ooo`030000003oool0oooo05D0oooo000K0?ooo`030000003oool0oooo0:T0
oooo00<000000?ooo`3oool0EP3oool001/0oooo0P00002Y0?ooo`030000003oool0oooo05L0oooo
000K0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0E`3oool001/0oooo00<00000
0?ooo`3oool0Y`3oool00`000000oooo0?ooo`1H0?ooo`000P3oool2000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`2V0?oo
o`030000003oool0oooo05T0oooo00001@3oool000000?ooo`3oool0000000T0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0:D0oooo00<000000?oo
o`3oool0FP3oool000050?ooo`000000oooo0?ooo`0000002P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0080oooo0P00002U0?ooo`030000003oool0oooo05/0oooo00001@3oool0
00000?ooo`3oool0000000X0oooo00@000000?ooo`3oool0oooo0`0000050?ooo`030000003oool0
oooo0:80oooo0P00001N0?ooo`0000D0oooo0000003oool0oooo0000000;0?ooo`040000003oool0
oooo000000L0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`1N0?ooo`0000D0oooo
0000003oool0oooo000000080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo05l0oooo00020?ooo`8000002@3o
ool400000080oooo100000040?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0H03o
ool001/0oooo0P00002N0?ooo`800000H`3oool001/0oooo00<000000?ooo`3oool0W03oool00`00
0000oooo0?ooo`1S0?ooo`006`3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo06@0
oooo000K0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3oool0I@3oool001/0oooo00<0
00000?ooo`3oool0V@3oool00`000000oooo0?ooo`1V0?ooo`006`3oool2000009P0oooo0P00001Y
0?ooo`006`3oool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo06T0oooo000K0?ooo`03
0000003oool0oooo09D0oooo00<000000?ooo`3oool0JP3oool001/0oooo00<000000?ooo`3oool0
U03oool00`000000oooo0?ooo`1[0?ooo`006`3oool00`000000oooo0?ooo`2B0?ooo`800000KP3o
ool001/0oooo0P00002B0?ooo`030000003oool0oooo06h0oooo000K0?ooo`030000003oool0oooo
0900oooo00<000000?ooo`3oool0K`3oool001/0oooo00<000000?ooo`3oool0SP3oool200000780
oooo000K0?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3oool0LP3oool001/0oooo00<0
00000?ooo`3oool0R`3oool2000007D0oooo000K0?ooo`800000R`3oool00`000000oooo0?ooo`1e
0?ooo`006`3oool00`000000oooo0?ooo`280?ooo`800000N03oool001/0oooo00<000000?ooo`3o
ool0QP3oool2000007X0oooo00080?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000
1@3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo07X0oooo00070?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`230?ooo`80
0000O@3oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?oo
o`800000P`3oool00`000000oooo0?ooo`1m0?ooo`001`3oool010000000oooo0?ooo`0000090?oo
o`8000001@3oool00`000000oooo0?ooo`200?ooo`800000P03oool000L0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo07l0oooo00<00000
0?ooo`3oool0P03oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo07d0oooo0P0000230?ooo`00203oool2000000X0oooo0P000005
0?ooo`030000003oool0oooo07/0oooo0P0000250?ooo`006`3oool2000007X0oooo0P0000270?oo
o`006`3oool00`000000oooo0?ooo`1f0?ooo`<00000R@3oool001/0oooo00<000000?ooo`3oool0
M03oool2000008`0oooo000K0?ooo`030000003oool0oooo0740oooo0`00002>0?ooo`006`3oool0
0`000000oooo0?ooo`1_0?ooo`800000T@3oool001/0oooo0P00001]0?ooo`<00000T`3oool001/0
oooo00<000000?ooo`3oool0JP3oool2000009H0oooo000K0?ooo`030000003oool0oooo06H0oooo
1000002H0?ooo`006`3oool00`000000oooo0?ooo`1R0?ooo`@00000W03oool001/0oooo00<00000
0?ooo`3oool0GP3oool400000:00oooo000K0?ooo`800000F`3oool400000:@0oooo000K0?ooo`03
0000003oool0oooo05H0oooo1000002X0?ooo`006`3oool00`000000oooo0?ooo`1B0?ooo`@00000
[03oool001/0oooo00<000000?ooo`3oool0C@3oool500000;00oooo000K0?ooo`030000003oool0
oooo04L0oooo1P00002e0?ooo`006`3oool2000004<0oooo1@00002k0?ooo`006`3oool00`000000
oooo0?ooo`0e0?ooo`d00000`03oool001/0oooo00<000000?ooo`3oool08@3ooolD00000<d0oooo
00020?ooo`800000103oool00`000000oooo0?ooo`030?ooo`8000000`3oool3000000D0oooo00<0
00000?ooo`3oool00`3ooolN00000>40oooo00001@3oool000000?ooo`3oool0000000P0oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo
0`3oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0oooo0080oooo0P00003o0?ooo`@0oooo00001@3oool000000?ooo`3oool0000000T0
oooo0P0000030?ooo`<000001@3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00001@3oool00000
0?ooo`3oool0000000P0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0?l0oooo0`3oool000050?ooo`000000oooo0?ooo`000000203oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo0?l0oooo2`3oool00080oooo0P00000:0?oo
o`8000000`3oool400000?l0oooo2P3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.411, 0.511332, 0.0123588, \
0.00198797}}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], TraditionalForm]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
CellGrouping->Manual,
WindowSize->{1024, 694},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 31, 0, 45, "Subsection"],
Cell[1761, 54, 2258, 40, 443, "Input"],
Cell[4022, 96, 318, 5, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4377, 106, 63, 1, 24, "Input"],
Cell[4443, 109, 73, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4553, 115, 431, 7, 155, "Input"],
Cell[4987, 124, 288, 5, 23, "Message"],
Cell[5278, 131, 288, 5, 23, "Message"],
Cell[5569, 138, 235, 4, 24, "Print"],
Cell[5807, 144, 223, 3, 24, "Print"],
Cell[6033, 149, 234, 4, 24, "Print"],
Cell[6270, 155, 225, 3, 24, "Print"],
Cell[6498, 160, 224, 3, 24, "Print"],
Cell[6725, 165, 227, 3, 24, "Print"],
Cell[6955, 170, 236, 4, 24, "Print"],
Cell[7194, 176, 226, 3, 24, "Print"],
Cell[7423, 181, 225, 3, 24, "Print"],
Cell[7651, 186, 236, 4, 24, "Print"],
Cell[7890, 192, 223, 3, 24, "Print"],
Cell[8116, 197, 237, 4, 24, "Print"],
Cell[8356, 203, 237, 4, 24, "Print"],
Cell[8596, 209, 59, 1, 24, "Print"],
Cell[8658, 212, 52, 1, 24, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[8747, 218, 110, 2, 24, "Input"],
Cell[8860, 222, 286, 5, 23, "Message"],
Cell[9149, 229, 3274, 57, 153, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12460, 291, 65, 1, 27, "Input"],
Cell[12528, 294, 919, 18, 243, "Output"]
}, Open  ]],
Cell[13462, 315, 43, 0, 60, "Section"],

Cell[CellGroupData[{
Cell[13530, 319, 298, 6, 43, "Input"],
Cell[13831, 327, 392, 11, 28, "Output"],
Cell[14226, 340, 32056, 916, 186, 13828, 686, "GraphicsData", "PostScript", \
"Graphics"],
Cell[46285, 1258, 167, 4, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46489, 1267, 294, 6, 43, "Input"],
Cell[46786, 1275, 392, 11, 28, "Output"],
Cell[47181, 1288, 28973, 867, 186, 12629, 661, "GraphicsData", "PostScript", \
"Graphics"],
Cell[76157, 2157, 167, 4, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76361, 2166, 73, 1, 27, "Input"],
Cell[76437, 2169, 31427, 932, 186, 13489, 706, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[107879, 3104, 36, 0, 60, "Section"],

Cell[CellGroupData[{
Cell[107940, 3108, 36, 1, 27, "Input"],
Cell[107979, 3111, 351, 5, 28, "Output"]
}, Open  ]],
Cell[108345, 3119, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[108396, 3123, 60, 1, 27, "Input"],
Cell[108459, 3126, 927, 18, 243, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[109423, 3149, 111, 2, 27, "Input"],
Cell[109537, 3153, 25626, 682, 186, 8463, 466, "GraphicsData", "PostScript", \
"Graphics"],
Cell[135166, 3837, 167, 4, 28, "Output"]
}, Open  ]],
Cell[135348, 3844, 35, 0, 60, "Section"],

Cell[CellGroupData[{
Cell[135408, 3848, 69, 1, 27, "Input"],
Cell[135480, 3851, 350, 5, 28, "Output"]
}, Open  ]],
Cell[135845, 3859, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[135896, 3863, 63, 1, 27, "Input"],
Cell[135962, 3866, 926, 18, 243, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[136925, 3889, 114, 2, 27, "Input"],
Cell[137042, 3893, 26635, 699, 186, 8583, 472, "GraphicsData", "PostScript", \
"Graphics"],
Cell[163680, 4594, 167, 4, 28, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

