(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6455,        205]*)
(*NotebookOutlinePosition[      7084,        227]*)
(*  CellTagsIndexPosition[      7040,        223]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(SetAttributes[SC, Orderless];\)\n\), "\[IndentingNewLine]", 
    \(\(SC[a_, b_ + c_] := 
        SC[a, b] + SC[a, c];\)\n\), "\[IndentingNewLine]", 
    \(SC[x_?NumberQ*a_, b_] := x*SC[a, b]\)}], "Input"],

Cell[BoxData[
    \(\(\(rules = {\[IndentingNewLine]SC[p1, p2] \[Rule] \(+s\)/
              2, \ \[IndentingNewLine]SC[p3, p4] \[Rule] \((\(+s\) - MW^2)\)/
              2, \ \[IndentingNewLine]SC[p1, p3] \[Rule] \(-t\)/
              2, \ \[IndentingNewLine]SC[p2, p4] \[Rule] \((\(-t\) + MW^2)\)/
              2, \ \[IndentingNewLine]SC[p1, p4] \[Rule] \((\(-u\) + MW^2)\)/
              2, \ \[IndentingNewLine]SC[p2, p3] \[Rule] \(-u\)/
              2};\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[{
    \(\(p4 = \(+p1\) + p2 - p3;\)\), "\n", 
    \(\(p1 /: SC[p1, p1] = 0^2;\)\), "\n", 
    \(\(p2 /: SC[p2, p2] = 0^2;\)\), "\n", 
    \(\(p3 /: SC[p3, p3] = 0^2;\)\), "\n", 
    \(\(\(p2 /: 
        SC[p2, p3] = \(-1\)*\((MW^2 - 0^2 - 0^2 - 0^2 - 2*SC[p1, p2] + 
                2*SC[p1, p3])\)/2;\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SC[p1 + p2 - p3 - p4, p1 + p2 - p3 - p4]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`SC(0, 0)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(sq[x_] = SC[x, x];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sRule = \(Solve[s + t + u\  \[Equal] \ MW^2, s]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{s \[Rule] MW\^2 - t - u}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(uRule = \(Solve[s + t + u\  \[Equal] \ MW^2, u]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{u \[Rule] MW\^2 - s - t}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(tRule = \(Solve[s + t + u\  \[Equal] \ MW^2, t]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{t \[Rule] MW\^2 - s - u}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({\[IndentingNewLine]sq[p1 + p2], \[IndentingNewLine]sq[
          p3 + p4], \[IndentingNewLine]sq[p1 - p3], \[IndentingNewLine]sq[
          p2 - p4], \[IndentingNewLine]sq[p1 - p4], \[IndentingNewLine]sq[
          p2 - p3]\[IndentingNewLine]}\  /. rules\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{s, s, t, t, MW\^2 - s - t, MW\^2 - s - t}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%\  /. tRule\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{s, s, MW\^2 - s - u, MW\^2 - s - u, u, u}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(numeratorTT = \((2*SC[p1, p3]^2*SC[p1, p2] - 2*SC[p1, p3]^2*MW^2 + 
          2*SC[p1, p3]*SC[p1, p2]*MW^2 - SC[p1, p3]*MW^4)\)\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-\(SC(p1, p3)\)\)\ MW\^4 - 
      2\ \(SC(p1, p3)\)\^2\ MW\^2 + 
      2\ \(SC(p1, p2)\)\ \(SC(p1, p3)\)\ MW\^2 + 
      2\ \(SC(p1, p2)\)\ \(SC(p1, p3)\)\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(numeratorX = \((2*SC[p1, p3]^2*SC[p1, p2] - 
          2*SC[p1, p3]*SC[p1, p2]^2 + SC[p1, p3]*SC[p1, p2]*MW^2 + 
          SC[p1, p2]*MW^4)\)\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(SC(p1, p2)\)\ MW\^4 + \(SC(p1, p2)\)\ \(SC(p1, 
          p3)\)\ MW\^2 + 2\ \(SC(p1, p2)\)\ \(SC(p1, p3)\)\^2 - 
      2\ \(SC(p1, p2)\)\^2\ \(SC(p1, p3)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(numeratorUU = \((4*SC[p1, p3]^2*SC[p1, p2] - 4*SC[p1, p3]^2*MW^2 - 
          8*SC[p1, p3]*SC[p1, p2]^2 + 8*SC[p1, p3]*SC[p1, p2]*MW^2 - 
          2*SC[p1, p3]*MW^4 + 4*SC[p1, p2]^3 - 4*SC[p1, p2]^2*MW^2 + 
          SC[p1, p2]*MW^4)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(SC(p1, p2)\)\ MW\^4 - 2\ \(SC(p1, p3)\)\ MW\^4 - 
      4\ \(SC(p1, p2)\)\^2\ MW\^2 - 4\ \(SC(p1, p3)\)\^2\ MW\^2 + 
      8\ \(SC(p1, p2)\)\ \(SC(p1, p3)\)\ MW\^2 + 4\ \(SC(p1, p2)\)\^3 + 
      4\ \(SC(p1, p2)\)\ \(SC(p1, p3)\)\^2 - 
      8\ \(SC(p1, p2)\)\^2\ \(SC(p1, p3)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(nlist = {numeratorTT, numeratorX, numeratorX};\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nlist2 = nlist/{t^2, t\ u, u^2} //. rules\  // Simplify\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{\(2\ MW\^4 - 2\ \((s + t)\)\ MW\^2 + s\ t\)\/\(4\ \
t\), \(s\ \((2\ MW\^4 - t\ MW\^2 + t\ \((s + t)\))\)\)\/\(4\ t\ u\), \(s\ \
\((2\ MW\^4 - t\ MW\^2 + t\ \((s + t)\))\)\)\/\(4\ u\^2\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(nlist2[\([1]\)]\  /. uRule\  // Simplify\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(2\ MW\^4 - 2\ \((s + t)\)\ MW\^2 + s\ t\)\/\(4\ \
t\)\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 31}, {Automatic, 57}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 227, 4, 91, "Input"],
Cell[1935, 56, 505, 8, 139, "Input"],
Cell[2443, 66, 377, 9, 139, "Input"],

Cell[CellGroupData[{
Cell[2845, 79, 73, 1, 27, "Input"],
Cell[2921, 82, 59, 1, 28, "Output"]
}, Open  ]],
Cell[2995, 86, 55, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[3075, 91, 91, 1, 27, "Input"],
Cell[3169, 94, 76, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3282, 100, 91, 1, 27, "Input"],
Cell[3376, 103, 76, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3489, 109, 91, 1, 27, "Input"],
Cell[3583, 112, 76, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3696, 118, 288, 4, 139, "Input"],
Cell[3987, 124, 93, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4117, 130, 45, 1, 27, "Input"],
Cell[4165, 133, 93, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4295, 139, 179, 3, 75, "Input"],
Cell[4477, 144, 210, 4, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4724, 153, 193, 4, 75, "Input"],
Cell[4920, 159, 208, 3, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5165, 167, 269, 4, 91, "Input"],
Cell[5437, 173, 331, 5, 65, "Output"]
}, Open  ]],
Cell[5783, 181, 83, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[5891, 186, 88, 1, 27, "Input"],
Cell[5982, 189, 238, 3, 84, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6257, 197, 73, 1, 27, "Input"],
Cell[6333, 200, 106, 2, 46, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

