(*
     ==============================
     *  CompHEP version 33.23     *
     ==============================
  process  u(p1)+D(p2)->G(p3)+W+(p4)
*)

parameters={
 EE -> 3.12230000000*10^(-1)
,SW -> 4.73000000000*10^(-1)
,s12 -> 2.21000000000*10^(-1)
,s13 -> 3.50000000000*10^(-3)
,MZ -> 9.11884000000*10^(1)
,GG -> 1.23800000000*10^(0)
           };

substitutions={
 Vud->c12*c13
,c13->Sqrt[1-s13^2]
,c12->Sqrt[1-s12^2]
,MW->MZ*CW
,CW->Sqrt[1-SW^2]
              };

inParticles = {"u","D"}
outParticles = {"G","W+"}

SetAttributes[ SC, Orderless ];

SC[ a_ , b_ + c_ ] := SC[a,b]+SC[a,c];

SC[ x_?NumberQ * a_ , b_ ] := x * SC[ a, b ]



p4 = +p1+p2-p3;
p1/: SC[p1,p1] =0^2;
p2/: SC[p2,p2] =0^2;
p3/: SC[p3,p3] =0^2;
p2/: SC[p2,p3] = -1*(MW^2-0^2-0^2-0^2-2*SC[p1,p2]+2*SC[p1,p3])/2;

initSum;

(*
  Diagram  1 in subprocess 1
                      u     G    !  G     u                          
                    ==>==@-------!-----@==>==                        
                      P1 |  P3   !  P3 |  P1                         
                        u|       !    u|                             
                      D  |  W+   !  W+ |  D                          
                    ==<==@-->----!-->--@==<==                        
                      P2    P4   !  P4    P2                         
*)
totFactor = ((4*GG^2*Vud^2*EE^2)/(9*MW^2*SW^2));
numerator =(2*SC[p1,p3]^2*SC[p1,p2]-2*SC[p1,p3]^2*MW^2+2*SC[p1,p3]*
 SC[p1,p2]*MW^2-SC[p1,p3]*MW^4);
denominator =(propDen[-p1+p3,0,0]^2);

addToSum;

(*
  Diagram  2 in subprocess 1
                                 !  W+    u                          
                                /!-->--@==>==                        
                                |!  P4 |  P1                         
                                |!    d|                             
                      u     G   |!  G  |  D                          
                    ==>==@------+!-----@==<==                        
                      P1 |  P3  |!  P3    P2                         
                        u|      |!                                   
                      D  |  W+  |!                                   
                    ==<==@-->---/!                                   
                      P2    P4   !                                   
*)
totFactor = ((8*GG^2*Vud^2*EE^2)/(9*MW^2*SW^2));
numerator =(2*SC[p1,p3]^2*SC[p1,p2]-2*SC[p1,p3]*SC[p1,p2]^2+SC[p1,p3]*
 SC[p1,p2]*MW^2+SC[p1,p2]*MW^4);
denominator =(propDen[-p1+p3,0,0]*propDen[-p1+p4,0,0]);

addToSum;

(*
  Diagram  3 in subprocess 1
                      u     W+   !  W+    u                          
                    ==>==@-->----!-->--@==>==                        
                      P1 |  P4   !  P4 |  P1                         
                        d|       !    d|                             
                      D  |  G    !  G  |  D                          
                    ==<==@-------!-----@==<==                        
                      P2    P3   !  P3    P2                         
*)
totFactor = ((2*GG^2*Vud^2*EE^2)/(9*MW^2*SW^2));
numerator =(4*SC[p1,p3]^2*SC[p1,p2]-4*SC[p1,p3]^2*MW^2-8*SC[p1,p3]*
 SC[p1,p2]^2+8*SC[p1,p3]*SC[p1,p2]*MW^2-2*SC[p1,p3]*MW^4+4*SC[p1,p2]^3-4*
 SC[p1,p2]^2*MW^2+SC[p1,p2]*MW^4);
denominator =(propDen[-p1+p4,0,0]^2);

addToSum;

finishSum;
