(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    781620,      26771]*)
(*NotebookOutlinePosition[    819316,      28063]*)
(*  CellTagsIndexPosition[    819272,      28059]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Read FeynArts File", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< /home/olness/feynarts/CODE/FeynArts.m\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"FeynArts 3.1"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn"\)], \
"Print"],

Cell[BoxData[
    \(TraditionalForm\`"last revised 3 Apr 03"\)], "Print"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examine FeynArts Functions", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FeynArts`*\)\)], "Input"],

Cell[BoxData[GridBox[{
        {
          StyleBox["FeynArts`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["ActualOptions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ActualOptions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Eight",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Eight"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GraphID",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`GraphID"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$GenericPropagators",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$GenericPropagators"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ScalarDash",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ScalarDash"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Topology",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Topology"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Adjacencies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Adjacencies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ExcludedQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ExcludedQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Greek",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Greek"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$LastGenericRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$LastGenericRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfConjugate",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SelfConjugate"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TopologyCode",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TopologyCode"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AllBoxCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`AllBoxCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ExcludeFieldPoints",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ExcludeFieldPoints"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Incoming",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Incoming"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$LastModelRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$LastModelRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SelfEnergies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TopologyList",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TopologyList"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AllBoxes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`AllBoxes"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ExcludeParticles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ExcludeParticles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Index",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Index"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$TruncationRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$TruncationRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergiesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SelfEnergiesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToTree",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`ToTree"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Alph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Alph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ExcludeTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ExcludeTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["IndexDelta",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`IndexDelta"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["NonCommutative",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`NonCommutative"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergyCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SelfEnergyCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TriangleCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TriangleCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AmplitudeLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`AmplitudeLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["External",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`External"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["IndexRange",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`IndexRange"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["NoUnfold",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`NoUnfold"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergyCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SelfEnergyCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TriangleCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TriangleCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AnalyticalCoupling",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`AnalyticalCoupling"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`F"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["IndexSum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`IndexSum"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Numbering",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Numbering"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Seq",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Seq"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Triangles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Triangles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AnalyticalPropagator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`AnalyticalPropagator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FAPrint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`FAPrint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Indices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Indices"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Outgoing",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Outgoing"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Shape",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Shape"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TrianglesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TrianglesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AntiParticle",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`AntiParticle"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FermionChain",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FermionChain"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InitializeModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`InitializeModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Paint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Paint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ShapeData",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ShapeData"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Truncated",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Truncated"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Appearance",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Appearance"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FeynAmp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`FeynAmp"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InsertFields",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`InsertFields"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PaintLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PaintLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SheetHeader",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SheetHeader"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["U",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`U"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AutoEdit",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`AutoEdit"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FeynAmpDenominator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FeynAmpDenominator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InsertionLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`InsertionLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Particles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Particles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Simple",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Simple"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["UCAlph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`UCAlph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Bicycle",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Bicycle"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FeynAmpList",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FeynAmpList"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Insertions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Insertions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["path",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`path"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Sine",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Sine"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["UCGreek",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`UCGreek"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["BoxCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`BoxCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FeynArtsGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FeynArtsGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InsertOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`InsertOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PickLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PickLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Spinor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Spinor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["V",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`V"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["BoxCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`BoxCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Field",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Field"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Integral",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Integral"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Pluralize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Pluralize"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["StartingTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`StartingTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Vertex",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Vertex"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Boxes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Boxes"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FieldNumbers",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FieldNumbers"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Internal",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Internal"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PossibleFields",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PossibleFields"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["StartTop",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`StartTop"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VertexFunction",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`VertexFunction"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["BoxesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`BoxesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FieldPoint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FieldPoint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`KI1"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PreFactor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PreFactor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Statistics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Statistics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VertexGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`VertexGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CanonicalOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`CanonicalOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FieldPoints",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FieldPoints"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`KI2"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Process",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Process"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Straight",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Straight"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Vertices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Vertices"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CC",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`CC"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["file",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`file"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`KI3"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Propagator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Propagator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SumOver",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`SumOver"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ViolatesQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ViolatesQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Centre",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Centre"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FindVertex",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FindVertex"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI4",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`KI4"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorArrow",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PropagatorArrow"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SV",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`SV"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VS",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`VS"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CheckFieldPoint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`CheckFieldPoint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FourMomentum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FourMomentum"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KinematicIndices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`KinematicIndices"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorDenominator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PropagatorDenominator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SVCompatibles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SVCompatibles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VSort",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`VSort"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Classes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Classes"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FreeWFQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`FreeWFQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KinematicVector",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`KinematicVector"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PropagatorGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SymmetryFactor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`SymmetryFactor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["WFCorrectionCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`WFCorrectionCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ColumnsXRows",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ColumnsXRows"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["full",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`full"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KIs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`KIs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorLabel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PropagatorLabel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TadpoleCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TadpoleCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["WFCorrections",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`WFCorrections"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Compare",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Compare"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Full",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Full"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["LastSelections",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`LastSelections"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorType",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`PropagatorType"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TadpoleCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TadpoleCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$CounterTerms",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$CounterTerms"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Compatibles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Compatibles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FullFileName",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`FullFileName"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Loop",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Loop"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PSort",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`PSort"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Tadpoles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Tadpoles"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ExcludedFPs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$ExcludedFPs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ComposedChar",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ComposedChar"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllClasses",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$AllClasses"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["LoopNumber",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`LoopNumber"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PV",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`PV"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TadpolesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TadpolesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ExcludedParticleFPs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$ExcludedParticleFPs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ConjugateCoupling",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ConjugateCoupling"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllGeneric",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$AllGeneric"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["L$CTOrders",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`L$CTOrders"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["P$Generic",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`P$Generic"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TakeGraph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`TakeGraph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ExcludeTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$ExcludeTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ContainsQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ContainsQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllowedFields",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$AllowedFields"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Mass",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Mass"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["P$NonCommuting",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`P$NonCommuting"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TakeInc",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`TakeInc"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FermionLines",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$FermionLines"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateCTTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`CreateCTTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllParticles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$AllParticles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MatrixTrace",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`MatrixTrace"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["P$Topology",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`P$Topology"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TakeIns",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`TakeIns"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FeynArts",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$FeynArts"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateFeynAmp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`CreateFeynAmp"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$Classes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$Classes"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MatrixTraceFactor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`MatrixTraceFactor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["QuantumNumbers",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`QuantumNumbers"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TheC",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`TheC"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FeynArtsDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$FeynArtsDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`CreateTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$Generic",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$Generic"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MixingPartners",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`MixingPartners"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ReferenceOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ReferenceOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TheLabel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`TheLabel"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FeynArtsProgramDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$FeynArtsProgramDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateVFTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`CreateVFTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$Particles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`F$Particles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Model",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Model"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Reinitialize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Reinitialize"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TheMass",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`TheMass"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$GenericModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$GenericModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CTOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`CTOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["G",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`G"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Mom",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Mom"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["RelativeCF",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`RelativeCF"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Theta",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Theta"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$Model",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`$Model"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Cycles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Cycles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GaugeRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`GaugeRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MomentumConservation",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`MomentumConservation"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Render",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Render"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Three",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Three"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ModelPath",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$ModelPath"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Diagonal",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Diagonal"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GaugeXi",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`GaugeXi"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$ClassesDescription",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$ClassesDescription"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ResolveLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ResolveLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ThreeRed",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`ThreeRed"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ShapeDataDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$ShapeDataDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["DiagramGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`DiagramGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GenericModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`GenericModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$CouplingMatrices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$CouplingMatrices"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["RestrictCurrentModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`RestrictCurrentModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToClasses",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ToClasses"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$SVMixing",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`$SVMixing"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["DiagramSelect",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`DiagramSelect"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GhostDash",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`GhostDash"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$FlippingRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$FlippingRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Restrictions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`Restrictions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToFA1Conventions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ToFA1Conventions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$Verbose",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`$Verbose"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Discard",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Discard"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Graph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`Graph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$GenericCouplings",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`M$GenericCouplings"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["S",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262844159-1499687", "FeynArts`S"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToGeneric",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262844159-1499687", 
                    "FeynArts`ToGeneric"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], ""}
              },
            
            RowMinHeight->{
              1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  CellMargins->{{20, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->GrayLevel[0.930022],
  ButtonBoxOptions->{Active->True}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drell-Yan Production:", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(\(tops = 
        CreateTopologies[0, 4, 
          ExcludeTopologies \[Rule] {}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[
          tops, {F[3, {1}], \(-F[3, {1}]\)} \[Rule] {F[
                2, {1}], \(-F[2, {1}]\)}, Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}, 
          ExcludeParticles -> {{S[1], S[2], S[3]}}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Paint[ins, ColumnsXRows \[Rule] {2, 1}, 
        PaintLevel \[Rule] {Classes}];\)\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Excluding "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]4\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]4\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Excluding ", 0, " Generic, ", 4, " Classes, and ", 4, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"2 Classes insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 4, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes insertions"\
\),
        SequenceForm[ "in total: ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Restoring "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]4\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]4\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Restoring ", 0, " Generic, ", 4, " Classes, and ", 4, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"2 diagrams"\),
        SequenceForm[ "> Top. ", 1, ": ", "2 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 -1.40675e-17 0.0227273 [
[ 0 0 0 0 ]
[ 1 .65 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65 L
0 .65 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -1.40675e-17 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.31818 .5 L
s
.20277 .59618 m
.14923 .61713 L
.17251 .64506 L
F
gsave
.16421 .587 -74.125 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.31818 .5 L
s
.16087 .3689 m
.21441 .38986 L
.19113 .41779 L
F
gsave
.19943 .35973 -61 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.68182 .5 L
s
.83913 .6311 m
.78559 .61014 L
.80887 .58221 L
F
gsave
.80057 .64027 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.68182 .5 L
s
.79723 .40382 m
.85077 .38287 L
.82749 .35494 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -67.3438 -17.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N1) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -1.40675e-17 1 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.31818 .5 L
s
.20277 .59618 m
.14923 .61713 L
.17251 .64506 L
F
gsave
.16421 .587 -74.125 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.31818 .5 L
s
.16087 .3689 m
.21441 .38986 L
.19113 .41779 L
F
gsave
.19943 .35973 -61 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.68182 .5 L
s
.83913 .6311 m
.78559 .61014 L
.80887 .58221 L
F
gsave
.80057 .64027 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.68182 .5 L
s
.79723 .40382 m
.85077 .38287 L
.82749 .35494 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -68 -19.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Z) show
73.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C2) show
102.375 14.688 moveto
(N2) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59 -71.0938 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.312 moveto
(\\256) show
79.188 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 .59 -68.4688 -11.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.1875 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 .59 -68.4688 -11.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.1875 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 187.188},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`000162000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`002P3oool00`000000oooo0?ooo`300?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`090?ooo`002`3o
ool00`000000oooo0?ooo`2n0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0_P3o
ool00`000000oooo0?ooo`0:0?ooo`00303oool200000;`0oooo0P00000G0?ooo`800000_03oool2
000000d0oooo000=0?ooo`800000^P3oool2000001T0oooo0P00002j0?ooo`8000003P3oool000h0
oooo0P00002h0?ooo`8000006`3oool200000;P0oooo0P00000?0?ooo`00403oool00`000000oooo
0?ooo`2d0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0]03oool00`000000oooo
0?ooo`0?0?ooo`004@3oool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo01l0oooo00<0
00000?ooo`3oool0/P3oool00`000000oooo0?ooo`0@0?ooo`004P3oool200000;00oooo0P00000S
0?ooo`800000/03oool2000001<0oooo000C0?ooo`800000[P3oool2000002D0oooo0P00002^0?oo
o`800000503oool001@0oooo0P00002/0?ooo`8000009`3oool200000:`0oooo0P00000E0?ooo`00
5P3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
Z03oool00`000000oooo0?ooo`0E0?ooo`005`3oool00`000000oooo0?ooo`2V0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`0F0?ooo`00603oool0
0`000000oooo0?ooo`2T0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0Y03oool0
0`000000oooo0?ooo`0G0?ooo`006@3oool200000:80oooo0P00000a0?ooo`800000XP3oool20000
01X0oooo000J0?ooo`800000X03oool2000003<0oooo0P00002P0?ooo`8000006`3oool001/0oooo
0P00002N0?ooo`800000=@3oool2000009h0oooo0P00000L0?ooo`007@3oool00`000000oooo0?oo
o`2J0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?oo
o`0L0?ooo`007P3oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo03T0oooo00<00000
0?ooo`3oool0V03oool00`000000oooo0?ooo`0M0?ooo`007`3oool2000009H0oooo0P00000m0?oo
o`800000UP3oool200000200oooo000P0?ooo`800000T03oool010000000oooo0?ooo`3oool20000
03l0oooo0P00002@0?ooo`040000003oool0oooo0?ooo`8000008@3oool00240oooo0P00002>0?oo
o`<0000000<0oooo000000000000@@3oool2000008h0oooo0`0000000`3oool000000000000R0?oo
o`008`3oool00`000000oooo0?ooo`2;0?ooo`@00000A@3oool00`000000oooo0?ooo`2;0?ooo`@0
0000903oool002<0oooo0P00002;0?ooo`H00000A@3oool2000008X0oooo1P00000S0?ooo`00903o
ool3000008P0oooo200000150?ooo`<00000R03oool700000280oooo000T0?ooo`H00000Q@3oool8
000004D0oooo1@0000250?ooo`P000008P3oool002D0oooo1`0000220?ooo`L00000B03oool60000
08<0oooo1P00000T0?ooo`009P3oool8000007l0oooo1P00001:0?ooo`P00000P03oool5000002H0
oooo000V0?ooo`P00000O`3oool3000004h0oooo1`00001o0?ooo`@00000:03oool002L0oooo1P00
001o0?ooo`800000D03oool6000007l0oooo0`00000Z0?ooo`00:03oool6000007`0oooo0P00001C
0?ooo`H00000O03oool2000002d0oooo000X0?ooo`<000000P3oool2000007X0oooo0P00001D0?oo
o`<000000P3oool2000007X0oooo0P00000^0?ooo`00:@3oool00`000000oooo0?ooo`020?ooo`80
0000N03oool2000005H0oooo00<000000?ooo`3oool00P3oool2000007P0oooo0P00000_0?ooo`00
<03oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0
M03oool00`000000oooo0?ooo`0_0?ooo`00<@3oool00`000000oooo0?ooo`1b0?ooo`030000003o
ool0oooo05l0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`0`0?ooo`00<P3oool2
00000700oooo0P00001S0?ooo`800000L03oool2000003<0oooo000c0?ooo`800000KP3oool20000
06D0oooo0P00001^0?ooo`800000=03oool003@0oooo0P00001/0?ooo`800000I`3oool2000006`0
oooo0P00000e0?ooo`00=P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`0e0?ooo`00=`3oool00`000000oooo0?oo
o`1V0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?oo
o`0f0?ooo`00>03oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo06d0oooo00<00000
0?ooo`3oool0I03oool00`000000oooo0?ooo`0g0?ooo`00>@3oool200000680oooo0P00001a0?oo
o`800000HP3oool2000003X0oooo000j0?ooo`800000H03oool2000007<0oooo0P00001P0?ooo`80
0000>`3oool003/0oooo0P00001N0?ooo`800000M@3oool2000005h0oooo0P00000l0?ooo`00?@3o
ool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0FP3o
ool00`000000oooo0?ooo`0l0?ooo`00?P3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0
oooo07T0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`0m0?ooo`00?`3oool20000
05H0oooo0P00001m0?ooo`800000EP3oool200000400oooo00100?ooo`L00000BP3oool7000007l0
oooo0P0000000`3oool0000000000003000004T0oooo1`0000110?ooo`00@@3oool7000000P0oooo
1000000>0?ooo`@00000303oool4000000h0oooo100000080?ooo`L00000P@3oool8000000L0oooo
1000000>0?ooo`@00000303oool4000000h0oooo100000080?ooo`L00000@P3oool00440oooo1`00
00060?ooo`800000103oool00`000000oooo0?ooo`090?ooo`800000103oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0080oooo0P00000;0?ooo`030000003oool0oooo0080oooo0P00
00060?ooo`L00000PP3oool7000000D0oooo0P0000040?ooo`030000003oool0oooo00T0oooo0P00
00040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool2000000/0oooo00<0
00000?ooo`3oool00P3oool2000000H0oooo1`0000120?ooo`00@03oool8000000D0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`P00000P@3oool8000000@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`P00000@P3oool00440oooo1`0000040?oo
o`030000003oool0oooo00L0oooo0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0P0000090?oo
o`030000003oool0oooo0080oooo1`0000220?ooo`L000000`3oool00`000000oooo0?ooo`070?oo
o`8000001P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`040?ooo`8000002@3oool00`000000oooo0?ooo`020?oo
o`L00000@P3oool00440oooo1`0000020?ooo`800000303oool010000000oooo0?ooo`3oool20000
00X0oooo0P0000030?ooo`8000002`3oool2000000<0oooo00<000000?ooo`3oool02P3oool20000
0080oooo1`0000210?ooo`P0000000<0oooo000000000000303oool010000000oooo0?ooo`3oool2
000000/0oooo0P0000030?ooo`8000002P3oool2000000<0oooo00<000000?ooo`3oool02P3oool2
00000080oooo1`0000120?ooo`00@03oool:000000l0oooo0`00000>0?ooo`<000003`3oool30000
00l0oooo2P00001o0?ooo`80000000<0oooo0000000000001@00000?0?ooo`<000003`3oool30000
00h0oooo0`00000?0?ooo`X00000@@3oool003l0oooo0P0000030?ooo`030000003oool0oooo04`0
oooo00@000000?ooo`3oool0oooo0P00001m0?ooo`800000103oool00`000000oooo0?ooo`1;0?oo
o`040000003oool0oooo0?ooo`800000@03oool003h0oooo00<000000?ooo`3oool0F03oool00`00
0000oooo0?ooo`1i0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0?@3oool003d0
oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05X0
oooo00<000000?ooo`3oool0?03oool003/0oooo0P00001N0?ooo`800000M@3oool2000005h0oooo
0P00000l0?ooo`00>P3oool200000600oooo0P00001c0?ooo`800000H03oool2000003/0oooo000i
0?ooo`800000HP3oool200000740oooo0P00001R0?ooo`800000>P3oool003P0oooo00<000000?oo
o`3oool0I03oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo06@0oooo00<000000?oo
o`3oool0=`3oool003L0oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?ooo`1[0?ooo`03
0000003oool0oooo06H0oooo00<000000?ooo`3oool0=P3oool003H0oooo00<000000?ooo`3oool0
J03oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0
=@3oool003@0oooo0P00001/0?ooo`800000I`3oool2000006`0oooo0P00000e0?ooo`00<`3oool2
000006h0oooo0P00001U0?ooo`800000KP3oool2000003@0oooo000b0?ooo`800000L03oool20000
06<0oooo0P00001`0?ooo`800000<`3oool00340oooo00<000000?ooo`3oool0LP3oool00`000000
oooo0?ooo`1O0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0<03oool00300oooo
00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo07@0oooo
00<000000?ooo`3oool0;`3oool002h0oooo0P00001h0?ooo`800000F`3oool2000007P0oooo0P00
000_0?ooo`00;@3oool2000007X0oooo0P0000030?ooo`030000003oool0oooo05<0oooo0P00001j
0?ooo`8000000`3oool00`000000oooo0?ooo`0X0?ooo`00;03oool2000007`0oooo0P000000103o
ool0000000000000001C0?ooo`800000O03oool2000000040?ooo`0000000000000002T0oooo000[
0?ooo`030000003oool0oooo07h0oooo1000001B0?ooo`030000003oool0oooo07h0oooo1000000Y
0?ooo`00:@3oool200000800oooo1P00001@0?ooo`800000O`3oool6000002P0oooo000W0?ooo`<0
0000P03oool7000004h0oooo0`00001o0?ooo`P000009`3oool002D0oooo1@00001o0?ooo`T00000
BP3oool6000007h0oooo2@00000W0?ooo`008`3oool6000008<0oooo1P0000180?ooo`L00000PP3o
ool7000002H0oooo000P0?ooo`T00000Q@3oool5000004@0oooo2@0000250?ooo`H000009@3oool0
0240oooo1`0000280?ooo`@00000A03oool8000008P0oooo0`00000U0?ooo`008P3oool6000008X0
oooo0`0000140?ooo`H00000R`3oool2000002@0oooo000Q0?ooo`H00000SP3oool200000440oooo
1P00002>0?ooo`8000008P3oool00200oooo0P0000020?ooo`<00000S`3oool2000003l0oooo0P00
00020?ooo`<00000S`3oool200000240oooo000O0?ooo`800000103oool00`000000oooo0?ooo`2?
0?ooo`800000?@3oool2000000@0oooo00<000000?ooo`3oool0S`3oool200000200oooo000N0?oo
o`030000003oool0oooo09P0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`2H0?oo
o`030000003oool0oooo01d0oooo000M0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo01`0oooo000K0?ooo`800000
WP3oool2000003D0oooo0P00002N0?ooo`800000703oool001X0oooo0P00002P0?ooo`800000<`3o
ool200000:00oooo0P00000K0?ooo`006@3oool200000:80oooo0P00000a0?ooo`800000XP3oool2
000001X0oooo000H0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0;@3oool00`00
0000oooo0?ooo`2T0?ooo`030000003oool0oooo01L0oooo000G0?ooo`030000003oool0oooo0:H0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo01H0
oooo000F0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0:@3oool00`000000oooo
0?ooo`2X0?ooo`030000003oool0oooo01D0oooo000D0?ooo`800000[03oool2000002L0oooo0P00
002/0?ooo`8000005@3oool001<0oooo0P00002^0?ooo`8000009@3oool200000:h0oooo0P00000D
0?ooo`004P3oool200000;00oooo0P00000S0?ooo`800000/03oool2000001<0oooo000A0?ooo`03
0000003oool0oooo0;80oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`2b0?ooo`03
0000003oool0oooo0100oooo000@0?ooo`030000003oool0oooo0;@0oooo00<000000?ooo`3oool0
7@3oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo00l0oooo000>0?ooo`800000^03o
ool2000001/0oooo0P00002h0?ooo`8000003`3oool000d0oooo0P00002j0?ooo`8000006@3oool2
00000;X0oooo0P00000>0?ooo`00303oool200000;`0oooo0P00000G0?ooo`800000_03oool20000
00d0oooo000;0?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`2n0?ooo`030000003oool0oooo00X0oooo000:0?ooo`030000003oool0oooo0<00oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo00T0oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {279.75, 0}} -> {-0.0314566, 6.18969*^-16, \
0.153351, 0.153351}, {{0.25, 215.5}, {279.75, 64.5}} -> {-1.02566, -1.00011, \
0.153312, 0.153312}, {{215.5, 430.688}, {279.75, 64.5}} -> {-23.0323, \
-1.0033, 0.153356, 0.153356}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp = CreateFeynAmp[ins]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"2 Classes amplitudes"\),
        SequenceForm[ "> Top. ", 1, ": ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes amplitudes"\
\),
        SequenceForm[ "in total: ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), ",", 
            RowBox[{"ExcludeParticles", "\[Rule]", 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(S(1)\), \(S(2)\), \(S(3)\)}
                    }], "\[NoBreak]", ")"}]}], 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(-\(F(3, {1})\)\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MU"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(2, {1})\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "ME"},
                      {\(-\(F(2, {1})\)\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "ME"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                  Number == 1)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("v"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]2\),
                              SequenceForm[ "p", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                            "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "-", 
                          
                          RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                            " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]1\),
                              SequenceForm[ "p", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]1\),
                              SequenceForm[ "k", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "ME"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "+", 
                          RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"\<\"v\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]2\),
                              SequenceForm[ "k", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "ME"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  RowBox[{"IndexDelta", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  RowBox[{
                    FormBox["\<\"g\"\>",
                      "TraditionalForm"], "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  FormBox[
                    FractionBox["1", 
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}]}]}], ")"}], ",", 
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 2, 
                  Number == 2)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("v"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]2\),
                              SequenceForm[ "p", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          FractionBox[
                            RowBox[{
                            "\[ImaginaryI]", " ", "EL", 
                              " ", \((1\/2 - \(2\ SW\^2\)\/3)\), " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(CW\ SW\)], "-", 
                          FractionBox[
                            RowBox[{
                            "2", " ", "\[ImaginaryI]", " ", "EL", " ", "SW", 
                              " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(3\ CW\)]}], ")"}], 
                      ".", 
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]1\),
                              SequenceForm[ "p", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]1\),
                              SequenceForm[ "k", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "ME"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          FractionBox[
                            RowBox[{
                            "\[ImaginaryI]", " ", "EL", 
                              " ", \((SW\^2 - 1\/2)\), " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(CW\ SW\)], "+", 
                          FractionBox[
                            RowBox[{
                            "\[ImaginaryI]", " ", "EL", " ", "SW", " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], "CW"]}], ")"}], ".", 
                      RowBox[{"\<\"v\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]2\),
                              SequenceForm[ "k", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "ME"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  RowBox[{"IndexDelta", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  RowBox[{
                    FormBox["\<\"g\"\>",
                      "TraditionalForm"], "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], "+", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MZ\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}]}]}], ")"}]}], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp\  // Length\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(strm = OpenWrite["\<test.amp\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`OutputStream["test.amp", 8]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Write[strm, famp2]\), "\[IndentingNewLine]", 
    \(Close[strm]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"test.amp"\)], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Direct Photon Production:", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(\(tops = 
        CreateTopologies[0, 4];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[tops, {V[5], F[3, {1}]} \[Rule] {V[1], F[3, {1}]}, 
          Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Paint[ins, ColumnsXRows \[Rule] {2, 1}, 
        PaintLevel \[Rule] {Classes}];\)\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 4, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes insertions"\
\),
        SequenceForm[ "in total: ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 -1.40675e-17 0.0227273 [
[ 0 0 0 0 ]
[ 1 .65 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65 L
0 .65 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -1.40675e-17 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.31818 .5 m
.31135 .50005 L
.30457 .50126 L
.29808 .50362 L
.29211 .50709 L
.28685 .51156 L
.28247 .51691 L
.27911 .52294 L
.27683 .52943 L
.27568 .53616 L
.27564 .54287 L
.27663 .54932 L
.27854 .55528 L
.28122 .56053 L
.28446 .5649 L
.28805 .56824 L
.29176 .57047 L
.29535 .57154 L
.29858 .57146 L
.30124 .5703 L
.30313 .56816 L
.30409 .56521 L
.30402 .56163 L
.30284 .55766 L
.30053 .55352 L
.29714 .54947 L
.29274 .54574 L
.28746 .54257 L
.28147 .54017 L
.27497 .53869 L
.26819 .53827 L
.26135 .53898 L
.25472 .54086 L
.2485 .54386 L
.24291 .54793 L
.23814 .55293 L
.23434 .55869 L
.23159 .56501 L
.22997 .57167 L
.22946 .57842 L
.23002 .58501 L
.23156 .59121 L
.23394 .59678 L
.23696 .60154 L
.24044 .60534 L
.24413 .60805 L
.2478 .60961 L
.25121 .61001 L
.25413 .6093 L
.25637 .60756 L
Mistroke
.25774 .60493 L
.25812 .60159 L
.25741 .59776 L
.25558 .59366 L
.25264 .58954 L
.24866 .58565 L
.24373 .58222 L
.23802 .57947 L
.23171 .57758 L
.22502 .5767 L
.21818 .57692 L
.21143 .5783 L
.205 .58084 L
.19913 .58447 L
.19399 .58909 L
.18976 .59455 L
.18656 .60066 L
.18446 .60721 L
.18348 .61395 L
.1836 .62063 L
.18474 .62703 L
.18677 .63289 L
.18955 .63802 L
.19286 .64224 L
.19649 .64542 L
.2002 .64747 L
.20374 .64836 L
.2069 .64812 L
.20945 .6468 L
.21121 .64453 L
.21202 .64147 L
.21178 .63781 L
.21043 .6338 L
.20796 .62966 L
.20441 .62564 L
.19986 .62198 L
.19446 .61892 L
.18838 .61665 L
.18182 .61532 L
.17502 .61507 L
.1682 .61596 L
.16161 .61801 L
.15548 .62118 L
.15 .6254 L
.14537 .63053 L
.14172 .63639 L
.13915 .64278 L
.13769 .64947 L
.13735 .65621 L
.13807 .66275 L
Mistroke
.13975 .66887 L
.14223 .67433 L
.14534 .67895 L
.14887 .68259 L
.15257 .68513 L
.15621 .68651 L
.15956 .68674 L
.1624 .68587 L
.16451 .68398 L
.16574 .68123 L
.16596 .67781 L
.16508 .67392 L
.16308 .6698 L
.15998 .6657 L
.15584 .66186 L
.15079 .65852 L
.14497 .65589 L
.13859 .65415 L
.13186 .65343 L
.12502 .65383 L
.1183 .65539 L
.11195 .65809 L
.10617 .66188 L
.10117 .66664 L
.09709 .67221 L
.09405 .67841 L
.09211 .685 L
.0913 .69175 L
.09159 .6984 L
.09287 .70473 L
.09503 .71049 L
.0979 .7155 L
.10128 .71957 L
.10493 .72258 L
.10863 .72446 L
.11214 .72517 L
.11521 .72476 L
.11766 .72328 L
.11928 .72088 L
.11994 .71772 L
.11953 .714 L
.11801 .70995 L
.11537 .70581 L
.11166 .70183 L
.10697 .69825 L
.10146 .6953 L
.09529 .69316 L
.08868 .69199 L
.08186 .69191 L
.07506 .69297 L
Mistroke
.06853 .6952 L
.06248 .69854 L
.05713 .7029 L
.05264 .70815 L
.04915 .71411 L
.04674 .72056 L
.04545 .72727 L
Mfstroke
gsave
.16421 .587 -74.125 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68789 .49982 L
.69364 .50004 L
.69875 .50101 L
.70303 .50299 L
.70636 .5061 L
.70878 .5103 L
.71042 .51544 L
.71153 .52123 L
.71241 .52728 L
.7134 .5332 L
.71483 .53859 L
.71697 .54313 L
.71999 .54662 L
.72396 .54896 L
.72881 .55025 L
.73437 .55069 L
.74037 .5506 L
.74649 .55037 L
.75238 .55041 L
.75773 .5511 L
.7623 .55272 L
.76595 .55545 L
.76867 .5593 L
.77055 .56415 L
.7718 .56976 L
.77272 .57577 L
.77363 .58178 L
.77489 .58739 L
.77676 .59224 L
.77948 .59609 L
.78314 .59881 L
.78771 .60044 L
.79306 .60113 L
.79895 .60117 L
.80506 .60094 L
.81106 .60085 L
.81662 .60129 L
.82148 .60257 L
.82545 .60492 L
.82847 .6084 L
.83061 .61294 L
.83204 .61833 L
.83303 .62425 L
.83391 .63031 L
.83502 .63609 L
.83666 .64123 L
.83908 .64544 L
.84242 .64854 L
.8467 .65052 L
Mistroke
.85181 .65149 L
.85755 .65171 L
.86363 .65153 L
.8697 .65134 L
.87544 .65156 L
.88056 .65254 L
.88483 .65451 L
.88817 .65762 L
.89059 .66182 L
.89224 .66696 L
.89334 .67275 L
.89422 .6788 L
.89521 .68472 L
.89665 .69011 L
.89879 .69465 L
.90181 .69813 L
.90578 .70048 L
.91063 .70176 L
.9162 .7022 L
.9222 .70211 L
.92831 .70188 L
.9342 .70192 L
.93955 .70261 L
.94412 .70423 L
.94778 .70695 L
.95049 .7108 L
.95237 .71566 L
.95363 .72126 L
.95455 .72727 L
Mfstroke
gsave
.80057 .64027 -73.6875 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.68182 .5 L
s
.52727 .5 m
.47273 .48182 L
.47273 .51818 L
F
gsave
.5 .45704 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N1) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -1.40675e-17 1 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.5 .68182 m
.49395 .67778 L
.48723 .67489 L
.48007 .67331 L
.47275 .67313 L
.46552 .67438 L
.45868 .677 L
.45245 .68086 L
.44707 .68578 L
.4427 .6915 L
.43947 .69774 L
.43742 .70417 L
.43657 .71049 L
.43684 .71636 L
.43812 .72148 L
.44022 .72561 L
.44292 .72854 L
.44598 .73011 L
.44913 .73027 L
.45209 .72901 L
.4546 .72641 L
.45641 .72262 L
.45732 .71785 L
.45718 .71236 L
.45588 .70644 L
.45338 .70042 L
.44971 .69462 L
.44494 .68937 L
.43921 .68494 L
.43273 .68158 L
.42571 .67947 L
.41842 .67874 L
.41112 .67943 L
.4041 .68153 L
.3976 .68492 L
.39187 .68945 L
.38709 .69489 L
.3834 .70097 L
.38088 .70737 L
.37957 .71377 L
.37941 .71985 L
.38032 .7253 L
.38212 .72984 L
.38462 .73326 L
.38757 .73537 L
.39072 .73609 L
.39378 .73538 L
.39649 .73329 L
.3986 .72994 L
.39989 .72553 L
Mistroke
.40017 .72028 L
.39934 .71449 L
.39731 .70847 L
.39408 .70255 L
.38973 .69705 L
.38436 .69226 L
.37814 .68846 L
.3713 .68584 L
.36409 .68457 L
.35676 .6847 L
.3496 .68626 L
.34287 .68916 L
.33681 .69328 L
.33164 .69839 L
.32751 .70425 L
.32453 .71056 L
.32275 .717 L
.32215 .72325 L
.32265 .72898 L
.32413 .73391 L
.32638 .73779 L
.32919 .74042 L
.33229 .74169 L
.33542 .74154 L
.3383 .73998 L
.34067 .7371 L
.34231 .73308 L
.343 .72812 L
.34261 .72251 L
.34105 .71654 L
.33829 .71055 L
.33437 .70484 L
.32937 .69974 L
.32346 .69553 L
.31684 .69243 L
.30974 .69061 L
.30242 .69019 L
.29516 .6912 L
.28823 .69359 L
.28189 .69725 L
.27635 .70201 L
.27179 .70761 L
.26836 .71378 L
.26611 .72021 L
.26505 .72657 L
.26514 .73254 L
.26626 .73781 L
.26823 .74213 L
.27085 .74527 L
.27387 .74708 L
Mistroke
.27702 .74748 L
.28003 .74647 L
.28263 .74409 L
.28458 .74049 L
.28566 .73587 L
.28571 .73048 L
.28461 .72461 L
.28232 .71859 L
.27884 .71273 L
.27425 .70736 L
.26868 .70277 L
.26231 .69921 L
.25536 .69688 L
.24809 .69591 L
.24078 .69636 L
.23369 .69822 L
.22709 .7014 L
.22121 .70575 L
.21625 .71106 L
.21237 .71704 L
.20965 .72341 L
.20813 .72983 L
.20779 .73599 L
.20852 .74157 L
.21018 .74629 L
.21257 .74991 L
.21547 .75226 L
.2186 .75322 L
.2217 .75275 L
.22449 .75089 L
.22672 .74775 L
.22816 .7435 L
.22863 .73838 L
.22799 .73266 L
.22616 .72666 L
.22314 .7207 L
.21897 .71511 L
.21377 .71018 L
.20768 .70619 L
.20093 .70336 L
.19376 .70184 L
.18643 .70174 L
.17922 .70305 L
.1724 .70573 L
.16621 .70965 L
.16088 .71461 L
.15656 .72037 L
.15338 .72662 L
.15139 .73306 L
.1506 .73936 L
Mistroke
.15092 .7452 L
.15224 .75029 L
.15437 .75437 L
.1571 .75723 L
.16017 .75874 L
.16332 .75883 L
.16626 .7575 L
.16874 .75485 L
.17051 .751 L
.17138 .74619 L
.17118 .74067 L
.16983 .73474 L
.16727 .72873 L
.16354 .72295 L
.15872 .71773 L
.15296 .71335 L
.14644 .71004 L
.1394 .708 L
.1321 .70733 L
.12481 .7081 L
.11781 .71026 L
.11135 .71371 L
.10565 .71829 L
.10092 .72377 L
.09729 .72987 L
.09483 .73627 L
.09358 .74267 L
.09347 .74873 L
.09442 .75414 L
.09626 .75864 L
.09879 .76199 L
.10176 .76404 L
.10491 .76469 L
.10796 .76391 L
.11065 .76176 L
.11273 .75836 L
.11397 .7539 L
.1142 .74862 L
.11331 .74282 L
.11122 .73679 L
.10794 .73089 L
.10353 .72541 L
.09812 .72067 L
.09187 .71692 L
.085 .71436 L
.07777 .71315 L
.07045 .71336 L
.0633 .71498 L
.0566 .71795 L
.05058 .72212 L
Mistroke
.04545 .72727 L
Mfstroke
gsave
.26572 .66193 -67.5625 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.5 .31818 L
s
.29986 .29817 m
.2474 .27465 L
.24378 .31083 L
F
gsave
.27974 .25284 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.50601 .31833 L
.5117 .31883 L
.51679 .32 L
.52107 .32207 L
.52443 .32516 L
.52687 .32926 L
.52852 .33425 L
.52958 .33989 L
.53034 .34587 L
.53113 .35182 L
.53225 .35739 L
.53399 .36227 L
.53656 .36624 L
.54004 .36919 L
.54444 .37113 L
.54962 .3722 L
.55537 .37263 L
.5614 .37276 L
.56738 .37293 L
.57301 .3735 L
.578 .37478 L
.58216 .37698 L
.5854 .38021 L
.58773 .38444 L
.58928 .38953 L
.59028 .39524 L
.59103 .40123 L
.59184 .40715 L
.59304 .41264 L
.59488 .41742 L
.59756 .42126 L
.60117 .42407 L
.60568 .42588 L
.61095 .42684 L
.61676 .42722 L
.6228 .42733 L
.62876 .42753 L
.63431 .42818 L
.6392 .42957 L
.64324 .43191 L
.64635 .43527 L
.64857 .43963 L
.65004 .44482 L
.65099 .45058 L
.65173 .45658 L
.65257 .46247 L
.65384 .46788 L
.65578 .47254 L
.65859 .47625 L
Mistroke
.66232 .47892 L
.66694 .48061 L
.6723 .48148 L
.67816 .48179 L
.68421 .48189 L
.69013 .48214 L
.69561 .48287 L
.70039 .48438 L
.70431 .48684 L
.7073 .49035 L
.70941 .49483 L
.71079 .50011 L
.7117 .50593 L
.71243 .51193 L
.71331 .51777 L
.71466 .5231 L
.71671 .52764 L
.71964 .53121 L
.72349 .53375 L
.72822 .53531 L
.73367 .53609 L
.73957 .53636 L
.74562 .53645 L
.75149 .53675 L
.75689 .53757 L
.76157 .53919 L
.76537 .5418 L
.76823 .54543 L
.77023 .55003 L
.77154 .55541 L
.7724 .56127 L
.77314 .56727 L
.77407 .57306 L
.77549 .5783 L
.77766 .58272 L
.78071 .58615 L
.78469 .58855 L
.78952 .59 L
.79504 .59069 L
.80098 .59091 L
.80703 .59102 L
.81286 .59136 L
.81817 .59227 L
.82274 .59402 L
.82641 .59676 L
.82916 .60053 L
.83105 .60525 L
.83228 .61071 L
.83311 .61661 L
.83386 .6226 L
Mistroke
.83484 .62834 L
.83635 .63348 L
.83862 .63778 L
.8418 .64107 L
.8459 .64334 L
.85084 .64467 L
.85643 .64528 L
.8624 .64546 L
.86844 .64558 L
.87422 .64598 L
.87945 .64699 L
.8839 .64886 L
.88745 .65174 L
.89007 .65565 L
.89187 .66047 L
.89303 .66601 L
.89383 .67194 L
.89458 .67793 L
.89562 .6836 L
.89722 .68864 L
.89961 .69281 L
.90291 .69596 L
.90713 .6981 L
.91217 .69932 L
.91783 .69985 L
.92383 .7 L
.92985 .70013 L
.93557 .7006 L
.94071 .70171 L
.94505 .70371 L
.94847 .70673 L
.95098 .71077 L
.95267 .7157 L
.95377 .72131 L
.95455 .72727 L
Mfstroke
gsave
.81534 .64005 -73.6875 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.5 .68182 L
s
.74754 .45903 m
.71916 .50903 L
.69484 .482 L
F
gsave
.84375 .41277 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .52727 m
.48182 .47273 L
.51818 .47273 L
F
gsave
.46158 .5 -74.125 -10.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N2) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 .59 -68.4688 -12.4688 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.9375 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59 -71.0938 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.312 moveto
(\\256) show
79.188 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 .59 -68.2188 -12.1562 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.438 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{250.375, 162.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000m2000`400?l00000o`00003oo`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00203oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo00h0oooo1@00002U0?oo
o`030000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3o
ool0503oool:000009X0oooo00<000000?ooo`3oool0203oool000X0oooo00<000000?ooo`3oool0
X`3oool00`000000oooo0?ooo`0O0?ooo`T000003P3oool3000007l0oooo00<000000?ooo`3oool0
2@3oool000/0oooo0P00002Q0?ooo`800000:`3oool:000000@0oooo1@00001l0?ooo`030000003o
ool0oooo00X0oooo000=0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3oool0=@3oool<
000007P0oooo00<000000?ooo`3oool02`3oool000h0oooo00<000000?ooo`3oool0V`3oool00`00
0000oooo0?ooo`0j0?ooo`h00000L03oool2000000h0oooo000?0?ooo`030000003oool0oooo09T0
oooo00<000000?ooo`3oool0>`3oool7000000L0oooo2P00000F0?ooo`@00000B`3oool00`000000
oooo0?ooo`0>0?ooo`00403oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo03`0oooo
0`00000E0?ooo`T00000303oool6000004T0oooo00<000000?ooo`3oool03`3oool00140oooo0P00
002E0?ooo`800000H03oool:00000080oooo1P0000180?ooo`030000003oool0oooo0100oooo000C
0?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool0JP3oool8000004L0oooo00<00000
0?ooo`3oool04@3oool001@0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`1]0?oo
o`P00000A03oool00`000000oooo0?ooo`0B0?ooo`005@3oool00`000000oooo0?ooo`2=0?ooo`03
0000003oool0oooo06l0oooo100000020?ooo`030000003oool0oooo0440oooo00<000000?ooo`3o
ool04`3oool001H0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`1a0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0D0?ooo`005`3o
ool2000008T0oooo0P00001d0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0E0?ooo`006@3oool00`000000oooo0?ooo`250?ooo`030000003oool0
oooo07@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0l0?ooo`800000603oool0
01X0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0H0?ooo`006`3oool00`000000
oooo0?ooo`210?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo000L0?ooo`050000003oool0oooo0?ooo`00
0000O@3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0J0?ooo`007@3oool00`000000oooo00000002000007/0oooo
00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03L0oooo
00<000000?ooo`3oool06`3oool001h0oooo1000001i0?ooo`800000N`3oool00`000000oooo0?oo
o`050?ooo`L00000<@3oool00`000000oooo0?ooo`0L0?ooo`007@3oool6000007D0oooo1000001l
0?ooo`030000003oool0oooo00`0oooo0P00000^0?ooo`030000003oool0oooo01d0oooo000L0?oo
o`P00000LP3oool6000007`0oooo00<000000?ooo`3oool03@3oool2000002`0oooo00<000000?oo
o`3oool07P3oool001l0oooo1@00001_0?ooo`P00000O@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool07`3oool00240oooo1000001_0?ooo`H00000
OP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
803oool002@0oooo0P00001_0?ooo`D00000OP3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo02H0oooo0P00000S0?ooo`009P3oool00`000000oooo0?ooo`1[0?ooo`D00000O`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool08`3oool0
02L0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`03000007l0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02@0oooo000X0?ooo`03
0000003oool0oooo06L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1n0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0U0?ooo`00
:@3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo08@0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02H0oooo000Z0?ooo`030000003o
ool0oooo06<0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`0@0?ooo`H00000703o
ool00`000000oooo0?ooo`0W0?ooo`00:`3oool200000640oooo0P0000280?ooo`030000003oool0
oooo01H0oooo0`00000H0?ooo`030000003oool0oooo02P0oooo000]0?ooo`030000003oool0oooo
05d0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0:@3oool002h0oooo00<000000?ooo`3oool0F`3oool00`000000
oooo0?ooo`290?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0Z0?ooo`00;`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo08X0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02/0oooo
000`0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo0100oooo0P00000^0?ooo`00<@3oool2000005D0oooo0P00002>
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0^
0?ooo`00<`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo08h0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02l0oooo000d0?ooo`03
0000003oool0oooo04l0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo00/0oooo0P00000b0?ooo`00=@3oool00`000000oooo0?ooo`1=0?ooo`030000
003oool0oooo0900oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`090?ooo`@00000
<P3oool003H0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`2?0?ooo`H000006P3o
ool2000000L0oooo1@00000c0?ooo`00=`3oool2000000030?ooo`000000000000800000@03oool6
00000980oooo1P00000L0?ooo``00000<`3oool003T0oooo1P00000I0?ooo`@000008@3oool60000
09<0oooo1@00000S0?ooo`D00000=03oool003T0oooo1P00000I0?ooo`L000007P3oool6000009@0
oooo1000000T0?ooo`@00000=03oool003T0ooooBP00002D0?ooo`<000008`3oool2000000030?oo
o`000000000003D0oooo000f0?ooo`T000006@3oool7000001h0oooo2000002B0?ooo`<000008P3o
ool010000000oooo0?ooo`3oool2000003D0oooo000e0?ooo`030000003oool0oooo0080oooo1000
000J0?ooo`@000008P3oool400000080oooo00<000000?ooo`3oool0T@3oool200000240oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0d0?ooo`00=@3oool00`000000oooo0?ooo`1=
0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo03@0oooo000d0?ooo`030000003oool0oooo04h0oooo00<000000?oo
o`3oool0T03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0=03oool003@0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`2@0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0c0?ooo`00
=03oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`070?ooo`800000=03oool00300oooo1@00001@0?ooo`030000003o
ool0oooo0900oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0:0?ooo`L00000;@3o
ool002h0oooo0P0000030?ooo`040000003oool00000000004l0oooo00<000000?ooo`3oool0S`3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:P3o
ool002d0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`00001>0?ooo`L00000R`3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0:@3o
ool002`0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000005@0oooo0`00
00280?ooo`030000003oool0oooo01L0oooo0P00000G0?ooo`030000003oool0oooo02T0oooo000/
0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P00001F0?ooo`030000003o
ool0oooo08D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo02T0oooo000[0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo0000
001F0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo02T0oooo000[0?ooo`030000003oool0oooo00P0oooo0`00001G
0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo02T0oooo000X0?ooo`@00000I03oool00`000000oooo0?ooo`250?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0Y0?oo
o`009P3oool2000000<0oooo0`00001R0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02P0oooo000U0?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`3oool00000HP3oool00`000000oooo0?ooo`240?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0W0?ooo`00
903oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`800000H03oool00`000000
oooo0?ooo`240?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07`3oool800000280
oooo000S0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0000001Q0?ooo`03
0000003oool0oooo08<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo01l0oooo000S0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0
oooo0000001R0?ooo`L00000OP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool07P3oool00280oooo00<000000?ooo`3oool0203oool4000006T0oooo
0P00001l0?ooo`030000003oool0oooo00`0oooo0P00000]0?ooo`030000003oool0oooo01h0oooo
000P0?ooo`<00000303oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo07X0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01h0oooo000N
0?ooo`8000000P3oool3000007H0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool07P3oool001`0oooo0P0000040?oo
o`030000003oool0oooo00800000M@3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0M0?ooo`006`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0LP3oool00`000000
oooo0?ooo`1i0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0M0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`00
0000M03oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`0M0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`050000
003oool0oooo0?ooo`000000M03oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0L0?ooo`006P3oool00`000000oooo
0?ooo`070?ooo`80000000<0oooo0000003oool0M03oool00`000000oooo0?ooo`1h0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0=P3oool7000001L0oooo000J0?ooo`030000003o
ool0oooo00P0oooo0P00001f0?ooo`P00000L`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo03h0oooo0P00000E0?ooo`005P3oool6000008T0oooo0P00001a0?ooo`030000003oool0
oooo0080oooo0P0000120?ooo`030000003oool0oooo01<0oooo000D0?ooo`800000103oool01000
0000oooo0000000000280?ooo`030000003oool0oooo06l0oooo00D000000?ooo`3oool0oooo0000
00140?ooo`030000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000280?ooo`030000003oool0oooo06d0oooo1@0000160?ooo`030000003o
ool0oooo0180oooo000B0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P00
00270?ooo`030000003oool0oooo06T0oooo0P0000000`3oool0000000000004000004H0oooo00<0
00000?ooo`3oool04P3oool00140oooo00<000000?ooo`3oool01P3oool2000000<0oooo00<00000
0?ooo`3oool0Q@3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00@0oooo0`000002
0?ooo`L00000AP3oool00`000000oooo0?ooo`0B0?ooo`004@3oool00`000000oooo0?ooo`080?oo
o`040000003oool0oooo000008L0oooo00<000000?ooo`3oool0D`3oool3000000H0oooo0`000000
103oool000000000000000020?ooo`030000003oool0oooo00@0oooo1P0000160?ooo`030000003o
ool0oooo0180oooo000A0?ooo`030000003oool0oooo00P0oooo0`0000280?ooo`030000003oool0
oooo0540oooo0P0000030?ooo`8000000P3oool2000000L0oooo0P0000070?ooo`H00000AP3oool0
0`000000oooo0?ooo`0B0?ooo`00303oool8000009<0oooo0P0000170?ooo`L000000`3oool00`00
0000oooo0?ooo`050?ooo`8000002P3oool2000000L0oooo100000180?ooo`030000003oool0oooo
0140oooo000;0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000T`3oool20000
03`0oooo1`0000020?ooo`030000003oool0oooo00D0oooo0`0000090?ooo`800000203oool01000
0000oooo0?ooo`00001C0?ooo`L00000303oool000X0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000009@0oooo1`00000Z0?ooo`H000000`3oool2000000L0oooo0P000009
0?ooo`800000203oool00`000000oooo000000080?ooo`040000003oool0oooo000005X0oooo00<0
00000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000009X0oooo00<000000?ooo`3oool07@3oool6000000<0oooo00<000000?ooo`3oool0103o
ool3000000X0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000070?ooo`040000
003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo0000001K0?ooo`8000002@3oool000T0
oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000009/0oooo00<000000?oo
o`3oool04@3oool6000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo000000090?oo
o`800000203oool00`000000oooo000000070?ooo`050000003oool0oooo0?ooo`0000001P3oool0
10000000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`000000G03oool00`000000oooo
0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000009/0oooo
00<000000?ooo`3oool03`3oool2000000H0oooo0P0000000`3oool000000?ooo`070?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`0000001`3oool01@000000oooo0?ooo`3oool0000000H0
oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000001P3oool0
10000000oooo0?ooo`00001L0?ooo`030000003oool0oooo00L0oooo00080?ooo`030000003oool0
oooo00P0oooo1000002K0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`060?ooo`030000003oool0000000P0oooo00@000000?ooo`3oool000001P3o
ool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000060?ooo`05
0000003oool0oooo0?ooo`0000001P3oool010000000oooo0?ooo`00001L0?ooo`030000003oool0
oooo00L0oooo003=0?ooo`030000003oool0000000L0oooo00@000000?ooo`3oool000001`3oool0
10000000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo
0?ooo`3oool0000000H0oooo00@000000?ooo`3oool00000203oool2000006L0oooo003<0?ooo`05
0000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000H0oooo00@00000
0?ooo`3oool000001`3oool010000000oooo0?ooo`0000060?ooo`80000000<0oooo000000000000
1`3oool300000740oooo003<0?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo
0?ooo`3oool0000000H0oooo00@000000?ooo`3oool000001`3oool010000000oooo0?ooo`000007
0?ooo`<00000O03oool00<`0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0
oooo0?ooo`0000001P3oool010000000oooo0?ooo`0000070?ooo`@00000QP3oool00<`0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000001P3oool400000940
oooo003=0?ooo`040000003oool0oooo000000L0oooo0`00002L0?ooo`00c@3oool300000:L0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo003o0?ooogP0oooo
0000\
\>"],
  ImageRangeCache->{{{0, 374.562}, {243, 0}} -> {-0.0423757, -0.000143001, \
0.176545, 0.176545}, {{0.3125, 187.25}, {243, 56.0625}} -> {-1.03689, \
-1.00011, 0.176532, 0.176532}, {{187.25, 374.188}, {243, 56.0625}} -> \
{-23.0371, -1.00011, 0.176532, 0.176532}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp = CreateFeynAmp[ins]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes amplitudes"\
\),
        SequenceForm[ "in total: ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), 
            ",", \(ExcludeParticles \[Rule] {}\), 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(V(5)\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "0"},
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MU"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(V(1)\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "0"},
                      {\(F(3, {1})\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MU"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                  Number == 1)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]2\),
                              SequenceForm[ "k", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                            "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "-", 
                          
                          RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                            " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MU", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], "+", 
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "k", 2],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}], "-", 
                          RowBox[{"\[ImaginaryI]", " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}]}], ")"}], ".",
                       
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]2\),
                              SequenceForm[ "p", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  RowBox[{
                    FormBox["\<\"ep\"\>",
                      "TraditionalForm"], "(", 
                    RowBox[{\(V(5)\), ",", 
                      FormBox[
                        InterpretationBox[\("p"\[InvisibleSpace]1\),
                          SequenceForm[ "p", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("k"\[InvisibleSpace]1\
\),
                                      SequenceForm[ "k", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MU\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Glu"\[InvisibleSpace]1\),
                          SequenceForm[ "Glu", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "8", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(1)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]1\),
                          SequenceForm[ "k", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], "]"}]}]}], ")"}], ",", 
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 2, Generic == 1, Classes == 1, 
                  Number == 2)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]2\),
                              SequenceForm[ "k", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}], "-", 
                          RowBox[{"\[ImaginaryI]", " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}]}], ")"}], ".",
                       
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MU", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("p"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "p", 2],
                                    Editable->False],
                                  "TraditionalForm"], "-", 
                                FormBox[
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                            "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "-", 
                          
                          RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                            " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]2\),
                              SequenceForm[ "p", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  RowBox[{
                    FormBox["\<\"ep\"\>",
                      "TraditionalForm"], "(", 
                    RowBox[{\(V(5)\), ",", 
                      FormBox[
                        InterpretationBox[\("p"\[InvisibleSpace]1\),
                          SequenceForm[ "p", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], "-", 
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MU\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Glu"\[InvisibleSpace]1\),
                          SequenceForm[ "Glu", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "8", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(1)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]1\),
                          SequenceForm[ "k", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], "]"}]}]}], ")"}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp\  // Length\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(strm = OpenWrite["\<test.amp\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`OutputStream["test.amp", 9]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Write[strm, famp]\), "\[IndentingNewLine]", 
    \(Close[strm]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"test.amp"\)], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["q qbar -> w \[Gamma]", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(\(tops = 
        CreateTopologies[0, 4];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[
          tops, {F[3, {1}], \(-F[4, {1}]\)} \[Rule] {V[5], \(-V[3]\)}, 
          Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Paint[ins, ColumnsXRows \[Rule] {2, 1}, 
        PaintLevel \[Rule] {Classes}];\)\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 3, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 4, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes insertions"\
\),
        SequenceForm[ "in total: ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 -1.40675e-17 0.0227273 [
[ 0 0 0 0 ]
[ 1 .65 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65 L
0 .65 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -1.40675e-17 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.5 .31818 L
s
.24559 .29274 m
.30167 .28008 L
.29806 .31626 L
F
gsave
.27974 .25284 -67.5625 -19.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
72.125 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50513 .68698 L
.51114 .69114 L
.51785 .69411 L
.52499 .69573 L
.53232 .69594 L
.53955 .69473 L
.54641 .69217 L
.55266 .68842 L
.55808 .68368 L
.56249 .6782 L
.56577 .6723 L
.56785 .66628 L
.56875 .66047 L
.56851 .65519 L
.56727 .65073 L
.5652 .64733 L
.56251 .64518 L
.55946 .6444 L
.55631 .64505 L
.55334 .6471 L
.55081 .65045 L
.54897 .65495 L
.54802 .66036 L
.54812 .66642 L
.54938 .67282 L
.55183 .67922 L
.55547 .68532 L
.5602 .6908 L
.56589 .69538 L
.57235 .69883 L
.57936 .70099 L
.58665 .70176 L
.59395 .70109 L
.60099 .69905 L
.6075 .69575 L
.61327 .69136 L
.61809 .68614 L
.62182 .68036 L
.62437 .67435 L
.62573 .66842 L
.62592 .6629 L
.62506 .65809 L
.62329 .65425 L
.62081 .65159 L
.61787 .65026 L
.61472 .65035 L
.61165 .65186 L
.60892 .65473 L
.60678 .6588 L
Mistroke
.60546 .66389 L
.60514 .66973 L
.60594 .67603 L
.60792 .68247 L
.6111 .68872 L
.61542 .69448 L
.62076 .69944 L
.62695 .70336 L
.63377 .70604 L
.64098 .70736 L
.64831 .70725 L
.65548 .70573 L
.66223 .7029 L
.66831 .69891 L
.67352 .69399 L
.67769 .68839 L
.68071 .68243 L
.68253 .67643 L
.68317 .67071 L
.68271 .66559 L
.68126 .66134 L
.67904 .6582 L
.67624 .65634 L
.67315 .65587 L
.67001 .65683 L
.66712 .65918 L
.66472 .6628 L
.66306 .66752 L
.66233 .6731 L
.66268 .67926 L
.6642 .68568 L
.66691 .69205 L
.6708 .69803 L
.67575 .70334 L
.68163 .70769 L
.68824 .71087 L
.69532 .71273 L
.70264 .71318 L
.70991 .71221 L
.71685 .70988 L
.72322 .70632 L
.72879 .70173 L
.73338 .69636 L
.73686 .6905 L
.73915 .68448 L
.74025 .67861 L
.7402 .67322 L
.73912 .6686 L
.73718 .665 L
.73458 .66263 L
Mistroke
.73157 .66161 L
.72841 .66201 L
.72539 .66382 L
.72277 .66697 L
.7208 .67128 L
.71969 .67655 L
.7196 .68252 L
.72065 .68888 L
.7229 .69531 L
.72634 .70148 L
.73089 .70708 L
.73643 .71184 L
.74278 .7155 L
.74971 .71789 L
.75697 .7189 L
.76428 .71848 L
.77139 .71666 L
.77801 .71356 L
.78392 .70935 L
.78891 .70425 L
.79283 .69855 L
.79559 .69255 L
.79716 .68658 L
.79754 .68097 L
.79685 .67601 L
.79522 .67199 L
.79285 .66912 L
.78997 .66755 L
.78684 .6674 L
.78373 .66867 L
.78093 .67131 L
.77867 .67519 L
.7772 .68011 L
.7767 .68585 L
.77729 .69209 L
.77907 .69853 L
.78205 .70484 L
.78618 .7107 L
.79136 .71581 L
.79741 .71993 L
.80414 .72283 L
.8113 .72439 L
.81863 .72453 L
.82585 .72325 L
.83269 .72063 L
.8389 .71683 L
.84427 .71204 L
.84863 .70654 L
.85185 .70062 L
.85388 .6946 L
Mistroke
.85472 .68881 L
.85443 .68357 L
.85315 .67915 L
.85104 .6758 L
.84833 .67371 L
.84526 .673 L
.84212 .67372 L
.83916 .67583 L
.83666 .67925 L
.83486 .68379 L
.83396 .68924 L
.83412 .69532 L
.83543 .70172 L
.83794 .70812 L
.84163 .7142 L
.84641 .71964 L
.85215 .72417 L
.85864 .72756 L
.86567 .72966 L
.87296 .73035 L
.88025 .72962 L
.88727 .72752 L
.89376 .72415 L
.89948 .71972 L
.90425 .71447 L
.90793 .70867 L
.91042 .70265 L
.91172 .69674 L
.91187 .69124 L
.91095 .68647 L
.90914 .68268 L
.90664 .68008 L
.90368 .67882 L
.90053 .67898 L
.89747 .68056 L
.89476 .68348 L
.89266 .68761 L
.89139 .69273 L
.89111 .6986 L
.89197 .70492 L
.89401 .71136 L
.89725 .71759 L
.90162 .72332 L
.907 .72823 L
.91322 .73209 L
.92007 .73471 L
.92729 .73596 L
.93462 .73579 L
.94178 .7342 L
.9485 .73131 L
Mistroke
.95455 .72727 L
Mfstroke
gsave
.72026 .74716 -67.5625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.50416 .3139 L
.50837 .31007 L
.51267 .3071 L
.51708 .30527 L
.52161 .30476 L
.52629 .30556 L
.53107 .30754 L
.53595 .3104 L
.54087 .31375 L
.5458 .31714 L
.55069 .32011 L
.5555 .32227 L
.56019 .3233 L
.56476 .32303 L
.56919 .32143 L
.5735 .31864 L
.57772 .31495 L
.58189 .31072 L
.58605 .30642 L
.59025 .30249 L
.59453 .29935 L
.59891 .29731 L
.60343 .29657 L
.60808 .29714 L
.61285 .29892 L
.61771 .30162 L
.62262 .30488 L
.62755 .30825 L
.63244 .31126 L
.63726 .31351 L
.64197 .31468 L
.64655 .31457 L
.651 .31315 L
.65533 .31056 L
.65957 .30709 L
.66377 .30314 L
.66797 .2992 L
.67221 .29578 L
.67656 .29332 L
.68103 .29214 L
.68564 .2923 L
.69035 .29354 L
.69512 .29529 L
.69986 .29678 L
.70452 .2975 L
.70911 .29744 L
.71365 .29697 L
.71819 .29643 L
.72273 .29594 L
Mistroke
.72728 .29548 L
.73182 .29503 L
.73637 .29461 L
.74092 .29425 L
.74547 .2938 L
.74998 .29295 L
.7544 .29132 L
.75876 .28892 L
.76308 .28627 L
.76746 .28411 L
.77194 .28305 L
.77656 .28332 L
.7813 .28487 L
.78615 .28738 L
.79104 .29041 L
.79594 .29345 L
.80078 .29602 L
.80554 .2977 L
.81019 .29821 L
.8147 .29741 L
.81908 .29533 L
.82335 .29217 L
.82755 .28825 L
.83172 .28397 L
.83589 .27981 L
.84012 .27619 L
.84444 .27351 L
.84888 .27202 L
.85346 .27186 L
.85816 .27299 L
.86298 .27522 L
.86787 .27824 L
.8728 .28163 L
.87772 .28495 L
.88259 .28773 L
.88737 .28961 L
.89203 .2903 L
.89656 .28966 L
.90096 .28772 L
.90524 .28466 L
.90944 .28077 L
.9136 .27647 L
.91777 .27221 L
.92198 .26845 L
.92628 .26556 L
.9307 .26385 L
.93525 .26345 L
.93993 .26437 L
.94473 .26644 L
.94962 .26936 L
Mistroke
.95455 .27273 L
Mfstroke
.70014 .29817 m
.75622 .31083 L
.7526 .27465 L
F
gsave
.73428 .33807 -70.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
78.500 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.45704 .5 -74.125 -10.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N1) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -1.40675e-17 1 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.5 .31818 L
s
.24559 .29274 m
.30167 .28008 L
.29806 .31626 L
F
gsave
.27974 .25284 -67.5625 -19.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
72.125 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.5011 .3251 L
.50337 .33178 L
.50679 .33799 L
.51125 .34349 L
.51664 .34811 L
.52276 .35167 L
.52941 .3541 L
.53635 .35534 L
.54332 .35539 L
.55008 .35433 L
.55638 .35226 L
.562 .34937 L
.56675 .34584 L
.57047 .34191 L
.57308 .33783 L
.57452 .33387 L
.5748 .33027 L
.57398 .32727 L
.57217 .32509 L
.56953 .32388 L
.56627 .32378 L
.56261 .32485 L
.55879 .32712 L
.55507 .33054 L
.55171 .33502 L
.54892 .34041 L
.54693 .34654 L
.54589 .35317 L
.54593 .36007 L
.54713 .36697 L
.5495 .37363 L
.553 .37978 L
.55754 .38522 L
.563 .38976 L
.56917 .39324 L
.57585 .39557 L
.58281 .3967 L
.58977 .39667 L
.5965 .39552 L
.60276 .39338 L
.60831 .39042 L
.61298 .38685 L
.61662 .3829 L
.61913 .37882 L
.62047 .37488 L
.62066 .37132 L
.61975 .36839 L
.61787 .36627 L
.61518 .36515 L
Mistroke
.61187 .36514 L
.60819 .36631 L
.60437 .36867 L
.60067 .37218 L
.59735 .37674 L
.59462 .3822 L
.5927 .38838 L
.59174 .39504 L
.59188 .40195 L
.59317 .40884 L
.59563 .41547 L
.59922 .42157 L
.60385 .42695 L
.60936 .4314 L
.61559 .43479 L
.6223 .43702 L
.62926 .43806 L
.63622 .43793 L
.64292 .4367 L
.64913 .43449 L
.65461 .43147 L
.6592 .42786 L
.66276 .42389 L
.66518 .41981 L
.66642 .41589 L
.66652 .41238 L
.66553 .4095 L
.66357 .40746 L
.66082 .40643 L
.65748 .40651 L
.65377 .40778 L
.64996 .41023 L
.64628 .41383 L
.64299 .41847 L
.64033 .424 L
.63848 .43022 L
.63761 .43691 L
.63783 .44383 L
.63922 .45071 L
.64177 .4573 L
.64545 .46336 L
.65016 .46866 L
.65574 .47303 L
.66201 .47633 L
.66875 .47847 L
.67573 .47941 L
.68267 .47919 L
.68934 .47787 L
.69549 .47558 L
.70092 .47251 L
Mistroke
.70543 .46886 L
.70889 .46487 L
.71121 .4608 L
.71237 .4569 L
.71237 .45343 L
.7113 .45061 L
.70927 .44865 L
.70647 .4477 L
.70308 .44788 L
.69936 .44924 L
.69555 .4518 L
.69189 .45548 L
.68865 .4602 L
.68604 .46579 L
.68426 .47206 L
.68348 .47878 L
.6838 .4857 L
.68528 .49257 L
.68793 .49913 L
.69169 .50513 L
.69647 .51036 L
.70212 .51465 L
.70844 .51786 L
.71521 .5199 L
.72219 .52075 L
.72912 .52043 L
.73576 .51903 L
.74186 .51667 L
.74721 .51355 L
.75165 .50986 L
.75502 .50586 L
.75725 .50179 L
.75831 .49791 L
.75822 .49449 L
.75707 .49173 L
.75497 .48985 L
.75211 .48899 L
.74869 .48926 L
.74495 .49072 L
.74114 .49336 L
.73751 .49714 L
.73431 .50193 L
.73176 .50759 L
.73006 .5139 L
.72936 .52065 L
.72977 .52757 L
.73135 .53443 L
.73409 .54095 L
.73794 .54689 L
.7428 .55206 L
Mistroke
.74851 .55626 L
.75487 .55938 L
.76167 .56132 L
.76866 .56208 L
.77557 .56167 L
.78218 .56018 L
.78822 .55776 L
.79351 .55457 L
.79786 .55085 L
.80114 .54683 L
.80328 .54277 L
.80424 .53893 L
.80407 .53554 L
.80283 .53285 L
.80067 .53104 L
.79775 .53027 L
.7943 .53064 L
.79054 .5322 L
.78674 .53494 L
.78313 .5388 L
.77998 .54367 L
.77749 .54938 L
.77587 .55574 L
.77526 .56251 L
.77576 .56944 L
.77743 .57628 L
.78027 .58276 L
.7842 .58865 L
.78914 .59374 L
.79491 .59786 L
.80131 .60089 L
.80814 .60274 L
.81513 .60339 L
.82203 .60289 L
.82859 .60132 L
.83459 .59883 L
.8398 .5956 L
.84407 .59184 L
.84726 .58781 L
.8493 .58375 L
.85017 .57994 L
.84991 .5766 L
.84859 .57397 L
.84636 .57225 L
.84339 .57156 L
.8399 .57202 L
.83614 .57368 L
.83234 .57651 L
.82876 .58046 L
.82565 .58541 L
Mistroke
.82323 .59118 L
.82168 .59758 L
.82116 .60437 L
.82176 .61131 L
.82352 .61812 L
.82645 .62456 L
.83047 .6304 L
.83548 .63542 L
.84131 .63945 L
.84776 .64238 L
.85461 .64414 L
.8616 .6447 L
.86848 .6441 L
.87501 .64246 L
.88095 .6399 L
.88609 .63661 L
.89028 .63282 L
.89338 .62878 L
.89532 .62473 L
.8961 .62095 L
.89574 .61766 L
.89435 .6151 L
.89205 .61345 L
.88903 .61286 L
.88551 .61342 L
.88173 .61517 L
.87794 .61809 L
.8744 .62213 L
.87134 .62715 L
.86898 .63298 L
.86751 .63942 L
.86707 .64623 L
.86776 .65317 L
.86963 .65996 L
.87264 .66636 L
.87675 .67214 L
.88183 .67708 L
.88772 .68103 L
.89421 .68387 L
.90108 .68553 L
.90807 .68599 L
.91493 .68531 L
.92142 .68358 L
.9273 .68095 L
.93238 .67762 L
.93648 .6738 L
.93949 .66975 L
.94134 .66571 L
.94202 .66196 L
.94158 .65872 L
Mistroke
.9401 .65623 L
.93774 .65466 L
.93467 .65416 L
.93112 .65481 L
.92733 .65666 L
.92355 .65968 L
.92004 .6638 L
.91703 .66889 L
.91473 .67478 L
.91334 .68126 L
.913 .68809 L
.91378 .69502 L
.91574 .7018 L
.91885 .70815 L
.92304 .71387 L
.92819 .71874 L
.93414 .7226 L
.94067 .72535 L
.94755 .7269 L
.95455 .72727 L
Mfstroke
gsave
.81534 .64005 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50078 .67586 L
.50187 .67025 L
.50357 .66531 L
.50608 .66128 L
.5095 .65826 L
.51384 .65626 L
.51898 .65514 L
.5247 .65468 L
.53072 .65455 L
.53671 .65439 L
.54237 .65386 L
.54741 .65264 L
.55163 .65051 L
.55493 .64735 L
.55732 .64318 L
.55892 .63814 L
.55996 .63247 L
.56072 .62649 L
.56152 .62055 L
.56268 .61502 L
.56448 .6102 L
.5671 .60629 L
.57065 .60341 L
.57511 .60154 L
.58033 .60053 L
.58611 .60012 L
.59214 .60001 L
.59811 .59982 L
.6037 .5992 L
.60863 .59787 L
.61273 .5956 L
.6159 .5923 L
.61818 .58801 L
.6197 .58287 L
.62068 .57714 L
.62143 .57116 L
.62228 .56527 L
.62352 .55983 L
.62543 .55512 L
.62818 .55136 L
.63186 .54863 L
.63643 .54688 L
.64173 .54595 L
.64754 .54559 L
.65355 .54544 L
.65944 .54517 L
.6649 .54441 L
.66967 .54289 L
.67358 .54042 L
Mistroke
.67659 .53693 L
.67874 .53249 L
.68021 .52731 L
.68127 .52167 L
.68226 .51595 L
.68354 .51055 L
.68544 .50584 L
.6882 .50208 L
.69189 .49936 L
.69636 .4975 L
.70121 .49607 L
.70593 .49449 L
.71014 .49234 L
.71382 .48961 L
.71721 .48656 L
.72055 .48344 L
.72392 .48037 L
.72731 .47731 L
.7307 .47426 L
.73412 .47123 L
.73757 .46824 L
.74096 .46519 L
.74406 .46182 L
.74664 .45786 L
.7487 .45333 L
.75063 .44866 L
.75295 .4444 L
.75604 .44102 L
.76007 .43867 L
.76496 .43728 L
.77046 .43657 L
.77625 .43618 L
.78197 .43572 L
.78728 .4348 L
.79192 .43313 L
.7957 .43051 L
.79857 .42687 L
.80058 .42229 L
.80191 .41694 L
.80281 .41112 L
.80358 .40515 L
.80455 .39942 L
.80603 .39424 L
.80825 .38988 L
.81136 .38651 L
.81539 .38416 L
.82026 .38276 L
.8258 .38209 L
.83175 .38187 L
.83778 .38176 L
Mistroke
.84358 .38138 L
.84885 .38041 L
.85336 .37859 L
.85697 .37578 L
.85965 .37195 L
.8615 .36718 L
.8627 .36169 L
.86351 .35577 L
.86426 .34979 L
.86527 .34408 L
.86683 .33899 L
.86916 .33476 L
.87239 .33153 L
.87655 .32933 L
.88154 .32805 L
.88716 .32748 L
.89315 .3273 L
.89917 .32718 L
.90492 .32674 L
.91011 .32568 L
.9145 .32374 L
.91799 .32079 L
.92055 .31681 L
.92229 .31193 L
.92342 .30636 L
.9242 .30041 L
.92497 .29444 L
.92603 .2888 L
.92767 .28381 L
.93012 .2797 L
.93348 .27661 L
.93776 .27455 L
.94285 .27338 L
.94854 .27287 L
.95455 .27273 L
Mfstroke
.707 .49552 m
.75971 .47254 L
.73538 .44551 L
F
gsave
.84375 .41277 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
78.500 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.46158 .5 -74.125 -11.6562 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
72.125 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N2) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 .59 -68.4688 -12.8438 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 25.6875 translate 1 -1 scale
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
73.938 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59 -71.0938 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.312 moveto
(\\256) show
79.188 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 .59 -68.4688 -12.4688 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.9375 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 .59 -72.3125 -12.8438 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 25.6875 translate 1 -1 scale
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
81.625 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{250.375, 162.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000m2000`400?l00000o`00003oo`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh
0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00o`3ooomh0?ooo`00[@3oool4
00000<H0oooo00080?ooo`D00000TP3oool00`000000oooo0?ooo`090?ooo`800000103oool20000
0100oooo1@00002U0?ooo`030000003oool0oooo00L0oooo000=0?ooo`X00000QP3oool200000003
0?ooo`000000000000T0oooo00<000000?ooo`3oool06P3oool:000009L0oooo1000000:0?ooo`00
5`3oool9000006/0oooo0P0000030?ooo`8000002P3oool00`000000oooo0?ooo`030?ooo`800000
1P3oool00`000000oooo0?ooo`0U0?ooo`T00000SP3oool00`000000oooo0?ooo`0;0?ooo`00803o
ool:000000T0oooo1@00001@0?ooo`D0000000<0oooo0000000000000P3oool2000000L0oooo00<0
00000?ooo`3oool01P3oool200000080oooo0P00000a0?ooo`X000002@3oool5000007D0oooo00<0
00000?ooo`3oool0303oool002X0oooo3P0000160?ooo`@00000103oool9000000D0oooo0P000004
0?ooo`030000003oool0oooo00T0oooo0P00000m0?ooo`h00000M@3oool00`000000oooo0?ooo`0<
0?ooo`00<03oool<000003<0oooo1000000:0?ooo`030000003oool0oooo0080oooo2`0000090?oo
o`@00000D@3oool<00000740oooo00<000000?ooo`3oool0303oool00380oooo1P0000040?ooo`X0
00005P3oool4000000030?ooo`000000oooo00/0oooo00<000000?ooo`3oool00P3oool2000000L0
oooo00<000000?ooo`3oool0203oool600000600oooo1P0000040?ooo`X000005P3oool4000004d0
oooo00<000000?ooo`3oool0303oool003@0oooo1000000>0?ooo`T00000303oool6000000030?oo
o`000000000000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00`0oooo0`00001R0?ooo`@000003P3oool9000000`0oooo1P00001;0?ooo`030000
003oool0oooo00d0oooo000f0?ooo`8000005`3oool:00000080oooo1P0000030?ooo`8000001P3o
ool2000000P0oooo1@00001f0?ooo`8000005`3oool:00000080oooo1P00001;0?ooo`030000003o
ool0oooo00d0oooo001I0?ooo`P000001@3oool2000000<0oooo00<000000?ooo`3oool0YP3oool8
000004X0oooo0P00000?0?ooo`00F`3oool6000000L0oooo0`00002[0?ooo`H00000203oool30000
03h0oooo0P00000@0?ooo`00G03oool400000;L0oooo100000080?ooo`040000003oool0oooo0000
03L0oooo1`00000B0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`800000203oool01@000000
oooo0?ooo`3oool0000003H0oooo00<000000?ooo`3oool05`3oool005d0oooo00<000000?ooo`3o
ool0^03oool2000000L0oooo00@000000?ooo`3oool0oooo0P00000f0?ooo`030000003oool0oooo
01L0oooo001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`0000001P3oool01@000000
oooo0?ooo`3oool0000003L0oooo00<000000?ooo`3oool05`3oool005d0oooo00<000000?ooo`3o
ool0^03oool00`000000oooo0?ooo`02000000@0oooo00@000000?ooo`0000000000=`3oool00`00
0000oooo0?ooo`0H0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo0080
oooo1P00000i0?ooo`030000003oool0oooo01P0oooo001M0?ooo`030000003oool0oooo0;P0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01P0oooo
001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`080?ooo`@00000;03oool00`000000oooo0?ooo`0H0?ooo`00G@3oool00`000000oooo0?ooo`2h
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool01@000000oooo0?ooo`3o
ool0000002/0oooo00<000000?ooo`3oool06@3oool005d0oooo00<000000?ooo`3oool0^03oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P00
000Z0?ooo`8000006`3oool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000T0?ooo`L000007@3o
ool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`080?ooo`8000001@3oool0
10000000oooo00000000000T0?ooo`030000003oool0oooo0280oooo001M0?ooo`030000003oool0
oooo0;P0oooo00<000000?ooo`3oool02P3oool200000080oooo0`00000U0?ooo`030000003oool0
oooo02<0oooo001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0303oool30000
02L0oooo00<000000?ooo`3oool08`3oool005d0oooo00<000000?ooo`3oool0^03oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0S0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool01`3oool2000000030?ooo`000000oooo01P0oooo00<000000?ooo`3oool0
8`3oool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00L0oooo00@000000?ooo`3oool000006@3oool00`000000oooo0?ooo`0S0?ooo`00G@3o
ool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01@3o
ool01@000000oooo0?ooo`3oool0000001P0oooo00<000000?ooo`3oool0903oool005d0oooo00<0
00000?ooo`3oool0^03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00<0oooo00@0
00000?ooo`3oool0oooo0P00000H0?ooo`030000003oool0oooo02@0oooo001M0?ooo`030000003o
ool0oooo0;P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo000001T0oooo00<000000?ooo`3oool09@3oool005d0oooo00<000000?ooo`3oool0^03o
ool00`000000oooo0?ooo`0C0?ooo`L000005@3oool5000002P0oooo001M0?ooo`030000003oool0
oooo0;P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?ooo`800000;@3oool0
05d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
00P0oooo0`0000070?ooo`800000;P3oool005d0oooo00<000000?ooo`3oool0^03oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool000000`3oool01000
0000oooo0?ooo`00000_0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool000000080oooo1000000`
0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool01@3oool010000000oooo0?ooo`3oool200000080oooo1000000`0?ooo`00G@3oool00`00
0000oooo0?ooo`2h0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool000000080oooo1P00000_0?ooo`00G@3oool00`000000oooo0?ooo`2h0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool010000000oooo000000000003
0?ooo`L00000;P3oool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0K0?oo
o`L00000103oool600000300oooo001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`030?ooo`<00000<`3oool005d0oooo0P00002i0?ooo`800000
8@3oool00`000000oooo0?ooo`020?ooo`800000103oool3000002h0oooo001L0?ooo`<00000^03o
ool300000240oooo00<000000?ooo`0000000`0000040?ooo`040000003oool0oooo000002h0oooo
001L0?ooo`<00000^03oool300000240oooo0P0000070?ooo`040000003oool0oooo0?ooo`800000
;@3oool005`0oooo1000002g0?ooo`@00000803oool2000000L0oooo00D000000?ooo`3oool0oooo
0000000^0?ooo`00F`3oool500000;H0oooo1@00000P0?ooo`030000003oool0000000H0oooo00@0
00000?ooo`0000000000;`3oool005/0oooo1P00002e0?ooo`H000007P3oool010000000oooo0?oo
o`3oool2000000<0oooo00<000000?ooo`000000<@3oool005/0oooo1P00002e0?ooo`H000007P3o
ool00`000000oooo0?ooo`030?ooo`D00000<P3oool005X0oooo1`00002d0?ooo`L000007P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0340oooo001M0?ooo`030000003oool0oooo
0;P0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00P0oooo1000000U0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?oo
o`0000009@3oool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0I0?ooo`H0
00002P3oool00`000000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`0000009@3oool005d0
oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0F0?ooo`<000004@3oool00`000000
oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`8000009@3oool005d0oooo00<000000?ooo`3o
ool0^03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo0P0000040?ooo`04
0000003oool0oooo000002L0oooo001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0F0?ooo`80000000<0oooo0000000000000P00000X0?ooo`00
G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
603oool00`000000oooo0000000Z0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`090?ooo`8000007@3o
ool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool01`3oool2000000030?ooo`000000000001`0oooo001M0?oo
o`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0000000L0?ooo`00G@3oool00`00
0000oooo0?ooo`2h0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`050?ooo`040000003oool0oooo0?ooo`800000703oool005d0oooo00<000000?oo
o`3oool0^03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01`0oooo0P0000060?oo
o`050000003oool0oooo0?ooo`0000007@3oool005d0oooo00<000000?ooo`3oool0^03oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`02000001h0oooo001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3o
ool02P3oool8000002<0oooo1`00000P0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0P0?ooo`00G@3o
ool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`090?ooo`<00000503oool005d0oooo00<000000?ooo`3oool0^03oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool01`3oool0
10000000oooo0?ooo`00000D0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`060?ooo`050000003oool0
oooo0?ooo`000000503oool005d0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000001@0oooo001M0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000
000E0?ooo`00G@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0<P3oool00`000000oooo0?ooo`020?ooo`040000003oool00000000001H0oooo001M
0?ooo`030000003oool0oooo00L0oooo0`00002^0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0<`3oool6000001P0oooo001M0?ooo`030000003oool0oooo00L0oooo00@000000?oo
o`00000000001`3oool300000:<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0h
0?ooo`030000003oool0oooo01L0oooo001M0?ooo`030000003oool0oooo00H0oooo00D000000?oo
o`3oool0oooo000000070?ooo`030000003oool0000000P0oooo0P00002I0?ooo`030000003oool0
oooo00L00000>`3oool00`000000oooo0?ooo`080?ooo`<00000303oool005d0oooo00<000000?oo
o`3oool01P3oool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo0000
00060?ooo`80000000<0oooo0000003oool01`3oool2000008h0oooo0`0000120?ooo`030000003o
ool0oooo00L0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`00G03oool4000000H0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000001P3oool010000000
oooo0?ooo`0000070?ooo`040000003oool0oooo000000L0oooo0P0000230?ooo`@00000@`3oool0
0`000000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`0000002`3oool005/0oooo1P000006
0?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000
003oool0oooo0?ooo`0000001P3oool010000000oooo0?ooo`0000070?ooo`030000003oool00000
00P0oooo0P00001g0?ooo`H00000@`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`000000303oool005/0oooo1P0000060?ooo`030000003oool0000000L0oooo00D000000?oo
o`3oool0oooo000000060?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo
000000060?ooo`050000003oool0oooo0?ooo`0000001P3oool2000000030?ooo`000000oooo00L0
oooo0P00001/0?ooo`H00000A03oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0000
00d0oooo001H0?ooo`T000001P3oool2000000P0oooo00@000000?ooo`3oool000001`3oool01000
0000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?oo
o`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000060?ooo`@00000J03oool9000004D0
oooo0P0000020?ooo`040000003oool00000000000h0oooo001>0?ooo`X000000`3oool6000000H0
oooo0P0000090?ooo`800000203oool00`000000oooo000000080?ooo`040000003oool0oooo0000
00H0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000001P3o
ool010000000oooo0?ooo`00001N0?ooo`X000000`3oool6000004L0oooo1000000@0?ooo`00;P3o
ool300000180oooo2`00000>0?ooo`H000000P3oool300000080oooo0P0000070?ooo`800000203o
ool00`000000oooo000000080?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0
oooo000000060?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo0000000n
0?ooo`<000004P3oool;000000h0oooo1000001;0?ooo`030000003oool0oooo00h0oooo000^0?oo
o`L000000`3oool;000001l0oooo0P0000070?ooo`030000003oool0oooo0080oooo0P0000020?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo000000070?oo
o`040000003oool0oooo000000L0oooo00@000000?ooo`3oool000001P3oool01@000000oooo0?oo
o`3oool0000003h0oooo1`0000030?ooo`/00000J03oool00`000000oooo0?ooo`0>0?ooo`00;P3o
ool:000003@0oooo100000050?ooo`8000000`3oool3000000030?ooo`000000oooo00P0oooo00<0
00000?ooo`3oool01`3oool2000000P0oooo00@000000?ooo`3oool000001`3oool010000000oooo
0?ooo`00000n0?ooo`X00000L`3oool00`000000oooo0?ooo`0>0?ooo`008`3ooolC00000440oooo
0`0000050?ooo`8000001@3oool3000000T0oooo0P0000080?ooo`030000003oool0000000P0oooo
00@000000?ooo`3oool00000<`3ooolC000007H0oooo00<000000?ooo`3oool03@3oool001P0oooo
2`00000;0?ooo`D00000CP3oool5000000<0oooo0`0000040?ooo`8000000P3oool00`000000oooo
0?ooo`060?ooo`800000203oool00`000000oooo0000000Y0?ooo`/000002`3oool5000007T0oooo
00<000000?ooo`3oool03@3oool000h0oooo2P00000F0?ooo`<00000F`3oool4000000D0oooo00<0
00000?ooo`3oool00`3oool4000000T0oooo00<000000?ooo`3oool07P3oool:000001H0oooo0`00
001l0?ooo`030000003oool0oooo00`0oooo00080?ooo`H00000R03oool5000000@0oooo00<00000
0?ooo`3oool00`3oool4000000T0oooo00<000000?ooo`3oool03P3oool600000:00oooo1@000009
0?ooo`00X03oool5000000@0oooo0`0000050?ooo`030000003oool0oooo0<<0oooo002/0?ooo`D0
0000aP3oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0ooooN03oool00?l0
ooooN03oool00001\
\>"],
  ImageRangeCache->{{{0, 374.562}, {243, 0}} -> {-0.0423757, -0.000143001, \
0.176545, 0.176545}, {{0.3125, 187.25}, {243, 56.0625}} -> {-1.03689, \
-1.00011, 0.176532, 0.176532}, {{187.25, 374.188}, {243, 56.0625}} -> \
{-23.0371, -1.00011, 0.176532, 0.176532}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp = CreateFeynAmp[ins]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes amplitudes"\
\),
        SequenceForm[ "in total: ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), 
            ",", \(ExcludeParticles \[Rule] {}\), 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(-\(F(4, {1})\)\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MD"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(V(5)\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "0"},
                      {\(-\(V(3)\)\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MW"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                  Number == 1)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("v"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]2\),
                              SequenceForm[ "p", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MD"}], ")"}], ".", 
                      FractionBox[
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\(CKM(1, 1)\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\^"*"\),
                                    Superscript[ "*"],
                                    Editable->False]}],
                                SequenceForm[ 
                                  CKM[ 1, 1], 
                                  Superscript[ "*"]],
                                Editable->False],
                              "TraditionalForm"], ")"}], " ", 
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox["\<\"ga\"\>",
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[\("Lor"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    
                                    RowBox[{"\<\"om\"\>", "\[InvisibleSpace]",
                                       
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"]}], \(\@2\ SW\)], ".", 
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MU", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "k", 2],
                                    Editable->False],
                                  "TraditionalForm"], "-", 
                                FormBox[
                                  
                                  InterpretationBox[\("p"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "p", 2],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}], "-", 
                          RowBox[{"\[ImaginaryI]", " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}]}], ")"}], ".",
                       
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]1\),
                              SequenceForm[ "p", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MU\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Glu"\[InvisibleSpace]1\),
                          SequenceForm[ "Glu", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "8", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(3)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]2\),
                          SequenceForm[ "k", 2],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], "]"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(5)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]1\),
                          SequenceForm[ "k", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"]}], "]"}]}]}], ")"}], ",", 
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 2, Generic == 1, Classes == 1, 
                  Number == 2)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("v"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]2\),
                              SequenceForm[ "p", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "MD"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}], "-", 
                          RowBox[{"\[ImaginaryI]", " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}]}], ")"}], ".",
                       
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MD", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], "-", 
                                FormBox[
                                  
                                  InterpretationBox[\("p"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "p", 2],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      FractionBox[
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\(CKM(1, 1)\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\^"*"\),
                                    Superscript[ "*"],
                                    Editable->False]}],
                                SequenceForm[ 
                                  CKM[ 1, 1], 
                                  Superscript[ "*"]],
                                Editable->False],
                              "TraditionalForm"], ")"}], " ", 
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox["\<\"ga\"\>",
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[\("Lor"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    
                                    RowBox[{"\<\"om\"\>", "\[InvisibleSpace]",
                                       
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"]}], \(\@2\ SW\)], ".", 
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]1\),
                              SequenceForm[ "p", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MD\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Glu"\[InvisibleSpace]1\),
                          SequenceForm[ "Glu", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "8", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(3)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]2\),
                          SequenceForm[ "k", 2],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], "]"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(5)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]1\),
                          SequenceForm[ "k", 1],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"]}], "]"}]}]}], ")"}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp\  // Length\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(strm = OpenWrite["\<test.amp\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`OutputStream["test.amp", 10]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Write[strm, famp]\), "\[IndentingNewLine]", 
    \(Close[strm]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"test.amp"\)], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["q g -> w q", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(\(tops = 
        CreateTopologies[0, 4];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[tops, {F[3, {1}], V[5]} \[Rule] {F[3, {1}], \(+V[1]\)}, 
          Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Paint[ins, ColumnsXRows \[Rule] {2, 1}, 
        PaintLevel \[Rule] {Classes}];\)\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 4, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes insertions"\
\),
        SequenceForm[ "in total: ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 -1.40675e-17 0.0227273 [
[ 0 0 0 0 ]
[ 1 .65 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65 L
0 .65 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -1.40675e-17 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.31818 .5 L
s
.20277 .59618 m
.14923 .61713 L
.17251 .64506 L
F
gsave
.16421 .587 -74.125 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.3169 .49329 L
.31449 .48684 L
.311 .48088 L
.30651 .47563 L
.30116 .47127 L
.29511 .46793 L
.28858 .4657 L
.28178 .46464 L
.27495 .46472 L
.26834 .46589 L
.26218 .46802 L
.25666 .47098 L
.25198 .47456 L
.24827 .47853 L
.24562 .48267 L
.2441 .48672 L
.2437 .49045 L
.24436 .49361 L
.24598 .49601 L
.24842 .49748 L
.2515 .4979 L
.255 .49718 L
.2587 .49531 L
.26236 .49229 L
.26573 .48822 L
.2686 .48322 L
.27076 .47746 L
.27205 .47113 L
.27233 .46447 L
.27152 .45772 L
.26959 .45113 L
.26655 .44494 L
.26247 .43937 L
.25746 .43461 L
.25169 .43082 L
.24533 .42811 L
.23862 .42656 L
.23178 .42616 L
.22505 .42687 L
.21867 .42862 L
.21285 .43125 L
.20779 .43459 L
.20366 .43842 L
.20055 .44252 L
.19855 .44664 L
.19768 .45053 L
.1979 .45396 L
.19913 .45671 L
.20124 .45859 L
Mistroke
.20407 .45947 L
.20742 .45924 L
.21107 .45785 L
.21477 .45532 L
.21829 .45168 L
.2214 .44706 L
.22389 .44159 L
.22556 .43548 L
.22628 .42893 L
.22594 .42219 L
.22449 .41551 L
.22191 .40912 L
.21826 .40325 L
.21363 .39813 L
.20816 .39391 L
.20203 .39074 L
.19544 .38869 L
.18862 .3878 L
.18181 .38805 L
.17526 .38937 L
.16917 .39165 L
.16378 .39471 L
.15923 .39836 L
.15568 .40238 L
.1532 .40652 L
.15185 .41054 L
.15161 .41419 L
.15243 .41725 L
.15418 .41952 L
.15674 .42084 L
.15989 .42109 L
.16344 .4202 L
.16715 .41814 L
.17078 .41497 L
.17409 .41074 L
.17686 .40562 L
.1789 .39975 L
.18004 .39336 L
.18016 .38667 L
.17918 .37993 L
.17708 .37339 L
.17387 .36728 L
.16964 .36181 L
.16451 .35719 L
.15863 .35356 L
.15221 .35103 L
.14546 .34965 L
.13862 .34942 L
.13193 .3503 L
.12562 .35219 L
Mistroke
.11991 .35494 L
.11498 .35837 L
.11099 .36227 L
.10805 .36639 L
.10623 .37049 L
.10552 .37432 L
.1059 .37766 L
.10727 .38029 L
.10951 .38203 L
.11243 .38274 L
.11584 .38234 L
.11951 .38077 L
.1232 .37806 L
.12667 .37427 L
.1297 .36951 L
.13207 .36393 L
.13361 .35774 L
.13418 .35115 L
.13367 .3444 L
.13204 .33774 L
.1293 .33142 L
.12549 .32566 L
.12072 .32066 L
.11514 .31659 L
.10892 .31358 L
.10228 .31171 L
.09545 .311 L
.08867 .31142 L
.08217 .3129 L
.07618 .3153 L
.0709 .31847 L
.0665 .32219 L
.0631 .32625 L
.0608 .33038 L
.05962 .33436 L
.05954 .33794 L
.06051 .34089 L
.0624 .34303 L
.06505 .34419 L
.06828 .34427 L
.07187 .3432 L
.07558 .34097 L
.07918 .33763 L
.08242 .33326 L
.08509 .32801 L
.08701 .32205 L
.088 .3156 L
.08795 .30888 L
.0868 .30216 L
.08453 .29566 L
Mistroke
.08116 .28964 L
.07679 .28429 L
.07153 .27981 L
.06555 .27634 L
.05907 .27398 L
.05229 .27278 L
.04545 .27273 L
Mfstroke
gsave
.19943 .35973 -61 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.68182 .5 L
s
.83913 .6311 m
.78559 .61014 L
.80887 .58221 L
F
gsave
.80057 .64027 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68274 .49399 L
.68399 .48838 L
.68587 .48353 L
.68859 .47968 L
.69224 .47696 L
.69681 .47534 L
.70217 .47465 L
.70805 .47461 L
.71417 .47483 L
.72017 .47493 L
.72573 .47449 L
.73058 .47321 L
.73455 .47086 L
.73758 .46738 L
.73972 .46284 L
.74115 .45745 L
.74214 .45153 L
.74302 .44547 L
.74413 .43969 L
.74577 .43455 L
.74819 .43034 L
.75153 .42724 L
.75581 .42526 L
.76092 .42429 L
.76666 .42407 L
.77274 .42425 L
.77881 .42444 L
.78455 .42422 L
.78967 .42324 L
.79395 .42127 L
.79728 .41816 L
.7997 .41396 L
.80135 .40882 L
.80245 .40303 L
.80333 .39698 L
.80432 .39106 L
.80575 .38567 L
.80789 .38113 L
.81092 .37765 L
.81489 .3753 L
.81974 .37402 L
.8253 .37358 L
.8313 .37367 L
.83742 .3739 L
.8433 .37385 L
.84866 .37316 L
.85323 .37154 L
.85688 .36882 L
.8596 .36497 L
Mistroke
.86148 .36011 L
.86273 .35451 L
.86365 .3485 L
.86456 .34249 L
.86581 .33688 L
.86769 .33203 L
.87041 .32818 L
.87406 .32545 L
.87864 .32383 L
.88399 .32314 L
.88988 .3231 L
.89599 .32332 L
.90199 .32341 L
.90755 .32298 L
.9124 .32169 L
.91637 .31934 L
.9194 .31586 L
.92154 .31132 L
.92297 .30593 L
.92396 .30001 L
.92484 .29395 L
.92594 .28817 L
.92758 .28303 L
.93 .27882 L
.93334 .27572 L
.93761 .27374 L
.94273 .27277 L
.94847 .27255 L
.95455 .27273 L
Mfstroke
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.68182 .5 L
s
.52727 .5 m
.47273 .48182 L
.47273 .51818 L
F
gsave
.5 .45704 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N1) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -1.40675e-17 1 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.49487 .31302 L
.48886 .30886 L
.48215 .30589 L
.47501 .30427 L
.46768 .30406 L
.46045 .30527 L
.45359 .30783 L
.44734 .31158 L
.44192 .31632 L
.43751 .3218 L
.43423 .3277 L
.43215 .33372 L
.43125 .33953 L
.43149 .34481 L
.43273 .34927 L
.4348 .35267 L
.43749 .35482 L
.44054 .3556 L
.44369 .35495 L
.44666 .3529 L
.44919 .34955 L
.45103 .34505 L
.45198 .33964 L
.45188 .33358 L
.45062 .32718 L
.44817 .32078 L
.44453 .31468 L
.4398 .3092 L
.43411 .30462 L
.42765 .30117 L
.42064 .29901 L
.41335 .29824 L
.40605 .29891 L
.39901 .30095 L
.3925 .30425 L
.38673 .30864 L
.38191 .31386 L
.37818 .31964 L
.37563 .32565 L
.37427 .33158 L
.37408 .3371 L
.37494 .34191 L
.37671 .34575 L
.37919 .34841 L
.38213 .34974 L
.38528 .34965 L
.38835 .34814 L
.39108 .34527 L
.39322 .3412 L
Mistroke
.39454 .33611 L
.39486 .33027 L
.39406 .32397 L
.39208 .31753 L
.3889 .31128 L
.38458 .30552 L
.37924 .30056 L
.37305 .29664 L
.36623 .29396 L
.35902 .29264 L
.35169 .29275 L
.34452 .29427 L
.33777 .2971 L
.33169 .30109 L
.32648 .30601 L
.32231 .31161 L
.31929 .31757 L
.31747 .32357 L
.31683 .32929 L
.31729 .33441 L
.31874 .33866 L
.32096 .3418 L
.32376 .34366 L
.32685 .34413 L
.32999 .34317 L
.33288 .34082 L
.33528 .3372 L
.33694 .33248 L
.33767 .3269 L
.33732 .32074 L
.3358 .31432 L
.33309 .30795 L
.3292 .30197 L
.32425 .29666 L
.31837 .29231 L
.31176 .28913 L
.30468 .28727 L
.29736 .28682 L
.29009 .28779 L
.28315 .29012 L
.27678 .29368 L
.27121 .29827 L
.26662 .30364 L
.26314 .3095 L
.26085 .31552 L
.25975 .32139 L
.2598 .32678 L
.26088 .3314 L
.26282 .335 L
.26542 .33737 L
Mistroke
.26843 .33839 L
.27159 .33799 L
.27461 .33618 L
.27723 .33303 L
.2792 .32872 L
.28031 .32345 L
.2804 .31748 L
.27935 .31112 L
.2771 .30469 L
.27366 .29852 L
.26911 .29292 L
.26357 .28816 L
.25722 .2845 L
.25029 .28211 L
.24303 .2811 L
.23572 .28152 L
.22861 .28334 L
.22199 .28644 L
.21608 .29065 L
.21109 .29575 L
.20717 .30145 L
.20441 .30745 L
.20284 .31342 L
.20246 .31903 L
.20315 .32399 L
.20478 .32801 L
.20715 .33088 L
.21003 .33245 L
.21316 .3326 L
.21627 .33133 L
.21907 .32869 L
.22133 .32481 L
.2228 .31989 L
.2233 .31415 L
.22271 .30791 L
.22093 .30147 L
.21795 .29516 L
.21382 .2893 L
.20864 .28419 L
.20259 .28007 L
.19586 .27717 L
.1887 .27561 L
.18137 .27547 L
.17415 .27675 L
.16731 .27937 L
.1611 .28317 L
.15573 .28796 L
.15137 .29346 L
.14815 .29938 L
.14612 .3054 L
Mistroke
.14528 .31119 L
.14557 .31643 L
.14685 .32085 L
.14896 .3242 L
.15167 .32629 L
.15474 .327 L
.15788 .32628 L
.16084 .32417 L
.16334 .32075 L
.16514 .31621 L
.16604 .31076 L
.16588 .30468 L
.16457 .29828 L
.16206 .29188 L
.15837 .2858 L
.15359 .28036 L
.14785 .27583 L
.14136 .27244 L
.13433 .27034 L
.12704 .26965 L
.11975 .27038 L
.11273 .27248 L
.10624 .27585 L
.10052 .28028 L
.09575 .28553 L
.09207 .29133 L
.08958 .29735 L
.08828 .30326 L
.08813 .30876 L
.08905 .31353 L
.09086 .31732 L
.09336 .31992 L
.09632 .32118 L
.09947 .32102 L
.10253 .31944 L
.10524 .31652 L
.10734 .31239 L
.10861 .30727 L
.10889 .3014 L
.10803 .29508 L
.10599 .28864 L
.10275 .28241 L
.09838 .27668 L
.093 .27177 L
.08678 .26791 L
.07993 .26529 L
.07271 .26404 L
.06538 .26421 L
.05822 .2658 L
.0515 .26869 L
Mistroke
.04545 .27273 L
Mfstroke
gsave
.27974 .25284 -67.5625 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.5 .31818 L
s
.74754 .54097 m
.69484 .518 L
.71916 .49097 L
F
gsave
.81534 .64005 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50078 .67586 L
.50187 .67025 L
.50357 .66531 L
.50608 .66128 L
.5095 .65826 L
.51384 .65626 L
.51897 .65514 L
.52469 .65468 L
.53072 .65455 L
.53672 .6544 L
.54237 .65386 L
.54741 .65264 L
.55163 .65051 L
.55493 .64735 L
.55732 .64319 L
.55893 .63814 L
.55996 .63247 L
.56072 .62649 L
.56152 .62055 L
.56268 .61502 L
.56447 .61019 L
.5671 .60628 L
.57065 .60341 L
.5751 .60153 L
.58033 .60052 L
.58611 .60012 L
.59214 .60001 L
.59812 .59982 L
.60371 .59921 L
.60865 .59788 L
.61275 .59562 L
.61592 .59232 L
.6182 .58803 L
.61971 .58288 L
.62069 .57715 L
.62143 .57115 L
.62226 .56525 L
.62349 .5598 L
.62539 .55508 L
.62813 .55131 L
.6318 .54857 L
.63637 .54682 L
.64169 .5459 L
.64752 .54556 L
.65357 .54546 L
.6595 .54524 L
.66502 .54455 L
.66986 .5431 L
.67384 .5407 L
Mistroke
.67689 .53727 L
.67905 .53285 L
.68048 .52761 L
.68141 .52182 L
.68214 .51581 L
.68301 .50995 L
.68431 .50458 L
.68631 .49998 L
.68918 .49634 L
.69297 .49374 L
.69765 .49211 L
.70305 .49129 L
.70893 .491 L
.71498 .4909 L
.72088 .49064 L
.72632 .48986 L
.73105 .48829 L
.73491 .48576 L
.73784 .48219 L
.73989 .47765 L
.74123 .47232 L
.74212 .46648 L
.74285 .46047 L
.74376 .45466 L
.74514 .44937 L
.74725 .44489 L
.75024 .44139 L
.75415 .43892 L
.75894 .43742 L
.76442 .43668 L
.77034 .43644 L
.77639 .43634 L
.78224 .43602 L
.7876 .43515 L
.79222 .43347 L
.79596 .43079 L
.79876 .42709 L
.80071 .42243 L
.80197 .41701 L
.80282 .41113 L
.80356 .40513 L
.80451 .39936 L
.80598 .39417 L
.80819 .38982 L
.8113 .38645 L
.81534 .38412 L
.82023 .38273 L
.82579 .38208 L
.83174 .38187 L
.83779 .38176 L
Mistroke
.84359 .38139 L
.84886 .38043 L
.85337 .37861 L
.85698 .3758 L
.85967 .37196 L
.86151 .36719 L
.8627 .36169 L
.86351 .35577 L
.86426 .34978 L
.86526 .34408 L
.86682 .33898 L
.86915 .33475 L
.87239 .33153 L
.87655 .32933 L
.88154 .32805 L
.88716 .32747 L
.89315 .3273 L
.89918 .32718 L
.90493 .32674 L
.91011 .32568 L
.9145 .32374 L
.91799 .32079 L
.92055 .31682 L
.9223 .31193 L
.92342 .30636 L
.9242 .30041 L
.92496 .29444 L
.92603 .2888 L
.92767 .28381 L
.93012 .2797 L
.93348 .27661 L
.93776 .27454 L
.94284 .27337 L
.94853 .27287 L
.95455 .27273 L
Mfstroke
gsave
.84375 .41277 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.46158 .5 -74.125 -10.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N2) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 .59 -68.4688 -12.4688 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.9375 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59 -71.0938 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.312 moveto
(\\256) show
79.188 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 .59 -68.2188 -12.1562 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.438 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 187.188},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`000162000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00h`3oool800000<D0oooo000:0?ooo`800000_`3oool3000001<0oooo
0`0000070?ooo`040000003oool0oooo0?ooo`P00000[03oool2000000/0oooo000<0?ooo`<00000
^P3oool200000240oooo00<000000?ooo`0000001`3oool2000000@0oooo1`00002M0?ooo`<00000
3@3oool000l0oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0Q0?ooo`8000002P3o
ool010000000oooo0?ooo`0000060?ooo`8000001@3oool500000940oooo00<000000?ooo`3oool0
3P3oool00100oooo00<000000?ooo`3oool0]03oool00`000000oooo0?ooo`0R0?ooo`8000002`3o
ool2000000T0oooo00<000000?ooo`3oool00`0000040?ooo`8000001P3oool3000008H0oooo00<0
00000?ooo`3oool03P3oool00140oooo00<000000?ooo`3oool0/`3oool00`000000oooo0?ooo`0Q
0?ooo`040000003oool0oooo000000X0oooo0P00000:0?ooo`800000203oool2000000<0oooo0`00
00000`3oool000000000000200000880oooo00<000000?ooo`3oool03`3oool00180oooo00<00000
0?ooo`3oool0/P3oool00`000000oooo0?ooo`0P0?ooo`8000000P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0000000T0oooo0`00000:0?ooo`<000001`3oool2000000@0oooo1P00001g
0?ooo`030000003oool0oooo00l0oooo000B0?ooo`030000003oool0oooo0;80oooo00<000000?oo
o`3oool0803oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?ooo`3oool000002@3o
ool010000000oooo0000000000090?ooo`8000002P3oool010000000oooo0000000000060?ooo`<0
0000103oool5000006/0oooo00<000000?ooo`3oool03`3oool00180oooo00<000000?ooo`3oool0
/@3oool200000280oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000000X0oooo0P0000090?ooo`D000001@3oool3000000@0oooo1@0000020?ooo`D00000F03oool0
0`000000oooo0?ooo`0?0?ooo`004`3oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo
0240oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000
2@3oool00`000000oooo0000000:0?ooo`030000003oool0oooo00P0oooo0P0000000`3oool00000
000000040?ooo`T00000E`3oool00`000000oooo0?ooo`0?0?ooo`004@3oool800000:d0oooo00<0
00000?ooo`3oool08@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001`3oool200000080
oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000090?ooo`030000003oool00000
00/0oooo0P0000070?ooo`L00000EP3oool00`000000oooo0?ooo`0@0?ooo`003`3oool200000080
oooo00<000000?ooo`3oool00P3oool200000:/0oooo0P00000T0?ooo`040000003oool0oooo0000
00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo
0?ooo`0000001`3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool00P00
00070?ooo`80000000<0oooo0000003oool02@3oool2000000L0oooo2000001F0?ooo`030000003o
ool0oooo0100oooo000>0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?oo
o`2P0?ooo`P000009P3oool3000000T0oooo00@000000?ooo`3oool00000203oool01@000000oooo
0?ooo`3oool0000000L0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000P0oooo00<00000
0?ooo`000000203oool7000005D0oooo0P00000B0?ooo`003@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0W@3oool2000003X0oooo100000080?oo
o`050000003oool0oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000
1`3oool01@000000oooo0?ooo`3oool0000000L0oooo1`00001>0?ooo`L00000503oool000d0oooo
00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo09`0oooo00<000000?ooo`3o
ool0AP3oool3000000P0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000L0oooo00D00000
0?ooo`3oool0oooo000000080?ooo`L00000B`3oool2000001/0oooo000=0?ooo`050000003oool0
oooo0?ooo`0000002P3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo05<0oooo00<0
00000?ooo`000000203oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3oool010000000
oooo0?ooo`3oool2000004T0oooo00<000000?ooo`3oool06`3oool000d0oooo00@000000?ooo`3o
ool000002`3oool2000009`0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`080?oo
o`040000003oool0oooo000000P0oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003o
ool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`020?ooo`800000B03oool00`000000oooo
0?ooo`0K0?ooo`003@3oool3000000d0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?oo
o`1P0?ooo`8000002@3oool010000000oooo0?ooo`0000080?ooo`050000003oool0oooo0?ooo`00
00002P3oool00`000000oooo0?ooo`030?ooo`800000AP3oool00`000000oooo0?ooo`0L0?ooo`00
703oool6000009P0oooo00<000000?ooo`3oool0K03oool3000000P0oooo00D000000?ooo`3oool0
oooo0000000:0?ooo`030000003oool0oooo00@0oooo0P0000150?ooo`030000003oool0oooo01`0
oooo000J0?ooo`80000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`2D0?ooo`030000
003oool0oooo07T0oooo0`00000;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
@P3oool00`000000oooo0?ooo`0L0?ooo`006@3oool01@000000oooo0?ooo`3oool0000000D0oooo
00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0L0?ooo`00603oool01@000000oooo0?oo
o`3oool0000000L0oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`270?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0L0?ooo`005`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0T03o
ool00`000000oooo0?ooo`280?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0M0?ooo`005P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0Q`3oool8000008/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0m0?ooo`030000003oool0oooo01d0oooo000G0?ooo`040000003oool0oooo
000000/0oooo00<000000?ooo`3oool0Q@3oool2000009<0oooo00<000000?ooo`3oool02`3oool2
000003`0oooo00<000000?ooo`3oool07P3oool001L0oooo0`00000<0?ooo`030000003oool0oooo
08D0oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`0<0?ooo`800000<P3oool90000
0240oooo000V0?ooo`D00000PP3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo00d0
oooo0P00000a0?ooo`030000003oool0oooo02L0oooo000T0?ooo`@000000`3oool200000800oooo
00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`0>0?ooo`800000;`3oool00`000000oooo
0?ooo`0X0?ooo`008P3oool200000080oooo0P0000040?ooo`<00000OP3oool00`000000oooo0?oo
o`2C0?ooo`030000003oool0oooo00l0oooo0P00000]0?ooo`030000003oool0oooo02T0oooo000Q
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool2000007`0oooo0P00002E
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0Y
0?ooo`008@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0NP3oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`0Y0?ooo`00803oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`2D0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0Y0?ooo`00
803oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
N@3oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0Y0?ooo`008@3oool4000000/0oooo00<000000?ooo`3oool0N03o
ool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0Y0?ooo`00<03oool3000006l0oooo2@00002H0?ooo`030000003oool0
oooo01H0oooo0P00000U0?ooo`030000003oool0oooo02X0oooo000_0?ooo`<0000000<0oooo0000
000000000P00001Z0?ooo`800000X03oool00`000000oooo0?ooo`0G0?ooo`8000008`3oool20000
02`0oooo000/0?ooo`<0000000<0oooo0000003oool01@3oool00`000000oooo0?ooo`1V0?ooo`03
0000003oool0oooo0:00oooo00<000000?ooo`3oool0603oool200000200oooo0P00000^0?ooo`00
;03oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0I@3oool00`000000
oooo0?ooo`2P0?ooo`030000003oool0oooo01T0oooo0P00000H0?ooo`L00000<03oool002/0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`800000IP3oool00`000000oooo
0?ooo`2P0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0e0?ooo`00:P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0I03oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool04P3oool2000003L0oooo000Z0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo0:40oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03H0oooo000[0?oo
o`040000003oool00000000000/0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`2Q
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0f
0?ooo`00;03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0680oooo00<000000?oo
o`3oool0X@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0=P3oool003P0oooo2@00001N0?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3o
ool0803oool2000000l0oooo00<000000?ooo`3oool0=P3oool003L0oooo00@000000?ooo`3oool0
00001@3oool2000005`0oooo00<000000?ooo`3oool0XP3oool00`000000oooo0?ooo`0Q0?ooo`80
00003P3oool00`000000oooo0?ooo`0f0?ooo`00=P3oool01@000000oooo0?ooo`3oool0000000L0
oooo00<000000?ooo`3oool0D03oool900000:D0oooo00<000000?ooo`3oool08P3oool2000000`0
oooo0P00000h0?ooo`00=@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo02<0oooo
0P00000;0?ooo`030000003oool0oooo03L0oooo000e0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool5000001l0oooo0`00000X0?ooo`D00000[@3oool00`000000oooo0?oo
o`0T0?ooo`8000002@3oool2000003T0oooo000d0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool7000001h0oooo1P00000T0?ooo`L00000Z`3oool3000002L0oooo00<00000
0?ooo`0000001P00000k0?ooo`00=03oool00`000000oooo0?ooo`02000000P0oooo1`00000N0?oo
o`T000008@3oool700000:/0oooo0`00000W0?ooo`800000103oool00`000000oooo0?ooo`0k0?oo
o`00=@3oool3000000P0ooooE`00002[0?ooo`<000009P3oool010000000oooo0?ooo`0000020?oo
o`<00000?03oool00440oooo1`00000N0?ooo`T000008@3oool700000:X0oooo1@00000T0?ooo`03
0000003oool0oooo0080oooo1@00000l0?ooo`00@@3oool7000001h0oooo1P00000T0?ooo`L00000
ZP3oool5000002@0oooo00<000000?ooo`3oool00P3oool6000003/0oooo00100?ooo`L000007`3o
ool3000002P0oooo1`00002Y0?ooo`D00000903oool010000000oooo0?ooo`3oool7000003/0oooo
000o0?ooo`8000000`3oool00`000000oooo0?ooo`1<0?ooo`040000003oool0oooo0?ooo`800000
Y`3oool7000002<0oooo00<000000?ooo`3oool02@00000j0?ooo`00?P3oool00`000000oooo0?oo
o`1H0?ooo`030000003oool0oooo0:@0oooo1`00000S0?ooo`030000003oool0oooo00<0oooo1P00
000j0?ooo`00?@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0:80oooo2000000R
0?ooo`030000003oool0oooo00H0oooo1@00000i0?ooo`00>`3oool2000005h0oooo0P00002V0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool0203oool3000003T0oooo000j0?ooo`80
0000H03oool200000:D0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0:0?ooo`80
0000>03oool003T0oooo0P00001R0?ooo`800000Y03oool00`000000oooo0?ooo`0R0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0=@3oool003P0oooo00<000000?ooo`3oool0I03o
ool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo01X0oooo2000000A0?ooo`030000003o
ool0oooo03@0oooo000g0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0X03oool0
0`000000oooo0?ooo`0H0?ooo`8000006P3oool00`000000oooo0?ooo`0c0?ooo`00=P3oool00`00
0000oooo0?ooo`1X0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo0380oooo000d0?ooo`800000K03oool2000009l0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0L0?ooo`800000<P3oool003<0oooo
0P00001^0?ooo`800000WP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01d0oooo
0P00000a0?ooo`00<P3oool200000700oooo0P00002M0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool07P3oool200000300oooo000a0?ooo`030000003oool0oooo0780oooo00<00000
0?ooo`3oool0VP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01l0oooo0P00000_
0?ooo`00<03oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo09T0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0P0?ooo`800000;P3oool002h0oooo0P00001h0?ooo`80
0000V@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0:`3oool002d0oooo0P00001j0?ooo`8000000`3oool00`000000oooo0?ooo`2B0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0Z0?ooo`00;03o
ool2000007`0oooo0P000000103oool0000000000000002C0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0Y0?ooo`00:`3oool00`000000oooo0?oo
o`1n0?ooo`@00000T`3oool00`000000oooo0?ooo`0D0?ooo`800000:@3oool00`000000oooo0?oo
o`0X0?ooo`00:@3oool200000800oooo1P00002B0?ooo`030000003oool0oooo00d0oooo1`00000/
0?ooo`030000003oool0oooo02L0oooo000W0?ooo`<00000P03oool700000980oooo00<000000?oo
o`3oool02`3oool2000003@0oooo0P00000W0?ooo`009@3oool5000007l0oooo2@00002A0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0=@3oool2000002H0oooo000S0?ooo`H00000
P`3oool600000940oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0f0?ooo`800000
9@3oool00200oooo2@0000250?ooo`D00000T03oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo03L0oooo0P00000T0?ooo`008@3oool7000008P0oooo1000002?0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0Q0?ooo`008P3oool60000
08X0oooo0`00002>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0P0?ooo`008@3oool6000008h0oooo0P00002<0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0O0?ooo`00803oool200000080oooo
0`00002?0?ooo`800000R`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03d0oooo
00<000000?ooo`3oool07P3oool001l0oooo0P0000040?ooo`030000003oool0oooo08l0oooo0P00
002:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?oo
o`0M0?ooo`007P3oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo08L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`100?ooo`8000007@3oool001d0oooo00<000000?oo
o`3oool0VP3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo00D0oooo100000130?oo
o`800000703oool001/0oooo0P00002N0?ooo`800000QP3oool00`000000oooo00000006000004L0
oooo0P00000K0?ooo`006P3oool200000:00oooo0P0000250?ooo`800000C`3oool2000001X0oooo
000I0?ooo`800000XP3oool200000880oooo1@00001?0?ooo`8000006@3oool001P0oooo00<00000
0?ooo`3oool0Y03oool00`000000oooo0?ooo`1n0?ooo`L00000D03oool00`000000oooo0?ooo`0F
0?ooo`005`3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo07d0oooo1`00001A0?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3o
ool0N`3oool800000580oooo00<000000?ooo`3oool0503oool001@0oooo0P00002/0?ooo`800000
L@3oool:000000030?ooo`000000000000D00000D`3oool00`000000oooo0?ooo`0C0?ooo`004`3o
ool200000:h0oooo0P00001V0?ooo`X000002`3oool7000005@0oooo00<000000?ooo`3oool04P3o
ool00180oooo0P00002`0?ooo`800000AP3oool400000140oooo2P00000F0?ooo`D00000EP3oool2
00000180oooo000A0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool0@`3oool80000
00<0oooo2P00000R0?ooo`030000003oool0oooo05L0oooo0P00000A0?ooo`00403oool00`000000
oooo0?ooo`2d0?ooo`030000003oool0oooo0480oooo300000260?ooo`800000403oool000h0oooo
0P00002h0?ooo`800000>P3ooolB000008T0oooo0P00000?0?ooo`003@3oool200000;X0oooo0P00
000_0?ooo`X00000203oool8000008`0oooo0P00000>0?ooo`00303oool200000;`0oooo0P00000T
0?ooo`X000004P3oool500000940oooo00<000000?ooo`3oool02`3oool000/0oooo00<000000?oo
o`3oool0_P3oool00`000000oooo0?ooo`0G0?ooo`X00000703oool3000009@0oooo00<000000?oo
o`3oool02P3oool000X0oooo00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`0A0?ooo`D0
0000_P3oool00`000000oooo0?ooo`090?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {279.75, 0}} -> {-0.0314566, 6.18969*^-16, \
0.153351, 0.153351}, {{0.25, 215.5}, {279.75, 64.5}} -> {-1.02566, -1.00011, \
0.153312, 0.153312}, {{215.5, 430.688}, {279.75, 64.5}} -> {-23.0323, \
-1.0033, 0.153356, 0.153356}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp = CreateFeynAmp[ins]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes amplitudes"\
\),
        SequenceForm[ "in total: ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), 
            ",", \(ExcludeParticles \[Rule] {}\), 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(V(5)\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "0"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(V(1)\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "0"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                  Number == 1)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]1\),
                              SequenceForm[ "k", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                            "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "-", 
                          
                          RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                            " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MU", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], "+", 
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "k", 2],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}], "-", 
                          RowBox[{"\[ImaginaryI]", " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}]}], ")"}], ".",
                       
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]1\),
                              SequenceForm[ "p", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  RowBox[{
                    FormBox["\<\"ep\"\>",
                      "TraditionalForm"], "(", 
                    RowBox[{\(V(5)\), ",", 
                      FormBox[
                        InterpretationBox[\("p"\[InvisibleSpace]2\),
                          SequenceForm[ "p", 2],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("k"\[InvisibleSpace]1\
\),
                                      SequenceForm[ "k", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MU\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Glu"\[InvisibleSpace]1\),
                          SequenceForm[ "Glu", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "8", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(1)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]2\),
                          SequenceForm[ "k", 2],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], "]"}]}]}], ")"}], ",", 
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 2, Generic == 1, Classes == 1, 
                  Number == 2)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]1\),
                              SequenceForm[ "k", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}], "-", 
                          RowBox[{"\[ImaginaryI]", " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], " ", 
                            RowBox[{"SUNT", "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("Glu"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Glu", 1],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Col", 2],
                                    Editable->False],
                                  "TraditionalForm"], ",", 
                                FormBox[
                                  
                                  InterpretationBox[\("Col"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Col", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}]}], ")"}], ".",
                       
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MU", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], "-", 
                                FormBox[
                                  InterpretationBox[\("p"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "p", 2],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                            "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "-", 
                          
                          RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                            " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"\<\"u\"\>", "[", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("p"\[InvisibleSpace]1\),
                              SequenceForm[ "p", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], "]"}]}],
                    "TraditionalForm"], " ", 
                  RowBox[{
                    FormBox["\<\"ep\"\>",
                      "TraditionalForm"], "(", 
                    RowBox[{\(V(5)\), ",", 
                      FormBox[
                        InterpretationBox[\("p"\[InvisibleSpace]2\),
                          SequenceForm[ "p", 2],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                          SequenceForm[ "Lor", 1],
                          Editable->False],
                        "TraditionalForm"]}], ")"}], " ", 
                  FormBox[
                    FractionBox["1", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "2"], 
                        "-", \(MU\^2\)}]],
                    "TraditionalForm"], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]1\),
                          SequenceForm[ "Col", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Col"\[InvisibleSpace]2\),
                          SequenceForm[ "Col", 2],
                          Editable->False],
                        "TraditionalForm"], ",", "3", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{"SumOver", "(", 
                    RowBox[{
                      FormBox[
                        InterpretationBox[\("Glu"\[InvisibleSpace]1\),
                          SequenceForm[ "Glu", 1],
                          Editable->False],
                        "TraditionalForm"], ",", "8", ",", "External"}], 
                    ")"}], " ", 
                  RowBox[{
                    RowBox[{"(", 
                      FormBox[
                        InterpretationBox[
                          RowBox[{
                            FormBox["\<\"ep\"\>",
                              "TraditionalForm"], "\[InvisibleSpace]", 
                            InterpretationBox[\(\[Null]\^"*"\),
                              Superscript[ "*"],
                              Editable->False]}],
                          SequenceForm[ PolarizationVector, 
                            Superscript[ "*"]],
                          Editable->False],
                        "TraditionalForm"], ")"}], "[", 
                    RowBox[{\(V(1)\), ",", 
                      FormBox[
                        InterpretationBox[\("k"\[InvisibleSpace]2\),
                          SequenceForm[ "k", 2],
                          Editable->False],
                        "TraditionalForm"], ",", 
                      FormBox[
                        InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                          SequenceForm[ "Lor", 2],
                          Editable->False],
                        "TraditionalForm"]}], "]"}]}]}], ")"}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(famp\  // Length\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(strm = OpenWrite["\<test.amp\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`OutputStream["test.amp", 11]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Write[strm, famp]\), "\[IndentingNewLine]", 
    \(Close[strm]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"test.amp"\)], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Direct Photon Production: 1 Loops (19 diagrams)", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(tops = 
        CreateTopologies[1, 4, 
          ExcludeTopologies \[Rule] {Internal}];\)\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(ins = 
        InsertFields[tops, {V[5], F[3, {1}]} \[Rule] {V[1], F[3, {1}]}, 
          Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}];\)\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(Paint[ins, ColumnsXRows \[Rule] 5, PaintLevel \[Rule] {Classes}, 
        AutoEdit \[Rule] False];\)\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 4, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]5\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 5, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]6\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 6, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]7\[InvisibleSpace]": "\
\[InvisibleSpace]"7 Classes insertions"\),
        SequenceForm[ "> Top. ", 7, ": ", "7 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]8\[InvisibleSpace]": "\
\[InvisibleSpace]"5 Classes insertions"\),
        SequenceForm[ "> Top. ", 8, ": ", "5 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]9\[InvisibleSpace]": "\
\[InvisibleSpace]"7 Classes insertions"\),
        SequenceForm[ "> Top. ", 9, ": ", "7 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]10\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 10, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]11\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 11, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]12\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 12, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"19 Classes \
insertions"\),
        SequenceForm[ "in total: ", "19 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"7 diagrams"\),
        SequenceForm[ "> Top. ", 1, ": ", "7 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"5 diagrams"\),
        SequenceForm[ "> Top. ", 2, ": ", "5 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"7 diagrams"\),
        SequenceForm[ "> Top. ", 3, ": ", "7 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.42861e-17 0.00909091 -2.29309e-17 0.00909091 [
[ 0 0 0 0 ]
[ 1 1.06 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.06 L
0 1.06 L
closepath
clip
newpath
% Start of sub-graphic
p
2.42861e-17 0.8 0.2 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .34091 m
.65909 .34091 L
s
gsave
.5 .30931 -65.2188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
67.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ ] 0 setdash
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N1) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.2 0.8 0.4 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .34091 m
.65909 .34091 L
s
gsave
.5 .30931 -67.3125 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 8.813 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
[ ] 0 setdash
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C2) show
77.562 11.250 moveto
(N2) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.4 0.8 0.6 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -65.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .34091 m
.65909 .34091 L
s
.47273 .34091 m
.52727 .32273 L
.52727 .35909 L
F
gsave
.5 .29795 -65.4062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ ] 0 setdash
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C3) show
77.562 11.250 moveto
(N3) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.6 0.8 0.8 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
gsave
.5 .29795 -64.625 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N4) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.8 0.8 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
gsave
.5 .29795 -64.875 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Z) show
66.750 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C2) show
77.562 11.250 moveto
(N5) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
2.42861e-17 0.6 0.2 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -65.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
.47273 .34091 m
.52727 .32273 L
.52727 .35909 L
F
gsave
.5 .29795 -65.9062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
68.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C3) show
77.562 11.250 moveto
(N6) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.2 0.6 0.4 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.6644 .6565 L
.66962 .65431 L
.67467 .65288 L
.67948 .65247 L
.68402 .65324 L
.68828 .65522 L
.69228 .65831 L
.69607 .66229 L
.69974 .66682 L
.70337 .67152 L
.70705 .676 L
.71088 .67986 L
.71491 .68281 L
.71921 .68462 L
.72378 .68522 L
.72863 .68465 L
.73371 .68308 L
.73895 .68082 L
.74427 .6782 L
.74957 .67565 L
.75477 .67354 L
.75979 .67224 L
.76456 .67199 L
.76906 .67294 L
.77327 .67509 L
.77724 .67832 L
.78102 .6824 L
.78468 .68698 L
.78831 .69167 L
.792 .69608 L
.79585 .69983 L
.79992 .70262 L
.80426 .70427 L
.80888 .70469 L
.81376 .70396 L
.81886 .70228 L
.82412 .69994 L
.82944 .69731 L
.83474 .69479 L
.83991 .69278 L
.8449 .69162 L
.84963 .69153 L
.85409 .69265 L
.85827 .69497 L
.86221 .69834 L
.86596 .70251 L
.86961 .70713 L
.87325 .71181 L
.87696 .71614 L
Mistroke
.88084 .71977 L
.88494 .72241 L
.88932 .72388 L
.89398 .72413 L
.89889 .72325 L
.90402 .72145 L
.90929 .71904 L
.91462 .71641 L
.9199 .71394 L
.92506 .71203 L
.93001 .71101 L
.9347 .71109 L
.93912 .71238 L
.94326 .71486 L
.94717 .71836 L
.9509 .72262 L
.95455 .72727 L
Mfstroke
gsave
.79098 .73434 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.83339 .30069 m
.78433 .33067 L
.77616 .29523 L
F
gsave
.79098 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65342 .33614 L
.64691 .33253 L
.63981 .33029 L
.63242 .32954 L
.62503 .33033 L
.61794 .33262 L
.61146 .33626 L
.60581 .34107 L
.60122 .34676 L
.59783 .35302 L
.59571 .35949 L
.59487 .36582 L
.59525 .37163 L
.59671 .37661 L
.59905 .38047 L
.60204 .383 L
.60538 .38406 L
.60878 .38358 L
.61194 .38159 L
.61455 .3782 L
.61637 .37361 L
.61717 .36807 L
.6168 .3619 L
.61517 .35544 L
.61225 .34906 L
.60809 .34311 L
.60282 .33794 L
.59663 .33383 L
.58974 .33101 L
.58243 .32965 L
.575 .32982 L
.56775 .33151 L
.56099 .33462 L
.55498 .33899 L
.54994 .34436 L
.54604 .35043 L
.5434 .35686 L
.54205 .36328 L
.54195 .36935 L
.54299 .3747 L
.545 .37905 L
.54775 .38214 L
.55099 .38381 L
.5544 .38395 L
.55769 .38257 L
.56056 .37973 L
.56273 .3756 L
.56397 .37041 L
.56409 .36446 L
Mistroke
.56297 .35807 L
.56057 .35162 L
.55691 .34545 L
.55208 .33993 L
.54623 .33535 L
.53959 .33199 L
.53241 .33002 L
.525 .32956 L
.51764 .33064 L
.51065 .33319 L
.5043 .33708 L
.49884 .34207 L
.49447 .3479 L
.49131 .35422 L
.48943 .36069 L
.48883 .36695 L
.48942 .37263 L
.49106 .37742 L
.49355 .38105 L
.49662 .38331 L
.5 .38408 L
.50338 .38331 L
.50645 .38105 L
.50894 .37742 L
.51058 .37263 L
.51117 .36695 L
.51057 .36069 L
.50869 .35422 L
.50553 .3479 L
.50116 .34207 L
.4957 .33708 L
.48935 .33319 L
.48236 .33064 L
.475 .32956 L
.46759 .33002 L
.46041 .33199 L
.45377 .33535 L
.44792 .33993 L
.44309 .34545 L
.43943 .35162 L
.43703 .35807 L
.43591 .36446 L
.43603 .37041 L
.43727 .3756 L
.43944 .37973 L
.44231 .38257 L
.4456 .38395 L
.44901 .38381 L
.45225 .38214 L
.455 .37905 L
Mistroke
.45701 .3747 L
.45805 .36935 L
.45795 .36328 L
.4566 .35686 L
.45396 .35043 L
.45006 .34436 L
.44502 .33899 L
.43901 .33462 L
.43225 .33151 L
.425 .32982 L
.41757 .32965 L
.41026 .33101 L
.40337 .33383 L
.39718 .33794 L
.39191 .34311 L
.38775 .34906 L
.38483 .35544 L
.3832 .3619 L
.38283 .36807 L
.38363 .37361 L
.38545 .3782 L
.38806 .38159 L
.39122 .38358 L
.39462 .38406 L
.39796 .383 L
.40095 .38047 L
.40329 .37661 L
.40475 .37163 L
.40513 .36582 L
.40429 .35949 L
.40217 .35302 L
.39878 .34676 L
.39419 .34107 L
.38854 .33626 L
.38206 .33262 L
.37497 .33033 L
.36758 .32954 L
.36019 .33029 L
.35309 .33253 L
.34658 .33614 L
.34091 .34091 L
Mfstroke
gsave
.5 .29795 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65909 .34091 L
s
.65909 .47273 m
.64091 .52727 L
.67727 .52727 L
F
gsave
.70205 .5 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
70.000 11.250 moveto
(C4) show
77.562 11.250 moveto
(N7) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.4 0.6 0.6 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.66472 .34233 L
.67005 .34398 L
.67481 .34606 L
.67881 .34872 L
.68191 .35207 L
.68408 .35614 L
.68538 .36087 L
.68595 .36615 L
.68604 .37181 L
.6859 .37763 L
.68585 .38339 L
.68617 .38887 L
.68711 .39387 L
.68887 .39825 L
.69155 .40192 L
.69515 .40489 L
.69959 .40722 L
.70469 .40904 L
.71022 .41054 L
.71588 .41193 L
.72138 .41345 L
.72644 .41531 L
.7308 .41769 L
.73432 .42072 L
.73691 .42446 L
.73859 .4289 L
.73947 .43395 L
.73975 .43946 L
.73968 .44524 L
.73955 .45105 L
.73967 .45669 L
.7403 .46192 L
.74167 .4666 L
.74392 .4706 L
.74711 .47388 L
.75119 .47649 L
.75601 .47852 L
.76138 .48014 L
.76702 .48155 L
.77263 .48298 L
.77792 .48466 L
.78263 .48678 L
.78655 .48951 L
.78956 .49292 L
.79165 .49705 L
.79287 .50184 L
.7934 .50716 L
.79345 .51284 L
.79331 .51867 L
Mistroke
.79328 .52442 L
.79365 .52986 L
.79466 .5348 L
.7965 .53912 L
.79926 .54273 L
.80295 .54564 L
.80745 .54791 L
.81261 .54969 L
.81816 .55117 L
.82382 .55256 L
.82929 .5541 L
.83429 .556 L
.83859 .55843 L
.84203 .56153 L
.84453 .56533 L
.84613 .56983 L
.84695 .57493 L
.84719 .58047 L
.8471 .58626 L
.84698 .59208 L
.84714 .59768 L
.84783 .60287 L
.84928 .60749 L
.85162 .61142 L
.85489 .61464 L
.85904 .61719 L
.86392 .61918 L
.86933 .62077 L
.87498 .62217 L
.88057 .62361 L
.88582 .62532 L
.89046 .62749 L
.8943 .63028 L
.89724 .63376 L
.89924 .63795 L
.90039 .64279 L
.90086 .64815 L
.90089 .65386 L
.90075 .65969 L
.90074 .66541 L
.90116 .67082 L
.90225 .67571 L
.90417 .67996 L
.90701 .68351 L
.91078 .68635 L
.91535 .68858 L
.92056 .69032 L
.92613 .69178 L
.93179 .69317 L
.93723 .69474 L
Mistroke
.94217 .69668 L
.9464 .69917 L
.94975 .70232 L
.95217 .70619 L
.9537 .71075 L
.95445 .7159 L
.95465 .72147 L
.95455 .72727 L
Mfstroke
gsave
.86846 .66805 -68.25 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.82339 .44424 m
.80469 .49862 L
.77581 .47653 L
F
gsave
.86165 .34332 -68.4375 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -65.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .34091 m
.65909 .34091 L
s
.47273 .34091 m
.52727 .32273 L
.52727 .35909 L
F
gsave
.5 .29795 -65.4062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65909 .65909 L
s
.65909 .47273 m
.67727 .52727 L
.64091 .52727 L
F
gsave
.61613 .5 -69.8125 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N8) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.6 0.6 0.8 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.66472 .34233 L
.67005 .34398 L
.67481 .34606 L
.67881 .34872 L
.68191 .35207 L
.68408 .35614 L
.68538 .36087 L
.68595 .36615 L
.68604 .37181 L
.6859 .37763 L
.68585 .38339 L
.68617 .38887 L
.68711 .39387 L
.68887 .39825 L
.69155 .40192 L
.69515 .40489 L
.69959 .40722 L
.70469 .40904 L
.71022 .41054 L
.71588 .41193 L
.72138 .41345 L
.72644 .41531 L
.7308 .41769 L
.73432 .42072 L
.73691 .42446 L
.73859 .4289 L
.73947 .43395 L
.73975 .43946 L
.73968 .44524 L
.73955 .45105 L
.73967 .45669 L
.7403 .46192 L
.74167 .4666 L
.74392 .4706 L
.74711 .47388 L
.75119 .47649 L
.75601 .47852 L
.76138 .48014 L
.76702 .48155 L
.77263 .48298 L
.77792 .48466 L
.78263 .48678 L
.78655 .48951 L
.78956 .49292 L
.79165 .49705 L
.79287 .50184 L
.7934 .50716 L
.79345 .51284 L
.79331 .51867 L
Mistroke
.79328 .52442 L
.79365 .52986 L
.79466 .5348 L
.7965 .53912 L
.79926 .54273 L
.80295 .54564 L
.80745 .54791 L
.81261 .54969 L
.81816 .55117 L
.82382 .55256 L
.82929 .5541 L
.83429 .556 L
.83859 .55843 L
.84203 .56153 L
.84453 .56533 L
.84613 .56983 L
.84695 .57493 L
.84719 .58047 L
.8471 .58626 L
.84698 .59208 L
.84714 .59768 L
.84783 .60287 L
.84928 .60749 L
.85162 .61142 L
.85489 .61464 L
.85904 .61719 L
.86392 .61918 L
.86933 .62077 L
.87498 .62217 L
.88057 .62361 L
.88582 .62532 L
.89046 .62749 L
.8943 .63028 L
.89724 .63376 L
.89924 .63795 L
.90039 .64279 L
.90086 .64815 L
.90089 .65386 L
.90075 .65969 L
.90074 .66541 L
.90116 .67082 L
.90225 .67571 L
.90417 .67996 L
.90701 .68351 L
.91078 .68635 L
.91535 .68858 L
.92056 .69032 L
.92613 .69178 L
.93179 .69317 L
.93723 .69474 L
Mistroke
.94217 .69668 L
.9464 .69917 L
.94975 .70232 L
.95217 .70619 L
.9537 .71075 L
.95445 .7159 L
.95465 .72147 L
.95455 .72727 L
Mfstroke
gsave
.86846 .66805 -68.25 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.82339 .44424 m
.80469 .49862 L
.77581 .47653 L
F
gsave
.86165 .34332 -68.4375 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -65.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .34091 m
.65909 .34091 L
s
.47273 .34091 m
.52727 .32273 L
.52727 .35909 L
F
gsave
.5 .29795 -65.4062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ ] 0 setdash
.65909 .65909 m
.65463 .65454 L
.65088 .65 L
.64845 .64545 L
.64774 .64091 L
.64886 .63636 L
.65162 .63182 L
.65558 .62727 L
.66012 .62273 L
.66448 .61818 L
.66798 .61364 L
.67005 .60909 L
.67036 .60455 L
.66885 .6 L
.66578 .59546 L
.66163 .59091 L
.65707 .58636 L
.65284 .58182 L
.64962 .57727 L
.64792 .57273 L
.64802 .56818 L
.64991 .56364 L
.65327 .55909 L
.65758 .55455 L
.66213 .55 L
.66619 .54545 L
.66911 .54091 L
.67042 .53636 L
.66991 .53182 L
.66766 .52727 L
.66404 .52273 L
.65961 .51818 L
.65511 .51364 L
.65125 .50909 L
.64866 .50455 L
.64774 .5 L
.64866 .49545 L
.65125 .49091 L
.65511 .48636 L
.65961 .48182 L
.66404 .47727 L
.66766 .47273 L
.66991 .46818 L
.67042 .46364 L
.66911 .45909 L
.66619 .45455 L
.66213 .45 L
.65758 .44545 L
.65327 .44091 L
.64991 .43636 L
Mistroke
.64802 .43182 L
.64792 .42727 L
.64962 .42273 L
.65284 .41818 L
.65707 .41364 L
.66163 .40909 L
.66578 .40454 L
.66885 .4 L
.67036 .39545 L
.67005 .39091 L
.66798 .38636 L
.66448 .38182 L
.66012 .37727 L
.65558 .37273 L
.65162 .36818 L
.64886 .36364 L
.64774 .35909 L
.64845 .35455 L
.65088 .35 L
.65463 .34546 L
.65909 .34091 L
Mfstroke
.65909 .47273 m
.67727 .52727 L
.64091 .52727 L
F
gsave
.61613 .5 -70.8125 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
68.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -73.4062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N9) show
83.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.8 0.6 1 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.66472 .34233 L
.67005 .34398 L
.67481 .34606 L
.67881 .34872 L
.68191 .35207 L
.68408 .35614 L
.68538 .36087 L
.68595 .36615 L
.68604 .37181 L
.6859 .37763 L
.68585 .38339 L
.68617 .38887 L
.68711 .39387 L
.68887 .39825 L
.69155 .40192 L
.69515 .40489 L
.69959 .40722 L
.70469 .40904 L
.71022 .41054 L
.71588 .41193 L
.72138 .41345 L
.72644 .41531 L
.7308 .41769 L
.73432 .42072 L
.73691 .42446 L
.73859 .4289 L
.73947 .43395 L
.73975 .43946 L
.73968 .44524 L
.73955 .45105 L
.73967 .45669 L
.7403 .46192 L
.74167 .4666 L
.74392 .4706 L
.74711 .47388 L
.75119 .47649 L
.75601 .47852 L
.76138 .48014 L
.76702 .48155 L
.77263 .48298 L
.77792 .48466 L
.78263 .48678 L
.78655 .48951 L
.78956 .49292 L
.79165 .49705 L
.79287 .50184 L
.7934 .50716 L
.79345 .51284 L
.79331 .51867 L
Mistroke
.79328 .52442 L
.79365 .52986 L
.79466 .5348 L
.7965 .53912 L
.79926 .54273 L
.80295 .54564 L
.80745 .54791 L
.81261 .54969 L
.81816 .55117 L
.82382 .55256 L
.82929 .5541 L
.83429 .556 L
.83859 .55843 L
.84203 .56153 L
.84453 .56533 L
.84613 .56983 L
.84695 .57493 L
.84719 .58047 L
.8471 .58626 L
.84698 .59208 L
.84714 .59768 L
.84783 .60287 L
.84928 .60749 L
.85162 .61142 L
.85489 .61464 L
.85904 .61719 L
.86392 .61918 L
.86933 .62077 L
.87498 .62217 L
.88057 .62361 L
.88582 .62532 L
.89046 .62749 L
.8943 .63028 L
.89724 .63376 L
.89924 .63795 L
.90039 .64279 L
.90086 .64815 L
.90089 .65386 L
.90075 .65969 L
.90074 .66541 L
.90116 .67082 L
.90225 .67571 L
.90417 .67996 L
.90701 .68351 L
.91078 .68635 L
.91535 .68858 L
.92056 .69032 L
.92613 .69178 L
.93179 .69317 L
.93723 .69474 L
Mistroke
.94217 .69668 L
.9464 .69917 L
.94975 .70232 L
.95217 .70619 L
.9537 .71075 L
.95445 .7159 L
.95465 .72147 L
.95455 .72727 L
Mfstroke
gsave
.86846 .66805 -68.25 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.82339 .44424 m
.80469 .49862 L
.77581 .47653 L
F
gsave
.86165 .34332 -68.4375 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -65.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
.47273 .34091 m
.52727 .32273 L
.52727 .35909 L
F
gsave
.5 .29795 -65.9062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
68.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.65909 .34091 m
.65909 .65909 L
s
.65909 .47273 m
.67727 .52727 L
.64091 .52727 L
F
gsave
.61613 .5 -69.8125 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N10) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
2.42861e-17 0.4 0.2 0.6 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.66472 .34233 L
.67005 .34398 L
.67481 .34606 L
.67881 .34872 L
.68191 .35207 L
.68408 .35614 L
.68538 .36087 L
.68595 .36615 L
.68604 .37181 L
.6859 .37763 L
.68585 .38339 L
.68617 .38887 L
.68711 .39387 L
.68887 .39825 L
.69155 .40192 L
.69515 .40489 L
.69959 .40722 L
.70469 .40904 L
.71022 .41054 L
.71588 .41193 L
.72138 .41345 L
.72644 .41531 L
.7308 .41769 L
.73432 .42072 L
.73691 .42446 L
.73859 .4289 L
.73947 .43395 L
.73975 .43946 L
.73968 .44524 L
.73955 .45105 L
.73967 .45669 L
.7403 .46192 L
.74167 .4666 L
.74392 .4706 L
.74711 .47388 L
.75119 .47649 L
.75601 .47852 L
.76138 .48014 L
.76702 .48155 L
.77263 .48298 L
.77792 .48466 L
.78263 .48678 L
.78655 .48951 L
.78956 .49292 L
.79165 .49705 L
.79287 .50184 L
.7934 .50716 L
.79345 .51284 L
.79331 .51867 L
Mistroke
.79328 .52442 L
.79365 .52986 L
.79466 .5348 L
.7965 .53912 L
.79926 .54273 L
.80295 .54564 L
.80745 .54791 L
.81261 .54969 L
.81816 .55117 L
.82382 .55256 L
.82929 .5541 L
.83429 .556 L
.83859 .55843 L
.84203 .56153 L
.84453 .56533 L
.84613 .56983 L
.84695 .57493 L
.84719 .58047 L
.8471 .58626 L
.84698 .59208 L
.84714 .59768 L
.84783 .60287 L
.84928 .60749 L
.85162 .61142 L
.85489 .61464 L
.85904 .61719 L
.86392 .61918 L
.86933 .62077 L
.87498 .62217 L
.88057 .62361 L
.88582 .62532 L
.89046 .62749 L
.8943 .63028 L
.89724 .63376 L
.89924 .63795 L
.90039 .64279 L
.90086 .64815 L
.90089 .65386 L
.90075 .65969 L
.90074 .66541 L
.90116 .67082 L
.90225 .67571 L
.90417 .67996 L
.90701 .68351 L
.91078 .68635 L
.91535 .68858 L
.92056 .69032 L
.92613 .69178 L
.93179 .69317 L
.93723 .69474 L
Mistroke
.94217 .69668 L
.9464 .69917 L
.94975 .70232 L
.95217 .70619 L
.9537 .71075 L
.95445 .7159 L
.95465 .72147 L
.95455 .72727 L
Mfstroke
gsave
.86846 .66805 -68.25 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.82339 .44424 m
.80469 .49862 L
.77581 .47653 L
F
gsave
.86165 .34332 -68.4375 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .52727 m
.32273 .47273 L
.35909 .47273 L
F
gsave
.29795 .5 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .65909 m
.65909 .65909 L
s
.52727 .65909 m
.47273 .64091 L
.47273 .67727 L
F
gsave
.5 .70205 -65.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
.47273 .34091 m
.52727 .32273 L
.52727 .35909 L
F
gsave
.5 .29795 -65.9062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
68.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65463 .65454 L
.65088 .65 L
.64845 .64545 L
.64774 .64091 L
.64886 .63636 L
.65162 .63182 L
.65558 .62727 L
.66012 .62273 L
.66448 .61818 L
.66798 .61364 L
.67005 .60909 L
.67036 .60455 L
.66885 .6 L
.66578 .59546 L
.66163 .59091 L
.65707 .58636 L
.65284 .58182 L
.64962 .57727 L
.64792 .57273 L
.64802 .56818 L
.64991 .56364 L
.65327 .55909 L
.65758 .55455 L
.66213 .55 L
.66619 .54545 L
.66911 .54091 L
.67042 .53636 L
.66991 .53182 L
.66766 .52727 L
.66404 .52273 L
.65961 .51818 L
.65511 .51364 L
.65125 .50909 L
.64866 .50455 L
.64774 .5 L
.64866 .49545 L
.65125 .49091 L
.65511 .48636 L
.65961 .48182 L
.66404 .47727 L
.66766 .47273 L
.66991 .46818 L
.67042 .46364 L
.66911 .45909 L
.66619 .45455 L
.66213 .45 L
.65758 .44545 L
.65327 .44091 L
.64991 .43636 L
Mistroke
.64802 .43182 L
.64792 .42727 L
.64962 .42273 L
.65284 .41818 L
.65707 .41364 L
.66163 .40909 L
.66578 .40454 L
.66885 .4 L
.67036 .39545 L
.67005 .39091 L
.66798 .38636 L
.66448 .38182 L
.66012 .37727 L
.65558 .37273 L
.65162 .36818 L
.64886 .36364 L
.64774 .35909 L
.64845 .35455 L
.65088 .35 L
.65463 .34546 L
.65909 .34091 L
Mfstroke
.65909 .47273 m
.67727 .52727 L
.64091 .52727 L
F
gsave
.61613 .5 -70.8125 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
68.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N11) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.2 0.4 0.4 0.6 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.34091 .65909 m
.33504 .65619 L
.32873 .65424 L
.32216 .65334 L
.31553 .65354 L
.30902 .65485 L
.30283 .65723 L
.29713 .66062 L
.29207 .66488 L
.28778 .66986 L
.28436 .67537 L
.28187 .68121 L
.28032 .68715 L
.27971 .69297 L
.27998 .69844 L
.28104 .70336 L
.28276 .70755 L
.28499 .71085 L
.28756 .71314 L
.29029 .71435 L
.29298 .71445 L
.29544 .71345 L
.29749 .71141 L
.29896 .70843 L
.29972 .70466 L
.29964 .70027 L
.29867 .69545 L
.29675 .69043 L
.29388 .68543 L
.29011 .68067 L
.2855 .67637 L
.28017 .67272 L
.27425 .6699 L
.26791 .66803 L
.26134 .66722 L
.25471 .66751 L
.24822 .66891 L
.24206 .67138 L
.23641 .67484 L
.23141 .67917 L
.22719 .6842 L
.22384 .68975 L
.22143 .6956 L
.21996 .70154 L
.21943 .70734 L
.21977 .71278 L
.22089 .71764 L
.22265 .72176 L
.22492 .72498 L
.22751 .72719 L
Mistroke
.23024 .72831 L
.23292 .72832 L
.23535 .72723 L
.23736 .7251 L
.23878 .72206 L
.23947 .71822 L
.23932 .71379 L
.23827 .70895 L
.23627 .70392 L
.23333 .69893 L
.22948 .6942 L
.22481 .68995 L
.21943 .68636 L
.21347 .68361 L
.2071 .68183 L
.20051 .68111 L
.19389 .68149 L
.18742 .68298 L
.1813 .68554 L
.17569 .68908 L
.17075 .69347 L
.1666 .69855 L
.16333 .70413 L
.161 .71 L
.15961 .71594 L
.15915 .72172 L
.15956 .72711 L
.16073 .73192 L
.16255 .73598 L
.16485 .73911 L
.16746 .74123 L
.1702 .74226 L
.17286 .74218 L
.17526 .741 L
.17723 .73879 L
.17859 .73568 L
.17922 .73179 L
.179 .72731 L
.17787 .72245 L
.17579 .71741 L
.17277 .71243 L
.16885 .70774 L
.16412 .70353 L
.15868 .70001 L
.15268 .69734 L
.14629 .69564 L
.13969 .69501 L
.13307 .69548 L
.12663 .69706 L
.12054 .69971 L
Mistroke
.11499 .70332 L
.11011 .70778 L
.10603 .71291 L
.10283 .71852 L
.10057 .72441 L
.09927 .73034 L
.09888 .73609 L
.09936 .74145 L
.10059 .7462 L
.10245 .75018 L
.10479 .75324 L
.10741 .75527 L
.11015 .75621 L
.1128 .75603 L
.11517 .75477 L
.11709 .75248 L
.1184 .7493 L
.11896 .74535 L
.11867 .74083 L
.11746 .73595 L
.11531 .73091 L
.11221 .72595 L
.10822 .72128 L
.10342 .71713 L
.09793 .71367 L
.09189 .71107 L
.08548 .70946 L
.07887 .70892 L
.07226 .70949 L
.06584 .71116 L
.05979 .71389 L
.05428 .71758 L
.04946 .72209 L
.04545 .72727 L
Mfstroke
gsave
.21618 .76534 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.21976 .31295 m
.1707 .28297 L
.16252 .3184 L
F
gsave
.20902 .26566 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.66472 .34233 L
.67005 .34398 L
.67481 .34606 L
.67881 .34872 L
.68191 .35207 L
.68408 .35614 L
.68538 .36087 L
.68595 .36615 L
.68604 .37181 L
.6859 .37763 L
.68585 .38339 L
.68617 .38887 L
.68711 .39387 L
.68887 .39825 L
.69155 .40192 L
.69515 .40489 L
.69959 .40722 L
.70469 .40904 L
.71022 .41054 L
.71588 .41193 L
.72138 .41345 L
.72644 .41531 L
.7308 .41769 L
.73432 .42072 L
.73691 .42446 L
.73859 .4289 L
.73947 .43395 L
.73975 .43946 L
.73968 .44524 L
.73955 .45105 L
.73967 .45669 L
.7403 .46192 L
.74167 .4666 L
.74392 .4706 L
.74711 .47388 L
.75119 .47649 L
.75601 .47852 L
.76138 .48014 L
.76702 .48155 L
.77263 .48298 L
.77792 .48466 L
.78263 .48678 L
.78655 .48951 L
.78956 .49292 L
.79165 .49705 L
.79287 .50184 L
.7934 .50716 L
.79345 .51284 L
.79331 .51867 L
Mistroke
.79328 .52442 L
.79365 .52986 L
.79466 .5348 L
.7965 .53912 L
.79926 .54273 L
.80295 .54564 L
.80745 .54791 L
.81261 .54969 L
.81816 .55117 L
.82382 .55256 L
.82929 .5541 L
.83429 .556 L
.83859 .55843 L
.84203 .56153 L
.84453 .56533 L
.84613 .56983 L
.84695 .57493 L
.84719 .58047 L
.8471 .58626 L
.84698 .59208 L
.84714 .59768 L
.84783 .60287 L
.84928 .60749 L
.85162 .61142 L
.85489 .61464 L
.85904 .61719 L
.86392 .61918 L
.86933 .62077 L
.87498 .62217 L
.88057 .62361 L
.88582 .62532 L
.89046 .62749 L
.8943 .63028 L
.89724 .63376 L
.89924 .63795 L
.90039 .64279 L
.90086 .64815 L
.90089 .65386 L
.90075 .65969 L
.90074 .66541 L
.90116 .67082 L
.90225 .67571 L
.90417 .67996 L
.90701 .68351 L
.91078 .68635 L
.91535 .68858 L
.92056 .69032 L
.92613 .69178 L
.93179 .69317 L
.93723 .69474 L
Mistroke
.94217 .69668 L
.9464 .69917 L
.94975 .70232 L
.95217 .70619 L
.9537 .71075 L
.95445 .7159 L
.95465 .72147 L
.95455 .72727 L
Mfstroke
gsave
.86846 .66805 -68.25 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.82339 .44424 m
.80469 .49862 L
.77581 .47653 L
F
gsave
.86165 .34332 -68.4375 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .34091 m
.33614 .34658 L
.33253 .35309 L
.33029 .36019 L
.32954 .36758 L
.33033 .37497 L
.33262 .38206 L
.33626 .38854 L
.34107 .39419 L
.34676 .39878 L
.35302 .40217 L
.35949 .40429 L
.36582 .40513 L
.37163 .40475 L
.37661 .40329 L
.38047 .40095 L
.383 .39796 L
.38406 .39462 L
.38358 .39122 L
.38159 .38806 L
.3782 .38545 L
.37361 .38363 L
.36807 .38283 L
.3619 .3832 L
.35544 .38483 L
.34906 .38775 L
.34311 .39191 L
.33794 .39718 L
.33383 .40337 L
.33101 .41026 L
.32965 .41757 L
.32982 .425 L
.33151 .43225 L
.33462 .43901 L
.33899 .44502 L
.34436 .45006 L
.35043 .45396 L
.35686 .4566 L
.36328 .45795 L
.36935 .45805 L
.3747 .45701 L
.37905 .455 L
.38214 .45225 L
.38381 .44901 L
.38395 .4456 L
.38257 .44231 L
.37973 .43944 L
.3756 .43727 L
.37041 .43603 L
.36446 .43591 L
Mistroke
.35807 .43703 L
.35162 .43943 L
.34545 .44309 L
.33993 .44792 L
.33535 .45377 L
.33199 .46041 L
.33002 .46759 L
.32956 .475 L
.33064 .48236 L
.33319 .48935 L
.33708 .4957 L
.34207 .50116 L
.3479 .50553 L
.35422 .50869 L
.36069 .51057 L
.36695 .51117 L
.37263 .51058 L
.37742 .50894 L
.38105 .50645 L
.38331 .50338 L
.38408 .5 L
.38331 .49662 L
.38105 .49355 L
.37742 .49106 L
.37263 .48942 L
.36695 .48883 L
.36069 .48943 L
.35422 .49131 L
.3479 .49447 L
.34207 .49884 L
.33708 .5043 L
.33319 .51065 L
.33064 .51764 L
.32956 .525 L
.33002 .53241 L
.33199 .53959 L
.33535 .54623 L
.33993 .55208 L
.34545 .55691 L
.35162 .56057 L
.35807 .56297 L
.36446 .56409 L
.37041 .56397 L
.3756 .56273 L
.37973 .56056 L
.38257 .55769 L
.38395 .5544 L
.38381 .55099 L
.38214 .54775 L
.37905 .545 L
Mistroke
.3747 .54299 L
.36935 .54195 L
.36328 .54205 L
.35686 .5434 L
.35043 .54604 L
.34436 .54994 L
.33899 .55498 L
.33462 .56099 L
.33151 .56775 L
.32982 .575 L
.32965 .58243 L
.33101 .58974 L
.33383 .59663 L
.33794 .60282 L
.34311 .60809 L
.34906 .61225 L
.35544 .61517 L
.3619 .6168 L
.36807 .61717 L
.37361 .61637 L
.3782 .61455 L
.38159 .61194 L
.38358 .60878 L
.38406 .60538 L
.383 .60204 L
.38047 .59905 L
.37661 .59671 L
.37163 .59525 L
.36582 .59487 L
.35949 .59571 L
.35302 .59783 L
.34676 .60122 L
.34107 .60581 L
.33626 .61146 L
.33262 .61794 L
.33033 .62503 L
.32954 .63242 L
.33029 .63981 L
.33253 .64691 L
.33614 .65342 L
.34091 .65909 L
Mfstroke
gsave
.29795 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65342 .65432 L
.64691 .65071 L
.63981 .64847 L
.63242 .64772 L
.62503 .64851 L
.61794 .6508 L
.61146 .65445 L
.60581 .65925 L
.60122 .66494 L
.59783 .6712 L
.59571 .67768 L
.59487 .684 L
.59525 .68981 L
.59671 .69479 L
.59905 .69865 L
.60204 .70118 L
.60538 .70224 L
.60878 .70176 L
.61194 .69977 L
.61455 .69638 L
.61637 .69179 L
.61717 .68625 L
.6168 .68008 L
.61517 .67362 L
.61225 .66724 L
.60809 .6613 L
.60282 .65612 L
.59663 .65201 L
.58974 .6492 L
.58243 .64783 L
.575 .648 L
.56775 .64969 L
.56099 .65281 L
.55498 .65717 L
.54994 .66254 L
.54604 .66861 L
.5434 .67504 L
.54205 .68147 L
.54195 .68753 L
.54299 .69288 L
.545 .69723 L
.54775 .70032 L
.55099 .70199 L
.5544 .70213 L
.55769 .70075 L
.56056 .69791 L
.56273 .69378 L
.56397 .68859 L
.56409 .68264 L
Mistroke
.56297 .67625 L
.56057 .6698 L
.55691 .66363 L
.55208 .65811 L
.54623 .65353 L
.53959 .65017 L
.53241 .6482 L
.525 .64775 L
.51764 .64882 L
.51065 .65138 L
.5043 .65526 L
.49884 .66025 L
.49447 .66608 L
.49131 .6724 L
.48943 .67888 L
.48883 .68513 L
.48942 .69081 L
.49106 .6956 L
.49355 .69923 L
.49662 .70149 L
.5 .70226 L
.50338 .70149 L
.50645 .69923 L
.50894 .6956 L
.51058 .69081 L
.51117 .68513 L
.51057 .67888 L
.50869 .6724 L
.50553 .66608 L
.50116 .66025 L
.4957 .65526 L
.48935 .65138 L
.48236 .64882 L
.475 .64775 L
.46759 .6482 L
.46041 .65017 L
.45377 .65353 L
.44792 .65811 L
.44309 .66363 L
.43943 .6698 L
.43703 .67625 L
.43591 .68264 L
.43603 .68859 L
.43727 .69378 L
.43944 .69791 L
.44231 .70075 L
.4456 .70213 L
.44901 .70199 L
.45225 .70032 L
.455 .69723 L
Mistroke
.45701 .69288 L
.45805 .68753 L
.45795 .68147 L
.4566 .67504 L
.45396 .66861 L
.45006 .66254 L
.44502 .65717 L
.43901 .65281 L
.43225 .64969 L
.425 .648 L
.41757 .64783 L
.41026 .6492 L
.40337 .65201 L
.39718 .65612 L
.39191 .6613 L
.38775 .66724 L
.38483 .67362 L
.3832 .68008 L
.38283 .68625 L
.38363 .69179 L
.38545 .69638 L
.38806 .69977 L
.39122 .70176 L
.39462 .70224 L
.39796 .70118 L
.40095 .69865 L
.40329 .69479 L
.40475 .68981 L
.40513 .684 L
.40429 .67768 L
.40217 .6712 L
.39878 .66494 L
.39419 .65925 L
.38854 .65445 L
.38206 .6508 L
.37497 .64851 L
.36758 .64772 L
.36019 .64847 L
.35309 .65071 L
.34658 .65432 L
.34091 .65909 L
Mfstroke
gsave
.5 .73387 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .34091 m
.65909 .34091 L
s
.52727 .34091 m
.47273 .32273 L
.47273 .35909 L
F
gsave
.5 .29795 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65909 .65909 L
s
.65909 .52727 m
.67727 .47273 L
.64091 .47273 L
F
gsave
.61613 .5 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N12) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.4 0.4 0.6 0.6 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .31818 m
.65909 .31818 L
s
gsave
.5 .28658 -65.2188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
67.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N13) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.6 0.4 0.8 0.6 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .31818 m
.65909 .31818 L
s
gsave
.5 .28658 -67.3125 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 8.813 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C2) show
77.562 11.250 moveto
(N14) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.8 0.4 1 0.6 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -65.7812 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
[ .03 .03 ] 0 setdash
.34091 .31818 m
.65909 .31818 L
s
.47273 .31818 m
.52727 .3 L
.52727 .33636 L
F
gsave
.5 .27522 -65.4062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(G) show
67.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C3) show
77.562 11.250 moveto
(N15) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
2.42861e-17 0.2 0.2 0.4 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .31818 m
.65454 .32265 L
.65 .32639 L
.64545 .32882 L
.64091 .32953 L
.63636 .32842 L
.63182 .32565 L
.62727 .32169 L
.62273 .31716 L
.61818 .31279 L
.61364 .30929 L
.60909 .30722 L
.60455 .30691 L
.6 .30842 L
.59546 .31149 L
.59091 .31564 L
.58636 .3202 L
.58182 .32443 L
.57727 .32765 L
.57273 .32935 L
.56818 .32925 L
.56364 .32736 L
.55909 .324 L
.55455 .31969 L
.55 .31515 L
.54545 .31108 L
.54091 .30816 L
.53636 .30685 L
.53182 .30736 L
.52727 .30961 L
.52273 .31324 L
.51818 .31766 L
.51364 .32216 L
.50909 .32602 L
.50455 .32862 L
.5 .32953 L
.49545 .32862 L
.49091 .32602 L
.48636 .32216 L
.48182 .31766 L
.47727 .31324 L
.47273 .30961 L
.46818 .30736 L
.46364 .30685 L
.45909 .30816 L
.45455 .31108 L
.45 .31515 L
.44545 .31969 L
.44091 .324 L
.43636 .32736 L
Mistroke
.43182 .32925 L
.42727 .32935 L
.42273 .32765 L
.41818 .32443 L
.41364 .3202 L
.40909 .31564 L
.40454 .31149 L
.4 .30842 L
.39545 .30691 L
.39091 .30722 L
.38636 .30929 L
.38182 .31279 L
.37727 .31716 L
.37273 .32169 L
.36818 .32565 L
.36364 .32842 L
.35909 .32953 L
.35455 .32882 L
.35 .32639 L
.34546 .32265 L
.34091 .31818 L
Mfstroke
gsave
.5 .27522 -64.625 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C1) show
77.562 11.250 moveto
(N16) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.2 0.2 0.4 0.4 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .31818 m
.65454 .32265 L
.65 .32639 L
.64545 .32882 L
.64091 .32953 L
.63636 .32842 L
.63182 .32565 L
.62727 .32169 L
.62273 .31716 L
.61818 .31279 L
.61364 .30929 L
.60909 .30722 L
.60455 .30691 L
.6 .30842 L
.59546 .31149 L
.59091 .31564 L
.58636 .3202 L
.58182 .32443 L
.57727 .32765 L
.57273 .32935 L
.56818 .32925 L
.56364 .32736 L
.55909 .324 L
.55455 .31969 L
.55 .31515 L
.54545 .31108 L
.54091 .30816 L
.53636 .30685 L
.53182 .30736 L
.52727 .30961 L
.52273 .31324 L
.51818 .31766 L
.51364 .32216 L
.50909 .32602 L
.50455 .32862 L
.5 .32953 L
.49545 .32862 L
.49091 .32602 L
.48636 .32216 L
.48182 .31766 L
.47727 .31324 L
.47273 .30961 L
.46818 .30736 L
.46364 .30685 L
.45909 .30816 L
.45455 .31108 L
.45 .31515 L
.44545 .31969 L
.44091 .324 L
.43636 .32736 L
Mistroke
.43182 .32925 L
.42727 .32935 L
.42273 .32765 L
.41818 .32443 L
.41364 .3202 L
.40909 .31564 L
.40454 .31149 L
.4 .30842 L
.39545 .30691 L
.39091 .30722 L
.38636 .30929 L
.38182 .31279 L
.37727 .31716 L
.37273 .32169 L
.36818 .32565 L
.36364 .32842 L
.35909 .32953 L
.35455 .32882 L
.35 .32639 L
.34546 .32265 L
.34091 .31818 L
Mfstroke
gsave
.5 .27522 -64.875 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Z) show
66.750 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C2) show
77.562 11.250 moveto
(N17) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.4 0.2 0.6 0.4 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -65.7812 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -70.5625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
66.438 12.625 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 5.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .31818 m
.65454 .32265 L
.65 .32639 L
.64545 .32882 L
.64091 .32953 L
.63636 .32842 L
.63182 .32565 L
.62727 .32169 L
.62273 .31716 L
.61818 .31279 L
.61364 .30929 L
.60909 .30722 L
.60455 .30691 L
.6 .30842 L
.59546 .31149 L
.59091 .31564 L
.58636 .3202 L
.58182 .32443 L
.57727 .32765 L
.57273 .32935 L
.56818 .32925 L
.56364 .32736 L
.55909 .324 L
.55455 .31969 L
.55 .31515 L
.54545 .31108 L
.54091 .30816 L
.53636 .30685 L
.53182 .30736 L
.52727 .30961 L
.52273 .31324 L
.51818 .31766 L
.51364 .32216 L
.50909 .32602 L
.50455 .32862 L
.5 .32953 L
.49545 .32862 L
.49091 .32602 L
.48636 .32216 L
.48182 .31766 L
.47727 .31324 L
.47273 .30961 L
.46818 .30736 L
.46364 .30685 L
.45909 .30816 L
.45455 .31108 L
.45 .31515 L
.44545 .31969 L
.44091 .324 L
.43636 .32736 L
Mistroke
.43182 .32925 L
.42727 .32935 L
.42273 .32765 L
.41818 .32443 L
.41364 .3202 L
.40909 .31564 L
.40454 .31149 L
.4 .30842 L
.39545 .30691 L
.39091 .30722 L
.38636 .30929 L
.38182 .31279 L
.37727 .31716 L
.37273 .32169 L
.36818 .32565 L
.36364 .32842 L
.35909 .32953 L
.35455 .32882 L
.35 .32639 L
.34546 .32265 L
.34091 .31818 L
Mfstroke
.47273 .31818 m
.52727 .3 L
.52727 .33636 L
F
gsave
.5 .27522 -65.9062 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
68.812 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C3) show
77.562 11.250 moveto
(N18) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.6 0.2 0.8 0.4 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.65909 .63636 m
.6531 .63284 L
.64655 .63035 L
.63964 .62901 L
.6326 .6289 L
.62565 .63004 L
.61901 .63239 L
.61289 .63586 L
.60748 .6403 L
.60292 .64553 L
.59933 .65131 L
.59678 .6574 L
.59528 .66352 L
.59481 .66942 L
.59529 .67484 L
.5966 .67953 L
.59859 .68331 L
.60105 .68601 L
.6038 .68751 L
.60659 .68778 L
.6092 .6868 L
.61143 .68463 L
.61305 .6814 L
.61392 .67727 L
.61387 .67243 L
.61283 .66713 L
.61074 .66162 L
.60761 .65618 L
.60346 .65106 L
.59841 .64652 L
.59258 .64278 L
.58615 .64002 L
.57931 .63839 L
.57228 .63798 L
.56528 .63882 L
.55855 .64089 L
.55229 .6441 L
.54669 .64832 L
.54191 .65338 L
.53808 .65905 L
.53528 .66508 L
.53352 .67123 L
.53281 .67721 L
.53307 .68276 L
.53419 .68765 L
.53603 .69166 L
.5384 .69463 L
.5411 .69644 L
.5439 .697 L
.54658 .69632 L
Mistroke
.54891 .69443 L
.5507 .69145 L
.55176 .68751 L
.55195 .68283 L
.55116 .67761 L
.54932 .67213 L
.54643 .66665 L
.54253 .66143 L
.53768 .65673 L
.53203 .65277 L
.52572 .64976 L
.51896 .64785 L
.51196 .64714 L
.50493 .64768 L
.49812 .64946 L
.49172 .6524 L
.48595 .65639 L
.48096 .66127 L
.47689 .66681 L
.47383 .67278 L
.47183 .67892 L
.47087 .68497 L
.4709 .69065 L
.47183 .69572 L
.47351 .69996 L
.47577 .7032 L
.47841 .70529 L
.4812 .70616 L
.48393 .70577 L
.48637 .70417 L
.48831 .70144 L
.48956 .69772 L
.48997 .69319 L
.48942 .68809 L
.48784 .68265 L
.48521 .67714 L
.48154 .67183 L
.47691 .66698 L
.47144 .66283 L
.46527 .65957 L
.4586 .65739 L
.45164 .65638 L
.4446 .65662 L
.43771 .6581 L
.43119 .66077 L
.42525 .66452 L
.42006 .6692 L
.41576 .6746 L
.41246 .68049 L
.41019 .68662 L
Mistroke
.40898 .69271 L
.40878 .6985 L
.40951 .70374 L
.41102 .7082 L
.41316 .7117 L
.41572 .71408 L
.4185 .71524 L
.42127 .71516 L
.4238 .71385 L
.42587 .71138 L
.42731 .70788 L
.42793 .70353 L
.42762 .69854 L
.4263 .69316 L
.42392 .68764 L
.42049 .68226 L
.41609 .67728 L
.41081 .67294 L
.40479 .66945 L
.39823 .667 L
.39131 .6657 L
.38427 .66563 L
.37732 .66681 L
.3707 .6692 L
.3646 .67271 L
.35922 .67718 L
.35469 .68243 L
.35114 .68822 L
.34862 .69432 L
.34716 .70044 L
.34672 .70633 L
.34723 .71173 L
.34857 .71639 L
.35057 .72014 L
.35306 .72279 L
.3558 .72426 L
.35859 .72448 L
.3612 .72346 L
.3634 .72126 L
.36501 .718 L
.36584 .71384 L
.36577 .70898 L
.36469 .70367 L
.36257 .69816 L
.35939 .69272 L
.35522 .68762 L
.35013 .6831 L
.34428 .67939 L
.33783 .67667 L
.33098 .67509 L
Mistroke
.32395 .67472 L
.31696 .6756 L
.31024 .67771 L
.304 .68096 L
.29842 .68521 L
.29368 .69029 L
.28988 .69598 L
.28711 .70202 L
.2854 .70816 L
.28472 .71413 L
.28501 .71967 L
.28616 .72453 L
.28802 .72852 L
.2904 .73145 L
.29311 .73321 L
.29591 .73373 L
.29858 .73301 L
.3009 .73109 L
.30267 .72807 L
.3037 .7241 L
.30385 .7194 L
.30303 .71417 L
.30116 .70869 L
.29823 .70321 L
.29429 .698 L
.28942 .69332 L
.28374 .6894 L
.27741 .68642 L
.27064 .68455 L
.26363 .68389 L
.25661 .68447 L
.2498 .68628 L
.24343 .68927 L
.23768 .69329 L
.23272 .69819 L
.22869 .70375 L
.22566 .70974 L
.22369 .71588 L
.22277 .72192 L
.22283 .72758 L
.22379 .73263 L
.22549 .73684 L
.22777 .74004 L
.23042 .74209 L
.23321 .74292 L
.23594 .74249 L
.23836 .74085 L
.24028 .73808 L
.2415 .73433 L
.24188 .72978 L
Mistroke
.2413 .72466 L
.23968 .71922 L
.23701 .71371 L
.23331 .70842 L
.22865 .70359 L
.22315 .69946 L
.21697 .69624 L
.21028 .69409 L
.20331 .69313 L
.19627 .69341 L
.1894 .69493 L
.1829 .69764 L
.17698 .70143 L
.17182 .70614 L
.16755 .71156 L
.16428 .71746 L
.16205 .72359 L
.16088 .72968 L
.16071 .73546 L
.16146 .74068 L
.163 .74511 L
.16516 .74857 L
.16774 .7509 L
.17052 .75203 L
.17328 .75191 L
.1758 .75055 L
.17785 .74805 L
.17926 .74452 L
.17986 .74014 L
.17951 .73514 L
.17815 .72975 L
.17574 .72423 L
.17228 .71886 L
.16784 .7139 L
.16253 .70958 L
.1565 .70613 L
.14991 .70371 L
.14299 .70245 L
.13595 .70243 L
.12901 .70365 L
.1224 .70608 L
.11633 .70963 L
.11097 .71413 L
.10647 .7194 L
.10295 .72521 L
.10047 .73131 L
.09905 .73743 L
.09864 .74331 L
.09919 .74868 L
.10055 .75332 L
Mistroke
.10257 .75703 L
.10507 .75965 L
.10782 .76108 L
.11061 .76125 L
.1132 .76019 L
.11539 .75796 L
.11697 .75466 L
.11778 .75047 L
.11767 .7456 L
.11656 .74028 L
.1144 .73477 L
.11119 .72934 L
.10698 .72425 L
.10187 .71976 L
.09599 .71608 L
.08952 .7134 L
.08266 .71185 L
.07563 .71152 L
.06864 .71245 L
.06194 .7146 L
.05572 .71788 L
.05017 .72217 L
.04545 .72727 L
Mfstroke
gsave
.20513 .77707 -64.7188 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .31818 L
s
.22014 .2996 m
.16899 .27334 L
.16346 .30928 L
F
gsave
.20389 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .63636 m
.34599 .63322 L
.351 .63052 L
.35588 .62868 L
.3606 .62799 L
.36512 .62862 L
.36944 .63056 L
.37359 .63367 L
.37761 .63766 L
.38155 .64213 L
.3855 .64663 L
.3895 .65071 L
.39363 .65396 L
.39793 .65607 L
.40242 .65687 L
.40711 .65635 L
.41197 .65465 L
.41697 .65205 L
.42205 .64894 L
.42713 .64576 L
.43215 .64298 L
.43706 .64101 L
.44179 .64016 L
.44634 .6406 L
.45069 .64237 L
.45486 .64534 L
.45889 .64924 L
.46284 .65367 L
.46678 .65819 L
.47078 .66235 L
.47489 .66573 L
.47916 .668 L
.48363 .66898 L
.48829 .66864 L
.49313 .66708 L
.49812 .66458 L
.50318 .66151 L
.50827 .65831 L
.5133 .65545 L
.51823 .65335 L
.52299 .65233 L
.52756 .6526 L
.53193 .6542 L
.53613 .65702 L
.54017 .66081 L
.54414 .66519 L
.54807 .66973 L
.55206 .67396 L
.55615 .67747 L
.5604 .6799 L
Mistroke
.56484 .68106 L
.56948 .68089 L
.5743 .67948 L
.57926 .67708 L
.58432 .67406 L
.58941 .67086 L
.59445 .66793 L
.59939 .6657 L
.60418 .66453 L
.60878 .66462 L
.61318 .66604 L
.61739 .66871 L
.62146 .67239 L
.62543 .67672 L
.62937 .68126 L
.63334 .68556 L
.63741 .68918 L
.64164 .69177 L
.64605 .69311 L
.65067 .69311 L
.65546 .69186 L
.66041 .68957 L
.66546 .68661 L
.67055 .6834 L
.6756 .68041 L
.68056 .67807 L
.68537 .67674 L
.68999 .67665 L
.69442 .6779 L
.69866 .68041 L
.70274 .68397 L
.70672 .68824 L
.71066 .69278 L
.71462 .69714 L
.71868 .70087 L
.72289 .70362 L
.72727 .70513 L
.73186 .70531 L
.73663 .70421 L
.74156 .70204 L
.7466 .69914 L
.75169 .69594 L
.75675 .6929 L
.76172 .69044 L
.76656 .68896 L
.77121 .6887 L
.77566 .68977 L
.77992 .69212 L
.78402 .69556 L
.78801 .69976 L
Mistroke
.79195 .70429 L
.79591 .70869 L
.79995 .71253 L
.80414 .71543 L
.8085 .71711 L
.81306 .71747 L
.81781 .71653 L
.82272 .71449 L
.82775 .71167 L
.83283 .70848 L
.8379 .70538 L
.84289 .70283 L
.84774 .7012 L
.85242 .70076 L
.8569 .70165 L
.86118 .70384 L
.8653 .70716 L
.8693 .71127 L
.87325 .71578 L
.8772 .72023 L
.88123 .72417 L
.88539 .72721 L
.88973 .72907 L
.89426 .7296 L
.89899 .72883 L
.90388 .72692 L
.90889 .72417 L
.91397 .72101 L
.91905 .71788 L
.92405 .71522 L
.92892 .71345 L
.93362 .71284 L
.93813 .71355 L
.94244 .71558 L
.94658 .71876 L
.9506 .72279 L
.95455 .72727 L
Mfstroke
gsave
.79954 .7456 -64.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.250 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .31818 L
s
.83377 .29131 m
.78263 .31757 L
.7771 .28163 L
F
gsave
.79611 .25331 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.34091 .63636 L
s
.52727 .63636 m
.47273 .65455 L
.47273 .61818 L
F
gsave
.5 .5934 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .63636 m
.65909 .31818 L
s
.65909 .45 m
.64091 .50455 L
.67727 .50455 L
F
gsave
.70205 .47727 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .31818 m
.34091 .63636 L
s
.34091 .50455 m
.35909 .45 L
.32273 .45 L
F
gsave
.29795 .47727 -68.4375 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .31818 m
.65342 .31341 L
.64691 .3098 L
.63981 .30756 L
.63242 .30681 L
.62503 .30761 L
.61794 .30989 L
.61146 .31354 L
.60581 .31834 L
.60122 .32404 L
.59783 .33029 L
.59571 .33677 L
.59487 .34309 L
.59525 .3489 L
.59671 .35388 L
.59905 .35774 L
.60204 .36027 L
.60538 .36133 L
.60878 .36085 L
.61194 .35886 L
.61455 .35547 L
.61637 .35088 L
.61717 .34535 L
.6168 .33917 L
.61517 .33271 L
.61225 .32633 L
.60809 .32039 L
.60282 .31521 L
.59663 .3111 L
.58974 .30829 L
.58243 .30693 L
.575 .30709 L
.56775 .30878 L
.56099 .3119 L
.55498 .31626 L
.54994 .32163 L
.54604 .3277 L
.5434 .33413 L
.54205 .34056 L
.54195 .34662 L
.54299 .35197 L
.545 .35632 L
.54775 .35941 L
.55099 .36108 L
.5544 .36122 L
.55769 .35984 L
.56056 .357 L
.56273 .35287 L
.56397 .34769 L
.56409 .34173 L
Mistroke
.56297 .33535 L
.56057 .32889 L
.55691 .32272 L
.55208 .3172 L
.54623 .31262 L
.53959 .30926 L
.53241 .30729 L
.525 .30684 L
.51764 .30791 L
.51065 .31047 L
.5043 .31435 L
.49884 .31934 L
.49447 .32517 L
.49131 .3315 L
.48943 .33797 L
.48883 .34422 L
.48942 .3499 L
.49106 .35469 L
.49355 .35832 L
.49662 .36058 L
.5 .36135 L
.50338 .36058 L
.50645 .35832 L
.50894 .35469 L
.51058 .3499 L
.51117 .34422 L
.51057 .33797 L
.50869 .3315 L
.50553 .32517 L
.50116 .31934 L
.4957 .31435 L
.48935 .31047 L
.48236 .30791 L
.475 .30684 L
.46759 .30729 L
.46041 .30926 L
.45377 .31262 L
.44792 .3172 L
.44309 .32272 L
.43943 .32889 L
.43703 .33535 L
.43591 .34173 L
.43603 .34769 L
.43727 .35287 L
.43944 .357 L
.44231 .35984 L
.4456 .36122 L
.44901 .36108 L
.45225 .35941 L
.455 .35632 L
Mistroke
.45701 .35197 L
.45805 .34662 L
.45795 .34056 L
.4566 .33413 L
.45396 .3277 L
.45006 .32163 L
.44502 .31626 L
.43901 .3119 L
.43225 .30878 L
.425 .30709 L
.41757 .30693 L
.41026 .30829 L
.40337 .3111 L
.39718 .31521 L
.39191 .32039 L
.38775 .32633 L
.38483 .33271 L
.3832 .33917 L
.38283 .34535 L
.38363 .35088 L
.38545 .35547 L
.38806 .35886 L
.39122 .36085 L
.39462 .36133 L
.39796 .36027 L
.40095 .35774 L
.40329 .35388 L
.40475 .3489 L
.40513 .34309 L
.40429 .33677 L
.40217 .33029 L
.39878 .32404 L
.39419 .31834 L
.38854 .31354 L
.38206 .30989 L
.37497 .30761 L
.36758 .30681 L
.36019 .30756 L
.35309 .3098 L
.34658 .31341 L
.34091 .31818 L
Mfstroke
gsave
.5 .27522 -64.7188 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.438 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.65909 .63636 Mdot
.34091 .31818 Mdot
.34091 .63636 Mdot
.65909 .31818 Mdot
gsave
.5 .02273 -74.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T3) show
70.000 11.250 moveto
(C4) show
77.562 11.250 moveto
(N19) show
86.500 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.41818 1.036 -65.0625 -8.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.875 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
67.125 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45909 1.036 -65.0625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
67.125 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 1.036 -66.0312 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 11.250 moveto
(\\256) show
69.062 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.54091 1.036 -64.9688 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
66.938 11.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.58182 1.036 -65.0625 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
67.125 11.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{279.562, 296.312},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006S0001_2000`400?l00000o`00003oo`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`003`3oool0
0`000000oooo0000000F0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`0000007`3oool0
0`000000oooo0000000^0?ooo`030000003oool0000001l0oooo00<000000?ooo`000000;`3oool0
0`000000oooo0000000O0?ooo`030000003oool0000001H0oooo0P00000F0?ooo`030000003oool0
000006D0oooo000>0?ooo`040000003oool00000000001H0oooo00<000000?ooo`3oool05@3oool0
10000000oooo00000000000N0?ooo`040000003oool00000000002d0oooo00@000000?ooo`000000
00007P3oool010000000oooo00000000000^0?ooo`040000003oool00000000001h0oooo00@00000
0?ooo`00000000005@3oool010000000oooo0?ooo`00000D0?ooo`040000003oool00000000006D0
oooo000>0?ooo`040000003oool0oooo000001L0oooo00<000000?ooo`3oool0503oool010000000
oooo0?ooo`00000N0?ooo`040000003oool0oooo000001@0oooo1000000E0?ooo`040000003oool0
oooo000001h0oooo00@000000?ooo`3oool00000503oool01@000000oooo0?ooo`3oool0000001D0
oooo00@000000?ooo`3oool000007P3oool010000000oooo0?ooo`00000F0?ooo`<00000503oool0
10000000oooo0?ooo`00001U0?ooo`003P3oool010000000oooo0?ooo`00000G0?ooo`030000003o
ool0oooo01@0oooo00@000000?ooo`3oool000007P3oool010000000oooo0?ooo`00000D0?ooo`03
0000003oool0oooo01H0oooo00@000000?ooo`3oool000007P3oool010000000oooo0?ooo`00000D
0?ooo`050000003oool0oooo0?ooo`0000005@3oool010000000oooo0?ooo`00000N0?ooo`040000
003oool0oooo000001D0oooo00@000000?ooo`3oool00000503oool010000000oooo0?ooo`00001U
0?ooo`003P3oool010000000oooo0?ooo`00000G0?ooo`8000005@3oool010000000oooo0?ooo`00
000N0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3oool05@3oool010000000oooo
0?ooo`00000N0?ooo`040000003oool0oooo000001@0oooo00D000000?ooo`3oool0oooo0000000E
0?ooo`040000003oool0oooo000001h0oooo00@000000?ooo`3oool000005@3oool010000000oooo
0?ooo`00000D0?ooo`040000003oool0oooo000006D0oooo000W0?ooo`050000003oool000000?oo
o`000000C`3oool2000004l0oooo00L000000?ooo`000000oooo0000003oool0000004l0oooo00@0
00000?ooo`3oool00000O@3oool002P0oooo00@000000?ooo`3oool00000D03oool00`000000oooo
0?ooo`1=0?ooo`070000003oool000000?ooo`000000oooo0000001@0?ooo`<00000O@3oool007d0
oooo00<000000?ooo`3oool0C03oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
0<h0oooo001j0?ooo`@00000CP3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
0<h0oooo003o0?oooj@0oooo003o0?oooj@0oooo003o0?oooj@0oooo00030?ooo`D00000@`3oool5
000000L0oooo1@0000130?ooo`D000001`3oool4000004@0oooo1@0000060?ooo`D00000@`3oool5
000005P0oooo00080?ooo`P00000<@3oool:00000140oooo2000000a0?ooo`X00000403oool80000
0340oooo2`00000@0?ooo`P00000<@3oool:000005d0oooo000>0?ooo`X00000203oool2000000@0
oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool8000001h0
oooo2`0000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo2000000N0?ooo`X000002@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000040?ooo`800000203oool8000001h0
oooo2P0000060?ooo`8000000P3oool2000000<0oooo00@000000?ooo`3oool0oooo0P0000030?oo
o`040000003oool0oooo0?ooo`8000001@3oool8000006D0oooo000H0?ooo`H0000000<0oooo0000
000000000P0000020?ooo`@000000P3oool3000000<0oooo100000000`3oool00000000000030000
0340oooo1P000000103oool000000?ooo`0000030?ooo`<000000P3oool4000000<0oooo0`000002
0?ooo`D00000<03oool6000000030?ooo`0000000000008000000P3oool:00000080oooo10000002
0?ooo`D00000<03oool6000000030?ooo`00000000000080000000D0oooo00000000000000000?oo
o`04000000050?ooo`00000000000000003oool00`0000020?ooo`D00000K@3oool001`0oooo1000
00020?ooo`@000000P3oool3000000<0oooo100000020?ooo`@00000>03oool3000000<0oooo0`00
00030?ooo`<000000`3oool3000000<0oooo1000000g0?ooo`@000000P3oool400000080oooo1000
00020?ooo`@000000P3oool5000003L0oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P00
00020?ooo`8000000P3oool300000080oooo0P00001`0?ooo`00703oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`3o
ool200000080oooo00L000000?ooo`000000oooo0000003oool000000080oooo00L000000?ooo`00
0000oooo0000003oool0000000<0oooo00<000000?ooo`3oool0KP3oool001`0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?oo
o`3oool00`0000020?ooo`040000003oool000000?ooo`<000000P3oool01`000000oooo0000003o
ool000000?ooo`0000000`3oool00`000000oooo0?ooo`1^0?ooo`00703oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool010000000oooo0?oo
o`3oool200000080oooo0`0000020?ooo`8000000P3oool2000000<0oooo0P0000030?ooo`030000
003oool0oooo06h0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0KP3o
ool001`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1^0?ooo`00703oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo06h0oooo000L0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0KP3oool001`0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0;P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0KP3oool001`0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0;P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0KP3oool00140oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000903oool00`000000oooo00000008
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0000000P
0?ooo`<000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`<000000P3oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000006L0oooo000@0?ooo`040000003oool00000000000L0oooo0`00000I
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`00000000008`3oool010000000oooo0000
000000070?ooo`8000006@3oool00`000000oooo0?ooo`040?ooo`040000003oool00000000001l0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`050?ooo`8000003P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`0M0?ooo`040000003oool00000000000L0oooo0P00000J0?ooo`030000003o
ool0oooo00<0oooo00@000000?ooo`0000000000I`3oool00100oooo00@000000?ooo`3oool00000
1`3oool3000001T0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000S0?ooo`04
0000003oool0oooo000000L0oooo0P00000I0?ooo`030000003oool0oooo00@0oooo00@000000?oo
o`3oool000007`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo0P00
000>0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool000001`3oool2000001X0
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00001W0?ooo`00403oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`0000002`3oool20000
00D0oooo00@000000?ooo`3oool000008`3oool010000000oooo0?ooo`0000080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`000000303oool2000000D0oooo00@000000?ooo`3oool00000
7`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00L0oooo0`0000030?ooo`03
0000003oool0oooo00L0oooo0P0000060?ooo`040000003oool0oooo00000280oooo00@000000?oo
o`3oool00000203oool00`000000oooo0?ooo`090?ooo`030000003oool0000000/0oooo0P000005
0?ooo`040000003oool0oooo000006L0oooo000@0?ooo`040000003oool0oooo000000P0oooo00<0
00000?ooo`3oool0203oool010000000oooo00000000000;0?ooo`8000001@3oool010000000oooo
0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01`3oool01000
0000oooo00000000000<0?ooo`8000001@3oool010000000oooo0?ooo`00000P0?ooo`<000000`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`070?ooo`8000001`3oool300000080oooo00<000000?ooo`3oool0
7@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00P0oooo00@000000?ooo`00
000000002`3oool2000000D0oooo00@000000?ooo`3oool00000I`3oool001`0oooo00<000000?oo
o`3oool0203oool010000000oooo0?ooo`00000:0?ooo`<00000>03oool00`000000oooo0?ooo`07
0?ooo`040000003oool0oooo000000/0oooo0`00000[0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01P3oool010000000oooo0?ooo`00000<0?ooo`<000002@3oool00`000000oooo
0?ooo`0/0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool000002P3oool300000700
oooo000L0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000303oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000303oool00`00
0000oooo0?ooo`0Z0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000303o
ool00`000000oooo0?ooo`1^0?ooo`00703oool00`000000oooo0?ooo`080?ooo`040000003oool0
oooo000000`0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`070?ooo`040000003o
ool0oooo000000`0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`070?ooo`<00000
3P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool0
0000303oool00`000000oooo0?ooo`1^0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0KP3oool001`0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo06h0oooo000L0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0KP3oool001`0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`1^0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo06h0
oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0KP3oool001`0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`1^0?ooo`00703oool3000000P0oooo0`00000:
0?ooo`@00000>03oool3000000P0oooo0P00000:0?ooo`D00000=`3oool3000000P0oooo0`00000:
0?ooo`D00000=`3oool3000000P0oooo0`00000:0?ooo`@00000L03oool001`0oooo7000000h0?oo
oa`00000=`3ooolM000003L0oooo7000001`0?ooo`00803oool00`000000oooo0000000200000003
0?ooo`000000000000L000000P3oool200000400oooo0P000000103oool000000000003oool90000
00<0oooo0P0000100?ooo`80000000@0oooo000000000000oooo2@0000020?ooo`800000@@3oool0
0`000000oooo0000000<00000080oooo0P00001e0?ooo`00803oool;000000030?ooo`0000000000
00<0oooo0`00000o0?ooo``0000000<0oooo0000000000000`3oool200000400oooo300000000`3o
ool000000?ooo`030?ooo`800000@03oool;000000030?ooo`000000000000<0oooo0`00001d0?oo
o`006@3oool4000000040?ooo`00000000000?ooo`<000000`3oool300000080oooo0`000000103o
ool000000000003oool2000000<0oooo0`00000b0?ooo`<0000000<0oooo00000000000010000004
0?ooo`8000000`3oool3000000030?ooo`000000000000800000103oool2000003<0oooo0`000000
103oool000000000003oool3000000<0oooo0`0000020?ooo`040000003oool000000?ooo`D00000
103oool200000380oooo10000000103oool000000000003oool3000000<0oooo0`0000020?ooo`<0
000000@0oooo000000000000oooo0P0000030?ooo`<00000K@3oool001@0oooo1P0000020?ooo`80
0000103oool2000000<0oooo0P0000030?ooo`030000003oool0000000L0000000@0oooo00000000
0000oooo0P0000040?ooo`030000003oool0oooo02@0oooo1`0000020?ooo`8000000`3oool30000
00<0oooo0P0000030?ooo`@0000000H0oooo000000000000oooo0000003oool3000000030?ooo`00
0000oooo00<0oooo0P00000V0?ooo`H000000`3oool2000000<0oooo0P0000030?ooo`030000003o
ool000000080oooo00<000000?ooo`0000000P0000000`3oool0000000000002000000040?ooo`00
000000000?ooo`800000103oool2000002H0oooo1P0000020?ooo`800000103oool2000000<0oooo
0P0000030?ooo`030000003oool0000000L0000000@0oooo000000000000oooo0P0000040?ooo`03
0000003oool0oooo06D0oooo000>0?ooo`H00000103oool00`000000oooo0?ooo`020?ooo`800000
0`3oool2000000<0oooo0P0000030?ooo`<000001P3oool2000000@0oooo0P0000001@3oool00000
0000003oool0000000@0oooo0P00000J0?ooo`H000000`3oool2000000<0oooo0P0000030?ooo`03
0000003oool0000000<0oooo0P0000030?ooo`8000001`3oool2000000@0oooo00<000000?ooo`00
0000100000040?ooo`8000006P3oool6000000<0oooo00<000000?ooo`3oool00P3oool2000000<0
oooo0`0000020?ooo`030000003oool0000000<0oooo0P0000060?ooo`<000000`3oool200000003
0?ooo`000000000000<00000103oool00`000000oooo0?ooo`0H0?ooo`H000000`3oool2000000<0
oooo0`0000030?ooo`8000000`3oool2000000<0oooo0`0000060?ooo`800000103oool500000003
0?ooo`000000oooo00<0oooo0P00001P0?ooo`001@3oool3000000030?ooo`000000000000@00000
0`3oool2000000<0oooo0`0000020?ooo`<000000`3oool2000000<0oooo0P00000C0?ooo`800000
103oool00`000000oooo0?ooo`02000000030?ooo`000000oooo00<0oooo0P00000:0?ooo`<00000
00<0oooo000000000000100000030?ooo`8000000`3oool2000000<0oooo00<000000?ooo`000000
0P3oool3000000<0oooo0P00000C0?ooo`8000000`3oool2000000030?ooo`000000000000<00000
103oool2000000X0oooo0P0000000`3oool0000000000004000000@0oooo0P0000030?ooo`800000
0`3oool2000000<0oooo0`0000030?ooo`030000003oool0oooo0140oooo0P0000040?ooo`800000
00@0oooo000000000000oooo0P0000030?ooo`8000002P3oool3000000030?ooo`000000000000@0
00000`3oool2000000<0oooo0`0000020?ooo`030000003oool0000000<0oooo0P0000030?ooo`80
00004`3oool2000000@0oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`030?ooo`80
0000F@3oool000@0oooo0P0000020?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000
003oool000000080oooo00<000000?ooo`0000000`3oool2000000<0oooo0P00000O0?ooo`800000
103oool00`000000oooo0?ooo`04000000L0oooo0P0000020?ooo`800000103oool2000000<0oooo
0P0000030?ooo`<000000P3oool3000000<0oooo00<000000?ooo`3oool07@3oool3000000<0oooo
0P000000103oool000000000003oool2000000L0oooo0P0000020?ooo`8000000`3oool300000080
oooo0`0000030?ooo`8000000`3oool2000000@0oooo00<000000?ooo`3oool07@3oool3000000<0
oooo0P0000001@3oool000000000003oool0000000P0oooo0P000000103oool00000000000000003
0?ooo`8000000`3oool300000080oooo00<000000?ooo`0000000`3oool2000000<0oooo0P00000O
0?ooo`800000103oool00`000000oooo0?ooo`04000005P0oooo00030?ooo`030000003oool0oooo
0080oooo0P0000030?ooo`<000000P3oool00`000000oooo000000030?ooo`800000<03oool20000
00<0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool3000000<0oooo0P000003
0?ooo`8000000`3oool200000300oooo0`0000030?ooo`030000003oool0oooo00D0oooo00@00000
0?ooo`3oool0oooo0P0000030?ooo`030000003oool000000080oooo0`0000030?ooo`800000<03o
ool2000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`8000000`3o
ool2000000<0oooo00<000000?ooo`0000000`3oool200000300oooo0P0000030?ooo`030000003o
ool0oooo05H0oooo00080?ooo`8000000`3oool3000000<0oooo0P0000160?ooo`030000003oool0
000000<0oooo0P0000030?ooo`800000A`3oool00`000000oooo000000020?ooo`<000000`3oool2
000004L0oooo0P0000030?ooo`800000103oool2000009<0oooo00080?ooo`800000103oool00`00
0000oooo0?ooo`1;0?ooo`8000000`3oool2000004`0oooo0`0000030?ooo`800000C03oool20000
00<0oooo0P00002I0?ooo`00o`3ooonT0?ooo`00@@3oool00`000000oooo0?ooo`1A0?ooo`030000
003oool0oooo0500oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1T0?ooo`00@@3o
ool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0D@3o
ool00`000000oooo0?ooo`1T0?ooo`00@P3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0
oooo0500oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1S0?ooo`003`3oool20000
0340oooo00<000000?ooo`3oool07P3oool200000340oooo00<000000?ooo`3oool07@3oool20000
0340oooo00<000000?ooo`3oool07P3oool200000340oooo00<000000?ooo`3oool0H`3oool000h0
oooo00@000000?ooo`3oool00000<03oool2000001h0oooo00@000000?ooo`3oool00000<03oool2
000001d0oooo00@000000?ooo`3oool00000<03oool2000001h0oooo00@000000?ooo`3oool00000
<03oool2000006@0oooo000?0?ooo`<00000;P3oool01@000000oooo0000003oool0000001h0oooo
0`00000^0?ooo`050000003oool000000?ooo`0000007@3oool3000002h0oooo00D000000?ooo`00
0000oooo0000000N0?ooo`<00000;P3oool01@000000oooo0000003oool0000006<0oooo000>0?oo
o`040000003oool0oooo000002l0oooo00@000000?ooo`3oool000007@3oool010000000oooo0?oo
o`00000_0?ooo`040000003oool0oooo000001`0oooo00@000000?ooo`3oool00000;`3oool01000
0000oooo0?ooo`00000M0?ooo`040000003oool0oooo000002l0oooo00@000000?ooo`3oool00000
H`3oool000h0oooo00@000000?ooo`3oool00000D03oool010000000oooo0?ooo`00001?0?ooo`04
0000003oool0oooo00000500oooo00@000000?ooo`3oool00000UP3oool000h0oooo00@000000?oo
o`3oool00000D03oool010000000oooo0?ooo`00001?0?ooo`040000003oool0oooo00000500oooo
00@000000?ooo`3oool00000UP3oool000l0oooo0`00001A0?ooo`<00000D03oool300000540oooo
0`00002F0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00
o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00
o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00
o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00
o`3ooonT0?ooo`00]P3oool00`000000oooo0000000_0?ooo`030000003oool0000001l0oooo00<0
00000?ooo`000000;P3oool00`000000oooo0000000P0?ooo`030000003oool0000002h0oooo00<0
00000?ooo`0000004@3oool000l0oooo00<000000?ooo`000000D@3oool00`000000oooo0000001?
0?ooo`040000003oool00000000002h0oooo00@000000?ooo`00000000007P3oool010000000oooo
00000000000]0?ooo`040000003oool00000000001l0oooo00@000000?ooo`0000000000;@3oool0
10000000oooo00000000000A0?ooo`003P3oool010000000oooo00000000001@0?ooo`040000003o
ool00000000004l0oooo00@000000?ooo`3oool00000;P3oool010000000oooo0?ooo`00000N0?oo
o`040000003oool0oooo000002d0oooo00@000000?ooo`3oool000007`3oool010000000oooo0?oo
o`00000E0?ooo`80000000<0oooo0000003oool04`3oool010000000oooo0?ooo`00000A0?ooo`00
3P3oool010000000oooo0?ooo`00001@0?ooo`040000003oool0oooo000004l0oooo00@000000?oo
o`3oool00000503oool01@000000oooo0?ooo`3oool0000001D0oooo00@000000?ooo`3oool00000
7P3oool010000000oooo0?ooo`00000C0?ooo`80000000<0oooo0000003oool05@3oool010000000
oooo0?ooo`00000O0?ooo`040000003oool0oooo000001@0oooo00<000000?ooo`3oool00P00000D
0?ooo`040000003oool0oooo00000140oooo000>0?ooo`040000003oool0oooo000001@0oooo00D0
00000?ooo`3oool0oooo0000000g0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`00
0000=`3oool010000000oooo0?ooo`00000D0?ooo`050000003oool0oooo0?ooo`0000005@3oool0
10000000oooo0?ooo`00000N0?ooo`040000003oool0oooo00000180oooo00<000000?ooo`3oool0
0P00000F0?ooo`040000003oool0oooo000001l0oooo00@000000?ooo`3oool000004`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0180oooo00@000000?ooo`3oool000004@3oool0
00h0oooo00@000000?ooo`3oool00000503oool01@000000oooo0?ooo`3oool0000003L0oooo00@0
00000?ooo`3oool00000503oool010000000oooo00000000001?0?ooo`050000003oool0oooo0?oo
o`000000C03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04h0oooo00<000000?oo
o`3oool00`00000Y0?ooo`009P3oool01@000000oooo0?ooo`3oool0000004l0oooo00@000000?oo
o`3oool00000C`3oool5000004`0oooo00<000000?ooo`3oool00`0000030?ooo`800000B`3oool0
0`000000oooo0?ooo`0/0?ooo`009@3oool01`000000oooo0000003oool000000?ooo`000000503o
ool00`000000oooo0000000g0?ooo`040000003oool0oooo000001H0oooo00<000000?ooo`000000
=P3oool01@000000oooo0?ooo`3oool0000004`0oooo00<000000?ooo`3oool01@3oool010000000
oooo0?ooo`00001;0?ooo`050000003oool0oooo0?ooo`000000:@3oool002D0oooo00L000000?oo
o`000000oooo0000003oool0000001<0oooo00@000000?ooo`0000000000=`3oool010000000oooo
0?ooo`00000E0?ooo`040000003oool00000000003H0oooo00D000000?ooo`3oool0oooo0000001=
0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`00001<0?ooo`<00000
:P3oool002D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0A0?ooo`040000
003oool0oooo00000500oooo00@000000?ooo`3oool00000=P3oool01@000000oooo0?ooo`3oool0
000004h0oooo0`0000030?ooo`040000003oool0oooo000007T0oooo000U0?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`00001@0?ooo`040000
003oool0oooo000008l0oooo00@000000?ooo`3oool00000N@3oool000<0oooo0`00000i0?ooo`04
0000003oool0oooo000000`0oooo00<000000?ooo`3oool01@3oool3000003T0oooo00@000000?oo
o`3oool00000303oool00`000000oooo0?ooo`050?ooo`<00000AP3oool4000000H0oooo1000000U
0?ooo`8000007P3oool4000000L0oooo100000150?ooo`@00000103oool000H0oooo100000140?oo
o`030000003oool0oooo00T0oooo100000140?ooo`030000003oool0oooo00T0oooo1P0000000`3o
ool000000000000g0?ooo`H000003P3oool6000000030?ooo`000000000003H0oooo1P00000?0?oo
o`T00000=P3oool6000000P0oooo000:0?ooo`H00000?P3oool00`000000oooo0?ooo`0=0?ooo`D0
0000?P3oool00`000000oooo0?ooo`0@0?ooo`H00000;P3oool6000001X0oooo1P00000]0?ooo`H0
00006`3oool6000002d0oooo1P00000>0?ooo`003P3oool4000003/0oooo00<000000?ooo`3oool0
4@3oool5000003/0oooo00<000000?ooo`3oool05P3oool6000000<0oooo0P00000I0?ooo`800000
0P3oool9000002<0oooo1P0000030?ooo`800000603oool200000080oooo1P0000000`3oool00000
0000000T0?ooo`H000000`3oool2000001P0oooo0P0000020?ooo`H0000000<0oooo000000000000
4@3oool000d0oooo2@00000f0?ooo`030000003oool0oooo0180oooo2@00000f0?ooo`030000003o
ool0oooo01d0oooo1`0000000`3oool0000000000002000000030?ooo`00000000000080000000<0
oooo0000000000000P0000000`3oool0000000000002000000030?ooo`000000000000@00000<P3o
ool600000080oooo0`0000020?ooo`<000000P3oool4000000030?ooo`00000000000080000000<0
oooo0000000000000`00000c0?ooo`H000000P3oool300000080oooo200000020?ooo`<000000P3o
ool5000001X0oooo000F0?ooo`@000000P3oool2000000040?ooo`0000000000000000@0oooo0P00
00020?ooo`@000000`3oool300000080oooo0P00000C0?ooo`030000003oool0oooo01`0oooo1000
00020?ooo`8000002@3oool2000000d0oooo0P00000C0?ooo`030000003oool0oooo0240oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0:0?ooo`8000002`3oool00`000000oooo0?oo
o`0K0?ooo`006P3oool4000000060?ooo`000000oooo0?ooo`000000oooo0P0000000`3oool00000
00000003000000040?ooo`00000000000?ooo`8000000P3oool00`000000oooo0000000200000180
oooo00<000000?ooo`3oool0803ooolO00000140oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool001`0oooo
0`0000040?ooo`800000103oool2000000@0oooo0P0000030?ooo`<0000000<0oooo000000000000
403oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`000000
4@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`0G0?ooo`040000003o
ool0oooo000000l0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0H0?ooo`040000
003oool00000000000l0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool0
5`3oool2000000030?ooo`000000oooo00d0oooo00<000000?ooo`3oool0903oool010000000oooo
00000000000G0?ooo`040000003oool0oooo000000h0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool001`0
oooo00<000000?ooo`3oool0603oool3000000h0oooo00<000000?ooo`3oool0903oool5000001H0
oooo00@000000?ooo`3oool000003@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000
oooo0?ooo`0H0?ooo`@00000303oool00`000000oooo0?ooo`0U0?ooo`D000005P3oool00`000000
oooo0?ooo`02000000`0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool0
5`3oool200000080oooo100000080?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
603oool010000000oooo0?ooo`3oool3000000T0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool001`0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02d0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool03P3oool001`0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09`3oool5000001H0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0;@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo01L0oooo0P0000050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool07P3oool2000000P0oooo0P0000020?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`0000001`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`0000008`3oool00`000000oooo000000080?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0000000Q0?ooo`<000000P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`05
0?ooo`<000000P3oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo01P0oooo0P0000040?ooo`8000000`3oool200000200oooo00@000000?oo
o`3oool000001`3oool010000000oooo00000000000G0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool200000200oooo00@000000?ooo`00000000001`3oool2000001T0oooo
00<000000?ooo`3oool0103oool010000000oooo00000000000R0?ooo`040000003oool000000000
00L0oooo0P00000J0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`0000000000803oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo0P00000>0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00h0oooo000>0?ooo`<000000P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`8000001@3oool600000240oooo
0`0000070?ooo`030000003oool0oooo00h0oooo00<000000?ooo`0000001`3oool00`000000oooo
0?ooo`040?ooo`80000000@0oooo00000000000000008@3oool010000000oooo0?ooo`0000070?oo
o`8000002P3oool00`000000oooo0000000<0?ooo`030000003oool0oooo00@0oooo00@000000?oo
o`3oool000008P3oool010000000oooo0?ooo`0000070?ooo`8000002`3oool00`000000oooo0000
000<0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000803oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00D0oooo0P0000090?ooo`<000000P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`0>0?ooo`003@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00D0oooo0`00000:0?ooo`050000003oool0oooo0?ooo`0000002@3oool2000000L0oooo1@00000P
0?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`0000000000303oool010000000oooo
0000000000070?ooo`8000001`3oool400000240oooo00@000000?ooo`3oool000001`3oool00`00
0000oooo0?ooo`080?ooo`040000003oool00000000000/0oooo0P0000060?ooo`040000003oool0
oooo00000280oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`080?ooo`040000
003oool00000000000/0oooo0P0000050?ooo`040000003oool0oooo00000200oooo00@000000?oo
o`3oool000002`3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool0203oool2000000D0oooo00@000000?ooo`3oool000004`3oool000d0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`<000002P3oool01@000000oooo
0?ooo`3oool0000000T0oooo0P0000090?ooo`8000008@3oool010000000oooo0?ooo`0000070?oo
o`<0000000<0oooo0000003oool02P3oool010000000oooo0?ooo`0000070?ooo`8000002@3oool0
0`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`3oool0203o
ool010000000oooo0?ooo`00000;0?ooo`8000001P3oool010000000oooo0?ooo`00000R0?ooo`04
0000003oool0oooo000000P0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000;
0?ooo`8000001@3oool010000000oooo0?ooo`00000Q0?ooo`<000000P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`080?ooo`8000001P3oool300000080oooo00<000000?ooo`3oool03P3oool000d0oooo00@0
00000?ooo`3oool000002`3oool00`000000oooo0?ooo`080?ooo`070000003oool000000?ooo`00
0000oooo000000080?ooo`800000203oool00`000000oooo0000000Q0?ooo`040000003oool0oooo
000000L0oooo1@00000;0?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0000000/0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000
2P3oool3000003P0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000:0?ooo`<0
0000;03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3o
ool00000303oool3000000P0oooo00<000000?ooo`3oool04@3oool000h0oooo0`0000020?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool01`000000oooo0000003oool00000
0?ooo`000000203oool2000000P0oooo00<000000?ooo`0000008P3oool3000000L0oooo00<00000
0?ooo`3oool03@3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`000000;@3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo000000`0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo000000`0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0
oooo0`0000020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0A0?ooo`00403oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`@000001P3oool010000000
oooo0?ooo`00000/0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01@3oool01@00
0000oooo0?ooo`3oool0000002`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool06`3oool00100oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`800000:`3o
ool5000001H0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool2000002/0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00<0oooo0`00000X0?ooo`<0000000<0oooo0000003oool05@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0`00000X0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0V0?ooo`040000003oool00000000001L0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01/0oooo000L0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool0603oool01@00
0000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool09P3oool00`000000oooo00000002
000001H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo01/0oooo000L0?ooo`030000003oool0oooo01P0oooo0P0000020?ooo`030000003oool0oooo
00P0oooo0P00000W0?ooo`8000000P3oool00`000000oooo0?ooo`0D0?ooo`050000003oool0oooo
0?ooo`0000002`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`0H0?oo
o`040000003oool0oooo000000`0oooo0`00000U0?ooo`D000005P3oool010000000oooo0?ooo`00
000<0?ooo`<000009P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool05`3oool2000000030?ooo`000000
oooo00h0oooo0`00000S0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`000000403oool2
000002@0oooo100000070?ooo`<000002P3oool5000003L0oooo100000070?ooo`<000002@3oool5
000003P0oooo0`0000080?ooo`8000002P3oool5000001`0oooo000L0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`0000004P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`0R0?oooad00000=`3ooolL0000
03P0oooo7000000L0?ooo`006@3oool5000000T0oooo0`00000<0?ooo`<000004P3oool00`000000
oooo0?ooo`0N0?ooob0000004P3oool00`000000oooo0?ooo`0V0?ooo`l000000`3oool200000400
oooo3P0000030?ooo`800000@03oool4000000050?ooo`00000000000000003oool01P0000030?oo
o`8000008@3oool001@0oooo0`0000000`3oool000000?ooo`020?oooa`000004`3oool00`000000
oooo0?ooo`0J0?ooo`D000000`3oool200000080oooo0P0000020?ooo`8000000`3oool010000000
oooo0?ooo`3oool200000080oooo0P0000030?ooo`8000004P3oool00`000000oooo0?ooo`0U0?oo
o`H000000P3oool400000080oooo0P0000030?ooo`800000?P3oool4000000040?ooo`0000000000
0?ooo`D0000000<0oooo0000000000000`3oool3000003h0oooo1P0000020?ooo`@000000P3oool2
000000<0oooo0`00000P0?ooo`00403oool2000000030?ooo`00000000000080oooo0P00000b0?oo
o`030000003oool0oooo01D0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool0
0`000000oooo000000020?ooo`8000000P3oool010000000oooo0000003oool300000080oooo00<0
00000?ooo`0000005`3oool00`000000oooo0?ooo`0N0?ooo`H000000`3oool2000000<0oooo0P00
00030?ooo`030000003oool0000000H000000`3oool300000380oooo100000000`3oool000000?oo
o`020?ooo`8000000`3oool2000000<0oooo1P0000000`3oool00000000000030?ooo`<00000<P3o
ool600000080oooo0P0000040?ooo`8000000`3oool9000000<0oooo0`00000I0?ooo`003P3oool2
000000040?ooo`0000000000000000<0oooo0P00000b0?ooo`<000004`3oool3000000030?ooo`00
0000000000@0oooo0P0000060?ooo`030000003oool000000080oooo0P0000020?ooo`040000003o
ool000000?ooo`<000000P3oool00`000000oooo0000000G0?ooo`<000005@3oool200000080oooo
1P0000030?ooo`8000000`3oool2000000<0oooo00<000000?ooo`0000000P3oool3000000<0oooo
0P0000000`3oool000000000000200000080oooo00@000000?ooo`3oool0oooo0`00000R0?ooo`80
000000<0oooo000000000000100000040?ooo`8000000`3oool2000000<0oooo0P0000030?ooo`03
0000003oool0000000<0oooo1`0000000`3oool00000000000030?ooo`<000008P3oool200000003
0?ooo`000000000000@000000`3oool2000000<0oooo00<000000?ooo`0000000`3oool2000000<0
oooo0P0000030?ooo`80000000<0oooo0000000000000P0000020?ooo`8000000P3oool3000001<0
oooo00090?ooo`D00000103oool2000000<0oooo0`00000W0?ooo`030000003oool0oooo00X0oooo
0P00000=0?ooo`D00000103oool2000000<0oooo0P0000060?ooo`<000000P3oool200000080oooo
0`0000020?ooo`8000000P3oool3000000d0oooo00<000000?ooo`3oool02P3oool2000000d0oooo
1`0000000`3oool00000000000040?ooo`8000000`3oool2000000<0oooo00<000000?ooo`000000
0P3oool3000000<0oooo0P00000=0?ooo`@0000000<0oooo0000000000000`3oool3000001D0oooo
1P0000020?ooo`8000000`3oool2000000@0oooo0P0000030?ooo`8000000`3oool2000000<0oooo
0P00000=0?ooo`@000000P3oool2000000<0oooo0P00000E0?ooo`L0000000@0oooo000000000000
00000`3oool2000000<0oooo0`0000020?ooo`030000003oool0000000<0oooo0P0000030?ooo`80
00003@3oool400000080oooo00@000000?ooo`3oool0oooo0`00000<0?ooo`00103oool6000000<0
oooo0P0000030?ooo`<000000P3oool3000002L0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`060?ooo`D00000103oool2000000<0oooo0P0000030?ooo`800000:03oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo1`0000020?ooo`800000103oool2000000<0
oooo0P0000030?ooo`8000000`3oool3000001d0oooo100000020?ooo`8000000`3oool3000000P0
oooo100000000`3oool000000?ooo`020?ooo`8000000`3oool2000000<0oooo00<000000?ooo`00
00000P3oool3000000<0oooo0P00000N0?ooo`@000000P3oool010000000oooo0?ooo`3oool30000
00T0oooo1P0000030?ooo`030000003oool0oooo0080oooo0P0000030?ooo`8000000`3oool00`00
0000oooo000000020?ooo`<000007P3oool4000000030?ooo`000000000000<0oooo0`0000050?oo
o`000`3oool2000000<0oooo0P0000030?ooo`8000000`3oool2000002h0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo0P0000020?ooo`<0
00000`3oool2000002h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo0?ooo`8000000`3oool300000080oooo00<000000?ooo`0000000`3oool20000
00<0oooo0P00000Z0?ooo`@000000P3oool2000000H0oooo0P0000030?ooo`8000000`3oool20000
00<0oooo00<000000?ooo`0000000P3oool3000000<0oooo0P00000Z0?ooo`@000000P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool20000
00<0oooo0P0000030?ooo`<000000P3oool3000002T0oooo1@0000000`3oool00000000000040?oo
o`00203oool2000000<0oooo0P00000L0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo000000030?ooo`800000<`3oool00`000000oooo0?ooo`0F0?ooo`<0
00000P3oool00`000000oooo000000030?ooo`8000000`3oool200000480oooo0P0000030?ooo`<0
00000P3oool3000000<0oooo0P0000110?ooo`<000000`3oool2000000<0oooo0P0000030?ooo`80
0000>`3oool000P0oooo0P0000040?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
503oool2000001P0oooo0P0000030?ooo`800000<`3oool2000001L0oooo00<000000?ooo`000000
0P3oool3000000<0oooo0P0000170?ooo`8000000`3oool2000000@0oooo00<000000?ooo`3oool0
A@3oool3000000<0oooo0P0000040?ooo`030000003oool0oooo03h0oooo00080?ooo`800000703o
ool300000080oooo00<000000?ooo`3oool04P3oool01@000000oooo0000003oool0000001L0oooo
0P00000f0?ooo`050000003oool000000?ooo`0000005P3oool300000540oooo0P00001B0?ooo`80
0000BP3oool002D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0C0?ooo`04
0000003oool0oooo000003H0oooo0P00000H0?ooo`040000003oool0oooo00000?l0oooo2`3oool0
02D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`1<0?ooo`040000003oool0
oooo000006X0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1A0?ooo`030000003o
ool0oooo0100oooo000@0?ooo`8000004`3oool010000000oooo0?ooo`00000k0?ooo`8000005@3o
ool3000006X0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1A0?ooo`030000003o
ool0oooo0100oooo000?0?ooo`040000003oool0oooo000001<0oooo0`0000020?ooo`030000003o
ool0oooo03D0oooo00@000000?ooo`3oool000004`3oool010000000oooo0?ooo`00000h0?ooo`80
0000<@3oool00`000000oooo0?ooo`0N0?ooo`800000<@3oool00`000000oooo0?ooo`0N0?ooo`80
0000<@3oool00`000000oooo0?ooo`0?0?ooo`00403oool3000001D0oooo00<000000?ooo`3oool0
>@3oool3000001<0oooo00@000000?ooo`3oool00000=`3oool010000000oooo0?ooo`00000`0?oo
o`030000003oool0oooo01d0oooo00@000000?ooo`3oool00000<03oool00`000000oooo0?ooo`0M
0?ooo`040000003oool0oooo00000300oooo00<000000?ooo`3oool03`3oool000l0oooo00@00000
0?ooo`3oool000005@3oool00`000000oooo0?ooo`0h0?ooo`040000003oool0oooo000001<0oooo
00@000000?ooo`3oool00000>03oool300000300oooo0P00000O0?ooo`<00000<03oool2000001l0
oooo0`00000`0?ooo`800000403oool000l0oooo00@000000?ooo`3oool00000D03oool010000000
oooo0?ooo`00000D0?ooo`<00000=`3oool010000000oooo0?ooo`00000^0?ooo`050000003oool0
00000?ooo`0000007@3oool010000000oooo0?ooo`00000^0?ooo`050000003oool000000?ooo`00
00007@3oool010000000oooo0?ooo`00000^0?ooo`050000003oool000000?ooo`0000003`3oool0
00l0oooo00@000000?ooo`3oool00000D03oool010000000oooo0?ooo`00001>0?ooo`040000003o
ool0oooo000002l0oooo00@000000?ooo`3oool000007@3oool010000000oooo0?ooo`00000_0?oo
o`040000003oool0oooo000001d0oooo00@000000?ooo`3oool00000;`3oool010000000oooo0?oo
o`00000?0?ooo`00403oool300000540oooo0`00001>0?ooo`040000003oool0oooo00000500oooo
00@000000?ooo`3oool00000D03oool010000000oooo0?ooo`0000120?ooo`00]P3oool300000540
oooo0`00001A0?ooo`<00000@P3oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool0
0?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool0
0?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool0
0?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool0
0?l0ooooY03oool00?l0ooooY03oool00?l0ooooY03oool000l0oooo00<000000?ooo`000000;P3o
ool00`000000oooo0000000P0?ooo`030000003oool0000002h0oooo00<000000?ooo`000000803o
ool00`000000oooo0000001@0?ooo`030000003oool000000540oooo00<000000?ooo`000000@P3o
ool000h0oooo00@000000?ooo`0000000000;@3oool010000000oooo00000000000O0?ooo`040000
003oool00000000001D0oooo0P00000F0?ooo`040000003oool00000000001l0oooo00@000000?oo
o`0000000000C`3oool010000000oooo00000000001@0?ooo`040000003oool0000000000480oooo
000>0?ooo`040000003oool0oooo000002d0oooo00@000000?ooo`3oool000007`3oool010000000
oooo0?ooo`00000D0?ooo`040000003oool0oooo000001D0oooo00@000000?ooo`3oool000007`3o
ool010000000oooo0?ooo`00001?0?ooo`040000003oool0oooo00000500oooo00@000000?ooo`3o
ool00000@P3oool000h0oooo00@000000?ooo`3oool00000503oool01@000000oooo0?ooo`3oool0
000001@0oooo00@000000?ooo`3oool000007`3oool010000000oooo0?ooo`00000E0?ooo`<00000
5@3oool010000000oooo0?ooo`00000O0?ooo`040000003oool0oooo000001D0oooo0P0000000`3o
ool000000?ooo`0e0?ooo`040000003oool0oooo000001H0oooo0P0000000`3oool000000?ooo`0e
0?ooo`040000003oool0oooo000001@0oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`003P3o
ool010000000oooo0?ooo`00000D0?ooo`050000003oool0oooo0?ooo`000000503oool010000000
oooo0?ooo`00000O0?ooo`040000003oool0oooo000001@0oooo00@000000?ooo`3oool000005@3o
ool010000000oooo0?ooo`00000O0?ooo`040000003oool0oooo000001@0oooo00<000000?ooo`3o
ool00P00000f0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3oool00P00000f0?oo
o`040000003oool0oooo000001@0oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`009P3oool0
1@000000oooo0?ooo`3oool0000004l0oooo00@000000?ooo`3oool00000C`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`1<0?ooo`050000003oool0oooo0?ooo`000000:@3oool002D0oooo00L000000?ooo`000000
oooo0000003oool0000004h0oooo00@000000?ooo`3oool00000C`3oool00`000000oooo0?ooo`03
000004h0oooo00<000000?ooo`3oool00`00001=0?ooo`070000003oool000000?ooo`000000oooo
0000000X0?ooo`009@3oool01`000000oooo0000003oool000000?ooo`000000C`3oool3000004l0
oooo00<000000?ooo`3oool0603oool00`000000oooo0000000f0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`000000=P3oool01`000000oooo0000003oool000000?ooo`000000503oool0
0`000000oooo0000000A0?ooo`009@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo0:00oooo00D000000?ooo`3oool0oooo0000000D0?ooo`040000003oool00000000003L0oooo
00D000000?ooo`3oool0oooo0000000C0?ooo`040000003oool00000000003H0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`0A0?ooo`040000003oool0000000000140oooo000U
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0X@3oool3000001D0oooo00@0
00000?ooo`3oool00000>03oool3000001@0oooo00@000000?ooo`3oool00000=P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0140oooo00@000000?ooo`3oool000004@3oool0
0>L0oooo00@000000?ooo`3oool00000C`3oool010000000oooo0?ooo`00001@0?ooo`040000003o
ool0oooo00000140oooo00030?ooo`<00000A`3oool3000000L0oooo0`0000170?ooo`<000001`3o
ool2000003X0oooo00@000000?ooo`3oool00000303oool00`000000oooo0?ooo`040?ooo`<00000
>@3oool010000000oooo0?ooo`00000<0?ooo`030000003oool0oooo00D0oooo0`00000i0?ooo`04
0000003oool0oooo000000`0oooo00<000000?ooo`3oool00P3oool000H0oooo1000000o0?ooo`@0
00003@3oool4000003l0oooo1000000<0?ooo`@00000A@3oool00`000000oooo0?ooo`080?ooo`@0
0000A03oool00`000000oooo0?ooo`090?ooo`@00000A03oool00`000000oooo0?ooo`030?ooo`00
2P3oool6000003D0oooo1000000E0?ooo`H00000=@3oool4000001@0oooo1P00000n0?ooo`030000
003oool0oooo00d0oooo1P00000n0?ooo`030000003oool0oooo00d0oooo1P00000m0?ooo`030000
003oool0oooo00@0oooo000>0?ooo`@00000;`3oool4000001`0oooo1@00000_0?ooo`@00000703o
ool4000003`0oooo00<000000?ooo`3oool04@3oool4000003/0oooo00<000000?ooo`3oool04@3o
ool5000003/0oooo00<000000?ooo`3oool0103oool00180oooo1000000W0?ooo`H000008`3oool4
000002L0oooo1P00000R0?ooo`@00000=`3oool00`000000oooo0?ooo`0F0?ooo`@00000=P3oool0
0`000000oooo0?ooo`0G0?ooo`@00000=P3oool00`000000oooo0?ooo`050?ooo`005P3oool40000
0080oooo0P0000000`3oool000000000000200000080oooo0`0000020?ooo`@000000`3oool30000
0080oooo0P0000000`3oool0000000000002000002d0oooo100000020?oooa`0000000<0oooo0000
000000000P00000/0?ooo`@000000P3oool2000000`0oooo0P00000;0?ooo`8000004`3oool00`00
0000oooo0?ooo`0K0?ooo`@000000P3oool2000000`0oooo0P00000:0?ooo`8000004`3oool00`00
0000oooo0?ooo`0L0?ooo`@000000P3oool2000000040?ooo`0000000000000000<0oooo0`000000
0`3oool0000000000003000000<0oooo0`0000020?ooo`8000004`3oool00`000000oooo0?ooo`06
0?ooo`006P3oool600000080oooo100000000`3oool000000000000300000080oooo100000020?oo
o`D00000=@3oool400000080oooo00@000000?ooo`3oool0oooo0P0000030?ooo`040000003oool0
oooo0?ooo`8000000P3oool2000000<0oooo0`00000d0?ooo`H0000000<0oooo0000000000000P00
00000`3oool0000000000007000000030?ooo`00000000000080000000<0oooo0000000000000`00
000A0?ooo`030000003oool0oooo0200oooo1@0000020?ooo`<000000P3oool9000000030?ooo`00
000000000080000000<0oooo0000000000000P00000B0?ooo`030000003oool0oooo0200oooo1P00
00020?ooo`030000003oool000000080oooo100000030?ooo`<000000P3oool600000140oooo00<0
00000?ooo`3oool01`3oool001`0oooo00<000000?ooo`000000103oool2000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000003P0oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`8000000P3oool010000000oooo0000003oool300000080
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01L0
oooo00@000000?ooo`3oool00000403oool00`000000oooo0?ooo`0S0?ooo`8000001@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool20000
00030?ooo`000000oooo0100oooo00<000000?ooo`3oool01`3oool001`0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0f0?ooo`060000003oool0oooo0000003oool000000P3oool2
00000080oooo00@000000?ooo`000000oooo0`0000020?ooo`030000003oool000000080oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool000000100oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo000000l0oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0G0?ooo`030000003oool000000100oooo
00<000000?ooo`3oool0203oool001`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo00<000000P3oool200000080oooo0`0000020?ooo`8000000P3o
ool300000080oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0000000h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool02@3oool001`0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0I0?ooo`8000003P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`00703oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool00P00000;0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0603oool00`000000oooo000000020000
00/0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
00<000002P3oool00`000000oooo0?ooo`0;0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool00P3oool2000000T0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0080oooo0`0000080?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`020?ooo`<0
0000203oool00`000000oooo0?ooo`0;0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool00`3oool2000000L0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo000C0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo02X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00d0oooo000C0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2
00000280oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool03P3oool000h0oooo0`0000020?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`040?ooo`<000000P3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool000000200oooo0`0000030?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0303oool2000000030?ooo`000000oooo00L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`8000007@3oool300000080oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000002`3oool0
0`000000oooo0?ooo`020?ooo`8000000`3oool2000001h0oooo0`0000020?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool02`3oool2000000030?ooo`000000oooo00L0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`800000403oool000d0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo01h0oooo00@0
00000?ooo`0000000000203oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo
00@000000?ooo`00000000007`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`02000000P0oooo00<000000?oo
o`3oool0103oool6000001d0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003o
ool0oooo00@0oooo1P00000M0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00800000203oool00`000000oooo
0?ooo`050?ooo`D000004@3oool000d0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`050?ooo`<000006@3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool07P3oool010000000oooo0?ooo`0000070?ooo`8000006@3oool00`00
0000oooo0?ooo`040?ooo`040000003oool0oooo000001l0oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`050?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool3000001d0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`050?ooo`8000002`3oool01@000000oooo0?ooo`3oool0000000T0
oooo0P0000090?ooo`<000007@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00D0oooo0P00000;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`070?ooo`<000004@3oool000d0oooo00@000000?ooo`3oool000002P3oool20000
01T0oooo0P0000050?ooo`040000003oool0oooo000002<0oooo00@000000?ooo`3oool000001`3o
ool2000001T0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`00000O0?ooo`040000
003oool0oooo000000/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`03000000L0
oooo0P0000090?ooo`8000007P3oool010000000oooo0?ooo`00000:0?ooo`8000002P3oool01`00
0000oooo0000003oool000000?ooo`000000203oool2000000T0oooo0P00000N0?ooo`040000003o
ool0oooo000000X0oooo0P00000;0?ooo`030000003oool0oooo00<00000203oool00`000000oooo
0?ooo`070?ooo`8000004P3oool000h0oooo0`0000020?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool05`3oool2000000H0oooo0`0000020?ooo`030000003oool0oooo01h0oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`0G0?ooo`8000001@3oool010000000oooo
0?ooo`00000P0?ooo`<000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool2000000P0oooo00<000000?ooo`0000007`3oool300000080
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`070000003oool000000?oo
o`000000oooo000000080?ooo`800000203oool00`000000oooo0000000O0?ooo`<000000P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool2
000000L0oooo00<000000?ooo`0000004P3oool00100oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0F0?ooo`<00000203oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
01H0oooo0`00000[0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool01@00
0000oooo0?ooo`3oool0000000H0oooo0`0000080?ooo`030000003oool000000240oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool01@3oool3000000L0oooo00@000000?ooo`3oool000008@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo000000070?ooo`<0
00001`3oool00`000000oooo0000000B0?ooo`00403oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00`0oooo0`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
0P00000P0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00L0oooo0P0000060?ooo`040000003oool0oooo0000
0240oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`<000002@3oool00`00
0000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000004@3oool001`0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00P3oool3000002X0oooo00<000000?ooo`3oool05`3oool2000000H0oooo00<000000?oo
o`3oool00P3oool3000002X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0080oooo0`00000?0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`80
0000:@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00H0oooo0P00000=0?ooo`00
703oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo000L0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00/0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool0
1@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0H0?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo01L0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00/0
oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool010000000oooo
0?ooo`00000<0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0603oool200000003
0?ooo`000000oooo00X0oooo0P00000X0?ooo`030000003oool0oooo01L0oooo00@000000?ooo`3o
ool00000303oool2000000`0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0<0?ooo`<000009@3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0000000d0oooo1000000U0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool0303oool3000000X0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0>0?ooo`800000903oool00`000000oooo0?ooo`0G0?ooo`040000
003oool0oooo00000100oooo0P00000T0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`070?ooo`00703oool2000001P0oooo0P00000h0?ooo`800000
603oool2000003L0oooo0P00000I0?ooo`8000004P3oool00`000000oooo0?ooo`0R0?ooo`800000
603oool300000180oooo00<000000?ooo`3oool08P3oool2000001P0oooo0P00000B0?ooo`030000
003oool0oooo00L0oooo000H0?ooob<00000<@3ooolR00000380oooo8000000B0?ooo`030000003o
ool0oooo01h0oooo8000000C0?ooo`030000003oool0oooo01h0oooo8000000B0?ooo`030000003o
ool0oooo00L0oooo000D0?ooo`D000003P3oool300000100oooo00<000000?ooo`3oool00P3oool2
000002H0oooo1P00000>0?ooo`8000004@3oool010000000oooo0?ooo`3oool2000002L0oooo1@00
000>0?ooo`<000008@3oool00`000000oooo0?ooo`0J0?ooo`D000003P3oool300000240oooo00<0
00000?ooo`3oool06@3oool6000000h0oooo0P00000Q0?ooo`030000003oool0oooo00L0oooo000?
0?ooo`D000000`3oool200000280oooo100000000`3oool000000000000P0?ooo`H000000`3oool2
00000240oooo1@0000000`3oool000000?ooo`0P0?ooo`H000000P3oool200000380oooo0P00000F
0?ooo`D000000`3oool200000380oooo0P00000E0?ooo`H000000`3oool200000380oooo00<00000
0?ooo`3oool01P3oool000X0oooo0`0000000`3oool000000?ooo`020?ooo`8000000`3oool20000
02P0oooo0P0000020?ooo`@000005@3oool500000080oooo0P0000040?ooo`800000:03oool01000
0000oooo0?ooo`3oool3000001D0oooo1P0000020?ooo`8000000`3oool00`000000oooo0000000b
0?ooo`@000003P3oool3000000030?ooo`000000oooo0080oooo0P0000030?ooo`800000<`3oool3
000000l0oooo1@0000030?ooo`030000003oool0oooo0080oooo0P00000c0?ooo`<000001@3oool0
00H0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo00<000000?oo
o`000000:03oool3000000<0oooo00<000000?ooo`3oool03P3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`<000000`3oool2000002T0oooo0`0000020?ooo`800000403oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`<000000P3oool00`000000oooo0000000X0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool3000000030?ooo`0000000000
0080oooo0P0000030?ooo`8000000`3oool3000002L0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`070?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0`0000030?oo
o`800000:03oool00`000000oooo0?ooo`0:0?ooo`800000103oool000@0oooo0P000000103oool0
00000000000000030?ooo`8000000`3oool300000080oooo0P00000`0?ooo`030000003oool00000
00@000001`3oool3000000030?ooo`000000000000<0oooo00<000000?ooo`0000000`3oool20000
00<0oooo0P00000_0?ooo`80000000<0oooo0000000000000P0000080?ooo`80000000@0oooo0000
0000000000000`3oool300000080oooo00<000000?ooo`0000000`3oool2000002P0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo000000000000103oool2
000000<0oooo0P0000030?ooo`800000:03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00D0oooo0`0000000`3oool00000000000030?ooo`030000003oool0000000<0oooo0P000003
0?ooo`800000:03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00030?oo
o`030000003oool0oooo0080oooo0P0000030?ooo`8000000`3oool2000003H0oooo0P0000030?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0`0000020?ooo`<000000`3oool2
000003D0oooo0P0000040?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0P00
00030?ooo`030000003oool0000000<0oooo0P00000^0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`8000000`3oool2000000<0oooo0P00
000^0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool010000000oooo0?oo
o`3oool300000080oooo0`0000030?ooo`800000;P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0080oooo00080?ooo`8000000`3oool2000001`0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo000000030?ooo`800000C03oool00`000000oooo000000020?ooo`<00000703o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01H0oooo0P0000030?ooo`800000703o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01H0oooo0`0000030?ooo`800000703o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00l0oooo00080?ooo`8000008@3oool0
0`000000oooo0?ooo`0^0?ooo`800000D@3oool300000240oooo00<000000?ooo`3oool0503oool2
000001L0oooo0P00000Q0?ooo`030000003oool0oooo01@0oooo0P00000H0?ooo`8000008@3oool0
0`000000oooo0?ooo`0D0?ooo`800000403oool002H0oooo0`0000020?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0>03oool00`000000oooo0000000F0?ooo`030000003oool0oooo
03H0oooo0`0000030?ooo`030000003oool0oooo0180oooo00D000000?ooo`000000oooo0000000d
0?ooo`<000000P3oool00`000000oooo0?ooo`0B0?ooo`050000003oool000000?ooo`000000=@3o
ool300000080oooo00<000000?ooo`3oool04P3oool01@000000oooo0000003oool0000000l0oooo
000U0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0g0?ooo`040000003oool00000000001H0oooo00<000000?ooo`3oool0=@3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo01<0oooo00@000000?ooo`3oool00000<`3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo01<0oooo00@000000?ooo`3oool00000
=03oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo01<0oooo00@000000?ooo`3o
ool000003`3oool002D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo03H0oooo00@000000?ooo`3oool000005`3oool00`000000oooo0?ooo`0d
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0BP3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo04/0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`0V0?ooo`00403oool2000001<0oooo00@000000?ooo`3oool00000603oool00`000000
oooo0?ooo`0P0?ooo`800000503oool010000000oooo0?ooo`00000G0?ooo`030000003oool0oooo
01l0oooo0P00000C0?ooo`040000003oool0oooo000003/0oooo0P00000C0?ooo`040000003oool0
oooo000003/0oooo0P00000C0?ooo`040000003oool0oooo000002/0oooo000?0?ooo`040000003o
ool0oooo000001<0oooo0`0000020?ooo`030000003oool0oooo01<0oooo0P00000P0?ooo`040000
003oool0oooo000001<0oooo00@000000?ooo`3oool000005`3oool2000001l0oooo00@000000?oo
o`3oool000004`3oool3000000<0oooo00<000000?ooo`3oool0=03oool010000000oooo0?ooo`00
000C0?ooo`<000000P3oool00`000000oooo0?ooo`0e0?ooo`040000003oool0oooo000001<0oooo
0`0000020?ooo`030000003oool0oooo02H0oooo000@0?ooo`<000005@3oool00`000000oooo0?oo
o`0D0?ooo`050000003oool000000?ooo`000000803oool3000002`0oooo00D000000?ooo`000000
oooo0000000O0?ooo`<000005@3oool00`000000oooo0?ooo`0i0?ooo`<000005@3oool00`000000
oooo0?ooo`0i0?ooo`<000005@3oool00`000000oooo0?ooo`0Y0?ooo`003`3oool010000000oooo
0?ooo`00000E0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`3oool000007`3oool01000
0000oooo0?ooo`00000]0?ooo`040000003oool0oooo000001h0oooo00@000000?ooo`3oool00000
5@3oool00`000000oooo0?ooo`0h0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3o
ool0>03oool010000000oooo0?ooo`00000E0?ooo`030000003oool0oooo02T0oooo000?0?ooo`04
0000003oool0oooo00000500oooo00@000000?ooo`3oool00000C`3oool010000000oooo0?ooo`00
001@0?ooo`040000003oool0oooo00000500oooo00@000000?ooo`3oool00000@@3oool000l0oooo
00@000000?ooo`3oool00000D03oool010000000oooo0?ooo`00001?0?ooo`040000003oool0oooo
00000500oooo00@000000?ooo`3oool00000D03oool010000000oooo0?ooo`0000110?ooo`00403o
ool300000540oooo0`00001@0?ooo`<00000D@3oool300000540oooo0`0000110?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT
0?ooo`00o`3ooonT0?ooo`003`3oool00`000000oooo0000000^0?ooo`030000003oool000000200
oooo00<000000?ooo`000000;P3oool00`000000oooo0000000P0?ooo`030000003oool0000002d0
oooo00<000000?ooo`000000803oool00`000000oooo0000000^0?ooo`030000003oool000000200
oooo00<000000?ooo`000000;P3oool00`000000oooo0000000A0?ooo`003P3oool010000000oooo
00000000000]0?ooo`040000003oool00000000001l0oooo00@000000?ooo`0000000000;@3oool0
10000000oooo00000000000O0?ooo`040000003oool00000000002`0oooo00@000000?ooo`000000
00007`3oool010000000oooo00000000000F0?ooo`030000003oool0oooo01@0oooo00@000000?oo
o`00000000007`3oool010000000oooo00000000000]0?ooo`040000003oool0000000000140oooo
000>0?ooo`040000003oool0oooo000002d0oooo00@000000?ooo`3oool000007`3oool010000000
oooo0?ooo`00000]0?ooo`040000003oool0oooo000001l0oooo00@000000?ooo`3oool00000;03o
ool010000000oooo0?ooo`00000O0?ooo`040000003oool0oooo000001H0oooo00<000000?ooo`3o
ool0503oool010000000oooo0?ooo`00000O0?ooo`040000003oool0oooo000002d0oooo00@00000
0?ooo`3oool000004@3oool000h0oooo00@000000?ooo`3oool00000;@3oool010000000oooo0?oo
o`00000O0?ooo`040000003oool0oooo000002d0oooo00@000000?ooo`3oool000007`3oool01000
0000oooo0?ooo`00000E0?ooo`80000000<0oooo0000003oool04P3oool010000000oooo0?ooo`00
000O0?ooo`040000003oool0oooo000001L0oooo00<000000?ooo`3oool04`3oool010000000oooo
0?ooo`00000O0?ooo`040000003oool0oooo000001@0oooo1000000E0?ooo`040000003oool0oooo
00000140oooo000>0?ooo`040000003oool0oooo000001@0oooo00D000000?ooo`3oool0oooo0000
000D0?ooo`040000003oool0oooo000001l0oooo00@000000?ooo`3oool000004`3oool200000003
0?ooo`000000oooo01D0oooo00@000000?ooo`3oool000007`3oool010000000oooo0?ooo`00000D
0?ooo`030000003oool0oooo008000004`3oool010000000oooo0?ooo`00000O0?ooo`040000003o
ool0oooo000001L0oooo00<000000?ooo`3oool04`3oool010000000oooo0?ooo`00000O0?ooo`04
0000003oool0oooo000001@0oooo00<000000?ooo`3oool05P3oool010000000oooo0?ooo`00000A
0?ooo`009P3oool01@000000oooo0?ooo`3oool0000004d0oooo00<000000?ooo`3oool00P00001@
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0C`3oool200000500oooo00<00000
0?ooo`3oool0:P3oool002H0oooo00D000000?ooo`3oool0oooo0000001<0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`03000004l0oooo00D00000
0?ooo`000000oooo0000001?0?ooo`800000:`3oool002H0oooo1@00001<0?ooo`030000003oool0
oooo00<000000`3oool2000004/0oooo00<000000?ooo`3oool0D`3oool010000000oooo0?ooo`00
001@0?ooo`030000003oool0oooo02T0oooo000V0?ooo`050000003oool0oooo0?ooo`000000C03o
ool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000004/0oooo00D000000?ooo`3oool0
oooo0000002U0?ooo`030000003oool0oooo02P0oooo000V0?ooo`050000003oool0oooo0?ooo`00
0000C@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool00000C03oool3
00000:<0oooo1000000Z0?ooo`009P3oool01@000000oooo0?ooo`3oool0000004h0oooo0`000003
0?ooo`040000003oool0oooo00000?l0oooo8@3oool000<0oooo0`0000170?ooo`<000001`3oool3
000002D0oooo00@000000?ooo`3oool000007P3oool3000000L0oooo0`0000170?ooo`<000001P3o
ool3000004L0oooo0`0000070?ooo`<00000A`3oool3000000@0oooo00060?ooo`D000000`3oool2
000003P0oooo1@00000=0?ooo`D000000P3oool2000001d0oooo0P00000J0?ooo`D000003@3oool5
00000080oooo0P00000i0?ooo`D00000303oool5000000<0oooo0P00000h0?ooo`D000003@3oool5
00000080oooo0P00000i0?ooo`D000001`3oool000/0oooo1P00000`0?ooo`L000005`3oool60000
0300oooo1`00000G0?ooo`D00000<03oool8000001H0oooo1P00000`0?ooo`L000005`3oool60000
0300oooo1`00000<0?ooo`003@3oool8000002X0oooo1000000N0?ooo`P00000:@3oool5000001d0
oooo2000000Z0?ooo`D000007@3oool8000002X0oooo1000000N0?ooo`P00000:@3oool500000140
oooo000E0?ooo`D000000P3oool2000001P0oooo0P0000020?ooo`D00000:P3oool500000080oooo
0P00000H0?ooo`80000000<0oooo0000000000000`00000Z0?ooo`D000000P3oool2000001T0oooo
0P0000000`3oool0000000000003000002X0oooo1@0000020?ooo`8000000P3oool2000000@0oooo
0P0000040?ooo`800000103oool010000000oooo0?ooo`3oool200000080oooo1@00000Z0?ooo`D0
00000P3oool200000080oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool2000000<0oooo0P0000000`3oool0000000000003000001H0oooo000J0?ooo`H00000
00<0oooo0000000000000P0000000`3oool0000000000002000000030?ooo`000000000000800000
00<0oooo0000000000000P0000000`3oool0000000000003000003@0oooo1@0000020?ooo`<00000
0P3oool300000080oooo0`0000020?ooo`<000000P3oool4000003@0oooo1P0000000`3oool00000
00000002000000030?ooo`000000000000L0000000<0oooo0000000000000P0000000`3oool00000
00000003000003@0oooo100000000`3oool000000000000200000080oooo00@000000?ooo`000000
00000P3oool400000080oooo00D000000?ooo`00000000000?ooo`04000003@0oooo100000000`3o
ool000000?ooo`02000000050?ooo`00000000000?ooo`0000000P3oool2000000040?ooo`000000
00000?ooo`@000000P3oool3000001/0oooo000L0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool02`3oool2000000/0oooo00<000000?ooo`3oool0=P3oool400000080oooo0`000003
0?ooo`<000000`3oool3000000<0oooo1000000h0?ooo`<000000`3oool3000000<0oooo0`000003
0?ooo`<000000`3oool3000001d0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01/0oooo000L0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01/0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01/0oooo000L0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01/0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01/0oooo000L0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01/0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01/0oooo000L0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02h0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool00140oooo00<00000
0?ooo`000000203oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`000000903oool00`000000oooo000000080?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0000000P0?ooo`<000000`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01@3oool300000080oooo00<00000
0?ooo`3oool07P3oool00`000000oooo000000080?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0000000T0?ooo`030000003oool0000000P0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000001<0oooo000@0?oo
o`040000003oool00000000000L0oooo0`00000I0?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`00000000008`3oool010000000oooo0000000000070?ooo`8000006@3oool00`000000oooo
0?ooo`040?ooo`040000003oool00000000001l0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`050?ooo`8000006@3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool07@3oool010000000oooo0000000000070?ooo`8000006P3o
ool00`000000oooo0?ooo`030?ooo`040000003oool00000000002<0oooo00@000000?ooo`000000
00001`3oool2000001T0oooo00<000000?ooo`3oool0103oool010000000oooo00000000000C0?oo
o`00403oool010000000oooo0?ooo`0000070?ooo`<000006@3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo000002<0oooo00@000000?ooo`3oool000001`3oool2000001T0oooo00<0
00000?ooo`3oool0103oool010000000oooo0?ooo`00000O0?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool01@3oool2000001T0oooo00<000000?ooo`3oool0103oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool000001`3oool2
000001X0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000S0?ooo`040000003o
ool0oooo000000L0oooo0P00000I0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0
00004`3oool00100oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0G0?ooo`80
00001@3oool010000000oooo0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo00<00000
0?ooo`3oool05`3oool2000000D0oooo00@000000?ooo`3oool000007`3oool010000000oooo0?oo
o`00000;0?ooo`030000003oool0oooo01L0oooo0P0000060?ooo`040000003oool0oooo00000280
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0G0?ooo`8000001@3oool01000
0000oooo0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool05`3o
ool2000000D0oooo00@000000?ooo`3oool000004`3oool00100oooo00@000000?ooo`3oool00000
203oool00`000000oooo0?ooo`0G0?ooo`8000001@3oool010000000oooo0?ooo`00000S0?ooo`04
0000003oool0oooo000000P0oooo00<000000?ooo`3oool05`3oool2000000D0oooo00@000000?oo
o`3oool00000803oool3000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0G
0?ooo`8000001`3oool300000080oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`00
00080?ooo`030000003oool0oooo01L0oooo0P0000050?ooo`040000003oool0oooo000002<0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0G0?ooo`8000001@3oool010000000
oooo0?ooo`00000C0?ooo`00703oool00`000000oooo0?ooo`0F0?ooo`<00000>03oool00`000000
oooo0?ooo`0F0?ooo`<00000:`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0
oooo0`0000090?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool05P3oool3000003P0
oooo00<000000?ooo`3oool05P3oool3000001`0oooo000L0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0K0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?oo
o`00703oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0K0?ooo`006P3oool4000000T0oooo0`00000<0?ooo`@00000=03oool4000000T0
oooo0P00000=0?ooo`<00000=03oool4000000T0oooo0`00000=0?ooo`<00000=03oool4000000T0
oooo0`00000<0?ooo`@00000=03oool4000000T0oooo0P00000=0?ooo`<000006`3oool001P0oooo
0P0000020?oooa`0000000<0oooo000000000000<@3oool2000000030?ooo`000000000001/00000
00<0oooo0000003oool0<03oool3000000030?ooo`000000000001d00000<@3oool2000000030?oo
o`000000000001/0000000<0oooo000000000000<@3oool2000000030?ooo`000000000001/00000
00<0oooo0000003oool06@3oool001<0oooo1P00000Q0?ooo`8000000P3oool3000002H0oooo1@00
000R0?ooo`040000003oool0oooo0?ooo`<000009P3oool500000240oooo0P0000020?ooo`<00000
9P3oool600000240oooo0P0000020?ooo`<000009P3oool500000280oooo00<000000?ooo`3oool0
1000000C0?ooo`003P3oool6000000<0oooo0P00000R0?ooo`<000000P3oool200000200oooo1@00
00040?ooo`8000008P3oool300000080oooo0P00000P0?ooo`D000000`3oool200000280oooo1000
00020?ooo`030000003oool0oooo01h0oooo1P0000030?ooo`8000008P3oool4000000030?ooo`00
000000000200oooo1@0000040?ooo`8000008P3oool300000080oooo0P00000B0?ooo`002P3oool5
000000<0oooo0P0000030?ooo`<000009`3oool2000000030?ooo`000000000000<00000503oool5
000000@0oooo0P0000030?ooo`800000:03oool2000000030?ooo`0000000000008000005@3oool5
000000<0oooo0P0000030?ooo`030000003oool0000002P0oooo00<000000?ooo`3oool01000000E
0?ooo`D000000`3oool2000000<0oooo0`00000W0?ooo`80000000<0oooo0000000000000`00000D
0?ooo`D00000103oool2000000<0oooo0P00000X0?ooo`80000000<0oooo0000000000000P00000<
0?ooo`001@3oool5000000<0oooo0P0000030?ooo`<000000P3oool3000002P0oooo0`0000030?oo
o`8000000P3oool3000000T0oooo1P0000030?ooo`8000000P3oool3000000<0oooo0P00000Y0?oo
o`<000000`3oool010000000oooo0?ooo`3oool3000000T0oooo1@0000030?ooo`8000000`3oool0
0`000000oooo000000020?ooo`<00000:@3oool2000000<0oooo0P0000030?ooo`8000002@3oool6
000000<0oooo0P0000030?ooo`8000000`3oool3000002P0oooo0`0000030?ooo`8000000P3oool3
000000T0oooo1P0000030?ooo`8000000P3oool3000000<0oooo0P00000Y0?ooo`<000000`3oool0
10000000oooo0?ooo`3oool3000000D0oooo00040?ooo`040000003oool0oooo0?ooo`8000000`3o
ool2000000<0oooo0`0000030?ooo`030000003oool0oooo02h0oooo100000000`3oool000000000
00070?ooo`8000000`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool2000000<0
oooo0P00000`0?ooo`@0000000<0oooo0000000000001`3oool010000000oooo0?ooo`3oool20000
00<0oooo00<000000?ooo`0000000P3oool3000000<0oooo00<000000?ooo`3oool0;P3oool40000
0080oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000@0oooo0P000003
0?ooo`800000103oool00`000000oooo0?ooo`0^0?ooo`@0000000<0oooo0000000000001`3oool2
000000<0oooo0P0000020?ooo`030000003oool0000000<0oooo0P0000030?ooo`800000;`3oool5
000000030?ooo`000000000000@0oooo00030?ooo`030000003oool0oooo0080oooo0P0000030?oo
o`800000103oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00D0oooo00L000000?oo
o`3oool0oooo0000003oool000000080oooo0`0000030?ooo`800000>`3oool00`000000oooo0?oo
o`050?ooo`040000003oool0oooo0?ooo`<000000P3oool00`000000oooo000000030?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0080oooo0P0000030?ooo`8000000`3oool2000003/0oooo00<000000?ooo`3oool0
1@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool3000000<0oooo0P00000k0?oo
o`030000003oool0oooo0080oooo00080?ooo`8000000`3oool2000004`0oooo0`0000030?ooo`80
0000C03oool00`000000oooo000000030?ooo`800000703oool00`000000oooo0?ooo`0]0?ooo`80
00000`3oool2000004`0oooo0`0000030?ooo`800000A@3oool000P0oooo0P00000N0?ooo`030000
003oool000000340oooo0P00000M0?ooo`030000003oool000000340oooo0`00000K0?ooo`<00000
0`3oool00`000000oooo0?ooo`0]0?ooo`8000007P3oool00`000000oooo0000000a0?ooo`800000
7@3oool00`000000oooo0000000Z0?ooo`009`3oool010000000oooo00000000000E0?ooo`030000
003oool0oooo03L0oooo00@000000?ooo`00000000005P3oool00`000000oooo0?ooo`0e0?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0g0?oo
o`040000003oool00000000001D0oooo00<000000?ooo`3oool0=`3oool010000000oooo00000000
000F0?ooo`030000003oool0oooo0140oooo000W0?ooo`040000003oool0oooo000001D0oooo00<0
00000?ooo`3oool0=`3oool010000000oooo0?ooo`00000F0?ooo`030000003oool0oooo03D0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03L0
oooo00@000000?ooo`3oool000005@3oool00`000000oooo0?ooo`0g0?ooo`040000003oool0oooo
000001H0oooo00<000000?ooo`3oool04@3oool002L0oooo00@000000?ooo`3oool000005P3oool0
0`000000oooo0?ooo`0f0?ooo`040000003oool0oooo000001L0oooo00<000000?ooo`3oool0=03o
ool010000000oooo0?ooo`00000I0?ooo`030000003oool0oooo03H0oooo00@000000?ooo`3oool0
00005P3oool00`000000oooo0?ooo`0f0?ooo`040000003oool0oooo000001L0oooo00<000000?oo
o`3oool0403oool00100oooo0P00000E0?ooo`040000003oool0oooo000001H0oooo00<000000?oo
o`3oool0803oool2000001@0oooo00@000000?ooo`3oool000005`3oool00`000000oooo0?ooo`0O
0?ooo`800000503oool3000000<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0O
0?ooo`8000005@3oool010000000oooo0?ooo`00000F0?ooo`030000003oool0oooo0200oooo0P00
000D0?ooo`040000003oool0oooo000001L0oooo00<000000?ooo`3oool0403oool000l0oooo00@0
00000?ooo`3oool00000;P3oool200000200oooo00@000000?ooo`3oool00000;P3oool2000001l0
oooo00@000000?ooo`3oool000005@3oool00`000000oooo0?ooo`0G0?ooo`8000007`3oool01000
0000oooo0?ooo`00000^0?ooo`800000803oool010000000oooo0?ooo`00000^0?ooo`8000004@3o
ool00100oooo0`00000/0?ooo`050000003oool000000?ooo`000000803oool3000002`0oooo00D0
00000?ooo`000000oooo0000000O0?ooo`<000005@3oool00`000000oooo0?ooo`0E0?ooo`050000
003oool000000?ooo`0000007`3oool3000002`0oooo00D000000?ooo`000000oooo0000000P0?oo
o`<00000;03oool01@000000oooo0000003oool000000100oooo000?0?ooo`040000003oool0oooo
000002d0oooo00@000000?ooo`3oool000007`3oool010000000oooo0?ooo`00000]0?ooo`040000
003oool0oooo000001h0oooo00@000000?ooo`3oool00000;P3oool010000000oooo0?ooo`00000N
0?ooo`040000003oool0oooo000002d0oooo00@000000?ooo`3oool000007`3oool010000000oooo
0?ooo`00000]0?ooo`040000003oool0oooo00000100oooo000?0?ooo`040000003oool0oooo0000
0500oooo00@000000?ooo`3oool00000C`3oool010000000oooo0?ooo`00001@0?ooo`040000003o
ool0oooo00000500oooo00@000000?ooo`3oool00000@@3oool000l0oooo00@000000?ooo`3oool0
0000D03oool010000000oooo0?ooo`00001?0?ooo`040000003oool0oooo00000500oooo00@00000
0?ooo`3oool00000D03oool010000000oooo0?ooo`0000110?ooo`00403oool300000540oooo0`00
001@0?ooo`<00000D@3oool300000540oooo0`0000110?ooo`00o`3ooonT0?ooo`00o`3ooonT0?oo
o`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?oo
o`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?oo
o`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?oo
o`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00h@3oool00`000000oooo0?ooo`2o
0?ooo`00h@3oool00`000000oooo0?ooo`2o0?ooo`00d@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo0;h0oooo003B0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
_P3oool00<d0oooo1`00000>0?ooo`800000_`3oool00=80oooo00<000000?ooo`3oool03@3oool2
00000;l0oooo003A0?ooo`030000003oool0oooo00`0oooo00D000000?ooo`000000oooo0000002n
0?ooo`00h@3oool010000000oooo0?ooo`00002n0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00
o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00o`3ooonT0?ooo`00
\
\>"],
  ImageRangeCache->{{{0, 418.312}, {443.438, 0}} -> {-0.000550005, \
-0.00403441, 0.394446, 0.394446}, {{0, 83.625}, {108.75, 25.0625}} -> \
{-1.00011, -89.0586, 0.394623, 0.394623}, {{83.625, 167.312}, {108.75, \
25.0625}} -> {-22.9839, -88.9846, 0.394328, 0.394328}, {{167.312, 250.938}, \
{108.75, 25.0625}} -> {-45.017, -89.0586, 0.394623, 0.394623}, {{250.938, \
334.625}, {108.75, 25.0625}} -> {-66.968, -88.9846, 0.394328, 0.394328}, \
{{334.625, 418.25}, {108.75, 25.0625}} -> {-89.034, -89.0586, 0.394623, \
0.394623}, {{0, 83.625}, {192.438, 108.75}} -> {-1.00011, -67.0419, 0.394623, \
0.394623}, {{83.625, 167.312}, {192.438, 108.75}} -> {-22.9839, -66.9844, \
0.394328, 0.394328}, {{167.312, 250.938}, {192.438, 108.75}} -> {-45.017, \
-67.0419, 0.394623, 0.394623}, {{250.938, 334.625}, {192.438, 108.75}} -> \
{-66.968, -66.9844, 0.394328, 0.394328}, {{334.625, 418.25}, {192.438, \
108.75}} -> {-89.034, -67.0419, 0.394623, 0.394623}, {{0, 83.625}, {276.062, \
192.438}} -> {-1.00011, -45.0335, 0.394623, 0.394623}, {{83.625, 167.312}, \
{276.062, 192.438}} -> {-23.0086, -45.0335, 0.394623, 0.394623}, {{167.312, \
250.938}, {276.062, 192.438}} -> {-45.017, -45.0335, 0.394623, 0.394623}, \
{{250.938, 334.625}, {276.062, 192.438}} -> {-67.0255, -45.0335, 0.394623, \
0.394623}, {{334.625, 418.25}, {276.062, 192.438}} -> {-89.034, -45.0335, \
0.394623, 0.394623}, {{0, 83.625}, {359.75, 276.062}} -> {-1.00011, -23.025, \
0.394623, 0.394623}, {{83.625, 167.312}, {359.75, 276.062}} -> {-22.9839, \
-23.0004, 0.394328, 0.394328}, {{167.312, 250.938}, {359.75, 276.062}} -> \
{-45.017, -23.025, 0.394623, 0.394623}, {{250.938, 334.625}, {359.75, \
276.062}} -> {-66.968, -23.0004, 0.394328, 0.394328}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Direct Photon Production: 2 Loops (4084 diagrams)", "Section"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(\(tops = 
        CreateTopologies[2, 4, 
          ExcludeTopologies \[Rule] {Internal}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[tops, {V[5], F[3, {1}]} \[Rule] {V[1], F[3, {1}]}, 
          Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Paint[ins, ColumnsXRows \[Rule] 10, PaintLevel \[Rule] {Classes}, 
        AutoEdit \[Rule] False];\)\)}], "Input",
  Evaluatable->False]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{1012, 688},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->12],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{8, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->8],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LineSpacing->{1, 11},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellFrame->True,
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LineSpacing->{1, 7},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    Background->GrayLevel[0.849989]],
  
  Cell[StyleData["Section", "Presentation"],
    CellFrame->True,
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellFrame->True,
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellFrame->True,
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    Hyphenation->True,
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    DefaultNewInlineCellStyle->"None",
    Hyphenation->True,
    LineSpacing->{1, 3},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}},
    FontSize->11],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}},
    FontSize->11],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontSize->11,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->False,
    LanguageCategory->"Formula",
    ScriptLevel->1,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{59, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{108, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{158, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["Hyperlink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["MainBookLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["AddOnsLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["GettingStartedLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["OtherInformationLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    LanguageCategory->"Formula",
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 37, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[1789, 56, 73, 1, 39, "Input"],
Cell[1865, 59, 62, 1, 34, "Print"],
Cell[1930, 62, 64, 1, 34, "Print"],
Cell[1997, 65, 99, 2, 34, "Print"],
Cell[2099, 69, 73, 1, 34, "Print"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2221, 76, 45, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[2291, 80, 48, 1, 39, "Input"],
Cell[2342, 83, 120237, 2773, 992, "Print"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[122628, 2862, 40, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[122693, 2866, 603, 13, 200, "Input"],
Cell[123299, 2881, 62, 1, 34, "Print"],
Cell[123364, 2884, 397, 8, 34, "Print"],
Cell[123764, 2894, 62, 1, 34, "Print"],
Cell[123829, 2897, 222, 5, 34, "Print"],
Cell[124054, 2904, 266, 5, 34, "Print"],
Cell[124323, 2911, 266, 5, 34, "Print"],
Cell[124592, 2918, 266, 5, 34, "Print"],
Cell[124861, 2925, 266, 5, 34, "Print"],
Cell[125130, 2932, 224, 5, 34, "Print"],
Cell[125357, 2939, 62, 1, 34, "Print"],
Cell[125422, 2942, 397, 8, 34, "Print"],
Cell[125822, 2952, 246, 5, 34, "Print"],
Cell[126071, 2959, 31759, 1021, 293, 18180, 849, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[157867, 3985, 58, 1, 32, "Input"],
Cell[157928, 3988, 62, 1, 34, "Print"],
Cell[157993, 3991, 242, 5, 34, "Print"],
Cell[158238, 3998, 266, 5, 34, "Print"],
Cell[158507, 4005, 224, 5, 34, "Print"],
Cell[158734, 4012, 23757, 471, 706, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[182528, 4488, 49, 1, 32, "Input"],
Cell[182580, 4491, 52, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[182669, 4497, 65, 1, 32, "Input"],
Cell[182737, 4500, 78, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[182852, 4506, 98, 2, 55, "Input"],
Cell[182953, 4510, 61, 1, 40, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[183063, 4517, 44, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[183132, 4521, 472, 10, 177, "Input"],
Cell[183607, 4533, 62, 1, 34, "Print"],
Cell[183672, 4536, 222, 5, 34, "Print"],
Cell[183897, 4543, 266, 5, 34, "Print"],
Cell[184166, 4550, 264, 5, 34, "Print"],
Cell[184433, 4557, 266, 5, 34, "Print"],
Cell[184702, 4564, 264, 5, 34, "Print"],
Cell[184969, 4571, 224, 5, 34, "Print"],
Cell[185196, 4578, 244, 5, 34, "Print"],
Cell[185443, 4585, 244, 5, 34, "Print"],
Cell[185690, 4592, 42095, 1506, 256, 25557, 1297, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[227822, 6103, 58, 1, 32, "Input"],
Cell[227883, 6106, 62, 1, 34, "Print"],
Cell[227948, 6109, 242, 5, 34, "Print"],
Cell[228193, 6116, 264, 5, 34, "Print"],
Cell[228460, 6123, 264, 5, 34, "Print"],
Cell[228727, 6130, 224, 5, 34, "Print"],
Cell[228954, 6137, 30283, 612, 607, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[259274, 6754, 49, 1, 32, "Input"],
Cell[259326, 6757, 52, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[259415, 6763, 65, 1, 32, "Input"],
Cell[259483, 6766, 78, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[259598, 6772, 97, 2, 55, "Input"],
Cell[259698, 6776, 61, 1, 40, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[259808, 6783, 39, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[259872, 6787, 493, 11, 177, "Input"],
Cell[260368, 6800, 62, 1, 34, "Print"],
Cell[260433, 6803, 222, 5, 34, "Print"],
Cell[260658, 6810, 266, 5, 34, "Print"],
Cell[260927, 6817, 266, 5, 34, "Print"],
Cell[261196, 6824, 264, 5, 34, "Print"],
Cell[261463, 6831, 264, 5, 34, "Print"],
Cell[261730, 6838, 224, 5, 34, "Print"],
Cell[261957, 6845, 244, 5, 34, "Print"],
Cell[262204, 6852, 244, 5, 34, "Print"],
Cell[262451, 6859, 42301, 1581, 256, 26399, 1380, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[304789, 8445, 58, 1, 32, "Input"],
Cell[304850, 8448, 62, 1, 34, "Print"],
Cell[304915, 8451, 242, 5, 34, "Print"],
Cell[305160, 8458, 264, 5, 34, "Print"],
Cell[305427, 8465, 264, 5, 34, "Print"],
Cell[305694, 8472, 224, 5, 34, "Print"],
Cell[305921, 8479, 29168, 590, 628, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[335126, 9074, 49, 1, 32, "Input"],
Cell[335178, 9077, 52, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[335267, 9083, 65, 1, 32, "Input"],
Cell[335335, 9086, 79, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[335451, 9092, 97, 2, 55, "Input"],
Cell[335551, 9096, 61, 1, 40, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[335661, 9103, 29, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[335715, 9107, 477, 10, 177, "Input"],
Cell[336195, 9119, 62, 1, 34, "Print"],
Cell[336260, 9122, 222, 5, 34, "Print"],
Cell[336485, 9129, 266, 5, 34, "Print"],
Cell[336754, 9136, 264, 5, 34, "Print"],
Cell[337021, 9143, 266, 5, 34, "Print"],
Cell[337290, 9150, 264, 5, 34, "Print"],
Cell[337557, 9157, 224, 5, 34, "Print"],
Cell[337784, 9164, 244, 5, 34, "Print"],
Cell[338031, 9171, 244, 5, 34, "Print"],
Cell[338278, 9178, 44042, 1530, 293, 25566, 1297, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[382357, 10713, 58, 1, 32, "Input"],
Cell[382418, 10716, 62, 1, 34, "Print"],
Cell[382483, 10719, 242, 5, 34, "Print"],
Cell[382728, 10726, 264, 5, 34, "Print"],
Cell[382995, 10733, 264, 5, 34, "Print"],
Cell[383262, 10740, 224, 5, 34, "Print"],
Cell[383489, 10747, 30283, 612, 607, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[413809, 11364, 49, 1, 32, "Input"],
Cell[413861, 11367, 52, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[413950, 11373, 65, 1, 32, "Input"],
Cell[414018, 11376, 79, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[414134, 11382, 97, 2, 55, "Input"],
Cell[414234, 11386, 61, 1, 40, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[414344, 11393, 66, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[414435, 11397, 518, 11, 177, "Input"],
Cell[414956, 11410, 62, 1, 34, "Print"],
Cell[415021, 11413, 222, 5, 34, "Print"],
Cell[415246, 11420, 266, 5, 34, "Print"],
Cell[415515, 11427, 266, 5, 34, "Print"],
Cell[415784, 11434, 266, 5, 34, "Print"],
Cell[416053, 11441, 266, 5, 34, "Print"],
Cell[416322, 11448, 266, 5, 34, "Print"],
Cell[416591, 11455, 266, 5, 34, "Print"],
Cell[416860, 11462, 266, 5, 34, "Print"],
Cell[417129, 11469, 266, 5, 34, "Print"],
Cell[417398, 11476, 266, 5, 34, "Print"],
Cell[417667, 11483, 268, 5, 34, "Print"],
Cell[417938, 11490, 268, 5, 34, "Print"],
Cell[418209, 11497, 268, 5, 34, "Print"],
Cell[418480, 11504, 226, 5, 34, "Print"],
Cell[418709, 11511, 246, 5, 34, "Print"],
Cell[418958, 11518, 246, 5, 34, "Print"],
Cell[419207, 11525, 246, 5, 34, "Print"],
Cell[419456, 11532, 361465, 15216, 457, 273168, 14120, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[780970, 26754, 68, 0, 111, "Section"],
Cell[781041, 26756, 563, 12, 177, "Input",
  Evaluatable->False]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

