(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    295980,       8577]*)
(*NotebookOutlinePosition[    334634,       9894]*)
(*  CellTagsIndexPosition[    334324,       9883]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Off[General::spell];
Off[General::spell1];\
\>", "Input",
  PageBreakAbove->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Load FeynCalc:", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(<< HighEnergyPhysics`fc`\)], "Input"],

Cell[TextData[{
  StyleBox["FeynCalc",
    FontWeight->"Bold"],
  " ",
  "4.1.0.3b",
  "    ",
  " Evaluate ?FeynCalc for help or visit ",
  ButtonBox["www.feyncalc.org",
    ButtonData:>{
      URL[ "http://www.feyncalc.org"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"http://www.feyncalc.org"]
}], "Text",
  GeneratedCell->True,
  CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check with Halzen & Martin", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["{p1s,p2s,p3s,p4s}=Map[DiracSlash,{p1,p2,p3,p4}]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p1",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p2",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p3",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p4",
              "TraditionalForm"]}]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
{gm,gn,gm1,gm2}=Map[DiracMatrix,{\[Mu],\[Nu],\[Rho],\[Sigma]}]\
\>",\
 "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["tr[ gm.p1s.gn.p2s ]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        RowBox[{
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ".", 
          RowBox[{"(", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["p1",
                "TraditionalForm"]}], ")"}], ".", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], ".", 
          RowBox[{"(", 
            RowBox[{
              FormBox["\<\"\[Gamma]\"\>",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["p2",
                "TraditionalForm"]}], ")"}]}], ")"}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tr[ gm.p1s.gn.p2s ]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["p2",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p1",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["p1",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p2",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{\(g\^\(\[Mu]\[NoBreak]\[Nu]\)\), " ", 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p2",
                  "TraditionalForm"]}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["tr[ DiracGamma[5].gm.gn.gm1.gm2 ]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"tr", "(", 
        RowBox[{\(\[Gamma]\^5\), ".", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ".", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], ".", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"]], ".", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]]}], ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tr[ DiracGamma[5].gm.gn.gm1.gm2 ]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(-4\), " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Other stuff from Halzen & Martin:", "Subsection",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[CellGroupData[{

Cell["\<\
4 Tr[ gm.DiracGamma[7].p1s.gn.DiracGamma[7].p2s ] - 2Tr[ \
gm.p1s.gn.p2s ] //Expand\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox["p1",
              "TraditionalForm"], "\[NoBreak]", 
            FormBox["p2",
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Contract[ Tr[ gm.p1s.gn.p2s ] Tr[ gm.p3s.gn.p4s ] ]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"32", " ", 
          RowBox[{
            FormBox["p1",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p4",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["p2",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p3",
              "TraditionalForm"]}]}], "+", 
        RowBox[{"32", " ", 
          RowBox[{
            FormBox["p1",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p3",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["p2",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p4",
              "TraditionalForm"]}]}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Contract[ Tr[ gm.p1s.gn.DiracGamma[5].p2s ] Tr[ \
gm.p3s.gn.DiracGamma[5].p4s ] ] //Simplify\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"32", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]}], "-", 
            RowBox[{
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Contract[ 4 Tr[ gm.DiracGamma[7].p1s.gn.DiracGamma[7].p2s ] 
        * 4 Tr[ gm.DiracGamma[7].p3s.gn.DiracGamma[7].p4s ] 
   ] //Contract\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"256", " ", 
        RowBox[{
          FormBox["p1",
            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
          FormBox["p3",
            "TraditionalForm"]}], " ", 
        RowBox[{
          FormBox["p2",
            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
          FormBox["p4",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tr[ Spinor[p,m].Spinor[p,m] ] //DiracSimplify", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{
          RowBox[{"\[CurlyPhi]", "\[NoBreak]", "(", "\[NoBreak]", 
            FormBox["p",
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", "m", 
            "\[NoBreak]", ")"}], ".", 
          RowBox[{"\[CurlyPhi]", "\[NoBreak]", "(", "\[NoBreak]", 
            FormBox["p",
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", "m", 
            "\[NoBreak]", ")"}]}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tr[ DiracGamma[5].gm.gn.gm1.gm2 ]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(-4\), " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tr[DiracMatrix[a1,a2,a3,a4,5]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(-4\), " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["\[Epsilon]", 
          RowBox[{
            FormBox[
              FormBox["a1",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["a2",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["a3",
                "TraditionalForm"],
              "TraditionalForm"], "\[NoBreak]", 
            FormBox[
              FormBox["a4",
                "TraditionalForm"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tr[DiracMatrix[a1,a2,a3,a4,a5,a6,5]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{\(-\[ImaginaryI]\), " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a1\[NoBreak]a2\)\)}], 
            "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a1\[NoBreak]a3\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a1\[NoBreak]a4\)\)}], 
            "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a1\[NoBreak]a5\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a1\[NoBreak]a6\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a2\[NoBreak]a3\)\)}], 
            "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a2\[NoBreak]a4\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a2\[NoBreak]a5\)\)}], 
            "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a2\[NoBreak]a6\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a3\[NoBreak]a4\)\)}], 
            "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a3\[NoBreak]a5\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a3\[NoBreak]a6\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a6",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a4\[NoBreak]a5\)\)}], 
            "+", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a5",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a4\[NoBreak]a6\)\)}], 
            "-", 
            RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["\[Epsilon]", 
                RowBox[{
                  FormBox[
                    FormBox["a1",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a2",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a3",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["a4",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", \(g\^\(a5\[NoBreak]a6\)\)}]}],
           ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
(tmp= Tr[DiracMatrix[a1,a2,a3,a4,a5,a6,a7,a8,5]]) //Timing \
//First\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`4.17`\ Second\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["tmp //Last //Length", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(TraditionalForm\`28\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Do Traces from Ch6 Halzen & Martin", "Subsubsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
temp1= Tr[ (DiracSlash[kp]+m)
          .DiracMatrix[\[Mu]]
          .(DiracSlash[k ]+m)
          .DiracMatrix[\[Nu]]
        ]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{\(g\^\(\[Mu]\[NoBreak]\[Nu]\)\ m\^2\), "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["kp",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["k",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["k",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["kp",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{\(g\^\(\[Mu]\[NoBreak]\[Nu]\)\), " ", 
              RowBox[{
                FormBox["k",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["kp",
                  "TraditionalForm"]}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
temp2= Tr[ (DiracSlash[pp]+m)
          .DiracMatrix[\[Mu]]
          .(DiracSlash[p ]+m)
          .DiracMatrix[\[Nu]]
        ]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"4", " ", 
        RowBox[{"(", 
          RowBox[{\(g\^\(\[Mu]\[NoBreak]\[Nu]\)\ m\^2\), "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["pp",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["pp",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{\(g\^\(\[Mu]\[NoBreak]\[Nu]\)\), " ", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["pp",
                  "TraditionalForm"]}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["temp3= temp1 temp2 //Contract", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(64\ m\^4\), "-", 
        RowBox[{"32", " ", 
          RowBox[{
            FormBox["k",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["kp",
              "TraditionalForm"]}], " ", \(m\^2\)}], "-", 
        RowBox[{"32", " ", 
          RowBox[{
            FormBox["p",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["pp",
              "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
        RowBox[{"32", " ", 
          RowBox[{
            FormBox["k",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["pp",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["kp",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p",
              "TraditionalForm"]}]}], "+", 
        RowBox[{"32", " ", 
          RowBox[{
            FormBox["k",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p",
              "TraditionalForm"]}], " ", 
          RowBox[{
            FormBox["kp",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["pp",
              "TraditionalForm"]}]}]}], TraditionalForm]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examine Mandelstam Variables", "Subsubsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetMandelstam[s, t, u, p, k, \(-pp\), \(-kp\), m, m, m, m]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\^2\), \(m\^2 - t\/2\), \(s\/2 - m\^2\), \(m\^2 - 
                u\/2\), \(m\^2\), \(m\^2 - u\/2\), \(s\/2 - 
                m\^2\), \(m\^2\), \(m\^2 - 
                t\/2\), \(m\^2\), \(m\^2\), \(m\^2 - t\/2\), \(s\/2 - 
                m\^2\), \(m\^2 - u\/2\), \(m\^2\), \(m\^2 - u\/2\), \(s\/2 - 
                m\^2\), \(m\^2\), \(m\^2 - t\/2\), \(m\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\({\[IndentingNewLine]ScalarProduct[p + k, 
              p + k], \[IndentingNewLine]ScalarProduct[p - pp, 
              p - pp], \[IndentingNewLine]ScalarProduct[p - kp, p - kp]} // 
          ExpandScalarProduct\) // Simplify)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{s, t, u}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(temp3 // Simplify\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`8\ \((8\ m\^4 - 4\ \((s - t + u)\)\ m\^2 + s\^2 + 
          u\^2)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(temp4 = temp3 /. {m \[Rule] 0} // Simplify\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`8\ \((s\^2 + u\^2)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(denom = \((ScalarProduct[k - kp, k - kp])\)^2 // 
        ExpandScalarProduct\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`t\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(result = temp4/denom\ e^4/4\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(2\ e\^4\ \((s\^2 + u\^2)\)\)\/t\^2\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check with Drell-Yan Born", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["{p1s,p2s,p3s,p4s}=Map[DiracSlash,{p1,p2,p3,p4}]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p1",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p2",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p3",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p4",
              "TraditionalForm"]}]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
{gm,gn,gm1,gm2}=Map[DiracMatrix,{\[Mu],\[Nu],\[Rho],\[Sigma]}]\
\>",\
 "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(tr[p2s . gm . p1s . gn]\)\(\ \)\(tr[
        p3s . gm . p4s . gn]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"tr", "(", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p2",
                  "TraditionalForm"]}], ")"}], ".", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], ".", 
            RowBox[{"(", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p1",
                  "TraditionalForm"]}], ")"}], ".", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], ")"}], " ", 
        RowBox[{"tr", "(", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], ")"}], ".", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], ".", 
            RowBox[{"(", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], ")"}], ".", 
            SuperscriptBox["\[Gamma]", 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat = 
      Tr[p2s . gm . p1s . gn]\ Tr[p3s . gm . p4s . gn]\ /
            ScalarProduct[p1 + p2]^2 // Contract\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"32", " ", 
            RowBox[{
              FormBox["p1",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["p4",
                "TraditionalForm"]}], " ", 
            RowBox[{
              FormBox["p2",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["p3",
                "TraditionalForm"]}]}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  FormBox["p1",
                    "TraditionalForm"], "2"], "+", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["p1",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p2",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["p2",
                    "TraditionalForm"], "2"]}], ")"}], "2"]], "+", 
        FractionBox[
          RowBox[{"32", " ", 
            RowBox[{
              FormBox["p1",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["p3",
                "TraditionalForm"]}], " ", 
            RowBox[{
              FormBox["p2",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["p4",
                "TraditionalForm"]}]}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  FormBox["p1",
                    "TraditionalForm"], "2"], "+", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["p1",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p2",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["p2",
                    "TraditionalForm"], "2"]}], ")"}], "2"]]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SetMandelstam\)\)], "Input"],

Cell[BoxData[
    \("SetMandelstam[s, t, u, p1, p2, p3, p4, m1, m2, m3, m4] defines the \
Mandelstam variables  s=(p1+p2)^2, t=(p1+p3)^2, u=(p1+p4)^2 and sets the pi \
on-shell: p1^2=m1^2, p2^2=m2^2, p3^2=m3^2, p4^2=m4^2. Note that p1 +  p2 + p3 \
+ p4 = 0 is assumed. \n SetMandelstam[x, {p1, p2, p3, p4, p5}, {m1, m2, m3, \
m4, m5}] defines x[i, j] = (pi+pj)^2 and sets the pi on-shell. The pi \
satisfy: p1 + p2 + p3 + p4 + p5 = 0."\)], "Print",
  CellTags->"Info3262845160-6867593"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetMandelstam[s, t, u, p1, p2, p3, p4, 0, 0, 0, 0]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{0, s\/2, t\/2, u\/2, 0, u\/2, t\/2, 0, s\/2, 0, 0, 
      s\/2, t\/2, u\/2, 0, u\/2, t\/2, 0, s\/2, 0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat\  // Simplify\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(8\ \((t\^2 + u\^2)\)\)\/s\^2\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(ClearScalarProducts\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "CALCULATION:  ",
  Cell[BoxData[
      \(TraditionalForm\`u  u\&_\  \[RightArrow] \ \ g\ \[Gamma]\)]]
}], "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 -1.40675e-17 0.0227273 [
[ 0 0 0 0 ]
[ 1 .65 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65 L
0 .65 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -1.40675e-17 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.5 .31818 L
s
.24559 .29274 m
.30167 .28008 L
.29806 .31626 L
F
gsave
.27974 .25284 -67.5625 -19.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
72.125 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50513 .68698 L
.51114 .69114 L
.51785 .69411 L
.52499 .69573 L
.53232 .69594 L
.53955 .69473 L
.54641 .69217 L
.55266 .68842 L
.55808 .68368 L
.56249 .6782 L
.56577 .6723 L
.56785 .66628 L
.56875 .66047 L
.56851 .65519 L
.56727 .65073 L
.5652 .64733 L
.56251 .64518 L
.55946 .6444 L
.55631 .64505 L
.55334 .6471 L
.55081 .65045 L
.54897 .65495 L
.54802 .66036 L
.54812 .66642 L
.54938 .67282 L
.55183 .67922 L
.55547 .68532 L
.5602 .6908 L
.56589 .69538 L
.57235 .69883 L
.57936 .70099 L
.58665 .70176 L
.59395 .70109 L
.60099 .69905 L
.6075 .69575 L
.61327 .69136 L
.61809 .68614 L
.62182 .68036 L
.62437 .67435 L
.62573 .66842 L
.62592 .6629 L
.62506 .65809 L
.62329 .65425 L
.62081 .65159 L
.61787 .65026 L
.61472 .65035 L
.61165 .65186 L
.60892 .65473 L
.60678 .6588 L
Mistroke
.60546 .66389 L
.60514 .66973 L
.60594 .67603 L
.60792 .68247 L
.6111 .68872 L
.61542 .69448 L
.62076 .69944 L
.62695 .70336 L
.63377 .70604 L
.64098 .70736 L
.64831 .70725 L
.65548 .70573 L
.66223 .7029 L
.66831 .69891 L
.67352 .69399 L
.67769 .68839 L
.68071 .68243 L
.68253 .67643 L
.68317 .67071 L
.68271 .66559 L
.68126 .66134 L
.67904 .6582 L
.67624 .65634 L
.67315 .65587 L
.67001 .65683 L
.66712 .65918 L
.66472 .6628 L
.66306 .66752 L
.66233 .6731 L
.66268 .67926 L
.6642 .68568 L
.66691 .69205 L
.6708 .69803 L
.67575 .70334 L
.68163 .70769 L
.68824 .71087 L
.69532 .71273 L
.70264 .71318 L
.70991 .71221 L
.71685 .70988 L
.72322 .70632 L
.72879 .70173 L
.73338 .69636 L
.73686 .6905 L
.73915 .68448 L
.74025 .67861 L
.7402 .67322 L
.73912 .6686 L
.73718 .665 L
.73458 .66263 L
Mistroke
.73157 .66161 L
.72841 .66201 L
.72539 .66382 L
.72277 .66697 L
.7208 .67128 L
.71969 .67655 L
.7196 .68252 L
.72065 .68888 L
.7229 .69531 L
.72634 .70148 L
.73089 .70708 L
.73643 .71184 L
.74278 .7155 L
.74971 .71789 L
.75697 .7189 L
.76428 .71848 L
.77139 .71666 L
.77801 .71356 L
.78392 .70935 L
.78891 .70425 L
.79283 .69855 L
.79559 .69255 L
.79716 .68658 L
.79754 .68097 L
.79685 .67601 L
.79522 .67199 L
.79285 .66912 L
.78997 .66755 L
.78684 .6674 L
.78373 .66867 L
.78093 .67131 L
.77867 .67519 L
.7772 .68011 L
.7767 .68585 L
.77729 .69209 L
.77907 .69853 L
.78205 .70484 L
.78618 .7107 L
.79136 .71581 L
.79741 .71993 L
.80414 .72283 L
.8113 .72439 L
.81863 .72453 L
.82585 .72325 L
.83269 .72063 L
.8389 .71683 L
.84427 .71204 L
.84863 .70654 L
.85185 .70062 L
.85388 .6946 L
Mistroke
.85472 .68881 L
.85443 .68357 L
.85315 .67915 L
.85104 .6758 L
.84833 .67371 L
.84526 .673 L
.84212 .67372 L
.83916 .67583 L
.83666 .67925 L
.83486 .68379 L
.83396 .68924 L
.83412 .69532 L
.83543 .70172 L
.83794 .70812 L
.84163 .7142 L
.84641 .71964 L
.85215 .72417 L
.85864 .72756 L
.86567 .72966 L
.87296 .73035 L
.88025 .72962 L
.88727 .72752 L
.89376 .72415 L
.89948 .71972 L
.90425 .71447 L
.90793 .70867 L
.91042 .70265 L
.91172 .69674 L
.91187 .69124 L
.91095 .68647 L
.90914 .68268 L
.90664 .68008 L
.90368 .67882 L
.90053 .67898 L
.89747 .68056 L
.89476 .68348 L
.89266 .68761 L
.89139 .69273 L
.89111 .6986 L
.89197 .70492 L
.89401 .71136 L
.89725 .71759 L
.90162 .72332 L
.907 .72823 L
.91322 .73209 L
.92007 .73471 L
.92729 .73596 L
.93462 .73579 L
.94178 .7342 L
.9485 .73131 L
Mistroke
.95455 .72727 L
Mfstroke
gsave
.72026 .74716 -67.5625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.50416 .3139 L
.50837 .31007 L
.51267 .3071 L
.51708 .30527 L
.52161 .30476 L
.52629 .30556 L
.53107 .30754 L
.53595 .3104 L
.54087 .31375 L
.5458 .31714 L
.55069 .32011 L
.5555 .32227 L
.56019 .3233 L
.56476 .32303 L
.56919 .32143 L
.5735 .31864 L
.57772 .31495 L
.58189 .31072 L
.58605 .30642 L
.59025 .30249 L
.59453 .29935 L
.59891 .29731 L
.60343 .29657 L
.60808 .29714 L
.61285 .29892 L
.61771 .30162 L
.62262 .30488 L
.62755 .30825 L
.63244 .31126 L
.63726 .31351 L
.64197 .31468 L
.64655 .31457 L
.651 .31315 L
.65533 .31056 L
.65957 .30709 L
.66377 .30314 L
.66797 .2992 L
.67221 .29578 L
.67656 .29332 L
.68103 .29214 L
.68564 .2923 L
.69035 .29354 L
.69512 .29529 L
.69986 .29678 L
.70452 .2975 L
.70911 .29744 L
.71365 .29697 L
.71819 .29643 L
.72273 .29594 L
Mistroke
.72728 .29548 L
.73182 .29503 L
.73637 .29461 L
.74092 .29425 L
.74547 .2938 L
.74998 .29295 L
.7544 .29132 L
.75876 .28892 L
.76308 .28627 L
.76746 .28411 L
.77194 .28305 L
.77656 .28332 L
.7813 .28487 L
.78615 .28738 L
.79104 .29041 L
.79594 .29345 L
.80078 .29602 L
.80554 .2977 L
.81019 .29821 L
.8147 .29741 L
.81908 .29533 L
.82335 .29217 L
.82755 .28825 L
.83172 .28397 L
.83589 .27981 L
.84012 .27619 L
.84444 .27351 L
.84888 .27202 L
.85346 .27186 L
.85816 .27299 L
.86298 .27522 L
.86787 .27824 L
.8728 .28163 L
.87772 .28495 L
.88259 .28773 L
.88737 .28961 L
.89203 .2903 L
.89656 .28966 L
.90096 .28772 L
.90524 .28466 L
.90944 .28077 L
.9136 .27647 L
.91777 .27221 L
.92198 .26845 L
.92628 .26556 L
.9307 .26385 L
.93525 .26345 L
.93993 .26437 L
.94473 .26644 L
.94962 .26936 L
Mistroke
.95455 .27273 L
Mfstroke
.70014 .29817 m
.75622 .31083 L
.7526 .27465 L
F
gsave
.73428 .33807 -70.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
78.500 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.45704 .5 -74.125 -10.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N1) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -1.40675e-17 1 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.5 .31818 L
s
.24559 .29274 m
.30167 .28008 L
.29806 .31626 L
F
gsave
.27974 .25284 -67.5625 -19.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
72.125 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.5011 .3251 L
.50337 .33178 L
.50679 .33799 L
.51125 .34349 L
.51664 .34811 L
.52276 .35167 L
.52941 .3541 L
.53635 .35534 L
.54332 .35539 L
.55008 .35433 L
.55638 .35226 L
.562 .34937 L
.56675 .34584 L
.57047 .34191 L
.57308 .33783 L
.57452 .33387 L
.5748 .33027 L
.57398 .32727 L
.57217 .32509 L
.56953 .32388 L
.56627 .32378 L
.56261 .32485 L
.55879 .32712 L
.55507 .33054 L
.55171 .33502 L
.54892 .34041 L
.54693 .34654 L
.54589 .35317 L
.54593 .36007 L
.54713 .36697 L
.5495 .37363 L
.553 .37978 L
.55754 .38522 L
.563 .38976 L
.56917 .39324 L
.57585 .39557 L
.58281 .3967 L
.58977 .39667 L
.5965 .39552 L
.60276 .39338 L
.60831 .39042 L
.61298 .38685 L
.61662 .3829 L
.61913 .37882 L
.62047 .37488 L
.62066 .37132 L
.61975 .36839 L
.61787 .36627 L
.61518 .36515 L
Mistroke
.61187 .36514 L
.60819 .36631 L
.60437 .36867 L
.60067 .37218 L
.59735 .37674 L
.59462 .3822 L
.5927 .38838 L
.59174 .39504 L
.59188 .40195 L
.59317 .40884 L
.59563 .41547 L
.59922 .42157 L
.60385 .42695 L
.60936 .4314 L
.61559 .43479 L
.6223 .43702 L
.62926 .43806 L
.63622 .43793 L
.64292 .4367 L
.64913 .43449 L
.65461 .43147 L
.6592 .42786 L
.66276 .42389 L
.66518 .41981 L
.66642 .41589 L
.66652 .41238 L
.66553 .4095 L
.66357 .40746 L
.66082 .40643 L
.65748 .40651 L
.65377 .40778 L
.64996 .41023 L
.64628 .41383 L
.64299 .41847 L
.64033 .424 L
.63848 .43022 L
.63761 .43691 L
.63783 .44383 L
.63922 .45071 L
.64177 .4573 L
.64545 .46336 L
.65016 .46866 L
.65574 .47303 L
.66201 .47633 L
.66875 .47847 L
.67573 .47941 L
.68267 .47919 L
.68934 .47787 L
.69549 .47558 L
.70092 .47251 L
Mistroke
.70543 .46886 L
.70889 .46487 L
.71121 .4608 L
.71237 .4569 L
.71237 .45343 L
.7113 .45061 L
.70927 .44865 L
.70647 .4477 L
.70308 .44788 L
.69936 .44924 L
.69555 .4518 L
.69189 .45548 L
.68865 .4602 L
.68604 .46579 L
.68426 .47206 L
.68348 .47878 L
.6838 .4857 L
.68528 .49257 L
.68793 .49913 L
.69169 .50513 L
.69647 .51036 L
.70212 .51465 L
.70844 .51786 L
.71521 .5199 L
.72219 .52075 L
.72912 .52043 L
.73576 .51903 L
.74186 .51667 L
.74721 .51355 L
.75165 .50986 L
.75502 .50586 L
.75725 .50179 L
.75831 .49791 L
.75822 .49449 L
.75707 .49173 L
.75497 .48985 L
.75211 .48899 L
.74869 .48926 L
.74495 .49072 L
.74114 .49336 L
.73751 .49714 L
.73431 .50193 L
.73176 .50759 L
.73006 .5139 L
.72936 .52065 L
.72977 .52757 L
.73135 .53443 L
.73409 .54095 L
.73794 .54689 L
.7428 .55206 L
Mistroke
.74851 .55626 L
.75487 .55938 L
.76167 .56132 L
.76866 .56208 L
.77557 .56167 L
.78218 .56018 L
.78822 .55776 L
.79351 .55457 L
.79786 .55085 L
.80114 .54683 L
.80328 .54277 L
.80424 .53893 L
.80407 .53554 L
.80283 .53285 L
.80067 .53104 L
.79775 .53027 L
.7943 .53064 L
.79054 .5322 L
.78674 .53494 L
.78313 .5388 L
.77998 .54367 L
.77749 .54938 L
.77587 .55574 L
.77526 .56251 L
.77576 .56944 L
.77743 .57628 L
.78027 .58276 L
.7842 .58865 L
.78914 .59374 L
.79491 .59786 L
.80131 .60089 L
.80814 .60274 L
.81513 .60339 L
.82203 .60289 L
.82859 .60132 L
.83459 .59883 L
.8398 .5956 L
.84407 .59184 L
.84726 .58781 L
.8493 .58375 L
.85017 .57994 L
.84991 .5766 L
.84859 .57397 L
.84636 .57225 L
.84339 .57156 L
.8399 .57202 L
.83614 .57368 L
.83234 .57651 L
.82876 .58046 L
.82565 .58541 L
Mistroke
.82323 .59118 L
.82168 .59758 L
.82116 .60437 L
.82176 .61131 L
.82352 .61812 L
.82645 .62456 L
.83047 .6304 L
.83548 .63542 L
.84131 .63945 L
.84776 .64238 L
.85461 .64414 L
.8616 .6447 L
.86848 .6441 L
.87501 .64246 L
.88095 .6399 L
.88609 .63661 L
.89028 .63282 L
.89338 .62878 L
.89532 .62473 L
.8961 .62095 L
.89574 .61766 L
.89435 .6151 L
.89205 .61345 L
.88903 .61286 L
.88551 .61342 L
.88173 .61517 L
.87794 .61809 L
.8744 .62213 L
.87134 .62715 L
.86898 .63298 L
.86751 .63942 L
.86707 .64623 L
.86776 .65317 L
.86963 .65996 L
.87264 .66636 L
.87675 .67214 L
.88183 .67708 L
.88772 .68103 L
.89421 .68387 L
.90108 .68553 L
.90807 .68599 L
.91493 .68531 L
.92142 .68358 L
.9273 .68095 L
.93238 .67762 L
.93648 .6738 L
.93949 .66975 L
.94134 .66571 L
.94202 .66196 L
.94158 .65872 L
Mistroke
.9401 .65623 L
.93774 .65466 L
.93467 .65416 L
.93112 .65481 L
.92733 .65666 L
.92355 .65968 L
.92004 .6638 L
.91703 .66889 L
.91473 .67478 L
.91334 .68126 L
.913 .68809 L
.91378 .69502 L
.91574 .7018 L
.91885 .70815 L
.92304 .71387 L
.92819 .71874 L
.93414 .7226 L
.94067 .72535 L
.94755 .7269 L
.95455 .72727 L
Mfstroke
gsave
.81534 .64005 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50078 .67586 L
.50187 .67025 L
.50357 .66531 L
.50608 .66128 L
.5095 .65826 L
.51384 .65626 L
.51898 .65514 L
.5247 .65468 L
.53072 .65455 L
.53671 .65439 L
.54237 .65386 L
.54741 .65264 L
.55163 .65051 L
.55493 .64735 L
.55732 .64318 L
.55892 .63814 L
.55996 .63247 L
.56072 .62649 L
.56152 .62055 L
.56268 .61502 L
.56448 .6102 L
.5671 .60629 L
.57065 .60341 L
.57511 .60154 L
.58033 .60053 L
.58611 .60012 L
.59214 .60001 L
.59811 .59982 L
.6037 .5992 L
.60863 .59787 L
.61273 .5956 L
.6159 .5923 L
.61818 .58801 L
.6197 .58287 L
.62068 .57714 L
.62143 .57116 L
.62228 .56527 L
.62352 .55983 L
.62543 .55512 L
.62818 .55136 L
.63186 .54863 L
.63643 .54688 L
.64173 .54595 L
.64754 .54559 L
.65355 .54544 L
.65944 .54517 L
.6649 .54441 L
.66967 .54289 L
.67358 .54042 L
Mistroke
.67659 .53693 L
.67874 .53249 L
.68021 .52731 L
.68127 .52167 L
.68226 .51595 L
.68354 .51055 L
.68544 .50584 L
.6882 .50208 L
.69189 .49936 L
.69636 .4975 L
.70121 .49607 L
.70593 .49449 L
.71014 .49234 L
.71382 .48961 L
.71721 .48656 L
.72055 .48344 L
.72392 .48037 L
.72731 .47731 L
.7307 .47426 L
.73412 .47123 L
.73757 .46824 L
.74096 .46519 L
.74406 .46182 L
.74664 .45786 L
.7487 .45333 L
.75063 .44866 L
.75295 .4444 L
.75604 .44102 L
.76007 .43867 L
.76496 .43728 L
.77046 .43657 L
.77625 .43618 L
.78197 .43572 L
.78728 .4348 L
.79192 .43313 L
.7957 .43051 L
.79857 .42687 L
.80058 .42229 L
.80191 .41694 L
.80281 .41112 L
.80358 .40515 L
.80455 .39942 L
.80603 .39424 L
.80825 .38988 L
.81136 .38651 L
.81539 .38416 L
.82026 .38276 L
.8258 .38209 L
.83175 .38187 L
.83778 .38176 L
Mistroke
.84358 .38138 L
.84885 .38041 L
.85336 .37859 L
.85697 .37578 L
.85965 .37195 L
.8615 .36718 L
.8627 .36169 L
.86351 .35577 L
.86426 .34979 L
.86527 .34408 L
.86683 .33899 L
.86916 .33476 L
.87239 .33153 L
.87655 .32933 L
.88154 .32805 L
.88716 .32748 L
.89315 .3273 L
.89917 .32718 L
.90492 .32674 L
.91011 .32568 L
.9145 .32374 L
.91799 .32079 L
.92055 .31681 L
.92229 .31193 L
.92342 .30636 L
.9242 .30041 L
.92497 .29444 L
.92603 .2888 L
.92767 .28381 L
.93012 .2797 L
.93348 .27661 L
.93776 .27455 L
.94285 .27338 L
.94854 .27287 L
.95455 .27273 L
Mfstroke
.707 .49552 m
.75971 .47254 L
.73538 .44551 L
F
gsave
.84375 .41277 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
78.500 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.46158 .5 -74.125 -11.6562 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.3125 translate 1 -1 scale
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
72.125 16.750 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N2) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 .59 -68.4688 -12.8438 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 25.6875 translate 1 -1 scale
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
73.938 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59 -71.0938 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.312 moveto
(\\256) show
79.188 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 .59 -68.4688 -12.4688 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.9375 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 .59 -72.3125 -12.8438 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 25.6875 translate 1 -1 scale
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
81.625 19.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.625, 171.25},
  ImageMargins->{{56.875, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006;000102000`400?l00000o`00003oo`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<0?ooo`00o`3ooon<
0?ooo`00o`3ooon<0?ooo`00]@3oool600000=00oooo00090?ooo`D00000V03oool4000000/0oooo
00<000000?ooo`3oool00`3oool200000140oooo1@00002[0?ooo`@000002@3oool000h0oooo2P00
002=0?ooo`030000003oool0oooo0080oooo0P0000080?ooo`030000003oool0oooo01`0oooo2P00
002O0?ooo`8000003@3oool001P0oooo2P00001`0?ooo`<000000`3oool2000000X0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02L0oooo2P00002E
0?ooo`030000003oool0oooo00`0oooo000R0?ooo`X000002P3oool5000005@0oooo1P0000000`3o
ool00000000000020?ooo`8000001`3oool2000000P0oooo0P0000020?ooo`800000=03oool:0000
00X0oooo1@00001k0?ooo`030000003oool0oooo00d0oooo000/0?ooo`l00000BP3oool4000000@0
oooo2@0000060?ooo`800000103oool00`000000oooo0?ooo`0:0?ooo`800000@03oool?000007/0
oooo00<000000?ooo`3oool03@3oool003<0oooo3@00000f0?ooo`<000002`3oool00`000000oooo
0?ooo`020?ooo``00000203oool5000005D0oooo3P00001f0?ooo`030000003oool0oooo00d0oooo
000e0?ooo`H000001@3oool:000002X0oooo0P0000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0203oool7000006@0oooo1`0000050?ooo`X00000K03oool00`000000oooo0?oo
o`0=0?ooo`00=`3oool4000000l0oooo2P00000=0?ooo`P000002P3oool00`000000oooo0?ooo`04
0?ooo`8000001P3oool00`000000oooo0?ooo`0=0?ooo`<00000IP3oool5000000l0oooo2P00000=
0?ooo`@00000D03oool00`000000oooo0?ooo`0>0?ooo`00>@3oool2000001T0oooo2P0000020?oo
o`H000000`3oool2000000L0oooo00<000000?ooo`3oool01`3oool200000080oooo0P00001k0?oo
o`<000006@3oool:00000080oooo1P00001?0?ooo`030000003oool0oooo00h0oooo001N0?ooo`P0
00001@3oool00`000000oooo0?ooo`030?ooo`8000002`3oool200000:<0oooo2000001?0?ooo`03
0000003oool0oooo00h0oooo001P0?ooo`H000001P3oool500000;@0oooo1P0000090?ooo`800000
@`3oool00`000000oooo0?ooo`0?0?ooo`00H03oool600000;l0oooo1P0000080?ooo`040000003o
ool00000000003X0oooo2000000B0?ooo`00H@3oool400000<40oooo100000080?ooo`050000003o
ool0oooo0?ooo`000000>@3oool00`000000oooo0?ooo`0H0?ooo`00HP3oool00`000000oooo0?oo
o`320?ooo`800000203oool01@000000oooo0?ooo`3oool0000003T0oooo0P00000J0?ooo`00HP3o
ool00`000000oooo0?ooo`320?ooo`030000003oool0000000L0oooo00D000000?ooo`3oool0oooo
0000000i0?ooo`030000003oool0oooo01T0oooo001R0?ooo`030000003oool0oooo0<80oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`02000003X0oooo00<000000?ooo`3oool0
6@3oool00680oooo00<000000?ooo`3oool0`P3oool010000000oooo0?ooo`3oool300000080oooo
0`00000l0?ooo`030000003oool0oooo01T0oooo001R0?ooo`030000003oool0oooo0<80oooo00<0
00000?ooo`3oool0103oool3000003h0oooo00<000000?ooo`3oool06@3oool00680oooo00<00000
0?ooo`3oool0`P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool06P3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00T0oooo1000000^0?ooo`030000003oool0oooo01X0oooo001R0?ooo`03
0000003oool0oooo0<80oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`05
0000003oool0oooo0?ooo`000000;P3oool00`000000oooo0?ooo`0J0?ooo`00HP3oool00`000000
oooo0?ooo`320?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool06`3oool00680oooo
00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00D000000?ooo`3oool0oooo0000000V0?ooo`P000007P3oool00680oooo00<000000?ooo`3oool0
`P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0P00000V0?ooo`030000003oool0oooo02@0oooo001R0?ooo`030000003oool0oooo0<80oooo00<0
00000?ooo`3oool02P3oool2000000<0oooo0`00000W0?ooo`030000003oool0oooo02D0oooo001R
0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool0303oool4000002T0oooo00<00000
0?ooo`3oool09@3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool09@3oool00680oooo00<000000?ooo`3o
ool0`P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00T0oooo1000000J0?ooo`03
0000003oool0oooo02D0oooo001R0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`0000006P3oool00`000000
oooo0?ooo`0U0?ooo`00HP3oool00`000000oooo0?ooo`320?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool09@3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000J0?ooo`030000
003oool0oooo02H0oooo001R0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000006P3oool2000002P0oooo
001R0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool04`3oool2000000<0oooo00<0
00000?ooo`0000000P00000G0?ooo`@00000:@3oool00680oooo00<000000?ooo`3oool0`P3oool0
0`000000oooo0?ooo`0E0?ooo`D000005@3oool5000002d0oooo001R0?ooo`030000003oool0oooo
0<80oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
02l0oooo001R0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`090?ooo`@000000`3oool010000000oooo0?ooo`00000b0?ooo`00HP3oool00`000000
oooo0?ooo`320?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0203oool200000080
oooo00<000000?ooo`3oool00`0000000`3oool000000?ooo`0a0?ooo`00HP3oool00`000000oooo
0?ooo`320?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00D00000<P3oool00680oooo00<000000?ooo`3oool0`P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo
000000020?ooo`H00000<P3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`L00000
<@3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0L0?ooo`8000000`3o
ool00`000000oooo0000000200000080oooo2000000a0?ooo`00HP3oool00`000000oooo0?ooo`32
0?ooo`030000003oool0oooo01h0oooo1@0000050?ooo`H00000<`3oool00680oooo00<000000?oo
o`3oool0`P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00<0oooo1000000f0?oo
o`00HP3oool200000<<0oooo0P00000R0?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`@0
0000<03oool00640oooo0`0000320?ooo`<000008`3oool00`000000oooo0?ooo`02000000D0oooo
0P0000020?ooo`030000003oool0oooo02h0oooo001Q0?ooo`<00000`P3oool3000002<0oooo0`00
00060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0;P3oool00640oooo10000031
0?ooo`@000008P3oool2000000L0oooo00D000000?ooo`3oool0oooo0000000a0?ooo`00H03oool5
00000<00oooo1@00000Q0?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo
0000000a0?ooo`00H03oool600000;l0oooo1P00000P0?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0000000200000380oooo001P0?ooo`H00000_`3oool600000200oooo00<0
00000?ooo`3oool00P3oool6000003D0oooo001O0?ooo`L00000_P3oool700000200oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0d0?ooo`00HP3oool00`000000oooo0?ooo`320?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?oo
o`<00000:03oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000W0?oo
o`00HP3oool00`000000oooo0?ooo`320?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`0000009`3oool00680
oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0H0?ooo`L000003@3oool00`000000
oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000:03oool00680oooo00<000000?ooo`3o
ool0`P3oool00`000000oooo0?ooo`0F0?ooo`8000005@3oool00`000000oooo0?ooo`040?ooo`05
0000003oool0oooo0?ooo`000000:03oool00680oooo00<000000?ooo`3oool0`P3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`02000002T0oooo001R0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0G0?ooo`L00000:`3oool00680oooo00<000000?ooo`3oool0`P3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0:`3o
ool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool02P3oool2000001l0oooo001R0?ooo`030000003oool0oooo
0<80oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
00P0oooo00@000000?ooo`3oool000007P3oool00680oooo00<000000?ooo`3oool0`P3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool01`3oool01@00
0000oooo0?ooo`3oool0000001h0oooo001R0?ooo`030000003oool0oooo0<80oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00H0oooo00@000000?oo
o`3oool0oooo0P00000N0?ooo`00HP3oool00`000000oooo0?ooo`320?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo
0?ooo`0000007`3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0B0?oo
o`8000008P3oool2000000@0oooo00D000000?ooo`3oool0oooo0000000P0?ooo`00HP3oool00`00
0000oooo0?ooo`320?ooo`030000003oool0oooo00/0oooo2000000U0?ooo`P000008@3oool00680
oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool08P3oool00680oooo00<000000?ooo`3oool0`P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool02P3oool2000001H0oooo
001R0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0a0?ooo`030000003oool0oooo00L0oooo0P0000020?ooo`030000003oool0oooo01<0oooo001R
0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo0000000E0?ooo`00HP3oool0
0`000000oooo0?ooo`320?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04`3oool0
0680oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
0380oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000001H0oooo001R0?oo
o`030000003oool0oooo0<80oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000G0?ooo`00HP3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0e0?ooo`@0000000<0oooo0000000000000P00000H0?ooo`00HP3oool00`000000
oooo0?ooo`080?ooo`030000003oool000000;L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0i0?ooo`8000006`3oool00680oooo00<000000?ooo`3oool01`3oool01@000000oooo
0?ooo`3oool0000000L0oooo1000002[0?ooo`030000003oool0oooo00<0oooo1@00000m0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00680oooo00<000000?ooo`3oool0
1`3oool01@000000oooo0?ooo`3oool0000000H0oooo0P0000020?ooo`030000003oool0oooo00D0
oooo1000002P0?ooo`030000003oool0000000<00000@P3oool00`000000oooo0?ooo`080?ooo`<0
000000<0oooo0000003oool02`3oool00680oooo00<000000?ooo`3oool01`3oool01@000000oooo
0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000070?ooo`040000003oool0oooo
000000P0oooo0P00002F0?ooo`800000A`3oool00`000000oooo0?ooo`070?ooo`050000003oool0
oooo0?ooo`000000303oool00640oooo100000070?ooo`050000003oool0oooo0?ooo`0000001P3o
ool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000070?ooo`04
0000003oool0oooo000000P0oooo0`0000290?ooo`@00000AP3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool00600oooo1P0000060?ooo`04
0000003oool0oooo000000L0oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0
oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`000000
2@3oool2000007d0oooo1P0000160?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0
oooo0000000=0?ooo`00H03oool6000000H0oooo00@000000?ooo`3oool000001`3oool01@000000
oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003oool0
oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000L0oooo00@000000?ooo`000000
0000203oool200000780oooo1P0000170?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3o
ool000003P3oool005h0oooo200000060?ooo`030000003oool0000000T0oooo00<000000?ooo`00
00001`3oool01@000000oooo0?ooo`3oool0000000L0oooo00@000000?ooo`3oool000001`3oool0
1@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000070?ooo`@00000
K`3oool8000004P0oooo0`0000020?ooo`040000003oool00000000000l0oooo001D0?ooo`X00000
0P3oool6000000H0oooo0P00000:0?ooo`030000003oool0000000P0oooo00<000000?ooo`000000
203oool010000000oooo0?ooo`0000070?ooo`050000003oool0oooo0?ooo`0000001P3oool01@00
0000oooo0?ooo`3oool0000000L0oooo00@000000?ooo`3oool00000I@3oool:00000080oooo1P00
001;0?ooo`@000004@3oool00340oooo0`00000F0?ooo`X000003@3oool6000000<0oooo0P000002
0?ooo`030000003oool0oooo00L0oooo0P0000090?ooo`8000002@3oool010000000oooo0?ooo`00
00070?ooo`040000003oool0oooo000000L0oooo00D000000?ooo`3oool0oooo000000060?ooo`05
0000003oool0oooo0?ooo`000000@@3oool4000001H0oooo2P00000=0?ooo`@00000C`3oool00`00
0000oooo0?ooo`0?0?ooo`00<@3oool7000000P0oooo2P00000M0?ooo`<000001@3oool3000000@0
oooo0P0000020?ooo`030000003oool0oooo00H0oooo0P0000090?ooo`030000003oool0000000P0
oooo00@000000?ooo`3oool000001`3oool01@000000oooo0?ooo`3oool0000000H0oooo00D00000
0?ooo`3oool0oooo000000110?ooo`P00000203oool:000006X0oooo00<000000?ooo`3oool03`3o
ool00340oooo3`00000b0?ooo`@000001@3oool00`000000oooo0?ooo`040?ooo`040000003oool0
oooo000000T0oooo00<000000?ooo`3oool0203oool2000000P0oooo00D000000?ooo`3oool0oooo
000000060?ooo`050000003oool0oooo0?ooo`000000@@3oool@000007@0oooo00<000000?ooo`3o
ool03`3oool002`0oooo3@0000130?ooo`H00000103oool00`000000oooo0?ooo`040?ooo`800000
00<0oooo0000003oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0000000L0oooo
00D000000?ooo`3oool0oooo0000000m0?ooo`d00000O03oool00`000000oooo0?ooo`0>0?ooo`00
8P3oool:000000D0oooo1@00001A0?ooo`H00000103oool2000000H0oooo00<000000?ooo`000000
2P3oool00`000000oooo0?ooo`070?ooo`030000003oool0000003@0oooo2P0000040?ooo`H00000
O`3oool00`000000oooo0?ooo`0>0?ooo`00603oool:000000l0oooo0`00001O0?ooo`H000000`3o
ool2000000D0oooo100000090?ooo`800000:`3oool:000000h0oooo0`0000230?ooo`030000003o
ool0oooo00d0oooo000>0?ooo`X00000QP3oool5000000@0oooo0P0000070?ooo`8000008@3oool:
000009l0oooo0`00000<0?ooo`002@3oool5000009/0oooo1`0000020?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool03`3oool500000:`0oooo0`0000090?ooo`00/`3oool900000<l0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0oooo003o0?oooh`0
oooo003o0?oooh`0oooo0000\
\>"],
  ImageRangeCache->{{{0, 394.438}, {255.875, 0}} -> {-0.0440162, \
-0.000143001, 0.167661, 0.167661}, {{0.375, 197.188}, {255.875, 59}} -> \
{-1.04203, -1.0036, 0.167674, 0.167674}, {{197.188, 394}, {255.875, 59}} -> \
{-23.0423, -1.0036, 0.167674, 0.167674}}],

Cell[BoxData[
    \(ClearScalarProducts\)], "Input"],

Cell[CellGroupData[{

Cell["{p1s,p2s,p3s,p4s}=Map[DiracSlash,{p1,p2,p3,p4}]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p1",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p2",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p3",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p4",
              "TraditionalForm"]}]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
{gm,gn,gm1,gm2}=Map[DiracMatrix,{\[Mu],\[Nu],\[Rho],\[Sigma]}]\
\>",\
 "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(amps = {\[IndentingNewLine]p1s . gm . \((p1s - p3s - m)\) . gn . 
            p2s, \[IndentingNewLine]p1s . gn . \((p1s - p4s - m)\) . gm . 
            p2s};\)\), "\[IndentingNewLine]", 
    \(amps\  // TableForm\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p1",
                      "TraditionalForm"]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "-", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p3",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p2",
                      "TraditionalForm"]}], ")"}]}]},
            {
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p1",
                      "TraditionalForm"]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "-", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p4",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p2",
                      "TraditionalForm"]}], ")"}]}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          Dot[ 
            DiracGamma[ 
              Momentum[ p1]], 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              Times[ -1, 
                DiracGamma[ 
                  Momentum[ p3]]]], 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]], 
            DiracGamma[ 
              Momentum[ p2]]], 
          Dot[ 
            DiracGamma[ 
              Momentum[ p1]], 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              Times[ -1, 
                DiracGamma[ 
                  Momentum[ p4]]]], 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]], 
            DiracGamma[ 
              Momentum[ p2]]]}]], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(camps = {\[IndentingNewLine]gn . \((p1s - p3s - m)\) . 
            gm, \[IndentingNewLine]gm . \((p1s - p4s - m)\) . 
            gn};\)\), "\[IndentingNewLine]", 
    \(camps\  // TableForm\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "-", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p3",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]},
            {
              RowBox[{
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "-", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p4",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          Dot[ 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              Times[ -1, 
                DiracGamma[ 
                  Momentum[ p3]]]], 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]]], 
          Dot[ 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              Times[ -1, 
                DiracGamma[ 
                  Momentum[ p4]]]], 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]]]}]], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat1 = Outer[tr[#1 . #2] &, amps, camps]\  /. {m \[Rule] 0}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p2",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}], 
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p2",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}]},
            {
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p2",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}], 
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p2",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}]}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat2 = mat1\  /. {tr[x__] \[RuleDelayed] Tr[x]}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p3",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}]}], ")"}]}], 
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(-8\), " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p3",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}]}], ")"}]}]},
            {
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(-8\), " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p3",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}]}], ")"}]}], 
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p4",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}]}], ")"}]}]}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat2[\([1, 2]\)] \[Equal] mat2[\([2, 1]\)]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SetMandelstam\)\)], "Input"],

Cell[BoxData[
    \("SetMandelstam[s, t, u, p1, p2, p3, p4, m1, m2, m3, m4] defines the \
Mandelstam variables  s=(p1+p2)^2, t=(p1+p3)^2, u=(p1+p4)^2 and sets the pi \
on-shell: p1^2=m1^2, p2^2=m2^2, p3^2=m3^2, p4^2=m4^2. Note that p1 +  p2 + p3 \
+ p4 = 0 is assumed. \n SetMandelstam[x, {p1, p2, p3, p4, p5}, {m1, m2, m3, \
m4, m5}] defines x[i, j] = (pi+pj)^2 and sets the pi on-shell. The pi \
satisfy: p1 + p2 + p3 + p4 + p5 = 0."\)], "Print",
  CellTags->"Info3262621466-7882925"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(test1 = 
      Outer[ScalarProduct[#1, #2] &, {p1, p2, p3, p4}, {p1, p2, p3, p4}]\  // 
        Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              SuperscriptBox[
                FormBox["p1",
                  "TraditionalForm"], "2"], 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p2",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]},
            {
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p2",
                  "TraditionalForm"]}], 
              SuperscriptBox[
                FormBox["p2",
                  "TraditionalForm"], "2"], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]},
            {
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              SuperscriptBox[
                FormBox["p3",
                  "TraditionalForm"], "2"], 
              RowBox[{
                FormBox["p3",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]},
            {
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p3",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], 
              SuperscriptBox[
                FormBox["p4",
                  "TraditionalForm"], "2"]}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(ClearScalarProducts\), "\[IndentingNewLine]", 
    \(test2 = 
      SetMandelstam[s, t, u, p1, p2, \(-p3\), \(-p4\), 0, 0, 0, 
        Q]\)}], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", \(s\/2\), \(-\(t\/2\)\), \(Q\^2\/2 - u\/2\), 
              "0", \(-\(u\/2\)\), \(Q\^2\/2 - t\/2\), 
              "0", \(s\/2 - Q\^2\/2\), \(Q\^2\), 
              "0", \(s\/2\), \(-\(t\/2\)\), \(Q\^2\/2 - u\/2\), 
              "0", \(-\(u\/2\)\), \(Q\^2\/2 - t\/2\), 
              "0", \(s\/2 - Q\^2\/2\), \(Q\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(test1\  // Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", \(s\/2\), \(-\(t\/2\)\), \(1\/2\ \((Q\^2 - u)\)\)},
            {\(s\/2\), "0", \(-\(u\/2\)\), \(1\/2\ \((Q\^2 - t)\)\)},
            {\(-\(t\/2\)\), \(-\(u\/2\)\), "0", \(1\/2\ \((s - Q\^2)\)\)},
            {\(1\/2\ \((Q\^2 - u)\)\), \(1\/2\ \((Q\^2 - 
                    t)\)\), \(1\/2\ \((s - Q\^2)\)\), \(Q\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat3 = mat2\  // Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(8\ t\ u\), \(\(-8\)\ s\ \((\(-2\)\ Q\^2 + s + t + u)\)\)},
            {\(\(-8\)\ s\ \((\(-2\)\ Q\^2 + s + t + 
                    u)\)\), \(8\ \((Q\^4 - \((s + t + u)\)\ Q\^2 + t\ u)\)\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?TrickMandelstam\)\)], "Input"],

Cell[BoxData[
    \("TrickMandelstam[expr, {s, t, u, m1^2 + m2^2 + m3^2 + m4^2}] simplifies \
all sums in expr so that one of the Mandelstam variables s, t or u is \
eliminated by the relation s + t + u = m1^2 + m2^2 + m3^2 + m4^2. The trick \
is that the resulting sum has the most short number of  terms."\)], "Print",
  CellTags->"Info3262614004-5830576"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat4 = TrickMandelstam[mat3, {s, t, u, Q^2}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(8\ t\ u\), \(8\ Q\^2\ s\)},
            {\(8\ Q\^2\ s\), \(8\ t\ u\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(den = 1/{{t^2, t\ u}, {u\ t, u^2}}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(1\/t\^2\), \(1\/\(t\ u\)\)},
            {\(1\/\(t\ u\)\), \(1\/u\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat5 = \ mat4\ den;\)\), "\[IndentingNewLine]", 
    \(mat5\  // StyleForm[#, FontSize \[Rule] 24] &\)}], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[
        StyleBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(\(8\ u\)\/t\), \(\(8\ Q\^2\ s\)\/\(t\ u\)\)},
                {\(\(8\ Q\^2\ s\)\/\(t\ u\)\), \(\(8\ t\)\/u\)}
                }], "\[NoBreak]", ")"}],
          FontSize->24],
        (StyleForm[ #, FontSize -> 24]&)], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(ClearScalarProducts\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "CALCULATION:  ",
  Cell[BoxData[
      \(TraditionalForm\`u\ g\ \  \[RightArrow] \ \ u\ \ \[Gamma]\)]]
}], "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 -1.40675e-17 0.0227273 [
[ 0 0 0 0 ]
[ 1 .65 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65 L
0 .65 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -1.40675e-17 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.31818 .5 L
s
.20277 .59618 m
.14923 .61713 L
.17251 .64506 L
F
gsave
.16421 .587 -74.125 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.3169 .49329 L
.31449 .48684 L
.311 .48088 L
.30651 .47563 L
.30116 .47127 L
.29511 .46793 L
.28858 .4657 L
.28178 .46464 L
.27495 .46472 L
.26834 .46589 L
.26218 .46802 L
.25666 .47098 L
.25198 .47456 L
.24827 .47853 L
.24562 .48267 L
.2441 .48672 L
.2437 .49045 L
.24436 .49361 L
.24598 .49601 L
.24842 .49748 L
.2515 .4979 L
.255 .49718 L
.2587 .49531 L
.26236 .49229 L
.26573 .48822 L
.2686 .48322 L
.27076 .47746 L
.27205 .47113 L
.27233 .46447 L
.27152 .45772 L
.26959 .45113 L
.26655 .44494 L
.26247 .43937 L
.25746 .43461 L
.25169 .43082 L
.24533 .42811 L
.23862 .42656 L
.23178 .42616 L
.22505 .42687 L
.21867 .42862 L
.21285 .43125 L
.20779 .43459 L
.20366 .43842 L
.20055 .44252 L
.19855 .44664 L
.19768 .45053 L
.1979 .45396 L
.19913 .45671 L
.20124 .45859 L
Mistroke
.20407 .45947 L
.20742 .45924 L
.21107 .45785 L
.21477 .45532 L
.21829 .45168 L
.2214 .44706 L
.22389 .44159 L
.22556 .43548 L
.22628 .42893 L
.22594 .42219 L
.22449 .41551 L
.22191 .40912 L
.21826 .40325 L
.21363 .39813 L
.20816 .39391 L
.20203 .39074 L
.19544 .38869 L
.18862 .3878 L
.18181 .38805 L
.17526 .38937 L
.16917 .39165 L
.16378 .39471 L
.15923 .39836 L
.15568 .40238 L
.1532 .40652 L
.15185 .41054 L
.15161 .41419 L
.15243 .41725 L
.15418 .41952 L
.15674 .42084 L
.15989 .42109 L
.16344 .4202 L
.16715 .41814 L
.17078 .41497 L
.17409 .41074 L
.17686 .40562 L
.1789 .39975 L
.18004 .39336 L
.18016 .38667 L
.17918 .37993 L
.17708 .37339 L
.17387 .36728 L
.16964 .36181 L
.16451 .35719 L
.15863 .35356 L
.15221 .35103 L
.14546 .34965 L
.13862 .34942 L
.13193 .3503 L
.12562 .35219 L
Mistroke
.11991 .35494 L
.11498 .35837 L
.11099 .36227 L
.10805 .36639 L
.10623 .37049 L
.10552 .37432 L
.1059 .37766 L
.10727 .38029 L
.10951 .38203 L
.11243 .38274 L
.11584 .38234 L
.11951 .38077 L
.1232 .37806 L
.12667 .37427 L
.1297 .36951 L
.13207 .36393 L
.13361 .35774 L
.13418 .35115 L
.13367 .3444 L
.13204 .33774 L
.1293 .33142 L
.12549 .32566 L
.12072 .32066 L
.11514 .31659 L
.10892 .31358 L
.10228 .31171 L
.09545 .311 L
.08867 .31142 L
.08217 .3129 L
.07618 .3153 L
.0709 .31847 L
.0665 .32219 L
.0631 .32625 L
.0608 .33038 L
.05962 .33436 L
.05954 .33794 L
.06051 .34089 L
.0624 .34303 L
.06505 .34419 L
.06828 .34427 L
.07187 .3432 L
.07558 .34097 L
.07918 .33763 L
.08242 .33326 L
.08509 .32801 L
.08701 .32205 L
.088 .3156 L
.08795 .30888 L
.0868 .30216 L
.08453 .29566 L
Mistroke
.08116 .28964 L
.07679 .28429 L
.07153 .27981 L
.06555 .27634 L
.05907 .27398 L
.05229 .27278 L
.04545 .27273 L
Mfstroke
gsave
.19943 .35973 -61 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.68182 .5 L
s
.83913 .6311 m
.78559 .61014 L
.80887 .58221 L
F
gsave
.80057 .64027 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68274 .49399 L
.68399 .48838 L
.68587 .48353 L
.68859 .47968 L
.69224 .47696 L
.69681 .47534 L
.70217 .47465 L
.70805 .47461 L
.71417 .47483 L
.72017 .47493 L
.72573 .47449 L
.73058 .47321 L
.73455 .47086 L
.73758 .46738 L
.73972 .46284 L
.74115 .45745 L
.74214 .45153 L
.74302 .44547 L
.74413 .43969 L
.74577 .43455 L
.74819 .43034 L
.75153 .42724 L
.75581 .42526 L
.76092 .42429 L
.76666 .42407 L
.77274 .42425 L
.77881 .42444 L
.78455 .42422 L
.78967 .42324 L
.79395 .42127 L
.79728 .41816 L
.7997 .41396 L
.80135 .40882 L
.80245 .40303 L
.80333 .39698 L
.80432 .39106 L
.80575 .38567 L
.80789 .38113 L
.81092 .37765 L
.81489 .3753 L
.81974 .37402 L
.8253 .37358 L
.8313 .37367 L
.83742 .3739 L
.8433 .37385 L
.84866 .37316 L
.85323 .37154 L
.85688 .36882 L
.8596 .36497 L
Mistroke
.86148 .36011 L
.86273 .35451 L
.86365 .3485 L
.86456 .34249 L
.86581 .33688 L
.86769 .33203 L
.87041 .32818 L
.87406 .32545 L
.87864 .32383 L
.88399 .32314 L
.88988 .3231 L
.89599 .32332 L
.90199 .32341 L
.90755 .32298 L
.9124 .32169 L
.91637 .31934 L
.9194 .31586 L
.92154 .31132 L
.92297 .30593 L
.92396 .30001 L
.92484 .29395 L
.92594 .28817 L
.92758 .28303 L
.93 .27882 L
.93334 .27572 L
.93761 .27374 L
.94273 .27277 L
.94847 .27255 L
.95455 .27273 L
Mfstroke
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.68182 .5 L
s
.52727 .5 m
.47273 .48182 L
.47273 .51818 L
F
gsave
.5 .45704 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N1) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -1.40675e-17 1 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -67.5625 -16.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.49487 .31302 L
.48886 .30886 L
.48215 .30589 L
.47501 .30427 L
.46768 .30406 L
.46045 .30527 L
.45359 .30783 L
.44734 .31158 L
.44192 .31632 L
.43751 .3218 L
.43423 .3277 L
.43215 .33372 L
.43125 .33953 L
.43149 .34481 L
.43273 .34927 L
.4348 .35267 L
.43749 .35482 L
.44054 .3556 L
.44369 .35495 L
.44666 .3529 L
.44919 .34955 L
.45103 .34505 L
.45198 .33964 L
.45188 .33358 L
.45062 .32718 L
.44817 .32078 L
.44453 .31468 L
.4398 .3092 L
.43411 .30462 L
.42765 .30117 L
.42064 .29901 L
.41335 .29824 L
.40605 .29891 L
.39901 .30095 L
.3925 .30425 L
.38673 .30864 L
.38191 .31386 L
.37818 .31964 L
.37563 .32565 L
.37427 .33158 L
.37408 .3371 L
.37494 .34191 L
.37671 .34575 L
.37919 .34841 L
.38213 .34974 L
.38528 .34965 L
.38835 .34814 L
.39108 .34527 L
.39322 .3412 L
Mistroke
.39454 .33611 L
.39486 .33027 L
.39406 .32397 L
.39208 .31753 L
.3889 .31128 L
.38458 .30552 L
.37924 .30056 L
.37305 .29664 L
.36623 .29396 L
.35902 .29264 L
.35169 .29275 L
.34452 .29427 L
.33777 .2971 L
.33169 .30109 L
.32648 .30601 L
.32231 .31161 L
.31929 .31757 L
.31747 .32357 L
.31683 .32929 L
.31729 .33441 L
.31874 .33866 L
.32096 .3418 L
.32376 .34366 L
.32685 .34413 L
.32999 .34317 L
.33288 .34082 L
.33528 .3372 L
.33694 .33248 L
.33767 .3269 L
.33732 .32074 L
.3358 .31432 L
.33309 .30795 L
.3292 .30197 L
.32425 .29666 L
.31837 .29231 L
.31176 .28913 L
.30468 .28727 L
.29736 .28682 L
.29009 .28779 L
.28315 .29012 L
.27678 .29368 L
.27121 .29827 L
.26662 .30364 L
.26314 .3095 L
.26085 .31552 L
.25975 .32139 L
.2598 .32678 L
.26088 .3314 L
.26282 .335 L
.26542 .33737 L
Mistroke
.26843 .33839 L
.27159 .33799 L
.27461 .33618 L
.27723 .33303 L
.2792 .32872 L
.28031 .32345 L
.2804 .31748 L
.27935 .31112 L
.2771 .30469 L
.27366 .29852 L
.26911 .29292 L
.26357 .28816 L
.25722 .2845 L
.25029 .28211 L
.24303 .2811 L
.23572 .28152 L
.22861 .28334 L
.22199 .28644 L
.21608 .29065 L
.21109 .29575 L
.20717 .30145 L
.20441 .30745 L
.20284 .31342 L
.20246 .31903 L
.20315 .32399 L
.20478 .32801 L
.20715 .33088 L
.21003 .33245 L
.21316 .3326 L
.21627 .33133 L
.21907 .32869 L
.22133 .32481 L
.2228 .31989 L
.2233 .31415 L
.22271 .30791 L
.22093 .30147 L
.21795 .29516 L
.21382 .2893 L
.20864 .28419 L
.20259 .28007 L
.19586 .27717 L
.1887 .27561 L
.18137 .27547 L
.17415 .27675 L
.16731 .27937 L
.1611 .28317 L
.15573 .28796 L
.15137 .29346 L
.14815 .29938 L
.14612 .3054 L
Mistroke
.14528 .31119 L
.14557 .31643 L
.14685 .32085 L
.14896 .3242 L
.15167 .32629 L
.15474 .327 L
.15788 .32628 L
.16084 .32417 L
.16334 .32075 L
.16514 .31621 L
.16604 .31076 L
.16588 .30468 L
.16457 .29828 L
.16206 .29188 L
.15837 .2858 L
.15359 .28036 L
.14785 .27583 L
.14136 .27244 L
.13433 .27034 L
.12704 .26965 L
.11975 .27038 L
.11273 .27248 L
.10624 .27585 L
.10052 .28028 L
.09575 .28553 L
.09207 .29133 L
.08958 .29735 L
.08828 .30326 L
.08813 .30876 L
.08905 .31353 L
.09086 .31732 L
.09336 .31992 L
.09632 .32118 L
.09947 .32102 L
.10253 .31944 L
.10524 .31652 L
.10734 .31239 L
.10861 .30727 L
.10889 .3014 L
.10803 .29508 L
.10599 .28864 L
.10275 .28241 L
.09838 .27668 L
.093 .27177 L
.08678 .26791 L
.07993 .26529 L
.07271 .26404 L
.06538 .26421 L
.05822 .2658 L
.0515 .26869 L
Mistroke
.04545 .27273 L
Mfstroke
gsave
.27974 .25284 -67.5625 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.812 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.5 .31818 L
s
.74754 .54097 m
.69484 .518 L
.71916 .49097 L
F
gsave
.81534 .64005 -74.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50078 .67586 L
.50187 .67025 L
.50357 .66531 L
.50608 .66128 L
.5095 .65826 L
.51384 .65626 L
.51897 .65514 L
.52469 .65468 L
.53072 .65455 L
.53672 .6544 L
.54237 .65386 L
.54741 .65264 L
.55163 .65051 L
.55493 .64735 L
.55732 .64319 L
.55893 .63814 L
.55996 .63247 L
.56072 .62649 L
.56152 .62055 L
.56268 .61502 L
.56447 .61019 L
.5671 .60628 L
.57065 .60341 L
.5751 .60153 L
.58033 .60052 L
.58611 .60012 L
.59214 .60001 L
.59812 .59982 L
.60371 .59921 L
.60865 .59788 L
.61275 .59562 L
.61592 .59232 L
.6182 .58803 L
.61971 .58288 L
.62069 .57715 L
.62143 .57115 L
.62226 .56525 L
.62349 .5598 L
.62539 .55508 L
.62813 .55131 L
.6318 .54857 L
.63637 .54682 L
.64169 .5459 L
.64752 .54556 L
.65357 .54546 L
.6595 .54524 L
.66502 .54455 L
.66986 .5431 L
.67384 .5407 L
Mistroke
.67689 .53727 L
.67905 .53285 L
.68048 .52761 L
.68141 .52182 L
.68214 .51581 L
.68301 .50995 L
.68431 .50458 L
.68631 .49998 L
.68918 .49634 L
.69297 .49374 L
.69765 .49211 L
.70305 .49129 L
.70893 .491 L
.71498 .4909 L
.72088 .49064 L
.72632 .48986 L
.73105 .48829 L
.73491 .48576 L
.73784 .48219 L
.73989 .47765 L
.74123 .47232 L
.74212 .46648 L
.74285 .46047 L
.74376 .45466 L
.74514 .44937 L
.74725 .44489 L
.75024 .44139 L
.75415 .43892 L
.75894 .43742 L
.76442 .43668 L
.77034 .43644 L
.77639 .43634 L
.78224 .43602 L
.7876 .43515 L
.79222 .43347 L
.79596 .43079 L
.79876 .42709 L
.80071 .42243 L
.80197 .41701 L
.80282 .41113 L
.80356 .40513 L
.80451 .39936 L
.80598 .39417 L
.80819 .38982 L
.8113 .38645 L
.81534 .38412 L
.82023 .38273 L
.82579 .38208 L
.83174 .38187 L
.83779 .38176 L
Mistroke
.84359 .38139 L
.84886 .38043 L
.85337 .37861 L
.85698 .3758 L
.85967 .37196 L
.86151 .36719 L
.8627 .36169 L
.86351 .35577 L
.86426 .34978 L
.86526 .34408 L
.86682 .33898 L
.86915 .33475 L
.87239 .33153 L
.87655 .32933 L
.88154 .32805 L
.88716 .32747 L
.89315 .3273 L
.89918 .32718 L
.90493 .32674 L
.91011 .32568 L
.9145 .32374 L
.91799 .32079 L
.92055 .31682 L
.9223 .31193 L
.92342 .30636 L
.9242 .30041 L
.92496 .29444 L
.92603 .2888 L
.92767 .28381 L
.93012 .2797 L
.93348 .27661 L
.93776 .27454 L
.94284 .27337 L
.94853 .27287 L
.95455 .27273 L
Mfstroke
gsave
.84375 .41277 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
71.688 13.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.46158 .5 -74.125 -10.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.125 13.562 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 16.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -91.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
81.938 14.688 moveto
(C1) show
102.375 14.688 moveto
(N2) show
119.188 14.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 13.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 .59 -68.4688 -12.4688 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.9375 translate 1 -1 scale
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.938 15.625 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59 -71.0938 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.312 moveto
(\\256) show
79.188 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 .59 -68.4688 -10.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.875 translate 1 -1 scale
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
73.938 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 .59 -68.2188 -12.1562 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
73.438 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 19.750 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 187.188},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000^b000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00U`3oool4000008D0oooo00060?ooo`800000O`3o
ool2000000d0oooo00<000000?ooo`3oool00P3oool200000080oooo1@00001b0?ooo`<000001`3o
ool000P0oooo0`00001j0?ooo`8000005P3oool2000000D0oooo0P0000000`3oool0000000000004
000006L0oooo0P00000:0?ooo`002`3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo
01D0oooo0P0000070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@0000050?oo
o`800000F03oool00`000000oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`1f0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`0000001P3oool2000000L0oooo00<000000?ooo`3o
ool0103oool500000080oooo0P0000020?ooo`@00000D03oool00`000000oooo0?ooo`090?ooo`00
303oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`000000
0000103oool010000000oooo0?ooo`0000050?ooo`8000001`3oool00`000000oooo0?ooo`040?oo
o`<00000103oool200000080oooo1@0000160?ooo`030000003oool0oooo00X0oooo000<0?ooo`03
0000003oool0oooo07D0oooo00<000000?ooo`3oool05@3oool010000000oooo0?ooo`0000040?oo
o`040000003oool0oooo000000@0oooo0P0000000`3oool000000?ooo`040?ooo`030000003oool0
000000H0oooo0P0000060?ooo`8000001@3oool00`000000oooo0?ooo`09000003X0oooo00<00000
0?ooo`3oool02P3oool000/0oooo1@00001d0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`0000001@3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`0000001@3oool00`000000oooo000000060?ooo`8000001P3oool2000000D0oooo1000
000j0?ooo`030000003oool0oooo00X0oooo00090?ooo`80000000<0oooo0000003oool00P3oool2
00000700oooo0P00000H0?ooo`<000001@3oool010000000oooo0000000000040?ooo`040000003o
ool0oooo000000@0oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000050?ooo`03
0000003oool0000000H0oooo0P0000050?ooo`@00000>@3oool2000000`0oooo00090?ooo`040000
003oool0oooo000000D0oooo00<000000?ooo`3oool0I`3oool700000240oooo0`0000050?ooo`04
0000003oool00000000000@0oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`00
00050?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool00000103oool4000003@0oooo
1P00000=0?ooo`00203oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
I`3oool00`000000oooo0?ooo`0^0?ooo`8000001@3oool4000000@0oooo00@000000?ooo`3oool0
00001@3oool010000000oooo0000000000040?ooo`040000003oool0oooo000000H0oooo00<00000
0?ooo`000000<@3oool2000001<0oooo00080?ooo`@000001`3oool00`000000oooo0?ooo`1V0?oo
o`030000003oool0oooo03H0oooo0P0000060?ooo`<000001@3oool00`000000oooo000000050?oo
o`040000003oool0oooo000000H0oooo00@000000?ooo`3oool00000<03oool00`000000oooo0?oo
o`0B0?ooo`002@3oool2000000P0oooo0`00001U0?ooo`030000003oool0oooo03l0oooo0P000006
0?ooo`<000001@3oool010000000oooo0000000000060?ooo`040000003oool0oooo0?ooo`800000
;P3oool00`000000oooo0?ooo`0B0?ooo`004@3oool300000080oooo0P00001S0?ooo`030000003o
ool0oooo04l0oooo0`0000070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`0B0?ooo`00403oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0600oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02X0oooo00<000000?ooo`3oool04P3oool000l0oooo00@000000?ooo`3oool000001P3o
ool00`000000oooo0?ooo`1N0?ooo`800000F`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool04`3oool000l0oooo00@000000?ooo`00000000001P3o
ool00`000000oooo0?ooo`1H0?ooo`L00000G03oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool04`3oool000l0oooo0`0000070?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0200oooo1P00000F0?ooo`00603oool6000005D0oooo00<000000?ooo`3oool0H@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool06P3oool001L0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo
0640oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
01/0oooo000F0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0D@3oool00`00
0000oooo0?ooo`1Q0?ooo`030000003oool0oooo00X0oooo0P00000L0?ooo`030000003oool0oooo
01/0oooo000F0?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool0D03oool00`00
0000oooo0?ooo`1Q0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0K0?ooo`005@3oool2000000030?ooo`000000oooo00H0oooo00<000000?ooo`3o
ool0C`3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0K0?ooo`005P3oool2000000P0oooo0`0000190?ooo`H00000
I@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01H0oooo0P00000M0?ooo`007P3o
ool300000080oooo0P0000160?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo0P00000:0?ooo`030000003o
ool0oooo0140oooo000M0?ooo`80000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`12
0?ooo`8000003`3oool2000005X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>
0?ooo`H000002`3oool200000180oooo000L0?ooo`030000003oool0oooo008000001@3oool00`00
0000oooo0?ooo`110?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0F03oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0@0?ooo`00703oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo
0440oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool02P3oool2000001<0oooo00<000000?ooo`3oool03`3oool001`0
oooo100000070?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`1G0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo000U0?ooo`H00000?P3oool200000180oooo
0P00001H0?ooo`030000003oool0oooo01@0oooo0P0000090?ooo`030000003oool0oooo0180oooo
0P00000@0?ooo`00903oool2000000030?ooo`000000oooo0080oooo0P00000g0?ooo`H000004`3o
ool2000005P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0180oooo0P00000@0?ooo`008`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool0<`3oool2000001T0oooo00<000000?ooo`000000E`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0000
000?0?ooo`008`3oool010000000oooo0?ooo`0000050?ooo`@000004`3oool3000001X0oooo1000
000I0?ooo`040000003oool0oooo000005H0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`020?ooo`8000005@3oool010000000oooo0?ooo`00000>0?ooo`008`3oool00`000000oooo
000000060?ooo`@000004`3oool6000001L0oooo1000000E0?ooo`030000003oool0oooo00800000
0P3oool00`000000oooo0?ooo`1C0?ooo`8000006P3oool5000001<0oooo00<000000?ooo`3oool0
0P0000020?ooo`030000003oool0oooo00`0oooo000S0?ooo`8000001`3ooolh000001H0oooo0`00
00040?ooo`030000003oool0oooo0580oooo0P00000I0?ooo`030000003oool0oooo00<00000503o
ool3000000@0oooo00<000000?ooo`3oool02`3oool002`0oooo1000000C0?ooo`H000005`3oool4
00000780oooo0`00000H0?ooo`030000003oool0oooo00@00000:03oool002X0oooo0P00000G0?oo
o`<000007@3oool200000700oooo1000000H0?ooo`030000003oool0000000@00000:03oool002T0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`1]0?ooo`@00000603oool8000002L0
oooo000X0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0J`3oool5000001L0oooo
00<000000?ooo`3oool00P3oool5000002H0oooo000W0?ooo`030000003oool0oooo03d0oooo00<0
00000?ooo`3oool0K@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0oooo0`00
000U0?ooo`009P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo06`0oooo00<00000
0?ooo`3oool04P3oool4000000/0oooo00<000000?ooo`3oool08P3oool002@0oooo0P0000130?oo
o`800000K03oool00`000000oooo0?ooo`0?0?ooo`<00000403oool00`000000oooo0?ooo`0Q0?oo
o`008`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3o
ool03P3oool2000001<0oooo00<000000?ooo`3oool0803oool00280oooo00<000000?ooo`3oool0
A`3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0O0?ooo`008@3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo06L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo01h0oooo000O0?ooo`800000C@3oool2000006L0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0E0?ooo`8000007P3oool001h0oooo00<000000?ooo`3oool0C`3oool00`00
0000oooo0?ooo`1T0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0K0?ooo`007@3oool00`000000oooo0?ooo`1A0?ooo`040000003oool000000000
0680oooo00<000000?ooo`3oool03@3oool2000001X0oooo00<000000?ooo`3oool06P3oool001`0
oooo00<000000?ooo`3oool0D`3oool400000640oooo00<000000?ooo`3oool01`3oool7000001`0
oooo00<000000?ooo`3oool06@3oool001/0oooo0P00001D0?ooo`D00000H@3oool00`000000oooo
0?ooo`060?ooo`8000008`3oool00`000000oooo0?ooo`0H0?ooo`00603oool4000005@0oooo1`00
001P0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?oo
o`0G0?ooo`005@3oool6000005P0oooo1000001P0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0F0?ooo`005P3oool5000005/0oooo0P00001O0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool4000005h0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool0503oool001D0oooo00@000000?ooo`3oool0
0000H03oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0:03oool2000001@0oooo000C0?ooo`800000I@3oool2000005/0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0140oooo000B0?ooo`030000003o
ool0oooo06L0oooo00<000000?ooo`3oool0F03oool00`000000oooo00000004000002l0oooo00<0
00000?ooo`3oool0403oool00140oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1G
0?ooo`800000=@3oool00`000000oooo0?ooo`0?0?ooo`00403oool00`000000oooo0?ooo`1[0?oo
o`030000003oool0oooo05@0oooo1000000f0?ooo`030000003oool0oooo00h0oooo000>0?ooo`80
0000K`3oool2000005@0oooo1000000g0?ooo`030000003oool0oooo00d0oooo000=0?ooo`030000
003oool0oooo0740oooo00<000000?ooo`3oool0CP3oool7000003P0oooo00<000000?ooo`3oool0
303oool000`0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`120?ooo`/000000`3o
ool4000003T0oooo00<000000?ooo`3oool02`3oool000/0oooo00<000000?ooo`3oool0M@3oool0
0`000000oooo0?ooo`0/0?ooo`@000001P3oool;000004`0oooo0P00000;0?ooo`002P3oool00`00
0000oooo0?ooo`1g0?ooo`030000003oool0oooo02/0oooo2P00001I0?ooo`030000003oool0oooo
00P0oooo00080?ooo`800000N`3oool200000200oooo4@00001N0?ooo`030000003oool0oooo00L0
oooo00070?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool04P3oool;000000/0oooo
0`00001R0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo07l0oooo00<0
00000?ooo`3oool02`3oool6000007`0oooo00<000000?ooo`3oool01@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {186.188, 0}} -> {-0.0428331, 6.18969*^-16, \
0.153608, 0.153608}, {{0.25, 143.5}, {186.188, 42.9375}} -> {-1.0385, \
-1.00011, 0.153579, 0.153579}, {{143.5, 286.688}, {186.188, 42.9375}} -> \
{-23.0484, -1.00491, 0.153646, 0.153646}}],

Cell[BoxData[
    \(ClearScalarProducts\)], "Input"],

Cell[CellGroupData[{

Cell["{p1s,p2s,p3s,p4s}=Map[DiracSlash,{p1,p2,p3,p4}]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p1",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p2",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p3",
              "TraditionalForm"]}], ",", 
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["p4",
              "TraditionalForm"]}]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
{gm,gn,gm1,gm2}=Map[DiracMatrix,{\[Mu],\[Nu],\[Rho],\[Sigma]}]\
\>",\
 "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Rho]",
                "TraditionalForm"],
              "TraditionalForm"]], ",", 
          SuperscriptBox["\[Gamma]", 
            FormBox[
              FormBox["\[Sigma]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "}"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(amps = {\[IndentingNewLine]p1s . gm . \((p1s + p2s - m)\) . gn . 
            p3s, \[IndentingNewLine]p1s . gn . \((p1s - p4s - m)\) . gm . 
            p3s};\)\), "\[IndentingNewLine]", 
    \(amps\  // TableForm\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p1",
                      "TraditionalForm"]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p2",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p3",
                      "TraditionalForm"]}], ")"}]}]},
            {
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p1",
                      "TraditionalForm"]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "-", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p4",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{
                    FormBox["\<\"\[Gamma]\"\>",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["p3",
                      "TraditionalForm"]}], ")"}]}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          Dot[ 
            DiracGamma[ 
              Momentum[ p1]], 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              DiracGamma[ 
                Momentum[ p2]]], 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]], 
            DiracGamma[ 
              Momentum[ p3]]], 
          Dot[ 
            DiracGamma[ 
              Momentum[ p1]], 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              Times[ -1, 
                DiracGamma[ 
                  Momentum[ p4]]]], 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]], 
            DiracGamma[ 
              Momentum[ p3]]]}]], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(camps = {\[IndentingNewLine]gn . \((p1s + p2s - m)\) . 
            gm, \[IndentingNewLine]gm . \((p1s - p4s - m)\) . 
            gn};\)\), "\[IndentingNewLine]", 
    \(camps\  // TableForm\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p2",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]},
            {
              RowBox[{
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], ".", 
                RowBox[{"(", 
                  RowBox[{\(-m\), "+", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], "-", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p4",
                        "TraditionalForm"]}]}], ")"}], ".", 
                SuperscriptBox["\[Gamma]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          Dot[ 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              DiracGamma[ 
                Momentum[ p2]]], 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]]], 
          Dot[ 
            DiracGamma[ 
              LorentzIndex[ \[Mu]]], 
            Plus[ 
              Times[ -1, m], 
              DiracGamma[ 
                Momentum[ p1]], 
              Times[ -1, 
                DiracGamma[ 
                  Momentum[ p4]]]], 
            DiracGamma[ 
              LorentzIndex[ \[Nu]]]]}]], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat1 = Outer[tr[#1 . #2] &, amps, camps]\  /. {m \[Rule] 0}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "+", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p3",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "+", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}], 
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "+", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p3",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}]},
            {
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p3",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "+", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}], 
              RowBox[{"tr", "(", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p1",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p3",
                        "TraditionalForm"]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p1",
                          "TraditionalForm"]}], "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], ")"}]}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat2 = mat1\  /. {tr[x__] \[RuleDelayed] Tr[x]}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p2",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}]}], ")"}]}], 
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(-8\), " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}]}], ")"}]}]},
            {
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(-8\), " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p2",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}]}], ")"}]}], 
              RowBox[{"4", " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"4", " ", 
                      SuperscriptBox[
                        FormBox["p4",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p3",
                          "TraditionalForm"]}]}], "-", 
                    RowBox[{"8", " ", 
                      SuperscriptBox[
                        FormBox["p1",
                          "TraditionalForm"], "2"], " ", 
                      RowBox[{
                        FormBox["p3",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}], "+", 
                    RowBox[{"8", " ", 
                      RowBox[{
                        FormBox["p1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}], " ", 
                      RowBox[{
                        FormBox["p3",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["p4",
                          "TraditionalForm"]}]}]}], ")"}]}]}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat2[\([1, 2]\)] \[Equal] mat2[\([2, 1]\)]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SetMandelstam\)\)], "Input"],

Cell[BoxData[
    \("SetMandelstam[s, t, u, p1, p2, p3, p4, m1, m2, m3, m4] defines the \
Mandelstam variables  s=(p1+p2)^2, t=(p1+p3)^2, u=(p1+p4)^2 and sets the pi \
on-shell: p1^2=m1^2, p2^2=m2^2, p3^2=m3^2, p4^2=m4^2. Note that p1 +  p2 + p3 \
+ p4 = 0 is assumed. \n SetMandelstam[x, {p1, p2, p3, p4, p5}, {m1, m2, m3, \
m4, m5}] defines x[i, j] = (pi+pj)^2 and sets the pi on-shell. The pi \
satisfy: p1 + p2 + p3 + p4 + p5 = 0."\)], "Print",
  CellTags->"Info3262622198-7190958"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(test1 = 
      Outer[ScalarProduct[#1, #2] &, {p1, p2, p3, p4}, {p1, p2, p3, p4}]\  // 
        Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              SuperscriptBox[
                FormBox["p1",
                  "TraditionalForm"], "2"], 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p2",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]},
            {
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p2",
                  "TraditionalForm"]}], 
              SuperscriptBox[
                FormBox["p2",
                  "TraditionalForm"], "2"], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]},
            {
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p3",
                  "TraditionalForm"]}], 
              SuperscriptBox[
                FormBox["p3",
                  "TraditionalForm"], "2"], 
              RowBox[{
                FormBox["p3",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}]},
            {
              RowBox[{
                FormBox["p1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], 
              RowBox[{
                FormBox["p3",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p4",
                  "TraditionalForm"]}], 
              SuperscriptBox[
                FormBox["p4",
                  "TraditionalForm"], "2"]}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(ClearScalarProducts\), "\[IndentingNewLine]", 
    \(test2 = 
      SetMandelstam[s, t, u, p1, p2, \(-p3\), \(-p4\), 0, 0, 0, 
        Q]\)}], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", \(s\/2\), \(-\(t\/2\)\), \(Q\^2\/2 - u\/2\), 
              "0", \(-\(u\/2\)\), \(Q\^2\/2 - t\/2\), 
              "0", \(s\/2 - Q\^2\/2\), \(Q\^2\), 
              "0", \(s\/2\), \(-\(t\/2\)\), \(Q\^2\/2 - u\/2\), 
              "0", \(-\(u\/2\)\), \(Q\^2\/2 - t\/2\), 
              "0", \(s\/2 - Q\^2\/2\), \(Q\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(test1\  // Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", \(s\/2\), \(-\(t\/2\)\), \(1\/2\ \((Q\^2 - u)\)\)},
            {\(s\/2\), "0", \(-\(u\/2\)\), \(1\/2\ \((Q\^2 - t)\)\)},
            {\(-\(t\/2\)\), \(-\(u\/2\)\), "0", \(1\/2\ \((s - Q\^2)\)\)},
            {\(1\/2\ \((Q\^2 - u)\)\), \(1\/2\ \((Q\^2 - 
                    t)\)\), \(1\/2\ \((s - Q\^2)\)\), \(Q\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat3 = mat2\  // Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(-8\)\ s\ u\), \(8\ t\ \((\(-2\)\ Q\^2 + s + t + u)\)\)},
            {\(8\ t\ \((\(-2\)\ Q\^2 + s + t + 
                    u)\)\), \(8\ \((\(-Q\^4\) + \((s + t + u)\)\ Q\^2 - 
                    s\ u)\)\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?TrickMandelstam\)\)], "Input"],

Cell[BoxData[
    \("TrickMandelstam[expr, {s, t, u, m1^2 + m2^2 + m3^2 + m4^2}] simplifies \
all sums in expr so that one of the Mandelstam variables s, t or u is \
eliminated by the relation s + t + u = m1^2 + m2^2 + m3^2 + m4^2. The trick \
is that the resulting sum has the most short number of  terms."\)], "Print",
  CellTags->"Info3262622199-2313460"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat4 = TrickMandelstam[mat3, {s, t, u, Q^2}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(-8\)\ s\ u\), \(\(-8\)\ Q\^2\ t\)},
            {\(\(-8\)\ Q\^2\ t\), \(\(-8\)\ s\ u\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(den = 1/{{s^2, s\ u}, {s\ u, u^2}}\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(1\/s\^2\), \(1\/\(s\ u\)\)},
            {\(1\/\(s\ u\)\), \(1\/u\^2\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat5 = \ mat4\ den;\)\), "\[IndentingNewLine]", 
    \(mat5\  // StyleForm[#, FontSize \[Rule] 24] &\)}], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[
        StyleBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(-\(\(8\ u\)\/s\)\), \(-\(\(8\ Q\^2\ t\)\/\(s\ u\)\)\)},
                {\(-\(\(8\ Q\^2\ t\)\/\(s\ u\)\)\), \(-\(\(8\ s\)\/u\)\)}
                }], "\[NoBreak]", ")"}],
          FontSize->24],
        (StyleForm[ #, FontSize -> 24]&)], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat5\  /. {t \[Rule] u, u \[Rule] t}\ \  // 
      StyleForm[#, FontSize \[Rule] 24] &\)], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[
        StyleBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(-\(\(8\ t\)\/s\)\), \(-\(\(8\ Q\^2\ u\)\/\(s\ t\)\)\)},
                {\(-\(\(8\ Q\^2\ u\)\/\(s\ t\)\)\), \(-\(\(8\ s\)\/t\)\)}
                }], "\[NoBreak]", ")"}],
          FontSize->24],
        (StyleForm[ #, FontSize -> 24]&)], TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    \(ClearScalarProducts\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How To Do LOOP Calculations     ...   ",
  StyleBox["(without really trying)",
    FontSlant->"Italic"]
}], "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(ClearScalarProducts\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A,B,C,D Scalar Integrals", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?OneLoop\)\)], "Input"],

Cell[BoxData[
    \("OneLoop[q, amplitude] calculates the one-loop Feynman diagram \
amplitude (n-point, where n<=4 and the highest tensor rank of the integration \
momenta (after cancellation of scalar products) may be 3; unless \
OneLoopSimplify is used). The argument q denotes the integration variable, \
i.e.,  the loop momentum. \n OneLoop[name, q, amplitude] has as first \
argument a name of  the amplitude. If the second argument has head FeynAmp \
then OneLoop[q, FeynAmp[name, k, expr]] and  OneLoop[FeynAmp[name, k, expr]] \
tranform to  OneLoop[name, k, expr]."\)], "Print",
  CellTags->"Info3262609255-4623449"]
}, Closed]],

Cell[BoxData[
    \(\(SetOptions[A0, A0ToB0 \[Rule] False];\)\)], "Input"],

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      FormBox[\(OneLoop(k, 1\/\(k\^2 - m0\^2\))\),
        "TraditionalForm"]}]], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\) 
      OneLoop[k, \[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
          PropagatorDenominator[k, 
            m0]\ \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\("A"\_"0"\),
          "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
        FormBox[\(m0\^2\),
          "TraditionalForm"], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      FormBox[\(OneLoop(k, 
          1\/\((k\^2 - m0\^2)\) . \((\((k + k1)\)\^2 - m1\^2)\))\),
        "TraditionalForm"]}]], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\) 
      OneLoop[k, \[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
          PropagatorDenominator[k, m0]\ , \[IndentingNewLine]\ 
          PropagatorDenominator[k1 + k, 
            m1]\ \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(B\_0\), "(", 
        SuperscriptBox[
          FormBox["k1",
            "TraditionalForm"], "2"], ",", \(m0\^2\), ",", \(m1\^2\), ")"}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`OneLoop(k, 
      1\/\((k\^2 - m0\^2)\) . \((\((k + k1)\)\^2 - m1\^2)\) . \((\((k + k2)\)\
\^2 - m2\^2)\))\)], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\) 
      OneLoop[k, \[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
          PropagatorDenominator[k, m0]\ , \[IndentingNewLine]\ 
          PropagatorDenominator[k1 + k, 
            m1]\ , \[IndentingNewLine]PropagatorDenominator[k2 + k, 
            m2]\ \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\("C"\_"0"\),
          "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
        FormBox[
          SuperscriptBox[
            FormBox["k1",
              "TraditionalForm"], "2"],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          SuperscriptBox[
            FormBox["k2",
              "TraditionalForm"], "2"],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          RowBox[{
            SuperscriptBox[
              FormBox["k1",
                "TraditionalForm"], "2"], "-", 
            RowBox[{"2", " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k2",
                  "TraditionalForm"]}]}], "+", 
            SuperscriptBox[
              FormBox["k2",
                "TraditionalForm"], "2"]}],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m1\^2\),
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m0\^2\),
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m2\^2\),
          "TraditionalForm"], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`OneLoop \((k, 
        1\/\((k\^2 - m0\^2)\) . \((\((k + k1)\)\^2 - m1\^2)\) . \((\((k + k2)\
\)\^2 - m2\^2)\) . \((\((k + k3)\)\^2 - m3\^2)\))\)\)], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(tmp1 = 
      1/\((I\ \[Pi]^2)\) 
        OneLoop[k, \[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
            PropagatorDenominator[k, m0]\ , \[IndentingNewLine]\ 
            PropagatorDenominator[k1 + k, 
              m1]\ , \[IndentingNewLine]PropagatorDenominator[k2 + k, 
              m2]\ , \[IndentingNewLine]PropagatorDenominator[k3 + k, 
              m3]\ \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\("D"\_"0"\),
          "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
        FormBox[
          SuperscriptBox[
            FormBox["k1",
              "TraditionalForm"], "2"],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          RowBox[{
            SuperscriptBox[
              FormBox["k1",
                "TraditionalForm"], "2"], "-", 
            RowBox[{"2", " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k2",
                  "TraditionalForm"]}]}], "+", 
            SuperscriptBox[
              FormBox["k2",
                "TraditionalForm"], "2"]}],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          RowBox[{
            SuperscriptBox[
              FormBox["k2",
                "TraditionalForm"], "2"], "-", 
            RowBox[{"2", " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k3",
                  "TraditionalForm"]}]}], "+", 
            SuperscriptBox[
              FormBox["k3",
                "TraditionalForm"], "2"]}],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          SuperscriptBox[
            FormBox["k3",
              "TraditionalForm"], "2"],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          SuperscriptBox[
            FormBox["k2",
              "TraditionalForm"], "2"],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[
          RowBox[{
            SuperscriptBox[
              FormBox["k1",
                "TraditionalForm"], "2"], "-", 
            RowBox[{"2", " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k3",
                  "TraditionalForm"]}]}], "+", 
            SuperscriptBox[
              FormBox["k3",
                "TraditionalForm"], "2"]}],
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m0\^2\),
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m1\^2\),
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m2\^2\),
          "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
        FormBox[\(m3\^2\),
          "TraditionalForm"], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A,B,C,D Tensor Integrals", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    FormBox[
      RowBox[{"OneLoop", "(", 
        RowBox[{"k", ",", 
          FractionBox[
            RowBox[{
              FormBox["\[Gamma]",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", 
              FormBox["q",
                "TraditionalForm"]}], \(k\^2 - m0\^2\)]}], ")"}], 
      TraditionalForm]], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\) 
      OneLoop[k, \[IndentingNewLine]DiracSlash[
            q]*\[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
            PropagatorDenominator[k, 
              m0]\ \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\("A"\_"0"\),
            "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
          FormBox[\(m0\^2\),
            "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
        RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
          FormBox["q",
            "TraditionalForm"]}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    FormBox[
      RowBox[{"OneLoop", "(", 
        RowBox[{"k", ",", 
          FractionBox[
            RowBox[{
              FormBox["\[Gamma]",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", "(", "\[NoBreak]", 
              FormBox[\(k + k1\),
                "TraditionalForm"], "\[NoBreak]", 
              ")"}], \(\((k\^2 - m0\^2)\) . \((\((k + k1)\)\^2 - 
                  m1\^2)\)\)]}], ")"}], TraditionalForm]], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\) 
        OneLoop[k, \[IndentingNewLine]DiracSlash[
              k1 + k]*\[IndentingNewLine]FeynAmpDenominator[\
\[IndentingNewLine]\ PropagatorDenominator[k, m0]\ , \[IndentingNewLine]\ 
              PropagatorDenominator[k1 + k, 
                m1]\ \[IndentingNewLine]]\[IndentingNewLine]]\  // 
      Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["k1",
              "TraditionalForm"]}], " ", 
          RowBox[{"(", 
            
            RowBox[{\(\((m0\^2 - m1\^2)\)\ \(\(B\_0\)(0, m0\^2, m1\^2)\)\), 
              "+", 
              RowBox[{
                RowBox[{\(B\_0\), "(", 
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"], ",", \(m0\^2\), 
                  ",", \(m1\^2\), ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{\(-m0\^2\), "+", \(m1\^2\), "+", 
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"]}], ")"}]}]}], ")"}]}], 
        RowBox[{"2", " ", 
          SuperscriptBox[
            FormBox["k1",
              "TraditionalForm"], "2"]}]], TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    FormBox[
      RowBox[{"OneLoop", "(", 
        RowBox[{"k", ",", 
          FractionBox[
            RowBox[{
              FormBox["\[Gamma]",
                "TraditionalForm"], "\[CenterDot]", "\[NoBreak]", 
              RowBox[{"(", "\[NoBreak]", 
                RowBox[{
                  FormBox[\(k + k1\),
                    "TraditionalForm"], "\[NoBreak]", "+", "k2"}], 
                ")"}]}], \(\((k\^2 - m0\^2)\) . \((\((k + k1)\)\^2 - 
                  m1\^2)\) . \((\((k + k2)\)\^2 - m2\^2)\)\)]}], ")"}], 
      TraditionalForm]], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\) 
        OneLoop[k, \[IndentingNewLine]DiracSlash[
              k2 + k1 + 
                k]*\[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
              PropagatorDenominator[k, m0]\ , \[IndentingNewLine]\ 
              PropagatorDenominator[k1 + k, 
                m1]\ , \[IndentingNewLine]PropagatorDenominator[k2 + k, 
                m2]\ \[IndentingNewLine]]\[IndentingNewLine]] // 
      Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\("C"\_"0"\),
              "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
            FormBox[
              SuperscriptBox[
                FormBox["k1",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              SuperscriptBox[
                FormBox["k2",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              RowBox[{
                SuperscriptBox[
                  FormBox["k1",
                    "TraditionalForm"], "2"], "-", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["k1",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["k2",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["k2",
                    "TraditionalForm"], "2"]}],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m1\^2\),
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m0\^2\),
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m2\^2\),
              "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k1",
                  "TraditionalForm"]}], "+", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k2",
                  "TraditionalForm"]}]}], ")"}]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["k1",
              "TraditionalForm"]}], " ", 
          RowBox[{"PaVe", "(", 
            RowBox[{"1", ",", 
              RowBox[{"{", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"], ",", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], "-", 
                    RowBox[{"2", " ", 
                      RowBox[{
                        FormBox["k1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}]}], "+", 
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"]}], ",", 
                  SuperscriptBox[
                    FormBox["k2",
                      "TraditionalForm"], "2"]}], "}"}], 
              ",", \({m0\^2, m1\^2, m2\^2}\)}], ")"}]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["k2",
              "TraditionalForm"]}], " ", 
          RowBox[{"PaVe", "(", 
            RowBox[{"2", ",", 
              RowBox[{"{", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"], ",", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], "-", 
                    RowBox[{"2", " ", 
                      RowBox[{
                        FormBox["k1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}]}], "+", 
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"]}], ",", 
                  SuperscriptBox[
                    FormBox["k2",
                      "TraditionalForm"], "2"]}], "}"}], 
              ",", \({m0\^2, m1\^2, m2\^2}\)}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(%\  // PaVeReduce\)\  // Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox["1", 
          RowBox[{"2", " ", 
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  FormBox[
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}],
                    "TraditionalForm"], "2"], "-", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"], " ", 
                  SuperscriptBox[
                    FormBox["k2",
                      "TraditionalForm"], "2"]}]}], ")"}]}]], 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"-", 
                RowBox[{\(B\_0\), "(", 
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"], ",", \(m0\^2\), 
                  ",", \(m1\^2\), ")"}]}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}], " ", 
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"]}], "-", 
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k1",
                        "TraditionalForm"]}], " ", 
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}]}]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{\(B\_0\), "(", 
                SuperscriptBox[
                  FormBox["k2",
                    "TraditionalForm"], "2"], ",", \(m0\^2\), ",", \(m2\^2\), 
                ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}], " ", 
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}]}], "-", 
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k1",
                        "TraditionalForm"]}], " ", 
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"]}]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{\(B\_0\), "(", 
                RowBox[{
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"], "-", 
                  RowBox[{"2", " ", 
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}]}], "+", 
                  SuperscriptBox[
                    FormBox["k2",
                      "TraditionalForm"], "2"]}], ",", \(m1\^2\), 
                ",", \(m2\^2\), ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["k1",
                            "TraditionalForm"], "2"], "-", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k2",
                            "TraditionalForm"]}]}], ")"}]}], "+", 
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k1",
                        "TraditionalForm"]}], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["k2",
                            "TraditionalForm"], "2"], "-", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k2",
                            "TraditionalForm"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
              RowBox[{
                FormBox[\("C"\_"0"\),
                  "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
                FormBox[
                  SuperscriptBox[
                    FormBox["k1",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                FormBox[
                  SuperscriptBox[
                    FormBox["k2",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                FormBox[
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], "-", 
                    RowBox[{"2", " ", 
                      RowBox[{
                        FormBox["k1",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}]}], "+", 
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"]}],
                  "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                FormBox[\(m1\^2\),
                  "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                FormBox[\(m0\^2\),
                  "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                FormBox[\(m2\^2\),
                  "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            FormBox["k1",
                              "TraditionalForm"], "\[NoBreak]", 
                            "\[CenterDot]", "\[NoBreak]", 
                            FormBox["k2",
                              "TraditionalForm"]}], " ", 
                          RowBox[{"(", 
                            RowBox[{\(-m0\^2\), "+", \(m1\^2\), "+", 
                              RowBox[{"2", " ", 
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k2",
                                    "TraditionalForm"]}]}]}], ")"}]}], "+", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox["k1",
                              "TraditionalForm"], "2"], " ", 
                          RowBox[{"(", 
                            RowBox[{\(m0\^2\), "-", \(m2\^2\), "-", 
                              RowBox[{
                                FormBox["k1",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k2",
                                  "TraditionalForm"]}], "-", 
                              SuperscriptBox[
                                FormBox["k2",
                                  "TraditionalForm"], "2"]}], ")"}]}]}], 
                      ")"}]}], "-", 
                  RowBox[{
                    RowBox[{
                      FormBox["\<\"\[Gamma]\"\>",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k1",
                        "TraditionalForm"]}], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{\(-2\), " ", 
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k1",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k2",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"]}], "+", 
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{\(m0\^2\), "-", \(m2\^2\), "+", 
                              SuperscriptBox[
                                FormBox["k2",
                                  "TraditionalForm"], "2"]}], ")"}], " ", 
                          RowBox[{
                            FormBox["k1",
                              "TraditionalForm"], "\[NoBreak]", 
                            "\[CenterDot]", "\[NoBreak]", 
                            FormBox["k2",
                              "TraditionalForm"]}]}], "+", 
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{\(-m0\^2\), "+", \(m1\^2\), "+", 
                              SuperscriptBox[
                                FormBox["k1",
                                  "TraditionalForm"], "2"]}], ")"}], " ", 
                          SuperscriptBox[
                            FormBox["k2",
                              "TraditionalForm"], "2"]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[BoxData[
    FormBox[
      RowBox[{"OneLoop", "(", 
        RowBox[{"k", ",", 
          FractionBox[
            RowBox[{
              FormBox["\[Gamma]",
                "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
              "\[NoBreak]", "(", "\[NoBreak]", 
              FormBox[\(k + k1 + k2 + k3\),
                "TraditionalForm"], "\[NoBreak]", 
              ")"}], \(\((k\^2 - m0\^2)\) . \((\((k + k1)\)\^2 - 
                  m1\^2)\) . \((\((k + k2)\)\^2 - 
                  m2\^2)\) . \((\((k + k3)\)\^2 - m3\^2)\)\)]}], ")"}], 
      TraditionalForm]], "Input",
  Evaluatable->False,
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((I\ \[Pi]^2)\)\ OneLoop[
        k, \[IndentingNewLine]DiracSlash[
            k1 + k2 + k3 + 
              k]*\[IndentingNewLine]FeynAmpDenominator[\[IndentingNewLine]\ 
            PropagatorDenominator[k, m0]\ , \[IndentingNewLine]\ 
            PropagatorDenominator[k1 + k, 
              m1]\ , \[IndentingNewLine]PropagatorDenominator[k2 + k, 
              m2]\ , \[IndentingNewLine]PropagatorDenominator[k3 + k, 
              m3]\ \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\("D"\_"0"\),
              "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
            FormBox[
              SuperscriptBox[
                FormBox["k1",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              RowBox[{
                SuperscriptBox[
                  FormBox["k1",
                    "TraditionalForm"], "2"], "-", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["k1",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["k2",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["k2",
                    "TraditionalForm"], "2"]}],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              RowBox[{
                SuperscriptBox[
                  FormBox["k2",
                    "TraditionalForm"], "2"], "-", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["k2",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["k3",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["k3",
                    "TraditionalForm"], "2"]}],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              SuperscriptBox[
                FormBox["k3",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              SuperscriptBox[
                FormBox["k2",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[
              RowBox[{
                SuperscriptBox[
                  FormBox["k1",
                    "TraditionalForm"], "2"], "-", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["k1",
                      "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                    "\[NoBreak]", 
                    FormBox["k3",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["k3",
                    "TraditionalForm"], "2"]}],
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m0\^2\),
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m1\^2\),
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m2\^2\),
              "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
            FormBox[\(m3\^2\),
              "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k1",
                  "TraditionalForm"]}], "+", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k2",
                  "TraditionalForm"]}], "+", 
              RowBox[{
                FormBox["\<\"\[Gamma]\"\>",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["k3",
                  "TraditionalForm"]}]}], ")"}]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["k1",
              "TraditionalForm"]}], " ", 
          SubscriptBox["D", 
            FormBox["1",
              "TraditionalForm"]]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["k2",
              "TraditionalForm"]}], " ", 
          SubscriptBox["D", 
            FormBox["2",
              "TraditionalForm"]]}], "+", 
        RowBox[{
          RowBox[{
            FormBox["\<\"\[Gamma]\"\>",
              "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", "\[NoBreak]", 
            
            FormBox["k3",
              "TraditionalForm"]}], " ", 
          SubscriptBox["D", 
            FormBox["3",
              "TraditionalForm"]]}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(%\  // PaVeReduce\)\  // Simplify\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  RowBox[{
                    FormBox[\("C"\_"0"\),
                      "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
                    FormBox[
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"],
                      "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                    FormBox[
                      SuperscriptBox[
                        FormBox["k2",
                          "TraditionalForm"], "2"],
                      "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                    FormBox[
                      RowBox[{
                        SuperscriptBox[
                          FormBox["k1",
                            "TraditionalForm"], "2"], "-", 
                        RowBox[{"2", " ", 
                          RowBox[{
                            FormBox["k1",
                              "TraditionalForm"], "\[NoBreak]", 
                            "\[CenterDot]", "\[NoBreak]", 
                            FormBox["k2",
                              "TraditionalForm"]}]}], "+", 
                        SuperscriptBox[
                          FormBox["k2",
                            "TraditionalForm"], "2"]}],
                      "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                    FormBox[\(m1\^2\),
                      "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                    FormBox[\(m0\^2\),
                      "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                    FormBox[\(m2\^2\),
                      "TraditionalForm"], "\[NoBreak]", ")"}]}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k1",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k2",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"], "-", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"]}]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}], "-", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k1",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"]}], "-", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{
                RowBox[{
                  FormBox[\("C"\_"0"\),
                    "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k3",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k3",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m1\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m0\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m3\^2\),
                    "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}], "-", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"]}], "-", 
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k1",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k3",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k1",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}], "-", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"]}]}], ")"}]}]}], 
                  ")"}]}], "-", 
              RowBox[{
                RowBox[{
                  FormBox[\("C"\_"0"\),
                    "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k3",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k2",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k2",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k3",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m2\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m0\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m3\^2\),
                    "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"]}], "-", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"]}], "-", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k1",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k2",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k3",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"], "-", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"]}]}], ")"}]}]}], 
                  ")"}]}], "+", 
              RowBox[{
                RowBox[{
                  FormBox[\("C"\_"0"\),
                    "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k2",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k2",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k3",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k2",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k2",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k3",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m2\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m1\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m3\^2\),
                    "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k1",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k2",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"], "-", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}], "+", 
                                RowBox[{
                                  FormBox["k2",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}]}], ")"}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}]}], "+", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"]}], "+", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  FormBox["k2",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}], "-", 
                                SuperscriptBox[
                                  FormBox["k2",
                                    "TraditionalForm"], "2"]}], ")"}]}]}], 
                        ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k1",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k3",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"], "-", 
                          RowBox[{
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}], "+", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  FormBox["k2",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}], "-", 
                                SuperscriptBox[
                                  FormBox["k3",
                                    "TraditionalForm"], "2"]}], ")"}]}], "+", 
                          
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                SuperscriptBox[
                                  FormBox["k3",
                                    "TraditionalForm"], "2"], "-", 
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}]}], ")"}]}]}], 
                        ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k1",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox[
                              RowBox[{
                                FormBox["k2",
                                  "TraditionalForm"], "\[NoBreak]", 
                                "\[CenterDot]", "\[NoBreak]", 
                                FormBox["k3",
                                  "TraditionalForm"]}],
                              "TraditionalForm"], "2"], "+", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                SuperscriptBox[
                                  FormBox["k2",
                                    "TraditionalForm"], "2"], "-", 
                                RowBox[{
                                  FormBox["k2",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}]}], ")"}]}], "-", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"]}], "+", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                SuperscriptBox[
                                  FormBox["k3",
                                    "TraditionalForm"], "2"], "-", 
                                RowBox[{
                                  FormBox["k2",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}]}], ")"}]}]}], 
                        ")"}]}]}], ")"}]}], "+", 
              RowBox[{
                RowBox[{
                  FormBox[\("D"\_"0"\),
                    "TraditionalForm"], "\[NoBreak]", "(", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k2",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k2",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k3",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k3",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k2",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["k2",
                          "TraditionalForm"], "2"]}],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["k3",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m1\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m0\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m2\^2\),
                    "TraditionalForm"], "\[NoBreak]", ",", "\[NoBreak]", 
                  FormBox[\(m3\^2\),
                    "TraditionalForm"], "\[NoBreak]", ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k2",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-2\), " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox[
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k2",
                                    "TraditionalForm"]}],
                                "TraditionalForm"], "2"]}], "+", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m1\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k1",
                                        "TraditionalForm"], "2"]}], ")"}], 
                                  " ", 
                                  SuperscriptBox[
                                    FormBox["k3",
                                      "TraditionalForm"], "2"]}], "-", 
                                RowBox[{
                                  RowBox[{
                                    FormBox["k1",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}], " ", 
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m3\^2\), "-", 
                                      RowBox[{"4", " ", 
                                        RowBox[{
                                        FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}]}], "+", 
                                      SuperscriptBox[
                                        FormBox["k3",
                                        "TraditionalForm"], "2"]}], ")"}]}]}],
                               ")"}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}]}], "+", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox[
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}],
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{"(", 
                              RowBox[{\(m0\^2\), "-", \(m2\^2\), "-", 
                                SuperscriptBox[
                                  FormBox["k2",
                                    "TraditionalForm"], "2"]}], ")"}]}], "-", 
                          
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{\(m0\^2\), "-", \(m1\^2\), "+", 
                                SuperscriptBox[
                                  FormBox["k1",
                                    "TraditionalForm"], "2"]}], ")"}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}]}], "+", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{\(-2\), " ", 
                                  SuperscriptBox[
                                    FormBox[
                                      RowBox[{
                                        FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}],
                                      "TraditionalForm"], "2"]}], "+", 
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m3\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k3",
                                        "TraditionalForm"], "2"]}], ")"}], 
                                  " ", 
                                  RowBox[{
                                    FormBox["k2",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}]}], "+", 
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(-m0\^2\), "+", \(m2\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k2",
                                        "TraditionalForm"], "2"]}], ")"}], 
                                  " ", 
                                  SuperscriptBox[
                                    FormBox["k3",
                                      "TraditionalForm"], "2"]}]}], ")"}]}]}],
                         ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k1",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-2\), " ", 
                            SuperscriptBox[
                              FormBox["k3",
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox[
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k2",
                                    "TraditionalForm"]}],
                                "TraditionalForm"], "2"]}], "+", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m2\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k2",
                                        "TraditionalForm"], "2"]}], ")"}], 
                                  " ", 
                                  SuperscriptBox[
                                    FormBox["k3",
                                      "TraditionalForm"], "2"]}], "-", 
                                RowBox[{
                                  RowBox[{
                                    FormBox["k2",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}], " ", 
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m3\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k3",
                                        "TraditionalForm"], "2"]}], ")"}]}]}],
                               ")"}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}]}], "-", 
                          RowBox[{"2", " ", 
                            SuperscriptBox[
                              FormBox[
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k3",
                                    "TraditionalForm"]}],
                                "TraditionalForm"], "2"], " ", 
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"]}], "+", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{\(m0\^2\), "-", \(m1\^2\), "-", 
                                SuperscriptBox[
                                  FormBox["k1",
                                    "TraditionalForm"], "2"]}], ")"}], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                SuperscriptBox[
                                  FormBox[
                                    RowBox[{
                                      FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                      "\[CenterDot]", "\[NoBreak]", 
                                      FormBox["k3",
                                        "TraditionalForm"]}],
                                    "TraditionalForm"], "2"], "-", 
                                RowBox[{
                                  SuperscriptBox[
                                    FormBox["k2",
                                      "TraditionalForm"], "2"], " ", 
                                  SuperscriptBox[
                                    FormBox["k3",
                                      "TraditionalForm"], "2"]}]}], ")"}]}], 
                          "+", 
                          RowBox[{
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(-m0\^2\), "+", \(m2\^2\), "+", 
                                      RowBox[{"4", " ", 
                                        RowBox[{
                                        FormBox["k1",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k2",
                                        "TraditionalForm"]}]}]}], ")"}], " ", 
                                  
                                  RowBox[{
                                    FormBox["k2",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}]}], "+", 
                                RowBox[{
                                  SuperscriptBox[
                                    FormBox["k2",
                                      "TraditionalForm"], "2"], " ", 
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m3\^2\), "-", 
                                      RowBox[{
                                        FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}], "+", 
                                      SuperscriptBox[
                                        FormBox["k3",
                                        "TraditionalForm"], "2"]}], ")"}]}]}],
                               ")"}]}]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                        "\[NoBreak]", 
                        FormBox["k3",
                          "TraditionalForm"]}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{\(m0\^2\), "-", \(m3\^2\), "-", 
                                SuperscriptBox[
                                  FormBox["k3",
                                    "TraditionalForm"], "2"]}], ")"}], " ", 
                            SuperscriptBox[
                              FormBox[
                                RowBox[{
                                  FormBox["k1",
                                    "TraditionalForm"], "\[NoBreak]", 
                                  "\[CenterDot]", "\[NoBreak]", 
                                  FormBox["k2",
                                    "TraditionalForm"]}],
                                "TraditionalForm"], "2"]}], "-", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    FormBox["k1",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}], " ", 
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m2\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k2",
                                        "TraditionalForm"], "2"], "-", 
                                      RowBox[{"4", " ", 
                                        RowBox[{
                                        FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}]}]}], ")"}]}], 
                                "+", 
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m1\^2\), "+", 
                                      SuperscriptBox[
                                        FormBox["k1",
                                        "TraditionalForm"], "2"]}], ")"}], 
                                  " ", 
                                  RowBox[{
                                    FormBox["k2",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}]}]}], ")"}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k2",
                                "TraditionalForm"]}]}], "+", 
                          RowBox[{
                            RowBox[{"(", 
                              RowBox[{\(m0\^2\), "-", \(m1\^2\), "-", 
                                RowBox[{"2", " ", 
                                  RowBox[{
                                    FormBox["k1",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}]}]}], ")"}], " ", 
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}], " ", 
                            SuperscriptBox[
                              FormBox["k2",
                                "TraditionalForm"], "2"]}], "+", 
                          RowBox[{
                            SuperscriptBox[
                              FormBox["k1",
                                "TraditionalForm"], "2"], " ", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(m0\^2\), "-", \(m2\^2\), "-", 
                                      RowBox[{"2", " ", 
                                        RowBox[{
                                        FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}]}]}], ")"}], " ", 
                                  
                                  RowBox[{
                                    FormBox["k2",
                                      "TraditionalForm"], "\[NoBreak]", 
                                    "\[CenterDot]", "\[NoBreak]", 
                                    FormBox["k3",
                                      "TraditionalForm"]}]}], "+", 
                                RowBox[{
                                  SuperscriptBox[
                                    FormBox["k2",
                                      "TraditionalForm"], "2"], " ", 
                                  RowBox[{"(", 
                                    RowBox[{\(-m0\^2\), "+", \(m3\^2\), "+", 
                                      RowBox[{
                                        FormBox["k1",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}], "+", 
                                      RowBox[{
                                        FormBox["k2",
                                        "TraditionalForm"], "\[NoBreak]", 
                                        "\[CenterDot]", "\[NoBreak]", 
                                        FormBox["k3",
                                        "TraditionalForm"]}], "+", 
                                      SuperscriptBox[
                                        FormBox["k3",
                                        "TraditionalForm"], "2"]}], ")"}]}]}],
                               ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
          RowBox[{"(", 
            RowBox[{"2", " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k3",
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox[
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k2",
                            "TraditionalForm"]}],
                        "TraditionalForm"], "2"]}], "-", 
                  RowBox[{"2", " ", 
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k3",
                        "TraditionalForm"]}], " ", 
                    RowBox[{
                      FormBox["k2",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k3",
                        "TraditionalForm"]}], " ", 
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["k2",
                        "TraditionalForm"]}]}], "+", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox[
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["k3",
                            "TraditionalForm"]}],
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox["k2",
                        "TraditionalForm"], "2"]}], "+", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], " ", 
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox[
                            RowBox[{
                              FormBox["k2",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["k3",
                                "TraditionalForm"]}],
                            "TraditionalForm"], "2"], "-", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox["k2",
                              "TraditionalForm"], "2"], " ", 
                          SuperscriptBox[
                            FormBox["k3",
                              "TraditionalForm"], "2"]}]}], ")"}]}]}], 
                ")"}]}], ")"}]}]}], TraditionalForm]], "Output"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowToolbars->"EditBar",
WindowSize->{1012, 688},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->12],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{8, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->8],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LineSpacing->{1, 11},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellFrame->True,
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LineSpacing->{1, 7},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    Background->GrayLevel[0.849989]],
  
  Cell[StyleData["Section", "Presentation"],
    CellFrame->True,
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellFrame->True,
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellFrame->True,
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    Hyphenation->True,
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    DefaultNewInlineCellStyle->"None",
    Hyphenation->True,
    LineSpacing->{1, 3},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}},
    FontSize->11],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}},
    FontSize->11],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontSize->11,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->False,
    LanguageCategory->"Formula",
    ScriptLevel->1,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{59, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{108, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{158, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["Hyperlink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["MainBookLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["AddOnsLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["GettingStartedLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["OtherInformationLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    LanguageCategory->"Formula",
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3262845160-6867593"->{
    Cell[41401, 1302, 486, 7, 148, "Print",
      CellTags->"Info3262845160-6867593"]},
  "Info3262621466-7882925"->{
    Cell[117025, 3730, 486, 7, 154, "Print",
      CellTags->"Info3262621466-7882925"]},
  "Info3262614004-5830576"->{
    Cell[122766, 3896, 358, 5, 106, "Print",
      CellTags->"Info3262614004-5830576"]},
  "Info3262622198-7190958"->{
    Cell[193918, 6210, 486, 7, 154, "Print",
      CellTags->"Info3262622198-7190958"]},
  "Info3262622199-2313460"->{
    Cell[199680, 6377, 358, 5, 106, "Print",
      CellTags->"Info3262622199-2313460"]},
  "Info3262609255-4623449"->{
    Cell[202359, 6474, 625, 9, 194, "Print",
      CellTags->"Info3262609255-4623449"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3262845160-6867593", 333616, 9861},
  {"Info3262621466-7882925", 333734, 9864},
  {"Info3262614004-5830576", 333853, 9867},
  {"Info3262622198-7190958", 333972, 9870},
  {"Info3262622199-2313460", 334091, 9873},
  {"Info3262609255-4623449", 334210, 9876}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 125, 5, 58, "Input",
  PageBreakAbove->False],

Cell[CellGroupData[{
Cell[1855, 59, 66, 1, 111, "Section"],
Cell[1924, 62, 57, 1, 39, "Input"],
Cell[1984, 65, 369, 14, 46, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2390, 84, 78, 1, 111, "Section"],

Cell[CellGroupData[{
Cell[2493, 89, 97, 1, 38, "Input"],
Cell[2593, 92, 971, 27, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3601, 124, 122, 4, 31, "Input"],
Cell[3726, 130, 767, 23, 41, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4530, 158, 69, 1, 31, "Input"],
Cell[4602, 161, 966, 28, 41, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5605, 194, 69, 1, 31, "Input"],
Cell[5677, 197, 1445, 42, 41, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7159, 244, 83, 1, 31, "Input"],
Cell[7245, 247, 795, 23, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8077, 275, 83, 1, 31, "Input"],
Cell[8163, 278, 704, 20, 41, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8904, 303, 109, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[9038, 309, 141, 4, 58, "Input"],
Cell[9182, 315, 573, 16, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9792, 336, 101, 1, 31, "Input"],
Cell[9896, 339, 946, 28, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10879, 372, 150, 4, 51, "Input"],
Cell[11032, 378, 1096, 31, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12165, 414, 195, 5, 71, "Input"],
Cell[12363, 421, 442, 12, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12842, 438, 95, 1, 31, "Input"],
Cell[12940, 441, 503, 11, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[13480, 457, 83, 1, 31, "Input"],
Cell[13566, 460, 704, 20, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14307, 485, 80, 1, 31, "Input"],
Cell[14390, 488, 688, 20, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15115, 513, 86, 1, 31, "Input"],
Cell[15204, 516, 11902, 304, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[27143, 825, 126, 4, 31, "Input"],
Cell[27272, 831, 64, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[27373, 837, 69, 1, 31, "Input"],
Cell[27445, 840, 53, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[27535, 846, 92, 1, 37, "Subsubsection"],

Cell[CellGroupData[{
Cell[27652, 851, 187, 7, 130, "Input"],
Cell[27842, 860, 1486, 42, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[29365, 907, 187, 7, 126, "Input"],
Cell[29555, 916, 1486, 42, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[31078, 963, 79, 1, 36, "Input"],
Cell[31160, 966, 1459, 42, 43, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32668, 1014, 86, 1, 37, "Subsubsection"],

Cell[CellGroupData[{
Cell[32779, 1019, 91, 1, 40, "Input"],
Cell[32873, 1022, 517, 9, 49, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[33427, 1036, 267, 4, 108, "Input"],
Cell[33697, 1042, 60, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[33794, 1048, 50, 1, 36, "Input"],
Cell[33847, 1051, 119, 2, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[34003, 1058, 75, 1, 36, "Input"],
Cell[34081, 1061, 71, 1, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[34189, 1067, 110, 2, 36, "Input"],
Cell[34302, 1071, 55, 1, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[34394, 1077, 60, 1, 36, "Input"],
Cell[34457, 1080, 87, 1, 69, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34617, 1089, 77, 1, 111, "Section"],

Cell[CellGroupData[{
Cell[34719, 1094, 97, 1, 38, "Input"],
Cell[34819, 1097, 971, 27, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[35827, 1129, 122, 4, 31, "Input"],
Cell[35952, 1135, 767, 23, 41, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[36756, 1163, 112, 2, 32, "Input"],
Cell[36871, 1167, 1990, 54, 41, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[38898, 1226, 146, 3, 32, "Input"],
Cell[39047, 1231, 2263, 63, 67, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[41347, 1299, 51, 1, 32, "Input"],
Cell[41401, 1302, 486, 7, 148, "Print",
  CellTags->"Info3262845160-6867593"]
}, Closed]],

Cell[CellGroupData[{
Cell[41924, 1314, 83, 1, 32, "Input"],
Cell[42010, 1317, 154, 2, 59, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[42201, 1324, 50, 1, 32, "Input"],
Cell[42254, 1327, 81, 1, 66, "Output"]
}, Closed]],
Cell[42350, 1331, 52, 1, 32, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42439, 1337, 168, 5, 111, "Section"],
Cell[42610, 1344, 43200, 1592, 269, 26399, 1380, "GraphicsData", \
"PostScript", "Graphics"],
Cell[85813, 2938, 52, 1, 39, "Input"],

Cell[CellGroupData[{
Cell[85890, 2943, 97, 1, 38, "Input"],
Cell[85990, 2946, 971, 27, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[86998, 2978, 122, 4, 31, "Input"],
Cell[87123, 2984, 767, 23, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[87927, 3012, 284, 5, 124, "Input"],
Cell[88214, 3019, 4511, 120, 90, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[92762, 3144, 262, 5, 124, "Input"],
Cell[93027, 3151, 3071, 84, 90, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[96135, 3240, 92, 1, 32, "Input"],
Cell[96230, 3243, 11486, 261, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[107753, 3509, 80, 1, 32, "Input"],
Cell[107836, 3512, 8928, 201, 73, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[116801, 3718, 75, 1, 32, "Input"],
Cell[116879, 3721, 55, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[116971, 3727, 51, 1, 32, "Input"],
Cell[117025, 3730, 486, 7, 154, "Print",
  CellTags->"Info3262621466-7882925"]
}, Closed]],

Cell[CellGroupData[{
Cell[117548, 3742, 137, 3, 55, "Input"],
Cell[117688, 3747, 3298, 91, 133, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[121023, 3843, 172, 4, 55, "Input"],
Cell[121198, 3849, 473, 9, 55, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[121708, 3863, 52, 1, 32, "Input"],
Cell[121763, 3866, 472, 8, 163, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[122272, 3879, 58, 1, 32, "Input"],
Cell[122333, 3882, 340, 6, 73, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[122710, 3893, 53, 1, 32, "Input"],
Cell[122766, 3896, 358, 5, 106, "Print",
  CellTags->"Info3262614004-5830576"]
}, Closed]],

Cell[CellGroupData[{
Cell[123161, 3906, 77, 1, 32, "Input"],
Cell[123241, 3909, 220, 5, 73, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[123498, 3919, 67, 1, 32, "Input"],
Cell[123568, 3922, 222, 5, 88, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[123827, 3932, 137, 2, 55, "Input"],
Cell[123967, 3936, 372, 9, 147, "Output"]
}, Open  ]],
Cell[124354, 3948, 52, 1, 39, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124443, 3954, 169, 5, 111, "Section"],
Cell[124615, 3961, 38150, 1457, 293, 25566, 1297, "GraphicsData", \
"PostScript", "Graphics"],
Cell[162768, 5420, 52, 1, 39, "Input"],

Cell[CellGroupData[{
Cell[162845, 5425, 97, 1, 38, "Input"],
Cell[162945, 5428, 971, 27, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[163953, 5460, 122, 4, 31, "Input"],
Cell[164078, 5466, 767, 23, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[164882, 5494, 284, 5, 124, "Input"],
Cell[165169, 5501, 4480, 119, 90, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[169686, 5625, 262, 5, 124, "Input"],
Cell[169951, 5632, 3040, 83, 90, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[173028, 5720, 92, 1, 32, "Input"],
Cell[173123, 5723, 11486, 261, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[184646, 5989, 80, 1, 32, "Input"],
Cell[184729, 5992, 8928, 201, 73, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[193694, 6198, 75, 1, 32, "Input"],
Cell[193772, 6201, 55, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[193864, 6207, 51, 1, 32, "Input"],
Cell[193918, 6210, 486, 7, 154, "Print",
  CellTags->"Info3262622198-7190958"]
}, Closed]],

Cell[CellGroupData[{
Cell[194441, 6222, 137, 3, 55, "Input"],
Cell[194581, 6227, 3298, 91, 133, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[197916, 6323, 172, 4, 55, "Input"],
Cell[198091, 6329, 473, 9, 55, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[198601, 6343, 52, 1, 32, "Input"],
Cell[198656, 6346, 472, 8, 163, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[199165, 6359, 58, 1, 32, "Input"],
Cell[199226, 6362, 361, 7, 73, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[199624, 6374, 53, 1, 32, "Input"],
Cell[199680, 6377, 358, 5, 106, "Print",
  CellTags->"Info3262622199-2313460"]
}, Closed]],

Cell[CellGroupData[{
Cell[200075, 6387, 77, 1, 32, "Input"],
Cell[200155, 6390, 240, 5, 73, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[200432, 6400, 67, 1, 32, "Input"],
Cell[200502, 6403, 222, 5, 88, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[200761, 6413, 137, 2, 55, "Input"],
Cell[200901, 6417, 392, 9, 168, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[201330, 6431, 119, 2, 32, "Input"],
Cell[201452, 6435, 392, 9, 168, "Output"]
}, Closed]],
Cell[201859, 6447, 52, 1, 32, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[201948, 6453, 170, 5, 79, "Section"],
Cell[202121, 6460, 52, 1, 39, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[202210, 6466, 76, 1, 111, "Section"],

Cell[CellGroupData[{
Cell[202311, 6471, 45, 1, 39, "Input"],
Cell[202359, 6474, 625, 9, 194, "Print",
  CellTags->"Info3262609255-4623449"]
}, Closed]],
Cell[202999, 6486, 74, 1, 32, "Input"],
Cell[203076, 6489, 194, 5, 94, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[203295, 6498, 223, 4, 131, "Input"],
Cell[203521, 6504, 242, 6, 47, "Output"]
}, Closed]],
Cell[203778, 6513, 239, 6, 90, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[204042, 6523, 292, 5, 154, "Input"],
Cell[204337, 6530, 217, 6, 47, "Output"]
}, Closed]],
Cell[204569, 6539, 210, 5, 65, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[204804, 6548, 361, 6, 177, "Input"],
Cell[205168, 6556, 1336, 36, 47, "Output"]
}, Closed]],
Cell[206519, 6595, 249, 5, 65, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[206793, 6604, 456, 8, 200, "Input"],
Cell[207252, 6614, 2732, 75, 47, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[210033, 6695, 76, 1, 111, "Section"],
Cell[210112, 6698, 440, 13, 65, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[210577, 6715, 273, 5, 154, "Input"],
Cell[210853, 6722, 464, 12, 47, "Output"]
}, Closed]],
Cell[211332, 6737, 550, 14, 65, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[211907, 6755, 367, 7, 177, "Input"],
Cell[212277, 6764, 1044, 28, 66, "Output"]
}, Closed]],
Cell[213336, 6795, 633, 16, 65, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[213994, 6815, 473, 9, 200, "Input"],
Cell[214470, 6826, 4591, 117, 109, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[219098, 6948, 68, 1, 32, "Input"],
Cell[219169, 6951, 11551, 262, 191, "Output"]
}, Closed]],
Cell[230735, 7216, 650, 16, 65, "Input",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[231410, 7236, 519, 9, 223, "Input"],
Cell[231932, 7247, 4846, 127, 72, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[236815, 7379, 68, 1, 32, "Input"],
Cell[236886, 7382, 59066, 1191, 667, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

