(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1149699,      25451]*)
(*NotebookOutlinePosition[   1187517,      26747]*)
(*  CellTagsIndexPosition[   1187425,      26741]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Warm-Up Stuff:", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"/home/olness/formcalc"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileNames["\<*\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{"CalcFeynAmp.frm", "CHANGES", "compile", "drivers", 
      "examples", "FC3Guide.ps.gz", "FormCalc32.tar.gz", "FormCalc.m", 
      "fortran", "fortran_sm", "fred_test.nb", "HelicityME.frm", "Linux", 
      "mpi03.pdf", "ReadForm.tm", "README", "ToForm.c", "ToFortran.c", 
      "tools"}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input FeynArts & FormCalc", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< "\</home/olness/feynarts/CODE/FeynArts.m\>"\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"FeynArts 3.1"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn"\)], \
"Print"],

Cell[BoxData[
    \(TraditionalForm\`"last revised 3 Apr 03"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< "\</home/olness/formcalc/FormCalc.m\>"\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"FormCalc 3.2"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"by Thomas Hahn"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"last revised 3 Apr 03"\)], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Defined functions: FeynArts & FormCalc", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FeynArts`*\)\)], "Input"],

Cell[BoxData[GridBox[{
        {
          StyleBox["FeynArts`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["ActualOptions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ActualOptions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FourMomentum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FourMomentum"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$LastGenericRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$LastGenericRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SymmetryFactor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SymmetryFactor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Adjacencies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Adjacencies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FreeWFQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`FreeWFQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$LastModelRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$LastModelRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TadpoleCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TadpoleCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AllBoxCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`AllBoxCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["full",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`full"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$TruncationRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$TruncationRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TadpoleCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TadpoleCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AllBoxes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`AllBoxes"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Full",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Full"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["NonCommutative",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`NonCommutative"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Tadpoles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Tadpoles"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Alph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Alph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["FullFileName",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FullFileName"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["NoUnfold",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`NoUnfold"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TadpolesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TadpolesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AmplitudeLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`AmplitudeLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllClasses",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$AllClasses"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Numbering",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Numbering"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TakeGraph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TakeGraph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AnalyticalCoupling",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`AnalyticalCoupling"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllGeneric",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$AllGeneric"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Outgoing",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Outgoing"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TakeInc",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`TakeInc"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AnalyticalPropagator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`AnalyticalPropagator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllowedFields",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$AllowedFields"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Paint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Paint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TakeIns",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`TakeIns"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AntiParticle",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`AntiParticle"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$AllParticles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$AllParticles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PaintLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PaintLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TheC",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`TheC"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Appearance",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Appearance"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$Classes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$Classes"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Particles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Particles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TheLabel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`TheLabel"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["AutoEdit",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`AutoEdit"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$Generic",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$Generic"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["path",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`path"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TheMass",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`TheMass"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Bicycle",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Bicycle"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["F$Particles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`F$Particles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PickLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PickLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Theta",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Theta"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["BoxCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`BoxCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["G",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`G"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Pluralize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Pluralize"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Three",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Three"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["BoxCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`BoxCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GaugeRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`GaugeRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PossibleFields",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PossibleFields"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ThreeRed",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`ThreeRed"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Boxes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Boxes"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GaugeXi",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`GaugeXi"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PreFactor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PreFactor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToClasses",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ToClasses"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["BoxesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`BoxesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GenericModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`GenericModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Process",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Process"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToFA1Conventions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ToFA1Conventions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CanonicalOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`CanonicalOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GhostDash",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`GhostDash"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Propagator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Propagator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToGeneric",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ToGeneric"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CC",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`CC"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Graph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Graph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorArrow",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PropagatorArrow"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Topology",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Topology"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Centre",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Centre"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["GraphID",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`GraphID"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorDenominator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PropagatorDenominator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TopologyCode",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TopologyCode"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CheckFieldPoint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`CheckFieldPoint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Greek",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Greek"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PropagatorGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TopologyList",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TopologyList"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Classes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Classes"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Incoming",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Incoming"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorLabel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PropagatorLabel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ToTree",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`ToTree"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ColumnsXRows",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ColumnsXRows"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Index",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Index"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PropagatorType",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`PropagatorType"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TriangleCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TriangleCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Compare",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Compare"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["IndexDelta",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`IndexDelta"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PSort",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`PSort"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TriangleCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TriangleCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Compatibles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Compatibles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["IndexRange",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`IndexRange"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["PV",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`PV"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Triangles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Triangles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ComposedChar",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ComposedChar"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["IndexSum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`IndexSum"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["P$Generic",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`P$Generic"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["TrianglesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`TrianglesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ConjugateCoupling",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ConjugateCoupling"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Indices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Indices"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["P$NonCommuting",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`P$NonCommuting"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Truncated",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Truncated"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ContainsQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ContainsQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InitializeModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`InitializeModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["P$Topology",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`P$Topology"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["U",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`U"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateCTTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`CreateCTTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InsertFields",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`InsertFields"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["QuantumNumbers",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`QuantumNumbers"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["UCAlph",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`UCAlph"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateFeynAmp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`CreateFeynAmp"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InsertionLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`InsertionLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ReferenceOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ReferenceOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["UCGreek",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`UCGreek"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`CreateTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Insertions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Insertions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Reinitialize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Reinitialize"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["V",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`V"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CreateVFTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`CreateVFTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["InsertOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`InsertOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["RelativeCF",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`RelativeCF"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Vertex",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Vertex"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["CTOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`CTOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Integral",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Integral"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Render",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Render"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VertexFunction",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`VertexFunction"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Cycles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Cycles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Internal",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Internal"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ResolveLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ResolveLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VertexGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`VertexGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Diagonal",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Diagonal"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`KI1"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["RestrictCurrentModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`RestrictCurrentModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Vertices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Vertices"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["DiagramGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`DiagramGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`KI2"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Restrictions",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Restrictions"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ViolatesQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ViolatesQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["DiagramSelect",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`DiagramSelect"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`KI3"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["S",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`S"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VS",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`VS"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Discard",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Discard"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KI4",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`KI4"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ScalarDash",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ScalarDash"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["VSort",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`VSort"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Eight",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Eight"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KinematicIndices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`KinematicIndices"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfConjugate",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SelfConjugate"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["WFCorrectionCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`WFCorrectionCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ExcludedQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ExcludedQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KinematicVector",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`KinematicVector"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SelfEnergies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["WFCorrections",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`WFCorrections"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ExcludeFieldPoints",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ExcludeFieldPoints"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["KIs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`KIs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergiesOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SelfEnergiesOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$CounterTerms",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$CounterTerms"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ExcludeParticles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ExcludeParticles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["LastSelections",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`LastSelections"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergyCTs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SelfEnergyCTs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ExcludedFPs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$ExcludedFPs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["ExcludeTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ExcludeTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Loop",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Loop"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SelfEnergyCTsOnly",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SelfEnergyCTsOnly"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ExcludedParticleFPs",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$ExcludedParticleFPs"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["External",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`External"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["LoopNumber",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`LoopNumber"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Seq",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Seq"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ExcludeTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$ExcludeTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["F",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`F"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["L$CTOrders",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`L$CTOrders"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Shape",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Shape"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FermionLines",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$FermionLines"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FAPrint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`FAPrint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Mass",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Mass"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["ShapeData",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`ShapeData"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FeynArts",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$FeynArts"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FermionChain",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FermionChain"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MatrixTrace",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`MatrixTrace"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SheetHeader",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SheetHeader"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FeynArtsDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$FeynArtsDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FeynAmp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`FeynAmp"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MatrixTraceFactor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`MatrixTraceFactor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Simple",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Simple"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$FeynArtsProgramDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$FeynArtsProgramDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FeynAmpDenominator",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FeynAmpDenominator"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MixingPartners",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`MixingPartners"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Sine",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Sine"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$GenericModel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$GenericModel"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FeynAmpList",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FeynAmpList"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Model",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Model"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Spinor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Spinor"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$Model",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`$Model"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FeynArtsGraphics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FeynArtsGraphics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Mom",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Mom"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["StartingTopologies",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`StartingTopologies"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ModelPath",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$ModelPath"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["Field",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Field"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["MomentumConservation",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`MomentumConservation"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["StartTop",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`StartTop"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$ShapeDataDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$ShapeDataDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FieldNumbers",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FieldNumbers"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$ClassesDescription",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$ClassesDescription"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Statistics",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`Statistics"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$SVMixing",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`$SVMixing"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FieldPoint",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FieldPoint"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$CouplingMatrices",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$CouplingMatrices"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["Straight",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`Straight"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["$Verbose",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`$Verbose"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"]},
              {
                ButtonBox[
                  StyleBox["FieldPoints",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FieldPoints"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$FlippingRules",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$FlippingRules"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SumOver",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`SumOver"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], ""},
              {
                ButtonBox[
                  StyleBox["file",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`file"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$GenericCouplings",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$GenericCouplings"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SV",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078839-6549882", "FeynArts`SV"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], ""},
              {
                ButtonBox[
                  StyleBox["FindVertex",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`FindVertex"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["M$GenericPropagators",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`M$GenericPropagators"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], 
                ButtonBox[
                  StyleBox["SVCompatibles",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078839-6549882", 
                    "FeynArts`SVCompatibles"},
                  ButtonFrame->"None",
                  ButtonNote->"FeynArts`"], ""}
              },
            
            RowMinHeight->{
              1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  CellMargins->{{20, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->GrayLevel[0.930022],
  ButtonBoxOptions->{Active->True}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FormCalc`*\)\)], "Input"],

Cell[BoxData[GridBox[{
        {
          StyleBox["FormCalc`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["A0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`A0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins102",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins102"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins230",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins230"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins359",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins359"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins487",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins487"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["A0i",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`A0i"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins103",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins103"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins231",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins231"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins36",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins36"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins488",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins488"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["abb",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`abb"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins104",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins104"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins232",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins232"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins360",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins360"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins489",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins489"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Abbr",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Abbr"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins105",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins105"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins233",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins233"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins361",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins361"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins49",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins49"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["AbbrScale",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`AbbrScale"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins106",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins106"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins234",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins234"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins362",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins362"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins490",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins490"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["AbbrToUse",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`AbbrToUse"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins107",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins107"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins235",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins235"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins363",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins363"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins491",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins491"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Amp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Amp"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins108",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins108"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins236",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins236"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins364",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins364"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins492",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins492"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["B0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`B0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins109",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins109"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins237",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins237"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins365",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins365"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins493",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins493"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["B00",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`B00"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins11",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins11"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins238",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins238"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins366",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins366"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins494",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins494"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["B0i",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`B0i"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins110",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins110"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins239",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins239"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins367",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins367"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins495",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins495"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["B1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`B1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins111",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins111"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins24",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins24"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins368",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins368"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins496",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins496"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["B11",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`B11"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins112",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins112"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins240",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins240"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins369",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins369"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins497",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins497"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["C0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`C0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins113",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins113"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins241",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins241"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins37",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins37"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins498",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins498"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["C0i",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`C0i"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins114",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins114"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins242",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins242"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins370",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins370"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins499",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins499"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["CalcFeynAmp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`CalcFeynAmp"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins115",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins115"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins243",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins243"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins371",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins371"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins5",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins5"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["CalcLevel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`CalcLevel"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins116",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins116"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins244",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins244"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins372",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins372"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins50",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins50"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["CalcRenConst",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`CalcRenConst"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins117",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins117"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins245",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins245"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins373",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins373"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins500",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins500"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins118",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins118"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins246",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins246"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins374",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins374"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins51",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins51"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc00",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc00"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins119",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins119"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins247",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins247"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins375",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins375"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins52",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins52"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc001",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc001"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins12",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins12"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins248",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins248"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins376",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins376"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins53",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins53"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc002",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc002"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins120",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins120"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins249",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins249"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins377",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins377"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins54",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins54"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins121",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins121"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins25",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins25"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins378",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins378"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins55",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins55"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc11",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc11"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins122",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins122"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins250",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins250"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins379",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins379"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins56",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins56"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc111",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc111"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins123",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins123"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins251",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins251"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins38",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins38"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins57",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins57"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc112",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc112"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins124",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins124"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins252",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins252"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins380",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins380"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins58",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins58"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc12",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc12"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins125",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins125"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins253",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins253"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins381",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins381"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins59",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins59"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc122",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc122"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins126",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins126"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins254",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins254"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins382",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins382"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins6",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins6"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins127",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins127"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins255",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins255"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins383",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins383"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins60",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins60"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc22",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc22"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins128",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins128"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins256",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins256"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins384",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins384"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins61",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins61"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["cc222",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`cc222"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins129",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins129"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins257",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins257"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins385",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins385"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins62",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins62"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Cget",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Cget"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins13",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins13"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins258",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins258"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins386",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins386"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins63",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins63"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ClearCache",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`ClearCache"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins130",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins130"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins259",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins259"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins387",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins387"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins64",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins64"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ClearProcess",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`ClearProcess"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins131",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins131"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins26",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins26"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins388",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins388"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins65",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins65"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ClearSE",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ClearSE"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins132",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins132"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins260",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins260"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins389",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins389"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins66",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins66"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Cloop",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Cloop"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins133",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins133"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins261",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins261"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins39",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins39"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins67",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins67"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ColourME",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ColourME"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins134",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins134"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins262",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins262"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins390",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins390"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins68",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins68"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["CommonDecl",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`CommonDecl"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins135",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins135"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins263",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins263"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins391",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins391"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins69",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins69"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Ctree",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ctree"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins136",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins136"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins264",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins264"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins392",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins392"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins7",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins7"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Cval",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Cval"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins137",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins137"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins265",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins265"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins393",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins393"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins70",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins70"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["D0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`D0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins138",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins138"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins266",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins266"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins394",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins394"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins71",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins71"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["D0i",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`D0i"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins139",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins139"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins267",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins267"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins395",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins395"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins72",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins72"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DB0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`DB0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins14",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins14"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins268",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins268"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins396",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins396"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins73",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins73"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DB00",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`DB00"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins140",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins140"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins269",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins269"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins397",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins397"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins74",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins74"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DB1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`DB1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins141",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins141"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins27",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins27"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins398",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins398"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins75",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins75"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DB11",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`DB11"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins142",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins142"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins270",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins270"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins399",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins399"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins76",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins76"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dble",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dble"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins143",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins143"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins271",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins271"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins4",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins4"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins77",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins77"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dconjg",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dconjg"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins144",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins144"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins272",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins272"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins40",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins40"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins78",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins78"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins145",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins145"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins273",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins273"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins400",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins400"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins79",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins79"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd00",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd00"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins146",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins146"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins274",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins274"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins401",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins401"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins8",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins8"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0000",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0000"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins147",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins147"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins275",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins275"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins402",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins402"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins80",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins80"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd001",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd001"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins148",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins148"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins276",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins276"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins403",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins403"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins81",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins81"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0011",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0011"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins149",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins149"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins277",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins277"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins404",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins404"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins82",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins82"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0012",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0012"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins15",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins15"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins278",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins278"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins405",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins405"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins83",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins83"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0013",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0013"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins150",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins150"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins279",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins279"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins406",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins406"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins84",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins84"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd002",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd002"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins151",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins151"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins28",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins28"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins407",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins407"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins85",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins85"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0022",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0022"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins152",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins152"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins280",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins280"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins408",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins408"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins86",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins86"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0023",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0023"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins153",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins153"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins281",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins281"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins409",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins409"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins87",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins87"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd003",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd003"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins154",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins154"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins282",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins282"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins41",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins41"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins88",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins88"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd0033",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd0033"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins155",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins155"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins283",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins283"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins410",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins410"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins89",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins89"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins156",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins156"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins284",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins284"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins411",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins411"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins9",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins9"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd11",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd11"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins157",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins157"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins285",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins285"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins412",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins412"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins90",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins90"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd111",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd111"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins158",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins158"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins286",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins286"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins413",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins413"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins91",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins91"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1111",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1111"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins159",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins159"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins287",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins287"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins414",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins414"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins92",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins92"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1112",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1112"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins16",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins16"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins288",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins288"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins415",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins415"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins93",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins93"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1113",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1113"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins160",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins160"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins289",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins289"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins416",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins416"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins94",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins94"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd112",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd112"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins161",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins161"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins29",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins29"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins417",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins417"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins95",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins95"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1122",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1122"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins162",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins162"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins290",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins290"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins418",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins418"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins96",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins96"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1123",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1123"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins163",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins163"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins291",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins291"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins419",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins419"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins97",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins97"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd113",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd113"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins164",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins164"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins292",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins292"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins42",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins42"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins98",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins98"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1133",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1133"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins165",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins165"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins293",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins293"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins420",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins420"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins99",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins99"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd12",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd12"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins166",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins166"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins294",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins294"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins421",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins421"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["InsertFieldsHook",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`InsertFieldsHook"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd122",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd122"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins167",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins167"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins295",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins295"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins422",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins422"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1222",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1222"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins168",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins168"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins296",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins296"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins423",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins423"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1223",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1223"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins169",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins169"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins297",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins297"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins424",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins424"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k1$",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k1$"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd123",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd123"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins17",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins17"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins298",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins298"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins425",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins425"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1233",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1233"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins170",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins170"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins299",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins299"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins426",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins426"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k2$",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k2$"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd13",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd13"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins171",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins171"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins3"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins427",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins427"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k3"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd133",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd133"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins172",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins172"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins30",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins30"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins428",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins428"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k4",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k4"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd1333",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd1333"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins173",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins173"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins300",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins300"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins429",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins429"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k5",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k5"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins174",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins174"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins301",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins301"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins43",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins43"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k6",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k6"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd22",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd22"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins175",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins175"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins302",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins302"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins430",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins430"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k7",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k7"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd222",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd222"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins176",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins176"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins303",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins303"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins431",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins431"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k8",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k8"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd2222",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd2222"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins177",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins177"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins304",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins304"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins432",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins432"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["k$",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`k$"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd2223",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd2223"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins178",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins178"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins305",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins305"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins433",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins433"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["LoopSquare",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`LoopSquare"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd223",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd223"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins179",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins179"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins306",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins306"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins434",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins434"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Lor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Lor"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd2233",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd2233"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins18",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins18"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins307",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins307"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins435",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins435"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Mandelstam",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`Mandelstam"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd23",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd23"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins180",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins180"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins308",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins308"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins436",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins436"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Mat",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Mat"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd233",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd233"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins181",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins181"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins309",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins309"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins437",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins437"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["MomSimplify",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`MomSimplify"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd2333",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd2333"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins182",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins182"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins31",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins31"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins438",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins438"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Newline",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Newline"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd3"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins183",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins183"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins310",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins310"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins439",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins439"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["NoExpand",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`NoExpand"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd33",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd33"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins184",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins184"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins311",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins311"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins44",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins44"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["NoIns",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`NoIns"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd333",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd333"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins185",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins185"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins312",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins312"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins440",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins440"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Normalized",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`Normalized"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dd3333",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dd3333"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins186",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins186"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins313",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins313"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins441",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins441"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["OffShell",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`OffShell"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Delta",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Delta"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins187",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins187"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins314",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins314"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins442",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins442"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["OnePassOrder",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`OnePassOrder"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Den",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Den"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins188",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins188"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins315",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins315"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins443",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins443"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["OnShell",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`OnShell"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Dget",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Dget"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins189",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins189"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins316",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins316"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins444",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins444"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["OpenFortran",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`OpenFortran"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DiagramType",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`DiagramType"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins19",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins19"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins317",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins317"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins445",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins445"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Optimize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Optimize"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Dim",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Dim"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins190",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins190"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins318",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins318"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins446",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins446"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["OptimizeAbbr",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`OptimizeAbbr"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["dimag",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`dimag"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins191",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins191"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins319",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins319"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins447",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins447"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Pair",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Pair"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Dimension",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`Dimension"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins192",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins192"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins32",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins32"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins448",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins448"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["pave",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`pave"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DiracChain",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`DiracChain"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins193",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins193"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins320",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins320"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins449",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins449"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["PaVe",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`PaVe"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Divergence",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`Divergence"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins194",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins194"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins321",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins321"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins45",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins45"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["q1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`q1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["DoLoop",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`DoLoop"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins195",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins195"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins322",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins322"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins450",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins450"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["ReadForm",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ReadForm"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Drivers",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Drivers"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins196",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins196"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins323",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins323"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins451",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins451"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["RealQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`RealQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Dval",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Dval"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins197",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins197"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins324",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins324"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins452",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins452"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["RenConstFile",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`RenConstFile"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["d$",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`d$"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins198",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins198"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins325",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins325"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins453",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins453"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Result",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Result"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins199",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins199"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins326",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins326"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins454",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins454"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["RetainFile",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`RetainFile"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["E0i",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`E0i"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins327",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins327"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins455",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins455"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["s",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`s"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins20",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins20"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins328",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins328"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins456",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins456"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SInvariant",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`SInvariant"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins200",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins200"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins329",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins329"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins457",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins457"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SizeSplit",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`SizeSplit"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e3"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins201",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins201"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins33",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins33"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins458",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins458"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Small",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Small"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e4",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e4"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins202",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins202"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins330",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins330"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins459",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins459"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SplitSums",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`SplitSums"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e5",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e5"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins203",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins203"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins331",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins331"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins46",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins46"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["sqrt2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`sqrt2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e6",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e6"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins204",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins204"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins332",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins332"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins460",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins460"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SquaredME",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`SquaredME"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e7",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e7"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins205",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins205"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins333",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins333"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins461",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins461"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SubroutineDecl",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`SubroutineDecl"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e8",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e8"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins206",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins206"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins334",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins334"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins462",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins462"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["sun",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`sun"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins207",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins207"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins335",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins335"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins463",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins463"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SUNN",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`SUNN"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins208",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins208"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins336",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins336"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins464",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins464"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["SymbolPrefix",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`SymbolPrefix"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec2",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec2"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins209",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins209"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins337",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins337"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins465",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins465"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["s$",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`s$"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec3",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec3"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins21",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins21"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins338",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins338"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins466",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins466"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["T",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`T"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec4",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec4"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins210",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins210"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins339",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins339"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins467",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins467"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["TimeStamp",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`TimeStamp"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec5",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec5"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins211",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins211"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins34",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins34"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins468",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins468"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["TInvariant",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`TInvariant"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec6",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec6"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins212",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins212"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins340",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins340"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins469",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins469"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["ToDoLoops",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`ToDoLoops"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec7",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec7"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins213",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins213"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins341",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins341"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins47",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins47"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["ToFortran",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`ToFortran"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["ec8",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`ec8"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins214",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins214"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins342",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins342"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins470",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins470"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Transverse",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`Transverse"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["EditCode",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`EditCode"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins215",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins215"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins343",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins343"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins471",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins471"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["UVDivergentPart",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`UVDivergentPart"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Eps",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Eps"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins216",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins216"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins344",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins344"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins472",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins472"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["VADecompose",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`VADecompose"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["e$",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`e$"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins217",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins217"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins345",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins345"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins473",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins473"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["VarDecl",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`VarDecl"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FermionicQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FermionicQ"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins218",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins218"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins346",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins346"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins474",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins474"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["WriteDoLoops",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`WriteDoLoops"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FeynCalcGet",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FeynCalcGet"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins219",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins219"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins347",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins347"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins475",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins475"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["WriteExpr",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`WriteExpr"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FeynCalcPut",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FeynCalcPut"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins22",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins22"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins348",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins348"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins476",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins476"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["WriteRenConst",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`WriteRenConst"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FinalTouch",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FinalTouch"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins220",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins220"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins349",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins349"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins477",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins477"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["WriteSquaredME",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`WriteSquaredME"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FindRenConst",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FindRenConst"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins221",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins221"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins35",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins35"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins478",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins478"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["WriteSummedExpr",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`WriteSummedExpr"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["fme",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`fme"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins222",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins222"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins350",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins350"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins479",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins479"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$BlockSize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`$BlockSize"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FormSetup",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FormSetup"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins223",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins223"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins351",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins351"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins48",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins48"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$DriversDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`$DriversDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["FormSubst",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`FormSubst"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins224",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins224"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins352",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins352"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins480",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins480"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$Editor",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`$Editor"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Hel",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Hel"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins225",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins225"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins353",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins353"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins481",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins481"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$FileSize",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`$FileSize"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["HelicityME",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`HelicityME"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins226",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins226"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins354",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins354"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins482",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins482"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$FormCalc",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`$FormCalc"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Ins1",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins1"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins227",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins227"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins355",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins355"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins483",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins483"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$FormCalcDir",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262078840-4907770", 
                    "FormCalc`$FormCalcDir"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Ins10",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins10"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins228",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins228"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins356",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins356"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins484",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins484"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$FormCmd",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`$FormCmd"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Ins100",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins100"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins229",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins229"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins357",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins357"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins485",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins485"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["$PaintSE",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`$PaintSE"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"]},
              {
                ButtonBox[
                  StyleBox["Ins101",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins101"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins23",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins23"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins358",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins358"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], 
                ButtonBox[
                  StyleBox["Ins486",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262078840-4907770", "FormCalc`Ins486"},
                  ButtonFrame->"None",
                  ButtonNote->"FormCalc`"], ""}
              },
            
            RowMinHeight->{
              1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  CellMargins->{{20, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->GrayLevel[0.930022],
  ButtonBoxOptions->{Active->True}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Comput: u ub -> e+e-", "Section"],

Cell[BoxData[
    \(ClearProcess[]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(tops = 
        CreateTopologies[0, 4, ExcludeTopologies \[Rule] {}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[
          tops, {F[3, {1}], \(-F[3, {1}]\)} \[Rule] {F[
                2, {1}], \(-F[2, {1}]\)}, Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}, 
          ExcludeParticles \[Rule] {{V[2], S[1], S[2], 
                S[3]}}];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(Paint[ins, ColumnsXRows \[Rule] 2, 
      PaintLevel \[Rule] {Classes}]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Excluding "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]5\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]5\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Excluding ", 0, " Generic, ", 5, " Classes, and ", 5, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 4, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"1 Classes \
insertion"\),
        SequenceForm[ "in total: ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Restoring "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]5\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]5\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Restoring ", 0, " Generic, ", 5, " Classes, and ", 5, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.15 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 4.22839e-18 0.0227273 [
[ 0 0 0 0 ]
[ 1 1.15 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.15 L
0 1.15 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 0.5 0.5 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.31818 .5 L
s
.20277 .59618 m
.14923 .61713 L
.17251 .64506 L
F
gsave
.16421 .587 -72.9375 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.31818 .5 L
s
.16087 .3689 m
.21441 .38986 L
.19113 .41779 L
F
gsave
.19943 .35973 -61 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.68182 .5 L
s
.83913 .6311 m
.78559 .61014 L
.80887 .58221 L
F
gsave
.80057 .64027 -72.9375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.68182 .5 L
s
.79723 .40382 m
.85077 .38287 L
.82749 .35494 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -66.7812 -16.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -87.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.9375 translate 1 -1 scale
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
79.375 13.375 moveto
(C1) show
97.062 13.375 moveto
(N1) show
111.625 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 1.09 -67.75 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.500 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 1.09 -67.75 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.500 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 1.09 -70.0312 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.938 moveto
(\\256) show
77.062 13.938 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 1.09 -67.75 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.500 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 1.09 -67.75 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.500 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{250.375, 287.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003j00017b000`400?l00000o`00003onP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo00050?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0
P03oool000H0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`210?ooo`001`3oool0
0`000000oooo0?ooo`1[0?ooo`030000003oool0oooo0880oooo00080?ooo`800000J@3oool20000
08D0oooo000:0?ooo`030000003oool0oooo00l0oooo0`0000000`3oool000000?ooo`1@0?ooo`03
0000003oool0oooo08D0oooo000;0?ooo`030000003oool0oooo00d0oooo0P0000020?ooo`800000
D03oool00`000000oooo0?ooo`260?ooo`00303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`270?ooo`003@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0C03oool0
0`000000oooo0?ooo`280?ooo`003P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`290?ooo`003`3oool2000000X0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`190?ooo`800000S03oool00140oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0S03oool00180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0S@3oool001<0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0000002@0?ooo`00503oool2000002D0oooo00<000000?oo
o`3oool0:03oool300000940oooo000E0?ooo`<000008`3oool2000002P0oooo1@00002@0?ooo`00
5P3oool400000280oooo00<000000?ooo`3oool09P3oool300000980oooo000F0?ooo`<00000903o
ool00`000000oooo0?ooo`0T0?ooo`800000U03oool001L0oooo00<000000?ooo`0000008`3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo09@0oooo000J0?ooo`030000003oool0oooo
0200oooo0P00000S0?ooo`030000003oool0oooo09D0oooo000K0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`0000008@3oool00`000000oooo0?ooo`2F0?ooo`00703oool2000001l0oooo
00<000000?ooo`0000007`3oool2000009T0oooo000N0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool00P0000020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool02`3o
ool4000008X0oooo000O0?ooo`030000003oool0oooo01P0oooo0`0000030?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool02`3oool200000080oooo0P0000290?ooo`00803oool00`00
0000oooo0?ooo`0i0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0S03oool00240
oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo08`0
oooo000R0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool03P3oool6000008T0oooo
000S0?ooo`800000<`3oool200000140oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`270?ooo`009@3oool00`000000oooo0?ooo`060?ooo`800000203oool2000000P0oooo0`000008
0?ooo`800000203oool00`000000oooo0?ooo`0A0?ooo`8000000P3oool2000008T0oooo000V0?oo
o`<00000103oool00`000000oooo0?ooo`02000000D0oooo0P0000000`3oool00000000000050?oo
o`80000000<0oooo0000000000001@3oool2000000030?ooo`000000000000@0oooo0`00000E0?oo
o`@00000RP3oool002D0oooo100000030?ooo`030000003oool0oooo0080oooo0P0000030?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`8000000`3oool00`00
0000oooo0?ooo`020?ooo`8000000P3oool400000:<0oooo000V0?ooo`H000001`3oool3000000L0
oooo0`0000060?ooo`@000001`3oool600000:<0oooo000T0?ooo`80000000<0oooo0000003oool0
;03oool010000000oooo00000000002Q0?ooo`00303oool3000000030?ooo`000000oooo0140oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2N0?ooo`002`3oool200000080oooo0P00
000A0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0W@3oool000/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03L0oooo00<00000
0?ooo`3oool0W03oool000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool0V`3oool000/0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0;0?ooo`800000?@3oool2000009/0oooo000;0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0o0?ooo`030000
003oool0oooo09P0oooo000;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`110?ooo`030000003oool0oooo09L0oooo000;0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`130?ooo`030000003oool0
oooo09H0oooo000J0?ooo`030000003oool0oooo04D0oooo0`00002E0?ooo`00603oool2000004P0
oooo1000002D0?ooo`005P3oool3000004P0oooo1@00002D0?ooo`004P3oool6000004`0oooo0`00
002C0?ooo`004`3oool4000004l0oooo0P00002B0?ooo`004`3oool400000540oooo0P00002@0?oo
o`004P3oool010000000oooo0?ooo`00001D0?ooo`030000003oool0oooo08d0oooo000A0?ooo`03
0000003oool0oooo05L0oooo00<000000?ooo`3oool0S03oool00100oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`2;0?ooo`003`3oool00`000000oooo0?ooo`1K0?ooo`030000003o
ool0oooo08X0oooo000=0?ooo`800000C03oool4000000l0oooo0P00002:0?ooo`00303oool00`00
0000oooo0?ooo`1;0?ooo`8000000P3oool200000100oooo00<000000?ooo`3oool0Q`3oool000/0
oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo08H0
oooo000:0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`250?ooo`002@3oool00`000000oooo0?ooo`1>0?ooo`H000004`3oool00`000000oooo0?oo
o`240?ooo`001`3oool200000540oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0B
0?ooo`800000Q03oool000H0oooo00<000000?ooo`3oool0D@3oool200000080oooo0P00000F0?oo
o`030000003oool0oooo0840oooo00050?ooo`030000003oool0oooo05<0oooo1000000H0?ooo`03
0000003oool0oooo0800oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00001\
\>"],
  ImageRangeCache->{{{0, 249.375}, {286.875, 0}} -> {-0.000220002, \
-0.00852375, 0.176443, 0.176443}, {{0, 124.688}, {162.125, 37.4375}} -> \
{-1.00011, -23.0114, 0.176443, 0.176443}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(FeynArtsGraphics({"u", "u"} \[Rule] {"e", "e"})\), 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          TagBox[
            RowBox[{"(", "\[NoBreak]", GridBox[{
                  {
                    FormBox[
                      
                      InterpretationBox[\("["\[InvisibleSpace]"T1 C1 N1"\
\[InvisibleSpace]"]"\),
                        SequenceForm[ "[", "T1 C1 N1", "]"],
                        Editable->False],
                      "TraditionalForm"], "Null"},
                  {"Null", "Null"}
                  }], "\[NoBreak]", ")"}],
            Function[ BoxForm`e$, 
              MatrixForm[ BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(amps\  = \ CreateFeynAmp[ins]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"1 Classes \
amplitude"\),
        SequenceForm[ "in total: ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), ",", 
            RowBox[{"ExcludeParticles", "\[Rule]", 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(V(2)\), \(S(1)\), \(S(2)\), \(S(3)\)}
                    }], "\[NoBreak]", ")"}]}], 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(-\(F(3, {1})\)\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MU"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(2, {1})\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "ME"},
                      {\(-\(F(2, {1})\)\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "ME"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{"FeynAmp", "(", 
            
            RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                Number == 1)\), ",", \(Integral()\), ",", 
              RowBox[{
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        
                        RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                          "EL", " ", 
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox["\<\"ga\"\>",
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[\("Lor"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    
                                    RowBox[{"\<\"om\"\>", "\[InvisibleSpace]",
                                       
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"]}], "-", 
                        
                        RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                          " ", 
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox["\<\"ga\"\>",
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[\("Lor"\[InvisibleSpace]1\
\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    
                                    RowBox[{"\<\"om\"\>", "\[InvisibleSpace]",
                                       
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"]}]}], ")"}], ".", 
                    RowBox[{"\<\"u\"\>", "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "MU"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("u"\&"_"\), "(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], ")"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox["\<\"ga\"\>",
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[\("Lor"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    
                                    RowBox[{"\<\"om\"\>", "\[InvisibleSpace]",
                                       
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"]}], "+", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox["\<\"ga\"\>",
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[\("Lor"\[InvisibleSpace]2\
\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    
                                    RowBox[{"\<\"om\"\>", "\[InvisibleSpace]",
                                       
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"]}]}], ")"}], ".", 
                    RowBox[{"\<\"v\"\>", "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                RowBox[{"IndexDelta", "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Col"\[InvisibleSpace]1\),
                        SequenceForm[ "Col", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Col"\[InvisibleSpace]2\),
                        SequenceForm[ "Col", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                RowBox[{
                  FormBox["\<\"g\"\>",
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]1\),
                              SequenceForm[ "k", 1],
                              Editable->False],
                            "TraditionalForm"], "+", 
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]2\),
                              SequenceForm[ "k", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], "2"]],
                  "TraditionalForm"], " ", 
                RowBox[{"SumOver", "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Col"\[InvisibleSpace]1\),
                        SequenceForm[ "Col", 1],
                        Editable->False],
                      "TraditionalForm"], ",", "3", ",", "External"}], ")"}], 
                " ", 
                RowBox[{"SumOver", "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Col"\[InvisibleSpace]2\),
                        SequenceForm[ "Col", 2],
                        Editable->False],
                      "TraditionalForm"], ",", "3", ",", "External"}], 
                  ")"}]}]}], ")"}], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat = CalcFeynAmp[amps]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("preparing FORM code in \
"\[InvisibleSpace]"/tmp/m4.frm"\),
        SequenceForm[ "preparing FORM code in ", "/tmp/m4.frm"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]0\[InvisibleSpace]" amplitudes \
with insertions"\),
        SequenceForm[ "> ", 0, " amplitudes with insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]1\[InvisibleSpace]" amplitudes \
without insertions"\),
        SequenceForm[ "> ", 1, " amplitudes without insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell["running FORM... ", "Print"],

Cell[BoxData[
    \(TraditionalForm\`"ok"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\(Amp({MU, MU} \[Rule] {ME, 
            ME})\)\[InvisibleApplication] \((8\/3\ Alfa\ \[Pi]\ \(Den(S, 
              0)\)\ \(Mat(F1\ SUN1)\) + 
          8\/3\ Alfa\ \[Pi]\ \(Den(S, 0)\)\ \(Mat(F2\ SUN1)\) + 
          8\/3\ Alfa\ \[Pi]\ \(Den(S, 0)\)\ \(Mat(F3\ SUN1)\) + 
          8\/3\ Alfa\ \[Pi]\ \(Den(S, 0)\)\ \(Mat(F4\ SUN1)\))\)\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(Hel[_] = 0;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(hRule\)\(=\)\(\ \)\(HelicityME[mat, mat]\)\(\ \ \)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("preparing FORM code in \
"\[InvisibleSpace]"/tmp/m4.frm"\),
        SequenceForm[ "preparing FORM code in ", "/tmp/m4.frm"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]16\[InvisibleSpace]" helicity \
matrix elements"\),
        SequenceForm[ "> ", 16, " helicity matrix elements"],
        Editable->False], TraditionalForm]], "Print"],

Cell["running FORM... ", "Print"],

Cell[BoxData[
    \(TraditionalForm\`"ok"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{Mat(F1, F1) \[Rule] 1\/4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F1, F2) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F1, F3) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F1, F4) \[Rule] ME2\ MU2, 
      Mat(F2, F1) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F2, F2) \[Rule] 1\/4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F2, F3) \[Rule] ME2\ MU2, 
      Mat(F2, F4) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F1) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F2) \[Rule] ME2\ MU2, 
      Mat(F3, F3) \[Rule] 1\/4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F3, F4) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F4, F1) \[Rule] ME2\ MU2, 
      Mat(F4, F2) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F4, F3) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F4, F4) \[Rule] 1\/4\ \((ME2 + MU2 - U)\)\^2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cRule = ColourME[mat, mat]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{Mat(SUN1, SUN1) \[Rule] 3}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(allRules = \ Join[hRule, cRule]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{Mat(F1, F1) \[Rule] 1\/4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F1, F2) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F1, F3) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F1, F4) \[Rule] ME2\ MU2, 
      Mat(F2, F1) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F2, F2) \[Rule] 1\/4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F2, F3) \[Rule] ME2\ MU2, 
      Mat(F2, F4) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F1) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F2) \[Rule] ME2\ MU2, 
      Mat(F3, F3) \[Rule] 1\/4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F3, F4) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F4, F1) \[Rule] ME2\ MU2, 
      Mat(F4, F2) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F4, F3) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F4, F4) \[Rule] 1\/4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(SUN1, SUN1) \[Rule] 3}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fredRules = {ME2 \[Rule] 0, \ MU2 \[Rule] 0, \ 
        Alfa2\  \[Rule] \[Alpha]^2, \ 
        Den[a_, b_] \[RuleDelayed] \ 1/\((a - b)\)}\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{ME2 \[Rule] 0, MU2 \[Rule] 0, 
      Alfa2 \[Rule] \[Alpha]\^2, 
      Den(a_, b_) \[RuleDelayed] 1\/\(a - b\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SquaredME[mat]\  //. \ allRules\) //. fredRules\  // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(32\ \[Pi]\^2\ \((T\^2 + U\^2)\)\ \[Alpha]\^2\)\/\(3\ \
S\^2\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?WriteSquaredME\)\)], "Input"],

Cell[BoxData[
    \("WriteSquaredME[tree, loop, me, abbr, ..., dir] writes out Fortran code \
to compute the squared matrix element for a process whose tree-level and \
one-loop contributions are given in the first and second argument, \
respectively.  All further arguments except the last specify the necessary \
matrix elements and abbreviations.  The last argument dir finally gives the \
path to write the generated code to."\)], "Print",
  CellTags->"Info3262600806-6362833"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(WriteSquaredME[mat, {}, hRule, cRule, Abbr[], "\<fortran\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{"/home/olness/formcalc/fortran/1to2.F", 
      "/home/olness/formcalc/fortran/1to2.h", 
      "/home/olness/formcalc/fortran/2to2.F", 
      "/home/olness/formcalc/fortran/2to2.h", 
      "/home/olness/formcalc/fortran/2to3.F", 
      "/home/olness/formcalc/fortran/2to3.h", 
      "/home/olness/formcalc/fortran/abbr_angle.F", 
      "/home/olness/formcalc/fortran/abbr_s.F", 
      "/home/olness/formcalc/fortran/configure", 
      "/home/olness/formcalc/fortran/dcuhre.f", 
      "/home/olness/formcalc/fortran/diag.F", 
      "/home/olness/formcalc/fortran/gausspoints.F", 
      "/home/olness/formcalc/fortran/GNUmakefile.in", 
      "/home/olness/formcalc/fortran/mat.F", 
      "/home/olness/formcalc/fortran/model.h", 
      "/home/olness/formcalc/fortran/mssm_ini.F", 
      "/home/olness/formcalc/fortran/multigauss.F", 
      "/home/olness/formcalc/fortran/num.F", 
      "/home/olness/formcalc/fortran/num.h", 
      "/home/olness/formcalc/fortran/prefix.h", 
      "/home/olness/formcalc/fortran/process.h", 
      "/home/olness/formcalc/fortran/rc_zero.F", 
      "/home/olness/formcalc/fortran/run.F", 
      "/home/olness/formcalc/fortran/sm_ini.F", 
      "/home/olness/formcalc/fortran/squared_me.F", 
      "/home/olness/formcalc/fortran/turnoff", 
      "/home/olness/formcalc/fortran/vars.h", 
      "/home/olness/formcalc/fortran/vegas.F"}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Comput: u ub -> e+e-:  1- loop", "Section"],

Cell[BoxData[
    \(ClearProcess[]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(tops = 
        CreateTopologies[1, 4, 
          ExcludeTopologies \[Rule] {Internal}];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(ins = 
        InsertFields[
          tops, {F[3, {1}], \(-F[3, {1}]\)} \[Rule] {F[
                2, {1}], \(-F[2, {1}]\)}, Model \[Rule] SMQCD, 
          InsertionLevel \[Rule] {Classes}, 
          ExcludeParticles \[Rule] {{V[2], S[1], S[2], S[3]}}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(Paint[ins, ColumnsXRows \[Rule] 2, 
      PaintLevel \[Rule] {Classes}]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("initializing generic model file \
"\[InvisibleSpace]"/home/olness/feynarts/CODE/Models/Lorentz.gen"\),
        SequenceForm[ 
        "initializing generic model file ", 
          "/home/olness/feynarts/CODE/Models/Lorentz.gen"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"> $SVMixing is OFF"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("generic model "\[InvisibleSpace]"Lorentz"\
\[InvisibleSpace]" initialized"\),
        SequenceForm[ "generic model ", "Lorentz", " initialized"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("initializing classes model file \
"\[InvisibleSpace]"/home/olness/feynarts/CODE/Models/SMQCD.mod"\),
        SequenceForm[ 
        "initializing classes model file ", 
          "/home/olness/feynarts/CODE/Models/SMQCD.mod"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]49\[InvisibleSpace]" particles \
(incl. antiparticles) in "\[InvisibleSpace]18\[InvisibleSpace]" classes"\),
        SequenceForm[ 
        "> ", 49, " particles (incl. antiparticles) in ", 18, " classes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"> $CounterTerms are ON"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]93\[InvisibleSpace]" vertices"\
\),
        SequenceForm[ "> ", 93, " vertices"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]120\[InvisibleSpace]" counter \
terms of order 1"\),
        SequenceForm[ "> ", 120, " counter terms of order 1"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]6\[InvisibleSpace]" counter \
terms of order 2"\),
        SequenceForm[ "> ", 6, " counter terms of order 2"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("classes model "\[InvisibleSpace]"SMQCD"\
\[InvisibleSpace]" initialized"\),
        SequenceForm[ "classes model ", "SMQCD", " initialized"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Excluding "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]5\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]5\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Excluding ", 0, " Generic, ", 5, " Classes, and ", 5, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 4, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]5\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 5, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]6\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 6, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]7\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 7, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]8\[InvisibleSpace]": "\
\[InvisibleSpace]"2 Classes insertions"\),
        SequenceForm[ "> Top. ", 8, ": ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]9\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 9, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]10\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 10, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]11\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 11, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]12\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 12, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"3 Classes insertions"\
\),
        SequenceForm[ "in total: ", "3 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Restoring "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]5\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]5\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Restoring ", 0, " Generic, ", 5, " Classes, and ", 5, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"2 diagrams"\),
        SequenceForm[ "> Top. ", 2, ": ", "2 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.15 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 4.22839e-18 0.0227273 [
[ 0 0 0 0 ]
[ 1 1.15 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.15 L
0 1.15 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 0.5 0.5 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.34091 .65909 L
s
.21976 .68705 m
.16252 .6816 L
.1707 .71703 L
F
gsave
.20902 .73434 -66.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.16661 .30069 m
.22384 .29523 L
.21567 .33067 L
F
gsave
.20902 .26566 -66.9688 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.65909 .65909 L
s
.83339 .69931 m
.77616 .70477 L
.78433 .66933 L
F
gsave
.79098 .73434 -66.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .34091 L
s
.78024 .31295 m
.83748 .3184 L
.8293 .28297 L
F
gsave
.79098 .26566 -66.9688 -15.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .47273 m
.32273 .52727 L
.35909 .52727 L
F
gsave
.29795 .5 -72.9375 -9.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65454 .66356 L
.65 .6673 L
.64545 .66973 L
.64091 .67044 L
.63636 .66933 L
.63182 .66656 L
.62727 .6626 L
.62273 .65807 L
.61818 .6537 L
.61364 .6502 L
.60909 .64813 L
.60455 .64782 L
.6 .64933 L
.59546 .6524 L
.59091 .65655 L
.58636 .66111 L
.58182 .66534 L
.57727 .66856 L
.57273 .67026 L
.56818 .67016 L
.56364 .66827 L
.55909 .66491 L
.55455 .6606 L
.55 .65606 L
.54545 .65199 L
.54091 .64907 L
.53636 .64776 L
.53182 .64827 L
.52727 .65052 L
.52273 .65415 L
.51818 .65857 L
.51364 .66307 L
.50909 .66693 L
.50455 .66953 L
.5 .67044 L
.49545 .66953 L
.49091 .66693 L
.48636 .66307 L
.48182 .65857 L
.47727 .65415 L
.47273 .65052 L
.46818 .64827 L
.46364 .64776 L
.45909 .64907 L
.45455 .65199 L
.45 .65606 L
.44545 .6606 L
.44091 .66491 L
.43636 .66827 L
Mistroke
.43182 .67016 L
.42727 .67026 L
.42273 .66856 L
.41818 .66534 L
.41364 .66111 L
.40909 .65655 L
.40454 .6524 L
.4 .64933 L
.39545 .64782 L
.39091 .64813 L
.38636 .6502 L
.38182 .6537 L
.37727 .65807 L
.37273 .6626 L
.36818 .66656 L
.36364 .66933 L
.35909 .67044 L
.35455 .66973 L
.35 .6673 L
.34546 .66356 L
.34091 .65909 L
Mfstroke
gsave
.5 .70205 -66.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
gsave
.5 .29795 -66.7812 -16.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65909 .34091 L
s
.65909 .52727 m
.64091 .47273 L
.67727 .47273 L
F
gsave
.70205 .5 -61 -9.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .65909 Mdot
.65909 .34091 Mdot
gsave
.5 .02273 -87.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.9375 translate 1 -1 scale
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
79.375 13.375 moveto
(C1) show
97.062 13.375 moveto
(N1) show
111.625 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.5 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.34091 .65909 L
s
.21976 .68705 m
.16252 .6816 L
.1707 .71703 L
F
gsave
.20902 .73434 -66.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.16661 .30069 m
.22384 .29523 L
.21567 .33067 L
F
gsave
.20902 .26566 -66.9688 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.65909 .34091 L
s
.82339 .55576 m
.77581 .52347 L
.80469 .50138 L
F
gsave
.86846 .66805 -72.9375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.79025 .48757 m
.83783 .45529 L
.80894 .4332 L
F
gsave
.86165 .34332 -72.9375 -15.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .47273 m
.32273 .52727 L
.35909 .52727 L
F
gsave
.29795 .5 -72.9375 -9.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .65909 m
.65454 .66356 L
.65 .6673 L
.64545 .66973 L
.64091 .67044 L
.63636 .66933 L
.63182 .66656 L
.62727 .6626 L
.62273 .65807 L
.61818 .6537 L
.61364 .6502 L
.60909 .64813 L
.60455 .64782 L
.6 .64933 L
.59546 .6524 L
.59091 .65655 L
.58636 .66111 L
.58182 .66534 L
.57727 .66856 L
.57273 .67026 L
.56818 .67016 L
.56364 .66827 L
.55909 .66491 L
.55455 .6606 L
.55 .65606 L
.54545 .65199 L
.54091 .64907 L
.53636 .64776 L
.53182 .64827 L
.52727 .65052 L
.52273 .65415 L
.51818 .65857 L
.51364 .66307 L
.50909 .66693 L
.50455 .66953 L
.5 .67044 L
.49545 .66953 L
.49091 .66693 L
.48636 .66307 L
.48182 .65857 L
.47727 .65415 L
.47273 .65052 L
.46818 .64827 L
.46364 .64776 L
.45909 .64907 L
.45455 .65199 L
.45 .65606 L
.44545 .6606 L
.44091 .66491 L
.43636 .66827 L
Mistroke
.43182 .67016 L
.42727 .67026 L
.42273 .66856 L
.41818 .66534 L
.41364 .66111 L
.40909 .65655 L
.40454 .6524 L
.4 .64933 L
.39545 .64782 L
.39091 .64813 L
.38636 .6502 L
.38182 .6537 L
.37727 .65807 L
.37273 .6626 L
.36818 .66656 L
.36364 .66933 L
.35909 .67044 L
.35455 .66973 L
.35 .6673 L
.34546 .66356 L
.34091 .65909 L
Mfstroke
gsave
.5 .70205 -66.7812 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
gsave
.5 .29795 -66.7812 -16.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65909 .65909 L
s
.65909 .47273 m
.67727 .52727 L
.64091 .52727 L
F
gsave
.61613 .5 -72.9375 -9.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -87.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.9375 translate 1 -1 scale
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
79.375 13.375 moveto
(C1) show
97.062 13.375 moveto
(N2) show
111.625 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
-1.38778e-17 4.22839e-18 0.5 0.5 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.34091 .65909 L
s
.21976 .68705 m
.16252 .6816 L
.1707 .71703 L
F
gsave
.20902 .73434 -66.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04545 .27273 m
.34091 .34091 L
s
.16661 .30069 m
.22384 .29523 L
.21567 .33067 L
F
gsave
.20902 .26566 -66.9688 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.65909 .34091 L
s
.82339 .55576 m
.77581 .52347 L
.80469 .50138 L
F
gsave
.86846 .66805 -72.9375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .27273 m
.65909 .65909 L
s
.79025 .48757 m
.83783 .45529 L
.80894 .4332 L
F
gsave
.86165 .34332 -72.9375 -15.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.25 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34091 .65909 m
.34091 .34091 L
s
.34091 .47273 m
.32273 .52727 L
.35909 .52727 L
F
gsave
.29795 .5 -76.25 -11.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.5 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
70.938 17.500 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
1.000 setlinewidth
grestore
.65909 .65909 m
.65454 .66356 L
.65 .6673 L
.64545 .66973 L
.64091 .67044 L
.63636 .66933 L
.63182 .66656 L
.62727 .6626 L
.62273 .65807 L
.61818 .6537 L
.61364 .6502 L
.60909 .64813 L
.60455 .64782 L
.6 .64933 L
.59546 .6524 L
.59091 .65655 L
.58636 .66111 L
.58182 .66534 L
.57727 .66856 L
.57273 .67026 L
.56818 .67016 L
.56364 .66827 L
.55909 .66491 L
.55455 .6606 L
.55 .65606 L
.54545 .65199 L
.54091 .64907 L
.53636 .64776 L
.53182 .64827 L
.52727 .65052 L
.52273 .65415 L
.51818 .65857 L
.51364 .66307 L
.50909 .66693 L
.50455 .66953 L
.5 .67044 L
.49545 .66953 L
.49091 .66693 L
.48636 .66307 L
.48182 .65857 L
.47727 .65415 L
.47273 .65052 L
.46818 .64827 L
.46364 .64776 L
.45909 .64907 L
.45455 .65199 L
.45 .65606 L
.44545 .6606 L
.44091 .66491 L
.43636 .66827 L
Mistroke
.43182 .67016 L
.42727 .67026 L
.42273 .66856 L
.41818 .66534 L
.41364 .66111 L
.40909 .65655 L
.40454 .6524 L
.4 .64933 L
.39545 .64782 L
.39091 .64813 L
.38636 .6502 L
.38182 .6537 L
.37727 .65807 L
.37273 .6626 L
.36818 .66656 L
.36364 .66933 L
.35909 .67044 L
.35455 .66973 L
.35 .6673 L
.34546 .66356 L
.34091 .65909 L
Mfstroke
.47273 .65909 m
.52727 .64091 L
.52727 .67727 L
F
gsave
.5 .70205 -69.75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.8125 translate 1 -1 scale
63.000 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
76.500 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65454 .34537 L
.65 .34912 L
.64545 .35155 L
.64091 .35226 L
.63636 .35114 L
.63182 .34838 L
.62727 .34442 L
.62273 .33988 L
.61818 .33552 L
.61364 .33202 L
.60909 .32995 L
.60455 .32964 L
.6 .33115 L
.59546 .33422 L
.59091 .33837 L
.58636 .34293 L
.58182 .34716 L
.57727 .35038 L
.57273 .35208 L
.56818 .35198 L
.56364 .35009 L
.55909 .34673 L
.55455 .34242 L
.55 .33787 L
.54545 .33381 L
.54091 .33089 L
.53636 .32958 L
.53182 .33009 L
.52727 .33234 L
.52273 .33596 L
.51818 .34039 L
.51364 .34489 L
.50909 .34875 L
.50455 .35134 L
.5 .35226 L
.49545 .35134 L
.49091 .34875 L
.48636 .34489 L
.48182 .34039 L
.47727 .33596 L
.47273 .33234 L
.46818 .33009 L
.46364 .32958 L
.45909 .33089 L
.45455 .33381 L
.45 .33787 L
.44545 .34242 L
.44091 .34673 L
.43636 .35009 L
Mistroke
.43182 .35198 L
.42727 .35208 L
.42273 .35038 L
.41818 .34716 L
.41364 .34293 L
.40909 .33837 L
.40454 .33422 L
.4 .33115 L
.39545 .32964 L
.39091 .32995 L
.38636 .33202 L
.38182 .33552 L
.37727 .33988 L
.37273 .34442 L
.36818 .34838 L
.36364 .35114 L
.35909 .35226 L
.35455 .35155 L
.35 .34912 L
.34546 .34537 L
.34091 .34091 L
Mfstroke
.52727 .34091 m
.47273 .32273 L
.47273 .35909 L
F
gsave
.5 .29795 -69.75 -17.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.8125 translate 1 -1 scale
63.000 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
76.500 15.250 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65909 .34091 m
.65909 .65909 L
s
.65909 .47273 m
.67727 .52727 L
.64091 .52727 L
F
gsave
.61613 .5 -78.25 -9.53125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.0625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(n) show
69.562 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
1.000 setlinewidth
grestore
.04 w
.34091 .65909 Mdot
.34091 .34091 Mdot
.65909 .34091 Mdot
.65909 .65909 Mdot
gsave
.5 .02273 -87.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.9375 translate 1 -1 scale
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
79.375 13.375 moveto
(C2) show
97.062 13.375 moveto
(N3) show
111.625 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 1.09 -67.75 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.500 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 1.09 -67.75 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.500 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 1.09 -70.0312 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.938 moveto
(\\256) show
77.062 13.938 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 1.09 -67.75 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.500 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 1.09 -67.75 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
72.500 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{250.375, 287.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003j00017b000`400?l00000o`00003onP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool001P0oooo0`000000
0`3oool000000?ooo`3L0?ooo`005`3oool200000080oooo0P00003M0?ooo`005`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`2f0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2f0?ooo`005`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
002g0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0000002g0?ooo`005`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`0000000`3oool00`000000oooo0000002g0?oo
o`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01X0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`3oool0]03oool003T0oooo00L000000?oo
o`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`3oool0]03oool000D0oooo0`00000a
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo0340oooo
00<000000?ooo`3oool0P03oool000P0oooo1000000/0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`000000103oool00`000000oooo0?ooo`0L0?ooo`@000003`3oool00`000000oooo0?oo
o`210?ooo`00303oool5000002L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01/0oooo0P0000020?ooo`8000003@3oool00`000000oooo0?ooo`22
0?ooo`004@3oool:000001d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`220?oo
o`005P3oool5000004L0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`230?ooo`00
5`3oool8000004<0oooo1P00000;0?ooo`030000003oool0oooo08@0oooo000I0?ooo`800000103o
ool5000003h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo08D0oooo000T0?ooo`@0000000@0oooo0000000000000000103oool3000000D0oooo1P00
00030?ooo`@000001@3oool3000000@0oooo0`00000>0?ooo`8000000P3oool2000000X0oooo00<0
00000?ooo`3oool0Q@3oool002P0oooo100000030?ooo`050000003oool0oooo0?ooo`0000000`3o
ool2000000030?ooo`000000000000H000000P3oool2000000<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`@000003`3oool4000000X0oooo00<000000?ooo`3oool0QP3oool002T0oooo0`00
00000`3oool00000000000050?ooo`030000003oool0000000<0oooo1`0000040?ooo`@000001@3o
ool2000000040?ooo`0000000000000001`0oooo00<000000?ooo`3oool0Q`3oool002X0oooo00<0
00000?ooo`000000203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo0P00
00070?ooo`80000000@0oooo0000003oool000006P3oool00`000000oooo0?ooo`280?ooo`00:P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0000001X0oooo00<000000?ooo`3oool0R03o
ool002X0oooo00<000000?ooo`3oool09@3oool010000000oooo0?ooo`00000H0?ooo`030000003o
ool0oooo08T0oooo000Z0?ooo`030000003oool0oooo02D0oooo00D000000?ooo`3oool0oooo0000
000F0?ooo`030000003oool0oooo08X0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo08/0oooo000Z0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo08`0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo08`0oooo000Z0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo08d0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo08h0oooo000Z0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo08l0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo08l0oooo000Z0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo0000003o
ool0T@3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00@0oooo1000002B0?ooo`007`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`@00000T`3o
ool001l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool00P3oool3000009@0oooo000I0?ooo`<0000000@0oooo0000
003oool000002P3oool00`000000oooo0?ooo`0H0?ooo`8000002`3oool00`000000oooo0?ooo`0:
0?ooo`040000003oool0oooo0?ooo`800000U@3oool001P0oooo0P0000020?ooo`80000000<0oooo
0000003oool02@3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo000000X0oooo00<0
00000?ooo`3oool02`3oool010000000oooo0?ooo`00002F0?ooo`00603oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00X0oooo0P00000>0?ooo`800000U`3oool001P0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000090?ooo`800000503oool2000000<0oooo10000009
0?ooo`8000003P3oool00`000000oooo0?ooo`2F0?ooo`00603oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00T0oooo0`00000C0?ooo`030000003oool000000080oooo00@000000?oo
o`3oool00000203oool4000000d0oooo1000002E0?ooo`00603oool00`000000oooo0?ooo`020?oo
o`030000003oool0000000T0oooo0`00000C0?ooo`030000003oool0000000<0oooo0P0000090?oo
o`@00000303oool00`000000oooo00000002000009D0oooo000H0?ooo`8000000P3oool2000000X0
oooo1000000C0?ooo`030000003oool0000000d0oooo1@00000;0?ooo`H00000U@3oool001T0oooo
0`0000000`3oool000000?ooo`0;0?ooo`030000003oool0oooo0140oooo0P0000020?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`3oool4000009@0
oooo000M0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0403oool2000000<0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo
0`00002D0?ooo`007@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`800000T`3oool001d0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`2@0?ooo`00:P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`2?0?oo
o`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`2?0?ooo`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`2>0?ooo`00:P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`2=0?ooo`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`2<0?ooo`00:P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`2<0?ooo`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`2;0?ooo`00:P3oool00`000000oooo
0?ooo`0U0?ooo`050000003oool0oooo0?ooo`0000005P3oool00`000000oooo0?ooo`2:0?ooo`00
:P3oool00`000000oooo0?ooo`0U0?ooo`040000003oool0oooo000001P0oooo00<000000?ooo`3o
ool0R@3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0000000J0?ooo`030000
003oool0oooo08P0oooo000Z0?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0000001X0oooo00<000000?ooo`3oool0R03oool002T0oooo0`0000030?ooo`@000001@3oool4
00000080oooo1`0000050?ooo`040000003oool00000000000<0oooo0`00000L0?ooo`030000003o
ool0oooo08L0oooo000X0?ooo`@000000P3oool2000000<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`L00000103oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000000`3oool00000
00000002000001d0oooo00<000000?ooo`3oool0QP3oool002@0oooo100000000`3oool000000000
0003000000H0oooo0`0000060?ooo`@00000103oool4000000D0oooo1P00000N0?ooo`030000003o
ool0oooo08D0oooo000O0?ooo`D000001P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool0Q@3oool001X0oooo1@00001D0?ooo`030000003oool0oooo
08@0oooo000E0?ooo`D00000FP3oool00`000000oooo0?ooo`230?ooo`004@3oool7000004`0oooo
1000000=0?ooo`030000003oool0oooo0880oooo000<0?ooo`D00000103oool2000004`0oooo0P00
00020?ooo`800000303oool00`000000oooo0?ooo`220?ooo`00203oool4000005L0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`210?ooo`001@3oool3000005/0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`200?ooo`00>`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01l0oooo1P00002A0?ooo`00>`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`2?0?ooo`00>P3o
ool00`000000oooo000000030?ooo`030000003oool000000200oooo0P0000020?ooo`800000T@3o
ool003X0oooo00<000000?ooo`0000000`3oool00`000000oooo0000000Q0?ooo`@00000TP3oool0
01P0oooo0`0000000`3oool000000?ooo`0L0?ooo`030000003oool0000000<0oooo00<000000?oo
o`000000]`3oool001L0oooo0P0000020?ooo`800000703oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo0?ooo`2d0?ooo`005`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo01X0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool0]03oool001L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0J
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo0;@0oooo
000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0/`3oool001L0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`2c0?ooo`005`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0;<0oooo000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0f`3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00603oool3000000030?ooo`000000
oooo0480oooo1000000`0?ooo`<0000000<0oooo0000003oool0H03oool001L0oooo0P0000020?oo
o`8000007P3oool00`000000oooo0?ooo`0Q0?ooo`8000000P3oool2000002h0oooo0P0000020?oo
o`8000007`3oool00`000000oooo0?ooo`0o0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01`0oooo0P00000R0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0M0?ooo`800000@03oool001L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
?P3oool001L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo01l0oooo1P00000^0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`0m0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo03d0oooo000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07P3oool20000
0200oooo0P0000020?ooo`800000;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
01l0oooo0P00000n0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`000000803oool4000002l0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0000003d0oooo00050?ooo`<00000=@3oool00`000000oooo
0000000e0?ooo`<000002P3oool3000003D0oooo00<000000?ooo`000000=P3oool00`000000oooo
0?ooo`040?ooo`00203oool4000002d0oooo00<000000?ooo`3oool00P0000020?ooo`030000003o
ool0oooo02h0oooo1000000@0?ooo`@00000;@3oool00`000000oooo0?ooo`0200000080oooo00<0
00000?ooo`3oool0803oool4000000h0oooo00<000000?ooo`3oool01@3oool000`0oooo1000000Z
0?ooo`<000000`3oool00`000000oooo0?ooo`0Z0?ooo`@00000603oool4000002X0oooo0`000003
0?ooo`030000003oool0oooo01l0oooo0P0000020?ooo`800000303oool00`000000oooo0?ooo`06
0?ooo`00403oool400000540oooo0`0000000`3oool000000000000200000200oooo1000001>0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool001@0oooo1`0000180?ooo`H0
0000:03oool7000004L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`070?ooo`00
5P3oool6000004D0oooo1`00000[0?ooo`H00000AP3oool6000000X0oooo00<000000?ooo`3oool0
203oool001L0oooo100000000`3oool0000000000002000003d0oooo1000000c0?ooo`@0000000<0
oooo0000000000000P0000120?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`090?ooo`006@3oool2000000D0oooo1000000=0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00/0oooo1000000i0?ooo`8000001@3oool4000000`0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0503oool2
00000080oooo0P0000090?ooo`030000003oool0oooo00T0oooo000T0?ooo`@0000000@0oooo0000
0000000000000`3oool4000000D0oooo100000050?ooo`@000001@3oool4000000<0oooo0`000000
0`3oool0000000000002000004P0oooo10000000103oool000000000000000030?ooo`@000001@3o
ool010000000oooo0000000000040?ooo`@000001@3oool4000000<0oooo0`00000@0?ooo`@00000
2@3oool00`000000oooo0?ooo`0:0?ooo`00:03oool400000080oooo0P0000030?ooo`040000003o
ool0oooo0?ooo`8000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000030?ooo`04
0000003oool0oooo0?ooo`80000000<0oooo0000000000000`00001@0?ooo`@000000P3oool01000
0000oooo0?ooo`3oool2000000<0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`8000000`3o
ool010000000oooo0?ooo`3oool2000000<0oooo00<000000?ooo`0000000`00000L0?ooo`030000
003oool0oooo00/0oooo000Y0?ooo`D000001P3oool3000000H0oooo0`0000050?ooo`@000001@3o
ool600000580oooo1@0000050?ooo`@000001@3oool4000000D0oooo100000050?ooo`D000006`3o
ool00`000000oooo0?ooo`0<0?ooo`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo0580oooo00<000000?ooo`3oool0903oool00`000000oooo0000000J0?ooo`030000003oool0
oooo00`0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0DP3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0000001T0oooo00<000000?ooo`3oool03@3oool002X0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo02@0
oooo00@000000?ooo`3oool000005`3oool00`000000oooo0?ooo`0>0?ooo`00:P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0903oool01@000000
oooo0?ooo`3oool0000001D0oooo00<000000?ooo`3oool03`3oool002X0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo000Z0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`00:P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3o
ool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0
oooo02@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0180oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0DP3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0B0?ooo`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0580
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool04`3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`1B0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`<000005P3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`1B0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`<000005P3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`05
0?ooo`@000005@3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?oo
o`030000003oool0oooo02@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?oo
o`@000005P3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`80
0000603oool002X0oooo00<000000?ooo`3oool08`3oool4000005<0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo0?ooo`8000006@3oool001d0oooo
0`0000000`3oool000000?ooo`070?ooo`030000003oool0oooo02<0oooo100000070?ooo`@00000
>P3oool3000000030?ooo`000000oooo00P0oooo00<000000?ooo`3oool05`3oool4000000T0oooo
00<000000?ooo`3oool02`3oool010000000oooo0?ooo`00000J0?ooo`00703oool200000080oooo
0P0000080?ooo`030000003oool0oooo02@0oooo0`0000060?ooo`8000000P3oool2000003P0oooo
0P0000020?ooo`800000203oool2000001P0oooo0P0000020?ooo`800000203oool2000000d0oooo
0P00000K0?ooo`00703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo0`00
000U0?ooo`8000001`3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01P3oool3000001L0oooo00<000000?ooo`3oool02P3oool3000000d0oooo00<0
00000?ooo`3oool06P3oool001`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`05
0?ooo`<000009P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`@000005`3oool00`000000oooo0?ooo`0:
0?ooo`@000002`3oool010000000oooo0000003oool2000001P0oooo000L0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool3000002H0oooo00<000000?ooo`3oool01@3oool6
000003P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`@000005`3oool6
000000L0oooo1000000;0?ooo`030000003oool0oooo00<00000603oool001`0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`040?ooo`@000009P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo1@00000G0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0103oool5000000X0oooo00<000000?ooo`0000001000000H0?ooo`00703oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`050?ooo`8000000P3oool2000003P0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01H0oooo0P0000020?ooo`800000203oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0080oooo1000000G0?ooo`00703oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`060?ooo`@00000>@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool05`3oool4000000T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`040?ooo`<000005`3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`1B0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01D0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool0DP3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`00:P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo0580oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool04`3oool002X0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01<0oooo000Z0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`00:P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3o
ool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0
oooo02@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0DP3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0@0?ooo`00:P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0580
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool03`3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`1B0?ooo`030000003oool0oooo02@0oooo00D000000?ooo`3oool0oooo0000000F0?ooo`03
0000003oool0oooo00h0oooo000Z0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
DP3oool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000001P0oooo00<000000?ooo`3o
ool03@3oool002X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1B0?ooo`030000
003oool0oooo02@0oooo00<000000?ooo`0000006P3oool00`000000oooo0?ooo`0<0?ooo`00:@3o
ool3000000@0oooo0P0000070?ooo`8000001P3oool3000000H0oooo0`0000040?ooo`<00000DP3o
ool3000000<0oooo0`0000060?ooo`<000001P3oool3000000H0oooo0`0000030?ooo`@000006P3o
ool00`000000oooo0?ooo`0<0?ooo`00:03oool4000000<0oooo00<000000?ooo`3oool00P000004
0?ooo`030000003oool0oooo008000000`3oool200000080oooo00<000000?ooo`3oool00P3oool2
00000080oooo00<000000?ooo`3oool01000001A0?ooo`@000000P3oool200000080oooo00<00000
0?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02
000000@0oooo00<000000?ooo`3oool00P0000000`3oool0000000000002000001`0oooo00<00000
0?ooo`3oool02`3oool002P0oooo100000000`3oool00000000000040?ooo`80000000<0oooo0000
00000000103oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P000004
0?ooo`030000003oool0oooo00@00000D03oool4000000030?ooo`000000000000@0oooo00<00000
0?ooo`3oool00P0000040?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`030000003o
ool0oooo0080oooo0P000000103oool0000000000000000M0?ooo`030000003oool0oooo00X0oooo
000T0?ooo`@000000P3oool4000000H0oooo0`0000060?ooo`<000001P3oool2000000L0oooo1000
00020?ooo`@00000B03oool400000080oooo100000060?ooo`<000001@3oool4000000D0oooo0`00
00070?ooo`<000007`3oool00`000000oooo0?ooo`090?ooo`007`3oool5000003D0oooo1@000003
0?ooo`800000>@3oool5000004d0oooo00<000000?ooo`3oool02@3oool001D0oooo2P00000o0?oo
o`H00000;@3oool;000005<0oooo00<000000?ooo`3oool0203oool001D0oooo1@0000170?ooo`H0
0000:P3oool6000004X0oooo1000000;0?ooo`030000003oool0oooo00L0oooo000A0?ooo`L00000
B03oool<00000280oooo1`00001;0?ooo`8000000P3oool2000000/0oooo00<000000?ooo`3oool0
1P3oool000`0oooo1@0000040?ooo`800000E@3oool5000001P0oooo1@0000030?ooo`800000C@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00H0oooo00080?ooo`@00000;`3oool0
0`000000oooo0?ooo`0c0?ooo`@00000403oool4000002l0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00050?ooo`<00000<`3oool20000
03P0oooo0`00000:0?ooo`<00000<`3oool2000002H0oooo1P00000=0?ooo`030000003oool0oooo
00@0oooo000l0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0180oooo000m0?ooo`030000003oool0oooo07X0oooo
00<000000?ooo`3oool08`3oool200000080oooo0P00000D0?ooo`00?@3oool00`000000oooo0?oo
o`1j0?ooo`030000003oool0oooo02@0oooo1000000E0?ooo`00603oool3000000030?ooo`000000
oooo01l0oooo0P00000Q0?ooo`@00000<03oool3000000030?ooo`000000oooo0200oooo0P00000n
0?ooo`005`3oool200000080oooo0P00000P0?ooo`030000003oool0000001l0oooo0P0000020?oo
o`800000;P3oool200000080oooo0P00000Q0?ooo`030000003oool0000003d0oooo000G0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool07P3oool00`000000oooo0000000O0?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0000003d0oooo000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`0a0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0200000080oooo00<000000?ooo`3oool0>P3oool001L0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0K0?ooo`<000000`3oool00`000000oooo0?ooo`0L0?ooo`H00000;P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo0`0000030?ooo`030000003o
ool0oooo03X0oooo000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`1O0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0400oooo0P0000020?ooo`800000;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
05l0oooo000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0@@3oool4000002l0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1O0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 249.375}, {286.875, 0}} -> {-0.000220002, \
-0.00852375, 0.176443, 0.176443}, {{0, 124.688}, {162.125, 37.4375}} -> \
{-1.00011, -23.0114, 0.176443, 0.176443}, {{124.688, 249.375}, {162.125, \
37.4375}} -> {-23.0004, -23.0114, 0.176443, 0.176443}, {{0, 124.688}, \
{286.812, 162.125}} -> {-1.00011, -1.01114, 0.176443, 0.176443}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(FeynArtsGraphics({"u", "u"} \[Rule] {"e", "e"})\), 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          TagBox[
            RowBox[{"(", "\[NoBreak]", GridBox[{
                  {
                    FormBox[
                      
                      InterpretationBox[\("["\[InvisibleSpace]"T1 C1 N1"\
\[InvisibleSpace]"]"\),
                        SequenceForm[ "[", "T1 C1 N1", "]"],
                        Editable->False],
                      "TraditionalForm"], 
                    FormBox[
                      
                      InterpretationBox[\("["\[InvisibleSpace]"T2 C1 N2"\
\[InvisibleSpace]"]"\),
                        SequenceForm[ "[", "T2 C1 N2", "]"],
                        Editable->False],
                      "TraditionalForm"]},
                  {
                    FormBox[
                      
                      InterpretationBox[\("["\[InvisibleSpace]"T2 C2 N3"\
\[InvisibleSpace]"]"\),
                        SequenceForm[ "[", "T2 C2 N3", "]"],
                        Editable->False],
                      "TraditionalForm"], "Null"}
                  }], "\[NoBreak]", ")"}],
            Function[ BoxForm`e$, 
              MatrixForm[ BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(amps\  = \ CreateFeynAmp[ins]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"2 Classes amplitudes"\),
        SequenceForm[ "> Top. ", 2, ": ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"3 Classes amplitudes"\
\),
        SequenceForm[ "in total: ", "3 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), ",", 
            RowBox[{"ExcludeParticles", "\[Rule]", 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(V(2)\), \(S(1)\), \(S(2)\), \(S(3)\)}
                    }], "\[NoBreak]", ")"}]}], 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(-\(F(3, {1})\)\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "MU"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(2, {1})\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "ME"},
                      {\(-\(F(2, {1})\)\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "ME"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                  Number == 1)\), ",", 
                RowBox[{"Integral", "(", 
                  FormBox[
                    InterpretationBox[\("q"\[InvisibleSpace]1\),
                      SequenceForm[ "q", 1],
                      Editable->False],
                    "TraditionalForm"], ")"}], ",", 
                RowBox[{\(1\/\(16\ \[Pi]\^4\)\), 
                  RowBox[{"(", 
                    RowBox[{"\[ImaginaryI]", " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{\("v"\&"_"\), "(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              
                              RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", 
                                " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]3\),
                                        SequenceForm[ "Lor", 3],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "-", 
                              
                              RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", 
                                "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]3\),
                                        SequenceForm[ "Lor", 3],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{"MU", "+", 
                                RowBox[{
                                  FormBox["\<\"gs\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("q"\[InvisibleSpace]1\
\),
                                      SequenceForm[ "q", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              
                              RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", 
                                " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "-", 
                              RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", 
                                "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"\<\"u\"\>", "[", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]1\),
                                  SequenceForm[ "p", 1],
                                  Editable->False],
                                "TraditionalForm"], ",", "MU"}], "]"}]}],
                        "TraditionalForm"], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{\("u"\&"_"\), "(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], ",", "ME"}], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "+", 
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{"ME", "+", 
                                RowBox[{
                                  FormBox["\<\"gs\"\>",
                                    "TraditionalForm"], "(", 
                                  RowBox[{
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "k", 2],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}]}],
                              "TraditionalForm"], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]4\),
                                        SequenceForm[ "Lor", 4],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "+", 
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]4\),
                                        SequenceForm[ "Lor", 4],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"\<\"v\"\>", "[", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"], ",", "ME"}], "]"}]}],
                        "TraditionalForm"], " ", 
                      RowBox[{"FeynAmpDenominator", "(", 
                        RowBox[{
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], "2"], "-", 
                                "MU2"}]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              SuperscriptBox[
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}], "2"]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    RowBox[{
                                      FormBox[
                                        
                                        InterpretationBox[\("p"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                        "TraditionalForm"], "+", 
                                      FormBox[
                                        
                                        InterpretationBox[\("q"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                        "TraditionalForm"], "-", 
                                      FormBox[
                                        
                                        InterpretationBox[\("k"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "k", 2],
                                        Editable->False],
                                        "TraditionalForm"]}], ")"}], "2"], 
                                "-", "ME2"}]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              SuperscriptBox[
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "k", 1],
                                        Editable->False],
                                      "TraditionalForm"], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "k", 2],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}], "2"]],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{"IndexDelta", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]1\),
                              SequenceForm[ "Col", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]2\),
                              SequenceForm[ "Col", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox["\<\"g\"\>",
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                              SequenceForm[ "Lor", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox["\<\"g\"\>",
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                              SequenceForm[ "Lor", 4],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]1\),
                              SequenceForm[ "Col", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "3", ",", "External"}], 
                        ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]2\),
                              SequenceForm[ "Col", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "3", ",", "External"}], 
                        ")"}]}], ")"}]}]}], ")"}], ",", 
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 2, Generic == 1, Classes == 1, 
                  Number == 2)\), ",", 
                RowBox[{"Integral", "(", 
                  FormBox[
                    InterpretationBox[\("q"\[InvisibleSpace]1\),
                      SequenceForm[ "q", 1],
                      Editable->False],
                    "TraditionalForm"], ")"}], ",", 
                RowBox[{\(1\/\(16\ \[Pi]\^4\)\), 
                  RowBox[{"(", 
                    RowBox[{"\[ImaginaryI]", " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{\("v"\&"_"\), "(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              
                              RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", 
                                " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]3\),
                                        SequenceForm[ "Lor", 3],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "-", 
                              
                              RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", 
                                "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]3\),
                                        SequenceForm[ "Lor", 3],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{"MU", "+", 
                                RowBox[{
                                  FormBox["\<\"gs\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("q"\[InvisibleSpace]1\
\),
                                      SequenceForm[ "q", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              
                              RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", 
                                " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "-", 
                              
                              RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", 
                                "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"\<\"u\"\>", "[", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]1\),
                                  SequenceForm[ "p", 1],
                                  Editable->False],
                                "TraditionalForm"], ",", "MU"}], "]"}]}],
                        "TraditionalForm"], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{\("u"\&"_"\), "(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], ",", "ME"}], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]4\),
                                        SequenceForm[ "Lor", 4],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "+", 
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]4\),
                                        SequenceForm[ "Lor", 4],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{"ME", "+", 
                                RowBox[{
                                  FormBox["\<\"gs\"\>",
                                    "TraditionalForm"], "(", 
                                  RowBox[{
                                    RowBox[{"-", 
                                      RowBox[{"(", 
                                        FormBox[
                                        
                                        InterpretationBox[\("p"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "k", 1],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}]}],
                              "TraditionalForm"], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}], "+", 
                              RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                                FormBox[
                                  RowBox[{
                                    RowBox[{
                                      FormBox["\<\"ga\"\>",
                                        "TraditionalForm"], "(", 
                                      FormBox[
                                        
                                        InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                        "TraditionalForm"], ")"}], ".", 
                                    RowBox[{"(", 
                                      FormBox[
                                        InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}],
                                  "TraditionalForm"]}]}], ")"}], ".", 
                          RowBox[{"\<\"v\"\>", "[", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"], ",", "ME"}], "]"}]}],
                        "TraditionalForm"], " ", 
                      RowBox[{"FeynAmpDenominator", "(", 
                        RowBox[{
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], "2"], "-", 
                                "MU2"}]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              SuperscriptBox[
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}], "2"]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    RowBox[{
                                      FormBox[
                                        
                                        InterpretationBox[\("p"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                        "TraditionalForm"], "+", 
                                      FormBox[
                                        
                                        InterpretationBox[\("q"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                        "TraditionalForm"], "-", 
                                      FormBox[
                                        
                                        InterpretationBox[\("k"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "k", 1],
                                        Editable->False],
                                        "TraditionalForm"]}], ")"}], "2"], 
                                "-", "ME2"}]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              SuperscriptBox[
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "k", 1],
                                        Editable->False],
                                      "TraditionalForm"], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "k", 2],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}], "2"]],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{"IndexDelta", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]1\),
                              SequenceForm[ "Col", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]2\),
                              SequenceForm[ "Col", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox["\<\"g\"\>",
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                              SequenceForm[ "Lor", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox["\<\"g\"\>",
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                              SequenceForm[ "Lor", 4],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]1\),
                              SequenceForm[ "Col", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "3", ",", "External"}], 
                        ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]2\),
                              SequenceForm[ "Col", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "3", ",", "External"}], 
                        ")"}]}], ")"}]}]}], ")"}], ",", 
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 2, Generic == 1, Classes == 2, 
                  Number == 3)\), ",", 
                RowBox[{"Integral", "(", 
                  FormBox[
                    InterpretationBox[\("q"\[InvisibleSpace]1\),
                      SequenceForm[ "q", 1],
                      Editable->False],
                    "TraditionalForm"], ")"}], ",", 
                RowBox[{\(1\/\(16\ \[Pi]\^4\)\), 
                  RowBox[{"(", 
                    RowBox[{"\[ImaginaryI]", " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{\("v"\&"_"\), "(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]2\),
                                  SequenceForm[ "p", 2],
                                  Editable->False],
                                "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                          FractionBox[
                            RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                              RowBox[{"CKM", "(", 
                                RowBox[{"1", ",", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Gen"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Gen", 1],
                                      Editable->False],
                                    "TraditionalForm"]}], ")"}], " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]3\),
                                        SequenceForm[ "Lor", 3],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(\@2\ SW\)], ".", 
                          RowBox[{"(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"gs\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("q"\[InvisibleSpace]1\
\),
                                      SequenceForm[ "q", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], "+", 
                                RowBox[{"MQD", "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Gen"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Gen", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}], ".", 
                          FractionBox[
                            RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                              RowBox[{"CKMC", "(", 
                                RowBox[{"1", ",", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Gen"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Gen", 1],
                                      Editable->False],
                                    "TraditionalForm"]}], ")"}], " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "Lor", 1],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(\@2\ SW\)], ".", 
                          RowBox[{"\<\"u\"\>", "[", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("p"\[InvisibleSpace]1\),
                                  SequenceForm[ "p", 1],
                                  Editable->False],
                                "TraditionalForm"], ",", "MU"}], "]"}]}],
                        "TraditionalForm"], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{\("u"\&"_"\), "(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], ",", "ME"}], ")"}], ".", 
                          FractionBox[
                            RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]4\),
                                        SequenceForm[ "Lor", 4],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(\@2\ SW\)], ".", 
                          FormBox[
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                RowBox[{"-", 
                                  RowBox[{"(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}], "-", 
                                FormBox[
                                  
                                  InterpretationBox[\("q"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "q", 1],
                                    Editable->False],
                                  "TraditionalForm"], "+", 
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}],
                            "TraditionalForm"], ".", 
                          FractionBox[
                            RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                              FormBox[
                                RowBox[{
                                  RowBox[{
                                    FormBox["\<\"ga\"\>",
                                      "TraditionalForm"], "(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("Lor"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "Lor", 2],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], ".", 
                                  RowBox[{"(", 
                                    FormBox[
                                      InterpretationBox[
                                        
                                        RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                        SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                        Editable->False],
                                      "TraditionalForm"], ")"}]}],
                                "TraditionalForm"]}], \(\@2\ SW\)], ".", 
                          RowBox[{"\<\"v\"\>", "[", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"], ",", "ME"}], "]"}]}],
                        "TraditionalForm"], " ", 
                      RowBox[{"FeynAmpDenominator", "(", 
                        RowBox[{
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], ")"}], "2"], "-", 
                                RowBox[{"MQD2", "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Gen"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Gen", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    RowBox[{
                                      FormBox[
                                        
                                        InterpretationBox[\("p"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                        "TraditionalForm"], "+", 
                                      FormBox[
                                        
                                        InterpretationBox[\("q"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                        "TraditionalForm"]}], ")"}], "2"], 
                                "-", "MW2"}]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              SuperscriptBox[
                                RowBox[{"(", 
                                  RowBox[{
                                    FormBox[
                                      
                                      InterpretationBox[\("p"\[InvisibleSpace]\
2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                      "TraditionalForm"], "+", 
                                    FormBox[
                                      
                                      InterpretationBox[\("q"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                      "TraditionalForm"], "-", 
                                    FormBox[
                                      
                                      InterpretationBox[\("k"\[InvisibleSpace]\
1\),
                                        SequenceForm[ "k", 1],
                                        Editable->False],
                                      "TraditionalForm"]}], ")"}], "2"]],
                            "TraditionalForm"], ",", 
                          FormBox[
                            FractionBox["1", 
                              RowBox[{
                                SuperscriptBox[
                                  RowBox[{"(", 
                                    RowBox[{
                                      FormBox[
                                        
                                        InterpretationBox[\("p"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "p", 2],
                                        Editable->False],
                                        "TraditionalForm"], "+", 
                                      FormBox[
                                        
                                        InterpretationBox[\("q"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "q", 1],
                                        Editable->False],
                                        "TraditionalForm"], "-", 
                                      FormBox[
                                        
                                        InterpretationBox[\("k"\
\[InvisibleSpace]1\),
                                        SequenceForm[ "k", 1],
                                        Editable->False],
                                        "TraditionalForm"], "-", 
                                      FormBox[
                                        
                                        InterpretationBox[\("k"\
\[InvisibleSpace]2\),
                                        SequenceForm[ "k", 2],
                                        Editable->False],
                                        "TraditionalForm"]}], ")"}], "2"], 
                                "-", "MW2"}]],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{"IndexDelta", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]1\),
                              SequenceForm[ "Col", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]2\),
                              SequenceForm[ "Col", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox["\<\"g\"\>",
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                              SequenceForm[ "Lor", 2],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox["\<\"g\"\>",
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                              SequenceForm[ "Lor", 4],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Gen"\[InvisibleSpace]1\),
                              SequenceForm[ "Gen", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "3"}], ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]1\),
                              SequenceForm[ "Col", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "3", ",", "External"}], 
                        ")"}], " ", 
                      RowBox[{"SumOver", "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Col"\[InvisibleSpace]2\),
                              SequenceForm[ "Col", 2],
                              Editable->False],
                            "TraditionalForm"], ",", "3", ",", "External"}], 
                        ")"}]}], ")"}]}]}], ")"}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat = CalcFeynAmp[amps]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("preparing FORM code in \
"\[InvisibleSpace]"/tmp/m4.frm"\),
        SequenceForm[ "preparing FORM code in ", "/tmp/m4.frm"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]0\[InvisibleSpace]" amplitudes \
with insertions"\),
        SequenceForm[ "> ", 0, " amplitudes with insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]3\[InvisibleSpace]" amplitudes \
without insertions"\),
        SequenceForm[ "> ", 3, " amplitudes without insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell["running FORM... ", "Print"],

Cell[BoxData[
    \(TraditionalForm\`"ok"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\(Amp({MU, MU} \[Rule] {ME, 
            ME})\)\[InvisibleApplication] \((\((16\/9\ Alfa2\ ME\ MU\ \(D0i(
                    dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ ME\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F1\ SUN1)\) + 
          4\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                  ME2, 0) + 
                D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\)\ \(Mat(
              F10\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ ME\ \(D0i(dd2, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/9\ Alfa2\ ME\ \(D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                    ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + 
                16\/9\ Alfa2\ ME\ \(D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F11\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ MU2\ \(D0i(dd0, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU2\ \(D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\) - 
                16\/9\ Alfa2\ \((C0i(cc0, ME2, ME2, S, 0, ME2, 0) + 
                      D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + \((\(8\ Alfa2\ ME2\)\/9 + \(32\ Alfa2\ \
MU2\)\/9 - 16\/9\ Alfa2\ \((ME2 + MU2)\) + 8\/9\ Alfa2\ \((S + U)\))\)\ \(D0i(
                    dd1, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(8\ Alfa2\ ME2\)\/3\)\) + \(32\ Alfa2\ \
MU2\)\/9 + 16\/9\ Alfa2\ \((ME2 + MU2)\) + \(8\ Alfa2\ U\)\/9)\)\ \(D0i(dd1, 
                    MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(16\ Alfa2\ MU2\)\/3 - \(16\ Alfa2\ ME2\)\
\/9)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/3 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(56\ Alfa2\ ME2\)\/9\)\) + 
                      16\/9\ Alfa2\ \((ME2 + 
                            MU2\/2)\) - \(32\ Alfa2\ MU2\)\/9 + 
                      8\/3\ Alfa2\ \((2\ ME2 + 
                            2\ MU2 - \(2\ T\)\/3)\))\)\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(8\ Alfa2\ \
MU2\)\/3 + 8\/9\ Alfa2\ \((ME2 + 2\ MU2)\) + \(16\ Alfa2\ U\)\/9)\)\ \(D0i(
                    dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \(D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 
                    0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(32\ Alfa2\ \
MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(-\(\(40\ Alfa2\ ME2\)\/9\)\) - \(32\ \
Alfa2\ MU2\)\/9 + 8\/3\ Alfa2\ \((2\ ME2 + 2\ MU2 - T\/3)\))\)\ \(D0i(dd3, 
                    MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((8\/9\ Alfa2\ \((4\ ME2 + 4\ MU2 + 
                            U)\) - \(40\ Alfa2\ ME2\)\/9)\)\ \(D0i(dd3, MU2, 
                    ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                16\/9\ Alfa2\ MU2\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F12\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ ME\ \(D0i(dd2, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/9\ Alfa2\ ME\ \(D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                    ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + 
                16\/9\ Alfa2\ ME\ \(D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F13\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ MU2\ \(D0i(dd0, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU2\ \(D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\) - 
                16\/9\ Alfa2\ \((C0i(cc0, ME2, ME2, S, 0, ME2, 0) + 
                      D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + \((\(8\ Alfa2\ ME2\)\/9 + \(32\ Alfa2\ \
MU2\)\/9 - 16\/9\ Alfa2\ \((ME2 + MU2)\) + 8\/9\ Alfa2\ \((S + U)\))\)\ \(D0i(
                    dd1, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(8\ Alfa2\ ME2\)\/3\)\) + \(32\ Alfa2\ \
MU2\)\/9 + 16\/9\ Alfa2\ \((ME2 + MU2)\) + \(8\ Alfa2\ U\)\/9)\)\ \(D0i(dd1, 
                    MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(16\ Alfa2\ MU2\)\/3 - \(16\ Alfa2\ ME2\)\
\/9)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/3 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(56\ Alfa2\ ME2\)\/9\)\) + 
                      16\/9\ Alfa2\ \((ME2 + 
                            MU2\/2)\) - \(32\ Alfa2\ MU2\)\/9 + 
                      8\/3\ Alfa2\ \((2\ ME2 + 
                            2\ MU2 - \(2\ T\)\/3)\))\)\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(8\ Alfa2\ \
MU2\)\/3 + 8\/9\ Alfa2\ \((ME2 + 2\ MU2)\) + \(16\ Alfa2\ U\)\/9)\)\ \(D0i(
                    dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \(D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 
                    0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(32\ Alfa2\ \
MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(-\(\(40\ Alfa2\ ME2\)\/9\)\) - \(32\ \
Alfa2\ MU2\)\/9 + 8\/3\ Alfa2\ \((2\ ME2 + 2\ MU2 - T\/3)\))\)\ \(D0i(dd3, 
                    MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((8\/9\ Alfa2\ \((4\ ME2 + 4\ MU2 + 
                            U)\) - \(40\ Alfa2\ ME2\)\/9)\)\ \(D0i(dd3, MU2, 
                    ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                16\/9\ Alfa2\ MU2\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F14\ SUN1)\) + \((8\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                4\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F15\ SUN1)\) + \((4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, 
                        ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F16\ SUN1)\) + \((4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, 
                        ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F17\ SUN1)\) + 
          4\/9\ Alfa2\ \((D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                  0) + D0i(dd00, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                  0))\)\ \(Mat(
              F18\ SUN1)\) + \((16\/9\ Alfa2\ ME\ MU\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ ME\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F19\ SUN1)\) + \((\(-\(80\/9\)\)\ Alfa2\ MU\ \((D0i(dd1, MU2, 
                        ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                64\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0))\) - 
                16\/3\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) - 
                32\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ MU\ \(D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F2\ SUN1)\) + \((\(-\(80\/9\)\)\ Alfa2\ MU\ \((D0i(dd1, MU2, 
                        ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                64\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0))\) - 
                16\/3\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) - 
                32\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ MU\ \(D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F20\ SUN1)\) + \((16\/9\ Alfa2\ ME\ MU\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ ME\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F21\ SUN1)\) + \((32\/9\ Alfa2\ MU\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, U, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                16\/9\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + 
                8\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F22\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ MU2\ \(D0i(dd0, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU2\ \(D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\) - 
                16\/9\ Alfa2\ \((C0i(cc0, ME2, ME2, S, 0, ME2, 0) + 
                      D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + \((\(8\ Alfa2\ ME2\)\/9 + \(32\ Alfa2\ \
MU2\)\/9 - 16\/9\ Alfa2\ \((ME2 + MU2)\) + 8\/9\ Alfa2\ \((S + U)\))\)\ \(D0i(
                    dd1, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(8\ Alfa2\ ME2\)\/3\)\) + \(32\ Alfa2\ \
MU2\)\/9 + 16\/9\ Alfa2\ \((ME2 + MU2)\) + \(8\ Alfa2\ U\)\/9)\)\ \(D0i(dd1, 
                    MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(16\ Alfa2\ MU2\)\/3 - \(16\ Alfa2\ ME2\)\
\/9)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/3 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(56\ Alfa2\ ME2\)\/9\)\) + 
                      16\/9\ Alfa2\ \((ME2 + 
                            MU2\/2)\) - \(32\ Alfa2\ MU2\)\/9 + 
                      8\/3\ Alfa2\ \((2\ ME2 + 
                            2\ MU2 - \(2\ T\)\/3)\))\)\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(8\ Alfa2\ \
MU2\)\/3 + 8\/9\ Alfa2\ \((ME2 + 2\ MU2)\) + \(16\ Alfa2\ U\)\/9)\)\ \(D0i(
                    dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \(D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 
                    0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(32\ Alfa2\ \
MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(-\(\(40\ Alfa2\ ME2\)\/9\)\) - \(32\ \
Alfa2\ MU2\)\/9 + 8\/3\ Alfa2\ \((2\ ME2 + 2\ MU2 - T\/3)\))\)\ \(D0i(dd3, 
                    MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((8\/9\ Alfa2\ \((4\ ME2 + 4\ MU2 + 
                            U)\) - \(40\ Alfa2\ ME2\)\/9)\)\ \(D0i(dd3, MU2, 
                    ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                16\/9\ Alfa2\ MU2\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F23\ SUN1)\) + \((8\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                4\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F24\ SUN1)\) + \((4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, 
                        ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F25\ SUN1)\) + \((4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, 
                        ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ ME\ MU\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F26\ SUN1)\) + \((\(-\(80\/9\)\)\ Alfa2\ MU\ \((D0i(dd1, MU2, 
                        ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                64\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0))\) - 
                16\/3\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) - 
                32\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ MU\ \(D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F27\ SUN1)\) + \((16\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F28\ SUN1)\) + \((32\/9\ Alfa2\ MU\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, U, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                16\/9\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + 
                8\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F29\ SUN1)\) + \((16\/9\ Alfa2\ ME\ MU\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ ME\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ ME\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F3\ SUN1)\) + \((4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, 
                        U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F30\ SUN1)\) + \((8\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                4\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F31\ SUN1)\) + 
          4\/9\ Alfa2\ \((D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                  0) + 
                D0i(dd00, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\)\ \(Mat(
              F32\ SUN1)\) + \((\(-\(80\/9\)\)\ Alfa2\ MU\ \((D0i(dd1, MU2, 
                        ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                64\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0))\) - 
                16\/3\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) - 
                32\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                16\/9\ Alfa2\ MU\ \(D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F33\ SUN1)\) + \((16\/9\ Alfa2\ ME\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, T, S, MU2, 0, ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F34\ SUN1)\) + \((16\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F35\ SUN1)\) + \((16\/9\ Alfa2\ ME\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, T, S, MU2, 0, ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F36\ SUN1)\) + \((16\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F37\ SUN1)\) + \((32\/9\ Alfa2\ MU\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, U, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                16\/9\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + 
                8\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F38\ SUN1)\) + \((4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, 
                        U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F39\ SUN1)\) + \((16\/9\ Alfa2\ ME\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, T, S, MU2, 0, ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F4\ SUN1)\) + 
          4\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                  ME2, 0) + 
                D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\)\ \(Mat(
              F40\ SUN1)\) + \((4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, 
                        U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F41\ SUN1)\) + 
          4\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                  ME2, 0) + 
                D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\)\ \(Mat(
              F42\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ ME\ \(D0i(dd2, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/9\ Alfa2\ ME\ \(D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                    ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + 
                16\/9\ Alfa2\ ME\ \(D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F43\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ ME\ \(D0i(dd2, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/9\ Alfa2\ ME\ \(D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                    ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + 
                16\/9\ Alfa2\ ME\ \(D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\))\)\ \(Mat(
              F44\ SUN1)\) + \((\(-\(8\/9\)\)\ Alfa2\ MU2\ \(D0i(dd0, MU2, 
                    ME2, ME2, MU2, T, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU2\ \(D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 
                    0, ME2, 0)\) - 
                16\/9\ Alfa2\ \((C0i(cc0, ME2, ME2, S, 0, ME2, 0) + 
                      D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) + \((\(8\ Alfa2\ ME2\)\/9 + \(32\ Alfa2\ \
MU2\)\/9 - 16\/9\ Alfa2\ \((ME2 + MU2)\) + 8\/9\ Alfa2\ \((S + U)\))\)\ \(D0i(
                    dd1, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(8\ Alfa2\ ME2\)\/3\)\) + \(32\ Alfa2\ \
MU2\)\/9 + 16\/9\ Alfa2\ \((ME2 + MU2)\) + \(8\ Alfa2\ U\)\/9)\)\ \(D0i(dd1, 
                    MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(16\ Alfa2\ MU2\)\/3 - \(16\ Alfa2\ ME2\)\
\/9)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/3 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(56\ Alfa2\ ME2\)\/9\)\) + 
                      16\/9\ Alfa2\ \((ME2 + 
                            MU2\/2)\) - \(32\ Alfa2\ MU2\)\/9 + 
                      8\/3\ Alfa2\ \((2\ ME2 + 
                            2\ MU2 - \(2\ T\)\/3)\))\)\ \(D0i(dd2, MU2, ME2, 
                    ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(8\ Alfa2\ \
MU2\)\/3 + 8\/9\ Alfa2\ \((ME2 + 2\ MU2)\) + \(16\ Alfa2\ U\)\/9)\)\ \(D0i(
                    dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                    0)\) + \((\(16\ Alfa2\ MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \
\(D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                32\/9\ Alfa2\ MU2\ \(D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 
                    0, ME2, 
                    0)\) + \((\(-\(\(16\ Alfa2\ ME2\)\/9\)\) + \(32\ Alfa2\ \
MU2\)\/9 + \(16\ Alfa2\ U\)\/9)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + \((\(-\(\(40\ Alfa2\ ME2\)\/9\)\) - \(32\ \
Alfa2\ MU2\)\/9 + 8\/3\ Alfa2\ \((2\ ME2 + 2\ MU2 - T\/3)\))\)\ \(D0i(dd3, 
                    MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                    0)\) + \((8\/9\ Alfa2\ \((4\ ME2 + 4\ MU2 + 
                            U)\) - \(40\ Alfa2\ ME2\)\/9)\)\ \(D0i(dd3, MU2, 
                    ME2, ME2, MU2, U, S, MU2, 0, ME2, 0)\) + 
                16\/9\ Alfa2\ MU2\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, 
                        MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F45\ SUN1)\) + \((8\/9\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                4\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F46\ SUN1)\) + 
          4\/9\ Alfa2\ \((D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                  0) + D0i(dd00, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                  0))\)\ \(Mat(F47\ SUN1)\) + 
          4\/9\ Alfa2\ \((D0i(dd00, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                  0) + D0i(dd00, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                  0))\)\ \(Mat(
              F48\ SUN1)\) + \((16\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, 
                        MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\) - 
                32\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F5\ SUN1)\) + \((16\/9\ Alfa2\ ME\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, T, S, MU2, 0, ME2, 0)\) - 
                16\/9\ Alfa2\ ME\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F6\ SUN1)\) + \((32\/9\ Alfa2\ MU\ \(D0i(dd12, MU2, ME2, ME2, 
                    MU2, U, S, MU2, 0, ME2, 0)\) + 
                8\/3\ Alfa2\ MU\ \((D0i(dd1, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd1, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\) + 
                16\/9\ Alfa2\ MU\ \((D0i(dd11, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd11, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) + 
                8\/9\ Alfa2\ MU\ \((D0i(dd0, MU2, ME2, ME2, MU2, T, S, MU2, 
                        0, ME2, 0) + 
                      D0i(dd0, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(
              F7\ SUN1)\) + \((4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, 
                        U, S, MU2, 0, ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 
                        0))\) - 
                4\/9\ Alfa2\ \((D0i(dd12, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                        ME2, 0) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 0) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, T, S, MU2, 0, ME2, 
                        0))\))\)\ \(Mat(F8\ SUN1)\) + 
          4\/9\ Alfa2\ ME\ \((D0i(dd22, MU2, ME2, ME2, MU2, T, S, MU2, 0, 
                  ME2, 0) + 
                D0i(dd22, MU2, ME2, ME2, MU2, U, S, MU2, 0, ME2, 0))\)\ \(Mat(
              F9\ SUN1)\), \((\(-\(\(1\/SW2\^2\)\((2\ Alfa2\ ME\ MU\ \(CKM(1, 
                      Gen1)\)\ \(CKMC(1, 
                      Gen1)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, MW2) + 
                        D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 
                          0, MW2) + 
                        D0i(dd3, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 
                          0, MW2))\)\ \(Mat(
                      F1\ SUN1)\))\)\)\) - \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ ME\
\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                    MQD2(Gen1), MW2, 0, MW2)\)\ \(Mat(
                    F10\ SUN1)\))\)\) + \((\(\(1\/SW2\^2\)\((Alfa2\ ME\ \(CKM(
                          1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, 
                              MW2))\))\)\) + \(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ \
ME\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd3, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, MW2)\))\)\))\)\ \(Mat(
                  F11\ SUN1)\) + \((\((\(Alfa2\ U\ \(CKM(1, Gen1)\)\ \
\(CKMC(1, Gen1)\)\)\/\(2\ SW2\^2\) + \(Alfa2\ ME2\ \(CKM(1, Gen1)\)\ \
\(CKMC(1, Gen1)\)\)\/\(2\ SW2\^2\) + \(Alfa2\ MU2\ \(CKM(1, Gen1)\)\ \
\(CKMC(1, Gen1)\)\)\/SW2\^2 - \(Alfa2\ \((ME2 + MU2)\)\ \(CKM(1, Gen1)\)\ \
\(CKMC(1, Gen1)\)\)\/\(2\ SW2\^2\))\)\ \(D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, 
                        MW2)\) + \(\(1\/SW2\^2\)\((Alfa2\ MU2\ \(CKM(1, 
                          Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd11, MU2, ME2, 
                          ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\) + \((\(Alfa2\ U\ \(CKM(1, Gen1)\)\ \
\(CKMC(1, Gen1)\)\)\/SW2\^2 + \(Alfa2\ MU2\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\
\)\)\/SW2\^2)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2)\) + \(Alfa2\ U\ \(CKM(1, Gen1)\)\ \(CKMC(1, \
Gen1)\)\ \(D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, \
MW2)\)\)\/SW2\^2 + \(\(1\/SW2\^2\)\((Alfa2\ U\ \(CKM(1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \(D0i(dd22, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\) + \((\(Alfa2\ U\ \(CKM(1, Gen1)\)\ \
\(CKMC(1, Gen1)\)\)\/SW2\^2 - \(Alfa2\ ME2\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\
\)\)\/SW2\^2 + \(Alfa2\ MU2\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\)\/SW2\^2)\)\
\ \((D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, MW2) + 
                          D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                            MW2, 0, 
                            MW2))\) + \((\(Alfa2\ \((4\ ME2 + 4\ MU2 + U)\)\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\)\/\(2\ SW2\^2\) - \(5\ Alfa2\ ME2\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\)\/\(2\ SW2\^2\) - \(Alfa2\ MU2\ \(CKM(1, \
Gen1)\)\ \(CKMC(1, Gen1)\)\)\/SW2\^2)\)\ \(D0i(dd3, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, 
                        MW2)\) + \(\(1\/SW2\^2\)\((Alfa2\ MU2\ \(CKM(1, 
                          Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd33, MU2, ME2, 
                          ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\))\)\ \(Mat(
                  F12\ SUN1)\) + \((\(-\(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ ME\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                            MQD2(Gen1), MW2, 0, 
                            MW2)\))\)\)\) - \(\(1\/SW2\^2\)\((Alfa2\ ME\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd13, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, MW2)\))\)\))\)\ \(Mat(
                  F13\ SUN1)\) + \(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ ME2\ \(CKM(
                    1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd1, MU2, ME2, ME2, 
                    MU2, U, S, MQD2(Gen1), MW2, 0, MW2)\)\ \(Mat(
                    F14\ SUN1)\))\)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd33, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F15\ SUN1)\))\)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ ME\ \
MU\ \(CKM(1, Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd3, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F16\ SUN1)\))\)\) - \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ ME\ \
MU\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd13, MU2, ME2, ME2, MU2, U, 
                    S, MQD2(Gen1), MW2, 0, MW2)\)\ \(Mat(
                    F17\ SUN1)\))\)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ \(CKM(
                    1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd00, MU2, ME2, ME2, 
                    MU2, U, S, MQD2(Gen1), MW2, 0, MW2)\)\ \(Mat(
                    F18\ SUN1)\))\)\) + \((\(-\(\(1\/SW2\^2\)\((2\ Alfa2\ ME\ \
MU\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, U, 
                            S, MQD2(Gen1), MW2, 0, 
                            MW2)\))\)\)\) - \(\(1\/SW2\^2\)\((Alfa2\ ME\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd11, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2))\))\)\))\)\ \(Mat(
                  F19\ SUN1)\) + \((\(-\(\(1\/SW2\^2\)\((2\ Alfa2\ MU\ \(CKM(
                            1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd3, MU2, 
                            ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                            MW2)\))\)\)\) - \(\(1\/SW2\^2\)\((Alfa2\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd13, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd33, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2))\))\)\))\)\ \(Mat(
                  F2\ SUN1)\) + \((\(-\(\(1\/SW2\^2\)\((4\ Alfa2\ MU\ \(CKM(
                            1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd12, MU2, 
                            ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                            MW2)\))\)\)\) - \(\(1\/SW2\^2\)\((2\ Alfa2\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd11, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2))\))\)\))\)\ \(Mat(
                  F20\ SUN1)\) - \(\(1\/SW2\^2\)\((Alfa2\ ME\ MU\ \(CKM(1, 
                    Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd1, MU2, ME2, ME2, 
                    MU2, U, S, MQD2(Gen1), MW2, 0, MW2)\)\ \(Mat(
                    F21\ SUN1)\))\)\) + \((\(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ MU\
\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\) + \(\(1\/SW2\^2\)\((Alfa2\ MU\ \(CKM(1, 
                          Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd11, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd12, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2))\))\)\))\)\ \(Mat(
                  F22\ SUN1)\) + \((\(\(1\/SW2\^2\)\((2\ Alfa2\ MU2\ \(CKM(1, 
                          Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd12, MU2, ME2, 
                          ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\) + \(\(1\/SW2\^2\)\((Alfa2\ MU2\ \(CKM(
                          1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd11, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, 
                              MW2))\))\)\) + \(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ \
MU2\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd3, MU2, ME2, ME2, MU2, U, 
                          S, MQD2(Gen1), MW2, 0, MW2)\))\)\))\)\ \(Mat(
                  F23\ SUN1)\) + \((\(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ MU\ \(CKM(
                          1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd12, MU2, 
                          ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd11, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2))\))\)\))\)\ \(Mat(
                  F24\ SUN1)\) + \((\(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ ME\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, 
                          MW2)\))\)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ ME\ \
MU\ \(CKM(1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd11, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2))\))\)\))\)\ \(Mat(
                  F25\ SUN1)\) - \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ ME\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd11, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd12, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F26\ SUN1)\))\)\) + \(\(1\/SW2\^2\)\((Alfa2\ ME\ MU\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd1, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F3\ SUN1)\))\)\) - \(\(1\/SW2\^2\)\((Alfa2\ ME\ \(CKM(1, 
                    Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F4\ SUN1)\))\)\) - \(\(1\/SW2\^2\)\((2\ Alfa2\ \(CKM(1, 
                    Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F5\ SUN1)\))\)\) - \(\(1\/SW2\^2\)\((Alfa2\ ME\ \(CKM(1, 
                    Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd1, MU2, ME2, ME2, 
                    MU2, U, S, MQD2(Gen1), MW2, 0, MW2)\)\ \(Mat(
                    F6\ SUN1)\))\)\) + \((\(\(1\/SW2\^2\)\((Alfa2\ MU\ \(CKM(
                          1, Gen1)\)\ \(CKMC(1, 
                          Gen1)\)\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                              MQD2(Gen1), MW2, 0, MW2) + 
                            D0i(dd13, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, MW2) + 
                            D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), 
                              MW2, 0, 
                              MW2))\))\)\) + \(\(1\/\(2\ SW2\^2\)\)\((Alfa2\ \
MU\ \(CKM(1, Gen1)\)\ \(CKMC(1, Gen1)\)\ \(D0i(dd3, MU2, ME2, ME2, MU2, U, S, 
                          MQD2(Gen1), MW2, 0, MW2)\))\)\))\)\ \(Mat(
                  F7\ SUN1)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ \(CKM(1, 
                    Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd23, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(
                    F8\ SUN1)\))\)\) + \(\(1\/\(4\ SW2\^2\)\)\((Alfa2\ ME\ \
\(CKM(1, Gen1)\)\ \(CKMC(1, 
                    Gen1)\)\ \((D0i(dd12, MU2, ME2, ME2, MU2, U, S, 
                        MQD2(Gen1), MW2, 0, MW2) + 
                      D0i(dd2, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2) + 
                      D0i(dd22, MU2, ME2, ME2, MU2, U, S, MQD2(Gen1), MW2, 0, 
                        MW2))\)\ \(Mat(F9\ SUN1)\))\)\))\)\ \(SumOver(Gen1, 
            3)\))\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([1]\)]\ \  // Length\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`48\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(Hel[_] = 0;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(hRule\)\(=\)\(\ \)\(HelicityME[mat, mat]\)\(\ \ \)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("preparing FORM code in \
"\[InvisibleSpace]"/tmp/m4.frm"\),
        SequenceForm[ "preparing FORM code in ", "/tmp/m4.frm"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> "\[InvisibleSpace]2304\[InvisibleSpace]" \
helicity matrix elements"\),
        SequenceForm[ "> ", 2304, " helicity matrix elements"],
        Editable->False], TraditionalForm]], "Print"],

Cell["running FORM... ", "Print"],

Cell[BoxData[
    \(TraditionalForm\`"ok"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`{Mat(F1, 
          F1) \[Rule] \(-\(1\/16\)\)\ \((2\ ME2 - S)\)\ \((S - 2\ MU2)\), 
      Mat(F1, F10) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F11) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F1, F12) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F13) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F1, F14) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F1, F15) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F1, F16) \[Rule] ME2\ MU2 - \(S\ U\)\/2, 
      Mat(F1, F17) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F1, F18) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F19) \[Rule] 1\/4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F1, F2) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F1, F20) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F1, F21) \[Rule] \(ME2\ MU2\)\/4, 
      Mat(F1, F22) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F1, F23) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F1, F24) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F1, F25) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F1, F26) \[Rule] ME2\ MU2, 
      Mat(F1, F27) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F1, F28) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F1, F29) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F1, F3) \[Rule] 1\/4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F1, F30) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F1, F31) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F1, F32) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F1, F33) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F1, F34) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F1, F35) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F1, F36) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F1, F37) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F1, F38) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F1, F39) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F1, F4) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F1, F40) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F41) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F1, F42) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F1, F43) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F1, F44) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F1, F45) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F46) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F1, F47) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F1, F48) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F5) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F1, F6) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F1, F7) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F1, F8) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F1, F9) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F10, 
          F1) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F10, F10) \[Rule] 4\ ME2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F10, F11) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F10, F12) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F10, F13) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F10, F14) \[Rule] \(-2\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F10, F15) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F10, F16) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F10, F17) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F10, F18) \[Rule] 16\ ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F10, F19) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F10, F2) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F10, 
          F20) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F10, F21) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F10, F22) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F10, F23) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F10, F24) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F10, F25) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F10, F26) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F10, F27) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F10, F28) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F10, F29) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F10, F3) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F10, F30) \[Rule] 2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F10, F31) \[Rule] 16\ ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F10, F32) \[Rule] \(-8\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F10, F33) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F10, F34) \[Rule] ME2\^2\ MU2, 
      Mat(F10, F35) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F10, F36) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F10, F37) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F10, F38) \[Rule] \(-ME\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F10, F39) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F10, F4) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F10, F40) \[Rule] 16\ ME2\^2\ MU2, 
      Mat(F10, F41) \[Rule] 8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F10, F42) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F10, F43) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F10, F44) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F10, F45) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F10, F46) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F10, F47) \[Rule] \(-8\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F10, F48) \[Rule] 64\ ME\ ME2\ MU2, 
      Mat(F10, 
          F5) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F10, F6) \[Rule] 1\/2\ ME2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F10, F7) \[Rule] 
        ME\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F10, F8) \[Rule] \(-4\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F10, 
          F9) \[Rule] \(-2\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F11, F1) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F11, F10) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F11) \[Rule] 1\/4\ MU2\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F11, F12) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F13) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F11, F14) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F15) \[Rule] 
        1\/2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F11, F16) \[Rule] \(-MU\)\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F11, F17) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F11, F18) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F19) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F11, F2) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F11, F20) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F21) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F11, F22) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ MU2, 
      Mat(F11, F23) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F24) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F25) \[Rule] MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F11, F26) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F11, F27) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F28) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F11, F29) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2\^2 + MU2\^2 - 
              T\ U)\), Mat(F11, F3) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F11, F30) \[Rule] 1\/2\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F11, F31) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F32) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F33) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F34) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F11, F35) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F11, F36) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F37) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F11, F38) \[Rule] ME\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F11, F39) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F11, F4) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + T)\), 
      Mat(F11, F40) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F41) \[Rule] \(-2\)\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F11, F42) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F43) \[Rule] 
        1\/4\ MU2\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F11, F44) \[Rule] ME2\ MU2\^2, 
      Mat(F11, F45) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F46) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F47) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F11, F48) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F5) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F11, F6) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F11, F7) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F11, F8) \[Rule] \(-ME\)\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F11, F9) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + T)\), 
      Mat(F12, F1) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F12, F10) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F12, F11) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F12, F12) \[Rule] 1\/4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F12, F13) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F12, F14) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F12, F15) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F12, F16) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F12, F17) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F12, F18) \[Rule] 4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F12, F19) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F12, F2) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F12, F20) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F12, F21) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F12, F22) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F12, F23) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F12, F24) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F12, F25) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F12, F26) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F12, F27) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F12, F28) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F12, F29) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F12, F3) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F12, F30) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F12, F31) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F12, F32) \[Rule] \(-2\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F12, F33) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F12, F34) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F12, F35) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F12, F36) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F12, F37) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F12, F38) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F12, F39) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F12, F4) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F12, F40) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F12, F41) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F12, F42) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F12, F43) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F12, F44) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F12, F45) \[Rule] ME2\ MU2, Mat(F12, F46) \[Rule] ME2\ MU\ MU2, 
      Mat(F12, F47) \[Rule] \(-2\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F12, F48) \[Rule] 16\ ME2\ MU2, 
      Mat(F12, F5) \[Rule] 
        1\/8\ \((\(-ME2\^3\) + \((2\ MU2 + U)\)\ ME2\^2 + \((2\ MU2 - 
                    T)\)\ \((MU2 - U)\)\ ME2 - \((MU2 - U)\)\ \((MU2\^2 - 
                    T\ U)\))\), 
      Mat(F12, F6) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F12, F7) \[Rule] 
        1\/4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F12, F8) \[Rule] \(-\((ME2\^2 - 
                2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F12, F9) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F13, F1) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F13, F10) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F13, F11) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F13, F12) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F13, F13) \[Rule] 
        1\/4\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((2\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((2\ MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    S\ \((S + 2\ T)\))\))\), 
      Mat(F13, F14) \[Rule] \(-\(1\/4\)\)\ ME\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F13, F15) \[Rule] 1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F16) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F13, F17) \[Rule] MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F13, F18) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F13, F19) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F13, F2) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F20) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F13, F21) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F13, F22) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F13, F23) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F13, F24) \[Rule] \(-2\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F13, F25) \[Rule] ME2\ MU\ MU2, 
      Mat(F13, F26) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F13, F27) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F13, F28) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F13, F29) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F13, F3) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F13, F30) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F13, F31) \[Rule] 
        2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F13, F32) \[Rule] \(-ME\)\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F13, F33) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F34) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F35) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F13, F36) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F13, F37) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F13, F38) \[Rule] 
        1\/4\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - MU2\^2 - T\^2 + 
              2\ MU2\ T)\), 
      Mat(F13, F39) \[Rule] ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F13, F4) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F13, F40) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F41) \[Rule] \(-2\)\ ME\ MU2\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F13, F42) \[Rule] 
        1\/2\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F13, F43) \[Rule] ME2\ MU2\^2, 
      Mat(F13, F44) \[Rule] 
        1\/4\ MU2\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F13, F45) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F46) \[Rule] 1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F47) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F13, F48) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F13, F5) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F13, F6) \[Rule] 
        1\/8\ \((\((MU2 + S)\)\ ME2\^2 + \((MU2\^2 - \((2\ S + T)\)\ MU2 - 
                    2\ S\ T)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ T\ MU2 + T\ \((S + T)\))\))\), 
      Mat(F13, F7) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\ MU2 - \(S\ \
U\)\/2)\), Mat(F13, F8) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F13, F9) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F14, F1) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F14, F10) \[Rule] \(-2\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F14, F11) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F14, F12) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F14, F13) \[Rule] \(-\(1\/4\)\)\ ME\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F14, F14) \[Rule] 1\/4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F14, F15) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F14, F16) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F14, F17) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F14, F18) \[Rule] \(-8\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F14, F19) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F14, F2) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F14, F20) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F14, F21) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F14, F22) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F14, F23) \[Rule] ME2\ MU2, 
      Mat(F14, F24) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F14, F25) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F14, F26) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F14, F27) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F14, F28) \[Rule] 
        1\/8\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F14, F29) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F14, F3) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F14, F30) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F14, F31) \[Rule] \(-2\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F14, F32) \[Rule] \((ME2 + MU2 - T)\)\^2, 
      Mat(F14, F33) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F14, F34) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F14, F35) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F14, F36) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F14, F37) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F14, F38) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F14, F39) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F14, F4) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F14, F40) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F14, F41) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), Mat(F14, F42) \[Rule] ME\ ME2\ MU2, 
      Mat(F14, F43) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F14, F44) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F14, F45) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F14, F46) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F14, F47) \[Rule] 4\ ME2\ MU2, 
      Mat(F14, F48) \[Rule] \(-8\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F14, F5) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F14, F6) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F14, F7) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F14, F8) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F14, F9) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F15, F1) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F15, F10) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F15, F11) \[Rule] 
        1\/2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F15, F12) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F15, F13) \[Rule] 1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F14) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F15, F15) \[Rule] \((2\ MU2 - 
              S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 2\ MU2\ T + 
              T\ \((S + T)\))\), 
      Mat(F15, F16) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F17) \[Rule] \(-ME\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F15, F18) \[Rule] 8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F15, F19) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F2) \[Rule] 
        1\/4\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F15, F20) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F21) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F22) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F23) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F24) \[Rule] \(-2\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F25) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F26) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F27) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F15, F28) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F29) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F3) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F15, F30) \[Rule] \(-2\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F31) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F15, F32) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F15, F33) \[Rule] ME2\ MU2\^2, 
      Mat(F15, F34) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F15, F35) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F36) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F15, F37) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F38) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F39) \[Rule] \(-MU\)\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F4) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F15, F40) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F15, F41) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F42) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F15, F43) \[Rule] 
        1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F15, F44) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F15, F45) \[Rule] ME2\ MU\ MU2, 
      Mat(F15, F46) \[Rule] 4\ ME2\ MU2\^2, 
      Mat(F15, F47) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F48) \[Rule] 16\ ME2\ MU\ MU2, 
      Mat(F15, F5) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F15, F6) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F15, F7) \[Rule] 
        1\/2\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F15, F8) \[Rule] 
        2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F15, F9) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F16, F1) \[Rule] ME2\ MU2 - \(S\ U\)\/2, 
      Mat(F16, F10) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F11) \[Rule] \(-MU\)\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F16, F12) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F13) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F16, F14) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F16, F15) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F16, F16) \[Rule] 4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F16, F17) \[Rule] 4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F16, F18) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F19) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F16, F2) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F16, F20) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F16, F21) \[Rule] ME2\ MU2, Mat(F16, F22) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F16, F23) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F16, F24) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F16, F25) \[Rule] 4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F16, F26) \[Rule] 16\ ME2\ MU2, 
      Mat(F16, F27) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F16, F28) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F16, F29) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F16, F3) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F16, F30) \[Rule] 4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F16, F31) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F16, 
          F32) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F16, F33) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F16, F34) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F35) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F16, F36) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F16, F37) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F16, F38) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F16, F39) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F16, F4) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F16, F40) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F41) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F16, F42) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F16, F43) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F16, F44) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F16, F45) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F46) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F16, F47) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F16, F48) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F5) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F16, F6) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F16, F7) \[Rule] 
        ME\ \((\(-ME2\^2\) + 2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F16, F8) \[Rule] \(-8\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F16, F9) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + 
              S\ \((U - MU2)\))\), 
      Mat(F17, F1) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F17, F10) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F11) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F17, F12) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F13) \[Rule] MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F17, F14) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F17, F15) \[Rule] \(-ME\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F17, F16) \[Rule] 4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F17, F17) \[Rule] \(-\((2\ ME2 - S)\)\)\ \((S - 2\ MU2)\), 
      Mat(F17, F18) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F19) \[Rule] ME2\ MU2, 
      Mat(F17, F2) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F17, F20) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F17, F21) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F17, F22) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F17, F23) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F17, F24) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F17, F25) \[Rule] 4\ ME2\ MU2, 
      Mat(F17, F26) \[Rule] 4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F17, F27) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F17, F28) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F17, F29) \[Rule] ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F17, F3) \[Rule] \(-\(1\/4\)\)\ \((2\ ME2 - S)\)\ \((S - 2\ MU2)\), 
      Mat(F17, F30) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F17, F31) \[Rule] 
        2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F17, F32) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F17, F33) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F17, F34) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F35) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F17, F36) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F17, F37) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F17, F38) \[Rule] ME\ ME2\ MU2, 
      Mat(F17, F39) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F17, 
          F4) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F17, F40) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F41) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F17, F42) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F17, F43) \[Rule] ME2\ MU\ MU2, 
      Mat(F17, F44) \[Rule] MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F17, F45) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F46) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F17, F47) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F17, F48) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F17, F5) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F17, F6) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F17, F7) \[Rule] ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F17, F8) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F17, F9) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F1) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F10) \[Rule] 16\ ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F18, F11) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F18, F12) \[Rule] 4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F18, F13) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F18, F14) \[Rule] \(-8\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F18, F15) \[Rule] 8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F18, F16) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F17) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F18, F18) \[Rule] 64\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F18, F19) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F18, F2) \[Rule] 2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F18, F20) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F18, F21) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F22) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F23) \[Rule] \(-8\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F18, F24) \[Rule] \(-16\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F18, F25) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F18, F26) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F27) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F18, F28) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F18, F29) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F18, F3) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F18, F30) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F18, F31) \[Rule] 64\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F18, F32) \[Rule] \(-32\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F18, F33) \[Rule] 4\ ME2\ MU\ MU2, 
      Mat(F18, F34) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F18, F35) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F18, F36) \[Rule] 4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F18, F37) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F18, F38) \[Rule] \(-4\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F18, F39) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F18, F4) \[Rule] \(-2\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F18, F40) \[Rule] 64\ ME\ ME2\ MU2, 
      Mat(F18, F41) \[Rule] 32\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F18, F42) \[Rule] 16\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F18, F43) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F18, F44) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F18, F45) \[Rule] 16\ ME2\ MU2, 
      Mat(F18, F46) \[Rule] 16\ ME2\ MU\ MU2, 
      Mat(F18, F47) \[Rule] \(-32\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F18, F48) \[Rule] 256\ ME2\ MU2, 
      Mat(F18, F5) \[Rule] \(-2\)\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F18, F6) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F18, F7) \[Rule] 
        4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F18, F8) \[Rule] \(-16\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F18, 
          F9) \[Rule] \(-8\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F19, F1) \[Rule] 1\/4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F19, F10) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F11) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F19, F12) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F13) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F19, F14) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F19, F15) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F19, F16) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F19, F17) \[Rule] ME2\ MU2, 
      Mat(F19, F18) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F19) \[Rule] \(-\(1\/16\)\)\ \((2\ ME2 - S)\)\ \((S - 
              2\ MU2)\), 
      Mat(F19, F2) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F19, F20) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F19, F21) \[Rule] 1\/4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F19, F22) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F19, F23) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F19, F24) \[Rule] 
        1\/2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F19, 
          F25) \[Rule] \(-\(1\/4\)\)\ \((2\ ME2 - S)\)\ \((S - 2\ MU2)\), 
      Mat(F19, F26) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F19, F27) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F19, F28) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F19, F29) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F19, F3) \[Rule] \(ME2\ MU2\)\/4, 
      Mat(F19, F30) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F19, F31) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F19, F32) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F19, F33) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F19, F34) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F19, F35) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F19, F36) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F19, F37) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F19, F38) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F19, F39) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F19, F4) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F19, F40) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F41) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F19, F42) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F19, F43) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F19, F44) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F19, F45) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F46) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F19, F47) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F19, F48) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F5) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F19, F6) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F19, F7) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F19, F8) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F19, F9) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F2, F1) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F2, F10) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F2, F11) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F2, F12) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F2, F13) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F14) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F2, F15) \[Rule] 
        1\/4\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F2, F16) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F17) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F2, F18) \[Rule] 2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F2, F19) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F2) \[Rule] 
        1\/16\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F2, F20) \[Rule] \(-\(1\/8\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F21) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F22) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F23) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F24) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F25) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F26) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F27) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F2, F28) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F29) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, 
          F3) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F2, 
          F30) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F31) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F2, F32) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F2, F33) \[Rule] \(ME2\ MU2\^2\)\/4, 
      Mat(F2, F34) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F2, F35) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F36) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F2, F37) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F38) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F39) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F4) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F2, F40) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F2, F41) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F42) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F2, F43) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F2, F44) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F2, F45) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F2, F46) \[Rule] ME2\ MU2\^2, 
      Mat(F2, F47) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F48) \[Rule] 4\ ME2\ MU\ MU2, 
      Mat(F2, F5) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F2, F6) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F2, F7) \[Rule] 
        1\/8\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F2, F8) \[Rule] 
        1\/2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - 
              T\ U)\), 
      Mat(F2, F9) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F20, F1) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F10) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F11) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F12) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F13) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F14) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F20, F15) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F16) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F17) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F18) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F19) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F20, F2) \[Rule] \(-\(1\/8\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F20) \[Rule] 
        1\/16\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F20, F21) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F20, F22) \[Rule] 
        1\/8\ ME2\ \((\(-MU2\^2\) - ME2\ MU2 + U\ MU2 + ME2\ S - S\ U)\), 
      Mat(F20, F23) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F20, F24) \[Rule] 
        1\/2\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((3\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((S\ \((S + 2\ T)\) - 2\ MU2\ \((S + T)\))\))\), 
      Mat(F20, F25) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F20, F26) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F20, F27) \[Rule] \(ME2\ MU2\^2\)\/4, 
      Mat(F20, F28) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F29) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F3) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F30) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F31) \[Rule] ME2\ MU2\^2, Mat(F20, F32) \[Rule] ME2\ MU\ MU2, 
      Mat(F20, F33) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F20, F34) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F20, F35) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F36) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F20, F37) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F38) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F39) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F4) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F20, F40) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F20, F41) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F42) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F20, F43) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F20, F44) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F20, F45) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F20, F46) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F20, F47) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F20, F48) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F20, F5) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F20, F6) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F20, F7) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F20, F8) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F20, F9) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F21, F1) \[Rule] \(ME2\ MU2\)\/4, 
      Mat(F21, F10) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F11) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F21, F12) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F13) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F21, F14) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F21, F15) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F21, F16) \[Rule] ME2\ MU2, 
      Mat(F21, F17) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F21, F18) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F19) \[Rule] 1\/4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F21, F2) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F21, F20) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F21, F21) \[Rule] \(-\(1\/16\)\)\ \((2\ ME2 - S)\)\ \((S - 
              2\ MU2)\), 
      Mat(F21, F22) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F21, F23) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F21, F24) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F21, F25) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F21, F26) \[Rule] ME2\ MU2 - \(S\ U\)\/2, 
      Mat(F21, F27) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F21, F28) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F21, F29) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F21, F3) \[Rule] 1\/4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F21, F30) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F21, F31) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F21, F32) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F21, F33) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F21, F34) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F35) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F21, F36) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F21, F37) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F21, F38) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F21, F39) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F21, F4) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F21, F40) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F41) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F21, F42) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F21, F43) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F21, F44) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F21, F45) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F46) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F21, F47) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F21, F48) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F21, F5) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F21, F6) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F21, F7) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F21, F8) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F21, F9) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F22, F1) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F22, F10) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F11) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ MU2, 
      Mat(F22, F12) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F13) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F22, F14) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F22, F15) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F22, F16) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F22, F17) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F22, F18) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F19) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F22, F2) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F22, F20) \[Rule] 
        1\/8\ ME2\ \((\(-MU2\^2\) - ME2\ MU2 + U\ MU2 + ME2\ S - S\ U)\), 
      Mat(F22, F21) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F22, F22) \[Rule] 1\/4\ ME2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F22, F23) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F22, F24) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F22, F25) \[Rule] ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F22, F26) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F22, F27) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F22, F28) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F22, F29) \[Rule] ME2\^2\ MU2, 
      Mat(F22, F3) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F22, F30) \[Rule] ME2\^2\ MU\ MU2, 
      Mat(F22, F31) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F22, F32) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F22, F33) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F22, F34) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F35) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F22, F36) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F22, F37) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F22, F38) \[Rule] 
        1\/4\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F22, F39) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F22, F4) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F22, F40) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F41) \[Rule] \(-2\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F22, F42) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F22, F43) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F22, F44) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2\^2 + MU2\^2 - 
              T\ U)\), 
      Mat(F22, F45) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F46) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F22, F47) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F22, F48) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F5) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F22, F6) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F22, F7) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F22, F8) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F22, F9) \[Rule] 
        1\/2\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F1) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F10) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F23, F11) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F23, F12) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F23, F13) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F23, F14) \[Rule] ME2\ MU2, 
      Mat(F23, F15) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F23, F16) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F17) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F23, F18) \[Rule] \(-8\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F23, F19) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F23, F2) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F23, F20) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F23, F21) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F22) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F23) \[Rule] 1\/4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F23, F24) \[Rule] \(-2\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F23, F25) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F23, F26) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F27) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F23, F28) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F23, F29) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F23, F3) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F23, F30) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F23, F31) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F23, F32) \[Rule] 4\ ME2\ MU2, 
      Mat(F23, F33) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F23, F34) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F23, F35) \[Rule] 
        1\/8\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F23, F36) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F23, F37) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F23, F38) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F23, F39) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F23, F4) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F23, F40) \[Rule] \(-2\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F23, F41) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F23, F42) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F23, F43) \[Rule] \(-\(1\/4\)\)\ ME\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F23, F44) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F23, F45) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F23, F46) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F23, F47) \[Rule] \((ME2 + MU2 - T)\)\^2, 
      Mat(F23, F48) \[Rule] \(-8\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F23, F5) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F23, F6) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F23, F7) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F23, F8) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), Mat(F23, F9) \[Rule] ME\ ME2\ MU2, 
      Mat(F24, F1) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F10) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F24, F11) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F12) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), 
      Mat(F24, F13) \[Rule] \(-2\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F24, F14) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F24, F15) \[Rule] \(-2\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F24, F16) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F17) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F24, F18) \[Rule] \(-16\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F24, F19) \[Rule] 
        1\/2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F24, F2) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F24, F20) \[Rule] 
        1\/2\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((3\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((S\ \((S + 2\ T)\) - 2\ MU2\ \((S + T)\))\))\), 
      Mat(F24, F21) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F24, F22) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F24, F23) \[Rule] \(-2\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F24, F24) \[Rule] 
        4\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((2\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((2\ MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    S\ \((S + 2\ T)\))\))\), 
      Mat(F24, F25) \[Rule] 
        2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F24, F26) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F24, F27) \[Rule] ME2\ MU2\^2, 
      Mat(F24, F28) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F29) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F3) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F24, F30) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F31) \[Rule] 16\ ME2\ MU2\^2, 
      Mat(F24, F32) \[Rule] \(-8\)\ ME2\ MU\ MU2, 
      Mat(F24, F33) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F24, F34) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F24, F35) \[Rule] \(-\(1\/2\)\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \
\((2\ S + U)\)\ MU2 - S\ U)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F24, F36) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F24, F37) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F24, F38) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F24, F39) \[Rule] \(-2\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \((2\ S \
+ U)\)\ MU2 - S\ U)\)\ ME2 + S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F24, F4) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F24, F40) \[Rule] 16\ ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F24, F41) \[Rule] \(-8\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F24, F42) \[Rule] 4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F24, F43) \[Rule] 
        2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F24, F44) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F24, F45) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F24, F46) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F24, F47) \[Rule] \(-8\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F24, F48) \[Rule] 64\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F24, F5) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F24, F6) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F24, F7) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F24, F8) \[Rule] \(-4\)\ MU\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\^2)\)\ \((ME2 + MU2 - U)\), 
      Mat(F24, F9) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F25, F1) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F25, F10) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F11) \[Rule] MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F25, F12) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F13) \[Rule] ME2\ MU\ MU2, 
      Mat(F25, F14) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F25, F15) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F25, F16) \[Rule] 4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F25, F17) \[Rule] 4\ ME2\ MU2, 
      Mat(F25, F18) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F19) \[Rule] \(-\(1\/4\)\)\ \((2\ ME2 - S)\)\ \((S - 
              2\ MU2)\), 
      Mat(F25, F2) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F25, F20) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F25, F21) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F25, F22) \[Rule] ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F25, F23) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F25, F24) \[Rule] 
        2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F25, F25) \[Rule] \(-\((2\ ME2 - S)\)\)\ \((S - 2\ MU2)\), 
      Mat(F25, F26) \[Rule] 4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F25, F27) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F25, F28) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F25, F29) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F25, F3) \[Rule] ME2\ MU2, 
      Mat(F25, F30) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F25, 
          F31) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F25, F32) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F25, F33) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F25, F34) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F25, F35) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F25, F36) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F25, F37) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F25, F38) \[Rule] ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F25, F39) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F25, F4) \[Rule] 
        1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F25, F40) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F41) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F25, F42) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F25, F43) \[Rule] MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F25, F44) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F25, F45) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F46) \[Rule] \(-ME\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F25, F47) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F25, F48) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F5) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F25, F6) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F25, F7) \[Rule] ME\ ME2\ MU2, 
      Mat(F25, F8) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F25, F9) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F26, F1) \[Rule] ME2\ MU2, 
      Mat(F26, F10) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F11) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F26, F12) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F13) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F26, F14) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F26, F15) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F26, F16) \[Rule] 16\ ME2\ MU2, 
      Mat(F26, F17) \[Rule] 4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F26, F18) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F19) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F26, F2) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F26, F20) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F26, F21) \[Rule] ME2\ MU2 - \(S\ U\)\/2, 
      Mat(F26, F22) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F26, F23) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F26, F24) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F26, F25) \[Rule] 4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F26, F26) \[Rule] 4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F26, F27) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F26, F28) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F26, F29) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F26, F3) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F26, F30) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F26, F31) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F26, F32) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F26, F33) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F26, F34) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F35) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F26, F36) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F26, F37) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F26, F38) \[Rule] 
        ME\ \((\(-ME2\^2\) + 2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F26, F39) \[Rule] 4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F26, F4) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F26, F40) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F41) \[Rule] \(-8\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F26, F42) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + 
              S\ \((U - MU2)\))\), 
      Mat(F26, F43) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F26, F44) \[Rule] \(-MU\)\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F26, F45) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F46) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F26, F47) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F26, F48) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F5) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F26, F6) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F26, F7) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F26, F8) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F26, F9) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F27, F1) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F27, F10) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F27, F11) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F12) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F27, F13) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F27, F14) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F27, F15) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F27, F16) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F27, F17) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F27, F18) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F27, F19) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F2) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F27, F20) \[Rule] \(ME2\ MU2\^2\)\/4, 
      Mat(F27, F21) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F22) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F23) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F27, F24) \[Rule] ME2\ MU2\^2, 
      Mat(F27, F25) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F26) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F27) \[Rule] 
        1\/16\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F27, F28) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F29) \[Rule] 
        1\/8\ ME2\ \((\(-MU2\^2\) - ME2\ MU2 + U\ MU2 + ME2\ S - S\ U)\), 
      Mat(F27, F3) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F27, F30) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F31) \[Rule] 
        1\/2\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((3\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((S\ \((S + 2\ T)\) - 2\ MU2\ \((S + T)\))\))\), 
      Mat(F27, F32) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F27, 
          F33) \[Rule] \(-\(1\/8\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F34) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F27, F35) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F36) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F27, F37) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F38) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F39) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F4) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F27, F40) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F41) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F27, F42) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F27, F43) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F44) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F27, F45) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F46) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F47) \[Rule] ME2\ MU\ MU2, 
      Mat(F27, F48) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F27, F5) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F6) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F27, F7) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F8) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F27, F9) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F28, F1) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F28, F10) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F28, F11) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F28, F12) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F13) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F28, F14) \[Rule] 
        1\/8\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F28, F15) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F16) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F28, F17) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F28, F18) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F19) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F28, F2) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F20) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F28, F21) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F28, F22) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F28, F23) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F28, F24) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F28, F25) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F28, F26) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F28, F27) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F28, F28) \[Rule] 
        1\/16\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F28, F29) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F28, F3) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F28, F30) \[Rule] 
        1\/4\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F28, F31) \[Rule] \(-\(1\/2\)\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \
\((2\ S + U)\)\ MU2 - S\ U)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F28, F32) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F28, F33) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F28, F34) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F35) \[Rule] \(ME2\^2\ MU2\^2\)\/4, 
      Mat(F28, F36) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F28, F37) \[Rule] 
        1\/8\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F28, F38) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), Mat(F28, F39) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F28, F4) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F28, 
          F40) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F41) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F28, F42) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F28, F43) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F28, F44) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F28, F45) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F46) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F28, F47) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F28, F48) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F28, F5) \[Rule] 
        1\/8\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F28, F6) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F28, 
          F7) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F28, F8) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F28, F9) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F29, F1) \[Rule] 
        1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F29, F10) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F11) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2\^2 + MU2\^2 - 
              T\ U)\), 
      Mat(F29, F12) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F13) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F29, F14) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F29, F15) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F29, F16) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F29, F17) \[Rule] ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F29, F18) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F19) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F29, F2) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F29, F20) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F29, F21) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F29, F22) \[Rule] ME2\^2\ MU2, 
      Mat(F29, F23) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F29, F24) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F29, F25) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F29, F26) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F29, F27) \[Rule] 
        1\/8\ ME2\ \((\(-MU2\^2\) - ME2\ MU2 + U\ MU2 + ME2\ S - S\ U)\), 
      Mat(F29, F28) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F29, F29) \[Rule] 1\/4\ ME2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F29, F3) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F29, F30) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F29, F31) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F29, F32) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F29, F33) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F29, F34) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F35) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F29, F36) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F29, F37) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F29, F38) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F29, F39) \[Rule] ME2\^2\ MU\ MU2, 
      Mat(F29, F4) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F29, F40) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F41) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F29, F42) \[Rule] 
        1\/2\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F29, F43) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F29, F44) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ MU2, 
      Mat(F29, F45) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F46) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F29, F47) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F29, F48) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F5) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F29, F6) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F29, F7) \[Rule] 
        1\/4\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F29, F8) \[Rule] \(-2\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F29, F9) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F3, F1) \[Rule] 1\/4\ ME2\ \((MU2 - S\/2)\), 
      Mat(F3, F10) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, F11) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F3, F12) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, F13) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F3, F14) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F3, F15) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), Mat(F3, F16) \[Rule] ME2\ \((MU2 - S\/2)\), 
      Mat(F3, F17) \[Rule] \(-\(1\/4\)\)\ \((2\ ME2 - S)\)\ \((S - 2\ MU2)\), 
      Mat(F3, F18) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, F19) \[Rule] \(ME2\ MU2\)\/4, 
      Mat(F3, F2) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F3, F20) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F3, F21) \[Rule] 1\/4\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F22) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F23) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F3, F24) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F3, F25) \[Rule] ME2\ MU2, 
      Mat(F3, F26) \[Rule] MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F27) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F3, F28) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F3, F29) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F3, F3) \[Rule] \(-\(1\/16\)\)\ \((2\ ME2 - S)\)\ \((S - 2\ MU2)\), 
      Mat(F3, F30) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F3, F31) \[Rule] 
        1\/2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F3, F32) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F3, F33) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F3, F34) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, F35) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F3, F36) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F3, F37) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F3, F38) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F3, F39) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F3, F4) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F3, F40) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, 
          F41) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F3, F42) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F3, F43) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F3, F44) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F3, F45) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, F46) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F3, F47) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F3, F48) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F3, F5) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F3, F6) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F3, F7) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F3, F8) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F3, F9) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F30, F1) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F30, F10) \[Rule] 2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F30, F11) \[Rule] 1\/2\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F30, F12) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F13) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F30, F14) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F30, F15) \[Rule] \(-2\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F16) \[Rule] 4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F30, F17) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F30, 
          F18) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F19) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F30, F2) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F20) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F30, F21) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F30, F22) \[Rule] ME2\^2\ MU\ MU2, 
      Mat(F30, F23) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F30, F24) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F30, F25) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F30, F26) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F30, F27) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F30, F28) \[Rule] 
        1\/4\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F30, F29) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F30, F3) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F30, F30) \[Rule] \(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
          3\ MU2\ \((2\ MU2 - T - 
                U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                      6\ U\ T + U\^2)\)\ MU2 - 
                T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                U)\)\ \((MU2\^2 - T\ U)\), 
      Mat(F30, F31) \[Rule] \(-2\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \((2\ S \
+ U)\)\ MU2 - S\ U)\)\ ME2 + S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F30, F32) \[Rule] 
        2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F30, F33) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F30, F34) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F35) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F30, F36) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F30, F37) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F30, F38) \[Rule] 
        1\/2\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), Mat(F30, F39) \[Rule] 4\ ME2\^2\ MU2\^2, 
      Mat(F30, F4) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F30, 
          F40) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F41) \[Rule] 
        2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F30, F42) \[Rule] 2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F30, F43) \[Rule] ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F30, F44) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F30, F45) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F46) \[Rule] \(-MU\)\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F30, F47) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F30, F48) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F30, F5) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F30, F6) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F30, F7) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F30, F8) \[Rule] 
        2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F30, F9) \[Rule] \(-ME\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F31, 
          F1) \[Rule] \(-\(1\/2\)\)\ ME\ \((MU2\^2 - U\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ U)\), 
      Mat(F31, F10) \[Rule] 16\ ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F31, F11) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F12) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F31, F13) \[Rule] 
        2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F31, F14) \[Rule] \(-2\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F31, F15) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F31, F16) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F31, F17) \[Rule] 
        2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F31, F18) \[Rule] 64\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F31, F19) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F31, F2) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F31, F20) \[Rule] ME2\ MU2\^2, 
      Mat(F31, F21) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F22) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F23) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F31, F24) \[Rule] 16\ ME2\ MU2\^2, 
      Mat(F31, F25) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F31, F26) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F27) \[Rule] 
        1\/2\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((3\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((S\ \((S + 2\ T)\) - 2\ MU2\ \((S + T)\))\))\), 
      Mat(F31, F28) \[Rule] \(-\(1\/2\)\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \
\((2\ S + U)\)\ MU2 - S\ U)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F31, F29) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F31, F3) \[Rule] 
        1\/2\ ME\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F31, F30) \[Rule] \(-2\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \((2\ S \
+ U)\)\ MU2 - S\ U)\)\ ME2 + S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F31, F31) \[Rule] 
        4\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((2\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((2\ MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    S\ \((S + 2\ T)\))\))\), 
      Mat(F31, F32) \[Rule] \(-8\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F31, F33) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F31, F34) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F31, F35) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F36) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F31, F37) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F31, F38) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F31, F39) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F4) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F31, F40) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F31, F41) \[Rule] \(-4\)\ MU\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\^2)\)\ \((ME2 + MU2 - U)\), 
      Mat(F31, F42) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F31, F43) \[Rule] \(-2\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F31, F44) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F31, F45) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F31, 
          F46) \[Rule] \(-2\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - 
              MU2\^2 + T\ U)\), Mat(F31, F47) \[Rule] \(-8\)\ ME2\ MU\ MU2, 
      Mat(F31, F48) \[Rule] \(-16\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F31, 
          F5) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F31, F6) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F31, F7) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F31, F8) \[Rule] \(-8\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F31, F9) \[Rule] 4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F32, F1) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F32, F10) \[Rule] \(-8\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F32, F11) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F32, F12) \[Rule] \(-2\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F32, F13) \[Rule] \(-ME\)\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F32, F14) \[Rule] \((ME2 + MU2 - T)\)\^2, 
      Mat(F32, F15) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F32, F16) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F32, F17) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F32, F18) \[Rule] \(-32\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F32, F19) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F32, F2) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F32, F20) \[Rule] ME2\ MU\ MU2, 
      Mat(F32, F21) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F32, F22) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F32, F23) \[Rule] 4\ ME2\ MU2, 
      Mat(F32, F24) \[Rule] \(-8\)\ ME2\ MU\ MU2, 
      Mat(F32, F25) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F32, F26) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F32, F27) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F32, F28) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F32, F29) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F32, F3) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F32, F30) \[Rule] 
        2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F32, F31) \[Rule] \(-8\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F32, F32) \[Rule] 4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F32, F33) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F32, F34) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F32, F35) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F32, F36) \[Rule] ME\ ME2\ MU2, 
      Mat(F32, F37) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F32, F38) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F32, F39) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F32, F4) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F32, F40) \[Rule] \(-8\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F32, F41) \[Rule] \(-4\)\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), Mat(F32, F42) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F32, F43) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F32, F44) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F32, F45) \[Rule] \(-2\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F32, F46) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F32, F47) \[Rule] 16\ ME2\ MU2, 
      Mat(F32, F48) \[Rule] \(-32\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F32, F5) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F32, F6) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F32, F7) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F32, F8) \[Rule] 4\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F32, F9) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F33, F1) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F10) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F33, F11) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F12) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F33, F13) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, F14) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F15) \[Rule] ME2\ MU2\^2, 
      Mat(F33, F16) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F17) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, F18) \[Rule] 4\ ME2\ MU\ MU2, 
      Mat(F33, F19) \[Rule] \(-\(1\/16\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), Mat(F33, F2) \[Rule] \(ME2\ MU2\^2\)\/4, 
      Mat(F33, F20) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F33, F21) \[Rule] 1\/16\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F33, F22) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F23) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F33, F24) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F33, F25) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F33, F26) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F27) \[Rule] \(-\(1\/8\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F28) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F29) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F3) \[Rule] 1\/8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, 
          F30) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F31) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F32) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F33) \[Rule] 
        1\/16\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F33, F34) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F33, F35) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F36) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F33, F37) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F33, F38) \[Rule] 
        1\/8\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F33, F39) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F33, F4) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F33, F40) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F33, F41) \[Rule] 
        1\/2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - 
              T\ U)\), 
      Mat(F33, F42) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F33, F43) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, F44) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F33, F45) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F33, F46) \[Rule] 
        1\/4\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F33, F47) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F33, F48) \[Rule] 2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F33, F5) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, F6) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F33, F7) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, F8) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F33, F9) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F34, F1) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F34, F10) \[Rule] ME2\^2\ MU2, 
      Mat(F34, F11) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F34, F12) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F34, F13) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F34, F14) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F34, F15) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F34, F16) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F34, F17) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F34, F18) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F34, F19) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F34, F2) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F34, F20) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F34, F21) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F34, F22) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F34, F23) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F34, F24) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F34, F25) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F34, F26) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F34, F27) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F34, F28) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F34, F29) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F34, F3) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F34, F30) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F34, F31) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F34, F32) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F34, F33) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F34, F34) \[Rule] 
        1\/16\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F34, F35) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F34, F36) \[Rule] \(-\(1\/8\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F34, F37) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F34, 
          F38) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F34, F39) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F34, F4) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F34, F40) \[Rule] 1\/2\ ME2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F34, F41) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F34, F42) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F34, F43) \[Rule] 
        1\/8\ \((\((MU2 + S)\)\ ME2\^2 + \((MU2\^2 - \((2\ S + T)\)\ MU2 - 
                    2\ S\ T)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ T\ MU2 + T\ \((S + T)\))\))\), 
      Mat(F34, F44) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F34, F45) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F34, F46) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F34, F47) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F34, F48) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F34, F5) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F34, F6) \[Rule] \(ME2\^2\ MU2\)\/4, 
      Mat(F34, F7) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F34, F8) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F34, F9) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F35, F1) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F35, F10) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F11) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F35, F12) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F13) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F35, F14) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F35, F15) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F35, F16) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F35, F17) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F35, F18) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F19) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F35, F2) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F35, F20) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F35, F21) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F35, F22) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F35, F23) \[Rule] 
        1\/8\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F35, F24) \[Rule] \(-\(1\/2\)\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \
\((2\ S + U)\)\ MU2 - S\ U)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F35, F25) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F35, F26) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F35, F27) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F35, F28) \[Rule] \(ME2\^2\ MU2\^2\)\/4, 
      Mat(F35, F29) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F35, 
          F3) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), Mat(F35, F30) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F35, F31) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F35, F32) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F35, F33) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F34) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F35, F35) \[Rule] 
        1\/16\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F35, F36) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F35, F37) \[Rule] 
        1\/8\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F35, F38) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F35, F39) \[Rule] 
        1\/4\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F35, F4) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F35, F40) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F35, F41) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F35, F42) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F35, 
          F43) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F35, F44) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F35, F45) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F46) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F47) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F35, F48) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F5) \[Rule] 
        1\/8\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F35, F6) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F35, F7) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F35, F8) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F35, F9) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F36, F1) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F36, F10) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F36, F11) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F36, F12) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F36, F13) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F36, F14) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F36, F15) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F36, F16) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F36, F17) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F36, F18) \[Rule] 4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F36, F19) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F36, F2) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F36, F20) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F36, F21) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F36, F22) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F36, F23) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F36, F24) \[Rule] ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F36, F25) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F36, F26) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F36, F27) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F36, F28) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F36, F29) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F36, F3) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F36, F30) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F36, F31) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F36, F32) \[Rule] ME\ ME2\ MU2, 
      Mat(F36, F33) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F36, F34) \[Rule] \(-\(1\/8\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F36, F35) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F36, F36) \[Rule] 
        1\/16\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F36, F37) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F36, F38) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F36, F39) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F36, F4) \[Rule] \(ME2\^2\ MU2\)\/4, 
      Mat(F36, F40) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F36, F41) \[Rule] 
        1\/2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F36, F42) \[Rule] 
        1\/4\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F36, F43) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F36, F44) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + 
              T)\), Mat(F36, 
          F45) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F36, 
          F46) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F36, F47) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F36, F48) \[Rule] \(-2\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F36, F5) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F36, F6) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F36, F7) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F36, F8) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F36, F9) \[Rule] ME2\^2\ MU2, 
      Mat(F37, F1) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F37, F10) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F37, F11) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F37, F12) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F37, F13) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F37, F14) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F15) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F37, F16) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F37, F17) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F37, F18) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F37, F19) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F37, F2) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F37, F20) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F21) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F37, F22) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F37, F23) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F24) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F25) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F37, 
          F26) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F37, F27) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F37, F28) \[Rule] 
        1\/8\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F37, F29) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F37, F3) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F37, F30) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F37, F31) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F37, F32) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F33) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F37, F34) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F37, F35) \[Rule] 
        1\/8\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F37, F36) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F37, F37) \[Rule] 
        1\/16\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F37, F38) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F37, F39) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F37, F4) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F40) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F37, F41) \[Rule] 
        1\/2\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 - 
              MU2\ \((\(-4\)\ MU2 + 3\ T + 
                    U)\)\ ME2\^2 - \((\((3\ T + U)\)\ MU2\^2 - 
                    T\ \((T + 5\ U)\)\ MU2 + 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F37, F42) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F37, F43) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F37, F44) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F37, F45) \[Rule] 
        1\/8\ \((\(-ME2\^3\) + \((2\ MU2 + U)\)\ ME2\^2 + \((2\ MU2 - 
                    T)\)\ \((MU2 - U)\)\ ME2 - \((MU2 - U)\)\ \((MU2\^2 - 
                    T\ U)\))\), 
      Mat(F37, F46) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F37, F47) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F37, F48) \[Rule] \(-2\)\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F37, F5) \[Rule] \(ME2\^2\ MU2\^2\)\/4, 
      Mat(F37, F6) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F37, F7) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F37, F8) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F37, F9) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F38, F1) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F38, F10) \[Rule] \(-ME\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F38, F11) \[Rule] ME\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F38, F12) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F38, F13) \[Rule] 
        1\/4\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - MU2\^2 - T\^2 + 
              2\ MU2\ T)\), 
      Mat(F38, F14) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F38, F15) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F38, F16) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F38, F17) \[Rule] ME\ ME2\ MU2, 
      Mat(F38, F18) \[Rule] \(-4\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F38, F19) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F38, F2) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F38, F20) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F38, F21) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F38, F22) \[Rule] 
        1\/4\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F38, F23) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F38, F24) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F38, F25) \[Rule] ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F38, F26) \[Rule] 
        ME\ \((\(-ME2\^2\) + 2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F38, F27) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F38, F28) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F38, F29) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F38, F3) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F38, F30) \[Rule] 
        1\/2\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F38, F31) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F38, F32) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F38, F33) \[Rule] 
        1\/8\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F38, F34) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F38, F35) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F38, F36) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F38, F37) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F38, F38) \[Rule] 
        1\/4\ \((ME2\^3 + \((2\ MU2 - S - 2\ U)\)\ ME2\^2 + \((MU2 - 
                    U)\)\ \((MU2 - 2\ S - U)\)\ ME2 + 
              S\ \((MU2 - U)\)\ \((\(-MU2\) + S + U)\))\), 
      Mat(F38, F39) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F38, F4) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F38, F40) \[Rule] 
        ME\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F38, F41) \[Rule] \(-MU\)\ \((ME2\^3 - \((S + 
                    2\ T)\)\ ME2\^2 + \((MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    T\ \((3\ S + T)\))\)\ ME2 + 
              S\ \((MU2 - T)\)\ \((\(-MU2\) + S + T)\))\), 
      Mat(F38, F42) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F38, F43) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\
\), Mat(F38, 
          F44) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F38, F45) \[Rule] 
        1\/4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F38, F46) \[Rule] 
        1\/2\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F38, F47) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F38, F48) \[Rule] 
        4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F38, F5) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F38, F6) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F38, F7) \[Rule] ME2\^2\ MU2, 
      Mat(F38, F8) \[Rule] \(-2\)\ ME2\^2\ MU\ MU2, 
      Mat(F38, F9) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F39, F1) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F39, F10) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F11) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F39, F12) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F13) \[Rule] ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F39, F14) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F39, F15) \[Rule] \(-MU\)\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F39, F16) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F39, F17) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F39, 
          F18) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, 
          F19) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F39, F2) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F39, F20) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F39, F21) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F39, F22) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F39, F23) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F39, F24) \[Rule] \(-2\)\ MU\ \((MU2\ ME2\^2 + \((MU2\^2 - \((2\ S \
+ U)\)\ MU2 - S\ U)\)\ ME2 + S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F39, F25) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F39, F26) \[Rule] 
        4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F39, F27) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F39, F28) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F39, F29) \[Rule] ME2\^2\ MU\ MU2, 
      Mat(F39, F3) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F39, F30) \[Rule] 4\ ME2\^2\ MU2\^2, 
      Mat(F39, F31) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F39, F32) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F39, F33) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F34) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F39, F35) \[Rule] 
        1\/4\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F39, F36) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F39, F37) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F39, 
          F38) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F39, F39) \[Rule] \(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
          3\ MU2\ \((2\ MU2 - T - 
                U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                      6\ U\ T + U\^2)\)\ MU2 - 
                T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                U)\)\ \((MU2\^2 - T\ U)\), 
      Mat(F39, F4) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F39, F40) \[Rule] 2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F39, F41) \[Rule] 
        2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F39, F42) \[Rule] \(-ME\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F39, 
          F43) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F39, F44) \[Rule] 1\/2\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F39, F45) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F46) \[Rule] \(-2\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F47) \[Rule] 
        2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F39, F48) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F5) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F39, F6) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F39, F7) \[Rule] 
        1\/2\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F39, F8) \[Rule] 
        2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F39, F9) \[Rule] 2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F4, F1) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F4, F10) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F4, F11) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + T)\), 
      Mat(F4, F12) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F4, F13) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F4, F14) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F4, F15) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F4, F16) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F4, F17) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F4, F18) \[Rule] \(-2\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F4, F19) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F4, F2) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F4, F20) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F4, F21) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F4, F22) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F4, F23) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F4, F24) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F4, F25) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F4, F26) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F4, F27) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F4, F28) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F4, 
          F29) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F4, F3) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F4, F30) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F4, F31) \[Rule] 
        ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F4, F32) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F4, F33) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F4, F34) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F4, F35) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F4, F36) \[Rule] \(ME2\^2\ MU2\)\/4, 
      Mat(F4, F37) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F4, F38) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F4, F39) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F4, F4) \[Rule] 
        1\/16\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F4, F40) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F4, F41) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F4, F42) \[Rule] ME2\^2\ MU2, 
      Mat(F4, F43) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F4, F44) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F4, F45) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F4, F46) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), Mat(F4, F47) \[Rule] ME\ ME2\ MU2, 
      Mat(F4, F48) \[Rule] 4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F4, F5) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F4, F6) \[Rule] \(-\(1\/8\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F4, F7) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F4, F8) \[Rule] 
        1\/2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F4, F9) \[Rule] 
        1\/4\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F40, F1) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F40, F10) \[Rule] 16\ ME2\^2\ MU2, 
      Mat(F40, F11) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F40, F12) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F40, F13) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F40, F14) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F40, F15) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F40, F16) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F40, F17) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F40, F18) \[Rule] 64\ ME\ ME2\ MU2, 
      Mat(F40, F19) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F40, F2) \[Rule] ME\ ME2\ MU\ MU2, 
      Mat(F40, F20) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F40, F21) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F40, F22) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F40, F23) \[Rule] \(-2\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F40, F24) \[Rule] 16\ ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F40, F25) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F40, F26) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F40, F27) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - 
                    T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F40, F28) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F40, F29) \[Rule] \(-2\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F40, F3) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F40, F30) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F40, F31) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F40, F32) \[Rule] \(-8\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F40, F33) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F40, F34) \[Rule] 1\/2\ ME2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F40, F35) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F40, F36) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F40, F37) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F40, F38) \[Rule] 
        ME\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F40, F39) \[Rule] 2\ ME\ ME2\ MU2\ \((\(-ME2\) - MU2 + U)\), 
      Mat(F40, F4) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F40, F40) \[Rule] 4\ ME2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F40, F41) \[Rule] \(-4\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), 
      Mat(F40, F42) \[Rule] \(-2\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F40, F43) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F40, F44) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F40, F45) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F40, F46) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F40, F47) \[Rule] \(-8\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F40, F48) \[Rule] 16\ ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F40, F5) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F40, F6) \[Rule] ME2\^2\ MU2, 
      Mat(F40, F7) \[Rule] \(-ME\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F40, F8) \[Rule] 8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F40, F9) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F41, F1) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F41, F10) \[Rule] 8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F41, F11) \[Rule] \(-2\)\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F41, F12) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F41, F13) \[Rule] \(-2\)\ ME\ MU2\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F41, F14) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F41, F15) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F41, F16) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F41, F17) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F41, F18) \[Rule] 32\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F41, F19) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F41, F2) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F41, F20) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F41, F21) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F41, F22) \[Rule] \(-2\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F41, F23) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F41, F24) \[Rule] \(-8\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F41, F25) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F41, F26) \[Rule] \(-8\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F41, F27) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F41, F28) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F41, F29) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F41, 
          F3) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F41, F30) \[Rule] 
        2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F41, F31) \[Rule] \(-4\)\ MU\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\^2)\)\ \((ME2 + MU2 - U)\), 
      Mat(F41, F32) \[Rule] \(-4\)\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F41, F33) \[Rule] 
        1\/2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - 
              T\ U)\), 
      Mat(F41, F34) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F41, F35) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F41, F36) \[Rule] 
        1\/2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F41, F37) \[Rule] 
        1\/2\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 - 
              MU2\ \((\(-4\)\ MU2 + 3\ T + 
                    U)\)\ ME2\^2 - \((\((3\ T + U)\)\ MU2\^2 - 
                    T\ \((T + 5\ U)\)\ MU2 + 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F41, F38) \[Rule] \(-MU\)\ \((ME2\^3 - \((S + 
                    2\ T)\)\ ME2\^2 + \((MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    T\ \((3\ S + T)\))\)\ ME2 + 
              S\ \((MU2 - T)\)\ \((\(-MU2\) + S + T)\))\), 
      Mat(F41, F39) \[Rule] 
        2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F41, F4) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F41, F40) \[Rule] \(-4\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F41, 
          F41) \[Rule] \(-4\)\ \((ME2 + MU2 - U)\)\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F41, F42) \[Rule] 
        2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F41, F43) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F41, F44) \[Rule] \(-ME\)\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F41, F45) \[Rule] \(-\((ME2\^2 - 
                2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F41, F46) \[Rule] 
        2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F41, F47) \[Rule] 4\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F41, F48) \[Rule] \(-16\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F41, F5) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F41, F6) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F41, F7) \[Rule] \(-2\)\ ME2\^2\ MU\ MU2, 
      Mat(F41, F8) \[Rule] 16\ ME2\^2\ MU2\^2, 
      Mat(F41, F9) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F42, F1) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F42, F10) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F42, F11) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F42, F12) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F42, F13) \[Rule] 
        1\/2\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F42, F14) \[Rule] ME\ ME2\ MU2, 
      Mat(F42, F15) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F42, F16) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F42, F17) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F42, F18) \[Rule] 16\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F42, F19) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F42, F2) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F42, F20) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F42, F21) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F42, F22) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F42, F23) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F42, F24) \[Rule] 4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F42, F25) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F42, F26) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + 
              S\ \((U - MU2)\))\), 
      Mat(F42, F27) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F42, F28) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F42, F29) \[Rule] 1\/2\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F42, F3) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F42, F30) \[Rule] 2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F42, F31) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F42, F32) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F42, F33) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F42, F34) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F42, F35) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F42, F36) \[Rule] 
        1\/4\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F42, F37) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F42, F38) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F42, F39) \[Rule] \(-ME\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F42, F4) \[Rule] ME2\^2\ MU2, 
      Mat(F42, F40) \[Rule] \(-2\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F42, F41) \[Rule] 
        2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F42, F42) \[Rule] \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F42, F43) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F42, F44) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + 
              T)\), Mat(F42, 
          F45) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F42, F46) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F42, F47) \[Rule] 
        2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F42, F48) \[Rule] \(-8\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F42, F5) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F42, F6) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F42, F7) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F42, F8) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F42, F9) \[Rule] 4\ ME2\^2\ MU2, 
      Mat(F43, F1) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F43, F10) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F11) \[Rule] 
        1\/4\ MU2\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F43, F12) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F13) \[Rule] ME2\ MU2\^2, 
      Mat(F43, F14) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F43, F15) \[Rule] 1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F16) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F43, F17) \[Rule] ME2\ MU\ MU2, 
      Mat(F43, F18) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F19) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F43, F2) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F20) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F43, F21) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F43, F22) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F43, F23) \[Rule] \(-\(1\/4\)\)\ ME\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F43, F24) \[Rule] 
        2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F43, F25) \[Rule] MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F43, F26) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F43, F27) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F43, F28) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F43, F29) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F43, F3) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F43, F30) \[Rule] ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F43, F31) \[Rule] \(-2\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F43, F32) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F43, F33) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F34) \[Rule] 
        1\/8\ \((\((MU2 + S)\)\ ME2\^2 + \((MU2\^2 - \((2\ S + T)\)\ MU2 - 
                    2\ S\ T)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ T\ MU2 + T\ \((S + T)\))\))\), 
      Mat(F43, F35) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F43, F36) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F43, F37) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F43, F38) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\
\), Mat(F43, F39) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F43, F4) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F43, F40) \[Rule] \(-ME2\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F43, F41) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F43, F42) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F43, F43) \[Rule] 
        1\/4\ \((MU2\^3 - \((S + 2\ T)\)\ MU2\^2 + T\ \((2\ S + T)\)\ MU2 + 
              ME2\^2\ \((MU2 - S)\) - S\ T\ \((S + T)\) + 
              ME2\ \((2\ MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    S\ \((S + 2\ T)\))\))\), 
      Mat(F43, F44) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F43, F45) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F43, F46) \[Rule] 1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F47) \[Rule] \(-ME\)\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F43, F48) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F43, 
          F5) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F43, F6) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F43, F7) \[Rule] 
        1\/4\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - MU2\^2 - T\^2 + 
              2\ MU2\ T)\), 
      Mat(F43, F8) \[Rule] \(-2\)\ ME\ MU2\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F43, F9) \[Rule] 
        1\/2\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F44, F1) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F44, F10) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F11) \[Rule] ME2\ MU2\^2, 
      Mat(F44, F12) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F13) \[Rule] 
        1\/4\ MU2\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F44, F14) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F15) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F16) \[Rule] \(-2\)\ ME2\ MU\ MU2, 
      Mat(F44, F17) \[Rule] MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F44, F18) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F19) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F44, F2) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F20) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F21) \[Rule] 1\/4\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F44, F22) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2\^2 + MU2\^2 - 
              T\ U)\), 
      Mat(F44, F23) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F24) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F25) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F44, F26) \[Rule] \(-MU\)\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F44, F27) \[Rule] 1\/8\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F28) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F44, F29) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ MU2, 
      Mat(F44, F3) \[Rule] 1\/4\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F44, F30) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F44, F31) \[Rule] \(-ME\)\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F32) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F33) \[Rule] 
        1\/8\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F44, F34) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F35) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F44, F36) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + 
              T)\), Mat(F44, 
          F37) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F44, F38) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F44, F39) \[Rule] 1\/2\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F44, F4) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F40) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F41) \[Rule] \(-ME\)\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F44, F42) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + 
              T)\), Mat(F44, F43) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F44, F44) \[Rule] 1\/4\ MU2\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F44, F45) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F46) \[Rule] 
        1\/2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F44, F47) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F44, F48) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F44, F5) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F44, F6) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F44, F7) \[Rule] ME\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F44, F8) \[Rule] \(-2\)\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F44, F9) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F45, F1) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F45, F10) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F45, F11) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F45, F12) \[Rule] ME2\ MU2, 
      Mat(F45, F13) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F45, F14) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F45, F15) \[Rule] ME2\ MU\ MU2, 
      Mat(F45, F16) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F45, F17) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F45, F18) \[Rule] 16\ ME2\ MU2, 
      Mat(F45, F19) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F45, F2) \[Rule] \(ME2\ MU\ MU2\)\/4, 
      Mat(F45, F20) \[Rule] 1\/4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F45, F21) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F45, F22) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F45, F23) \[Rule] \(-\(1\/2\)\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F45, F24) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F45, F25) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F45, F26) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F45, F27) \[Rule] \(-\(1\/8\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F45, F28) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F45, F29) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F45, F3) \[Rule] 1\/8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F45, F30) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F45, F31) \[Rule] \(-MU\)\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F45, F32) \[Rule] \(-2\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F45, F33) \[Rule] 1\/8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F45, F34) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F45, F35) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F45, F36) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F45, F37) \[Rule] 
        1\/8\ \((\(-ME2\^3\) + \((2\ MU2 + U)\)\ ME2\^2 + \((2\ MU2 - 
                    T)\)\ \((MU2 - U)\)\ ME2 - \((MU2 - U)\)\ \((MU2\^2 - 
                    T\ U)\))\), 
      Mat(F45, F38) \[Rule] 
        1\/4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F45, F39) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F45, F4) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F45, F40) \[Rule] ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F45, F41) \[Rule] \(-\((ME2\^2 - 
                2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F45, F42) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F45, F43) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F45, F44) \[Rule] 1\/4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F45, F45) \[Rule] 1\/4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F45, F46) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F45, F47) \[Rule] \(-2\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F45, F48) \[Rule] 4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F45, F5) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F45, F6) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F45, F7) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F45, F8) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F45, F9) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F46, F1) \[Rule] \(-\(1\/2\)\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F10) \[Rule] 4\ ME\ ME2\ MU\ MU2, 
      Mat(F46, F11) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F12) \[Rule] ME2\ MU\ MU2, 
      Mat(F46, F13) \[Rule] 1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F14) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F15) \[Rule] 4\ ME2\ MU2\^2, 
      Mat(F46, F16) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F17) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F18) \[Rule] 16\ ME2\ MU\ MU2, 
      Mat(F46, F19) \[Rule] \(-\(1\/4\)\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + 
              MU2 - U)\), Mat(F46, F2) \[Rule] ME2\ MU2\^2, 
      Mat(F46, F20) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F46, F21) \[Rule] 1\/4\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F46, F22) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F23) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F46, F24) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F46, F25) \[Rule] \(-ME\)\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - U)\), 
      Mat(F46, F26) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F27) \[Rule] \(-\(1\/2\)\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F28) \[Rule] \(-\(1\/4\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F29) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F3) \[Rule] 1\/2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F30) \[Rule] \(-MU\)\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F31) \[Rule] \(-2\)\ MU2\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F32) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F33) \[Rule] 
        1\/4\ \((2\ MU2 - S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 
              2\ MU2\ T + T\ \((S + T)\))\), 
      Mat(F46, F34) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F46, F35) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F36) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F46, F37) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F46, F38) \[Rule] 
        1\/2\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F46, F39) \[Rule] \(-2\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F46, F4) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F46, F40) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F46, F41) \[Rule] 
        2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F46, F42) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F46, F43) \[Rule] 
        1\/2\ ME\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F44) \[Rule] 
        1\/2\ ME\ MU\ \((MU2\^2 - T\ MU2 + ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F46, F45) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F46, F46) \[Rule] \((2\ MU2 - 
              S)\)\ \((ME2\^2 - \((S + 2\ T)\)\ ME2 + MU2\^2 - 2\ MU2\ T + 
              T\ \((S + T)\))\), 
      Mat(F46, F47) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F46, F48) \[Rule] 8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F46, F5) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F6) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F46, F7) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F8) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F46, F9) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F47, F1) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F47, F10) \[Rule] \(-8\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F47, F11) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F47, F12) \[Rule] \(-2\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F47, F13) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F47, F14) \[Rule] 4\ ME2\ MU2, 
      Mat(F47, F15) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F47, F16) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F47, F17) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F47, F18) \[Rule] \(-32\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F47, F19) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F47, F2) \[Rule] \(-\(1\/2\)\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F47, F20) \[Rule] 1\/2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F47, F21) \[Rule] 1\/2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F47, F22) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F47, F23) \[Rule] \((ME2 + MU2 - T)\)\^2, 
      Mat(F47, F24) \[Rule] \(-8\)\ MU\ \((ME2\ MU2 - \(S\ T\)\/2)\), 
      Mat(F47, F25) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F47, F26) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F47, F27) \[Rule] ME2\ MU\ MU2, 
      Mat(F47, F28) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F47, F29) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F47, F3) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F47, F30) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F47, F31) \[Rule] \(-8\)\ ME2\ MU\ MU2, 
      Mat(F47, F32) \[Rule] 16\ ME2\ MU2, 
      Mat(F47, F33) \[Rule] ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F47, F34) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F47, F35) \[Rule] 
        1\/2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F47, F36) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F47, F37) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F47, F38) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F47, F39) \[Rule] 
        2\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F47, F4) \[Rule] ME\ ME2\ MU2, 
      Mat(F47, F40) \[Rule] \(-8\)\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F47, F41) \[Rule] 4\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F47, F42) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F47, F43) \[Rule] \(-ME\)\ \((MU2\^2 - T\ MU2 + 
              ME2\ \((MU2 - S)\) + S\ T)\), 
      Mat(F47, F44) \[Rule] 2\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F47, F45) \[Rule] \(-2\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F47, F46) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F47, F47) \[Rule] 4\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F47, F48) \[Rule] \(-32\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F47, F5) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F47, F6) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F47, F7) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F47, F8) \[Rule] \(-4\)\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), Mat(F47, F9) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F48, F1) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F48, F10) \[Rule] 64\ ME\ ME2\ MU2, 
      Mat(F48, F11) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F48, F12) \[Rule] 16\ ME2\ MU2, 
      Mat(F48, F13) \[Rule] 8\ ME\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F48, F14) \[Rule] \(-8\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F48, F15) \[Rule] 16\ ME2\ MU\ MU2, 
      Mat(F48, F16) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F48, F17) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F48, F18) \[Rule] 256\ ME2\ MU2, 
      Mat(F48, F19) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F48, F2) \[Rule] 4\ ME2\ MU\ MU2, 
      Mat(F48, F20) \[Rule] 4\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F48, F21) \[Rule] \(-2\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F48, F22) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F48, F23) \[Rule] \(-8\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F48, F24) \[Rule] 64\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F48, F25) \[Rule] 8\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F48, F26) \[Rule] \(-32\)\ ME\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F48, F27) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F48, F28) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F48, F29) \[Rule] \(-8\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F48, F3) \[Rule] 2\ ME\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F48, F30) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F48, F31) \[Rule] \(-16\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F48, F32) \[Rule] \(-32\)\ MU2\ \((ME2 - S\/2)\), 
      Mat(F48, F33) \[Rule] 2\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F48, F34) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F48, F35) \[Rule] \(-2\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F48, F36) \[Rule] \(-2\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F48, F37) \[Rule] \(-2\)\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F48, F38) \[Rule] 
        4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F48, F39) \[Rule] \(-8\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F48, F4) \[Rule] 4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F48, F40) \[Rule] 16\ ME\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F48, F41) \[Rule] \(-16\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F48, 
          F42) \[Rule] \(-8\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F48, F43) \[Rule] \(-4\)\ ME\ \((2\ MU2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F48, F44) \[Rule] 4\ ME\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F48, F45) \[Rule] 4\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F48, F46) \[Rule] 8\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F48, F47) \[Rule] \(-32\)\ ME2\ \((MU2 - S\/2)\), 
      Mat(F48, F48) \[Rule] 64\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F48, F5) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F48, F6) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F48, F7) \[Rule] \(-4\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F48, F8) \[Rule] 32\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F48, F9) \[Rule] 16\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F5, F1) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F5, F10) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F5, F11) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((S - 2\ MU2)\), 
      Mat(F5, F12) \[Rule] 
        1\/8\ \((\(-ME2\^3\) + \((2\ MU2 + U)\)\ ME2\^2 + \((2\ MU2 - 
                    T)\)\ \((MU2 - U)\)\ ME2 - \((MU2 - U)\)\ \((MU2\^2 - 
                    T\ U)\))\), 
      Mat(F5, F13) \[Rule] 1\/8\ ME\ MU2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F5, F14) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F15) \[Rule] 
        1\/4\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F5, F16) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F5, F17) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F5, F18) \[Rule] \(-2\)\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F5, F19) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F5, F2) \[Rule] 
        1\/16\ MU\ \((ME2 + MU2 - 
              U)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F5, F20) \[Rule] \(-\(1\/16\)\)\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2\^2 + \((2\ MU2 - T - U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F5, F21) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F5, F22) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F5, F23) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F24) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F5, F25) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F5, F26) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F5, F27) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F28) \[Rule] 
        1\/8\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F5, F29) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F5, F3) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F5, F30) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F5, F31) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F32) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F33) \[Rule] 1\/8\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F5, F34) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F5, F35) \[Rule] 
        1\/8\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F5, F36) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F37) \[Rule] \(ME2\^2\ MU2\^2\)\/4, 
      Mat(F5, F38) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F5, F39) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F5, F4) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F5, F40) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F5, F41) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F5, F42) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F43) \[Rule] \(-\(1\/8\)\)\ ME\ MU2\ \((\(-ME2\^2\) + 
              2\ T\ ME2 - MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F5, F44) \[Rule] 1\/4\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F5, F45) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F5, F46) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F5, F47) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F5, F48) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F5, F5) \[Rule] 
        1\/16\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 + 
              3\ MU2\ \((2\ MU2 - T - 
                    U)\)\ ME2\^2 + \((\(-3\)\ \((T + U)\)\ MU2\^2 + \((T\^2 + 
                          6\ U\ T + U\^2)\)\ MU2 - 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F5, F6) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F5, 
          F7) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F5, F8) \[Rule] 
        1\/2\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 - 
              MU2\ \((\(-4\)\ MU2 + 3\ T + 
                    U)\)\ ME2\^2 - \((\((3\ T + U)\)\ MU2\^2 - 
                    T\ \((T + 5\ U)\)\ MU2 + 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F5, F9) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F6, F1) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F6, F10) \[Rule] 1\/2\ ME2\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F6, F11) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F6, F12) \[Rule] 1\/8\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F6, F13) \[Rule] 
        1\/8\ \((\((MU2 + S)\)\ ME2\^2 + \((MU2\^2 - \((2\ S + T)\)\ MU2 - 
                    2\ S\ T)\)\ ME2 + 
              S\ \((MU2\^2 - 2\ T\ MU2 + T\ \((S + T)\))\))\), 
      Mat(F6, F14) \[Rule] \(-\(1\/8\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F6, F15) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F6, F16) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F6, F17) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F6, F18) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F6, F19) \[Rule] 1\/8\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F6, F2) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F6, F20) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F6, F21) \[Rule] 1\/16\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F6, F22) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F6, F23) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F6, F24) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F6, F25) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F6, F26) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F6, F27) \[Rule] \(-\(1\/16\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F6, F28) \[Rule] 
        1\/16\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F6, F29) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F6, F3) \[Rule] \(-\(1\/16\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F6, F30) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F6, F31) \[Rule] ME\ ME2\ MU\ \((MU2 - S\/2)\), 
      Mat(F6, F32) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F6, F33) \[Rule] 1\/16\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F6, F34) \[Rule] \(ME2\^2\ MU2\)\/4, 
      Mat(F6, F35) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F6, F36) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F6, F37) \[Rule] 1\/8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F6, F38) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F6, F39) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F6, F4) \[Rule] \(-\(1\/8\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F6, F40) \[Rule] ME2\^2\ MU2, 
      Mat(F6, F41) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F6, F42) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F6, F43) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F6, F44) \[Rule] 
        1\/8\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F6, F45) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F6, F46) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F6, F47) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F6, F48) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F6, F5) \[Rule] \(-\(1\/16\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F6, F6) \[Rule] 
        1\/16\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F6, F7) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F6, F8) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F6, F9) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F7, F1) \[Rule] 1\/4\ ME\ ME2\ \((MU2 - S\/2)\), 
      Mat(F7, F10) \[Rule] 
        ME\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F7, F11) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F7, F12) \[Rule] 
        1\/4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F7, F13) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\ MU2 - \(S\ \
U\)\/2)\), Mat(F7, F14) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F7, F15) \[Rule] 
        1\/2\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F7, F16) \[Rule] 
        ME\ \((\(-ME2\^2\) + 2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F7, F17) \[Rule] ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F7, F18) \[Rule] 
        4\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F7, F19) \[Rule] \(ME\ ME2\ MU2\)\/4, 
      Mat(F7, F2) \[Rule] 
        1\/8\ \((\(-MU2\)\ ME2\^2 - \((MU2\^2 - \((2\ S + U)\)\ MU2 - 
                    S\ U)\)\ ME2 - 
              S\ \((MU2\^2 - 2\ U\ MU2 + U\ \((S + U)\))\))\), 
      Mat(F7, F20) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F7, F21) \[Rule] 1\/4\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F7, F22) \[Rule] 1\/4\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F7, F23) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F7, F24) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), Mat(F7, F25) \[Rule] ME\ ME2\ MU2, 
      Mat(F7, F26) \[Rule] \(-2\)\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F7, F27) \[Rule] \(-\(1\/8\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F7, F28) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F7, F29) \[Rule] 
        1\/4\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F7, F3) \[Rule] 1\/4\ ME\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F7, F30) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F7, F31) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F7, F32) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F7, F33) \[Rule] 1\/8\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F7, F34) \[Rule] 1\/8\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F7, F35) \[Rule] 
        1\/8\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F7, F36) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F7, F37) \[Rule] 1\/4\ ME2\^2\ MU\ MU2, 
      Mat(F7, F38) \[Rule] ME2\^2\ MU2, 
      Mat(F7, F39) \[Rule] 
        1\/2\ ME2\ MU\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F7, F4) \[Rule] \(-\(1\/8\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F7, F40) \[Rule] \(-ME\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F7, F41) \[Rule] \(-2\)\ ME2\^2\ MU\ MU2, 
      Mat(F7, F42) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F7, F43) \[Rule] 
        1\/4\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - MU2\^2 - T\^2 + 
              2\ MU2\ T)\), 
      Mat(F7, F44) \[Rule] ME\ MU\ MU2\ \((ME2 - S\/2)\), 
      Mat(F7, F45) \[Rule] \(-\(1\/4\)\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F7, F46) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F7, F47) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F7, F48) \[Rule] \(-4\)\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F7, F5) \[Rule] \(-\(1\/8\)\)\ ME2\ MU\ \((S\ U - 2\ ME2\ MU2)\), 
      Mat(F7, F6) \[Rule] \(-\(1\/8\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F7, F7) \[Rule] 
        1\/4\ \((ME2\^3 + \((2\ MU2 - S - 2\ U)\)\ ME2\^2 + \((MU2 - 
                    U)\)\ \((MU2 - 2\ S - U)\)\ ME2 + 
              S\ \((MU2 - U)\)\ \((\(-MU2\) + S + U)\))\), 
      Mat(F7, F8) \[Rule] \(-MU\)\ \((ME2\^3 - \((S + 
                    2\ T)\)\ ME2\^2 + \((MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    T\ \((3\ S + T)\))\)\ ME2 + 
              S\ \((MU2 - T)\)\ \((\(-MU2\) + S + T)\))\), 
      Mat(F7, F9) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F8, F1) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F8, 
          F10) \[Rule] \(-4\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F8, 
          F11) \[Rule] \(-ME\)\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F8, F12) \[Rule] \(-\((ME2\^2 - 
                2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F8, F13) \[Rule] ME\ MU2\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F8, F14) \[Rule] ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F8, F15) \[Rule] 
        2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - T\ U)\), 
      Mat(F8, F16) \[Rule] \(-8\)\ ME\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F8, F17) \[Rule] 2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F8, F18) \[Rule] \(-16\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F8, 
          F19) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F8, F2) \[Rule] 
        1\/2\ MU\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - MU2\ ME2 + MU2\^2 - 
              T\ U)\), 
      Mat(F8, F20) \[Rule] 
        1\/2\ MU\ \((\(-ME2\^3\) + \((\(-2\)\ MU2 + 2\ T + U)\)\ ME2\^2 - 
              T\ \((\(-3\)\ MU2 + T + 2\ U)\)\ ME2 + \((MU2 - 
                    T)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F8, F21) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((2\ MU2 - T - 
                    U)\)\ ME2 - MU2\^2 + T\ U)\), 
      Mat(F8, F22) \[Rule] \(-ME2\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F8, 
          F23) \[Rule] \(-MU2\)\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F8, F24) \[Rule] \(-4\)\ MU\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\^2)\)\ \((ME2 + MU2 - U)\), 
      Mat(F8, F25) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F8, F26) \[Rule] \(-4\)\ ME\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + 
              MU2 - U)\), 
      Mat(F8, F27) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F8, F28) \[Rule] 
        1\/2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F8, F29) \[Rule] \(-2\)\ ME2\ MU\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F8, F3) \[Rule] 1\/2\ ME\ MU\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F8, F30) \[Rule] 
        2\ ME2\ MU2\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F8, F31) \[Rule] \(-8\)\ ME2\ MU\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F8, F32) \[Rule] 4\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F8, F33) \[Rule] 1\/2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F8, F34) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F8, F35) \[Rule] 
        1\/2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F8, F36) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F8, F37) \[Rule] ME2\^2\ MU2\^2, 
      Mat(F8, F38) \[Rule] \(-2\)\ ME2\^2\ MU\ MU2, 
      Mat(F8, F39) \[Rule] 
        2\ ME2\ MU2\ \((\(-ME2\^2\) + \((\(-2\)\ MU2 + T + U)\)\ ME2 + 
              MU2\^2 - T\ U)\), 
      Mat(F8, F4) \[Rule] 
        1\/2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F8, F40) \[Rule] 8\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F8, F41) \[Rule] 16\ ME2\^2\ MU2\^2, 
      Mat(F8, F42) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F8, F43) \[Rule] \(-2\)\ ME\ MU2\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F8, F44) \[Rule] \(-2\)\ ME\ MU2\^2\ \((ME2 - S\/2)\), 
      Mat(F8, F45) \[Rule] 2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F8, F46) \[Rule] 2\ ME2\ MU\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F8, F47) \[Rule] \(-4\)\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + 
              S\ \((T - MU2)\))\), 
      Mat(F8, F48) \[Rule] 32\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F8, F5) \[Rule] 
        1\/2\ \((\(-ME2\^4\) + \((T + U)\)\ ME2\^3 - 
              MU2\ \((\(-4\)\ MU2 + 3\ T + 
                    U)\)\ ME2\^2 - \((\((3\ T + U)\)\ MU2\^2 - 
                    T\ \((T + 5\ U)\)\ MU2 + 
                    T\ U\ \((T + U)\))\)\ ME2 - \((MU2 - T)\)\ \((MU2 - 
                    U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F8, F6) \[Rule] \(-\(1\/2\)\)\ ME\ \((ME2\^3 - \((2\ MU2 + 
                    U)\)\ ME2\^2 - \((2\ MU2 - T)\)\ \((MU2 - 
                    U)\)\ ME2 + \((MU2 - U)\)\ \((MU2\^2 - T\ U)\))\), 
      Mat(F8, F7) \[Rule] \(-MU\)\ \((ME2\^3 - \((S + 
                    2\ T)\)\ ME2\^2 + \((MU2\^2 - 2\ \((S + T)\)\ MU2 + 
                    T\ \((3\ S + T)\))\)\ ME2 + 
              S\ \((MU2 - T)\)\ \((\(-MU2\) + S + T)\))\), 
      Mat(F8, F8) \[Rule] \(-4\)\ \((ME2 + MU2 - U)\)\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F8, F9) \[Rule] 
        2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F9, F1) \[Rule] \(-\(1\/4\)\)\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - 
              U)\), Mat(F9, 
          F10) \[Rule] \(-2\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F9, F11) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((\(-ME2\) - MU2 + T)\), 
      Mat(F9, F12) \[Rule] \(-\(1\/2\)\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F9, F13) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F9, F14) \[Rule] 1\/2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F9, F15) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F9, 
          F16) \[Rule] \(-2\)\ MU\ \((ME2\^2 + \((MU2 - U)\)\ ME2 + 
              S\ \((U - MU2)\))\), 
      Mat(F9, F17) \[Rule] \(-2\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F9, F18) \[Rule] \(-8\)\ ME\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F9, F19) \[Rule] 1\/4\ MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F9, F2) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F9, F20) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - T)\)\^2, 
      Mat(F9, F21) \[Rule] 1\/2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F9, F22) \[Rule] 1\/2\ ME\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F9, F23) \[Rule] ME\ ME2\ MU2, 
      Mat(F9, F24) \[Rule] \(-2\)\ ME\ MU\ \((\(-ME2\^2\) + 2\ T\ ME2 - 
              MU2\^2 - T\^2 + 2\ MU2\ T)\), 
      Mat(F9, F25) \[Rule] MU\ \((2\ ME2 - S)\)\ \((ME2 + MU2 - T)\), 
      Mat(F9, F26) \[Rule] 2\ ME2\ MU\ \((ME2 + MU2 - T)\), 
      Mat(F9, F27) \[Rule] 1\/4\ ME\ MU\ \((ME2 + MU2 - U)\)\^2, 
      Mat(F9, F28) \[Rule] \(-\(1\/4\)\)\ ME\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F9, 
          F29) \[Rule] \(-\(1\/2\)\)\ ME\ MU\ \((ME2\^2 + \((MU2 - 
                    U)\)\ ME2 + S\ \((U - MU2)\))\), 
      Mat(F9, F3) \[Rule] \(-\(1\/2\)\)\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F9, F30) \[Rule] \(-ME\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\)\ \((ME2 + MU2 - 
              U)\), Mat(F9, F31) \[Rule] 
        4\ ME\ MU\ \((ME2\ MU2 - \(S\ U\)\/2)\), 
      Mat(F9, F32) \[Rule] 2\ ME\ \((ME2\^2 + MU2\^2 - T\ U)\), 
      Mat(F9, F33) \[Rule] \(-\(1\/4\)\)\ ME\ MU\ \((ME2 + MU2 - 
              T)\)\ \((ME2 + MU2 - U)\), 
      Mat(F9, F34) \[Rule] \(-\(1\/2\)\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F9, F35) \[Rule] 1\/2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F9, F36) \[Rule] ME2\^2\ MU2, 
      Mat(F9, F37) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F9, F38) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F9, F39) \[Rule] 2\ ME\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F9, F4) \[Rule] 
        1\/4\ \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\), 
      Mat(F9, F40) \[Rule] \(-2\)\ ME2\ MU2\ \((S - 2\ ME2)\), 
      Mat(F9, F41) \[Rule] \(-2\)\ ME\ ME2\ MU2\ \((ME2 + MU2 - U)\), 
      Mat(F9, F42) \[Rule] 4\ ME2\^2\ MU2, 
      Mat(F9, F43) \[Rule] 
        1\/2\ MU2\ \((ME2\^2 + \((MU2 - T)\)\ ME2 + S\ \((T - MU2)\))\), 
      Mat(F9, F44) \[Rule] 1\/2\ ME2\ MU2\ \((ME2 + MU2 - T)\), 
      Mat(F9, F45) \[Rule] ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F9, F46) \[Rule] \(-ME\)\ MU\ \((ME2 + MU2 - T)\)\ \((ME2 + MU2 - 
              U)\), Mat(F9, F47) \[Rule] 4\ ME\ ME2\ MU2, 
      Mat(F9, F48) \[Rule] 16\ ME\ MU2\ \((ME2 - S\/2)\), 
      Mat(F9, F5) \[Rule] 
        1\/4\ ME\ \((ME2 + MU2 - T)\)\ \((ME2\^2 - 
              2\ MU2\ ME2 - \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F9, F6) \[Rule] \(-\(1\/2\)\)\ ME2\ \((\(-ME2\^2\) + 
              2\ MU2\ ME2 + \((MU2 - T)\)\ \((MU2 - U)\))\), 
      Mat(F9, F7) \[Rule] \(-\(1\/2\)\)\ ME\ ME2\ MU\ \((ME2 + MU2 - U)\), 
      Mat(F9, F8) \[Rule] 
        2\ ME\ \((ME2\^3 - 
              T\ ME2\^2 - \((2\ MU2\^2 - 3\ T\ MU2 + 
                    T\ U)\)\ ME2 - \((MU2 - T)\)\^2\ \((MU2 - U)\))\), 
      Mat(F9, F9) \[Rule] \((2\ ME2 - S)\)\ \((ME2\^2 - 
              2\ T\ ME2 + \((MU2 - T)\)\ \((MU2 - S - T)\))\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cRule = ColourME[mat, mat]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{Mat(SUN1, SUN1) \[Rule] 3}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(allRules = \ Join[hRule, cRule];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fredRules = {ME2 \[Rule] 0, \ MU2 \[Rule] 0, \ 
        Alfa2\  \[Rule] \[Alpha]^2, \ 
        Den[a_, b_] \[RuleDelayed] \ 1/\((a - b)\)}\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{ME2 \[Rule] 0, MU2 \[Rule] 0, 
      Alfa2 \[Rule] \[Alpha]\^2, 
      Den(a_, b_) \[RuleDelayed] 1\/\(a - b\)}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(\(SquaredME[mat]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(SquaredME[mat]\  //. \ 
        allRules\)\(//.\)\(fredRules\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`$Aborted\)], "Output"],

Cell[BoxData[
    \(\(?WriteSquaredME\)\)], "Input"],

Cell[BoxData[
    \(WriteSquaredME[mat, {}, hRule, cRule, Abbr[], "\<fortran\>"]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Comput: u g ->  u \[Gamma]", "Section"],

Cell[BoxData[
    \(ClearProcess[]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(tops = 
        CreateTopologies[0, 4, ExcludeTopologies \[Rule] {}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ins = 
        InsertFields[tops, {F[3, {1}], V[5]} \[Rule] {F[3, {1}], V[1]}, 
          Model \[Rule] SMQCD, InsertionLevel \[Rule] {Classes}, 
          ExcludeParticles \[Rule] {{V[2], S[1], S[2], S[3]}}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(Paint[ins, ColumnsXRows \[Rule] 2, 
      PaintLevel \[Rule] {Classes}]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Excluding "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]5\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]5\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Excluding ", 0, " Generic, ", 5, " Classes, and ", 5, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("inserting at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "inserting at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]3\[InvisibleSpace]": "\
\[InvisibleSpace]"0 Classes insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]4\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes insertion"\),
        SequenceForm[ "> Top. ", 4, ": ", "1 Classes insertion"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes insertions"\
\),
        SequenceForm[ "in total: ", "2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("Restoring "\[InvisibleSpace]0\[InvisibleSpace]" \
Generic, "\[InvisibleSpace]5\[InvisibleSpace]" Classes, and \
"\[InvisibleSpace]5\[InvisibleSpace]" Particles fields"\),
        SequenceForm[ 
        "Restoring ", 0, " Generic, ", 5, " Classes, and ", 5, 
          " Particles fields"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 diagram"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 diagram"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.15 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0227273 4.22839e-18 0.0227273 [
[ 0 0 0 0 ]
[ 1 1.15 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.15 L
0 1.15 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 0.5 0.5 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.31818 .5 L
s
.20277 .59618 m
.14923 .61713 L
.17251 .64506 L
F
gsave
.16421 .587 -72.9375 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.3169 .49329 L
.31449 .48684 L
.311 .48088 L
.30651 .47563 L
.30116 .47127 L
.29511 .46793 L
.28858 .4657 L
.28178 .46464 L
.27495 .46472 L
.26834 .46589 L
.26218 .46802 L
.25666 .47098 L
.25198 .47456 L
.24827 .47853 L
.24562 .48267 L
.2441 .48672 L
.2437 .49045 L
.24436 .49361 L
.24598 .49601 L
.24842 .49748 L
.2515 .4979 L
.255 .49718 L
.2587 .49531 L
.26236 .49229 L
.26573 .48822 L
.2686 .48322 L
.27076 .47746 L
.27205 .47113 L
.27233 .46447 L
.27152 .45772 L
.26959 .45113 L
.26655 .44494 L
.26247 .43937 L
.25746 .43461 L
.25169 .43082 L
.24533 .42811 L
.23862 .42656 L
.23178 .42616 L
.22505 .42687 L
.21867 .42862 L
.21285 .43125 L
.20779 .43459 L
.20366 .43842 L
.20055 .44252 L
.19855 .44664 L
.19768 .45053 L
.1979 .45396 L
.19913 .45671 L
.20124 .45859 L
Mistroke
.20407 .45947 L
.20742 .45924 L
.21107 .45785 L
.21477 .45532 L
.21829 .45168 L
.2214 .44706 L
.22389 .44159 L
.22556 .43548 L
.22628 .42893 L
.22594 .42219 L
.22449 .41551 L
.22191 .40912 L
.21826 .40325 L
.21363 .39813 L
.20816 .39391 L
.20203 .39074 L
.19544 .38869 L
.18862 .3878 L
.18181 .38805 L
.17526 .38937 L
.16917 .39165 L
.16378 .39471 L
.15923 .39836 L
.15568 .40238 L
.1532 .40652 L
.15185 .41054 L
.15161 .41419 L
.15243 .41725 L
.15418 .41952 L
.15674 .42084 L
.15989 .42109 L
.16344 .4202 L
.16715 .41814 L
.17078 .41497 L
.17409 .41074 L
.17686 .40562 L
.1789 .39975 L
.18004 .39336 L
.18016 .38667 L
.17918 .37993 L
.17708 .37339 L
.17387 .36728 L
.16964 .36181 L
.16451 .35719 L
.15863 .35356 L
.15221 .35103 L
.14546 .34965 L
.13862 .34942 L
.13193 .3503 L
.12562 .35219 L
Mistroke
.11991 .35494 L
.11498 .35837 L
.11099 .36227 L
.10805 .36639 L
.10623 .37049 L
.10552 .37432 L
.1059 .37766 L
.10727 .38029 L
.10951 .38203 L
.11243 .38274 L
.11584 .38234 L
.11951 .38077 L
.1232 .37806 L
.12667 .37427 L
.1297 .36951 L
.13207 .36393 L
.13361 .35774 L
.13418 .35115 L
.13367 .3444 L
.13204 .33774 L
.1293 .33142 L
.12549 .32566 L
.12072 .32066 L
.11514 .31659 L
.10892 .31358 L
.10228 .31171 L
.09545 .311 L
.08867 .31142 L
.08217 .3129 L
.07618 .3153 L
.0709 .31847 L
.0665 .32219 L
.0631 .32625 L
.0608 .33038 L
.05962 .33436 L
.05954 .33794 L
.06051 .34089 L
.0624 .34303 L
.06505 .34419 L
.06828 .34427 L
.07187 .3432 L
.07558 .34097 L
.07918 .33763 L
.08242 .33326 L
.08509 .32801 L
.08701 .32205 L
.088 .3156 L
.08795 .30888 L
.0868 .30216 L
.08453 .29566 L
Mistroke
.08116 .28964 L
.07679 .28429 L
.07153 .27981 L
.06555 .27634 L
.05907 .27398 L
.05229 .27278 L
.04545 .27273 L
Mfstroke
gsave
.19943 .35973 -61 -16.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.8125 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.68182 .5 L
s
.83913 .6311 m
.78559 .61014 L
.80887 .58221 L
F
gsave
.80057 .64027 -72.9375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68274 .49399 L
.68399 .48838 L
.68587 .48353 L
.68859 .47968 L
.69224 .47696 L
.69681 .47534 L
.70217 .47465 L
.70805 .47461 L
.71417 .47483 L
.72017 .47493 L
.72573 .47449 L
.73058 .47321 L
.73455 .47086 L
.73758 .46738 L
.73972 .46284 L
.74115 .45745 L
.74214 .45153 L
.74302 .44547 L
.74413 .43969 L
.74577 .43455 L
.74819 .43034 L
.75153 .42724 L
.75581 .42526 L
.76092 .42429 L
.76666 .42407 L
.77274 .42425 L
.77881 .42444 L
.78455 .42422 L
.78967 .42324 L
.79395 .42127 L
.79728 .41816 L
.7997 .41396 L
.80135 .40882 L
.80245 .40303 L
.80333 .39698 L
.80432 .39106 L
.80575 .38567 L
.80789 .38113 L
.81092 .37765 L
.81489 .3753 L
.81974 .37402 L
.8253 .37358 L
.8313 .37367 L
.83742 .3739 L
.8433 .37385 L
.84866 .37316 L
.85323 .37154 L
.85688 .36882 L
.8596 .36497 L
Mistroke
.86148 .36011 L
.86273 .35451 L
.86365 .3485 L
.86456 .34249 L
.86581 .33688 L
.86769 .33203 L
.87041 .32818 L
.87406 .32545 L
.87864 .32383 L
.88399 .32314 L
.88988 .3231 L
.89599 .32332 L
.90199 .32341 L
.90755 .32298 L
.9124 .32169 L
.91637 .31934 L
.9194 .31586 L
.92154 .31132 L
.92297 .30593 L
.92396 .30001 L
.92484 .29395 L
.92594 .28817 L
.92758 .28303 L
.93 .27882 L
.93334 .27572 L
.93761 .27374 L
.94273 .27277 L
.94847 .27255 L
.95455 .27273 L
Mfstroke
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31818 .5 m
.68182 .5 L
s
.52727 .5 m
.47273 .48182 L
.47273 .51818 L
F
gsave
.5 .45704 -66.9688 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -87.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.9375 translate 1 -1 scale
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T1) show
79.375 13.375 moveto
(C1) show
97.062 13.375 moveto
(N1) show
111.625 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.5 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.04545 .72727 m
.5 .68182 L
s
.29986 .70183 m
.24378 .68917 L
.2474 .72535 L
F
gsave
.26572 .66193 -66.9688 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .31818 m
.49487 .31302 L
.48886 .30886 L
.48215 .30589 L
.47501 .30427 L
.46768 .30406 L
.46045 .30527 L
.45359 .30783 L
.44734 .31158 L
.44192 .31632 L
.43751 .3218 L
.43423 .3277 L
.43215 .33372 L
.43125 .33953 L
.43149 .34481 L
.43273 .34927 L
.4348 .35267 L
.43749 .35482 L
.44054 .3556 L
.44369 .35495 L
.44666 .3529 L
.44919 .34955 L
.45103 .34505 L
.45198 .33964 L
.45188 .33358 L
.45062 .32718 L
.44817 .32078 L
.44453 .31468 L
.4398 .3092 L
.43411 .30462 L
.42765 .30117 L
.42064 .29901 L
.41335 .29824 L
.40605 .29891 L
.39901 .30095 L
.3925 .30425 L
.38673 .30864 L
.38191 .31386 L
.37818 .31964 L
.37563 .32565 L
.37427 .33158 L
.37408 .3371 L
.37494 .34191 L
.37671 .34575 L
.37919 .34841 L
.38213 .34974 L
.38528 .34965 L
.38835 .34814 L
.39108 .34527 L
.39322 .3412 L
Mistroke
.39454 .33611 L
.39486 .33027 L
.39406 .32397 L
.39208 .31753 L
.3889 .31128 L
.38458 .30552 L
.37924 .30056 L
.37305 .29664 L
.36623 .29396 L
.35902 .29264 L
.35169 .29275 L
.34452 .29427 L
.33777 .2971 L
.33169 .30109 L
.32648 .30601 L
.32231 .31161 L
.31929 .31757 L
.31747 .32357 L
.31683 .32929 L
.31729 .33441 L
.31874 .33866 L
.32096 .3418 L
.32376 .34366 L
.32685 .34413 L
.32999 .34317 L
.33288 .34082 L
.33528 .3372 L
.33694 .33248 L
.33767 .3269 L
.33732 .32074 L
.3358 .31432 L
.33309 .30795 L
.3292 .30197 L
.32425 .29666 L
.31837 .29231 L
.31176 .28913 L
.30468 .28727 L
.29736 .28682 L
.29009 .28779 L
.28315 .29012 L
.27678 .29368 L
.27121 .29827 L
.26662 .30364 L
.26314 .3095 L
.26085 .31552 L
.25975 .32139 L
.2598 .32678 L
.26088 .3314 L
.26282 .335 L
.26542 .33737 L
Mistroke
.26843 .33839 L
.27159 .33799 L
.27461 .33618 L
.27723 .33303 L
.2792 .32872 L
.28031 .32345 L
.2804 .31748 L
.27935 .31112 L
.2771 .30469 L
.27366 .29852 L
.26911 .29292 L
.26357 .28816 L
.25722 .2845 L
.25029 .28211 L
.24303 .2811 L
.23572 .28152 L
.22861 .28334 L
.22199 .28644 L
.21608 .29065 L
.21109 .29575 L
.20717 .30145 L
.20441 .30745 L
.20284 .31342 L
.20246 .31903 L
.20315 .32399 L
.20478 .32801 L
.20715 .33088 L
.21003 .33245 L
.21316 .3326 L
.21627 .33133 L
.21907 .32869 L
.22133 .32481 L
.2228 .31989 L
.2233 .31415 L
.22271 .30791 L
.22093 .30147 L
.21795 .29516 L
.21382 .2893 L
.20864 .28419 L
.20259 .28007 L
.19586 .27717 L
.1887 .27561 L
.18137 .27547 L
.17415 .27675 L
.16731 .27937 L
.1611 .28317 L
.15573 .28796 L
.15137 .29346 L
.14815 .29938 L
.14612 .3054 L
Mistroke
.14528 .31119 L
.14557 .31643 L
.14685 .32085 L
.14896 .3242 L
.15167 .32629 L
.15474 .327 L
.15788 .32628 L
.16084 .32417 L
.16334 .32075 L
.16514 .31621 L
.16604 .31076 L
.16588 .30468 L
.16457 .29828 L
.16206 .29188 L
.15837 .2858 L
.15359 .28036 L
.14785 .27583 L
.14136 .27244 L
.13433 .27034 L
.12704 .26965 L
.11975 .27038 L
.11273 .27248 L
.10624 .27585 L
.10052 .28028 L
.09575 .28553 L
.09207 .29133 L
.08958 .29735 L
.08828 .30326 L
.08813 .30876 L
.08905 .31353 L
.09086 .31732 L
.09336 .31992 L
.09632 .32118 L
.09947 .32102 L
.10253 .31944 L
.10524 .31652 L
.10734 .31239 L
.10861 .30727 L
.10889 .3014 L
.10803 .29508 L
.10599 .28864 L
.10275 .28241 L
.09838 .27668 L
.093 .27177 L
.08678 .26791 L
.07993 .26529 L
.07271 .26404 L
.06538 .26421 L
.05822 .2658 L
.0515 .26869 L
Mistroke
.04545 .27273 L
Mfstroke
gsave
.27974 .25284 -66.9688 -16.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.8125 translate 1 -1 scale
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.938 12.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95455 .72727 m
.5 .31818 L
s
.74754 .54097 m
.69484 .518 L
.71916 .49097 L
F
gsave
.81534 .64005 -72.9375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.50078 .67586 L
.50187 .67025 L
.50357 .66531 L
.50608 .66128 L
.5095 .65826 L
.51384 .65626 L
.51897 .65514 L
.52469 .65468 L
.53072 .65455 L
.53672 .6544 L
.54237 .65386 L
.54741 .65264 L
.55163 .65051 L
.55493 .64735 L
.55732 .64319 L
.55893 .63814 L
.55996 .63247 L
.56072 .62649 L
.56152 .62055 L
.56268 .61502 L
.56447 .61019 L
.5671 .60628 L
.57065 .60341 L
.5751 .60153 L
.58033 .60052 L
.58611 .60012 L
.59214 .60001 L
.59812 .59982 L
.60371 .59921 L
.60865 .59788 L
.61275 .59562 L
.61592 .59232 L
.6182 .58803 L
.61971 .58288 L
.62069 .57715 L
.62143 .57115 L
.62226 .56525 L
.62349 .5598 L
.62539 .55508 L
.62813 .55131 L
.6318 .54857 L
.63637 .54682 L
.64169 .5459 L
.64752 .54556 L
.65357 .54546 L
.6595 .54524 L
.66502 .54455 L
.66986 .5431 L
.67384 .5407 L
Mistroke
.67689 .53727 L
.67905 .53285 L
.68048 .52761 L
.68141 .52182 L
.68214 .51581 L
.68301 .50995 L
.68431 .50458 L
.68631 .49998 L
.68918 .49634 L
.69297 .49374 L
.69765 .49211 L
.70305 .49129 L
.70893 .491 L
.71498 .4909 L
.72088 .49064 L
.72632 .48986 L
.73105 .48829 L
.73491 .48576 L
.73784 .48219 L
.73989 .47765 L
.74123 .47232 L
.74212 .46648 L
.74285 .46047 L
.74376 .45466 L
.74514 .44937 L
.74725 .44489 L
.75024 .44139 L
.75415 .43892 L
.75894 .43742 L
.76442 .43668 L
.77034 .43644 L
.77639 .43634 L
.78224 .43602 L
.7876 .43515 L
.79222 .43347 L
.79596 .43079 L
.79876 .42709 L
.80071 .42243 L
.80197 .41701 L
.80282 .41113 L
.80356 .40513 L
.80451 .39936 L
.80598 .39417 L
.80819 .38982 L
.8113 .38645 L
.81534 .38412 L
.82023 .38273 L
.82579 .38208 L
.83174 .38187 L
.83779 .38176 L
Mistroke
.84359 .38139 L
.84886 .38043 L
.85337 .37861 L
.85698 .3758 L
.85967 .37196 L
.86151 .36719 L
.8627 .36169 L
.86351 .35577 L
.86426 .34978 L
.86526 .34408 L
.86682 .33898 L
.86915 .33475 L
.87239 .33153 L
.87655 .32933 L
.88154 .32805 L
.88716 .32747 L
.89315 .3273 L
.89918 .32718 L
.90493 .32674 L
.91011 .32568 L
.9145 .32374 L
.91799 .32079 L
.92055 .31682 L
.9223 .31193 L
.92342 .30636 L
.9242 .30041 L
.92496 .29444 L
.92603 .2888 L
.92767 .28381 L
.93012 .2797 L
.93348 .27661 L
.93776 .27454 L
.94284 .27337 L
.94853 .27287 L
.95455 .27273 L
Mfstroke
gsave
.84375 .41277 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.3125 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.562 12.438 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .68182 m
.5 .31818 L
s
.5 .47273 m
.48182 .52727 L
.51818 .52727 L
F
gsave
.46158 .5 -72.9375 -9.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19 translate 1 -1 scale
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
70.938 12.438 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 14.312 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .68182 Mdot
.5 .31818 Mdot
gsave
.5 .02273 -87.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.9375 translate 1 -1 scale
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T2) show
79.375 13.375 moveto
(C1) show
97.062 13.375 moveto
(N2) show
111.625 13.375 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 11.438 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.29545 1.09 -67.75 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.500 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39773 1.09 -67.75 -11.4688 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.9375 translate 1 -1 scale
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.500 14.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 1.09 -70.0312 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.938 moveto
(\\256) show
77.062 13.938 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60227 1.09 -67.75 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5 translate 1 -1 scale
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
72.500 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70455 1.09 -67.5625 -11.2188 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.938 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.938 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
72.125 13.938 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 17.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{250.375, 287.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003j00017b000`400?l00000o`00003onP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool009d0oooo1000001I
0?ooo`00W03oool200000080oooo0P00001H0?ooo`00X@3oool00`000000oooo0?ooo`1F0?ooo`00
W@3oool3000000030?ooo`000000oooo05L0oooo002L0?ooo`8000000P3oool2000005P0oooo002L
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0EP3oool009`0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`1F0?ooo`00W03oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo05H0oooo002L0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
EP3oool009`0oooo0P0000020?ooo`800000F03oool009d0oooo0`0000000`3oool000000?ooo`1G
0?ooo`00nP3oool008@0oooo0`00001c0?ooo`001@3oool2000006h0oooo0`00000:0?ooo`800000
0`3oool2000000030?ooo`000000000000<00000H`3oool2000000H0oooo00070?ooo`8000004`3o
ool4000005<0oooo0P00000C0?ooo`8000001@3oool00`000000oooo00000004000000@0oooo00<0
00000?ooo`3oool0D`3oool2000000P0oooo00090?ooo`800000403oool200000080oooo0P00001B
0?ooo`030000003oool0oooo0180oooo0P0000060?ooo`030000003oool0oooo00<0oooo10000000
103oool000000000000000020?ooo`@00000C03oool00`000000oooo0?ooo`070?ooo`002P3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool04@3oool2
000000030?ooo`000000oooo00<0oooo0P0000060?ooo`030000003oool0oooo00@0oooo0P000004
0?ooo`P00000A03oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`0?0?oo
o`<0000000<0oooo0000003oool0D@3oool00`000000oooo0?ooo`0A0?ooo`040000003oool0oooo
000000<0oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0000000@0oooo0`000005
0?ooo`800000103oool8000000<0oooo0P00000g0?ooo`030000003oool0oooo00P0oooo000:0?oo
o`@000003@3oool200000080oooo0P00001A0?ooo`8000004`3oool010000000oooo0?ooo`000003
0?ooo`040000003oool0oooo000000<0oooo0P0000000`3oool000000?ooo`030?ooo`030000003o
ool0000000@0oooo0`0000050?ooo`8000001@3oool300000080oooo1@00000b0?ooo`030000003o
ool0oooo00P0oooo00080?ooo`<000000`3oool2000000/0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`1>0?ooo`8000005@3oool2000000@0oooo0P0000000`3oool000000?ooo`02
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`000000103oool00`000000oooo0000
00040?ooo`<000001@3oool2000000@0oooo1000000b0?ooo`030000003oool0oooo00P0oooo0007
0?ooo`80000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0B@3oool6000001d0oooo0P0000050?ooo`030000003oool0
000000@0oooo00<000000?ooo`000000103oool00`000000oooo000000040?ooo`030000003oool0
000000@0oooo00<000000?ooo`0000001@3oool3000002`0oooo1P00000;0?ooo`001`3oool01000
0000oooo0000000000050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`180?ooo`800000:@3oool2000000D0oooo0`0000040?ooo`030000003oool0
000000@0oooo00<000000?ooo`000000103oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0000002/0oooo00<000000?ooo`3oool03P3oool000L0oooo0`0000060?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`180?ooo`030000003oool0
oooo0300oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`000000103oool0
10000000oooo0000000000050?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool0
3`3oool000l0oooo1@0000070?ooo`8000000P3oool2000004X0oooo00<000000?ooo`3oool0?@3o
ool3000000@0oooo00<000000?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000002P0oooo
00<000000?ooo`3oool03`3oool000h0oooo00<000000?ooo`0000000`3oool2000000H0oooo0`00
00000`3oool000000?ooo`190?ooo`030000003oool0oooo04D0oooo0P0000060?ooo`030000003o
ool0oooo0080oooo0P00000V0?ooo`030000003oool0oooo00l0oooo000=0?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool0DP3oool2000004l0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00l0oooo000=0?ooo`030000003oool0
000000H0oooo00<000000?ooo`3oool0C03oool600000500oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0100oooo000=0?ooo`<000001P3oool00`00
0000oooo0?ooo`1;0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0K0?ooo`H000004P3oool001D0oooo1@00001:0?ooo`030000003oool0oooo05@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01H0
oooo000C0?ooo`80000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`0O0?ooo`<00000
00<0oooo0000003oool08P3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`004`3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo01d0oooo0P0000020?ooo`8000008P3oool2000005H0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo
000B0?ooo`80000000<0oooo0000003oool0103oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1E0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0G0?ooo`004`3oool2
000000L0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01/0oooo1P00001G0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0G0?ooo`006P3oool6000001/0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0C@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0180oooo0P0000070?ooo`030000003oool0oooo
00l0oooo000I0?ooo`040000003oool00000000000<0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0303oool20000
04h0oooo00<000000?ooo`3oool03@3oool2000000d0oooo1@0000090?ooo`800000403oool001P0
oooo0P0000000`3oool000000?ooo`040?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0C03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`00603oool010000000oooo0000000000050?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`00
6@3oool00`000000oooo0?ooo`050?ooo`<00000>03oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo04/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00200oooo0P0000020?ooo`800000=@3o
ool00`000000oooo0?ooo`0?0?ooo`800000C03oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool03P3oool2000000h0oooo000N0?ooo`80000000<0oooo
0000003oool00`3oool00`000000oooo0?ooo`0/0?ooo`H000004P3oool00`000000oooo0000001;
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0000000d0oooo000N0?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool0403oool3000001P0oooo00<000000?ooo`3oool05@3oool00`000000oooo0000000n
0?ooo`<0000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo0080oooo0P00000A0?ooo`030000003oool0000000d0oooo000N0?ooo`<000001@3oool30000
0140oooo1@00000E0?ooo`<000004P3oool00`000000oooo0?ooo`0200000080oooo00<000000?oo
o`3oool0>P3oool200000080oooo0P0000070?ooo`8000005P3oool5000000l0oooo00<000000?oo
o`3oool00P0000020?ooo`030000003oool0oooo00X0oooo000U0?oooc8000004`3oool3000000<0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0
oooo0`00000E0?ooo`030000003oool0000000800000403oool3000000<0oooo00<000000?ooo`3o
ool02P3oool002H0oooo0`00000A0?ooo`@000005P3oool3000005H0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`040?ooo`@00000503oool00`000000oooo0?ooo`03000002<0oooo
000T0?ooo`80000000<0oooo0000003oool0;03oool010000000oooo00000000001D0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0103oool4000001@0oooo00<000000?ooo`000000
1000000R0?ooo`00303oool3000000030?ooo`000000oooo0140oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool5000001@0oooo00@000000?ooo`3oool0oooo1000000Q0?ooo`002`3oool200000080oooo0P00
000A0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`030?ooo`<00000803oool000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool5000000T0oooo00<00000
0?ooo`3oool07@3oool000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0=0?oo
o`8000003P3oool00`000000oooo0?ooo`0L0?ooo`002`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00/0oooo0P00000m0?ooo`800000G03oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool06`3oool000/0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
6P3oool000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0440oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool06@3oool000/0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0E`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0603oool0
01X0oooo00<000000?ooo`3oool0A@3oool3000005H0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo01L0oooo000H0?ooo`800000B03oool4000003D0
oooo0`0000000`3oool000000?ooo`0J0?ooo`030000003oool0oooo00H0oooo1P00000G0?ooo`03
0000003oool0oooo01H0oooo000F0?ooo`<00000B03oool5000003@0oooo0P0000020?ooo`800000
6`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01`0oooo0P00000F0?ooo`004P3o
ool6000004`0oooo0`00000c0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool04`3o
ool001<0oooo1000001?0?ooo`800000<P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
oooo0180oooo000C0?ooo`@00000D@3oool200000300oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`0A0?ooo`004P3oool010000000oooo0?ooo`00001D0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0@0?ooo`004@3oool00`000000
oooo0?ooo`1G0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo0P00000U0?ooo`030000003oool0oooo00l0
oooo000@0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo01T0oooo1P00000X0?ooo`030000003oool0oooo00h0oooo
000?0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo00d0oooo000=0?ooo`800000C03oool3000000030?ooo`000000
oooo00d0oooo0P00001:0?ooo`<000007@3oool3000000030?ooo`000000oooo00/0oooo00<00000
0?ooo`3oool0303oool000`0oooo00<000000?ooo`3oool0B`3oool200000080oooo0P00000@0?oo
o`030000003oool0oooo04@0oooo1P00000L0?ooo`8000000P3oool2000000d0oooo00<000000?oo
o`3oool02`3oool000/0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0>@3oool:000000<0oooo0`00000L0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0303oool2000000/0oooo000:0?ooo`030000
003oool0oooo04d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo02H0oooo100000050?ooo`T000003P3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0T0?ooo`X00000=@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool01`3oool000L0oooo0P00001A0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool04P3oool2000001/0oooo2@0000000`3oool0000000000003
000003T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00H0oooo00060?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo00h0oooo2P00000:0?ooo`<00000>`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool01@3oool000D0
oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0203oool500000580oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00@0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j
0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo
003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0
oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool0
0?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3o
ool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00
nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?oo
o`00nP3oool00?X0oooo003j0?ooo`00nP3oool00?X0oooo003j0?ooo`00nP3oool00001\
\>"],
  ImageRangeCache->{{{0, 249.375}, {286.875, 0}} -> {-0.000220002, \
-0.00852375, 0.176443, 0.176443}, {{0, 124.688}, {162.125, 37.4375}} -> \
{-1.00011, -23.0114, 0.176443, 0.176443}, {{124.688, 249.375}, {162.125, \
37.4375}} -> {-23.0004, -23.0114, 0.176443, 0.176443}}],

Cell[BoxData[
    FormBox[
      RowBox[{\(FeynArtsGraphics({"u", "g"} \[Rule] {"u", "\\gamma"})\), 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          TagBox[
            RowBox[{"(", "\[NoBreak]", GridBox[{
                  {
                    FormBox[
                      
                      InterpretationBox[\("["\[InvisibleSpace]"T1 C1 N1"\
\[InvisibleSpace]"]"\),
                        SequenceForm[ "[", "T1 C1 N1", "]"],
                        Editable->False],
                      "TraditionalForm"], 
                    FormBox[
                      
                      InterpretationBox[\("["\[InvisibleSpace]"T2 C1 N2"\
\[InvisibleSpace]"]"\),
                        SequenceForm[ "[", "T2 C1 N2", "]"],
                        Editable->False],
                      "TraditionalForm"]},
                  {"Null", "Null"}
                  }], "\[NoBreak]", ")"}],
            Function[ BoxForm`e$, 
              MatrixForm[ BoxForm`e$]]], ")"}]}], TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(amps\)\(\ \)\(=\)\(\ \)\(CreateFeynAmp[ins]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("creating amplitudes at level(s) \
"\[InvisibleSpace]{Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]1\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("> Top. "\[InvisibleSpace]2\[InvisibleSpace]": "\
\[InvisibleSpace]"1 Classes amplitude"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Classes amplitude"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("in total: "\[InvisibleSpace]"2 Classes amplitudes"\
\),
        SequenceForm[ "in total: ", "2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"FeynAmpList", "(", 
          
          RowBox[{\(Model \[Rule] SMQCD\), 
            ",", \(GenericModel \[Rule] "Lorentz"\), 
            ",", \(AmplitudeLevel \[Rule] {Classes}\), ",", 
            RowBox[{"ExcludeParticles", "\[Rule]", 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(V(2)\), \(S(1)\), \(S(2)\), \(S(3)\)}
                    }], "\[NoBreak]", ")"}]}], 
            ",", \(LastSelections \[Rule] {}\), 
            ",", \(ExcludeFieldPoints \[Rule] {}\), 
            ",", \(Restrictions \[Rule] {}\), ",", 
            RowBox[{"Process", "\[Rule]", 
              RowBox[{
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("p"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(V(5)\), 
                        FormBox[\("p"\[InvisibleSpace]2\),
                          "TraditionalForm"], "0"}
                      }], "\[NoBreak]", ")"}], "\[Rule]", 
                RowBox[{"(", "\[NoBreak]", GridBox[{
                      {\(F(3, {1})\), 
                        FormBox[\("k"\[InvisibleSpace]1\),
                          "TraditionalForm"], "MU"},
                      {\(V(1)\), 
                        FormBox[\("k"\[InvisibleSpace]2\),
                          "TraditionalForm"], "0"}
                      }], "\[NoBreak]", ")"}]}]}]}], ")"}], 
        "\[InvisibleApplication]", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"FeynAmp", "(", 
              
              RowBox[{\(GraphID(Topology == 1, Generic == 1, Classes == 1, 
                  Number == 1)\), ",", \(Integral()\), ",", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\("u"\&"_"\), "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("k"\[InvisibleSpace]1\),
                              SequenceForm[ "k", 1],
                              Editable->False],
                            "TraditionalForm"], ",", "MU"}], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          
                          RowBox[{\(-\(2\/3\)\), " ", "\[ImaginaryI]", " ", 
                            "EL", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}], "-", 
                          
                          RowBox[{\(2\/3\), " ", "\[ImaginaryI]", " ", "EL", 
                            " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
2\),
                                      SequenceForm[ "Lor", 2],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      
                                      RowBox[{"\<\"om\"\>", 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"]}]}], ")"}], ".", 
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{"MU", "+", 
                            RowBox[{
                              FormBox["\<\"gs\"\>",
                                "TraditionalForm"], "(", 
                              RowBox[{
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], "+", 
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]2\),
                                    
                                    SequenceForm[ "k", 2],
                                    Editable->False],
                                  "TraditionalForm"]}], ")"}]}],
                          "TraditionalForm"], ")"}], ".", 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(-\[ImaginaryI]\), " ", "GS", " ", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox["\<\"ga\"\>",
                                    "TraditionalForm"], "(", 
                                  FormBox[
                                    
                                    InterpretationBox[\("Lor"\[InvisibleSpace]\
1\),
                                      SequenceForm[ "Lor", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}], ".", 
                                RowBox[{"(", 
                           