(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17855,        442]*)
(*NotebookOutlinePosition[     55529,       1733]*)
(*  CellTagsIndexPosition[     55485,       1729]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Load LoopTools:", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"/home/olness/LoopTools"\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory["\</home/olness/LoopTools/tools\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"/home/olness/LoopTools/tools"\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileNames["\<Loop*\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{"LoopTools"}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Install["\<LoopTools\>"]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`LinkObject["./LoopTools", 2, 2]\)], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple Examples", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[\(-100\)]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-100.`\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(B0[1000, 50, 80]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-4.40593282878069`\) + 
      2.7041430991660014`\ \[ImaginaryI]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(C0[1000, 2000, 1500, 100, 200, 300]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(\(0.0027125912174012557`\)\(\[InvisibleSpace]\)\) - 
      0.001293759624007471`\ \[ImaginaryI]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cget[80, 80, 10000, 300, 100, 200]\  // TableForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {\(cc0 \[Rule] \
\(\(0.0003683322958259529`\)\(\[InvisibleSpace]\)\) - 
                  0.0014430487812442507`\ \[ImaginaryI]\)},
            {\(cc1 \[Rule] \(\(0.00003691991146686589`\)\(\[InvisibleSpace]\)\
\) + 0.0008063637675463306`\ \[ImaginaryI]\)},
            {\(cc2 \[Rule] \(-0.0002186870966525929`\) + 
                  0.0003255577507551813`\ \[ImaginaryI]\)},
            {\(cc00 \[Rule] \(-1.4681228646004982`\) + 
                  0.6620214671984384`\ \[ImaginaryI]\)},
            {\(cc11 \[Rule] \(-0.00013839636499407652`\) - 
                  0.0005211388919006447`\ \[ImaginaryI]\)},
            {\(cc12 \[Rule] \(\(0.000056074208755007786`\)\(\[InvisibleSpace]\
\)\) - 0.0001466442566605746`\ \[ImaginaryI]\)},
            {\(cc22 \[Rule] \
\(\(0.00010382320338821283`\)\(\[InvisibleSpace]\)\) - 
                  0.00015728668252092308`\ \[ImaginaryI]\)},
            {\(cc001 \[Rule] \(\(0.4339544374355453`\)\(\[InvisibleSpace]\)\) \
- 0.19053460357936428`\ \[ImaginaryI]\)},
            {\(cc002 \[Rule] \(\(0.5179247985708856`\)\(\[InvisibleSpace]\)\) \
- 0.2390535391455292`\ \[ImaginaryI]\)},
            {\(cc111 \[Rule] \(\(0.00016374078161959536`\)\(\[InvisibleSpace]\
\)\) + 0.0003561351446381442`\ \[ImaginaryI]\)},
            {\(cc112 \[Rule] \(-0.00001499429891688686`\) + 
                  0.00008510756809075344`\ \[ImaginaryI]\)},
            {\(cc122 \[Rule] \(-0.00002351641063613298`\) + 
                  0.00005055502592614986`\ \[ImaginaryI]\)},
            {\(cc222 \[Rule] \(-0.000059567868673522675`\) + 
                  0.00010196296953909706`\ \[ImaginaryI]\)}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {cc0 -> Complex[ 
          0.0003683322958259529, -0.0014430487812442507], cc1 -> Complex[ 
          3.6919911466865887*^-05, 0.00080636376754633057], cc2 -> 
          Complex[ -0.0002186870966525929, 0.0003255577507551813], cc00 -> 
          Complex[ -1.4681228646004982, 0.66202146719843835], cc11 -> 
          Complex[ -0.00013839636499407652, -0.00052113889190064469], cc12 -> 
          Complex[ 5.6074208755007786*^-05, -0.0001466442566605746], cc22 -> 
          Complex[ 0.00010382320338821283, -0.00015728668252092308], cc001 -> 
          Complex[ 0.43395443743554529, -0.19053460357936428], cc002 -> 
          Complex[ 0.51792479857088558, -0.23905353914552921], cc111 -> 
          Complex[ 0.00016374078161959536, 0.00035613514463814423], cc112 -> 
          Complex[ -1.4994298916886859*^-05, 8.5107568090753445*^-05], cc122 -> 
          Complex[ -2.351641063613298*^-05, 5.0555025926149858*^-05], cc222 -> 
          Complex[ -5.9567868673522675*^-05, 0.00010196296953909706]}]], 
      TraditionalForm]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dget[80, 80, 10000, 15000, 7000, 8000, 300, 100, 200, 400]\  // 
      TableForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {\(dd0 \[Rule] 
                1.6900171040633422`*^-8 - 
                  2.0339517235234314`*^-7\ \[ImaginaryI]\)},
            {\(dd1 \[Rule] 
                3.2792461005188326`*^-8 + 
                  1.0598516708829382`*^-7\ \[ImaginaryI]\)},
            {\(dd2 \[Rule] \(-1.8787062123681883`*^-8\) + 
                  5.1516426073220214`*^-8\ \[ImaginaryI]\)},
            {\(dd3 \[Rule] \(-1.603529583532037`*^-8\) + 
                  5.090988211207349`*^-9\ \[ImaginaryI]\)},
            {\(dd00 \[Rule] \
\(\(0.00007507260295944346`\)\(\[InvisibleSpace]\)\) - 
                  0.000017933903502189513`\ \[ImaginaryI]\)},
            {\(dd11 \[Rule] \(-3.9598161502972694`*^-8\) - 
                  6.295774067090948`*^-8\ \[ImaginaryI]\)},
            {\(dd12 \[Rule] 
                1.1852638989594553`*^-9 - 
                  2.2244609516979783`*^-8\ \[ImaginaryI]\)},
            {\(dd13 \[Rule] 
                4.951251749355869`*^-9 - 
                  2.3863581241626536`*^-9\ \[ImaginaryI]\)},
            {\(dd22 \[Rule] 
                7.540054886041384`*^-9 - 
                  2.4155105150950364`*^-8\ \[ImaginaryI]\)},
            {\(dd23 \[Rule] 
                3.4282378904135366`*^-9 - 
                  8.544403357404359`*^-10\ \[ImaginaryI]\)},
            {\(dd33 \[Rule] 
                4.9209204711143445`*^-9 - 
                  1.1619010709568564`*^-9\ \[ImaginaryI]\)},
            {\(dd001 \[Rule] \(-0.000026391520676931128`\) + 
                  0.00001033558752736846`\ \[ImaginaryI]\)},
            {\(dd002 \[Rule] \(-0.00001951969108686213`\) + 
                  3.671790512615503`*^-6\ \[ImaginaryI]\)},
            {\(dd003 \[Rule] \(-0.00001140331303656962`\) + 
                  2.5634366124915445`*^-7\ \[ImaginaryI]\)},
            {\(dd111 \[Rule] 
                3.748302142961626`*^-8 + 
                  3.8984801343042336`*^-8\ \[ImaginaryI]\)},
            {\(dd112 \[Rule] 
                2.274983336698561`*^-9 + 
                  1.2110272537714562`*^-8\ \[ImaginaryI]\)},
            {\(dd113 \[Rule] \(-2.3282661898821247`*^-9\) + 
                  1.64467887358042`*^-9\ \[ImaginaryI]\)},
            {\(dd122 \[Rule] \(-7.714141489678637`*^-10\) + 
                  7.680131077295765`*^-9\ \[ImaginaryI]\)},
            {\(dd123 \[Rule] \(-9.148023558960374`*^-10\) + 
                  3.628986132638359`*^-10\ \[ImaginaryI]\)},
            {\(dd133 \[Rule] \(-9.47873973882996`*^-10\) + 
                  6.694577537183992`*^-11\ \[ImaginaryI]\)},
            {\(dd222 \[Rule] \(-3.0684597236772202`*^-9\) + 
                  1.4971304401133194`*^-8\ \[ImaginaryI]\)},
            {\(dd223 \[Rule] \(-1.346511622254025`*^-9\) + 
                  4.1904435625057936`*^-10\ \[ImaginaryI]\)},
            {\(dd233 \[Rule] \(-7.292965833708445`*^-10\) + 
                  3.571098552685465`*^-11\ \[ImaginaryI]\)},
            {\(dd333 \[Rule] \(-2.6635582553227667`*^-9\) + 
                  1.0332910544984691`*^-9\ \[ImaginaryI]\)},
            {\(dd0000 \[Rule] \(-0.30378445738302456`\) + 
                  0.13020262087842419`\ \[ImaginaryI]\)},
            {\(dd0011 \[Rule] \
\(\(0.00001323551505451981`\)\(\[InvisibleSpace]\)\) - 
                  7.123039152971568`*^-6\ \[ImaginaryI]\)},
            {\(dd0012 \[Rule] 
                5.410128130631761`*^-6 - 
                  1.567123850447706`*^-6\ \[ImaginaryI]\)},
            {\(dd0013 \[Rule] 
                2.767963329798651`*^-6 - 
                  8.652577211113912`*^-8\ \[ImaginaryI]\)},
            {\(dd0022 \[Rule] 
                8.586633176346617`*^-6 - 
                  1.8960385239007586`*^-6\ \[ImaginaryI]\)},
            {\(dd0023 \[Rule] 
                2.307753619808399`*^-6 - 
                  3.089133690322607`*^-8\ \[ImaginaryI]\)},
            {\(dd0033 \[Rule] 
                4.24715255760644`*^-6 - 
                  1.0718322580842524`*^-7\ \[ImaginaryI]\)},
            {\(dd1111 \[Rule] \(-3.311729891001208`*^-8\) - 
                  2.446069459010741`*^-8\ \[ImaginaryI]\)},
            {\(dd1112 \[Rule] \(-2.9471805837312267`*^-9\) - 
                  7.18083345934978`*^-9\ \[ImaginaryI]\)},
            {\(dd1113 \[Rule] 
                1.284568588328204`*^-9 - 
                  1.2169859484435037`*^-9\ \[ImaginaryI]\)},
            {\(dd1122 \[Rule] \(-2.930241003719631`*^-10\) - 
                  3.493660295890382`*^-9\ \[ImaginaryI]\)},
            {\(dd1123 \[Rule] 
                3.7885771392794025`*^-10 - 
                  2.1177903859227372`*^-10\ \[ImaginaryI]\)},
            {\(dd1133 \[Rule] 
                3.427823606182761`*^-10 - 
                  2.900488473196531`*^-11\ \[ImaginaryI]\)},
            {\(dd1222 \[Rule] 
                1.9208636183812793`*^-10 - 
                  3.626076579567613`*^-9\ \[ImaginaryI]\)},
            {\(dd1223 \[Rule] 
                2.954224877650451`*^-10 - 
                  1.2660632363910212`*^-10\ \[ImaginaryI]\)},
            {\(dd1233 \[Rule] 
                1.3398139626256728`*^-10 - 
                  5.871297276367452`*^-12\ \[ImaginaryI]\)},
            {\(dd1333 \[Rule] 
                3.594419012823527`*^-10 - 
                  2.6917116508794105`*^-11\ \[ImaginaryI]\)},
            {\(dd2222 \[Rule] 
                1.07996844876691`*^-9 - 
                  1.0523563395972286`*^-8\ \[ImaginaryI]\)},
            {\(dd2223 \[Rule] 
                6.982814567609666`*^-10 - 
                  2.758719534408001`*^-10\ \[ImaginaryI]\)},
            {\(dd2233 \[Rule] 
                2.185259941462159`*^-10 - 
                  7.869426642106622`*^-12\ \[ImaginaryI]\)},
            {\(dd2333 \[Rule] 
                2.9878541460353916`*^-10 - 
                  2.1367552256409005`*^-11\ \[ImaginaryI]\)},
            {\(dd3333 \[Rule] 
                1.7689732829566575`*^-9 - 
                  9.706602322200645`*^-10\ \[ImaginaryI]\)}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {dd0 -> Complex[ 
          1.6900171040633422*^-08, -2.0339517235234314*^-07], dd1 -> Complex[ 
          3.2792461005188326*^-08, 1.0598516708829382*^-07], dd2 -> 
          Complex[ -1.8787062123681883*^-08, 5.1516426073220214*^-08], dd3 -> 
          Complex[ -1.603529583532037*^-08, 5.0909882112073488*^-09], dd00 -> 
          Complex[ 7.5072602959443458*^-05, -1.7933903502189513*^-05], dd11 -> 
          Complex[ -3.9598161502972694*^-08, -6.2957740670909476*^-08], dd12 -> 
          Complex[ 1.1852638989594553*^-09, -2.2244609516979783*^-08], dd13 -> 
          Complex[ 4.9512517493558686*^-09, -2.3863581241626536*^-09], dd22 -> 
          Complex[ 7.5400548860413844*^-09, -2.4155105150950364*^-08], dd23 -> 
          Complex[ 3.4282378904135366*^-09, -8.5444033574043588*^-10], dd33 -> 
          Complex[ 4.9209204711143445*^-09, -1.1619010709568564*^-09], dd001 -> 
          Complex[ -2.6391520676931128*^-05, 1.033558752736846*^-05], dd002 -> 
          Complex[ -1.9519691086862128*^-05, 3.6717905126155029*^-06], dd003 -> 
          Complex[ -1.140331303656962*^-05, 2.5634366124915445*^-07], dd111 -> 
          Complex[ 3.7483021429616258*^-08, 3.8984801343042336*^-08], dd112 -> 
          Complex[ 2.2749833366985608*^-09, 1.2110272537714562*^-08], dd113 -> 
          Complex[ -2.3282661898821247*^-09, 1.6446788735804199*^-09], dd122 -> 
          Complex[ -7.7141414896786368*^-10, 7.6801310772957653*^-09], dd123 -> 
          Complex[ -9.1480235589603743*^-10, 3.6289861326383588*^-10], dd133 -> 
          Complex[ -9.4787397388299596*^-10, 6.6945775371839925*^-11], dd222 -> 
          Complex[ -3.0684597236772202*^-09, 1.4971304401133194*^-08], dd223 -> 
          Complex[ -1.3465116222540251*^-09, 4.1904435625057936*^-10], dd233 -> 
          Complex[ -7.2929658337084446*^-10, 3.5710985526854647*^-11], dd333 -> 
          Complex[ -2.6635582553227667*^-09, 1.0332910544984691*^-09], dd0000 -> 
          Complex[ -0.30378445738302456, 0.13020262087842419], dd0011 -> 
          Complex[ 1.3235515054519809*^-05, -7.1230391529715679*^-06], dd0012 -> 
          Complex[ 5.4101281306317606*^-06, -1.5671238504477059*^-06], dd0013 -> 
          Complex[ 2.7679633297986511*^-06, -8.6525772111139124*^-08], dd0022 -> 
          Complex[ 8.586633176346617*^-06, -1.8960385239007586*^-06], dd0023 -> 
          Complex[ 2.3077536198083991*^-06, -3.0891336903226069*^-08], dd0033 -> 
          Complex[ 4.2471525576064404*^-06, -1.0718322580842524*^-07], dd1111 -> 
          Complex[ -3.3117298910012077*^-08, -2.4460694590107411*^-08], 
          dd1112 -> 
          Complex[ -2.9471805837312267*^-09, -7.1808334593497802*^-09], 
          dd1113 -> Complex[ 
          1.284568588328204*^-09, -1.2169859484435037*^-09], dd1122 -> 
          Complex[ -2.9302410037196312*^-10, -3.4936602958903821*^-09], 
          dd1123 -> Complex[ 
          3.7885771392794025*^-10, -2.1177903859227372*^-10], dd1133 -> 
          Complex[ 3.4278236061827609*^-10, -2.9004884731965311*^-11], dd1222 -> 
          Complex[ 1.9208636183812793*^-10, -3.6260765795676129*^-09], dd1223 -> 
          Complex[ 2.9542248776504513*^-10, -1.2660632363910212*^-10], dd1233 -> 
          Complex[ 1.3398139626256728*^-10, -5.8712972763674522*^-12], dd1333 -> 
          Complex[ 3.5944190128235271*^-10, -2.6917116508794105*^-11], dd2222 -> 
          Complex[ 1.0799684487669099*^-09, -1.0523563395972286*^-08], dd2223 -> 
          Complex[ 6.9828145676096657*^-10, -2.7587195344080009*^-10], dd2233 -> 
          Complex[ 2.185259941462159*^-10, -7.8694266421066221*^-12], dd2333 -> 
          Complex[ 2.9878541460353916*^-10, -2.1367552256409005*^-11], dd3333 -> 
          Complex[ 1.7689732829566575*^-09, -9.7066023222006449*^-10]}]], 
      TraditionalForm]], "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Vary: \[CapitalDelta] = ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["2", 
            RowBox[{
              RowBox[{"4", 
                StyleBox[
                  RowBox[{"-", 
                    StyleBox["-",
                      FontFamily->"Times"]}]]}], "D"}]], "-", 
          " ", \(\[Gamma]\_E\), "+", " ", \(ln\ 4\ \[Pi]\)}], 
        TraditionalForm]]],
  "   \[TildeEqual]  ",
  Cell[BoxData[
      \(TraditionalForm\`1\/\(\(\ \)\(e\)\) - \ \[Gamma]\_E + \ 
        ln\ 4\ \[Pi]\)]],
  "  "
}], "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \({GetDelta[], GetMudim[], GetLambda[]}\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{0.`, 1.`, 1.`}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A0[100]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-360.51701859880916`\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(SetDelta[0.0];\)\), "\[IndentingNewLine]", 
    \(A0[100]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-360.51701859880916`\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(SetDelta[1.23];\)\), "\[IndentingNewLine]", 
    \(A0[100]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-237.5170185988092`\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(SetDelta[0.0];\)\), "\[IndentingNewLine]", 
    \(A0[100]\)}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-360.51701859880916`\)\)], "Output"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowToolbars->"EditBar",
WindowSize->{747, 593},
WindowMargins->{{40, Automatic}, {Automatic, 15}},
Magnification->1.5,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->12],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{8, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->8],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LineSpacing->{1, 11},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellFrame->True,
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LineSpacing->{1, 7},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    Background->GrayLevel[0.849989]],
  
  Cell[StyleData["Section", "Presentation"],
    CellFrame->True,
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellFrame->True,
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellFrame->True,
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", Inherited},
    Hyphenation->True,
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    DefaultNewInlineCellStyle->"None",
    Hyphenation->True,
    LineSpacing->{1, 3},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}},
    FontSize->11],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}},
    FontSize->11],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontSize->11,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->False,
    LanguageCategory->"Formula",
    ScriptLevel->1,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{59, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{108, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{158, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["Hyperlink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["MainBookLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["AddOnsLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["GettingStartedLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["OtherInformationLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    LanguageCategory->"Formula",
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 34, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[1786, 56, 44, 1, 39, "Input"],
Cell[1833, 59, 75, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[1945, 65, 81, 1, 32, "Input"],
Cell[2029, 68, 81, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2147, 74, 55, 1, 32, "Input"],
Cell[2205, 77, 64, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2306, 83, 57, 1, 32, "Input"],
Cell[2366, 86, 82, 1, 40, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2497, 93, 34, 0, 111, "Section"],

Cell[CellGroupData[{
Cell[2556, 97, 45, 1, 39, "Input"],
Cell[2604, 100, 61, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2702, 106, 49, 1, 32, "Input"],
Cell[2754, 109, 117, 2, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2908, 116, 68, 1, 32, "Input"],
Cell[2979, 119, 148, 2, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3164, 126, 82, 1, 32, "Input"],
Cell[3249, 129, 2892, 50, 369, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6178, 184, 113, 2, 55, "Input"],
Cell[6294, 188, 9969, 178, 1443, "Output"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16312, 372, 569, 19, 112, "Section"],

Cell[CellGroupData[{
Cell[16906, 395, 70, 1, 39, "Input"],
Cell[16979, 398, 66, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17082, 404, 40, 1, 32, "Input"],
Cell[17125, 407, 75, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17237, 413, 94, 2, 55, "Input"],
Cell[17334, 417, 75, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17446, 423, 95, 2, 55, "Input"],
Cell[17544, 427, 74, 1, 40, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17655, 433, 94, 2, 55, "Input"],
Cell[17752, 437, 75, 1, 40, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

