!-----------------------
!  The partial O(\alpha_s^3) contribution to the gluonic heavy-quark 
!  electroproduction calculated in [Nucl.Phys. B864, 399 (2012)]. 
!  All terms are given in the tabulated form ready for the realistic kinematics.
!-----------------------

      subroutine c2hqg20(eta, xi, coeff)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      include 'PDFCOM.'
 
      call c2hqg20a(eta, xi, coeffa)
      call c2hqg20b(eta, xi, coeffb)
! Linear interploation between variants A and B of 1205.5727]
      coeff=coeffa*(1.-ddnnlohq)+ddnnlohq*coeffb

      return
      end
!-----------------------------
      subroutine c2hqg20a(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.6132D-01,-0.5721D-01,-0.4610D-01,-0.2927D-01,-0.7848D-02,
     ,   0.1719D-01, 0.4498D-01, 0.7472D-01, 0.1057D+00, 0.1372D+00,
     ,   0.1685D+00, 0.1990D+00, 0.2281D+00, 0.2550D+00, 0.2791D+00,
     ,   0.2997D+00, 0.3162D+00, 0.3280D+00, 0.3344D+00, 0.3351D+00,
     ,   0.3295D+00, 0.3173D+00, 0.2985D+00, 0.2730D+00, 0.2409D+00,
     ,   0.2028D+00, 0.1593D+00, 0.1109D+00, 0.5867D-01, 0.3433D-02,
     ,  -0.5391D-01,-0.1124D+00,-0.1710D+00,-0.2281D+00,-0.2817D+00,
     ,  -0.3284D+00,-0.3643D+00,-0.3840D+00,-0.3817D+00,-0.3513D+00,
     ,  -0.2876D+00,-0.1880D+00,-0.5388D-01, 0.1075D+00, 0.2833D+00,
     ,   0.4578D+00, 0.6161D+00, 0.7478D+00, 0.8486D+00, 0.9192D+00,
     ,   0.9634D+00, 0.9863D+00, 0.9928D+00, 0.9872D+00, 0.9729D+00,
     ,   0.9524D+00, 0.9276D+00, 0.8998D+00, 0.8700D+00, 0.8387D+00,
     ,   0.8064D+00, 0.7735D+00, 0.7401D+00, 0.7064D+00, 0.6726D+00,
     ,   0.6385D+00, 0.6044D+00, 0.5702D+00, 0.5359D+00, 0.5016D+00,
     ,   0.4673D+00, 0.4330D+00, 0.3987D+00/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.6106D-01,-0.5690D-01,-0.4572D-01,-0.2882D-01,-0.7305D-02,
     ,   0.1785D-01, 0.4577D-01, 0.7568D-01, 0.1068D+00, 0.1386D+00,
     ,   0.1702D+00, 0.2011D+00, 0.2306D+00, 0.2580D+00, 0.2827D+00,
     ,   0.3041D+00, 0.3216D+00, 0.3345D+00, 0.3423D+00, 0.3447D+00,
     ,   0.3411D+00, 0.3314D+00, 0.3156D+00, 0.2937D+00, 0.2660D+00,
     ,   0.2332D+00, 0.1960D+00, 0.1553D+00, 0.1123D+00, 0.6805D-01,
     ,   0.2381D-01,-0.1928D-01,-0.5992D-01,-0.9662D-01,-0.1275D+00,
     ,  -0.1501D+00,-0.1614D+00,-0.1581D+00,-0.1362D+00,-0.9180D-01,
     ,  -0.2145D-01, 0.7646D-01, 0.2005D+00, 0.3451D+00, 0.5003D+00,
     ,   0.6541D+00, 0.7950D+00, 0.9153D+00, 0.1011D+01, 0.1084D+01,
     ,   0.1137D+01, 0.1173D+01, 0.1196D+01, 0.1210D+01, 0.1217D+01,
     ,   0.1219D+01, 0.1218D+01, 0.1215D+01, 0.1210D+01, 0.1204D+01,
     ,   0.1198D+01, 0.1190D+01, 0.1183D+01, 0.1175D+01, 0.1167D+01,
     ,   0.1159D+01, 0.1151D+01, 0.1142D+01, 0.1134D+01, 0.1126D+01,
     ,   0.1118D+01, 0.1109D+01, 0.1101D+01/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.6093D-01,-0.5675D-01,-0.4554D-01,-0.2860D-01,-0.7045D-02,
     ,   0.1816D-01, 0.4614D-01, 0.7612D-01, 0.1074D+00, 0.1392D+00,
     ,   0.1710D+00, 0.2020D+00, 0.2317D+00, 0.2594D+00, 0.2844D+00,
     ,   0.3062D+00, 0.3241D+00, 0.3376D+00, 0.3461D+00, 0.3492D+00,
     ,   0.3466D+00, 0.3381D+00, 0.3237D+00, 0.3035D+00, 0.2780D+00,
     ,   0.2477D+00, 0.2135D+00, 0.1765D+00, 0.1379D+00, 0.9902D-01,
     ,   0.6108D-01, 0.2544D-01,-0.6563D-02,-0.3343D-01,-0.5347D-01,
     ,  -0.6476D-01,-0.6518D-01,-0.5249D-01,-0.2425D-01, 0.2196D-01,
     ,   0.8815D-01, 0.1752D+00, 0.2817D+00, 0.4034D+00, 0.5328D+00,
     ,   0.6608D+00, 0.7791D+00, 0.8816D+00, 0.9660D+00, 0.1033D+01,
     ,   0.1084D+01, 0.1123D+01, 0.1153D+01, 0.1176D+01, 0.1193D+01,
     ,   0.1207D+01, 0.1218D+01, 0.1228D+01, 0.1236D+01, 0.1244D+01,
     ,   0.1251D+01, 0.1257D+01, 0.1264D+01, 0.1270D+01, 0.1276D+01,
     ,   0.1282D+01, 0.1288D+01, 0.1294D+01, 0.1299D+01, 0.1305D+01,
     ,   0.1311D+01, 0.1317D+01, 0.1323D+01/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.6086D-01,-0.5666D-01,-0.4545D-01,-0.2850D-01,-0.6924D-02,
     ,   0.1830D-01, 0.4630D-01, 0.7632D-01, 0.1076D+00, 0.1395D+00,
     ,   0.1713D+00, 0.2024D+00, 0.2322D+00, 0.2600D+00, 0.2852D+00,
     ,   0.3071D+00, 0.3252D+00, 0.3389D+00, 0.3477D+00, 0.3512D+00,
     ,   0.3491D+00, 0.3412D+00, 0.3274D+00, 0.3080D+00, 0.2834D+00,
     ,   0.2543D+00, 0.2215D+00, 0.1862D+00, 0.1497D+00, 0.1132D+00,
     ,   0.7818D-01, 0.4597D-01, 0.1794D-01,-0.4446D-02,-0.1966D-01,
     ,  -0.2613D-01,-0.2238D-01,-0.7028D-02, 0.2125D-01, 0.6370D-01,
     ,   0.1213D+00, 0.1943D+00, 0.2814D+00, 0.3794D+00, 0.4827D+00,
     ,   0.5849D+00, 0.6799D+00, 0.7634D+00, 0.8337D+00, 0.8913D+00,
     ,   0.9377D+00, 0.9752D+00, 0.1006D+01, 0.1031D+01, 0.1053D+01,
     ,   0.1072D+01, 0.1089D+01, 0.1106D+01, 0.1121D+01, 0.1135D+01,
     ,   0.1150D+01, 0.1163D+01, 0.1177D+01, 0.1191D+01, 0.1204D+01,
     ,   0.1218D+01, 0.1231D+01, 0.1244D+01, 0.1258D+01, 0.1271D+01,
     ,   0.1284D+01, 0.1298D+01, 0.1311D+01/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.6081D-01,-0.5662D-01,-0.4539D-01,-0.2844D-01,-0.6871D-02,
     ,   0.1835D-01, 0.4636D-01, 0.7638D-01, 0.1077D+00, 0.1396D+00,
     ,   0.1714D+00, 0.2026D+00, 0.2324D+00, 0.2602D+00, 0.2854D+00,
     ,   0.3074D+00, 0.3256D+00, 0.3394D+00, 0.3484D+00, 0.3520D+00,
     ,   0.3501D+00, 0.3424D+00, 0.3289D+00, 0.3098D+00, 0.2857D+00,
     ,   0.2570D+00, 0.2249D+00, 0.1903D+00, 0.1547D+00, 0.1193D+00,
     ,   0.8552D-01, 0.5480D-01, 0.2849D-01, 0.7981D-02,-0.5311D-02,
     ,  -0.1010D-01,-0.5380D-02, 0.9563D-02, 0.3520D-01, 0.7189D-01,
     ,   0.1198D+00, 0.1786D+00, 0.2473D+00, 0.3233D+00, 0.4029D+00,
     ,   0.4815D+00, 0.5551D+00, 0.6207D+00, 0.6772D+00, 0.7248D+00,
     ,   0.7649D+00, 0.7987D+00, 0.8278D+00, 0.8534D+00, 0.8764D+00,
     ,   0.8977D+00, 0.9177D+00, 0.9368D+00, 0.9554D+00, 0.9735D+00,
     ,   0.9913D+00, 0.1009D+01, 0.1026D+01, 0.1044D+01, 0.1061D+01,
     ,   0.1078D+01, 0.1096D+01, 0.1113D+01, 0.1130D+01, 0.1147D+01,
     ,   0.1165D+01, 0.1182D+01, 0.1199D+01/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.6077D-01,-0.5657D-01,-0.4536D-01,-0.2841D-01,-0.6847D-02,
     ,   0.1836D-01, 0.4636D-01, 0.7637D-01, 0.1077D+00, 0.1396D+00,
     ,   0.1714D+00, 0.2025D+00, 0.2323D+00, 0.2602D+00, 0.2854D+00,
     ,   0.3074D+00, 0.3256D+00, 0.3395D+00, 0.3485D+00, 0.3522D+00,
     ,   0.3503D+00, 0.3427D+00, 0.3293D+00, 0.3104D+00, 0.2864D+00,
     ,   0.2580D+00, 0.2261D+00, 0.1919D+00, 0.1566D+00, 0.1216D+00,
     ,   0.8835D-01, 0.5822D-01, 0.3256D-01, 0.1274D-01, 0.2857D-04,
     ,  -0.4493D-02,-0.1744D-03, 0.1317D-01, 0.3535D-01, 0.6603D-01,
     ,   0.1047D+00, 0.1508D+00, 0.2033D+00, 0.2603D+00, 0.3194D+00,
     ,   0.3778D+00, 0.4328D+00, 0.4827D+00, 0.5268D+00, 0.5653D+00,
     ,   0.5989D+00, 0.6287D+00, 0.6554D+00, 0.6799D+00, 0.7028D+00,
     ,   0.7246D+00, 0.7456D+00, 0.7660D+00, 0.7860D+00, 0.8058D+00,
     ,   0.8253D+00, 0.8448D+00, 0.8642D+00, 0.8835D+00, 0.9028D+00,
     ,   0.9220D+00, 0.9412D+00, 0.9605D+00, 0.9797D+00, 0.9989D+00,
     ,   0.1018D+01, 0.1037D+01, 0.1056D+01/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.6072D-01,-0.5652D-01,-0.4532D-01,-0.2838D-01,-0.6836D-02,
     ,   0.1836D-01, 0.4634D-01, 0.7632D-01, 0.1076D+00, 0.1395D+00,
     ,   0.1713D+00, 0.2024D+00, 0.2322D+00, 0.2600D+00, 0.2852D+00,
     ,   0.3072D+00, 0.3254D+00, 0.3393D+00, 0.3483D+00, 0.3520D+00,
     ,   0.3502D+00, 0.3426D+00, 0.3293D+00, 0.3104D+00, 0.2865D+00,
     ,   0.2582D+00, 0.2264D+00, 0.1922D+00, 0.1571D+00, 0.1223D+00,
     ,   0.8920D-01, 0.5927D-01, 0.3382D-01, 0.1416D-01, 0.1471D-02,
     ,  -0.3338D-02, 0.9835D-04, 0.1156D-01, 0.3036D-01, 0.5560D-01,
     ,   0.8634D-01, 0.1216D+00, 0.1605D+00, 0.2018D+00, 0.2440D+00,
     ,   0.2856D+00, 0.3253D+00, 0.3621D+00, 0.3958D+00, 0.4264D+00,
     ,   0.4543D+00, 0.4802D+00, 0.5045D+00, 0.5275D+00, 0.5497D+00,
     ,   0.5712D+00, 0.5924D+00, 0.6132D+00, 0.6338D+00, 0.6543D+00,
     ,   0.6746D+00, 0.6949D+00, 0.7152D+00, 0.7354D+00, 0.7556D+00,
     ,   0.7758D+00, 0.7960D+00, 0.8162D+00, 0.8363D+00, 0.8565D+00,
     ,   0.8766D+00, 0.8968D+00, 0.9170D+00/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.6064D-01,-0.5646D-01,-0.4526D-01,-0.2835D-01,-0.6827D-02,
     ,   0.1834D-01, 0.4628D-01, 0.7624D-01, 0.1075D+00, 0.1393D+00,
     ,   0.1711D+00, 0.2022D+00, 0.2319D+00, 0.2597D+00, 0.2849D+00,
     ,   0.3069D+00, 0.3251D+00, 0.3389D+00, 0.3479D+00, 0.3516D+00,
     ,   0.3498D+00, 0.3422D+00, 0.3289D+00, 0.3101D+00, 0.2862D+00,
     ,   0.2579D+00, 0.2262D+00, 0.1921D+00, 0.1570D+00, 0.1223D+00,
     ,   0.8926D-01, 0.5938D-01, 0.3396D-01, 0.1426D-01, 0.1410D-02,
     ,  -0.3845D-02,-0.1350D-02, 0.8360D-02, 0.2422D-01, 0.4491D-01,
     ,   0.6911D-01, 0.9569D-01, 0.1237D+00, 0.1524D+00, 0.1811D+00,
     ,   0.2094D+00, 0.2368D+00, 0.2631D+00, 0.2882D+00, 0.3124D+00,
     ,   0.3356D+00, 0.3582D+00, 0.3802D+00, 0.4018D+00, 0.4231D+00,
     ,   0.4442D+00, 0.4651D+00, 0.4860D+00, 0.5067D+00, 0.5274D+00,
     ,   0.5481D+00, 0.5688D+00, 0.5894D+00, 0.6100D+00, 0.6307D+00,
     ,   0.6513D+00, 0.6719D+00, 0.6925D+00, 0.7131D+00, 0.7337D+00,
     ,   0.7543D+00, 0.7749D+00, 0.7955D+00/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.6054D-01,-0.5636D-01,-0.4519D-01,-0.2830D-01,-0.6816D-02,
     ,   0.1831D-01, 0.4620D-01, 0.7610D-01, 0.1073D+00, 0.1391D+00,
     ,   0.1708D+00, 0.2018D+00, 0.2315D+00, 0.2592D+00, 0.2844D+00,
     ,   0.3063D+00, 0.3245D+00, 0.3383D+00, 0.3473D+00, 0.3510D+00,
     ,   0.3492D+00, 0.3416D+00, 0.3283D+00, 0.3095D+00, 0.2857D+00,
     ,   0.2574D+00, 0.2257D+00, 0.1917D+00, 0.1567D+00, 0.1220D+00,
     ,   0.8900D-01, 0.5915D-01, 0.3372D-01, 0.1395D-01, 0.8966D-03,
     ,  -0.4788D-02,-0.3119D-02, 0.5134D-02, 0.1861D-01, 0.3569D-01,
     ,   0.5476D-01, 0.7452D-01, 0.9408D-01, 0.1130D+00, 0.1313D+00,
     ,   0.1492D+00, 0.1671D+00, 0.1853D+00, 0.2039D+00, 0.2229D+00,
     ,   0.2424D+00, 0.2623D+00, 0.2824D+00, 0.3028D+00, 0.3233D+00,
     ,   0.3439D+00, 0.3645D+00, 0.3852D+00, 0.4060D+00, 0.4267D+00,
     ,   0.4475D+00, 0.4682D+00, 0.4890D+00, 0.5098D+00, 0.5306D+00,
     ,   0.5514D+00, 0.5722D+00, 0.5930D+00, 0.6137D+00, 0.6345D+00,
     ,   0.6553D+00, 0.6761D+00, 0.6969D+00/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.6039D-01,-0.5622D-01,-0.4507D-01,-0.2823D-01,-0.6800D-02,
     ,   0.1826D-01, 0.4609D-01, 0.7591D-01, 0.1070D+00, 0.1387D+00,
     ,   0.1704D+00, 0.2013D+00, 0.2309D+00, 0.2586D+00, 0.2837D+00,
     ,   0.3056D+00, 0.3237D+00, 0.3374D+00, 0.3464D+00, 0.3501D+00,
     ,   0.3483D+00, 0.3407D+00, 0.3275D+00, 0.3087D+00, 0.2849D+00,
     ,   0.2567D+00, 0.2251D+00, 0.1912D+00, 0.1562D+00, 0.1215D+00,
     ,   0.8863D-01, 0.5882D-01, 0.3340D-01, 0.1357D-01, 0.3504D-03,
     ,  -0.5683D-02,-0.4671D-02, 0.2446D-02, 0.1410D-01, 0.2842D-01,
     ,   0.4362D-01, 0.5825D-01, 0.7147D-01, 0.8311D-01, 0.9361D-01,
     ,   0.1038D+00, 0.1146D+00, 0.1266D+00, 0.1402D+00, 0.1554D+00,
     ,   0.1721D+00, 0.1899D+00, 0.2086D+00, 0.2279D+00, 0.2477D+00,
     ,   0.2679D+00, 0.2882D+00, 0.3088D+00, 0.3294D+00, 0.3501D+00,
     ,   0.3708D+00, 0.3916D+00, 0.4124D+00, 0.4333D+00, 0.4541D+00,
     ,   0.4749D+00, 0.4958D+00, 0.5166D+00, 0.5375D+00, 0.5583D+00,
     ,   0.5792D+00, 0.6000D+00, 0.6209D+00/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.6017D-01,-0.5602D-01,-0.4491D-01,-0.2813D-01,-0.6776D-02,
     ,   0.1819D-01, 0.4592D-01, 0.7563D-01, 0.1066D+00, 0.1382D+00,
     ,   0.1697D+00, 0.2006D+00, 0.2301D+00, 0.2576D+00, 0.2826D+00,
     ,   0.3044D+00, 0.3225D+00, 0.3362D+00, 0.3451D+00, 0.3488D+00,
     ,   0.3470D+00, 0.3394D+00, 0.3262D+00, 0.3075D+00, 0.2838D+00,
     ,   0.2557D+00, 0.2242D+00, 0.1904D+00, 0.1555D+00, 0.1210D+00,
     ,   0.8818D-01, 0.5845D-01, 0.3307D-01, 0.1323D-01,-0.9524D-04,
     ,  -0.6382D-02,-0.5857D-02, 0.4188D-03, 0.1073D-01, 0.2304D-01,
     ,   0.3541D-01, 0.4633D-01, 0.5496D-01, 0.6132D-01, 0.6617D-01,
     ,   0.7077D-01, 0.7641D-01, 0.8401D-01, 0.9402D-01, 0.1064D+00,
     ,   0.1210D+00, 0.1373D+00, 0.1549D+00, 0.1735D+00, 0.1927D+00,
     ,   0.2125D+00, 0.2326D+00, 0.2530D+00, 0.2735D+00, 0.2941D+00,
     ,   0.3148D+00, 0.3356D+00, 0.3563D+00, 0.3772D+00, 0.3980D+00,
     ,   0.4188D+00, 0.4397D+00, 0.4605D+00, 0.4814D+00, 0.5022D+00,
     ,   0.5231D+00, 0.5439D+00, 0.5648D+00/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.5985D-01,-0.5572D-01,-0.4467D-01,-0.2798D-01,-0.6741D-02,
     ,   0.1809D-01, 0.4567D-01, 0.7522D-01, 0.1060D+00, 0.1375D+00,
     ,   0.1688D+00, 0.1995D+00, 0.2288D+00, 0.2562D+00, 0.2811D+00,
     ,   0.3028D+00, 0.3207D+00, 0.3344D+00, 0.3432D+00, 0.3469D+00,
     ,   0.3451D+00, 0.3376D+00, 0.3245D+00, 0.3059D+00, 0.2823D+00,
     ,   0.2543D+00, 0.2230D+00, 0.1893D+00, 0.1546D+00, 0.1202D+00,
     ,   0.8761D-01, 0.5801D-01, 0.3273D-01, 0.1294D-01,-0.4229D-03,
     ,  -0.6872D-02,-0.6688D-02,-0.1008D-02, 0.8349D-02, 0.1925D-01,
     ,   0.2965D-01, 0.3797D-01, 0.4341D-01, 0.4610D-01, 0.4704D-01,
     ,   0.4777D-01, 0.4982D-01, 0.5435D-01, 0.6185D-01, 0.7232D-01,
     ,   0.8540D-01, 0.1006D+00, 0.1174D+00, 0.1354D+00, 0.1543D+00,
     ,   0.1738D+00, 0.1937D+00, 0.2139D+00, 0.2343D+00, 0.2549D+00,
     ,   0.2755D+00, 0.2962D+00, 0.3169D+00, 0.3377D+00, 0.3585D+00,
     ,   0.3793D+00, 0.4001D+00, 0.4209D+00, 0.4417D+00, 0.4625D+00,
     ,   0.4834D+00, 0.5042D+00, 0.5250D+00/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.5938D-01,-0.5528D-01,-0.4432D-01,-0.2776D-01,-0.6690D-02,
     ,   0.1795D-01, 0.4531D-01, 0.7464D-01, 0.1052D+00, 0.1364D+00,
     ,   0.1675D+00, 0.1979D+00, 0.2271D+00, 0.2542D+00, 0.2789D+00,
     ,   0.3004D+00, 0.3182D+00, 0.3318D+00, 0.3406D+00, 0.3442D+00,
     ,   0.3424D+00, 0.3349D+00, 0.3219D+00, 0.3034D+00, 0.2800D+00,
     ,   0.2523D+00, 0.2212D+00, 0.1878D+00, 0.1533D+00, 0.1192D+00,
     ,   0.8684D-01, 0.5747D-01, 0.3236D-01, 0.1268D-01,-0.6567D-03,
     ,  -0.7189D-02,-0.7228D-02,-0.1954D-02, 0.6756D-02, 0.1670D-01,
     ,   0.2577D-01, 0.3236D-01, 0.3568D-01, 0.3594D-01, 0.3429D-01,
     ,   0.3245D-01, 0.3214D-01, 0.3461D-01, 0.4044D-01, 0.4960D-01,
     ,   0.6168D-01, 0.7614D-01, 0.9241D-01, 0.1100D+00, 0.1286D+00,
     ,   0.1479D+00, 0.1676D+00, 0.1877D+00, 0.2080D+00, 0.2284D+00,
     ,   0.2490D+00, 0.2696D+00, 0.2903D+00, 0.3110D+00, 0.3317D+00,
     ,   0.3525D+00, 0.3732D+00, 0.3940D+00, 0.4147D+00, 0.4355D+00,
     ,   0.4563D+00, 0.4770D+00, 0.4978D+00/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.5871D-01,-0.5466D-01,-0.4382D-01,-0.2745D-01,-0.6616D-02,
     ,   0.1774D-01, 0.4480D-01, 0.7379D-01, 0.1040D+00, 0.1348D+00,
     ,   0.1656D+00, 0.1957D+00, 0.2245D+00, 0.2514D+00, 0.2757D+00,
     ,   0.2970D+00, 0.3146D+00, 0.3280D+00, 0.3367D+00, 0.3403D+00,
     ,   0.3385D+00, 0.3311D+00, 0.3182D+00, 0.3000D+00, 0.2768D+00,
     ,   0.2494D+00, 0.2186D+00, 0.1856D+00, 0.1515D+00, 0.1178D+00,
     ,   0.8578D-01, 0.5673D-01, 0.3190D-01, 0.1241D-01,-0.8311D-03,
     ,  -0.7376D-02,-0.7549D-02,-0.2545D-02, 0.5734D-02, 0.1505D-01,
     ,   0.2326D-01, 0.2875D-01, 0.3072D-01, 0.2945D-01, 0.2617D-01,
     ,   0.2271D-01, 0.2091D-01, 0.2208D-01, 0.2684D-01, 0.3515D-01,
     ,   0.4658D-01, 0.6053D-01, 0.7643D-01, 0.9376D-01, 0.1121D+00,
     ,   0.1312D+00, 0.1508D+00, 0.1707D+00, 0.1909D+00, 0.2112D+00,
     ,   0.2317D+00, 0.2522D+00, 0.2728D+00, 0.2934D+00, 0.3141D+00,
     ,   0.3347D+00, 0.3554D+00, 0.3761D+00, 0.3967D+00, 0.4174D+00,
     ,   0.4381D+00, 0.4588D+00, 0.4795D+00/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.5775D-01,-0.5377D-01,-0.4311D-01,-0.2700D-01,-0.6510D-02,
     ,   0.1745D-01, 0.4406D-01, 0.7258D-01, 0.1023D+00, 0.1326D+00,
     ,   0.1629D+00, 0.1925D+00, 0.2208D+00, 0.2473D+00, 0.2712D+00,
     ,   0.2922D+00, 0.3095D+00, 0.3226D+00, 0.3312D+00, 0.3347D+00,
     ,   0.3329D+00, 0.3257D+00, 0.3130D+00, 0.2950D+00, 0.2722D+00,
     ,   0.2452D+00, 0.2150D+00, 0.1825D+00, 0.1490D+00, 0.1158D+00,
     ,   0.8429D-01, 0.5572D-01, 0.3128D-01, 0.1208D-01,-0.9798D-03,
     ,  -0.7475D-02,-0.7717D-02,-0.2894D-02, 0.5090D-02, 0.1399D-01,
     ,   0.2165D-01, 0.2645D-01, 0.2760D-01, 0.2539D-01, 0.2113D-01,
     ,   0.1670D-01, 0.1399D-01, 0.1438D-01, 0.1847D-01, 0.2624D-01,
     ,   0.3722D-01, 0.5083D-01, 0.6644D-01, 0.8353D-01, 0.1017D+00,
     ,   0.1206D+00, 0.1400D+00, 0.1598D+00, 0.1798D+00, 0.2000D+00,
     ,   0.2204D+00, 0.2408D+00, 0.2612D+00, 0.2817D+00, 0.3022D+00,
     ,   0.3228D+00, 0.3433D+00, 0.3639D+00, 0.3844D+00, 0.4050D+00,
     ,   0.4256D+00, 0.4461D+00, 0.4667D+00/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.5640D-01,-0.5251D-01,-0.4210D-01,-0.2637D-01,-0.6360D-02,
     ,   0.1704D-01, 0.4303D-01, 0.7088D-01, 0.9992D-01, 0.1295D+00,
     ,   0.1591D+00, 0.1880D+00, 0.2156D+00, 0.2414D+00, 0.2649D+00,
     ,   0.2853D+00, 0.3022D+00, 0.3150D+00, 0.3234D+00, 0.3268D+00,
     ,   0.3251D+00, 0.3180D+00, 0.3056D+00, 0.2880D+00, 0.2658D+00,
     ,   0.2394D+00, 0.2098D+00, 0.1781D+00, 0.1454D+00, 0.1130D+00,
     ,   0.8219D-01, 0.5429D-01, 0.3042D-01, 0.1165D-01,-0.1134D-02,
     ,  -0.7515D-02,-0.7783D-02,-0.3096D-02, 0.4663D-02, 0.1326D-01,
     ,   0.2054D-01, 0.2488D-01, 0.2550D-01, 0.2273D-01, 0.1787D-01,
     ,   0.1285D-01, 0.9589D-02, 0.9474D-02, 0.1313D-01, 0.2051D-01,
     ,   0.3117D-01, 0.4449D-01, 0.5985D-01, 0.7670D-01, 0.9465D-01,
     ,   0.1134D+00, 0.1326D+00, 0.1522D+00, 0.1720D+00, 0.1921D+00,
     ,   0.2122D+00, 0.2325D+00, 0.2527D+00, 0.2731D+00, 0.2934D+00,
     ,   0.3138D+00, 0.3341D+00, 0.3545D+00, 0.3749D+00, 0.3953D+00,
     ,   0.4157D+00, 0.4361D+00, 0.4565D+00/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.5453D-01,-0.5077D-01,-0.4071D-01,-0.2550D-01,-0.6154D-02,
     ,   0.1647D-01, 0.4159D-01, 0.6852D-01, 0.9659D-01, 0.1252D+00,
     ,   0.1538D+00, 0.1817D+00, 0.2084D+00, 0.2334D+00, 0.2560D+00,
     ,   0.2758D+00, 0.2921D+00, 0.3045D+00, 0.3126D+00, 0.3159D+00,
     ,   0.3142D+00, 0.3073D+00, 0.2953D+00, 0.2783D+00, 0.2568D+00,
     ,   0.2313D+00, 0.2027D+00, 0.1720D+00, 0.1403D+00, 0.1090D+00,
     ,   0.7928D-01, 0.5231D-01, 0.2923D-01, 0.1107D-01,-0.1323D-02,
     ,  -0.7522D-02,-0.7785D-02,-0.3224D-02, 0.4320D-02, 0.1263D-01,
     ,   0.1959D-01, 0.2355D-01, 0.2378D-01, 0.2059D-01, 0.1530D-01,
     ,   0.9864D-02, 0.6202D-02, 0.5707D-02, 0.9006D-02, 0.1606D-01,
     ,   0.2641D-01, 0.3944D-01, 0.5451D-01, 0.7110D-01, 0.8878D-01,
     ,   0.1072D+00, 0.1262D+00, 0.1456D+00, 0.1652D+00, 0.1850D+00,
     ,   0.2049D+00, 0.2248D+00, 0.2449D+00, 0.2649D+00, 0.2850D+00,
     ,   0.3052D+00, 0.3253D+00, 0.3454D+00, 0.3656D+00, 0.3857D+00,
     ,   0.4059D+00, 0.4260D+00, 0.4462D+00/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.5199D-01,-0.4841D-01,-0.3882D-01,-0.2432D-01,-0.5875D-02,
     ,   0.1569D-01, 0.3965D-01, 0.6532D-01, 0.9209D-01, 0.1194D+00,
     ,   0.1466D+00, 0.1732D+00, 0.1987D+00, 0.2225D+00, 0.2441D+00,
     ,   0.2629D+00, 0.2785D+00, 0.2903D+00, 0.2980D+00, 0.3011D+00,
     ,   0.2995D+00, 0.2929D+00, 0.2814D+00, 0.2652D+00, 0.2446D+00,
     ,   0.2203D+00, 0.1930D+00, 0.1637D+00, 0.1335D+00, 0.1037D+00,
     ,   0.7532D-01, 0.4961D-01, 0.2760D-01, 0.1027D-01,-0.1576D-02,
     ,  -0.7511D-02,-0.7748D-02,-0.3333D-02, 0.3955D-02, 0.1194D-01,
     ,   0.1852D-01, 0.2209D-01, 0.2190D-01, 0.1829D-01, 0.1259D-01,
     ,   0.6737D-02, 0.2673D-02, 0.1784D-02, 0.4699D-02, 0.1138D-01,
     ,   0.2136D-01, 0.3402D-01, 0.4874D-01, 0.6497D-01, 0.8230D-01,
     ,   0.1004D+00, 0.1190D+00, 0.1380D+00, 0.1573D+00, 0.1767D+00,
     ,   0.1963D+00, 0.2159D+00, 0.2356D+00, 0.2554D+00, 0.2751D+00,
     ,   0.2949D+00, 0.3147D+00, 0.3345D+00, 0.3543D+00, 0.3741D+00,
     ,   0.3939D+00, 0.4137D+00, 0.4335D+00/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.4867D-01,-0.4532D-01,-0.3634D-01,-0.2278D-01,-0.5510D-02,
     ,   0.1468D-01, 0.3710D-01, 0.6112D-01, 0.8618D-01, 0.1117D+00,
     ,   0.1372D+00, 0.1621D+00, 0.1860D+00, 0.2082D+00, 0.2284D+00,
     ,   0.2460D+00, 0.2605D+00, 0.2716D+00, 0.2788D+00, 0.2817D+00,
     ,   0.2801D+00, 0.2740D+00, 0.2632D+00, 0.2480D+00, 0.2287D+00,
     ,   0.2059D+00, 0.1803D+00, 0.1528D+00, 0.1246D+00, 0.9663D-01,
     ,   0.7009D-01, 0.4603D-01, 0.2544D-01, 0.9204D-02,-0.1916D-02,
     ,  -0.7490D-02,-0.7684D-02,-0.3455D-02, 0.3496D-02, 0.1106D-01,
     ,   0.1715D-01, 0.2020D-01, 0.1949D-01, 0.1535D-01, 0.9125D-02,
     ,   0.2761D-02,-0.1812D-02,-0.3203D-02,-0.7860D-03, 0.5397D-02,
     ,   0.1489D-01, 0.2706D-01, 0.4129D-01, 0.5704D-01, 0.7389D-01,
     ,   0.9150D-01, 0.1097D+00, 0.1282D+00, 0.1470D+00, 0.1659D+00,
     ,   0.1850D+00, 0.2042D+00, 0.2234D+00, 0.2427D+00, 0.2619D+00,
     ,   0.2812D+00, 0.3006D+00, 0.3199D+00, 0.3392D+00, 0.3585D+00,
     ,   0.3779D+00, 0.3972D+00, 0.4166D+00/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.4449D-01,-0.4143D-01,-0.3323D-01,-0.2083D-01,-0.5054D-02,
     ,   0.1340D-01, 0.3389D-01, 0.5584D-01, 0.7874D-01, 0.1021D+00,
     ,   0.1254D+00, 0.1481D+00, 0.1699D+00, 0.1902D+00, 0.2087D+00,
     ,   0.2247D+00, 0.2380D+00, 0.2481D+00, 0.2546D+00, 0.2572D+00,
     ,   0.2558D+00, 0.2501D+00, 0.2402D+00, 0.2263D+00, 0.2086D+00,
     ,   0.1877D+00, 0.1643D+00, 0.1392D+00, 0.1133D+00, 0.8773D-01,
     ,   0.6347D-01, 0.4149D-01, 0.2268D-01, 0.7836D-02,-0.2345D-02,
     ,  -0.7446D-02,-0.7575D-02,-0.3590D-02, 0.2912D-02, 0.9898D-02,
     ,   0.1535D-01, 0.1773D-01, 0.1633D-01, 0.1151D-01, 0.4620D-02,
     ,  -0.2403D-02,-0.7630D-02,-0.9677D-02,-0.7919D-02,-0.2397D-02,
     ,   0.6430D-02, 0.1794D-01, 0.3151D-01, 0.4660D-01, 0.6278D-01,
     ,   0.7975D-01, 0.9725D-01, 0.1151D+00, 0.1333D+00, 0.1516D+00,
     ,   0.1700D+00, 0.1886D+00, 0.2071D+00, 0.2258D+00, 0.2444D+00,
     ,   0.2631D+00, 0.2818D+00, 0.3005D+00, 0.3192D+00, 0.3379D+00,
     ,   0.3566D+00, 0.3753D+00, 0.3940D+00/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.3950D-01,-0.3680D-01,-0.2952D-01,-0.1852D-01,-0.4513D-02,
     ,   0.1186D-01, 0.3005D-01, 0.4954D-01, 0.6986D-01, 0.9057D-01,
     ,   0.1112D+00, 0.1314D+00, 0.1508D+00, 0.1688D+00, 0.1851D+00,
     ,   0.1994D+00, 0.2111D+00, 0.2200D+00, 0.2258D+00, 0.2281D+00,
     ,   0.2267D+00, 0.2216D+00, 0.2128D+00, 0.2003D+00, 0.1846D+00,
     ,   0.1660D+00, 0.1451D+00, 0.1228D+00, 0.9978D-01, 0.7708D-01,
     ,   0.5555D-01, 0.3608D-01, 0.1942D-01, 0.6280D-02,-0.2728D-02,
     ,  -0.7220D-02,-0.7261D-02,-0.3605D-02, 0.2283D-02, 0.8494D-02,
     ,   0.1311D-01, 0.1466D-01, 0.1247D-01, 0.6922D-02,-0.6631D-03,
     ,  -0.8372D-02,-0.1431D-01,-0.1711D-01,-0.1615D-01,-0.1148D-01,
     ,  -0.3531D-02, 0.7071D-02, 0.1972D-01, 0.3389D-01, 0.4916D-01,
     ,   0.6521D-01, 0.8181D-01, 0.9880D-01, 0.1161D+00, 0.1335D+00,
     ,   0.1511D+00, 0.1688D+00, 0.1865D+00, 0.2043D+00, 0.2221D+00,
     ,   0.2399D+00, 0.2578D+00, 0.2756D+00, 0.2935D+00, 0.3114D+00,
     ,   0.3293D+00, 0.3471D+00, 0.3650D+00/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.3391D-01,-0.3160D-01,-0.2536D-01,-0.1592D-01,-0.3909D-02,
     ,   0.1014D-01, 0.2575D-01, 0.4247D-01, 0.5990D-01, 0.7766D-01,
     ,   0.9538D-01, 0.1127D+00, 0.1293D+00, 0.1447D+00, 0.1587D+00,
     ,   0.1709D+00, 0.1809D+00, 0.1885D+00, 0.1934D+00, 0.1953D+00,
     ,   0.1941D+00, 0.1896D+00, 0.1820D+00, 0.1712D+00, 0.1576D+00,
     ,   0.1416D+00, 0.1237D+00, 0.1045D+00, 0.8478D-01, 0.6538D-01,
     ,   0.4706D-01, 0.3057D-01, 0.1657D-01, 0.5626D-02,-0.1784D-02,
     ,  -0.5393D-02,-0.5324D-02,-0.2281D-02, 0.2455D-02, 0.7275D-02,
     ,   0.1060D-01, 0.1124D-01, 0.8661D-02, 0.3180D-02,-0.4052D-02,
     ,  -0.1138D-01,-0.1713D-01,-0.2012D-01,-0.1976D-01,-0.1607D-01,
     ,  -0.9407D-02,-0.2889D-03, 0.1076D-01, 0.2329D-01, 0.3692D-01,
     ,   0.5137D-01, 0.6644D-01, 0.8195D-01, 0.9780D-01, 0.1139D+00,
     ,   0.1302D+00, 0.1466D+00, 0.1632D+00, 0.1798D+00, 0.1965D+00,
     ,   0.2132D+00, 0.2300D+00, 0.2468D+00, 0.2636D+00, 0.2805D+00,
     ,   0.2973D+00, 0.3142D+00, 0.3311D+00/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.2807D-01,-0.2616D-01,-0.2101D-01,-0.1321D-01,-0.3275D-02,
     ,   0.8345D-02, 0.2125D-01, 0.3508D-01, 0.4949D-01, 0.6417D-01,
     ,   0.7881D-01, 0.9312D-01, 0.1068D+00, 0.1195D+00, 0.1311D+00,
     ,   0.1411D+00, 0.1494D+00, 0.1556D+00, 0.1596D+00, 0.1611D+00,
     ,   0.1600D+00, 0.1563D+00, 0.1499D+00, 0.1410D+00, 0.1297D+00,
     ,   0.1165D+00, 0.1018D+00, 0.8607D-01, 0.7011D-01, 0.5458D-01,
     ,   0.4017D-01, 0.2755D-01, 0.1724D-01, 0.9622D-02, 0.4879D-02,
     ,   0.2895D-02, 0.3170D-02, 0.4804D-02, 0.6726D-02, 0.8091D-02,
     ,   0.8512D-02, 0.7968D-02, 0.6590D-02, 0.4589D-02, 0.2318D-02,
     ,   0.2758D-03,-0.9912D-03,-0.1027D-02, 0.4584D-03, 0.3579D-02,
     ,   0.8322D-02, 0.1459D-01, 0.2226D-01, 0.3118D-01, 0.4121D-01,
     ,   0.5221D-01, 0.6405D-01, 0.7661D-01, 0.8979D-01, 0.1035D+00,
     ,   0.1176D+00, 0.1322D+00, 0.1470D+00, 0.1620D+00, 0.1773D+00,
     ,   0.1927D+00, 0.2083D+00, 0.2240D+00, 0.2397D+00, 0.2555D+00,
     ,   0.2714D+00, 0.2873D+00, 0.3033D+00/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.2238D-01,-0.2088D-01,-0.1678D-01,-0.1057D-01,-0.2661D-02,
     ,   0.6595D-02, 0.1687D-01, 0.2788D-01, 0.3936D-01, 0.5104D-01,
     ,   0.6269D-01, 0.7407D-01, 0.8494D-01, 0.9506D-01, 0.1042D+00,
     ,   0.1121D+00, 0.1187D+00, 0.1236D+00, 0.1267D+00, 0.1278D+00,
     ,   0.1268D+00, 0.1238D+00, 0.1186D+00, 0.1114D+00, 0.1024D+00,
     ,   0.9188D-01, 0.8015D-01, 0.6773D-01, 0.5516D-01, 0.4302D-01,
     ,   0.3189D-01, 0.2229D-01, 0.1464D-01, 0.9178D-02, 0.5988D-02,
     ,   0.4890D-02, 0.5398D-02, 0.6705D-02, 0.7850D-02, 0.8093D-02,
     ,   0.7239D-02, 0.5604D-02, 0.3675D-02, 0.1829D-02, 0.2983D-03,
     ,  -0.7459D-03,-0.1131D-02,-0.6778D-03, 0.7705D-03, 0.3333D-02,
     ,   0.7079D-02, 0.1203D-01, 0.1817D-01, 0.2544D-01, 0.3378D-01,
     ,   0.4309D-01, 0.5327D-01, 0.6423D-01, 0.7586D-01, 0.8807D-01,
     ,   0.1008D+00, 0.1139D+00, 0.1274D+00, 0.1411D+00, 0.1551D+00,
     ,   0.1693D+00, 0.1837D+00, 0.1982D+00, 0.2128D+00, 0.2274D+00,
     ,   0.2421D+00, 0.2569D+00, 0.2717D+00/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.1723D-01,-0.1609D-01,-0.1295D-01,-0.8185D-02,-0.2105D-02,
     ,   0.5008D-02, 0.1291D-01, 0.2137D-01, 0.3018D-01, 0.3915D-01,
     ,   0.4809D-01, 0.5681D-01, 0.6513D-01, 0.7288D-01, 0.7986D-01,
     ,   0.8590D-01, 0.9085D-01, 0.9453D-01, 0.9682D-01, 0.9759D-01,
     ,   0.9677D-01, 0.9432D-01, 0.9025D-01, 0.8463D-01, 0.7763D-01,
     ,   0.6945D-01, 0.6039D-01, 0.5085D-01, 0.4123D-01, 0.3200D-01,
     ,   0.2361D-01, 0.1646D-01, 0.1085D-01, 0.6966D-02, 0.4828D-02,
     ,   0.4282D-02, 0.4960D-02, 0.6257D-02, 0.7401D-02, 0.7686D-02,
     ,   0.6776D-02, 0.4826D-02, 0.2295D-02,-0.3447D-03,-0.2752D-02,
     ,  -0.4688D-02,-0.5958D-02,-0.6385D-02,-0.5822D-02,-0.4163D-02,
     ,  -0.1353D-02, 0.2620D-02, 0.7728D-02, 0.1392D-01, 0.2111D-01,
     ,   0.2922D-01, 0.3816D-01, 0.4782D-01, 0.5812D-01, 0.6896D-01,
     ,   0.8027D-01, 0.9198D-01, 0.1040D+00, 0.1163D+00, 0.1288D+00,
     ,   0.1416D+00, 0.1544D+00, 0.1674D+00, 0.1805D+00, 0.1936D+00,
     ,   0.2069D+00, 0.2201D+00, 0.2334D+00/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.1286D-01,-0.1203D-01,-0.9700D-02,-0.6155D-02,-0.1631D-02,
     ,   0.3664D-02, 0.9544D-02, 0.1584D-01, 0.2239D-01, 0.2906D-01,
     ,   0.3570D-01, 0.4217D-01, 0.4833D-01, 0.5406D-01, 0.5920D-01,
     ,   0.6364D-01, 0.6725D-01, 0.6991D-01, 0.7152D-01, 0.7200D-01,
     ,   0.7128D-01, 0.6935D-01, 0.6621D-01, 0.6192D-01, 0.5661D-01,
     ,   0.5044D-01, 0.4366D-01, 0.3654D-01, 0.2942D-01, 0.2264D-01,
     ,   0.1657D-01, 0.1148D-01, 0.7627D-02, 0.5115D-02, 0.3941D-02,
     ,   0.3956D-02, 0.4851D-02, 0.6157D-02, 0.7281D-02, 0.7641D-02,
     ,   0.6880D-02, 0.5019D-02, 0.2400D-02,-0.5338D-03,-0.3408D-02,
     ,  -0.5945D-02,-0.7925D-02,-0.9152D-02,-0.9468D-02,-0.8759D-02,
     ,  -0.6965D-02,-0.4073D-02,-0.1086D-03, 0.4873D-02, 0.1080D-01,
     ,   0.1759D-01, 0.2514D-01, 0.3338D-01, 0.4222D-01, 0.5156D-01,
     ,   0.6134D-01, 0.7149D-01, 0.8195D-01, 0.9266D-01, 0.1036D+00,
     ,   0.1147D+00, 0.1259D+00, 0.1373D+00, 0.1487D+00, 0.1602D+00,
     ,   0.1718D+00, 0.1834D+00, 0.1951D+00/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.9346D-02,-0.8761D-02,-0.7085D-02,-0.4521D-02,-0.1244D-02,
     ,   0.2592D-02, 0.6851D-02, 0.1141D-01, 0.1615D-01, 0.2097D-01,
     ,   0.2577D-01, 0.3043D-01, 0.3487D-01, 0.3897D-01, 0.4265D-01,
     ,   0.4581D-01, 0.4835D-01, 0.5020D-01, 0.5128D-01, 0.5152D-01,
     ,   0.5089D-01, 0.4938D-01, 0.4699D-01, 0.4378D-01, 0.3983D-01,
     ,   0.3528D-01, 0.3031D-01, 0.2513D-01, 0.1999D-01, 0.1517D-01,
     ,   0.1092D-01, 0.7470D-02, 0.4999D-02, 0.3591D-02, 0.3229D-02,
     ,   0.3772D-02, 0.4948D-02, 0.6358D-02, 0.7516D-02, 0.7951D-02,
     ,   0.7353D-02, 0.5698D-02, 0.3237D-02, 0.3442D-03,-0.2634D-02,
     ,  -0.5433D-02,-0.7839D-02,-0.9655D-02,-0.1070D-01,-0.1086D-01,
     ,  -0.1003D-01,-0.8190D-02,-0.5362D-02,-0.1588D-02, 0.3065D-02,
     ,   0.8519D-02, 0.1469D-01, 0.2150D-01, 0.2886D-01, 0.3670D-01,
     ,   0.4495D-01, 0.5354D-01, 0.6242D-01, 0.7154D-01, 0.8085D-01,
     ,   0.9033D-01, 0.9994D-01, 0.1097D+00, 0.1195D+00, 0.1293D+00,
     ,   0.1393D+00, 0.1492D+00, 0.1592D+00/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.6653D-02,-0.6254D-02,-0.5074D-02,-0.3261D-02,-0.9403D-03,
     ,   0.1778D-02, 0.4796D-02, 0.8024D-02, 0.1138D-01, 0.1479D-01,
     ,   0.1817D-01, 0.2145D-01, 0.2457D-01, 0.2744D-01, 0.3000D-01,
     ,   0.3218D-01, 0.3392D-01, 0.3515D-01, 0.3583D-01, 0.3591D-01,
     ,   0.3536D-01, 0.3418D-01, 0.3238D-01, 0.3000D-01, 0.2710D-01,
     ,   0.2379D-01, 0.2020D-01, 0.1650D-01, 0.1287D-01, 0.9517D-02,
     ,   0.6632D-02, 0.4396D-02, 0.2944D-02, 0.2347D-02, 0.2591D-02,
     ,   0.3559D-02, 0.5013D-02, 0.6598D-02, 0.7887D-02, 0.8466D-02,
     ,   0.8058D-02, 0.6628D-02, 0.4387D-02, 0.1675D-02,-0.1192D-02,
     ,  -0.3988D-02,-0.6541D-02,-0.8686D-02,-0.1025D-01,-0.1108D-01,
     ,  -0.1108D-01,-0.1018D-01,-0.8391D-02,-0.5737D-02,-0.2274D-02,
     ,   0.1928D-02, 0.6796D-02, 0.1225D-01, 0.1822D-01, 0.2464D-01,
     ,   0.3143D-01, 0.3854D-01, 0.4593D-01, 0.5354D-01, 0.6133D-01,
     ,   0.6928D-01, 0.7734D-01, 0.8551D-01, 0.9376D-01, 0.1021D+00,
     ,   0.1104D+00, 0.1189D+00, 0.1273D+00/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.4659D-02,-0.4394D-02,-0.3580D-02,-0.2321D-02,-0.7067D-03,
     ,   0.1186D-02, 0.3287D-02, 0.5533D-02, 0.7865D-02, 0.1023D-01,
     ,   0.1257D-01, 0.1484D-01, 0.1698D-01, 0.1895D-01, 0.2069D-01,
     ,   0.2216D-01, 0.2331D-01, 0.2410D-01, 0.2449D-01, 0.2446D-01,
     ,   0.2399D-01, 0.2307D-01, 0.2172D-01, 0.1996D-01, 0.1785D-01,
     ,   0.1547D-01, 0.1291D-01, 0.1029D-01, 0.7766D-02, 0.5472D-02,
     ,   0.3565D-02, 0.2180D-02, 0.1429D-02, 0.1373D-02, 0.2014D-02,
     ,   0.3262D-02, 0.4921D-02, 0.6679D-02, 0.8150D-02, 0.8947D-02,
     ,   0.8797D-02, 0.7635D-02, 0.5639D-02, 0.3135D-02, 0.4479D-03,
     ,  -0.2204D-02,-0.4699D-02,-0.6930D-02,-0.8765D-02,-0.1006D-01,
     ,  -0.1068D-01,-0.1056D-01,-0.9649D-02,-0.7972D-02,-0.5562D-02,
     ,  -0.2477D-02, 0.1218D-02, 0.5456D-02, 0.1017D-01, 0.1529D-01,
     ,   0.2077D-01, 0.2654D-01, 0.3257D-01, 0.3880D-01, 0.4521D-01,
     ,   0.5176D-01, 0.5842D-01, 0.6518D-01, 0.7201D-01, 0.7891D-01,
     ,   0.8585D-01, 0.9283D-01, 0.9985D-01/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.3222D-02,-0.3051D-02,-0.2499D-02,-0.1637D-02,-0.5295D-03,
     ,   0.7698D-03, 0.2212D-02, 0.3752D-02, 0.5350D-02, 0.6966D-02,
     ,   0.8562D-02, 0.1010D-01, 0.1155D-01, 0.1287D-01, 0.1403D-01,
     ,   0.1500D-01, 0.1574D-01, 0.1622D-01, 0.1643D-01, 0.1633D-01,
     ,   0.1593D-01, 0.1522D-01, 0.1420D-01, 0.1291D-01, 0.1138D-01,
     ,   0.9673D-02, 0.7858D-02, 0.6026D-02, 0.4282D-02, 0.2736D-02,
     ,   0.1505D-02, 0.6950D-03, 0.3966D-03, 0.6705D-03, 0.1529D-02,
     ,   0.2916D-02, 0.4674D-02, 0.6543D-02, 0.8176D-02, 0.9211D-02,
     ,   0.9367D-02, 0.8538D-02, 0.6837D-02, 0.4561D-02, 0.2054D-02,
     ,  -0.4284D-03,-0.2767D-02,-0.4914D-02,-0.6805D-02,-0.8332D-02,
     ,  -0.9369D-02,-0.9814D-02,-0.9608D-02,-0.8736D-02,-0.7215D-02,
     ,  -0.5086D-02,-0.2403D-02, 0.7763D-03, 0.4392D-02, 0.8385D-02,
     ,   0.1270D-01, 0.1730D-01, 0.2213D-01, 0.2715D-01, 0.3233D-01,
     ,   0.3765D-01, 0.4307D-01, 0.4858D-01, 0.5417D-01, 0.5981D-01,
     ,   0.6549D-01, 0.7122D-01, 0.7697D-01/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.2207D-02,-0.2100D-02,-0.1730D-02,-0.1148D-02,-0.3961D-03,
     ,   0.4861D-03, 0.1465D-02, 0.2510D-02, 0.3591D-02, 0.4683D-02,
     ,   0.5757D-02, 0.6790D-02, 0.7756D-02, 0.8631D-02, 0.9390D-02,
     ,   0.1001D-01, 0.1047D-01, 0.1075D-01, 0.1084D-01, 0.1071D-01,
     ,   0.1037D-01, 0.9817D-02, 0.9057D-02, 0.8108D-02, 0.7003D-02,
     ,   0.5781D-02, 0.4499D-02, 0.3223D-02, 0.2029D-02, 0.1002D-02,
     ,   0.2280D-03,-0.2071D-03,-0.2280D-03, 0.2226D-03, 0.1169D-02,
     ,   0.2578D-02, 0.4336D-02, 0.6228D-02, 0.7955D-02, 0.9188D-02,
     ,   0.9646D-02, 0.9183D-02, 0.7840D-02, 0.5844D-02, 0.3526D-02,
     ,   0.1192D-02,-0.9905D-03,-0.2982D-02,-0.4783D-02,-0.6350D-02,
     ,  -0.7592D-02,-0.8406D-02,-0.8710D-02,-0.8461D-02,-0.7654D-02,
     ,  -0.6311D-02,-0.4471D-02,-0.2183D-02, 0.5020D-03, 0.3534D-02,
     ,   0.6865D-02, 0.1045D-01, 0.1425D-01, 0.1823D-01, 0.2236D-01,
     ,   0.2662D-01, 0.3097D-01, 0.3541D-01, 0.3991D-01, 0.4447D-01,
     ,   0.4907D-01, 0.5370D-01, 0.5836D-01/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.1500D-02,-0.1436D-02,-0.1191D-02,-0.8010D-03,-0.2959D-03,
     ,   0.2978D-03, 0.9563D-03, 0.1658D-02, 0.2383D-02, 0.3113D-02,
     ,   0.3829D-02, 0.4514D-02, 0.5149D-02, 0.5719D-02, 0.6206D-02,
     ,   0.6596D-02, 0.6872D-02, 0.7022D-02, 0.7035D-02, 0.6903D-02,
     ,   0.6622D-02, 0.6193D-02, 0.5624D-02, 0.4929D-02, 0.4130D-02,
     ,   0.3260D-02, 0.2357D-02, 0.1473D-02, 0.6628D-03,-0.9533D-05,
     ,  -0.4775D-03,-0.6739D-03,-0.5350D-03,-0.7384D-05, 0.9397D-03,
     ,   0.2294D-02, 0.3974D-02, 0.5809D-02, 0.7550D-02, 0.8905D-02,
     ,   0.9611D-02, 0.9497D-02, 0.8541D-02, 0.6886D-02, 0.4806D-02,
     ,   0.2616D-02, 0.5509D-03,-0.1300D-02,-0.2952D-02,-0.4432D-02,
     ,  -0.5708D-02,-0.6703D-02,-0.7331D-02,-0.7527D-02,-0.7263D-02,
     ,  -0.6540D-02,-0.5380D-02,-0.3820D-02,-0.1902D-02, 0.3314D-03,
     ,   0.2838D-02, 0.5578D-02, 0.8516D-02, 0.1162D-01, 0.1486D-01,
     ,   0.1822D-01, 0.2167D-01, 0.2520D-01, 0.2879D-01, 0.3243D-01,
     ,   0.3611D-01, 0.3982D-01, 0.4356D-01/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.1014D-02,-0.9768D-03,-0.8166D-03,-0.5576D-03,-0.2206D-03,
     ,   0.1759D-03, 0.6156D-03, 0.1084D-02, 0.1566D-02, 0.2050D-02,
     ,   0.2522D-02, 0.2971D-02, 0.3384D-02, 0.3750D-02, 0.4057D-02,
     ,   0.4295D-02, 0.4453D-02, 0.4523D-02, 0.4498D-02, 0.4372D-02,
     ,   0.4143D-02, 0.3814D-02, 0.3389D-02, 0.2881D-02, 0.2306D-02,
     ,   0.1687D-02, 0.1056D-02, 0.4472D-03,-0.9589D-04,-0.5259D-03,
     ,  -0.7915D-03,-0.8392D-03,-0.6155D-03,-0.7184D-04, 0.8257D-03,
     ,   0.2078D-02, 0.3630D-02, 0.5350D-02, 0.7033D-02, 0.8431D-02,
     ,   0.9305D-02, 0.9482D-02, 0.8896D-02, 0.7616D-02, 0.5834D-02,
     ,   0.3828D-02, 0.1864D-02, 0.1050D-03,-0.1422D-02,-0.2765D-02,
     ,  -0.3961D-02,-0.4986D-02,-0.5773D-02,-0.6251D-02,-0.6370D-02,
     ,  -0.6111D-02,-0.5478D-02,-0.4496D-02,-0.3194D-02,-0.1608D-02,
     ,   0.2246D-03, 0.2271D-02, 0.4498D-02, 0.6879D-02, 0.9387D-02,
     ,   0.1200D-01, 0.1470D-01, 0.1747D-01, 0.2030D-01, 0.2318D-01,
     ,   0.2609D-01, 0.2904D-01, 0.3201D-01/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.6820D-03,-0.6618D-03,-0.5580D-03,-0.3873D-03,-0.1641D-03,
     ,   0.9902D-04, 0.3907D-03, 0.7006D-03, 0.1019D-02, 0.1337D-02,
     ,   0.1646D-02, 0.1938D-02, 0.2203D-02, 0.2435D-02, 0.2625D-02,
     ,   0.2766D-02, 0.2851D-02, 0.2874D-02, 0.2831D-02, 0.2718D-02,
     ,   0.2536D-02, 0.2284D-02, 0.1969D-02, 0.1600D-02, 0.1187D-02,
     ,   0.7509D-03, 0.3120D-03,-0.1021D-03,-0.4594D-03,-0.7242D-03,
     ,  -0.8567D-03,-0.8141D-03,-0.5519D-03,-0.2673D-04, 0.7954D-03,
     ,   0.1924D-02, 0.3322D-02, 0.4890D-02, 0.6463D-02, 0.7835D-02,
     ,   0.8798D-02, 0.9189D-02, 0.8921D-02, 0.8007D-02, 0.6565D-02,
     ,   0.4802D-02, 0.2967D-02, 0.1273D-02,-0.1822D-03,-0.1414D-02,
     ,  -0.2490D-02,-0.3444D-02,-0.4258D-02,-0.4874D-02,-0.5233D-02,
     ,  -0.5298D-02,-0.5056D-02,-0.4516D-02,-0.3696D-02,-0.2624D-02,
     ,  -0.1330D-02, 0.1569D-03, 0.1809D-02, 0.3601D-02, 0.5510D-02,
     ,   0.7517D-02, 0.9605D-02, 0.1176D-01, 0.1397D-01, 0.1622D-01,
     ,   0.1850D-01, 0.2081D-01, 0.2315D-01/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.4567D-03,-0.4469D-03,-0.3803D-03,-0.2686D-03,-0.1216D-03,
     ,   0.5194D-04, 0.2443D-03, 0.4482D-03, 0.6572D-03, 0.8650D-03,
     ,   0.1065D-02, 0.1253D-02, 0.1422D-02, 0.1566D-02, 0.1681D-02,
     ,   0.1761D-02, 0.1802D-02, 0.1800D-02, 0.1752D-02, 0.1656D-02,
     ,   0.1513D-02, 0.1323D-02, 0.1091D-02, 0.8239D-03, 0.5309D-03,
     ,   0.2254D-03,-0.7596D-04,-0.3527D-03,-0.5810D-03,-0.7335D-03,
     ,  -0.7792D-03,-0.6841D-03,-0.4110D-03, 0.7772D-04, 0.8142D-03,
     ,   0.1812D-02, 0.3049D-02, 0.4448D-02, 0.5879D-02, 0.7174D-02,
     ,   0.8158D-02, 0.8686D-02, 0.8666D-02, 0.8077D-02, 0.6978D-02,
     ,   0.5506D-02, 0.3859D-02, 0.2248D-02, 0.8283D-03,-0.3487D-03,
     ,  -0.1326D-02,-0.2176D-02,-0.2930D-02,-0.3570D-02,-0.4047D-02,
     ,  -0.4314D-02,-0.4343D-02,-0.4127D-02,-0.3672D-02,-0.2998D-02,
     ,  -0.2126D-02,-0.1081D-02, 0.1130D-03, 0.1434D-02, 0.2863D-02,
     ,   0.4381D-02, 0.5973D-02, 0.7626D-02, 0.9329D-02, 0.1107D-01,
     ,   0.1285D-01, 0.1465D-01, 0.1647D-01/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.3046D-03,-0.3008D-03,-0.2586D-03,-0.1860D-03,-0.8978D-04,
     ,   0.2410D-04, 0.1502D-03, 0.2837D-03, 0.4200D-03, 0.5547D-03,
     ,   0.6838D-03, 0.8031D-03, 0.9089D-03, 0.9973D-03, 0.1065D-02,
     ,   0.1108D-02, 0.1124D-02, 0.1110D-02, 0.1064D-02, 0.9858D-03,
     ,   0.8751D-03, 0.7336D-03, 0.5645D-03, 0.3732D-03, 0.1671D-03,
     ,  -0.4391D-04,-0.2471D-03,-0.4272D-03,-0.5660D-03,-0.6426D-03,
     ,  -0.6329D-03,-0.5095D-03,-0.2418D-03, 0.2023D-03, 0.8520D-03,
     ,   0.1722D-02, 0.2800D-02, 0.4027D-02, 0.5302D-02, 0.6488D-02,
     ,   0.7443D-02, 0.8041D-02, 0.8196D-02, 0.7872D-02, 0.7088D-02,
     ,   0.5924D-02, 0.4517D-02, 0.3042D-02, 0.1668D-02, 0.5062D-03,
     ,  -0.4286D-03,-0.1194D-02,-0.1857D-02,-0.2447D-02,-0.2946D-02,
     ,  -0.3313D-02,-0.3511D-02,-0.3517D-02,-0.3328D-02,-0.2952D-02,
     ,  -0.2404D-02,-0.1702D-02,-0.8665D-03, 0.8386D-04, 0.1132D-02,
     ,   0.2261D-02, 0.3458D-02, 0.4712D-02, 0.6011D-02, 0.7348D-02,
     ,   0.8715D-02, 0.1011D-01, 0.1152D-01/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.2023D-03,-0.2018D-03,-0.1755D-03,-0.1286D-03,-0.6594D-04,
     ,   0.8390D-05, 0.9068D-04, 0.1776D-03, 0.2659D-03, 0.3527D-03,
     ,   0.4351D-03, 0.5104D-03, 0.5758D-03, 0.6289D-03, 0.6672D-03,
     ,   0.6885D-03, 0.6908D-03, 0.6725D-03, 0.6325D-03, 0.5703D-03,
     ,   0.4865D-03, 0.3824D-03, 0.2607D-03, 0.1255D-03,-0.1740D-04,
     ,  -0.1604D-03,-0.2938D-03,-0.4061D-03,-0.4834D-03,-0.5095D-03,
     ,  -0.4656D-03,-0.3297D-03,-0.7677D-04, 0.3203D-03, 0.8869D-03,
     ,   0.1638D-02, 0.2566D-02, 0.3628D-02, 0.4743D-02, 0.5805D-02,
     ,   0.6696D-02, 0.7313D-02, 0.7580D-02, 0.7454D-02, 0.6935D-02,
     ,   0.6063D-02, 0.4922D-02, 0.3638D-02, 0.2358D-02, 0.1215D-02,
     ,   0.2815D-03,-0.4500D-03,-0.1042D-02,-0.1555D-02,-0.2014D-02,
     ,  -0.2400D-02,-0.2681D-02,-0.2825D-02,-0.2818D-02,-0.2657D-02,
     ,  -0.2350D-02,-0.1908D-02,-0.1349D-02,-0.6865D-03, 0.6377D-04,
     ,   0.8882D-03, 0.1775D-02, 0.2713D-02, 0.3693D-02, 0.4707D-02,
     ,   0.5750D-02, 0.6815D-02, 0.7898D-02/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.1338D-03,-0.1350D-03,-0.1187D-03,-0.8870D-04,-0.4814D-04,
     ,   0.1222D-06, 0.5354D-04, 0.1098D-03, 0.1667D-03, 0.2222D-03,
     ,   0.2744D-03, 0.3214D-03, 0.3613D-03, 0.3925D-03, 0.4132D-03,
     ,   0.4221D-03, 0.4179D-03, 0.3995D-03, 0.3664D-03, 0.3184D-03,
     ,   0.2560D-03, 0.1806D-03, 0.9435D-04, 0.4429D-06,-0.9659D-04,
     ,  -0.1909D-03,-0.2752D-03,-0.3404D-03,-0.3760D-03,-0.3694D-03,
     ,  -0.3058D-03,-0.1676D-03, 0.6555D-04, 0.4162D-03, 0.9059D-03,
     ,   0.1548D-02, 0.2340D-02, 0.3248D-02, 0.4210D-02, 0.5142D-02,
     ,   0.5950D-02, 0.6549D-02, 0.6875D-02, 0.6889D-02, 0.6578D-02,
     ,   0.5959D-02, 0.5079D-02, 0.4019D-02, 0.2887D-02, 0.1804D-02,
     ,   0.8698D-03, 0.1308D-03,-0.4345D-03,-0.8875D-03,-0.1282D-02,
     ,  -0.1636D-02,-0.1933D-02,-0.2146D-02,-0.2252D-02,-0.2237D-02,
     ,  -0.2102D-02,-0.1854D-02,-0.1502D-02,-0.1060D-02,-0.5386D-03,
     ,   0.4943D-04, 0.6937D-03, 0.1385D-02, 0.2115D-02, 0.2876D-02,
     ,   0.3664D-02, 0.4472D-02, 0.5297D-02/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.8808D-04,-0.8998D-04,-0.8011D-04,-0.6102D-04,-0.3491D-04,
     ,  -0.3734D-05, 0.3076D-04, 0.6698D-04, 0.1034D-03, 0.1387D-03,
     ,   0.1715D-03, 0.2005D-03, 0.2244D-03, 0.2422D-03, 0.2527D-03,
     ,   0.2550D-03, 0.2483D-03, 0.2319D-03, 0.2056D-03, 0.1695D-03,
     ,   0.1240D-03, 0.7042D-04, 0.1041D-04,-0.5340D-04,-0.1175D-03,
     ,  -0.1773D-03,-0.2273D-03,-0.2604D-03,-0.2684D-03,-0.2416D-03,
     ,  -0.1682D-03,-0.3429D-04, 0.1767D-03, 0.4832D-03, 0.9032D-03,
     ,   0.1449D-02, 0.2118D-02, 0.2887D-02, 0.3707D-02, 0.4511D-02,
     ,   0.5227D-02, 0.5785D-02, 0.6133D-02, 0.6236D-02, 0.6078D-02,
     ,   0.5663D-02, 0.5015D-02, 0.4182D-02, 0.3233D-02, 0.2262D-02,
     ,   0.1363D-02, 0.6120D-03, 0.3452D-04,-0.3979D-03,-0.7419D-03,
     ,  -0.1043D-02,-0.1314D-02,-0.1542D-02,-0.1703D-02,-0.1779D-02,
     ,  -0.1762D-02,-0.1651D-02,-0.1452D-02,-0.1174D-02,-0.8263D-03,
     ,  -0.4191D-03, 0.3882D-04, 0.5392D-03, 0.1075D-02, 0.1639D-02,
     ,   0.2228D-02, 0.2835D-02, 0.3459D-02/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.5766D-04,-0.5973D-04,-0.5387D-04,-0.4183D-04,-0.2513D-04,
     ,  -0.5089D-05, 0.1708D-04, 0.4028D-04, 0.6349D-04, 0.8576D-04,
     ,   0.1062D-03, 0.1238D-03, 0.1380D-03, 0.1477D-03, 0.1525D-03,
     ,   0.1516D-03, 0.1445D-03, 0.1309D-03, 0.1108D-03, 0.8428D-04,
     ,   0.5189D-04, 0.1458D-04,-0.2617D-04,-0.6827D-04,-0.1090D-03,
     ,  -0.1447D-03,-0.1711D-03,-0.1828D-03,-0.1733D-03,-0.1350D-03,
     ,  -0.5861D-04, 0.6700D-04, 0.2551D-03, 0.5206D-03, 0.8783D-03,
     ,   0.1338D-02, 0.1900D-02, 0.2545D-02, 0.3237D-02, 0.3922D-02,
     ,   0.4544D-02, 0.5048D-02, 0.5391D-02, 0.5545D-02, 0.5493D-02,
     ,   0.5233D-02, 0.4776D-02, 0.4149D-02, 0.3393D-02, 0.2570D-02,
     ,   0.1753D-02, 0.1020D-02, 0.4232D-03,-0.2333D-04,-0.3511D-03,
     ,  -0.6104D-03,-0.8389D-03,-0.1046D-02,-0.1219D-02,-0.1340D-02,
     ,  -0.1395D-02,-0.1377D-02,-0.1287D-02,-0.1129D-02,-0.9108D-03,
     ,  -0.6399D-03,-0.3237D-03, 0.3073D-04, 0.4171D-03, 0.8300D-03,
     ,   0.1265D-02, 0.1717D-02, 0.2183D-02/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.3751D-04,-0.3946D-04,-0.3608D-04,-0.2856D-04,-0.1793D-04,
     ,  -0.5120D-05, 0.9054D-05, 0.2384D-04, 0.3854D-04, 0.5249D-04,
     ,   0.6508D-04, 0.7573D-04, 0.8387D-04, 0.8900D-04, 0.9066D-04,
     ,   0.8847D-04, 0.8213D-04, 0.7150D-04, 0.5659D-04, 0.3762D-04,
     ,   0.1508D-04,-0.1019D-04,-0.3699D-04,-0.6364D-04,-0.8797D-04,
     ,  -0.1072D-03,-0.1178D-03,-0.1157D-03,-0.9581D-04,-0.5205D-04,
     ,   0.2288D-04, 0.1378D-03, 0.3034D-03, 0.5315D-03, 0.8342D-03,
     ,   0.1220D-02, 0.1688D-02, 0.2225D-02, 0.2803D-02, 0.3380D-02,
     ,   0.3912D-02, 0.4356D-02, 0.4678D-02, 0.4854D-02, 0.4871D-02,
     ,   0.4723D-02, 0.4415D-02, 0.3961D-02, 0.3383D-02, 0.2720D-02,
     ,   0.2021D-02, 0.1347D-02, 0.7558D-03, 0.2874D-03,-0.5486D-04,
     ,  -0.3014D-03,-0.4956D-03,-0.6680D-03,-0.8252D-03,-0.9567D-03,
     ,  -0.1047D-02,-0.1086D-02,-0.1069D-02,-0.9967D-03,-0.8726D-03,
     ,  -0.7026D-03,-0.4926D-03,-0.2485D-03, 0.2443D-04, 0.3213D-03,
     ,   0.6379D-03, 0.9706D-03, 0.1317D-02/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.2421D-04,-0.2592D-04,-0.2404D-04,-0.1939D-04,-0.1267D-04,
     ,  -0.4524D-05, 0.4494D-05, 0.1387D-04, 0.2312D-04, 0.3181D-04,
     ,   0.3952D-04, 0.4585D-04, 0.5043D-04, 0.5295D-04, 0.5310D-04,
     ,   0.5066D-04, 0.4547D-04, 0.3749D-04, 0.2679D-04, 0.1361D-04,
     ,  -0.1596D-05,-0.1813D-04,-0.3499D-04,-0.5085D-04,-0.6395D-04,
     ,  -0.7210D-04,-0.7258D-04,-0.6209D-04,-0.3667D-04, 0.8459D-05,
     ,   0.7909D-04, 0.1822D-03, 0.3263D-03, 0.5209D-03, 0.7754D-03,
     ,   0.1097D-02, 0.1484D-02, 0.1929D-02, 0.2407D-02, 0.2888D-02,
     ,   0.3337D-02, 0.3720D-02, 0.4012D-02, 0.4192D-02, 0.4250D-02,
     ,   0.4179D-02, 0.3981D-02, 0.3663D-02, 0.3237D-02, 0.2725D-02,
     ,   0.2157D-02, 0.1575D-02, 0.1026D-02, 0.5557D-03, 0.1912D-03,
     ,  -0.6905D-04,-0.2532D-03,-0.3978D-03,-0.5273D-03,-0.6462D-03,
     ,  -0.7455D-03,-0.8132D-03,-0.8409D-03,-0.8255D-03,-0.7677D-03,
     ,  -0.6707D-03,-0.5390D-03,-0.3771D-03,-0.1896D-03, 0.1943D-04,
     ,   0.2464D-03, 0.4881D-03, 0.7418D-03/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.1548D-04,-0.1691D-04,-0.1592D-04,-0.1307D-04,-0.8858D-05,
     ,  -0.3702D-05, 0.2010D-05, 0.7926D-05, 0.1372D-04, 0.1910D-04,
     ,   0.2378D-04, 0.2750D-04, 0.3002D-04, 0.3113D-04, 0.3065D-04,
     ,   0.2845D-04, 0.2447D-04, 0.1872D-04, 0.1130D-04, 0.2462D-05,
     ,  -0.7406D-05,-0.1771D-04,-0.2764D-04,-0.3610D-04,-0.4171D-04,
     ,  -0.4271D-04,-0.3697D-04,-0.2188D-04, 0.5698D-05, 0.4954D-04,
     ,   0.1142D-03, 0.2053D-03, 0.3294D-03, 0.4941D-03, 0.7067D-03,
     ,   0.9728D-03, 0.1292D-02, 0.1657D-02, 0.2050D-02, 0.2447D-02,
     ,   0.2822D-02, 0.3148D-02, 0.3405D-02, 0.3577D-02, 0.3656D-02,
     ,   0.3636D-02, 0.3516D-02, 0.3301D-02, 0.2996D-02, 0.2614D-02,
     ,   0.2172D-02, 0.1696D-02, 0.1218D-02, 0.7767D-03, 0.4056D-03,
     ,   0.1242D-03,-0.7234D-04,-0.2090D-03,-0.3162D-03,-0.4131D-03,
     ,  -0.5026D-03,-0.5773D-03,-0.6276D-03,-0.6473D-03,-0.6339D-03,
     ,  -0.5882D-03,-0.5130D-03,-0.4115D-03,-0.2873D-03,-0.1440D-03,
     ,   0.1544D-04, 0.1882D-03, 0.3719D-03/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.9785D-05,-0.1094D-04,-0.1046D-04,-0.8743D-05,-0.6113D-05,
     ,  -0.2866D-05, 0.7362D-06, 0.4455D-05, 0.8073D-05, 0.1139D-04,
     ,   0.1421D-04, 0.1637D-04, 0.1772D-04, 0.1812D-04, 0.1748D-04,
     ,   0.1572D-04, 0.1283D-04, 0.8862D-05, 0.3929D-05,-0.1742D-05,
     ,  -0.7805D-05,-0.1377D-04,-0.1896D-04,-0.2250D-04,-0.2329D-04,
     ,  -0.1992D-04,-0.1070D-04, 0.6433D-05, 0.3396D-04, 0.7487D-04,
     ,   0.1328D-03, 0.2121D-03, 0.3180D-03, 0.4564D-03, 0.6331D-03,
     ,   0.8522D-03, 0.1114D-02, 0.1412D-02, 0.1733D-02, 0.2058D-02,
     ,   0.2367D-02, 0.2641D-02, 0.2862D-02, 0.3020D-02, 0.3106D-02,
     ,   0.3117D-02, 0.3052D-02, 0.2911D-02, 0.2699D-02, 0.2421D-02,
     ,   0.2089D-02, 0.1716D-02, 0.1323D-02, 0.9357D-03, 0.5842D-03,
     ,   0.2941D-03, 0.7827D-04,-0.6920D-04,-0.1701D-03,-0.2492D-03,
     ,  -0.3214D-03,-0.3885D-03,-0.4445D-03,-0.4818D-03,-0.4957D-03,
     ,  -0.4844D-03,-0.4486D-03,-0.3905D-03,-0.3127D-03,-0.2179D-03,
     ,  -0.1088D-03, 0.1223D-04, 0.1432D-03/
      data (calcpts(j,45), j = 1,neta) /
     ,  -0.6091D-05,-0.6996D-05,-0.6807D-05,-0.5785D-05,-0.4156D-05,
     ,  -0.2120D-05, 0.1446D-06, 0.2476D-05, 0.4727D-05, 0.6764D-05,
     ,   0.8463D-05, 0.9715D-05, 0.1042D-04, 0.1051D-04, 0.9921D-05,
     ,   0.8630D-05, 0.6650D-05, 0.4044D-05, 0.9346D-06,-0.2476D-05,
     ,  -0.5891D-05,-0.8902D-05,-0.1096D-04,-0.1136D-04,-0.9198D-05,
     ,  -0.3378D-05, 0.7457D-05, 0.2494D-04, 0.5104D-04, 0.8812D-04,
     ,   0.1390D-03, 0.2072D-03, 0.2968D-03, 0.4123D-03, 0.5583D-03,
     ,   0.7377D-03, 0.9508D-03, 0.1193D-02, 0.1453D-02, 0.1718D-02,
     ,   0.1971D-02, 0.2197D-02, 0.2385D-02, 0.2525D-02, 0.2610D-02,
     ,   0.2639D-02, 0.2609D-02, 0.2521D-02, 0.2377D-02, 0.2180D-02,
     ,   0.1936D-02, 0.1654D-02, 0.1344D-02, 0.1024D-02, 0.7143D-03,
     ,   0.4371D-03, 0.2119D-03, 0.4743D-04,-0.6266D-04,-0.1368D-03,
     ,  -0.1949D-03,-0.2485D-03,-0.2987D-03,-0.3405D-03,-0.3681D-03,
     ,  -0.3778D-03,-0.3685D-03,-0.3406D-03,-0.2960D-03,-0.2367D-03,
     ,  -0.1646D-03,-0.8194D-04, 0.9654D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,  -0.3716D-05,-0.4414D-05,-0.4375D-05,-0.3777D-05,-0.2774D-05,
     ,  -0.1501D-05,-0.8103D-07, 0.1379D-05, 0.2780D-05, 0.4033D-05,
     ,   0.5059D-05, 0.5788D-05, 0.6162D-05, 0.6138D-05, 0.5689D-05,
     ,   0.4816D-05, 0.3548D-05, 0.1951D-05, 0.1434D-06,-0.1699D-05,
     ,  -0.3325D-05,-0.4394D-05,-0.4461D-05,-0.2953D-05, 0.8459D-06,
     ,   0.7820D-05, 0.1904D-04, 0.3582D-04, 0.5970D-04, 0.9256D-04,
     ,   0.1366D-03, 0.1947D-03, 0.2698D-03, 0.3656D-03, 0.4854D-03,
     ,   0.6317D-03, 0.8043D-03, 0.9995D-03, 0.1209D-02, 0.1423D-02,
     ,   0.1629D-02, 0.1815D-02, 0.1972D-02, 0.2092D-02, 0.2173D-02,
     ,   0.2209D-02, 0.2202D-02, 0.2150D-02, 0.2055D-02, 0.1918D-02,
     ,   0.1743D-02, 0.1534D-02, 0.1299D-02, 0.1046D-02, 0.7884D-03,
     ,   0.5424D-03, 0.3254D-03, 0.1517D-03, 0.2713D-04,-0.5465D-04,
     ,  -0.1089D-03,-0.1514D-03,-0.1910D-03,-0.2285D-03,-0.2596D-03,
     ,  -0.2800D-03,-0.2868D-03,-0.2791D-03,-0.2576D-03,-0.2235D-03,
     ,  -0.1784D-03,-0.1239D-03,-0.6145D-04/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.2204D-05,-0.2734D-05,-0.2767D-05,-0.2423D-05,-0.1809D-05,
     ,  -0.1015D-05,-0.1246D-06, 0.7910D-06, 0.1666D-05, 0.2443D-05,
     ,   0.3070D-05, 0.3505D-05, 0.3715D-05, 0.3677D-05, 0.3386D-05,
     ,   0.2853D-05, 0.2115D-05, 0.1239D-05, 0.3300D-06,-0.4596D-06,
     ,  -0.9194D-06,-0.7692D-06, 0.3539D-06, 0.2910D-05, 0.7475D-05,
     ,   0.1475D-04, 0.2560D-04, 0.4105D-04, 0.6233D-04, 0.9092D-04,
     ,   0.1286D-03, 0.1775D-03, 0.2400D-03, 0.3189D-03, 0.4168D-03,
     ,   0.5355D-03, 0.6746D-03, 0.8314D-03, 0.9998D-03, 0.1171D-02,
     ,   0.1337D-02, 0.1488D-02, 0.1618D-02, 0.1720D-02, 0.1792D-02,
     ,   0.1832D-02, 0.1837D-02, 0.1810D-02, 0.1748D-02, 0.1655D-02,
     ,   0.1532D-02, 0.1381D-02, 0.1206D-02, 0.1013D-02, 0.8086D-03,
     ,   0.6034D-03, 0.4099D-03, 0.2412D-03, 0.1081D-03, 0.1411D-04,
     ,  -0.4637D-04,-0.8586D-04,-0.1168D-03,-0.1461D-03,-0.1740D-03,
     ,  -0.1971D-03,-0.2121D-03,-0.2168D-03,-0.2107D-03,-0.1941D-03,
     ,  -0.1682D-03,-0.1340D-03,-0.9291D-04/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.1255D-05,-0.1651D-05,-0.1712D-05,-0.1519D-05,-0.1144D-05,
     ,  -0.6492D-06,-0.8892D-07, 0.4882D-06, 0.1040D-05, 0.1528D-05,
     ,   0.1921D-05, 0.2194D-05, 0.2330D-05, 0.2321D-05, 0.2169D-05,
     ,   0.1894D-05, 0.1535D-05, 0.1153D-05, 0.8416D-06, 0.7295D-06,
     ,   0.9920D-06, 0.1858D-05, 0.3622D-05, 0.6655D-05, 0.1142D-04,
     ,   0.1847D-04, 0.2849D-04, 0.4230D-04, 0.6088D-04, 0.8539D-04,
     ,   0.1172D-03, 0.1580D-03, 0.2097D-03, 0.2744D-03, 0.3539D-03,
     ,   0.4496D-03, 0.5613D-03, 0.6866D-03, 0.8210D-03, 0.9580D-03,
     ,   0.1091D-02, 0.1213D-02, 0.1319D-02, 0.1404D-02, 0.1467D-02,
     ,   0.1505D-02, 0.1518D-02, 0.1506D-02, 0.1468D-02, 0.1406D-02,
     ,   0.1320D-02, 0.1213D-02, 0.1085D-02, 0.9413D-03, 0.7848D-03,
     ,   0.6216D-03, 0.4596D-03, 0.3084D-03, 0.1781D-03, 0.7654D-04,
     ,   0.6018D-05,-0.3854D-04,-0.6719D-04,-0.8971D-04,-0.1113D-03,
     ,  -0.1319D-03,-0.1490D-03,-0.1600D-03,-0.1633D-03,-0.1584D-03,
     ,  -0.1458D-03,-0.1261D-03,-0.1004D-03/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.6692D-06,-0.9621D-06,-0.1028D-05,-0.9222D-06,-0.6934D-06,
     ,  -0.3834D-06,-0.2866D-07, 0.3389D-06, 0.6916D-06, 0.1006D-05,
     ,   0.1263D-05, 0.1449D-05, 0.1556D-05, 0.1583D-05, 0.1541D-05,
     ,   0.1451D-05, 0.1349D-05, 0.1292D-05, 0.1358D-05, 0.1657D-05,
     ,   0.2333D-05, 0.3573D-05, 0.5613D-05, 0.8751D-05, 0.1336D-04,
     ,   0.1987D-04, 0.2884D-04, 0.4092D-04, 0.5687D-04, 0.7761D-04,
     ,   0.1042D-03, 0.1380D-03, 0.1805D-03, 0.2331D-03, 0.2974D-03,
     ,   0.3742D-03, 0.4635D-03, 0.5632D-03, 0.6699D-03, 0.7787D-03,
     ,   0.8845D-03, 0.9822D-03, 0.1068D-02, 0.1138D-02, 0.1192D-02,
     ,   0.1227D-02, 0.1243D-02, 0.1240D-02, 0.1219D-02, 0.1178D-02,
     ,   0.1119D-02, 0.1044D-02, 0.9525D-03, 0.8471D-03, 0.7300D-03,
     ,   0.6046D-03, 0.4754D-03, 0.3484D-03, 0.2311D-03, 0.1310D-03,
     ,   0.5393D-04, 0.1206D-05,-0.3150D-04,-0.5221D-04,-0.6853D-04,
     ,  -0.8434D-04,-0.9961D-04,-0.1123D-03,-0.1203D-03,-0.1226D-03,
     ,  -0.1187D-03,-0.1091D-03,-0.9427D-04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0,
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0,
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0,
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0,
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

c      coeff=coeff/sqrt(1+eta/1.)

      return
      end
!-------------------------------    
      subroutine c2hqg20b(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.6082D-01,-0.5661D-01,-0.4537D-01,-0.2839D-01,-0.6776D-02,
     ,   0.1849D-01, 0.4655D-01, 0.7663D-01, 0.1080D+00, 0.1400D+00,
     ,   0.1719D+00, 0.2031D+00, 0.2330D+00, 0.2610D+00, 0.2864D+00,
     ,   0.3085D+00, 0.3269D+00, 0.3409D+00, 0.3501D+00, 0.3541D+00,
     ,   0.3525D+00, 0.3452D+00, 0.3322D+00, 0.3136D+00, 0.2900D+00,
     ,   0.2618D+00, 0.2300D+00, 0.1954D+00, 0.1589D+00, 0.1212D+00,
     ,   0.8257D-01, 0.4263D-01, 0.2918D-03,-0.4625D-01,-0.9902D-01,
     ,  -0.1594D+00,-0.2270D+00,-0.2988D+00,-0.3697D+00,-0.4336D+00,
     ,  -0.4858D+00,-0.5238D+00,-0.5479D+00,-0.5600D+00,-0.5637D+00,
     ,  -0.5627D+00,-0.5605D+00,-0.5601D+00,-0.5631D+00,-0.5706D+00,
     ,  -0.5827D+00,-0.5991D+00,-0.6194D+00,-0.6429D+00,-0.6689D+00,
     ,  -0.6969D+00,-0.7266D+00,-0.7574D+00,-0.7891D+00,-0.8215D+00,
     ,  -0.8544D+00,-0.8877D+00,-0.9212D+00,-0.9550D+00,-0.9889D+00,
     ,  -0.1023D+01,-0.1057D+01,-0.1091D+01,-0.1125D+01,-0.1160D+01,
     ,  -0.1194D+01,-0.1228D+01,-0.1263D+01/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.6081D-01,-0.5660D-01,-0.4536D-01,-0.2838D-01,-0.6775D-02,
     ,   0.1849D-01, 0.4655D-01, 0.7662D-01, 0.1080D+00, 0.1400D+00,
     ,   0.1719D+00, 0.2031D+00, 0.2330D+00, 0.2610D+00, 0.2863D+00,
     ,   0.3085D+00, 0.3269D+00, 0.3409D+00, 0.3501D+00, 0.3541D+00,
     ,   0.3525D+00, 0.3452D+00, 0.3322D+00, 0.3138D+00, 0.2902D+00,
     ,   0.2624D+00, 0.2310D+00, 0.1971D+00, 0.1619D+00, 0.1263D+00,
     ,   0.9131D-01, 0.5735D-01, 0.2452D-01,-0.7501D-02,-0.3923D-01,
     ,  -0.7103D-01,-0.1025D+00,-0.1321D+00,-0.1573D+00,-0.1750D+00,
     ,  -0.1833D+00,-0.1812D+00,-0.1695D+00,-0.1502D+00,-0.1259D+00,
     ,  -0.9941D-01,-0.7339D-01,-0.4984D-01,-0.3003D-01,-0.1451D-01,
     ,  -0.3286D-02, 0.4010D-02, 0.7912D-02, 0.9005D-02, 0.7849D-02,
     ,   0.4930D-02, 0.6523D-03,-0.4658D-02,-0.1075D-01,-0.1742D-01,
     ,  -0.2453D-01,-0.3196D-01,-0.3963D-01,-0.4748D-01,-0.5545D-01,
     ,  -0.6353D-01,-0.7167D-01,-0.7987D-01,-0.8811D-01,-0.9637D-01,
     ,  -0.1047D+00,-0.1130D+00,-0.1213D+00/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.6080D-01,-0.5659D-01,-0.4535D-01,-0.2838D-01,-0.6774D-02,
     ,   0.1848D-01, 0.4654D-01, 0.7661D-01, 0.1080D+00, 0.1399D+00,
     ,   0.1719D+00, 0.2031D+00, 0.2330D+00, 0.2609D+00, 0.2863D+00,
     ,   0.3084D+00, 0.3268D+00, 0.3408D+00, 0.3501D+00, 0.3540D+00,
     ,   0.3524D+00, 0.3452D+00, 0.3322D+00, 0.3138D+00, 0.2904D+00,
     ,   0.2626D+00, 0.2314D+00, 0.1979D+00, 0.1634D+00, 0.1289D+00,
     ,   0.9581D-01, 0.6493D-01, 0.3700D-01, 0.1245D-01,-0.8512D-02,
     ,  -0.2574D-01,-0.3895D-01,-0.4739D-01,-0.4989D-01,-0.4520D-01,
     ,  -0.3257D-01,-0.1209D-01, 0.1527D-01, 0.4781D-01, 0.8343D-01,
     ,   0.1200D+00, 0.1554D+00, 0.1884D+00, 0.2179D+00, 0.2437D+00,
     ,   0.2658D+00, 0.2846D+00, 0.3005D+00, 0.3141D+00, 0.3258D+00,
     ,   0.3360D+00, 0.3451D+00, 0.3534D+00, 0.3610D+00, 0.3682D+00,
     ,   0.3750D+00, 0.3815D+00, 0.3878D+00, 0.3940D+00, 0.4001D+00,
     ,   0.4061D+00, 0.4120D+00, 0.4179D+00, 0.4238D+00, 0.4296D+00,
     ,   0.4354D+00, 0.4412D+00, 0.4470D+00/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.6078D-01,-0.5658D-01,-0.4534D-01,-0.2837D-01,-0.6773D-02,
     ,   0.1848D-01, 0.4653D-01, 0.7659D-01, 0.1079D+00, 0.1399D+00,
     ,   0.1718D+00, 0.2030D+00, 0.2329D+00, 0.2609D+00, 0.2862D+00,
     ,   0.3084D+00, 0.3267D+00, 0.3408D+00, 0.3500D+00, 0.3539D+00,
     ,   0.3524D+00, 0.3451D+00, 0.3322D+00, 0.3138D+00, 0.2904D+00,
     ,   0.2627D+00, 0.2316D+00, 0.1983D+00, 0.1641D+00, 0.1303D+00,
     ,   0.9810D-01, 0.6879D-01, 0.4335D-01, 0.2255D-01, 0.6978D-02,
     ,  -0.3052D-02,-0.7355D-02,-0.5711D-02, 0.2236D-02, 0.1682D-01,
     ,   0.3803D-01, 0.6537D-01, 0.9779D-01, 0.1338D+00, 0.1719D+00,
     ,   0.2102D+00, 0.2474D+00, 0.2825D+00, 0.3146D+00, 0.3438D+00,
     ,   0.3699D+00, 0.3935D+00, 0.4147D+00, 0.4342D+00, 0.4521D+00,
     ,   0.4689D+00, 0.4848D+00, 0.5001D+00, 0.5148D+00, 0.5292D+00,
     ,   0.5432D+00, 0.5571D+00, 0.5708D+00, 0.5845D+00, 0.5980D+00,
     ,   0.6115D+00, 0.6249D+00, 0.6383D+00, 0.6516D+00, 0.6650D+00,
     ,   0.6783D+00, 0.6916D+00, 0.7049D+00/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.6076D-01,-0.5656D-01,-0.4533D-01,-0.2836D-01,-0.6770D-02,
     ,   0.1847D-01, 0.4651D-01, 0.7656D-01, 0.1079D+00, 0.1398D+00,
     ,   0.1717D+00, 0.2030D+00, 0.2328D+00, 0.2608D+00, 0.2861D+00,
     ,   0.3082D+00, 0.3266D+00, 0.3406D+00, 0.3498D+00, 0.3538D+00,
     ,   0.3522D+00, 0.3450D+00, 0.3320D+00, 0.3137D+00, 0.2903D+00,
     ,   0.2626D+00, 0.2317D+00, 0.1985D+00, 0.1644D+00, 0.1309D+00,
     ,   0.9923D-01, 0.7072D-01, 0.4652D-01, 0.2758D-01, 0.1460D-01,
     ,   0.7962D-02, 0.7701D-02, 0.1369D-01, 0.2577D-01, 0.4373D-01,
     ,   0.6719D-01, 0.9542D-01, 0.1274D+00, 0.1620D+00, 0.1979D+00,
     ,   0.2339D+00, 0.2689D+00, 0.3022D+00, 0.3333D+00, 0.3621D+00,
     ,   0.3888D+00, 0.4135D+00, 0.4366D+00, 0.4583D+00, 0.4789D+00,
     ,   0.4986D+00, 0.5177D+00, 0.5364D+00, 0.5546D+00, 0.5726D+00,
     ,   0.5904D+00, 0.6080D+00, 0.6256D+00, 0.6430D+00, 0.6604D+00,
     ,   0.6777D+00, 0.6950D+00, 0.7123D+00, 0.7295D+00, 0.7468D+00,
     ,   0.7640D+00, 0.7813D+00, 0.7985D+00/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.6073D-01,-0.5653D-01,-0.4530D-01,-0.2834D-01,-0.6766D-02,
     ,   0.1846D-01, 0.4648D-01, 0.7652D-01, 0.1078D+00, 0.1398D+00,
     ,   0.1717D+00, 0.2028D+00, 0.2327D+00, 0.2606D+00, 0.2859D+00,
     ,   0.3081D+00, 0.3264D+00, 0.3404D+00, 0.3497D+00, 0.3536D+00,
     ,   0.3521D+00, 0.3448D+00, 0.3319D+00, 0.3135D+00, 0.2902D+00,
     ,   0.2625D+00, 0.2316D+00, 0.1985D+00, 0.1645D+00, 0.1312D+00,
     ,   0.9977D-01, 0.7166D-01, 0.4807D-01, 0.3000D-01, 0.1821D-01,
     ,   0.1303D-01, 0.1435D-01, 0.2176D-01, 0.3479D-01, 0.5288D-01,
     ,   0.7542D-01, 0.1016D+00, 0.1305D+00, 0.1613D+00, 0.1928D+00,
     ,   0.2244D+00, 0.2553D+00, 0.2851D+00, 0.3134D+00, 0.3402D+00,
     ,   0.3655D+00, 0.3896D+00, 0.4126D+00, 0.4347D+00, 0.4560D+00,
     ,   0.4769D+00, 0.4973D+00, 0.5174D+00, 0.5373D+00, 0.5570D+00,
     ,   0.5765D+00, 0.5960D+00, 0.6154D+00, 0.6347D+00, 0.6540D+00,
     ,   0.6733D+00, 0.6925D+00, 0.7118D+00, 0.7310D+00, 0.7502D+00,
     ,   0.7694D+00, 0.7886D+00, 0.8078D+00/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.6068D-01,-0.5648D-01,-0.4527D-01,-0.2832D-01,-0.6761D-02,
     ,   0.1845D-01, 0.4645D-01, 0.7646D-01, 0.1078D+00, 0.1397D+00,
     ,   0.1715D+00, 0.2027D+00, 0.2325D+00, 0.2604D+00, 0.2857D+00,
     ,   0.3078D+00, 0.3262D+00, 0.3402D+00, 0.3494D+00, 0.3533D+00,
     ,   0.3518D+00, 0.3445D+00, 0.3316D+00, 0.3133D+00, 0.2899D+00,
     ,   0.2623D+00, 0.2314D+00, 0.1984D+00, 0.1645D+00, 0.1312D+00,
     ,   0.9998D-01, 0.7208D-01, 0.4878D-01, 0.3112D-01, 0.1980D-01,
     ,   0.1511D-01, 0.1679D-01, 0.2422D-01, 0.3664D-01, 0.5332D-01,
     ,   0.7347D-01, 0.9629D-01, 0.1210D+00, 0.1469D+00, 0.1732D+00,
     ,   0.1997D+00, 0.2257D+00, 0.2512D+00, 0.2759D+00, 0.2998D+00,
     ,   0.3230D+00, 0.3456D+00, 0.3676D+00, 0.3892D+00, 0.4104D+00,
     ,   0.4314D+00, 0.4522D+00, 0.4728D+00, 0.4932D+00, 0.5136D+00,
     ,   0.5340D+00, 0.5543D+00, 0.5745D+00, 0.5947D+00, 0.6149D+00,
     ,   0.6351D+00, 0.6553D+00, 0.6755D+00, 0.6957D+00, 0.7158D+00,
     ,   0.7360D+00, 0.7561D+00, 0.7763D+00/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.6061D-01,-0.5642D-01,-0.4521D-01,-0.2829D-01,-0.6753D-02,
     ,   0.1843D-01, 0.4639D-01, 0.7637D-01, 0.1076D+00, 0.1395D+00,
     ,   0.1713D+00, 0.2024D+00, 0.2322D+00, 0.2601D+00, 0.2854D+00,
     ,   0.3075D+00, 0.3258D+00, 0.3398D+00, 0.3490D+00, 0.3529D+00,
     ,   0.3514D+00, 0.3441D+00, 0.3312D+00, 0.3129D+00, 0.2896D+00,
     ,   0.2620D+00, 0.2312D+00, 0.1982D+00, 0.1644D+00, 0.1312D+00,
     ,   0.1000D+00, 0.7223D-01, 0.4907D-01, 0.3156D-01, 0.2039D-01,
     ,   0.1573D-01, 0.1718D-01, 0.2396D-01, 0.3510D-01, 0.4969D-01,
     ,   0.6688D-01, 0.8586D-01, 0.1060D+00, 0.1267D+00, 0.1477D+00,
     ,   0.1688D+00, 0.1899D+00, 0.2109D+00, 0.2318D+00, 0.2526D+00,
     ,   0.2734D+00, 0.2941D+00, 0.3148D+00, 0.3355D+00, 0.3561D+00,
     ,   0.3767D+00, 0.3974D+00, 0.4180D+00, 0.4386D+00, 0.4592D+00,
     ,   0.4798D+00, 0.5004D+00, 0.5210D+00, 0.5416D+00, 0.5622D+00,
     ,   0.5828D+00, 0.6034D+00, 0.6240D+00, 0.6446D+00, 0.6652D+00,
     ,   0.6858D+00, 0.7064D+00, 0.7270D+00/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.6051D-01,-0.5632D-01,-0.4514D-01,-0.2824D-01,-0.6742D-02,
     ,   0.1839D-01, 0.4631D-01, 0.7623D-01, 0.1074D+00, 0.1393D+00,
     ,   0.1710D+00, 0.2021D+00, 0.2319D+00, 0.2597D+00, 0.2849D+00,
     ,   0.3069D+00, 0.3252D+00, 0.3392D+00, 0.3484D+00, 0.3523D+00,
     ,   0.3508D+00, 0.3435D+00, 0.3307D+00, 0.3124D+00, 0.2891D+00,
     ,   0.2616D+00, 0.2308D+00, 0.1979D+00, 0.1641D+00, 0.1310D+00,
     ,   0.9990D-01, 0.7221D-01, 0.4913D-01, 0.3167D-01, 0.2047D-01,
     ,   0.1563D-01, 0.1661D-01, 0.2246D-01, 0.3207D-01, 0.4438D-01,
     ,   0.5847D-01, 0.7359D-01, 0.8917D-01, 0.1049D+00, 0.1207D+00,
     ,   0.1367D+00, 0.1529D+00, 0.1695D+00, 0.1867D+00, 0.2045D+00,
     ,   0.2228D+00, 0.2416D+00, 0.2609D+00, 0.2805D+00, 0.3004D+00,
     ,   0.3205D+00, 0.3407D+00, 0.3612D+00, 0.3817D+00, 0.4022D+00,
     ,   0.4229D+00, 0.4435D+00, 0.4643D+00, 0.4850D+00, 0.5057D+00,
     ,   0.5265D+00, 0.5472D+00, 0.5680D+00, 0.5888D+00, 0.6096D+00,
     ,   0.6304D+00, 0.6511D+00, 0.6719D+00/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.6036D-01,-0.5618D-01,-0.4502D-01,-0.2817D-01,-0.6725D-02,
     ,   0.1835D-01, 0.4620D-01, 0.7604D-01, 0.1072D+00, 0.1389D+00,
     ,   0.1706D+00, 0.2016D+00, 0.2313D+00, 0.2590D+00, 0.2842D+00,
     ,   0.3062D+00, 0.3244D+00, 0.3383D+00, 0.3475D+00, 0.3514D+00,
     ,   0.3499D+00, 0.3427D+00, 0.3298D+00, 0.3116D+00, 0.2884D+00,
     ,   0.2609D+00, 0.2302D+00, 0.1974D+00, 0.1637D+00, 0.1307D+00,
     ,   0.9967D-01, 0.7205D-01, 0.4904D-01, 0.3159D-01, 0.2030D-01,
     ,   0.1519D-01, 0.1561D-01, 0.2047D-01, 0.2850D-01, 0.3855D-01,
     ,   0.4966D-01, 0.6109D-01, 0.7240D-01, 0.8346D-01, 0.9440D-01,
     ,   0.1055D+00, 0.1173D+00, 0.1299D+00, 0.1436D+00, 0.1585D+00,
     ,   0.1744D+00, 0.1914D+00, 0.2093D+00, 0.2278D+00, 0.2469D+00,
     ,   0.2664D+00, 0.2863D+00, 0.3064D+00, 0.3267D+00, 0.3471D+00,
     ,   0.3677D+00, 0.3883D+00, 0.4090D+00, 0.4297D+00, 0.4505D+00,
     ,   0.4713D+00, 0.4921D+00, 0.5129D+00, 0.5337D+00, 0.5546D+00,
     ,   0.5754D+00, 0.5963D+00, 0.6171D+00/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.6013D-01,-0.5597D-01,-0.4486D-01,-0.2807D-01,-0.6701D-02,
     ,   0.1828D-01, 0.4603D-01, 0.7576D-01, 0.1068D+00, 0.1384D+00,
     ,   0.1700D+00, 0.2009D+00, 0.2304D+00, 0.2581D+00, 0.2831D+00,
     ,   0.3050D+00, 0.3232D+00, 0.3371D+00, 0.3462D+00, 0.3501D+00,
     ,   0.3486D+00, 0.3414D+00, 0.3286D+00, 0.3104D+00, 0.2873D+00,
     ,   0.2600D+00, 0.2293D+00, 0.1966D+00, 0.1631D+00, 0.1302D+00,
     ,   0.9929D-01, 0.7178D-01, 0.4883D-01, 0.3139D-01, 0.2000D-01,
     ,   0.1460D-01, 0.1446D-01, 0.1834D-01, 0.2486D-01, 0.3280D-01,
     ,   0.4114D-01, 0.4918D-01, 0.5658D-01, 0.6337D-01, 0.6988D-01,
     ,   0.7667D-01, 0.8430D-01, 0.9324D-01, 0.1038D+00, 0.1160D+00,
     ,   0.1298D+00, 0.1451D+00, 0.1616D+00, 0.1791D+00, 0.1975D+00,
     ,   0.2164D+00, 0.2358D+00, 0.2556D+00, 0.2757D+00, 0.2960D+00,
     ,   0.3164D+00, 0.3369D+00, 0.3576D+00, 0.3782D+00, 0.3990D+00,
     ,   0.4197D+00, 0.4405D+00, 0.4613D+00, 0.4822D+00, 0.5030D+00,
     ,   0.5238D+00, 0.5447D+00, 0.5655D+00/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.5981D-01,-0.5568D-01,-0.4462D-01,-0.2792D-01,-0.6666D-02,
     ,   0.1818D-01, 0.4578D-01, 0.7536D-01, 0.1062D+00, 0.1377D+00,
     ,   0.1691D+00, 0.1998D+00, 0.2292D+00, 0.2567D+00, 0.2816D+00,
     ,   0.3034D+00, 0.3215D+00, 0.3353D+00, 0.3443D+00, 0.3483D+00,
     ,   0.3467D+00, 0.3396D+00, 0.3268D+00, 0.3087D+00, 0.2857D+00,
     ,   0.2585D+00, 0.2281D+00, 0.1955D+00, 0.1622D+00, 0.1294D+00,
     ,   0.9873D-01, 0.7136D-01, 0.4850D-01, 0.3108D-01, 0.1961D-01,
     ,   0.1395D-01, 0.1327D-01, 0.1625D-01, 0.2140D-01, 0.2741D-01,
     ,   0.3326D-01, 0.3826D-01, 0.4216D-01, 0.4512D-01, 0.4769D-01,
     ,   0.5058D-01, 0.5456D-01, 0.6022D-01, 0.6792D-01, 0.7776D-01,
     ,   0.8967D-01, 0.1034D+00, 0.1187D+00, 0.1353D+00, 0.1529D+00,
     ,   0.1713D+00, 0.1903D+00, 0.2098D+00, 0.2296D+00, 0.2497D+00,
     ,   0.2700D+00, 0.2904D+00, 0.3110D+00, 0.3316D+00, 0.3522D+00,
     ,   0.3730D+00, 0.3937D+00, 0.4145D+00, 0.4352D+00, 0.4560D+00,
     ,   0.4768D+00, 0.4976D+00, 0.5185D+00/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.5935D-01,-0.5524D-01,-0.4427D-01,-0.2770D-01,-0.6615D-02,
     ,   0.1804D-01, 0.4542D-01, 0.7477D-01, 0.1054D+00, 0.1366D+00,
     ,   0.1677D+00, 0.1982D+00, 0.2274D+00, 0.2547D+00, 0.2794D+00,
     ,   0.3010D+00, 0.3190D+00, 0.3327D+00, 0.3417D+00, 0.3455D+00,
     ,   0.3440D+00, 0.3369D+00, 0.3243D+00, 0.3063D+00, 0.2835D+00,
     ,   0.2565D+00, 0.2263D+00, 0.1940D+00, 0.1609D+00, 0.1284D+00,
     ,   0.9790D-01, 0.7073D-01, 0.4803D-01, 0.3068D-01, 0.1915D-01,
     ,   0.1326D-01, 0.1211D-01, 0.1428D-01, 0.1822D-01, 0.2253D-01,
     ,   0.2617D-01, 0.2850D-01, 0.2932D-01, 0.2894D-01, 0.2805D-01,
     ,   0.2754D-01, 0.2832D-01, 0.3110D-01, 0.3631D-01, 0.4406D-01,
     ,   0.5426D-01, 0.6664D-01, 0.8088D-01, 0.9663D-01, 0.1136D+00,
     ,   0.1315D+00, 0.1501D+00, 0.1693D+00, 0.1889D+00, 0.2088D+00,
     ,   0.2289D+00, 0.2492D+00, 0.2696D+00, 0.2901D+00, 0.3107D+00,
     ,   0.3314D+00, 0.3520D+00, 0.3727D+00, 0.3934D+00, 0.4142D+00,
     ,   0.4349D+00, 0.4557D+00, 0.4764D+00/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.5868D-01,-0.5462D-01,-0.4377D-01,-0.2739D-01,-0.6542D-02,
     ,   0.1783D-01, 0.4491D-01, 0.7392D-01, 0.1042D+00, 0.1350D+00,
     ,   0.1658D+00, 0.1960D+00, 0.2248D+00, 0.2518D+00, 0.2762D+00,
     ,   0.2976D+00, 0.3153D+00, 0.3289D+00, 0.3378D+00, 0.3416D+00,
     ,   0.3401D+00, 0.3331D+00, 0.3206D+00, 0.3028D+00, 0.2802D+00,
     ,   0.2535D+00, 0.2237D+00, 0.1917D+00, 0.1590D+00, 0.1269D+00,
     ,   0.9671D-01, 0.6983D-01, 0.4736D-01, 0.3014D-01, 0.1861D-01,
     ,   0.1255D-01, 0.1100D-01, 0.1248D-01, 0.1536D-01, 0.1821D-01,
     ,   0.1995D-01, 0.1997D-01, 0.1816D-01, 0.1491D-01, 0.1104D-01,
     ,   0.7611D-02, 0.5644D-02, 0.5950D-02, 0.9009D-02, 0.1496D-01,
     ,   0.2368D-01, 0.3487D-01, 0.4816D-01, 0.6318D-01, 0.7956D-01,
     ,   0.9700D-01, 0.1153D+00, 0.1341D+00, 0.1535D+00, 0.1732D+00,
     ,   0.1932D+00, 0.2133D+00, 0.2336D+00, 0.2540D+00, 0.2745D+00,
     ,   0.2950D+00, 0.3156D+00, 0.3362D+00, 0.3568D+00, 0.3774D+00,
     ,   0.3981D+00, 0.4188D+00, 0.4394D+00/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.5772D-01,-0.5373D-01,-0.4306D-01,-0.2694D-01,-0.6437D-02,
     ,   0.1754D-01, 0.4417D-01, 0.7271D-01, 0.1025D+00, 0.1328D+00,
     ,   0.1631D+00, 0.1928D+00, 0.2211D+00, 0.2477D+00, 0.2717D+00,
     ,   0.2927D+00, 0.3102D+00, 0.3235D+00, 0.3322D+00, 0.3360D+00,
     ,   0.3345D+00, 0.3276D+00, 0.3153D+00, 0.2978D+00, 0.2756D+00,
     ,   0.2493D+00, 0.2199D+00, 0.1885D+00, 0.1563D+00, 0.1247D+00,
     ,   0.9500D-01, 0.6855D-01, 0.4641D-01, 0.2942D-01, 0.1796D-01,
     ,   0.1180D-01, 0.9934D-02, 0.1084D-01, 0.1284D-01, 0.1446D-01,
     ,   0.1461D-01, 0.1270D-01, 0.8670D-02, 0.3013D-02,-0.3338D-02,
     ,  -0.9217D-02,-0.1349D-01,-0.1526D-01,-0.1402D-01,-0.9596D-02,
     ,  -0.2142D-02, 0.8023D-02, 0.2049D-01, 0.3484D-01, 0.5069D-01,
     ,   0.6771D-01, 0.8562D-01, 0.1042D+00, 0.1233D+00, 0.1428D+00,
     ,   0.1626D+00, 0.1825D+00, 0.2027D+00, 0.2229D+00, 0.2433D+00,
     ,   0.2637D+00, 0.2841D+00, 0.3046D+00, 0.3251D+00, 0.3456D+00,
     ,   0.3661D+00, 0.3867D+00, 0.4072D+00/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.5637D-01,-0.5247D-01,-0.4205D-01,-0.2632D-01,-0.6290D-02,
     ,   0.1713D-01, 0.4313D-01, 0.7100D-01, 0.1001D+00, 0.1297D+00,
     ,   0.1593D+00, 0.1882D+00, 0.2159D+00, 0.2418D+00, 0.2653D+00,
     ,   0.2859D+00, 0.3029D+00, 0.3159D+00, 0.3244D+00, 0.3281D+00,
     ,   0.3266D+00, 0.3198D+00, 0.3078D+00, 0.2907D+00, 0.2690D+00,
     ,   0.2434D+00, 0.2146D+00, 0.1839D+00, 0.1524D+00, 0.1216D+00,
     ,   0.9259D-01, 0.6674D-01, 0.4509D-01, 0.2843D-01, 0.1715D-01,
     ,   0.1097D-01, 0.8882D-02, 0.9345D-02, 0.1064D-01, 0.1126D-01,
     ,   0.1012D-01, 0.6638D-02, 0.8095D-03,-0.6800D-02,-0.1517D-01,
     ,  -0.2303D-01,-0.2918D-01,-0.3266D-01,-0.3290D-01,-0.2976D-01,
     ,  -0.2337D-01,-0.1408D-01,-0.2338D-02, 0.1142D-01, 0.2678D-01,
     ,   0.4338D-01, 0.6094D-01, 0.7922D-01, 0.9805D-01, 0.1173D+00,
     ,   0.1368D+00, 0.1566D+00, 0.1765D+00, 0.1966D+00, 0.2167D+00,
     ,   0.2369D+00, 0.2572D+00, 0.2775D+00, 0.2978D+00, 0.3182D+00,
     ,   0.3385D+00, 0.3589D+00, 0.3793D+00/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.5450D-01,-0.5073D-01,-0.4066D-01,-0.2545D-01,-0.6087D-02,
     ,   0.1655D-01, 0.4169D-01, 0.6864D-01, 0.9674D-01, 0.1254D+00,
     ,   0.1540D+00, 0.1820D+00, 0.2088D+00, 0.2338D+00, 0.2565D+00,
     ,   0.2763D+00, 0.2928D+00, 0.3053D+00, 0.3136D+00, 0.3171D+00,
     ,   0.3156D+00, 0.3091D+00, 0.2975D+00, 0.2809D+00, 0.2599D+00,
     ,   0.2351D+00, 0.2073D+00, 0.1776D+00, 0.1471D+00, 0.1172D+00,
     ,   0.8922D-01, 0.6421D-01, 0.4325D-01, 0.2710D-01, 0.1610D-01,
     ,   0.9996D-02, 0.7792D-02, 0.7936D-02, 0.8699D-02, 0.8556D-02,
     ,   0.6412D-02, 0.1709D-02,-0.5516D-02,-0.1464D-01,-0.2458D-01,
     ,  -0.3399D-01,-0.4161D-01,-0.4643D-01,-0.4787D-01,-0.4576D-01,
     ,  -0.4025D-01,-0.3172D-01,-0.2062D-01,-0.7412D-02, 0.7469D-02,
     ,   0.2365D-01, 0.4084D-01, 0.5878D-01, 0.7730D-01, 0.9624D-01,
     ,   0.1155D+00, 0.1350D+00, 0.1547D+00, 0.1744D+00, 0.1943D+00,
     ,   0.2143D+00, 0.2343D+00, 0.2543D+00, 0.2744D+00, 0.2945D+00,
     ,   0.3146D+00, 0.3348D+00, 0.3549D+00/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.5196D-01,-0.4837D-01,-0.3877D-01,-0.2427D-01,-0.5812D-02,
     ,   0.1577D-01, 0.3974D-01, 0.6543D-01, 0.9222D-01, 0.1195D+00,
     ,   0.1468D+00, 0.1735D+00, 0.1990D+00, 0.2229D+00, 0.2445D+00,
     ,   0.2634D+00, 0.2791D+00, 0.2910D+00, 0.2989D+00, 0.3022D+00,
     ,   0.3008D+00, 0.2945D+00, 0.2834D+00, 0.2676D+00, 0.2476D+00,
     ,   0.2239D+00, 0.1973D+00, 0.1689D+00, 0.1399D+00, 0.1114D+00,
     ,   0.8463D-01, 0.6075D-01, 0.4073D-01, 0.2527D-01, 0.1471D-01,
     ,   0.8800D-02, 0.6583D-02, 0.6538D-02, 0.6940D-02, 0.6256D-02,
     ,   0.3389D-02,-0.2201D-02,-0.1044D-01,-0.2067D-01,-0.3175D-01,
     ,  -0.4230D-01,-0.5101D-01,-0.5684D-01,-0.5920D-01,-0.5792D-01,
     ,  -0.5316D-01,-0.4528D-01,-0.3476D-01,-0.2208D-01,-0.7688D-02,
     ,   0.8047D-02, 0.2481D-01, 0.4235D-01, 0.6048D-01, 0.7904D-01,
     ,   0.9793D-01, 0.1171D+00, 0.1364D+00, 0.1558D+00, 0.1754D+00,
     ,   0.1950D+00, 0.2146D+00, 0.2343D+00, 0.2541D+00, 0.2738D+00,
     ,   0.2936D+00, 0.3134D+00, 0.3331D+00/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.4864D-01,-0.4529D-01,-0.3630D-01,-0.2273D-01,-0.5453D-02,
     ,   0.1475D-01, 0.3718D-01, 0.6122D-01, 0.8630D-01, 0.1119D+00,
     ,   0.1374D+00, 0.1623D+00, 0.1862D+00, 0.2085D+00, 0.2288D+00,
     ,   0.2465D+00, 0.2611D+00, 0.2723D+00, 0.2796D+00, 0.2827D+00,
     ,   0.2814D+00, 0.2755D+00, 0.2650D+00, 0.2502D+00, 0.2314D+00,
     ,   0.2091D+00, 0.1842D+00, 0.1576D+00, 0.1304D+00, 0.1036D+00,
     ,   0.7855D-01, 0.5616D-01, 0.3736D-01, 0.2283D-01, 0.1287D-01,
     ,   0.7271D-02, 0.5149D-02, 0.5043D-02, 0.5253D-02, 0.4245D-02,
     ,   0.9228D-03,-0.5240D-02,-0.1415D-01,-0.2510D-01,-0.3693D-01,
     ,  -0.4824D-01,-0.5769D-01,-0.6424D-01,-0.6729D-01,-0.6666D-01,
     ,  -0.6252D-01,-0.5523D-01,-0.4528D-01,-0.3315D-01,-0.1928D-01,
     ,  -0.4062D-02, 0.1220D-01, 0.2924D-01, 0.4688D-01, 0.6495D-01,
     ,   0.8336D-01, 0.1020D+00, 0.1208D+00, 0.1398D+00, 0.1589D+00,
     ,   0.1780D+00, 0.1972D+00, 0.2164D+00, 0.2357D+00, 0.2550D+00,
     ,   0.2743D+00, 0.2936D+00, 0.3129D+00/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.4447D-01,-0.4140D-01,-0.3320D-01,-0.2079D-01,-0.5005D-02,
     ,   0.1346D-01, 0.3396D-01, 0.5593D-01, 0.7885D-01, 0.1022D+00,
     ,   0.1255D+00, 0.1483D+00, 0.1701D+00, 0.1905D+00, 0.2090D+00,
     ,   0.2252D+00, 0.2385D+00, 0.2487D+00, 0.2553D+00, 0.2581D+00,
     ,   0.2569D+00, 0.2514D+00, 0.2418D+00, 0.2282D+00, 0.2109D+00,
     ,   0.1905D+00, 0.1677D+00, 0.1433D+00, 0.1183D+00, 0.9381D-01,
     ,   0.7081D-01, 0.5028D-01, 0.3302D-01, 0.1965D-01, 0.1046D-01,
     ,   0.5300D-02, 0.3381D-02, 0.3342D-02, 0.3532D-02, 0.2420D-02,
     ,  -0.1095D-02,-0.7533D-02,-0.1678D-01,-0.2811D-01,-0.4035D-01,
     ,  -0.5210D-01,-0.6200D-01,-0.6904D-01,-0.7260D-01,-0.7250D-01,
     ,  -0.6892D-01,-0.6221D-01,-0.5286D-01,-0.4134D-01,-0.2809D-01,
     ,  -0.1349D-01, 0.2136D-02, 0.1855D-01, 0.3555D-01, 0.5300D-01,
     ,   0.7077D-01, 0.8879D-01, 0.1070D+00, 0.1253D+00, 0.1438D+00,
     ,   0.1623D+00, 0.1808D+00, 0.1994D+00, 0.2180D+00, 0.2367D+00,
     ,   0.2554D+00, 0.2740D+00, 0.2927D+00/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.3949D-01,-0.3677D-01,-0.2949D-01,-0.1849D-01,-0.4473D-02,
     ,   0.1191D-01, 0.3011D-01, 0.4961D-01, 0.6995D-01, 0.9067D-01,
     ,   0.1114D+00, 0.1316D+00, 0.1509D+00, 0.1690D+00, 0.1854D+00,
     ,   0.1997D+00, 0.2115D+00, 0.2205D+00, 0.2263D+00, 0.2288D+00,
     ,   0.2276D+00, 0.2227D+00, 0.2140D+00, 0.2019D+00, 0.1864D+00,
     ,   0.1682D+00, 0.1479D+00, 0.1261D+00, 0.1038D+00, 0.8195D-01,
     ,   0.6143D-01, 0.4310D-01, 0.2767D-01, 0.1569D-01, 0.7447D-02,
     ,   0.2857D-02, 0.1275D-02, 0.1475D-02, 0.1880D-02, 0.9523D-03,
     ,  -0.2444D-02,-0.8848D-02,-0.1814D-01,-0.2960D-01,-0.4202D-01,
     ,  -0.5401D-01,-0.6423D-01,-0.7166D-01,-0.7571D-01,-0.7619D-01,
     ,  -0.7326D-01,-0.6727D-01,-0.5868D-01,-0.4795D-01,-0.3553D-01,
     ,  -0.2177D-01,-0.6989D-02, 0.8575D-02, 0.2473D-01, 0.4133D-01,
     ,   0.5825D-01, 0.7543D-01, 0.9279D-01, 0.1103D+00, 0.1279D+00,
     ,   0.1456D+00, 0.1633D+00, 0.1811D+00, 0.1989D+00, 0.2167D+00,
     ,   0.2345D+00, 0.2524D+00, 0.2703D+00/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.3390D-01,-0.3159D-01,-0.2535D-01,-0.1590D-01,-0.3883D-02,
     ,   0.1017D-01, 0.2578D-01, 0.4251D-01, 0.5996D-01, 0.7773D-01,
     ,   0.9546D-01, 0.1128D+00, 0.1294D+00, 0.1449D+00, 0.1589D+00,
     ,   0.1711D+00, 0.1812D+00, 0.1888D+00, 0.1938D+00, 0.1957D+00,
     ,   0.1946D+00, 0.1903D+00, 0.1828D+00, 0.1722D+00, 0.1588D+00,
     ,   0.1430D+00, 0.1254D+00, 0.1066D+00, 0.8730D-01, 0.6840D-01,
     ,   0.5067D-01, 0.3483D-01, 0.2150D-01, 0.1115D-01, 0.4101D-02,
     ,   0.3624D-03,-0.4907D-03, 0.5445D-03, 0.1991D-02, 0.2230D-02,
     ,  -0.7609D-04,-0.5666D-02,-0.1453D-01,-0.2597D-01,-0.3873D-01,
     ,  -0.5137D-01,-0.6251D-01,-0.7110D-01,-0.7652D-01,-0.7854D-01,
     ,  -0.7728D-01,-0.7303D-01,-0.6620D-01,-0.5723D-01,-0.4651D-01,
     ,  -0.3440D-01,-0.2119D-01,-0.7121D-02, 0.7610D-02, 0.2285D-01,
     ,   0.3849D-01, 0.5442D-01, 0.7059D-01, 0.8693D-01, 0.1034D+00,
     ,   0.1200D+00, 0.1366D+00, 0.1534D+00, 0.1701D+00, 0.1869D+00,
     ,   0.2037D+00, 0.2206D+00, 0.2374D+00/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.2807D-01,-0.2617D-01,-0.2101D-01,-0.1321D-01,-0.3276D-02,
     ,   0.8344D-02, 0.2125D-01, 0.3507D-01, 0.4949D-01, 0.6417D-01,
     ,   0.7881D-01, 0.9312D-01, 0.1068D+00, 0.1195D+00, 0.1311D+00,
     ,   0.1411D+00, 0.1494D+00, 0.1556D+00, 0.1595D+00, 0.1611D+00,
     ,   0.1600D+00, 0.1562D+00, 0.1498D+00, 0.1409D+00, 0.1296D+00,
     ,   0.1164D+00, 0.1016D+00, 0.8589D-01, 0.6985D-01, 0.5419D-01,
     ,   0.3959D-01, 0.2667D-01, 0.1592D-01, 0.7734D-02, 0.2363D-02,
     ,  -0.4716D-04, 0.4448D-03, 0.3395D-02, 0.7788D-02, 0.1206D-01,
     ,   0.1444D-01, 0.1343D-01, 0.8290D-02,-0.7522D-03,-0.1265D-01,
     ,  -0.2590D-01,-0.3899D-01,-0.5065D-01,-0.6001D-01,-0.6661D-01,
     ,  -0.7030D-01,-0.7113D-01,-0.6932D-01,-0.6514D-01,-0.5889D-01,
     ,  -0.5087D-01,-0.4134D-01,-0.3056D-01,-0.1874D-01,-0.6069D-02,
     ,   0.7292D-02, 0.2121D-01, 0.3559D-01, 0.5032D-01, 0.6534D-01,
     ,   0.8059D-01, 0.9602D-01, 0.1116D+00, 0.1273D+00, 0.1431D+00,
     ,   0.1589D+00, 0.1748D+00, 0.1907D+00/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.2238D-01,-0.2089D-01,-0.1679D-01,-0.1058D-01,-0.2671D-02,
     ,   0.6582D-02, 0.1686D-01, 0.2786D-01, 0.3934D-01, 0.5102D-01,
     ,   0.6266D-01, 0.7403D-01, 0.8489D-01, 0.9500D-01, 0.1041D+00,
     ,   0.1121D+00, 0.1186D+00, 0.1234D+00, 0.1265D+00, 0.1276D+00,
     ,   0.1266D+00, 0.1235D+00, 0.1183D+00, 0.1110D+00, 0.1019D+00,
     ,   0.9127D-01, 0.7941D-01, 0.6682D-01, 0.5404D-01, 0.4164D-01,
     ,   0.3017D-01, 0.2012D-01, 0.1188D-01, 0.5692D-02, 0.1652D-02,
     ,  -0.2357D-03,-0.4954D-04, 0.2006D-02, 0.5474D-02, 0.9521D-02,
     ,   0.1297D-01, 0.1455D-01, 0.1322D-01, 0.8600D-02, 0.1049D-02,
     ,  -0.8456D-02,-0.1868D-01,-0.2845D-01,-0.3684D-01,-0.4325D-01,
     ,  -0.4736D-01,-0.4908D-01,-0.4847D-01,-0.4569D-01,-0.4095D-01,
     ,  -0.3449D-01,-0.2653D-01,-0.1729D-01,-0.6984D-02, 0.4221D-02,
     ,   0.1617D-01, 0.2872D-01, 0.4176D-01, 0.5520D-01, 0.6896D-01,
     ,   0.8298D-01, 0.9720D-01, 0.1116D+00, 0.1261D+00, 0.1407D+00,
     ,   0.1554D+00, 0.1701D+00, 0.1849D+00/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.1723D-01,-0.1610D-01,-0.1296D-01,-0.8196D-02,-0.2118D-02,
     ,   0.4992D-02, 0.1289D-01, 0.2134D-01, 0.3015D-01, 0.3912D-01,
     ,   0.4805D-01, 0.5676D-01, 0.6507D-01, 0.7280D-01, 0.7977D-01,
     ,   0.8580D-01, 0.9072D-01, 0.9437D-01, 0.9663D-01, 0.9736D-01,
     ,   0.9649D-01, 0.9398D-01, 0.8984D-01, 0.8414D-01, 0.7702D-01,
     ,   0.6872D-01, 0.5951D-01, 0.4978D-01, 0.3995D-01, 0.3046D-01,
     ,   0.2176D-01, 0.1424D-01, 0.8191D-02, 0.3781D-02, 0.1031D-02,
     ,  -0.1702D-03,-0.3346D-04, 0.1173D-02, 0.3142D-02, 0.5499D-02,
     ,   0.7740D-02, 0.9193D-02, 0.9106D-02, 0.6907D-02, 0.2476D-02,
     ,  -0.3759D-02,-0.1099D-01,-0.1827D-01,-0.2477D-01,-0.2987D-01,
     ,  -0.3320D-01,-0.3460D-01,-0.3404D-01,-0.3162D-01,-0.2748D-01,
     ,  -0.2182D-01,-0.1482D-01,-0.6672D-02, 0.2454D-02, 0.1240D-01,
     ,   0.2302D-01, 0.3421D-01, 0.4585D-01, 0.5786D-01, 0.7017D-01,
     ,   0.8272D-01, 0.9546D-01, 0.1084D+00, 0.1214D+00, 0.1345D+00,
     ,   0.1477D+00, 0.1609D+00, 0.1742D+00/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.1286D-01,-0.1203D-01,-0.9710D-02,-0.6166D-02,-0.1644D-02,
     ,   0.3648D-02, 0.9524D-02, 0.1581D-01, 0.2237D-01, 0.2903D-01,
     ,   0.3566D-01, 0.4212D-01, 0.4827D-01, 0.5398D-01, 0.5911D-01,
     ,   0.6353D-01, 0.6712D-01, 0.6975D-01, 0.7132D-01, 0.7176D-01,
     ,   0.7099D-01, 0.6899D-01, 0.6578D-01, 0.6140D-01, 0.5598D-01,
     ,   0.4968D-01, 0.4274D-01, 0.3544D-01, 0.2810D-01, 0.2107D-01,
     ,   0.1469D-01, 0.9277D-02, 0.5054D-02, 0.2156D-02, 0.5875D-03,
     ,   0.2131D-03, 0.7574D-03, 0.1846D-02, 0.3102D-02, 0.4257D-02,
     ,   0.5176D-02, 0.5728D-02, 0.5630D-02, 0.4458D-02, 0.1875D-02,
     ,  -0.2115D-02,-0.7118D-02,-0.1249D-01,-0.1753D-01,-0.2167D-01,
     ,  -0.2450D-01,-0.2580D-01,-0.2549D-01,-0.2360D-01,-0.2024D-01,
     ,  -0.1553D-01,-0.9641D-02,-0.2718D-02, 0.5087D-02, 0.1364D-01,
     ,   0.2280D-01, 0.3249D-01, 0.4259D-01, 0.5304D-01, 0.6377D-01,
     ,   0.7471D-01, 0.8584D-01, 0.9711D-01, 0.1085D+00, 0.1200D+00,
     ,   0.1315D+00, 0.1431D+00, 0.1547D+00/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.9352D-02,-0.8768D-02,-0.7094D-02,-0.4531D-02,-0.1257D-02,
     ,   0.2577D-02, 0.6833D-02, 0.1139D-01, 0.1613D-01, 0.2094D-01,
     ,   0.2573D-01, 0.3038D-01, 0.3481D-01, 0.3890D-01, 0.4257D-01,
     ,   0.4571D-01, 0.4823D-01, 0.5005D-01, 0.5109D-01, 0.5130D-01,
     ,   0.5063D-01, 0.4905D-01, 0.4660D-01, 0.4330D-01, 0.3925D-01,
     ,   0.3458D-01, 0.2946D-01, 0.2411D-01, 0.1876D-01, 0.1369D-01,
     ,   0.9146D-02, 0.5371D-02, 0.2546D-02, 0.7862D-03, 0.1156D-03,
     ,   0.4367D-03, 0.1497D-02, 0.2885D-02, 0.4117D-02, 0.4819D-02,
     ,   0.4895D-02, 0.4497D-02, 0.3782D-02, 0.2686D-02, 0.9412D-03,
     ,  -0.1672D-02,-0.5107D-02,-0.9029D-02,-0.1294D-01,-0.1634D-01,
     ,  -0.1882D-01,-0.2015D-01,-0.2017D-01,-0.1889D-01,-0.1634D-01,
     ,  -0.1263D-01,-0.7877D-02,-0.2203D-02, 0.4263D-02, 0.1140D-01,
     ,   0.1911D-01, 0.2728D-01, 0.3584D-01, 0.4472D-01, 0.5386D-01,
     ,   0.6320D-01, 0.7271D-01, 0.8235D-01, 0.9210D-01, 0.1019D+00,
     ,   0.1118D+00, 0.1218D+00, 0.1318D+00/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.6657D-02,-0.6259D-02,-0.5081D-02,-0.3269D-02,-0.9504D-03,
     ,   0.1766D-02, 0.4781D-02, 0.8006D-02, 0.1136D-01, 0.1476D-01,
     ,   0.1814D-01, 0.2142D-01, 0.2452D-01, 0.2738D-01, 0.2993D-01,
     ,   0.3210D-01, 0.3382D-01, 0.3503D-01, 0.3568D-01, 0.3573D-01,
     ,   0.3514D-01, 0.3391D-01, 0.3206D-01, 0.2960D-01, 0.2662D-01,
     ,   0.2321D-01, 0.1950D-01, 0.1565D-01, 0.1183D-01, 0.8243D-02,
     ,   0.5080D-02, 0.2515D-02, 0.6913D-03,-0.2874D-03,-0.3747D-03,
     ,   0.3917D-03, 0.1835D-02, 0.3591D-02, 0.5142D-02, 0.5985D-02,
     ,   0.5875D-02, 0.4950D-02, 0.3589D-02, 0.2093D-02, 0.4734D-03,
     ,  -0.1473D-02,-0.3908D-02,-0.6774D-02,-0.9794D-02,-0.1259D-01,
     ,  -0.1481D-01,-0.1618D-01,-0.1654D-01,-0.1583D-01,-0.1407D-01,
     ,  -0.1130D-01,-0.7619D-02,-0.3127D-02, 0.2072D-02, 0.7877D-02,
     ,   0.1419D-01, 0.2094D-01, 0.2804D-01, 0.3543D-01, 0.4306D-01,
     ,   0.5088D-01, 0.5886D-01, 0.6696D-01, 0.7516D-01, 0.8343D-01,
     ,   0.9177D-01, 0.1002D+00, 0.1086D+00/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.4662D-02,-0.4398D-02,-0.3585D-02,-0.2328D-02,-0.7141D-03,
     ,   0.1177D-02, 0.3276D-02, 0.5519D-02, 0.7849D-02, 0.1021D-01,
     ,   0.1255D-01, 0.1481D-01, 0.1695D-01, 0.1891D-01, 0.2064D-01,
     ,   0.2210D-01, 0.2323D-01, 0.2401D-01, 0.2438D-01, 0.2433D-01,
     ,   0.2383D-01, 0.2287D-01, 0.2148D-01, 0.1967D-01, 0.1750D-01,
     ,   0.1504D-01, 0.1238D-01, 0.9639D-02, 0.6953D-02, 0.4458D-02,
     ,   0.2294D-02, 0.5882D-03,-0.5492D-03,-0.1029D-02,-0.7891D-03,
     ,   0.1856D-03, 0.1803D-02, 0.3791D-02, 0.5681D-02, 0.6921D-02,
     ,   0.7106D-02, 0.6199D-02, 0.4540D-02, 0.2620D-02, 0.7586D-03,
     ,  -0.1039D-02,-0.2953D-02,-0.5108D-02,-0.7444D-02,-0.9737D-02,
     ,  -0.1171D-01,-0.1310D-01,-0.1374D-01,-0.1353D-01,-0.1245D-01,
     ,  -0.1051D-01,-0.7796D-02,-0.4366D-02,-0.3097D-03, 0.4289D-02,
     ,   0.9350D-02, 0.1480D-01, 0.2057D-01, 0.2661D-01, 0.3287D-01,
     ,   0.3931D-01, 0.4589D-01, 0.5259D-01, 0.5937D-01, 0.6623D-01,
     ,   0.7315D-01, 0.8011D-01, 0.8711D-01/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.3224D-02,-0.3054D-02,-0.2502D-02,-0.1641D-02,-0.5345D-03,
     ,   0.7639D-03, 0.2205D-02, 0.3744D-02, 0.5339D-02, 0.6953D-02,
     ,   0.8547D-02, 0.1008D-01, 0.1153D-01, 0.1285D-01, 0.1400D-01,
     ,   0.1496D-01, 0.1569D-01, 0.1616D-01, 0.1636D-01, 0.1625D-01,
     ,   0.1582D-01, 0.1509D-01, 0.1404D-01, 0.1272D-01, 0.1114D-01,
     ,   0.9377D-02, 0.7489D-02, 0.5562D-02, 0.3692D-02, 0.1978D-02,
     ,   0.5198D-03,-0.5913D-03,-0.1273D-02,-0.1451D-02,-0.1055D-02,
     ,  -0.3678D-04, 0.1580D-02, 0.3619D-02, 0.5703D-02, 0.7312D-02,
     ,   0.7969D-02, 0.7455D-02, 0.5932D-02, 0.3858D-02, 0.1725D-02,
     ,  -0.2047D-03,-0.1963D-02,-0.3714D-02,-0.5555D-02,-0.7426D-02,
     ,  -0.9148D-02,-0.1051D-01,-0.1134D-01,-0.1153D-01,-0.1100D-01,
     ,  -0.9778D-02,-0.7880D-02,-0.5366D-02,-0.2301D-02, 0.1246D-02,
     ,   0.5208D-02, 0.9520D-02, 0.1413D-01, 0.1898D-01, 0.2403D-01,
     ,   0.2925D-01, 0.3459D-01, 0.4005D-01, 0.4559D-01, 0.5120D-01,
     ,   0.5686D-01, 0.6256D-01, 0.6830D-01/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.2208D-02,-0.2102D-02,-0.1732D-02,-0.1150D-02,-0.3991D-03,
     ,   0.4825D-03, 0.1461D-02, 0.2504D-02, 0.3585D-02, 0.4675D-02,
     ,   0.5748D-02, 0.6779D-02, 0.7742D-02, 0.8614D-02, 0.9369D-02,
     ,   0.9985D-02, 0.1044D-01, 0.1071D-01, 0.1079D-01, 0.1066D-01,
     ,   0.1031D-01, 0.9737D-02, 0.8958D-02, 0.7987D-02, 0.6852D-02,
     ,   0.5592D-02, 0.4259D-02, 0.2913D-02, 0.1621D-02, 0.4563D-03,
     ,  -0.5124D-03,-0.1220D-02,-0.1604D-02,-0.1605D-02,-0.1153D-02,
     ,  -0.1824D-03, 0.1328D-02, 0.3278D-02, 0.5387D-02, 0.7213D-02,
     ,   0.8283D-02, 0.8281D-02, 0.7184D-02, 0.5291D-02, 0.3082D-02,
     ,   0.9810D-03,-0.8342D-03,-0.2432D-02,-0.3963D-02,-0.5496D-02,
     ,  -0.6975D-02,-0.8257D-02,-0.9188D-02,-0.9645D-02,-0.9556D-02,
     ,  -0.8893D-02,-0.7669D-02,-0.5916D-02,-0.3683D-02,-0.1026D-02,
     ,   0.2001D-02, 0.5343D-02, 0.8951D-02, 0.1278D-01, 0.1680D-01,
     ,   0.2096D-01, 0.2525D-01, 0.2963D-01, 0.3409D-01, 0.3862D-01,
     ,   0.4320D-01, 0.4782D-01, 0.5247D-01/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.1501D-02,-0.1437D-02,-0.1192D-02,-0.8024D-03,-0.2976D-03,
     ,   0.2957D-03, 0.9538D-03, 0.1655D-02, 0.2380D-02, 0.3109D-02,
     ,   0.3824D-02, 0.4507D-02, 0.5141D-02, 0.5709D-02, 0.6195D-02,
     ,   0.6581D-02, 0.6855D-02, 0.7001D-02, 0.7009D-02, 0.6871D-02,
     ,   0.6584D-02, 0.6146D-02, 0.5566D-02, 0.4856D-02, 0.4039D-02,
     ,   0.3142D-02, 0.2204D-02, 0.1268D-02, 0.3822D-03,-0.4020D-03,
     ,  -0.1035D-02,-0.1471D-02,-0.1665D-02,-0.1564D-02,-0.1108D-02,
     ,  -0.2227D-03, 0.1136D-02, 0.2921D-02, 0.4931D-02, 0.6811D-02,
     ,   0.8142D-02, 0.8583D-02, 0.7996D-02, 0.6508D-02, 0.4474D-02,
     ,   0.2334D-02, 0.4135D-03,-0.1193D-02,-0.2579D-02,-0.3874D-02,
     ,  -0.5127D-02,-0.6283D-02,-0.7230D-02,-0.7854D-02,-0.8071D-02,
     ,  -0.7837D-02,-0.7141D-02,-0.5999D-02,-0.4445D-02,-0.2520D-02,
     ,  -0.2687D-03, 0.2264D-02, 0.5036D-02, 0.8010D-02, 0.1115D-01,
     ,   0.1443D-01, 0.1782D-01, 0.2130D-01, 0.2485D-01, 0.2847D-01,
     ,   0.3213D-01, 0.3582D-01, 0.3955D-01/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.1015D-02,-0.9774D-03,-0.8173D-03,-0.5584D-03,-0.2217D-03,
     ,   0.1746D-03, 0.6140D-03, 0.1082D-02, 0.1564D-02, 0.2047D-02,
     ,   0.2519D-02, 0.2967D-02, 0.3379D-02, 0.3744D-02, 0.4050D-02,
     ,   0.4286D-02, 0.4443D-02, 0.4510D-02, 0.4482D-02, 0.4352D-02,
     ,   0.4119D-02, 0.3784D-02, 0.3352D-02, 0.2834D-02, 0.2246D-02,
     ,   0.1609D-02, 0.9501D-03, 0.3014D-03,-0.3023D-03,-0.8249D-03,
     ,  -0.1231D-02,-0.1487D-02,-0.1558D-02,-0.1403D-02,-0.9641D-03,
     ,  -0.1725D-03, 0.1028D-02, 0.2620D-02, 0.4463D-02, 0.6279D-02,
     ,   0.7718D-02, 0.8461D-02, 0.8321D-02, 0.7306D-02, 0.5626D-02,
     ,   0.3631D-02, 0.1684D-02, 0.1404D-04,-0.1350D-02,-0.2513D-02,
     ,  -0.3583D-02,-0.4592D-02,-0.5488D-02,-0.6183D-02,-0.6593D-02,
     ,  -0.6662D-02,-0.6362D-02,-0.5695D-02,-0.4678D-02,-0.3341D-02,
     ,  -0.1718D-02, 0.1542D-03, 0.2241D-02, 0.4508D-02, 0.6927D-02,
     ,   0.9471D-02, 0.1212D-01, 0.1485D-01, 0.1765D-01, 0.2050D-01,
     ,   0.2340D-01, 0.2633D-01, 0.2928D-01/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.6824D-03,-0.6623D-03,-0.5586D-03,-0.3880D-03,-0.1649D-03,
     ,   0.9797D-04, 0.3894D-03, 0.6990D-03, 0.1017D-02, 0.1335D-02,
     ,   0.1643D-02, 0.1934D-02, 0.2199D-02, 0.2430D-02, 0.2619D-02,
     ,   0.2758D-02, 0.2842D-02, 0.2863D-02, 0.2818D-02, 0.2702D-02,
     ,   0.2516D-02, 0.2260D-02, 0.1939D-02, 0.1561D-02, 0.1138D-02,
     ,   0.6853D-03, 0.2236D-03,-0.2245D-03,-0.6336D-03,-0.9776D-03,
     ,  -0.1231D-02,-0.1368D-02,-0.1363D-02,-0.1180D-02,-0.7686D-03,
     ,  -0.6498D-04, 0.9872D-03, 0.2389D-02, 0.4040D-02, 0.5724D-02,
     ,   0.7157D-02, 0.8063D-02, 0.8252D-02, 0.7666D-02, 0.6401D-02,
     ,   0.4692D-02, 0.2850D-02, 0.1157D-02,-0.2434D-03,-0.1367D-02,
     ,  -0.2319D-02,-0.3188D-02,-0.3991D-02,-0.4680D-02,-0.5187D-02,
     ,  -0.5451D-02,-0.5432D-02,-0.5118D-02,-0.4513D-02,-0.3636D-02,
     ,  -0.2511D-02,-0.1167D-02, 0.3671D-03, 0.2063D-02, 0.3895D-02,
     ,   0.5841D-02, 0.7881D-02, 0.9998D-02, 0.1218D-01, 0.1441D-01,
     ,   0.1667D-01, 0.1898D-01, 0.2130D-01/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.4572D-03,-0.4474D-03,-0.3810D-03,-0.2694D-03,-0.1226D-03,
     ,   0.5074D-04, 0.2428D-03, 0.4465D-03, 0.6551D-03, 0.8624D-03,
     ,   0.1062D-02, 0.1249D-02, 0.1417D-02, 0.1560D-02, 0.1674D-02,
     ,   0.1753D-02, 0.1792D-02, 0.1788D-02, 0.1737D-02, 0.1638D-02,
     ,   0.1491D-02, 0.1296D-02, 0.1058D-02, 0.7817D-03, 0.4774D-03,
     ,   0.1563D-03,-0.1669D-03,-0.4754D-03,-0.7508D-03,-0.9739D-03,
     ,  -0.1126D-02,-0.1187D-02,-0.1135D-02,-0.9405D-03,-0.5593D-03,
     ,   0.6558D-04, 0.9865D-03, 0.2213D-02, 0.3670D-02, 0.5191D-02,
     ,   0.6549D-02, 0.7513D-02, 0.7912D-02, 0.7661D-02, 0.6787D-02,
     ,   0.5426D-02, 0.3804D-02, 0.2177D-02, 0.7522D-03,-0.3904D-03,
     ,  -0.1295D-02,-0.2061D-02,-0.2756D-02,-0.3388D-02,-0.3916D-02,
     ,  -0.4284D-02,-0.4448D-02,-0.4383D-02,-0.4083D-02,-0.3555D-02,
     ,  -0.2815D-02,-0.1885D-02,-0.7888D-03, 0.4519D-03, 0.1815D-02,
     ,   0.3281D-02, 0.4831D-02, 0.6452D-02, 0.8130D-02, 0.9854D-02,
     ,   0.1161D-01, 0.1341D-01, 0.1522D-01/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.3052D-03,-0.3015D-03,-0.2595D-03,-0.1871D-03,-0.9103D-04,
     ,   0.2258D-04, 0.1484D-03, 0.2815D-03, 0.4173D-03, 0.5515D-03,
     ,   0.6798D-03, 0.7983D-03, 0.9031D-03, 0.9903D-03, 0.1056D-02,
     ,   0.1098D-02, 0.1111D-02, 0.1094D-02, 0.1045D-02, 0.9632D-03,
     ,   0.8475D-03, 0.6998D-03, 0.5230D-03, 0.3218D-03, 0.1029D-03,
     ,  -0.1249D-03,-0.3509D-03,-0.5627D-03,-0.7466D-03,-0.8883D-03,
     ,  -0.9733D-03,-0.9860D-03,-0.9079D-03,-0.7129D-03,-0.3627D-03,
     ,   0.1925D-03, 0.9986D-03, 0.2067D-02, 0.3342D-02, 0.4693D-02,
     ,   0.5938D-02, 0.6891D-02, 0.7403D-02, 0.7389D-02, 0.6840D-02,
     ,   0.5823D-02, 0.4482D-02, 0.3015D-02, 0.1625D-02, 0.4558D-03,
     ,  -0.4573D-03,-0.1173D-02,-0.1779D-02,-0.2330D-02,-0.2824D-02,
     ,  -0.3225D-02,-0.3490D-02,-0.3589D-02,-0.3503D-02,-0.3232D-02,
     ,  -0.2783D-02,-0.2172D-02,-0.1415D-02,-0.5306D-03, 0.4623D-03,
     ,   0.1547D-02, 0.2709D-02, 0.3934D-02, 0.5211D-02, 0.6531D-02,
     ,   0.7885D-02, 0.9266D-02, 0.1067D-01/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.2031D-03,-0.2027D-03,-0.1765D-03,-0.1299D-03,-0.6749D-04,
     ,   0.6503D-05, 0.8840D-04, 0.1748D-03, 0.2625D-03, 0.3486D-03,
     ,   0.4302D-03, 0.5044D-03, 0.5686D-03, 0.6202D-03, 0.6566D-03,
     ,   0.6756D-03, 0.6752D-03, 0.6535D-03, 0.6095D-03, 0.5424D-03,
     ,   0.4525D-03, 0.3409D-03, 0.2100D-03, 0.6329D-04,-0.9411D-04,
     ,  -0.2557D-03,-0.4135D-03,-0.5583D-03,-0.6799D-03,-0.7674D-03,
     ,  -0.8092D-03,-0.7927D-03,-0.7016D-03,-0.5131D-03,-0.1938D-03,
     ,   0.2988D-03, 0.1004D-02, 0.1933D-02, 0.3041D-02, 0.4226D-02,
     ,   0.5342D-02, 0.6241D-02, 0.6799D-02, 0.6940D-02, 0.6638D-02,
     ,   0.5921D-02, 0.4873D-02, 0.3627D-02, 0.2347D-02, 0.1188D-02,
     ,   0.2478D-03,-0.4698D-03,-0.1028D-02,-0.1503D-02,-0.1934D-02,
     ,  -0.2317D-02,-0.2621D-02,-0.2812D-02,-0.2867D-02,-0.2776D-02,
     ,  -0.2540D-02,-0.2167D-02,-0.1669D-02,-0.1060D-02,-0.3548D-03,
     ,   0.4322D-03, 0.1288D-02, 0.2202D-02, 0.3163D-02, 0.4162D-02,
     ,   0.5193D-02, 0.6249D-02, 0.7326D-02/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.1347D-03,-0.1360D-03,-0.1200D-03,-0.9021D-04,-0.4997D-04,
     ,  -0.2089D-05, 0.5086D-04, 0.1065D-03, 0.1628D-03, 0.2175D-03,
     ,   0.2686D-03, 0.3144D-03, 0.3528D-03, 0.3822D-03, 0.4008D-03,
     ,   0.4070D-03, 0.3996D-03, 0.3773D-03, 0.3395D-03, 0.2857D-03,
     ,   0.2164D-03, 0.1324D-03, 0.3564D-04,-0.7124D-04,-0.1844D-03,
     ,  -0.2990D-03,-0.4090D-03,-0.5076D-03,-0.5869D-03,-0.6386D-03,
     ,  -0.6533D-03,-0.6202D-03,-0.5250D-03,-0.3477D-03,-0.5910D-04,
     ,   0.3768D-03, 0.9924D-03, 0.1797D-02, 0.2755D-02, 0.3784D-02,
     ,   0.4769D-02, 0.5590D-02, 0.6150D-02, 0.6381D-02, 0.6255D-02,
     ,   0.5780D-02, 0.5001D-02, 0.3997D-02, 0.2886D-02, 0.1799D-02,
     ,   0.8529D-03, 0.1081D-03,-0.4482D-03,-0.8787D-03,-0.1247D-02,
     ,  -0.1582D-02,-0.1877D-02,-0.2106D-02,-0.2242D-02,-0.2271D-02,
     ,  -0.2184D-02,-0.1984D-02,-0.1679D-02,-0.1278D-02,-0.7930D-03,
     ,  -0.2358D-03, 0.3830D-03, 0.1053D-02, 0.1767D-02, 0.2515D-02,
     ,   0.3292D-02, 0.4093D-02, 0.4912D-02/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.8902D-04,-0.9111D-04,-0.8149D-04,-0.6269D-04,-0.3693D-04,
     ,  -0.6179D-05, 0.2780D-04, 0.6339D-04, 0.9909D-04, 0.1335D-03,
     ,   0.1651D-03, 0.1927D-03, 0.2151D-03, 0.2309D-03, 0.2390D-03,
     ,   0.2383D-03, 0.2281D-03, 0.2074D-03, 0.1759D-03, 0.1335D-03,
     ,   0.8036D-04, 0.1739D-04,-0.5405D-04,-0.1318D-03,-0.2132D-03,
     ,  -0.2943D-03,-0.3709D-03,-0.4376D-03,-0.4885D-03,-0.5169D-03,
     ,  -0.5152D-03,-0.4739D-03,-0.3805D-03,-0.2172D-03, 0.4117D-04,
     ,   0.4248D-03, 0.9603D-03, 0.1654D-02, 0.2478D-02, 0.3364D-02,
     ,   0.4222D-02, 0.4956D-02, 0.5488D-02, 0.5764D-02, 0.5757D-02,
     ,   0.5466D-02, 0.4911D-02, 0.4140D-02, 0.3226D-02, 0.2265D-02,
     ,   0.1362D-02, 0.6012D-03, 0.1909D-04,-0.4074D-03,-0.7360D-03,
     ,  -0.1019D-02,-0.1278D-02,-0.1504D-02,-0.1675D-02,-0.1773D-02,
     ,  -0.1784D-02,-0.1706D-02,-0.1540D-02,-0.1294D-02,-0.9748D-03,
     ,  -0.5924D-03,-0.1555D-03, 0.3275D-03, 0.8490D-03, 0.1402D-02,
     ,   0.1982D-02, 0.2583D-02, 0.3200D-02/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.5865D-04,-0.6092D-04,-0.5532D-04,-0.4358D-04,-0.2725D-04,
     ,  -0.7659D-05, 0.1396D-04, 0.3651D-04, 0.5892D-04, 0.8022D-04,
     ,   0.9945D-04, 0.1157D-03, 0.1281D-03, 0.1358D-03, 0.1380D-03,
     ,   0.1340D-03, 0.1233D-03, 0.1052D-03, 0.7963D-04, 0.4649D-04,
     ,   0.6064D-05,-0.4100D-04,-0.9362D-04,-0.1502D-03,-0.2086D-03,
     ,  -0.2661D-03,-0.3192D-03,-0.3641D-03,-0.3960D-03,-0.4096D-03,
     ,  -0.3984D-03,-0.3544D-03,-0.2665D-03,-0.1187D-03, 0.1102D-03,
     ,   0.4457D-03, 0.9090D-03, 0.1505D-02, 0.2208D-02, 0.2966D-02,
     ,   0.3705D-02, 0.4350D-02, 0.4838D-02, 0.5128D-02, 0.5195D-02,
     ,   0.5035D-02, 0.4658D-02, 0.4089D-02, 0.3372D-02, 0.2569D-02,
     ,   0.1758D-02, 0.1020D-02, 0.4162D-03,-0.3384D-04,-0.3577D-03,
     ,  -0.6065D-03,-0.8227D-03,-0.1021D-02,-0.1193D-02,-0.1322D-02,
     ,  -0.1391D-02,-0.1392D-02,-0.1324D-02,-0.1189D-02,-0.9927D-03,
     ,  -0.7411D-03,-0.4418D-03,-0.1016D-03, 0.2729D-03, 0.6761D-03,
     ,   0.1103D-02, 0.1549D-02, 0.2011D-02/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.3850D-04,-0.4066D-04,-0.3754D-04,-0.3032D-04,-0.2007D-04,
     ,  -0.7711D-05, 0.5915D-05, 0.2003D-04, 0.3393D-04, 0.4691D-04,
     ,   0.5832D-04, 0.6753D-04, 0.7394D-04, 0.7697D-04, 0.7609D-04,
     ,   0.7081D-04, 0.6074D-04, 0.4558D-04, 0.2518D-04,-0.4491D-06,
     ,  -0.3105D-04,-0.6611D-04,-0.1048D-03,-0.1459D-03,-0.1878D-03,
     ,  -0.2284D-03,-0.2652D-03,-0.2951D-03,-0.3144D-03,-0.3189D-03,
     ,  -0.3030D-03,-0.2597D-03,-0.1792D-03,-0.4775D-04, 0.1531D-03,
     ,   0.4442D-03, 0.8426D-03, 0.1351D-02, 0.1948D-02, 0.2592D-02,
     ,   0.3222D-02, 0.3780D-02, 0.4217D-02, 0.4500D-02, 0.4609D-02,
     ,   0.4540D-02, 0.4295D-02, 0.3890D-02, 0.3349D-02, 0.2709D-02,
     ,   0.2023D-02, 0.1351D-02, 0.7563D-03, 0.2827D-03,-0.6203D-04,
     ,  -0.3059D-03,-0.4930D-03,-0.6571D-03,-0.8083D-03,-0.9389D-03,
     ,  -0.1035D-02,-0.1084D-02,-0.1080D-02,-0.1022D-02,-0.9138D-03,
     ,  -0.7584D-03,-0.5616D-03,-0.3289D-03,-0.6576D-04, 0.2230D-03,
     ,   0.5331D-03, 0.8606D-03, 0.1202D-02/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.2518D-04,-0.2709D-04,-0.2546D-04,-0.2111D-04,-0.1476D-04,
     ,  -0.7047D-05, 0.1437D-05, 0.1016D-04, 0.1863D-04, 0.2637D-04,
     ,   0.3293D-04, 0.3787D-04, 0.4077D-04, 0.4124D-04, 0.3891D-04,
     ,   0.3347D-04, 0.2464D-04, 0.1225D-04,-0.3789D-05,-0.2344D-04,
     ,  -0.4648D-04,-0.7251D-04,-0.1009D-03,-0.1307D-03,-0.1607D-03,
     ,  -0.1894D-03,-0.2148D-03,-0.2345D-03,-0.2456D-03,-0.2446D-03,
     ,  -0.2270D-03,-0.1864D-03,-0.1145D-03, 0.9270D-06, 0.1753D-03,
     ,   0.4259D-03, 0.7660D-03, 0.1197D-02, 0.1701D-02, 0.2243D-02,
     ,   0.2776D-02, 0.3253D-02, 0.3636D-02, 0.3900D-02, 0.4029D-02,
     ,   0.4019D-02, 0.3870D-02, 0.3591D-02, 0.3196D-02, 0.2706D-02,
     ,   0.2153D-02, 0.1578D-02, 0.1030D-02, 0.5563D-03, 0.1880D-03,
     ,  -0.7394D-04,-0.2563D-03,-0.3961D-03,-0.5199D-03,-0.6347D-03,
     ,  -0.7334D-03,-0.8045D-03,-0.8390D-03,-0.8327D-03,-0.7852D-03,
     ,  -0.6988D-03,-0.5770D-03,-0.4241D-03,-0.2444D-03,-0.4201D-04,
     ,   0.1795D-03, 0.4167D-03, 0.6668D-03/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.1640D-04,-0.1802D-04,-0.1726D-04,-0.1470D-04,-0.1083D-04,
     ,  -0.6089D-05,-0.8824D-06, 0.4422D-05, 0.9479D-05, 0.1396D-04,
     ,   0.1755D-04, 0.1995D-04, 0.2087D-04, 0.2005D-04, 0.1722D-04,
     ,   0.1219D-04, 0.4772D-05,-0.5149D-05,-0.1761D-04,-0.3257D-04,
     ,  -0.4984D-04,-0.6911D-04,-0.8989D-04,-0.1115D-03,-0.1330D-03,
     ,  -0.1532D-03,-0.1706D-03,-0.1834D-03,-0.1893D-03,-0.1853D-03,
     ,  -0.1677D-03,-0.1310D-03,-0.6777D-04, 0.3221D-04, 0.1821D-03,
     ,   0.3960D-03, 0.6843D-03, 0.1047D-02, 0.1470D-02, 0.1923D-02,
     ,   0.2369D-02, 0.2773D-02, 0.3104D-02, 0.3342D-02, 0.3476D-02,
     ,   0.3502D-02, 0.3419D-02, 0.3234D-02, 0.2953D-02, 0.2590D-02,
     ,   0.2161D-02, 0.1694D-02, 0.1221D-02, 0.7793D-03, 0.4062D-03,
     ,   0.1220D-03,-0.7568D-04,-0.2112D-03,-0.3151D-03,-0.4080D-03,
     ,  -0.4948D-03,-0.5690D-03,-0.6217D-03,-0.6460D-03,-0.6388D-03,
     ,  -0.6002D-03,-0.5321D-03,-0.4374D-03,-0.3194D-03,-0.1813D-03,
     ,  -0.2642D-04, 0.1426D-03, 0.3232D-03/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.1063D-04,-0.1196D-04,-0.1170D-04,-0.1024D-04,-0.7932D-05,
     ,  -0.5070D-05,-0.1934D-05, 0.1221D-05, 0.4154D-05, 0.6639D-05,
     ,   0.8458D-05, 0.9403D-05, 0.9277D-05, 0.7895D-05, 0.5087D-05,
     ,   0.7095D-06,-0.5352D-05,-0.1317D-04,-0.2276D-04,-0.3407D-04,
     ,  -0.4696D-04,-0.6118D-04,-0.7637D-04,-0.9199D-04,-0.1074D-03,
     ,  -0.1216D-03,-0.1335D-03,-0.1416D-03,-0.1442D-03,-0.1388D-03,
     ,  -0.1222D-03,-0.8980D-04,-0.3516D-04, 0.5048D-04, 0.1781D-03,
     ,   0.3591D-03, 0.6017D-03, 0.9052D-03, 0.1257D-02, 0.1633D-02,
     ,   0.2005D-02, 0.2343D-02, 0.2624D-02, 0.2834D-02, 0.2964D-02,
     ,   0.3009D-02, 0.2971D-02, 0.2853D-02, 0.2658D-02, 0.2395D-02,
     ,   0.2074D-02, 0.1710D-02, 0.1322D-02, 0.9376D-03, 0.5862D-03,
     ,   0.2945D-03, 0.7685D-04,-0.7149D-04,-0.1716D-03,-0.2484D-03,
     ,  -0.3179D-03,-0.3832D-03,-0.4389D-03,-0.4778D-03,-0.4948D-03,
     ,  -0.4877D-03,-0.4568D-03,-0.4035D-03,-0.3303D-03,-0.2398D-03,
     ,  -0.1343D-03,-0.1629D-04, 0.1121D-03/
      data (calcpts(j,45), j = 1,neta) /
     ,  -0.6854D-05,-0.7921D-05,-0.7928D-05,-0.7142D-05,-0.5800D-05,
     ,  -0.4112D-05,-0.2269D-05,-0.4484D-06, 0.1184D-05, 0.2472D-05,
     ,   0.3263D-05, 0.3415D-05, 0.2791D-05, 0.1263D-05,-0.1282D-05,
     ,  -0.4942D-05,-0.9791D-05,-0.1587D-04,-0.2319D-04,-0.3169D-04,
     ,  -0.4128D-04,-0.5174D-04,-0.6282D-04,-0.7410D-04,-0.8507D-04,
     ,  -0.9504D-04,-0.1031D-03,-0.1082D-03,-0.1088D-03,-0.1030D-03,
     ,  -0.8793D-04,-0.5984D-04,-0.1322D-04, 0.5937D-04, 0.1670D-03,
     ,   0.3190D-03, 0.5216D-03, 0.7737D-03, 0.1065D-02, 0.1375D-02,
     ,   0.1682D-02, 0.1963D-02, 0.2199D-02, 0.2381D-02, 0.2500D-02,
     ,   0.2555D-02, 0.2545D-02, 0.2473D-02, 0.2342D-02, 0.2156D-02,
     ,   0.1921D-02, 0.1645D-02, 0.1341D-02, 0.1024D-02, 0.7159D-03,
     ,   0.4385D-03, 0.2122D-03, 0.4647D-04,-0.6422D-04,-0.1378D-03,
     ,  -0.1944D-03,-0.2461D-03,-0.2951D-03,-0.3367D-03,-0.3654D-03,
     ,  -0.3772D-03,-0.3708D-03,-0.3462D-03,-0.3049D-03,-0.2487D-03,
     ,  -0.1795D-03,-0.9927D-04,-0.9777D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,  -0.4393D-05,-0.5235D-05,-0.5370D-05,-0.4982D-05,-0.4234D-05,
     ,  -0.3270D-05,-0.2224D-05,-0.1218D-05,-0.3657D-06, 0.2223D-06,
     ,   0.4422D-06, 0.1946D-06,-0.6145D-06,-0.2072D-05,-0.4256D-05,
     ,  -0.7232D-05,-0.1105D-04,-0.1573D-04,-0.2127D-04,-0.2764D-04,
     ,  -0.3473D-04,-0.4242D-04,-0.5047D-04,-0.5861D-04,-0.6642D-04,
     ,  -0.7340D-04,-0.7885D-04,-0.8191D-04,-0.8138D-04,-0.7565D-04,
     ,  -0.6244D-04,-0.3848D-04, 0.8615D-06, 0.6180D-04, 0.1519D-03,
     ,   0.2785D-03, 0.4464D-03, 0.6545D-03, 0.8937D-03, 0.1148D-02,
     ,   0.1400D-02, 0.1631D-02, 0.1828D-02, 0.1982D-02, 0.2088D-02,
     ,   0.2145D-02, 0.2153D-02, 0.2113D-02, 0.2026D-02, 0.1897D-02,
     ,   0.1728D-02, 0.1525D-02, 0.1294D-02, 0.1044D-02, 0.7886D-03,
     ,   0.5436D-03, 0.3264D-03, 0.1520D-03, 0.2648D-04,-0.5571D-04,
     ,  -0.1096D-03,-0.1510D-03,-0.1894D-03,-0.2260D-03,-0.2570D-03,
     ,  -0.2781D-03,-0.2864D-03,-0.2807D-03,-0.2614D-03,-0.2296D-03,
     ,  -0.1866D-03,-0.1340D-03,-0.7325D-04/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.2796D-05,-0.3452D-05,-0.3636D-05,-0.3477D-05,-0.3085D-05,
     ,  -0.2561D-05,-0.1998D-05,-0.1478D-05,-0.1083D-05,-0.8881D-06,
     ,  -0.9653D-06,-0.1384D-05,-0.2208D-05,-0.3498D-05,-0.5306D-05,
     ,  -0.7676D-05,-0.1064D-04,-0.1421D-04,-0.1838D-04,-0.2312D-04,
     ,  -0.2836D-04,-0.3399D-04,-0.3984D-04,-0.4570D-04,-0.5125D-04,
     ,  -0.5612D-04,-0.5977D-04,-0.6151D-04,-0.6039D-04,-0.5509D-04,
     ,  -0.4372D-04,-0.2355D-04, 0.9309D-05, 0.6002D-04, 0.1347D-03,
     ,   0.2395D-03, 0.3778D-03, 0.5483D-03, 0.7437D-03, 0.9513D-03,
     ,   0.1156D-02, 0.1345D-02, 0.1508D-02, 0.1637D-02, 0.1729D-02,
     ,   0.1784D-02, 0.1801D-02, 0.1782D-02, 0.1727D-02, 0.1639D-02,
     ,   0.1519D-02, 0.1372D-02, 0.1200D-02, 0.1010D-02, 0.8075D-03,
     ,   0.6037D-03, 0.4107D-03, 0.2419D-03, 0.1082D-03, 0.1366D-04,
     ,  -0.4710D-04,-0.8634D-04,-0.1166D-03,-0.1450D-03,-0.1723D-03,
     ,  -0.1953D-03,-0.2108D-03,-0.2165D-03,-0.2117D-03,-0.1967D-03,
     ,  -0.1723D-03,-0.1396D-03,-0.9981D-04/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.1766D-05,-0.2270D-05,-0.2461D-05,-0.2427D-05,-0.2244D-05,
     ,  -0.1982D-05,-0.1703D-05,-0.1468D-05,-0.1330D-05,-0.1343D-05,
     ,  -0.1557D-05,-0.2019D-05,-0.2774D-05,-0.3864D-05,-0.5323D-05,
     ,  -0.7181D-05,-0.9459D-05,-0.1216D-04,-0.1529D-04,-0.1880D-04,
     ,  -0.2266D-04,-0.2677D-04,-0.3101D-04,-0.3522D-04,-0.3916D-04,
     ,  -0.4254D-04,-0.4496D-04,-0.4586D-04,-0.4449D-04,-0.3978D-04,
     ,  -0.3016D-04,-0.1336D-04, 0.1384D-04, 0.5569D-04, 0.1172D-03,
     ,   0.2032D-03, 0.3163D-03, 0.4553D-03, 0.6140D-03, 0.7821D-03,
     ,   0.9481D-03, 0.1102D-02, 0.1234D-02, 0.1342D-02, 0.1421D-02,
     ,   0.1471D-02, 0.1492D-02, 0.1486D-02, 0.1452D-02, 0.1393D-02,
     ,   0.1310D-02, 0.1205D-02, 0.1080D-02, 0.9378D-03, 0.7829D-03,
     ,   0.6210D-03, 0.4598D-03, 0.3090D-03, 0.1786D-03, 0.7666D-04,
     ,   0.5713D-05,-0.3904D-04,-0.6751D-04,-0.8955D-04,-0.1105D-03,
     ,  -0.1308D-03,-0.1478D-03,-0.1592D-03,-0.1631D-03,-0.1591D-03,
     ,  -0.1475D-03,-0.1289D-03,-0.1042D-03/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.1104D-05,-0.1489D-05,-0.1666D-05,-0.1695D-05,-0.1630D-05,
     ,  -0.1518D-05,-0.1403D-05,-0.1326D-05,-0.1326D-05,-0.1438D-05,
     ,  -0.1698D-05,-0.2138D-05,-0.2790D-05,-0.3682D-05,-0.4837D-05,
     ,  -0.6276D-05,-0.8010D-05,-0.1005D-04,-0.1237D-04,-0.1497D-04,
     ,  -0.1780D-04,-0.2079D-04,-0.2386D-04,-0.2688D-04,-0.2968D-04,
     ,  -0.3202D-04,-0.3360D-04,-0.3398D-04,-0.3257D-04,-0.2848D-04,
     ,  -0.2045D-04,-0.6595D-05, 0.1573D-04, 0.5002D-04, 0.1003D-03,
     ,   0.1705D-03, 0.2624D-03, 0.3750D-03, 0.5031D-03, 0.6385D-03,
     ,   0.7722D-03, 0.8959D-03, 0.1004D-02, 0.1092D-02, 0.1158D-02,
     ,   0.1203D-02, 0.1225D-02, 0.1227D-02, 0.1208D-02, 0.1169D-02,
     ,   0.1112D-02, 0.1038D-02, 0.9479D-03, 0.8437D-03, 0.7278D-03,
     ,   0.6034D-03, 0.4750D-03, 0.3486D-03, 0.2315D-03, 0.1313D-03,
     ,   0.5401D-04, 0.9983D-06,-0.3184D-04,-0.5243D-04,-0.6842D-04,
     ,  -0.8385D-04,-0.9883D-04,-0.1115D-03,-0.1197D-03,-0.1225D-03,
     ,  -0.1192D-03,-0.1103D-03,-0.9618D-04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0,
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0,
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0,
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0,
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

c      coeff=coeff/sqrt(1+eta/1.)

      return
      end    
!----------------------------
      subroutine c2hqg20p(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.1791D+01,-0.1479D+01,-0.1220D+01,-0.1007D+01,-0.8307D+00,
     ,  -0.6851D+00,-0.5649D+00,-0.4655D+00,-0.3834D+00,-0.3154D+00,
     ,  -0.2591D+00,-0.2125D+00,-0.1738D+00,-0.1417D+00,-0.1149D+00,
     ,  -0.9258D-01,-0.7391D-01,-0.5825D-01,-0.4509D-01,-0.3398D-01,
     ,  -0.2458D-01,-0.1662D-01,-0.9871D-02,-0.4168D-02, 0.6256D-03,
     ,   0.4596D-02, 0.7828D-02, 0.1037D-01, 0.1227D-01, 0.1354D-01,
     ,   0.1418D-01, 0.1413D-01, 0.1332D-01, 0.1162D-01, 0.9023D-02,
     ,   0.5805D-02, 0.2563D-02, 0.4854D-04,-0.1178D-02,-0.1012D-02,
     ,   0.2955D-03, 0.2362D-02, 0.4826D-02, 0.7415D-02, 0.9947D-02,
     ,   0.1230D-01, 0.1443D-01, 0.1629D-01, 0.1787D-01, 0.1920D-01,
     ,   0.2030D-01, 0.2120D-01, 0.2192D-01, 0.2249D-01, 0.2295D-01,
     ,   0.2331D-01, 0.2358D-01, 0.2380D-01, 0.2396D-01, 0.2409D-01,
     ,   0.2419D-01, 0.2426D-01, 0.2432D-01, 0.2436D-01, 0.2439D-01,
     ,   0.2442D-01, 0.2443D-01, 0.2445D-01, 0.2446D-01, 0.2447D-01,
     ,   0.2447D-01, 0.2448D-01, 0.2448D-01/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.1791D+01,-0.1478D+01,-0.1220D+01,-0.1007D+01,-0.8305D+00,
     ,  -0.6850D+00,-0.5648D+00,-0.4654D+00,-0.3833D+00,-0.3153D+00,
     ,  -0.2591D+00,-0.2124D+00,-0.1738D+00,-0.1416D+00,-0.1149D+00,
     ,  -0.9255D-01,-0.7390D-01,-0.5824D-01,-0.4508D-01,-0.3397D-01,
     ,  -0.2457D-01,-0.1661D-01,-0.9866D-02,-0.4166D-02, 0.6212D-03,
     ,   0.4597D-02, 0.7827D-02, 0.1037D-01, 0.1227D-01, 0.1353D-01,
     ,   0.1418D-01, 0.1413D-01, 0.1332D-01, 0.1162D-01, 0.9026D-02,
     ,   0.5806D-02, 0.2564D-02, 0.4823D-04,-0.1178D-02,-0.1013D-02,
     ,   0.2951D-03, 0.2362D-02, 0.4826D-02, 0.7413D-02, 0.9946D-02,
     ,   0.1230D-01, 0.1443D-01, 0.1629D-01, 0.1787D-01, 0.1920D-01,
     ,   0.2030D-01, 0.2120D-01, 0.2191D-01, 0.2249D-01, 0.2295D-01,
     ,   0.2330D-01, 0.2358D-01, 0.2380D-01, 0.2396D-01, 0.2409D-01,
     ,   0.2418D-01, 0.2426D-01, 0.2432D-01, 0.2436D-01, 0.2439D-01,
     ,   0.2442D-01, 0.2443D-01, 0.2445D-01, 0.2445D-01, 0.2447D-01,
     ,   0.2447D-01, 0.2447D-01, 0.2448D-01/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.1790D+01,-0.1478D+01,-0.1219D+01,-0.1006D+01,-0.8302D+00,
     ,  -0.6847D+00,-0.5646D+00,-0.4653D+00,-0.3831D+00,-0.3152D+00,
     ,  -0.2590D+00,-0.2124D+00,-0.1737D+00,-0.1416D+00,-0.1148D+00,
     ,  -0.9253D-01,-0.7387D-01,-0.5822D-01,-0.4506D-01,-0.3396D-01,
     ,  -0.2457D-01,-0.1661D-01,-0.9866D-02,-0.4161D-02, 0.6242D-03,
     ,   0.4598D-02, 0.7828D-02, 0.1037D-01, 0.1227D-01, 0.1353D-01,
     ,   0.1416D-01, 0.1413D-01, 0.1330D-01, 0.1161D-01, 0.9030D-02,
     ,   0.5805D-02, 0.2559D-02, 0.4869D-04,-0.1178D-02,-0.1012D-02,
     ,   0.2940D-03, 0.2361D-02, 0.4824D-02, 0.7412D-02, 0.9944D-02,
     ,   0.1231D-01, 0.1443D-01, 0.1628D-01, 0.1787D-01, 0.1920D-01,
     ,   0.2030D-01, 0.2119D-01, 0.2191D-01, 0.2249D-01, 0.2295D-01,
     ,   0.2330D-01, 0.2358D-01, 0.2380D-01, 0.2396D-01, 0.2409D-01,
     ,   0.2419D-01, 0.2426D-01, 0.2432D-01, 0.2436D-01, 0.2439D-01,
     ,   0.2442D-01, 0.2443D-01, 0.2444D-01, 0.2446D-01, 0.2446D-01,
     ,   0.2447D-01, 0.2447D-01, 0.2448D-01/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.1789D+01,-0.1477D+01,-0.1219D+01,-0.1006D+01,-0.8297D+00,
     ,  -0.6844D+00,-0.5643D+00,-0.4650D+00,-0.3830D+00,-0.3151D+00,
     ,  -0.2588D+00,-0.2123D+00,-0.1736D+00,-0.1415D+00,-0.1148D+00,
     ,  -0.9247D-01,-0.7383D-01,-0.5820D-01,-0.4504D-01,-0.3394D-01,
     ,  -0.2455D-01,-0.1660D-01,-0.9857D-02,-0.4161D-02, 0.6211D-03,
     ,   0.4594D-02, 0.7822D-02, 0.1036D-01, 0.1226D-01, 0.1353D-01,
     ,   0.1416D-01, 0.1412D-01, 0.1331D-01, 0.1161D-01, 0.9019D-02,
     ,   0.5800D-02, 0.2561D-02, 0.4817D-04,-0.1178D-02,-0.1013D-02,
     ,   0.2936D-03, 0.2360D-02, 0.4823D-02, 0.7410D-02, 0.9942D-02,
     ,   0.1230D-01, 0.1442D-01, 0.1628D-01, 0.1787D-01, 0.1919D-01,
     ,   0.2030D-01, 0.2119D-01, 0.2192D-01, 0.2249D-01, 0.2294D-01,
     ,   0.2330D-01, 0.2358D-01, 0.2379D-01, 0.2396D-01, 0.2409D-01,
     ,   0.2419D-01, 0.2426D-01, 0.2432D-01, 0.2436D-01, 0.2439D-01,
     ,   0.2441D-01, 0.2443D-01, 0.2445D-01, 0.2446D-01, 0.2446D-01,
     ,   0.2447D-01, 0.2447D-01, 0.2447D-01/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.1788D+01,-0.1476D+01,-0.1218D+01,-0.1005D+01,-0.8291D+00,
     ,  -0.6839D+00,-0.5639D+00,-0.4647D+00,-0.3827D+00,-0.3148D+00,
     ,  -0.2587D+00,-0.2121D+00,-0.1735D+00,-0.1414D+00,-0.1147D+00,
     ,  -0.9241D-01,-0.7378D-01,-0.5815D-01,-0.4501D-01,-0.3392D-01,
     ,  -0.2453D-01,-0.1658D-01,-0.9851D-02,-0.4158D-02, 0.6205D-03,
     ,   0.4590D-02, 0.7817D-02, 0.1036D-01, 0.1225D-01, 0.1351D-01,
     ,   0.1415D-01, 0.1411D-01, 0.1330D-01, 0.1161D-01, 0.9011D-02,
     ,   0.5801D-02, 0.2555D-02, 0.4882D-04,-0.1177D-02,-0.1013D-02,
     ,   0.2927D-03, 0.2368D-02, 0.4820D-02, 0.7408D-02, 0.9939D-02,
     ,   0.1231D-01, 0.1442D-01, 0.1628D-01, 0.1786D-01, 0.1920D-01,
     ,   0.2029D-01, 0.2119D-01, 0.2191D-01, 0.2249D-01, 0.2294D-01,
     ,   0.2330D-01, 0.2357D-01, 0.2379D-01, 0.2395D-01, 0.2408D-01,
     ,   0.2418D-01, 0.2425D-01, 0.2431D-01, 0.2435D-01, 0.2438D-01,
     ,   0.2441D-01, 0.2443D-01, 0.2444D-01, 0.2445D-01, 0.2446D-01,
     ,   0.2446D-01, 0.2447D-01, 0.2447D-01/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.1786D+01,-0.1474D+01,-0.1217D+01,-0.1004D+01,-0.8282D+00,
     ,  -0.6831D+00,-0.5633D+00,-0.4642D+00,-0.3823D+00,-0.3145D+00,
     ,  -0.2584D+00,-0.2119D+00,-0.1733D+00,-0.1412D+00,-0.1146D+00,
     ,  -0.9231D-01,-0.7370D-01,-0.5809D-01,-0.4496D-01,-0.3388D-01,
     ,  -0.2451D-01,-0.1657D-01,-0.9844D-02,-0.4151D-02, 0.6228D-03,
     ,   0.4588D-02, 0.7810D-02, 0.1035D-01, 0.1224D-01, 0.1349D-01,
     ,   0.1414D-01, 0.1410D-01, 0.1329D-01, 0.1159D-01, 0.9007D-02,
     ,   0.5796D-02, 0.2559D-02, 0.4802D-04,-0.1178D-02,-0.1013D-02,
     ,   0.2912D-03, 0.2365D-02, 0.4816D-02, 0.7404D-02, 0.9935D-02,
     ,   0.1229D-01, 0.1442D-01, 0.1627D-01, 0.1786D-01, 0.1919D-01,
     ,   0.2029D-01, 0.2118D-01, 0.2191D-01, 0.2248D-01, 0.2293D-01,
     ,   0.2329D-01, 0.2357D-01, 0.2378D-01, 0.2395D-01, 0.2408D-01,
     ,   0.2418D-01, 0.2425D-01, 0.2431D-01, 0.2435D-01, 0.2438D-01,
     ,   0.2440D-01, 0.2443D-01, 0.2444D-01, 0.2445D-01, 0.2445D-01,
     ,   0.2446D-01, 0.2446D-01, 0.2446D-01/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.1783D+01,-0.1472D+01,-0.1215D+01,-0.1002D+01,-0.8269D+00,
     ,  -0.6821D+00,-0.5624D+00,-0.4634D+00,-0.3816D+00,-0.3140D+00,
     ,  -0.2580D+00,-0.2115D+00,-0.1730D+00,-0.1410D+00,-0.1144D+00,
     ,  -0.9216D-01,-0.7358D-01,-0.5799D-01,-0.4488D-01,-0.3383D-01,
     ,  -0.2447D-01,-0.1654D-01,-0.9828D-02,-0.4144D-02, 0.6221D-03,
     ,   0.4574D-02, 0.7792D-02, 0.1033D-01, 0.1221D-01, 0.1348D-01,
     ,   0.1411D-01, 0.1407D-01, 0.1326D-01, 0.1158D-01, 0.8992D-02,
     ,   0.5786D-02, 0.2557D-02, 0.4761D-04,-0.1177D-02,-0.1013D-02,
     ,   0.2989D-03, 0.2361D-02, 0.4821D-02, 0.7397D-02, 0.9927D-02,
     ,   0.1229D-01, 0.1441D-01, 0.1627D-01, 0.1785D-01, 0.1918D-01,
     ,   0.2028D-01, 0.2118D-01, 0.2190D-01, 0.2247D-01, 0.2293D-01,
     ,   0.2328D-01, 0.2356D-01, 0.2378D-01, 0.2395D-01, 0.2407D-01,
     ,   0.2417D-01, 0.2424D-01, 0.2430D-01, 0.2434D-01, 0.2438D-01,
     ,   0.2440D-01, 0.2442D-01, 0.2443D-01, 0.2444D-01, 0.2441D-01,
     ,   0.2446D-01, 0.2445D-01, 0.2446D-01/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.1779D+01,-0.1468D+01,-0.1212D+01,-0.1000D+01,-0.8250D+00,
     ,  -0.6805D+00,-0.5611D+00,-0.4624D+00,-0.3808D+00,-0.3132D+00,
     ,  -0.2574D+00,-0.2110D+00,-0.1726D+00,-0.1407D+00,-0.1141D+00,
     ,  -0.9195D-01,-0.7341D-01,-0.5786D-01,-0.4478D-01,-0.3375D-01,
     ,  -0.2441D-01,-0.1651D-01,-0.9804D-02,-0.4135D-02, 0.6207D-03,
     ,   0.4565D-02, 0.7774D-02, 0.1030D-01, 0.1219D-01, 0.1345D-01,
     ,   0.1408D-01, 0.1404D-01, 0.1324D-01, 0.1154D-01, 0.8986D-02,
     ,   0.5778D-02, 0.2550D-02, 0.4697D-04,-0.1177D-02,-0.1014D-02,
     ,   0.2946D-03, 0.2355D-02, 0.4814D-02, 0.7398D-02, 0.9929D-02,
     ,   0.1228D-01, 0.1440D-01, 0.1626D-01, 0.1785D-01, 0.1917D-01,
     ,   0.2028D-01, 0.2116D-01, 0.2189D-01, 0.2247D-01, 0.2292D-01,
     ,   0.2328D-01, 0.2355D-01, 0.2377D-01, 0.2393D-01, 0.2406D-01,
     ,   0.2416D-01, 0.2423D-01, 0.2429D-01, 0.2433D-01, 0.2436D-01,
     ,   0.2439D-01, 0.2441D-01, 0.2442D-01, 0.2443D-01, 0.2443D-01,
     ,   0.2444D-01, 0.2445D-01, 0.2445D-01/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.1773D+01,-0.1463D+01,-0.1208D+01,-0.9966D+00,-0.8222D+00,
     ,  -0.6781D+00,-0.5591D+00,-0.4608D+00,-0.3795D+00,-0.3122D+00,
     ,  -0.2565D+00,-0.2103D+00,-0.1720D+00,-0.1402D+00,-0.1137D+00,
     ,  -0.9163D-01,-0.7316D-01,-0.5766D-01,-0.4463D-01,-0.3363D-01,
     ,  -0.2433D-01,-0.1645D-01,-0.9768D-02,-0.4123D-02, 0.6149D-03,
     ,   0.4553D-02, 0.7752D-02, 0.1027D-01, 0.1215D-01, 0.1340D-01,
     ,   0.1403D-01, 0.1399D-01, 0.1319D-01, 0.1151D-01, 0.8959D-02,
     ,   0.5765D-02, 0.2546D-02, 0.4628D-04,-0.1177D-02,-0.1016D-02,
     ,   0.2898D-03, 0.2346D-02, 0.4801D-02, 0.7385D-02, 0.9914D-02,
     ,   0.1227D-01, 0.1439D-01, 0.1624D-01, 0.1783D-01, 0.1916D-01,
     ,   0.2026D-01, 0.2115D-01, 0.2188D-01, 0.2245D-01, 0.2290D-01,
     ,   0.2326D-01, 0.2354D-01, 0.2375D-01, 0.2392D-01, 0.2405D-01,
     ,   0.2415D-01, 0.2422D-01, 0.2428D-01, 0.2432D-01, 0.2435D-01,
     ,   0.2437D-01, 0.2439D-01, 0.2441D-01, 0.2442D-01, 0.2442D-01,
     ,   0.2443D-01, 0.2443D-01, 0.2443D-01/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.1764D+01,-0.1456D+01,-0.1202D+01,-0.9916D+00,-0.8181D+00,
     ,  -0.6748D+00,-0.5563D+00,-0.4585D+00,-0.3776D+00,-0.3106D+00,
     ,  -0.2552D+00,-0.2093D+00,-0.1712D+00,-0.1395D+00,-0.1132D+00,
     ,  -0.9118D-01,-0.7279D-01,-0.5738D-01,-0.4441D-01,-0.3346D-01,
     ,  -0.2421D-01,-0.1636D-01,-0.9717D-02,-0.4100D-02, 0.6161D-03,
     ,   0.4533D-02, 0.7711D-02, 0.1022D-01, 0.1209D-01, 0.1334D-01,
     ,   0.1396D-01, 0.1393D-01, 0.1313D-01, 0.1146D-01, 0.8916D-02,
     ,   0.5740D-02, 0.2534D-02, 0.4383D-04,-0.1177D-02,-0.1016D-02,
     ,   0.2815D-03, 0.2343D-02, 0.4795D-02, 0.7376D-02, 0.9904D-02,
     ,   0.1225D-01, 0.1437D-01, 0.1622D-01, 0.1781D-01, 0.1914D-01,
     ,   0.2024D-01, 0.2113D-01, 0.2185D-01, 0.2243D-01, 0.2288D-01,
     ,   0.2324D-01, 0.2352D-01, 0.2373D-01, 0.2390D-01, 0.2403D-01,
     ,   0.2413D-01, 0.2420D-01, 0.2426D-01, 0.2429D-01, 0.2433D-01,
     ,   0.2435D-01, 0.2437D-01, 0.2438D-01, 0.2440D-01, 0.2440D-01,
     ,   0.2441D-01, 0.2441D-01, 0.2441D-01/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.1751D+01,-0.1446D+01,-0.1193D+01,-0.9843D+00,-0.8121D+00,
     ,  -0.6698D+00,-0.5523D+00,-0.4551D+00,-0.3748D+00,-0.3084D+00,
     ,  -0.2533D+00,-0.2077D+00,-0.1699D+00,-0.1385D+00,-0.1123D+00,
     ,  -0.9051D-01,-0.7226D-01,-0.5695D-01,-0.4408D-01,-0.3322D-01,
     ,  -0.2403D-01,-0.1625D-01,-0.9649D-02,-0.4074D-02, 0.6143D-03,
     ,   0.4497D-02, 0.7659D-02, 0.1015D-01, 0.1200D-01, 0.1323D-01,
     ,   0.1386D-01, 0.1383D-01, 0.1304D-01, 0.1138D-01, 0.8867D-02,
     ,   0.5713D-02, 0.2521D-02, 0.4253D-04,-0.1175D-02,-0.1018D-02,
     ,   0.2805D-03, 0.2333D-02, 0.4780D-02, 0.7347D-02, 0.9872D-02,
     ,   0.1223D-01, 0.1435D-01, 0.1620D-01, 0.1778D-01, 0.1911D-01,
     ,   0.2021D-01, 0.2110D-01, 0.2182D-01, 0.2240D-01, 0.2285D-01,
     ,   0.2321D-01, 0.2349D-01, 0.2370D-01, 0.2387D-01, 0.2399D-01,
     ,   0.2409D-01, 0.2417D-01, 0.2422D-01, 0.2426D-01, 0.2430D-01,
     ,   0.2432D-01, 0.2434D-01, 0.2435D-01, 0.2436D-01, 0.2437D-01,
     ,   0.2438D-01, 0.2438D-01, 0.2438D-01/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.1733D+01,-0.1430D+01,-0.1180D+01,-0.9739D+00,-0.8035D+00,
     ,  -0.6627D+00,-0.5464D+00,-0.4503D+00,-0.3708D+00,-0.3051D+00,
     ,  -0.2506D+00,-0.2055D+00,-0.1681D+00,-0.1370D+00,-0.1111D+00,
     ,  -0.8955D-01,-0.7149D-01,-0.5635D-01,-0.4361D-01,-0.3287D-01,
     ,  -0.2378D-01,-0.1607D-01,-0.9543D-02,-0.4026D-02, 0.6054D-03,
     ,   0.4455D-02, 0.7577D-02, 0.1004D-01, 0.1188D-01, 0.1310D-01,
     ,   0.1371D-01, 0.1369D-01, 0.1290D-01, 0.1128D-01, 0.8782D-02,
     ,   0.5666D-02, 0.2505D-02, 0.3919D-04,-0.1175D-02,-0.1022D-02,
     ,   0.2631D-03, 0.2314D-02, 0.4753D-02, 0.7326D-02, 0.9838D-02,
     ,   0.1219D-01, 0.1430D-01, 0.1615D-01, 0.1774D-01, 0.1906D-01,
     ,   0.2016D-01, 0.2105D-01, 0.2178D-01, 0.2235D-01, 0.2281D-01,
     ,   0.2316D-01, 0.2344D-01, 0.2366D-01, 0.2382D-01, 0.2395D-01,
     ,   0.2405D-01, 0.2412D-01, 0.2418D-01, 0.2421D-01, 0.2425D-01,
     ,   0.2427D-01, 0.2429D-01, 0.2430D-01, 0.2432D-01, 0.2432D-01,
     ,   0.2433D-01, 0.2433D-01, 0.2433D-01/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.1706D+01,-0.1408D+01,-0.1162D+01,-0.9588D+00,-0.7910D+00,
     ,  -0.6524D+00,-0.5379D+00,-0.4433D+00,-0.3651D+00,-0.3003D+00,
     ,  -0.2468D+00,-0.2023D+00,-0.1655D+00,-0.1349D+00,-0.1094D+00,
     ,  -0.8816D-01,-0.7039D-01,-0.5548D-01,-0.4294D-01,-0.3235D-01,
     ,  -0.2340D-01,-0.1582D-01,-0.9396D-02,-0.3965D-02, 0.5966D-03,
     ,   0.4386D-02, 0.7462D-02, 0.9884D-02, 0.1169D-01, 0.1291D-01,
     ,   0.1351D-01, 0.1348D-01, 0.1272D-01, 0.1112D-01, 0.8675D-02,
     ,   0.5602D-02, 0.2474D-02, 0.3430D-04,-0.1175D-02,-0.1026D-02,
     ,   0.2479D-03, 0.2282D-02, 0.4720D-02, 0.7275D-02, 0.9793D-02,
     ,   0.1213D-01, 0.1424D-01, 0.1609D-01, 0.1767D-01, 0.1900D-01,
     ,   0.2010D-01, 0.2099D-01, 0.2171D-01, 0.2228D-01, 0.2274D-01,
     ,   0.2309D-01, 0.2337D-01, 0.2359D-01, 0.2375D-01, 0.2388D-01,
     ,   0.2398D-01, 0.2405D-01, 0.2411D-01, 0.2415D-01, 0.2418D-01,
     ,   0.2421D-01, 0.2422D-01, 0.2424D-01, 0.2424D-01, 0.2426D-01,
     ,   0.2426D-01, 0.2427D-01, 0.2427D-01/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.1668D+01,-0.1376D+01,-0.1136D+01,-0.9373D+00,-0.7733D+00,
     ,  -0.6378D+00,-0.5259D+00,-0.4334D+00,-0.3569D+00,-0.2936D+00,
     ,  -0.2412D+00,-0.1978D+00,-0.1618D+00,-0.1319D+00,-0.1070D+00,
     ,  -0.8618D-01,-0.6880D-01,-0.5423D-01,-0.4197D-01,-0.3163D-01,
     ,  -0.2288D-01,-0.1546D-01,-0.9181D-02,-0.3871D-02, 0.5875D-03,
     ,   0.4287D-02, 0.7301D-02, 0.9666D-02, 0.1144D-01, 0.1262D-01,
     ,   0.1321D-01, 0.1319D-01, 0.1245D-01, 0.1089D-01, 0.8510D-02,
     ,   0.5501D-02, 0.2436D-02, 0.2712D-04,-0.1173D-02,-0.1033D-02,
     ,   0.2310D-03, 0.2252D-02, 0.4662D-02, 0.7216D-02, 0.9718D-02,
     ,   0.1205D-01, 0.1416D-01, 0.1601D-01, 0.1758D-01, 0.1891D-01,
     ,   0.2000D-01, 0.2090D-01, 0.2161D-01, 0.2219D-01, 0.2264D-01,
     ,   0.2300D-01, 0.2327D-01, 0.2349D-01, 0.2365D-01, 0.2378D-01,
     ,   0.2388D-01, 0.2396D-01, 0.2401D-01, 0.2405D-01, 0.2409D-01,
     ,   0.2411D-01, 0.2413D-01, 0.2414D-01, 0.2415D-01, 0.2416D-01,
     ,   0.2417D-01, 0.2416D-01, 0.2417D-01/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.1614D+01,-0.1332D+01,-0.1099D+01,-0.9070D+00,-0.7483D+00,
     ,  -0.6172D+00,-0.5089D+00,-0.4194D+00,-0.3454D+00,-0.2841D+00,
     ,  -0.2334D+00,-0.1914D+00,-0.1566D+00,-0.1276D+00,-0.1035D+00,
     ,  -0.8340D-01,-0.6658D-01,-0.5248D-01,-0.4062D-01,-0.3060D-01,
     ,  -0.2214D-01,-0.1497D-01,-0.8881D-02,-0.3742D-02, 0.5741D-03,
     ,   0.4155D-02, 0.7069D-02, 0.9359D-02, 0.1107D-01, 0.1221D-01,
     ,   0.1279D-01, 0.1278D-01, 0.1207D-01, 0.1057D-01, 0.8268D-02,
     ,   0.5361D-02, 0.2381D-02, 0.1607D-04,-0.1173D-02,-0.1041D-02,
     ,   0.2055D-03, 0.2192D-02, 0.4588D-02, 0.7117D-02, 0.9609D-02,
     ,   0.1194D-01, 0.1404D-01, 0.1588D-01, 0.1745D-01, 0.1877D-01,
     ,   0.1987D-01, 0.2076D-01, 0.2148D-01, 0.2204D-01, 0.2250D-01,
     ,   0.2286D-01, 0.2313D-01, 0.2335D-01, 0.2351D-01, 0.2364D-01,
     ,   0.2374D-01, 0.2381D-01, 0.2387D-01, 0.2391D-01, 0.2394D-01,
     ,   0.2397D-01, 0.2398D-01, 0.2400D-01, 0.2401D-01, 0.2402D-01,
     ,   0.2402D-01, 0.2402D-01, 0.2403D-01/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.1539D+01,-0.1270D+01,-0.1048D+01,-0.8651D+00,-0.7137D+00,
     ,  -0.5887D+00,-0.4854D+00,-0.4000D+00,-0.3294D+00,-0.2710D+00,
     ,  -0.2227D+00,-0.1826D+00,-0.1493D+00,-0.1217D+00,-0.9873D-01,
     ,  -0.7954D-01,-0.6351D-01,-0.5005D-01,-0.3874D-01,-0.2919D-01,
     ,  -0.2111D-01,-0.1427D-01,-0.8470D-02,-0.3568D-02, 0.5499D-03,
     ,   0.3967D-02, 0.6744D-02, 0.8932D-02, 0.1056D-01, 0.1165D-01,
     ,   0.1221D-01, 0.1220D-01, 0.1153D-01, 0.1013D-01, 0.7950D-02,
     ,   0.5168D-02, 0.2292D-02,-0.1503D-05,-0.1170D-02,-0.1056D-02,
     ,   0.1546D-03, 0.2121D-02, 0.4483D-02, 0.6990D-02, 0.9460D-02,
     ,   0.1177D-01, 0.1386D-01, 0.1569D-01, 0.1726D-01, 0.1858D-01,
     ,   0.1967D-01, 0.2056D-01, 0.2127D-01, 0.2185D-01, 0.2230D-01,
     ,   0.2265D-01, 0.2293D-01, 0.2314D-01, 0.2331D-01, 0.2344D-01,
     ,   0.2353D-01, 0.2361D-01, 0.2366D-01, 0.2371D-01, 0.2374D-01,
     ,   0.2376D-01, 0.2378D-01, 0.2379D-01, 0.2380D-01, 0.2381D-01,
     ,   0.2381D-01, 0.2382D-01, 0.2382D-01/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.1439D+01,-0.1188D+01,-0.9801D+00,-0.8087D+00,-0.6672D+00,
     ,  -0.5503D+00,-0.4538D+00,-0.3739D+00,-0.3079D+00,-0.2533D+00,
     ,  -0.2081D+00,-0.1707D+00,-0.1396D+00,-0.1138D+00,-0.9229D-01,
     ,  -0.7436D-01,-0.5937D-01,-0.4679D-01,-0.3621D-01,-0.2729D-01,
     ,  -0.1974D-01,-0.1334D-01,-0.7917D-02,-0.3335D-02, 0.5154D-03,
     ,   0.3712D-02, 0.6310D-02, 0.8354D-02, 0.9878D-02, 0.1090D-01,
     ,   0.1143D-01, 0.1142D-01, 0.1081D-01, 0.9518D-02, 0.7497D-02,
     ,   0.4896D-02, 0.2177D-02,-0.2873D-04,-0.1173D-02,-0.1079D-02,
     ,   0.9313D-04, 0.2009D-02, 0.4325D-02, 0.6801D-02, 0.9243D-02,
     ,   0.1154D-01, 0.1360D-01, 0.1543D-01, 0.1699D-01, 0.1830D-01,
     ,   0.1939D-01, 0.2027D-01, 0.2098D-01, 0.2155D-01, 0.2201D-01,
     ,   0.2236D-01, 0.2263D-01, 0.2285D-01, 0.2302D-01, 0.2314D-01,
     ,   0.2324D-01, 0.2331D-01, 0.2337D-01, 0.2341D-01, 0.2344D-01,
     ,   0.2347D-01, 0.2348D-01, 0.2350D-01, 0.2351D-01, 0.2352D-01,
     ,   0.2352D-01, 0.2353D-01, 0.2353D-01/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.1309D+01,-0.1080D+01,-0.8913D+00,-0.7355D+00,-0.6068D+00,
     ,  -0.5005D+00,-0.4126D+00,-0.3401D+00,-0.2800D+00,-0.2304D+00,
     ,  -0.1893D+00,-0.1552D+00,-0.1270D+00,-0.1035D+00,-0.8393D-01,
     ,  -0.6762D-01,-0.5399D-01,-0.4255D-01,-0.3293D-01,-0.2481D-01,
     ,  -0.1795D-01,-0.1213D-01,-0.7195D-02,-0.3029D-02, 0.4727D-03,
     ,   0.3381D-02, 0.5745D-02, 0.7602D-02, 0.8988D-02, 0.9918D-02,
     ,   0.1039D-01, 0.1040D-01, 0.9865D-02, 0.8710D-02, 0.6888D-02,
     ,   0.4525D-02, 0.2005D-02,-0.7069D-04,-0.1178D-02,-0.1112D-02,
     ,   0.4466D-05, 0.1853D-02, 0.4112D-02, 0.6528D-02, 0.8935D-02,
     ,   0.1120D-01, 0.1324D-01, 0.1505D-01, 0.1660D-01, 0.1790D-01,
     ,   0.1899D-01, 0.1987D-01, 0.2058D-01, 0.2114D-01, 0.2159D-01,
     ,   0.2195D-01, 0.2222D-01, 0.2244D-01, 0.2261D-01, 0.2273D-01,
     ,   0.2282D-01, 0.2290D-01, 0.2296D-01, 0.2299D-01, 0.2303D-01,
     ,   0.2305D-01, 0.2307D-01, 0.2309D-01, 0.2310D-01, 0.2310D-01,
     ,   0.2311D-01, 0.2311D-01, 0.2311D-01/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.1147D+01,-0.9467D+00,-0.7813D+00,-0.6447D+00,-0.5319D+00,
     ,  -0.4387D+00,-0.3617D+00,-0.2981D+00,-0.2455D+00,-0.2020D+00,
     ,  -0.1659D+00,-0.1361D+00,-0.1113D+00,-0.9070D-01,-0.7357D-01,
     ,  -0.5928D-01,-0.4732D-01,-0.3730D-01,-0.2887D-01,-0.2175D-01,
     ,  -0.1573D-01,-0.1063D-01,-0.6305D-02,-0.2648D-02, 0.4189D-03,
     ,   0.2963D-02, 0.5035D-02, 0.6664D-02, 0.7881D-02, 0.8695D-02,
     ,   0.9110D-02, 0.9120D-02, 0.8669D-02, 0.7680D-02, 0.6110D-02,
     ,   0.4031D-02, 0.1776D-02,-0.1370D-03,-0.1193D-02,-0.1162D-02,
     ,  -0.1275D-03, 0.1629D-02, 0.3810D-02, 0.6159D-02, 0.8505D-02,
     ,   0.1073D-01, 0.1275D-01, 0.1453D-01, 0.1606D-01, 0.1736D-01,
     ,   0.1843D-01, 0.1931D-01, 0.2001D-01, 0.2058D-01, 0.2102D-01,
     ,   0.2137D-01, 0.2165D-01, 0.2187D-01, 0.2203D-01, 0.2216D-01,
     ,   0.2225D-01, 0.2232D-01, 0.2238D-01, 0.2242D-01, 0.2245D-01,
     ,   0.2248D-01, 0.2249D-01, 0.2251D-01, 0.2252D-01, 0.2253D-01,
     ,   0.2253D-01, 0.2253D-01, 0.2254D-01/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.9592D+00,-0.7917D+00,-0.6533D+00,-0.5391D+00,-0.4448D+00,
     ,  -0.3668D+00,-0.3025D+00,-0.2493D+00,-0.2053D+00,-0.1689D+00,
     ,  -0.1387D+00,-0.1138D+00,-0.9306D-01,-0.7585D-01,-0.6152D-01,
     ,  -0.4957D-01,-0.3957D-01,-0.3119D-01,-0.2413D-01,-0.1819D-01,
     ,  -0.1315D-01,-0.8887D-02,-0.5270D-02,-0.2216D-02, 0.3517D-03,
     ,   0.2480D-02, 0.4211D-02, 0.5570D-02, 0.6580D-02, 0.7257D-02,
     ,   0.7611D-02, 0.7622D-02, 0.7255D-02, 0.6449D-02, 0.5155D-02,
     ,   0.3417D-02, 0.1472D-02,-0.2334D-03,-0.1221D-02,-0.1233D-02,
     ,  -0.3033D-03, 0.1339D-02, 0.3412D-02, 0.5669D-02, 0.7933D-02,
     ,   0.1010D-01, 0.1207D-01, 0.1382D-01, 0.1533D-01, 0.1661D-01,
     ,   0.1767D-01, 0.1854D-01, 0.1924D-01, 0.1981D-01, 0.2025D-01,
     ,   0.2060D-01, 0.2087D-01, 0.2108D-01, 0.2125D-01, 0.2137D-01,
     ,   0.2147D-01, 0.2154D-01, 0.2160D-01, 0.2164D-01, 0.2167D-01,
     ,   0.2170D-01, 0.2171D-01, 0.2172D-01, 0.2173D-01, 0.2174D-01,
     ,   0.2174D-01, 0.2175D-01, 0.2175D-01/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.7571D+00,-0.6249D+00,-0.5157D+00,-0.4255D+00,-0.3511D+00,
     ,  -0.2896D+00,-0.2387D+00,-0.1967D+00,-0.1620D+00,-0.1333D+00,
     ,  -0.1095D+00,-0.8980D-01,-0.7345D-01,-0.5987D-01,-0.4856D-01,
     ,  -0.3913D-01,-0.3123D-01,-0.2462D-01,-0.1905D-01,-0.1436D-01,
     ,  -0.1039D-01,-0.7017D-02,-0.4166D-02,-0.1756D-02, 0.2695D-03,
     ,   0.1948D-02, 0.3312D-02, 0.4381D-02, 0.5179D-02, 0.5706D-02,
     ,   0.5975D-02, 0.5982D-02, 0.5703D-02, 0.5081D-02, 0.4073D-02,
     ,   0.2694D-02, 0.1098D-02,-0.3631D-03,-0.1266D-02,-0.1327D-02,
     ,  -0.5229D-03, 0.9728D-03, 0.2896D-02, 0.5022D-02, 0.7186D-02,
     ,   0.9273D-02, 0.1118D-01, 0.1290D-01, 0.1437D-01, 0.1563D-01,
     ,   0.1668D-01, 0.1753D-01, 0.1823D-01, 0.1879D-01, 0.1922D-01,
     ,   0.1957D-01, 0.1984D-01, 0.2005D-01, 0.2021D-01, 0.2034D-01,
     ,   0.2044D-01, 0.2051D-01, 0.2056D-01, 0.2060D-01, 0.2064D-01,
     ,   0.2066D-01, 0.2068D-01, 0.2069D-01, 0.2070D-01, 0.2070D-01,
     ,   0.2071D-01, 0.2072D-01, 0.2072D-01/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.5590D+00,-0.4614D+00,-0.3808D+00,-0.3142D+00,-0.2592D+00,
     ,  -0.2138D+00,-0.1763D+00,-0.1453D+00,-0.1196D+00,-0.9842D-01,
     ,  -0.8086D-01,-0.6631D-01,-0.5424D-01,-0.4421D-01,-0.3586D-01,
     ,  -0.2889D-01,-0.2307D-01,-0.1818D-01,-0.1407D-01,-0.1060D-01,
     ,  -0.7673D-02,-0.5190D-02,-0.3084D-02,-0.1306D-02, 0.1895D-03,
     ,   0.1424D-02, 0.2428D-02, 0.3213D-02, 0.3795D-02, 0.4177D-02,
     ,   0.4366D-02, 0.4366D-02, 0.4150D-02, 0.3697D-02, 0.2954D-02,
     ,   0.1916D-02, 0.6763D-03,-0.5233D-03,-0.1322D-02,-0.1439D-02,
     ,  -0.7870D-03, 0.5172D-03, 0.2263D-02, 0.4228D-02, 0.6260D-02,
     ,   0.8239D-02, 0.1008D-01, 0.1173D-01, 0.1317D-01, 0.1440D-01,
     ,   0.1542D-01, 0.1626D-01, 0.1694D-01, 0.1749D-01, 0.1792D-01,
     ,   0.1827D-01, 0.1854D-01, 0.1875D-01, 0.1891D-01, 0.1903D-01,
     ,   0.1913D-01, 0.1920D-01, 0.1925D-01, 0.1929D-01, 0.1932D-01,
     ,   0.1934D-01, 0.1936D-01, 0.1938D-01, 0.1939D-01, 0.1940D-01,
     ,   0.1940D-01, 0.1940D-01, 0.1941D-01/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.3840D+00,-0.3169D+00,-0.2616D+00,-0.2158D+00,-0.1781D+00,
     ,  -0.1469D+00,-0.1211D+00,-0.9979D-01,-0.8218D-01,-0.6761D-01,
     ,  -0.5555D-01,-0.4555D-01,-0.3726D-01,-0.3037D-01,-0.2463D-01,
     ,  -0.1985D-01,-0.1585D-01,-0.1249D-01,-0.9672D-02,-0.7291D-02,
     ,  -0.5279D-02,-0.3572D-02,-0.2128D-02,-0.9078D-03, 0.1154D-03,
     ,   0.9594D-03, 0.1644D-02, 0.2178D-02, 0.2569D-02, 0.2823D-02,
     ,   0.2942D-02, 0.2926D-02, 0.2765D-02, 0.2439D-02, 0.1917D-02,
     ,   0.1176D-02, 0.2567D-03,-0.6834D-03,-0.1374D-02,-0.1547D-02,
     ,  -0.1062D-02, 0.2093D-04, 0.1541D-02, 0.3310D-02, 0.5180D-02,
     ,   0.7019D-02, 0.8757D-02, 0.1033D-01, 0.1172D-01, 0.1291D-01,
     ,   0.1390D-01, 0.1473D-01, 0.1539D-01, 0.1593D-01, 0.1636D-01,
     ,   0.1670D-01, 0.1696D-01, 0.1717D-01, 0.1733D-01, 0.1745D-01,
     ,   0.1754D-01, 0.1762D-01, 0.1767D-01, 0.1771D-01, 0.1774D-01,
     ,   0.1776D-01, 0.1778D-01, 0.1780D-01, 0.1780D-01, 0.1781D-01,
     ,   0.1782D-01, 0.1782D-01, 0.1782D-01/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.2453D+00,-0.2024D+00,-0.1671D+00,-0.1379D+00,-0.1137D+00,
     ,  -0.9380D-01,-0.7734D-01,-0.6374D-01,-0.5249D-01,-0.4318D-01,
     ,  -0.3548D-01,-0.2910D-01,-0.2380D-01,-0.1940D-01,-0.1574D-01,
     ,  -0.1268D-01,-0.1013D-01,-0.7984D-02,-0.6183D-02,-0.4664D-02,
     ,  -0.3379D-02,-0.2291D-02,-0.1371D-02,-0.5951D-03, 0.5503D-04,
     ,   0.5917D-03, 0.1024D-02, 0.1358D-02, 0.1600D-02, 0.1751D-02,
     ,   0.1814D-02, 0.1788D-02, 0.1667D-02, 0.1437D-02, 0.1076D-02,
     ,   0.5631D-03,-0.9297D-04,-0.8056D-03,-0.1390D-02,-0.1614D-02,
     ,  -0.1315D-02,-0.4759D-03, 0.7837D-03, 0.2321D-02, 0.3987D-02,
     ,   0.5667D-02, 0.7276D-02, 0.8756D-02, 0.1007D-01, 0.1121D-01,
     ,   0.1217D-01, 0.1297D-01, 0.1362D-01, 0.1415D-01, 0.1457D-01,
     ,   0.1490D-01, 0.1516D-01, 0.1536D-01, 0.1552D-01, 0.1564D-01,
     ,   0.1573D-01, 0.1580D-01, 0.1585D-01, 0.1589D-01, 0.1593D-01,
     ,   0.1594D-01, 0.1596D-01, 0.1598D-01, 0.1598D-01, 0.1600D-01,
     ,   0.1600D-01, 0.1600D-01, 0.1601D-01/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.1463D+00,-0.1208D+00,-0.9966D-01,-0.8223D-01,-0.6784D-01,
     ,  -0.5596D-01,-0.4614D-01,-0.3802D-01,-0.3131D-01,-0.2576D-01,
     ,  -0.2117D-01,-0.1736D-01,-0.1420D-01,-0.1157D-01,-0.9389D-02,
     ,  -0.7567D-02,-0.6044D-02,-0.4767D-02,-0.3693D-02,-0.2788D-02,
     ,  -0.2023D-02,-0.1376D-02,-0.8294D-03,-0.3686D-03, 0.1616D-04,
     ,   0.3324D-03, 0.5857D-03, 0.7796D-03, 0.9163D-03, 0.9971D-03,
     ,   0.1022D-02, 0.9913D-03, 0.8992D-03, 0.7378D-03, 0.4903D-03,
     ,   0.1391D-03,-0.3209D-03,-0.8507D-03,-0.1337D-02,-0.1603D-02,
     ,  -0.1478D-02,-0.8977D-03, 0.8749D-04, 0.1358D-02, 0.2788D-02,
     ,   0.4273D-02, 0.5728D-02, 0.7093D-02, 0.8324D-02, 0.9403D-02,
     ,   0.1032D-01, 0.1108D-01, 0.1171D-01, 0.1223D-01, 0.1263D-01,
     ,   0.1295D-01, 0.1321D-01, 0.1341D-01, 0.1356D-01, 0.1368D-01,
     ,   0.1377D-01, 0.1384D-01, 0.1389D-01, 0.1393D-01, 0.1396D-01,
     ,   0.1398D-01, 0.1400D-01, 0.1402D-01, 0.1402D-01, 0.1403D-01,
     ,   0.1403D-01, 0.1404D-01, 0.1404D-01/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.8220D-01,-0.6784D-01,-0.5599D-01,-0.4620D-01,-0.3812D-01,
     ,  -0.3144D-01,-0.2592D-01,-0.2136D-01,-0.1759D-01,-0.1447D-01,
     ,  -0.1189D-01,-0.9753D-02,-0.7978D-02,-0.6504D-02,-0.5277D-02,
     ,  -0.4254D-02,-0.3398D-02,-0.2682D-02,-0.2079D-02,-0.1572D-02,
     ,  -0.1143D-02,-0.7808D-03,-0.4751D-03,-0.2183D-03,-0.4564D-05,
     ,   0.1703D-03, 0.3089D-03, 0.4131D-03, 0.4839D-03, 0.5219D-03,
     ,   0.5264D-03, 0.4962D-03, 0.4278D-03, 0.3148D-03, 0.1455D-03,
     ,  -0.9383D-04,-0.4146D-03,-0.8037D-03,-0.1201D-02,-0.1486D-02,
     ,  -0.1513D-02,-0.1178D-02,-0.4794D-03, 0.5091D-03, 0.1682D-02,
     ,   0.2947D-02, 0.4223D-02, 0.5449D-02, 0.6577D-02, 0.7578D-02,
     ,   0.8443D-02, 0.9176D-02, 0.9778D-02, 0.1026D-01, 0.1066D-01,
     ,   0.1097D-01, 0.1122D-01, 0.1142D-01, 0.1156D-01, 0.1168D-01,
     ,   0.1177D-01, 0.1184D-01, 0.1189D-01, 0.1193D-01, 0.1196D-01,
     ,   0.1198D-01, 0.1200D-01, 0.1201D-01, 0.1202D-01, 0.1203D-01,
     ,   0.1203D-01, 0.1203D-01, 0.1204D-01/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.4395D-01,-0.3627D-01,-0.2993D-01,-0.2470D-01,-0.2038D-01,
     ,  -0.1681D-01,-0.1386D-01,-0.1142D-01,-0.9406D-02,-0.7739D-02,
     ,  -0.6359D-02,-0.5215D-02,-0.4267D-02,-0.3479D-02,-0.2823D-02,
     ,  -0.2276D-02,-0.1819D-02,-0.1436D-02,-0.1115D-02,-0.8441D-03,
     ,  -0.6157D-03,-0.4231D-03,-0.2609D-03,-0.1250D-03,-0.1245D-04,
     ,   0.7882D-04, 0.1502D-03, 0.2026D-03, 0.2363D-03, 0.2511D-03,
     ,   0.2466D-03, 0.2212D-03, 0.1722D-03, 0.9475D-04,-0.1950D-04,
     ,  -0.1812D-03,-0.4023D-03,-0.6838D-03,-0.9991D-03,-0.1278D-02,
     ,  -0.1408D-02,-0.1283D-02,-0.8542D-03,-0.1490D-03, 0.7585D-03,
     ,   0.1786D-02, 0.2863D-02, 0.3929D-02, 0.4936D-02, 0.5850D-02,
     ,   0.6652D-02, 0.7336D-02, 0.7907D-02, 0.8375D-02, 0.8752D-02,
     ,   0.9055D-02, 0.9292D-02, 0.9480D-02, 0.9627D-02, 0.9740D-02,
     ,   0.9827D-02, 0.9895D-02, 0.9943D-02, 0.9985D-02, 0.1001D-01,
     ,   0.1003D-01, 0.1005D-01, 0.1006D-01, 0.1007D-01, 0.1008D-01,
     ,   0.1009D-01, 0.1009D-01, 0.1009D-01/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.2260D-01,-0.1865D-01,-0.1539D-01,-0.1270D-01,-0.1048D-01,
     ,  -0.8643D-02,-0.7127D-02,-0.5873D-02,-0.4837D-02,-0.3980D-02,
     ,  -0.3270D-02,-0.2682D-02,-0.2195D-02,-0.1789D-02,-0.1452D-02,
     ,  -0.1172D-02,-0.9369D-03,-0.7403D-03,-0.5753D-03,-0.4366D-03,
     ,  -0.3196D-03,-0.2212D-03,-0.1386D-03,-0.6967D-04,-0.1299D-04,
     ,   0.3253D-04, 0.6742D-04, 0.9216D-04, 0.1067D-03, 0.1108D-03,
     ,   0.1038D-03, 0.8464D-04, 0.5105D-04,-0.2412D-06,-0.7533D-04,
     ,  -0.1827D-03,-0.3317D-03,-0.5298D-03,-0.7688D-03,-0.1015D-02,
     ,  -0.1196D-02,-0.1220D-02,-0.1017D-02,-0.5720D-03, 0.7541D-04,
     ,   0.8634D-03, 0.1730D-02, 0.2622D-02, 0.3493D-02, 0.4305D-02,
     ,   0.5033D-02, 0.5666D-02, 0.6199D-02, 0.6642D-02, 0.7002D-02,
     ,   0.7291D-02, 0.7520D-02, 0.7700D-02, 0.7842D-02, 0.7951D-02,
     ,   0.8035D-02, 0.8101D-02, 0.8150D-02, 0.8187D-02, 0.8216D-02,
     ,   0.8238D-02, 0.8253D-02, 0.8265D-02, 0.8275D-02, 0.8281D-02,
     ,   0.8286D-02, 0.8290D-02, 0.8293D-02/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.1128D-01,-0.9312D-02,-0.7685D-02,-0.6341D-02,-0.5232D-02,
     ,  -0.4315D-02,-0.3558D-02,-0.2932D-02,-0.2415D-02,-0.1987D-02,
     ,  -0.1633D-02,-0.1339D-02,-0.1096D-02,-0.8939D-03,-0.7257D-03,
     ,  -0.5856D-03,-0.4686D-03,-0.3706D-03,-0.2885D-03,-0.2195D-03,
     ,  -0.1614D-03,-0.1127D-03,-0.7195D-04,-0.3810D-04,-0.1054D-04,
     ,   0.1127D-04, 0.2767D-04, 0.3862D-04, 0.4416D-04, 0.4401D-04,
     ,   0.3771D-04, 0.2433D-04, 0.2410D-05,-0.3048D-04,-0.7837D-04,
     ,  -0.1472D-03,-0.2449D-03,-0.3788D-03,-0.5513D-03,-0.7485D-03,
     ,  -0.9326D-03,-0.1040D-02,-0.9998D-03,-0.7703D-03,-0.3561D-03,
     ,   0.2046D-03, 0.8627D-03, 0.1574D-02, 0.2298D-02, 0.2997D-02,
     ,   0.3641D-02, 0.4214D-02, 0.4705D-02, 0.5119D-02, 0.5457D-02,
     ,   0.5731D-02, 0.5950D-02, 0.6123D-02, 0.6259D-02, 0.6364D-02,
     ,   0.6447D-02, 0.6509D-02, 0.6557D-02, 0.6594D-02, 0.6622D-02,
     ,   0.6652D-02, 0.6658D-02, 0.6670D-02, 0.6679D-02, 0.6686D-02,
     ,   0.6691D-02, 0.6695D-02, 0.6698D-02/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.5512D-02,-0.4549D-02,-0.3754D-02,-0.3098D-02,-0.2556D-02,
     ,  -0.2108D-02,-0.1738D-02,-0.1433D-02,-0.1180D-02,-0.9710D-03,
     ,  -0.7979D-03,-0.6546D-03,-0.5357D-03,-0.4370D-03,-0.3549D-03,
     ,  -0.2865D-03,-0.2294D-03,-0.1817D-03,-0.1417D-03,-0.1081D-03,
     ,  -0.7999D-04,-0.5639D-04,-0.3677D-04,-0.2058D-04,-0.7549D-05,
     ,   0.2590D-05, 0.9959D-05, 0.1454D-04, 0.1623D-04, 0.1489D-04,
     ,   0.1012D-04, 0.1333D-05,-0.1235D-04,-0.3261D-04,-0.6229D-04,
     ,  -0.1051D-03,-0.1668D-03,-0.2540D-03,-0.3714D-03,-0.5172D-03,
     ,  -0.6747D-03,-0.8074D-03,-0.8614D-03,-0.7879D-03,-0.5645D-03,
     ,  -0.2043D-03, 0.2620D-03, 0.7974D-03, 0.1370D-02, 0.1947D-02,
     ,   0.2499D-02, 0.3004D-02, 0.3448D-02, 0.3827D-02, 0.4143D-02,
     ,   0.4400D-02, 0.4608D-02, 0.4773D-02, 0.4902D-02, 0.5003D-02,
     ,   0.5082D-02, 0.5143D-02, 0.5189D-02, 0.5225D-02, 0.5252D-02,
     ,   0.5279D-02, 0.5288D-02, 0.5299D-02, 0.5308D-02, 0.5315D-02,
     ,   0.5319D-02, 0.5323D-02, 0.5326D-02/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.2651D-02,-0.2188D-02,-0.1806D-02,-0.1490D-02,-0.1229D-02,
     ,  -0.1014D-02,-0.8363D-03,-0.6892D-03,-0.5677D-03,-0.4671D-03,
     ,  -0.3839D-03,-0.3150D-03,-0.2578D-03,-0.2104D-03,-0.1709D-03,
     ,  -0.1381D-03,-0.1106D-03,-0.8774D-04,-0.6856D-04,-0.5252D-04,
     ,  -0.3909D-04,-0.2786D-04,-0.1860D-04,-0.1100D-04,-0.4964D-05,
     ,  -0.3608D-06, 0.2818D-05, 0.4549D-05, 0.4827D-05, 0.3456D-05,
     ,   0.2330D-06,-0.5232D-05,-0.1351D-04,-0.2570D-04,-0.4342D-04,
     ,  -0.6928D-04,-0.1070D-03,-0.1615D-03,-0.2376D-03,-0.3378D-03,
     ,  -0.4576D-03,-0.5797D-03,-0.6715D-03,-0.6906D-03,-0.6047D-03,
     ,  -0.4038D-03,-0.1035D-03, 0.2731D-03, 0.7002D-03, 0.1153D-02,
     ,   0.1607D-02, 0.2039D-02, 0.2429D-02, 0.2770D-02, 0.3060D-02,
     ,   0.3299D-02, 0.3493D-02, 0.3650D-02, 0.3773D-02, 0.3870D-02,
     ,   0.3945D-02, 0.4003D-02, 0.4048D-02, 0.4082D-02, 0.4109D-02,
     ,   0.4133D-02, 0.4144D-02, 0.4155D-02, 0.4163D-02, 0.4169D-02,
     ,   0.4175D-02, 0.4178D-02, 0.4180D-02/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.1261D-02,-0.1041D-02,-0.8592D-03,-0.7090D-03,-0.5850D-03,
     ,  -0.4825D-03,-0.3979D-03,-0.3279D-03,-0.2701D-03,-0.2223D-03,
     ,  -0.1827D-03,-0.1499D-03,-0.1227D-03,-0.1002D-03,-0.8141D-04,
     ,  -0.6581D-04,-0.5279D-04,-0.4193D-04,-0.3285D-04,-0.2526D-04,
     ,  -0.1893D-04,-0.1367D-04,-0.9334D-05,-0.5830D-05,-0.3084D-05,
     ,  -0.1058D-05, 0.2604D-06, 0.8510D-06, 0.6707D-06,-0.3686D-06,
     ,  -0.2407D-05,-0.5677D-05,-0.1055D-04,-0.1765D-04,-0.2798D-04,
     ,  -0.4316D-04,-0.6551D-04,-0.9835D-04,-0.1455D-03,-0.2106D-03,
     ,  -0.2939D-03,-0.3898D-03,-0.4817D-03,-0.5421D-03,-0.5403D-03,
     ,  -0.4545D-03,-0.2837D-03,-0.4007D-04, 0.2576D-03, 0.5930D-03,
     ,   0.9467D-03, 0.1299D-02, 0.1632D-02, 0.1932D-02, 0.2193D-02,
     ,   0.2412D-02, 0.2593D-02, 0.2738D-02, 0.2855D-02, 0.2946D-02,
     ,   0.3019D-02, 0.3074D-02, 0.3117D-02, 0.3150D-02, 0.3175D-02,
     ,   0.3198D-02, 0.3209D-02, 0.3220D-02, 0.3228D-02, 0.3235D-02,
     ,   0.3239D-02, 0.3242D-02, 0.3245D-02/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.5955D-03,-0.4915D-03,-0.4056D-03,-0.3347D-03,-0.2762D-03,
     ,  -0.2278D-03,-0.1878D-03,-0.1548D-03,-0.1275D-03,-0.1050D-03,
     ,  -0.8628D-04,-0.7080D-04,-0.5798D-04,-0.4734D-04,-0.3849D-04,
     ,  -0.3114D-04,-0.2501D-04,-0.1990D-04,-0.1563D-04,-0.1207D-04,
     ,  -0.9114D-05,-0.6669D-05,-0.4670D-05,-0.3070D-05,-0.1843D-05,
     ,  -0.9714D-06,-0.4514D-06,-0.3002D-06,-0.5486D-06,-0.1247D-05,
     ,  -0.2477D-05,-0.4378D-05,-0.7157D-05,-0.1122D-04,-0.1711D-04,
     ,  -0.2578D-04,-0.3874D-04,-0.5799D-04,-0.8621D-04,-0.1264D-03,
     ,  -0.1807D-03,-0.2485D-03,-0.3234D-03,-0.3905D-03,-0.4286D-03,
     ,  -0.4151D-03,-0.3375D-03,-0.1964D-03,-0.4255D-05, 0.2278D-03,
     ,   0.4882D-03, 0.7611D-03, 0.1033D-02, 0.1287D-02, 0.1516D-02,
     ,   0.1713D-02, 0.1878D-02, 0.2014D-02, 0.2122D-02, 0.2209D-02,
     ,   0.2277D-02, 0.2330D-02, 0.2371D-02, 0.2403D-02, 0.2427D-02,
     ,   0.2448D-02, 0.2459D-02, 0.2470D-02, 0.2478D-02, 0.2484D-02,
     ,   0.2489D-02, 0.2491D-02, 0.2495D-02/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.2797D-03,-0.2308D-03,-0.1905D-03,-0.1572D-03,-0.1297D-03,
     ,  -0.1070D-03,-0.8822D-04,-0.7272D-04,-0.5990D-04,-0.4930D-04,
     ,  -0.4053D-04,-0.3327D-04,-0.2725D-04,-0.2225D-04,-0.1811D-04,
     ,  -0.1466D-04,-0.1179D-04,-0.9394D-05,-0.7403D-05,-0.5746D-05,
     ,  -0.4371D-05,-0.3243D-05,-0.2327D-05,-0.1606D-05,-0.1066D-05,
     ,  -0.6996D-06,-0.5094D-06,-0.5056D-06,-0.7071D-06,-0.1140D-05,
     ,  -0.1860D-05,-0.2938D-05,-0.4504D-05,-0.6769D-05,-0.1006D-04,
     ,  -0.1495D-04,-0.2226D-04,-0.3325D-04,-0.4961D-04,-0.7352D-04,
     ,  -0.1070D-03,-0.1514D-03,-0.2053D-03,-0.2624D-03,-0.3107D-03,
     ,  -0.3333D-03,-0.3143D-03,-0.2472D-03,-0.1345D-03, 0.1526D-04,
     ,   0.1942D-03, 0.3936D-03, 0.6030D-03, 0.8104D-03, 0.1004D-02,
     ,   0.1177D-02, 0.1325D-02, 0.1449D-02, 0.1549D-02, 0.1630D-02,
     ,   0.1694D-02, 0.1744D-02, 0.1783D-02, 0.1814D-02, 0.1837D-02,
     ,   0.1856D-02, 0.1868D-02, 0.1878D-02, 0.1886D-02, 0.1892D-02,
     ,   0.1896D-02, 0.1899D-02, 0.1902D-02/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.1308D-03,-0.1080D-03,-0.8913D-04,-0.7355D-04,-0.6068D-04,
     ,  -0.5006D-04,-0.4128D-04,-0.3403D-04,-0.2803D-04,-0.2307D-04,
     ,  -0.1897D-04,-0.1557D-04,-0.1276D-04,-0.1042D-04,-0.8486D-05,
     ,  -0.6876D-05,-0.5536D-05,-0.4422D-05,-0.3496D-05,-0.2727D-05,
     ,  -0.2093D-05,-0.1574D-05,-0.1158D-05,-0.8357D-06,-0.6011D-06,
     ,  -0.4521D-06,-0.3909D-06,-0.4232D-06,-0.5605D-06,-0.8192D-06,
     ,  -0.1227D-05,-0.1827D-05,-0.2691D-05,-0.3936D-05,-0.5756D-05,
     ,  -0.8444D-05,-0.1251D-04,-0.1865D-04,-0.2791D-04,-0.4168D-04,
     ,  -0.6160D-04,-0.8905D-04,-0.1246D-03,-0.1666D-03,-0.2096D-03,
     ,  -0.2435D-03,-0.2557D-03,-0.2354D-03,-0.1795D-03,-0.9048D-04,
     ,   0.2418D-04, 0.1607D-03, 0.3124D-03, 0.4717D-03, 0.6288D-03,
     ,   0.7751D-03, 0.9048D-03, 0.1016D-02, 0.1107D-02, 0.1182D-02,
     ,   0.1242D-02, 0.1289D-02, 0.1326D-02, 0.1355D-02, 0.1378D-02,
     ,   0.1395D-02, 0.1407D-02, 0.1417D-02, 0.1424D-02, 0.1430D-02,
     ,   0.1434D-02, 0.1437D-02, 0.1439D-02/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.6107D-04,-0.5040D-04,-0.4160D-04,-0.3433D-04,-0.2832D-04,
     ,  -0.2336D-04,-0.1927D-04,-0.1588D-04,-0.1308D-04,-0.1077D-04,
     ,  -0.8857D-05,-0.7272D-05,-0.5959D-05,-0.4871D-05,-0.3968D-05,
     ,  -0.3218D-05,-0.2595D-05,-0.2077D-05,-0.1648D-05,-0.1293D-05,
     ,  -0.1001D-05,-0.7638D-06,-0.5761D-06,-0.4331D-06,-0.3327D-06,
     ,  -0.2750D-06,-0.2603D-06,-0.2930D-06,-0.3788D-06,-0.5277D-06,
     ,  -0.7541D-06,-0.1083D-05,-0.1553D-05,-0.2228D-05,-0.3215D-05,
     ,  -0.4681D-05,-0.6898D-05,-0.1027D-04,-0.1542D-04,-0.2318D-04,
     ,  -0.3461D-04,-0.5090D-04,-0.7304D-04,-0.1010D-03,-0.1333D-03,
     ,  -0.1650D-03,-0.1885D-03,-0.1941D-03,-0.1748D-03,-0.1293D-03,
     ,  -0.6058D-04, 0.2678D-04, 0.1297D-03, 0.2445D-03, 0.3648D-03,
     ,   0.4831D-03, 0.5931D-03, 0.6900D-03, 0.7725D-03, 0.8407D-03,
     ,   0.8951D-03, 0.9399D-03, 0.9750D-03, 0.1002D-02, 0.1023D-02,
     ,   0.1040D-02, 0.1051D-02, 0.1061D-02, 0.1068D-02, 0.1074D-02,
     ,   0.1077D-02, 0.1080D-02, 0.1083D-02/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.2845D-04,-0.2348D-04,-0.1938D-04,-0.1599D-04,-0.1320D-04,
     ,  -0.1089D-04,-0.8977D-05,-0.7400D-05,-0.6097D-05,-0.5019D-05,
     ,  -0.4128D-05,-0.3390D-05,-0.2779D-05,-0.2273D-05,-0.1852D-05,
     ,  -0.1504D-05,-0.1215D-05,-0.9747D-06,-0.7758D-06,-0.6123D-06,
     ,  -0.4782D-06,-0.3704D-06,-0.2863D-06,-0.2234D-06,-0.1814D-06,
     ,  -0.1599D-06,-0.1602D-06,-0.1842D-06,-0.2354D-06,-0.3183D-06,
     ,  -0.4428D-06,-0.6204D-06,-0.8734D-06,-0.1235D-05,-0.1765D-05,
     ,  -0.2553D-05,-0.3748D-05,-0.5581D-05,-0.8387D-05,-0.1267D-04,
     ,  -0.1908D-04,-0.2842D-04,-0.4156D-04,-0.5908D-04,-0.8090D-04,
     ,  -0.1053D-03,-0.1286D-03,-0.1446D-03,-0.1462D-03,-0.1290D-03,
     ,  -0.9260D-04,-0.4000D-04, 0.2588D-04, 0.1031D-03, 0.1893D-03,
     ,   0.2796D-03, 0.3684D-03, 0.4504D-03, 0.5226D-03, 0.5838D-03,
     ,   0.6341D-03, 0.6748D-03, 0.7069D-03, 0.7326D-03, 0.7522D-03,
     ,   0.7678D-03, 0.7794D-03, 0.7885D-03, 0.7953D-03, 0.8004D-03,
     ,   0.8043D-03, 0.8072D-03, 0.8095D-03/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.1324D-04,-0.1093D-04,-0.9018D-05,-0.7442D-05,-0.6141D-05,
     ,  -0.5066D-05,-0.4178D-05,-0.3444D-05,-0.2838D-05,-0.2336D-05,
     ,  -0.1922D-05,-0.1579D-05,-0.1294D-05,-0.1059D-05,-0.8639D-06,
     ,  -0.7021D-06,-0.5680D-06,-0.4569D-06,-0.3651D-06,-0.2898D-06,
     ,  -0.2286D-06,-0.1797D-06,-0.1420D-06,-0.1147D-06,-0.9749D-07,
     ,  -0.9042D-07,-0.9405D-07,-0.1095D-06,-0.1389D-06,-0.1847D-06,
     ,  -0.2517D-06,-0.3467D-06,-0.4809D-06,-0.6733D-06,-0.9546D-06,
     ,  -0.1374D-05,-0.2012D-05,-0.2993D-05,-0.4508D-05,-0.6833D-05,
     ,  -0.1036D-04,-0.1557D-04,-0.2308D-04,-0.3354D-04,-0.4723D-04,
     ,  -0.6400D-04,-0.8233D-04,-0.9918D-04,-0.1098D-03,-0.1092D-03,
     ,  -0.9453D-04,-0.6597D-04,-0.2610D-04, 0.2320D-04, 0.8087D-04,
     ,   0.1452D-03, 0.2128D-03, 0.2790D-03, 0.3400D-03, 0.3935D-03,
     ,   0.4386D-03, 0.4757D-03, 0.5054D-03, 0.5292D-03, 0.5478D-03,
     ,   0.5623D-03, 0.5733D-03, 0.5819D-03, 0.5885D-03, 0.5934D-03,
     ,   0.5971D-03, 0.6000D-03, 0.6021D-03/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.6156D-05,-0.5081D-05,-0.4193D-05,-0.3460D-05,-0.2855D-05,
     ,  -0.2356D-05,-0.1943D-05,-0.1602D-05,-0.1320D-05,-0.1087D-05,
     ,  -0.8940D-06,-0.7345D-06,-0.6025D-06,-0.4932D-06,-0.4026D-06,
     ,  -0.3276D-06,-0.2655D-06,-0.2141D-06,-0.1718D-06,-0.1373D-06,
     ,  -0.1093D-06,-0.8724D-07,-0.7048D-07,-0.5875D-07,-0.5188D-07,
     ,  -0.5002D-07,-0.5347D-07,-0.6281D-07,-0.7934D-07,-0.1041D-06,
     ,  -0.1398D-06,-0.1901D-06,-0.2608D-06,-0.3622D-06,-0.5102D-06,
     ,  -0.7316D-06,-0.1069D-05,-0.1589D-05,-0.2396D-05,-0.3643D-05,
     ,  -0.5548D-05,-0.8411D-05,-0.1261D-04,-0.1860D-04,-0.2678D-04,
     ,  -0.3738D-04,-0.5011D-04,-0.6379D-04,-0.7587D-04,-0.8287D-04,
     ,  -0.8119D-04,-0.6897D-04,-0.4692D-04,-0.1688D-04, 0.1976D-04,
     ,   0.6256D-04, 0.1105D-03, 0.1607D-03, 0.2098D-03, 0.2551D-03,
     ,   0.2948D-03, 0.3278D-03, 0.3550D-03, 0.3768D-03, 0.3941D-03,
     ,   0.4076D-03, 0.4181D-03, 0.4262D-03, 0.4324D-03, 0.4371D-03,
     ,   0.4407D-03, 0.4434D-03, 0.4455D-03/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.2861D-05,-0.2361D-05,-0.1949D-05,-0.1608D-05,-0.1327D-05,
     ,  -0.1095D-05,-0.9029D-06,-0.7444D-06,-0.6134D-06,-0.5052D-06,
     ,  -0.4157D-06,-0.3416D-06,-0.2803D-06,-0.2296D-06,-0.1876D-06,
     ,  -0.1528D-06,-0.1241D-06,-0.1003D-06,-0.8086D-07,-0.6501D-07,
     ,  -0.5228D-07,-0.4233D-07,-0.3494D-07,-0.2995D-07,-0.2733D-07,
     ,  -0.2717D-07,-0.2964D-07,-0.3509D-07,-0.4406D-07,-0.5729D-07,
     ,  -0.7609D-07,-0.1025D-06,-0.1397D-06,-0.1925D-06,-0.2699D-06,
     ,  -0.3857D-06,-0.5623D-06,-0.8359D-06,-0.1262D-05,-0.1923D-05,
     ,  -0.2940D-05,-0.4485D-05,-0.6784D-05,-0.1012D-04,-0.1482D-04,
     ,  -0.2118D-04,-0.2930D-04,-0.3890D-04,-0.4897D-04,-0.5762D-04,
     ,  -0.6210D-04,-0.5999D-04,-0.5011D-04,-0.3316D-04,-0.1070D-04,
     ,   0.1642D-04, 0.4812D-04, 0.8359D-04, 0.1208D-03, 0.1571D-03,
     ,   0.1905D-03, 0.2195D-03, 0.2439D-03, 0.2638D-03, 0.2798D-03,
     ,   0.2924D-03, 0.3022D-03, 0.3097D-03, 0.3156D-03, 0.3201D-03,
     ,   0.3235D-03, 0.3261D-03, 0.3281D-03/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.1329D-05,-0.1097D-05,-0.9053D-06,-0.7471D-06,-0.6164D-06,
     ,  -0.5086D-06,-0.4195D-06,-0.3459D-06,-0.2850D-06,-0.2348D-06,
     ,  -0.1932D-06,-0.1588D-06,-0.1304D-06,-0.1068D-06,-0.8737D-07,
     ,  -0.7127D-07,-0.5797D-07,-0.4702D-07,-0.3806D-07,-0.3080D-07,
     ,  -0.2501D-07,-0.2055D-07,-0.1730D-07,-0.1521D-07,-0.1427D-07,
     ,  -0.1455D-07,-0.1612D-07,-0.1919D-07,-0.2403D-07,-0.3104D-07,
     ,  -0.4093D-07,-0.5460D-07,-0.7388D-07,-0.1014D-06,-0.1415D-06,
     ,  -0.2017D-06,-0.2936D-06,-0.4363D-06,-0.6589D-06,-0.1006D-05,
     ,  -0.1544D-05,-0.2366D-05,-0.3604D-05,-0.5429D-05,-0.8051D-05,
     ,  -0.1171D-04,-0.1659D-04,-0.2276D-04,-0.2995D-04,-0.3735D-04,
     ,  -0.4346D-04,-0.4632D-04,-0.4411D-04,-0.3624D-04,-0.2334D-04,
     ,  -0.6683D-05, 0.1329D-04, 0.3667D-04, 0.6283D-04, 0.9028D-04,
     ,   0.1167D-03, 0.1416D-03, 0.1630D-03, 0.1808D-03, 0.1953D-03,
     ,   0.2070D-03, 0.2160D-03, 0.2232D-03, 0.2287D-03, 0.2329D-03,
     ,   0.2362D-03, 0.2386D-03, 0.2405D-03/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.6172D-06,-0.5094D-06,-0.4204D-06,-0.3470D-06,-0.2863D-06,
     ,  -0.2362D-06,-0.1948D-06,-0.1607D-06,-0.1324D-06,-0.1091D-06,
     ,  -0.8978D-07,-0.7382D-07,-0.6063D-07,-0.4971D-07,-0.4069D-07,
     ,  -0.3324D-07,-0.2709D-07,-0.2204D-07,-0.1792D-07,-0.1460D-07,
     ,  -0.1197D-07,-0.9977D-08,-0.8562D-08,-0.7711D-08,-0.7407D-08,
     ,  -0.7708D-08,-0.8646D-08,-0.1034D-07,-0.1291D-07,-0.1659D-07,
     ,  -0.2170D-07,-0.2881D-07,-0.3878D-07,-0.5290D-07,-0.7371D-07,
     ,  -0.1048D-06,-0.1523D-06,-0.2263D-06,-0.3419D-06,-0.5229D-06,
     ,  -0.8042D-06,-0.1238D-05,-0.1895D-05,-0.2876D-05,-0.4310D-05,
     ,  -0.6350D-05,-0.9166D-05,-0.1289D-04,-0.1755D-04,-0.2290D-04,
     ,  -0.2829D-04,-0.3261D-04,-0.3437D-04,-0.3232D-04,-0.2611D-04,
     ,  -0.1641D-04,-0.4057D-05, 0.1058D-04, 0.2770D-04, 0.4699D-04,
     ,   0.6719D-04, 0.8692D-04, 0.1049D-03, 0.1205D-03, 0.1335D-03,
     ,   0.1440D-03, 0.1525D-03, 0.1591D-03, 0.1643D-03, 0.1682D-03,
     ,   0.1713D-03, 0.1736D-03, 0.1754D-03/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.2866D-06,-0.2365D-06,-0.1952D-06,-0.1611D-06,-0.1329D-06,
     ,  -0.1097D-06,-0.9048D-07,-0.7461D-07,-0.6150D-07,-0.5067D-07,
     ,  -0.4171D-07,-0.3431D-07,-0.2819D-07,-0.2313D-07,-0.1895D-07,
     ,  -0.1550D-07,-0.1266D-07,-0.1033D-07,-0.8439D-08,-0.6923D-08,
     ,  -0.5737D-08,-0.4844D-08,-0.4236D-08,-0.3892D-08,-0.3821D-08,
     ,  -0.4041D-08,-0.4582D-08,-0.5494D-08,-0.6846D-08,-0.8760D-08,
     ,  -0.1141D-07,-0.1506D-07,-0.2016D-07,-0.2745D-07,-0.3810D-07,
     ,  -0.5405D-07,-0.7850D-07,-0.1166D-06,-0.1763D-06,-0.2700D-06,
     ,  -0.4162D-06,-0.6424D-06,-0.9881D-06,-0.1509D-05,-0.2278D-05,
     ,  -0.3394D-05,-0.4968D-05,-0.7121D-05,-0.9941D-05,-0.1343D-04,
     ,  -0.1740D-04,-0.2132D-04,-0.2435D-04,-0.2540D-04,-0.2361D-04,
     ,  -0.1880D-04,-0.1150D-04,-0.2438D-05, 0.8326D-05, 0.2086D-04,
     ,   0.3496D-04, 0.4979D-04, 0.6423D-04, 0.7739D-04, 0.8876D-04,
     ,   0.9825D-04, 0.1059D-03, 0.1120D-03, 0.1168D-03, 0.1205D-03,
     ,   0.1234D-03, 0.1256D-03, 0.1273D-03/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.1331D-06,-0.1098D-06,-0.9064D-07,-0.7480D-07,-0.6173D-07,
     ,  -0.5093D-07,-0.4201D-07,-0.3465D-07,-0.2856D-07,-0.2353D-07,
     ,  -0.1938D-07,-0.1594D-07,-0.1311D-07,-0.1076D-07,-0.8824D-08,
     ,  -0.7228D-08,-0.5916D-08,-0.4844D-08,-0.3977D-08,-0.3285D-08,
     ,  -0.2748D-08,-0.2353D-08,-0.2092D-08,-0.1959D-08,-0.1958D-08,
     ,  -0.2102D-08,-0.2402D-08,-0.2889D-08,-0.3595D-08,-0.4583D-08,
     ,  -0.5940D-08,-0.7810D-08,-0.1042D-07,-0.1414D-07,-0.1958D-07,
     ,  -0.2774D-07,-0.4028D-07,-0.5977D-07,-0.9043D-07,-0.1386D-06,
     ,  -0.2142D-06,-0.3313D-06,-0.5115D-06,-0.7850D-06,-0.1192D-05,
     ,  -0.1790D-05,-0.2650D-05,-0.3854D-05,-0.5487D-05,-0.7612D-05,
     ,  -0.1022D-04,-0.1313D-04,-0.1598D-04,-0.1809D-04,-0.1871D-04,
     ,  -0.1720D-04,-0.1347D-04,-0.8040D-05,-0.1373D-05, 0.6460D-05,
     ,   0.1561D-04, 0.2593D-04, 0.3678D-04, 0.4733D-04, 0.5691D-04,
     ,   0.6520D-04, 0.7207D-04, 0.7764D-04, 0.8202D-04, 0.8552D-04,
     ,   0.8823D-04, 0.9027D-04, 0.9187D-04/
      data (calcpts(j,45), j = 1,neta) /
     ,  -0.6177D-07,-0.5098D-07,-0.4208D-07,-0.3473D-07,-0.2866D-07,
     ,  -0.2365D-07,-0.1951D-07,-0.1609D-07,-0.1326D-07,-0.1093D-07,
     ,  -0.9002D-08,-0.7409D-08,-0.6093D-08,-0.5006D-08,-0.4110D-08,
     ,  -0.3371D-08,-0.2766D-08,-0.2273D-08,-0.1875D-08,-0.1560D-08,
     ,  -0.1318D-08,-0.1143D-08,-0.1032D-08,-0.9843D-09,-0.1001D-08,
     ,  -0.1087D-08,-0.1251D-08,-0.1505D-08,-0.1873D-08,-0.2380D-08,
     ,  -0.3075D-08,-0.4027D-08,-0.5354D-08,-0.7246D-08,-0.1001D-07,
     ,  -0.1417D-07,-0.2054D-07,-0.3048D-07,-0.4613D-07,-0.7082D-07,
     ,  -0.1096D-06,-0.1700D-06,-0.2632D-06,-0.4054D-06,-0.6187D-06,
     ,  -0.9357D-06,-0.1397D-05,-0.2054D-05,-0.2970D-05,-0.4202D-05,
     ,  -0.5790D-05,-0.7722D-05,-0.9863D-05,-0.1192D-04,-0.1340D-04,
     ,  -0.1373D-04,-0.1248D-04,-0.9653D-05,-0.5621D-05,-0.7413D-06,
     ,   0.4950D-05, 0.1162D-04, 0.1914D-04, 0.2705D-04, 0.3474D-04,
     ,   0.4171D-04, 0.4773D-04, 0.5271D-04, 0.5673D-04, 0.5990D-04,
     ,   0.6241D-04, 0.6435D-04, 0.6584D-04/
      data (calcpts(j,46), j = 1,neta) /
     ,  -0.2868D-07,-0.2367D-07,-0.1953D-07,-0.1612D-07,-0.1330D-07,
     ,  -0.1098D-07,-0.9057D-08,-0.7470D-08,-0.6159D-08,-0.5076D-08,
     ,  -0.4182D-08,-0.3443D-08,-0.2833D-08,-0.2329D-08,-0.1914D-08,
     ,  -0.1573D-08,-0.1293D-08,-0.1066D-08,-0.8839D-09,-0.7405D-09,
     ,  -0.6319D-09,-0.5552D-09,-0.5090D-09,-0.4931D-09,-0.5084D-09,
     ,  -0.5579D-09,-0.6456D-09,-0.7786D-09,-0.9680D-09,-0.1227D-08,
     ,  -0.1579D-08,-0.2064D-08,-0.2735D-08,-0.3693D-08,-0.5095D-08,
     ,  -0.7202D-08,-0.1044D-07,-0.1549D-07,-0.2345D-07,-0.3600D-07,
     ,  -0.5583D-07,-0.8680D-07,-0.1346D-06,-0.2080D-06,-0.3189D-06,
     ,  -0.4848D-06,-0.7282D-06,-0.1081D-05,-0.1581D-05,-0.2271D-05,
     ,  -0.3196D-05,-0.4384D-05,-0.5809D-05,-0.7373D-05,-0.8857D-05,
     ,  -0.9884D-05,-0.1004D-04,-0.9036D-05,-0.6893D-05,-0.3907D-05,
     ,  -0.3536D-06, 0.3782D-05, 0.8615D-05, 0.1408D-04, 0.1984D-04,
     ,   0.2544D-04, 0.3051D-04, 0.3486D-04, 0.3847D-04, 0.4135D-04,
     ,   0.4367D-04, 0.4546D-04, 0.4693D-04/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.1331D-07,-0.1099D-07,-0.9068D-08,-0.7484D-08,-0.6176D-08,
     ,  -0.5097D-08,-0.4205D-08,-0.3468D-08,-0.2860D-08,-0.2358D-08,
     ,  -0.1943D-08,-0.1600D-08,-0.1317D-08,-0.1084D-08,-0.8916D-09,
     ,  -0.7338D-09,-0.6049D-09,-0.5005D-09,-0.4170D-09,-0.3518D-09,
     ,  -0.3031D-09,-0.2695D-09,-0.2507D-09,-0.2463D-09,-0.2572D-09,
     ,  -0.2849D-09,-0.3313D-09,-0.4001D-09,-0.4966D-09,-0.6280D-09,
     ,  -0.8075D-09,-0.1051D-08,-0.1390D-08,-0.1874D-08,-0.2582D-08,
     ,  -0.3646D-08,-0.5280D-08,-0.7836D-08,-0.1187D-07,-0.1824D-07,
     ,  -0.2830D-07,-0.4405D-07,-0.6851D-07,-0.1062D-06,-0.1634D-06,
     ,  -0.2493D-06,-0.3770D-06,-0.5634D-06,-0.8318D-06,-0.1208D-05,
     ,  -0.1727D-05,-0.2418D-05,-0.3298D-05,-0.4349D-05,-0.5492D-05,
     ,  -0.6555D-05,-0.7267D-05,-0.7325D-05,-0.6526D-05,-0.4912D-05,
     ,  -0.2716D-05,-0.1298D-06, 0.2864D-05, 0.6405D-05, 0.1034D-04,
     ,   0.1453D-04, 0.1858D-04, 0.2226D-04, 0.2583D-04, 0.2801D-04,
     ,   0.3010D-04, 0.3188D-04, 0.3305D-04/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.6179D-08,-0.5100D-08,-0.4210D-08,-0.3474D-08,-0.2867D-08,
     ,  -0.2366D-08,-0.1952D-08,-0.1610D-08,-0.1328D-08,-0.1095D-08,
     ,  -0.9024D-09,-0.7435D-09,-0.6124D-09,-0.5043D-09,-0.4154D-09,
     ,  -0.3424D-09,-0.2830D-09,-0.2349D-09,-0.1967D-09,-0.1672D-09,
     ,  -0.1454D-09,-0.1308D-09,-0.1234D-09,-0.1228D-09,-0.1297D-09,
     ,  -0.1448D-09,-0.1691D-09,-0.2046D-09,-0.2537D-09,-0.3204D-09,
     ,  -0.4104D-09,-0.5335D-09,-0.7045D-09,-0.9481D-09,-0.1304D-08,
     ,  -0.1838D-08,-0.2662D-08,-0.3951D-08,-0.5985D-08,-0.9205D-08,
     ,  -0.1430D-07,-0.2229D-07,-0.3475D-07,-0.5395D-07,-0.8328D-07,
     ,  -0.1276D-06,-0.1937D-06,-0.2911D-06,-0.4326D-06,-0.6350D-06,
     ,  -0.9186D-06,-0.1306D-05,-0.1820D-05,-0.2470D-05,-0.3242D-05,
     ,  -0.4073D-05,-0.4835D-05,-0.5326D-05,-0.5357D-05,-0.4706D-05,
     ,  -0.3497D-05,-0.1883D-05,-0.8866D-08, 0.2156D-05, 0.4689D-05,
     ,   0.7569D-05, 0.1060D-04, 0.1354D-04, 0.1619D-04, 0.1846D-04,
     ,   0.2034D-04, 0.2184D-04, 0.2304D-04/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.2868D-08,-0.2367D-08,-0.1954D-08,-0.1613D-08,-0.1331D-08,
     ,  -0.1098D-08,-0.9063D-09,-0.7477D-09,-0.6167D-09,-0.5085D-09,
     ,  -0.4192D-09,-0.3455D-09,-0.2847D-09,-0.2347D-09,-0.1935D-09,
     ,  -0.1598D-09,-0.1324D-09,-0.1103D-09,-0.9291D-10,-0.7953D-10,
     ,  -0.6979D-10,-0.6353D-10,-0.6060D-10,-0.6108D-10,-0.6515D-10,
     ,  -0.7326D-10,-0.8589D-10,-0.1040D-09,-0.1289D-09,-0.1625D-09,
     ,  -0.2079D-09,-0.2694D-09,-0.3555D-09,-0.4772D-09,-0.6559D-09,
     ,  -0.9248D-09,-0.1338D-08,-0.1985D-08,-0.3008D-08,-0.4631D-08,
     ,  -0.7198D-08,-0.1124D-07,-0.1754D-07,-0.2730D-07,-0.4225D-07,
     ,  -0.6492D-07,-0.9893D-07,-0.1494D-06,-0.2233D-06,-0.3301D-06,
     ,  -0.4821D-06,-0.6942D-06,-0.9830D-06,-0.1363D-05,-0.1842D-05,
     ,  -0.2407D-05,-0.3010D-05,-0.3554D-05,-0.3894D-05,-0.3869D-05,
     ,  -0.3386D-05,-0.2486D-05,-0.1307D-05, 0.5552D-07, 0.1609D-05,
     ,   0.3439D-05, 0.5517D-05, 0.7710D-05, 0.9840D-05, 0.1175D-04,
     ,   0.1339D-04, 0.1474D-04, 0.1582D-04/


      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0,
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0,
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0,
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0,
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

c      coeff=coeff/sqrt(1+eta/1.)

      return
      end    
!----------------------------
      subroutine c2hqg20m(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.1791D+01, 0.1478D+01, 0.1220D+01, 0.1006D+01, 0.8302D+00,
     ,   0.6847D+00, 0.5644D+00, 0.4651D+00, 0.3828D+00, 0.3148D+00,
     ,   0.2585D+00, 0.2118D+00, 0.1730D+00, 0.1407D+00, 0.1138D+00,
     ,   0.9131D-01, 0.7246D-01, 0.5658D-01, 0.4317D-01, 0.3177D-01,
     ,   0.2203D-01, 0.1371D-01, 0.6560D-02, 0.4169D-03,-0.4859D-02,
     ,  -0.9378D-02,-0.1319D-01,-0.1636D-01,-0.1891D-01,-0.2085D-01,
     ,  -0.2219D-01,-0.2276D-01,-0.2240D-01,-0.2084D-01,-0.1791D-01,
     ,  -0.1371D-01,-0.8860D-02,-0.4241D-02,-0.6816D-03, 0.1451D-02,
     ,   0.2240D-02, 0.2014D-02, 0.1117D-02,-0.1477D-03,-0.1588D-02,
     ,  -0.3044D-02,-0.4448D-02,-0.5732D-02,-0.6842D-02,-0.7814D-02,
     ,  -0.8644D-02,-0.9324D-02,-0.9862D-02,-0.1032D-01,-0.1068D-01,
     ,  -0.1096D-01,-0.1120D-01,-0.1137D-01,-0.1150D-01,-0.1160D-01,
     ,  -0.1168D-01,-0.1176D-01,-0.1181D-01,-0.1183D-01,-0.1187D-01,
     ,  -0.1188D-01,-0.1190D-01,-0.1192D-01,-0.1191D-01,-0.1193D-01,
     ,  -0.1194D-01,-0.1193D-01,-0.1194D-01/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1790D+01, 0.1477D+01, 0.1219D+01, 0.1006D+01, 0.8299D+00,
     ,   0.6844D+00, 0.5643D+00, 0.4649D+00, 0.3827D+00, 0.3147D+00,
     ,   0.2584D+00, 0.2117D+00, 0.1729D+00, 0.1407D+00, 0.1138D+00,
     ,   0.9128D-01, 0.7244D-01, 0.5656D-01, 0.4315D-01, 0.3176D-01,
     ,   0.2203D-01, 0.1371D-01, 0.6564D-02, 0.4092D-03,-0.4862D-02,
     ,  -0.9382D-02,-0.1319D-01,-0.1636D-01,-0.1891D-01,-0.2085D-01,
     ,  -0.2216D-01,-0.2275D-01,-0.2237D-01,-0.2083D-01,-0.1791D-01,
     ,  -0.1371D-01,-0.8853D-02,-0.4246D-02,-0.6860D-03, 0.1446D-02,
     ,   0.2238D-02, 0.2011D-02, 0.1117D-02,-0.1546D-03,-0.1593D-02,
     ,  -0.3062D-02,-0.4449D-02,-0.5720D-02,-0.6843D-02,-0.7818D-02,
     ,  -0.8634D-02,-0.9314D-02,-0.9868D-02,-0.1033D-01,-0.1069D-01,
     ,  -0.1096D-01,-0.1119D-01,-0.1137D-01,-0.1151D-01,-0.1160D-01,
     ,  -0.1168D-01,-0.1175D-01,-0.1180D-01,-0.1184D-01,-0.1186D-01,
     ,  -0.1189D-01,-0.1190D-01,-0.1191D-01,-0.1191D-01,-0.1192D-01,
     ,  -0.1193D-01,-0.1193D-01,-0.1194D-01/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1789D+01, 0.1477D+01, 0.1219D+01, 0.1006D+01, 0.8295D+00,
     ,   0.6841D+00, 0.5640D+00, 0.4646D+00, 0.3825D+00, 0.3146D+00,
     ,   0.2583D+00, 0.2116D+00, 0.1728D+00, 0.1406D+00, 0.1137D+00,
     ,   0.9124D-01, 0.7238D-01, 0.5652D-01, 0.4311D-01, 0.3172D-01,
     ,   0.2203D-01, 0.1371D-01, 0.6571D-02, 0.4018D-03,-0.4875D-02,
     ,  -0.9383D-02,-0.1319D-01,-0.1636D-01,-0.1892D-01,-0.2087D-01,
     ,  -0.2213D-01,-0.2274D-01,-0.2234D-01,-0.2081D-01,-0.1791D-01,
     ,  -0.1371D-01,-0.8842D-02,-0.4239D-02,-0.6881D-03, 0.1442D-02,
     ,   0.2239D-02, 0.2012D-02, 0.1120D-02,-0.1541D-03,-0.1589D-02,
     ,  -0.3077D-02,-0.4446D-02,-0.5703D-02,-0.6855D-02,-0.7824D-02,
     ,  -0.8623D-02,-0.9301D-02,-0.9882D-02,-0.1032D-01,-0.1068D-01,
     ,  -0.1098D-01,-0.1118D-01,-0.1137D-01,-0.1150D-01,-0.1162D-01,
     ,  -0.1170D-01,-0.1174D-01,-0.1179D-01,-0.1184D-01,-0.1185D-01,
     ,  -0.1188D-01,-0.1190D-01,-0.1190D-01,-0.1193D-01,-0.1191D-01,
     ,  -0.1191D-01,-0.1194D-01,-0.1194D-01/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.1788D+01, 0.1476D+01, 0.1218D+01, 0.1005D+01, 0.8289D+00,
     ,   0.6836D+00, 0.5635D+00, 0.4643D+00, 0.3822D+00, 0.3143D+00,
     ,   0.2581D+00, 0.2114D+00, 0.1727D+00, 0.1405D+00, 0.1136D+00,
     ,   0.9113D-01, 0.7233D-01, 0.5650D-01, 0.4309D-01, 0.3172D-01,
     ,   0.2198D-01, 0.1368D-01, 0.6537D-02, 0.4181D-03,-0.4852D-02,
     ,  -0.9361D-02,-0.1317D-01,-0.1633D-01,-0.1888D-01,-0.2084D-01,
     ,  -0.2216D-01,-0.2272D-01,-0.2239D-01,-0.2083D-01,-0.1786D-01,
     ,  -0.1370D-01,-0.8865D-02,-0.4239D-02,-0.6900D-03, 0.1446D-02,
     ,   0.2245D-02, 0.2007D-02, 0.1118D-02,-0.1466D-03,-0.1586D-02,
     ,  -0.3017D-02,-0.4435D-02,-0.5730D-02,-0.6852D-02,-0.7801D-02,
     ,  -0.8643D-02,-0.9324D-02,-0.9874D-02,-0.1031D-01,-0.1067D-01,
     ,  -0.1097D-01,-0.1120D-01,-0.1135D-01,-0.1149D-01,-0.1162D-01,
     ,  -0.1169D-01,-0.1176D-01,-0.1181D-01,-0.1182D-01,-0.1187D-01,
     ,  -0.1187D-01,-0.1188D-01,-0.1192D-01,-0.1192D-01,-0.1193D-01,
     ,  -0.1194D-01,-0.1194D-01,-0.1192D-01/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.1786D+01, 0.1474D+01, 0.1216D+01, 0.1004D+01, 0.8279D+00,
     ,   0.6828D+00, 0.5629D+00, 0.4638D+00, 0.3818D+00, 0.3140D+00,
     ,   0.2578D+00, 0.2112D+00, 0.1725D+00, 0.1403D+00, 0.1135D+00,
     ,   0.9108D-01, 0.7226D-01, 0.5641D-01, 0.4304D-01, 0.3167D-01,
     ,   0.2198D-01, 0.1368D-01, 0.6549D-02, 0.4055D-03,-0.4863D-02,
     ,  -0.9365D-02,-0.1317D-01,-0.1633D-01,-0.1888D-01,-0.2081D-01,
     ,  -0.2212D-01,-0.2270D-01,-0.2234D-01,-0.2080D-01,-0.1787D-01,
     ,  -0.1372D-01,-0.8838D-02,-0.4247D-02,-0.6847D-03, 0.1437D-02,
     ,   0.2244D-02, 0.1978D-02, 0.1123D-02,-0.1497D-03,-0.1583D-02,
     ,  -0.3078D-02,-0.4455D-02,-0.5705D-02,-0.6834D-02,-0.7831D-02,
     ,  -0.8620D-02,-0.9299D-02,-0.9859D-02,-0.1033D-01,-0.1067D-01,
     ,  -0.1096D-01,-0.1118D-01,-0.1136D-01,-0.1149D-01,-0.1160D-01,
     ,  -0.1168D-01,-0.1174D-01,-0.1179D-01,-0.1182D-01,-0.1185D-01,
     ,  -0.1187D-01,-0.1191D-01,-0.1190D-01,-0.1191D-01,-0.1191D-01,
     ,  -0.1191D-01,-0.1192D-01,-0.1192D-01/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.1783D+01, 0.1472D+01, 0.1214D+01, 0.1002D+01, 0.8266D+00,
     ,   0.6817D+00, 0.5620D+00, 0.4630D+00, 0.3812D+00, 0.3135D+00,
     ,   0.2573D+00, 0.2108D+00, 0.1722D+00, 0.1401D+00, 0.1133D+00,
     ,   0.9091D-01, 0.7212D-01, 0.5633D-01, 0.4296D-01, 0.3161D-01,
     ,   0.2195D-01, 0.1366D-01, 0.6540D-02, 0.3931D-03,-0.4868D-02,
     ,  -0.9360D-02,-0.1316D-01,-0.1632D-01,-0.1886D-01,-0.2078D-01,
     ,  -0.2212D-01,-0.2267D-01,-0.2232D-01,-0.2077D-01,-0.1787D-01,
     ,  -0.1368D-01,-0.8873D-02,-0.4238D-02,-0.6889D-03, 0.1445D-02,
     ,   0.2235D-02, 0.2014D-02, 0.1120D-02,-0.1446D-03,-0.1583D-02,
     ,  -0.3010D-02,-0.4429D-02,-0.5711D-02,-0.6839D-02,-0.7805D-02,
     ,  -0.8629D-02,-0.9308D-02,-0.9865D-02,-0.1031D-01,-0.1067D-01,
     ,  -0.1096D-01,-0.1118D-01,-0.1136D-01,-0.1149D-01,-0.1160D-01,
     ,  -0.1168D-01,-0.1174D-01,-0.1179D-01,-0.1183D-01,-0.1185D-01,
     ,  -0.1187D-01,-0.1188D-01,-0.1190D-01,-0.1191D-01,-0.1189D-01,
     ,  -0.1192D-01,-0.1192D-01,-0.1192D-01/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.1779D+01, 0.1468D+01, 0.1211D+01, 0.9996D+00, 0.8246D+00,
     ,   0.6801D+00, 0.5606D+00, 0.4619D+00, 0.3803D+00, 0.3127D+00,
     ,   0.2567D+00, 0.2103D+00, 0.1718D+00, 0.1397D+00, 0.1130D+00,
     ,   0.9069D-01, 0.7196D-01, 0.5618D-01, 0.4286D-01, 0.3154D-01,
     ,   0.2188D-01, 0.1361D-01, 0.6504D-02, 0.3926D-03,-0.4854D-02,
     ,  -0.9318D-02,-0.1311D-01,-0.1628D-01,-0.1880D-01,-0.2078D-01,
     ,  -0.2206D-01,-0.2264D-01,-0.2226D-01,-0.2075D-01,-0.1783D-01,
     ,  -0.1368D-01,-0.8848D-02,-0.4239D-02,-0.6898D-03, 0.1435D-02,
     ,   0.2203D-02, 0.2011D-02, 0.1093D-02,-0.1439D-03,-0.1577D-02,
     ,  -0.3073D-02,-0.4444D-02,-0.5715D-02,-0.6838D-02,-0.7791D-02,
     ,  -0.8632D-02,-0.9307D-02,-0.9843D-02,-0.1030D-01,-0.1068D-01,
     ,  -0.1094D-01,-0.1116D-01,-0.1136D-01,-0.1149D-01,-0.1158D-01,
     ,  -0.1166D-01,-0.1172D-01,-0.1177D-01,-0.1183D-01,-0.1185D-01,
     ,  -0.1188D-01,-0.1187D-01,-0.1188D-01,-0.1189D-01,-0.1180D-01,
     ,  -0.1192D-01,-0.1191D-01,-0.1193D-01/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1773D+01, 0.1463D+01, 0.1207D+01, 0.9961D+00, 0.8217D+00,
     ,   0.6777D+00, 0.5587D+00, 0.4603D+00, 0.3789D+00, 0.3116D+00,
     ,   0.2558D+00, 0.2096D+00, 0.1712D+00, 0.1393D+00, 0.1126D+00,
     ,   0.9036D-01, 0.7171D-01, 0.5599D-01, 0.4270D-01, 0.3142D-01,
     ,   0.2180D-01, 0.1356D-01, 0.6473D-02, 0.3836D-03,-0.4846D-02,
     ,  -0.9325D-02,-0.1310D-01,-0.1622D-01,-0.1878D-01,-0.2070D-01,
     ,  -0.2200D-01,-0.2258D-01,-0.2227D-01,-0.2069D-01,-0.1784D-01,
     ,  -0.1367D-01,-0.8829D-02,-0.4242D-02,-0.7031D-03, 0.1436D-02,
     ,   0.2243D-02, 0.2012D-02, 0.1132D-02,-0.1615D-03,-0.1603D-02,
     ,  -0.3024D-02,-0.4426D-02,-0.5691D-02,-0.6821D-02,-0.7794D-02,
     ,  -0.8616D-02,-0.9274D-02,-0.9851D-02,-0.1030D-01,-0.1065D-01,
     ,  -0.1095D-01,-0.1117D-01,-0.1134D-01,-0.1146D-01,-0.1159D-01,
     ,  -0.1167D-01,-0.1173D-01,-0.1178D-01,-0.1181D-01,-0.1182D-01,
     ,  -0.1186D-01,-0.1187D-01,-0.1189D-01,-0.1190D-01,-0.1201D-01,
     ,  -0.1189D-01,-0.1192D-01,-0.1189D-01/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1763D+01, 0.1455D+01, 0.1201D+01, 0.9910D+00, 0.8175D+00,
     ,   0.6742D+00, 0.5558D+00, 0.4579D+00, 0.3770D+00, 0.3100D+00,
     ,   0.2545D+00, 0.2085D+00, 0.1703D+00, 0.1385D+00, 0.1121D+00,
     ,   0.8990D-01, 0.7134D-01, 0.5570D-01, 0.4249D-01, 0.3125D-01,
     ,   0.2167D-01, 0.1347D-01, 0.6421D-02, 0.3726D-03,-0.4830D-02,
     ,  -0.9301D-02,-0.1306D-01,-0.1619D-01,-0.1871D-01,-0.2062D-01,
     ,  -0.2190D-01,-0.2249D-01,-0.2213D-01,-0.2066D-01,-0.1776D-01,
     ,  -0.1364D-01,-0.8836D-02,-0.4251D-02,-0.7005D-03, 0.1433D-02,
     ,   0.2226D-02, 0.2013D-02, 0.1132D-02,-0.1239D-03,-0.1554D-02,
     ,  -0.3016D-02,-0.4404D-02,-0.5679D-02,-0.6810D-02,-0.7787D-02,
     ,  -0.8578D-02,-0.9277D-02,-0.9834D-02,-0.1026D-01,-0.1062D-01,
     ,  -0.1093D-01,-0.1116D-01,-0.1131D-01,-0.1146D-01,-0.1157D-01,
     ,  -0.1165D-01,-0.1171D-01,-0.1176D-01,-0.1178D-01,-0.1183D-01,
     ,  -0.1183D-01,-0.1184D-01,-0.1187D-01,-0.1188D-01,-0.1187D-01,
     ,  -0.1190D-01,-0.1189D-01,-0.1190D-01/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.1750D+01, 0.1444D+01, 0.1192D+01, 0.9836D+00, 0.8114D+00,
     ,   0.6692D+00, 0.5516D+00, 0.4545D+00, 0.3742D+00, 0.3077D+00,
     ,   0.2526D+00, 0.2069D+00, 0.1690D+00, 0.1375D+00, 0.1112D+00,
     ,   0.8924D-01, 0.7077D-01, 0.5527D-01, 0.4214D-01, 0.3102D-01,
     ,   0.2151D-01, 0.1335D-01, 0.6357D-02, 0.3341D-03,-0.4842D-02,
     ,  -0.9253D-02,-0.1298D-01,-0.1608D-01,-0.1859D-01,-0.2052D-01,
     ,  -0.2181D-01,-0.2238D-01,-0.2205D-01,-0.2053D-01,-0.1768D-01,
     ,  -0.1359D-01,-0.8804D-02,-0.4244D-02,-0.7113D-03, 0.1412D-02,
     ,   0.2223D-02, 0.1987D-02, 0.1109D-02,-0.1444D-03,-0.1574D-02,
     ,  -0.3000D-02,-0.4396D-02,-0.5672D-02,-0.6780D-02,-0.7769D-02,
     ,  -0.8594D-02,-0.9252D-02,-0.9803D-02,-0.1028D-01,-0.1062D-01,
     ,  -0.1090D-01,-0.1112D-01,-0.1130D-01,-0.1144D-01,-0.1154D-01,
     ,  -0.1162D-01,-0.1168D-01,-0.1173D-01,-0.1177D-01,-0.1179D-01,
     ,  -0.1182D-01,-0.1183D-01,-0.1184D-01,-0.1185D-01,-0.1186D-01,
     ,  -0.1187D-01,-0.1187D-01,-0.1187D-01/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.1731D+01, 0.1429D+01, 0.1179D+01, 0.9727D+00, 0.8025D+00,
     ,   0.6618D+00, 0.5456D+00, 0.4495D+00, 0.3700D+00, 0.3043D+00,
     ,   0.2498D+00, 0.2047D+00, 0.1672D+00, 0.1360D+00, 0.1099D+00,
     ,   0.8822D-01, 0.6998D-01, 0.5463D-01, 0.4166D-01, 0.3064D-01,
     ,   0.2123D-01, 0.1320D-01, 0.6277D-02, 0.3225D-03,-0.4814D-02,
     ,  -0.9178D-02,-0.1290D-01,-0.1598D-01,-0.1845D-01,-0.2033D-01,
     ,  -0.2164D-01,-0.2221D-01,-0.2189D-01,-0.2040D-01,-0.1763D-01,
     ,  -0.1355D-01,-0.8800D-02,-0.4260D-02,-0.7339D-03, 0.1403D-02,
     ,   0.2197D-02, 0.1996D-02, 0.1128D-02,-0.9577D-04,-0.1516D-02,
     ,  -0.3000D-02,-0.4389D-02,-0.5640D-02,-0.6773D-02,-0.7721D-02,
     ,  -0.8546D-02,-0.9245D-02,-0.9779D-02,-0.1023D-01,-0.1059D-01,
     ,  -0.1087D-01,-0.1110D-01,-0.1127D-01,-0.1141D-01,-0.1150D-01,
     ,  -0.1158D-01,-0.1166D-01,-0.1169D-01,-0.1174D-01,-0.1177D-01,
     ,  -0.1179D-01,-0.1181D-01,-0.1182D-01,-0.1181D-01,-0.1183D-01,
     ,  -0.1184D-01,-0.1182D-01,-0.1184D-01/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.1703D+01, 0.1406D+01, 0.1160D+01, 0.9571D+00, 0.7896D+00,
     ,   0.6512D+00, 0.5368D+00, 0.4423D+00, 0.3641D+00, 0.2994D+00,
     ,   0.2458D+00, 0.2013D+00, 0.1645D+00, 0.1338D+00, 0.1082D+00,
     ,   0.8681D-01, 0.6887D-01, 0.5376D-01, 0.4099D-01, 0.3013D-01,
     ,   0.2088D-01, 0.1293D-01, 0.6112D-02, 0.2435D-03,-0.4774D-02,
     ,  -0.9113D-02,-0.1274D-01,-0.1578D-01,-0.1824D-01,-0.2013D-01,
     ,  -0.2137D-01,-0.2196D-01,-0.2163D-01,-0.2022D-01,-0.1744D-01,
     ,  -0.1346D-01,-0.8779D-02,-0.4263D-02,-0.7493D-03, 0.1386D-02,
     ,   0.2227D-02, 0.2008D-02, 0.1143D-02,-0.1287D-03,-0.1522D-02,
     ,  -0.2962D-02,-0.4324D-02,-0.5601D-02,-0.6727D-02,-0.7681D-02,
     ,  -0.8499D-02,-0.9160D-02,-0.9738D-02,-0.1017D-01,-0.1055D-01,
     ,  -0.1082D-01,-0.1104D-01,-0.1123D-01,-0.1137D-01,-0.1148D-01,
     ,  -0.1156D-01,-0.1160D-01,-0.1167D-01,-0.1168D-01,-0.1171D-01,
     ,  -0.1173D-01,-0.1177D-01,-0.1176D-01,-0.1179D-01,-0.1177D-01,
     ,  -0.1178D-01,-0.1181D-01,-0.1178D-01/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.1663D+01, 0.1373D+01, 0.1133D+01, 0.9346D+00, 0.7710D+00,
     ,   0.6359D+00, 0.5242D+00, 0.4319D+00, 0.3555D+00, 0.2924D+00,
     ,   0.2400D+00, 0.1966D+00, 0.1606D+00, 0.1306D+00, 0.1056D+00,
     ,   0.8473D-01, 0.6722D-01, 0.5245D-01, 0.3998D-01, 0.2937D-01,
     ,   0.2032D-01, 0.1259D-01, 0.5930D-02, 0.1943D-03,-0.4747D-02,
     ,  -0.8961D-02,-0.1254D-01,-0.1550D-01,-0.1792D-01,-0.1979D-01,
     ,  -0.2105D-01,-0.2161D-01,-0.2133D-01,-0.1994D-01,-0.1728D-01,
     ,  -0.1335D-01,-0.8721D-02,-0.4267D-02,-0.7740D-03, 0.1350D-02,
     ,   0.2178D-02, 0.2013D-02, 0.1144D-02,-0.5100D-04,-0.1498D-02,
     ,  -0.2907D-02,-0.4291D-02,-0.5553D-02,-0.6662D-02,-0.7632D-02,
     ,  -0.8450D-02,-0.9132D-02,-0.9663D-02,-0.1012D-01,-0.1048D-01,
     ,  -0.1076D-01,-0.1099D-01,-0.1114D-01,-0.1128D-01,-0.1140D-01,
     ,  -0.1148D-01,-0.1155D-01,-0.1159D-01,-0.1163D-01,-0.1166D-01,
     ,  -0.1168D-01,-0.1168D-01,-0.1170D-01,-0.1169D-01,-0.1173D-01,
     ,  -0.1173D-01,-0.1173D-01,-0.1174D-01/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1606D+01, 0.1326D+01, 0.1094D+01, 0.9027D+00, 0.7447D+00,
     ,   0.6141D+00, 0.5063D+00, 0.4171D+00, 0.3434D+00, 0.2824D+00,
     ,   0.2318D+00, 0.1899D+00, 0.1551D+00, 0.1261D+00, 0.1020D+00,
     ,   0.8181D-01, 0.6487D-01, 0.5062D-01, 0.3856D-01, 0.2834D-01,
     ,   0.1959D-01, 0.1208D-01, 0.5624D-02, 0.7122D-04,-0.4703D-02,
     ,  -0.8777D-02,-0.1226D-01,-0.1514D-01,-0.1749D-01,-0.1926D-01,
     ,  -0.2050D-01,-0.2110D-01,-0.2084D-01,-0.1952D-01,-0.1695D-01,
     ,  -0.1316D-01,-0.8672D-02,-0.4287D-02,-0.8242D-03, 0.1319D-02,
     ,   0.2143D-02, 0.1974D-02, 0.1187D-02,-0.5549D-04,-0.1421D-02,
     ,  -0.2864D-02,-0.4226D-02,-0.5489D-02,-0.6572D-02,-0.7551D-02,
     ,  -0.8348D-02,-0.9026D-02,-0.9569D-02,-0.1003D-01,-0.1038D-01,
     ,  -0.1067D-01,-0.1089D-01,-0.1107D-01,-0.1120D-01,-0.1129D-01,
     ,  -0.1137D-01,-0.1145D-01,-0.1148D-01,-0.1153D-01,-0.1156D-01,
     ,  -0.1158D-01,-0.1159D-01,-0.1159D-01,-0.1162D-01,-0.1162D-01,
     ,  -0.1162D-01,-0.1160D-01,-0.1163D-01/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1527D+01, 0.1260D+01, 0.1040D+01, 0.8579D+00, 0.7078D+00,
     ,   0.5837D+00, 0.4812D+00, 0.3964D+00, 0.3263D+00, 0.2684D+00,
     ,   0.2203D+00, 0.1805D+00, 0.1474D+00, 0.1199D+00, 0.9688D-01,
     ,   0.7773D-01, 0.6162D-01, 0.4806D-01, 0.3660D-01, 0.2683D-01,
     ,   0.1851D-01, 0.1139D-01, 0.5234D-02,-0.6264D-04,-0.4624D-02,
     ,  -0.8537D-02,-0.1184D-01,-0.1461D-01,-0.1685D-01,-0.1859D-01,
     ,  -0.1977D-01,-0.2036D-01,-0.2018D-01,-0.1895D-01,-0.1652D-01,
     ,  -0.1292D-01,-0.8582D-02,-0.4295D-02,-0.8757D-03, 0.1256D-02,
     ,   0.2104D-02, 0.2008D-02, 0.1187D-02, 0.3313D-04,-0.1350D-02,
     ,  -0.2768D-02,-0.4110D-02,-0.5347D-02,-0.6465D-02,-0.7410D-02,
     ,  -0.8218D-02,-0.8878D-02,-0.9458D-02,-0.9870D-02,-0.1025D-01,
     ,  -0.1053D-01,-0.1074D-01,-0.1093D-01,-0.1105D-01,-0.1118D-01,
     ,  -0.1126D-01,-0.1130D-01,-0.1137D-01,-0.1138D-01,-0.1141D-01,
     ,  -0.1143D-01,-0.1145D-01,-0.1148D-01,-0.1147D-01,-0.1147D-01,
     ,  -0.1148D-01,-0.1149D-01,-0.1148D-01/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.1418D+01, 0.1170D+01, 0.9654D+00, 0.7966D+00, 0.6571D+00,
     ,   0.5419D+00, 0.4467D+00, 0.3680D+00, 0.3030D+00, 0.2491D+00,
     ,   0.2045D+00, 0.1675D+00, 0.1368D+00, 0.1112D+00, 0.8992D-01,
     ,   0.7207D-01, 0.5715D-01, 0.4453D-01, 0.3387D-01, 0.2481D-01,
     ,   0.1706D-01, 0.1041D-01, 0.4696D-02,-0.2400D-03,-0.4500D-02,
     ,  -0.8160D-02,-0.1126D-01,-0.1387D-01,-0.1599D-01,-0.1763D-01,
     ,  -0.1880D-01,-0.1937D-01,-0.1920D-01,-0.1818D-01,-0.1598D-01,
     ,  -0.1258D-01,-0.8424D-02,-0.4311D-02,-0.9642D-03, 0.1177D-02,
     ,   0.2092D-02, 0.1959D-02, 0.1226D-02, 0.6555D-04,-0.1258D-02,
     ,  -0.2626D-02,-0.3972D-02,-0.5202D-02,-0.6292D-02,-0.7226D-02,
     ,  -0.8027D-02,-0.8711D-02,-0.9217D-02,-0.9698D-02,-0.1004D-01,
     ,  -0.1030D-01,-0.1055D-01,-0.1070D-01,-0.1086D-01,-0.1094D-01,
     ,  -0.1103D-01,-0.1109D-01,-0.1114D-01,-0.1119D-01,-0.1120D-01,
     ,  -0.1122D-01,-0.1125D-01,-0.1125D-01,-0.1128D-01,-0.1127D-01,
     ,  -0.1127D-01,-0.1129D-01,-0.1127D-01/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.1272D+01, 0.1050D+01, 0.8662D+00, 0.7147D+00, 0.5896D+00,
     ,   0.4862D+00, 0.4008D+00, 0.3302D+00, 0.2719D+00, 0.2235D+00,
     ,   0.1835D+00, 0.1502D+00, 0.1227D+00, 0.9975D-01, 0.8061D-01,
     ,   0.6463D-01, 0.5114D-01, 0.3985D-01, 0.3025D-01, 0.2212D-01,
     ,   0.1513D-01, 0.9126D-02, 0.3977D-02,-0.4844D-03,-0.4343D-02,
     ,  -0.7669D-02,-0.1051D-01,-0.1288D-01,-0.1482D-01,-0.1635D-01,
     ,  -0.1744D-01,-0.1802D-01,-0.1796D-01,-0.1707D-01,-0.1511D-01,
     ,  -0.1208D-01,-0.8273D-02,-0.4326D-02,-0.1051D-02, 0.1074D-02,
     ,   0.1994D-02, 0.1979D-02, 0.1299D-02, 0.2003D-03,-0.1094D-02,
     ,  -0.2449D-02,-0.3725D-02,-0.4953D-02,-0.6040D-02,-0.6979D-02,
     ,  -0.7764D-02,-0.8410D-02,-0.8969D-02,-0.9398D-02,-0.9762D-02,
     ,  -0.1004D-01,-0.1025D-01,-0.1043D-01,-0.1056D-01,-0.1067D-01,
     ,  -0.1076D-01,-0.1082D-01,-0.1087D-01,-0.1088D-01,-0.1093D-01,
     ,  -0.1094D-01,-0.1094D-01,-0.1098D-01,-0.1098D-01,-0.1099D-01,
     ,  -0.1099D-01,-0.1099D-01,-0.1100D-01/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.1086D+01, 0.8959D+00, 0.7394D+00, 0.6100D+00, 0.5032D+00,
     ,   0.4150D+00, 0.3421D+00, 0.2818D+00, 0.2320D+00, 0.1907D+00,
     ,   0.1565D+00, 0.1282D+00, 0.1046D+00, 0.8503D-01, 0.6870D-01,
     ,   0.5501D-01, 0.4354D-01, 0.3384D-01, 0.2563D-01, 0.1863D-01,
     ,   0.1267D-01, 0.7524D-02, 0.3056D-02,-0.8017D-03,-0.4142D-02,
     ,  -0.7030D-02,-0.9508D-02,-0.1160D-01,-0.1333D-01,-0.1470D-01,
     ,  -0.1567D-01,-0.1625D-01,-0.1633D-01,-0.1563D-01,-0.1402D-01,
     ,  -0.1140D-01,-0.7956D-02,-0.4318D-02,-0.1180D-02, 0.9403D-03,
     ,   0.1920D-02, 0.1976D-02, 0.1350D-02, 0.3676D-03,-0.8774D-03,
     ,  -0.2167D-02,-0.3450D-02,-0.4631D-02,-0.5664D-02,-0.6582D-02,
     ,  -0.7390D-02,-0.8054D-02,-0.8575D-02,-0.9003D-02,-0.9351D-02,
     ,  -0.9630D-02,-0.9858D-02,-0.1004D-01,-0.1017D-01,-0.1026D-01,
     ,  -0.1034D-01,-0.1040D-01,-0.1045D-01,-0.1049D-01,-0.1051D-01,
     ,  -0.1053D-01,-0.1055D-01,-0.1056D-01,-0.1057D-01,-0.1057D-01,
     ,  -0.1058D-01,-0.1058D-01,-0.1058D-01/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.8602D+00, 0.7099D+00, 0.5858D+00, 0.4834D+00, 0.3987D+00,
     ,   0.3288D+00, 0.2710D+00, 0.2233D+00, 0.1838D+00, 0.1511D+00,
     ,   0.1240D+00, 0.1015D+00, 0.8283D-01, 0.6728D-01, 0.5428D-01,
     ,   0.4343D-01, 0.3431D-01, 0.2661D-01, 0.2007D-01, 0.1450D-01,
     ,   0.9682D-02, 0.5555D-02, 0.1980D-02,-0.1152D-02,-0.3864D-02,
     ,  -0.6207D-02,-0.8251D-02,-0.1000D-01,-0.1147D-01,-0.1264D-01,
     ,  -0.1352D-01,-0.1409D-01,-0.1422D-01,-0.1380D-01,-0.1262D-01,
     ,  -0.1050D-01,-0.7570D-02,-0.4274D-02,-0.1324D-02, 0.7771D-03,
     ,   0.1847D-02, 0.2003D-02, 0.1484D-02, 0.5532D-03,-0.5690D-03,
     ,  -0.1813D-02,-0.3048D-02,-0.4174D-02,-0.5214D-02,-0.6115D-02,
     ,  -0.6854D-02,-0.7500D-02,-0.8043D-02,-0.8479D-02,-0.8821D-02,
     ,  -0.9091D-02,-0.9310D-02,-0.9487D-02,-0.9605D-02,-0.9737D-02,
     ,  -0.9790D-02,-0.9852D-02,-0.9904D-02,-0.9935D-02,-0.9964D-02,
     ,  -0.9987D-02,-0.1000D-01,-0.1001D-01,-0.1000D-01,-0.1003D-01,
     ,  -0.1003D-01,-0.1002D-01,-0.1004D-01/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.6071D+00, 0.5010D+00, 0.4135D+00, 0.3411D+00, 0.2814D+00,
     ,   0.2321D+00, 0.1913D+00, 0.1575D+00, 0.1296D+00, 0.1065D+00,
     ,   0.8738D-01, 0.7150D-01, 0.5832D-01, 0.4732D-01, 0.3814D-01,
     ,   0.3043D-01, 0.2395D-01, 0.1848D-01, 0.1381D-01, 0.9820D-02,
     ,   0.6401D-02, 0.3405D-02, 0.7914D-03,-0.1475D-02,-0.3500D-02,
     ,  -0.5279D-02,-0.6824D-02,-0.8160D-02,-0.9294D-02,-0.1025D-01,
     ,  -0.1103D-01,-0.1157D-01,-0.1181D-01,-0.1165D-01,-0.1087D-01,
     ,  -0.9347D-02,-0.6992D-02,-0.4165D-02,-0.1446D-02, 0.5973D-03,
     ,   0.1737D-02, 0.1994D-02, 0.1614D-02, 0.8161D-03,-0.2039D-03,
     ,  -0.1339D-02,-0.2483D-02,-0.3573D-02,-0.4567D-02,-0.5436D-02,
     ,  -0.6185D-02,-0.6816D-02,-0.7336D-02,-0.7770D-02,-0.8086D-02,
     ,  -0.8376D-02,-0.8588D-02,-0.8739D-02,-0.8877D-02,-0.8975D-02,
     ,  -0.9066D-02,-0.9124D-02,-0.9175D-02,-0.9209D-02,-0.9235D-02,
     ,  -0.9260D-02,-0.9270D-02,-0.9263D-02,-0.9295D-02,-0.9278D-02,
     ,  -0.9283D-02,-0.9311D-02,-0.9289D-02/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.3492D+00, 0.2882D+00, 0.2378D+00, 0.1962D+00, 0.1618D+00,
     ,   0.1334D+00, 0.1099D+00, 0.9055D-01, 0.7448D-01, 0.6117D-01,
     ,   0.5014D-01, 0.4098D-01, 0.3335D-01, 0.2700D-01, 0.2168D-01,
     ,   0.1722D-01, 0.1343D-01, 0.1023D-01, 0.7497D-02, 0.5102D-02,
     ,   0.3055D-02, 0.1249D-02,-0.3369D-03,-0.1767D-02,-0.3051D-02,
     ,  -0.4203D-02,-0.5245D-02,-0.6177D-02,-0.7031D-02,-0.7748D-02,
     ,  -0.8334D-02,-0.8834D-02,-0.9181D-02,-0.9259D-02,-0.8917D-02,
     ,  -0.7952D-02,-0.6252D-02,-0.3950D-02,-0.1536D-02, 0.4300D-03,
     ,   0.1628D-02, 0.2026D-02, 0.1820D-02, 0.1197D-02, 0.2891D-03,
     ,  -0.7556D-03,-0.1796D-02,-0.2848D-02,-0.3770D-02,-0.4611D-02,
     ,  -0.5334D-02,-0.5943D-02,-0.6441D-02,-0.6853D-02,-0.7197D-02,
     ,  -0.7466D-02,-0.7668D-02,-0.7831D-02,-0.7960D-02,-0.8050D-02,
     ,  -0.8149D-02,-0.8189D-02,-0.8240D-02,-0.8273D-02,-0.8299D-02,
     ,  -0.8320D-02,-0.8331D-02,-0.8351D-02,-0.8359D-02,-0.8369D-02,
     ,  -0.8374D-02,-0.8371D-02,-0.8379D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.1170D+00, 0.9656D-01, 0.7964D-01, 0.6568D-01, 0.5415D-01,
     ,   0.4461D-01, 0.3672D-01, 0.3022D-01, 0.2481D-01, 0.2031D-01,
     ,   0.1662D-01, 0.1351D-01, 0.1090D-01, 0.8716D-02, 0.6891D-02,
     ,   0.5317D-02, 0.3993D-02, 0.2823D-02, 0.1804D-02, 0.9216D-03,
     ,   0.1062D-03,-0.6183D-03,-0.1326D-02,-0.1971D-02,-0.2597D-02,
     ,  -0.3175D-02,-0.3750D-02,-0.4303D-02,-0.4821D-02,-0.5333D-02,
     ,  -0.5814D-02,-0.6267D-02,-0.6610D-02,-0.6886D-02,-0.6891D-02,
     ,  -0.6428D-02,-0.5341D-02,-0.3605D-02,-0.1566D-02, 0.2929D-03,
     ,   0.1548D-02, 0.2118D-02, 0.2050D-02, 0.1576D-02, 0.8253D-03,
     ,  -0.5585D-04,-0.1026D-02,-0.1953D-02,-0.2855D-02,-0.3637D-02,
     ,  -0.4318D-02,-0.4898D-02,-0.5395D-02,-0.5791D-02,-0.6109D-02,
     ,  -0.6376D-02,-0.6585D-02,-0.6759D-02,-0.6875D-02,-0.6985D-02,
     ,  -0.7035D-02,-0.7106D-02,-0.7156D-02,-0.7189D-02,-0.7193D-02,
     ,  -0.7212D-02,-0.7227D-02,-0.7262D-02,-0.7271D-02,-0.7280D-02,
     ,  -0.7280D-02,-0.7261D-02,-0.7285D-02/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.6165D-01,-0.5089D-01,-0.4202D-01,-0.3470D-01,-0.2866D-01,
     ,  -0.2367D-01,-0.1956D-01,-0.1620D-01,-0.1338D-01,-0.1108D-01,
     ,  -0.9209D-02,-0.7645D-02,-0.6356D-02,-0.5312D-02,-0.4479D-02,
     ,  -0.3787D-02,-0.3236D-02,-0.2815D-02,-0.2477D-02,-0.2243D-02,
     ,  -0.2087D-02,-0.2019D-02,-0.1983D-02,-0.2026D-02,-0.2102D-02,
     ,  -0.2250D-02,-0.2438D-02,-0.2680D-02,-0.2960D-02,-0.3299D-02,
     ,  -0.3660D-02,-0.4024D-02,-0.4428D-02,-0.4765D-02,-0.5009D-02,
     ,  -0.4951D-02,-0.4374D-02,-0.3190D-02,-0.1534D-02, 0.1502D-03,
     ,   0.1426D-02, 0.2115D-02, 0.2270D-02, 0.1968D-02, 0.1378D-02,
     ,   0.6458D-03,-0.1889D-03,-0.1020D-02,-0.1828D-02,-0.2563D-02,
     ,  -0.3228D-02,-0.3781D-02,-0.4233D-02,-0.4626D-02,-0.4939D-02,
     ,  -0.5191D-02,-0.5389D-02,-0.5543D-02,-0.5663D-02,-0.5766D-02,
     ,  -0.5825D-02,-0.5907D-02,-0.5935D-02,-0.5970D-02,-0.6003D-02,
     ,  -0.6018D-02,-0.6035D-02,-0.6047D-02,-0.6031D-02,-0.6060D-02,
     ,  -0.6067D-02,-0.6070D-02,-0.6071D-02/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.1725D+00,-0.1424D+00,-0.1175D+00,-0.9701D-01,-0.8006D-01,
     ,  -0.6608D-01,-0.5451D-01,-0.4495D-01,-0.3708D-01,-0.3055D-01,
     ,  -0.2517D-01,-0.2072D-01,-0.1705D-01,-0.1400D-01,-0.1148D-01,
     ,  -0.9404D-02,-0.7688D-02,-0.6263D-02,-0.5103D-02,-0.4147D-02,
     ,  -0.3376D-02,-0.2748D-02,-0.2262D-02,-0.1898D-02,-0.1646D-02,
     ,  -0.1507D-02,-0.1447D-02,-0.1480D-02,-0.1598D-02,-0.1781D-02,
     ,  -0.2052D-02,-0.2387D-02,-0.2773D-02,-0.3179D-02,-0.3533D-02,
     ,  -0.3711D-02,-0.3522D-02,-0.2788D-02,-0.1526D-02,-0.4526D-04,
     ,   0.1261D-02, 0.2073D-02, 0.2393D-02, 0.2284D-02, 0.1899D-02,
     ,   0.1302D-02, 0.6185D-03,-0.1213D-03,-0.8288D-03,-0.1516D-02,
     ,  -0.2099D-02,-0.2617D-02,-0.3087D-02,-0.3450D-02,-0.3739D-02,
     ,  -0.3983D-02,-0.4162D-02,-0.4317D-02,-0.4452D-02,-0.4535D-02,
     ,  -0.4616D-02,-0.4656D-02,-0.4705D-02,-0.4735D-02,-0.4787D-02,
     ,  -0.4783D-02,-0.4796D-02,-0.4814D-02,-0.4822D-02,-0.4829D-02,
     ,  -0.4830D-02,-0.4833D-02,-0.4839D-02/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.2195D+00,-0.1812D+00,-0.1495D+00,-0.1234D+00,-0.1018D+00,
     ,  -0.8401D-01,-0.6930D-01,-0.5714D-01,-0.4709D-01,-0.3879D-01,
     ,  -0.3192D-01,-0.2624D-01,-0.2153D-01,-0.1763D-01,-0.1440D-01,
     ,  -0.1172D-01,-0.9495D-02,-0.7647D-02,-0.6115D-02,-0.4846D-02,
     ,  -0.3797D-02,-0.2940D-02,-0.2250D-02,-0.1702D-02,-0.1284D-02,
     ,  -0.9805D-03,-0.7972D-03,-0.7179D-03,-0.7380D-03,-0.8599D-03,
     ,  -0.1070D-02,-0.1365D-02,-0.1724D-02,-0.2139D-02,-0.2542D-02,
     ,  -0.2851D-02,-0.2899D-02,-0.2505D-02,-0.1600D-02,-0.3311D-03,
     ,   0.9204D-03, 0.1854D-02, 0.2314D-02, 0.2405D-02, 0.2203D-02,
     ,   0.1797D-02, 0.1258D-02, 0.6512D-03, 0.1792D-04,-0.5726D-03,
     ,  -0.1114D-02,-0.1596D-02,-0.2001D-02,-0.2351D-02,-0.2637D-02,
     ,  -0.2855D-02,-0.3054D-02,-0.3209D-02,-0.3315D-02,-0.3401D-02,
     ,  -0.3480D-02,-0.3541D-02,-0.3587D-02,-0.3601D-02,-0.3623D-02,
     ,  -0.3646D-02,-0.3664D-02,-0.3673D-02,-0.3684D-02,-0.3690D-02,
     ,  -0.3673D-02,-0.3693D-02,-0.3699D-02/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.2195D+00,-0.1811D+00,-0.1495D+00,-0.1234D+00,-0.1018D+00,
     ,  -0.8398D-01,-0.6926D-01,-0.5711D-01,-0.4706D-01,-0.3875D-01,
     ,  -0.3187D-01,-0.2619D-01,-0.2147D-01,-0.1757D-01,-0.1433D-01,
     ,  -0.1163D-01,-0.9393D-02,-0.7529D-02,-0.5981D-02,-0.4689D-02,
     ,  -0.3622D-02,-0.2739D-02,-0.2018D-02,-0.1437D-02,-0.9862D-03,
     ,  -0.6551D-03,-0.4295D-03,-0.3104D-03,-0.2932D-03,-0.3784D-03,
     ,  -0.5554D-03,-0.8213D-03,-0.1165D-02,-0.1562D-02,-0.1979D-02,
     ,  -0.2341D-02,-0.2521D-02,-0.2363D-02,-0.1749D-02,-0.7267D-03,
     ,   0.4591D-03, 0.1462D-02, 0.2102D-02, 0.2356D-02, 0.2319D-02,
     ,   0.2077D-02, 0.1696D-02, 0.1225D-02, 0.7128D-03, 0.2036D-03,
     ,  -0.2951D-03,-0.7470D-03,-0.1117D-02,-0.1414D-02,-0.1692D-02,
     ,  -0.1922D-02,-0.2092D-02,-0.2240D-02,-0.2330D-02,-0.2433D-02,
     ,  -0.2508D-02,-0.2550D-02,-0.2592D-02,-0.2633D-02,-0.2636D-02,
     ,  -0.2674D-02,-0.2690D-02,-0.2683D-02,-0.2711D-02,-0.2697D-02,
     ,  -0.2725D-02,-0.2704D-02,-0.2710D-02/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.1928D+00,-0.1591D+00,-0.1313D+00,-0.1084D+00,-0.8942D-01,
     ,  -0.7377D-01,-0.6084D-01,-0.5016D-01,-0.4132D-01,-0.3402D-01,
     ,  -0.2798D-01,-0.2298D-01,-0.1884D-01,-0.1540D-01,-0.1255D-01,
     ,  -0.1018D-01,-0.8208D-02,-0.6569D-02,-0.5198D-02,-0.4061D-02,
     ,  -0.3112D-02,-0.2329D-02,-0.1684D-02,-0.1168D-02,-0.7621D-03,
     ,  -0.4569D-03,-0.2497D-03,-0.1383D-03,-0.1216D-03,-0.1884D-03,
     ,  -0.3488D-03,-0.5905D-03,-0.9053D-03,-0.1280D-02,-0.1683D-02,
     ,  -0.2058D-02,-0.2311D-02,-0.2310D-02,-0.1930D-02,-0.1140D-02,
     ,  -0.1000D-03, 0.9300D-03, 0.1693D-02, 0.2110D-02, 0.2229D-02,
     ,   0.2145D-02, 0.1909D-02, 0.1573D-02, 0.1171D-02, 0.7410D-03,
     ,   0.3237D-03,-0.5290D-04,-0.4010D-03,-0.7165D-03,-0.9598D-03,
     ,  -0.1160D-02,-0.1325D-02,-0.1447D-02,-0.1578D-02,-0.1655D-02,
     ,  -0.1708D-02,-0.1770D-02,-0.1796D-02,-0.1845D-02,-0.1855D-02,
     ,  -0.1871D-02,-0.1886D-02,-0.1901D-02,-0.1905D-02,-0.1915D-02,
     ,  -0.1915D-02,-0.1921D-02,-0.1925D-02/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.1561D+00,-0.1288D+00,-0.1063D+00,-0.8773D-01,-0.7239D-01,
     ,  -0.5972D-01,-0.4925D-01,-0.4060D-01,-0.3345D-01,-0.2754D-01,
     ,  -0.2265D-01,-0.1860D-01,-0.1525D-01,-0.1246D-01,-0.1015D-01,
     ,  -0.8234D-02,-0.6638D-02,-0.5306D-02,-0.4196D-02,-0.3271D-02,
     ,  -0.2503D-02,-0.1867D-02,-0.1346D-02,-0.9265D-03,-0.5961D-03,
     ,  -0.3514D-03,-0.1877D-03,-0.1020D-03,-0.8918D-04,-0.1589D-03,
     ,  -0.3014D-03,-0.5175D-03,-0.8006D-03,-0.1144D-02,-0.1520D-02,
     ,  -0.1878D-02,-0.2163D-02,-0.2265D-02,-0.2075D-02,-0.1519D-02,
     ,  -0.6517D-03, 0.3184D-03, 0.1149D-02, 0.1694D-02, 0.1958D-02,
     ,   0.2002D-02, 0.1902D-02, 0.1690D-02, 0.1401D-02, 0.1066D-02,
     ,   0.7210D-03, 0.3805D-03, 0.7509D-04,-0.1923D-03,-0.4245D-03,
     ,  -0.6141D-03,-0.7732D-03,-0.9014D-03,-0.9948D-03,-0.1075D-02,
     ,  -0.1138D-02,-0.1183D-02,-0.1228D-02,-0.1244D-02,-0.1287D-02,
     ,  -0.1301D-02,-0.1304D-02,-0.1316D-02,-0.1317D-02,-0.1324D-02,
     ,  -0.1327D-02,-0.1341D-02,-0.1335D-02/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.1196D+00,-0.9875D-01,-0.8150D-01,-0.6726D-01,-0.5549D-01,
     ,  -0.4578D-01,-0.3775D-01,-0.3113D-01,-0.2565D-01,-0.2111D-01,
     ,  -0.1736D-01,-0.1426D-01,-0.1169D-01,-0.9553D-02,-0.7783D-02,
     ,  -0.6311D-02,-0.5085D-02,-0.4065D-02,-0.3216D-02,-0.2508D-02,
     ,  -0.1919D-02,-0.1434D-02,-0.1036D-02,-0.7166D-03,-0.4676D-03,
     ,  -0.2834D-03,-0.1666D-03,-0.1077D-03,-0.1121D-03,-0.1791D-03,
     ,  -0.3077D-03,-0.4982D-03,-0.7484D-03,-0.1048D-02,-0.1381D-02,
     ,  -0.1722D-02,-0.2008D-02,-0.2176D-02,-0.2115D-02,-0.1771D-02,
     ,  -0.1122D-02,-0.2773D-03, 0.5569D-03, 0.1195D-02, 0.1572D-02,
     ,   0.1732D-02, 0.1740D-02, 0.1641D-02, 0.1459D-02, 0.1216D-02,
     ,   0.9460D-03, 0.6637D-03, 0.3981D-03, 0.1569D-03,-0.4751D-04,
     ,  -0.2241D-03,-0.3676D-03,-0.4873D-03,-0.5832D-03,-0.6563D-03,
     ,  -0.7199D-03,-0.7631D-03,-0.8002D-03,-0.8284D-03,-0.8474D-03,
     ,  -0.8974D-03,-0.8778D-03,-0.8878D-03,-0.8957D-03,-0.9008D-03,
     ,  -0.9053D-03,-0.9060D-03,-0.9111D-03/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.8838D-01,-0.7295D-01,-0.6020D-01,-0.4968D-01,-0.4099D-01,
     ,  -0.3381D-01,-0.2789D-01,-0.2299D-01,-0.1894D-01,-0.1559D-01,
     ,  -0.1283D-01,-0.1053D-01,-0.8633D-02,-0.7056D-02,-0.5750D-02,
     ,  -0.4664D-02,-0.3761D-02,-0.3006D-02,-0.2379D-02,-0.1859D-02,
     ,  -0.1425D-02,-0.1069D-02,-0.7786D-03,-0.5456D-03,-0.3663D-03,
     ,  -0.2384D-03,-0.1561D-03,-0.1241D-03,-0.1390D-03,-0.2033D-03,
     ,  -0.3165D-03,-0.4795D-03,-0.6952D-03,-0.9550D-03,-0.1243D-02,
     ,  -0.1546D-02,-0.1825D-02,-0.2018D-02,-0.2063D-02,-0.1875D-02,
     ,  -0.1430D-02,-0.7640D-03,-0.1403D-04, 0.6556D-03, 0.1123D-02,
     ,   0.1380D-02, 0.1473D-02, 0.1465D-02, 0.1377D-02, 0.1227D-02,
     ,   0.1026D-02, 0.8102D-03, 0.5864D-03, 0.3814D-03, 0.1908D-03,
     ,   0.3598D-04,-0.1003D-03,-0.2088D-03,-0.2959D-03,-0.3693D-03,
     ,  -0.4234D-03,-0.4700D-03,-0.5024D-03,-0.5302D-03,-0.5502D-03,
     ,  -0.5587D-03,-0.5783D-03,-0.5857D-03,-0.5944D-03,-0.5993D-03,
     ,  -0.6025D-03,-0.6055D-03,-0.6073D-03/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.6364D-01,-0.5253D-01,-0.4335D-01,-0.3577D-01,-0.2952D-01,
     ,  -0.2435D-01,-0.2008D-01,-0.1655D-01,-0.1364D-01,-0.1123D-01,
     ,  -0.9236D-02,-0.7587D-02,-0.6218D-02,-0.5085D-02,-0.4145D-02,
     ,  -0.3360D-02,-0.2711D-02,-0.2172D-02,-0.1722D-02,-0.1347D-02,
     ,  -0.1038D-02,-0.7832D-03,-0.5766D-03,-0.4128D-03,-0.2896D-03,
     ,  -0.2034D-03,-0.1515D-03,-0.1348D-03,-0.1581D-03,-0.2166D-03,
     ,  -0.3162D-03,-0.4566D-03,-0.6342D-03,-0.8457D-03,-0.1099D-02,
     ,  -0.1359D-02,-0.1612D-02,-0.1819D-02,-0.1916D-02,-0.1856D-02,
     ,  -0.1583D-02,-0.1103D-02,-0.4768D-03, 0.1531D-03, 0.6642D-03,
     ,   0.9863D-03, 0.1158D-02, 0.1214D-02, 0.1200D-02, 0.1126D-02,
     ,   0.1003D-02, 0.8417D-03, 0.6698D-03, 0.4984D-03, 0.3376D-03,
     ,   0.1913D-03, 0.7211D-04,-0.2946D-04,-0.1133D-03,-0.1787D-03,
     ,  -0.2303D-03,-0.2715D-03,-0.3055D-03,-0.3301D-03,-0.3494D-03,
     ,  -0.3655D-03,-0.3786D-03,-0.3870D-03,-0.3921D-03,-0.3979D-03,
     ,  -0.4044D-03,-0.4058D-03,-0.4061D-03/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.4503D-01,-0.3716D-01,-0.3067D-01,-0.2531D-01,-0.2088D-01,
     ,  -0.1723D-01,-0.1421D-01,-0.1172D-01,-0.9653D-02,-0.7947D-02,
     ,  -0.6536D-02,-0.5368D-02,-0.4403D-02,-0.3600D-02,-0.2934D-02,
     ,  -0.2383D-02,-0.1922D-02,-0.1541D-02,-0.1223D-02,-0.9609D-03,
     ,  -0.7444D-03,-0.5652D-03,-0.4232D-03,-0.3104D-03,-0.2265D-03,
     ,  -0.1685D-03,-0.1385D-03,-0.1371D-03,-0.1599D-03,-0.2135D-03,
     ,  -0.2970D-03,-0.4127D-03,-0.5589D-03,-0.7379D-03,-0.9432D-03,
     ,  -0.1166D-02,-0.1392D-02,-0.1587D-02,-0.1719D-02,-0.1735D-02,
     ,  -0.1595D-02,-0.1281D-02,-0.8148D-03,-0.2698D-03, 0.2358D-03,
     ,   0.6122D-03, 0.8342D-03, 0.9412D-03, 0.9787D-03, 0.9635D-03,
     ,   0.9046D-03, 0.8090D-03, 0.6826D-03, 0.5411D-03, 0.4069D-03,
     ,   0.2843D-03, 0.1744D-03, 0.8307D-04, 0.8774D-05,-0.5318D-04,
     ,  -0.1057D-03,-0.1425D-03,-0.1718D-03,-0.1983D-03,-0.2161D-03,
     ,  -0.2311D-03,-0.2417D-03,-0.2513D-03,-0.2561D-03,-0.2623D-03,
     ,  -0.2649D-03,-0.2665D-03,-0.2718D-03/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.3148D-01,-0.2598D-01,-0.2145D-01,-0.1770D-01,-0.1460D-01,
     ,  -0.1205D-01,-0.9935D-02,-0.8191D-02,-0.6749D-02,-0.5557D-02,
     ,  -0.4572D-02,-0.3755D-02,-0.3079D-02,-0.2519D-02,-0.2054D-02,
     ,  -0.1668D-02,-0.1348D-02,-0.1082D-02,-0.8613D-03,-0.6786D-03,
     ,  -0.5277D-03,-0.4056D-03,-0.3073D-03,-0.2315D-03,-0.1760D-03,
     ,  -0.1403D-03,-0.1241D-03,-0.1276D-03,-0.1520D-03,-0.1979D-03,
     ,  -0.2672D-03,-0.3609D-03,-0.4816D-03,-0.6244D-03,-0.7918D-03,
     ,  -0.9785D-03,-0.1167D-02,-0.1344D-02,-0.1482D-02,-0.1548D-02,
     ,  -0.1500D-02,-0.1318D-02,-0.9975D-03,-0.5752D-03,-0.1236D-03,
     ,   0.2686D-03, 0.5372D-03, 0.6849D-03, 0.7537D-03, 0.7782D-03,
     ,   0.7624D-03, 0.7161D-03, 0.6365D-03, 0.5396D-03, 0.4322D-03,
     ,   0.3293D-03, 0.2360D-03, 0.1525D-03, 0.8237D-04, 0.2681D-04,
     ,  -0.1796D-04,-0.5582D-04,-0.8511D-04,-0.1079D-03,-0.1259D-03,
     ,  -0.1397D-03,-0.1493D-03,-0.1563D-03,-0.1641D-03,-0.1670D-03,
     ,  -0.1717D-03,-0.1746D-03,-0.1764D-03/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.2183D-01,-0.1802D-01,-0.1487D-01,-0.1227D-01,-0.1013D-01,
     ,  -0.8354D-02,-0.6890D-02,-0.5680D-02,-0.4681D-02,-0.3854D-02,
     ,  -0.3171D-02,-0.2605D-02,-0.2137D-02,-0.1748D-02,-0.1427D-02,
     ,  -0.1159D-02,-0.9382D-03,-0.7545D-03,-0.6021D-03,-0.4761D-03,
     ,  -0.3733D-03,-0.2898D-03,-0.2236D-03,-0.1729D-03,-0.1371D-03,
     ,  -0.1156D-03,-0.1079D-03,-0.1150D-03,-0.1375D-03,-0.1769D-03,
     ,  -0.2329D-03,-0.3083D-03,-0.4017D-03,-0.5196D-03,-0.6539D-03,
     ,  -0.8022D-03,-0.9644D-03,-0.1121D-02,-0.1255D-02,-0.1337D-02,
     ,  -0.1350D-02,-0.1263D-02,-0.1062D-02,-0.7572D-03,-0.3922D-03,
     ,  -0.2952D-04, 0.2586D-03, 0.4489D-03, 0.5446D-03, 0.5871D-03,
     ,   0.6047D-03, 0.5925D-03, 0.5567D-03, 0.4942D-03, 0.4200D-03,
     ,   0.3351D-03, 0.2571D-03, 0.1854D-03, 0.1249D-03, 0.7106D-04,
     ,   0.3142D-04,-0.3800D-05,-0.3175D-04,-0.5290D-04,-0.7031D-04,
     ,  -0.8235D-04,-0.9291D-04,-0.9979D-04,-0.1065D-03,-0.1102D-03,
     ,  -0.1142D-03,-0.1169D-03,-0.1171D-03/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.1505D-01,-0.1242D-01,-0.1025D-01,-0.8463D-02,-0.6983D-02,
     ,  -0.5761D-02,-0.4751D-02,-0.3917D-02,-0.3228D-02,-0.2658D-02,
     ,  -0.2187D-02,-0.1797D-02,-0.1474D-02,-0.1207D-02,-0.9854D-03,
     ,  -0.8017D-03,-0.6491D-03,-0.5227D-03,-0.4184D-03,-0.3326D-03,
     ,  -0.2621D-03,-0.2059D-03,-0.1614D-03,-0.1281D-03,-0.1056D-03,
     ,  -0.9298D-04,-0.9070D-04,-0.9921D-04,-0.1193D-03,-0.1508D-03,
     ,  -0.1967D-03,-0.2562D-03,-0.3318D-03,-0.4232D-03,-0.5289D-03,
     ,  -0.6533D-03,-0.7824D-03,-0.9144D-03,-0.1032D-02,-0.1124D-02,
     ,  -0.1161D-02,-0.1134D-02,-0.1026D-02,-0.8301D-03,-0.5587D-03,
     ,  -0.2573D-03, 0.2754D-04, 0.2372D-03, 0.3647D-03, 0.4250D-03,
     ,   0.4550D-03, 0.4653D-03, 0.4579D-03, 0.4301D-03, 0.3814D-03,
     ,   0.3234D-03, 0.2592D-03, 0.2001D-03, 0.1459D-03, 0.1004D-03,
     ,   0.6206D-04, 0.3054D-04, 0.5005D-05,-0.1529D-04,-0.3145D-04,
     ,  -0.4280D-04,-0.5279D-04,-0.6009D-04,-0.6461D-04,-0.6975D-04,
     ,  -0.7142D-04,-0.7405D-04,-0.7687D-04/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.1034D-01,-0.8535D-02,-0.7044D-02,-0.5813D-02,-0.4797D-02,
     ,  -0.3957D-02,-0.3264D-02,-0.2691D-02,-0.2218D-02,-0.1827D-02,
     ,  -0.1503D-02,-0.1235D-02,-0.1014D-02,-0.8300D-03,-0.6781D-03,
     ,  -0.5520D-03,-0.4475D-03,-0.3612D-03,-0.2900D-03,-0.2314D-03,
     ,  -0.1840D-03,-0.1460D-03,-0.1165D-03,-0.9487D-04,-0.8076D-04,
     ,  -0.7380D-04,-0.7447D-04,-0.8284D-04,-0.9979D-04,-0.1259D-03,
     ,  -0.1618D-03,-0.2088D-03,-0.2675D-03,-0.3390D-03,-0.4246D-03,
     ,  -0.5190D-03,-0.6256D-03,-0.7331D-03,-0.8353D-03,-0.9176D-03,
     ,  -0.9750D-03,-0.9827D-03,-0.9322D-03,-0.8181D-03,-0.6370D-03,
     ,  -0.4077D-03,-0.1615D-03, 0.5622D-04, 0.2065D-03, 0.2932D-03,
     ,   0.3289D-03, 0.3482D-03, 0.3560D-03, 0.3508D-03, 0.3292D-03,
     ,   0.2929D-03, 0.2470D-03, 0.1994D-03, 0.1532D-03, 0.1134D-03,
     ,   0.8026D-04, 0.4958D-04, 0.2571D-04, 0.8824D-05,-0.4251D-05,
     ,  -0.1789D-04,-0.2634D-04,-0.3497D-04,-0.3971D-04,-0.4458D-04,
     ,  -0.4667D-04,-0.4931D-04,-0.5115D-04/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.7085D-02,-0.5848D-02,-0.4826D-02,-0.3983D-02,-0.3286D-02,
     ,  -0.2711D-02,-0.2236D-02,-0.1844D-02,-0.1520D-02,-0.1252D-02,
     ,  -0.1030D-02,-0.8469D-03,-0.6951D-03,-0.5696D-03,-0.4654D-03,
     ,  -0.3793D-03,-0.3081D-03,-0.2492D-03,-0.2007D-03,-0.1610D-03,
     ,  -0.1291D-03,-0.1036D-03,-0.8413D-04,-0.7023D-04,-0.6153D-04,
     ,  -0.5850D-04,-0.6049D-04,-0.6834D-04,-0.8209D-04,-0.1031D-03,
     ,  -0.1309D-03,-0.1674D-03,-0.2129D-03,-0.2685D-03,-0.3341D-03,
     ,  -0.4101D-03,-0.4933D-03,-0.5798D-03,-0.6654D-03,-0.7413D-03,
     ,  -0.7963D-03,-0.8243D-03,-0.8126D-03,-0.7496D-03,-0.6400D-03,
     ,  -0.4792D-03,-0.2889D-03,-0.9489D-04, 0.6815D-04, 0.1743D-03,
     ,   0.2291D-03, 0.2511D-03, 0.2624D-03, 0.2690D-03, 0.2656D-03,
     ,   0.2493D-03, 0.2217D-03, 0.1868D-03, 0.1509D-03, 0.1162D-03,
     ,   0.8382D-04, 0.6068D-04, 0.4184D-04, 0.2273D-04, 0.9007D-05,
     ,   0.2874D-06,-0.9350D-05,-0.1544D-04,-0.2123D-04,-0.2403D-04,
     ,  -0.2841D-04,-0.3057D-04,-0.3203D-04/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.4845D-02,-0.3999D-02,-0.3301D-02,-0.2724D-02,-0.2248D-02,
     ,  -0.1855D-02,-0.1530D-02,-0.1261D-02,-0.1040D-02,-0.8563D-03,
     ,  -0.7048D-03,-0.5795D-03,-0.4758D-03,-0.3900D-03,-0.3190D-03,
     ,  -0.2603D-03,-0.2117D-03,-0.1717D-03,-0.1386D-03,-0.1120D-03,
     ,  -0.9023D-04,-0.7332D-04,-0.6073D-04,-0.5187D-04,-0.4684D-04,
     ,  -0.4539D-04,-0.4804D-04,-0.5485D-04,-0.6613D-04,-0.8213D-04,
     ,  -0.1043D-03,-0.1324D-03,-0.1679D-03,-0.2106D-03,-0.2613D-03,
     ,  -0.3200D-03,-0.3851D-03,-0.4551D-03,-0.5229D-03,-0.5883D-03,
     ,  -0.6398D-03,-0.6735D-03,-0.6831D-03,-0.6566D-03,-0.5952D-03,
     ,  -0.4926D-03,-0.3596D-03,-0.2052D-03,-0.5362D-04, 0.6722D-04,
     ,   0.1428D-03, 0.1773D-03, 0.1905D-03, 0.1973D-03, 0.2023D-03,
     ,   0.1998D-03, 0.1878D-03, 0.1666D-03, 0.1405D-03, 0.1131D-03,
     ,   0.8821D-04, 0.6530D-04, 0.4603D-04, 0.3097D-04, 0.1785D-04,
     ,   0.7989D-05, 0.6534D-06,-0.5596D-05,-0.1033D-04,-0.1420D-04,
     ,  -0.1668D-04,-0.1888D-04,-0.2071D-04/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.3310D-02,-0.2732D-02,-0.2255D-02,-0.1861D-02,-0.1535D-02,
     ,  -0.1267D-02,-0.1045D-02,-0.8617D-03,-0.7103D-03,-0.5851D-03,
     ,  -0.4816D-03,-0.3961D-03,-0.3254D-03,-0.2668D-03,-0.2184D-03,
     ,  -0.1783D-03,-0.1453D-03,-0.1180D-03,-0.9579D-04,-0.7767D-04,
     ,  -0.6325D-04,-0.5201D-04,-0.4369D-04,-0.3811D-04,-0.3526D-04,
     ,  -0.3509D-04,-0.3771D-04,-0.4338D-04,-0.5234D-04,-0.6509D-04,
     ,  -0.8200D-04,-0.1035D-03,-0.1304D-03,-0.1631D-03,-0.2022D-03,
     ,  -0.2473D-03,-0.2979D-03,-0.3523D-03,-0.4085D-03,-0.4608D-03,
     ,  -0.5070D-03,-0.5391D-03,-0.5540D-03,-0.5522D-03,-0.5210D-03,
     ,  -0.4637D-03,-0.3753D-03,-0.2638D-03,-0.1418D-03,-0.2584D-04,
     ,   0.6278D-04, 0.1149D-03, 0.1363D-03, 0.1433D-03, 0.1478D-03,
     ,   0.1518D-03, 0.1502D-03, 0.1410D-03, 0.1251D-03, 0.1057D-03,
     ,   0.8431D-04, 0.6629D-04, 0.4900D-04, 0.3573D-04, 0.2440D-04,
     ,   0.1515D-04, 0.7565D-05, 0.2151D-05,-0.2189D-05,-0.5570D-05,
     ,  -0.8495D-05,-0.1048D-04,-0.1192D-04/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.2259D-02,-0.1864D-02,-0.1539D-02,-0.1270D-02,-0.1048D-02,
     ,  -0.8647D-03,-0.7133D-03,-0.5882D-03,-0.4849D-03,-0.3995D-03,
     ,  -0.3289D-03,-0.2706D-03,-0.2223D-03,-0.1824D-03,-0.1494D-03,
     ,  -0.1222D-03,-0.9971D-04,-0.8128D-04,-0.6617D-04,-0.5401D-04,
     ,  -0.4433D-04,-0.3694D-04,-0.3153D-04,-0.2812D-04,-0.2657D-04,
     ,  -0.2700D-04,-0.2943D-04,-0.3398D-04,-0.4130D-04,-0.5109D-04,
     ,  -0.6411D-04,-0.8056D-04,-0.1007D-03,-0.1257D-03,-0.1553D-03,
     ,  -0.1900D-03,-0.2290D-03,-0.2714D-03,-0.3151D-03,-0.3578D-03,
     ,  -0.3959D-03,-0.4266D-03,-0.4471D-03,-0.4522D-03,-0.4405D-03,
     ,  -0.4093D-03,-0.3568D-03,-0.2839D-03,-0.1938D-03,-0.9761D-04,
     ,  -0.1023D-04, 0.5464D-04, 0.9015D-04, 0.1030D-03, 0.1062D-03,
     ,   0.1091D-03, 0.1122D-03, 0.1114D-03, 0.1046D-03, 0.9294D-04,
     ,   0.7914D-04, 0.6298D-04, 0.4892D-04, 0.3648D-04, 0.2629D-04,
     ,   0.1786D-04, 0.1134D-04, 0.6101D-05, 0.1844D-05,-0.1389D-05,
     ,  -0.3763D-05,-0.5790D-05,-0.7130D-05/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.1541D-02,-0.1272D-02,-0.1050D-02,-0.8663D-03,-0.7149D-03,
     ,  -0.5899D-03,-0.4866D-03,-0.4013D-03,-0.3308D-03,-0.2726D-03,
     ,  -0.2245D-03,-0.1847D-03,-0.1518D-03,-0.1246D-03,-0.1022D-03,
     ,  -0.8363D-04,-0.6837D-04,-0.5586D-04,-0.4568D-04,-0.3749D-04,
     ,  -0.3108D-04,-0.2615D-04,-0.2273D-04,-0.2063D-04,-0.1992D-04,
     ,  -0.2054D-04,-0.2268D-04,-0.2639D-04,-0.3188D-04,-0.3933D-04,
     ,  -0.4899D-04,-0.6172D-04,-0.7727D-04,-0.9582D-04,-0.1185D-03,
     ,  -0.1447D-03,-0.1744D-03,-0.2072D-03,-0.2414D-03,-0.2750D-03,
     ,  -0.3062D-03,-0.3328D-03,-0.3518D-03,-0.3621D-03,-0.3614D-03,
     ,  -0.3468D-03,-0.3175D-03,-0.2721D-03,-0.2117D-03,-0.1407D-03,
     ,  -0.6612D-04,-0.4365D-06, 0.4601D-04, 0.7036D-04, 0.7764D-04,
     ,   0.7903D-04, 0.8107D-04, 0.8332D-04, 0.8288D-04, 0.7763D-04,
     ,   0.7001D-04, 0.5770D-04, 0.4657D-04, 0.3610D-04, 0.2708D-04,
     ,   0.1965D-04, 0.1364D-04, 0.8665D-05, 0.4857D-05, 0.1948D-05,
     ,  -0.5276D-06,-0.2261D-05,-0.3609D-05/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.1051D-02,-0.8672D-03,-0.7158D-03,-0.5907D-03,-0.4875D-03,
     ,  -0.4022D-03,-0.3318D-03,-0.2737D-03,-0.2256D-03,-0.1860D-03,
     ,  -0.1532D-03,-0.1260D-03,-0.1036D-03,-0.8513D-04,-0.6985D-04,
     ,  -0.5726D-04,-0.4690D-04,-0.3842D-04,-0.3157D-04,-0.2605D-04,
     ,  -0.2177D-04,-0.1856D-04,-0.1633D-04,-0.1510D-04,-0.1482D-04,
     ,  -0.1555D-04,-0.1733D-04,-0.2024D-04,-0.2452D-04,-0.3024D-04,
     ,  -0.3780D-04,-0.4695D-04,-0.5854D-04,-0.7300D-04,-0.8953D-04,
     ,  -0.1096D-03,-0.1322D-03,-0.1570D-03,-0.1834D-03,-0.2098D-03,
     ,  -0.2350D-03,-0.2568D-03,-0.2742D-03,-0.2856D-03,-0.2893D-03,
     ,  -0.2847D-03,-0.2697D-03,-0.2436D-03,-0.2058D-03,-0.1574D-03,
     ,  -0.1016D-03,-0.4468D-04, 0.4762D-05, 0.3804D-04, 0.5439D-04,
     ,   0.5818D-04, 0.5807D-04, 0.5975D-04, 0.6159D-04, 0.6120D-04,
     ,   0.5609D-04, 0.5088D-04, 0.4288D-04, 0.3444D-04, 0.2688D-04,
     ,   0.2038D-04, 0.1470D-04, 0.1023D-04, 0.6761D-05, 0.3933D-05,
     ,   0.1852D-05, 0.6228D-07,-0.1201D-05/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.7162D-03,-0.5912D-03,-0.4879D-03,-0.4027D-03,-0.3323D-03,
     ,  -0.2742D-03,-0.2262D-03,-0.1866D-03,-0.1538D-03,-0.1268D-03,
     ,  -0.1045D-03,-0.8599D-04,-0.7075D-04,-0.5816D-04,-0.4775D-04,
     ,  -0.3921D-04,-0.3218D-04,-0.2645D-04,-0.2180D-04,-0.1813D-04,
     ,  -0.1523D-04,-0.1317D-04,-0.1176D-04,-0.1109D-04,-0.1103D-04,
     ,  -0.1173D-04,-0.1316D-04,-0.1547D-04,-0.1871D-04,-0.2304D-04,
     ,  -0.2856D-04,-0.3566D-04,-0.4447D-04,-0.5479D-04,-0.6780D-04,
     ,  -0.8265D-04,-0.9977D-04,-0.1188D-03,-0.1388D-03,-0.1592D-03,
     ,  -0.1786D-03,-0.1965D-03,-0.2114D-03,-0.2222D-03,-0.2283D-03,
     ,  -0.2283D-03,-0.2218D-03,-0.2079D-03,-0.1859D-03,-0.1550D-03,
     ,  -0.1162D-03,-0.7296D-04,-0.2958D-04, 0.6845D-05, 0.3097D-04,
     ,   0.4170D-04, 0.4342D-04, 0.4281D-04, 0.4351D-04, 0.4520D-04,
     ,   0.4538D-04, 0.4243D-04, 0.3738D-04, 0.3147D-04, 0.2528D-04,
     ,   0.1945D-04, 0.1473D-04, 0.1089D-04, 0.7673D-05, 0.4944D-05,
     ,   0.2972D-05, 0.1522D-05, 0.9767D-07/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.4881D-03,-0.4029D-03,-0.3325D-03,-0.2745D-03,-0.2265D-03,
     ,  -0.1869D-03,-0.1542D-03,-0.1272D-03,-0.1049D-03,-0.8646D-04,
     ,  -0.7123D-04,-0.5867D-04,-0.4828D-04,-0.3970D-04,-0.3265D-04,
     ,  -0.2683D-04,-0.2207D-04,-0.1819D-04,-0.1506D-04,-0.1259D-04,
     ,  -0.1072D-04,-0.9328D-05,-0.8487D-05,-0.8084D-05,-0.8181D-05,
     ,  -0.8773D-05,-0.9949D-05,-0.1172D-04,-0.1416D-04,-0.1743D-04,
     ,  -0.2163D-04,-0.2685D-04,-0.3331D-04,-0.4133D-04,-0.5077D-04,
     ,  -0.6190D-04,-0.7461D-04,-0.8914D-04,-0.1043D-03,-0.1200D-03,
     ,  -0.1351D-03,-0.1492D-03,-0.1613D-03,-0.1708D-03,-0.1775D-03,
     ,  -0.1803D-03,-0.1785D-03,-0.1716D-03,-0.1589D-03,-0.1402D-03,
     ,  -0.1159D-03,-0.8576D-04,-0.5243D-04,-0.1978D-04, 0.7365D-05,
     ,   0.2447D-04, 0.3150D-04, 0.3200D-04, 0.3144D-04, 0.3191D-04,
     ,   0.3305D-04, 0.3304D-04, 0.3105D-04, 0.2743D-04, 0.2303D-04,
     ,   0.1861D-04, 0.1446D-04, 0.1079D-04, 0.7958D-05, 0.5647D-05,
     ,   0.3663D-05, 0.2249D-05, 0.1182D-05/
      data (calcpts(j,45), j = 1,neta) /
     ,  -0.3327D-03,-0.2746D-03,-0.2266D-03,-0.1871D-03,-0.1544D-03,
     ,  -0.1274D-03,-0.1051D-03,-0.8670D-04,-0.7150D-04,-0.5895D-04,
     ,  -0.4858D-04,-0.4001D-04,-0.3294D-04,-0.2711D-04,-0.2231D-04,
     ,  -0.1837D-04,-0.1513D-04,-0.1251D-04,-0.1041D-04,-0.8761D-05,
     ,  -0.7506D-05,-0.6625D-05,-0.6085D-05,-0.5879D-05,-0.6008D-05,
     ,  -0.6543D-05,-0.7441D-05,-0.8823D-05,-0.1065D-04,-0.1310D-04,
     ,  -0.1619D-04,-0.2009D-04,-0.2494D-04,-0.3079D-04,-0.3787D-04,
     ,  -0.4627D-04,-0.5597D-04,-0.6659D-04,-0.7820D-04,-0.8980D-04,
     ,  -0.1017D-03,-0.1125D-03,-0.1223D-03,-0.1306D-03,-0.1364D-03,
     ,  -0.1396D-03,-0.1404D-03,-0.1376D-03,-0.1309D-03,-0.1207D-03,
     ,  -0.1057D-03,-0.8578D-04,-0.6278D-04,-0.3705D-04,-0.1289D-04,
     ,   0.6884D-05, 0.1931D-04, 0.2385D-04, 0.2374D-04, 0.2296D-04,
     ,   0.2336D-04, 0.2422D-04, 0.2427D-04, 0.2284D-04, 0.2012D-04,
     ,   0.1689D-04, 0.1355D-04, 0.1060D-04, 0.7940D-05, 0.6009D-05,
     ,   0.4308D-05, 0.2884D-05, 0.1794D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,  -0.2267D-03,-0.1871D-03,-0.1544D-03,-0.1275D-03,-0.1052D-03,
     ,  -0.8681D-04,-0.7163D-04,-0.5909D-04,-0.4874D-04,-0.4018D-04,
     ,  -0.3312D-04,-0.2730D-04,-0.2248D-04,-0.1852D-04,-0.1525D-04,
     ,  -0.1257D-04,-0.1039D-04,-0.8618D-05,-0.7205D-05,-0.6105D-05,
     ,  -0.5278D-05,-0.4712D-05,-0.4382D-05,-0.4296D-05,-0.4469D-05,
     ,  -0.4879D-05,-0.5591D-05,-0.6607D-05,-0.8014D-05,-0.9823D-05,
     ,  -0.1215D-04,-0.1503D-04,-0.1860D-04,-0.2296D-04,-0.2821D-04,
     ,  -0.3437D-04,-0.4151D-04,-0.4945D-04,-0.5805D-04,-0.6723D-04,
     ,  -0.7598D-04,-0.8446D-04,-0.9240D-04,-0.9890D-04,-0.1040D-03,
     ,  -0.1077D-03,-0.1093D-03,-0.1086D-03,-0.1057D-03,-0.9985D-04,
     ,  -0.9089D-04,-0.7878D-04,-0.6355D-04,-0.4599D-04,-0.2656D-04,
     ,  -0.8271D-05, 0.6168D-05, 0.1484D-04, 0.1775D-04, 0.1737D-04,
     ,   0.1662D-04, 0.1689D-04, 0.1760D-04, 0.1761D-04, 0.1660D-04,
     ,   0.1458D-04, 0.1222D-04, 0.9802D-05, 0.7345D-05, 0.5728D-05,
     ,   0.4214D-05, 0.2925D-05, 0.1795D-05/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.1545D-03,-0.1275D-03,-0.1052D-03,-0.8685D-04,-0.7168D-04,
     ,  -0.5916D-04,-0.4881D-04,-0.4027D-04,-0.3322D-04,-0.2740D-04,
     ,  -0.2259D-04,-0.1862D-04,-0.1534D-04,-0.1265D-04,-0.1043D-04,
     ,  -0.8612D-05,-0.7129D-05,-0.5934D-05,-0.4983D-05,-0.4247D-05,
     ,  -0.3705D-05,-0.3340D-05,-0.3146D-05,-0.3123D-05,-0.3271D-05,
     ,  -0.3608D-05,-0.4147D-05,-0.4920D-05,-0.5977D-05,-0.7321D-05,
     ,  -0.9008D-05,-0.1119D-04,-0.1380D-04,-0.1701D-04,-0.2088D-04,
     ,  -0.2548D-04,-0.3079D-04,-0.3675D-04,-0.4323D-04,-0.4986D-04,
     ,  -0.5682D-04,-0.6340D-04,-0.6909D-04,-0.7427D-04,-0.7859D-04,
     ,  -0.8199D-04,-0.8359D-04,-0.8439D-04,-0.8315D-04,-0.8028D-04,
     ,  -0.7528D-04,-0.6842D-04,-0.5867D-04,-0.4674D-04,-0.3332D-04,
     ,  -0.1883D-04,-0.5297D-05, 0.5315D-05, 0.1151D-04, 0.1328D-04,
     ,   0.1275D-04, 0.1211D-04, 0.1226D-04, 0.1264D-04, 0.1282D-04,
     ,   0.1209D-04, 0.1067D-04, 0.8898D-05, 0.5853D-05, 0.5507D-05,
     ,   0.4207D-05, 0.2691D-05, 0.2456D-05/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.1052D-03,-0.8687D-04,-0.7170D-04,-0.5918D-04,-0.4884D-04,
     ,  -0.4031D-04,-0.3326D-04,-0.2744D-04,-0.2264D-04,-0.1867D-04,
     ,  -0.1540D-04,-0.1270D-04,-0.1047D-04,-0.8635D-05,-0.7131D-05,
     ,  -0.5897D-05,-0.4894D-05,-0.4087D-05,-0.3450D-05,-0.2958D-05,
     ,  -0.2604D-05,-0.2369D-05,-0.2257D-05,-0.2264D-05,-0.2395D-05,
     ,  -0.2662D-05,-0.3073D-05,-0.3649D-05,-0.4419D-05,-0.5407D-05,
     ,  -0.6703D-05,-0.8236D-05,-0.1018D-04,-0.1255D-04,-0.1540D-04,
     ,  -0.1882D-04,-0.2271D-04,-0.2714D-04,-0.3192D-04,-0.3698D-04,
     ,  -0.4201D-04,-0.4688D-04,-0.5147D-04,-0.5580D-04,-0.5912D-04,
     ,  -0.6174D-04,-0.6390D-04,-0.6476D-04,-0.6483D-04,-0.6324D-04,
     ,  -0.6068D-04,-0.5653D-04,-0.5093D-04,-0.4352D-04,-0.3444D-04,
     ,  -0.2416D-04,-0.1331D-04,-0.3320D-05, 0.4699D-05, 0.8730D-05,
     ,   0.9857D-05, 0.9307D-05, 0.8783D-05, 0.9044D-05, 0.9301D-05,
     ,   0.9341D-05, 0.8783D-05, 0.7743D-05, 0.7925D-05, 0.5210D-05,
     ,   0.4042D-05, 0.3531D-05, 0.2222D-05/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.7169D-04,-0.5917D-04,-0.4883D-04,-0.4030D-04,-0.3325D-04,
     ,  -0.2743D-04,-0.2262D-04,-0.1865D-04,-0.1537D-04,-0.1265D-04,
     ,  -0.1041D-04,-0.8548D-05,-0.7009D-05,-0.5732D-05,-0.4672D-05,
     ,  -0.3791D-05,-0.3060D-05,-0.2454D-05,-0.1947D-05,-0.1529D-05,
     ,  -0.1184D-05,-0.9024D-06,-0.6797D-06,-0.5027D-06,-0.3732D-06,
     ,  -0.2887D-06,-0.2510D-06,-0.2668D-06,-0.3276D-06,-0.4580D-06,
     ,  -0.6338D-06,-0.9331D-06,-0.1300D-05,-0.1828D-05,-0.2494D-05,
     ,  -0.3311D-05,-0.4415D-05,-0.5770D-05,-0.7333D-05,-0.9026D-05,
     ,  -0.1089D-04,-0.1277D-04,-0.1462D-04,-0.1621D-04,-0.1774D-04,
     ,  -0.1900D-04,-0.1989D-04,-0.2047D-04,-0.2063D-04,-0.2047D-04,
     ,  -0.1975D-04,-0.1845D-04,-0.1656D-04,-0.1401D-04,-0.1069D-04,
     ,  -0.6630D-05,-0.2017D-05, 0.2898D-05, 0.7094D-05, 0.1086D-04,
     ,   0.1261D-04, 0.1278D-04, 0.1207D-04, 0.1125D-04, 0.1072D-04,
     ,   0.1016D-04, 0.9335D-05, 0.8207D-05, 0.6582D-05, 0.5571D-05,
     ,   0.4390D-05, 0.3281D-05, 0.2542D-05/


      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0,
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0,
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0,
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0,
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0,
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0,
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0,
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0,
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0,
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

c      coeff=coeff/sqrt(1+eta/1.)

      return
      end  
c--------------------------
      subroutine c2hqg21(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init
 
      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.8345D-02,-0.4070D-02, 0.4170D-03, 0.5433D-02, 0.1054D-01,
     ,   0.1618D-01, 0.2214D-01, 0.2836D-01, 0.3499D-01, 0.4192D-01,
     ,   0.4906D-01, 0.5664D-01, 0.6421D-01, 0.7202D-01, 0.7984D-01,
     ,   0.8748D-01, 0.9495D-01, 0.1021D+00, 0.1086D+00, 0.1144D+00,
     ,   0.1193D+00, 0.1230D+00, 0.1253D+00, 0.1262D+00, 0.1253D+00,
     ,   0.1226D+00, 0.1182D+00, 0.1119D+00, 0.1040D+00, 0.9454D-01,
     ,   0.8369D-01, 0.7133D-01, 0.5746D-01, 0.4205D-01, 0.2571D-01,
     ,   0.1013D-01,-0.2491D-02,-0.1036D-01,-0.1310D-01,-0.1187D-01,
     ,  -0.8286D-02,-0.3718D-02, 0.8679D-03, 0.4855D-02, 0.7852D-02,
     ,   0.9592D-02, 0.9972D-02, 0.8928D-02, 0.6503D-02, 0.2766D-02,
     ,  -0.2082D-02,-0.7980D-02,-0.1476D-01,-0.2234D-01,-0.3037D-01,
     ,  -0.3831D-01,-0.4541D-01,-0.5146D-01,-0.5733D-01,-0.6450D-01,
     ,  -0.7393D-01,-0.8550D-01,-0.9842D-01,-0.1117D+00,-0.1246D+00,
     ,  -0.1365D+00,-0.1470D+00,-0.1562D+00,-0.1640D+00,-0.1705D+00,
     ,  -0.1758D+00,-0.1801D+00,-0.1835D+00/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.8346D-02,-0.4069D-02, 0.5394D-03, 0.5420D-02, 0.1065D-01,
     ,   0.1629D-01, 0.2213D-01, 0.2836D-01, 0.3499D-01, 0.4202D-01,
     ,   0.4914D-01, 0.5652D-01, 0.6422D-01, 0.7193D-01, 0.7977D-01,
     ,   0.8749D-01, 0.9488D-01, 0.1020D+00, 0.1085D+00, 0.1143D+00,
     ,   0.1193D+00, 0.1230D+00, 0.1253D+00, 0.1262D+00, 0.1253D+00,
     ,   0.1226D+00, 0.1181D+00, 0.1119D+00, 0.1040D+00, 0.9451D-01,
     ,   0.8372D-01, 0.7135D-01, 0.5747D-01, 0.4206D-01, 0.2572D-01,
     ,   0.1013D-01,-0.2487D-02,-0.1037D-01,-0.1310D-01,-0.1187D-01,
     ,  -0.8283D-02,-0.3714D-02, 0.8706D-03, 0.4854D-02, 0.7856D-02,
     ,   0.9593D-02, 0.9979D-02, 0.8936D-02, 0.6484D-02, 0.2780D-02,
     ,  -0.2077D-02,-0.7975D-02,-0.1478D-01,-0.2232D-01,-0.3037D-01,
     ,  -0.3833D-01,-0.4539D-01,-0.5145D-01,-0.5732D-01,-0.6451D-01,
     ,  -0.7393D-01,-0.8548D-01,-0.9841D-01,-0.1117D+00,-0.1246D+00,
     ,  -0.1364D+00,-0.1470D+00,-0.1562D+00,-0.1640D+00,-0.1704D+00,
     ,  -0.1758D+00,-0.1801D+00,-0.1835D+00/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.8346D-02,-0.4069D-02, 0.5393D-03, 0.5420D-02, 0.1065D-01,
     ,   0.1617D-01, 0.2203D-01, 0.2848D-01, 0.3498D-01, 0.4192D-01,
     ,   0.4916D-01, 0.5662D-01, 0.6421D-01, 0.7202D-01, 0.7975D-01,
     ,   0.8741D-01, 0.9489D-01, 0.1020D+00, 0.1086D+00, 0.1144D+00,
     ,   0.1192D+00, 0.1229D+00, 0.1253D+00, 0.1262D+00, 0.1253D+00,
     ,   0.1226D+00, 0.1182D+00, 0.1119D+00, 0.1040D+00, 0.9452D-01,
     ,   0.8363D-01, 0.7136D-01, 0.5742D-01, 0.4206D-01, 0.2576D-01,
     ,   0.1013D-01,-0.2505D-02,-0.1035D-01,-0.1309D-01,-0.1186D-01,
     ,  -0.8281D-02,-0.3707D-02, 0.8739D-03, 0.4861D-02, 0.7859D-02,
     ,   0.9636D-02, 0.9974D-02, 0.8918D-02, 0.6500D-02, 0.2791D-02,
     ,  -0.2093D-02,-0.7981D-02,-0.1476D-01,-0.2230D-01,-0.3036D-01,
     ,  -0.3832D-01,-0.4541D-01,-0.5142D-01,-0.5731D-01,-0.6451D-01,
     ,  -0.7392D-01,-0.8549D-01,-0.9842D-01,-0.1117D+00,-0.1246D+00,
     ,  -0.1364D+00,-0.1470D+00,-0.1562D+00,-0.1640D+00,-0.1705D+00,
     ,  -0.1758D+00,-0.1800D+00,-0.1835D+00/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.8236D-02,-0.4083D-02, 0.5348D-03, 0.5417D-02, 0.1065D-01,
     ,   0.1617D-01, 0.2214D-01, 0.2836D-01, 0.3499D-01, 0.4192D-01,
     ,   0.4916D-01, 0.5653D-01, 0.6423D-01, 0.7193D-01, 0.7977D-01,
     ,   0.8750D-01, 0.9488D-01, 0.1020D+00, 0.1085D+00, 0.1143D+00,
     ,   0.1192D+00, 0.1229D+00, 0.1253D+00, 0.1261D+00, 0.1252D+00,
     ,   0.1226D+00, 0.1181D+00, 0.1119D+00, 0.1039D+00, 0.9453D-01,
     ,   0.8363D-01, 0.7134D-01, 0.5746D-01, 0.4206D-01, 0.2571D-01,
     ,   0.1012D-01,-0.2485D-02,-0.1035D-01,-0.1309D-01,-0.1186D-01,
     ,  -0.8272D-02,-0.3702D-02, 0.8809D-03, 0.4864D-02, 0.7866D-02,
     ,   0.9606D-02, 0.9983D-02, 0.8944D-02, 0.6515D-02, 0.2784D-02,
     ,  -0.2066D-02,-0.7958D-02,-0.1474D-01,-0.2232D-01,-0.3035D-01,
     ,  -0.3829D-01,-0.4538D-01,-0.5143D-01,-0.5731D-01,-0.6448D-01,
     ,  -0.7390D-01,-0.8547D-01,-0.9839D-01,-0.1117D+00,-0.1246D+00,
     ,  -0.1364D+00,-0.1470D+00,-0.1562D+00,-0.1640D+00,-0.1704D+00,
     ,  -0.1757D+00,-0.1800D+00,-0.1835D+00/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.8236D-02,-0.4083D-02, 0.5347D-03, 0.5417D-02, 0.1065D-01,
     ,   0.1617D-01, 0.2214D-01, 0.2836D-01, 0.3499D-01, 0.4192D-01,
     ,   0.4906D-01, 0.5654D-01, 0.6423D-01, 0.7194D-01, 0.7969D-01,
     ,   0.8743D-01, 0.9482D-01, 0.1020D+00, 0.1085D+00, 0.1143D+00,
     ,   0.1192D+00, 0.1229D+00, 0.1253D+00, 0.1261D+00, 0.1252D+00,
     ,   0.1226D+00, 0.1181D+00, 0.1118D+00, 0.1039D+00, 0.9447D-01,
     ,   0.8360D-01, 0.7132D-01, 0.5745D-01, 0.4205D-01, 0.2570D-01,
     ,   0.1015D-01,-0.2501D-02,-0.1033D-01,-0.1308D-01,-0.1185D-01,
     ,  -0.8265D-02,-0.3658D-02, 0.8695D-03, 0.4870D-02, 0.7868D-02,
     ,   0.9646D-02, 0.9989D-02, 0.8931D-02, 0.6512D-02, 0.2806D-02,
     ,  -0.2079D-02,-0.7959D-02,-0.1474D-01,-0.2229D-01,-0.3036D-01,
     ,  -0.3828D-01,-0.4538D-01,-0.5143D-01,-0.5731D-01,-0.6447D-01,
     ,  -0.7389D-01,-0.8546D-01,-0.9841D-01,-0.1117D+00,-0.1245D+00,
     ,  -0.1364D+00,-0.1470D+00,-0.1562D+00,-0.1639D+00,-0.1704D+00,
     ,  -0.1757D+00,-0.1800D+00,-0.1835D+00/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.8348D-02,-0.4070D-02, 0.5388D-03, 0.5420D-02, 0.1065D-01,
     ,   0.1617D-01, 0.2203D-01, 0.2827D-01, 0.3490D-01, 0.4183D-01,
     ,   0.4908D-01, 0.5655D-01, 0.6424D-01, 0.7185D-01, 0.7971D-01,
     ,   0.8735D-01, 0.9484D-01, 0.1019D+00, 0.1085D+00, 0.1142D+00,
     ,   0.1191D+00, 0.1228D+00, 0.1252D+00, 0.1261D+00, 0.1252D+00,
     ,   0.1225D+00, 0.1180D+00, 0.1118D+00, 0.1039D+00, 0.9440D-01,
     ,   0.8360D-01, 0.7128D-01, 0.5743D-01, 0.4201D-01, 0.2572D-01,
     ,   0.1015D-01,-0.2468D-02,-0.1033D-01,-0.1307D-01,-0.1184D-01,
     ,  -0.8256D-02,-0.3653D-02, 0.8748D-03, 0.4878D-02, 0.7877D-02,
     ,   0.9616D-02, 0.1001D-01, 0.8947D-02, 0.6528D-02, 0.2822D-02,
     ,  -0.2055D-02,-0.7940D-02,-0.1472D-01,-0.2226D-01,-0.3033D-01,
     ,  -0.3826D-01,-0.4536D-01,-0.5141D-01,-0.5729D-01,-0.6444D-01,
     ,  -0.7387D-01,-0.8543D-01,-0.9837D-01,-0.1117D+00,-0.1245D+00,
     ,  -0.1364D+00,-0.1469D+00,-0.1561D+00,-0.1639D+00,-0.1704D+00,
     ,  -0.1757D+00,-0.1800D+00,-0.1834D+00/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.8349D-02,-0.4071D-02, 0.5385D-03, 0.5420D-02, 0.1065D-01,
     ,   0.1617D-01, 0.2204D-01, 0.2827D-01, 0.3491D-01, 0.4184D-01,
     ,   0.4908D-01, 0.5655D-01, 0.6415D-01, 0.7187D-01, 0.7962D-01,
     ,   0.8729D-01, 0.9478D-01, 0.1019D+00, 0.1084D+00, 0.1142D+00,
     ,   0.1190D+00, 0.1227D+00, 0.1251D+00, 0.1260D+00, 0.1251D+00,
     ,   0.1224D+00, 0.1179D+00, 0.1117D+00, 0.1038D+00, 0.9438D-01,
     ,   0.8352D-01, 0.7124D-01, 0.5735D-01, 0.4201D-01, 0.2570D-01,
     ,   0.1015D-01,-0.2444D-02,-0.1031D-01,-0.1305D-01,-0.1182D-01,
     ,  -0.8206D-02,-0.3661D-02, 0.9197D-03, 0.4867D-02, 0.7880D-02,
     ,   0.9661D-02, 0.1001D-01, 0.8959D-02, 0.6541D-02, 0.2817D-02,
     ,  -0.2031D-02,-0.7920D-02,-0.1472D-01,-0.2225D-01,-0.3030D-01,
     ,  -0.3825D-01,-0.4534D-01,-0.5138D-01,-0.5726D-01,-0.6444D-01,
     ,  -0.7384D-01,-0.8542D-01,-0.9834D-01,-0.1116D+00,-0.1244D+00,
     ,  -0.1363D+00,-0.1469D+00,-0.1561D+00,-0.1638D+00,-0.1704D+00,
     ,  -0.1755D+00,-0.1799D+00,-0.1833D+00/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.8351D-02,-0.4073D-02, 0.4154D-03, 0.5433D-02, 0.1065D-01,
     ,   0.1618D-01, 0.2204D-01, 0.2827D-01, 0.3491D-01, 0.4184D-01,
     ,   0.4899D-01, 0.5648D-01, 0.6408D-01, 0.7180D-01, 0.7956D-01,
     ,   0.8723D-01, 0.9464D-01, 0.1017D+00, 0.1083D+00, 0.1140D+00,
     ,   0.1189D+00, 0.1226D+00, 0.1250D+00, 0.1258D+00, 0.1250D+00,
     ,   0.1223D+00, 0.1178D+00, 0.1116D+00, 0.1037D+00, 0.9430D-01,
     ,   0.8344D-01, 0.7117D-01, 0.5737D-01, 0.4193D-01, 0.2576D-01,
     ,   0.1014D-01,-0.2444D-02,-0.1028D-01,-0.1302D-01,-0.1179D-01,
     ,  -0.8194D-02,-0.3647D-02, 0.9324D-03, 0.4915D-02, 0.7914D-02,
     ,   0.9655D-02, 0.1002D-01, 0.8973D-02, 0.6559D-02, 0.2835D-02,
     ,  -0.1999D-02,-0.7918D-02,-0.1467D-01,-0.2222D-01,-0.3025D-01,
     ,  -0.3822D-01,-0.4530D-01,-0.5133D-01,-0.5724D-01,-0.6439D-01,
     ,  -0.7381D-01,-0.8537D-01,-0.9827D-01,-0.1115D+00,-0.1244D+00,
     ,  -0.1362D+00,-0.1468D+00,-0.1560D+00,-0.1638D+00,-0.1703D+00,
     ,  -0.1755D+00,-0.1798D+00,-0.1833D+00/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.8243D-02,-0.4087D-02, 0.5329D-03, 0.5417D-02, 0.1053D-01,
     ,   0.1619D-01, 0.2204D-01, 0.2827D-01, 0.3481D-01, 0.4176D-01,
     ,   0.4891D-01, 0.5631D-01, 0.6393D-01, 0.7175D-01, 0.7942D-01,
     ,   0.8711D-01, 0.9445D-01, 0.1016D+00, 0.1081D+00, 0.1139D+00,
     ,   0.1187D+00, 0.1224D+00, 0.1248D+00, 0.1256D+00, 0.1247D+00,
     ,   0.1221D+00, 0.1177D+00, 0.1114D+00, 0.1036D+00, 0.9414D-01,
     ,   0.8329D-01, 0.7108D-01, 0.5725D-01, 0.4193D-01, 0.2573D-01,
     ,   0.1016D-01,-0.2408D-02,-0.1025D-01,-0.1299D-01,-0.1177D-01,
     ,  -0.8170D-02,-0.3630D-02, 0.9450D-03, 0.4931D-02, 0.7931D-02,
     ,   0.9677D-02, 0.1005D-01, 0.9005D-02, 0.6601D-02, 0.2883D-02,
     ,  -0.1977D-02,-0.7849D-02,-0.1461D-01,-0.2217D-01,-0.3019D-01,
     ,  -0.3813D-01,-0.4522D-01,-0.5129D-01,-0.5716D-01,-0.6432D-01,
     ,  -0.7372D-01,-0.8528D-01,-0.9817D-01,-0.1115D+00,-0.1243D+00,
     ,  -0.1362D+00,-0.1467D+00,-0.1559D+00,-0.1636D+00,-0.1701D+00,
     ,  -0.1754D+00,-0.1797D+00,-0.1832D+00/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.8247D-02,-0.4089D-02, 0.5319D-03, 0.5298D-02, 0.1055D-01,
     ,   0.1608D-01, 0.2195D-01, 0.2819D-01, 0.3473D-01, 0.4168D-01,
     ,   0.4884D-01, 0.5624D-01, 0.6386D-01, 0.7152D-01, 0.7922D-01,
     ,   0.8684D-01, 0.9429D-01, 0.1013D+00, 0.1079D+00, 0.1136D+00,
     ,   0.1185D+00, 0.1222D+00, 0.1245D+00, 0.1254D+00, 0.1245D+00,
     ,   0.1219D+00, 0.1174D+00, 0.1112D+00, 0.1034D+00, 0.9397D-01,
     ,   0.8312D-01, 0.7094D-01, 0.5716D-01, 0.4187D-01, 0.2568D-01,
     ,   0.1017D-01,-0.2377D-02,-0.1020D-01,-0.1294D-01,-0.1171D-01,
     ,  -0.8144D-02,-0.3569D-02, 0.9880D-03, 0.4971D-02, 0.7973D-02,
     ,   0.9680D-02, 0.1008D-01, 0.9047D-02, 0.6625D-02, 0.2947D-02,
     ,  -0.1917D-02,-0.7801D-02,-0.1455D-01,-0.2207D-01,-0.3012D-01,
     ,  -0.3804D-01,-0.4514D-01,-0.5121D-01,-0.5709D-01,-0.6424D-01,
     ,  -0.7364D-01,-0.8517D-01,-0.9805D-01,-0.1113D+00,-0.1242D+00,
     ,  -0.1360D+00,-0.1466D+00,-0.1557D+00,-0.1635D+00,-0.1700D+00,
     ,  -0.1753D+00,-0.1795D+00,-0.1830D+00/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.8252D-02,-0.4092D-02, 0.5303D-03, 0.5417D-02, 0.1054D-01,
     ,   0.1608D-01, 0.2195D-01, 0.2808D-01, 0.3464D-01, 0.4150D-01,
     ,   0.4858D-01, 0.5601D-01, 0.6356D-01, 0.7133D-01, 0.7903D-01,
     ,   0.8658D-01, 0.9406D-01, 0.1010D+00, 0.1075D+00, 0.1133D+00,
     ,   0.1181D+00, 0.1218D+00, 0.1241D+00, 0.1249D+00, 0.1242D+00,
     ,   0.1215D+00, 0.1171D+00, 0.1109D+00, 0.1030D+00, 0.9364D-01,
     ,   0.8292D-01, 0.7073D-01, 0.5703D-01, 0.4174D-01, 0.2568D-01,
     ,   0.1021D-01,-0.2329D-02,-0.1013D-01,-0.1287D-01,-0.1165D-01,
     ,  -0.8067D-02,-0.3520D-02, 0.1032D-02, 0.4977D-02, 0.7995D-02,
     ,   0.9747D-02, 0.1014D-01, 0.9090D-02, 0.6691D-02, 0.3000D-02,
     ,  -0.1835D-02,-0.7690D-02,-0.1446D-01,-0.2196D-01,-0.2999D-01,
     ,  -0.3791D-01,-0.4502D-01,-0.5109D-01,-0.5698D-01,-0.6415D-01,
     ,  -0.7351D-01,-0.8501D-01,-0.9791D-01,-0.1111D+00,-0.1239D+00,
     ,  -0.1358D+00,-0.1463D+00,-0.1555D+00,-0.1633D+00,-0.1697D+00,
     ,  -0.1750D+00,-0.1793D+00,-0.1827D+00/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.8150D-02,-0.3991D-02, 0.5104D-03, 0.5293D-02, 0.1043D-01,
     ,   0.1598D-01, 0.2175D-01, 0.2791D-01, 0.3447D-01, 0.4134D-01,
     ,   0.4834D-01, 0.5579D-01, 0.6326D-01, 0.7097D-01, 0.7863D-01,
     ,   0.8613D-01, 0.9357D-01, 0.1005D+00, 0.1070D+00, 0.1127D+00,
     ,   0.1175D+00, 0.1213D+00, 0.1236D+00, 0.1244D+00, 0.1236D+00,
     ,   0.1210D+00, 0.1165D+00, 0.1104D+00, 0.1026D+00, 0.9325D-01,
     ,   0.8253D-01, 0.7045D-01, 0.5675D-01, 0.4163D-01, 0.2560D-01,
     ,   0.1025D-01,-0.2236D-02,-0.1003D-01,-0.1277D-01,-0.1156D-01,
     ,  -0.8010D-02,-0.3440D-02, 0.1093D-02, 0.5075D-02, 0.8041D-02,
     ,   0.9817D-02, 0.1019D-01, 0.9174D-02, 0.6787D-02, 0.3094D-02,
     ,  -0.1716D-02,-0.7573D-02,-0.1428D-01,-0.2180D-01,-0.2978D-01,
     ,  -0.3772D-01,-0.4483D-01,-0.5089D-01,-0.5679D-01,-0.6395D-01,
     ,  -0.7329D-01,-0.8477D-01,-0.9762D-01,-0.1108D+00,-0.1236D+00,
     ,  -0.1354D+00,-0.1460D+00,-0.1551D+00,-0.1629D+00,-0.1694D+00,
     ,  -0.1746D+00,-0.1789D+00,-0.1824D+00/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.8162D-02,-0.3878D-02, 0.4936D-03, 0.5291D-02, 0.1032D-01,
     ,   0.1589D-01, 0.2166D-01, 0.2772D-01, 0.3421D-01, 0.4100D-01,
     ,   0.4803D-01, 0.5541D-01, 0.6291D-01, 0.7038D-01, 0.7810D-01,
     ,   0.8556D-01, 0.9289D-01, 0.9984D-01, 0.1062D+00, 0.1120D+00,
     ,   0.1168D+00, 0.1204D+00, 0.1227D+00, 0.1236D+00, 0.1227D+00,
     ,   0.1202D+00, 0.1158D+00, 0.1097D+00, 0.1019D+00, 0.9273D-01,
     ,   0.8205D-01, 0.7001D-01, 0.5644D-01, 0.4143D-01, 0.2556D-01,
     ,   0.1028D-01,-0.2143D-02,-0.9888D-02,-0.1263D-01,-0.1143D-01,
     ,  -0.7899D-02,-0.3362D-02, 0.1201D-02, 0.5129D-02, 0.8154D-02,
     ,   0.9886D-02, 0.1029D-01, 0.9280D-02, 0.6912D-02, 0.3244D-02,
     ,  -0.1535D-02,-0.7369D-02,-0.1407D-01,-0.2155D-01,-0.2951D-01,
     ,  -0.3745D-01,-0.4456D-01,-0.5065D-01,-0.5655D-01,-0.6367D-01,
     ,  -0.7298D-01,-0.8442D-01,-0.9721D-01,-0.1104D+00,-0.1232D+00,
     ,  -0.1350D+00,-0.1455D+00,-0.1546D+00,-0.1624D+00,-0.1688D+00,
     ,  -0.1741D+00,-0.1784D+00,-0.1818D+00/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.8068D-02,-0.3903D-02, 0.3617D-03, 0.5180D-02, 0.1033D-01,
     ,   0.1567D-01, 0.2137D-01, 0.2746D-01, 0.3386D-01, 0.4059D-01,
     ,   0.4755D-01, 0.5478D-01, 0.6216D-01, 0.6970D-01, 0.7721D-01,
     ,   0.8475D-01, 0.9198D-01, 0.9888D-01, 0.1052D+00, 0.1109D+00,
     ,   0.1156D+00, 0.1193D+00, 0.1216D+00, 0.1224D+00, 0.1216D+00,
     ,   0.1190D+00, 0.1147D+00, 0.1086D+00, 0.1010D+00, 0.9183D-01,
     ,   0.8130D-01, 0.6941D-01, 0.5597D-01, 0.4113D-01, 0.2546D-01,
     ,   0.1032D-01,-0.1968D-02,-0.9689D-02,-0.1243D-01,-0.1125D-01,
     ,  -0.7726D-02,-0.3213D-02, 0.1281D-02, 0.5255D-02, 0.8236D-02,
     ,   0.9997D-02, 0.1041D-01, 0.9428D-02, 0.7047D-02, 0.3447D-02,
     ,  -0.1327D-02,-0.7110D-02,-0.1380D-01,-0.2120D-01,-0.2916D-01,
     ,  -0.3706D-01,-0.4418D-01,-0.5031D-01,-0.5621D-01,-0.6333D-01,
     ,  -0.7259D-01,-0.8394D-01,-0.9671D-01,-0.1098D+00,-0.1225D+00,
     ,  -0.1343D+00,-0.1448D+00,-0.1539D+00,-0.1616D+00,-0.1680D+00,
     ,  -0.1734D+00,-0.1777D+00,-0.1811D+00/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.7982D-02,-0.3809D-02, 0.4601D-03, 0.5162D-02, 0.1010D-01,
     ,   0.1548D-01, 0.2108D-01, 0.2699D-01, 0.3334D-01, 0.3990D-01,
     ,   0.4684D-01, 0.5393D-01, 0.6130D-01, 0.6863D-01, 0.7615D-01,
     ,   0.8345D-01, 0.9065D-01, 0.9742D-01, 0.1037D+00, 0.1093D+00,
     ,   0.1140D+00, 0.1175D+00, 0.1199D+00, 0.1207D+00, 0.1199D+00,
     ,   0.1174D+00, 0.1132D+00, 0.1072D+00, 0.9964D-01, 0.9060D-01,
     ,   0.8019D-01, 0.6850D-01, 0.5533D-01, 0.4068D-01, 0.2526D-01,
     ,   0.1040D-01,-0.1726D-02,-0.9408D-02,-0.1215D-01,-0.1098D-01,
     ,  -0.7481D-02,-0.3049D-02, 0.1465D-02, 0.5385D-02, 0.8391D-02,
     ,   0.1018D-01, 0.1058D-01, 0.9632D-02, 0.7304D-02, 0.3735D-02,
     ,  -0.9917D-03,-0.6729D-02,-0.1333D-01,-0.2073D-01,-0.2858D-01,
     ,  -0.3646D-01,-0.4363D-01,-0.4976D-01,-0.5570D-01,-0.6276D-01,
     ,  -0.7196D-01,-0.8326D-01,-0.9588D-01,-0.1089D+00,-0.1216D+00,
     ,  -0.1333D+00,-0.1438D+00,-0.1528D+00,-0.1606D+00,-0.1670D+00,
     ,  -0.1723D+00,-0.1766D+00,-0.1800D+00/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.7794D-02,-0.3736D-02, 0.4283D-03, 0.5034D-02, 0.9884D-02,
     ,   0.1506D-01, 0.2061D-01, 0.2656D-01, 0.3273D-01, 0.3906D-01,
     ,   0.4588D-01, 0.5277D-01, 0.5996D-01, 0.6723D-01, 0.7453D-01,
     ,   0.8181D-01, 0.8865D-01, 0.9544D-01, 0.1016D+00, 0.1071D+00,
     ,   0.1116D+00, 0.1152D+00, 0.1175D+00, 0.1183D+00, 0.1176D+00,
     ,   0.1151D+00, 0.1110D+00, 0.1051D+00, 0.9772D-01, 0.8885D-01,
     ,   0.7869D-01, 0.6722D-01, 0.5432D-01, 0.4012D-01, 0.2506D-01,
     ,   0.1048D-01,-0.1454D-02,-0.9009D-02,-0.1174D-01,-0.1063D-01,
     ,  -0.7191D-02,-0.2746D-02, 0.1696D-02, 0.5612D-02, 0.8597D-02,
     ,   0.1038D-01, 0.1084D-01, 0.9916D-02, 0.7640D-02, 0.4122D-02,
     ,  -0.5322D-03,-0.6180D-02,-0.1274D-01,-0.2000D-01,-0.2782D-01,
     ,  -0.3568D-01,-0.4281D-01,-0.4901D-01,-0.5495D-01,-0.6199D-01,
     ,  -0.7107D-01,-0.8222D-01,-0.9474D-01,-0.1076D+00,-0.1202D+00,
     ,  -0.1319D+00,-0.1422D+00,-0.1513D+00,-0.1590D+00,-0.1654D+00,
     ,  -0.1707D+00,-0.1749D+00,-0.1783D+00/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.7509D-02,-0.3684D-02, 0.3884D-03, 0.4902D-02, 0.9550D-02,
     ,   0.1467D-01, 0.1993D-01, 0.2563D-01, 0.3158D-01, 0.3791D-01,
     ,   0.4452D-01, 0.5124D-01, 0.5810D-01, 0.6518D-01, 0.7230D-01,
     ,   0.7927D-01, 0.8612D-01, 0.9257D-01, 0.9860D-01, 0.1039D+00,
     ,   0.1084D+00, 0.1119D+00, 0.1141D+00, 0.1149D+00, 0.1143D+00,
     ,   0.1119D+00, 0.1079D+00, 0.1022D+00, 0.9503D-01, 0.8642D-01,
     ,   0.7656D-01, 0.6543D-01, 0.5292D-01, 0.3926D-01, 0.2470D-01,
     ,   0.1059D-01,-0.1039D-02,-0.8490D-02,-0.1121D-01,-0.1015D-01,
     ,  -0.6759D-02,-0.2392D-02, 0.1986D-02, 0.5898D-02, 0.8869D-02,
     ,   0.1068D-01, 0.1114D-01, 0.1031D-01, 0.8122D-02, 0.4686D-02,
     ,   0.1149D-03,-0.5444D-02,-0.1186D-01,-0.1901D-01,-0.2671D-01,
     ,  -0.3451D-01,-0.4167D-01,-0.4792D-01,-0.5387D-01,-0.6084D-01,
     ,  -0.6978D-01,-0.8076D-01,-0.9309D-01,-0.1058D+00,-0.1183D+00,
     ,  -0.1298D+00,-0.1401D+00,-0.1491D+00,-0.1567D+00,-0.1631D+00,
     ,  -0.1684D+00,-0.1726D+00,-0.1760D+00/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.7239D-02,-0.3521D-02, 0.3304D-03, 0.4647D-02, 0.9231D-02,
     ,   0.1394D-01, 0.1907D-01, 0.2464D-01, 0.3026D-01, 0.3630D-01,
     ,   0.4256D-01, 0.4908D-01, 0.5574D-01, 0.6248D-01, 0.6923D-01,
     ,   0.7598D-01, 0.8254D-01, 0.8877D-01, 0.9456D-01, 0.9971D-01,
     ,   0.1040D+00, 0.1074D+00, 0.1096D+00, 0.1104D+00, 0.1098D+00,
     ,   0.1076D+00, 0.1037D+00, 0.9827D-01, 0.9137D-01, 0.8310D-01,
     ,   0.7361D-01, 0.6295D-01, 0.5108D-01, 0.3800D-01, 0.2413D-01,
     ,   0.1067D-01,-0.5609D-03,-0.7802D-02,-0.1052D-01,-0.9516D-02,
     ,  -0.6203D-02,-0.1936D-02, 0.2393D-02, 0.6218D-02, 0.9214D-02,
     ,   0.1104D-01, 0.1157D-01, 0.1082D-01, 0.8710D-02, 0.5409D-02,
     ,   0.1008D-02,-0.4397D-02,-0.1068D-01,-0.1767D-01,-0.2521D-01,
     ,  -0.3289D-01,-0.4005D-01,-0.4636D-01,-0.5234D-01,-0.5924D-01,
     ,  -0.6796D-01,-0.7869D-01,-0.9075D-01,-0.1033D+00,-0.1155D+00,
     ,  -0.1269D+00,-0.1371D+00,-0.1460D+00,-0.1536D+00,-0.1599D+00,
     ,  -0.1651D+00,-0.1693D+00,-0.1728D+00/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.6877D-02,-0.3380D-02, 0.3863D-03, 0.4376D-02, 0.8559D-02,
     ,   0.1325D-01, 0.1800D-01, 0.2304D-01, 0.2851D-01, 0.3419D-01,
     ,   0.4003D-01, 0.4619D-01, 0.5245D-01, 0.5884D-01, 0.6529D-01,
     ,   0.7160D-01, 0.7778D-01, 0.8370D-01, 0.8917D-01, 0.9403D-01,
     ,   0.9824D-01, 0.1014D+00, 0.1035D+00, 0.1044D+00, 0.1038D+00,
     ,   0.1017D+00, 0.9813D-01, 0.9302D-01, 0.8652D-01, 0.7868D-01,
     ,   0.6967D-01, 0.5963D-01, 0.4848D-01, 0.3625D-01, 0.2332D-01,
     ,   0.1065D-01, 0.1875D-04,-0.6977D-02,-0.9653D-02,-0.8732D-02,
     ,  -0.5547D-02,-0.1396D-02, 0.2864D-02, 0.6635D-02, 0.9594D-02,
     ,   0.1148D-01, 0.1211D-01, 0.1145D-01, 0.9499D-02, 0.6365D-02,
     ,   0.2129D-02,-0.3054D-02,-0.9105D-02,-0.1586D-01,-0.2318D-01,
     ,  -0.3071D-01,-0.3783D-01,-0.4419D-01,-0.5021D-01,-0.5696D-01,
     ,  -0.6544D-01,-0.7579D-01,-0.8749D-01,-0.9971D-01,-0.1116D+00,
     ,  -0.1228D+00,-0.1329D+00,-0.1417D+00,-0.1492D+00,-0.1554D+00,
     ,  -0.1606D+00,-0.1648D+00,-0.1682D+00/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.6309D-02,-0.3035D-02, 0.4016D-03, 0.4094D-02, 0.7881D-02,
     ,   0.1210D-01, 0.1655D-01, 0.2129D-01, 0.2628D-01, 0.3145D-01,
     ,   0.3694D-01, 0.4258D-01, 0.4830D-01, 0.5422D-01, 0.6018D-01,
     ,   0.6609D-01, 0.7181D-01, 0.7727D-01, 0.8240D-01, 0.8689D-01,
     ,   0.9078D-01, 0.9381D-01, 0.9583D-01, 0.9663D-01, 0.9619D-01,
     ,   0.9431D-01, 0.9102D-01, 0.8629D-01, 0.8022D-01, 0.7296D-01,
     ,   0.6467D-01, 0.5536D-01, 0.4509D-01, 0.3389D-01, 0.2207D-01,
     ,   0.1048D-01, 0.5834D-03,-0.6041D-02,-0.8655D-02,-0.7827D-02,
     ,  -0.4792D-02,-0.7643D-03, 0.3381D-02, 0.7084D-02, 0.9997D-02,
     ,   0.1192D-01, 0.1267D-01, 0.1215D-01, 0.1041D-01, 0.7511D-02,
     ,   0.3531D-02,-0.1372D-02,-0.7124D-02,-0.1355D-01,-0.2059D-01,
     ,  -0.2786D-01,-0.3491D-01,-0.4130D-01,-0.4732D-01,-0.5390D-01,
     ,  -0.6201D-01,-0.7188D-01,-0.8310D-01,-0.9489D-01,-0.1065D+00,
     ,  -0.1173D+00,-0.1272D+00,-0.1358D+00,-0.1432D+00,-0.1494D+00,
     ,  -0.1545D+00,-0.1587D+00,-0.1620D+00/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.5529D-02,-0.2727D-02, 0.2778D-03, 0.3570D-02, 0.7107D-02,
     ,   0.1074D-01, 0.1478D-01, 0.1904D-01, 0.2349D-01, 0.2818D-01,
     ,   0.3314D-01, 0.3821D-01, 0.4335D-01, 0.4868D-01, 0.5407D-01,
     ,   0.5931D-01, 0.6458D-01, 0.6948D-01, 0.7410D-01, 0.7829D-01,
     ,   0.8178D-01, 0.8458D-01, 0.8641D-01, 0.8720D-01, 0.8686D-01,
     ,   0.8522D-01, 0.8229D-01, 0.7803D-01, 0.7260D-01, 0.6598D-01,
     ,   0.5841D-01, 0.5000D-01, 0.4082D-01, 0.3082D-01, 0.2033D-01,
     ,   0.9992D-02, 0.1030D-02,-0.5093D-02,-0.7609D-02,-0.6872D-02,
     ,  -0.4002D-02,-0.1328D-03, 0.3837D-02, 0.7429D-02, 0.1033D-01,
     ,   0.1232D-01, 0.1317D-01, 0.1290D-01, 0.1138D-01, 0.8799D-02,
     ,   0.5158D-02, 0.6129D-03,-0.4752D-02,-0.1077D-01,-0.1738D-01,
     ,  -0.2430D-01,-0.3117D-01,-0.3754D-01,-0.4351D-01,-0.4988D-01,
     ,  -0.5749D-01,-0.6679D-01,-0.7738D-01,-0.8858D-01,-0.9966D-01,
     ,  -0.1102D+00,-0.1197D+00,-0.1281D+00,-0.1353D+00,-0.1414D+00,
     ,  -0.1465D+00,-0.1505D+00,-0.1539D+00/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.4872D-02,-0.2409D-02, 0.2801D-03, 0.3157D-02, 0.6198D-02,
     ,   0.9378D-02, 0.1290D-01, 0.1646D-01, 0.2041D-01, 0.2452D-01,
     ,   0.2867D-01, 0.3314D-01, 0.3774D-01, 0.4240D-01, 0.4705D-01,
     ,   0.5171D-01, 0.5629D-01, 0.6063D-01, 0.6473D-01, 0.6839D-01,
     ,   0.7149D-01, 0.7393D-01, 0.7565D-01, 0.7639D-01, 0.7618D-01,
     ,   0.7476D-01, 0.7224D-01, 0.6852D-01, 0.6372D-01, 0.5787D-01,
     ,   0.5117D-01, 0.4378D-01, 0.3566D-01, 0.2705D-01, 0.1797D-01,
     ,   0.9028D-02, 0.1196D-02,-0.4318D-02,-0.6648D-02,-0.6015D-02,
     ,  -0.3329D-02, 0.3225D-03, 0.4150D-02, 0.7610D-02, 0.1048D-01,
     ,   0.1251D-01, 0.1354D-01, 0.1350D-01, 0.1233D-01, 0.1010D-01,
     ,   0.6877D-02, 0.2790D-02,-0.2073D-02,-0.7591D-02,-0.1368D-01,
     ,  -0.2012D-01,-0.2666D-01,-0.3286D-01,-0.3873D-01,-0.4480D-01,
     ,  -0.5187D-01,-0.6041D-01,-0.7019D-01,-0.8067D-01,-0.9114D-01,
     ,  -0.1011D+00,-0.1103D+00,-0.1184D+00,-0.1254D+00,-0.1313D+00,
     ,  -0.1362D+00,-0.1403D+00,-0.1435D+00/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.4097D-02,-0.2106D-02, 0.1492D-03, 0.2625D-02, 0.5171D-02,
     ,   0.7784D-02, 0.1079D-01, 0.1389D-01, 0.1708D-01, 0.2061D-01,
     ,   0.2416D-01, 0.2788D-01, 0.3172D-01, 0.3567D-01, 0.3966D-01,
     ,   0.4356D-01, 0.4742D-01, 0.5117D-01, 0.5461D-01, 0.5775D-01,
     ,   0.6044D-01, 0.6261D-01, 0.6409D-01, 0.6479D-01, 0.6462D-01,
     ,   0.6344D-01, 0.6132D-01, 0.5817D-01, 0.5405D-01, 0.4906D-01,
     ,   0.4327D-01, 0.3687D-01, 0.2994D-01, 0.2261D-01, 0.1502D-01,
     ,   0.7535D-02, 0.9021D-03,-0.3859D-02,-0.5959D-02,-0.5399D-02,
     ,  -0.2892D-02, 0.5304D-03, 0.4140D-02, 0.7477D-02, 0.1030D-01,
     ,   0.1236D-01, 0.1357D-01, 0.1379D-01, 0.1301D-01, 0.1122D-01,
     ,   0.8517D-02, 0.4962D-02, 0.6636D-03,-0.4232D-02,-0.9689D-02,
     ,  -0.1552D-01,-0.2157D-01,-0.2748D-01,-0.3313D-01,-0.3881D-01,
     ,  -0.4525D-01,-0.5287D-01,-0.6171D-01,-0.7126D-01,-0.8096D-01,
     ,  -0.9031D-01,-0.9894D-01,-0.1067D+00,-0.1134D+00,-0.1191D+00,
     ,  -0.1239D+00,-0.1279D+00,-0.1310D+00/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.3341D-02,-0.1663D-02, 0.1231D-03, 0.2060D-02, 0.4139D-02,
     ,   0.6352D-02, 0.8711D-02, 0.1122D-01, 0.1388D-01, 0.1669D-01,
     ,   0.1961D-01, 0.2266D-01, 0.2580D-01, 0.2902D-01, 0.3226D-01,
     ,   0.3549D-01, 0.3866D-01, 0.4171D-01, 0.4456D-01, 0.4716D-01,
     ,   0.4940D-01, 0.5119D-01, 0.5242D-01, 0.5303D-01, 0.5292D-01,
     ,   0.5201D-01, 0.5025D-01, 0.4765D-01, 0.4422D-01, 0.4001D-01,
     ,   0.3515D-01, 0.2975D-01, 0.2395D-01, 0.1786D-01, 0.1163D-01,
     ,   0.5526D-02, 0.1006D-03,-0.3861D-02,-0.5667D-02,-0.5152D-02,
     ,  -0.2867D-02, 0.3482D-03, 0.3726D-02, 0.6921D-02, 0.9652D-02,
     ,   0.1177D-01, 0.1313D-01, 0.1365D-01, 0.1325D-01, 0.1198D-01,
     ,   0.9812D-02, 0.6876D-02, 0.3265D-02,-0.9632D-03,-0.5713D-02,
     ,  -0.1083D-01,-0.1625D-01,-0.2167D-01,-0.2693D-01,-0.3217D-01,
     ,  -0.3789D-01,-0.4453D-01,-0.5227D-01,-0.6075D-01,-0.6949D-01,
     ,  -0.7809D-01,-0.8612D-01,-0.9336D-01,-0.9978D-01,-0.1052D+00,
     ,  -0.1099D+00,-0.1137D+00,-0.1167D+00/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.2642D-02,-0.1334D-02, 0.6750D-04, 0.1586D-02, 0.3218D-02,
     ,   0.4961D-02, 0.6819D-02, 0.8794D-02, 0.1089D-01, 0.1309D-01,
     ,   0.1540D-01, 0.1781D-01, 0.2030D-01, 0.2282D-01, 0.2539D-01,
     ,   0.2795D-01, 0.3047D-01, 0.3290D-01, 0.3517D-01, 0.3725D-01,
     ,   0.3903D-01, 0.4047D-01, 0.4148D-01, 0.4198D-01, 0.4190D-01,
     ,   0.4117D-01, 0.3976D-01, 0.3765D-01, 0.3485D-01, 0.3140D-01,
     ,   0.2739D-01, 0.2293D-01, 0.1813D-01, 0.1314D-01, 0.8081D-02,
     ,   0.3192D-02,-0.1138D-02,-0.4329D-02,-0.5799D-02,-0.5331D-02,
     ,  -0.3238D-02,-0.2588D-03, 0.2935D-02, 0.5933D-02, 0.8545D-02,
     ,   0.1066D-01, 0.1216D-01, 0.1295D-01, 0.1296D-01, 0.1217D-01,
     ,   0.1058D-01, 0.8288D-02, 0.5369D-02, 0.1880D-02,-0.2111D-02,
     ,  -0.6475D-02,-0.1113D-01,-0.1592D-01,-0.2067D-01,-0.2539D-01,
     ,  -0.3033D-01,-0.3596D-01,-0.4251D-01,-0.4984D-01,-0.5750D-01,
     ,  -0.6519D-01,-0.7248D-01,-0.7916D-01,-0.8516D-01,-0.9032D-01,
     ,  -0.9474D-01,-0.9834D-01,-0.1013D+00/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.2029D-02,-0.1039D-02, 0.2909D-04, 0.1201D-02, 0.2436D-02,
     ,   0.3753D-02, 0.5174D-02, 0.6681D-02, 0.8296D-02, 0.9983D-02,
     ,   0.1174D-01, 0.1358D-01, 0.1548D-01, 0.1744D-01, 0.1941D-01,
     ,   0.2138D-01, 0.2332D-01, 0.2518D-01, 0.2695D-01, 0.2854D-01,
     ,   0.2993D-01, 0.3104D-01, 0.3182D-01, 0.3219D-01, 0.3212D-01,
     ,   0.3155D-01, 0.3042D-01, 0.2873D-01, 0.2647D-01, 0.2369D-01,
     ,   0.2043D-01, 0.1679D-01, 0.1287D-01, 0.8807D-02, 0.4719D-02,
     ,   0.8203D-03,-0.2611D-02,-0.5129D-02,-0.6283D-02,-0.5839D-02,
     ,  -0.3969D-02,-0.1219D-02, 0.1769D-02, 0.4591D-02, 0.7064D-02,
     ,   0.9131D-02, 0.1071D-01, 0.1171D-01, 0.1207D-01, 0.1174D-01,
     ,   0.1073D-01, 0.9083D-02, 0.6829D-02, 0.4046D-02, 0.8452D-03,
     ,  -0.2730D-02,-0.6616D-02,-0.1067D-01,-0.1482D-01,-0.1892D-01,
     ,  -0.2313D-01,-0.2779D-01,-0.3314D-01,-0.3923D-01,-0.4576D-01,
     ,  -0.5241D-01,-0.5888D-01,-0.6493D-01,-0.7039D-01,-0.7521D-01,
     ,  -0.7932D-01,-0.8279D-01,-0.8563D-01/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.1529D-02,-0.7860D-03,-0.2521D-05, 0.8674D-03, 0.1785D-02,
     ,   0.2772D-02, 0.3828D-02, 0.4954D-02, 0.6152D-02, 0.7395D-02,
     ,   0.8730D-02, 0.1010D-01, 0.1152D-01, 0.1298D-01, 0.1446D-01,
     ,   0.1593D-01, 0.1738D-01, 0.1878D-01, 0.2010D-01, 0.2130D-01,
     ,   0.2234D-01, 0.2316D-01, 0.2373D-01, 0.2400D-01, 0.2392D-01,
     ,   0.2345D-01, 0.2254D-01, 0.2119D-01, 0.1940D-01, 0.1716D-01,
     ,   0.1455D-01, 0.1160D-01, 0.8423D-02, 0.5116D-02, 0.1804D-02,
     ,  -0.1323D-02,-0.4055D-02,-0.6048D-02,-0.6952D-02,-0.6546D-02,
     ,  -0.4889D-02,-0.2400D-02, 0.3781D-03, 0.3029D-02, 0.5362D-02,
     ,   0.7331D-02, 0.8917D-02, 0.1006D-01, 0.1069D-01, 0.1076D-01,
     ,   0.1025D-01, 0.9174D-02, 0.7570D-02, 0.5494D-02, 0.3006D-02,
     ,   0.1770D-03,-0.2947D-02,-0.6272D-02,-0.9717D-02,-0.1320D-01,
     ,  -0.1673D-01,-0.2049D-01,-0.2475D-01,-0.2960D-01,-0.3498D-01,
     ,  -0.4056D-01,-0.4612D-01,-0.5144D-01,-0.5632D-01,-0.6072D-01,
     ,  -0.6453D-01,-0.6778D-01,-0.7045D-01/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.1122D-02,-0.5820D-03,-0.1500D-04, 0.6142D-03, 0.1283D-02,
     ,   0.2001D-02, 0.2773D-02, 0.3590D-02, 0.4459D-02, 0.5391D-02,
     ,   0.6340D-02, 0.7362D-02, 0.8403D-02, 0.9470D-02, 0.1054D-01,
     ,   0.1162D-01, 0.1269D-01, 0.1372D-01, 0.1467D-01, 0.1555D-01,
     ,   0.1630D-01, 0.1689D-01, 0.1729D-01, 0.1746D-01, 0.1737D-01,
     ,   0.1697D-01, 0.1623D-01, 0.1516D-01, 0.1372D-01, 0.1194D-01,
     ,   0.9841D-02, 0.7469D-02, 0.4888D-02, 0.2203D-02,-0.4943D-03,
     ,  -0.3053D-02,-0.5257D-02,-0.6873D-02,-0.7594D-02,-0.7259D-02,
     ,  -0.5842D-02,-0.3626D-02,-0.1066D-02, 0.1422D-02, 0.3611D-02,
     ,   0.5465D-02, 0.6993D-02, 0.8189D-02, 0.9001D-02, 0.9373D-02,
     ,   0.9267D-02, 0.8684D-02, 0.7638D-02, 0.6176D-02, 0.4343D-02,
     ,   0.2188D-02,-0.2338D-03,-0.2864D-02,-0.5643D-02,-0.8501D-02,
     ,  -0.1140D-01,-0.1441D-01,-0.1772D-01,-0.2148D-01,-0.2570D-01,
     ,  -0.3024D-01,-0.3487D-01,-0.3940D-01,-0.4367D-01,-0.4758D-01,
     ,  -0.5104D-01,-0.5402D-01,-0.5653D-01/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.8164D-03,-0.4451D-03,-0.3580D-04, 0.4186D-03, 0.8991D-03,
     ,   0.1430D-02, 0.1964D-02, 0.2566D-02, 0.3198D-02, 0.3856D-02,
     ,   0.4548D-02, 0.5277D-02, 0.6024D-02, 0.6795D-02, 0.7561D-02,
     ,   0.8339D-02, 0.9100D-02, 0.9839D-02, 0.1053D-01, 0.1114D-01,
     ,   0.1167D-01, 0.1208D-01, 0.1234D-01, 0.1244D-01, 0.1232D-01,
     ,   0.1198D-01, 0.1139D-01, 0.1052D-01, 0.9368D-02, 0.7943D-02,
     ,   0.6262D-02, 0.4349D-02, 0.2257D-02, 0.5943D-04,-0.2156D-02,
     ,  -0.4263D-02,-0.6098D-02,-0.7442D-02,-0.8081D-02,-0.7824D-02,
     ,  -0.6654D-02,-0.4742D-02,-0.2433D-02,-0.1087D-03, 0.1957D-02,
     ,   0.3694D-02, 0.5127D-02, 0.6299D-02, 0.7190D-02, 0.7757D-02,
     ,   0.7948D-02, 0.7760D-02, 0.7173D-02, 0.6229D-02, 0.4946D-02,
     ,   0.3382D-02, 0.1568D-02,-0.4420D-03,-0.2608D-02,-0.4881D-02,
     ,  -0.7209D-02,-0.9604D-02,-0.1215D-01,-0.1498D-01,-0.1819D-01,
     ,  -0.2170D-01,-0.2547D-01,-0.2919D-01,-0.3281D-01,-0.3620D-01,
     ,  -0.3927D-01,-0.4196D-01,-0.4427D-01/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.5934D-03,-0.3268D-03,-0.3009D-04, 0.2776D-03, 0.6234D-03,
     ,   0.1002D-02, 0.1395D-02, 0.1815D-02, 0.2245D-02, 0.2719D-02,
     ,   0.3217D-02, 0.3724D-02, 0.4261D-02, 0.4801D-02, 0.5349D-02,
     ,   0.5906D-02, 0.6443D-02, 0.6950D-02, 0.7434D-02, 0.7865D-02,
     ,   0.8222D-02, 0.8498D-02, 0.8656D-02, 0.8692D-02, 0.8563D-02,
     ,   0.8264D-02, 0.7775D-02, 0.7073D-02, 0.6148D-02, 0.5009D-02,
     ,   0.3653D-02, 0.2105D-02, 0.4132D-03,-0.1381D-02,-0.3227D-02,
     ,  -0.4982D-02,-0.6538D-02,-0.7707D-02,-0.8296D-02,-0.8162D-02,
     ,  -0.7239D-02,-0.5640D-02,-0.3599D-02,-0.1467D-02, 0.4848D-03,
     ,   0.2119D-02, 0.3461D-02, 0.4554D-02, 0.5442D-02, 0.6101D-02,
     ,   0.6489D-02, 0.6576D-02, 0.6348D-02, 0.5810D-02, 0.4988D-02,
     ,   0.3903D-02, 0.2605D-02, 0.1118D-02,-0.5189D-03,-0.2267D-02,
     ,  -0.4089D-02,-0.5967D-02,-0.7922D-02,-0.1004D-01,-0.1241D-01,
     ,  -0.1506D-01,-0.1797D-01,-0.2094D-01,-0.2390D-01,-0.2675D-01,
     ,  -0.2939D-01,-0.3178D-01,-0.3386D-01/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.4208D-03,-0.2350D-03,-0.2853D-04, 0.1951D-03, 0.4354D-03,
     ,   0.6811D-03, 0.9598D-03, 0.1255D-02, 0.1570D-02, 0.1903D-02,
     ,   0.2250D-02, 0.2614D-02, 0.2976D-02, 0.3362D-02, 0.3751D-02,
     ,   0.4126D-02, 0.4506D-02, 0.4857D-02, 0.5192D-02, 0.5477D-02,
     ,   0.5714D-02, 0.5891D-02, 0.5974D-02, 0.5967D-02, 0.5839D-02,
     ,   0.5583D-02, 0.5173D-02, 0.4595D-02, 0.3857D-02, 0.2937D-02,
     ,   0.1847D-02, 0.5961D-03,-0.7820D-03,-0.2266D-02,-0.3788D-02,
     ,  -0.5275D-02,-0.6612D-02,-0.7645D-02,-0.8231D-02,-0.8215D-02,
     ,  -0.7542D-02,-0.6256D-02,-0.4523D-02,-0.2598D-02,-0.7696D-03,
     ,   0.7956D-03, 0.2049D-02, 0.3062D-02, 0.3891D-02, 0.4559D-02,
     ,   0.5042D-02, 0.5309D-02, 0.5327D-02, 0.5095D-02, 0.4628D-02,
     ,   0.3934D-02, 0.3044D-02, 0.1989D-02, 0.7926D-03,-0.5143D-03,
     ,  -0.1905D-02,-0.3350D-02,-0.4847D-02,-0.6430D-02,-0.8164D-02,
     ,  -0.1009D-01,-0.1228D-01,-0.1456D-01,-0.1691D-01,-0.1922D-01,
     ,  -0.2142D-01,-0.2347D-01,-0.2531D-01/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.3097D-03,-0.1769D-03,-0.3211D-04, 0.1239D-03, 0.2899D-03,
     ,   0.4721D-03, 0.6637D-03, 0.8692D-03, 0.1087D-02, 0.1317D-02,
     ,   0.1557D-02, 0.1809D-02, 0.2068D-02, 0.2332D-02, 0.2598D-02,
     ,   0.2861D-02, 0.3117D-02, 0.3360D-02, 0.3581D-02, 0.3772D-02,
     ,   0.3926D-02, 0.4026D-02, 0.4066D-02, 0.4031D-02, 0.3906D-02,
     ,   0.3680D-02, 0.3340D-02, 0.2872D-02, 0.2272D-02, 0.1532D-02,
     ,   0.6539D-03,-0.3566D-03,-0.1484D-02,-0.2702D-02,-0.3967D-02,
     ,  -0.5227D-02,-0.6378D-02,-0.7310D-02,-0.7887D-02,-0.7996D-02,
     ,  -0.7551D-02,-0.6571D-02,-0.5149D-02,-0.3479D-02,-0.1798D-02,
     ,  -0.3006D-03, 0.9057D-03, 0.1853D-02, 0.2605D-02, 0.3230D-02,
     ,   0.3727D-02, 0.4080D-02, 0.4257D-02, 0.4244D-02, 0.4033D-02,
     ,   0.3634D-02, 0.3067D-02, 0.2350D-02, 0.1505D-02, 0.5585D-03,
     ,  -0.4686D-03,-0.1562D-02,-0.2698D-02,-0.3881D-02,-0.5148D-02,
     ,  -0.6535D-02,-0.8118D-02,-0.9823D-02,-0.1162D-01,-0.1343D-01,
     ,  -0.1522D-01,-0.1692D-01,-0.1848D-01/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.2206D-03,-0.1284D-03,-0.2801D-04, 0.7756D-04, 0.1952D-03,
     ,   0.3191D-03, 0.4541D-03, 0.5959D-03, 0.7482D-03, 0.9061D-03,
     ,   0.1073D-02, 0.1246D-02, 0.1424D-02, 0.1605D-02, 0.1786D-02,
     ,   0.1966D-02, 0.2139D-02, 0.2301D-02, 0.2447D-02, 0.2571D-02,
     ,   0.2664D-02, 0.2717D-02, 0.2725D-02, 0.2676D-02, 0.2558D-02,
     ,   0.2363D-02, 0.2081D-02, 0.1700D-02, 0.1214D-02, 0.6172D-03,
     ,  -0.8974D-04,-0.9068D-03,-0.1819D-02,-0.2828D-02,-0.3879D-02,
     ,  -0.4937D-02,-0.5942D-02,-0.6781D-02,-0.7348D-02,-0.7545D-02,
     ,  -0.7304D-02,-0.6599D-02,-0.5487D-02,-0.4088D-02,-0.2598D-02,
     ,  -0.1195D-02,-0.2059D-04, 0.8983D-03, 0.1594D-02, 0.2154D-02,
     ,   0.2622D-02, 0.2990D-02, 0.3249D-02, 0.3367D-02, 0.3337D-02,
     ,   0.3150D-02, 0.2824D-02, 0.2369D-02, 0.1799D-02, 0.1135D-02,
     ,   0.3961D-03,-0.4061D-03,-0.1253D-02,-0.2136D-02,-0.3067D-02,
     ,  -0.4061D-02,-0.5187D-02,-0.6420D-02,-0.7756D-02,-0.9141D-02,
     ,  -0.1053D-01,-0.1190D-01,-0.1319D-01/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.1580D-03,-0.9433D-04,-0.2551D-04, 0.4895D-04, 0.1285D-03,
     ,   0.2155D-03, 0.3075D-03, 0.4054D-03, 0.5099D-03, 0.6198D-03,
     ,   0.7344D-03, 0.8531D-03, 0.9738D-03, 0.1098D-02, 0.1221D-02,
     ,   0.1341D-02, 0.1458D-02, 0.1565D-02, 0.1659D-02, 0.1735D-02,
     ,   0.1790D-02, 0.1813D-02, 0.1802D-02, 0.1747D-02, 0.1639D-02,
     ,   0.1472D-02, 0.1238D-02, 0.9286D-03, 0.5354D-03, 0.5748D-04,
     ,  -0.5135D-03,-0.1172D-02,-0.1918D-02,-0.2739D-02,-0.3611D-02,
     ,  -0.4510D-02,-0.5368D-02,-0.6115D-02,-0.6656D-02,-0.6925D-02,
     ,  -0.6834D-02,-0.6366D-02,-0.5544D-02,-0.4433D-02,-0.3164D-02,
     ,  -0.1895D-02,-0.7616D-03, 0.1399D-03, 0.8184D-03, 0.1331D-02,
     ,   0.1744D-02, 0.2089D-02, 0.2365D-02, 0.2552D-02, 0.2629D-02,
     ,   0.2593D-02, 0.2435D-02, 0.2174D-02, 0.1811D-02, 0.1367D-02,
     ,   0.8494D-03, 0.2776D-03,-0.3399D-03,-0.9926D-03,-0.1676D-02,
     ,  -0.2395D-02,-0.3190D-02,-0.4064D-02,-0.5026D-02,-0.6056D-02,
     ,  -0.7112D-02,-0.8171D-02,-0.9203D-02/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.1126D-03,-0.6943D-04,-0.2154D-04, 0.3016D-04, 0.8529D-04,
     ,   0.1436D-03, 0.2075D-03, 0.2748D-03, 0.3467D-03, 0.4210D-03,
     ,   0.5001D-03, 0.5808D-03, 0.6626D-03, 0.7462D-03, 0.8293D-03,
     ,   0.9097D-03, 0.9865D-03, 0.1055D-02, 0.1115D-02, 0.1161D-02,
     ,   0.1188D-02, 0.1194D-02, 0.1172D-02, 0.1116D-02, 0.1021D-02,
     ,   0.8810D-03, 0.6885D-03, 0.4376D-03, 0.1215D-03,-0.2633D-03,
     ,  -0.7205D-03,-0.1251D-02,-0.1855D-02,-0.2524D-02,-0.3250D-02,
     ,  -0.3992D-02,-0.4730D-02,-0.5384D-02,-0.5895D-02,-0.6192D-02,
     ,  -0.6227D-02,-0.5946D-02,-0.5368D-02,-0.4525D-02,-0.3501D-02,
     ,  -0.2400D-02,-0.1354D-02,-0.4643D-03, 0.2156D-03, 0.7156D-03,
     ,   0.1083D-02, 0.1387D-02, 0.1642D-02, 0.1847D-02, 0.1982D-02,
     ,   0.2033D-02, 0.1994D-02, 0.1868D-02, 0.1657D-02, 0.1376D-02,
     ,   0.1029D-02, 0.6333D-03, 0.1945D-03,-0.2776D-03,-0.7772D-03,
     ,  -0.1301D-02,-0.1865D-02,-0.2476D-02,-0.3154D-02,-0.3897D-02,
     ,  -0.4683D-02,-0.5483D-02,-0.6280D-02/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.8045D-04,-0.5060D-04,-0.1857D-04, 0.1669D-04, 0.5480D-04,
     ,   0.9555D-04, 0.1401D-03, 0.1850D-03, 0.2347D-03, 0.2855D-03,
     ,   0.3375D-03, 0.3917D-03, 0.4489D-03, 0.5036D-03, 0.5600D-03,
     ,   0.6123D-03, 0.6618D-03, 0.7054D-03, 0.7420D-03, 0.7673D-03,
     ,   0.7787D-03, 0.7742D-03, 0.7472D-03, 0.6955D-03, 0.6137D-03,
     ,   0.4956D-03, 0.3389D-03, 0.1360D-03,-0.1167D-03,-0.4247D-03,
     ,  -0.7897D-03,-0.1216D-02,-0.1702D-02,-0.2245D-02,-0.2838D-02,
     ,  -0.3459D-02,-0.4078D-02,-0.4648D-02,-0.5115D-02,-0.5429D-02,
     ,  -0.5530D-02,-0.5396D-02,-0.5017D-02,-0.4401D-02,-0.3615D-02,
     ,  -0.2707D-02,-0.1792D-02,-0.9527D-03,-0.2665D-03, 0.2398D-03,
     ,   0.6000D-03, 0.8669D-03, 0.1087D-02, 0.1276D-02, 0.1427D-02,
     ,   0.1524D-02, 0.1558D-02, 0.1523D-02, 0.1421D-02, 0.1257D-02,
     ,   0.1036D-02, 0.7751D-03, 0.4725D-03, 0.1362D-03,-0.2239D-03,
     ,  -0.6009D-03,-0.1007D-02,-0.1434D-02,-0.1906D-02,-0.2427D-02,
     ,  -0.2996D-02,-0.3589D-02,-0.4190D-02/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.5815D-04,-0.3733D-04,-0.1557D-04, 0.8440D-05, 0.3441D-04,
     ,   0.6223D-04, 0.9344D-04, 0.1245D-03, 0.1574D-03, 0.1918D-03,
     ,   0.2274D-03, 0.2639D-03, 0.3021D-03, 0.3388D-03, 0.3758D-03,
     ,   0.4092D-03, 0.4411D-03, 0.4679D-03, 0.4896D-03, 0.5013D-03,
     ,   0.5045D-03, 0.4936D-03, 0.4657D-03, 0.4194D-03, 0.3496D-03,
     ,   0.2536D-03, 0.1260D-03,-0.3650D-04,-0.2390D-03,-0.4823D-03,
     ,  -0.7752D-03,-0.1115D-02,-0.1506D-02,-0.1944D-02,-0.2427D-02,
     ,  -0.2938D-02,-0.3455D-02,-0.3946D-02,-0.4359D-02,-0.4667D-02,
     ,  -0.4811D-02,-0.4773D-02,-0.4545D-02,-0.4123D-02,-0.3540D-02,
     ,  -0.2832D-02,-0.2071D-02,-0.1323D-02,-0.6615D-03,-0.1403D-03,
     ,   0.2338D-03, 0.4921D-03, 0.6836D-03, 0.8430D-03, 0.9823D-03,
     ,   0.1093D-02, 0.1164D-02, 0.1185D-02, 0.1155D-02, 0.1074D-02,
     ,   0.9472D-03, 0.7800D-03, 0.5776D-03, 0.3488D-03, 0.9451D-04,
     ,  -0.1765D-03,-0.4657D-03,-0.7694D-03,-0.1097D-02,-0.1456D-02,
     ,  -0.1854D-02,-0.2284D-02,-0.2730D-02/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.4112D-04,-0.2727D-04,-0.1200D-04, 0.4518D-05, 0.2205D-04,
     ,   0.4111D-04, 0.6120D-04, 0.8253D-04, 0.1050D-03, 0.1284D-03,
     ,   0.1526D-03, 0.1771D-03, 0.2019D-03, 0.2265D-03, 0.2504D-03,
     ,   0.2723D-03, 0.2918D-03, 0.3079D-03, 0.3192D-03, 0.3239D-03,
     ,   0.3209D-03, 0.3078D-03, 0.2821D-03, 0.2417D-03, 0.1836D-03,
     ,   0.1048D-03, 0.2481D-05,-0.1269D-03,-0.2879D-03,-0.4816D-03,
     ,  -0.7132D-03,-0.9836D-03,-0.1294D-02,-0.1647D-02,-0.2037D-02,
     ,  -0.2455D-02,-0.2883D-02,-0.3297D-02,-0.3663D-02,-0.3944D-02,
     ,  -0.4111D-02,-0.4133D-02,-0.4006D-02,-0.3738D-02,-0.3321D-02,
     ,  -0.2797D-02,-0.2191D-02,-0.1562D-02,-0.9655D-03,-0.4534D-03,
     ,  -0.6167D-04, 0.2115D-03, 0.3955D-03, 0.5320D-03, 0.6477D-03,
     ,   0.7498D-03, 0.8310D-03, 0.8819D-03, 0.8955D-03, 0.8705D-03,
     ,   0.8069D-03, 0.7099D-03, 0.5818D-03, 0.4303D-03, 0.2566D-03,
     ,   0.6589D-04,-0.1396D-03,-0.3559D-03,-0.5859D-03,-0.8335D-03,
     ,  -0.1107D-02,-0.1408D-02,-0.1731D-02/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.2941D-04,-0.1997D-04,-0.9425D-05, 0.1638D-05, 0.1369D-04,
     ,   0.2645D-04, 0.4018D-04, 0.5459D-04, 0.6980D-04, 0.8536D-04,
     ,   0.1015D-03, 0.1178D-03, 0.1343D-03, 0.1503D-03, 0.1655D-03,
     ,   0.1793D-03, 0.1911D-03, 0.2000D-03, 0.2055D-03, 0.2057D-03,
     ,   0.2001D-03, 0.1865D-03, 0.1637D-03, 0.1292D-03, 0.8153D-04,
     ,   0.1780D-04,-0.6398D-04,-0.1664D-03,-0.2944D-03,-0.4469D-03,
     ,  -0.6296D-03,-0.8438D-03,-0.1090D-02,-0.1371D-02,-0.1684D-02,
     ,  -0.2023D-02,-0.2375D-02,-0.2720D-02,-0.3033D-02,-0.3286D-02,
     ,  -0.3454D-02,-0.3517D-02,-0.3466D-02,-0.3296D-02,-0.3014D-02,
     ,  -0.2635D-02,-0.2178D-02,-0.1677D-02,-0.1169D-02,-0.6995D-03,
     ,  -0.3078D-03,-0.1553D-04, 0.1818D-03, 0.3130D-03, 0.4097D-03,
     ,   0.4933D-03, 0.5684D-03, 0.6279D-03, 0.6643D-03, 0.6731D-03,
     ,   0.6533D-03, 0.6033D-03, 0.5296D-03, 0.4333D-03, 0.3188D-03,
     ,   0.1885D-03, 0.4551D-04,-0.1078D-03,-0.2703D-03,-0.4429D-03,
     ,  -0.6293D-03,-0.8354D-03,-0.1062D-02/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.2112D-04,-0.1455D-04,-0.7447D-05, 0.2981D-07, 0.8355D-05,
     ,   0.1694D-04, 0.2627D-04, 0.3590D-04, 0.4616D-04, 0.5663D-04,
     ,   0.6728D-04, 0.7811D-04, 0.8879D-04, 0.9913D-04, 0.1087D-03,
     ,   0.1172D-03, 0.1240D-03, 0.1288D-03, 0.1305D-03, 0.1284D-03,
     ,   0.1216D-03, 0.1091D-03, 0.8907D-04, 0.6052D-04, 0.2173D-04,
     ,  -0.2922D-04,-0.9419D-04,-0.1753D-03,-0.2750D-03,-0.3948D-03,
     ,  -0.5377D-03,-0.7068D-03,-0.9023D-03,-0.1124D-02,-0.1375D-02,
     ,  -0.1647D-02,-0.1932D-02,-0.2218D-02,-0.2481D-02,-0.2703D-02,
     ,  -0.2862D-02,-0.2945D-02,-0.2938D-02,-0.2843D-02,-0.2659D-02,
     ,  -0.2394D-02,-0.2061D-02,-0.1678D-02,-0.1270D-02,-0.8678D-03,
     ,  -0.5028D-03,-0.2063D-03, 0.9487D-05, 0.1522D-03, 0.2448D-03,
     ,   0.3132D-03, 0.3737D-03, 0.4283D-03, 0.4716D-03, 0.4976D-03,
     ,   0.5033D-03, 0.4865D-03, 0.4495D-03, 0.3932D-03, 0.3211D-03,
     ,   0.2353D-03, 0.1378D-03, 0.3112D-04,-0.8305D-04,-0.2044D-03,
     ,  -0.3333D-03,-0.4732D-03,-0.6278D-03/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.1509D-04,-0.1080D-04,-0.5904D-05,-0.7010D-06, 0.4791D-05,
     ,   0.1071D-04, 0.1686D-04, 0.2350D-04, 0.3014D-04, 0.3709D-04,
     ,   0.4411D-04, 0.5139D-04, 0.5813D-04, 0.6482D-04, 0.7076D-04,
     ,   0.7569D-04, 0.7948D-04, 0.8157D-04, 0.8129D-04, 0.7814D-04,
     ,   0.7150D-04, 0.6016D-04, 0.4347D-04, 0.2000D-04,-0.1109D-04,
     ,  -0.5172D-04,-0.1029D-03,-0.1665D-03,-0.2446D-03,-0.3383D-03,
     ,  -0.4507D-03,-0.5815D-03,-0.7352D-03,-0.9113D-03,-0.1108D-02,
     ,  -0.1327D-02,-0.1557D-02,-0.1789D-02,-0.2008D-02,-0.2198D-02,
     ,  -0.2343D-02,-0.2431D-02,-0.2453D-02,-0.2407D-02,-0.2291D-02,
     ,  -0.2113D-02,-0.1877D-02,-0.1595D-02,-0.1281D-02,-0.9553D-03,
     ,  -0.6398D-03,-0.3602D-03,-0.1364D-03, 0.2199D-04, 0.1246D-03,
     ,   0.1891D-03, 0.2375D-03, 0.2812D-03, 0.3209D-03, 0.3524D-03,
     ,   0.3697D-03, 0.3753D-03, 0.3617D-03, 0.3333D-03, 0.2913D-03,
     ,   0.2372D-03, 0.1729D-03, 0.1006D-03, 0.2147D-04,-0.6360D-04,
     ,  -0.1535D-03,-0.2496D-03,-0.3541D-03/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.1067D-04,-0.7885D-05,-0.4612D-05,-0.1124D-05, 0.2735D-05,
     ,   0.6593D-05, 0.1062D-04, 0.1513D-04, 0.1973D-04, 0.2425D-04,
     ,   0.2888D-04, 0.3345D-04, 0.3779D-04, 0.4191D-04, 0.4556D-04,
     ,   0.4832D-04, 0.5018D-04, 0.5068D-04, 0.4955D-04, 0.4592D-04,
     ,   0.3996D-04, 0.3013D-04, 0.1625D-04,-0.2809D-05,-0.2742D-04,
     ,  -0.5951D-04,-0.9955D-04,-0.1494D-03,-0.2100D-03,-0.2830D-03,
     ,  -0.3698D-03,-0.4725D-03,-0.5927D-03,-0.7295D-03,-0.8867D-03,
     ,  -0.1059D-02,-0.1243D-02,-0.1431D-02,-0.1610D-02,-0.1770D-02,
     ,  -0.1897D-02,-0.1983D-02,-0.2020D-02,-0.2005D-02,-0.1938D-02,
     ,  -0.1821D-02,-0.1658D-02,-0.1457D-02,-0.1224D-02,-0.9710D-03,
     ,  -0.7136D-03,-0.4694D-03,-0.2565D-03,-0.8934D-04, 0.2690D-04,
     ,   0.9960D-04, 0.1452D-03, 0.1789D-03, 0.2103D-03, 0.2394D-03,
     ,   0.2623D-03, 0.2759D-03, 0.2776D-03, 0.2676D-03, 0.2461D-03,
     ,   0.2144D-03, 0.1743D-03, 0.1268D-03, 0.7311D-04, 0.1443D-04,
     ,  -0.4831D-04,-0.1150D-03,-0.1863D-03/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.7679D-05,-0.5731D-05,-0.3451D-05,-0.1086D-05, 0.1364D-05,
     ,   0.3889D-05, 0.6818D-05, 0.9700D-05, 0.1260D-04, 0.1572D-04,
     ,   0.1875D-04, 0.2157D-04, 0.2436D-04, 0.2698D-04, 0.2898D-04,
     ,   0.3050D-04, 0.3117D-04, 0.3088D-04, 0.2925D-04, 0.2581D-04,
     ,   0.2027D-04, 0.1229D-04, 0.8095D-06,-0.1421D-04,-0.3376D-04,
     ,  -0.5879D-04,-0.9012D-04,-0.1287D-03,-0.1756D-03,-0.2321D-03,
     ,  -0.2996D-03,-0.3790D-03,-0.4720D-03,-0.5797D-03,-0.7020D-03,
     ,  -0.8376D-03,-0.9834D-03,-0.1135D-02,-0.1280D-02,-0.1413D-02,
     ,  -0.1521D-02,-0.1600D-02,-0.1643D-02,-0.1647D-02,-0.1612D-02,
     ,  -0.1539D-02,-0.1429D-02,-0.1288D-02,-0.1119D-02,-0.9305D-03,
     ,  -0.7314D-03,-0.5304D-03,-0.3433D-03,-0.1820D-03,-0.5782D-04,
     ,   0.2671D-04, 0.7880D-04, 0.1102D-03, 0.1344D-03, 0.1567D-03,
     ,   0.1777D-03, 0.1945D-03, 0.2041D-03, 0.2051D-03, 0.1973D-03,
     ,   0.1813D-03, 0.1577D-03, 0.1278D-03, 0.9262D-04, 0.5315D-04,
     ,   0.9797D-05,-0.3650D-04,-0.8561D-04/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.5513D-05,-0.4163D-05,-0.2681D-05,-0.1110D-05, 0.5803D-06,
     ,   0.2341D-05, 0.4204D-05, 0.6117D-05, 0.8072D-05, 0.1005D-04,
     ,   0.1198D-04, 0.1386D-04, 0.1557D-04, 0.1706D-04, 0.1820D-04,
     ,   0.1889D-04, 0.1896D-04, 0.1823D-04, 0.1644D-04, 0.1336D-04,
     ,   0.8707D-05, 0.2039D-05,-0.7045D-05,-0.1894D-04,-0.3426D-04,
     ,  -0.5384D-04,-0.7801D-04,-0.1079D-03,-0.1440D-03,-0.1876D-03,
     ,  -0.2395D-03,-0.3009D-03,-0.3729D-03,-0.4563D-03,-0.5516D-03,
     ,  -0.6582D-03,-0.7736D-03,-0.8925D-03,-0.1010D-02,-0.1118D-02,
     ,  -0.1210D-02,-0.1279D-02,-0.1322D-02,-0.1338D-02,-0.1322D-02,
     ,  -0.1278D-02,-0.1206D-02,-0.1110D-02,-0.9904D-03,-0.8538D-03,
     ,  -0.7038D-03,-0.5465D-03,-0.3926D-03,-0.2493D-03,-0.1291D-03,
     ,  -0.3698D-04, 0.2482D-04, 0.6140D-04, 0.8347D-04, 0.1002D-03,
     ,   0.1163D-03, 0.1315D-03, 0.1436D-03, 0.1505D-03, 0.1510D-03,
     ,   0.1450D-03, 0.1330D-03, 0.1156D-03, 0.9338D-04, 0.6763D-04,
     ,   0.3849D-04, 0.6589D-05,-0.2739D-04/
      data (calcpts(j,45), j = 1,neta) /
     ,  -0.3937D-05,-0.3041D-05,-0.2060D-05,-0.1003D-05, 0.1410D-06,
     ,   0.1314D-05, 0.2542D-05, 0.3806D-05, 0.5087D-05, 0.6360D-05,
     ,   0.7595D-05, 0.8736D-05, 0.9784D-05, 0.1061D-04, 0.1121D-04,
     ,   0.1142D-04, 0.1112D-04, 0.1025D-04, 0.8560D-05, 0.5879D-05,
     ,   0.2017D-05,-0.3387D-05,-0.1058D-04,-0.1996D-04,-0.3199D-04,
     ,  -0.4703D-04,-0.6571D-04,-0.8855D-04,-0.1165D-03,-0.1498D-03,
     ,  -0.1898D-03,-0.2369D-03,-0.2923D-03,-0.3568D-03,-0.4306D-03,
     ,  -0.5134D-03,-0.6035D-03,-0.6974D-03,-0.7910D-03,-0.8788D-03,
     ,  -0.9547D-03,-0.1015D-02,-0.1055D-02,-0.1075D-02,-0.1071D-02,
     ,  -0.1047D-02,-0.1002D-02,-0.9366D-03,-0.8545D-03,-0.7563D-03,
     ,  -0.6464D-03,-0.5286D-03,-0.4072D-03,-0.2894D-03,-0.1812D-03,
     ,  -0.9079D-04,-0.2312D-04, 0.2144D-04, 0.4737D-04, 0.6273D-04,
     ,   0.7442D-04, 0.8594D-04, 0.9693D-04, 0.1057D-03, 0.1106D-03,
     ,   0.1108D-03, 0.1063D-03, 0.9735D-04, 0.8448D-04, 0.6814D-04,
     ,   0.4922D-04, 0.2780D-04, 0.4522D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,  -0.2825D-05,-0.2213D-05,-0.1548D-05,-0.8467D-06,-0.9699D-07,
     ,   0.6805D-06, 0.1495D-05, 0.2315D-05, 0.3155D-05, 0.3958D-05,
     ,   0.4729D-05, 0.5439D-05, 0.6042D-05, 0.6486D-05, 0.6742D-05,
     ,   0.6669D-05, 0.6263D-05, 0.5365D-05, 0.3875D-05, 0.1633D-05,
     ,  -0.1532D-05,-0.5822D-05,-0.1150D-04,-0.1882D-04,-0.2808D-04,
     ,  -0.3969D-04,-0.5399D-04,-0.7149D-04,-0.9285D-04,-0.1183D-03,
     ,  -0.1488D-03,-0.1851D-03,-0.2274D-03,-0.2770D-03,-0.3340D-03,
     ,  -0.3982D-03,-0.4683D-03,-0.5421D-03,-0.6161D-03,-0.6857D-03,
     ,  -0.7486D-03,-0.7991D-03,-0.8342D-03,-0.8553D-03,-0.8590D-03,
     ,  -0.8477D-03,-0.8191D-03,-0.7773D-03,-0.7209D-03,-0.6520D-03,
     ,  -0.5734D-03,-0.4874D-03,-0.3951D-03,-0.3018D-03,-0.2124D-03,
     ,  -0.1311D-03,-0.6389D-04,-0.1409D-04, 0.1800D-04, 0.3633D-04,
     ,   0.4690D-04, 0.5511D-04, 0.6327D-04, 0.7120D-04, 0.7752D-04,
     ,   0.8105D-04, 0.8111D-04, 0.7770D-04, 0.7107D-04, 0.6150D-04,
     ,   0.4967D-04, 0.3567D-04, 0.2035D-04/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.2015D-05,-0.1620D-05,-0.1185D-05,-0.7069D-06,-0.1906D-06,
     ,   0.3060D-06, 0.8428D-06, 0.1392D-05, 0.1903D-05, 0.2430D-05,
     ,   0.2901D-05, 0.3325D-05, 0.3653D-05, 0.3877D-05, 0.3903D-05,
     ,   0.3733D-05, 0.3277D-05, 0.2449D-05, 0.1171D-05,-0.6677D-06,
     ,  -0.3206D-05,-0.6583D-05,-0.1102D-04,-0.1668D-04,-0.2380D-04,
     ,  -0.3271D-04,-0.4363D-04,-0.5697D-04,-0.7315D-04,-0.9254D-04,
     ,  -0.1159D-03,-0.1433D-03,-0.1758D-03,-0.2138D-03,-0.2575D-03,
     ,  -0.3071D-03,-0.3613D-03,-0.4188D-03,-0.4768D-03,-0.5324D-03,
     ,  -0.5823D-03,-0.6239D-03,-0.6551D-03,-0.6758D-03,-0.6829D-03,
     ,  -0.6785D-03,-0.6630D-03,-0.6354D-03,-0.5982D-03,-0.5500D-03,
     ,  -0.4947D-03,-0.4323D-03,-0.3649D-03,-0.2941D-03,-0.2231D-03,
     ,  -0.1553D-03,-0.9458D-04,-0.4478D-04,-0.8344D-05, 0.1474D-04,
     ,   0.2760D-04, 0.3492D-04, 0.4064D-04, 0.4667D-04, 0.5211D-04,
     ,   0.5673D-04, 0.5919D-04, 0.5920D-04, 0.5824D-04, 0.5098D-04,
     ,   0.4463D-04, 0.3635D-04, 0.2546D-04/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.1455D-05,-0.1167D-05,-0.8808D-06,-0.5815D-06,-0.2340D-06,
     ,   0.9871D-07, 0.4402D-06, 0.7864D-06, 0.1120D-05, 0.1443D-05,
     ,   0.1736D-05, 0.1970D-05, 0.2133D-05, 0.2214D-05, 0.2155D-05,
     ,   0.1938D-05, 0.1497D-05, 0.7773D-06,-0.2786D-06,-0.1778D-05,
     ,  -0.3775D-05,-0.6430D-05,-0.9884D-05,-0.1423D-04,-0.1968D-04,
     ,  -0.2647D-04,-0.3478D-04,-0.4495D-04,-0.5722D-04,-0.7199D-04,
     ,  -0.8955D-04,-0.1105D-03,-0.1353D-03,-0.1643D-03,-0.1977D-03,
     ,  -0.2355D-03,-0.2774D-03,-0.3219D-03,-0.3672D-03,-0.4108D-03,
     ,  -0.4508D-03,-0.4848D-03,-0.5113D-03,-0.5294D-03,-0.5386D-03,
     ,  -0.5389D-03,-0.5303D-03,-0.5132D-03,-0.4883D-03,-0.4561D-03,
     ,  -0.4175D-03,-0.3731D-03,-0.3243D-03,-0.2721D-03,-0.2180D-03,
     ,  -0.1643D-03,-0.1133D-03,-0.6805D-04,-0.3200D-04,-0.4545D-05,
     ,   0.1184D-04, 0.2089D-04, 0.2589D-04, 0.2989D-04, 0.3403D-04,
     ,   0.3816D-04, 0.4141D-04, 0.4320D-04, 0.4311D-04, 0.4121D-04,
     ,   0.3760D-04, 0.3248D-04, 0.2615D-04/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.1034D-05,-0.8582D-06,-0.6459D-06,-0.4541D-06,-0.2516D-06,
     ,  -0.1445D-07, 0.2122D-06, 0.4316D-06, 0.6443D-06, 0.8295D-06,
     ,   0.1005D-05, 0.1129D-05, 0.1204D-05, 0.1202D-05, 0.1092D-05,
     ,   0.8584D-06, 0.4610D-06,-0.1306D-06,-0.1011D-05,-0.2203D-05,
     ,  -0.3765D-05,-0.5828D-05,-0.8458D-05,-0.1179D-04,-0.1595D-04,
     ,  -0.2112D-04,-0.2742D-04,-0.3510D-04,-0.4438D-04,-0.5553D-04,
     ,  -0.6888D-04,-0.8465D-04,-0.1035D-03,-0.1254D-03,-0.1509D-03,
     ,  -0.1800D-03,-0.2121D-03,-0.2462D-03,-0.2813D-03,-0.3156D-03,
     ,  -0.3471D-03,-0.3745D-03,-0.3964D-03,-0.4123D-03,-0.4216D-03,
     ,  -0.4243D-03,-0.4204D-03,-0.4102D-03,-0.3941D-03,-0.3725D-03,
     ,  -0.3458D-03,-0.3148D-03,-0.2800D-03,-0.2420D-03,-0.2020D-03,
     ,  -0.1610D-03,-0.1205D-03,-0.8244D-04,-0.4893D-04,-0.2190D-04,
     ,  -0.2544D-05, 0.9318D-05, 0.1565D-04, 0.1915D-04, 0.2186D-04,
     ,   0.2484D-04, 0.2778D-04, 0.3014D-04, 0.3142D-04, 0.3133D-04,
     ,   0.2991D-04, 0.2725D-04, 0.2356D-04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c--------------------
      subroutine c2hqg22(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.9890D-03, 0.1137D-02, 0.1304D-02, 0.1494D-02, 0.1710D-02,
     ,   0.1953D-02, 0.2226D-02, 0.2533D-02, 0.2876D-02, 0.3258D-02,
     ,   0.3683D-02, 0.4152D-02, 0.4669D-02, 0.5235D-02, 0.5851D-02,
     ,   0.6517D-02, 0.7232D-02, 0.7994D-02, 0.8797D-02, 0.9634D-02,
     ,   0.1050D-01, 0.1137D-01, 0.1224D-01, 0.1308D-01, 0.1387D-01,
     ,   0.1460D-01, 0.1522D-01, 0.1571D-01, 0.1603D-01, 0.1616D-01,
     ,   0.1602D-01, 0.1553D-01, 0.1456D-01, 0.1295D-01, 0.1056D-01,
     ,   0.7433D-02, 0.3821D-02, 0.1456D-03,-0.3182D-02,-0.5913D-02,
     ,  -0.7977D-02,-0.9401D-02,-0.1024D-01,-0.1055D-01,-0.1037D-01,
     ,  -0.9748D-02,-0.8742D-02,-0.7402D-02,-0.5778D-02,-0.3909D-02,
     ,  -0.1810D-02, 0.5315D-03, 0.3084D-02, 0.5661D-02, 0.7877D-02,
     ,   0.9316D-02, 0.9773D-02, 0.9348D-02, 0.8335D-02, 0.7051D-02,
     ,   0.5737D-02, 0.4535D-02, 0.3509D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1493D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.9889D-03, 0.1136D-02, 0.1304D-02, 0.1494D-02, 0.1710D-02,
     ,   0.1952D-02, 0.2226D-02, 0.2532D-02, 0.2875D-02, 0.3258D-02,
     ,   0.3682D-02, 0.4152D-02, 0.4668D-02, 0.5234D-02, 0.5850D-02,
     ,   0.6516D-02, 0.7231D-02, 0.7993D-02, 0.8796D-02, 0.9633D-02,
     ,   0.1050D-01, 0.1137D-01, 0.1224D-01, 0.1308D-01, 0.1387D-01,
     ,   0.1459D-01, 0.1521D-01, 0.1570D-01, 0.1603D-01, 0.1616D-01,
     ,   0.1602D-01, 0.1553D-01, 0.1456D-01, 0.1295D-01, 0.1056D-01,
     ,   0.7434D-02, 0.3822D-02, 0.1465D-03,-0.3181D-02,-0.5912D-02,
     ,  -0.7976D-02,-0.9400D-02,-0.1024D-01,-0.1055D-01,-0.1037D-01,
     ,  -0.9747D-02,-0.8741D-02,-0.7401D-02,-0.5778D-02,-0.3910D-02,
     ,  -0.1810D-02, 0.5308D-03, 0.3083D-02, 0.5660D-02, 0.7876D-02,
     ,   0.9315D-02, 0.9772D-02, 0.9348D-02, 0.8334D-02, 0.7050D-02,
     ,   0.5737D-02, 0.4535D-02, 0.3509D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1493D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.9887D-03, 0.1136D-02, 0.1304D-02, 0.1494D-02, 0.1709D-02,
     ,   0.1952D-02, 0.2225D-02, 0.2532D-02, 0.2875D-02, 0.3257D-02,
     ,   0.3682D-02, 0.4151D-02, 0.4668D-02, 0.5233D-02, 0.5849D-02,
     ,   0.6515D-02, 0.7231D-02, 0.7992D-02, 0.8795D-02, 0.9632D-02,
     ,   0.1049D-01, 0.1137D-01, 0.1223D-01, 0.1308D-01, 0.1387D-01,
     ,   0.1459D-01, 0.1521D-01, 0.1570D-01, 0.1603D-01, 0.1615D-01,
     ,   0.1602D-01, 0.1553D-01, 0.1456D-01, 0.1295D-01, 0.1056D-01,
     ,   0.7434D-02, 0.3823D-02, 0.1478D-03,-0.3180D-02,-0.5911D-02,
     ,  -0.7974D-02,-0.9399D-02,-0.1024D-01,-0.1055D-01,-0.1036D-01,
     ,  -0.9746D-02,-0.8741D-02,-0.7401D-02,-0.5778D-02,-0.3910D-02,
     ,  -0.1811D-02, 0.5298D-03, 0.3082D-02, 0.5658D-02, 0.7874D-02,
     ,   0.9313D-02, 0.9771D-02, 0.9347D-02, 0.8334D-02, 0.7050D-02,
     ,   0.5736D-02, 0.4535D-02, 0.3508D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1493D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.9885D-03, 0.1136D-02, 0.1304D-02, 0.1494D-02, 0.1709D-02,
     ,   0.1952D-02, 0.2225D-02, 0.2531D-02, 0.2874D-02, 0.3257D-02,
     ,   0.3681D-02, 0.4150D-02, 0.4667D-02, 0.5232D-02, 0.5848D-02,
     ,   0.6514D-02, 0.7229D-02, 0.7990D-02, 0.8793D-02, 0.9630D-02,
     ,   0.1049D-01, 0.1136D-01, 0.1223D-01, 0.1307D-01, 0.1387D-01,
     ,   0.1459D-01, 0.1521D-01, 0.1570D-01, 0.1603D-01, 0.1615D-01,
     ,   0.1602D-01, 0.1553D-01, 0.1456D-01, 0.1294D-01, 0.1056D-01,
     ,   0.7435D-02, 0.3824D-02, 0.1498D-03,-0.3177D-02,-0.5908D-02,
     ,  -0.7972D-02,-0.9396D-02,-0.1024D-01,-0.1054D-01,-0.1036D-01,
     ,  -0.9745D-02,-0.8740D-02,-0.7401D-02,-0.5778D-02,-0.3910D-02,
     ,  -0.1812D-02, 0.5282D-03, 0.3080D-02, 0.5656D-02, 0.7872D-02,
     ,   0.9311D-02, 0.9769D-02, 0.9346D-02, 0.8333D-02, 0.7050D-02,
     ,   0.5736D-02, 0.4535D-02, 0.3508D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1493D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.9882D-03, 0.1136D-02, 0.1303D-02, 0.1493D-02, 0.1708D-02,
     ,   0.1951D-02, 0.2224D-02, 0.2531D-02, 0.2873D-02, 0.3256D-02,
     ,   0.3680D-02, 0.4149D-02, 0.4665D-02, 0.5231D-02, 0.5846D-02,
     ,   0.6512D-02, 0.7227D-02, 0.7988D-02, 0.8791D-02, 0.9628D-02,
     ,   0.1049D-01, 0.1136D-01, 0.1223D-01, 0.1307D-01, 0.1387D-01,
     ,   0.1459D-01, 0.1521D-01, 0.1570D-01, 0.1602D-01, 0.1615D-01,
     ,   0.1601D-01, 0.1553D-01, 0.1456D-01, 0.1294D-01, 0.1056D-01,
     ,   0.7437D-02, 0.3827D-02, 0.1527D-03,-0.3174D-02,-0.5905D-02,
     ,  -0.7969D-02,-0.9393D-02,-0.1023D-01,-0.1054D-01,-0.1036D-01,
     ,  -0.9743D-02,-0.8739D-02,-0.7400D-02,-0.5778D-02,-0.3911D-02,
     ,  -0.1813D-02, 0.5260D-03, 0.3077D-02, 0.5652D-02, 0.7868D-02,
     ,   0.9308D-02, 0.9767D-02, 0.9344D-02, 0.8332D-02, 0.7049D-02,
     ,   0.5736D-02, 0.4535D-02, 0.3508D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.9877D-03, 0.1135D-02, 0.1303D-02, 0.1493D-02, 0.1708D-02,
     ,   0.1950D-02, 0.2223D-02, 0.2529D-02, 0.2872D-02, 0.3254D-02,
     ,   0.3678D-02, 0.4147D-02, 0.4663D-02, 0.5229D-02, 0.5844D-02,
     ,   0.6509D-02, 0.7224D-02, 0.7985D-02, 0.8787D-02, 0.9624D-02,
     ,   0.1049D-01, 0.1136D-01, 0.1222D-01, 0.1307D-01, 0.1386D-01,
     ,   0.1458D-01, 0.1520D-01, 0.1569D-01, 0.1602D-01, 0.1614D-01,
     ,   0.1601D-01, 0.1552D-01, 0.1456D-01, 0.1294D-01, 0.1056D-01,
     ,   0.7439D-02, 0.3830D-02, 0.1569D-03,-0.3170D-02,-0.5900D-02,
     ,  -0.7964D-02,-0.9388D-02,-0.1023D-01,-0.1054D-01,-0.1036D-01,
     ,  -0.9741D-02,-0.8737D-02,-0.7399D-02,-0.5778D-02,-0.3912D-02,
     ,  -0.1815D-02, 0.5227D-03, 0.3073D-02, 0.5647D-02, 0.7863D-02,
     ,   0.9303D-02, 0.9763D-02, 0.9341D-02, 0.8330D-02, 0.7048D-02,
     ,   0.5735D-02, 0.4534D-02, 0.3508D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.9871D-03, 0.1134D-02, 0.1302D-02, 0.1492D-02, 0.1706D-02,
     ,   0.1949D-02, 0.2222D-02, 0.2528D-02, 0.2870D-02, 0.3252D-02,
     ,   0.3676D-02, 0.4145D-02, 0.4660D-02, 0.5225D-02, 0.5840D-02,
     ,   0.6505D-02, 0.7220D-02, 0.7980D-02, 0.8782D-02, 0.9618D-02,
     ,   0.1048D-01, 0.1135D-01, 0.1222D-01, 0.1306D-01, 0.1385D-01,
     ,   0.1458D-01, 0.1520D-01, 0.1569D-01, 0.1601D-01, 0.1614D-01,
     ,   0.1600D-01, 0.1552D-01, 0.1455D-01, 0.1294D-01, 0.1056D-01,
     ,   0.7442D-02, 0.3835D-02, 0.1631D-03,-0.3163D-02,-0.5893D-02,
     ,  -0.7956D-02,-0.9381D-02,-0.1022D-01,-0.1053D-01,-0.1035D-01,
     ,  -0.9737D-02,-0.8735D-02,-0.7398D-02,-0.5778D-02,-0.3914D-02,
     ,  -0.1818D-02, 0.5178D-03, 0.3066D-02, 0.5639D-02, 0.7855D-02,
     ,   0.9296D-02, 0.9758D-02, 0.9337D-02, 0.8328D-02, 0.7046D-02,
     ,   0.5734D-02, 0.4534D-02, 0.3508D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8073D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.9861D-03, 0.1133D-02, 0.1300D-02, 0.1490D-02, 0.1705D-02,
     ,   0.1947D-02, 0.2219D-02, 0.2525D-02, 0.2867D-02, 0.3249D-02,
     ,   0.3672D-02, 0.4141D-02, 0.4656D-02, 0.5220D-02, 0.5835D-02,
     ,   0.6500D-02, 0.7213D-02, 0.7973D-02, 0.8775D-02, 0.9610D-02,
     ,   0.1047D-01, 0.1134D-01, 0.1221D-01, 0.1305D-01, 0.1384D-01,
     ,   0.1457D-01, 0.1519D-01, 0.1568D-01, 0.1600D-01, 0.1613D-01,
     ,   0.1600D-01, 0.1551D-01, 0.1455D-01, 0.1294D-01, 0.1056D-01,
     ,   0.7446D-02, 0.3842D-02, 0.1722D-03,-0.3152D-02,-0.5882D-02,
     ,  -0.7946D-02,-0.9371D-02,-0.1021D-01,-0.1052D-01,-0.1035D-01,
     ,  -0.9732D-02,-0.8731D-02,-0.7397D-02,-0.5779D-02,-0.3916D-02,
     ,  -0.1823D-02, 0.5107D-03, 0.3056D-02, 0.5628D-02, 0.7843D-02,
     ,   0.9286D-02, 0.9750D-02, 0.9332D-02, 0.8324D-02, 0.7044D-02,
     ,   0.5733D-02, 0.4533D-02, 0.3507D-02, 0.2670D-02, 0.2006D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8072D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1596D-03/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.9846D-03, 0.1132D-02, 0.1299D-02, 0.1488D-02, 0.1702D-02,
     ,   0.1944D-02, 0.2216D-02, 0.2522D-02, 0.2863D-02, 0.3244D-02,
     ,   0.3667D-02, 0.4135D-02, 0.4650D-02, 0.5213D-02, 0.5827D-02,
     ,   0.6491D-02, 0.7204D-02, 0.7963D-02, 0.8763D-02, 0.9598D-02,
     ,   0.1046D-01, 0.1133D-01, 0.1219D-01, 0.1304D-01, 0.1383D-01,
     ,   0.1455D-01, 0.1517D-01, 0.1566D-01, 0.1599D-01, 0.1612D-01,
     ,   0.1598D-01, 0.1550D-01, 0.1454D-01, 0.1294D-01, 0.1056D-01,
     ,   0.7452D-02, 0.3853D-02, 0.1856D-03,-0.3138D-02,-0.5867D-02,
     ,  -0.7931D-02,-0.9357D-02,-0.1020D-01,-0.1051D-01,-0.1034D-01,
     ,  -0.9724D-02,-0.8726D-02,-0.7394D-02,-0.5779D-02,-0.3920D-02,
     ,  -0.1830D-02, 0.5003D-03, 0.3042D-02, 0.5612D-02, 0.7827D-02,
     ,   0.9271D-02, 0.9738D-02, 0.9324D-02, 0.8319D-02, 0.7041D-02,
     ,   0.5731D-02, 0.4532D-02, 0.3507D-02, 0.2669D-02, 0.2006D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8072D-03, 0.5885D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.9825D-03, 0.1129D-02, 0.1296D-02, 0.1485D-02, 0.1699D-02,
     ,   0.1940D-02, 0.2212D-02, 0.2516D-02, 0.2857D-02, 0.3238D-02,
     ,   0.3660D-02, 0.4127D-02, 0.4640D-02, 0.5203D-02, 0.5816D-02,
     ,   0.6478D-02, 0.7190D-02, 0.7948D-02, 0.8747D-02, 0.9581D-02,
     ,   0.1044D-01, 0.1131D-01, 0.1217D-01, 0.1301D-01, 0.1381D-01,
     ,   0.1453D-01, 0.1515D-01, 0.1564D-01, 0.1597D-01, 0.1610D-01,
     ,   0.1597D-01, 0.1549D-01, 0.1453D-01, 0.1293D-01, 0.1057D-01,
     ,   0.7462D-02, 0.3868D-02, 0.2050D-03,-0.3116D-02,-0.5844D-02,
     ,  -0.7908D-02,-0.9335D-02,-0.1018D-01,-0.1049D-01,-0.1032D-01,
     ,  -0.9712D-02,-0.8718D-02,-0.7390D-02,-0.5779D-02,-0.3924D-02,
     ,  -0.1840D-02, 0.4851D-03, 0.3022D-02, 0.5588D-02, 0.7802D-02,
     ,   0.9250D-02, 0.9721D-02, 0.9312D-02, 0.8311D-02, 0.7036D-02,
     ,   0.5728D-02, 0.4530D-02, 0.3506D-02, 0.2669D-02, 0.2006D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8072D-03, 0.5884D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.9794D-03, 0.1126D-02, 0.1292D-02, 0.1480D-02, 0.1693D-02,
     ,   0.1934D-02, 0.2205D-02, 0.2509D-02, 0.2849D-02, 0.3228D-02,
     ,   0.3649D-02, 0.4114D-02, 0.4627D-02, 0.5188D-02, 0.5799D-02,
     ,   0.6460D-02, 0.7170D-02, 0.7926D-02, 0.8723D-02, 0.9555D-02,
     ,   0.1041D-01, 0.1128D-01, 0.1214D-01, 0.1298D-01, 0.1377D-01,
     ,   0.1449D-01, 0.1511D-01, 0.1561D-01, 0.1594D-01, 0.1607D-01,
     ,   0.1594D-01, 0.1547D-01, 0.1451D-01, 0.1292D-01, 0.1057D-01,
     ,   0.7475D-02, 0.3890D-02, 0.2334D-03,-0.3084D-02,-0.5811D-02,
     ,  -0.7875D-02,-0.9303D-02,-0.1015D-01,-0.1047D-01,-0.1030D-01,
     ,  -0.9696D-02,-0.8706D-02,-0.7385D-02,-0.5780D-02,-0.3932D-02,
     ,  -0.1854D-02, 0.4629D-03, 0.2992D-02, 0.5553D-02, 0.7766D-02,
     ,   0.9218D-02, 0.9696D-02, 0.9294D-02, 0.8299D-02, 0.7029D-02,
     ,   0.5724D-02, 0.4528D-02, 0.3505D-02, 0.2668D-02, 0.2005D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8071D-03, 0.5884D-03, 0.4270D-03,
     ,   0.3086D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.9749D-03, 0.1120D-02, 0.1286D-02, 0.1473D-02, 0.1686D-02,
     ,   0.1925D-02, 0.2195D-02, 0.2498D-02, 0.2836D-02, 0.3214D-02,
     ,   0.3633D-02, 0.4097D-02, 0.4607D-02, 0.5166D-02, 0.5775D-02,
     ,   0.6433D-02, 0.7140D-02, 0.7894D-02, 0.8689D-02, 0.9518D-02,
     ,   0.1037D-01, 0.1124D-01, 0.1210D-01, 0.1294D-01, 0.1373D-01,
     ,   0.1445D-01, 0.1507D-01, 0.1556D-01, 0.1589D-01, 0.1602D-01,
     ,   0.1590D-01, 0.1543D-01, 0.1449D-01, 0.1291D-01, 0.1057D-01,
     ,   0.7495D-02, 0.3923D-02, 0.2747D-03,-0.3038D-02,-0.5763D-02,
     ,  -0.7827D-02,-0.9257D-02,-0.1011D-01,-0.1043D-01,-0.1027D-01,
     ,  -0.9671D-02,-0.8690D-02,-0.7376D-02,-0.5781D-02,-0.3942D-02,
     ,  -0.1875D-02, 0.4308D-03, 0.2949D-02, 0.5502D-02, 0.7714D-02,
     ,   0.9171D-02, 0.9660D-02, 0.9268D-02, 0.8282D-02, 0.7018D-02,
     ,   0.5718D-02, 0.4524D-02, 0.3503D-02, 0.2667D-02, 0.2005D-02,
     ,   0.1492D-02, 0.1101D-02, 0.8071D-03, 0.5884D-03, 0.4269D-03,
     ,   0.3085D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.9683D-03, 0.1113D-02, 0.1277D-02, 0.1464D-02, 0.1675D-02,
     ,   0.1913D-02, 0.2181D-02, 0.2481D-02, 0.2818D-02, 0.3193D-02,
     ,   0.3610D-02, 0.4071D-02, 0.4578D-02, 0.5134D-02, 0.5739D-02,
     ,   0.6394D-02, 0.7098D-02, 0.7847D-02, 0.8638D-02, 0.9464D-02,
     ,   0.1031D-01, 0.1118D-01, 0.1203D-01, 0.1287D-01, 0.1366D-01,
     ,   0.1438D-01, 0.1500D-01, 0.1549D-01, 0.1582D-01, 0.1596D-01,
     ,   0.1584D-01, 0.1539D-01, 0.1446D-01, 0.1290D-01, 0.1058D-01,
     ,   0.7523D-02, 0.3970D-02, 0.3346D-03,-0.2971D-02,-0.5694D-02,
     ,  -0.7757D-02,-0.9189D-02,-0.1004D-01,-0.1037D-01,-0.1022D-01,
     ,  -0.9635D-02,-0.8665D-02,-0.7364D-02,-0.5782D-02,-0.3957D-02,
     ,  -0.1905D-02, 0.3844D-03, 0.2887D-02, 0.5428D-02, 0.7638D-02,
     ,   0.9104D-02, 0.9606D-02, 0.9230D-02, 0.8257D-02, 0.7003D-02,
     ,   0.5709D-02, 0.4519D-02, 0.3500D-02, 0.2665D-02, 0.2004D-02,
     ,   0.1491D-02, 0.1101D-02, 0.8069D-03, 0.5883D-03, 0.4269D-03,
     ,   0.3085D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.9589D-03, 0.1102D-02, 0.1265D-02, 0.1450D-02, 0.1659D-02,
     ,   0.1894D-02, 0.2160D-02, 0.2458D-02, 0.2792D-02, 0.3163D-02,
     ,   0.3577D-02, 0.4033D-02, 0.4537D-02, 0.5088D-02, 0.5688D-02,
     ,   0.6338D-02, 0.7036D-02, 0.7780D-02, 0.8566D-02, 0.9386D-02,
     ,   0.1023D-01, 0.1109D-01, 0.1194D-01, 0.1277D-01, 0.1356D-01,
     ,   0.1428D-01, 0.1490D-01, 0.1539D-01, 0.1573D-01, 0.1587D-01,
     ,   0.1576D-01, 0.1532D-01, 0.1441D-01, 0.1287D-01, 0.1059D-01,
     ,   0.7563D-02, 0.4037D-02, 0.4207D-03,-0.2875D-02,-0.5593D-02,
     ,  -0.7656D-02,-0.9092D-02,-0.9954D-02,-0.1029D-01,-0.1015D-01,
     ,  -0.9582D-02,-0.8629D-02,-0.7346D-02,-0.5783D-02,-0.3978D-02,
     ,  -0.1947D-02, 0.3180D-03, 0.2797D-02, 0.5321D-02, 0.7529D-02,
     ,   0.9006D-02, 0.9529D-02, 0.9175D-02, 0.8221D-02, 0.6981D-02,
     ,   0.5696D-02, 0.4512D-02, 0.3496D-02, 0.2663D-02, 0.2003D-02,
     ,   0.1491D-02, 0.1100D-02, 0.8068D-03, 0.5882D-03, 0.4269D-03,
     ,   0.3085D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.9453D-03, 0.1087D-02, 0.1247D-02, 0.1429D-02, 0.1636D-02,
     ,   0.1868D-02, 0.2130D-02, 0.2425D-02, 0.2754D-02, 0.3121D-02,
     ,   0.3529D-02, 0.3980D-02, 0.4477D-02, 0.5022D-02, 0.5615D-02,
     ,   0.6258D-02, 0.6948D-02, 0.7684D-02, 0.8462D-02, 0.9274D-02,
     ,   0.1011D-01, 0.1096D-01, 0.1181D-01, 0.1263D-01, 0.1342D-01,
     ,   0.1413D-01, 0.1475D-01, 0.1525D-01, 0.1559D-01, 0.1574D-01,
     ,   0.1565D-01, 0.1522D-01, 0.1434D-01, 0.1284D-01, 0.1060D-01,
     ,   0.7619D-02, 0.4133D-02, 0.5438D-03,-0.2736D-02,-0.5448D-02,
     ,  -0.7512D-02,-0.8952D-02,-0.9824D-02,-0.1018D-01,-0.1006D-01,
     ,  -0.9506D-02,-0.8577D-02,-0.7320D-02,-0.5783D-02,-0.4007D-02,
     ,  -0.2007D-02, 0.2238D-03, 0.2669D-02, 0.5169D-02, 0.7371D-02,
     ,   0.8864D-02, 0.9417D-02, 0.9095D-02, 0.8169D-02, 0.6948D-02,
     ,   0.5676D-02, 0.4501D-02, 0.3490D-02, 0.2660D-02, 0.2001D-02,
     ,   0.1490D-02, 0.1100D-02, 0.8065D-03, 0.5881D-03, 0.4268D-03,
     ,   0.3085D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.9262D-03, 0.1065D-02, 0.1222D-02, 0.1401D-02, 0.1603D-02,
     ,   0.1831D-02, 0.2089D-02, 0.2377D-02, 0.2700D-02, 0.3061D-02,
     ,   0.3461D-02, 0.3905D-02, 0.4393D-02, 0.4928D-02, 0.5512D-02,
     ,   0.6144D-02, 0.6823D-02, 0.7548D-02, 0.8314D-02, 0.9114D-02,
     ,   0.9941D-02, 0.1078D-01, 0.1162D-01, 0.1244D-01, 0.1321D-01,
     ,   0.1393D-01, 0.1454D-01, 0.1504D-01, 0.1539D-01, 0.1556D-01,
     ,   0.1548D-01, 0.1508D-01, 0.1423D-01, 0.1279D-01, 0.1061D-01,
     ,   0.7696D-02, 0.4266D-02, 0.7172D-03,-0.2541D-02,-0.5243D-02,
     ,  -0.7306D-02,-0.8753D-02,-0.9638D-02,-0.1001D-01,-0.9916D-02,
     ,  -0.9396D-02,-0.8501D-02,-0.7280D-02,-0.5782D-02,-0.4046D-02,
     ,  -0.2091D-02, 0.9241D-04, 0.2489D-02, 0.4954D-02, 0.7147D-02,
     ,   0.8661D-02, 0.9255D-02, 0.8979D-02, 0.8092D-02, 0.6901D-02,
     ,   0.5648D-02, 0.4485D-02, 0.3481D-02, 0.2655D-02, 0.1998D-02,
     ,   0.1488D-02, 0.1099D-02, 0.8062D-03, 0.5879D-03, 0.4267D-03,
     ,   0.3084D-03, 0.2222D-03, 0.1595D-03/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.8996D-03, 0.1034D-02, 0.1187D-02, 0.1361D-02, 0.1558D-02,
     ,   0.1780D-02, 0.2030D-02, 0.2311D-02, 0.2626D-02, 0.2977D-02,
     ,   0.3367D-02, 0.3799D-02, 0.4276D-02, 0.4798D-02, 0.5367D-02,
     ,   0.5985D-02, 0.6649D-02, 0.7358D-02, 0.8108D-02, 0.8892D-02,
     ,   0.9702D-02, 0.1053D-01, 0.1135D-01, 0.1216D-01, 0.1293D-01,
     ,   0.1364D-01, 0.1425D-01, 0.1476D-01, 0.1512D-01, 0.1529D-01,
     ,   0.1524D-01, 0.1488D-01, 0.1408D-01, 0.1271D-01, 0.1062D-01,
     ,   0.7798D-02, 0.4449D-02, 0.9575D-03,-0.2268D-02,-0.4956D-02,
     ,  -0.7017D-02,-0.8473D-02,-0.9376D-02,-0.9776D-02,-0.9717D-02,
     ,  -0.9239D-02,-0.8391D-02,-0.7220D-02,-0.5776D-02,-0.4096D-02,
     ,  -0.2202D-02,-0.8674D-04, 0.2242D-02, 0.4655D-02, 0.6833D-02,
     ,   0.8374D-02, 0.9025D-02, 0.8813D-02, 0.7982D-02, 0.6832D-02,
     ,   0.5608D-02, 0.4462D-02, 0.3468D-02, 0.2648D-02, 0.1995D-02,
     ,   0.1486D-02, 0.1098D-02, 0.8057D-03, 0.5877D-03, 0.4266D-03,
     ,   0.3084D-03, 0.2221D-03, 0.1595D-03/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.8634D-03, 0.9928D-03, 0.1140D-02, 0.1307D-02, 0.1496D-02,
     ,   0.1710D-02, 0.1951D-02, 0.2221D-02, 0.2524D-02, 0.2863D-02,
     ,   0.3239D-02, 0.3656D-02, 0.4115D-02, 0.4620D-02, 0.5170D-02,
     ,   0.5767D-02, 0.6410D-02, 0.7097D-02, 0.7825D-02, 0.8587D-02,
     ,   0.9376D-02, 0.1018D-01, 0.1099D-01, 0.1178D-01, 0.1254D-01,
     ,   0.1324D-01, 0.1385D-01, 0.1436D-01, 0.1473D-01, 0.1493D-01,
     ,   0.1491D-01, 0.1459D-01, 0.1387D-01, 0.1259D-01, 0.1062D-01,
     ,   0.7926D-02, 0.4692D-02, 0.1282D-02,-0.1896D-02,-0.4563D-02,
     ,  -0.6620D-02,-0.8086D-02,-0.9013D-02,-0.9450D-02,-0.9438D-02,
     ,  -0.9017D-02,-0.8233D-02,-0.7132D-02,-0.5760D-02,-0.4158D-02,
     ,  -0.2347D-02,-0.3234D-03, 0.1912D-02, 0.4250D-02, 0.6401D-02,
     ,   0.7975D-02, 0.8700D-02, 0.8576D-02, 0.7823D-02, 0.6733D-02,
     ,   0.5549D-02, 0.4428D-02, 0.3449D-02, 0.2638D-02, 0.1989D-02,
     ,   0.1484D-02, 0.1097D-02, 0.8049D-03, 0.5873D-03, 0.4264D-03,
     ,   0.3083D-03, 0.2221D-03, 0.1595D-03/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.8155D-03, 0.9380D-03, 0.1077D-02, 0.1235D-02, 0.1415D-02,
     ,   0.1617D-02, 0.1846D-02, 0.2102D-02, 0.2390D-02, 0.2711D-02,
     ,   0.3069D-02, 0.3465D-02, 0.3903D-02, 0.4383D-02, 0.4908D-02,
     ,   0.5478D-02, 0.6093D-02, 0.6750D-02, 0.7448D-02, 0.8180D-02,
     ,   0.8940D-02, 0.9717D-02, 0.1050D-01, 0.1127D-01, 0.1201D-01,
     ,   0.1270D-01, 0.1331D-01, 0.1382D-01, 0.1421D-01, 0.1443D-01,
     ,   0.1445D-01, 0.1420D-01, 0.1357D-01, 0.1241D-01, 0.1060D-01,
     ,   0.8077D-02, 0.5000D-02, 0.1705D-02,-0.1404D-02,-0.4040D-02,
     ,  -0.6089D-02,-0.7565D-02,-0.8521D-02,-0.9004D-02,-0.9054D-02,
     ,  -0.8709D-02,-0.8009D-02,-0.6999D-02,-0.5725D-02,-0.4225D-02,
     ,  -0.2525D-02,-0.6224D-03, 0.1486D-02, 0.3719D-02, 0.5825D-02,
     ,   0.7431D-02, 0.8250D-02, 0.8244D-02, 0.7599D-02, 0.6591D-02,
     ,   0.5463D-02, 0.4379D-02, 0.3422D-02, 0.2623D-02, 0.1981D-02,
     ,   0.1479D-02, 0.1095D-02, 0.8038D-03, 0.5867D-03, 0.4261D-03,
     ,   0.3081D-03, 0.2220D-03, 0.1594D-03/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.7547D-03, 0.8683D-03, 0.9976D-03, 0.1144D-02, 0.1311D-02,
     ,   0.1499D-02, 0.1712D-02, 0.1951D-02, 0.2219D-02, 0.2518D-02,
     ,   0.2852D-02, 0.3222D-02, 0.3631D-02, 0.4081D-02, 0.4573D-02,
     ,   0.5108D-02, 0.5685D-02, 0.6305D-02, 0.6964D-02, 0.7657D-02,
     ,   0.8378D-02, 0.9119D-02, 0.9867D-02, 0.1061D-01, 0.1132D-01,
     ,   0.1200D-01, 0.1260D-01, 0.1312D-01, 0.1352D-01, 0.1378D-01,
     ,   0.1385D-01, 0.1367D-01, 0.1314D-01, 0.1214D-01, 0.1053D-01,
     ,   0.8235D-02, 0.5367D-02, 0.2232D-02,-0.7805D-03,-0.3368D-02,
     ,  -0.5402D-02,-0.6888D-02,-0.7876D-02,-0.8415D-02,-0.8542D-02,
     ,  -0.8290D-02,-0.7697D-02,-0.6805D-02,-0.5655D-02,-0.4286D-02,
     ,  -0.2726D-02,-0.9780D-03, 0.9660D-03, 0.3055D-02, 0.5084D-02,
     ,   0.6714D-02, 0.7644D-02, 0.7787D-02, 0.7285D-02, 0.6390D-02,
     ,   0.5342D-02, 0.4308D-02, 0.3382D-02, 0.2602D-02, 0.1970D-02,
     ,   0.1473D-02, 0.1091D-02, 0.8022D-03, 0.5859D-03, 0.4257D-03,
     ,   0.3079D-03, 0.2219D-03, 0.1594D-03/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.6811D-03, 0.7839D-03, 0.9010D-03, 0.1034D-02, 0.1185D-02,
     ,   0.1356D-02, 0.1549D-02, 0.1766D-02, 0.2010D-02, 0.2283D-02,
     ,   0.2587D-02, 0.2926D-02, 0.3300D-02, 0.3711D-02, 0.4163D-02,
     ,   0.4655D-02, 0.5187D-02, 0.5759D-02, 0.6369D-02, 0.7013D-02,
     ,   0.7685D-02, 0.8379D-02, 0.9084D-02, 0.9786D-02, 0.1047D-01,
     ,   0.1112D-01, 0.1172D-01, 0.1224D-01, 0.1265D-01, 0.1294D-01,
     ,   0.1306D-01, 0.1297D-01, 0.1258D-01, 0.1176D-01, 0.1038D-01,
     ,   0.8365D-02, 0.5767D-02, 0.2846D-02,-0.2998D-04,-0.2547D-02,
     ,  -0.4555D-02,-0.6045D-02,-0.7065D-02,-0.7666D-02,-0.7881D-02,
     ,  -0.7740D-02,-0.7276D-02,-0.6526D-02,-0.5528D-02,-0.4319D-02,
     ,  -0.2929D-02,-0.1368D-02, 0.3740D-03, 0.2272D-02, 0.4181D-02,
     ,   0.5810D-02, 0.6855D-02, 0.7176D-02, 0.6855D-02, 0.6110D-02,
     ,   0.5170D-02, 0.4208D-02, 0.3325D-02, 0.2570D-02, 0.1953D-02,
     ,   0.1465D-02, 0.1087D-02, 0.7999D-03, 0.5847D-03, 0.4251D-03,
     ,   0.3076D-03, 0.2218D-03, 0.1593D-03/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.5970D-03, 0.6875D-03, 0.7906D-03, 0.9080D-03, 0.1041D-02,
     ,   0.1192D-02, 0.1363D-02, 0.1555D-02, 0.1771D-02, 0.2013D-02,
     ,   0.2283D-02, 0.2584D-02, 0.2917D-02, 0.3285D-02, 0.3689D-02,
     ,   0.4130D-02, 0.4609D-02, 0.5125D-02, 0.5676D-02, 0.6262D-02,
     ,   0.6875D-02, 0.7512D-02, 0.8163D-02, 0.8817D-02, 0.9461D-02,
     ,   0.1008D-01, 0.1066D-01, 0.1117D-01, 0.1160D-01, 0.1192D-01,
     ,   0.1210D-01, 0.1210D-01, 0.1184D-01, 0.1122D-01, 0.1011D-01,
     ,   0.8419D-02, 0.6150D-02, 0.3504D-02, 0.8135D-03,-0.1602D-02,
     ,  -0.3566D-02,-0.5049D-02,-0.6096D-02,-0.6757D-02,-0.7065D-02,
     ,  -0.7047D-02,-0.6728D-02,-0.6140D-02,-0.5317D-02,-0.4294D-02,
     ,  -0.3100D-02,-0.1751D-02,-0.2424D-03, 0.1422D-02, 0.3156D-02,
     ,   0.4737D-02, 0.5877D-02, 0.6390D-02, 0.6286D-02, 0.5730D-02,
     ,   0.4932D-02, 0.4066D-02, 0.3244D-02, 0.2525D-02, 0.1929D-02,
     ,   0.1452D-02, 0.1080D-02, 0.7964D-03, 0.5830D-03, 0.4242D-03,
     ,   0.3072D-03, 0.2215D-03, 0.1592D-03/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.5070D-03, 0.5842D-03, 0.6723D-03, 0.7727D-03, 0.8867D-03,
     ,   0.1016D-02, 0.1162D-02, 0.1327D-02, 0.1513D-02, 0.1722D-02,
     ,   0.1955D-02, 0.2215D-02, 0.2504D-02, 0.2823D-02, 0.3174D-02,
     ,   0.3559D-02, 0.3978D-02, 0.4431D-02, 0.4918D-02, 0.5437D-02,
     ,   0.5983D-02, 0.6554D-02, 0.7141D-02, 0.7738D-02, 0.8331D-02,
     ,   0.8910D-02, 0.9458D-02, 0.9958D-02, 0.1039D-01, 0.1074D-01,
     ,   0.1097D-01, 0.1106D-01, 0.1093D-01, 0.1051D-01, 0.9685D-02,
     ,   0.8337D-02, 0.6445D-02, 0.4134D-02, 0.1685D-02,-0.5906D-03,
     ,  -0.2486D-02,-0.3946D-02,-0.5006D-02,-0.5716D-02,-0.6113D-02,
     ,  -0.6218D-02,-0.6050D-02,-0.5635D-02,-0.5001D-02,-0.4179D-02,
     ,  -0.3196D-02,-0.2074D-02,-0.8162D-03, 0.5841D-03, 0.2090D-02,
     ,   0.3556D-02, 0.4740D-02, 0.5430D-02, 0.5561D-02, 0.5230D-02,
     ,   0.4611D-02, 0.3870D-02, 0.3131D-02, 0.2462D-02, 0.1894D-02,
     ,   0.1433D-02, 0.1070D-02, 0.7914D-03, 0.5804D-03, 0.4229D-03,
     ,   0.3065D-03, 0.2212D-03, 0.1591D-03/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.4170D-03, 0.4809D-03, 0.5538D-03, 0.6369D-03, 0.7316D-03,
     ,   0.8390D-03, 0.9607D-03, 0.1098D-02, 0.1253D-02, 0.1428D-02,
     ,   0.1623D-02, 0.1841D-02, 0.2084D-02, 0.2354D-02, 0.2651D-02,
     ,   0.2977D-02, 0.3334D-02, 0.3721D-02, 0.4139D-02, 0.4586D-02,
     ,   0.5061D-02, 0.5560D-02, 0.6077D-02, 0.6607D-02, 0.7142D-02,
     ,   0.7670D-02, 0.8179D-02, 0.8657D-02, 0.9086D-02, 0.9450D-02,
     ,   0.9726D-02, 0.9884D-02, 0.9880D-02, 0.9643D-02, 0.9077D-02,
     ,   0.8075D-02, 0.6579D-02, 0.4649D-02, 0.2496D-02, 0.4070D-03,
     ,  -0.1391D-02,-0.2808D-02,-0.3861D-02,-0.4601D-02,-0.5069D-02,
     ,  -0.5284D-02,-0.5260D-02,-0.5014D-02,-0.4569D-02,-0.3950D-02,
     ,  -0.3183D-02,-0.2289D-02,-0.1279D-02,-0.1505D-03, 0.1091D-02,
     ,   0.2373D-02, 0.3523D-02, 0.4336D-02, 0.4689D-02, 0.4600D-02,
     ,   0.4190D-02, 0.3607D-02, 0.2974D-02, 0.2372D-02, 0.1845D-02,
     ,   0.1407D-02, 0.1056D-02, 0.7842D-03, 0.5767D-03, 0.4210D-03,
     ,   0.3056D-03, 0.2207D-03, 0.1588D-03/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.3327D-03, 0.3840D-03, 0.4426D-03, 0.5095D-03, 0.5858D-03,
     ,   0.6725D-03, 0.7709D-03, 0.8823D-03, 0.1008D-02, 0.1150D-02,
     ,   0.1309D-02, 0.1487D-02, 0.1686D-02, 0.1907D-02, 0.2151D-02,
     ,   0.2421D-02, 0.2716D-02, 0.3038D-02, 0.3388D-02, 0.3764D-02,
     ,   0.4165D-02, 0.4590D-02, 0.5034D-02, 0.5494D-02, 0.5963D-02,
     ,   0.6433D-02, 0.6895D-02, 0.7339D-02, 0.7750D-02, 0.8116D-02,
     ,   0.8418D-02, 0.8633D-02, 0.8726D-02, 0.8642D-02, 0.8305D-02,
     ,   0.7617D-02, 0.6504D-02, 0.4973D-02, 0.3159D-02, 0.1302D-02,
     ,  -0.3659D-03,-0.1717D-02,-0.2742D-02,-0.3489D-02,-0.4000D-02,
     ,  -0.4299D-02,-0.4397D-02,-0.4303D-02,-0.4033D-02,-0.3606D-02,
     ,  -0.3042D-02,-0.2364D-02,-0.1586D-02,-0.7115D-03, 0.2624D-03,
     ,   0.1312D-02, 0.2341D-02, 0.3190D-02, 0.3710D-02, 0.3851D-02,
     ,   0.3665D-02, 0.3265D-02, 0.2764D-02, 0.2249D-02, 0.1775D-02,
     ,   0.1369D-02, 0.1036D-02, 0.7737D-03, 0.5713D-03, 0.4183D-03,
     ,   0.3042D-03, 0.2201D-03, 0.1585D-03/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.2585D-03, 0.2986D-03, 0.3444D-03, 0.3969D-03, 0.4568D-03,
     ,   0.5249D-03, 0.6024D-03, 0.6903D-03, 0.7897D-03, 0.9019D-03,
     ,   0.1028D-02, 0.1170D-02, 0.1328D-02, 0.1505D-02, 0.1701D-02,
     ,   0.1918D-02, 0.2157D-02, 0.2419D-02, 0.2704D-02, 0.3012D-02,
     ,   0.3343D-02, 0.3696D-02, 0.4069D-02, 0.4458D-02, 0.4859D-02,
     ,   0.5268D-02, 0.5676D-02, 0.6076D-02, 0.6458D-02, 0.6811D-02,
     ,   0.7121D-02, 0.7371D-02, 0.7533D-02, 0.7567D-02, 0.7411D-02,
     ,   0.6985D-02, 0.6213D-02, 0.5064D-02, 0.3608D-02, 0.2021D-02,
     ,   0.5172D-03,-0.7473D-03,-0.1727D-02,-0.2456D-02,-0.2980D-02,
     ,  -0.3331D-02,-0.3518D-02,-0.3547D-02,-0.3425D-02,-0.3165D-02,
     ,  -0.2783D-02,-0.2298D-02,-0.1723D-02,-0.1070D-02,-0.3383D-03,
     ,   0.4702D-03, 0.1318D-02, 0.2107D-02, 0.2706D-02, 0.3023D-02,
     ,   0.3048D-02, 0.2841D-02, 0.2492D-02, 0.2085D-02, 0.1681D-02,
     ,   0.1316D-02, 0.1008D-02, 0.7587D-03, 0.5635D-03, 0.4143D-03,
     ,   0.3022D-03, 0.2190D-03, 0.1580D-03/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1963D-03, 0.2270D-03, 0.2621D-03, 0.3024D-03, 0.3483D-03,
     ,   0.4008D-03, 0.4605D-03, 0.5283D-03, 0.6052D-03, 0.6921D-03,
     ,   0.7902D-03, 0.9005D-03, 0.1024D-02, 0.1163D-02, 0.1317D-02,
     ,   0.1488D-02, 0.1677D-02, 0.1884D-02, 0.2112D-02, 0.2359D-02,
     ,   0.2627D-02, 0.2913D-02, 0.3219D-02, 0.3541D-02, 0.3876D-02,
     ,   0.4222D-02, 0.4574D-02, 0.4925D-02, 0.5269D-02, 0.5597D-02,
     ,   0.5899D-02, 0.6161D-02, 0.6365D-02, 0.6479D-02, 0.6456D-02,
     ,   0.6233D-02, 0.5739D-02, 0.4927D-02, 0.3817D-02, 0.2520D-02,
     ,   0.1212D-02, 0.5519D-04,-0.8676D-03,-0.1562D-02,-0.2075D-02,
     ,  -0.2443D-02,-0.2683D-02,-0.2798D-02,-0.2790D-02,-0.2666D-02,
     ,  -0.2435D-02,-0.2112D-02,-0.1709D-02,-0.1240D-02,-0.7081D-03,
     ,  -0.1141D-03, 0.5338D-03, 0.1193D-02, 0.1776D-02, 0.2189D-02,
     ,   0.2377D-02, 0.2349D-02, 0.2159D-02, 0.1874D-02, 0.1554D-02,
     ,   0.1244D-02, 0.9681D-03, 0.7374D-03, 0.5524D-03, 0.4086D-03,
     ,   0.2993D-03, 0.2176D-03, 0.1572D-03/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.1465D-03, 0.1695D-03, 0.1960D-03, 0.2263D-03, 0.2609D-03,
     ,   0.3006D-03, 0.3457D-03, 0.3972D-03, 0.4556D-03, 0.5218D-03,
     ,   0.5966D-03, 0.6810D-03, 0.7759D-03, 0.8822D-03, 0.1001D-02,
     ,   0.1133D-02, 0.1280D-02, 0.1442D-02, 0.1621D-02, 0.1815D-02,
     ,   0.2027D-02, 0.2256D-02, 0.2501D-02, 0.2762D-02, 0.3037D-02,
     ,   0.3324D-02, 0.3619D-02, 0.3919D-02, 0.4219D-02, 0.4514D-02,
     ,   0.4794D-02, 0.5052D-02, 0.5273D-02, 0.5434D-02, 0.5500D-02,
     ,   0.5422D-02, 0.5141D-02, 0.4605D-02, 0.3803D-02, 0.2793D-02,
     ,   0.1701D-02, 0.6733D-03,-0.1821D-03,-0.8375D-03,-0.1323D-02,
     ,  -0.1683D-02,-0.1942D-02,-0.2106D-02,-0.2176D-02,-0.2151D-02,
     ,  -0.2038D-02,-0.1844D-02,-0.1581D-02,-0.1258D-02,-0.8840D-03,
     ,  -0.4621D-03, 0.6926D-05, 0.5107D-03, 0.1008D-02, 0.1429D-02,
     ,   0.1710D-02, 0.1821D-02, 0.1776D-02, 0.1617D-02, 0.1393D-02,
     ,   0.1148D-02, 0.9137D-03, 0.7076D-03, 0.5366D-03, 0.4004D-03,
     ,   0.2951D-03, 0.2155D-03, 0.1562D-03/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.1078D-03, 0.1249D-03, 0.1445D-03, 0.1670D-03, 0.1928D-03,
     ,   0.2223D-03, 0.2560D-03, 0.2945D-03, 0.3383D-03, 0.3879D-03,
     ,   0.4442D-03, 0.5079D-03, 0.5796D-03, 0.6602D-03, 0.7506D-03,
     ,   0.8516D-03, 0.9640D-03, 0.1089D-02, 0.1226D-02, 0.1377D-02,
     ,   0.1543D-02, 0.1722D-02, 0.1916D-02, 0.2124D-02, 0.2345D-02,
     ,   0.2578D-02, 0.2821D-02, 0.3071D-02, 0.3326D-02, 0.3582D-02,
     ,   0.3834D-02, 0.4074D-02, 0.4293D-02, 0.4475D-02, 0.4593D-02,
     ,   0.4611D-02, 0.4481D-02, 0.4155D-02, 0.3609D-02, 0.2862D-02,
     ,   0.1991D-02, 0.1112D-02, 0.3360D-03,-0.2784D-03,-0.7353D-03,
     ,  -0.1073D-02,-0.1325D-02,-0.1507D-02,-0.1620D-02,-0.1662D-02,
     ,  -0.1633D-02,-0.1536D-02,-0.1379D-02,-0.1171D-02,-0.9180D-03,
     ,  -0.6268D-03,-0.2991D-03, 0.6275D-04, 0.4450D-03, 0.8120D-03,
     ,   0.1112D-02, 0.1303D-02, 0.1369D-02, 0.1323D-02, 0.1197D-02,
     ,   0.1026D-02, 0.8417D-03, 0.6671D-03, 0.5146D-03, 0.3887D-03,
     ,   0.2891D-03, 0.2124D-03, 0.1546D-03/
      data (calcpts(j,30), j = 1,neta) /
     ,   0.7850D-04, 0.9101D-04, 0.1054D-03, 0.1220D-03, 0.1410D-03,
     ,   0.1627D-03, 0.1876D-03, 0.2161D-03, 0.2485D-03, 0.2854D-03,
     ,   0.3273D-03, 0.3748D-03, 0.4284D-03, 0.4888D-03, 0.5568D-03,
     ,   0.6329D-03, 0.7179D-03, 0.8126D-03, 0.9175D-03, 0.1033D-02,
     ,   0.1160D-02, 0.1299D-02, 0.1451D-02, 0.1614D-02, 0.1789D-02,
     ,   0.1975D-02, 0.2171D-02, 0.2376D-02, 0.2588D-02, 0.2805D-02,
     ,   0.3023D-02, 0.3238D-02, 0.3442D-02, 0.3625D-02, 0.3769D-02,
     ,   0.3844D-02, 0.3814D-02, 0.3639D-02, 0.3290D-02, 0.2766D-02,
     ,   0.2105D-02, 0.1386D-02, 0.7059D-03, 0.1371D-03,-0.2948D-03,
     ,  -0.6096D-03,-0.8431D-03,-0.1020D-02,-0.1149D-02,-0.1227D-02,
     ,  -0.1252D-02,-0.1223D-02,-0.1145D-02,-0.1021D-02,-0.8599D-03,
     ,  -0.6658D-03,-0.4429D-03,-0.1929D-03, 0.8099D-04, 0.3656D-03,
     ,   0.6324D-03, 0.8446D-03, 0.9745D-03, 0.1014D-02, 0.9750D-03,
     ,   0.8784D-03, 0.7503D-03, 0.6135D-03, 0.4846D-03, 0.3725D-03,
     ,   0.2805D-03, 0.2080D-03, 0.1524D-03/
      data (calcpts(j,31), j = 1,neta) /
     ,   0.5673D-04, 0.6583D-04, 0.7631D-04, 0.8839D-04, 0.1023D-03,
     ,   0.1182D-03, 0.1364D-03, 0.1573D-03, 0.1811D-03, 0.2083D-03,
     ,   0.2392D-03, 0.2743D-03, 0.3141D-03, 0.3590D-03, 0.4096D-03,
     ,   0.4665D-03, 0.5302D-03, 0.6014D-03, 0.6806D-03, 0.7684D-03,
     ,   0.8653D-03, 0.9718D-03, 0.1088D-02, 0.1215D-02, 0.1351D-02,
     ,   0.1498D-02, 0.1654D-02, 0.1819D-02, 0.1992D-02, 0.2171D-02,
     ,   0.2355D-02, 0.2541D-02, 0.2724D-02, 0.2896D-02, 0.3044D-02,
     ,   0.3149D-02, 0.3180D-02, 0.3108D-02, 0.2902D-02, 0.2554D-02,
     ,   0.2077D-02, 0.1518D-02, 0.9474D-03, 0.4357D-03, 0.2780D-04,
     ,  -0.2713D-03,-0.4866D-03,-0.6480D-03,-0.7726D-03,-0.8637D-03,
     ,  -0.9179D-03,-0.9325D-03,-0.9074D-03,-0.8453D-03,-0.7505D-03,
     ,  -0.6275D-03,-0.4806D-03,-0.3123D-03,-0.1244D-03, 0.7978D-04,
     ,   0.2887D-03, 0.4806D-03, 0.6300D-03, 0.7192D-03, 0.7442D-03,
     ,   0.7127D-03, 0.6404D-03, 0.5456D-03, 0.4450D-03, 0.3505D-03,
     ,   0.2687D-03, 0.2018D-03, 0.1492D-03/
      data (calcpts(j,32), j = 1,neta) /
     ,   0.4076D-04, 0.4734D-04, 0.5493D-04, 0.6368D-04, 0.7375D-04,
     ,   0.8532D-04, 0.9860D-04, 0.1138D-03, 0.1312D-03, 0.1511D-03,
     ,   0.1738D-03, 0.1995D-03, 0.2288D-03, 0.2620D-03, 0.2994D-03,
     ,   0.3416D-03, 0.3890D-03, 0.4422D-03, 0.5015D-03, 0.5675D-03,
     ,   0.6407D-03, 0.7215D-03, 0.8103D-03, 0.9073D-03, 0.1013D-02,
     ,   0.1127D-02, 0.1249D-02, 0.1380D-02, 0.1519D-02, 0.1665D-02,
     ,   0.1817D-02, 0.1973D-02, 0.2131D-02, 0.2285D-02, 0.2426D-02,
     ,   0.2540D-02, 0.2605D-02, 0.2597D-02, 0.2490D-02, 0.2273D-02,
     ,   0.1945D-02, 0.1532D-02, 0.1077D-02, 0.6374D-03, 0.2610D-03,
     ,  -0.2672D-04,-0.2317D-03,-0.3782D-03,-0.4898D-03,-0.5777D-03,
     ,  -0.6422D-03,-0.6800D-03,-0.6884D-03,-0.6677D-03,-0.6197D-03,
     ,  -0.5479D-03,-0.4555D-03,-0.3455D-03,-0.2200D-03,-0.8040D-04,
     ,   0.6998D-04, 0.2218D-03, 0.3589D-03, 0.4639D-03, 0.5256D-03,
     ,   0.5417D-03, 0.5177D-03, 0.4644D-03, 0.3949D-03, 0.3214D-03,
     ,   0.2525D-03, 0.1931D-03, 0.1447D-03/
      data (calcpts(j,33), j = 1,neta) /
     ,   0.2916D-04, 0.3390D-04, 0.3937D-04, 0.4568D-04, 0.5296D-04,
     ,   0.6133D-04, 0.7095D-04, 0.8200D-04, 0.9465D-04, 0.1091D-03,
     ,   0.1256D-03, 0.1445D-03, 0.1659D-03, 0.1902D-03, 0.2178D-03,
     ,   0.2489D-03, 0.2840D-03, 0.3234D-03, 0.3676D-03, 0.4169D-03,
     ,   0.4718D-03, 0.5326D-03, 0.5998D-03, 0.6736D-03, 0.7544D-03,
     ,   0.8423D-03, 0.9374D-03, 0.1040D-02, 0.1150D-02, 0.1266D-02,
     ,   0.1389D-02, 0.1518D-02, 0.1651D-02, 0.1784D-02, 0.1911D-02,
     ,   0.2022D-02, 0.2101D-02, 0.2130D-02, 0.2088D-02, 0.1962D-02,
     ,   0.1749D-02, 0.1457D-02, 0.1114D-02, 0.7550D-03, 0.4233D-03,
     ,   0.1512D-03,-0.4947D-04,-0.1889D-03,-0.2884D-03,-0.3657D-03,
     ,  -0.4277D-03,-0.4734D-03,-0.4998D-03,-0.5046D-03,-0.4881D-03,
     ,  -0.4517D-03,-0.3979D-03,-0.3292D-03,-0.2477D-03,-0.1549D-03,
     ,  -0.5218D-04, 0.5758D-04, 0.1670D-03, 0.2645D-03, 0.3383D-03,
     ,   0.3812D-03, 0.3919D-03, 0.3741D-03, 0.3353D-03, 0.2847D-03,
     ,   0.2313D-03, 0.1814D-03, 0.1385D-03/
      data (calcpts(j,34), j = 1,neta) /
     ,   0.2080D-04, 0.2419D-04, 0.2812D-04, 0.3266D-04, 0.3790D-04,
     ,   0.4394D-04, 0.5088D-04, 0.5887D-04, 0.6803D-04, 0.7852D-04,
     ,   0.9053D-04, 0.1042D-03, 0.1199D-03, 0.1376D-03, 0.1578D-03,
     ,   0.1807D-03, 0.2065D-03, 0.2356D-03, 0.2683D-03, 0.3049D-03,
     ,   0.3458D-03, 0.3913D-03, 0.4418D-03, 0.4976D-03, 0.5589D-03,
     ,   0.6261D-03, 0.6993D-03, 0.7786D-03, 0.8643D-03, 0.9563D-03,
     ,   0.1055D-02, 0.1159D-02, 0.1268D-02, 0.1380D-02, 0.1490D-02,
     ,   0.1591D-02, 0.1673D-02, 0.1720D-02, 0.1717D-02, 0.1653D-02,
     ,   0.1521D-02, 0.1324D-02, 0.1077D-02, 0.8000D-03, 0.5239D-03,
     ,   0.2782D-03, 0.8379D-04,-0.5493D-04,-0.1493D-03,-0.2169D-03,
     ,  -0.2704D-03,-0.3141D-03,-0.3466D-03,-0.3650D-03,-0.3677D-03,
     ,  -0.3548D-03,-0.3276D-03,-0.2877D-03,-0.2370D-03,-0.1771D-03,
     ,  -0.1091D-03,-0.3402D-04, 0.4552D-04, 0.1240D-03, 0.1930D-03,
     ,   0.2449D-03, 0.2749D-03, 0.2822D-03, 0.2693D-03, 0.2411D-03,
     ,   0.2046D-03, 0.1660D-03, 0.1299D-03/
      data (calcpts(j,35), j = 1,neta) /
     ,   0.1480D-04, 0.1723D-04, 0.2004D-04, 0.2330D-04, 0.2706D-04,
     ,   0.3140D-04, 0.3639D-04, 0.4215D-04, 0.4876D-04, 0.5635D-04,
     ,   0.6504D-04, 0.7498D-04, 0.8633D-04, 0.9928D-04, 0.1140D-03,
     ,   0.1307D-03, 0.1496D-03, 0.1710D-03, 0.1951D-03, 0.2222D-03,
     ,   0.2525D-03, 0.2864D-03, 0.3242D-03, 0.3660D-03, 0.4123D-03,
     ,   0.4632D-03, 0.5190D-03, 0.5800D-03, 0.6463D-03, 0.7181D-03,
     ,   0.7955D-03, 0.8785D-03, 0.9666D-03, 0.1058D-02, 0.1151D-02,
     ,   0.1240D-02, 0.1316D-02, 0.1370D-02, 0.1389D-02, 0.1363D-02,
     ,   0.1287D-02, 0.1161D-02, 0.9896D-03, 0.7864D-03, 0.5695D-03,
     ,   0.3608D-03, 0.1812D-03, 0.4358D-04,-0.5178D-04,-0.1155D-03,
     ,  -0.1613D-03,-0.1984D-03,-0.2292D-03,-0.2523D-03,-0.2652D-03,
     ,  -0.2666D-03,-0.2568D-03,-0.2366D-03,-0.2072D-03,-0.1701D-03,
     ,  -0.1263D-03,-0.7674D-04,-0.2229D-04, 0.3503D-04, 0.9103D-04,
     ,   0.1399D-03, 0.1763D-03, 0.1973D-03, 0.2024D-03, 0.1931D-03,
     ,   0.1729D-03, 0.1466D-03, 0.1188D-03/
      data (calcpts(j,36), j = 1,neta) /
     ,   0.1051D-04, 0.1224D-04, 0.1425D-04, 0.1658D-04, 0.1928D-04,
     ,   0.2239D-04, 0.2598D-04, 0.3011D-04, 0.3487D-04, 0.4034D-04,
     ,   0.4662D-04, 0.5381D-04, 0.6204D-04, 0.7143D-04, 0.8214D-04,
     ,   0.9431D-04, 0.1081D-03, 0.1238D-03, 0.1415D-03, 0.1614D-03,
     ,   0.1838D-03, 0.2090D-03, 0.2370D-03, 0.2683D-03, 0.3030D-03,
     ,   0.3413D-03, 0.3836D-03, 0.4301D-03, 0.4810D-03, 0.5365D-03,
     ,   0.5968D-03, 0.6621D-03, 0.7322D-03, 0.8064D-03, 0.8827D-03,
     ,   0.9577D-03, 0.1026D-02, 0.1078D-02, 0.1108D-02, 0.1105D-02,
     ,   0.1066D-02, 0.9881D-03, 0.8743D-03, 0.7311D-03, 0.5692D-03,
     ,   0.4025D-03, 0.2471D-03, 0.1171D-03, 0.2031D-04,-0.4497D-04,
     ,  -0.8785D-04,-0.1189D-03,-0.1446D-03,-0.1664D-03,-0.1828D-03,
     ,  -0.1918D-03,-0.1926D-03,-0.1852D-03,-0.1702D-03,-0.1488D-03,
     ,  -0.1217D-03,-0.8991D-04,-0.5398D-04,-0.1466D-04, 0.2646D-04,
     ,   0.6631D-04, 0.1008D-03, 0.1264D-03, 0.1412D-03, 0.1448D-03,
     ,   0.1381D-03, 0.1236D-03, 0.1047D-03/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.7449D-05, 0.8686D-05, 0.1012D-04, 0.1178D-04, 0.1371D-04,
     ,   0.1594D-04, 0.1851D-04, 0.2148D-04, 0.2490D-04, 0.2883D-04,
     ,   0.3335D-04, 0.3854D-04, 0.4449D-04, 0.5129D-04, 0.5905D-04,
     ,   0.6791D-04, 0.7797D-04, 0.8940D-04, 0.1023D-03, 0.1170D-03,
     ,   0.1335D-03, 0.1520D-03, 0.1728D-03, 0.1960D-03, 0.2219D-03,
     ,   0.2507D-03, 0.2825D-03, 0.3177D-03, 0.3564D-03, 0.3990D-03,
     ,   0.4456D-03, 0.4964D-03, 0.5515D-03, 0.6105D-03, 0.6722D-03,
     ,   0.7341D-03, 0.7921D-03, 0.8405D-03, 0.8728D-03, 0.8829D-03,
     ,   0.8664D-03, 0.8214D-03, 0.7485D-03, 0.6512D-03, 0.5352D-03,
     ,   0.4090D-03, 0.2830D-03, 0.1686D-03, 0.7518D-04, 0.7379D-05,
     ,  -0.3719D-04,-0.6601D-04,-0.8707D-04,-0.1049D-03,-0.1203D-03,
     ,  -0.1319D-03,-0.1382D-03,-0.1386D-03,-0.1330D-03,-0.1221D-03,
     ,  -0.1065D-03,-0.8690D-04,-0.6389D-04,-0.3796D-04,-0.9684D-05,
     ,   0.1972D-04, 0.4800D-04, 0.7229D-04, 0.9027D-04, 0.1007D-03,
     ,   0.1032D-03, 0.9852D-04, 0.8819D-04/
      data (calcpts(j,38), j = 1,neta) /
     ,   0.5275D-05, 0.6156D-05, 0.7178D-05, 0.8364D-05, 0.9738D-05,
     ,   0.1133D-04, 0.1317D-04, 0.1529D-04, 0.1775D-04, 0.2057D-04,
     ,   0.2382D-04, 0.2756D-04, 0.3185D-04, 0.3676D-04, 0.4238D-04,
     ,   0.4880D-04, 0.5611D-04, 0.6443D-04, 0.7388D-04, 0.8458D-04,
     ,   0.9667D-04, 0.1103D-03, 0.1256D-03, 0.1428D-03, 0.1621D-03,
     ,   0.1835D-03, 0.2074D-03, 0.2338D-03, 0.2631D-03, 0.2955D-03,
     ,   0.3312D-03, 0.3704D-03, 0.4133D-03, 0.4596D-03, 0.5087D-03,
     ,   0.5588D-03, 0.6071D-03, 0.6493D-03, 0.6807D-03, 0.6966D-03,
     ,   0.6936D-03, 0.6696D-03, 0.6248D-03, 0.5606D-03, 0.4804D-03,
     ,   0.3889D-03, 0.2923D-03, 0.1982D-03, 0.1146D-03, 0.4791D-04,
     ,   0.6014D-06,-0.2976D-04,-0.4912D-04,-0.6340D-04,-0.7581D-04,
     ,  -0.8665D-04,-0.9484D-04,-0.9926D-04,-0.9941D-04,-0.9532D-04,
     ,  -0.8737D-04,-0.7606D-04,-0.6190D-04,-0.4532D-04,-0.2668D-04,
     ,  -0.6415D-05, 0.1455D-04, 0.3457D-04, 0.5167D-04, 0.6430D-04,
     ,   0.7164D-04, 0.7346D-04, 0.7012D-04/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.3731D-05, 0.4357D-05, 0.5085D-05, 0.5929D-05, 0.6909D-05,
     ,   0.8044D-05, 0.9359D-05, 0.1088D-04, 0.1263D-04, 0.1466D-04,
     ,   0.1699D-04, 0.1968D-04, 0.2277D-04, 0.2631D-04, 0.3037D-04,
     ,   0.3501D-04, 0.4031D-04, 0.4635D-04, 0.5323D-04, 0.6103D-04,
     ,   0.6987D-04, 0.7986D-04, 0.9113D-04, 0.1038D-03, 0.1180D-03,
     ,   0.1340D-03, 0.1518D-03, 0.1716D-03, 0.1936D-03, 0.2181D-03,
     ,   0.2452D-03, 0.2753D-03, 0.3083D-03, 0.3443D-03, 0.3829D-03,
     ,   0.4229D-03, 0.4621D-03, 0.4978D-03, 0.5262D-03, 0.5439D-03,
     ,   0.5481D-03, 0.5372D-03, 0.5109D-03, 0.4699D-03, 0.4159D-03,
     ,   0.3517D-03, 0.2809D-03, 0.2080D-03, 0.1384D-03, 0.7778D-04,
     ,   0.3032D-04,-0.2614D-05,-0.2327D-04,-0.3626D-04,-0.4595D-04,
     ,  -0.5457D-04,-0.6221D-04,-0.6799D-04,-0.7109D-04,-0.7112D-04,
     ,  -0.6812D-04,-0.6236D-04,-0.5420D-04,-0.4401D-04,-0.3210D-04,
     ,  -0.1874D-04,-0.4260D-05, 0.1065D-04, 0.2480D-04, 0.3683D-04,
     ,   0.4569D-04, 0.5086D-04, 0.5216D-04/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.2637D-05, 0.3082D-05, 0.3599D-05, 0.4199D-05, 0.4897D-05,
     ,   0.5706D-05, 0.6643D-05, 0.7729D-05, 0.8984D-05, 0.1043D-04,
     ,   0.1211D-04, 0.1403D-04, 0.1625D-04, 0.1880D-04, 0.2173D-04,
     ,   0.2508D-04, 0.2891D-04, 0.3329D-04, 0.3828D-04, 0.4396D-04,
     ,   0.5041D-04, 0.5771D-04, 0.6597D-04, 0.7529D-04, 0.8578D-04,
     ,   0.9756D-04, 0.1108D-03, 0.1255D-03, 0.1420D-03, 0.1604D-03,
     ,   0.1810D-03, 0.2038D-03, 0.2290D-03, 0.2568D-03, 0.2868D-03,
     ,   0.3182D-03, 0.3497D-03, 0.3790D-03, 0.4036D-03, 0.4208D-03,
     ,   0.4284D-03, 0.4253D-03, 0.4108D-03, 0.3854D-03, 0.3500D-03,
     ,   0.3061D-03, 0.2559D-03, 0.2019D-03, 0.1475D-03, 0.9645D-04,
     ,   0.5269D-04, 0.1904D-04,-0.3843D-05,-0.1788D-04,-0.2660D-04,
     ,  -0.3317D-04,-0.3915D-04,-0.4454D-04,-0.4862D-04,-0.5079D-04,
     ,  -0.5076D-04,-0.4857D-04,-0.4441D-04,-0.3854D-04,-0.3123D-04,
     ,  -0.2270D-04,-0.1315D-04,-0.2834D-05, 0.7744D-05, 0.1773D-04,
     ,   0.2618D-04, 0.3240D-04, 0.3604D-04/
      data (calcpts(j,41), j = 1,neta) /
     ,   0.1862D-05, 0.2178D-05, 0.2545D-05, 0.2971D-05, 0.3467D-05,
     ,   0.4043D-05, 0.4711D-05, 0.5485D-05, 0.6382D-05, 0.7418D-05,
     ,   0.8615D-05, 0.9996D-05, 0.1159D-04, 0.1342D-04, 0.1552D-04,
     ,   0.1794D-04, 0.2071D-04, 0.2387D-04, 0.2749D-04, 0.3161D-04,
     ,   0.3630D-04, 0.4163D-04, 0.4766D-04, 0.5449D-04, 0.6220D-04,
     ,   0.7089D-04, 0.8065D-04, 0.9162D-04, 0.1039D-03, 0.1177D-03,
     ,   0.1331D-03, 0.1503D-03, 0.1695D-03, 0.1908D-03, 0.2139D-03,
     ,   0.2384D-03, 0.2632D-03, 0.2869D-03, 0.3074D-03, 0.3229D-03,
     ,   0.3318D-03, 0.3329D-03, 0.3258D-03, 0.3106D-03, 0.2879D-03,
     ,   0.2586D-03, 0.2238D-03, 0.1852D-03, 0.1445D-03, 0.1043D-03,
     ,   0.6709D-04, 0.3565D-04, 0.1186D-04,-0.4024D-05,-0.1356D-04,
     ,  -0.1940D-04,-0.2386D-04,-0.2802D-04,-0.3180D-04,-0.3469D-04,
     ,  -0.3620D-04,-0.3615D-04,-0.3456D-04,-0.3156D-04,-0.2736D-04,
     ,  -0.2213D-04,-0.1604D-04,-0.9226D-05,-0.1889D-05, 0.5605D-05,
     ,   0.1265D-04, 0.1858D-04, 0.2293D-04/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.1314D-05, 0.1538D-05, 0.1798D-05, 0.2101D-05, 0.2453D-05,
     ,   0.2863D-05, 0.3338D-05, 0.3890D-05, 0.4529D-05, 0.5269D-05,
     ,   0.6124D-05, 0.7113D-05, 0.8253D-05, 0.9567D-05, 0.1108D-04,
     ,   0.1282D-04, 0.1481D-04, 0.1710D-04, 0.1971D-04, 0.2270D-04,
     ,   0.2610D-04, 0.2998D-04, 0.3438D-04, 0.3937D-04, 0.4502D-04,
     ,   0.5140D-04, 0.5859D-04, 0.6670D-04, 0.7582D-04, 0.8608D-04,
     ,   0.9761D-04, 0.1106D-03, 0.1251D-03, 0.1412D-03, 0.1588D-03,
     ,   0.1777D-03, 0.1971D-03, 0.2159D-03, 0.2328D-03, 0.2461D-03,
     ,   0.2548D-03, 0.2580D-03, 0.2554D-03, 0.2468D-03, 0.2326D-03,
     ,   0.2133D-03, 0.1898D-03, 0.1628D-03, 0.1334D-03, 0.1031D-03,
     ,   0.7357D-04, 0.4661D-04, 0.2410D-04, 0.7311D-05,-0.3699D-05,
     ,  -0.1017D-04,-0.1409D-04,-0.1712D-04,-0.2000D-04,-0.2266D-04,
     ,  -0.2469D-04,-0.2575D-04,-0.2570D-04,-0.2454D-04,-0.2239D-04,
     ,  -0.1938D-04,-0.1565D-04,-0.1131D-04,-0.6468D-05,-0.1260D-05,
     ,   0.4040D-05, 0.8997D-05, 0.1315D-04/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.9267D-06, 0.1085D-05, 0.1269D-05, 0.1484D-05, 0.1734D-05,
     ,   0.2025D-05, 0.2363D-05, 0.2756D-05, 0.3211D-05, 0.3739D-05,
     ,   0.4350D-05, 0.5056D-05, 0.5872D-05, 0.6813D-05, 0.7898D-05,
     ,   0.9147D-05, 0.1058D-04, 0.1223D-04, 0.1411D-04, 0.1627D-04,
     ,   0.1874D-04, 0.2155D-04, 0.2475D-04, 0.2839D-04, 0.3252D-04,
     ,   0.3719D-04, 0.4248D-04, 0.4845D-04, 0.5520D-04, 0.6281D-04,
     ,   0.7139D-04, 0.8107D-04, 0.9196D-04, 0.1041D-03, 0.1175D-03,
     ,   0.1320D-03, 0.1470D-03, 0.1618D-03, 0.1753D-03, 0.1864D-03,
     ,   0.1944D-03, 0.1984D-03, 0.1982D-03, 0.1937D-03, 0.1851D-03,
     ,   0.1727D-03, 0.1570D-03, 0.1384D-03, 0.1178D-03, 0.9580D-04,
     ,   0.7341D-04, 0.5181D-04, 0.3235D-04, 0.1628D-04, 0.4455D-05,
     ,  -0.3172D-05,-0.7567D-05,-0.1019D-04,-0.1224D-04,-0.1425D-04,
     ,  -0.1612D-04,-0.1754D-04,-0.1829D-04,-0.1823D-04,-0.1740D-04,
     ,  -0.1586D-04,-0.1372D-04,-0.1106D-04,-0.7971D-05,-0.4531D-05,
     ,  -0.8407D-06, 0.2902D-05, 0.6388D-05/
      data (calcpts(j,44), j = 1,neta) /
     ,   0.6531D-06, 0.7650D-06, 0.8956D-06, 0.1048D-05, 0.1225D-05,
     ,   0.1432D-05, 0.1672D-05, 0.1951D-05, 0.2275D-05, 0.2651D-05,
     ,   0.3086D-05, 0.3591D-05, 0.4174D-05, 0.4847D-05, 0.5624D-05,
     ,   0.6520D-05, 0.7551D-05, 0.8735D-05, 0.1009D-04, 0.1165D-04,
     ,   0.1344D-04, 0.1547D-04, 0.1780D-04, 0.2044D-04, 0.2345D-04,
     ,   0.2687D-04, 0.3074D-04, 0.3513D-04, 0.4010D-04, 0.4572D-04,
     ,   0.5209D-04, 0.5929D-04, 0.6743D-04, 0.7657D-04, 0.8670D-04,
     ,   0.9769D-04, 0.1092D-03, 0.1207D-03, 0.1313D-03, 0.1404D-03,
     ,   0.1473D-03, 0.1514D-03, 0.1525D-03, 0.1505D-03, 0.1454D-03,
     ,   0.1376D-03, 0.1273D-03, 0.1148D-03, 0.1005D-03, 0.8492D-04,
     ,   0.6857D-04, 0.5213D-04, 0.3644D-04, 0.2243D-04, 0.1100D-04,
     ,   0.2675D-05,-0.2605D-05,-0.5588D-05,-0.7343D-05,-0.8739D-05,
     ,  -0.1013D-04,-0.1144D-04,-0.1244D-04,-0.1296D-04,-0.1292D-04,
     ,  -0.1232D-04,-0.1122D-04,-0.9691D-05,-0.7802D-05,-0.5611D-05,
     ,  -0.3172D-05,-0.5613D-06, 0.2078D-05/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.4600D-06, 0.5391D-06, 0.6315D-06, 0.7393D-06, 0.8649D-06,
     ,   0.1011D-05, 0.1182D-05, 0.1380D-05, 0.1610D-05, 0.1878D-05,
     ,   0.2188D-05, 0.2548D-05, 0.2964D-05, 0.3445D-05, 0.4001D-05,
     ,   0.4643D-05, 0.5382D-05, 0.6233D-05, 0.7211D-05, 0.8334D-05,
     ,   0.9620D-05, 0.1109D-04, 0.1278D-04, 0.1470D-04, 0.1688D-04,
     ,   0.1937D-04, 0.2220D-04, 0.2542D-04, 0.2907D-04, 0.3321D-04,
     ,   0.3792D-04, 0.4326D-04, 0.4931D-04, 0.5614D-04, 0.6375D-04,
     ,   0.7205D-04, 0.8081D-04, 0.8963D-04, 0.9797D-04, 0.1053D-03,
     ,   0.1110D-03, 0.1148D-03, 0.1165D-03, 0.1159D-03, 0.1131D-03,
     ,   0.1083D-03, 0.1016D-03, 0.9326D-04, 0.8353D-04, 0.7267D-04,
     ,   0.6101D-04, 0.4894D-04, 0.3694D-04, 0.2559D-04, 0.1555D-04,
     ,   0.7423D-05, 0.1577D-05,-0.2077D-05,-0.4101D-05,-0.5276D-05,
     ,  -0.6224D-05,-0.7188D-05,-0.8107D-05,-0.8813D-05,-0.9174D-05,
     ,  -0.9136D-05,-0.8706D-05,-0.7924D-05,-0.6838D-05,-0.5498D-05,
     ,  -0.3945D-05,-0.2219D-05,-0.3749D-06/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.3238D-06, 0.3797D-06, 0.4450D-06, 0.5213D-06, 0.6102D-06,
     ,   0.7140D-06, 0.8348D-06, 0.9755D-06, 0.1139D-05, 0.1329D-05,
     ,   0.1550D-05, 0.1806D-05, 0.2103D-05, 0.2447D-05, 0.2844D-05,
     ,   0.3303D-05, 0.3833D-05, 0.4443D-05, 0.5145D-05, 0.5953D-05,
     ,   0.6880D-05, 0.7942D-05, 0.9159D-05, 0.1055D-04, 0.1214D-04,
     ,   0.1395D-04, 0.1601D-04, 0.1836D-04, 0.2103D-04, 0.2407D-04,
     ,   0.2754D-04, 0.3149D-04, 0.3598D-04, 0.4106D-04, 0.4674D-04,
     ,   0.5298D-04, 0.5960D-04, 0.6634D-04, 0.7279D-04, 0.7856D-04,
     ,   0.8325D-04, 0.8658D-04, 0.8837D-04, 0.8857D-04, 0.8718D-04,
     ,   0.8430D-04, 0.8004D-04, 0.7454D-04, 0.6798D-04, 0.6051D-04,
     ,   0.5235D-04, 0.4371D-04, 0.3486D-04, 0.2613D-04, 0.1795D-04,
     ,   0.1077D-04, 0.5009D-05, 0.9066D-06,-0.1621D-05,-0.2994D-05,
     ,  -0.3780D-05,-0.4424D-05,-0.5092D-05,-0.5736D-05,-0.6232D-05,
     ,  -0.6484D-05,-0.6453D-05,-0.6146D-05,-0.5590D-05,-0.4819D-05,
     ,  -0.3870D-05,-0.2771D-05,-0.1552D-05/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.2278D-06, 0.2673D-06, 0.3134D-06, 0.3673D-06, 0.4303D-06,
     ,   0.5037D-06, 0.5893D-06, 0.6891D-06, 0.8052D-06, 0.9403D-06,
     ,   0.1097D-05, 0.1279D-05, 0.1491D-05, 0.1736D-05, 0.2020D-05,
     ,   0.2348D-05, 0.2726D-05, 0.3164D-05, 0.3668D-05, 0.4248D-05,
     ,   0.4914D-05, 0.5680D-05, 0.6558D-05, 0.7563D-05, 0.8713D-05,
     ,   0.1003D-04, 0.1153D-04, 0.1324D-04, 0.1519D-04, 0.1742D-04,
     ,   0.1996D-04, 0.2287D-04, 0.2618D-04, 0.2995D-04, 0.3418D-04,
     ,   0.3884D-04, 0.4383D-04, 0.4893D-04, 0.5389D-04, 0.5838D-04,
     ,   0.6215D-04, 0.6495D-04, 0.6667D-04, 0.6725D-04, 0.6668D-04,
     ,   0.6503D-04, 0.6237D-04, 0.5879D-04, 0.5440D-04, 0.4932D-04,
     ,   0.4368D-04, 0.3759D-04, 0.3123D-04, 0.2477D-04, 0.1846D-04,
     ,   0.1258D-04, 0.7458D-05, 0.3379D-05, 0.5032D-06,-0.1245D-05,
     ,  -0.2176D-05,-0.2702D-05,-0.3139D-05,-0.3602D-05,-0.4053D-05,
     ,  -0.4401D-05,-0.4576D-05,-0.4552D-05,-0.4333D-05,-0.3938D-05,
     ,  -0.3393D-05,-0.2721D-05,-0.1945D-05/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.1602D-06, 0.1880D-06, 0.2206D-06, 0.2587D-06, 0.3032D-06,
     ,   0.3551D-06, 0.4158D-06, 0.4864D-06, 0.5688D-06, 0.6646D-06,
     ,   0.7761D-06, 0.9057D-06, 0.1056D-05, 0.1231D-05, 0.1433D-05,
     ,   0.1667D-05, 0.1938D-05, 0.2251D-05, 0.2612D-05, 0.3028D-05,
     ,   0.3506D-05, 0.4057D-05, 0.4689D-05, 0.5415D-05, 0.6246D-05,
     ,   0.7198D-05, 0.8286D-05, 0.9530D-05, 0.1095D-04, 0.1258D-04,
     ,   0.1444D-04, 0.1658D-04, 0.1902D-04, 0.2180D-04, 0.2493D-04,
     ,   0.2841D-04, 0.3214D-04, 0.3599D-04, 0.3976D-04, 0.4323D-04,
     ,   0.4620D-04, 0.4851D-04, 0.5005D-04, 0.5076D-04, 0.5066D-04,
     ,   0.4978D-04, 0.4815D-04, 0.4585D-04, 0.4295D-04, 0.3952D-04,
     ,   0.3565D-04, 0.3142D-04, 0.2692D-04, 0.2226D-04, 0.1757D-04,
     ,   0.1302D-04, 0.8810D-05, 0.5162D-05, 0.2279D-05, 0.2648D-06,
     ,  -0.9434D-06,-0.1575D-05,-0.1927D-05,-0.2224D-05,-0.2545D-05,
     ,  -0.2860D-05,-0.3104D-05,-0.3226D-05,-0.3208D-05,-0.3052D-05,
     ,  -0.2772D-05,-0.2386D-05,-0.1912D-05/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.1126D-06, 0.1322D-06, 0.1552D-06, 0.1821D-06, 0.2135D-06,
     ,   0.2503D-06, 0.2931D-06, 0.3432D-06, 0.4015D-06, 0.4695D-06,
     ,   0.5486D-06, 0.6406D-06, 0.7476D-06, 0.8718D-06, 0.1016D-05,
     ,   0.1183D-05, 0.1376D-05, 0.1600D-05, 0.1858D-05, 0.2156D-05,
     ,   0.2499D-05, 0.2895D-05, 0.3350D-05, 0.3872D-05, 0.4472D-05,
     ,   0.5160D-05, 0.5948D-05, 0.6851D-05, 0.7886D-05, 0.9071D-05,
     ,   0.1043D-04, 0.1199D-04, 0.1379D-04, 0.1583D-04, 0.1815D-04,
     ,   0.2072D-04, 0.2350D-04, 0.2639D-04, 0.2924D-04, 0.3190D-04,
     ,   0.3422D-04, 0.3608D-04, 0.3739D-04, 0.3812D-04, 0.3827D-04,
     ,   0.3784D-04, 0.3688D-04, 0.3542D-04, 0.3352D-04, 0.3123D-04,
     ,   0.2860D-04, 0.2568D-04, 0.2254D-04, 0.1923D-04, 0.1583D-04,
     ,   0.1244D-04, 0.9174D-05, 0.6164D-05, 0.3572D-05, 0.1537D-05,
     ,   0.1272D-06,-0.7078D-06,-0.1136D-05,-0.1372D-05,-0.1573D-05,
     ,  -0.1796D-05,-0.2016D-05,-0.2187D-05,-0.2272D-05,-0.2258D-05,
     ,  -0.2147D-05,-0.1949D-05,-0.1676D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c---------------------
      subroutine clhqg20m(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.6525D-08, 0.7905D-08, 0.9573D-08, 0.1160D-07, 0.1405D-07,
     ,   0.1701D-07, 0.2060D-07, 0.2494D-07, 0.3019D-07, 0.3652D-07,
     ,   0.4416D-07, 0.5332D-07, 0.6434D-07, 0.7750D-07, 0.9315D-07,
     ,   0.1116D-06, 0.1332D-06, 0.1581D-06, 0.1862D-06, 0.2170D-06,
     ,   0.2491D-06, 0.2800D-06, 0.3052D-06, 0.3173D-06, 0.3046D-06,
     ,   0.2505D-06, 0.1320D-06,-0.7713D-07,-0.4038D-06,-0.8604D-06,
     ,  -0.1417D-05,-0.1979D-05,-0.2357D-05,-0.2297D-05,-0.1610D-05,
     ,  -0.3441D-06, 0.1122D-05, 0.2295D-05, 0.2813D-05, 0.2668D-05,
     ,   0.2088D-05, 0.1354D-05, 0.6526D-06, 0.6383D-07,-0.3982D-06,
     ,  -0.7476D-06,-0.1004D-05,-0.1192D-05,-0.1329D-05,-0.1427D-05,
     ,  -0.1498D-05,-0.1548D-05,-0.1584D-05,-0.1610D-05,-0.1628D-05,
     ,  -0.1640D-05,-0.1649D-05,-0.1655D-05,-0.1660D-05,-0.1662D-05,
     ,  -0.1666D-05,-0.1667D-05,-0.1667D-05,-0.1669D-05,-0.1670D-05,
     ,  -0.1668D-05,-0.1670D-05,-0.1670D-05,-0.1669D-05,-0.1669D-05,
     ,  -0.1669D-05,-0.1669D-05,-0.1669D-05/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1054D-07, 0.1277D-07, 0.1547D-07, 0.1874D-07, 0.2271D-07,
     ,   0.2750D-07, 0.3330D-07, 0.4031D-07, 0.4879D-07, 0.5903D-07,
     ,   0.7137D-07, 0.8621D-07, 0.1040D-06, 0.1253D-06, 0.1506D-06,
     ,   0.1805D-06, 0.2155D-06, 0.2557D-06, 0.3012D-06, 0.3509D-06,
     ,   0.4024D-06, 0.4516D-06, 0.4900D-06, 0.5047D-06, 0.4746D-06,
     ,   0.3680D-06, 0.1406D-06,-0.2632D-06,-0.9054D-06,-0.1833D-05,
     ,  -0.3035D-05,-0.4387D-05,-0.5597D-05,-0.6230D-05,-0.5889D-05,
     ,  -0.4511D-05,-0.2563D-05,-0.7665D-06, 0.3021D-06, 0.5562D-06,
     ,   0.2877D-06,-0.1979D-06,-0.6887D-06,-0.1102D-05,-0.1428D-05,
     ,  -0.1677D-05,-0.1867D-05,-0.2013D-05,-0.2125D-05,-0.2209D-05,
     ,  -0.2275D-05,-0.2323D-05,-0.2358D-05,-0.2385D-05,-0.2404D-05,
     ,  -0.2417D-05,-0.2427D-05,-0.2435D-05,-0.2442D-05,-0.2444D-05,
     ,  -0.2447D-05,-0.2449D-05,-0.2450D-05,-0.2452D-05,-0.2452D-05,
     ,  -0.2453D-05,-0.2453D-05,-0.2454D-05,-0.2453D-05,-0.2453D-05,
     ,  -0.2453D-05,-0.2453D-05,-0.2453D-05/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1538D-07, 0.1863D-07, 0.2258D-07, 0.2735D-07, 0.3313D-07,
     ,   0.4012D-07, 0.4858D-07, 0.5881D-07, 0.7118D-07, 0.8612D-07,
     ,   0.1041D-06, 0.1258D-06, 0.1518D-06, 0.1828D-06, 0.2198D-06,
     ,   0.2633D-06, 0.3144D-06, 0.3731D-06, 0.4394D-06, 0.5119D-06,
     ,   0.5871D-06, 0.6589D-06, 0.7151D-06, 0.7367D-06, 0.6933D-06,
     ,   0.5390D-06, 0.2102D-06,-0.3751D-06,-0.1304D-05,-0.2642D-05,
     ,  -0.4376D-05,-0.6316D-05,-0.8035D-05,-0.8903D-05,-0.8352D-05,
     ,  -0.6290D-05,-0.3396D-05,-0.7667D-06, 0.7606D-06, 0.1092D-05,
     ,   0.6496D-06,-0.1061D-06,-0.8727D-06,-0.1519D-05,-0.2026D-05,
     ,  -0.2411D-05,-0.2707D-05,-0.2934D-05,-0.3103D-05,-0.3234D-05,
     ,  -0.3332D-05,-0.3406D-05,-0.3460D-05,-0.3498D-05,-0.3526D-05,
     ,  -0.3548D-05,-0.3564D-05,-0.3576D-05,-0.3582D-05,-0.3589D-05,
     ,  -0.3592D-05,-0.3595D-05,-0.3599D-05,-0.3598D-05,-0.3599D-05,
     ,  -0.3601D-05,-0.3599D-05,-0.3601D-05,-0.3602D-05,-0.3602D-05,
     ,  -0.3602D-05,-0.3602D-05,-0.3602D-05/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.2256D-07, 0.2732D-07, 0.3310D-07, 0.4010D-07, 0.4857D-07,
     ,   0.5882D-07, 0.7122D-07, 0.8622D-07, 0.1044D-06, 0.1263D-06,
     ,   0.1527D-06, 0.1844D-06, 0.2225D-06, 0.2681D-06, 0.3222D-06,
     ,   0.3862D-06, 0.4609D-06, 0.5471D-06, 0.6442D-06, 0.7506D-06,
     ,   0.8610D-06, 0.9650D-06, 0.1049D-05, 0.1081D-05, 0.1017D-05,
     ,   0.7914D-06, 0.3093D-06,-0.5489D-06,-0.1911D-05,-0.3873D-05,
     ,  -0.6412D-05,-0.9262D-05,-0.1178D-04,-0.1306D-04,-0.1223D-04,
     ,  -0.9232D-05,-0.5002D-05,-0.1153D-05, 0.1072D-05, 0.1627D-05,
     ,   0.9340D-06,-0.1709D-06,-0.1289D-05,-0.2232D-05,-0.2975D-05,
     ,  -0.3542D-05,-0.3972D-05,-0.4302D-05,-0.4552D-05,-0.4741D-05,
     ,  -0.4885D-05,-0.4992D-05,-0.5070D-05,-0.5129D-05,-0.5171D-05,
     ,  -0.5202D-05,-0.5224D-05,-0.5240D-05,-0.5250D-05,-0.5259D-05,
     ,  -0.5265D-05,-0.5269D-05,-0.5272D-05,-0.5275D-05,-0.5276D-05,
     ,  -0.5275D-05,-0.5278D-05,-0.5278D-05,-0.5278D-05,-0.5278D-05,
     ,  -0.5278D-05,-0.5280D-05,-0.5280D-05/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.3304D-07, 0.4003D-07, 0.4849D-07, 0.5874D-07, 0.7117D-07,
     ,   0.8617D-07, 0.1044D-06, 0.1264D-06, 0.1529D-06, 0.1850D-06,
     ,   0.2237D-06, 0.2702D-06, 0.3260D-06, 0.3928D-06, 0.4721D-06,
     ,   0.5658D-06, 0.6752D-06, 0.8015D-06, 0.9439D-06, 0.1099D-05,
     ,   0.1261D-05, 0.1413D-05, 0.1537D-05, 0.1583D-05, 0.1490D-05,
     ,   0.1159D-05, 0.4527D-06,-0.8042D-06,-0.2798D-05,-0.5675D-05,
     ,  -0.9398D-05,-0.1358D-04,-0.1726D-04,-0.1918D-04,-0.1797D-04,
     ,  -0.1355D-04,-0.7333D-05,-0.1728D-05, 0.1615D-05, 0.2334D-05,
     ,   0.1415D-05,-0.2507D-06,-0.1884D-05,-0.3271D-05,-0.4365D-05,
     ,  -0.5194D-05,-0.5823D-05,-0.6307D-05,-0.6677D-05,-0.6957D-05,
     ,  -0.7162D-05,-0.7324D-05,-0.7440D-05,-0.7522D-05,-0.7585D-05,
     ,  -0.7631D-05,-0.7664D-05,-0.7687D-05,-0.7702D-05,-0.7715D-05,
     ,  -0.7721D-05,-0.7728D-05,-0.7735D-05,-0.7737D-05,-0.7742D-05,
     ,  -0.7742D-05,-0.7741D-05,-0.7742D-05,-0.7743D-05,-0.7743D-05,
     ,  -0.7743D-05,-0.7741D-05,-0.7741D-05/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.4837D-07, 0.5860D-07, 0.7098D-07, 0.8599D-07, 0.1041D-06,
     ,   0.1261D-06, 0.1528D-06, 0.1849D-06, 0.2238D-06, 0.2708D-06,
     ,   0.3274D-06, 0.3954D-06, 0.4772D-06, 0.5748D-06, 0.6909D-06,
     ,   0.8282D-06, 0.9886D-06, 0.1173D-05, 0.1381D-05, 0.1609D-05,
     ,   0.1846D-05, 0.2074D-05, 0.2249D-05, 0.2317D-05, 0.2180D-05,
     ,   0.1695D-05, 0.6604D-06,-0.1177D-05,-0.4099D-05,-0.8314D-05,
     ,  -0.1377D-04,-0.1989D-04,-0.2531D-04,-0.2807D-04,-0.2632D-04,
     ,  -0.1985D-04,-0.1078D-04,-0.2518D-05, 0.2325D-05, 0.3465D-05,
     ,   0.2035D-05,-0.3357D-06,-0.2788D-05,-0.4783D-05,-0.6399D-05,
     ,  -0.7610D-05,-0.8544D-05,-0.9248D-05,-0.9799D-05,-0.1021D-04,
     ,  -0.1050D-04,-0.1075D-04,-0.1091D-04,-0.1103D-04,-0.1112D-04,
     ,  -0.1120D-04,-0.1125D-04,-0.1128D-04,-0.1129D-04,-0.1131D-04,
     ,  -0.1132D-04,-0.1133D-04,-0.1135D-04,-0.1134D-04,-0.1136D-04,
     ,  -0.1136D-04,-0.1136D-04,-0.1136D-04,-0.1135D-04,-0.1135D-04,
     ,  -0.1135D-04,-0.1135D-04,-0.1135D-04/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.7071D-07, 0.8567D-07, 0.1038D-06, 0.1257D-06, 0.1523D-06,
     ,   0.1844D-06, 0.2233D-06, 0.2704D-06, 0.3272D-06, 0.3958D-06,
     ,   0.4786D-06, 0.5782D-06, 0.6978D-06, 0.8404D-06, 0.1010D-05,
     ,   0.1211D-05, 0.1445D-05, 0.1715D-05, 0.2020D-05, 0.2353D-05,
     ,   0.2699D-05, 0.3028D-05, 0.3288D-05, 0.3388D-05, 0.3188D-05,
     ,   0.2481D-05, 0.9659D-06,-0.1724D-05,-0.5998D-05,-0.1216D-04,
     ,  -0.2015D-04,-0.2907D-04,-0.3703D-04,-0.4104D-04,-0.3857D-04,
     ,  -0.2908D-04,-0.1578D-04,-0.3728D-05, 0.3431D-05, 0.5043D-05,
     ,   0.3004D-05,-0.5283D-06,-0.4039D-05,-0.7049D-05,-0.9385D-05,
     ,  -0.1115D-04,-0.1253D-04,-0.1355D-04,-0.1433D-04,-0.1493D-04,
     ,  -0.1542D-04,-0.1572D-04,-0.1597D-04,-0.1618D-04,-0.1630D-04,
     ,  -0.1640D-04,-0.1646D-04,-0.1652D-04,-0.1655D-04,-0.1659D-04,
     ,  -0.1662D-04,-0.1662D-04,-0.1662D-04,-0.1665D-04,-0.1663D-04,
     ,  -0.1663D-04,-0.1665D-04,-0.1665D-04,-0.1665D-04,-0.1665D-04,
     ,  -0.1665D-04,-0.1665D-04,-0.1665D-04/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1032D-06, 0.1250D-06, 0.1514D-06, 0.1835D-06, 0.2222D-06,
     ,   0.2691D-06, 0.3259D-06, 0.3945D-06, 0.4775D-06, 0.5777D-06,
     ,   0.6985D-06, 0.8438D-06, 0.1018D-05, 0.1226D-05, 0.1474D-05,
     ,   0.1767D-05, 0.2109D-05, 0.2503D-05, 0.2947D-05, 0.3434D-05,
     ,   0.3938D-05, 0.4419D-05, 0.4797D-05, 0.4942D-05, 0.4652D-05,
     ,   0.3616D-05, 0.1407D-05,-0.2517D-05,-0.8759D-05,-0.1776D-04,
     ,  -0.2940D-04,-0.4253D-04,-0.5412D-04,-0.6004D-04,-0.5642D-04,
     ,  -0.4265D-04,-0.2320D-04,-0.5534D-05, 0.5007D-05, 0.7333D-05,
     ,   0.4368D-05,-0.7523D-06,-0.5949D-05,-0.1028D-04,-0.1371D-04,
     ,  -0.1634D-04,-0.1832D-04,-0.1987D-04,-0.2102D-04,-0.2190D-04,
     ,  -0.2255D-04,-0.2305D-04,-0.2342D-04,-0.2368D-04,-0.2389D-04,
     ,  -0.2402D-04,-0.2412D-04,-0.2419D-04,-0.2425D-04,-0.2428D-04,
     ,  -0.2431D-04,-0.2434D-04,-0.2435D-04,-0.2435D-04,-0.2437D-04,
     ,  -0.2437D-04,-0.2435D-04,-0.2437D-04,-0.2437D-04,-0.2437D-04,
     ,  -0.2437D-04,-0.2437D-04,-0.2437D-04/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1501D-06, 0.1819D-06, 0.2204D-06, 0.2669D-06, 0.3233D-06,
     ,   0.3916D-06, 0.4742D-06, 0.5741D-06, 0.6948D-06, 0.8406D-06,
     ,   0.1016D-05, 0.1227D-05, 0.1481D-05, 0.1785D-05, 0.2145D-05,
     ,   0.2571D-05, 0.3068D-05, 0.3642D-05, 0.4288D-05, 0.4996D-05,
     ,   0.5730D-05, 0.6430D-05, 0.6981D-05, 0.7189D-05, 0.6764D-05,
     ,   0.5256D-05, 0.2038D-05,-0.3681D-05,-0.1278D-04,-0.2589D-04,
     ,  -0.4287D-04,-0.6199D-04,-0.7897D-04,-0.8764D-04,-0.8238D-04,
     ,  -0.6229D-04,-0.3388D-04,-0.7729D-05, 0.7374D-05, 0.1083D-04,
     ,   0.6421D-05,-0.1054D-05,-0.8616D-05,-0.1501D-04,-0.2004D-04,
     ,  -0.2392D-04,-0.2681D-04,-0.2904D-04,-0.3077D-04,-0.3206D-04,
     ,  -0.3302D-04,-0.3376D-04,-0.3427D-04,-0.3468D-04,-0.3494D-04,
     ,  -0.3516D-04,-0.3532D-04,-0.3544D-04,-0.3552D-04,-0.3556D-04,
     ,  -0.3560D-04,-0.3563D-04,-0.3566D-04,-0.3566D-04,-0.3566D-04,
     ,  -0.3569D-04,-0.3569D-04,-0.3569D-04,-0.3570D-04,-0.3569D-04,
     ,  -0.3569D-04,-0.3569D-04,-0.3569D-04/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.2177D-06, 0.2637D-06, 0.3194D-06, 0.3870D-06, 0.4687D-06,
     ,   0.5677D-06, 0.6874D-06, 0.8321D-06, 0.1007D-05, 0.1218D-05,
     ,   0.1473D-05, 0.1780D-05, 0.2147D-05, 0.2587D-05, 0.3110D-05,
     ,   0.3727D-05, 0.4449D-05, 0.5280D-05, 0.6216D-05, 0.7244D-05,
     ,   0.8308D-05, 0.9323D-05, 0.1012D-04, 0.1042D-04, 0.9806D-05,
     ,   0.7622D-05, 0.2959D-05,-0.5324D-05,-0.1853D-04,-0.3755D-04,
     ,  -0.6226D-04,-0.9003D-04,-0.1148D-03,-0.1276D-03,-0.1200D-03,
     ,  -0.9058D-04,-0.4974D-04,-0.1190D-04, 0.1046D-04, 0.1573D-04,
     ,   0.9645D-05,-0.1669D-05,-0.1262D-04,-0.2195D-04,-0.2931D-04,
     ,  -0.3489D-04,-0.3914D-04,-0.4242D-04,-0.4489D-04,-0.4676D-04,
     ,  -0.4821D-04,-0.4924D-04,-0.5005D-04,-0.5062D-04,-0.5106D-04,
     ,  -0.5135D-04,-0.5156D-04,-0.5172D-04,-0.5182D-04,-0.5192D-04,
     ,  -0.5198D-04,-0.5202D-04,-0.5204D-04,-0.5207D-04,-0.5208D-04,
     ,  -0.5208D-04,-0.5210D-04,-0.5209D-04,-0.5211D-04,-0.5211D-04,
     ,  -0.5211D-04,-0.5211D-04,-0.5211D-04/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.3137D-06, 0.3800D-06, 0.4604D-06, 0.5576D-06, 0.6754D-06,
     ,   0.8182D-06, 0.9909D-06, 0.1199D-05, 0.1451D-05, 0.1756D-05,
     ,   0.2123D-05, 0.2565D-05, 0.3095D-05, 0.3729D-05, 0.4481D-05,
     ,   0.5371D-05, 0.6411D-05, 0.7608D-05, 0.8962D-05, 0.1043D-04,
     ,   0.1197D-04, 0.1343D-04, 0.1458D-04, 0.1501D-04, 0.1413D-04,
     ,   0.1098D-04, 0.4218D-05,-0.7755D-05,-0.2681D-04,-0.5435D-04,
     ,  -0.9005D-04,-0.1303D-03,-0.1661D-03,-0.1851D-03,-0.1746D-03,
     ,  -0.1326D-03,-0.7254D-04,-0.1787D-04, 0.1500D-04, 0.2295D-04,
     ,   0.1355D-04,-0.2057D-05,-0.1839D-04,-0.3197D-04,-0.4271D-04,
     ,  -0.5085D-04,-0.5711D-04,-0.6184D-04,-0.6547D-04,-0.6817D-04,
     ,  -0.7027D-04,-0.7185D-04,-0.7294D-04,-0.7379D-04,-0.7441D-04,
     ,  -0.7484D-04,-0.7517D-04,-0.7538D-04,-0.7559D-04,-0.7568D-04,
     ,  -0.7578D-04,-0.7581D-04,-0.7586D-04,-0.7592D-04,-0.7593D-04,
     ,  -0.7595D-04,-0.7595D-04,-0.7595D-04,-0.7595D-04,-0.7595D-04,
     ,  -0.7596D-04,-0.7596D-04,-0.7601D-04/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.4481D-06, 0.5429D-06, 0.6577D-06, 0.7967D-06, 0.9651D-06,
     ,   0.1169D-05, 0.1415D-05, 0.1713D-05, 0.2074D-05, 0.2509D-05,
     ,   0.3033D-05, 0.3664D-05, 0.4421D-05, 0.5326D-05, 0.6402D-05,
     ,   0.7673D-05, 0.9156D-05, 0.1087D-04, 0.1280D-04, 0.1491D-04,
     ,   0.1710D-04, 0.1918D-04, 0.2082D-04, 0.2145D-04, 0.2016D-04,
     ,   0.1563D-04, 0.6001D-05,-0.1116D-04,-0.3847D-04,-0.7795D-04,
     ,  -0.1293D-03,-0.1873D-03,-0.2391D-03,-0.2668D-03,-0.2520D-03,
     ,  -0.1921D-03,-0.1059D-03,-0.2604D-04, 0.2196D-04, 0.3311D-04,
     ,   0.2012D-04,-0.3191D-05,-0.2651D-04,-0.4635D-04,-0.6191D-04,
     ,  -0.7382D-04,-0.8286D-04,-0.8980D-04,-0.9509D-04,-0.9906D-04,
     ,  -0.1022D-03,-0.1045D-03,-0.1060D-03,-0.1073D-03,-0.1082D-03,
     ,  -0.1088D-03,-0.1093D-03,-0.1096D-03,-0.1099D-03,-0.1100D-03,
     ,  -0.1102D-03,-0.1102D-03,-0.1103D-03,-0.1105D-03,-0.1105D-03,
     ,  -0.1104D-03,-0.1104D-03,-0.1104D-03,-0.1104D-03,-0.1104D-03,
     ,  -0.1103D-03,-0.1103D-03,-0.1106D-03/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.6324D-06, 0.7660D-06, 0.9280D-06, 0.1124D-05, 0.1362D-05,
     ,   0.1649D-05, 0.1997D-05, 0.2418D-05, 0.2926D-05, 0.3540D-05,
     ,   0.4280D-05, 0.5171D-05, 0.6240D-05, 0.7516D-05, 0.9036D-05,
     ,   0.1083D-04, 0.1292D-04, 0.1534D-04, 0.1806D-04, 0.2104D-04,
     ,   0.2413D-04, 0.2707D-04, 0.2937D-04, 0.3023D-04, 0.2842D-04,
     ,   0.2201D-04, 0.8330D-05,-0.1596D-04,-0.5468D-04,-0.1107D-03,
     ,  -0.1837D-03,-0.2660D-03,-0.3413D-03,-0.3813D-03,-0.3619D-03,
     ,  -0.2772D-03,-0.1537D-03,-0.3901D-04, 0.3038D-04, 0.4760D-04,
     ,   0.2904D-04,-0.4126D-05,-0.3806D-04,-0.6697D-04,-0.8919D-04,
     ,  -0.1067D-03,-0.1197D-03,-0.1299D-03,-0.1375D-03,-0.1434D-03,
     ,  -0.1476D-03,-0.1509D-03,-0.1535D-03,-0.1551D-03,-0.1564D-03,
     ,  -0.1576D-03,-0.1582D-03,-0.1588D-03,-0.1589D-03,-0.1594D-03,
     ,  -0.1592D-03,-0.1597D-03,-0.1595D-03,-0.1595D-03,-0.1598D-03,
     ,  -0.1598D-03,-0.1598D-03,-0.1598D-03,-0.1598D-03,-0.1598D-03,
     ,  -0.1598D-03,-0.1598D-03,-0.1598D-03/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.8766D-06, 0.1062D-05, 0.1286D-05, 0.1558D-05, 0.1887D-05,
     ,   0.2286D-05, 0.2768D-05, 0.3351D-05, 0.4056D-05, 0.4906D-05,
     ,   0.5931D-05, 0.7166D-05, 0.8644D-05, 0.1041D-04, 0.1252D-04,
     ,   0.1500D-04, 0.1791D-04, 0.2126D-04, 0.2503D-04, 0.2915D-04,
     ,   0.3343D-04, 0.3750D-04, 0.4068D-04, 0.4190D-04, 0.3935D-04,
     ,   0.3039D-04, 0.1136D-04,-0.2252D-04,-0.7647D-04,-0.1549D-03,
     ,  -0.2570D-03,-0.3737D-03,-0.4800D-03,-0.5386D-03,-0.5143D-03,
     ,  -0.3967D-03,-0.2232D-03,-0.5906D-04, 0.4171D-04, 0.6751D-04,
     ,   0.4218D-04,-0.5376D-05,-0.5435D-04,-0.9552D-04,-0.1283D-03,
     ,  -0.1531D-03,-0.1721D-03,-0.1864D-03,-0.1975D-03,-0.2058D-03,
     ,  -0.2123D-03,-0.2169D-03,-0.2205D-03,-0.2230D-03,-0.2249D-03,
     ,  -0.2262D-03,-0.2272D-03,-0.2278D-03,-0.2285D-03,-0.2286D-03,
     ,  -0.2291D-03,-0.2291D-03,-0.2294D-03,-0.2295D-03,-0.2294D-03,
     ,  -0.2294D-03,-0.2295D-03,-0.2297D-03,-0.2297D-03,-0.2297D-03,
     ,  -0.2297D-03,-0.2297D-03,-0.2295D-03/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1183D-05, 0.1433D-05, 0.1736D-05, 0.2103D-05, 0.2547D-05,
     ,   0.3085D-05, 0.3736D-05, 0.4523D-05, 0.5475D-05, 0.6622D-05,
     ,   0.8007D-05, 0.9672D-05, 0.1167D-04, 0.1406D-04, 0.1690D-04,
     ,   0.2025D-04, 0.2417D-04, 0.2868D-04, 0.3377D-04, 0.3933D-04,
     ,   0.4510D-04, 0.5059D-04, 0.5485D-04, 0.5642D-04, 0.5290D-04,
     ,   0.4073D-04, 0.1481D-04,-0.3133D-04,-0.1050D-03,-0.2121D-03,
     ,  -0.3526D-03,-0.5134D-03,-0.6625D-03,-0.7478D-03,-0.7205D-03,
     ,  -0.5608D-03,-0.3200D-03,-0.8782D-04, 0.5696D-04, 0.9463D-04,
     ,   0.6078D-04,-0.6260D-05,-0.7561D-04,-0.1346D-03,-0.1816D-03,
     ,  -0.2171D-03,-0.2442D-03,-0.2650D-03,-0.2808D-03,-0.2930D-03,
     ,  -0.3019D-03,-0.3089D-03,-0.3137D-03,-0.3174D-03,-0.3202D-03,
     ,  -0.3222D-03,-0.3235D-03,-0.3244D-03,-0.3254D-03,-0.3260D-03,
     ,  -0.3263D-03,-0.3264D-03,-0.3266D-03,-0.3269D-03,-0.3268D-03,
     ,  -0.3270D-03,-0.3272D-03,-0.3270D-03,-0.3270D-03,-0.3270D-03,
     ,  -0.3270D-03,-0.3272D-03,-0.3273D-03/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.1538D-05, 0.1863D-05, 0.2257D-05, 0.2734D-05, 0.3312D-05,
     ,   0.4011D-05, 0.4858D-05, 0.5879D-05, 0.7115D-05, 0.8608D-05,
     ,   0.1041D-04, 0.1257D-04, 0.1517D-04, 0.1828D-04, 0.2197D-04,
     ,   0.2632D-04, 0.3142D-04, 0.3728D-04, 0.4390D-04, 0.5113D-04,
     ,   0.5861D-04, 0.6573D-04, 0.7126D-04, 0.7325D-04, 0.6855D-04,
     ,   0.5250D-04, 0.1838D-04,-0.4232D-04,-0.1394D-03,-0.2811D-03,
     ,  -0.4689D-03,-0.6859D-03,-0.8894D-03,-0.1013D-02,-0.9847D-03,
     ,  -0.7819D-03,-0.4548D-03,-0.1379D-03, 0.6810D-04, 0.1310D-03,
     ,   0.8470D-04,-0.6867D-05,-0.1043D-03,-0.1877D-03,-0.2530D-03,
     ,  -0.3033D-03,-0.3419D-03,-0.3709D-03,-0.3936D-03,-0.4103D-03,
     ,  -0.4233D-03,-0.4328D-03,-0.4401D-03,-0.4451D-03,-0.4490D-03,
     ,  -0.4518D-03,-0.4540D-03,-0.4553D-03,-0.4563D-03,-0.4571D-03,
     ,  -0.4576D-03,-0.4582D-03,-0.4584D-03,-0.4583D-03,-0.4587D-03,
     ,  -0.4588D-03,-0.4586D-03,-0.4588D-03,-0.4589D-03,-0.4589D-03,
     ,  -0.4591D-03,-0.4589D-03,-0.4589D-03/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.1894D-05, 0.2294D-05, 0.2779D-05, 0.3366D-05, 0.4078D-05,
     ,   0.4940D-05, 0.5978D-05, 0.7240D-05, 0.8763D-05, 0.1060D-04,
     ,   0.1281D-04, 0.1548D-04, 0.1868D-04, 0.2250D-04, 0.2704D-04,
     ,   0.3241D-04, 0.3867D-04, 0.4590D-04, 0.5403D-04, 0.6291D-04,
     ,   0.7210D-04, 0.8078D-04, 0.8753D-04, 0.8983D-04, 0.8379D-04,
     ,   0.6360D-04, 0.2075D-04,-0.5532D-04,-0.1779D-03,-0.3577D-03,
     ,  -0.5964D-03,-0.8775D-03,-0.1147D-02,-0.1327D-02,-0.1312D-02,
     ,  -0.1061D-02,-0.6401D-03,-0.2072D-03, 0.8168D-04, 0.1758D-03,
     ,   0.1222D-03,-0.3846D-05,-0.1380D-03,-0.2534D-03,-0.3451D-03,
     ,  -0.4151D-03,-0.4679D-03,-0.5092D-03,-0.5401D-03,-0.5639D-03,
     ,  -0.5820D-03,-0.5954D-03,-0.6054D-03,-0.6128D-03,-0.6182D-03,
     ,  -0.6221D-03,-0.6249D-03,-0.6271D-03,-0.6285D-03,-0.6294D-03,
     ,  -0.6304D-03,-0.6307D-03,-0.6311D-03,-0.6316D-03,-0.6314D-03,
     ,  -0.6316D-03,-0.6320D-03,-0.6318D-03,-0.6319D-03,-0.6320D-03,
     ,  -0.6320D-03,-0.6320D-03,-0.6320D-03/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.2157D-05, 0.2614D-05, 0.3166D-05, 0.3834D-05, 0.4644D-05,
     ,   0.5626D-05, 0.6812D-05, 0.8249D-05, 0.9982D-05, 0.1208D-04,
     ,   0.1460D-04, 0.1763D-04, 0.2128D-04, 0.2563D-04, 0.3080D-04,
     ,   0.3691D-04, 0.4404D-04, 0.5226D-04, 0.6148D-04, 0.7157D-04,
     ,   0.8200D-04, 0.9182D-04, 0.9930D-04, 0.1016D-03, 0.9430D-04,
     ,   0.7040D-04, 0.1997D-04,-0.6954D-04,-0.2140D-03,-0.4274D-03,
     ,  -0.7155D-03,-0.1060D-02,-0.1406D-02,-0.1649D-02,-0.1668D-02,
     ,  -0.1388D-02,-0.8753D-03,-0.3199D-03, 0.7814D-04, 0.2221D-03,
     ,   0.1641D-03, 0.5346D-05,-0.1731D-03,-0.3303D-03,-0.4546D-03,
     ,  -0.5502D-03,-0.6227D-03,-0.6787D-03,-0.7212D-03,-0.7537D-03,
     ,  -0.7784D-03,-0.7970D-03,-0.8105D-03,-0.8207D-03,-0.8285D-03,
     ,  -0.8339D-03,-0.8373D-03,-0.8405D-03,-0.8422D-03,-0.8440D-03,
     ,  -0.8448D-03,-0.8455D-03,-0.8461D-03,-0.8462D-03,-0.8469D-03,
     ,  -0.8468D-03,-0.8469D-03,-0.8471D-03,-0.8473D-03,-0.8475D-03,
     ,  -0.8473D-03,-0.8473D-03,-0.8473D-03/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.2200D-05, 0.2667D-05, 0.3230D-05, 0.3912D-05, 0.4737D-05,
     ,   0.5736D-05, 0.6949D-05, 0.8412D-05, 0.1018D-04, 0.1232D-04,
     ,   0.1489D-04, 0.1799D-04, 0.2170D-04, 0.2612D-04, 0.3141D-04,
     ,   0.3763D-04, 0.4492D-04, 0.5323D-04, 0.6263D-04, 0.7288D-04,
     ,   0.8339D-04, 0.9321D-04, 0.1006D-03, 0.1024D-03, 0.9407D-04,
     ,   0.6813D-04, 0.1449D-04,-0.8190D-04,-0.2377D-03,-0.4703D-03,
     ,  -0.7896D-03,-0.1181D-02,-0.1592D-02,-0.1914D-02,-0.1993D-02,
     ,  -0.1730D-02,-0.1155D-02,-0.4702D-03, 0.5282D-04, 0.2785D-03,
     ,   0.2277D-03, 0.3107D-04,-0.2018D-03,-0.4057D-03,-0.5714D-03,
     ,  -0.6973D-03,-0.7935D-03,-0.8687D-03,-0.9240D-03,-0.9678D-03,
     ,  -0.1001D-02,-0.1027D-02,-0.1044D-02,-0.1057D-02,-0.1069D-02,
     ,  -0.1076D-02,-0.1080D-02,-0.1086D-02,-0.1086D-02,-0.1090D-02,
     ,  -0.1091D-02,-0.1091D-02,-0.1092D-02,-0.1092D-02,-0.1093D-02,
     ,  -0.1093D-02,-0.1093D-02,-0.1093D-02,-0.1095D-02,-0.1095D-02,
     ,  -0.1095D-02,-0.1095D-02,-0.1095D-02/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.1907D-05, 0.2311D-05, 0.2800D-05, 0.3393D-05, 0.4111D-05,
     ,   0.4979D-05, 0.6028D-05, 0.7296D-05, 0.8828D-05, 0.1068D-04,
     ,   0.1291D-04, 0.1559D-04, 0.1881D-04, 0.2266D-04, 0.2723D-04,
     ,   0.3262D-04, 0.3886D-04, 0.4610D-04, 0.5418D-04, 0.6294D-04,
     ,   0.7185D-04, 0.8011D-04, 0.8601D-04, 0.8676D-04, 0.7803D-04,
     ,   0.5313D-04, 0.1885D-05,-0.8934D-04,-0.2378D-03,-0.4629D-03,
     ,  -0.7784D-03,-0.1183D-02,-0.1627D-02,-0.2016D-02,-0.2187D-02,
     ,  -0.2003D-02,-0.1431D-02,-0.6623D-03,-0.2550D-05, 0.3243D-03,
     ,   0.3130D-03, 0.8786D-04,-0.1936D-03,-0.4564D-03,-0.6684D-03,
     ,  -0.8304D-03,-0.9566D-03,-0.1052D-02,-0.1126D-02,-0.1180D-02,
     ,  -0.1223D-02,-0.1256D-02,-0.1282D-02,-0.1299D-02,-0.1310D-02,
     ,  -0.1320D-02,-0.1329D-02,-0.1332D-02,-0.1338D-02,-0.1337D-02,
     ,  -0.1342D-02,-0.1342D-02,-0.1342D-02,-0.1345D-02,-0.1343D-02,
     ,  -0.1345D-02,-0.1346D-02,-0.1345D-02,-0.1343D-02,-0.1343D-02,
     ,  -0.1343D-02,-0.1343D-02,-0.1343D-02/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.1276D-05, 0.1545D-05, 0.1871D-05, 0.2266D-05, 0.2745D-05,
     ,   0.3323D-05, 0.4026D-05, 0.4872D-05, 0.5897D-05, 0.7133D-05,
     ,   0.8625D-05, 0.1041D-04, 0.1257D-04, 0.1513D-04, 0.1815D-04,
     ,   0.2173D-04, 0.2589D-04, 0.3064D-04, 0.3597D-04, 0.4161D-04,
     ,   0.4734D-04, 0.5230D-04, 0.5536D-04, 0.5450D-04, 0.4626D-04,
     ,   0.2548D-04,-0.1567D-04,-0.8858D-04,-0.2078D-03,-0.3923D-03,
     ,  -0.6594D-03,-0.1014D-02,-0.1448D-02,-0.1864D-02,-0.2144D-02,
     ,  -0.2094D-02,-0.1626D-02,-0.8582D-03,-0.8991D-04, 0.3683D-03,
     ,   0.4285D-03, 0.2087D-03,-0.1237D-03,-0.4444D-03,-0.7081D-03,
     ,  -0.9122D-03,-0.1066D-02,-0.1185D-02,-0.1276D-02,-0.1349D-02,
     ,  -0.1401D-02,-0.1440D-02,-0.1471D-02,-0.1495D-02,-0.1512D-02,
     ,  -0.1523D-02,-0.1533D-02,-0.1538D-02,-0.1541D-02,-0.1547D-02,
     ,  -0.1548D-02,-0.1551D-02,-0.1551D-02,-0.1551D-02,-0.1554D-02,
     ,  -0.1552D-02,-0.1554D-02,-0.1554D-02,-0.1554D-02,-0.1554D-02,
     ,  -0.1554D-02,-0.1554D-02,-0.1554D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.4731D-06, 0.5725D-06, 0.6903D-06, 0.8384D-06, 0.1014D-05,
     ,   0.1230D-05, 0.1488D-05, 0.1803D-05, 0.2181D-05, 0.2635D-05,
     ,   0.3187D-05, 0.3859D-05, 0.4629D-05, 0.5578D-05, 0.6676D-05,
     ,   0.7968D-05, 0.9428D-05, 0.1112D-04, 0.1290D-04, 0.1472D-04,
     ,   0.1634D-04, 0.1745D-04, 0.1707D-04, 0.1448D-04, 0.7666D-05,
     ,  -0.6500D-05,-0.3250D-04,-0.7744D-04,-0.1525D-03,-0.2716D-03,
     ,  -0.4526D-03,-0.7131D-03,-0.1053D-02,-0.1447D-02,-0.1790D-02,
     ,  -0.1908D-02,-0.1648D-02,-0.9883D-03,-0.1929D-03, 0.3989D-03,
     ,   0.5788D-03, 0.3984D-03, 0.4467D-04,-0.3281D-03,-0.6437D-03,
     ,  -0.8897D-03,-0.1077D-02,-0.1217D-02,-0.1327D-02,-0.1411D-02,
     ,  -0.1475D-02,-0.1526D-02,-0.1562D-02,-0.1589D-02,-0.1610D-02,
     ,  -0.1625D-02,-0.1636D-02,-0.1644D-02,-0.1651D-02,-0.1654D-02,
     ,  -0.1658D-02,-0.1658D-02,-0.1661D-02,-0.1661D-02,-0.1661D-02,
     ,  -0.1664D-02,-0.1662D-02,-0.1662D-02,-0.1664D-02,-0.1664D-02,
     ,  -0.1665D-02,-0.1665D-02,-0.1665D-02/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.2322D-06,-0.2839D-06,-0.3425D-06,-0.4128D-06,-0.4982D-06,
     ,  -0.6042D-06,-0.7330D-06,-0.8885D-06,-0.1078D-05,-0.1310D-05,
     ,  -0.1579D-05,-0.1926D-05,-0.2320D-05,-0.2822D-05,-0.3393D-05,
     ,  -0.4104D-05,-0.4958D-05,-0.6011D-05,-0.7256D-05,-0.8798D-05,
     ,  -0.1067D-04,-0.1287D-04,-0.1585D-04,-0.1942D-04,-0.2489D-04,
     ,  -0.3221D-04,-0.4336D-04,-0.6131D-04,-0.9082D-04,-0.1409D-03,
     ,  -0.2262D-03,-0.3671D-03,-0.5833D-03,-0.8807D-03,-0.1218D-02,
     ,  -0.1471D-02,-0.1441D-02,-0.1022D-02,-0.3026D-03, 0.3754D-03,
     ,   0.7118D-03, 0.6403D-03, 0.3079D-03,-0.9503D-04,-0.4583D-03,
     ,  -0.7432D-03,-0.9577D-03,-0.1123D-02,-0.1246D-02,-0.1342D-02,
     ,  -0.1419D-02,-0.1473D-02,-0.1515D-02,-0.1550D-02,-0.1571D-02,
     ,  -0.1590D-02,-0.1603D-02,-0.1613D-02,-0.1620D-02,-0.1625D-02,
     ,  -0.1627D-02,-0.1630D-02,-0.1633D-02,-0.1633D-02,-0.1634D-02,
     ,  -0.1634D-02,-0.1636D-02,-0.1637D-02,-0.1634D-02,-0.1634D-02,
     ,  -0.1637D-02,-0.1637D-02,-0.1637D-02/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.6320D-06,-0.7652D-06,-0.9271D-06,-0.1125D-05,-0.1361D-05,
     ,  -0.1650D-05,-0.1998D-05,-0.2419D-05,-0.2926D-05,-0.3550D-05,
     ,  -0.4280D-05,-0.5166D-05,-0.6268D-05,-0.7534D-05,-0.9108D-05,
     ,  -0.1095D-04,-0.1312D-04,-0.1565D-04,-0.1864D-04,-0.2202D-04,
     ,  -0.2580D-04,-0.3017D-04,-0.3421D-04,-0.3844D-04,-0.4173D-04,
     ,  -0.4438D-04,-0.4533D-04,-0.4448D-04,-0.4266D-04,-0.4338D-04,
     ,  -0.5588D-04,-0.9632D-04,-0.1917D-03,-0.3712D-03,-0.6373D-03,
     ,  -0.9287D-03,-0.1096D-02,-0.9441D-03,-0.4190D-03, 0.2638D-03,
     ,   0.7604D-03, 0.8593D-03, 0.6186D-03, 0.2250D-03,-0.1630D-03,
     ,  -0.4821D-03,-0.7240D-03,-0.9019D-03,-0.1038D-02,-0.1143D-02,
     ,  -0.1224D-02,-0.1286D-02,-0.1336D-02,-0.1371D-02,-0.1398D-02,
     ,  -0.1419D-02,-0.1433D-02,-0.1443D-02,-0.1449D-02,-0.1456D-02,
     ,  -0.1460D-02,-0.1464D-02,-0.1465D-02,-0.1465D-02,-0.1468D-02,
     ,  -0.1469D-02,-0.1467D-02,-0.1469D-02,-0.1469D-02,-0.1469D-02,
     ,  -0.1469D-02,-0.1469D-02,-0.1469D-02/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.7121D-06,-0.8615D-06,-0.1044D-05,-0.1264D-05,-0.1533D-05,
     ,  -0.1858D-05,-0.2250D-05,-0.2722D-05,-0.3296D-05,-0.3988D-05,
     ,  -0.4839D-05,-0.5844D-05,-0.7027D-05,-0.8500D-05,-0.1021D-04,
     ,  -0.1229D-04,-0.1470D-04,-0.1758D-04,-0.2083D-04,-0.2452D-04,
     ,  -0.2862D-04,-0.3284D-04,-0.3712D-04,-0.4100D-04,-0.4383D-04,
     ,  -0.4408D-04,-0.4067D-04,-0.3215D-04,-0.1714D-04, 0.3657D-05,
     ,   0.2667D-04, 0.4028D-04, 0.2150D-04,-0.6069D-04,-0.2349D-03,
     ,  -0.4951D-03,-0.7487D-03,-0.8136D-03,-0.5352D-03, 0.4855D-04,
     ,   0.6466D-03, 0.9593D-03, 0.8908D-03, 0.5710D-03, 0.1846D-03,
     ,  -0.1517D-03,-0.4130D-03,-0.6073D-03,-0.7532D-03,-0.8601D-03,
     ,  -0.9434D-03,-0.1010D-02,-0.1060D-02,-0.1098D-02,-0.1126D-02,
     ,  -0.1147D-02,-0.1163D-02,-0.1176D-02,-0.1185D-02,-0.1191D-02,
     ,  -0.1196D-02,-0.1197D-02,-0.1199D-02,-0.1202D-02,-0.1202D-02,
     ,  -0.1203D-02,-0.1205D-02,-0.1203D-02,-0.1205D-02,-0.1205D-02,
     ,  -0.1204D-02,-0.1204D-02,-0.1204D-02/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.5937D-06,-0.7186D-06,-0.8712D-06,-0.1055D-05,-0.1280D-05,
     ,  -0.1547D-05,-0.1874D-05,-0.2270D-05,-0.2749D-05,-0.3326D-05,
     ,  -0.4006D-05,-0.4860D-05,-0.5879D-05,-0.7067D-05,-0.8509D-05,
     ,  -0.1024D-04,-0.1226D-04,-0.1461D-04,-0.1736D-04,-0.2044D-04,
     ,  -0.2381D-04,-0.2731D-04,-0.3074D-04,-0.3406D-04,-0.3576D-04,
     ,  -0.3572D-04,-0.3218D-04,-0.2370D-04,-0.8956D-05, 0.1271D-04,
     ,   0.4024D-04, 0.6588D-04, 0.7492D-04, 0.4135D-04,-0.6708D-04,
     ,  -0.2664D-03,-0.5222D-03,-0.7060D-03,-0.6435D-03,-0.2399D-03,
     ,   0.3627D-03, 0.8592D-03, 0.1021D-02, 0.8561D-03, 0.5268D-03,
     ,   0.1853D-03,-0.9152D-04,-0.2966D-03,-0.4442D-03,-0.5568D-03,
     ,  -0.6408D-03,-0.7070D-03,-0.7571D-03,-0.7957D-03,-0.8272D-03,
     ,  -0.8487D-03,-0.8664D-03,-0.8784D-03,-0.8860D-03,-0.8927D-03,
     ,  -0.8972D-03,-0.9021D-03,-0.9035D-03,-0.9061D-03,-0.9072D-03,
     ,  -0.9081D-03,-0.9082D-03,-0.9086D-03,-0.9088D-03,-0.9087D-03,
     ,  -0.9091D-03,-0.9115D-03,-0.9115D-03/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.4149D-06,-0.5043D-06,-0.6093D-06,-0.7368D-06,-0.8947D-06,
     ,  -0.1083D-05,-0.1311D-05,-0.1590D-05,-0.1921D-05,-0.2319D-05,
     ,  -0.2828D-05,-0.3405D-05,-0.4101D-05,-0.4953D-05,-0.5978D-05,
     ,  -0.7178D-05,-0.8596D-05,-0.1027D-04,-0.1216D-04,-0.1430D-04,
     ,  -0.1669D-04,-0.1927D-04,-0.2182D-04,-0.2391D-04,-0.2548D-04,
     ,  -0.2551D-04,-0.2366D-04,-0.1817D-04,-0.8727D-05, 0.6218D-05,
     ,   0.2460D-04, 0.4243D-04, 0.5040D-04, 0.2927D-04,-0.4488D-04,
     ,  -0.1953D-03,-0.4143D-03,-0.6364D-03,-0.7186D-03,-0.5194D-03,
     ,  -0.2926D-04, 0.5511D-03, 0.9403D-03, 0.9973D-03, 0.7917D-03,
     ,   0.4850D-03, 0.2014D-03,-0.1428D-04,-0.1724D-03,-0.2834D-03,
     ,  -0.3679D-03,-0.4311D-03,-0.4825D-03,-0.5204D-03,-0.5522D-03,
     ,  -0.5740D-03,-0.5909D-03,-0.6028D-03,-0.6134D-03,-0.6208D-03,
     ,  -0.6242D-03,-0.6286D-03,-0.6324D-03,-0.6315D-03,-0.6325D-03,
     ,  -0.6349D-03,-0.6354D-03,-0.6357D-03,-0.6363D-03,-0.6362D-03,
     ,  -0.6362D-03,-0.6360D-03,-0.6364D-03/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.2594D-06,-0.3117D-06,-0.3799D-06,-0.4631D-06,-0.5580D-06,
     ,  -0.6759D-06,-0.8188D-06,-0.9905D-06,-0.1199D-05,-0.1445D-05,
     ,  -0.1742D-05,-0.2117D-05,-0.2583D-05,-0.3099D-05,-0.3729D-05,
     ,  -0.4483D-05,-0.5368D-05,-0.6386D-05,-0.7598D-05,-0.8974D-05,
     ,  -0.1047D-04,-0.1207D-04,-0.1394D-04,-0.1532D-04,-0.1637D-04,
     ,  -0.1683D-04,-0.1574D-04,-0.1358D-04,-0.8531D-05,-0.1634D-05,
     ,   0.7032D-05, 0.1427D-04, 0.1312D-04,-0.7585D-05,-0.6682D-04,
     ,  -0.1815D-03,-0.3604D-03,-0.5724D-03,-0.7351D-03,-0.7107D-03,
     ,  -0.4054D-03, 0.1203D-03, 0.6394D-03, 0.9230D-03, 0.9103D-03,
     ,   0.6995D-03, 0.4384D-03, 0.2101D-03, 0.4565D-04,-0.7376D-04,
     ,  -0.1565D-03,-0.2201D-03,-0.2668D-03,-0.3044D-03,-0.3324D-03,
     ,  -0.3564D-03,-0.3726D-03,-0.3873D-03,-0.3950D-03,-0.4022D-03,
     ,  -0.4086D-03,-0.4112D-03,-0.4128D-03,-0.4166D-03,-0.4181D-03,
     ,  -0.4163D-03,-0.4168D-03,-0.4191D-03,-0.4197D-03,-0.4196D-03,
     ,  -0.4196D-03,-0.4183D-03,-0.4202D-03/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.1479D-06,-0.1808D-06,-0.2172D-06,-0.2625D-06,-0.3200D-06,
     ,  -0.3881D-06,-0.4681D-06,-0.5682D-06,-0.6887D-06,-0.8346D-06,
     ,  -0.1017D-05,-0.1207D-05,-0.1462D-05,-0.1791D-05,-0.2124D-05,
     ,  -0.2565D-05,-0.3066D-05,-0.3697D-05,-0.4374D-05,-0.5178D-05,
     ,  -0.6053D-05,-0.6993D-05,-0.7817D-05,-0.8782D-05,-0.9655D-05,
     ,  -0.1014D-04,-0.1022D-04,-0.9152D-05,-0.7292D-05,-0.4818D-05,
     ,  -0.2470D-05,-0.2019D-05,-0.8691D-05,-0.2977D-04,-0.7717D-04,
     ,  -0.1660D-03,-0.3062D-03,-0.4930D-03,-0.6727D-03,-0.7682D-03,
     ,  -0.6596D-03,-0.3004D-03, 0.2045D-03, 0.6466D-03, 0.8443D-03,
     ,   0.7940D-03, 0.5991D-03, 0.3830D-03, 0.2057D-03, 0.8086D-04,
     ,  -0.5398D-05,-0.6768D-04,-0.1126D-03,-0.1502D-03,-0.1768D-03,
     ,  -0.1994D-03,-0.2153D-03,-0.2264D-03,-0.2388D-03,-0.2429D-03,
     ,  -0.2491D-03,-0.2527D-03,-0.2548D-03,-0.2559D-03,-0.2594D-03,
     ,  -0.2602D-03,-0.2607D-03,-0.2609D-03,-0.2614D-03,-0.2614D-03,
     ,  -0.2614D-03,-0.2642D-03,-0.2620D-03/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.8093D-07,-0.9661D-07,-0.1182D-06,-0.1418D-06,-0.1710D-06,
     ,  -0.2072D-06,-0.2524D-06,-0.3058D-06,-0.3657D-06,-0.4460D-06,
     ,  -0.5385D-06,-0.6665D-06,-0.7780D-06,-0.9512D-06,-0.1167D-05,
     ,  -0.1367D-05,-0.1664D-05,-0.1971D-05,-0.2355D-05,-0.2784D-05,
     ,  -0.3242D-05,-0.3790D-05,-0.4344D-05,-0.4900D-05,-0.5326D-05,
     ,  -0.5671D-05,-0.5695D-05,-0.5769D-05,-0.5262D-05,-0.4676D-05,
     ,  -0.4847D-05,-0.7491D-05,-0.1488D-04,-0.3318D-04,-0.6942D-04,
     ,  -0.1348D-03,-0.2383D-03,-0.3815D-03,-0.5523D-03,-0.6964D-03,
     ,  -0.7289D-03,-0.5683D-03,-0.2063D-03, 0.2414D-03, 0.5976D-03,
     ,   0.7310D-03, 0.6624D-03, 0.4953D-03, 0.3227D-03, 0.1886D-03,
     ,   0.9348D-04, 0.3155D-04,-0.1578D-04,-0.4701D-04,-0.7485D-04,
     ,  -0.9287D-04,-0.1111D-03,-0.1236D-03,-0.1299D-03,-0.1388D-03,
     ,  -0.1433D-03,-0.1486D-03,-0.1511D-03,-0.1527D-03,-0.1540D-03,
     ,  -0.1544D-03,-0.1554D-03,-0.1555D-03,-0.1561D-03,-0.1560D-03,
     ,  -0.1564D-03,-0.1562D-03,-0.1567D-03/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.4026D-07,-0.5006D-07,-0.6047D-07,-0.7326D-07,-0.8677D-07,
     ,  -0.1070D-06,-0.1270D-06,-0.1548D-06,-0.1900D-06,-0.2281D-06,
     ,  -0.2777D-06,-0.3320D-06,-0.4092D-06,-0.4723D-06,-0.5721D-06,
     ,  -0.7015D-06,-0.8548D-06,-0.1001D-05,-0.1191D-05,-0.1426D-05,
     ,  -0.1666D-05,-0.1939D-05,-0.2247D-05,-0.2517D-05,-0.2855D-05,
     ,  -0.3064D-05,-0.3188D-05,-0.3261D-05,-0.3449D-05,-0.3889D-05,
     ,  -0.4712D-05,-0.7383D-05,-0.1374D-04,-0.2708D-04,-0.5278D-04,
     ,  -0.9718D-04,-0.1689D-03,-0.2741D-03,-0.4097D-03,-0.5523D-03,
     ,  -0.6535D-03,-0.6474D-03,-0.4657D-03,-0.1313D-03, 0.2462D-03,
     ,   0.5180D-03, 0.6054D-03, 0.5352D-03, 0.3968D-03, 0.2621D-03,
     ,   0.1614D-03, 0.9172D-04, 0.4638D-04, 0.1261D-04,-0.1157D-04,
     ,  -0.3252D-04,-0.4502D-04,-0.5746D-04,-0.6715D-04,-0.7352D-04,
     ,  -0.7852D-04,-0.7992D-04,-0.8430D-04,-0.8607D-04,-0.8756D-04,
     ,  -0.8836D-04,-0.9097D-04,-0.8948D-04,-0.8994D-04,-0.9002D-04,
     ,  -0.9212D-04,-0.9043D-04,-0.9051D-04/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.1960D-07,-0.2352D-07,-0.2710D-07,-0.3364D-07,-0.4169D-07,
     ,  -0.5013D-07,-0.6187D-07,-0.7556D-07,-0.8844D-07,-0.1077D-06,
     ,  -0.1320D-06,-0.1617D-06,-0.1941D-06,-0.2391D-06,-0.2788D-06,
     ,  -0.3387D-06,-0.4018D-06,-0.4953D-06,-0.5792D-06,-0.6672D-06,
     ,  -0.7956D-06,-0.9417D-06,-0.1073D-05,-0.1250D-05,-0.1380D-05,
     ,  -0.1516D-05,-0.1737D-05,-0.1671D-05,-0.2144D-05,-0.2174D-05,
     ,  -0.3318D-05,-0.5521D-05,-0.9911D-05,-0.1886D-04,-0.3550D-04,
     ,  -0.6404D-04,-0.1108D-03,-0.1810D-03,-0.2770D-03,-0.3924D-03,
     ,  -0.5081D-03,-0.5759D-03,-0.5426D-03,-0.3696D-03,-0.7903D-04,
     ,   0.2266D-03, 0.4319D-03, 0.4852D-03, 0.4204D-03, 0.3099D-03,
     ,   0.2069D-03, 0.1312D-03, 0.8084D-04, 0.4729D-04, 0.2379D-04,
     ,   0.6836D-05,-0.8364D-05,-0.1846D-04,-0.2730D-04,-0.3395D-04,
     ,  -0.3845D-04,-0.4346D-04,-0.4493D-04,-0.4739D-04,-0.4770D-04,
     ,  -0.4993D-04,-0.4876D-04,-0.5127D-04,-0.5086D-04,-0.5181D-04,
     ,  -0.5032D-04,-0.5123D-04,-0.5171D-04/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.8320D-08,-0.1020D-07,-0.1244D-07,-0.1484D-07,-0.1964D-07,
     ,  -0.2223D-07,-0.2723D-07,-0.3152D-07,-0.3998D-07,-0.4719D-07,
     ,  -0.5715D-07,-0.6775D-07,-0.8204D-07,-0.1005D-06,-0.1191D-06,
     ,  -0.1508D-06,-0.1679D-06,-0.1934D-06,-0.2450D-06,-0.3179D-06,
     ,  -0.3466D-06,-0.3916D-06,-0.4535D-06,-0.5170D-06,-0.5538D-06,
     ,  -0.6253D-06,-0.6530D-06,-0.8021D-06,-0.7857D-06,-0.1248D-05,
     ,  -0.1962D-05,-0.3231D-05,-0.6283D-05,-0.1165D-04,-0.2174D-04,
     ,  -0.3931D-04,-0.6780D-04,-0.1118D-03,-0.1750D-03,-0.2579D-03,
     ,  -0.3527D-03,-0.4396D-03,-0.4838D-03,-0.4375D-03,-0.2836D-03,
     ,  -0.4323D-04, 0.1962D-03, 0.3481D-03, 0.3798D-03, 0.3239D-03,
     ,   0.2379D-03, 0.1600D-03, 0.1041D-03, 0.6736D-04, 0.4334D-04,
     ,   0.2598D-04, 0.1343D-04, 0.3501D-05,-0.4414D-05,-0.1031D-04,
     ,  -0.1528D-04,-0.1837D-04,-0.2121D-04,-0.2320D-04,-0.2480D-04,
     ,  -0.2550D-04,-0.2658D-04,-0.2664D-04,-0.2719D-04,-0.2724D-04,
     ,  -0.2773D-04,-0.2776D-04,-0.2776D-04/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.3754D-08,-0.4391D-08,-0.5267D-08,-0.6357D-08,-0.6893D-08,
     ,  -0.8875D-08,-0.1124D-07,-0.1406D-07,-0.1760D-07,-0.2199D-07,
     ,  -0.2338D-07,-0.2841D-07,-0.3472D-07,-0.4098D-07,-0.5221D-07,
     ,  -0.5893D-07,-0.7876D-07,-0.1032D-06,-0.1140D-06,-0.1104D-06,
     ,  -0.1549D-06,-0.1555D-06,-0.2115D-06,-0.1967D-06,-0.2587D-06,
     ,  -0.2750D-06,-0.2812D-06,-0.3191D-06,-0.4577D-06,-0.6966D-06,
     ,  -0.8487D-06,-0.1880D-05,-0.3467D-05,-0.6796D-05,-0.1286D-04,
     ,  -0.2296D-04,-0.4017D-04,-0.6638D-04,-0.1051D-03,-0.1588D-03,
     ,  -0.2264D-03,-0.3008D-03,-0.3641D-03,-0.3897D-03,-0.3435D-03,
     ,  -0.2122D-03,-0.2183D-04, 0.1617D-03, 0.2730D-03, 0.2909D-03,
     ,   0.2446D-03, 0.1785D-03, 0.1206D-03, 0.7969D-04, 0.5303D-04,
     ,   0.3570D-04, 0.2334D-04, 0.1406D-04, 0.6991D-05, 0.1284D-05,
     ,  -0.3177D-05,-0.6503D-05,-0.9022D-05,-0.1072D-04,-0.1214D-04,
     ,  -0.1313D-04,-0.1403D-04,-0.1436D-04,-0.1470D-04,-0.1513D-04,
     ,  -0.1530D-04,-0.1542D-04,-0.1533D-04/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.8303D-09,-0.1170D-08,-0.1335D-08,-0.1584D-08,-0.2060D-08,
     ,  -0.2519D-08,-0.2825D-08,-0.2568D-08,-0.2334D-08,-0.3325D-08,
     ,  -0.8266D-08,-0.8288D-08,-0.8925D-08,-0.1229D-07,-0.1063D-07,
     ,  -0.1567D-07,-0.1851D-07,-0.1643D-07,-0.1341D-07,-0.2583D-07,
     ,  -0.6947D-08,-0.3541D-07,-0.2792D-07,-0.6013D-07,-0.3915D-07,
     ,  -0.4077D-07,-0.3928D-07,-0.5530D-07,-0.7622D-07,-0.1816D-06,
     ,  -0.5515D-06,-0.1005D-05,-0.1907D-05,-0.3840D-05,-0.6915D-05,
     ,  -0.1273D-04,-0.2223D-04,-0.3758D-04,-0.6026D-04,-0.9280D-04,
     ,  -0.1364D-03,-0.1894D-03,-0.2460D-03,-0.2918D-03,-0.3053D-03,
     ,  -0.2631D-03,-0.1562D-03,-0.8000D-05, 0.1298D-03, 0.2099D-03,
     ,   0.2196D-03, 0.1830D-03, 0.1325D-03, 0.8984D-04, 0.6008D-04,
     ,   0.4075D-04, 0.2837D-04, 0.1957D-04, 0.1285D-04, 0.7794D-05,
     ,   0.3721D-05, 0.6417D-06,-0.1849D-05,-0.3620D-05,-0.5027D-05,
     ,  -0.6003D-05,-0.6490D-05,-0.7241D-05,-0.7593D-05,-0.7651D-05,
     ,  -0.7827D-05,-0.7938D-05,-0.8234D-05/
      data (calcpts(j,36), j = 1,neta) /
     ,   0.3606D-09, 0.3827D-09, 0.5480D-09, 0.5174D-09, 0.6868D-09,
     ,   0.8359D-09, 0.9401D-09, 0.8792D-09, 0.1069D-08, 0.9310D-09,
     ,   0.3162D-08, 0.2546D-08, 0.3619D-08, 0.3797D-08, 0.4754D-08,
     ,   0.7667D-08, 0.9278D-08, 0.6572D-08, 0.1031D-07, 0.1330D-07,
     ,   0.1687D-08,-0.5457D-09, 0.2620D-07, 0.5762D-07, 0.5761D-07,
     ,   0.6273D-07, 0.7879D-07, 0.9290D-07, 0.5882D-07, 0.5374D-07,
     ,  -0.2885D-07,-0.2608D-06,-0.8459D-06,-0.1684D-05,-0.3572D-05,
     ,  -0.6849D-05,-0.1189D-04,-0.2036D-04,-0.3326D-04,-0.5229D-04,
     ,  -0.7848D-04,-0.1126D-03,-0.1533D-03,-0.1955D-03,-0.2280D-03,
     ,  -0.2343D-03,-0.1978D-03,-0.1137D-03,-0.2413D-06, 0.1022D-03,
     ,   0.1595D-03, 0.1641D-03, 0.1355D-03, 0.9777D-04, 0.6616D-04,
     ,   0.4471D-04, 0.3071D-04, 0.2179D-04, 0.1553D-04, 0.1095D-04,
     ,   0.7245D-05, 0.4217D-05, 0.1963D-05, 0.2396D-06,-0.9538D-06,
     ,  -0.1796D-05,-0.2520D-05,-0.3019D-05,-0.3375D-05,-0.3854D-05,
     ,  -0.4026D-05,-0.4146D-05,-0.4025D-05/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.5214D-09, 0.7114D-09, 0.7981D-09, 0.1190D-08, 0.1095D-08,
     ,   0.1593D-08, 0.1901D-08, 0.2262D-08, 0.2777D-08, 0.3855D-08,
     ,   0.4133D-08, 0.6401D-08, 0.5179D-08, 0.7057D-08, 0.7872D-08,
     ,   0.1038D-07, 0.1066D-07, 0.1593D-07, 0.1780D-07, 0.2178D-07,
     ,   0.3284D-07, 0.5436D-07, 0.4625D-07, 0.5072D-07, 0.6783D-07,
     ,   0.8186D-07, 0.1053D-06, 0.9452D-07, 0.1420D-06, 0.1009D-06,
     ,   0.5298D-07,-0.5607D-07,-0.3075D-06,-0.8613D-06,-0.1878D-05,
     ,  -0.3502D-05,-0.6432D-05,-0.1089D-04,-0.1809D-04,-0.2868D-04,
     ,  -0.4388D-04,-0.6428D-04,-0.9032D-04,-0.1209D-03,-0.1518D-03,
     ,  -0.1745D-03,-0.1770D-03,-0.1469D-03,-0.8228D-04, 0.3077D-05,
     ,   0.7834D-04, 0.1192D-03, 0.1210D-03, 0.9899D-04, 0.7120D-04,
     ,   0.4822D-04, 0.3266D-04, 0.2286D-04, 0.1646D-04, 0.1182D-04,
     ,   0.8524D-05, 0.5818D-05, 0.3826D-05, 0.2350D-05, 0.1138D-05,
     ,  -0.9973D-07,-0.6009D-06,-0.1155D-05,-0.1515D-05,-0.1535D-05,
     ,  -0.1710D-05,-0.1831D-05,-0.2174D-05/
      data (calcpts(j,38), j = 1,neta) /
     ,   0.6629D-09, 0.8987D-09, 0.1033D-08, 0.1246D-08, 0.1358D-08,
     ,   0.1565D-08, 0.1825D-08, 0.2433D-08, 0.3176D-08, 0.3679D-08,
     ,   0.4236D-08, 0.4068D-08, 0.6617D-08, 0.8862D-08, 0.1024D-07,
     ,   0.1029D-07, 0.1529D-07, 0.1839D-07, 0.2250D-07, 0.2503D-07,
     ,   0.3291D-07, 0.3496D-07, 0.4640D-07, 0.4929D-07, 0.7219D-07,
     ,   0.8218D-07, 0.9862D-07, 0.1159D-06, 0.1223D-06, 0.1507D-06,
     ,   0.1259D-06, 0.6346D-07,-0.4683D-07,-0.2961D-06,-0.7823D-06,
     ,  -0.1665D-05,-0.3170D-05,-0.5697D-05,-0.9564D-05,-0.1521D-04,
     ,  -0.2359D-04,-0.3555D-04,-0.5122D-04,-0.7075D-04,-0.9328D-04,
     ,  -0.1159D-03,-0.1319D-03,-0.1319D-03,-0.1079D-03,-0.5853D-04,
     ,   0.4624D-05, 0.5956D-04, 0.8860D-04, 0.8893D-04, 0.7209D-04,
     ,   0.5154D-04, 0.3491D-04, 0.2353D-04, 0.1665D-04, 0.1191D-04,
     ,   0.8905D-05, 0.6550D-05, 0.4620D-05, 0.3179D-05, 0.1986D-05,
     ,   0.1227D-05, 0.4962D-06,-0.2612D-07,-0.3943D-06,-0.6624D-06,
     ,  -0.8598D-06,-0.9829D-06,-0.1063D-05/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.6672D-09, 0.6646D-09, 0.9368D-09, 0.1064D-08, 0.1623D-08,
     ,   0.1722D-08, 0.2251D-08, 0.2642D-08, 0.2910D-08, 0.3700D-08,
     ,   0.4505D-08, 0.5558D-08, 0.6639D-08, 0.6368D-08, 0.9205D-08,
     ,   0.1370D-07, 0.1331D-07, 0.1800D-07, 0.2034D-07, 0.2752D-07,
     ,   0.3095D-07, 0.3924D-07, 0.4395D-07, 0.5577D-07, 0.6671D-07,
     ,   0.7691D-07, 0.8396D-07, 0.1207D-06, 0.1166D-06, 0.1392D-06,
     ,   0.1667D-06, 0.1473D-06, 0.1102D-06,-0.8770D-08,-0.2585D-06,
     ,  -0.7137D-06,-0.1489D-05,-0.2760D-05,-0.4794D-05,-0.7927D-05,
     ,  -0.1251D-04,-0.1892D-04,-0.2798D-04,-0.3963D-04,-0.5436D-04,
     ,  -0.7078D-04,-0.8702D-04,-0.9815D-04,-0.9743D-04,-0.7897D-04,
     ,  -0.4166D-04, 0.4934D-05, 0.4501D-04, 0.6523D-04, 0.6494D-04,
     ,   0.5233D-04, 0.3728D-04, 0.2526D-04, 0.1708D-04, 0.1222D-04,
     ,   0.8824D-05, 0.6608D-05, 0.4964D-05, 0.3599D-05, 0.2481D-05,
     ,   0.1677D-05, 0.9943D-06, 0.6812D-06, 0.3143D-06, 0.6832D-07,
     ,  -0.1178D-06,-0.2474D-06,-0.3506D-06/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.4488D-09, 0.5854D-09, 0.7302D-09, 0.7851D-09, 0.8090D-09,
     ,   0.1299D-08, 0.1363D-08, 0.1627D-08, 0.2210D-08, 0.2590D-08,
     ,   0.3094D-08, 0.3936D-08, 0.4513D-08, 0.5900D-08, 0.7073D-08,
     ,   0.6639D-08, 0.1103D-07, 0.9881D-08, 0.1367D-07, 0.1713D-07,
     ,   0.2133D-07, 0.2618D-07, 0.3154D-07, 0.3843D-07, 0.4464D-07,
     ,   0.5524D-07, 0.7233D-07, 0.8380D-07, 0.9451D-07, 0.1210D-06,
     ,   0.1017D-06, 0.1120D-06, 0.1126D-06, 0.3706D-07,-0.8393D-07,
     ,  -0.3081D-06,-0.7089D-06,-0.1380D-05,-0.2413D-05,-0.4094D-05,
     ,  -0.6520D-05,-0.1008D-04,-0.1500D-04,-0.2170D-04,-0.3034D-04,
     ,  -0.4124D-04,-0.5308D-04,-0.6481D-04,-0.7253D-04,-0.7136D-04,
     ,  -0.5743D-04,-0.2961D-04, 0.4315D-05, 0.3326D-04, 0.4762D-04,
     ,   0.4694D-04, 0.3761D-04, 0.2665D-04, 0.1796D-04, 0.1217D-04,
     ,   0.8641D-05, 0.6320D-05, 0.4693D-05, 0.3434D-05, 0.2585D-05,
     ,   0.1868D-05, 0.1314D-05, 0.8418D-06, 0.5394D-06, 0.2719D-06,
     ,   0.8887D-07,-0.5843D-07,-0.6355D-07/
      data (calcpts(j,41), j = 1,neta) /
     ,   0.4014D-09, 0.4477D-09, 0.5452D-09, 0.6880D-09, 0.8749D-09,
     ,   0.9164D-09, 0.1275D-08, 0.1443D-08, 0.1873D-08, 0.2145D-08,
     ,   0.2587D-08, 0.2983D-08, 0.3939D-08, 0.4523D-08, 0.5585D-08,
     ,   0.7201D-08, 0.7426D-08, 0.1141D-07, 0.1466D-07, 0.1365D-07,
     ,   0.1719D-07, 0.2067D-07, 0.2743D-07, 0.3212D-07, 0.3682D-07,
     ,   0.4614D-07, 0.5658D-07, 0.6507D-07, 0.8896D-07, 0.7884D-07,
     ,   0.1073D-06, 0.1254D-06, 0.9897D-07, 0.8080D-07, 0.4516D-07,
     ,  -0.5851D-07,-0.2743D-06,-0.6211D-06,-0.1163D-05,-0.1992D-05,
     ,  -0.3299D-05,-0.5167D-05,-0.7806D-05,-0.1157D-04,-0.1652D-04,
     ,  -0.2290D-04,-0.3077D-04,-0.3947D-04,-0.4770D-04,-0.5317D-04,
     ,  -0.5181D-04,-0.4132D-04,-0.2108D-04, 0.3801D-05, 0.2455D-04,
     ,   0.3467D-04, 0.3392D-04, 0.2702D-04, 0.1909D-04, 0.1285D-04,
     ,   0.8711D-05, 0.6166D-05, 0.4551D-05, 0.3420D-05, 0.2561D-05,
     ,   0.1888D-05, 0.1358D-05, 0.9512D-06, 0.6301D-06, 0.4194D-06,
     ,   0.2569D-06, 0.1336D-06, 0.2288D-07/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.3388D-09, 0.3860D-09, 0.4991D-09, 0.5667D-09, 0.6674D-09,
     ,   0.8444D-09, 0.1011D-08, 0.1133D-08, 0.1437D-08, 0.1903D-08,
     ,   0.2374D-08, 0.2757D-08, 0.2965D-08, 0.3918D-08, 0.4684D-08,
     ,   0.5429D-08, 0.6781D-08, 0.7984D-08, 0.8061D-08, 0.1302D-07,
     ,   0.1597D-07, 0.1901D-07, 0.2149D-07, 0.2509D-07, 0.3268D-07,
     ,   0.3866D-07, 0.4510D-07, 0.5435D-07, 0.6067D-07, 0.7802D-07,
     ,   0.9562D-07, 0.8050D-07, 0.9470D-07, 0.1105D-06, 0.7213D-07,
     ,   0.1413D-07,-0.5554D-07,-0.2072D-06,-0.5105D-06,-0.9407D-06,
     ,  -0.1602D-05,-0.2584D-05,-0.4011D-05,-0.5998D-05,-0.8733D-05,
     ,  -0.1242D-04,-0.1705D-04,-0.2273D-04,-0.2902D-04,-0.3491D-04,
     ,  -0.3866D-04,-0.3760D-04,-0.2961D-04,-0.1482D-04, 0.3160D-05,
     ,   0.1802D-04, 0.2512D-04, 0.2444D-04, 0.1934D-04, 0.1362D-04,
     ,   0.9143D-05, 0.6212D-05, 0.4401D-05, 0.3260D-05, 0.2451D-05,
     ,   0.1864D-05, 0.1385D-05, 0.1009D-05, 0.7443D-06, 0.4927D-06,
     ,   0.3286D-06, 0.2231D-06, 0.1480D-06/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.1931D-09, 0.2789D-09, 0.2899D-09, 0.3985D-09, 0.4501D-09,
     ,   0.5806D-09, 0.7158D-09, 0.9687D-09, 0.1022D-08, 0.1215D-08,
     ,   0.1457D-08, 0.1621D-08, 0.2194D-08, 0.2592D-08, 0.3207D-08,
     ,   0.4219D-08, 0.5007D-08, 0.5777D-08, 0.7498D-08, 0.7287D-08,
     ,   0.9144D-08, 0.1063D-07, 0.1462D-07, 0.1945D-07, 0.2161D-07,
     ,   0.2716D-07, 0.3051D-07, 0.3996D-07, 0.4586D-07, 0.5403D-07,
     ,   0.6261D-07, 0.7531D-07, 0.9238D-07, 0.7409D-07, 0.6798D-07,
     ,   0.5928D-07, 0.1493D-07,-0.6765D-07,-0.2176D-06,-0.4483D-06,
     ,  -0.7963D-06,-0.1293D-05,-0.2028D-05,-0.3073D-05,-0.4540D-05,
     ,  -0.6535D-05,-0.9213D-05,-0.1259D-04,-0.1670D-04,-0.2122D-04,
     ,  -0.2543D-04,-0.2800D-04,-0.2714D-04,-0.2121D-04,-0.1047D-04,
     ,   0.2531D-05, 0.1313D-04, 0.1810D-04, 0.1752D-04, 0.1381D-04,
     ,   0.9690D-05, 0.6486D-05, 0.4397D-05, 0.3118D-05, 0.2315D-05,
     ,   0.1726D-05, 0.1321D-05, 0.9860D-06, 0.7098D-06, 0.5287D-06,
     ,   0.3716D-06, 0.2615D-06, 0.1471D-06/
      data (calcpts(j,44), j = 1,neta) /
     ,   0.1495D-09, 0.2214D-09, 0.2923D-09, 0.3265D-09, 0.3866D-09,
     ,   0.4279D-09, 0.5099D-09, 0.6073D-09, 0.7940D-09, 0.9137D-09,
     ,   0.9941D-09, 0.1471D-08, 0.1902D-08, 0.1996D-08, 0.2472D-08,
     ,   0.2732D-08, 0.3383D-08, 0.4493D-08, 0.5252D-08, 0.6561D-08,
     ,   0.8072D-08, 0.1042D-07, 0.1040D-07, 0.1496D-07, 0.1740D-07,
     ,   0.2004D-07, 0.2597D-07, 0.2825D-07, 0.3410D-07, 0.4008D-07,
     ,   0.4731D-07, 0.5573D-07, 0.5982D-07, 0.6937D-07, 0.8423D-07,
     ,   0.7479D-07, 0.4305D-07,-0.9894D-08,-0.5251D-07,-0.1513D-06,
     ,  -0.3413D-06,-0.6144D-06,-0.1005D-05,-0.1532D-05,-0.2343D-05,
     ,  -0.3385D-05,-0.4869D-05,-0.6807D-05,-0.9239D-05,-0.1217D-04,
     ,  -0.1542D-04,-0.1842D-04,-0.2018D-04,-0.1951D-04,-0.1516D-04,
     ,  -0.7366D-05, 0.1956D-05, 0.9537D-05, 0.1303D-04, 0.1251D-04,
     ,   0.9827D-05, 0.6879D-05, 0.4588D-05, 0.3107D-05, 0.2198D-05,
     ,   0.1631D-05, 0.1243D-05, 0.9344D-06, 0.7147D-06, 0.5177D-06,
     ,   0.3828D-06, 0.2563D-06, 0.1911D-06/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.6953D-10, 0.2975D-10, 0.7771D-10, 0.1621D-09, 0.2485D-09,
     ,   0.3080D-09, 0.3891D-09, 0.4644D-09, 0.5551D-09, 0.7397D-09,
     ,   0.9304D-09, 0.1120D-08, 0.1125D-08, 0.1730D-08, 0.2131D-08,
     ,   0.2455D-08, 0.2855D-08, 0.3231D-08, 0.4086D-08, 0.5239D-08,
     ,   0.6090D-08, 0.7281D-08, 0.8982D-08, 0.9123D-08, 0.1296D-07,
     ,   0.1585D-07, 0.1847D-07, 0.2422D-07, 0.2827D-07, 0.3339D-07,
     ,   0.3865D-07, 0.4587D-07, 0.5247D-07, 0.5923D-07, 0.6010D-07,
     ,   0.5872D-07, 0.5778D-07, 0.4192D-07, 0.3459D-09,-0.6628D-07,
     ,  -0.1258D-06,-0.2611D-06,-0.4611D-06,-0.7619D-06,-0.1142D-05,
     ,  -0.1725D-05,-0.2488D-05,-0.3551D-05,-0.4966D-05,-0.6725D-05,
     ,  -0.8833D-05,-0.1112D-04,-0.1328D-04,-0.1449D-04,-0.1393D-04,
     ,  -0.1082D-04,-0.5116D-05, 0.1521D-05, 0.6911D-05, 0.9362D-05,
     ,   0.8942D-05, 0.6989D-05, 0.4880D-05, 0.3262D-05, 0.2206D-05,
     ,   0.1578D-05, 0.1156D-05, 0.8874D-06, 0.6599D-06, 0.5156D-06,
     ,   0.3687D-06, 0.2697D-06, 0.1990D-06/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.7984D-10, 0.1571D-09, 0.1858D-09, 0.1463D-09, 0.1500D-09,
     ,   0.2410D-09, 0.3056D-09, 0.3626D-09, 0.4215D-09, 0.4703D-09,
     ,   0.5624D-09, 0.7141D-09, 0.8839D-09, 0.9298D-09, 0.1128D-08,
     ,   0.1680D-08, 0.2025D-08, 0.2401D-08, 0.2527D-08, 0.3115D-08,
     ,   0.4058D-08, 0.4981D-08, 0.5831D-08, 0.7318D-08, 0.8230D-08,
     ,   0.8898D-08, 0.1289D-07, 0.1271D-07, 0.1665D-07, 0.2275D-07,
     ,   0.2571D-07, 0.2834D-07, 0.3425D-07, 0.3830D-07, 0.4074D-07,
     ,   0.4231D-07, 0.3955D-07, 0.3448D-07, 0.1752D-07,-0.8118D-08,
     ,  -0.5822D-07,-0.1235D-06,-0.2219D-06,-0.3657D-06,-0.5784D-06,
     ,  -0.8731D-06,-0.1288D-05,-0.1852D-05,-0.2607D-05,-0.3605D-05,
     ,  -0.4867D-05,-0.6407D-05,-0.8028D-05,-0.9536D-05,-0.1039D-04,
     ,  -0.9954D-05,-0.7699D-05,-0.3618D-05, 0.1117D-05, 0.4941D-05,
     ,   0.6671D-05, 0.6354D-05, 0.4950D-05, 0.3435D-05, 0.2289D-05,
     ,   0.1539D-05, 0.1093D-05, 0.8067D-06, 0.6150D-06, 0.4533D-06,
     ,   0.3510D-06, 0.2634D-06, 0.1880D-06/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.1068D-09, 0.1197D-09, 0.1325D-09, 0.1628D-09, 0.1779D-09,
     ,   0.1962D-09, 0.1658D-09, 0.2447D-09, 0.2974D-09, 0.3878D-09,
     ,   0.4254D-09, 0.4971D-09, 0.6415D-09, 0.7792D-09, 0.9808D-09,
     ,   0.9914D-09, 0.1250D-08, 0.1479D-08, 0.2250D-08, 0.2287D-08,
     ,   0.2957D-08, 0.3439D-08, 0.4432D-08, 0.5144D-08, 0.6628D-08,
     ,   0.7827D-08, 0.9289D-08, 0.1270D-07, 0.1479D-07, 0.1523D-07,
     ,   0.1978D-07, 0.2047D-07, 0.2514D-07, 0.2966D-07, 0.3057D-07,
     ,   0.3549D-07, 0.3513D-07, 0.3152D-07, 0.2763D-07, 0.1512D-07,
     ,  -0.6697D-08,-0.4066D-07,-0.9049D-07,-0.1645D-06,-0.2717D-06,
     ,  -0.4263D-06,-0.6376D-06,-0.9364D-06,-0.1345D-05,-0.1895D-05,
     ,  -0.2614D-05,-0.3514D-05,-0.4591D-05,-0.5782D-05,-0.6849D-05,
     ,  -0.7434D-05,-0.7111D-05,-0.5451D-05,-0.2548D-05, 0.8742D-06,
     ,   0.3567D-05, 0.4763D-05, 0.4516D-05, 0.3506D-05, 0.2429D-05,
     ,   0.1611D-05, 0.1088D-05, 0.7695D-06, 0.5719D-06, 0.4344D-06,
     ,   0.3274D-06, 0.2446D-06, 0.1809D-06/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.8784D-11,-0.8812D-10, 0.8179D-10, 0.7976D-10, 0.9617D-10,
     ,   0.7867D-10, 0.1220D-09, 0.1645D-09, 0.2339D-09, 0.2419D-09,
     ,   0.3491D-09, 0.4087D-09, 0.4888D-09, 0.5817D-09, 0.7130D-09,
     ,   0.8926D-09, 0.9765D-09, 0.1392D-08, 0.1289D-08, 0.2009D-08,
     ,   0.2093D-08, 0.2718D-08, 0.3210D-08, 0.4105D-08, 0.4766D-08,
     ,   0.5876D-08, 0.7107D-08, 0.8233D-08, 0.9910D-08, 0.1107D-07,
     ,   0.1382D-07, 0.1888D-07, 0.2018D-07, 0.2201D-07, 0.2585D-07,
     ,   0.2761D-07, 0.2803D-07, 0.3092D-07, 0.2723D-07, 0.2252D-07,
     ,   0.1164D-07,-0.3762D-08,-0.2879D-07,-0.6970D-07,-0.1233D-06,
     ,  -0.2000D-06,-0.3109D-06,-0.4670D-06,-0.6790D-06,-0.9700D-06,
     ,  -0.1364D-05,-0.1878D-05,-0.2529D-05,-0.3294D-05,-0.4122D-05,
     ,  -0.4872D-05,-0.5300D-05,-0.5062D-05,-0.3846D-05,-0.1780D-05,
     ,   0.6382D-06, 0.2554D-05, 0.3392D-05, 0.3206D-05, 0.2482D-05,
     ,   0.1717D-05, 0.1139D-05, 0.7689D-06, 0.5425D-06, 0.4039D-06,
     ,   0.3068D-06, 0.2350D-06, 0.1767D-06/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.1218D-08, 0.1375D-08, 0.1849D-08, 0.2001D-08, 0.2611D-08,
     ,   0.3064D-08, 0.3686D-08, 0.4371D-08, 0.5328D-08, 0.6477D-08,
     ,   0.7854D-08, 0.9506D-08, 0.1151D-07, 0.1392D-07, 0.1685D-07,
     ,   0.2043D-07, 0.2479D-07, 0.2997D-07, 0.3646D-07, 0.4396D-07,
     ,   0.5350D-07, 0.6466D-07, 0.7805D-07, 0.9452D-07, 0.1143D-06,
     ,   0.1383D-06, 0.1669D-06, 0.2011D-06, 0.2419D-06, 0.2904D-06,
     ,   0.3455D-06, 0.4101D-06, 0.4844D-06, 0.5638D-06, 0.6480D-06,
     ,   0.7301D-06, 0.8116D-06, 0.8824D-06, 0.9447D-06, 0.9963D-06,
     ,   0.1035D-05, 0.1059D-05, 0.1077D-05, 0.1087D-05, 0.1084D-05,
     ,   0.1073D-05, 0.1053D-05, 0.1020D-05, 0.9686D-06, 0.8978D-06,
     ,   0.8003D-06, 0.6665D-06, 0.4928D-06, 0.2635D-06,-0.1815D-07,
     ,  -0.3311D-06,-0.6204D-06,-0.7882D-06,-0.7024D-06,-0.2153D-06,
     ,   0.6424D-06, 0.1612D-05, 0.2302D-05, 0.2463D-05, 0.2160D-05,
     ,   0.1649D-05, 0.1167D-05, 0.8091D-06, 0.5737D-06, 0.4183D-06,
     ,   0.3127D-06, 0.2348D-06, 0.1766D-06/



      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c---------------------
      subroutine clhqg21m(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.3797D-09, 0.4615D-09, 0.5588D-09, 0.6770D-09, 0.8192D-09,
     ,   0.9916D-09, 0.1200D-08, 0.1452D-08, 0.1756D-08, 0.2120D-08,
     ,   0.2556D-08, 0.3080D-08, 0.3693D-08, 0.4432D-08, 0.5296D-08,
     ,   0.6242D-08, 0.7311D-08, 0.8422D-08, 0.9503D-08, 0.1030D-07,
     ,   0.1050D-07, 0.9418D-08, 0.5995D-08,-0.1552D-08,-0.1611D-07,
     ,  -0.4149D-07,-0.8473D-07,-0.1539D-06,-0.2594D-06,-0.4105D-06,
     ,  -0.6099D-06,-0.8432D-06,-0.1066D-05,-0.1199D-05,-0.1140D-05,
     ,  -0.8328D-06,-0.3069D-06, 0.3031D-06, 0.8435D-06, 0.1216D-05,
     ,   0.1416D-05, 0.1494D-05, 0.1506D-05, 0.1491D-05, 0.1472D-05,
     ,   0.1456D-05, 0.1447D-05, 0.1440D-05, 0.1435D-05, 0.1434D-05,
     ,   0.1433D-05, 0.1431D-05, 0.1433D-05, 0.1431D-05, 0.1432D-05,
     ,   0.1433D-05, 0.1432D-05, 0.1433D-05, 0.1431D-05, 0.1433D-05,
     ,   0.1432D-05, 0.1432D-05, 0.1432D-05, 0.1432D-05, 0.1432D-05,
     ,   0.1431D-05, 0.1431D-05, 0.1431D-05, 0.1431D-05, 0.1431D-05,
     ,   0.1431D-05, 0.1431D-05, 0.1431D-05/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.2570D-10,-0.3069D-10,-0.3729D-10,-0.4665D-10,-0.5682D-10,
     ,  -0.7047D-10,-0.8798D-10,-0.1092D-09,-0.1366D-09,-0.1766D-09,
     ,  -0.2302D-09,-0.3061D-09,-0.4220D-09,-0.6018D-09,-0.8616D-09,
     ,  -0.1293D-08,-0.1965D-08,-0.3079D-08,-0.4891D-08,-0.7896D-08,
     ,  -0.1283D-07,-0.2103D-07,-0.3457D-07,-0.5671D-07,-0.9275D-07,
     ,  -0.1508D-06,-0.2429D-06,-0.3858D-06,-0.6003D-06,-0.9086D-06,
     ,  -0.1324D-05,-0.1832D-05,-0.2368D-05,-0.2794D-05,-0.2929D-05,
     ,  -0.2633D-05,-0.1915D-05,-0.9596D-06,-0.2386D-07, 0.7107D-06,
     ,   0.1204D-05, 0.1504D-05, 0.1681D-05, 0.1792D-05, 0.1870D-05,
     ,   0.1928D-05, 0.1974D-05, 0.2008D-05, 0.2034D-05, 0.2053D-05,
     ,   0.2068D-05, 0.2078D-05, 0.2086D-05, 0.2091D-05, 0.2095D-05,
     ,   0.2097D-05, 0.2099D-05, 0.2100D-05, 0.2100D-05, 0.2102D-05,
     ,   0.2102D-05, 0.2102D-05, 0.2102D-05, 0.2103D-05, 0.2103D-05,
     ,   0.2102D-05, 0.2102D-05, 0.2102D-05, 0.2102D-05, 0.2102D-05,
     ,   0.2102D-05, 0.2102D-05, 0.2102D-05/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1194D-10, 0.1263D-10, 0.1579D-10, 0.1681D-10, 0.1958D-10,
     ,   0.2226D-10, 0.2346D-10, 0.2470D-10, 0.2354D-10, 0.1351D-10,
     ,  -0.4515D-11,-0.4626D-10,-0.1187D-09,-0.2932D-09,-0.5737D-09,
     ,  -0.1016D-08,-0.1823D-08,-0.3212D-08,-0.5613D-08,-0.9668D-08,
     ,  -0.1650D-07,-0.2795D-07,-0.4712D-07,-0.7871D-07,-0.1301D-06,
     ,  -0.2142D-06,-0.3467D-06,-0.5528D-06,-0.8623D-06,-0.1308D-05,
     ,  -0.1907D-05,-0.2640D-05,-0.3410D-05,-0.4012D-05,-0.4194D-05,
     ,  -0.3744D-05,-0.2687D-05,-0.1290D-05, 0.6871D-07, 0.1130D-05,
     ,   0.1838D-05, 0.2264D-05, 0.2510D-05, 0.2662D-05, 0.2770D-05,
     ,   0.2849D-05, 0.2908D-05, 0.2955D-05, 0.2992D-05, 0.3018D-05,
     ,   0.3038D-05, 0.3053D-05, 0.3060D-05, 0.3070D-05, 0.3075D-05,
     ,   0.3077D-05, 0.3080D-05, 0.3081D-05, 0.3084D-05, 0.3084D-05,
     ,   0.3084D-05, 0.3084D-05, 0.3084D-05, 0.3086D-05, 0.3086D-05,
     ,   0.3087D-05, 0.3087D-05, 0.3087D-05, 0.3087D-05, 0.3087D-05,
     ,   0.3087D-05, 0.3087D-05, 0.3087D-05/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.1069D-10, 0.1439D-10, 0.1862D-10, 0.2131D-10, 0.2297D-10,
     ,   0.2654D-10, 0.3158D-10, 0.2658D-10, 0.2280D-10,-0.2692D-11,
     ,  -0.3067D-10,-0.9682D-10,-0.2296D-09,-0.4412D-09,-0.8242D-09,
     ,  -0.1515D-08,-0.2761D-08,-0.4797D-08,-0.8285D-08,-0.1427D-07,
     ,  -0.2439D-07,-0.4107D-07,-0.6906D-07,-0.1157D-06,-0.1915D-06,
     ,  -0.3138D-06,-0.5084D-06,-0.8103D-06,-0.1264D-05,-0.1919D-05,
     ,  -0.2795D-05,-0.3874D-05,-0.4998D-05,-0.5890D-05,-0.6153D-05,
     ,  -0.5498D-05,-0.3949D-05,-0.1903D-05, 0.9182D-07, 0.1653D-05,
     ,   0.2689D-05, 0.3311D-05, 0.3680D-05, 0.3904D-05, 0.4055D-05,
     ,   0.4172D-05, 0.4261D-05, 0.4331D-05, 0.4385D-05, 0.4425D-05,
     ,   0.4453D-05, 0.4473D-05, 0.4490D-05, 0.4499D-05, 0.4507D-05,
     ,   0.4512D-05, 0.4515D-05, 0.4519D-05, 0.4519D-05, 0.4520D-05,
     ,   0.4520D-05, 0.4523D-05, 0.4523D-05, 0.4521D-05, 0.4521D-05,
     ,   0.4523D-05, 0.4523D-05, 0.4523D-05, 0.4523D-05, 0.4523D-05,
     ,   0.4523D-05, 0.4523D-05, 0.4523D-05/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.1991D-10, 0.1908D-10, 0.2457D-10, 0.2884D-10, 0.3677D-10,
     ,   0.3975D-10, 0.5399D-10, 0.3017D-10, 0.1535D-10, 0.6691D-11,
     ,  -0.6459D-10,-0.1321D-09,-0.3194D-09,-0.6775D-09,-0.1247D-08,
     ,  -0.2270D-08,-0.4046D-08,-0.7078D-08,-0.1210D-07,-0.2086D-07,
     ,  -0.3553D-07,-0.6025D-07,-0.1016D-06,-0.1691D-06,-0.2804D-06,
     ,  -0.4600D-06,-0.7452D-06,-0.1187D-05,-0.1852D-05,-0.2809D-05,
     ,  -0.4100D-05,-0.5673D-05,-0.7327D-05,-0.8632D-05,-0.9025D-05,
     ,  -0.8069D-05,-0.5795D-05,-0.2799D-05, 0.1330D-06, 0.2423D-05,
     ,   0.3942D-05, 0.4859D-05, 0.5391D-05, 0.5723D-05, 0.5949D-05,
     ,   0.6120D-05, 0.6251D-05, 0.6351D-05, 0.6429D-05, 0.6485D-05,
     ,   0.6530D-05, 0.6560D-05, 0.6583D-05, 0.6598D-05, 0.6607D-05,
     ,   0.6617D-05, 0.6622D-05, 0.6623D-05, 0.6627D-05, 0.6628D-05,
     ,   0.6630D-05, 0.6631D-05, 0.6631D-05, 0.6632D-05, 0.6634D-05,
     ,   0.6631D-05, 0.6631D-05, 0.6631D-05, 0.6632D-05, 0.6632D-05,
     ,   0.6632D-05, 0.6632D-05, 0.6632D-05/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.2949D-10, 0.3652D-10, 0.4148D-10, 0.4815D-10, 0.6394D-10,
     ,   0.7343D-10, 0.4428D-10, 0.5743D-10, 0.7904D-10, 0.1854D-10,
     ,  -0.4664D-10,-0.1894D-09,-0.4823D-09,-0.9451D-09,-0.1757D-08,
     ,  -0.3244D-08,-0.5946D-08,-0.1030D-07,-0.1787D-07,-0.3052D-07,
     ,  -0.5218D-07,-0.8830D-07,-0.1483D-06,-0.2476D-06,-0.4104D-06,
     ,  -0.6727D-06,-0.1091D-05,-0.1738D-05,-0.2716D-05,-0.4114D-05,
     ,  -0.6004D-05,-0.8311D-05,-0.1074D-04,-0.1264D-04,-0.1323D-04,
     ,  -0.1182D-04,-0.8502D-05,-0.4107D-05, 0.1971D-06, 0.3548D-05,
     ,   0.5782D-05, 0.7120D-05, 0.7905D-05, 0.8392D-05, 0.8725D-05,
     ,   0.8968D-05, 0.9165D-05, 0.9314D-05, 0.9427D-05, 0.9512D-05,
     ,   0.9574D-05, 0.9620D-05, 0.9649D-05, 0.9675D-05, 0.9691D-05,
     ,   0.9701D-05, 0.9708D-05, 0.9712D-05, 0.9719D-05, 0.9721D-05,
     ,   0.9721D-05, 0.9721D-05, 0.9721D-05, 0.9723D-05, 0.9721D-05,
     ,   0.9721D-05, 0.9721D-05, 0.9721D-05, 0.9723D-05, 0.9723D-05,
     ,   0.9723D-05, 0.9723D-05, 0.9723D-05/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.3809D-10, 0.4890D-10, 0.5066D-10, 0.5403D-10, 0.5597D-10,
     ,   0.6177D-10, 0.9138D-10, 0.1084D-09, 0.8052D-10, 0.3401D-10,
     ,  -0.8517D-10,-0.3031D-09,-0.6740D-09,-0.1399D-08,-0.2612D-08,
     ,  -0.4748D-08,-0.8390D-08,-0.1506D-07,-0.2587D-07,-0.4477D-07,
     ,  -0.7624D-07,-0.1288D-06,-0.2169D-06,-0.3623D-06,-0.6000D-06,
     ,  -0.9836D-06,-0.1596D-05,-0.2545D-05,-0.3968D-05,-0.6017D-05,
     ,  -0.8781D-05,-0.1217D-04,-0.1571D-04,-0.1851D-04,-0.1935D-04,
     ,  -0.1735D-04,-0.1245D-04,-0.6024D-05, 0.2476D-06, 0.5182D-05,
     ,   0.8456D-05, 0.1043D-04, 0.1158D-04, 0.1229D-04, 0.1277D-04,
     ,   0.1314D-04, 0.1342D-04, 0.1363D-04, 0.1381D-04, 0.1393D-04,
     ,   0.1402D-04, 0.1409D-04, 0.1413D-04, 0.1417D-04, 0.1420D-04,
     ,   0.1421D-04, 0.1422D-04, 0.1422D-04, 0.1424D-04, 0.1424D-04,
     ,   0.1423D-04, 0.1423D-04, 0.1423D-04, 0.1423D-04, 0.1423D-04,
     ,   0.1423D-04, 0.1423D-04, 0.1423D-04, 0.1423D-04, 0.1423D-04,
     ,   0.1423D-04, 0.1423D-04, 0.1423D-04/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.5658D-10, 0.7869D-10, 0.7830D-10, 0.1133D-09, 0.1367D-09,
     ,   0.1309D-09, 0.1323D-09, 0.9938D-10, 0.1019D-09, 0.2578D-10,
     ,  -0.1805D-09,-0.4763D-09,-0.1070D-08,-0.2093D-08,-0.3907D-08,
     ,  -0.7014D-08,-0.1256D-07,-0.2186D-07,-0.3809D-07,-0.6521D-07,
     ,  -0.1112D-06,-0.1886D-06,-0.3168D-06,-0.5295D-06,-0.8753D-06,
     ,  -0.1436D-05,-0.2328D-05,-0.3713D-05,-0.5796D-05,-0.8791D-05,
     ,  -0.1283D-04,-0.1779D-04,-0.2295D-04,-0.2706D-04,-0.2835D-04,
     ,  -0.2539D-04,-0.1829D-04,-0.8858D-05, 0.3376D-06, 0.7545D-05,
     ,   0.1234D-04, 0.1524D-04, 0.1693D-04, 0.1797D-04, 0.1869D-04,
     ,   0.1922D-04, 0.1963D-04, 0.1996D-04, 0.2020D-04, 0.2038D-04,
     ,   0.2051D-04, 0.2062D-04, 0.2070D-04, 0.2072D-04, 0.2076D-04,
     ,   0.2079D-04, 0.2080D-04, 0.2082D-04, 0.2081D-04, 0.2083D-04,
     ,   0.2083D-04, 0.2083D-04, 0.2084D-04, 0.2084D-04, 0.2086D-04,
     ,   0.2086D-04, 0.2086D-04, 0.2086D-04, 0.2086D-04, 0.2086D-04,
     ,   0.2086D-04, 0.2086D-04, 0.2086D-04/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.9588D-10, 0.1160D-09, 0.1577D-09, 0.1630D-09, 0.1775D-09,
     ,   0.2305D-09, 0.2491D-09, 0.2476D-09, 0.1959D-09, 0.9789D-10,
     ,  -0.2357D-09,-0.5662D-09,-0.1378D-08,-0.2595D-08,-0.5248D-08,
     ,  -0.9964D-08,-0.1799D-07,-0.3140D-07,-0.5482D-07,-0.9475D-07,
     ,  -0.1608D-06,-0.2732D-06,-0.4600D-06,-0.7699D-06,-0.1274D-05,
     ,  -0.2092D-05,-0.3388D-05,-0.5406D-05,-0.8439D-05,-0.1281D-04,
     ,  -0.1869D-04,-0.2590D-04,-0.3352D-04,-0.3955D-04,-0.4139D-04,
     ,  -0.3710D-04,-0.2672D-04,-0.1300D-04, 0.4490D-06, 0.1103D-04,
     ,   0.1808D-04, 0.2227D-04, 0.2474D-04, 0.2630D-04, 0.2732D-04,
     ,   0.2811D-04, 0.2871D-04, 0.2919D-04, 0.2954D-04, 0.2982D-04,
     ,   0.3000D-04, 0.3013D-04, 0.3024D-04, 0.3033D-04, 0.3037D-04,
     ,   0.3039D-04, 0.3042D-04, 0.3042D-04, 0.3046D-04, 0.3046D-04,
     ,   0.3046D-04, 0.3046D-04, 0.3048D-04, 0.3048D-04, 0.3046D-04,
     ,   0.3046D-04, 0.3046D-04, 0.3046D-04, 0.3046D-04, 0.3046D-04,
     ,   0.3046D-04, 0.3046D-04, 0.3046D-04/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.1185D-09, 0.1261D-09, 0.1755D-09, 0.2184D-09, 0.2213D-09,
     ,   0.2319D-09, 0.2689D-09, 0.2110D-09, 0.8844D-10,-0.2268D-10,
     ,  -0.1839D-09,-0.9469D-09,-0.2085D-08,-0.4461D-08,-0.8111D-08,
     ,  -0.1491D-07,-0.2656D-07,-0.4679D-07,-0.8086D-07,-0.1381D-06,
     ,  -0.2338D-06,-0.3989D-06,-0.6709D-06,-0.1117D-05,-0.1850D-05,
     ,  -0.3037D-05,-0.4921D-05,-0.7848D-05,-0.1226D-04,-0.1861D-04,
     ,  -0.2715D-04,-0.3765D-04,-0.4872D-04,-0.5754D-04,-0.6039D-04,
     ,  -0.5420D-04,-0.3924D-04,-0.1920D-04, 0.4589D-06, 0.1589D-04,
     ,   0.2620D-04, 0.3240D-04, 0.3605D-04, 0.3827D-04, 0.3980D-04,
     ,   0.4093D-04, 0.4183D-04, 0.4251D-04, 0.4302D-04, 0.4343D-04,
     ,   0.4372D-04, 0.4393D-04, 0.4407D-04, 0.4418D-04, 0.4424D-04,
     ,   0.4431D-04, 0.4434D-04, 0.4436D-04, 0.4438D-04, 0.4437D-04,
     ,   0.4440D-04, 0.4440D-04, 0.4440D-04, 0.4440D-04, 0.4440D-04,
     ,   0.4440D-04, 0.4440D-04, 0.4440D-04, 0.4440D-04, 0.4440D-04,
     ,   0.4440D-04, 0.4440D-04, 0.4440D-04/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.1527D-09, 0.1906D-09, 0.2472D-09, 0.2675D-09, 0.2998D-09,
     ,   0.3536D-09, 0.4464D-09, 0.2632D-09, 0.3379D-09, 0.2303D-09,
     ,  -0.3692D-09,-0.1481D-08,-0.3392D-08,-0.6568D-08,-0.1207D-07,
     ,  -0.2174D-07,-0.3888D-07,-0.6721D-07,-0.1173D-06,-0.1987D-06,
     ,  -0.3418D-06,-0.5728D-06,-0.9630D-06,-0.1614D-05,-0.2672D-05,
     ,  -0.4384D-05,-0.7105D-05,-0.1133D-04,-0.1769D-04,-0.2686D-04,
     ,  -0.3929D-04,-0.5452D-04,-0.7061D-04,-0.8354D-04,-0.8778D-04,
     ,  -0.7901D-04,-0.5733D-04,-0.2829D-04, 0.3135D-06, 0.2282D-04,
     ,   0.3794D-04, 0.4702D-04, 0.5229D-04, 0.5557D-04, 0.5781D-04,
     ,   0.5952D-04, 0.6078D-04, 0.6179D-04, 0.6255D-04, 0.6313D-04,
     ,   0.6355D-04, 0.6385D-04, 0.6406D-04, 0.6422D-04, 0.6434D-04,
     ,   0.6440D-04, 0.6444D-04, 0.6450D-04, 0.6449D-04, 0.6454D-04,
     ,   0.6455D-04, 0.6455D-04, 0.6456D-04, 0.6456D-04, 0.6456D-04,
     ,   0.6456D-04, 0.6456D-04, 0.6456D-04, 0.6456D-04, 0.6456D-04,
     ,   0.6456D-04, 0.6456D-04, 0.6456D-04/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.2438D-09, 0.2658D-09, 0.3263D-09, 0.4091D-09, 0.3933D-09,
     ,   0.6039D-09, 0.4586D-09, 0.3556D-09, 0.4226D-09,-0.2746D-09,
     ,  -0.8701D-09,-0.2008D-08,-0.4608D-08,-0.8995D-08,-0.1688D-07,
     ,  -0.3051D-07,-0.5509D-07,-0.9520D-07,-0.1651D-06,-0.2852D-06,
     ,  -0.4833D-06,-0.8210D-06,-0.1383D-05,-0.2305D-05,-0.3824D-05,
     ,  -0.6275D-05,-0.1017D-04,-0.1624D-04,-0.2536D-04,-0.3855D-04,
     ,  -0.5636D-04,-0.7833D-04,-0.1016D-03,-0.1205D-03,-0.1271D-03,
     ,  -0.1146D-03,-0.8365D-04,-0.4170D-04,-0.1735D-06, 0.3259D-04,
     ,   0.5456D-04, 0.6787D-04, 0.7564D-04, 0.8043D-04, 0.8368D-04,
     ,   0.8609D-04, 0.8797D-04, 0.8944D-04, 0.9056D-04, 0.9138D-04,
     ,   0.9201D-04, 0.9245D-04, 0.9275D-04, 0.9300D-04, 0.9311D-04,
     ,   0.9324D-04, 0.9330D-04, 0.9337D-04, 0.9341D-04, 0.9339D-04,
     ,   0.9345D-04, 0.9347D-04, 0.9346D-04, 0.9348D-04, 0.9348D-04,
     ,   0.9348D-04, 0.9348D-04, 0.9348D-04, 0.9348D-04, 0.9348D-04,
     ,   0.9348D-04, 0.9348D-04, 0.9348D-04/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.3342D-09, 0.3491D-09, 0.4420D-09, 0.5859D-09, 0.4736D-09,
     ,   0.4396D-09, 0.8115D-09, 0.5817D-09, 0.2311D-09,-0.6573D-10,
     ,  -0.1310D-08,-0.3083D-08,-0.6574D-08,-0.1357D-07,-0.2387D-07,
     ,  -0.4271D-07,-0.7645D-07,-0.1354D-06,-0.2371D-06,-0.4050D-06,
     ,  -0.6873D-06,-0.1165D-05,-0.1956D-05,-0.3268D-05,-0.5409D-05,
     ,  -0.8879D-05,-0.1441D-04,-0.2297D-04,-0.3597D-04,-0.5469D-04,
     ,  -0.8009D-04,-0.1115D-03,-0.1451D-03,-0.1725D-03,-0.1825D-03,
     ,  -0.1661D-03,-0.1219D-03,-0.6196D-04,-0.2034D-05, 0.4563D-04,
     ,   0.7770D-04, 0.9711D-04, 0.1084D-03, 0.1155D-03, 0.1202D-03,
     ,   0.1237D-03, 0.1264D-03, 0.1286D-03, 0.1302D-03, 0.1314D-03,
     ,   0.1323D-03, 0.1330D-03, 0.1334D-03, 0.1338D-03, 0.1339D-03,
     ,   0.1340D-03, 0.1342D-03, 0.1343D-03, 0.1343D-03, 0.1343D-03,
     ,   0.1344D-03, 0.1345D-03, 0.1345D-03, 0.1345D-03, 0.1345D-03,
     ,   0.1345D-03, 0.1345D-03, 0.1345D-03, 0.1345D-03, 0.1345D-03,
     ,   0.1345D-03, 0.1345D-03, 0.1345D-03/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.6317D-09, 0.6311D-09, 0.7670D-09, 0.8976D-09, 0.1376D-08,
     ,   0.1465D-08, 0.1399D-08, 0.1460D-08, 0.1620D-08, 0.9361D-09,
     ,  -0.2737D-09,-0.3050D-08,-0.7811D-08,-0.1656D-07,-0.3021D-07,
     ,  -0.5974D-07,-0.1052D-06,-0.1848D-06,-0.3222D-06,-0.5565D-06,
     ,  -0.9457D-06,-0.1604D-05,-0.2709D-05,-0.4522D-05,-0.7505D-05,
     ,  -0.1235D-04,-0.2004D-04,-0.3204D-04,-0.5012D-04,-0.7635D-04,
     ,  -0.1121D-03,-0.1564D-03,-0.2042D-03,-0.2439D-03,-0.2595D-03,
     ,  -0.2374D-03,-0.1766D-03,-0.9157D-04,-0.6105D-05, 0.6262D-04,
     ,   0.1093D-03, 0.1377D-03, 0.1541D-03, 0.1644D-03, 0.1713D-03,
     ,   0.1762D-03, 0.1803D-03, 0.1834D-03, 0.1856D-03, 0.1875D-03,
     ,   0.1886D-03, 0.1895D-03, 0.1902D-03, 0.1907D-03, 0.1913D-03,
     ,   0.1914D-03, 0.1915D-03, 0.1916D-03, 0.1918D-03, 0.1918D-03,
     ,   0.1916D-03, 0.1918D-03, 0.1918D-03, 0.1919D-03, 0.1919D-03,
     ,   0.1919D-03, 0.1919D-03, 0.1919D-03, 0.1919D-03, 0.1919D-03,
     ,   0.1919D-03, 0.1919D-03, 0.1919D-03/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.9188D-09, 0.1087D-08, 0.1186D-08, 0.1511D-08, 0.1517D-08,
     ,   0.1656D-08, 0.1851D-08, 0.1731D-08, 0.1778D-08, 0.1045D-08,
     ,  -0.5901D-09,-0.4743D-08,-0.1001D-07,-0.2276D-07,-0.4445D-07,
     ,  -0.8006D-07,-0.1439D-06,-0.2509D-06,-0.4366D-06,-0.7528D-06,
     ,  -0.1286D-05,-0.2177D-05,-0.3680D-05,-0.6131D-05,-0.1019D-04,
     ,  -0.1674D-04,-0.2723D-04,-0.4357D-04,-0.6836D-04,-0.1044D-03,
     ,  -0.1536D-03,-0.2150D-03,-0.2822D-03,-0.3392D-03,-0.3641D-03,
     ,  -0.3366D-03,-0.2540D-03,-0.1361D-03,-0.1479D-04, 0.8353D-04,
     ,   0.1509D-03, 0.1915D-03, 0.2156D-03, 0.2303D-03, 0.2403D-03,
     ,   0.2477D-03, 0.2535D-03, 0.2576D-03, 0.2612D-03, 0.2636D-03,
     ,   0.2655D-03, 0.2669D-03, 0.2678D-03, 0.2686D-03, 0.2688D-03,
     ,   0.2693D-03, 0.2695D-03, 0.2698D-03, 0.2696D-03, 0.2699D-03,
     ,   0.2699D-03, 0.2699D-03, 0.2699D-03, 0.2699D-03, 0.2699D-03,
     ,   0.2699D-03, 0.2699D-03, 0.2699D-03, 0.2699D-03, 0.2699D-03,
     ,   0.2699D-03, 0.2699D-03, 0.2699D-03/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.5576D-09, 0.8910D-09, 0.1175D-08, 0.1322D-08, 0.1384D-08,
     ,   0.1487D-08, 0.1603D-08, 0.1594D-08, 0.1319D-08, 0.7392D-09,
     ,  -0.1818D-08,-0.6729D-08,-0.1580D-07,-0.3040D-07,-0.5838D-07,
     ,  -0.1062D-06,-0.1904D-06,-0.3345D-06,-0.5778D-06,-0.9885D-06,
     ,  -0.1688D-05,-0.2859D-05,-0.4823D-05,-0.8082D-05,-0.1337D-04,
     ,  -0.2202D-04,-0.3575D-04,-0.5733D-04,-0.9009D-04,-0.1381D-03,
     ,  -0.2038D-03,-0.2874D-03,-0.3793D-03,-0.4605D-03,-0.5002D-03,
     ,  -0.4699D-03,-0.3627D-03,-0.2028D-03,-0.3480D-04, 0.1046D-03,
     ,   0.2008D-03, 0.2603D-03, 0.2950D-03, 0.3162D-03, 0.3302D-03,
     ,   0.3408D-03, 0.3488D-03, 0.3552D-03, 0.3597D-03, 0.3635D-03,
     ,   0.3661D-03, 0.3682D-03, 0.3695D-03, 0.3704D-03, 0.3712D-03,
     ,   0.3714D-03, 0.3720D-03, 0.3721D-03, 0.3724D-03, 0.3725D-03,
     ,   0.3725D-03, 0.3724D-03, 0.3726D-03, 0.3726D-03, 0.3726D-03,
     ,   0.3726D-03, 0.3726D-03, 0.3726D-03, 0.3726D-03, 0.3726D-03,
     ,   0.3726D-03, 0.3726D-03, 0.3726D-03/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.8892D-09, 0.9746D-09, 0.1447D-08, 0.1259D-08, 0.1526D-08,
     ,   0.1542D-08, 0.1642D-08, 0.1118D-08, 0.1813D-08,-0.2489D-08,
     ,  -0.5961D-08,-0.1109D-07,-0.2370D-07,-0.4441D-07,-0.7347D-07,
     ,  -0.1378D-06,-0.2432D-06,-0.4176D-06,-0.7201D-06,-0.1225D-05,
     ,  -0.2097D-05,-0.3575D-05,-0.5999D-05,-0.1003D-04,-0.1671D-04,
     ,  -0.2745D-04,-0.4474D-04,-0.7183D-04,-0.1132D-03,-0.1739D-03,
     ,  -0.2591D-03,-0.3675D-03,-0.4905D-03,-0.6036D-03,-0.6671D-03,
     ,  -0.6406D-03,-0.5095D-03,-0.3009D-03,-0.7358D-04, 0.1200D-03,
     ,   0.2564D-03, 0.3418D-03, 0.3916D-03, 0.4218D-03, 0.4422D-03,
     ,   0.4566D-03, 0.4681D-03, 0.4767D-03, 0.4836D-03, 0.4885D-03,
     ,   0.4924D-03, 0.4951D-03, 0.4971D-03, 0.4983D-03, 0.4994D-03,
     ,   0.5002D-03, 0.5004D-03, 0.5008D-03, 0.5009D-03, 0.5012D-03,
     ,   0.5012D-03, 0.5015D-03, 0.5013D-03, 0.5013D-03, 0.5015D-03,
     ,   0.5015D-03, 0.5016D-03, 0.5016D-03, 0.5016D-03, 0.5016D-03,
     ,   0.5016D-03, 0.5016D-03, 0.5016D-03/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.6474D-09, 0.6381D-09, 0.9386D-09, 0.1189D-08, 0.7025D-09,
     ,   0.1224D-08, 0.4567D-09, 0.7807D-09,-0.1658D-08, 0.1906D-09,
     ,  -0.6528D-08,-0.1318D-07,-0.2660D-07,-0.5111D-07,-0.9028D-07,
     ,  -0.1578D-06,-0.2804D-06,-0.4868D-06,-0.8395D-06,-0.1441D-05,
     ,  -0.2453D-05,-0.4121D-05,-0.6948D-05,-0.1164D-04,-0.1934D-04,
     ,  -0.3192D-04,-0.5212D-04,-0.8396D-04,-0.1331D-03,-0.2059D-03,
     ,  -0.3082D-03,-0.4424D-03,-0.6001D-03,-0.7519D-03,-0.8507D-03,
     ,  -0.8418D-03,-0.6974D-03,-0.4418D-03,-0.1457D-03, 0.1158D-03,
     ,   0.3067D-03, 0.4269D-03, 0.4982D-03, 0.5413D-03, 0.5688D-03,
     ,   0.5897D-03, 0.6052D-03, 0.6173D-03, 0.6264D-03, 0.6336D-03,
     ,   0.6387D-03, 0.6426D-03, 0.6453D-03, 0.6472D-03, 0.6485D-03,
     ,   0.6494D-03, 0.6502D-03, 0.6504D-03, 0.6510D-03, 0.6509D-03,
     ,   0.6512D-03, 0.6512D-03, 0.6514D-03, 0.6515D-03, 0.6513D-03,
     ,   0.6513D-03, 0.6515D-03, 0.6515D-03, 0.6515D-03, 0.6515D-03,
     ,   0.6515D-03, 0.6515D-03, 0.6515D-03/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.4711D-10,-0.1254D-09,-0.2302D-09,-0.4745D-09,-0.2206D-08,
     ,  -0.1357D-08,-0.1515D-08,-0.2183D-08,-0.5770D-08,-0.9954D-08,
     ,  -0.1298D-07,-0.2355D-07,-0.3735D-07,-0.6412D-07,-0.1078D-06,
     ,  -0.1843D-06,-0.3146D-06,-0.5201D-06,-0.9104D-06,-0.1520D-05,
     ,  -0.2555D-05,-0.4364D-05,-0.7322D-05,-0.1222D-04,-0.2032D-04,
     ,  -0.3359D-04,-0.5498D-04,-0.8888D-04,-0.1420D-03,-0.2213D-03,
     ,  -0.3358D-03,-0.4900D-03,-0.6769D-03,-0.8716D-03,-0.1019D-02,
     ,  -0.1051D-02,-0.9197D-03,-0.6340D-03,-0.2706D-03, 0.7006D-04,
     ,   0.3281D-03, 0.4966D-03, 0.5970D-03, 0.6570D-03, 0.6960D-03,
     ,   0.7231D-03, 0.7442D-03, 0.7602D-03, 0.7728D-03, 0.7822D-03,
     ,   0.7895D-03, 0.7944D-03, 0.7981D-03, 0.8010D-03, 0.8026D-03,
     ,   0.8039D-03, 0.8048D-03, 0.8056D-03, 0.8057D-03, 0.8062D-03,
     ,   0.8064D-03, 0.8065D-03, 0.8064D-03, 0.8066D-03, 0.8067D-03,
     ,   0.8067D-03, 0.8066D-03, 0.8067D-03, 0.8067D-03, 0.8067D-03,
     ,   0.8067D-03, 0.8067D-03, 0.8067D-03/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.2221D-08,-0.2563D-08,-0.2766D-08,-0.3374D-08,-0.3575D-08,
     ,  -0.6597D-08,-0.7478D-08,-0.1084D-07,-0.1228D-07,-0.1810D-07,
     ,  -0.2496D-07,-0.3426D-07,-0.4990D-07,-0.7870D-07,-0.1183D-06,
     ,  -0.1943D-06,-0.3297D-06,-0.5235D-06,-0.8359D-06,-0.1454D-05,
     ,  -0.2397D-05,-0.3983D-05,-0.6656D-05,-0.1113D-04,-0.1854D-04,
     ,  -0.3065D-04,-0.5034D-04,-0.8230D-04,-0.1320D-03,-0.2086D-03,
     ,  -0.3216D-03,-0.4796D-03,-0.6829D-03,-0.9120D-03,-0.1116D-02,
     ,  -0.1219D-02,-0.1140D-02,-0.8648D-03,-0.4617D-03,-0.4490D-04,
     ,   0.2920D-03, 0.5206D-03, 0.6604D-03, 0.7427D-03, 0.7947D-03,
     ,   0.8308D-03, 0.8576D-03, 0.8789D-03, 0.8952D-03, 0.9076D-03,
     ,   0.9170D-03, 0.9237D-03, 0.9285D-03, 0.9316D-03, 0.9342D-03,
     ,   0.9361D-03, 0.9371D-03, 0.9380D-03, 0.9387D-03, 0.9389D-03,
     ,   0.9390D-03, 0.9392D-03, 0.9399D-03, 0.9397D-03, 0.9399D-03,
     ,   0.9399D-03, 0.9397D-03, 0.9399D-03, 0.9399D-03, 0.9399D-03,
     ,   0.9399D-03, 0.9399D-03, 0.9399D-03/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.3795D-08,-0.4959D-08,-0.4846D-08,-0.8063D-08,-0.9619D-08,
     ,  -0.9663D-08,-0.1305D-07,-0.1756D-07,-0.1839D-07,-0.2335D-07,
     ,  -0.3228D-07,-0.4540D-07,-0.6157D-07,-0.8430D-07,-0.1105D-06,
     ,  -0.1807D-06,-0.2638D-06,-0.4183D-06,-0.6860D-06,-0.1098D-05,
     ,  -0.1779D-05,-0.2949D-05,-0.4897D-05,-0.8161D-05,-0.1352D-04,
     ,  -0.2249D-04,-0.3708D-04,-0.6111D-04,-0.9955D-04,-0.1607D-03,
     ,  -0.2542D-03,-0.3921D-03,-0.5831D-03,-0.8217D-03,-0.1073D-02,
     ,  -0.1263D-02,-0.1290D-02,-0.1097D-02,-0.7075D-03,-0.2462D-03,
     ,   0.1670D-03, 0.4657D-03, 0.6539D-03, 0.7659D-03, 0.8342D-03,
     ,   0.8801D-03, 0.9134D-03, 0.9395D-03, 0.9599D-03, 0.9754D-03,
     ,   0.9875D-03, 0.9959D-03, 0.1002D-02, 0.1005D-02, 0.1009D-02,
     ,   0.1012D-02, 0.1013D-02, 0.1014D-02, 0.1015D-02, 0.1015D-02,
     ,   0.1015D-02, 0.1015D-02, 0.1017D-02, 0.1017D-02, 0.1017D-02,
     ,   0.1017D-02, 0.1017D-02, 0.1016D-02, 0.1016D-02, 0.1016D-02,
     ,   0.1016D-02, 0.1017D-02, 0.1017D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.6002D-08,-0.7672D-08,-0.1122D-07,-0.9639D-08,-0.1239D-07,
     ,  -0.1544D-07,-0.1976D-07,-0.2266D-07,-0.2831D-07,-0.3678D-07,
     ,  -0.4474D-07,-0.5313D-07,-0.6944D-07,-0.9139D-07,-0.1114D-06,
     ,  -0.1520D-06,-0.2142D-06,-0.3021D-06,-0.4254D-06,-0.6180D-06,
     ,  -0.9815D-06,-0.1521D-05,-0.2435D-05,-0.3944D-05,-0.6517D-05,
     ,  -0.1088D-04,-0.1812D-04,-0.3036D-04,-0.5111D-04,-0.8576D-04,
     ,  -0.1431D-03,-0.2363D-03,-0.3802D-03,-0.5862D-03,-0.8492D-03,
     ,  -0.1109D-02,-0.1281D-02,-0.1243D-02,-0.9626D-03,-0.5214D-03,
     ,  -0.6235D-04, 0.3052D-03, 0.5506D-03, 0.6988D-03, 0.7874D-03,
     ,   0.8442D-03, 0.8834D-03, 0.9140D-03, 0.9380D-03, 0.9560D-03,
     ,   0.9687D-03, 0.9795D-03, 0.9883D-03, 0.9940D-03, 0.9963D-03,
     ,   0.1000D-02, 0.1001D-02, 0.1002D-02, 0.1002D-02, 0.1005D-02,
     ,   0.1005D-02, 0.1006D-02, 0.1006D-02, 0.1006D-02, 0.1006D-02,
     ,   0.1006D-02, 0.1006D-02, 0.1006D-02, 0.1006D-02, 0.1006D-02,
     ,   0.1006D-02, 0.1006D-02, 0.1006D-02/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.5181D-08,-0.7094D-08,-0.7222D-08,-0.8603D-08,-0.1042D-07,
     ,  -0.1370D-07,-0.1738D-07,-0.1932D-07,-0.2355D-07,-0.2820D-07,
     ,  -0.3460D-07,-0.4309D-07,-0.4965D-07,-0.5542D-07,-0.8081D-07,
     ,  -0.9055D-07,-0.8169D-07,-0.9614D-07,-0.1230D-06,-0.1283D-06,
     ,  -0.7575D-07,-0.3573D-07, 0.5192D-07, 0.1888D-06, 0.3914D-06,
     ,   0.8194D-06, 0.7235D-06, 0.5552D-06,-0.1412D-05,-0.7065D-05,
     ,  -0.2228D-04,-0.5655D-04,-0.1271D-03,-0.2565D-03,-0.4665D-03,
     ,  -0.7508D-03,-0.1032D-02,-0.1190D-02,-0.1115D-02,-0.7996D-03,
     ,  -0.3629D-03, 0.4525D-04, 0.3479D-03, 0.5388D-03, 0.6513D-03,
     ,   0.7201D-03, 0.7671D-03, 0.8004D-03, 0.8273D-03, 0.8481D-03,
     ,   0.8630D-03, 0.8753D-03, 0.8830D-03, 0.8912D-03, 0.8966D-03,
     ,   0.8985D-03, 0.9022D-03, 0.9031D-03, 0.9038D-03, 0.9041D-03,
     ,   0.9046D-03, 0.9066D-03, 0.9049D-03, 0.9054D-03, 0.9054D-03,
     ,   0.9054D-03, 0.9054D-03, 0.9054D-03, 0.9054D-03, 0.9054D-03,
     ,   0.9054D-03, 0.9054D-03, 0.9054D-03/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.2097D-08,-0.2625D-09,-0.2612D-08,-0.4259D-08,-0.6261D-08,
     ,  -0.5571D-08,-0.6052D-08,-0.8856D-08,-0.8483D-08,-0.9882D-08,
     ,  -0.1176D-07,-0.1147D-07,-0.1230D-07, 0.3374D-08,-0.6161D-08,
     ,   0.1038D-07, 0.3281D-07, 0.8634D-07, 0.2014D-06, 0.3437D-06,
     ,   0.5841D-06, 0.1069D-05, 0.1813D-05, 0.3086D-05, 0.5149D-05,
     ,   0.8267D-05, 0.1391D-04, 0.2182D-04, 0.3375D-04, 0.5007D-04,
     ,   0.6943D-04, 0.8786D-04, 0.9181D-04, 0.5332D-04,-0.5430D-04,
     ,  -0.2687D-03,-0.5795D-03,-0.8917D-03,-0.1052D-02,-0.9638D-03,
     ,  -0.6567D-03,-0.2671D-03, 0.7158D-04, 0.3072D-03, 0.4508D-03,
     ,   0.5353D-03, 0.5875D-03, 0.6268D-03, 0.6527D-03, 0.6758D-03,
     ,   0.6933D-03, 0.7066D-03, 0.7162D-03, 0.7231D-03, 0.7285D-03,
     ,   0.7314D-03, 0.7350D-03, 0.7363D-03, 0.7372D-03, 0.7379D-03,
     ,   0.7400D-03, 0.7383D-03, 0.7387D-03, 0.7407D-03, 0.7412D-03,
     ,   0.7412D-03, 0.7412D-03, 0.7412D-03, 0.7412D-03, 0.7412D-03,
     ,   0.7412D-03, 0.7412D-03, 0.7412D-03/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.1739D-08, 0.7550D-09, 0.2827D-08, 0.4233D-08, 0.4882D-08,
     ,   0.4369D-08, 0.6436D-08, 0.8575D-08, 0.9773D-08, 0.1386D-07,
     ,   0.1593D-07, 0.2249D-07, 0.3242D-07, 0.2648D-07, 0.7598D-07,
     ,   0.9968D-07, 0.1498D-06, 0.2105D-06, 0.3331D-06, 0.5744D-06,
     ,   0.9475D-06, 0.1527D-05, 0.2552D-05, 0.4204D-05, 0.6941D-05,
     ,   0.1161D-04, 0.1855D-04, 0.2987D-04, 0.4779D-04, 0.7382D-04,
     ,   0.1115D-03, 0.1603D-03, 0.2149D-03, 0.2600D-03, 0.2547D-03,
     ,   0.1556D-03,-0.7232D-04,-0.4075D-03,-0.7385D-03,-0.9015D-03,
     ,  -0.8173D-03,-0.5438D-03,-0.2201D-03, 0.4619D-04, 0.2235D-03,
     ,   0.3285D-03, 0.3928D-03, 0.4305D-03, 0.4603D-03, 0.4816D-03,
     ,   0.5023D-03, 0.5134D-03, 0.5257D-03, 0.5338D-03, 0.5381D-03,
     ,   0.5433D-03, 0.5452D-03, 0.5486D-03, 0.5499D-03, 0.5507D-03,
     ,   0.5490D-03, 0.5515D-03, 0.5520D-03, 0.5498D-03, 0.5518D-03,
     ,   0.5518D-03, 0.5519D-03, 0.5519D-03, 0.5519D-03, 0.5519D-03,
     ,   0.5519D-03, 0.5519D-03, 0.5519D-03/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.4688D-08, 0.5834D-08, 0.7259D-08, 0.7205D-08, 0.9625D-08,
     ,   0.1204D-07, 0.1723D-07, 0.1794D-07, 0.2118D-07, 0.2770D-07,
     ,   0.3563D-07, 0.4441D-07, 0.5445D-07, 0.7683D-07, 0.8902D-07,
     ,   0.1272D-06, 0.1650D-06, 0.2747D-06, 0.4321D-06, 0.6170D-06,
     ,   0.9719D-06, 0.1522D-05, 0.2420D-05, 0.3934D-05, 0.6437D-05,
     ,   0.1035D-04, 0.1710D-04, 0.2792D-04, 0.4455D-04, 0.7068D-04,
     ,   0.1098D-03, 0.1650D-03, 0.2374D-03, 0.3197D-03, 0.3911D-03,
     ,   0.4085D-03, 0.3110D-03, 0.7080D-04,-0.2787D-03,-0.6044D-03,
     ,  -0.7604D-03,-0.6815D-03,-0.4523D-03,-0.1960D-03, 0.4848D-05,
     ,   0.1347D-03, 0.2096D-03, 0.2563D-03, 0.2868D-03, 0.3097D-03,
     ,   0.3249D-03, 0.3405D-03, 0.3497D-03, 0.3571D-03, 0.3641D-03,
     ,   0.3681D-03, 0.3704D-03, 0.3718D-03, 0.3749D-03, 0.3758D-03,
     ,   0.3787D-03, 0.3769D-03, 0.3791D-03, 0.3797D-03, 0.3776D-03,
     ,   0.3776D-03, 0.3777D-03, 0.3777D-03, 0.3778D-03, 0.3778D-03,
     ,   0.3778D-03, 0.3778D-03, 0.3778D-03/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.4909D-08, 0.5885D-08, 0.6930D-08, 0.8806D-08, 0.1095D-07,
     ,   0.1292D-07, 0.1370D-07, 0.1890D-07, 0.2493D-07, 0.2792D-07,
     ,   0.3641D-07, 0.4392D-07, 0.5623D-07, 0.7115D-07, 0.9348D-07,
     ,   0.1327D-06, 0.1723D-06, 0.2290D-06, 0.3229D-06, 0.5054D-06,
     ,   0.7480D-06, 0.1175D-05, 0.1851D-05, 0.2993D-05, 0.4813D-05,
     ,   0.7875D-05, 0.1273D-04, 0.2084D-04, 0.3359D-04, 0.5414D-04,
     ,   0.8531D-04, 0.1316D-03, 0.1970D-03, 0.2818D-03, 0.3770D-03,
     ,   0.4563D-03, 0.4793D-03, 0.3798D-03, 0.1419D-03,-0.1924D-03,
     ,  -0.4871D-03,-0.6188D-03,-0.5538D-03,-0.3714D-03,-0.1762D-03,
     ,  -0.2880D-04, 0.6431D-04, 0.1181D-03, 0.1507D-03, 0.1726D-03,
     ,   0.1895D-03, 0.2022D-03, 0.2127D-03, 0.2208D-03, 0.2265D-03,
     ,   0.2311D-03, 0.2351D-03, 0.2376D-03, 0.2380D-03, 0.2391D-03,
     ,   0.2390D-03, 0.2410D-03, 0.2397D-03, 0.2404D-03, 0.2413D-03,
     ,   0.2416D-03, 0.2419D-03, 0.2419D-03, 0.2422D-03, 0.2422D-03,
     ,   0.2422D-03, 0.2422D-03, 0.2422D-03/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.4107D-08, 0.5137D-08, 0.6179D-08, 0.7303D-08, 0.9502D-08,
     ,   0.1185D-07, 0.1552D-07, 0.1735D-07, 0.1779D-07, 0.2312D-07,
     ,   0.2940D-07, 0.3689D-07, 0.4659D-07, 0.6029D-07, 0.7333D-07,
     ,   0.9549D-07, 0.1433D-06, 0.1773D-06, 0.2524D-06, 0.3526D-06,
     ,   0.5178D-06, 0.7937D-06, 0.1269D-05, 0.1969D-05, 0.3170D-05,
     ,   0.5144D-05, 0.8387D-05, 0.1350D-04, 0.2228D-04, 0.3562D-04,
     ,   0.5702D-04, 0.8998D-04, 0.1378D-03, 0.2048D-03, 0.2898D-03,
     ,   0.3841D-03, 0.4599D-03, 0.4770D-03, 0.3829D-03, 0.1578D-03,
     ,  -0.1334D-03,-0.3844D-03,-0.4888D-03,-0.4357D-03,-0.2961D-03,
     ,  -0.1520D-03,-0.4608D-04, 0.1932D-04, 0.5744D-04, 0.8049D-04,
     ,   0.9620D-04, 0.1083D-03, 0.1178D-03, 0.1252D-03, 0.1310D-03,
     ,   0.1351D-03, 0.1383D-03, 0.1405D-03, 0.1426D-03, 0.1438D-03,
     ,   0.1446D-03, 0.1449D-03, 0.1457D-03, 0.1458D-03, 0.1457D-03,
     ,   0.1460D-03, 0.1460D-03, 0.1461D-03, 0.1461D-03, 0.1461D-03,
     ,   0.1461D-03, 0.1461D-03, 0.1461D-03/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.2300D-08, 0.2978D-08, 0.3419D-08, 0.4198D-08, 0.5087D-08,
     ,   0.6082D-08, 0.6817D-08, 0.9798D-08, 0.1184D-07, 0.1633D-07,
     ,   0.1674D-07, 0.2133D-07, 0.2671D-07, 0.3197D-07, 0.4096D-07,
     ,   0.5546D-07, 0.6982D-07, 0.1094D-06, 0.1277D-06, 0.1994D-06,
     ,   0.2954D-06, 0.4597D-06, 0.7103D-06, 0.1131D-05, 0.1861D-05,
     ,   0.3008D-05, 0.4906D-05, 0.8077D-05, 0.1296D-04, 0.2140D-04,
     ,   0.3449D-04, 0.5471D-04, 0.8602D-04, 0.1311D-03, 0.1930D-03,
     ,   0.2704D-03, 0.3527D-03, 0.4170D-03, 0.4226D-03, 0.3392D-03,
     ,   0.1461D-03,-0.9719D-04,-0.2962D-03,-0.3752D-03,-0.3333D-03,
     ,  -0.2298D-03,-0.1257D-03,-0.5070D-04,-0.5252D-05, 0.2112D-04,
     ,   0.3729D-04, 0.4850D-04, 0.5714D-04, 0.6393D-04, 0.6927D-04,
     ,   0.7350D-04, 0.7653D-04, 0.7891D-04, 0.8038D-04, 0.8145D-04,
     ,   0.8242D-04, 0.8295D-04, 0.8330D-04, 0.8356D-04, 0.8396D-04,
     ,   0.8403D-04, 0.8412D-04, 0.8417D-04, 0.8421D-04, 0.8426D-04,
     ,   0.8426D-04, 0.8426D-04, 0.8426D-04/
      data (calcpts(j,30), j = 1,neta) /
     ,   0.8901D-09, 0.7975D-09, 0.9780D-09, 0.1293D-08, 0.1414D-08,
     ,   0.1904D-08, 0.1144D-08, 0.1745D-08, 0.3760D-08, 0.2801D-08,
     ,   0.4177D-08, 0.7718D-08, 0.9191D-08, 0.1222D-07, 0.1509D-07,
     ,   0.1816D-07, 0.2842D-07, 0.3917D-07, 0.6332D-07, 0.9230D-07,
     ,   0.1573D-06, 0.2318D-06, 0.3683D-06, 0.5959D-06, 0.9553D-06,
     ,   0.1570D-05, 0.2619D-05, 0.4332D-05, 0.7211D-05, 0.1179D-04,
     ,   0.1924D-04, 0.3102D-04, 0.4932D-04, 0.7654D-04, 0.1164D-03,
     ,   0.1691D-03, 0.2345D-03, 0.3016D-03, 0.3516D-03, 0.3515D-03,
     ,   0.2754D-03, 0.1194D-03,-0.7162D-04,-0.2230D-03,-0.2807D-03,
     ,  -0.2485D-03,-0.1736D-03,-0.9976D-04,-0.4724D-04,-0.1568D-04,
     ,   0.2604D-05, 0.1382D-04, 0.2156D-04, 0.2757D-04, 0.3254D-04,
     ,   0.3633D-04, 0.3922D-04, 0.4141D-04, 0.4280D-04, 0.4414D-04,
     ,   0.4490D-04, 0.4544D-04, 0.4604D-04, 0.4631D-04, 0.4644D-04,
     ,   0.4636D-04, 0.4645D-04, 0.4671D-04, 0.4654D-04, 0.4679D-04,
     ,   0.4680D-04, 0.4680D-04, 0.4680D-04/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.3070D-09,-0.1902D-09,-0.1477D-09,-0.6836D-10,-0.2802D-09,
     ,  -0.2219D-09,-0.7267D-10,-0.1746D-10,-0.5799D-09,-0.1132D-08,
     ,   0.9082D-09,-0.3165D-08,-0.2562D-08,-0.1695D-08, 0.1972D-08,
     ,   0.1775D-08, 0.4715D-08, 0.7466D-08, 0.1444D-07, 0.2829D-07,
     ,   0.4125D-07, 0.9346D-07, 0.1337D-06, 0.2627D-06, 0.4415D-06,
     ,   0.7900D-06, 0.1296D-05, 0.2210D-05, 0.3719D-05, 0.6171D-05,
     ,   0.1016D-04, 0.1677D-04, 0.2685D-04, 0.4252D-04, 0.6526D-04,
     ,   0.9833D-04, 0.1414D-03, 0.1932D-03, 0.2445D-03, 0.2804D-03,
     ,   0.2762D-03, 0.2131D-03, 0.9147D-04,-0.5316D-04,-0.1643D-03,
     ,  -0.2054D-03,-0.1814D-03,-0.1277D-03,-0.7609D-04,-0.3969D-04,
     ,  -0.1786D-04,-0.5466D-05, 0.2385D-05, 0.7811D-05, 0.1197D-04,
     ,   0.1539D-04, 0.1800D-04, 0.2003D-04, 0.2165D-04, 0.2274D-04,
     ,   0.2355D-04, 0.2410D-04, 0.2449D-04, 0.2476D-04, 0.2494D-04,
     ,   0.2508D-04, 0.2517D-04, 0.2521D-04, 0.2531D-04, 0.2529D-04,
     ,   0.2530D-04, 0.2530D-04, 0.2530D-04/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.5025D-09,-0.6262D-09,-0.7634D-09,-0.1020D-08,-0.1136D-08,
     ,  -0.1520D-08,-0.1743D-08,-0.2175D-08,-0.2627D-08,-0.2395D-08,
     ,  -0.3676D-08,-0.3617D-08,-0.4755D-08,-0.5801D-08,-0.7505D-08,
     ,  -0.6229D-08,-0.1040D-07,-0.9385D-08,-0.7628D-08,-0.6183D-08,
     ,   0.4687D-08, 0.2921D-08, 0.5609D-07, 0.1077D-06, 0.2035D-06,
     ,   0.3359D-06, 0.5990D-06, 0.1047D-05, 0.1800D-05, 0.3063D-05,
     ,   0.5141D-05, 0.8487D-05, 0.1387D-04, 0.2220D-04, 0.3515D-04,
     ,   0.5390D-04, 0.7962D-04, 0.1132D-03, 0.1525D-03, 0.1902D-03,
     ,   0.2148D-03, 0.2085D-03, 0.1586D-03, 0.6692D-04,-0.3924D-04,
     ,  -0.1195D-03,-0.1477D-03,-0.1304D-03,-0.9241D-04,-0.5636D-04,
     ,  -0.3147D-04,-0.1650D-04,-0.7841D-05,-0.2578D-05, 0.1304D-05,
     ,   0.4079D-05, 0.6361D-05, 0.8328D-05, 0.9828D-05, 0.1078D-04,
     ,   0.1159D-04, 0.1215D-04, 0.1254D-04, 0.1282D-04, 0.1304D-04,
     ,   0.1314D-04, 0.1323D-04, 0.1331D-04, 0.1352D-04, 0.1340D-04,
     ,   0.1340D-04, 0.1341D-04, 0.1341D-04/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.6884D-09,-0.9178D-09,-0.1388D-08,-0.1486D-08,-0.1747D-08,
     ,  -0.2012D-08,-0.2641D-08,-0.3095D-08,-0.3596D-08,-0.4741D-08,
     ,  -0.5476D-08,-0.5450D-08,-0.6739D-08,-0.8930D-08,-0.1345D-07,
     ,  -0.1479D-07,-0.1557D-07,-0.1603D-07,-0.2149D-07,-0.2088D-07,
     ,  -0.2430D-07,-0.2075D-07,-0.1355D-07,-0.4025D-08, 0.2248D-07,
     ,   0.1152D-06, 0.2437D-06, 0.4356D-06, 0.8067D-06, 0.1431D-05,
     ,   0.2470D-05, 0.4180D-05, 0.6923D-05, 0.1133D-04, 0.1809D-04,
     ,   0.2813D-04, 0.4302D-04, 0.6279D-04, 0.8799D-04, 0.1165D-03,
     ,   0.1433D-03, 0.1595D-03, 0.1528D-03, 0.1147D-03, 0.4771D-04,
     ,  -0.2839D-04,-0.8513D-04,-0.1050D-03,-0.9252D-04,-0.6612D-04,
     ,  -0.4107D-04,-0.2372D-04,-0.1382D-04,-0.7827D-05,-0.4129D-05,
     ,  -0.1571D-05, 0.5172D-06, 0.2131D-05, 0.3210D-05, 0.4324D-05,
     ,   0.5112D-05, 0.5668D-05, 0.5875D-05, 0.6153D-05, 0.6541D-05,
     ,   0.6664D-05, 0.6754D-05, 0.6824D-05, 0.6637D-05, 0.6905D-05,
     ,   0.6918D-05, 0.6926D-05, 0.6937D-05/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.6579D-09,-0.7358D-09,-0.7678D-09,-0.1222D-08,-0.1359D-08,
     ,  -0.1774D-08,-0.1845D-08,-0.2443D-08,-0.2998D-08,-0.3592D-08,
     ,  -0.4212D-08,-0.5506D-08,-0.6500D-08,-0.7221D-08,-0.7443D-08,
     ,  -0.1175D-07,-0.1085D-07,-0.1655D-07,-0.1642D-07,-0.1962D-07,
     ,  -0.2273D-07,-0.2120D-07,-0.2299D-07,-0.1548D-07,-0.1799D-09,
     ,   0.1679D-07, 0.6546D-07, 0.2004D-06, 0.3731D-06, 0.6486D-06,
     ,   0.1187D-05, 0.2004D-05, 0.3419D-05, 0.5647D-05, 0.9176D-05,
     ,   0.1454D-04, 0.2235D-04, 0.3354D-04, 0.4814D-04, 0.6648D-04,
     ,   0.8662D-04, 0.1052D-03, 0.1157D-03, 0.1098D-03, 0.8138D-04,
     ,   0.3317D-04,-0.2060D-04,-0.5997D-04,-0.7357D-04,-0.6477D-04,
     ,  -0.4645D-04,-0.2939D-04,-0.1737D-04,-0.1040D-04,-0.6512D-05,
     ,  -0.3906D-05,-0.2128D-05,-0.8246D-06, 0.4464D-06, 0.1256D-05,
     ,   0.1839D-05, 0.2378D-05, 0.2841D-05, 0.3136D-05, 0.3126D-05,
     ,   0.3345D-05, 0.3440D-05, 0.3451D-05, 0.3627D-05, 0.3508D-05,
     ,   0.3561D-05, 0.3593D-05, 0.3640D-05/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.5665D-09,-0.6851D-09,-0.8588D-09,-0.8810D-09,-0.1077D-08,
     ,  -0.1591D-08,-0.1940D-08,-0.2062D-08,-0.2702D-08,-0.3058D-08,
     ,  -0.3737D-08,-0.4613D-08,-0.5621D-08,-0.6774D-08,-0.8455D-08,
     ,  -0.8383D-08,-0.1340D-07,-0.1311D-07,-0.1605D-07,-0.1991D-07,
     ,  -0.2418D-07,-0.2853D-07,-0.2906D-07,-0.3050D-07,-0.2813D-07,
     ,  -0.1591D-07, 0.3543D-08, 0.2456D-07, 0.1078D-06, 0.2636D-06,
     ,   0.4878D-06, 0.9279D-06, 0.1587D-05, 0.2703D-05, 0.4485D-05,
     ,   0.7231D-05, 0.1136D-04, 0.1726D-04, 0.2553D-04, 0.3621D-04,
     ,   0.4926D-04, 0.6344D-04, 0.7573D-04, 0.8269D-04, 0.7768D-04,
     ,   0.5709D-04, 0.2265D-04,-0.1472D-04,-0.4215D-04,-0.5128D-04,
     ,  -0.4512D-04,-0.3242D-04,-0.2069D-04,-0.1259D-04,-0.7814D-05,
     ,  -0.5070D-05,-0.3373D-05,-0.2136D-05,-0.1200D-05,-0.4350D-06,
     ,   0.1908D-06, 0.6292D-06, 0.9768D-06, 0.1222D-05, 0.1453D-05,
     ,   0.1543D-05, 0.1654D-05, 0.1731D-05, 0.1754D-05, 0.1790D-05,
     ,   0.1804D-05, 0.1830D-05, 0.1813D-05/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.4848D-09,-0.5709D-09,-0.6907D-09,-0.8530D-09,-0.1040D-08,
     ,  -0.1074D-08,-0.1393D-08,-0.1700D-08,-0.2283D-08,-0.2836D-08,
     ,  -0.3163D-08,-0.3786D-08,-0.4822D-08,-0.5664D-08,-0.6829D-08,
     ,  -0.8724D-08,-0.9572D-08,-0.1317D-07,-0.1579D-07,-0.1808D-07,
     ,  -0.2084D-07,-0.2139D-07,-0.2527D-07,-0.3085D-07,-0.3394D-07,
     ,  -0.3206D-07,-0.2576D-07,-0.1113D-07, 0.2030D-07, 0.8170D-07,
     ,   0.1892D-06, 0.3881D-06, 0.7138D-06, 0.1245D-05, 0.2124D-05,
     ,   0.3503D-05, 0.5603D-05, 0.8721D-05, 0.1307D-04, 0.1897D-04,
     ,   0.2657D-04, 0.3563D-04, 0.4540D-04, 0.5376D-04, 0.5804D-04,
     ,   0.5431D-04, 0.3990D-04, 0.1563D-04,-0.1042D-04,-0.2933D-04,
     ,  -0.3557D-04,-0.3128D-04,-0.2251D-04,-0.1448D-04,-0.8948D-05,
     ,  -0.5700D-05,-0.3811D-05,-0.2653D-05,-0.1810D-05,-0.1175D-05,
     ,  -0.6388D-06,-0.2369D-06, 0.8760D-07, 0.3104D-06, 0.4982D-06,
     ,   0.6320D-06, 0.6973D-06, 0.7607D-06, 0.8057D-06, 0.8380D-06,
     ,   0.8811D-06, 0.8694D-06, 0.8829D-06/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.3418D-09,-0.3982D-09,-0.5130D-09,-0.6230D-09,-0.7385D-09,
     ,  -0.8932D-09,-0.1082D-08,-0.1426D-08,-0.1467D-08,-0.1858D-08,
     ,  -0.2456D-08,-0.2953D-08,-0.3403D-08,-0.3955D-08,-0.5083D-08,
     ,  -0.6082D-08,-0.7242D-08,-0.8419D-08,-0.1019D-07,-0.1165D-07,
     ,  -0.1401D-07,-0.1759D-07,-0.2133D-07,-0.2519D-07,-0.2520D-07,
     ,  -0.3040D-07,-0.3096D-07,-0.2579D-07,-0.1602D-07, 0.7969D-08,
     ,   0.5746D-07, 0.1336D-06, 0.3001D-06, 0.5693D-06, 0.9905D-06,
     ,   0.1688D-05, 0.2732D-05, 0.4324D-05, 0.6595D-05, 0.9749D-05,
     ,   0.1393D-04, 0.1924D-04, 0.2549D-04, 0.3215D-04, 0.3788D-04,
     ,   0.4057D-04, 0.3763D-04, 0.2739D-04, 0.1075D-04,-0.7330D-05,
     ,  -0.2028D-04,-0.2451D-04,-0.2157D-04,-0.1556D-04,-0.1003D-04,
     ,  -0.6263D-05,-0.4064D-05,-0.2758D-05,-0.1978D-05,-0.1397D-05,
     ,  -0.9632D-06,-0.5946D-06,-0.3143D-06,-0.9745D-07, 0.6188D-07,
     ,   0.1864D-06, 0.2625D-06, 0.3218D-06, 0.3669D-06, 0.4081D-06,
     ,   0.4159D-06, 0.4307D-06, 0.4399D-06/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.2459D-09,-0.3134D-09,-0.3545D-09,-0.4430D-09,-0.5364D-09,
     ,  -0.6530D-09,-0.7933D-09,-0.9092D-09,-0.1178D-08,-0.1330D-08,
     ,  -0.1615D-08,-0.1927D-08,-0.2443D-08,-0.3118D-08,-0.3516D-08,
     ,  -0.4313D-08,-0.5340D-08,-0.6373D-08,-0.7658D-08,-0.9532D-08,
     ,  -0.1146D-07,-0.1466D-07,-0.1705D-07,-0.1718D-07,-0.2238D-07,
     ,  -0.2397D-07,-0.2893D-07,-0.2710D-07,-0.2401D-07,-0.1508D-07,
     ,   0.3347D-08, 0.4631D-07, 0.1120D-06, 0.2469D-06, 0.4534D-06,
     ,   0.7809D-06, 0.1324D-05, 0.2072D-05, 0.3248D-05, 0.4889D-05,
     ,   0.7133D-05, 0.1007D-04, 0.1375D-04, 0.1801D-04, 0.2252D-04,
     ,   0.2639D-04, 0.2814D-04, 0.2603D-04, 0.1881D-04, 0.7342D-05,
     ,  -0.5067D-05,-0.1396D-04,-0.1685D-04,-0.1481D-04,-0.1070D-04,
     ,  -0.6928D-05,-0.4359D-05,-0.2853D-05,-0.1986D-05,-0.1427D-05,
     ,  -0.1043D-05,-0.7229D-06,-0.5012D-06,-0.2876D-06,-0.1518D-06,
     ,  -0.5127D-07, 0.5768D-07, 0.1017D-06, 0.1421D-06, 0.2342D-06,
     ,   0.1956D-06, 0.2060D-06, 0.2152D-06/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.1873D-09,-0.2353D-09,-0.3016D-09,-0.3489D-09,-0.3990D-09,
     ,  -0.5039D-09,-0.5965D-09,-0.7299D-09,-0.8804D-09,-0.1102D-08,
     ,  -0.1304D-08,-0.1611D-08,-0.1848D-08,-0.2336D-08,-0.2991D-08,
     ,  -0.3259D-08,-0.4197D-08,-0.5136D-08,-0.6052D-08,-0.7119D-08,
     ,  -0.8717D-08,-0.1025D-07,-0.1207D-07,-0.1478D-07,-0.1767D-07,
     ,  -0.1934D-07,-0.2225D-07,-0.2373D-07,-0.2626D-07,-0.2445D-07,
     ,  -0.1772D-07,-0.3214D-08, 0.2654D-07, 0.7910D-07, 0.1774D-06,
     ,   0.3381D-06, 0.5812D-06, 0.1006D-05, 0.1568D-05, 0.2402D-05,
     ,   0.3577D-05, 0.5123D-05, 0.7141D-05, 0.9689D-05, 0.1264D-04,
     ,   0.1567D-04, 0.1825D-04, 0.1941D-04, 0.1790D-04, 0.1287D-04,
     ,   0.4979D-05,-0.3534D-05,-0.9586D-05,-0.1159D-04,-0.1017D-04,
     ,  -0.7371D-05,-0.4779D-05,-0.3021D-05,-0.1993D-05,-0.1409D-05,
     ,  -0.1018D-05,-0.7764D-06,-0.5416D-06,-0.4070D-06,-0.2619D-06,
     ,  -0.1630D-06,-0.1032D-06,-0.2108D-07, 0.1517D-08,-0.1604D-07,
     ,   0.5197D-07, 0.6498D-07, 0.7420D-07/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.1202D-09,-0.1379D-09,-0.1646D-09,-0.1995D-09,-0.2682D-09,
     ,  -0.3198D-09,-0.3826D-09,-0.4794D-09,-0.5769D-09,-0.6837D-09,
     ,  -0.8173D-09,-0.9870D-09,-0.1231D-08,-0.1353D-08,-0.1615D-08,
     ,  -0.2297D-08,-0.2566D-08,-0.2869D-08,-0.3644D-08,-0.4523D-08,
     ,  -0.5606D-08,-0.6398D-08,-0.7775D-08,-0.9603D-08,-0.1106D-07,
     ,  -0.1445D-07,-0.1434D-07,-0.2026D-07,-0.1833D-07,-0.2028D-07,
     ,  -0.1882D-07,-0.1213D-07, 0.8605D-10, 0.2500D-07, 0.7073D-07,
     ,   0.1489D-06, 0.2750D-06, 0.4631D-06, 0.7590D-06, 0.1188D-05,
     ,   0.1761D-05, 0.2581D-05, 0.3678D-05, 0.5070D-05, 0.6779D-05,
     ,   0.8782D-05, 0.1088D-04, 0.1258D-04, 0.1333D-04, 0.1230D-04,
     ,   0.8811D-05, 0.3391D-05,-0.2420D-05,-0.6554D-05,-0.7906D-05,
     ,  -0.6938D-05,-0.5031D-05,-0.3280D-05,-0.2073D-05,-0.1369D-05,
     ,  -0.9773D-06,-0.7118D-06,-0.5414D-06,-0.3821D-06,-0.2782D-06,
     ,  -0.1820D-06,-0.1087D-06,-0.7132D-07,-0.1990D-07, 0.1708D-08,
     ,   0.1613D-07, 0.4066D-07, 0.5035D-07/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.8792D-10,-0.1059D-09,-0.1292D-09,-0.1581D-09,-0.1902D-09,
     ,  -0.2251D-09,-0.2816D-09,-0.3361D-09,-0.4045D-09,-0.4844D-09,
     ,  -0.5830D-09,-0.7229D-09,-0.8635D-09,-0.1088D-08,-0.1317D-08,
     ,  -0.1475D-08,-0.1831D-08,-0.2524D-08,-0.2778D-08,-0.3291D-08,
     ,  -0.4002D-08,-0.4946D-08,-0.6002D-08,-0.6957D-08,-0.8403D-08,
     ,  -0.9586D-08,-0.1210D-07,-0.1155D-07,-0.1597D-07,-0.1690D-07,
     ,  -0.1796D-07,-0.1781D-07,-0.1218D-07,-0.2135D-08, 0.1869D-07,
     ,   0.5463D-07, 0.1147D-06, 0.2070D-06, 0.3484D-06, 0.5565D-06,
     ,   0.8586D-06, 0.1274D-05, 0.1834D-05, 0.2581D-05, 0.3529D-05,
     ,   0.4712D-05, 0.6061D-05, 0.7488D-05, 0.8667D-05, 0.9149D-05,
     ,   0.8407D-05, 0.6026D-05, 0.2303D-05,-0.1674D-05,-0.4499D-05,
     ,  -0.5409D-05,-0.4743D-05,-0.3437D-05,-0.2244D-05,-0.1426D-05,
     ,  -0.9449D-06,-0.6716D-06,-0.4985D-06,-0.3756D-06,-0.2785D-06,
     ,  -0.2020D-06,-0.1405D-06,-0.9332D-07,-0.6047D-07,-0.2886D-07,
     ,  -0.1248D-07,-0.3109D-08, 0.8078D-08/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.6517D-10,-0.7570D-10,-0.9543D-10,-0.1150D-09,-0.1353D-09,
     ,  -0.1674D-09,-0.1907D-09,-0.2371D-09,-0.3100D-09,-0.3605D-09,
     ,  -0.4490D-09,-0.5253D-09,-0.6303D-09,-0.7475D-09,-0.9359D-09,
     ,  -0.1154D-08,-0.1376D-08,-0.1526D-08,-0.2020D-08,-0.2577D-08,
     ,  -0.2939D-08,-0.3518D-08,-0.4117D-08,-0.5019D-08,-0.6239D-08,
     ,  -0.7125D-08,-0.8596D-08,-0.1074D-07,-0.1173D-07,-0.1440D-07,
     ,  -0.1368D-07,-0.1421D-07,-0.1411D-07,-0.9676D-08,-0.2384D-08,
     ,   0.1260D-07, 0.4084D-07, 0.8666D-07, 0.1553D-06, 0.2574D-06,
     ,   0.4066D-06, 0.6156D-06, 0.9027D-06, 0.1293D-05, 0.1808D-05,
     ,   0.2457D-05, 0.3260D-05, 0.4185D-05, 0.5130D-05, 0.5924D-05,
     ,   0.6262D-05, 0.5747D-05, 0.4102D-05, 0.1572D-05,-0.1147D-05,
     ,  -0.3075D-05,-0.3699D-05,-0.3245D-05,-0.2354D-05,-0.1537D-05,
     ,  -0.9822D-06,-0.6538D-06,-0.4668D-06,-0.3488D-06,-0.2643D-06,
     ,  -0.1977D-06,-0.1456D-06,-0.1020D-06,-0.7057D-07,-0.4779D-07,
     ,  -0.3085D-07,-0.1714D-07,-0.1012D-07/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.4137D-10,-0.5221D-10,-0.6291D-10,-0.7322D-10,-0.9111D-10,
     ,  -0.1119D-09,-0.1373D-09,-0.1501D-09,-0.1799D-09,-0.2332D-09,
     ,  -0.2824D-09,-0.3475D-09,-0.4455D-09,-0.5201D-09,-0.6059D-09,
     ,  -0.7523D-09,-0.8935D-09,-0.1120D-08,-0.1332D-08,-0.1512D-08,
     ,  -0.1974D-08,-0.2390D-08,-0.2997D-08,-0.3530D-08,-0.4177D-08,
     ,  -0.5092D-08,-0.6019D-08,-0.6793D-08,-0.7992D-08,-0.9286D-08,
     ,  -0.1104D-07,-0.1163D-07,-0.1152D-07,-0.1085D-07,-0.7001D-08,
     ,  -0.1902D-08, 0.1173D-07, 0.3295D-07, 0.6539D-07, 0.1173D-06,
     ,   0.1902D-06, 0.2947D-06, 0.4399D-06, 0.6377D-06, 0.9038D-06,
     ,   0.1256D-05, 0.1702D-05, 0.2243D-05, 0.2877D-05, 0.3525D-05,
     ,   0.4060D-05, 0.4278D-05, 0.3924D-05, 0.2807D-05, 0.1069D-05,
     ,  -0.7864D-06,-0.2099D-05,-0.2521D-05,-0.2211D-05,-0.1608D-05,
     ,  -0.1048D-05,-0.6693D-06,-0.4468D-06,-0.3193D-06,-0.2388D-06,
     ,  -0.1814D-06,-0.1341D-06,-0.1008D-06,-0.7164D-07,-0.4955D-07,
     ,  -0.3334D-07,-0.2253D-07,-0.1286D-07/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.2839D-10,-0.3551D-10,-0.4080D-10,-0.5315D-10,-0.6357D-10,
     ,  -0.7513D-10,-0.9255D-10,-0.1152D-09,-0.1395D-09,-0.1675D-09,
     ,  -0.1906D-09,-0.2484D-09,-0.2766D-09,-0.3472D-09,-0.4386D-09,
     ,  -0.5142D-09,-0.6283D-09,-0.7645D-09,-0.9220D-09,-0.1111D-08,
     ,  -0.1348D-08,-0.1709D-08,-0.1800D-08,-0.2226D-08,-0.2713D-08,
     ,  -0.3507D-08,-0.3966D-08,-0.4907D-08,-0.5996D-08,-0.6796D-08,
     ,  -0.7789D-08,-0.8731D-08,-0.9478D-08,-0.1013D-07,-0.9288D-08,
     ,  -0.4679D-08,-0.1652D-08, 0.9444D-08, 0.2573D-07, 0.4900D-07,
     ,   0.8677D-07, 0.1364D-06, 0.2114D-06, 0.3106D-06, 0.4471D-06,
     ,   0.6287D-06, 0.8671D-06, 0.1174D-05, 0.1543D-05, 0.1971D-05,
     ,   0.2413D-05, 0.2777D-05, 0.2919D-05, 0.2673D-05, 0.1915D-05,
     ,   0.7319D-06,-0.5360D-06,-0.1433D-05,-0.1720D-05,-0.1507D-05,
     ,  -0.1095D-05,-0.7153D-06,-0.4565D-06,-0.3054D-06,-0.2183D-06,
     ,  -0.1644D-06,-0.1274D-06,-0.9395D-07,-0.7008D-07,-0.4997D-07,
     ,  -0.3450D-07,-0.2395D-07,-0.1522D-07/
      data (calcpts(j,45), j = 1,neta) /
     ,  -0.2127D-10,-0.2676D-10,-0.3186D-10,-0.3853D-10,-0.4498D-10,
     ,  -0.5531D-10,-0.6711D-10,-0.8021D-10,-0.9937D-10,-0.1200D-09,
     ,  -0.1465D-09,-0.1777D-09,-0.2116D-09,-0.2469D-09,-0.3098D-09,
     ,  -0.3628D-09,-0.4514D-09,-0.5376D-09,-0.6554D-09,-0.8005D-09,
     ,  -0.9901D-09,-0.1158D-08,-0.1467D-08,-0.1835D-08,-0.2111D-08,
     ,  -0.2402D-08,-0.3126D-08,-0.3746D-08,-0.4158D-08,-0.5007D-08,
     ,  -0.5966D-08,-0.6857D-08,-0.7795D-08,-0.8003D-08,-0.7995D-08,
     ,  -0.7589D-08,-0.4020D-08,-0.1037D-08, 0.6537D-08, 0.1729D-07,
     ,   0.3437D-07, 0.6085D-07, 0.9641D-07, 0.1474D-06, 0.2168D-06,
     ,   0.3102D-06, 0.4344D-06, 0.5982D-06, 0.8023D-06, 0.1058D-05,
     ,   0.1347D-05, 0.1645D-05, 0.1896D-05, 0.1993D-05, 0.1822D-05,
     ,   0.1301D-05, 0.4954D-06,-0.3702D-06,-0.9800D-06,-0.1173D-05,
     ,  -0.1030D-05,-0.7484D-06,-0.4900D-06,-0.3128D-06,-0.2107D-06,
     ,  -0.1492D-06,-0.1114D-06,-0.8510D-07,-0.6568D-07,-0.4959D-07,
     ,  -0.3543D-07,-0.2551D-07,-0.1903D-07/
      data (calcpts(j,46), j = 1,neta) /
     ,  -0.1329D-10,-0.1425D-10,-0.2020D-10,-0.2273D-10,-0.2762D-10,
     ,  -0.3499D-10,-0.4180D-10,-0.4993D-10,-0.6226D-10,-0.7336D-10,
     ,  -0.9064D-10,-0.1069D-09,-0.1306D-09,-0.1748D-09,-0.1990D-09,
     ,  -0.2577D-09,-0.2972D-09,-0.3505D-09,-0.4402D-09,-0.5066D-09,
     ,  -0.6350D-09,-0.7461D-09,-0.8857D-09,-0.1065D-08,-0.1313D-08,
     ,  -0.1590D-08,-0.1957D-08,-0.2350D-08,-0.2715D-08,-0.3357D-08,
     ,  -0.3622D-08,-0.4213D-08,-0.4743D-08,-0.5575D-08,-0.5788D-08,
     ,  -0.5524D-08,-0.4882D-08,-0.2782D-08, 0.6194D-09, 0.6530D-08,
     ,   0.1506D-07, 0.2736D-07, 0.4499D-07, 0.6972D-07, 0.1031D-06,
     ,   0.1519D-06, 0.2160D-06, 0.2995D-06, 0.4121D-06, 0.5524D-06,
     ,   0.7236D-06, 0.9236D-06, 0.1125D-05, 0.1295D-05, 0.1361D-05,
     ,   0.1242D-05, 0.8897D-06, 0.3383D-06,-0.2499D-06,-0.6666D-06,
     ,  -0.7992D-06,-0.7007D-06,-0.5087D-06,-0.3334D-06,-0.2119D-06,
     ,  -0.1433D-06,-0.1029D-06,-0.7798D-07,-0.5819D-07,-0.4395D-07,
     ,  -0.3332D-07,-0.2364D-07,-0.1632D-07/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.9130D-11,-0.1156D-10,-0.1349D-10,-0.1640D-10,-0.2062D-10,
     ,  -0.2244D-10,-0.2744D-10,-0.3620D-10,-0.4326D-10,-0.5169D-10,
     ,  -0.6241D-10,-0.7790D-10,-0.9436D-10,-0.1086D-09,-0.1375D-09,
     ,  -0.1534D-09,-0.1901D-09,-0.2447D-09,-0.2842D-09,-0.3689D-09,
     ,  -0.4228D-09,-0.5223D-09,-0.6440D-09,-0.7560D-09,-0.9135D-09,
     ,  -0.1098D-08,-0.1334D-08,-0.1488D-08,-0.1955D-08,-0.2140D-08,
     ,  -0.2829D-08,-0.3175D-08,-0.3844D-08,-0.3939D-08,-0.4251D-08,
     ,  -0.4601D-08,-0.4164D-08,-0.3458D-08,-0.2061D-08, 0.4049D-09,
     ,   0.4563D-08, 0.1061D-07, 0.1929D-07, 0.3164D-07, 0.4885D-07,
     ,   0.7224D-07, 0.1043D-06, 0.1484D-06, 0.2061D-06, 0.2815D-06,
     ,   0.3774D-06, 0.4941D-06, 0.6301D-06, 0.7686D-06, 0.8825D-06,
     ,   0.9280D-06, 0.8444D-06, 0.6061D-06, 0.2304D-06,-0.1722D-06,
     ,  -0.4540D-06,-0.5450D-06,-0.4780D-06,-0.3467D-06,-0.2269D-06,
     ,  -0.1452D-06,-0.9723D-07,-0.6943D-07,-0.5224D-07,-0.3998D-07,
     ,  -0.3018D-07,-0.2253D-07,-0.1632D-07/
      data (calcpts(j,48), j = 1,neta) /
     ,  -0.6794D-11,-0.7854D-11,-0.9746D-11,-0.1176D-10,-0.1408D-10,
     ,  -0.1810D-10,-0.2222D-10,-0.2578D-10,-0.3083D-10,-0.3770D-10,
     ,  -0.4492D-10,-0.5355D-10,-0.6713D-10,-0.7826D-10,-0.9631D-10,
     ,  -0.1174D-09,-0.1445D-09,-0.1651D-09,-0.2001D-09,-0.2451D-09,
     ,  -0.2927D-09,-0.3887D-09,-0.4395D-09,-0.5601D-09,-0.6481D-09,
     ,  -0.7847D-09,-0.9452D-09,-0.1180D-08,-0.1355D-08,-0.1623D-08,
     ,  -0.1831D-08,-0.2266D-08,-0.2422D-08,-0.2869D-08,-0.3204D-08,
     ,  -0.3547D-08,-0.3740D-08,-0.3358D-08,-0.2610D-08,-0.1609D-08,
     ,   0.3012D-09, 0.3028D-08, 0.7400D-08, 0.1338D-07, 0.2204D-07,
     ,   0.3356D-07, 0.4995D-07, 0.7192D-07, 0.1017D-06, 0.1410D-06,
     ,   0.1926D-06, 0.2582D-06, 0.3376D-06, 0.4290D-06, 0.5238D-06,
     ,   0.6033D-06, 0.6348D-06, 0.5792D-06, 0.4143D-06, 0.1579D-06,
     ,  -0.1165D-06,-0.3099D-06,-0.3716D-06,-0.3260D-06,-0.2368D-06,
     ,  -0.1548D-06,-0.9919D-07,-0.6667D-07,-0.4795D-07,-0.3624D-07,
     ,  -0.2778D-07,-0.2107D-07,-0.1568D-07/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.1143D-09,-0.1388D-09,-0.1681D-09,-0.2036D-09,-0.2465D-09,
     ,  -0.2985D-09,-0.3619D-09,-0.4376D-09,-0.5305D-09,-0.6449D-09,
     ,  -0.7789D-09,-0.9459D-09,-0.1143D-08,-0.1388D-08,-0.1681D-08,
     ,  -0.2036D-08,-0.2465D-08,-0.2989D-08,-0.3618D-08,-0.4377D-08,
     ,  -0.5314D-08,-0.6417D-08,-0.7782D-08,-0.9406D-08,-0.1141D-07,
     ,  -0.1376D-07,-0.1663D-07,-0.2004D-07,-0.2410D-07,-0.2892D-07,
     ,  -0.3453D-07,-0.4096D-07,-0.4827D-07,-0.5605D-07,-0.6431D-07,
     ,  -0.7259D-07,-0.8061D-07,-0.8798D-07,-0.9430D-07,-0.9899D-07,
     ,  -0.1028D-06,-0.1050D-06,-0.1065D-06,-0.1071D-06,-0.1065D-06,
     ,  -0.1050D-06,-0.1023D-06,-0.9816D-07,-0.9224D-07,-0.8386D-07,
     ,  -0.7272D-07,-0.5806D-07,-0.3836D-07,-0.1351D-07, 0.1576D-07,
     ,   0.4695D-07, 0.7440D-07, 0.8639D-07, 0.6662D-07, 0.4978D-08,
     ,  -0.9194D-07,-0.1918D-06,-0.2524D-06,-0.2533D-06,-0.2092D-06,
     ,  -0.1515D-06,-0.1030D-06,-0.7002D-07,-0.4970D-07,-0.3651D-07,
     ,  -0.2759D-07,-0.2081D-07,-0.1564D-07/


      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c--------------------------
      subroutine clhqg21(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.8140D-09, 0.3983D-09, 0.2484D-09, 0.1872D-09, 0.1570D-09,
     ,   0.1779D-09, 0.2507D-09, 0.3894D-09, 0.6955D-09, 0.1180D-08,
     ,   0.1989D-08, 0.3354D-08, 0.5605D-08, 0.9235D-08, 0.1522D-07,
     ,   0.2454D-07, 0.3944D-07, 0.6283D-07, 0.9950D-07, 0.1558D-06,
     ,   0.2422D-06, 0.3723D-06, 0.5663D-06, 0.8515D-06, 0.1261D-05,
     ,   0.1837D-05, 0.2622D-05, 0.3646D-05, 0.4907D-05, 0.6329D-05,
     ,   0.7710D-05, 0.8705D-05, 0.8817D-05, 0.7619D-05, 0.4941D-05,
     ,   0.1145D-05,-0.2960D-05,-0.6562D-05,-0.9207D-05,-0.1084D-04,
     ,  -0.1161D-04,-0.1166D-04,-0.1118D-04,-0.1032D-04,-0.9242D-05,
     ,  -0.8087D-05,-0.6975D-05,-0.5990D-05,-0.5196D-05,-0.4656D-05,
     ,  -0.4393D-05,-0.4306D-05,-0.4151D-05,-0.3738D-05,-0.3181D-05,
     ,  -0.2832D-05,-0.2936D-05,-0.3453D-05,-0.4169D-05,-0.4880D-05,
     ,  -0.5494D-05,-0.5980D-05,-0.6360D-05,-0.6652D-05,-0.6873D-05,
     ,  -0.7045D-05,-0.7173D-05,-0.7268D-05,-0.7337D-05,-0.7390D-05,
     ,  -0.7428D-05,-0.7455D-05,-0.7477D-05/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1196D-08, 0.5751D-09, 0.3774D-09, 0.2600D-09, 0.2194D-09,
     ,   0.2439D-09, 0.3563D-09, 0.5674D-09, 0.1002D-08, 0.1701D-08,
     ,   0.2821D-08, 0.4939D-08, 0.8222D-08, 0.1357D-07, 0.2224D-07,
     ,   0.3593D-07, 0.5780D-07, 0.9223D-07, 0.1458D-06, 0.2285D-06,
     ,   0.3552D-06, 0.5462D-06, 0.8309D-06, 0.1249D-05, 0.1850D-05,
     ,   0.2695D-05, 0.3847D-05, 0.5350D-05, 0.7200D-05, 0.9291D-05,
     ,   0.1132D-04, 0.1279D-04, 0.1300D-04, 0.1132D-04, 0.7598D-05,
     ,   0.2444D-05,-0.2879D-05,-0.7264D-05,-0.1013D-04,-0.1162D-04,
     ,  -0.1211D-04,-0.1192D-04,-0.1128D-04,-0.1033D-04,-0.9225D-05,
     ,  -0.8093D-05,-0.7047D-05,-0.6164D-05,-0.5506D-05,-0.5157D-05,
     ,  -0.5135D-05,-0.5311D-05,-0.5323D-05,-0.4911D-05,-0.4241D-05,
     ,  -0.3833D-05,-0.4067D-05,-0.4892D-05,-0.5988D-05,-0.7073D-05,
     ,  -0.7993D-05,-0.8730D-05,-0.9301D-05,-0.9738D-05,-0.1007D-04,
     ,  -0.1033D-04,-0.1052D-04,-0.1066D-04,-0.1076D-04,-0.1084D-04,
     ,  -0.1090D-04,-0.1094D-04,-0.1097D-04/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1783D-08, 0.8722D-09, 0.5558D-09, 0.4044D-09, 0.3399D-09,
     ,   0.3904D-09, 0.5536D-09, 0.8773D-09, 0.1508D-08, 0.2549D-08,
     ,   0.4333D-08, 0.7275D-08, 0.1217D-07, 0.1995D-07, 0.3266D-07,
     ,   0.5303D-07, 0.8499D-07, 0.1355D-06, 0.2141D-06, 0.3356D-06,
     ,   0.5216D-06, 0.8011D-06, 0.1220D-05, 0.1833D-05, 0.2715D-05,
     ,   0.3955D-05, 0.5645D-05, 0.7851D-05, 0.1057D-04, 0.1363D-04,
     ,   0.1662D-04, 0.1878D-04, 0.1912D-04, 0.1675D-04, 0.1150D-04,
     ,   0.4342D-05,-0.2806D-05,-0.8312D-05,-0.1149D-04,-0.1274D-04,
     ,  -0.1286D-04,-0.1231D-04,-0.1142D-04,-0.1034D-04,-0.9190D-05,
     ,  -0.8094D-05,-0.7141D-05,-0.6406D-05,-0.5952D-05,-0.5874D-05,
     ,  -0.6214D-05,-0.6772D-05,-0.7040D-05,-0.6617D-05,-0.5773D-05,
     ,  -0.5283D-05,-0.5721D-05,-0.6997D-05,-0.8651D-05,-0.1028D-04,
     ,  -0.1166D-04,-0.1276D-04,-0.1362D-04,-0.1427D-04,-0.1477D-04,
     ,  -0.1515D-04,-0.1543D-04,-0.1564D-04,-0.1580D-04,-0.1591D-04,
     ,  -0.1600D-04,-0.1606D-04,-0.1610D-04/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.2593D-08, 0.1275D-08, 0.8231D-09, 0.5773D-09, 0.5011D-09,
     ,   0.5604D-09, 0.8488D-09, 0.1337D-08, 0.2221D-08, 0.3674D-08,
     ,   0.6330D-08, 0.1061D-07, 0.1772D-07, 0.2923D-07, 0.4792D-07,
     ,   0.7753D-07, 0.1246D-06, 0.1986D-06, 0.3142D-06, 0.4915D-06,
     ,   0.7645D-06, 0.1177D-05, 0.1788D-05, 0.2688D-05, 0.3982D-05,
     ,   0.5801D-05, 0.8279D-05, 0.1152D-04, 0.1550D-04, 0.1999D-04,
     ,   0.2438D-04, 0.2757D-04, 0.2810D-04, 0.2469D-04, 0.1720D-04,
     ,   0.7142D-05,-0.2678D-05,-0.9836D-05,-0.1343D-04,-0.1445D-04,
     ,  -0.1391D-04,-0.1288D-04,-0.1162D-04,-0.1035D-04,-0.9141D-05,
     ,  -0.8098D-05,-0.7286D-05,-0.6768D-05,-0.6612D-05,-0.6942D-05,
     ,  -0.7799D-05,-0.8933D-05,-0.9550D-05,-0.9135D-05,-0.8035D-05,
     ,  -0.7436D-05,-0.8149D-05,-0.1008D-04,-0.1258D-04,-0.1499D-04,
     ,  -0.1705D-04,-0.1868D-04,-0.1995D-04,-0.2092D-04,-0.2165D-04,
     ,  -0.2221D-04,-0.2263D-04,-0.2294D-04,-0.2318D-04,-0.2335D-04,
     ,  -0.2347D-04,-0.2356D-04,-0.2362D-04/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.3798D-08, 0.1839D-08, 0.1183D-08, 0.8227D-09, 0.6504D-09,
     ,   0.8364D-09, 0.1138D-08, 0.1841D-08, 0.3174D-08, 0.5383D-08,
     ,   0.9135D-08, 0.1548D-07, 0.2585D-07, 0.4264D-07, 0.7006D-07,
     ,   0.1135D-06, 0.1830D-06, 0.2907D-06, 0.4601D-06, 0.7212D-06,
     ,   0.1121D-05, 0.1732D-05, 0.2620D-05, 0.3940D-05, 0.5838D-05,
     ,   0.8503D-05, 0.1214D-04, 0.1689D-04, 0.2273D-04, 0.2932D-04,
     ,   0.3576D-04, 0.4045D-04, 0.4124D-04, 0.3641D-04, 0.2559D-04,
     ,   0.1124D-04,-0.2507D-05,-0.1202D-04,-0.1636D-04,-0.1687D-04,
     ,  -0.1555D-04,-0.1368D-04,-0.1193D-04,-0.1036D-04,-0.9071D-05,
     ,  -0.8102D-05,-0.7506D-05,-0.7300D-05,-0.7581D-05,-0.8492D-05,
     ,  -0.1014D-04,-0.1209D-04,-0.1325D-04,-0.1281D-04,-0.1136D-04,
     ,  -0.1058D-04,-0.1172D-04,-0.1461D-04,-0.1831D-04,-0.2190D-04,
     ,  -0.2494D-04,-0.2736D-04,-0.2923D-04,-0.3066D-04,-0.3175D-04,
     ,  -0.3257D-04,-0.3319D-04,-0.3365D-04,-0.3399D-04,-0.3425D-04,
     ,  -0.3443D-04,-0.3456D-04,-0.3466D-04/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.5568D-08, 0.2708D-08, 0.1756D-08, 0.1185D-08, 0.1037D-08,
     ,   0.1261D-08, 0.1627D-08, 0.2663D-08, 0.4670D-08, 0.7959D-08,
     ,   0.1342D-07, 0.2283D-07, 0.3797D-07, 0.6261D-07, 0.1031D-06,
     ,   0.1662D-06, 0.2674D-06, 0.4267D-06, 0.6749D-06, 0.1057D-05,
     ,   0.1643D-05, 0.2526D-05, 0.3842D-05, 0.5776D-05, 0.8557D-05,
     ,   0.1247D-04, 0.1779D-04, 0.2475D-04, 0.3331D-04, 0.4298D-04,
     ,   0.5242D-04, 0.5933D-04, 0.6052D-04, 0.5355D-04, 0.3785D-04,
     ,   0.1726D-04,-0.2206D-05,-0.1526D-04,-0.2058D-04,-0.2047D-04,
     ,  -0.1787D-04,-0.1492D-04,-0.1234D-04,-0.1041D-04,-0.8957D-05,
     ,  -0.8111D-05,-0.7815D-05,-0.8077D-05,-0.8981D-05,-0.1077D-04,
     ,  -0.1357D-04,-0.1670D-04,-0.1865D-04,-0.1822D-04,-0.1623D-04,
     ,  -0.1521D-04,-0.1693D-04,-0.2126D-04,-0.2673D-04,-0.3203D-04,
     ,  -0.3652D-04,-0.4008D-04,-0.4284D-04,-0.4495D-04,-0.4654D-04,
     ,  -0.4778D-04,-0.4869D-04,-0.4936D-04,-0.4987D-04,-0.5025D-04,
     ,  -0.5051D-04,-0.5069D-04,-0.5084D-04/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.8218D-08, 0.3940D-08, 0.2480D-08, 0.1858D-08, 0.1511D-08,
     ,   0.1803D-08, 0.2536D-08, 0.3875D-08, 0.6965D-08, 0.1173D-07,
     ,   0.1979D-07, 0.3339D-07, 0.5521D-07, 0.9186D-07, 0.1502D-06,
     ,   0.2444D-06, 0.3911D-06, 0.6248D-06, 0.9877D-06, 0.1548D-05,
     ,   0.2406D-05, 0.3699D-05, 0.5626D-05, 0.8457D-05, 0.1253D-04,
     ,   0.1825D-04, 0.2606D-04, 0.3624D-04, 0.4879D-04, 0.6295D-04,
     ,   0.7682D-04, 0.8687D-04, 0.8874D-04, 0.7855D-04, 0.5590D-04,
     ,   0.2604D-04,-0.1784D-05,-0.1998D-04,-0.2680D-04,-0.2572D-04,
     ,  -0.2130D-04,-0.1667D-04,-0.1298D-04,-0.1040D-04,-0.8781D-05,
     ,  -0.8120D-05,-0.8240D-05,-0.9220D-05,-0.1105D-04,-0.1410D-04,
     ,  -0.1853D-04,-0.2349D-04,-0.2658D-04,-0.2610D-04,-0.2337D-04,
     ,  -0.2197D-04,-0.2458D-04,-0.3098D-04,-0.3905D-04,-0.4685D-04,
     ,  -0.5346D-04,-0.5874D-04,-0.6279D-04,-0.6589D-04,-0.6825D-04,
     ,  -0.7004D-04,-0.7137D-04,-0.7238D-04,-0.7312D-04,-0.7365D-04,
     ,  -0.7406D-04,-0.7434D-04,-0.7455D-04/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1192D-07, 0.5831D-08, 0.3709D-08, 0.2527D-08, 0.2202D-08,
     ,   0.2401D-08, 0.3548D-08, 0.5694D-08, 0.9899D-08, 0.1689D-07,
     ,   0.2837D-07, 0.4796D-07, 0.8048D-07, 0.1345D-06, 0.2195D-06,
     ,   0.3568D-06, 0.5724D-06, 0.9131D-06, 0.1444D-05, 0.2264D-05,
     ,   0.3518D-05, 0.5410D-05, 0.8232D-05, 0.1237D-04, 0.1833D-04,
     ,   0.2670D-04, 0.3812D-04, 0.5302D-04, 0.7138D-04, 0.9211D-04,
     ,   0.1124D-03, 0.1272D-03, 0.1300D-03, 0.1152D-03, 0.8229D-04,
     ,   0.3901D-04,-0.1078D-05,-0.2675D-04,-0.3595D-04,-0.3333D-04,
     ,  -0.2633D-04,-0.1924D-04,-0.1389D-04,-0.1045D-04,-0.8553D-05,
     ,  -0.8126D-05,-0.8900D-05,-0.1085D-04,-0.1408D-04,-0.1896D-04,
     ,  -0.2585D-04,-0.3337D-04,-0.3817D-04,-0.3769D-04,-0.3385D-04,
     ,  -0.3192D-04,-0.3581D-04,-0.4524D-04,-0.5709D-04,-0.6859D-04,
     ,  -0.7830D-04,-0.8602D-04,-0.9199D-04,-0.9655D-04,-0.1000D-03,
     ,  -0.1026D-03,-0.1046D-03,-0.1061D-03,-0.1072D-03,-0.1079D-03,
     ,  -0.1085D-03,-0.1090D-03,-0.1093D-03/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1760D-07, 0.8711D-08, 0.5592D-08, 0.3976D-08, 0.3420D-08,
     ,   0.3952D-08, 0.5536D-08, 0.8762D-08, 0.1516D-07, 0.2476D-07,
     ,   0.4288D-07, 0.7185D-07, 0.1196D-06, 0.1965D-06, 0.3229D-06,
     ,   0.5225D-06, 0.8377D-06, 0.1337D-05, 0.2112D-05, 0.3310D-05,
     ,   0.5144D-05, 0.7907D-05, 0.1202D-04, 0.1808D-04, 0.2678D-04,
     ,   0.3902D-04, 0.5570D-04, 0.7748D-04, 0.1043D-03, 0.1346D-03,
     ,   0.1643D-03, 0.1861D-03, 0.1902D-03, 0.1686D-03, 0.1208D-03,
     ,   0.5803D-04,-0.1255D-06,-0.3713D-04,-0.4917D-04,-0.4448D-04,
     ,  -0.3350D-04,-0.2304D-04,-0.1518D-04,-0.1041D-04,-0.8122D-05,
     ,  -0.7987D-05,-0.9754D-05,-0.1316D-04,-0.1835D-04,-0.2596D-04,
     ,  -0.3636D-04,-0.4770D-04,-0.5506D-04,-0.5460D-04,-0.4904D-04,
     ,  -0.4630D-04,-0.5218D-04,-0.6608D-04,-0.8347D-04,-0.1003D-03,
     ,  -0.1146D-03,-0.1260D-03,-0.1347D-03,-0.1414D-03,-0.1465D-03,
     ,  -0.1504D-03,-0.1533D-03,-0.1554D-03,-0.1570D-03,-0.1582D-03,
     ,  -0.1590D-03,-0.1597D-03,-0.1601D-03/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.2578D-07, 0.1258D-07, 0.8097D-08, 0.5702D-08, 0.4950D-08,
     ,   0.5630D-08, 0.8398D-08, 0.1303D-07, 0.2086D-07, 0.3663D-07,
     ,   0.6155D-07, 0.1047D-06, 0.1739D-06, 0.2865D-06, 0.4694D-06,
     ,   0.7600D-06, 0.1219D-05, 0.1946D-05, 0.3082D-05, 0.4814D-05,
     ,   0.7495D-05, 0.1151D-04, 0.1753D-04, 0.2634D-04, 0.3903D-04,
     ,   0.5686D-04, 0.8116D-04, 0.1129D-03, 0.1521D-03, 0.1963D-03,
     ,   0.2396D-03, 0.2715D-03, 0.2777D-03, 0.2466D-03, 0.1770D-03,
     ,   0.8535D-04, 0.1834D-05,-0.5174D-04,-0.6834D-04,-0.6072D-04,
     ,  -0.4435D-04,-0.2812D-04,-0.1705D-04,-0.1028D-04,-0.7400D-05,
     ,  -0.7801D-05,-0.1095D-04,-0.1647D-04,-0.2453D-04,-0.3615D-04,
     ,  -0.5169D-04,-0.6857D-04,-0.7954D-04,-0.7911D-04,-0.7139D-04,
     ,  -0.6746D-04,-0.7611D-04,-0.9633D-04,-0.1219D-03,-0.1467D-03,
     ,  -0.1676D-03,-0.1842D-03,-0.1971D-03,-0.2069D-03,-0.2144D-03,
     ,  -0.2200D-03,-0.2243D-03,-0.2274D-03,-0.2297D-03,-0.2315D-03,
     ,  -0.2327D-03,-0.2336D-03,-0.2343D-03/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.3755D-07, 0.1815D-07, 0.1161D-07, 0.8223D-08, 0.7094D-08,
     ,   0.6993D-08, 0.1057D-07, 0.1822D-07, 0.3030D-07, 0.5265D-07,
     ,   0.8926D-07, 0.1502D-06, 0.2508D-06, 0.4129D-06, 0.6797D-06,
     ,   0.1101D-05, 0.1764D-05, 0.2825D-05, 0.4460D-05, 0.7000D-05,
     ,   0.1088D-04, 0.1673D-04, 0.2545D-04, 0.3826D-04, 0.5668D-04,
     ,   0.8257D-04, 0.1179D-03, 0.1641D-03, 0.2210D-03, 0.2854D-03,
     ,   0.3485D-03, 0.3950D-03, 0.4043D-03, 0.3597D-03, 0.2591D-03,
     ,   0.1261D-03, 0.4422D-05,-0.7228D-04,-0.9610D-04,-0.8449D-04,
     ,  -0.5940D-04,-0.3614D-04,-0.1947D-04,-0.1003D-04,-0.6266D-05,
     ,  -0.7420D-05,-0.1255D-04,-0.2123D-04,-0.3349D-04,-0.5079D-04,
     ,  -0.7384D-04,-0.9887D-04,-0.1152D-03,-0.1150D-03,-0.1039D-03,
     ,  -0.9849D-04,-0.1110D-03,-0.1406D-03,-0.1779D-03,-0.2141D-03,
     ,  -0.2448D-03,-0.2691D-03,-0.2879D-03,-0.3023D-03,-0.3132D-03,
     ,  -0.3215D-03,-0.3276D-03,-0.3323D-03,-0.3357D-03,-0.3382D-03,
     ,  -0.3400D-03,-0.3413D-03,-0.3423D-03/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.5483D-07, 0.2660D-07, 0.1668D-07, 0.1203D-07, 0.9662D-08,
     ,   0.1087D-07, 0.1611D-07, 0.2641D-07, 0.4473D-07, 0.7633D-07,
     ,   0.1289D-06, 0.2176D-06, 0.3633D-06, 0.5987D-06, 0.9849D-06,
     ,   0.1593D-05, 0.2561D-05, 0.4086D-05, 0.6452D-05, 0.1011D-04,
     ,   0.1573D-04, 0.2418D-04, 0.3678D-04, 0.5530D-04, 0.8194D-04,
     ,   0.1194D-03, 0.1705D-03, 0.2373D-03, 0.3198D-03, 0.4131D-03,
     ,   0.5048D-03, 0.5728D-03, 0.5865D-03, 0.5230D-03, 0.3774D-03,
     ,   0.1857D-03, 0.9038D-05,-0.1021D-03,-0.1364D-03,-0.1182D-03,
     ,  -0.8132D-04,-0.4684D-04,-0.2280D-04,-0.9224D-05,-0.4179D-05,
     ,  -0.6395D-05,-0.1445D-04,-0.2760D-04,-0.4597D-04,-0.7153D-04,
     ,  -0.1053D-03,-0.1419D-03,-0.1665D-03,-0.1667D-03,-0.1510D-03,
     ,  -0.1432D-03,-0.1613D-03,-0.2047D-03,-0.2590D-03,-0.3121D-03,
     ,  -0.3566D-03,-0.3925D-03,-0.4198D-03,-0.4406D-03,-0.4568D-03,
     ,  -0.4688D-03,-0.4779D-03,-0.4847D-03,-0.4897D-03,-0.4934D-03,
     ,  -0.4960D-03,-0.4980D-03,-0.4990D-03/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.8003D-07, 0.3916D-07, 0.2496D-07, 0.1774D-07, 0.1499D-07,
     ,   0.1589D-07, 0.2284D-07, 0.3766D-07, 0.6523D-07, 0.1089D-06,
     ,   0.1848D-06, 0.3124D-06, 0.5146D-06, 0.8593D-06, 0.1408D-05,
     ,   0.2282D-05, 0.3676D-05, 0.5856D-05, 0.9270D-05, 0.1452D-04,
     ,   0.2257D-04, 0.3470D-04, 0.5279D-04, 0.7942D-04, 0.1177D-03,
     ,   0.1715D-03, 0.2449D-03, 0.3410D-03, 0.4596D-03, 0.5940D-03,
     ,   0.7266D-03, 0.8248D-03, 0.8471D-03, 0.7564D-03, 0.5482D-03,
     ,   0.2723D-03, 0.1663D-04,-0.1440D-03,-0.1933D-03,-0.1664D-03,
     ,  -0.1122D-03,-0.6194D-04,-0.2690D-04,-0.7115D-05,-0.7111D-06,
     ,  -0.3987D-05,-0.1641D-04,-0.3584D-04,-0.6309D-04,-0.1003D-03,
     ,  -0.1497D-03,-0.2031D-03,-0.2395D-03,-0.2410D-03,-0.2190D-03,
     ,  -0.2076D-03,-0.2341D-03,-0.2967D-03,-0.3761D-03,-0.4528D-03,
     ,  -0.5184D-03,-0.5699D-03,-0.6103D-03,-0.6407D-03,-0.6639D-03,
     ,  -0.6816D-03,-0.6949D-03,-0.7047D-03,-0.7121D-03,-0.7175D-03,
     ,  -0.7213D-03,-0.7240D-03,-0.7259D-03/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1146D-06, 0.5618D-07, 0.3591D-07, 0.2535D-07, 0.2054D-07,
     ,   0.2223D-07, 0.3231D-07, 0.5209D-07, 0.9084D-07, 0.1536D-06,
     ,   0.2669D-06, 0.4417D-06, 0.7405D-06, 0.1222D-05, 0.2000D-05,
     ,   0.3242D-05, 0.5213D-05, 0.8306D-05, 0.1315D-04, 0.2060D-04,
     ,   0.3205D-04, 0.4929D-04, 0.7501D-04, 0.1128D-03, 0.1672D-03,
     ,   0.2438D-03, 0.3483D-03, 0.4851D-03, 0.6542D-03, 0.8464D-03,
     ,   0.1036D-02, 0.1179D-02, 0.1213D-02, 0.1086D-02, 0.7916D-03,
     ,   0.3971D-03, 0.2913D-04,-0.2042D-03,-0.2776D-03,-0.2407D-03,
     ,  -0.1639D-03,-0.9241D-04,-0.4308D-04,-0.1651D-04,-0.8593D-05,
     ,  -0.1536D-04,-0.3451D-04,-0.6408D-04,-0.1043D-03,-0.1588D-03,
     ,  -0.2302D-03,-0.3082D-03,-0.3620D-03,-0.3666D-03,-0.3365D-03,
     ,  -0.3208D-03,-0.3586D-03,-0.4487D-03,-0.5632D-03,-0.6750D-03,
     ,  -0.7697D-03,-0.8450D-03,-0.9032D-03,-0.9476D-03,-0.9813D-03,
     ,  -0.1007D-02,-0.1026D-02,-0.1040D-02,-0.1051D-02,-0.1059D-02,
     ,  -0.1065D-02,-0.1069D-02,-0.1072D-02/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1668D-06, 0.8185D-07, 0.5282D-07, 0.3672D-07, 0.3213D-07,
     ,   0.3556D-07, 0.4983D-07, 0.7661D-07, 0.1256D-06, 0.2186D-06,
     ,   0.3732D-06, 0.6223D-06, 0.1041D-05, 0.1713D-05, 0.2812D-05,
     ,   0.4547D-05, 0.7319D-05, 0.1165D-04, 0.1843D-04, 0.2888D-04,
     ,   0.4490D-04, 0.6904D-04, 0.1051D-03, 0.1580D-03, 0.2343D-03,
     ,   0.3417D-03, 0.4884D-03, 0.6807D-03, 0.9188D-03, 0.1190D-02,
     ,   0.1459D-02, 0.1664D-02, 0.1719D-02, 0.1546D-02, 0.1137D-02,
     ,   0.5771D-03, 0.5414D-04,-0.2837D-03,-0.3900D-03,-0.3353D-03,
     ,  -0.2269D-03,-0.1225D-03,-0.5131D-04,-0.1302D-04,-0.9773D-06,
     ,  -0.1151D-04,-0.3924D-04,-0.8222D-04,-0.1399D-03,-0.2176D-03,
     ,  -0.3198D-03,-0.4318D-03,-0.5124D-03,-0.5222D-03,-0.4817D-03,
     ,  -0.4597D-03,-0.5140D-03,-0.6429D-03,-0.8067D-03,-0.9679D-03,
     ,  -0.1105D-02,-0.1214D-02,-0.1298D-02,-0.1362D-02,-0.1412D-02,
     ,  -0.1448D-02,-0.1476D-02,-0.1497D-02,-0.1513D-02,-0.1524D-02,
     ,  -0.1532D-02,-0.1538D-02,-0.1542D-02/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.2366D-06, 0.1150D-06, 0.7523D-07, 0.5250D-07, 0.4268D-07,
     ,   0.4727D-07, 0.6189D-07, 0.1093D-06, 0.1794D-06, 0.3052D-06,
     ,   0.5098D-06, 0.8559D-06, 0.1422D-05, 0.2350D-05, 0.3841D-05,
     ,   0.6235D-05, 0.1001D-04, 0.1597D-04, 0.2525D-04, 0.3955D-04,
     ,   0.6154D-04, 0.9463D-04, 0.1441D-03, 0.2167D-03, 0.3215D-03,
     ,   0.4691D-03, 0.6711D-03, 0.9361D-03, 0.1265D-02, 0.1641D-02,
     ,   0.2019D-02, 0.2309D-02, 0.2396D-02, 0.2168D-02, 0.1609D-02,
     ,   0.8382D-03, 0.9772D-04,-0.3783D-03,-0.5363D-03,-0.4650D-03,
     ,  -0.3073D-03,-0.1601D-03,-0.5706D-04,-0.1739D-05, 0.1472D-04,
     ,   0.1785D-06,-0.3916D-04,-0.1007D-03,-0.1829D-03,-0.2922D-03,
     ,  -0.4358D-03,-0.5953D-03,-0.7132D-03,-0.7356D-03,-0.6844D-03,
     ,  -0.6557D-03,-0.7298D-03,-0.9112D-03,-0.1144D-02,-0.1374D-02,
     ,  -0.1571D-02,-0.1727D-02,-0.1848D-02,-0.1941D-02,-0.2011D-02,
     ,  -0.2064D-02,-0.2104D-02,-0.2134D-02,-0.2156D-02,-0.2172D-02,
     ,  -0.2184D-02,-0.2192D-02,-0.2199D-02/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.3320D-06, 0.1615D-06, 0.1029D-06, 0.7027D-07, 0.5568D-07,
     ,   0.5629D-07, 0.9108D-07, 0.1415D-06, 0.2346D-06, 0.3911D-06,
     ,   0.6740D-06, 0.1125D-05, 0.1891D-05, 0.3104D-05, 0.5104D-05,
     ,   0.8282D-05, 0.1330D-04, 0.2123D-04, 0.3357D-04, 0.5263D-04,
     ,   0.8193D-04, 0.1261D-03, 0.1919D-03, 0.2888D-03, 0.4288D-03,
     ,   0.6260D-03, 0.8965D-03, 0.1252D-02, 0.1695D-02, 0.2205D-02,
     ,   0.2720D-02, 0.3126D-02, 0.3262D-02, 0.2986D-02, 0.2246D-02,
     ,   0.1203D-02, 0.1808D-03,-0.4943D-03,-0.7243D-03,-0.6319D-03,
     ,  -0.4115D-03,-0.1993D-03,-0.5270D-04, 0.2623D-04, 0.5075D-04,
     ,   0.3083D-04,-0.2498D-04,-0.1104D-03,-0.2253D-03,-0.3760D-03,
     ,  -0.5734D-03,-0.7972D-03,-0.9702D-03,-0.1016D-02,-0.9563D-03,
     ,  -0.9191D-03,-0.1019D-02,-0.1269D-02,-0.1597D-02,-0.1923D-02,
     ,  -0.2202D-02,-0.2424D-02,-0.2596D-02,-0.2728D-02,-0.2828D-02,
     ,  -0.2903D-02,-0.2960D-02,-0.3003D-02,-0.3034D-02,-0.3057D-02,
     ,  -0.3074D-02,-0.3086D-02,-0.3095D-02/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.4612D-06, 0.2237D-06, 0.1424D-06, 0.1040D-06, 0.8288D-07,
     ,   0.7550D-07, 0.1197D-06, 0.1745D-06, 0.2993D-06, 0.5048D-06,
     ,   0.8602D-06, 0.1450D-05, 0.2419D-05, 0.3974D-05, 0.6537D-05,
     ,   0.1061D-04, 0.1706D-04, 0.2712D-04, 0.4302D-04, 0.6739D-04,
     ,   0.1048D-03, 0.1614D-03, 0.2458D-03, 0.3702D-03, 0.5498D-03,
     ,   0.8034D-03, 0.1152D-02, 0.1611D-02, 0.2187D-02, 0.2854D-02,
     ,   0.3537D-02, 0.4092D-02, 0.4309D-02, 0.3993D-02, 0.3062D-02,
     ,   0.1697D-02, 0.3276D-03,-0.6049D-03,-0.9466D-03,-0.8298D-03,
     ,  -0.5305D-03,-0.2358D-03,-0.2922D-04, 0.8498D-04, 0.1203D-03,
     ,   0.9514D-04, 0.1934D-04,-0.9744D-04,-0.2538D-03,-0.4568D-03,
     ,  -0.7222D-03,-0.1027D-02,-0.1278D-02,-0.1366D-02,-0.1309D-02,
     ,  -0.1265D-02,-0.1397D-02,-0.1734D-02,-0.2183D-02,-0.2635D-02,
     ,  -0.3026D-02,-0.3339D-02,-0.3580D-02,-0.3765D-02,-0.3905D-02,
     ,  -0.4012D-02,-0.4092D-02,-0.4152D-02,-0.4196D-02,-0.4229D-02,
     ,  -0.4252D-02,-0.4270D-02,-0.4282D-02/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.6237D-06, 0.2961D-06, 0.1855D-06, 0.1365D-06, 0.1123D-06,
     ,   0.1152D-06, 0.1461D-06, 0.2164D-06, 0.3758D-06, 0.6095D-06,
     ,   0.1036D-05, 0.1750D-05, 0.2920D-05, 0.4878D-05, 0.7922D-05,
     ,   0.1287D-04, 0.2057D-04, 0.3298D-04, 0.5215D-04, 0.8170D-04,
     ,   0.1272D-03, 0.1959D-03, 0.2987D-03, 0.4500D-03, 0.6690D-03,
     ,   0.9790D-03, 0.1405D-02, 0.1971D-02, 0.2683D-02, 0.3515D-02,
     ,   0.4383D-02, 0.5112D-02, 0.5451D-02, 0.5135D-02, 0.4033D-02,
     ,   0.2339D-02, 0.5736D-03,-0.6886D-03,-0.1180D-02,-0.1057D-02,
     ,  -0.6548D-03,-0.2527D-03, 0.3784D-04, 0.1951D-03, 0.2498D-03,
     ,   0.2190D-03, 0.1198D-03,-0.3357D-04,-0.2416D-03,-0.5056D-03,
     ,  -0.8482D-03,-0.1251D-02,-0.1606D-02,-0.1770D-02,-0.1734D-02,
     ,  -0.1691D-02,-0.1858D-02,-0.2293D-02,-0.2897D-02,-0.3509D-02,
     ,  -0.4048D-02,-0.4478D-02,-0.4812D-02,-0.5067D-02,-0.5260D-02,
     ,  -0.5408D-02,-0.5518D-02,-0.5602D-02,-0.5662D-02,-0.5707D-02,
     ,  -0.5740D-02,-0.5764D-02,-0.5783D-02/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.8201D-06, 0.3923D-06, 0.2402D-06, 0.1653D-06, 0.1266D-06,
     ,   0.1198D-06, 0.1563D-06, 0.2395D-06, 0.4184D-06, 0.6872D-06,
     ,   0.1169D-05, 0.1969D-05, 0.3311D-05, 0.5482D-05, 0.8890D-05,
     ,   0.1447D-04, 0.2329D-04, 0.3725D-04, 0.5899D-04, 0.9246D-04,
     ,   0.1442D-03, 0.2221D-03, 0.3388D-03, 0.5110D-03, 0.7605D-03,
     ,   0.1115D-02, 0.1604D-02, 0.2255D-02, 0.3082D-02, 0.4061D-02,
     ,   0.5102D-02, 0.6018D-02, 0.6505D-02, 0.6261D-02, 0.5063D-02,
     ,   0.3106D-02, 0.9424D-03,-0.6926D-03,-0.1392D-02,-0.1280D-02,
     ,  -0.7712D-03,-0.2286D-03, 0.1619D-03, 0.3843D-03, 0.4655D-03,
     ,   0.4328D-03, 0.3129D-03, 0.1178D-03,-0.1462D-03,-0.4794D-03,
     ,  -0.9023D-03,-0.1409D-02,-0.1891D-02,-0.2172D-02,-0.2201D-02,
     ,  -0.2174D-02,-0.2374D-02,-0.2915D-02,-0.3688D-02,-0.4503D-02,
     ,  -0.5217D-02,-0.5800D-02,-0.6249D-02,-0.6593D-02,-0.6857D-02,
     ,  -0.7054D-02,-0.7204D-02,-0.7316D-02,-0.7401D-02,-0.7463D-02,
     ,  -0.7507D-02,-0.7539D-02,-0.7562D-02/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.1031D-05, 0.5042D-06, 0.3100D-06, 0.2160D-06, 0.1611D-06,
     ,   0.1595D-06, 0.1842D-06, 0.2779D-06, 0.4615D-06, 0.7464D-06,
     ,   0.1237D-05, 0.2112D-05, 0.3415D-05, 0.5719D-05, 0.9350D-05,
     ,   0.1510D-04, 0.2430D-04, 0.3886D-04, 0.6141D-04, 0.9645D-04,
     ,   0.1503D-03, 0.2318D-03, 0.3538D-03, 0.5340D-03, 0.7960D-03,
     ,   0.1169D-02, 0.1685D-02, 0.2379D-02, 0.3265D-02, 0.4330D-02,
     ,   0.5489D-02, 0.6553D-02, 0.7225D-02, 0.7113D-02, 0.5976D-02,
     ,   0.3891D-02, 0.1426D-02,-0.5676D-03,-0.1530D-02,-0.1471D-02,
     ,  -0.8590D-03,-0.1634D-03, 0.3620D-03, 0.6678D-03, 0.7895D-03,
     ,   0.7644D-03, 0.6260D-03, 0.3925D-03, 0.7435D-04,-0.3217D-03,
     ,  -0.8217D-03,-0.1426D-02,-0.2043D-02,-0.2479D-02,-0.2627D-02,
     ,  -0.2652D-02,-0.2882D-02,-0.3516D-02,-0.4461D-02,-0.5489D-02,
     ,  -0.6420D-02,-0.7179D-02,-0.7771D-02,-0.8222D-02,-0.8566D-02,
     ,  -0.8829D-02,-0.9024D-02,-0.9174D-02,-0.9283D-02,-0.9365D-02,
     ,  -0.9425D-02,-0.9468D-02,-0.9499D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.1222D-05, 0.5926D-06, 0.3776D-06, 0.2515D-06, 0.1922D-06,
     ,   0.1698D-06, 0.1920D-06, 0.2590D-06, 0.4321D-06, 0.7067D-06,
     ,   0.1148D-05, 0.1899D-05, 0.3215D-05, 0.5298D-05, 0.8821D-05,
     ,   0.1420D-04, 0.2295D-04, 0.3658D-04, 0.5796D-04, 0.9109D-04,
     ,   0.1421D-03, 0.2193D-03, 0.3355D-03, 0.5069D-03, 0.7561D-03,
     ,   0.1112D-02, 0.1609D-02, 0.2278D-02, 0.3144D-02, 0.4200D-02,
     ,   0.5378D-02, 0.6512D-02, 0.7318D-02, 0.7415D-02, 0.6487D-02,
     ,   0.4501D-02, 0.1948D-02,-0.3252D-03,-0.1551D-02,-0.1610D-02,
     ,  -0.9249D-03,-0.6368D-04, 0.6187D-03, 0.1034D-02, 0.1214D-02,
     ,   0.1213D-02, 0.1071D-02, 0.8080D-03, 0.4504D-03,-0.4700D-06,
     ,  -0.5548D-03,-0.1227D-02,-0.1959D-02,-0.2569D-02,-0.2888D-02,
     ,  -0.3013D-02,-0.3275D-02,-0.3962D-02,-0.5046D-02,-0.6286D-02,
     ,  -0.7441D-02,-0.8402D-02,-0.9151D-02,-0.9725D-02,-0.1016D-01,
     ,  -0.1049D-01,-0.1075D-01,-0.1094D-01,-0.1107D-01,-0.1118D-01,
     ,  -0.1126D-01,-0.1131D-01,-0.1135D-01/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.1381D-05, 0.6805D-06, 0.4322D-06, 0.2761D-06, 0.1962D-06,
     ,   0.1610D-06, 0.1725D-06, 0.2235D-06, 0.3819D-06, 0.6199D-06,
     ,   0.9718D-06, 0.1665D-05, 0.2719D-05, 0.4559D-05, 0.7473D-05,
     ,   0.1202D-04, 0.1947D-04, 0.3111D-04, 0.4921D-04, 0.7747D-04,
     ,   0.1210D-03, 0.1862D-03, 0.2861D-03, 0.4319D-03, 0.6470D-03,
     ,   0.9533D-03, 0.1382D-02, 0.1965D-02, 0.2726D-02, 0.3668D-02,
     ,   0.4746D-02, 0.5831D-02, 0.6686D-02, 0.6972D-02, 0.6355D-02,
     ,   0.4701D-02, 0.2315D-02,-0.1922D-04,-0.1471D-02,-0.1693D-02,
     ,  -0.9975D-03, 0.7884D-05, 0.8675D-03, 0.1418D-02, 0.1684D-02,
     ,   0.1726D-02, 0.1599D-02, 0.1337D-02, 0.9585D-03, 0.4796D-03,
     ,  -0.9881D-04,-0.8003D-03,-0.1597D-02,-0.2347D-02,-0.2866D-02,
     ,  -0.3137D-02,-0.3442D-02,-0.4128D-02,-0.5274D-02,-0.6673D-02,
     ,  -0.8040D-02,-0.9202D-02,-0.1012D-01,-0.1082D-01,-0.1136D-01,
     ,  -0.1176D-01,-0.1207D-01,-0.1230D-01,-0.1248D-01,-0.1261D-01,
     ,  -0.1270D-01,-0.1277D-01,-0.1282D-01/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.1471D-05, 0.7263D-06, 0.4569D-06, 0.3047D-06, 0.1994D-06,
     ,   0.1638D-06, 0.1588D-06, 0.1887D-06, 0.3023D-06, 0.5318D-06,
     ,   0.6886D-06, 0.1204D-05, 0.2148D-05, 0.3423D-05, 0.5763D-05,
     ,   0.9198D-05, 0.1487D-04, 0.2367D-04, 0.3759D-04, 0.5919D-04,
     ,   0.9253D-04, 0.1432D-03, 0.2191D-03, 0.3312D-03, 0.4960D-03,
     ,   0.7331D-03, 0.1066D-02, 0.1522D-02, 0.2121D-02, 0.2873D-02,
     ,   0.3753D-02, 0.4673D-02, 0.5460D-02, 0.5849D-02, 0.5536D-02,
     ,   0.4324D-02, 0.2348D-02, 0.1931D-03,-0.1353D-02,-0.1759D-02,
     ,  -0.1138D-02,-0.3445D-04, 0.1002D-02, 0.1716D-02, 0.2093D-02,
     ,   0.2207D-02, 0.2123D-02, 0.1887D-02, 0.1523D-02, 0.1052D-02,
     ,   0.4792D-03,-0.2036D-03,-0.9936D-03,-0.1813D-02,-0.2496D-02,
     ,  -0.2938D-02,-0.3305D-02,-0.3940D-02,-0.5043D-02,-0.6498D-02,
     ,  -0.8014D-02,-0.9353D-02,-0.1043D-01,-0.1126D-01,-0.1189D-01,
     ,  -0.1237D-01,-0.1274D-01,-0.1301D-01,-0.1322D-01,-0.1337D-01,
     ,  -0.1349D-01,-0.1357D-01,-0.1363D-01/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.1477D-05, 0.7250D-06, 0.4520D-06, 0.2988D-06, 0.1949D-06,
     ,   0.1635D-06, 0.1456D-06, 0.1469D-06, 0.2323D-06, 0.4094D-06,
     ,   0.5612D-06, 0.8746D-06, 0.1431D-05, 0.2405D-05, 0.3991D-05,
     ,   0.6366D-05, 0.1024D-04, 0.1641D-04, 0.2591D-04, 0.4081D-04,
     ,   0.6399D-04, 0.9906D-04, 0.1515D-03, 0.2293D-03, 0.3446D-03,
     ,   0.5096D-03, 0.7427D-03, 0.1062D-02, 0.1486D-02, 0.2024D-02,
     ,   0.2664D-02, 0.3352D-02, 0.3978D-02, 0.4352D-02, 0.4238D-02,
     ,   0.3443D-02, 0.1969D-02, 0.1762D-03,-0.1296D-02,-0.1858D-02,
     ,  -0.1384D-02,-0.2747D-03, 0.9111D-03, 0.1808D-02, 0.2329D-02,
     ,   0.2537D-02, 0.2525D-02, 0.2346D-02, 0.2033D-02, 0.1602D-02,
     ,   0.1075D-02, 0.4478D-03,-0.2788D-03,-0.1078D-02,-0.1840D-02,
     ,  -0.2424D-02,-0.2868D-02,-0.3428D-02,-0.4381D-02,-0.5752D-02,
     ,  -0.7309D-02,-0.8771D-02,-0.9982D-02,-0.1092D-01,-0.1164D-01,
     ,  -0.1218D-01,-0.1260D-01,-0.1291D-01,-0.1315D-01,-0.1333D-01,
     ,  -0.1346D-01,-0.1355D-01,-0.1363D-01/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.1400D-05, 0.6793D-06, 0.4283D-06, 0.2833D-06, 0.1909D-06,
     ,   0.1438D-06, 0.1243D-06, 0.1073D-06, 0.1784D-06, 0.3122D-06,
     ,   0.2823D-06, 0.5731D-06, 0.9464D-06, 0.1465D-05, 0.2469D-05,
     ,   0.4023D-05, 0.6437D-05, 0.1031D-04, 0.1641D-04, 0.2580D-04,
     ,   0.4054D-04, 0.6240D-04, 0.9526D-04, 0.1456D-03, 0.2180D-03,
     ,   0.3232D-03, 0.4711D-03, 0.6750D-03, 0.9467D-03, 0.1295D-02,
     ,   0.1711D-02, 0.2167D-02, 0.2596D-02, 0.2874D-02, 0.2841D-02,
     ,   0.2336D-02, 0.1307D-02,-0.6960D-04,-0.1348D-02,-0.2001D-02,
     ,  -0.1732D-02,-0.7242D-03, 0.5370D-03, 0.1608D-02, 0.2299D-02,
     ,   0.2636D-02, 0.2716D-02, 0.2615D-02, 0.2376D-02, 0.2023D-02,
     ,   0.1569D-02, 0.1028D-02, 0.3973D-03,-0.3140D-03,-0.1052D-02,
     ,  -0.1706D-02,-0.2218D-02,-0.2715D-02,-0.3463D-02,-0.4613D-02,
     ,  -0.6062D-02,-0.7544D-02,-0.8842D-02,-0.9873D-02,-0.1066D-01,
     ,  -0.1126D-01,-0.1171D-01,-0.1205D-01,-0.1231D-01,-0.1251D-01,
     ,  -0.1266D-01,-0.1277D-01,-0.1285D-01/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1252D-05, 0.6163D-06, 0.3789D-06, 0.2351D-06, 0.1679D-06,
     ,   0.1127D-06, 0.8778D-07, 0.7897D-07, 0.1137D-06, 0.1859D-06,
     ,   0.2206D-06, 0.3414D-06, 0.4887D-06, 0.7948D-06, 0.1458D-05,
     ,   0.2365D-05, 0.3725D-05, 0.6088D-05, 0.9603D-05, 0.1498D-04,
     ,   0.2375D-04, 0.3661D-04, 0.5548D-04, 0.8519D-04, 0.1277D-03,
     ,   0.1890D-03, 0.2767D-03, 0.3954D-03, 0.5558D-03, 0.7596D-03,
     ,   0.1005D-02, 0.1275D-02, 0.1528D-02, 0.1692D-02, 0.1661D-02,
     ,   0.1322D-02, 0.6091D-03,-0.4060D-03,-0.1459D-02,-0.2136D-02,
     ,  -0.2091D-02,-0.1299D-02,-0.8639D-04, 0.1102D-02, 0.1973D-02,
     ,   0.2468D-02, 0.2664D-02, 0.2653D-02, 0.2504D-02, 0.2240D-02,
     ,   0.1884D-02, 0.1443D-02, 0.9283D-03, 0.3365D-03,-0.3046D-03,
     ,  -0.9403D-03,-0.1483D-02,-0.1950D-02,-0.2504D-02,-0.3357D-02,
     ,  -0.4554D-02,-0.5921D-02,-0.7224D-02,-0.8315D-02,-0.9156D-02,
     ,  -0.9792D-02,-0.1027D-01,-0.1064D-01,-0.1091D-01,-0.1113D-01,
     ,  -0.1128D-01,-0.1140D-01,-0.1149D-01/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.1077D-05, 0.5147D-06, 0.3266D-06, 0.2181D-06, 0.1428D-06,
     ,   0.9227D-07, 0.7548D-07, 0.5601D-07, 0.7640D-07, 0.8080D-07,
     ,   0.6242D-07, 0.1975D-06, 0.3588D-06, 0.4044D-06, 0.8734D-06,
     ,   0.1360D-05, 0.2071D-05, 0.3281D-05, 0.5332D-05, 0.8222D-05,
     ,   0.1315D-04, 0.2020D-04, 0.3139D-04, 0.4733D-04, 0.7031D-04,
     ,   0.1041D-03, 0.1516D-03, 0.2175D-03, 0.3045D-03, 0.4152D-03,
     ,   0.5469D-03, 0.6900D-03, 0.8191D-03, 0.8896D-03, 0.8379D-03,
     ,   0.5858D-03, 0.7812D-04,-0.6721D-03,-0.1509D-02,-0.2175D-02,
     ,  -0.2338D-02,-0.1843D-02,-0.8192D-03, 0.3772D-03, 0.1387D-02,
     ,   0.2054D-02, 0.2385D-02, 0.2481D-02, 0.2419D-02, 0.2251D-02,
     ,   0.1993D-02, 0.1661D-02, 0.1260D-02, 0.7951D-03, 0.2774D-03,
     ,  -0.2710D-03,-0.7918D-03,-0.1237D-02,-0.1669D-02,-0.2242D-02,
     ,  -0.3108D-02,-0.4229D-02,-0.5428D-02,-0.6511D-02,-0.7385D-02,
     ,  -0.8052D-02,-0.8551D-02,-0.8928D-02,-0.9213D-02,-0.9432D-02,
     ,  -0.9598D-02,-0.9721D-02,-0.9811D-02/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.8861D-06, 0.4293D-06, 0.2655D-06, 0.1784D-06, 0.1246D-06,
     ,   0.8416D-07, 0.5968D-07, 0.4629D-07, 0.7177D-07, 0.6111D-07,
     ,   0.6629D-07, 0.3486D-07, 0.2345D-06, 0.2894D-06, 0.4185D-06,
     ,   0.7893D-06, 0.1040D-05, 0.1816D-05, 0.2858D-05, 0.4389D-05,
     ,   0.7054D-05, 0.1065D-04, 0.1633D-04, 0.2472D-04, 0.3696D-04,
     ,   0.5466D-04, 0.7976D-04, 0.1133D-03, 0.1575D-03, 0.2140D-03,
     ,   0.2793D-03, 0.3462D-03, 0.4019D-03, 0.4157D-03, 0.3497D-03,
     ,   0.1532D-03,-0.2170D-03,-0.7662D-03,-0.1435D-02,-0.2044D-02,
     ,  -0.2361D-02,-0.2182D-02,-0.1467D-02,-0.4234D-03, 0.6337D-03,
     ,   0.1443D-02, 0.1928D-02, 0.2143D-02, 0.2175D-02, 0.2092D-02,
     ,   0.1924D-02, 0.1692D-02, 0.1397D-02, 0.1053D-02, 0.6556D-03,
     ,   0.2226D-03,-0.2260D-03,-0.6405D-03,-0.1005D-02,-0.1398D-02,
     ,  -0.1948D-02,-0.2748D-02,-0.3728D-02,-0.4720D-02,-0.5583D-02,
     ,  -0.6266D-02,-0.6780D-02,-0.7162D-02,-0.7451D-02,-0.7672D-02,
     ,  -0.7839D-02,-0.7965D-02,-0.8060D-02/
      data (calcpts(j,30), j = 1,neta) /
     ,   0.7174D-06, 0.3419D-06, 0.2176D-06, 0.1397D-06, 0.9784D-07,
     ,   0.6195D-07, 0.5236D-07, 0.4023D-07, 0.3292D-07, 0.4079D-07,
     ,   0.2887D-07, 0.5524D-07, 0.7298D-07, 0.2083D-06, 0.3176D-06,
     ,   0.3752D-06, 0.5218D-06, 0.9454D-06, 0.1514D-05, 0.2240D-05,
     ,   0.3599D-05, 0.5443D-05, 0.8233D-05, 0.1254D-04, 0.1849D-04,
     ,   0.2741D-04, 0.3984D-04, 0.5683D-04, 0.7737D-04, 0.1040D-03,
     ,   0.1338D-03, 0.1616D-03, 0.1789D-03, 0.1675D-03, 0.1018D-03,
     ,  -0.4829D-04,-0.3177D-03,-0.7208D-03,-0.1233D-02,-0.1760D-02,
     ,  -0.2153D-02,-0.2229D-02,-0.1858D-02,-0.1095D-02,-0.1480D-03,
     ,   0.7250D-03, 0.1348D-02, 0.1693D-02, 0.1825D-02, 0.1822D-02,
     ,   0.1734D-02, 0.1583D-02, 0.1383D-02, 0.1135D-02, 0.8489D-03,
     ,   0.5230D-03, 0.1740D-03,-0.1798D-03,-0.5049D-03,-0.8023D-03,
     ,  -0.1145D-02,-0.1640D-02,-0.2332D-02,-0.3144D-02,-0.3934D-02,
     ,  -0.4607D-02,-0.5125D-02,-0.5513D-02,-0.5801D-02,-0.6021D-02,
     ,  -0.6187D-02,-0.6311D-02,-0.6407D-02/
      data (calcpts(j,31), j = 1,neta) /
     ,   0.5606D-06, 0.2723D-06, 0.1809D-06, 0.1174D-06, 0.7095D-07,
     ,   0.5525D-07, 0.3153D-07, 0.2693D-07, 0.3366D-07, 0.3098D-07,
     ,   0.2288D-07, 0.3158D-07, 0.4996D-07, 0.5596D-07, 0.1686D-06,
     ,   0.1721D-06, 0.3074D-06, 0.4158D-06, 0.7473D-06, 0.1167D-05,
     ,   0.1792D-05, 0.2704D-05, 0.4073D-05, 0.6084D-05, 0.9118D-05,
     ,   0.1334D-04, 0.1904D-04, 0.2752D-04, 0.3628D-04, 0.4887D-04,
     ,   0.6041D-04, 0.6955D-04, 0.7059D-04, 0.5187D-04,-0.2913D-05,
     ,  -0.1132D-03,-0.3036D-03,-0.5892D-03,-0.9660D-03,-0.1392D-02,
     ,  -0.1787D-02,-0.2007D-02,-0.1933D-02,-0.1499D-02,-0.7863D-03,
     ,   0.1983D-04, 0.7093D-03, 0.1175D-02, 0.1416D-02, 0.1494D-02,
     ,   0.1474D-02, 0.1391D-02, 0.1263D-02, 0.1097D-02, 0.8973D-03,
     ,   0.6668D-03, 0.4073D-03, 0.1336D-03,-0.1406D-03,-0.3907D-03,
     ,  -0.6289D-03,-0.9210D-03,-0.1342D-02,-0.1915D-02,-0.2559D-02,
     ,  -0.3176D-02,-0.3682D-02,-0.4074D-02,-0.4361D-02,-0.4577D-02,
     ,  -0.4737D-02,-0.4862D-02,-0.4957D-02/
      data (calcpts(j,32), j = 1,neta) /
     ,   0.4312D-06, 0.2096D-06, 0.1332D-06, 0.8817D-07, 0.4848D-07,
     ,   0.4092D-07, 0.2352D-07, 0.2894D-07, 0.1692D-07, 0.1828D-07,
     ,   0.1687D-07, 0.3264D-07, 0.4089D-07, 0.3834D-07, 0.9882D-07,
     ,   0.8045D-07, 0.1766D-06, 0.2580D-06, 0.3912D-06, 0.4935D-06,
     ,   0.8852D-06, 0.1388D-05, 0.1973D-05, 0.3023D-05, 0.4507D-05,
     ,   0.6395D-05, 0.9317D-05, 0.1268D-04, 0.1721D-04, 0.2133D-04,
     ,   0.2571D-04, 0.2742D-04, 0.2257D-04, 0.5348D-05,-0.3542D-04,
     ,  -0.1126D-03,-0.2416D-03,-0.4362D-03,-0.7014D-03,-0.1024D-02,
     ,  -0.1360D-02,-0.1631D-02,-0.1739D-02,-0.1587D-02,-0.1167D-02,
     ,  -0.5462D-03, 0.1030D-03, 0.6349D-03, 0.9768D-03, 0.1143D-02,
     ,   0.1188D-02, 0.1160D-02, 0.1088D-02, 0.9834D-03, 0.8507D-03,
     ,   0.6926D-03, 0.5114D-03, 0.3116D-03, 0.9980D-04,-0.1077D-03,
     ,  -0.2991D-03,-0.4875D-03,-0.7262D-03,-0.1072D-02,-0.1528D-02,
     ,  -0.2030D-02,-0.2497D-02,-0.2877D-02,-0.3165D-02,-0.3377D-02,
     ,  -0.3535D-02,-0.3655D-02,-0.3745D-02/
      data (calcpts(j,33), j = 1,neta) /
     ,   0.3228D-06, 0.1555D-06, 0.9657D-07, 0.6185D-07, 0.4174D-07,
     ,   0.2719D-07, 0.1409D-07, 0.1094D-07, 0.5565D-08,-0.3384D-08,
     ,   0.1285D-08, 0.5804D-08, 0.6987D-08, 0.4765D-08, 0.2402D-07,
     ,   0.4323D-07, 0.1872D-07, 0.1645D-07, 0.1420D-06, 0.2835D-06,
     ,   0.3538D-06, 0.6157D-06, 0.7964D-06, 0.1411D-05, 0.1957D-05,
     ,   0.2826D-05, 0.4211D-05, 0.5637D-05, 0.7211D-05, 0.8650D-05,
     ,   0.1034D-04, 0.8741D-05, 0.3978D-05,-0.9856D-05,-0.3819D-04,
     ,  -0.8908D-04,-0.1738D-03,-0.3012D-03,-0.4788D-03,-0.7060D-03,
     ,  -0.9652D-03,-0.1216D-02,-0.1396D-02,-0.1431D-02,-0.1260D-02,
     ,  -0.8826D-03,-0.3755D-03, 0.1348D-03, 0.5365D-03, 0.7842D-03,
     ,   0.8977D-03, 0.9227D-03, 0.8945D-03, 0.8348D-03, 0.7514D-03,
     ,   0.6478D-03, 0.5254D-03, 0.3864D-03, 0.2340D-03, 0.7388D-04,
     ,  -0.8211D-04,-0.2267D-03,-0.3733D-03,-0.5632D-03,-0.8373D-03,
     ,  -0.1192D-02,-0.1574D-02,-0.1923D-02,-0.2204D-02,-0.2415D-02,
     ,  -0.2570D-02,-0.2685D-02,-0.2771D-02/
      data (calcpts(j,34), j = 1,neta) /
     ,   0.2427D-06, 0.1168D-06, 0.7317D-07, 0.4716D-07, 0.2916D-07,
     ,   0.1995D-07, 0.1337D-07, 0.1423D-07, 0.1872D-07, 0.1383D-07,
     ,  -0.6977D-08, 0.1484D-08, 0.4848D-08,-0.6140D-08, 0.2753D-07,
     ,   0.2319D-07, 0.2063D-07, 0.5239D-07, 0.1313D-06, 0.1275D-06,
     ,   0.2730D-06, 0.2593D-06, 0.4517D-06, 0.5863D-06, 0.9825D-06,
     ,   0.1298D-05, 0.1909D-05, 0.2462D-05, 0.3077D-05, 0.3501D-05,
     ,   0.3022D-05, 0.1581D-05,-0.2442D-05,-0.1206D-04,-0.2999D-04,
     ,  -0.6274D-04,-0.1152D-03,-0.1964D-03,-0.3106D-03,-0.4620D-03,
     ,  -0.6462D-03,-0.8448D-03,-0.1027D-02,-0.1143D-02,-0.1138D-02,
     ,  -0.9737D-03,-0.6569D-03,-0.2540D-03, 0.1367D-03, 0.4356D-03,
     ,   0.6139D-03, 0.6917D-03, 0.7037D-03, 0.6785D-03, 0.6305D-03,
     ,   0.5656D-03, 0.4861D-03, 0.3929D-03, 0.2879D-03, 0.1731D-03,
     ,   0.5373D-04,-0.6258D-04,-0.1708D-03,-0.2830D-03,-0.4313D-03,
     ,  -0.6436D-03,-0.9135D-03,-0.1201D-02,-0.1459D-02,-0.1664D-02,
     ,  -0.1817D-02,-0.1929D-02,-0.2013D-02/
      data (calcpts(j,35), j = 1,neta) /
     ,   0.1803D-06, 0.8790D-07, 0.5586D-07, 0.3615D-07, 0.2303D-07,
     ,   0.1699D-07, 0.1197D-07, 0.8020D-08, 0.9870D-08, 0.7614D-08,
     ,   0.1239D-07, 0.8053D-08, 0.9375D-08, 0.5793D-08, 0.1798D-07,
     ,   0.2915D-07, 0.2918D-07, 0.2902D-07, 0.6073D-07, 0.6697D-07,
     ,   0.6312D-07, 0.9833D-07, 0.2244D-06, 0.3837D-06, 0.5246D-06,
     ,   0.6135D-06, 0.8930D-06, 0.1112D-05, 0.1205D-05, 0.1342D-05,
     ,   0.9347D-06,-0.3623D-06,-0.3483D-05,-0.9233D-05,-0.2114D-04,
     ,  -0.4126D-04,-0.7282D-04,-0.1224D-03,-0.1936D-03,-0.2902D-03,
     ,  -0.4127D-03,-0.5554D-03,-0.7046D-03,-0.8340D-03,-0.9067D-03,
     ,  -0.8830D-03,-0.7383D-03,-0.4831D-03,-0.1707D-03, 0.1241D-03,
     ,   0.3438D-03, 0.4714D-03, 0.5244D-03, 0.5294D-03, 0.5079D-03,
     ,   0.4705D-03, 0.4208D-03, 0.3605D-03, 0.2907D-03, 0.2121D-03,
     ,   0.1269D-03, 0.3811D-04,-0.4752D-04,-0.1279D-03,-0.2126D-03,
     ,  -0.3263D-03,-0.4879D-03,-0.6908D-03,-0.9036D-03,-0.1093D-02,
     ,  -0.1242D-02,-0.1352D-02,-0.1433D-02/
      data (calcpts(j,36), j = 1,neta) /
     ,   0.1314D-06, 0.6407D-07, 0.4004D-07, 0.2667D-07, 0.1545D-07,
     ,   0.1168D-07, 0.8141D-08, 0.5367D-08, 0.6285D-08, 0.8653D-08,
     ,   0.4607D-08, 0.8412D-08,-0.9946D-09, 0.5265D-09, 0.4719D-08,
     ,   0.7490D-08, 0.5597D-09, 0.2142D-07, 0.2102D-07, 0.2172D-07,
     ,   0.6757D-07, 0.1507D-06, 0.9561D-07, 0.1207D-06, 0.2371D-06,
     ,   0.2582D-06, 0.3892D-06, 0.4079D-06, 0.5039D-06, 0.3467D-06,
     ,  -0.3089D-07,-0.1000D-05,-0.2863D-05,-0.6793D-05,-0.1402D-04,
     ,  -0.2568D-04,-0.4498D-04,-0.7413D-04,-0.1173D-03,-0.1763D-03,
     ,  -0.2543D-03,-0.3496D-03,-0.4578D-03,-0.5670D-03,-0.6580D-03,
     ,  -0.7028D-03,-0.6729D-03,-0.5520D-03,-0.3527D-03,-0.1144D-03,
     ,   0.1050D-03, 0.2657D-03, 0.3566D-03, 0.3924D-03, 0.3940D-03,
     ,   0.3764D-03, 0.3477D-03, 0.3102D-03, 0.2653D-03, 0.2131D-03,
     ,   0.1551D-03, 0.9211D-04, 0.2714D-04,-0.3575D-04,-0.9488D-04,
     ,  -0.1586D-03,-0.2441D-03,-0.3654D-03,-0.5162D-03,-0.6724D-03,
     ,  -0.8099D-03,-0.9178D-03,-0.9972D-03/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.9601D-07, 0.4686D-07, 0.2974D-07, 0.1870D-07, 0.1187D-07,
     ,   0.7543D-08, 0.5006D-08, 0.3538D-08, 0.4869D-08, 0.4181D-08,
     ,   0.1264D-08,-0.5491D-08, 0.2560D-08, 0.1532D-08, 0.7486D-08,
     ,  -0.1314D-08, 0.8990D-08, 0.1538D-07, 0.1835D-07, 0.1246D-07,
     ,   0.3837D-07, 0.4175D-07, 0.4482D-07, 0.3270D-07, 0.1199D-06,
     ,   0.1024D-06, 0.1462D-06, 0.2173D-06, 0.1018D-06, 0.9938D-07,
     ,  -0.2115D-06,-0.9290D-06,-0.1998D-05,-0.4388D-05,-0.8541D-05,
     ,  -0.1543D-04,-0.2662D-04,-0.4390D-04,-0.6917D-04,-0.1041D-03,
     ,  -0.1517D-03,-0.2126D-03,-0.2852D-03,-0.3651D-03,-0.4447D-03,
     ,  -0.5087D-03,-0.5353D-03,-0.5054D-03,-0.4086D-03,-0.2553D-03,
     ,  -0.7659D-04, 0.8555D-04, 0.2021D-03, 0.2666D-03, 0.2909D-03,
     ,   0.2905D-03, 0.2768D-03, 0.2547D-03, 0.2269D-03, 0.1935D-03,
     ,   0.1553D-03, 0.1126D-03, 0.6644D-04, 0.1884D-04,-0.2691D-04,
     ,  -0.7004D-04,-0.1173D-03,-0.1810D-03,-0.2712D-03,-0.3823D-03,
     ,  -0.4962D-03,-0.5958D-03,-0.6730D-03/
      data (calcpts(j,38), j = 1,neta) /
     ,   0.6985D-07, 0.3309D-07, 0.2168D-07, 0.1288D-07, 0.1021D-07,
     ,   0.6674D-08, 0.6132D-08, 0.3781D-08, 0.3422D-08, 0.3889D-08,
     ,   0.3041D-08, 0.2299D-08, 0.3398D-08,-0.6225D-08, 0.6108D-08,
     ,   0.1253D-07, 0.3128D-08, 0.1232D-07, 0.1070D-07, 0.1965D-07,
     ,   0.2197D-07, 0.3677D-07, 0.2468D-07, 0.4539D-07, 0.5712D-07,
     ,   0.4733D-07, 0.4869D-07, 0.1546D-06, 0.8580D-08,-0.2220D-07,
     ,  -0.1348D-06,-0.5992D-06,-0.1213D-05,-0.2668D-05,-0.5062D-05,
     ,  -0.9034D-05,-0.1540D-04,-0.2522D-04,-0.3971D-04,-0.6036D-04,
     ,  -0.8859D-04,-0.1253D-03,-0.1716D-03,-0.2255D-03,-0.2849D-03,
     ,  -0.3422D-03,-0.3860D-03,-0.4023D-03,-0.3757D-03,-0.3005D-03,
     ,  -0.1838D-03,-0.5110D-04, 0.6759D-04, 0.1516D-03, 0.1975D-03,
     ,   0.2140D-03, 0.2128D-03, 0.2021D-03, 0.1855D-03, 0.1651D-03,
     ,   0.1403D-03, 0.1124D-03, 0.8120D-04, 0.4743D-04, 0.1305D-04,
     ,  -0.2005D-04,-0.5164D-04,-0.8604D-04,-0.1334D-03,-0.1998D-03,
     ,  -0.2809D-03,-0.3636D-03,-0.4352D-03/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.4987D-07, 0.2398D-07, 0.1531D-07, 0.8767D-08, 0.4702D-08,
     ,   0.4308D-08, 0.2295D-08, 0.1854D-09, 0.1779D-08, 0.6876D-09,
     ,  -0.3504D-09,-0.5685D-09,-0.1886D-08,-0.1768D-08, 0.1473D-08,
     ,  -0.9136D-08, 0.1590D-08,-0.1032D-07,-0.3178D-08,-0.9590D-08,
     ,  -0.9730D-09, 0.8162D-09,-0.8559D-09, 0.7969D-08,-0.3175D-08,
     ,   0.1925D-08, 0.3187D-07, 0.3759D-07,-0.6871D-08,-0.5545D-07,
     ,  -0.2123D-06,-0.4632D-06,-0.8098D-06,-0.1716D-05,-0.3058D-05,
     ,  -0.5291D-05,-0.8886D-05,-0.1444D-04,-0.2257D-04,-0.3445D-04,
     ,  -0.5076D-04,-0.7260D-04,-0.1005D-03,-0.1350D-03,-0.1749D-03,
     ,  -0.2185D-03,-0.2588D-03,-0.2898D-03,-0.2991D-03,-0.2770D-03,
     ,  -0.2192D-03,-0.1320D-03,-0.3462D-04, 0.5226D-04, 0.1127D-03,
     ,   0.1451D-03, 0.1563D-03, 0.1549D-03, 0.1467D-03, 0.1345D-03,
     ,   0.1194D-03, 0.1014D-03, 0.8096D-04, 0.5825D-04, 0.3405D-04,
     ,   0.9213D-05,-0.1480D-04,-0.3760D-04,-0.6284D-04,-0.9752D-04,
     ,  -0.1460D-03,-0.2050D-03,-0.2646D-03/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.3603D-07, 0.1722D-07, 0.1082D-07, 0.6804D-08, 0.4467D-08,
     ,   0.2448D-08, 0.2627D-08, 0.9458D-09, 0.1781D-08, 0.9925D-09,
     ,   0.4204D-09,-0.9789D-09, 0.2474D-10,-0.9037D-09, 0.1277D-08,
     ,   0.1141D-08,-0.4981D-08, 0.7380D-08, 0.8445D-08,-0.1010D-07,
     ,  -0.1200D-09,-0.2358D-08, 0.4620D-08, 0.9040D-08, 0.7771D-09,
     ,   0.5910D-08, 0.1629D-07, 0.6817D-08, 0.3070D-07,-0.1051D-06,
     ,  -0.6658D-07,-0.2513D-06,-0.5314D-06,-0.9958D-06,-0.1717D-05,
     ,  -0.2959D-05,-0.4981D-05,-0.8078D-05,-0.1267D-04,-0.1922D-04,
     ,  -0.2858D-04,-0.4114D-04,-0.5759D-04,-0.7869D-04,-0.1041D-03,
     ,  -0.1335D-03,-0.1647D-03,-0.1939D-03,-0.2150D-03,-0.2206D-03,
     ,  -0.2025D-03,-0.1591D-03,-0.9477D-04,-0.2300D-04, 0.3971D-04,
     ,   0.8313D-04, 0.1060D-03, 0.1136D-03, 0.1122D-03, 0.1060D-03,
     ,   0.9704D-04, 0.8594D-04, 0.7292D-04, 0.5809D-04, 0.4174D-04,
     ,   0.2421D-04, 0.6266D-05,-0.1099D-04,-0.2743D-04,-0.4573D-04,
     ,  -0.7098D-04,-0.1063D-03,-0.1489D-03/
      data (calcpts(j,41), j = 1,neta) /
     ,   0.2591D-07, 0.1259D-07, 0.8152D-08, 0.5173D-08, 0.3334D-08,
     ,   0.2534D-08, 0.2046D-08, 0.1271D-08, 0.1280D-08, 0.1940D-08,
     ,   0.1822D-08, 0.1442D-08, 0.3789D-10, 0.1497D-08, 0.2848D-08,
     ,   0.1839D-08, 0.1213D-08, 0.2774D-08,-0.6105D-08, 0.3718D-08,
     ,   0.9343D-08, 0.8625D-08, 0.7247D-09, 0.9927D-08, 0.1806D-07,
     ,   0.1230D-07, 0.1352D-07, 0.1567D-07,-0.7892D-08,-0.1903D-07,
     ,  -0.8294D-08,-0.2114D-06,-0.2697D-06,-0.5080D-06,-0.9768D-06,
     ,  -0.1672D-05,-0.2700D-05,-0.4381D-05,-0.6993D-05,-0.1062D-04,
     ,  -0.1582D-04,-0.2295D-04,-0.3249D-04,-0.4480D-04,-0.6031D-04,
     ,  -0.7903D-04,-0.1003D-03,-0.1228D-03,-0.1437D-03,-0.1584D-03,
     ,  -0.1615D-03,-0.1476D-03,-0.1149D-03,-0.6760D-04,-0.1545D-04,
     ,   0.2985D-04, 0.6088D-04, 0.7706D-04, 0.8219D-04, 0.8094D-04,
     ,   0.7632D-04, 0.6976D-04, 0.6167D-04, 0.5225D-04, 0.4155D-04,
     ,   0.2977D-04, 0.1715D-04, 0.4270D-05,-0.8072D-05,-0.1991D-04,
     ,  -0.3316D-04,-0.5146D-04,-0.7699D-04/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.1815D-07, 0.8900D-08, 0.5394D-08, 0.3568D-08, 0.2199D-08,
     ,   0.1621D-08, 0.1160D-08, 0.1568D-08, 0.5593D-09, 0.2344D-09,
     ,  -0.5625D-09,-0.5021D-09, 0.3853D-09,-0.2991D-09, 0.1195D-08,
     ,   0.2081D-08, 0.7870D-09, 0.5260D-09, 0.1114D-08,-0.6912D-08,
     ,  -0.3040D-08,-0.4606D-08,-0.6003D-08, 0.9594D-08, 0.3971D-08,
     ,   0.5514D-09, 0.1679D-08, 0.8551D-08,-0.8011D-08,-0.2055D-07,
     ,  -0.3526D-07,-0.9034D-07,-0.1040D-06,-0.3351D-06,-0.5392D-06,
     ,  -0.8788D-06,-0.1499D-05,-0.2452D-05,-0.3836D-05,-0.5865D-05,
     ,  -0.8727D-05,-0.1269D-04,-0.1808D-04,-0.2512D-04,-0.3426D-04,
     ,  -0.4556D-04,-0.5923D-04,-0.7464D-04,-0.9088D-04,-0.1057D-03,
     ,  -0.1159D-03,-0.1176D-03,-0.1069D-03,-0.8273D-04,-0.4818D-04,
     ,  -0.1037D-04, 0.2221D-04, 0.4433D-04, 0.5576D-04, 0.5923D-04,
     ,   0.5819D-04, 0.5477D-04, 0.4998D-04, 0.4413D-04, 0.3733D-04,
     ,   0.2963D-04, 0.2118D-04, 0.1214D-04, 0.2914D-05,-0.5898D-05,
     ,  -0.1436D-04,-0.2392D-04,-0.3715D-04/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.1304D-07, 0.6344D-08, 0.4245D-08, 0.2594D-08, 0.1872D-08,
     ,   0.1140D-08, 0.6875D-09, 0.5248D-09, 0.6600D-09, 0.1499D-09,
     ,  -0.8998D-09, 0.1147D-08, 0.1257D-08, 0.1051D-09, 0.1442D-08,
     ,  -0.5774D-10,-0.7150D-09, 0.1179D-08, 0.2668D-10, 0.1851D-09,
     ,   0.2543D-08, 0.6561D-08,-0.6958D-08, 0.5222D-08, 0.6321D-08,
     ,  -0.4142D-08, 0.1378D-07,-0.1010D-08,-0.2510D-08,-0.1263D-07,
     ,  -0.2514D-07,-0.5200D-07,-0.8255D-07,-0.1592D-06,-0.2334D-06,
     ,  -0.4504D-06,-0.8242D-06,-0.1377D-05,-0.2034D-05,-0.3122D-05,
     ,  -0.4694D-05,-0.6928D-05,-0.9944D-05,-0.1389D-04,-0.1919D-04,
     ,  -0.2577D-04,-0.3411D-04,-0.4399D-04,-0.5512D-04,-0.6666D-04,
     ,  -0.7723D-04,-0.8440D-04,-0.8519D-04,-0.7720D-04,-0.5938D-04,
     ,  -0.3428D-04,-0.6965D-05, 0.1640D-04, 0.3215D-04, 0.4016D-04,
     ,   0.4254D-04, 0.4171D-04, 0.3919D-04, 0.3571D-04, 0.3149D-04,
     ,   0.2661D-04, 0.2110D-04, 0.1503D-04, 0.8576D-05, 0.1995D-05,
     ,  -0.4299D-05,-0.1036D-04,-0.1718D-04/
      data (calcpts(j,44), j = 1,neta) /
     ,   0.9364D-08, 0.4024D-08, 0.2540D-08, 0.1545D-08, 0.1268D-08,
     ,   0.9107D-09, 0.6169D-09, 0.4704D-09, 0.4452D-09, 0.4937D-09,
     ,   0.4511D-09, 0.9374D-09,-0.5804D-09, 0.1181D-08, 0.2129D-08,
     ,   0.1773D-08, 0.7939D-09, 0.2349D-09, 0.6505D-09, 0.1818D-08,
     ,   0.2612D-08, 0.3203D-08, 0.1174D-08,-0.5601D-08, 0.4601D-08,
     ,  -0.2304D-08, 0.7897D-08, 0.9110D-08, 0.7875D-08, 0.2286D-08,
     ,  -0.6972D-08,-0.2401D-07,-0.3101D-07,-0.7306D-07,-0.1491D-06,
     ,  -0.2579D-06,-0.4252D-06,-0.6984D-06,-0.1116D-05,-0.1738D-05,
     ,  -0.2487D-05,-0.3712D-05,-0.5371D-05,-0.7633D-05,-0.1051D-04,
     ,  -0.1438D-04,-0.1919D-04,-0.2522D-04,-0.3239D-04,-0.4035D-04,
     ,  -0.4865D-04,-0.5614D-04,-0.6114D-04,-0.6150D-04,-0.5548D-04,
     ,  -0.4255D-04,-0.2428D-04,-0.4697D-05, 0.1200D-04, 0.2324D-04,
     ,   0.2885D-04, 0.3046D-04, 0.2981D-04, 0.2797D-04, 0.2545D-04,
     ,   0.2243D-04, 0.1890D-04, 0.1498D-04, 0.1064D-04, 0.6040D-05,
     ,   0.1346D-05,-0.3126D-05,-0.7427D-05/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.7133D-08, 0.3814D-08, 0.2633D-08, 0.1353D-08, 0.8691D-09,
     ,   0.8004D-09, 0.5385D-09, 0.4792D-09, 0.4980D-09, 0.1239D-10,
     ,  -0.1139D-09, 0.9068D-11,-0.1027D-09,-0.8861D-09,-0.5234D-09,
     ,   0.6383D-09,-0.1291D-11, 0.2056D-09,-0.1305D-08,-0.1963D-08,
     ,   0.1508D-09, 0.8106D-10,-0.1328D-08,-0.1169D-08,-0.2366D-08,
     ,  -0.1123D-07, 0.3640D-08,-0.9214D-08,-0.5235D-08,-0.5397D-08,
     ,  -0.1282D-07,-0.3205D-07,-0.2730D-07,-0.5759D-07,-0.1033D-06,
     ,  -0.1545D-06,-0.2561D-06,-0.3903D-06,-0.6088D-06,-0.9226D-06,
     ,  -0.1382D-05,-0.2023D-05,-0.2912D-05,-0.4136D-05,-0.5763D-05,
     ,  -0.7923D-05,-0.1070D-04,-0.1422D-04,-0.1854D-04,-0.2365D-04,
     ,  -0.2939D-04,-0.3538D-04,-0.4062D-04,-0.4413D-04,-0.4426D-04,
     ,  -0.3977D-04,-0.3042D-04,-0.1722D-04,-0.3200D-05, 0.8764D-05,
     ,   0.1671D-04, 0.2067D-04, 0.2177D-04, 0.2125D-04, 0.1992D-04,
     ,   0.1810D-04, 0.1593D-04, 0.1343D-04, 0.1062D-04, 0.7530D-05,
     ,   0.4263D-05, 0.9425D-06,-0.2252D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.5557D-08, 0.2817D-08, 0.1863D-08, 0.1334D-08, 0.1148D-08,
     ,   0.6605D-09, 0.1634D-09, 0.2672D-09, 0.4320D-09, 0.2550D-09,
     ,   0.9115D-10,-0.1125D-09, 0.8268D-10,-0.1164D-09, 0.3338D-09,
     ,  -0.8493D-09,-0.1175D-08,-0.6874D-09, 0.1085D-08,-0.1190D-08,
     ,   0.4026D-10,-0.7693D-09,-0.1322D-09,-0.3605D-09, 0.7121D-09,
     ,  -0.1821D-08, 0.1789D-08, 0.6320D-08, 0.4205D-08,-0.1205D-07,
     ,  -0.7092D-08,-0.1992D-07,-0.1375D-07,-0.3185D-07,-0.5861D-07,
     ,  -0.7692D-07,-0.1357D-06,-0.2124D-06,-0.3144D-06,-0.4795D-06,
     ,  -0.7243D-06,-0.1072D-05,-0.1550D-05,-0.2215D-05,-0.3104D-05,
     ,  -0.4304D-05,-0.5858D-05,-0.7876D-05,-0.1042D-04,-0.1353D-04,
     ,  -0.1721D-04,-0.2132D-04,-0.2553D-04,-0.2934D-04,-0.3174D-04,
     ,  -0.3172D-04,-0.2850D-04,-0.2164D-04,-0.1220D-04,-0.2108D-05,
     ,   0.6352D-05, 0.1199D-04, 0.1477D-04, 0.1551D-04, 0.1512D-04,
     ,   0.1415D-04, 0.1285D-04, 0.1130D-04, 0.9514D-05, 0.7513D-05,
     ,   0.5319D-05, 0.2994D-05, 0.6276D-06/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.3696D-08, 0.1432D-08, 0.9956D-09, 0.7555D-09, 0.6594D-09,
     ,   0.1947D-09, 0.3589D-09, 0.2129D-09, 0.4893D-09, 0.4442D-10,
     ,   0.3626D-09, 0.2296D-09, 0.2096D-09, 0.1655D-09, 0.3831D-09,
     ,   0.2881D-09,-0.4412D-09, 0.1044D-08,-0.4869D-09, 0.1080D-08,
     ,   0.1110D-10, 0.6821D-09,-0.2325D-10, 0.1738D-08, 0.4046D-09,
     ,   0.8562D-09, 0.2864D-08, 0.1780D-08, 0.7341D-09,-0.6973D-08,
     ,  -0.7545D-08, 0.2477D-08,-0.2989D-09,-0.1778D-07,-0.2038D-07,
     ,  -0.3740D-07,-0.6832D-07,-0.1017D-06,-0.1618D-06,-0.2459D-06,
     ,  -0.3748D-06,-0.5585D-06,-0.8158D-06,-0.1179D-05,-0.1657D-05,
     ,  -0.2308D-05,-0.3176D-05,-0.4306D-05,-0.5757D-05,-0.7581D-05,
     ,  -0.9822D-05,-0.1246D-04,-0.1540D-04,-0.1840D-04,-0.2105D-04,
     ,  -0.2273D-04,-0.2273D-04,-0.2033D-04,-0.1537D-04,-0.8624D-05,
     ,  -0.1439D-05, 0.4597D-05, 0.8579D-05, 0.1053D-04, 0.1103D-04,
     ,   0.1074D-04, 0.1004D-04, 0.9109D-05, 0.7999D-05, 0.6730D-05,
     ,   0.5307D-05, 0.3750D-05, 0.2098D-05/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.3372D-08, 0.2151D-08, 0.9082D-09, 0.3358D-09, 0.9498D-09,
     ,   0.6240D-09, 0.7410D-09, 0.1739D-09, 0.3023D-09, 0.2384D-09,
     ,   0.2054D-09, 0.1899D-09, 0.1365D-09, 0.1082D-09, 0.1602D-09,
     ,   0.9095D-10, 0.1434D-09, 0.5886D-10, 0.1113D-08,-0.2653D-09,
     ,   0.1312D-08, 0.6269D-09,-0.3032D-09, 0.4779D-09,-0.3237D-09,
     ,   0.9105D-10, 0.1418D-08, 0.5978D-09,-0.6251D-09,-0.7733D-09,
     ,  -0.8397D-08,-0.6404D-08, 0.3387D-08,-0.8010D-08,-0.7812D-08,
     ,  -0.2093D-07,-0.3207D-07,-0.6423D-07,-0.8979D-07,-0.1346D-06,
     ,  -0.1972D-06,-0.3023D-06,-0.4376D-06,-0.6173D-06,-0.8782D-06,
     ,  -0.1233D-05,-0.1708D-05,-0.2326D-05,-0.3149D-05,-0.4193D-05,
     ,  -0.5504D-05,-0.7103D-05,-0.8980D-05,-0.1107D-04,-0.1321D-04,
     ,  -0.1509D-04,-0.1627D-04,-0.1621D-04,-0.1446D-04,-0.1093D-04,
     ,  -0.6083D-05,-0.9687D-06, 0.3312D-05, 0.6123D-05, 0.7488D-05,
     ,   0.7833D-05, 0.7613D-05, 0.7110D-05, 0.6446D-05, 0.5656D-05,
     ,   0.4753D-05, 0.3743D-05, 0.2643D-05/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.1940D-08, 0.2539D-08,-0.1669D-08, 0.9206D-09,-0.9832D-09,
     ,  -0.3154D-10, 0.2057D-09, 0.6743D-09, 0.3210D-09, 0.1123D-09,
     ,  -0.1538D-09,-0.5593D-10,-0.1442D-09, 0.2064D-09, 0.2989D-09,
     ,   0.7608D-10,-0.7598D-10,-0.3727D-10, 0.1342D-09,-0.1684D-09,
     ,  -0.5414D-09,-0.6043D-09, 0.4853D-09, 0.2241D-09, 0.1916D-09,
     ,  -0.5591D-09, 0.1049D-08, 0.1203D-08, 0.5452D-09, 0.1676D-09,
     ,   0.3334D-09,-0.1452D-08,-0.1176D-08,-0.8504D-08,-0.1024D-07,
     ,  -0.4042D-08,-0.1526D-07,-0.2708D-07,-0.3894D-07,-0.7313D-07,
     ,  -0.1046D-06,-0.1527D-06,-0.2296D-06,-0.3320D-06,-0.4626D-06,
     ,  -0.6516D-06,-0.9145D-06,-0.1247D-05,-0.1696D-05,-0.2282D-05,
     ,  -0.3033D-05,-0.3969D-05,-0.5121D-05,-0.6455D-05,-0.7946D-05,
     ,  -0.9458D-05,-0.1079D-04,-0.1161D-04,-0.1154D-04,-0.1028D-04,
     ,  -0.7743D-05,-0.4291D-05,-0.6547D-06, 0.2380D-05, 0.4361D-05,
     ,   0.5316D-05, 0.5551D-05, 0.5389D-05, 0.5027D-05, 0.4554D-05,
     ,   0.3993D-05, 0.3353D-05, 0.2639D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c--------------------------
      subroutine clhqg22(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.7213D-12, 0.1220D-11, 0.2060D-11, 0.3473D-11, 0.5849D-11,
     ,   0.9834D-11, 0.1651D-10, 0.2766D-10, 0.4627D-10, 0.7725D-10,
     ,   0.1287D-09, 0.2139D-09, 0.3547D-09, 0.5867D-09, 0.9677D-09,
     ,   0.1591D-08, 0.2608D-08, 0.4258D-08, 0.6924D-08, 0.1121D-07,
     ,   0.1804D-07, 0.2888D-07, 0.4589D-07, 0.7231D-07, 0.1128D-06,
     ,   0.1737D-06, 0.2632D-06, 0.3908D-06, 0.5648D-06, 0.7881D-06,
     ,   0.1049D-05, 0.1312D-05, 0.1507D-05, 0.1543D-05, 0.1347D-05,
     ,   0.9151D-06, 0.3493D-06,-0.1932D-06,-0.5895D-06,-0.8067D-06,
     ,  -0.8828D-06,-0.8746D-06,-0.8236D-06,-0.7508D-06,-0.6635D-06,
     ,  -0.5640D-06,-0.4533D-06,-0.3328D-06,-0.2043D-06,-0.6835D-07,
     ,   0.7994D-07, 0.2524D-06, 0.4517D-06, 0.6443D-06, 0.7628D-06,
     ,   0.7569D-06, 0.6385D-06, 0.4679D-06, 0.3054D-06, 0.1820D-06,
     ,   0.1013D-06, 0.5350D-07, 0.2723D-07, 0.1349D-07, 0.6558D-08,
     ,   0.3144D-08, 0.1493D-08, 0.7041D-09, 0.3305D-09, 0.1546D-09,
     ,   0.7216D-10, 0.3362D-10, 0.1565D-10/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1058D-11, 0.1790D-11, 0.3022D-11, 0.5097D-11, 0.8582D-11,
     ,   0.1443D-10, 0.2422D-10, 0.4059D-10, 0.6790D-10, 0.1133D-09,
     ,   0.1888D-09, 0.3139D-09, 0.5205D-09, 0.8609D-09, 0.1420D-08,
     ,   0.2335D-08, 0.3826D-08, 0.6248D-08, 0.1016D-07, 0.1644D-07,
     ,   0.2648D-07, 0.4237D-07, 0.6734D-07, 0.1061D-06, 0.1655D-06,
     ,   0.2548D-06, 0.3862D-06, 0.5734D-06, 0.8288D-06, 0.1156D-05,
     ,   0.1540D-05, 0.1925D-05, 0.2211D-05, 0.2265D-05, 0.1976D-05,
     ,   0.1343D-05, 0.5129D-06,-0.2833D-06,-0.8650D-06,-0.1184D-05,
     ,  -0.1296D-05,-0.1283D-05,-0.1209D-05,-0.1102D-05,-0.9737D-06,
     ,  -0.8277D-06,-0.6652D-06,-0.4884D-06,-0.2998D-06,-0.1004D-06,
     ,   0.1172D-06, 0.3703D-06, 0.6628D-06, 0.9455D-06, 0.1119D-05,
     ,   0.1111D-05, 0.9371D-06, 0.6867D-06, 0.4483D-06, 0.2672D-06,
     ,   0.1486D-06, 0.7853D-07, 0.3997D-07, 0.1980D-07, 0.9625D-08,
     ,   0.4615D-08, 0.2191D-08, 0.1034D-08, 0.4851D-09, 0.2269D-09,
     ,   0.1059D-09, 0.4935D-10, 0.2297D-10/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1553D-11, 0.2626D-11, 0.4434D-11, 0.7477D-11, 0.1259D-10,
     ,   0.2117D-10, 0.3554D-10, 0.5955D-10, 0.9961D-10, 0.1663D-09,
     ,   0.2770D-09, 0.4605D-09, 0.7636D-09, 0.1263D-08, 0.2083D-08,
     ,   0.3425D-08, 0.5614D-08, 0.9166D-08, 0.1490D-07, 0.2413D-07,
     ,   0.3885D-07, 0.6217D-07, 0.9879D-07, 0.1557D-06, 0.2428D-06,
     ,   0.3739D-06, 0.5666D-06, 0.8413D-06, 0.1216D-05, 0.1697D-05,
     ,   0.2259D-05, 0.2824D-05, 0.3244D-05, 0.3323D-05, 0.2900D-05,
     ,   0.1971D-05, 0.7531D-06,-0.4153D-06,-0.1269D-05,-0.1737D-05,
     ,  -0.1901D-05,-0.1883D-05,-0.1774D-05,-0.1617D-05,-0.1429D-05,
     ,  -0.1215D-05,-0.9763D-06,-0.7168D-06,-0.4401D-06,-0.1474D-06,
     ,   0.1719D-06, 0.5432D-06, 0.9724D-06, 0.1387D-05, 0.1643D-05,
     ,   0.1630D-05, 0.1375D-05, 0.1008D-05, 0.6579D-06, 0.3922D-06,
     ,   0.2181D-06, 0.1153D-06, 0.5867D-07, 0.2907D-07, 0.1413D-07,
     ,   0.6774D-08, 0.3216D-08, 0.1517D-08, 0.7121D-09, 0.3331D-09,
     ,   0.1555D-09, 0.7244D-10, 0.3371D-10/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.2277D-11, 0.3851D-11, 0.6503D-11, 0.1097D-10, 0.1847D-10,
     ,   0.3105D-10, 0.5212D-10, 0.8735D-10, 0.1461D-09, 0.2439D-09,
     ,   0.4063D-09, 0.6754D-09, 0.1120D-08, 0.1853D-08, 0.3055D-08,
     ,   0.5024D-08, 0.8234D-08, 0.1344D-07, 0.2186D-07, 0.3539D-07,
     ,   0.5698D-07, 0.9119D-07, 0.1449D-06, 0.2283D-06, 0.3561D-06,
     ,   0.5484D-06, 0.8312D-06, 0.1234D-05, 0.1784D-05, 0.2489D-05,
     ,   0.3314D-05, 0.4143D-05, 0.4760D-05, 0.4876D-05, 0.4256D-05,
     ,   0.2893D-05, 0.1106D-05,-0.6084D-06,-0.1861D-05,-0.2548D-05,
     ,  -0.2789D-05,-0.2763D-05,-0.2602D-05,-0.2372D-05,-0.2097D-05,
     ,  -0.1782D-05,-0.1433D-05,-0.1052D-05,-0.6459D-06,-0.2165D-06,
     ,   0.2519D-06, 0.7966D-06, 0.1426D-05, 0.2035D-05, 0.2410D-05,
     ,   0.2392D-05, 0.2018D-05, 0.1479D-05, 0.9655D-06, 0.5756D-06,
     ,   0.3201D-06, 0.1692D-06, 0.8611D-07, 0.4267D-07, 0.2074D-07,
     ,   0.9942D-08, 0.4721D-08, 0.2227D-08, 0.1045D-08, 0.4889D-09,
     ,   0.2282D-09, 0.1063D-09, 0.4948D-10/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.3339D-11, 0.5647D-11, 0.9535D-11, 0.1608D-10, 0.2708D-10,
     ,   0.4553D-10, 0.7643D-10, 0.1281D-09, 0.2142D-09, 0.3576D-09,
     ,   0.5958D-09, 0.9904D-09, 0.1642D-08, 0.2716D-08, 0.4480D-08,
     ,   0.7367D-08, 0.1207D-07, 0.1971D-07, 0.3206D-07, 0.5189D-07,
     ,   0.8355D-07, 0.1337D-06, 0.2125D-06, 0.3348D-06, 0.5222D-06,
     ,   0.8042D-06, 0.1219D-05, 0.1810D-05, 0.2616D-05, 0.3650D-05,
     ,   0.4860D-05, 0.6076D-05, 0.6981D-05, 0.7153D-05, 0.6244D-05,
     ,   0.4246D-05, 0.1625D-05,-0.8906D-06,-0.2729D-05,-0.3737D-05,
     ,  -0.4091D-05,-0.4053D-05,-0.3818D-05,-0.3480D-05,-0.3076D-05,
     ,  -0.2615D-05,-0.2102D-05,-0.1544D-05,-0.9480D-06,-0.3182D-06,
     ,   0.3688D-06, 0.1168D-05, 0.2091D-05, 0.2984D-05, 0.3535D-05,
     ,   0.3509D-05, 0.2961D-05, 0.2170D-05, 0.1417D-05, 0.8447D-06,
     ,   0.4699D-06, 0.2483D-06, 0.1264D-06, 0.6262D-07, 0.3044D-07,
     ,   0.1459D-07, 0.6930D-08, 0.3268D-08, 0.1534D-08, 0.7176D-09,
     ,   0.3349D-09, 0.1561D-09, 0.7263D-10/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.4894D-11, 0.8275D-11, 0.1397D-10, 0.2357D-10, 0.3968D-10,
     ,   0.6672D-10, 0.1120D-09, 0.1877D-09, 0.3140D-09, 0.5241D-09,
     ,   0.8732D-09, 0.1451D-08, 0.2407D-08, 0.3981D-08, 0.6566D-08,
     ,   0.1080D-07, 0.1769D-07, 0.2889D-07, 0.4698D-07, 0.7605D-07,
     ,   0.1224D-06, 0.1960D-06, 0.3114D-06, 0.4908D-06, 0.7654D-06,
     ,   0.1179D-05, 0.1787D-05, 0.2653D-05, 0.3835D-05, 0.5351D-05,
     ,   0.7125D-05, 0.8909D-05, 0.1024D-04, 0.1049D-04, 0.9160D-05,
     ,   0.6232D-05, 0.2388D-05,-0.1302D-05,-0.3999D-05,-0.5480D-05,
     ,  -0.5999D-05,-0.5945D-05,-0.5599D-05,-0.5104D-05,-0.4511D-05,
     ,  -0.3835D-05,-0.3083D-05,-0.2265D-05,-0.1391D-05,-0.4679D-06,
     ,   0.5394D-06, 0.1711D-05, 0.3065D-05, 0.4375D-05, 0.5183D-05,
     ,   0.5146D-05, 0.4343D-05, 0.3184D-05, 0.2079D-05, 0.1239D-05,
     ,   0.6895D-06, 0.3644D-06, 0.1855D-06, 0.9191D-07, 0.4467D-07,
     ,   0.2142D-07, 0.1017D-07, 0.4797D-08, 0.2252D-08, 0.1053D-08,
     ,   0.4916D-09, 0.2291D-09, 0.1066D-09/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.7167D-11, 0.1212D-10, 0.2046D-10, 0.3451D-10, 0.5812D-10,
     ,   0.9772D-10, 0.1640D-09, 0.2749D-09, 0.4598D-09, 0.7676D-09,
     ,   0.1279D-08, 0.2126D-08, 0.3525D-08, 0.5830D-08, 0.9616D-08,
     ,   0.1581D-07, 0.2591D-07, 0.4231D-07, 0.6881D-07, 0.1114D-06,
     ,   0.1793D-06, 0.2870D-06, 0.4561D-06, 0.7188D-06, 0.1121D-05,
     ,   0.1727D-05, 0.2617D-05, 0.3886D-05, 0.5618D-05, 0.7840D-05,
     ,   0.1044D-04, 0.1306D-04, 0.1500D-04, 0.1538D-04, 0.1343D-04,
     ,   0.9146D-05, 0.3511D-05,-0.1899D-05,-0.5857D-05,-0.8030D-05,
     ,  -0.8793D-05,-0.8714D-05,-0.8208D-05,-0.7483D-05,-0.6615D-05,
     ,  -0.5624D-05,-0.4522D-05,-0.3322D-05,-0.2042D-05,-0.6885D-06,
     ,   0.7877D-06, 0.2504D-05, 0.4489D-05, 0.6409D-05, 0.7596D-05,
     ,   0.7544D-05, 0.6369D-05, 0.4670D-05, 0.3050D-05, 0.1819D-05,
     ,   0.1012D-05, 0.5348D-06, 0.2722D-06, 0.1349D-06, 0.6557D-07,
     ,   0.3144D-07, 0.1493D-07, 0.7041D-08, 0.3305D-08, 0.1546D-08,
     ,   0.7216D-09, 0.3362D-09, 0.1565D-09/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1048D-10, 0.1773D-10, 0.2994D-10, 0.5049D-10, 0.8502D-10,
     ,   0.1430D-09, 0.2400D-09, 0.4021D-09, 0.6726D-09, 0.1123D-08,
     ,   0.1871D-08, 0.3110D-08, 0.5157D-08, 0.8530D-08, 0.1407D-07,
     ,   0.2313D-07, 0.3791D-07, 0.6191D-07, 0.1007D-06, 0.1630D-06,
     ,   0.2624D-06, 0.4200D-06, 0.6674D-06, 0.1052D-05, 0.1641D-05,
     ,   0.2527D-05, 0.3830D-05, 0.5687D-05, 0.8222D-05, 0.1148D-04,
     ,   0.1528D-04, 0.1912D-04, 0.2198D-04, 0.2254D-04, 0.1969D-04,
     ,   0.1342D-04, 0.5167D-05,-0.2763D-05,-0.8568D-05,-0.1176D-04,
     ,  -0.1288D-04,-0.1277D-04,-0.1203D-04,-0.1097D-04,-0.9694D-05,
     ,  -0.8243D-05,-0.6629D-05,-0.4871D-05,-0.2997D-05,-0.1014D-05,
     ,   0.1147D-05, 0.3660D-05, 0.6567D-05, 0.9382D-05, 0.1112D-04,
     ,   0.1105D-04, 0.9335D-05, 0.6848D-05, 0.4474D-05, 0.2668D-05,
     ,   0.1485D-05, 0.7847D-06, 0.3995D-06, 0.1980D-06, 0.9623D-07,
     ,   0.4614D-07, 0.2191D-07, 0.1033D-07, 0.4851D-08, 0.2269D-08,
     ,   0.1059D-08, 0.4935D-09, 0.2297D-09/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1531D-10, 0.2589D-10, 0.4373D-10, 0.7375D-10, 0.1242D-09,
     ,   0.2088D-09, 0.3505D-09, 0.5874D-09, 0.9825D-09, 0.1640D-08,
     ,   0.2733D-08, 0.4543D-08, 0.7533D-08, 0.1246D-07, 0.2055D-07,
     ,   0.3379D-07, 0.5539D-07, 0.9044D-07, 0.1471D-06, 0.2381D-06,
     ,   0.3834D-06, 0.6136D-06, 0.9751D-06, 0.1537D-05, 0.2397D-05,
     ,   0.3692D-05, 0.5597D-05, 0.8311D-05, 0.1202D-04, 0.1678D-04,
     ,   0.2235D-04, 0.2796D-04, 0.3216D-04, 0.3299D-04, 0.2886D-04,
     ,   0.1969D-04, 0.7614D-05,-0.4002D-05,-0.1251D-04,-0.1720D-04,
     ,  -0.1885D-04,-0.1869D-04,-0.1761D-04,-0.1606D-04,-0.1419D-04,
     ,  -0.1207D-04,-0.9711D-05,-0.7140D-05,-0.4398D-05,-0.1497D-05,
     ,   0.1665D-05, 0.5340D-05, 0.9592D-05, 0.1372D-04, 0.1627D-04,
     ,   0.1618D-04, 0.1368D-04, 0.1004D-04, 0.6560D-05, 0.3913D-05,
     ,   0.2178D-05, 0.1151D-05, 0.5863D-06, 0.2905D-06, 0.1412D-06,
     ,   0.6772D-07, 0.3216D-07, 0.1517D-07, 0.7120D-08, 0.3331D-08,
     ,   0.1555D-08, 0.7244D-09, 0.3371D-09/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.2232D-10, 0.3774D-10, 0.6373D-10, 0.1075D-09, 0.1810D-09,
     ,   0.3043D-09, 0.5108D-09, 0.8561D-09, 0.1432D-08, 0.2391D-08,
     ,   0.3983D-08, 0.6621D-08, 0.1098D-07, 0.1816D-07, 0.2995D-07,
     ,   0.4926D-07, 0.8073D-07, 0.1318D-06, 0.2144D-06, 0.3470D-06,
     ,   0.5588D-06, 0.8945D-06, 0.1422D-05, 0.2241D-05, 0.3495D-05,
     ,   0.5384D-05, 0.8162D-05, 0.1212D-04, 0.1753D-04, 0.2448D-04,
     ,   0.3262D-04, 0.4084D-04, 0.4699D-04, 0.4825D-04, 0.4225D-04,
     ,   0.2888D-04, 0.1124D-04,-0.5761D-05,-0.1824D-04,-0.2511D-04,
     ,  -0.2755D-04,-0.2732D-04,-0.2575D-04,-0.2348D-04,-0.2076D-04,
     ,  -0.1766D-04,-0.1422D-04,-0.1046D-04,-0.6453D-05,-0.2215D-05,
     ,   0.2403D-05, 0.7769D-05, 0.1398D-04, 0.2001D-04, 0.2377D-04,
     ,   0.2366D-04, 0.2002D-04, 0.1470D-04, 0.9613D-05, 0.5738D-05,
     ,   0.3194D-05, 0.1689D-05, 0.8602D-06, 0.4263D-06, 0.2073D-06,
     ,   0.9939D-07, 0.4720D-07, 0.2226D-07, 0.1045D-07, 0.4889D-08,
     ,   0.2282D-08, 0.1063D-08, 0.4948D-09/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.3241D-10, 0.5481D-10, 0.9256D-10, 0.1561D-09, 0.2629D-09,
     ,   0.4420D-09, 0.7420D-09, 0.1243D-08, 0.2080D-08, 0.3473D-08,
     ,   0.5786D-08, 0.9618D-08, 0.1595D-07, 0.2638D-07, 0.4352D-07,
     ,   0.7156D-07, 0.1173D-06, 0.1915D-06, 0.3115D-06, 0.5043D-06,
     ,   0.8121D-06, 0.1300D-05, 0.2066D-05, 0.3257D-05, 0.5081D-05,
     ,   0.7827D-05, 0.1187D-04, 0.1763D-04, 0.2551D-04, 0.3563D-04,
     ,   0.4750D-04, 0.5949D-04, 0.6852D-04, 0.7043D-04, 0.6177D-04,
     ,   0.4235D-04, 0.1663D-04,-0.8213D-05,-0.2648D-04,-0.3658D-04,
     ,  -0.4017D-04,-0.3987D-04,-0.3758D-04,-0.3428D-04,-0.3032D-04,
     ,  -0.2581D-04,-0.2078D-04,-0.1531D-04,-0.9466D-05,-0.3288D-05,
     ,   0.3441D-05, 0.1126D-04, 0.2031D-04, 0.2912D-04, 0.3465D-04,
     ,   0.3454D-04, 0.2925D-04, 0.2151D-04, 0.1408D-04, 0.8408D-05,
     ,   0.4683D-05, 0.2477D-05, 0.1262D-05, 0.6255D-06, 0.3041D-06,
     ,   0.1459D-06, 0.6927D-07, 0.3267D-07, 0.1534D-07, 0.7176D-08,
     ,   0.3349D-08, 0.1561D-08, 0.7263D-09/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.4685D-10, 0.7923D-10, 0.1338D-09, 0.2256D-09, 0.3800D-09,
     ,   0.6390D-09, 0.1073D-08, 0.1798D-08, 0.3007D-08, 0.5021D-08,
     ,   0.8365D-08, 0.1391D-07, 0.2306D-07, 0.3815D-07, 0.6293D-07,
     ,   0.1035D-06, 0.1696D-06, 0.2770D-06, 0.4505D-06, 0.7294D-06,
     ,   0.1175D-05, 0.1880D-05, 0.2989D-05, 0.4712D-05, 0.7353D-05,
     ,   0.1133D-04, 0.1718D-04, 0.2553D-04, 0.3695D-04, 0.5164D-04,
     ,   0.6890D-04, 0.8638D-04, 0.9960D-04, 0.1026D-03, 0.9016D-04,
     ,   0.6206D-04, 0.2468D-04,-0.1154D-04,-0.3827D-04,-0.5309D-04,
     ,  -0.5841D-04,-0.5801D-04,-0.5471D-04,-0.4993D-04,-0.4419D-04,
     ,  -0.3763D-04,-0.3033D-04,-0.2237D-04,-0.1388D-04,-0.4904D-05,
     ,   0.4868D-05, 0.1621D-04, 0.2936D-04, 0.4221D-04, 0.5033D-04,
     ,   0.5029D-04, 0.4267D-04, 0.3143D-04, 0.2059D-04, 0.1231D-04,
     ,   0.6863D-05, 0.3632D-05, 0.1851D-05, 0.9177D-06, 0.4463D-06,
     ,   0.2140D-06, 0.1017D-06, 0.4795D-07, 0.2251D-07, 0.1053D-07,
     ,   0.4916D-08, 0.2290D-08, 0.1066D-08/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.6724D-10, 0.1137D-09, 0.1920D-09, 0.3239D-09, 0.5455D-09,
     ,   0.9172D-09, 0.1540D-08, 0.2581D-08, 0.4317D-08, 0.7208D-08,
     ,   0.1201D-07, 0.1997D-07, 0.3311D-07, 0.5478D-07, 0.9037D-07,
     ,   0.1486D-06, 0.2436D-06, 0.3979D-06, 0.6472D-06, 0.1048D-05,
     ,   0.1688D-05, 0.2702D-05, 0.4296D-05, 0.6773D-05, 0.1057D-04,
     ,   0.1629D-04, 0.2472D-04, 0.3675D-04, 0.5322D-04, 0.7443D-04,
     ,   0.9940D-04, 0.1248D-03, 0.1441D-03, 0.1488D-03, 0.1312D-03,
     ,   0.9087D-04, 0.3681D-04,-0.1585D-04,-0.5489D-04,-0.7666D-04,
     ,  -0.8457D-04,-0.8409D-04,-0.7936D-04,-0.7246D-04,-0.6416D-04,
     ,  -0.5469D-04,-0.4413D-04,-0.3263D-04,-0.2035D-04,-0.7359D-05,
     ,   0.6762D-05, 0.2313D-04, 0.4215D-04, 0.6082D-04, 0.7277D-04,
     ,   0.7293D-04, 0.6207D-04, 0.4582D-04, 0.3008D-04, 0.1801D-04,
     ,   0.1005D-04, 0.5322D-05, 0.2713D-05, 0.1346D-05, 0.6546D-06,
     ,   0.3140D-06, 0.1492D-06, 0.7037D-07, 0.3304D-07, 0.1546D-07,
     ,   0.7215D-08, 0.3362D-08, 0.1565D-08/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.9554D-10, 0.1616D-09, 0.2729D-09, 0.4602D-09, 0.7751D-09,
     ,   0.1303D-08, 0.2188D-08, 0.3668D-08, 0.6136D-08, 0.1025D-07,
     ,   0.1707D-07, 0.2838D-07, 0.4708D-07, 0.7788D-07, 0.1285D-06,
     ,   0.2113D-06, 0.3465D-06, 0.5659D-06, 0.9206D-06, 0.1491D-05,
     ,   0.2402D-05, 0.3846D-05, 0.6116D-05, 0.9645D-05, 0.1506D-04,
     ,   0.2322D-04, 0.3524D-04, 0.5243D-04, 0.7598D-04, 0.1064D-03,
     ,   0.1423D-03, 0.1789D-03, 0.2072D-03, 0.2147D-03, 0.1903D-03,
     ,   0.1329D-03, 0.5521D-04,-0.2101D-04,-0.7790D-04,-0.1099D-03,
     ,  -0.1217D-03,-0.1212D-03,-0.1145D-03,-0.1046D-03,-0.9272D-04,
     ,  -0.7912D-04,-0.6397D-04,-0.4744D-04,-0.2979D-04,-0.1113D-04,
     ,   0.9134D-05, 0.3259D-04, 0.5988D-04, 0.8688D-04, 0.1045D-03,
     ,   0.1052D-03, 0.8989D-04, 0.6659D-04, 0.4384D-04, 0.2630D-04,
     ,   0.1470D-04, 0.7792D-05, 0.3976D-05, 0.1973D-05, 0.9601D-06,
     ,   0.4607D-06, 0.2189D-06, 0.1033D-06, 0.4848D-07, 0.2269D-07,
     ,   0.1059D-07, 0.4934D-08, 0.2297D-08/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1338D-09, 0.2262D-09, 0.3821D-09, 0.6445D-09, 0.1086D-08,
     ,   0.1826D-08, 0.3065D-08, 0.5138D-08, 0.8596D-08, 0.1435D-07,
     ,   0.2392D-07, 0.3977D-07, 0.6598D-07, 0.1092D-06, 0.1801D-06,
     ,   0.2963D-06, 0.4858D-06, 0.7937D-06, 0.1291D-05, 0.2092D-05,
     ,   0.3370D-05, 0.5398D-05, 0.8587D-05, 0.1355D-04, 0.2116D-04,
     ,   0.3264D-04, 0.4959D-04, 0.7384D-04, 0.1071D-03, 0.1502D-03,
     ,   0.2013D-03, 0.2539D-03, 0.2952D-03, 0.3073D-03, 0.2744D-03,
     ,   0.1939D-03, 0.8339D-04,-0.2618D-04,-0.1088D-03,-0.1557D-03,
     ,  -0.1734D-03,-0.1732D-03,-0.1639D-03,-0.1499D-03,-0.1330D-03,
     ,  -0.1137D-03,-0.9219D-04,-0.6868D-04,-0.4355D-04,-0.1699D-04,
     ,   0.1180D-04, 0.4505D-04, 0.8383D-04, 0.1226D-03, 0.1485D-03,
     ,   0.1505D-03, 0.1294D-03, 0.9633D-04, 0.6367D-04, 0.3831D-04,
     ,   0.2146D-04, 0.1139D-04, 0.5820D-05, 0.2891D-05, 0.1408D-05,
     ,   0.6756D-06, 0.3211D-06, 0.1515D-06, 0.7115D-07, 0.3329D-07,
     ,   0.1554D-07, 0.7242D-08, 0.3371D-08/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.1835D-09, 0.3103D-09, 0.5242D-09, 0.8842D-09, 0.1489D-08,
     ,   0.2505D-08, 0.4206D-08, 0.7051D-08, 0.1180D-07, 0.1970D-07,
     ,   0.3284D-07, 0.5461D-07, 0.9061D-07, 0.1499D-06, 0.2474D-06,
     ,   0.4071D-06, 0.6677D-06, 0.1091D-05, 0.1776D-05, 0.2877D-05,
     ,   0.4637D-05, 0.7430D-05, 0.1182D-04, 0.1867D-04, 0.2917D-04,
     ,   0.4504D-04, 0.6849D-04, 0.1021D-03, 0.1484D-03, 0.2086D-03,
     ,   0.2804D-03, 0.3550D-03, 0.4148D-03, 0.4349D-03, 0.3922D-03,
     ,   0.2817D-03, 0.1269D-03,-0.2909D-04,-0.1484D-03,-0.2173D-03,
     ,  -0.2440D-03,-0.2447D-03,-0.2320D-03,-0.2126D-03,-0.1890D-03,
     ,  -0.1620D-03,-0.1318D-03,-0.9879D-04,-0.6349D-04,-0.2617D-04,
     ,   0.1415D-04, 0.6056D-04, 0.1149D-03, 0.1699D-03, 0.2080D-03,
     ,   0.2129D-03, 0.1846D-03, 0.1384D-03, 0.9202D-04, 0.5561D-04,
     ,   0.3125D-04, 0.1663D-04, 0.8511D-05, 0.4232D-05, 0.2062D-05,
     ,   0.9905D-06, 0.4709D-06, 0.2223D-06, 0.1044D-06, 0.4885D-07,
     ,   0.2281D-07, 0.1063D-07, 0.4947D-08/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.2445D-09, 0.4135D-09, 0.6986D-09, 0.1179D-08, 0.1985D-08,
     ,   0.3340D-08, 0.5609D-08, 0.9404D-08, 0.1574D-07, 0.2629D-07,
     ,   0.4382D-07, 0.7289D-07, 0.1210D-06, 0.2002D-06, 0.3305D-06,
     ,   0.5439D-06, 0.8922D-06, 0.1458D-05, 0.2374D-05, 0.3848D-05,
     ,   0.6206D-05, 0.9950D-05, 0.1585D-04, 0.2503D-04, 0.3916D-04,
     ,   0.6053D-04, 0.9216D-04, 0.1377D-03, 0.2006D-03, 0.2827D-03,
     ,   0.3816D-03, 0.4858D-03, 0.5718D-03, 0.6054D-03, 0.5537D-03,
     ,   0.4068D-03, 0.1944D-03,-0.2449D-04,-0.1953D-03,-0.2962D-03,
     ,  -0.3370D-03,-0.3400D-03,-0.3233D-03,-0.2969D-03,-0.2647D-03,
     ,  -0.2276D-03,-0.1861D-03,-0.1407D-03,-0.9208D-04,-0.4064D-04,
     ,   0.1475D-04, 0.7816D-04, 0.1526D-03, 0.2296D-03, 0.2852D-03,
     ,   0.2960D-03, 0.2599D-03, 0.1970D-03, 0.1321D-03, 0.8032D-04,
     ,   0.4535D-04, 0.2422D-04, 0.1242D-04, 0.6189D-05, 0.3019D-05,
     ,   0.1451D-05, 0.6903D-06, 0.3260D-06, 0.1531D-06, 0.7168D-07,
     ,   0.3347D-07, 0.1560D-07, 0.7260D-08/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.3131D-09, 0.5297D-09, 0.8950D-09, 0.1510D-08, 0.2544D-08,
     ,   0.4281D-08, 0.7191D-08, 0.1206D-07, 0.2019D-07, 0.3373D-07,
     ,   0.5623D-07, 0.9356D-07, 0.1553D-06, 0.2571D-06, 0.4246D-06,
     ,   0.6991D-06, 0.1147D-05, 0.1876D-05, 0.3056D-05, 0.4956D-05,
     ,   0.7998D-05, 0.1283D-04, 0.2045D-04, 0.3234D-04, 0.5066D-04,
     ,   0.7843D-04, 0.1197D-03, 0.1792D-03, 0.2619D-03, 0.3708D-03,
     ,   0.5032D-03, 0.6454D-03, 0.7673D-03, 0.8235D-03, 0.7675D-03,
     ,   0.5811D-03, 0.2986D-03,-0.2094D-05,-0.2436D-03,-0.3907D-03,
     ,  -0.4534D-03,-0.4614D-03,-0.4408D-03,-0.4062D-03,-0.3634D-03,
     ,  -0.3139D-03,-0.2585D-03,-0.1977D-03,-0.1324D-03,-0.6326D-04,
     ,   0.1081D-04, 0.9498D-04, 0.1941D-03, 0.2992D-03, 0.3796D-03,
     ,   0.4019D-03, 0.3593D-03, 0.2764D-03, 0.1876D-03, 0.1152D-03,
     ,   0.6547D-04, 0.3514D-04, 0.1809D-04, 0.9034D-05, 0.4415D-05,
     ,   0.2125D-05, 0.1011D-05, 0.4779D-06, 0.2246D-06, 0.1051D-06,
     ,   0.4910D-07, 0.2289D-07, 0.1065D-07/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.3803D-09, 0.6436D-09, 0.1088D-08, 0.1836D-08, 0.3094D-08,
     ,   0.5207D-08, 0.8749D-08, 0.1468D-07, 0.2457D-07, 0.4107D-07,
     ,   0.6850D-07, 0.1140D-06, 0.1893D-06, 0.3136D-06, 0.5182D-06,
     ,   0.8535D-06, 0.1402D-05, 0.2293D-05, 0.3738D-05, 0.6068D-05,
     ,   0.9800D-05, 0.1574D-04, 0.2512D-04, 0.3977D-04, 0.6241D-04,
     ,   0.9682D-04, 0.1481D-03, 0.2225D-03, 0.3266D-03, 0.4650D-03,
     ,   0.6358D-03, 0.8237D-03, 0.9923D-03, 0.1084D-02, 0.1036D-02,
     ,   0.8152D-03, 0.4561D-03, 0.5580D-04,-0.2789D-03,-0.4915D-03,
     ,  -0.5882D-03,-0.6068D-03,-0.5837D-03,-0.5403D-03,-0.4856D-03,
     ,  -0.4222D-03,-0.3509D-03,-0.2723D-03,-0.1876D-03,-0.9782D-04,
     ,  -0.2151D-05, 0.1054D-03, 0.2322D-03, 0.3706D-03, 0.4843D-03,
     ,   0.5273D-03, 0.4834D-03, 0.3800D-03, 0.2624D-03, 0.1633D-03,
     ,   0.9379D-04, 0.5071D-04, 0.2624D-04, 0.1315D-04, 0.6444D-05,
     ,   0.3107D-05, 0.1481D-05, 0.7002D-06, 0.3292D-06, 0.1542D-06,
     ,   0.7203D-07, 0.3358D-07, 0.1564D-07/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.4318D-09, 0.7309D-09, 0.1236D-08, 0.2086D-08, 0.3517D-08,
     ,   0.5920D-08, 0.9951D-08, 0.1670D-07, 0.2797D-07, 0.4678D-07,
     ,   0.7806D-07, 0.1300D-06, 0.2160D-06, 0.3580D-06, 0.5918D-06,
     ,   0.9755D-06, 0.1603D-05, 0.2625D-05, 0.4283D-05, 0.6959D-05,
     ,   0.1125D-04, 0.1810D-04, 0.2893D-04, 0.4589D-04, 0.7216D-04,
     ,   0.1123D-03, 0.1723D-03, 0.2600D-03, 0.3837D-03, 0.5503D-03,
     ,   0.7597D-03, 0.9968D-03, 0.1222D-02, 0.1365D-02, 0.1347D-02,
     ,   0.1111D-02, 0.6836D-03, 0.1746D-03,-0.2752D-03,-0.5774D-03,
     ,  -0.7259D-03,-0.7649D-03,-0.7435D-03,-0.6927D-03,-0.6265D-03,
     ,  -0.5490D-03,-0.4614D-03,-0.3646D-03,-0.2597D-03,-0.1482D-03,
     ,  -0.2996D-04, 0.1010D-03, 0.2549D-03, 0.4283D-03, 0.5830D-03,
     ,   0.6595D-03, 0.6264D-03, 0.5077D-03, 0.3594D-03, 0.2280D-03,
     ,   0.1329D-03, 0.7261D-04, 0.3786D-04, 0.1908D-04, 0.9381D-05,
     ,   0.4534D-05, 0.2165D-05, 0.1025D-05, 0.4824D-06, 0.2261D-06,
     ,   0.1056D-06, 0.4926D-07, 0.2294D-07/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.4511D-09, 0.7639D-09, 0.1292D-08, 0.2182D-08, 0.3680D-08,
     ,   0.6199D-08, 0.1042D-07, 0.1750D-07, 0.2933D-07, 0.4908D-07,
     ,   0.8195D-07, 0.1366D-06, 0.2271D-06, 0.3766D-06, 0.6231D-06,
     ,   0.1028D-05, 0.1691D-05, 0.2773D-05, 0.4529D-05, 0.7369D-05,
     ,   0.1193D-04, 0.1922D-04, 0.3079D-04, 0.4896D-04, 0.7720D-04,
     ,   0.1205D-03, 0.1857D-03, 0.2817D-03, 0.4187D-03, 0.6059D-03,
     ,   0.8463D-03, 0.1128D-02, 0.1411D-02, 0.1622D-02, 0.1662D-02,
     ,   0.1451D-02, 0.9872D-03, 0.3814D-03,-0.1956D-03,-0.6125D-03,
     ,  -0.8370D-03,-0.9127D-03,-0.9014D-03,-0.8476D-03,-0.7727D-03,
     ,  -0.6837D-03,-0.5826D-03,-0.4700D-03,-0.3473D-03,-0.2163D-03,
     ,  -0.7781D-04, 0.7299D-04, 0.2481D-03, 0.4511D-03, 0.6490D-03,
     ,   0.7730D-03, 0.7702D-03, 0.6511D-03, 0.4774D-03, 0.3113D-03,
     ,   0.1852D-03, 0.1028D-03, 0.5418D-04, 0.2751D-04, 0.1360D-04,
     ,   0.6601D-05, 0.3160D-05, 0.1499D-05, 0.7062D-06, 0.3312D-06,
     ,   0.1549D-06, 0.7225D-07, 0.3365D-07/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.4282D-09, 0.7254D-09, 0.1227D-08, 0.2074D-08, 0.3500D-08,
     ,   0.5899D-08, 0.9926D-08, 0.1668D-07, 0.2797D-07, 0.4683D-07,
     ,   0.7826D-07, 0.1305D-06, 0.2172D-06, 0.3606D-06, 0.5973D-06,
     ,   0.9866D-06, 0.1625D-05, 0.2667D-05, 0.4364D-05, 0.7111D-05,
     ,   0.1154D-04, 0.1863D-04, 0.2990D-04, 0.4768D-04, 0.7544D-04,
     ,   0.1182D-03, 0.1831D-03, 0.2796D-03, 0.4188D-03, 0.6124D-03,
     ,   0.8672D-03, 0.1177D-02, 0.1508D-02, 0.1791D-02, 0.1918D-02,
     ,   0.1782D-02, 0.1344D-02, 0.6876D-03,-0.3572D-05,-0.5516D-03,
     ,  -0.8796D-03,-0.1015D-02,-0.1029D-02,-0.9805D-03,-0.9028D-03,
     ,  -0.8080D-03,-0.6992D-03,-0.5772D-03,-0.4433D-03,-0.2992D-03,
     ,  -0.1467D-03, 0.1665D-04, 0.2019D-03, 0.4202D-03, 0.6522D-03,
     ,   0.8310D-03, 0.8823D-03, 0.7896D-03, 0.6075D-03, 0.4118D-03,
     ,   0.2523D-03, 0.1431D-03, 0.7666D-04, 0.3937D-04, 0.1962D-04,
     ,   0.9572D-05, 0.4600D-05, 0.2187D-05, 0.1033D-05, 0.4849D-06,
     ,   0.2269D-06, 0.1059D-06, 0.4935D-07/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.3663D-09, 0.6209D-09, 0.1051D-08, 0.1777D-08, 0.3002D-08,
     ,   0.5062D-08, 0.8524D-08, 0.1433D-07, 0.2406D-07, 0.4032D-07,
     ,   0.6744D-07, 0.1126D-06, 0.1876D-06, 0.3118D-06, 0.5170D-06,
     ,   0.8551D-06, 0.1410D-05, 0.2319D-05, 0.3800D-05, 0.6205D-05,
     ,   0.1009D-04, 0.1633D-04, 0.2628D-04, 0.4205D-04, 0.6678D-04,
     ,   0.1052D-03, 0.1638D-03, 0.2518D-03, 0.3806D-03, 0.5630D-03,
     ,   0.8092D-03, 0.1120D-02, 0.1474D-02, 0.1814D-02, 0.2037D-02,
     ,   0.2023D-02, 0.1688D-02, 0.1064D-02, 0.3126D-03,-0.3566D-03,
     ,  -0.8087D-03,-0.1032D-02,-0.1092D-02,-0.1063D-02,-0.9916D-03,
     ,  -0.8989D-03,-0.7909D-03,-0.6687D-03,-0.5333D-03,-0.3863D-03,
     ,  -0.2297D-03,-0.6373D-04, 0.1189D-03, 0.3327D-03, 0.5759D-03,
     ,   0.7997D-03, 0.9207D-03, 0.8879D-03, 0.7287D-03, 0.5209D-03,
     ,   0.3327D-03, 0.1947D-03, 0.1067D-03, 0.5568D-04, 0.2807D-04,
     ,   0.1380D-04, 0.6671D-05, 0.3184D-05, 0.1507D-05, 0.7090D-06,
     ,   0.3322D-06, 0.1552D-06, 0.7235D-07/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.2821D-09, 0.4784D-09, 0.8106D-09, 0.1372D-08, 0.2318D-08,
     ,   0.3913D-08, 0.6594D-08, 0.1110D-07, 0.1865D-07, 0.3128D-07,
     ,   0.5238D-07, 0.8754D-07, 0.1460D-06, 0.2430D-06, 0.4036D-06,
     ,   0.6685D-06, 0.1104D-05, 0.1819D-05, 0.2987D-05, 0.4888D-05,
     ,   0.7968D-05, 0.1293D-04, 0.2088D-04, 0.3352D-04, 0.5347D-04,
     ,   0.8460D-04, 0.1326D-03, 0.2053D-03, 0.3133D-03, 0.4690D-03,
     ,   0.6847D-03, 0.9673D-03, 0.1308D-02, 0.1668D-02, 0.1968D-02,
     ,   0.2089D-02, 0.1919D-02, 0.1426D-02, 0.7112D-03,-0.2495D-04,
     ,  -0.5967D-03,-0.9309D-03,-0.1064D-02,-0.1072D-02,-0.1019D-02,
     ,  -0.9369D-03,-0.8384D-03,-0.7258D-03,-0.5997D-03,-0.4611D-03,
     ,  -0.3120D-03,-0.1541D-03, 0.1510D-04, 0.2071D-03, 0.4328D-03,
     ,   0.6716D-03, 0.8542D-03, 0.9048D-03, 0.8078D-03, 0.6198D-03,
     ,   0.4190D-03, 0.2561D-03, 0.1449D-03, 0.7743D-04, 0.3969D-04,
     ,   0.1975D-04, 0.9619D-05, 0.4617D-05, 0.2194D-05, 0.1035D-05,
     ,   0.4857D-06, 0.2272D-06, 0.1060D-06/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.1968D-09, 0.3341D-09, 0.5664D-09, 0.9592D-09, 0.1623D-08,
     ,   0.2741D-08, 0.4624D-08, 0.7790D-08, 0.1310D-07, 0.2200D-07,
     ,   0.3689D-07, 0.6174D-07, 0.1031D-06, 0.1719D-06, 0.2859D-06,
     ,   0.4743D-06, 0.7851D-06, 0.1296D-05, 0.2132D-05, 0.3497D-05,
     ,   0.5715D-05, 0.9302D-05, 0.1507D-04, 0.2429D-04, 0.3891D-04,
     ,   0.6188D-04, 0.9758D-04, 0.1523D-03, 0.2345D-03, 0.3552D-03,
     ,   0.5265D-03, 0.7587D-03, 0.1053D-02, 0.1391D-02, 0.1719D-02,
     ,   0.1945D-02, 0.1953D-02, 0.1661D-02, 0.1091D-02, 0.3866D-03,
     ,  -0.2563D-03,-0.7017D-03,-0.9290D-03,-0.9966D-03,-0.9756D-03,
     ,  -0.9135D-03,-0.8315D-03,-0.7359D-03,-0.6277D-03,-0.5073D-03,
     ,  -0.3760D-03,-0.2357D-03,-0.8702D-04, 0.7506D-04, 0.2630D-03,
     ,   0.4793D-03, 0.6877D-03, 0.8154D-03, 0.8083D-03, 0.6798D-03,
     ,   0.4957D-03, 0.3216D-03, 0.1903D-03, 0.1051D-03, 0.5517D-04,
     ,   0.2791D-04, 0.1376D-04, 0.6658D-05, 0.3181D-05, 0.1506D-05,
     ,   0.7088D-06, 0.3322D-06, 0.1552D-06/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.1259D-09, 0.2138D-09, 0.3629D-09, 0.6151D-09, 0.1041D-08,
     ,   0.1761D-08, 0.2974D-08, 0.5015D-08, 0.8446D-08, 0.1420D-07,
     ,   0.2384D-07, 0.3995D-07, 0.6682D-07, 0.1116D-06, 0.1858D-06,
     ,   0.3089D-06, 0.5123D-06, 0.8472D-06, 0.1397D-05, 0.2297D-05,
     ,   0.3765D-05, 0.6146D-05, 0.9991D-05, 0.1616D-04, 0.2601D-04,
     ,   0.4157D-04, 0.6595D-04, 0.1037D-03, 0.1611D-03, 0.2467D-03,
     ,   0.3709D-03, 0.5444D-03, 0.7741D-03, 0.1056D-02, 0.1362D-02,
     ,   0.1632D-02, 0.1773D-02, 0.1688D-02, 0.1334D-02, 0.7688D-03,
     ,   0.1464D-03,-0.3699D-03,-0.6948D-03,-0.8404D-03,-0.8676D-03,
     ,  -0.8341D-03,-0.7734D-03,-0.6985D-03,-0.6124D-03,-0.5155D-03,
     ,  -0.4083D-03,-0.2921D-03,-0.1684D-03,-0.3677D-04, 0.1093D-03,
     ,   0.2801D-03, 0.4697D-03, 0.6350D-03, 0.7126D-03, 0.6711D-03,
     ,   0.5394D-03, 0.3788D-03, 0.2384D-03, 0.1379D-03, 0.7485D-04,
     ,   0.3879D-04, 0.1945D-04, 0.9522D-05, 0.4587D-05, 0.2184D-05,
     ,   0.1032D-05, 0.4848D-06, 0.2269D-06/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.7492D-10, 0.1274D-09, 0.2164D-09, 0.3671D-09, 0.6221D-09,
     ,   0.1053D-08, 0.1780D-08, 0.3005D-08, 0.5067D-08, 0.8530D-08,
     ,   0.1434D-07, 0.2406D-07, 0.4031D-07, 0.6740D-07, 0.1125D-06,
     ,   0.1873D-06, 0.3112D-06, 0.5158D-06, 0.8527D-06, 0.1406D-05,
     ,   0.2309D-05, 0.3782D-05, 0.6168D-05, 0.1002D-04, 0.1618D-04,
     ,   0.2600D-04, 0.4148D-04, 0.6565D-04, 0.1029D-03, 0.1591D-03,
     ,   0.2423D-03, 0.3615D-03, 0.5251D-03, 0.7363D-03, 0.9857D-03,
     ,   0.1242D-02, 0.1443D-02, 0.1509D-02, 0.1369D-02, 0.1009D-02,
     ,   0.5071D-03,-0.6359D-06,-0.3912D-03,-0.6182D-03,-0.7075D-03,
     ,  -0.7129D-03,-0.6775D-03,-0.6240D-03,-0.5601D-03,-0.4872D-03,
     ,  -0.4056D-03,-0.3156D-03,-0.2185D-03,-0.1153D-03,-0.4857D-05,
     ,   0.1194D-03, 0.2645D-03, 0.4189D-03, 0.5412D-03, 0.5821D-03,
     ,   0.5274D-03, 0.4100D-03, 0.2801D-03, 0.1725D-03, 0.9813D-04,
     ,   0.5261D-04, 0.2702D-04, 0.1346D-04, 0.6560D-05, 0.3149D-05,
     ,   0.1496D-05, 0.7057D-06, 0.3312D-06/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.4212D-10, 0.7168D-10, 0.1219D-09, 0.2069D-09, 0.3510D-09,
     ,   0.5948D-09, 0.1007D-08, 0.1702D-08, 0.2872D-08, 0.4842D-08,
     ,   0.8149D-08, 0.1369D-07, 0.2298D-07, 0.3848D-07, 0.6433D-07,
     ,   0.1073D-06, 0.1787D-06, 0.2968D-06, 0.4917D-06, 0.8125D-06,
     ,   0.1339D-05, 0.2198D-05, 0.3597D-05, 0.5863D-05, 0.9511D-05,
     ,   0.1535D-04, 0.2462D-04, 0.3921D-04, 0.6190D-04, 0.9664D-04,
     ,   0.1488D-03, 0.2252D-03, 0.3330D-03, 0.4782D-03, 0.6604D-03,
     ,   0.8672D-03, 0.1066D-02, 0.1204D-02, 0.1216D-02, 0.1056D-02,
     ,   0.7312D-03, 0.3180D-03,-0.7320D-04,-0.3570D-03,-0.5112D-03,
     ,  -0.5646D-03,-0.5598D-03,-0.5280D-03,-0.4839D-03,-0.4323D-03,
     ,  -0.3737D-03,-0.3082D-03,-0.2363D-03,-0.1589D-03,-0.7669D-04,
     ,   0.1191D-04, 0.1125D-03, 0.2289D-03, 0.3479D-03, 0.4341D-03,
     ,   0.4522D-03, 0.3981D-03, 0.3019D-03, 0.2022D-03, 0.1226D-03,
     ,   0.6894D-04, 0.3664D-04, 0.1870D-04, 0.9270D-05, 0.4504D-05,
     ,   0.2157D-05, 0.1023D-05, 0.4820D-06/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.2268D-10, 0.3863D-10, 0.6572D-10, 0.1117D-09, 0.1897D-09,
     ,   0.3218D-09, 0.5451D-09, 0.9225D-09, 0.1559D-08, 0.2631D-08,
     ,   0.4435D-08, 0.7464D-08, 0.1254D-07, 0.2104D-07, 0.3523D-07,
     ,   0.5888D-07, 0.9821D-07, 0.1635D-06, 0.2714D-06, 0.4496D-06,
     ,   0.7426D-06, 0.1223D-05, 0.2008D-05, 0.3283D-05, 0.5347D-05,
     ,   0.8667D-05, 0.1397D-04, 0.2238D-04, 0.3556D-04, 0.5596D-04,
     ,   0.8701D-04, 0.1333D-03, 0.2001D-03, 0.2930D-03, 0.4152D-03,
     ,   0.5641D-03, 0.7259D-03, 0.8717D-03, 0.9578D-03, 0.9375D-03,
     ,   0.7837D-03, 0.5136D-03, 0.1921D-03,-0.9736D-04,-0.2980D-03,
     ,  -0.4012D-03,-0.4327D-03,-0.4245D-03,-0.3982D-03,-0.3637D-03,
     ,  -0.3238D-03,-0.2785D-03,-0.2280D-03,-0.1727D-03,-0.1132D-03,
     ,  -0.5010D-04, 0.1836D-04, 0.9644D-04, 0.1857D-03, 0.2738D-03,
     ,   0.3328D-03, 0.3385D-03, 0.2917D-03, 0.2174D-03, 0.1435D-03,
     ,   0.8608D-04, 0.4799D-04, 0.2535D-04, 0.1288D-04, 0.6365D-05,
     ,   0.3085D-05, 0.1475D-05, 0.6990D-06/
      data (calcpts(j,30), j = 1,neta) /
     ,   0.1183D-10, 0.2016D-10, 0.3433D-10, 0.5841D-10, 0.9927D-10,
     ,   0.1686D-09, 0.2859D-09, 0.4843D-09, 0.8195D-09, 0.1385D-08,
     ,   0.2337D-08, 0.3939D-08, 0.6628D-08, 0.1114D-07, 0.1868D-07,
     ,   0.3127D-07, 0.5226D-07, 0.8715D-07, 0.1450D-06, 0.2408D-06,
     ,   0.3987D-06, 0.6584D-06, 0.1084D-05, 0.1778D-05, 0.2907D-05,
     ,   0.4731D-05, 0.7660D-05, 0.1233D-04, 0.1971D-04, 0.3124D-04,
     ,   0.4899D-04, 0.7579D-04, 0.1153D-03, 0.1715D-03, 0.2482D-03,
     ,   0.3465D-03, 0.4623D-03, 0.5828D-03, 0.6841D-03, 0.7333D-03,
     ,   0.6986D-03, 0.5656D-03, 0.3534D-03, 0.1132D-03,-0.9518D-04,
     ,  -0.2346D-03,-0.3032D-03,-0.3217D-03,-0.3133D-03,-0.2928D-03,
     ,  -0.2668D-03,-0.2368D-03,-0.2029D-03,-0.1652D-03,-0.1239D-03,
     ,  -0.7957D-04,-0.3245D-04, 0.1886D-04, 0.7747D-04, 0.1437D-03,
     ,   0.2070D-03, 0.2468D-03, 0.2466D-03, 0.2094D-03, 0.1540D-03,
     ,   0.1007D-03, 0.5989D-04, 0.3319D-04, 0.1746D-04, 0.8841D-05,
     ,   0.4360D-05, 0.2110D-05, 0.1008D-05/
      data (calcpts(j,31), j = 1,neta) /
     ,   0.6024D-11, 0.1028D-10, 0.1752D-10, 0.2983D-10, 0.5075D-10,
     ,   0.8626D-10, 0.1465D-09, 0.2484D-09, 0.4208D-09, 0.7119D-09,
     ,   0.1203D-08, 0.2030D-08, 0.3421D-08, 0.5756D-08, 0.9670D-08,
     ,   0.1622D-07, 0.2715D-07, 0.4537D-07, 0.7565D-07, 0.1259D-06,
     ,   0.2089D-06, 0.3459D-06, 0.5710D-06, 0.9397D-06, 0.1541D-05,
     ,   0.2517D-05, 0.4093D-05, 0.6620D-05, 0.1064D-04, 0.1696D-04,
     ,   0.2679D-04, 0.4181D-04, 0.6427D-04, 0.9691D-04, 0.1426D-03,
     ,   0.2035D-03, 0.2794D-03, 0.3659D-03, 0.4519D-03, 0.5193D-03,
     ,   0.5447D-03, 0.5073D-03, 0.4001D-03, 0.2402D-03, 0.6567D-04,
     ,  -0.8150D-04,-0.1774D-03,-0.2229D-03,-0.2338D-03,-0.2265D-03,
     ,  -0.2112D-03,-0.1921D-03,-0.1701D-03,-0.1454D-03,-0.1178D-03,
     ,  -0.8765D-04,-0.5537D-04,-0.2098D-04, 0.1657D-04, 0.5943D-04,
     ,   0.1073D-03, 0.1521D-03, 0.1787D-03, 0.1763D-03, 0.1480D-03,
     ,   0.1079D-03, 0.6998D-04, 0.4141D-04, 0.2286D-04, 0.1198D-04,
     ,   0.6056D-05, 0.2981D-05, 0.1441D-05/
      data (calcpts(j,32), j = 1,neta) /
     ,   0.3018D-11, 0.5153D-11, 0.8791D-11, 0.1498D-10, 0.2552D-10,
     ,   0.4341D-10, 0.7377D-10, 0.1253D-09, 0.2124D-09, 0.3598D-09,
     ,   0.6088D-09, 0.1029D-08, 0.1736D-08, 0.2925D-08, 0.4921D-08,
     ,   0.8267D-08, 0.1386D-07, 0.2321D-07, 0.3877D-07, 0.6465D-07,
     ,   0.1076D-06, 0.1785D-06, 0.2954D-06, 0.4876D-06, 0.8021D-06,
     ,   0.1315D-05, 0.2145D-05, 0.3484D-05, 0.5626D-05, 0.9020D-05,
     ,   0.1434D-04, 0.2254D-04, 0.3496D-04, 0.5329D-04, 0.7950D-04,
     ,   0.1154D-03, 0.1621D-03, 0.2187D-03, 0.2810D-03, 0.3405D-03,
     ,   0.3839D-03, 0.3954D-03, 0.3614D-03, 0.2792D-03, 0.1621D-03,
     ,   0.3784D-04,-0.6479D-04,-0.1303D-03,-0.1606D-03,-0.1671D-03,
     ,  -0.1613D-03,-0.1501D-03,-0.1363D-03,-0.1206D-03,-0.1028D-03,
     ,  -0.8299D-04,-0.6140D-04,-0.3827D-04,-0.1361D-04, 0.1337D-04,
     ,   0.4412D-04, 0.7816D-04, 0.1094D-03, 0.1271D-03, 0.1242D-03,
     ,   0.1035D-03, 0.7494D-04, 0.4837D-04, 0.2851D-04, 0.1569D-04,
     ,   0.8208D-05, 0.4141D-05, 0.2037D-05/
      data (calcpts(j,33), j = 1,neta) /
     ,   0.1494D-11, 0.2553D-11, 0.4359D-11, 0.7436D-11, 0.1267D-10,
     ,   0.2158D-10, 0.3672D-10, 0.6240D-10, 0.1059D-09, 0.1797D-09,
     ,   0.3043D-09, 0.5149D-09, 0.8700D-09, 0.1468D-08, 0.2473D-08,
     ,   0.4161D-08, 0.6990D-08, 0.1172D-07, 0.1962D-07, 0.3278D-07,
     ,   0.5465D-07, 0.9090D-07, 0.1508D-06, 0.2496D-06, 0.4117D-06,
     ,   0.6769D-06, 0.1109D-05, 0.1807D-05, 0.2931D-05, 0.4721D-05,
     ,   0.7545D-05, 0.1194D-04, 0.1866D-04, 0.2871D-04, 0.4330D-04,
     ,   0.6376D-04, 0.9116D-04, 0.1259D-03, 0.1667D-03, 0.2104D-03,
     ,   0.2506D-03, 0.2780D-03, 0.2820D-03, 0.2540D-03, 0.1929D-03,
     ,   0.1091D-03, 0.2181D-04,-0.4915D-04,-0.9381D-04,-0.1140D-03,
     ,  -0.1179D-03,-0.1135D-03,-0.1055D-03,-0.9574D-04,-0.8456D-04,
     ,  -0.7196D-04,-0.5796D-04,-0.4269D-04,-0.2633D-04,-0.8879D-05,
     ,   0.1023D-04, 0.3198D-04, 0.5587D-04, 0.7746D-04, 0.8934D-04,
     ,   0.8672D-04, 0.7181D-04, 0.5176D-04, 0.3329D-04, 0.1956D-04,
     ,   0.1074D-04, 0.5613D-05, 0.2829D-05/
      data (calcpts(j,34), j = 1,neta) /
     ,   0.7334D-12, 0.1254D-11, 0.2143D-11, 0.3659D-11, 0.6242D-11,
     ,   0.1064D-10, 0.1812D-10, 0.3082D-10, 0.5238D-10, 0.8892D-10,
     ,   0.1508D-09, 0.2554D-09, 0.4321D-09, 0.7301D-09, 0.1232D-08,
     ,   0.2076D-08, 0.3492D-08, 0.5866D-08, 0.9836D-08, 0.1646D-07,
     ,   0.2750D-07, 0.4584D-07, 0.7624D-07, 0.1265D-06, 0.2092D-06,
     ,   0.3449D-06, 0.5666D-06, 0.9270D-06, 0.1509D-05, 0.2441D-05,
     ,   0.3921D-05, 0.6239D-05, 0.9815D-05, 0.1522D-04, 0.2317D-04,
     ,   0.3451D-04, 0.5005D-04, 0.7037D-04, 0.9546D-04, 0.1243D-03,
     ,   0.1543D-03, 0.1810D-03, 0.1981D-03, 0.1985D-03, 0.1768D-03,
     ,   0.1326D-03, 0.7333D-04, 0.1266D-04,-0.3614D-04,-0.6652D-04,
     ,  -0.8001D-04,-0.8242D-04,-0.7921D-04,-0.7356D-04,-0.6670D-04,
     ,  -0.5886D-04,-0.5003D-04,-0.4021D-04,-0.2952D-04,-0.1806D-04,
     ,  -0.5832D-05, 0.7567D-05, 0.2278D-04, 0.3940D-04, 0.5426D-04,
     ,   0.6222D-04, 0.6010D-04, 0.4956D-04, 0.3561D-04, 0.2284D-04,
     ,   0.1340D-04, 0.7346D-05, 0.3834D-05/
      data (calcpts(j,35), j = 1,neta) /
     ,   0.3578D-12, 0.6124D-12, 0.1047D-11, 0.1789D-11, 0.3055D-11,
     ,   0.5212D-11, 0.8883D-11, 0.1513D-10, 0.2573D-10, 0.4373D-10,
     ,   0.7424D-10, 0.1259D-09, 0.2133D-09, 0.3608D-09, 0.6096D-09,
     ,   0.1029D-08, 0.1733D-08, 0.2915D-08, 0.4897D-08, 0.8210D-08,
     ,   0.1374D-07, 0.2295D-07, 0.3825D-07, 0.6359D-07, 0.1055D-06,
     ,   0.1743D-06, 0.2873D-06, 0.4714D-06, 0.7701D-06, 0.1251D-05,
     ,   0.2018D-05, 0.3226D-05, 0.5104D-05, 0.7966D-05, 0.1222D-04,
     ,   0.1838D-04, 0.2697D-04, 0.3848D-04, 0.5318D-04, 0.7092D-04,
     ,   0.9087D-04, 0.1112D-03, 0.1288D-03, 0.1395D-03, 0.1385D-03,
     ,   0.1222D-03, 0.9072D-04, 0.4936D-04, 0.7437D-05,-0.2601D-04,
     ,  -0.4665D-04,-0.5572D-04,-0.5722D-04,-0.5492D-04,-0.5097D-04,
     ,  -0.4619D-04,-0.4073D-04,-0.3459D-04,-0.2776D-04,-0.2033D-04,
     ,  -0.1236D-04,-0.3857D-05, 0.5463D-05, 0.1603D-04, 0.2752D-04,
     ,   0.3770D-04, 0.4306D-04, 0.4144D-04, 0.3407D-04, 0.2443D-04,
     ,   0.1564D-04, 0.9160D-05, 0.5018D-05/
      data (calcpts(j,36), j = 1,neta) /
     ,   0.1738D-12, 0.2977D-12, 0.5095D-12, 0.8713D-12, 0.1489D-11,
     ,   0.2542D-11, 0.4336D-11, 0.7390D-11, 0.1258D-10, 0.2141D-10,
     ,   0.3638D-10, 0.6176D-10, 0.1047D-09, 0.1774D-09, 0.3001D-09,
     ,   0.5071D-09, 0.8556D-09, 0.1441D-08, 0.2425D-08, 0.4073D-08,
     ,   0.6828D-08, 0.1143D-07, 0.1908D-07, 0.3179D-07, 0.5284D-07,
     ,   0.8758D-07, 0.1447D-06, 0.2382D-06, 0.3903D-06, 0.6362D-06,
     ,   0.1030D-05, 0.1655D-05, 0.2631D-05, 0.4129D-05, 0.6379D-05,
     ,   0.9668D-05, 0.1432D-04, 0.2068D-04, 0.2901D-04, 0.3942D-04,
     ,   0.5176D-04, 0.6539D-04, 0.7905D-04, 0.9065D-04, 0.9732D-04,
     ,   0.9590D-04, 0.8406D-04, 0.6194D-04, 0.3327D-04, 0.4437D-05,
     ,  -0.1843D-04,-0.3246D-04,-0.3857D-04,-0.3952D-04,-0.3790D-04,
     ,  -0.3516D-04,-0.3185D-04,-0.2807D-04,-0.2382D-04,-0.1910D-04,
     ,  -0.1396D-04,-0.8450D-05,-0.2567D-05, 0.3879D-05, 0.1118D-04,
     ,   0.1908D-04, 0.2605D-04, 0.2966D-04, 0.2848D-04, 0.2336D-04,
     ,   0.1672D-04, 0.1069D-04, 0.6256D-05/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.8418D-13, 0.1443D-12, 0.2471D-12, 0.4228D-12, 0.7230D-12,
     ,   0.1235D-11, 0.2109D-11, 0.3598D-11, 0.6133D-11, 0.1044D-10,
     ,   0.1776D-10, 0.3019D-10, 0.5125D-10, 0.8691D-10, 0.1472D-09,
     ,   0.2490D-09, 0.4208D-09, 0.7099D-09, 0.1196D-08, 0.2012D-08,
     ,   0.3379D-08, 0.5664D-08, 0.9477D-08, 0.1582D-07, 0.2635D-07,
     ,   0.4378D-07, 0.7251D-07, 0.1197D-06, 0.1967D-06, 0.3216D-06,
     ,   0.5227D-06, 0.8429D-06, 0.1346D-05, 0.2123D-05, 0.3300D-05,
     ,   0.5035D-05, 0.7520D-05, 0.1096D-04, 0.1556D-04, 0.2147D-04,
     ,   0.2873D-04, 0.3720D-04, 0.4645D-04, 0.5560D-04, 0.6325D-04,
     ,   0.6745D-04, 0.6610D-04, 0.5764D-04, 0.4224D-04, 0.2246D-04,
     ,   0.2694D-05,-0.1292D-04,-0.2246D-04,-0.2658D-04,-0.2720D-04,
     ,  -0.2606D-04,-0.2417D-04,-0.2189D-04,-0.1928D-04,-0.1636D-04,
     ,  -0.1311D-04,-0.9563D-05,-0.5770D-05,-0.1717D-05, 0.2722D-05,
     ,   0.7743D-05, 0.1317D-04, 0.1793D-04, 0.2037D-04, 0.1952D-04,
     ,   0.1599D-04, 0.1143D-04, 0.7301D-05/
      data (calcpts(j,38), j = 1,neta) /
     ,   0.4067D-13, 0.6974D-13, 0.1195D-12, 0.2047D-12, 0.3503D-12,
     ,   0.5990D-12, 0.1023D-11, 0.1747D-11, 0.2981D-11, 0.5081D-11,
     ,   0.8651D-11, 0.1472D-10, 0.2501D-10, 0.4246D-10, 0.7200D-10,
     ,   0.1219D-09, 0.2063D-09, 0.3485D-09, 0.5880D-09, 0.9907D-09,
     ,   0.1666D-08, 0.2798D-08, 0.4690D-08, 0.7845D-08, 0.1309D-07,
     ,   0.2180D-07, 0.3619D-07, 0.5987D-07, 0.9867D-07, 0.1618D-06,
     ,   0.2638D-06, 0.4270D-06, 0.6846D-06, 0.1085D-05, 0.1694D-05,
     ,   0.2601D-05, 0.3911D-05, 0.5749D-05, 0.8242D-05, 0.1151D-04,
     ,   0.1564D-04, 0.2064D-04, 0.2641D-04, 0.3266D-04, 0.3879D-04,
     ,   0.4384D-04, 0.4652D-04, 0.4540D-04, 0.3944D-04, 0.2878D-04,
     ,   0.1519D-04, 0.1666D-05,-0.8985D-05,-0.1547D-04,-0.1826D-04,
     ,  -0.1866D-04,-0.1788D-04,-0.1657D-04,-0.1500D-04,-0.1322D-04,
     ,  -0.1121D-04,-0.8974D-05,-0.6542D-05,-0.3937D-05,-0.1154D-05,
     ,   0.1894D-05, 0.5338D-05, 0.9052D-05, 0.1230D-04, 0.1395D-04,
     ,   0.1335D-04, 0.1093D-04, 0.7805D-05/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.1961D-13, 0.3365D-13, 0.5771D-13, 0.9890D-13, 0.1694D-12,
     ,   0.2898D-12, 0.4956D-12, 0.8469D-12, 0.1446D-11, 0.2467D-11,
     ,   0.4204D-11, 0.7159D-11, 0.1218D-10, 0.2070D-10, 0.3513D-10,
     ,   0.5957D-10, 0.1009D-09, 0.1707D-09, 0.2884D-09, 0.4865D-09,
     ,   0.8195D-09, 0.1378D-08, 0.2314D-08, 0.3878D-08, 0.6485D-08,
     ,   0.1082D-07, 0.1800D-07, 0.2985D-07, 0.4931D-07, 0.8110D-07,
     ,   0.1326D-06, 0.2153D-06, 0.3464D-06, 0.5512D-06, 0.8648D-06,
     ,   0.1334D-05, 0.2019D-05, 0.2988D-05, 0.4319D-05, 0.6092D-05,
     ,   0.8377D-05, 0.1123D-04, 0.1465D-04, 0.1857D-04, 0.2278D-04,
     ,   0.2689D-04, 0.3025D-04, 0.3198D-04, 0.3110D-04, 0.2695D-04,
     ,   0.1960D-04, 0.1029D-04, 0.1048D-05,-0.6213D-05,-0.1063D-04,
     ,  -0.1252D-04,-0.1278D-04,-0.1224D-04,-0.1134D-04,-0.1027D-04,
     ,  -0.9045D-05,-0.7666D-05,-0.6137D-05,-0.4470D-05,-0.2685D-05,
     ,  -0.7782D-06, 0.1310D-05, 0.3668D-05, 0.6207D-05, 0.8423D-05,
     ,   0.9543D-05, 0.9125D-05, 0.7462D-05/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.9442D-14, 0.1621D-13, 0.2782D-13, 0.4771D-13, 0.8177D-13,
     ,   0.1400D-12, 0.2396D-12, 0.4098D-12, 0.7002D-12, 0.1196D-11,
     ,   0.2039D-11, 0.3476D-11, 0.5919D-11, 0.1007D-10, 0.1711D-10,
     ,   0.2905D-10, 0.4925D-10, 0.8342D-10, 0.1411D-09, 0.2384D-09,
     ,   0.4022D-09, 0.6774D-09, 0.1139D-08, 0.1912D-08, 0.3203D-08,
     ,   0.5353D-08, 0.8925D-08, 0.1483D-07, 0.2456D-07, 0.4050D-07,
     ,   0.6641D-07, 0.1081D-06, 0.1746D-06, 0.2787D-06, 0.4391D-06,
     ,   0.6806D-06, 0.1035D-05, 0.1541D-05, 0.2244D-05, 0.3191D-05,
     ,   0.4433D-05, 0.6014D-05, 0.7967D-05, 0.1030D-04, 0.1295D-04,
     ,   0.1580D-04, 0.1856D-04, 0.2080D-04, 0.2192D-04, 0.2127D-04,
     ,   0.1839D-04, 0.1335D-04, 0.6981D-05, 0.6705D-06,-0.4279D-05,
     ,  -0.7282D-05,-0.8565D-05,-0.8742D-05,-0.8367D-05,-0.7755D-05,
     ,  -0.7019D-05,-0.6182D-05,-0.5239D-05,-0.4192D-05,-0.3052D-05,
     ,  -0.1831D-05,-0.5262D-06, 0.9023D-06, 0.2514D-05, 0.4248D-05,
     ,   0.5759D-05, 0.6520D-05, 0.6230D-05/
      data (calcpts(j,41), j = 1,neta) /
     ,   0.4541D-14, 0.7803D-14, 0.1340D-13, 0.2299D-13, 0.3943D-13,
     ,   0.6757D-13, 0.1157D-12, 0.1980D-12, 0.3387D-12, 0.5787D-12,
     ,   0.9880D-12, 0.1685D-11, 0.2872D-11, 0.4891D-11, 0.8320D-11,
     ,   0.1414D-10, 0.2400D-10, 0.4070D-10, 0.6893D-10, 0.1166D-09,
     ,   0.1970D-09, 0.3322D-09, 0.5595D-09, 0.9406D-09, 0.1578D-08,
     ,   0.2643D-08, 0.4414D-08, 0.7352D-08, 0.1220D-07, 0.2016D-07,
     ,   0.3314D-07, 0.5412D-07, 0.8763D-07, 0.1404D-06, 0.2220D-06,
     ,   0.3455D-06, 0.5279D-06, 0.7902D-06, 0.1157D-05, 0.1658D-05,
     ,   0.2322D-05, 0.3182D-05, 0.4268D-05, 0.5600D-05, 0.7182D-05,
     ,   0.8981D-05, 0.1090D-04, 0.1276D-04, 0.1426D-04, 0.1500D-04,
     ,   0.1453D-04, 0.1255D-04, 0.9093D-05, 0.4740D-05, 0.4349D-06,
     ,  -0.2938D-05,-0.4982D-05,-0.5854D-05,-0.5972D-05,-0.5715D-05,
     ,  -0.5296D-05,-0.4794D-05,-0.4221D-05,-0.3577D-05,-0.2861D-05,
     ,  -0.2082D-05,-0.1248D-05,-0.3565D-06, 0.6195D-06, 0.1721D-05,
     ,   0.2904D-05, 0.3934D-05, 0.4450D-05/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.2182D-14, 0.3752D-14, 0.6446D-14, 0.1107D-13, 0.1899D-13,
     ,   0.3257D-13, 0.5582D-13, 0.9559D-13, 0.1636D-12, 0.2797D-12,
     ,   0.4780D-12, 0.8161D-12, 0.1392D-11, 0.2373D-11, 0.4040D-11,
     ,   0.6873D-11, 0.1168D-10, 0.1983D-10, 0.3362D-10, 0.5693D-10,
     ,   0.9629D-10, 0.1626D-09, 0.2743D-09, 0.4619D-09, 0.7762D-09,
     ,   0.1302D-08, 0.2178D-08, 0.3635D-08, 0.6045D-08, 0.1001D-07,
     ,   0.1650D-07, 0.2701D-07, 0.4385D-07, 0.7046D-07, 0.1118D-06,
     ,   0.1746D-06, 0.2679D-06, 0.4029D-06, 0.5933D-06, 0.8550D-06,
     ,   0.1206D-05, 0.1667D-05, 0.2258D-05, 0.3000D-05, 0.3907D-05,
     ,   0.4981D-05, 0.6199D-05, 0.7498D-05, 0.8753D-05, 0.9763D-05,
     ,   0.1025D-04, 0.9921D-05, 0.8555D-05, 0.6192D-05, 0.3221D-05,
     ,   0.2853D-06,-0.2013D-05,-0.3405D-05,-0.3997D-05,-0.4076D-05,
     ,  -0.3901D-05,-0.3615D-05,-0.3271D-05,-0.2881D-05,-0.2440D-05,
     ,  -0.1952D-05,-0.1420D-05,-0.8505D-06,-0.2419D-06, 0.4244D-06,
     ,   0.1176D-05, 0.1983D-05, 0.2685D-05/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.1048D-14, 0.1802D-14, 0.3098D-14, 0.5323D-14, 0.9140D-14,
     ,   0.1569D-13, 0.2690D-13, 0.4610D-13, 0.7895D-13, 0.1351D-12,
     ,   0.2310D-12, 0.3948D-12, 0.6740D-12, 0.1150D-11, 0.1959D-11,
     ,   0.3336D-11, 0.5676D-11, 0.9645D-11, 0.1637D-10, 0.2776D-10,
     ,   0.4701D-10, 0.7950D-10, 0.1343D-09, 0.2264D-09, 0.3810D-09,
     ,   0.6401D-09, 0.1073D-08, 0.1793D-08, 0.2988D-08, 0.4959D-08,
     ,   0.8189D-08, 0.1344D-07, 0.2187D-07, 0.3525D-07, 0.5609D-07,
     ,   0.8791D-07, 0.1354D-06, 0.2045D-06, 0.3025D-06, 0.4383D-06,
     ,   0.6222D-06, 0.8661D-06, 0.1183D-05, 0.1588D-05, 0.2093D-05,
     ,   0.2710D-05, 0.3438D-05, 0.4264D-05, 0.5144D-05, 0.5993D-05,
     ,   0.6674D-05, 0.7001D-05, 0.6768D-05, 0.5831D-05, 0.4217D-05,
     ,   0.2190D-05, 0.1889D-06,-0.1377D-05,-0.2325D-05,-0.2727D-05,
     ,  -0.2781D-05,-0.2661D-05,-0.2466D-05,-0.2232D-05,-0.1965D-05,
     ,  -0.1664D-05,-0.1331D-05,-0.9683D-06,-0.5796D-06,-0.1643D-06,
     ,   0.2903D-06, 0.8029D-06, 0.1353D-05/
      data (calcpts(j,44), j = 1,neta) /
     ,   0.5027D-15, 0.8651D-15, 0.1488D-14, 0.2558D-14, 0.4395D-14,
     ,   0.7547D-14, 0.1295D-13, 0.2221D-13, 0.3806D-13, 0.6519D-13,
     ,   0.1116D-12, 0.1908D-12, 0.3260D-12, 0.5565D-12, 0.9493D-12,
     ,   0.1618D-11, 0.2755D-11, 0.4686D-11, 0.7963D-11, 0.1352D-10,
     ,   0.2291D-10, 0.3880D-10, 0.6561D-10, 0.1108D-09, 0.1867D-09,
     ,   0.3142D-09, 0.5274D-09, 0.8831D-09, 0.1474D-08, 0.2451D-08,
     ,   0.4056D-08, 0.6670D-08, 0.1088D-07, 0.1758D-07, 0.2806D-07,
     ,   0.4411D-07, 0.6817D-07, 0.1033D-06, 0.1536D-06, 0.2235D-06,
     ,   0.3190D-06, 0.4468D-06, 0.6148D-06, 0.8320D-06, 0.1108D-05,
     ,   0.1452D-05, 0.1871D-05, 0.2365D-05, 0.2926D-05, 0.3522D-05,
     ,   0.4097D-05, 0.4558D-05, 0.4777D-05, 0.4615D-05, 0.3974D-05,
     ,   0.2872D-05, 0.1490D-05, 0.1260D-06,-0.9406D-06,-0.1586D-05,
     ,  -0.1860D-05,-0.1897D-05,-0.1815D-05,-0.1681D-05,-0.1522D-05,
     ,  -0.1340D-05,-0.1135D-05,-0.9076D-06,-0.6601D-06,-0.3949D-06,
     ,  -0.1117D-06, 0.1983D-06, 0.5478D-06/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.2410D-15, 0.4150D-15, 0.7143D-15, 0.1229D-14, 0.2112D-14,
     ,   0.3629D-14, 0.6231D-14, 0.1069D-13, 0.1834D-13, 0.3143D-13,
     ,   0.5382D-13, 0.9210D-13, 0.1575D-12, 0.2691D-12, 0.4594D-12,
     ,   0.7837D-12, 0.1336D-11, 0.2274D-11, 0.3868D-11, 0.6573D-11,
     ,   0.1116D-10, 0.1891D-10, 0.3202D-10, 0.5413D-10, 0.9137D-10,
     ,   0.1539D-09, 0.2588D-09, 0.4341D-09, 0.7258D-09, 0.1209D-08,
     ,   0.2004D-08, 0.3303D-08, 0.5401D-08, 0.8747D-08, 0.1400D-07,
     ,   0.2207D-07, 0.3421D-07, 0.5204D-07, 0.7761D-07, 0.1135D-06,
     ,   0.1627D-06, 0.2291D-06, 0.3172D-06, 0.4324D-06, 0.5807D-06,
     ,   0.7687D-06, 0.1003D-05, 0.1287D-05, 0.1623D-05, 0.2003D-05,
     ,   0.2408D-05, 0.2799D-05, 0.3111D-05, 0.3258D-05, 0.3146D-05,
     ,   0.2708D-05, 0.1957D-05, 0.1014D-05, 0.8451D-07,-0.6422D-06,
     ,  -0.1082D-05,-0.1268D-05,-0.1293D-05,-0.1237D-05,-0.1146D-05,
     ,  -0.1037D-05,-0.9133D-06,-0.7736D-06,-0.6187D-06,-0.4499D-06,
     ,  -0.2691D-06,-0.7599D-07, 0.1354D-06/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.1155D-15, 0.1990D-15, 0.3426D-15, 0.5896D-15, 0.1014D-14,
     ,   0.1744D-14, 0.2996D-14, 0.5144D-14, 0.8827D-14, 0.1514D-13,
     ,   0.2594D-13, 0.4443D-13, 0.7603D-13, 0.1300D-12, 0.2222D-12,
     ,   0.3793D-12, 0.6470D-12, 0.1103D-11, 0.1877D-11, 0.3193D-11,
     ,   0.5425D-11, 0.9207D-11, 0.1561D-10, 0.2642D-10, 0.4464D-10,
     ,   0.7532D-10, 0.1268D-09, 0.2130D-09, 0.3567D-09, 0.5952D-09,
     ,   0.9886D-09, 0.1632D-08, 0.2675D-08, 0.4341D-08, 0.6963D-08,
     ,   0.1101D-07, 0.1711D-07, 0.2612D-07, 0.3908D-07, 0.5736D-07,
     ,   0.8261D-07, 0.1169D-06, 0.1627D-06, 0.2232D-06, 0.3018D-06,
     ,   0.4029D-06, 0.5309D-06, 0.6899D-06, 0.8833D-06, 0.1112D-05,
     ,   0.1370D-05, 0.1645D-05, 0.1910D-05, 0.2122D-05, 0.2222D-05,
     ,   0.2144D-05, 0.1845D-05, 0.1333D-05, 0.6903D-06, 0.5692D-07,
     ,  -0.4382D-06,-0.7376D-06,-0.8647D-06,-0.8814D-06,-0.8432D-06,
     ,  -0.7813D-06,-0.7070D-06,-0.6225D-06,-0.5273D-06,-0.4216D-06,
     ,  -0.3066D-06,-0.1833D-06,-0.5172D-07/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.5531D-16, 0.9534D-16, 0.1642D-15, 0.2828D-15, 0.4868D-15,
     ,   0.8373D-15, 0.1439D-14, 0.2473D-14, 0.4246D-14, 0.7287D-14,
     ,   0.1250D-13, 0.2142D-13, 0.3668D-13, 0.6276D-13, 0.1073D-12,
     ,   0.1834D-12, 0.3131D-12, 0.5340D-12, 0.9101D-12, 0.1549D-11,
     ,   0.2635D-11, 0.4477D-11, 0.7597D-11, 0.1287D-10, 0.2178D-10,
     ,   0.3680D-10, 0.6204D-10, 0.1044D-09, 0.1750D-09, 0.2925D-09,
     ,   0.4867D-09, 0.8050D-09, 0.1322D-08, 0.2150D-08, 0.3456D-08,
     ,   0.5476D-08, 0.8537D-08, 0.1307D-07, 0.1962D-07, 0.2889D-07,
     ,   0.4177D-07, 0.5935D-07, 0.8302D-07, 0.1145D-06, 0.1558D-06,
     ,   0.2095D-06, 0.2783D-06, 0.3653D-06, 0.4735D-06, 0.6050D-06,
     ,   0.7602D-06, 0.9359D-06, 0.1123D-05, 0.1303D-05, 0.1447D-05,
     ,   0.1514D-05, 0.1461D-05, 0.1257D-05, 0.9079D-06, 0.4701D-06,
     ,   0.3846D-07,-0.2988D-06,-0.5028D-06,-0.5894D-06,-0.6007D-06,
     ,  -0.5747D-06,-0.5325D-06,-0.4818D-06,-0.4242D-06,-0.3593D-06,
     ,  -0.2873D-06,-0.2089D-06,-0.1249D-06/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.2648D-16, 0.4566D-16, 0.7870D-16, 0.1356D-15, 0.2335D-15,
     ,   0.4018D-15, 0.6911D-15, 0.1188D-14, 0.2041D-14, 0.3505D-14,
     ,   0.6015D-14, 0.1032D-13, 0.1768D-13, 0.3027D-13, 0.5181D-13,
     ,   0.8859D-13, 0.1514D-12, 0.2584D-12, 0.4408D-12, 0.7511D-12,
     ,   0.1279D-11, 0.2175D-11, 0.3694D-11, 0.6267D-11, 0.1062D-10,
     ,   0.1796D-10, 0.3031D-10, 0.5105D-10, 0.8575D-10, 0.1435D-09,
     ,   0.2392D-09, 0.3963D-09, 0.6519D-09, 0.1062D-08, 0.1711D-08,
     ,   0.2718D-08, 0.4248D-08, 0.6519D-08, 0.9816D-08, 0.1450D-07,
     ,   0.2104D-07, 0.3001D-07, 0.4216D-07, 0.5841D-07, 0.7993D-07,
     ,   0.1081D-06, 0.1447D-06, 0.1915D-06, 0.2508D-06, 0.3243D-06,
     ,   0.4138D-06, 0.5194D-06, 0.6389D-06, 0.7660D-06, 0.8886D-06,
     ,   0.9864D-06, 0.1032D-05, 0.9958D-06, 0.8567D-06, 0.6185D-06,
     ,   0.3201D-06, 0.2605D-07,-0.2037D-06,-0.3427D-06,-0.4017D-06,
     ,  -0.4094D-06,-0.3916D-06,-0.3628D-06,-0.3284D-06,-0.2891D-06,
     ,  -0.2449D-06,-0.1958D-06,-0.1423D-06/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.1267D-16, 0.2185D-16, 0.3769D-16, 0.6496D-16, 0.1119D-15,
     ,   0.1927D-15, 0.3317D-15, 0.5705D-15, 0.9808D-15, 0.1685D-14,
     ,   0.2893D-14, 0.4965D-14, 0.8515D-14, 0.1459D-13, 0.2499D-13,
     ,   0.4276D-13, 0.7312D-13, 0.1249D-12, 0.2133D-12, 0.3638D-12,
     ,   0.6199D-12, 0.1055D-11, 0.1794D-11, 0.3047D-11, 0.5168D-11,
     ,   0.8751D-11, 0.1479D-10, 0.2494D-10, 0.4195D-10, 0.7032D-10,
     ,   0.1174D-09, 0.1948D-09, 0.3209D-09, 0.5240D-09, 0.8457D-09,
     ,   0.1346D-08, 0.2108D-08, 0.3244D-08, 0.4898D-08, 0.7258D-08,
     ,   0.1056D-07, 0.1512D-07, 0.2132D-07, 0.2967D-07, 0.4079D-07,
     ,   0.5548D-07, 0.7470D-07, 0.9959D-07, 0.1315D-06, 0.1718D-06,
     ,   0.2218D-06, 0.2827D-06, 0.3545D-06, 0.4359D-06, 0.5224D-06,
     ,   0.6058D-06, 0.6723D-06, 0.7034D-06, 0.6786D-06, 0.5837D-06,
     ,   0.4213D-06, 0.2180D-06, 0.1767D-07,-0.1389D-06,-0.2335D-06,
     ,  -0.2737D-06,-0.2790D-06,-0.2668D-06,-0.2472D-06,-0.2237D-06,
     ,  -0.1970D-06,-0.1668D-06,-0.1334D-06/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c-----------------------------
      subroutine c2hqg21m(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.1163D-03,-0.1370D-03,-0.1616D-03,-0.1902D-03,-0.2239D-03,
     ,  -0.2630D-03,-0.3090D-03,-0.3623D-03,-0.4248D-03,-0.4973D-03,
     ,  -0.5816D-03,-0.6781D-03,-0.7915D-03,-0.9218D-03,-0.1070D-02,
     ,  -0.1244D-02,-0.1440D-02,-0.1663D-02,-0.1917D-02,-0.2207D-02,
     ,  -0.2528D-02,-0.2892D-02,-0.3299D-02,-0.3745D-02,-0.4242D-02,
     ,  -0.4778D-02,-0.5361D-02,-0.5985D-02,-0.6647D-02,-0.7332D-02,
     ,  -0.7998D-02,-0.8616D-02,-0.9066D-02,-0.9220D-02,-0.8863D-02,
     ,  -0.7902D-02,-0.6294D-02,-0.4204D-02,-0.1864D-02, 0.4330D-03,
     ,   0.2531D-02, 0.4371D-02, 0.5939D-02, 0.7247D-02, 0.8341D-02,
     ,   0.9247D-02, 0.9978D-02, 0.1056D-01, 0.1102D-01, 0.1139D-01,
     ,   0.1166D-01, 0.1188D-01, 0.1203D-01, 0.1217D-01, 0.1226D-01,
     ,   0.1234D-01, 0.1239D-01, 0.1243D-01, 0.1246D-01, 0.1248D-01,
     ,   0.1250D-01, 0.1250D-01, 0.1252D-01, 0.1253D-01, 0.1252D-01,
     ,   0.1253D-01, 0.1253D-01, 0.1252D-01, 0.1254D-01, 0.1254D-01,
     ,   0.1254D-01, 0.1254D-01, 0.1254D-01/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.1162D-03,-0.1370D-03,-0.1615D-03,-0.1901D-03,-0.2238D-03,
     ,  -0.2630D-03,-0.3089D-03,-0.3623D-03,-0.4247D-03,-0.4972D-03,
     ,  -0.5812D-03,-0.6777D-03,-0.7915D-03,-0.9218D-03,-0.1070D-02,
     ,  -0.1242D-02,-0.1439D-02,-0.1662D-02,-0.1917D-02,-0.2204D-02,
     ,  -0.2529D-02,-0.2893D-02,-0.3298D-02,-0.3746D-02,-0.4239D-02,
     ,  -0.4777D-02,-0.5360D-02,-0.5984D-02,-0.6644D-02,-0.7319D-02,
     ,  -0.7996D-02,-0.8617D-02,-0.9067D-02,-0.9202D-02,-0.8862D-02,
     ,  -0.7906D-02,-0.6297D-02,-0.4188D-02,-0.1867D-02, 0.4297D-03,
     ,   0.2528D-02, 0.4370D-02, 0.5938D-02, 0.7247D-02, 0.8341D-02,
     ,   0.9249D-02, 0.9980D-02, 0.1056D-01, 0.1102D-01, 0.1138D-01,
     ,   0.1166D-01, 0.1188D-01, 0.1203D-01, 0.1217D-01, 0.1226D-01,
     ,   0.1233D-01, 0.1238D-01, 0.1242D-01, 0.1246D-01, 0.1248D-01,
     ,   0.1249D-01, 0.1250D-01, 0.1251D-01, 0.1252D-01, 0.1252D-01,
     ,   0.1253D-01, 0.1253D-01, 0.1252D-01, 0.1253D-01, 0.1254D-01,
     ,   0.1254D-01, 0.1254D-01, 0.1254D-01/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.1160D-03,-0.1371D-03,-0.1613D-03,-0.1902D-03,-0.2235D-03,
     ,  -0.2631D-03,-0.3087D-03,-0.3625D-03,-0.4245D-03,-0.4970D-03,
     ,  -0.5807D-03,-0.6788D-03,-0.7913D-03,-0.9211D-03,-0.1071D-02,
     ,  -0.1240D-02,-0.1437D-02,-0.1663D-02,-0.1917D-02,-0.2202D-02,
     ,  -0.2532D-02,-0.2895D-02,-0.3297D-02,-0.3749D-02,-0.4236D-02,
     ,  -0.4778D-02,-0.5360D-02,-0.5984D-02,-0.6639D-02,-0.7305D-02,
     ,  -0.7993D-02,-0.8611D-02,-0.9062D-02,-0.9181D-02,-0.8878D-02,
     ,  -0.7909D-02,-0.6301D-02,-0.4168D-02,-0.1871D-02, 0.4260D-03,
     ,   0.2531D-02, 0.4369D-02, 0.5937D-02, 0.7262D-02, 0.8356D-02,
     ,   0.9251D-02, 0.9975D-02, 0.1056D-01, 0.1102D-01, 0.1136D-01,
     ,   0.1166D-01, 0.1187D-01, 0.1204D-01, 0.1216D-01, 0.1226D-01,
     ,   0.1231D-01, 0.1237D-01, 0.1241D-01, 0.1245D-01, 0.1248D-01,
     ,   0.1248D-01, 0.1251D-01, 0.1250D-01, 0.1250D-01, 0.1253D-01,
     ,   0.1253D-01, 0.1253D-01, 0.1254D-01, 0.1252D-01, 0.1254D-01,
     ,   0.1254D-01, 0.1254D-01, 0.1254D-01/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.1162D-03,-0.1370D-03,-0.1615D-03,-0.1899D-03,-0.2235D-03,
     ,  -0.2627D-03,-0.3086D-03,-0.3616D-03,-0.4243D-03,-0.4967D-03,
     ,  -0.5807D-03,-0.6786D-03,-0.7910D-03,-0.9190D-03,-0.1070D-02,
     ,  -0.1242D-02,-0.1438D-02,-0.1662D-02,-0.1914D-02,-0.2206D-02,
     ,  -0.2524D-02,-0.2887D-02,-0.3292D-02,-0.3739D-02,-0.4237D-02,
     ,  -0.4775D-02,-0.5354D-02,-0.5977D-02,-0.6634D-02,-0.7323D-02,
     ,  -0.7992D-02,-0.8581D-02,-0.9034D-02,-0.9216D-02,-0.8846D-02,
     ,  -0.7914D-02,-0.6300D-02,-0.4207D-02,-0.1870D-02, 0.4206D-03,
     ,   0.2555D-02, 0.4361D-02, 0.5929D-02, 0.7254D-02, 0.8349D-02,
     ,   0.9247D-02, 0.9956D-02, 0.1054D-01, 0.1100D-01, 0.1138D-01,
     ,   0.1164D-01, 0.1186D-01, 0.1204D-01, 0.1215D-01, 0.1224D-01,
     ,   0.1233D-01, 0.1239D-01, 0.1243D-01, 0.1244D-01, 0.1246D-01,
     ,   0.1249D-01, 0.1250D-01, 0.1251D-01, 0.1252D-01, 0.1252D-01,
     ,   0.1251D-01, 0.1253D-01, 0.1253D-01, 0.1254D-01, 0.1251D-01,
     ,   0.1252D-01, 0.1252D-01, 0.1252D-01/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.1159D-03,-0.1367D-03,-0.1611D-03,-0.1897D-03,-0.2233D-03,
     ,  -0.2625D-03,-0.3083D-03,-0.3617D-03,-0.4238D-03,-0.4962D-03,
     ,  -0.5800D-03,-0.6774D-03,-0.7904D-03,-0.9202D-03,-0.1068D-02,
     ,  -0.1239D-02,-0.1435D-02,-0.1659D-02,-0.1913D-02,-0.2198D-02,
     ,  -0.2525D-02,-0.2888D-02,-0.3293D-02,-0.3737D-02,-0.4230D-02,
     ,  -0.4768D-02,-0.5350D-02,-0.5971D-02,-0.6630D-02,-0.7311D-02,
     ,  -0.7969D-02,-0.8609D-02,-0.9062D-02,-0.9207D-02,-0.8878D-02,
     ,  -0.7908D-02,-0.6278D-02,-0.4202D-02,-0.1848D-02, 0.4192D-03,
     ,   0.2515D-02, 0.4359D-02, 0.5927D-02, 0.7233D-02, 0.8327D-02,
     ,   0.9223D-02, 0.9976D-02, 0.1056D-01, 0.1102D-01, 0.1135D-01,
     ,   0.1166D-01, 0.1187D-01, 0.1202D-01, 0.1217D-01, 0.1226D-01,
     ,   0.1231D-01, 0.1236D-01, 0.1240D-01, 0.1246D-01, 0.1248D-01,
     ,   0.1247D-01, 0.1248D-01, 0.1249D-01, 0.1249D-01, 0.1250D-01,
     ,   0.1253D-01, 0.1251D-01, 0.1251D-01, 0.1251D-01, 0.1252D-01,
     ,   0.1254D-01, 0.1254D-01, 0.1254D-01/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.1159D-03,-0.1365D-03,-0.1609D-03,-0.1896D-03,-0.2230D-03,
     ,  -0.2620D-03,-0.3075D-03,-0.3611D-03,-0.4229D-03,-0.4952D-03,
     ,  -0.5787D-03,-0.6754D-03,-0.7874D-03,-0.9168D-03,-0.1068D-02,
     ,  -0.1240D-02,-0.1434D-02,-0.1658D-02,-0.1911D-02,-0.2199D-02,
     ,  -0.2518D-02,-0.2881D-02,-0.3285D-02,-0.3733D-02,-0.4225D-02,
     ,  -0.4760D-02,-0.5341D-02,-0.5965D-02,-0.6621D-02,-0.7293D-02,
     ,  -0.7984D-02,-0.8567D-02,-0.9023D-02,-0.9177D-02,-0.8844D-02,
     ,  -0.7859D-02,-0.6316D-02,-0.4178D-02,-0.1887D-02, 0.4373D-03,
     ,   0.2510D-02, 0.4352D-02, 0.5917D-02, 0.7232D-02, 0.8324D-02,
     ,   0.9226D-02, 0.9947D-02, 0.1053D-01, 0.1099D-01, 0.1136D-01,
     ,   0.1163D-01, 0.1185D-01, 0.1202D-01, 0.1214D-01, 0.1223D-01,
     ,   0.1231D-01, 0.1236D-01, 0.1240D-01, 0.1243D-01, 0.1245D-01,
     ,   0.1247D-01, 0.1248D-01, 0.1249D-01, 0.1250D-01, 0.1250D-01,
     ,   0.1250D-01, 0.1251D-01, 0.1251D-01, 0.1251D-01, 0.1253D-01,
     ,   0.1251D-01, 0.1251D-01, 0.1251D-01/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.1153D-03,-0.1361D-03,-0.1605D-03,-0.1890D-03,-0.2223D-03,
     ,  -0.2614D-03,-0.3071D-03,-0.3600D-03,-0.4221D-03,-0.4942D-03,
     ,  -0.5781D-03,-0.6759D-03,-0.7865D-03,-0.9160D-03,-0.1063D-02,
     ,  -0.1234D-02,-0.1432D-02,-0.1652D-02,-0.1906D-02,-0.2192D-02,
     ,  -0.2515D-02,-0.2876D-02,-0.3280D-02,-0.3726D-02,-0.4215D-02,
     ,  -0.4752D-02,-0.5330D-02,-0.5953D-02,-0.6609D-02,-0.7298D-02,
     ,  -0.7955D-02,-0.8565D-02,-0.9024D-02,-0.9183D-02,-0.8846D-02,
     ,  -0.7927D-02,-0.6284D-02,-0.4193D-02,-0.1868D-02, 0.3937D-03,
     ,   0.2500D-02, 0.4341D-02, 0.5907D-02, 0.7226D-02, 0.8320D-02,
     ,   0.9216D-02, 0.9921D-02, 0.1051D-01, 0.1099D-01, 0.1135D-01,
     ,   0.1161D-01, 0.1182D-01, 0.1201D-01, 0.1211D-01, 0.1221D-01,
     ,   0.1230D-01, 0.1235D-01, 0.1239D-01, 0.1240D-01, 0.1245D-01,
     ,   0.1246D-01, 0.1248D-01, 0.1248D-01, 0.1249D-01, 0.1250D-01,
     ,   0.1248D-01, 0.1250D-01, 0.1250D-01, 0.1250D-01, 0.1248D-01,
     ,   0.1248D-01, 0.1248D-01, 0.1248D-01/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.1151D-03,-0.1358D-03,-0.1600D-03,-0.1884D-03,-0.2218D-03,
     ,  -0.2606D-03,-0.3060D-03,-0.3590D-03,-0.4211D-03,-0.4926D-03,
     ,  -0.5757D-03,-0.6705D-03,-0.7845D-03,-0.9138D-03,-0.1063D-02,
     ,  -0.1231D-02,-0.1426D-02,-0.1647D-02,-0.1900D-02,-0.2188D-02,
     ,  -0.2510D-02,-0.2868D-02,-0.3271D-02,-0.3713D-02,-0.4202D-02,
     ,  -0.4737D-02,-0.5315D-02,-0.5934D-02,-0.6589D-02,-0.7249D-02,
     ,  -0.7942D-02,-0.8551D-02,-0.9015D-02,-0.9172D-02,-0.8818D-02,
     ,  -0.7864D-02,-0.6269D-02,-0.4209D-02,-0.1914D-02, 0.4115D-03,
     ,   0.2506D-02, 0.4322D-02, 0.5889D-02, 0.7219D-02, 0.8292D-02,
     ,   0.9188D-02, 0.9920D-02, 0.1052D-01, 0.1096D-01, 0.1132D-01,
     ,   0.1160D-01, 0.1182D-01, 0.1198D-01, 0.1211D-01, 0.1223D-01,
     ,   0.1227D-01, 0.1232D-01, 0.1237D-01, 0.1240D-01, 0.1242D-01,
     ,   0.1243D-01, 0.1245D-01, 0.1245D-01, 0.1246D-01, 0.1247D-01,
     ,   0.1247D-01, 0.1247D-01, 0.1247D-01, 0.1247D-01, 0.1248D-01,
     ,   0.1248D-01, 0.1248D-01, 0.1248D-01/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.1147D-03,-0.1351D-03,-0.1594D-03,-0.1874D-03,-0.2206D-03,
     ,  -0.2593D-03,-0.3046D-03,-0.3573D-03,-0.4186D-03,-0.4898D-03,
     ,  -0.5732D-03,-0.6707D-03,-0.7798D-03,-0.9088D-03,-0.1055D-02,
     ,  -0.1227D-02,-0.1418D-02,-0.1641D-02,-0.1892D-02,-0.2173D-02,
     ,  -0.2494D-02,-0.2854D-02,-0.3252D-02,-0.3697D-02,-0.4186D-02,
     ,  -0.4715D-02,-0.5291D-02,-0.5907D-02,-0.6558D-02,-0.7250D-02,
     ,  -0.7898D-02,-0.8508D-02,-0.8966D-02,-0.9102D-02,-0.8818D-02,
     ,  -0.7877D-02,-0.6286D-02,-0.4224D-02,-0.1873D-02, 0.3782D-03,
     ,   0.2444D-02, 0.4300D-02, 0.5860D-02, 0.7166D-02, 0.8282D-02,
     ,   0.9160D-02, 0.9906D-02, 0.1046D-01, 0.1093D-01, 0.1129D-01,
     ,   0.1159D-01, 0.1180D-01, 0.1195D-01, 0.1209D-01, 0.1217D-01,
     ,   0.1224D-01, 0.1230D-01, 0.1234D-01, 0.1238D-01, 0.1239D-01,
     ,   0.1240D-01, 0.1242D-01, 0.1242D-01, 0.1243D-01, 0.1244D-01,
     ,   0.1244D-01, 0.1244D-01, 0.1244D-01, 0.1244D-01, 0.1244D-01,
     ,   0.1244D-01, 0.1246D-01, 0.1246D-01/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.1137D-03,-0.1340D-03,-0.1579D-03,-0.1863D-03,-0.2189D-03,
     ,  -0.2575D-03,-0.3022D-03,-0.3547D-03,-0.4159D-03,-0.4870D-03,
     ,  -0.5689D-03,-0.6643D-03,-0.7741D-03,-0.9020D-03,-0.1050D-02,
     ,  -0.1217D-02,-0.1411D-02,-0.1628D-02,-0.1878D-02,-0.2160D-02,
     ,  -0.2480D-02,-0.2834D-02,-0.3231D-02,-0.3673D-02,-0.4154D-02,
     ,  -0.4688D-02,-0.5259D-02,-0.5873D-02,-0.6522D-02,-0.7178D-02,
     ,  -0.7853D-02,-0.8486D-02,-0.8896D-02,-0.9076D-02,-0.8765D-02,
     ,  -0.7826D-02,-0.6277D-02,-0.4197D-02,-0.1921D-02, 0.3410D-03,
     ,   0.2442D-02, 0.4266D-02, 0.5827D-02, 0.7135D-02, 0.8223D-02,
     ,   0.9126D-02, 0.9849D-02, 0.1044D-01, 0.1089D-01, 0.1125D-01,
     ,   0.1151D-01, 0.1173D-01, 0.1192D-01, 0.1202D-01, 0.1211D-01,
     ,   0.1221D-01, 0.1226D-01, 0.1230D-01, 0.1231D-01, 0.1235D-01,
     ,   0.1237D-01, 0.1238D-01, 0.1239D-01, 0.1240D-01, 0.1240D-01,
     ,   0.1240D-01, 0.1241D-01, 0.1241D-01, 0.1241D-01, 0.1241D-01,
     ,   0.1241D-01, 0.1239D-01, 0.1239D-01/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.1125D-03,-0.1327D-03,-0.1565D-03,-0.1841D-03,-0.2168D-03,
     ,  -0.2548D-03,-0.2993D-03,-0.3513D-03,-0.4115D-03,-0.4816D-03,
     ,  -0.5635D-03,-0.6577D-03,-0.7688D-03,-0.8920D-03,-0.1038D-02,
     ,  -0.1205D-02,-0.1395D-02,-0.1612D-02,-0.1860D-02,-0.2138D-02,
     ,  -0.2452D-02,-0.2807D-02,-0.3201D-02,-0.3634D-02,-0.4119D-02,
     ,  -0.4640D-02,-0.5209D-02,-0.5815D-02,-0.6463D-02,-0.7143D-02,
     ,  -0.7790D-02,-0.8387D-02,-0.8878D-02,-0.9056D-02,-0.8768D-02,
     ,  -0.7820D-02,-0.6283D-02,-0.4249D-02,-0.1969D-02, 0.3157D-03,
     ,   0.2406D-02, 0.4214D-02, 0.5771D-02, 0.7089D-02, 0.8164D-02,
     ,   0.9077D-02, 0.9787D-02, 0.1037D-01, 0.1083D-01, 0.1119D-01,
     ,   0.1147D-01, 0.1169D-01, 0.1185D-01, 0.1198D-01, 0.1207D-01,
     ,   0.1214D-01, 0.1220D-01, 0.1224D-01, 0.1227D-01, 0.1227D-01,
     ,   0.1230D-01, 0.1232D-01, 0.1232D-01, 0.1233D-01, 0.1234D-01,
     ,   0.1234D-01, 0.1232D-01, 0.1235D-01, 0.1235D-01, 0.1235D-01,
     ,   0.1235D-01, 0.1235D-01, 0.1235D-01/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.1107D-03,-0.1307D-03,-0.1540D-03,-0.1816D-03,-0.2134D-03,
     ,  -0.2509D-03,-0.2947D-03,-0.3457D-03,-0.4048D-03,-0.4744D-03,
     ,  -0.5547D-03,-0.6480D-03,-0.7543D-03,-0.8808D-03,-0.1021D-02,
     ,  -0.1186D-02,-0.1374D-02,-0.1590D-02,-0.1832D-02,-0.2108D-02,
     ,  -0.2419D-02,-0.2766D-02,-0.3155D-02,-0.3586D-02,-0.4059D-02,
     ,  -0.4577D-02,-0.5136D-02,-0.5740D-02,-0.6376D-02,-0.7036D-02,
     ,  -0.7690D-02,-0.8290D-02,-0.8771D-02,-0.8914D-02,-0.8644D-02,
     ,  -0.7785D-02,-0.6271D-02,-0.4244D-02,-0.1980D-02, 0.2586D-03,
     ,   0.2317D-02, 0.4140D-02, 0.5693D-02, 0.6998D-02, 0.8088D-02,
     ,   0.8962D-02, 0.9692D-02, 0.1027D-01, 0.1073D-01, 0.1109D-01,
     ,   0.1139D-01, 0.1159D-01, 0.1176D-01, 0.1188D-01, 0.1197D-01,
     ,   0.1205D-01, 0.1210D-01, 0.1214D-01, 0.1217D-01, 0.1219D-01,
     ,   0.1221D-01, 0.1222D-01, 0.1223D-01, 0.1224D-01, 0.1224D-01,
     ,   0.1224D-01, 0.1225D-01, 0.1225D-01, 0.1225D-01, 0.1225D-01,
     ,   0.1225D-01, 0.1225D-01, 0.1225D-01/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.1084D-03,-0.1278D-03,-0.1506D-03,-0.1773D-03,-0.2085D-03,
     ,  -0.2453D-03,-0.2882D-03,-0.3380D-03,-0.3964D-03,-0.4641D-03,
     ,  -0.5426D-03,-0.6334D-03,-0.7390D-03,-0.8612D-03,-0.1000D-02,
     ,  -0.1162D-02,-0.1344D-02,-0.1556D-02,-0.1794D-02,-0.2066D-02,
     ,  -0.2371D-02,-0.2708D-02,-0.3088D-02,-0.3512D-02,-0.3974D-02,
     ,  -0.4482D-02,-0.5037D-02,-0.5627D-02,-0.6250D-02,-0.6892D-02,
     ,  -0.7560D-02,-0.8186D-02,-0.8597D-02,-0.8835D-02,-0.8564D-02,
     ,  -0.7732D-02,-0.6245D-02,-0.4256D-02,-0.2037D-02, 0.1740D-03,
     ,   0.2228D-02, 0.4033D-02, 0.5578D-02, 0.6887D-02, 0.7958D-02,
     ,   0.8857D-02, 0.9582D-02, 0.1014D-01, 0.1060D-01, 0.1096D-01,
     ,   0.1124D-01, 0.1148D-01, 0.1163D-01, 0.1175D-01, 0.1185D-01,
     ,   0.1192D-01, 0.1197D-01, 0.1201D-01, 0.1204D-01, 0.1206D-01,
     ,   0.1208D-01, 0.1209D-01, 0.1210D-01, 0.1211D-01, 0.1211D-01,
     ,   0.1211D-01, 0.1212D-01, 0.1212D-01, 0.1212D-01, 0.1212D-01,
     ,   0.1212D-01, 0.1212D-01, 0.1212D-01/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.1047D-03,-0.1236D-03,-0.1458D-03,-0.1716D-03,-0.2019D-03,
     ,  -0.2375D-03,-0.2789D-03,-0.3272D-03,-0.3838D-03,-0.4491D-03,
     ,  -0.5251D-03,-0.6134D-03,-0.7151D-03,-0.8321D-03,-0.9704D-03,
     ,  -0.1123D-02,-0.1304D-02,-0.1506D-02,-0.1738D-02,-0.2000D-02,
     ,  -0.2292D-02,-0.2627D-02,-0.2997D-02,-0.3408D-02,-0.3859D-02,
     ,  -0.4353D-02,-0.4887D-02,-0.5463D-02,-0.6077D-02,-0.6708D-02,
     ,  -0.7354D-02,-0.7931D-02,-0.8412D-02,-0.8640D-02,-0.8416D-02,
     ,  -0.7628D-02,-0.6193D-02,-0.4326D-02,-0.2133D-02, 0.9456D-04,
     ,   0.2104D-02, 0.3883D-02, 0.5416D-02, 0.6700D-02, 0.7790D-02,
     ,   0.8663D-02, 0.9387D-02, 0.9975D-02, 0.1043D-01, 0.1079D-01,
     ,   0.1105D-01, 0.1127D-01, 0.1143D-01, 0.1158D-01, 0.1167D-01,
     ,   0.1173D-01, 0.1178D-01, 0.1182D-01, 0.1187D-01, 0.1189D-01,
     ,   0.1189D-01, 0.1190D-01, 0.1191D-01, 0.1192D-01, 0.1192D-01,
     ,   0.1192D-01, 0.1194D-01, 0.1193D-01, 0.1193D-01, 0.1193D-01,
     ,   0.1195D-01, 0.1195D-01, 0.1195D-01/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.9990D-04,-0.1177D-03,-0.1389D-03,-0.1636D-03,-0.1925D-03,
     ,  -0.2262D-03,-0.2656D-03,-0.3116D-03,-0.3654D-03,-0.4280D-03,
     ,  -0.5008D-03,-0.5852D-03,-0.6835D-03,-0.7956D-03,-0.9248D-03,
     ,  -0.1075D-02,-0.1242D-02,-0.1438D-02,-0.1657D-02,-0.1906D-02,
     ,  -0.2192D-02,-0.2509D-02,-0.2864D-02,-0.3254D-02,-0.3690D-02,
     ,  -0.4165D-02,-0.4680D-02,-0.5239D-02,-0.5832D-02,-0.6454D-02,
     ,  -0.7073D-02,-0.7671D-02,-0.8175D-02,-0.8392D-02,-0.8230D-02,
     ,  -0.7491D-02,-0.6178D-02,-0.4326D-02,-0.2231D-02,-0.9581D-04,
     ,   0.1883D-02, 0.3669D-02, 0.5186D-02, 0.6472D-02, 0.7541D-02,
     ,   0.8438D-02, 0.9146D-02, 0.9717D-02, 0.1016D-01, 0.1052D-01,
     ,   0.1081D-01, 0.1102D-01, 0.1119D-01, 0.1129D-01, 0.1138D-01,
     ,   0.1148D-01, 0.1153D-01, 0.1157D-01, 0.1158D-01, 0.1160D-01,
     ,   0.1164D-01, 0.1163D-01, 0.1166D-01, 0.1167D-01, 0.1165D-01,
     ,   0.1167D-01, 0.1166D-01, 0.1168D-01, 0.1168D-01, 0.1168D-01,
     ,   0.1166D-01, 0.1166D-01, 0.1166D-01/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.9298D-04,-0.1098D-03,-0.1295D-03,-0.1524D-03,-0.1794D-03,
     ,  -0.2110D-03,-0.2480D-03,-0.2912D-03,-0.3412D-03,-0.3997D-03,
     ,  -0.4673D-03,-0.5459D-03,-0.6360D-03,-0.7408D-03,-0.8620D-03,
     ,  -0.1001D-02,-0.1162D-02,-0.1342D-02,-0.1552D-02,-0.1787D-02,
     ,  -0.2054D-02,-0.2347D-02,-0.2682D-02,-0.3053D-02,-0.3463D-02,
     ,  -0.3909D-02,-0.4397D-02,-0.4924D-02,-0.5484D-02,-0.6083D-02,
     ,  -0.6676D-02,-0.7249D-02,-0.7732D-02,-0.7994D-02,-0.7911D-02,
     ,  -0.7331D-02,-0.6115D-02,-0.4406D-02,-0.2382D-02,-0.3299D-03,
     ,   0.1656D-02, 0.3374D-02, 0.4863D-02, 0.6130D-02, 0.7193D-02,
     ,   0.8062D-02, 0.8765D-02, 0.9327D-02, 0.9790D-02, 0.1015D-01,
     ,   0.1043D-01, 0.1063D-01, 0.1081D-01, 0.1094D-01, 0.1103D-01,
     ,   0.1108D-01, 0.1114D-01, 0.1118D-01, 0.1123D-01, 0.1125D-01,
     ,   0.1124D-01, 0.1128D-01, 0.1126D-01, 0.1127D-01, 0.1130D-01,
     ,   0.1128D-01, 0.1131D-01, 0.1128D-01, 0.1128D-01, 0.1129D-01,
     ,   0.1129D-01, 0.1131D-01, 0.1131D-01/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.8410D-04,-0.9911D-04,-0.1167D-03,-0.1375D-03,-0.1619D-03,
     ,  -0.1905D-03,-0.2238D-03,-0.2628D-03,-0.3083D-03,-0.3608D-03,
     ,  -0.4226D-03,-0.4935D-03,-0.5775D-03,-0.6734D-03,-0.7810D-03,
     ,  -0.9091D-03,-0.1053D-02,-0.1218D-02,-0.1406D-02,-0.1622D-02,
     ,  -0.1861D-02,-0.2135D-02,-0.2436D-02,-0.2775D-02,-0.3151D-02,
     ,  -0.3563D-02,-0.4011D-02,-0.4500D-02,-0.5021D-02,-0.5572D-02,
     ,  -0.6139D-02,-0.6715D-02,-0.7194D-02,-0.7534D-02,-0.7513D-02,
     ,  -0.7027D-02,-0.6031D-02,-0.4459D-02,-0.2547D-02,-0.5660D-03,
     ,   0.1282D-02, 0.2969D-02, 0.4430D-02, 0.5676D-02, 0.6716D-02,
     ,   0.7569D-02, 0.8270D-02, 0.8854D-02, 0.9308D-02, 0.9651D-02,
     ,   0.9929D-02, 0.1015D-01, 0.1029D-01, 0.1042D-01, 0.1051D-01,
     ,   0.1061D-01, 0.1066D-01, 0.1068D-01, 0.1071D-01, 0.1073D-01,
     ,   0.1075D-01, 0.1076D-01, 0.1077D-01, 0.1077D-01, 0.1078D-01,
     ,   0.1081D-01, 0.1078D-01, 0.1079D-01, 0.1079D-01, 0.1081D-01,
     ,   0.1081D-01, 0.1079D-01, 0.1079D-01/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.7229D-04,-0.8532D-04,-0.1006D-03,-0.1186D-03,-0.1396D-03,
     ,  -0.1641D-03,-0.1929D-03,-0.2264D-03,-0.2659D-03,-0.3116D-03,
     ,  -0.3644D-03,-0.4265D-03,-0.4964D-03,-0.5788D-03,-0.6751D-03,
     ,  -0.7851D-03,-0.9096D-03,-0.1055D-02,-0.1218D-02,-0.1403D-02,
     ,  -0.1613D-02,-0.1853D-02,-0.2123D-02,-0.2420D-02,-0.2747D-02,
     ,  -0.3113D-02,-0.3514D-02,-0.3948D-02,-0.4420D-02,-0.4919D-02,
     ,  -0.5446D-02,-0.5976D-02,-0.6455D-02,-0.6805D-02,-0.6956D-02,
     ,  -0.6663D-02,-0.5807D-02,-0.4482D-02,-0.2805D-02,-0.9536D-03,
     ,   0.8230D-03, 0.2440D-02, 0.3856D-02, 0.5067D-02, 0.6074D-02,
     ,   0.6942D-02, 0.7643D-02, 0.8194D-02, 0.8614D-02, 0.8976D-02,
     ,   0.9238D-02, 0.9474D-02, 0.9620D-02, 0.9765D-02, 0.9841D-02,
     ,   0.9909D-02, 0.9964D-02, 0.1001D-01, 0.1004D-01, 0.1006D-01,
     ,   0.1008D-01, 0.1009D-01, 0.1010D-01, 0.1010D-01, 0.1011D-01,
     ,   0.1011D-01, 0.1011D-01, 0.1012D-01, 0.1012D-01, 0.1011D-01,
     ,   0.1011D-01, 0.1012D-01, 0.1012D-01/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.5790D-04,-0.6851D-04,-0.8072D-04,-0.9525D-04,-0.1122D-03,
     ,  -0.1322D-03,-0.1552D-03,-0.1825D-03,-0.2142D-03,-0.2512D-03,
     ,  -0.2940D-03,-0.3440D-03,-0.4024D-03,-0.4695D-03,-0.5479D-03,
     ,  -0.6352D-03,-0.7382D-03,-0.8549D-03,-0.9905D-03,-0.1144D-02,
     ,  -0.1317D-02,-0.1512D-02,-0.1730D-02,-0.1979D-02,-0.2254D-02,
     ,  -0.2558D-02,-0.2896D-02,-0.3262D-02,-0.3667D-02,-0.4104D-02,
     ,  -0.4580D-02,-0.5057D-02,-0.5544D-02,-0.5984D-02,-0.6180D-02,
     ,  -0.6126D-02,-0.5561D-02,-0.4506D-02,-0.3064D-02,-0.1409D-02,
     ,   0.2572D-03, 0.1785D-02, 0.3134D-02, 0.4299D-02, 0.5297D-02,
     ,   0.6112D-02, 0.6784D-02, 0.7324D-02, 0.7784D-02, 0.8126D-02,
     ,   0.8409D-02, 0.8600D-02, 0.8766D-02, 0.8870D-02, 0.8990D-02,
     ,   0.9042D-02, 0.9093D-02, 0.9152D-02, 0.9166D-02, 0.9187D-02,
     ,   0.9221D-02, 0.9234D-02, 0.9241D-02, 0.9248D-02, 0.9255D-02,
     ,   0.9237D-02, 0.9242D-02, 0.9262D-02, 0.9262D-02, 0.9244D-02,
     ,   0.9244D-02, 0.9244D-02, 0.9244D-02/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.4188D-04,-0.4942D-04,-0.5842D-04,-0.6870D-04,-0.8116D-04,
     ,  -0.9564D-04,-0.1126D-03,-0.1322D-03,-0.1553D-03,-0.1823D-03,
     ,  -0.2139D-03,-0.2505D-03,-0.2931D-03,-0.3425D-03,-0.3985D-03,
     ,  -0.4642D-03,-0.5409D-03,-0.6284D-03,-0.7271D-03,-0.8418D-03,
     ,  -0.9732D-03,-0.1120D-02,-0.1288D-02,-0.1472D-02,-0.1686D-02,
     ,  -0.1919D-02,-0.2181D-02,-0.2473D-02,-0.2793D-02,-0.3150D-02,
     ,  -0.3540D-02,-0.3972D-02,-0.4426D-02,-0.4868D-02,-0.5232D-02,
     ,  -0.5319D-02,-0.5113D-02,-0.4399D-02,-0.3243D-02,-0.1876D-02,
     ,  -0.3873D-03, 0.1015D-02, 0.2277D-02, 0.3381D-02, 0.4328D-02,
     ,   0.5121D-02, 0.5774D-02, 0.6328D-02, 0.6741D-02, 0.7102D-02,
     ,   0.7359D-02, 0.7555D-02, 0.7718D-02, 0.7849D-02, 0.7939D-02,
     ,   0.8014D-02, 0.8050D-02, 0.8083D-02, 0.8140D-02, 0.8161D-02,
     ,   0.8152D-02, 0.8166D-02, 0.8174D-02, 0.8180D-02, 0.8187D-02,
     ,   0.8192D-02, 0.8216D-02, 0.8194D-02, 0.8194D-02, 0.8199D-02,
     ,   0.8199D-02, 0.8199D-02, 0.8199D-02/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.2527D-04,-0.2985D-04,-0.3523D-04,-0.4161D-04,-0.4898D-04,
     ,  -0.5783D-04,-0.6821D-04,-0.8029D-04,-0.9456D-04,-0.1110D-03,
     ,  -0.1305D-03,-0.1529D-03,-0.1794D-03,-0.2096D-03,-0.2452D-03,
     ,  -0.2880D-03,-0.3346D-03,-0.3904D-03,-0.4549D-03,-0.5255D-03,
     ,  -0.6102D-03,-0.7060D-03,-0.8133D-03,-0.9395D-03,-0.1079D-02,
     ,  -0.1240D-02,-0.1421D-02,-0.1621D-02,-0.1855D-02,-0.2119D-02,
     ,  -0.2421D-02,-0.2771D-02,-0.3171D-02,-0.3589D-02,-0.4047D-02,
     ,  -0.4409D-02,-0.4499D-02,-0.4156D-02,-0.3395D-02,-0.2281D-02,
     ,  -0.1051D-02, 0.1902D-03, 0.1338D-02, 0.2361D-02, 0.3246D-02,
     ,   0.4003D-02, 0.4639D-02, 0.5147D-02, 0.5582D-02, 0.5895D-02,
     ,   0.6156D-02, 0.6355D-02, 0.6516D-02, 0.6639D-02, 0.6715D-02,
     ,   0.6787D-02, 0.6861D-02, 0.6883D-02, 0.6910D-02, 0.6931D-02,
     ,   0.6953D-02, 0.6962D-02, 0.6971D-02, 0.6978D-02, 0.6984D-02,
     ,   0.6989D-02, 0.6987D-02, 0.6991D-02, 0.6991D-02, 0.6991D-02,
     ,   0.6995D-02, 0.6995D-02, 0.6995D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.9904D-05,-0.1159D-04,-0.1392D-04,-0.1656D-04,-0.1975D-04,
     ,  -0.2309D-04,-0.2738D-04,-0.3263D-04,-0.3838D-04,-0.4551D-04,
     ,  -0.5380D-04,-0.6340D-04,-0.7449D-04,-0.8852D-04,-0.1043D-03,
     ,  -0.1215D-03,-0.1443D-03,-0.1692D-03,-0.1974D-03,-0.2326D-03,
     ,  -0.2717D-03,-0.3199D-03,-0.3741D-03,-0.4362D-03,-0.5065D-03,
     ,  -0.5945D-03,-0.6929D-03,-0.8113D-03,-0.9482D-03,-0.1116D-02,
     ,  -0.1319D-02,-0.1571D-02,-0.1892D-02,-0.2310D-02,-0.2794D-02,
     ,  -0.3266D-02,-0.3595D-02,-0.3689D-02,-0.3342D-02,-0.2597D-02,
     ,  -0.1630D-02,-0.5930D-03, 0.4096D-03, 0.1325D-02, 0.2137D-02,
     ,   0.2839D-02, 0.3433D-02, 0.3925D-02, 0.4316D-02, 0.4640D-02,
     ,   0.4897D-02, 0.5118D-02, 0.5262D-02, 0.5367D-02, 0.5463D-02,
     ,   0.5534D-02, 0.5563D-02, 0.5625D-02, 0.5636D-02, 0.5659D-02,
     ,   0.5695D-02, 0.5687D-02, 0.5696D-02, 0.5701D-02, 0.5707D-02,
     ,   0.5729D-02, 0.5713D-02, 0.5714D-02, 0.5715D-02, 0.5716D-02,
     ,   0.5736D-02, 0.5737D-02, 0.5737D-02/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.2278D-05, 0.2453D-05, 0.3043D-05, 0.3403D-05, 0.3898D-05,
     ,   0.4409D-05, 0.4997D-05, 0.5650D-05, 0.6269D-05, 0.7160D-05,
     ,   0.7872D-05, 0.8588D-05, 0.9281D-05, 0.1020D-04, 0.1072D-04,
     ,   0.1084D-04, 0.1174D-04, 0.1095D-04, 0.1003D-04, 0.7833D-05,
     ,   0.3106D-05,-0.1573D-06,-0.7123D-05,-0.2003D-04,-0.3681D-04,
     ,  -0.5804D-04,-0.8490D-04,-0.1248D-03,-0.1775D-03,-0.2535D-03,
     ,  -0.3591D-03,-0.5140D-03,-0.7295D-03,-0.1044D-02,-0.1462D-02,
     ,  -0.2002D-02,-0.2561D-02,-0.2926D-02,-0.2980D-02,-0.2658D-02,
     ,  -0.2018D-02,-0.1228D-02,-0.4019D-03, 0.3839D-03, 0.1101D-02,
     ,   0.1732D-02, 0.2281D-02, 0.2744D-02, 0.3125D-02, 0.3430D-02,
     ,   0.3671D-02, 0.3848D-02, 0.4004D-02, 0.4125D-02, 0.4214D-02,
     ,   0.4275D-02, 0.4338D-02, 0.4364D-02, 0.4398D-02, 0.4420D-02,
     ,   0.4421D-02, 0.4449D-02, 0.4461D-02, 0.4464D-02, 0.4463D-02,
     ,   0.4453D-02, 0.4467D-02, 0.4473D-02, 0.4477D-02, 0.4480D-02,
     ,   0.4460D-02, 0.4463D-02, 0.4465D-02/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.1012D-04, 0.1193D-04, 0.1389D-04, 0.1634D-04, 0.1938D-04,
     ,   0.2258D-04, 0.2633D-04, 0.3080D-04, 0.3603D-04, 0.4182D-04,
     ,   0.4884D-04, 0.5633D-04, 0.6528D-04, 0.7586D-04, 0.8746D-04,
     ,   0.1006D-03, 0.1148D-03, 0.1316D-03, 0.1494D-03, 0.1706D-03,
     ,   0.1944D-03, 0.2177D-03, 0.2428D-03, 0.2703D-03, 0.2968D-03,
     ,   0.3267D-03, 0.3470D-03, 0.3676D-03, 0.3804D-03, 0.3809D-03,
     ,   0.3568D-03, 0.3007D-03, 0.1796D-03,-0.2606D-04,-0.3641D-03,
     ,  -0.8467D-03,-0.1441D-02,-0.2027D-02,-0.2403D-02,-0.2447D-02,
     ,  -0.2150D-02,-0.1625D-02,-0.1005D-02,-0.3701D-03, 0.2338D-03,
     ,   0.7880D-03, 0.1277D-02, 0.1696D-02, 0.2047D-02, 0.2337D-02,
     ,   0.2568D-02, 0.2754D-02, 0.2896D-02, 0.3007D-02, 0.3090D-02,
     ,   0.3155D-02, 0.3203D-02, 0.3241D-02, 0.3268D-02, 0.3289D-02,
     ,   0.3306D-02, 0.3312D-02, 0.3320D-02, 0.3330D-02, 0.3335D-02,
     ,   0.3341D-02, 0.3339D-02, 0.3342D-02, 0.3342D-02, 0.3343D-02,
     ,   0.3348D-02, 0.3347D-02, 0.3346D-02/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.1387D-04, 0.1634D-04, 0.1927D-04, 0.2272D-04, 0.2662D-04,
     ,   0.3118D-04, 0.3663D-04, 0.4304D-04, 0.5036D-04, 0.5884D-04,
     ,   0.6860D-04, 0.8034D-04, 0.9328D-04, 0.1086D-03, 0.1258D-03,
     ,   0.1456D-03, 0.1685D-03, 0.1949D-03, 0.2237D-03, 0.2552D-03,
     ,   0.2915D-03, 0.3323D-03, 0.3769D-03, 0.4256D-03, 0.4791D-03,
     ,   0.5310D-03, 0.5939D-03, 0.6501D-03, 0.7079D-03, 0.7561D-03,
     ,   0.7967D-03, 0.8095D-03, 0.7852D-03, 0.6820D-03, 0.4670D-03,
     ,   0.9829D-04,-0.4310D-03,-0.1053D-02,-0.1625D-02,-0.1963D-02,
     ,  -0.1988D-02,-0.1741D-02,-0.1337D-02,-0.8664D-03,-0.3893D-03,
     ,   0.6754D-04, 0.4887D-03, 0.8609D-03, 0.1182D-02, 0.1448D-02,
     ,   0.1667D-02, 0.1838D-02, 0.1976D-02, 0.2082D-02, 0.2163D-02,
     ,   0.2227D-02, 0.2272D-02, 0.2308D-02, 0.2335D-02, 0.2356D-02,
     ,   0.2370D-02, 0.2384D-02, 0.2391D-02, 0.2392D-02, 0.2401D-02,
     ,   0.2404D-02, 0.2407D-02, 0.2408D-02, 0.2408D-02, 0.2411D-02,
     ,   0.2411D-02, 0.2410D-02, 0.2412D-02/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.1445D-04, 0.1704D-04, 0.2010D-04, 0.2364D-04, 0.2776D-04,
     ,   0.3274D-04, 0.3848D-04, 0.4514D-04, 0.5282D-04, 0.6203D-04,
     ,   0.7260D-04, 0.8473D-04, 0.9916D-04, 0.1152D-03, 0.1342D-03,
     ,   0.1557D-03, 0.1807D-03, 0.2088D-03, 0.2409D-03, 0.2779D-03,
     ,   0.3194D-03, 0.3647D-03, 0.4162D-03, 0.4747D-03, 0.5353D-03,
     ,   0.6038D-03, 0.6761D-03, 0.7537D-03, 0.8305D-03, 0.9112D-03,
     ,   0.9847D-03, 0.1048D-02, 0.1082D-02, 0.1065D-02, 0.9654D-03,
     ,   0.7373D-03, 0.3421D-03,-0.2076D-03,-0.8189D-03,-0.1326D-02,
     ,  -0.1603D-02,-0.1607D-02,-0.1409D-02,-0.1106D-02,-0.7630D-03,
     ,  -0.4089D-03,-0.6427D-04, 0.2548D-03, 0.5339D-03, 0.7764D-03,
     ,   0.9750D-03, 0.1140D-02, 0.1266D-02, 0.1367D-02, 0.1444D-02,
     ,   0.1503D-02, 0.1551D-02, 0.1585D-02, 0.1613D-02, 0.1630D-02,
     ,   0.1647D-02, 0.1654D-02, 0.1665D-02, 0.1672D-02, 0.1674D-02,
     ,   0.1677D-02, 0.1680D-02, 0.1679D-02, 0.1683D-02, 0.1683D-02,
     ,   0.1682D-02, 0.1685D-02, 0.1685D-02/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1309D-04, 0.1546D-04, 0.1822D-04, 0.2147D-04, 0.2536D-04,
     ,   0.2983D-04, 0.3510D-04, 0.4121D-04, 0.4855D-04, 0.5665D-04,
     ,   0.6647D-04, 0.7782D-04, 0.9082D-04, 0.1060D-03, 0.1235D-03,
     ,   0.1440D-03, 0.1670D-03, 0.1937D-03, 0.2243D-03, 0.2591D-03,
     ,   0.2982D-03, 0.3436D-03, 0.3930D-03, 0.4468D-03, 0.5100D-03,
     ,   0.5811D-03, 0.6527D-03, 0.7323D-03, 0.8155D-03, 0.9074D-03,
     ,   0.9938D-03, 0.1077D-02, 0.1145D-02, 0.1187D-02, 0.1170D-02,
     ,   0.1055D-02, 0.8134D-03, 0.4039D-03,-0.1224D-03,-0.6665D-03,
     ,  -0.1083D-02,-0.1281D-02,-0.1274D-02,-0.1128D-02,-0.9078D-03,
     ,  -0.6582D-03,-0.3988D-03,-0.1431D-03, 0.9293D-04, 0.3030D-03,
     ,   0.4824D-03, 0.6281D-03, 0.7487D-03, 0.8433D-03, 0.9186D-03,
     ,   0.9764D-03, 0.1020D-02, 0.1054D-02, 0.1078D-02, 0.1097D-02,
     ,   0.1110D-02, 0.1123D-02, 0.1127D-02, 0.1136D-02, 0.1139D-02,
     ,   0.1143D-02, 0.1145D-02, 0.1147D-02, 0.1148D-02, 0.1147D-02,
     ,   0.1150D-02, 0.1150D-02, 0.1149D-02/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.1086D-04, 0.1283D-04, 0.1517D-04, 0.1791D-04, 0.2108D-04,
     ,   0.2484D-04, 0.2926D-04, 0.3443D-04, 0.4035D-04, 0.4758D-04,
     ,   0.5569D-04, 0.6528D-04, 0.7642D-04, 0.8935D-04, 0.1042D-03,
     ,   0.1216D-03, 0.1413D-03, 0.1643D-03, 0.1904D-03, 0.2203D-03,
     ,   0.2545D-03, 0.2932D-03, 0.3372D-03, 0.3874D-03, 0.4421D-03,
     ,   0.5020D-03, 0.5689D-03, 0.6420D-03, 0.7277D-03, 0.8050D-03,
     ,   0.8952D-03, 0.9856D-03, 0.1071D-02, 0.1139D-02, 0.1173D-02,
     ,   0.1149D-02, 0.1023D-02, 0.7701D-03, 0.3789D-03,-0.9820D-04,
     ,  -0.5490D-03,-0.8685D-03,-0.1002D-02,-0.9859D-03,-0.8802D-03,
     ,  -0.7278D-03,-0.5494D-03,-0.3624D-03,-0.1722D-03, 0.1851D-05,
     ,   0.1597D-03, 0.2933D-03, 0.4008D-03, 0.4876D-03, 0.5570D-03,
     ,   0.6110D-03, 0.6516D-03, 0.6850D-03, 0.7087D-03, 0.7267D-03,
     ,   0.7400D-03, 0.7510D-03, 0.7596D-03, 0.7631D-03, 0.7677D-03,
     ,   0.7715D-03, 0.7736D-03, 0.7750D-03, 0.7764D-03, 0.7776D-03,
     ,   0.7778D-03, 0.7785D-03, 0.7790D-03/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.8545D-05, 0.1011D-04, 0.1193D-04, 0.1408D-04, 0.1663D-04,
     ,   0.1960D-04, 0.2308D-04, 0.2718D-04, 0.3200D-04, 0.3757D-04,
     ,   0.4413D-04, 0.5169D-04, 0.6070D-04, 0.7089D-04, 0.8296D-04,
     ,   0.9672D-04, 0.1130D-03, 0.1313D-03, 0.1528D-03, 0.1770D-03,
     ,   0.2049D-03, 0.2367D-03, 0.2726D-03, 0.3131D-03, 0.3593D-03,
     ,   0.4095D-03, 0.4681D-03, 0.5329D-03, 0.5961D-03, 0.6736D-03,
     ,   0.7543D-03, 0.8359D-03, 0.9202D-03, 0.9974D-03, 0.1060D-02,
     ,   0.1083D-02, 0.1040D-02, 0.9057D-03, 0.6547D-03, 0.3004D-03,
     ,  -0.9944D-04,-0.4548D-03,-0.6838D-03,-0.7703D-03,-0.7534D-03,
     ,  -0.6770D-03,-0.5732D-03,-0.4484D-03,-0.3110D-03,-0.1728D-03,
     ,  -0.4464D-04, 0.6987D-04, 0.1676D-03, 0.2481D-03, 0.3108D-03,
     ,   0.3606D-03, 0.4024D-03, 0.4292D-03, 0.4531D-03, 0.4705D-03,
     ,   0.4838D-03, 0.4941D-03, 0.5003D-03, 0.5062D-03, 0.5109D-03,
     ,   0.5140D-03, 0.5162D-03, 0.5181D-03, 0.5191D-03, 0.5203D-03,
     ,   0.5205D-03, 0.5212D-03, 0.5217D-03/
      data (calcpts(j,30), j = 1,neta) /
     ,   0.6445D-05, 0.7639D-05, 0.9032D-05, 0.1068D-04, 0.1261D-04,
     ,   0.1487D-04, 0.1755D-04, 0.2063D-04, 0.2431D-04, 0.2862D-04,
     ,   0.3361D-04, 0.3946D-04, 0.4619D-04, 0.5427D-04, 0.6342D-04,
     ,   0.7415D-04, 0.8642D-04, 0.1009D-03, 0.1172D-03, 0.1363D-03,
     ,   0.1582D-03, 0.1830D-03, 0.2114D-03, 0.2437D-03, 0.2799D-03,
     ,   0.3212D-03, 0.3668D-03, 0.4171D-03, 0.4751D-03, 0.5394D-03,
     ,   0.6037D-03, 0.6765D-03, 0.7486D-03, 0.8262D-03, 0.8931D-03,
     ,   0.9386D-03, 0.9469D-03, 0.8946D-03, 0.7575D-03, 0.5239D-03,
     ,   0.2144D-03,-0.1066D-03,-0.3703D-03,-0.5281D-03,-0.5795D-03,
     ,  -0.5657D-03,-0.5161D-03,-0.4441D-03,-0.3565D-03,-0.2579D-03,
     ,  -0.1578D-03,-0.6251D-04, 0.2141D-04, 0.9156D-04, 0.1502D-03,
     ,   0.1964D-03, 0.2313D-03, 0.2632D-03, 0.2820D-03, 0.2991D-03,
     ,   0.3131D-03, 0.3195D-03, 0.3298D-03, 0.3333D-03, 0.3377D-03,
     ,   0.3387D-03, 0.3409D-03, 0.3446D-03, 0.3438D-03, 0.3467D-03,
     ,   0.3454D-03, 0.3457D-03, 0.3481D-03/
      data (calcpts(j,31), j = 1,neta) /
     ,   0.4765D-05, 0.5623D-05, 0.6654D-05, 0.7860D-05, 0.9285D-05,
     ,   0.1097D-04, 0.1294D-04, 0.1529D-04, 0.1799D-04, 0.2115D-04,
     ,   0.2489D-04, 0.2928D-04, 0.3439D-04, 0.4030D-04, 0.4723D-04,
     ,   0.5518D-04, 0.6471D-04, 0.7540D-04, 0.8787D-04, 0.1023D-03,
     ,   0.1186D-03, 0.1377D-03, 0.1594D-03, 0.1842D-03, 0.2125D-03,
     ,   0.2440D-03, 0.2800D-03, 0.3202D-03, 0.3646D-03, 0.4132D-03,
     ,   0.4698D-03, 0.5281D-03, 0.5924D-03, 0.6588D-03, 0.7186D-03,
     ,   0.7750D-03, 0.8128D-03, 0.8054D-03, 0.7422D-03, 0.6036D-03,
     ,   0.3953D-03, 0.1416D-03,-0.1089D-03,-0.2957D-03,-0.3997D-03,
     ,  -0.4312D-03,-0.4188D-03,-0.3856D-03,-0.3381D-03,-0.2764D-03,
     ,  -0.2052D-03,-0.1333D-03,-0.6453D-04,-0.3122D-05, 0.4904D-04,
     ,   0.9159D-04, 0.1245D-03, 0.1495D-03, 0.1720D-03, 0.1880D-03,
     ,   0.1974D-03, 0.2081D-03, 0.2132D-03, 0.2190D-03, 0.2231D-03,
     ,   0.2266D-03, 0.2287D-03, 0.2280D-03, 0.2316D-03, 0.2301D-03,
     ,   0.2330D-03, 0.2315D-03, 0.2315D-03/
      data (calcpts(j,32), j = 1,neta) /
     ,   0.3439D-05, 0.4072D-05, 0.4817D-05, 0.5702D-05, 0.6755D-05,
     ,   0.7972D-05, 0.9407D-05, 0.1110D-04, 0.1308D-04, 0.1543D-04,
     ,   0.1816D-04, 0.2134D-04, 0.2507D-04, 0.2943D-04, 0.3451D-04,
     ,   0.4047D-04, 0.4725D-04, 0.5531D-04, 0.6448D-04, 0.7530D-04,
     ,   0.8764D-04, 0.1017D-03, 0.1181D-03, 0.1367D-03, 0.1574D-03,
     ,   0.1819D-03, 0.2090D-03, 0.2396D-03, 0.2743D-03, 0.3131D-03,
     ,   0.3558D-03, 0.4043D-03, 0.4563D-03, 0.5083D-03, 0.5679D-03,
     ,   0.6199D-03, 0.6584D-03, 0.6788D-03, 0.6596D-03, 0.5910D-03,
     ,   0.4667D-03, 0.2856D-03, 0.8435D-04,-0.1028D-03,-0.2353D-03,
     ,  -0.2988D-03,-0.3144D-03,-0.3062D-03,-0.2852D-03,-0.2534D-03,
     ,  -0.2107D-03,-0.1599D-03,-0.1069D-03,-0.5730D-04,-0.1381D-04,
     ,   0.2312D-04, 0.5362D-04, 0.7791D-04, 0.9635D-04, 0.1105D-03,
     ,   0.1228D-03, 0.1313D-03, 0.1377D-03, 0.1431D-03, 0.1456D-03,
     ,   0.1485D-03, 0.1504D-03, 0.1526D-03, 0.1528D-03, 0.1543D-03,
     ,   0.1540D-03, 0.1560D-03, 0.1554D-03/
      data (calcpts(j,33), j = 1,neta) /
     ,   0.2457D-05, 0.2913D-05, 0.3450D-05, 0.4083D-05, 0.4818D-05,
     ,   0.5704D-05, 0.6743D-05, 0.7953D-05, 0.9384D-05, 0.1106D-04,
     ,   0.1302D-04, 0.1535D-04, 0.1804D-04, 0.2119D-04, 0.2490D-04,
     ,   0.2919D-04, 0.3421D-04, 0.4001D-04, 0.4681D-04, 0.5448D-04,
     ,   0.6364D-04, 0.7404D-04, 0.8590D-04, 0.9968D-04, 0.1152D-03,
     ,   0.1333D-03, 0.1536D-03, 0.1769D-03, 0.2029D-03, 0.2322D-03,
     ,   0.2653D-03, 0.3020D-03, 0.3424D-03, 0.3869D-03, 0.4333D-03,
     ,   0.4784D-03, 0.5186D-03, 0.5474D-03, 0.5536D-03, 0.5291D-03,
     ,   0.4580D-03, 0.3500D-03, 0.2001D-03, 0.4297D-04,-0.9158D-04,
     ,  -0.1812D-03,-0.2215D-03,-0.2290D-03,-0.2227D-03,-0.2102D-03,
     ,  -0.1894D-03,-0.1594D-03,-0.1236D-03,-0.8530D-04,-0.4903D-04,
     ,  -0.1752D-04, 0.9511D-05, 0.3120D-04, 0.4830D-04, 0.6225D-04,
     ,   0.7277D-04, 0.8053D-04, 0.8641D-04, 0.9070D-04, 0.9483D-04,
     ,   0.9706D-04, 0.9899D-04, 0.1005D-03, 0.1013D-03, 0.1023D-03,
     ,   0.1030D-03, 0.1031D-03, 0.1035D-03/
      data (calcpts(j,34), j = 1,neta) /
     ,   0.1739D-05, 0.2061D-05, 0.2440D-05, 0.2889D-05, 0.3422D-05,
     ,   0.4048D-05, 0.4786D-05, 0.5656D-05, 0.6687D-05, 0.7872D-05,
     ,   0.9290D-05, 0.1093D-04, 0.1286D-04, 0.1514D-04, 0.1779D-04,
     ,   0.2087D-04, 0.2450D-04, 0.2870D-04, 0.3355D-04, 0.3924D-04,
     ,   0.4577D-04, 0.5335D-04, 0.6211D-04, 0.7205D-04, 0.8385D-04,
     ,   0.9679D-04, 0.1120D-03, 0.1292D-03, 0.1489D-03, 0.1707D-03,
     ,   0.1956D-03, 0.2238D-03, 0.2551D-03, 0.2899D-03, 0.3272D-03,
     ,   0.3654D-03, 0.4029D-03, 0.4317D-03, 0.4486D-03, 0.4445D-03,
     ,   0.4147D-03, 0.3484D-03, 0.2566D-03, 0.1385D-03, 0.1955D-04,
     ,  -0.7801D-04,-0.1376D-03,-0.1609D-03,-0.1643D-03,-0.1599D-03,
     ,  -0.1523D-03,-0.1386D-03,-0.1180D-03,-0.9233D-04,-0.6480D-04,
     ,  -0.3874D-04,-0.1592D-04, 0.3035D-05, 0.1891D-04, 0.3106D-04,
     ,   0.4172D-04, 0.4824D-04, 0.5406D-04, 0.5856D-04, 0.6143D-04,
     ,   0.6413D-04, 0.6600D-04, 0.6723D-04, 0.6828D-04, 0.6877D-04,
     ,   0.6935D-04, 0.6981D-04, 0.7018D-04/
      data (calcpts(j,35), j = 1,neta) /
     ,   0.1225D-05, 0.1451D-05, 0.1723D-05, 0.2041D-05, 0.2412D-05,
     ,   0.2854D-05, 0.3375D-05, 0.3994D-05, 0.4707D-05, 0.5576D-05,
     ,   0.6565D-05, 0.7757D-05, 0.9117D-05, 0.1075D-04, 0.1262D-04,
     ,   0.1483D-04, 0.1741D-04, 0.2042D-04, 0.2393D-04, 0.2800D-04,
     ,   0.3273D-04, 0.3816D-04, 0.4447D-04, 0.5178D-04, 0.6014D-04,
     ,   0.6993D-04, 0.8067D-04, 0.9342D-04, 0.1076D-03, 0.1244D-03,
     ,   0.1429D-03, 0.1640D-03, 0.1880D-03, 0.2144D-03, 0.2435D-03,
     ,   0.2740D-03, 0.3047D-03, 0.3321D-03, 0.3520D-03, 0.3595D-03,
     ,   0.3491D-03, 0.3179D-03, 0.2609D-03, 0.1836D-03, 0.9238D-04,
     ,   0.4088D-05,-0.6477D-04,-0.1038D-03,-0.1172D-03,-0.1178D-03,
     ,  -0.1149D-03,-0.1105D-03,-0.1014D-03,-0.8713D-04,-0.6898D-04,
     ,  -0.4927D-04,-0.3073D-04,-0.1420D-04,-0.4767D-06, 0.1070D-04,
     ,   0.1852D-04, 0.2639D-04, 0.3174D-04, 0.3568D-04, 0.3877D-04,
     ,   0.4096D-04, 0.4279D-04, 0.4406D-04, 0.4510D-04, 0.4596D-04,
     ,   0.4631D-04, 0.4671D-04, 0.4698D-04/
      data (calcpts(j,36), j = 1,neta) /
     ,   0.8574D-06, 0.1018D-05, 0.1207D-05, 0.1430D-05, 0.1697D-05,
     ,   0.2010D-05, 0.2377D-05, 0.2811D-05, 0.3322D-05, 0.3920D-05,
     ,   0.4636D-05, 0.5459D-05, 0.6448D-05, 0.7588D-05, 0.8948D-05,
     ,   0.1051D-04, 0.1234D-04, 0.1450D-04, 0.1698D-04, 0.1988D-04,
     ,   0.2328D-04, 0.2722D-04, 0.3175D-04, 0.3699D-04, 0.4314D-04,
     ,   0.5009D-04, 0.5813D-04, 0.6724D-04, 0.7796D-04, 0.8979D-04,
     ,   0.1038D-03, 0.1193D-03, 0.1371D-03, 0.1574D-03, 0.1796D-03,
     ,   0.2036D-03, 0.2279D-03, 0.2510D-03, 0.2701D-03, 0.2820D-03,
     ,   0.2832D-03, 0.2696D-03, 0.2396D-03, 0.1920D-03, 0.1299D-03,
     ,   0.6069D-04,-0.3964D-05,-0.5186D-04,-0.7737D-04,-0.8458D-04,
     ,  -0.8410D-04,-0.8215D-04,-0.7949D-04,-0.7400D-04,-0.6402D-04,
     ,  -0.5100D-04,-0.3700D-04,-0.2369D-04,-0.1209D-04,-0.2249D-05,
     ,   0.5903D-05, 0.1191D-04, 0.1692D-04, 0.2063D-04, 0.2365D-04,
     ,   0.2585D-04, 0.2752D-04, 0.2873D-04, 0.2954D-04, 0.3032D-04,
     ,   0.3087D-04, 0.3108D-04, 0.3138D-04/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.6004D-06, 0.7117D-06, 0.8447D-06, 0.1001D-05, 0.1188D-05,
     ,   0.1403D-05, 0.1665D-05, 0.1970D-05, 0.2332D-05, 0.2755D-05,
     ,   0.3251D-05, 0.3840D-05, 0.4531D-05, 0.5338D-05, 0.6280D-05,
     ,   0.7400D-05, 0.8709D-05, 0.1022D-04, 0.1203D-04, 0.1407D-04,
     ,   0.1649D-04, 0.1929D-04, 0.2254D-04, 0.2633D-04, 0.3064D-04,
     ,   0.3568D-04, 0.4148D-04, 0.4819D-04, 0.5589D-04, 0.6477D-04,
     ,   0.7495D-04, 0.8671D-04, 0.9990D-04, 0.1147D-03, 0.1316D-03,
     ,   0.1500D-03, 0.1691D-03, 0.1880D-03, 0.2046D-03, 0.2170D-03,
     ,   0.2228D-03, 0.2196D-03, 0.2051D-03, 0.1787D-03, 0.1399D-03,
     ,   0.9127D-04, 0.3928D-04,-0.7813D-05,-0.4069D-04,-0.5705D-04,
     ,  -0.6064D-04,-0.5980D-04,-0.5865D-04,-0.5701D-04,-0.5342D-04,
     ,  -0.4661D-04,-0.3730D-04,-0.2747D-04,-0.1769D-04,-0.9498D-05,
     ,  -0.2492D-05, 0.3375D-05, 0.7686D-05, 0.1117D-04, 0.1378D-04,
     ,   0.1599D-04, 0.1742D-04, 0.1855D-04, 0.1955D-04, 0.2014D-04,
     ,   0.2041D-04, 0.2103D-04, 0.2132D-04/
      data (calcpts(j,38), j = 1,neta) /
     ,   0.4181D-06, 0.4973D-06, 0.5886D-06, 0.6985D-06, 0.8283D-06,
     ,   0.9825D-06, 0.1164D-05, 0.1376D-05, 0.1629D-05, 0.1929D-05,
     ,   0.2280D-05, 0.2692D-05, 0.3180D-05, 0.3749D-05, 0.4423D-05,
     ,   0.5211D-05, 0.6117D-05, 0.7196D-05, 0.8440D-05, 0.9935D-05,
     ,   0.1165D-04, 0.1365D-04, 0.1598D-04, 0.1865D-04, 0.2179D-04,
     ,   0.2542D-04, 0.2959D-04, 0.3438D-04, 0.3994D-04, 0.4636D-04,
     ,   0.5362D-04, 0.6210D-04, 0.7187D-04, 0.8320D-04, 0.9579D-04,
     ,   0.1096D-03, 0.1244D-03, 0.1392D-03, 0.1528D-03, 0.1641D-03,
     ,   0.1713D-03, 0.1730D-03, 0.1678D-03, 0.1543D-03, 0.1320D-03,
     ,   0.1008D-03, 0.6378D-04, 0.2501D-04,-0.8768D-05,-0.3175D-04,
     ,  -0.4193D-04,-0.4321D-04,-0.4232D-04,-0.4169D-04,-0.4094D-04,
     ,  -0.3848D-04,-0.3379D-04,-0.2713D-04,-0.2024D-04,-0.1321D-04,
     ,  -0.7359D-05,-0.2419D-05, 0.1527D-05, 0.4938D-05, 0.7351D-05,
     ,   0.9010D-05, 0.1060D-04, 0.1166D-04, 0.1240D-04, 0.1318D-04,
     ,   0.1367D-04, 0.1378D-04, 0.1408D-04/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.2914D-06, 0.3455D-06, 0.4109D-06, 0.4879D-06, 0.5781D-06,
     ,   0.6860D-06, 0.8126D-06, 0.9643D-06, 0.1140D-05, 0.1347D-05,
     ,   0.1597D-05, 0.1885D-05, 0.2225D-05, 0.2629D-05, 0.3101D-05,
     ,   0.3652D-05, 0.4304D-05, 0.5073D-05, 0.5962D-05, 0.7019D-05,
     ,   0.8206D-05, 0.9611D-05, 0.1128D-04, 0.1322D-04, 0.1542D-04,
     ,   0.1801D-04, 0.2101D-04, 0.2450D-04, 0.2845D-04, 0.3311D-04,
     ,   0.3848D-04, 0.4462D-04, 0.5176D-04, 0.5994D-04, 0.6924D-04,
     ,   0.7984D-04, 0.9093D-04, 0.1024D-03, 0.1133D-03, 0.1229D-03,
     ,   0.1303D-03, 0.1338D-03, 0.1329D-03, 0.1266D-03, 0.1145D-03,
     ,   0.9637D-04, 0.7212D-04, 0.4407D-04, 0.1548D-04,-0.8588D-05,
     ,  -0.2418D-04,-0.3072D-04,-0.3098D-04,-0.2994D-04,-0.2957D-04,
     ,  -0.2932D-04,-0.2777D-04,-0.2448D-04,-0.1982D-04,-0.1492D-04,
     ,  -0.1002D-04,-0.5831D-05,-0.2169D-05, 0.4894D-06, 0.2813D-05,
     ,   0.4668D-05, 0.5958D-05, 0.6996D-05, 0.7898D-05, 0.8142D-05,
     ,   0.8845D-05, 0.9050D-05, 0.9317D-05/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.2023D-06, 0.2407D-06, 0.2855D-06, 0.3390D-06, 0.4024D-06,
     ,   0.4782D-06, 0.5656D-06, 0.6699D-06, 0.7946D-06, 0.9406D-06,
     ,   0.1111D-05, 0.1319D-05, 0.1556D-05, 0.1839D-05, 0.2171D-05,
     ,   0.2561D-05, 0.3019D-05, 0.3554D-05, 0.4185D-05, 0.4909D-05,
     ,   0.5787D-05, 0.6799D-05, 0.7954D-05, 0.9311D-05, 0.1093D-04,
     ,   0.1275D-04, 0.1489D-04, 0.1736D-04, 0.2027D-04, 0.2360D-04,
     ,   0.2747D-04, 0.3200D-04, 0.3720D-04, 0.4323D-04, 0.5005D-04,
     ,   0.5778D-04, 0.6616D-04, 0.7474D-04, 0.8338D-04, 0.9116D-04,
     ,   0.9723D-04, 0.1014D-03, 0.1028D-03, 0.1007D-03, 0.9502D-04,
     ,   0.8480D-04, 0.7003D-04, 0.5147D-04, 0.3053D-04, 0.9847D-05,
     ,  -0.7456D-05,-0.1814D-04,-0.2212D-04,-0.2191D-04,-0.2100D-04,
     ,  -0.2081D-04,-0.2078D-04,-0.1979D-04,-0.1749D-04,-0.1421D-04,
     ,  -0.1067D-04,-0.7240D-05,-0.4260D-05,-0.1712D-05, 0.2831D-06,
     ,   0.1854D-05, 0.3077D-05, 0.4047D-05, 0.4666D-05, 0.5440D-05,
     ,   0.5643D-05, 0.6140D-05, 0.6264D-05/
      data (calcpts(j,41), j = 1,neta) /
     ,   0.1406D-06, 0.1671D-06, 0.1988D-06, 0.2359D-06, 0.2801D-06,
     ,   0.3322D-06, 0.3945D-06, 0.4679D-06, 0.5537D-06, 0.6575D-06,
     ,   0.7778D-06, 0.9172D-06, 0.1089D-05, 0.1284D-05, 0.1519D-05,
     ,   0.1794D-05, 0.2115D-05, 0.2492D-05, 0.2933D-05, 0.3454D-05,
     ,   0.4061D-05, 0.4774D-05, 0.5609D-05, 0.6580D-05, 0.7670D-05,
     ,   0.9015D-05, 0.1052D-04, 0.1234D-04, 0.1437D-04, 0.1675D-04,
     ,   0.1958D-04, 0.2279D-04, 0.2659D-04, 0.3095D-04, 0.3594D-04,
     ,   0.4154D-04, 0.4757D-04, 0.5437D-04, 0.6082D-04, 0.6688D-04,
     ,   0.7199D-04, 0.7607D-04, 0.7833D-04, 0.7818D-04, 0.7547D-04,
     ,   0.7021D-04, 0.6208D-04, 0.5048D-04, 0.3677D-04, 0.2109D-04,
     ,   0.5918D-05,-0.6295D-05,-0.1357D-04,-0.1602D-04,-0.1559D-04,
     ,  -0.1481D-04,-0.1471D-04,-0.1478D-04,-0.1415D-04,-0.1257D-04,
     ,  -0.1024D-04,-0.7739D-05,-0.5335D-05,-0.3199D-05,-0.1423D-05,
     ,   0.1590D-07, 0.1143D-05, 0.2009D-05, 0.2701D-05, 0.3170D-05,
     ,   0.3589D-05, 0.3824D-05, 0.4080D-05/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.9760D-07, 0.1162D-06, 0.1380D-06, 0.1640D-06, 0.1949D-06,
     ,   0.2315D-06, 0.2745D-06, 0.3254D-06, 0.3863D-06, 0.4568D-06,
     ,   0.5421D-06, 0.6431D-06, 0.7592D-06, 0.8971D-06, 0.1060D-05,
     ,   0.1254D-05, 0.1479D-05, 0.1746D-05, 0.2057D-05, 0.2424D-05,
     ,   0.2851D-05, 0.3352D-05, 0.3940D-05, 0.4618D-05, 0.5430D-05,
     ,   0.6356D-05, 0.7459D-05, 0.8695D-05, 0.1020D-04, 0.1191D-04,
     ,   0.1390D-04, 0.1623D-04, 0.1896D-04, 0.2210D-04, 0.2576D-04,
     ,   0.2992D-04, 0.3449D-04, 0.3926D-04, 0.4437D-04, 0.4897D-04,
     ,   0.5314D-04, 0.5629D-04, 0.5834D-04, 0.5961D-04, 0.5868D-04,
     ,   0.5614D-04, 0.5164D-04, 0.4514D-04, 0.3614D-04, 0.2575D-04,
     ,   0.1442D-04, 0.3484D-05,-0.5159D-05,-0.1010D-04,-0.1154D-04,
     ,  -0.1105D-04,-0.1044D-04,-0.1041D-04,-0.1051D-04,-0.1010D-04,
     ,  -0.9042D-05,-0.7408D-05,-0.5597D-05,-0.3873D-05,-0.2383D-05,
     ,  -0.1142D-05,-0.1343D-06, 0.6677D-06, 0.1266D-05, 0.1752D-05,
     ,   0.2111D-05, 0.2376D-05, 0.2586D-05/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.6786D-07, 0.8052D-07, 0.9593D-07, 0.1141D-06, 0.1356D-06,
     ,   0.1606D-06, 0.1908D-06, 0.2266D-06, 0.2686D-06, 0.3186D-06,
     ,   0.3776D-06, 0.4464D-06, 0.5288D-06, 0.6277D-06, 0.7407D-06,
     ,   0.8743D-06, 0.1034D-05, 0.1219D-05, 0.1441D-05, 0.1696D-05,
     ,   0.1996D-05, 0.2353D-05, 0.2767D-05, 0.3252D-05, 0.3815D-05,
     ,   0.4473D-05, 0.5258D-05, 0.6132D-05, 0.7222D-05, 0.8436D-05,
     ,   0.9853D-05, 0.1156D-04, 0.1347D-04, 0.1579D-04, 0.1844D-04,
     ,   0.2141D-04, 0.2478D-04, 0.2835D-04, 0.3199D-04, 0.3554D-04,
     ,   0.3879D-04, 0.4158D-04, 0.4360D-04, 0.4460D-04, 0.4486D-04,
     ,   0.4382D-04, 0.4152D-04, 0.3792D-04, 0.3269D-04, 0.2605D-04,
     ,   0.1822D-04, 0.9892D-05, 0.2059D-05,-0.4019D-05,-0.7433D-05,
     ,  -0.8279D-05,-0.7805D-05,-0.7303D-05,-0.7307D-05,-0.7445D-05,
     ,  -0.7150D-05,-0.6403D-05,-0.5290D-05,-0.4022D-05,-0.2799D-05,
     ,  -0.1742D-05,-0.8631D-06,-0.1482D-06, 0.4254D-06, 0.8220D-06,
     ,   0.1165D-05, 0.1427D-05, 0.1593D-05/
      data (calcpts(j,44), j = 1,neta) /
     ,   0.4698D-07, 0.5602D-07, 0.6648D-07, 0.7897D-07, 0.9378D-07,
     ,   0.1116D-06, 0.1326D-06, 0.1575D-06, 0.1868D-06, 0.2218D-06,
     ,   0.2627D-06, 0.3116D-06, 0.3691D-06, 0.4363D-06, 0.5176D-06,
     ,   0.6109D-06, 0.7222D-06, 0.8537D-06, 0.1008D-05, 0.1189D-05,
     ,   0.1401D-05, 0.1648D-05, 0.1941D-05, 0.2285D-05, 0.2684D-05,
     ,   0.3151D-05, 0.3695D-05, 0.4347D-05, 0.5064D-05, 0.5952D-05,
     ,   0.6962D-05, 0.8172D-05, 0.9601D-05, 0.1121D-04, 0.1312D-04,
     ,   0.1531D-04, 0.1773D-04, 0.2038D-04, 0.2305D-04, 0.2573D-04,
     ,   0.2822D-04, 0.3034D-04, 0.3204D-04, 0.3319D-04, 0.3369D-04,
     ,   0.3344D-04, 0.3241D-04, 0.3043D-04, 0.2751D-04, 0.2357D-04,
     ,   0.1859D-04, 0.1285D-04, 0.6760D-05, 0.1129D-05,-0.3141D-05,
     ,  -0.5441D-05,-0.5917D-05,-0.5504D-05,-0.5130D-05,-0.5123D-05,
     ,  -0.5260D-05,-0.5100D-05,-0.4556D-05,-0.3772D-05,-0.2893D-05,
     ,  -0.2012D-05,-0.1278D-05,-0.6607D-06,-0.1515D-06, 0.2337D-06,
     ,   0.5503D-06, 0.7692D-06, 0.9681D-06/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.3260D-07, 0.3877D-07, 0.4618D-07, 0.5500D-07, 0.6518D-07,
     ,   0.7774D-07, 0.9227D-07, 0.1096D-06, 0.1300D-06, 0.1541D-06,
     ,   0.1830D-06, 0.2168D-06, 0.2568D-06, 0.3045D-06, 0.3602D-06,
     ,   0.4265D-06, 0.5043D-06, 0.5958D-06, 0.7034D-06, 0.8287D-06,
     ,   0.9810D-06, 0.1156D-05, 0.1359D-05, 0.1599D-05, 0.1885D-05,
     ,   0.2215D-05, 0.2599D-05, 0.3052D-05, 0.3584D-05, 0.4206D-05,
     ,   0.4946D-05, 0.5783D-05, 0.6797D-05, 0.7989D-05, 0.9354D-05,
     ,   0.1092D-04, 0.1268D-04, 0.1456D-04, 0.1657D-04, 0.1854D-04,
     ,   0.2041D-04, 0.2207D-04, 0.2345D-04, 0.2448D-04, 0.2507D-04,
     ,   0.2521D-04, 0.2479D-04, 0.2380D-04, 0.2223D-04, 0.1990D-04,
     ,   0.1693D-04, 0.1323D-04, 0.9035D-05, 0.4620D-05, 0.5922D-06,
     ,  -0.2420D-05,-0.3973D-05,-0.4252D-05,-0.3902D-05,-0.3623D-05,
     ,  -0.3633D-05,-0.3720D-05,-0.3629D-05,-0.3264D-05,-0.2696D-05,
     ,  -0.2084D-05,-0.1472D-05,-0.9453D-06,-0.5004D-06,-0.1436D-06,
     ,   0.1291D-06, 0.3367D-06, 0.4935D-06/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.2259D-07, 0.2687D-07, 0.3196D-07, 0.3804D-07, 0.4538D-07,
     ,   0.5371D-07, 0.6405D-07, 0.7598D-07, 0.9038D-07, 0.1072D-06,
     ,   0.1271D-06, 0.1509D-06, 0.1792D-06, 0.2120D-06, 0.2510D-06,
     ,   0.2971D-06, 0.3514D-06, 0.4159D-06, 0.4912D-06, 0.5817D-06,
     ,   0.6834D-06, 0.8084D-06, 0.9529D-06, 0.1123D-05, 0.1318D-05,
     ,   0.1555D-05, 0.1829D-05, 0.2150D-05, 0.2525D-05, 0.2967D-05,
     ,   0.3484D-05, 0.4099D-05, 0.4812D-05, 0.5659D-05, 0.6628D-05,
     ,   0.7779D-05, 0.9048D-05, 0.1043D-04, 0.1190D-04, 0.1336D-04,
     ,   0.1471D-04, 0.1602D-04, 0.1709D-04, 0.1792D-04, 0.1850D-04,
     ,   0.1875D-04, 0.1873D-04, 0.1827D-04, 0.1741D-04, 0.1615D-04,
     ,   0.1440D-04, 0.1215D-04, 0.9401D-05, 0.6352D-05, 0.3182D-05,
     ,   0.3173D-06,-0.1807D-05,-0.2871D-05,-0.3000D-05,-0.2723D-05,
     ,  -0.2515D-05,-0.2531D-05,-0.2609D-05,-0.2549D-05,-0.2297D-05,
     ,  -0.1904D-05,-0.1460D-05,-0.1034D-05,-0.6788D-06,-0.3619D-06,
     ,  -0.1204D-06, 0.8933D-07, 0.2379D-06/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.1564D-07, 0.1863D-07, 0.2219D-07, 0.2640D-07, 0.3138D-07,
     ,   0.3736D-07, 0.4430D-07, 0.5271D-07, 0.6271D-07, 0.7455D-07,
     ,   0.8860D-07, 0.1050D-06, 0.1243D-06, 0.1475D-06, 0.1749D-06,
     ,   0.2073D-06, 0.2453D-06, 0.2900D-06, 0.3431D-06, 0.4052D-06,
     ,   0.4800D-06, 0.5643D-06, 0.6676D-06, 0.7858D-06, 0.9294D-06,
     ,   0.1089D-05, 0.1284D-05, 0.1509D-05, 0.1778D-05, 0.2088D-05,
     ,   0.2456D-05, 0.2889D-05, 0.3403D-05, 0.4002D-05, 0.4717D-05,
     ,   0.5504D-05, 0.6415D-05, 0.7448D-05, 0.8488D-05, 0.9542D-05,
     ,   0.1060D-04, 0.1152D-04, 0.1236D-04, 0.1307D-04, 0.1355D-04,
     ,   0.1388D-04, 0.1390D-04, 0.1379D-04, 0.1338D-04, 0.1268D-04,
     ,   0.1168D-04, 0.1034D-04, 0.8690D-05, 0.6680D-05, 0.4433D-05,
     ,   0.2162D-05, 0.1132D-06,-0.1348D-05,-0.2079D-05,-0.2142D-05,
     ,  -0.1917D-05,-0.1764D-05,-0.1780D-05,-0.1842D-05,-0.1809D-05,
     ,  -0.1630D-05,-0.1355D-05,-0.1047D-05,-0.7447D-06,-0.4853D-06,
     ,  -0.2655D-06,-0.9638D-07, 0.3994D-07/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.1083D-07, 0.1290D-07, 0.1538D-07, 0.1830D-07, 0.2178D-07,
     ,   0.2593D-07, 0.3085D-07, 0.3665D-07, 0.4356D-07, 0.5168D-07,
     ,   0.6139D-07, 0.7275D-07, 0.8647D-07, 0.1025D-06, 0.1218D-06,
     ,   0.1440D-06, 0.1708D-06, 0.2025D-06, 0.2393D-06, 0.2829D-06,
     ,   0.3341D-06, 0.3950D-06, 0.4657D-06, 0.5504D-06, 0.6476D-06,
     ,   0.7640D-06, 0.9006D-06, 0.1060D-05, 0.1246D-05, 0.1470D-05,
     ,   0.1732D-05, 0.2037D-05, 0.2398D-05, 0.2830D-05, 0.3329D-05,
     ,   0.3914D-05, 0.4585D-05, 0.5284D-05, 0.6034D-05, 0.6841D-05,
     ,   0.7597D-05, 0.8328D-05, 0.8921D-05, 0.9448D-05, 0.9887D-05,
     ,   0.1014D-04, 0.1029D-04, 0.1028D-04, 0.1010D-04, 0.9740D-05,
     ,   0.9170D-05, 0.8413D-05, 0.7403D-05, 0.6183D-05, 0.4735D-05,
     ,   0.3100D-05, 0.1493D-05, 0.2350D-07,-0.1010D-05,-0.1498D-05,
     ,  -0.1521D-05,-0.1350D-05,-0.1234D-05,-0.1250D-05,-0.1298D-05,
     ,  -0.1278D-05,-0.1156D-05,-0.9639D-06,-0.7428D-06,-0.5350D-06,
     ,  -0.3536D-06,-0.1999D-06,-0.7854D-07/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.4471D-08, 0.5268D-08, 0.6182D-08, 0.7268D-08, 0.8546D-08,
     ,   0.1004D-07, 0.1176D-07, 0.1380D-07, 0.1612D-07, 0.1884D-07,
     ,   0.2199D-07, 0.2563D-07, 0.2975D-07, 0.3462D-07, 0.4004D-07,
     ,   0.4652D-07, 0.5365D-07, 0.6133D-07, 0.7078D-07, 0.8099D-07,
     ,   0.9237D-07, 0.1048D-06, 0.1189D-06, 0.1335D-06, 0.1492D-06,
     ,   0.1676D-06, 0.1839D-06, 0.2024D-06, 0.2249D-06, 0.2412D-06,
     ,   0.2613D-06, 0.2879D-06, 0.3208D-06, 0.3649D-06, 0.4282D-06,
     ,   0.5225D-06, 0.6501D-06, 0.8230D-06, 0.1030D-05, 0.1243D-05,
     ,   0.1476D-05, 0.1689D-05, 0.1927D-05, 0.2116D-05, 0.2232D-05,
     ,   0.2372D-05, 0.2454D-05, 0.2466D-05, 0.2437D-05, 0.2366D-05,
     ,   0.2240D-05, 0.2010D-05, 0.1708D-05, 0.1319D-05, 0.8772D-06,
     ,   0.3252D-06,-0.3108D-06,-0.9389D-06,-0.1500D-05,-0.1877D-05,
     ,  -0.2007D-05,-0.1925D-05,-0.1758D-05,-0.1610D-05,-0.1511D-05,
     ,  -0.1407D-05,-0.1261D-05,-0.1068D-05,-0.8571D-06,-0.6487D-06,
     ,  -0.4637D-06,-0.3100D-06,-0.1849D-06/




      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c-----------------------------
      subroutine c2hqg21p(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.1163D-03, 0.1372D-03, 0.1616D-03, 0.1903D-03, 0.2239D-03,
     ,   0.2632D-03, 0.3090D-03, 0.3626D-03, 0.4249D-03, 0.4974D-03,
     ,   0.5816D-03, 0.6794D-03, 0.7915D-03, 0.9218D-03, 0.1072D-02,
     ,   0.1243D-02, 0.1440D-02, 0.1664D-02, 0.1919D-02, 0.2207D-02,
     ,   0.2531D-02, 0.2895D-02, 0.3299D-02, 0.3748D-02, 0.4242D-02,
     ,   0.4780D-02, 0.5363D-02, 0.5987D-02, 0.6646D-02, 0.7327D-02,
     ,   0.7997D-02, 0.8615D-02, 0.9065D-02, 0.9211D-02, 0.8881D-02,
     ,   0.7900D-02, 0.6291D-02, 0.4195D-02, 0.1862D-02,-0.4350D-03,
     ,  -0.2533D-02,-0.4373D-02,-0.5941D-02,-0.7262D-02,-0.8357D-02,
     ,  -0.9249D-02,-0.9977D-02,-0.1056D-01,-0.1102D-01,-0.1138D-01,
     ,  -0.1166D-01,-0.1188D-01,-0.1204D-01,-0.1217D-01,-0.1226D-01,
     ,  -0.1234D-01,-0.1239D-01,-0.1243D-01,-0.1246D-01,-0.1248D-01,
     ,  -0.1250D-01,-0.1251D-01,-0.1252D-01,-0.1252D-01,-0.1253D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1254D-01,-0.1254D-01,-0.1254D-01,
     ,  -0.1254D-01,-0.1254D-01,-0.1254D-01/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1163D-03, 0.1371D-03, 0.1616D-03, 0.1902D-03, 0.2238D-03,
     ,   0.2631D-03, 0.3090D-03, 0.3624D-03, 0.4248D-03, 0.4973D-03,
     ,   0.5815D-03, 0.6787D-03, 0.7914D-03, 0.9217D-03, 0.1071D-02,
     ,   0.1243D-02, 0.1440D-02, 0.1663D-02, 0.1918D-02, 0.2206D-02,
     ,   0.2530D-02, 0.2893D-02, 0.3299D-02, 0.3747D-02, 0.4241D-02,
     ,   0.4779D-02, 0.5362D-02, 0.5985D-02, 0.6645D-02, 0.7327D-02,
     ,   0.7996D-02, 0.8615D-02, 0.9065D-02, 0.9212D-02, 0.8871D-02,
     ,   0.7901D-02, 0.6293D-02, 0.4197D-02, 0.1863D-02,-0.4337D-03,
     ,  -0.2531D-02,-0.4372D-02,-0.5940D-02,-0.7255D-02,-0.8350D-02,
     ,  -0.9249D-02,-0.9978D-02,-0.1056D-01,-0.1102D-01,-0.1138D-01,
     ,  -0.1166D-01,-0.1188D-01,-0.1204D-01,-0.1217D-01,-0.1226D-01,
     ,  -0.1234D-01,-0.1239D-01,-0.1243D-01,-0.1246D-01,-0.1248D-01,
     ,  -0.1250D-01,-0.1250D-01,-0.1252D-01,-0.1252D-01,-0.1252D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1254D-01,-0.1254D-01,
     ,  -0.1254D-01,-0.1254D-01,-0.1254D-01/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1162D-03, 0.1370D-03, 0.1615D-03, 0.1902D-03, 0.2237D-03,
     ,   0.2630D-03, 0.3089D-03, 0.3624D-03, 0.4247D-03, 0.4972D-03,
     ,   0.5812D-03, 0.6785D-03, 0.7913D-03, 0.9216D-03, 0.1071D-02,
     ,   0.1242D-02, 0.1439D-02, 0.1663D-02, 0.1917D-02, 0.2205D-02,
     ,   0.2530D-02, 0.2893D-02, 0.3298D-02, 0.3747D-02, 0.4239D-02,
     ,   0.4778D-02, 0.5360D-02, 0.5984D-02, 0.6643D-02, 0.7320D-02,
     ,   0.7995D-02, 0.8615D-02, 0.9065D-02, 0.9202D-02, 0.8872D-02,
     ,   0.7902D-02, 0.6294D-02, 0.4188D-02, 0.1865D-02,-0.4319D-03,
     ,  -0.2530D-02,-0.4371D-02,-0.5939D-02,-0.7256D-02,-0.8350D-02,
     ,  -0.9249D-02,-0.9979D-02,-0.1056D-01,-0.1102D-01,-0.1138D-01,
     ,  -0.1166D-01,-0.1188D-01,-0.1204D-01,-0.1217D-01,-0.1226D-01,
     ,  -0.1233D-01,-0.1238D-01,-0.1242D-01,-0.1246D-01,-0.1248D-01,
     ,  -0.1249D-01,-0.1251D-01,-0.1251D-01,-0.1252D-01,-0.1253D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1254D-01,
     ,  -0.1254D-01,-0.1254D-01,-0.1254D-01/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.1162D-03, 0.1370D-03, 0.1615D-03, 0.1901D-03, 0.2236D-03,
     ,   0.2629D-03, 0.3087D-03, 0.3622D-03, 0.4245D-03, 0.4970D-03,
     ,   0.5810D-03, 0.6784D-03, 0.7911D-03, 0.9207D-03, 0.1071D-02,
     ,   0.1242D-02, 0.1438D-02, 0.1662D-02, 0.1916D-02, 0.2205D-02,
     ,   0.2528D-02, 0.2891D-02, 0.3296D-02, 0.3745D-02, 0.4238D-02,
     ,   0.4776D-02, 0.5358D-02, 0.5982D-02, 0.6640D-02, 0.7318D-02,
     ,   0.7993D-02, 0.8604D-02, 0.9054D-02, 0.9202D-02, 0.8863D-02,
     ,   0.7904D-02, 0.6296D-02, 0.4191D-02, 0.1868D-02,-0.4291D-03,
     ,  -0.2537D-02,-0.4369D-02,-0.5937D-02,-0.7256D-02,-0.8351D-02,
     ,  -0.9250D-02,-0.9973D-02,-0.1055D-01,-0.1101D-01,-0.1138D-01,
     ,  -0.1165D-01,-0.1187D-01,-0.1204D-01,-0.1216D-01,-0.1226D-01,
     ,  -0.1233D-01,-0.1238D-01,-0.1242D-01,-0.1245D-01,-0.1247D-01,
     ,  -0.1249D-01,-0.1251D-01,-0.1251D-01,-0.1252D-01,-0.1253D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1253D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.1161D-03, 0.1369D-03, 0.1613D-03, 0.1899D-03, 0.2235D-03,
     ,   0.2627D-03, 0.3086D-03, 0.3619D-03, 0.4243D-03, 0.4967D-03,
     ,   0.5806D-03, 0.6781D-03, 0.7908D-03, 0.9203D-03, 0.1070D-02,
     ,   0.1241D-02, 0.1437D-02, 0.1661D-02, 0.1915D-02, 0.2202D-02,
     ,   0.2527D-02, 0.2890D-02, 0.3294D-02, 0.3742D-02, 0.4235D-02,
     ,   0.4773D-02, 0.5355D-02, 0.5977D-02, 0.6635D-02, 0.7315D-02,
     ,   0.7985D-02, 0.8603D-02, 0.9054D-02, 0.9203D-02, 0.8865D-02,
     ,   0.7907D-02, 0.6290D-02, 0.4195D-02, 0.1861D-02,-0.4251D-03,
     ,  -0.2533D-02,-0.4366D-02,-0.5934D-02,-0.7251D-02,-0.8345D-02,
     ,  -0.9243D-02,-0.9973D-02,-0.1055D-01,-0.1101D-01,-0.1137D-01,
     ,  -0.1166D-01,-0.1187D-01,-0.1203D-01,-0.1216D-01,-0.1226D-01,
     ,  -0.1232D-01,-0.1238D-01,-0.1242D-01,-0.1245D-01,-0.1247D-01,
     ,  -0.1249D-01,-0.1250D-01,-0.1251D-01,-0.1251D-01,-0.1252D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1253D-01,-0.1253D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.1160D-03, 0.1368D-03, 0.1612D-03, 0.1898D-03, 0.2233D-03,
     ,   0.2625D-03, 0.3082D-03, 0.3616D-03, 0.4238D-03, 0.4961D-03,
     ,   0.5799D-03, 0.6771D-03, 0.7897D-03, 0.9191D-03, 0.1069D-02,
     ,   0.1240D-02, 0.1436D-02, 0.1660D-02, 0.1913D-02, 0.2201D-02,
     ,   0.2524D-02, 0.2887D-02, 0.3291D-02, 0.3738D-02, 0.4231D-02,
     ,   0.4768D-02, 0.5349D-02, 0.5972D-02, 0.6629D-02, 0.7306D-02,
     ,   0.7981D-02, 0.8591D-02, 0.9044D-02, 0.9194D-02, 0.8858D-02,
     ,   0.7891D-02, 0.6295D-02, 0.4190D-02, 0.1867D-02,-0.4293D-03,
     ,  -0.2527D-02,-0.4362D-02,-0.5930D-02,-0.7245D-02,-0.8339D-02,
     ,  -0.9238D-02,-0.9968D-02,-0.1055D-01,-0.1101D-01,-0.1137D-01,
     ,  -0.1165D-01,-0.1187D-01,-0.1203D-01,-0.1216D-01,-0.1225D-01,
     ,  -0.1232D-01,-0.1237D-01,-0.1241D-01,-0.1245D-01,-0.1247D-01,
     ,  -0.1248D-01,-0.1249D-01,-0.1250D-01,-0.1251D-01,-0.1252D-01,
     ,  -0.1252D-01,-0.1252D-01,-0.1252D-01,-0.1252D-01,-0.1253D-01,
     ,  -0.1253D-01,-0.1253D-01,-0.1253D-01/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.1158D-03, 0.1365D-03, 0.1609D-03, 0.1895D-03, 0.2229D-03,
     ,   0.2620D-03, 0.3077D-03, 0.3610D-03, 0.4231D-03, 0.4953D-03,
     ,   0.5791D-03, 0.6765D-03, 0.7883D-03, 0.9177D-03, 0.1067D-02,
     ,   0.1238D-02, 0.1434D-02, 0.1657D-02, 0.1910D-02, 0.2197D-02,
     ,   0.2520D-02, 0.2882D-02, 0.3286D-02, 0.3733D-02, 0.4224D-02,
     ,   0.4761D-02, 0.5341D-02, 0.5964D-02, 0.6620D-02, 0.7301D-02,
     ,   0.7971D-02, 0.8579D-02, 0.9033D-02, 0.9186D-02, 0.8852D-02,
     ,   0.7897D-02, 0.6292D-02, 0.4189D-02, 0.1866D-02,-0.4206D-03,
     ,  -0.2519D-02,-0.4357D-02,-0.5924D-02,-0.7240D-02,-0.8334D-02,
     ,  -0.9233D-02,-0.9956D-02,-0.1054D-01,-0.1100D-01,-0.1136D-01,
     ,  -0.1164D-01,-0.1186D-01,-0.1202D-01,-0.1215D-01,-0.1224D-01,
     ,  -0.1231D-01,-0.1237D-01,-0.1241D-01,-0.1244D-01,-0.1246D-01,
     ,  -0.1248D-01,-0.1249D-01,-0.1250D-01,-0.1250D-01,-0.1251D-01,
     ,  -0.1251D-01,-0.1252D-01,-0.1252D-01,-0.1252D-01,-0.1252D-01,
     ,  -0.1252D-01,-0.1252D-01,-0.1252D-01/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1155D-03, 0.1362D-03, 0.1605D-03, 0.1891D-03, 0.2224D-03,
     ,   0.2615D-03, 0.3070D-03, 0.3602D-03, 0.4222D-03, 0.4943D-03,
     ,   0.5778D-03, 0.6743D-03, 0.7867D-03, 0.9160D-03, 0.1065D-02,
     ,   0.1235D-02, 0.1431D-02, 0.1653D-02, 0.1906D-02, 0.2193D-02,
     ,   0.2516D-02, 0.2876D-02, 0.3280D-02, 0.3725D-02, 0.4215D-02,
     ,   0.4751D-02, 0.5330D-02, 0.5952D-02, 0.6608D-02, 0.7282D-02,
     ,   0.7958D-02, 0.8566D-02, 0.9023D-02, 0.9178D-02, 0.8837D-02,
     ,   0.7885D-02, 0.6283D-02, 0.4191D-02, 0.1879D-02,-0.4180D-03,
     ,  -0.2516D-02,-0.4348D-02,-0.5915D-02,-0.7235D-02,-0.8323D-02,
     ,  -0.9222D-02,-0.9945D-02,-0.1053D-01,-0.1099D-01,-0.1135D-01,
     ,  -0.1163D-01,-0.1185D-01,-0.1201D-01,-0.1214D-01,-0.1224D-01,
     ,  -0.1230D-01,-0.1236D-01,-0.1240D-01,-0.1243D-01,-0.1245D-01,
     ,  -0.1247D-01,-0.1248D-01,-0.1249D-01,-0.1249D-01,-0.1250D-01,
     ,  -0.1250D-01,-0.1251D-01,-0.1251D-01,-0.1251D-01,-0.1251D-01,
     ,  -0.1251D-01,-0.1251D-01,-0.1251D-01/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1152D-03, 0.1358D-03, 0.1601D-03, 0.1884D-03, 0.2217D-03,
     ,   0.2606D-03, 0.3060D-03, 0.3590D-03, 0.4208D-03, 0.4925D-03,
     ,   0.5759D-03, 0.6725D-03, 0.7841D-03, 0.9131D-03, 0.1061D-02,
     ,   0.1232D-02, 0.1426D-02, 0.1648D-02, 0.1900D-02, 0.2185D-02,
     ,   0.2507D-02, 0.2867D-02, 0.3269D-02, 0.3713D-02, 0.4203D-02,
     ,   0.4736D-02, 0.5314D-02, 0.5933D-02, 0.6587D-02, 0.7266D-02,
     ,   0.7934D-02, 0.8541D-02, 0.9002D-02, 0.9152D-02, 0.8826D-02,
     ,   0.7878D-02, 0.6279D-02, 0.4199D-02, 0.1877D-02,-0.4095D-03,
     ,  -0.2498D-02,-0.4335D-02,-0.5901D-02,-0.7219D-02,-0.8313D-02,
     ,  -0.9206D-02,-0.9936D-02,-0.1052D-01,-0.1098D-01,-0.1134D-01,
     ,  -0.1162D-01,-0.1184D-01,-0.1200D-01,-0.1213D-01,-0.1222D-01,
     ,  -0.1229D-01,-0.1234D-01,-0.1238D-01,-0.1242D-01,-0.1244D-01,
     ,  -0.1245D-01,-0.1246D-01,-0.1247D-01,-0.1248D-01,-0.1249D-01,
     ,  -0.1249D-01,-0.1249D-01,-0.1249D-01,-0.1249D-01,-0.1249D-01,
     ,  -0.1249D-01,-0.1250D-01,-0.1250D-01/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.1146D-03, 0.1351D-03, 0.1592D-03, 0.1875D-03, 0.2206D-03,
     ,   0.2594D-03, 0.3045D-03, 0.3573D-03, 0.4188D-03, 0.4903D-03,
     ,   0.5731D-03, 0.6693D-03, 0.7801D-03, 0.9088D-03, 0.1056D-02,
     ,   0.1226D-02, 0.1419D-02, 0.1640D-02, 0.1891D-02, 0.2175D-02,
     ,   0.2496D-02, 0.2854D-02, 0.3253D-02, 0.3697D-02, 0.4183D-02,
     ,   0.4716D-02, 0.5291D-02, 0.5908D-02, 0.6559D-02, 0.7231D-02,
     ,   0.7901D-02, 0.8514D-02, 0.8960D-02, 0.9117D-02, 0.8798D-02,
     ,   0.7856D-02, 0.6272D-02, 0.4194D-02, 0.1884D-02,-0.3924D-03,
     ,  -0.2482D-02,-0.4318D-02,-0.5882D-02,-0.7196D-02,-0.8292D-02,
     ,  -0.9185D-02,-0.9915D-02,-0.1050D-01,-0.1096D-01,-0.1132D-01,
     ,  -0.1159D-01,-0.1181D-01,-0.1198D-01,-0.1210D-01,-0.1219D-01,
     ,  -0.1227D-01,-0.1232D-01,-0.1236D-01,-0.1239D-01,-0.1242D-01,
     ,  -0.1243D-01,-0.1244D-01,-0.1245D-01,-0.1246D-01,-0.1247D-01,
     ,  -0.1247D-01,-0.1247D-01,-0.1247D-01,-0.1247D-01,-0.1247D-01,
     ,  -0.1247D-01,-0.1247D-01,-0.1247D-01/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.1138D-03, 0.1341D-03, 0.1581D-03, 0.1862D-03, 0.2191D-03,
     ,   0.2576D-03, 0.3024D-03, 0.3549D-03, 0.4159D-03, 0.4868D-03,
     ,   0.5692D-03, 0.6647D-03, 0.7753D-03, 0.9021D-03, 0.1049D-02,
     ,   0.1217D-02, 0.1410D-02, 0.1629D-02, 0.1878D-02, 0.2160D-02,
     ,   0.2478D-02, 0.2835D-02, 0.3231D-02, 0.3671D-02, 0.4156D-02,
     ,   0.4685D-02, 0.5257D-02, 0.5870D-02, 0.6519D-02, 0.7191D-02,
     ,   0.7854D-02, 0.8464D-02, 0.8918D-02, 0.9084D-02, 0.8775D-02,
     ,   0.7833D-02, 0.6266D-02, 0.4202D-02, 0.1904D-02,-0.3729D-03,
     ,  -0.2463D-02,-0.4291D-02,-0.5854D-02,-0.7169D-02,-0.8259D-02,
     ,  -0.9160D-02,-0.9884D-02,-0.1047D-01,-0.1093D-01,-0.1128D-01,
     ,  -0.1156D-01,-0.1178D-01,-0.1195D-01,-0.1207D-01,-0.1216D-01,
     ,  -0.1224D-01,-0.1229D-01,-0.1233D-01,-0.1236D-01,-0.1238D-01,
     ,  -0.1240D-01,-0.1241D-01,-0.1242D-01,-0.1243D-01,-0.1243D-01,
     ,  -0.1243D-01,-0.1243D-01,-0.1244D-01,-0.1244D-01,-0.1244D-01,
     ,  -0.1244D-01,-0.1244D-01,-0.1244D-01/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.1126D-03, 0.1328D-03, 0.1565D-03, 0.1843D-03, 0.2169D-03,
     ,   0.2549D-03, 0.2993D-03, 0.3512D-03, 0.4116D-03, 0.4819D-03,
     ,   0.5634D-03, 0.6580D-03, 0.7672D-03, 0.8933D-03, 0.1038D-02,
     ,   0.1205D-02, 0.1395D-02, 0.1613D-02, 0.1860D-02, 0.2139D-02,
     ,   0.2454D-02, 0.2807D-02, 0.3200D-02, 0.3636D-02, 0.4116D-02,
     ,   0.4640D-02, 0.5207D-02, 0.5815D-02, 0.6460D-02, 0.7127D-02,
     ,   0.7785D-02, 0.8390D-02, 0.8855D-02, 0.9015D-02, 0.8721D-02,
     ,   0.7802D-02, 0.6255D-02, 0.4207D-02, 0.1921D-02,-0.3454D-03,
     ,  -0.2427D-02,-0.4252D-02,-0.5813D-02,-0.7126D-02,-0.8216D-02,
     ,  -0.9111D-02,-0.9836D-02,-0.1042D-01,-0.1088D-01,-0.1124D-01,
     ,  -0.1152D-01,-0.1173D-01,-0.1190D-01,-0.1202D-01,-0.1212D-01,
     ,  -0.1219D-01,-0.1225D-01,-0.1229D-01,-0.1231D-01,-0.1233D-01,
     ,  -0.1236D-01,-0.1237D-01,-0.1238D-01,-0.1238D-01,-0.1239D-01,
     ,  -0.1239D-01,-0.1239D-01,-0.1240D-01,-0.1240D-01,-0.1240D-01,
     ,  -0.1240D-01,-0.1240D-01,-0.1240D-01/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.1109D-03, 0.1308D-03, 0.1542D-03, 0.1816D-03, 0.2136D-03,
     ,   0.2511D-03, 0.2949D-03, 0.3460D-03, 0.4055D-03, 0.4748D-03,
     ,   0.5551D-03, 0.6482D-03, 0.7559D-03, 0.8805D-03, 0.1023D-02,
     ,   0.1188D-02, 0.1375D-02, 0.1590D-02, 0.1833D-02, 0.2109D-02,
     ,   0.2420D-02, 0.2767D-02, 0.3155D-02, 0.3585D-02, 0.4058D-02,
     ,   0.4575D-02, 0.5136D-02, 0.5737D-02, 0.6373D-02, 0.7032D-02,
     ,   0.7689D-02, 0.8299D-02, 0.8751D-02, 0.8930D-02, 0.8647D-02,
     ,   0.7758D-02, 0.6235D-02, 0.4207D-02, 0.1944D-02,-0.3019D-03,
     ,  -0.2375D-02,-0.4196D-02,-0.5752D-02,-0.7066D-02,-0.8151D-02,
     ,  -0.9047D-02,-0.9773D-02,-0.1035D-01,-0.1081D-01,-0.1117D-01,
     ,  -0.1146D-01,-0.1167D-01,-0.1183D-01,-0.1196D-01,-0.1205D-01,
     ,  -0.1213D-01,-0.1218D-01,-0.1222D-01,-0.1225D-01,-0.1227D-01,
     ,  -0.1229D-01,-0.1230D-01,-0.1231D-01,-0.1232D-01,-0.1232D-01,
     ,  -0.1232D-01,-0.1232D-01,-0.1233D-01,-0.1233D-01,-0.1233D-01,
     ,  -0.1233D-01,-0.1233D-01,-0.1233D-01/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1085D-03, 0.1280D-03, 0.1508D-03, 0.1776D-03, 0.2090D-03,
     ,   0.2457D-03, 0.2886D-03, 0.3386D-03, 0.3969D-03, 0.4646D-03,
     ,   0.5432D-03, 0.6343D-03, 0.7396D-03, 0.8614D-03, 0.1002D-02,
     ,   0.1162D-02, 0.1346D-02, 0.1556D-02, 0.1795D-02, 0.2065D-02,
     ,   0.2369D-02, 0.2710D-02, 0.3090D-02, 0.3512D-02, 0.3976D-02,
     ,   0.4483D-02, 0.5034D-02, 0.5624D-02, 0.6250D-02, 0.6897D-02,
     ,   0.7549D-02, 0.8149D-02, 0.8604D-02, 0.8802D-02, 0.8539D-02,
     ,   0.7688D-02, 0.6197D-02, 0.4222D-02, 0.1985D-02,-0.2516D-03,
     ,  -0.2307D-02,-0.4115D-02,-0.5666D-02,-0.6973D-02,-0.8060D-02,
     ,  -0.8950D-02,-0.9677D-02,-0.1026D-01,-0.1072D-01,-0.1108D-01,
     ,  -0.1136D-01,-0.1157D-01,-0.1174D-01,-0.1187D-01,-0.1196D-01,
     ,  -0.1203D-01,-0.1208D-01,-0.1212D-01,-0.1216D-01,-0.1218D-01,
     ,  -0.1219D-01,-0.1220D-01,-0.1221D-01,-0.1222D-01,-0.1222D-01,
     ,  -0.1222D-01,-0.1223D-01,-0.1223D-01,-0.1223D-01,-0.1223D-01,
     ,  -0.1224D-01,-0.1224D-01,-0.1224D-01/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1051D-03, 0.1240D-03, 0.1462D-03, 0.1721D-03, 0.2025D-03,
     ,   0.2381D-03, 0.2796D-03, 0.3280D-03, 0.3845D-03, 0.4502D-03,
     ,   0.5265D-03, 0.6149D-03, 0.7173D-03, 0.8352D-03, 0.9712D-03,
     ,   0.1127D-02, 0.1305D-02, 0.1509D-02, 0.1740D-02, 0.2002D-02,
     ,   0.2297D-02, 0.2629D-02, 0.2998D-02, 0.3408D-02, 0.3860D-02,
     ,   0.4353D-02, 0.4889D-02, 0.5465D-02, 0.6077D-02, 0.6711D-02,
     ,   0.7351D-02, 0.7947D-02, 0.8414D-02, 0.8622D-02, 0.8393D-02,
     ,   0.7582D-02, 0.6152D-02, 0.4225D-02, 0.2036D-02,-0.1694D-03,
     ,  -0.2198D-02,-0.4000D-02,-0.5543D-02,-0.6845D-02,-0.7929D-02,
     ,  -0.8822D-02,-0.9545D-02,-0.1012D-01,-0.1058D-01,-0.1094D-01,
     ,  -0.1122D-01,-0.1144D-01,-0.1160D-01,-0.1172D-01,-0.1182D-01,
     ,  -0.1189D-01,-0.1195D-01,-0.1199D-01,-0.1202D-01,-0.1204D-01,
     ,  -0.1206D-01,-0.1206D-01,-0.1208D-01,-0.1208D-01,-0.1208D-01,
     ,  -0.1209D-01,-0.1209D-01,-0.1210D-01,-0.1210D-01,-0.1210D-01,
     ,  -0.1210D-01,-0.1210D-01,-0.1210D-01/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.1004D-03, 0.1184D-03, 0.1397D-03, 0.1645D-03, 0.1935D-03,
     ,   0.2275D-03, 0.2672D-03, 0.3136D-03, 0.3676D-03, 0.4304D-03,
     ,   0.5033D-03, 0.5879D-03, 0.6855D-03, 0.7982D-03, 0.9284D-03,
     ,   0.1077D-02, 0.1248D-02, 0.1443D-02, 0.1665D-02, 0.1916D-02,
     ,   0.2200D-02, 0.2516D-02, 0.2872D-02, 0.3265D-02, 0.3699D-02,
     ,   0.4173D-02, 0.4689D-02, 0.5244D-02, 0.5834D-02, 0.6452D-02,
     ,   0.7073D-02, 0.7658D-02, 0.8130D-02, 0.8354D-02, 0.8175D-02,
     ,   0.7440D-02, 0.6085D-02, 0.4236D-02, 0.2109D-02,-0.4562D-04,
     ,  -0.2058D-02,-0.3838D-02,-0.5367D-02,-0.6662D-02,-0.7743D-02,
     ,  -0.8632D-02,-0.9351D-02,-0.9926D-02,-0.1038D-01,-0.1075D-01,
     ,  -0.1103D-01,-0.1124D-01,-0.1141D-01,-0.1153D-01,-0.1163D-01,
     ,  -0.1169D-01,-0.1175D-01,-0.1179D-01,-0.1182D-01,-0.1184D-01,
     ,  -0.1186D-01,-0.1187D-01,-0.1188D-01,-0.1188D-01,-0.1189D-01,
     ,  -0.1189D-01,-0.1190D-01,-0.1190D-01,-0.1190D-01,-0.1190D-01,
     ,  -0.1190D-01,-0.1191D-01,-0.1191D-01/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.9412D-04, 0.1110D-03, 0.1309D-03, 0.1541D-03, 0.1813D-03,
     ,   0.2132D-03, 0.2505D-03, 0.2940D-03, 0.3447D-03, 0.4035D-03,
     ,   0.4720D-03, 0.5513D-03, 0.6434D-03, 0.7494D-03, 0.8711D-03,
     ,   0.1012D-02, 0.1172D-02, 0.1355D-02, 0.1563D-02, 0.1800D-02,
     ,   0.2067D-02, 0.2365D-02, 0.2699D-02, 0.3070D-02, 0.3480D-02,
     ,   0.3929D-02, 0.4416D-02, 0.4944D-02, 0.5505D-02, 0.6095D-02,
     ,   0.6693D-02, 0.7268D-02, 0.7741D-02, 0.7999D-02, 0.7873D-02,
     ,   0.7227D-02, 0.5994D-02, 0.4245D-02, 0.2196D-02, 0.1041D-03,
     ,  -0.1860D-02,-0.3612D-02,-0.5124D-02,-0.6408D-02,-0.7482D-02,
     ,  -0.8362D-02,-0.9078D-02,-0.9657D-02,-0.1012D-01,-0.1047D-01,
     ,  -0.1076D-01,-0.1097D-01,-0.1113D-01,-0.1126D-01,-0.1135D-01,
     ,  -0.1143D-01,-0.1148D-01,-0.1152D-01,-0.1155D-01,-0.1157D-01,
     ,  -0.1158D-01,-0.1160D-01,-0.1160D-01,-0.1161D-01,-0.1162D-01,
     ,  -0.1162D-01,-0.1162D-01,-0.1162D-01,-0.1162D-01,-0.1163D-01,
     ,  -0.1163D-01,-0.1163D-01,-0.1163D-01/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.8589D-04, 0.1013D-03, 0.1194D-03, 0.1407D-03, 0.1655D-03,
     ,   0.1946D-03, 0.2287D-03, 0.2684D-03, 0.3147D-03, 0.3686D-03,
     ,   0.4311D-03, 0.5037D-03, 0.5876D-03, 0.6845D-03, 0.7961D-03,
     ,   0.9249D-03, 0.1071D-02, 0.1240D-02, 0.1430D-02, 0.1647D-02,
     ,   0.1891D-02, 0.2167D-02, 0.2474D-02, 0.2816D-02, 0.3193D-02,
     ,   0.3607D-02, 0.4059D-02, 0.4549D-02, 0.5072D-02, 0.5625D-02,
     ,   0.6191D-02, 0.6746D-02, 0.7216D-02, 0.7502D-02, 0.7463D-02,
     ,   0.6933D-02, 0.5838D-02, 0.4236D-02, 0.2314D-02, 0.3072D-03,
     ,  -0.1594D-02,-0.3306D-02,-0.4793D-02,-0.6060D-02,-0.7119D-02,
     ,  -0.7999D-02,-0.8714D-02,-0.9289D-02,-0.9739D-02,-0.1010D-01,
     ,  -0.1038D-01,-0.1060D-01,-0.1075D-01,-0.1089D-01,-0.1097D-01,
     ,  -0.1105D-01,-0.1110D-01,-0.1114D-01,-0.1117D-01,-0.1119D-01,
     ,  -0.1121D-01,-0.1122D-01,-0.1123D-01,-0.1123D-01,-0.1124D-01,
     ,  -0.1125D-01,-0.1125D-01,-0.1125D-01,-0.1125D-01,-0.1125D-01,
     ,  -0.1125D-01,-0.1125D-01,-0.1125D-01/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.7560D-04, 0.8922D-04, 0.1052D-03, 0.1239D-03, 0.1459D-03,
     ,   0.1715D-03, 0.2015D-03, 0.2366D-03, 0.2775D-03, 0.3250D-03,
     ,   0.3802D-03, 0.4444D-03, 0.5185D-03, 0.6042D-03, 0.7032D-03,
     ,   0.8167D-03, 0.9466D-03, 0.1095D-02, 0.1265D-02, 0.1457D-02,
     ,   0.1674D-02, 0.1918D-02, 0.2192D-02, 0.2497D-02, 0.2833D-02,
     ,   0.3204D-02, 0.3610D-02, 0.4051D-02, 0.4526D-02, 0.5031D-02,
     ,   0.5557D-02, 0.6078D-02, 0.6544D-02, 0.6870D-02, 0.6910D-02,
     ,   0.6536D-02, 0.5619D-02, 0.4207D-02, 0.2455D-02, 0.5694D-03,
     ,  -0.1250D-02,-0.2906D-02,-0.4356D-02,-0.5599D-02,-0.6644D-02,
     ,  -0.7513D-02,-0.8220D-02,-0.8787D-02,-0.9242D-02,-0.9598D-02,
     ,  -0.9877D-02,-0.1009D-01,-0.1025D-01,-0.1038D-01,-0.1047D-01,
     ,  -0.1054D-01,-0.1060D-01,-0.1064D-01,-0.1067D-01,-0.1069D-01,
     ,  -0.1071D-01,-0.1072D-01,-0.1073D-01,-0.1074D-01,-0.1074D-01,
     ,  -0.1074D-01,-0.1074D-01,-0.1075D-01,-0.1075D-01,-0.1075D-01,
     ,  -0.1075D-01,-0.1075D-01,-0.1075D-01/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.6360D-04, 0.7506D-04, 0.8852D-04, 0.1043D-03, 0.1228D-03,
     ,   0.1445D-03, 0.1698D-03, 0.1993D-03, 0.2338D-03, 0.2739D-03,
     ,   0.3206D-03, 0.3748D-03, 0.4375D-03, 0.5101D-03, 0.5936D-03,
     ,   0.6896D-03, 0.7999D-03, 0.9261D-03, 0.1070D-02, 0.1234D-02,
     ,   0.1418D-02, 0.1626D-02, 0.1860D-02, 0.2120D-02, 0.2409D-02,
     ,   0.2728D-02, 0.3078D-02, 0.3461D-02, 0.3875D-02, 0.4321D-02,
     ,   0.4792D-02, 0.5271D-02, 0.5721D-02, 0.6076D-02, 0.6208D-02,
     ,   0.5985D-02, 0.5297D-02, 0.4126D-02, 0.2585D-02, 0.8774D-03,
     ,  -0.8300D-03,-0.2406D-02,-0.3803D-02,-0.5010D-02,-0.6034D-02,
     ,  -0.6887D-02,-0.7583D-02,-0.8150D-02,-0.8596D-02,-0.8957D-02,
     ,  -0.9232D-02,-0.9443D-02,-0.9604D-02,-0.9730D-02,-0.9827D-02,
     ,  -0.9897D-02,-0.9946D-02,-0.9987D-02,-0.1002D-01,-0.1004D-01,
     ,  -0.1006D-01,-0.1007D-01,-0.1008D-01,-0.1008D-01,-0.1009D-01,
     ,  -0.1009D-01,-0.1010D-01,-0.1010D-01,-0.1010D-01,-0.1010D-01,
     ,  -0.1010D-01,-0.1010D-01,-0.1010D-01/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.5062D-04, 0.5975D-04, 0.7046D-04, 0.8302D-04, 0.9777D-04,
     ,   0.1151D-03, 0.1353D-03, 0.1588D-03, 0.1864D-03, 0.2185D-03,
     ,   0.2558D-03, 0.2991D-03, 0.3493D-03, 0.4073D-03, 0.4743D-03,
     ,   0.5516D-03, 0.6400D-03, 0.7416D-03, 0.8574D-03, 0.9888D-03,
     ,   0.1138D-02, 0.1306D-02, 0.1495D-02, 0.1707D-02, 0.1943D-02,
     ,   0.2203D-02, 0.2491D-02, 0.2807D-02, 0.3153D-02, 0.3529D-02,
     ,   0.3933D-02, 0.4356D-02, 0.4774D-02, 0.5134D-02, 0.5351D-02,
     ,   0.5299D-02, 0.4859D-02, 0.3962D-02, 0.2689D-02, 0.1196D-02,
     ,  -0.3492D-03,-0.1815D-02,-0.3138D-02,-0.4296D-02,-0.5286D-02,
     ,  -0.6118D-02,-0.6803D-02,-0.7359D-02,-0.7805D-02,-0.8156D-02,
     ,  -0.8429D-02,-0.8636D-02,-0.8799D-02,-0.8926D-02,-0.9018D-02,
     ,  -0.9088D-02,-0.9144D-02,-0.9179D-02,-0.9214D-02,-0.9235D-02,
     ,  -0.9249D-02,-0.9262D-02,-0.9270D-02,-0.9277D-02,-0.9284D-02,
     ,  -0.9284D-02,-0.9290D-02,-0.9290D-02,-0.9290D-02,-0.9290D-02,
     ,  -0.9290D-02,-0.9290D-02,-0.9290D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.3776D-04, 0.4455D-04, 0.5259D-04, 0.6198D-04, 0.7303D-04,
     ,   0.8594D-04, 0.1011D-03, 0.1188D-03, 0.1394D-03, 0.1635D-03,
     ,   0.1915D-03, 0.2240D-03, 0.2617D-03, 0.3054D-03, 0.3559D-03,
     ,   0.4140D-03, 0.4809D-03, 0.5576D-03, 0.6451D-03, 0.7448D-03,
     ,   0.8581D-03, 0.9865D-03, 0.1131D-02, 0.1292D-02, 0.1473D-02,
     ,   0.1674D-02, 0.1898D-02, 0.2144D-02, 0.2417D-02, 0.2717D-02,
     ,   0.3046D-02, 0.3400D-02, 0.3769D-02, 0.4120D-02, 0.4394D-02,
     ,   0.4483D-02, 0.4273D-02, 0.3687D-02, 0.2723D-02, 0.1491D-02,
     ,   0.1506D-03,-0.1170D-02,-0.2392D-02,-0.3481D-02,-0.4425D-02,
     ,  -0.5226D-02,-0.5891D-02,-0.6434D-02,-0.6870D-02,-0.7216D-02,
     ,  -0.7487D-02,-0.7700D-02,-0.7859D-02,-0.7980D-02,-0.8073D-02,
     ,  -0.8145D-02,-0.8194D-02,-0.8236D-02,-0.8264D-02,-0.8286D-02,
     ,  -0.8306D-02,-0.8313D-02,-0.8321D-02,-0.8328D-02,-0.8335D-02,
     ,  -0.8341D-02,-0.8341D-02,-0.8342D-02,-0.8342D-02,-0.8342D-02,
     ,  -0.8348D-02,-0.8348D-02,-0.8348D-02/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.2626D-04, 0.3101D-04, 0.3659D-04, 0.4315D-04, 0.5087D-04,
     ,   0.5988D-04, 0.7045D-04, 0.8283D-04, 0.9728D-04, 0.1141D-03,
     ,   0.1338D-03, 0.1565D-03, 0.1830D-03, 0.2138D-03, 0.2492D-03,
     ,   0.2902D-03, 0.3373D-03, 0.3915D-03, 0.4533D-03, 0.5241D-03,
     ,   0.6048D-03, 0.6960D-03, 0.7988D-03, 0.9150D-03, 0.1045D-02,
     ,   0.1191D-02, 0.1353D-02, 0.1534D-02, 0.1736D-02, 0.1961D-02,
     ,   0.2212D-02, 0.2491D-02, 0.2794D-02, 0.3107D-02, 0.3393D-02,
     ,   0.3580D-02, 0.3570D-02, 0.3265D-02, 0.2626D-02, 0.1699D-02,
     ,   0.6057D-03,-0.5297D-03,-0.1620D-02,-0.2616D-02,-0.3496D-02,
     ,  -0.4254D-02,-0.4892D-02,-0.5418D-02,-0.5843D-02,-0.6180D-02,
     ,  -0.6446D-02,-0.6652D-02,-0.6811D-02,-0.6933D-02,-0.7025D-02,
     ,  -0.7095D-02,-0.7147D-02,-0.7186D-02,-0.7216D-02,-0.7237D-02,
     ,  -0.7254D-02,-0.7265D-02,-0.7274D-02,-0.7280D-02,-0.7285D-02,
     ,  -0.7288D-02,-0.7291D-02,-0.7292D-02,-0.7294D-02,-0.7294D-02,
     ,  -0.7295D-02,-0.7296D-02,-0.7296D-02/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.1702D-04, 0.2010D-04, 0.2374D-04, 0.2801D-04, 0.3301D-04,
     ,   0.3888D-04, 0.4578D-04, 0.5385D-04, 0.6327D-04, 0.7427D-04,
     ,   0.8709D-04, 0.1021D-03, 0.1194D-03, 0.1395D-03, 0.1628D-03,
     ,   0.1897D-03, 0.2208D-03, 0.2566D-03, 0.2975D-03, 0.3442D-03,
     ,   0.3977D-03, 0.4584D-03, 0.5272D-03, 0.6050D-03, 0.6927D-03,
     ,   0.7910D-03, 0.9020D-03, 0.1026D-02, 0.1166D-02, 0.1324D-02,
     ,   0.1504D-02, 0.1709D-02, 0.1940D-02, 0.2195D-02, 0.2456D-02,
     ,   0.2682D-02, 0.2802D-02, 0.2726D-02, 0.2384D-02, 0.1770D-02,
     ,   0.9513D-03, 0.3363D-04,-0.8934D-03,-0.1771D-02,-0.2568D-02,
     ,  -0.3269D-02,-0.3868D-02,-0.4369D-02,-0.4777D-02,-0.5105D-02,
     ,  -0.5363D-02,-0.5565D-02,-0.5722D-02,-0.5841D-02,-0.5932D-02,
     ,  -0.6001D-02,-0.6053D-02,-0.6092D-02,-0.6121D-02,-0.6142D-02,
     ,  -0.6158D-02,-0.6169D-02,-0.6178D-02,-0.6185D-02,-0.6189D-02,
     ,  -0.6193D-02,-0.6195D-02,-0.6197D-02,-0.6198D-02,-0.6199D-02,
     ,  -0.6200D-02,-0.6200D-02,-0.6200D-02/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.1032D-04, 0.1220D-04, 0.1441D-04, 0.1701D-04, 0.2005D-04,
     ,   0.2364D-04, 0.2785D-04, 0.3277D-04, 0.3853D-04, 0.4526D-04,
     ,   0.5312D-04, 0.6227D-04, 0.7294D-04, 0.8527D-04, 0.9962D-04,
     ,   0.1162D-03, 0.1354D-03, 0.1575D-03, 0.1828D-03, 0.2119D-03,
     ,   0.2452D-03, 0.2831D-03, 0.3262D-03, 0.3752D-03, 0.4305D-03,
     ,   0.4932D-03, 0.5638D-03, 0.6439D-03, 0.7347D-03, 0.8390D-03,
     ,   0.9591D-03, 0.1099D-02, 0.1263D-02, 0.1453D-02, 0.1664D-02,
     ,   0.1878D-02, 0.2053D-02, 0.2122D-02, 0.2011D-02, 0.1677D-02,
     ,   0.1135D-02, 0.4538D-03,-0.2856D-03,-0.1022D-02,-0.1715D-02,
     ,  -0.2342D-02,-0.2891D-02,-0.3358D-02,-0.3744D-02,-0.4058D-02,
     ,  -0.4308D-02,-0.4503D-02,-0.4656D-02,-0.4773D-02,-0.4862D-02,
     ,  -0.4930D-02,-0.4981D-02,-0.5019D-02,-0.5047D-02,-0.5069D-02,
     ,  -0.5085D-02,-0.5096D-02,-0.5105D-02,-0.5110D-02,-0.5116D-02,
     ,  -0.5119D-02,-0.5122D-02,-0.5124D-02,-0.5124D-02,-0.5126D-02,
     ,  -0.5126D-02,-0.5126D-02,-0.5127D-02/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.5905D-05, 0.6983D-05, 0.8252D-05, 0.9745D-05, 0.1150D-04,
     ,   0.1356D-04, 0.1599D-04, 0.1882D-04, 0.2215D-04, 0.2603D-04,
     ,   0.3057D-04, 0.3587D-04, 0.4203D-04, 0.4920D-04, 0.5753D-04,
     ,   0.6720D-04, 0.7835D-04, 0.9124D-04, 0.1061D-03, 0.1232D-03,
     ,   0.1427D-03, 0.1651D-03, 0.1906D-03, 0.2196D-03, 0.2527D-03,
     ,   0.2904D-03, 0.3329D-03, 0.3817D-03, 0.4374D-03, 0.5021D-03,
     ,   0.5776D-03, 0.6675D-03, 0.7751D-03, 0.9053D-03, 0.1059D-02,
     ,   0.1231D-02, 0.1403D-02, 0.1534D-02, 0.1567D-02, 0.1445D-02,
     ,   0.1147D-02, 0.6976D-03, 0.1539D-03,-0.4257D-03,-0.9975D-03,
     ,  -0.1536D-02,-0.2022D-02,-0.2447D-02,-0.2804D-02,-0.3100D-02,
     ,  -0.3337D-02,-0.3526D-02,-0.3673D-02,-0.3786D-02,-0.3873D-02,
     ,  -0.3939D-02,-0.3989D-02,-0.4026D-02,-0.4055D-02,-0.4075D-02,
     ,  -0.4092D-02,-0.4102D-02,-0.4111D-02,-0.4117D-02,-0.4122D-02,
     ,  -0.4125D-02,-0.4128D-02,-0.4129D-02,-0.4130D-02,-0.4132D-02,
     ,  -0.4132D-02,-0.4132D-02,-0.4133D-02/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.3218D-05, 0.3807D-05, 0.4503D-05, 0.5321D-05, 0.6282D-05,
     ,   0.7412D-05, 0.8741D-05, 0.1030D-04, 0.1212D-04, 0.1427D-04,
     ,   0.1676D-04, 0.1968D-04, 0.2309D-04, 0.2706D-04, 0.3167D-04,
     ,   0.3702D-04, 0.4323D-04, 0.5040D-04, 0.5869D-04, 0.6821D-04,
     ,   0.7918D-04, 0.9176D-04, 0.1062D-03, 0.1227D-03, 0.1414D-03,
     ,   0.1628D-03, 0.1874D-03, 0.2156D-03, 0.2483D-03, 0.2861D-03,
     ,   0.3312D-03, 0.3856D-03, 0.4523D-03, 0.5352D-03, 0.6376D-03,
     ,   0.7608D-03, 0.8988D-03, 0.1034D-02, 0.1129D-02, 0.1137D-02,
     ,   0.1020D-02, 0.7690D-03, 0.4118D-03,-0.8391D-05,-0.4519D-03,
     ,  -0.8900D-03,-0.1303D-02,-0.1675D-02,-0.1997D-02,-0.2269D-02,
     ,  -0.2491D-02,-0.2669D-02,-0.2810D-02,-0.2919D-02,-0.3003D-02,
     ,  -0.3067D-02,-0.3116D-02,-0.3153D-02,-0.3180D-02,-0.3201D-02,
     ,  -0.3216D-02,-0.3227D-02,-0.3235D-02,-0.3242D-02,-0.3246D-02,
     ,  -0.3250D-02,-0.3252D-02,-0.3253D-02,-0.3255D-02,-0.3255D-02,
     ,  -0.3256D-02,-0.3257D-02,-0.3257D-02/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.1689D-05, 0.1999D-05, 0.2365D-05, 0.2796D-05, 0.3303D-05,
     ,   0.3900D-05, 0.4602D-05, 0.5425D-05, 0.6392D-05, 0.7526D-05,
     ,   0.8851D-05, 0.1040D-04, 0.1221D-04, 0.1432D-04, 0.1678D-04,
     ,   0.1963D-04, 0.2296D-04, 0.2680D-04, 0.3125D-04, 0.3638D-04,
     ,   0.4229D-04, 0.4910D-04, 0.5690D-04, 0.6587D-04, 0.7615D-04,
     ,   0.8789D-04, 0.1015D-03, 0.1172D-03, 0.1352D-03, 0.1568D-03,
     ,   0.1825D-03, 0.2139D-03, 0.2530D-03, 0.3027D-03, 0.3663D-03,
     ,   0.4465D-03, 0.5438D-03, 0.6524D-03, 0.7547D-03, 0.8206D-03,
     ,   0.8141D-03, 0.7096D-03, 0.5079D-03, 0.2328D-03,-0.8491D-04,
     ,  -0.4189D-03,-0.7502D-03,-0.1062D-02,-0.1343D-02,-0.1586D-02,
     ,  -0.1790D-02,-0.1956D-02,-0.2088D-02,-0.2192D-02,-0.2273D-02,
     ,  -0.2334D-02,-0.2381D-02,-0.2417D-02,-0.2444D-02,-0.2464D-02,
     ,  -0.2479D-02,-0.2490D-02,-0.2498D-02,-0.2504D-02,-0.2508D-02,
     ,  -0.2512D-02,-0.2514D-02,-0.2515D-02,-0.2517D-02,-0.2518D-02,
     ,  -0.2518D-02,-0.2519D-02,-0.2519D-02/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.8608D-06, 0.1019D-05, 0.1207D-05, 0.1427D-05, 0.1687D-05,
     ,   0.1993D-05, 0.2354D-05, 0.2776D-05, 0.3273D-05, 0.3857D-05,
     ,   0.4539D-05, 0.5339D-05, 0.6271D-05, 0.7366D-05, 0.8637D-05,
     ,   0.1012D-04, 0.1184D-04, 0.1384D-04, 0.1615D-04, 0.1884D-04,
     ,   0.2194D-04, 0.2551D-04, 0.2962D-04, 0.3436D-04, 0.3980D-04,
     ,   0.4608D-04, 0.5332D-04, 0.6173D-04, 0.7160D-04, 0.8336D-04,
     ,   0.9744D-04, 0.1149D-03, 0.1368D-03, 0.1653D-03, 0.2026D-03,
     ,   0.2513D-03, 0.3138D-03, 0.3898D-03, 0.4731D-03, 0.5484D-03,
     ,   0.5915D-03, 0.5768D-03, 0.4889D-03, 0.3321D-03, 0.1253D-03,
     ,  -0.1113D-03,-0.3601D-03,-0.6070D-03,-0.8407D-03,-0.1051D-02,
     ,  -0.1233D-02,-0.1384D-02,-0.1506D-02,-0.1604D-02,-0.1680D-02,
     ,  -0.1739D-02,-0.1785D-02,-0.1818D-02,-0.1845D-02,-0.1864D-02,
     ,  -0.1878D-02,-0.1889D-02,-0.1897D-02,-0.1903D-02,-0.1907D-02,
     ,  -0.1911D-02,-0.1913D-02,-0.1914D-02,-0.1916D-02,-0.1917D-02,
     ,  -0.1917D-02,-0.1918D-02,-0.1918D-02/
      data (calcpts(j,30), j = 1,neta) /
     ,   0.4297D-06, 0.5087D-06, 0.6024D-06, 0.7129D-06, 0.8432D-06,
     ,   0.9969D-06, 0.1178D-05, 0.1391D-05, 0.1640D-05, 0.1934D-05,
     ,   0.2278D-05, 0.2682D-05, 0.3154D-05, 0.3705D-05, 0.4350D-05,
     ,   0.5100D-05, 0.5978D-05, 0.6995D-05, 0.8175D-05, 0.9546D-05,
     ,   0.1113D-04, 0.1296D-04, 0.1508D-04, 0.1752D-04, 0.2035D-04,
     ,   0.2361D-04, 0.2739D-04, 0.3181D-04, 0.3701D-04, 0.4321D-04,
     ,   0.5079D-04, 0.6018D-04, 0.7219D-04, 0.8787D-04, 0.1088D-03,
     ,   0.1369D-03, 0.1745D-03, 0.2228D-03, 0.2809D-03, 0.3432D-03,
     ,   0.3970D-03, 0.4238D-03, 0.4056D-03, 0.3346D-03, 0.2157D-03,
     ,   0.6268D-04,-0.1108D-03,-0.2941D-03,-0.4774D-03,-0.6506D-03,
     ,  -0.8065D-03,-0.9408D-03,-0.1052D-02,-0.1142D-02,-0.1214D-02,
     ,  -0.1269D-02,-0.1312D-02,-0.1345D-02,-0.1370D-02,-0.1388D-02,
     ,  -0.1403D-02,-0.1413D-02,-0.1421D-02,-0.1426D-02,-0.1431D-02,
     ,  -0.1434D-02,-0.1436D-02,-0.1438D-02,-0.1439D-02,-0.1440D-02,
     ,  -0.1440D-02,-0.1441D-02,-0.1442D-02/
      data (calcpts(j,31), j = 1,neta) /
     ,   0.2110D-06, 0.2500D-06, 0.2962D-06, 0.3507D-06, 0.4152D-06,
     ,   0.4910D-06, 0.5804D-06, 0.6856D-06, 0.8094D-06, 0.9550D-06,
     ,   0.1126D-05, 0.1326D-05, 0.1560D-05, 0.1835D-05, 0.2157D-05,
     ,   0.2532D-05, 0.2969D-05, 0.3479D-05, 0.4070D-05, 0.4759D-05,
     ,   0.5559D-05, 0.6482D-05, 0.7554D-05, 0.8794D-05, 0.1023D-04,
     ,   0.1190D-04, 0.1383D-04, 0.1611D-04, 0.1880D-04, 0.2203D-04,
     ,   0.2598D-04, 0.3095D-04, 0.3732D-04, 0.4570D-04, 0.5715D-04,
     ,   0.7274D-04, 0.9408D-04, 0.1228D-03, 0.1597D-03, 0.2035D-03,
     ,   0.2492D-03, 0.2864D-03, 0.3020D-03, 0.2837D-03, 0.2277D-03,
     ,   0.1396D-03, 0.2807D-04,-0.9836D-04,-0.2326D-03,-0.3674D-03,
     ,  -0.4951D-03,-0.6097D-03,-0.7082D-03,-0.7898D-03,-0.8557D-03,
     ,  -0.9078D-03,-0.9481D-03,-0.9794D-03,-0.1003D-02,-0.1021D-02,
     ,  -0.1034D-02,-0.1044D-02,-0.1052D-02,-0.1057D-02,-0.1062D-02,
     ,  -0.1065D-02,-0.1067D-02,-0.1069D-02,-0.1070D-02,-0.1071D-02,
     ,  -0.1071D-02,-0.1071D-02,-0.1072D-02/
      data (calcpts(j,32), j = 1,neta) /
     ,   0.1025D-06, 0.1215D-06, 0.1440D-06, 0.1706D-06, 0.2020D-06,
     ,   0.2391D-06, 0.2828D-06, 0.3342D-06, 0.3948D-06, 0.4661D-06,
     ,   0.5498D-06, 0.6483D-06, 0.7634D-06, 0.8986D-06, 0.1057D-05,
     ,   0.1242D-05, 0.1458D-05, 0.1710D-05, 0.2004D-05, 0.2344D-05,
     ,   0.2743D-05, 0.3203D-05, 0.3737D-05, 0.4358D-05, 0.5079D-05,
     ,   0.5919D-05, 0.6898D-05, 0.8054D-05, 0.9426D-05, 0.1108D-04,
     ,   0.1311D-04, 0.1567D-04, 0.1899D-04, 0.2341D-04, 0.2946D-04,
     ,   0.3785D-04, 0.4959D-04, 0.6586D-04, 0.8770D-04, 0.1156D-03,
     ,   0.1480D-03, 0.1809D-03, 0.2061D-03, 0.2142D-03, 0.1978D-03,
     ,   0.1548D-03, 0.8989D-04, 0.9291D-05,-0.8217D-04,-0.1799D-03,
     ,  -0.2785D-03,-0.3719D-03,-0.4558D-03,-0.5276D-03,-0.5870D-03,
     ,  -0.6348D-03,-0.6723D-03,-0.7017D-03,-0.7242D-03,-0.7412D-03,
     ,  -0.7542D-03,-0.7639D-03,-0.7711D-03,-0.7766D-03,-0.7805D-03,
     ,  -0.7835D-03,-0.7856D-03,-0.7872D-03,-0.7884D-03,-0.7893D-03,
     ,  -0.7898D-03,-0.7902D-03,-0.7906D-03/
      data (calcpts(j,33), j = 1,neta) /
     ,   0.4938D-07, 0.5858D-07, 0.6946D-07, 0.8232D-07, 0.9753D-07,
     ,   0.1155D-06, 0.1367D-06, 0.1617D-06, 0.1911D-06, 0.2257D-06,
     ,   0.2665D-06, 0.3143D-06, 0.3704D-06, 0.4365D-06, 0.5138D-06,
     ,   0.6041D-06, 0.7100D-06, 0.8336D-06, 0.9776D-06, 0.1146D-05,
     ,   0.1341D-05, 0.1569D-05, 0.1834D-05, 0.2141D-05, 0.2501D-05,
     ,   0.2919D-05, 0.3409D-05, 0.3989D-05, 0.4680D-05, 0.5515D-05,
     ,   0.6546D-05, 0.7854D-05, 0.9554D-05, 0.1184D-04, 0.1499D-04,
     ,   0.1941D-04, 0.2571D-04, 0.3459D-04, 0.4694D-04, 0.6346D-04,
     ,   0.8427D-04, 0.1079D-03, 0.1312D-03, 0.1480D-03, 0.1517D-03,
     ,   0.1374D-03, 0.1050D-03, 0.5792D-04,-0.4216D-07,-0.6582D-04,
     ,  -0.1365D-03,-0.2082D-03,-0.2762D-03,-0.3372D-03,-0.3894D-03,
     ,  -0.4323D-03,-0.4669D-03,-0.4941D-03,-0.5151D-03,-0.5314D-03,
     ,  -0.5437D-03,-0.5529D-03,-0.5598D-03,-0.5650D-03,-0.5690D-03,
     ,  -0.5717D-03,-0.5738D-03,-0.5754D-03,-0.5765D-03,-0.5774D-03,
     ,  -0.5780D-03,-0.5784D-03,-0.5787D-03/
      data (calcpts(j,34), j = 1,neta) /
     ,   0.2367D-07, 0.2808D-07, 0.3332D-07, 0.3952D-07, 0.4682D-07,
     ,   0.5546D-07, 0.6567D-07, 0.7773D-07, 0.9189D-07, 0.1087D-06,
     ,   0.1283D-06, 0.1516D-06, 0.1787D-06, 0.2108D-06, 0.2482D-06,
     ,   0.2922D-06, 0.3436D-06, 0.4038D-06, 0.4742D-06, 0.5562D-06,
     ,   0.6520D-06, 0.7635D-06, 0.8935D-06, 0.1045D-05, 0.1222D-05,
     ,   0.1430D-05, 0.1672D-05, 0.1960D-05, 0.2305D-05, 0.2724D-05,
     ,   0.3243D-05, 0.3903D-05, 0.4765D-05, 0.5930D-05, 0.7545D-05,
     ,   0.9835D-05, 0.1313D-04, 0.1787D-04, 0.2460D-04, 0.3393D-04,
     ,   0.4630D-04, 0.6162D-04, 0.7873D-04, 0.9493D-04, 0.1059D-03,
     ,   0.1070D-03, 0.9526D-04, 0.7108D-04, 0.3708D-04,-0.4324D-05,
     ,  -0.5142D-04,-0.1025D-03,-0.1542D-03,-0.2036D-03,-0.2478D-03,
     ,  -0.2855D-03,-0.3166D-03,-0.3414D-03,-0.3610D-03,-0.3761D-03,
     ,  -0.3880D-03,-0.3965D-03,-0.4031D-03,-0.4081D-03,-0.4118D-03,
     ,  -0.4146D-03,-0.4166D-03,-0.4181D-03,-0.4192D-03,-0.4200D-03,
     ,  -0.4206D-03,-0.4210D-03,-0.4213D-03/
      data (calcpts(j,35), j = 1,neta) /
     ,   0.1130D-07, 0.1341D-07, 0.1592D-07, 0.1888D-07, 0.2240D-07,
     ,   0.2654D-07, 0.3144D-07, 0.3722D-07, 0.4405D-07, 0.5209D-07,
     ,   0.6159D-07, 0.7273D-07, 0.8589D-07, 0.1013D-06, 0.1195D-06,
     ,   0.1407D-06, 0.1656D-06, 0.1948D-06, 0.2289D-06, 0.2688D-06,
     ,   0.3154D-06, 0.3699D-06, 0.4334D-06, 0.5076D-06, 0.5947D-06,
     ,   0.6965D-06, 0.8162D-06, 0.9585D-06, 0.1130D-05, 0.1337D-05,
     ,   0.1597D-05, 0.1926D-05, 0.2360D-05, 0.2948D-05, 0.3767D-05,
     ,   0.4938D-05, 0.6634D-05, 0.9107D-05, 0.1269D-04, 0.1778D-04,
     ,   0.2478D-04, 0.3395D-04, 0.4513D-04, 0.5735D-04, 0.6853D-04,
     ,   0.7557D-04, 0.7529D-04, 0.6592D-04, 0.4810D-04, 0.2369D-04,
     ,  -0.5770D-05,-0.3944D-04,-0.7606D-04,-0.1135D-03,-0.1491D-03,
     ,  -0.1810D-03,-0.2081D-03,-0.2304D-03,-0.2483D-03,-0.2624D-03,
     ,  -0.2732D-03,-0.2815D-03,-0.2878D-03,-0.2925D-03,-0.2960D-03,
     ,  -0.2986D-03,-0.3006D-03,-0.3021D-03,-0.3031D-03,-0.3039D-03,
     ,  -0.3045D-03,-0.3049D-03,-0.3052D-03/
      data (calcpts(j,36), j = 1,neta) /
     ,   0.5378D-08, 0.6387D-08, 0.7582D-08, 0.8998D-08, 0.1068D-07,
     ,   0.1266D-07, 0.1501D-07, 0.1777D-07, 0.2105D-07, 0.2490D-07,
     ,   0.2945D-07, 0.3481D-07, 0.4113D-07, 0.4854D-07, 0.5726D-07,
     ,   0.6753D-07, 0.7953D-07, 0.9362D-07, 0.1102D-06, 0.1295D-06,
     ,   0.1521D-06, 0.1785D-06, 0.2094D-06, 0.2456D-06, 0.2880D-06,
     ,   0.3378D-06, 0.3966D-06, 0.4667D-06, 0.5510D-06, 0.6539D-06,
     ,   0.7822D-06, 0.9466D-06, 0.1163D-05, 0.1457D-05, 0.1869D-05,
     ,   0.2461D-05, 0.3325D-05, 0.4597D-05, 0.6463D-05, 0.9167D-05,
     ,   0.1299D-04, 0.1820D-04, 0.2495D-04, 0.3305D-04, 0.4171D-04,
     ,   0.4936D-04, 0.5381D-04, 0.5285D-04, 0.4558D-04, 0.3252D-04,
     ,   0.1512D-04,-0.5823D-05,-0.2983D-04,-0.5600D-04,-0.8290D-04,
     ,  -0.1085D-03,-0.1314D-03,-0.1510D-03,-0.1669D-03,-0.1797D-03,
     ,  -0.1898D-03,-0.1975D-03,-0.2034D-03,-0.2079D-03,-0.2113D-03,
     ,  -0.2138D-03,-0.2157D-03,-0.2171D-03,-0.2181D-03,-0.2189D-03,
     ,  -0.2194D-03,-0.2198D-03,-0.2201D-03/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.2554D-08, 0.3036D-08, 0.3604D-08, 0.4279D-08, 0.5078D-08,
     ,   0.6026D-08, 0.7145D-08, 0.8465D-08, 0.1003D-07, 0.1188D-07,
     ,   0.1405D-07, 0.1662D-07, 0.1965D-07, 0.2321D-07, 0.2740D-07,
     ,   0.3233D-07, 0.3810D-07, 0.4489D-07, 0.5284D-07, 0.6221D-07,
     ,   0.7312D-07, 0.8592D-07, 0.1009D-06, 0.1185D-06, 0.1391D-06,
     ,   0.1634D-06, 0.1922D-06, 0.2264D-06, 0.2678D-06, 0.3184D-06,
     ,   0.3815D-06, 0.4626D-06, 0.5698D-06, 0.7163D-06, 0.9219D-06,
     ,   0.1219D-05, 0.1655D-05, 0.2302D-05, 0.3260D-05, 0.4669D-05,
     ,   0.6702D-05, 0.9556D-05, 0.1341D-04, 0.1834D-04, 0.2415D-04,
     ,   0.3025D-04, 0.3547D-04, 0.3821D-04, 0.3706D-04, 0.3146D-04,
     ,   0.2199D-04, 0.9615D-05,-0.5225D-05,-0.2227D-04,-0.4101D-04,
     ,  -0.6026D-04,-0.7866D-04,-0.9505D-04,-0.1091D-03,-0.1205D-03,
     ,  -0.1296D-03,-0.1368D-03,-0.1423D-03,-0.1465D-03,-0.1497D-03,
     ,  -0.1521D-03,-0.1539D-03,-0.1552D-03,-0.1562D-03,-0.1570D-03,
     ,  -0.1574D-03,-0.1579D-03,-0.1582D-03/
      data (calcpts(j,38), j = 1,neta) /
     ,   0.1211D-08, 0.1440D-08, 0.1711D-08, 0.2032D-08, 0.2412D-08,
     ,   0.2864D-08, 0.3396D-08, 0.4028D-08, 0.4773D-08, 0.5654D-08,
     ,   0.6696D-08, 0.7923D-08, 0.9370D-08, 0.1108D-07, 0.1309D-07,
     ,   0.1545D-07, 0.1822D-07, 0.2150D-07, 0.2532D-07, 0.2983D-07,
     ,   0.3508D-07, 0.4126D-07, 0.4853D-07, 0.5705D-07, 0.6704D-07,
     ,   0.7885D-07, 0.9285D-07, 0.1096D-06, 0.1298D-06, 0.1546D-06,
     ,   0.1856D-06, 0.2255D-06, 0.2784D-06, 0.3508D-06, 0.4528D-06,
     ,   0.6010D-06, 0.8189D-06, 0.1145D-05, 0.1632D-05, 0.2356D-05,
     ,   0.3417D-05, 0.4938D-05, 0.7055D-05, 0.9881D-05, 0.1345D-04,
     ,   0.1761D-04, 0.2188D-04, 0.2541D-04, 0.2708D-04, 0.2596D-04,
     ,   0.2172D-04, 0.1485D-04, 0.6070D-05,-0.4389D-05,-0.1649D-04,
     ,  -0.2986D-04,-0.4363D-04,-0.5677D-04,-0.6852D-04,-0.7853D-04,
     ,  -0.8667D-04,-0.9320D-04,-0.9825D-04,-0.1022D-03,-0.1052D-03,
     ,  -0.1074D-03,-0.1092D-03,-0.1104D-03,-0.1113D-03,-0.1121D-03,
     ,  -0.1126D-03,-0.1129D-03,-0.1132D-03/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.5736D-09, 0.6823D-09, 0.8109D-09, 0.9635D-09, 0.1144D-08,
     ,   0.1359D-08, 0.1612D-08, 0.1913D-08, 0.2268D-08, 0.2688D-08,
     ,   0.3184D-08, 0.3772D-08, 0.4463D-08, 0.5278D-08, 0.6240D-08,
     ,   0.7372D-08, 0.8704D-08, 0.1027D-07, 0.1211D-07, 0.1427D-07,
     ,   0.1681D-07, 0.1980D-07, 0.2329D-07, 0.2740D-07, 0.3225D-07,
     ,   0.3797D-07, 0.4477D-07, 0.5289D-07, 0.6277D-07, 0.7486D-07,
     ,   0.9007D-07, 0.1097D-06, 0.1357D-06, 0.1713D-06, 0.2217D-06,
     ,   0.2950D-06, 0.4034D-06, 0.5663D-06, 0.8119D-06, 0.1179D-05,
     ,   0.1723D-05, 0.2518D-05, 0.3649D-05, 0.5209D-05, 0.7271D-05,
     ,   0.9847D-05, 0.1280D-04, 0.1578D-04, 0.1817D-04, 0.1919D-04,
     ,   0.1816D-04, 0.1499D-04, 0.1006D-04, 0.3839D-05,-0.3542D-05,
     ,  -0.1211D-04,-0.2162D-04,-0.3143D-04,-0.4082D-04,-0.4919D-04,
     ,  -0.5631D-04,-0.6212D-04,-0.6675D-04,-0.7036D-04,-0.7315D-04,
     ,  -0.7527D-04,-0.7689D-04,-0.7808D-04,-0.7900D-04,-0.7963D-04,
     ,  -0.8016D-04,-0.8047D-04,-0.8077D-04/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.2715D-09, 0.3230D-09, 0.3841D-09, 0.4566D-09, 0.5425D-09,
     ,   0.6443D-09, 0.7651D-09, 0.9080D-09, 0.1077D-08, 0.1277D-08,
     ,   0.1514D-08, 0.1792D-08, 0.2124D-08, 0.2512D-08, 0.2972D-08,
     ,   0.3514D-08, 0.4151D-08, 0.4901D-08, 0.5783D-08, 0.6820D-08,
     ,   0.8040D-08, 0.9476D-08, 0.1116D-07, 0.1315D-07, 0.1547D-07,
     ,   0.1825D-07, 0.2154D-07, 0.2550D-07, 0.3029D-07, 0.3617D-07,
     ,   0.4360D-07, 0.5317D-07, 0.6591D-07, 0.8340D-07, 0.1082D-06,
     ,   0.1443D-06, 0.1978D-06, 0.2790D-06, 0.4016D-06, 0.5864D-06,
     ,   0.8628D-06, 0.1272D-05, 0.1863D-05, 0.2699D-05, 0.3838D-05,
     ,   0.5334D-05, 0.7186D-05, 0.9279D-05, 0.1136D-04, 0.1296D-04,
     ,   0.1355D-04, 0.1269D-04, 0.1033D-04, 0.6793D-05, 0.2396D-05,
     ,  -0.2799D-05,-0.8850D-05,-0.1560D-04,-0.2259D-04,-0.2928D-04,
     ,  -0.3524D-04,-0.4030D-04,-0.4443D-04,-0.4772D-04,-0.5028D-04,
     ,  -0.5225D-04,-0.5376D-04,-0.5489D-04,-0.5574D-04,-0.5639D-04,
     ,  -0.5685D-04,-0.5720D-04,-0.5745D-04/
      data (calcpts(j,41), j = 1,neta) /
     ,   0.1284D-09, 0.1528D-09, 0.1818D-09, 0.2162D-09, 0.2570D-09,
     ,   0.3053D-09, 0.3626D-09, 0.4306D-09, 0.5110D-09, 0.6061D-09,
     ,   0.7189D-09, 0.8521D-09, 0.1009D-08, 0.1195D-08, 0.1414D-08,
     ,   0.1673D-08, 0.1977D-08, 0.2337D-08, 0.2759D-08, 0.3257D-08,
     ,   0.3841D-08, 0.4531D-08, 0.5342D-08, 0.6295D-08, 0.7425D-08,
     ,   0.8761D-08, 0.1036D-07, 0.1226D-07, 0.1459D-07, 0.1746D-07,
     ,   0.2106D-07, 0.2573D-07, 0.3194D-07, 0.4049D-07, 0.5265D-07,
     ,   0.7040D-07, 0.9685D-07, 0.1369D-06, 0.1979D-06, 0.2902D-06,
     ,   0.4294D-06, 0.6368D-06, 0.9406D-06, 0.1379D-05, 0.1991D-05,
     ,   0.2822D-05, 0.3903D-05, 0.5227D-05, 0.6700D-05, 0.8144D-05,
     ,   0.9227D-05, 0.9557D-05, 0.8855D-05, 0.7122D-05, 0.4588D-05,
     ,   0.1485D-05,-0.2166D-05,-0.6443D-05,-0.1123D-04,-0.1620D-04,
     ,  -0.2095D-04,-0.2519D-04,-0.2877D-04,-0.3171D-04,-0.3404D-04,
     ,  -0.3585D-04,-0.3725D-04,-0.3831D-04,-0.3911D-04,-0.3973D-04,
     ,  -0.4016D-04,-0.4050D-04,-0.4074D-04/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.6073D-10, 0.7226D-10, 0.8600D-10, 0.1023D-09, 0.1217D-09,
     ,   0.1445D-09, 0.1718D-09, 0.2041D-09, 0.2423D-09, 0.2875D-09,
     ,   0.3411D-09, 0.4043D-09, 0.4793D-09, 0.5681D-09, 0.6725D-09,
     ,   0.7955D-09, 0.9414D-09, 0.1113D-08, 0.1315D-08, 0.1553D-08,
     ,   0.1833D-08, 0.2164D-08, 0.2553D-08, 0.3013D-08, 0.3556D-08,
     ,   0.4199D-08, 0.4971D-08, 0.5889D-08, 0.7019D-08, 0.8407D-08,
     ,   0.1015D-07, 0.1243D-07, 0.1545D-07, 0.1963D-07, 0.2557D-07,
     ,   0.3425D-07, 0.4724D-07, 0.6695D-07, 0.9702D-07, 0.1429D-06,
     ,   0.2125D-06, 0.3171D-06, 0.4719D-06, 0.6972D-06, 0.1019D-05,
     ,   0.1467D-05, 0.2069D-05, 0.2848D-05, 0.3788D-05, 0.4832D-05,
     ,   0.5832D-05, 0.6556D-05, 0.6735D-05, 0.6182D-05, 0.4908D-05,
     ,   0.3101D-05, 0.9191D-06,-0.1647D-05,-0.4664D-05,-0.8057D-05,
     ,  -0.1157D-04,-0.1494D-04,-0.1795D-04,-0.2050D-04,-0.2257D-04,
     ,  -0.2422D-04,-0.2551D-04,-0.2649D-04,-0.2724D-04,-0.2782D-04,
     ,  -0.2823D-04,-0.2855D-04,-0.2879D-04/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.2868D-10, 0.3416D-10, 0.4065D-10, 0.4837D-10, 0.5751D-10,
     ,   0.6840D-10, 0.8133D-10, 0.9664D-10, 0.1148D-09, 0.1363D-09,
     ,   0.1617D-09, 0.1919D-09, 0.2275D-09, 0.2697D-09, 0.3196D-09,
     ,   0.3782D-09, 0.4478D-09, 0.5297D-09, 0.6264D-09, 0.7402D-09,
     ,   0.8746D-09, 0.1033D-08, 0.1219D-08, 0.1440D-08, 0.1701D-08,
     ,   0.2011D-08, 0.2381D-08, 0.2828D-08, 0.3368D-08, 0.4042D-08,
     ,   0.4889D-08, 0.5990D-08, 0.7464D-08, 0.9492D-08, 0.1238D-07,
     ,   0.1663D-07, 0.2298D-07, 0.3265D-07, 0.4744D-07, 0.7012D-07,
     ,   0.1047D-06, 0.1569D-06, 0.2349D-06, 0.3497D-06, 0.5158D-06,
     ,   0.7512D-06, 0.1077D-05, 0.1512D-05, 0.2068D-05, 0.2739D-05,
     ,   0.3473D-05, 0.4166D-05, 0.4650D-05, 0.4739D-05, 0.4309D-05,
     ,   0.3382D-05, 0.2099D-05, 0.5594D-06,-0.1243D-05,-0.3364D-05,
     ,  -0.5765D-05,-0.8255D-05,-0.1064D-04,-0.1277D-04,-0.1458D-04,
     ,  -0.1604D-04,-0.1721D-04,-0.1811D-04,-0.1881D-04,-0.1934D-04,
     ,  -0.1974D-04,-0.2004D-04,-0.2025D-04/
      data (calcpts(j,44), j = 1,neta) /
     ,   0.1355D-10, 0.1613D-10, 0.1921D-10, 0.2288D-10, 0.2720D-10,
     ,   0.3237D-10, 0.3849D-10, 0.4576D-10, 0.5437D-10, 0.6457D-10,
     ,   0.7667D-10, 0.9098D-10, 0.1079D-09, 0.1280D-09, 0.1517D-09,
     ,   0.1797D-09, 0.2128D-09, 0.2519D-09, 0.2980D-09, 0.3524D-09,
     ,   0.4167D-09, 0.4925D-09, 0.5818D-09, 0.6875D-09, 0.8131D-09,
     ,   0.9621D-09, 0.1140D-08, 0.1355D-08, 0.1617D-08, 0.1941D-08,
     ,   0.2352D-08, 0.2884D-08, 0.3598D-08, 0.4585D-08, 0.5991D-08,
     ,   0.8056D-08, 0.1116D-07, 0.1588D-07, 0.2314D-07, 0.3430D-07,
     ,   0.5138D-07, 0.7734D-07, 0.1164D-06, 0.1742D-06, 0.2589D-06,
     ,   0.3806D-06, 0.5521D-06, 0.7875D-06, 0.1101D-05, 0.1498D-05,
     ,   0.1974D-05, 0.2490D-05, 0.2969D-05, 0.3293D-05, 0.3332D-05,
     ,   0.3002D-05, 0.2331D-05, 0.1415D-05, 0.3345D-06,-0.9307D-06,
     ,  -0.2424D-05,-0.4113D-05,-0.5877D-05,-0.7567D-05,-0.9071D-05,
     ,  -0.1035D-04,-0.1138D-04,-0.1220D-04,-0.1284D-04,-0.1333D-04,
     ,  -0.1371D-04,-0.1398D-04,-0.1420D-04/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.6396D-11, 0.7619D-11, 0.9074D-11, 0.1080D-10, 0.1286D-10,
     ,   0.1530D-10, 0.1821D-10, 0.2164D-10, 0.2574D-10, 0.3058D-10,
     ,   0.3631D-10, 0.4312D-10, 0.5119D-10, 0.6071D-10, 0.7199D-10,
     ,   0.8533D-10, 0.1011D-09, 0.1197D-09, 0.1417D-09, 0.1678D-09,
     ,   0.1983D-09, 0.2346D-09, 0.2775D-09, 0.3281D-09, 0.3881D-09,
     ,   0.4598D-09, 0.5454D-09, 0.6488D-09, 0.7749D-09, 0.9313D-09,
     ,   0.1129D-08, 0.1387D-08, 0.1732D-08, 0.2210D-08, 0.2892D-08,
     ,   0.3896D-08, 0.5406D-08, 0.7712D-08, 0.1126D-07, 0.1674D-07,
     ,   0.2514D-07, 0.3798D-07, 0.5738D-07, 0.8633D-07, 0.1291D-06,
     ,   0.1912D-06, 0.2800D-06, 0.4043D-06, 0.5740D-06, 0.7986D-06,
     ,   0.1082D-05, 0.1419D-05, 0.1780D-05, 0.2113D-05, 0.2330D-05,
     ,   0.2341D-05, 0.2092D-05, 0.1606D-05, 0.9590D-06, 0.1999D-06,
     ,  -0.6855D-06,-0.1735D-05,-0.2927D-05,-0.4172D-05,-0.5365D-05,
     ,  -0.6428D-05,-0.7325D-05,-0.8056D-05,-0.8640D-05,-0.9087D-05,
     ,  -0.9435D-05,-0.9692D-05,-0.9890D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.3018D-11, 0.3597D-11, 0.4286D-11, 0.5104D-11, 0.6076D-11,
     ,   0.7233D-11, 0.8603D-11, 0.1023D-10, 0.1218D-10, 0.1447D-10,
     ,   0.1720D-10, 0.2042D-10, 0.2424D-10, 0.2878D-10, 0.3415D-10,
     ,   0.4050D-10, 0.4801D-10, 0.5688D-10, 0.6736D-10, 0.7976D-10,
     ,   0.9444D-10, 0.1117D-09, 0.1322D-09, 0.1564D-09, 0.1853D-09,
     ,   0.2195D-09, 0.2606D-09, 0.3103D-09, 0.3710D-09, 0.4462D-09,
     ,   0.5417D-09, 0.6660D-09, 0.8327D-09, 0.1064D-08, 0.1395D-08,
     ,   0.1880D-08, 0.2613D-08, 0.3737D-08, 0.5465D-08, 0.8141D-08,
     ,   0.1227D-07, 0.1858D-07, 0.2817D-07, 0.4258D-07, 0.6397D-07,
     ,   0.9536D-07, 0.1406D-06, 0.2052D-06, 0.2950D-06, 0.4171D-06,
     ,   0.5776D-06, 0.7793D-06, 0.1017D-05, 0.1271D-05, 0.1500D-05,
     ,   0.1645D-05, 0.1642D-05, 0.1457D-05, 0.1106D-05, 0.6469D-06,
     ,   0.1155D-06,-0.5051D-06,-0.1242D-05,-0.2081D-05,-0.2960D-05,
     ,  -0.3801D-05,-0.4551D-05,-0.5185D-05,-0.5699D-05,-0.6107D-05,
     ,  -0.6424D-05,-0.6667D-05,-0.6851D-05/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.1424D-11, 0.1698D-11, 0.2023D-11, 0.2410D-11, 0.2870D-11,
     ,   0.3418D-11, 0.4068D-11, 0.4841D-11, 0.5758D-11, 0.6845D-11,
     ,   0.8138D-11, 0.9665D-11, 0.1148D-10, 0.1364D-10, 0.1619D-10,
     ,   0.1920D-10, 0.2278D-10, 0.2700D-10, 0.3200D-10, 0.3790D-10,
     ,   0.4489D-10, 0.5315D-10, 0.6293D-10, 0.7454D-10, 0.8828D-10,
     ,   0.1047D-09, 0.1244D-09, 0.1483D-09, 0.1774D-09, 0.2136D-09,
     ,   0.2596D-09, 0.3195D-09, 0.3997D-09, 0.5113D-09, 0.6711D-09,
     ,   0.9065D-09, 0.1263D-08, 0.1806D-08, 0.2647D-08, 0.3954D-08,
     ,   0.5971D-08, 0.9071D-08, 0.1379D-07, 0.2091D-07, 0.3156D-07,
     ,   0.4726D-07, 0.7020D-07, 0.1032D-06, 0.1498D-06, 0.2145D-06,
     ,   0.3019D-06, 0.4164D-06, 0.5595D-06, 0.7273D-06, 0.9054D-06,
     ,   0.1063D-05, 0.1161D-05, 0.1151D-05, 0.1013D-05, 0.7611D-06,
     ,   0.4367D-06, 0.6399D-07,-0.3697D-06,-0.8870D-06,-0.1477D-05,
     ,  -0.2096D-05,-0.2689D-05,-0.3218D-05,-0.3663D-05,-0.4026D-05,
     ,  -0.4313D-05,-0.4536D-05,-0.4706D-05/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.6718D-12, 0.8011D-12, 0.9546D-12, 0.1138D-11, 0.1355D-11,
     ,   0.1614D-11, 0.1922D-11, 0.2288D-11, 0.2722D-11, 0.3238D-11,
     ,   0.3851D-11, 0.4577D-11, 0.5438D-11, 0.6461D-11, 0.7669D-11,
     ,   0.9107D-11, 0.1080D-10, 0.1281D-10, 0.1519D-10, 0.1801D-10,
     ,   0.2134D-10, 0.2528D-10, 0.2995D-10, 0.3548D-10, 0.4206D-10,
     ,   0.4995D-10, 0.5933D-10, 0.7080D-10, 0.8480D-10, 0.1022D-09,
     ,   0.1242D-09, 0.1531D-09, 0.1918D-09, 0.2456D-09, 0.3226D-09,
     ,   0.4364D-09, 0.6083D-09, 0.8722D-09, 0.1281D-08, 0.1916D-08,
     ,   0.2899D-08, 0.4411D-08, 0.6735D-08, 0.1024D-07, 0.1550D-07,
     ,   0.2333D-07, 0.3484D-07, 0.5149D-07, 0.7534D-07, 0.1090D-06,
     ,   0.1554D-06, 0.2180D-06, 0.2994D-06, 0.4008D-06, 0.5193D-06,
     ,   0.6437D-06, 0.7528D-06, 0.8173D-06, 0.8061D-06, 0.7041D-06,
     ,   0.5238D-06, 0.2951D-06, 0.3417D-07,-0.2688D-06,-0.6311D-06,
     ,  -0.1046D-05,-0.1482D-05,-0.1899D-05,-0.2272D-05,-0.2585D-05,
     ,  -0.2840D-05,-0.3041D-05,-0.3197D-05/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.3167D-12, 0.3777D-12, 0.4504D-12, 0.5369D-12, 0.6398D-12,
     ,   0.7620D-12, 0.9079D-12, 0.1081D-11, 0.1286D-11, 0.1531D-11,
     ,   0.1821D-11, 0.2165D-11, 0.2574D-11, 0.3059D-11, 0.3632D-11,
     ,   0.4314D-11, 0.5120D-11, 0.6077D-11, 0.7207D-11, 0.8546D-11,
     ,   0.1013D-10, 0.1201D-10, 0.1424D-10, 0.1688D-10, 0.2003D-10,
     ,   0.2379D-10, 0.2829D-10, 0.3379D-10, 0.4044D-10, 0.4881D-10,
     ,   0.5941D-10, 0.7327D-10, 0.9187D-10, 0.1177D-09, 0.1549D-09,
     ,   0.2098D-09, 0.2928D-09, 0.4204D-09, 0.6184D-09, 0.9265D-09,
     ,   0.1405D-08, 0.2143D-08, 0.3279D-08, 0.4997D-08, 0.7600D-08,
     ,   0.1147D-07, 0.1720D-07, 0.2556D-07, 0.3764D-07, 0.5485D-07,
     ,   0.7895D-07, 0.1122D-06, 0.1569D-06, 0.2148D-06, 0.2865D-06,
     ,   0.3698D-06, 0.4566D-06, 0.5320D-06, 0.5751D-06, 0.5641D-06,
     ,   0.4893D-06, 0.3607D-06, 0.1996D-06, 0.1691D-07,-0.1948D-06,
     ,  -0.4492D-06,-0.7403D-06,-0.1046D-05,-0.1340D-05,-0.1601D-05,
     ,  -0.1822D-05,-0.2001D-05,-0.2142D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c-----------------------------
      subroutine clhqg20p(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.3581D-08,-0.4337D-08,-0.5255D-08,-0.6365D-08,-0.7710D-08,
     ,  -0.9337D-08,-0.1131D-07,-0.1369D-07,-0.1657D-07,-0.2005D-07,
     ,  -0.2424D-07,-0.2929D-07,-0.3535D-07,-0.4260D-07,-0.5122D-07,
     ,  -0.6144D-07,-0.7341D-07,-0.8725D-07,-0.1030D-06,-0.1203D-06,
     ,  -0.1386D-06,-0.1567D-06,-0.1720D-06,-0.1807D-06,-0.1766D-06,
     ,  -0.1505D-06,-0.8937D-07, 0.2287D-07, 0.2032D-06, 0.4634D-06,
     ,   0.7971D-06, 0.1165D-05, 0.1477D-05, 0.1612D-05, 0.1464D-05,
     ,   0.1039D-05, 0.4915D-06, 0.4603D-07,-0.1532D-06,-0.1119D-06,
     ,   0.7092D-07, 0.2952D-06, 0.5002D-06, 0.6663D-06, 0.7950D-06,
     ,   0.8929D-06, 0.9672D-06, 0.1025D-05, 0.1069D-05, 0.1102D-05,
     ,   0.1126D-05, 0.1145D-05, 0.1158D-05, 0.1168D-05, 0.1176D-05,
     ,   0.1181D-05, 0.1185D-05, 0.1188D-05, 0.1189D-05, 0.1191D-05,
     ,   0.1192D-05, 0.1193D-05, 0.1193D-05, 0.1193D-05, 0.1194D-05,
     ,   0.1194D-05, 0.1194D-05, 0.1194D-05, 0.1194D-05, 0.1194D-05,
     ,   0.1194D-05, 0.1194D-05, 0.1194D-05/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.5253D-08,-0.6364D-08,-0.7708D-08,-0.9338D-08,-0.1131D-07,
     ,  -0.1370D-07,-0.1659D-07,-0.2009D-07,-0.2431D-07,-0.2941D-07,
     ,  -0.3557D-07,-0.4297D-07,-0.5186D-07,-0.6250D-07,-0.7516D-07,
     ,  -0.9015D-07,-0.1077D-06,-0.1280D-06,-0.1511D-06,-0.1765D-06,
     ,  -0.2034D-06,-0.2299D-06,-0.2524D-06,-0.2652D-06,-0.2593D-06,
     ,  -0.2209D-06,-0.1311D-06, 0.3345D-07, 0.2980D-06, 0.6802D-06,
     ,   0.1170D-05, 0.1710D-05, 0.2169D-05, 0.2365D-05, 0.2148D-05,
     ,   0.1525D-05, 0.7272D-06, 0.7053D-07,-0.2243D-06,-0.1637D-06,
     ,   0.1057D-06, 0.4349D-06, 0.7350D-06, 0.9780D-06, 0.1166D-05,
     ,   0.1311D-05, 0.1420D-05, 0.1504D-05, 0.1568D-05, 0.1616D-05,
     ,   0.1653D-05, 0.1680D-05, 0.1700D-05, 0.1715D-05, 0.1726D-05,
     ,   0.1733D-05, 0.1739D-05, 0.1742D-05, 0.1746D-05, 0.1747D-05,
     ,   0.1749D-05, 0.1750D-05, 0.1750D-05, 0.1751D-05, 0.1752D-05,
     ,   0.1751D-05, 0.1752D-05, 0.1752D-05, 0.1752D-05, 0.1752D-05,
     ,   0.1752D-05, 0.1752D-05, 0.1752D-05/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.7703D-08,-0.9333D-08,-0.1131D-07,-0.1370D-07,-0.1659D-07,
     ,  -0.2009D-07,-0.2433D-07,-0.2946D-07,-0.3566D-07,-0.4314D-07,
     ,  -0.5216D-07,-0.6302D-07,-0.7606D-07,-0.9167D-07,-0.1102D-06,
     ,  -0.1322D-06,-0.1580D-06,-0.1877D-06,-0.2215D-06,-0.2589D-06,
     ,  -0.2983D-06,-0.3371D-06,-0.3701D-06,-0.3889D-06,-0.3801D-06,
     ,  -0.3237D-06,-0.1921D-06, 0.4943D-07, 0.4374D-06, 0.9979D-06,
     ,   0.1717D-05, 0.2508D-05, 0.3181D-05, 0.3469D-05, 0.3152D-05,
     ,   0.2236D-05, 0.1061D-05, 0.9610D-07,-0.3349D-06,-0.2389D-06,
     ,   0.1536D-06, 0.6361D-06, 0.1077D-05, 0.1434D-05, 0.1711D-05,
     ,   0.1922D-05, 0.2084D-05, 0.2207D-05, 0.2301D-05, 0.2373D-05,
     ,   0.2426D-05, 0.2466D-05, 0.2496D-05, 0.2517D-05, 0.2533D-05,
     ,   0.2544D-05, 0.2552D-05, 0.2558D-05, 0.2563D-05, 0.2565D-05,
     ,   0.2567D-05, 0.2569D-05, 0.2570D-05, 0.2571D-05, 0.2571D-05,
     ,   0.2572D-05, 0.2572D-05, 0.2572D-05, 0.2572D-05, 0.2572D-05,
     ,   0.2572D-05, 0.2572D-05, 0.2572D-05/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.1130D-07,-0.1369D-07,-0.1658D-07,-0.2008D-07,-0.2433D-07,
     ,  -0.2946D-07,-0.3568D-07,-0.4319D-07,-0.5228D-07,-0.6326D-07,
     ,  -0.7649D-07,-0.9242D-07,-0.1115D-06,-0.1344D-06,-0.1616D-06,
     ,  -0.1939D-06,-0.2316D-06,-0.2753D-06,-0.3248D-06,-0.3796D-06,
     ,  -0.4375D-06,-0.4942D-06,-0.5428D-06,-0.5704D-06,-0.5574D-06,
     ,  -0.4749D-06,-0.2819D-06, 0.7252D-07, 0.6417D-06, 0.1463D-05,
     ,   0.2517D-05, 0.3678D-05, 0.4665D-05, 0.5085D-05, 0.4618D-05,
     ,   0.3280D-05, 0.1556D-05, 0.1392D-06,-0.4824D-06,-0.3597D-06,
     ,   0.2314D-06, 0.9345D-06, 0.1582D-05, 0.2105D-05, 0.2512D-05,
     ,   0.2821D-05, 0.3058D-05, 0.3239D-05, 0.3377D-05, 0.3481D-05,
     ,   0.3560D-05, 0.3618D-05, 0.3661D-05, 0.3693D-05, 0.3716D-05,
     ,   0.3733D-05, 0.3745D-05, 0.3753D-05, 0.3759D-05, 0.3764D-05,
     ,   0.3767D-05, 0.3769D-05, 0.3771D-05, 0.3772D-05, 0.3772D-05,
     ,   0.3773D-05, 0.3773D-05, 0.3774D-05, 0.3774D-05, 0.3774D-05,
     ,   0.3774D-05, 0.3774D-05, 0.3774D-05/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.1656D-07,-0.2006D-07,-0.2430D-07,-0.2944D-07,-0.3566D-07,
     ,  -0.4318D-07,-0.5230D-07,-0.6332D-07,-0.7663D-07,-0.9272D-07,
     ,  -0.1121D-06,-0.1355D-06,-0.1635D-06,-0.1970D-06,-0.2369D-06,
     ,  -0.2842D-06,-0.3395D-06,-0.4035D-06,-0.4762D-06,-0.5564D-06,
     ,  -0.6412D-06,-0.7237D-06,-0.7956D-06,-0.8360D-06,-0.8171D-06,
     ,  -0.6963D-06,-0.4135D-06, 0.1062D-06, 0.9402D-06, 0.2143D-05,
     ,   0.3689D-05, 0.5392D-05, 0.6836D-05, 0.7464D-05, 0.6776D-05,
     ,   0.4814D-05, 0.2279D-05, 0.2143D-06,-0.7131D-06,-0.5197D-06,
     ,   0.3300D-06, 0.1374D-05, 0.2318D-05, 0.3089D-05, 0.3686D-05,
     ,   0.4140D-05, 0.4486D-05, 0.4751D-05, 0.4953D-05, 0.5107D-05,
     ,   0.5222D-05, 0.5308D-05, 0.5371D-05, 0.5417D-05, 0.5451D-05,
     ,   0.5475D-05, 0.5493D-05, 0.5506D-05, 0.5514D-05, 0.5521D-05,
     ,   0.5525D-05, 0.5528D-05, 0.5531D-05, 0.5533D-05, 0.5534D-05,
     ,   0.5534D-05, 0.5535D-05, 0.5535D-05, 0.5536D-05, 0.5536D-05,
     ,   0.5536D-05, 0.5536D-05, 0.5536D-05/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.2425D-07,-0.2938D-07,-0.3559D-07,-0.4311D-07,-0.5222D-07,
     ,  -0.6324D-07,-0.7659D-07,-0.9274D-07,-0.1122D-06,-0.1358D-06,
     ,  -0.1642D-06,-0.1984D-06,-0.2394D-06,-0.2886D-06,-0.3470D-06,
     ,  -0.4162D-06,-0.4972D-06,-0.5910D-06,-0.6973D-06,-0.8149D-06,
     ,  -0.9390D-06,-0.1061D-05,-0.1165D-05,-0.1224D-05,-0.1197D-05,
     ,  -0.1019D-05,-0.6052D-06, 0.1550D-06, 0.1377D-05, 0.3140D-05,
     ,   0.5405D-05, 0.7903D-05, 0.1002D-04, 0.1094D-04, 0.9929D-05,
     ,   0.7058D-05, 0.3349D-05, 0.3179D-06,-0.1039D-05,-0.7667D-06,
     ,   0.4864D-06, 0.2007D-05, 0.3407D-05, 0.4525D-05, 0.5406D-05,
     ,   0.6071D-05, 0.6580D-05, 0.6969D-05, 0.7269D-05, 0.7494D-05,
     ,   0.7657D-05, 0.7789D-05, 0.7882D-05, 0.7946D-05, 0.7995D-05,
     ,   0.8034D-05, 0.8061D-05, 0.8077D-05, 0.8087D-05, 0.8098D-05,
     ,   0.8103D-05, 0.8109D-05, 0.8115D-05, 0.8114D-05, 0.8120D-05,
     ,   0.8120D-05, 0.8120D-05, 0.8120D-05, 0.8120D-05, 0.8119D-05,
     ,   0.8119D-05, 0.8119D-05, 0.8119D-05/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.3548D-07,-0.4299D-07,-0.5208D-07,-0.6308D-07,-0.7641D-07,
     ,  -0.9254D-07,-0.1121D-06,-0.1357D-06,-0.1642D-06,-0.1987D-06,
     ,  -0.2402D-06,-0.2903D-06,-0.3504D-06,-0.4222D-06,-0.5077D-06,
     ,  -0.6089D-06,-0.7276D-06,-0.8647D-06,-0.1020D-05,-0.1192D-05,
     ,  -0.1374D-05,-0.1553D-05,-0.1705D-05,-0.1792D-05,-0.1751D-05,
     ,  -0.1492D-05,-0.8858D-06, 0.2268D-06, 0.2015D-05, 0.4595D-05,
     ,   0.7916D-05, 0.1156D-04, 0.1467D-04, 0.1601D-04, 0.1455D-04,
     ,   0.1033D-04, 0.4904D-05, 0.4691D-06,-0.1526D-05,-0.1124D-05,
     ,   0.7104D-06, 0.2946D-05, 0.4987D-05, 0.6643D-05, 0.7930D-05,
     ,   0.8901D-05, 0.9651D-05, 0.1022D-04, 0.1065D-04, 0.1098D-04,
     ,   0.1124D-04, 0.1141D-04, 0.1155D-04, 0.1165D-04, 0.1172D-04,
     ,   0.1178D-04, 0.1182D-04, 0.1184D-04, 0.1186D-04, 0.1188D-04,
     ,   0.1189D-04, 0.1189D-04, 0.1190D-04, 0.1190D-04, 0.1190D-04,
     ,   0.1190D-04, 0.1191D-04, 0.1191D-04, 0.1191D-04, 0.1191D-04,
     ,   0.1191D-04, 0.1191D-04, 0.1191D-04/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.5184D-07,-0.6280D-07,-0.7608D-07,-0.9216D-07,-0.1116D-06,
     ,  -0.1352D-06,-0.1637D-06,-0.1982D-06,-0.2399D-06,-0.2903D-06,
     ,  -0.3510D-06,-0.4241D-06,-0.5119D-06,-0.6168D-06,-0.7418D-06,
     ,  -0.8896D-06,-0.1063D-05,-0.1263D-05,-0.1491D-05,-0.1742D-05,
     ,  -0.2007D-05,-0.2269D-05,-0.2491D-05,-0.2618D-05,-0.2559D-05,
     ,  -0.2180D-05,-0.1295D-05, 0.3295D-06, 0.2942D-05, 0.6713D-05,
     ,   0.1156D-04, 0.1690D-04, 0.2145D-04, 0.2341D-04, 0.2130D-04,
     ,   0.1514D-04, 0.7201D-05, 0.7302D-06,-0.2234D-05,-0.1629D-05,
     ,   0.1040D-05, 0.4317D-05, 0.7313D-05, 0.9732D-05, 0.1162D-04,
     ,   0.1304D-04, 0.1414D-04, 0.1498D-04, 0.1561D-04, 0.1610D-04,
     ,   0.1646D-04, 0.1673D-04, 0.1693D-04, 0.1708D-04, 0.1719D-04,
     ,   0.1726D-04, 0.1732D-04, 0.1736D-04, 0.1738D-04, 0.1740D-04,
     ,   0.1742D-04, 0.1743D-04, 0.1744D-04, 0.1744D-04, 0.1745D-04,
     ,   0.1745D-04, 0.1745D-04, 0.1745D-04, 0.1745D-04, 0.1745D-04,
     ,   0.1745D-04, 0.1745D-04, 0.1745D-04/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.7557D-07,-0.9154D-07,-0.1109D-06,-0.1343D-06,-0.1627D-06,
     ,  -0.1971D-06,-0.2387D-06,-0.2890D-06,-0.3497D-06,-0.4232D-06,
     ,  -0.5116D-06,-0.6182D-06,-0.7461D-06,-0.8991D-06,-0.1081D-05,
     ,  -0.1297D-05,-0.1549D-05,-0.1841D-05,-0.2173D-05,-0.2539D-05,
     ,  -0.2926D-05,-0.3307D-05,-0.3631D-05,-0.3815D-05,-0.3730D-05,
     ,  -0.3178D-05,-0.1886D-05, 0.4831D-06, 0.4295D-05, 0.9796D-05,
     ,   0.1686D-04, 0.2467D-04, 0.3131D-04, 0.3418D-04, 0.3112D-04,
     ,   0.2216D-04, 0.1053D-04, 0.9740D-06,-0.3300D-05,-0.2403D-05,
     ,   0.1537D-05, 0.6298D-05, 0.1069D-04, 0.1424D-04, 0.1700D-04,
     ,   0.1911D-04, 0.2071D-04, 0.2194D-04, 0.2288D-04, 0.2359D-04,
     ,   0.2412D-04, 0.2452D-04, 0.2481D-04, 0.2503D-04, 0.2518D-04,
     ,   0.2529D-04, 0.2537D-04, 0.2543D-04, 0.2548D-04, 0.2550D-04,
     ,   0.2552D-04, 0.2554D-04, 0.2555D-04, 0.2556D-04, 0.2556D-04,
     ,   0.2557D-04, 0.2557D-04, 0.2557D-04, 0.2557D-04, 0.2557D-04,
     ,   0.2557D-04, 0.2557D-04, 0.2557D-04/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.1098D-06,-0.1330D-06,-0.1612D-06,-0.1952D-06,-0.2365D-06,
     ,  -0.2864D-06,-0.3468D-06,-0.4199D-06,-0.5083D-06,-0.6149D-06,
     ,  -0.7435D-06,-0.8983D-06,-0.1084D-05,-0.1307D-05,-0.1571D-05,
     ,  -0.1884D-05,-0.2252D-05,-0.2676D-05,-0.3158D-05,-0.3691D-05,
     ,  -0.4252D-05,-0.4806D-05,-0.5277D-05,-0.5546D-05,-0.5421D-05,
     ,  -0.4620D-05,-0.2746D-05, 0.6929D-06, 0.6237D-05, 0.1423D-04,
     ,   0.2452D-04, 0.3588D-04, 0.4557D-04, 0.4981D-04, 0.4535D-04,
     ,   0.3223D-04, 0.1542D-04, 0.1453D-05,-0.4795D-05,-0.3516D-05,
     ,   0.2149D-05, 0.9245D-05, 0.1563D-04, 0.2083D-04, 0.2487D-04,
     ,   0.2795D-04, 0.3029D-04, 0.3210D-04, 0.3347D-04, 0.3451D-04,
     ,   0.3529D-04, 0.3587D-04, 0.3630D-04, 0.3662D-04, 0.3685D-04,
     ,   0.3701D-04, 0.3713D-04, 0.3721D-04, 0.3727D-04, 0.3732D-04,
     ,   0.3735D-04, 0.3737D-04, 0.3739D-04, 0.3740D-04, 0.3740D-04,
     ,   0.3741D-04, 0.3741D-04, 0.3741D-04, 0.3742D-04, 0.3742D-04,
     ,   0.3742D-04, 0.3742D-04, 0.3742D-04/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.1588D-06,-0.1924D-06,-0.2331D-06,-0.2824D-06,-0.3421D-06,
     ,  -0.4143D-06,-0.5017D-06,-0.6074D-06,-0.7352D-06,-0.8895D-06,
     ,  -0.1076D-05,-0.1299D-05,-0.1568D-05,-0.1890D-05,-0.2273D-05,
     ,  -0.2726D-05,-0.3258D-05,-0.3871D-05,-0.4569D-05,-0.5338D-05,
     ,  -0.6151D-05,-0.6952D-05,-0.7635D-05,-0.8023D-05,-0.7845D-05,
     ,  -0.6689D-05,-0.3971D-05, 0.1004D-05, 0.9025D-05, 0.2060D-04,
     ,   0.3551D-04, 0.5198D-04, 0.6606D-04, 0.7233D-04, 0.6599D-04,
     ,   0.4701D-04, 0.2250D-04, 0.2275D-05,-0.6912D-05,-0.5175D-05,
     ,   0.3195D-05, 0.1341D-04, 0.2282D-04, 0.3042D-04, 0.3633D-04,
     ,   0.4083D-04, 0.4427D-04, 0.4690D-04, 0.4890D-04, 0.5041D-04,
     ,   0.5156D-04, 0.5241D-04, 0.5304D-04, 0.5349D-04, 0.5383D-04,
     ,   0.5407D-04, 0.5424D-04, 0.5437D-04, 0.5446D-04, 0.5453D-04,
     ,   0.5457D-04, 0.5460D-04, 0.5462D-04, 0.5464D-04, 0.5465D-04,
     ,   0.5466D-04, 0.5467D-04, 0.5467D-04, 0.5467D-04, 0.5467D-04,
     ,   0.5468D-04, 0.5468D-04, 0.5468D-04/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.2282D-06,-0.2765D-06,-0.3349D-06,-0.4057D-06,-0.4915D-06,
     ,  -0.5952D-06,-0.7208D-06,-0.8726D-06,-0.1056D-05,-0.1278D-05,
     ,  -0.1545D-05,-0.1867D-05,-0.2253D-05,-0.2715D-05,-0.3265D-05,
     ,  -0.3916D-05,-0.4679D-05,-0.5561D-05,-0.6563D-05,-0.7670D-05,
     ,  -0.8838D-05,-0.9988D-05,-0.1097D-04,-0.1153D-04,-0.1127D-04,
     ,  -0.9612D-05,-0.5716D-05, 0.1437D-05, 0.1297D-04, 0.2963D-04,
     ,   0.5111D-04, 0.7492D-04, 0.9524D-04, 0.1045D-03, 0.9541D-04,
     ,   0.6824D-04, 0.3276D-04, 0.3365D-05,-0.1014D-04,-0.7559D-05,
     ,   0.4571D-05, 0.1952D-04, 0.3320D-04, 0.4430D-04, 0.5294D-04,
     ,   0.5950D-04, 0.6452D-04, 0.6836D-04, 0.7130D-04, 0.7349D-04,
     ,   0.7520D-04, 0.7646D-04, 0.7732D-04, 0.7804D-04, 0.7853D-04,
     ,   0.7885D-04, 0.7912D-04, 0.7928D-04, 0.7945D-04, 0.7949D-04,
     ,   0.7961D-04, 0.7960D-04, 0.7966D-04, 0.7972D-04, 0.7972D-04,
     ,   0.7972D-04, 0.7971D-04, 0.7971D-04, 0.7971D-04, 0.7971D-04,
     ,   0.7971D-04, 0.7971D-04, 0.7978D-04/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.3246D-06,-0.3933D-06,-0.4765D-06,-0.5772D-06,-0.6991D-06,
     ,  -0.8468D-06,-0.1025D-05,-0.1242D-05,-0.1503D-05,-0.1818D-05,
     ,  -0.2198D-05,-0.2656D-05,-0.3206D-05,-0.3863D-05,-0.4646D-05,
     ,  -0.5572D-05,-0.6657D-05,-0.7913D-05,-0.9337D-05,-0.1091D-04,
     ,  -0.1257D-04,-0.1421D-04,-0.1561D-04,-0.1640D-04,-0.1604D-04,
     ,  -0.1368D-04,-0.8139D-05, 0.2041D-05, 0.1846D-04, 0.4221D-04,
     ,   0.7290D-04, 0.1069D-03, 0.1363D-03, 0.1497D-03, 0.1371D-03,
     ,   0.9846D-04, 0.4741D-04, 0.4955D-05,-0.1466D-04,-0.1103D-04,
     ,   0.6514D-05, 0.2818D-04, 0.4808D-04, 0.6433D-04, 0.7680D-04,
     ,   0.8644D-04, 0.9372D-04, 0.9935D-04, 0.1036D-03, 0.1069D-03,
     ,   0.1093D-03, 0.1111D-03, 0.1124D-03, 0.1134D-03, 0.1141D-03,
     ,   0.1147D-03, 0.1151D-03, 0.1153D-03, 0.1155D-03, 0.1157D-03,
     ,   0.1157D-03, 0.1158D-03, 0.1158D-03, 0.1159D-03, 0.1159D-03,
     ,   0.1159D-03, 0.1159D-03, 0.1159D-03, 0.1159D-03, 0.1159D-03,
     ,   0.1159D-03, 0.1159D-03, 0.1160D-03/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.4554D-06,-0.5517D-06,-0.6683D-06,-0.8096D-06,-0.9807D-06,
     ,  -0.1188D-05,-0.1438D-05,-0.1742D-05,-0.2108D-05,-0.2550D-05,
     ,  -0.3083D-05,-0.3726D-05,-0.4497D-05,-0.5419D-05,-0.6517D-05,
     ,  -0.7816D-05,-0.9339D-05,-0.1110D-04,-0.1310D-04,-0.1531D-04,
     ,  -0.1764D-04,-0.1994D-04,-0.2190D-04,-0.2303D-04,-0.2253D-04,
     ,  -0.1922D-04,-0.1145D-04, 0.2838D-05, 0.2588D-04, 0.5932D-04,
     ,   0.1025D-03, 0.1507D-03, 0.1927D-03, 0.2122D-03, 0.1952D-03,
     ,   0.1409D-03, 0.6847D-04, 0.7623D-05,-0.2088D-04,-0.1603D-04,
     ,   0.9099D-05, 0.4042D-04, 0.6934D-04, 0.9286D-04, 0.1111D-03,
     ,   0.1250D-03, 0.1356D-03, 0.1437D-03, 0.1499D-03, 0.1546D-03,
     ,   0.1582D-03, 0.1608D-03, 0.1628D-03, 0.1642D-03, 0.1652D-03,
     ,   0.1660D-03, 0.1666D-03, 0.1669D-03, 0.1672D-03, 0.1674D-03,
     ,   0.1675D-03, 0.1676D-03, 0.1677D-03, 0.1677D-03, 0.1678D-03,
     ,   0.1678D-03, 0.1678D-03, 0.1678D-03, 0.1678D-03, 0.1678D-03,
     ,   0.1678D-03, 0.1678D-03, 0.1678D-03/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.6259D-06,-0.7583D-06,-0.9185D-06,-0.1113D-05,-0.1348D-05,
     ,  -0.1632D-05,-0.1977D-05,-0.2393D-05,-0.2897D-05,-0.3505D-05,
     ,  -0.4238D-05,-0.5121D-05,-0.6180D-05,-0.7448D-05,-0.8957D-05,
     ,  -0.1074D-04,-0.1283D-04,-0.1526D-04,-0.1800D-04,-0.2104D-04,
     ,  -0.2425D-04,-0.2741D-04,-0.3011D-04,-0.3166D-04,-0.3098D-04,
     ,  -0.2644D-04,-0.1577D-04, 0.3882D-05, 0.3563D-04, 0.8180D-04,
     ,   0.1416D-03, 0.2086D-03, 0.2677D-03, 0.2961D-03, 0.2744D-03,
     ,   0.1992D-03, 0.9784D-04, 0.1101D-04,-0.3014D-04,-0.2317D-04,
     ,   0.1224D-04, 0.5727D-04, 0.9894D-04, 0.1329D-03, 0.1594D-03,
     ,   0.1795D-03, 0.1948D-03, 0.2066D-03, 0.2156D-03, 0.2224D-03,
     ,   0.2276D-03, 0.2314D-03, 0.2342D-03, 0.2363D-03, 0.2378D-03,
     ,   0.2389D-03, 0.2397D-03, 0.2402D-03, 0.2406D-03, 0.2409D-03,
     ,   0.2411D-03, 0.2412D-03, 0.2413D-03, 0.2414D-03, 0.2414D-03,
     ,   0.2415D-03, 0.2416D-03, 0.2415D-03, 0.2415D-03, 0.2415D-03,
     ,   0.2415D-03, 0.2416D-03, 0.2416D-03/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.8359D-06,-0.1013D-05,-0.1227D-05,-0.1486D-05,-0.1800D-05,
     ,  -0.2180D-05,-0.2640D-05,-0.3196D-05,-0.3869D-05,-0.4680D-05,
     ,  -0.5660D-05,-0.6838D-05,-0.8253D-05,-0.9946D-05,-0.1196D-04,
     ,  -0.1435D-04,-0.1714D-04,-0.2038D-04,-0.2405D-04,-0.2811D-04,
     ,  -0.3239D-04,-0.3663D-04,-0.4024D-04,-0.4233D-04,-0.4144D-04,
     ,  -0.3540D-04,-0.2116D-04, 0.5100D-05, 0.4759D-04, 0.1096D-03,
     ,   0.1905D-03, 0.2817D-03, 0.3630D-03, 0.4038D-03, 0.3770D-03,
     ,   0.2773D-03, 0.1377D-03, 0.1748D-04,-0.4144D-04,-0.3361D-04,
     ,   0.1651D-04, 0.8008D-04, 0.1396D-03, 0.1884D-03, 0.2262D-03,
     ,   0.2551D-03, 0.2773D-03, 0.2941D-03, 0.3071D-03, 0.3169D-03,
     ,   0.3243D-03, 0.3298D-03, 0.3338D-03, 0.3368D-03, 0.3390D-03,
     ,   0.3406D-03, 0.3417D-03, 0.3425D-03, 0.3431D-03, 0.3435D-03,
     ,   0.3438D-03, 0.3440D-03, 0.3441D-03, 0.3442D-03, 0.3443D-03,
     ,   0.3444D-03, 0.3444D-03, 0.3444D-03, 0.3444D-03, 0.3444D-03,
     ,   0.3445D-03, 0.3445D-03, 0.3445D-03/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.1072D-05,-0.1299D-05,-0.1574D-05,-0.1906D-05,-0.2309D-05,
     ,  -0.2797D-05,-0.3386D-05,-0.4100D-05,-0.4963D-05,-0.6004D-05,
     ,  -0.7260D-05,-0.8772D-05,-0.1059D-04,-0.1276D-04,-0.1535D-04,
     ,  -0.1840D-04,-0.2199D-04,-0.2614D-04,-0.3085D-04,-0.3606D-04,
     ,  -0.4157D-04,-0.4701D-04,-0.5167D-04,-0.5438D-04,-0.5326D-04,
     ,  -0.4557D-04,-0.2734D-04, 0.6334D-05, 0.6112D-04, 0.1413D-03,
     ,   0.2465D-03, 0.3664D-03, 0.4750D-03, 0.5343D-03, 0.5045D-03,
     ,   0.3766D-03, 0.1909D-03, 0.2595D-04,-0.5730D-04,-0.4902D-04,
     ,   0.1950D-04, 0.1092D-03, 0.1935D-03, 0.2627D-03, 0.3166D-03,
     ,   0.3577D-03, 0.3891D-03, 0.4132D-03, 0.4316D-03, 0.4456D-03,
     ,   0.4561D-03, 0.4639D-03, 0.4698D-03, 0.4740D-03, 0.4771D-03,
     ,   0.4794D-03, 0.4810D-03, 0.4822D-03, 0.4830D-03, 0.4836D-03,
     ,   0.4840D-03, 0.4843D-03, 0.4845D-03, 0.4847D-03, 0.4847D-03,
     ,   0.4848D-03, 0.4849D-03, 0.4849D-03, 0.4849D-03, 0.4849D-03,
     ,   0.4850D-03, 0.4850D-03, 0.4850D-03/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.1302D-05,-0.1577D-05,-0.1910D-05,-0.2314D-05,-0.2803D-05,
     ,  -0.3395D-05,-0.4110D-05,-0.4977D-05,-0.6024D-05,-0.7288D-05,
     ,  -0.8813D-05,-0.1065D-04,-0.1285D-04,-0.1549D-04,-0.1863D-04,
     ,  -0.2234D-04,-0.2669D-04,-0.3174D-04,-0.3745D-04,-0.4379D-04,
     ,  -0.5049D-04,-0.5710D-04,-0.6278D-04,-0.6611D-04,-0.6483D-04,
     ,  -0.5557D-04,-0.3345D-04, 0.7418D-05, 0.7426D-04, 0.1726D-03,
     ,   0.3028D-03, 0.4534D-03, 0.5935D-03, 0.6756D-03, 0.6480D-03,
     ,   0.4928D-03, 0.2571D-03, 0.3964D-04,-0.7666D-04,-0.6933D-04,
     ,   0.2162D-04, 0.1442D-03, 0.2611D-03, 0.3583D-03, 0.4338D-03,
     ,   0.4917D-03, 0.5358D-03, 0.5698D-03, 0.5957D-03, 0.6154D-03,
     ,   0.6303D-03, 0.6413D-03, 0.6495D-03, 0.6555D-03, 0.6599D-03,
     ,   0.6631D-03, 0.6654D-03, 0.6670D-03, 0.6682D-03, 0.6690D-03,
     ,   0.6696D-03, 0.6700D-03, 0.6703D-03, 0.6706D-03, 0.6707D-03,
     ,   0.6708D-03, 0.6709D-03, 0.6709D-03, 0.6709D-03, 0.6710D-03,
     ,   0.6710D-03, 0.6710D-03, 0.6710D-03/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.1468D-05,-0.1779D-05,-0.2155D-05,-0.2609D-05,-0.3161D-05,
     ,  -0.3828D-05,-0.4636D-05,-0.5613D-05,-0.6793D-05,-0.8220D-05,
     ,  -0.9940D-05,-0.1201D-04,-0.1450D-04,-0.1747D-04,-0.2101D-04,
     ,  -0.2520D-04,-0.3012D-04,-0.3580D-04,-0.4226D-04,-0.4941D-04,
     ,  -0.5698D-04,-0.6447D-04,-0.7091D-04,-0.7473D-04,-0.7338D-04,
     ,  -0.6304D-04,-0.3830D-04, 0.7899D-05, 0.8370D-04, 0.1961D-03,
     ,   0.3467D-03, 0.5236D-03, 0.6945D-03, 0.8036D-03, 0.7866D-03,
     ,   0.6142D-03, 0.3328D-03, 0.5705D-04,-0.9942D-04,-0.9931D-04,
     ,   0.1751D-04, 0.1809D-03, 0.3408D-03, 0.4736D-03, 0.5780D-03,
     ,   0.6578D-03, 0.7186D-03, 0.7659D-03, 0.8014D-03, 0.8288D-03,
     ,   0.8495D-03, 0.8651D-03, 0.8761D-03, 0.8844D-03, 0.8912D-03,
     ,   0.8956D-03, 0.8982D-03, 0.9011D-03, 0.9021D-03, 0.9038D-03,
     ,   0.9043D-03, 0.9048D-03, 0.9054D-03, 0.9053D-03, 0.9060D-03,
     ,   0.9059D-03, 0.9059D-03, 0.9059D-03, 0.9066D-03, 0.9065D-03,
     ,   0.9065D-03, 0.9065D-03, 0.9065D-03/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.1506D-05,-0.1825D-05,-0.2211D-05,-0.2679D-05,-0.3245D-05,
     ,  -0.3930D-05,-0.4759D-05,-0.5762D-05,-0.6973D-05,-0.8437D-05,
     ,  -0.1020D-04,-0.1233D-04,-0.1488D-04,-0.1793D-04,-0.2157D-04,
     ,  -0.2587D-04,-0.3092D-04,-0.3675D-04,-0.4339D-04,-0.5075D-04,
     ,  -0.5853D-04,-0.6626D-04,-0.7294D-04,-0.7695D-04,-0.7571D-04,
     ,  -0.6528D-04,-0.4006D-04, 0.7350D-05, 0.8563D-04, 0.2029D-03,
     ,   0.3622D-03, 0.5542D-03, 0.7455D-03, 0.8808D-03, 0.8842D-03,
     ,   0.7150D-03, 0.4048D-03, 0.7720D-04,-0.1257D-03,-0.1393D-03,
     ,   0.5267D-06, 0.2114D-03, 0.4217D-03, 0.6000D-03, 0.7407D-03,
     ,   0.8482D-03, 0.9311D-03, 0.9948D-03, 0.1043D-02, 0.1080D-02,
     ,   0.1108D-02, 0.1129D-02, 0.1145D-02, 0.1156D-02, 0.1164D-02,
     ,   0.1171D-02, 0.1175D-02, 0.1178D-02, 0.1181D-02, 0.1182D-02,
     ,   0.1183D-02, 0.1184D-02, 0.1184D-02, 0.1185D-02, 0.1185D-02,
     ,   0.1186D-02, 0.1185D-02, 0.1185D-02, 0.1185D-02, 0.1185D-02,
     ,   0.1185D-02, 0.1185D-02, 0.1185D-02/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.1378D-05,-0.1669D-05,-0.2022D-05,-0.2449D-05,-0.2967D-05,
     ,  -0.3593D-05,-0.4351D-05,-0.5268D-05,-0.6376D-05,-0.7714D-05,
     ,  -0.9329D-05,-0.1127D-04,-0.1361D-04,-0.1640D-04,-0.1972D-04,
     ,  -0.2366D-04,-0.2827D-04,-0.3362D-04,-0.3970D-04,-0.4643D-04,
     ,  -0.5358D-04,-0.6068D-04,-0.6686D-04,-0.7064D-04,-0.6966D-04,
     ,  -0.6034D-04,-0.3751D-04, 0.5786D-05, 0.7773D-04, 0.1868D-03,
     ,   0.3374D-03, 0.5232D-03, 0.7189D-03, 0.8690D-03, 0.9020D-03,
     ,   0.7591D-03, 0.4516D-03, 0.9461D-04,-0.1539D-03,-0.1919D-03,
     ,  -0.3744D-04, 0.2187D-03, 0.4866D-03, 0.7185D-03, 0.9029D-03,
     ,   0.1044D-02, 0.1153D-02, 0.1237D-02, 0.1301D-02, 0.1350D-02,
     ,   0.1387D-02, 0.1415D-02, 0.1435D-02, 0.1451D-02, 0.1462D-02,
     ,   0.1470D-02, 0.1476D-02, 0.1480D-02, 0.1482D-02, 0.1485D-02,
     ,   0.1486D-02, 0.1488D-02, 0.1488D-02, 0.1489D-02, 0.1489D-02,
     ,   0.1489D-02, 0.1490D-02, 0.1490D-02, 0.1490D-02, 0.1490D-02,
     ,   0.1490D-02, 0.1490D-02, 0.1490D-02/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.1103D-05,-0.1336D-05,-0.1618D-05,-0.1960D-05,-0.2374D-05,
     ,  -0.2875D-05,-0.3482D-05,-0.4216D-05,-0.5102D-05,-0.6173D-05,
     ,  -0.7466D-05,-0.9023D-05,-0.1089D-04,-0.1313D-04,-0.1578D-04,
     ,  -0.1894D-04,-0.2263D-04,-0.2692D-04,-0.3179D-04,-0.3720D-04,
     ,  -0.4294D-04,-0.4867D-04,-0.5366D-04,-0.5679D-04,-0.5619D-04,
     ,  -0.4897D-04,-0.3098D-04, 0.3381D-05, 0.6117D-04, 0.1498D-03,
     ,   0.2744D-03, 0.4324D-03, 0.6063D-03, 0.7540D-03, 0.8118D-03,
     ,   0.7141D-03, 0.4483D-03, 0.9496D-04,-0.1844D-03,-0.2585D-03,
     ,  -0.1075D-03, 0.1841D-03, 0.5084D-03, 0.7984D-03, 0.1032D-02,
     ,   0.1212D-02, 0.1351D-02, 0.1456D-02, 0.1538D-02, 0.1601D-02,
     ,   0.1648D-02, 0.1685D-02, 0.1711D-02, 0.1731D-02, 0.1746D-02,
     ,   0.1756D-02, 0.1764D-02, 0.1769D-02, 0.1773D-02, 0.1775D-02,
     ,   0.1778D-02, 0.1779D-02, 0.1780D-02, 0.1780D-02, 0.1781D-02,
     ,   0.1782D-02, 0.1781D-02, 0.1781D-02, 0.1782D-02, 0.1782D-02,
     ,   0.1782D-02, 0.1782D-02, 0.1782D-02/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.7638D-06,-0.9250D-06,-0.1120D-05,-0.1358D-05,-0.1645D-05,
     ,  -0.1992D-05,-0.2412D-05,-0.2921D-05,-0.3534D-05,-0.4276D-05,
     ,  -0.5172D-05,-0.6248D-05,-0.7543D-05,-0.9090D-05,-0.1093D-04,
     ,  -0.1312D-04,-0.1568D-04,-0.1865D-04,-0.2204D-04,-0.2579D-04,
     ,  -0.2979D-04,-0.3382D-04,-0.3731D-04,-0.3961D-04,-0.3929D-04,
     ,  -0.3451D-04,-0.2235D-04, 0.1168D-05, 0.4106D-04, 0.1030D-03,
     ,   0.1917D-03, 0.3073D-03, 0.4402D-03, 0.5632D-03, 0.6291D-03,
     ,   0.5792D-03, 0.3788D-03, 0.7046D-04,-0.2162D-03,-0.3310D-03,
     ,  -0.2094D-03, 0.9188D-04, 0.4600D-03, 0.8054D-03, 0.1091D-02,
     ,   0.1312D-02, 0.1481D-02, 0.1612D-02, 0.1712D-02, 0.1789D-02,
     ,   0.1848D-02, 0.1893D-02, 0.1926D-02, 0.1950D-02, 0.1968D-02,
     ,   0.1981D-02, 0.1991D-02, 0.1998D-02, 0.2003D-02, 0.2007D-02,
     ,   0.2009D-02, 0.2010D-02, 0.2012D-02, 0.2013D-02, 0.2013D-02,
     ,   0.2014D-02, 0.2014D-02, 0.2014D-02, 0.2014D-02, 0.2014D-02,
     ,   0.2015D-02, 0.2015D-02, 0.2015D-02/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.4574D-06,-0.5538D-06,-0.6708D-06,-0.8127D-06,-0.9848D-06,
     ,  -0.1193D-05,-0.1444D-05,-0.1749D-05,-0.2116D-05,-0.2559D-05,
     ,  -0.3098D-05,-0.3743D-05,-0.4515D-05,-0.5445D-05,-0.6547D-05,
     ,  -0.7857D-05,-0.9392D-05,-0.1118D-04,-0.1321D-04,-0.1546D-04,
     ,  -0.1787D-04,-0.2028D-04,-0.2244D-04,-0.2388D-04,-0.2383D-04,
     ,  -0.2113D-04,-0.1408D-04,-0.2945D-06, 0.2329D-04, 0.6033D-04,
     ,   0.1142D-03, 0.1861D-03, 0.2719D-03, 0.3571D-03, 0.4120D-03,
     ,   0.3929D-03, 0.2606D-03, 0.2105D-04,-0.2438D-03,-0.3947D-03,
     ,  -0.3300D-03,-0.5610D-04, 0.3279D-03, 0.7158D-03, 0.1048D-02,
     ,   0.1310D-02, 0.1510D-02, 0.1664D-02, 0.1782D-02, 0.1873D-02,
     ,   0.1943D-02, 0.1996D-02, 0.2037D-02, 0.2067D-02, 0.2088D-02,
     ,   0.2104D-02, 0.2116D-02, 0.2124D-02, 0.2130D-02, 0.2134D-02,
     ,   0.2137D-02, 0.2140D-02, 0.2141D-02, 0.2142D-02, 0.2143D-02,
     ,   0.2144D-02, 0.2144D-02, 0.2144D-02, 0.2144D-02, 0.2144D-02,
     ,   0.2145D-02, 0.2145D-02, 0.2145D-02/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.2389D-06,-0.2893D-06,-0.3504D-06,-0.4245D-06,-0.5144D-06,
     ,  -0.6228D-06,-0.7542D-06,-0.9134D-06,-0.1105D-05,-0.1336D-05,
     ,  -0.1617D-05,-0.1954D-05,-0.2360D-05,-0.2844D-05,-0.3420D-05,
     ,  -0.4105D-05,-0.4908D-05,-0.5839D-05,-0.6905D-05,-0.8089D-05,
     ,  -0.9352D-05,-0.1063D-04,-0.1178D-04,-0.1258D-04,-0.1261D-04,
     ,  -0.1131D-04,-0.7796D-05,-0.8452D-06, 0.1114D-04, 0.3014D-04,
     ,   0.5809D-04, 0.9600D-04, 0.1425D-03, 0.1906D-03, 0.2243D-03,
     ,   0.2164D-03, 0.1347D-03,-0.3528D-04,-0.2568D-03,-0.4290D-03,
     ,  -0.4356D-03,-0.2320D-03, 0.1249D-03, 0.5285D-03, 0.8955D-03,
     ,   0.1192D-02, 0.1421D-02, 0.1596D-02, 0.1731D-02, 0.1834D-02,
     ,   0.1914D-02, 0.1975D-02, 0.2021D-02, 0.2056D-02, 0.2081D-02,
     ,   0.2100D-02, 0.2114D-02, 0.2124D-02, 0.2131D-02, 0.2136D-02,
     ,   0.2139D-02, 0.2142D-02, 0.2143D-02, 0.2145D-02, 0.2146D-02,
     ,   0.2146D-02, 0.2147D-02, 0.2147D-02, 0.2148D-02, 0.2147D-02,
     ,   0.2147D-02, 0.2147D-02, 0.2147D-02/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.1107D-06,-0.1341D-06,-0.1623D-06,-0.1966D-06,-0.2382D-06,
     ,  -0.2885D-06,-0.3494D-06,-0.4233D-06,-0.5118D-06,-0.6185D-06,
     ,  -0.7501D-06,-0.9054D-06,-0.1093D-05,-0.1318D-05,-0.1586D-05,
     ,  -0.1902D-05,-0.2276D-05,-0.2708D-05,-0.3202D-05,-0.3753D-05,
     ,  -0.4341D-05,-0.4946D-05,-0.5502D-05,-0.5877D-05,-0.5939D-05,
     ,  -0.5397D-05,-0.3882D-05,-0.8332D-06, 0.4473D-05, 0.1295D-04,
     ,   0.2544D-04, 0.4251D-04, 0.6363D-04, 0.8558D-04, 0.1004D-03,
     ,   0.9301D-04, 0.4170D-04,-0.7255D-04,-0.2432D-03,-0.4149D-03,
     ,  -0.4885D-03,-0.3843D-03,-0.1032D-03, 0.2744D-03, 0.6529D-03,
     ,   0.9751D-03, 0.1228D-02, 0.1421D-02, 0.1568D-02, 0.1682D-02,
     ,   0.1769D-02, 0.1836D-02, 0.1888D-02, 0.1926D-02, 0.1955D-02,
     ,   0.1976D-02, 0.1992D-02, 0.2003D-02, 0.2011D-02, 0.2017D-02,
     ,   0.2021D-02, 0.2024D-02, 0.2025D-02, 0.2027D-02, 0.2028D-02,
     ,   0.2029D-02, 0.2029D-02, 0.2029D-02, 0.2030D-02, 0.2030D-02,
     ,   0.2030D-02, 0.2031D-02, 0.2031D-02/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.4647D-07,-0.5622D-07,-0.6812D-07,-0.8261D-07,-0.9997D-07,
     ,  -0.1211D-06,-0.1467D-06,-0.1776D-06,-0.2148D-06,-0.2596D-06,
     ,  -0.3143D-06,-0.3799D-06,-0.4593D-06,-0.5540D-06,-0.6655D-06,
     ,  -0.7985D-06,-0.9559D-06,-0.1137D-05,-0.1345D-05,-0.1579D-05,
     ,  -0.1827D-05,-0.2084D-05,-0.2329D-05,-0.2496D-05,-0.2541D-05,
     ,  -0.2352D-05,-0.1759D-05,-0.5870D-06, 0.1500D-05, 0.4804D-05,
     ,   0.9675D-05, 0.1629D-04, 0.2431D-04, 0.3220D-04, 0.3600D-04,
     ,   0.2786D-04,-0.5398D-05,-0.7941D-04,-0.2019D-03,-0.3519D-03,
     ,  -0.4665D-03,-0.4624D-03,-0.2938D-03, 0.9082D-05, 0.3634D-03,
     ,   0.6934D-03, 0.9631D-03, 0.1170D-02, 0.1327D-02, 0.1447D-02,
     ,   0.1540D-02, 0.1611D-02, 0.1666D-02, 0.1707D-02, 0.1739D-02,
     ,   0.1762D-02, 0.1779D-02, 0.1791D-02, 0.1800D-02, 0.1807D-02,
     ,   0.1811D-02, 0.1815D-02, 0.1817D-02, 0.1818D-02, 0.1819D-02,
     ,   0.1821D-02, 0.1821D-02, 0.1821D-02, 0.1822D-02, 0.1822D-02,
     ,   0.1822D-02, 0.1822D-02, 0.1822D-02/
      data (calcpts(j,28), j = 1,neta) /
     ,  -0.1803D-07,-0.2189D-07,-0.2643D-07,-0.3199D-07,-0.3879D-07,
     ,  -0.4703D-07,-0.5691D-07,-0.6896D-07,-0.8336D-07,-0.1009D-06,
     ,  -0.1225D-06,-0.1475D-06,-0.1777D-06,-0.2153D-06,-0.2579D-06,
     ,  -0.3096D-06,-0.3711D-06,-0.4423D-06,-0.5227D-06,-0.6147D-06,
     ,  -0.7110D-06,-0.8126D-06,-0.9032D-06,-0.9758D-06,-0.1007D-05,
     ,  -0.9490D-06,-0.7527D-06,-0.3331D-06, 0.3955D-06, 0.1550D-05,
     ,   0.3220D-05, 0.5426D-05, 0.7927D-05, 0.9911D-05, 0.9441D-05,
     ,   0.2387D-05,-0.1859D-04,-0.6440D-04,-0.1450D-03,-0.2603D-03,
     ,  -0.3813D-03,-0.4475D-03,-0.3945D-03,-0.2018D-03, 0.8548D-04,
     ,   0.3945D-03, 0.6673D-03, 0.8840D-03, 0.1048D-02, 0.1173D-02,
     ,   0.1268D-02, 0.1342D-02, 0.1399D-02, 0.1442D-02, 0.1475D-02,
     ,   0.1499D-02, 0.1517D-02, 0.1531D-02, 0.1540D-02, 0.1548D-02,
     ,   0.1552D-02, 0.1556D-02, 0.1558D-02, 0.1560D-02, 0.1561D-02,
     ,   0.1562D-02, 0.1563D-02, 0.1563D-02, 0.1564D-02, 0.1564D-02,
     ,   0.1564D-02, 0.1564D-02, 0.1564D-02/
      data (calcpts(j,29), j = 1,neta) /
     ,  -0.6620D-08,-0.8010D-08,-0.9685D-08,-0.1170D-07,-0.1416D-07,
     ,  -0.1718D-07,-0.2082D-07,-0.2522D-07,-0.3040D-07,-0.3688D-07,
     ,  -0.4468D-07,-0.5430D-07,-0.6487D-07,-0.7842D-07,-0.9460D-07,
     ,  -0.1130D-06,-0.1361D-06,-0.1616D-06,-0.1913D-06,-0.2251D-06,
     ,  -0.2603D-06,-0.2987D-06,-0.3345D-06,-0.3633D-06,-0.3768D-06,
     ,  -0.3614D-06,-0.2975D-06,-0.1675D-06, 0.6068D-07, 0.4265D-06,
     ,   0.9334D-06, 0.1547D-05, 0.2139D-05, 0.2256D-05, 0.9384D-06,
     ,  -0.3879D-05,-0.1611D-04,-0.4220D-04,-0.9091D-04,-0.1682D-03,
     ,  -0.2681D-03,-0.3601D-03,-0.3911D-03,-0.3147D-03,-0.1268D-03,
     ,   0.1254D-03, 0.3806D-03, 0.5984D-03, 0.7677D-03, 0.8954D-03,
     ,   0.9914D-03, 0.1065D-02, 0.1122D-02, 0.1166D-02, 0.1200D-02,
     ,   0.1225D-02, 0.1244D-02, 0.1258D-02, 0.1268D-02, 0.1275D-02,
     ,   0.1281D-02, 0.1285D-02, 0.1287D-02, 0.1289D-02, 0.1291D-02,
     ,   0.1291D-02, 0.1292D-02, 0.1292D-02, 0.1293D-02, 0.1293D-02,
     ,   0.1293D-02, 0.1294D-02, 0.1294D-02/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.2306D-08,-0.2816D-08,-0.3383D-08,-0.4103D-08,-0.4959D-08,
     ,  -0.6028D-08,-0.7278D-08,-0.8818D-08,-0.1069D-07,-0.1291D-07,
     ,  -0.1569D-07,-0.1893D-07,-0.2289D-07,-0.2731D-07,-0.3280D-07,
     ,  -0.3970D-07,-0.4779D-07,-0.5663D-07,-0.6692D-07,-0.7905D-07,
     ,  -0.9154D-07,-0.1052D-06,-0.1186D-06,-0.1292D-06,-0.1364D-06,
     ,  -0.1335D-06,-0.1161D-06,-0.7623D-07,-0.1532D-07, 0.8455D-07,
     ,   0.2164D-06, 0.3479D-06, 0.4020D-06, 0.1619D-06,-0.8521D-06,
     ,  -0.3613D-05,-0.1011D-04,-0.2390D-04,-0.5050D-04,-0.9629D-04,
     ,  -0.1646D-03,-0.2470D-03,-0.3138D-03,-0.3222D-03,-0.2401D-03,
     ,  -0.7285D-04, 0.1370D-03, 0.3404D-03, 0.5094D-03, 0.6388D-03,
     ,   0.7358D-03, 0.8088D-03, 0.8651D-03, 0.9081D-03, 0.9417D-03,
     ,   0.9668D-03, 0.9863D-03, 0.1001D-02, 0.1011D-02, 0.1018D-02,
     ,   0.1024D-02, 0.1028D-02, 0.1031D-02, 0.1033D-02, 0.1035D-02,
     ,   0.1035D-02, 0.1036D-02, 0.1036D-02, 0.1037D-02, 0.1037D-02,
     ,   0.1037D-02, 0.1038D-02, 0.1038D-02/
      data (calcpts(j,31), j = 1,neta) /
     ,  -0.7845D-09,-0.9520D-09,-0.1129D-08,-0.1377D-08,-0.1690D-08,
     ,  -0.2035D-08,-0.2484D-08,-0.2999D-08,-0.3608D-08,-0.4373D-08,
     ,  -0.5318D-08,-0.6427D-08,-0.7754D-08,-0.9394D-08,-0.1114D-07,
     ,  -0.1354D-07,-0.1615D-07,-0.1940D-07,-0.2282D-07,-0.2680D-07,
     ,  -0.3121D-07,-0.3596D-07,-0.4068D-07,-0.4492D-07,-0.4754D-07,
     ,  -0.4784D-07,-0.4463D-07,-0.3288D-07,-0.2022D-07, 0.6085D-08,
     ,   0.2947D-07, 0.3846D-07,-0.5865D-08,-0.2066D-06,-0.7844D-06,
     ,  -0.2188D-05,-0.5355D-05,-0.1205D-04,-0.2531D-04,-0.4961D-04,
     ,  -0.8994D-04,-0.1472D-03,-0.2123D-03,-0.2597D-03,-0.2556D-03,
     ,  -0.1779D-03,-0.3720D-04, 0.1307D-03, 0.2886D-03, 0.4171D-03,
     ,   0.5144D-03, 0.5869D-03, 0.6416D-03, 0.6834D-03, 0.7160D-03,
     ,   0.7411D-03, 0.7598D-03, 0.7743D-03, 0.7847D-03, 0.7924D-03,
     ,   0.7982D-03, 0.8020D-03, 0.8052D-03, 0.8070D-03, 0.8089D-03,
     ,   0.8095D-03, 0.8108D-03, 0.8107D-03, 0.8114D-03, 0.8114D-03,
     ,   0.8120D-03, 0.8120D-03, 0.8120D-03/
      data (calcpts(j,32), j = 1,neta) /
     ,  -0.2596D-09,-0.3158D-09,-0.3773D-09,-0.4569D-09,-0.5693D-09,
     ,  -0.6766D-09,-0.8272D-09,-0.9848D-09,-0.1204D-08,-0.1455D-08,
     ,  -0.1764D-08,-0.2115D-08,-0.2555D-08,-0.3107D-08,-0.3682D-08,
     ,  -0.4510D-08,-0.5335D-08,-0.6365D-08,-0.7550D-08,-0.9070D-08,
     ,  -0.1042D-07,-0.1190D-07,-0.1366D-07,-0.1502D-07,-0.1598D-07,
     ,  -0.1663D-07,-0.1560D-07,-0.1399D-07,-0.1019D-07,-0.7986D-08,
     ,  -0.6791D-08,-0.1649D-07,-0.5707D-07,-0.1696D-06,-0.4528D-06,
     ,  -0.1105D-05,-0.2539D-05,-0.5568D-05,-0.1170D-04,-0.2348D-04,
     ,  -0.4447D-04,-0.7808D-04,-0.1244D-03,-0.1743D-03,-0.2074D-03,
     ,  -0.1970D-03,-0.1295D-03,-0.1559D-04, 0.1153D-03, 0.2354D-03,
     ,   0.3317D-03, 0.4039D-03, 0.4574D-03, 0.4978D-03, 0.5288D-03,
     ,   0.5527D-03, 0.5712D-03, 0.5852D-03, 0.5957D-03, 0.6035D-03,
     ,   0.6092D-03, 0.6134D-03, 0.6163D-03, 0.6184D-03, 0.6199D-03,
     ,   0.6210D-03, 0.6218D-03, 0.6223D-03, 0.6227D-03, 0.6229D-03,
     ,   0.6231D-03, 0.6232D-03, 0.6234D-03/
      data (calcpts(j,33), j = 1,neta) /
     ,  -0.8745D-10,-0.1059D-09,-0.1261D-09,-0.1526D-09,-0.1839D-09,
     ,  -0.2237D-09,-0.2748D-09,-0.3299D-09,-0.4006D-09,-0.4909D-09,
     ,  -0.5878D-09,-0.7055D-09,-0.8530D-09,-0.1036D-08,-0.1236D-08,
     ,  -0.1479D-08,-0.1826D-08,-0.2222D-08,-0.2553D-08,-0.2940D-08,
     ,  -0.3520D-08,-0.4009D-08,-0.4734D-08,-0.5084D-08,-0.5664D-08,
     ,  -0.6039D-08,-0.5865D-08,-0.5816D-08,-0.5895D-08,-0.6723D-08,
     ,  -0.7983D-08,-0.1725D-07,-0.3870D-07,-0.9397D-07,-0.2219D-06,
     ,  -0.5048D-06,-0.1121D-05,-0.2418D-05,-0.5083D-05,-0.1037D-04,
     ,  -0.2031D-04,-0.3762D-04,-0.6473D-04,-0.1010D-03,-0.1387D-03,
     ,  -0.1612D-03,-0.1490D-03,-0.9306D-04,-0.3485D-05, 0.9650D-04,
     ,   0.1865D-03, 0.2577D-03, 0.3107D-03, 0.3499D-03, 0.3794D-03,
     ,   0.4021D-03, 0.4196D-03, 0.4330D-03, 0.4433D-03, 0.4510D-03,
     ,   0.4567D-03, 0.4608D-03, 0.4638D-03, 0.4660D-03, 0.4675D-03,
     ,   0.4686D-03, 0.4694D-03, 0.4699D-03, 0.4703D-03, 0.4705D-03,
     ,   0.4707D-03, 0.4709D-03, 0.4710D-03/
      data (calcpts(j,34), j = 1,neta) /
     ,  -0.2767D-10,-0.3425D-10,-0.4036D-10,-0.4897D-10,-0.6062D-10,
     ,  -0.7289D-10,-0.8820D-10,-0.1036D-09,-0.1213D-09,-0.1498D-09,
     ,  -0.1954D-09,-0.2307D-09,-0.2765D-09,-0.3423D-09,-0.3911D-09,
     ,  -0.4782D-09,-0.5846D-09,-0.6877D-09,-0.7774D-09,-0.9577D-09,
     ,  -0.1062D-08,-0.1328D-08,-0.1488D-08,-0.1741D-08,-0.1834D-08,
     ,  -0.2055D-08,-0.2091D-08,-0.2263D-08,-0.2529D-08,-0.3229D-08,
     ,  -0.5459D-08,-0.9979D-08,-0.2026D-07,-0.4468D-07,-0.9765D-07,
     ,  -0.2151D-06,-0.4648D-06,-0.9969D-06,-0.2099D-05,-0.4335D-05,
     ,  -0.8708D-05,-0.1678D-04,-0.3064D-04,-0.5192D-04,-0.7975D-04,
     ,  -0.1077D-03,-0.1230D-03,-0.1110D-03,-0.6626D-04, 0.2662D-05,
     ,   0.7789D-04, 0.1447D-03, 0.1968D-03, 0.2354D-03, 0.2639D-03,
     ,   0.2853D-03, 0.3018D-03, 0.3145D-03, 0.3242D-03, 0.3316D-03,
     ,   0.3372D-03, 0.3413D-03, 0.3443D-03, 0.3465D-03, 0.3480D-03,
     ,   0.3491D-03, 0.3500D-03, 0.3505D-03, 0.3508D-03, 0.3512D-03,
     ,   0.3513D-03, 0.3515D-03, 0.3515D-03/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.8564D-11,-0.1056D-10,-0.1224D-10,-0.1517D-10,-0.1907D-10,
     ,  -0.2264D-10,-0.2759D-10,-0.3382D-10,-0.3948D-10,-0.4845D-10,
     ,  -0.5670D-10,-0.7093D-10,-0.8592D-10,-0.1063D-09,-0.1237D-09,
     ,  -0.1456D-09,-0.1785D-09,-0.2192D-09,-0.2523D-09,-0.3070D-09,
     ,  -0.3811D-09,-0.4500D-09,-0.4821D-09,-0.5065D-09,-0.5597D-09,
     ,  -0.6746D-09,-0.7065D-09,-0.8044D-09,-0.1056D-08,-0.1382D-08,
     ,  -0.2291D-08,-0.4359D-08,-0.9037D-08,-0.1863D-07,-0.4071D-07,
     ,  -0.8763D-07,-0.1854D-06,-0.3948D-06,-0.8336D-06,-0.1738D-05,
     ,  -0.3554D-05,-0.7058D-05,-0.1346D-04,-0.2429D-04,-0.4066D-04,
     ,  -0.6167D-04,-0.8221D-04,-0.9244D-04,-0.8185D-04,-0.4685D-04,
     ,   0.5315D-05, 0.6128D-04, 0.1103D-03, 0.1483D-03, 0.1762D-03,
     ,   0.1967D-03, 0.2122D-03, 0.2241D-03, 0.2333D-03, 0.2403D-03,
     ,   0.2457D-03, 0.2496D-03, 0.2526D-03, 0.2547D-03, 0.2563D-03,
     ,   0.2574D-03, 0.2582D-03, 0.2588D-03, 0.2591D-03, 0.2594D-03,
     ,   0.2596D-03, 0.2597D-03, 0.2598D-03/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.2898D-11,-0.3457D-11,-0.4020D-11,-0.4731D-11,-0.6460D-11,
     ,  -0.7386D-11,-0.8938D-11,-0.1095D-10,-0.1262D-10,-0.1443D-10,
     ,  -0.1871D-10,-0.2167D-10,-0.2931D-10,-0.3514D-10,-0.4127D-10,
     ,  -0.4927D-10,-0.6233D-10,-0.6883D-10,-0.8425D-10,-0.1033D-09,
     ,  -0.1102D-09,-0.1056D-09,-0.1562D-09,-0.1894D-09,-0.1915D-09,
     ,  -0.2374D-09,-0.2525D-09,-0.3273D-09,-0.3942D-09,-0.6150D-09,
     ,  -0.1035D-08,-0.1942D-08,-0.3759D-08,-0.7811D-08,-0.1654D-07,
     ,  -0.3439D-07,-0.7259D-07,-0.1527D-06,-0.3227D-06,-0.6753D-06,
     ,  -0.1399D-05,-0.2838D-05,-0.5588D-05,-0.1056D-04,-0.1886D-04,
     ,  -0.3127D-04,-0.4695D-04,-0.6188D-04,-0.6876D-04,-0.5988D-04,
     ,  -0.3308D-04, 0.5953D-05, 0.4721D-04, 0.8294D-04, 0.1104D-03,
     ,   0.1305D-03, 0.1453D-03, 0.1564D-03, 0.1650D-03, 0.1715D-03,
     ,   0.1766D-03, 0.1804D-03, 0.1833D-03, 0.1854D-03, 0.1869D-03,
     ,   0.1880D-03, 0.1888D-03, 0.1893D-03, 0.1897D-03, 0.1901D-03,
     ,   0.1903D-03, 0.1904D-03, 0.1904D-03/
      data (calcpts(j,37), j = 1,neta) /
     ,  -0.8864D-12,-0.1072D-11,-0.1159D-11,-0.1569D-11,-0.2021D-11,
     ,  -0.2510D-11,-0.3019D-11,-0.3587D-11,-0.3885D-11,-0.4738D-11,
     ,  -0.6299D-11,-0.8927D-11,-0.9067D-11,-0.1109D-10,-0.1225D-10,
     ,  -0.1688D-10,-0.1833D-10,-0.2094D-10,-0.2521D-10,-0.3271D-10,
     ,  -0.3420D-10,-0.4179D-10,-0.5188D-10,-0.6847D-10,-0.6192D-10,
     ,  -0.8379D-10,-0.9578D-10,-0.1028D-09,-0.1736D-09,-0.2292D-09,
     ,  -0.4090D-09,-0.8071D-09,-0.1491D-08,-0.3064D-08,-0.6331D-08,
     ,  -0.1310D-07,-0.2744D-07,-0.5784D-07,-0.1219D-06,-0.2555D-06,
     ,  -0.5340D-06,-0.1102D-05,-0.2222D-05,-0.4338D-05,-0.8135D-05,
     ,  -0.1443D-04,-0.2371D-04,-0.3528D-04,-0.4608D-04,-0.5066D-04,
     ,  -0.4350D-04,-0.2324D-04, 0.5677D-05, 0.3585D-04, 0.6176D-04,
     ,   0.8153D-04, 0.9598D-04, 0.1065D-03, 0.1145D-03, 0.1205D-03,
     ,   0.1253D-03, 0.1289D-03, 0.1316D-03, 0.1336D-03, 0.1351D-03,
     ,   0.1363D-03, 0.1370D-03, 0.1376D-03, 0.1380D-03, 0.1382D-03,
     ,   0.1384D-03, 0.1386D-03, 0.1387D-03/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.2461D-12,-0.4311D-12,-0.3330D-12,-0.5673D-12,-0.4781D-12,
     ,  -0.6707D-12,-0.6781D-12,-0.9871D-12,-0.1178D-11,-0.1336D-11,
     ,  -0.1742D-11,-0.2235D-11,-0.2599D-11,-0.4505D-11,-0.3705D-11,
     ,  -0.3581D-11,-0.5943D-11,-0.6054D-11,-0.7822D-11,-0.8443D-11,
     ,  -0.1034D-10,-0.1077D-10,-0.1605D-10,-0.1698D-10,-0.1974D-10,
     ,  -0.2765D-10,-0.3556D-10,-0.2429D-10,-0.6377D-10,-0.9073D-10,
     ,  -0.1415D-09,-0.2975D-09,-0.5492D-09,-0.1156D-08,-0.2375D-08,
     ,  -0.4897D-08,-0.1019D-07,-0.2136D-07,-0.4499D-07,-0.9496D-07,
     ,  -0.1998D-06,-0.4157D-06,-0.8535D-06,-0.1708D-05,-0.3321D-05,
     ,  -0.6186D-05,-0.1088D-04,-0.1777D-04,-0.2625D-04,-0.3405D-04,
     ,  -0.3707D-04,-0.3144D-04,-0.1631D-04, 0.4926D-05, 0.2690D-04,
     ,   0.4559D-04, 0.5979D-04, 0.7011D-04, 0.7761D-04, 0.8331D-04,
     ,   0.8761D-04, 0.9098D-04, 0.9356D-04, 0.9546D-04, 0.9691D-04,
     ,   0.9801D-04, 0.9875D-04, 0.9935D-04, 0.9975D-04, 0.1000D-03,
     ,   0.1002D-03, 0.1003D-03, 0.1005D-03/
      data (calcpts(j,39), j = 1,neta) /
     ,  -0.1125D-12,-0.1458D-12,-0.1164D-12,-0.2314D-12,-0.3355D-12,
     ,  -0.2561D-12,-0.3525D-12,-0.5163D-12,-0.4264D-12,-0.5667D-12,
     ,  -0.7552D-12,-0.9068D-12,-0.1191D-11,-0.1395D-11,-0.1354D-11,
     ,  -0.2640D-11,-0.2086D-11,-0.3638D-11,-0.3604D-11,-0.4910D-11,
     ,  -0.4915D-11,-0.5652D-11,-0.7037D-11,-0.7529D-11,-0.1055D-10,
     ,  -0.1231D-10,-0.1119D-10,-0.1320D-10,-0.2317D-10,-0.3643D-10,
     ,  -0.6955D-10,-0.1278D-09,-0.2211D-09,-0.4625D-09,-0.9147D-09,
     ,  -0.1842D-08,-0.3784D-08,-0.7879D-08,-0.1648D-07,-0.3486D-07,
     ,  -0.7353D-07,-0.1543D-06,-0.3200D-06,-0.6527D-06,-0.1300D-05,
     ,  -0.2514D-05,-0.4647D-05,-0.8136D-05,-0.1320D-04,-0.1938D-04,
     ,  -0.2497D-04,-0.2698D-04,-0.2268D-04,-0.1146D-04, 0.4057D-05,
     ,   0.1996D-04, 0.3340D-04, 0.4356D-04, 0.5090D-04, 0.5625D-04,
     ,   0.6028D-04, 0.6336D-04, 0.6573D-04, 0.6753D-04, 0.6894D-04,
     ,   0.6998D-04, 0.7074D-04, 0.7128D-04, 0.7168D-04, 0.7195D-04,
     ,   0.7215D-04, 0.7228D-04, 0.7241D-04/
      data (calcpts(j,40), j = 1,neta) /
     ,  -0.2939D-13,-0.5183D-13,-0.4261D-13,-0.5998D-13,-0.7177D-13,
     ,  -0.1132D-12,-0.7211D-13,-0.1430D-12,-0.1036D-12,-0.1571D-12,
     ,  -0.2193D-12,-0.3412D-12,-0.3426D-12,-0.4595D-12,-0.4144D-12,
     ,  -0.5120D-12,-0.1029D-11,-0.4062D-12,-0.4365D-12,-0.1912D-11,
     ,  -0.1616D-11,-0.2066D-11,-0.1975D-11,-0.2072D-11,-0.3264D-11,
     ,  -0.3644D-11,-0.3616D-11,-0.5394D-11,-0.4614D-11,-0.1902D-10,
     ,  -0.1960D-10,-0.4342D-10,-0.8744D-10,-0.1716D-09,-0.3305D-09,
     ,  -0.6640D-09,-0.1368D-08,-0.2847D-08,-0.5970D-08,-0.1256D-07,
     ,  -0.2664D-07,-0.5617D-07,-0.1175D-06,-0.2432D-06,-0.4936D-06,
     ,  -0.9790D-06,-0.1880D-05,-0.3462D-05,-0.6024D-05,-0.9728D-05,
     ,  -0.1420D-04,-0.1820D-04,-0.1956D-04,-0.1626D-04,-0.8026D-05,
     ,   0.3250D-05, 0.1471D-04, 0.2435D-04, 0.3159D-04, 0.3681D-04,
     ,   0.4061D-04, 0.4346D-04, 0.4564D-04, 0.4733D-04, 0.4862D-04,
     ,   0.4960D-04, 0.5033D-04, 0.5086D-04, 0.5125D-04, 0.5152D-04,
     ,   0.5173D-04, 0.5187D-04, 0.5196D-04/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.6126D-14,-0.1062D-13, 0.3719D-15,-0.9236D-14,-0.1868D-13,
     ,  -0.1419D-13,-0.1153D-13,-0.2810D-13,-0.2551D-13,-0.2259D-14,
     ,  -0.1098D-13,-0.3555D-13,-0.1076D-12,-0.7383D-13,-0.4035D-13,
     ,  -0.1089D-12,-0.1778D-12,-0.1605D-12,-0.6139D-12,-0.2817D-12,
     ,  -0.6856D-13,-0.1734D-12,-0.6863D-12,-0.4189D-12,-0.1349D-12,
     ,  -0.6073D-12,-0.8326D-12,-0.1029D-11,-0.2841D-11,-0.4288D-11,
     ,  -0.4439D-11,-0.2012D-10,-0.2959D-10,-0.5688D-10,-0.1199D-09,
     ,  -0.2418D-09,-0.4820D-09,-0.1001D-08,-0.2129D-08,-0.4484D-08,
     ,  -0.9517D-08,-0.2017D-07,-0.4255D-07,-0.8876D-07,-0.1828D-06,
     ,  -0.3698D-06,-0.7296D-06,-0.1395D-05,-0.2557D-05,-0.4430D-05,
     ,  -0.7119D-05,-0.1035D-04,-0.1320D-04,-0.1410D-04,-0.1163D-04,
     ,  -0.5615D-05, 0.2540D-05, 0.1078D-04, 0.1766D-04, 0.2282D-04,
     ,   0.2652D-04, 0.2921D-04, 0.3122D-04, 0.3277D-04, 0.3396D-04,
     ,   0.3488D-04, 0.3557D-04, 0.3608D-04, 0.3646D-04, 0.3673D-04,
     ,   0.3693D-04, 0.3707D-04, 0.3717D-04/
      data (calcpts(j,42), j = 1,neta) /
     ,  -0.9924D-14,-0.6004D-14,-0.7569D-14,-0.5555D-14,-0.1042D-13,
     ,  -0.7883D-14,-0.8534D-14, 0.7398D-14,-0.1311D-13,-0.2224D-13,
     ,  -0.4516D-13,-0.4907D-13,-0.3165D-13,-0.5504D-13,-0.2488D-13,
     ,  -0.7576D-14,-0.5484D-13,-0.8173D-13,-0.8611D-13,-0.3570D-12,
     ,  -0.2967D-12,-0.3831D-12,-0.4881D-12,-0.3043D-13,-0.2352D-12,
     ,  -0.4493D-12,-0.5212D-12,-0.3736D-12,-0.1140D-11,-0.1932D-11,
     ,  -0.2933D-11,-0.6075D-11,-0.7956D-11,-0.2302D-10,-0.4311D-10,
     ,  -0.8284D-10,-0.1726D-09,-0.3624D-09,-0.7587D-09,-0.1603D-08,
     ,  -0.3397D-08,-0.7203D-08,-0.1524D-07,-0.3197D-07,-0.6654D-07,
     ,  -0.1363D-06,-0.2747D-06,-0.5397D-06,-0.1028D-05,-0.1877D-05,
     ,  -0.3239D-05,-0.5186D-05,-0.7512D-05,-0.9534D-05,-0.1014D-04,
     ,  -0.8303D-05,-0.3928D-05, 0.1946D-05, 0.7853D-05, 0.1276D-04,
     ,   0.1642D-04, 0.1904D-04, 0.2094D-04, 0.2236D-04, 0.2346D-04,
     ,   0.2430D-04, 0.2494D-04, 0.2543D-04, 0.2579D-04, 0.2606D-04,
     ,   0.2625D-04, 0.2639D-04, 0.2648D-04/
      data (calcpts(j,43), j = 1,neta) /
     ,  -0.2566D-14,-0.2218D-14, 0.3057D-14,-0.6039D-15, 0.8602D-15,
     ,  -0.2372D-14,-0.4716D-14,-0.4360D-14,-0.5128D-15,-0.8079D-14,
     ,  -0.2692D-13, 0.5917D-14, 0.8956D-14,-0.1308D-13, 0.6811D-14,
     ,  -0.2298D-13,-0.4273D-13,-0.1349D-13,-0.4087D-13,-0.4885D-13,
     ,  -0.1091D-13, 0.6716D-13,-0.2341D-12,-0.1153D-13, 0.1523D-13,
     ,  -0.2545D-12, 0.1245D-12,-0.2384D-12,-0.3614D-12,-0.7118D-12,
     ,  -0.1203D-11,-0.2241D-11,-0.3679D-11,-0.7333D-11,-0.1238D-10,
     ,  -0.2724D-10,-0.6108D-10,-0.1316D-09,-0.2630D-09,-0.5548D-09,
     ,  -0.1184D-08,-0.2540D-08,-0.5409D-08,-0.1138D-07,-0.2392D-07,
     ,  -0.4940D-07,-0.1011D-06,-0.2028D-06,-0.3969D-06,-0.7526D-06,
     ,  -0.1370D-05,-0.2356D-05,-0.3759D-05,-0.5429D-05,-0.6863D-05,
     ,  -0.7268D-05,-0.5913D-05,-0.2746D-05, 0.1474D-05, 0.5690D-05,
     ,   0.9181D-05, 0.1178D-04, 0.1363D-04, 0.1497D-04, 0.1597D-04,
     ,   0.1675D-04, 0.1734D-04, 0.1780D-04, 0.1814D-04, 0.1839D-04,
     ,   0.1858D-04, 0.1871D-04, 0.1882D-04/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.1604D-15,-0.5682D-14,-0.3417D-14,-0.3440D-14,-0.2335D-15,
     ,   0.1500D-15,-0.4248D-15,-0.4015D-15, 0.2413D-15, 0.1303D-14,
     ,   0.9725D-15, 0.6486D-14,-0.1140D-13, 0.7641D-14, 0.1989D-13,
     ,   0.1568D-13, 0.1798D-14,-0.8408D-14,-0.6373D-14, 0.6523D-14,
     ,   0.1534D-13, 0.2083D-13,-0.1274D-13,-0.1241D-12, 0.1093D-13,
     ,  -0.9412D-13, 0.4939D-13, 0.7695D-13, 0.5193D-13,-0.6008D-13,
     ,  -0.2649D-12,-0.6709D-12,-0.9432D-12,-0.2164D-11,-0.4909D-11,
     ,  -0.1011D-10,-0.2067D-10,-0.4364D-10,-0.9314D-10,-0.2001D-09,
     ,  -0.4099D-09,-0.8830D-09,-0.1890D-08,-0.4032D-08,-0.8449D-08,
     ,  -0.1768D-07,-0.3645D-07,-0.7427D-07,-0.1486D-06,-0.2899D-06,
     ,  -0.5482D-06,-0.9946D-06,-0.1706D-05,-0.2714D-05,-0.3907D-05,
     ,  -0.4927D-05,-0.5192D-05,-0.4201D-05,-0.1921D-05, 0.1107D-05,
     ,   0.4110D-05, 0.6588D-05, 0.8426D-05, 0.9735D-05, 0.1068D-04,
     ,   0.1139D-04, 0.1193D-04, 0.1235D-04, 0.1266D-04, 0.1291D-04,
     ,   0.1309D-04, 0.1322D-04, 0.1332D-04/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.3435D-14, 0.4037D-14, 0.4537D-14, 0.7193D-15, 0.7420D-16,
     ,   0.1400D-14, 0.8301D-15, 0.1167D-14, 0.1810D-14,-0.1502D-14,
     ,  -0.2675D-14,-0.1899D-14,-0.2958D-14,-0.9640D-14,-0.7795D-14,
     ,   0.1393D-14,-0.3901D-14,-0.3274D-14,-0.1764D-13,-0.2643D-13,
     ,  -0.9669D-14,-0.1086D-13,-0.2696D-13,-0.2995D-13,-0.4628D-13,
     ,  -0.1463D-12,-0.3430D-14,-0.1381D-12,-0.1152D-12,-0.1233D-12,
     ,  -0.2291D-12,-0.5241D-12,-0.5303D-12,-0.1096D-11,-0.2217D-11,
     ,  -0.3982D-11,-0.8100D-11,-0.1601D-10,-0.3326D-10,-0.6958D-10,
     ,  -0.1476D-09,-0.3132D-09,-0.6657D-09,-0.1415D-08,-0.2988D-08,
     ,  -0.6276D-08,-0.1305D-07,-0.2683D-07,-0.5440D-07,-0.1083D-06,
     ,  -0.2107D-06,-0.3980D-06,-0.7194D-06,-0.1231D-05,-0.1954D-05,
     ,  -0.2804D-05,-0.3529D-05,-0.3705D-05,-0.2986D-05,-0.1343D-05,
     ,   0.8177D-06, 0.2956D-05, 0.4714D-05, 0.6009D-05, 0.6933D-05,
     ,   0.7597D-05, 0.8095D-05, 0.8476D-05, 0.8772D-05, 0.8994D-05,
     ,   0.9167D-05, 0.9294D-05, 0.9386D-05/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.4044D-14, 0.2631D-14, 0.2265D-14, 0.2128D-14, 0.2679D-14,
     ,   0.1355D-14,-0.5103D-15, 0.2325D-15, 0.1310D-14, 0.6407D-15,
     ,  -0.1888D-15,-0.1307D-14,-0.4504D-15,-0.1556D-14, 0.6400D-15,
     ,  -0.5998D-14,-0.8746D-14,-0.6646D-14, 0.3496D-14,-0.9847D-14,
     ,  -0.4090D-14,-0.9509D-14,-0.6924D-14,-0.9366D-14,-0.3659D-14,
     ,  -0.2228D-13,-0.9340D-16, 0.3470D-13, 0.2232D-13,-0.1108D-12,
     ,  -0.8917D-13,-0.2103D-12,-0.1779D-12,-0.3899D-12,-0.8117D-12,
     ,  -0.1298D-11,-0.2778D-11,-0.5657D-11,-0.1127D-10,-0.2362D-10,
     ,  -0.5044D-10,-0.1080D-09,-0.2302D-09,-0.4914D-09,-0.1041D-08,
     ,  -0.2200D-08,-0.4599D-08,-0.9540D-08,-0.1957D-07,-0.3958D-07,
     ,  -0.7865D-07,-0.1527D-06,-0.2872D-06,-0.5190D-06,-0.8858D-06,
     ,  -0.1401D-05,-0.2009D-05,-0.2519D-05,-0.2637D-05,-0.2110D-05,
     ,  -0.9366D-06, 0.6034D-06, 0.2122D-05, 0.3365D-05, 0.4280D-05,
     ,   0.4929D-05, 0.5398D-05, 0.5747D-05, 0.6016D-05, 0.6222D-05,
     ,   0.6380D-05, 0.6499D-05, 0.6588D-05/
      data (calcpts(j,47), j = 1,neta) /
     ,   0.1167D-14,-0.5025D-15,-0.2658D-16, 0.3392D-15, 0.7297D-15,
     ,  -0.2709D-15, 0.4640D-15, 0.2297D-15, 0.1245D-14,-0.9138D-16,
     ,   0.9323D-15, 0.5678D-15, 0.4615D-15, 0.2787D-15, 0.1005D-14,
     ,   0.6465D-15,-0.2245D-14, 0.3141D-14,-0.2603D-14, 0.3037D-14,
     ,  -0.1082D-14, 0.1109D-14,-0.2063D-14, 0.5006D-14,-0.7344D-15,
     ,   0.3204D-15, 0.9553D-14, 0.4886D-14,-0.1150D-14,-0.4374D-13,
     ,  -0.5391D-13, 0.3629D-14,-0.4883D-14,-0.1316D-12,-0.1844D-12,
     ,  -0.3935D-12,-0.8997D-12,-0.1768D-11,-0.3761D-11,-0.7915D-11,
     ,  -0.1704D-10,-0.3670D-10,-0.7886D-10,-0.1699D-09,-0.3605D-09,
     ,  -0.7633D-09,-0.1608D-08,-0.3357D-08,-0.6942D-08,-0.1420D-07,
     ,  -0.2866D-07,-0.5683D-07,-0.1101D-06,-0.2068D-06,-0.3725D-06,
     ,  -0.6344D-06,-0.1003D-05,-0.1435D-05,-0.1793D-05,-0.1873D-05,
     ,  -0.1494D-05,-0.6534D-06, 0.4426D-06, 0.1519D-05, 0.2397D-05,
     ,   0.3042D-05, 0.3499D-05, 0.3828D-05, 0.4073D-05, 0.4262D-05,
     ,   0.4407D-05, 0.4518D-05, 0.4602D-05/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.2188D-14, 0.2204D-14, 0.6047D-15,-0.1528D-15, 0.1378D-14,
     ,   0.9978D-15, 0.1371D-14, 0.2705D-15, 0.5395D-15, 0.4495D-15,
     ,   0.3836D-15, 0.3531D-15, 0.2198D-15, 0.1332D-15, 0.2273D-15,
     ,   0.2981D-16, 0.1064D-15,-0.1560D-15, 0.2549D-14,-0.9865D-15,
     ,   0.2971D-14, 0.1318D-14,-0.1611D-14, 0.2298D-15,-0.2250D-14,
     ,  -0.1487D-14, 0.2543D-14, 0.8794D-16,-0.4489D-14,-0.5695D-14,
     ,  -0.3490D-13,-0.3181D-13, 0.1042D-13,-0.3698D-13,-0.4427D-13,
     ,  -0.1382D-12,-0.2748D-12,-0.7107D-12,-0.1374D-11,-0.2839D-11,
     ,  -0.5898D-11,-0.1296D-10,-0.2763D-10,-0.5815D-10,-0.1242D-09,
     ,  -0.2643D-09,-0.5594D-09,-0.1171D-08,-0.2443D-08,-0.5041D-08,
     ,  -0.1029D-07,-0.2070D-07,-0.4094D-07,-0.7914D-07,-0.1484D-06,
     ,  -0.2669D-06,-0.4540D-06,-0.7160D-06,-0.1022D-05,-0.1275D-05,
     ,  -0.1328D-05,-0.1055D-05,-0.4555D-06, 0.3225D-06, 0.1084D-05,
     ,   0.1704D-05, 0.2158D-05, 0.2479D-05, 0.2710D-05, 0.2882D-05,
     ,   0.3014D-05, 0.3116D-05, 0.3194D-05/
      data (calcpts(j,49), j = 1,neta) /
     ,   0.4038D-15, 0.2429D-14,-0.2764D-14, 0.6810D-15,-0.1625D-14,
     ,  -0.3574D-15, 0.1150D-15, 0.8737D-15, 0.4453D-15, 0.1325D-15,
     ,  -0.2836D-15,-0.1630D-15,-0.3039D-15, 0.2387D-15, 0.4247D-15,
     ,   0.5864D-16,-0.2393D-15,-0.2228D-15, 0.4684D-16,-0.5170D-15,
     ,  -0.1307D-14,-0.1579D-14, 0.3860D-15,-0.3062D-16,-0.2099D-15,
     ,  -0.1877D-14, 0.1246D-14, 0.1830D-14, 0.4168D-15,-0.5625D-15,
     ,  -0.1005D-15,-0.4469D-14,-0.3788D-14,-0.2692D-13,-0.3884D-13,
     ,  -0.1891D-13,-0.8060D-13,-0.1954D-12,-0.3886D-12,-0.9906D-12,
     ,  -0.2046D-11,-0.4309D-11,-0.9452D-11,-0.2034D-10,-0.4270D-10,
     ,  -0.9088D-10,-0.1941D-09,-0.4062D-09,-0.8497D-09,-0.1766D-08,
     ,  -0.3639D-08,-0.7407D-08,-0.1491D-07,-0.2941D-07,-0.5677D-07,
     ,  -0.1062D-06,-0.1908D-06,-0.3239D-06,-0.5100D-06,-0.7265D-06,
     ,  -0.9052D-06,-0.9407D-06,-0.7443D-06,-0.3174D-06, 0.2339D-06,
     ,   0.7721D-06, 0.1209D-05, 0.1528D-05, 0.1754D-05, 0.1916D-05,
     ,   0.2036D-05, 0.2129D-05, 0.2200D-05/










      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
c-----------------------------
      subroutine clhqg21p(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.1155D-12, 0.2034D-12, 0.3908D-12, 0.1742D-14, 0.1300D-11,
     ,   0.1499D-11, 0.1837D-11, 0.4128D-11, 0.6231D-11, 0.1061D-10,
     ,   0.1967D-10, 0.3305D-10, 0.5602D-10, 0.9685D-10, 0.1633D-09,
     ,   0.2810D-09, 0.4797D-09, 0.8174D-09, 0.1383D-08, 0.2348D-08,
     ,   0.3955D-08, 0.6648D-08, 0.1113D-07, 0.1851D-07, 0.3059D-07,
     ,   0.5011D-07, 0.8106D-07, 0.1290D-06, 0.2013D-06, 0.3051D-06,
     ,   0.4449D-06, 0.6158D-06, 0.7949D-06, 0.9364D-06, 0.9791D-06,
     ,   0.8754D-06, 0.6296D-06, 0.3056D-06,-0.1079D-07,-0.2581D-06,
     ,  -0.4232D-06,-0.5224D-06,-0.5807D-06,-0.6169D-06,-0.6416D-06,
     ,  -0.6603D-06,-0.6746D-06,-0.6856D-06,-0.6944D-06,-0.7005D-06,
     ,  -0.7052D-06,-0.7086D-06,-0.7106D-06,-0.7127D-06,-0.7140D-06,
     ,  -0.7147D-06,-0.7154D-06,-0.7154D-06,-0.7160D-06,-0.7160D-06,
     ,  -0.7160D-06,-0.7160D-06,-0.7160D-06,-0.7160D-06,-0.7160D-06,
     ,  -0.7167D-06,-0.7167D-06,-0.7167D-06,-0.7167D-06,-0.7167D-06,
     ,  -0.7167D-06,-0.7167D-06,-0.7167D-06/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.5008D-12, 0.8411D-13, 0.2997D-12, 0.3530D-12, 0.1423D-11,
     ,   0.2184D-11, 0.3362D-11, 0.6118D-11, 0.9324D-11, 0.1685D-10,
     ,   0.2957D-10, 0.4940D-10, 0.8643D-10, 0.1448D-09, 0.2382D-09,
     ,   0.4184D-09, 0.7084D-09, 0.1207D-08, 0.2035D-08, 0.3450D-08,
     ,   0.5804D-08, 0.9759D-08, 0.1633D-07, 0.2717D-07, 0.4492D-07,
     ,   0.7345D-07, 0.1189D-06, 0.1894D-06, 0.2954D-06, 0.4477D-06,
     ,   0.6527D-06, 0.9033D-06, 0.1166D-05, 0.1375D-05, 0.1437D-05,
     ,   0.1286D-05, 0.9251D-06, 0.4495D-06,-0.1551D-07,-0.3789D-06,
     ,  -0.6209D-06,-0.7667D-06,-0.8522D-06,-0.9050D-06,-0.9413D-06,
     ,  -0.9684D-06,-0.9901D-06,-0.1006D-05,-0.1018D-05,-0.1028D-05,
     ,  -0.1035D-05,-0.1039D-05,-0.1044D-05,-0.1046D-05,-0.1048D-05,
     ,  -0.1049D-05,-0.1050D-05,-0.1050D-05,-0.1050D-05,-0.1051D-05,
     ,  -0.1051D-05,-0.1051D-05,-0.1051D-05,-0.1051D-05,-0.1051D-05,
     ,  -0.1051D-05,-0.1051D-05,-0.1051D-05,-0.1051D-05,-0.1051D-05,
     ,  -0.1051D-05,-0.1051D-05,-0.1051D-05/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.4072D-12,-0.3638D-12,-0.3714D-12, 0.2209D-12, 0.1041D-11,
     ,   0.2092D-11, 0.4020D-11, 0.7232D-11, 0.1188D-10, 0.2172D-10,
     ,   0.3875D-10, 0.6678D-10, 0.1160D-09, 0.2089D-09, 0.3535D-09,
     ,   0.6046D-09, 0.1025D-08, 0.1751D-08, 0.2972D-08, 0.5040D-08,
     ,   0.8490D-08, 0.1429D-07, 0.2395D-07, 0.3983D-07, 0.6577D-07,
     ,   0.1078D-06, 0.1744D-06, 0.2778D-06, 0.4332D-06, 0.6566D-06,
     ,   0.9576D-06, 0.1325D-05, 0.1712D-05, 0.2016D-05, 0.2108D-05,
     ,   0.1885D-05, 0.1357D-05, 0.6578D-06,-0.2368D-07,-0.5563D-06,
     ,  -0.9119D-06,-0.1126D-05,-0.1251D-05,-0.1328D-05,-0.1382D-05,
     ,  -0.1422D-05,-0.1453D-05,-0.1477D-05,-0.1495D-05,-0.1509D-05,
     ,  -0.1519D-05,-0.1526D-05,-0.1531D-05,-0.1535D-05,-0.1538D-05,
     ,  -0.1539D-05,-0.1540D-05,-0.1541D-05,-0.1542D-05,-0.1542D-05,
     ,  -0.1542D-05,-0.1542D-05,-0.1542D-05,-0.1543D-05,-0.1543D-05,
     ,  -0.1543D-05,-0.1543D-05,-0.1543D-05,-0.1543D-05,-0.1543D-05,
     ,  -0.1543D-05,-0.1543D-05,-0.1543D-05/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.3884D-12, 0.1931D-13,-0.1890D-12, 0.7105D-12, 0.2231D-11,
     ,   0.3556D-11, 0.6498D-11, 0.1117D-10, 0.1749D-10, 0.3562D-10,
     ,   0.5765D-10, 0.1010D-09, 0.1759D-09, 0.3037D-09, 0.5151D-09,
     ,   0.8810D-09, 0.1515D-08, 0.2570D-08, 0.4365D-08, 0.7401D-08,
     ,   0.1250D-07, 0.2095D-07, 0.3507D-07, 0.5846D-07, 0.9653D-07,
     ,   0.1581D-06, 0.2557D-06, 0.4074D-06, 0.6352D-06, 0.9635D-06,
     ,   0.1404D-05, 0.1944D-05, 0.2510D-05, 0.2958D-05, 0.3093D-05,
     ,   0.2766D-05, 0.1991D-05, 0.9662D-06,-0.3332D-07,-0.8154D-06,
     ,  -0.1337D-05,-0.1651D-05,-0.1835D-05,-0.1949D-05,-0.2027D-05,
     ,  -0.2086D-05,-0.2131D-05,-0.2167D-05,-0.2194D-05,-0.2214D-05,
     ,  -0.2228D-05,-0.2239D-05,-0.2246D-05,-0.2252D-05,-0.2256D-05,
     ,  -0.2258D-05,-0.2260D-05,-0.2261D-05,-0.2262D-05,-0.2262D-05,
     ,  -0.2262D-05,-0.2263D-05,-0.2263D-05,-0.2263D-05,-0.2263D-05,
     ,  -0.2264D-05,-0.2264D-05,-0.2264D-05,-0.2264D-05,-0.2264D-05,
     ,  -0.2264D-05,-0.2264D-05,-0.2264D-05/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.5822D-12, 0.1698D-11, 0.1342D-11, 0.2653D-11, 0.4237D-11,
     ,   0.6914D-11, 0.6048D-11, 0.2000D-10, 0.3430D-10, 0.5368D-10,
     ,   0.9419D-10, 0.1497D-09, 0.2594D-09, 0.4544D-09, 0.7658D-09,
     ,   0.1305D-08, 0.2230D-08, 0.3789D-08, 0.6383D-08, 0.1085D-07,
     ,   0.1830D-07, 0.3073D-07, 0.5150D-07, 0.8565D-07, 0.1415D-06,
     ,   0.2318D-06, 0.3749D-06, 0.5972D-06, 0.9309D-06, 0.1412D-05,
     ,   0.2058D-05, 0.2850D-05, 0.3680D-05, 0.4337D-05, 0.4535D-05,
     ,   0.4059D-05, 0.2922D-05, 0.1420D-05,-0.4646D-07,-0.1195D-05,
     ,  -0.1959D-05,-0.2420D-05,-0.2690D-05,-0.2858D-05,-0.2972D-05,
     ,  -0.3060D-05,-0.3126D-05,-0.3177D-05,-0.3217D-05,-0.3246D-05,
     ,  -0.3268D-05,-0.3283D-05,-0.3295D-05,-0.3302D-05,-0.3308D-05,
     ,  -0.3312D-05,-0.3314D-05,-0.3316D-05,-0.3317D-05,-0.3318D-05,
     ,  -0.3318D-05,-0.3319D-05,-0.3319D-05,-0.3319D-05,-0.3320D-05,
     ,  -0.3320D-05,-0.3320D-05,-0.3320D-05,-0.3320D-05,-0.3320D-05,
     ,  -0.3320D-05,-0.3320D-05,-0.3320D-05/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.3368D-12, 0.1257D-11, 0.1403D-11, 0.2483D-11, 0.1651D-11,
     ,   0.4708D-11, 0.1667D-10, 0.3089D-10, 0.4099D-10, 0.7755D-10,
     ,   0.1331D-09, 0.2182D-09, 0.3869D-09, 0.6621D-09, 0.1113D-08,
     ,   0.1905D-08, 0.3298D-08, 0.5555D-08, 0.9396D-08, 0.1588D-07,
     ,   0.2682D-07, 0.4507D-07, 0.7541D-07, 0.1254D-06, 0.2073D-06,
     ,   0.3394D-06, 0.5491D-06, 0.8743D-06, 0.1365D-05, 0.2068D-05,
     ,   0.3016D-05, 0.4176D-05, 0.5393D-05, 0.6356D-05, 0.6653D-05,
     ,   0.5949D-05, 0.4289D-05, 0.2087D-05,-0.6866D-07,-0.1751D-05,
     ,  -0.2872D-05,-0.3548D-05,-0.3945D-05,-0.4191D-05,-0.4360D-05,
     ,  -0.4486D-05,-0.4585D-05,-0.4660D-05,-0.4718D-05,-0.4761D-05,
     ,  -0.4793D-05,-0.4816D-05,-0.4832D-05,-0.4843D-05,-0.4851D-05,
     ,  -0.4857D-05,-0.4860D-05,-0.4863D-05,-0.4865D-05,-0.4866D-05,
     ,  -0.4867D-05,-0.4868D-05,-0.4868D-05,-0.4868D-05,-0.4868D-05,
     ,  -0.4868D-05,-0.4868D-05,-0.4868D-05,-0.4869D-05,-0.4869D-05,
     ,  -0.4869D-05,-0.4869D-05,-0.4869D-05/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.1334D-11, 0.1955D-11, 0.3786D-11, 0.8425D-11, 0.1148D-10,
     ,   0.1585D-10, 0.2424D-10, 0.3507D-10, 0.5796D-10, 0.1082D-09,
     ,   0.1905D-09, 0.3224D-09, 0.5579D-09, 0.9609D-09, 0.1621D-08,
     ,   0.2773D-08, 0.4749D-08, 0.8127D-08, 0.1370D-07, 0.2326D-07,
     ,   0.3925D-07, 0.6588D-07, 0.1103D-06, 0.1835D-06, 0.3033D-06,
     ,   0.4965D-06, 0.8041D-06, 0.1280D-05, 0.1997D-05, 0.3027D-05,
     ,   0.4416D-05, 0.6115D-05, 0.7900D-05, 0.9309D-05, 0.9741D-05,
     ,   0.8726D-05, 0.6282D-05, 0.3062D-05,-0.9115D-07,-0.2563D-05,
     ,  -0.4209D-05,-0.5200D-05,-0.5781D-05,-0.6144D-05,-0.6390D-05,
     ,  -0.6576D-05,-0.6719D-05,-0.6830D-05,-0.6917D-05,-0.6978D-05,
     ,  -0.7025D-05,-0.7059D-05,-0.7079D-05,-0.7099D-05,-0.7113D-05,
     ,  -0.7120D-05,-0.7127D-05,-0.7127D-05,-0.7133D-05,-0.7133D-05,
     ,  -0.7133D-05,-0.7133D-05,-0.7133D-05,-0.7133D-05,-0.7133D-05,
     ,  -0.7133D-05,-0.7133D-05,-0.7133D-05,-0.7133D-05,-0.7133D-05,
     ,  -0.7133D-05,-0.7133D-05,-0.7133D-05/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.3433D-11, 0.1663D-11, 0.8830D-11, 0.7476D-11, 0.1002D-10,
     ,   0.2426D-10, 0.3819D-10, 0.6459D-10, 0.9360D-10, 0.1655D-09,
     ,   0.2909D-09, 0.4914D-09, 0.8399D-09, 0.1441D-08, 0.2416D-08,
     ,   0.4080D-08, 0.6971D-08, 0.1187D-07, 0.2010D-07, 0.3400D-07,
     ,   0.5739D-07, 0.9646D-07, 0.1613D-06, 0.2684D-06, 0.4431D-06,
     ,   0.7253D-06, 0.1175D-05, 0.1871D-05, 0.2919D-05, 0.4425D-05,
     ,   0.6456D-05, 0.8946D-05, 0.1155D-04, 0.1362D-04, 0.1426D-04,
     ,   0.1278D-04, 0.9221D-05, 0.4497D-05,-0.1185D-06,-0.3739D-05,
     ,  -0.6151D-05,-0.7609D-05,-0.8465D-05,-0.8993D-05,-0.9359D-05,
     ,  -0.9629D-05,-0.9840D-05,-0.1000D-04,-0.1013D-04,-0.1022D-04,
     ,  -0.1029D-04,-0.1034D-04,-0.1037D-04,-0.1039D-04,-0.1041D-04,
     ,  -0.1043D-04,-0.1043D-04,-0.1044D-04,-0.1044D-04,-0.1045D-04,
     ,  -0.1045D-04,-0.1045D-04,-0.1045D-04,-0.1045D-04,-0.1046D-04,
     ,  -0.1046D-04,-0.1046D-04,-0.1046D-04,-0.1046D-04,-0.1046D-04,
     ,  -0.1046D-04,-0.1046D-04,-0.1046D-04/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1617D-11,-0.1415D-11, 0.7001D-12, 0.5553D-11, 0.1088D-10,
     ,   0.1844D-10, 0.3678D-10, 0.7245D-10, 0.1199D-09, 0.2201D-09,
     ,   0.4376D-09, 0.6943D-09, 0.1199D-08, 0.1978D-08, 0.3424D-08,
     ,   0.5889D-08, 0.1010D-07, 0.1713D-07, 0.2916D-07, 0.4949D-07,
     ,   0.8344D-07, 0.1403D-06, 0.2348D-06, 0.3914D-06, 0.6458D-06,
     ,   0.1058D-05, 0.1712D-05, 0.2729D-05, 0.4257D-05, 0.6456D-05,
     ,   0.9420D-05, 0.1305D-04, 0.1687D-04, 0.1991D-04, 0.2085D-04,
     ,   0.1870D-04, 0.1349D-04, 0.6597D-05,-0.1563D-06,-0.5466D-05,
     ,  -0.9008D-05,-0.1113D-04,-0.1238D-04,-0.1317D-04,-0.1370D-04,
     ,  -0.1410D-04,-0.1440D-04,-0.1465D-04,-0.1483D-04,-0.1497D-04,
     ,  -0.1506D-04,-0.1513D-04,-0.1519D-04,-0.1522D-04,-0.1525D-04,
     ,  -0.1526D-04,-0.1528D-04,-0.1528D-04,-0.1529D-04,-0.1530D-04,
     ,  -0.1530D-04,-0.1530D-04,-0.1530D-04,-0.1530D-04,-0.1530D-04,
     ,  -0.1530D-04,-0.1530D-04,-0.1530D-04,-0.1530D-04,-0.1530D-04,
     ,  -0.1530D-04,-0.1530D-04,-0.1530D-04/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.3515D-11, 0.6905D-11, 0.3894D-11, 0.6437D-11, 0.2283D-10,
     ,   0.3863D-10, 0.6628D-10, 0.1223D-09, 0.2225D-09, 0.3648D-09,
     ,   0.6005D-09, 0.1013D-08, 0.1716D-08, 0.2936D-08, 0.4994D-08,
     ,   0.8611D-08, 0.1473D-07, 0.2508D-07, 0.4255D-07, 0.7209D-07,
     ,   0.1209D-06, 0.2045D-06, 0.3422D-06, 0.5686D-06, 0.9392D-06,
     ,   0.1539D-05, 0.2490D-05, 0.3969D-05, 0.6193D-05, 0.9396D-05,
     ,   0.1371D-04, 0.1900D-04, 0.2458D-04, 0.2902D-04, 0.3044D-04,
     ,   0.2732D-04, 0.1977D-04, 0.9700D-05,-0.1750D-06,-0.7940D-05,
     ,  -0.1313D-04,-0.1625D-04,-0.1809D-04,-0.1924D-04,-0.2001D-04,
     ,  -0.2059D-04,-0.2105D-04,-0.2140D-04,-0.2166D-04,-0.2187D-04,
     ,  -0.2201D-04,-0.2212D-04,-0.2219D-04,-0.2225D-04,-0.2228D-04,
     ,  -0.2231D-04,-0.2233D-04,-0.2233D-04,-0.2235D-04,-0.2235D-04,
     ,  -0.2235D-04,-0.2235D-04,-0.2236D-04,-0.2236D-04,-0.2236D-04,
     ,  -0.2236D-04,-0.2236D-04,-0.2236D-04,-0.2236D-04,-0.2236D-04,
     ,  -0.2236D-04,-0.2236D-04,-0.2236D-04/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.1363D-10, 0.1684D-10, 0.1131D-10, 0.2352D-10, 0.4626D-10,
     ,   0.7556D-10, 0.8510D-10, 0.2081D-09, 0.3149D-09, 0.4691D-09,
     ,   0.8491D-09, 0.1517D-08, 0.2587D-08, 0.4399D-08, 0.7393D-08,
     ,   0.1261D-07, 0.2154D-07, 0.3649D-07, 0.6213D-07, 0.1043D-06,
     ,   0.1763D-06, 0.2957D-06, 0.4946D-06, 0.8242D-06, 0.1361D-05,
     ,   0.2229D-05, 0.3608D-05, 0.5749D-05, 0.8972D-05, 0.1361D-04,
     ,   0.1988D-04, 0.2758D-04, 0.3570D-04, 0.4220D-04, 0.4431D-04,
     ,   0.3986D-04, 0.2891D-04, 0.1427D-04,-0.1297D-06,-0.1147D-04,
     ,  -0.1908D-04,-0.2366D-04,-0.2635D-04,-0.2802D-04,-0.2916D-04,
     ,  -0.3002D-04,-0.3068D-04,-0.3120D-04,-0.3158D-04,-0.3188D-04,
     ,  -0.3209D-04,-0.3225D-04,-0.3236D-04,-0.3244D-04,-0.3249D-04,
     ,  -0.3253D-04,-0.3255D-04,-0.3257D-04,-0.3258D-04,-0.3259D-04,
     ,  -0.3260D-04,-0.3260D-04,-0.3261D-04,-0.3261D-04,-0.3261D-04,
     ,  -0.3261D-04,-0.3261D-04,-0.3261D-04,-0.3261D-04,-0.3261D-04,
     ,  -0.3261D-04,-0.3261D-04,-0.3261D-04/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.1847D-10, 0.2871D-10, 0.2651D-10, 0.4028D-10, 0.7589D-10,
     ,   0.6790D-10, 0.1657D-09, 0.3284D-09, 0.4228D-09, 0.7852D-09,
     ,   0.1284D-08, 0.2171D-08, 0.3739D-08, 0.6277D-08, 0.1064D-07,
     ,   0.1813D-07, 0.3109D-07, 0.5228D-07, 0.8882D-07, 0.1501D-06,
     ,   0.2529D-06, 0.4250D-06, 0.7119D-06, 0.1184D-05, 0.1958D-05,
     ,   0.3207D-05, 0.5191D-05, 0.8278D-05, 0.1292D-04, 0.1961D-04,
     ,   0.2866D-04, 0.3979D-04, 0.5158D-04, 0.6106D-04, 0.6430D-04,
     ,   0.5792D-04, 0.4219D-04, 0.2097D-04, 0.2341D-07,-0.1651D-04,
     ,  -0.2761D-04,-0.3433D-04,-0.3827D-04,-0.4072D-04,-0.4239D-04,
     ,  -0.4364D-04,-0.4461D-04,-0.4536D-04,-0.4593D-04,-0.4636D-04,
     ,  -0.4667D-04,-0.4689D-04,-0.4706D-04,-0.4717D-04,-0.4725D-04,
     ,  -0.4731D-04,-0.4734D-04,-0.4737D-04,-0.4739D-04,-0.4740D-04,
     ,  -0.4741D-04,-0.4742D-04,-0.4742D-04,-0.4742D-04,-0.4742D-04,
     ,  -0.4742D-04,-0.4742D-04,-0.4742D-04,-0.4742D-04,-0.4742D-04,
     ,  -0.4742D-04,-0.4742D-04,-0.4742D-04/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.3368D-10, 0.5587D-10, 0.5776D-10, 0.5970D-10, 0.1768D-09,
     ,   0.2161D-09, 0.2470D-09, 0.5035D-09, 0.7464D-09, 0.1199D-08,
     ,   0.1996D-08, 0.3214D-08, 0.5404D-08, 0.9228D-08, 0.1532D-07,
     ,   0.2565D-07, 0.4403D-07, 0.7465D-07, 0.1273D-06, 0.2146D-06,
     ,   0.3612D-06, 0.6073D-06, 0.1015D-05, 0.1689D-05, 0.2791D-05,
     ,   0.4571D-05, 0.7404D-05, 0.1180D-04, 0.1844D-04, 0.2801D-04,
     ,   0.4098D-04, 0.5697D-04, 0.7401D-04, 0.8782D-04, 0.9271D-04,
     ,   0.8400D-04, 0.6144D-04, 0.3094D-04, 0.5772D-06,-0.2349D-04,
     ,  -0.3969D-04,-0.4951D-04,-0.5529D-04,-0.5888D-04,-0.6132D-04,
     ,  -0.6314D-04,-0.6455D-04,-0.6565D-04,-0.6648D-04,-0.6711D-04,
     ,  -0.6758D-04,-0.6792D-04,-0.6812D-04,-0.6833D-04,-0.6840D-04,
     ,  -0.6846D-04,-0.6853D-04,-0.6860D-04,-0.6860D-04,-0.6860D-04,
     ,  -0.6867D-04,-0.6867D-04,-0.6867D-04,-0.6867D-04,-0.6867D-04,
     ,  -0.6867D-04,-0.6867D-04,-0.6867D-04,-0.6867D-04,-0.6867D-04,
     ,  -0.6867D-04,-0.6867D-04,-0.6867D-04/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1806D-10, 0.6807D-10, 0.6680D-10, 0.8217D-10, 0.1009D-09,
     ,   0.1754D-09, 0.2798D-09, 0.5481D-09, 0.8197D-09, 0.1444D-08,
     ,   0.2513D-08, 0.4258D-08, 0.7343D-08, 0.1259D-07, 0.2069D-07,
     ,   0.3604D-07, 0.6124D-07, 0.1042D-06, 0.1778D-06, 0.3008D-06,
     ,   0.5056D-06, 0.8509D-06, 0.1425D-05, 0.2372D-05, 0.3920D-05,
     ,   0.6431D-05, 0.1041D-04, 0.1662D-04, 0.2597D-04, 0.3951D-04,
     ,   0.5788D-04, 0.8064D-04, 0.1050D-03, 0.1250D-03, 0.1326D-03,
     ,   0.1208D-03, 0.8910D-04, 0.4556D-04, 0.1959D-05,-0.3291D-04,
     ,  -0.5653D-04,-0.7094D-04,-0.7935D-04,-0.8463D-04,-0.8819D-04,
     ,  -0.9081D-04,-0.9287D-04,-0.9451D-04,-0.9567D-04,-0.9663D-04,
     ,  -0.9724D-04,-0.9772D-04,-0.9806D-04,-0.9834D-04,-0.9854D-04,
     ,  -0.9861D-04,-0.9868D-04,-0.9874D-04,-0.9881D-04,-0.9881D-04,
     ,  -0.9881D-04,-0.9888D-04,-0.9888D-04,-0.9888D-04,-0.9888D-04,
     ,  -0.9888D-04,-0.9888D-04,-0.9888D-04,-0.9888D-04,-0.9888D-04,
     ,  -0.9888D-04,-0.9888D-04,-0.9888D-04/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.5787D-10,-0.1089D-10, 0.1183D-10,-0.2805D-11, 0.5172D-10,
     ,   0.1547D-09, 0.2855D-09, 0.6349D-09, 0.9381D-09, 0.1812D-08,
     ,   0.3195D-08, 0.5755D-08, 0.9600D-08, 0.1703D-07, 0.2861D-07,
     ,   0.4938D-07, 0.8414D-07, 0.1427D-06, 0.2434D-06, 0.4128D-06,
     ,   0.6957D-06, 0.1170D-05, 0.1963D-05, 0.3263D-05, 0.5404D-05,
     ,   0.8862D-05, 0.1437D-04, 0.2296D-04, 0.3594D-04, 0.5474D-04,
     ,   0.8039D-04, 0.1122D-03, 0.1468D-03, 0.1756D-03, 0.1874D-03,
     ,   0.1720D-03, 0.1283D-03, 0.6710D-04, 0.4872D-05,-0.4530D-04,
     ,  -0.7959D-04,-0.1004D-03,-0.1128D-03,-0.1204D-03,-0.1256D-03,
     ,  -0.1294D-03,-0.1325D-03,-0.1348D-03,-0.1365D-03,-0.1378D-03,
     ,  -0.1388D-03,-0.1395D-03,-0.1400D-03,-0.1404D-03,-0.1406D-03,
     ,  -0.1408D-03,-0.1409D-03,-0.1410D-03,-0.1410D-03,-0.1411D-03,
     ,  -0.1411D-03,-0.1411D-03,-0.1411D-03,-0.1411D-03,-0.1411D-03,
     ,  -0.1411D-03,-0.1411D-03,-0.1411D-03,-0.1411D-03,-0.1411D-03,
     ,  -0.1411D-03,-0.1411D-03,-0.1411D-03/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.2966D-10, 0.2248D-10, 0.3983D-10, 0.3331D-10, 0.1531D-09,
     ,   0.2970D-09, 0.4908D-09, 0.8753D-09, 0.1394D-08, 0.2213D-08,
     ,   0.4116D-08, 0.7580D-08, 0.1286D-07, 0.2234D-07, 0.3852D-07,
     ,   0.6585D-07, 0.1127D-06, 0.1919D-06, 0.3264D-06, 0.5531D-06,
     ,   0.9333D-06, 0.1568D-05, 0.2634D-05, 0.4386D-05, 0.7249D-05,
     ,   0.1191D-04, 0.1931D-04, 0.3089D-04, 0.4844D-04, 0.7400D-04,
     ,   0.1089D-03, 0.1528D-03, 0.2007D-03, 0.2419D-03, 0.2604D-03,
     ,   0.2418D-03, 0.1833D-03, 0.9887D-04, 0.1143D-04,-0.6018D-04,
     ,  -0.1096D-03,-0.1399D-03,-0.1578D-03,-0.1690D-03,-0.1764D-03,
     ,  -0.1820D-03,-0.1864D-03,-0.1897D-03,-0.1922D-03,-0.1941D-03,
     ,  -0.1955D-03,-0.1965D-03,-0.1972D-03,-0.1978D-03,-0.1981D-03,
     ,  -0.1983D-03,-0.1985D-03,-0.1987D-03,-0.1987D-03,-0.1988D-03,
     ,  -0.1988D-03,-0.1988D-03,-0.1989D-03,-0.1989D-03,-0.1989D-03,
     ,  -0.1989D-03,-0.1989D-03,-0.1989D-03,-0.1989D-03,-0.1989D-03,
     ,  -0.1989D-03,-0.1989D-03,-0.1989D-03/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.5171D-10, 0.5991D-10, 0.2018D-10, 0.1460D-09, 0.2529D-09,
     ,   0.4745D-09, 0.6885D-09, 0.1282D-08, 0.1621D-08, 0.3669D-08,
     ,   0.6046D-08, 0.1023D-07, 0.1756D-07, 0.2992D-07, 0.4948D-07,
     ,   0.8595D-07, 0.1466D-06, 0.2479D-06, 0.4211D-06, 0.7101D-06,
     ,   0.1201D-05, 0.2028D-05, 0.3398D-05, 0.5661D-05, 0.9377D-05,
     ,   0.1539D-04, 0.2501D-04, 0.4005D-04, 0.6293D-04, 0.9636D-04,
     ,   0.1426D-03, 0.2011D-03, 0.2661D-03, 0.3240D-03, 0.3532D-03,
     ,   0.3333D-03, 0.2585D-03, 0.1452D-03, 0.2478D-04,-0.7604D-04,
     ,  -0.1465D-03,-0.1904D-03,-0.2164D-03,-0.2324D-03,-0.2433D-03,
     ,  -0.2512D-03,-0.2575D-03,-0.2622D-03,-0.2658D-03,-0.2686D-03,
     ,  -0.2706D-03,-0.2720D-03,-0.2731D-03,-0.2738D-03,-0.2743D-03,
     ,  -0.2747D-03,-0.2749D-03,-0.2751D-03,-0.2752D-03,-0.2753D-03,
     ,  -0.2753D-03,-0.2754D-03,-0.2754D-03,-0.2754D-03,-0.2754D-03,
     ,  -0.2754D-03,-0.2754D-03,-0.2754D-03,-0.2754D-03,-0.2754D-03,
     ,  -0.2755D-03,-0.2755D-03,-0.2755D-03/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.6698D-10, 0.1121D-09, 0.3991D-10, 0.1369D-09, 0.3184D-09,
     ,   0.5179D-09, 0.9643D-09, 0.1478D-08, 0.2290D-08, 0.3618D-08,
     ,   0.7279D-08, 0.1204D-07, 0.2105D-07, 0.3633D-07, 0.6017D-07,
     ,   0.1037D-06, 0.1781D-06, 0.3025D-06, 0.5130D-06, 0.8696D-06,
     ,   0.1472D-05, 0.2475D-05, 0.4153D-05, 0.6930D-05, 0.1149D-04,
     ,   0.1889D-04, 0.3074D-04, 0.4935D-04, 0.7780D-04, 0.1196D-03,
     ,   0.1779D-03, 0.2529D-03, 0.3384D-03, 0.4174D-03, 0.4629D-03,
     ,   0.4466D-03, 0.3568D-03, 0.2114D-03, 0.5025D-04,-0.8859D-04,
     ,  -0.1881D-03,-0.2509D-03,-0.2884D-03,-0.3115D-03,-0.3268D-03,
     ,  -0.3382D-03,-0.3470D-03,-0.3537D-03,-0.3588D-03,-0.3627D-03,
     ,  -0.3656D-03,-0.3677D-03,-0.3692D-03,-0.3701D-03,-0.3709D-03,
     ,  -0.3714D-03,-0.3718D-03,-0.3720D-03,-0.3722D-03,-0.3723D-03,
     ,  -0.3723D-03,-0.3724D-03,-0.3725D-03,-0.3725D-03,-0.3725D-03,
     ,  -0.3725D-03,-0.3725D-03,-0.3725D-03,-0.3725D-03,-0.3725D-03,
     ,  -0.3725D-03,-0.3725D-03,-0.3725D-03/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.6302D-11, 0.6182D-10, 0.1385D-10, 0.1503D-09, 0.7146D-09,
     ,   0.5292D-09, 0.9385D-09, 0.1366D-08, 0.2853D-08, 0.4504D-08,
     ,   0.7989D-08, 0.1389D-07, 0.2369D-07, 0.4096D-07, 0.6850D-07,
     ,   0.1178D-06, 0.2018D-06, 0.3409D-06, 0.5867D-06, 0.9872D-06,
     ,   0.1669D-05, 0.2823D-05, 0.4737D-05, 0.7906D-05, 0.1312D-04,
     ,   0.2161D-04, 0.3525D-04, 0.5673D-04, 0.8990D-04, 0.1390D-03,
     ,   0.2083D-03, 0.2992D-03, 0.4057D-03, 0.5096D-03, 0.5783D-03,
     ,   0.5744D-03, 0.4780D-03, 0.3027D-03, 0.9603D-04,-0.8972D-04,
     ,  -0.2272D-03,-0.3160D-03,-0.3695D-03,-0.4024D-03,-0.4242D-03,
     ,  -0.4400D-03,-0.4522D-03,-0.4615D-03,-0.4687D-03,-0.4741D-03,
     ,  -0.4782D-03,-0.4811D-03,-0.4831D-03,-0.4846D-03,-0.4856D-03,
     ,  -0.4863D-03,-0.4868D-03,-0.4872D-03,-0.4874D-03,-0.4876D-03,
     ,  -0.4877D-03,-0.4878D-03,-0.4878D-03,-0.4878D-03,-0.4878D-03,
     ,  -0.4878D-03,-0.4879D-03,-0.4879D-03,-0.4879D-03,-0.4879D-03,
     ,  -0.4879D-03,-0.4879D-03,-0.4879D-03/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.8446D-10, 0.1046D-09, 0.8336D-10, 0.8528D-10, 0.4703D-09,
     ,   0.8196D-09, 0.1049D-08, 0.1737D-08, 0.3073D-08, 0.5230D-08,
     ,   0.8683D-08, 0.1447D-07, 0.2439D-07, 0.4271D-07, 0.7112D-07,
     ,   0.1225D-06, 0.2132D-06, 0.3561D-06, 0.6042D-06, 0.1032D-05,
     ,   0.1739D-05, 0.2936D-05, 0.4930D-05, 0.8240D-05, 0.1370D-04,
     ,   0.2262D-04, 0.3699D-04, 0.5982D-04, 0.9521D-04, 0.1483D-03,
     ,   0.2244D-03, 0.3266D-03, 0.4507D-03, 0.5794D-03, 0.6774D-03,
     ,   0.6994D-03, 0.6118D-03, 0.4191D-03, 0.1712D-03,-0.6656D-04,
     ,  -0.2508D-03,-0.3738D-03,-0.4493D-03,-0.4954D-03,-0.5258D-03,
     ,  -0.5475D-03,-0.5641D-03,-0.5769D-03,-0.5867D-03,-0.5941D-03,
     ,  -0.5997D-03,-0.6036D-03,-0.6065D-03,-0.6085D-03,-0.6099D-03,
     ,  -0.6109D-03,-0.6116D-03,-0.6121D-03,-0.6124D-03,-0.6126D-03,
     ,  -0.6127D-03,-0.6129D-03,-0.6130D-03,-0.6130D-03,-0.6130D-03,
     ,  -0.6130D-03,-0.6130D-03,-0.6131D-03,-0.6131D-03,-0.6131D-03,
     ,  -0.6131D-03,-0.6131D-03,-0.6131D-03/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.6880D-11, 0.5188D-10,-0.2906D-09, 0.2013D-09, 0.4340D-09,
     ,   0.4112D-09, 0.7331D-09, 0.1657D-08, 0.2103D-08, 0.3870D-08,
     ,   0.7221D-08, 0.1299D-07, 0.2200D-07, 0.3837D-07, 0.6293D-07,
     ,   0.1125D-06, 0.1936D-06, 0.3265D-06, 0.5593D-06, 0.9564D-06,
     ,   0.1610D-05, 0.2725D-05, 0.4586D-05, 0.7687D-05, 0.1280D-04,
     ,   0.2120D-04, 0.3479D-04, 0.5655D-04, 0.9055D-04, 0.1423D-03,
     ,   0.2179D-03, 0.3222D-03, 0.4544D-03, 0.6011D-03, 0.7291D-03,
     ,   0.7901D-03, 0.7341D-03, 0.5508D-03, 0.2792D-03,-0.5141D-05,
     ,  -0.2413D-03,-0.4063D-03,-0.5104D-03,-0.5743D-03,-0.6156D-03,
     ,  -0.6448D-03,-0.6667D-03,-0.6837D-03,-0.6968D-03,-0.7068D-03,
     ,  -0.7143D-03,-0.7196D-03,-0.7234D-03,-0.7257D-03,-0.7279D-03,
     ,  -0.7293D-03,-0.7301D-03,-0.7308D-03,-0.7315D-03,-0.7316D-03,
     ,  -0.7316D-03,-0.7316D-03,-0.7323D-03,-0.7323D-03,-0.7323D-03,
     ,  -0.7323D-03,-0.7323D-03,-0.7323D-03,-0.7323D-03,-0.7323D-03,
     ,  -0.7323D-03,-0.7323D-03,-0.7323D-03/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.1769D-10, 0.9581D-10, 0.2079D-09, 0.8378D-10, 0.3492D-09,
     ,   0.2973D-09, 0.7156D-09, 0.1347D-08, 0.1695D-08, 0.3463D-08,
     ,   0.6140D-08, 0.1043D-07, 0.1823D-07, 0.3194D-07, 0.5039D-07,
     ,   0.9138D-07, 0.1588D-06, 0.2679D-06, 0.4558D-06, 0.7768D-06,
     ,   0.1317D-05, 0.2227D-05, 0.3755D-05, 0.6304D-05, 0.1053D-04,
     ,   0.1751D-04, 0.2882D-04, 0.4712D-04, 0.7600D-04, 0.1206D-03,
     ,   0.1872D-03, 0.2821D-03, 0.4079D-03, 0.5578D-03, 0.7072D-03,
     ,   0.8092D-03, 0.8092D-03, 0.6711D-03, 0.4115D-03, 0.1021D-03,
     ,  -0.1804D-03,-0.3920D-03,-0.5310D-03,-0.6176D-03,-0.6729D-03,
     ,  -0.7110D-03,-0.7389D-03,-0.7607D-03,-0.7775D-03,-0.7902D-03,
     ,  -0.7996D-03,-0.8066D-03,-0.8119D-03,-0.8151D-03,-0.8174D-03,
     ,  -0.8196D-03,-0.8205D-03,-0.8212D-03,-0.8220D-03,-0.8227D-03,
     ,  -0.8227D-03,-0.8227D-03,-0.8234D-03,-0.8234D-03,-0.8234D-03,
     ,  -0.8234D-03,-0.8234D-03,-0.8234D-03,-0.8235D-03,-0.8235D-03,
     ,  -0.8235D-03,-0.8235D-03,-0.8235D-03/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.1066D-10, 0.2727D-09, 0.1770D-09,-0.8211D-10, 0.6290D-10,
     ,   0.2127D-09, 0.6761D-09, 0.8212D-09, 0.1131D-08, 0.2391D-08,
     ,   0.4344D-08, 0.7557D-08, 0.1288D-07, 0.2268D-07, 0.3691D-07,
     ,   0.6598D-07, 0.1109D-06, 0.1893D-06, 0.3263D-06, 0.5544D-06,
     ,   0.9338D-06, 0.1584D-05, 0.2674D-05, 0.4500D-05, 0.7537D-05,
     ,   0.1254D-04, 0.2081D-04, 0.3418D-04, 0.5560D-04, 0.8919D-04,
     ,   0.1405D-03, 0.2160D-03, 0.3209D-03, 0.4547D-03, 0.6052D-03,
     ,   0.7377D-03, 0.7988D-03, 0.7366D-03, 0.5362D-03, 0.2428D-03,
     ,  -0.6370D-04,-0.3163D-03,-0.4938D-03,-0.6072D-03,-0.6790D-03,
     ,  -0.7273D-03,-0.7622D-03,-0.7886D-03,-0.8094D-03,-0.8251D-03,
     ,  -0.8365D-03,-0.8453D-03,-0.8517D-03,-0.8564D-03,-0.8596D-03,
     ,  -0.8619D-03,-0.8635D-03,-0.8643D-03,-0.8651D-03,-0.8658D-03,
     ,  -0.8659D-03,-0.8666D-03,-0.8666D-03,-0.8666D-03,-0.8666D-03,
     ,  -0.8667D-03,-0.8667D-03,-0.8667D-03,-0.8667D-03,-0.8667D-03,
     ,  -0.8667D-03,-0.8667D-03,-0.8667D-03/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.3842D-11,-0.9699D-10, 0.6007D-10,-0.2799D-11, 0.2270D-09,
     ,   0.1263D-09, 0.4008D-09, 0.6449D-09, 0.6112D-09, 0.1435D-08,
     ,   0.2686D-08, 0.4603D-08, 0.8021D-08, 0.1198D-07, 0.2364D-07,
     ,   0.4113D-07, 0.6868D-07, 0.1159D-06, 0.1976D-06, 0.3404D-06,
     ,   0.5766D-06, 0.9745D-06, 0.1653D-05, 0.2787D-05, 0.4683D-05,
     ,   0.7849D-05, 0.1302D-04, 0.2155D-04, 0.3534D-04, 0.5729D-04,
     ,   0.9167D-04, 0.1438D-03, 0.2196D-03, 0.3234D-03, 0.4517D-03,
     ,   0.5873D-03, 0.6922D-03, 0.7124D-03, 0.6058D-03, 0.3790D-03,
     ,   0.9071D-04,-0.1824D-03,-0.3934D-03,-0.5358D-03,-0.6267D-03,
     ,  -0.6863D-03,-0.7277D-03,-0.7595D-03,-0.7832D-03,-0.8020D-03,
     ,  -0.8157D-03,-0.8264D-03,-0.8339D-03,-0.8396D-03,-0.8436D-03,
     ,  -0.8461D-03,-0.8484D-03,-0.8493D-03,-0.8501D-03,-0.8509D-03,
     ,  -0.8517D-03,-0.8517D-03,-0.8517D-03,-0.8524D-03,-0.8525D-03,
     ,  -0.8525D-03,-0.8525D-03,-0.8525D-03,-0.8525D-03,-0.8525D-03,
     ,  -0.8525D-03,-0.8525D-03,-0.8525D-03/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.1043D-10, 0.2965D-10, 0.3454D-10,-0.9800D-10, 0.1034D-09,
     ,   0.1341D-09, 0.2815D-09, 0.3300D-09, 0.2652D-09, 0.6548D-09,
     ,   0.1544D-08, 0.2465D-08, 0.4131D-08, 0.7472D-08, 0.1145D-07,
     ,   0.2154D-07, 0.3585D-07, 0.6339D-07, 0.1082D-06, 0.1833D-06,
     ,   0.3106D-06, 0.5268D-06, 0.8929D-06, 0.1510D-05, 0.2546D-05,
     ,   0.4266D-05, 0.7138D-05, 0.1190D-04, 0.1963D-04, 0.3220D-04,
     ,   0.5224D-04, 0.8353D-04, 0.1310D-03, 0.1998D-03, 0.2931D-03,
     ,   0.4063D-03, 0.5200D-03, 0.5956D-03, 0.5847D-03, 0.4590D-03,
     ,   0.2376D-03,-0.1760D-04,-0.2443D-03,-0.4118D-03,-0.5229D-03,
     ,  -0.5947D-03,-0.6436D-03,-0.6787D-03,-0.7053D-03,-0.7260D-03,
     ,  -0.7426D-03,-0.7540D-03,-0.7633D-03,-0.7700D-03,-0.7742D-03,
     ,  -0.7775D-03,-0.7800D-03,-0.7816D-03,-0.7825D-03,-0.7833D-03,
     ,  -0.7834D-03,-0.7841D-03,-0.7842D-03,-0.7842D-03,-0.7849D-03,
     ,  -0.7849D-03,-0.7849D-03,-0.7849D-03,-0.7849D-03,-0.7849D-03,
     ,  -0.7849D-03,-0.7849D-03,-0.7849D-03/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.6681D-13, 0.1386D-10,-0.2448D-10,-0.1785D-10, 0.7854D-10,
     ,   0.8720D-10,-0.5338D-10, 0.1643D-09, 0.1899D-09, 0.2390D-09,
     ,   0.7028D-09, 0.1095D-08, 0.2000D-08, 0.3512D-08, 0.5577D-08,
     ,   0.1069D-07, 0.1827D-07, 0.3011D-07, 0.4969D-07, 0.8739D-07,
     ,   0.1471D-06, 0.2519D-06, 0.4291D-06, 0.7281D-06, 0.1229D-05,
     ,   0.2075D-05, 0.3475D-05, 0.5821D-05, 0.9686D-05, 0.1605D-04,
     ,   0.2636D-04, 0.4290D-04, 0.6886D-04, 0.1085D-03, 0.1662D-03,
     ,   0.2442D-03, 0.3379D-03, 0.4278D-03, 0.4789D-03, 0.4510D-03,
     ,   0.3275D-03, 0.1322D-03,-0.7853D-04,-0.2571D-03,-0.3853D-03,
     ,  -0.4700D-03,-0.5258D-03,-0.5647D-03,-0.5936D-03,-0.6159D-03,
     ,  -0.6331D-03,-0.6461D-03,-0.6559D-03,-0.6631D-03,-0.6683D-03,
     ,  -0.6720D-03,-0.6744D-03,-0.6761D-03,-0.6777D-03,-0.6786D-03,
     ,  -0.6793D-03,-0.6794D-03,-0.6802D-03,-0.6802D-03,-0.6802D-03,
     ,  -0.6802D-03,-0.6802D-03,-0.6803D-03,-0.6803D-03,-0.6803D-03,
     ,  -0.6803D-03,-0.6803D-03,-0.6803D-03/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1188D-10, 0.2893D-10, 0.1045D-10, 0.1544D-10, 0.7036D-10,
     ,   0.1005D-09, 0.9155D-10, 0.1625D-09, 0.5602D-10, 0.1710D-09,
     ,   0.3569D-09, 0.5938D-09, 0.1016D-08, 0.1749D-08, 0.2563D-08,
     ,   0.4553D-08, 0.8613D-08, 0.1371D-07, 0.2215D-07, 0.3806D-07,
     ,   0.6427D-07, 0.1099D-06, 0.1886D-06, 0.3185D-06, 0.5397D-06,
     ,   0.9136D-06, 0.1538D-05, 0.2579D-05, 0.4333D-05, 0.7223D-05,
     ,   0.1200D-04, 0.1984D-04, 0.3248D-04, 0.5259D-04, 0.8363D-04,
     ,   0.1293D-03, 0.1914D-03, 0.2652D-03, 0.3336D-03, 0.3665D-03,
     ,   0.3331D-03, 0.2232D-03, 0.6329D-04,-0.1017D-03,-0.2370D-03,
     ,  -0.3326D-03,-0.3959D-03,-0.4384D-03,-0.4687D-03,-0.4916D-03,
     ,  -0.5092D-03,-0.5228D-03,-0.5331D-03,-0.5409D-03,-0.5464D-03,
     ,  -0.5505D-03,-0.5534D-03,-0.5554D-03,-0.5568D-03,-0.5577D-03,
     ,  -0.5584D-03,-0.5589D-03,-0.5592D-03,-0.5594D-03,-0.5596D-03,
     ,  -0.5597D-03,-0.5598D-03,-0.5598D-03,-0.5598D-03,-0.5599D-03,
     ,  -0.5599D-03,-0.5599D-03,-0.5599D-03/
      data (calcpts(j,28), j = 1,neta) /
     ,   0.4498D-11, 0.1230D-10,-0.1199D-11, 0.7105D-11, 0.1532D-10,
     ,   0.1806D-10,-0.3302D-10, 0.4741D-10, 0.6107D-10, 0.1210D-09,
     ,   0.1426D-09, 0.2342D-09, 0.3913D-09, 0.6321D-09, 0.9998D-09,
     ,   0.1774D-08, 0.3092D-08, 0.5678D-08, 0.8487D-08, 0.1519D-07,
     ,   0.2588D-07, 0.4431D-07, 0.7544D-07, 0.1287D-06, 0.2190D-06,
     ,   0.3716D-06, 0.6269D-06, 0.1060D-05, 0.1780D-05, 0.3002D-05,
     ,   0.5032D-05, 0.8410D-05, 0.1402D-04, 0.2320D-04, 0.3806D-04,
     ,   0.6136D-04, 0.9609D-04, 0.1436D-03, 0.1995D-03, 0.2503D-03,
     ,   0.2707D-03, 0.2379D-03, 0.1478D-03, 0.2326D-04,-0.1010D-03,
     ,  -0.2007D-03,-0.2705D-03,-0.3169D-03,-0.3487D-03,-0.3717D-03,
     ,  -0.3892D-03,-0.4028D-03,-0.4132D-03,-0.4211D-03,-0.4270D-03,
     ,  -0.4312D-03,-0.4343D-03,-0.4364D-03,-0.4380D-03,-0.4390D-03,
     ,  -0.4397D-03,-0.4402D-03,-0.4406D-03,-0.4408D-03,-0.4409D-03,
     ,  -0.4411D-03,-0.4412D-03,-0.4412D-03,-0.4413D-03,-0.4413D-03,
     ,  -0.4413D-03,-0.4413D-03,-0.4413D-03/
      data (calcpts(j,29), j = 1,neta) /
     ,   0.2169D-11,-0.7247D-12,-0.6437D-11,-0.1910D-11,-0.3298D-11,
     ,  -0.2911D-11,-0.3913D-10,-0.1994D-10, 0.7892D-11,-0.2861D-10,
     ,   0.3170D-10, 0.6666D-10, 0.1110D-09, 0.2253D-09, 0.3551D-09,
     ,   0.5805D-09, 0.1112D-08, 0.1948D-08, 0.3327D-08, 0.5754D-08,
     ,   0.1002D-07, 0.1681D-07, 0.2872D-07, 0.4933D-07, 0.8311D-07,
     ,   0.1419D-06, 0.2401D-06, 0.4079D-06, 0.6919D-06, 0.1169D-05,
     ,   0.1976D-05, 0.3341D-05, 0.5639D-05, 0.9498D-05, 0.1598D-04,
     ,   0.2662D-04, 0.4366D-04, 0.6937D-04, 0.1047D-03, 0.1462D-03,
     ,   0.1825D-03, 0.1948D-03, 0.1664D-03, 0.9625D-04, 0.2762D-05,
     ,  -0.8822D-04,-0.1602D-03,-0.2103D-03,-0.2440D-03,-0.2672D-03,
     ,  -0.2842D-03,-0.2973D-03,-0.3075D-03,-0.3153D-03,-0.3211D-03,
     ,  -0.3254D-03,-0.3286D-03,-0.3308D-03,-0.3324D-03,-0.3335D-03,
     ,  -0.3343D-03,-0.3348D-03,-0.3352D-03,-0.3354D-03,-0.3356D-03,
     ,  -0.3358D-03,-0.3358D-03,-0.3359D-03,-0.3359D-03,-0.3359D-03,
     ,  -0.3359D-03,-0.3359D-03,-0.3359D-03/
      data (calcpts(j,30), j = 1,neta) /
     ,  -0.1212D-11, 0.1300D-11,-0.1226D-11, 0.1081D-11, 0.1707D-11,
     ,   0.2588D-13,-0.1578D-12, 0.6469D-11,-0.4783D-12,-0.6541D-11,
     ,   0.4495D-10,-0.1380D-11, 0.2137D-10, 0.7023D-10, 0.1415D-09,
     ,   0.2332D-09, 0.4118D-09, 0.7036D-09, 0.1201D-08, 0.2104D-08,
     ,   0.3414D-08, 0.6029D-08, 0.1025D-07, 0.1798D-07, 0.3028D-07,
     ,   0.5238D-07, 0.8811D-07, 0.1504D-06, 0.2563D-06, 0.4351D-06,
     ,   0.7398D-06, 0.1264D-05, 0.2152D-05, 0.3680D-05, 0.6298D-05,
     ,   0.1079D-04, 0.1831D-04, 0.3055D-04, 0.4921D-04, 0.7500D-04,
     ,   0.1050D-03, 0.1305D-03, 0.1377D-03, 0.1149D-03, 0.6220D-04,
     ,  -0.6106D-05,-0.7137D-04,-0.1225D-03,-0.1581D-03,-0.1821D-03,
     ,  -0.1988D-03,-0.2112D-03,-0.2208D-03,-0.2282D-03,-0.2339D-03,
     ,  -0.2381D-03,-0.2413D-03,-0.2436D-03,-0.2451D-03,-0.2463D-03,
     ,  -0.2471D-03,-0.2476D-03,-0.2481D-03,-0.2483D-03,-0.2485D-03,
     ,  -0.2486D-03,-0.2487D-03,-0.2488D-03,-0.2488D-03,-0.2488D-03,
     ,  -0.2488D-03,-0.2489D-03,-0.2489D-03/
      data (calcpts(j,31), j = 1,neta) /
     ,   0.1468D-11, 0.2012D-11,-0.2276D-12,-0.8119D-12, 0.2496D-11,
     ,  -0.1002D-11, 0.4764D-12, 0.1814D-11,-0.8313D-12, 0.7051D-11,
     ,   0.1173D-10, 0.2440D-10, 0.2717D-10, 0.4155D-10, 0.3440D-10,
     ,   0.9356D-10, 0.1320D-09, 0.2503D-09, 0.4318D-09, 0.7394D-09,
     ,   0.1234D-08, 0.1965D-08, 0.3822D-08, 0.6450D-08, 0.1091D-07,
     ,   0.1855D-07, 0.3144D-07, 0.5367D-07, 0.9171D-07, 0.1564D-06,
     ,   0.2674D-06, 0.4585D-06, 0.7882D-06, 0.1362D-05, 0.2372D-05,
     ,   0.4141D-05, 0.7222D-05, 0.1250D-04, 0.2120D-04, 0.3457D-04,
     ,   0.5305D-04, 0.7438D-04, 0.9209D-04, 0.9623D-04, 0.7863D-04,
     ,   0.4009D-04,-0.8768D-05,-0.5496D-04,-0.9086D-04,-0.1158D-03,
     ,  -0.1328D-03,-0.1447D-03,-0.1536D-03,-0.1604D-03,-0.1657D-03,
     ,  -0.1698D-03,-0.1729D-03,-0.1751D-03,-0.1767D-03,-0.1779D-03,
     ,  -0.1787D-03,-0.1792D-03,-0.1797D-03,-0.1799D-03,-0.1801D-03,
     ,  -0.1802D-03,-0.1803D-03,-0.1804D-03,-0.1804D-03,-0.1805D-03,
     ,  -0.1805D-03,-0.1805D-03,-0.1805D-03/
      data (calcpts(j,32), j = 1,neta) /
     ,   0.6664D-12, 0.6410D-12,-0.1809D-11,-0.1403D-11, 0.2961D-12,
     ,  -0.1185D-11,-0.1544D-11,-0.5746D-12,-0.2048D-11,-0.3376D-11,
     ,   0.6274D-12, 0.1052D-10, 0.1137D-10, 0.1451D-10,-0.4168D-11,
     ,   0.9889D-11, 0.4402D-10, 0.8541D-10, 0.1319D-09, 0.2538D-09,
     ,   0.3842D-09, 0.6983D-09, 0.1264D-08, 0.2096D-08, 0.3565D-08,
     ,   0.6413D-08, 0.1095D-07, 0.1864D-07, 0.3202D-07, 0.5476D-07,
     ,   0.9412D-07, 0.1621D-06, 0.2805D-06, 0.4897D-06, 0.8617D-06,
     ,   0.1526D-05, 0.2723D-05, 0.4845D-05, 0.8533D-05, 0.1467D-04,
     ,   0.2414D-04, 0.3720D-04, 0.5215D-04, 0.6435D-04, 0.6666D-04,
     ,   0.5361D-04, 0.2597D-04,-0.8561D-05,-0.4089D-04,-0.6593D-04,
     ,  -0.8330D-04,-0.9513D-04,-0.1036D-03,-0.1098D-03,-0.1147D-03,
     ,  -0.1184D-03,-0.1213D-03,-0.1235D-03,-0.1251D-03,-0.1262D-03,
     ,  -0.1270D-03,-0.1276D-03,-0.1280D-03,-0.1283D-03,-0.1285D-03,
     ,  -0.1286D-03,-0.1287D-03,-0.1287D-03,-0.1288D-03,-0.1288D-03,
     ,  -0.1288D-03,-0.1288D-03,-0.1288D-03/
      data (calcpts(j,33), j = 1,neta) /
     ,   0.2296D-12, 0.7591D-12, 0.1050D-11, 0.2014D-12, 0.1384D-11,
     ,   0.5726D-13, 0.1593D-11, 0.1773D-11, 0.3241D-12, 0.1257D-11,
     ,   0.3654D-11, 0.3161D-11, 0.4101D-11, 0.1071D-10, 0.1590D-10,
     ,   0.1134D-10, 0.2994D-10, 0.2833D-10, 0.6376D-10, 0.1000D-09,
     ,   0.1447D-09, 0.2740D-09, 0.4530D-09, 0.7631D-09, 0.1297D-08,
     ,   0.2188D-08, 0.3706D-08, 0.6531D-08, 0.1115D-07, 0.1895D-07,
     ,   0.3270D-07, 0.5636D-07, 0.9808D-07, 0.1722D-06, 0.3057D-06,
     ,   0.5479D-06, 0.9912D-06, 0.1803D-05, 0.3265D-05, 0.5837D-05,
     ,   0.1013D-04, 0.1678D-04, 0.2591D-04, 0.3632D-04, 0.4462D-04,
     ,   0.4591D-04, 0.3642D-04, 0.1693D-04,-0.7213D-05,-0.2967D-04,
     ,  -0.4699D-04,-0.5906D-04,-0.6725D-04,-0.7311D-04,-0.7755D-04,
     ,  -0.8091D-04,-0.8355D-04,-0.8560D-04,-0.8706D-04,-0.8818D-04,
     ,  -0.8901D-04,-0.8956D-04,-0.8994D-04,-0.9021D-04,-0.9046D-04,
     ,  -0.9056D-04,-0.9065D-04,-0.9074D-04,-0.9075D-04,-0.9082D-04,
     ,  -0.9083D-04,-0.9083D-04,-0.9083D-04/
      data (calcpts(j,34), j = 1,neta) /
     ,   0.1389D-13, 0.1622D-12, 0.8570D-15, 0.5019D-12, 0.7963D-12,
     ,  -0.1022D-13,-0.7950D-13, 0.8694D-12,-0.3016D-12, 0.5192D-12,
     ,   0.1163D-11, 0.9852D-12, 0.8503D-12, 0.2859D-11, 0.2158D-11,
     ,   0.8755D-11, 0.1787D-11, 0.1115D-10, 0.1871D-10, 0.2983D-10,
     ,   0.4281D-10, 0.8106D-10, 0.1486D-09, 0.2486D-09, 0.4283D-09,
     ,   0.7495D-09, 0.1264D-08, 0.2112D-08, 0.3701D-08, 0.6450D-08,
     ,   0.1104D-07, 0.1932D-07, 0.3360D-07, 0.5939D-07, 0.1062D-06,
     ,   0.1922D-06, 0.3520D-06, 0.6501D-06, 0.1204D-05, 0.2216D-05,
     ,   0.4004D-05, 0.7003D-05, 0.1162D-04, 0.1798D-04, 0.2515D-04,
     ,   0.3080D-04, 0.3149D-04, 0.2473D-04, 0.1108D-04,-0.5662D-05,
     ,  -0.2117D-04,-0.3311D-04,-0.4142D-04,-0.4711D-04,-0.5118D-04,
     ,  -0.5423D-04,-0.5660D-04,-0.5844D-04,-0.5984D-04,-0.6089D-04,
     ,  -0.6165D-04,-0.6221D-04,-0.6260D-04,-0.6288D-04,-0.6307D-04,
     ,  -0.6321D-04,-0.6330D-04,-0.6336D-04,-0.6341D-04,-0.6344D-04,
     ,  -0.6346D-04,-0.6347D-04,-0.6349D-04/
      data (calcpts(j,35), j = 1,neta) /
     ,  -0.7295D-13,-0.1420D-13,-0.1002D-12,-0.8650D-13,-0.4992D-13,
     ,   0.3180D-12, 0.1327D-12, 0.1125D-12,-0.3879D-12,-0.5175D-12,
     ,  -0.7520D-13,-0.1202D-13,-0.4407D-12, 0.3626D-12,-0.1206D-12,
     ,  -0.1924D-12, 0.1320D-11,-0.7945D-12, 0.8357D-12, 0.6707D-11,
     ,   0.1227D-10, 0.2938D-10, 0.4848D-10, 0.7870D-10, 0.1362D-09,
     ,   0.2424D-09, 0.4149D-09, 0.7166D-09, 0.1244D-08, 0.2157D-08,
     ,   0.3715D-08, 0.6499D-08, 0.1139D-07, 0.2022D-07, 0.3634D-07,
     ,   0.6628D-07, 0.1225D-06, 0.2293D-06, 0.4314D-06, 0.8114D-06,
     ,   0.1511D-05, 0.2750D-05, 0.4827D-05, 0.8030D-05, 0.1241D-04,
     ,   0.1734D-04, 0.2120D-04, 0.2155D-04, 0.1679D-04, 0.7302D-05,
     ,  -0.4253D-05,-0.1492D-04,-0.2312D-04,-0.2884D-04,-0.3275D-04,
     ,  -0.3556D-04,-0.3767D-04,-0.3931D-04,-0.4059D-04,-0.4156D-04,
     ,  -0.4228D-04,-0.4281D-04,-0.4319D-04,-0.4347D-04,-0.4366D-04,
     ,  -0.4379D-04,-0.4389D-04,-0.4395D-04,-0.4400D-04,-0.4402D-04,
     ,  -0.4404D-04,-0.4406D-04,-0.4407D-04/
      data (calcpts(j,36), j = 1,neta) /
     ,  -0.9947D-15, 0.2013D-13,-0.4480D-13,-0.4440D-13,-0.5604D-14,
     ,   0.2766D-13, 0.2161D-13,-0.1577D-12, 0.1274D-12, 0.1134D-12,
     ,  -0.1353D-12,-0.1406D-12, 0.1108D-12, 0.4131D-12,-0.7667D-13,
     ,   0.2073D-12, 0.4946D-12, 0.1096D-11, 0.1951D-11, 0.4572D-11,
     ,   0.6127D-11, 0.8150D-11, 0.1388D-10, 0.2671D-10, 0.4873D-10,
     ,   0.7967D-10, 0.1349D-09, 0.2417D-09, 0.4157D-09, 0.7167D-09,
     ,   0.1246D-08, 0.2158D-08, 0.3831D-08, 0.6863D-08, 0.1235D-07,
     ,   0.2266D-07, 0.4214D-07, 0.7958D-07, 0.1516D-06, 0.2898D-06,
     ,   0.5513D-06, 0.1034D-05, 0.1890D-05, 0.3326D-05, 0.5538D-05,
     ,   0.8549D-05, 0.1192D-04, 0.1452D-04, 0.1474D-04, 0.1140D-04,
     ,   0.4851D-05,-0.3096D-05,-0.1042D-04,-0.1604D-04,-0.1995D-04,
     ,  -0.2265D-04,-0.2458D-04,-0.2603D-04,-0.2717D-04,-0.2804D-04,
     ,  -0.2871D-04,-0.2920D-04,-0.2957D-04,-0.2983D-04,-0.3002D-04,
     ,  -0.3015D-04,-0.3025D-04,-0.3031D-04,-0.3035D-04,-0.3038D-04,
     ,  -0.3041D-04,-0.3042D-04,-0.3043D-04/
      data (calcpts(j,37), j = 1,neta) /
     ,   0.7462D-14,-0.8657D-14,-0.5457D-14,-0.5964D-14, 0.1541D-14,
     ,  -0.1218D-13, 0.1341D-14, 0.3572D-13,-0.3309D-13, 0.8276D-13,
     ,   0.1028D-12, 0.1167D-12, 0.1264D-12, 0.4524D-14, 0.1058D-12,
     ,   0.2227D-12, 0.1084D-12, 0.3486D-12, 0.7440D-12, 0.1044D-11,
     ,   0.1195D-11, 0.1111D-11, 0.3608D-11, 0.1085D-10, 0.1428D-10,
     ,   0.2707D-10, 0.4339D-10, 0.8038D-10, 0.1399D-09, 0.2395D-09,
     ,   0.4162D-09, 0.7316D-09, 0.1281D-08, 0.2312D-08, 0.4175D-08,
     ,   0.7663D-08, 0.1437D-07, 0.2722D-07, 0.5240D-07, 0.1015D-06,
     ,   0.1963D-06, 0.3764D-06, 0.7093D-06, 0.1300D-05, 0.2288D-05,
     ,   0.3808D-05, 0.5872D-05, 0.8177D-05, 0.9939D-05, 0.1006D-04,
     ,   0.7747D-05, 0.3237D-05,-0.2212D-05,-0.7225D-05,-0.1107D-04,
     ,  -0.1375D-04,-0.1559D-04,-0.1692D-04,-0.1792D-04,-0.1869D-04,
     ,  -0.1930D-04,-0.1975D-04,-0.2010D-04,-0.2035D-04,-0.2053D-04,
     ,  -0.2066D-04,-0.2075D-04,-0.2081D-04,-0.2086D-04,-0.2088D-04,
     ,  -0.2091D-04,-0.2092D-04,-0.2093D-04/
      data (calcpts(j,38), j = 1,neta) /
     ,  -0.9830D-15,-0.5521D-14,-0.2363D-13,-0.1208D-13,-0.5862D-14,
     ,  -0.2459D-13,-0.9922D-14,-0.1503D-13,-0.4127D-13,-0.4621D-13,
     ,  -0.1424D-13,-0.6379D-13, 0.1283D-13,-0.1522D-13,-0.1657D-12,
     ,   0.3845D-14,-0.1141D-12,-0.1333D-12, 0.3490D-13, 0.2320D-12,
     ,   0.6590D-13, 0.5426D-12, 0.1529D-11, 0.2780D-11, 0.4167D-11,
     ,   0.8499D-11, 0.1513D-10, 0.2625D-10, 0.4542D-10, 0.7759D-10,
     ,   0.1374D-09, 0.2412D-09, 0.4246D-09, 0.7607D-09, 0.1388D-08,
     ,   0.2566D-08, 0.4816D-08, 0.9279D-08, 0.1792D-07, 0.3504D-07,
     ,   0.6864D-07, 0.1337D-06, 0.2576D-06, 0.4869D-06, 0.8932D-06,
     ,   0.1571D-05, 0.2613D-05, 0.4025D-05, 0.5598D-05, 0.6795D-05,
     ,   0.6861D-05, 0.5262D-05, 0.2172D-05,-0.1562D-05,-0.4989D-05,
     ,  -0.7617D-05,-0.9445D-05,-0.1071D-04,-0.1161D-04,-0.1230D-04,
     ,  -0.1283D-04,-0.1325D-04,-0.1356D-04,-0.1380D-04,-0.1397D-04,
     ,  -0.1409D-04,-0.1418D-04,-0.1424D-04,-0.1428D-04,-0.1433D-04,
     ,  -0.1434D-04,-0.1435D-04,-0.1436D-04/
      data (calcpts(j,39), j = 1,neta) /
     ,   0.4327D-14, 0.1039D-13, 0.9230D-14, 0.1402D-13, 0.3285D-14,
     ,   0.5186D-14, 0.1304D-13, 0.1155D-13, 0.6357D-15, 0.1635D-13,
     ,   0.3567D-13, 0.2723D-13, 0.3458D-13, 0.1218D-12, 0.1239D-12,
     ,   0.8233D-14, 0.1316D-12, 0.2266D-12, 0.2517D-12, 0.2864D-12,
     ,   0.2209D-12, 0.5566D-12, 0.9332D-12, 0.1282D-11, 0.2052D-11,
     ,   0.2773D-11, 0.6045D-11, 0.8198D-11, 0.1622D-10, 0.2607D-10,
     ,   0.4654D-10, 0.8174D-10, 0.1433D-09, 0.2558D-09, 0.4666D-09,
     ,   0.8639D-09, 0.1630D-08, 0.3129D-08, 0.6095D-08, 0.1201D-07,
     ,   0.2367D-07, 0.4672D-07, 0.9159D-07, 0.1769D-06, 0.3340D-06,
     ,   0.6127D-06, 0.1078D-05, 0.1790D-05, 0.2755D-05, 0.3829D-05,
     ,   0.4640D-05, 0.4678D-05, 0.3579D-05, 0.1466D-05,-0.1088D-05,
     ,  -0.3427D-05,-0.5221D-05,-0.6475D-05,-0.7334D-05,-0.7955D-05,
     ,  -0.8427D-05,-0.8788D-05,-0.9073D-05,-0.9283D-05,-0.9447D-05,
     ,  -0.9562D-05,-0.9646D-05,-0.9710D-05,-0.9748D-05,-0.9783D-05,
     ,  -0.9802D-05,-0.9812D-05,-0.9821D-05/
      data (calcpts(j,40), j = 1,neta) /
     ,   0.7056D-15, 0.2106D-14, 0.4526D-15, 0.9870D-15, 0.8819D-15,
     ,   0.2278D-14, 0.2800D-14, 0.8197D-14, 0.3381D-15, 0.6267D-14,
     ,   0.1202D-13, 0.2467D-14, 0.1160D-13, 0.1632D-13, 0.5992D-14,
     ,   0.3515D-13, 0.5362D-13,-0.2594D-13, 0.4051D-13, 0.7486D-13,
     ,   0.6002D-13, 0.7469D-13, 0.2211D-12, 0.4199D-12, 0.5944D-12,
     ,   0.1136D-11, 0.1605D-11, 0.3566D-11, 0.4963D-11, 0.8349D-11,
     ,   0.1531D-10, 0.2651D-10, 0.4736D-10, 0.8475D-10, 0.1551D-09,
     ,   0.2872D-09, 0.5449D-09, 0.1049D-08, 0.2050D-08, 0.4058D-08,
     ,   0.8084D-08, 0.1610D-07, 0.3193D-07, 0.6270D-07, 0.1211D-06,
     ,   0.2291D-06, 0.4199D-06, 0.7383D-06, 0.1225D-05, 0.1884D-05,
     ,   0.2615D-05, 0.3167D-05, 0.3187D-05, 0.2435D-05, 0.9872D-06,
     ,  -0.7544D-06,-0.2351D-05,-0.3575D-05,-0.4429D-05,-0.5018D-05,
     ,  -0.5442D-05,-0.5763D-05,-0.6012D-05,-0.6204D-05,-0.6351D-05,
     ,  -0.6461D-05,-0.6541D-05,-0.6599D-05,-0.6640D-05,-0.6669D-05,
     ,  -0.6689D-05,-0.6703D-05,-0.6713D-05/
      data (calcpts(j,41), j = 1,neta) /
     ,  -0.5009D-15,-0.2597D-16,-0.1437D-14,-0.1222D-14,-0.3065D-15,
     ,  -0.1374D-14, 0.1320D-14, 0.3786D-14,-0.4578D-14,-0.2713D-14,
     ,  -0.3339D-14,-0.5898D-14,-0.2943D-14, 0.3406D-14,-0.7872D-14,
     ,  -0.9413D-14,-0.6515D-16, 0.2254D-13,-0.9748D-14,-0.2265D-13,
     ,  -0.1818D-13,-0.1793D-13, 0.7815D-13, 0.1058D-12, 0.1280D-12,
     ,   0.3246D-12, 0.4602D-12, 0.8118D-12, 0.1595D-11, 0.2406D-11,
     ,   0.5144D-11, 0.8981D-11, 0.1556D-10, 0.2809D-10, 0.5110D-10,
     ,   0.9448D-10, 0.1803D-09, 0.3498D-09, 0.6859D-09, 0.1363D-08,
     ,   0.2735D-08, 0.5488D-08, 0.1099D-07, 0.2186D-07, 0.4297D-07,
     ,   0.8306D-07, 0.1570D-06, 0.2876D-06, 0.5048D-06, 0.8373D-06,
     ,   0.1287D-05, 0.1785D-05, 0.2158D-05, 0.2173D-05, 0.1657D-05,
     ,   0.6679D-06,-0.5214D-06,-0.1611D-05,-0.2445D-05,-0.3028D-05,
     ,  -0.3430D-05,-0.3719D-05,-0.3938D-05,-0.4108D-05,-0.4239D-05,
     ,  -0.4340D-05,-0.4415D-05,-0.4469D-05,-0.4509D-05,-0.4537D-05,
     ,  -0.4557D-05,-0.4571D-05,-0.4580D-05/
      data (calcpts(j,42), j = 1,neta) /
     ,   0.2711D-15,-0.1085D-15,-0.3007D-15, 0.8973D-16, 0.1472D-15,
     ,  -0.1621D-15,-0.3405D-15, 0.3063D-14, 0.1989D-14, 0.1552D-15,
     ,   0.2111D-14,-0.1709D-14,-0.2289D-14, 0.5940D-15,-0.2728D-16,
     ,   0.2404D-15, 0.4915D-14, 0.3151D-14, 0.2382D-14, 0.2368D-13,
     ,  -0.5949D-14,-0.1174D-13, 0.1667D-13, 0.2625D-13, 0.6406D-13,
     ,   0.8633D-13, 0.1373D-12, 0.3113D-12, 0.5687D-12, 0.9188D-12,
     ,   0.1593D-11, 0.2930D-11, 0.5198D-11, 0.9205D-11, 0.1708D-10,
     ,   0.3136D-10, 0.5989D-10, 0.1164D-09, 0.2288D-09, 0.4571D-09,
     ,   0.9212D-09, 0.1858D-08, 0.3751D-08, 0.7526D-08, 0.1498D-07,
     ,   0.2946D-07, 0.5692D-07, 0.1075D-06, 0.1967D-06, 0.3452D-06,
     ,   0.5721D-06, 0.8784D-06, 0.1218D-05, 0.1473D-05, 0.1481D-05,
     ,   0.1128D-05, 0.4529D-06,-0.3583D-06,-0.1100D-05,-0.1670D-05,
     ,  -0.2067D-05,-0.2341D-05,-0.2539D-05,-0.2688D-05,-0.2804D-05,
     ,  -0.2894D-05,-0.2962D-05,-0.3014D-05,-0.3051D-05,-0.3078D-05,
     ,  -0.3097D-05,-0.3110D-05,-0.3120D-05/
      data (calcpts(j,43), j = 1,neta) /
     ,   0.1324D-15, 0.6265D-17, 0.3484D-16,-0.1927D-15, 0.3368D-16,
     ,   0.1567D-15,-0.6196D-16, 0.1413D-15,-0.5429D-15,-0.6055D-15,
     ,   0.1311D-14,-0.1621D-14, 0.1759D-14, 0.8348D-15,-0.2332D-14,
     ,   0.5078D-15, 0.6099D-15, 0.1145D-14, 0.8626D-15, 0.5373D-14,
     ,  -0.2973D-14,-0.1084D-13, 0.2700D-13, 0.2130D-13, 0.3794D-13,
     ,   0.3195D-13, 0.5128D-13, 0.8245D-13, 0.1605D-12, 0.3028D-12,
     ,   0.5290D-12, 0.9487D-12, 0.1654D-11, 0.2928D-11, 0.5489D-11,
     ,   0.1063D-10, 0.1967D-10, 0.3854D-10, 0.7631D-10, 0.1519D-09,
     ,   0.3088D-09, 0.6246D-09, 0.1271D-08, 0.2568D-08, 0.5158D-08,
     ,   0.1027D-07, 0.2017D-07, 0.3898D-07, 0.7349D-07, 0.1345D-06,
     ,   0.2358D-06, 0.3905D-06, 0.5992D-06, 0.8303D-06, 0.1004D-05,
     ,   0.1009D-05, 0.7679D-06, 0.3071D-06,-0.2453D-06,-0.7513D-06,
     ,  -0.1140D-05,-0.1411D-05,-0.1597D-05,-0.1732D-05,-0.1834D-05,
     ,  -0.1913D-05,-0.1975D-05,-0.2021D-05,-0.2056D-05,-0.2082D-05,
     ,  -0.2100D-05,-0.2113D-05,-0.2122D-05/
      data (calcpts(j,44), j = 1,neta) /
     ,  -0.4517D-16,-0.6092D-16,-0.2223D-15,-0.1565D-15,-0.1146D-16,
     ,  -0.7248D-16,-0.1382D-15,-0.4408D-16,-0.5136D-15,-0.4846D-15,
     ,  -0.3089D-15,-0.9033D-15,-0.2513D-15,-0.2532D-15,-0.1591D-14,
     ,  -0.4415D-15,-0.8788D-15, 0.6208D-16,-0.6027D-15,-0.2910D-15,
     ,  -0.4593D-14,-0.2692D-14,-0.1196D-14,-0.8414D-14, 0.1183D-14,
     ,   0.1508D-13,-0.7060D-14, 0.6070D-14, 0.5446D-13, 0.9071D-13,
     ,   0.1551D-12, 0.2822D-12, 0.4892D-12, 0.9518D-12, 0.1802D-11,
     ,   0.3363D-11, 0.6647D-11, 0.1261D-10, 0.2512D-10, 0.5015D-10,
     ,   0.1021D-09, 0.2090D-09, 0.4264D-09, 0.8685D-09, 0.1758D-08,
     ,   0.3536D-08, 0.7033D-08, 0.1381D-07, 0.2663D-07, 0.5024D-07,
     ,   0.9178D-07, 0.1609D-06, 0.2664D-06, 0.4087D-06, 0.5661D-06,
     ,   0.6839D-06, 0.6873D-06, 0.5226D-06, 0.2088D-06,-0.1680D-06,
     ,  -0.5131D-06,-0.7778D-06,-0.9624D-06,-0.1090D-05,-0.1181D-05,
     ,  -0.1251D-05,-0.1305D-05,-0.1347D-05,-0.1378D-05,-0.1402D-05,
     ,  -0.1420D-05,-0.1432D-05,-0.1441D-05/
      data (calcpts(j,45), j = 1,neta) /
     ,   0.2968D-16, 0.1458D-15,-0.3787D-16, 0.9829D-16, 0.1265D-15,
     ,   0.1111D-15, 0.1372D-15, 0.1959D-15, 0.4542D-16, 0.1709D-15,
     ,   0.2639D-15, 0.2922D-15, 0.3894D-15,-0.2584D-15,-0.8627D-16,
     ,  -0.3784D-15, 0.3083D-15, 0.8722D-15, 0.5267D-15, 0.1499D-14,
     ,   0.2535D-15, 0.1128D-14, 0.3456D-14, 0.3645D-14, 0.4938D-14,
     ,   0.8728D-14, 0.2900D-14, 0.1177D-13, 0.2549D-13, 0.3875D-13,
     ,   0.7440D-13, 0.1194D-12, 0.1952D-12, 0.3367D-12, 0.6262D-12,
     ,   0.1152D-11, 0.2201D-11, 0.4262D-11, 0.8414D-11, 0.1693D-10,
     ,   0.3438D-10, 0.7021D-10, 0.1434D-09, 0.2928D-09, 0.5945D-09,
     ,   0.1207D-08, 0.2424D-08, 0.4814D-08, 0.9449D-08, 0.1821D-07,
     ,   0.3429D-07, 0.6269D-07, 0.1098D-06, 0.1818D-06, 0.2787D-06,
     ,   0.3858D-06, 0.4662D-06, 0.4686D-06, 0.3564D-06, 0.1419D-06,
     ,  -0.1147D-06,-0.3499D-06,-0.5301D-06,-0.6561D-06,-0.7425D-06,
     ,  -0.8055D-06,-0.8530D-06,-0.8899D-06,-0.9178D-06,-0.9396D-06,
     ,  -0.9560D-06,-0.9676D-06,-0.9761D-06/
      data (calcpts(j,46), j = 1,neta) /
     ,   0.1042D-16, 0.1430D-16,-0.5909D-17, 0.2114D-16, 0.7687D-17,
     ,   0.8056D-16, 0.7582D-16, 0.3642D-16, 0.1949D-16, 0.1805D-16,
     ,   0.1226D-15, 0.2218D-16, 0.1873D-16, 0.2192D-15,-0.5188D-16,
     ,   0.4522D-15, 0.5048D-15, 0.2844D-15, 0.8284D-15, 0.2019D-15,
     ,   0.6165D-15, 0.6683D-16, 0.5829D-15, 0.1032D-14, 0.1523D-14,
     ,   0.2886D-14, 0.1399D-14, 0.8055D-14, 0.6661D-14, 0.1920D-13,
     ,   0.1831D-13, 0.3389D-13, 0.5198D-13, 0.1162D-12, 0.2120D-12,
     ,   0.3737D-12, 0.7283D-12, 0.1410D-11, 0.2768D-11, 0.5574D-11,
     ,   0.1136D-10, 0.2331D-10, 0.4778D-10, 0.9803D-10, 0.2005D-09,
     ,   0.4082D-09, 0.8257D-09, 0.1658D-08, 0.3293D-08, 0.6453D-08,
     ,   0.1243D-07, 0.2341D-07, 0.4276D-07, 0.7489D-07, 0.1239D-06,
     ,   0.1900D-06, 0.2629D-06, 0.3179D-06, 0.3193D-06, 0.2424D-06,
     ,   0.9667D-07,-0.7843D-07,-0.2386D-06,-0.3615D-06,-0.4472D-06,
     ,  -0.5064D-06,-0.5490D-06,-0.5813D-06,-0.6063D-06,-0.6258D-06,
     ,  -0.6406D-06,-0.6515D-06,-0.6596D-06/
      data (calcpts(j,47), j = 1,neta) /
     ,  -0.7100D-17,-0.2744D-18,-0.1423D-16,-0.7337D-17,-0.3353D-18,
     ,  -0.2337D-16,-0.4042D-16,-0.2409D-18,-0.1479D-16,-0.5508D-16,
     ,   0.4872D-17,-0.1444D-16,-0.5121D-16, 0.3254D-16,-0.7959D-16,
     ,  -0.4920D-16,-0.6712D-16, 0.1186D-15, 0.2221D-15, 0.2376D-15,
     ,   0.8337D-16,-0.5323D-15, 0.1755D-15,-0.4263D-15,-0.8573D-16,
     ,   0.1896D-15,-0.3953D-15,-0.1942D-15, 0.1752D-14, 0.3832D-14,
     ,   0.7600D-14, 0.8556D-14, 0.2023D-13, 0.3519D-13, 0.6508D-13,
     ,   0.1197D-12, 0.2248D-12, 0.4514D-12, 0.9015D-12, 0.1826D-11,
     ,   0.3718D-11, 0.7657D-11, 0.1579D-10, 0.3256D-10, 0.6711D-10,
     ,   0.1371D-09, 0.2794D-09, 0.5648D-09, 0.1133D-08, 0.2248D-08,
     ,   0.4406D-08, 0.8486D-08, 0.1597D-07, 0.2915D-07, 0.5105D-07,
     ,   0.8452D-07, 0.1296D-06, 0.1793D-06, 0.2167D-06, 0.2175D-06,
     ,   0.1652D-06, 0.6572D-07,-0.5352D-07,-0.1628D-06,-0.2465D-06,
     ,  -0.3048D-06,-0.3452D-06,-0.3743D-06,-0.3963D-06,-0.4133D-06,
     ,  -0.4266D-06,-0.4366D-06,-0.4442D-06/
      data (calcpts(j,48), j = 1,neta) /
     ,   0.1070D-17,-0.1597D-17,-0.5916D-17,-0.2739D-17, 0.3817D-17,
     ,   0.4176D-18,-0.3340D-17, 0.2547D-16, 0.1018D-16,-0.2625D-16,
     ,   0.1831D-16,-0.1483D-16, 0.1982D-16, 0.3831D-18,-0.3009D-16,
     ,  -0.3519D-16, 0.1109D-16,-0.1093D-16, 0.1905D-16, 0.1762D-15,
     ,  -0.1712D-15, 0.1777D-15, 0.1029D-15, 0.2307D-15,-0.2113D-15,
     ,   0.8499D-16,-0.3090D-15, 0.6845D-16, 0.7241D-15, 0.1005D-14,
     ,   0.1747D-14, 0.2538D-14, 0.3362D-14, 0.9655D-14, 0.2034D-13,
     ,   0.4421D-13, 0.8104D-13, 0.1499D-12, 0.2878D-12, 0.6096D-12,
     ,   0.1221D-11, 0.2560D-11, 0.5229D-11, 0.1081D-10, 0.2236D-10,
     ,   0.4595D-10, 0.9400D-10, 0.1912D-09, 0.3862D-09, 0.7746D-09,
     ,   0.1536D-08, 0.3007D-08, 0.5790D-08, 0.1089D-07, 0.1988D-07,
     ,   0.3479D-07, 0.5756D-07, 0.8824D-07, 0.1221D-06, 0.1475D-06,
     ,   0.1481D-06, 0.1125D-06, 0.4478D-07,-0.3654D-07,-0.1110D-06,
     ,  -0.1679D-06,-0.2077D-06,-0.2352D-06,-0.2550D-06,-0.2700D-06,
     ,  -0.2816D-06,-0.2906D-06,-0.2976D-06/
      data (calcpts(j,49), j = 1,neta) /
     ,  -0.5222D-18, 0.7815D-18,-0.1586D-17, 0.1708D-18, 0.6976D-18,
     ,  -0.1892D-17, 0.1735D-17, 0.2473D-17,-0.5319D-17, 0.8885D-17,
     ,  -0.3088D-17, 0.1091D-16,-0.1006D-17, 0.1540D-16,-0.2377D-17,
     ,  -0.1485D-16, 0.9075D-17, 0.1634D-16,-0.1008D-16, 0.2100D-16,
     ,  -0.3306D-16, 0.3433D-16, 0.9633D-16, 0.6119D-16, 0.1663D-15,
     ,  -0.5665D-16,-0.1507D-15, 0.1401D-15, 0.3035D-15, 0.4597D-15,
     ,   0.7287D-15, 0.1165D-14, 0.1850D-14, 0.1684D-14, 0.4204D-14,
     ,   0.1179D-13, 0.2506D-13, 0.5087D-13, 0.1019D-12, 0.2039D-12,
     ,   0.4108D-12, 0.8299D-12, 0.1718D-11, 0.3595D-11, 0.7434D-11,
     ,   0.1540D-10, 0.3152D-10, 0.6434D-10, 0.1306D-09, 0.2638D-09,
     ,   0.5286D-09, 0.1049D-08, 0.2053D-08, 0.3947D-08, 0.7427D-08,
     ,   0.1355D-07, 0.2371D-07, 0.3922D-07, 0.6013D-07, 0.8321D-07,
     ,   0.1005D-06, 0.1009D-06, 0.7668D-07, 0.3050D-07,-0.2490D-07,
     ,  -0.7562D-07,-0.1145D-06,-0.1416D-06,-0.1603D-06,-0.1738D-06,
     ,  -0.1840D-06,-0.1919D-06,-0.1980D-06/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
!  The O(\alpha_s^3) asymptotic contribution to the charged-current gluonic 
!  and pure-singlet heavy-quark production calculated in 
!  [Nucl.Phys. B881, 1 (2014)] and [S. Moch (2013), unpublished]. 
!  All terms are given in the tabulated form ready for the realistic kinematics.
!-----------------------------

      subroutine c2hqps21cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.1595D-04,-0.2288D-04,-0.3281D-04,-0.4701D-04,-0.6731D-04,
     ,  -0.9633D-04,-0.1378D-03,-0.1969D-03,-0.2812D-03,-0.4012D-03,
     ,  -0.5721D-03,-0.8150D-03,-0.1160D-02,-0.1649D-02,-0.2343D-02,
     ,  -0.3324D-02,-0.4710D-02,-0.6666D-02,-0.9421D-02,-0.1329D-01,
     ,  -0.1873D-01,-0.2634D-01,-0.3697D-01,-0.5176D-01,-0.7230D-01,
     ,  -0.1007D+00,-0.1398D+00,-0.1933D+00,-0.2661D+00,-0.3642D+00,
     ,  -0.4950D+00,-0.6669D+00,-0.8882D+00,-0.1165D+01,-0.1498D+01,
     ,  -0.1876D+01,-0.2268D+01,-0.2613D+01,-0.2818D+01,-0.2755D+01,
     ,  -0.2241D+01,-0.9914D+00, 0.1509D+01, 0.6178D+01, 0.1456D+02,
     ,   0.2907D+02, 0.5340D+02, 0.9301D+02, 0.1560D+03, 0.2543D+03,
     ,   0.4054D+03, 0.6353D+03, 0.9818D+03, 0.1501D+04, 0.2273D+04,
     ,   0.3420D+04, 0.5117D+04, 0.7623D+04, 0.1132D+05, 0.1676D+05,
     ,   0.2476D+05, 0.3652D+05, 0.5381D+05, 0.7920D+05, 0.1165D+06,
     ,   0.1713D+06, 0.2517D+06, 0.3698D+06, 0.5431D+06, 0.7975D+06,
     ,   0.1171D+07, 0.1719D+07, 0.2524D+07/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.1159D-04,-0.1663D-04,-0.2384D-04,-0.3417D-04,-0.4894D-04,
     ,  -0.7005D-04,-0.1002D-03,-0.1432D-03,-0.2046D-03,-0.2920D-03,
     ,  -0.4164D-03,-0.5934D-03,-0.8448D-03,-0.1201D-02,-0.1707D-02,
     ,  -0.2423D-02,-0.3434D-02,-0.4862D-02,-0.6875D-02,-0.9706D-02,
     ,  -0.1368D-01,-0.1925D-01,-0.2703D-01,-0.3788D-01,-0.5296D-01,
     ,  -0.7383D-01,-0.1026D+00,-0.1421D+00,-0.1960D+00,-0.2690D+00,
     ,  -0.3669D+00,-0.4965D+00,-0.6654D+00,-0.8805D+00,-0.1146D+01,
     ,  -0.1458D+01,-0.1800D+01,-0.2133D+01,-0.2385D+01,-0.2450D+01,
     ,  -0.2174D+01,-0.1334D+01, 0.4373D+00, 0.3792D+01, 0.9868D+01,
     ,   0.2053D+02, 0.3867D+02, 0.6865D+02, 0.1169D+03, 0.1931D+03,
     ,   0.3111D+03, 0.4918D+03, 0.7654D+03, 0.1177D+04, 0.1791D+04,
     ,   0.2705D+04, 0.4060D+04, 0.6062D+04, 0.9016D+04, 0.1337D+05,
     ,   0.1978D+05, 0.2920D+05, 0.4305D+05, 0.6340D+05, 0.9329D+05,
     ,   0.1372D+06, 0.2017D+06, 0.2963D+06, 0.4352D+06, 0.6392D+06,
     ,   0.9386D+06, 0.1378D+07, 0.2023D+07/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.8296D-05,-0.1190D-04,-0.1707D-04,-0.2447D-04,-0.3505D-04,
     ,  -0.5018D-04,-0.7179D-04,-0.1026D-03,-0.1467D-03,-0.2094D-03,
     ,  -0.2987D-03,-0.4257D-03,-0.6063D-03,-0.8626D-03,-0.1226D-02,
     ,  -0.1741D-02,-0.2469D-02,-0.3496D-02,-0.4946D-02,-0.6986D-02,
     ,  -0.9853D-02,-0.1387D-01,-0.1949D-01,-0.2734D-01,-0.3826D-01,
     ,  -0.5340D-01,-0.7431D-01,-0.1031D+00,-0.1424D+00,-0.1959D+00,
     ,  -0.2681D+00,-0.3643D+00,-0.4910D+00,-0.6547D+00,-0.8609D+00,
     ,  -0.1111D+01,-0.1399D+01,-0.1702D+01,-0.1974D+01,-0.2134D+01,
     ,  -0.2061D+01,-0.1578D+01,-0.4182D+00, 0.1864D+01, 0.6054D+01,
     ,   0.1350D+02, 0.2636D+02, 0.4799D+02, 0.8337D+02, 0.1399D+03,
     ,   0.2286D+03, 0.3654D+03, 0.5740D+03, 0.8892D+03, 0.1362D+04,
     ,   0.2067D+04, 0.3115D+04, 0.4666D+04, 0.6957D+04, 0.1034D+05,
     ,   0.1531D+05, 0.2264D+05, 0.3341D+05, 0.4923D+05, 0.7248D+05,
     ,   0.1066D+06, 0.1568D+06, 0.2304D+06, 0.3385D+06, 0.4972D+06,
     ,   0.7302D+06, 0.1072D+07, 0.1574D+07/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.5871D-05,-0.8425D-05,-0.1209D-04,-0.1733D-04,-0.2483D-04,
     ,  -0.3555D-04,-0.5087D-04,-0.7276D-04,-0.1040D-03,-0.1485D-03,
     ,  -0.2119D-03,-0.3021D-03,-0.4304D-03,-0.6126D-03,-0.8710D-03,
     ,  -0.1237D-02,-0.1755D-02,-0.2487D-02,-0.3521D-02,-0.4976D-02,
     ,  -0.7022D-02,-0.9893D-02,-0.1391D-01,-0.1953D-01,-0.2735D-01,
     ,  -0.3822D-01,-0.5326D-01,-0.7399D-01,-0.1024D+00,-0.1412D+00,
     ,  -0.1938D+00,-0.2643D+00,-0.3579D+00,-0.4804D+00,-0.6372D+00,
     ,  -0.8325D+00,-0.1066D+01,-0.1327D+01,-0.1590D+01,-0.1800D+01,
     ,  -0.1870D+01,-0.1663D+01,-0.9805D+00, 0.4869D+00, 0.3261D+01,
     ,   0.8255D+01, 0.1701D+02, 0.3197D+02, 0.5690D+02, 0.9740D+02,
     ,   0.1618D+03, 0.2622D+03, 0.4167D+03, 0.6517D+03, 0.1006D+04,
     ,   0.1537D+04, 0.2327D+04, 0.3500D+04, 0.5236D+04, 0.7800D+04,
     ,   0.1158D+05, 0.1714D+05, 0.2533D+05, 0.3736D+05, 0.5505D+05,
     ,   0.8103D+05, 0.1192D+06, 0.1752D+06, 0.2575D+06, 0.3783D+06,
     ,   0.5556D+06, 0.8159D+06, 0.1198D+07/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.4121D-05,-0.5915D-05,-0.8487D-05,-0.1217D-04,-0.1744D-04,
     ,  -0.2498D-04,-0.3576D-04,-0.5116D-04,-0.7313D-04,-0.1045D-03,
     ,  -0.1491D-03,-0.2127D-03,-0.3031D-03,-0.4316D-03,-0.6139D-03,
     ,  -0.8724D-03,-0.1238D-02,-0.1756D-02,-0.2486D-02,-0.3516D-02,
     ,  -0.4965D-02,-0.7001D-02,-0.9854D-02,-0.1384D-01,-0.1941D-01,
     ,  -0.2715D-01,-0.3788D-01,-0.5270D-01,-0.7308D-01,-0.1010D+00,
     ,  -0.1389D+00,-0.1901D+00,-0.2585D+00,-0.3488D+00,-0.4661D+00,
     ,  -0.6150D+00,-0.7982D+00,-0.1013D+01,-0.1247D+01,-0.1468D+01,
     ,  -0.1618D+01,-0.1600D+01,-0.1264D+01,-0.3902D+00, 0.1373D+01,
     ,   0.4619D+01, 0.1038D+02, 0.2038D+02, 0.3733D+02, 0.6539D+02,
     ,   0.1107D+03, 0.1825D+03, 0.2940D+03, 0.4652D+03, 0.7251D+03,
     ,   0.1116D+04, 0.1701D+04, 0.2572D+04, 0.3864D+04, 0.5774D+04,
     ,   0.8594D+04, 0.1275D+05, 0.1887D+05, 0.2786D+05, 0.4109D+05,
     ,   0.6053D+05, 0.8908D+05, 0.1310D+06, 0.1926D+06, 0.2830D+06,
     ,   0.4157D+06, 0.6105D+06, 0.8966D+06/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.2876D-05,-0.4129D-05,-0.5925D-05,-0.8498D-05,-0.1218D-04,
     ,  -0.1745D-04,-0.2499D-04,-0.3576D-04,-0.5114D-04,-0.7308D-04,
     ,  -0.1044D-03,-0.1489D-03,-0.2123D-03,-0.3024D-03,-0.4303D-03,
     ,  -0.6117D-03,-0.8688D-03,-0.1232D-02,-0.1746D-02,-0.2471D-02,
     ,  -0.3492D-02,-0.4926D-02,-0.6939D-02,-0.9757D-02,-0.1369D-01,
     ,  -0.1917D-01,-0.2679D-01,-0.3732D-01,-0.5184D-01,-0.7176D-01,
     ,  -0.9893D-01,-0.1358D+00,-0.1853D+00,-0.2512D+00,-0.3377D+00,
     ,  -0.4493D+00,-0.5896D+00,-0.7599D+00,-0.9555D+00,-0.1161D+01,
     ,  -0.1341D+01,-0.1431D+01,-0.1327D+01,-0.8676D+00, 0.1906D+00,
     ,   0.2237D+01, 0.5937D+01, 0.1243D+02, 0.2362D+02, 0.4247D+02,
     ,   0.7350D+02, 0.1234D+03, 0.2022D+03, 0.3243D+03, 0.5113D+03,
     ,   0.7947D+03, 0.1221D+04, 0.1858D+04, 0.2805D+04, 0.4209D+04,
     ,   0.6284D+04, 0.9347D+04, 0.1386D+05, 0.2050D+05, 0.3027D+05,
     ,   0.4463D+05, 0.6573D+05, 0.9672D+05, 0.1422D+06, 0.2091D+06,
     ,   0.3072D+06, 0.4512D+06, 0.6627D+06/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.1998D-05,-0.2870D-05,-0.4119D-05,-0.5910D-05,-0.8474D-05,
     ,  -0.1214D-04,-0.1739D-04,-0.2490D-04,-0.3561D-04,-0.5091D-04,
     ,  -0.7272D-04,-0.1038D-03,-0.1480D-03,-0.2110D-03,-0.3003D-03,
     ,  -0.4272D-03,-0.6070D-03,-0.8615D-03,-0.1221D-02,-0.1729D-02,
     ,  -0.2445D-02,-0.3453D-02,-0.4867D-02,-0.6849D-02,-0.9621D-02,
     ,  -0.1349D-01,-0.1886D-01,-0.2632D-01,-0.3661D-01,-0.5077D-01,
     ,  -0.7014D-01,-0.9651D-01,-0.1321D+00,-0.1798D+00,-0.2430D+00,
     ,  -0.3254D+00,-0.4308D+00,-0.5621D+00,-0.7189D+00,-0.8949D+00,
     ,  -0.1071D+01,-0.1210D+01,-0.1242D+01,-0.1054D+01,-0.4746D+00,
     ,   0.7614D+00, 0.3082D+01, 0.7218D+01, 0.1442D+02, 0.2675D+02,
     ,   0.4742D+02, 0.8130D+02, 0.1356D+03, 0.2210D+03, 0.3533D+03,
     ,   0.5554D+03, 0.8614D+03, 0.1321D+04, 0.2007D+04, 0.3027D+04,
     ,   0.4539D+04, 0.6772D+04, 0.1007D+05, 0.1492D+05, 0.2207D+05,
     ,   0.3257D+05, 0.4801D+05, 0.7070D+05, 0.1040D+06, 0.1530D+06,
     ,   0.2248D+06, 0.3303D+06, 0.4852D+06/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.1385D-05,-0.1989D-05,-0.2856D-05,-0.4098D-05,-0.5877D-05,
     ,  -0.8425D-05,-0.1207D-04,-0.1728D-04,-0.2473D-04,-0.3536D-04,
     ,  -0.5053D-04,-0.7215D-04,-0.1029D-03,-0.1468D-03,-0.2090D-03,
     ,  -0.2974D-03,-0.4228D-03,-0.6005D-03,-0.8517D-03,-0.1207D-02,
     ,  -0.1707D-02,-0.2412D-02,-0.3404D-02,-0.4794D-02,-0.6740D-02,
     ,  -0.9458D-02,-0.1324D-01,-0.1850D-01,-0.2577D-01,-0.3580D-01,
     ,  -0.4955D-01,-0.6833D-01,-0.9381D-01,-0.1281D+00,-0.1738D+00,
     ,  -0.2341D+00,-0.3122D+00,-0.4112D+00,-0.5331D+00,-0.6762D+00,
     ,  -0.8322D+00,-0.9801D+00,-0.1078D+01,-0.1052D+01,-0.7822D+00,
     ,  -0.8550D-01, 0.1323D+01, 0.3910D+01, 0.8470D+01, 0.1636D+02,
     ,   0.2979D+02, 0.5221D+02, 0.8884D+02, 0.1474D+03, 0.2393D+03,
     ,   0.3813D+03, 0.5980D+03, 0.9257D+03, 0.1418D+04, 0.2151D+04,
     ,   0.3242D+04, 0.4857D+04, 0.7243D+04, 0.1076D+05, 0.1595D+05,
     ,   0.2357D+05, 0.3479D+05, 0.5127D+05, 0.7549D+05, 0.1111D+06,
     ,   0.1633D+06, 0.2400D+06, 0.3526D+06/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.9575D-06,-0.1376D-05,-0.1976D-05,-0.2836D-05,-0.4068D-05,
     ,  -0.5833D-05,-0.8359D-05,-0.1197D-04,-0.1714D-04,-0.2451D-04,
     ,  -0.3504D-04,-0.5005D-04,-0.7143D-04,-0.1019D-03,-0.1452D-03,
     ,  -0.2067D-03,-0.2939D-03,-0.4176D-03,-0.5927D-03,-0.8403D-03,
     ,  -0.1190D-02,-0.1682D-02,-0.2375D-02,-0.3348D-02,-0.4711D-02,
     ,  -0.6617D-02,-0.9275D-02,-0.1297D-01,-0.1810D-01,-0.2518D-01,
     ,  -0.3491D-01,-0.4824D-01,-0.6639D-01,-0.9093D-01,-0.1238D+00,
     ,  -0.1675D+00,-0.2247D+00,-0.2984D+00,-0.3909D+00,-0.5032D+00,
     ,  -0.6325D+00,-0.7684D+00,-0.8876D+00,-0.9447D+00,-0.8613D+00,
     ,  -0.5114D+00, 0.3000D+00, 0.1878D+01, 0.4724D+01, 0.9697D+01,
     ,   0.1825D+02, 0.3276D+02, 0.5689D+02, 0.9618D+02, 0.1589D+03,
     ,   0.2570D+03, 0.4085D+03, 0.6394D+03, 0.9883D+03, 0.1511D+04,
     ,   0.2292D+04, 0.3450D+04, 0.5166D+04, 0.7701D+04, 0.1144D+05,
     ,   0.1694D+05, 0.2504D+05, 0.3695D+05, 0.5445D+05, 0.8015D+05,
     ,   0.1179D+06, 0.1734D+06, 0.2548D+06/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.6612D-06,-0.9501D-06,-0.1365D-05,-0.1959D-05,-0.2812D-05,
     ,  -0.4033D-05,-0.5781D-05,-0.8282D-05,-0.1186D-04,-0.1697D-04,
     ,  -0.2426D-04,-0.3467D-04,-0.4950D-04,-0.7062D-04,-0.1007D-03,
     ,  -0.1434D-03,-0.2040D-03,-0.2900D-03,-0.4119D-03,-0.5842D-03,
     ,  -0.8277D-03,-0.1171D-02,-0.1655D-02,-0.2334D-02,-0.3287D-02,
     ,  -0.4622D-02,-0.6485D-02,-0.9080D-02,-0.1268D-01,-0.1767D-01,
     ,  -0.2455D-01,-0.3398D-01,-0.4687D-01,-0.6436D-01,-0.8794D-01,
     ,  -0.1194D+00,-0.1610D+00,-0.2151D+00,-0.2842D+00,-0.3701D+00,
     ,  -0.4728D+00,-0.5880D+00,-0.7038D+00,-0.7943D+00,-0.8110D+00,
     ,  -0.6710D+00,-0.2418D+00, 0.6825D+00, 0.2426D+01, 0.5527D+01,
     ,   0.1090D+02, 0.2011D+02, 0.3567D+02, 0.6147D+02, 0.1034D+03,
     ,   0.1701D+03, 0.2744D+03, 0.4351D+03, 0.6799D+03, 0.1049D+04,
     ,   0.1603D+04, 0.2429D+04, 0.3655D+04, 0.5469D+04, 0.8149D+04,
     ,   0.1210D+05, 0.1792D+05, 0.2648D+05, 0.3906D+05, 0.5755D+05,
     ,   0.8472D+05, 0.1246D+06, 0.1832D+06/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.4561D-06,-0.6555D-06,-0.9418D-06,-0.1353D-05,-0.1941D-05,
     ,  -0.2785D-05,-0.3993D-05,-0.5723D-05,-0.8196D-05,-0.1173D-04,
     ,  -0.1678D-04,-0.2399D-04,-0.3426D-04,-0.4890D-04,-0.6974D-04,
     ,  -0.9937D-04,-0.1415D-03,-0.2012D-03,-0.2859D-03,-0.4057D-03,
     ,  -0.5751D-03,-0.8142D-03,-0.1151D-02,-0.1625D-02,-0.2291D-02,
     ,  -0.3224D-02,-0.4528D-02,-0.6347D-02,-0.8877D-02,-0.1238D-01,
     ,  -0.1723D-01,-0.2389D-01,-0.3302D-01,-0.4545D-01,-0.6227D-01,
     ,  -0.8486D-01,-0.1149D+00,-0.1543D+00,-0.2053D+00,-0.2699D+00,
     ,  -0.3491D+00,-0.4420D+00,-0.5431D+00,-0.6388D+00,-0.7007D+00,
     ,  -0.6771D+00,-0.4809D+00, 0.2682D-01, 0.1063D+01, 0.2970D+01,
     ,   0.6322D+01, 0.1210D+02, 0.2195D+02, 0.3854D+02, 0.6598D+02,
     ,   0.1105D+03, 0.1811D+03, 0.2915D+03, 0.4613D+03, 0.7198D+03,
     ,   0.1110D+04, 0.1694D+04, 0.2564D+04, 0.3856D+04, 0.5767D+04,
     ,   0.8589D+04, 0.1275D+05, 0.1888D+05, 0.2789D+05, 0.4114D+05,
     ,   0.6061D+05, 0.8921D+05, 0.1312D+06/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.3144D-06,-0.4520D-06,-0.6495D-06,-0.9329D-06,-0.1339D-05,
     ,  -0.1922D-05,-0.2757D-05,-0.3951D-05,-0.5661D-05,-0.8105D-05,
     ,  -0.1160D-04,-0.1658D-04,-0.2369D-04,-0.3383D-04,-0.4827D-04,
     ,  -0.6881D-04,-0.9800D-04,-0.1394D-03,-0.1982D-03,-0.2815D-03,
     ,  -0.3993D-03,-0.5656D-03,-0.8003D-03,-0.1131D-02,-0.1595D-02,
     ,  -0.2247D-02,-0.3158D-02,-0.4432D-02,-0.6205D-02,-0.8668D-02,
     ,  -0.1208D-01,-0.1677D-01,-0.2323D-01,-0.3204D-01,-0.4401D-01,
     ,  -0.6015D-01,-0.8173D-01,-0.1103D+00,-0.1476D+00,-0.1954D+00,
     ,  -0.2553D+00,-0.3278D+00,-0.4109D+00,-0.4980D+00,-0.5735D+00,
     ,  -0.6068D+00,-0.5432D+00,-0.2912D+00, 0.2945D+00, 0.1441D+01,
     ,   0.3511D+01, 0.7111D+01, 0.1328D+02, 0.2377D+02, 0.4138D+02,
     ,   0.7044D+02, 0.1175D+03, 0.1920D+03, 0.3083D+03, 0.4872D+03,
     ,   0.7592D+03, 0.1169D+04, 0.1783D+04, 0.2697D+04, 0.4054D+04,
     ,   0.6061D+04, 0.9025D+04, 0.1339D+05, 0.1982D+05, 0.2928D+05,
     ,   0.4319D+05, 0.6362D+05, 0.9364D+05/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.2166D-06,-0.3114D-06,-0.4476D-06,-0.6431D-06,-0.9235D-06,
     ,  -0.1326D-05,-0.1902D-05,-0.2727D-05,-0.3908D-05,-0.5596D-05,
     ,  -0.8010D-05,-0.1146D-04,-0.1638D-04,-0.2339D-04,-0.3339D-04,
     ,  -0.4761D-04,-0.6785D-04,-0.9659D-04,-0.1374D-03,-0.1952D-03,
     ,  -0.2770D-03,-0.3927D-03,-0.5559D-03,-0.7860D-03,-0.1110D-02,
     ,  -0.1564D-02,-0.2201D-02,-0.3091D-02,-0.4333D-02,-0.6060D-02,
     ,  -0.8455D-02,-0.1176D-01,-0.1631D-01,-0.2255D-01,-0.3104D-01,
     ,  -0.4254D-01,-0.5800D-01,-0.7857D-01,-0.1056D+00,-0.1408D+00,
     ,  -0.1854D+00,-0.2407D+00,-0.3064D+00,-0.3797D+00,-0.4527D+00,
     ,  -0.5081D+00,-0.5129D+00,-0.4093D+00,-0.1017D+00, 0.5614D+00,
     ,   0.1817D+01, 0.4048D+01, 0.7895D+01, 0.1446D+02, 0.2557D+02,
     ,   0.4420D+02, 0.7487D+02, 0.1244D+03, 0.2029D+03, 0.3251D+03,
     ,   0.5129D+03, 0.7982D+03, 0.1228D+04, 0.1871D+04, 0.2830D+04,
     ,   0.4251D+04, 0.6353D+04, 0.9456D+04, 0.1403D+05, 0.2076D+05,
     ,   0.3067D+05, 0.4522D+05, 0.6662D+05/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.1491D-06,-0.2145D-06,-0.3084D-06,-0.4432D-06,-0.6366D-06,
     ,  -0.9139D-06,-0.1311D-05,-0.1881D-05,-0.2696D-05,-0.3863D-05,
     ,  -0.5530D-05,-0.7913D-05,-0.1131D-04,-0.1617D-04,-0.2308D-04,
     ,  -0.3293D-04,-0.4695D-04,-0.6687D-04,-0.9515D-04,-0.1353D-03,
     ,  -0.1921D-03,-0.2724D-03,-0.3859D-03,-0.5460D-03,-0.7715D-03,
     ,  -0.1088D-02,-0.1533D-02,-0.2155D-02,-0.3024D-02,-0.4234D-02,
     ,  -0.5914D-02,-0.8239D-02,-0.1145D-01,-0.1585D-01,-0.2186D-01,
     ,  -0.3004D-01,-0.4107D-01,-0.5583D-01,-0.7538D-01,-0.1010D+00,
     ,  -0.1339D+00,-0.1754D+00,-0.2260D+00,-0.2849D+00,-0.3484D+00,
     ,  -0.4073D+00,-0.4426D+00,-0.4189D+00,-0.2754D+00, 0.8756D-01,
     ,   0.8278D+00, 0.2193D+01, 0.4584D+01, 0.8676D+01, 0.1563D+02,
     ,   0.2737D+02, 0.4700D+02, 0.7927D+02, 0.1313D+03, 0.2136D+03,
     ,   0.3417D+03, 0.5383D+03, 0.8370D+03, 0.1287D+04, 0.1959D+04,
     ,   0.2961D+04, 0.4446D+04, 0.6643D+04, 0.9885D+04, 0.1466D+05,
     ,   0.2170D+05, 0.3204D+05, 0.4725D+05/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.1027D-06,-0.1477D-06,-0.2124D-06,-0.3053D-06,-0.4386D-06,
     ,  -0.6299D-06,-0.9041D-06,-0.1297D-05,-0.1860D-05,-0.2665D-05,
     ,  -0.3817D-05,-0.5463D-05,-0.7814D-05,-0.1117D-04,-0.1595D-04,
     ,  -0.2277D-04,-0.3247D-04,-0.4627D-04,-0.6587D-04,-0.9368D-04,
     ,  -0.1331D-03,-0.1889D-03,-0.2678D-03,-0.3791D-03,-0.5360D-03,
     ,  -0.7568D-03,-0.1067D-02,-0.1501D-02,-0.2108D-02,-0.2955D-02,
     ,  -0.4133D-02,-0.5766D-02,-0.8022D-02,-0.1113D-01,-0.1538D-01,
     ,  -0.2118D-01,-0.2903D-01,-0.3958D-01,-0.5365D-01,-0.7218D-01,
     ,  -0.9628D-01,-0.1270D+00,-0.1653D+00,-0.2112D+00,-0.2634D+00,
     ,  -0.3171D+00,-0.3619D+00,-0.3770D+00,-0.3249D+00,-0.1417D+00,
     ,   0.2766D+00, 0.1094D+01, 0.2568D+01, 0.5118D+01, 0.9454D+01,
     ,   0.1679D+02, 0.2916D+02, 0.4979D+02, 0.8364D+02, 0.1382D+03,
     ,   0.2243D+03, 0.3582D+03, 0.5637D+03, 0.8756D+03, 0.1345D+04,
     ,   0.2047D+04, 0.3092D+04, 0.4641D+04, 0.6932D+04, 0.1031D+05,
     ,   0.1529D+05, 0.2263D+05, 0.3341D+05/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.7067D-07,-0.1017D-06,-0.1462D-06,-0.2103D-06,-0.3021D-06,
     ,  -0.4340D-06,-0.6231D-06,-0.8941D-06,-0.1282D-05,-0.1838D-05,
     ,  -0.2633D-05,-0.3770D-05,-0.5395D-05,-0.7714D-05,-0.1102D-04,
     ,  -0.1574D-04,-0.2245D-04,-0.3201D-04,-0.4559D-04,-0.6487D-04,
     ,  -0.9221D-04,-0.1309D-03,-0.1857D-03,-0.2631D-03,-0.3723D-03,
     ,  -0.5259D-03,-0.7419D-03,-0.1045D-02,-0.1469D-02,-0.2061D-02,
     ,  -0.2886D-02,-0.4032D-02,-0.5617D-02,-0.7804D-02,-0.1081D-01,
     ,  -0.1491D-01,-0.2049D-01,-0.2801D-01,-0.3809D-01,-0.5146D-01,
     ,  -0.6898D-01,-0.9157D-01,-0.1201D+00,-0.1552D+00,-0.1965D+00,
     ,  -0.2418D+00,-0.2858D+00,-0.3164D+00,-0.3114D+00,-0.2309D+00,
     ,  -0.7956D-02, 0.4654D+00, 0.1359D+01, 0.2942D+01, 0.5651D+01,
     ,   0.1023D+02, 0.1795D+02, 0.3094D+02, 0.5257D+02, 0.8801D+02,
     ,   0.1450D+03, 0.2350D+03, 0.3747D+03, 0.5890D+03, 0.9141D+03,
     ,   0.1403D+04, 0.2134D+04, 0.3222D+04, 0.4835D+04, 0.7219D+04,
     ,   0.1074D+05, 0.1592D+05, 0.2355D+05/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.4863D-07,-0.6999D-07,-0.1007D-06,-0.1448D-06,-0.2081D-06,
     ,  -0.2990D-06,-0.4293D-06,-0.6162D-06,-0.8841D-06,-0.1268D-05,
     ,  -0.1816D-05,-0.2602D-05,-0.3724D-05,-0.5326D-05,-0.7613D-05,
     ,  -0.1087D-04,-0.1552D-04,-0.2213D-04,-0.3154D-04,-0.4490D-04,
     ,  -0.6386D-04,-0.9072D-04,-0.1288D-03,-0.1825D-03,-0.2584D-03,
     ,  -0.3654D-03,-0.5158D-03,-0.7271D-03,-0.1023D-02,-0.1437D-02,
     ,  -0.2014D-02,-0.2817D-02,-0.3930D-02,-0.5468D-02,-0.7585D-02,
     ,  -0.1048D-01,-0.1444D-01,-0.1979D-01,-0.2699D-01,-0.3660D-01,
     ,  -0.4927D-01,-0.6576D-01,-0.8686D-01,-0.1132D+00,-0.1451D+00,
     ,  -0.1817D+00,-0.2203D+00,-0.2544D+00,-0.2709D+00,-0.2458D+00,
     ,  -0.1369D+00, 0.1257D+00, 0.6542D+00, 0.1625D+01, 0.3315D+01,
     ,   0.6183D+01, 0.1100D+02, 0.1911D+02, 0.3272D+02, 0.5534D+02,
     ,   0.9236D+02, 0.1518D+03, 0.2456D+03, 0.3912D+03, 0.6142D+03,
     ,   0.9524D+03, 0.1461D+04, 0.2221D+04, 0.3352D+04, 0.5028D+04,
     ,   0.7506D+04, 0.1116D+05, 0.1655D+05/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.3346D-07,-0.4816D-07,-0.6930D-07,-0.9967D-07,-0.1433D-06,
     ,  -0.2059D-06,-0.2958D-06,-0.4246D-06,-0.6094D-06,-0.8739D-06,
     ,  -0.1253D-05,-0.1795D-05,-0.2570D-05,-0.3677D-05,-0.5257D-05,
     ,  -0.7512D-05,-0.1073D-04,-0.1530D-04,-0.2181D-04,-0.3107D-04,
     ,  -0.4421D-04,-0.6284D-04,-0.8923D-04,-0.1266D-03,-0.1793D-03,
     ,  -0.2537D-03,-0.3584D-03,-0.5056D-03,-0.7121D-03,-0.1001D-02,
     ,  -0.1405D-02,-0.1967D-02,-0.2748D-02,-0.3828D-02,-0.5319D-02,
     ,  -0.7365D-02,-0.1016D-01,-0.1396D-01,-0.1910D-01,-0.2597D-01,
     ,  -0.3510D-01,-0.4707D-01,-0.6254D-01,-0.8214D-01,-0.1063D+00,
     ,  -0.1350D+00,-0.1669D+00,-0.1987D+00,-0.2230D+00,-0.2255D+00,
     ,  -0.1802D+00,-0.4299D-01, 0.2593D+00, 0.8428D+00, 0.1890D+01,
     ,   0.3689D+01, 0.6715D+01, 0.1178D+02, 0.2027D+02, 0.3449D+02,
     ,   0.5811D+02, 0.9671D+02, 0.1586D+03, 0.2562D+03, 0.4076D+03,
     ,   0.6394D+03, 0.9907D+03, 0.1519D+04, 0.2308D+04, 0.3482D+04,
     ,   0.5221D+04, 0.7793D+04, 0.1159D+05/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.2302D-07,-0.3314D-07,-0.4769D-07,-0.6861D-07,-0.9866D-07,
     ,  -0.1418D-06,-0.2037D-06,-0.2926D-06,-0.4199D-06,-0.6024D-06,
     ,  -0.8638D-06,-0.1238D-05,-0.1773D-05,-0.2537D-05,-0.3629D-05,
     ,  -0.5188D-05,-0.7410D-05,-0.1058D-04,-0.1508D-04,-0.2149D-04,
     ,  -0.3060D-04,-0.4351D-04,-0.6182D-04,-0.8774D-04,-0.1244D-03,
     ,  -0.1761D-03,-0.2490D-03,-0.3515D-03,-0.4955D-03,-0.6972D-03,
     ,  -0.9792D-03,-0.1373D-02,-0.1920D-02,-0.2678D-02,-0.3726D-02,
     ,  -0.5169D-02,-0.7145D-02,-0.9840D-02,-0.1349D-01,-0.1840D-01,
     ,  -0.2495D-01,-0.3360D-01,-0.4488D-01,-0.5932D-01,-0.7742D-01,
     ,  -0.9938D-01,-0.1248D+00,-0.1521D+00,-0.1771D+00,-0.1916D+00,
     ,  -0.1800D+00,-0.1147D+00, 0.5095D-01, 0.3929D+00, 0.1031D+01,
     ,   0.2155D+01, 0.4062D+01, 0.7246D+01, 0.1255D+02, 0.2143D+02,
     ,   0.3627D+02, 0.6088D+02, 0.1010D+03, 0.1654D+03, 0.2668D+03,
     ,   0.4240D+03, 0.6646D+03, 0.1029D+04, 0.1577D+04, 0.2395D+04,
     ,   0.3612D+04, 0.5414D+04, 0.8079D+04/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.1583D-07,-0.2280D-07,-0.3282D-07,-0.4722D-07,-0.6792D-07,
     ,  -0.9764D-07,-0.1403D-06,-0.2015D-06,-0.2894D-06,-0.4152D-06,
     ,  -0.5955D-06,-0.8536D-06,-0.1223D-05,-0.1751D-05,-0.2505D-05,
     ,  -0.3582D-05,-0.5118D-05,-0.7308D-05,-0.1043D-04,-0.1486D-04,
     ,  -0.2117D-04,-0.3012D-04,-0.4282D-04,-0.6080D-04,-0.8624D-04,
     ,  -0.1222D-03,-0.1729D-03,-0.2442D-03,-0.3445D-03,-0.4852D-03,
     ,  -0.6822D-03,-0.9572D-03,-0.1340D-02,-0.1872D-02,-0.2609D-02,
     ,  -0.3624D-02,-0.5019D-02,-0.6925D-02,-0.9517D-02,-0.1302D-01,
     ,  -0.1771D-01,-0.2393D-01,-0.3211D-01,-0.4268D-01,-0.5610D-01,
     ,  -0.7269D-01,-0.9246D-01,-0.1147D+00,-0.1373D+00,-0.1555D+00,
     ,  -0.1602D+00,-0.1345D+00,-0.4908D-01, 0.1449D+00, 0.5264D+00,
     ,   0.1220D+01, 0.2419D+01, 0.4434D+01, 0.7777D+01, 0.1332D+02,
     ,   0.2258D+02, 0.3804D+02, 0.6364D+02, 0.1054D+03, 0.1722D+03,
     ,   0.2774D+03, 0.4404D+03, 0.6897D+03, 0.1067D+04, 0.1635D+04,
     ,   0.2482D+04, 0.3741D+04, 0.5607D+04/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.1089D-07,-0.1568D-07,-0.2258D-07,-0.3250D-07,-0.4675D-07,
     ,  -0.6722D-07,-0.9662D-07,-0.1388D-06,-0.1993D-06,-0.2861D-06,
     ,  -0.4105D-06,-0.5886D-06,-0.8434D-06,-0.1208D-05,-0.1729D-05,
     ,  -0.2473D-05,-0.3535D-05,-0.5049D-05,-0.7206D-05,-0.1028D-04,
     ,  -0.1464D-04,-0.2085D-04,-0.2965D-04,-0.4212D-04,-0.5978D-04,
     ,  -0.8475D-04,-0.1200D-03,-0.1696D-03,-0.2395D-03,-0.3376D-03,
     ,  -0.4750D-03,-0.6672D-03,-0.9352D-03,-0.1308D-02,-0.1825D-02,
     ,  -0.2539D-02,-0.3522D-02,-0.4869D-02,-0.6705D-02,-0.9194D-02,
     ,  -0.1254D-01,-0.1701D-01,-0.2291D-01,-0.3061D-01,-0.4048D-01,
     ,  -0.5287D-01,-0.6796D-01,-0.8554D-01,-0.1046D+00,-0.1225D+00,
     ,  -0.1339D+00,-0.1288D+00,-0.8897D-01, 0.1650D-01, 0.2388D+00,
     ,   0.6599D+00, 0.1408D+01, 0.2684D+01, 0.4807D+01, 0.8308D+01,
     ,   0.1410D+02, 0.2374D+02, 0.3981D+02, 0.6640D+02, 0.1097D+03,
     ,   0.1790D+03, 0.2880D+03, 0.4568D+03, 0.7148D+03, 0.1105D+04,
     ,   0.1692D+04, 0.2568D+04, 0.3871D+04/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.7489D-08,-0.1079D-07,-0.1553D-07,-0.2236D-07,-0.3217D-07,
     ,  -0.4627D-07,-0.6653D-07,-0.9560D-07,-0.1373D-06,-0.1971D-06,
     ,  -0.2829D-06,-0.4057D-06,-0.5816D-06,-0.8332D-06,-0.1193D-05,
     ,  -0.1707D-05,-0.2441D-05,-0.3487D-05,-0.4979D-05,-0.7104D-05,
     ,  -0.1013D-04,-0.1442D-04,-0.2052D-04,-0.2917D-04,-0.4143D-04,
     ,  -0.5876D-04,-0.8325D-04,-0.1178D-03,-0.1664D-03,-0.2347D-03,
     ,  -0.3306D-03,-0.4648D-03,-0.6522D-03,-0.9132D-03,-0.1276D-02,
     ,  -0.1777D-02,-0.2469D-02,-0.3420D-02,-0.4719D-02,-0.6485D-02,
     ,  -0.8870D-02,-0.1207D-01,-0.1631D-01,-0.2189D-01,-0.2911D-01,
     ,  -0.3828D-01,-0.4965D-01,-0.6324D-01,-0.7862D-01,-0.9444D-01,
     ,  -0.1077D+00,-0.1123D+00,-0.9738D-01,-0.4348D-01, 0.8207D-01,
     ,   0.3327D+00, 0.7934D+00, 0.1597D+01, 0.2949D+01, 0.5180D+01,
     ,   0.8838D+01, 0.1487D+02, 0.2489D+02, 0.4158D+02, 0.6916D+02,
     ,   0.1141D+03, 0.1858D+03, 0.2986D+03, 0.4731D+03, 0.7399D+03,
     ,   0.1144D+04, 0.1750D+04, 0.2655D+04/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.5150D-08,-0.7420D-08,-0.1069D-07,-0.1538D-07,-0.2214D-07,
     ,  -0.3185D-07,-0.4580D-07,-0.6583D-07,-0.9458D-07,-0.1358D-06,
     ,  -0.1949D-06,-0.2797D-06,-0.4010D-06,-0.5746D-06,-0.8230D-06,
     ,  -0.1178D-05,-0.1685D-05,-0.2408D-05,-0.3440D-05,-0.4910D-05,
     ,  -0.7002D-05,-0.9977D-05,-0.1420D-04,-0.2020D-04,-0.2870D-04,
     ,  -0.4073D-04,-0.5774D-04,-0.8175D-04,-0.1156D-03,-0.1632D-03,
     ,  -0.2300D-03,-0.3237D-03,-0.4546D-03,-0.6372D-03,-0.8912D-03,
     ,  -0.1243D-02,-0.1730D-02,-0.2400D-02,-0.3318D-02,-0.4569D-02,
     ,  -0.6265D-02,-0.8547D-02,-0.1159D-01,-0.1562D-01,-0.2087D-01,
     ,  -0.2761D-01,-0.3608D-01,-0.4642D-01,-0.5851D-01,-0.7169D-01,
     ,  -0.8431D-01,-0.9287D-01,-0.9074D-01,-0.6598D-01, 0.2017D-02,
     ,   0.1476D+00, 0.4266D+00, 0.9269D+00, 0.1785D+01, 0.3214D+01,
     ,   0.5552D+01, 0.9369D+01, 0.1564D+02, 0.2605D+02, 0.4335D+02,
     ,   0.7192D+02, 0.1184D+03, 0.1926D+03, 0.3092D+03, 0.4895D+03,
     ,   0.7650D+03, 0.1182D+04, 0.1808D+04/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.3541D-08,-0.5103D-08,-0.7350D-08,-0.1058D-07,-0.1523D-07,
     ,  -0.2192D-07,-0.3153D-07,-0.4533D-07,-0.6513D-07,-0.9356D-07,
     ,  -0.1343D-06,-0.1927D-06,-0.2764D-06,-0.3963D-06,-0.5677D-06,
     ,  -0.8128D-06,-0.1163D-05,-0.1663D-05,-0.2376D-05,-0.3393D-05,
     ,  -0.4840D-05,-0.6900D-05,-0.9827D-05,-0.1398D-04,-0.1988D-04,
     ,  -0.2823D-04,-0.4004D-04,-0.5672D-04,-0.8024D-04,-0.1134D-03,
     ,  -0.1599D-03,-0.2253D-03,-0.3167D-03,-0.4444D-03,-0.6222D-03,
     ,  -0.8691D-03,-0.1211D-02,-0.1682D-02,-0.2330D-02,-0.3215D-02,
     ,  -0.4419D-02,-0.6044D-02,-0.8224D-02,-0.1112D-01,-0.1492D-01,
     ,  -0.1985D-01,-0.2611D-01,-0.3388D-01,-0.4320D-01,-0.5378D-01,
     ,  -0.6477D-01,-0.7417D-01,-0.7806D-01,-0.6914D-01,-0.3457D-01,
     ,   0.4751D-01, 0.2132D+00, 0.5205D+00, 0.1060D+01, 0.1973D+01,
     ,   0.3478D+01, 0.5925D+01, 0.9899D+01, 0.1641D+02, 0.2720D+02,
     ,   0.4512D+02, 0.7468D+02, 0.1227D+03, 0.1994D+03, 0.3198D+03,
     ,   0.5059D+03, 0.7901D+03, 0.1220D+04/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.2435D-08,-0.3509D-08,-0.5055D-08,-0.7280D-08,-0.1048D-07,
     ,  -0.1508D-07,-0.2170D-07,-0.3120D-07,-0.4485D-07,-0.6444D-07,
     ,  -0.9253D-07,-0.1328D-06,-0.1905D-06,-0.2732D-06,-0.3915D-06,
     ,  -0.5607D-06,-0.8025D-06,-0.1148D-05,-0.1641D-05,-0.2344D-05,
     ,  -0.3345D-05,-0.4770D-05,-0.6797D-05,-0.9677D-05,-0.1376D-04,
     ,  -0.1955D-04,-0.2775D-04,-0.3934D-04,-0.5569D-04,-0.7874D-04,
     ,  -0.1112D-03,-0.1567D-03,-0.2205D-03,-0.3097D-03,-0.4341D-03,
     ,  -0.6072D-03,-0.8471D-03,-0.1179D-02,-0.1635D-02,-0.2260D-02,
     ,  -0.3113D-02,-0.4269D-02,-0.5824D-02,-0.7900D-02,-0.1064D-01,
     ,  -0.1422D-01,-0.1882D-01,-0.2461D-01,-0.3168D-01,-0.3997D-01,
     ,  -0.4905D-01,-0.5784D-01,-0.6404D-01,-0.6325D-01,-0.4755D-01,
     ,  -0.3173D-02, 0.9300D-01, 0.2788D+00, 0.6144D+00, 0.1194D+01,
     ,   0.2162D+01, 0.3743D+01, 0.6297D+01, 0.1043D+02, 0.1718D+02,
     ,   0.2836D+02, 0.4689D+02, 0.7744D+02, 0.1270D+03, 0.2062D+03,
     ,   0.3303D+03, 0.5222D+03, 0.8152D+03/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.1674D-08,-0.2413D-08,-0.3476D-08,-0.5008D-08,-0.7211D-08,
     ,  -0.1038D-07,-0.1493D-07,-0.2148D-07,-0.3088D-07,-0.4438D-07,
     ,  -0.6374D-07,-0.9151D-07,-0.1313D-06,-0.1883D-06,-0.2700D-06,
     ,  -0.3868D-06,-0.5537D-06,-0.7923D-06,-0.1133D-05,-0.1619D-05,
     ,  -0.2311D-05,-0.3298D-05,-0.4701D-05,-0.6695D-05,-0.9527D-05,
     ,  -0.1354D-04,-0.1923D-04,-0.2728D-04,-0.3864D-04,-0.5467D-04,
     ,  -0.7724D-04,-0.1090D-03,-0.1535D-03,-0.2158D-03,-0.3027D-03,
     ,  -0.4239D-03,-0.5922D-03,-0.8251D-03,-0.1146D-02,-0.1588D-02,
     ,  -0.2191D-02,-0.3011D-02,-0.4118D-02,-0.5603D-02,-0.7577D-02,
     ,  -0.1017D-01,-0.1353D-01,-0.1780D-01,-0.2311D-01,-0.2948D-01,
     ,  -0.3674D-01,-0.4433D-01,-0.5092D-01,-0.5391D-01,-0.4844D-01,
     ,  -0.2596D-01, 0.2823D-01, 0.1385D+00, 0.3443D+00, 0.7083D+00,
     ,   0.1327D+01, 0.2350D+01, 0.4008D+01, 0.6670D+01, 0.1096D+02,
     ,   0.1796D+02, 0.2951D+02, 0.4866D+02, 0.8020D+02, 0.1314D+03,
     ,   0.2130D+03, 0.3409D+03, 0.5386D+03/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.1151D-08,-0.1659D-08,-0.2390D-08,-0.3444D-08,-0.4960D-08,
     ,  -0.7141D-08,-0.1028D-07,-0.1478D-07,-0.2126D-07,-0.3056D-07,
     ,  -0.4390D-07,-0.6304D-07,-0.9049D-07,-0.1298D-06,-0.1861D-06,
     ,  -0.2667D-06,-0.3820D-06,-0.5468D-06,-0.7821D-06,-0.1118D-05,
     ,  -0.1597D-05,-0.2279D-05,-0.3250D-05,-0.4631D-05,-0.6593D-05,
     ,  -0.9377D-05,-0.1332D-04,-0.1891D-04,-0.2680D-04,-0.3794D-04,
     ,  -0.5365D-04,-0.7574D-04,-0.1068D-03,-0.1502D-03,-0.2110D-03,
     ,  -0.2958D-03,-0.4137D-03,-0.5771D-03,-0.8030D-03,-0.1114D-02,
     ,  -0.1540D-02,-0.2121D-02,-0.2908D-02,-0.3968D-02,-0.5383D-02,
     ,  -0.7253D-02,-0.9694D-02,-0.1283D-01,-0.1678D-01,-0.2161D-01,
     ,  -0.2728D-01,-0.3352D-01,-0.3960D-01,-0.4399D-01,-0.4377D-01,
     ,  -0.3364D-01,-0.4362D-02, 0.5963D-01, 0.1840D+00, 0.4099D+00,
     ,   0.8022D+00, 0.1461D+01, 0.2539D+01, 0.4272D+01, 0.7042D+01,
     ,   0.1149D+02, 0.1873D+02, 0.3066D+02, 0.5043D+02, 0.8296D+02,
     ,   0.1357D+03, 0.2198D+03, 0.3515D+03/


      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine c2hqps20cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.1474D-03, 0.2070D-03, 0.2904D-03, 0.4070D-03, 0.5698D-03,
     ,   0.7967D-03, 0.1113D-02, 0.1552D-02, 0.2162D-02, 0.3007D-02,
     ,   0.4177D-02, 0.5791D-02, 0.8017D-02, 0.1108D-01, 0.1528D-01,
     ,   0.2103D-01, 0.2888D-01, 0.3957D-01, 0.5407D-01, 0.7369D-01,
     ,   0.1001D+00, 0.1356D+00, 0.1830D+00, 0.2460D+00, 0.3292D+00,
     ,   0.4384D+00, 0.5804D+00, 0.7633D+00, 0.9959D+00, 0.1287D+01,
     ,   0.1644D+01, 0.2069D+01, 0.2555D+01, 0.3074D+01, 0.3570D+01,
     ,   0.3938D+01, 0.4015D+01, 0.3567D+01, 0.2294D+01,-0.1589D+00,
     ,  -0.4227D+01,-0.1048D+02,-0.1968D+02,-0.3278D+02,-0.5073D+02,
     ,  -0.7439D+02,-0.1044D+03,-0.1410D+03,-0.1843D+03,-0.2339D+03,
     ,  -0.2889D+03,-0.3471D+03,-0.4051D+03,-0.4571D+03,-0.4942D+03,
     ,  -0.5023D+03,-0.4604D+03,-0.3367D+03,-0.8428D+02, 0.3667D+03,
     ,   0.1119D+04, 0.2325D+04, 0.4209D+04, 0.7098D+04, 0.1148D+05,
     ,   0.1805D+05, 0.2788D+05, 0.4247D+05, 0.6409D+05, 0.9603D+05,
     ,   0.1431D+06, 0.2125D+06, 0.3146D+06/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1095D-03, 0.1538D-03, 0.2160D-03, 0.3029D-03, 0.4243D-03,
     ,   0.5937D-03, 0.8298D-03, 0.1158D-02, 0.1615D-02, 0.2248D-02,
     ,   0.3125D-02, 0.4337D-02, 0.6010D-02, 0.8314D-02, 0.1148D-01,
     ,   0.1582D-01, 0.2175D-01, 0.2984D-01, 0.4084D-01, 0.5574D-01,
     ,   0.7587D-01, 0.1030D+00, 0.1392D+00, 0.1875D+00, 0.2516D+00,
     ,   0.3359D+00, 0.4462D+00, 0.5890D+00, 0.7720D+00, 0.1003D+01,
     ,   0.1291D+01, 0.1639D+01, 0.2048D+01, 0.2505D+01, 0.2976D+01,
     ,   0.3394D+01, 0.3644D+01, 0.3547D+01, 0.2857D+01, 0.1265D+01,
     ,  -0.1597D+01,-0.6178D+01,-0.1308D+02,-0.2308D+02,-0.3712D+02,
     ,  -0.5612D+02,-0.8083D+02,-0.1117D+03,-0.1488D+03,-0.1919D+03,
     ,  -0.2400D+03,-0.2912D+03,-0.3424D+03,-0.3880D+03,-0.4197D+03,
     ,  -0.4243D+03,-0.3819D+03,-0.2626D+03,-0.2201D+02, 0.4059D+03,
     ,   0.1119D+04, 0.2260D+04, 0.4041D+04, 0.6773D+04, 0.1091D+05,
     ,   0.1714D+05, 0.2642D+05, 0.4023D+05, 0.6068D+05, 0.9090D+05,
     ,   0.1355D+06, 0.2011D+06, 0.2978D+06/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.8022D-04, 0.1128D-03, 0.1585D-03, 0.2224D-03, 0.3117D-03,
     ,   0.4366D-03, 0.6106D-03, 0.8531D-03, 0.1190D-02, 0.1659D-02,
     ,   0.2308D-02, 0.3206D-02, 0.4448D-02, 0.6160D-02, 0.8515D-02,
     ,   0.1175D-01, 0.1618D-01, 0.2222D-01, 0.3046D-01, 0.4165D-01,
     ,   0.5679D-01, 0.7720D-01, 0.1046D+00, 0.1413D+00, 0.1900D+00,
     ,   0.2544D+00, 0.3390D+00, 0.4491D+00, 0.5912D+00, 0.7723D+00,
     ,   0.9998D+00, 0.1280D+01, 0.1616D+01, 0.2004D+01, 0.2427D+01,
     ,   0.2844D+01, 0.3181D+01, 0.3309D+01, 0.3039D+01, 0.2112D+01,
     ,   0.2058D+00,-0.3061D+01,-0.8164D+01,-0.1574D+02,-0.2661D+02,
     ,  -0.4177D+02,-0.6216D+02,-0.8855D+02,-0.1214D+03,-0.1609D+03,
     ,  -0.2068D+03,-0.2581D+03,-0.3129D+03,-0.3680D+03,-0.4180D+03,
     ,  -0.4542D+03,-0.4635D+03,-0.4256D+03,-0.3104D+03,-0.7299D+02,
     ,   0.3533D+03, 0.1067D+04, 0.2213D+04, 0.4006D+04, 0.6759D+04,
     ,   0.1093D+05, 0.1721D+05, 0.2659D+05, 0.4052D+05, 0.6117D+05,
     ,   0.9169D+05, 0.1367D+06, 0.2030D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.5817D-04, 0.8185D-04, 0.1151D-03, 0.1616D-03, 0.2267D-03,
     ,   0.3177D-03, 0.4448D-03, 0.6219D-03, 0.8685D-03, 0.1211D-02,
     ,   0.1687D-02, 0.2346D-02, 0.3258D-02, 0.4518D-02, 0.6253D-02,
     ,   0.8638D-02, 0.1191D-01, 0.1639D-01, 0.2250D-01, 0.3081D-01,
     ,   0.4208D-01, 0.5732D-01, 0.7784D-01, 0.1053D+00, 0.1420D+00,
     ,   0.1907D+00, 0.2549D+00, 0.3389D+00, 0.4479D+00, 0.5880D+00,
     ,   0.7655D+00, 0.9870D+00, 0.1257D+01, 0.1577D+01, 0.1940D+01,
     ,   0.2325D+01, 0.2683D+01, 0.2933D+01, 0.2935D+01, 0.2487D+01,
     ,   0.1318D+01,-0.9086D+00,-0.4597D+01,-0.1026D+02,-0.1858D+02,
     ,  -0.3047D+02,-0.4700D+02,-0.6926D+02,-0.9817D+02,-0.1345D+03,
     ,  -0.1786D+03,-0.2307D+03,-0.2907D+03,-0.3574D+03,-0.4290D+03,
     ,  -0.5021D+03,-0.5708D+03,-0.6262D+03,-0.6542D+03,-0.6338D+03,
     ,  -0.5331D+03,-0.3050D+03, 0.1205D+03, 0.8466D+03, 0.2026D+04,
     ,   0.3881D+04, 0.6744D+04, 0.1110D+05, 0.1765D+05, 0.2746D+05,
     ,   0.4204D+05, 0.6366D+05, 0.9563D+05/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.4185D-04, 0.5893D-04, 0.8289D-04, 0.1165D-03, 0.1636D-03,
     ,   0.2294D-03, 0.3214D-03, 0.4498D-03, 0.6287D-03, 0.8777D-03,
     ,   0.1224D-02, 0.1704D-02, 0.2369D-02, 0.3288D-02, 0.4556D-02,
     ,   0.6302D-02, 0.8701D-02, 0.1199D-01, 0.1648D-01, 0.2261D-01,
     ,   0.3094D-01, 0.4222D-01, 0.5745D-01, 0.7792D-01, 0.1053D+00,
     ,   0.1418D+00, 0.1901D+00, 0.2535D+00, 0.3364D+00, 0.4434D+00,
     ,   0.5803D+00, 0.7528D+00, 0.9663D+00, 0.1224D+01, 0.1525D+01,
     ,   0.1860D+01, 0.2200D+01, 0.2495D+01, 0.2651D+01, 0.2519D+01,
     ,   0.1886D+01, 0.4637D+00,-0.2101D+01,-0.6239D+01,-0.1251D+02,
     ,  -0.2167D+02,-0.3476D+02,-0.5300D+02,-0.7767D+02,-0.1100D+03,
     ,  -0.1512D+03,-0.2024D+03,-0.2646D+03,-0.3389D+03,-0.4263D+03,
     ,  -0.5274D+03,-0.6430D+03,-0.7732D+03,-0.9175D+03,-0.1075D+04,
     ,  -0.1242D+04,-0.1416D+04,-0.1588D+04,-0.1747D+04,-0.1878D+04,
     ,  -0.1954D+04,-0.1937D+04,-0.1771D+04,-0.1372D+04,-0.6171D+03,
     ,   0.6752D+03, 0.2772D+04, 0.6066D+04/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.2993D-04, 0.4218D-04, 0.5937D-04, 0.8350D-04, 0.1173D-03,
     ,   0.1647D-03, 0.2309D-03, 0.3234D-03, 0.4525D-03, 0.6323D-03,
     ,   0.8824D-03, 0.1230D-02, 0.1711D-02, 0.2378D-02, 0.3299D-02,
     ,   0.4570D-02, 0.6317D-02, 0.8717D-02, 0.1200D-01, 0.1649D-01,
     ,   0.2260D-01, 0.3090D-01, 0.4213D-01, 0.5726D-01, 0.7757D-01,
     ,   0.1047D+00, 0.1407D+00, 0.1883D+00, 0.2507D+00, 0.3318D+00,
     ,   0.4362D+00, 0.5689D+00, 0.7351D+00, 0.9390D+00, 0.1182D+01,
     ,   0.1462D+01, 0.1763D+01, 0.2056D+01, 0.2280D+01, 0.2334D+01,
     ,   0.2060D+01, 0.1229D+01,-0.4624D+00,-0.3389D+01,-0.8018D+01,
     ,  -0.1496D+02,-0.2509D+02,-0.3958D+02,-0.5987D+02,-0.8756D+02,
     ,  -0.1244D+03,-0.1721D+03,-0.2327D+03,-0.3088D+03,-0.4032D+03,
     ,  -0.5198D+03,-0.6636D+03,-0.8411D+03,-0.1061D+04,-0.1337D+04,
     ,  -0.1686D+04,-0.2134D+04,-0.2717D+04,-0.3489D+04,-0.4528D+04,
     ,  -0.5946D+04,-0.7910D+04,-0.1066D+05,-0.1456D+05,-0.2012D+05,
     ,  -0.2811D+05,-0.3965D+05,-0.5639D+05/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.2132D-04, 0.3005D-04, 0.4233D-04, 0.5958D-04, 0.8378D-04,
     ,   0.1177D-03, 0.1651D-03, 0.2315D-03, 0.3242D-03, 0.4534D-03,
     ,   0.6333D-03, 0.8835D-03, 0.1231D-02, 0.1712D-02, 0.2378D-02,
     ,   0.3298D-02, 0.4565D-02, 0.6307D-02, 0.8697D-02, 0.1197D-01,
     ,   0.1643D-01, 0.2250D-01, 0.3073D-01, 0.4186D-01, 0.5682D-01,
     ,   0.7687D-01, 0.1036D+00, 0.1390D+00, 0.1857D+00, 0.2466D+00,
     ,   0.3255D+00, 0.4267D+00, 0.5544D+00, 0.7132D+00, 0.9059D+00,
     ,   0.1133D+01, 0.1387D+01, 0.1652D+01, 0.1892D+01, 0.2039D+01,
     ,   0.1984D+01, 0.1556D+01, 0.5118D+00,-0.1468D+01,-0.4787D+01,
     ,  -0.9951D+01,-0.1765D+02,-0.2887D+02,-0.4498D+02,-0.6768D+02,
     ,  -0.9900D+02,-0.1412D+03,-0.1970D+03,-0.2696D+03,-0.3633D+03,
     ,  -0.4835D+03,-0.6379D+03,-0.8370D+03,-0.1095D+04,-0.1434D+04,
     ,  -0.1882D+04,-0.2484D+04,-0.3301D+04,-0.4427D+04,-0.5993D+04,
     ,  -0.8196D+04,-0.1132D+05,-0.1579D+05,-0.2222D+05,-0.3150D+05,
     ,  -0.4497D+05,-0.6457D+05,-0.9314D+05/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1513D-04, 0.2135D-04, 0.3009D-04, 0.4237D-04, 0.5962D-04,
     ,   0.8381D-04, 0.1177D-03, 0.1651D-03, 0.2314D-03, 0.3239D-03,
     ,   0.4529D-03, 0.6324D-03, 0.8820D-03, 0.1228D-02, 0.1708D-02,
     ,   0.2371D-02, 0.3286D-02, 0.4546D-02, 0.6277D-02, 0.8650D-02,
     ,   0.1189D-01, 0.1632D-01, 0.2232D-01, 0.3046D-01, 0.4144D-01,
     ,   0.5618D-01, 0.7590D-01, 0.1021D+00, 0.1368D+00, 0.1823D+00,
     ,   0.2415D+00, 0.3179D+00, 0.4151D+00, 0.5372D+00, 0.6874D+00,
     ,   0.8676D+00, 0.1076D+01, 0.1303D+01, 0.1528D+01, 0.1709D+01,
     ,   0.1773D+01, 0.1599D+01, 0.1005D+01,-0.2678D+00,-0.2560D+01,
     ,  -0.6303D+01,-0.1205D+02,-0.2059D+02,-0.3304D+02,-0.5099D+02,
     ,  -0.7649D+02,-0.1120D+03,-0.1607D+03,-0.2261D+03,-0.3130D+03,
     ,  -0.4279D+03,-0.5795D+03,-0.7801D+03,-0.1047D+04,-0.1404D+04,
     ,  -0.1888D+04,-0.2549D+04,-0.3463D+04,-0.4737D+04,-0.6532D+04,
     ,  -0.9081D+04,-0.1272D+05,-0.1796D+05,-0.2553D+05,-0.3650D+05,
     ,  -0.5246D+05,-0.7573D+05,-0.1097D+06/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1071D-04, 0.1512D-04, 0.2133D-04, 0.3006D-04, 0.4232D-04,
     ,   0.5953D-04, 0.8367D-04, 0.1175D-03, 0.1648D-03, 0.2308D-03,
     ,   0.3230D-03, 0.4515D-03, 0.6302D-03, 0.8784D-03, 0.1223D-02,
     ,   0.1699D-02, 0.2358D-02, 0.3266D-02, 0.4516D-02, 0.6232D-02,
     ,   0.8582D-02, 0.1179D-01, 0.1616D-01, 0.2209D-01, 0.3010D-01,
     ,   0.4090D-01, 0.5538D-01, 0.7469D-01, 0.1003D+00, 0.1341D+00,
     ,   0.1783D+00, 0.2355D+00, 0.3090D+00, 0.4019D+00, 0.5175D+00,
     ,   0.6583D+00, 0.8244D+00, 0.1012D+01, 0.1209D+01, 0.1391D+01,
     ,   0.1509D+01, 0.1482D+01, 0.1180D+01, 0.4064D+00,-0.1113D+01,
     ,  -0.3742D+01,-0.7945D+01,-0.1434D+02,-0.2379D+02,-0.3761D+02,
     ,  -0.5763D+02,-0.8630D+02,-0.1267D+03,-0.1827D+03,-0.2593D+03,
     ,  -0.3629D+03,-0.5027D+03,-0.6910D+03,-0.9458D+03,-0.1292D+04,
     ,  -0.1767D+04,-0.2422D+04,-0.3335D+04,-0.4618D+04,-0.6433D+04,
     ,  -0.9022D+04,-0.1274D+05,-0.1809D+05,-0.2583D+05,-0.3708D+05,
     ,  -0.5345D+05,-0.7733D+05,-0.1122D+06/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.7569D-05, 0.1069D-04, 0.1509D-04, 0.2128D-04, 0.2998D-04,
     ,   0.4220D-04, 0.5935D-04, 0.8339D-04, 0.1170D-03, 0.1641D-03,
     ,   0.2298D-03, 0.3215D-03, 0.4492D-03, 0.6268D-03, 0.8733D-03,
     ,   0.1215D-02, 0.1688D-02, 0.2341D-02, 0.3241D-02, 0.4478D-02,
     ,   0.6174D-02, 0.8495D-02, 0.1166D-01, 0.1597D-01, 0.2180D-01,
     ,   0.2968D-01, 0.4027D-01, 0.5443D-01, 0.7329D-01, 0.9823D-01,
     ,   0.1310D+00, 0.1737D+00, 0.2287D+00, 0.2989D+00, 0.3871D+00,
     ,   0.4956D+00, 0.6260D+00, 0.7768D+00, 0.9420D+00, 0.1107D+01,
     ,   0.1240D+01, 0.1290D+01, 0.1166D+01, 0.7254D+00,-0.2405D+00,
     ,  -0.2025D+01,-0.5016D+01,-0.9718D+01,-0.1681D+02,-0.2727D+02,
     ,  -0.4259D+02,-0.6492D+02,-0.9714D+02,-0.1430D+03,-0.2074D+03,
     ,  -0.2966D+03,-0.4193D+03,-0.5874D+03,-0.8178D+03,-0.1135D+04,
     ,  -0.1572D+04,-0.2181D+04,-0.3034D+04,-0.4237D+04,-0.5945D+04,
     ,  -0.8384D+04,-0.1189D+05,-0.1694D+05,-0.2426D+05,-0.3490D+05,
     ,  -0.5039D+05,-0.7298D+05,-0.1060D+06/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.5340D-05, 0.7547D-05, 0.1066D-04, 0.1504D-04, 0.2120D-04,
     ,   0.2986D-04, 0.4203D-04, 0.5909D-04, 0.8300D-04, 0.1165D-03,
     ,   0.1632D-03, 0.2286D-03, 0.3196D-03, 0.4464D-03, 0.6225D-03,
     ,   0.8670D-03, 0.1206D-02, 0.1674D-02, 0.2320D-02, 0.3210D-02,
     ,   0.4432D-02, 0.6106D-02, 0.8394D-02, 0.1151D-01, 0.1574D-01,
     ,   0.2147D-01, 0.2919D-01, 0.3955D-01, 0.5337D-01, 0.7171D-01,
     ,   0.9591D-01, 0.1276D+00, 0.1686D+00, 0.2213D+00, 0.2879D+00,
     ,   0.3708D+00, 0.4716D+00, 0.5907D+00, 0.7250D+00, 0.8659D+00,
     ,   0.9952D+00, 0.1078D+01, 0.1054D+01, 0.8245D+00, 0.2360D+00,
     ,  -0.9366D+00,-0.3006D+01,-0.6387D+01,-0.1162D+02,-0.1947D+02,
     ,  -0.3103D+02,-0.4800D+02,-0.7286D+02,-0.1090D+03,-0.1610D+03,
     ,  -0.2347D+03,-0.3380D+03,-0.4820D+03,-0.6819D+03,-0.9596D+03,
     ,  -0.1346D+04,-0.1887D+04,-0.2648D+04,-0.3723D+04,-0.5253D+04,
     ,  -0.7440D+04,-0.1058D+05,-0.1512D+05,-0.2169D+05,-0.3124D+05,
     ,  -0.4514D+05,-0.6542D+05,-0.9505D+05/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.3763D-05, 0.5320D-05, 0.7517D-05, 0.1061D-04, 0.1497D-04,
     ,   0.2110D-04, 0.2972D-04, 0.4181D-04, 0.5877D-04, 0.8253D-04,
     ,   0.1158D-03, 0.1622D-03, 0.2270D-03, 0.3173D-03, 0.4430D-03,
     ,   0.6175D-03, 0.8596D-03, 0.1195D-02, 0.1658D-02, 0.2296D-02,
     ,   0.3174D-02, 0.4379D-02, 0.6029D-02, 0.8280D-02, 0.1134D-01,
     ,   0.1550D-01, 0.2111D-01, 0.2865D-01, 0.3875D-01, 0.5219D-01,
     ,   0.6998D-01, 0.9335D-01, 0.1238D+00, 0.1631D+00, 0.2131D+00,
     ,   0.2759D+00, 0.3531D+00, 0.4457D+00, 0.5525D+00, 0.6690D+00,
     ,   0.7839D+00, 0.8753D+00, 0.9032D+00, 0.8004D+00, 0.4584D+00,
     ,  -0.2887D+00,-0.1682D+01,-0.4056D+01,-0.7854D+01,-0.1367D+02,
     ,  -0.2232D+02,-0.3507D+02,-0.5383D+02,-0.8146D+02,-0.1219D+03,
     ,  -0.1806D+03,-0.2645D+03,-0.3835D+03,-0.5510D+03,-0.7862D+03,
     ,  -0.1116D+04,-0.1581D+04,-0.2236D+04,-0.3165D+04,-0.4488D+04,
     ,  -0.6381D+04,-0.9103D+04,-0.1303D+05,-0.1872D+05,-0.2698D+05,
     ,  -0.3900D+05,-0.5654D+05,-0.8216D+05/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.2648D-05, 0.3746D-05, 0.5296D-05, 0.7482D-05, 0.1056D-04,
     ,   0.1489D-04, 0.2099D-04, 0.2955D-04, 0.4156D-04, 0.5841D-04,
     ,   0.8199D-04, 0.1150D-03, 0.1610D-03, 0.2253D-03, 0.3148D-03,
     ,   0.4392D-03, 0.6119D-03, 0.8513D-03, 0.1183D-02, 0.1640D-02,
     ,   0.2270D-02, 0.3135D-02, 0.4322D-02, 0.5944D-02, 0.8155D-02,
     ,   0.1116D-01, 0.1522D-01, 0.2071D-01, 0.2806D-01, 0.3788D-01,
     ,   0.5092D-01, 0.6810D-01, 0.9059D-01, 0.1197D+00, 0.1571D+00,
     ,   0.2043D+00, 0.2629D+00, 0.3341D+00, 0.4177D+00, 0.5115D+00,
     ,   0.6089D+00, 0.6960D+00, 0.7469D+00, 0.7163D+00, 0.5293D+00,
     ,   0.6739D-01,-0.8488D+00,-0.2478D+01,-0.5176D+01,-0.9420D+01,
     ,  -0.1585D+02,-0.2537D+02,-0.3940D+02,-0.6010D+02,-0.9073D+02,
     ,  -0.1359D+03,-0.2018D+03,-0.2970D+03,-0.4330D+03,-0.6264D+03,
     ,  -0.9002D+03,-0.1288D+04,-0.1837D+04,-0.2618D+04,-0.3732D+04,
     ,  -0.5328D+04,-0.7621D+04,-0.1093D+05,-0.1572D+05,-0.2268D+05,
     ,  -0.3279D+05,-0.4755D+05,-0.6909D+05/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1862D-05, 0.2636D-05, 0.3728D-05, 0.5269D-05, 0.7442D-05,
     ,   0.1050D-04, 0.1481D-04, 0.2086D-04, 0.2936D-04, 0.4129D-04,
     ,   0.5800D-04, 0.8139D-04, 0.1141D-03, 0.1597D-03, 0.2233D-03,
     ,   0.3119D-03, 0.4350D-03, 0.6058D-03, 0.8423D-03, 0.1169D-02,
     ,   0.1620D-02, 0.2241D-02, 0.3093D-02, 0.4259D-02, 0.5852D-02,
     ,   0.8019D-02, 0.1096D-01, 0.1493D-01, 0.2027D-01, 0.2743D-01,
     ,   0.3695D-01, 0.4954D-01, 0.6608D-01, 0.8762D-01, 0.1154D+00,
     ,   0.1507D+00, 0.1949D+00, 0.2491D+00, 0.3138D+00, 0.3879D+00,
     ,   0.4678D+00, 0.5449D+00, 0.6023D+00, 0.6102D+00, 0.5173D+00,
     ,   0.2409D+00,-0.3485D+00,-0.1444D+01,-0.3324D+01,-0.6367D+01,
     ,  -0.1108D+02,-0.1817D+02,-0.2862D+02,-0.4402D+02,-0.6680D+02,
     ,  -0.1007D+03,-0.1509D+03,-0.2247D+03,-0.3320D+03,-0.4866D+03,
     ,  -0.7080D+03,-0.1024D+04,-0.1474D+04,-0.2116D+04,-0.3034D+04,
     ,  -0.4350D+04,-0.6242D+04,-0.8972D+04,-0.1292D+05,-0.1865D+05,
     ,  -0.2699D+05,-0.3914D+05,-0.5686D+05/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1308D-05, 0.1853D-05, 0.2622D-05, 0.3708D-05, 0.5239D-05,
     ,   0.7398D-05, 0.1044D-04, 0.1471D-04, 0.2072D-04, 0.2916D-04,
     ,   0.4098D-04, 0.5755D-04, 0.8073D-04, 0.1131D-03, 0.1583D-03,
     ,   0.2213D-03, 0.3088D-03, 0.4305D-03, 0.5991D-03, 0.8325D-03,
     ,   0.1155D-02, 0.1599D-02, 0.2210D-02, 0.3047D-02, 0.4192D-02,
     ,   0.5753D-02, 0.7874D-02, 0.1075D-01, 0.1462D-01, 0.1981D-01,
     ,   0.2675D-01, 0.3595D-01, 0.4808D-01, 0.6393D-01, 0.8445D-01,
     ,   0.1107D+00, 0.1438D+00, 0.1848D+00, 0.2344D+00, 0.2922D+00,
     ,   0.3562D+00, 0.4214D+00, 0.4769D+00, 0.5029D+00, 0.4651D+00,
     ,   0.3063D+00,-0.6498D-01,-0.7894D+00,-0.2076D+01,-0.4220D+01,
     ,  -0.7629D+01,-0.1285D+02,-0.2063D+02,-0.3208D+02,-0.4893D+02,
     ,  -0.7394D+02,-0.1113D+03,-0.1669D+03,-0.2492D+03,-0.3697D+03,
     ,  -0.5443D+03,-0.7959D+03,-0.1157D+04,-0.1675D+04,-0.2417D+04,
     ,  -0.3483D+04,-0.5017D+04,-0.7231D+04,-0.1043D+05,-0.1508D+05,
     ,  -0.2183D+05,-0.3166D+05,-0.4600D+05/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.9186D-06, 0.1301D-05, 0.1843D-05, 0.2607D-05, 0.3686D-05,
     ,   0.5207D-05, 0.7350D-05, 0.1037D-04, 0.1461D-04, 0.2057D-04,
     ,   0.2893D-04, 0.4066D-04, 0.5707D-04, 0.8002D-04, 0.1121D-03,
     ,   0.1568D-03, 0.2190D-03, 0.3055D-03, 0.4256D-03, 0.5920D-03,
     ,   0.8220D-03, 0.1139D-02, 0.1576D-02, 0.2176D-02, 0.2998D-02,
     ,   0.4120D-02, 0.5648D-02, 0.7719D-02, 0.1052D-01, 0.1428D-01,
     ,   0.1932D-01, 0.2603D-01, 0.3489D-01, 0.4652D-01, 0.6165D-01,
     ,   0.8110D-01, 0.1058D+00, 0.1366D+00, 0.1742D+00, 0.2188D+00,
     ,   0.2693D+00, 0.3227D+00, 0.3722D+00, 0.4049D+00, 0.3978D+00,
     ,   0.3118D+00, 0.8319D-01,-0.3882D+00,-0.1255D+01,-0.2742D+01,
     ,  -0.5167D+01,-0.8963D+01,-0.1471D+02,-0.2323D+02,-0.3573D+02,
     ,  -0.5413D+02,-0.8151D+02,-0.1226D+03,-0.1840D+03,-0.2754D+03,
     ,  -0.4099D+03,-0.6060D+03,-0.8901D+03,-0.1300D+04,-0.1891D+04,
     ,  -0.2741D+04,-0.3966D+04,-0.5735D+04,-0.8293D+04,-0.1200D+05,
     ,  -0.1739D+05,-0.2524D+05,-0.3668D+05/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.6445D-06, 0.9136D-06, 0.1294D-05, 0.1832D-05, 0.2591D-05,
     ,   0.3662D-05, 0.5172D-05, 0.7300D-05, 0.1029D-04, 0.1450D-04,
     ,   0.2041D-04, 0.2870D-04, 0.4031D-04, 0.5656D-04, 0.7927D-04,
     ,   0.1110D-03, 0.1552D-03, 0.2166D-03, 0.3020D-03, 0.4205D-03,
     ,   0.5844D-03, 0.8109D-03, 0.1123D-02, 0.1552D-02, 0.2141D-02,
     ,   0.2946D-02, 0.4044D-02, 0.5536D-02, 0.7555D-02, 0.1028D-01,
     ,   0.1393D-01, 0.1880D-01, 0.2526D-01, 0.3377D-01, 0.4488D-01,
     ,   0.5923D-01, 0.7756D-01, 0.1006D+00, 0.1290D+00, 0.1630D+00,
     ,   0.2023D+00, 0.2452D+00, 0.2874D+00, 0.3204D+00, 0.3291D+00,
     ,   0.2870D+00, 0.1501D+00,-0.1519D+00,-0.7288D+00,-0.1746D+01,
     ,  -0.3445D+01,-0.6165D+01,-0.1037D+02,-0.1668D+02,-0.2597D+02,
     ,  -0.3958D+02,-0.5962D+02,-0.8953D+02,-0.1345D+03,-0.2022D+03,
     ,  -0.3033D+03,-0.4527D+03,-0.6718D+03,-0.9906D+03,-0.1453D+04,
     ,  -0.2121D+04,-0.3086D+04,-0.4482D+04,-0.6502D+04,-0.9430D+04,
     ,  -0.1368D+05,-0.1987D+05,-0.2889D+05/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.4519D-06, 0.6409D-06, 0.9082D-06, 0.1286D-05, 0.1820D-05,
     ,   0.2574D-05, 0.3637D-05, 0.5136D-05, 0.7246D-05, 0.1021D-04,
     ,   0.1438D-04, 0.2024D-04, 0.2844D-04, 0.3994D-04, 0.5602D-04,
     ,   0.7848D-04, 0.1098D-03, 0.1534D-03, 0.2141D-03, 0.2983D-03,
     ,   0.4150D-03, 0.5765D-03, 0.7992D-03, 0.1106D-02, 0.1527D-02,
     ,   0.2104D-02, 0.2892D-02, 0.3964D-02, 0.5418D-02, 0.7383D-02,
     ,   0.1002D-01, 0.1356D-01, 0.1826D-01, 0.2446D-01, 0.3259D-01,
     ,   0.4315D-01, 0.5669D-01, 0.7383D-01, 0.9512D-01, 0.1209D+00,
     ,   0.1512D+00, 0.1850D+00, 0.2198D+00, 0.2502D+00, 0.2660D+00,
     ,   0.2494D+00, 0.1705D+00,-0.1983D-01,-0.3991D+00,-0.1087D+01,
     ,  -0.2262D+01,-0.4184D+01,-0.7214D+01,-0.1184D+02,-0.1874D+02,
     ,  -0.2886D+02,-0.4363D+02,-0.6541D+02,-0.9798D+02,-0.1472D+03,
     ,  -0.2214D+03,-0.3328D+03,-0.4982D+03,-0.7416D+03,-0.1097D+04,
     ,  -0.1615D+04,-0.2366D+04,-0.3454D+04,-0.5031D+04,-0.7318D+04,
     ,  -0.1064D+05,-0.1547D+05,-0.2251D+05/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.3167D-06, 0.4493D-06, 0.6370D-06, 0.9025D-06, 0.1278D-05,
     ,   0.1808D-05, 0.2556D-05, 0.3611D-05, 0.5097D-05, 0.7189D-05,
     ,   0.1013D-04, 0.1426D-04, 0.2006D-04, 0.2818D-04, 0.3955D-04,
     ,   0.5545D-04, 0.7764D-04, 0.1086D-03, 0.1516D-03, 0.2115D-03,
     ,   0.2944D-03, 0.4093D-03, 0.5681D-03, 0.7869D-03, 0.1088D-02,
     ,   0.1500D-02, 0.2065D-02, 0.2834D-02, 0.3880D-02, 0.5295D-02,
     ,   0.7201D-02, 0.9758D-02, 0.1317D-01, 0.1768D-01, 0.2362D-01,
     ,   0.3136D-01, 0.4133D-01, 0.5403D-01, 0.6992D-01, 0.8937D-01,
     ,   0.1125D+00, 0.1389D+00, 0.1669D+00, 0.1932D+00, 0.2112D+00,
     ,   0.2088D+00, 0.1658D+00, 0.4827D-01,-0.1980D+00,-0.6582D+00,
     ,  -0.1462D+01,-0.2803D+01,-0.4958D+01,-0.8313D+01,-0.1339D+02,
     ,  -0.2091D+02,-0.3189D+02,-0.4789D+02,-0.7150D+02,-0.1069D+03,
     ,  -0.1605D+03,-0.2417D+03,-0.3639D+03,-0.5462D+03,-0.8154D+03,
     ,  -0.1210D+04,-0.1787D+04,-0.2625D+04,-0.3843D+04,-0.5613D+04,
     ,  -0.8184D+04,-0.1193D+05,-0.1737D+05/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.2218D-06, 0.3148D-06, 0.4465D-06, 0.6329D-06, 0.8966D-06,
     ,   0.1269D-05, 0.1795D-05, 0.2537D-05, 0.3583D-05, 0.5056D-05,
     ,   0.7129D-05, 0.1004D-04, 0.1413D-04, 0.1987D-04, 0.2790D-04,
     ,   0.3914D-04, 0.5485D-04, 0.7676D-04, 0.1073D-03, 0.1497D-03,
     ,   0.2087D-03, 0.2904D-03, 0.4033D-03, 0.5592D-03, 0.7739D-03,
     ,   0.1069D-02, 0.1473D-02, 0.2024D-02, 0.2774D-02, 0.3792D-02,
     ,   0.5165D-02, 0.7011D-02, 0.9479D-02, 0.1276D-01, 0.1708D-01,
     ,   0.2274D-01, 0.3006D-01, 0.3943D-01, 0.5124D-01, 0.6582D-01,
     ,   0.8336D-01, 0.1037D+00, 0.1259D+00, 0.1479D+00, 0.1654D+00,
     ,   0.1703D+00, 0.1490D+00, 0.7827D-01,-0.7961D-01,-0.3845D+00,
     ,  -0.9294D+00,-0.1855D+01,-0.3369D+01,-0.5768D+01,-0.9464D+01,
     ,  -0.1501D+02,-0.2318D+02,-0.3505D+02,-0.5235D+02,-0.7787D+02,
     ,  -0.1162D+03,-0.1744D+03,-0.2630D+03,-0.3967D+03,-0.5968D+03,
     ,  -0.8933D+03,-0.1330D+04,-0.1968D+04,-0.2899D+04,-0.4255D+04,
     ,  -0.6228D+04,-0.9100D+04,-0.1328D+05/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.1553D-06, 0.2205D-06, 0.3129D-06, 0.4436D-06, 0.6287D-06,
     ,   0.8903D-06, 0.1260D-05, 0.1782D-05, 0.2517D-05, 0.3554D-05,
     ,   0.5014D-05, 0.7066D-05, 0.9950D-05, 0.1400D-04, 0.1967D-04,
     ,   0.2761D-04, 0.3872D-04, 0.5422D-04, 0.7584D-04, 0.1059D-03,
     ,   0.1477D-03, 0.2058D-03, 0.2861D-03, 0.3971D-03, 0.5500D-03,
     ,   0.7604D-03, 0.1049D-02, 0.1443D-02, 0.1981D-02, 0.2712D-02,
     ,   0.3700D-02, 0.5030D-02, 0.6813D-02, 0.9187D-02, 0.1233D-01,
     ,   0.1645D-01, 0.2181D-01, 0.2871D-01, 0.3744D-01, 0.4832D-01,
     ,   0.6154D-01, 0.7708D-01, 0.9447D-01, 0.1124D+00, 0.1281D+00,
     ,   0.1363D+00, 0.1277D+00, 0.8656D-01,-0.1312D-01,-0.2132D+00,
     ,  -0.5793D+00,-0.1213D+01,-0.2265D+01,-0.3960D+01,-0.6614D+01,
     ,  -0.1067D+02,-0.1671D+02,-0.2555D+02,-0.3837D+02,-0.5701D+02,
     ,  -0.8455D+02,-0.1260D+03,-0.1891D+03,-0.2854D+03,-0.4312D+03,
     ,  -0.6500D+03,-0.9753D+03,-0.1455D+04,-0.2159D+04,-0.3188D+04,
     ,  -0.4689D+04,-0.6877D+04,-0.1007D+05/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.1087D-06, 0.1543D-06, 0.2191D-06, 0.3108D-06, 0.4406D-06,
     ,   0.6242D-06, 0.8838D-06, 0.1250D-05, 0.1768D-05, 0.2497D-05,
     ,   0.3524D-05, 0.4969D-05, 0.7001D-05, 0.9854D-05, 0.1386D-04,
     ,   0.1946D-04, 0.2731D-04, 0.3827D-04, 0.5357D-04, 0.7488D-04,
     ,   0.1045D-03, 0.1457D-03, 0.2027D-03, 0.2816D-03, 0.3905D-03,
     ,   0.5404D-03, 0.7463D-03, 0.1028D-02, 0.1413D-02, 0.1937D-02,
     ,   0.2646D-02, 0.3604D-02, 0.4889D-02, 0.6606D-02, 0.8883D-02,
     ,   0.1188D-01, 0.1580D-01, 0.2085D-01, 0.2730D-01, 0.3537D-01,
     ,   0.4528D-01, 0.5708D-01, 0.7053D-01, 0.8485D-01, 0.9829D-01,
     ,   0.1074D+00, 0.1059D+00, 0.8324D-01, 0.2145D-01,-0.1084D+00,
     ,  -0.3524D+00,-0.7823D+00,-0.1508D+01,-0.2693D+01,-0.4577D+01,
     ,  -0.7497D+01,-0.1192D+02,-0.1847D+02,-0.2802D+02,-0.4182D+02,
     ,  -0.6188D+02,-0.9152D+02,-0.1362D+03,-0.2044D+03,-0.3088D+03,
     ,  -0.4673D+03,-0.7058D+03,-0.1061D+04,-0.1587D+04,-0.2360D+04,
     ,  -0.3491D+04,-0.5145D+04,-0.7559D+04/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.7601D-07, 0.1080D-06, 0.1533D-06, 0.2176D-06, 0.3086D-06,
     ,   0.4375D-06, 0.6196D-06, 0.8770D-06, 0.1240D-05, 0.1753D-05,
     ,   0.2475D-05, 0.3492D-05, 0.4923D-05, 0.6933D-05, 0.9754D-05,
     ,   0.1371D-04, 0.1925D-04, 0.2699D-04, 0.3781D-04, 0.5289D-04,
     ,   0.7388D-04, 0.1031D-03, 0.1435D-03, 0.1996D-03, 0.2770D-03,
     ,   0.3837D-03, 0.5304D-03, 0.7316D-03, 0.1007D-02, 0.1381D-02,
     ,   0.1890D-02, 0.2578D-02, 0.3503D-02, 0.4742D-02, 0.6390D-02,
     ,   0.8567D-02, 0.1142D-01, 0.1512D-01, 0.1985D-01, 0.2583D-01,
     ,   0.3322D-01, 0.4211D-01, 0.5243D-01, 0.6371D-01, 0.7485D-01,
     ,   0.8361D-01, 0.8586D-01, 0.7437D-01, 0.3697D-01,-0.4633D-01,
     ,  -0.2076D+00,-0.4973D+00,-0.9937D+00,-0.1815D+01,-0.3138D+01,
     ,  -0.5218D+01,-0.8415D+01,-0.1322D+02,-0.2031D+02,-0.3059D+02,
     ,  -0.4542D+02,-0.6694D+02,-0.9878D+02,-0.1469D+03,-0.2205D+03,
     ,  -0.3333D+03,-0.5051D+03,-0.7643D+03,-0.1151D+04,-0.1725D+04,
     ,  -0.2570D+04,-0.3809D+04,-0.5623D+04/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.5314D-07, 0.7552D-07, 0.1073D-06, 0.1523D-06, 0.2161D-06,
     ,   0.3064D-06, 0.4342D-06, 0.6148D-06, 0.8699D-06, 0.1230D-05,
     ,   0.1738D-05, 0.2453D-05, 0.3459D-05, 0.4874D-05, 0.6862D-05,
     ,   0.9650D-05, 0.1356D-04, 0.1902D-04, 0.2666D-04, 0.3732D-04,
     ,   0.5218D-04, 0.7284D-04, 0.1015D-03, 0.1413D-03, 0.1963D-03,
     ,   0.2722D-03, 0.3766D-03, 0.5200D-03, 0.7164D-03, 0.9843D-03,
     ,   0.1349D-02, 0.1842D-02, 0.2507D-02, 0.3399D-02, 0.4589D-02,
     ,   0.6166D-02, 0.8238D-02, 0.1093D-01, 0.1441D-01, 0.1881D-01,
     ,   0.2430D-01, 0.3097D-01, 0.3882D-01, 0.4760D-01, 0.5663D-01,
     ,   0.6445D-01, 0.6836D-01, 0.6348D-01, 0.4156D-01,-0.1112D-01,
     ,  -0.1168D+00,-0.3106D+00,-0.6479D+00,-0.1213D+01,-0.2135D+01,
     ,  -0.3601D+01,-0.5885D+01,-0.9369D+01,-0.1458D+02,-0.2222D+02,
     ,  -0.3326D+02,-0.4916D+02,-0.7222D+02,-0.1063D+03,-0.1580D+03,
     ,  -0.2372D+03,-0.3588D+03,-0.5446D+03,-0.8253D+03,-0.1245D+04,
     ,  -0.1869D+04,-0.2790D+04,-0.4142D+04/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.3713D-07, 0.5279D-07, 0.7502D-07, 0.1065D-06, 0.1512D-06,
     ,   0.2145D-06, 0.3041D-06, 0.4308D-06, 0.6098D-06, 0.8625D-06,
     ,   0.1219D-05, 0.1722D-05, 0.2430D-05, 0.3425D-05, 0.4824D-05,
     ,   0.6788D-05, 0.9542D-05, 0.1340D-04, 0.1879D-04, 0.2632D-04,
     ,   0.3682D-04, 0.5144D-04, 0.7176D-04, 0.9994D-04, 0.1390D-03,
     ,   0.1929D-03, 0.2671D-03, 0.3693D-03, 0.5092D-03, 0.7005D-03,
     ,   0.9610D-03, 0.1314D-02, 0.1792D-02, 0.2434D-02, 0.3291D-02,
     ,   0.4431D-02, 0.5933D-02, 0.7896D-02, 0.1043D-01, 0.1367D-01,
     ,   0.1773D-01, 0.2271D-01, 0.2865D-01, 0.3541D-01, 0.4259D-01,
     ,   0.4927D-01, 0.5367D-01, 0.5253D-01, 0.4027D-01, 0.7515D-02,
     ,  -0.6102D-01,-0.1898D+00,-0.4176D+00,-0.8042D+00,-0.1441D+01,
     ,  -0.2466D+01,-0.4081D+01,-0.6576D+01,-0.1036D+02,-0.1598D+02,
     ,  -0.2420D+02,-0.3604D+02,-0.5304D+02,-0.7769D+02,-0.1142D+03,
     ,  -0.1695D+03,-0.2545D+03,-0.3854D+03,-0.5857D+03,-0.8889D+03,
     ,  -0.1344D+04,-0.2020D+04,-0.3019D+04/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.2594D-07, 0.3689D-07, 0.5244D-07, 0.7450D-07, 0.1058D-06,
     ,   0.1501D-06, 0.2129D-06, 0.3017D-06, 0.4272D-06, 0.6046D-06,
     ,   0.8549D-06, 0.1208D-05, 0.1705D-05, 0.2405D-05, 0.3390D-05,
     ,   0.4772D-05, 0.6712D-05, 0.9430D-05, 0.1323D-04, 0.1855D-04,
     ,   0.2597D-04, 0.3630D-04, 0.5068D-04, 0.7064D-04, 0.9830D-04,
     ,   0.1365D-03, 0.1893D-03, 0.2619D-03, 0.3616D-03, 0.4980D-03,
     ,   0.6841D-03, 0.9369D-03, 0.1279D-02, 0.1740D-02, 0.2357D-02,
     ,   0.3180D-02, 0.4267D-02, 0.5692D-02, 0.7542D-02, 0.9914D-02,
     ,   0.1291D-01, 0.1661D-01, 0.2107D-01, 0.2624D-01, 0.3187D-01,
     ,   0.3740D-01, 0.4165D-01, 0.4248D-01, 0.3612D-01, 0.1620D-01,
     ,  -0.2777D-01,-0.1127D+00,-0.2656D+00,-0.5284D+00,-0.9661D+00,
     ,  -0.1677D+01,-0.2809D+01,-0.4578D+01,-0.7293D+01,-0.1139D+02,
     ,  -0.1744D+02,-0.2625D+02,-0.3892D+02,-0.5706D+02,-0.8337D+02,
     ,  -0.1224D+03,-0.1815D+03,-0.2726D+03,-0.4131D+03,-0.6284D+03,
     ,  -0.9551D+03,-0.1446D+04,-0.2177D+04/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1811D-07, 0.2577D-07, 0.3664D-07, 0.5207D-07, 0.7397D-07,
     ,   0.1050D-06, 0.1490D-06, 0.2112D-06, 0.2992D-06, 0.4236D-06,
     ,   0.5992D-06, 0.8470D-06, 0.1196D-05, 0.1688D-05, 0.2380D-05,
     ,   0.3353D-05, 0.4719D-05, 0.6633D-05, 0.9314D-05, 0.1306D-04,
     ,   0.1830D-04, 0.2560D-04, 0.3577D-04, 0.4989D-04, 0.6948D-04,
     ,   0.9660D-04, 0.1341D-03, 0.1857D-03, 0.2566D-03, 0.3537D-03,
     ,   0.4865D-03, 0.6671D-03, 0.9119D-03, 0.1242D-02, 0.1686D-02,
     ,   0.2278D-02, 0.3064D-02, 0.4097D-02, 0.5443D-02, 0.7176D-02,
     ,   0.9377D-02, 0.1212D-01, 0.1545D-01, 0.1937D-01, 0.2374D-01,
     ,   0.2821D-01, 0.3202D-01, 0.3376D-01, 0.3091D-01, 0.1914D-01,
     ,  -0.8704D-02,-0.6429D-01,-0.1663D+00,-0.3440D+00,-0.6431D+00,
     ,  -0.1134D+01,-0.1922D+01,-0.3165D+01,-0.5093D+01,-0.8035D+01,
     ,  -0.1245D+02,-0.1895D+02,-0.2838D+02,-0.4189D+02,-0.6123D+02,
     ,  -0.8925D+02,-0.1308D+03,-0.1939D+03,-0.2913D+03,-0.4418D+03,
     ,  -0.6728D+03,-0.1024D+04,-0.1552D+04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine chqps22cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.2363D-06, 0.3469D-06, 0.5092D-06, 0.7474D-06, 0.1097D-05,
     ,   0.1610D-05, 0.2363D-05, 0.3469D-05, 0.5092D-05, 0.7474D-05,
     ,   0.1097D-04, 0.1610D-04, 0.2363D-04, 0.3469D-04, 0.5092D-04,
     ,   0.7473D-04, 0.1097D-03, 0.1610D-03, 0.2363D-03, 0.3468D-03,
     ,   0.5090D-03, 0.7470D-03, 0.1096D-02, 0.1608D-02, 0.2359D-02,
     ,   0.3460D-02, 0.5072D-02, 0.7432D-02, 0.1088D-01, 0.1591D-01,
     ,   0.2323D-01, 0.3383D-01, 0.4911D-01, 0.7098D-01, 0.1020D+00,
     ,   0.1455D+00, 0.2061D+00, 0.2901D+00, 0.4075D+00, 0.5760D+00,
     ,   0.8280D+00, 0.1221D+01, 0.1850D+01, 0.2863D+01, 0.4483D+01,
     ,   0.7037D+01, 0.1100D+02, 0.1709D+02, 0.2632D+02, 0.4020D+02,
     ,   0.6093D+02, 0.9176D+02, 0.1374D+03, 0.2049D+03, 0.3043D+03,
     ,   0.4507D+03, 0.6661D+03, 0.9827D+03, 0.1448D+04, 0.2131D+04,
     ,   0.3134D+04, 0.4607D+04, 0.6770D+04, 0.9945D+04, 0.1461D+05,
     ,   0.2145D+05, 0.3149D+05, 0.4623D+05, 0.6787D+05, 0.9962D+05,
     ,   0.1462D+06, 0.2147D+06, 0.3151D+06/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1707D-06, 0.2505D-06, 0.3677D-06, 0.5397D-06, 0.7921D-06,
     ,   0.1163D-05, 0.1707D-05, 0.2505D-05, 0.3677D-05, 0.5397D-05,
     ,   0.7921D-05, 0.1163D-04, 0.1707D-04, 0.2505D-04, 0.3677D-04,
     ,   0.5396D-04, 0.7921D-04, 0.1163D-03, 0.1706D-03, 0.2504D-03,
     ,   0.3676D-03, 0.5394D-03, 0.7917D-03, 0.1162D-02, 0.1704D-02,
     ,   0.2500D-02, 0.3667D-02, 0.5375D-02, 0.7875D-02, 0.1153D-01,
     ,   0.1685D-01, 0.2460D-01, 0.3581D-01, 0.5195D-01, 0.7502D-01,
     ,   0.1077D+00, 0.1535D+00, 0.2171D+00, 0.3054D+00, 0.4291D+00,
     ,   0.6077D+00, 0.8766D+00, 0.1298D+01, 0.1974D+01, 0.3063D+01,
     ,   0.4800D+01, 0.7533D+01, 0.1177D+02, 0.1825D+02, 0.2808D+02,
     ,   0.4283D+02, 0.6486D+02, 0.9759D+02, 0.1460D+03, 0.2176D+03,
     ,   0.3230D+03, 0.4783D+03, 0.7066D+03, 0.1042D+04, 0.1535D+04,
     ,   0.2259D+04, 0.3323D+04, 0.4884D+04, 0.7177D+04, 0.1054D+05,
     ,   0.1548D+05, 0.2273D+05, 0.3338D+05, 0.4900D+05, 0.7193D+05,
     ,   0.1056D+06, 0.1550D+06, 0.2275D+06/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.1212D-06, 0.1779D-06, 0.2611D-06, 0.3833D-06, 0.5626D-06,
     ,   0.8258D-06, 0.1212D-05, 0.1779D-05, 0.2611D-05, 0.3833D-05,
     ,   0.5626D-05, 0.8258D-05, 0.1212D-04, 0.1779D-04, 0.2611D-04,
     ,   0.3833D-04, 0.5626D-04, 0.8258D-04, 0.1212D-03, 0.1779D-03,
     ,   0.2611D-03, 0.3832D-03, 0.5624D-03, 0.8253D-03, 0.1211D-02,
     ,   0.1777D-02, 0.2606D-02, 0.3822D-02, 0.5603D-02, 0.8208D-02,
     ,   0.1201D-01, 0.1756D-01, 0.2562D-01, 0.3729D-01, 0.5408D-01,
     ,   0.7805D-01, 0.1120D+00, 0.1594D+00, 0.2254D+00, 0.3169D+00,
     ,   0.4454D+00, 0.6317D+00, 0.9135D+00, 0.1357D+01, 0.2069D+01,
     ,   0.3215D+01, 0.5041D+01, 0.7909D+01, 0.1235D+02, 0.1913D+02,
     ,   0.2940D+02, 0.4482D+02, 0.6782D+02, 0.1020D+03, 0.1525D+03,
     ,   0.2272D+03, 0.3371D+03, 0.4990D+03, 0.7371D+03, 0.1087D+04,
     ,   0.1601D+04, 0.2356D+04, 0.3465D+04, 0.5093D+04, 0.7482D+04,
     ,   0.1099D+05, 0.1614D+05, 0.2370D+05, 0.3480D+05, 0.5108D+05,
     ,   0.7499D+05, 0.1101D+06, 0.1616D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.8504D-07, 0.1248D-06, 0.1832D-06, 0.2689D-06, 0.3947D-06,
     ,   0.5794D-06, 0.8504D-06, 0.1248D-05, 0.1832D-05, 0.2689D-05,
     ,   0.3947D-05, 0.5794D-05, 0.8504D-05, 0.1248D-04, 0.1832D-04,
     ,   0.2689D-04, 0.3947D-04, 0.5794D-04, 0.8504D-04, 0.1248D-03,
     ,   0.1832D-03, 0.2689D-03, 0.3946D-03, 0.5792D-03, 0.8499D-03,
     ,   0.1247D-02, 0.1830D-02, 0.2684D-02, 0.3936D-02, 0.5769D-02,
     ,   0.8451D-02, 0.1237D-01, 0.1808D-01, 0.2637D-01, 0.3837D-01,
     ,   0.5563D-01, 0.8025D-01, 0.1151D+00, 0.1638D+00, 0.2314D+00,
     ,   0.3252D+00, 0.4573D+00, 0.6493D+00, 0.9407D+00, 0.1400D+01,
     ,   0.2139D+01, 0.3327D+01, 0.5219D+01, 0.8185D+01, 0.1277D+02,
     ,   0.1978D+02, 0.3038D+02, 0.4628D+02, 0.6999D+02, 0.1052D+03,
     ,   0.1573D+03, 0.2342D+03, 0.3475D+03, 0.5142D+03, 0.7594D+03,
     ,   0.1120D+04, 0.1649D+04, 0.2427D+04, 0.3569D+04, 0.5245D+04,
     ,   0.7706D+04, 0.1132D+05, 0.1662D+05, 0.2441D+05, 0.3583D+05,
     ,   0.5261D+05, 0.7723D+05, 0.1134D+06/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.5914D-07, 0.8681D-07, 0.1274D-06, 0.1870D-06, 0.2745D-06,
     ,   0.4029D-06, 0.5914D-06, 0.8681D-06, 0.1274D-05, 0.1870D-05,
     ,   0.2745D-05, 0.4029D-05, 0.5914D-05, 0.8681D-05, 0.1274D-04,
     ,   0.1870D-04, 0.2745D-04, 0.4029D-04, 0.5914D-04, 0.8680D-04,
     ,   0.1274D-03, 0.1870D-03, 0.2745D-03, 0.4028D-03, 0.5912D-03,
     ,   0.8675D-03, 0.1273D-02, 0.1868D-02, 0.2740D-02, 0.4017D-02,
     ,   0.5888D-02, 0.8625D-02, 0.1262D-01, 0.1845D-01, 0.2691D-01,
     ,   0.3915D-01, 0.5674D-01, 0.8183D-01, 0.1173D+00, 0.1669D+00,
     ,   0.2357D+00, 0.3312D+00, 0.4658D+00, 0.6619D+00, 0.9602D+00,
     ,   0.1431D+01, 0.2189D+01, 0.3408D+01, 0.5346D+01, 0.8384D+01,
     ,   0.1308D+02, 0.2024D+02, 0.3108D+02, 0.4732D+02, 0.7154D+02,
     ,   0.1075D+03, 0.1607D+03, 0.2392D+03, 0.3548D+03, 0.5251D+03,
     ,   0.7754D+03, 0.1143D+04, 0.1684D+04, 0.2477D+04, 0.3643D+04,
     ,   0.5354D+04, 0.7866D+04, 0.1155D+05, 0.1697D+05, 0.2491D+05,
     ,   0.3658D+05, 0.5370D+05, 0.7883D+05/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.4087D-07, 0.5999D-07, 0.8805D-07, 0.1292D-06, 0.1897D-06,
     ,   0.2785D-06, 0.4087D-06, 0.5999D-06, 0.8805D-06, 0.1292D-05,
     ,   0.1897D-05, 0.2785D-05, 0.4087D-05, 0.5999D-05, 0.8805D-05,
     ,   0.1292D-04, 0.1897D-04, 0.2784D-04, 0.4087D-04, 0.5999D-04,
     ,   0.8805D-04, 0.1292D-03, 0.1897D-03, 0.2784D-03, 0.4086D-03,
     ,   0.5996D-03, 0.8800D-03, 0.1291D-02, 0.1894D-02, 0.2779D-02,
     ,   0.4075D-02, 0.5972D-02, 0.8748D-02, 0.1280D-01, 0.1871D-01,
     ,   0.2729D-01, 0.3969D-01, 0.5752D-01, 0.8294D-01, 0.1188D+00,
     ,   0.1690D+00, 0.2387D+00, 0.3354D+00, 0.4718D+00, 0.6708D+00,
     ,   0.9741D+00, 0.1454D+01, 0.2225D+01, 0.3465D+01, 0.5436D+01,
     ,   0.8524D+01, 0.1329D+02, 0.2057D+02, 0.3157D+02, 0.4806D+02,
     ,   0.7264D+02, 0.1091D+03, 0.1631D+03, 0.2427D+03, 0.3600D+03,
     ,   0.5327D+03, 0.7867D+03, 0.1160D+04, 0.1708D+04, 0.2513D+04,
     ,   0.3695D+04, 0.5431D+04, 0.7979D+04, 0.1172D+05, 0.1721D+05,
     ,   0.2527D+05, 0.3710D+05, 0.5447D+05/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.2812D-07, 0.4127D-07, 0.6058D-07, 0.8892D-07, 0.1305D-06,
     ,   0.1916D-06, 0.2812D-06, 0.4127D-06, 0.6058D-06, 0.8892D-06,
     ,   0.1305D-05, 0.1916D-05, 0.2812D-05, 0.4127D-05, 0.6058D-05,
     ,   0.8892D-05, 0.1305D-04, 0.1916D-04, 0.2812D-04, 0.4127D-04,
     ,   0.6058D-04, 0.8892D-04, 0.1305D-03, 0.1916D-03, 0.2811D-03,
     ,   0.4126D-03, 0.6056D-03, 0.8886D-03, 0.1304D-02, 0.1913D-02,
     ,   0.2806D-02, 0.4115D-02, 0.6031D-02, 0.8834D-02, 0.1293D-01,
     ,   0.1889D-01, 0.2755D-01, 0.4007D-01, 0.5806D-01, 0.8371D-01,
     ,   0.1199D+00, 0.1705D+00, 0.2408D+00, 0.3383D+00, 0.4760D+00,
     ,   0.6770D+00, 0.9838D+00, 0.1469D+01, 0.2250D+01, 0.3505D+01,
     ,   0.5500D+01, 0.8623D+01, 0.1344D+02, 0.2080D+02, 0.3191D+02,
     ,   0.4857D+02, 0.7340D+02, 0.1102D+03, 0.1648D+03, 0.2452D+03,
     ,   0.3637D+03, 0.5381D+03, 0.7945D+03, 0.1171D+04, 0.1725D+04,
     ,   0.2538D+04, 0.3732D+04, 0.5485D+04, 0.8058D+04, 0.1184D+05,
     ,   0.1738D+05, 0.2552D+05, 0.3747D+05/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1929D-07, 0.2831D-07, 0.4155D-07, 0.6099D-07, 0.8952D-07,
     ,   0.1314D-06, 0.1929D-06, 0.2831D-06, 0.4155D-06, 0.6099D-06,
     ,   0.8952D-06, 0.1314D-05, 0.1929D-05, 0.2831D-05, 0.4155D-05,
     ,   0.6099D-05, 0.8952D-05, 0.1314D-04, 0.1929D-04, 0.2831D-04,
     ,   0.4155D-04, 0.6099D-04, 0.8952D-04, 0.1314D-03, 0.1928D-03,
     ,   0.2830D-03, 0.4154D-03, 0.6096D-03, 0.8946D-03, 0.1313D-02,
     ,   0.1926D-02, 0.2825D-02, 0.4143D-02, 0.6072D-02, 0.8893D-02,
     ,   0.1301D-01, 0.1902D-01, 0.2773D-01, 0.4034D-01, 0.5844D-01,
     ,   0.8425D-01, 0.1207D+00, 0.1716D+00, 0.2422D+00, 0.3403D+00,
     ,   0.4789D+00, 0.6813D+00, 0.9905D+00, 0.1480D+01, 0.2267D+01,
     ,   0.3533D+01, 0.5543D+01, 0.8691D+01, 0.1355D+02, 0.2096D+02,
     ,   0.3215D+02, 0.4893D+02, 0.7393D+02, 0.1110D+03, 0.1659D+03,
     ,   0.2469D+03, 0.3662D+03, 0.5418D+03, 0.8000D+03, 0.1179D+04,
     ,   0.1737D+04, 0.2555D+04, 0.3757D+04, 0.5522D+04, 0.8113D+04,
     ,   0.1192D+05, 0.1750D+05, 0.2569D+05/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1320D-07, 0.1938D-07, 0.2844D-07, 0.4175D-07, 0.6128D-07,
     ,   0.8994D-07, 0.1320D-06, 0.1938D-06, 0.2844D-06, 0.4175D-06,
     ,   0.6128D-06, 0.8994D-06, 0.1320D-05, 0.1938D-05, 0.2844D-05,
     ,   0.4175D-05, 0.6127D-05, 0.8994D-05, 0.1320D-04, 0.1938D-04,
     ,   0.2844D-04, 0.4174D-04, 0.6127D-04, 0.8993D-04, 0.1320D-03,
     ,   0.1937D-03, 0.2844D-03, 0.4173D-03, 0.6125D-03, 0.8988D-03,
     ,   0.1319D-02, 0.1935D-02, 0.2838D-02, 0.4162D-02, 0.6100D-02,
     ,   0.8934D-02, 0.1307D-01, 0.1910D-01, 0.2786D-01, 0.4052D-01,
     ,   0.5870D-01, 0.8462D-01, 0.1212D+00, 0.1723D+00, 0.2432D+00,
     ,   0.3417D+00, 0.4809D+00, 0.6843D+00, 0.9951D+00, 0.1487D+01,
     ,   0.2279D+01, 0.3552D+01, 0.5573D+01, 0.8738D+01, 0.1362D+02,
     ,   0.2107D+02, 0.3232D+02, 0.4918D+02, 0.7430D+02, 0.1116D+03,
     ,   0.1667D+03, 0.2481D+03, 0.3679D+03, 0.5443D+03, 0.8037D+03,
     ,   0.1185D+04, 0.1745D+04, 0.2567D+04, 0.3775D+04, 0.5548D+04,
     ,   0.8151D+04, 0.1197D+05, 0.1758D+05/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.9022D-08, 0.1324D-07, 0.1944D-07, 0.2853D-07, 0.4188D-07,
     ,   0.6147D-07, 0.9022D-07, 0.1324D-06, 0.1944D-06, 0.2853D-06,
     ,   0.4188D-06, 0.6147D-06, 0.9022D-06, 0.1324D-05, 0.1944D-05,
     ,   0.2853D-05, 0.4188D-05, 0.6147D-05, 0.9022D-05, 0.1324D-04,
     ,   0.1944D-04, 0.2853D-04, 0.4188D-04, 0.6147D-04, 0.9022D-04,
     ,   0.1324D-03, 0.1944D-03, 0.2853D-03, 0.4187D-03, 0.6144D-03,
     ,   0.9016D-03, 0.1323D-02, 0.1941D-02, 0.2847D-02, 0.4175D-02,
     ,   0.6119D-02, 0.8962D-02, 0.1311D-01, 0.1916D-01, 0.2795D-01,
     ,   0.4064D-01, 0.5888D-01, 0.8487D-01, 0.1215D+00, 0.1728D+00,
     ,   0.2439D+00, 0.3427D+00, 0.4822D+00, 0.6864D+00, 0.9983D+00,
     ,   0.1492D+01, 0.2287D+01, 0.3565D+01, 0.5594D+01, 0.8770D+01,
     ,   0.1367D+02, 0.2114D+02, 0.3243D+02, 0.4934D+02, 0.7455D+02,
     ,   0.1119D+03, 0.1673D+03, 0.2489D+03, 0.3691D+03, 0.5461D+03,
     ,   0.8063D+03, 0.1189D+04, 0.1750D+04, 0.2575D+04, 0.3787D+04,
     ,   0.5565D+04, 0.8176D+04, 0.1201D+05/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.6160D-08, 0.9042D-08, 0.1327D-07, 0.1948D-07, 0.2859D-07,
     ,   0.4197D-07, 0.6160D-07, 0.9042D-07, 0.1327D-06, 0.1948D-06,
     ,   0.2859D-06, 0.4197D-06, 0.6160D-06, 0.9042D-06, 0.1327D-05,
     ,   0.1948D-05, 0.2859D-05, 0.4197D-05, 0.6160D-05, 0.9042D-05,
     ,   0.1327D-04, 0.1948D-04, 0.2859D-04, 0.4197D-04, 0.6160D-04,
     ,   0.9041D-04, 0.1327D-03, 0.1948D-03, 0.2859D-03, 0.4196D-03,
     ,   0.6157D-03, 0.9036D-03, 0.1326D-02, 0.1945D-02, 0.2853D-02,
     ,   0.4184D-02, 0.6132D-02, 0.8981D-02, 0.1314D-01, 0.1920D-01,
     ,   0.2801D-01, 0.4073D-01, 0.5900D-01, 0.8504D-01, 0.1218D+00,
     ,   0.1731D+00, 0.2444D+00, 0.3433D+00, 0.4832D+00, 0.6878D+00,
     ,   0.1000D+01, 0.1496D+01, 0.2293D+01, 0.3574D+01, 0.5608D+01,
     ,   0.8792D+01, 0.1370D+02, 0.2119D+02, 0.3251D+02, 0.4946D+02,
     ,   0.7472D+02, 0.1122D+03, 0.1676D+03, 0.2494D+03, 0.3700D+03,
     ,   0.5473D+03, 0.8081D+03, 0.1191D+04, 0.1754D+04, 0.2581D+04,
     ,   0.3795D+04, 0.5577D+04, 0.8194D+04/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.4203D-08, 0.6169D-08, 0.9055D-08, 0.1329D-07, 0.1951D-07,
     ,   0.2864D-07, 0.4203D-07, 0.6169D-07, 0.9055D-07, 0.1329D-06,
     ,   0.1951D-06, 0.2864D-06, 0.4203D-06, 0.6169D-06, 0.9055D-06,
     ,   0.1329D-05, 0.1951D-05, 0.2864D-05, 0.4203D-05, 0.6169D-05,
     ,   0.9055D-05, 0.1329D-04, 0.1951D-04, 0.2863D-04, 0.4203D-04,
     ,   0.6169D-04, 0.9055D-04, 0.1329D-03, 0.1951D-03, 0.2863D-03,
     ,   0.4202D-03, 0.6166D-03, 0.9049D-03, 0.1328D-02, 0.1948D-02,
     ,   0.2857D-02, 0.4190D-02, 0.6141D-02, 0.8995D-02, 0.1316D-01,
     ,   0.1923D-01, 0.2805D-01, 0.4079D-01, 0.5909D-01, 0.8516D-01,
     ,   0.1220D+00, 0.1734D+00, 0.2447D+00, 0.3438D+00, 0.4838D+00,
     ,   0.6887D+00, 0.1002D+01, 0.1498D+01, 0.2297D+01, 0.3580D+01,
     ,   0.5618D+01, 0.8807D+01, 0.1373D+02, 0.2123D+02, 0.3256D+02,
     ,   0.4954D+02, 0.7484D+02, 0.1124D+03, 0.1679D+03, 0.2498D+03,
     ,   0.3705D+03, 0.5481D+03, 0.8093D+03, 0.1193D+04, 0.1757D+04,
     ,   0.2585D+04, 0.3801D+04, 0.5586D+04/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.2866D-08, 0.4207D-08, 0.6175D-08, 0.9064D-08, 0.1330D-07,
     ,   0.1953D-07, 0.2866D-07, 0.4207D-07, 0.6175D-07, 0.9064D-07,
     ,   0.1330D-06, 0.1953D-06, 0.2866D-06, 0.4207D-06, 0.6175D-06,
     ,   0.9064D-06, 0.1330D-05, 0.1953D-05, 0.2866D-05, 0.4207D-05,
     ,   0.6175D-05, 0.9064D-05, 0.1330D-04, 0.1953D-04, 0.2866D-04,
     ,   0.4207D-04, 0.6175D-04, 0.9064D-04, 0.1330D-03, 0.1953D-03,
     ,   0.2866D-03, 0.4206D-03, 0.6173D-03, 0.9058D-03, 0.1329D-02,
     ,   0.1950D-02, 0.2860D-02, 0.4194D-02, 0.6147D-02, 0.9004D-02,
     ,   0.1317D-01, 0.1925D-01, 0.2807D-01, 0.4083D-01, 0.5914D-01,
     ,   0.8524D-01, 0.1221D+00, 0.1735D+00, 0.2449D+00, 0.3441D+00,
     ,   0.4842D+00, 0.6894D+00, 0.1003D+01, 0.1500D+01, 0.2300D+01,
     ,   0.3584D+01, 0.5625D+01, 0.8817D+01, 0.1374D+02, 0.2125D+02,
     ,   0.3260D+02, 0.4959D+02, 0.7492D+02, 0.1125D+03, 0.1681D+03,
     ,   0.2501D+03, 0.3709D+03, 0.5487D+03, 0.8101D+03, 0.1194D+04,
     ,   0.1759D+04, 0.2587D+04, 0.3805D+04/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1954D-08, 0.2868D-08, 0.4210D-08, 0.6180D-08, 0.9071D-08,
     ,   0.1331D-07, 0.1954D-07, 0.2868D-07, 0.4210D-07, 0.6180D-07,
     ,   0.9071D-07, 0.1331D-06, 0.1954D-06, 0.2868D-06, 0.4210D-06,
     ,   0.6180D-06, 0.9071D-06, 0.1331D-05, 0.1954D-05, 0.2868D-05,
     ,   0.4210D-05, 0.6180D-05, 0.9071D-05, 0.1331D-04, 0.1954D-04,
     ,   0.2868D-04, 0.4210D-04, 0.6179D-04, 0.9070D-04, 0.1331D-03,
     ,   0.1954D-03, 0.2868D-03, 0.4209D-03, 0.6177D-03, 0.9064D-03,
     ,   0.1330D-02, 0.1951D-02, 0.2862D-02, 0.4197D-02, 0.6151D-02,
     ,   0.9010D-02, 0.1318D-01, 0.1926D-01, 0.2809D-01, 0.4085D-01,
     ,   0.5918D-01, 0.8530D-01, 0.1221D+00, 0.1736D+00, 0.2451D+00,
     ,   0.3443D+00, 0.4845D+00, 0.6898D+00, 0.1004D+01, 0.1501D+01,
     ,   0.2301D+01, 0.3587D+01, 0.5629D+01, 0.8824D+01, 0.1375D+02,
     ,   0.2127D+02, 0.3262D+02, 0.4963D+02, 0.7497D+02, 0.1126D+03,
     ,   0.1682D+03, 0.2503D+03, 0.3712D+03, 0.5491D+03, 0.8107D+03,
     ,   0.1195D+04, 0.1760D+04, 0.2589D+04/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1332D-08, 0.1955D-08, 0.2870D-08, 0.4212D-08, 0.6183D-08,
     ,   0.9075D-08, 0.1332D-07, 0.1955D-07, 0.2870D-07, 0.4212D-07,
     ,   0.6183D-07, 0.9075D-07, 0.1332D-06, 0.1955D-06, 0.2870D-06,
     ,   0.4212D-06, 0.6183D-06, 0.9075D-06, 0.1332D-05, 0.1955D-05,
     ,   0.2870D-05, 0.4212D-05, 0.6183D-05, 0.9075D-05, 0.1332D-04,
     ,   0.1955D-04, 0.2870D-04, 0.4212D-04, 0.6182D-04, 0.9074D-04,
     ,   0.1332D-03, 0.1955D-03, 0.2869D-03, 0.4211D-03, 0.6180D-03,
     ,   0.9069D-03, 0.1331D-02, 0.1952D-02, 0.2864D-02, 0.4199D-02,
     ,   0.6154D-02, 0.9014D-02, 0.1319D-01, 0.1927D-01, 0.2811D-01,
     ,   0.4087D-01, 0.5921D-01, 0.8533D-01, 0.1222D+00, 0.1737D+00,
     ,   0.2452D+00, 0.3444D+00, 0.4847D+00, 0.6901D+00, 0.1004D+01,
     ,   0.1502D+01, 0.2303D+01, 0.3589D+01, 0.5632D+01, 0.8829D+01,
     ,   0.1376D+02, 0.2128D+02, 0.3264D+02, 0.4965D+02, 0.7501D+02,
     ,   0.1126D+03, 0.1683D+03, 0.2504D+03, 0.3713D+03, 0.5493D+03,
     ,   0.8110D+03, 0.1196D+04, 0.1761D+04/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.9078D-09, 0.1332D-08, 0.1956D-08, 0.2871D-08, 0.4213D-08,
     ,   0.6185D-08, 0.9078D-08, 0.1332D-07, 0.1956D-07, 0.2871D-07,
     ,   0.4213D-07, 0.6185D-07, 0.9078D-07, 0.1332D-06, 0.1956D-06,
     ,   0.2871D-06, 0.4213D-06, 0.6185D-06, 0.9078D-06, 0.1332D-05,
     ,   0.1956D-05, 0.2871D-05, 0.4213D-05, 0.6185D-05, 0.9078D-05,
     ,   0.1332D-04, 0.1956D-04, 0.2871D-04, 0.4213D-04, 0.6184D-04,
     ,   0.9077D-04, 0.1332D-03, 0.1955D-03, 0.2870D-03, 0.4212D-03,
     ,   0.6182D-03, 0.9072D-03, 0.1331D-02, 0.1953D-02, 0.2864D-02,
     ,   0.4200D-02, 0.6156D-02, 0.9017D-02, 0.1319D-01, 0.1928D-01,
     ,   0.2811D-01, 0.4088D-01, 0.5923D-01, 0.8536D-01, 0.1222D+00,
     ,   0.1738D+00, 0.2452D+00, 0.3445D+00, 0.4849D+00, 0.6903D+00,
     ,   0.1004D+01, 0.1502D+01, 0.2303D+01, 0.3591D+01, 0.5635D+01,
     ,   0.8832D+01, 0.1377D+02, 0.2129D+02, 0.3265D+02, 0.4967D+02,
     ,   0.7504D+02, 0.1127D+03, 0.1683D+03, 0.2505D+03, 0.3715D+03,
     ,   0.5495D+03, 0.8113D+03, 0.1196D+04/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.6186D-09, 0.9080D-09, 0.1333D-08, 0.1956D-08, 0.2871D-08,
     ,   0.4214D-08, 0.6186D-08, 0.9080D-08, 0.1333D-07, 0.1956D-07,
     ,   0.2871D-07, 0.4214D-07, 0.6186D-07, 0.9080D-07, 0.1333D-06,
     ,   0.1956D-06, 0.2871D-06, 0.4214D-06, 0.6186D-06, 0.9080D-06,
     ,   0.1333D-05, 0.1956D-05, 0.2871D-05, 0.4214D-05, 0.6186D-05,
     ,   0.9080D-05, 0.1333D-04, 0.1956D-04, 0.2871D-04, 0.4214D-04,
     ,   0.6186D-04, 0.9079D-04, 0.1333D-03, 0.1956D-03, 0.2871D-03,
     ,   0.4213D-03, 0.6183D-03, 0.9074D-03, 0.1331D-02, 0.1953D-02,
     ,   0.2865D-02, 0.4201D-02, 0.6157D-02, 0.9019D-02, 0.1320D-01,
     ,   0.1928D-01, 0.2812D-01, 0.4089D-01, 0.5924D-01, 0.8538D-01,
     ,   0.1223D+00, 0.1738D+00, 0.2453D+00, 0.3446D+00, 0.4850D+00,
     ,   0.6905D+00, 0.1005D+01, 0.1503D+01, 0.2304D+01, 0.3592D+01,
     ,   0.5636D+01, 0.8835D+01, 0.1377D+02, 0.2129D+02, 0.3266D+02,
     ,   0.4968D+02, 0.7505D+02, 0.1127D+03, 0.1684D+03, 0.2505D+03,
     ,   0.3715D+03, 0.5496D+03, 0.8115D+03/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.4215D-09, 0.6187D-09, 0.9081D-09, 0.1333D-08, 0.1956D-08,
     ,   0.2872D-08, 0.4215D-08, 0.6187D-08, 0.9081D-08, 0.1333D-07,
     ,   0.1956D-07, 0.2872D-07, 0.4215D-07, 0.6187D-07, 0.9081D-07,
     ,   0.1333D-06, 0.1956D-06, 0.2872D-06, 0.4215D-06, 0.6187D-06,
     ,   0.9081D-06, 0.1333D-05, 0.1956D-05, 0.2872D-05, 0.4215D-05,
     ,   0.6187D-05, 0.9081D-05, 0.1333D-04, 0.1956D-04, 0.2872D-04,
     ,   0.4215D-04, 0.6187D-04, 0.9080D-04, 0.1333D-03, 0.1956D-03,
     ,   0.2871D-03, 0.4214D-03, 0.6184D-03, 0.9075D-03, 0.1332D-02,
     ,   0.1954D-02, 0.2866D-02, 0.4202D-02, 0.6158D-02, 0.9020D-02,
     ,   0.1320D-01, 0.1929D-01, 0.2812D-01, 0.4090D-01, 0.5925D-01,
     ,   0.8539D-01, 0.1223D+00, 0.1738D+00, 0.2453D+00, 0.3446D+00,
     ,   0.4850D+00, 0.6906D+00, 0.1005D+01, 0.1503D+01, 0.2304D+01,
     ,   0.3592D+01, 0.5637D+01, 0.8836D+01, 0.1377D+02, 0.2130D+02,
     ,   0.3266D+02, 0.4969D+02, 0.7507D+02, 0.1127D+03, 0.1684D+03,
     ,   0.2506D+03, 0.3716D+03, 0.5497D+03/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.2872D-09, 0.4215D-09, 0.6187D-09, 0.9082D-09, 0.1333D-08,
     ,   0.1957D-08, 0.2872D-08, 0.4215D-08, 0.6187D-08, 0.9082D-08,
     ,   0.1333D-07, 0.1957D-07, 0.2872D-07, 0.4215D-07, 0.6187D-07,
     ,   0.9082D-07, 0.1333D-06, 0.1957D-06, 0.2872D-06, 0.4215D-06,
     ,   0.6187D-06, 0.9082D-06, 0.1333D-05, 0.1957D-05, 0.2872D-05,
     ,   0.4215D-05, 0.6187D-05, 0.9082D-05, 0.1333D-04, 0.1957D-04,
     ,   0.2872D-04, 0.4215D-04, 0.6187D-04, 0.9081D-04, 0.1333D-03,
     ,   0.1956D-03, 0.2871D-03, 0.4214D-03, 0.6185D-03, 0.9076D-03,
     ,   0.1332D-02, 0.1954D-02, 0.2866D-02, 0.4202D-02, 0.6159D-02,
     ,   0.9021D-02, 0.1320D-01, 0.1929D-01, 0.2813D-01, 0.4090D-01,
     ,   0.5925D-01, 0.8540D-01, 0.1223D+00, 0.1738D+00, 0.2453D+00,
     ,   0.3447D+00, 0.4851D+00, 0.6906D+00, 0.1005D+01, 0.1503D+01,
     ,   0.2305D+01, 0.3593D+01, 0.5638D+01, 0.8837D+01, 0.1377D+02,
     ,   0.2130D+02, 0.3267D+02, 0.4970D+02, 0.7507D+02, 0.1127D+03,
     ,   0.1684D+03, 0.2506D+03, 0.3716D+03/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.1957D-09, 0.2872D-09, 0.4216D-09, 0.6188D-09, 0.9083D-09,
     ,   0.1333D-08, 0.1957D-08, 0.2872D-08, 0.4216D-08, 0.6188D-08,
     ,   0.9083D-08, 0.1333D-07, 0.1957D-07, 0.2872D-07, 0.4216D-07,
     ,   0.6188D-07, 0.9083D-07, 0.1333D-06, 0.1957D-06, 0.2872D-06,
     ,   0.4216D-06, 0.6188D-06, 0.9083D-06, 0.1333D-05, 0.1957D-05,
     ,   0.2872D-05, 0.4216D-05, 0.6188D-05, 0.9082D-05, 0.1333D-04,
     ,   0.1957D-04, 0.2872D-04, 0.4216D-04, 0.6188D-04, 0.9082D-04,
     ,   0.1333D-03, 0.1956D-03, 0.2872D-03, 0.4214D-03, 0.6185D-03,
     ,   0.9076D-03, 0.1332D-02, 0.1954D-02, 0.2866D-02, 0.4203D-02,
     ,   0.6159D-02, 0.9022D-02, 0.1320D-01, 0.1929D-01, 0.2813D-01,
     ,   0.4091D-01, 0.5926D-01, 0.8540D-01, 0.1223D+00, 0.1738D+00,
     ,   0.2453D+00, 0.3447D+00, 0.4851D+00, 0.6907D+00, 0.1005D+01,
     ,   0.1503D+01, 0.2305D+01, 0.3593D+01, 0.5638D+01, 0.8838D+01,
     ,   0.1377D+02, 0.2130D+02, 0.3267D+02, 0.4970D+02, 0.7508D+02,
     ,   0.1127D+03, 0.1684D+03, 0.2506D+03/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.1333D-09, 0.1957D-09, 0.2872D-09, 0.4216D-09, 0.6188D-09,
     ,   0.9083D-09, 0.1333D-08, 0.1957D-08, 0.2872D-08, 0.4216D-08,
     ,   0.6188D-08, 0.9083D-08, 0.1333D-07, 0.1957D-07, 0.2872D-07,
     ,   0.4216D-07, 0.6188D-07, 0.9083D-07, 0.1333D-06, 0.1957D-06,
     ,   0.2872D-06, 0.4216D-06, 0.6188D-06, 0.9083D-06, 0.1333D-05,
     ,   0.1957D-05, 0.2872D-05, 0.4216D-05, 0.6188D-05, 0.9083D-05,
     ,   0.1333D-04, 0.1957D-04, 0.2872D-04, 0.4216D-04, 0.6188D-04,
     ,   0.9082D-04, 0.1333D-03, 0.1957D-03, 0.2872D-03, 0.4215D-03,
     ,   0.6185D-03, 0.9077D-03, 0.1332D-02, 0.1954D-02, 0.2866D-02,
     ,   0.4203D-02, 0.6160D-02, 0.9022D-02, 0.1320D-01, 0.1929D-01,
     ,   0.2813D-01, 0.4091D-01, 0.5926D-01, 0.8541D-01, 0.1223D+00,
     ,   0.1738D+00, 0.2454D+00, 0.3447D+00, 0.4851D+00, 0.6907D+00,
     ,   0.1005D+01, 0.1503D+01, 0.2305D+01, 0.3593D+01, 0.5638D+01,
     ,   0.8838D+01, 0.1378D+02, 0.2130D+02, 0.3267D+02, 0.4970D+02,
     ,   0.7508D+02, 0.1127D+03, 0.1684D+03/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.9083D-10, 0.1333D-09, 0.1957D-09, 0.2872D-09, 0.4216D-09,
     ,   0.6188D-09, 0.9083D-09, 0.1333D-08, 0.1957D-08, 0.2872D-08,
     ,   0.4216D-08, 0.6188D-08, 0.9083D-08, 0.1333D-07, 0.1957D-07,
     ,   0.2872D-07, 0.4216D-07, 0.6188D-07, 0.9083D-07, 0.1333D-06,
     ,   0.1957D-06, 0.2872D-06, 0.4216D-06, 0.6188D-06, 0.9083D-06,
     ,   0.1333D-05, 0.1957D-05, 0.2872D-05, 0.4216D-05, 0.6188D-05,
     ,   0.9083D-05, 0.1333D-04, 0.1957D-04, 0.2872D-04, 0.4216D-04,
     ,   0.6188D-04, 0.9083D-04, 0.1333D-03, 0.1957D-03, 0.2872D-03,
     ,   0.4215D-03, 0.6185D-03, 0.9077D-03, 0.1332D-02, 0.1954D-02,
     ,   0.2866D-02, 0.4203D-02, 0.6160D-02, 0.9022D-02, 0.1320D-01,
     ,   0.1929D-01, 0.2813D-01, 0.4091D-01, 0.5926D-01, 0.8541D-01,
     ,   0.1223D+00, 0.1739D+00, 0.2454D+00, 0.3447D+00, 0.4852D+00,
     ,   0.6907D+00, 0.1005D+01, 0.1503D+01, 0.2305D+01, 0.3593D+01,
     ,   0.5639D+01, 0.8839D+01, 0.1378D+02, 0.2130D+02, 0.3267D+02,
     ,   0.4970D+02, 0.7509D+02, 0.1127D+03/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.6189D-10, 0.9083D-10, 0.1333D-09, 0.1957D-09, 0.2872D-09,
     ,   0.4216D-09, 0.6188D-09, 0.9083D-09, 0.1333D-08, 0.1957D-08,
     ,   0.2872D-08, 0.4216D-08, 0.6188D-08, 0.9083D-08, 0.1333D-07,
     ,   0.1957D-07, 0.2872D-07, 0.4216D-07, 0.6188D-07, 0.9083D-07,
     ,   0.1333D-06, 0.1957D-06, 0.2872D-06, 0.4216D-06, 0.6188D-06,
     ,   0.9083D-06, 0.1333D-05, 0.1957D-05, 0.2872D-05, 0.4216D-05,
     ,   0.6188D-05, 0.9083D-05, 0.1333D-04, 0.1957D-04, 0.2872D-04,
     ,   0.4216D-04, 0.6188D-04, 0.9083D-04, 0.1333D-03, 0.1957D-03,
     ,   0.2872D-03, 0.4215D-03, 0.6186D-03, 0.9077D-03, 0.1332D-02,
     ,   0.1954D-02, 0.2866D-02, 0.4203D-02, 0.6160D-02, 0.9022D-02,
     ,   0.1320D-01, 0.1929D-01, 0.2813D-01, 0.4091D-01, 0.5926D-01,
     ,   0.8541D-01, 0.1223D+00, 0.1739D+00, 0.2454D+00, 0.3447D+00,
     ,   0.4852D+00, 0.6907D+00, 0.1005D+01, 0.1503D+01, 0.2305D+01,
     ,   0.3593D+01, 0.5639D+01, 0.8839D+01, 0.1378D+02, 0.2130D+02,
     ,   0.3267D+02, 0.4971D+02, 0.7509D+02/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.4216D-10, 0.6189D-10, 0.9084D-10, 0.1333D-09, 0.1957D-09,
     ,   0.2872D-09, 0.4216D-09, 0.6189D-09, 0.9084D-09, 0.1333D-08,
     ,   0.1957D-08, 0.2872D-08, 0.4216D-08, 0.6189D-08, 0.9084D-08,
     ,   0.1333D-07, 0.1957D-07, 0.2872D-07, 0.4216D-07, 0.6189D-07,
     ,   0.9084D-07, 0.1333D-06, 0.1957D-06, 0.2872D-06, 0.4216D-06,
     ,   0.6189D-06, 0.9084D-06, 0.1333D-05, 0.1957D-05, 0.2872D-05,
     ,   0.4216D-05, 0.6189D-05, 0.9084D-05, 0.1333D-04, 0.1957D-04,
     ,   0.2872D-04, 0.4216D-04, 0.6188D-04, 0.9083D-04, 0.1333D-03,
     ,   0.1957D-03, 0.2872D-03, 0.4215D-03, 0.6186D-03, 0.9077D-03,
     ,   0.1332D-02, 0.1954D-02, 0.2866D-02, 0.4203D-02, 0.6160D-02,
     ,   0.9023D-02, 0.1320D-01, 0.1929D-01, 0.2813D-01, 0.4091D-01,
     ,   0.5926D-01, 0.8541D-01, 0.1223D+00, 0.1739D+00, 0.2454D+00,
     ,   0.3447D+00, 0.4852D+00, 0.6908D+00, 0.1005D+01, 0.1503D+01,
     ,   0.2305D+01, 0.3593D+01, 0.5639D+01, 0.8839D+01, 0.1378D+02,
     ,   0.2130D+02, 0.3267D+02, 0.4971D+02/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.2873D-10, 0.4216D-10, 0.6189D-10, 0.9084D-10, 0.1333D-09,
     ,   0.1957D-09, 0.2873D-09, 0.4216D-09, 0.6189D-09, 0.9084D-09,
     ,   0.1333D-08, 0.1957D-08, 0.2873D-08, 0.4216D-08, 0.6189D-08,
     ,   0.9084D-08, 0.1333D-07, 0.1957D-07, 0.2873D-07, 0.4216D-07,
     ,   0.6189D-07, 0.9084D-07, 0.1333D-06, 0.1957D-06, 0.2873D-06,
     ,   0.4216D-06, 0.6189D-06, 0.9084D-06, 0.1333D-05, 0.1957D-05,
     ,   0.2873D-05, 0.4216D-05, 0.6189D-05, 0.9084D-05, 0.1333D-04,
     ,   0.1957D-04, 0.2872D-04, 0.4216D-04, 0.6188D-04, 0.9083D-04,
     ,   0.1333D-03, 0.1957D-03, 0.2872D-03, 0.4215D-03, 0.6186D-03,
     ,   0.9078D-03, 0.1332D-02, 0.1954D-02, 0.2866D-02, 0.4203D-02,
     ,   0.6160D-02, 0.9023D-02, 0.1320D-01, 0.1929D-01, 0.2813D-01,
     ,   0.4091D-01, 0.5926D-01, 0.8541D-01, 0.1223D+00, 0.1739D+00,
     ,   0.2454D+00, 0.3447D+00, 0.4852D+00, 0.6908D+00, 0.1005D+01,
     ,   0.1503D+01, 0.2305D+01, 0.3593D+01, 0.5639D+01, 0.8839D+01,
     ,   0.1378D+02, 0.2131D+02, 0.3267D+02/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.1957D-10, 0.2873D-10, 0.4216D-10, 0.6189D-10, 0.9084D-10,
     ,   0.1333D-09, 0.1957D-09, 0.2873D-09, 0.4216D-09, 0.6189D-09,
     ,   0.9084D-09, 0.1333D-08, 0.1957D-08, 0.2873D-08, 0.4216D-08,
     ,   0.6189D-08, 0.9084D-08, 0.1333D-07, 0.1957D-07, 0.2873D-07,
     ,   0.4216D-07, 0.6189D-07, 0.9084D-07, 0.1333D-06, 0.1957D-06,
     ,   0.2873D-06, 0.4216D-06, 0.6189D-06, 0.9084D-06, 0.1333D-05,
     ,   0.1957D-05, 0.2873D-05, 0.4216D-05, 0.6189D-05, 0.9084D-05,
     ,   0.1333D-04, 0.1957D-04, 0.2872D-04, 0.4216D-04, 0.6188D-04,
     ,   0.9083D-04, 0.1333D-03, 0.1957D-03, 0.2872D-03, 0.4215D-03,
     ,   0.6186D-03, 0.9078D-03, 0.1332D-02, 0.1954D-02, 0.2866D-02,
     ,   0.4203D-02, 0.6160D-02, 0.9023D-02, 0.1320D-01, 0.1929D-01,
     ,   0.2813D-01, 0.4091D-01, 0.5926D-01, 0.8541D-01, 0.1223D+00,
     ,   0.1739D+00, 0.2454D+00, 0.3447D+00, 0.4852D+00, 0.6908D+00,
     ,   0.1005D+01, 0.1503D+01, 0.2305D+01, 0.3593D+01, 0.5639D+01,
     ,   0.8839D+01, 0.1378D+02, 0.2131D+02/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1333D-10, 0.1957D-10, 0.2873D-10, 0.4216D-10, 0.6189D-10,
     ,   0.9084D-10, 0.1333D-09, 0.1957D-09, 0.2873D-09, 0.4216D-09,
     ,   0.6189D-09, 0.9084D-09, 0.1333D-08, 0.1957D-08, 0.2873D-08,
     ,   0.4216D-08, 0.6189D-08, 0.9084D-08, 0.1333D-07, 0.1957D-07,
     ,   0.2873D-07, 0.4216D-07, 0.6189D-07, 0.9084D-07, 0.1333D-06,
     ,   0.1957D-06, 0.2873D-06, 0.4216D-06, 0.6189D-06, 0.9084D-06,
     ,   0.1333D-05, 0.1957D-05, 0.2873D-05, 0.4216D-05, 0.6189D-05,
     ,   0.9084D-05, 0.1333D-04, 0.1957D-04, 0.2872D-04, 0.4216D-04,
     ,   0.6188D-04, 0.9083D-04, 0.1333D-03, 0.1957D-03, 0.2872D-03,
     ,   0.4215D-03, 0.6186D-03, 0.9078D-03, 0.1332D-02, 0.1954D-02,
     ,   0.2866D-02, 0.4203D-02, 0.6160D-02, 0.9023D-02, 0.1320D-01,
     ,   0.1929D-01, 0.2813D-01, 0.4091D-01, 0.5926D-01, 0.8541D-01,
     ,   0.1223D+00, 0.1739D+00, 0.2454D+00, 0.3447D+00, 0.4852D+00,
     ,   0.6908D+00, 0.1005D+01, 0.1503D+01, 0.2305D+01, 0.3593D+01,
     ,   0.5639D+01, 0.8839D+01, 0.1378D+02/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine cthqps20cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.1474D-03, 0.2070D-03, 0.2904D-03, 0.4070D-03, 0.5698D-03,
     ,   0.7967D-03, 0.1113D-02, 0.1552D-02, 0.2162D-02, 0.3007D-02,
     ,   0.4177D-02, 0.5791D-02, 0.8017D-02, 0.1108D-01, 0.1528D-01,
     ,   0.2103D-01, 0.2888D-01, 0.3957D-01, 0.5408D-01, 0.7370D-01,
     ,   0.1002D+00, 0.1357D+00, 0.1831D+00, 0.2462D+00, 0.3295D+00,
     ,   0.4390D+00, 0.5816D+00, 0.7659D+00, 0.1001D+01, 0.1298D+01,
     ,   0.1666D+01, 0.2113D+01, 0.2642D+01, 0.3245D+01, 0.3898D+01,
     ,   0.4557D+01, 0.5147D+01, 0.5566D+01, 0.5683D+01, 0.5326D+01,
     ,   0.4256D+01, 0.2123D+01,-0.1538D+01,-0.7227D+01,-0.1533D+02,
     ,  -0.2594D+02,-0.3874D+02,-0.5276D+02,-0.6612D+02,-0.7549D+02,
     ,  -0.7540D+02,-0.5717D+02,-0.7375D+01, 0.9435D+02, 0.2786D+03,
     ,   0.5910D+03, 0.1099D+04, 0.1903D+04, 0.3149D+04, 0.5055D+04,
     ,   0.7939D+04, 0.1227D+05, 0.1873D+05, 0.2835D+05, 0.4259D+05,
     ,   0.6364D+05, 0.9469D+05, 0.1405D+06, 0.2078D+06, 0.3069D+06,
     ,   0.4525D+06, 0.6666D+06, 0.9810D+06/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1095D-03, 0.1538D-03, 0.2160D-03, 0.3029D-03, 0.4243D-03,
     ,   0.5937D-03, 0.8298D-03, 0.1158D-02, 0.1615D-02, 0.2248D-02,
     ,   0.3125D-02, 0.4337D-02, 0.6010D-02, 0.8314D-02, 0.1148D-01,
     ,   0.1582D-01, 0.2175D-01, 0.2984D-01, 0.4084D-01, 0.5575D-01,
     ,   0.7588D-01, 0.1030D+00, 0.1393D+00, 0.1876D+00, 0.2518D+00,
     ,   0.3363D+00, 0.4469D+00, 0.5904D+00, 0.7749D+00, 0.1009D+01,
     ,   0.1303D+01, 0.1663D+01, 0.2096D+01, 0.2600D+01, 0.3162D+01,
     ,   0.3752D+01, 0.4314D+01, 0.4767D+01, 0.4997D+01, 0.4861D+01,
     ,   0.4173D+01, 0.2665D+01,-0.4359D-01,-0.4449D+01,-0.1106D+02,
     ,  -0.2024D+02,-0.3206D+02,-0.4611D+02,-0.6130D+02,-0.7550D+02,
     ,  -0.8502D+02,-0.8380D+02,-0.6228D+02,-0.5729D+01, 0.1082D+03,
     ,   0.3128D+03, 0.6580D+03, 0.1217D+04, 0.2100D+04, 0.3466D+04,
     ,   0.5551D+04, 0.8703D+04, 0.1343D+05, 0.2049D+05, 0.3097D+05,
     ,   0.4649D+05, 0.6943D+05, 0.1033D+06, 0.1531D+06, 0.2265D+06,
     ,   0.3344D+06, 0.4930D+06, 0.7260D+06/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.8022D-04, 0.1128D-03, 0.1585D-03, 0.2224D-03, 0.3117D-03,
     ,   0.4366D-03, 0.6106D-03, 0.8531D-03, 0.1190D-02, 0.1659D-02,
     ,   0.2308D-02, 0.3206D-02, 0.4448D-02, 0.6160D-02, 0.8515D-02,
     ,   0.1175D-01, 0.1618D-01, 0.2222D-01, 0.3046D-01, 0.4165D-01,
     ,   0.5679D-01, 0.7721D-01, 0.1046D+00, 0.1413D+00, 0.1901D+00,
     ,   0.2546D+00, 0.3393D+00, 0.4498D+00, 0.5927D+00, 0.7754D+00,
     ,   0.1006D+01, 0.1293D+01, 0.1642D+01, 0.2056D+01, 0.2529D+01,
     ,   0.3043D+01, 0.3561D+01, 0.4019D+01, 0.4326D+01, 0.4356D+01,
     ,   0.3955D+01, 0.2913D+01, 0.9353D+00,-0.2407D+01,-0.7659D+01,
     ,  -0.1538D+02,-0.2601D+02,-0.3967D+02,-0.5605D+02,-0.7419D+02,
     ,  -0.9207D+02,-0.1062D+03,-0.1107D+03,-0.9628D+02,-0.4867D+02,
     ,   0.5387D+02, 0.2439D+03, 0.5699D+03, 0.1104D+04, 0.1952D+04,
     ,   0.3270D+04, 0.5288D+04, 0.8345D+04, 0.1294D+05, 0.1980D+05,
     ,   0.3000D+05, 0.4512D+05, 0.6746D+05, 0.1004D+06, 0.1490D+06,
     ,   0.2205D+06, 0.3257D+06, 0.4804D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.5817D-04, 0.8185D-04, 0.1151D-03, 0.1616D-03, 0.2267D-03,
     ,   0.3177D-03, 0.4448D-03, 0.6219D-03, 0.8685D-03, 0.1211D-02,
     ,   0.1687D-02, 0.2346D-02, 0.3259D-02, 0.4518D-02, 0.6253D-02,
     ,   0.8638D-02, 0.1191D-01, 0.1639D-01, 0.2250D-01, 0.3081D-01,
     ,   0.4209D-01, 0.5733D-01, 0.7785D-01, 0.1054D+00, 0.1421D+00,
     ,   0.1908D+00, 0.2551D+00, 0.3393D+00, 0.4487D+00, 0.5896D+00,
     ,   0.7688D+00, 0.9936D+00, 0.1271D+01, 0.1605D+01, 0.1995D+01,
     ,   0.2431D+01, 0.2891D+01, 0.3330D+01, 0.3674D+01, 0.3822D+01,
     ,   0.3638D+01, 0.2949D+01, 0.1523D+01,-0.9772D+00,-0.5040D+01,
     ,  -0.1129D+02,-0.2040D+02,-0.3294D+02,-0.4926D+02,-0.6931D+02,
     ,  -0.9252D+02,-0.1174D+03,-0.1413D+03,-0.1593D+03,-0.1639D+03,
     ,  -0.1430D+03,-0.7823D+02, 0.5791D+02, 0.3066D+03, 0.7290D+03,
     ,   0.1415D+04, 0.2499D+04, 0.4177D+04, 0.6736D+04, 0.1060D+05,
     ,   0.1640D+05, 0.2504D+05, 0.3787D+05, 0.5687D+05, 0.8493D+05,
     ,   0.1263D+06, 0.1873D+06, 0.2769D+06/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.4185D-04, 0.5893D-04, 0.8289D-04, 0.1165D-03, 0.1636D-03,
     ,   0.2294D-03, 0.3214D-03, 0.4498D-03, 0.6287D-03, 0.8777D-03,
     ,   0.1224D-02, 0.1704D-02, 0.2369D-02, 0.3288D-02, 0.4556D-02,
     ,   0.6302D-02, 0.8701D-02, 0.1199D-01, 0.1648D-01, 0.2261D-01,
     ,   0.3094D-01, 0.4222D-01, 0.5745D-01, 0.7793D-01, 0.1053D+00,
     ,   0.1418D+00, 0.1901D+00, 0.2537D+00, 0.3368D+00, 0.4442D+00,
     ,   0.5820D+00, 0.7562D+00, 0.9732D+00, 0.1238D+01, 0.1554D+01,
     ,   0.1916D+01, 0.2311D+01, 0.2710D+01, 0.3059D+01, 0.3280D+01,
     ,   0.3255D+01, 0.2837D+01, 0.1834D+01,-0.1805D-01,-0.3106D+01,
     ,  -0.7999D+01,-0.1544D+02,-0.2626D+02,-0.4126D+02,-0.6113D+02,
     ,  -0.8632D+02,-0.1169D+03,-0.1524D+03,-0.1915D+03,-0.2314D+03,
     ,  -0.2673D+03,-0.2916D+03,-0.2922D+03,-0.2508D+03,-0.1398D+03,
     ,   0.8221D+02, 0.4763D+03, 0.1133D+04, 0.2185D+04, 0.3830D+04,
     ,   0.6357D+04, 0.1019D+05, 0.1595D+05, 0.2456D+05, 0.3736D+05,
     ,   0.5633D+05, 0.8438D+05, 0.1257D+06/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.2993D-04, 0.4218D-04, 0.5937D-04, 0.8350D-04, 0.1173D-03,
     ,   0.1647D-03, 0.2309D-03, 0.3234D-03, 0.4525D-03, 0.6323D-03,
     ,   0.8824D-03, 0.1230D-02, 0.1711D-02, 0.2378D-02, 0.3299D-02,
     ,   0.4570D-02, 0.6317D-02, 0.8717D-02, 0.1200D-01, 0.1649D-01,
     ,   0.2260D-01, 0.3090D-01, 0.4213D-01, 0.5727D-01, 0.7758D-01,
     ,   0.1047D+00, 0.1408D+00, 0.1884D+00, 0.2509D+00, 0.3322D+00,
     ,   0.4370D+00, 0.5706D+00, 0.7386D+00, 0.9461D+00, 0.1197D+01,
     ,   0.1490D+01, 0.1821D+01, 0.2169D+01, 0.2499D+01, 0.2752D+01,
     ,   0.2835D+01, 0.2623D+01, 0.1949D+01, 0.5993D+00,-0.1726D+01,
     ,  -0.5477D+01,-0.1132D+02,-0.2016D+02,-0.3304D+02,-0.5110D+02,
     ,  -0.7548D+02,-0.1073D+03,-0.1476D+03,-0.1974D+03,-0.2572D+03,
     ,  -0.3273D+03,-0.4071D+03,-0.4952D+03,-0.5889D+03,-0.6831D+03,
     ,  -0.7699D+03,-0.8372D+03,-0.8663D+03,-0.8292D+03,-0.6842D+03,
     ,  -0.3693D+03, 0.2069D+03, 0.1179D+04, 0.2746D+04, 0.5200D+04,
     ,   0.8971D+04, 0.1469D+05, 0.2328D+05/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.2132D-04, 0.3005D-04, 0.4233D-04, 0.5958D-04, 0.8378D-04,
     ,   0.1177D-03, 0.1651D-03, 0.2315D-03, 0.3242D-03, 0.4534D-03,
     ,   0.6333D-03, 0.8835D-03, 0.1231D-02, 0.1712D-02, 0.2378D-02,
     ,   0.3298D-02, 0.4565D-02, 0.6307D-02, 0.8697D-02, 0.1197D-01,
     ,   0.1643D-01, 0.2250D-01, 0.3073D-01, 0.4186D-01, 0.5683D-01,
     ,   0.7688D-01, 0.1036D+00, 0.1391D+00, 0.1858D+00, 0.2468D+00,
     ,   0.3260D+00, 0.4275D+00, 0.5562D+00, 0.7167D+00, 0.9131D+00,
     ,   0.1147D+01, 0.1416D+01, 0.1711D+01, 0.2007D+01, 0.2262D+01,
     ,   0.2407D+01, 0.2341D+01, 0.1923D+01, 0.9692D+00,-0.7610D+00,
     ,  -0.3611D+01,-0.8106D+01,-0.1504D+02,-0.2549D+02,-0.4079D+02,
     ,  -0.6251D+02,-0.9237D+02,-0.1324D+03,-0.1848D+03,-0.2525D+03,
     ,  -0.3385D+03,-0.4470D+03,-0.5831D+03,-0.7534D+03,-0.9672D+03,
     ,  -0.1237D+04,-0.1581D+04,-0.2025D+04,-0.2605D+04,-0.3376D+04,
     ,  -0.4416D+04,-0.5838D+04,-0.7810D+04,-0.1058D+05,-0.1449D+05,
     ,  -0.2009D+05,-0.2813D+05,-0.3974D+05/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.1513D-04, 0.2135D-04, 0.3009D-04, 0.4237D-04, 0.5962D-04,
     ,   0.8381D-04, 0.1177D-03, 0.1651D-03, 0.2314D-03, 0.3239D-03,
     ,   0.4529D-03, 0.6324D-03, 0.8820D-03, 0.1228D-02, 0.1708D-02,
     ,   0.2371D-02, 0.3286D-02, 0.4546D-02, 0.6277D-02, 0.8650D-02,
     ,   0.1189D-01, 0.1632D-01, 0.2232D-01, 0.3046D-01, 0.4144D-01,
     ,   0.5619D-01, 0.7591D-01, 0.1021D+00, 0.1368D+00, 0.1824D+00,
     ,   0.2417D+00, 0.3183D+00, 0.4160D+00, 0.5390D+00, 0.6910D+00,
     ,   0.8748D+00, 0.1090D+01, 0.1332D+01, 0.1587D+01, 0.1825D+01,
     ,   0.1998D+01, 0.2027D+01, 0.1798D+01, 0.1155D+01,-0.1044D+00,
     ,  -0.2252D+01,-0.5681D+01,-0.1100D+02,-0.1916D+02,-0.3145D+02,
     ,  -0.4956D+02,-0.7553D+02,-0.1118D+03,-0.1615D+03,-0.2285D+03,
     ,  -0.3175D+03,-0.4353D+03,-0.5903D+03,-0.7947D+03,-0.1065D+04,
     ,  -0.1426D+04,-0.1910D+04,-0.2569D+04,-0.3474D+04,-0.4731D+04,
     ,  -0.6494D+04,-0.8989D+04,-0.1254D+05,-0.1765D+05,-0.2501D+05,
     ,  -0.3566D+05,-0.5115D+05,-0.7370D+05/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.1071D-04, 0.1512D-04, 0.2133D-04, 0.3006D-04, 0.4232D-04,
     ,   0.5953D-04, 0.8367D-04, 0.1175D-03, 0.1648D-03, 0.2308D-03,
     ,   0.3230D-03, 0.4515D-03, 0.6302D-03, 0.8784D-03, 0.1223D-02,
     ,   0.1699D-02, 0.2358D-02, 0.3266D-02, 0.4516D-02, 0.6232D-02,
     ,   0.8582D-02, 0.1179D-01, 0.1616D-01, 0.2209D-01, 0.3010D-01,
     ,   0.4090D-01, 0.5538D-01, 0.7470D-01, 0.1003D+00, 0.1341D+00,
     ,   0.1784D+00, 0.2357D+00, 0.3094D+00, 0.4028D+00, 0.5193D+00,
     ,   0.6619D+00, 0.8318D+00, 0.1027D+01, 0.1239D+01, 0.1450D+01,
     ,   0.1625D+01, 0.1708D+01, 0.1610D+01, 0.1204D+01, 0.3179D+00,
     ,  -0.1274D+01,-0.3876D+01,-0.7941D+01,-0.1418D+02,-0.2370D+02,
     ,  -0.3806D+02,-0.5935D+02,-0.9019D+02,-0.1339D+03,-0.1948D+03,
     ,  -0.2785D+03,-0.3926D+03,-0.5473D+03,-0.7568D+03,-0.1041D+04,
     ,  -0.1429D+04,-0.1963D+04,-0.2701D+04,-0.3731D+04,-0.5180D+04,
     ,  -0.7236D+04,-0.1017D+05,-0.1438D+05,-0.2046D+05,-0.2926D+05,
     ,  -0.4205D+05,-0.6067D+05,-0.8785D+05/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.7569D-05, 0.1069D-04, 0.1509D-04, 0.2128D-04, 0.2998D-04,
     ,   0.4220D-04, 0.5935D-04, 0.8339D-04, 0.1170D-03, 0.1641D-03,
     ,   0.2298D-03, 0.3215D-03, 0.4492D-03, 0.6268D-03, 0.8733D-03,
     ,   0.1215D-02, 0.1688D-02, 0.2341D-02, 0.3241D-02, 0.4478D-02,
     ,   0.6174D-02, 0.8495D-02, 0.1166D-01, 0.1597D-01, 0.2180D-01,
     ,   0.2968D-01, 0.4027D-01, 0.5444D-01, 0.7330D-01, 0.9826D-01,
     ,   0.1310D+00, 0.1738D+00, 0.2289D+00, 0.2994D+00, 0.3879D+00,
     ,   0.4974D+00, 0.6296D+00, 0.7842D+00, 0.9569D+00, 0.1136D+01,
     ,   0.1300D+01, 0.1407D+01, 0.1393D+01, 0.1158D+01, 0.5604D+00,
     ,  -0.5888D+00,-0.2540D+01,-0.5637D+01,-0.1040D+02,-0.1764D+02,
     ,  -0.2866D+02,-0.4533D+02,-0.7017D+02,-0.1065D+03,-0.1586D+03,
     ,  -0.2322D+03,-0.3350D+03,-0.4775D+03,-0.6744D+03,-0.9462D+03,
     ,  -0.1323D+04,-0.1846D+04,-0.2577D+04,-0.3606D+04,-0.5062D+04,
     ,  -0.7138D+04,-0.1011D+05,-0.1439D+05,-0.2058D+05,-0.2956D+05,
     ,  -0.4262D+05,-0.6165D+05,-0.8944D+05/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.5340D-05, 0.7547D-05, 0.1066D-04, 0.1504D-04, 0.2120D-04,
     ,   0.2986D-04, 0.4203D-04, 0.5909D-04, 0.8300D-04, 0.1165D-03,
     ,   0.1632D-03, 0.2286D-03, 0.3196D-03, 0.4464D-03, 0.6225D-03,
     ,   0.8670D-03, 0.1206D-02, 0.1674D-02, 0.2320D-02, 0.3210D-02,
     ,   0.4432D-02, 0.6106D-02, 0.8394D-02, 0.1151D-01, 0.1574D-01,
     ,   0.2147D-01, 0.2919D-01, 0.3955D-01, 0.5337D-01, 0.7173D-01,
     ,   0.9593D-01, 0.1276D+00, 0.1687D+00, 0.2215D+00, 0.2883D+00,
     ,   0.3716D+00, 0.4734D+00, 0.5943D+00, 0.7324D+00, 0.8809D+00,
     ,   0.1025D+01, 0.1138D+01, 0.1172D+01, 0.1053D+01, 0.6696D+00,
     ,  -0.1334D+00,-0.1566D+01,-0.3905D+01,-0.7535D+01,-0.1304D+02,
     ,  -0.2138D+02,-0.3405D+02,-0.5326D+02,-0.8203D+02,-0.1244D+03,
     ,  -0.1859D+03,-0.2736D+03,-0.3978D+03,-0.5722D+03,-0.8164D+03,
     ,  -0.1158D+04,-0.1638D+04,-0.2313D+04,-0.3267D+04,-0.4624D+04,
     ,  -0.6561D+04,-0.9343D+04,-0.1335D+05,-0.1915D+05,-0.2757D+05,
     ,  -0.3982D+05,-0.5768D+05,-0.8377D+05/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.3763D-05, 0.5320D-05, 0.7517D-05, 0.1061D-04, 0.1497D-04,
     ,   0.2110D-04, 0.2972D-04, 0.4181D-04, 0.5877D-04, 0.8253D-04,
     ,   0.1158D-03, 0.1622D-03, 0.2270D-03, 0.3173D-03, 0.4430D-03,
     ,   0.6175D-03, 0.8596D-03, 0.1195D-02, 0.1658D-02, 0.2296D-02,
     ,   0.3174D-02, 0.4379D-02, 0.6029D-02, 0.8280D-02, 0.1134D-01,
     ,   0.1550D-01, 0.2111D-01, 0.2865D-01, 0.3875D-01, 0.5220D-01,
     ,   0.6999D-01, 0.9337D-01, 0.1238D+00, 0.1632D+00, 0.2133D+00,
     ,   0.2763D+00, 0.3540D+00, 0.4474D+00, 0.5561D+00, 0.6764D+00,
     ,   0.7989D+00, 0.9054D+00, 0.9632D+00, 0.9184D+00, 0.6871D+00,
     ,   0.1458D+00,-0.8774D+00,-0.2613D+01,-0.5368D+01,-0.9572D+01,
     ,  -0.1589D+02,-0.2542D+02,-0.3988D+02,-0.6185D+02,-0.9494D+02,
     ,  -0.1440D+03,-0.2157D+03,-0.3191D+03,-0.4669D+03,-0.6766D+03,
     ,  -0.9733D+03,-0.1393D+04,-0.1987D+04,-0.2830D+04,-0.4033D+04,
     ,  -0.5754D+04,-0.8226D+04,-0.1179D+05,-0.1695D+05,-0.2445D+05,
     ,  -0.3535D+05,-0.5124D+05,-0.7444D+05/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.2648D-05, 0.3746D-05, 0.5296D-05, 0.7482D-05, 0.1056D-04,
     ,   0.1489D-04, 0.2099D-04, 0.2955D-04, 0.4156D-04, 0.5841D-04,
     ,   0.8199D-04, 0.1150D-03, 0.1610D-03, 0.2253D-03, 0.3148D-03,
     ,   0.4392D-03, 0.6119D-03, 0.8513D-03, 0.1183D-02, 0.1640D-02,
     ,   0.2270D-02, 0.3135D-02, 0.4322D-02, 0.5944D-02, 0.8155D-02,
     ,   0.1116D-01, 0.1522D-01, 0.2071D-01, 0.2806D-01, 0.3788D-01,
     ,   0.5092D-01, 0.6811D-01, 0.9061D-01, 0.1198D+00, 0.1572D+00,
     ,   0.2045D+00, 0.2633D+00, 0.3350D+00, 0.4195D+00, 0.5152D+00,
     ,   0.6163D+00, 0.7110D+00, 0.7771D+00, 0.7764D+00, 0.6475D+00,
     ,   0.2964D+00,-0.4136D+00,-0.1672D+01,-0.3732D+01,-0.6931D+01,
     ,  -0.1175D+02,-0.1894D+02,-0.2974D+02,-0.4614D+02,-0.7111D+02,
     ,  -0.1089D+03,-0.1653D+03,-0.2482D+03,-0.3687D+03,-0.5423D+03,
     ,  -0.7906D+03,-0.1145D+04,-0.1650D+04,-0.2370D+04,-0.3398D+04,
     ,  -0.4873D+04,-0.6994D+04,-0.1006D+05,-0.1448D+05,-0.2091D+05,
     ,  -0.3027D+05,-0.4390D+05,-0.6379D+05/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.1862D-05, 0.2636D-05, 0.3728D-05, 0.5269D-05, 0.7442D-05,
     ,   0.1050D-04, 0.1481D-04, 0.2086D-04, 0.2936D-04, 0.4129D-04,
     ,   0.5800D-04, 0.8139D-04, 0.1141D-03, 0.1597D-03, 0.2233D-03,
     ,   0.3119D-03, 0.4350D-03, 0.6058D-03, 0.8423D-03, 0.1169D-02,
     ,   0.1620D-02, 0.2241D-02, 0.3093D-02, 0.4259D-02, 0.5852D-02,
     ,   0.8019D-02, 0.1096D-01, 0.1493D-01, 0.2027D-01, 0.2743D-01,
     ,   0.3695D-01, 0.4955D-01, 0.6609D-01, 0.8764D-01, 0.1154D+00,
     ,   0.1508D+00, 0.1951D+00, 0.2495D+00, 0.3146D+00, 0.3897D+00,
     ,   0.4715D+00, 0.5523D+00, 0.6174D+00, 0.6404D+00, 0.5774D+00,
     ,   0.3591D+00,-0.1193D+00,-0.1009D+01,-0.2517D+01,-0.4922D+01,
     ,  -0.8594D+01,-0.1407D+02,-0.2219D+02,-0.3435D+02,-0.5283D+02,
     ,  -0.8105D+02,-0.1239D+03,-0.1881D+03,-0.2832D+03,-0.4223D+03,
     ,  -0.6239D+03,-0.9143D+03,-0.1331D+04,-0.1929D+04,-0.2786D+04,
     ,  -0.4016D+04,-0.5788D+04,-0.8346D+04,-0.1205D+05,-0.1742D+05,
     ,  -0.2523D+05,-0.3661D+05,-0.5322D+05/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.1308D-05, 0.1853D-05, 0.2622D-05, 0.3708D-05, 0.5239D-05,
     ,   0.7398D-05, 0.1044D-04, 0.1471D-04, 0.2072D-04, 0.2916D-04,
     ,   0.4098D-04, 0.5755D-04, 0.8073D-04, 0.1131D-03, 0.1583D-03,
     ,   0.2213D-03, 0.3088D-03, 0.4305D-03, 0.5991D-03, 0.8325D-03,
     ,   0.1155D-02, 0.1599D-02, 0.2210D-02, 0.3047D-02, 0.4192D-02,
     ,   0.5753D-02, 0.7874D-02, 0.1075D-01, 0.1462D-01, 0.1981D-01,
     ,   0.2675D-01, 0.3595D-01, 0.4808D-01, 0.6394D-01, 0.8448D-01,
     ,   0.1108D+00, 0.1439D+00, 0.1850D+00, 0.2348D+00, 0.2930D+00,
     ,   0.3580D+00, 0.4250D+00, 0.4843D+00, 0.5180D+00, 0.4953D+00,
     ,   0.3664D+00, 0.5339D-01,-0.5600D+00,-0.1640D+01,-0.3413D+01,
     ,  -0.6183D+01,-0.1036D+02,-0.1653D+02,-0.2563D+02,-0.3926D+02,
     ,  -0.5997D+02,-0.9166D+02,-0.1399D+03,-0.2127D+03,-0.3209D+03,
     ,  -0.4800D+03,-0.7119D+03,-0.1048D+04,-0.1532D+04,-0.2230D+04,
     ,  -0.3235D+04,-0.4684D+04,-0.6777D+04,-0.9807D+04,-0.1420D+05,
     ,  -0.2059D+05,-0.2990D+05,-0.4347D+05/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.9186D-06, 0.1301D-05, 0.1843D-05, 0.2607D-05, 0.3686D-05,
     ,   0.5207D-05, 0.7350D-05, 0.1037D-04, 0.1461D-04, 0.2057D-04,
     ,   0.2893D-04, 0.4066D-04, 0.5707D-04, 0.8002D-04, 0.1121D-03,
     ,   0.1568D-03, 0.2190D-03, 0.3055D-03, 0.4256D-03, 0.5920D-03,
     ,   0.8220D-03, 0.1139D-02, 0.1576D-02, 0.2176D-02, 0.2998D-02,
     ,   0.4120D-02, 0.5648D-02, 0.7719D-02, 0.1052D-01, 0.1428D-01,
     ,   0.1932D-01, 0.2603D-01, 0.3489D-01, 0.4653D-01, 0.6166D-01,
     ,   0.8112D-01, 0.1058D+00, 0.1367D+00, 0.1744D+00, 0.2192D+00,
     ,   0.2702D+00, 0.3245D+00, 0.3759D+00, 0.4124D+00, 0.4128D+00,
     ,   0.3420D+00, 0.1434D+00,-0.2698D+00,-0.1026D+01,-0.2306D+01,
     ,  -0.4360D+01,-0.7516D+01,-0.1222D+02,-0.1913D+02,-0.2928D+02,
     ,  -0.4446D+02,-0.6754D+02,-0.1029D+03,-0.1570D+03,-0.2389D+03,
     ,  -0.3611D+03,-0.5417D+03,-0.8061D+03,-0.1191D+04,-0.1748D+04,
     ,  -0.2553D+04,-0.3718D+04,-0.5401D+04,-0.7840D+04,-0.1138D+05,
     ,  -0.1652D+05,-0.2401D+05,-0.3492D+05/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.6445D-06, 0.9136D-06, 0.1294D-05, 0.1832D-05, 0.2591D-05,
     ,   0.3662D-05, 0.5172D-05, 0.7300D-05, 0.1029D-04, 0.1450D-04,
     ,   0.2041D-04, 0.2870D-04, 0.4031D-04, 0.5656D-04, 0.7927D-04,
     ,   0.1110D-03, 0.1552D-03, 0.2166D-03, 0.3020D-03, 0.4205D-03,
     ,   0.5844D-03, 0.8109D-03, 0.1123D-02, 0.1552D-02, 0.2141D-02,
     ,   0.2946D-02, 0.4044D-02, 0.5536D-02, 0.7556D-02, 0.1028D-01,
     ,   0.1393D-01, 0.1880D-01, 0.2527D-01, 0.3377D-01, 0.4488D-01,
     ,   0.5924D-01, 0.7758D-01, 0.1006D+00, 0.1291D+00, 0.1632D+00,
     ,   0.2028D+00, 0.2461D+00, 0.2891D+00, 0.3241D+00, 0.3366D+00,
     ,   0.3020D+00, 0.1803D+00,-0.9172D-01,-0.6104D+00,-0.1517D+01,
     ,  -0.3009D+01,-0.5357D+01,-0.8920D+01,-0.1419D+02,-0.2187D+02,
     ,  -0.3314D+02,-0.4995D+02,-0.7555D+02,-0.1149D+03,-0.1752D+03,
     ,  -0.2667D+03,-0.4039D+03,-0.6075D+03,-0.9065D+03,-0.1343D+04,
     ,  -0.1978D+04,-0.2899D+04,-0.4233D+04,-0.6169D+04,-0.8977D+04,
     ,  -0.1306D+05,-0.1900D+05,-0.2766D+05/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.4519D-06, 0.6409D-06, 0.9082D-06, 0.1286D-05, 0.1820D-05,
     ,   0.2574D-05, 0.3637D-05, 0.5136D-05, 0.7246D-05, 0.1021D-04,
     ,   0.1438D-04, 0.2024D-04, 0.2844D-04, 0.3994D-04, 0.5602D-04,
     ,   0.7848D-04, 0.1098D-03, 0.1534D-03, 0.2141D-03, 0.2983D-03,
     ,   0.4150D-03, 0.5765D-03, 0.7992D-03, 0.1106D-02, 0.1527D-02,
     ,   0.2104D-02, 0.2892D-02, 0.3964D-02, 0.5418D-02, 0.7383D-02,
     ,   0.1002D-01, 0.1356D-01, 0.1826D-01, 0.2446D-01, 0.3260D-01,
     ,   0.4315D-01, 0.5670D-01, 0.7385D-01, 0.9516D-01, 0.1210D+00,
     ,   0.1514D+00, 0.1855D+00, 0.2207D+00, 0.2520D+00, 0.2696D+00,
     ,   0.2568D+00, 0.1855D+00, 0.1042D-01,-0.3388D+00,-0.9683D+00,
     ,  -0.2032D+01,-0.3747D+01,-0.6406D+01,-0.1040D+02,-0.1625D+02,
     ,  -0.2475D+02,-0.3719D+02,-0.5574D+02,-0.8401D+02,-0.1275D+03,
     ,  -0.1944D+03,-0.2962D+03,-0.4494D+03,-0.6773D+03,-0.1013D+04,
     ,  -0.1505D+04,-0.2223D+04,-0.3266D+04,-0.4783D+04,-0.6985D+04,
     ,  -0.1019D+05,-0.1485D+05,-0.2164D+05/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.3167D-06, 0.4493D-06, 0.6370D-06, 0.9025D-06, 0.1278D-05,
     ,   0.1808D-05, 0.2556D-05, 0.3611D-05, 0.5097D-05, 0.7189D-05,
     ,   0.1013D-04, 0.1426D-04, 0.2006D-04, 0.2818D-04, 0.3955D-04,
     ,   0.5545D-04, 0.7764D-04, 0.1086D-03, 0.1516D-03, 0.2115D-03,
     ,   0.2944D-03, 0.4093D-03, 0.5681D-03, 0.7869D-03, 0.1088D-02,
     ,   0.1500D-02, 0.2065D-02, 0.2835D-02, 0.3880D-02, 0.5295D-02,
     ,   0.7202D-02, 0.9758D-02, 0.1317D-01, 0.1768D-01, 0.2362D-01,
     ,   0.3136D-01, 0.4134D-01, 0.5404D-01, 0.6994D-01, 0.8942D-01,
     ,   0.1126D+00, 0.1391D+00, 0.1673D+00, 0.1941D+00, 0.2130D+00,
     ,   0.2125D+00, 0.1732D+00, 0.6333D-01,-0.1678D+00,-0.5980D+00,
     ,  -0.1344D+01,-0.2573D+01,-0.4522D+01,-0.7505D+01,-0.1195D+02,
     ,  -0.1842D+02,-0.2778D+02,-0.4144D+02,-0.6183D+02,-0.9290D+02,
     ,  -0.1408D+03,-0.2147D+03,-0.3274D+03,-0.4974D+03,-0.7511D+03,
     ,  -0.1126D+04,-0.1677D+04,-0.2482D+04,-0.3656D+04,-0.5365D+04,
     ,  -0.7851D+04,-0.1147D+05,-0.1675D+05/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.2218D-06, 0.3148D-06, 0.4465D-06, 0.6329D-06, 0.8966D-06,
     ,   0.1269D-05, 0.1795D-05, 0.2537D-05, 0.3583D-05, 0.5056D-05,
     ,   0.7129D-05, 0.1004D-04, 0.1413D-04, 0.1987D-04, 0.2790D-04,
     ,   0.3914D-04, 0.5485D-04, 0.7676D-04, 0.1073D-03, 0.1497D-03,
     ,   0.2087D-03, 0.2904D-03, 0.4033D-03, 0.5592D-03, 0.7739D-03,
     ,   0.1069D-02, 0.1473D-02, 0.2024D-02, 0.2774D-02, 0.3792D-02,
     ,   0.5166D-02, 0.7011D-02, 0.9479D-02, 0.1276D-01, 0.1708D-01,
     ,   0.2274D-01, 0.3006D-01, 0.3944D-01, 0.5125D-01, 0.6584D-01,
     ,   0.8341D-01, 0.1038D+00, 0.1261D+00, 0.1483D+00, 0.1662D+00,
     ,   0.1721D+00, 0.1527D+00, 0.8572D-01,-0.6454D-01,-0.3543D+00,
     ,  -0.8692D+00,-0.1737D+01,-0.3139D+01,-0.5332D+01,-0.8656D+01,
     ,  -0.1357D+02,-0.2069D+02,-0.3095D+02,-0.4590D+02,-0.6820D+02,
     ,  -0.1022D+03,-0.1548D+03,-0.2360D+03,-0.3602D+03,-0.5480D+03,
     ,  -0.8290D+03,-0.1246D+04,-0.1859D+04,-0.2757D+04,-0.4068D+04,
     ,  -0.5980D+04,-0.8767D+04,-0.1283D+05/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.1553D-06, 0.2205D-06, 0.3129D-06, 0.4436D-06, 0.6287D-06,
     ,   0.8903D-06, 0.1260D-05, 0.1782D-05, 0.2517D-05, 0.3554D-05,
     ,   0.5014D-05, 0.7066D-05, 0.9950D-05, 0.1400D-04, 0.1967D-04,
     ,   0.2761D-04, 0.3872D-04, 0.5422D-04, 0.7584D-04, 0.1059D-03,
     ,   0.1477D-03, 0.2058D-03, 0.2861D-03, 0.3971D-03, 0.5500D-03,
     ,   0.7604D-03, 0.1049D-02, 0.1443D-02, 0.1981D-02, 0.2712D-02,
     ,   0.3700D-02, 0.5030D-02, 0.6813D-02, 0.9187D-02, 0.1233D-01,
     ,   0.1645D-01, 0.2182D-01, 0.2871D-01, 0.3745D-01, 0.4833D-01,
     ,   0.6156D-01, 0.7713D-01, 0.9457D-01, 0.1126D+00, 0.1285D+00,
     ,   0.1371D+00, 0.1295D+00, 0.9023D-01,-0.5672D-02,-0.1981D+00,
     ,  -0.5490D+00,-0.1152D+01,-0.2147D+01,-0.3731D+01,-0.6178D+01,
     ,  -0.9857D+01,-0.1526D+02,-0.2305D+02,-0.3426D+02,-0.5057D+02,
     ,  -0.7488D+02,-0.1120D+03,-0.1695D+03,-0.2584D+03,-0.3946D+03,
     ,  -0.6012D+03,-0.9110D+03,-0.1371D+04,-0.2050D+04,-0.3045D+04,
     ,  -0.4502D+04,-0.6629D+04,-0.9733D+04/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.1087D-06, 0.1543D-06, 0.2191D-06, 0.3108D-06, 0.4406D-06,
     ,   0.6242D-06, 0.8838D-06, 0.1250D-05, 0.1768D-05, 0.2497D-05,
     ,   0.3524D-05, 0.4969D-05, 0.7001D-05, 0.9854D-05, 0.1386D-04,
     ,   0.1946D-04, 0.2731D-04, 0.3827D-04, 0.5357D-04, 0.7488D-04,
     ,   0.1045D-03, 0.1457D-03, 0.2027D-03, 0.2816D-03, 0.3905D-03,
     ,   0.5404D-03, 0.7463D-03, 0.1028D-02, 0.1413D-02, 0.1937D-02,
     ,   0.2646D-02, 0.3604D-02, 0.4889D-02, 0.6606D-02, 0.8883D-02,
     ,   0.1188D-01, 0.1580D-01, 0.2085D-01, 0.2730D-01, 0.3538D-01,
     ,   0.4529D-01, 0.5710D-01, 0.7058D-01, 0.8496D-01, 0.9850D-01,
     ,   0.1078D+00, 0.1068D+00, 0.8503D-01, 0.2511D-01,-0.1010D+00,
     ,  -0.3373D+00,-0.7521D+00,-0.1448D+01,-0.2575D+01,-0.4347D+01,
     ,  -0.7060D+01,-0.1111D+02,-0.1702D+02,-0.2552D+02,-0.3771D+02,
     ,  -0.5543D+02,-0.8185D+02,-0.1222D+03,-0.1848D+03,-0.2818D+03,
     ,  -0.4308D+03,-0.6571D+03,-0.9970D+03,-0.1503D+04,-0.2250D+04,
     ,  -0.3349D+04,-0.4958D+04,-0.7311D+04/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.7601D-07, 0.1080D-06, 0.1533D-06, 0.2176D-06, 0.3086D-06,
     ,   0.4375D-06, 0.6196D-06, 0.8770D-06, 0.1240D-05, 0.1753D-05,
     ,   0.2475D-05, 0.3492D-05, 0.4923D-05, 0.6933D-05, 0.9754D-05,
     ,   0.1371D-04, 0.1925D-04, 0.2699D-04, 0.3781D-04, 0.5289D-04,
     ,   0.7388D-04, 0.1031D-03, 0.1435D-03, 0.1996D-03, 0.2770D-03,
     ,   0.3837D-03, 0.5304D-03, 0.7316D-03, 0.1007D-02, 0.1381D-02,
     ,   0.1890D-02, 0.2578D-02, 0.3503D-02, 0.4742D-02, 0.6390D-02,
     ,   0.8567D-02, 0.1142D-01, 0.1512D-01, 0.1985D-01, 0.2583D-01,
     ,   0.3322D-01, 0.4213D-01, 0.5245D-01, 0.6376D-01, 0.7495D-01,
     ,   0.8382D-01, 0.8628D-01, 0.7525D-01, 0.3876D-01,-0.4266D-01,
     ,  -0.2001D+00,-0.4822D+00,-0.9634D+00,-0.1755D+01,-0.3020D+01,
     ,  -0.4988D+01,-0.7978D+01,-0.1241D+02,-0.1886D+02,-0.2810D+02,
     ,  -0.4131D+02,-0.6050D+02,-0.8911D+02,-0.1329D+03,-0.2008D+03,
     ,  -0.3063D+03,-0.4686D+03,-0.7155D+03,-0.1087D+04,-0.1641D+04,
     ,  -0.2460D+04,-0.3667D+04,-0.5436D+04/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.5314D-07, 0.7552D-07, 0.1073D-06, 0.1523D-06, 0.2161D-06,
     ,   0.3064D-06, 0.4342D-06, 0.6148D-06, 0.8699D-06, 0.1230D-05,
     ,   0.1738D-05, 0.2453D-05, 0.3459D-05, 0.4874D-05, 0.6862D-05,
     ,   0.9650D-05, 0.1356D-04, 0.1902D-04, 0.2666D-04, 0.3732D-04,
     ,   0.5218D-04, 0.7284D-04, 0.1015D-03, 0.1413D-03, 0.1963D-03,
     ,   0.2722D-03, 0.3766D-03, 0.5200D-03, 0.7164D-03, 0.9843D-03,
     ,   0.1349D-02, 0.1842D-02, 0.2507D-02, 0.3399D-02, 0.4589D-02,
     ,   0.6166D-02, 0.8238D-02, 0.1094D-01, 0.1441D-01, 0.1881D-01,
     ,   0.2430D-01, 0.3098D-01, 0.3884D-01, 0.4762D-01, 0.5667D-01,
     ,   0.6455D-01, 0.6856D-01, 0.6391D-01, 0.4244D-01,-0.9325D-02,
     ,  -0.1131D+00,-0.3032D+00,-0.6328D+00,-0.1183D+01,-0.2074D+01,
     ,  -0.3482D+01,-0.5655D+01,-0.8932D+01,-0.1377D+02,-0.2077D+02,
     ,  -0.3077D+02,-0.4505D+02,-0.6577D+02,-0.9667D+02,-0.1440D+03,
     ,  -0.2175D+03,-0.3318D+03,-0.5080D+03,-0.7765D+03,-0.1181D+04,
     ,  -0.1785D+04,-0.2680D+04,-0.3999D+04/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.3713D-07, 0.5279D-07, 0.7502D-07, 0.1065D-06, 0.1512D-06,
     ,   0.2145D-06, 0.3041D-06, 0.4308D-06, 0.6098D-06, 0.8625D-06,
     ,   0.1219D-05, 0.1722D-05, 0.2430D-05, 0.3425D-05, 0.4824D-05,
     ,   0.6788D-05, 0.9542D-05, 0.1340D-04, 0.1879D-04, 0.2632D-04,
     ,   0.3682D-04, 0.5144D-04, 0.7176D-04, 0.9994D-04, 0.1390D-03,
     ,   0.1929D-03, 0.2671D-03, 0.3693D-03, 0.5092D-03, 0.7005D-03,
     ,   0.9610D-03, 0.1314D-02, 0.1792D-02, 0.2434D-02, 0.3291D-02,
     ,   0.4431D-02, 0.5933D-02, 0.7896D-02, 0.1043D-01, 0.1367D-01,
     ,   0.1773D-01, 0.2272D-01, 0.2865D-01, 0.3542D-01, 0.4261D-01,
     ,   0.4932D-01, 0.5377D-01, 0.5274D-01, 0.4069D-01, 0.8391D-02,
     ,  -0.5923D-01,-0.1862D+00,-0.4101D+00,-0.7891D+00,-0.1411D+01,
     ,  -0.2406D+01,-0.3962D+01,-0.6346D+01,-0.9922D+01,-0.1518D+02,
     ,  -0.2275D+02,-0.3354D+02,-0.4893D+02,-0.7125D+02,-0.1045D+03,
     ,  -0.1555D+03,-0.2349D+03,-0.3584D+03,-0.5491D+03,-0.8401D+03,
     ,  -0.1279D+04,-0.1936D+04,-0.2910D+04/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.2594D-07, 0.3689D-07, 0.5244D-07, 0.7450D-07, 0.1058D-06,
     ,   0.1501D-06, 0.2129D-06, 0.3017D-06, 0.4272D-06, 0.6046D-06,
     ,   0.8549D-06, 0.1208D-05, 0.1705D-05, 0.2405D-05, 0.3390D-05,
     ,   0.4772D-05, 0.6712D-05, 0.9430D-05, 0.1323D-04, 0.1855D-04,
     ,   0.2597D-04, 0.3630D-04, 0.5068D-04, 0.7064D-04, 0.9830D-04,
     ,   0.1365D-03, 0.1893D-03, 0.2619D-03, 0.3616D-03, 0.4980D-03,
     ,   0.6841D-03, 0.9369D-03, 0.1279D-02, 0.1740D-02, 0.2357D-02,
     ,   0.3180D-02, 0.4267D-02, 0.5692D-02, 0.7542D-02, 0.9915D-02,
     ,   0.1291D-01, 0.1661D-01, 0.2107D-01, 0.2624D-01, 0.3188D-01,
     ,   0.3742D-01, 0.4170D-01, 0.4258D-01, 0.3633D-01, 0.1663D-01,
     ,  -0.2689D-01,-0.1109D+00,-0.2619D+00,-0.5210D+00,-0.9511D+00,
     ,  -0.1647D+01,-0.2749D+01,-0.4460D+01,-0.7063D+01,-0.1095D+02,
     ,  -0.1663D+02,-0.2480D+02,-0.3642D+02,-0.5296D+02,-0.7692D+02,
     ,  -0.1127D+03,-0.1675D+03,-0.2529D+03,-0.3861D+03,-0.5919D+03,
     ,  -0.9064D+03,-0.1382D+04,-0.2093D+04/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1811D-07, 0.2577D-07, 0.3664D-07, 0.5207D-07, 0.7397D-07,
     ,   0.1050D-06, 0.1490D-06, 0.2112D-06, 0.2992D-06, 0.4236D-06,
     ,   0.5992D-06, 0.8470D-06, 0.1196D-05, 0.1688D-05, 0.2380D-05,
     ,   0.3353D-05, 0.4719D-05, 0.6633D-05, 0.9314D-05, 0.1306D-04,
     ,   0.1830D-04, 0.2560D-04, 0.3577D-04, 0.4989D-04, 0.6948D-04,
     ,   0.9660D-04, 0.1341D-03, 0.1857D-03, 0.2566D-03, 0.3537D-03,
     ,   0.4865D-03, 0.6671D-03, 0.9119D-03, 0.1242D-02, 0.1686D-02,
     ,   0.2278D-02, 0.3064D-02, 0.4097D-02, 0.5443D-02, 0.7176D-02,
     ,   0.9377D-02, 0.1212D-01, 0.1546D-01, 0.1937D-01, 0.2375D-01,
     ,   0.2822D-01, 0.3205D-01, 0.3381D-01, 0.3101D-01, 0.1935D-01,
     ,  -0.8278D-02,-0.6342D-01,-0.1645D+00,-0.3403D+00,-0.6357D+00,
     ,  -0.1119D+01,-0.1891D+01,-0.3105D+01,-0.4975D+01,-0.7805D+01,
     ,  -0.1201D+02,-0.1814D+02,-0.2693D+02,-0.3940D+02,-0.5713D+02,
     ,  -0.8280D+02,-0.1211D+03,-0.1800D+03,-0.2717D+03,-0.4148D+03,
     ,  -0.6363D+03,-0.9752D+03,-0.1488D+04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine cthqps21cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.1595D-04,-0.2288D-04,-0.3281D-04,-0.4701D-04,-0.6731D-04,
     ,  -0.9633D-04,-0.1378D-03,-0.1969D-03,-0.2812D-03,-0.4012D-03,
     ,  -0.5721D-03,-0.8150D-03,-0.1160D-02,-0.1649D-02,-0.2343D-02,
     ,  -0.3324D-02,-0.4710D-02,-0.6666D-02,-0.9422D-02,-0.1330D-01,
     ,  -0.1873D-01,-0.2634D-01,-0.3697D-01,-0.5178D-01,-0.7234D-01,
     ,  -0.1008D+00,-0.1400D+00,-0.1937D+00,-0.2668D+00,-0.3658D+00,
     ,  -0.4983D+00,-0.6738D+00,-0.9028D+00,-0.1196D+01,-0.1562D+01,
     ,  -0.2006D+01,-0.2525D+01,-0.3111D+01,-0.3752D+01,-0.4442D+01,
     ,  -0.5177D+01,-0.5928D+01,-0.6571D+01,-0.6788D+01,-0.5952D+01,
     ,  -0.2990D+01, 0.3808D+01, 0.1707D+02, 0.4079D+02, 0.8087D+02,
     ,   0.1461D+03, 0.2494D+03, 0.4098D+03, 0.6552D+03, 0.1027D+04,
     ,   0.1584D+04, 0.2416D+04, 0.3651D+04, 0.5480D+04, 0.8182D+04,
     ,   0.1217D+05, 0.1803D+05, 0.2667D+05, 0.3936D+05, 0.5801D+05,
     ,   0.8541D+05, 0.1257D+06, 0.1848D+06, 0.2715D+06, 0.3989D+06,
     ,   0.5859D+06, 0.8604D+06, 0.1263D+07/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.1159D-04,-0.1663D-04,-0.2384D-04,-0.3417D-04,-0.4894D-04,
     ,  -0.7005D-04,-0.1002D-03,-0.1432D-03,-0.2046D-03,-0.2920D-03,
     ,  -0.4164D-03,-0.5934D-03,-0.8448D-03,-0.1201D-02,-0.1707D-02,
     ,  -0.2423D-02,-0.3434D-02,-0.4863D-02,-0.6875D-02,-0.9706D-02,
     ,  -0.1368D-01,-0.1925D-01,-0.2704D-01,-0.3789D-01,-0.5297D-01,
     ,  -0.7387D-01,-0.1027D+00,-0.1423D+00,-0.1964D+00,-0.2698D+00,
     ,  -0.3686D+00,-0.5001D+00,-0.6732D+00,-0.8969D+00,-0.1180D+01,
     ,  -0.1529D+01,-0.1944D+01,-0.2418D+01,-0.2935D+01,-0.3475D+01,
     ,  -0.4014D+01,-0.4516D+01,-0.4890D+01,-0.4897D+01,-0.4042D+01,
     ,  -0.1431D+01, 0.4398D+01, 0.1572D+02, 0.3601D+02, 0.7044D+02,
     ,   0.1267D+03, 0.2162D+03, 0.3557D+03, 0.5698D+03, 0.8944D+03,
     ,   0.1383D+04, 0.2112D+04, 0.3197D+04, 0.4806D+04, 0.7182D+04,
     ,   0.1069D+05, 0.1585D+05, 0.2345D+05, 0.3463D+05, 0.5106D+05,
     ,   0.7520D+05, 0.1107D+06, 0.1627D+06, 0.2392D+06, 0.3514D+06,
     ,   0.5162D+06, 0.7581D+06, 0.1113D+07/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.8296D-05,-0.1190D-04,-0.1707D-04,-0.2447D-04,-0.3505D-04,
     ,  -0.5018D-04,-0.7179D-04,-0.1026D-03,-0.1467D-03,-0.2094D-03,
     ,  -0.2987D-03,-0.4257D-03,-0.6063D-03,-0.8626D-03,-0.1226D-02,
     ,  -0.1741D-02,-0.2469D-02,-0.3497D-02,-0.4946D-02,-0.6986D-02,
     ,  -0.9853D-02,-0.1387D-01,-0.1950D-01,-0.2734D-01,-0.3827D-01,
     ,  -0.5341D-01,-0.7435D-01,-0.1032D+00,-0.1426D+00,-0.1963D+00,
     ,  -0.2689D+00,-0.3662D+00,-0.4950D+00,-0.6631D+00,-0.8786D+00,
     ,  -0.1148D+01,-0.1475D+01,-0.1857D+01,-0.2280D+01,-0.2723D+01,
     ,  -0.3155D+01,-0.3534D+01,-0.3789D+01,-0.3760D+01,-0.3098D+01,
     ,  -0.1129D+01, 0.3303D+01, 0.1204D+02, 0.2792D+02, 0.5523D+02,
     ,   0.1003D+03, 0.1727D+03, 0.2863D+03, 0.4616D+03, 0.7286D+03,
     ,   0.1132D+04, 0.1735D+04, 0.2635D+04, 0.3970D+04, 0.5946D+04,
     ,   0.8863D+04, 0.1316D+05, 0.1949D+05, 0.2880D+05, 0.4249D+05,
     ,   0.6261D+05, 0.9215D+05, 0.1355D+06, 0.1993D+06, 0.2928D+06,
     ,   0.4302D+06, 0.6318D+06, 0.9278D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.5871D-05,-0.8425D-05,-0.1209D-04,-0.1733D-04,-0.2483D-04,
     ,  -0.3555D-04,-0.5087D-04,-0.7276D-04,-0.1040D-03,-0.1485D-03,
     ,  -0.2119D-03,-0.3021D-03,-0.4304D-03,-0.6126D-03,-0.8710D-03,
     ,  -0.1237D-02,-0.1755D-02,-0.2488D-02,-0.3521D-02,-0.4976D-02,
     ,  -0.7022D-02,-0.9893D-02,-0.1391D-01,-0.1953D-01,-0.2736D-01,
     ,  -0.3823D-01,-0.5328D-01,-0.7403D-01,-0.1025D+00,-0.1414D+00,
     ,  -0.1942D+00,-0.2652D+00,-0.3599D+00,-0.4846D+00,-0.6461D+00,
     ,  -0.8513D+00,-0.1105D+01,-0.1408D+01,-0.1753D+01,-0.2123D+01,
     ,  -0.2488D+01,-0.2808D+01,-0.3022D+01,-0.3022D+01,-0.2581D+01,
     ,  -0.1237D+01, 0.1855D+01, 0.8103D+01, 0.1972D+02, 0.4010D+02,
     ,   0.7430D+02, 0.1299D+03, 0.2180D+03, 0.3551D+03, 0.5653D+03,
     ,   0.8840D+03, 0.1363D+04, 0.2080D+04, 0.3145D+04, 0.4723D+04,
     ,   0.7057D+04, 0.1050D+05, 0.1557D+05, 0.2303D+05, 0.3401D+05,
     ,   0.5014D+05, 0.7384D+05, 0.1087D+06, 0.1598D+06, 0.2349D+06,
     ,   0.3451D+06, 0.5069D+06, 0.7444D+06/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.4121D-05,-0.5915D-05,-0.8487D-05,-0.1217D-04,-0.1744D-04,
     ,  -0.2498D-04,-0.3576D-04,-0.5116D-04,-0.7313D-04,-0.1045D-03,
     ,  -0.1491D-03,-0.2127D-03,-0.3031D-03,-0.4316D-03,-0.6139D-03,
     ,  -0.8724D-03,-0.1238D-02,-0.1756D-02,-0.2486D-02,-0.3516D-02,
     ,  -0.4965D-02,-0.7001D-02,-0.9854D-02,-0.1384D-01,-0.1941D-01,
     ,  -0.2715D-01,-0.3789D-01,-0.5272D-01,-0.7313D-01,-0.1011D+00,
     ,  -0.1391D+00,-0.1905D+00,-0.2594D+00,-0.3508D+00,-0.4704D+00,
     ,  -0.6243D+00,-0.8178D+00,-0.1054D+01,-0.1330D+01,-0.1637D+01,
     ,  -0.1952D+01,-0.2239D+01,-0.2446D+01,-0.2494D+01,-0.2236D+01,
     ,  -0.1380D+01, 0.6447D+00, 0.4849D+01, 0.1289D+02, 0.2734D+02,
     ,   0.5210D+02, 0.9302D+02, 0.1588D+03, 0.2622D+03, 0.4221D+03,
     ,   0.6661D+03, 0.1035D+04, 0.1588D+04, 0.2413D+04, 0.3639D+04,
     ,   0.5453D+04, 0.8133D+04, 0.1209D+05, 0.1790D+05, 0.2647D+05,
     ,   0.3905D+05, 0.5755D+05, 0.8473D+05, 0.1246D+06, 0.1833D+06,
     ,   0.2693D+06, 0.3957D+06, 0.5811D+06/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.2876D-05,-0.4129D-05,-0.5925D-05,-0.8498D-05,-0.1218D-04,
     ,  -0.1745D-04,-0.2499D-04,-0.3576D-04,-0.5114D-04,-0.7308D-04,
     ,  -0.1044D-03,-0.1489D-03,-0.2123D-03,-0.3024D-03,-0.4303D-03,
     ,  -0.6117D-03,-0.8688D-03,-0.1232D-02,-0.1746D-02,-0.2471D-02,
     ,  -0.3492D-02,-0.4926D-02,-0.6940D-02,-0.9758D-02,-0.1369D-01,
     ,  -0.1918D-01,-0.2679D-01,-0.3733D-01,-0.5186D-01,-0.7180D-01,
     ,  -0.9903D-01,-0.1360D+00,-0.1858D+00,-0.2522D+00,-0.3398D+00,
     ,  -0.4538D+00,-0.5991D+00,-0.7800D+00,-0.9974D+00,-0.1247D+01,
     ,  -0.1515D+01,-0.1774D+01,-0.1982D+01,-0.2076D+01,-0.1957D+01,
     ,  -0.1442D+01,-0.1734D+00, 0.2525D+01, 0.7824D+01, 0.1762D+02,
     ,   0.3483D+02, 0.6387D+02, 0.1113D+03, 0.1870D+03, 0.3052D+03,
     ,   0.4872D+03, 0.7641D+03, 0.1182D+04, 0.1807D+04, 0.2737D+04,
     ,   0.4118D+04, 0.6162D+04, 0.9178D+04, 0.1362D+05, 0.2017D+05,
     ,   0.2979D+05, 0.4394D+05, 0.6474D+05, 0.9528D+05, 0.1401D+06,
     ,   0.2060D+06, 0.3027D+06, 0.4447D+06/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.1998D-05,-0.2870D-05,-0.4119D-05,-0.5910D-05,-0.8474D-05,
     ,  -0.1214D-04,-0.1739D-04,-0.2490D-04,-0.3561D-04,-0.5091D-04,
     ,  -0.7272D-04,-0.1038D-03,-0.1480D-03,-0.2110D-03,-0.3003D-03,
     ,  -0.4272D-03,-0.6070D-03,-0.8615D-03,-0.1221D-02,-0.1729D-02,
     ,  -0.2445D-02,-0.3453D-02,-0.4867D-02,-0.6850D-02,-0.9622D-02,
     ,  -0.1349D-01,-0.1887D-01,-0.2632D-01,-0.3662D-01,-0.5079D-01,
     ,  -0.7019D-01,-0.9661D-01,-0.1323D+00,-0.1803D+00,-0.2440D+00,
     ,  -0.3275D+00,-0.4354D+00,-0.5718D+00,-0.7394D+00,-0.9375D+00,
     ,  -0.1159D+01,-0.1387D+01,-0.1590D+01,-0.1720D+01,-0.1702D+01,
     ,  -0.1417D+01,-0.6468D+00, 0.1030D+01, 0.4393D+01, 0.1077D+02,
     ,   0.2228D+02, 0.4219D+02, 0.7540D+02, 0.1292D+03, 0.2145D+03,
     ,   0.3472D+03, 0.5507D+03, 0.8596D+03, 0.1324D+04, 0.2019D+04,
     ,   0.3053D+04, 0.4585D+04, 0.6850D+04, 0.1019D+05, 0.1512D+05,
     ,   0.2237D+05, 0.3303D+05, 0.4870D+05, 0.7172D+05, 0.1055D+06,
     ,   0.1552D+06, 0.2281D+06, 0.3352D+06/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.1385D-05,-0.1989D-05,-0.2856D-05,-0.4098D-05,-0.5877D-05,
     ,  -0.8425D-05,-0.1207D-04,-0.1728D-04,-0.2473D-04,-0.3536D-04,
     ,  -0.5053D-04,-0.7215D-04,-0.1029D-03,-0.1468D-03,-0.2090D-03,
     ,  -0.2974D-03,-0.4228D-03,-0.6005D-03,-0.8518D-03,-0.1207D-02,
     ,  -0.1707D-02,-0.2413D-02,-0.3404D-02,-0.4794D-02,-0.6740D-02,
     ,  -0.9458D-02,-0.1324D-01,-0.1850D-01,-0.2578D-01,-0.3581D-01,
     ,  -0.4958D-01,-0.6838D-01,-0.9391D-01,-0.1283D+00,-0.1743D+00,
     ,  -0.2351D+00,-0.3143D+00,-0.4159D+00,-0.5429D+00,-0.6970D+00,
     ,  -0.8754D+00,-0.1069D+01,-0.1257D+01,-0.1404D+01,-0.1455D+01,
     ,  -0.1325D+01,-0.8762D+00, 0.1468D+00, 0.2228D+01, 0.6245D+01,
     ,   0.1368D+02, 0.2687D+02, 0.4942D+02, 0.8672D+02, 0.1468D+03,
     ,   0.2415D+03, 0.3883D+03, 0.6129D+03, 0.9529D+03, 0.1464D+04,
     ,   0.2227D+04, 0.3361D+04, 0.5041D+04, 0.7523D+04, 0.1119D+05,
     ,   0.1658D+05, 0.2452D+05, 0.3619D+05, 0.5335D+05, 0.7855D+05,
     ,   0.1156D+06, 0.1699D+06, 0.2498D+06/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.9575D-06,-0.1376D-05,-0.1976D-05,-0.2836D-05,-0.4068D-05,
     ,  -0.5833D-05,-0.8359D-05,-0.1197D-04,-0.1714D-04,-0.2451D-04,
     ,  -0.3504D-04,-0.5005D-04,-0.7143D-04,-0.1019D-03,-0.1452D-03,
     ,  -0.2067D-03,-0.2939D-03,-0.4176D-03,-0.5927D-03,-0.8403D-03,
     ,  -0.1190D-02,-0.1682D-02,-0.2375D-02,-0.3348D-02,-0.4711D-02,
     ,  -0.6617D-02,-0.9276D-02,-0.1297D-01,-0.1810D-01,-0.2518D-01,
     ,  -0.3492D-01,-0.4827D-01,-0.6644D-01,-0.9104D-01,-0.1241D+00,
     ,  -0.1680D+00,-0.2258D+00,-0.3006D+00,-0.3956D+00,-0.5132D+00,
     ,  -0.6534D+00,-0.8120D+00,-0.9771D+00,-0.1125D+01,-0.1217D+01,
     ,  -0.1190D+01,-0.9488D+00,-0.3365D+00, 0.9373D+00, 0.3418D+01,
     ,   0.8081D+01, 0.1656D+02, 0.3141D+02, 0.5656D+02, 0.9787D+02,
     ,   0.1641D+03, 0.2680D+03, 0.4287D+03, 0.6739D+03, 0.1045D+04,
     ,   0.1601D+04, 0.2431D+04, 0.3663D+04, 0.5488D+04, 0.8184D+04,
     ,   0.1216D+05, 0.1801D+05, 0.2663D+05, 0.3929D+05, 0.5790D+05,
     ,   0.8525D+05, 0.1254D+06, 0.1844D+06/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.6612D-06,-0.9501D-06,-0.1365D-05,-0.1959D-05,-0.2812D-05,
     ,  -0.4033D-05,-0.5781D-05,-0.8282D-05,-0.1186D-04,-0.1697D-04,
     ,  -0.2426D-04,-0.3467D-04,-0.4950D-04,-0.7062D-04,-0.1007D-03,
     ,  -0.1434D-03,-0.2040D-03,-0.2900D-03,-0.4119D-03,-0.5842D-03,
     ,  -0.8277D-03,-0.1171D-02,-0.1655D-02,-0.2334D-02,-0.3287D-02,
     ,  -0.4622D-02,-0.6485D-02,-0.9081D-02,-0.1268D-01,-0.1767D-01,
     ,  -0.2455D-01,-0.3399D-01,-0.4689D-01,-0.6441D-01,-0.8804D-01,
     ,  -0.1196D+00,-0.1615D+00,-0.2162D+00,-0.2865D+00,-0.3749D+00,
     ,  -0.4828D+00,-0.6090D+00,-0.7477D+00,-0.8844D+00,-0.9926D+00,
     ,  -0.1028D+01,-0.9234D+00,-0.5724D+00, 0.2019D+00, 0.1724D+01,
     ,   0.4600D+01, 0.9902D+01, 0.1941D+02, 0.3590D+02, 0.6361D+02,
     ,   0.1089D+03, 0.1811D+03, 0.2942D+03, 0.4685D+03, 0.7341D+03,
     ,   0.1135D+04, 0.1736D+04, 0.2631D+04, 0.3961D+04, 0.5929D+04,
     ,   0.8835D+04, 0.1312D+05, 0.1943D+05, 0.2871D+05, 0.4235D+05,
     ,   0.6240D+05, 0.9185D+05, 0.1351D+06/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.4561D-06,-0.6555D-06,-0.9418D-06,-0.1353D-05,-0.1941D-05,
     ,  -0.2785D-05,-0.3993D-05,-0.5723D-05,-0.8196D-05,-0.1173D-04,
     ,  -0.1678D-04,-0.2399D-04,-0.3426D-04,-0.4890D-04,-0.6974D-04,
     ,  -0.9937D-04,-0.1415D-03,-0.2012D-03,-0.2859D-03,-0.4057D-03,
     ,  -0.5751D-03,-0.8142D-03,-0.1151D-02,-0.1625D-02,-0.2291D-02,
     ,  -0.3224D-02,-0.4528D-02,-0.6347D-02,-0.8877D-02,-0.1238D-01,
     ,  -0.1723D-01,-0.2390D-01,-0.3303D-01,-0.4548D-01,-0.6232D-01,
     ,  -0.8496D-01,-0.1151D+00,-0.1548D+00,-0.2064D+00,-0.2721D+00,
     ,  -0.3538D+00,-0.4520D+00,-0.5643D+00,-0.6828D+00,-0.7911D+00,
     ,  -0.8594D+00,-0.8396D+00,-0.6572D+00,-0.1965D+00, 0.7388D+00,
     ,   0.2508D+01, 0.5776D+01, 0.1171D+02, 0.2223D+02, 0.4035D+02,
     ,   0.7060D+02, 0.1198D+03, 0.1980D+03, 0.3200D+03, 0.5079D+03,
     ,   0.7936D+03, 0.1224D+04, 0.1869D+04, 0.2830D+04, 0.4256D+04,
     ,   0.6365D+04, 0.9478D+04, 0.1407D+05, 0.2082D+05, 0.3076D+05,
     ,   0.4537D+05, 0.6684D+05, 0.9837D+05/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.3144D-06,-0.4520D-06,-0.6495D-06,-0.9329D-06,-0.1339D-05,
     ,  -0.1922D-05,-0.2757D-05,-0.3951D-05,-0.5661D-05,-0.8105D-05,
     ,  -0.1160D-04,-0.1658D-04,-0.2369D-04,-0.3383D-04,-0.4827D-04,
     ,  -0.6881D-04,-0.9800D-04,-0.1394D-03,-0.1982D-03,-0.2815D-03,
     ,  -0.3993D-03,-0.5656D-03,-0.8003D-03,-0.1131D-02,-0.1595D-02,
     ,  -0.2247D-02,-0.3158D-02,-0.4432D-02,-0.6205D-02,-0.8668D-02,
     ,  -0.1208D-01,-0.1678D-01,-0.2323D-01,-0.3205D-01,-0.4403D-01,
     ,  -0.6020D-01,-0.8184D-01,-0.1105D+00,-0.1481D+00,-0.1965D+00,
     ,  -0.2575D+00,-0.3325D+00,-0.4210D+00,-0.5192D+00,-0.6177D+00,
     ,  -0.6975D+00,-0.7260D+00,-0.6507D+00,-0.3912D+00, 0.1788D+00,
     ,   0.1274D+01, 0.3289D+01, 0.6947D+01, 0.1351D+02, 0.2505D+02,
     ,   0.4476D+02, 0.7753D+02, 0.1306D+03, 0.2147D+03, 0.3457D+03,
     ,   0.5469D+03, 0.8526D+03, 0.1313D+04, 0.2002D+04, 0.3027D+04,
     ,   0.4548D+04, 0.6797D+04, 0.1012D+05, 0.1501D+05, 0.2221D+05,
     ,   0.3280D+05, 0.4837D+05, 0.7124D+05/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.2166D-06,-0.3114D-06,-0.4476D-06,-0.6431D-06,-0.9235D-06,
     ,  -0.1326D-05,-0.1902D-05,-0.2727D-05,-0.3908D-05,-0.5596D-05,
     ,  -0.8010D-05,-0.1146D-04,-0.1638D-04,-0.2339D-04,-0.3339D-04,
     ,  -0.4761D-04,-0.6785D-04,-0.9659D-04,-0.1374D-03,-0.1952D-03,
     ,  -0.2770D-03,-0.3927D-03,-0.5559D-03,-0.7860D-03,-0.1110D-02,
     ,  -0.1564D-02,-0.2201D-02,-0.3092D-02,-0.4333D-02,-0.6061D-02,
     ,  -0.8455D-02,-0.1176D-01,-0.1632D-01,-0.2255D-01,-0.3105D-01,
     ,  -0.4257D-01,-0.5804D-01,-0.7867D-01,-0.1059D+00,-0.1412D+00,
     ,  -0.1865D+00,-0.2429D+00,-0.3111D+00,-0.3898D+00,-0.4739D+00,
     ,  -0.5523D+00,-0.6037D+00,-0.5924D+00,-0.4618D+00,-0.1254D+00,
     ,   0.5535D+00, 0.1809D+01, 0.4068D+01, 0.8114D+01, 0.1530D+02,
     ,   0.2784D+02, 0.4916D+02, 0.8442D+02, 0.1413D+03, 0.2313D+03,
     ,   0.3712D+03, 0.5857D+03, 0.9112D+03, 0.1401D+04, 0.2133D+04,
     ,   0.3223D+04, 0.4838D+04, 0.7226D+04, 0.1075D+05, 0.1594D+05,
     ,   0.2358D+05, 0.3482D+05, 0.5134D+05/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.1491D-06,-0.2145D-06,-0.3084D-06,-0.4432D-06,-0.6366D-06,
     ,  -0.9139D-06,-0.1311D-05,-0.1881D-05,-0.2696D-05,-0.3863D-05,
     ,  -0.5530D-05,-0.7913D-05,-0.1131D-04,-0.1617D-04,-0.2308D-04,
     ,  -0.3293D-04,-0.4695D-04,-0.6687D-04,-0.9515D-04,-0.1353D-03,
     ,  -0.1921D-03,-0.2724D-03,-0.3859D-03,-0.5460D-03,-0.7715D-03,
     ,  -0.1088D-02,-0.1533D-02,-0.2155D-02,-0.3024D-02,-0.4234D-02,
     ,  -0.5914D-02,-0.8240D-02,-0.1145D-01,-0.1585D-01,-0.2187D-01,
     ,  -0.3005D-01,-0.4109D-01,-0.5588D-01,-0.7549D-01,-0.1012D+00,
     ,  -0.1344D+00,-0.1764D+00,-0.2282D+00,-0.2897D+00,-0.3585D+00,
     ,  -0.4286D+00,-0.4868D+00,-0.5099D+00,-0.4588D+00,-0.2730D+00,
     ,   0.1402D+00, 0.9277D+00, 0.2342D+01, 0.4845D+01, 0.9278D+01,
     ,   0.1709D+02, 0.3063D+02, 0.5354D+02, 0.9129D+02, 0.1520D+03,
     ,   0.2479D+03, 0.3966D+03, 0.6244D+03, 0.9696D+03, 0.1489D+04,
     ,   0.2264D+04, 0.3417D+04, 0.5127D+04, 0.7653D+04, 0.1138D+05,
     ,   0.1687D+05, 0.2495D+05, 0.3684D+05/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.1027D-06,-0.1477D-06,-0.2124D-06,-0.3053D-06,-0.4386D-06,
     ,  -0.6299D-06,-0.9041D-06,-0.1297D-05,-0.1860D-05,-0.2665D-05,
     ,  -0.3817D-05,-0.5463D-05,-0.7814D-05,-0.1117D-04,-0.1595D-04,
     ,  -0.2277D-04,-0.3247D-04,-0.4627D-04,-0.6587D-04,-0.9368D-04,
     ,  -0.1331D-03,-0.1889D-03,-0.2678D-03,-0.3791D-03,-0.5360D-03,
     ,  -0.7568D-03,-0.1067D-02,-0.1501D-02,-0.2108D-02,-0.2955D-02,
     ,  -0.4133D-02,-0.5766D-02,-0.8022D-02,-0.1113D-01,-0.1538D-01,
     ,  -0.2118D-01,-0.2904D-01,-0.3960D-01,-0.5370D-01,-0.7229D-01,
     ,  -0.9651D-01,-0.1275D+00,-0.1663D+00,-0.2135D+00,-0.2682D+00,
     ,  -0.3272D+00,-0.3832D+00,-0.4213D+00,-0.4160D+00,-0.3252D+00,
     ,  -0.8430D-01, 0.4056D+00, 0.1301D+01, 0.2875D+01, 0.5621D+01,
     ,   0.1044D+02, 0.1887D+02, 0.3341D+02, 0.5790D+02, 0.9813D+02,
     ,   0.1627D+03, 0.2644D+03, 0.4219D+03, 0.6629D+03, 0.1028D+04,
     ,   0.1576D+04, 0.2395D+04, 0.3612D+04, 0.5415D+04, 0.8079D+04,
     ,   0.1201D+05, 0.1780D+05, 0.2632D+05/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.7067D-07,-0.1017D-06,-0.1462D-06,-0.2103D-06,-0.3021D-06,
     ,  -0.4340D-06,-0.6231D-06,-0.8941D-06,-0.1282D-05,-0.1838D-05,
     ,  -0.2633D-05,-0.3770D-05,-0.5395D-05,-0.7714D-05,-0.1102D-04,
     ,  -0.1574D-04,-0.2245D-04,-0.3201D-04,-0.4559D-04,-0.6487D-04,
     ,  -0.9221D-04,-0.1309D-03,-0.1857D-03,-0.2631D-03,-0.3723D-03,
     ,  -0.5259D-03,-0.7419D-03,-0.1045D-02,-0.1469D-02,-0.2061D-02,
     ,  -0.2886D-02,-0.4032D-02,-0.5617D-02,-0.7804D-02,-0.1081D-01,
     ,  -0.1491D-01,-0.2049D-01,-0.2802D-01,-0.3811D-01,-0.5151D-01,
     ,  -0.6908D-01,-0.9180D-01,-0.1206D+00,-0.1562D+00,-0.1987D+00,
     ,  -0.2466D+00,-0.2959D+00,-0.3377D+00,-0.3558D+00,-0.3220D+00,
     ,  -0.1916D+00, 0.1044D+00, 0.6708D+00, 0.1675D+01, 0.3407D+01,
     ,   0.6396D+01, 0.1160D+02, 0.2065D+02, 0.3618D+02, 0.6225D+02,
     ,   0.1050D+03, 0.1734D+03, 0.2808D+03, 0.4472D+03, 0.7013D+03,
     ,   0.1086D+04, 0.1663D+04, 0.2525D+04, 0.3805D+04, 0.5702D+04,
     ,   0.8504D+04, 0.1264D+05, 0.1872D+05/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.4863D-07,-0.6999D-07,-0.1007D-06,-0.1448D-06,-0.2081D-06,
     ,  -0.2990D-06,-0.4293D-06,-0.6162D-06,-0.8841D-06,-0.1268D-05,
     ,  -0.1816D-05,-0.2602D-05,-0.3724D-05,-0.5326D-05,-0.7613D-05,
     ,  -0.1087D-04,-0.1552D-04,-0.2213D-04,-0.3154D-04,-0.4490D-04,
     ,  -0.6386D-04,-0.9072D-04,-0.1288D-03,-0.1825D-03,-0.2584D-03,
     ,  -0.3654D-03,-0.5158D-03,-0.7271D-03,-0.1023D-02,-0.1437D-02,
     ,  -0.2014D-02,-0.2817D-02,-0.3930D-02,-0.5468D-02,-0.7585D-02,
     ,  -0.1049D-01,-0.1444D-01,-0.1980D-01,-0.2700D-01,-0.3662D-01,
     ,  -0.4932D-01,-0.6587D-01,-0.8709D-01,-0.1137D+00,-0.1461D+00,
     ,  -0.1839D+00,-0.2250D+00,-0.2645D+00,-0.2922D+00,-0.2902D+00,
     ,  -0.2281D+00,-0.5802D-01, 0.2930D+00, 0.9358D+00, 0.2048D+01,
     ,   0.3938D+01, 0.7169D+01, 0.1276D+02, 0.2243D+02, 0.3895D+02,
     ,   0.6660D+02, 0.1118D+03, 0.1840D+03, 0.2973D+03, 0.4723D+03,
     ,   0.7396D+03, 0.1144D+04, 0.1750D+04, 0.2655D+04, 0.3998D+04,
     ,   0.5988D+04, 0.8928D+04, 0.1326D+05/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.3346D-07,-0.4816D-07,-0.6930D-07,-0.9967D-07,-0.1433D-06,
     ,  -0.2059D-06,-0.2958D-06,-0.4246D-06,-0.6094D-06,-0.8739D-06,
     ,  -0.1253D-05,-0.1795D-05,-0.2570D-05,-0.3677D-05,-0.5257D-05,
     ,  -0.7512D-05,-0.1073D-04,-0.1530D-04,-0.2181D-04,-0.3107D-04,
     ,  -0.4421D-04,-0.6284D-04,-0.8923D-04,-0.1266D-03,-0.1793D-03,
     ,  -0.2537D-03,-0.3584D-03,-0.5056D-03,-0.7121D-03,-0.1001D-02,
     ,  -0.1405D-02,-0.1967D-02,-0.2748D-02,-0.3828D-02,-0.5319D-02,
     ,  -0.7366D-02,-0.1016D-01,-0.1397D-01,-0.1910D-01,-0.2599D-01,
     ,  -0.3512D-01,-0.4712D-01,-0.6265D-01,-0.8237D-01,-0.1068D+00,
     ,  -0.1360D+00,-0.1691D+00,-0.2035D+00,-0.2331D+00,-0.2468D+00,
     ,  -0.2246D+00,-0.1342D+00, 0.7553D-01, 0.4815D+00, 0.1201D+01,
     ,   0.2421D+01, 0.4469D+01, 0.7942D+01, 0.1391D+02, 0.2420D+02,
     ,   0.4172D+02, 0.7094D+02, 0.1186D+03, 0.1946D+03, 0.3137D+03,
     ,   0.4975D+03, 0.7779D+03, 0.1201D+04, 0.1837D+04, 0.2784D+04,
     ,   0.4191D+04, 0.6275D+04, 0.9352D+04/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.2302D-07,-0.3314D-07,-0.4769D-07,-0.6861D-07,-0.9866D-07,
     ,  -0.1418D-06,-0.2037D-06,-0.2926D-06,-0.4199D-06,-0.6024D-06,
     ,  -0.8638D-06,-0.1238D-05,-0.1773D-05,-0.2537D-05,-0.3629D-05,
     ,  -0.5188D-05,-0.7410D-05,-0.1058D-04,-0.1508D-04,-0.2149D-04,
     ,  -0.3060D-04,-0.4351D-04,-0.6182D-04,-0.8774D-04,-0.1244D-03,
     ,  -0.1761D-03,-0.2490D-03,-0.3515D-03,-0.4955D-03,-0.6972D-03,
     ,  -0.9792D-03,-0.1373D-02,-0.1920D-02,-0.2678D-02,-0.3726D-02,
     ,  -0.5169D-02,-0.7146D-02,-0.9841D-02,-0.1349D-01,-0.1841D-01,
     ,  -0.2497D-01,-0.3363D-01,-0.4493D-01,-0.5943D-01,-0.7764D-01,
     ,  -0.9987D-01,-0.1259D+00,-0.1543D+00,-0.1819D+00,-0.2017D+00,
     ,  -0.2013D+00,-0.1591D+00,-0.4024D-01, 0.2091D+00, 0.6700D+00,
     ,   0.1466D+01, 0.2794D+01, 0.5000D+01, 0.8715D+01, 0.1507D+02,
     ,   0.2597D+02, 0.4448D+02, 0.7528D+02, 0.1254D+03, 0.2052D+03,
     ,   0.3301D+03, 0.5226D+03, 0.8161D+03, 0.1259D+04, 0.1924D+04,
     ,   0.2914D+04, 0.4384D+04, 0.6561D+04/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.1583D-07,-0.2280D-07,-0.3282D-07,-0.4722D-07,-0.6792D-07,
     ,  -0.9764D-07,-0.1403D-06,-0.2015D-06,-0.2894D-06,-0.4152D-06,
     ,  -0.5955D-06,-0.8536D-06,-0.1223D-05,-0.1751D-05,-0.2505D-05,
     ,  -0.3582D-05,-0.5118D-05,-0.7308D-05,-0.1043D-04,-0.1486D-04,
     ,  -0.2117D-04,-0.3012D-04,-0.4282D-04,-0.6080D-04,-0.8624D-04,
     ,  -0.1222D-03,-0.1729D-03,-0.2442D-03,-0.3445D-03,-0.4852D-03,
     ,  -0.6822D-03,-0.9573D-03,-0.1340D-02,-0.1872D-02,-0.2609D-02,
     ,  -0.3624D-02,-0.5019D-02,-0.6926D-02,-0.9518D-02,-0.1302D-01,
     ,  -0.1771D-01,-0.2394D-01,-0.3213D-01,-0.4273D-01,-0.5620D-01,
     ,  -0.7292D-01,-0.9295D-01,-0.1157D+00,-0.1395D+00,-0.1603D+00,
     ,  -0.1703D+00,-0.1558D+00,-0.9348D-01, 0.5367D-01, 0.3426D+00,
     ,   0.8584D+00, 0.1730D+01, 0.3167D+01, 0.5531D+01, 0.9488D+01,
     ,   0.1622D+02, 0.2775D+02, 0.4725D+02, 0.7962D+02, 0.1322D+03,
     ,   0.2158D+03, 0.3465D+03, 0.5478D+03, 0.8543D+03, 0.1317D+04,
     ,   0.2010D+04, 0.3043D+04, 0.4577D+04/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.1089D-07,-0.1568D-07,-0.2258D-07,-0.3250D-07,-0.4675D-07,
     ,  -0.6722D-07,-0.9662D-07,-0.1388D-06,-0.1993D-06,-0.2861D-06,
     ,  -0.4105D-06,-0.5886D-06,-0.8434D-06,-0.1208D-05,-0.1729D-05,
     ,  -0.2473D-05,-0.3535D-05,-0.5049D-05,-0.7206D-05,-0.1028D-04,
     ,  -0.1464D-04,-0.2085D-04,-0.2965D-04,-0.4212D-04,-0.5978D-04,
     ,  -0.8475D-04,-0.1200D-03,-0.1696D-03,-0.2395D-03,-0.3376D-03,
     ,  -0.4750D-03,-0.6672D-03,-0.9352D-03,-0.1308D-02,-0.1825D-02,
     ,  -0.2539D-02,-0.3522D-02,-0.4869D-02,-0.6706D-02,-0.9195D-02,
     ,  -0.1254D-01,-0.1702D-01,-0.2292D-01,-0.3063D-01,-0.4053D-01,
     ,  -0.5298D-01,-0.6819D-01,-0.8603D-01,-0.1056D+00,-0.1247D+00,
     ,  -0.1387D+00,-0.1389D+00,-0.1103D+00,-0.2791D-01, 0.1476D+00,
     ,   0.4761D+00, 0.1047D+01, 0.1995D+01, 0.3539D+01, 0.6062D+01,
     ,   0.1026D+02, 0.1738D+02, 0.2952D+02, 0.5001D+02, 0.8395D+02,
     ,   0.1390D+03, 0.2264D+03, 0.3628D+03, 0.5729D+03, 0.8925D+03,
     ,   0.1375D+04, 0.2097D+04, 0.3173D+04/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.7489D-08,-0.1079D-07,-0.1553D-07,-0.2236D-07,-0.3217D-07,
     ,  -0.4627D-07,-0.6653D-07,-0.9560D-07,-0.1373D-06,-0.1971D-06,
     ,  -0.2829D-06,-0.4057D-06,-0.5816D-06,-0.8332D-06,-0.1193D-05,
     ,  -0.1707D-05,-0.2441D-05,-0.3487D-05,-0.4979D-05,-0.7104D-05,
     ,  -0.1013D-04,-0.1442D-04,-0.2052D-04,-0.2917D-04,-0.4143D-04,
     ,  -0.5876D-04,-0.8325D-04,-0.1178D-03,-0.1664D-03,-0.2347D-03,
     ,  -0.3306D-03,-0.4648D-03,-0.6522D-03,-0.9132D-03,-0.1276D-02,
     ,  -0.1777D-02,-0.2469D-02,-0.3420D-02,-0.4719D-02,-0.6485D-02,
     ,  -0.8871D-02,-0.1207D-01,-0.1632D-01,-0.2190D-01,-0.2913D-01,
     ,  -0.3833D-01,-0.4975D-01,-0.6347D-01,-0.7911D-01,-0.9549D-01,
     ,  -0.1099D+00,-0.1171D+00,-0.1075D+00,-0.6479D-01, 0.3766D-01,
     ,   0.2415D+00, 0.6096D+00, 0.1235D+01, 0.2260D+01, 0.3912D+01,
     ,   0.6592D+01, 0.1103D+02, 0.1853D+02, 0.3129D+02, 0.5277D+02,
     ,   0.8828D+02, 0.1458D+03, 0.2370D+03, 0.3792D+03, 0.5980D+03,
     ,   0.9307D+03, 0.1432D+04, 0.2183D+04/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.5150D-08,-0.7420D-08,-0.1069D-07,-0.1538D-07,-0.2214D-07,
     ,  -0.3185D-07,-0.4580D-07,-0.6583D-07,-0.9458D-07,-0.1358D-06,
     ,  -0.1949D-06,-0.2797D-06,-0.4010D-06,-0.5746D-06,-0.8230D-06,
     ,  -0.1178D-05,-0.1685D-05,-0.2408D-05,-0.3440D-05,-0.4910D-05,
     ,  -0.7002D-05,-0.9977D-05,-0.1420D-04,-0.2020D-04,-0.2870D-04,
     ,  -0.4073D-04,-0.5774D-04,-0.8175D-04,-0.1156D-03,-0.1632D-03,
     ,  -0.2300D-03,-0.3237D-03,-0.4546D-03,-0.6372D-03,-0.8912D-03,
     ,  -0.1243D-02,-0.1730D-02,-0.2400D-02,-0.3318D-02,-0.4569D-02,
     ,  -0.6265D-02,-0.8548D-02,-0.1160D-01,-0.1562D-01,-0.2088D-01,
     ,  -0.2763D-01,-0.3613D-01,-0.4653D-01,-0.5874D-01,-0.7218D-01,
     ,  -0.8535D-01,-0.9511D-01,-0.9551D-01,-0.7611D-01,-0.1930D-01,
     ,   0.1032D+00, 0.3354D+00, 0.7430D+00, 0.1424D+01, 0.2525D+01,
     ,   0.4284D+01, 0.7122D+01, 0.1180D+02, 0.1969D+02, 0.3306D+02,
     ,   0.5553D+02, 0.9261D+02, 0.1525D+03, 0.2475D+03, 0.3956D+03,
     ,   0.6231D+03, 0.9689D+03, 0.1490D+04/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.3541D-08,-0.5103D-08,-0.7350D-08,-0.1058D-07,-0.1523D-07,
     ,  -0.2192D-07,-0.3153D-07,-0.4533D-07,-0.6513D-07,-0.9356D-07,
     ,  -0.1343D-06,-0.1927D-06,-0.2764D-06,-0.3963D-06,-0.5677D-06,
     ,  -0.8128D-06,-0.1163D-05,-0.1663D-05,-0.2376D-05,-0.3393D-05,
     ,  -0.4840D-05,-0.6900D-05,-0.9827D-05,-0.1398D-04,-0.1988D-04,
     ,  -0.2823D-04,-0.4004D-04,-0.5672D-04,-0.8024D-04,-0.1134D-03,
     ,  -0.1599D-03,-0.2253D-03,-0.3167D-03,-0.4444D-03,-0.6222D-03,
     ,  -0.8692D-03,-0.1211D-02,-0.1683D-02,-0.2330D-02,-0.3215D-02,
     ,  -0.4419D-02,-0.6045D-02,-0.8225D-02,-0.1112D-01,-0.1493D-01,
     ,  -0.1986D-01,-0.2613D-01,-0.3393D-01,-0.4330D-01,-0.5401D-01,
     ,  -0.6526D-01,-0.7522D-01,-0.8030D-01,-0.7392D-01,-0.4470D-01,
     ,   0.2619D-01, 0.1688D+00, 0.4293D+00, 0.8765D+00, 0.1612D+01,
     ,   0.2789D+01, 0.4657D+01, 0.7653D+01, 0.1258D+02, 0.2084D+02,
     ,   0.3483D+02, 0.5829D+02, 0.9694D+02, 0.1593D+03, 0.2581D+03,
     ,   0.4119D+03, 0.6482D+03, 0.1007D+04/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.2435D-08,-0.3509D-08,-0.5055D-08,-0.7280D-08,-0.1048D-07,
     ,  -0.1508D-07,-0.2170D-07,-0.3120D-07,-0.4485D-07,-0.6444D-07,
     ,  -0.9253D-07,-0.1328D-06,-0.1905D-06,-0.2732D-06,-0.3915D-06,
     ,  -0.5607D-06,-0.8025D-06,-0.1148D-05,-0.1641D-05,-0.2344D-05,
     ,  -0.3345D-05,-0.4770D-05,-0.6797D-05,-0.9677D-05,-0.1376D-04,
     ,  -0.1955D-04,-0.2775D-04,-0.3934D-04,-0.5569D-04,-0.7874D-04,
     ,  -0.1112D-03,-0.1567D-03,-0.2205D-03,-0.3097D-03,-0.4341D-03,
     ,  -0.6072D-03,-0.8471D-03,-0.1179D-02,-0.1635D-02,-0.2260D-02,
     ,  -0.3113D-02,-0.4269D-02,-0.5824D-02,-0.7901D-02,-0.1065D-01,
     ,  -0.1423D-01,-0.1883D-01,-0.2463D-01,-0.3173D-01,-0.4008D-01,
     ,  -0.4928D-01,-0.5833D-01,-0.6509D-01,-0.6549D-01,-0.5233D-01,
     ,  -0.1330D-01, 0.7168D-01, 0.2344D+00, 0.5232D+00, 0.1010D+01,
     ,   0.1800D+01, 0.3054D+01, 0.5029D+01, 0.8183D+01, 0.1335D+02,
     ,   0.2200D+02, 0.3660D+02, 0.6105D+02, 0.1013D+03, 0.1661D+03,
     ,   0.2687D+03, 0.4283D+03, 0.6732D+03/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.1674D-08,-0.2413D-08,-0.3476D-08,-0.5008D-08,-0.7211D-08,
     ,  -0.1038D-07,-0.1493D-07,-0.2148D-07,-0.3088D-07,-0.4438D-07,
     ,  -0.6374D-07,-0.9151D-07,-0.1313D-06,-0.1883D-06,-0.2700D-06,
     ,  -0.3868D-06,-0.5537D-06,-0.7923D-06,-0.1133D-05,-0.1619D-05,
     ,  -0.2311D-05,-0.3298D-05,-0.4701D-05,-0.6695D-05,-0.9527D-05,
     ,  -0.1354D-04,-0.1923D-04,-0.2728D-04,-0.3864D-04,-0.5467D-04,
     ,  -0.7724D-04,-0.1090D-03,-0.1535D-03,-0.2158D-03,-0.3027D-03,
     ,  -0.4239D-03,-0.5922D-03,-0.8251D-03,-0.1146D-02,-0.1588D-02,
     ,  -0.2191D-02,-0.3011D-02,-0.4119D-02,-0.5604D-02,-0.7578D-02,
     ,  -0.1017D-01,-0.1353D-01,-0.1781D-01,-0.2313D-01,-0.2953D-01,
     ,  -0.3685D-01,-0.4455D-01,-0.5141D-01,-0.5495D-01,-0.5069D-01,
     ,  -0.3073D-01, 0.1810D-01, 0.1172D+00, 0.2999D+00, 0.6170D+00,
     ,   0.1143D+01, 0.1989D+01, 0.3318D+01, 0.5402D+01, 0.8713D+01,
     ,   0.1412D+02, 0.2315D+02, 0.3837D+02, 0.6380D+02, 0.1056D+03,
     ,   0.1729D+03, 0.2793D+03, 0.4446D+03/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.1150D-08,-0.1659D-08,-0.2390D-08,-0.3444D-08,-0.4960D-08,
     ,  -0.7141D-08,-0.1028D-07,-0.1478D-07,-0.2126D-07,-0.3056D-07,
     ,  -0.4390D-07,-0.6304D-07,-0.9049D-07,-0.1298D-06,-0.1861D-06,
     ,  -0.2667D-06,-0.3820D-06,-0.5468D-06,-0.7821D-06,-0.1118D-05,
     ,  -0.1597D-05,-0.2279D-05,-0.3250D-05,-0.4631D-05,-0.6593D-05,
     ,  -0.9377D-05,-0.1332D-04,-0.1891D-04,-0.2680D-04,-0.3794D-04,
     ,  -0.5365D-04,-0.7574D-04,-0.1068D-03,-0.1502D-03,-0.2110D-03,
     ,  -0.2958D-03,-0.4137D-03,-0.5771D-03,-0.8030D-03,-0.1114D-02,
     ,  -0.1540D-02,-0.2121D-02,-0.2908D-02,-0.3968D-02,-0.5384D-02,
     ,  -0.7254D-02,-0.9697D-02,-0.1284D-01,-0.1679D-01,-0.2163D-01,
     ,  -0.2733D-01,-0.3362D-01,-0.3983D-01,-0.4448D-01,-0.4482D-01,
     ,  -0.3588D-01,-0.9141D-02, 0.4950D-01, 0.1627D+00, 0.3655D+00,
     ,   0.7109D+00, 0.1277D+01, 0.2177D+01, 0.3583D+01, 0.5774D+01,
     ,   0.9244D+01, 0.1489D+02, 0.2430D+02, 0.4014D+02, 0.6656D+02,
     ,   0.1099D+03, 0.1797D+03, 0.2898D+03/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine c3hqps20cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,   0.1249D-05, 0.1833D-05, 0.2690D-05, 0.3949D-05, 0.5796D-05,
     ,   0.8507D-05, 0.1249D-04, 0.1833D-04, 0.2690D-04, 0.3949D-04,
     ,   0.5796D-04, 0.8507D-04, 0.1249D-03, 0.1833D-03, 0.2690D-03,
     ,   0.3948D-03, 0.5795D-03, 0.8506D-03, 0.1248D-02, 0.1832D-02,
     ,   0.2689D-02, 0.3946D-02, 0.5790D-02, 0.8495D-02, 0.1246D-01,
     ,   0.1827D-01, 0.2678D-01, 0.3923D-01, 0.5740D-01, 0.8387D-01,
     ,   0.1223D+00, 0.1778D+00, 0.2575D+00, 0.3706D+00, 0.5291D+00,
     ,   0.7472D+00, 0.1040D+01, 0.1424D+01, 0.1911D+01, 0.2512D+01,
     ,   0.3237D+01, 0.4109D+01, 0.5165D+01, 0.6477D+01, 0.8156D+01,
     ,   0.1035D+02, 0.1325D+02, 0.1708D+02, 0.2213D+02, 0.2883D+02,
     ,   0.3781D+02, 0.4999D+02, 0.6685D+02, 0.9054D+02, 0.1244D+03,
     ,   0.1732D+03, 0.2443D+03, 0.3484D+03, 0.5014D+03, 0.7264D+03,
     ,   0.1058D+04, 0.1546D+04, 0.2265D+04, 0.3323D+04, 0.4880D+04,
     ,   0.7171D+04, 0.1054D+05, 0.1549D+05, 0.2276D+05, 0.3345D+05,
     ,   0.4914D+05, 0.7219D+05, 0.1060D+06/
      data (calcpts(j, 2), j = 1,neta) /
     ,   0.1112D-05, 0.1632D-05, 0.2396D-05, 0.3517D-05, 0.5162D-05,
     ,   0.7576D-05, 0.1112D-04, 0.1632D-04, 0.2396D-04, 0.3517D-04,
     ,   0.5162D-04, 0.7576D-04, 0.1112D-03, 0.1632D-03, 0.2396D-03,
     ,   0.3516D-03, 0.5161D-03, 0.7575D-03, 0.1112D-02, 0.1632D-02,
     ,   0.2395D-02, 0.3515D-02, 0.5158D-02, 0.7568D-02, 0.1110D-01,
     ,   0.1629D-01, 0.2388D-01, 0.3500D-01, 0.5126D-01, 0.7501D-01,
     ,   0.1096D+00, 0.1598D+00, 0.2323D+00, 0.3362D+00, 0.4837D+00,
     ,   0.6902D+00, 0.9743D+00, 0.1356D+01, 0.1857D+01, 0.2495D+01,
     ,   0.3288D+01, 0.4260D+01, 0.5448D+01, 0.6919D+01, 0.8786D+01,
     ,   0.1122D+02, 0.1445D+02, 0.1877D+02, 0.2457D+02, 0.3234D+02,
     ,   0.4278D+02, 0.5693D+02, 0.7630D+02, 0.1032D+03, 0.1410D+03,
     ,   0.1948D+03, 0.2722D+03, 0.3842D+03, 0.5473D+03, 0.7857D+03,
     ,   0.1135D+04, 0.1647D+04, 0.2399D+04, 0.3504D+04, 0.5127D+04,
     ,   0.7511D+04, 0.1101D+05, 0.1616D+05, 0.2371D+05, 0.3481D+05,
     ,   0.5110D+05, 0.7503D+05, 0.1102D+06/
      data (calcpts(j, 3), j = 1,neta) /
     ,   0.9745D-06, 0.1430D-05, 0.2100D-05, 0.3082D-05, 0.4523D-05,
     ,   0.6639D-05, 0.9745D-05, 0.1430D-04, 0.2100D-04, 0.3082D-04,
     ,   0.4523D-04, 0.6639D-04, 0.9745D-04, 0.1430D-03, 0.2099D-03,
     ,   0.3082D-03, 0.4523D-03, 0.6639D-03, 0.9744D-03, 0.1430D-02,
     ,   0.2099D-02, 0.3081D-02, 0.4521D-02, 0.6635D-02, 0.9735D-02,
     ,   0.1428D-01, 0.2095D-01, 0.3072D-01, 0.4502D-01, 0.6594D-01,
     ,   0.9647D-01, 0.1409D+00, 0.2055D+00, 0.2986D+00, 0.4322D+00,
     ,   0.6217D+00, 0.8870D+00, 0.1252D+01, 0.1744D+01, 0.2389D+01,
     ,   0.3218D+01, 0.4261D+01, 0.5562D+01, 0.7193D+01, 0.9277D+01,
     ,   0.1201D+02, 0.1568D+02, 0.2069D+02, 0.2758D+02, 0.3708D+02,
     ,   0.5017D+02, 0.6823D+02, 0.9328D+02, 0.1283D+03, 0.1777D+03,
     ,   0.2480D+03, 0.3488D+03, 0.4944D+03, 0.7055D+03, 0.1013D+04,
     ,   0.1462D+04, 0.2120D+04, 0.3083D+04, 0.4496D+04, 0.6568D+04,
     ,   0.9610D+04, 0.1408D+05, 0.2063D+05, 0.3025D+05, 0.4438D+05,
     ,   0.6512D+05, 0.9556D+05, 0.1403D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,   0.8390D-06, 0.1231D-05, 0.1807D-05, 0.2653D-05, 0.3894D-05,
     ,   0.5716D-05, 0.8389D-05, 0.1231D-04, 0.1807D-04, 0.2653D-04,
     ,   0.3894D-04, 0.5716D-04, 0.8389D-04, 0.1231D-03, 0.1807D-03,
     ,   0.2653D-03, 0.3894D-03, 0.5715D-03, 0.8389D-03, 0.1231D-02,
     ,   0.1807D-02, 0.2652D-02, 0.3893D-02, 0.5713D-02, 0.8384D-02,
     ,   0.1230D-01, 0.1805D-01, 0.2647D-01, 0.3881D-01, 0.5689D-01,
     ,   0.8331D-01, 0.1219D+00, 0.1781D+00, 0.2596D+00, 0.3773D+00,
     ,   0.5459D+00, 0.7853D+00, 0.1121D+01, 0.1582D+01, 0.2205D+01,
     ,   0.3026D+01, 0.4087D+01, 0.5439D+01, 0.7161D+01, 0.9378D+01,
     ,   0.1230D+02, 0.1625D+02, 0.2171D+02, 0.2936D+02, 0.4015D+02,
     ,   0.5536D+02, 0.7678D+02, 0.1070D+03, 0.1496D+03, 0.2102D+03,
     ,   0.2967D+03, 0.4210D+03, 0.6004D+03, 0.8606D+03, 0.1239D+04,
     ,   0.1791D+04, 0.2599D+04, 0.3781D+04, 0.5512D+04, 0.8051D+04,
     ,   0.1178D+05, 0.1724D+05, 0.2526D+05, 0.3703D+05, 0.5430D+05,
     ,   0.7965D+05, 0.1169D+06, 0.1715D+06/
      data (calcpts(j, 5), j = 1,neta) /
     ,   0.7095D-06, 0.1041D-05, 0.1529D-05, 0.2244D-05, 0.3293D-05,
     ,   0.4834D-05, 0.7095D-05, 0.1041D-04, 0.1529D-04, 0.2244D-04,
     ,   0.3293D-04, 0.4834D-04, 0.7095D-04, 0.1041D-03, 0.1529D-03,
     ,   0.2244D-03, 0.3293D-03, 0.4833D-03, 0.7094D-03, 0.1041D-02,
     ,   0.1528D-02, 0.2243D-02, 0.3292D-02, 0.4832D-02, 0.7091D-02,
     ,   0.1041D-01, 0.1527D-01, 0.2240D-01, 0.3286D-01, 0.4818D-01,
     ,   0.7061D-01, 0.1034D+00, 0.1513D+00, 0.2210D+00, 0.3222D+00,
     ,   0.4683D+00, 0.6776D+00, 0.9748D+00, 0.1391D+01, 0.1965D+01,
     ,   0.2740D+01, 0.3767D+01, 0.5103D+01, 0.6829D+01, 0.9067D+01,
     ,   0.1202D+02, 0.1601D+02, 0.2155D+02, 0.2940D+02, 0.4063D+02,
     ,   0.5674D+02, 0.7983D+02, 0.1128D+03, 0.1600D+03, 0.2275D+03,
     ,   0.3244D+03, 0.4639D+03, 0.6655D+03, 0.9578D+03, 0.1383D+04,
     ,   0.2003D+04, 0.2909D+04, 0.4235D+04, 0.6176D+04, 0.9021D+04,
     ,   0.1319D+05, 0.1931D+05, 0.2829D+05, 0.4146D+05, 0.6080D+05,
     ,   0.8917D+05, 0.1308D+06, 0.1920D+06/
      data (calcpts(j, 6), j = 1,neta) /
     ,   0.5900D-06, 0.8660D-06, 0.1271D-05, 0.1866D-05, 0.2738D-05,
     ,   0.4020D-05, 0.5900D-05, 0.8660D-05, 0.1271D-04, 0.1866D-04,
     ,   0.2738D-04, 0.4019D-04, 0.5900D-04, 0.8660D-04, 0.1271D-03,
     ,   0.1866D-03, 0.2738D-03, 0.4019D-03, 0.5900D-03, 0.8659D-03,
     ,   0.1271D-02, 0.1865D-02, 0.2738D-02, 0.4019D-02, 0.5898D-02,
     ,   0.8656D-02, 0.1270D-01, 0.1864D-01, 0.2734D-01, 0.4011D-01,
     ,   0.5881D-01, 0.8618D-01, 0.1262D+00, 0.1847D+00, 0.2698D+00,
     ,   0.3933D+00, 0.5716D+00, 0.8271D+00, 0.1190D+01, 0.1699D+01,
     ,   0.2400D+01, 0.3350D+01, 0.4612D+01, 0.6268D+01, 0.8430D+01,
     ,   0.1128D+02, 0.1512D+02, 0.2043D+02, 0.2796D+02, 0.3881D+02,
     ,   0.5457D+02, 0.7747D+02, 0.1107D+03, 0.1587D+03, 0.2279D+03,
     ,   0.3278D+03, 0.4721D+03, 0.6810D+03, 0.9842D+03, 0.1425D+04,
     ,   0.2068D+04, 0.3007D+04, 0.4381D+04, 0.6391D+04, 0.9337D+04,
     ,   0.1365D+05, 0.1999D+05, 0.2927D+05, 0.4290D+05, 0.6290D+05,
     ,   0.9225D+05, 0.1353D+06, 0.1985D+06/
      data (calcpts(j, 7), j = 1,neta) /
     ,   0.4831D-06, 0.7092D-06, 0.1041D-05, 0.1528D-05, 0.2243D-05,
     ,   0.3292D-05, 0.4831D-05, 0.7092D-05, 0.1041D-04, 0.1528D-04,
     ,   0.2243D-04, 0.3292D-04, 0.4831D-04, 0.7092D-04, 0.1041D-03,
     ,   0.1528D-03, 0.2243D-03, 0.3292D-03, 0.4831D-03, 0.7091D-03,
     ,   0.1041D-02, 0.1528D-02, 0.2242D-02, 0.3291D-02, 0.4830D-02,
     ,   0.7089D-02, 0.1040D-01, 0.1527D-01, 0.2240D-01, 0.3287D-01,
     ,   0.4821D-01, 0.7068D-01, 0.1036D+00, 0.1517D+00, 0.2220D+00,
     ,   0.3243D+00, 0.4727D+00, 0.6870D+00, 0.9943D+00, 0.1431D+01,
     ,   0.2042D+01, 0.2887D+01, 0.4033D+01, 0.5562D+01, 0.7579D+01,
     ,   0.1024D+02, 0.1380D+02, 0.1868D+02, 0.2555D+02, 0.3545D+02,
     ,   0.4992D+02, 0.7118D+02, 0.1024D+03, 0.1480D+03, 0.2143D+03,
     ,   0.3107D+03, 0.4506D+03, 0.6537D+03, 0.9487D+03, 0.1378D+04,
     ,   0.2004D+04, 0.2918D+04, 0.4255D+04, 0.6211D+04, 0.9075D+04,
     ,   0.1327D+05, 0.1943D+05, 0.2846D+05, 0.4170D+05, 0.6114D+05,
     ,   0.8966D+05, 0.1315D+06, 0.1929D+06/
      data (calcpts(j, 8), j = 1,neta) /
     ,   0.3903D-06, 0.5728D-06, 0.8408D-06, 0.1234D-05, 0.1811D-05,
     ,   0.2659D-05, 0.3903D-05, 0.5728D-05, 0.8408D-05, 0.1234D-04,
     ,   0.1811D-04, 0.2659D-04, 0.3903D-04, 0.5728D-04, 0.8408D-04,
     ,   0.1234D-03, 0.1811D-03, 0.2659D-03, 0.3902D-03, 0.5728D-03,
     ,   0.8407D-03, 0.1234D-02, 0.1811D-02, 0.2658D-02, 0.3902D-02,
     ,   0.5727D-02, 0.8405D-02, 0.1233D-01, 0.1810D-01, 0.2656D-01,
     ,   0.3897D-01, 0.5715D-01, 0.8380D-01, 0.1228D+00, 0.1799D+00,
     ,   0.2632D+00, 0.3845D+00, 0.5605D+00, 0.8146D+00, 0.1179D+01,
     ,   0.1697D+01, 0.2423D+01, 0.3426D+01, 0.4790D+01, 0.6615D+01,
     ,   0.9036D+01, 0.1226D+02, 0.1662D+02, 0.2269D+02, 0.3137D+02,
     ,   0.4404D+02, 0.6275D+02, 0.9047D+02, 0.1314D+03, 0.1917D+03,
     ,   0.2799D+03, 0.4086D+03, 0.5961D+03, 0.8692D+03, 0.1267D+04,
     ,   0.1848D+04, 0.2695D+04, 0.3934D+04, 0.5746D+04, 0.8401D+04,
     ,   0.1229D+05, 0.1799D+05, 0.2635D+05, 0.3861D+05, 0.5660D+05,
     ,   0.8300D+05, 0.1217D+06, 0.1786D+06/
      data (calcpts(j, 9), j = 1,neta) /
     ,   0.3114D-06, 0.4571D-06, 0.6709D-06, 0.9848D-06, 0.1445D-05,
     ,   0.2122D-05, 0.3114D-05, 0.4571D-05, 0.6709D-05, 0.9848D-05,
     ,   0.1445D-04, 0.2122D-04, 0.3114D-04, 0.4571D-04, 0.6709D-04,
     ,   0.9848D-04, 0.1445D-03, 0.2122D-03, 0.3114D-03, 0.4571D-03,
     ,   0.6709D-03, 0.9847D-03, 0.1445D-02, 0.2121D-02, 0.3114D-02,
     ,   0.4570D-02, 0.6708D-02, 0.9844D-02, 0.1445D-01, 0.2120D-01,
     ,   0.3111D-01, 0.4564D-01, 0.6694D-01, 0.9816D-01, 0.1439D+00,
     ,   0.2107D+00, 0.3082D+00, 0.4503D+00, 0.6565D+00, 0.9542D+00,
     ,   0.1381D+01, 0.1988D+01, 0.2839D+01, 0.4016D+01, 0.5619D+01,
     ,   0.7769D+01, 0.1064D+02, 0.1448D+02, 0.1975D+02, 0.2716D+02,
     ,   0.3788D+02, 0.5370D+02, 0.7727D+02, 0.1124D+03, 0.1646D+03,
     ,   0.2418D+03, 0.3553D+03, 0.5214D+03, 0.7642D+03, 0.1119D+04,
     ,   0.1636D+04, 0.2392D+04, 0.3497D+04, 0.5114D+04, 0.7482D+04,
     ,   0.1095D+05, 0.1603D+05, 0.2348D+05, 0.3441D+05, 0.5045D+05,
     ,   0.7397D+05, 0.1085D+06, 0.1592D+06/
      data (calcpts(j,10), j = 1,neta) /
     ,   0.2458D-06, 0.3608D-06, 0.5296D-06, 0.7774D-06, 0.1141D-05,
     ,   0.1675D-05, 0.2458D-05, 0.3608D-05, 0.5296D-05, 0.7774D-05,
     ,   0.1141D-04, 0.1675D-04, 0.2458D-04, 0.3608D-04, 0.5296D-04,
     ,   0.7774D-04, 0.1141D-03, 0.1675D-03, 0.2458D-03, 0.3608D-03,
     ,   0.5296D-03, 0.7774D-03, 0.1141D-02, 0.1675D-02, 0.2458D-02,
     ,   0.3608D-02, 0.5296D-02, 0.7772D-02, 0.1141D-01, 0.1674D-01,
     ,   0.2457D-01, 0.3605D-01, 0.5288D-01, 0.7757D-01, 0.1137D+00,
     ,   0.1667D+00, 0.2441D+00, 0.3572D+00, 0.5218D+00, 0.7608D+00,
     ,   0.1106D+01, 0.1601D+01, 0.2304D+01, 0.3291D+01, 0.4658D+01,
     ,   0.6520D+01, 0.9026D+01, 0.1238D+02, 0.1691D+02, 0.2317D+02,
     ,   0.3207D+02, 0.4508D+02, 0.6444D+02, 0.9348D+02, 0.1370D+03,
     ,   0.2020D+03, 0.2983D+03, 0.4404D+03, 0.6490D+03, 0.9547D+03,
     ,   0.1402D+04, 0.2056D+04, 0.3012D+04, 0.4411D+04, 0.6459D+04,
     ,   0.9459D+04, 0.1386D+05, 0.2030D+05, 0.2975D+05, 0.4362D+05,
     ,   0.6395D+05, 0.9380D+05, 0.1376D+06/
      data (calcpts(j,11), j = 1,neta) /
     ,   0.1922D-06, 0.2822D-06, 0.4142D-06, 0.6079D-06, 0.8923D-06,
     ,   0.1310D-05, 0.1922D-05, 0.2822D-05, 0.4142D-05, 0.6079D-05,
     ,   0.8923D-05, 0.1310D-04, 0.1922D-04, 0.2822D-04, 0.4142D-04,
     ,   0.6079D-04, 0.8923D-04, 0.1310D-03, 0.1922D-03, 0.2822D-03,
     ,   0.4141D-03, 0.6079D-03, 0.8922D-03, 0.1310D-02, 0.1922D-02,
     ,   0.2821D-02, 0.4141D-02, 0.6078D-02, 0.8921D-02, 0.1309D-01,
     ,   0.1921D-01, 0.2820D-01, 0.4137D-01, 0.6070D-01, 0.8903D-01,
     ,   0.1305D+00, 0.1913D+00, 0.2802D+00, 0.4100D+00, 0.5989D+00,
     ,   0.8732D+00, 0.1269D+01, 0.1837D+01, 0.2645D+01, 0.3779D+01,
     ,   0.5350D+01, 0.7493D+01, 0.1038D+02, 0.1427D+02, 0.1954D+02,
     ,   0.2689D+02, 0.3743D+02, 0.5296D+02, 0.7625D+02, 0.1114D+03,
     ,   0.1642D+03, 0.2434D+03, 0.3611D+03, 0.5352D+03, 0.7915D+03,
     ,   0.1167D+04, 0.1718D+04, 0.2525D+04, 0.3706D+04, 0.5435D+04,
     ,   0.7967D+04, 0.1168D+05, 0.1712D+05, 0.2509D+05, 0.3679D+05,
     ,   0.5395D+05, 0.7913D+05, 0.1161D+06/
      data (calcpts(j,12), j = 1,neta) /
     ,   0.1491D-06, 0.2188D-06, 0.3211D-06, 0.4714D-06, 0.6918D-06,
     ,   0.1015D-05, 0.1491D-05, 0.2188D-05, 0.3211D-05, 0.4714D-05,
     ,   0.6918D-05, 0.1015D-04, 0.1491D-04, 0.2188D-04, 0.3211D-04,
     ,   0.4714D-04, 0.6918D-04, 0.1015D-03, 0.1491D-03, 0.2188D-03,
     ,   0.3211D-03, 0.4713D-03, 0.6918D-03, 0.1015D-02, 0.1490D-02,
     ,   0.2188D-02, 0.3211D-02, 0.4713D-02, 0.6917D-02, 0.1015D-01,
     ,   0.1490D-01, 0.2187D-01, 0.3209D-01, 0.4709D-01, 0.6908D-01,
     ,   0.1013D+00, 0.1486D+00, 0.2177D+00, 0.3189D+00, 0.4666D+00,
     ,   0.6817D+00, 0.9939D+00, 0.1445D+01, 0.2092D+01, 0.3011D+01,
     ,   0.4303D+01, 0.6093D+01, 0.8538D+01, 0.1184D+02, 0.1630D+02,
     ,   0.2238D+02, 0.3090D+02, 0.4323D+02, 0.6153D+02, 0.8911D+02,
     ,   0.1309D+03, 0.1941D+03, 0.2889D+03, 0.4303D+03, 0.6397D+03,
     ,   0.9486D+03, 0.1402D+04, 0.2068D+04, 0.3044D+04, 0.4474D+04,
     ,   0.6568D+04, 0.9638D+04, 0.1414D+05, 0.2073D+05, 0.3041D+05,
     ,   0.4460D+05, 0.6541D+05, 0.9596D+05/
      data (calcpts(j,13), j = 1,neta) /
     ,   0.1147D-06, 0.1684D-06, 0.2471D-06, 0.3627D-06, 0.5324D-06,
     ,   0.7815D-06, 0.1147D-05, 0.1684D-05, 0.2471D-05, 0.3627D-05,
     ,   0.5324D-05, 0.7815D-05, 0.1147D-04, 0.1684D-04, 0.2471D-04,
     ,   0.3627D-04, 0.5324D-04, 0.7815D-04, 0.1147D-03, 0.1684D-03,
     ,   0.2471D-03, 0.3627D-03, 0.5324D-03, 0.7815D-03, 0.1147D-02,
     ,   0.1684D-02, 0.2471D-02, 0.3627D-02, 0.5324D-02, 0.7814D-02,
     ,   0.1147D-01, 0.1683D-01, 0.2470D-01, 0.3625D-01, 0.5319D-01,
     ,   0.7803D-01, 0.1145D+00, 0.1678D+00, 0.2460D+00, 0.3602D+00,
     ,   0.5271D+00, 0.7701D+00, 0.1123D+01, 0.1632D+01, 0.2363D+01,
     ,   0.3402D+01, 0.4862D+01, 0.6886D+01, 0.9655D+01, 0.1340D+02,
     ,   0.1847D+02, 0.2542D+02, 0.3521D+02, 0.4947D+02, 0.7077D+02,
     ,   0.1030D+03, 0.1521D+03, 0.2265D+03, 0.3384D+03, 0.5057D+03,
     ,   0.7539D+03, 0.1120D+04, 0.1660D+04, 0.2452D+04, 0.3613D+04,
     ,   0.5316D+04, 0.7812D+04, 0.1147D+05, 0.1684D+05, 0.2470D+05,
     ,   0.3624D+05, 0.5317D+05, 0.7800D+05/
      data (calcpts(j,14), j = 1,neta) /
     ,   0.8769D-07, 0.1287D-06, 0.1889D-06, 0.2773D-06, 0.4070D-06,
     ,   0.5974D-06, 0.8769D-06, 0.1287D-05, 0.1889D-05, 0.2773D-05,
     ,   0.4070D-05, 0.5974D-05, 0.8769D-05, 0.1287D-04, 0.1889D-04,
     ,   0.2773D-04, 0.4070D-04, 0.5974D-04, 0.8769D-04, 0.1287D-03,
     ,   0.1889D-03, 0.2773D-03, 0.4070D-03, 0.5974D-03, 0.8769D-03,
     ,   0.1287D-02, 0.1889D-02, 0.2773D-02, 0.4070D-02, 0.5973D-02,
     ,   0.8767D-02, 0.1287D-01, 0.1889D-01, 0.2772D-01, 0.4067D-01,
     ,   0.5968D-01, 0.8756D-01, 0.1284D+00, 0.1883D+00, 0.2760D+00,
     ,   0.4042D+00, 0.5914D+00, 0.8641D+00, 0.1260D+01, 0.1831D+01,
     ,   0.2652D+01, 0.3818D+01, 0.5457D+01, 0.7731D+01, 0.1084D+02,
     ,   0.1506D+02, 0.2078D+02, 0.2866D+02, 0.3982D+02, 0.5616D+02,
     ,   0.8069D+02, 0.1180D+03, 0.1750D+03, 0.2615D+03, 0.3920D+03,
     ,   0.5873D+03, 0.8776D+03, 0.1307D+04, 0.1939D+04, 0.2868D+04,
     ,   0.4232D+04, 0.6232D+04, 0.9165D+04, 0.1347D+05, 0.1977D+05,
     ,   0.2902D+05, 0.4259D+05, 0.6250D+05/
      data (calcpts(j,15), j = 1,neta) /
     ,   0.6663D-07, 0.9780D-07, 0.1435D-06, 0.2107D-06, 0.3093D-06,
     ,   0.4539D-06, 0.6663D-06, 0.9780D-06, 0.1435D-05, 0.2107D-05,
     ,   0.3093D-05, 0.4539D-05, 0.6663D-05, 0.9780D-05, 0.1435D-04,
     ,   0.2107D-04, 0.3093D-04, 0.4539D-04, 0.6663D-04, 0.9780D-04,
     ,   0.1435D-03, 0.2107D-03, 0.3093D-03, 0.4539D-03, 0.6663D-03,
     ,   0.9779D-03, 0.1435D-02, 0.2107D-02, 0.3092D-02, 0.4539D-02,
     ,   0.6662D-02, 0.9778D-02, 0.1435D-01, 0.2106D-01, 0.3091D-01,
     ,   0.4536D-01, 0.6656D-01, 0.9765D-01, 0.1432D+00, 0.2100D+00,
     ,   0.3078D+00, 0.4508D+00, 0.6596D+00, 0.9637D+00, 0.1405D+01,
     ,   0.2043D+01, 0.2958D+01, 0.4259D+01, 0.6088D+01, 0.8627D+01,
     ,   0.1210D+02, 0.1682D+02, 0.2324D+02, 0.3211D+02, 0.4472D+02,
     ,   0.6328D+02, 0.9128D+02, 0.1341D+03, 0.1995D+03, 0.2992D+03,
     ,   0.4497D+03, 0.6753D+03, 0.1011D+04, 0.1508D+04, 0.2240D+04,
     ,   0.3318D+04, 0.4900D+04, 0.7222D+04, 0.1063D+05, 0.1562D+05,
     ,   0.2295D+05, 0.3370D+05, 0.4947D+05/
      data (calcpts(j,16), j = 1,neta) /
     ,   0.5035D-07, 0.7390D-07, 0.1085D-06, 0.1592D-06, 0.2337D-06,
     ,   0.3430D-06, 0.5035D-06, 0.7390D-06, 0.1085D-05, 0.1592D-05,
     ,   0.2337D-05, 0.3430D-05, 0.5035D-05, 0.7390D-05, 0.1085D-04,
     ,   0.1592D-04, 0.2337D-04, 0.3430D-04, 0.5035D-04, 0.7390D-04,
     ,   0.1085D-03, 0.1592D-03, 0.2337D-03, 0.3430D-03, 0.5035D-03,
     ,   0.7390D-03, 0.1085D-02, 0.1592D-02, 0.2337D-02, 0.3430D-02,
     ,   0.5035D-02, 0.7390D-02, 0.1085D-01, 0.1592D-01, 0.2336D-01,
     ,   0.3429D-01, 0.5032D-01, 0.7383D-01, 0.1083D+00, 0.1589D+00,
     ,   0.2330D+00, 0.3414D+00, 0.5001D+00, 0.7317D+00, 0.1069D+01,
     ,   0.1559D+01, 0.2266D+01, 0.3281D+01, 0.4724D+01, 0.6755D+01,
     ,   0.9573D+01, 0.1344D+02, 0.1869D+02, 0.2584D+02, 0.3575D+02,
     ,   0.4992D+02, 0.7085D+02, 0.1026D+03, 0.1511D+03, 0.2257D+03,
     ,   0.3394D+03, 0.5114D+03, 0.7695D+03, 0.1154D+04, 0.1724D+04,
     ,   0.2564D+04, 0.3801D+04, 0.5618D+04, 0.8285D+04, 0.1220D+05,
     ,   0.1794D+05, 0.2637D+05, 0.3873D+05/
      data (calcpts(j,17), j = 1,neta) /
     ,   0.3786D-07, 0.5557D-07, 0.8157D-07, 0.1197D-06, 0.1757D-06,
     ,   0.2580D-06, 0.3786D-06, 0.5557D-06, 0.8157D-06, 0.1197D-05,
     ,   0.1757D-05, 0.2580D-05, 0.3786D-05, 0.5557D-05, 0.8157D-05,
     ,   0.1197D-04, 0.1757D-04, 0.2580D-04, 0.3786D-04, 0.5557D-04,
     ,   0.8157D-04, 0.1197D-03, 0.1757D-03, 0.2580D-03, 0.3786D-03,
     ,   0.5557D-03, 0.8157D-03, 0.1197D-02, 0.1757D-02, 0.2579D-02,
     ,   0.3786D-02, 0.5557D-02, 0.8156D-02, 0.1197D-01, 0.1757D-01,
     ,   0.2579D-01, 0.3784D-01, 0.5554D-01, 0.8149D-01, 0.1196D+00,
     ,   0.1754D+00, 0.2571D+00, 0.3769D+00, 0.5519D+00, 0.8076D+00,
     ,   0.1180D+01, 0.1720D+01, 0.2501D+01, 0.3622D+01, 0.5215D+01,
     ,   0.7457D+01, 0.1057D+02, 0.1484D+02, 0.2065D+02, 0.2858D+02,
     ,   0.3960D+02, 0.5541D+02, 0.7886D+02, 0.1145D+03, 0.1693D+03,
     ,   0.2535D+03, 0.3822D+03, 0.5772D+03, 0.8700D+03, 0.1307D+04,
     ,   0.1954D+04, 0.2909D+04, 0.4317D+04, 0.6385D+04, 0.9423D+04,
     ,   0.1388D+05, 0.2042D+05, 0.3002D+05/
      data (calcpts(j,18), j = 1,neta) /
     ,   0.2834D-07, 0.4160D-07, 0.6106D-07, 0.8963D-07, 0.1316D-06,
     ,   0.1931D-06, 0.2834D-06, 0.4160D-06, 0.6106D-06, 0.8963D-06,
     ,   0.1316D-05, 0.1931D-05, 0.2834D-05, 0.4160D-05, 0.6106D-05,
     ,   0.8963D-05, 0.1316D-04, 0.1931D-04, 0.2834D-04, 0.4160D-04,
     ,   0.6106D-04, 0.8963D-04, 0.1316D-03, 0.1931D-03, 0.2834D-03,
     ,   0.4160D-03, 0.6106D-03, 0.8963D-03, 0.1316D-02, 0.1931D-02,
     ,   0.2834D-02, 0.4160D-02, 0.6106D-02, 0.8962D-02, 0.1315D-01,
     ,   0.1931D-01, 0.2833D-01, 0.4158D-01, 0.6102D-01, 0.8954D-01,
     ,   0.1314D+00, 0.1927D+00, 0.2825D+00, 0.4141D+00, 0.6065D+00,
     ,   0.8874D+00, 0.1296D+01, 0.1890D+01, 0.2748D+01, 0.3980D+01,
     ,   0.5731D+01, 0.8195D+01, 0.1162D+02, 0.1632D+02, 0.2272D+02,
     ,   0.3146D+02, 0.4365D+02, 0.6120D+02, 0.8731D+02, 0.1271D+03,
     ,   0.1885D+03, 0.2830D+03, 0.4276D+03, 0.6470D+03, 0.9767D+03,
     ,   0.1469D+04, 0.2199D+04, 0.3277D+04, 0.4866D+04, 0.7202D+04,
     ,   0.1063D+05, 0.1567D+05, 0.2307D+05/
      data (calcpts(j,19), j = 1,neta) /
     ,   0.2113D-07, 0.3102D-07, 0.4552D-07, 0.6682D-07, 0.9808D-07,
     ,   0.1440D-06, 0.2113D-06, 0.3102D-06, 0.4552D-06, 0.6682D-06,
     ,   0.9808D-06, 0.1440D-05, 0.2113D-05, 0.3102D-05, 0.4552D-05,
     ,   0.6682D-05, 0.9808D-05, 0.1440D-04, 0.2113D-04, 0.3102D-04,
     ,   0.4552D-04, 0.6682D-04, 0.9808D-04, 0.1440D-03, 0.2113D-03,
     ,   0.3101D-03, 0.4552D-03, 0.6682D-03, 0.9808D-03, 0.1440D-02,
     ,   0.2113D-02, 0.3101D-02, 0.4552D-02, 0.6682D-02, 0.9807D-02,
     ,   0.1439D-01, 0.2113D-01, 0.3101D-01, 0.4550D-01, 0.6677D-01,
     ,   0.9798D-01, 0.1437D+00, 0.2108D+00, 0.3092D+00, 0.4531D+00,
     ,   0.6636D+00, 0.9710D+00, 0.1419D+01, 0.2069D+01, 0.3008D+01,
     ,   0.4355D+01, 0.6272D+01, 0.8970D+01, 0.1272D+02, 0.1786D+02,
     ,   0.2488D+02, 0.3449D+02, 0.4791D+02, 0.6728D+02, 0.9620D+02,
     ,   0.1404D+03, 0.2088D+03, 0.3142D+03, 0.4756D+03, 0.7208D+03,
     ,   0.1090D+04, 0.1641D+04, 0.2458D+04, 0.3667D+04, 0.5448D+04,
     ,   0.8068D+04, 0.1192D+05, 0.1757D+05/
      data (calcpts(j,20), j = 1,neta) /
     ,   0.1569D-07, 0.2303D-07, 0.3381D-07, 0.4963D-07, 0.7284D-07,
     ,   0.1069D-06, 0.1569D-06, 0.2303D-06, 0.3381D-06, 0.4963D-06,
     ,   0.7284D-06, 0.1069D-05, 0.1569D-05, 0.2303D-05, 0.3381D-05,
     ,   0.4963D-05, 0.7284D-05, 0.1069D-04, 0.1569D-04, 0.2303D-04,
     ,   0.3381D-04, 0.4963D-04, 0.7284D-04, 0.1069D-03, 0.1569D-03,
     ,   0.2303D-03, 0.3381D-03, 0.4963D-03, 0.7284D-03, 0.1069D-02,
     ,   0.1569D-02, 0.2303D-02, 0.3381D-02, 0.4963D-02, 0.7284D-02,
     ,   0.1069D-01, 0.1569D-01, 0.2303D-01, 0.3380D-01, 0.4960D-01,
     ,   0.7279D-01, 0.1068D+00, 0.1567D+00, 0.2298D+00, 0.3370D+00,
     ,   0.4940D+00, 0.7235D+00, 0.1059D+01, 0.1547D+01, 0.2255D+01,
     ,   0.3279D+01, 0.4748D+01, 0.6838D+01, 0.9780D+01, 0.1387D+02,
     ,   0.1949D+02, 0.2715D+02, 0.3766D+02, 0.5237D+02, 0.7366D+02,
     ,   0.1055D+03, 0.1544D+03, 0.2301D+03, 0.3470D+03, 0.5263D+03,
     ,   0.7987D+03, 0.1209D+04, 0.1822D+04, 0.2732D+04, 0.4079D+04,
     ,   0.6064D+04, 0.8984D+04, 0.1328D+05/
      data (calcpts(j,21), j = 1,neta) /
     ,   0.1162D-07, 0.1705D-07, 0.2502D-07, 0.3673D-07, 0.5391D-07,
     ,   0.7913D-07, 0.1162D-06, 0.1705D-06, 0.2502D-06, 0.3673D-06,
     ,   0.5391D-06, 0.7913D-06, 0.1162D-05, 0.1705D-05, 0.2502D-05,
     ,   0.3673D-05, 0.5391D-05, 0.7913D-05, 0.1162D-04, 0.1705D-04,
     ,   0.2502D-04, 0.3673D-04, 0.5391D-04, 0.7913D-04, 0.1162D-03,
     ,   0.1705D-03, 0.2502D-03, 0.3673D-03, 0.5391D-03, 0.7913D-03,
     ,   0.1161D-02, 0.1705D-02, 0.2502D-02, 0.3673D-02, 0.5391D-02,
     ,   0.7913D-02, 0.1161D-01, 0.1705D-01, 0.2502D-01, 0.3672D-01,
     ,   0.5389D-01, 0.7908D-01, 0.1160D+00, 0.1702D+00, 0.2497D+00,
     ,   0.3661D+00, 0.5366D+00, 0.7859D+00, 0.1150D+01, 0.1680D+01,
     ,   0.2450D+01, 0.3562D+01, 0.5158D+01, 0.7429D+01, 0.1063D+02,
     ,   0.1507D+02, 0.2118D+02, 0.2952D+02, 0.4097D+02, 0.5703D+02,
     ,   0.8033D+02, 0.1153D+03, 0.1691D+03, 0.2524D+03, 0.3814D+03,
     ,   0.5795D+03, 0.8807D+03, 0.1334D+04, 0.2013D+04, 0.3021D+04,
     ,   0.4513D+04, 0.6712D+04, 0.9950D+04/
      data (calcpts(j,22), j = 1,neta) /
     ,   0.8569D-08, 0.1258D-07, 0.1846D-07, 0.2710D-07, 0.3977D-07,
     ,   0.5838D-07, 0.8569D-07, 0.1258D-06, 0.1846D-06, 0.2710D-06,
     ,   0.3977D-06, 0.5838D-06, 0.8569D-06, 0.1258D-05, 0.1846D-05,
     ,   0.2710D-05, 0.3977D-05, 0.5838D-05, 0.8569D-05, 0.1258D-04,
     ,   0.1846D-04, 0.2710D-04, 0.3977D-04, 0.5838D-04, 0.8569D-04,
     ,   0.1258D-03, 0.1846D-03, 0.2710D-03, 0.3977D-03, 0.5838D-03,
     ,   0.8569D-03, 0.1258D-02, 0.1846D-02, 0.2710D-02, 0.3977D-02,
     ,   0.5838D-02, 0.8568D-02, 0.1258D-01, 0.1846D-01, 0.2709D-01,
     ,   0.3976D-01, 0.5835D-01, 0.8563D-01, 0.1256D+00, 0.1843D+00,
     ,   0.2704D+00, 0.3965D+00, 0.5811D+00, 0.8511D+00, 0.1245D+01,
     ,   0.1819D+01, 0.2653D+01, 0.3857D+01, 0.5586D+01, 0.8046D+01,
     ,   0.1151D+02, 0.1632D+02, 0.2294D+02, 0.3199D+02, 0.4442D+02,
     ,   0.6189D+02, 0.8730D+02, 0.1255D+03, 0.1844D+03, 0.2759D+03,
     ,   0.4176D+03, 0.6353D+03, 0.9667D+03, 0.1466D+04, 0.2214D+04,
     ,   0.3325D+04, 0.4969D+04, 0.7394D+04/
      data (calcpts(j,23), j = 1,neta) /
     ,   0.6303D-08, 0.9251D-08, 0.1358D-07, 0.1993D-07, 0.2926D-07,
     ,   0.4294D-07, 0.6303D-07, 0.9251D-07, 0.1358D-06, 0.1993D-06,
     ,   0.2926D-06, 0.4294D-06, 0.6303D-06, 0.9251D-06, 0.1358D-05,
     ,   0.1993D-05, 0.2926D-05, 0.4294D-05, 0.6303D-05, 0.9251D-05,
     ,   0.1358D-04, 0.1993D-04, 0.2926D-04, 0.4294D-04, 0.6303D-04,
     ,   0.9251D-04, 0.1358D-03, 0.1993D-03, 0.2926D-03, 0.4294D-03,
     ,   0.6303D-03, 0.9251D-03, 0.1358D-02, 0.1993D-02, 0.2925D-02,
     ,   0.4294D-02, 0.6303D-02, 0.9251D-02, 0.1358D-01, 0.1993D-01,
     ,   0.2925D-01, 0.4293D-01, 0.6300D-01, 0.9245D-01, 0.1357D+00,
     ,   0.1990D+00, 0.2919D+00, 0.4280D+00, 0.6274D+00, 0.9189D+00,
     ,   0.1344D+01, 0.1964D+01, 0.2864D+01, 0.4165D+01, 0.6031D+01,
     ,   0.8687D+01, 0.1243D+02, 0.1763D+02, 0.2478D+02, 0.3456D+02,
     ,   0.4802D+02, 0.6696D+02, 0.9456D+02, 0.1362D+03, 0.2004D+03,
     ,   0.3004D+03, 0.4553D+03, 0.6937D+03, 0.1057D+04, 0.1604D+04,
     ,   0.2424D+04, 0.3643D+04, 0.5447D+04/
      data (calcpts(j,24), j = 1,neta) /
     ,   0.4623D-08, 0.6786D-08, 0.9961D-08, 0.1462D-07, 0.2146D-07,
     ,   0.3150D-07, 0.4623D-07, 0.6786D-07, 0.9961D-07, 0.1462D-06,
     ,   0.2146D-06, 0.3150D-06, 0.4623D-06, 0.6786D-06, 0.9961D-06,
     ,   0.1462D-05, 0.2146D-05, 0.3150D-05, 0.4623D-05, 0.6786D-05,
     ,   0.9961D-05, 0.1462D-04, 0.2146D-04, 0.3150D-04, 0.4623D-04,
     ,   0.6786D-04, 0.9961D-04, 0.1462D-03, 0.2146D-03, 0.3150D-03,
     ,   0.4623D-03, 0.6786D-03, 0.9960D-03, 0.1462D-02, 0.2146D-02,
     ,   0.3150D-02, 0.4623D-02, 0.6786D-02, 0.9960D-02, 0.1462D-01,
     ,   0.2146D-01, 0.3149D-01, 0.4622D-01, 0.6783D-01, 0.9954D-01,
     ,   0.1461D+00, 0.2143D+00, 0.3143D+00, 0.4609D+00, 0.6755D+00,
     ,   0.9893D+00, 0.1448D+01, 0.2115D+01, 0.3084D+01, 0.4484D+01,
     ,   0.6494D+01, 0.9354D+01, 0.1338D+02, 0.1898D+02, 0.2669D+02,
     ,   0.3723D+02, 0.5176D+02, 0.7223D+02, 0.1021D+03, 0.1473D+03,
     ,   0.2171D+03, 0.3259D+03, 0.4948D+03, 0.7547D+03, 0.1151D+04,
     ,   0.1749D+04, 0.2644D+04, 0.3975D+04/
      data (calcpts(j,25), j = 1,neta) /
     ,   0.3382D-08, 0.4965D-08, 0.7287D-08, 0.1070D-07, 0.1570D-07,
     ,   0.2304D-07, 0.3383D-07, 0.4965D-07, 0.7287D-07, 0.1070D-06,
     ,   0.1570D-06, 0.2304D-06, 0.3383D-06, 0.4965D-06, 0.7287D-06,
     ,   0.1070D-05, 0.1570D-05, 0.2304D-05, 0.3383D-05, 0.4965D-05,
     ,   0.7287D-05, 0.1070D-04, 0.1570D-04, 0.2304D-04, 0.3383D-04,
     ,   0.4965D-04, 0.7287D-04, 0.1070D-03, 0.1570D-03, 0.2304D-03,
     ,   0.3382D-03, 0.4965D-03, 0.7287D-03, 0.1070D-02, 0.1570D-02,
     ,   0.2304D-02, 0.3382D-02, 0.4965D-02, 0.7287D-02, 0.1070D-01,
     ,   0.1570D-01, 0.2304D-01, 0.3382D-01, 0.4963D-01, 0.7284D-01,
     ,   0.1069D+00, 0.1568D+00, 0.2301D+00, 0.3375D+00, 0.4949D+00,
     ,   0.7254D+00, 0.1062D+01, 0.1554D+01, 0.2271D+01, 0.3312D+01,
     ,   0.4815D+01, 0.6974D+01, 0.1005D+02, 0.1437D+02, 0.2039D+02,
     ,   0.2867D+02, 0.4001D+02, 0.5564D+02, 0.7771D+02, 0.1100D+03,
     ,   0.1588D+03, 0.2345D+03, 0.3525D+03, 0.5359D+03, 0.8184D+03,
     ,   0.1249D+04, 0.1899D+04, 0.2873D+04/
      data (calcpts(j,26), j = 1,neta) /
     ,   0.2469D-08, 0.3624D-08, 0.5319D-08, 0.7807D-08, 0.1146D-07,
     ,   0.1682D-07, 0.2469D-07, 0.3624D-07, 0.5319D-07, 0.7807D-07,
     ,   0.1146D-06, 0.1682D-06, 0.2469D-06, 0.3624D-06, 0.5319D-06,
     ,   0.7807D-06, 0.1146D-05, 0.1682D-05, 0.2469D-05, 0.3624D-05,
     ,   0.5319D-05, 0.7807D-05, 0.1146D-04, 0.1682D-04, 0.2469D-04,
     ,   0.3624D-04, 0.5319D-04, 0.7807D-04, 0.1146D-03, 0.1682D-03,
     ,   0.2469D-03, 0.3624D-03, 0.5319D-03, 0.7807D-03, 0.1146D-02,
     ,   0.1682D-02, 0.2469D-02, 0.3624D-02, 0.5319D-02, 0.7807D-02,
     ,   0.1146D-01, 0.1682D-01, 0.2468D-01, 0.3623D-01, 0.5317D-01,
     ,   0.7803D-01, 0.1145D+00, 0.1680D+00, 0.2465D+00, 0.3616D+00,
     ,   0.5302D+00, 0.7771D+00, 0.1138D+01, 0.1665D+01, 0.2433D+01,
     ,   0.3548D+01, 0.5159D+01, 0.7471D+01, 0.1076D+02, 0.1540D+02,
     ,   0.2185D+02, 0.3072D+02, 0.4288D+02, 0.5967D+02, 0.8339D+02,
     ,   0.1181D+03, 0.1708D+03, 0.2526D+03, 0.3802D+03, 0.5787D+03,
     ,   0.8846D+03, 0.1351D+04, 0.2056D+04/
      data (calcpts(j,27), j = 1,neta) /
     ,   0.1798D-08, 0.2639D-08, 0.3873D-08, 0.5685D-08, 0.8345D-08,
     ,   0.1225D-07, 0.1798D-07, 0.2639D-07, 0.3873D-07, 0.5685D-07,
     ,   0.8345D-07, 0.1225D-06, 0.1798D-06, 0.2639D-06, 0.3873D-06,
     ,   0.5685D-06, 0.8345D-06, 0.1225D-05, 0.1798D-05, 0.2639D-05,
     ,   0.3873D-05, 0.5685D-05, 0.8345D-05, 0.1225D-04, 0.1798D-04,
     ,   0.2639D-04, 0.3873D-04, 0.5685D-04, 0.8345D-04, 0.1225D-03,
     ,   0.1798D-03, 0.2639D-03, 0.3873D-03, 0.5685D-03, 0.8345D-03,
     ,   0.1225D-02, 0.1798D-02, 0.2639D-02, 0.3873D-02, 0.5685D-02,
     ,   0.8344D-02, 0.1225D-01, 0.1798D-01, 0.2638D-01, 0.3872D-01,
     ,   0.5683D-01, 0.8341D-01, 0.1224D+00, 0.1796D+00, 0.2635D+00,
     ,   0.3865D+00, 0.5667D+00, 0.8306D+00, 0.1217D+01, 0.1780D+01,
     ,   0.2601D+01, 0.3792D+01, 0.5514D+01, 0.7986D+01, 0.1150D+02,
     ,   0.1646D+02, 0.2335D+02, 0.3285D+02, 0.4586D+02, 0.6384D+02,
     ,   0.8927D+02, 0.1266D+03, 0.1833D+03, 0.2713D+03, 0.4089D+03,
     ,   0.6231D+03, 0.9534D+03, 0.1458D+04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine c3hqps21cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.8178D-06,-0.1200D-05,-0.1762D-05,-0.2586D-05,-0.3796D-05,
     ,  -0.5572D-05,-0.8178D-05,-0.1200D-04,-0.1762D-04,-0.2586D-04,
     ,  -0.3796D-04,-0.5572D-04,-0.8178D-04,-0.1200D-03,-0.1762D-03,
     ,  -0.2586D-03,-0.3796D-03,-0.5571D-03,-0.8177D-03,-0.1200D-02,
     ,  -0.1761D-02,-0.2585D-02,-0.3793D-02,-0.5565D-02,-0.8164D-02,
     ,  -0.1197D-01,-0.1755D-01,-0.2572D-01,-0.3765D-01,-0.5506D-01,
     ,  -0.8037D-01,-0.1170D+00,-0.1698D+00,-0.2453D+00,-0.3518D+00,
     ,  -0.5003D+00,-0.7035D+00,-0.9760D+00,-0.1334D+01,-0.1795D+01,
     ,  -0.2379D+01,-0.3113D+01,-0.4033D+01,-0.5192D+01,-0.6674D+01,
     ,  -0.8595D+01,-0.1111D+02,-0.1440D+02,-0.1870D+02,-0.2425D+02,
     ,  -0.3141D+02,-0.4061D+02,-0.5249D+02,-0.6793D+02,-0.8824D+02,
     ,  -0.1153D+03,-0.1520D+03,-0.2023D+03,-0.2722D+03,-0.3707D+03,
     ,  -0.5106D+03,-0.7110D+03,-0.9997D+03,-0.1418D+04,-0.2025D+04,
     ,  -0.2911D+04,-0.4203D+04,-0.6093D+04,-0.8860D+04,-0.1291D+05,
     ,  -0.1885D+05,-0.2756D+05,-0.4034D+05/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.7017D-06,-0.1030D-05,-0.1512D-05,-0.2219D-05,-0.3257D-05,
     ,  -0.4780D-05,-0.7017D-05,-0.1030D-04,-0.1512D-04,-0.2219D-04,
     ,  -0.3257D-04,-0.4780D-04,-0.7017D-04,-0.1030D-03,-0.1512D-03,
     ,  -0.2219D-03,-0.3257D-03,-0.4780D-03,-0.7016D-03,-0.1030D-02,
     ,  -0.1511D-02,-0.2218D-02,-0.3255D-02,-0.4776D-02,-0.7008D-02,
     ,  -0.1028D-01,-0.1508D-01,-0.2210D-01,-0.3238D-01,-0.4739D-01,
     ,  -0.6929D-01,-0.1011D+00,-0.1472D+00,-0.2135D+00,-0.3080D+00,
     ,  -0.4415D+00,-0.6272D+00,-0.8813D+00,-0.1223D+01,-0.1676D+01,
     ,  -0.2270D+01,-0.3051D+01,-0.4085D+01,-0.5477D+01,-0.7388D+01,
     ,  -0.1006D+02,-0.1384D+02,-0.1922D+02,-0.2687D+02,-0.3773D+02,
     ,  -0.5312D+02,-0.7490D+02,-0.1058D+03,-0.1497D+03,-0.2123D+03,
     ,  -0.3022D+03,-0.4316D+03,-0.6187D+03,-0.8901D+03,-0.1285D+04,
     ,  -0.1860D+04,-0.2700D+04,-0.3929D+04,-0.5727D+04,-0.8361D+04,
     ,  -0.1222D+05,-0.1788D+05,-0.2618D+05,-0.3836D+05,-0.5622D+05,
     ,  -0.8244D+05,-0.1209D+06,-0.1774D+06/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.5813D-06,-0.8532D-06,-0.1252D-05,-0.1838D-05,-0.2698D-05,
     ,  -0.3960D-05,-0.5813D-05,-0.8532D-05,-0.1252D-04,-0.1838D-04,
     ,  -0.2698D-04,-0.3960D-04,-0.5813D-04,-0.8532D-04,-0.1252D-03,
     ,  -0.1838D-03,-0.2698D-03,-0.3960D-03,-0.5813D-03,-0.8531D-03,
     ,  -0.1252D-02,-0.1838D-02,-0.2697D-02,-0.3958D-02,-0.5808D-02,
     ,  -0.8521D-02,-0.1250D-01,-0.1833D-01,-0.2687D-01,-0.3936D-01,
     ,  -0.5761D-01,-0.8421D-01,-0.1229D+00,-0.1788D+00,-0.2592D+00,
     ,  -0.3738D+00,-0.5354D+00,-0.7602D+00,-0.1068D+01,-0.1483D+01,
     ,  -0.2038D+01,-0.2777D+01,-0.3774D+01,-0.5144D+01,-0.7071D+01,
     ,  -0.9836D+01,-0.1386D+02,-0.1975D+02,-0.2837D+02,-0.4097D+02,
     ,  -0.5928D+02,-0.8580D+02,-0.1242D+03,-0.1796D+03,-0.2598D+03,
     ,  -0.3760D+03,-0.5448D+03,-0.7902D+03,-0.1148D+04,-0.1670D+04,
     ,  -0.2433D+04,-0.3549D+04,-0.5183D+04,-0.7577D+04,-0.1109D+05,
     ,  -0.1623D+05,-0.2378D+05,-0.3485D+05,-0.5110D+05,-0.7493D+05,
     ,  -0.1099D+06,-0.1613D+06,-0.2366D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.4681D-06,-0.6871D-06,-0.1009D-05,-0.1480D-05,-0.2173D-05,
     ,  -0.3189D-05,-0.4681D-05,-0.6871D-05,-0.1009D-04,-0.1480D-04,
     ,  -0.2173D-04,-0.3189D-04,-0.4681D-04,-0.6871D-04,-0.1009D-03,
     ,  -0.1480D-03,-0.2173D-03,-0.3189D-03,-0.4681D-03,-0.6871D-03,
     ,  -0.1008D-02,-0.1480D-02,-0.2172D-02,-0.3188D-02,-0.4678D-02,
     ,  -0.6865D-02,-0.1007D-01,-0.1477D-01,-0.2166D-01,-0.3176D-01,
     ,  -0.4652D-01,-0.6808D-01,-0.9950D-01,-0.1451D+00,-0.2112D+00,
     ,  -0.3060D+00,-0.4412D+00,-0.6317D+00,-0.8966D+00,-0.1260D+01,
     ,  -0.1751D+01,-0.2411D+01,-0.3304D+01,-0.4531D+01,-0.6262D+01,
     ,  -0.8765D+01,-0.1245D+02,-0.1793D+02,-0.2610D+02,-0.3823D+02,
     ,  -0.5616D+02,-0.8251D+02,-0.1211D+03,-0.1773D+03,-0.2593D+03,
     ,  -0.3787D+03,-0.5528D+03,-0.8067D+03,-0.1178D+04,-0.1719D+04,
     ,  -0.2512D+04,-0.3673D+04,-0.5373D+04,-0.7865D+04,-0.1152D+05,
     ,  -0.1688D+05,-0.2474D+05,-0.3627D+05,-0.5319D+05,-0.7801D+05,
     ,  -0.1145D+06,-0.1679D+06,-0.2464D+06/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.3685D-06,-0.5409D-06,-0.7939D-06,-0.1165D-05,-0.1711D-05,
     ,  -0.2511D-05,-0.3685D-05,-0.5409D-05,-0.7939D-05,-0.1165D-04,
     ,  -0.1710D-04,-0.2511D-04,-0.3685D-04,-0.5409D-04,-0.7939D-04,
     ,  -0.1165D-03,-0.1710D-03,-0.2511D-03,-0.3685D-03,-0.5409D-03,
     ,  -0.7939D-03,-0.1165D-02,-0.1710D-02,-0.2510D-02,-0.3684D-02,
     ,  -0.5406D-02,-0.7932D-02,-0.1164D-01,-0.1707D-01,-0.2503D-01,
     ,  -0.3669D-01,-0.5374D-01,-0.7865D-01,-0.1149D+00,-0.1677D+00,
     ,  -0.2439D+00,-0.3533D+00,-0.5093D+00,-0.7290D+00,-0.1035D+01,
     ,  -0.1454D+01,-0.2022D+01,-0.2791D+01,-0.3840D+01,-0.5306D+01,
     ,  -0.7413D+01,-0.1052D+02,-0.1517D+02,-0.2218D+02,-0.3272D+02,
     ,  -0.4853D+02,-0.7204D+02,-0.1068D+03,-0.1579D+03,-0.2329D+03,
     ,  -0.3427D+03,-0.5032D+03,-0.7378D+03,-0.1081D+04,-0.1583D+04,
     ,  -0.2318D+04,-0.3394D+04,-0.4972D+04,-0.7284D+04,-0.1067D+05,
     ,  -0.1565D+05,-0.2294D+05,-0.3364D+05,-0.4934D+05,-0.7239D+05,
     ,  -0.1062D+06,-0.1558D+06,-0.2287D+06/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.2849D-06,-0.4181D-06,-0.6137D-06,-0.9008D-06,-0.1322D-05,
     ,  -0.1941D-05,-0.2849D-05,-0.4181D-05,-0.6137D-05,-0.9008D-05,
     ,  -0.1322D-04,-0.1941D-04,-0.2849D-04,-0.4181D-04,-0.6137D-04,
     ,  -0.9008D-04,-0.1322D-03,-0.1941D-03,-0.2849D-03,-0.4181D-03,
     ,  -0.6137D-03,-0.9008D-03,-0.1322D-02,-0.1940D-02,-0.2848D-02,
     ,  -0.4179D-02,-0.6133D-02,-0.9000D-02,-0.1320D-01,-0.1937D-01,
     ,  -0.2840D-01,-0.4163D-01,-0.6097D-01,-0.8923D-01,-0.1304D+00,
     ,  -0.1902D+00,-0.2766D+00,-0.4007D+00,-0.5775D+00,-0.8265D+00,
     ,  -0.1173D+01,-0.1648D+01,-0.2294D+01,-0.3173D+01,-0.4382D+01,
     ,  -0.6091D+01,-0.8582D+01,-0.1230D+02,-0.1794D+02,-0.2651D+02,
     ,  -0.3950D+02,-0.5907D+02,-0.8830D+02,-0.1317D+03,-0.1958D+03,
     ,  -0.2900D+03,-0.4283D+03,-0.6309D+03,-0.9278D+03,-0.1363D+04,
     ,  -0.1999D+04,-0.2932D+04,-0.4300D+04,-0.6305D+04,-0.9245D+04,
     ,  -0.1356D+05,-0.1988D+05,-0.2916D+05,-0.4278D+05,-0.6277D+05,
     ,  -0.9210D+05,-0.1351D+06,-0.1983D+06/
      data (calcpts(j, 7), j = 1,neta) /
     ,  -0.2170D-06,-0.3186D-06,-0.4676D-06,-0.6863D-06,-0.1007D-05,
     ,  -0.1479D-05,-0.2170D-05,-0.3186D-05,-0.4676D-05,-0.6863D-05,
     ,  -0.1007D-04,-0.1479D-04,-0.2170D-04,-0.3186D-04,-0.4676D-04,
     ,  -0.6863D-04,-0.1007D-03,-0.1479D-03,-0.2170D-03,-0.3185D-03,
     ,  -0.4676D-03,-0.6863D-03,-0.1007D-02,-0.1478D-02,-0.2170D-02,
     ,  -0.3185D-02,-0.4674D-02,-0.6858D-02,-0.1006D-01,-0.1476D-01,
     ,  -0.2166D-01,-0.3176D-01,-0.4655D-01,-0.6818D-01,-0.9977D-01,
     ,  -0.1458D+00,-0.2126D+00,-0.3092D+00,-0.4479D+00,-0.6455D+00,
     ,  -0.9237D+00,-0.1311D+01,-0.1842D+01,-0.2567D+01,-0.3555D+01,
     ,  -0.4925D+01,-0.6879D+01,-0.9758D+01,-0.1410D+02,-0.2074D+02,
     ,  -0.3090D+02,-0.4636D+02,-0.6973D+02,-0.1048D+03,-0.1569D+03,
     ,  -0.2341D+03,-0.3478D+03,-0.5150D+03,-0.7604D+03,-0.1120D+04,
     ,  -0.1648D+04,-0.2421D+04,-0.3555D+04,-0.5218D+04,-0.7657D+04,
     ,  -0.1123D+05,-0.1648D+05,-0.2418D+05,-0.3548D+05,-0.5206D+05,
     ,  -0.7639D+05,-0.1121D+06,-0.1645D+06/
      data (calcpts(j, 8), j = 1,neta) /
     ,  -0.1634D-06,-0.2398D-06,-0.3520D-06,-0.5167D-06,-0.7585D-06,
     ,  -0.1113D-05,-0.1634D-05,-0.2398D-05,-0.3520D-05,-0.5167D-05,
     ,  -0.7585D-05,-0.1113D-04,-0.1634D-04,-0.2398D-04,-0.3520D-04,
     ,  -0.5167D-04,-0.7584D-04,-0.1113D-03,-0.1634D-03,-0.2398D-03,
     ,  -0.3520D-03,-0.5167D-03,-0.7584D-03,-0.1113D-02,-0.1634D-02,
     ,  -0.2398D-02,-0.3519D-02,-0.5165D-02,-0.7579D-02,-0.1112D-01,
     ,  -0.1632D-01,-0.2393D-01,-0.3510D-01,-0.5144D-01,-0.7534D-01,
     ,  -0.1102D+00,-0.1611D+00,-0.2349D+00,-0.3417D+00,-0.4949D+00,
     ,  -0.7131D+00,-0.1020D+01,-0.1448D+01,-0.2036D+01,-0.2838D+01,
     ,  -0.3936D+01,-0.5467D+01,-0.7668D+01,-0.1094D+02,-0.1591D+02,
     ,  -0.2355D+02,-0.3530D+02,-0.5325D+02,-0.8045D+02,-0.1213D+03,
     ,  -0.1823D+03,-0.2726D+03,-0.4060D+03,-0.6023D+03,-0.8907D+03,
     ,  -0.1314D+04,-0.1935D+04,-0.2846D+04,-0.4183D+04,-0.6143D+04,
     ,  -0.9018D+04,-0.1324D+05,-0.1943D+05,-0.2851D+05,-0.4184D+05,
     ,  -0.6140D+05,-0.9010D+05,-0.1322D+06/
      data (calcpts(j, 9), j = 1,neta) /
     ,  -0.1219D-06,-0.1789D-06,-0.2625D-06,-0.3853D-06,-0.5656D-06,
     ,  -0.8302D-06,-0.1219D-05,-0.1789D-05,-0.2625D-05,-0.3853D-05,
     ,  -0.5656D-05,-0.8302D-05,-0.1219D-04,-0.1789D-04,-0.2625D-04,
     ,  -0.3853D-04,-0.5656D-04,-0.8302D-04,-0.1219D-03,-0.1789D-03,
     ,  -0.2625D-03,-0.3853D-03,-0.5656D-03,-0.8301D-03,-0.1218D-02,
     ,  -0.1788D-02,-0.2625D-02,-0.3852D-02,-0.5653D-02,-0.8296D-02,
     ,  -0.1217D-01,-0.1786D-01,-0.2620D-01,-0.3841D-01,-0.5630D-01,
     ,  -0.8246D-01,-0.1207D+00,-0.1763D+00,-0.2571D+00,-0.3739D+00,
     ,  -0.5416D+00,-0.7804D+00,-0.1117D+01,-0.1585D+01,-0.2229D+01,
     ,  -0.3109D+01,-0.4317D+01,-0.6008D+01,-0.8454D+01,-0.1211D+02,
     ,  -0.1771D+02,-0.2635D+02,-0.3970D+02,-0.6014D+02,-0.9118D+02,
     ,  -0.1379D+03,-0.2077D+03,-0.3112D+03,-0.4643D+03,-0.6897D+03,
     ,  -0.1021D+04,-0.1508D+04,-0.2223D+04,-0.3272D+04,-0.4812D+04,
     ,  -0.7070D+04,-0.1038D+05,-0.1524D+05,-0.2238D+05,-0.3285D+05,
     ,  -0.4821D+05,-0.7076D+05,-0.1038D+06/
      data (calcpts(j,10), j = 1,neta) /
     ,  -0.9015D-07,-0.1323D-06,-0.1942D-06,-0.2851D-06,-0.4184D-06,
     ,  -0.6142D-06,-0.9015D-06,-0.1323D-05,-0.1942D-05,-0.2851D-05,
     ,  -0.4184D-05,-0.6142D-05,-0.9015D-05,-0.1323D-04,-0.1942D-04,
     ,  -0.2851D-04,-0.4184D-04,-0.6142D-04,-0.9015D-04,-0.1323D-03,
     ,  -0.1942D-03,-0.2851D-03,-0.4184D-03,-0.6141D-03,-0.9014D-03,
     ,  -0.1323D-02,-0.1942D-02,-0.2850D-02,-0.4183D-02,-0.6139D-02,
     ,  -0.9009D-02,-0.1322D-01,-0.1939D-01,-0.2845D-01,-0.4171D-01,
     ,  -0.6114D-01,-0.8954D-01,-0.1310D+00,-0.1915D+00,-0.2792D+00,
     ,  -0.4060D+00,-0.5881D+00,-0.8473D+00,-0.1213D+01,-0.1721D+01,
     ,  -0.2421D+01,-0.3378D+01,-0.4695D+01,-0.6547D+01,-0.9238D+01,
     ,  -0.1328D+02,-0.1951D+02,-0.2916D+02,-0.4409D+02,-0.6702D+02,
     ,  -0.1019D+03,-0.1545D+03,-0.2330D+03,-0.3498D+03,-0.5225D+03,
     ,  -0.7772D+03,-0.1152D+04,-0.1703D+04,-0.2511D+04,-0.3699D+04,
     ,  -0.5441D+04,-0.7997D+04,-0.1175D+05,-0.1725D+05,-0.2533D+05,
     ,  -0.3719D+05,-0.5459D+05,-0.8012D+05/
      data (calcpts(j,11), j = 1,neta) /
     ,  -0.6625D-07,-0.9724D-07,-0.1427D-06,-0.2095D-06,-0.3075D-06,
     ,  -0.4514D-06,-0.6625D-06,-0.9724D-06,-0.1427D-05,-0.2095D-05,
     ,  -0.3075D-05,-0.4514D-05,-0.6625D-05,-0.9724D-05,-0.1427D-04,
     ,  -0.2095D-04,-0.3075D-04,-0.4514D-04,-0.6625D-04,-0.9724D-04,
     ,  -0.1427D-03,-0.2095D-03,-0.3075D-03,-0.4513D-03,-0.6625D-03,
     ,  -0.9724D-03,-0.1427D-02,-0.2095D-02,-0.3074D-02,-0.4512D-02,
     ,  -0.6622D-02,-0.9718D-02,-0.1426D-01,-0.2092D-01,-0.3069D-01,
     ,  -0.4499D-01,-0.6595D-01,-0.9659D-01,-0.1413D+00,-0.2065D+00,
     ,  -0.3012D+00,-0.4379D+00,-0.6343D+00,-0.9140D+00,-0.1308D+01,
     ,  -0.1856D+01,-0.2612D+01,-0.3646D+01,-0.5073D+01,-0.7084D+01,
     ,  -0.1002D+02,-0.1445D+02,-0.2130D+02,-0.3195D+02,-0.4847D+02,
     ,  -0.7389D+02,-0.1126D+03,-0.1710D+03,-0.2584D+03,-0.3884D+03,
     ,  -0.5807D+03,-0.8646D+03,-0.1282D+04,-0.1897D+04,-0.2799D+04,
     ,  -0.4124D+04,-0.6069D+04,-0.8924D+04,-0.1311D+05,-0.1926D+05,
     ,  -0.2828D+05,-0.4153D+05,-0.6096D+05/
      data (calcpts(j,12), j = 1,neta) /
     ,  -0.4842D-07,-0.7107D-07,-0.1043D-06,-0.1531D-06,-0.2247D-06,
     ,  -0.3299D-06,-0.4842D-06,-0.7107D-06,-0.1043D-05,-0.1531D-05,
     ,  -0.2247D-05,-0.3299D-05,-0.4842D-05,-0.7107D-05,-0.1043D-04,
     ,  -0.1531D-04,-0.2247D-04,-0.3299D-04,-0.4842D-04,-0.7107D-04,
     ,  -0.1043D-03,-0.1531D-03,-0.2247D-03,-0.3298D-03,-0.4841D-03,
     ,  -0.7106D-03,-0.1043D-02,-0.1531D-02,-0.2247D-02,-0.3298D-02,
     ,  -0.4840D-02,-0.7103D-02,-0.1042D-01,-0.1530D-01,-0.2244D-01,
     ,  -0.3292D-01,-0.4826D-01,-0.7074D-01,-0.1036D+00,-0.1516D+00,
     ,  -0.2215D+00,-0.3230D+00,-0.4698D+00,-0.6804D+00,-0.9803D+00,
     ,  -0.1403D+01,-0.1991D+01,-0.2802D+01,-0.3914D+01,-0.5449D+01,
     ,  -0.7620D+01,-0.1080D+02,-0.1562D+02,-0.2309D+02,-0.3474D+02,
     ,  -0.5285D+02,-0.8074D+02,-0.1233D+03,-0.1875D+03,-0.2837D+03,
     ,  -0.4268D+03,-0.6388D+03,-0.9518D+03,-0.1413D+04,-0.2091D+04,
     ,  -0.3087D+04,-0.4549D+04,-0.6697D+04,-0.9849D+04,-0.1448D+05,
     ,  -0.2127D+05,-0.3123D+05,-0.4586D+05/
      data (calcpts(j,13), j = 1,neta) /
     ,  -0.3521D-07,-0.5169D-07,-0.7586D-07,-0.1114D-06,-0.1634D-06,
     ,  -0.2399D-06,-0.3521D-06,-0.5169D-06,-0.7586D-06,-0.1114D-05,
     ,  -0.1634D-05,-0.2399D-05,-0.3521D-05,-0.5169D-05,-0.7586D-05,
     ,  -0.1114D-04,-0.1634D-04,-0.2399D-04,-0.3521D-04,-0.5169D-04,
     ,  -0.7586D-04,-0.1114D-03,-0.1634D-03,-0.2399D-03,-0.3521D-03,
     ,  -0.5168D-03,-0.7586D-03,-0.1113D-02,-0.1634D-02,-0.2399D-02,
     ,  -0.3521D-02,-0.5167D-02,-0.7583D-02,-0.1113D-01,-0.1633D-01,
     ,  -0.2396D-01,-0.3514D-01,-0.5152D-01,-0.7552D-01,-0.1106D+00,
     ,  -0.1618D+00,-0.2365D+00,-0.3449D+00,-0.5015D+00,-0.7263D+00,
     ,  -0.1047D+01,-0.1498D+01,-0.2126D+01,-0.2992D+01,-0.4180D+01,
     ,  -0.5825D+01,-0.8155D+01,-0.1158D+02,-0.1678D+02,-0.2487D+02,
     ,  -0.3752D+02,-0.5721D+02,-0.8758D+02,-0.1339D+03,-0.2040D+03,
     ,  -0.3090D+03,-0.4653D+03,-0.6969D+03,-0.1039D+04,-0.1543D+04,
     ,  -0.2284D+04,-0.3374D+04,-0.4974D+04,-0.7324D+04,-0.1077D+05,
     ,  -0.1584D+05,-0.2327D+05,-0.3417D+05/
      data (calcpts(j,14), j = 1,neta) /
     ,  -0.2550D-07,-0.3743D-07,-0.5495D-07,-0.8065D-07,-0.1184D-06,
     ,  -0.1738D-06,-0.2550D-06,-0.3743D-06,-0.5495D-06,-0.8065D-06,
     ,  -0.1184D-05,-0.1738D-05,-0.2550D-05,-0.3743D-05,-0.5495D-05,
     ,  -0.8065D-05,-0.1184D-04,-0.1738D-04,-0.2550D-04,-0.3743D-04,
     ,  -0.5495D-04,-0.8065D-04,-0.1184D-03,-0.1738D-03,-0.2550D-03,
     ,  -0.3743D-03,-0.5495D-03,-0.8065D-03,-0.1184D-02,-0.1737D-02,
     ,  -0.2550D-02,-0.3743D-02,-0.5493D-02,-0.8061D-02,-0.1183D-01,
     ,  -0.1736D-01,-0.2547D-01,-0.3735D-01,-0.5477D-01,-0.8028D-01,
     ,  -0.1176D+00,-0.1721D+00,-0.2514D+00,-0.3666D+00,-0.5331D+00,
     ,  -0.7722D+00,-0.1113D+01,-0.1592D+01,-0.2260D+01,-0.3182D+01,
     ,  -0.4447D+01,-0.6199D+01,-0.8688D+01,-0.1235D+02,-0.1795D+02,
     ,  -0.2665D+02,-0.4030D+02,-0.6157D+02,-0.9441D+02,-0.1446D+03,
     ,  -0.2204D+03,-0.3342D+03,-0.5036D+03,-0.7548D+03,-0.1126D+04,
     ,  -0.1673D+04,-0.2478D+04,-0.3660D+04,-0.5398D+04,-0.7950D+04,
     ,  -0.1170D+05,-0.1720D+05,-0.2527D+05/
      data (calcpts(j,15), j = 1,neta) /
     ,  -0.1840D-07,-0.2701D-07,-0.3965D-07,-0.5820D-07,-0.8543D-07,
     ,  -0.1254D-06,-0.1840D-06,-0.2701D-06,-0.3965D-06,-0.5820D-06,
     ,  -0.8543D-06,-0.1254D-05,-0.1840D-05,-0.2701D-05,-0.3965D-05,
     ,  -0.5820D-05,-0.8543D-05,-0.1254D-04,-0.1840D-04,-0.2701D-04,
     ,  -0.3965D-04,-0.5820D-04,-0.8543D-04,-0.1254D-03,-0.1840D-03,
     ,  -0.2701D-03,-0.3965D-03,-0.5820D-03,-0.8542D-03,-0.1254D-02,
     ,  -0.1840D-02,-0.2701D-02,-0.3964D-02,-0.5818D-02,-0.8539D-02,
     ,  -0.1253D-01,-0.1839D-01,-0.2698D-01,-0.3957D-01,-0.5802D-01,
     ,  -0.8504D-01,-0.1245D+00,-0.1822D+00,-0.2663D+00,-0.3883D+00,
     ,  -0.5647D+00,-0.8179D+00,-0.1178D+01,-0.1687D+01,-0.2394D+01,
     ,  -0.3371D+01,-0.4713D+01,-0.6573D+01,-0.9221D+01,-0.1313D+02,
     ,  -0.1911D+02,-0.2843D+02,-0.4307D+02,-0.6592D+02,-0.1012D+03,
     ,  -0.1552D+03,-0.2369D+03,-0.3594D+03,-0.5419D+03,-0.8127D+03,
     ,  -0.1213D+04,-0.1803D+04,-0.2671D+04,-0.3947D+04,-0.5822D+04,
     ,  -0.8575D+04,-0.1262D+05,-0.1855D+05/
      data (calcpts(j,16), j = 1,neta) /
     ,  -0.1324D-07,-0.1943D-07,-0.2852D-07,-0.4187D-07,-0.6145D-07,
     ,  -0.9020D-07,-0.1324D-06,-0.1943D-06,-0.2852D-06,-0.4187D-06,
     ,  -0.6145D-06,-0.9020D-06,-0.1324D-05,-0.1943D-05,-0.2852D-05,
     ,  -0.4187D-05,-0.6145D-05,-0.9020D-05,-0.1324D-04,-0.1943D-04,
     ,  -0.2852D-04,-0.4187D-04,-0.6145D-04,-0.9020D-04,-0.1324D-03,
     ,  -0.1943D-03,-0.2852D-03,-0.4187D-03,-0.6145D-03,-0.9019D-03,
     ,  -0.1324D-02,-0.1943D-02,-0.2852D-02,-0.4186D-02,-0.6143D-02,
     ,  -0.9016D-02,-0.1323D-01,-0.1941D-01,-0.2848D-01,-0.4178D-01,
     ,  -0.6126D-01,-0.8978D-01,-0.1315D+00,-0.1924D+00,-0.2812D+00,
     ,  -0.4100D+00,-0.5962D+00,-0.8636D+00,-0.1244D+01,-0.1781D+01,
     ,  -0.2528D+01,-0.3560D+01,-0.4978D+01,-0.6947D+01,-0.9753D+01,
     ,  -0.1390D+02,-0.2026D+02,-0.3021D+02,-0.4584D+02,-0.7026D+02,
     ,  -0.1080D+03,-0.1658D+03,-0.2533D+03,-0.3845D+03,-0.5802D+03,
     ,  -0.8705D+03,-0.1300D+04,-0.1932D+04,-0.2864D+04,-0.4233D+04,
     ,  -0.6245D+04,-0.9200D+04,-0.1354D+05/
      data (calcpts(j,17), j = 1,neta) /
     ,  -0.9496D-08,-0.1394D-07,-0.2046D-07,-0.3003D-07,-0.4408D-07,
     ,  -0.6470D-07,-0.9496D-07,-0.1394D-06,-0.2046D-06,-0.3003D-06,
     ,  -0.4408D-06,-0.6470D-06,-0.9496D-06,-0.1394D-05,-0.2046D-05,
     ,  -0.3003D-05,-0.4408D-05,-0.6470D-05,-0.9496D-05,-0.1394D-04,
     ,  -0.2046D-04,-0.3003D-04,-0.4408D-04,-0.6470D-04,-0.9496D-04,
     ,  -0.1394D-03,-0.2046D-03,-0.3003D-03,-0.4408D-03,-0.6470D-03,
     ,  -0.9496D-03,-0.1394D-02,-0.2046D-02,-0.3003D-02,-0.4407D-02,
     ,  -0.6468D-02,-0.9492D-02,-0.1393D-01,-0.2044D-01,-0.2999D-01,
     ,  -0.4398D-01,-0.6449D-01,-0.9453D-01,-0.1384D+00,-0.2026D+00,
     ,  -0.2960D+00,-0.4317D+00,-0.6277D+00,-0.9092D+00,-0.1310D+01,
     ,  -0.1875D+01,-0.2662D+01,-0.3749D+01,-0.5243D+01,-0.7320D+01,
     ,  -0.1028D+02,-0.1468D+02,-0.2142D+02,-0.3198D+02,-0.4860D+02,
     ,  -0.7460D+02,-0.1148D+03,-0.1764D+03,-0.2697D+03,-0.4097D+03,
     ,  -0.6185D+03,-0.9283D+03,-0.1386D+04,-0.2062D+04,-0.3056D+04,
     ,  -0.4519D+04,-0.6668D+04,-0.9825D+04/
      data (calcpts(j,18), j = 1,neta) /
     ,  -0.6794D-08,-0.9972D-08,-0.1464D-07,-0.2148D-07,-0.3154D-07,
     ,  -0.4629D-07,-0.6794D-07,-0.9972D-07,-0.1464D-06,-0.2148D-06,
     ,  -0.3154D-06,-0.4629D-06,-0.6794D-06,-0.9972D-06,-0.1464D-05,
     ,  -0.2148D-05,-0.3154D-05,-0.4629D-05,-0.6794D-05,-0.9972D-05,
     ,  -0.1464D-04,-0.2148D-04,-0.3154D-04,-0.4629D-04,-0.6794D-04,
     ,  -0.9972D-04,-0.1464D-03,-0.2148D-03,-0.3153D-03,-0.4629D-03,
     ,  -0.6794D-03,-0.9972D-03,-0.1464D-02,-0.2148D-02,-0.3153D-02,
     ,  -0.4628D-02,-0.6792D-02,-0.9968D-02,-0.1463D-01,-0.2146D-01,
     ,  -0.3149D-01,-0.4619D-01,-0.6773D-01,-0.9927D-01,-0.1454D+00,
     ,  -0.2127D+00,-0.3109D+00,-0.4533D+00,-0.6592D+00,-0.9548D+00,
     ,  -0.1376D+01,-0.1969D+01,-0.2796D+01,-0.3937D+01,-0.5508D+01,
     ,  -0.7693D+01,-0.1082D+02,-0.1545D+02,-0.2258D+02,-0.3376D+02,
     ,  -0.5137D+02,-0.7894D+02,-0.1216D+03,-0.1870D+03,-0.2860D+03,
     ,  -0.4348D+03,-0.6567D+03,-0.9860D+03,-0.1473D+04,-0.2191D+04,
     ,  -0.3249D+04,-0.4805D+04,-0.7091D+04/
      data (calcpts(j,19), j = 1,neta) /
     ,  -0.4850D-08,-0.7118D-08,-0.1045D-07,-0.1534D-07,-0.2251D-07,
     ,  -0.3304D-07,-0.4850D-07,-0.7118D-07,-0.1045D-06,-0.1534D-06,
     ,  -0.2251D-06,-0.3304D-06,-0.4850D-06,-0.7118D-06,-0.1045D-05,
     ,  -0.1534D-05,-0.2251D-05,-0.3304D-05,-0.4850D-05,-0.7118D-05,
     ,  -0.1045D-04,-0.1534D-04,-0.2251D-04,-0.3304D-04,-0.4850D-04,
     ,  -0.7118D-04,-0.1045D-03,-0.1534D-03,-0.2251D-03,-0.3304D-03,
     ,  -0.4850D-03,-0.7118D-03,-0.1045D-02,-0.1533D-02,-0.2251D-02,
     ,  -0.3304D-02,-0.4849D-02,-0.7116D-02,-0.1044D-01,-0.1533D-01,
     ,  -0.2249D-01,-0.3299D-01,-0.4839D-01,-0.7096D-01,-0.1040D+00,
     ,  -0.1523D+00,-0.2229D+00,-0.3257D+00,-0.4749D+00,-0.6906D+00,
     ,  -0.1000D+01,-0.1441D+01,-0.2063D+01,-0.2930D+01,-0.4126D+01,
     ,  -0.5773D+01,-0.8066D+01,-0.1135D+02,-0.1622D+02,-0.2373D+02,
     ,  -0.3553D+02,-0.5413D+02,-0.8327D+02,-0.1284D+03,-0.1976D+03,
     ,  -0.3024D+03,-0.4599D+03,-0.6949D+03,-0.1044D+04,-0.1560D+04,
     ,  -0.2321D+04,-0.3442D+04,-0.5090D+04/
      data (calcpts(j,20), j = 1,neta) /
     ,  -0.3454D-08,-0.5070D-08,-0.7442D-08,-0.1092D-07,-0.1603D-07,
     ,  -0.2353D-07,-0.3454D-07,-0.5070D-07,-0.7442D-07,-0.1092D-06,
     ,  -0.1603D-06,-0.2353D-06,-0.3454D-06,-0.5070D-06,-0.7442D-06,
     ,  -0.1092D-05,-0.1603D-05,-0.2353D-05,-0.3454D-05,-0.5070D-05,
     ,  -0.7442D-05,-0.1092D-04,-0.1603D-04,-0.2353D-04,-0.3454D-04,
     ,  -0.5070D-04,-0.7442D-04,-0.1092D-03,-0.1603D-03,-0.2353D-03,
     ,  -0.3454D-03,-0.5070D-03,-0.7442D-03,-0.1092D-02,-0.1603D-02,
     ,  -0.2353D-02,-0.3454D-02,-0.5069D-02,-0.7440D-02,-0.1092D-01,
     ,  -0.1602D-01,-0.2351D-01,-0.3449D-01,-0.5059D-01,-0.7419D-01,
     ,  -0.1087D+00,-0.1593D+00,-0.2330D+00,-0.3405D+00,-0.4965D+00,
     ,  -0.7220D+00,-0.1046D+01,-0.1507D+01,-0.2157D+01,-0.3063D+01,
     ,  -0.4314D+01,-0.6038D+01,-0.8439D+01,-0.1188D+02,-0.1700D+02,
     ,  -0.2489D+02,-0.3730D+02,-0.5689D+02,-0.8761D+02,-0.1352D+03,
     ,  -0.2082D+03,-0.3188D+03,-0.4850D+03,-0.7331D+03,-0.1101D+04,
     ,  -0.1646D+04,-0.2450D+04,-0.3634D+04/
      data (calcpts(j,21), j = 1,neta) /
     ,  -0.2456D-08,-0.3605D-08,-0.5291D-08,-0.7766D-08,-0.1140D-07,
     ,  -0.1673D-07,-0.2456D-07,-0.3605D-07,-0.5291D-07,-0.7766D-07,
     ,  -0.1140D-06,-0.1673D-06,-0.2456D-06,-0.3605D-06,-0.5291D-06,
     ,  -0.7766D-06,-0.1140D-05,-0.1673D-05,-0.2456D-05,-0.3605D-05,
     ,  -0.5291D-05,-0.7766D-05,-0.1140D-04,-0.1673D-04,-0.2456D-04,
     ,  -0.3605D-04,-0.5291D-04,-0.7766D-04,-0.1140D-03,-0.1673D-03,
     ,  -0.2456D-03,-0.3605D-03,-0.5291D-03,-0.7766D-03,-0.1140D-02,
     ,  -0.1673D-02,-0.2456D-02,-0.3604D-02,-0.5290D-02,-0.7764D-02,
     ,  -0.1139D-01,-0.1672D-01,-0.2453D-01,-0.3599D-01,-0.5280D-01,
     ,  -0.7742D-01,-0.1135D+00,-0.1662D+00,-0.2432D+00,-0.3553D+00,
     ,  -0.5182D+00,-0.7535D+00,-0.1091D+01,-0.1573D+01,-0.2251D+01,
     ,  -0.3197D+01,-0.4503D+01,-0.6303D+01,-0.8812D+01,-0.1241D+02,
     ,  -0.1777D+02,-0.2604D+02,-0.3907D+02,-0.5965D+02,-0.9194D+02,
     ,  -0.1420D+03,-0.2188D+03,-0.3352D+03,-0.5101D+03,-0.7713D+03,
     ,  -0.1159D+04,-0.1733D+04,-0.2580D+04/
      data (calcpts(j,22), j = 1,neta) /
     ,  -0.1743D-08,-0.2558D-08,-0.3755D-08,-0.5512D-08,-0.8090D-08,
     ,  -0.1187D-07,-0.1743D-07,-0.2558D-07,-0.3755D-07,-0.5512D-07,
     ,  -0.8090D-07,-0.1187D-06,-0.1743D-06,-0.2558D-06,-0.3755D-06,
     ,  -0.5512D-06,-0.8090D-06,-0.1187D-05,-0.1743D-05,-0.2558D-05,
     ,  -0.3755D-05,-0.5512D-05,-0.8090D-05,-0.1187D-04,-0.1743D-04,
     ,  -0.2558D-04,-0.3755D-04,-0.5512D-04,-0.8090D-04,-0.1187D-03,
     ,  -0.1743D-03,-0.2558D-03,-0.3755D-03,-0.5512D-03,-0.8090D-03,
     ,  -0.1187D-02,-0.1743D-02,-0.2558D-02,-0.3754D-02,-0.5510D-02,
     ,  -0.8087D-02,-0.1187D-01,-0.1742D-01,-0.2556D-01,-0.3750D-01,
     ,  -0.5500D-01,-0.8065D-01,-0.1182D+00,-0.1731D+00,-0.2533D+00,
     ,  -0.3701D+00,-0.5398D+00,-0.7849D+00,-0.1137D+01,-0.1638D+01,
     ,  -0.2345D+01,-0.3330D+01,-0.4691D+01,-0.6568D+01,-0.9184D+01,
     ,  -0.1294D+02,-0.1854D+02,-0.2720D+02,-0.4084D+02,-0.6241D+02,
     ,  -0.9627D+02,-0.1488D+03,-0.2293D+03,-0.3515D+03,-0.5352D+03,
     ,  -0.8094D+03,-0.1217D+04,-0.1819D+04/
      data (calcpts(j,23), j = 1,neta) /
     ,  -0.1235D-08,-0.1813D-08,-0.2661D-08,-0.3905D-08,-0.5732D-08,
     ,  -0.8414D-08,-0.1235D-07,-0.1813D-07,-0.2661D-07,-0.3905D-07,
     ,  -0.5732D-07,-0.8414D-07,-0.1235D-06,-0.1813D-06,-0.2661D-06,
     ,  -0.3905D-06,-0.5732D-06,-0.8414D-06,-0.1235D-05,-0.1813D-05,
     ,  -0.2661D-05,-0.3905D-05,-0.5732D-05,-0.8414D-05,-0.1235D-04,
     ,  -0.1813D-04,-0.2661D-04,-0.3905D-04,-0.5732D-04,-0.8414D-04,
     ,  -0.1235D-03,-0.1813D-03,-0.2661D-03,-0.3905D-03,-0.5732D-03,
     ,  -0.8413D-03,-0.1235D-02,-0.1813D-02,-0.2660D-02,-0.3905D-02,
     ,  -0.5731D-02,-0.8411D-02,-0.1234D-01,-0.1811D-01,-0.2658D-01,
     ,  -0.3900D-01,-0.5720D-01,-0.8387D-01,-0.1229D+00,-0.1800D+00,
     ,  -0.2635D+00,-0.3850D+00,-0.5614D+00,-0.8163D+00,-0.1182D+01,
     ,  -0.1704D+01,-0.2439D+01,-0.3464D+01,-0.4880D+01,-0.6832D+01,
     ,  -0.9557D+01,-0.1347D+02,-0.1931D+02,-0.2835D+02,-0.4261D+02,
     ,  -0.6517D+02,-0.1006D+03,-0.1556D+03,-0.2399D+03,-0.3679D+03,
     ,  -0.5603D+03,-0.8476D+03,-0.1274D+04/
      data (calcpts(j,24), j = 1,neta) /
     ,  -0.8737D-09,-0.1282D-08,-0.1882D-08,-0.2763D-08,-0.4056D-08,
     ,  -0.5953D-08,-0.8737D-08,-0.1282D-07,-0.1882D-07,-0.2763D-07,
     ,  -0.4056D-07,-0.5953D-07,-0.8737D-07,-0.1282D-06,-0.1882D-06,
     ,  -0.2763D-06,-0.4056D-06,-0.5953D-06,-0.8737D-06,-0.1282D-05,
     ,  -0.1882D-05,-0.2763D-05,-0.4056D-05,-0.5953D-05,-0.8737D-05,
     ,  -0.1282D-04,-0.1882D-04,-0.2763D-04,-0.4056D-04,-0.5953D-04,
     ,  -0.8737D-04,-0.1282D-03,-0.1882D-03,-0.2763D-03,-0.4056D-03,
     ,  -0.5953D-03,-0.8737D-03,-0.1282D-02,-0.1882D-02,-0.2763D-02,
     ,  -0.4055D-02,-0.5951D-02,-0.8735D-02,-0.1282D-01,-0.1881D-01,
     ,  -0.2760D-01,-0.4050D-01,-0.5940D-01,-0.8710D-01,-0.1277D+00,
     ,  -0.1870D+00,-0.2736D+00,-0.3998D+00,-0.5830D+00,-0.8477D+00,
     ,  -0.1228D+01,-0.1769D+01,-0.2533D+01,-0.3597D+01,-0.5068D+01,
     ,  -0.7097D+01,-0.9929D+01,-0.1400D+02,-0.2008D+02,-0.2951D+02,
     ,  -0.4438D+02,-0.6793D+02,-0.1049D+03,-0.1624D+03,-0.2505D+03,
     ,  -0.3842D+03,-0.5854D+03,-0.8858D+03/
      data (calcpts(j,25), j = 1,neta) /
     ,  -0.6173D-09,-0.9061D-09,-0.1330D-08,-0.1952D-08,-0.2865D-08,
     ,  -0.4206D-08,-0.6173D-08,-0.9061D-08,-0.1330D-07,-0.1952D-07,
     ,  -0.2865D-07,-0.4206D-07,-0.6173D-07,-0.9061D-07,-0.1330D-06,
     ,  -0.1952D-06,-0.2865D-06,-0.4206D-06,-0.6173D-06,-0.9061D-06,
     ,  -0.1330D-05,-0.1952D-05,-0.2865D-05,-0.4206D-05,-0.6173D-05,
     ,  -0.9061D-05,-0.1330D-04,-0.1952D-04,-0.2865D-04,-0.4206D-04,
     ,  -0.6173D-04,-0.9061D-04,-0.1330D-03,-0.1952D-03,-0.2865D-03,
     ,  -0.4206D-03,-0.6173D-03,-0.9061D-03,-0.1330D-02,-0.1952D-02,
     ,  -0.2865D-02,-0.4205D-02,-0.6172D-02,-0.9058D-02,-0.1329D-01,
     ,  -0.1951D-01,-0.2863D-01,-0.4200D-01,-0.6160D-01,-0.9033D-01,
     ,  -0.1324D+00,-0.1939D+00,-0.2837D+00,-0.4146D+00,-0.6046D+00,
     ,  -0.8791D+00,-0.1273D+01,-0.1835D+01,-0.2627D+01,-0.3731D+01,
     ,  -0.5257D+01,-0.7362D+01,-0.1030D+02,-0.1453D+02,-0.2085D+02,
     ,  -0.3066D+02,-0.4615D+02,-0.7069D+02,-0.1093D+03,-0.1692D+03,
     ,  -0.2611D+03,-0.4006D+03,-0.6104D+03/
      data (calcpts(j,26), j = 1,neta) /
     ,  -0.4356D-09,-0.6394D-09,-0.9385D-09,-0.1377D-08,-0.2022D-08,
     ,  -0.2968D-08,-0.4356D-08,-0.6394D-08,-0.9385D-08,-0.1378D-07,
     ,  -0.2022D-07,-0.2968D-07,-0.4356D-07,-0.6394D-07,-0.9385D-07,
     ,  -0.1378D-06,-0.2022D-06,-0.2968D-06,-0.4356D-06,-0.6394D-06,
     ,  -0.9385D-06,-0.1378D-05,-0.2022D-05,-0.2968D-05,-0.4356D-05,
     ,  -0.6394D-05,-0.9385D-05,-0.1378D-04,-0.2022D-04,-0.2968D-04,
     ,  -0.4356D-04,-0.6394D-04,-0.9385D-04,-0.1377D-03,-0.2022D-03,
     ,  -0.2968D-03,-0.4356D-03,-0.6394D-03,-0.9385D-03,-0.1377D-02,
     ,  -0.2022D-02,-0.2967D-02,-0.4355D-02,-0.6392D-02,-0.9382D-02,
     ,  -0.1377D-01,-0.2021D-01,-0.2965D-01,-0.4350D-01,-0.6380D-01,
     ,  -0.9355D-01,-0.1371D+00,-0.2008D+00,-0.2939D+00,-0.4294D+00,
     ,  -0.6262D+00,-0.9105D+00,-0.1319D+01,-0.1901D+01,-0.2721D+01,
     ,  -0.3864D+01,-0.5445D+01,-0.7626D+01,-0.1067D+02,-0.1506D+02,
     ,  -0.2163D+02,-0.3181D+02,-0.4792D+02,-0.7345D+02,-0.1136D+03,
     ,  -0.1759D+03,-0.2717D+03,-0.4169D+03/
      data (calcpts(j,27), j = 1,neta) /
     ,  -0.3070D-09,-0.4506D-09,-0.6614D-09,-0.9708D-09,-0.1425D-08,
     ,  -0.2092D-08,-0.3070D-08,-0.4506D-08,-0.6614D-08,-0.9708D-08,
     ,  -0.1425D-07,-0.2092D-07,-0.3070D-07,-0.4506D-07,-0.6614D-07,
     ,  -0.9708D-07,-0.1425D-06,-0.2092D-06,-0.3070D-06,-0.4506D-06,
     ,  -0.6614D-06,-0.9708D-06,-0.1425D-05,-0.2092D-05,-0.3070D-05,
     ,  -0.4506D-05,-0.6614D-05,-0.9708D-05,-0.1425D-04,-0.2092D-04,
     ,  -0.3070D-04,-0.4506D-04,-0.6614D-04,-0.9708D-04,-0.1425D-03,
     ,  -0.2092D-03,-0.3070D-03,-0.4506D-03,-0.6614D-03,-0.9708D-03,
     ,  -0.1425D-02,-0.2091D-02,-0.3070D-02,-0.4506D-02,-0.6613D-02,
     ,  -0.9705D-02,-0.1424D-01,-0.2090D-01,-0.3067D-01,-0.4500D-01,
     ,  -0.6600D-01,-0.9678D-01,-0.1418D+00,-0.2078D+00,-0.3040D+00,
     ,  -0.4442D+00,-0.6478D+00,-0.9419D+00,-0.1364D+01,-0.1966D+01,
     ,  -0.2814D+01,-0.3998D+01,-0.5633D+01,-0.7891D+01,-0.1105D+02,
     ,  -0.1559D+02,-0.2240D+02,-0.3297D+02,-0.4969D+02,-0.7621D+02,
     ,  -0.1179D+03,-0.1827D+03,-0.2822D+03/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     #  0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate_nr(dlaeta,neta, dleta, ieta)
      call locate_nr(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 26
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      coeff = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
     #     peta*(peta+1d0)/2d0*f(1)

      return
      end
!-----------------------------
      subroutine c2hqg20cc_asy(eta, xi, coeff)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 27)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, coeff
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j

      real*8 ff(nxi*neta),rlambda(nxi+4),rmu(neta+4),c(nxi*neta),
     ,       wrk((nxi+6)*(neta+6)),xx(1),yy(1),fg(1)
      integer i,ipeta,ipxi,ifail,iwrk(neta),init
      data init/0/
      save ipxi,ipeta,rlambda,rmu,c,wrk,iwrk,init

      data (calcpts(j, 1), j = 1,neta) /
     ,  -0.2850D+05,-0.2657D+05,-0.2473D+05,-0.2297D+05,-0.2130D+05,
     ,  -0.1971D+05,-0.1820D+05,-0.1677D+05,-0.1541D+05,-0.1412D+05,
     ,  -0.1291D+05,-0.1177D+05,-0.1069D+05,-0.9680D+04,-0.8734D+04,
     ,  -0.7849D+04,-0.7023D+04,-0.6255D+04,-0.5542D+04,-0.4883D+04,
     ,  -0.4275D+04,-0.3716D+04,-0.3204D+04,-0.2737D+04,-0.2313D+04,
     ,  -0.1930D+04,-0.1584D+04,-0.1275D+04,-0.9992D+03,-0.7553D+03,
     ,  -0.5413D+03,-0.3554D+03,-0.1965D+03,-0.6414D+02, 0.4117D+02,
     ,   0.1181D+03, 0.1647D+03, 0.1799D+03, 0.1655D+03, 0.1274D+03,
     ,   0.7632D+02, 0.2385D+02,-0.2246D+02,-0.6228D+02,-0.1013D+03,
     ,  -0.1469D+03,-0.2052D+03,-0.2788D+03,-0.3679D+03,-0.4700D+03,
     ,  -0.5811D+03,-0.6949D+03,-0.8019D+03,-0.8878D+03,-0.9314D+03,
     ,  -0.9002D+03,-0.7460D+03,-0.3969D+03, 0.2537D+03, 0.1363D+04,
     ,   0.3165D+04, 0.6001D+04, 0.1037D+05, 0.1703D+05, 0.2705D+05,
     ,   0.4203D+05, 0.6433D+05, 0.9738D+05, 0.1463D+06, 0.2184D+06,
     ,   0.3246D+06, 0.4811D+06, 0.7111D+06/
      data (calcpts(j, 2), j = 1,neta) /
     ,  -0.2982D+05,-0.2783D+05,-0.2593D+05,-0.2412D+05,-0.2239D+05,
     ,  -0.2074D+05,-0.1918D+05,-0.1769D+05,-0.1628D+05,-0.1495D+05,
     ,  -0.1369D+05,-0.1250D+05,-0.1138D+05,-0.1033D+05,-0.9337D+04,
     ,  -0.8412D+04,-0.7547D+04,-0.6741D+04,-0.5992D+04,-0.5298D+04,
     ,  -0.4657D+04,-0.4066D+04,-0.3523D+04,-0.3028D+04,-0.2576D+04,
     ,  -0.2167D+04,-0.1797D+04,-0.1465D+04,-0.1168D+04,-0.9051D+03,
     ,  -0.6731D+03,-0.4703D+03,-0.2952D+03,-0.1469D+03,-0.2480D+02,
     ,   0.7043D+02, 0.1375D+03, 0.1748D+03, 0.1819D+03, 0.1611D+03,
     ,   0.1195D+03, 0.6767D+02, 0.1654D+02,-0.2792D+02,-0.6677D+02,
     ,  -0.1061D+03,-0.1531D+03,-0.2127D+03,-0.2865D+03,-0.3733D+03,
     ,  -0.4695D+03,-0.5689D+03,-0.6626D+03,-0.7370D+03,-0.7716D+03,
     ,  -0.7360D+03,-0.5846D+03,-0.2493D+03, 0.3705D+03, 0.1424D+04,
     ,   0.3131D+04, 0.5816D+04, 0.9955D+04, 0.1625D+05, 0.2573D+05,
     ,   0.3990D+05, 0.6100D+05, 0.9227D+05, 0.1385D+06, 0.2068D+06,
     ,   0.3073D+06, 0.4553D+06, 0.6730D+06/
      data (calcpts(j, 3), j = 1,neta) /
     ,  -0.3136D+05,-0.2930D+05,-0.2733D+05,-0.2545D+05,-0.2366D+05,
     ,  -0.2195D+05,-0.2032D+05,-0.1878D+05,-0.1731D+05,-0.1592D+05,
     ,  -0.1461D+05,-0.1336D+05,-0.1219D+05,-0.1109D+05,-0.1005D+05,
     ,  -0.9077D+04,-0.8167D+04,-0.7317D+04,-0.6525D+04,-0.5790D+04,
     ,  -0.5110D+04,-0.4481D+04,-0.3903D+04,-0.3373D+04,-0.2889D+04,
     ,  -0.2449D+04,-0.2051D+04,-0.1692D+04,-0.1370D+04,-0.1083D+04,
     ,  -0.8294D+03,-0.6064D+03,-0.4124D+03,-0.2460D+03,-0.1060D+03,
     ,   0.7835D+01, 0.9495D+02, 0.1541D+03, 0.1840D+03, 0.1847D+03,
     ,   0.1592D+03, 0.1149D+03, 0.6261D+02, 0.1231D+02,-0.3129D+02,
     ,  -0.7032D+02,-0.1113D+03,-0.1612D+03,-0.2244D+03,-0.3023D+03,
     ,  -0.3934D+03,-0.4941D+03,-0.5983D+03,-0.6968D+03,-0.7762D+03,
     ,  -0.8158D+03,-0.7850D+03,-0.6375D+03,-0.3048D+03, 0.3149D+03,
     ,   0.1372D+04, 0.3090D+04, 0.5794D+04, 0.9967D+04, 0.1632D+05,
     ,   0.2588D+05, 0.4019D+05, 0.6149D+05, 0.9307D+05, 0.1398D+06,
     ,   0.2087D+06, 0.3103D+06, 0.4598D+06/
      data (calcpts(j, 4), j = 1,neta) /
     ,  -0.3309D+05,-0.3095D+05,-0.2891D+05,-0.2695D+05,-0.2509D+05,
     ,  -0.2331D+05,-0.2162D+05,-0.2001D+05,-0.1847D+05,-0.1702D+05,
     ,  -0.1564D+05,-0.1434D+05,-0.1311D+05,-0.1195D+05,-0.1086D+05,
     ,  -0.9834D+04,-0.8872D+04,-0.7973D+04,-0.7134D+04,-0.6354D+04,
     ,  -0.5629D+04,-0.4959D+04,-0.4340D+04,-0.3772D+04,-0.3251D+04,
     ,  -0.2776D+04,-0.2345D+04,-0.1955D+04,-0.1604D+04,-0.1290D+04,
     ,  -0.1011D+04,-0.7646D+03,-0.5490D+03,-0.3622D+03,-0.2028D+03,
     ,  -0.6982D+02, 0.3705D+02, 0.1173D+03, 0.1698D+03, 0.1935D+03,
     ,   0.1888D+03, 0.1594D+03, 0.1129D+03, 0.6011D+02, 0.1008D+02,
     ,  -0.3354D+02,-0.7381D+02,-0.1177D+03,-0.1723D+03,-0.2421D+03,
     ,  -0.3290D+03,-0.4323D+03,-0.5497D+03,-0.6773D+03,-0.8090D+03,
     ,  -0.9358D+03,-0.1044D+04,-0.1111D+04,-0.1106D+04,-0.9798D+03,
     ,  -0.6610D+03,-0.4241D+02, 0.1034D+04, 0.2801D+04, 0.5602D+04,
     ,   0.9941D+04, 0.1656D+05, 0.2655D+05, 0.4152D+05, 0.6381D+05,
     ,   0.9688D+05, 0.1458D+06, 0.2180D+06/
      data (calcpts(j, 5), j = 1,neta) /
     ,  -0.3498D+05,-0.3276D+05,-0.3063D+05,-0.2860D+05,-0.2666D+05,
     ,  -0.2481D+05,-0.2304D+05,-0.2135D+05,-0.1975D+05,-0.1823D+05,
     ,  -0.1679D+05,-0.1542D+05,-0.1413D+05,-0.1291D+05,-0.1176D+05,
     ,  -0.1067D+05,-0.9656D+04,-0.8704D+04,-0.7813D+04,-0.6982D+04,
     ,  -0.6210D+04,-0.5493D+04,-0.4831D+04,-0.4220D+04,-0.3659D+04,
     ,  -0.3145D+04,-0.2677D+04,-0.2253D+04,-0.1870D+04,-0.1526D+04,
     ,  -0.1218D+04,-0.9459D+03,-0.7059D+03,-0.4964D+03,-0.3158D+03,
     ,  -0.1626D+03,-0.3570D+02, 0.6502D+02, 0.1391D+03, 0.1856D+03,
     ,   0.2038D+03, 0.1944D+03, 0.1614D+03, 0.1130D+03, 0.5941D+02,
     ,   0.9113D+01,-0.3531D+02,-0.7780D+02,-0.1260D+03,-0.1873D+03,
     ,  -0.2671D+03,-0.3683D+03,-0.4921D+03,-0.6391D+03,-0.8096D+03,
     ,  -0.1004D+04,-0.1222D+04,-0.1463D+04,-0.1725D+04,-0.2005D+04,
     ,  -0.2295D+04,-0.2587D+04,-0.2862D+04,-0.3095D+04,-0.3248D+04,
     ,  -0.3263D+04,-0.3052D+04,-0.2490D+04,-0.1387D+04, 0.5357D+03,
     ,   0.3686D+04, 0.8665D+04, 0.1636D+05/
      data (calcpts(j, 6), j = 1,neta) /
     ,  -0.3701D+05,-0.3470D+05,-0.3249D+05,-0.3037D+05,-0.2835D+05,
     ,  -0.2642D+05,-0.2457D+05,-0.2281D+05,-0.2114D+05,-0.1954D+05,
     ,  -0.1803D+05,-0.1659D+05,-0.1523D+05,-0.1395D+05,-0.1273D+05,
     ,  -0.1159D+05,-0.1051D+05,-0.9502D+04,-0.8557D+04,-0.7673D+04,
     ,  -0.6849D+04,-0.6083D+04,-0.5372D+04,-0.4716D+04,-0.4111D+04,
     ,  -0.3556D+04,-0.3049D+04,-0.2587D+04,-0.2168D+04,-0.1791D+04,
     ,  -0.1453D+04,-0.1151D+04,-0.8839D+03,-0.6495D+03,-0.4456D+03,
     ,  -0.2706D+03,-0.1230D+03,-0.1800D+01, 0.9314D+02, 0.1615D+03,
     ,   0.2023D+03