c;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Fortran -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; hadr5n12.f --- 
c;; Author          : Friedrich Jegerlehner
c;; Created On      : Wed Aug  3 18:09:58 2011
c;; Last Modified By: Friedrich Jegerlehner
c;; Last Modified On: Sun Apr  1 14:42:27 2012
c;; RCS: $Id$
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; Copyright (C) 2012 Friedrich Jegerlehner
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;;
       subroutine hadr5n12(e,st2,der,errder,deg,errdeg)
c Provides real part of 5 flavor hadronic contribution to photon vacuum polarization
c single precision HADR5 ; double precision DHADR5
c ******************************************************************
c *                                                                *
c *      subroutine for the evaluation of the light hadron         *
c *           contributions to Delta_r  and  Delta_g               *
c *                    using fits to the                           *
c *          QED vacuum polarization from e^+ e^- data             *
c *                                                                *
c *    F. Jegerlehner, Institut fr Physik                         *
c *                    Humboldt-Universitt zu Berlin              *
c *                    Newtonstrae 15, D-12489 Berlin, Germany    *
c *    E-mail: fjeger@physik.hu-berlin.de                          *
c *    Phone :   +49-3375 500 277                                  *
c *                                                                *
c *    Reference: F. Jegerlehner, Z. Phys. C32 (1986) 195          *
c *               H. Burkhardt et al., Z. Phys. C42 (1989) 497     *
c *               S. Eidelman, F. Jegerlehner, Z. Phys. C (1995)   *
c *               F. Jegerlehner,                                  *
c *                    Nucl.Phys.Proc.Suppl.131:213-222,2004       *
c *                    Nucl.Phys.Proc.Suppl.162:22-32,2006         *
c *                    Nucl.Phys.Proc.Suppl.181-182:135-140,2008   *
c *                                                                *
c ******************************************************************
c       VERSION: 09/09/2009
c
C  Notation: E energy ( momentum transfer ): E>0 timelike , E<0 spacelike
c      sin2ell=0.23153 ! pm 0.00016 LEPEEWG Phys Rep 427 (2006) 257
C            st2 is sin^2(Theta); st2=0.23153 is the reference value
C  the routine returns the hadronic contribution of 5 flavors (u,d,s,c,b)
C                 to   DER=Delta_r with hadronic error ERRDER
C                and   DEG=Delta_g with hadronic error ERRDEG
C  The effective value of the fine structure constant alphaQED at energy
C  E is alphaQED(E)=alphaQED(0)/(1-Delta_r) ,similarly for the SU(2)
C  coupling alphaSU2(E)=alphaSU2(0)/(1-Delta_g), where Delta_r(g) is the
C  sum of leptonic, hadronic contributions (top to be added).
C
      IMPLICIT NONE
      INTEGER NA,NB,NC,IJ,I,ini
      PARAMETER(NA=979,NB=2164,NC=200)
      real e,st2,der,errder,deg,errdeg,fac
      real dal(2),dg2(2)
      REAL ETA(NA),DAT(NA,2),DGT(NA,2),DGT3(NA,2)
      REAL ESA(NB),DAS(NB,2),DGS(NB,2),DGS3(NB,2)
      REAL EMA(NC),DAM(NC,2),DGM(NC,2),DGM3(NC,2)
      COMMON /DATM12/EMA,DAM,DGM,DGM3
      COMMON /DATT12/ETA,DAT,DGT,DGT3
      COMMON /DATS12/ESA,DAS,DGS,DGS3
      data ini/0/
C initialize data

      call dalhad_spacelike12

      call dalhad_timelike12

      call dalhad_timelike1h12

c boundaries of data sets
c space-like and unphysical region  -1.0000E+03 - 0.27599999D0 (ETA,DAT)
c time-like R data range 0.28207018D0 - 38.29000000D0          (ESA,DAS)
c time-like1 pQCD range 1.3005E+01 - 2.0000E+04                (EMA,DAM)
c 2 pion threshold at 0.27914....
      fac=0.23153d0/st2
      if (e.eq.0.0) then
        der=0.0
        errder=0.0
        deg=0.0
        errdeg=0.0
        return
c first bridge cracks between regions
      else if ((e.ge.ETA(NA)).and.(e.lt.ESA(1))) then
        DO I=1,2
        dal(i)=DAT(NA,I)
     &    +(DAS(1,I)-DAT(NA,I))/(ESA(1)-ETA(NA))*(E-ETA(NA))
        dg2(i)=DGT(NA,I)
     &    +(DGS(1,I)-DGT(NA,I))/(ESA(1)-ETA(NA))*(E-ETA(NA))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.ETA(NA)).and.(e.ge.ETA(1))) then
        ij=NA
        do while (ETA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=DAT(IJ,I)
     &    +(DAT(IJ+1,I)-DAT(IJ,I))/(ETA(IJ+1)-ETA(IJ))*(E-ETA(IJ))
        dg2(i)=DGT(IJ,I)
     &    +(DGT(IJ+1,I)-DGT(IJ,I))/(ETA(IJ+1)-ETA(IJ))*(E-ETA(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.EMA(NC)).and.(e.ge.EMA(1))) then
        ij=NC
        do while (EMA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=DAM(IJ,I)
     &    +(DAM(IJ+1,I)-DAM(IJ,I))/(EMA(IJ+1)-EMA(IJ))*(E-EMA(IJ))
        dg2(i)=DGM(IJ,I)
     &    +(DGM(IJ+1,I)-DGM(IJ,I))/(EMA(IJ+1)-EMA(IJ))*(E-EMA(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.ESA(NB)).and.(e.ge.ESA(1))) then
        if ((e.gt.3.96).and.(e.lt.4.52).and.(ini.eq.0)) then
c           write (*,*) ' ******************************************'
c           write (*,*) ' * Note: fluctuations in the Psi(4,5,6)   *'
c           write (*,*) ' * region are because we are using the    *'
c           write (*,*) ' * CB and BES data without any smoothing  *'
c           write (*,*) ' *********** FJ@HU Berlin *****************'
           ini=1
        endif
        ij=NB
        do while (ESA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=DAS(IJ,I)
     &    +(DAS(IJ+1,I)-DAS(IJ,I))/(ESA(IJ+1)-ESA(IJ))*(E-ESA(IJ))
        dg2(i)=DGS(IJ,I)
     &    +(DGS(IJ+1,I)-DGS(IJ,I))/(ESA(IJ+1)-ESA(IJ))*(E-ESA(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else
         write(*,*) ' out of range! '
      endif
      return
      end

       subroutine dhadr5n12(de,dst2,dder,derrder,ddeg,derrdeg)
c **********************************************************************
c *    F. Jegerlehner, University of Silesia, PL-40007 Katowice, Poland *
c **********************************************************************
c Converts hadr5n09 to double precision variables in dhadr5n09
c
       implicit none
       real *8 de,dst2,dder,ddeg,derrder,derrdeg
       real    se,sst2,sder,sdeg,serrder,serrdeg
       se  =sngl(de)
       sst2=sngl(dst2)
       call hadr5n12(se,sst2,sder,serrder,sdeg,serrdeg)
       dder   =dble(sder)
       ddeg   =dble(sdeg)
       derrder=dble(serrder)
       derrdeg=dble(serrdeg)
       return
       end
c
c Following datasets obtained with run parameters specified in the header
c

       subroutine dalhad_timelike12
       IMPLICIT NONE
       INTEGER NB,I,J
       PARAMETER(NB=2164)
       REAL ESA(NB),DAS(NB,2),DGS(NB,2),DGS3(NB,2)
       COMMON /DATS12/ESA,DAS,DGS,DGS3

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 15:24:12 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: 1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
c replaced March 30, 2012 [dalhads.dat;432]
  
       DATA  (ESA(I), I=   1, 100) /
     &   0.28207018D0, 0.28800000D0, 0.29400000D0, 0.30000000D0,
     &   0.30600000D0, 0.30900000D0, 0.31500000D0, 0.32600000D0,
     &   0.33100000D0, 0.33600000D0, 0.34100000D0, 0.34600000D0,
     &   0.35200000D0, 0.35600000D0, 0.36100000D0, 0.36600000D0,
     &   0.37100000D0, 0.37600000D0, 0.38000000D0, 0.38500000D0,
     &   0.38900000D0, 0.39400000D0, 0.39800000D0, 0.40300000D0,
     &   0.40700000D0, 0.41100000D0, 0.41600000D0, 0.41871100D0,
     &   0.42000000D0, 0.42400000D0, 0.42800000D0, 0.43200000D0,
     &   0.43600000D0, 0.44000000D0, 0.44400000D0, 0.44800000D0,
     &   0.45200000D0, 0.45600000D0, 0.46000000D0, 0.46400000D0,
     &   0.46700000D0, 0.47100000D0, 0.47500000D0, 0.47800000D0,
     &   0.48200000D0, 0.48600000D0, 0.48900000D0, 0.49300000D0,
     &   0.49600000D0, 0.50000000D0, 0.52000000D0, 0.54000000D0,
     &   0.56600000D0, 0.59200000D0, 0.60000000D0, 0.60200000D0,
     &   0.60800000D0, 0.61600000D0, 0.62400000D0, 0.63200000D0,
     &   0.64000000D0, 0.64300000D0, 0.64800000D0, 0.65600000D0,
     &   0.66300000D0, 0.67100000D0, 0.67800000D0, 0.68600000D0,
     &   0.68800000D0, 0.69300000D0, 0.69600000D0, 0.70000000D0,
     &   0.70700000D0, 0.71400000D0, 0.72100000D0, 0.72800000D0,
     &   0.73500000D0, 0.74200000D0, 0.74800000D0, 0.75000000D0,
     &   0.75500000D0, 0.75744000D0, 0.76007300D0, 0.76207300D0,
     &   0.76507300D0, 0.76851700D0, 0.77060500D0, 0.77205400D0,
     &   0.77314300D0, 0.77400300D0, 0.77470900D0, 0.77530500D0,
     &   0.77582000D0, 0.77627100D0, 0.77667300D0, 0.77726600D0,
     &   0.77746600D0, 0.77766900D0, 0.77795100D0, 0.77821500D0/
       DATA  (ESA(I), I= 101, 200) /
     &   0.77846300D0, 0.77869800D0, 0.77892200D0, 0.77913700D0,
     &   0.77934400D0, 0.77954500D0, 0.77974200D0, 0.77993500D0,
     &   0.78012700D0, 0.78031800D0, 0.78051000D0, 0.78070600D0,
     &   0.78090800D0, 0.78112100D0, 0.78135100D0, 0.78161200D0,
     &   0.78193600D0, 0.78268000D0, 0.78341500D0, 0.78373400D0,
     &   0.78399100D0, 0.78421700D0, 0.78442600D0, 0.78462500D0,
     &   0.78481700D0, 0.78500500D0, 0.78519100D0, 0.78537800D0,
     &   0.78556600D0, 0.78575600D0, 0.78595100D0, 0.78615100D0,
     &   0.78635800D0, 0.78657300D0, 0.78679800D0, 0.78703400D0,
     &   0.78728400D0, 0.78755000D0, 0.78773500D0, 0.78793500D0,
     &   0.78814300D0, 0.78847900D0, 0.78884800D0, 0.78925800D0,
     &   0.78971900D0, 0.79024600D0, 0.79085900D0, 0.79158800D0,
     &   0.79248000D0, 0.79361500D0, 0.79513900D0, 0.79736300D0,
     &   0.79800000D0, 0.80000000D0, 0.80200000D0, 0.80400000D0,
     &   0.80600000D0, 0.80800000D0, 0.81200000D0, 0.81400000D0,
     &   0.81600000D0, 0.82000000D0, 0.82200000D0, 0.82400000D0,
     &   0.82600000D0, 0.82800000D0, 0.83000000D0, 0.83100000D0,
     &   0.83700000D0, 0.84300000D0, 0.84900000D0, 0.85400000D0,
     &   0.86000000D0, 0.86600000D0, 0.87200000D0, 0.87700000D0,
     &   0.88300000D0, 0.88900000D0, 0.89400000D0, 0.89700000D0,
     &   0.90250000D0, 0.90500000D0, 0.91100000D0, 0.91600000D0,
     &   0.92200000D0, 0.92700000D0, 0.93300000D0, 0.93800000D0,
     &   0.94300000D0, 0.94900000D0, 0.95200000D0, 0.95400000D0,
     &   0.95800000D0, 0.96000000D0, 0.96200000D0, 0.96400000D0,
     &   0.96600000D0, 0.96800000D0, 0.97000000D0, 0.97400000D0/
       DATA  (ESA(I), I= 201, 300) /
     &   0.97800000D0, 0.98000000D0, 0.98070000D0, 0.98140000D0,
     &   0.98210000D0, 0.98280000D0, 0.98350000D0, 0.98420000D0,
     &   0.98490000D0, 0.98560000D0, 0.98630000D0, 0.98700000D0,
     &   0.98770000D0, 0.98840000D0, 0.98910000D0, 0.98980000D0,
     &   0.99050000D0, 0.99120000D0, 0.99190000D0, 0.99260000D0,
     &   0.99330000D0, 0.99400000D0, 0.99470000D0, 0.99540000D0,
     &   0.99610000D0, 0.99680000D0, 0.99750000D0, 0.99820000D0,
     &   0.99890000D0, 0.99960000D0, 0.99990000D0, 1.00001000D0,
     &   1.00030000D0, 1.00100000D0, 1.00170000D0, 1.00240000D0,
     &   1.00310000D0, 1.00380000D0, 1.00450000D0, 1.00520000D0,
     &   1.00590000D0, 1.00660000D0, 1.00730000D0, 1.00800000D0,
     &   1.00870000D0, 1.00940000D0, 1.01010000D0, 1.01080000D0,
     &   1.01150000D0, 1.01220000D0, 1.01290000D0, 1.01360000D0,
     &   1.01430000D0, 1.01500000D0, 1.01520000D0, 1.01540000D0,
     &   1.01560000D0, 1.01580000D0, 1.01600000D0, 1.01620000D0,
     &   1.01640000D0, 1.01660000D0, 1.01680000D0, 1.01700000D0,
     &   1.01720000D0, 1.01740000D0, 1.01770000D0, 1.01790000D0,
     &   1.01800000D0, 1.01820000D0, 1.01840000D0, 1.01860000D0,
     &   1.01880000D0, 1.01900000D0, 1.01920000D0, 1.01940000D0,
     &   1.01960000D0, 1.01980000D0, 1.02000000D0, 1.02020000D0,
     &   1.02040000D0, 1.02060000D0, 1.02080000D0, 1.02100000D0,
     &   1.02120000D0, 1.02140000D0, 1.02160000D0, 1.02180000D0,
     &   1.02200000D0, 1.02220000D0, 1.02240000D0, 1.02270000D0,
     &   1.02290000D0, 1.02300000D0, 1.02320000D0, 1.02340000D0,
     &   1.02360000D0, 1.02380000D0, 1.02400000D0, 1.02420000D0/
       DATA  (ESA(I), I= 301, 400) /
     &   1.02440000D0, 1.02460000D0, 1.02480000D0, 1.02500000D0,
     &   1.02570000D0, 1.02640000D0, 1.02710000D0, 1.02780000D0,
     &   1.02850000D0, 1.02920000D0, 1.02990000D0, 1.03060000D0,
     &   1.03130000D0, 1.03200000D0, 1.03270000D0, 1.03340000D0,
     &   1.03410000D0, 1.03480000D0, 1.03550000D0, 1.03620000D0,
     &   1.03690000D0, 1.03760000D0, 1.03830000D0, 1.03900000D0,
     &   1.03970000D0, 1.03999000D0, 1.04001000D0, 1.04040000D0,
     &   1.04110000D0, 1.04180000D0, 1.04250000D0, 1.04320000D0,
     &   1.04390000D0, 1.04460000D0, 1.04530000D0, 1.04600000D0,
     &   1.04670000D0, 1.04740000D0, 1.04810000D0, 1.04880000D0,
     &   1.04950000D0, 1.05020000D0, 1.05090000D0, 1.05160000D0,
     &   1.05230000D0, 1.05300000D0, 1.05370000D0, 1.05440000D0,
     &   1.05510000D0, 1.05580000D0, 1.05650000D0, 1.05720000D0,
     &   1.05790000D0, 1.05860000D0, 1.05930000D0, 1.06000000D0,
     &   1.06200000D0, 1.06700000D0, 1.07700000D0, 1.08700000D0,
     &   1.09700000D0, 1.10700000D0, 1.11700000D0, 1.12700000D0,
     &   1.13700000D0, 1.13800000D0, 1.15200000D0, 1.16300000D0,
     &   1.16700000D0, 1.17700000D0, 1.18700000D0, 1.18800000D0,
     &   1.19700000D0, 1.20700000D0, 1.21200000D0, 1.21700000D0,
     &   1.22700000D0, 1.23700000D0, 1.24700000D0, 1.25700000D0,
     &   1.26300000D0, 1.26700000D0, 1.27700000D0, 1.28700000D0,
     &   1.28800000D0, 1.29700000D0, 1.30700000D0, 1.31200000D0,
     &   1.31700000D0, 1.32700000D0, 1.33700000D0, 1.34700000D0,
     &   1.35000000D0, 1.35700000D0, 1.36200000D0, 1.36700000D0,
     &   1.37700000D0, 1.38700000D0, 1.38800000D0, 1.39500000D0/
       DATA  (ESA(I), I= 401, 500) /
     &   1.41000000D0, 1.41900000D0, 1.42700000D0, 1.43500000D0,
     &   1.43800000D0, 1.45200000D0, 1.45700000D0, 1.46000000D0,
     &   1.46400000D0, 1.47200000D0, 1.48100000D0, 1.49000000D0,
     &   1.49100000D0, 1.50000000D0, 1.50100000D0, 1.50600000D0,
     &   1.51000000D0, 1.52300000D0, 1.52500000D0, 1.53800000D0,
     &   1.53900000D0, 1.54000000D0, 1.55000000D0, 1.56000000D0,
     &   1.56200000D0, 1.57400000D0, 1.57500000D0, 1.58000000D0,
     &   1.58100000D0, 1.58700000D0, 1.59000000D0, 1.59900000D0,
     &   1.60000000D0, 1.61000000D0, 1.61900000D0, 1.62400000D0,
     &   1.62500000D0, 1.63800000D0, 1.64000000D0, 1.65000000D0,
     &   1.65700000D0, 1.66000000D0, 1.66200000D0, 1.66300000D0,
     &   1.67300000D0, 1.67500000D0, 1.68100000D0, 1.68700000D0,
     &   1.69000000D0, 1.70000000D0, 1.71000000D0, 1.71200000D0,
     &   1.71300000D0, 1.71900000D0, 1.72200000D0, 1.72500000D0,
     &   1.73800000D0, 1.74000000D0, 1.74600000D0, 1.75000000D0,
     &   1.75600000D0, 1.75700000D0, 1.76000000D0, 1.76200000D0,
     &   1.76400000D0, 1.76900000D0, 1.77500000D0, 1.78100000D0,
     &   1.79000000D0, 1.79900000D0, 1.80000000D0, 1.81200000D0,
     &   1.81900000D0, 1.82500000D0, 1.82600000D0, 1.83400000D0,
     &   1.83500000D0, 1.83800000D0, 1.84500000D0, 1.85700000D0,
     &   1.85900000D0, 1.87400000D0, 1.88100000D0, 1.88600000D0,
     &   1.90000000D0, 1.91900000D0, 1.92500000D0, 1.93000000D0,
     &   1.93800000D0, 1.94000000D0, 1.94500000D0, 1.94600000D0,
     &   1.95000000D0, 1.95500000D0, 1.96000000D0, 1.96200000D0,
     &   1.98100000D0, 1.99050000D0, 2.00500000D0, 2.05000000D0/
       DATA  (ESA(I), I= 501, 600) /
     &   2.10000000D0, 2.15000000D0, 2.22000000D0, 2.26000000D0,
     &   2.30000000D0, 2.40000000D0, 2.45000000D0, 2.50000000D0,
     &   2.55000000D0, 2.60000000D0, 2.65000000D0, 2.70000000D0,
     &   2.75000000D0, 2.80000000D0, 2.85000000D0, 2.90000000D0,
     &   2.91000000D0, 2.92000000D0, 2.93000000D0, 2.94000000D0,
     &   2.95000000D0, 2.96000000D0, 2.97000000D0, 2.97200000D0,
     &   2.97400000D0, 2.97600000D0, 2.97800000D0, 2.98000000D0,
     &   2.98200000D0, 2.98400000D0, 2.98600000D0, 2.98800000D0,
     &   2.99000000D0, 2.99900000D0, 3.00500000D0, 3.00800000D0,
     &   3.01000000D0, 3.01200000D0, 3.01400000D0, 3.01600000D0,
     &   3.01800000D0, 3.02000000D0, 3.02100000D0, 3.02200000D0,
     &   3.02300000D0, 3.02400000D0, 3.02500000D0, 3.02600000D0,
     &   3.02700000D0, 3.02800000D0, 3.02900000D0, 3.03000000D0,
     &   3.03100000D0, 3.03200000D0, 3.03300000D0, 3.03400000D0,
     &   3.03500000D0, 3.03600000D0, 3.03700000D0, 3.03800000D0,
     &   3.03900000D0, 3.04000000D0, 3.04100000D0, 3.04200000D0,
     &   3.04300000D0, 3.04400000D0, 3.04500000D0, 3.04600000D0,
     &   3.04700000D0, 3.04800000D0, 3.04900000D0, 3.05000000D0,
     &   3.05100000D0, 3.05200000D0, 3.05300000D0, 3.05400000D0,
     &   3.05500000D0, 3.05600000D0, 3.05700000D0, 3.05800000D0,
     &   3.05900000D0, 3.06000000D0, 3.06050000D0, 3.06100000D0,
     &   3.06150000D0, 3.06200000D0, 3.06250000D0, 3.06300000D0,
     &   3.06350000D0, 3.06400000D0, 3.06450000D0, 3.06500000D0,
     &   3.06550000D0, 3.06600000D0, 3.06650000D0, 3.06700000D0,
     &   3.06750000D0, 3.06800000D0, 3.06850000D0, 3.06900000D0/
       DATA  (ESA(I), I= 601, 700) /
     &   3.06950000D0, 3.07000000D0, 3.07050000D0, 3.07100000D0,
     &   3.07150000D0, 3.07200000D0, 3.07250000D0, 3.07300000D0,
     &   3.07350000D0, 3.07400000D0, 3.07450000D0, 3.07500000D0,
     &   3.07550000D0, 3.07600000D0, 3.07650000D0, 3.07700000D0,
     &   3.07750000D0, 3.07800000D0, 3.07850000D0, 3.07900000D0,
     &   3.07970000D0, 3.08000000D0, 3.08050000D0, 3.08100000D0,
     &   3.08150000D0, 3.08200000D0, 3.08250000D0, 3.08300000D0,
     &   3.08350000D0, 3.08400000D0, 3.08450000D0, 3.08500000D0,
     &   3.08550000D0, 3.08587000D0, 3.08688300D0, 3.08789600D0,
     &   3.08890900D0, 3.08992200D0, 3.09093500D0, 3.09194800D0,
     &   3.09296100D0, 3.09397400D0, 3.09498700D0, 3.09600000D0,
     &   3.09605000D0, 3.09610000D0, 3.09615000D0, 3.09620000D0,
     &   3.09625000D0, 3.09630000D0, 3.09635000D0, 3.09640000D0,
     &   3.09645000D0, 3.09650000D0, 3.09655000D0, 3.09660000D0,
     &   3.09665000D0, 3.09665500D0, 3.09673500D0, 3.09677100D0,
     &   3.09679300D0, 3.09680900D0, 3.09682000D0, 3.09682900D0,
     &   3.09683600D0, 3.09684300D0, 3.09684800D0, 3.09685300D0,
     &   3.09685700D0, 3.09686100D0, 3.09686400D0, 3.09686800D0,
     &   3.09687000D0, 3.09687300D0, 3.09687600D0, 3.09687800D0,
     &   3.09688100D0, 3.09688300D0, 3.09688500D0, 3.09688700D0,
     &   3.09688900D0, 3.09689100D0, 3.09689300D0, 3.09689500D0,
     &   3.09689700D0, 3.09689900D0, 3.09690100D0, 3.09690400D0,
     &   3.09690600D0, 3.09690900D0, 3.09691200D0, 3.09692000D0,
     &   3.09692800D0, 3.09693100D0, 3.09693400D0, 3.09693600D0,
     &   3.09693900D0, 3.09694100D0, 3.09694300D0, 3.09694500D0/
       DATA  (ESA(I), I= 701, 800) /
     &   3.09694700D0, 3.09694900D0, 3.09695100D0, 3.09695300D0,
     &   3.09695500D0, 3.09695700D0, 3.09695900D0, 3.09696200D0,
     &   3.09696400D0, 3.09696700D0, 3.09697000D0, 3.09697200D0,
     &   3.09697600D0, 3.09697900D0, 3.09698300D0, 3.09698700D0,
     &   3.09699200D0, 3.09699700D0, 3.09700400D0, 3.09701100D0,
     &   3.09702000D0, 3.09703100D0, 3.09704700D0, 3.09706900D0,
     &   3.09710500D0, 3.09715000D0, 3.09720000D0, 3.09725000D0,
     &   3.09730000D0, 3.09735000D0, 3.09740000D0, 3.09745000D0,
     &   3.09750000D0, 3.09755000D0, 3.09760000D0, 3.09765000D0,
     &   3.09770000D0, 3.09775000D0, 3.09780000D0, 3.09785000D0,
     &   3.09790000D0, 3.09795000D0, 3.09800000D0, 3.09898700D0,
     &   3.09997400D0, 3.10096100D0, 3.10194800D0, 3.10293500D0,
     &   3.10392200D0, 3.10490900D0, 3.10589600D0, 3.10688300D0,
     &   3.10787000D0, 3.10800000D0, 3.10900000D0, 3.11000000D0,
     &   3.11100000D0, 3.11200000D0, 3.11300000D0, 3.11400000D0,
     &   3.11500000D0, 3.11600000D0, 3.11700000D0, 3.11800000D0,
     &   3.11900000D0, 3.12000000D0, 3.12100000D0, 3.12200000D0,
     &   3.12300000D0, 3.12400000D0, 3.12500000D0, 3.12600000D0,
     &   3.12700000D0, 3.12800000D0, 3.12900000D0, 3.13000000D0,
     &   3.13100000D0, 3.13200000D0, 3.13300000D0, 3.13400000D0,
     &   3.13500000D0, 3.13600000D0, 3.13700000D0, 3.13800000D0,
     &   3.13900000D0, 3.14000000D0, 3.14100000D0, 3.14200000D0,
     &   3.14300000D0, 3.14400000D0, 3.14500000D0, 3.14600000D0,
     &   3.14700000D0, 3.14800000D0, 3.14900000D0, 3.15000000D0,
     &   3.15100000D0, 3.15200000D0, 3.15300000D0, 3.15400000D0/
       DATA  (ESA(I), I= 801, 900) /
     &   3.15500000D0, 3.15600000D0, 3.15700000D0, 3.15800000D0,
     &   3.15900000D0, 3.16000000D0, 3.16100000D0, 3.16200000D0,
     &   3.16300000D0, 3.16400000D0, 3.16500000D0, 3.16600000D0,
     &   3.16700000D0, 3.16800000D0, 3.16900000D0, 3.17000000D0,
     &   3.17100000D0, 3.17200000D0, 3.17300000D0, 3.17400000D0,
     &   3.17500000D0, 3.17600000D0, 3.17700000D0, 3.17800000D0,
     &   3.17900000D0, 3.18000000D0, 3.18100000D0, 3.18200000D0,
     &   3.18300000D0, 3.18400000D0, 3.18500000D0, 3.18600000D0,
     &   3.18700000D0, 3.18800000D0, 3.18900000D0, 3.19000000D0,
     &   3.19100000D0, 3.19200000D0, 3.19300000D0, 3.19400000D0,
     &   3.19500000D0, 3.19600000D0, 3.19700000D0, 3.19800000D0,
     &   3.19900000D0, 3.19990000D0, 3.20100000D0, 3.20200000D0,
     &   3.20300000D0, 3.20400000D0, 3.20500000D0, 3.20600000D0,
     &   3.20700000D0, 3.20800000D0, 3.20900000D0, 3.21000000D0,
     &   3.25000000D0, 3.30000000D0, 3.37000000D0, 3.45000000D0,
     &   3.50000000D0, 3.52000000D0, 3.54000000D0, 3.56000000D0,
     &   3.57500000D0, 3.59000000D0, 3.59500000D0, 3.60500000D0,
     &   3.61000000D0, 3.61500000D0, 3.62000000D0, 3.62500000D0,
     &   3.63000000D0, 3.63500000D0, 3.64000000D0, 3.64500000D0,
     &   3.65000000D0, 3.65200000D0, 3.65400000D0, 3.65600000D0,
     &   3.65800000D0, 3.66000000D0, 3.66200000D0, 3.66300000D0,
     &   3.66400000D0, 3.66500000D0, 3.66600000D0, 3.66700000D0,
     &   3.66800000D0, 3.66900000D0, 3.67000000D0, 3.67100000D0,
     &   3.67200000D0, 3.67300000D0, 3.67400000D0, 3.67496000D0,
     &   3.67551000D0, 3.67606000D0, 3.67661000D0, 3.67716000D0/
       DATA  (ESA(I), I= 901,1000) /
     &   3.67771000D0, 3.67826000D0, 3.67881000D0, 3.67936000D0,
     &   3.67991000D0, 3.68046000D0, 3.68101000D0, 3.68156000D0,
     &   3.68211000D0, 3.68266000D0, 3.68321000D0, 3.68376000D0,
     &   3.68431000D0, 3.68486000D0, 3.68527300D0, 3.68541000D0,
     &   3.68552000D0, 3.68569900D0, 3.68574600D0, 3.68578100D0,
     &   3.68580900D0, 3.68583200D0, 3.68585100D0, 3.68586800D0,
     &   3.68588300D0, 3.68589500D0, 3.68590700D0, 3.68591800D0,
     &   3.68592800D0, 3.68593700D0, 3.68594600D0, 3.68595300D0,
     &   3.68596100D0, 3.68596800D0, 3.68597500D0, 3.68598200D0,
     &   3.68598800D0, 3.68599500D0, 3.68600100D0, 3.68600700D0,
     &   3.68601300D0, 3.68602000D0, 3.68602600D0, 3.68603300D0,
     &   3.68603900D0, 3.68604700D0, 3.68605500D0, 3.68606600D0,
     &   3.68607500D0, 3.68608500D0, 3.68609000D0, 3.68609500D0,
     &   3.68610000D0, 3.68611400D0, 3.68612500D0, 3.68613300D0,
     &   3.68614100D0, 3.68614700D0, 3.68615400D0, 3.68616000D0,
     &   3.68616700D0, 3.68617300D0, 3.68617900D0, 3.68618500D0,
     &   3.68619200D0, 3.68619800D0, 3.68620500D0, 3.68621200D0,
     &   3.68621900D0, 3.68622700D0, 3.68623400D0, 3.68624300D0,
     &   3.68625200D0, 3.68626200D0, 3.68627300D0, 3.68628500D0,
     &   3.68629700D0, 3.68631200D0, 3.68632900D0, 3.68634800D0,
     &   3.68637100D0, 3.68639900D0, 3.68643400D0, 3.68648100D0,
     &   3.68654800D0, 3.68651000D0, 3.68666000D0, 3.68690700D0,
     &   3.68706000D0, 3.68761000D0, 3.68816000D0, 3.68871000D0,
     &   3.68926000D0, 3.68981000D0, 3.69036000D0, 3.69091000D0,
     &   3.69146000D0, 3.69201000D0, 3.69256000D0, 3.69311000D0/
       DATA  (ESA(I), I=1001,1100) /
     &   3.69366000D0, 3.69421000D0, 3.69476000D0, 3.69531000D0,
     &   3.69586000D0, 3.69641000D0, 3.69696000D0, 3.69796000D0,
     &   3.69950000D0, 3.70050000D0, 3.70250000D0, 3.70450000D0,
     &   3.70700000D0, 3.71200000D0, 3.72128100D0, 3.73082800D0,
     &   3.73660200D0, 3.74060200D0, 3.74360300D0, 3.74597300D0,
     &   3.74791700D0, 3.74955600D0, 3.75096800D0, 3.75220600D0,
     &   3.75330900D0, 3.75430100D0, 3.75520500D0, 3.75603600D0,
     &   3.75680500D0, 3.75752300D0, 3.75819800D0, 3.75883700D0,
     &   3.75944400D0, 3.76002600D0, 3.76058600D0, 3.76112800D0,
     &   3.76165500D0, 3.76217200D0, 3.76268100D0, 3.76318700D0,
     &   3.76369200D0, 3.76420200D0, 3.76472200D0, 3.76526100D0,
     &   3.76582800D0, 3.76644200D0, 3.76713800D0, 3.76800500D0,
     &   3.77000000D0, 3.77199500D0, 3.77286200D0, 3.77355800D0,
     &   3.77417200D0, 3.77474000D0, 3.77527800D0, 3.77579800D0,
     &   3.77630800D0, 3.77681400D0, 3.77731900D0, 3.77782800D0,
     &   3.77834500D0, 3.77887200D0, 3.77941400D0, 3.77997400D0,
     &   3.78055600D0, 3.78116300D0, 3.78180200D0, 3.78247700D0,
     &   3.78319500D0, 3.78396400D0, 3.78479500D0, 3.78569900D0,
     &   3.78669100D0, 3.78779400D0, 3.78903200D0, 3.79044400D0,
     &   3.79208300D0, 3.79402700D0, 3.79639700D0, 3.79939800D0,
     &   3.80339800D0, 3.80917200D0, 3.81871900D0, 3.82200000D0,
     &   3.83200000D0, 3.85000000D0, 3.85200000D0, 3.86700000D0,
     &   3.87300000D0, 3.87800000D0, 3.88400000D0, 3.89000000D0,
     &   3.89600000D0, 3.90000000D0, 3.90200000D0, 3.90800000D0,
     &   3.91400000D0, 3.92000000D0, 3.92600000D0, 3.93200000D0/
       DATA  (ESA(I), I=1101,1200) /
     &   3.93800000D0, 3.94400000D0, 3.95000000D0, 3.95600000D0,
     &   3.96200000D0, 3.96800000D0, 3.97400000D0, 3.98000000D0,
     &   3.98600000D0, 3.99200000D0, 3.99800000D0, 4.00000000D0,
     &   4.00400000D0, 4.01000000D0, 4.01600000D0, 4.02000000D0,
     &   4.02200000D0, 4.02800000D0, 4.03000000D0, 4.03400000D0,
     &   4.04000000D0, 4.04600000D0, 4.05000000D0, 4.05200000D0,
     &   4.05800000D0, 4.06400000D0, 4.07000000D0, 4.07600000D0,
     &   4.08200000D0, 4.08800000D0, 4.09000000D0, 4.09400000D0,
     &   4.10000000D0, 4.10500000D0, 4.10900000D0, 4.11000000D0,
     &   4.11300000D0, 4.11800000D0, 4.12100000D0, 4.12500000D0,
     &   4.12900000D0, 4.13000000D0, 4.13300000D0, 4.13600000D0,
     &   4.14100000D0, 4.14700000D0, 4.15000000D0, 4.15300000D0,
     &   4.15900000D0, 4.16500000D0, 4.17100000D0, 4.17700000D0,
     &   4.18000000D0, 4.18200000D0, 4.18500000D0, 4.19000000D0,
     &   4.19500000D0, 4.19900000D0, 4.20100000D0, 4.20800000D0,
     &   4.21200000D0, 4.21400000D0, 4.22000000D0, 4.22600000D0,
     &   4.23200000D0, 4.23800000D0, 4.24000000D0, 4.24400000D0,
     &   4.25000000D0, 4.25600000D0, 4.26200000D0, 4.26800000D0,
     &   4.27400000D0, 4.28000000D0, 4.29200000D0, 4.30000000D0,
     &   4.30400000D0, 4.31000000D0, 4.31600000D0, 4.32800000D0,
     &   4.33000000D0, 4.34000000D0, 4.35000000D0, 4.35200000D0,
     &   4.36400000D0, 4.37600000D0, 4.38000000D0, 4.38200000D0,
     &   4.38800000D0, 4.39000000D0, 4.39400000D0, 4.40000000D0,
     &   4.40600000D0, 4.41000000D0, 4.41200000D0, 4.41800000D0,
     &   4.42400000D0, 4.43000000D0, 4.43600000D0, 4.44000000D0/
       DATA  (ESA(I), I=1201,1300) /
     &   4.44200000D0, 4.44800000D0, 4.45000000D0, 4.46000000D0,
     &   4.47200000D0, 4.48400000D0, 4.49600000D0, 4.50450000D0,
     &   4.54000000D0, 4.55000000D0, 4.57000000D0, 4.60000000D0,
     &   4.62000000D0, 4.65000000D0, 4.66000000D0, 4.70000000D0,
     &   4.71000000D0, 4.80000000D0, 4.90000000D0, 4.98000000D0,
     &   5.06500000D0, 5.15000000D0, 5.22500000D0, 5.25000000D0,
     &   5.30000000D0, 5.40000000D0, 5.45000000D0, 5.50000000D0,
     &   5.60000000D0, 5.70000000D0, 5.75000000D0, 5.80000000D0,
     &   5.85000000D0, 5.90000000D0, 5.95000000D0, 6.00000000D0,
     &   6.05000000D0, 6.10000000D0, 6.15000000D0, 6.20000000D0,
     &   6.25000000D0, 6.30000000D0, 6.35000000D0, 6.40000000D0,
     &   6.45000000D0, 6.50000000D0, 6.55000000D0, 6.60000000D0,
     &   6.65000000D0, 6.70000000D0, 6.75000000D0, 6.80000000D0,
     &   6.85000000D0, 6.90000000D0, 6.95000000D0, 7.00000000D0,
     &   7.05000000D0, 7.10000000D0, 7.15000000D0, 7.20000000D0,
     &   7.25000000D0, 7.30000000D0, 7.35000000D0, 7.40000000D0,
     &   7.44000000D0, 7.50000000D0, 7.60000000D0, 7.70000000D0,
     &   7.80000000D0, 7.90000000D0, 8.00000000D0, 8.10000000D0,
     &   8.20000000D0, 8.30000000D0, 8.40000000D0, 8.50000000D0,
     &   8.60000000D0, 8.70000000D0, 8.80000000D0, 8.90000000D0,
     &   8.91000000D0, 9.00000000D0, 9.10000000D0, 9.20000000D0,
     &   9.28000000D0, 9.30000000D0, 9.35000000D0, 9.39000000D0,
     &   9.40000000D0, 9.41000000D0, 9.41500000D0, 9.42000000D0,
     &   9.42400000D0, 9.42800000D0, 9.43000000D0, 9.43200000D0,
     &   9.43400000D0, 9.43600000D0, 9.43800000D0, 9.44000000D0/
       DATA  (ESA(I), I=1301,1400) /
     &   9.44100000D0, 9.44200000D0, 9.44300000D0, 9.44400000D0,
     &   9.44500000D0, 9.44600000D0, 9.44700000D0, 9.44800000D0,
     &   9.44900000D0, 9.44937000D0, 9.44959000D0, 9.44981000D0,
     &   9.45003000D0, 9.45025000D0, 9.45047000D0, 9.45069000D0,
     &   9.45091000D0, 9.45113000D0, 9.45135000D0, 9.45157000D0,
     &   9.45179000D0, 9.45201000D0, 9.45223000D0, 9.45245000D0,
     &   9.45267000D0, 9.45289000D0, 9.45311000D0, 9.45333000D0,
     &   9.45355000D0, 9.45377000D0, 9.45399000D0, 9.45421000D0,
     &   9.45443000D0, 9.45465000D0, 9.45487000D0, 9.45509000D0,
     &   9.45531000D0, 9.45553000D0, 9.45575000D0, 9.45597000D0,
     &   9.45619000D0, 9.45641000D0, 9.45663000D0, 9.45685000D0,
     &   9.45707000D0, 9.45729000D0, 9.45751000D0, 9.45773000D0,
     &   9.45795000D0, 9.45817000D0, 9.45839000D0, 9.45861000D0,
     &   9.45883000D0, 9.45905000D0, 9.45927000D0, 9.45949000D0,
     &   9.45971000D0, 9.45993000D0, 9.46000000D0, 9.46014595D0,
     &   9.46019268D0, 9.46021366D0, 9.46022606D0, 9.46023464D0,
     &   9.46024132D0, 9.46024704D0, 9.46025085D0, 9.46025467D0,
     &   9.46025848D0, 9.46026039D0, 9.46026325D0, 9.46026516D0,
     &   9.46026802D0, 9.46026897D0, 9.46027088D0, 9.46027279D0,
     &   9.46027470D0, 9.46027565D0, 9.46027660D0, 9.46027851D0,
     &   9.46027946D0, 9.46028042D0, 9.46028233D0, 9.46028328D0,
     &   9.46028423D0, 9.46028519D0, 9.46028709D0, 9.46028805D0,
     &   9.46028900D0, 9.46029091D0, 9.46029186D0, 9.46029377D0,
     &   9.46029568D0, 9.46030045D0, 9.46030426D0, 9.46030617D0,
     &   9.46030807D0, 9.46030998D0, 9.46031094D0, 9.46031189D0/
       DATA  (ESA(I), I=1401,1500) /
     &   9.46031284D0, 9.46031475D0, 9.46031570D0, 9.46031666D0,
     &   9.46031761D0, 9.46031952D0, 9.46032047D0, 9.46032143D0,
     &   9.46032333D0, 9.46032429D0, 9.46032619D0, 9.46032715D0,
     &   9.46032906D0, 9.46033096D0, 9.46033287D0, 9.46033478D0,
     &   9.46033669D0, 9.46033955D0, 9.46034145D0, 9.46034527D0,
     &   9.46034908D0, 9.46035290D0, 9.46035862D0, 9.46036530D0,
     &   9.46037388D0, 9.46038628D0, 9.46040726D0, 9.46045494D0,
     &   9.46059000D0, 9.46081000D0, 9.46103000D0, 9.46125000D0,
     &   9.46147000D0, 9.46169000D0, 9.46191000D0, 9.46213000D0,
     &   9.46235000D0, 9.46257000D0, 9.46279000D0, 9.46301000D0,
     &   9.46323000D0, 9.46345000D0, 9.46367000D0, 9.46389000D0,
     &   9.46411000D0, 9.46433000D0, 9.46455000D0, 9.46477000D0,
     &   9.46499000D0, 9.46521000D0, 9.46543000D0, 9.46565000D0,
     &   9.46587000D0, 9.46609000D0, 9.46631000D0, 9.46653000D0,
     &   9.46675000D0, 9.46697000D0, 9.46719000D0, 9.46741000D0,
     &   9.46763000D0, 9.46785000D0, 9.46807000D0, 9.46829000D0,
     &   9.46851000D0, 9.46873000D0, 9.46895000D0, 9.46917000D0,
     &   9.46939000D0, 9.46961000D0, 9.46983000D0, 9.47005000D0,
     &   9.47027000D0, 9.47049000D0, 9.47071000D0, 9.47093000D0,
     &   9.47115000D0, 9.47137000D0, 9.47337000D0, 9.47500000D0,
     &   9.47700000D0, 9.48000000D0, 9.48400000D0, 9.49000000D0,
     &   9.49500000D0, 9.50500000D0, 9.51000000D0, 9.51500000D0,
     &   9.52000000D0, 9.52500000D0, 9.53000000D0, 9.54000000D0,
     &   9.55000000D0, 9.60000000D0, 9.70000000D0, 9.80000000D0,
     &   9.90000000D0, 9.95000000D0, 9.97500000D0, 9.99000000D0/
       DATA  (ESA(I), I=1501,1600) /
     &  10.00000000D0,10.01000000D0,10.01100000D0,10.01200000D0,
     &  10.01226000D0,10.01281000D0,10.01336000D0,10.01391000D0,
     &  10.01446000D0,10.01501000D0,10.01556000D0,10.01611000D0,
     &  10.01666000D0,10.01721000D0,10.01776000D0,10.01831000D0,
     &  10.01886000D0,10.01941000D0,10.01996000D0,10.02051000D0,
     &  10.02106000D0,10.02161000D0,10.02216000D0,10.02250000D0,
     &  10.02253750D0,10.02257500D0,10.02261250D0,10.02265000D0,
     &  10.02268750D0,10.02272500D0,10.02276250D0,10.02280000D0,
     &  10.02283750D0,10.02287500D0,10.02291250D0,10.02295000D0,
     &  10.02298750D0,10.02302500D0,10.02306250D0,10.02310000D0,
     &  10.02313750D0,10.02317500D0,10.02321250D0,10.02322000D0,
     &  10.02322500D0,10.02323000D0,10.02323400D0,10.02323700D0,
     &  10.02324000D0,10.02324200D0,10.02324400D0,10.02324600D0,
     &  10.02324800D0,10.02324930D0,10.02324950D0,10.02324960D0,
     &  10.02324980D0,10.02324988D0,10.02324994D0,10.02325000D0,
     &  10.02325060D0,10.02325150D0,10.02325250D0,10.02325340D0,
     &  10.02325440D0,10.02325540D0,10.02325630D0,10.02325680D0,
     &  10.02325730D0,10.02325780D0,10.02325850D0,10.02325900D0,
     &  10.02325950D0,10.02325980D0,10.02325990D0,10.02326000D0,
     &  10.02326010D0,10.02326050D0,10.02326100D0,10.02326150D0,
     &  10.02326390D0,10.02326490D0,10.02326680D0,10.02326770D0,
     &  10.02326870D0,10.02326970D0,10.02327060D0,10.02327160D0,
     &  10.02327250D0,10.02327350D0,10.02327440D0,10.02327540D0,
     &  10.02327630D0,10.02327730D0,10.02327820D0,10.02328010D0,
     &  10.02328110D0,10.02328210D0,10.02328300D0,10.02328490D0/
       DATA  (ESA(I), I=1601,1700) /
     &  10.02328590D0,10.02328750D0,10.02332500D0,10.02336250D0,
     &  10.02340000D0,10.02343750D0,10.02347500D0,10.02351250D0,
     &  10.02355000D0,10.02358750D0,10.02362500D0,10.02366250D0,
     &  10.02370000D0,10.02373750D0,10.02377500D0,10.02381250D0,
     &  10.02385000D0,10.02388750D0,10.02392500D0,10.02396250D0,
     &  10.02400000D0,10.02436000D0,10.02491000D0,10.02546000D0,
     &  10.02601000D0,10.02656000D0,10.02711000D0,10.02766000D0,
     &  10.02821000D0,10.02876000D0,10.02931000D0,10.02986000D0,
     &  10.03041000D0,10.03096000D0,10.03151000D0,10.03206000D0,
     &  10.03261000D0,10.03316000D0,10.03371000D0,10.03426000D0,
     &  10.03500000D0,10.03600000D0,10.03700000D0,10.03800000D0,
     &  10.03900000D0,10.04000000D0,10.04500000D0,10.05000000D0,
     &  10.05500000D0,10.06000000D0,10.06500000D0,10.07000000D0,
     &  10.07500000D0,10.08000000D0,10.20000000D0,10.25000000D0,
     &  10.26000000D0,10.27000000D0,10.28000000D0,10.29000000D0,
     &  10.29500000D0,10.30000000D0,10.31000000D0,10.32000000D0,
     &  10.33000000D0,10.34000000D0,10.34420000D0,10.34493333D0,
     &  10.34566667D0,10.34640000D0,10.34713333D0,10.34786667D0,
     &  10.34860000D0,10.34933333D0,10.35006667D0,10.35080000D0,
     &  10.35153333D0,10.35226667D0,10.35300000D0,10.35309167D0,
     &  10.35318333D0,10.35327500D0,10.35336667D0,10.35345833D0,
     &  10.35355000D0,10.35364167D0,10.35373333D0,10.35382500D0,
     &  10.35391667D0,10.35400833D0,10.35410000D0,10.35419167D0,
     &  10.35428333D0,10.35437500D0,10.35440000D0,10.35446667D0,
     &  10.35455833D0,10.35465000D0,10.35474167D0,10.35483334D0/
       DATA  (ESA(I), I=1701,1800) /
     &  10.35492500D0,10.35501667D0,10.35510834D0,10.35512330D0,
     &  10.35514660D0,10.35515710D0,10.35516340D0,10.35516780D0,
     &  10.35517110D0,10.35517370D0,10.35517580D0,10.35517760D0,
     &  10.35517920D0,10.35518060D0,10.35518180D0,10.35518290D0,
     &  10.35518390D0,10.35518480D0,10.35518570D0,10.35518650D0,
     &  10.35518720D0,10.35518790D0,10.35518860D0,10.35518930D0,
     &  10.35518990D0,10.35519050D0,10.35519110D0,10.35519170D0,
     &  10.35519230D0,10.35519280D0,10.35519340D0,10.35519400D0,
     &  10.35519460D0,10.35519530D0,10.35519600D0,10.35519680D0,
     &  10.35519770D0,10.35520000D0,10.35520230D0,10.35520320D0,
     &  10.35520400D0,10.35520470D0,10.35520540D0,10.35520600D0,
     &  10.35520660D0,10.35520720D0,10.35520770D0,10.35520830D0,
     &  10.35520890D0,10.35520950D0,10.35521010D0,10.35521070D0,
     &  10.35521140D0,10.35521210D0,10.35521280D0,10.35521350D0,
     &  10.35521430D0,10.35521520D0,10.35521610D0,10.35521710D0,
     &  10.35521820D0,10.35521940D0,10.35522080D0,10.35522240D0,
     &  10.35522420D0,10.35522630D0,10.35522890D0,10.35523220D0,
     &  10.35523660D0,10.35524290D0,10.35525340D0,10.35527670D0,
     &  10.35529167D0,10.35538334D0,10.35547500D0,10.35556667D0,
     &  10.35565834D0,10.35575000D0,10.35584167D0,10.35593334D0,
     &  10.35602500D0,10.35611667D0,10.35620834D0,10.35630000D0,
     &  10.35639167D0,10.35648334D0,10.35657500D0,10.35666667D0,
     &  10.35740000D0,10.35813333D0,10.35886667D0,10.35960000D0,
     &  10.36033333D0,10.36106667D0,10.36180000D0,10.36253333D0,
     &  10.36326667D0,10.36400000D0,10.36473333D0,10.36546667D0/
       DATA  (ESA(I), I=1801,1900) /
     &  10.36620000D0,10.37000000D0,10.37500000D0,10.38000000D0,
     &  10.38500000D0,10.39000000D0,10.39500000D0,10.40000000D0,
     &  10.40500000D0,10.41000000D0,10.41500000D0,10.42000000D0,
     &  10.42500000D0,10.43000000D0,10.43500000D0,10.44000000D0,
     &  10.44500000D0,10.45000000D0,10.45500000D0,10.46000000D0,
     &  10.46500000D0,10.47000000D0,10.47300000D0,10.52897000D0,
     &  10.54217000D0,10.54889000D0,10.55317000D0,10.55622000D0,
     &  10.55855000D0,10.56042000D0,10.56197000D0,10.56328000D0,
     &  10.56442000D0,10.56543000D0,10.56633000D0,10.56714000D0,
     &  10.56788000D0,10.56857000D0,10.56921000D0,10.56980000D0,
     &  10.57036000D0,10.57090000D0,10.57141000D0,10.57189000D0,
     &  10.57237000D0,10.57282000D0,10.57327000D0,10.57371000D0,
     &  10.57415000D0,10.57459000D0,10.57503000D0,10.57547000D0,
     &  10.57594000D0,10.57643000D0,10.57695000D0,10.57755000D0,
     &  10.57829000D0,10.58000000D0,10.58171000D0,10.58245000D0,
     &  10.58305000D0,10.58357000D0,10.58406000D0,10.58453000D0,
     &  10.58497000D0,10.58541000D0,10.58585000D0,10.58629000D0,
     &  10.58673000D0,10.58718000D0,10.58763000D0,10.58811000D0,
     &  10.58859000D0,10.58910000D0,10.58964000D0,10.59020000D0,
     &  10.59079000D0,10.59143000D0,10.59212000D0,10.59286000D0,
     &  10.59367000D0,10.59457000D0,10.59558000D0,10.59671000D0,
     &  10.59803000D0,10.59958000D0,10.60145000D0,10.60378000D0,
     &  10.60683000D0,10.61111000D0,10.61783000D0,10.63103000D0,
     &  10.68700000D0,10.69000000D0,10.71309000D0,10.72975000D0,
     &  10.74256000D0,10.75286000D0,10.76141000D0,10.76869000D0/
       DATA  (ESA(I), I=1901,2000) /
     &  10.77500000D0,10.78057000D0,10.78554000D0,10.79004000D0,
     &  10.79414000D0,10.79791000D0,10.80141000D0,10.80468000D0,
     &  10.80775000D0,10.81065000D0,10.81341000D0,10.81604000D0,
     &  10.81858000D0,10.82102000D0,10.82339000D0,10.82570000D0,
     &  10.82796000D0,10.83019000D0,10.83240000D0,10.83460000D0,
     &  10.83681000D0,10.83906000D0,10.84135000D0,10.84374000D0,
     &  10.84626000D0,10.84900000D0,10.85212000D0,10.85601000D0,
     &  10.86500000D0,10.87288000D0,10.87627000D0,10.87895000D0,
     &  10.88128000D0,10.88340000D0,10.88539000D0,10.88728000D0,
     &  10.88910000D0,10.89088000D0,10.89262000D0,10.89434000D0,
     &  10.89605000D0,10.89775000D0,10.89946000D0,10.90119000D0,
     &  10.90292000D0,10.90468000D0,10.90648000D0,10.90830000D0,
     &  10.91017000D0,10.91208000D0,10.91406000D0,10.91609000D0,
     &  10.91820000D0,10.92038000D0,10.92266000D0,10.92504000D0,
     &  10.92754000D0,10.93017000D0,10.93295000D0,10.93590000D0,
     &  10.93905000D0,10.94242000D0,10.94606000D0,10.95000000D0,
     &  10.97500000D0,10.97638000D0,10.97771000D0,10.97900000D0,
     &  10.98025000D0,10.98146000D0,10.98263000D0,10.98377000D0,
     &  10.98489000D0,10.98598000D0,10.98705000D0,10.98810000D0,
     &  10.98913000D0,10.99014000D0,10.99114000D0,10.99213000D0,
     &  10.99310000D0,10.99407000D0,10.99504000D0,10.99600000D0,
     &  10.99697000D0,10.99793000D0,10.99890000D0,10.99988000D0,
     &  11.00087000D0,11.00188000D0,11.00290000D0,11.00396000D0,
     &  11.00506000D0,11.00621000D0,11.00742000D0,11.00873000D0,
     &  11.01018000D0,11.01186000D0,11.01399000D0,11.01900000D0/
       DATA  (ESA(I), I=2001,2100) /
     &  11.02401000D0,11.02614000D0,11.02782000D0,11.02927000D0,
     &  11.03058000D0,11.03179000D0,11.03294000D0,11.03404000D0,
     &  11.03510000D0,11.03612000D0,11.03713000D0,11.03812000D0,
     &  11.03910000D0,11.04007000D0,11.04103000D0,11.04200000D0,
     &  11.04296000D0,11.04392000D0,11.04490000D0,11.04587000D0,
     &  11.04686000D0,11.04786000D0,11.04887000D0,11.04990000D0,
     &  11.05095000D0,11.05202000D0,11.05311000D0,11.05423000D0,
     &  11.05537000D0,11.05654000D0,11.05775000D0,11.05900000D0,
     &  11.06029000D0,11.06162000D0,11.06300000D0,11.07000000D0,
     &  11.09200000D0,11.11500000D0,11.13700000D0,11.16000000D0,
     &  11.18200000D0,11.20500000D0,11.22700000D0,11.25000000D0,
     &  11.27300000D0,11.29500000D0,11.31800000D0,11.34000000D0,
     &  11.50000000D0,11.65500000D0,11.67700000D0,11.70000000D0,
     &  11.72200000D0,11.74500000D0,11.76700000D0,11.79000000D0,
     &  11.81200000D0,11.83500000D0,11.85800000D0,11.88000000D0,
     &  11.90300000D0,11.92500000D0,11.94800000D0,11.97000000D0,
     &  11.99300000D0,12.01500000D0,12.03800000D0,12.06000000D0,
     &  12.08300000D0,12.10500000D0,12.12700000D0,12.15000000D0,
     &  12.17200000D0,12.19500000D0,12.21700000D0,12.24000000D0,
     &  12.26200000D0,12.28500000D0,12.30700000D0,12.33000000D0,
     &  12.35200000D0,12.37500000D0,12.39800000D0,12.42000000D0,
     &  12.44300000D0,12.46500000D0,12.48800000D0,12.51000000D0,
     &  12.53300000D0,12.55500000D0,12.57800000D0,12.60000000D0,
     &  12.62300000D0,12.64500000D0,12.66700000D0,12.69000000D0,
     &  12.71200000D0,12.73500000D0,12.75700000D0,12.78000000D0/
       DATA  (ESA(I), I=2101,2164) /
     &  12.80200000D0,12.82500000D0,12.84700000D0,12.87000000D0,
     &  12.89200000D0,12.91500000D0,12.93800000D0,12.96000000D0,
     &  12.98300000D0,13.00500000D0,13.02800000D0,13.05000000D0,
     &  13.07300000D0,13.09500000D0,13.11800000D0,13.14000000D0,
     &  13.16300000D0,13.18500000D0,13.20800000D0,13.23000000D0,
     &  13.25200000D0,13.27500000D0,13.29700000D0,13.32000000D0,
     &  13.34200000D0,13.36500000D0,13.38700000D0,13.41000000D0,
     &  13.43200000D0,13.45500000D0,13.47700000D0,13.50000000D0,
     &  13.75000000D0,14.00000000D0,14.04000000D0,16.00000000D0,
     &  17.00000000D0,20.00000000D0,21.95000000D0,22.05000000D0,
     &  25.00000000D0,25.01000000D0,27.50000000D0,27.60000000D0,
     &  27.66000000D0,29.00000000D0,29.93000000D0,30.10000000D0,
     &  30.38000000D0,30.80000000D0,31.10000000D0,31.29000000D0,
     &  33.20000000D0,33.30000000D0,33.89000000D0,34.00000000D0,
     &  34.50000000D0,34.70000000D0,34.86000000D0,35.01000000D0,
     &  35.45000000D0,36.10000000D0,36.38000000D0,38.29000000D0/
  
         DATA ((DAS (I,J), I=   1, 100), J=1,1) /
     &  -9.18806502E-04,-9.77925800E-04,-1.03611017E-03,-1.09725856E-03,
     &  -1.16343617E-03,-1.19578263E-03,-1.25086109E-03,-1.34891424E-03,
     &  -1.38582375E-03,-1.42146016E-03,-1.47771817E-03,-1.53248063E-03,
     &  -1.59530652E-03,-1.63672145E-03,-1.68866892E-03,-1.74097991E-03,
     &  -1.79347777E-03,-1.84646003E-03,-1.89039962E-03,-1.94595562E-03,
     &  -1.99144792E-03,-2.04775422E-03,-2.09301334E-03,-2.15198831E-03,
     &  -2.20079411E-03,-2.24934775E-03,-2.31055208E-03,-2.35519644E-03,
     &  -2.36078163E-03,-2.40968396E-03,-2.46103820E-03,-2.51261950E-03,
     &  -2.56503235E-03,-2.61868553E-03,-2.67557341E-03,-2.73335424E-03,
     &  -2.79240680E-03,-2.85072280E-03,-2.91573347E-03,-2.98094631E-03,
     &  -3.03050714E-03,-3.09638199E-03,-3.09392667E-03,-3.21365401E-03,
     &  -3.24188231E-03,-3.35268690E-03,-3.40729270E-03,-3.48360794E-03,
     &  -3.54125714E-03,-3.62225053E-03,-4.06927234E-03,-4.55228477E-03,
     &  -5.24279334E-03,-6.12919988E-03,-6.42615647E-03,-6.51346783E-03,
     &  -6.73950641E-03,-7.05425773E-03,-7.38568055E-03,-7.72332651E-03,
     &  -8.08090198E-03,-8.20149140E-03,-8.41795512E-03,-8.77332083E-03,
     &  -9.07745253E-03,-9.39417807E-03,-9.65665115E-03,-9.89126014E-03,
     &  -9.93121040E-03,-1.00026802E-02,-1.00235070E-02,-1.00384522E-02,
     &  -9.93148830E-03,-9.67362686E-03,-9.27327065E-03,-8.66848867E-03,
     &  -7.38416098E-03,-6.94249385E-03,-6.08293508E-03,-5.80931018E-03,
     &  -5.07574021E-03,-4.82665618E-03,-4.65550661E-03,-4.55791682E-03,
     &  -4.51659108E-03,-4.84100387E-03,-5.27355159E-03,-5.64282337E-03,
     &  -5.97807474E-03,-6.36582255E-03,-6.53061737E-03,-6.70301630E-03,
     &  -6.83406489E-03,-6.90460036E-03,-6.85940542E-03,-6.79273726E-03,
     &  -6.69275038E-03,-6.59124383E-03,-6.39038928E-03,-6.19141602E-03/
  
         DATA ((DAS (I,J), I= 101, 200), J=1,1) /
     &  -5.87112513E-03,-5.56412023E-03,-5.21985698E-03,-4.83262681E-03,
     &  -4.40866711E-03,-3.95480522E-03,-3.40531056E-03,-2.86697315E-03,
     &  -2.24107174E-03,-1.53970374E-03,-7.76559565E-04, 1.20878939E-04,
     &   1.04579005E-03, 2.16249764E-03, 3.47608171E-03, 5.04560016E-03,
     &   7.14770882E-03, 1.23302648E-02, 1.70952830E-02, 1.89093729E-02,
     &   2.02195776E-02, 2.12280309E-02, 2.20567451E-02, 2.27191892E-02,
     &   2.32596402E-02, 2.36995464E-02, 2.40551503E-02, 2.43350815E-02,
     &   2.45577209E-02, 2.46679314E-02, 2.47857803E-02, 2.48433551E-02,
     &   2.48622779E-02, 2.48478104E-02, 2.47801058E-02, 2.48078031E-02,
     &   2.45483719E-02, 2.43561330E-02, 2.43266830E-02, 2.41975186E-02,
     &   2.40193288E-02, 2.37302272E-02, 2.33529080E-02, 2.28577936E-02,
     &   2.23998124E-02, 2.18654807E-02, 2.12517646E-02, 2.05683599E-02,
     &   1.97730999E-02, 1.90249786E-02, 1.79208338E-02, 1.68615800E-02,
     &   1.66291566E-02, 1.59081420E-02, 1.51871274E-02, 1.49821371E-02,
     &   1.46713112E-02, 1.42917090E-02, 1.38673459E-02, 1.38063145E-02,
     &   1.35503803E-02, 1.33518993E-02, 1.32392286E-02, 1.31387756E-02,
     &   1.30055624E-02, 1.28858422E-02, 1.27711545E-02, 1.27108586E-02,
     &   1.23682085E-02, 1.20129674E-02, 1.16649710E-02, 1.13682243E-02,
     &   1.10074495E-02, 1.06489802E-02, 1.02746058E-02, 9.95544068E-03,
     &   9.56534421E-03, 9.16893426E-03, 8.84360218E-03, 8.65028886E-03,
     &   8.29563947E-03, 8.12919077E-03, 7.75022272E-03, 7.42268633E-03,
     &   7.02993273E-03, 6.67558754E-03, 6.23757275E-03, 5.85466253E-03,
     &   5.44650968E-03, 4.92713896E-03, 4.65562414E-03, 4.47052163E-03,
     &   4.08375151E-03, 3.87971027E-03, 3.65957745E-03, 3.42977730E-03,
     &   3.17685721E-03, 2.92059483E-03, 2.64991239E-03, 2.08978119E-03/
  
         DATA ((DAS (I,J), I= 201, 300), J=1,1) /
     &   1.49105417E-03, 1.13869237E-03, 9.96949835E-04, 8.68518360E-04,
     &   7.23778535E-04, 5.74168689E-04, 4.39320298E-04, 2.61957672E-04,
     &   7.86790130E-05,-8.49390082E-05,-2.72323484E-04,-4.69952138E-04,
     &  -6.76590887E-04,-8.85406443E-04,-1.11234818E-03,-1.34166894E-03,
     &  -1.58258146E-03,-1.83060582E-03,-2.08586394E-03,-2.34187110E-03,
     &  -2.61997317E-03,-2.90287767E-03,-3.19513530E-03,-3.50009583E-03,
     &  -3.81595760E-03,-4.14147050E-03,-4.50403808E-03,-4.88844014E-03,
     &  -5.30506718E-03,-5.79792538E-03,-6.05516291E-03,-6.42139119E-03,
     &  -6.71864163E-03,-7.08723604E-03,-8.00504418E-03,-8.28135240E-03,
     &  -8.94086744E-03,-9.69333856E-03,-1.05418253E-02,-1.13018766E-02,
     &  -1.22282530E-02,-1.32172933E-02,-1.41530611E-02,-1.55385083E-02,
     &  -1.69239554E-02,-1.83785240E-02,-2.01285658E-02,-2.20539970E-02,
     &  -2.42493968E-02,-2.67586017E-02,-2.96506607E-02,-3.30062247E-02,
     &  -3.68853453E-02,-4.06163534E-02,-4.26547556E-02,-4.40407628E-02,
     &  -4.54561426E-02,-4.68791799E-02,-4.63362379E-02,-4.97271784E-02,
     &  -5.10742181E-02,-5.22982333E-02,-5.33725100E-02,-5.42425120E-02,
     &  -5.47436520E-02,-5.48037695E-02,-5.37545226E-02,-5.19565620E-02,
     &  -5.06904165E-02,-4.72512865E-02,-4.24488732E-02,-3.61333862E-02,
     &  -2.82766200E-02,-1.89603556E-02,-8.50237771E-03, 2.69281519E-03,
     &   1.40469308E-02, 2.49846329E-02, 3.49768934E-02, 4.36478239E-02,
     &   5.08182657E-02, 5.64446411E-02, 6.06192769E-02, 6.35048558E-02,
     &   6.53090384E-02, 6.62477030E-02, 6.64911044E-02, 6.62099499E-02,
     &   6.55264493E-02, 6.45752921E-02, 6.28427204E-02, 6.10744635E-02,
     &   5.98747721E-02, 5.92570637E-02, 5.79263703E-02, 5.64983643E-02,
     &   5.50892932E-02, 5.37177726E-02, 5.23688967E-02, 5.10847264E-02/
  
         DATA ((DAS (I,J), I= 301, 400), J=1,1) /
     &   5.09388859E-02, 4.86315498E-02, 4.74749974E-02, 4.63562610E-02,
     &   4.27860216E-02, 3.97291831E-02, 3.70684042E-02, 3.47499699E-02,
     &   3.27500274E-02, 3.06079560E-02, 2.94076338E-02, 2.80206221E-02,
     &   2.67801644E-02, 2.56648033E-02, 2.46532208E-02, 2.37407318E-02,
     &   2.29441167E-02, 2.21385530E-02, 2.14567265E-02, 2.08079335E-02,
     &   2.02298087E-02, 1.96913542E-02, 1.96701176E-02, 1.87176618E-02,
     &   1.82858070E-02, 1.81048442E-02, 1.83323282E-02, 1.80209513E-02,
     &   1.75268114E-02, 1.71791006E-02, 1.68443330E-02, 1.65534368E-02,
     &   1.62560674E-02, 1.59965794E-02, 1.57485533E-02, 1.55022621E-02,
     &   1.52662454E-02, 1.50430164E-02, 1.48381259E-02, 1.46319279E-02,
     &   1.44460822E-02, 1.42546361E-02, 1.40787986E-02, 1.39045316E-02,
     &   1.37219120E-02, 1.35798802E-02, 1.34241577E-02, 1.32681437E-02,
     &   1.31062625E-02, 1.29794304E-02, 1.28523446E-02, 1.27169166E-02,
     &   1.25944363E-02, 1.24402108E-02, 1.23370756E-02, 1.22130065E-02,
     &   1.18828311E-02, 1.11713672E-02, 1.00520619E-02, 9.23557316E-03,
     &   8.58215810E-03, 8.05044345E-03, 7.57568122E-03, 7.16008558E-03,
     &   6.81130826E-03, 6.76967624E-03, 6.36151333E-03, 6.09353389E-03,
     &   6.00243791E-03, 5.77910748E-03, 5.57028554E-03, 5.54745873E-03,
     &   5.36360268E-03, 5.16766526E-03, 5.07088476E-03, 4.96734635E-03,
     &   4.80883157E-03, 4.66423083E-03, 4.53025824E-03, 4.41044584E-03,
     &   4.33819889E-03, 4.29370989E-03, 4.18066013E-03, 4.05714974E-03,
     &   4.04880268E-03, 3.93720809E-03, 3.85777390E-03, 3.81618997E-03,
     &   3.77227719E-03, 3.68497813E-03, 3.61192173E-03, 3.51679709E-03,
     &   3.50487479E-03, 3.44474437E-03, 3.39844675E-03, 3.35681724E-03,
     &   3.29441192E-03, 3.24620763E-03, 3.23859231E-03, 3.24201266E-03/
  
         DATA ((DAS (I,J), I= 401, 500), J=1,1) /
     &   3.21884567E-03, 3.16643821E-03, 3.08634897E-03, 2.99983546E-03,
     &   2.97240751E-03, 2.88082428E-03, 2.88469557E-03, 2.89180661E-03,
     &   2.90287932E-03, 2.94060459E-03, 2.99557929E-03, 3.05422967E-03,
     &   3.06099720E-03, 3.12247118E-03, 3.13010836E-03, 3.17239033E-03,
     &   3.21224389E-03, 3.38052923E-03, 3.41010753E-03, 3.61750109E-03,
     &   3.63223658E-03, 3.64710033E-03, 3.78359777E-03, 3.88628915E-03,
     &   3.90045817E-03, 3.95895675E-03, 3.96050807E-03, 3.95142723E-03,
     &   3.95037875E-03, 3.94088845E-03, 3.93602812E-03, 3.91874765E-03,
     &   3.91502466E-03, 3.90919291E-03, 3.90777424E-03, 3.90870781E-03,
     &   3.90939842E-03, 3.91357987E-03, 3.91984774E-03, 3.98574974E-03,
     &   4.06279708E-03, 4.09732427E-03, 4.12007128E-03, 4.13159427E-03,
     &   4.25278145E-03, 4.27150403E-03, 4.32530750E-03, 4.36986839E-03,
     &   4.39209102E-03, 4.47548721E-03, 4.57512371E-03, 4.59799970E-03,
     &   4.61215174E-03, 4.67922000E-03, 4.71709834E-03, 4.75559672E-03,
     &   4.91613903E-03, 4.93462757E-03, 4.97599947E-03, 4.98902581E-03,
     &   4.98176434E-03, 4.97854729E-03, 4.96900827E-03, 4.96254641E-03,
     &   4.95575642E-03, 4.93981176E-03, 4.92390264E-03, 4.94139863E-03,
     &   4.99748513E-03, 5.05479128E-03, 5.06111098E-03, 5.08491658E-03,
     &   5.07077688E-03, 5.07816305E-03, 5.08217438E-03, 5.10144339E-03,
     &   5.10158760E-03, 5.10565053E-03, 5.11720809E-03, 5.04792259E-03,
     &   5.02216847E-03, 4.75644831E-03, 4.61581531E-03, 4.52841791E-03,
     &   4.30810489E-03, 4.16955951E-03, 4.15320623E-03, 4.14077969E-03,
     &   4.11469634E-03, 4.10833273E-03, 4.08153345E-03, 4.07377493E-03,
     &   4.03750006E-03, 3.98792367E-03, 3.93636783E-03, 3.91449687E-03,
     &   3.60238945E-03, 3.37609058E-03, 3.43976561E-03, 3.66153917E-03/
  
         DATA ((DAS (I,J), I= 501, 600), J=1,1) /
     &   4.24411759E-03, 4.53676709E-03, 4.82604392E-03, 4.95783240E-03,
     &   4.99367839E-03, 4.91270284E-03, 4.80023937E-03, 4.62299363E-03,
     &   4.41271843E-03, 4.20106862E-03, 3.95192740E-03, 3.63749341E-03,
     &   3.23022778E-03, 2.68299378E-03, 1.91261974E-03, 7.55749874E-04,
     &   4.51914731E-04, 1.14569793E-04,-2.62424701E-04,-6.87107014E-04,
     &  -1.16855004E-03,-1.71885604E-03,-2.35204082E-03,-2.49103160E-03,
     &  -2.63439893E-03,-2.78269296E-03,-2.93707117E-03,-3.09377261E-03,
     &  -3.25737476E-03,-3.42677632E-03,-3.60197274E-03,-3.78363810E-03,
     &  -3.97201960E-03,-4.91573937E-03,-5.64511526E-03,-6.04609829E-03,
     &  -6.32876563E-03,-6.62468167E-03,-6.93476250E-03,-7.26008928E-03,
     &  -7.60179053E-03,-7.96111403E-03,-8.14781282E-03,-8.33945462E-03,
     &  -8.53624112E-03,-8.73833489E-03,-8.94622523E-03,-9.15976394E-03,
     &  -9.37924123E-03,-9.60516139E-03,-9.83768612E-03,-1.00771365E-02,
     &  -1.03238058E-02,-1.05780201E-02,-1.08401329E-02,-1.11105209E-02,
     &  -1.13896257E-02,-1.16777559E-02,-1.19757842E-02,-1.22834816E-02,
     &  -1.26018795E-02,-1.29313961E-02,-1.32726280E-02,-1.36262141E-02,
     &  -1.39928409E-02,-1.43732474E-02,-1.47682290E-02,-1.51787727E-02,
     &  -1.56054150E-02,-1.60495466E-02,-1.65121433E-02,-1.69944064E-02,
     &  -1.74976121E-02,-1.80231232E-02,-1.85724575E-02,-1.91472830E-02,
     &  -1.97495184E-02,-2.03808872E-02,-2.10438696E-02,-2.17407965E-02,
     &  -2.24743777E-02,-2.32475938E-02,-2.36500761E-02,-2.40637304E-02,
     &  -2.44890341E-02,-2.49265137E-02,-2.53766679E-02,-2.58400533E-02,
     &  -2.63172989E-02,-2.68088051E-02,-2.73157410E-02,-2.78383980E-02,
     &  -2.83774820E-02,-2.89342475E-02,-2.95091562E-02,-3.01032139E-02,
     &  -3.07174229E-02,-3.13528275E-02,-3.20105463E-02,-3.26917782E-02/
  
         DATA ((DAS (I,J), I= 601, 700), J=1,1) /
     &  -3.33978009E-02,-3.41299990E-02,-3.48897183E-02,-3.56789231E-02,
     &  -3.64991511E-02,-3.73522223E-02,-3.82401704E-02,-3.91652096E-02,
     &  -4.01296914E-02,-4.11362182E-02,-4.21875390E-02,-4.32869013E-02,
     &  -4.44374127E-02,-4.56428620E-02,-4.69073021E-02,-4.82350114E-02,
     &  -4.96311694E-02,-5.11010980E-02,-5.26507741E-02,-5.42868434E-02,
     &  -5.67369775E-02,-5.78489493E-02,-5.97926061E-02,-6.18582885E-02,
     &  -6.40578447E-02,-6.64047404E-02,-6.89143266E-02,-7.16041618E-02,
     &  -7.44943794E-02,-7.76082135E-02,-8.09726989E-02,-8.46193773E-02,
     &  -8.85853272E-02,-9.17511686E-02,-1.01613011E-01,-1.13689019E-01,
     &  -1.28819466E-01,-1.48331346E-01,-1.74450410E-01,-2.11217324E-01,
     &  -2.66810117E-01,-3.60661943E-01,-5.52958645E-01,-1.16861958E+00,
     &  -1.23605179E+00,-1.31167209E+00,-1.39706207E+00,-1.49423716E+00,
     &  -1.60580488E+00,-1.73519821E+00,-1.88702773E+00,-2.06762879E+00,
     &  -2.28594113E+00,-2.55497846E+00,-2.89439651E+00,-3.33521365E+00,
     &  -3.92901104E+00,-3.99980695E+00,-5.58502204E+00,-6.74043707E+00,
     &  -7.66874630E+00,-8.47609077E+00,-9.09821413E+00,-9.64179250E+00,
     &  -1.00774327E+01,-1.05114268E+01,-1.08095550E+01,-1.10855971E+01,
     &  -1.12803823E+01,-1.14409608E+01,-1.15311981E+01,-1.15985541E+01,
     &  -1.16042817E+01,-1.15703828E+01,-1.14763758E+01,-1.13747764E+01,
     &  -1.11550156E+01,-1.09581116E+01,-1.07164141E+01,-1.04261207E+01,
     &  -1.00835848E+01,-9.68545227E+00,-9.22882330E+00,-8.71143160E+00,
     &  -8.13183860E+00,-7.48962793E+00,-6.78559174E+00,-5.61874410E+00,
     &  -4.77285969E+00,-3.41692012E+00,-1.98023254E+00, 1.98952164E+00,
     &   5.62820354E+00, 6.79514759E+00, 7.82820475E+00, 8.43920177E+00,
     &   9.23867942E+00, 9.69538722E+00, 1.00935980E+01, 1.04362109E+01/
  
         DATA ((DAS (I,J), I= 701, 800), J=1,1) /
     &   1.07265798E+01, 1.09683507E+01, 1.11653253E+01, 1.13213459E+01,
     &   1.14402038E+01, 1.15255705E+01, 1.15809471E+01, 1.16149290E+01,
     &   1.16092529E+01, 1.15650306E+01, 1.14851328E+01, 1.14155655E+01,
     &   1.12453994E+01, 1.10966014E+01, 1.08780183E+01, 1.06436555E+01,
     &   1.03378869E+01, 1.00261727E+01, 9.59150229E+00, 9.16860282E+00,
     &   8.65192168E+00, 8.06918896E+00, 7.31965544E+00, 6.46041760E+00,
     &   5.38752687E+00, 4.44040820E+00, 3.70470955E+00, 3.17385334E+00,
     &   2.77414274E+00, 2.46291033E+00, 2.21398253E+00, 2.01049474E+00,
     &   1.84112346E+00, 1.69799772E+00, 1.57548315E+00, 1.46944411E+00,
     &   1.37677799E+00, 1.29511254E+00, 1.22260396E+00, 1.15779762E+00,
     &   1.09953080E+00, 1.04686315E+00, 9.99026023E-01, 5.26385299E-01,
     &   3.58467994E-01, 2.72447997E-01, 2.20160140E-01, 1.85015761E-01,
     &   1.59771055E-01, 1.40759369E-01, 1.25925711E-01, 1.14029000E-01,
     &   1.04275422E-01, 1.03120171E-01, 9.50642539E-02, 8.82391632E-02,
     &   8.23827590E-02, 7.73024199E-02, 7.28534229E-02, 6.89248859E-02,
     &   6.54305188E-02, 6.23021470E-02, 5.94847693E-02, 5.69344644E-02,
     &   5.46149433E-02, 5.24961173E-02, 5.05529959E-02, 4.87645580E-02,
     &   4.71130615E-02, 4.55832868E-02, 4.41623629E-02, 4.28389268E-02,
     &   4.16032861E-02, 4.04469397E-02, 3.93625716E-02, 3.83436312E-02,
     &   3.73843203E-02, 3.64795407E-02, 3.56247681E-02, 3.48159818E-02,
     &   3.40495541E-02, 3.33222745E-02, 3.26311875E-02, 3.19736260E-02,
     &   3.13471999E-02, 3.07497424E-02, 3.01792835E-02, 2.96340568E-02,
     &   2.91124014E-02, 2.86128885E-02, 2.81340708E-02, 2.76746805E-02,
     &   2.72335557E-02, 2.68096419E-02, 2.64019652E-02, 2.60096320E-02,
     &   2.56317204E-02, 2.52675135E-02, 2.49162762E-02, 2.45772981E-02/
  
         DATA ((DAS (I,J), I= 801, 900), J=1,1) /
     &   2.42499312E-02, 2.39336317E-02, 2.36278284E-02, 2.33320101E-02,
     &   2.30456921E-02, 2.27684521E-02, 2.24998968E-02, 2.22396015E-02,
     &   2.19871832E-02, 2.17423013E-02, 2.15046708E-02, 2.12739144E-02,
     &   2.10497799E-02, 2.08319994E-02, 2.06203276E-02, 2.04145506E-02,
     &   2.02144586E-02, 2.00198005E-02, 1.98303816E-02, 1.96460202E-02,
     &   1.94665480E-02, 1.92918083E-02, 1.91216575E-02, 1.89559754E-02,
     &   1.87946626E-02, 1.86376286E-02, 1.84847603E-02, 1.83359778E-02,
     &   1.81912337E-02, 1.80505059E-02, 1.79138034E-02, 1.77811746E-02,
     &   1.76527199E-02, 1.75286280E-02, 1.74091691E-02, 1.72947678E-02,
     &   1.70066013E-02, 1.68833496E-02, 1.67626166E-02, 1.66443283E-02,
     &   1.65284161E-02, 1.64148252E-02, 1.63036696E-02, 1.61944498E-02,
     &   1.60877431E-02, 1.59948553E-02, 1.58790868E-02, 1.57772789E-02,
     &   1.56775914E-02, 1.55794810E-02, 1.54833443E-02, 1.53889441E-02,
     &   1.52962411E-02, 1.52051802E-02, 1.51157002E-02, 1.50277571E-02,
     &   1.23948566E-02, 1.05398028E-02, 8.97939699E-03, 7.75612682E-03,
     &   6.82088527E-03, 6.35710260E-03, 5.80382517E-03, 5.12470926E-03,
     &   4.51170233E-03, 3.77374645E-03, 3.46908593E-03, 2.73762392E-03,
     &   2.30116185E-03, 1.80306061E-03, 1.24667326E-03, 6.13319949E-04,
     &  -1.19743819E-04,-9.83028006E-04,-2.01962113E-03,-3.29314588E-03,
     &  -4.90213008E-03,-5.67271494E-03,-6.53623615E-03,-7.51118594E-03,
     &  -8.62132993E-03,-9.89772913E-03,-1.13816908E-02,-1.22183568E-02,
     &  -1.31295560E-02,-1.41258782E-02,-1.52200200E-02,-1.64273368E-02,
     &  -1.77665540E-02,-1.92608483E-02,-2.09390801E-02,-2.28378081E-02,
     &  -2.50038800E-02,-2.74985362E-02,-3.04032271E-02,-3.36799745E-02,
     &  -3.58238489E-02,-3.82017529E-02,-4.08543711E-02,-4.38323974E-02/
  
         DATA ((DAS (I,J), I= 901,1000), J=1,1) /
     &  -4.71998146E-02,-5.10385524E-02,-5.54552514E-02,-6.05913348E-02,
     &  -6.66384390E-02,-7.38628509E-02,-8.26457512E-02,-9.35525802E-02,
     &  -1.07459505E-01,-1.25800326E-01,-1.51092605E-01,-1.88194742E-01,
     &  -2.47822934E-01,-3.58983488E-01,-5.33808031E-01,-6.33309004E-01,
     &  -7.41838543E-01,-1.00886989E+00,-1.10507451E+00,-1.18447422E+00,
     &  -1.25190294E+00,-1.30868174E+00,-1.35526584E+00,-1.39537720E+00,
     &  -1.42822067E+00,-1.45172678E+00,-1.47169627E+00,-1.48583289E+00,
     &  -1.49421771E+00,-1.49724616E+00,-1.49509587E+00,-1.48921989E+00,
     &  -1.47729460E+00,-1.46168970E+00,-1.44065511E+00,-1.41359142E+00,
     &  -1.38513373E+00,-1.34526254E+00,-1.30495189E+00,-1.25862056E+00,
     &  -1.20597118E+00,-1.13624189E+00,-1.06916716E+00,-9.82293793E-01,
     &  -9.00497422E-01,-7.81242235E-01,-6.51093656E-01,-4.56708150E-01,
     &  -2.87267870E-01,-9.20959559E-02, 6.76311161E-03, 1.05623368E-01,
     &   2.03845752E-01, 4.70261368E-01, 6.64675470E-01, 7.94849831E-01,
     &   9.14134085E-01, 9.95953884E-01, 1.08285590E+00, 1.14995591E+00,
     &   1.21971507E+00, 1.27239015E+00, 1.31874701E+00, 1.35908280E+00,
     &   1.39898271E+00, 1.42746428E+00, 1.45455491E+00, 1.47561531E+00,
     &   1.49124484E+00, 1.50319672E+00, 1.50909470E+00, 1.51127147E+00,
     &   1.50826755E+00, 1.49990784E+00, 1.48579630E+00, 1.46585153E+00,
     &   1.44236754E+00, 1.40954860E+00, 1.36946125E+00, 1.32290007E+00,
     &   1.26614445E+00, 1.19873856E+00, 1.11936117E+00, 1.02317874E+00,
     &   9.06575001E-01, 9.69880256E-01, 7.56190776E-01, 5.48181352E-01,
     &   4.67319837E-01, 3.05043013E-01, 2.26888469E-01, 1.81100169E-01,
     &   1.51059453E-01, 1.29844689E-01, 1.14067582E-01, 1.01876099E-01,
     &   9.21727900E-02, 8.42663719E-02, 7.76998067E-02, 7.21588624E-02/
  
         DATA ((DAS (I,J), I=1001,1100), J=1,1) /
     &   6.74204462E-02, 6.33217653E-02, 5.97412682E-02, 5.65863711E-02,
     &   5.37852836E-02, 5.12815850E-02, 4.90300757E-02, 4.54686766E-02,
     &   4.10182512E-02, 3.86332500E-02, 3.47220928E-02, 3.16458820E-02,
     &   2.85962120E-02, 2.42452243E-02, 1.94560096E-02, 1.64409475E-02,
     &   1.50869463E-02, 1.42757362E-02, 1.37187336E-02, 1.33063582E-02,
     &   1.29835192E-02, 1.27220946E-02, 1.25048391E-02, 1.23208671E-02,
     &   1.21626016E-02, 1.20253620E-02, 1.19051042E-02, 1.17991130E-02,
     &   1.17054508E-02, 1.16222055E-02, 1.15483684E-02, 1.14829940E-02,
     &   1.14248602E-02, 1.13739746E-02, 1.13290845E-02, 1.12906958E-02,
     &   1.12576045E-02, 1.12303871E-02, 1.12091348E-02, 1.11925964E-02,
     &   1.11827081E-02, 1.11786949E-02, 1.11817409E-02, 1.11927241E-02,
     &   1.12133018E-02, 1.12464572E-02, 1.12982223E-02, 1.13838036E-02,
     &   1.16667433E-02, 1.20458951E-02, 1.22270629E-02, 1.23742352E-02,
     &   1.25027687E-02, 1.26187901E-02, 1.27247723E-02, 1.28225566E-02,
     &   1.29131681E-02, 1.29972433E-02, 1.30753471E-02, 1.31464155E-02,
     &   1.32120570E-02, 1.32717934E-02, 1.33265560E-02, 1.33897735E-02,
     &   1.34058102E-02, 1.34295300E-02, 1.34471772E-02, 1.34568627E-02,
     &   1.34575201E-02, 1.34481730E-02, 1.34273057E-02, 1.33950866E-02,
     &   1.33488858E-02, 1.32873848E-02, 1.32088022E-02, 1.31109007E-02,
     &   1.29907017E-02, 1.28438178E-02, 1.26648083E-02, 1.24490165E-02,
     &   1.21816938E-02, 1.17926540E-02, 1.12139659E-02, 1.10426129E-02,
     &   1.05731469E-02, 9.84732091E-03, 9.76986448E-03, 9.25038395E-03,
     &   9.04592125E-03, 8.84555143E-03, 8.68365242E-03, 8.49634824E-03,
     &   8.21323655E-03, 8.09535193E-03, 8.10501619E-03, 7.90408231E-03,
     &   7.90629999E-03, 8.14273496E-03, 8.02386698E-03, 8.16047333E-03/
  
         DATA ((DAS (I,J), I=1101,1200), J=1,1) /
     &   8.00953133E-03, 7.77846627E-03, 8.00540754E-03, 7.70866383E-03,
     &   7.12569651E-03, 6.96075821E-03, 7.15194946E-03, 7.16243237E-03,
     &   7.12127005E-03, 6.98542994E-03, 6.58658925E-03, 6.39913929E-03,
     &   5.96198271E-03, 5.60365532E-03, 5.44133624E-03, 5.70447971E-03,
     &   6.15135463E-03, 7.08982195E-03, 7.42487951E-03, 7.83967441E-03,
     &   8.10107537E-03, 8.39001462E-03, 8.46888680E-03, 8.45636781E-03,
     &   8.85823275E-03, 9.22792664E-03, 9.13945059E-03, 9.09637632E-03,
     &   9.15402401E-03, 9.19951871E-03, 9.23636235E-03, 9.21924652E-03,
     &   9.24029117E-03, 9.23176031E-03, 9.11648886E-03, 9.06470724E-03,
     &   9.08761374E-03, 9.16252805E-03, 9.25879401E-03, 9.50607214E-03,
     &   9.62036701E-03, 9.62699459E-03, 9.62190772E-03, 9.52992090E-03,
     &   9.28565975E-03, 9.27056502E-03, 9.49669433E-03, 9.75985189E-03,
     &   9.99454420E-03, 1.00079583E-02, 1.01035353E-02, 1.02497935E-02,
     &   1.03995250E-02, 1.06660838E-02, 1.09449606E-02, 1.10615914E-02,
     &   1.11773540E-02, 1.13670266E-02, 1.14902323E-02, 1.13844469E-02,
     &   1.11613497E-02, 1.10864032E-02, 1.12151271E-02, 1.11666854E-02,
     &   1.07823321E-02, 1.06533900E-02, 1.07328265E-02, 1.07317959E-02,
     &   1.02724329E-02, 9.81114538E-03, 9.66243629E-03, 9.59208719E-03,
     &   9.53422429E-03, 9.48180738E-03, 9.21021007E-03, 9.07773142E-03,
     &   9.12226187E-03, 9.10551734E-03, 8.91076130E-03, 8.52888492E-03,
     &   8.47799154E-03, 8.37326228E-03, 8.44223020E-03, 8.47106652E-03,
     &   8.52874822E-03, 8.58291917E-03, 8.60142334E-03, 8.61611510E-03,
     &   8.54688972E-03, 8.44170621E-03, 8.36110289E-03, 8.72355252E-03,
     &   9.01723509E-03, 9.00430561E-03, 9.03484352E-03, 9.04367038E-03,
     &   9.01780782E-03, 9.32125581E-03, 9.74851517E-03, 9.86489209E-03/
  
         DATA ((DAS (I,J), I=1201,1300), J=1,1) /
     &   9.85460246E-03, 9.90050401E-03, 9.93477750E-03, 9.99346247E-03,
     &   1.00541111E-02, 1.00195765E-02, 9.97264816E-03, 9.94774899E-03,
     &   9.69233899E-03, 9.63730808E-03, 9.72910377E-03, 9.75573967E-03,
     &   9.63861842E-03, 9.56416342E-03, 9.55469758E-03, 9.55626066E-03,
     &   9.56701060E-03, 9.78871810E-03, 1.00250159E-02, 1.00570880E-02,
     &   1.00287918E-02, 1.00059199E-02, 1.00380250E-02, 1.00487266E-02,
     &   1.02203043E-02, 1.04534747E-02, 1.05458552E-02, 1.06293638E-02,
     &   1.07785604E-02, 1.09117012E-02, 1.09739273E-02, 1.10337966E-02,
     &   1.10916127E-02, 1.11476095E-02, 1.12019753E-02, 1.12545578E-02,
     &   1.13060819E-02, 1.13563635E-02, 1.14054930E-02, 1.14535476E-02,
     &   1.15005935E-02, 1.15466887E-02, 1.15918821E-02, 1.16362185E-02,
     &   1.16797358E-02, 1.17224679E-02, 1.17644445E-02, 1.18056919E-02,
     &   1.18462333E-02, 1.18860892E-02, 1.19252775E-02, 1.19638138E-02,
     &   1.20017120E-02, 1.20389837E-02, 1.20756391E-02, 1.21116864E-02,
     &   1.21471325E-02, 1.21819825E-02, 1.22162403E-02, 1.22499080E-02,
     &   1.22829865E-02, 1.23154751E-02, 1.23473715E-02, 1.23786719E-02,
     &   1.24032796E-02, 1.24394615E-02, 1.24977788E-02, 1.25535263E-02,
     &   1.26065682E-02, 1.26567210E-02, 1.27037411E-02, 1.27473047E-02,
     &   1.27869812E-02, 1.28221910E-02, 1.28521404E-02, 1.28757171E-02,
     &   1.28912124E-02, 1.28964810E-02, 1.28875732E-02, 1.28580793E-02,
     &   1.28536161E-02, 1.27961957E-02, 1.26773154E-02, 1.24395320E-02,
     &   1.20346612E-02, 1.18668197E-02, 1.11721021E-02, 9.88793402E-03,
     &   9.29679824E-03, 8.46793052E-03, 7.91488916E-03, 7.22337033E-03,
     &   6.53184088E-03, 5.66770045E-03, 5.14947072E-03, 4.55751871E-03,
     &   3.87498376E-03, 3.07944894E-03, 2.14044854E-03, 1.01550192E-03/
  
         DATA ((DAS (I,J), I=1301,1400), J=1,1) /
     &   3.65205907E-04,-3.56453443E-04,-1.16186620E-03,-2.06646400E-03,
     &  -3.08971409E-03,-4.25653050E-03,-5.59932176E-03,-7.16103761E-03,
     &  -8.99983324E-03,-9.76564819E-03,-1.02461314E-02,-1.07468062E-02,
     &  -1.12689707E-02,-1.18140366E-02,-1.23835421E-02,-1.29791661E-02,
     &  -1.36027449E-02,-1.42562910E-02,-1.49420149E-02,-1.56623498E-02,
     &  -1.64199805E-02,-1.72178768E-02,-1.80593325E-02,-1.89480104E-02,
     &  -1.98879959E-02,-2.08838595E-02,-2.19407311E-02,-2.30643882E-02,
     &  -2.42613615E-02,-2.55390617E-02,-2.69059331E-02,-2.83716398E-02,
     &  -2.99472949E-02,-3.16457420E-02,-3.34819061E-02,-3.54732327E-02,
     &  -3.76402435E-02,-4.00072458E-02,-4.26032472E-02,-4.54631496E-02,
     &  -4.86293264E-02,-5.21537348E-02,-5.61007875E-02,-6.05513222E-02,
     &  -6.56081943E-02,-7.14043190E-02,-7.81145173E-02,-8.59734431E-02,
     &  -9.53035709E-02,-1.06560514E-01,-1.20409629E-01,-1.37862370E-01,
     &  -1.60534881E-01,-1.91179032E-01,-2.34891870E-01,-3.02286629E-01,
     &  -4.19701139E-01,-6.75202196E-01,-8.33616148E-01,-1.60018747E+00,
     &  -2.23191491E+00,-2.68982086E+00,-3.04412852E+00,-3.33523557E+00,
     &  -3.58998621E+00,-3.82635929E+00,-3.99091313E+00,-4.15841625E+00,
     &  -4.32315407E+00,-4.40258191E+00,-4.51389846E+00,-4.58059804E+00,
     &  -4.66338985E+00,-4.68496581E+00,-4.71687944E+00,-4.73014208E+00,
     &  -4.72014644E+00,-4.70489464E+00,-4.68186868E+00,-4.60894971E+00,
     &  -4.55781469E+00,-4.49496729E+00,-4.33304022E+00,-4.23251077E+00,
     &  -4.11761691E+00,-3.98616150E+00,-3.67792450E+00,-3.49690088E+00,
     &  -3.30065500E+00,-2.85457172E+00,-2.60764288E+00,-2.06423868E+00,
     &  -1.46600161E+00, 1.71686582E-01, 1.47377383E+00, 2.07354592E+00,
     &   2.61614392E+00, 3.09827869E+00, 3.31503233E+00, 3.51236220E+00/
  
         DATA ((DAS (I,J), I=1401,1500), J=1,1) /
     &   3.69266318E+00, 4.00478263E+00, 4.13593258E+00, 4.25306297E+00,
     &   4.35448122E+00, 4.51803608E+00, 4.58101645E+00, 4.63342782E+00,
     &   4.70725080E+00, 4.73108875E+00, 4.75543728E+00, 4.75762919E+00,
     &   4.74502978E+00, 4.71385077E+00, 4.66769663E+00, 4.61000899E+00,
     &   4.54355006E+00, 4.43247670E+00, 4.35357278E+00, 4.18850730E+00,
     &   4.02143893E+00, 3.85638626E+00, 3.61986025E+00, 3.36489519E+00,
     &   3.07351193E+00, 2.71885503E+00, 2.26051516E+00, 1.61896323E+00,
     &   8.89842309E-01, 5.14839542E-01, 3.64331657E-01, 2.83298731E-01,
     &   2.32678147E-01, 1.98059859E-01, 1.72893593E-01, 1.53774145E-01,
     &   1.38756411E-01, 1.26648622E-01, 1.16679898E-01, 1.08329529E-01,
     &   1.01233118E-01, 9.51280233E-02, 8.98201594E-02, 8.51630019E-02,
     &   8.10438596E-02, 7.73746288E-02, 7.40854823E-02, 7.11203017E-02,
     &   6.84335075E-02, 6.59876878E-02, 6.37518476E-02, 6.17000893E-02,
     &   5.98106067E-02, 5.80649073E-02, 5.64472063E-02, 5.49439481E-02,
     &   5.35434268E-02, 5.22354806E-02, 5.10112456E-02, 4.98629552E-02,
     &   4.87837749E-02, 4.77676671E-02, 4.68092778E-02, 4.59038430E-02,
     &   4.50471092E-02, 4.42352670E-02, 4.34648946E-02, 4.27329098E-02,
     &   4.20365289E-02, 4.13732313E-02, 4.07407293E-02, 4.01369418E-02,
     &   3.95599712E-02, 3.90080843E-02, 3.84796942E-02, 3.79733454E-02,
     &   3.74877008E-02, 3.70215296E-02, 3.35106154E-02, 3.13655039E-02,
     &   2.93183622E-02, 2.70560198E-02, 2.49975483E-02, 2.31861896E-02,
     &   2.27418143E-02, 2.10853784E-02, 1.85971560E-02, 1.70067869E-02,
     &   1.69323880E-02, 1.67735186E-02, 1.65976095E-02, 1.62629354E-02,
     &   1.59752400E-02, 1.50591107E-02, 1.42497296E-02, 1.37738530E-02,
     &   1.31389081E-02, 1.23886275E-02, 1.15248306E-02, 1.04153674E-02/
  
         DATA ((DAS (I,J), I=1501,1600), J=1,1) /
     &   8.89594610E-03, 5.10115733E-03, 4.38216575E-03, 3.53563724E-03,
     &   3.29035857E-03, 2.73132633E-03, 2.11024430E-03, 1.41616436E-03,
     &   6.35401293E-04,-2.49379536E-04,-1.26046550E-03,-2.42700158E-03,
     &  -3.78784756E-03,-5.39599374E-03,-7.32562585E-03,-9.68389972E-03,
     &  -1.26315463E-02,-1.64211365E-02,-2.14736068E-02,-2.85466005E-02,
     &  -3.91552623E-02,-5.68343085E-02,-9.21835567E-02,-1.39601058E-01,
     &  -1.47559977E-01,-1.56388951E-01,-1.66238809E-01,-1.77297352E-01,
     &  -1.89801418E-01,-2.04053982E-01,-2.20448956E-01,-2.39508029E-01,
     &  -2.61936956E-01,-2.88714452E-01,-3.21237945E-01,-3.61573628E-01,
     &  -4.12909262E-01,-4.80430371E-01,-5.73163018E-01,-7.08289794E-01,
     &  -9.22824839E-01,-1.31215454E+00,-2.19292542E+00,-2.50168253E+00,
     &  -2.74469781E+00,-3.01555953E+00,-3.24287754E+00,-3.40681466E+00,
     &  -3.54585256E+00,-3.60991577E+00,-3.63535076E+00,-3.60335975E+00,
     &  -3.49000132E+00,-3.35948620E+00,-3.33478944E+00,-3.32195011E+00,
     &  -3.29527176E+00,-3.28422220E+00,-3.27579153E+00,-3.26723705E+00,
     &  -3.17472201E+00,-3.01107964E+00,-2.79211240E+00,-2.56011269E+00,
     &  -2.26294463E+00,-1.92528304E+00,-1.58914266E+00,-1.39050956E+00,
     &  -1.18437199E+00,-9.71661876E-01,-6.64839111E-01,-4.40814746E-01,
     &  -2.14151361E-01,-7.74287506E-02,-3.17974826E-02, 1.38444990E-02,
     &   5.94864840E-02, 2.41840461E-01, 4.68504152E-01, 6.92529021E-01,
     &   1.69400451E+00, 2.05839736E+00, 2.64227554E+00, 2.86684111E+00,
     &   3.07782477E+00, 3.25029710E+00, 3.37501909E+00, 3.48286290E+00,
     &   3.55518052E+00, 3.61141887E+00, 3.64316094E+00, 3.66050879E+00,
     &   3.66241482E+00, 3.65180438E+00, 3.63272238E+00, 3.56964916E+00,
     &   3.52713840E+00, 3.48000641E+00, 3.43456372E+00, 3.33226498E+00/
  
         DATA ((DAS (I,J), I=1601,1700), J=1,1) /
     &   3.27627776E+00, 3.18534707E+00, 1.70684792E+00, 1.12539120E+00,
     &   8.36736602E-01, 6.66068394E-01, 5.53699114E-01, 4.74224955E-01,
     &   4.15085827E-01, 3.69379366E-01, 3.33003834E-01, 3.03370703E-01,
     &   2.78766662E-01, 2.58012945E-01, 2.40272141E-01, 2.24933069E-01,
     &   2.11539270E-01, 1.99742992E-01, 1.89274664E-01, 1.79922107E-01,
     &   1.71516037E-01, 1.19954024E-01, 8.46047568E-02, 6.69256769E-02,
     &   5.63169698E-02, 4.92439198E-02, 4.41913823E-02, 4.04017142E-02,
     &   3.74539791E-02, 3.50956059E-02, 3.31658636E-02, 3.15575963E-02,
     &   3.01966182E-02, 2.90299389E-02, 2.80186986E-02, 2.71337520E-02,
     &   2.63528117E-02, 2.56585427E-02, 2.50372597E-02, 2.44780142E-02,
     &   2.38081183E-02, 2.30262640E-02, 2.23579705E-02, 2.17801226E-02,
     &   2.12754792E-02, 2.08309189E-02, 1.92191118E-02, 1.82065775E-02,
     &   1.75099102E-02, 1.69998544E-02, 1.66085666E-02, 1.62940896E-02,
     &   1.60434990E-02, 1.58350033E-02, 1.40562715E-02, 1.35625454E-02,
     &   1.34383007E-02, 1.32945569E-02, 1.31235624E-02, 1.29114333E-02,
     &   1.27835747E-02, 1.26363988E-02, 1.22580872E-02, 1.16890084E-02,
     &   1.07001585E-02, 8.45804962E-03, 6.31947170E-03, 5.76783538E-03,
     &   5.13170171E-03, 4.38996495E-03, 3.51381328E-03, 2.46290586E-03,
     &   1.17902353E-03,-4.25217101E-04,-2.48714332E-03,-5.23552536E-03,
     &  -9.08226498E-03,-1.48511950E-02,-2.44641555E-02,-2.61358968E-02,
     &  -2.79593742E-02,-2.99566883E-02,-3.21536937E-02,-3.45816392E-02,
     &  -3.72795834E-02,-4.02948712E-02,-4.36866035E-02,-4.75308683E-02,
     &  -5.19241955E-02,-5.69926685E-02,-6.29062664E-02,-6.98947503E-02,
     &  -7.82794549E-02,-8.85276765E-02,-9.17299422E-02,-1.01336661E-01,
     &  -1.17800955E-01,-1.39750660E-01,-1.70469522E-01,-2.16519427E-01/
  
         DATA ((DAS (I,J), I=1701,1800), J=1,1) /
     &  -2.93161779E-01,-4.45954133E-01,-8.97557321E-01,-1.06971601E+00,
     &  -1.51454196E+00,-1.85282307E+00,-2.13155282E+00,-2.37483100E+00,
     &  -2.59066809E+00,-2.78429485E+00,-2.95725142E+00,-3.11756442E+00,
     &  -3.26896076E+00,-3.40732025E+00,-3.52902363E+00,-3.64160066E+00,
     &  -3.74310201E+00,-3.83200497E+00,-3.91646970E+00,-3.98565663E+00,
     &  -4.03968475E+00,-4.08555613E+00,-4.12086333E+00,-4.14273498E+00,
     &  -4.14823758E+00,-4.13894034E+00,-4.11209131E+00,-4.06464996E+00,
     &  -3.99332389E+00,-3.91313663E+00,-3.78894251E+00,-3.63095194E+00,
     &  -3.43595273E+00,-3.15814911E+00,-2.82360787E+00,-2.37133538E+00,
     &  -1.77868057E+00, 1.39434730E-02, 1.80657106E+00, 2.39922883E+00,
     &   2.85150438E+00, 3.18604850E+00, 3.46385507E+00, 3.65885680E+00,
     &   3.81684984E+00, 3.94104633E+00, 4.02123548E+00, 4.09256371E+00,
     &   4.14000709E+00, 4.16685802E+00, 4.17615702E+00, 4.17065606E+00,
     &   4.14878618E+00, 4.11348057E+00, 4.06761065E+00, 4.01358385E+00,
     &   3.94439828E+00, 3.85993492E+00, 3.77103318E+00, 3.66953301E+00,
     &   3.55695713E+00, 3.43525482E+00, 3.29689641E+00, 3.14550109E+00,
     &   2.98518905E+00, 2.81223339E+00, 2.61860752E+00, 2.40277129E+00,
     &   2.15949393E+00, 1.88076498E+00, 1.54248463E+00, 1.09765942E+00,
     &   9.25403920E-01, 4.73873195E-01, 3.21105843E-01, 2.44457239E-01,
     &   1.98409601E-01, 1.67694765E-01, 1.45745065E-01, 1.29279202E-01,
     &   1.16471791E-01, 1.06223571E-01, 9.78380366E-02, 9.08503855E-02,
     &   8.49367888E-02, 7.98678034E-02, 7.54749907E-02, 7.16307270E-02,
     &   5.24082883E-02, 4.27953396E-02, 3.70264244E-02, 3.31797029E-02,
     &   3.04313423E-02, 2.83694406E-02, 2.67652277E-02, 2.54813764E-02,
     &   2.44305034E-02, 2.35543896E-02, 2.28126940E-02, 2.21766049E-02/
  
         DATA ((DAS (I,J), I=1801,1900), J=1,1) /
     &   2.16250167E-02, 1.96384723E-02, 1.81790433E-02, 1.73014386E-02,
     &   1.67127231E-02, 1.62882974E-02, 1.59661318E-02, 1.57118485E-02,
     &   1.55048683E-02, 1.53320999E-02, 1.51847820E-02, 1.50568358E-02,
     &   1.49439192E-02, 1.48428219E-02, 1.47511078E-02, 1.46668822E-02,
     &   1.45886354E-02, 1.45151330E-02, 1.44453307E-02, 1.43782670E-02,
     &   1.43131412E-02, 1.42497320E-02, 1.42120310E-02, 1.33209069E-02,
     &   1.29083143E-02, 1.26096011E-02, 1.23727743E-02, 1.21776900E-02,
     &   1.20138363E-02, 1.18746638E-02, 1.17564618E-02, 1.16571241E-02,
     &   1.15737262E-02, 1.15048143E-02, 1.14498520E-02, 1.14079382E-02,
     &   1.13781172E-02, 1.13597215E-02, 1.13527814E-02, 1.13568429E-02,
     &   1.13716859E-02, 1.13977721E-02, 1.14345409E-02, 1.14812631E-02,
     &   1.15410315E-02, 1.16100472E-02, 1.16926733E-02, 1.17875440E-02,
     &   1.18971417E-02, 1.20221217E-02, 1.21629497E-02, 1.23198513E-02,
     &   1.25051280E-02, 1.27171918E-02, 1.29620930E-02, 1.32673557E-02,
     &   1.36708395E-02, 1.46569707E-02, 1.55891577E-02, 1.59408740E-02,
     &   1.61957298E-02, 1.63930189E-02, 1.65584424E-02, 1.66985549E-02,
     &   1.68136647E-02, 1.69138496E-02, 1.69998616E-02, 1.70725646E-02,
     &   1.71328937E-02, 1.71828080E-02, 1.72218447E-02, 1.72526569E-02,
     &   1.72734750E-02, 1.72859217E-02, 1.72896274E-02, 1.72846307E-02,
     &   1.72711395E-02, 1.72485985E-02, 1.72168557E-02, 1.71761084E-02,
     &   1.71255502E-02, 1.70642370E-02, 1.69913464E-02, 1.69071593E-02,
     &   1.68079896E-02, 1.66932549E-02, 1.65601977E-02, 1.64052576E-02,
     &   1.62222186E-02, 1.60012621E-02, 1.57240941E-02, 1.53465228E-02,
     &   1.46432586E-02, 1.46213460E-02, 1.44720885E-02, 1.43790787E-02,
     &   1.43124778E-02, 1.42609363E-02, 1.42192561E-02, 1.41845894E-02/
  
         DATA ((DAS (I,J), I=1901,2000), J=1,1) /
     &   1.41553106E-02, 1.41302688E-02, 1.41087988E-02, 1.40903173E-02,
     &   1.40745194E-02, 1.40611123E-02, 1.40498631E-02, 1.40406260E-02,
     &   1.40332957E-02, 1.40277791E-02, 1.40240054E-02, 1.40219472E-02,
     &   1.40215751E-02, 1.40228955E-02, 1.40259271E-02, 1.40307076E-02,
     &   1.40372875E-02, 1.40457748E-02, 1.40562815E-02, 1.40689423E-02,
     &   1.40839884E-02, 1.41018042E-02, 1.41226019E-02, 1.41472213E-02,
     &   1.41763993E-02, 1.42117843E-02, 1.42564476E-02, 1.43178775E-02,
     &   1.44758045E-02, 1.46162633E-02, 1.46725505E-02, 1.47141234E-02,
     &   1.47477920E-02, 1.47762334E-02, 1.48009236E-02, 1.48225181E-02,
     &   1.48415814E-02, 1.48585810E-02, 1.48736411E-02, 1.48870419E-02,
     &   1.48989365E-02, 1.49093944E-02, 1.49185900E-02, 1.49265999E-02,
     &   1.49333718E-02, 1.49390581E-02, 1.49436918E-02, 1.49472385E-02,
     &   1.49497718E-02, 1.49512821E-02, 1.49517895E-02, 1.49512855E-02,
     &   1.49497623E-02, 1.49472223E-02, 1.49436246E-02, 1.49389574E-02,
     &   1.49331734E-02, 1.49262417E-02, 1.49181062E-02, 1.49087086E-02,
     &   1.48979569E-02, 1.48858256E-02, 1.48721803E-02, 1.48569914E-02,
     &   1.47684712E-02, 1.47651371E-02, 1.47622327E-02, 1.47597354E-02,
     &   1.47576454E-02, 1.47559600E-02, 1.47546737E-02, 1.47537715E-02,
     &   1.47532483E-02, 1.47530993E-02, 1.47533343E-02, 1.47539561E-02,
     &   1.47549647E-02, 1.47563588E-02, 1.47581553E-02, 1.47603623E-02,
     &   1.47629577E-02, 1.47660004E-02, 1.47695088E-02, 1.47734565E-02,
     &   1.47779424E-02, 1.47828889E-02, 1.47884128E-02, 1.47945429E-02,
     &   1.48005928E-02, 1.48080923E-02, 1.48162864E-02, 1.48254643E-02,
     &   1.48356997E-02, 1.48471652E-02, 1.48600539E-02, 1.48749267E-02,
     &   1.48924410E-02, 1.49139980E-02, 1.49430107E-02, 1.50161359E-02/
  
         DATA ((DAS (I,J), I=2001,2100), J=1,1) /
     &   1.50904259E-02, 1.51206315E-02, 1.51434165E-02, 1.51621913E-02,
     &   1.51783606E-02, 1.51925787E-02, 1.52054243E-02, 1.52170861E-02,
     &   1.52277369E-02, 1.52374403E-02, 1.52465243E-02, 1.52549289E-02,
     &   1.52627717E-02, 1.52700800E-02, 1.52768520E-02, 1.52832188E-02,
     &   1.52890630E-02, 1.52944677E-02, 1.52995485E-02, 1.53041607E-02,
     &   1.53084591E-02, 1.53124013E-02, 1.53159958E-02, 1.53192824E-02,
     &   1.53222613E-02, 1.53249348E-02, 1.53273068E-02, 1.53293999E-02,
     &   1.53311982E-02, 1.53327222E-02, 1.53339835E-02, 1.53349789E-02,
     &   1.53357079E-02, 1.53361157E-02, 1.53361733E-02, 1.53320887E-02,
     &   1.52985692E-02, 1.52606029E-02, 1.52304229E-02, 1.52043541E-02,
     &   1.51839709E-02, 1.51655880E-02, 1.51496982E-02, 1.51339316E-02,
     &   1.51182426E-02, 1.51026570E-02, 1.50851966E-02, 1.50644190E-02,
     &   1.50484048E-02, 1.50323905E-02, 1.50563475E-02, 1.50793606E-02,
     &   1.50998954E-02, 1.51203564E-02, 1.51386801E-02, 1.51570499E-02,
     &   1.51739972E-02, 1.51911684E-02, 1.52078654E-02, 1.52234556E-02,
     &   1.52394092E-02, 1.52543798E-02, 1.52697639E-02, 1.52842518E-02,
     &   1.52991855E-02, 1.53132864E-02, 1.53278543E-02, 1.53416370E-02,
     &   1.53559009E-02, 1.53694164E-02, 1.53828160E-02, 1.53991116E-02,
     &   1.54124126E-02, 1.54262124E-02, 1.54393168E-02, 1.54529221E-02,
     &   1.54658500E-02, 1.54792798E-02, 1.54920475E-02, 1.55053172E-02,
     &   1.55179381E-02, 1.55310603E-02, 1.55441112E-02, 1.55565304E-02,
     &   1.55694491E-02, 1.55817459E-02, 1.55945404E-02, 1.56067220E-02,
     &   1.56193995E-02, 1.56314720E-02, 1.56440386E-02, 1.56560076E-02,
     &   1.56684686E-02, 1.56803390E-02, 1.56921627E-02, 1.57044751E-02,
     &   1.57162065E-02, 1.57284242E-02, 1.57400669E-02, 1.57521937E-02/
  
         DATA ((DAS (I,J), I=2101,2164), J=1,1) /
     &   1.57637509E-02, 1.57724173E-02, 1.57839503E-02, 1.57959711E-02,
     &   1.58074350E-02, 1.58193848E-02, 1.58314050E-02, 1.58428764E-02,
     &   1.58547315E-02, 1.58649190E-02, 1.58766955E-02, 1.58879290E-02,
     &   1.58996413E-02, 1.59108142E-02, 1.59224637E-02, 1.59335772E-02,
     &   1.59451653E-02, 1.59562207E-02, 1.59677487E-02, 1.59787472E-02,
     &   1.59897182E-02, 1.60011588E-02, 1.60120744E-02, 1.60234577E-02,
     &   1.60343190E-02, 1.60456460E-02, 1.60564540E-02, 1.60677257E-02,
     &   1.60784812E-02, 1.60896984E-02, 1.61004023E-02, 1.61115661E-02,
     &   1.62312124E-02, 1.63479141E-02, 1.63663275E-02, 1.71952704E-02,
     &   1.75727528E-02, 1.85708161E-02, 1.91358540E-02, 1.91633661E-02,
     &   1.99209679E-02, 1.99233747E-02, 2.04932549E-02, 2.05149974E-02,
     &   2.05280036E-02, 2.08113344E-02, 2.10001782E-02, 2.10340447E-02,
     &   2.10893980E-02, 2.11714506E-02, 2.12293573E-02, 2.12657964E-02,
     &   2.16197079E-02, 2.16376378E-02, 2.17422606E-02, 2.17612623E-02,
     &   2.18482759E-02, 2.18873044E-02, 2.19148415E-02, 2.19404850E-02,
     &   2.20101494E-02, 2.21624680E-02, 2.21644340E-02, 2.24689536E-02/
  
         DATA ((DAS (I,J), I=   1, 100), J=2,2) /
     &   5.73318260E-06, 6.04971345E-06, 6.39384515E-06, 6.78362554E-06,
     &   7.25979320E-06, 7.51835845E-06, 8.53431002E-06, 8.72736838E-06,
     &   9.17659801E-06, 9.66809666E-06, 9.61381856E-06, 9.64395388E-06,
     &   9.69196913E-06, 9.87867596E-06, 1.01721834E-05, 1.05096216E-05,
     &   1.08189951E-05, 1.10881918E-05, 1.12891166E-05, 1.16120717E-05,
     &   1.19024718E-05, 1.22306788E-05, 1.24853336E-05, 1.27994652E-05,
     &   1.30794933E-05, 1.34079138E-05, 1.38482333E-05, 1.41752987E-05,
     &   1.42009487E-05, 1.45340492E-05, 1.48933972E-05, 1.52016300E-05,
     &   1.55692837E-05, 1.59453866E-05, 1.63347084E-05, 1.67410378E-05,
     &   1.71738096E-05, 1.76436455E-05, 1.81002061E-05, 1.85773468E-05,
     &   1.89820317E-05, 1.94996663E-05, 1.96139018E-05, 2.05581798E-05,
     &   2.09924907E-05, 2.22014956E-05, 2.29415273E-05, 2.35028208E-05,
     &   2.38302172E-05, 2.41533846E-05, 2.77169449E-05, 3.19291844E-05,
     &   3.77606544E-05, 4.45947162E-05, 4.89961563E-05, 5.00235763E-05,
     &   5.14835474E-05, 5.25795775E-05, 5.44571471E-05, 5.51086032E-05,
     &   5.63472706E-05, 5.68252156E-05, 5.81271840E-05, 6.04394260E-05,
     &   6.27907550E-05, 6.56021910E-05, 6.83500993E-05, 6.99872986E-05,
     &   7.10303857E-05, 7.29753721E-05, 7.35710789E-05, 7.29439860E-05,
     &   7.53628450E-05, 7.84713805E-05, 8.21330524E-05, 8.80175014E-05,
     &   8.44636223E-05, 1.05628806E-04, 1.18739699E-04, 1.34130520E-04,
     &   1.47718958E-04, 1.59108899E-04, 1.72160846E-04, 1.82835187E-04,
     &   2.07464535E-04, 2.49124865E-04, 2.81611522E-04, 3.07180468E-04,
     &   3.29462026E-04, 3.52098527E-04, 3.66744097E-04, 3.80616405E-04,
     &   3.93760707E-04, 4.05273251E-04, 3.38908277E-04, 4.28358124E-04,
     &   3.84731370E-04, 4.33859610E-04, 4.36134237E-04, 4.37174228E-04/
  
         DATA ((DAS (I,J), I= 101, 200), J=2,2) /
     &   4.36674488E-04, 4.34910607E-04, 4.31836557E-04, 4.27424963E-04,
     &   4.21681749E-04, 4.14416678E-04, 2.73722213E-04, 3.95047694E-04,
     &   3.82271483E-04, 3.67632361E-04, 3.50660275E-04, 1.95163959E-04,
     &   3.07660677E-04, 2.80464760E-04, 2.47883960E-04, 2.07356260E-04,
     &   1.53649709E-04, 7.20285070E-05, 1.73637564E-04, 2.27725531E-04,
     &   2.68508913E-04, 3.01397349E-04, 3.28963215E-04, 3.52481764E-04,
     &   3.72293871E-04, 3.89118101E-04, 4.03582443E-04, 4.16021465E-04,
     &   4.26597750E-04, 4.35428707E-04, 4.42754164E-04, 4.48620916E-04,
     &   4.53134038E-04, 4.56308805E-04, 4.58125616E-04, 4.61326600E-04,
     &   4.56491284E-04, 4.52121590E-04, 4.50819382E-04, 4.46964207E-04,
     &   4.42971787E-04, 4.36370523E-04, 4.27490171E-04, 4.15120374E-04,
     &   4.04672888E-04, 3.90978691E-04, 3.75259404E-04, 3.57419898E-04,
     &   3.36849025E-04, 3.17254622E-04, 2.85398717E-04, 2.53174557E-04,
     &   2.45274722E-04, 1.84388196E-04, 1.95633409E-04, 1.89820247E-04,
     &   1.78861853E-04, 1.70711307E-04, 1.49499564E-04, 1.36590472E-04,
     &   1.27758121E-04, 1.16365318E-04, 1.12095616E-04, 1.07809528E-04,
     &   1.03827668E-04, 1.00077835E-04, 9.67516054E-05, 9.52125121E-05,
     &   8.81001878E-05, 8.33710280E-05, 7.99801317E-05, 7.79853938E-05,
     &   7.69981059E-05, 7.62522604E-05, 7.55253363E-05, 7.50696331E-05,
     &   7.47134678E-05, 7.46986273E-05, 7.52828178E-05, 7.58188817E-05,
     &   7.71109372E-05, 7.78305975E-05, 7.98403108E-05, 8.17850093E-05,
     &   8.46684967E-05, 8.74915272E-05, 9.14803908E-05, 9.52660774E-05,
     &   9.98423847E-05, 1.06201194E-04, 1.10007436E-04, 1.12697355E-04,
     &   1.18821253E-04, 1.21894218E-04, 1.24704269E-04, 1.28594171E-04,
     &   1.33305613E-04, 1.38794039E-04, 1.44467400E-04, 1.55629949E-04/
  
         DATA ((DAS (I,J), I= 201, 300), J=2,2) /
     &   1.67006665E-04, 1.74091857E-04, 1.76870944E-04, 1.79799149E-04,
     &   1.82879692E-04, 1.86110587E-04, 1.89497749E-04, 1.93040967E-04,
     &   1.96752653E-04, 2.00690287E-04, 2.04889782E-04, 2.09388164E-04,
     &   2.14223015E-04, 2.19357683E-04, 2.24814191E-04, 2.30570469E-04,
     &   2.36604612E-04, 2.42932723E-04, 2.49499456E-04, 2.56275206E-04,
     &   2.63278482E-04, 2.70553723E-04, 2.78229017E-04, 2.86525498E-04,
     &   2.95743429E-04, 3.06286791E-04, 3.18627799E-04, 3.33323774E-04,
     &   3.51471608E-04, 3.77002263E-04, 4.01997727E-04, 4.38104697E-04,
     &   3.95617984E-04, 3.94366825E-04, 4.12419647E-04, 4.14642608E-04,
     &   4.29580929E-04, 4.45728461E-04, 4.65262897E-04, 4.83926718E-04,
     &   5.06269296E-04, 5.31098368E-04, 5.53751889E-04, 6.20422736E-04,
     &   6.24248276E-04, 6.63257078E-04, 7.07417344E-04, 7.57688791E-04,
     &   8.15236680E-04, 8.81501033E-04, 9.58109889E-04, 1.04704015E-03,
     &   1.15002183E-03, 1.24942058E-03, 1.30414264E-03, 1.34116763E-03,
     &   1.37883416E-03, 1.41694816E-03, 1.40195382E-03, 1.49280037E-03,
     &   1.52889569E-03, 1.56156753E-03, 1.59032992E-03, 1.61280725E-03,
     &   1.62648653E-03, 1.62797865E-03, 1.59952595E-03, 1.55096343E-03,
     &   1.51673360E-03, 1.42402770E-03, 1.29474482E-03, 1.12495841E-03,
     &   9.13849955E-04, 6.64592944E-04, 3.86384915E-04, 1.13166240E-04,
     &   2.45573736E-04, 5.31940808E-04, 7.98922887E-04, 1.03177334E-03,
     &   1.22441013E-03, 1.37608440E-03, 1.48817745E-03, 1.56601212E-03,
     &   1.61490255E-03, 1.64019269E-03, 1.64696703E-03, 1.63957396E-03,
     &   1.62162009E-03, 1.59607293E-03, 1.54962274E-03, 1.50251623E-03,
     &   1.47043057E-03, 1.45410823E-03, 1.41844360E-03, 1.38036636E-03,
     &   1.34294276E-03, 1.30626058E-03, 1.27046663E-03, 1.23581046E-03/
  
         DATA ((DAS (I,J), I= 301, 400), J=2,2) /
     &   1.23193998E-03, 1.17014889E-03, 1.13919840E-03, 1.10947349E-03,
     &   1.01471233E-03, 9.33085389E-04, 8.62691284E-04, 8.01711568E-04,
     &   7.48608619E-04, 6.91617097E-04, 6.61165138E-04, 6.24928378E-04,
     &   5.92716381E-04, 5.63959733E-04, 5.38201259E-04, 5.15075797E-04,
     &   4.94280682E-04, 4.75588228E-04, 4.58824446E-04, 4.43893502E-04,
     &   4.31150452E-04, 4.20083615E-04, 4.23975056E-04, 4.07338723E-04,
     &   4.17686930E-04, 4.93378815E-04, 4.83107711E-04, 3.92322323E-04,
     &   3.63450893E-04, 3.44250444E-04, 3.29456104E-04, 3.16893415E-04,
     &   3.06097728E-04, 2.96433468E-04, 2.87718186E-04, 2.79774233E-04,
     &   2.72467200E-04, 2.65706224E-04, 2.59418192E-04, 2.53554067E-04,
     &   2.48067771E-04, 2.42909448E-04, 2.38024350E-04, 2.33441754E-04,
     &   2.29094360E-04, 2.24963844E-04, 2.21045403E-04, 2.17337134E-04,
     &   2.13824652E-04, 2.10498185E-04, 2.07355007E-04, 2.04341589E-04,
     &   2.01361877E-04, 1.98514265E-04, 1.95792921E-04, 1.93185199E-04,
     &   1.86347703E-04, 1.72976323E-04, 1.53599204E-04, 1.42437215E-04,
     &   1.36893123E-04, 1.32173988E-04, 1.29235287E-04, 1.28208516E-04,
     &   1.27807921E-04, 1.27700704E-04, 1.29014532E-04, 1.32003383E-04,
     &   1.33005003E-04, 1.35665257E-04, 1.39220613E-04, 1.39429566E-04,
     &   1.42964765E-04, 1.47443357E-04, 1.49501947E-04, 1.52371660E-04,
     &   1.57629115E-04, 1.63849552E-04, 1.70771005E-04, 1.78778844E-04,
     &   1.83561828E-04, 1.87355581E-04, 1.96122181E-04, 2.06306894E-04,
     &   2.07261398E-04, 2.17219341E-04, 2.29534487E-04, 2.35886950E-04,
     &   2.43025871E-04, 2.58036410E-04, 2.75828585E-04, 2.97867359E-04,
     &   3.05104157E-04, 3.23981927E-04, 3.38455773E-04, 3.54742108E-04,
     &   3.93799810E-04, 4.49422676E-04, 4.56383441E-04, 5.23377154E-04/
  
         DATA ((DAS (I,J), I= 401, 500), J=2,2) /
     &   6.43565739E-04, 6.53592554E-04, 5.57975893E-04, 4.85904419E-04,
     &   4.64143116E-04, 3.87015371E-04, 3.80252237E-04, 3.75647262E-04,
     &   3.65879711E-04, 3.45244666E-04, 3.21062664E-04, 2.92849530E-04,
     &   2.90252363E-04, 2.64648833E-04, 2.60735910E-04, 2.43808409E-04,
     &   2.33526137E-04, 2.02716087E-04, 1.99255867E-04, 1.84290458E-04,
     &   1.83624367E-04, 1.83380889E-04, 1.74001242E-04, 1.62805110E-04,
     &   1.59650161E-04, 1.52039945E-04, 1.51352523E-04, 1.52635398E-04,
     &   1.52228437E-04, 1.47517527E-04, 1.47889026E-04, 1.38308930E-04,
     &   1.38584406E-04, 1.33770419E-04, 1.33041232E-04, 1.28787225E-04,
     &   1.28831641E-04, 1.26903956E-04, 1.29116952E-04, 1.36160880E-04,
     &   1.43001288E-04, 1.49215318E-04, 1.51902276E-04, 1.54599982E-04,
     &   1.82338491E-04, 1.87677307E-04, 2.06174136E-04, 2.12908488E-04,
     &   2.18572324E-04, 2.23684470E-04, 2.38578718E-04, 2.41127680E-04,
     &   2.42844347E-04, 2.52906108E-04, 2.55176029E-04, 2.57054126E-04,
     &   2.72300788E-04, 2.74988079E-04, 2.80901836E-04, 2.82996829E-04,
     &   2.84054033E-04, 2.83672353E-04, 2.83650655E-04, 2.82469226E-04,
     &   2.82212854E-04, 2.79592315E-04, 2.74870929E-04, 2.71522188E-04,
     &   2.68583825E-04, 2.65424425E-04, 2.66100086E-04, 2.73101561E-04,
     &   2.83101529E-04, 2.92505977E-04, 2.94271103E-04, 3.09780980E-04,
     &   3.13110373E-04, 3.15431325E-04, 3.28799369E-04, 3.44990614E-04,
     &   3.47289507E-04, 3.75256244E-04, 3.93330136E-04, 4.03931614E-04,
     &   4.26990786E-04, 4.46638278E-04, 4.51024156E-04, 4.53596171E-04,
     &   4.55069800E-04, 4.57546725E-04, 4.62867580E-04, 4.63874937E-04,
     &   4.69906886E-04, 4.78800564E-04, 4.90727555E-04, 4.97465422E-04,
     &   6.44103696E-04, 7.23818186E-04, 6.53146498E-04, 4.86796154E-04/
  
         DATA ((DAS (I,J), I= 501, 600), J=2,2) /
     &   3.96590723E-04, 3.49257082E-04, 3.28819094E-04, 3.15836944E-04,
     &   3.15283822E-04, 2.91237848E-04, 2.71000959E-04, 2.57045845E-04,
     &   2.49824122E-04, 2.50357076E-04, 2.56072099E-04, 2.68002645E-04,
     &   2.85626331E-04, 3.10042977E-04, 3.48588363E-04, 4.13309911E-04,
     &   4.31380424E-04, 4.51638582E-04, 4.74717368E-04, 5.01093851E-04,
     &   5.31421950E-04, 5.66550176E-04, 6.07662440E-04, 6.16717647E-04,
     &   6.26091161E-04, 6.35796574E-04, 6.45849249E-04, 6.56266621E-04,
     &   6.67039513E-04, 6.78217067E-04, 6.89820870E-04, 7.01874936E-04,
     &   7.14399760E-04, 7.77118019E-04, 8.26297714E-04, 8.53455210E-04,
     &   8.72620928E-04, 8.92695207E-04, 9.13767135E-04, 9.35905249E-04,
     &   9.59193323E-04, 9.83720107E-04, 9.96479002E-04, 1.00958693E-03,
     &   1.02305646E-03, 1.03690406E-03, 1.05114396E-03, 1.06579433E-03,
     &   1.08087128E-03, 1.09639492E-03, 1.11238353E-03, 1.12885945E-03,
     &   1.14584347E-03, 1.16335990E-03, 1.18143359E-03, 1.20009153E-03,
     &   1.21936185E-03, 1.23927474E-03, 1.25986233E-03, 1.28115930E-03,
     &   1.30320217E-03, 1.32603039E-03, 1.34968597E-03, 1.37421450E-03,
     &   1.39966447E-03, 1.42608816E-03, 1.45354192E-03, 1.48208648E-03,
     &   1.51178747E-03, 1.54271588E-03, 1.57494862E-03, 1.60856916E-03,
     &   1.64366838E-03, 1.68034498E-03, 1.71870678E-03, 1.75887168E-03,
     &   1.80096879E-03, 1.84513986E-03, 1.89154085E-03, 1.94034374E-03,
     &   1.99173865E-03, 2.04593632E-03, 2.07415830E-03, 2.10317094E-03,
     &   2.13300748E-03, 2.16370353E-03, 2.19529639E-03, 2.22782591E-03,
     &   2.26133397E-03, 2.29586536E-03, 2.33146725E-03, 2.36819015E-03,
     &   2.40608742E-03, 2.44521623E-03, 2.48563715E-03, 2.52741515E-03,
     &   2.57061929E-03, 2.61532371E-03, 2.66160746E-03, 2.70955558E-03/
  
         DATA ((DAS (I,J), I= 601, 700), J=2,2) /
     &   2.75925897E-03, 2.81081568E-03, 2.86433075E-03, 2.91991764E-03,
     &   2.97769865E-03, 3.03780588E-03, 3.10038225E-03, 3.16558265E-03,
     &   3.23357517E-03, 3.30454261E-03, 3.37868405E-03, 3.45621676E-03,
     &   3.53737819E-03, 3.62242867E-03, 3.71165391E-03, 3.80536864E-03,
     &   3.90391929E-03, 4.00768956E-03, 4.11710456E-03, 4.23263696E-03,
     &   4.40567431E-03, 4.48422368E-03, 4.62152816E-03, 4.76747110E-03,
     &   4.92289299E-03, 5.08874710E-03, 5.26611886E-03, 5.45624978E-03,
     &   5.66056634E-03, 5.88071600E-03, 6.11861147E-03, 6.37648660E-03,
     &   6.65696641E-03, 6.88087926E-03, 7.57846964E-03, 8.43282450E-03,
     &   9.50343642E-03, 1.08842594E-02, 1.27328844E-02, 1.53353950E-02,
     &   1.92708331E-02, 2.59151059E-02, 3.95295314E-02, 8.31192097E-02,
     &   8.78935481E-02, 9.32476175E-02, 9.92934118E-02, 1.06173622E-01,
     &   1.14072866E-01, 1.23234209E-01, 1.33984092E-01, 1.46771072E-01,
     &   1.62228108E-01, 1.81276606E-01, 2.05308220E-01, 2.36519175E-01,
     &   2.78561493E-01, 2.83574033E-01, 3.95811234E-01, 4.77617533E-01,
     &   5.43344172E-01, 6.00506198E-01, 6.44554113E-01, 6.83040839E-01,
     &   7.13885268E-01, 7.44613150E-01, 7.65721383E-01, 7.85265862E-01,
     &   7.99057149E-01, 8.10426513E-01, 8.16815533E-01, 8.21584516E-01,
     &   8.21990044E-01, 8.19589917E-01, 8.12933980E-01, 8.05740485E-01,
     &   7.90180859E-01, 7.76239560E-01, 7.59126749E-01, 7.38573247E-01,
     &   7.14320836E-01, 6.86132045E-01, 6.53801546E-01, 6.17168909E-01,
     &   5.76132254E-01, 5.30662110E-01, 4.80814564E-01, 3.98198797E-01,
     &   3.38308039E-01, 2.42304112E-01, 1.40583074E-01, 1.40486070E-01,
     &   3.98113855E-01, 4.80736448E-01, 5.53879513E-01, 5.97139651E-01,
     &   6.53744698E-01, 6.86080770E-01, 7.14275103E-01, 7.38532977E-01/
  
         DATA ((DAS (I,J), I= 701, 800), J=2,2) /
     &   7.59091819E-01, 7.76209818E-01, 7.90156128E-01, 8.01202775E-01,
     &   8.09618214E-01, 8.15662395E-01, 8.19583197E-01, 8.21989204E-01,
     &   8.21587336E-01, 8.18456273E-01, 8.12799304E-01, 8.07873763E-01,
     &   7.95825573E-01, 7.85290302E-01, 7.69814061E-01, 7.53220592E-01,
     &   7.31571389E-01, 7.09501235E-01, 6.78725469E-01, 6.48783121E-01,
     &   6.12200782E-01, 5.70941831E-01, 5.17872962E-01, 4.57036752E-01,
     &   3.81073390E-01, 3.14015010E-01, 2.61925702E-01, 2.24339766E-01,
     &   1.96039273E-01, 1.74003261E-01, 1.56378574E-01, 1.41971154E-01,
     &   1.29979271E-01, 1.19845638E-01, 1.11171336E-01, 1.03663537E-01,
     &   9.71025660E-02, 9.13204783E-02, 8.61867204E-02, 8.15983003E-02,
     &   7.74728954E-02, 7.37439257E-02, 7.03569693E-02, 3.68934837E-02,
     &   2.50051877E-02, 1.89154316E-02, 1.52139984E-02, 1.27263689E-02,
     &   1.09396646E-02, 9.59427402E-03, 8.54470191E-03, 7.70307657E-03,
     &   7.01319326E-03, 6.93149002E-03, 6.36181626E-03, 5.87929200E-03,
     &   5.46535568E-03, 5.10636745E-03, 4.79207970E-03, 4.51464391E-03,
     &   4.26794757E-03, 4.04715949E-03, 3.84841042E-03, 3.66856533E-03,
     &   3.50505706E-03, 3.35576314E-03, 3.21891383E-03, 3.09302149E-03,
     &   2.97682669E-03, 2.86925604E-03, 2.76938893E-03, 2.67643163E-03,
     &   2.58969531E-03, 2.50858126E-03, 2.43256410E-03, 2.36118244E-03,
     &   2.29402908E-03, 2.23074328E-03, 2.17100434E-03, 2.11452648E-03,
     &   2.06105310E-03, 2.01035481E-03, 1.96222469E-03, 1.91647655E-03,
     &   1.87294139E-03, 1.83146619E-03, 1.79191184E-03, 1.75415166E-03,
     &   1.71807003E-03, 1.68356124E-03, 1.65052842E-03, 1.61888275E-03,
     &   1.58854254E-03, 1.55943258E-03, 1.53148358E-03, 1.50463156E-03,
     &   1.47881739E-03, 1.45398638E-03, 1.43008783E-03, 1.40707477E-03/
  
         DATA ((DAS (I,J), I= 801, 900), J=2,2) /
     &   1.38490396E-03, 1.36353428E-03, 1.34292841E-03, 1.32305080E-03,
     &   1.30387005E-03, 1.28535542E-03, 1.26747883E-03, 1.25021416E-03,
     &   1.23353716E-03, 1.21742535E-03, 1.20185789E-03, 1.18681551E-03,
     &   1.17228168E-03, 1.15823644E-03, 1.14466853E-03, 1.13156318E-03,
     &   1.11890819E-03, 1.10669270E-03, 1.09490718E-03, 1.08354347E-03,
     &   1.07259528E-03, 1.06205609E-03, 1.05192286E-03, 1.04219411E-03,
     &   1.03286890E-03, 1.02394920E-03, 1.01543909E-03, 1.00734531E-03,
     &   9.99677676E-04, 9.92449665E-04, 9.85679211E-04, 9.79382014E-04,
     &   9.73602238E-04, 9.68383604E-04, 9.63756749E-04, 9.59797053E-04,
     &   9.56577996E-04, 9.49751418E-04, 9.43153040E-04, 9.36803819E-04,
     &   9.30632884E-04, 9.24727045E-04, 9.19113082E-04, 9.13669737E-04,
     &   9.08591882E-04, 9.04513019E-04, 9.02900360E-04, 8.97352974E-04,
     &   8.91792167E-04, 8.86433870E-04, 8.81127413E-04, 8.75964247E-04,
     &   8.71012588E-04, 8.65989355E-04, 8.61161698E-04, 8.56444764E-04,
     &   6.60993577E-04, 5.66444635E-04, 5.29029290E-04, 5.44980445E-04,
     &   5.94647467E-04, 6.36109913E-04, 6.96657365E-04, 7.84580129E-04,
     &   8.73729471E-04, 9.97861701E-04, 1.04452129E-03, 1.13911526E-03,
     &   1.19989447E-03, 1.26518266E-03, 1.34207682E-03, 1.43659219E-03,
     &   1.55150078E-03, 1.69171065E-03, 1.86476713E-03, 2.08216665E-03,
     &   2.36195370E-03, 2.49743045E-03, 2.65013727E-03, 2.82349344E-03,
     &   3.02190023E-03, 3.25110857E-03, 3.51877716E-03, 3.67015543E-03,
     &   3.83534685E-03, 4.01631424E-03, 4.21541340E-03, 4.43549172E-03,
     &   4.68002746E-03, 4.95331171E-03, 5.26070303E-03, 5.60897945E-03,
     &   6.00684297E-03, 6.46565181E-03, 7.00052054E-03, 7.60456965E-03,
     &   8.00009515E-03, 8.43904134E-03, 8.92895862E-03, 9.47925526E-03/
  
         DATA ((DAS (I,J), I= 901,1000), J=2,2) /
     &   1.01018059E-02, 1.08118160E-02, 1.16290776E-02, 1.25798383E-02,
     &   1.36996652E-02, 1.50379809E-02, 1.66655321E-02, 1.86872641E-02,
     &   2.12657932E-02, 2.46672371E-02, 2.93588620E-02, 3.62423826E-02,
     &   4.73067495E-02, 6.79355844E-02, 1.00381232E-01, 1.18848093E-01,
     &   1.38990808E-01, 1.88551393E-01, 2.06406907E-01, 2.21143460E-01,
     &   2.33658212E-01, 2.44196348E-01, 2.52842349E-01, 2.60287014E-01,
     &   2.66382747E-01, 2.70745469E-01, 2.74451788E-01, 2.77075531E-01,
     &   2.78631725E-01, 2.79193775E-01, 2.78794645E-01, 2.77704028E-01,
     &   2.75490647E-01, 2.72594330E-01, 2.68690253E-01, 2.63667170E-01,
     &   2.58385359E-01, 2.50985186E-01, 2.43503453E-01, 2.34904273E-01,
     &   2.25132458E-01, 2.12190593E-01, 1.99741417E-01, 1.83617594E-01,
     &   1.68436088E-01, 1.46302199E-01, 1.22146534E-01, 8.60686287E-02,
     &   5.46210111E-02, 1.84011400E-02, 4.97259153E-04, 1.83092993E-02,
     &   3.65362211E-02, 8.59815452E-02, 1.22064754E-01, 1.46225204E-01,
     &   1.68364487E-01, 1.83550346E-01, 1.99679482E-01, 2.12133346E-01,
     &   2.25080760E-01, 2.34857345E-01, 2.43461262E-01, 2.50947666E-01,
     &   2.58353167E-01, 2.63639412E-01, 2.68667493E-01, 2.72576359E-01,
     &   2.75477245E-01, 2.77695569E-01, 2.78790265E-01, 2.79194310E-01,
     &   2.78636813E-01, 2.77085276E-01, 2.74466197E-01, 2.70764463E-01,
     &   2.66405850E-01, 2.60314663E-01, 2.52874460E-01, 2.44232713E-01,
     &   2.33698879E-01, 2.21188369E-01, 2.06455961E-01, 1.88604575E-01,
     &   1.66963055E-01, 1.78712422E-01, 1.39052059E-01, 1.00446439E-01,
     &   8.54392084E-02, 5.53232859E-02, 4.08206533E-02, 3.23253001E-02,
     &   2.67527759E-02, 2.28184171E-02, 1.98933442E-02, 1.76337629E-02,
     &   1.58359873E-02, 1.43717092E-02, 1.31560999E-02, 1.21308392E-02/
  
         DATA ((DAS (I,J), I=1001,1100), J=2,2) /
     &   1.12545155E-02, 1.04969137E-02, 9.83547089E-03, 9.25299955E-03,
     &   8.73617775E-03, 8.27451926E-03, 7.85965766E-03, 7.20404410E-03,
     &   6.38608379E-03, 5.94854062E-03, 5.23528168E-03, 4.67778615E-03,
     &   4.13307962E-03, 3.36163335E-03, 2.50544585E-03, 1.99768443E-03,
     &   1.78524934E-03, 1.66593199E-03, 1.58809481E-03, 1.53316409E-03,
     &   1.49174604E-03, 1.45924166E-03, 1.43285608E-03, 1.41078476E-03,
     &   1.39195890E-03, 1.37556205E-03, 1.36103908E-03, 1.34799932E-03,
     &   1.33609906E-03, 1.32513948E-03, 1.31490357E-03, 1.30521795E-03,
     &   1.29603508E-03, 1.28718632E-03, 1.27858864E-03, 1.27018839E-03,
     &   1.26187506E-03, 1.25367771E-03, 1.24541241E-03, 1.23704375E-03,
     &   1.22850954E-03, 1.21970420E-03, 1.21051284E-03, 1.20076894E-03,
     &   1.19027757E-03, 1.17867072E-03, 1.16526799E-03, 1.14837270E-03,
     &   1.11040749E-03, 1.07757304E-03, 1.06622298E-03, 1.05861761E-03,
     &   1.05302434E-03, 1.04873517E-03, 1.04537945E-03, 1.04271294E-03,
     &   1.04054528E-03, 1.03874435E-03, 1.03706843E-03, 1.03575052E-03,
     &   1.03430260E-03, 1.03271474E-03, 1.03069500E-03, 1.02596422E-03,
     &   1.02831813E-03, 1.02641371E-03, 1.02463687E-03, 1.02219854E-03,
     &   1.01906923E-03, 1.01517208E-03, 1.01042370E-03, 1.00432094E-03,
     &   9.97564192E-04, 9.89191275E-04, 9.79343569E-04, 9.67584943E-04,
     &   9.53551274E-04, 9.36999651E-04, 9.17215469E-04, 8.94019035E-04,
     &   8.65361142E-04, 8.28059839E-04, 7.76044594E-04, 7.60990598E-04,
     &   7.17428083E-04, 6.57246935E-04, 6.51681121E-04, 6.13685582E-04,
     &   6.01027569E-04, 5.91982352E-04, 5.79921227E-04, 5.68388941E-04,
     &   5.59694218E-04, 5.54981570E-04, 5.50756998E-04, 5.44336281E-04,
     &   5.34212461E-04, 5.30126272E-04, 5.12395574E-04, 4.93006090E-04/
  
         DATA ((DAS (I,J), I=1101,1200), J=2,2) /
     &   4.91824912E-04, 4.77564694E-04, 4.64242710E-04, 4.62947685E-04,
     &   4.59823392E-04, 4.63495419E-04, 4.77265669E-04, 5.20094846E-04,
     &   4.46264471E-04, 4.09596494E-04, 4.17785395E-04, 4.26669429E-04,
     &   4.41898301E-04, 4.39252652E-04, 4.27686618E-04, 4.27213765E-04,
     &   4.23273678E-04, 4.07872006E-04, 3.99945152E-04, 3.80202547E-04,
     &   3.76426777E-04, 3.76446499E-04, 3.68341849E-04, 3.62827438E-04,
     &   3.58739615E-04, 3.50507718E-04, 3.43915873E-04, 3.40911210E-04,
     &   3.39747745E-04, 3.38528075E-04, 3.38518015E-04, 3.36627294E-04,
     &   3.34262111E-04, 3.31499926E-04, 3.31306080E-04, 3.32671015E-04,
     &   3.30927851E-04, 3.22442383E-04, 3.17330053E-04, 3.15088612E-04,
     &   3.13500214E-04, 3.12616831E-04, 3.11434682E-04, 3.11072409E-04,
     &   3.09591227E-04, 3.06254932E-04, 3.04709137E-04, 3.03215240E-04,
     &   3.01606897E-04, 2.99209460E-04, 2.97785621E-04, 2.96803812E-04,
     &   2.96516838E-04, 2.96400543E-04, 2.98080648E-04, 2.94014511E-04,
     &   2.90744577E-04, 2.90074881E-04, 2.89704428E-04, 2.87998257E-04,
     &   2.87590656E-04, 2.88696790E-04, 2.85010198E-04, 2.88466064E-04,
     &   2.96068802E-04, 2.83900038E-04, 2.82953839E-04, 2.79284088E-04,
     &   2.78959442E-04, 2.82697668E-04, 2.76229077E-04, 2.74534255E-04,
     &   2.72966738E-04, 2.71716018E-04, 2.69013570E-04, 2.70107751E-04,
     &   2.69988797E-04, 2.69519233E-04, 2.67764561E-04, 2.68434676E-04,
     &   2.69056587E-04, 2.65450329E-04, 2.64996609E-04, 2.64917057E-04,
     &   2.60980983E-04, 2.61034828E-04, 2.61862522E-04, 2.60900716E-04,
     &   2.61629638E-04, 2.62966403E-04, 2.57785284E-04, 2.57284931E-04,
     &   2.57101385E-04, 2.62519703E-04, 2.60091564E-04, 2.59594973E-04,
     &   2.57890393E-04, 2.62466773E-04, 2.71027868E-04, 2.76026310E-04/
  
         DATA ((DAS (I,J), I=1201,1300), J=2,2) /
     &   2.71019499E-04, 2.70650261E-04, 2.74467048E-04, 2.71880266E-04,
     &   2.74532013E-04, 2.84625175E-04, 3.18786192E-04, 2.98924629E-04,
     &   3.00278277E-04, 3.11841550E-04, 2.90448326E-04, 2.86641984E-04,
     &   2.85244453E-04, 3.01001198E-04, 3.03091689E-04, 3.33666779E-04,
     &   3.36606227E-04, 3.86640048E-04, 4.52215444E-04, 4.83913590E-04,
     &   6.00023831E-04, 6.91706068E-04, 6.86371340E-04, 5.81517142E-04,
     &   4.80025153E-04, 3.91090418E-04, 3.65505561E-04, 3.45790605E-04,
     &   3.16938108E-04, 2.96509655E-04, 2.88311496E-04, 2.81104298E-04,
     &   2.74708287E-04, 2.68986473E-04, 2.63832326E-04, 2.59158323E-04,
     &   2.54903052E-04, 2.51008380E-04, 2.47428953E-04, 2.44127054E-04,
     &   2.41071023E-04, 2.38234071E-04, 2.35593359E-04, 2.33129287E-04,
     &   2.30824934E-04, 2.28665609E-04, 2.26638497E-04, 2.24732367E-04,
     &   2.22937338E-04, 2.21244685E-04, 2.19646678E-04, 2.18136449E-04,
     &   2.16707885E-04, 2.15355528E-04, 2.14074505E-04, 2.12860452E-04,
     &   2.11709467E-04, 2.10618055E-04, 2.09583095E-04, 2.08601796E-04,
     &   2.07671678E-04, 2.06790541E-04, 2.05956446E-04, 2.05167700E-04,
     &   2.04568364E-04, 2.03720627E-04, 2.02440235E-04, 2.01320801E-04,
     &   2.00359942E-04, 1.99558798E-04, 1.98922426E-04, 1.98460498E-04,
     &   1.98188411E-04, 1.98129013E-04, 1.98315308E-04, 1.98794784E-04,
     &   1.99637269E-04, 2.00944552E-04, 2.02878956E-04, 2.05708766E-04,
     &   2.06056827E-04, 2.09922957E-04, 2.16546284E-04, 2.28263950E-04,
     &   2.47449278E-04, 2.55543261E-04, 2.90939134E-04, 3.64464819E-04,
     &   4.01088085E-04, 4.54534511E-04, 4.91251627E-04, 5.38080657E-04,
     &   5.85722077E-04, 6.46142120E-04, 6.82755025E-04, 7.24860713E-04,
     &   7.73726915E-04, 8.31039106E-04, 8.99087817E-04, 9.81066658E-04/
  
         DATA ((DAS (I,J), I=1301,1400), J=2,2) /
     &   1.02863996E-03, 1.08156577E-03, 1.14077535E-03, 1.20742854E-03,
     &   1.28298838E-03, 1.36932724E-03, 1.46888055E-03, 1.58487584E-03,
     &   1.72168308E-03, 1.77872131E-03, 1.81452398E-03, 1.85184347E-03,
     &   1.89077733E-03, 1.93143162E-03, 1.97392193E-03, 2.01837439E-03,
     &   2.06492699E-03, 2.11373094E-03, 2.16495233E-03, 2.21877398E-03,
     &   2.27539762E-03, 2.33504639E-03, 2.39796777E-03, 2.46443698E-03,
     &   2.53476096E-03, 2.60928312E-03, 2.68838890E-03, 2.77251240E-03,
     &   2.86214428E-03, 2.95784137E-03, 3.06023810E-03, 3.17006059E-03,
     &   3.28814381E-03, 3.41545275E-03, 3.55310879E-03, 3.70242267E-03,
     &   3.86493628E-03, 4.04247590E-03, 4.23722098E-03, 4.45179382E-03,
     &   4.68937810E-03, 4.95387754E-03, 5.25013166E-03, 5.58421411E-03,
     &   5.96385273E-03, 6.39903389E-03, 6.90289247E-03, 7.49305879E-03,
     &   8.19376141E-03, 9.03923205E-03, 1.00794611E-02, 1.13904424E-02,
     &   1.30936019E-02, 1.53956968E-02, 1.86796844E-02, 2.37429713E-02,
     &   3.25644035E-02, 5.17607229E-02, 6.36627786E-02, 1.21257553E-01,
     &   1.68721208E-01, 2.03125130E-01, 2.29745389E-01, 2.51617189E-01,
     &   2.70757416E-01, 2.88516881E-01, 3.00880337E-01, 3.13465382E-01,
     &   3.25842662E-01, 3.31810330E-01, 3.40173899E-01, 3.45185252E-01,
     &   3.51405667E-01, 3.53026739E-01, 3.55424513E-01, 3.56420978E-01,
     &   3.55669975E-01, 3.54524060E-01, 3.52794046E-01, 3.47315412E-01,
     &   3.43473476E-01, 3.38751550E-01, 3.26585455E-01, 3.19032357E-01,
     &   3.10400016E-01, 3.00523353E-01, 2.77364528E-01, 2.63763649E-01,
     &   2.49019074E-01, 2.15503428E-01, 1.96950887E-01, 1.56123233E-01,
     &   1.11175858E-01, 1.18724321E-02, 1.09699600E-01, 1.54762304E-01,
     &   1.95529384E-01, 2.31753689E-01, 2.48039075E-01, 2.62865094E-01/
  
         DATA ((DAS (I,J), I=1401,1500), J=2,2) /
     &   2.76411678E-01, 2.99862204E-01, 3.09715917E-01, 3.18516296E-01,
     &   3.26136171E-01, 3.38424568E-01, 3.43156484E-01, 3.47094317E-01,
     &   3.52640872E-01, 3.54431893E-01, 3.56261275E-01, 3.56425959E-01,
     &   3.55479324E-01, 3.53136744E-01, 3.49669035E-01, 3.45334778E-01,
     &   3.40341505E-01, 3.31996207E-01, 3.26067903E-01, 3.13666005E-01,
     &   3.01113624E-01, 2.88712690E-01, 2.70941735E-01, 2.51785397E-01,
     &   2.29892845E-01, 2.03246346E-01, 1.68809822E-01, 1.20608023E-01,
     &   6.58270027E-02, 3.76521335E-02, 2.63442875E-02, 2.02563184E-02,
     &   1.64533261E-02, 1.38526374E-02, 1.19621091E-02, 1.05258982E-02,
     &   9.39786074E-03, 8.48845633E-03, 7.73976618E-03, 7.11266772E-03,
     &   6.57978253E-03, 6.12137745E-03, 5.72287027E-03, 5.37325209E-03,
     &   5.06405600E-03, 4.78866350E-03, 4.54182619E-03, 4.31932869E-03,
     &   4.11774645E-03, 3.93426855E-03, 3.76656622E-03, 3.61269366E-03,
     &   3.47101245E-03, 3.34013318E-03, 3.21886983E-03, 3.10620392E-03,
     &   3.00125590E-03, 2.90326224E-03, 2.81155695E-03, 2.72555644E-03,
     &   2.64474719E-03, 2.56867554E-03, 2.49693918E-03, 2.42918012E-03,
     &   2.36507877E-03, 2.30434885E-03, 2.24673324E-03, 2.19200032E-03,
     &   2.13994089E-03, 2.09036552E-03, 2.04310228E-03, 1.99799476E-03,
     &   1.95490035E-03, 1.91368876E-03, 1.87424070E-03, 1.83644679E-03,
     &   1.80020648E-03, 1.76542725E-03, 1.50377119E-03, 1.34417376E-03,
     &   1.19203349E-03, 1.02382055E-03, 8.69319387E-04, 7.22907568E-04,
     &   6.47677111E-04, 5.44406205E-04, 5.10560709E-04, 4.84093706E-04,
     &   4.52628801E-04, 4.27682635E-04, 4.07651833E-04, 3.77353842E-04,
     &   3.54009526E-04, 3.00042012E-04, 2.72233721E-04, 2.72600735E-04,
     &   3.17227738E-04, 4.23989814E-04, 5.87557290E-04, 8.19666840E-04/
  
         DATA ((DAS (I,J), I=1501,1600), J=2,2) /
     &   1.15030588E-03, 1.99414103E-03, 2.15508459E-03, 2.34479853E-03,
     &   2.39980441E-03, 2.52522481E-03, 2.66464117E-03, 2.82052266E-03,
     &   2.99595563E-03, 3.19485033E-03, 3.42223407E-03, 3.68468088E-03,
     &   3.99095622E-03, 4.35301290E-03, 4.78758480E-03, 5.31884280E-03,
     &   5.98304262E-03, 6.83715619E-03, 7.97613333E-03, 9.57087045E-03,
     &   1.19631413E-02, 1.59502651E-02, 2.39232236E-02, 3.46186655E-02,
     &   3.64138959E-02, 3.84053833E-02, 4.06271495E-02, 4.31215567E-02,
     &   4.59420276E-02, 4.91569041E-02, 5.28550404E-02, 5.71541122E-02,
     &   6.22133162E-02, 6.82534187E-02, 7.55896353E-02, 8.46880334E-02,
     &   9.62676702E-02, 1.11498235E-01, 1.32415721E-01, 1.62895973E-01,
     &   2.11288202E-01, 2.99108543E-01, 4.97782375E-01, 5.67428143E-01,
     &   6.22244649E-01, 6.83342427E-01, 7.34618132E-01, 7.71597125E-01,
     &   8.02959648E-01, 8.17410267E-01, 8.23147591E-01, 8.15931436E-01,
     &   7.90361385E-01, 7.60921327E-01, 7.55350524E-01, 7.52454382E-01,
     &   7.46436594E-01, 7.43944164E-01, 7.42042475E-01, 7.40112856E-01,
     &   7.19244408E-01, 6.82331901E-01, 6.32939862E-01, 5.80608116E-01,
     &   5.13576465E-01, 4.37410765E-01, 3.61588207E-01, 3.16782912E-01,
     &   2.70284850E-01, 2.22304239E-01, 1.53094841E-01, 1.02562157E-01,
     &   5.14343587E-02, 2.05948328E-02, 1.03031100E-02, 2.26060905E-04,
     &   1.02926079E-02, 5.14238763E-02, 1.02551743E-01, 1.53084541E-01,
     &   3.78985438E-01, 4.61180854E-01, 5.92885176E-01, 6.43540018E-01,
     &   6.91131214E-01, 7.30035481E-01, 7.58168791E-01, 7.82494921E-01,
     &   7.98807475E-01, 8.11493056E-01, 8.18653058E-01, 8.22566180E-01,
     &   8.22996119E-01, 8.20602743E-01, 8.16298450E-01, 8.02071141E-01,
     &   7.92482066E-01, 7.81850592E-01, 7.71600167E-01, 7.48524830E-01/
  
         DATA ((DAS (I,J), I=1601,1700), J=2,2) /
     &   7.35895895E-01, 7.15384827E-01, 3.81882520E-01, 2.50724438E-01,
     &   1.85613197E-01, 1.47115929E-01, 1.21769044E-01, 1.03842252E-01,
     &   9.05023947E-02, 8.01925202E-02, 7.19874063E-02, 6.53031634E-02,
     &   5.97533232E-02, 5.50719936E-02, 5.10702812E-02, 4.76103231E-02,
     &   4.45891568E-02, 4.19283403E-02, 3.95670670E-02, 3.74574761E-02,
     &   3.55613827E-02, 2.39310986E-02, 1.59581403E-02, 1.19710147E-02,
     &   9.57874151E-03, 7.98400093E-03, 6.84502514E-03, 5.99091356E-03,
     &   5.32671680E-03, 4.79546269E-03, 4.36089560E-03, 3.99884481E-03,
     &   3.69257205E-03, 3.43012638E-03, 3.20274395E-03, 3.00385072E-03,
     &   2.82841943E-03, 2.67253991E-03, 2.53312588E-03, 2.40770824E-03,
     &   2.25758920E-03, 2.08254984E-03, 1.93313125E-03, 1.80412119E-03,
     &   1.69163282E-03, 1.59270941E-03, 1.23591497E-03, 1.01442352E-03,
     &   8.64429848E-04, 7.56776262E-04, 6.76459474E-04, 6.15185582E-04,
     &   5.65284905E-04, 5.24832603E-04, 2.98951958E-04, 2.94779936E-04,
     &   3.00816720E-04, 3.05617567E-04, 3.15449162E-04, 3.32197172E-04,
     &   3.42679893E-04, 3.57263502E-04, 3.96922764E-04, 4.66217546E-04,
     &   6.01019860E-04, 9.37446663E-04, 1.27239698E-03, 1.35980201E-03,
     &   1.46091520E-03, 1.57916111E-03, 1.71921376E-03, 1.88762104E-03,
     &   2.09383136E-03, 2.35202608E-03, 2.68448980E-03, 3.12833566E-03,
     &   3.75043619E-03, 4.68448943E-03, 6.24238937E-03, 6.51342269E-03,
     &   6.80908127E-03, 7.13295172E-03, 7.48922996E-03, 7.88298745E-03,
     &   8.32056293E-03, 8.80964007E-03, 9.35981033E-03, 9.98342197E-03,
     &   1.06961409E-02, 1.15184291E-02, 1.24778723E-02, 1.36117587E-02,
     &   1.49722373E-02, 1.66351458E-02, 1.71547664E-02, 1.87136403E-02,
     &   2.13853543E-02, 2.49472950E-02, 2.99323811E-02, 3.74055402E-02/
  
         DATA ((DAS (I,J), I=1701,1800), J=2,2) /
     &   4.98435434E-02, 7.46399203E-02, 1.47930268E-01, 1.75869835E-01,
     &   2.48060509E-01, 3.02960074E-01, 3.48195069E-01, 3.87676640E-01,
     &   4.22704803E-01, 4.54128456E-01, 4.82197550E-01, 5.08214719E-01,
     &   5.32784808E-01, 5.55239147E-01, 5.74990369E-01, 5.93260477E-01,
     &   6.09733116E-01, 6.24161163E-01, 6.37868931E-01, 6.49097268E-01,
     &   6.57865483E-01, 6.65309942E-01, 6.71039942E-01, 6.74589488E-01,
     &   6.75482503E-01, 6.73973656E-01, 6.69616330E-01, 6.61917080E-01,
     &   6.50341583E-01, 6.37328004E-01, 6.17172559E-01, 5.91532292E-01,
     &   5.59885900E-01, 5.14801193E-01, 4.60508548E-01, 3.87109322E-01,
     &   2.90927481E-01, 2.59734037E-04, 2.90922754E-01, 3.87105074E-01,
     &   4.60504799E-01, 5.14797911E-01, 5.59883097E-01, 5.91529897E-01,
     &   6.17170564E-01, 6.37326394E-01, 6.50340280E-01, 6.61916128E-01,
     &   6.69615708E-01, 6.73973342E-01, 6.75482476E-01, 6.74589726E-01,
     &   6.71040466E-01, 6.65310725E-01, 6.57866502E-01, 6.49098501E-01,
     &   6.37870386E-01, 6.24162840E-01, 6.09734990E-01, 5.93262544E-01,
     &   5.74992622E-01, 5.55241574E-01, 5.32787409E-01, 5.08217488E-01,
     &   4.82200474E-01, 4.54131527E-01, 4.22708019E-01, 3.87679995E-01,
     &   3.48198557E-01, 3.02963692E-01, 2.48064251E-01, 1.75873696E-01,
     &   1.47918418E-01, 7.46398303E-02, 4.98475109E-02, 3.74084932E-02,
     &   2.99357020E-02, 2.49512694E-02, 2.13893293E-02, 1.87173605E-02,
     &   1.66391215E-02, 1.49762131E-02, 1.36155997E-02, 1.24818485E-02,
     &   1.15224054E-02, 1.07000340E-02, 9.98739858E-03, 9.36378710E-03,
     &   6.24636755E-03, 4.68846940E-03, 3.75441816E-03, 3.13231950E-03,
     &   2.68846942E-03, 2.35601632E-03, 2.09783850E-03, 1.89164960E-03,
     &   1.72326864E-03, 1.58324680E-03, 1.46503970E-03, 1.36395817E-03/
  
         DATA ((DAS (I,J), I=1801,1900), J=2,2) /
     &   1.27657852E-03, 9.65219565E-04, 7.42574058E-04, 6.14015575E-04,
     &   5.31917651E-04, 4.75983501E-04, 4.36154077E-04, 4.06855603E-04,
     &   3.84780223E-04, 3.67845415E-04, 3.54663662E-04, 3.44291159E-04,
     &   3.36085110E-04, 3.29590145E-04, 3.24481240E-04, 3.20528356E-04,
     &   3.17575850E-04, 3.15534589E-04, 3.14391028E-04, 3.14254665E-04,
     &   3.14606806E-04, 3.14199105E-04, 3.14146808E-04, 3.80042133E-04,
     &   4.40239619E-04, 4.90202014E-04, 5.32888283E-04, 5.69353170E-04,
     &   6.00871901E-04, 6.28018863E-04, 6.51369414E-04, 6.71157072E-04,
     &   6.87806576E-04, 7.01598384E-04, 7.12579539E-04, 7.20877875E-04,
     &   7.26691003E-04, 7.30128962E-04, 7.31161004E-04, 7.29907487E-04,
     &   7.26392419E-04, 7.20506959E-04, 7.12399616E-04, 7.02234479E-04,
     &   6.89347974E-04, 6.74588654E-04, 6.57056111E-04, 6.37079543E-04,
     &   6.14209558E-04, 5.88402604E-04, 5.59695615E-04, 5.28237190E-04,
     &   4.91912105E-04, 4.51677756E-04, 4.07495781E-04, 3.57135765E-04,
     &   3.02683023E-04, 2.74602625E-04, 3.91781139E-04, 4.54515978E-04,
     &   5.03163733E-04, 5.42164421E-04, 5.75589546E-04, 6.04346198E-04,
     &   6.28242676E-04, 6.49233772E-04, 6.67395360E-04, 6.82855007E-04,
     &   6.95773067E-04, 7.06533265E-04, 7.15022543E-04, 7.21803271E-04,
     &   7.26469486E-04, 7.29384916E-04, 7.30469509E-04, 7.29709636E-04,
     &   7.27164823E-04, 7.22741519E-04, 7.16385213E-04, 7.08164335E-04,
     &   6.97937560E-04, 6.85504674E-04, 6.70750470E-04, 6.53785990E-04,
     &   6.33864451E-04, 6.11012053E-04, 5.84830742E-04, 5.54702668E-04,
     &   5.20016462E-04, 4.79352497E-04, 4.31387506E-04, 3.71939099E-04,
     &   2.93769616E-04, 2.92281475E-04, 2.80909792E-04, 2.76736549E-04,
     &   2.75179315E-04, 2.74539446E-04, 2.74066135E-04, 2.74034410E-04/
  
         DATA ((DAS (I,J), I=1901,2000), J=2,2) /
     &   2.74323038E-04, 2.74699798E-04, 2.75082318E-04, 2.75373521E-04,
     &   2.75548616E-04, 2.75655655E-04, 2.75626520E-04, 2.75494153E-04,
     &   2.75213556E-04, 2.74725697E-04, 2.74088324E-04, 2.73262091E-04,
     &   2.72259996E-04, 2.71081622E-04, 2.69707877E-04, 2.68097091E-04,
     &   2.66282787E-04, 2.64251408E-04, 2.61994785E-04, 2.59511348E-04,
     &   2.56791812E-04, 2.53822158E-04, 2.50543781E-04, 2.46973412E-04,
     &   2.43207798E-04, 2.38530626E-04, 2.33507322E-04, 2.28234925E-04,
     &   2.20818704E-04, 2.23503747E-04, 2.26720369E-04, 2.29726860E-04,
     &   2.32829918E-04, 2.35727610E-04, 2.38250171E-04, 2.40676615E-04,
     &   2.43004270E-04, 2.45168170E-04, 2.47195690E-04, 2.49100690E-04,
     &   2.50877658E-04, 2.52517895E-04, 2.54032518E-04, 2.55425310E-04,
     &   2.56676809E-04, 2.57809375E-04, 2.58825619E-04, 2.59716212E-04,
     &   2.60475289E-04, 2.61107552E-04, 2.61636902E-04, 2.62061668E-04,
     &   2.62394664E-04, 2.62624151E-04, 2.62732098E-04, 2.62746929E-04,
     &   2.62714820E-04, 2.62666458E-04, 2.62617409E-04, 2.62624062E-04,
     &   2.62791435E-04, 2.62122326E-04, 2.60764600E-04, 2.59251444E-04,
     &   2.54367205E-04, 2.54244309E-04, 2.54097458E-04, 2.53922271E-04,
     &   2.53710176E-04, 2.53458722E-04, 2.53173839E-04, 2.52851730E-04,
     &   2.52488006E-04, 2.51460486E-04, 2.50406352E-04, 2.49378541E-04,
     &   2.48363484E-04, 2.47343224E-04, 2.46299826E-04, 2.45236394E-04,
     &   2.44159985E-04, 2.43046114E-04, 2.41891738E-04, 2.40699103E-04,
     &   2.39446404E-04, 2.38165728E-04, 2.36838376E-04, 2.35447475E-04,
     &   2.33962363E-04, 2.32482799E-04, 2.30905037E-04, 2.29317293E-04,
     &   2.27445685E-04, 2.25512916E-04, 2.23561517E-04, 2.21602639E-04,
     &   2.19331221E-04, 2.16891890E-04, 2.14382291E-04, 2.10936782E-04/
  
         DATA ((DAS (I,J), I=2001,2100), J=2,2) /
     &   2.11665753E-04, 2.13088978E-04, 2.14717302E-04, 2.16322889E-04,
     &   2.17701601E-04, 2.19142235E-04, 2.20610896E-04, 2.22056035E-04,
     &   2.23237559E-04, 2.24439483E-04, 2.25554329E-04, 2.26655186E-04,
     &   2.27711074E-04, 2.28713073E-04, 2.29677463E-04, 2.30614353E-04,
     &   2.31496454E-04, 2.32328866E-04, 2.33138852E-04, 2.33901439E-04,
     &   2.34642115E-04, 2.35355371E-04, 2.36034568E-04, 2.36691216E-04,
     &   2.37340492E-04, 2.37990317E-04, 2.38619040E-04, 2.38939048E-04,
     &   2.39279069E-04, 2.39663896E-04, 2.40131653E-04, 2.40726065E-04,
     &   2.41279214E-04, 2.41046450E-04, 2.40774087E-04, 2.39106030E-04,
     &   2.38311689E-04, 2.39695749E-04, 2.43314053E-04, 2.49473658E-04,
     &   2.57197377E-04, 2.66886044E-04, 2.77551464E-04, 2.89984855E-04,
     &   3.03818634E-04, 3.18426330E-04, 3.35475336E-04, 3.53771867E-04,
     &   3.61000209E-04, 3.68228551E-04, 3.53890767E-04, 3.41089566E-04,
     &   3.30475390E-04, 3.20736170E-04, 3.12479565E-04, 3.04763431E-04,
     &   2.98119585E-04, 2.91827840E-04, 2.86109887E-04, 2.81105383E-04,
     &   2.76297539E-04, 2.72055963E-04, 2.67951861E-04, 2.64307616E-04,
     &   2.60760675E-04, 2.57594132E-04, 2.54496848E-04, 2.51719057E-04,
     &   2.48990494E-04, 2.46533721E-04, 2.44213980E-04, 2.41922913E-04,
     &   2.39850067E-04, 2.37796912E-04, 2.35933725E-04, 2.34083239E-04,
     &   2.32399658E-04, 2.30723489E-04, 2.29194975E-04, 2.27669845E-04,
     &   2.26276149E-04, 2.24882757E-04, 2.23550289E-04, 2.22329207E-04,
     &   2.21105087E-04, 2.19981409E-04, 2.18853119E-04, 2.17815801E-04,
     &   2.16772672E-04, 2.15812270E-04, 2.14845149E-04, 2.13953538E-04,
     &   2.13054532E-04, 2.12224683E-04, 2.11422754E-04, 2.10612747E-04,
     &   2.09863772E-04, 2.09106424E-04, 2.08405398E-04, 2.07695806E-04/
  
         DATA ((DAS (I,J), I=2101,2164), J=2,2) /
     &   2.07038328E-04, 2.06372345E-04, 2.05754521E-04, 2.05127970E-04,
     &   2.04546371E-04, 2.03956046E-04, 2.03382769E-04, 2.02850474E-04,
     &   2.02309269E-04, 2.01792040E-04, 2.01280010E-04, 2.00803400E-04,
     &   2.00318336E-04, 1.99866508E-04, 1.99406350E-04, 1.98977435E-04,
     &   1.98540325E-04, 1.98132632E-04, 1.97716890E-04, 1.97328890E-04,
     &   1.96950004E-04, 1.96563298E-04, 1.96202085E-04, 1.95833211E-04,
     &   1.95488465E-04, 1.95136217E-04, 1.94806838E-04, 1.94470119E-04,
     &   1.94155102E-04, 1.93832906E-04, 1.93531329E-04, 1.93222734E-04,
     &   1.90254432E-04, 1.87851151E-04, 1.87508333E-04, 1.77896422E-04,
     &   1.75512239E-04, 1.71555840E-04, 1.70143908E-04, 1.70084951E-04,
     &   1.68729319E-04, 1.68725717E-04, 1.67969514E-04, 1.67944102E-04,
     &   1.67929009E-04, 1.67619891E-04, 1.67432859E-04, 1.67400796E-04,
     &   1.67349315E-04, 1.67275058E-04, 1.67224088E-04, 1.67192683E-04,
     &   1.66909625E-04, 1.66896270E-04, 1.66820100E-04, 1.66806219E-04,
     &   1.66745718E-04, 1.66723533E-04, 1.66705165E-04, 1.66688181E-04,
     &   1.66638447E-04, 1.66576324E-04, 1.66542243E-04, 1.66367907E-04/

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Thu Mar 29 23:47:18 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: 1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50

c replaced March 29, 2012 [dalhads.dat;424]
  
         DATA ((DGS (I,J), I=   1, 100), J=1,1) /
     &  -1.72187486E-03,-1.83339733E-03,-1.94303983E-03,-2.05831671E-03,
     &  -2.18323777E-03,-2.24421138E-03,-2.34736523E-03,-2.53535464E-03,
     &  -2.59978529E-03,-2.66402880E-03,-2.76842349E-03,-2.86887878E-03,
     &  -2.98586467E-03,-3.06271767E-03,-3.15904879E-03,-3.25689771E-03,
     &  -3.35453335E-03,-3.45315261E-03,-3.53381066E-03,-3.63689755E-03,
     &  -3.72102898E-03,-3.82417747E-03,-3.90700852E-03,-4.01549027E-03,
     &  -4.10412628E-03,-4.19223387E-03,-4.30226129E-03,-4.36239866E-03,
     &  -4.39139948E-03,-4.48365597E-03,-4.57876950E-03,-4.67404687E-03,
     &  -4.77120151E-03,-4.86909676E-03,-4.97448149E-03,-5.08059176E-03,
     &  -5.18949513E-03,-5.29623750E-03,-5.41566122E-03,-5.53589936E-03,
     &  -5.62595447E-03,-5.74596684E-03,-5.86686256E-03,-5.95857641E-03,
     &  -6.08446362E-03,-6.21314898E-03,-6.31327064E-03,-6.45181065E-03,
     &  -6.55679797E-03,-6.70498193E-03,-7.51896441E-03,-8.38916913E-03,
     &  -9.61771320E-03,-1.11881517E-02,-1.16928427E-02,-1.18431138E-02,
     &  -1.22425760E-02,-1.27784841E-02,-1.33508710E-02,-1.39250091E-02,
     &  -1.45063469E-02,-1.47326255E-02,-1.50770375E-02,-1.56511108E-02,
     &  -1.61174241E-02,-1.65836881E-02,-1.69354554E-02,-1.71126107E-02,
     &  -1.72269756E-02,-1.71906714E-02,-1.71277218E-02,-1.70030121E-02,
     &  -1.65122578E-02,-1.56808308E-02,-1.44962145E-02,-1.28102714E-02,
     &  -1.06625275E-02,-8.02617597E-03,-5.38537731E-03,-4.45220393E-03,
     &  -1.85751996E-03,-6.33497315E-04, 6.87264655E-04, 1.65729140E-03,
     &   3.18767547E-03, 4.94547174E-03, 5.95241151E-03, 6.67845159E-03,
     &   7.24743666E-03, 7.68373597E-03, 8.10309773E-03, 8.39337501E-03,
     &   8.63774363E-03, 8.99333124E-03, 9.21354374E-03, 9.70992851E-03,
     &   9.86880551E-03, 1.00132102E-02, 1.02299790E-02, 1.04151955E-02/
  
         DATA ((DGS (I,J), I= 101, 200), J=1,1) /
     &   1.05805361E-02, 1.07236059E-02, 1.08715491E-02, 1.09904530E-02,
     &   1.11028981E-02, 1.12097617E-02, 1.12957336E-02, 1.13766439E-02,
     &   1.14519230E-02, 1.15134232E-02, 1.15719383E-02, 1.16191151E-02,
     &   1.16608678E-02, 1.16970449E-02, 1.17322916E-02, 1.17578665E-02,
     &   1.17691280E-02, 1.17923967E-02, 1.18327363E-02, 1.18615988E-02,
     &   1.19201441E-02, 1.19800302E-02, 1.20547559E-02, 1.21371368E-02,
     &   1.22273803E-02, 1.23262057E-02, 1.24355640E-02, 1.25604364E-02,
     &   1.26965654E-02, 1.28436947E-02, 1.29972378E-02, 1.31577024E-02,
     &   1.33311483E-02, 1.35000619E-02, 1.36786885E-02, 1.38469133E-02,
     &   1.39774269E-02, 1.41088714E-02, 1.41305915E-02, 1.41777698E-02,
     &   1.42479738E-02, 1.43559555E-02, 1.44799873E-02, 1.46177303E-02,
     &   1.47860732E-02, 1.49618632E-02, 1.51490657E-02, 1.53288381E-02,
     &   1.55109706E-02, 1.57071020E-02, 1.59198538E-02, 1.62342628E-02,
     &   1.63302705E-02, 1.66799874E-02, 1.70035046E-02, 1.74422863E-02,
     &   1.77812757E-02, 1.79614424E-02, 1.81767195E-02, 1.82990059E-02,
     &   1.84152254E-02, 1.85651736E-02, 1.86052215E-02, 1.86343630E-02,
     &   1.86881850E-02, 1.86907501E-02, 1.85654928E-02, 1.85271786E-02,
     &   1.82851792E-02, 1.79648344E-02, 1.75527244E-02, 1.71547630E-02,
     &   1.66041095E-02, 1.60326019E-02, 1.53388640E-02, 1.48309302E-02,
     &   1.41159288E-02, 1.33819142E-02, 1.27499885E-02, 1.23713954E-02,
     &   1.16440638E-02, 1.13206335E-02, 1.05068758E-02, 9.81218446E-03,
     &   8.92201808E-03, 8.12792416E-03, 7.11911117E-03, 6.22056319E-03,
     &   5.24831861E-03, 3.94947319E-03, 3.26560329E-03, 2.78106173E-03,
     &   1.74393503E-03, 1.20065782E-03, 6.32492590E-04, 2.90289242E-06,
     &  -7.05597306E-04,-1.41551036E-03,-2.15883588E-03,-3.77594384E-03/
  
         DATA ((DGS (I,J), I= 201, 300), J=1,1) /
     &  -5.58663976E-03,-6.66104274E-03,-7.07871593E-03,-7.48068962E-03,
     &  -7.91287590E-03,-8.35780568E-03,-8.77152998E-03,-9.31768076E-03,
     &  -9.86207060E-03,-1.03500870E-02,-1.08983098E-02,-1.14728531E-02,
     &  -1.20714138E-02,-1.26793747E-02,-1.33366787E-02,-1.40113459E-02,
     &  -1.47335419E-02,-1.55233814E-02,-1.62685076E-02,-1.70557144E-02,
     &  -1.79471775E-02,-1.88659864E-02,-1.98454508E-02,-2.08961116E-02,
     &  -2.20152212E-02,-2.32107918E-02,-2.45069278E-02,-2.59224480E-02,
     &  -2.74643634E-02,-2.91925772E-02,-3.00526304E-02,-3.12340412E-02,
     &  -3.22199732E-02,-3.34897902E-02,-3.65173786E-02,-3.74663054E-02,
     &  -3.96922981E-02,-4.21150410E-02,-4.48977749E-02,-4.74911555E-02,
     &  -5.04948938E-02,-5.37741380E-02,-5.67634210E-02,-6.50745058E-02,
     &  -6.57689304E-02,-7.06427619E-02,-7.61924602E-02,-8.24329544E-02,
     &  -8.95553695E-02,-9.76972252E-02,-1.07082940E-01,-1.17937628E-01,
     &  -1.30483866E-01,-1.42614173E-01,-1.49217005E-01,-1.53700654E-01,
     &  -1.58275334E-01,-1.62902725E-01,-1.61126279E-01,-1.72102641E-01,
     &  -1.76489551E-01,-1.80454213E-01,-1.83946120E-01,-1.86650526E-01,
     &  -1.88366007E-01,-1.88562339E-01,-1.85172700E-01,-1.79338266E-01,
     &  -1.75246330E-01,-1.64104616E-01,-1.48546077E-01,-1.28090812E-01,
     &  -1.02639056E-01,-7.25023446E-02,-3.85804834E-02,-2.30330422E-03,
     &   3.44568383E-02, 6.98942786E-02, 1.02266630E-01, 1.30359815E-01,
     &   1.53593356E-01, 1.72080143E-01, 1.85337897E-01, 1.94690147E-01,
     &   2.00573532E-01, 2.03582690E-01, 2.04361198E-01, 2.03455587E-01,
     &   2.01245105E-01, 1.98138390E-01, 1.92529536E-01, 1.86835372E-01,
     &   1.82959733E-01, 1.80952009E-01, 1.76649337E-01, 1.72025845E-01,
     &   1.67487742E-01, 1.63039348E-01, 1.58721395E-01, 1.54519627E-01/
  
         DATA ((DGS (I,J), I= 301, 400), J=1,1) /
     &   1.54034265E-01, 1.46567218E-01, 1.42813516E-01, 1.39147215E-01,
     &   1.27646133E-01, 1.17761783E-01, 1.09156993E-01, 1.01699766E-01,
     &   9.52037665E-02, 8.82104109E-02, 8.44158984E-02, 7.99483961E-02,
     &   7.59507506E-02, 7.23783829E-02, 6.91122846E-02, 6.62049559E-02,
     &   6.35731477E-02, 6.10945068E-02, 5.88801987E-02, 5.68319805E-02,
     &   5.50142166E-02, 5.32968096E-02, 5.32808590E-02, 5.02124846E-02,
     &   4.88178779E-02, 4.80787017E-02, 4.88553611E-02, 4.81077122E-02,
     &   4.66119748E-02, 4.55658323E-02, 4.45910649E-02, 4.37216261E-02,
     &   4.28411841E-02, 4.20285134E-02, 4.12597829E-02, 4.05284752E-02,
     &   3.98290270E-02, 3.91687054E-02, 3.85279441E-02, 3.79093433E-02,
     &   3.73477327E-02, 3.67735561E-02, 3.62523493E-02, 3.57252452E-02,
     &   3.51962466E-02, 3.47527579E-02, 3.42887969E-02, 3.38007122E-02,
     &   3.34110381E-02, 3.29963303E-02, 3.25755667E-02, 3.21858899E-02,
     &   3.18252857E-02, 3.13967504E-02, 3.10545453E-02, 3.06993083E-02,
     &   2.97175811E-02, 2.76255609E-02, 2.43646977E-02, 2.20326070E-02,
     &   2.01919730E-02, 1.87350571E-02, 1.74720365E-02, 1.63766207E-02,
     &   1.54901483E-02, 1.53896640E-02, 1.43715770E-02, 1.36945066E-02,
     &   1.35020984E-02, 1.29771383E-02, 1.24812003E-02, 1.24353941E-02,
     &   1.20043628E-02, 1.15543194E-02, 1.13358088E-02, 1.11393816E-02,
     &   1.07512086E-02, 1.04445787E-02, 1.01570657E-02, 9.92638860E-03,
     &   9.76524714E-03, 9.67750982E-03, 9.48054464E-03, 9.27743290E-03,
     &   9.26878690E-03, 9.11089510E-03, 8.95220083E-03, 8.88174089E-03,
     &   8.81228957E-03, 8.68684780E-03, 8.55700848E-03, 8.42608945E-03,
     &   8.38160764E-03, 8.29674145E-03, 8.20422446E-03, 8.06804246E-03,
     &   7.88927483E-03, 7.73464024E-03, 7.72368190E-03, 7.62559542E-03/
  
         DATA ((DGS (I,J), I= 401, 500), J=1,1) /
     &   7.48551807E-03, 7.28668552E-03, 7.09818684E-03, 6.95386354E-03,
     &   6.91346467E-03, 6.81407196E-03, 6.84150093E-03, 6.86374655E-03,
     &   6.89917402E-03, 6.97749436E-03, 6.99817301E-03, 6.95838277E-03,
     &   6.94820614E-03, 6.81473926E-03, 6.79681080E-03, 6.70943458E-03,
     &   6.63628691E-03, 6.38545988E-03, 6.34804047E-03, 6.12738876E-03,
     &   6.10984444E-03, 6.09471060E-03, 5.93101344E-03, 5.72878100E-03,
     &   5.67912693E-03, 5.33606327E-03, 5.30439753E-03, 5.14755995E-03,
     &   5.11713200E-03, 4.94831685E-03, 4.88099396E-03, 4.75828609E-03,
     &   4.75297245E-03, 4.81539336E-03, 4.99062529E-03, 5.14089952E-03,
     &   5.17209532E-03, 5.65666347E-03, 5.72927375E-03, 6.07221336E-03,
     &   6.22290339E-03, 6.27447370E-03, 6.30519270E-03, 6.31986393E-03,
     &   6.45927662E-03, 6.48676571E-03, 6.59851578E-03, 6.73886034E-03,
     &   6.81683828E-03, 7.09418594E-03, 7.41913775E-03, 7.49304352E-03,
     &   7.53136178E-03, 7.78418042E-03, 7.92115318E-03, 8.06674082E-03,
     &   8.73508443E-03, 8.82063492E-03, 9.03690731E-03, 9.12640004E-03,
     &   9.14382422E-03, 9.13515729E-03, 9.11759550E-03, 9.09675259E-03,
     &   9.08731229E-03, 9.04089540E-03, 8.97819114E-03, 8.99470706E-03,
     &   9.09932175E-03, 9.22915452E-03, 9.24390307E-03, 9.35700489E-03,
     &   9.38906583E-03, 9.39896189E-03, 9.40127931E-03, 9.38058785E-03,
     &   9.37552624E-03, 9.35669645E-03, 9.28751421E-03, 9.08474766E-03,
     &   9.04240769E-03, 8.65187701E-03, 8.45609614E-03, 8.31937330E-03,
     &   7.94920945E-03, 7.57500437E-03, 7.48092272E-03, 7.43673744E-03,
     &   7.39833288E-03, 7.38899259E-03, 7.36480667E-03, 7.35913808E-03,
     &   7.33750350E-03, 7.31157355E-03, 7.27159635E-03, 7.25009866E-03,
     &   6.81892987E-03, 6.38934098E-03, 6.08389627E-03, 6.02835499E-03/
  
         DATA ((DGS (I,J), I= 501, 600), J=1,1) /
     &   5.81863894E-03, 6.51151703E-03, 8.15471126E-03, 8.68056525E-03,
     &   8.94155393E-03, 9.12713053E-03, 9.06334109E-03, 8.82253766E-03,
     &   8.53234630E-03, 8.25064433E-03, 7.91473207E-03, 7.46602629E-03,
     &   6.85471184E-03, 6.02095353E-03, 4.81627035E-03, 2.98238234E-03,
     &   2.49536268E-03, 1.96040627E-03, 1.35448204E-03, 6.72214179E-04,
     &  -9.34682113E-05,-9.79116803E-04,-2.00286708E-03,-2.22701918E-03,
     &  -2.45822444E-03,-2.69755223E-03,-2.94421028E-03,-3.19950667E-03,
     &  -3.46361200E-03,-3.73715068E-03,-4.01998856E-03,-4.31339654E-03,
     &  -4.61769014E-03,-6.13243659E-03,-7.31227777E-03,-7.96085961E-03,
     &  -8.41818626E-03,-8.89701802E-03,-9.39879873E-03,-9.92532235E-03,
     &  -1.04784051E-02,-1.10601222E-02,-1.13623926E-02,-1.16726794E-02,
     &  -1.19913067E-02,-1.23185161E-02,-1.26552553E-02,-1.30010585E-02,
     &  -1.33564181E-02,-1.37222809E-02,-1.40988454E-02,-1.44865892E-02,
     &  -1.48860187E-02,-1.52976723E-02,-1.57221226E-02,-1.61599958E-02,
     &  -1.66120225E-02,-1.70786298E-02,-1.75614621E-02,-1.80597592E-02,
     &  -1.85754659E-02,-1.91091848E-02,-1.96618824E-02,-2.02345935E-02,
     &  -2.08284299E-02,-2.14445871E-02,-2.20843534E-02,-2.27493957E-02,
     &  -2.34403508E-02,-2.41597033E-02,-2.49089748E-02,-2.56901217E-02,
     &  -2.65051713E-02,-2.73563463E-02,-2.82461076E-02,-2.91771581E-02,
     &  -3.01526568E-02,-3.11752448E-02,-3.22366570E-02,-3.33654228E-02,
     &  -3.45535690E-02,-3.58059255E-02,-3.64578157E-02,-3.71278006E-02,
     &  -3.78166677E-02,-3.85252804E-02,-3.92544225E-02,-4.00049936E-02,
     &  -4.07780360E-02,-4.15740801E-02,-4.23952785E-02,-4.32418772E-02,
     &  -4.41149924E-02,-4.50168982E-02,-4.59481299E-02,-4.69104212E-02,
     &  -4.79053569E-02,-4.89346230E-02,-5.00000312E-02,-5.11035233E-02/
  
         DATA ((DGS (I,J), I= 601, 700), J=1,1) /
     &  -5.22471762E-02,-5.34332342E-02,-5.46637154E-02,-5.59420669E-02,
     &  -5.72706805E-02,-5.86524796E-02,-6.00907658E-02,-6.15891403E-02,
     &  -6.31513984E-02,-6.47817672E-02,-6.64846649E-02,-6.82654481E-02,
     &  -7.01290166E-02,-7.20815676E-02,-7.41296748E-02,-7.62801797E-02,
     &  -7.85416229E-02,-8.09225730E-02,-8.34326955E-02,-8.60827381E-02,
     &  -9.00513439E-02,-9.18523885E-02,-9.50005686E-02,-9.83463953E-02,
     &  -1.01909046E-01,-1.05710331E-01,-1.09775125E-01,-1.14131881E-01,
     &  -1.18813199E-01,-1.23856692E-01,-1.29306159E-01,-1.35212682E-01,
     &  -1.41636307E-01,-1.46763992E-01,-1.62737102E-01,-1.82296407E-01,
     &  -2.06802884E-01,-2.38405818E-01,-2.80710156E-01,-3.40260449E-01,
     &  -4.30302174E-01,-5.82310538E-01,-8.93766128E-01,-1.89092814E+00,
     &  -2.00014545E+00,-2.12262472E+00,-2.26092752E+00,-2.41831819E+00,
     &  -2.59902003E+00,-2.80859332E+00,-3.05450562E+00,-3.34701804E+00,
     &  -3.70060995E+00,-4.13635905E+00,-4.68610120E+00,-5.40007524E+00,
     &  -6.36182557E+00,-6.47649080E+00,-9.04400121E+00,-1.09153814E+01,
     &  -1.24189272E+01,-1.37265512E+01,-1.47341799E+01,-1.56145923E+01,
     &  -1.63201815E+01,-1.70231047E+01,-1.75059712E+01,-1.79530657E+01,
     &  -1.82685516E+01,-1.85286342E+01,-1.86747880E+01,-1.87838819E+01,
     &  -1.87931586E+01,-1.87382540E+01,-1.85859945E+01,-1.84214380E+01,
     &  -1.80655000E+01,-1.77465825E+01,-1.73551145E+01,-1.68849377E+01,
     &  -1.63301458E+01,-1.56853063E+01,-1.49457225E+01,-1.41077235E+01,
     &  -1.31689796E+01,-1.21288163E+01,-1.09885166E+01,-9.09861954E+00,
     &  -7.72857398E+00,-5.53241211E+00,-3.20546592E+00, 3.22418831E+00,
     &   9.11761783E+00, 1.10076711E+01, 1.26808730E+01, 1.36704808E+01,
     &   1.49653632E+01, 1.57050748E+01, 1.63500411E+01, 1.69049576E+01/
  
         DATA ((DGS (I,J), I= 701, 800), J=1,1) /
     &   1.73752566E+01, 1.77668435E+01, 1.80858754E+01, 1.83385759E+01,
     &   1.85310853E+01, 1.86693504E+01, 1.87590417E+01, 1.88140808E+01,
     &   1.88048875E+01, 1.87332624E+01, 1.86038550E+01, 1.84911796E+01,
     &   1.82155683E+01, 1.79745660E+01, 1.76205356E+01, 1.72409474E+01,
     &   1.67457061E+01, 1.62408349E+01, 1.55368164E+01, 1.48518628E+01,
     &   1.40150148E+01, 1.30711856E+01, 1.18571957E+01, 1.04655221E+01,
     &   8.72780323E+00, 7.19379248E+00, 6.00221043E+00, 5.14240355E+00,
     &   4.49500806E+00, 3.99091719E+00, 3.58773864E+00, 3.25815747E+00,
     &   2.98383349E+00, 2.75201835E+00, 2.55358626E+00, 2.38183901E+00,
     &   2.23175139E+00, 2.09948107E+00, 1.98204177E+00, 1.87707748E+00,
     &   1.78270501E+00, 1.69740127E+00, 1.61992135E+00, 8.54403496E-01,
     &   5.82434189E-01, 4.43110730E-01, 3.58421900E-01, 3.01499700E-01,
     &   2.60611611E-01, 2.29818928E-01, 2.05793239E-01, 1.86524410E-01,
     &   1.70726731E-01, 1.68855589E-01, 1.55807537E-01, 1.44753010E-01,
     &   1.35267441E-01, 1.27038862E-01, 1.19832880E-01, 1.13469876E-01,
     &   1.07810122E-01, 1.02743216E-01, 9.81798824E-02, 9.40491970E-02,
     &   9.02923688E-02, 8.68606054E-02, 8.37134487E-02, 8.08168318E-02,
     &   7.81420447E-02, 7.56643939E-02, 7.33631177E-02, 7.12197302E-02,
     &   6.92185442E-02, 6.73458088E-02, 6.55897067E-02, 6.39396060E-02,
     &   6.23860915E-02, 6.09209070E-02, 5.95367303E-02, 5.82411796E-02,
     &   5.70001404E-02, 5.58225492E-02, 5.47036020E-02, 5.36389648E-02,
     &   5.26247882E-02, 5.16575398E-02, 5.07340285E-02, 4.98514111E-02,
     &   4.90069817E-02, 4.81984675E-02, 4.74234874E-02, 4.66799890E-02,
     &   4.59660880E-02, 4.52892946E-02, 4.46294996E-02, 4.39945739E-02,
     &   4.33830085E-02, 4.27936791E-02, 4.22253920E-02, 4.16769799E-02/
  
         DATA ((DGS (I,J), I= 801, 900), J=1,1) /
     &   4.11384975E-02, 4.06269176E-02, 4.01323319E-02, 3.96539370E-02,
     &   3.91909519E-02, 3.87427099E-02, 3.83085895E-02, 3.78879189E-02,
     &   3.74800512E-02, 3.70844219E-02, 3.67005987E-02, 3.63279340E-02,
     &   3.59660414E-02, 3.56144913E-02, 3.52728988E-02, 3.49409347E-02,
     &   3.46182685E-02, 3.43044772E-02, 3.39966932E-02, 3.36997694E-02,
     &   3.34108658E-02, 3.31323492E-02, 3.28587947E-02, 3.25926060E-02,
     &   3.23336573E-02, 3.20818497E-02, 3.18370121E-02, 3.15990413E-02,
     &   3.13678936E-02, 3.11435745E-02, 3.09261896E-02, 3.07159030E-02,
     &   3.05215746E-02, 3.03265677E-02, 3.01400300E-02, 2.99629280E-02,
     &   2.94091333E-02, 2.92100865E-02, 2.90151297E-02, 2.88241448E-02,
     &   2.86370237E-02, 2.84536868E-02, 2.82744174E-02, 2.80981724E-02,
     &   2.79262265E-02, 2.77773262E-02, 2.75893374E-02, 2.74247795E-02,
     &   2.72638028E-02, 2.71052615E-02, 2.69500423E-02, 2.67976563E-02,
     &   2.66384762E-02, 2.64914655E-02, 2.63470248E-02, 2.62050821E-02,
     &   2.19568205E-02, 1.90211275E-02, 1.66190048E-02, 1.48437438E-02,
     &   1.33915389E-02, 1.26507013E-02, 1.17507890E-02, 1.06258630E-02,
     &   9.58889349E-03, 8.22188458E-03, 7.47243499E-03, 6.27581381E-03,
     &   6.19418934E-03, 5.74369916E-03, 4.73055035E-03, 3.64236443E-03,
     &   2.41516990E-03, 9.89270465E-04,-7.09913763E-04,-2.78797723E-03,
     &  -5.40598677E-03,-6.65814567E-03,-8.06048330E-03,-9.64298771E-03,
     &  -1.14441827E-02,-1.35144040E-02,-1.59205792E-02,-1.72769461E-02,
     &  -1.87539823E-02,-2.03688419E-02,-2.21420913E-02,-2.40986027E-02,
     &  -2.62687070E-02,-2.86899441E-02,-3.14090599E-02,-3.44852684E-02,
     &  -3.79944485E-02,-4.20357902E-02,-4.67412170E-02,-5.20491874E-02,
     &  -5.55219545E-02,-5.93737614E-02,-6.36705033E-02,-6.84942874E-02/
  
         DATA ((DGS (I,J), I= 901,1000), J=1,1) /
     &  -7.39487444E-02,-8.01665726E-02,-8.73204939E-02,-9.56395660E-02,
     &  -1.05434175E-01,-1.17135615E-01,-1.31361270E-01,-1.49026961E-01,
     &  -1.71551782E-01,-2.01258003E-01,-2.42223219E-01,-3.02316390E-01,
     &  -3.98894116E-01,-5.78936770E-01,-8.62093400E-01,-1.02325127E+00,
     &  -1.19903234E+00,-1.63153256E+00,-1.78735143E+00,-1.91595201E+00,
     &  -2.02516366E+00,-2.11712606E+00,-2.19257650E+00,-2.25754329E+00,
     &  -2.31073857E+00,-2.34881049E+00,-2.38115430E+00,-2.40405083E+00,
     &  -2.41763140E+00,-2.42253646E+00,-2.41905373E+00,-2.40953664E+00,
     &  -2.39022172E+00,-2.36494709E+00,-2.33087819E+00,-2.28704421E+00,
     &  -2.24095241E+00,-2.17637462E+00,-2.11108506E+00,-2.03604403E+00,
     &  -1.95076991E+00,-1.83783213E+00,-1.72919384E+00,-1.58848848E+00,
     &  -1.45600613E+00,-1.26285321E+00,-1.05205669E+00,-7.37218165E-01,
     &  -4.62782431E-01,-1.46670188E-01, 1.34479414E-02, 1.73567996E-01,
     &   3.32654913E-01, 7.64157769E-01, 1.07904262E+00, 1.28988089E+00,
     &   1.48308088E+00, 1.61560118E+00, 1.75635294E+00, 1.86503218E+00,
     &   1.97801834E+00, 2.06333408E+00, 2.13841646E+00, 2.20374675E+00,
     &   2.26837105E+00, 2.31450153E+00, 2.35837914E+00, 2.39248983E+00,
     &   2.41780437E+00, 2.43716235E+00, 2.44671507E+00, 2.45024069E+00,
     &   2.44537537E+00, 2.43183546E+00, 2.40897956E+00, 2.37667579E+00,
     &   2.33863969E+00, 2.28548415E+00, 2.22055624E+00, 2.14514292E+00,
     &   2.05321807E+00, 1.94404340E+00, 1.81547896E+00, 1.65969605E+00,
     &   1.47083753E+00, 1.57337058E+00, 1.22726608E+00, 8.90361307E-01,
     &   7.59393027E-01, 4.96559399E-01, 3.69975313E-01, 2.95813561E-01,
     &   2.47157556E-01, 2.12796602E-01, 1.87242813E-01, 1.67496522E-01,
     &   1.51780234E-01, 1.38974305E-01, 1.28338487E-01, 1.19363832E-01/
  
         DATA ((DGS (I,J), I=1001,1100), J=1,1) /
     &   1.11689005E-01, 1.05050336E-01, 9.92509547E-02, 9.41409052E-02,
     &   8.96039115E-02, 8.55485915E-02, 8.19017370E-02, 7.61331744E-02,
     &   6.89245537E-02, 6.50613910E-02, 5.87261422E-02, 5.37432722E-02,
     &   4.88033414E-02, 4.17549719E-02, 3.39972001E-02, 2.91136222E-02,
     &   2.69207629E-02, 2.56071004E-02, 2.47051663E-02, 2.40374751E-02,
     &   2.35147733E-02, 2.30915256E-02, 2.27398024E-02, 2.24419748E-02,
     &   2.21857725E-02, 2.19636155E-02, 2.17689557E-02, 2.15973964E-02,
     &   2.14457999E-02, 2.13110705E-02, 2.11915747E-02, 2.10857822E-02,
     &   2.09917137E-02, 2.09093826E-02, 2.08367599E-02, 2.07746658E-02,
     &   2.07211175E-02, 2.06771150E-02, 2.06427737E-02, 2.06160678E-02,
     &   2.06001334E-02, 2.05937163E-02, 2.05987352E-02, 2.06166139E-02,
     &   2.06500380E-02, 2.07038428E-02, 2.07878043E-02, 2.09265682E-02,
     &   2.13851911E-02, 2.19996572E-02, 2.22932513E-02, 2.25317536E-02,
     &   2.27400528E-02, 2.29280788E-02, 2.30998396E-02, 2.32583198E-02,
     &   2.34051812E-02, 2.35414559E-02, 2.36680596E-02, 2.37832698E-02,
     &   2.38896926E-02, 2.39865537E-02, 2.40753630E-02, 2.41778708E-02,
     &   2.42039672E-02, 2.42425138E-02, 2.42712327E-02, 2.42870650E-02,
     &   2.42882853E-02, 2.42733144E-02, 2.42396995E-02, 2.41877167E-02,
     &   2.41131100E-02, 2.40137498E-02, 2.38867571E-02, 2.37285186E-02,
     &   2.35342240E-02, 2.32967883E-02, 2.30074326E-02, 2.26586724E-02,
     &   2.22267256E-02, 2.15981435E-02, 2.06635149E-02, 2.03869234E-02,
     &   1.96295090E-02, 1.84595445E-02, 1.83347373E-02, 1.74983131E-02,
     &   1.71691871E-02, 1.68463711E-02, 1.65862302E-02, 1.62849642E-02,
     &   1.58285436E-02, 1.56390377E-02, 1.56554072E-02, 1.53321246E-02,
     &   1.53378955E-02, 1.57230346E-02, 1.55327180E-02, 1.57561966E-02/
  
         DATA ((DGS (I,J), I=1101,1200), J=1,1) /
     &   1.55139570E-02, 1.51419567E-02, 1.55117819E-02, 1.50334251E-02,
     &   1.40914921E-02, 1.38266326E-02, 1.41385897E-02, 1.41578676E-02,
     &   1.40935039E-02, 1.38757489E-02, 1.32320770E-02, 1.29292443E-02,
     &   1.22227454E-02, 1.16447477E-02, 1.13841672E-02, 1.18119542E-02,
     &   1.25365199E-02, 1.40588092E-02, 1.46022521E-02, 1.52756310E-02,
     &   1.57013971E-02, 1.61717582E-02, 1.63010516E-02, 1.62815380E-02,
     &   1.69346992E-02, 1.75357940E-02, 1.73948773E-02, 1.73275227E-02,
     &   1.74232619E-02, 1.74992421E-02, 1.75596675E-02, 1.75334409E-02,
     &   1.75697902E-02, 1.75579133E-02, 1.73728043E-02, 1.72893379E-02,
     &   1.73276513E-02, 1.74510065E-02, 1.76081194E-02, 1.80101828E-02,
     &   1.81968093E-02, 1.82079131E-02, 1.82007671E-02, 1.80528563E-02,
     &   1.76590234E-02, 1.76367730E-02, 1.80041670E-02, 1.84315665E-02,
     &   1.88141140E-02, 1.88382906E-02, 1.89954330E-02, 1.92344295E-02,
     &   1.94778922E-02, 1.99102220E-02, 2.03627525E-02, 2.05529830E-02,
     &   2.07418082E-02, 2.10501650E-02, 2.12503430E-02, 2.10815592E-02,
     &   2.07219508E-02, 2.06014998E-02, 2.08130155E-02, 2.07377397E-02,
     &   2.01183262E-02, 1.99123443E-02, 2.00418900E-02, 2.00418961E-02,
     &   1.93002218E-02, 1.85553617E-02, 1.83168512E-02, 1.82054023E-02,
     &   1.81142810E-02, 1.80319738E-02, 1.75972027E-02, 1.73856770E-02,
     &   1.74593595E-02, 1.74346652E-02, 1.71217142E-02, 1.65079763E-02,
     &   1.64263041E-02, 1.62605246E-02, 1.63762558E-02, 1.64237431E-02,
     &   1.65217637E-02, 1.66142276E-02, 1.66457414E-02, 1.66703077E-02,
     &   1.65604981E-02, 1.63909049E-02, 1.62618261E-02, 1.68511715E-02,
     &   1.73291324E-02, 1.73097181E-02, 1.73599418E-02, 1.73765230E-02,
     &   1.73369140E-02, 1.78306712E-02, 1.85249558E-02, 1.87149572E-02/
  
         DATA ((DGS (I,J), I=1201,1300), J=1,1) /
     &   1.86990458E-02, 1.87756503E-02, 1.88319138E-02, 1.89307158E-02,
     &   1.90334309E-02, 1.89819620E-02, 1.89104003E-02, 1.88732099E-02,
     &   1.84725164E-02, 1.83870175E-02, 1.85429212E-02, 1.85968034E-02,
     &   1.84142026E-02, 1.83042000E-02, 1.82923585E-02, 1.83087225E-02,
     &   1.83295600E-02, 1.87189186E-02, 1.91340857E-02, 1.92111035E-02,
     &   1.91910648E-02, 1.91789514E-02, 1.92521345E-02, 1.92765281E-02,
     &   1.95681146E-02, 1.99722903E-02, 2.01347490E-02, 2.02825563E-02,
     &   2.05484666E-02, 2.07872694E-02, 2.08991988E-02, 2.10070462E-02,
     &   2.11112909E-02, 2.12123112E-02, 2.13104114E-02, 2.14053445E-02,
     &   2.14982831E-02, 2.15889279E-02, 2.16774236E-02, 2.17638934E-02,
     &   2.18484424E-02, 2.19311615E-02, 2.20121179E-02, 2.20914000E-02,
     &   2.21690559E-02, 2.22451365E-02, 2.23196851E-02, 2.23927396E-02,
     &   2.24643322E-02, 2.25344900E-02, 2.26032355E-02, 2.26706021E-02,
     &   2.27365741E-02, 2.28011774E-02, 2.28644189E-02, 2.29263023E-02,
     &   2.29868275E-02, 2.30459914E-02, 2.31037870E-02, 2.31602040E-02,
     &   2.32152284E-02, 2.32688424E-02, 2.33210243E-02, 2.33717480E-02,
     &   2.34112567E-02, 2.34686937E-02, 2.35593731E-02, 2.36433852E-02,
     &   2.37202127E-02, 2.37891909E-02, 2.38494663E-02, 2.38999323E-02,
     &   2.39391401E-02, 2.39651628E-02, 2.39753837E-02, 2.39661569E-02,
     &   2.39319084E-02, 2.38656524E-02, 2.37545610E-02, 2.35778401E-02,
     &   2.35553210E-02, 2.32972261E-02, 2.28329855E-02, 2.19845199E-02,
     &   2.06111897E-02, 2.00521407E-02, 1.77635154E-02, 1.35733083E-02,
     &   1.16508660E-02, 8.95834668E-03, 7.16309807E-03, 4.91928014E-03,
     &   2.67618386E-03,-1.26052198E-04,-1.80626753E-03,-3.72529232E-03,
     &  -5.93774361E-03,-8.51623701E-03,-1.15594608E-02,-1.52050232E-02/
  
         DATA ((DGS (I,J), I=1301,1400), J=1,1) /
     &  -1.73122900E-02,-1.96507254E-02,-2.22604648E-02,-2.51914961E-02,
     &  -2.85068801E-02,-3.22873213E-02,-3.66378013E-02,-4.16974480E-02,
     &  -4.76546449E-02,-5.01356420E-02,-5.16922456E-02,-5.33142564E-02,
     &  -5.50058793E-02,-5.67716873E-02,-5.86166628E-02,-6.05462445E-02,
     &  -6.25663807E-02,-6.46835908E-02,-6.69050349E-02,-6.92385951E-02,
     &  -7.16929683E-02,-7.42777750E-02,-7.70036843E-02,-7.98825617E-02,
     &  -8.29276408E-02,-8.61537270E-02,-8.95774376E-02,-9.32174879E-02,
     &  -9.70950329E-02,-1.01234078E-01,-1.05661978E-01,-1.10410037E-01,
     &  -1.15514253E-01,-1.21016233E-01,-1.26964322E-01,-1.33415032E-01,
     &  -1.40434840E-01,-1.48102485E-01,-1.56511931E-01,-1.65776237E-01,
     &  -1.76032664E-01,-1.87449519E-01,-2.00235454E-01,-2.14652329E-01,
     &  -2.31033325E-01,-2.49808998E-01,-2.71545649E-01,-2.97003397E-01,
     &  -3.27226840E-01,-3.63691858E-01,-4.08553751E-01,-4.65088948E-01,
     &  -5.38532653E-01,-6.37799064E-01,-7.79399146E-01,-9.97712575E-01,
     &  -1.37805604E+00,-2.20570616E+00,-2.71885987E+00,-5.20203062E+00,
     &  -7.24839869E+00,-8.73170313E+00,-9.87941939E+00,-1.08224086E+01,
     &  -1.16476277E+01,-1.24133161E+01,-1.29463588E+01,-1.34889552E+01,
     &  -1.40225939E+01,-1.42798862E+01,-1.46404762E+01,-1.48565376E+01,
     &  -1.51247268E+01,-1.51946183E+01,-1.52979968E+01,-1.53409587E+01,
     &  -1.53085797E+01,-1.52591742E+01,-1.51845857E+01,-1.49483777E+01,
     &  -1.47827350E+01,-1.45791521E+01,-1.40546183E+01,-1.37289711E+01,
     &  -1.33567930E+01,-1.29309668E+01,-1.19324881E+01,-1.13460945E+01,
     &  -1.07103911E+01,-9.26538412E+00,-8.46550231E+00,-6.70524162E+00,
     &  -4.76735967E+00, 5.37638246E-01, 4.75551692E+00, 6.69837131E+00,
     &   8.45602045E+00, 1.00178098E+01, 1.07199444E+01, 1.13591592E+01/
  
         DATA ((DGS (I,J), I=1401,1500), J=1,1) /
     &   1.19432120E+01, 1.29542671E+01, 1.33791039E+01, 1.37585269E+01,
     &   1.40870531E+01, 1.46168598E+01, 1.48208735E+01, 1.49906508E+01,
     &   1.52297871E+01, 1.53070059E+01, 1.53858786E+01, 1.53929789E+01,
     &   1.53521653E+01, 1.52511665E+01, 1.51016584E+01, 1.49147896E+01,
     &   1.46995078E+01, 1.43397055E+01, 1.40841104E+01, 1.35494103E+01,
     &   1.30082222E+01, 1.24735636E+01, 1.17073799E+01, 1.08814662E+01,
     &   9.93758226E+00, 8.78873468E+00, 7.30402463E+00, 5.22583189E+00,
     &   2.86397503E+00, 1.64922049E+00, 1.16167696E+00, 8.99185128E-01,
     &   7.35208637E-01, 6.23068724E-01, 5.41546943E-01, 4.79612749E-01,
     &   4.30965322E-01, 3.91744143E-01, 3.59452081E-01, 3.32402393E-01,
     &   3.09414676E-01, 2.89638149E-01, 2.72444110E-01, 2.57357919E-01,
     &   2.44014531E-01, 2.32128551E-01, 2.21473786E-01, 2.11868450E-01,
     &   2.03164898E-01, 1.95241939E-01, 1.87999172E-01, 1.81352705E-01,
     &   1.75231901E-01, 1.69576857E-01, 1.64336440E-01, 1.59466741E-01,
     &   1.54929840E-01, 1.50692819E-01, 1.46726966E-01, 1.43007122E-01,
     &   1.39511147E-01, 1.36219485E-01, 1.33114791E-01, 1.30181654E-01,
     &   1.27406275E-01, 1.24776295E-01, 1.22280648E-01, 1.19909352E-01,
     &   1.17653388E-01, 1.15504591E-01, 1.13455552E-01, 1.11499527E-01,
     &   1.09630372E-01, 1.07842470E-01, 1.06130682E-01, 1.04490293E-01,
     &   1.02916972E-01, 1.01406731E-01, 9.00322769E-02, 8.30823630E-02,
     &   7.64495430E-02, 6.91188904E-02, 6.24479253E-02, 5.65760412E-02,
     &   5.51331064E-02, 4.97598656E-02, 4.16956622E-02, 3.65400206E-02,
     &   3.62951459E-02, 3.57766742E-02, 3.52030252E-02, 3.41113020E-02,
     &   3.31717944E-02, 3.01666194E-02, 2.74706281E-02, 2.58559145E-02,
     &   2.37267850E-02, 2.12605243E-02, 1.84445539E-02, 1.48399575E-02/
  
         DATA ((DGS (I,J), I=1501,1600), J=1,1) /
     &   9.91094786E-03,-2.38869961E-03,-4.71845454E-03,-7.46134235E-03,
     &  -8.25606325E-03,-1.00673391E-02,-1.20796138E-02,-1.43283521E-02,
     &  -1.68578846E-02,-1.97243648E-02,-2.29999874E-02,-2.67791628E-02,
     &  -3.11877704E-02,-3.63974626E-02,-4.26485511E-02,-5.02881477E-02,
     &  -5.98369119E-02,-7.21130017E-02,-8.84799655E-02,-1.11392054E-01,
     &  -1.45757306E-01,-2.03025804E-01,-3.17533759E-01,-4.71134513E-01,
     &  -4.96916032E-01,-5.25515942E-01,-5.57422821E-01,-5.93245021E-01,
     &  -6.33749730E-01,-6.79918388E-01,-7.33027002E-01,-7.94765483E-01,
     &  -8.67420009E-01,-9.54160943E-01,-1.05951501E+00,-1.19017526E+00,
     &  -1.35646789E+00,-1.57519047E+00,-1.87558131E+00,-2.31330036E+00,
     &  -3.00824828E+00,-4.26941222E+00,-7.12251194E+00,-8.12267537E+00,
     &  -8.90987989E+00,-9.78728798E+00,-1.05236440E+01,-1.10546890E+01,
     &  -1.15050774E+01,-1.17125987E+01,-1.17949908E+01,-1.16913616E+01,
     &  -1.13241573E+01,-1.09013769E+01,-1.08213762E+01,-1.07797855E+01,
     &  -1.06933657E+01,-1.06575726E+01,-1.06302630E+01,-1.06025523E+01,
     &  -1.03028664E+01,-9.77277621E+00,-9.06347099E+00,-8.31194945E+00,
     &  -7.34932668E+00,-6.25553235E+00,-5.16666575E+00,-4.52322936E+00,
     &  -3.85548356E+00,-3.16644721E+00,-2.17254976E+00,-1.44686290E+00,
     &  -7.12627421E-01,-2.69738985E-01,-1.21924656E-01, 2.59243783E-02,
     &   1.73773423E-01, 7.64476507E-01, 1.49871298E+00, 2.22440147E+00,
     &   5.46850216E+00, 6.64888759E+00, 8.54025649E+00, 9.26769648E+00,
     &   9.95114030E+00, 1.05098336E+01, 1.09138481E+01, 1.12631889E+01,
     &   1.14974489E+01, 1.16796229E+01, 1.17824457E+01, 1.18386409E+01,
     &   1.18448152E+01, 1.18104446E+01, 1.17486318E+01, 1.15443174E+01,
     &   1.14066114E+01, 1.12539358E+01, 1.11067323E+01, 1.07753538E+01/
  
         DATA ((DGS (I,J), I=1601,1700), J=1,1) /
     &   1.05939932E+01, 1.02994395E+01, 5.51010602E+00, 3.62658098E+00,
     &   2.69153603E+00, 2.13868688E+00, 1.77468667E+00, 1.51724432E+00,
     &   1.32567367E+00, 1.17761574E+00, 1.05978369E+00, 9.63792435E-01,
     &   8.84092018E-01, 8.16864039E-01, 7.59395852E-01, 7.09707645E-01,
     &   6.66320804E-01, 6.28108844E-01, 5.94198542E-01, 5.63902578E-01,
     &   5.36672592E-01, 3.69646421E-01, 2.55138404E-01, 1.97869797E-01,
     &   1.63504398E-01, 1.40592128E-01, 1.24224947E-01, 1.11948605E-01,
     &   1.02399555E-01, 9.47596368E-02, 8.85081920E-02, 8.32981079E-02,
     &   7.88890729E-02, 7.51094343E-02, 7.18333124E-02, 6.89662966E-02,
     &   6.64361903E-02, 6.41868405E-02, 6.21739155E-02, 6.03619500E-02,
     &   5.81914180E-02, 5.56580323E-02, 5.34925068E-02, 5.16199636E-02,
     &   4.99845534E-02, 4.85437718E-02, 4.33190716E-02, 4.00356105E-02,
     &   3.77753462E-02, 3.61195782E-02, 3.48485398E-02, 3.38263182E-02,
     &   3.30110473E-02, 3.23321371E-02, 2.64862152E-02, 2.48521858E-02,
     &   2.44428018E-02, 2.39702607E-02, 2.34094540E-02, 2.27154066E-02,
     &   2.22977878E-02, 2.18175956E-02, 2.05852447E-02, 1.87349449E-02,
     &   1.55248794E-02, 8.25511288E-03, 1.32469521E-03,-4.62734320E-04,
     &  -2.52387776E-03,-4.92711630E-03,-7.76574221E-03,-1.11704709E-02,
     &  -1.53298803E-02,-2.05270325E-02,-2.72067756E-02,-3.61101696E-02,
     &  -4.85714961E-02,-6.72594148E-02,-9.83993824E-02,-1.03814752E-01,
     &  -1.09721643E-01,-1.16191648E-01,-1.23308516E-01,-1.31173474E-01,
     &  -1.39913044E-01,-1.49680593E-01,-1.60667565E-01,-1.73120436E-01,
     &  -1.87351896E-01,-2.03770371E-01,-2.22926476E-01,-2.45564482E-01,
     &  -2.72725295E-01,-3.05922638E-01,-3.16295822E-01,-3.47415115E-01,
     &  -4.00748311E-01,-4.71850516E-01,-5.71358836E-01,-7.20529330E-01/
  
         DATA ((DGS (I,J), I=1701,1800), J=1,1) /
     &  -9.68798580E-01,-1.46374214E+00,-2.92662994E+00,-3.48430723E+00,
     &  -4.92524133E+00,-6.02104248E+00,-6.92393762E+00,-7.71199378E+00,
     &  -8.41115942E+00,-9.03837865E+00,-9.59864054E+00,-1.01179458E+01,
     &  -1.06083672E+01,-1.10565580E+01,-1.14507943E+01,-1.18154675E+01,
     &  -1.21442629E+01,-1.24322482E+01,-1.27058565E+01,-1.29299752E+01,
     &  -1.31049897E+01,-1.32535818E+01,-1.33679532E+01,-1.34388024E+01,
     &  -1.34566271E+01,-1.34265104E+01,-1.33395378E+01,-1.31858600E+01,
     &  -1.29548120E+01,-1.26950597E+01,-1.22927551E+01,-1.17809728E+01,
     &  -1.11493078E+01,-1.02494127E+01,-9.16572617E+00,-7.70067037E+00,
     &  -5.78087113E+00, 2.60137541E-02, 5.83291011E+00, 7.75271893E+00,
     &   9.21778468E+00, 1.03014805E+01, 1.12013852E+01, 1.18330584E+01,
     &   1.23448486E+01, 1.27471609E+01, 1.30069193E+01, 1.32379743E+01,
     &   1.33916587E+01, 1.34786375E+01, 1.35087599E+01, 1.34909405E+01,
     &   1.34200969E+01, 1.33057308E+01, 1.31571433E+01, 1.29821332E+01,
     &   1.27580189E+01, 1.24844150E+01, 1.21964337E+01, 1.18676421E+01,
     &   1.15029726E+01, 1.11087398E+01, 1.06605524E+01, 1.01701344E+01,
     &   9.65083224E+00, 9.09057329E+00, 8.46335694E+00, 7.76419408E+00,
     &   6.97614059E+00, 6.07324801E+00, 4.97744935E+00, 3.53651765E+00,
     &   2.97852675E+00, 1.51587368E+00, 1.02101111E+00, 7.72721608E-01,
     &   6.23558460E-01, 5.24063183E-01, 4.52960991E-01, 3.99622713E-01,
     &   3.58135334E-01, 3.24937996E-01, 2.97774494E-01, 2.75139186E-01,
     &   2.55983084E-01, 2.39562950E-01, 2.25333157E-01, 2.12880290E-01,
     &   1.50612137E-01, 1.19472208E-01, 1.00784338E-01, 8.83230702E-02,
     &   7.94197463E-02, 7.27400830E-02, 6.75430210E-02, 6.33837133E-02,
     &   5.99790971E-02, 5.71405817E-02, 5.47374905E-02, 5.26764926E-02/
  
         DATA ((DGS (I,J), I=1801,1900), J=1,1) /
     &   5.08892201E-02, 4.44515691E-02, 3.97205959E-02, 3.68743404E-02,
     &   3.49638917E-02, 3.35856323E-02, 3.25386281E-02, 3.17115181E-02,
     &   3.10376399E-02, 3.04745867E-02, 2.99939775E-02, 2.95761217E-02,
     &   2.92069533E-02, 2.88760731E-02, 2.85755901E-02, 2.82993666E-02,
     &   2.80425122E-02, 2.78010280E-02, 2.75715318E-02, 2.73509087E-02,
     &   2.71365650E-02, 2.69277836E-02, 2.68036316E-02, 2.38793147E-02,
     &   2.25339425E-02, 2.15618129E-02, 2.07917895E-02, 2.01578077E-02,
     &   1.96254743E-02, 1.91733991E-02, 1.87894685E-02, 1.84668059E-02,
     &   1.81958913E-02, 1.79719884E-02, 1.77933462E-02, 1.76570329E-02,
     &   1.75599386E-02, 1.74998880E-02, 1.74769791E-02, 1.74897413E-02,
     &   1.75374484E-02, 1.76215893E-02, 1.77403546E-02, 1.78913824E-02,
     &   1.80846708E-02, 1.83079344E-02, 1.85752862E-02, 1.88823092E-02,
     &   1.92370373E-02, 1.96415940E-02, 2.00974874E-02, 2.06054483E-02,
     &   2.12053053E-02, 2.18919209E-02, 2.26848873E-02, 2.36733308E-02,
     &   2.49798505E-02, 2.81731048E-02, 3.11916170E-02, 3.23304453E-02,
     &   3.31556049E-02, 3.37943407E-02, 3.43298738E-02, 3.47834297E-02,
     &   3.51560139E-02, 3.54802513E-02, 3.57585786E-02, 3.59937939E-02,
     &   3.61889256E-02, 3.63502431E-02, 3.64764663E-02, 3.65759568E-02,
     &   3.66430731E-02, 3.66830520E-02, 3.66946960E-02, 3.66781371E-02,
     &   3.66340414E-02, 3.65605971E-02, 3.64573124E-02, 3.63248257E-02,
     &   3.61605119E-02, 3.59612992E-02, 3.57245102E-02, 3.54510486E-02,
     &   3.51289270E-02, 3.47562322E-02, 3.43239724E-02, 3.38205210E-02,
     &   3.32255695E-02, 3.25069739E-02, 3.16046711E-02, 3.03728324E-02,
     &   2.80577183E-02, 2.79847589E-02, 2.74860639E-02, 2.71741133E-02,
     &   2.69499524E-02, 2.67762833E-02, 2.66357081E-02, 2.65186854E-02/
  
         DATA ((DGS (I,J), I=1901,2000), J=1,1) /
     &   2.64197496E-02, 2.63350253E-02, 2.62622631E-02, 2.61994896E-02,
     &   2.61456700E-02, 2.60998108E-02, 2.60611180E-02, 2.60290932E-02,
     &   2.60033757E-02, 2.59836444E-02, 2.59696508E-02, 2.59612989E-02,
     &   2.59584686E-02, 2.59611858E-02, 2.59694940E-02, 2.59835222E-02,
     &   2.60033577E-02, 2.60294770E-02, 2.60620797E-02, 2.61016673E-02,
     &   2.61490624E-02, 2.62053465E-02, 2.62712027E-02, 2.63494660E-02,
     &   2.64424663E-02, 2.65553117E-02, 2.66979768E-02, 2.68946641E-02,
     &   2.74006522E-02, 2.78507104E-02, 2.80311940E-02, 2.81641021E-02,
     &   2.82717061E-02, 2.83628078E-02, 2.84417530E-02, 2.85104287E-02,
     &   2.85710647E-02, 2.86254892E-02, 2.86735303E-02, 2.87157094E-02,
     &   2.87538489E-02, 2.87875223E-02, 2.88185746E-02, 2.88416145E-02,
     &   2.88612833E-02, 2.88779589E-02, 2.88913852E-02, 2.89013768E-02,
     &   2.89081098E-02, 2.89115431E-02, 2.89117078E-02, 2.89085859E-02,
     &   2.89021255E-02, 2.88923392E-02, 2.88790709E-02, 2.88622816E-02,
     &   2.88418030E-02, 2.88175279E-02, 2.87892604E-02, 2.87567979E-02,
     &   2.87198219E-02, 2.86782371E-02, 2.86315741E-02, 2.85797178E-02,
     &   2.82762976E-02, 2.82645828E-02, 2.82542933E-02, 2.82453505E-02,
     &   2.82377538E-02, 2.82314945E-02, 2.82265547E-02, 2.82228789E-02,
     &   2.82204450E-02, 2.82192427E-02, 2.82192983E-02, 2.82206199E-02,
     &   2.82232081E-02, 2.82270583E-02, 2.82322188E-02, 2.82387160E-02,
     &   2.82464847E-02, 2.82557028E-02, 2.82664291E-02, 2.82785856E-02,
     &   2.82924788E-02, 2.83078709E-02, 2.83251272E-02, 2.83443406E-02,
     &   2.83632879E-02, 2.83869179E-02, 2.84127914E-02, 2.84418257E-02,
     &   2.84742596E-02, 2.85106458E-02, 2.85516030E-02, 2.85989219E-02,
     &   2.86547061E-02, 2.87234354E-02, 2.88160221E-02, 2.90496200E-02/
  
         DATA ((DGS (I,J), I=2001,2100), J=1,1) /
     &   2.92869946E-02, 2.93834491E-02, 2.94561603E-02, 2.95160314E-02,
     &   2.95675542E-02, 2.96128217E-02, 2.96536830E-02, 2.96907418E-02,
     &   2.97245523E-02, 2.97553198E-02, 2.97840875E-02, 2.98106676E-02,
     &   2.98354345E-02, 2.98584767E-02, 2.98797884E-02, 2.98997808E-02,
     &   2.99180869E-02, 2.99349697E-02, 2.99507903E-02, 2.99650994E-02,
     &   2.99783792E-02, 2.99904987E-02, 3.00014857E-02, 3.00114619E-02,
     &   3.00204292E-02, 3.00283939E-02, 3.00326972E-02, 3.00414210E-02,
     &   3.00465056E-02, 3.00506823E-02, 3.00539817E-02, 3.00563946E-02,
     &   3.00579182E-02, 3.00583757E-02, 3.00576666E-02, 3.00398935E-02,
     &   2.99170582E-02, 2.97791767E-02, 2.96670742E-02, 2.95683082E-02,
     &   2.94882303E-02, 2.94140328E-02, 2.93485828E-02, 2.92829280E-02,
     &   2.92175488E-02, 2.91531365E-02, 2.90818579E-02, 2.90029281E-02,
     &   2.88532659E-02, 2.87036038E-02, 2.87677086E-02, 2.88281589E-02,
     &   2.88812120E-02, 2.89334353E-02, 2.89793259E-02, 2.90249968E-02,
     &   2.90666817E-02, 2.91085197E-02, 2.91488506E-02, 2.91862215E-02,
     &   2.92242011E-02, 2.92596186E-02, 2.92958094E-02, 2.93297168E-02,
     &   2.93645042E-02, 2.93972109E-02, 2.94308683E-02, 2.94625967E-02,
     &   2.94953238E-02, 2.95262387E-02, 2.95574213E-02, 2.95934740E-02,
     &   2.96236423E-02, 2.96548714E-02, 2.96844642E-02, 2.97151281E-02,
     &   2.97442113E-02, 2.97743715E-02, 2.98029978E-02, 2.98327040E-02,
     &   2.98609165E-02, 2.98902094E-02, 2.99193045E-02, 2.99469569E-02,
     &   2.99756877E-02, 3.00030046E-02, 3.00313971E-02, 3.00584015E-02,
     &   3.00864779E-02, 3.01131896E-02, 3.01409693E-02, 3.01674053E-02,
     &   3.01949049E-02, 3.02210803E-02, 3.02471333E-02, 3.02742427E-02,
     &   3.03000542E-02, 3.03269173E-02, 3.03524986E-02, 3.03791264E-02/
  
         DATA ((DGS (I,J), I=2101,2164), J=1,1) /
     &   3.04044876E-02, 3.04246516E-02, 3.04490174E-02, 3.04753427E-02,
     &   3.05004339E-02, 3.05265739E-02, 3.05529646E-02, 3.05779034E-02,
     &   3.06038418E-02, 3.06248979E-02, 3.06505803E-02, 3.06750672E-02,
     &   3.07005859E-02, 3.07249183E-02, 3.07502777E-02, 3.07744597E-02,
     &   3.07996638E-02, 3.08236991E-02, 3.08487517E-02, 3.08726438E-02,
     &   3.08964670E-02, 3.09213004E-02, 3.09449851E-02, 3.09696753E-02,
     &   3.09932246E-02, 3.10177746E-02, 3.10411912E-02, 3.10656039E-02,
     &   3.10888905E-02, 3.11131686E-02, 3.11363277E-02, 3.11604738E-02,
     &   3.14187657E-02, 3.16699059E-02, 3.17094652E-02, 3.34757931E-02,
     &   3.42729393E-02, 3.63665197E-02, 3.75453928E-02, 3.76027021E-02,
     &   3.91783473E-02, 3.91833462E-02, 4.03659049E-02, 4.04109830E-02,
     &   4.04379471E-02, 4.10251938E-02, 4.14164102E-02, 4.14865530E-02,
     &   4.16011874E-02, 4.17710913E-02, 4.18909800E-02, 4.19664183E-02,
     &   4.26988961E-02, 4.27359903E-02, 4.29524115E-02, 4.29913762E-02,
     &   4.31716361E-02, 4.32525353E-02, 4.33094893E-02, 4.33625232E-02,
     &   4.35064136E-02, 4.38219088E-02, 4.38254430E-02, 4.44549174E-02/
  
         DATA ((DGS (I,J), I=   1, 100), J=2,2) /
     &   1.16620819E-05, 1.22869070E-05, 1.29626689E-05, 1.37216372E-05,
     &   1.46380309E-05, 1.51315698E-05, 1.70447164E-05, 1.77029458E-05,
     &   1.83570888E-05, 1.93963707E-05, 1.93212031E-05, 1.93397843E-05,
     &   1.94498858E-05, 1.98109595E-05, 2.03553376E-05, 2.10221132E-05,
     &   2.16770287E-05, 2.22087961E-05, 2.26187109E-05, 2.32708430E-05,
     &   2.38374922E-05, 2.44688698E-05, 2.50452868E-05, 2.57190417E-05,
     &   2.62311072E-05, 2.68758058E-05, 2.76819883E-05, 2.81065358E-05,
     &   2.83042153E-05, 2.89548313E-05, 2.96549069E-05, 3.02577419E-05,
     &   3.09900889E-05, 3.17298545E-05, 3.24895556E-05, 3.32772865E-05,
     &   3.41001347E-05, 3.50165330E-05, 3.58797055E-05, 3.67405591E-05,
     &   3.74829671E-05, 3.84548632E-05, 3.95200505E-05, 4.04399710E-05,
     &   4.18728913E-05, 4.36827683E-05, 4.51155880E-05, 4.61104504E-05,
     &   4.65595148E-05, 4.71741566E-05, 5.39948048E-05, 6.18520931E-05,
     &   7.26971604E-05, 8.47433788E-05, 9.29619490E-05, 9.48792230E-05,
     &   9.72697314E-05, 9.88092509E-05, 1.01917025E-04, 1.02449654E-04,
     &   1.04008876E-04, 1.04630497E-04, 1.06633605E-04, 1.10096005E-04,
     &   1.13504011E-04, 1.17520199E-04, 1.21345794E-04, 1.22226649E-04,
     &   1.23639860E-04, 1.25601940E-04, 1.25523710E-04, 1.22236217E-04,
     &   1.22913345E-04, 1.23660675E-04, 1.23815938E-04, 1.25908074E-04,
     &   1.25651117E-04, 1.27934637E-04, 1.30152902E-04, 1.61397543E-04,
     &   1.54284146E-04, 1.58253348E-04, 1.54492760E-04, 1.48112906E-04,
     &   1.49548313E-04, 1.62642190E-04, 1.64534216E-04, 1.58256560E-04,
     &   1.54085347E-04, 1.50927172E-04, 1.47301588E-04, 1.46945332E-04,
     &   1.47865415E-04, 1.50978251E-04, 1.55333157E-04, 1.63374280E-04,
     &   1.59486967E-04, 1.57897626E-04, 1.51166540E-04, 1.45365790E-04/
  
         DATA ((DGS (I,J), I= 101, 200), J=2,2) /
     &   1.37764561E-04, 1.31021921E-04, 1.24910989E-04, 1.19897386E-04,
     &   1.16691293E-04, 1.14322214E-04, 1.12920735E-04, 1.12077337E-04,
     &   1.11937570E-04, 1.12846256E-04, 1.14622585E-04, 1.16266345E-04,
     &   1.18132405E-04, 1.20269204E-04, 1.22491565E-04, 1.24209726E-04,
     &   1.25022233E-04, 1.21836323E-04, 1.16765696E-04, 1.15140886E-04,
     &   1.14243519E-04, 1.13844457E-04, 1.14016605E-04, 1.14635918E-04,
     &   1.15374144E-04, 1.15281726E-04, 1.15617957E-04, 1.16454730E-04,
     &   1.17987638E-04, 1.19827251E-04, 1.22856247E-04, 1.27029237E-04,
     &   1.32563091E-04, 1.38987853E-04, 1.46143413E-04, 1.52796645E-04,
     &   1.57689250E-04, 1.58237981E-04, 1.54281322E-04, 1.45294429E-04,
     &   1.40688045E-04, 1.35953692E-04, 1.32717098E-04, 1.30197120E-04,
     &   1.28460417E-04, 1.27419683E-04, 1.25555480E-04, 1.25059234E-04,
     &   1.23049937E-04, 1.22208299E-04, 1.20965087E-04, 1.26650022E-04,
     &   1.27904301E-04, 1.31334499E-04, 1.19992834E-04, 1.25558344E-04,
     &   1.28163955E-04, 1.24991017E-04, 1.16907426E-04, 1.17531266E-04,
     &   1.20408981E-04, 1.29187583E-04, 1.32117862E-04, 1.31746745E-04,
     &   1.30593145E-04, 1.29316100E-04, 1.28767994E-04, 1.28437375E-04,
     &   1.29645155E-04, 1.32758828E-04, 1.36317682E-04, 1.39981272E-04,
     &   1.46034429E-04, 1.51232647E-04, 1.56348865E-04, 1.60550637E-04,
     &   1.65483033E-04, 1.71007594E-04, 1.76533064E-04, 1.80222513E-04,
     &   1.87665498E-04, 1.91331009E-04, 2.00802857E-04, 2.09493910E-04,
     &   2.21270293E-04, 2.32323484E-04, 2.47413120E-04, 2.61680975E-04,
     &   2.77999959E-04, 3.00530049E-04, 3.13408355E-04, 3.22636132E-04,
     &   3.43123926E-04, 3.54179408E-04, 3.65696577E-04, 3.78552926E-04,
     &   3.92743588E-04, 4.08409861E-04, 4.25396249E-04, 4.63045828E-04/
  
         DATA ((DGS (I,J), I= 201, 300), J=2,2) /
     &   5.07216659E-04, 5.33180740E-04, 5.43027085E-04, 5.53292485E-04,
     &   5.64001239E-04, 5.75173710E-04, 5.86843707E-04, 5.99031675E-04,
     &   6.11754511E-04, 6.25066049E-04, 6.38995623E-04, 6.53583641E-04,
     &   6.68884694E-04, 6.84931083E-04, 7.01803716E-04, 7.19596424E-04,
     &   7.38391950E-04, 7.58278032E-04, 7.79376138E-04, 8.01825081E-04,
     &   8.25791349E-04, 8.51473241E-04, 8.79123694E-04, 9.09060923E-04,
     &   9.41712233E-04, 9.77683344E-04, 1.01791755E-03, 1.06410857E-03,
     &   1.12009472E-03, 1.20115581E-03, 1.27633955E-03, 1.37753801E-03,
     &   1.26221500E-03, 1.26385701E-03, 1.32467047E-03, 1.33298297E-03,
     &   1.38113669E-03, 1.43435394E-03, 1.49848733E-03, 1.55968803E-03,
     &   1.63278767E-03, 1.71390656E-03, 1.78789156E-03, 2.00479386E-03,
     &   2.01750372E-03, 2.14438778E-03, 2.28790969E-03, 2.45117983E-03,
     &   2.63797019E-03, 2.85294350E-03, 3.10139430E-03, 3.38975255E-03,
     &   3.72355437E-03, 4.04570146E-03, 4.22302434E-03, 4.34299873E-03,
     &   4.46508540E-03, 4.58859277E-03, 4.53999688E-03, 4.83438454E-03,
     &   4.95137134E-03, 5.05725892E-03, 5.15047261E-03, 5.22331546E-03,
     &   5.26765141E-03, 5.27249943E-03, 5.18033034E-03, 5.02299908E-03,
     &   4.91210012E-03, 4.61173567E-03, 4.19284268E-03, 3.64267183E-03,
     &   2.95849320E-03, 2.15042799E-03, 1.24752599E-03, 3.52401618E-04,
     &   7.89082933E-04, 1.72018638E-03, 2.58601469E-03, 3.34073466E-03,
     &   3.96498484E-03, 4.45644557E-03, 4.81963395E-03, 5.07181405E-03,
     &   5.23021126E-03, 5.31214491E-03, 5.33408924E-03, 5.31012865E-03,
     &   5.25194841E-03, 5.16916520E-03, 5.01865321E-03, 4.86599935E-03,
     &   4.76201761E-03, 4.70912011E-03, 4.59353345E-03, 4.47012196E-03,
     &   4.34881918E-03, 4.22990132E-03, 4.11386490E-03, 4.00153070E-03/
  
         DATA ((DGS (I,J), I= 301, 400), J=2,2) /
     &   3.98894637E-03, 3.78863471E-03, 3.68828437E-03, 3.59190176E-03,
     &   3.28454422E-03, 3.01967320E-03, 2.79114608E-03, 2.59311928E-03,
     &   2.42060600E-03, 2.23542039E-03, 2.13635909E-03, 2.01849035E-03,
     &   1.91367629E-03, 1.82008419E-03, 1.73624974E-03, 1.66101478E-03,
     &   1.59343679E-03, 1.53278159E-03, 1.47850089E-03, 1.43034294E-03,
     &   1.38963092E-03, 1.35404351E-03, 1.36755262E-03, 1.31517600E-03,
     &   1.35376326E-03, 1.61440394E-03, 1.57864532E-03, 1.27003419E-03,
     &   1.17317225E-03, 1.10820597E-03, 1.05808254E-03, 1.01535745E-03,
     &   9.78546674E-04, 9.45759598E-04, 9.16144094E-04, 8.89108943E-04,
     &   8.64237401E-04, 8.41224697E-04, 8.19818865E-04, 7.99844326E-04,
     &   7.81137919E-04, 7.63554521E-04, 7.46944137E-04, 7.31283626E-04,
     &   7.16473199E-04, 7.02359216E-04, 6.88983446E-04, 6.76283636E-04,
     &   6.64225771E-04, 6.52777179E-04, 6.41914347E-04, 6.31504426E-04,
     &   6.21255612E-04, 6.11433468E-04, 6.02011004E-04, 5.92980011E-04,
     &   5.69132575E-04, 5.21542344E-04, 4.50664510E-04, 4.07244034E-04,
     &   3.82543387E-04, 3.59571700E-04, 3.42458368E-04, 3.31752260E-04,
     &   3.24032999E-04, 3.23065496E-04, 3.18615075E-04, 3.20863835E-04,
     &   3.21498788E-04, 3.23893638E-04, 3.29065285E-04, 3.29156534E-04,
     &   3.34357475E-04, 3.41015147E-04, 3.43659503E-04, 3.48295771E-04,
     &   3.57398851E-04, 3.69444367E-04, 3.83369986E-04, 4.00415516E-04,
     &   4.10275289E-04, 4.18403770E-04, 4.36546794E-04, 4.57343215E-04,
     &   4.59134858E-04, 4.78046420E-04, 5.01740691E-04, 5.12497164E-04,
     &   5.25948622E-04, 5.51632250E-04, 5.82572435E-04, 6.21283363E-04,
     &   6.33123640E-04, 6.68791625E-04, 6.91802739E-04, 7.22401762E-04,
     &   7.83058914E-04, 8.70404702E-04, 8.78859404E-04, 9.66625164E-04/
  
         DATA ((DGS (I,J), I= 401, 500), J=2,2) /
     &   1.14573097E-03, 1.18640102E-03, 1.10937221E-03, 1.05088849E-03,
     &   1.03432401E-03, 9.57721533E-04, 9.65819592E-04, 9.63126353E-04,
     &   9.41001346E-04, 8.83540809E-04, 8.25939993E-04, 7.71047831E-04,
     &   7.69930788E-04, 7.45171276E-04, 7.36034875E-04, 7.07554712E-04,
     &   7.03229100E-04, 6.64760172E-04, 6.62656851E-04, 6.47439185E-04,
     &   6.47732234E-04, 6.50450904E-04, 6.30753682E-04, 6.09691181E-04,
     &   6.04875357E-04, 6.65766364E-04, 6.71017174E-04, 7.21507734E-04,
     &   7.28481032E-04, 7.64919791E-04, 7.90513146E-04, 7.95231136E-04,
     &   7.99407691E-04, 7.96836306E-04, 7.92062368E-04, 7.66307573E-04,
     &   7.63769540E-04, 6.97363950E-04, 6.91715972E-04, 6.42864163E-04,
     &   5.93854186E-04, 5.79684795E-04, 5.61619662E-04, 5.56209753E-04,
     &   4.98847823E-04, 4.88581980E-04, 4.93669565E-04, 4.59601882E-04,
     &   4.67269795E-04, 4.22895121E-04, 4.57524721E-04, 4.59257854E-04,
     &   4.62138603E-04, 4.77105395E-04, 4.60268415E-04, 4.45431031E-04,
     &   4.93175715E-04, 5.13207114E-04, 5.60762322E-04, 5.76574323E-04,
     &   5.88927743E-04, 5.86309051E-04, 5.92758561E-04, 5.89037834E-04,
     &   5.96418467E-04, 6.03703367E-04, 6.03083239E-04, 6.22507987E-04,
     &   6.56958023E-04, 6.71653790E-04, 6.79472704E-04, 7.20514772E-04,
     &   7.64609896E-04, 7.96152350E-04, 8.01215198E-04, 8.46625628E-04,
     &   8.58528688E-04, 8.55965387E-04, 8.84224180E-04, 9.07675813E-04,
     &   9.10210702E-04, 9.60592378E-04, 9.90496153E-04, 1.00407455E-03,
     &   1.03426880E-03, 1.14974654E-03, 1.19804703E-03, 1.24181351E-03,
     &   1.29625151E-03, 1.31556692E-03, 1.35992979E-03, 1.36951903E-03,
     &   1.41349114E-03, 1.46175837E-03, 1.50110991E-03, 1.51888883E-03,
     &   1.85409986E-03, 2.14275001E-03, 2.48015782E-03, 1.61495575E-03/
  
         DATA ((DGS (I,J), I= 501, 600), J=2,2) /
     &   1.38755932E-03, 1.34434081E-03, 8.80681321E-04, 8.84340069E-04,
     &   8.75243860E-04, 7.86421442E-04, 7.25782662E-04, 6.73581949E-04,
     &   6.35143474E-04, 6.17013134E-04, 6.11043847E-04, 6.19406500E-04,
     &   6.36051629E-04, 6.57888498E-04, 6.99041450E-04, 7.80152754E-04,
     &   8.04568866E-04, 8.32327950E-04, 8.64642072E-04, 9.02241865E-04,
     &   9.46173020E-04, 9.97793884E-04, 1.05906947E-03, 1.07265746E-03,
     &   1.08676440E-03, 1.10141109E-03, 1.11662097E-03, 1.13242206E-03,
     &   1.14876895E-03, 1.16577242E-03, 1.18346734E-03, 1.20189342E-03,
     &   1.22107882E-03, 1.31681180E-03, 1.39338297E-03, 1.43579824E-03,
     &   1.46576338E-03, 1.49713231E-03, 1.53011470E-03, 1.56481480E-03,
     &   1.60137224E-03, 1.63992810E-03, 1.66000612E-03, 1.68064903E-03,
     &   1.70187530E-03, 1.72371345E-03, 1.74618471E-03, 1.76932028E-03,
     &   1.79314453E-03, 1.81769177E-03, 1.84298989E-03, 1.86907683E-03,
     &   1.89598457E-03, 1.92375343E-03, 1.95242308E-03, 1.98203861E-03,
     &   2.01264483E-03, 2.04429068E-03, 2.07702791E-03, 2.11091365E-03,
     &   2.14600615E-03, 2.18236967E-03, 2.22007163E-03, 2.25918709E-03,
     &   2.29979410E-03, 2.34197741E-03, 2.38582829E-03, 2.43144519E-03,
     &   2.47893445E-03, 2.52841108E-03, 2.57999970E-03, 2.63383556E-03,
     &   2.69006605E-03, 2.74885096E-03, 2.81036498E-03, 2.87479909E-03,
     &   2.94236249E-03, 3.01328480E-03, 3.08781869E-03, 3.16624275E-03,
     &   3.24886499E-03, 3.33602676E-03, 3.38142664E-03, 3.42810745E-03,
     &   3.47612252E-03, 3.52552987E-03, 3.57638967E-03, 3.62876672E-03,
     &   3.68272862E-03, 3.73834812E-03, 3.79570146E-03, 3.85487064E-03,
     &   3.91594189E-03, 3.97900801E-03, 4.04416692E-03, 4.11152404E-03,
     &   4.18119103E-03, 4.25328819E-03, 4.32794338E-03, 4.40529451E-03/
  
         DATA ((DGS (I,J), I= 601, 700), J=2,2) /
     &   4.48548860E-03, 4.56868471E-03, 4.65505278E-03, 4.74477666E-03,
     &   4.83805444E-03, 4.93510009E-03, 5.03614510E-03, 5.14144034E-03,
     &   5.25125809E-03, 5.36589440E-03, 5.48567172E-03, 5.61094207E-03,
     &   5.74208958E-03, 5.87953626E-03, 6.02374485E-03, 6.17522617E-03,
     &   6.33453954E-03, 6.50230723E-03, 6.67921770E-03, 6.86603660E-03,
     &   7.14587271E-03, 7.27291381E-03, 7.49499702E-03, 7.73107211E-03,
     &   7.98250029E-03, 8.25082563E-03, 8.53780606E-03, 8.84545250E-03,
     &   9.17607528E-03, 9.53234282E-03, 9.91735297E-03, 1.03347239E-02,
     &   1.07887071E-02, 1.11511492E-02, 1.22804057E-02, 1.36635694E-02,
     &   1.53969981E-02, 1.76328656E-02, 2.06264158E-02, 2.48410074E-02,
     &   3.12144913E-02, 4.19753705E-02, 6.40255330E-02, 1.34625432E-01,
     &   1.42358211E-01, 1.51029958E-01, 1.60822063E-01, 1.71965639E-01,
     &   1.84759705E-01, 1.99597943E-01, 2.17009075E-01, 2.37719614E-01,
     &   2.62754736E-01, 2.93606809E-01, 3.32529838E-01, 3.83080962E-01,
     &   4.51175217E-01, 4.59293829E-01, 6.41079952E-01, 7.73578367E-01,
     &   8.80033201E-01, 9.72616271E-01, 1.04395894E+00, 1.10629436E+00,
     &   1.15625187E+00, 1.20602060E+00, 1.24020877E+00, 1.27186419E+00,
     &   1.29420139E+00, 1.31261590E+00, 1.32296395E+00, 1.33068808E+00,
     &   1.33134490E+00, 1.32745751E+00, 1.31667715E+00, 1.30502613E+00,
     &   1.27982482E+00, 1.25724465E+00, 1.22952770E+00, 1.19623801E+00,
     &   1.15695734E+00, 1.11130107E+00, 1.05893664E+00, 9.99604205E-01,
     &   9.33138759E-01, 8.59492567E-01, 7.78756472E-01, 6.44946993E-01,
     &   5.47944313E-01, 3.92450592E-01, 2.27697170E-01, 2.27540057E-01,
     &   6.44809415E-01, 7.78629950E-01, 8.97096875E-01, 9.67163609E-01,
     &   1.05884456E+00, 1.11121802E+00, 1.15688327E+00, 1.19617279E+00/
  
         DATA ((DGS (I,J), I= 701, 800), J=2,2) /
     &   1.22947113E+00, 1.25719648E+00, 1.27978476E+00, 1.29767658E+00,
     &   1.31130673E+00, 1.32109626E+00, 1.32744662E+00, 1.33134354E+00,
     &   1.33069265E+00, 1.32562139E+00, 1.31645902E+00, 1.30848132E+00,
     &   1.28896734E+00, 1.27190378E+00, 1.24683752E+00, 1.21996174E+00,
     &   1.18489738E+00, 1.14915122E+00, 1.09930493E+00, 1.05080849E+00,
     &   9.91557527E-01, 9.24732036E-01, 8.38778490E-01, 7.40244493E-01,
     &   6.17209651E-01, 5.08597863E-01, 4.24230894E-01, 3.63354464E-01,
     &   3.17517300E-01, 2.81826469E-01, 2.53280486E-01, 2.29945386E-01,
     &   2.10522634E-01, 1.94109617E-01, 1.80060221E-01, 1.67900163E-01,
     &   1.57273646E-01, 1.47908656E-01, 1.39593739E-01, 1.32162085E-01,
     &   1.25480358E-01, 1.19440721E-01, 1.13955030E-01, 5.97561065E-02,
     &   4.05016651E-02, 3.06388898E-02, 2.46443864E-02, 2.06158323E-02,
     &   1.77225393E-02, 1.55440248E-02, 1.38446365E-02, 1.24820517E-02,
     &   1.13652382E-02, 1.12329811E-02, 1.03108750E-02, 9.52992288E-03,
     &   8.86006207E-03, 8.27920132E-03, 7.77074303E-03, 7.32197643E-03,
     &   6.92300280E-03, 6.56599386E-03, 6.24468433E-03, 5.95399885E-03,
     &   5.68977857E-03, 5.44858621E-03, 5.22755562E-03, 5.02427771E-03,
     &   4.83671294E-03, 4.66311930E-03, 4.50201761E-03, 4.35210581E-03,
     &   4.21229162E-03, 4.08158303E-03, 3.95913834E-03, 3.84421070E-03,
     &   3.73614101E-03, 3.63434546E-03, 3.53830511E-03, 3.44755523E-03,
     &   3.36168573E-03, 3.28032301E-03, 3.20313400E-03, 3.12981442E-03,
     &   3.06009301E-03, 2.99372255E-03, 2.93047846E-03, 2.87015629E-03,
     &   2.81256956E-03, 2.75754785E-03, 2.70493614E-03, 2.65458981E-03,
     &   2.60637818E-03, 2.56017852E-03, 2.51588325E-03, 2.47338827E-03,
     &   2.43259902E-03, 2.39342818E-03, 2.35579503E-03, 2.31962494E-03/
  
         DATA ((DGS (I,J), I= 801, 900), J=2,2) /
     &   2.28485339E-03, 2.25140773E-03, 2.21923299E-03, 2.18826885E-03,
     &   2.15847551E-03, 2.12980093E-03, 2.10220193E-03, 2.07563869E-03,
     &   2.05007460E-03, 2.02547611E-03, 2.00181257E-03, 1.97905613E-03,
     &   1.95718860E-03, 1.93616671E-03, 1.91599140E-03, 1.89663847E-03,
     &   1.87809328E-03, 1.86034383E-03, 1.84338089E-03, 1.82719803E-03,
     &   1.81179412E-03, 1.79716316E-03, 1.78331180E-03, 1.77024943E-03,
     &   1.75798492E-03, 1.74653510E-03, 1.73592185E-03, 1.72617357E-03,
     &   1.71732635E-03, 1.70942556E-03, 1.70252784E-03, 1.69667674E-03,
     &   1.69200986E-03, 1.68865296E-03, 1.68667788E-03, 1.68629731E-03,
     &   1.68770241E-03, 1.67850388E-03, 1.66971991E-03, 1.66142094E-03,
     &   1.65338174E-03, 1.64588348E-03, 1.63900980E-03, 1.63237310E-03,
     &   1.62658133E-03, 1.62264825E-03, 1.62701136E-03, 1.61947357E-03,
     &   1.61176736E-03, 1.60445429E-03, 1.59714926E-03, 1.59009131E-03,
     &   1.58345833E-03, 1.57652713E-03, 1.56998603E-03, 1.56362014E-03,
     &   1.20961722E-03, 1.06035959E-03, 1.00825916E-03, 1.02113204E-03,
     &   1.07949331E-03, 1.14021244E-03, 1.23468884E-03, 1.37786084E-03,
     &   1.52370530E-03, 1.73211746E-03, 1.80571412E-03, 1.94232450E-03,
     &   2.03269414E-03, 2.12583353E-03, 2.23900225E-03, 2.38315097E-03,
     &   2.56181064E-03, 2.78244820E-03, 3.05700614E-03, 3.40392980E-03,
     &   3.85232832E-03, 4.06995068E-03, 4.31553084E-03, 4.59460332E-03,
     &   4.91429344E-03, 5.28391295E-03, 5.71586382E-03, 5.96026837E-03,
     &   6.22705442E-03, 6.51940078E-03, 6.84112287E-03, 7.19683225E-03,
     &   7.59216231E-03, 8.03406295E-03, 8.53121306E-03, 9.09459054E-03,
     &   9.73828954E-03, 1.04807063E-02, 1.13463213E-02, 1.23240190E-02,
     &   1.29642625E-02, 1.36748347E-02, 1.44679649E-02, 1.53588910E-02/
  
         DATA ((DGS (I,J), I= 901,1000), J=2,2) /
     &   1.63668460E-02, 1.75164576E-02, 1.88397822E-02, 2.03793317E-02,
     &   2.21927131E-02, 2.43599741E-02, 2.69957001E-02, 3.02698672E-02,
     &   3.44458585E-02, 3.99546942E-02, 4.75531873E-02, 5.87018094E-02,
     &   7.66219857E-02, 1.10033357E-01, 1.62584043E-01, 1.92494007E-01,
     &   2.25118305E-01, 3.05389529E-01, 3.34309378E-01, 3.58177574E-01,
     &   3.78447211E-01, 3.95515405E-01, 4.09518984E-01, 4.21576809E-01,
     &   4.31449821E-01, 4.38515948E-01, 4.44518924E-01, 4.48768495E-01,
     &   4.51288999E-01, 4.52199329E-01, 4.51552874E-01, 4.49786447E-01,
     &   4.46201522E-01, 4.41510473E-01, 4.35187197E-01, 4.27051510E-01,
     &   4.18496775E-01, 4.06511011E-01, 3.94393150E-01, 3.80465405E-01,
     &   3.64638392E-01, 3.43676977E-01, 3.23513554E-01, 2.97398457E-01,
     &   2.72809595E-01, 2.36960256E-01, 1.97836349E-01, 1.39402568E-01,
     &   8.84684510E-02, 2.98064328E-02, 9.04149223E-04, 2.96576962E-02,
     &   5.91777024E-02, 1.39261523E-01, 1.97703894E-01, 2.36835551E-01,
     &   2.72693628E-01, 2.97289537E-01, 3.23413240E-01, 3.43584257E-01,
     &   3.64554659E-01, 3.80389398E-01, 3.94324816E-01, 4.06450242E-01,
     &   4.18444634E-01, 4.27006553E-01, 4.35150334E-01, 4.41481366E-01,
     &   4.46179814E-01, 4.49772745E-01, 4.51545781E-01, 4.52200196E-01,
     &   4.51297241E-01, 4.48784279E-01, 4.44542261E-01, 4.38546711E-01,
     &   4.31487241E-01, 4.21621591E-01, 4.09570992E-01, 3.95574304E-01,
     &   3.78513077E-01, 3.58250311E-01, 3.34388828E-01, 3.05475665E-01,
     &   2.70423785E-01, 2.89453751E-01, 2.25217508E-01, 1.62689651E-01,
     &   1.38383123E-01, 8.96058798E-02, 6.61168679E-02, 5.23576087E-02,
     &   4.33323392E-02, 3.69603402E-02, 3.22230403E-02, 2.85636095E-02,
     &   2.56521456E-02, 2.32808328E-02, 2.13122776E-02, 1.96520209E-02/
  
         DATA ((DGS (I,J), I=1001,1100), J=2,2) /
     &   1.82329901E-02, 1.70062468E-02, 1.59352470E-02, 1.49921526E-02,
     &   1.41553865E-02, 1.34079648E-02, 1.27363365E-02, 1.16750188E-02,
     &   1.03510435E-02, 9.64291332E-03, 8.48874122E-03, 7.58683256E-03,
     &   6.70586703E-03, 5.45883830E-03, 4.07641340E-03, 3.25809503E-03,
     &   2.91632562E-03, 2.72458414E-03, 2.59960318E-03, 2.51145588E-03,
     &   2.44502432E-03, 2.39290968E-03, 2.35061893E-03, 2.31525297E-03,
     &   2.28509456E-03, 2.25883327E-03, 2.23557793E-03, 2.21470162E-03,
     &   2.19565340E-03, 2.17811409E-03, 2.16173605E-03, 2.14624159E-03,
     &   2.13155415E-03, 2.11740396E-03, 2.10365820E-03, 2.09023088E-03,
     &   2.07694558E-03, 2.06384823E-03, 2.05064562E-03, 2.03728114E-03,
     &   2.02365574E-03, 2.00960120E-03, 1.99493460E-03, 1.97939091E-03,
     &   1.96266017E-03, 1.94415693E-03, 1.92279907E-03, 1.89588812E-03,
     &   1.83546426E-03, 1.78324863E-03, 1.76520074E-03, 1.75310355E-03,
     &   1.74420197E-03, 1.73737041E-03, 1.73201995E-03, 1.72776255E-03,
     &   1.72429600E-03, 1.72141058E-03, 1.71872334E-03, 1.71660275E-03,
     &   1.71427602E-03, 1.71172733E-03, 1.70849438E-03, 1.70097065E-03,
     &   1.70465649E-03, 1.70160248E-03, 1.69874853E-03, 1.69484591E-03,
     &   1.68984778E-03, 1.68363245E-03, 1.67606791E-03, 1.66635866E-03,
     &   1.65561247E-03, 1.64230844E-03, 1.62667118E-03, 1.60801298E-03,
     &   1.58576124E-03, 1.55953586E-03, 1.52821470E-03, 1.49151967E-03,
     &   1.44623427E-03, 1.38737733E-03, 1.30547130E-03, 1.28179746E-03,
     &   1.21344453E-03, 1.11927587E-03, 1.11058132E-03, 1.05133022E-03,
     &   1.03160880E-03, 1.01750074E-03, 9.98763552E-04, 9.80872409E-04,
     &   9.67327423E-04, 9.59955267E-04, 9.53440713E-04, 9.43389561E-04,
     &   9.27759310E-04, 9.21272184E-04, 8.94249201E-04, 8.64862734E-04/
  
         DATA ((DGS (I,J), I=1101,1200), J=2,2) /
     &   8.62783592E-04, 8.41192697E-04, 8.21083329E-04, 8.18857201E-04,
     &   8.13925900E-04, 8.19080193E-04, 8.39291283E-04, 9.03333630E-04,
     &   7.92718534E-04, 7.38675189E-04, 7.50325814E-04, 7.63236071E-04,
     &   7.85462635E-04, 7.81298855E-04, 7.64018442E-04, 7.63152508E-04,
     &   7.57285558E-04, 7.34517957E-04, 7.22905392E-04, 6.94217336E-04,
     &   6.88530537E-04, 6.88295918E-04, 6.76519657E-04, 6.68568716E-04,
     &   6.62493565E-04, 6.50568556E-04, 6.41010989E-04, 6.36527316E-04,
     &   6.34637828E-04, 6.32673829E-04, 6.32576673E-04, 6.29758873E-04,
     &   6.26199253E-04, 6.22132205E-04, 6.21700581E-04, 6.23569931E-04,
     &   6.21012791E-04, 6.08990007E-04, 6.01783881E-04, 5.98526385E-04,
     &   5.96175486E-04, 5.94917826E-04, 5.93170774E-04, 5.92554360E-04,
     &   5.90321302E-04, 5.85506087E-04, 5.83271333E-04, 5.81110674E-04,
     &   5.78682906E-04, 5.75182801E-04, 5.73017585E-04, 5.71458814E-04,
     &   5.70958473E-04, 5.70727513E-04, 5.72910597E-04, 5.67192195E-04,
     &   5.62573903E-04, 5.61524224E-04, 5.60951681E-04, 5.58396470E-04,
     &   5.57706234E-04, 5.59134624E-04, 5.53944399E-04, 5.58415274E-04,
     &   5.68562122E-04, 5.51841417E-04, 5.50499067E-04, 5.45428417E-04,
     &   5.44795642E-04, 5.49634800E-04, 5.40744684E-04, 5.38283874E-04,
     &   5.35998230E-04, 5.34139853E-04, 5.30165938E-04, 5.31379824E-04,
     &   5.31100785E-04, 5.30295590E-04, 5.27780627E-04, 5.28323339E-04,
     &   5.29095152E-04, 5.24008218E-04, 5.23123555E-04, 5.22962053E-04,
     &   5.17410267E-04, 5.17154402E-04, 5.18143613E-04, 5.16815722E-04,
     &   5.17622291E-04, 5.19343714E-04, 5.12378246E-04, 5.11560305E-04,
     &   5.11161876E-04, 5.18234168E-04, 5.14961362E-04, 5.14151342E-04,
     &   5.11744625E-04, 5.17664041E-04, 5.28966407E-04, 5.35610080E-04/
  
         DATA ((DGS (I,J), I=1201,1300), J=2,2) /
     &   5.28812870E-04, 5.28175475E-04, 5.33271040E-04, 5.29552738E-04,
     &   5.32859175E-04, 5.46315935E-04, 5.93513255E-04, 5.65579305E-04,
     &   5.66767841E-04, 5.82735686E-04, 5.52596818E-04, 5.46807058E-04,
     &   5.44530341E-04, 5.65847307E-04, 5.68606700E-04, 6.11294159E-04,
     &   6.15368423E-04, 6.87142104E-04, 7.84245266E-04, 8.31779069E-04,
     &   1.01045602E-03, 1.15359899E-03, 1.14488995E-03, 9.80709565E-04,
     &   8.23843246E-04, 6.88958241E-04, 6.50772199E-04, 6.21577437E-04,
     &   5.79254177E-04, 5.49607545E-04, 5.37791399E-04, 5.27444763E-04,
     &   5.18296800E-04, 5.10142073E-04, 5.02821556E-04, 4.96205554E-04,
     &   4.90202544E-04, 4.84727192E-04, 4.79713001E-04, 4.75104921E-04,
     &   4.70856968E-04, 4.66930420E-04, 4.63292445E-04, 4.59915024E-04,
     &   4.56774117E-04, 4.53848999E-04, 4.51121727E-04, 4.48576714E-04,
     &   4.46200382E-04, 4.43980880E-04, 4.41907850E-04, 4.39972236E-04,
     &   4.38166129E-04, 4.36482628E-04, 4.34915738E-04, 4.33460276E-04,
     &   4.32111797E-04, 4.30866531E-04, 4.29721335E-04, 4.28673650E-04,
     &   4.27721474E-04, 4.26863332E-04, 4.26098270E-04, 4.25425835E-04,
     &   4.24954599E-04, 4.24359575E-04, 4.23671173E-04, 4.23375940E-04,
     &   4.23498866E-04, 4.24076217E-04, 4.25157920E-04, 4.26811066E-04,
     &   4.29125018E-04, 4.32218974E-04, 4.36253435E-04, 4.41448175E-04,
     &   4.48114679E-04, 4.56692977E-04, 4.67868956E-04, 4.82750831E-04,
     &   4.84507291E-04, 5.03317199E-04, 5.33628678E-04, 5.84068964E-04,
     &   6.61945797E-04, 6.93683328E-04, 8.27588670E-04, 1.09138078E-03,
     &   1.21878688E-03, 1.40193532E-03, 1.52639355E-03, 1.68396498E-03,
     &   1.84325449E-03, 2.04417107E-03, 2.16545671E-03, 2.30459175E-03,
     &   2.46568157E-03, 2.65418449E-03, 2.87751839E-03, 3.14602620E-03/
  
         DATA ((DGS (I,J), I=1301,1400), J=2,2) /
     &   3.30162526E-03, 3.47457423E-03, 3.66788941E-03, 3.88532741E-03,
     &   4.13162714E-03, 4.41285324E-03, 4.73689446E-03, 5.11420519E-03,
     &   5.55894067E-03, 5.74428973E-03, 5.86061376E-03, 5.98185162E-03,
     &   6.10831926E-03, 6.24036028E-03, 6.37834905E-03, 6.52269421E-03,
     &   6.67384271E-03, 6.83228437E-03, 6.99855719E-03, 7.17325339E-03,
     &   7.35702643E-03, 7.55059912E-03, 7.75477312E-03, 7.97043993E-03,
     &   8.19859385E-03, 8.44034730E-03, 8.69694879E-03, 8.96980451E-03,
     &   9.26050391E-03, 9.57085066E-03, 9.90289993E-03, 1.02590038E-02,
     &   1.06418671E-02, 1.10546156E-02, 1.15008819E-02, 1.19849119E-02,
     &   1.25117002E-02, 1.30871627E-02, 1.37183594E-02, 1.44137847E-02,
     &   1.51837516E-02, 1.60409054E-02, 1.70009230E-02, 1.80834788E-02,
     &   1.93136058E-02, 2.07236530E-02, 2.23561685E-02, 2.42682626E-02,
     &   2.65384193E-02, 2.92775261E-02, 3.26475179E-02, 3.68945633E-02,
     &   4.24120001E-02, 4.98695807E-02, 6.05078271E-02, 7.69097950E-02,
     &   1.05485602E-01, 1.67668999E-01, 2.06223692E-01, 3.92791894E-01,
     &   5.46541984E-01, 6.57987364E-01, 7.44218949E-01, 8.15068744E-01,
     &   8.77070096E-01, 9.34598712E-01, 9.74647919E-01, 1.01541492E+00,
     &   1.05550891E+00, 1.07484011E+00, 1.10193240E+00, 1.11816578E+00,
     &   1.13831570E+00, 1.14356687E+00, 1.15133403E+00, 1.15456191E+00,
     &   1.15212917E+00, 1.14841718E+00, 1.14281311E+00, 1.12506605E+00,
     &   1.11262079E+00, 1.09732495E+00, 1.05791506E+00, 1.03344815E+00,
     &   1.00548522E+00, 9.73491534E-01, 8.98472654E-01, 8.54415034E-01,
     &   8.06652614E-01, 6.98084655E-01, 6.37987004E-01, 5.05733084E-01,
     &   3.60134021E-01, 3.84559941E-02, 3.55351943E-01, 5.01324595E-01,
     &   6.33382300E-01, 7.50724478E-01, 8.03478084E-01, 8.51504325E-01/
  
         DATA ((DGS (I,J), I=1401,1500), J=2,2) /
     &   8.95386067E-01, 9.71349860E-01, 1.00326920E+00, 1.03177646E+00,
     &   1.05645968E+00, 1.09626575E+00, 1.11159395E+00, 1.12434986E+00,
     &   1.14231693E+00, 1.14811862E+00, 1.15404458E+00, 1.15457804E+00,
     &   1.15151159E+00, 1.14392322E+00, 1.13269019E+00, 1.11865014E+00,
     &   1.10247533E+00, 1.07544222E+00, 1.05623854E+00, 1.01606481E+00,
     &   9.75403611E-01, 9.35232999E-01, 8.77667162E-01, 8.15613625E-01,
     &   7.44696607E-01, 6.58380022E-01, 5.46829034E-01, 3.90687856E-01,
     &   2.13234325E-01, 1.21966522E-01, 8.53364229E-02, 6.56151806E-02,
     &   5.32957117E-02, 4.48708903E-02, 3.87465064E-02, 3.40938027E-02,
     &   3.04393718E-02, 2.74931635E-02, 2.50675605E-02, 2.30358321E-02,
     &   2.13092909E-02, 1.98240148E-02, 1.85327674E-02, 1.73998874E-02,
     &   1.63979477E-02, 1.55055088E-02, 1.47055696E-02, 1.39844750E-02,
     &   1.33311319E-02, 1.27364349E-02, 1.21928402E-02, 1.16940448E-02,
     &   1.12347414E-02, 1.08104292E-02, 1.04172664E-02, 1.00519537E-02,
     &   9.71164204E-03, 9.39385812E-03, 9.09644455E-03, 8.81751095E-03,
     &   8.55539385E-03, 8.30862369E-03, 8.07589731E-03, 7.85605506E-03,
     &   7.64806171E-03, 7.45098991E-03, 7.26400676E-03, 7.08636198E-03,
     &   6.91737791E-03, 6.75644097E-03, 6.60299422E-03, 6.45653099E-03,
     &   6.31658934E-03, 6.18274722E-03, 6.05461827E-03, 5.93184811E-03,
     &   5.81411112E-03, 5.70110754E-03, 4.85043208E-03, 4.33096717E-03,
     &   3.83515069E-03, 3.28590829E-03, 2.77992750E-03, 2.29820260E-03,
     &   2.04929015E-03, 1.70527040E-03, 1.59173494E-03, 1.50253086E-03,
     &   1.39588453E-03, 1.31080265E-03, 1.24207741E-03, 1.13728416E-03,
     &   1.05568458E-03, 8.63117072E-04, 7.61244971E-04, 7.63520782E-04,
     &   9.27606397E-04, 1.30055274E-03, 1.85146008E-03, 2.61829707E-03/
  
         DATA ((DGS (I,J), I=1501,1600), J=2,2) /
     &   3.70004643E-03, 6.44461540E-03, 6.96709023E-03, 7.58276366E-03,
     &   7.76123922E-03, 8.16813823E-03, 8.62037513E-03, 9.12594836E-03,
     &   9.69485557E-03, 1.03397632E-02, 1.10769564E-02, 1.19277305E-02,
     &   1.29204795E-02, 1.40939224E-02, 1.55022657E-02, 1.72238065E-02,
     &   1.93759887E-02, 2.21433626E-02, 2.58335012E-02, 3.09999928E-02,
     &   3.87499522E-02, 5.16661526E-02, 7.74937511E-02, 1.12140108E-01,
     &   1.17955479E-01, 1.24406588E-01, 1.31603645E-01, 1.39683874E-01,
     &   1.48820327E-01, 1.59234387E-01, 1.71213881E-01, 1.85139997E-01,
     &   2.01528426E-01, 2.21094300E-01, 2.44858704E-01, 2.74331380E-01,
     &   3.11841584E-01, 3.61178317E-01, 4.28936811E-01, 5.27672177E-01,
     &   6.84430190E-01, 9.68908515E-01, 1.61247689E+00, 1.83808190E+00,
     &   2.01565017E+00, 2.21356550E+00, 2.37966397E+00, 2.49945081E+00,
     &   2.60104409E+00, 2.64785429E+00, 2.66643932E+00, 2.64306388E+00,
     &   2.56023427E+00, 2.46486847E+00, 2.44682285E+00, 2.43744131E+00,
     &   2.41794777E+00, 2.40987399E+00, 2.40371380E+00, 2.39746315E+00,
     &   2.32986354E+00, 2.21029208E+00, 2.05029540E+00, 1.88077607E+00,
     &   1.66363902E+00, 1.41691385E+00, 1.17130023E+00, 1.02616148E+00,
     &   8.75539305E-01, 7.20114678E-01, 4.95923152E-01, 3.32231465E-01,
     &   1.66611821E-01, 6.67118223E-02, 3.33721748E-02, 5.84991711E-04,
     &   3.33381522E-02, 1.66577865E-01, 3.32197733E-01, 4.95889789E-01,
     &   1.22765545E+00, 1.49391281E+00, 1.92054541E+00, 2.08463271E+00,
     &   2.23879588E+00, 2.36481930E+00, 2.45595212E+00, 2.53475227E+00,
     &   2.58759387E+00, 2.62868654E+00, 2.65188008E+00, 2.66455594E+00,
     &   2.66594865E+00, 2.65819574E+00, 2.64425275E+00, 2.59816593E+00,
     &   2.56710384E+00, 2.53266508E+00, 2.49946066E+00, 2.42471223E+00/
  
         DATA ((DGS (I,J), I=1601,1700), J=2,2) /
     &   2.38380306E+00, 2.31736112E+00, 1.23704002E+00, 8.12176843E-01,
     &   6.01260582E-01, 4.76555529E-01, 3.94448787E-01, 3.36378108E-01,
     &   2.93165986E-01, 2.59768949E-01, 2.33189908E-01, 2.11537456E-01,
     &   1.93559699E-01, 1.78395327E-01, 1.65432453E-01, 1.54224495E-01,
     &   1.44437925E-01, 1.35818643E-01, 1.28169678E-01, 1.21335993E-01,
     &   1.15193895E-01, 7.75192613E-02, 5.16916640E-02, 3.87754591E-02,
     &   3.10254933E-02, 2.58589921E-02, 2.21688597E-02, 1.94014944E-02,
     &   1.72493246E-02, 1.55277991E-02, 1.41194745E-02, 1.29460539E-02,
     &   1.19533169E-02, 1.11025504E-02, 1.03653656E-02, 9.72046723E-03,
     &   9.15157020E-03, 8.64600841E-03, 8.19378434E-03, 7.78689990E-03,
     &   7.29978802E-03, 6.73166272E-03, 6.24653432E-03, 5.82751898E-03,
     &   5.46202620E-03, 5.14047842E-03, 3.97925177E-03, 3.25643492E-03,
     &   2.76537029E-03, 2.41163142E-03, 2.14665339E-03, 1.94363135E-03,
     &   1.77753890E-03, 1.64224687E-03, 8.63572990E-04, 8.48703211E-04,
     &   8.70706661E-04, 8.88135274E-04, 9.23558535E-04, 9.83301187E-04,
     &   1.02037609E-03, 1.07160170E-03, 1.20925150E-03, 1.44568366E-03,
     &   1.89729237E-03, 3.00514640E-03, 4.09852251E-03, 4.38315389E-03,
     &   4.71220005E-03, 5.09675357E-03, 5.55195444E-03, 6.09901276E-03,
     &   6.76853429E-03, 7.60645626E-03, 8.68496501E-03, 1.01242811E-02,
     &   1.21410255E-02, 1.51682884E-02, 2.02163937E-02, 2.10945537E-02,
     &   2.20524828E-02, 2.31017993E-02, 2.42560951E-02, 2.55317982E-02,
     &   2.69494418E-02, 2.85339159E-02, 3.03162902E-02, 3.23365648E-02,
     &   3.46454863E-02, 3.73093381E-02, 4.04174792E-02, 4.40906976E-02,
     &   4.84979209E-02, 5.38848118E-02, 5.55680831E-02, 6.06179189E-02,
     &   6.92726549E-02, 8.08111208E-02, 9.69596116E-02, 1.21167770E-01/
  
         DATA ((DGS (I,J), I=1701,1800), J=2,2) /
     &   1.61458652E-01, 2.41782275E-01, 4.79193439E-01, 5.69698698E-01,
     &   8.03547522E-01, 9.81384864E-01, 1.12791555E+00, 1.25580904E+00,
     &   1.36927652E+00, 1.47106782E+00, 1.56199263E+00, 1.64627060E+00,
     &   1.72586101E+00, 1.79859783E+00, 1.86257838E+00, 1.92176113E+00,
     &   1.97512130E+00, 2.02185838E+00, 2.06626224E+00, 2.10263443E+00,
     &   2.13103749E+00, 2.15515249E+00, 2.17371380E+00, 2.18521192E+00,
     &   2.18810468E+00, 2.18321704E+00, 2.16910226E+00, 2.14416192E+00,
     &   2.10666517E+00, 2.06451000E+00, 1.99922004E+00, 1.91616298E+00,
     &   1.81365015E+00, 1.66760631E+00, 1.49173499E+00, 1.25397132E+00,
     &   9.42407424E-01, 7.19344655E-04, 9.42392113E-01, 1.25395756E+00,
     &   1.49172285E+00, 1.66759568E+00, 1.81364107E+00, 1.91615523E+00,
     &   1.99921358E+00, 2.06450479E+00, 2.10666095E+00, 2.14415883E+00,
     &   2.16910025E+00, 2.18321602E+00, 2.18810459E+00, 2.18521269E+00,
     &   2.17371549E+00, 2.15515502E+00, 2.13104079E+00, 2.10263842E+00,
     &   2.06626695E+00, 2.02186381E+00, 1.97512737E+00, 1.92176783E+00,
     &   1.86258568E+00, 1.79860569E+00, 1.72586944E+00, 1.64627957E+00,
     &   1.56200211E+00, 1.47107777E+00, 1.36928693E+00, 1.25581991E+00,
     &   1.12792685E+00, 9.81396581E-01, 8.03559643E-01, 5.69711207E-01,
     &   4.79155053E-01, 2.41781983E-01, 1.61471504E-01, 1.21177335E-01,
     &   9.69703693E-02, 8.08239952E-02, 6.92855313E-02, 6.06299705E-02,
     &   5.38976906E-02, 4.85108005E-02, 4.41031407E-02, 4.04303603E-02,
     &   3.73222198E-02, 3.46580989E-02, 3.23494479E-02, 3.03291741E-02,
     &   2.02292844E-02, 1.51811881E-02, 1.21539358E-02, 1.01372024E-02,
     &   8.69787843E-03, 7.61941086E-03, 6.78155134E-03, 6.11210787E-03,
     &   5.56514445E-03, 5.11005399E-03, 4.72563787E-03, 4.39670680E-03/
  
         DATA ((DGS (I,J), I=1801,1900), J=2,2) /
     &   4.11217102E-03, 3.09607701E-03, 2.36556242E-03, 1.94059508E-03,
     &   1.66696477E-03, 1.47893718E-03, 1.34390748E-03, 1.24377085E-03,
     &   1.16774967E-03, 1.10902946E-03, 1.06304212E-03, 1.02666082E-03,
     &   9.97745136E-04, 9.74769748E-04, 9.56640190E-04, 9.42578760E-04,
     &   9.32058793E-04, 9.24781486E-04, 9.20711599E-04, 9.20248958E-04,
     &   9.21536514E-04, 9.20101657E-04, 9.19929754E-04, 1.15186574E-03,
     &   1.35832961E-03, 1.52738978E-03, 1.67069354E-03, 1.79248409E-03,
     &   1.89738027E-03, 1.98749314E-03, 2.06485386E-03, 2.13031391E-03,
     &   2.18533010E-03, 2.23086348E-03, 2.26709334E-03, 2.29445843E-03,
     &   2.31362172E-03, 2.32495308E-03, 2.32835512E-03, 2.32422566E-03,
     &   2.31264251E-03, 2.29324305E-03, 2.26651012E-03, 2.23297577E-03,
     &   2.19043703E-03, 2.14167742E-03, 2.08369870E-03, 2.01755544E-03,
     &   1.94171326E-03, 1.85596065E-03, 1.76032791E-03, 1.65518343E-03,
     &   1.53322855E-03, 1.39729122E-03, 1.24663777E-03, 1.07240430E-03,
     &   8.79231518E-04, 7.76507855E-04, 1.19262339E-03, 1.40693482E-03,
     &   1.57109466E-03, 1.70180357E-03, 1.81333312E-03, 1.90898561E-03,
     &   1.98829132E-03, 2.05783580E-03, 2.11792501E-03, 2.16902041E-03,
     &   2.21168014E-03, 2.24719069E-03, 2.27519270E-03, 2.29755055E-03,
     &   2.31293221E-03, 2.32254124E-03, 2.32611630E-03, 2.32361343E-03,
     &   2.31522816E-03, 2.30064998E-03, 2.27969508E-03, 2.25258295E-03,
     &   2.21883893E-03, 2.17779002E-03, 2.12903842E-03, 2.07292831E-03,
     &   2.00695597E-03, 1.93115801E-03, 1.84414186E-03, 1.74373968E-03,
     &   1.62772559E-03, 1.49100736E-03, 1.32845086E-03, 1.12417991E-03,
     &   8.47480675E-04, 8.42079555E-04, 8.00562167E-04, 7.85252633E-04,
     &   7.79558442E-04, 7.77243163E-04, 7.75534511E-04, 7.75455995E-04/
  
         DATA ((DGS (I,J), I=1901,2000), J=2,2) /
     &   7.76559853E-04, 7.77985783E-04, 7.79429097E-04, 7.80531127E-04,
     &   7.81200880E-04, 7.81616849E-04, 7.81527403E-04, 7.81054664E-04,
     &   7.80032065E-04, 7.78240621E-04, 7.75893339E-04, 7.72843109E-04,
     &   7.69136455E-04, 7.64769474E-04, 7.59668436E-04, 7.53674166E-04,
     &   7.46906676E-04, 7.39309809E-04, 7.30845917E-04, 7.21500852E-04,
     &   7.11229794E-04, 6.99967597E-04, 6.87475455E-04, 6.73797061E-04,
     &   6.59283031E-04, 6.41118606E-04, 6.21431147E-04, 6.00551732E-04,
     &   5.70779209E-04, 5.81695991E-04, 5.94637409E-04, 6.06642117E-04,
     &   6.18946201E-04, 6.30363737E-04, 6.40250287E-04, 6.49714763E-04,
     &   6.58754375E-04, 6.67125455E-04, 6.74941133E-04, 6.82260681E-04,
     &   6.89069217E-04, 6.95337837E-04, 7.01114251E-04, 7.06412455E-04,
     &   7.11165201E-04, 7.15460220E-04, 7.19309485E-04, 7.22679616E-04,
     &   7.25550478E-04, 7.27941290E-04, 7.29943355E-04, 7.31551129E-04,
     &   7.32813602E-04, 7.33687091E-04, 7.34104412E-04, 7.34172518E-04,
     &   7.34064964E-04, 7.33897036E-04, 7.33727293E-04, 7.33767616E-04,
     &   7.34412485E-04, 7.31916573E-04, 7.26828740E-04, 7.21147115E-04,
     &   7.02792881E-04, 7.02333446E-04, 7.01782651E-04, 7.01123845E-04,
     &   7.00324364E-04, 6.99374754E-04, 6.98297414E-04, 6.97077780E-04,
     &   6.95698984E-04, 6.91788719E-04, 6.87770542E-04, 6.83846422E-04,
     &   6.79964732E-04, 6.76056656E-04, 6.72053071E-04, 6.67965357E-04,
     &   6.63820147E-04, 6.59522459E-04, 6.55059507E-04, 6.50438817E-04,
     &   6.45574471E-04, 6.40589699E-04, 6.35410409E-04, 6.29968741E-04,
     &   6.24141681E-04, 6.18319140E-04, 6.12090137E-04, 6.05800795E-04,
     &   5.98357975E-04, 5.90638898E-04, 5.82810235E-04, 5.74914854E-04,
     &   5.65710462E-04, 5.55765163E-04, 5.45466288E-04, 5.31218368E-04/
  
         DATA ((DGS (I,J), I=2001,2100), J=2,2) /
     &   5.34357770E-04, 5.40229444E-04, 5.46939491E-04, 5.53548006E-04,
     &   5.59199407E-04, 5.65080933E-04, 5.71053248E-04, 5.76907650E-04,
     &   5.81679330E-04, 5.86518829E-04, 5.90995603E-04, 5.95404619E-04,
     &   5.99623173E-04, 6.03617323E-04, 6.07453288E-04, 6.11172320E-04,
     &   6.14667264E-04, 6.17959640E-04, 6.21158060E-04, 6.24164686E-04,
     &   6.27080713E-04, 6.29884928E-04, 6.32551851E-04, 6.35127129E-04,
     &   6.37670421E-04, 6.40212768E-04, 6.42669797E-04, 6.43922464E-04,
     &   6.45252297E-04, 6.46755663E-04, 6.48580366E-04, 6.50895269E-04,
     &   6.53047891E-04, 6.52152562E-04, 6.51103493E-04, 6.44659561E-04,
     &   6.41686186E-04, 6.47195835E-04, 6.61325025E-04, 6.85095011E-04,
     &   7.14536967E-04, 7.50993523E-04, 7.90606681E-04, 8.36207221E-04,
     &   8.86326066E-04, 9.38656402E-04, 9.99089658E-04, 1.06330468E-03,
     &   1.08892847E-03, 1.11455225E-03, 1.06478494E-03, 1.02009571E-03,
     &   9.82835617E-04, 9.48464216E-04, 9.19173943E-04, 8.91663925E-04,
     &   8.67861838E-04, 8.45215310E-04, 8.24538296E-04, 8.06361355E-04,
     &   7.88824138E-04, 7.73288345E-04, 7.58195811E-04, 7.44742250E-04,
     &   7.31598647E-04, 7.19821849E-04, 7.08261998E-04, 6.97859130E-04,
     &   6.87606856E-04, 6.78346256E-04, 6.69575721E-04, 6.60888775E-04,
     &   6.53005532E-04, 6.45175347E-04, 6.38050436E-04, 6.30955636E-04,
     &   6.24484484E-04, 6.18026160E-04, 6.12122938E-04, 6.06219467E-04,
     &   6.00812983E-04, 5.95396330E-04, 5.90205810E-04, 5.85439925E-04,
     &   5.80653245E-04, 5.76251415E-04, 5.71823877E-04, 5.67746561E-04,
     &   5.63639870E-04, 5.59853082E-04, 5.56034221E-04, 5.52508577E-04,
     &   5.48948920E-04, 5.45658872E-04, 5.42475700E-04, 5.39256694E-04,
     &   5.36276904E-04, 5.33260597E-04, 5.30465774E-04, 5.27634081E-04/
  
         DATA ((DGS (I,J), I=2101,2164), J=2,2) /
     &   5.25007958E-04, 5.22344244E-04, 5.19872383E-04, 5.17363675E-04,
     &   5.15033260E-04, 5.12666267E-04, 5.10369000E-04, 5.08229322E-04,
     &   5.06055355E-04, 5.03974100E-04, 5.01915167E-04, 4.99997813E-04,
     &   4.98045655E-04, 4.96226583E-04, 4.94373348E-04, 4.92645414E-04,
     &   4.90883992E-04, 4.89240720E-04, 4.87564659E-04, 4.86000161E-04,
     &   4.84472195E-04, 4.82912507E-04, 4.81455509E-04, 4.79967512E-04,
     &   4.78576799E-04, 4.77155812E-04, 4.75827098E-04, 4.74468831E-04,
     &   4.73198187E-04, 4.71898703E-04, 4.70682518E-04, 4.69438196E-04,
     &   4.57485006E-04, 4.47845616E-04, 4.46474962E-04, 4.09033369E-04,
     &   4.00280662E-04, 3.86590735E-04, 3.82016002E-04, 3.81828933E-04,
     &   3.77618450E-04, 3.77607496E-04, 3.75336033E-04, 3.75260660E-04,
     &   3.75215926E-04, 3.74304705E-04, 3.73757920E-04, 3.73664525E-04,
     &   3.73514779E-04, 3.73299238E-04, 3.73151596E-04, 3.73060775E-04,
     &   3.72246455E-04, 3.72208219E-04, 3.71990434E-04, 3.71950656E-04,
     &   3.71778199E-04, 3.71716029E-04, 3.71663798E-04, 3.71615521E-04,
     &   3.71473291E-04, 3.71301757E-04, 3.71200807E-04, 3.70709202E-04/

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 02:59:41 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: 1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 4,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c
c replaced March 30, 2012 [dalhads.dat;425]
  
         DATA ((DGS3(I,J), I=   1, 100), J=1,1) /
     &  -9.01504002E-04,-9.59018058E-04,-1.01562315E-03,-1.07504151E-03,
     &  -1.13931003E-03,-1.17060612E-03,-1.22420842E-03,-1.32081669E-03,
     &  -1.35755384E-03,-1.39423134E-03,-1.44993336E-03,-1.50341604E-03,
     &  -1.56426686E-03,-1.60428770E-03,-1.65379349E-03,-1.70417749E-03,
     &  -1.75416353E-03,-1.80423443E-03,-1.84524451E-03,-1.89944629E-03,
     &  -1.94363073E-03,-1.99755571E-03,-2.04117231E-03,-2.09884757E-03,
     &  -2.14639356E-03,-2.19257698E-03,-2.25102421E-03,-2.28331703E-03,
     &  -2.29894700E-03,-2.34821685E-03,-2.39846497E-03,-2.44763065E-03,
     &  -2.49839468E-03,-2.55116432E-03,-2.60526365E-03,-2.66055376E-03,
     &  -2.71683974E-03,-2.77452686E-03,-2.83435915E-03,-2.89666549E-03,
     &  -2.94410288E-03,-3.00694198E-03,-3.06978567E-03,-3.11772476E-03,
     &  -3.18332832E-03,-3.24997931E-03,-3.30225455E-03,-3.37164381E-03,
     &  -3.42893894E-03,-3.50535006E-03,-3.92922900E-03,-4.38568301E-03,
     &  -5.02403822E-03,-5.83626950E-03,-6.10354518E-03,-6.17916230E-03,
     &  -6.37777800E-03,-6.66399432E-03,-6.96428787E-03,-7.26281350E-03,
     &  -7.56833455E-03,-7.68118619E-03,-7.86290951E-03,-8.16345949E-03,
     &  -8.41052477E-03,-8.64882562E-03,-8.84437476E-03,-8.98658056E-03,
     &  -9.00551229E-03,-9.00044147E-03,-8.97242974E-03,-8.92751747E-03,
     &  -8.69489502E-03,-8.29212768E-03,-7.72099372E-03,-6.89248031E-03,
     &  -5.84278496E-03,-4.53680521E-03,-3.23461933E-03,-2.77096610E-03,
     &  -1.49537774E-03,-8.99112123E-04,-2.50745330E-04, 2.41687584E-04,
     &   9.98558868E-04, 1.86539302E-03, 2.37094566E-03, 2.71326195E-03,
     &   2.98807041E-03, 3.23064547E-03, 3.41128197E-03, 3.54789512E-03,
     &   3.70333641E-03, 3.85445465E-03, 3.97436483E-03, 4.18975588E-03,
     &   4.28959024E-03, 4.36607134E-03, 4.47123187E-03, 4.56180288E-03/
  
         DATA ((DGS3(I,J), I= 101, 200), J=1,1) /
     &   4.64591350E-03, 4.71895366E-03, 4.78516055E-03, 4.84332404E-03,
     &   4.89877997E-03, 4.94946923E-03, 4.99409962E-03, 5.04141061E-03,
     &   5.07212755E-03, 5.09997140E-03, 5.13336220E-03, 5.15882544E-03,
     &   5.17004126E-03, 5.18035524E-03, 5.19767470E-03, 5.21139550E-03,
     &   5.22273809E-03, 5.23344238E-03, 5.25279882E-03, 5.26588486E-03,
     &   5.29176285E-03, 5.32306647E-03, 5.35894778E-03, 5.39903215E-03,
     &   5.44348610E-03, 5.49240407E-03, 5.54690481E-03, 5.60890559E-03,
     &   5.67893074E-03, 5.75119722E-03, 5.82729695E-03, 5.90716192E-03,
     &   5.98627621E-03, 6.06785070E-03, 6.15728647E-03, 6.24060631E-03,
     &   6.31488327E-03, 6.36295149E-03, 6.38188693E-03, 6.39977999E-03,
     &   6.43813508E-03, 6.49619219E-03, 6.55517961E-03, 6.62600378E-03,
     &   6.70731474E-03, 6.79180146E-03, 6.88518025E-03, 6.97223209E-03,
     &   7.08305562E-03, 7.14629851E-03, 7.24956420E-03, 7.39755777E-03,
     &   7.43405822E-03, 7.60946725E-03, 7.76889322E-03, 7.97241054E-03,
     &   8.14177477E-03, 8.21143236E-03, 8.29942240E-03, 8.34865170E-03,
     &   8.39614063E-03, 8.45123562E-03, 8.45970269E-03, 8.46380101E-03,
     &   8.44365618E-03, 8.47030875E-03, 8.39273935E-03, 8.36979966E-03,
     &   8.21197292E-03, 8.01468750E-03, 7.76311225E-03, 7.52608043E-03,
     &   7.20278256E-03, 6.86503898E-03, 6.46205287E-03, 6.15797032E-03,
     &   5.72712541E-03, 5.29750103E-03, 4.91735669E-03, 4.68859608E-03,
     &   4.24501094E-03, 4.04542262E-03, 3.53788001E-03, 3.08967022E-03,
     &   2.53320518E-03, 2.01861807E-03, 1.35932784E-03, 7.64394499E-04,
     &   1.08082071E-04,-7.67652616E-04,-1.23739459E-03,-1.57221781E-03,
     &  -2.29376473E-03,-2.67568362E-03,-3.07777060E-03,-3.51954470E-03,
     &  -4.01483002E-03,-4.51468643E-03,-5.04670544E-03,-6.20806394E-03/
  
         DATA ((DGS3(I,J), I= 201, 300), J=1,1) /
     &  -7.54725094E-03,-8.33870523E-03,-8.63921626E-03,-8.93812297E-03,
     &  -9.25541971E-03,-9.58289549E-03,-9.88342653E-03,-1.02870824E-02,
     &  -1.06582642E-02,-1.10464634E-02,-1.14479944E-02,-1.18709302E-02,
     &  -1.23116510E-02,-1.27663234E-02,-1.32465788E-02,-1.37430166E-02,
     &  -1.42878479E-02,-1.48496977E-02,-1.54103744E-02,-1.60183823E-02,
     &  -1.66669528E-02,-1.73495450E-02,-1.80793141E-02,-1.88619449E-02,
     &  -1.96970500E-02,-2.05938038E-02,-2.15600775E-02,-2.26164383E-02,
     &  -2.37757495E-02,-2.50764754E-02,-2.57221420E-02,-2.66063962E-02,
     &  -2.73568788E-02,-2.83119731E-02,-3.05856833E-02,-3.12966222E-02,
     &  -3.30089072E-02,-3.48180007E-02,-3.68634558E-02,-3.88057479E-02,
     &  -4.10538242E-02,-4.35144965E-02,-4.57399146E-02,-5.19726659E-02,
     &  -5.24801524E-02,-5.61376615E-02,-6.02939765E-02,-6.49671819E-02,
     &  -7.03025081E-02,-7.63992847E-02,-8.34310078E-02,-9.15650773E-02,
     &  -1.00964159E-01,-1.10033449E-01,-1.14990797E-01,-1.18368906E-01,
     &  -1.21786003E-01,-1.25259060E-01,-1.23925213E-01,-1.32147155E-01,
     &  -1.35439413E-01,-1.38412836E-01,-1.41026171E-01,-1.43075934E-01,
     &  -1.44349991E-01,-1.44489219E-01,-1.41933257E-01,-1.37555869E-01,
     &  -1.34483672E-01,-1.26123252E-01,-1.14453794E-01,-9.91095709E-02,
     &  -8.00151841E-02,-5.74095694E-02,-3.19646265E-02,-4.75690824E-03,
     &   2.28233023E-02, 4.94019047E-02, 7.36828979E-02, 9.47587429E-02,
     &   1.12186226E-01, 1.25843717E-01, 1.36000618E-01, 1.43018469E-01,
     &   1.47431411E-01, 1.49696579E-01, 1.50285639E-01, 1.49607291E-01,
     &   1.47951478E-01, 1.45625647E-01, 1.41424621E-01, 1.37159062E-01,
     &   1.34255844E-01, 1.32747337E-01, 1.29522734E-01, 1.26071093E-01,
     &   1.22666624E-01, 1.19335520E-01, 1.16100971E-01, 1.12951869E-01/
  
         DATA ((DGS3(I,J), I= 301, 400), J=1,1) /
     &   1.12592594E-01, 1.06996455E-01, 1.04183864E-01, 1.01470952E-01,
     &   9.28523355E-02, 8.54207467E-02, 7.89983795E-02, 7.34204701E-02,
     &   6.85697458E-02, 6.33436641E-02, 6.05275053E-02, 5.71866854E-02,
     &   5.42128434E-02, 5.15565212E-02, 4.91375444E-02, 4.69738143E-02,
     &   4.50350626E-02, 4.32144141E-02, 4.15895481E-02, 4.00961797E-02,
     &   3.87626638E-02, 3.75473146E-02, 3.76062113E-02, 3.54138050E-02,
     &   3.45940088E-02, 3.46133647E-02, 3.51008600E-02, 3.39792836E-02,
     &   3.27593177E-02, 3.19179496E-02, 3.11479057E-02, 3.04534618E-02,
     &   2.97913983E-02, 2.91685141E-02, 2.85839073E-02, 2.80243894E-02,
     &   2.74940815E-02, 2.69931018E-02, 2.65088208E-02, 2.60424369E-02,
     &   2.56204084E-02, 2.51871435E-02, 2.47878268E-02, 2.43986428E-02,
     &   2.40264949E-02, 2.36691657E-02, 2.33214491E-02, 2.29859622E-02,
     &   2.26657404E-02, 2.23566544E-02, 2.20422376E-02, 2.17516288E-02,
     &   2.14817338E-02, 2.11701118E-02, 2.09149431E-02, 2.06418496E-02,
     &   1.99316367E-02, 1.83736003E-02, 1.59823607E-02, 1.42874170E-02,
     &   1.29680836E-02, 1.19374672E-02, 1.10584538E-02, 1.03090677E-02,
     &   9.70648291E-03, 9.64208178E-03, 8.95551303E-03, 8.50448079E-03,
     &   8.37073192E-03, 8.01980573E-03, 7.69787077E-03, 7.66529668E-03,
     &   7.38958947E-03, 7.09852307E-03, 6.95556275E-03, 6.83264772E-03,
     &   6.58586859E-03, 6.39064206E-03, 6.21283430E-03, 6.05399756E-03,
     &   5.97185289E-03, 5.91246009E-03, 5.79668563E-03, 5.67631978E-03,
     &   5.67042717E-03, 5.57240963E-03, 5.47884809E-03, 5.43295236E-03,
     &   5.39490546E-03, 5.30985733E-03, 5.25345361E-03, 5.16034188E-03,
     &   5.13048504E-03, 5.06231728E-03, 4.99935952E-03, 4.89932464E-03,
     &   4.76105017E-03, 4.62516587E-03, 4.61091276E-03, 4.52249653E-03/
  
         DATA ((DGS3(I,J), I= 401, 500), J=1,1) /
     &   4.35356575E-03, 4.28196441E-03, 4.19935280E-03, 4.13161422E-03,
     &   4.12049247E-03, 4.00508872E-03, 4.02176251E-03, 4.03441679E-03,
     &   4.04931553E-03, 4.08051746E-03, 4.07296614E-03, 4.02375825E-03,
     &   4.01508920E-03, 3.90991953E-03, 3.89522024E-03, 3.82535801E-03,
     &   3.76548368E-03, 3.55308358E-03, 3.51390816E-03, 3.28744478E-03,
     &   3.26890323E-03, 3.25264433E-03, 3.07522623E-03, 2.87773972E-03,
     &   2.83305112E-03, 2.53655459E-03, 2.51205712E-03, 2.38675334E-03,
     &   2.36270298E-03, 2.23265801E-03, 2.18435646E-03, 2.10420713E-03,
     &   2.10260801E-03, 2.17788559E-03, 2.34526302E-03, 2.47620897E-03,
     &   2.50253774E-03, 2.89110248E-03, 2.94850562E-03, 3.21306587E-03,
     &   3.34396519E-03, 3.38776161E-03, 3.41663449E-03, 3.42917240E-03,
     &   3.53092028E-03, 3.55121031E-03, 3.62125293E-03, 3.70050094E-03,
     &   3.74377216E-03, 3.90086788E-03, 4.07995193E-03, 4.14159993E-03,
     &   4.16508804E-03, 4.32107901E-03, 4.40586289E-03, 4.49535515E-03,
     &   4.92881015E-03, 4.98564589E-03, 5.12793634E-03, 5.19124081E-03,
     &   5.21743690E-03, 5.21669520E-03, 5.21472720E-03, 5.20613908E-03,
     &   5.19882338E-03, 5.17205061E-03, 5.13275243E-03, 5.12942498E-03,
     &   5.16588251E-03, 5.22949175E-03, 5.23796865E-03, 5.33040087E-03,
     &   5.37091907E-03, 5.39584617E-03, 5.39802796E-03, 5.40266825E-03,
     &   5.40233871E-03, 5.38266935E-03, 5.35682560E-03, 5.27630883E-03,
     &   5.26036228E-03, 5.09444473E-03, 5.00804327E-03, 4.94370421E-03,
     &   4.74540895E-03, 4.48425628E-03, 4.42403644E-03, 4.37172512E-03,
     &   4.32222492E-03, 4.31026489E-03, 4.28151006E-03, 4.27561069E-03,
     &   4.25882151E-03, 4.23035700E-03, 4.19803434E-03, 4.18317651E-03,
     &   3.94370680E-03, 3.69720448E-03, 3.54042244E-03, 3.73081432E-03/
  
         DATA ((DGS3(I,J), I= 501, 600), J=1,1) /
     &   3.68139189E-03, 4.11914473E-03, 4.99368154E-03, 5.29684792E-03,
     &   5.45926270E-03, 5.62775540E-03, 5.62067949E-03, 5.54565246E-03,
     &   5.44524554E-03, 5.35900996E-03, 5.25565401E-03, 5.11164544E-03,
     &   4.90408178E-03, 4.61265108E-03, 4.17929269E-03, 3.50763959E-03,
     &   3.32780020E-03, 3.13053658E-03, 2.90594415E-03, 2.65265415E-03,
     &   2.36879457E-03, 2.03912210E-03, 1.65754841E-03, 1.57396088E-03,
     &   1.48775571E-03, 1.39839812E-03, 1.30640504E-03, 1.21111678E-03,
     &   1.11251880E-03, 1.01034705E-03, 9.04770477E-04, 7.95174518E-04,
     &   6.81489543E-04, 1.15679918E-04,-3.25826083E-04,-5.68505156E-04,
     &  -7.39700955E-04,-9.18994838E-04,-1.10691117E-03,-1.30414111E-03,
     &  -1.51135552E-03,-1.72933557E-03,-1.84261004E-03,-1.95889560E-03,
     &  -2.07831330E-03,-2.20093447E-03,-2.32722451E-03,-2.45684989E-03,
     &  -2.59001196E-03,-2.72716334E-03,-2.86833107E-03,-3.01369391E-03,
     &  -3.16344161E-03,-3.31777590E-03,-3.47691152E-03,-3.64108862E-03,
     &  -3.81059569E-03,-3.98554215E-03,-4.16671467E-03,-4.35353802E-03,
     &  -4.54694842E-03,-4.74711590E-03,-4.95440314E-03,-5.16919801E-03,
     &  -5.39191730E-03,-5.62300924E-03,-5.86295680E-03,-6.11243706E-03,
     &  -6.37152674E-03,-6.64131883E-03,-6.92233948E-03,-7.21533094E-03,
     &  -7.52104438E-03,-7.84030626E-03,-8.17403823E-03,-8.52325506E-03,
     &  -8.88917985E-03,-9.27269017E-03,-9.66956113E-03,-1.00929139E-02,
     &  -1.05385438E-02,-1.10082637E-02,-1.12527664E-02,-1.15040550E-02,
     &  -1.17624288E-02,-1.20282216E-02,-1.23017134E-02,-1.25832403E-02,
     &  -1.28732080E-02,-1.31717236E-02,-1.34797947E-02,-1.37973439E-02,
     &  -1.41247695E-02,-1.44631060E-02,-1.48123942E-02,-1.51733311E-02,
     &  -1.55465115E-02,-1.59325663E-02,-1.63321748E-02,-1.67460652E-02/
  
         DATA ((DGS3(I,J), I= 601, 700), J=1,1) /
     &  -1.71750151E-02,-1.76198673E-02,-1.80813056E-02,-1.85607827E-02,
     &  -1.90591193E-02,-1.95773933E-02,-2.01168489E-02,-2.06788472E-02,
     &  -2.12648022E-02,-2.18763077E-02,-2.25149948E-02,-2.31829448E-02,
     &  -2.38818950E-02,-2.46142150E-02,-2.53823768E-02,-2.61888801E-02,
     &  -2.70370412E-02,-2.79300351E-02,-2.88714749E-02,-2.98653791E-02,
     &  -3.13538401E-02,-3.20292891E-02,-3.32100046E-02,-3.44648423E-02,
     &  -3.58009841E-02,-3.72266103E-02,-3.87510567E-02,-4.03850027E-02,
     &  -4.21406676E-02,-4.40321429E-02,-4.60758604E-02,-4.82909730E-02,
     &  -5.06999974E-02,-5.26230012E-02,-5.86132677E-02,-6.59483655E-02,
     &  -7.51386673E-02,-8.69901586E-02,-1.02854682E-01,-1.25186477E-01,
     &  -1.58952498E-01,-2.15956004E-01,-3.32752176E-01,-7.06688306E-01,
     &  -7.47644815E-01,-7.93574595E-01,-8.45438163E-01,-9.04459684E-01,
     &  -9.72222892E-01,-1.05081290E+00,-1.14303002E+00,-1.25272220E+00,
     &  -1.38531918E+00,-1.54872508E+00,-1.75487849E+00,-2.02261869E+00,
     &  -2.38327516E+00,-2.42627455E+00,-3.38909101E+00,-4.09085858E+00,
     &  -4.65468828E+00,-5.14504733E+00,-5.52290803E+00,-5.85306271E+00,
     &  -6.11765867E+00,-6.38125484E+00,-6.56232979E+00,-6.72999022E+00,
     &  -6.84829745E+00,-6.94582844E+00,-7.00063614E+00,-7.04154631E+00,
     &  -7.04502509E+00,-7.02443585E+00,-6.96733855E+00,-6.90562985E+00,
     &  -6.77215312E+00,-6.65255904E+00,-6.50575861E+00,-6.32944224E+00,
     &  -6.12139529E+00,-5.87958048E+00,-5.60223659E+00,-5.28798692E+00,
     &  -4.93595795E+00,-4.54589672E+00,-4.11828435E+00,-3.40957295E+00,
     &  -2.89580589E+00,-2.07224516E+00,-1.19964034E+00, 1.21147999E+00,
     &   3.42151606E+00, 4.13028603E+00, 4.75773675E+00, 5.12883966E+00,
     &   5.61442056E+00, 5.89181241E+00, 6.13367477E+00, 6.34176842E+00/
  
         DATA ((DGS3(I,J), I= 701, 800), J=1,1) /
     &   6.51813061E+00, 6.66497569E+00, 6.78461260E+00, 6.87937534E+00,
     &   6.95156635E+00, 7.00341578E+00, 7.03704999E+00, 7.05768967E+00,
     &   7.05424213E+00, 7.02738276E+00, 6.97885499E+00, 6.93660171E+00,
     &   6.83324747E+00, 6.74287157E+00, 6.61011022E+00, 6.46776459E+00,
     &   6.28204914E+00, 6.09272245E+00, 5.82871551E+00, 5.57185786E+00,
     &   5.25803989E+00, 4.90410393E+00, 4.44885772E+00, 3.92698010E+00,
     &   3.27533548E+00, 2.70008144E+00, 2.25323819E+00, 1.93081059E+00,
     &   1.68803726E+00, 1.49900317E+00, 1.34781119E+00, 1.22421824E+00,
     &   1.12134673E+00, 1.03441412E+00, 9.60002029E-01, 8.95596789E-01,
     &   8.39313958E-01, 7.89712570E-01, 7.45672815E-01, 7.06311187E-01,
     &   6.70921490E-01, 6.38932572E-01, 6.09877584E-01, 3.22807977E-01,
     &   2.20819116E-01, 1.68572453E-01, 1.36813787E-01, 1.15467618E-01,
     &   1.00134208E-01, 8.85865752E-02, 7.95765676E-02, 7.23525549E-02,
     &   6.64281216E-02, 6.57264051E-02, 6.08308194E-02, 5.66850394E-02,
     &   5.31276309E-02, 5.00416150E-02, 4.73391006E-02, 4.49551881E-02,
     &   4.28325951E-02, 4.09323756E-02, 3.92209071E-02, 3.76717426E-02,
     &   3.62628237E-02, 3.49758087E-02, 3.37955313E-02, 3.27092104E-02,
     &   3.17060989E-02, 3.07769093E-02, 2.99139132E-02, 2.91101192E-02,
     &   2.83596589E-02, 2.76573686E-02, 2.69988525E-02, 2.63801099E-02,
     &   2.57975923E-02, 2.52482040E-02, 2.47292025E-02, 2.42448572E-02,
     &   2.37795689E-02, 2.33381044E-02, 2.29186500E-02, 2.25099716E-02,
     &   2.21297902E-02, 2.17672061E-02, 2.14210316E-02, 2.10902118E-02,
     &   2.07737228E-02, 2.04707418E-02, 2.01803473E-02, 1.99017686E-02,
     &   1.96342989E-02, 1.93915669E-02, 1.91444454E-02, 1.89066773E-02,
     &   1.86776710E-02, 1.84570325E-02, 1.82443123E-02, 1.80390595E-02/
  
         DATA ((DGS3(I,J), I= 801, 900), J=1,1) /
     &   1.78408706E-02, 1.76494430E-02, 1.74644166E-02, 1.72854826E-02,
     &   1.71123442E-02, 1.69447604E-02, 1.67825154E-02, 1.66253501E-02,
     &   1.64730101E-02, 1.63252893E-02, 1.61781278E-02, 1.60390943E-02,
     &   1.59041356E-02, 1.57730939E-02, 1.56458319E-02, 1.55222395E-02,
     &   1.54022013E-02, 1.52855468E-02, 1.51721776E-02, 1.50619862E-02,
     &   1.49548785E-02, 1.48507738E-02, 1.47496000E-02, 1.46512966E-02,
     &   1.45558396E-02, 1.44668596E-02, 1.43770043E-02, 1.42899451E-02,
     &   1.42056708E-02, 1.41242272E-02, 1.40456951E-02, 1.39702002E-02,
     &   1.38979283E-02, 1.38291697E-02, 1.37643111E-02, 1.37039240E-02,
     &   1.34308381E-02, 1.33565144E-02, 1.32837324E-02, 1.32124490E-02,
     &   1.31426264E-02, 1.30742412E-02, 1.30074736E-02, 1.29417571E-02,
     &   1.28778278E-02, 1.28230583E-02, 1.27520882E-02, 1.26905295E-02,
     &   1.26304240E-02, 1.25711430E-02, 1.25132005E-02, 1.24563362E-02,
     &   1.24005309E-02, 1.23457449E-02, 1.22919301E-02, 1.22390586E-02,
     &   1.06446571E-02, 9.58730013E-03, 8.77168849E-03, 8.25370890E-03,
     &   7.75078743E-03, 7.47870402E-03, 7.13693982E-03, 6.69390796E-03,
     &   6.27055738E-03, 5.62770976E-03, 5.15420660E-03, 4.69564117E-03,
     &   5.13355453E-03, 5.23137244E-03, 4.76700476E-03, 4.31171693E-03,
     &   3.82116977E-03, 3.26526675E-03, 2.61244707E-03, 1.82120232E-03,
     &   8.30018509E-04, 3.57233164E-04,-1.71608893E-04,-7.67780799E-04,
     &  -1.44575273E-03,-2.22442111E-03,-3.12890159E-03,-3.63856256E-03,
     &  -4.19343757E-03,-4.79996105E-03,-5.46584695E-03,-6.20042381E-03,
     &  -7.01506712E-03,-7.92385558E-03,-8.94432015E-03,-1.00986673E-02,
     &  -1.14153525E-02,-1.29315733E-02,-1.46968018E-02,-1.66879345E-02,
     &  -1.79905817E-02,-1.94353622E-02,-2.10469868E-02,-2.28562459E-02/
  
         DATA ((DGS3(I,J), I= 901,1000), J=1,1) /
     &  -2.49020011E-02,-2.72340143E-02,-2.99170565E-02,-3.30370243E-02,
     &  -3.67103229E-02,-4.10986674E-02,-4.64335868E-02,-5.30585144E-02,
     &  -6.15056103E-02,-7.26457262E-02,-8.80079599E-02,-1.10543172E-01,
     &  -1.46760087E-01,-2.14276345E-01,-3.20460275E-01,-3.80894540E-01,
     &  -4.46812492E-01,-6.09000158E-01,-6.67432255E-01,-7.15657491E-01,
     &  -7.56611871E-01,-7.91097782E-01,-8.19391704E-01,-8.43754260E-01,
     &  -8.63702495E-01,-8.77979474E-01,-8.90108408E-01,-8.98694610E-01,
     &  -9.03787330E-01,-9.05626731E-01,-9.04320710E-01,-9.00751806E-01,
     &  -8.93508713E-01,-8.84030729E-01,-8.71254895E-01,-8.54817157E-01,
     &  -8.37532734E-01,-8.13316067E-01,-7.88832484E-01,-7.60692099E-01,
     &  -7.28714307E-01,-6.86362643E-01,-6.45623289E-01,-5.92858781E-01,
     &  -5.43177901E-01,-4.70745561E-01,-3.91696871E-01,-2.73632428E-01,
     &  -1.70719032E-01,-5.21769450E-02, 7.86735114E-03, 6.79123692E-02,
     &   1.27569961E-01, 2.89383526E-01, 4.07465338E-01, 4.86529687E-01,
     &   5.58979682E-01, 6.08674791E-01, 6.61456697E-01, 7.02211408E-01,
     &   7.44581216E-01, 7.76574616E-01, 8.04730505E-01, 8.29229361E-01,
     &   8.53463472E-01, 8.70762397E-01, 8.87216500E-01, 9.00008004E-01,
     &   9.09500952E-01, 9.16760193E-01, 9.20342461E-01, 9.21664563E-01,
     &   9.19840063E-01, 9.14762594E-01, 9.06191626E-01, 8.94077704E-01,
     &   8.79814163E-01, 8.59880828E-01, 8.35532854E-01, 8.07252851E-01,
     &   7.72781024E-01, 7.31840508E-01, 6.83628827E-01, 6.25210214E-01,
     &   5.54388242E-01, 5.92838150E-01, 4.63048898E-01, 3.36709497E-01,
     &   2.87596324E-01, 1.89033474E-01, 1.41564206E-01, 1.13753318E-01,
     &   9.55070889E-02, 8.26215084E-02, 7.30386185E-02, 6.56335446E-02,
     &   5.97397258E-02, 5.49372951E-02, 5.09486602E-02, 4.75829650E-02/
  
         DATA ((DGS3(I,J), I=1001,1100), J=1,1) /
     &   4.47047090E-02, 4.22150161E-02, 4.00400593E-02, 3.81236055E-02,
     &   3.64220512E-02, 3.49011278E-02, 3.35333824E-02, 3.13698616E-02,
     &   2.86661722E-02, 2.72172026E-02, 2.48409463E-02, 2.29718693E-02,
     &   2.11188187E-02, 1.84746788E-02, 1.55641238E-02, 1.37318800E-02,
     &   1.29092291E-02, 1.24164620E-02, 1.20781702E-02, 1.18277572E-02,
     &   1.16317353E-02, 1.14730200E-02, 1.13411333E-02, 1.12294615E-02,
     &   1.11334018E-02, 1.10501107E-02, 1.09771320E-02, 1.09128168E-02,
     &   1.08559879E-02, 1.08054843E-02, 1.07606936E-02, 1.07210418E-02,
     &   1.06857864E-02, 1.06549327E-02, 1.06277198E-02, 1.06044553E-02,
     &   1.05844079E-02, 1.05679282E-02, 1.05550718E-02, 1.05450793E-02,
     &   1.05391267E-02, 1.05367439E-02, 1.05391358E-02, 1.05458668E-02,
     &   1.05584294E-02, 1.05786380E-02, 1.06101608E-02, 1.06622453E-02,
     &   1.08343463E-02, 1.10648977E-02, 1.11750534E-02, 1.12645395E-02,
     &   1.13426946E-02, 1.14132448E-02, 1.14776941E-02, 1.15371624E-02,
     &   1.15922735E-02, 1.16434149E-02, 1.16909301E-02, 1.17341735E-02,
     &   1.17741229E-02, 1.18104880E-02, 1.18438354E-02, 1.18823219E-02,
     &   1.18921565E-02, 1.19066628E-02, 1.19174872E-02, 1.19234830E-02,
     &   1.19240041E-02, 1.19184590E-02, 1.19059293E-02, 1.18865197E-02,
     &   1.18586361E-02, 1.18214825E-02, 1.17739823E-02, 1.17147854E-02,
     &   1.16420946E-02, 1.15532633E-02, 1.14450157E-02, 1.13145735E-02,
     &   1.11530715E-02, 1.09180832E-02, 1.05688996E-02, 1.04656505E-02,
     &   1.01831330E-02, 9.74736072E-03, 9.70090434E-03, 9.38993695E-03,
     &   9.26763402E-03, 9.14752766E-03, 9.05113336E-03, 8.93933667E-03,
     &   8.76937527E-03, 8.69911767E-03, 8.70566256E-03, 8.58566104E-03,
     &   8.58906961E-03, 8.73475535E-03, 8.66465847E-03, 8.74974719E-03/
  
         DATA ((DGS3(I,J), I=1101,1200), J=1,1) /
     &   8.66020321E-03, 8.52200992E-03, 8.66201142E-03, 8.48395424E-03,
     &   8.13206503E-03, 8.03408678E-03, 8.15242261E-03, 8.16101109E-03,
     &   8.13824083E-03, 8.05791683E-03, 7.81791712E-03, 7.70481515E-03,
     &   7.44080042E-03, 7.22547494E-03, 7.12914577E-03, 7.29051994E-03,
     &   7.56270051E-03, 8.13492869E-03, 8.33917665E-03, 8.59262690E-03,
     &   8.75373373E-03, 8.93155985E-03, 8.98097805E-03, 8.97411933E-03,
     &   9.22042347E-03, 9.44723446E-03, 9.39584419E-03, 9.37206165E-03,
     &   9.40940999E-03, 9.43929406E-03, 9.46240769E-03, 9.45347609E-03,
     &   9.46847972E-03, 9.46521110E-03, 9.39677402E-03, 9.36572218E-03,
     &   9.38083860E-03, 9.42834476E-03, 9.48799874E-03, 9.63972827E-03,
     &   9.71063288E-03, 9.71502121E-03, 9.71300355E-03, 9.65818729E-03,
     &   9.51157937E-03, 9.50457232E-03, 9.64304576E-03, 9.80404602E-03,
     &   9.94901234E-03, 9.95960973E-03, 1.00199883E-02, 1.01108895E-02,
     &   1.02027484E-02, 1.03652179E-02, 1.05354002E-02, 1.06074831E-02,
     &   1.06790408E-02, 1.07953403E-02, 1.08707783E-02, 1.08090545E-02,
     &   1.06753057E-02, 1.06307417E-02, 1.07120383E-02, 1.06859070E-02,
     &   1.04556696E-02, 1.03802847E-02, 1.04294331E-02, 1.04305017E-02,
     &   1.01538431E-02, 9.87593973E-03, 9.78797796E-03, 9.74777455E-03,
     &   9.71527368E-03, 9.68607449E-03, 9.52599411E-03, 9.44859306E-03,
     &   9.47721239E-03, 9.46950231E-03, 9.35374349E-03, 9.12663928E-03,
     &   9.09649244E-03, 9.03677169E-03, 9.08275642E-03, 9.10106433E-03,
     &   9.14075339E-03, 9.17846087E-03, 9.19126702E-03, 9.20097314E-03,
     &   9.16127655E-03, 9.09817168E-03, 9.05070347E-03, 9.27318356E-03,
     &   9.45389185E-03, 9.44759197E-03, 9.46691568E-03, 9.47460132E-03,
     &   9.46121306E-03, 9.64783459E-03, 9.90965134E-03, 9.98187378E-03/
  
         DATA ((DGS3(I,J), I=1201,1300), J=1,1) /
     &   9.97639254E-03, 1.00065742E-02, 1.00281574E-02, 1.00676262E-02,
     &   1.01090367E-02, 1.00926183E-02, 1.00686552E-02, 1.00567375E-02,
     &   9.91489652E-03, 9.88519036E-03, 9.94834537E-03, 9.97553605E-03,
     &   9.91168264E-03, 9.87731217E-03, 9.87515116E-03, 9.89033552E-03,
     &   9.90039394E-03, 1.00662839E-02, 1.02433836E-02, 1.02888786E-02,
     &   1.02985111E-02, 1.03105950E-02, 1.03522073E-02, 1.03660806E-02,
     &   1.04846017E-02, 1.06539787E-02, 1.07235351E-02, 1.07874163E-02,
     &   1.09034953E-02, 1.10086892E-02, 1.10582045E-02, 1.11060048E-02,
     &   1.11522687E-02, 1.11971372E-02, 1.12407231E-02, 1.12829323E-02,
     &   1.13242031E-02, 1.13644214E-02, 1.14036294E-02, 1.14418917E-02,
     &   1.14792352E-02, 1.15156915E-02, 1.15512755E-02, 1.15860323E-02,
     &   1.16199692E-02, 1.16531017E-02, 1.16854423E-02, 1.17170009E-02,
     &   1.17477852E-02, 1.17778004E-02, 1.18070497E-02, 1.18355343E-02,
     &   1.18632533E-02, 1.18902043E-02, 1.19163825E-02, 1.19417814E-02,
     &   1.19663928E-02, 1.19902061E-02, 1.20132088E-02, 1.20353864E-02,
     &   1.20567217E-02, 1.20771954E-02, 1.20967854E-02, 1.21154669E-02,
     &   1.21297391E-02, 1.21499885E-02, 1.21804930E-02, 1.22066458E-02,
     &   1.22280286E-02, 1.22441151E-02, 1.22542397E-02, 1.22575494E-02,
     &   1.22529365E-02, 1.22389360E-02, 1.22135674E-02, 1.21740793E-02,
     &   1.21162757E-02, 1.20349026E-02, 1.19203259E-02, 1.17569375E-02,
     &   1.17369856E-02, 1.15160288E-02, 1.11377898E-02, 1.04717648E-02,
     &   9.41830034E-03, 8.99318525E-03, 7.26221484E-03, 4.10803375E-03,
     &   2.66333201E-03, 6.41077598E-04,-7.06789337E-04,-2.39108185E-03,
     &  -4.07454624E-03,-6.17736448E-03,-7.43809619E-03,-8.87793473E-03,
     &  -1.05378429E-02,-1.24722823E-02,-1.47552692E-02,-1.74900098E-02/
  
         DATA ((DGS3(I,J), I=1301,1400), J=1,1) /
     &  -1.90707442E-02,-2.08248550E-02,-2.27824436E-02,-2.49810011E-02,
     &  -2.74678231E-02,-3.03034378E-02,-3.35665816E-02,-3.73616003E-02,
     &  -4.18297816E-02,-4.36906343E-02,-4.48581493E-02,-4.60747198E-02,
     &  -4.73434994E-02,-4.86679177E-02,-5.00517117E-02,-5.14989603E-02,
     &  -5.30141248E-02,-5.46020947E-02,-5.62682401E-02,-5.80184726E-02,
     &  -5.98593148E-02,-6.17979821E-02,-6.38424765E-02,-6.60016968E-02,
     &  -6.82855684E-02,-7.07051953E-02,-7.32730406E-02,-7.60031406E-02,
     &  -7.89113616E-02,-8.20157080E-02,-8.53366947E-02,-8.88978012E-02,
     &  -9.27260261E-02,-9.68525731E-02,-1.01313702E-01,-1.06151797E-01,
     &  -1.11416715E-01,-1.17167511E-01,-1.23474658E-01,-1.30422949E-01,
     &  -1.38115332E-01,-1.46678035E-01,-1.56267549E-01,-1.67080267E-01,
     &  -1.79366077E-01,-1.93447893E-01,-2.09750444E-01,-2.28843817E-01,
     &  -2.51511462E-01,-2.78860287E-01,-3.12506769E-01,-3.54908229E-01,
     &  -4.09991070E-01,-4.84440940E-01,-5.90641064E-01,-7.54376197E-01,
     &  -1.03963386E+00,-1.66037151E+00,-2.04523682E+00,-3.90761492E+00,
     &  -5.44239098E+00,-6.55486932E+00,-7.41565652E+00,-8.12289845E+00,
     &  -8.74181279E+00,-9.31607903E+00,-9.71586106E+00,-1.01228084E+01,
     &  -1.05230374E+01,-1.07160066E+01,-1.09864491E+01,-1.11484952E+01,
     &  -1.13496371E+01,-1.14020557E+01,-1.14795896E+01,-1.15118110E+01,
     &  -1.14875267E+01,-1.14504726E+01,-1.13945313E+01,-1.12173753E+01,
     &  -1.10931432E+01,-1.09404560E+01,-1.05470557E+01,-1.03028203E+01,
     &  -1.00236868E+01,-9.70431707E+00,-8.95545810E+00,-8.51566288E+00,
     &  -8.03888531E+00,-6.95513008E+00,-6.35521873E+00,-5.03502321E+00,
     &  -3.58161175E+00, 3.97136690E-01, 3.56054570E+00, 5.01768649E+00,
     &   6.33592334E+00, 7.50726535E+00, 8.03386634E+00, 8.51327744E+00/
  
         DATA ((DGS3(I,J), I=1401,1500), J=1,1) /
     &   8.95131700E+00, 9.70960835E+00, 1.00282359E+01, 1.03128032E+01,
     &   1.05591979E+01, 1.09565529E+01, 1.11095631E+01, 1.12368961E+01,
     &   1.14162483E+01, 1.14741624E+01, 1.15333169E+01, 1.15386421E+01,
     &   1.15080320E+01, 1.14322829E+01, 1.13201518E+01, 1.11800002E+01,
     &   1.10185389E+01, 1.07486871E+01, 1.05569908E+01, 1.01559657E+01,
     &   9.75007464E+00, 9.34908071E+00, 8.77444291E+00, 8.15500765E+00,
     &   7.44709468E+00, 6.58545899E+00, 5.47192645E+00, 3.91328188E+00,
     &   2.14188919E+00, 1.23082323E+00, 8.65165518E-01, 6.68296583E-01,
     &   5.45314152E-01, 4.61209156E-01, 4.00067758E-01, 3.53617051E-01,
     &   3.17131418E-01, 2.87715472E-01, 2.63496364E-01, 2.43209035E-01,
     &   2.25968186E-01, 2.11135729E-01, 1.98240137E-01, 1.86925432E-01,
     &   1.76917829E-01, 1.68003282E-01, 1.60012146E-01, 1.52808083E-01,
     &   1.46280356E-01, 1.40338075E-01, 1.34905938E-01, 1.29921026E-01,
     &   1.25330361E-01, 1.21089016E-01, 1.17158642E-01, 1.13506305E-01,
     &   1.10103567E-01, 1.06925740E-01, 1.03951288E-01, 1.01161343E-01,
     &   9.85393005E-02, 9.60704918E-02, 9.37419099E-02, 9.15420027E-02,
     &   8.94604142E-02, 8.74878671E-02, 8.56160705E-02, 8.38375364E-02,
     &   8.21455016E-02, 8.05338424E-02, 7.89970008E-02, 7.75299207E-02,
     &   7.61279924E-02, 7.47870045E-02, 7.35031018E-02, 7.22727485E-02,
     &   7.10926959E-02, 6.99599536E-02, 6.14285529E-02, 5.62156588E-02,
     &   5.12404857E-02, 4.57416619E-02, 4.07373318E-02, 3.63317824E-02,
     &   3.52482673E-02, 3.12154868E-02, 2.51657987E-02, 2.12975792E-02,
     &   2.11124548E-02, 2.07221439E-02, 2.02904575E-02, 1.94687807E-02,
     &   1.87612794E-02, 1.64931629E-02, 1.44430558E-02, 1.32042728E-02,
     &   1.15800085E-02, 9.71672363E-03, 7.59798030E-03, 4.89048292E-03/
  
         DATA ((DGS3(I,J), I=1501,1600), J=1,1) /
     &   1.19102945E-03,-8.03639931E-03,-9.78398465E-03,-1.18414196E-02,
     &  -1.24375301E-02,-1.37961352E-02,-1.53054892E-02,-1.69921909E-02,
     &  -1.88894880E-02,-2.10394963E-02,-2.34963612E-02,-2.63308907E-02,
     &  -2.96374944E-02,-3.35449115E-02,-3.82333758E-02,-4.39632211E-02,
     &  -5.11249422E-02,-6.03321574E-02,-7.26075281E-02,-8.97917420E-02,
     &  -1.15565829E-01,-1.58517350E-01,-2.44398465E-01,-3.59599122E-01,
     &  -3.78935271E-01,-4.00385213E-01,-4.24315383E-01,-4.51182043E-01,
     &  -4.81560585E-01,-5.16187088E-01,-5.56018559E-01,-6.02322430E-01,
     &  -6.56813334E-01,-7.21869045E-01,-8.00884602E-01,-8.98879804E-01,
     &  -1.02359928E+00,-1.18764123E+00,-1.41293437E+00,-1.74122367E+00,
     &  -2.26243462E+00,-3.20830758E+00,-5.34813239E+00,-6.09825496E+00,
     &  -6.68865835E+00,-7.34671441E+00,-7.89898145E+00,-8.29726517E+00,
     &  -8.63505649E+00,-8.79069745E+00,-8.85249154E+00,-8.77476966E+00,
     &  -8.49936642E+00,-8.18228112E+00,-8.12228057E+00,-8.09108755E+00,
     &  -8.02627273E+00,-7.99942792E+00,-7.97894570E+00,-7.95816266E+00,
     &  -7.73339822E+00,-7.33583060E+00,-6.80385168E+00,-6.24021052E+00,
     &  -5.51824345E+00,-4.69789770E+00,-3.88124775E+00,-3.39867046E+00,
     &  -2.89786111E+00,-2.38108385E+00,-1.63566076E+00,-1.09139562E+00,
     &  -5.40719007E-01,-2.08552679E-01,-9.76919328E-02, 1.31948427E-02,
     &   1.24081626E-01, 5.67108939E-01, 1.11778630E+00, 1.66205266E+00,
     &   4.09512818E+00, 4.98041725E+00, 6.39894392E+00, 6.94452392E+00,
     &   7.45710678E+00, 7.87612673E+00, 8.17913766E+00, 8.44114320E+00,
     &   8.61683820E+00, 8.75346875E+00, 8.83058583E+00, 8.87273227E+00,
     &   8.87736293E+00, 8.85158498E+00, 8.80522542E+00, 8.65198962E+00,
     &   8.54871010E+00, 8.43420338E+00, 8.32380077E+00, 8.07526694E+00/
  
         DATA ((DGS3(I,J), I=1601,1700), J=1,1) /
     &   7.93924648E+00, 7.71833121E+00, 4.12633105E+00, 2.71368726E+00,
     &   2.01240354E+00, 1.59776667E+00, 1.32476650E+00, 1.13168473E+00,
     &   9.88006734E-01, 8.76963277E-01, 7.88589226E-01, 7.16595777E-01,
     &   6.56820455E-01, 6.06399460E-01, 5.63298309E-01, 5.26032145E-01,
     &   4.93492003E-01, 4.64833024E-01, 4.39400286E-01, 4.16678304E-01,
     &   3.96255804E-01, 2.70986079E-01, 1.85104919E-01, 1.42153316E-01,
     &   1.16379119E-01, 9.91947684E-02, 8.69192347E-02, 7.77118306E-02,
     &   7.05498950E-02, 6.48198088E-02, 6.01310775E-02, 5.62233667E-02,
     &   5.29164427E-02, 5.00815661E-02, 4.76243270E-02, 4.54739174E-02,
     &   4.35761901E-02, 4.18890300E-02, 4.03791887E-02, 3.90200669E-02,
     &   3.73919693E-02, 3.54916616E-02, 3.38672491E-02, 3.24625734E-02,
     &   3.12357475E-02, 3.01548930E-02, 2.62350269E-02, 2.37710910E-02,
     &   2.20745534E-02, 2.08313888E-02, 1.98767720E-02, 1.91087687E-02,
     &   1.84959792E-02, 1.79854609E-02, 1.35691873E-02, 1.23305266E-02,
     &   1.20208696E-02, 1.16638477E-02, 1.12406294E-02, 1.07174835E-02,
     &   1.04029654E-02, 1.00415179E-02, 9.11465019E-03, 7.72432363E-03,
     &   5.31417577E-03,-1.40745073E-04,-5.33964770E-03,-6.68041006E-03,
     &  -8.22645780E-03,-1.00290817E-02,-1.21582364E-02,-1.47119730E-02,
     &  -1.78317202E-02,-2.17297744E-02,-2.67397717E-02,-3.34175074E-02,
     &  -4.27636922E-02,-5.67798212E-02,-8.01349869E-02,-8.41965378E-02,
     &  -8.86267301E-02,-9.34792571E-02,-9.88169325E-02,-1.04715675E-01,
     &  -1.11270376E-01,-1.18596061E-01,-1.26836314E-01,-1.36175991E-01,
     &  -1.46849610E-01,-1.59163489E-01,-1.73530592E-01,-1.90509120E-01,
     &  -2.10879754E-01,-2.35777785E-01,-2.43557679E-01,-2.66897166E-01,
     &  -3.06897087E-01,-3.60223764E-01,-4.34855029E-01,-5.46732923E-01/
  
         DATA ((DGS3(I,J), I=1701,1800), J=1,1) /
     &  -7.32934884E-01,-1.10414258E+00,-2.20130845E+00,-2.61956643E+00,
     &  -3.70026700E+00,-4.52211787E+00,-5.19928922E+00,-5.79033135E+00,
     &  -6.31470558E+00,-6.78512000E+00,-7.20531642E+00,-7.59479537E+00,
     &  -7.96261140E+00,-8.29875451E+00,-8.59443176E+00,-8.86793661E+00,
     &  -9.11453322E+00,-9.33052213E+00,-9.53572842E+00,-9.70381744E+00,
     &  -9.83507827E+00,-9.94652236E+00,-1.00323009E+01,-1.00854378E+01,
     &  -1.00988064E+01,-1.00762188E+01,-1.00109893E+01,-9.89573101E+00,
     &  -9.72244499E+00,-9.52763077E+00,-9.22590231E+00,-8.84206565E+00,
     &  -8.36831686E+00,-7.69339551E+00,-6.88063065E+00,-5.78183880E+00,
     &  -4.34198936E+00, 1.31742955E-02, 4.36834657E+00, 5.80820318E+00,
     &   6.90700249E+00, 7.71977435E+00, 8.39470286E+00, 8.86845776E+00,
     &   9.25230040E+00, 9.55403463E+00, 9.74885345E+00, 9.92214472E+00,
     &   1.00374080E+01, 1.01026421E+01, 1.01252339E+01, 1.01118694E+01,
     &   1.00587367E+01, 9.97296205E+00, 9.86152149E+00, 9.73026387E+00,
     &   9.56217816E+00, 9.35697520E+00, 9.14098924E+00, 8.89439552E+00,
     &   8.62089344E+00, 8.32521881E+00, 7.98907831E+00, 7.62126478E+00,
     &   7.23178815E+00, 6.81159394E+00, 6.34118168E+00, 5.81680953E+00,
     &   5.22576941E+00, 4.54859998E+00, 3.72675098E+00, 2.64605220E+00,
     &   2.22755902E+00, 1.13056919E+00, 7.59422241E-01, 5.73205091E-01,
     &   4.61332706E-01, 3.86711225E-01, 3.33384557E-01, 2.93380825E-01,
     &   2.62265267E-01, 2.37367240E-01, 2.16994589E-01, 2.00018084E-01,
     &   1.85650985E-01, 1.73335860E-01, 1.62663492E-01, 1.53323817E-01,
     &   1.06622513E-01, 8.32673762E-02, 6.92512838E-02, 5.99051433E-02,
     &   5.32274605E-02, 4.82175232E-02, 4.43195369E-02, 4.11998663E-02,
     &   3.86462143E-02, 3.65171381E-02, 3.47146299E-02, 3.31686918E-02/
  
         DATA ((DGS3(I,J), I=1801,1900), J=1,1) /
     &   3.18280476E-02, 2.69988266E-02, 2.34493041E-02, 2.13133206E-02,
     &   1.98791929E-02, 1.88442080E-02, 1.80576651E-02, 1.74360436E-02,
     &   1.69293467E-02, 1.65057692E-02, 1.61440255E-02, 1.58293475E-02,
     &   1.55511858E-02, 1.53017409E-02, 1.50750947E-02, 1.48666438E-02,
     &   1.46727204E-02, 1.44903255E-02, 1.43169222E-02, 1.41501745E-02,
     &   1.39881370E-02, 1.38302720E-02, 1.37363909E-02, 1.15288903E-02,
     &   1.05165105E-02, 9.78570943E-03, 9.20710733E-03, 8.73084846E-03,
     &   8.33100845E-03, 7.99147864E-03, 7.70313841E-03, 7.46080998E-03,
     &   7.25733553E-03, 7.08915283E-03, 6.95494357E-03, 6.85250372E-03,
     &   6.77949584E-03, 6.73428337E-03, 6.71693988E-03, 6.72636234E-03,
     &   6.76200108E-03, 6.82497022E-03, 6.91391524E-03, 7.02706475E-03,
     &   7.17190973E-03, 7.33924364E-03, 7.53964380E-03, 7.76979985E-03,
     &   8.03573470E-03, 8.33904104E-03, 8.68084988E-03, 9.06170937E-03,
     &   9.51148337E-03, 1.00263213E-02, 1.06209147E-02, 1.13620957E-02,
     &   1.23417986E-02, 1.47363074E-02, 1.69997597E-02, 1.78536941E-02,
     &   1.84724124E-02, 1.89513329E-02, 1.93528590E-02, 1.96929073E-02,
     &   1.99722344E-02, 2.02153014E-02, 2.04239358E-02, 2.06002364E-02,
     &   2.07464741E-02, 2.08673220E-02, 2.09619024E-02, 2.10363992E-02,
     &   2.10866153E-02, 2.11164708E-02, 2.11250675E-02, 2.11125071E-02,
     &   2.10792865E-02, 2.10240418E-02, 2.09464043E-02, 2.08468527E-02,
     &   2.07234130E-02, 2.05737766E-02, 2.03959302E-02, 2.01905491E-02,
     &   1.99486253E-02, 1.96687135E-02, 1.93440475E-02, 1.89658721E-02,
     &   1.85188904E-02, 1.79788664E-02, 1.73004488E-02, 1.63732531E-02,
     &   1.46229097E-02, 1.45674417E-02, 1.41876679E-02, 1.39496697E-02,
     &   1.37783634E-02, 1.36455727E-02, 1.35380375E-02, 1.34484821E-02/
  
         DATA ((DGS3(I,J), I=1901,2000), J=1,1) /
     &   1.33727319E-02, 1.33078241E-02, 1.32520365E-02, 1.32038567E-02,
     &   1.31624912E-02, 1.31271775E-02, 1.30973054E-02, 1.30724911E-02,
     &   1.30524567E-02, 1.30369540E-02, 1.30257892E-02, 1.30188879E-02,
     &   1.30161503E-02, 1.30175979E-02, 1.30232569E-02, 1.30332265E-02,
     &   1.30475437E-02, 1.30666132E-02, 1.30905234E-02, 1.31196751E-02,
     &   1.31547126E-02, 1.31963858E-02, 1.32452051E-02, 1.33033398E-02,
     &   1.33725159E-02, 1.34564773E-02, 1.35627144E-02, 1.37093576E-02,
     &   1.40867338E-02, 1.44224107E-02, 1.45570729E-02, 1.46560884E-02,
     &   1.47362392E-02, 1.48041750E-02, 1.48629917E-02, 1.49140160E-02,
     &   1.49590707E-02, 1.49996443E-02, 1.50353926E-02, 1.50665619E-02,
     &   1.50950162E-02, 1.51201916E-02, 1.51439514E-02, 1.51601376E-02,
     &   1.51740353E-02, 1.51858842E-02, 1.51953563E-02, 1.52022846E-02,
     &   1.52067780E-02, 1.52088017E-02, 1.52083666E-02, 1.52054624E-02,
     &   1.52000403E-02, 1.51921115E-02, 1.51815502E-02, 1.51683267E-02,
     &   1.51523091E-02, 1.51334143E-02, 1.51114901E-02, 1.50863793E-02,
     &   1.50578353E-02, 1.50257817E-02, 1.49898538E-02, 1.49499579E-02,
     &   1.47160877E-02, 1.47069558E-02, 1.46989054E-02, 1.46918757E-02,
     &   1.46858656E-02, 1.46808687E-02, 1.46768715E-02, 1.46738300E-02,
     &   1.46717249E-02, 1.46705512E-02, 1.46703259E-02, 1.46710553E-02,
     &   1.46727397E-02, 1.46753756E-02, 1.46789969E-02, 1.46836232E-02,
     &   1.46892083E-02, 1.46958804E-02, 1.47036838E-02, 1.47125624E-02,
     &   1.47227410E-02, 1.47340464E-02, 1.47467476E-02, 1.47609141E-02,
     &   1.47748787E-02, 1.47923504E-02, 1.48115022E-02, 1.48330149E-02,
     &   1.48570674E-02, 1.48840718E-02, 1.49144896E-02, 1.49496540E-02,
     &   1.49911328E-02, 1.50422636E-02, 1.51111763E-02, 1.52851351E-02/
  
         DATA ((DGS3(I,J), I=2001,2100), J=1,1) /
     &   1.54619279E-02, 1.55337427E-02, 1.55878614E-02, 1.56324068E-02,
     &   1.56707257E-02, 1.57043779E-02, 1.57347402E-02, 1.57622631E-02,
     &   1.57873597E-02, 1.58101840E-02, 1.58315108E-02, 1.58512020E-02,
     &   1.58695358E-02, 1.58865785E-02, 1.59023259E-02, 1.59170813E-02,
     &   1.59305746E-02, 1.59430004E-02, 1.59546247E-02, 1.59651179E-02,
     &   1.59748341E-02, 1.59836778E-02, 1.59916697E-02, 1.59988985E-02,
     &   1.60053659E-02, 1.60110764E-02, 1.60130341E-02, 1.60203035E-02,
     &   1.60238368E-02, 1.60266819E-02, 1.60288593E-02, 1.60303620E-02,
     &   1.60311879E-02, 1.60312046E-02, 1.60303340E-02, 1.60152869E-02,
     &   1.59177707E-02, 1.58087272E-02, 1.57192293E-02, 1.56397389E-02,
     &   1.55743685E-02, 1.55131821E-02, 1.54588102E-02, 1.54040565E-02,
     &   1.53495190E-02, 1.52959459E-02, 1.52369239E-02, 1.51733260E-02,
     &   1.50241262E-02, 1.48749265E-02, 1.49179050E-02, 1.49579173E-02,
     &   1.49926202E-02, 1.50264775E-02, 1.50558089E-02, 1.50848358E-02,
     &   1.51111081E-02, 1.51372793E-02, 1.51623313E-02, 1.51853996E-02,
     &   1.52087098E-02, 1.52303337E-02, 1.52523236E-02, 1.52728354E-02,
     &   1.52937941E-02, 1.53134255E-02, 1.53335578E-02, 1.53524757E-02,
     &   1.53719310E-02, 1.53902585E-02, 1.54090282E-02, 1.54297576E-02,
     &   1.54475063E-02, 1.54658412E-02, 1.54831818E-02, 1.55011175E-02,
     &   1.55180995E-02, 1.55356820E-02, 1.55523450E-02, 1.55696117E-02,
     &   1.55859879E-02, 1.56029692E-02, 1.56198147E-02, 1.56358063E-02,
     &   1.56524030E-02, 1.56681662E-02, 1.56845334E-02, 1.57000853E-02,
     &   1.57162396E-02, 1.57315949E-02, 1.57475504E-02, 1.57627217E-02,
     &   1.57784908E-02, 1.57934890E-02, 1.58084063E-02, 1.58239174E-02,
     &   1.58386756E-02, 1.58540249E-02, 1.58686322E-02, 1.58838276E-02/
  
         DATA ((DGS3(I,J), I=2101,2164), J=1,1) /
     &   1.58982913E-02, 1.59104188E-02, 1.59237924E-02, 1.59387768E-02,
     &   1.59530508E-02, 1.59679134E-02, 1.59829726E-02, 1.59970664E-02,
     &   1.60118177E-02, 1.60231035E-02, 1.60376625E-02, 1.60515375E-02,
     &   1.60659906E-02, 1.60797659E-02, 1.60941163E-02, 1.61077947E-02,
     &   1.61220453E-02, 1.61356296E-02, 1.61497830E-02, 1.61632756E-02,
     &   1.61767241E-02, 1.61907376E-02, 1.62040978E-02, 1.62180201E-02,
     &   1.62312942E-02, 1.62451274E-02, 1.62583173E-02, 1.62720636E-02,
     &   1.62851712E-02, 1.62988323E-02, 1.63118595E-02, 1.63254374E-02,
     &   1.64704091E-02, 1.66109266E-02, 1.66330240E-02, 1.76116205E-02,
     &   1.80492682E-02, 1.91908730E-02, 1.98301640E-02, 1.98611919E-02,
     &   2.07128941E-02, 2.07155925E-02, 2.13533460E-02, 2.13776346E-02,
     &   2.13921625E-02, 2.17084843E-02, 2.19191094E-02, 2.19568643E-02,
     &   2.20185612E-02, 2.21099912E-02, 2.21744974E-02, 2.22150847E-02,
     &   2.26090592E-02, 2.26290028E-02, 2.27453456E-02, 2.27660911E-02,
     &   2.28631513E-02, 2.29067405E-02, 2.29373532E-02, 2.29658566E-02,
     &   2.30430823E-02, 2.32129486E-02, 2.32145209E-02, 2.35526690E-02/
  
         DATA ((DGS3(I,J), I=   1, 100), J=2,2) /
     &   6.25290549E-06, 7.07146237E-06, 7.44690731E-06, 7.86428978E-06,
     &   8.35898791E-06, 8.65072812E-06, 9.59812590E-06, 1.01137994E-05,
     &   1.03472301E-05, 1.08735672E-05, 1.09633709E-05, 1.10574580E-05,
     &   1.11669487E-05, 1.13990361E-05, 1.17170192E-05, 1.21408088E-05,
     &   1.24511224E-05, 1.27363263E-05, 1.30117823E-05, 1.33794009E-05,
     &   1.37077795E-05, 1.40411770E-05, 1.42680118E-05, 1.46238453E-05,
     &   1.49642818E-05, 1.53120892E-05, 1.58241072E-05, 1.61225865E-05,
     &   1.62582082E-05, 1.65903800E-05, 1.70080227E-05, 1.74294304E-05,
     &   1.78363331E-05, 1.82312993E-05, 1.86337647E-05, 1.90444919E-05,
     &   1.94668873E-05, 1.99770409E-05, 2.04926634E-05, 2.09986814E-05,
     &   2.14311896E-05, 2.19495576E-05, 2.25178609E-05, 2.29952420E-05,
     &   2.36606186E-05, 2.44944812E-05, 2.51849970E-05, 2.58166674E-05,
     &   2.62452064E-05, 2.66341804E-05, 2.95791590E-05, 3.37578243E-05,
     &   3.91196949E-05, 4.57876511E-05, 5.01905867E-05, 5.13706101E-05,
     &   5.26749038E-05, 5.36897481E-05, 5.54402046E-05, 5.60528321E-05,
     &   5.71949002E-05, 5.78136284E-05, 5.88205511E-05, 6.05755819E-05,
     &   6.24965355E-05, 6.47829993E-05, 6.69766352E-05, 6.76463602E-05,
     &   6.86467698E-05, 6.96124032E-05, 6.98387356E-05, 6.84293209E-05,
     &   6.89437535E-05, 6.96865127E-05, 7.00293523E-05, 7.14570831E-05,
     &   7.18144731E-05, 7.33893654E-05, 7.49001986E-05, 8.89082225E-05,
     &   8.60928504E-05, 8.82853706E-05, 8.68164625E-05, 8.38970185E-05,
     &   8.48988329E-05, 9.14522326E-05, 9.25086236E-05, 8.99538853E-05,
     &   8.81759603E-05, 8.67932707E-05, 8.52204167E-05, 8.50682148E-05,
     &   8.55886893E-05, 8.70854187E-05, 8.91831969E-05, 9.29424782E-05,
     &   9.11530385E-05, 9.04541347E-05, 8.73471194E-05, 8.47409960E-05/
  
         DATA ((DGS3(I,J), I= 101, 200), J=2,2) /
     &   8.12998756E-05, 7.82626696E-05, 7.54960755E-05, 7.31720800E-05,
     &   7.15865401E-05, 7.03523792E-05, 6.95040435E-05, 6.88667049E-05,
     &   6.85087424E-05, 6.85928304E-05, 6.90405965E-05, 6.94651891E-05,
     &   6.99964648E-05, 7.06928017E-05, 7.14848980E-05, 7.21409417E-05,
     &   7.25065875E-05, 7.16245315E-05, 7.01262743E-05, 6.97237079E-05,
     &   6.94619264E-05, 6.93423411E-05, 6.94260952E-05, 6.96874861E-05,
     &   7.00017299E-05, 6.99488640E-05, 7.01041533E-05, 7.04914886E-05,
     &   7.11812196E-05, 7.19819882E-05, 7.32583206E-05, 7.50112346E-05,
     &   7.73099189E-05, 7.99661422E-05, 8.28863137E-05, 8.55397076E-05,
     &   8.73309202E-05, 8.71715682E-05, 8.52043370E-05, 8.15698467E-05,
     &   7.98054754E-05, 7.79929831E-05, 7.68008872E-05, 7.59103342E-05,
     &   7.53394700E-05, 7.50590908E-05, 7.44637203E-05, 7.44687704E-05,
     &   7.38503285E-05, 7.38115546E-05, 7.36764932E-05, 7.59054130E-05,
     &   7.68014542E-05, 7.82050371E-05, 7.37415024E-05, 7.63447674E-05,
     &   7.76853338E-05, 7.66946053E-05, 7.41159784E-05, 7.51007732E-05,
     &   7.62060402E-05, 7.93511848E-05, 8.14106272E-05, 8.17035713E-05,
     &   8.17430006E-05, 8.17520760E-05, 8.20686138E-05, 8.25242247E-05,
     &   8.28657616E-05, 8.54353403E-05, 8.81484078E-05, 9.09459516E-05,
     &   9.40642719E-05, 9.75643365E-05, 1.01284691E-04, 1.05071535E-04,
     &   1.08528471E-04, 1.12983224E-04, 1.17948160E-04, 1.22322934E-04,
     &   1.25583667E-04, 1.31099370E-04, 1.34386731E-04, 1.41588720E-04,
     &   1.48571645E-04, 1.57575420E-04, 1.66286991E-04, 1.77687406E-04,
     &   1.88707354E-04, 2.01272248E-04, 2.18114926E-04, 2.27774716E-04,
     &   2.35181201E-04, 2.50314922E-04, 2.58546174E-04, 2.67646622E-04,
     &   2.77727829E-04, 2.88725301E-04, 3.00501152E-04, 3.13185304E-04/
  
         DATA ((DGS3(I,J), I= 201, 300), J=2,2) /
     &   3.41130353E-04, 3.74989382E-04, 3.94714307E-04, 4.02195110E-04,
     &   4.09977483E-04, 4.18077883E-04, 4.26519617E-04, 4.35324026E-04,
     &   4.44509558E-04, 4.54107186E-04, 4.64140153E-04, 4.74638751E-04,
     &   4.85637364E-04, 4.97166439E-04, 5.09273257E-04, 5.22015274E-04,
     &   5.35447695E-04, 5.49629317E-04, 5.64635970E-04, 5.80555809E-04,
     &   5.97493364E-04, 6.15570699E-04, 6.34938601E-04, 6.55783275E-04,
     &   6.78341831E-04, 7.02931022E-04, 7.30001659E-04, 7.60259481E-04,
     &   7.94949152E-04, 8.36951398E-04, 8.98230966E-04, 9.55536676E-04,
     &   1.02977036E-03, 9.44506319E-04, 9.45900455E-04, 9.91559716E-04,
     &   9.97898079E-04, 1.03389469E-03, 1.07386062E-03, 1.12202582E-03,
     &   1.16798448E-03, 1.22287559E-03, 1.28378367E-03, 1.33932873E-03,
     &   1.50216685E-03, 1.51169724E-03, 1.60693424E-03, 1.71465025E-03,
     &   1.83717722E-03, 1.97734631E-03, 2.13865110E-03, 2.32506326E-03,
     &   2.54141139E-03, 2.79183001E-03, 3.03339147E-03, 3.16641570E-03,
     &   3.25641124E-03, 3.34799701E-03, 3.44064554E-03, 3.40418224E-03,
     &   3.62501836E-03, 3.71277296E-03, 3.79220345E-03, 3.86212384E-03,
     &   3.91676238E-03, 3.95001799E-03, 3.95366767E-03, 3.88450834E-03,
     &   3.76646766E-03, 3.68329141E-03, 3.45796435E-03, 3.14370811E-03,
     &   2.73093826E-03, 2.21755142E-03, 1.61100088E-03, 9.32498321E-04,
     &   2.52913075E-04, 5.86802925E-04, 1.28784444E-03, 1.93798163E-03,
     &   2.50436484E-03, 2.97273728E-03, 3.34144157E-03, 3.61389859E-03,
     &   3.80307336E-03, 3.92189319E-03, 3.98335392E-03, 3.99981544E-03,
     &   3.98184104E-03, 3.93819565E-03, 3.87609482E-03, 3.76319791E-03,
     &   3.64866841E-03, 3.57065117E-03, 3.53097931E-03, 3.44426588E-03,
     &   3.35168071E-03, 3.26067701E-03, 3.17145177E-03, 3.08438870E-03/
  
         DATA ((DGS3(I,J), I= 301, 400), J=2,2) /
     &   3.00012411E-03, 2.99069277E-03, 2.84039474E-03, 2.76510973E-03,
     &   2.69283222E-03, 2.46222551E-03, 2.26350481E-03, 2.09200649E-03,
     &   1.94338912E-03, 1.81390762E-03, 1.67489656E-03, 1.60052890E-03,
     &   1.51203166E-03, 1.43332837E-03, 1.36304767E-03, 1.30009583E-03,
     &   1.24361730E-03, 1.19288392E-03, 1.14736931E-03, 1.10670971E-03,
     &   1.07181398E-03, 1.04055019E-03, 1.01508622E-03, 1.02849453E-03,
     &   1.00621596E-03, 1.12615857E-03, 1.16719136E-03, 1.05578104E-03,
     &   9.26278090E-04, 8.62357423E-04, 8.18863484E-04, 7.83238671E-04,
     &   7.52966846E-04, 7.26243394E-04, 7.02236077E-04, 6.80401891E-04,
     &   6.60369688E-04, 6.41872316E-04, 6.24696202E-04, 6.08688470E-04,
     &   5.93713294E-04, 5.79655134E-04, 5.66379227E-04, 5.53865831E-04,
     &   5.42040227E-04, 5.30781432E-04, 5.20118226E-04, 5.09994389E-04,
     &   5.00381541E-04, 4.91249579E-04, 4.82576888E-04, 4.74264348E-04,
     &   4.66105110E-04, 4.58292144E-04, 4.50792760E-04, 4.43596467E-04,
     &   4.36808272E-04, 4.20163030E-04, 3.81530696E-04, 3.28789932E-04,
     &   2.97228885E-04, 2.70694505E-04, 2.50719906E-04, 2.36890197E-04,
     &   2.26318797E-04, 2.16899268E-04, 2.19470862E-04, 2.14889093E-04,
     &   2.10392357E-04, 2.12053788E-04, 2.13050651E-04, 2.09796561E-04,
     &   2.13960617E-04, 2.16196386E-04, 2.15599182E-04, 2.17618801E-04,
     &   2.22628324E-04, 2.28912081E-04, 2.36399363E-04, 2.46080413E-04,
     &   2.51370612E-04, 2.55983496E-04, 2.66790197E-04, 2.78317513E-04,
     &   2.78661210E-04, 2.89618862E-04, 3.02718646E-04, 3.08160300E-04,
     &   3.15982576E-04, 3.29905450E-04, 3.46345817E-04, 3.67478728E-04,
     &   3.73314348E-04, 3.93988113E-04, 4.05622616E-04, 4.23366093E-04,
     &   4.54969956E-04, 5.01071739E-04, 5.04537264E-04, 5.47572338E-04/
  
         DATA ((DGS3(I,J), I= 401, 500), J=2,2) /
     &   6.45379468E-04, 6.71028435E-04, 6.39176525E-04, 6.14401615E-04,
     &   6.07541870E-04, 5.81860434E-04, 5.85091981E-04, 5.83692261E-04,
     &   5.71665146E-04, 5.38259149E-04, 5.07464573E-04, 4.78428161E-04,
     &   4.78862149E-04, 4.71043306E-04, 4.64863067E-04, 4.46401619E-04,
     &   4.45410327E-04, 4.23390831E-04, 4.23140288E-04, 4.23981888E-04,
     &   4.25061004E-04, 4.28037868E-04, 4.23997268E-04, 4.18593359E-04,
     &   4.17070770E-04, 4.71143846E-04, 4.75506413E-04, 5.13176088E-04,
     &   5.18516075E-04, 5.46667232E-04, 5.65080225E-04, 5.68531575E-04,
     &   5.71118954E-04, 5.66081302E-04, 5.58098424E-04, 5.37980204E-04,
     &   5.35422734E-04, 4.82758019E-04, 4.76804484E-04, 4.36768320E-04,
     &   3.98149479E-04, 3.86121120E-04, 3.73141037E-04, 3.68527576E-04,
     &   3.25225014E-04, 3.18166950E-04, 3.17861525E-04, 2.97705683E-04,
     &   3.02874749E-04, 2.76317175E-04, 2.96034099E-04, 2.97203852E-04,
     &   2.98789697E-04, 3.02935962E-04, 2.87299654E-04, 2.73077550E-04,
     &   2.97000335E-04, 3.10771707E-04, 3.44091043E-04, 3.53590931E-04,
     &   3.59981970E-04, 3.57657822E-04, 3.61252025E-04, 3.57992843E-04,
     &   3.62558777E-04, 3.66326272E-04, 3.63956143E-04, 3.74986197E-04,
     &   3.95550380E-04, 4.01669424E-04, 4.06959673E-04, 4.34358899E-04,
     &   4.65171890E-04, 4.87167271E-04, 4.90573767E-04, 5.20362755E-04,
     &   5.28276307E-04, 5.25826754E-04, 5.44255949E-04, 5.60953813E-04,
     &   5.62947382E-04, 5.99747793E-04, 6.20314957E-04, 6.28965070E-04,
     &   6.43553111E-04, 7.08313535E-04, 7.36849687E-04, 7.64037599E-04,
     &   7.97406030E-04, 8.10224270E-04, 8.39438261E-04, 8.45814555E-04,
     &   8.75656524E-04, 9.07290944E-04, 9.31124943E-04, 9.41897857E-04,
     &   1.13596365E-03, 1.30708183E-03, 1.53302839E-03, 9.79756480E-04/
  
         DATA ((DGS3(I,J), I= 501, 600), J=2,2) /
     &   8.59994202E-04, 8.28100162E-04, 5.33768591E-04, 5.31734213E-04,
     &   5.22573064E-04, 4.65135815E-04, 4.28563622E-04, 3.95875196E-04,
     &   3.70332558E-04, 3.55599678E-04, 3.46757091E-04, 3.44635579E-04,
     &   3.44683299E-04, 3.42873937E-04, 3.43714886E-04, 3.51527326E-04,
     &   3.76049028E-04, 3.82570046E-04, 3.90467840E-04, 3.99905337E-04,
     &   4.11164246E-04, 4.24607400E-04, 4.40838120E-04, 4.60450176E-04,
     &   4.64840245E-04, 4.69419897E-04, 4.74196017E-04, 4.79178174E-04,
     &   4.84320032E-04, 4.89691164E-04, 4.95303633E-04, 5.01172106E-04,
     &   5.07301300E-04, 5.12748090E-04, 5.45796918E-04, 5.71910411E-04,
     &   5.86485270E-04, 5.96798020E-04, 6.07667139E-04, 6.19121027E-04,
     &   6.31210807E-04, 6.43982064E-04, 6.57474962E-04, 6.64528160E-04,
     &   6.71787807E-04, 6.79265960E-04, 6.86968229E-04, 6.94907598E-04,
     &   7.03090819E-04, 7.11531929E-04, 7.20238969E-04, 7.29227197E-04,
     &   7.38506126E-04, 7.48091005E-04, 7.57995381E-04, 7.68236186E-04,
     &   7.78828644E-04, 7.89789996E-04, 8.01138219E-04, 8.12894121E-04,
     &   8.25077445E-04, 8.37710978E-04, 8.50817850E-04, 8.64425229E-04,
     &   8.78560011E-04, 8.93251785E-04, 9.08532372E-04, 9.24436048E-04,
     &   9.40999773E-04, 9.58263466E-04, 9.76270306E-04, 9.95067069E-04,
     &   1.01470483E-03, 1.03523851E-03, 1.05672820E-03, 1.07923946E-03,
     &   1.10284398E-03, 1.12762024E-03, 1.15365442E-03, 1.18104132E-03,
     &   1.20988547E-03, 1.24030243E-03, 1.27241935E-03, 1.28916025E-03,
     &   1.30638061E-03, 1.32410136E-03, 1.34234357E-03, 1.36113044E-03,
     &   1.38048566E-03, 1.40043519E-03, 1.42100573E-03, 1.44222646E-03,
     &   1.46412756E-03, 1.48674195E-03, 1.51010386E-03, 1.53425058E-03,
     &   1.55922111E-03, 1.58505787E-03, 1.61180543E-03, 1.63951228E-03/
  
         DATA ((DGS3(I,J), I= 601, 700), J=2,2) /
     &   1.66822957E-03, 1.69801313E-03, 1.72892191E-03, 1.76102008E-03,
     &   1.79437648E-03, 1.82906542E-03, 1.86516713E-03, 1.90276844E-03,
     &   1.94196342E-03, 1.98285418E-03, 2.02555176E-03, 2.07017719E-03,
     &   2.11686189E-03, 2.16575055E-03, 2.21700121E-03, 2.27078881E-03,
     &   2.32730209E-03, 2.38675275E-03, 2.44937360E-03, 2.51542300E-03,
     &   2.58518755E-03, 2.68971774E-03, 2.73718245E-03, 2.82017160E-03,
     &   2.90840764E-03, 3.00240124E-03, 3.10273123E-03, 3.21005703E-03,
     &   3.32513253E-03, 3.44882433E-03, 3.58213285E-03, 3.72622004E-03,
     &   3.88244245E-03, 4.05239463E-03, 4.18809503E-03, 4.61097603E-03,
     &   5.12907238E-03, 5.77851867E-03, 6.61637986E-03, 7.73837297E-03,
     &   9.31825711E-03, 1.17077264E-02, 1.57424691E-02, 2.40106934E-02,
     &   5.04850687E-02, 5.33848319E-02, 5.66367079E-02, 6.03087188E-02,
     &   6.44875309E-02, 6.92852767E-02, 7.48495872E-02, 8.13787329E-02,
     &   8.91451565E-02, 9.85332986E-02, 1.10102797E-01, 1.24698904E-01,
     &   1.43655548E-01, 1.69190865E-01, 1.72235342E-01, 2.40405093E-01,
     &   2.90091980E-01, 3.30012532E-01, 3.64731175E-01, 3.91484669E-01,
     &   4.14860451E-01, 4.33594512E-01, 4.52257785E-01, 4.65078347E-01,
     &   4.76949128E-01, 4.85325578E-01, 4.92231019E-01, 4.96111535E-01,
     &   4.99008084E-01, 4.99254391E-01, 4.97796619E-01, 4.93753986E-01,
     &   4.89384853E-01, 4.79934363E-01, 4.71466800E-01, 4.61072947E-01,
     &   4.48589314E-01, 4.33859064E-01, 4.16737965E-01, 3.97101307E-01,
     &   3.74851649E-01, 3.49927111E-01, 3.22309796E-01, 2.92033769E-01,
     &   2.41855233E-01, 2.05479248E-01, 1.47169155E-01, 8.53867531E-02,
     &   8.53278361E-02, 2.41803642E-01, 2.91986323E-01, 3.36411408E-01,
     &   3.62686427E-01, 3.97066779E-01, 4.16706822E-01, 4.33831287E-01/
  
         DATA ((DGS3(I,J), I= 701, 800), J=2,2) /
     &   4.48564854E-01, 4.61051732E-01, 4.71448735E-01, 4.79919342E-01,
     &   4.86628773E-01, 4.91740080E-01, 4.95411150E-01, 4.97792538E-01,
     &   4.99253880E-01, 4.99009797E-01, 4.97108075E-01, 4.93672187E-01,
     &   4.90680549E-01, 4.83362808E-01, 4.76963973E-01, 4.67564128E-01,
     &   4.57485709E-01, 4.44336577E-01, 4.30931770E-01, 4.12239414E-01,
     &   3.94053253E-01, 3.71834145E-01, 3.46774591E-01, 3.14542019E-01,
     &   2.77591781E-01, 2.31453735E-01, 1.90724340E-01, 1.59086754E-01,
     &   1.36258121E-01, 1.19069213E-01, 1.05685180E-01, 9.49804651E-02,
     &   8.62298311E-02, 7.89463280E-02, 7.27914754E-02, 6.75229807E-02,
     &   6.29629878E-02, 5.89780728E-02, 5.54662301E-02, 5.23481653E-02,
     &   4.95613238E-02, 4.70557050E-02, 4.47908702E-02, 4.27337660E-02,
     &   2.24097416E-02, 1.51898994E-02, 1.14919326E-02, 9.24456856E-03,
     &   7.73443684E-03, 6.65002917E-03, 5.83366517E-03, 5.19697456E-03,
     &   4.68658706E-03, 4.26834435E-03, 4.21884682E-03, 3.87365076E-03,
     &   3.58139029E-03, 3.33079200E-03, 3.11357171E-03, 2.92350624E-03,
     &   2.75582998E-03, 2.60682752E-03, 2.47356574E-03, 2.35369681E-03,
     &   2.24531587E-03, 2.14686391E-03, 2.05705223E-03, 1.97480620E-03,
     &   1.89922266E-03, 1.82953353E-03, 1.76509764E-03, 1.70534105E-03,
     &   1.64980239E-03, 1.59804441E-03, 1.54971082E-03, 1.50448328E-03,
     &   1.46208202E-03, 1.42226024E-03, 1.38479934E-03, 1.34950328E-03,
     &   1.31620272E-03, 1.28474079E-03, 1.25497979E-03, 1.22679222E-03,
     &   1.20006689E-03, 1.17470203E-03, 1.15060548E-03, 1.12769360E-03,
     &   1.10589034E-03, 1.08512642E-03, 1.06533949E-03, 1.04647031E-03,
     &   1.02846663E-03, 1.01127822E-03, 9.94863940E-04, 9.79181538E-04,
     &   9.64193570E-04, 9.49865624E-04, 9.36166068E-04, 9.23065821E-04/
  
         DATA ((DGS3(I,J), I= 801, 900), J=2,2) /
     &   9.10542138E-04, 8.98562808E-04, 8.87108978E-04, 8.76155185E-04,
     &   8.65691944E-04, 8.55697483E-04, 8.46156155E-04, 8.37053803E-04,
     &   8.28377695E-04, 8.20116472E-04, 8.12260106E-04, 8.04799871E-04,
     &   7.97734068E-04, 7.91039301E-04, 7.84727920E-04, 7.78790606E-04,
     &   7.73225126E-04, 7.68030642E-04, 7.63207787E-04, 7.58758756E-04,
     &   7.54689244E-04, 7.51000326E-04, 7.47702458E-04, 7.44807440E-04,
     &   7.42325918E-04, 7.40273915E-04, 7.38670509E-04, 7.37538849E-04,
     &   7.36906941E-04, 7.36808661E-04, 7.37285084E-04, 7.38365917E-04,
     &   7.40149621E-04, 7.42722730E-04, 7.46129068E-04, 7.50513183E-04,
     &   7.55998920E-04, 7.53774623E-04, 7.51740126E-04, 7.49948001E-04,
     &   7.48238363E-04, 7.46814583E-04, 7.45736778E-04, 7.44729679E-04,
     &   7.44225071E-04, 7.44309082E-04, 7.51563406E-04, 7.49317711E-04,
     &   7.47159329E-04, 7.45201821E-04, 7.43184374E-04, 7.41271645E-04,
     &   7.39585570E-04, 7.37637809E-04, 7.35896258E-04, 7.34216801E-04,
     &   6.33754821E-04, 5.50178848E-04, 5.17173820E-04, 4.90528003E-04,
     &   4.81095259E-04, 5.06057329E-04, 5.33359637E-04, 5.79786705E-04,
     &   6.35617403E-04, 7.09660947E-04, 7.63053609E-04, 7.69896310E-04,
     &   8.15743440E-04, 8.33172352E-04, 8.57540495E-04, 8.94011024E-04,
     &   9.42391222E-04, 1.00409568E-03, 1.08189669E-03, 1.18021845E-03,
     &   1.30592138E-03, 1.47065626E-03, 1.55056478E-03, 1.64099468E-03,
     &   1.74402230E-03, 1.86231690E-03, 1.99936634E-03, 2.15992035E-03,
     &   2.25081107E-03, 2.35010217E-03, 2.45898678E-03, 2.57889439E-03,
     &   2.71155492E-03, 2.85908013E-03, 3.02407663E-03, 3.20979863E-03,
     &   3.42036311E-03, 3.66105441E-03, 3.93877138E-03, 4.26269380E-03,
     &   4.62867885E-03, 4.86839910E-03, 5.13449449E-03, 5.43155095E-03/
  
         DATA ((DGS3(I,J), I= 901,1000), J=2,2) /
     &   5.76528275E-03, 6.14290220E-03, 6.57364471E-03, 7.06953134E-03,
     &   7.64650417E-03, 8.32616561E-03, 9.13853383E-03, 1.01265781E-02,
     &   1.13540395E-02, 1.29196867E-02, 1.49851521E-02, 1.78342411E-02,
     &   2.20146303E-02, 2.87343548E-02, 4.12632792E-02, 6.09695350E-02,
     &   7.21856905E-02, 8.44197388E-02, 1.14521349E-01, 1.25366268E-01,
     &   1.34316825E-01, 1.41917926E-01, 1.48318489E-01, 1.53569824E-01,
     &   1.58091503E-01, 1.61793878E-01, 1.64443672E-01, 1.66694785E-01,
     &   1.68288373E-01, 1.69233561E-01, 1.69574934E-01, 1.69332514E-01,
     &   1.68670104E-01, 1.67325759E-01, 1.65566618E-01, 1.63195392E-01,
     &   1.60144513E-01, 1.56936491E-01, 1.52441836E-01, 1.47897644E-01,
     &   1.42674748E-01, 1.36739627E-01, 1.28879111E-01, 1.21317842E-01,
     &   1.11524704E-01, 1.02303906E-01, 8.88604505E-02, 7.41890555E-02,
     &   5.22765652E-02, 3.31766182E-02, 1.11802288E-02, 4.21809416E-04,
     &   1.11244664E-02, 2.21930570E-02, 5.22236739E-02, 7.41393849E-02,
     &   8.88136861E-02, 1.02260418E-01, 1.11483859E-01, 1.21280224E-01,
     &   1.28844340E-01, 1.36708227E-01, 1.42646245E-01, 1.47872019E-01,
     &   1.52419047E-01, 1.56916938E-01, 1.60127654E-01, 1.63181568E-01,
     &   1.65555702E-01, 1.67317618E-01, 1.68664966E-01, 1.69329854E-01,
     &   1.69575259E-01, 1.69236651E-01, 1.68294291E-01, 1.66703537E-01,
     &   1.64455208E-01, 1.61807910E-01, 1.58108295E-01, 1.53589327E-01,
     &   1.48340576E-01, 1.41942625E-01, 1.34344101E-01, 1.25396061E-01,
     &   1.14553649E-01, 1.01409229E-01, 1.08545447E-01, 8.44569384E-02,
     &   6.10091345E-02, 5.18942798E-02, 3.36031435E-02, 2.47950952E-02,
     &   1.96357041E-02, 1.62515586E-02, 1.38623878E-02, 1.20862263E-02,
     &   1.07142637E-02, 9.62278682E-03, 8.73386467E-03, 7.99597440E-03/
  
         DATA ((DGS3(I,J), I=1001,1100), J=2,2) /
     &   7.37369427E-03, 6.84187183E-03, 6.38215477E-03, 5.98083918E-03,
     &   5.62748641E-03, 5.31400466E-03, 5.03402491E-03, 4.78248448E-03,
     &   4.38503992E-03, 3.88917107E-03, 3.62473538E-03, 3.19282815E-03,
     &   2.85620443E-03, 2.52700602E-03, 2.05528514E-03, 1.54064269E-03,
     &   1.23972185E-03, 1.11504757E-03, 1.04513449E-03, 9.99924241E-04,
     &   9.67882762E-04, 9.43807520E-04, 9.24912836E-04, 9.09541584E-04,
     &   8.96739466E-04, 8.85777903E-04, 8.76256049E-04, 8.67829326E-04,
     &   8.60234688E-04, 8.53335974E-04, 8.46967653E-04, 8.41010949E-04,
     &   8.35405867E-04, 8.30074838E-04, 8.24932934E-04, 8.19954754E-04,
     &   8.15066520E-04, 8.10300708E-04, 8.05525598E-04, 8.00747374E-04,
     &   7.95903819E-04, 7.90972290E-04, 7.85879766E-04, 7.80572454E-04,
     &   7.74942206E-04, 7.68883522E-04, 7.62177185E-04, 7.54413996E-04,
     &   7.44306224E-04, 7.22374177E-04, 7.04146974E-04, 6.97743865E-04,
     &   6.93429586E-04, 6.90241429E-04, 6.87780947E-04, 6.85846606E-04,
     &   6.84289746E-04, 6.83013947E-04, 6.81869038E-04, 6.80981555E-04,
     &   6.80071718E-04, 6.79130175E-04, 6.77994267E-04, 6.75385086E-04,
     &   6.76794317E-04, 6.75863138E-04, 6.75056494E-04, 6.73929289E-04,
     &   6.72471447E-04, 6.70643883E-04, 6.68409694E-04, 6.65488529E-04,
     &   6.62281214E-04, 6.58279105E-04, 6.53555785E-04, 6.47916904E-04,
     &   6.41194582E-04, 6.33314143E-04, 6.23979473E-04, 6.13270461E-04,
     &   6.00369992E-04, 5.84267483E-04, 5.63478350E-04, 5.34497275E-04,
     &   5.25079543E-04, 5.01360636E-04, 4.68982643E-04, 4.65330664E-04,
     &   4.45348229E-04, 4.38864043E-04, 4.32994824E-04, 4.26386415E-04,
     &   4.21255855E-04, 4.16769071E-04, 4.12917992E-04, 4.12187460E-04,
     &   4.06552915E-04, 4.03897427E-04, 3.94714654E-04, 3.84868180E-04/
  
         DATA ((DGS3(I,J), I=1101,1200), J=2,2) /
     &   3.83713993E-04, 3.76434587E-04, 3.69678894E-04, 3.68547674E-04,
     &   3.66592162E-04, 3.67808524E-04, 3.73791161E-04, 3.93890448E-04,
     &   3.58489246E-04, 3.41517443E-04, 3.44733932E-04, 3.47344498E-04,
     &   3.54664864E-04, 3.53659105E-04, 3.48012512E-04, 3.47026396E-04,
     &   3.44615793E-04, 3.38384119E-04, 3.33758316E-04, 3.25415809E-04,
     &   3.23935833E-04, 3.23595986E-04, 3.19460105E-04, 3.16578799E-04,
     &   3.15403607E-04, 3.11637441E-04, 3.08588468E-04, 3.07034913E-04,
     &   3.06244662E-04, 3.05438540E-04, 3.04639778E-04, 3.04020596E-04,
     &   3.03102370E-04, 3.01578775E-04, 3.01158349E-04, 3.01212148E-04,
     &   3.00674132E-04, 2.97328573E-04, 2.94863709E-04, 2.93943965E-04,
     &   2.93140952E-04, 2.92335808E-04, 2.92017168E-04, 2.91747789E-04,
     &   2.91217681E-04, 2.89783360E-04, 2.88676775E-04, 2.87973644E-04,
     &   2.87465655E-04, 2.86289046E-04, 2.85493838E-04, 2.84873265E-04,
     &   2.84322108E-04, 2.84096563E-04, 2.84735628E-04, 2.83186940E-04,
     &   2.81747264E-04, 2.81243398E-04, 2.80836479E-04, 2.80404805E-04,
     &   2.79823383E-04, 2.79991451E-04, 2.78737573E-04, 2.79829987E-04,
     &   2.82533525E-04, 2.77676851E-04, 2.76929649E-04, 2.75576329E-04,
     &   2.75407601E-04, 2.76607679E-04, 2.73984660E-04, 2.73156296E-04,
     &   2.72379184E-04, 2.71722765E-04, 2.70742192E-04, 2.70624717E-04,
     &   2.70207843E-04, 2.69975159E-04, 2.69149004E-04, 2.69380835E-04,
     &   2.68989025E-04, 2.67813263E-04, 2.67354667E-04, 2.66856581E-04,
     &   2.65591814E-04, 2.65270929E-04, 2.65085980E-04, 2.64591822E-04,
     &   2.64881343E-04, 2.65139187E-04, 2.63240684E-04, 2.62992049E-04,
     &   2.62770977E-04, 2.64555357E-04, 2.63536910E-04, 2.63370075E-04,
     &   2.62601722E-04, 2.64121718E-04, 2.67148162E-04, 2.68861435E-04/
  
         DATA ((DGS3(I,J), I=1201,1300), J=2,2) /
     &   2.66855874E-04, 2.66722888E-04, 2.67969361E-04, 2.67045785E-04,
     &   2.67835589E-04, 2.71424639E-04, 2.84837012E-04, 2.76495101E-04,
     &   2.77057115E-04, 2.80852575E-04, 2.72119670E-04, 2.70279678E-04,
     &   2.69122994E-04, 2.75054563E-04, 2.75337611E-04, 2.87981584E-04,
     &   2.88588409E-04, 3.10755876E-04, 3.40740151E-04, 3.55446161E-04,
     &   4.15040344E-04, 4.64181296E-04, 4.60794406E-04, 4.03733880E-04,
     &   3.50884368E-04, 3.07048308E-04, 2.94646576E-04, 2.85433222E-04,
     &   2.72416172E-04, 2.63252268E-04, 2.59460797E-04, 2.56304889E-04,
     &   2.53526235E-04, 2.51059967E-04, 2.48856237E-04, 2.46876063E-04,
     &   2.45087237E-04, 2.43467334E-04, 2.41994912E-04, 2.40653347E-04,
     &   2.39428873E-04, 2.38310009E-04, 2.37287129E-04, 2.36352118E-04,
     &   2.35498117E-04, 2.34719316E-04, 2.34010788E-04, 2.33368361E-04,
     &   2.32788513E-04, 2.32268289E-04, 2.31805230E-04, 2.31397320E-04,
     &   2.31042940E-04, 2.30740835E-04, 2.30490082E-04, 2.30290070E-04,
     &   2.30140482E-04, 2.30041287E-04, 2.29992724E-04, 2.29995306E-04,
     &   2.30049817E-04, 2.30157311E-04, 2.30319124E-04, 2.30536884E-04,
     &   2.30759928E-04, 2.31139494E-04, 2.31953748E-04, 2.33074100E-04,
     &   2.34500141E-04, 2.36271805E-04, 2.38439317E-04, 2.41065937E-04,
     &   2.44231796E-04, 2.48039355E-04, 2.52621368E-04, 2.58152852E-04,
     &   2.64869769E-04, 2.73102353E-04, 2.83314871E-04, 2.96224603E-04,
     &   3.01205222E-04, 3.13453123E-04, 3.35642209E-04, 3.68346494E-04,
     &   4.13745651E-04, 4.61404949E-04, 5.01396236E-04, 6.08004665E-04,
     &   7.98784683E-04, 8.97029184E-04, 1.03474461E-03, 1.12963295E-03,
     &   1.24894614E-03, 1.36974588E-03, 1.52094625E-03, 1.61262548E-03,
     &   1.71770105E-03, 1.83925149E-03, 1.98136991E-03, 2.14961905E-03/
  
         DATA ((DGS3(I,J), I=1301,1400), J=2,2) /
     &   2.35142068E-03, 2.46850936E-03, 2.59861231E-03, 2.74399163E-03,
     &   2.90746468E-03, 3.09258552E-03, 3.30390249E-03, 3.54733204E-03,
     &   3.83071481E-03, 4.16452571E-03, 4.30365683E-03, 4.39099072E-03,
     &   4.48201005E-03, 4.57695178E-03, 4.67607361E-03, 4.77965631E-03,
     &   4.88800635E-03, 5.00145896E-03, 5.12038149E-03, 5.24517744E-03,
     &   5.37629097E-03, 5.51421219E-03, 5.65948319E-03, 5.81270522E-03,
     &   5.97454690E-03, 6.14575397E-03, 6.32716071E-03, 6.51970354E-03,
     &   6.72443706E-03, 6.94255339E-03, 7.17540526E-03, 7.42453406E-03,
     &   7.69170387E-03, 7.97894322E-03, 8.28859656E-03, 8.62338823E-03,
     &   8.98650269E-03, 9.38168591E-03, 9.81337483E-03, 1.02868644E-02,
     &   1.08085255E-02, 1.13860927E-02, 1.20290502E-02, 1.27491555E-02,
     &   1.35611645E-02, 1.44838518E-02, 1.55414794E-02, 1.67659581E-02,
     &   1.82001208E-02, 1.99028305E-02, 2.19572527E-02, 2.44848387E-02,
     &   2.76702149E-02, 3.18083846E-02, 3.74016621E-02, 4.53804389E-02,
     &   5.76820069E-02, 7.91139541E-02, 1.25751592E-01, 1.54667642E-01,
     &   2.94593853E-01, 4.09906440E-01, 4.93490483E-01, 5.58164176E-01,
     &   6.11301525E-01, 6.57802542E-01, 7.00949006E-01, 7.30985912E-01,
     &   7.61561168E-01, 7.91631661E-01, 8.06130056E-01, 8.26449273E-01,
     &   8.38624312E-01, 8.53736754E-01, 8.57675133E-01, 8.63500503E-01,
     &   8.65921408E-01, 8.64096852E-01, 8.61312860E-01, 8.57109807E-01,
     &   8.43799516E-01, 8.34465565E-01, 8.22993690E-01, 7.93436268E-01,
     &   7.75086085E-01, 7.54113888E-01, 7.30118623E-01, 6.73854461E-01,
     &   6.40811244E-01, 6.04989427E-01, 5.23563453E-01, 4.78490212E-01,
     &   3.79299761E-01, 2.70100443E-01, 2.88413080E-02, 2.66513883E-01,
     &   3.75993394E-01, 4.75036683E-01, 5.63043323E-01, 6.02608530E-01/
  
         DATA ((DGS3(I,J), I=1401,1500), J=2,2) /
     &   6.38628212E-01, 6.71539521E-01, 7.28512368E-01, 7.52451875E-01,
     &   7.73832319E-01, 7.92344739E-01, 8.22199290E-01, 8.33695438E-01,
     &   8.43262368E-01, 8.56737673E-01, 8.61088942E-01, 8.65533409E-01,
     &   8.65933508E-01, 8.63633668E-01, 8.57942390E-01, 8.49517621E-01,
     &   8.38987582E-01, 8.26856470E-01, 8.06581644E-01, 7.92178881E-01,
     &   7.62048581E-01, 7.31552681E-01, 7.01424721E-01, 6.58250341E-01,
     &   6.11710186E-01, 5.58522419E-01, 4.93784977E-01, 4.10121727E-01,
     &   2.93015825E-01, 1.59925621E-01, 9.14746780E-02, 6.40020116E-02,
     &   4.92109880E-02, 3.99712945E-02, 3.36525867E-02, 2.90592069E-02,
     &   2.55695874E-02, 2.28286725E-02, 2.06189246E-02, 1.87996307E-02,
     &   1.72757428E-02, 1.59807453E-02, 1.48666968E-02, 1.38981698E-02,
     &   1.30484184E-02, 1.22968723E-02, 1.16274519E-02, 1.10274063E-02,
     &   1.04864943E-02, 9.99639590E-03, 9.55028212E-03, 9.14249519E-03,
     &   8.76830782E-03, 8.42373952E-03, 8.10541471E-03, 7.81045200E-03,
     &   7.53637699E-03, 7.28105283E-03, 7.04262458E-03, 6.81947419E-03,
     &   6.61018387E-03, 6.41350603E-03, 6.22833849E-03, 6.05370388E-03,
     &   5.88873255E-03, 5.73264793E-03, 5.58475460E-03, 5.44442789E-03,
     &   5.31110508E-03, 5.18427793E-03, 5.06348624E-03, 4.94831233E-03,
     &   4.83837620E-03, 4.73333138E-03, 4.63286136E-03, 4.53667635E-03,
     &   4.44451059E-03, 4.35611984E-03, 4.27202819E-03, 3.63322963E-03,
     &   3.24338891E-03, 2.87187133E-03, 2.46083393E-03, 2.08612766E-03,
     &   1.72888193E-03, 1.52383512E-03, 1.26334860E-03, 1.17720580E-03,
     &   1.08377472E-03, 1.00932430E-03, 9.49215501E-04, 8.91365067E-04,
     &   8.12510427E-04, 7.33285590E-04, 5.88734073E-04, 5.16064521E-04,
     &   5.17979930E-04, 6.53653483E-04, 9.50794547E-04, 1.37390406E-03/
  
         DATA ((DGS3(I,J), I=1501,1600), J=2,2) /
     &   1.95327692E-03, 2.76782717E-03, 4.82943140E-03, 5.22160857E-03,
     &   5.68368862E-03, 5.81762148E-03, 6.12296423E-03, 6.46230954E-03,
     &   6.84165563E-03, 7.26850242E-03, 7.75234953E-03, 8.30541046E-03,
     &   8.94365683E-03, 9.68838417E-03, 1.05686318E-02, 1.16250545E-02,
     &   1.29163751E-02, 1.45306767E-02, 1.66063719E-02, 1.93741297E-02,
     &   2.32491650E-02, 2.90618006E-02, 3.87491173E-02, 5.81199822E-02,
     &   8.41048529E-02, 8.84663919E-02, 9.33047355E-02, 9.87025394E-02,
     &   1.04762722E-01, 1.11615073E-01, 1.19425630E-01, 1.28410261E-01,
     &   1.38854860E-01, 1.51146193E-01, 1.65820610E-01, 1.83643924E-01,
     &   2.05748441E-01, 2.33881106E-01, 2.70883667E-01, 3.21702549E-01,
     &   3.95754084E-01, 5.13322605E-01, 7.26681360E-01, 1.20935765E+00,
     &   1.37856141E+00, 1.51173762E+00, 1.66017411E+00, 1.78474797E+00,
     &   1.87458809E+00, 1.95078306E+00, 1.98589070E+00, 1.99982948E+00,
     &   1.98229790E+00, 1.92017569E+00, 1.84865134E+00, 1.83511713E+00,
     &   1.82808097E+00, 1.81346081E+00, 1.80740548E+00, 1.80278534E+00,
     &   1.79809735E+00, 1.74739765E+00, 1.65771905E+00, 1.53772154E+00,
     &   1.41058204E+00, 1.24772925E+00, 1.06268537E+00, 8.78475147E-01,
     &   7.69621082E-01, 6.56654449E-01, 5.40085973E-01, 3.71942313E-01,
     &   2.49173522E-01, 1.24958712E-01, 5.00334829E-02, 2.50283639E-02,
     &   3.92542424E-04, 2.50028461E-02, 1.24933245E-01, 2.49148223E-01,
     &   3.71917290E-01, 9.20741564E-01, 1.12043459E+00, 1.44040904E+00,
     &   1.56347452E+00, 1.67909690E+00, 1.77361446E+00, 1.84196408E+00,
     &   1.90106419E+00, 1.94069539E+00, 1.97151489E+00, 1.98891005E+00,
     &   1.99841695E+00, 1.99946148E+00, 1.99364680E+00, 1.98318956E+00,
     &   1.94862444E+00, 1.92532787E+00, 1.89949880E+00, 1.87459549E+00/
  
         DATA ((DGS3(I,J), I=1601,1700), J=2,2) /
     &   1.81853417E+00, 1.78785228E+00, 1.73802083E+00, 9.27779998E-01,
     &   6.09132601E-01, 4.50945394E-01, 3.57416593E-01, 2.95836525E-01,
     &   2.52283505E-01, 2.19874402E-01, 1.94826613E-01, 1.74892321E-01,
     &   1.58652971E-01, 1.45169642E-01, 1.33796352E-01, 1.24074185E-01,
     &   1.15668205E-01, 1.08328266E-01, 1.01863794E-01, 9.61270588E-02,
     &   9.10017837E-02, 8.63951988E-02, 5.81391154E-02, 3.87682523E-02,
     &   2.90809342E-02, 2.32682947E-02, 1.93932550E-02, 1.66254912E-02,
     &   1.45498037E-02, 1.29355125E-02, 1.16442051E-02, 1.05877989E-02,
     &   9.70756118E-03, 8.96284139E-03, 8.32460375E-03, 7.77155291E-03,
     &   7.28771709E-03, 6.86088253E-03, 6.48155108E-03, 6.14222420E-03,
     &   5.83691064E-03, 5.47132974E-03, 5.04494754E-03, 4.68081761E-03,
     &   4.36627772E-03, 4.09188683E-03, 3.85055695E-03, 2.97835529E-03,
     &   2.43523555E-03, 2.06588240E-03, 1.79994035E-03, 1.60148122E-03,
     &   1.44409596E-03, 1.31823048E-03, 1.22584784E-03, 6.03501033E-04,
     &   6.10481355E-04, 6.17147550E-04, 6.35113957E-04, 6.67421407E-04,
     &   7.10318031E-04, 7.42913983E-04, 7.80528325E-04, 8.88089414E-04,
     &   1.06705960E-03, 1.41051525E-03, 2.24548207E-03, 3.06777942E-03,
     &   3.28165864E-03, 3.52884874E-03, 3.81766597E-03, 4.15947228E-03,
     &   4.57017258E-03, 5.07272085E-03, 5.70156393E-03, 6.51080667E-03,
     &   7.59071716E-03, 9.10369581E-03, 1.13745609E-02, 1.51610485E-02,
     &   1.58197205E-02, 1.65382193E-02, 1.73252584E-02, 1.81910322E-02,
     &   1.91478615E-02, 2.02111462E-02, 2.13995538E-02, 2.27363865E-02,
     &   2.42516444E-02, 2.59833875E-02, 2.79813282E-02, 3.03124860E-02,
     &   3.30674511E-02, 3.63729205E-02, 4.04131408E-02, 4.16756084E-02,
     &   4.54630231E-02, 5.19541271E-02, 6.06080286E-02, 7.27194486E-02/
  
         DATA ((DGS3(I,J), I=1701,1800), J=2,2) /
     &   9.08756192E-02, 1.21093833E-01, 1.81336602E-01, 3.59395026E-01,
     &   4.27273979E-01, 6.02660610E-01, 7.36038622E-01, 8.45936638E-01,
     &   9.41856763E-01, 1.02695737E+00, 1.10330085E+00, 1.17149446E+00,
     &   1.23470294E+00, 1.29439575E+00, 1.34894836E+00, 1.39693377E+00,
     &   1.44132084E+00, 1.48134096E+00, 1.51639377E+00, 1.54969667E+00,
     &   1.57697581E+00, 1.59827811E+00, 1.61636435E+00, 1.63028534E+00,
     &   1.63890893E+00, 1.64107850E+00, 1.63741277E+00, 1.62682668E+00,
     &   1.60812143E+00, 1.57999886E+00, 1.54838249E+00, 1.49941502E+00,
     &   1.43712222E+00, 1.36023760E+00, 1.25070472E+00, 1.11880123E+00,
     &   9.40478467E-01, 7.06805541E-01, 5.03226527E-04, 7.06794058E-01,
     &   9.40468149E-01, 1.11879212E+00, 1.25069674E+00, 1.36023079E+00,
     &   1.43711641E+00, 1.49941017E+00, 1.54837858E+00, 1.57999570E+00,
     &   1.60811911E+00, 1.62682517E+00, 1.63741200E+00, 1.64107843E+00,
     &   1.63890950E+00, 1.63028661E+00, 1.61636626E+00, 1.59828058E+00,
     &   1.57697881E+00, 1.54970020E+00, 1.51639784E+00, 1.48134551E+00,
     &   1.44132586E+00, 1.39693925E+00, 1.34895426E+00, 1.29440207E+00,
     &   1.23470966E+00, 1.17150156E+00, 1.10330831E+00, 1.02696518E+00,
     &   9.41864913E-01, 8.45945114E-01, 7.36047410E-01, 6.02669700E-01,
     &   4.27283361E-01, 3.59366237E-01, 1.81336383E-01, 1.21103472E-01,
     &   9.08827934E-02, 7.27275169E-02, 6.06176845E-02, 5.19637846E-02,
     &   4.54720620E-02, 4.04228003E-02, 3.63825807E-02, 3.30767835E-02,
     &   3.03221462E-02, 2.79909888E-02, 2.59928462E-02, 2.42613060E-02,
     &   2.27460478E-02, 1.51707171E-02, 1.13842338E-02, 9.11338654E-03,
     &   7.60042081E-03, 6.52050595E-03, 5.71124830E-03, 5.08244960E-03,
     &   4.57996602E-03, 4.16934377E-03, 3.82763435E-03, 3.53890260E-03/
  
         DATA ((DGS3(I,J), I=1801,1900), J=2,2) /
     &   3.29179248E-03, 3.07815313E-03, 2.31416910E-03, 1.76403029E-03,
     &   1.44314314E-03, 1.23584344E-03, 1.09297094E-03, 9.90014678E-04,
     &   9.13428836E-04, 8.55118853E-04, 8.09912517E-04, 7.74382242E-04,
     &   7.46220493E-04, 7.23811307E-04, 7.06006459E-04, 6.91989548E-04,
     &   6.81196053E-04, 6.73277114E-04, 6.68115565E-04, 6.65952003E-04,
     &   6.65283755E-04, 6.62559336E-04, 6.61527834E-04, 6.62733692E-04,
     &   8.40418610E-04, 9.98227353E-04, 1.12837323E-03, 1.23724249E-03,
     &   1.33010572E-03, 1.40944582E-03, 1.47779036E-03, 1.53637736E-03,
     &   1.58578654E-03, 1.62742040E-03, 1.66183691E-03, 1.68915958E-03,
     &   1.70984843E-03, 1.72432453E-03, 1.73284317E-03, 1.73544343E-03,
     &   1.73233206E-03, 1.72357175E-03, 1.70894894E-03, 1.68878424E-03,
     &   1.66345419E-03, 1.63133735E-03, 1.59451387E-03, 1.55068982E-03,
     &   1.50069185E-03, 1.44331997E-03, 1.37839818E-03, 1.30593670E-03,
     &   1.22614804E-03, 1.13346038E-03, 1.02987356E-03, 9.14647304E-04,
     &   7.80564290E-04, 6.30141279E-04, 5.49044012E-04, 8.73213249E-04,
     &   1.03725680E-03, 1.16228643E-03, 1.26156364E-03, 1.34613886E-03,
     &   1.41857339E-03, 1.47858987E-03, 1.53117625E-03, 1.57659325E-03,
     &   1.61520401E-03, 1.64741240E-03, 1.67423533E-03, 1.69538012E-03,
     &   1.71224493E-03, 1.72386709E-03, 1.73113620E-03, 1.73381380E-03,
     &   1.73192793E-03, 1.72562915E-03, 1.71458791E-03, 1.69877944E-03,
     &   1.67833898E-03, 1.65281953E-03, 1.62183881E-03, 1.58507053E-03,
     &   1.54258445E-03, 1.49276799E-03, 1.43554455E-03, 1.36948581E-03,
     &   1.29378960E-03, 1.20551995E-03, 1.10243191E-03, 9.76864590E-04,
     &   8.13874940E-04, 6.04837145E-04, 5.86071159E-04, 5.60286988E-04,
     &   5.50911013E-04, 5.47055646E-04, 5.44855125E-04, 5.44524467E-04/
  
         DATA ((DGS3(I,J), I=1901,2000), J=2,2) /
     &   5.45456607E-04, 5.46817646E-04, 5.48314043E-04, 5.49599125E-04,
     &   5.50600134E-04, 5.51431159E-04, 5.51881382E-04, 5.52048788E-04,
     &   5.51796394E-04, 5.50945271E-04, 5.49665726E-04, 5.47836012E-04,
     &   5.45509420E-04, 5.42652473E-04, 5.39236378E-04, 5.35120259E-04,
     &   5.30396164E-04, 5.25040521E-04, 5.19004408E-04, 5.12269235E-04,
     &   5.04822498E-04, 4.96644171E-04, 4.87413842E-04, 4.77362935E-04,
     &   4.66588238E-04, 4.52972514E-04, 4.38190420E-04, 4.22473517E-04,
     &   4.00408331E-04, 3.79254194E-04, 3.90066261E-04, 4.00696580E-04,
     &   4.11564280E-04, 4.21625253E-04, 4.30308245E-04, 4.38659805E-04,
     &   4.46611311E-04, 4.53930336E-04, 4.60829622E-04, 4.67259080E-04,
     &   4.73246824E-04, 4.78802338E-04, 4.83894407E-04, 4.88577763E-04,
     &   4.92877966E-04, 4.96727363E-04, 5.00202323E-04, 5.03333096E-04,
     &   5.06004810E-04, 5.08307349E-04, 5.10258708E-04, 5.11916118E-04,
     &   5.13264746E-04, 5.14304471E-04, 5.14955117E-04, 5.15318765E-04,
     &   5.15524542E-04, 5.15664354E-04, 5.15779906E-04, 5.16036201E-04,
     &   5.16744148E-04, 5.14900772E-04, 5.10943379E-04, 5.06458395E-04,
     &   4.97653059E-04, 4.91247459E-04, 4.90894984E-04, 4.90466256E-04,
     &   4.89927786E-04, 4.89270155E-04, 4.88509453E-04, 4.87645360E-04,
     &   4.86668028E-04, 4.83640909E-04, 4.80540353E-04, 4.77514089E-04,
     &   4.74519132E-04, 4.71498462E-04, 4.68419977E-04, 4.65271330E-04,
     &   4.62043038E-04, 4.58742515E-04, 4.55306343E-04, 4.51703011E-04,
     &   4.47964403E-04, 4.44045758E-04, 4.40033361E-04, 4.35796709E-04,
     &   4.31352730E-04, 4.26694744E-04, 4.21754324E-04, 4.16874713E-04,
     &   4.11012348E-04, 4.04915323E-04, 3.98698029E-04, 3.92507770E-04,
     &   3.85244073E-04, 3.77444275E-04, 3.69518972E-04, 3.60640677E-04/
  
         DATA ((DGS3(I,J), I=2001,2100), J=2,2) /
     &   3.49675861E-04, 3.52135001E-04, 3.57661490E-04, 3.63322969E-04,
     &   3.68224558E-04, 3.73366758E-04, 3.78543407E-04, 3.83645600E-04,
     &   3.87837041E-04, 3.92113682E-04, 3.95997287E-04, 3.99874005E-04,
     &   4.03567264E-04, 4.07079876E-04, 4.10463612E-04, 4.13699213E-04,
     &   4.16803608E-04, 4.19713670E-04, 4.22506614E-04, 4.25201029E-04,
     &   4.27765329E-04, 4.30256331E-04, 4.32632847E-04, 4.34922270E-04,
     &   4.37186957E-04, 4.39450775E-04, 4.41643072E-04, 4.42845565E-04,
     &   4.44113539E-04, 4.45520115E-04, 4.47189932E-04, 4.49259572E-04,
     &   4.51194497E-04, 4.50645009E-04, 4.49974369E-04, 4.50403781E-04,
     &   4.67611160E-04, 4.68586233E-04, 4.72651174E-04, 4.87667936E-04,
     &   5.07810219E-04, 5.35173859E-04, 5.65062967E-04, 6.00277364E-04,
     &   6.38934417E-04, 6.79245647E-04, 7.25943374E-04, 7.75329228E-04,
     &   7.98022793E-04, 8.20716357E-04, 7.75847277E-04, 7.41311781E-04,
     &   7.12423925E-04, 6.85728651E-04, 6.62904471E-04, 6.41434189E-04,
     &   6.22795177E-04, 6.05036917E-04, 5.88775707E-04, 5.74439152E-04,
     &   5.60592105E-04, 5.48282367E-04, 5.36312868E-04, 5.25605353E-04,
     &   5.15136645E-04, 5.05722956E-04, 4.96477181E-04, 4.88126685E-04,
     &   4.79893433E-04, 4.72429454E-04, 4.65352893E-04, 4.58336046E-04,
     &   4.51944961E-04, 4.45596372E-04, 4.39798249E-04, 4.34024954E-04,
     &   4.28739592E-04, 4.23465707E-04, 4.18627162E-04, 4.13789955E-04,
     &   4.09343422E-04, 4.04890506E-04, 4.00611980E-04, 3.96672928E-04,
     &   3.92719174E-04, 3.89069651E-04, 3.85401549E-04, 3.82010896E-04,
     &   3.78598748E-04, 3.75440559E-04, 3.72258706E-04, 3.69310095E-04,
     &   3.66336241E-04, 3.63577268E-04, 3.60907937E-04, 3.58208417E-04,
     &   3.55700082E-04, 3.53164384E-04, 3.50806014E-04, 3.48419939E-04/
  
         DATA ((DGS3(I,J), I=2101,2164), J=2,2) /
     &   3.46198734E-04, 3.43949210E-04, 3.41853778E-04, 3.39730536E-04,
     &   3.37750746E-04, 3.35743297E-04, 3.33790196E-04, 3.31966935E-04,
     &   3.30117719E-04, 3.28390291E-04, 3.26585553E-04, 3.24945328E-04,
     &   3.23278659E-04, 3.21719742E-04, 3.20134834E-04, 3.18651499E-04,
     &   3.17142658E-04, 3.15729704E-04, 3.14291748E-04, 3.12944435E-04,
     &   3.11629673E-04, 3.10288629E-04, 3.09031145E-04, 3.07749969E-04,
     &   3.06548028E-04, 3.05322932E-04, 3.04173057E-04, 3.03000560E-04,
     &   3.01899553E-04, 3.00776454E-04, 2.99721372E-04, 2.98644723E-04,
     &   2.88607570E-04, 2.80135399E-04, 2.78657634E-04, 2.47246714E-04,
     &   2.38476851E-04, 2.26972606E-04, 2.22710066E-04, 2.22340494E-04,
     &   2.19069918E-04, 2.18851522E-04, 2.17122321E-04, 2.16950676E-04,
     &   2.16913070E-04, 2.16224567E-04, 2.15768476E-04, 2.15670783E-04,
     &   2.15554116E-04, 2.15385606E-04, 2.15264548E-04, 2.15189362E-04,
     &   2.14580161E-04, 2.14510096E-04, 2.14347076E-04, 2.14306508E-04,
     &   2.14177182E-04, 2.14122482E-04, 2.14080547E-04, 2.14042273E-04,
     &   2.13935005E-04, 2.13801850E-04, 2.13717582E-04, 2.13352984E-04/
c
      save
      RETURN
      END
c
       subroutine dalhad_timelike1h12
       IMPLICIT NONE
       INTEGER NC,I,J
       PARAMETER(NC=200)
       REAL EMA(NC),DAM(NC,2),DGM(NC,2),DGM3(NC,2)
       COMMON /DATM12/EMA,DAM,DGM,DGM3
  
c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 10:34:48 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: 2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c
c replaced March 30, 2012 [dalhads.dat;426]
  
       DATA  (EMA(I), I=   1, 100) /
     &   1.3005E+01, 1.3500E+01, 1.4000E+01, 1.4500E+01, 1.5000E+01,
     &   1.6000E+01, 1.7000E+01, 1.8000E+01, 1.9000E+01, 2.0000E+01,
     &   2.1000E+01, 2.2000E+01, 2.3000E+01, 2.4000E+01, 2.5000E+01,
     &   2.6000E+01, 2.7000E+01, 2.8000E+01, 2.9000E+01, 3.0000E+01,
     &   3.1000E+01, 3.2000E+01, 3.3000E+01, 3.4000E+01, 3.5000E+01,
     &   3.6000E+01, 3.7000E+01, 3.8000E+01, 3.9000E+01, 4.0000E+01,
     &   4.1000E+01, 4.2000E+01, 4.3000E+01, 4.4000E+01, 4.5000E+01,
     &   4.6000E+01, 4.7000E+01, 4.8000E+01, 4.9000E+01, 5.0000E+01,
     &   5.1000E+01, 5.2000E+01, 5.3000E+01, 5.4000E+01, 5.5000E+01,
     &   5.6000E+01, 5.7000E+01, 5.8000E+01, 5.9000E+01, 6.0000E+01,
     &   6.1000E+01, 6.2000E+01, 6.3000E+01, 6.4000E+01, 6.5000E+01,
     &   6.6000E+01, 6.7000E+01, 6.8000E+01, 6.9000E+01, 7.0000E+01,
     &   7.1000E+01, 7.2000E+01, 7.3000E+01, 7.4000E+01, 7.5000E+01,
     &   7.6000E+01, 7.7000E+01, 7.8000E+01, 7.9000E+01, 8.0000E+01,
     &   8.1000E+01, 8.2000E+01, 8.3000E+01, 8.4000E+01, 8.5000E+01,
     &   8.6000E+01, 8.7000E+01, 8.8000E+01, 8.9000E+01, 9.0000E+01,
     &   9.1000E+01, 9.2000E+01, 9.3000E+01, 9.4000E+01, 9.5000E+01,
     &   9.6000E+01, 9.7000E+01, 9.8000E+01, 9.9000E+01, 1.0000E+02,
     &   1.0900E+02, 1.1800E+02, 1.2700E+02, 1.3600E+02, 1.4500E+02,
     &   1.5400E+02, 1.6300E+02, 1.7200E+02, 1.8100E+02, 1.9000E+02/
  
       DATA  (EMA(I), I= 101, 200) /
     &   1.9900E+02, 2.0800E+02, 2.1700E+02, 2.2600E+02, 2.3500E+02,
     &   2.4400E+02, 2.5300E+02, 2.6200E+02, 2.7100E+02, 2.8000E+02,
     &   2.8900E+02, 2.9800E+02, 3.0700E+02, 3.1600E+02, 3.2500E+02,
     &   3.3400E+02, 3.4300E+02, 3.5200E+02, 3.6100E+02, 3.7000E+02,
     &   3.7900E+02, 3.8800E+02, 3.9700E+02, 4.0600E+02, 4.1500E+02,
     &   4.2400E+02, 4.3300E+02, 4.4200E+02, 4.5100E+02, 4.6000E+02,
     &   4.6900E+02, 4.7800E+02, 4.8700E+02, 4.9600E+02, 5.0500E+02,
     &   5.1400E+02, 5.2300E+02, 5.3200E+02, 5.4100E+02, 5.5000E+02,
     &   5.5900E+02, 5.6800E+02, 5.7700E+02, 5.8600E+02, 5.9500E+02,
     &   6.0400E+02, 6.1300E+02, 6.2200E+02, 6.3100E+02, 6.4000E+02,
     &   6.4900E+02, 6.5800E+02, 6.6700E+02, 6.7600E+02, 6.8500E+02,
     &   6.9400E+02, 7.0300E+02, 7.1200E+02, 7.2100E+02, 7.3000E+02,
     &   7.3900E+02, 7.4800E+02, 7.5700E+02, 7.6600E+02, 7.7500E+02,
     &   7.8400E+02, 7.9300E+02, 8.0200E+02, 8.1100E+02, 8.2000E+02,
     &   8.2900E+02, 8.3800E+02, 8.4700E+02, 8.5600E+02, 8.6500E+02,
     &   8.7400E+02, 8.8300E+02, 8.9200E+02, 9.0100E+02, 9.1000E+02,
     &   9.1900E+02, 9.2800E+02, 9.3700E+02, 9.4600E+02, 9.5500E+02,
     &   9.6400E+02, 9.7300E+02, 9.8200E+02, 9.9100E+02, 1.0000E+03,
     &   2.0000E+03, 3.0000E+03, 4.0000E+03, 5.0000E+03, 6.0000E+03,
     &   8.0000E+03, 1.0000E+04, 1.2000E+04, 1.4000E+04, 2.0000E+04/
  
         DATA ((DAM (I,J), I=   1, 100), J=1,1) /
     &   1.5865E-02, 1.6112E-02, 1.6348E-02, 1.6573E-02, 1.6789E-02,
     &   1.7195E-02, 1.7573E-02, 1.7937E-02, 1.8258E-02, 1.8571E-02,
     &   1.8868E-02, 1.9150E-02, 1.9418E-02, 1.9675E-02, 1.9921E-02,
     &   2.0157E-02, 2.0385E-02, 2.0601E-02, 2.0811E-02, 2.1014E-02,
     &   2.1210E-02, 2.1400E-02, 2.1584E-02, 2.1761E-02, 2.1939E-02,
     &   2.2145E-02, 2.2265E-02, 2.2424E-02, 2.2578E-02, 2.2729E-02,
     &   2.2877E-02, 2.3020E-02, 2.3159E-02, 2.3306E-02, 2.3428E-02,
     &   2.3559E-02, 2.3686E-02, 2.3811E-02, 2.3934E-02, 2.4053E-02,
     &   2.4171E-02, 2.4286E-02, 2.4399E-02, 2.4510E-02, 2.4618E-02,
     &   2.4758E-02, 2.4830E-02, 2.4933E-02, 2.5034E-02, 2.5295E-02,
     &   2.5232E-02, 2.5328E-02, 2.5423E-02, 2.5516E-02, 2.5607E-02,
     &   2.5698E-02, 2.5787E-02, 2.5874E-02, 2.5961E-02, 2.6046E-02,
     &   2.6130E-02, 2.6213E-02, 2.6294E-02, 2.6375E-02, 2.6454E-02,
     &   2.6865E-02, 2.6610E-02, 2.6686E-02, 2.6761E-02, 2.6836E-02,
     &   2.6909E-02, 2.6982E-02, 2.7053E-02, 2.7124E-02, 2.7194E-02,
     &   2.7263E-02, 2.7332E-02, 2.7399E-02, 2.7466E-02, 2.7532E-02,
     &   2.7597E-02, 2.7662E-02, 2.7726E-02, 2.7789E-02, 2.7851E-02,
     &   2.7913E-02, 2.7975E-02, 2.8035E-02, 2.8095E-02, 2.8155E-02,
     &   2.8664E-02, 2.9133E-02, 2.9568E-02, 2.9973E-02, 3.0352E-02,
     &   3.0709E-02, 3.1045E-02, 3.1364E-02, 3.1666E-02, 3.1955E-02/
  
         DATA ((DAM (I,J), I= 101, 200), J=1,1) /
     &   3.2230E-02, 3.2493E-02, 3.2745E-02, 3.2987E-02, 3.3221E-02,
     &   3.3445E-02, 3.3662E-02, 3.3871E-02, 3.4074E-02, 3.4271E-02,
     &   3.4461E-02, 3.4646E-02, 3.4826E-02, 3.5001E-02, 3.5171E-02,
     &   3.5337E-02, 3.5499E-02, 3.5656E-02, 3.5812E-02, 3.5963E-02,
     &   3.6112E-02, 3.6258E-02, 3.6400E-02, 3.6539E-02, 3.6676E-02,
     &   3.6811E-02, 3.6943E-02, 3.7073E-02, 3.7200E-02, 3.7326E-02,
     &   3.7450E-02, 3.7571E-02, 3.7691E-02, 3.7810E-02, 3.7920E-02,
     &   3.8024E-02, 3.8125E-02, 3.8225E-02, 3.8324E-02, 3.8420E-02,
     &   3.8515E-02, 3.8609E-02, 3.8701E-02, 3.8791E-02, 3.8880E-02,
     &   3.8968E-02, 3.9055E-02, 3.9140E-02, 3.9224E-02, 3.9307E-02,
     &   3.9389E-02, 3.9469E-02, 3.9549E-02, 3.9627E-02, 3.9705E-02,
     &   3.9781E-02, 3.9856E-02, 3.9931E-02, 4.0004E-02, 4.0077E-02,
     &   4.0148E-02, 4.0219E-02, 4.0289E-02, 4.0358E-02, 4.0427E-02,
     &   4.0494E-02, 4.0561E-02, 4.0627E-02, 4.0692E-02, 4.0757E-02,
     &   4.0821E-02, 4.0884E-02, 4.0946E-02, 4.1008E-02, 4.1069E-02,
     &   4.1130E-02, 4.1189E-02, 4.1249E-02, 4.1307E-02, 4.1365E-02,
     &   4.1423E-02, 4.1480E-02, 4.1536E-02, 4.1592E-02, 4.1647E-02,
     &   4.1702E-02, 4.1757E-02, 4.1810E-02, 4.1864E-02, 4.1916E-02,
     &   4.5963E-02, 4.8329E-02, 5.0003E-02, 5.1304E-02, 5.2366E-02,
     &   5.4038E-02, 5.5336E-02, 5.6397E-02, 5.7292E-02, 5.9364E-02/
  
         DATA ((DAM (I,J), I=   1, 100), J=2,2) /
     &   2.0179E-04, 1.9322E-04, 1.8785E-04, 1.8419E-04, 1.8153E-04,
     &   1.7790E-04, 1.7551E-04, 1.7382E-04, 1.7255E-04, 1.7156E-04,
     &   1.7076E-04, 1.7011E-04, 1.6957E-04, 1.6912E-04, 1.6873E-04,
     &   1.6839E-04, 1.6810E-04, 1.6785E-04, 1.6762E-04, 1.6742E-04,
     &   1.6724E-04, 1.6708E-04, 1.6694E-04, 1.6681E-04, 1.6669E-04,
     &   1.6659E-04, 1.6648E-04, 1.6639E-04, 1.6631E-04, 1.6623E-04,
     &   1.6616E-04, 1.6610E-04, 1.6604E-04, 1.6599E-04, 1.6593E-04,
     &   1.6588E-04, 1.6584E-04, 1.6580E-04, 1.6576E-04, 1.6572E-04,
     &   1.6569E-04, 1.6565E-04, 1.6562E-04, 1.6559E-04, 1.6557E-04,
     &   1.6555E-04, 1.6552E-04, 1.6549E-04, 1.6547E-04, 1.6547E-04,
     &   1.6543E-04, 1.6541E-04, 1.6539E-04, 1.6538E-04, 1.6536E-04,
     &   1.6535E-04, 1.6533E-04, 1.6532E-04, 1.6530E-04, 1.6529E-04,
     &   1.6528E-04, 1.6527E-04, 1.6526E-04, 1.6525E-04, 1.6524E-04,
     &   1.6526E-04, 1.6522E-04, 1.6521E-04, 1.6520E-04, 1.6519E-04,
     &   1.6518E-04, 1.6518E-04, 1.6517E-04, 1.6516E-04, 1.6515E-04,
     &   1.6515E-04, 1.6514E-04, 1.6514E-04, 1.6513E-04, 1.6512E-04,
     &   1.6512E-04, 1.6511E-04, 1.6511E-04, 1.6510E-04, 1.6510E-04,
     &   1.6509E-04, 1.6509E-04, 1.6508E-04, 1.6508E-04, 1.6508E-04,
     &   1.6504E-04, 1.6502E-04, 1.6500E-04, 1.6499E-04, 1.6497E-04,
     &   1.6496E-04, 1.6496E-04, 1.6495E-04, 1.6494E-04, 1.6494E-04/
  
         DATA ((DAM (I,J), I= 101, 200), J=2,2) /
     &   1.6494E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04, 1.6493E-04,
     &   1.6495E-04, 1.6496E-04, 1.6497E-04, 1.6497E-04, 1.6497E-04,
     &   1.6498E-04, 1.6499E-04, 1.6499E-04, 1.6500E-04, 1.6500E-04/

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 10:47:22 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: 2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c
c replaced March 30, 2012 [dalhads.dat;427]
  
       DATA  (EMA(I), I= 101, 200) /
     &   1.9900E+02, 2.0800E+02, 2.1700E+02, 2.2600E+02, 2.3500E+02,
     &   2.4400E+02, 2.5300E+02, 2.6200E+02, 2.7100E+02, 2.8000E+02,
     &   2.8900E+02, 2.9800E+02, 3.0700E+02, 3.1600E+02, 3.2500E+02,
     &   3.3400E+02, 3.4300E+02, 3.5200E+02, 3.6100E+02, 3.7000E+02,
     &   3.7900E+02, 3.8800E+02, 3.9700E+02, 4.0600E+02, 4.1500E+02,
     &   4.2400E+02, 4.3300E+02, 4.4200E+02, 4.5100E+02, 4.6000E+02,
     &   4.6900E+02, 4.7800E+02, 4.8700E+02, 4.9600E+02, 5.0500E+02,
     &   5.1400E+02, 5.2300E+02, 5.3200E+02, 5.4100E+02, 5.5000E+02,
     &   5.5900E+02, 5.6800E+02, 5.7700E+02, 5.8600E+02, 5.9500E+02,
     &   6.0400E+02, 6.1300E+02, 6.2200E+02, 6.3100E+02, 6.4000E+02,
     &   6.4900E+02, 6.5800E+02, 6.6700E+02, 6.7600E+02, 6.8500E+02,
     &   6.9400E+02, 7.0300E+02, 7.1200E+02, 7.2100E+02, 7.3000E+02,
     &   7.3900E+02, 7.4800E+02, 7.5700E+02, 7.6600E+02, 7.7500E+02,
     &   7.8400E+02, 7.9300E+02, 8.0200E+02, 8.1100E+02, 8.2000E+02,
     &   8.2900E+02, 8.3800E+02, 8.4700E+02, 8.5600E+02, 8.6500E+02,
     &   8.7400E+02, 8.8300E+02, 8.9200E+02, 9.0100E+02, 9.1000E+02,
     &   9.1900E+02, 9.2800E+02, 9.3700E+02, 9.4600E+02, 9.5500E+02,
     &   9.6400E+02, 9.7300E+02, 9.8200E+02, 9.9100E+02, 1.0000E+03,
     &   2.0000E+03, 3.0000E+03, 4.0000E+03, 5.0000E+03, 6.0000E+03,
     &   8.0000E+03, 1.0000E+04, 1.2000E+04, 1.4000E+04, 2.0000E+04/
  
         DATA ((DGM (I,J), I=   1, 100), J=1,1) /
     &   3.0625E-02, 3.1160E-02, 3.1670E-02, 3.2153E-02, 3.2614E-02,
     &   3.3476E-02, 3.4273E-02, 3.5039E-02, 3.5711E-02, 3.6367E-02,
     &   3.6986E-02, 3.7574E-02, 3.8133E-02, 3.8667E-02, 3.9178E-02,
     &   3.9668E-02, 4.0142E-02, 4.0590E-02, 4.1025E-02, 4.1445E-02,
     &   4.1851E-02, 4.2244E-02, 4.2624E-02, 4.2991E-02, 4.3359E-02,
     &   4.3787E-02, 4.4033E-02, 4.4361E-02, 4.4681E-02, 4.4992E-02,
     &   4.5298E-02, 4.5594E-02, 4.5880E-02, 4.6185E-02, 4.6437E-02,
     &   4.6706E-02, 4.6970E-02, 4.7228E-02, 4.7480E-02, 4.7728E-02,
     &   4.7970E-02, 4.8208E-02, 4.8441E-02, 4.8669E-02, 4.8894E-02,
     &   4.9183E-02, 4.9330E-02, 4.9543E-02, 4.9752E-02, 5.0292E-02,
     &   5.0159E-02, 5.0357E-02, 5.0553E-02, 5.0745E-02, 5.0934E-02,
     &   5.1121E-02, 5.1304E-02, 5.1485E-02, 5.1663E-02, 5.1839E-02,
     &   5.2012E-02, 5.2183E-02, 5.2351E-02, 5.2517E-02, 5.2681E-02,
     &   5.3533E-02, 5.3002E-02, 5.3159E-02, 5.3314E-02, 5.3468E-02,
     &   5.3619E-02, 5.3769E-02, 5.3917E-02, 5.4063E-02, 5.4207E-02,
     &   5.4349E-02, 5.4490E-02, 5.4630E-02, 5.4767E-02, 5.4904E-02,
     &   5.5038E-02, 5.5172E-02, 5.5303E-02, 5.5434E-02, 5.5563E-02,
     &   5.5690E-02, 5.5817E-02, 5.5942E-02, 5.6065E-02, 5.6188E-02,
     &   5.7238E-02, 5.8205E-02, 5.9101E-02, 5.9937E-02, 6.0718E-02,
     &   6.1454E-02, 6.2147E-02, 6.2804E-02, 6.3428E-02, 6.4022E-02/
  
         DATA ((DGM (I,J), I= 101, 200), J=1,1) /
     &   6.4589E-02, 6.5132E-02, 6.5652E-02, 6.6152E-02, 6.6632E-02,
     &   6.7095E-02, 6.7542E-02, 6.7974E-02, 6.8392E-02, 6.8797E-02,
     &   6.9190E-02, 6.9571E-02, 6.9942E-02, 7.0303E-02, 7.0654E-02,
     &   7.0996E-02, 7.1329E-02, 7.1654E-02, 7.1973E-02, 7.2287E-02,
     &   7.2593E-02, 7.2893E-02, 7.3186E-02, 7.3474E-02, 7.3756E-02,
     &   7.4033E-02, 7.4306E-02, 7.4573E-02, 7.4836E-02, 7.5095E-02,
     &   7.5350E-02, 7.5601E-02, 7.5849E-02, 7.6093E-02, 7.6321E-02,
     &   7.6534E-02, 7.6744E-02, 7.6950E-02, 7.7152E-02, 7.7351E-02,
     &   7.7547E-02, 7.7740E-02, 7.7929E-02, 7.8116E-02, 7.8300E-02,
     &   7.8481E-02, 7.8660E-02, 7.8836E-02, 7.9009E-02, 7.9180E-02,
     &   7.9348E-02, 7.9514E-02, 7.9678E-02, 7.9840E-02, 7.9999E-02,
     &   8.0157E-02, 8.0312E-02, 8.0465E-02, 8.0617E-02, 8.0766E-02,
     &   8.0914E-02, 8.1060E-02, 8.1204E-02, 8.1347E-02, 8.1488E-02,
     &   8.1627E-02, 8.1764E-02, 8.1900E-02, 8.2035E-02, 8.2168E-02,
     &   8.2300E-02, 8.2430E-02, 8.2558E-02, 8.2686E-02, 8.2812E-02,
     &   8.2937E-02, 8.3060E-02, 8.3182E-02, 8.3303E-02, 8.3423E-02,
     &   8.3541E-02, 8.3659E-02, 8.3775E-02, 8.3890E-02, 8.4004E-02,
     &   8.4117E-02, 8.4229E-02, 8.4340E-02, 8.4450E-02, 8.4558E-02,
     &   9.2901E-02, 9.7778E-02, 1.0123E-01, 1.0391E-01, 1.0610E-01,
     &   1.0955E-01, 1.1222E-01, 1.1441E-01, 1.1625E-01, 1.2053E-01/
  
         DATA ((DGM (I,J), I=   1, 100), J=2,2) /
     &   5.0397E-04, 4.6944E-04, 4.4785E-04, 4.3330E-04, 4.2289E-04,
     &   4.0903E-04, 4.0028E-04, 3.9428E-04, 3.8990E-04, 3.8659E-04,
     &   3.8400E-04, 3.8192E-04, 3.8022E-04, 3.7881E-04, 3.7762E-04,
     &   3.7660E-04, 3.7573E-04, 3.7497E-04, 3.7430E-04, 3.7372E-04,
     &   3.7320E-04, 3.7274E-04, 3.7232E-04, 3.7195E-04, 3.7162E-04,
     &   3.7133E-04, 3.7103E-04, 3.7078E-04, 3.7055E-04, 3.7033E-04,
     &   3.7014E-04, 3.6996E-04, 3.6979E-04, 3.6964E-04, 3.6949E-04,
     &   3.6936E-04, 3.6923E-04, 3.6912E-04, 3.6901E-04, 3.6891E-04,
     &   3.6881E-04, 3.6872E-04, 3.6864E-04, 3.6856E-04, 3.6849E-04,
     &   3.6844E-04, 3.6835E-04, 3.6829E-04, 3.6823E-04, 3.6824E-04,
     &   3.6812E-04, 3.6806E-04, 3.6802E-04, 3.6797E-04, 3.6793E-04,
     &   3.6789E-04, 3.6785E-04, 3.6781E-04, 3.6777E-04, 3.6774E-04,
     &   3.6770E-04, 3.6767E-04, 3.6764E-04, 3.6761E-04, 3.6759E-04,
     &   3.6769E-04, 3.6753E-04, 3.6751E-04, 3.6749E-04, 3.6746E-04,
     &   3.6744E-04, 3.6742E-04, 3.6740E-04, 3.6738E-04, 3.6736E-04,
     &   3.6734E-04, 3.6733E-04, 3.6731E-04, 3.6729E-04, 3.6728E-04,
     &   3.6726E-04, 3.6725E-04, 3.6723E-04, 3.6722E-04, 3.6721E-04,
     &   3.6720E-04, 3.6718E-04, 3.6717E-04, 3.6716E-04, 3.6715E-04,
     &   3.6706E-04, 3.6700E-04, 3.6695E-04, 3.6690E-04, 3.6687E-04,
     &   3.6684E-04, 3.6682E-04, 3.6680E-04, 3.6679E-04, 3.6678E-04/
  
         DATA ((DGM (I,J), I= 101, 200), J=2,2) /
     &   3.6676E-04, 3.6676E-04, 3.6675E-04, 3.6674E-04, 3.6674E-04,
     &   3.6673E-04, 3.6673E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04,
     &   3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04,
     &   3.6671E-04, 3.6671E-04, 3.6670E-04, 3.6670E-04, 3.6670E-04,
     &   3.6670E-04, 3.6670E-04, 3.6670E-04, 3.6670E-04, 3.6670E-04,
     &   3.6670E-04, 3.6670E-04, 3.6670E-04, 3.6670E-04, 3.6670E-04,
     &   3.6670E-04, 3.6670E-04, 3.6670E-04, 3.6671E-04, 3.6671E-04,
     &   3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04,
     &   3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04,
     &   3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04,
     &   3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04, 3.6671E-04,
     &   3.6671E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04,
     &   3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04,
     &   3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04,
     &   3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04, 3.6672E-04,
     &   3.6672E-04, 3.6672E-04, 3.6673E-04, 3.6673E-04, 3.6673E-04,
     &   3.6673E-04, 3.6673E-04, 3.6673E-04, 3.6673E-04, 3.6673E-04,
     &   3.6673E-04, 3.6673E-04, 3.6673E-04, 3.6673E-04, 3.6673E-04,
     &   3.6676E-04, 3.6678E-04, 3.6680E-04, 3.6681E-04, 3.6681E-04,
     &   3.6683E-04, 3.6685E-04, 3.6684E-04, 3.6686E-04, 3.6688E-04/

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 11:00:14 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: 2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 4,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
c replaced March 30, 2012 [dalhads.dat;428]
  
         DATA ((DGM3(I,J), I=   1, 100), J=1,1) /
     &   1.6023E-02, 1.6325E-02, 1.6611E-02, 1.6880E-02, 1.7136E-02,
     &   1.7612E-02, 1.8049E-02, 1.8468E-02, 1.8835E-02, 1.9191E-02,
     &   1.9527E-02, 1.9846E-02, 2.0148E-02, 2.0437E-02, 2.0713E-02,
     &   2.0977E-02, 2.1233E-02, 2.1474E-02, 2.1708E-02, 2.1935E-02,
     &   2.2153E-02, 2.2364E-02, 2.2569E-02, 2.2766E-02, 2.2964E-02,
     &   2.3194E-02, 2.3326E-02, 2.3502E-02, 2.3674E-02, 2.3841E-02,
     &   2.4005E-02, 2.4164E-02, 2.4318E-02, 2.4482E-02, 2.4617E-02,
     &   2.4761E-02, 2.4903E-02, 2.5041E-02, 2.5177E-02, 2.5309E-02,
     &   2.5439E-02, 2.5567E-02, 2.5692E-02, 2.5814E-02, 2.5935E-02,
     &   2.6090E-02, 2.6169E-02, 2.6283E-02, 2.6395E-02, 2.6686E-02,
     &   2.6613E-02, 2.6720E-02, 2.6824E-02, 2.6927E-02, 2.7029E-02,
     &   2.7129E-02, 2.7227E-02, 2.7324E-02, 2.7420E-02, 2.7514E-02,
     &   2.7607E-02, 2.7698E-02, 2.7788E-02, 2.7877E-02, 2.7965E-02,
     &   2.8425E-02, 2.8137E-02, 2.8221E-02, 2.8305E-02, 2.8387E-02,
     &   2.8468E-02, 2.8548E-02, 2.8628E-02, 2.8706E-02, 2.8783E-02,
     &   2.8860E-02, 2.8935E-02, 2.9010E-02, 2.9084E-02, 2.9157E-02,
     &   2.9229E-02, 2.9300E-02, 2.9371E-02, 2.9441E-02, 2.9510E-02,
     &   2.9578E-02, 2.9646E-02, 2.9713E-02, 2.9779E-02, 2.9845E-02,
     &   3.0408E-02, 3.0926E-02, 3.1406E-02, 3.1853E-02, 3.2272E-02,
     &   3.2666E-02, 3.3038E-02, 3.3390E-02, 3.3724E-02, 3.4042E-02/
  
         DATA ((DGM3(I,J), I= 101, 200), J=1,1) /
     &   3.4346E-02, 3.4637E-02, 3.4916E-02, 3.5183E-02, 3.5441E-02,
     &   3.5689E-02, 3.5928E-02, 3.6160E-02, 3.6384E-02, 3.6601E-02,
     &   3.6811E-02, 3.7015E-02, 3.7214E-02, 3.7407E-02, 3.7595E-02,
     &   3.7779E-02, 3.7957E-02, 3.8131E-02, 3.8302E-02, 3.8470E-02,
     &   3.8634E-02, 3.8795E-02, 3.8952E-02, 3.9106E-02, 3.9258E-02,
     &   3.9406E-02, 3.9552E-02, 3.9695E-02, 3.9836E-02, 3.9975E-02,
     &   4.0111E-02, 4.0246E-02, 4.0379E-02, 4.0510E-02, 4.0631E-02,
     &   4.0746E-02, 4.0858E-02, 4.0968E-02, 4.1077E-02, 4.1183E-02,
     &   4.1288E-02, 4.1392E-02, 4.1493E-02, 4.1593E-02, 4.1692E-02,
     &   4.1789E-02, 4.1885E-02, 4.1979E-02, 4.2072E-02, 4.2163E-02,
     &   4.2253E-02, 4.2342E-02, 4.2430E-02, 4.2517E-02, 4.2602E-02,
     &   4.2686E-02, 4.2770E-02, 4.2852E-02, 4.2933E-02, 4.3013E-02,
     &   4.3092E-02, 4.3171E-02, 4.3248E-02, 4.3324E-02, 4.3400E-02,
     &   4.3474E-02, 4.3548E-02, 4.3621E-02, 4.3693E-02, 4.3764E-02,
     &   4.3835E-02, 4.3904E-02, 4.3973E-02, 4.4041E-02, 4.4109E-02,
     &   4.4176E-02, 4.4242E-02, 4.4307E-02, 4.4372E-02, 4.4436E-02,
     &   4.4500E-02, 4.4563E-02, 4.4625E-02, 4.4687E-02, 4.4748E-02,
     &   4.4808E-02, 4.4868E-02, 4.4928E-02, 4.4986E-02, 4.5045E-02,
     &   4.9514E-02, 5.2127E-02, 5.3976E-02, 5.5412E-02, 5.6585E-02,
     &   5.8432E-02, 5.9866E-02, 6.1037E-02, 6.2026E-02, 6.4314E-02/
  
         DATA ((DGM3(I,J), I=   1, 100), J=2,2) /
     &   3.1939E-04, 2.9964E-04, 2.8053E-04, 2.6759E-04, 2.5831E-04,
     &   2.4631E-04, 2.3848E-04, 2.3317E-04, 2.2935E-04, 2.2649E-04,
     &   2.2427E-04, 2.2251E-04, 2.2108E-04, 2.1991E-04, 2.1892E-04,
     &   2.1808E-04, 2.1737E-04, 2.1675E-04, 2.1621E-04, 2.1574E-04,
     &   2.1532E-04, 2.1495E-04, 2.1462E-04, 2.1432E-04, 2.1406E-04,
     &   2.1383E-04, 2.1359E-04, 2.1340E-04, 2.1321E-04, 2.1304E-04,
     &   2.1289E-04, 2.1275E-04, 2.1262E-04, 2.1250E-04, 2.1239E-04,
     &   2.1228E-04, 2.1218E-04, 2.1209E-04, 2.1201E-04, 2.1193E-04,
     &   2.1186E-04, 2.1179E-04, 2.1172E-04, 2.1166E-04, 2.1160E-04,
     &   2.1156E-04, 2.1149E-04, 2.1145E-04, 2.1140E-04, 2.1141E-04,
     &   2.1131E-04, 2.1128E-04, 2.1124E-04, 2.1120E-04, 2.1117E-04,
     &   2.1114E-04, 2.1111E-04, 2.1108E-04, 2.1105E-04, 2.1102E-04,
     &   2.1100E-04, 2.1097E-04, 2.1095E-04, 2.1093E-04, 2.1090E-04,
     &   2.1098E-04, 2.1086E-04, 2.1085E-04, 2.1083E-04, 2.1081E-04,
     &   2.1079E-04, 2.1078E-04, 2.1076E-04, 2.1075E-04, 2.1073E-04,
     &   2.1072E-04, 2.1070E-04, 2.1069E-04, 2.1068E-04, 2.1067E-04,
     &   2.1066E-04, 2.1064E-04, 2.1063E-04, 2.1062E-04, 2.1061E-04,
     &   2.1060E-04, 2.1059E-04, 2.1058E-04, 2.1058E-04, 2.1057E-04,
     &   2.1050E-04, 2.1045E-04, 2.1041E-04, 2.1038E-04, 2.1035E-04,
     &   2.1033E-04, 2.1031E-04, 2.1030E-04, 2.1028E-04, 2.1027E-04/
  
         DATA ((DGM3(I,J), I= 101, 200), J=2,2) /
     &   2.1026E-04, 2.1026E-04, 2.1025E-04, 2.1024E-04, 2.1024E-04,
     &   2.1023E-04, 2.1023E-04, 2.1023E-04, 2.1022E-04, 2.1022E-04,
     &   2.1022E-04, 2.1022E-04, 2.1022E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1020E-04,
     &   2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04,
     &   2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04,
     &   2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04,
     &   2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04,
     &   2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04, 2.1020E-04,
     &   2.1020E-04, 2.1020E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04, 2.1021E-04,
     &   2.1023E-04, 2.1023E-04, 2.1025E-04, 2.1025E-04, 2.1025E-04,
     &   2.1026E-04, 2.1027E-04, 2.1027E-04, 2.1028E-04, 2.1029E-04/
c
      save
      RETURN
      END

       subroutine dalhad_spacelike12
       IMPLICIT NONE
       INTEGER NA,I,J
       PARAMETER(NA=979)
       REAL ETA(NA),DAT(NA,2),DGT(NA,2),DGT3(NA,2)
       COMMON /DATT12/ETA,DAT,DGT,DGT3

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 12:04:09 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: *, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
c replaced March 30, 2012 [dalhads.dat;429]

       DATA  (ETA(I), I=   1, 100) /
     &  -1.0000E+03,-9.9000E+02,-9.8000E+02,-9.7000E+02,-9.6000E+02,
     &  -9.5000E+02,-9.4000E+02,-9.3000E+02,-9.2000E+02,-9.1000E+02,
     &  -9.0000E+02,-8.9000E+02,-8.8000E+02,-8.7000E+02,-8.6000E+02,
     &  -8.5000E+02,-8.4000E+02,-8.3000E+02,-8.2000E+02,-8.1000E+02,
     &  -8.0000E+02,-7.9000E+02,-7.8000E+02,-7.7000E+02,-7.6000E+02,
     &  -7.5000E+02,-7.4000E+02,-7.3000E+02,-7.2000E+02,-7.1000E+02,
     &  -7.0000E+02,-6.9000E+02,-6.8000E+02,-6.7000E+02,-6.6000E+02,
     &  -6.5000E+02,-6.4000E+02,-6.3000E+02,-6.2000E+02,-6.1000E+02,
     &  -6.0000E+02,-5.9000E+02,-5.8000E+02,-5.7000E+02,-5.6000E+02,
     &  -5.5000E+02,-5.4000E+02,-5.3000E+02,-5.2000E+02,-5.1000E+02,
     &  -5.0000E+02,-4.9000E+02,-4.8000E+02,-4.7000E+02,-4.6000E+02,
     &  -4.5000E+02,-4.4000E+02,-4.3000E+02,-4.2000E+02,-4.1000E+02,
     &  -4.0000E+02,-3.9000E+02,-3.8000E+02,-3.7000E+02,-3.6000E+02,
     &  -3.5000E+02,-3.4000E+02,-3.3000E+02,-3.2000E+02,-3.1000E+02,
     &  -3.0000E+02,-2.9000E+02,-2.8000E+02,-2.7000E+02,-2.6000E+02,
     &  -2.5000E+02,-2.4000E+02,-2.3000E+02,-2.2000E+02,-2.1000E+02,
     &  -2.0000E+02,-1.9000E+02,-1.8000E+02,-1.7000E+02,-1.6000E+02,
     &  -1.5000E+02,-1.4000E+02,-1.3000E+02,-1.2000E+02,-1.1000E+02,
     &  -1.0000E+02,-9.9000E+01,-9.8000E+01,-9.7000E+01,-9.6000E+01,
     &  -9.5000E+01,-9.4000E+01,-9.3000E+01,-9.2000E+01,-9.1000E+01/
  
       DATA  (ETA(I), I= 101, 200) /
     &  -9.0000E+01,-8.9000E+01,-8.8000E+01,-8.7000E+01,-8.6000E+01,
     &  -8.5000E+01,-8.4000E+01,-8.3000E+01,-8.2000E+01,-8.1000E+01,
     &  -8.0000E+01,-7.9000E+01,-7.8000E+01,-7.7000E+01,-7.6000E+01,
     &  -7.5000E+01,-7.4000E+01,-7.3000E+01,-7.2000E+01,-7.1000E+01,
     &  -7.0000E+01,-6.9000E+01,-6.8000E+01,-6.7000E+01,-6.6000E+01,
     &  -6.5000E+01,-6.4000E+01,-6.3000E+01,-6.2000E+01,-6.1000E+01,
     &  -6.0000E+01,-5.9000E+01,-5.8000E+01,-5.7000E+01,-5.6000E+01,
     &  -5.5000E+01,-5.4000E+01,-5.3000E+01,-5.2000E+01,-5.1000E+01,
     &  -5.0000E+01,-4.9000E+01,-4.8000E+01,-4.7000E+01,-4.6000E+01,
     &  -4.5000E+01,-4.4000E+01,-4.3000E+01,-4.2000E+01,-4.1000E+01,
     &  -4.0000E+01,-3.9000E+01,-3.8000E+01,-3.7000E+01,-3.6000E+01,
     &  -3.5000E+01,-3.4000E+01,-3.3000E+01,-3.2000E+01,-3.1000E+01,
     &  -3.0000E+01,-2.9000E+01,-2.8000E+01,-2.7000E+01,-2.6000E+01,
     &  -2.5000E+01,-2.4000E+01,-2.3000E+01,-2.2000E+01,-2.1000E+01,
     &  -2.0000E+01,-1.9000E+01,-1.8000E+01,-1.7000E+01,-1.6000E+01,
     &  -1.5000E+01,-1.4000E+01,-1.3000E+01,-1.2000E+01,-1.1000E+01,
     &  -1.0000E+01,-9.9100E+00,-9.8200E+00,-9.7300E+00,-9.6400E+00,
     &  -9.5500E+00,-9.4600E+00,-9.3700E+00,-9.2800E+00,-9.1900E+00,
     &  -9.1000E+00,-9.0100E+00,-8.9200E+00,-8.8300E+00,-8.7400E+00,
     &  -8.6500E+00,-8.5600E+00,-8.4700E+00,-8.3800E+00,-8.2900E+00/
  
       DATA  (ETA(I), I= 201, 300) /
     &  -8.2000E+00,-8.1100E+00,-8.0200E+00,-7.9300E+00,-7.8400E+00,
     &  -7.7500E+00,-7.6600E+00,-7.5700E+00,-7.4800E+00,-7.3900E+00,
     &  -7.3000E+00,-7.2100E+00,-7.1200E+00,-7.0300E+00,-6.9400E+00,
     &  -6.8500E+00,-6.7600E+00,-6.6700E+00,-6.5800E+00,-6.4900E+00,
     &  -6.4000E+00,-6.3100E+00,-6.2200E+00,-6.1300E+00,-6.0400E+00,
     &  -5.9500E+00,-5.8600E+00,-5.7700E+00,-5.6800E+00,-5.5900E+00,
     &  -5.5000E+00,-5.4100E+00,-5.3200E+00,-5.2300E+00,-5.1400E+00,
     &  -5.0500E+00,-4.9600E+00,-4.8700E+00,-4.7800E+00,-4.6900E+00,
     &  -4.6000E+00,-4.5100E+00,-4.4200E+00,-4.3300E+00,-4.2400E+00,
     &  -4.1500E+00,-4.0600E+00,-3.9700E+00,-3.8800E+00,-3.7900E+00,
     &  -3.7000E+00,-3.6100E+00,-3.5200E+00,-3.4300E+00,-3.3400E+00,
     &  -3.2500E+00,-3.1600E+00,-3.0700E+00,-2.9800E+00,-2.8900E+00,
     &  -2.8000E+00,-2.7100E+00,-2.6200E+00,-2.5300E+00,-2.4400E+00,
     &  -2.3500E+00,-2.2600E+00,-2.1700E+00,-2.0800E+00,-1.9900E+00,
     &  -1.9000E+00,-1.8100E+00,-1.7200E+00,-1.6300E+00,-1.5400E+00,
     &  -1.4500E+00,-1.3600E+00,-1.2700E+00,-1.1800E+00,-1.0900E+00,
     &  -1.0000E+00,-9.9100E-01,-9.8200E-01,-9.7300E-01,-9.6400E-01,
     &  -9.5500E-01,-9.4600E-01,-9.3700E-01,-9.2800E-01,-9.1900E-01,
     &  -9.1000E-01,-9.0100E-01,-8.9200E-01,-8.8300E-01,-8.7400E-01,
     &  -8.6500E-01,-8.5600E-01,-8.4700E-01,-8.3800E-01,-8.2900E-01/
  
       DATA  (ETA(I), I= 301, 400) /
     &  -8.2000E-01,-8.1100E-01,-8.0200E-01,-7.9300E-01,-7.8400E-01,
     &  -7.7500E-01,-7.6600E-01,-7.5700E-01,-7.4800E-01,-7.3900E-01,
     &  -7.3000E-01,-7.2100E-01,-7.1200E-01,-7.0300E-01,-6.9400E-01,
     &  -6.8500E-01,-6.7600E-01,-6.6700E-01,-6.5800E-01,-6.4900E-01,
     &  -6.4000E-01,-6.3100E-01,-6.2200E-01,-6.1300E-01,-6.0400E-01,
     &  -5.9500E-01,-5.8600E-01,-5.7700E-01,-5.6800E-01,-5.5900E-01,
     &  -5.5000E-01,-5.4100E-01,-5.3200E-01,-5.2300E-01,-5.1400E-01,
     &  -5.0500E-01,-4.9600E-01,-4.8700E-01,-4.7800E-01,-4.6900E-01,
     &  -4.6000E-01,-4.5100E-01,-4.4200E-01,-4.3300E-01,-4.2400E-01,
     &  -4.1500E-01,-4.0600E-01,-3.9700E-01,-3.8800E-01,-3.7900E-01,
     &  -3.7000E-01,-3.6100E-01,-3.5200E-01,-3.4300E-01,-3.3400E-01,
     &  -3.2500E-01,-3.1600E-01,-3.0700E-01,-2.9800E-01,-2.8900E-01,
     &  -2.8000E-01,-2.7100E-01,-2.6200E-01,-2.5300E-01,-2.4400E-01,
     &  -2.3500E-01,-2.2600E-01,-2.1700E-01,-2.0800E-01,-1.9900E-01,
     &  -1.9000E-01,-1.8100E-01,-1.7200E-01,-1.6300E-01,-1.5400E-01,
     &  -1.4500E-01,-1.3600E-01,-1.2700E-01,-1.1800E-01,-1.0900E-01,
     &  -1.0000E-01,-9.9100E-02,-9.8200E-02,-9.7300E-02,-9.6400E-02,
     &  -9.5500E-02,-9.4600E-02,-9.3700E-02,-9.2800E-02,-9.1900E-02,
     &  -9.1000E-02,-9.0100E-02,-8.9200E-02,-8.8300E-02,-8.7400E-02,
     &  -8.6500E-02,-8.5600E-02,-8.4700E-02,-8.3800E-02,-8.2900E-02/
  
       DATA  (ETA(I), I= 401, 500) /
     &  -8.2000E-02,-8.1100E-02,-8.0200E-02,-7.9300E-02,-7.8400E-02,
     &  -7.7500E-02,-7.6600E-02,-7.5700E-02,-7.4800E-02,-7.3900E-02,
     &  -7.3000E-02,-7.2100E-02,-7.1200E-02,-7.0300E-02,-6.9400E-02,
     &  -6.8500E-02,-6.7600E-02,-6.6700E-02,-6.5800E-02,-6.4900E-02,
     &  -6.4000E-02,-6.3100E-02,-6.2200E-02,-6.1300E-02,-6.0400E-02,
     &  -5.9500E-02,-5.8600E-02,-5.7700E-02,-5.6800E-02,-5.5900E-02,
     &  -5.5000E-02,-5.4100E-02,-5.3200E-02,-5.2300E-02,-5.1400E-02,
     &  -5.0500E-02,-4.9600E-02,-4.8700E-02,-4.7800E-02,-4.6900E-02,
     &  -4.6000E-02,-4.5100E-02,-4.4200E-02,-4.3300E-02,-4.2400E-02,
     &  -4.1500E-02,-4.0600E-02,-3.9700E-02,-3.8800E-02,-3.7900E-02,
     &  -3.7000E-02,-3.6100E-02,-3.5200E-02,-3.4300E-02,-3.3400E-02,
     &  -3.2500E-02,-3.1600E-02,-3.0700E-02,-2.9800E-02,-2.8900E-02,
     &  -2.8000E-02,-2.7100E-02,-2.6200E-02,-2.5300E-02,-2.4400E-02,
     &  -2.3500E-02,-2.2600E-02,-2.1700E-02,-2.0800E-02,-1.9900E-02,
     &  -1.9000E-02,-1.8100E-02,-1.7200E-02,-1.6300E-02,-1.5400E-02,
     &  -1.4500E-02,-1.3600E-02,-1.2700E-02,-1.1800E-02,-1.0900E-02,
     &  -1.0000E-02,-9.9100E-03,-9.8200E-03,-9.7300E-03,-9.6400E-03,
     &  -9.5500E-03,-9.4600E-03,-9.3700E-03,-9.2800E-03,-9.1900E-03,
     &  -9.1000E-03,-9.0100E-03,-8.9200E-03,-8.8300E-03,-8.7400E-03,
     &  -8.6500E-03,-8.5600E-03,-8.4700E-03,-8.3800E-03,-8.2900E-03/
  
       DATA  (ETA(I), I= 501, 600) /
     &  -8.2000E-03,-8.1100E-03,-8.0200E-03,-7.9300E-03,-7.8400E-03,
     &  -7.7500E-03,-7.6600E-03,-7.5700E-03,-7.4800E-03,-7.3900E-03,
     &  -7.3000E-03,-7.2100E-03,-7.1200E-03,-7.0300E-03,-6.9400E-03,
     &  -6.8500E-03,-6.7600E-03,-6.6700E-03,-6.5800E-03,-6.4900E-03,
     &  -6.4000E-03,-6.3100E-03,-6.2200E-03,-6.1300E-03,-6.0400E-03,
     &  -5.9500E-03,-5.8600E-03,-5.7700E-03,-5.6800E-03,-5.5900E-03,
     &  -5.5000E-03,-5.4100E-03,-5.3200E-03,-5.2300E-03,-5.1400E-03,
     &  -5.0500E-03,-4.9600E-03,-4.8700E-03,-4.7800E-03,-4.6900E-03,
     &  -4.6000E-03,-4.5100E-03,-4.4200E-03,-4.3300E-03,-4.2400E-03,
     &  -4.1500E-03,-4.0600E-03,-3.9700E-03,-3.8800E-03,-3.7900E-03,
     &  -3.7000E-03,-3.6100E-03,-3.5200E-03,-3.4300E-03,-3.3400E-03,
     &  -3.2500E-03,-3.1600E-03,-3.0700E-03,-2.9800E-03,-2.8900E-03,
     &  -2.8000E-03,-2.7100E-03,-2.6200E-03,-2.5300E-03,-2.4400E-03,
     &  -2.3500E-03,-2.2600E-03,-2.1700E-03,-2.0800E-03,-1.9900E-03,
     &  -1.9000E-03,-1.8100E-03,-1.7200E-03,-1.6300E-03,-1.5400E-03,
     &  -1.4500E-03,-1.3600E-03,-1.2700E-03,-1.1800E-03,-1.0900E-03,
     &  -1.0000E-03,-9.9100E-04,-9.8200E-04,-9.7300E-04,-9.6400E-04,
     &  -9.5500E-04,-9.4600E-04,-9.3700E-04,-9.2800E-04,-9.1900E-04,
     &  -9.1000E-04,-9.0100E-04,-8.9200E-04,-8.8300E-04,-8.7400E-04,
     &  -8.6500E-04,-8.5600E-04,-8.4700E-04,-8.3800E-04,-8.2900E-04/
  
       DATA  (ETA(I), I= 601, 700) /
     &  -8.2000E-04,-8.1100E-04,-8.0200E-04,-7.9300E-04,-7.8400E-04,
     &  -7.7500E-04,-7.6600E-04,-7.5700E-04,-7.4800E-04,-7.3900E-04,
     &  -7.3000E-04,-7.2100E-04,-7.1200E-04,-7.0300E-04,-6.9400E-04,
     &  -6.8500E-04,-6.7600E-04,-6.6700E-04,-6.5800E-04,-6.4900E-04,
     &  -6.4000E-04,-6.3100E-04,-6.2200E-04,-6.1300E-04,-6.0400E-04,
     &  -5.9500E-04,-5.8600E-04,-5.7700E-04,-5.6800E-04,-5.5900E-04,
     &  -5.5000E-04,-5.4100E-04,-5.3200E-04,-5.2300E-04,-5.1400E-04,
     &  -5.0500E-04,-4.9600E-04,-4.8700E-04,-4.7800E-04,-4.6900E-04,
     &  -4.6000E-04,-4.5100E-04,-4.4200E-04,-4.3300E-04,-4.2400E-04,
     &  -4.1500E-04,-4.0600E-04,-3.9700E-04,-3.8800E-04,-3.7900E-04,
     &  -3.7000E-04,-3.6100E-04,-3.5200E-04,-3.4300E-04,-3.3400E-04,
     &  -3.2500E-04,-3.1600E-04,-3.0700E-04,-2.9800E-04,-2.8900E-04,
     &  -2.8000E-04,-2.7100E-04,-2.6200E-04,-2.5300E-04,-2.4400E-04,
     &  -2.3500E-04,-2.2600E-04,-2.1700E-04,-2.0800E-04,-1.9900E-04,
     &  -1.9000E-04,-1.8100E-04,-1.7200E-04,-1.6300E-04,-1.5400E-04,
     &  -1.4500E-04,-1.3600E-04,-1.2700E-04,-1.1800E-04,-1.0900E-04,
     &  -1.0000E-04,-9.9100E-05,-9.8200E-05,-9.7300E-05,-9.6400E-05,
     &  -9.5500E-05,-9.4600E-05,-9.3700E-05,-9.2800E-05,-9.1900E-05,
     &  -9.1000E-05,-9.0100E-05,-8.9200E-05,-8.8300E-05,-8.7400E-05,
     &  -8.6500E-05,-8.5600E-05,-8.4700E-05,-8.3800E-05,-8.2900E-05/
  
       DATA  (ETA(I), I= 701, 800) /
     &  -8.2000E-05,-8.1100E-05,-8.0200E-05,-7.9300E-05,-7.8400E-05,
     &  -7.7500E-05,-7.6600E-05,-7.5700E-05,-7.4800E-05,-7.3900E-05,
     &  -7.3000E-05,-7.2100E-05,-7.1200E-05,-7.0300E-05,-6.9400E-05,
     &  -6.8500E-05,-6.7600E-05,-6.6700E-05,-6.5800E-05,-6.4900E-05,
     &  -6.4000E-05,-6.3100E-05,-6.2200E-05,-6.1300E-05,-6.0400E-05,
     &  -5.9500E-05,-5.8600E-05,-5.7700E-05,-5.6800E-05,-5.5900E-05,
     &  -5.5000E-05,-5.4100E-05,-5.3200E-05,-5.2300E-05,-5.1400E-05,
     &  -5.0500E-05,-4.9600E-05,-4.8700E-05,-4.7800E-05,-4.6900E-05,
     &  -4.6000E-05,-4.5100E-05,-4.4200E-05,-4.3300E-05,-4.2400E-05,
     &  -4.1500E-05,-4.0600E-05,-3.9700E-05,-3.8800E-05,-3.7900E-05,
     &  -3.7000E-05,-3.6100E-05,-3.5200E-05,-3.4300E-05,-3.3400E-05,
     &  -3.2500E-05,-3.1600E-05,-3.0700E-05,-2.9800E-05,-2.8900E-05,
     &  -2.8000E-05,-2.7100E-05,-2.6200E-05,-2.5300E-05,-2.4400E-05,
     &  -2.3500E-05,-2.2600E-05,-2.1700E-05,-2.0800E-05,-1.9900E-05,
     &  -1.9000E-05,-1.8100E-05,-1.7200E-05,-1.6300E-05,-1.5400E-05,
     &  -1.4500E-05,-1.3600E-05,-1.2700E-05,-1.1800E-05,-1.0900E-05,
     &  -1.0000E-05,-9.9100E-06,-9.8200E-06,-9.7300E-06,-9.6400E-06,
     &  -9.5500E-06,-9.4600E-06,-9.3700E-06,-9.2800E-06,-9.1900E-06,
     &  -9.1000E-06,-9.0100E-06,-8.9200E-06,-8.8300E-06,-8.7400E-06,
     &  -8.6500E-06,-8.5600E-06,-8.4700E-06,-8.3800E-06,-8.2900E-06/
  
       DATA  (ETA(I), I= 801, 900) /
     &  -8.2000E-06,-8.1100E-06,-8.0200E-06,-7.9300E-06,-7.8400E-06,
     &  -7.7500E-06,-7.6600E-06,-7.5700E-06,-7.4800E-06,-7.3900E-06,
     &  -7.3000E-06,-7.2100E-06,-7.1200E-06,-7.0300E-06,-6.9400E-06,
     &  -6.8500E-06,-6.7600E-06,-6.6700E-06,-6.5800E-06,-6.4900E-06,
     &  -6.4000E-06,-6.3100E-06,-6.2200E-06,-6.1300E-06,-6.0400E-06,
     &  -5.9500E-06,-5.8600E-06,-5.7700E-06,-5.6800E-06,-5.5900E-06,
     &  -5.5000E-06,-5.4100E-06,-5.3200E-06,-5.2300E-06,-5.1400E-06,
     &  -5.0500E-06,-4.9600E-06,-4.8700E-06,-4.7800E-06,-4.6900E-06,
     &  -4.6000E-06,-4.5100E-06,-4.4200E-06,-4.3300E-06,-4.2400E-06,
     &  -4.1500E-06,-4.0600E-06,-3.9700E-06,-3.8800E-06,-3.7900E-06,
     &  -3.7000E-06,-3.6100E-06,-3.5200E-06,-3.4300E-06,-3.3400E-06,
     &  -3.2500E-06,-3.1600E-06,-3.0700E-06,-2.9800E-06,-2.8900E-06,
     &  -2.8000E-06,-2.7100E-06,-2.6200E-06,-2.5300E-06,-2.4400E-06,
     &  -2.3500E-06,-2.2600E-06,-2.1700E-06,-2.0800E-06,-1.9900E-06,
     &  -1.9000E-06,-1.8100E-06,-1.7200E-06,-1.6300E-06,-1.5400E-06,
     &  -1.4500E-06,-1.3600E-06,-1.2700E-06,-1.1800E-06,-1.0900E-06,
     &  -1.0000E-06, 0.0000E+00, 1.0000E-06, 3.0010E-03, 6.0010E-03,
     &   9.0010E-03, 1.2000E-02, 1.5000E-02, 1.8000E-02, 2.1000E-02,
     &   2.4000E-02, 2.7000E-02, 3.0000E-02, 3.3000E-02, 3.6000E-02,
     &   3.9000E-02, 4.2000E-02, 4.5000E-02, 4.8000E-02, 5.1000E-02/
  
       DATA  (ETA(I), I= 901, 979) /
     &   5.4000E-02, 5.7000E-02, 6.0000E-02, 6.3000E-02, 6.6000E-02,
     &   6.9000E-02, 7.2000E-02, 7.5000E-02, 7.8000E-02, 8.1000E-02,
     &   8.4000E-02, 8.7000E-02, 9.0000E-02, 9.3000E-02, 9.6000E-02,
     &   9.9000E-02, 1.0200E-01, 1.0500E-01, 1.0800E-01, 1.1100E-01,
     &   1.1400E-01, 1.1700E-01, 1.2000E-01, 1.2300E-01, 1.2600E-01,
     &   1.2900E-01, 1.3200E-01, 1.3500E-01, 1.3800E-01, 1.4100E-01,
     &   1.4400E-01, 1.4700E-01, 1.5000E-01, 1.5300E-01, 1.5600E-01,
     &   1.5900E-01, 1.6200E-01, 1.6500E-01, 1.6800E-01, 1.7100E-01,
     &   1.7400E-01, 1.7700E-01, 1.8000E-01, 1.8300E-01, 1.8600E-01,
     &   1.8900E-01, 1.9200E-01, 1.9500E-01, 1.9800E-01, 2.0100E-01,
     &   2.0400E-01, 2.0700E-01, 2.1000E-01, 2.1300E-01, 2.1600E-01,
     &   2.1900E-01, 2.2200E-01, 2.2500E-01, 2.2800E-01, 2.3100E-01,
     &   2.3400E-01, 2.3700E-01, 2.4000E-01, 2.4300E-01, 2.4600E-01,
     &   2.4900E-01, 2.5200E-01, 2.5500E-01, 2.5800E-01, 2.6100E-01,
     &   2.6400E-01, 2.6700E-01, 2.7000E-01, 2.7100E-01, 2.7300E-01,
     &   0.27370000D0, 0.27599999D0, 0.27630001D0, 0.27700001D0/
  
         DATA ((DAT (I,J), I=   1, 100), J=1,1) /
     &   4.1065E-02, 4.1013E-02, 4.0961E-02, 4.0909E-02, 4.0855E-02,
     &   4.0801E-02, 4.0747E-02, 4.0692E-02, 4.0636E-02, 4.0580E-02,
     &   4.0522E-02, 4.0465E-02, 4.0406E-02, 4.0347E-02, 4.0287E-02,
     &   4.0226E-02, 4.0164E-02, 4.0101E-02, 4.0038E-02, 3.9974E-02,
     &   3.9909E-02, 3.9843E-02, 3.9776E-02, 3.9708E-02, 3.9639E-02,
     &   3.9569E-02, 3.9498E-02, 3.9426E-02, 3.9353E-02, 3.9278E-02,
     &   3.9203E-02, 3.9126E-02, 3.9048E-02, 3.8969E-02, 3.8888E-02,
     &   3.8806E-02, 3.8723E-02, 3.8638E-02, 3.8552E-02, 3.8464E-02,
     &   3.8374E-02, 3.8283E-02, 3.8190E-02, 3.8095E-02, 3.7999E-02,
     &   3.7900E-02, 3.7800E-02, 3.7697E-02, 3.7593E-02, 3.7486E-02,
     &   3.7376E-02, 3.7265E-02, 3.7150E-02, 3.7034E-02, 3.6914E-02,
     &   3.6792E-02, 3.6666E-02, 3.6538E-02, 3.6406E-02, 3.6270E-02,
     &   3.6132E-02, 3.5989E-02, 3.5842E-02, 3.5692E-02, 3.5536E-02,
     &   3.5377E-02, 3.5212E-02, 3.5042E-02, 3.4866E-02, 3.4685E-02,
     &   3.4497E-02, 3.4303E-02, 3.4101E-02, 3.3892E-02, 3.3675E-02,
     &   3.3449E-02, 3.3213E-02, 3.2967E-02, 3.2709E-02, 3.2439E-02,
     &   3.2156E-02, 3.1857E-02, 3.1542E-02, 3.1209E-02, 3.0855E-02,
     &   3.0477E-02, 3.0073E-02, 2.9639E-02, 2.9169E-02, 2.8658E-02,
     &   2.8098E-02, 2.8039E-02, 2.7979E-02, 2.7919E-02, 2.7858E-02,
     &   2.7796E-02, 2.7734E-02, 2.7671E-02, 2.7607E-02, 2.7543E-02/
  
         DATA ((DAT (I,J), I= 101, 200), J=1,1) /
     &   2.7478E-02, 2.7412E-02, 2.7345E-02, 2.7278E-02, 2.7210E-02,
     &   2.7141E-02, 2.7071E-02, 2.7001E-02, 2.6929E-02, 2.6857E-02,
     &   2.6784E-02, 2.6709E-02, 2.6634E-02, 2.6558E-02, 2.6481E-02,
     &   2.6403E-02, 2.6324E-02, 2.6244E-02, 2.6162E-02, 2.6080E-02,
     &   2.5996E-02, 2.5911E-02, 2.5825E-02, 2.5737E-02, 2.5649E-02,
     &   2.5558E-02, 2.5467E-02, 2.5374E-02, 2.5279E-02, 2.5183E-02,
     &   2.5086E-02, 2.4986E-02, 2.4885E-02, 2.4783E-02, 2.4678E-02,
     &   2.4572E-02, 2.4463E-02, 2.4353E-02, 2.4240E-02, 2.4125E-02,
     &   2.4008E-02, 2.3889E-02, 2.3767E-02, 2.3642E-02, 2.3515E-02,
     &   2.3385E-02, 2.3252E-02, 2.3116E-02, 2.2977E-02, 2.2834E-02,
     &   2.2688E-02, 2.2538E-02, 2.2385E-02, 2.2227E-02, 2.2065E-02,
     &   2.1898E-02, 2.1727E-02, 2.1550E-02, 2.1368E-02, 2.1180E-02,
     &   2.0987E-02, 2.0786E-02, 2.0579E-02, 2.0364E-02, 2.0141E-02,
     &   1.9909E-02, 1.9668E-02, 1.9417E-02, 1.9155E-02, 1.8881E-02,
     &   1.8594E-02, 1.8292E-02, 1.7975E-02, 1.7640E-02, 1.7285E-02,
     &   1.6908E-02, 1.6506E-02, 1.6076E-02, 1.5613E-02, 1.5112E-02,
     &   1.4566E-02, 1.4514E-02, 1.4462E-02, 1.4410E-02, 1.4357E-02,
     &   1.4304E-02, 1.4250E-02, 1.4195E-02, 1.4141E-02, 1.4085E-02,
     &   1.4030E-02, 1.3973E-02, 1.3917E-02, 1.3859E-02, 1.3801E-02,
     &   1.3743E-02, 1.3684E-02, 1.3624E-02, 1.3564E-02, 1.3504E-02/
  
         DATA ((DAT (I,J), I= 201, 300), J=1,1) /
     &   1.3442E-02, 1.3380E-02, 1.3318E-02, 1.3254E-02, 1.3191E-02,
     &   1.3126E-02, 1.3061E-02, 1.2995E-02, 1.2928E-02, 1.2861E-02,
     &   1.2793E-02, 1.2724E-02, 1.2655E-02, 1.2584E-02, 1.2513E-02,
     &   1.2441E-02, 1.2368E-02, 1.2295E-02, 1.2220E-02, 1.2144E-02,
     &   1.2068E-02, 1.1991E-02, 1.1912E-02, 1.1833E-02, 1.1753E-02,
     &   1.1671E-02, 1.1589E-02, 1.1505E-02, 1.1421E-02, 1.1335E-02,
     &   1.1248E-02, 1.1159E-02, 1.1070E-02, 1.0979E-02, 1.0887E-02,
     &   1.0793E-02, 1.0698E-02, 1.0602E-02, 1.0504E-02, 1.0405E-02,
     &   1.0304E-02, 1.0201E-02, 1.0097E-02, 9.9906E-03, 9.8827E-03,
     &   9.7729E-03, 9.6612E-03, 9.5476E-03, 9.4318E-03, 9.3139E-03,
     &   9.1938E-03, 9.0714E-03, 8.9466E-03, 8.8193E-03, 8.6894E-03,
     &   8.5568E-03, 8.4213E-03, 8.2829E-03, 8.1415E-03, 7.9967E-03,
     &   7.8486E-03, 7.6969E-03, 7.5415E-03, 7.3820E-03, 7.2183E-03,
     &   7.0501E-03, 6.8771E-03, 6.6990E-03, 6.5153E-03, 6.3261E-03,
     &   6.1301E-03, 5.9272E-03, 5.7166E-03, 5.4976E-03, 5.2694E-03,
     &   5.0311E-03, 4.7814E-03, 4.5191E-03, 4.2429E-03, 3.9511E-03,
     &   3.6422E-03, 3.6103E-03, 3.5782E-03, 3.5459E-03, 3.5134E-03,
     &   3.4808E-03, 3.4479E-03, 3.4149E-03, 3.3816E-03, 3.3482E-03,
     &   3.3145E-03, 3.2807E-03, 3.2466E-03, 3.2124E-03, 3.1780E-03,
     &   3.1433E-03, 3.1085E-03, 3.0734E-03, 3.0381E-03, 3.0027E-03/
  
         DATA ((DAT (I,J), I= 301, 400), J=1,1) /
     &   2.9670E-03, 2.9311E-03, 2.8951E-03, 2.8588E-03, 2.8223E-03,
     &   2.7856E-03, 2.7487E-03, 2.7117E-03, 2.6744E-03, 2.6369E-03,
     &   2.5992E-03, 2.5613E-03, 2.5233E-03, 2.4849E-03, 2.4465E-03,
     &   2.4079E-03, 2.3691E-03, 2.3301E-03, 2.2910E-03, 2.2516E-03,
     &   2.2122E-03, 2.1725E-03, 2.1327E-03, 2.0928E-03, 2.0527E-03,
     &   2.0125E-03, 1.9722E-03, 1.9317E-03, 1.8912E-03, 1.8505E-03,
     &   1.8098E-03, 1.7689E-03, 1.7280E-03, 1.6871E-03, 1.6461E-03,
     &   1.6050E-03, 1.5640E-03, 1.5229E-03, 1.4819E-03, 1.4409E-03,
     &   1.3999E-03, 1.3590E-03, 1.3181E-03, 1.2774E-03, 1.2368E-03,
     &   1.1963E-03, 1.1560E-03, 1.1158E-03, 1.0759E-03, 1.0362E-03,
     &   9.9673E-04, 9.5757E-04, 9.1871E-04, 8.8018E-04, 8.4203E-04,
     &   8.0427E-04, 7.6693E-04, 7.3006E-04, 6.9367E-04, 6.5780E-04,
     &   6.2250E-04, 5.8778E-04, 5.5369E-04, 5.2027E-04, 4.8754E-04,
     &   4.5555E-04, 4.2434E-04, 3.9393E-04, 3.6438E-04, 3.3571E-04,
     &   3.0797E-04, 2.8119E-04, 2.5541E-04, 2.3068E-04, 2.0702E-04,
     &   1.8447E-04, 1.6307E-04, 1.4286E-04, 1.2386E-04, 1.0612E-04,
     &   8.9653E-05, 8.8078E-05, 8.6516E-05, 8.4968E-05, 8.3432E-05,
     &   8.1910E-05, 8.0401E-05, 7.8905E-05, 7.7423E-05, 7.5954E-05,
     &   7.4498E-05, 7.3056E-05, 7.1627E-05, 7.0212E-05, 6.8810E-05,
     &   6.7421E-05, 6.6046E-05, 6.4685E-05, 6.3337E-05, 6.2003E-05/
  
         DATA ((DAT (I,J), I= 401, 500), J=1,1) /
     &   6.0682E-05, 5.9375E-05, 5.8081E-05, 5.6802E-05, 5.5536E-05,
     &   5.4284E-05, 5.3045E-05, 5.1820E-05, 5.0609E-05, 4.9412E-05,
     &   4.8229E-05, 4.7060E-05, 4.5904E-05, 4.4763E-05, 4.3635E-05,
     &   4.2522E-05, 4.1422E-05, 4.0336E-05, 3.9265E-05, 3.8207E-05,
     &   3.7164E-05, 3.6135E-05, 3.5119E-05, 3.4118E-05, 3.3131E-05,
     &   3.2158E-05, 3.1200E-05, 3.0255E-05, 2.9325E-05, 2.8409E-05,
     &   2.7507E-05, 2.6620E-05, 2.5746E-05, 2.4888E-05, 2.4043E-05,
     &   2.3213E-05, 2.2397E-05, 2.1596E-05, 2.0808E-05, 2.0036E-05,
     &   1.9278E-05, 1.8534E-05, 1.7804E-05, 1.7089E-05, 1.6389E-05,
     &   1.5703E-05, 1.5032E-05, 1.4375E-05, 1.3732E-05, 1.3105E-05,
     &   1.2491E-05, 1.1893E-05, 1.1309E-05, 1.0739E-05, 1.0184E-05,
     &   9.6440E-06, 9.1184E-06, 8.6074E-06, 8.1110E-06, 7.6293E-06,
     &   7.1623E-06, 6.7100E-06, 6.2723E-06, 5.8494E-06, 5.4411E-06,
     &   5.0476E-06, 4.6688E-06, 4.3047E-06, 3.9553E-06, 3.6207E-06,
     &   3.3009E-06, 2.9958E-06, 2.7054E-06, 2.4299E-06, 2.1691E-06,
     &   1.9231E-06, 1.6918E-06, 1.4754E-06, 1.2738E-06, 1.0869E-06,
     &   9.1486E-07, 8.9847E-07, 8.8223E-07, 8.6614E-07, 8.5019E-07,
     &   8.3439E-07, 8.1874E-07, 8.0324E-07, 7.8789E-07, 7.7268E-07,
     &   7.5763E-07, 7.4272E-07, 7.2796E-07, 7.1334E-07, 6.9888E-07,
     &   6.8456E-07, 6.7039E-07, 6.5637E-07, 6.4250E-07, 6.2877E-07/
  
         DATA ((DAT (I,J), I= 501, 600), J=1,1) /
     &   6.1520E-07, 6.0177E-07, 5.8849E-07, 5.7536E-07, 5.6237E-07,
     &   5.4954E-07, 5.3685E-07, 5.2431E-07, 5.1192E-07, 4.9967E-07,
     &   4.8758E-07, 4.7563E-07, 4.6383E-07, 4.5218E-07, 4.4068E-07,
     &   4.2932E-07, 4.1812E-07, 4.0706E-07, 3.9615E-07, 3.8539E-07,
     &   3.7477E-07, 3.6431E-07, 3.5399E-07, 3.4382E-07, 3.3380E-07,
     &   3.2393E-07, 3.1420E-07, 3.0463E-07, 2.9520E-07, 2.8592E-07,
     &   2.7679E-07, 2.6780E-07, 2.5897E-07, 2.5028E-07, 2.4174E-07,
     &   2.3335E-07, 2.2511E-07, 2.1701E-07, 2.0907E-07, 2.0127E-07,
     &   1.9362E-07, 1.8612E-07, 1.7876E-07, 1.7156E-07, 1.6450E-07,
     &   1.5759E-07, 1.5083E-07, 1.4422E-07, 1.3775E-07, 1.3144E-07,
     &   1.2527E-07, 1.1925E-07, 1.1338E-07, 1.0765E-07, 1.0208E-07,
     &   9.6651E-08, 9.1372E-08, 8.6241E-08, 8.1259E-08, 7.6425E-08,
     &   7.1739E-08, 6.7202E-08, 6.2812E-08, 5.8571E-08, 5.4478E-08,
     &   5.0533E-08, 4.6737E-08, 4.3089E-08, 3.9589E-08, 3.6237E-08,
     &   3.3033E-08, 2.9978E-08, 2.7071E-08, 2.4312E-08, 2.1701E-08,
     &   1.9239E-08, 1.6925E-08, 1.4759E-08, 1.2741E-08, 1.0872E-08,
     &   9.1505E-09, 8.9866E-09, 8.8241E-09, 8.6631E-09, 8.5036E-09,
     &   8.3455E-09, 8.1890E-09, 8.0339E-09, 7.8803E-09, 7.7282E-09,
     &   7.5776E-09, 7.4284E-09, 7.2808E-09, 7.1346E-09, 6.9899E-09,
     &   6.8467E-09, 6.7049E-09, 6.5647E-09, 6.4259E-09, 6.2886E-09/
  
         DATA ((DAT (I,J), I= 601, 700), J=1,1) /
     &   6.1528E-09, 6.0185E-09, 5.8857E-09, 5.7543E-09, 5.6244E-09,
     &   5.4960E-09, 5.3691E-09, 5.2437E-09, 5.1198E-09, 4.9973E-09,
     &   4.8763E-09, 4.7568E-09, 4.6388E-09, 4.5223E-09, 4.4072E-09,
     &   4.2937E-09, 4.1816E-09, 4.0710E-09, 3.9619E-09, 3.8542E-09,
     &   3.7481E-09, 3.6434E-09, 3.5402E-09, 3.4385E-09, 3.3383E-09,
     &   3.2395E-09, 3.1423E-09, 3.0465E-09, 2.9522E-09, 2.8594E-09,
     &   2.7680E-09, 2.6782E-09, 2.5898E-09, 2.5029E-09, 2.4175E-09,
     &   2.3336E-09, 2.2512E-09, 2.1702E-09, 2.0908E-09, 2.0128E-09,
     &   1.9363E-09, 1.8612E-09, 1.7877E-09, 1.7156E-09, 1.6450E-09,
     &   1.5760E-09, 1.5083E-09, 1.4422E-09, 1.3776E-09, 1.3144E-09,
     &   1.2527E-09, 1.1925E-09, 1.1338E-09, 1.0766E-09, 1.0208E-09,
     &   9.6653E-10, 9.1374E-10, 8.6243E-10, 8.1261E-10, 7.6426E-10,
     &   7.1740E-10, 6.7203E-10, 6.2813E-10, 5.8572E-10, 5.4479E-10,
     &   5.0534E-10, 4.6737E-10, 4.3089E-10, 3.9589E-10, 3.6237E-10,
     &   3.3034E-10, 2.9978E-10, 2.7071E-10, 2.4312E-10, 2.1701E-10,
     &   1.9239E-10, 1.6925E-10, 1.4759E-10, 1.2741E-10, 1.0872E-10,
     &   9.1506E-11, 8.9866E-11, 8.8241E-11, 8.6631E-11, 8.5036E-11,
     &   8.3455E-11, 8.1890E-11, 8.0339E-11, 7.8803E-11, 7.7282E-11,
     &   7.5776E-11, 7.4284E-11, 7.2808E-11, 7.1346E-11, 6.9899E-11,
     &   6.8467E-11, 6.7049E-11, 6.5647E-11, 6.4259E-11, 6.2886E-11/
  
         DATA ((DAT (I,J), I= 701, 800), J=1,1) /
     &   6.1528E-11, 6.0185E-11, 5.8857E-11, 5.7543E-11, 5.6244E-11,
     &   5.4961E-11, 5.3691E-11, 5.2437E-11, 5.1198E-11, 4.9973E-11,
     &   4.8763E-11, 4.7568E-11, 4.6388E-11, 4.5223E-11, 4.4072E-11,
     &   4.2937E-11, 4.1816E-11, 4.0710E-11, 3.9619E-11, 3.8542E-11,
     &   3.7481E-11, 3.6434E-11, 3.5402E-11, 3.4385E-11, 3.3383E-11,
     &   3.2395E-11, 3.1423E-11, 3.0465E-11, 2.9522E-11, 2.8594E-11,
     &   2.7680E-11, 2.6782E-11, 2.5898E-11, 2.5029E-11, 2.4175E-11,
     &   2.3336E-11, 2.2512E-11, 2.1702E-11, 2.0908E-11, 2.0128E-11,
     &   1.9363E-11, 1.8612E-11, 1.7877E-11, 1.7156E-11, 1.6451E-11,
     &   1.5760E-11, 1.5083E-11, 1.4422E-11, 1.3776E-11, 1.3144E-11,
     &   1.2527E-11, 1.1925E-11, 1.1338E-11, 1.0766E-11, 1.0208E-11,
     &   9.6653E-12, 9.1374E-12, 8.6243E-12, 8.1261E-12, 7.6426E-12,
     &   7.1740E-12, 6.7203E-12, 6.2813E-12, 5.8572E-12, 5.4479E-12,
     &   5.0534E-12, 4.6737E-12, 4.3089E-12, 3.9589E-12, 3.6237E-12,
     &   3.3034E-12, 2.9978E-12, 2.7071E-12, 2.4312E-12, 2.1701E-12,
     &   1.9239E-12, 1.6925E-12, 1.4759E-12, 1.2741E-12, 1.0872E-12,
     &   9.1506E-13, 8.9866E-13, 8.8241E-13, 8.6631E-13, 8.5036E-13,
     &   8.3455E-13, 8.1890E-13, 8.0339E-13, 7.8803E-13, 7.7282E-13,
     &   7.5776E-13, 7.4284E-13, 7.2808E-13, 7.1346E-13, 6.9899E-13,
     &   6.8467E-13, 6.7049E-13, 6.5647E-13, 6.4259E-13, 6.2886E-13/
  
         DATA ((DAT (I,J), I= 801, 900), J=1,1) /
     &   6.1528E-13, 6.0185E-13, 5.8857E-13, 5.7543E-13, 5.6244E-13,
     &   5.4961E-13, 5.3691E-13, 5.2437E-13, 5.1198E-13, 4.9973E-13,
     &   4.8763E-13, 4.7568E-13, 4.6388E-13, 4.5223E-13, 4.4072E-13,
     &   4.2937E-13, 4.1816E-13, 4.0710E-13, 3.9619E-13, 3.8542E-13,
     &   3.7481E-13, 3.6434E-13, 3.5402E-13, 3.4385E-13, 3.3383E-13,
     &   3.2395E-13, 3.1423E-13, 3.0465E-13, 2.9522E-13, 2.8594E-13,
     &   2.7680E-13, 2.6782E-13, 2.5898E-13, 2.5029E-13, 2.4175E-13,
     &   2.3336E-13, 2.2512E-13, 2.1702E-13, 2.0908E-13, 2.0128E-13,
     &   1.9363E-13, 1.8612E-13, 1.7877E-13, 1.7156E-13, 1.6451E-13,
     &   1.5760E-13, 1.5083E-13, 1.4422E-13, 1.3776E-13, 1.3144E-13,
     &   1.2527E-13, 1.1925E-13, 1.1338E-13, 1.0766E-13, 1.0208E-13,
     &   9.6653E-14, 9.1374E-14, 8.6243E-14, 8.1261E-14, 7.6426E-14,
     &   7.1740E-14, 6.7203E-14, 6.2813E-14, 5.8572E-14, 5.4479E-14,
     &   5.0534E-14, 4.6737E-14, 4.3089E-14, 3.9589E-14, 3.6237E-14,
     &   3.3034E-14, 2.9978E-14, 2.7071E-14, 2.4312E-14, 2.1701E-14,
     &   1.9239E-14, 1.6925E-14, 1.4759E-14, 1.2741E-14, 1.0872E-14,
     &   9.1506E-15, 0.0000E+00,-9.1506E-15,-8.2411E-08,-3.2955E-07,
     &  -7.4149E-07,-1.3181E-06,-2.0598E-06,-2.9668E-06,-4.0391E-06,
     &  -5.2771E-06,-6.6809E-06,-8.2510E-06,-9.9877E-06,-1.1891E-05,
     &  -1.3962E-05,-1.6201E-05,-1.8609E-05,-2.1185E-05,-2.3931E-05/
  
         DATA ((DAT (I,J), I= 901, 979), J=1,1) /
     &  -2.6847E-05,-2.9934E-05,-3.3193E-05,-3.6624E-05,-4.0228E-05,
     &  -4.4006E-05,-4.7960E-05,-5.2089E-05,-5.6395E-05,-6.0879E-05,
     &  -6.5542E-05,-7.0385E-05,-7.5410E-05,-8.0617E-05,-8.6009E-05,
     &  -9.1585E-05,-9.7349E-05,-1.0330E-04,-1.0944E-04,-1.1578E-04,
     &  -1.2230E-04,-1.2902E-04,-1.3594E-04,-1.4306E-04,-1.5037E-04,
     &  -1.5789E-04,-1.6562E-04,-1.7355E-04,-1.8169E-04,-1.9004E-04,
     &  -1.9861E-04,-2.0739E-04,-2.1640E-04,-2.2562E-04,-2.3507E-04,
     &  -2.4475E-04,-2.5466E-04,-2.6481E-04,-2.7519E-04,-2.8582E-04,
     &  -2.9669E-04,-3.0781E-04,-3.1918E-04,-3.3082E-04,-3.4271E-04,
     &  -3.5488E-04,-3.6731E-04,-3.8003E-04,-3.9302E-04,-4.0631E-04,
     &  -4.1989E-04,-4.3378E-04,-4.4797E-04,-4.6248E-04,-4.7731E-04,
     &  -4.9248E-04,-5.0799E-04,-5.2385E-04,-5.4007E-04,-5.5667E-04,
     &  -5.7365E-04,-5.9103E-04,-6.0882E-04,-6.2704E-04,-6.4571E-04,
     &  -6.6485E-04,-6.8448E-04,-7.0463E-04,-7.2534E-04,-7.4663E-04,
     &  -7.6855E-04,-7.9117E-04,-8.1458E-04,-8.2257E-04,-8.3886E-04,
     &  -8.44678933E-04,-8.64254141E-04,-8.66868511E-04,-8.73034241E-04/
  
         DATA ((DAT (I,J), I=   1, 100), J=2,2) /
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6492E-04,
     &   1.6492E-04, 1.6492E-04, 1.6492E-04, 1.6491E-04, 1.6491E-04,
     &   1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04,
     &   1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04,
     &   1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04,
     &   1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04, 1.6491E-04,
     &   1.6491E-04, 1.6490E-04, 1.6490E-04, 1.6490E-04, 1.6490E-04,
     &   1.6490E-04, 1.6490E-04, 1.6490E-04, 1.6490E-04, 1.6490E-04,
     &   1.6490E-04, 1.6490E-04, 1.6490E-04, 1.6490E-04, 1.6490E-04,
     &   1.6490E-04, 1.6489E-04, 1.6489E-04, 1.6489E-04, 1.6489E-04,
     &   1.6489E-04, 1.6489E-04, 1.6489E-04, 1.6489E-04, 1.6489E-04,
     &   1.6489E-04, 1.6488E-04, 1.6488E-04, 1.6488E-04, 1.6488E-04,
     &   1.6488E-04, 1.6488E-04, 1.6488E-04, 1.6487E-04, 1.6487E-04,
     &   1.6487E-04, 1.6487E-04, 1.6487E-04, 1.6486E-04, 1.6486E-04,
     &   1.6486E-04, 1.6486E-04, 1.6485E-04, 1.6485E-04, 1.6485E-04,
     &   1.6484E-04, 1.6484E-04, 1.6483E-04, 1.6483E-04, 1.6482E-04,
     &   1.6482E-04, 1.6481E-04, 1.6480E-04, 1.6479E-04, 1.6478E-04,
     &   1.6477E-04, 1.6475E-04, 1.6473E-04, 1.6470E-04, 1.6467E-04,
     &   1.6463E-04, 1.6463E-04, 1.6462E-04, 1.6462E-04, 1.6461E-04,
     &   1.6461E-04, 1.6460E-04, 1.6460E-04, 1.6459E-04, 1.6459E-04/
  
         DATA ((DAT (I,J), I= 101, 200), J=2,2) /
     &   1.6458E-04, 1.6457E-04, 1.6457E-04, 1.6456E-04, 1.6455E-04,
     &   1.6455E-04, 1.6454E-04, 1.6453E-04, 1.6452E-04, 1.6452E-04,
     &   1.6451E-04, 1.6450E-04, 1.6449E-04, 1.6448E-04, 1.6447E-04,
     &   1.6446E-04, 1.6445E-04, 1.6444E-04, 1.6443E-04, 1.6441E-04,
     &   1.6440E-04, 1.6439E-04, 1.6438E-04, 1.6436E-04, 1.6435E-04,
     &   1.6433E-04, 1.6432E-04, 1.6430E-04, 1.6428E-04, 1.6426E-04,
     &   1.6424E-04, 1.6422E-04, 1.6420E-04, 1.6418E-04, 1.6416E-04,
     &   1.6413E-04, 1.6411E-04, 1.6408E-04, 1.6405E-04, 1.6402E-04,
     &   1.6399E-04, 1.6395E-04, 1.6392E-04, 1.6388E-04, 1.6384E-04,
     &   1.6379E-04, 1.6375E-04, 1.6370E-04, 1.6365E-04, 1.6359E-04,
     &   1.6353E-04, 1.6346E-04, 1.6339E-04, 1.6332E-04, 1.6324E-04,
     &   1.6315E-04, 1.6305E-04, 1.6295E-04, 1.6284E-04, 1.6272E-04,
     &   1.6258E-04, 1.6244E-04, 1.6227E-04, 1.6210E-04, 1.6190E-04,
     &   1.6168E-04, 1.6144E-04, 1.6117E-04, 1.6086E-04, 1.6052E-04,
     &   1.6013E-04, 1.5969E-04, 1.5918E-04, 1.5860E-04, 1.5793E-04,
     &   1.5714E-04, 1.5621E-04, 1.5510E-04, 1.5377E-04, 1.5215E-04,
     &   1.5016E-04, 1.4996E-04, 1.4975E-04, 1.4954E-04, 1.4932E-04,
     &   1.4910E-04, 1.4888E-04, 1.4865E-04, 1.4842E-04, 1.4818E-04,
     &   1.4793E-04, 1.4768E-04, 1.4743E-04, 1.4717E-04, 1.4690E-04,
     &   1.4663E-04, 1.4635E-04, 1.4607E-04, 1.4577E-04, 1.4548E-04/
  
         DATA ((DAT (I,J), I= 201, 300), J=2,2) /
     &   1.4517E-04, 1.4486E-04, 1.4454E-04, 1.4421E-04, 1.4387E-04,
     &   1.4353E-04, 1.4318E-04, 1.4282E-04, 1.4245E-04, 1.4207E-04,
     &   1.4168E-04, 1.4128E-04, 1.4088E-04, 1.4046E-04, 1.4003E-04,
     &   1.3959E-04, 1.3913E-04, 1.3867E-04, 1.3819E-04, 1.3770E-04,
     &   1.3720E-04, 1.3669E-04, 1.3615E-04, 1.3561E-04, 1.3505E-04,
     &   1.3447E-04, 1.3388E-04, 1.3327E-04, 1.3265E-04, 1.3200E-04,
     &   1.3134E-04, 1.3065E-04, 1.2995E-04, 1.2923E-04, 1.2848E-04,
     &   1.2771E-04, 1.2692E-04, 1.2610E-04, 1.2526E-04, 1.2439E-04,
     &   1.2349E-04, 1.2257E-04, 1.2161E-04, 1.2063E-04, 1.1961E-04,
     &   1.1855E-04, 1.1746E-04, 1.1633E-04, 1.1517E-04, 1.1396E-04,
     &   1.1271E-04, 1.1141E-04, 1.1007E-04, 1.0867E-04, 1.0723E-04,
     &   1.0572E-04, 1.0416E-04, 1.0254E-04, 1.0085E-04, 9.9084E-05,
     &   9.7249E-05, 9.5335E-05, 9.3337E-05, 9.1250E-05, 8.9068E-05,
     &   8.6786E-05, 8.4398E-05, 8.1897E-05, 7.9276E-05, 7.6529E-05,
     &   7.3650E-05, 7.0632E-05, 6.7470E-05, 6.4159E-05, 6.0695E-05,
     &   5.7078E-05, 5.3308E-05, 4.9389E-05, 4.5331E-05, 4.1147E-05,
     &   3.6857E-05, 3.6423E-05, 3.5988E-05, 3.5553E-05, 3.5117E-05,
     &   3.4680E-05, 3.4243E-05, 3.3805E-05, 3.3367E-05, 3.2928E-05,
     &   3.2489E-05, 3.2049E-05, 3.1609E-05, 3.1169E-05, 3.0728E-05,
     &   3.0287E-05, 2.9846E-05, 2.9405E-05, 2.8963E-05, 2.8522E-05/
  
         DATA ((DAT (I,J), I= 301, 400), J=2,2) /
     &   2.8081E-05, 2.7639E-05, 2.7198E-05, 2.6757E-05, 2.6316E-05,
     &   2.5876E-05, 2.5436E-05, 2.4996E-05, 2.4557E-05, 2.4119E-05,
     &   2.3681E-05, 2.3243E-05, 2.2807E-05, 2.2371E-05, 2.1936E-05,
     &   2.1502E-05, 2.1070E-05, 2.0638E-05, 2.0208E-05, 1.9778E-05,
     &   1.9351E-05, 1.8924E-05, 1.8500E-05, 1.8077E-05, 1.7655E-05,
     &   1.7236E-05, 1.6818E-05, 1.6403E-05, 1.5989E-05, 1.5578E-05,
     &   1.5169E-05, 1.4763E-05, 1.4359E-05, 1.3958E-05, 1.3559E-05,
     &   1.3164E-05, 1.2771E-05, 1.2382E-05, 1.1996E-05, 1.1613E-05,
     &   1.1233E-05, 1.0858E-05, 1.0486E-05, 1.0118E-05, 9.7541E-06,
     &   9.3943E-06, 9.0389E-06, 8.6879E-06, 8.3415E-06, 7.9999E-06,
     &   7.6632E-06, 7.3315E-06, 7.0050E-06, 6.6839E-06, 6.3684E-06,
     &   6.0584E-06, 5.7544E-06, 5.4563E-06, 5.1644E-06, 4.8788E-06,
     &   4.5996E-06, 4.3271E-06, 4.0615E-06, 3.8028E-06, 3.5512E-06,
     &   3.3069E-06, 3.0701E-06, 2.8410E-06, 2.6196E-06, 2.4061E-06,
     &   2.2008E-06, 2.0037E-06, 1.8150E-06, 1.6349E-06, 1.4636E-06,
     &   1.3010E-06, 1.1475E-06, 1.0031E-06, 8.6796E-07, 7.4220E-07,
     &   6.2594E-07, 6.1484E-07, 6.0383E-07, 5.9293E-07, 5.8212E-07,
     &   5.7140E-07, 5.6079E-07, 5.5027E-07, 5.3984E-07, 5.2952E-07,
     &   5.1929E-07, 5.0916E-07, 4.9912E-07, 4.8918E-07, 4.7935E-07,
     &   4.6960E-07, 4.5996E-07, 4.5041E-07, 4.4096E-07, 4.3161E-07/
  
         DATA ((DAT (I,J), I= 401, 500), J=2,2) /
     &   4.2236E-07, 4.1320E-07, 4.0415E-07, 3.9519E-07, 3.8633E-07,
     &   3.7757E-07, 3.6890E-07, 3.6034E-07, 3.5187E-07, 3.4351E-07,
     &   3.3524E-07, 3.2707E-07, 3.1900E-07, 3.1103E-07, 3.0316E-07,
     &   2.9539E-07, 2.8771E-07, 2.8014E-07, 2.7267E-07, 2.6529E-07,
     &   2.5802E-07, 2.5084E-07, 2.4377E-07, 2.3679E-07, 2.2992E-07,
     &   2.2315E-07, 2.1647E-07, 2.0990E-07, 2.0342E-07, 1.9705E-07,
     &   1.9078E-07, 1.8460E-07, 1.7853E-07, 1.7256E-07, 1.6669E-07,
     &   1.6092E-07, 1.5525E-07, 1.4968E-07, 1.4421E-07, 1.3885E-07,
     &   1.3358E-07, 1.2842E-07, 1.2335E-07, 1.1839E-07, 1.1353E-07,
     &   1.0877E-07, 1.0411E-07, 9.9557E-08, 9.5102E-08, 9.0748E-08,
     &   8.6495E-08, 8.2345E-08, 7.8296E-08, 7.4348E-08, 7.0502E-08,
     &   6.6759E-08, 6.3116E-08, 5.9576E-08, 5.6138E-08, 5.2801E-08,
     &   4.9566E-08, 4.6434E-08, 4.3403E-08, 4.0474E-08, 3.7648E-08,
     &   3.4924E-08, 3.2301E-08, 2.9781E-08, 2.7363E-08, 2.5047E-08,
     &   2.2834E-08, 2.0723E-08, 1.8714E-08, 1.6807E-08, 1.5003E-08,
     &   1.3301E-08, 1.1701E-08, 1.0204E-08, 8.8094E-09, 7.5170E-09,
     &   6.3270E-09, 6.2137E-09, 6.1013E-09, 5.9900E-09, 5.8797E-09,
     &   5.7705E-09, 5.6622E-09, 5.5550E-09, 5.4488E-09, 5.3437E-09,
     &   5.2395E-09, 5.1364E-09, 5.0343E-09, 4.9332E-09, 4.8332E-09,
     &   4.7342E-09, 4.6362E-09, 4.5392E-09, 4.4433E-09, 4.3484E-09/
  
         DATA ((DAT (I,J), I= 501, 600), J=2,2) /
     &   4.2545E-09, 4.1616E-09, 4.0697E-09, 3.9789E-09, 3.8891E-09,
     &   3.8003E-09, 3.7126E-09, 3.6259E-09, 3.5402E-09, 3.4555E-09,
     &   3.3719E-09, 3.2892E-09, 3.2076E-09, 3.1271E-09, 3.0475E-09,
     &   2.9690E-09, 2.8915E-09, 2.8150E-09, 2.7396E-09, 2.6651E-09,
     &   2.5917E-09, 2.5193E-09, 2.4480E-09, 2.3777E-09, 2.3084E-09,
     &   2.2401E-09, 2.1728E-09, 2.1066E-09, 2.0414E-09, 1.9772E-09,
     &   1.9141E-09, 1.8519E-09, 1.7908E-09, 1.7308E-09, 1.6717E-09,
     &   1.6137E-09, 1.5567E-09, 1.5007E-09, 1.4458E-09, 1.3918E-09,
     &   1.3389E-09, 1.2870E-09, 1.2362E-09, 1.1864E-09, 1.1376E-09,
     &   1.0898E-09, 1.0430E-09, 9.9729E-10, 9.5259E-10, 9.0891E-10,
     &   8.6625E-10, 8.2463E-10, 7.8402E-10, 7.4444E-10, 7.0589E-10,
     &   6.6836E-10, 6.3186E-10, 5.9638E-10, 5.6192E-10, 5.2849E-10,
     &   4.9609E-10, 4.6471E-10, 4.3436E-10, 4.0503E-10, 3.7673E-10,
     &   3.4945E-10, 3.2319E-10, 2.9797E-10, 2.7376E-10, 2.5058E-10,
     &   2.2843E-10, 2.0730E-10, 1.8720E-10, 1.6812E-10, 1.5007E-10,
     &   1.3304E-10, 1.1704E-10, 1.0206E-10, 8.8107E-11, 7.5180E-11,
     &   6.3277E-11, 6.2143E-11, 6.1020E-11, 5.9906E-11, 5.8803E-11,
     &   5.7711E-11, 5.6628E-11, 5.5556E-11, 5.4493E-11, 5.3442E-11,
     &   5.2400E-11, 5.1369E-11, 5.0348E-11, 4.9337E-11, 4.8336E-11,
     &   4.7346E-11, 4.6366E-11, 4.5396E-11, 4.4436E-11, 4.3487E-11/
  
         DATA ((DAT (I,J), I= 601, 700), J=2,2) /
     &   4.2548E-11, 4.1619E-11, 4.0700E-11, 3.9792E-11, 3.8894E-11,
     &   3.8006E-11, 3.7128E-11, 3.6261E-11, 3.5404E-11, 3.4557E-11,
     &   3.3721E-11, 3.2894E-11, 3.2078E-11, 3.1272E-11, 3.0477E-11,
     &   2.9691E-11, 2.8916E-11, 2.8151E-11, 2.7397E-11, 2.6652E-11,
     &   2.5918E-11, 2.5195E-11, 2.4481E-11, 2.3778E-11, 2.3085E-11,
     &   2.2402E-11, 2.1729E-11, 2.1067E-11, 2.0415E-11, 1.9773E-11,
     &   1.9141E-11, 1.8520E-11, 1.7909E-11, 1.7308E-11, 1.6718E-11,
     &   1.6137E-11, 1.5567E-11, 1.5007E-11, 1.4458E-11, 1.3919E-11,
     &   1.3389E-11, 1.2871E-11, 1.2362E-11, 1.1864E-11, 1.1376E-11,
     &   1.0898E-11, 1.0430E-11, 9.9731E-12, 9.5260E-12, 9.0892E-12,
     &   8.6627E-12, 8.2464E-12, 7.8403E-12, 7.4445E-12, 7.0590E-12,
     &   6.6837E-12, 6.3186E-12, 5.9638E-12, 5.6193E-12, 5.2850E-12,
     &   4.9609E-12, 4.6472E-12, 4.3436E-12, 4.0503E-12, 3.7673E-12,
     &   3.4945E-12, 3.2320E-12, 2.9797E-12, 2.7376E-12, 2.5058E-12,
     &   2.2843E-12, 2.0730E-12, 1.8720E-12, 1.6812E-12, 1.5007E-12,
     &   1.3304E-12, 1.1704E-12, 1.0206E-12, 8.8107E-13, 7.5180E-13,
     &   6.3277E-13, 6.2144E-13, 6.1020E-13, 5.9907E-13, 5.8803E-13,
     &   5.7711E-13, 5.6628E-13, 5.5556E-13, 5.4493E-13, 5.3442E-13,
     &   5.2400E-13, 5.1369E-13, 5.0348E-13, 4.9337E-13, 4.8336E-13,
     &   4.7346E-13, 4.6366E-13, 4.5396E-13, 4.4436E-13, 4.3487E-13/
  
         DATA ((DAT (I,J), I= 701, 800), J=2,2) /
     &   4.2548E-13, 4.1619E-13, 4.0700E-13, 3.9792E-13, 3.8894E-13,
     &   3.8006E-13, 3.7128E-13, 3.6261E-13, 3.5404E-13, 3.4557E-13,
     &   3.3721E-13, 3.2894E-13, 3.2078E-13, 3.1272E-13, 3.0477E-13,
     &   2.9691E-13, 2.8916E-13, 2.8151E-13, 2.7397E-13, 2.6653E-13,
     &   2.5918E-13, 2.5195E-13, 2.4481E-13, 2.3778E-13, 2.3085E-13,
     &   2.2402E-13, 2.1729E-13, 2.1067E-13, 2.0415E-13, 1.9773E-13,
     &   1.9141E-13, 1.8520E-13, 1.7909E-13, 1.7308E-13, 1.6718E-13,
     &   1.6137E-13, 1.5567E-13, 1.5007E-13, 1.4458E-13, 1.3919E-13,
     &   1.3390E-13, 1.2871E-13, 1.2362E-13, 1.1864E-13, 1.1376E-13,
     &   1.0898E-13, 1.0430E-13, 9.9731E-14, 9.5260E-14, 9.0892E-14,
     &   8.6627E-14, 8.2464E-14, 7.8403E-14, 7.4445E-14, 7.0590E-14,
     &   6.6837E-14, 6.3186E-14, 5.9638E-14, 5.6193E-14, 5.2850E-14,
     &   4.9609E-14, 4.6472E-14, 4.3436E-14, 4.0503E-14, 3.7673E-14,
     &   3.4945E-14, 3.2320E-14, 2.9797E-14, 2.7376E-14, 2.5058E-14,
     &   2.2843E-14, 2.0730E-14, 1.8720E-14, 1.6812E-14, 1.5007E-14,
     &   1.3304E-14, 1.1704E-14, 1.0206E-14, 8.8107E-15, 7.5180E-15,
     &   6.3277E-15, 6.2144E-15, 6.1020E-15, 5.9907E-15, 5.8803E-15,
     &   5.7711E-15, 5.6628E-15, 5.5556E-15, 5.4493E-15, 5.3442E-15,
     &   5.2400E-15, 5.1369E-15, 5.0348E-15, 4.9337E-15, 4.8336E-15,
     &   4.7346E-15, 4.6366E-15, 4.5396E-15, 4.4436E-15, 4.3487E-15/
  
         DATA ((DAT (I,J), I= 801, 900), J=2,2) /
     &   4.2548E-15, 4.1619E-15, 4.0700E-15, 3.9792E-15, 3.8894E-15,
     &   3.8006E-15, 3.7128E-15, 3.6261E-15, 3.5404E-15, 3.4557E-15,
     &   3.3721E-15, 3.2894E-15, 3.2078E-15, 3.1272E-15, 3.0477E-15,
     &   2.9691E-15, 2.8916E-15, 2.8151E-15, 2.7397E-15, 2.6653E-15,
     &   2.5918E-15, 2.5195E-15, 2.4481E-15, 2.3778E-15, 2.3085E-15,
     &   2.2402E-15, 2.1729E-15, 2.1067E-15, 2.0415E-15, 1.9773E-15,
     &   1.9141E-15, 1.8520E-15, 1.7909E-15, 1.7308E-15, 1.6718E-15,
     &   1.6137E-15, 1.5567E-15, 1.5007E-15, 1.4458E-15, 1.3919E-15,
     &   1.3390E-15, 1.2871E-15, 1.2362E-15, 1.1864E-15, 1.1376E-15,
     &   1.0898E-15, 1.0430E-15, 9.9731E-16, 9.5260E-16, 9.0892E-16,
     &   8.6627E-16, 8.2464E-16, 7.8403E-16, 7.4445E-16, 7.0590E-16,
     &   6.6837E-16, 6.3186E-16, 5.9638E-16, 5.6193E-16, 5.2850E-16,
     &   4.9609E-16, 4.6472E-16, 4.3436E-16, 4.0503E-16, 3.7673E-16,
     &   3.4945E-16, 3.2320E-16, 2.9797E-16, 2.7376E-16, 2.5058E-16,
     &   2.2843E-16, 2.0730E-16, 1.8720E-16, 1.6812E-16, 1.5007E-16,
     &   1.3304E-16, 1.1704E-16, 1.0206E-16, 8.8107E-17, 7.5180E-17,
     &   6.3277E-17, 0.0000E+00, 6.3277E-17, 5.6988E-10, 2.2788E-09,
     &   5.1271E-09, 9.1134E-09, 1.4241E-08, 2.0509E-08, 2.7919E-08,
     &   3.6471E-08, 4.6167E-08, 5.7007E-08, 6.8993E-08, 8.2126E-08,
     &   9.6408E-08, 1.1184E-07, 1.2843E-07, 1.4617E-07, 1.6506E-07/
  
         DATA ((DAT (I,J), I= 901, 979), J=2,2) /
     &   1.8512E-07, 2.0634E-07, 2.2872E-07, 2.5227E-07, 2.7699E-07,
     &   3.0288E-07, 3.2995E-07, 3.5820E-07, 3.8763E-07, 4.1825E-07,
     &   4.5006E-07, 4.8307E-07, 5.1728E-07, 5.5269E-07, 5.8931E-07,
     &   6.2714E-07, 6.6620E-07, 7.0648E-07, 7.4799E-07, 7.9074E-07,
     &   8.3472E-07, 8.7996E-07, 9.2645E-07, 9.7421E-07, 1.0232E-06,
     &   1.0735E-06, 1.1251E-06, 1.1780E-06, 1.2322E-06, 1.2877E-06,
     &   1.3445E-06, 1.4026E-06, 1.4621E-06, 1.5229E-06, 1.5851E-06,
     &   1.6486E-06, 1.7135E-06, 1.7799E-06, 1.8476E-06, 1.9167E-06,
     &   1.9873E-06, 2.0593E-06, 2.1328E-06, 2.2078E-06, 2.2842E-06,
     &   2.3622E-06, 2.4417E-06, 2.5228E-06, 2.6054E-06, 2.6896E-06,
     &   2.7754E-06, 2.8629E-06, 2.9520E-06, 3.0429E-06, 3.1354E-06,
     &   3.2297E-06, 3.3258E-06, 3.4238E-06, 3.5236E-06, 3.6253E-06,
     &   3.7289E-06, 3.8346E-06, 3.9424E-06, 4.0523E-06, 4.1644E-06,
     &   4.2788E-06, 4.3956E-06, 4.5148E-06, 4.6367E-06, 4.7613E-06,
     &   4.8889E-06, 5.0195E-06, 5.1535E-06, 5.1989E-06, 5.2911E-06,
     &   5.32376698E-06, 5.43280123E-06, 5.44722264E-06, 5.48106272E-06/

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 13:05:01 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: *, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c
c replaced March 30, 2012 [dalhads.dat;430]
  
         DATA ((DGT (I,J), I=   1, 100), J=1,1) /
     &   8.2803E-02, 8.2697E-02, 8.2589E-02, 8.2481E-02, 8.2371E-02,
     &   8.2260E-02, 8.2148E-02, 8.2034E-02, 8.1919E-02, 8.1803E-02,
     &   8.1685E-02, 8.1566E-02, 8.1445E-02, 8.1323E-02, 8.1199E-02,
     &   8.1073E-02, 8.0946E-02, 8.0817E-02, 8.0687E-02, 8.0554E-02,
     &   8.0420E-02, 8.0284E-02, 8.0146E-02, 8.0006E-02, 7.9864E-02,
     &   7.9720E-02, 7.9573E-02, 7.9425E-02, 7.9274E-02, 7.9121E-02,
     &   7.8965E-02, 7.8807E-02, 7.8646E-02, 7.8483E-02, 7.8317E-02,
     &   7.8148E-02, 7.7976E-02, 7.7801E-02, 7.7623E-02, 7.7442E-02,
     &   7.7257E-02, 7.7069E-02, 7.6877E-02, 7.6682E-02, 7.6483E-02,
     &   7.6280E-02, 7.6073E-02, 7.5861E-02, 7.5645E-02, 7.5425E-02,
     &   7.5200E-02, 7.4969E-02, 7.4734E-02, 7.4493E-02, 7.4246E-02,
     &   7.3994E-02, 7.3735E-02, 7.3470E-02, 7.3199E-02, 7.2920E-02,
     &   7.2634E-02, 7.2340E-02, 7.2037E-02, 7.1727E-02, 7.1407E-02,
     &   7.1077E-02, 7.0737E-02, 7.0387E-02, 7.0025E-02, 6.9651E-02,
     &   6.9264E-02, 6.8864E-02, 6.8449E-02, 6.8017E-02, 6.7569E-02,
     &   6.7103E-02, 6.6617E-02, 6.6109E-02, 6.5578E-02, 6.5022E-02,
     &   6.4438E-02, 6.3822E-02, 6.3173E-02, 6.2486E-02, 6.1756E-02,
     &   6.0978E-02, 6.0146E-02, 5.9251E-02, 5.8283E-02, 5.7229E-02,
     &   5.6074E-02, 5.5952E-02, 5.5829E-02, 5.5705E-02, 5.5579E-02,
     &   5.5452E-02, 5.5324E-02, 5.5194E-02, 5.5063E-02, 5.4930E-02/
  
         DATA ((DGT (I,J), I= 101, 200), J=1,1) /
     &   5.4796E-02, 5.4661E-02, 5.4523E-02, 5.4385E-02, 5.4244E-02,
     &   5.4102E-02, 5.3959E-02, 5.3813E-02, 5.3666E-02, 5.3517E-02,
     &   5.3366E-02, 5.3213E-02, 5.3058E-02, 5.2902E-02, 5.2743E-02,
     &   5.2582E-02, 5.2419E-02, 5.2253E-02, 5.2086E-02, 5.1916E-02,
     &   5.1743E-02, 5.1568E-02, 5.1391E-02, 5.1210E-02, 5.1028E-02,
     &   5.0842E-02, 5.0653E-02, 5.0462E-02, 5.0267E-02, 5.0069E-02,
     &   4.9868E-02, 4.9664E-02, 4.9456E-02, 4.9244E-02, 4.9029E-02,
     &   4.8809E-02, 4.8586E-02, 4.8358E-02, 4.8127E-02, 4.7890E-02,
     &   4.7649E-02, 4.7403E-02, 4.7152E-02, 4.6896E-02, 4.6634E-02,
     &   4.6367E-02, 4.6093E-02, 4.5813E-02, 4.5527E-02, 4.5234E-02,
     &   4.4933E-02, 4.4625E-02, 4.4309E-02, 4.3985E-02, 4.3651E-02,
     &   4.3309E-02, 4.2956E-02, 4.2593E-02, 4.2219E-02, 4.1834E-02,
     &   4.1435E-02, 4.1024E-02, 4.0598E-02, 4.0157E-02, 3.9700E-02,
     &   3.9225E-02, 3.8731E-02, 3.8217E-02, 3.7680E-02, 3.7119E-02,
     &   3.6532E-02, 3.5916E-02, 3.5268E-02, 3.4584E-02, 3.3861E-02,
     &   3.3094E-02, 3.2277E-02, 3.1404E-02, 3.0466E-02, 2.9454E-02,
     &   2.8354E-02, 2.8251E-02, 2.8146E-02, 2.8041E-02, 2.7934E-02,
     &   2.7827E-02, 2.7719E-02, 2.7610E-02, 2.7500E-02, 2.7389E-02,
     &   2.7277E-02, 2.7164E-02, 2.7050E-02, 2.6935E-02, 2.6819E-02,
     &   2.6702E-02, 2.6583E-02, 2.6464E-02, 2.6344E-02, 2.6222E-02/
  
         DATA ((DGT (I,J), I= 201, 300), J=1,1) /
     &   2.6099E-02, 2.5976E-02, 2.5850E-02, 2.5724E-02, 2.5596E-02,
     &   2.5468E-02, 2.5337E-02, 2.5206E-02, 2.5073E-02, 2.4939E-02,
     &   2.4803E-02, 2.4666E-02, 2.4527E-02, 2.4387E-02, 2.4245E-02,
     &   2.4102E-02, 2.3957E-02, 2.3810E-02, 2.3662E-02, 2.3511E-02,
     &   2.3360E-02, 2.3206E-02, 2.3050E-02, 2.2893E-02, 2.2733E-02,
     &   2.2572E-02, 2.2408E-02, 2.2243E-02, 2.2075E-02, 2.1905E-02,
     &   2.1733E-02, 2.1558E-02, 2.1381E-02, 2.1201E-02, 2.1019E-02,
     &   2.0834E-02, 2.0647E-02, 2.0456E-02, 2.0263E-02, 2.0067E-02,
     &   1.9868E-02, 1.9665E-02, 1.9460E-02, 1.9251E-02, 1.9038E-02,
     &   1.8822E-02, 1.8603E-02, 1.8379E-02, 1.8152E-02, 1.7920E-02,
     &   1.7684E-02, 1.7444E-02, 1.7199E-02, 1.6949E-02, 1.6694E-02,
     &   1.6434E-02, 1.6169E-02, 1.5897E-02, 1.5620E-02, 1.5337E-02,
     &   1.5047E-02, 1.4751E-02, 1.4447E-02, 1.4135E-02, 1.3816E-02,
     &   1.3487E-02, 1.3150E-02, 1.2803E-02, 1.2445E-02, 1.2076E-02,
     &   1.1695E-02, 1.1300E-02, 1.0891E-02, 1.0466E-02, 1.0024E-02,
     &   9.5625E-03, 9.0796E-03, 8.5731E-03, 8.0405E-03, 7.4790E-03,
     &   6.8857E-03, 6.8245E-03, 6.7630E-03, 6.7011E-03, 6.6389E-03,
     &   6.5763E-03, 6.5134E-03, 6.4501E-03, 6.3865E-03, 6.3225E-03,
     &   6.2581E-03, 6.1934E-03, 6.1283E-03, 6.0628E-03, 5.9970E-03,
     &   5.9308E-03, 5.8642E-03, 5.7973E-03, 5.7300E-03, 5.6623E-03/
  
         DATA ((DGT (I,J), I= 301, 400), J=1,1) /
     &   5.5943E-03, 5.5259E-03, 5.4571E-03, 5.3879E-03, 5.3184E-03,
     &   5.2486E-03, 5.1783E-03, 5.1077E-03, 5.0368E-03, 4.9655E-03,
     &   4.8938E-03, 4.8220E-03, 4.7496E-03, 4.6769E-03, 4.6039E-03,
     &   4.5306E-03, 4.4570E-03, 4.3830E-03, 4.3087E-03, 4.2342E-03,
     &   4.1593E-03, 4.0842E-03, 4.0089E-03, 3.9332E-03, 3.8574E-03,
     &   3.7813E-03, 3.7050E-03, 3.6285E-03, 3.5518E-03, 3.4750E-03,
     &   3.3980E-03, 3.3209E-03, 3.2437E-03, 3.1664E-03, 3.0890E-03,
     &   3.0116E-03, 2.9342E-03, 2.8568E-03, 2.7795E-03, 2.7022E-03,
     &   2.6251E-03, 2.5481E-03, 2.4712E-03, 2.3946E-03, 2.3181E-03,
     &   2.2420E-03, 2.1662E-03, 2.0908E-03, 2.0157E-03, 1.9411E-03,
     &   1.8670E-03, 1.7935E-03, 1.7206E-03, 1.6483E-03, 1.5767E-03,
     &   1.5059E-03, 1.4358E-03, 1.3664E-03, 1.2988E-03, 1.2316E-03,
     &   1.1654E-03, 1.1003E-03, 1.0365E-03, 9.7384E-04, 9.1254E-04,
     &   8.5262E-04, 7.9416E-04, 7.3723E-04, 6.8189E-04, 6.2822E-04,
     &   5.7629E-04, 5.2616E-04, 4.7792E-04, 4.3162E-04, 3.8734E-04,
     &   3.4515E-04, 3.0511E-04, 2.6729E-04, 2.3174E-04, 1.9854E-04,
     &   1.6773E-04, 1.6478E-04, 1.6186E-04, 1.5897E-04, 1.5609E-04,
     &   1.5324E-04, 1.5042E-04, 1.4762E-04, 1.4485E-04, 1.4210E-04,
     &   1.3938E-04, 1.3668E-04, 1.3401E-04, 1.3136E-04, 1.2873E-04,
     &   1.2614E-04, 1.2356E-04, 1.2102E-04, 1.1849E-04, 1.1600E-04/
  
         DATA ((DGT (I,J), I= 401, 500), J=1,1) /
     &   1.1353E-04, 1.1108E-04, 1.0866E-04, 1.0627E-04, 1.0390E-04,
     &   1.0156E-04, 9.9240E-05, 9.6948E-05, 9.4683E-05, 9.2443E-05,
     &   9.0230E-05, 8.8042E-05, 8.5880E-05, 8.3745E-05, 8.1635E-05,
     &   7.9552E-05, 7.7494E-05, 7.5463E-05, 7.3458E-05, 7.1480E-05,
     &   6.9528E-05, 6.7602E-05, 6.5702E-05, 6.3829E-05, 6.1983E-05,
     &   6.0163E-05, 5.8369E-05, 5.6602E-05, 5.4862E-05, 5.3148E-05,
     &   5.1461E-05, 4.9801E-05, 4.8167E-05, 4.6560E-05, 4.4980E-05,
     &   4.3427E-05, 4.1901E-05, 4.0401E-05, 3.8929E-05, 3.7483E-05,
     &   3.6065E-05, 3.4673E-05, 3.3309E-05, 3.1971E-05, 3.0661E-05,
     &   2.9378E-05, 2.8122E-05, 2.6893E-05, 2.5691E-05, 2.4516E-05,
     &   2.3369E-05, 2.2249E-05, 2.1156E-05, 2.0091E-05, 1.9053E-05,
     &   1.8042E-05, 1.7059E-05, 1.6103E-05, 1.5174E-05, 1.4273E-05,
     &   1.3399E-05, 1.2553E-05, 1.1734E-05, 1.0943E-05, 1.0179E-05,
     &   9.4430E-06, 8.7343E-06, 8.0532E-06, 7.3996E-06, 6.7736E-06,
     &   6.1753E-06, 5.6045E-06, 5.0613E-06, 4.5458E-06, 4.0579E-06,
     &   3.5977E-06, 3.1651E-06, 2.7602E-06, 2.3829E-06, 2.0334E-06,
     &   1.7115E-06, 1.6809E-06, 1.6505E-06, 1.6204E-06, 1.5905E-06,
     &   1.5610E-06, 1.5317E-06, 1.5027E-06, 1.4740E-06, 1.4455E-06,
     &   1.4174E-06, 1.3895E-06, 1.3619E-06, 1.3345E-06, 1.3075E-06,
     &   1.2807E-06, 1.2542E-06, 1.2279E-06, 1.2020E-06, 1.1763E-06/
  
         DATA ((DGT (I,J), I= 501, 600), J=1,1) /
     &   1.1509E-06, 1.1258E-06, 1.1009E-06, 1.0764E-06, 1.0521E-06,
     &   1.0281E-06, 1.0043E-06, 9.8088E-07, 9.5769E-07, 9.3479E-07,
     &   9.1216E-07, 8.8981E-07, 8.6774E-07, 8.4594E-07, 8.2442E-07,
     &   8.0318E-07, 7.8222E-07, 7.6153E-07, 7.4112E-07, 7.2098E-07,
     &   7.0113E-07, 6.8155E-07, 6.6225E-07, 6.4322E-07, 6.2448E-07,
     &   6.0601E-07, 5.8781E-07, 5.6990E-07, 5.5226E-07, 5.3490E-07,
     &   5.1781E-07, 5.0101E-07, 4.8448E-07, 4.6822E-07, 4.5225E-07,
     &   4.3655E-07, 4.2113E-07, 4.0599E-07, 3.9112E-07, 3.7653E-07,
     &   3.6222E-07, 3.4818E-07, 3.3443E-07, 3.2095E-07, 3.0774E-07,
     &   2.9482E-07, 2.8217E-07, 2.6980E-07, 2.5771E-07, 2.4589E-07,
     &   2.3435E-07, 2.2309E-07, 2.1210E-07, 2.0140E-07, 1.9097E-07,
     &   1.8081E-07, 1.7094E-07, 1.6134E-07, 1.5202E-07, 1.4298E-07,
     &   1.3421E-07, 1.2572E-07, 1.1751E-07, 1.0957E-07, 1.0192E-07,
     &   9.4538E-08, 8.7435E-08, 8.0610E-08, 7.4062E-08, 6.7792E-08,
     &   6.1799E-08, 5.6083E-08, 5.0644E-08, 4.5483E-08, 4.0599E-08,
     &   3.5992E-08, 3.1663E-08, 2.7611E-08, 2.3836E-08, 2.0339E-08,
     &   1.7119E-08, 1.6812E-08, 1.6508E-08, 1.6207E-08, 1.5908E-08,
     &   1.5613E-08, 1.5320E-08, 1.5030E-08, 1.4742E-08, 1.4458E-08,
     &   1.4176E-08, 1.3897E-08, 1.3621E-08, 1.3347E-08, 1.3077E-08,
     &   1.2809E-08, 1.2544E-08, 1.2281E-08, 1.2022E-08, 1.1765E-08/
  
         DATA ((DGT (I,J), I= 601, 700), J=1,1) /
     &   1.1511E-08, 1.1259E-08, 1.1011E-08, 1.0765E-08, 1.0522E-08,
     &   1.0282E-08, 1.0045E-08, 9.8099E-09, 9.5781E-09, 9.3490E-09,
     &   9.1226E-09, 8.8991E-09, 8.6783E-09, 8.4603E-09, 8.2450E-09,
     &   8.0326E-09, 7.8229E-09, 7.6160E-09, 7.4118E-09, 7.2105E-09,
     &   7.0119E-09, 6.8161E-09, 6.6230E-09, 6.4327E-09, 6.2452E-09,
     &   6.0605E-09, 5.8785E-09, 5.6994E-09, 5.5229E-09, 5.3493E-09,
     &   5.1784E-09, 5.0104E-09, 4.8450E-09, 4.6825E-09, 4.5227E-09,
     &   4.3657E-09, 4.2115E-09, 4.0601E-09, 3.9114E-09, 3.7655E-09,
     &   3.6223E-09, 3.4820E-09, 3.3444E-09, 3.2096E-09, 3.0776E-09,
     &   2.9483E-09, 2.8218E-09, 2.6981E-09, 2.5771E-09, 2.4590E-09,
     &   2.3436E-09, 2.2309E-09, 2.1211E-09, 2.0140E-09, 1.9097E-09,
     &   1.8082E-09, 1.7094E-09, 1.6134E-09, 1.5202E-09, 1.4298E-09,
     &   1.3421E-09, 1.2572E-09, 1.1751E-09, 1.0958E-09, 1.0192E-09,
     &   9.4539E-10, 8.7436E-10, 8.0611E-10, 7.4063E-10, 6.7792E-10,
     &   6.1799E-10, 5.6083E-10, 5.0644E-10, 4.5483E-10, 4.0599E-10,
     &   3.5992E-10, 3.1663E-10, 2.7611E-10, 2.3836E-10, 2.0339E-10,
     &   1.7119E-10, 1.6812E-10, 1.6508E-10, 1.6207E-10, 1.5908E-10,
     &   1.5613E-10, 1.5320E-10, 1.5030E-10, 1.4742E-10, 1.4458E-10,
     &   1.4176E-10, 1.3897E-10, 1.3621E-10, 1.3347E-10, 1.3077E-10,
     &   1.2809E-10, 1.2544E-10, 1.2281E-10, 1.2022E-10, 1.1765E-10/
  
         DATA ((DGT (I,J), I= 701, 800), J=1,1) /
     &   1.1511E-10, 1.1259E-10, 1.1011E-10, 1.0765E-10, 1.0522E-10,
     &   1.0282E-10, 1.0045E-10, 9.8099E-11, 9.5781E-11, 9.3490E-11,
     &   9.1226E-11, 8.8991E-11, 8.6783E-11, 8.4603E-11, 8.2451E-11,
     &   8.0326E-11, 7.8229E-11, 7.6160E-11, 7.4118E-11, 7.2105E-11,
     &   7.0119E-11, 6.8161E-11, 6.6230E-11, 6.4327E-11, 6.2452E-11,
     &   6.0605E-11, 5.8785E-11, 5.6994E-11, 5.5230E-11, 5.3493E-11,
     &   5.1785E-11, 5.0104E-11, 4.8450E-11, 4.6825E-11, 4.5227E-11,
     &   4.3657E-11, 4.2115E-11, 4.0601E-11, 3.9114E-11, 3.7655E-11,
     &   3.6223E-11, 3.4820E-11, 3.3444E-11, 3.2096E-11, 3.0776E-11,
     &   2.9483E-11, 2.8218E-11, 2.6981E-11, 2.5771E-11, 2.4590E-11,
     &   2.3436E-11, 2.2309E-11, 2.1211E-11, 2.0140E-11, 1.9097E-11,
     &   1.8082E-11, 1.7094E-11, 1.6134E-11, 1.5202E-11, 1.4298E-11,
     &   1.3421E-11, 1.2572E-11, 1.1751E-11, 1.0958E-11, 1.0192E-11,
     &   9.4539E-12, 8.7436E-12, 8.0611E-12, 7.4063E-12, 6.7792E-12,
     &   6.1799E-12, 5.6083E-12, 5.0644E-12, 4.5483E-12, 4.0599E-12,
     &   3.5992E-12, 3.1663E-12, 2.7611E-12, 2.3836E-12, 2.0339E-12,
     &   1.7119E-12, 1.6812E-12, 1.6508E-12, 1.6207E-12, 1.5908E-12,
     &   1.5613E-12, 1.5320E-12, 1.5030E-12, 1.4742E-12, 1.4458E-12,
     &   1.4176E-12, 1.3897E-12, 1.3621E-12, 1.3347E-12, 1.3077E-12,
     &   1.2809E-12, 1.2544E-12, 1.2281E-12, 1.2022E-12, 1.1765E-12/
  
         DATA ((DGT (I,J), I= 801, 900), J=1,1) /
     &   1.1511E-12, 1.1259E-12, 1.1011E-12, 1.0765E-12, 1.0522E-12,
     &   1.0282E-12, 1.0045E-12, 9.8099E-13, 9.5781E-13, 9.3490E-13,
     &   9.1226E-13, 8.8991E-13, 8.6783E-13, 8.4603E-13, 8.2451E-13,
     &   8.0326E-13, 7.8229E-13, 7.6160E-13, 7.4118E-13, 7.2105E-13,
     &   7.0119E-13, 6.8161E-13, 6.6230E-13, 6.4327E-13, 6.2452E-13,
     &   6.0605E-13, 5.8785E-13, 5.6994E-13, 5.5230E-13, 5.3493E-13,
     &   5.1785E-13, 5.0104E-13, 4.8450E-13, 4.6825E-13, 4.5227E-13,
     &   4.3657E-13, 4.2115E-13, 4.0601E-13, 3.9114E-13, 3.7655E-13,
     &   3.6223E-13, 3.4820E-13, 3.3444E-13, 3.2096E-13, 3.0776E-13,
     &   2.9483E-13, 2.8218E-13, 2.6981E-13, 2.5771E-13, 2.4590E-13,
     &   2.3436E-13, 2.2309E-13, 2.1211E-13, 2.0140E-13, 1.9097E-13,
     &   1.8082E-13, 1.7094E-13, 1.6134E-13, 1.5202E-13, 1.4298E-13,
     &   1.3421E-13, 1.2572E-13, 1.1751E-13, 1.0958E-13, 1.0192E-13,
     &   9.4539E-14, 8.7436E-14, 8.0611E-14, 7.4063E-14, 6.7792E-14,
     &   6.1799E-14, 5.6083E-14, 5.0644E-14, 4.5483E-14, 4.0599E-14,
     &   3.5992E-14, 3.1663E-14, 2.7611E-14, 2.3836E-14, 2.0339E-14,
     &   1.7119E-14, 0.0000E+00,-1.7119E-14,-1.5418E-07,-6.1653E-07,
     &  -1.3872E-06,-2.4659E-06,-3.8536E-06,-5.5503E-06,-7.5564E-06,
     &  -9.8723E-06,-1.2499E-05,-1.5436E-05,-1.8685E-05,-2.2246E-05,
     &  -2.6121E-05,-3.0309E-05,-3.4813E-05,-3.9633E-05,-4.4770E-05/
  
         DATA ((DGT (I,J), I= 901, 979), J=1,1) /
     &  -5.0225E-05,-5.6001E-05,-6.2097E-05,-6.8515E-05,-7.5258E-05,
     &  -8.2326E-05,-8.9722E-05,-9.7446E-05,-1.0550E-04,-1.1389E-04,
     &  -1.2261E-04,-1.3167E-04,-1.4107E-04,-1.5082E-04,-1.6090E-04,
     &  -1.7133E-04,-1.8212E-04,-1.9325E-04,-2.0474E-04,-2.1659E-04,
     &  -2.2880E-04,-2.4137E-04,-2.5431E-04,-2.6762E-04,-2.8131E-04,
     &  -2.9538E-04,-3.0983E-04,-3.2467E-04,-3.3990E-04,-3.5552E-04,
     &  -3.7155E-04,-3.8798E-04,-4.0483E-04,-4.2209E-04,-4.3977E-04,
     &  -4.5788E-04,-4.7643E-04,-4.9541E-04,-5.1484E-04,-5.3472E-04,
     &  -5.5506E-04,-5.7587E-04,-5.9716E-04,-6.1892E-04,-6.4119E-04,
     &  -6.6395E-04,-6.8722E-04,-7.1102E-04,-7.3534E-04,-7.6021E-04,
     &  -7.8564E-04,-8.1163E-04,-8.3820E-04,-8.6537E-04,-8.9314E-04,
     &  -9.2154E-04,-9.5058E-04,-9.8029E-04,-1.0107E-03,-1.0418E-03,
     &  -1.0736E-03,-1.1061E-03,-1.1395E-03,-1.1736E-03,-1.2086E-03,
     &  -1.2445E-03,-1.2813E-03,-1.3191E-03,-1.3580E-03,-1.3980E-03,
     &  -1.4391E-03,-1.4816E-03,-1.5256E-03,-1.5406E-03,-1.5713E-03,
     &  -1.58224069E-03,-1.61909042E-03,-1.62401449E-03,-1.63563025E-03/
  
         DATA ((DGT (I,J), I=   1, 100), J=2,2) /
     &   3.6669E-04, 3.6669E-04, 3.6669E-04, 3.6669E-04, 3.6669E-04,
     &   3.6669E-04, 3.6669E-04, 3.6669E-04, 3.6669E-04, 3.6669E-04,
     &   3.6669E-04, 3.6669E-04, 3.6669E-04, 3.6669E-04, 3.6668E-04,
     &   3.6668E-04, 3.6668E-04, 3.6668E-04, 3.6668E-04, 3.6668E-04,
     &   3.6668E-04, 3.6668E-04, 3.6668E-04, 3.6668E-04, 3.6668E-04,
     &   3.6667E-04, 3.6667E-04, 3.6667E-04, 3.6667E-04, 3.6667E-04,
     &   3.6667E-04, 3.6667E-04, 3.6667E-04, 3.6666E-04, 3.6666E-04,
     &   3.6666E-04, 3.6666E-04, 3.6666E-04, 3.6666E-04, 3.6666E-04,
     &   3.6665E-04, 3.6665E-04, 3.6665E-04, 3.6665E-04, 3.6665E-04,
     &   3.6665E-04, 3.6664E-04, 3.6664E-04, 3.6664E-04, 3.6664E-04,
     &   3.6664E-04, 3.6663E-04, 3.6663E-04, 3.6663E-04, 3.6663E-04,
     &   3.6662E-04, 3.6662E-04, 3.6662E-04, 3.6662E-04, 3.6661E-04,
     &   3.6661E-04, 3.6661E-04, 3.6660E-04, 3.6660E-04, 3.6659E-04,
     &   3.6659E-04, 3.6658E-04, 3.6658E-04, 3.6657E-04, 3.6657E-04,
     &   3.6656E-04, 3.6655E-04, 3.6655E-04, 3.6654E-04, 3.6653E-04,
     &   3.6652E-04, 3.6651E-04, 3.6650E-04, 3.6648E-04, 3.6647E-04,
     &   3.6645E-04, 3.6643E-04, 3.6641E-04, 3.6639E-04, 3.6636E-04,
     &   3.6632E-04, 3.6628E-04, 3.6623E-04, 3.6616E-04, 3.6608E-04,
     &   3.6598E-04, 3.6597E-04, 3.6595E-04, 3.6594E-04, 3.6593E-04,
     &   3.6591E-04, 3.6590E-04, 3.6589E-04, 3.6587E-04, 3.6586E-04/
  
         DATA ((DGT (I,J), I= 101, 200), J=2,2) /
     &   3.6584E-04, 3.6582E-04, 3.6581E-04, 3.6579E-04, 3.6577E-04,
     &   3.6575E-04, 3.6573E-04, 3.6571E-04, 3.6569E-04, 3.6567E-04,
     &   3.6565E-04, 3.6563E-04, 3.6560E-04, 3.6558E-04, 3.6555E-04,
     &   3.6552E-04, 3.6550E-04, 3.6547E-04, 3.6544E-04, 3.6541E-04,
     &   3.6538E-04, 3.6534E-04, 3.6531E-04, 3.6527E-04, 3.6523E-04,
     &   3.6519E-04, 3.6515E-04, 3.6511E-04, 3.6506E-04, 3.6501E-04,
     &   3.6496E-04, 3.6491E-04, 3.6486E-04, 3.6480E-04, 3.6474E-04,
     &   3.6467E-04, 3.6461E-04, 3.6454E-04, 3.6446E-04, 3.6438E-04,
     &   3.6430E-04, 3.6421E-04, 3.6412E-04, 3.6402E-04, 3.6391E-04,
     &   3.6380E-04, 3.6368E-04, 3.6356E-04, 3.6342E-04, 3.6328E-04,
     &   3.6312E-04, 3.6296E-04, 3.6278E-04, 3.6259E-04, 3.6239E-04,
     &   3.6217E-04, 3.6193E-04, 3.6167E-04, 3.6139E-04, 3.6109E-04,
     &   3.6076E-04, 3.6040E-04, 3.6000E-04, 3.5957E-04, 3.5910E-04,
     &   3.5857E-04, 3.5799E-04, 3.5735E-04, 3.5664E-04, 3.5584E-04,
     &   3.5495E-04, 3.5395E-04, 3.5282E-04, 3.5153E-04, 3.5007E-04,
     &   3.4838E-04, 3.4644E-04, 3.4417E-04, 3.4150E-04, 3.3832E-04,
     &   3.3447E-04, 3.3408E-04, 3.3369E-04, 3.3329E-04, 3.3288E-04,
     &   3.3246E-04, 3.3204E-04, 3.3160E-04, 3.3116E-04, 3.3071E-04,
     &   3.3025E-04, 3.2978E-04, 3.2930E-04, 3.2881E-04, 3.2831E-04,
     &   3.2780E-04, 3.2728E-04, 3.2674E-04, 3.2620E-04, 3.2564E-04/
  
         DATA ((DGT (I,J), I= 201, 300), J=2,2) /
     &   3.2507E-04, 3.2448E-04, 3.2389E-04, 3.2327E-04, 3.2265E-04,
     &   3.2201E-04, 3.2135E-04, 3.2068E-04, 3.1999E-04, 3.1928E-04,
     &   3.1856E-04, 3.1782E-04, 3.1705E-04, 3.1627E-04, 3.1547E-04,
     &   3.1464E-04, 3.1380E-04, 3.1293E-04, 3.1203E-04, 3.1111E-04,
     &   3.1016E-04, 3.0919E-04, 3.0819E-04, 3.0716E-04, 3.0610E-04,
     &   3.0500E-04, 3.0387E-04, 3.0271E-04, 3.0151E-04, 3.0027E-04,
     &   2.9899E-04, 2.9767E-04, 2.9631E-04, 2.9490E-04, 2.9344E-04,
     &   2.9193E-04, 2.9037E-04, 2.8875E-04, 2.8708E-04, 2.8534E-04,
     &   2.8354E-04, 2.8167E-04, 2.7973E-04, 2.7772E-04, 2.7562E-04,
     &   2.7345E-04, 2.7118E-04, 2.6882E-04, 2.6637E-04, 2.6381E-04,
     &   2.6114E-04, 2.5835E-04, 2.5545E-04, 2.5241E-04, 2.4923E-04,
     &   2.4590E-04, 2.4242E-04, 2.3877E-04, 2.3495E-04, 2.3094E-04,
     &   2.2673E-04, 2.2231E-04, 2.1766E-04, 2.1278E-04, 2.0764E-04,
     &   2.0224E-04, 1.9656E-04, 1.9059E-04, 1.8430E-04, 1.7768E-04,
     &   1.7073E-04, 1.6343E-04, 1.5578E-04, 1.4776E-04, 1.3937E-04,
     &   1.3063E-04, 1.2155E-04, 1.1213E-04, 1.0243E-04, 9.2487E-05,
     &   8.2361E-05, 8.1341E-05, 8.0321E-05, 7.9299E-05, 7.8277E-05,
     &   7.7255E-05, 7.6231E-05, 7.5208E-05, 7.4184E-05, 7.3160E-05,
     &   7.2135E-05, 7.1111E-05, 7.0087E-05, 6.9063E-05, 6.8039E-05,
     &   6.7016E-05, 6.5994E-05, 6.4972E-05, 6.3951E-05, 6.2931E-05/
  
         DATA ((DGT (I,J), I= 301, 400), J=2,2) /
     &   6.1912E-05, 6.0895E-05, 5.9879E-05, 5.8864E-05, 5.7851E-05,
     &   5.6840E-05, 5.5831E-05, 5.4824E-05, 5.3819E-05, 5.2817E-05,
     &   5.1817E-05, 5.0820E-05, 4.9826E-05, 4.8836E-05, 4.7848E-05,
     &   4.6864E-05, 4.5884E-05, 4.4907E-05, 4.3935E-05, 4.2966E-05,
     &   4.2002E-05, 4.1043E-05, 4.0089E-05, 3.9139E-05, 3.8195E-05,
     &   3.7256E-05, 3.6322E-05, 3.5395E-05, 3.4474E-05, 3.3558E-05,
     &   3.2650E-05, 3.1748E-05, 3.0853E-05, 2.9965E-05, 2.9085E-05,
     &   2.8212E-05, 2.7347E-05, 2.6491E-05, 2.5643E-05, 2.4803E-05,
     &   2.3973E-05, 2.3151E-05, 2.2339E-05, 2.1537E-05, 2.0745E-05,
     &   1.9963E-05, 1.9192E-05, 1.8431E-05, 1.7682E-05, 1.6944E-05,
     &   1.6218E-05, 1.5503E-05, 1.4801E-05, 1.4111E-05, 1.3435E-05,
     &   1.2771E-05, 1.2121E-05, 1.1484E-05, 1.0862E-05, 1.0254E-05,
     &   9.6601E-06, 9.0815E-06, 8.5180E-06, 7.9701E-06, 7.4379E-06,
     &   6.9218E-06, 6.4221E-06, 5.9391E-06, 5.4730E-06, 5.0242E-06,
     &   4.5929E-06, 4.1794E-06, 3.7839E-06, 3.4068E-06, 3.0482E-06,
     &   2.7085E-06, 2.3878E-06, 2.0865E-06, 1.8047E-06, 1.5427E-06,
     &   1.3006E-06, 1.2775E-06, 1.2546E-06, 1.2319E-06, 1.2094E-06,
     &   1.1871E-06, 1.1650E-06, 1.1431E-06, 1.1214E-06, 1.1000E-06,
     &   1.0787E-06, 1.0576E-06, 1.0367E-06, 1.0161E-06, 9.9560E-07,
     &   9.7534E-07, 9.5528E-07, 9.3543E-07, 9.1578E-07, 8.9633E-07/
  
         DATA ((DGT (I,J), I= 401, 500), J=2,2) /
     &   8.7709E-07, 8.5806E-07, 8.3923E-07, 8.2061E-07, 8.0219E-07,
     &   7.8398E-07, 7.6597E-07, 7.4817E-07, 7.3057E-07, 7.1319E-07,
     &   6.9600E-07, 6.7903E-07, 6.6226E-07, 6.4570E-07, 6.2934E-07,
     &   6.1319E-07, 5.9725E-07, 5.8152E-07, 5.6599E-07, 5.5068E-07,
     &   5.3557E-07, 5.2066E-07, 5.0597E-07, 4.9148E-07, 4.7720E-07,
     &   4.6313E-07, 4.4927E-07, 4.3562E-07, 4.2218E-07, 4.0894E-07,
     &   3.9592E-07, 3.8310E-07, 3.7049E-07, 3.5809E-07, 3.4590E-07,
     &   3.3393E-07, 3.2216E-07, 3.1060E-07, 2.9925E-07, 2.8811E-07,
     &   2.7718E-07, 2.6646E-07, 2.5595E-07, 2.4565E-07, 2.3556E-07,
     &   2.2568E-07, 2.1601E-07, 2.0656E-07, 1.9731E-07, 1.8827E-07,
     &   1.7945E-07, 1.7084E-07, 1.6243E-07, 1.5424E-07, 1.4626E-07,
     &   1.3849E-07, 1.3094E-07, 1.2359E-07, 1.1646E-07, 1.0953E-07,
     &   1.0282E-07, 9.6323E-08, 9.0036E-08, 8.3960E-08, 7.8096E-08,
     &   7.2444E-08, 6.7004E-08, 6.1776E-08, 5.6760E-08, 5.1956E-08,
     &   4.7364E-08, 4.2985E-08, 3.8817E-08, 3.4862E-08, 3.1120E-08,
     &   2.7589E-08, 2.4271E-08, 2.1166E-08, 1.8272E-08, 1.5592E-08,
     &   1.3123E-08, 1.2888E-08, 1.2655E-08, 1.2424E-08, 1.2196E-08,
     &   1.1969E-08, 1.1745E-08, 1.1522E-08, 1.1302E-08, 1.1084E-08,
     &   1.0868E-08, 1.0654E-08, 1.0442E-08, 1.0232E-08, 1.0025E-08,
     &   9.8196E-09, 9.6163E-09, 9.4152E-09, 9.2161E-09, 9.0193E-09/
  
         DATA ((DGT (I,J), I= 501, 600), J=2,2) /
     &   8.8245E-09, 8.6319E-09, 8.4414E-09, 8.2530E-09, 8.0667E-09,
     &   7.8826E-09, 7.7006E-09, 7.5207E-09, 7.3429E-09, 7.1673E-09,
     &   6.9938E-09, 6.8224E-09, 6.6532E-09, 6.4860E-09, 6.3210E-09,
     &   6.1582E-09, 5.9974E-09, 5.8388E-09, 5.6823E-09, 5.5279E-09,
     &   5.3757E-09, 5.2256E-09, 5.0776E-09, 4.9317E-09, 4.7879E-09,
     &   4.6463E-09, 4.5068E-09, 4.3695E-09, 4.2342E-09, 4.1011E-09,
     &   3.9701E-09, 3.8412E-09, 3.7145E-09, 3.5899E-09, 3.4674E-09,
     &   3.3470E-09, 3.2288E-09, 3.1127E-09, 2.9987E-09, 2.8869E-09,
     &   2.7771E-09, 2.6695E-09, 2.5640E-09, 2.4607E-09, 2.3595E-09,
     &   2.2604E-09, 2.1634E-09, 2.0685E-09, 1.9758E-09, 1.8852E-09,
     &   1.7967E-09, 1.7104E-09, 1.6262E-09, 1.5441E-09, 1.4641E-09,
     &   1.3863E-09, 1.3106E-09, 1.2370E-09, 1.1655E-09, 1.0962E-09,
     &   1.0290E-09, 9.6388E-10, 9.0093E-10, 8.4009E-10, 7.8139E-10,
     &   7.2481E-10, 6.7035E-10, 6.1803E-10, 5.6782E-10, 5.1975E-10,
     &   4.7380E-10, 4.2998E-10, 3.8828E-10, 3.4871E-10, 3.1126E-10,
     &   2.7595E-10, 2.4275E-10, 2.1169E-10, 1.8275E-10, 1.5593E-10,
     &   1.3125E-10, 1.2890E-10, 1.2656E-10, 1.2426E-10, 1.2197E-10,
     &   1.1970E-10, 1.1745E-10, 1.1523E-10, 1.1303E-10, 1.1085E-10,
     &   1.0869E-10, 1.0655E-10, 1.0443E-10, 1.0233E-10, 1.0026E-10,
     &   9.8202E-11, 9.6169E-11, 9.4158E-11, 9.2167E-11, 9.0198E-11/
  
         DATA ((DGT (I,J), I= 601, 700), J=2,2) /
     &   8.8250E-11, 8.6324E-11, 8.4419E-11, 8.2535E-11, 8.0672E-11,
     &   7.8830E-11, 7.7010E-11, 7.5211E-11, 7.3433E-11, 7.1677E-11,
     &   6.9942E-11, 6.8228E-11, 6.6535E-11, 6.4863E-11, 6.3213E-11,
     &   6.1584E-11, 5.9977E-11, 5.8390E-11, 5.6825E-11, 5.5281E-11,
     &   5.3759E-11, 5.2257E-11, 5.0777E-11, 4.9319E-11, 4.7881E-11,
     &   4.6465E-11, 4.5070E-11, 4.3696E-11, 4.2343E-11, 4.1012E-11,
     &   3.9702E-11, 3.8414E-11, 3.7146E-11, 3.5900E-11, 3.4675E-11,
     &   3.3471E-11, 3.2289E-11, 3.1128E-11, 2.9988E-11, 2.8869E-11,
     &   2.7772E-11, 2.6696E-11, 2.5641E-11, 2.4607E-11, 2.3595E-11,
     &   2.2604E-11, 2.1634E-11, 2.0686E-11, 1.9758E-11, 1.8852E-11,
     &   1.7968E-11, 1.7104E-11, 1.6262E-11, 1.5441E-11, 1.4641E-11,
     &   1.3863E-11, 1.3106E-11, 1.2370E-11, 1.1655E-11, 1.0962E-11,
     &   1.0290E-11, 9.6389E-12, 9.0093E-12, 8.4010E-12, 7.8139E-12,
     &   7.2481E-12, 6.7036E-12, 6.1803E-12, 5.6783E-12, 5.1975E-12,
     &   4.7380E-12, 4.2998E-12, 3.8828E-12, 3.4871E-12, 3.1127E-12,
     &   2.7595E-12, 2.4275E-12, 2.1169E-12, 1.8275E-12, 1.5593E-12,
     &   1.3125E-12, 1.2890E-12, 1.2656E-12, 1.2426E-12, 1.2197E-12,
     &   1.1970E-12, 1.1746E-12, 1.1523E-12, 1.1303E-12, 1.1085E-12,
     &   1.0869E-12, 1.0655E-12, 1.0443E-12, 1.0233E-12, 1.0026E-12,
     &   9.8202E-13, 9.6169E-13, 9.4158E-13, 9.2167E-13, 9.0198E-13/
  
         DATA ((DGT (I,J), I= 701, 800), J=2,2) /
     &   8.8251E-13, 8.6324E-13, 8.4419E-13, 8.2535E-13, 8.0672E-13,
     &   7.8830E-13, 7.7010E-13, 7.5211E-13, 7.3433E-13, 7.1677E-13,
     &   6.9942E-13, 6.8228E-13, 6.6535E-13, 6.4863E-13, 6.3213E-13,
     &   6.1584E-13, 5.9977E-13, 5.8390E-13, 5.6825E-13, 5.5281E-13,
     &   5.3759E-13, 5.2257E-13, 5.0777E-13, 4.9319E-13, 4.7881E-13,
     &   4.6465E-13, 4.5070E-13, 4.3696E-13, 4.2343E-13, 4.1012E-13,
     &   3.9702E-13, 3.8414E-13, 3.7146E-13, 3.5900E-13, 3.4675E-13,
     &   3.3471E-13, 3.2289E-13, 3.1128E-13, 2.9988E-13, 2.8869E-13,
     &   2.7772E-13, 2.6696E-13, 2.5641E-13, 2.4607E-13, 2.3595E-13,
     &   2.2604E-13, 2.1634E-13, 2.0686E-13, 1.9758E-13, 1.8852E-13,
     &   1.7968E-13, 1.7104E-13, 1.6262E-13, 1.5441E-13, 1.4641E-13,
     &   1.3863E-13, 1.3106E-13, 1.2370E-13, 1.1655E-13, 1.0962E-13,
     &   1.0290E-13, 9.6389E-14, 9.0093E-14, 8.4010E-14, 7.8139E-14,
     &   7.2481E-14, 6.7036E-14, 6.1803E-14, 5.6783E-14, 5.1975E-14,
     &   4.7380E-14, 4.2998E-14, 3.8828E-14, 3.4871E-14, 3.1127E-14,
     &   2.7595E-14, 2.4275E-14, 2.1169E-14, 1.8275E-14, 1.5593E-14,
     &   1.3125E-14, 1.2890E-14, 1.2656E-14, 1.2426E-14, 1.2197E-14,
     &   1.1970E-14, 1.1746E-14, 1.1523E-14, 1.1303E-14, 1.1085E-14,
     &   1.0869E-14, 1.0655E-14, 1.0443E-14, 1.0233E-14, 1.0026E-14,
     &   9.8202E-15, 9.6169E-15, 9.4158E-15, 9.2167E-15, 9.0198E-15/
  
         DATA ((DGT (I,J), I= 801, 900), J=2,2) /
     &   8.8251E-15, 8.6324E-15, 8.4419E-15, 8.2535E-15, 8.0672E-15,
     &   7.8830E-15, 7.7010E-15, 7.5211E-15, 7.3433E-15, 7.1677E-15,
     &   6.9942E-15, 6.8228E-15, 6.6535E-15, 6.4863E-15, 6.3213E-15,
     &   6.1584E-15, 5.9977E-15, 5.8390E-15, 5.6825E-15, 5.5281E-15,
     &   5.3759E-15, 5.2257E-15, 5.0777E-15, 4.9319E-15, 4.7881E-15,
     &   4.6465E-15, 4.5070E-15, 4.3696E-15, 4.2343E-15, 4.1012E-15,
     &   3.9702E-15, 3.8414E-15, 3.7146E-15, 3.5900E-15, 3.4675E-15,
     &   3.3471E-15, 3.2289E-15, 3.1128E-15, 2.9988E-15, 2.8869E-15,
     &   2.7772E-15, 2.6696E-15, 2.5641E-15, 2.4607E-15, 2.3595E-15,
     &   2.2604E-15, 2.1634E-15, 2.0686E-15, 1.9758E-15, 1.8852E-15,
     &   1.7968E-15, 1.7104E-15, 1.6262E-15, 1.5441E-15, 1.4641E-15,
     &   1.3863E-15, 1.3106E-15, 1.2370E-15, 1.1655E-15, 1.0962E-15,
     &   1.0290E-15, 9.6389E-16, 9.0093E-16, 8.4010E-16, 7.8139E-16,
     &   7.2481E-16, 6.7036E-16, 6.1803E-16, 5.6783E-16, 5.1975E-16,
     &   4.7380E-16, 4.2998E-16, 3.8828E-16, 3.4871E-16, 3.1127E-16,
     &   2.7595E-16, 2.4275E-16, 2.1169E-16, 1.8275E-16, 1.5593E-16,
     &   1.3125E-16, 0.0000E+00, 1.3125E-16, 1.1820E-09, 4.7266E-09,
     &   1.0634E-08, 1.8902E-08, 2.9537E-08, 4.2537E-08, 5.7904E-08,
     &   7.5639E-08, 9.5744E-08, 1.1822E-07, 1.4307E-07, 1.7030E-07,
     &   1.9991E-07, 2.3190E-07, 2.6628E-07, 3.0305E-07, 3.4221E-07/
  
         DATA ((DGT (I,J), I= 901, 979), J=2,2) /
     &   3.8376E-07, 4.2772E-07, 4.7409E-07, 5.2286E-07, 5.7406E-07,
     &   6.2767E-07, 6.8371E-07, 7.4219E-07, 8.0311E-07, 8.6647E-07,
     &   9.3228E-07, 1.0006E-06, 1.0713E-06, 1.1445E-06, 1.2202E-06,
     &   1.2984E-06, 1.3791E-06, 1.4623E-06, 1.5481E-06, 1.6363E-06,
     &   1.7271E-06, 1.8205E-06, 1.9164E-06, 2.0149E-06, 2.1160E-06,
     &   2.2197E-06, 2.3260E-06, 2.4349E-06, 2.5465E-06, 2.6607E-06,
     &   2.7776E-06, 2.8972E-06, 3.0195E-06, 3.1446E-06, 3.2723E-06,
     &   3.4029E-06, 3.5362E-06, 3.6723E-06, 3.8112E-06, 3.9530E-06,
     &   4.0977E-06, 4.2452E-06, 4.3957E-06, 4.5491E-06, 4.7056E-06,
     &   4.8650E-06, 5.0274E-06, 5.1930E-06, 5.3616E-06, 5.5335E-06,
     &   5.7085E-06, 5.8867E-06, 6.0682E-06, 6.2531E-06, 6.4413E-06,
     &   6.6330E-06, 6.8281E-06, 7.0269E-06, 7.2293E-06, 7.4354E-06,
     &   7.6453E-06, 7.8591E-06, 8.0769E-06, 8.2988E-06, 8.5250E-06,
     &   8.7555E-06, 8.9906E-06, 9.2305E-06, 9.4752E-06, 9.7252E-06,
     &   9.9807E-06, 1.0242E-05, 1.0510E-05, 1.0600E-05, 1.0784E-05,
     &   1.08491404E-05, 1.10660940E-05, 1.10947633E-05, 1.11620111E-05/

c ******************************************************************************
c *                                                                            *
c *    --- intRdat1 ---                              Fri Mar 30 14:05:33 2012  *
c *                                                                            *
c ***************************# FJ@HU Berlin #***********************************
c 
c   "Delta alpha"               Update version (17/03/2012) 
c
c  ISCAN: *, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c  IKE,Emin,Emax,NP,N,EPSREL: 1, 9.1188E+01, 9.1188E+01,   1, 10, 1.00E-02, 
c  ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c  NF,IOR,ICHK: 5,4,2,ISU2: 4,NFL: 5,INAG: 1, sin2W:   0.23153
c  CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c
c replaced March 30, 2012 [dalhads.dat;431]
  
         DATA ((DGT3(I,J), I=   1, 100), J=1,1) /
     &   4.4104E-02, 4.4047E-02, 4.3990E-02, 4.3932E-02, 4.3873E-02,
     &   4.3813E-02, 4.3753E-02, 4.3692E-02, 4.3631E-02, 4.3568E-02,
     &   4.3505E-02, 4.3441E-02, 4.3377E-02, 4.3311E-02, 4.3245E-02,
     &   4.3178E-02, 4.3109E-02, 4.3040E-02, 4.2971E-02, 4.2900E-02,
     &   4.2828E-02, 4.2755E-02, 4.2681E-02, 4.2606E-02, 4.2530E-02,
     &   4.2452E-02, 4.2374E-02, 4.2294E-02, 4.2214E-02, 4.2132E-02,
     &   4.2048E-02, 4.1963E-02, 4.1877E-02, 4.1790E-02, 4.1701E-02,
     &   4.1610E-02, 4.1518E-02, 4.1424E-02, 4.1329E-02, 4.1232E-02,
     &   4.1133E-02, 4.1032E-02, 4.0930E-02, 4.0825E-02, 4.0718E-02,
     &   4.0610E-02, 4.0499E-02, 4.0385E-02, 4.0270E-02, 4.0152E-02,
     &   4.0031E-02, 3.9907E-02, 3.9781E-02, 3.9652E-02, 3.9520E-02,
     &   3.9385E-02, 3.9246E-02, 3.9104E-02, 3.8959E-02, 3.8810E-02,
     &   3.8656E-02, 3.8499E-02, 3.8337E-02, 3.8170E-02, 3.7999E-02,
     &   3.7822E-02, 3.7640E-02, 3.7453E-02, 3.7259E-02, 3.7058E-02,
     &   3.6851E-02, 3.6637E-02, 3.6414E-02, 3.6183E-02, 3.5943E-02,
     &   3.5693E-02, 3.5433E-02, 3.5161E-02, 3.4877E-02, 3.4578E-02,
     &   3.4265E-02, 3.3936E-02, 3.3588E-02, 3.3220E-02, 3.2829E-02,
     &   3.2412E-02, 3.1966E-02, 3.1487E-02, 3.0968E-02, 3.0404E-02,
     &   2.9786E-02, 2.9720E-02, 2.9654E-02, 2.9588E-02, 2.9520E-02,
     &   2.9452E-02, 2.9384E-02, 2.9314E-02, 2.9244E-02, 2.9173E-02/
  
         DATA ((DGT3(I,J), I= 101, 200), J=1,1) /
     &   2.9101E-02, 2.9029E-02, 2.8955E-02, 2.8881E-02, 2.8806E-02,
     &   2.8730E-02, 2.8653E-02, 2.8575E-02, 2.8496E-02, 2.8416E-02,
     &   2.8335E-02, 2.8253E-02, 2.8171E-02, 2.8087E-02, 2.8002E-02,
     &   2.7915E-02, 2.7828E-02, 2.7739E-02, 2.7650E-02, 2.7559E-02,
     &   2.7466E-02, 2.7373E-02, 2.7278E-02, 2.7181E-02, 2.7083E-02,
     &   2.6984E-02, 2.6883E-02, 2.6780E-02, 2.6676E-02, 2.6570E-02,
     &   2.6463E-02, 2.6353E-02, 2.6242E-02, 2.6129E-02, 2.6013E-02,
     &   2.5896E-02, 2.5776E-02, 2.5655E-02, 2.5531E-02, 2.5404E-02,
     &   2.5275E-02, 2.5144E-02, 2.5009E-02, 2.4872E-02, 2.4732E-02,
     &   2.4589E-02, 2.4443E-02, 2.4293E-02, 2.4140E-02, 2.3983E-02,
     &   2.3823E-02, 2.3658E-02, 2.3489E-02, 2.3316E-02, 2.3137E-02,
     &   2.2954E-02, 2.2766E-02, 2.2572E-02, 2.2373E-02, 2.2167E-02,
     &   2.1954E-02, 2.1735E-02, 2.1507E-02, 2.1272E-02, 2.1028E-02,
     &   2.0775E-02, 2.0512E-02, 2.0238E-02, 1.9953E-02, 1.9655E-02,
     &   1.9342E-02, 1.9015E-02, 1.8671E-02, 1.8309E-02, 1.7926E-02,
     &   1.7520E-02, 1.7089E-02, 1.6628E-02, 1.6135E-02, 1.5603E-02,
     &   1.5026E-02, 1.4972E-02, 1.4917E-02, 1.4862E-02, 1.4806E-02,
     &   1.4750E-02, 1.4694E-02, 1.4636E-02, 1.4579E-02, 1.4521E-02,
     &   1.4462E-02, 1.4403E-02, 1.4344E-02, 1.4284E-02, 1.4223E-02,
     &   1.4162E-02, 1.4101E-02, 1.4038E-02, 1.3976E-02, 1.3912E-02/
  
         DATA ((DGT3(I,J), I= 201, 300), J=1,1) /
     &   1.3848E-02, 1.3784E-02, 1.3719E-02, 1.3653E-02, 1.3586E-02,
     &   1.3519E-02, 1.3451E-02, 1.3383E-02, 1.3314E-02, 1.3244E-02,
     &   1.3173E-02, 1.3102E-02, 1.3030E-02, 1.2957E-02, 1.2883E-02,
     &   1.2809E-02, 1.2734E-02, 1.2657E-02, 1.2580E-02, 1.2503E-02,
     &   1.2424E-02, 1.2344E-02, 1.2263E-02, 1.2182E-02, 1.2099E-02,
     &   1.2015E-02, 1.1930E-02, 1.1845E-02, 1.1758E-02, 1.1669E-02,
     &   1.1580E-02, 1.1489E-02, 1.1398E-02, 1.1305E-02, 1.1210E-02,
     &   1.1114E-02, 1.1017E-02, 1.0919E-02, 1.0818E-02, 1.0717E-02,
     &   1.0613E-02, 1.0508E-02, 1.0402E-02, 1.0293E-02, 1.0183E-02,
     &   1.0071E-02, 9.9567E-03, 9.8405E-03, 9.7222E-03, 9.6016E-03,
     &   9.4788E-03, 9.3536E-03, 9.2259E-03, 9.0955E-03, 8.9625E-03,
     &   8.8266E-03, 8.6882E-03, 8.5462E-03, 8.4010E-03, 8.2523E-03,
     &   8.1000E-03, 7.9438E-03, 7.7836E-03, 7.6190E-03, 7.4490E-03,
     &   7.2751E-03, 7.0960E-03, 6.9113E-03, 6.7205E-03, 6.5233E-03,
     &   6.3191E-03, 6.1073E-03, 5.8872E-03, 5.6581E-03, 5.4190E-03,
     &   5.1690E-03, 4.9069E-03, 4.6315E-03, 4.3415E-03, 4.0354E-03,
     &   3.7119E-03, 3.6785E-03, 3.6449E-03, 3.6112E-03, 3.5773E-03,
     &   3.5431E-03, 3.5088E-03, 3.4743E-03, 3.4396E-03, 3.4047E-03,
     &   3.3696E-03, 3.3343E-03, 3.2988E-03, 3.2631E-03, 3.2273E-03,
     &   3.1912E-03, 3.1549E-03, 3.1184E-03, 3.0818E-03, 3.0449E-03/
  
         DATA ((DGT3(I,J), I= 301, 400), J=1,1) /
     &   3.0078E-03, 2.9706E-03, 2.9332E-03, 2.8955E-03, 2.8577E-03,
     &   2.8197E-03, 2.7814E-03, 2.7431E-03, 2.7045E-03, 2.6657E-03,
     &   2.6268E-03, 2.5876E-03, 2.5483E-03, 2.5089E-03, 2.4692E-03,
     &   2.4294E-03, 2.3894E-03, 2.3493E-03, 2.3090E-03, 2.2686E-03,
     &   2.2280E-03, 2.1873E-03, 2.1465E-03, 2.1056E-03, 2.0644E-03,
     &   2.0232E-03, 1.9819E-03, 1.9406E-03, 1.8991E-03, 1.8576E-03,
     &   1.8161E-03, 1.7744E-03, 1.7328E-03, 1.6911E-03, 1.6494E-03,
     &   1.6076E-03, 1.5660E-03, 1.5243E-03, 1.4826E-03, 1.4411E-03,
     &   1.3996E-03, 1.3582E-03, 1.3169E-03, 1.2757E-03, 1.2347E-03,
     &   1.1939E-03, 1.1533E-03, 1.1128E-03, 1.0726E-03, 1.0327E-03,
     &   9.9300E-04, 9.5365E-04, 9.1463E-04, 8.7598E-04, 8.3773E-04,
     &   7.9990E-04, 7.6252E-04, 7.2562E-04, 6.8924E-04, 6.5341E-04,
     &   6.1815E-04, 5.8350E-04, 5.4952E-04, 5.1620E-04, 4.8334E-04,
     &   4.5151E-04, 4.2047E-04, 3.9025E-04, 3.6089E-04, 3.3242E-04,
     &   3.0488E-04, 2.7831E-04, 2.5275E-04, 2.2823E-04, 2.0478E-04,
     &   1.8245E-04, 1.6126E-04, 1.4125E-04, 1.2245E-04, 1.0489E-04,
     &   8.8604E-05, 8.7047E-05, 8.5502E-05, 8.3971E-05, 8.2452E-05,
     &   8.0947E-05, 7.9455E-05, 7.7976E-05, 7.6510E-05, 7.5058E-05,
     &   7.3618E-05, 7.2192E-05, 7.0780E-05, 6.9380E-05, 6.7994E-05,
     &   6.6621E-05, 6.5262E-05, 6.3916E-05, 6.2583E-05, 6.1264E-05/
  
         DATA ((DGT3(I,J), I= 401, 500), J=1,1) /
     &   5.9959E-05, 5.8667E-05, 5.7388E-05, 5.6123E-05, 5.4872E-05,
     &   5.3634E-05, 5.2410E-05, 5.1199E-05, 5.0003E-05, 4.8819E-05,
     &   4.7650E-05, 4.6494E-05, 4.5352E-05, 4.4224E-05, 4.3110E-05,
     &   4.2009E-05, 4.0922E-05, 3.9850E-05, 3.8791E-05, 3.7746E-05,
     &   3.6714E-05, 3.5697E-05, 3.4694E-05, 3.3705E-05, 3.2729E-05,
     &   3.1768E-05, 3.0821E-05, 2.9887E-05, 2.8968E-05, 2.8063E-05,
     &   2.7172E-05, 2.6295E-05, 2.5433E-05, 2.4584E-05, 2.3750E-05,
     &   2.2930E-05, 2.2123E-05, 2.1332E-05, 2.0554E-05, 1.9791E-05,
     &   1.9042E-05, 1.8307E-05, 1.7586E-05, 1.6880E-05, 1.6188E-05,
     &   1.5511E-05, 1.4847E-05, 1.4198E-05, 1.3564E-05, 1.2944E-05,
     &   1.2338E-05, 1.1747E-05, 1.1170E-05, 1.0607E-05, 1.0059E-05,
     &   9.5253E-06, 9.0061E-06, 8.5014E-06, 8.0111E-06, 7.5353E-06,
     &   7.0740E-06, 6.6272E-06, 6.1950E-06, 5.7772E-06, 5.3740E-06,
     &   4.9853E-06, 4.6111E-06, 4.2515E-06, 3.9065E-06, 3.5760E-06,
     &   3.2601E-06, 2.9587E-06, 2.6720E-06, 2.3998E-06, 2.1423E-06,
     &   1.8993E-06, 1.6709E-06, 1.4571E-06, 1.2580E-06, 1.0735E-06,
     &   9.0354E-07, 8.8736E-07, 8.7131E-07, 8.5542E-07, 8.3967E-07,
     &   8.2407E-07, 8.0861E-07, 7.9330E-07, 7.7814E-07, 7.6312E-07,
     &   7.4825E-07, 7.3353E-07, 7.1895E-07, 7.0451E-07, 6.9023E-07,
     &   6.7609E-07, 6.6209E-07, 6.4825E-07, 6.3455E-07, 6.2099E-07/
  
         DATA ((DGT3(I,J), I= 501, 600), J=1,1) /
     &   6.0758E-07, 5.9432E-07, 5.8120E-07, 5.6823E-07, 5.5541E-07,
     &   5.4273E-07, 5.3020E-07, 5.1782E-07, 5.0558E-07, 4.9349E-07,
     &   4.8154E-07, 4.6974E-07, 4.5809E-07, 4.4658E-07, 4.3522E-07,
     &   4.2401E-07, 4.1294E-07, 4.0202E-07, 3.9125E-07, 3.8062E-07,
     &   3.7014E-07, 3.5980E-07, 3.4961E-07, 3.3957E-07, 3.2967E-07,
     &   3.1992E-07, 3.1031E-07, 3.0086E-07, 2.9154E-07, 2.8238E-07,
     &   2.7336E-07, 2.6449E-07, 2.5576E-07, 2.4718E-07, 2.3875E-07,
     &   2.3046E-07, 2.2232E-07, 2.1433E-07, 2.0648E-07, 1.9878E-07,
     &   1.9122E-07, 1.8381E-07, 1.7655E-07, 1.6943E-07, 1.6246E-07,
     &   1.5564E-07, 1.4896E-07, 1.4243E-07, 1.3605E-07, 1.2981E-07,
     &   1.2372E-07, 1.1777E-07, 1.1197E-07, 1.0632E-07, 1.0081E-07,
     &   9.5454E-08, 9.0241E-08, 8.5174E-08, 8.0253E-08, 7.5479E-08,
     &   7.0851E-08, 6.6370E-08, 6.2034E-08, 5.7846E-08, 5.3804E-08,
     &   4.9908E-08, 4.6158E-08, 4.2555E-08, 3.9098E-08, 3.5788E-08,
     &   3.2624E-08, 2.9607E-08, 2.6736E-08, 2.4011E-08, 2.1433E-08,
     &   1.9001E-08, 1.6715E-08, 1.4576E-08, 1.2583E-08, 1.0737E-08,
     &   9.0372E-09, 8.8753E-09, 8.7148E-09, 8.5558E-09, 8.3983E-09,
     &   8.2422E-09, 8.0876E-09, 7.9344E-09, 7.7827E-09, 7.6325E-09,
     &   7.4837E-09, 7.3364E-09, 7.1906E-09, 7.0462E-09, 6.9033E-09,
     &   6.7619E-09, 6.6219E-09, 6.4834E-09, 6.3464E-09, 6.2108E-09/
  
         DATA ((DGT3(I,J), I= 601, 700), J=1,1) /
     &   6.0766E-09, 5.9440E-09, 5.8128E-09, 5.6831E-09, 5.5548E-09,
     &   5.4280E-09, 5.3027E-09, 5.1788E-09, 5.0564E-09, 4.9354E-09,
     &   4.8160E-09, 4.6979E-09, 4.5814E-09, 4.4663E-09, 4.3527E-09,
     &   4.2405E-09, 4.1298E-09, 4.0206E-09, 3.9128E-09, 3.8065E-09,
     &   3.7017E-09, 3.5983E-09, 3.4964E-09, 3.3959E-09, 3.2969E-09,
     &   3.1994E-09, 3.1034E-09, 3.0088E-09, 2.9156E-09, 2.8240E-09,
     &   2.7338E-09, 2.6450E-09, 2.5578E-09, 2.4720E-09, 2.3876E-09,
     &   2.3047E-09, 2.2233E-09, 2.1434E-09, 2.0649E-09, 1.9878E-09,
     &   1.9123E-09, 1.8382E-09, 1.7656E-09, 1.6944E-09, 1.6247E-09,
     &   1.5564E-09, 1.4897E-09, 1.4244E-09, 1.3605E-09, 1.2981E-09,
     &   1.2372E-09, 1.1777E-09, 1.1198E-09, 1.0632E-09, 1.0082E-09,
     &   9.5456E-10, 9.0242E-10, 8.5175E-10, 8.0254E-10, 7.5480E-10,
     &   7.0852E-10, 6.6371E-10, 6.2035E-10, 5.7847E-10, 5.3804E-10,
     &   4.9908E-10, 4.6159E-10, 4.2556E-10, 3.9099E-10, 3.5788E-10,
     &   3.2625E-10, 2.9607E-10, 2.6736E-10, 2.4011E-10, 2.1433E-10,
     &   1.9001E-10, 1.6715E-10, 1.4576E-10, 1.2583E-10, 1.0737E-10,
     &   9.0373E-11, 8.8753E-11, 8.7148E-11, 8.5558E-11, 8.3983E-11,
     &   8.2422E-11, 8.0876E-11, 7.9344E-11, 7.7827E-11, 7.6325E-11,
     &   7.4838E-11, 7.3365E-11, 7.1906E-11, 7.0463E-11, 6.9033E-11,
     &   6.7619E-11, 6.6219E-11, 6.4834E-11, 6.3464E-11, 6.2108E-11/
  
         DATA ((DGT3(I,J), I= 701, 800), J=1,1) /
     &   6.0767E-11, 5.9440E-11, 5.8128E-11, 5.6831E-11, 5.5548E-11,
     &   5.4280E-11, 5.3027E-11, 5.1788E-11, 5.0564E-11, 4.9354E-11,
     &   4.8160E-11, 4.6979E-11, 4.5814E-11, 4.4663E-11, 4.3527E-11,
     &   4.2405E-11, 4.1298E-11, 4.0206E-11, 3.9128E-11, 3.8065E-11,
     &   3.7017E-11, 3.5983E-11, 3.4964E-11, 3.3959E-11, 3.2969E-11,
     &   3.1994E-11, 3.1034E-11, 3.0088E-11, 2.9156E-11, 2.8240E-11,
     &   2.7338E-11, 2.6450E-11, 2.5578E-11, 2.4720E-11, 2.3876E-11,
     &   2.3047E-11, 2.2233E-11, 2.1434E-11, 2.0649E-11, 1.9878E-11,
     &   1.9123E-11, 1.8382E-11, 1.7656E-11, 1.6944E-11, 1.6247E-11,
     &   1.5564E-11, 1.4897E-11, 1.4244E-11, 1.3605E-11, 1.2981E-11,
     &   1.2372E-11, 1.1777E-11, 1.1198E-11, 1.0632E-11, 1.0082E-11,
     &   9.5456E-12, 9.0242E-12, 8.5175E-12, 8.0254E-12, 7.5480E-12,
     &   7.0852E-12, 6.6371E-12, 6.2035E-12, 5.7847E-12, 5.3804E-12,
     &   4.9908E-12, 4.6159E-12, 4.2556E-12, 3.9099E-12, 3.5788E-12,
     &   3.2625E-12, 2.9607E-12, 2.6736E-12, 2.4011E-12, 2.1433E-12,
     &   1.9001E-12, 1.6715E-12, 1.4576E-12, 1.2583E-12, 1.0737E-12,
     &   9.0373E-13, 8.8753E-13, 8.7148E-13, 8.5558E-13, 8.3983E-13,
     &   8.2422E-13, 8.0876E-13, 7.9344E-13, 7.7827E-13, 7.6325E-13,
     &   7.4838E-13, 7.3365E-13, 7.1906E-13, 7.0463E-13, 6.9033E-13,
     &   6.7619E-13, 6.6219E-13, 6.4834E-13, 6.3464E-13, 6.2108E-13/
  
         DATA ((DGT3(I,J), I= 801, 900), J=1,1) /
     &   6.0767E-13, 5.9440E-13, 5.8128E-13, 5.6831E-13, 5.5548E-13,
     &   5.4280E-13, 5.3027E-13, 5.1788E-13, 5.0564E-13, 4.9354E-13,
     &   4.8160E-13, 4.6979E-13, 4.5814E-13, 4.4663E-13, 4.3527E-13,
     &   4.2405E-13, 4.1298E-13, 4.0206E-13, 3.9128E-13, 3.8065E-13,
     &   3.7017E-13, 3.5983E-13, 3.4964E-13, 3.3959E-13, 3.2969E-13,
     &   3.1994E-13, 3.1034E-13, 3.0088E-13, 2.9156E-13, 2.8240E-13,
     &   2.7338E-13, 2.6450E-13, 2.5578E-13, 2.4720E-13, 2.3876E-13,
     &   2.3047E-13, 2.2233E-13, 2.1434E-13, 2.0649E-13, 1.9878E-13,
     &   1.9123E-13, 1.8382E-13, 1.7656E-13, 1.6944E-13, 1.6247E-13,
     &   1.5564E-13, 1.4897E-13, 1.4244E-13, 1.3605E-13, 1.2981E-13,
     &   1.2372E-13, 1.1777E-13, 1.1198E-13, 1.0632E-13, 1.0082E-13,
     &   9.5456E-14, 9.0242E-14, 8.5175E-14, 8.0254E-14, 7.5480E-14,
     &   7.0852E-14, 6.6371E-14, 6.2035E-14, 5.7847E-14, 5.3804E-14,
     &   4.9908E-14, 4.6159E-14, 4.2556E-14, 3.9099E-14, 3.5788E-14,
     &   3.2625E-14, 2.9607E-14, 2.6736E-14, 2.4011E-14, 2.1433E-14,
     &   1.9001E-14, 1.6715E-14, 1.4576E-14, 1.2583E-14, 1.0737E-14,
     &   9.0373E-15, 0.0000E+00,-9.0373E-15,-8.1391E-08,-3.2547E-07,
     &  -7.3230E-07,-1.3017E-06,-2.0343E-06,-2.9300E-06,-3.9890E-06,
     &  -5.2115E-06,-6.5979E-06,-8.1484E-06,-9.8633E-06,-1.1743E-05,
     &  -1.3788E-05,-1.5999E-05,-1.8376E-05,-2.0920E-05,-2.3631E-05/
  
         DATA ((DGT3(I,J), I= 901, 979), J=1,1) /
     &  -2.6510E-05,-2.9557E-05,-3.2774E-05,-3.6161E-05,-3.9718E-05,
     &  -4.3447E-05,-4.7349E-05,-5.1424E-05,-5.5673E-05,-6.0098E-05,
     &  -6.4699E-05,-6.9477E-05,-7.4434E-05,-7.9571E-05,-8.4889E-05,
     &  -9.0389E-05,-9.6073E-05,-1.0194E-04,-1.0800E-04,-1.1424E-04,
     &  -1.2068E-04,-1.2730E-04,-1.3412E-04,-1.4113E-04,-1.4834E-04,
     &  -1.5575E-04,-1.6336E-04,-1.7118E-04,-1.7920E-04,-1.8742E-04,
     &  -1.9586E-04,-2.0451E-04,-2.1337E-04,-2.2245E-04,-2.3175E-04,
     &  -2.4128E-04,-2.5103E-04,-2.6101E-04,-2.7122E-04,-2.8167E-04,
     &  -2.9236E-04,-3.0329E-04,-3.1447E-04,-3.2591E-04,-3.3760E-04,
     &  -3.4955E-04,-3.6177E-04,-3.7425E-04,-3.8701E-04,-4.0006E-04,
     &  -4.1339E-04,-4.2702E-04,-4.4094E-04,-4.5518E-04,-4.6973E-04,
     &  -4.8460E-04,-4.9980E-04,-5.1535E-04,-5.3124E-04,-5.4750E-04,
     &  -5.6413E-04,-5.8115E-04,-5.9856E-04,-6.1640E-04,-6.3466E-04,
     &  -6.5339E-04,-6.7258E-04,-6.9228E-04,-7.1251E-04,-7.3331E-04,
     &  -7.5473E-04,-7.7681E-04,-7.9964E-04,-8.0743E-04,-8.2357E-04,
     &  -8.29238733E-04,-8.48329189E-04,-8.50878396E-04,-8.56883478E-04/
  
         DATA ((DGT3(I,J), I=   1, 100), J=2,2) /
     &   2.0279E-04, 2.1019E-04, 2.1019E-04, 2.1019E-04, 2.1019E-04,
     &   2.1019E-04, 2.1019E-04, 2.1019E-04, 2.1019E-04, 2.1019E-04,
     &   2.1019E-04, 2.1019E-04, 2.1019E-04, 2.1019E-04, 2.1019E-04,
     &   2.1018E-04, 2.1018E-04, 2.1018E-04, 2.1018E-04, 2.1018E-04,
     &   2.1018E-04, 2.1018E-04, 2.1018E-04, 2.1018E-04, 2.1018E-04,
     &   2.1018E-04, 2.1018E-04, 2.1018E-04, 2.1018E-04, 2.1018E-04,
     &   2.1018E-04, 2.1018E-04, 2.1017E-04, 2.1017E-04, 2.1017E-04,
     &   2.1017E-04, 2.1017E-04, 2.1017E-04, 2.1017E-04, 2.1017E-04,
     &   2.1017E-04, 2.1017E-04, 2.1017E-04, 2.1017E-04, 2.1016E-04,
     &   2.1016E-04, 2.1016E-04, 2.1016E-04, 2.1016E-04, 2.1016E-04,
     &   2.1016E-04, 2.1016E-04, 2.1015E-04, 2.1015E-04, 2.1015E-04,
     &   2.1015E-04, 2.1015E-04, 2.1015E-04, 2.1014E-04, 2.1014E-04,
     &   2.1014E-04, 2.1014E-04, 2.1013E-04, 2.1013E-04, 2.1013E-04,
     &   2.1013E-04, 2.1012E-04, 2.1012E-04, 2.1012E-04, 2.1011E-04,
     &   2.1011E-04, 2.1010E-04, 2.1010E-04, 2.1009E-04, 2.1009E-04,
     &   2.1008E-04, 2.1007E-04, 2.1007E-04, 2.1006E-04, 2.1005E-04,
     &   2.1003E-04, 2.1002E-04, 2.1001E-04, 2.0999E-04, 2.0997E-04,
     &   2.0994E-04, 2.0991E-04, 2.0987E-04, 2.0983E-04, 2.0977E-04,
     &   2.0969E-04, 2.0968E-04, 2.0967E-04, 2.0966E-04, 2.0965E-04,
     &   2.0964E-04, 2.0963E-04, 2.0962E-04, 2.0961E-04, 2.0960E-04/
  
         DATA ((DGT3(I,J), I= 101, 200), J=2,2) /
     &   2.0959E-04, 2.0957E-04, 2.0956E-04, 2.0955E-04, 2.0954E-04,
     &   2.0952E-04, 2.0951E-04, 2.0949E-04, 2.0948E-04, 2.0946E-04,
     &   2.0944E-04, 2.0943E-04, 2.0941E-04, 2.0939E-04, 2.0937E-04,
     &   2.0935E-04, 2.0933E-04, 2.0931E-04, 2.0929E-04, 2.0927E-04,
     &   2.0924E-04, 2.0922E-04, 2.0919E-04, 2.0917E-04, 2.0914E-04,
     &   2.0911E-04, 2.0908E-04, 2.0904E-04, 2.0901E-04, 2.0898E-04,
     &   2.0894E-04, 2.0890E-04, 2.0886E-04, 2.0882E-04, 2.0877E-04,
     &   2.0873E-04, 2.0868E-04, 2.0862E-04, 2.0857E-04, 2.0851E-04,
     &   2.0845E-04, 2.0838E-04, 2.0832E-04, 2.0824E-04, 2.0817E-04,
     &   2.0809E-04, 2.0800E-04, 2.0791E-04, 2.0781E-04, 2.0770E-04,
     &   2.0759E-04, 2.0747E-04, 2.0734E-04, 2.0721E-04, 2.0706E-04,
     &   2.0690E-04, 2.0673E-04, 2.0654E-04, 2.0634E-04, 2.0613E-04,
     &   2.0589E-04, 2.0564E-04, 2.0536E-04, 2.0506E-04, 2.0472E-04,
     &   2.0436E-04, 2.0396E-04, 2.0352E-04, 2.0304E-04, 2.0250E-04,
     &   2.0191E-04, 2.0125E-04, 2.0051E-04, 1.9969E-04, 1.9876E-04,
     &   1.9772E-04, 1.9655E-04, 1.9521E-04, 1.9368E-04, 1.9192E-04,
     &   1.8985E-04, 1.8947E-04, 1.8926E-04, 1.8905E-04, 1.8883E-04,
     &   1.8861E-04, 1.8839E-04, 1.8816E-04, 1.8793E-04, 1.8769E-04,
     &   1.8745E-04, 1.8721E-04, 1.8696E-04, 1.8671E-04, 1.8645E-04,
     &   1.8619E-04, 1.8592E-04, 1.8564E-04, 1.8536E-04, 1.8508E-04/
  
         DATA ((DGT3(I,J), I= 201, 300), J=2,2) /
     &   1.8479E-04, 1.8449E-04, 1.8419E-04, 1.8388E-04, 1.8356E-04,
     &   1.8324E-04, 1.8291E-04, 1.8257E-04, 1.8223E-04, 1.8187E-04,
     &   1.8151E-04, 1.8114E-04, 1.8076E-04, 1.8037E-04, 1.7997E-04,
     &   1.7956E-04, 1.7914E-04, 1.7870E-04, 1.7826E-04, 1.7780E-04,
     &   1.7733E-04, 1.7685E-04, 1.7635E-04, 1.7584E-04, 1.7531E-04,
     &   1.7476E-04, 1.7420E-04, 1.7362E-04, 1.7302E-04, 1.7240E-04,
     &   1.7176E-04, 1.7110E-04, 1.7041E-04, 1.6970E-04, 1.6897E-04,
     &   1.6820E-04, 1.6741E-04, 1.6659E-04, 1.6573E-04, 1.6485E-04,
     &   1.6392E-04, 1.6296E-04, 1.6196E-04, 1.6091E-04, 1.5983E-04,
     &   1.5869E-04, 1.5750E-04, 1.5626E-04, 1.5496E-04, 1.5360E-04,
     &   1.5218E-04, 1.5069E-04, 1.4912E-04, 1.4748E-04, 1.4575E-04,
     &   1.4394E-04, 1.4203E-04, 1.4002E-04, 1.3791E-04, 1.3568E-04,
     &   1.3333E-04, 1.3085E-04, 1.2824E-04, 1.2548E-04, 1.2256E-04,
     &   1.1948E-04, 1.1623E-04, 1.1280E-04, 1.0917E-04, 1.0535E-04,
     &   1.0132E-04, 9.7078E-05, 9.2615E-05, 8.7930E-05, 8.3023E-05,
     &   7.7897E-05, 7.2561E-05, 6.7027E-05, 6.1317E-05, 5.5459E-05,
     &   4.9491E-05, 4.8460E-05, 4.7854E-05, 4.7247E-05, 4.6639E-05,
     &   4.6031E-05, 4.5423E-05, 4.4814E-05, 4.4205E-05, 4.3596E-05,
     &   4.2987E-05, 4.2378E-05, 4.1768E-05, 4.1159E-05, 4.0550E-05,
     &   3.9941E-05, 3.9332E-05, 3.8724E-05, 3.8117E-05, 3.7509E-05/
  
         DATA ((DGT3(I,J), I= 301, 400), J=2,2) /
     &   3.6903E-05, 3.6297E-05, 3.5692E-05, 3.5087E-05, 3.4484E-05,
     &   3.3882E-05, 3.3281E-05, 3.2681E-05, 3.2082E-05, 3.1485E-05,
     &   3.0889E-05, 3.0295E-05, 2.9703E-05, 2.9112E-05, 2.8524E-05,
     &   2.7937E-05, 2.7353E-05, 2.6771E-05, 2.6191E-05, 2.5614E-05,
     &   2.5039E-05, 2.4467E-05, 2.3898E-05, 2.3332E-05, 2.2769E-05,
     &   2.2209E-05, 2.1652E-05, 2.1099E-05, 2.0550E-05, 2.0004E-05,
     &   1.9462E-05, 1.8924E-05, 1.8391E-05, 1.7861E-05, 1.7336E-05,
     &   1.6816E-05, 1.6300E-05, 1.5790E-05, 1.5284E-05, 1.4784E-05,
     &   1.4288E-05, 1.3799E-05, 1.3315E-05, 1.2837E-05, 1.2365E-05,
     &   1.1899E-05, 1.1439E-05, 1.0986E-05, 1.0539E-05, 1.0100E-05,
     &   9.6670E-06, 9.2415E-06, 8.8233E-06, 8.4127E-06, 8.0097E-06,
     &   7.6146E-06, 7.2275E-06, 6.8486E-06, 6.4781E-06, 6.1162E-06,
     &   5.7630E-06, 5.4187E-06, 5.0835E-06, 4.7575E-06, 4.4410E-06,
     &   4.1340E-06, 3.8368E-06, 3.5496E-06, 3.2724E-06, 3.0055E-06,
     &   2.7490E-06, 2.5031E-06, 2.2678E-06, 2.0435E-06, 1.8302E-06,
     &   1.6280E-06, 1.4371E-06, 1.2577E-06, 1.0898E-06, 9.3356E-07,
     &   7.8912E-07, 7.5445E-07, 7.4093E-07, 7.2754E-07, 7.1426E-07,
     &   7.0110E-07, 6.8807E-07, 6.7515E-07, 6.6235E-07, 6.4967E-07,
     &   6.3712E-07, 6.2468E-07, 6.1236E-07, 6.0016E-07, 5.8809E-07,
     &   5.7613E-07, 5.6430E-07, 5.5258E-07, 5.4099E-07, 5.2951E-07/
  
         DATA ((DGT3(I,J), I= 401, 500), J=2,2) /
     &   5.1816E-07, 5.0693E-07, 4.9582E-07, 4.8483E-07, 4.7396E-07,
     &   4.6322E-07, 4.5259E-07, 4.4209E-07, 4.3171E-07, 4.2145E-07,
     &   4.1131E-07, 4.0129E-07, 3.9140E-07, 3.8162E-07, 3.7197E-07,
     &   3.6245E-07, 3.5304E-07, 3.4376E-07, 3.3459E-07, 3.2555E-07,
     &   3.1664E-07, 3.0784E-07, 2.9917E-07, 2.9062E-07, 2.8220E-07,
     &   2.7389E-07, 2.6571E-07, 2.5766E-07, 2.4972E-07, 2.4191E-07,
     &   2.3422E-07, 2.2666E-07, 2.1922E-07, 2.1190E-07, 2.0470E-07,
     &   1.9763E-07, 1.9069E-07, 1.8386E-07, 1.7716E-07, 1.7058E-07,
     &   1.6413E-07, 1.5780E-07, 1.5160E-07, 1.4551E-07, 1.3956E-07,
     &   1.3372E-07, 1.2801E-07, 1.2243E-07, 1.1697E-07, 1.1163E-07,
     &   1.0642E-07, 1.0133E-07, 9.6363E-08, 9.1523E-08, 8.6807E-08,
     &   8.2216E-08, 7.7749E-08, 7.3407E-08, 6.9189E-08, 6.5096E-08,
     &   6.1127E-08, 5.7283E-08, 5.3563E-08, 4.9969E-08, 4.6499E-08,
     &   4.3153E-08, 3.9933E-08, 3.6837E-08, 3.3866E-08, 3.1020E-08,
     &   2.8299E-08, 2.5703E-08, 2.3231E-08, 2.0885E-08, 1.8663E-08,
     &   1.6567E-08, 1.4595E-08, 1.2749E-08, 1.1027E-08, 9.4309E-09,
     &   7.9595E-09, 7.6058E-09, 7.4685E-09, 7.3324E-09, 7.1976E-09,
     &   7.0640E-09, 6.9317E-09, 6.8006E-09, 6.6708E-09, 6.5423E-09,
     &   6.4149E-09, 6.2889E-09, 6.1641E-09, 6.0405E-09, 5.9182E-09,
     &   5.7972E-09, 5.6773E-09, 5.5588E-09, 5.4415E-09, 5.3254E-09/
  
         DATA ((DGT3(I,J), I= 501, 600), J=2,2) /
     &   5.2106E-09, 5.0971E-09, 4.9848E-09, 4.8737E-09, 4.7639E-09,
     &   4.6554E-09, 4.5481E-09, 4.4420E-09, 4.3372E-09, 4.2337E-09,
     &   4.1314E-09, 4.0303E-09, 3.9305E-09, 3.8320E-09, 3.7347E-09,
     &   3.6387E-09, 3.5439E-09, 3.4503E-09, 3.3581E-09, 3.2670E-09,
     &   3.1772E-09, 3.0887E-09, 3.0014E-09, 2.9154E-09, 2.8306E-09,
     &   2.7471E-09, 2.6648E-09, 2.5838E-09, 2.5040E-09, 2.4255E-09,
     &   2.3482E-09, 2.2722E-09, 2.1974E-09, 2.1239E-09, 2.0516E-09,
     &   1.9806E-09, 1.9108E-09, 1.8423E-09, 1.7750E-09, 1.7090E-09,
     &   1.6442E-09, 1.5807E-09, 1.5185E-09, 1.4574E-09, 1.3977E-09,
     &   1.3392E-09, 1.2819E-09, 1.2259E-09, 1.1712E-09, 1.1176E-09,
     &   1.0654E-09, 1.0144E-09, 9.6464E-10, 9.1614E-10, 8.6889E-10,
     &   8.2290E-10, 7.7815E-10, 7.3465E-10, 6.9241E-10, 6.5142E-10,
     &   6.1168E-10, 5.7319E-10, 5.3595E-10, 4.9996E-10, 4.6522E-10,
     &   4.3174E-10, 3.9950E-10, 3.6852E-10, 3.3879E-10, 3.1031E-10,
     &   2.8308E-10, 2.5710E-10, 2.3237E-10, 2.0890E-10, 1.8667E-10,
     &   1.6570E-10, 1.4598E-10, 1.2751E-10, 1.1029E-10, 9.4319E-11,
     &   7.9602E-11, 7.6064E-11, 7.4691E-11, 7.3330E-11, 7.1981E-11,
     &   7.0646E-11, 6.9322E-11, 6.8011E-11, 6.6713E-11, 6.5427E-11,
     &   6.4154E-11, 6.2893E-11, 6.1645E-11, 6.0409E-11, 5.9186E-11,
     &   5.7975E-11, 5.6777E-11, 5.5591E-11, 5.4418E-11, 5.3257E-11/
  
         DATA ((DGT3(I,J), I= 601, 700), J=2,2) /
     &   5.2109E-11, 5.0974E-11, 4.9850E-11, 4.8740E-11, 4.7642E-11,
     &   4.6556E-11, 4.5483E-11, 4.4422E-11, 4.3374E-11, 4.2339E-11,
     &   4.1316E-11, 4.0305E-11, 3.9307E-11, 3.8322E-11, 3.7349E-11,
     &   3.6388E-11, 3.5440E-11, 3.4505E-11, 3.3582E-11, 3.2671E-11,
     &   3.1773E-11, 3.0888E-11, 3.0015E-11, 2.9155E-11, 2.8307E-11,
     &   2.7471E-11, 2.6649E-11, 2.5838E-11, 2.5040E-11, 2.4255E-11,
     &   2.3482E-11, 2.2722E-11, 2.1974E-11, 2.1239E-11, 2.0516E-11,
     &   1.9806E-11, 1.9108E-11, 1.8423E-11, 1.7750E-11, 1.7090E-11,
     &   1.6443E-11, 1.5807E-11, 1.5185E-11, 1.4575E-11, 1.3977E-11,
     &   1.3392E-11, 1.2819E-11, 1.2259E-11, 1.1712E-11, 1.1177E-11,
     &   1.0654E-11, 1.0144E-11, 9.6465E-12, 9.1615E-12, 8.6890E-12,
     &   8.2290E-12, 7.7816E-12, 7.3466E-12, 6.9242E-12, 6.5142E-12,
     &   6.1168E-12, 5.7319E-12, 5.3595E-12, 4.9996E-12, 4.6522E-12,
     &   4.3174E-12, 3.9950E-12, 3.6852E-12, 3.3879E-12, 3.1031E-12,
     &   2.8308E-12, 2.5710E-12, 2.3237E-12, 2.0890E-12, 1.8667E-12,
     &   1.6570E-12, 1.4598E-12, 1.2751E-12, 1.1029E-12, 9.4319E-13,
     &   7.9602E-13, 7.6064E-13, 7.4691E-13, 7.3330E-13, 7.1981E-13,
     &   7.0646E-13, 6.9322E-13, 6.8011E-13, 6.6713E-13, 6.5427E-13,
     &   6.4154E-13, 6.2893E-13, 6.1645E-13, 6.0409E-13, 5.9186E-13,
     &   5.7975E-13, 5.6777E-13, 5.5591E-13, 5.4418E-13, 5.3257E-13/
  
         DATA ((DGT3(I,J), I= 701, 800), J=2,2) /
     &   5.2109E-13, 5.0974E-13, 4.9850E-13, 4.8740E-13, 4.7642E-13,
     &   4.6556E-13, 4.5483E-13, 4.4422E-13, 4.3374E-13, 4.2339E-13,
     &   4.1316E-13, 4.0305E-13, 3.9307E-13, 3.8322E-13, 3.7349E-13,
     &   3.6388E-13, 3.5440E-13, 3.4505E-13, 3.3582E-13, 3.2671E-13,
     &   3.1773E-13, 3.0888E-13, 3.0015E-13, 2.9155E-13, 2.8307E-13,
     &   2.7471E-13, 2.6649E-13, 2.5838E-13, 2.5040E-13, 2.4255E-13,
     &   2.3482E-13, 2.2722E-13, 2.1974E-13, 2.1239E-13, 2.0516E-13,
     &   1.9806E-13, 1.9108E-13, 1.8423E-13, 1.7750E-13, 1.7090E-13,
     &   1.6443E-13, 1.5807E-13, 1.5185E-13, 1.4575E-13, 1.3977E-13,
     &   1.3392E-13, 1.2819E-13, 1.2259E-13, 1.1712E-13, 1.1177E-13,
     &   1.0654E-13, 1.0144E-13, 9.6465E-14, 9.1615E-14, 8.6890E-14,
     &   8.2290E-14, 7.7816E-14, 7.3466E-14, 6.9242E-14, 6.5142E-14,
     &   6.1168E-14, 5.7319E-14, 5.3595E-14, 4.9996E-14, 4.6522E-14,
     &   4.3174E-14, 3.9950E-14, 3.6852E-14, 3.3879E-14, 3.1031E-14,
     &   2.8308E-14, 2.5710E-14, 2.3237E-14, 2.0890E-14, 1.8667E-14,
     &   1.6570E-14, 1.4598E-14, 1.2751E-14, 1.1029E-14, 9.4319E-15,
     &   7.9602E-15, 7.6064E-15, 7.4691E-15, 7.3330E-15, 7.1981E-15,
     &   7.0646E-15, 6.9322E-15, 6.8011E-15, 6.6713E-15, 6.5427E-15,
     &   6.4154E-15, 6.2893E-15, 6.1645E-15, 6.0409E-15, 5.9186E-15,
     &   5.7975E-15, 5.6777E-15, 5.5591E-15, 5.4418E-15, 5.3257E-15/
  
         DATA ((DGT3(I,J), I= 801, 900), J=2,2) /
     &   5.2109E-15, 5.0974E-15, 4.9850E-15, 4.8740E-15, 4.7642E-15,
     &   4.6556E-15, 4.5483E-15, 4.4422E-15, 4.3374E-15, 4.2339E-15,
     &   4.1316E-15, 4.0305E-15, 3.9307E-15, 3.8322E-15, 3.7349E-15,
     &   3.6388E-15, 3.5440E-15, 3.4505E-15, 3.3582E-15, 3.2671E-15,
     &   3.1773E-15, 3.0888E-15, 3.0015E-15, 2.9155E-15, 2.8307E-15,
     &   2.7471E-15, 2.6649E-15, 2.5838E-15, 2.5040E-15, 2.4255E-15,
     &   2.3482E-15, 2.2722E-15, 2.1974E-15, 2.1239E-15, 2.0516E-15,
     &   1.9806E-15, 1.9108E-15, 1.8423E-15, 1.7750E-15, 1.7090E-15,
     &   1.6443E-15, 1.5807E-15, 1.5185E-15, 1.4575E-15, 1.3977E-15,
     &   1.3392E-15, 1.2819E-15, 1.2259E-15, 1.1712E-15, 1.1177E-15,
     &   1.0654E-15, 1.0144E-15, 9.6465E-16, 9.1615E-16, 8.6890E-16,
     &   8.2290E-16, 7.7816E-16, 7.3466E-16, 6.9242E-16, 6.5142E-16,
     &   6.1168E-16, 5.7319E-16, 5.3595E-16, 4.9996E-16, 4.6522E-16,
     &   4.3174E-16, 3.9950E-16, 3.6852E-16, 3.3879E-16, 3.1031E-16,
     &   2.8308E-16, 2.5710E-16, 2.3237E-16, 2.0890E-16, 1.8667E-16,
     &   1.6570E-16, 1.4598E-16, 1.2751E-16, 1.1029E-16, 9.4319E-17,
     &   7.9602E-17, 3.0019E-17, 7.1165E-17, 6.4092E-10, 2.5771E-09,
     &   5.8665E-09, 1.0534E-08, 1.6588E-08, 2.4033E-08, 3.2868E-08,
     &   4.3096E-08, 5.4718E-08, 6.7734E-08, 8.2147E-08, 9.7957E-08,
     &   1.1517E-07, 1.3378E-07, 1.5379E-07, 1.7521E-07, 1.9803E-07/
  
         DATA ((DGT3(I,J), I= 901, 979), J=2,2) /
     &   2.2226E-07, 2.4790E-07, 2.7496E-07, 3.0343E-07, 3.3332E-07,
     &   3.6463E-07, 3.9737E-07, 4.3153E-07, 4.6713E-07, 5.0416E-07,
     &   5.4262E-07, 5.8253E-07, 6.2389E-07, 6.6669E-07, 7.1095E-07,
     &   7.5667E-07, 8.0385E-07, 8.5250E-07, 9.0262E-07, 9.5423E-07,
     &   1.0073E-06, 1.0619E-06, 1.1180E-06, 1.1755E-06, 1.2346E-06,
     &   1.2952E-06, 1.3573E-06, 1.4210E-06, 1.4862E-06, 1.5529E-06,
     &   1.6212E-06, 1.6910E-06, 1.7624E-06, 1.8354E-06, 1.9100E-06,
     &   1.9862E-06, 2.0640E-06, 2.1434E-06, 2.2244E-06, 2.3071E-06,
     &   2.3914E-06, 2.4774E-06, 2.5650E-06, 2.6544E-06, 2.7454E-06,
     &   2.8382E-06, 2.9328E-06, 3.0290E-06, 3.1271E-06, 3.2269E-06,
     &   3.3286E-06, 3.4321E-06, 3.5374E-06, 3.6446E-06, 3.7537E-06,
     &   3.8648E-06, 3.9778E-06, 4.0928E-06, 4.2098E-06, 4.3289E-06,
     &   4.4501E-06, 4.5735E-06, 4.6990E-06, 4.8268E-06, 4.9569E-06,
     &   5.0894E-06, 5.2244E-06, 5.3619E-06, 5.5021E-06, 5.6450E-06,
     &   5.7908E-06, 5.9398E-06, 6.0920E-06, 6.1576E-06, 6.2548E-06,
     &   6.30104570E-06, 6.41235760E-06, 6.44313404E-06, 6.47822265E-06/
c
      save
      RETURN
      END
