      Real*8 Function LLNSqr(z,xi)
cmarco Implementation of LNSLq from Eq A1 of Buza et. al. 
c      Nucl. Phys. B 472 1996 611 Full mass dependent

      Use mDisPac
      implicit none
      Real*8 z, xi
      external xLi
      Real*8 :: z1, zz, zxi, zz1xi, xLi
      Real*8 :: LL1, LL2, LL3, sq1, sq2
      Real*8 :: DIL1, DIL2, DIL3, DIL4
      Real*8 :: term1, term2, term3, term4

      z1=1.D0-z; zz=z*z; zxi=z/xi; zz1xi=z/(z1*xi)

!Definition of logarithmic functions
      sq1=dsqrt(1d0 - 4d0*zz1xi)
      sq2=dsqrt(1d0 - 4d0*zxi)
      LL1=dlog((1d0+sq1)/(1d0-sq1))
      LL2=dlog((1d0+sq2)/(1d0-sq2))

      if(z.lt.1.d-5)then
        LL3=(z*(-4d0 - xi))/xi + (z**2*(-16d0 - 4d0*xi - xi**2))/(2d0
     >    *xi**2) - 2d0*dlog(z) +dlog(2d0/((4d0/xi**2 + 4d0/xi)/2d0 -
     >    2d0/xi**2))
      else
        LL3=dlog((sq2+sq1)/(sq2-sq1))
      endif
      
      DIL1=xLi(2,z1*(1d0+sq1)/(1d0+sq2))
      DIL2=xLi(2,(1d0-sq2)/(1d0+sq1))
      DIL3=xLi(2,(1d0-sq1)/(1d0+sq2))
      
      if(z.lt.1.d-5)then
        DIL4=Pi**2/6d0 + z**2*(-1d0 + 2d0*dlog(z) -dlog(xi))/xi
      else
        DIL4=xLi(2,(1d0+sq1)/(1d0+sq2))
      endif

      term1=96d0*z *zxi**2 * (2d0*(-DIL1 + DIL2 + DIL3 - DIL4) + LL1
     >  *LL2 + LL1*dlog(z1/zz) )

      term2= zz1xi**2 * (64d0 - 288d0*z + 192d0*zz)*LL1

      term3=z*(16d0/3d0 - 416d0/3d0*zxi + 1408d0/3d0*zxi**2)*LL3/sq2
      
      term4=(16d0/3d0 - 400d0/18d0*z + zz1xi*(-160d0/3d0 + 3824d0/9d0
     >  *z - 992d0/3d0*zz))*sq1

      LLNSqr=Cf*Tf*(term1+term2+term3+term4)

      End


      Real*8 Function L2NSqr(z,xi)
cmarco Implementation of LNS2qr from Eq A2 of Buza et. al. 
c      Nucl. Phys. B 472 1996 611 Full mass dependent
      Use mDispac
      implicit none
      Real*8 z, xi
      external xLi
      Real*8 :: z1,zz,  zxi, zz1xi, xLi 
      Real*8 :: LL1, LL2, LL3, sq1, sq2
      Real*8 :: DIL1, DIL2, DIL3, DIL4
      Real*8 :: term1, term2, term3, term4
      
      z1=1.D0-z; zz=z*z; zxi=z/xi; zz1xi=z/(z1*xi)

!Definition of logarithmic functions
      sq1=dsqrt(1d0 - 4d0*zz1xi)
      sq2=dsqrt(1d0 - 4d0*zxi)
      LL1=dlog((1d0+sq1)/(1d0-sq1))
      LL2=dlog((1d0+sq2)/(1d0-sq2))
      
      if(z.lt.1.d-5)then
        LL3=(z*(-4d0 - xi))/xi + (z**2*(-16d0 - 4d0*xi - xi**2))/(2d0
     >    *xi**2) - 2d0*dlog(z) +dlog(2d0/((4d0/xi**2 + 4d0/xi)/2d0 -
     >    2d0/xi**2))
      else
        LL3=dlog((sq2+sq1)/(sq2-sq1))
      endif

      DIL1=xLi(2,z1*(1d0+sq1)/(1d0+sq2))
      DIL2=xLi(2,(1d0-sq2)/(1d0+sq1))
      DIL3=xLi(2,(1d0-sq1)/(1d0+sq2))
      
      if(z.lt.1.d-5)then
        DIL4=Pi**2/6d0 + z**2*(-1d0 + 2d0*dlog(z) -dlog(xi))/xi
      else
        DIL4=xLi(2,(1d0+sq1)/(1d0+sq2))
      endif
      
      term1= (4d0/3d0*(1d0 + zz)/z1 - 
     >  16d0*zxi*zz1xi*(1d0 - 9d0*z + 9d0*zz))*
     >  (LL1*LL2 + LL1*dlog(z1/zz) + 2d0*(-DIL1 + DIL2 + DIL3 - DIL4)) 
      
      term2= LL1*( -8d0/3d0 + 4d0/z1 + 
     >  zz1xi**2*(128d0 - 8d0/z1 - 432d0*z + 288d0*zz))
      
      term3=(88d0/9d0 + 136d0/9d0*z  - 152d0/9d0/z1  
     >  + zz1xi*(464d0/9d0 - 512d0/3d0*z + 2048d0/9d0*zz)
     >  + zz1xi**2 *(-832d0/9d0 + 6208d0/9d0*z - 11392d0/9d0*zz 
     >  + 6016d0/9d0*zz*z) )*LL3/sq2

      term4=(-272d0/27d0 - 1244d0/27d0*z + 718d0/27d0/z1  
     >  + zz1xi*(-3424d0/27d0 + 15608d0/27d0*z - 4304d0/9d0*zz  
     >  + 20d0/27d0/z1) )*sq1
      
      L2NSqr=Cf*Tf*(term1+term2+term3+term4)
       
      End
      
      Real*8 Function L2NSqr0(z,xi)
cmarco Implementation of LNS2qr from Eq A2 of Buza et. al. 
c Nucl. Phys. B 472 1996 611 Full mass dependent
c Here we made an explicit subtraction of the singuar part
c that is added analytically in F2LNS2 
cmarco
      Use mDispac               
      implicit none
      Real*8 z, xi
      external xLi
      Real*8 :: z1,zz,  zxi, zz1xi, xLi 
      Real*8 :: LL1, LL2, LL3, sq1, sq2
      Real*8 :: DIL1, DIL2, DIL3, DIL4
      Real*8 :: term1, term2, term3, term4, asym

      z1=1.D0-z; zz=z*z; zxi=z/xi; zz1xi=z/(z1*xi)

!Definition of logarithmic functions
      sq1=dsqrt(1d0 - 4d0*zz1xi)
      sq2=dsqrt(1d0 - 4d0*zxi)
      LL1=dlog((1d0+sq1)/(1d0-sq1))
      LL2=dlog((1d0+sq2)/(1d0-sq2))
      
      if(z.lt.1.d-5)then
        LL3=(z*(-4d0 - xi))/xi + (z**2*(-16d0 - 4d0*xi - xi**2))/(2d0
     >    *xi**2) - 2d0*dlog(z) +dlog(2d0/((4d0/xi**2 + 4d0/xi)/2d0 -
     >    2d0/xi**2))
      else
        LL3=dlog((sq2+sq1)/(sq2-sq1))
      endif
      
      DIL1=xLi(2,z1*(1d0+sq1)/(1d0+sq2))
      DIL2=xLi(2,(1d0-sq2)/(1d0+sq1))
      DIL3=xLi(2,(1d0-sq1)/(1d0+sq2))
      
      if(z.lt.1.d-5)then
        DIL4=Pi**2/6d0 + z**2*(-1d0 + 2d0*dlog(z) -dlog(xi))/xi
      else
        DIL4=xLi(2,(1d0+sq1)/(1d0+sq2))
      endif
      
      term1= (4d0/3d0*(1d0 + zz)/z1 - 
     >  16d0*zxi*zz1xi*(1d0 - 9d0*z + 9d0*zz))*
     >  (LL1*LL2 + LL1*dlog(z1/zz) + 2d0*(-DIL1 + DIL2 + DIL3 - DIL4)) 
      
      term2= LL1*( -8d0/3d0 + 4d0/z1 + 
     >  zz1xi**2*(128d0 - 8d0/z1 - 432d0*z + 288d0*zz))
      
      term3=(88d0/9d0 + 136d0/9d0*z  - 152d0/9d0/z1  
     >  + zz1xi*(464d0/9d0 - 512d0/3d0*z + 2048d0/9d0*zz)
     >  + zz1xi**2 *(-832d0/9d0 + 6208d0/9d0*z - 11392d0/9d0*zz 
     >  + 6016d0/9d0*zz*z) )*LL3/sq2
      
      term4=(-272d0/27d0 - 1244d0/27d0*z + 718d0/27d0/z1  
     >  + zz1xi*(-3424d0/27d0 + 15608d0/27d0*z - 4304d0/9d0*zz  
     >  + 20d0/27d0/z1) )*sq1
      
cmarco      asym=(232.0d0*dlog(z)/27.0d0 + 8.0d0/3.0d0*dlog(z)**2 
c     >  -32.0d0*dlog(z)*dlog(xi)/9.0D0) 

      !subtraction of the singular part for z->0 
      asym=892d0/81d0-16d0/27d0*Pi**2
     >  +232.0d0/27.0d0*dlog(z) + 8.0d0/3.0d0*dlog(z)**2 
     >  -32.0d0*dlog(z)*dlog(xi)/9.0D0 
     >  -104d0/27d0*dlog(xi)+8d0/9d0*dlog(xi)**2 
      
      L2NSqr0=Cf*Tf*(term1+term2+term3+term4)-asym
      End
      


      Real*8 Function AsyLLNSq(z,xi)
cmarco Implementation of LLNS2q from Eq D7 of Buza et. al. 
c      Nucl. Phys. B 472 1996 611 Asymptotic form Q^2>>m^2
      implicit none
      Real*8 z, xi
      Real*8, parameter:: Cf=4d0/3d0, Tf=.5d0
 
      AsyLLNSq=16d0/3d0*Cf*Tf*( z*(dlog(xi) + 
     >  dlog(1d0-z) - 2d0*dlog(z)) + 1d0 - 25d0/6d0*z )

      End

      
      Real*8 Function AsyL2NSq(z,xi)
cmarco Implementation of L2NS2q from Eq D8 of Buza et. al. 
c      Nucl. Phys. B 472 1996 611 Asymptotic form Q^2>>m^2
      implicit none
      Real*8 z, xi
      external xLi
      Real*8, parameter:: Cf=4d0/3d0, Tf=.5d0
      Real*8, parameter:: Zeta2=1.6449340668482264365D0
      Real*8 :: z1,zz, xLi 
      Real*8 :: term1, term2, term3

      z1=1d0-z
      zz=z*z

      term1=4d0/3d0*(1d0 + zz)/z1

      term2= (1d0+zz)/z1*(8d0/3d0*dlog(z1)-16d0/3d0/dlog(z)-58d0/9d0) +
     >  2d0/3d0 + 26d0/3d0*z

      term3=(1d0+zz)/z1*(-8d0/3d0*xLi(2,z1) - 8d0/3d0*Zeta2 - 16d0/3d0
     >  *dlog(z)*dlog(z1)+ 4d0/3d0*dlog(z1)**2 + 4d0*dlog(z)**2 - 58d0
     >  /9d0*dlog(z1) +134d0/9d0*dlog(z) + 359d0/27d0) + (2d0/3d0 + 26d0
     >  /3d0*z)*dlog(z1) - (2d0 + 46d0/3d0*z)*dlog(z) + 29d0/9d0 -295d0
     >  /9d0*z
       
      AsyL2NSq=Cf*Tf*(term1*dlog(xi)**2 + term2*dlog(xi) + term3)

      End


C     Auxilary procedures for GM-JS
C     Assembled by HLL, 08.07 from source codes (1996) provided by Jack Smith.

C     ------------------------------------------------------------------------

      Real*8 Function A1Hg(z,eps)
c based on appendix B of Buza et al. EJC, hep-ph/9612398
c eps=m^2/mu^2
c Tf=1/2
      implicit none
      Real*8 z, eps

      A1Hg= -2d0*(1.-2.*z+2.*z*z)*dlog(eps)

      end

cmarco
      Real*8 Function A2PSHq(z,eps)
      implicit none
      Real*8 z, eps
c remove unused one (jcp)      external xLi, snp12N, snp12
      external xLi, snp12
      Real*8, parameter:: Cf=4d0/3d0, Ca=3d0, Tf=.5d0
      Real*8, parameter:: Zeta2=1.6449340668482264365D0
      Real*8, parameter:: Zeta3=1.2020569031595942854D0
      Real*8 :: z1, DL, dlm2u
c remove unused one (jcp)      Real*8 :: snp12, xLi, snp12N! functions
      Real*8 :: snp12, xLi ! functions
      Real*8 :: Li2z1, S12z1

      z1=1d0-z

      DL=dlog(z)
      dlm2u=dlog(eps)

      Li2z1=xLi(2,z1)           !dilogarithm
      S12z1=snp12(z1)
      
      A2PSHq = Cf*Tf*( (-8. * (1.+ z) * DL - 16./3./z - 4. + 4. * z  +
     >  16./3.*z**2)*dlm2u*dlm2u + ((8.+z)*DL*DL - (8. + 40.*z + 64./3.
     >  *z*z)*DL-160./9./z + 16. - 48.*z + 448./9.*z*z)*dlm2u + (1.+z)
     >  *(32.*S12z1+16.*DL*Li2z1 -16.*Zeta2*DL - 4./3.*DL**3) + (32./3.
     >  /z +8.-8.*z-32./3.*z*z)*Li2z1 + (-32./3./z -8.+8.*z +32./3.*z*z)
     >  *Zeta2+(2.+10.*z+16./3.*z*z)*DL*DL - (56./3. + 88./3. * z   +
     >  448./9.*z*z)*DL - 448./27./z - 4./3. -124./3.*z + 1600./27.*z*z)
      End
cmarco


cmarco
      Real*8 Function A2NSqqPlus(z,eps)
      implicit none
      Real*8 z, eps
      Real*8, parameter:: Cf=4d0/3d0, Ca=3d0, Tf=.5d0
      
      A2NSqqPlus = Cf*Tf*(dlog(eps)**2*8d0/3d0 + 80d0/9d0*dlog(eps) +
     >  224d0/27d0)/(1d0-z)

      End
      Real*8 Function A2NSqqFinite(z,eps)
cmarco
      implicit none
      Real*8 z, eps
      Real*8, parameter:: Cf=4d0/3d0, Ca=3d0, Tf=.5d0
      Real*8 :: z1,zz

      z1=1d0-z
      zz=z*z
      
      A2NSqqFinite = Cf*Tf*(( -4d0/3d0 - 4d0/3d0*z)*dlog(eps)**2 + (8d0
     >  /3d0*(1+zz)/z1*dlog(z) + 8d0/9d0 - 88d0/9d0*z)*dlog(eps) + (1+zz
     >  )/z1*(2d0/3d0*dlog(z)**2  + 20d0/9d0*dlog(z)) + 8d0/3d0*z1
     >  *dlog(z) + 44d0/27d0 - 268d0/27d0*z)
      End

      Real*8 Function A2Hg(z,eps)
cmarco
      implicit none
      Real*8 z, eps
c remove unused one (jcp)      external xLi, snp12N, snp12
      external xLi, snp12
      Real*8, parameter:: Cf=4d0/3d0, Ca=3d0, Tf=.5d0
      Real*8, parameter:: Zeta2=1.6449340668482264365D0
      Real*8, parameter:: Zeta3=1.2020569031595942854D0
      Real*8 :: z1,zz, pqg, DL, DL1, DLp, dlm2u
c remove unused one (jcp)      Real*8 :: snp12, xLi, snp12N! functions
      Real*8 :: snp12, xLi ! functions
      Real*8 :: Li2z, Li2z1, Li3z, Li3z1, S12z, S12z1
      Real*8 :: term1, term2, term3a, term3b

      z1=1d0-z
      zz=z*z
      pqg=1.-2.*z+2.*zz
      DL=dlog(z)
      DL1=dlog(z1)
      DLp=dlog(1.+z)
      dlm2u=dlog(eps)

      Li2z=xLi(2,-z)               !dilogarithm
      Li2z1=xLi(2,z1)
      Li3z= xLi(3,-z)               !trilogarithm
      Li3z1= xLi(3,z1)
      S12z=snp12(-z)             !Nielsen function
      S12z1=snp12(z1)

      term1=Cf*Tf*((8.*pqg)*DL1-(4.-8.*z+16.*zz)*DL-(2.-8.*z))
     >  +Ca*Tf*(-(8.*pqg)*DL1-(8.+32.*z)*DL-16./3./z-4.-32.*z
     >  +124./3.*zz)+Tf*Tf*(-16./3.*pqg)
      term2=Cf*Tf*(8.*pqg*(2.*DL*DL1-DL1*DL1+2.*Zeta2)-(4.-8.*z+16.*zz)
     >  *DL*DL-32.*z*z1*DL1-(12.-16.*z+32.*zz)*DL-56.+116.*z-80.*zz)
     >  +Ca*Tf*((16.+32.*z+32.*zz)*(Li2z+DL*DLp)+8.*pqg*DL1*DL1
     >  +(8.+16.*z)*DL*DL+32.*z*Zeta2+32.*z*z1*DL1
     >  -(8.+64.*z+352./3.*zz)*DL-160./9./z+16.-200.*z+1744./9.*zz)
      term3a=Cf*Tf*(pqg*(8.*Zeta3+4./3.*DL1**3-8.*DL1*Li2z1+8.*Zeta2*DL
     >  -4.*DL*DL1*DL1+2./3.*DL**3-8.*DL*Li2z1+8.*Li3z1-24.*S12z1)
     >  +zz*(-16.*Zeta2*DL+4./3.*DL**3+16.*DL*Li2z1+32.*S12z1)
     >  -(4.+96.*z-64.*zz)*Li2z1-(4.-48.*z+40.*zz)*Zeta2
     >  -(8.+48.*z-24.*zz)*DL*DL1+(4.+8.*z-12.*zz)*DL1*DL1
     >  -(1.+12.*z-20.*zz)*DL*DL-(52.*z-48.*zz)*DL1
     >  -(16.+18.*z+48.*zz)*DL+26.-82.*z+80.*zz)
      term3b=Ca*Tf*(pqg*(-4./3.*DL1**3+8.*DL1*Li2z1-8.*Li3z1)
     >  +(1.+2.*z+2.*zz)*(-8.*Zeta2*DLp-16.*DLp*Li2z-8.*DL*DLp*DLp
     >  +4.*DL*DL*DLp+8.*DL*Li2z-8.*Li3z-16.*S12z)
     >  +(16.+64.*z)*(2.*S12z1+DL*Li2z1)-(4.+8.*z)/3.*DL**3
     >  +(8.-32.*z+16.*zz)*Zeta3-(16.+64.*z)*Zeta2*DL+(16.+16.*zz)
     >  *(Li2z+DL*DLp)+(32./3./z+12.+64.*z-272./3.*zz)*Li2z1
     >  -(12.+48.*z-260./3.*zz+32./3./z)*Zeta2-4.*zz*DL*DL1
     >  -(2.+8.*z-10.*zz)*DL1*DL1+(2.+8.*z+46./3.*zz)*DL*DL
     >  +(4.+16.*z-16.*zz)*DL1-(56./3.+172./3*z+1600./9.*zz)*DL
     >  -448./27./z-4./3.-628./3.*z+6352./27.*zz)

      A2Hg=term1*dlm2u*dlm2u +term2*dlm2u +term3a+term3b

cmarco form A. Vogt
c      A2Hg=-1.111d0*DL1**3-0.400d0*DL1**2-2.770d0*DL1-187.8+249.6*z -
c     >  146.8*DL**2*DL1-93.68*DL-3.292*DL**2-1.556*DL**3-24.89/z
cmarco
      End
      
      Real*8 Function HQcoef(iFn,z,Q,amu,ams)
      implicit none
      Integer iFn
      Real*8 z, Q, amu, ams
      Real*8, parameter:: ca = 3d0, cf = 4d0/3d0, tf = 0.5d0
      Real*8, parameter:: pi = 3.1415265359d0
      Real*8 xi, eta, rho, beta, amu2m2
      Real*8 asymp_l_CT, asymp_t_CT, asympbar_l_CT, asympbar_t_CT !functions
      Real*8 threshf_l_CT, threshf_t_CT, thresha_l_CT, threshbar_l_CT !functions
      Real*8 thresha_t_CT, threshbar_t_CT !functions
      Real*8 xsclca, xsclcf, xsclba, xsctca, xsctcf, xsctba
      Real*8 xclca, xclcf, xclbar, xctca, xctcf, xctbar
      Real*8 fglcorr, fgtcorr, fac

      If(.not.(iFn==0 .or. iFn==2)) then
         print*,'iFn is not supported in HQcoef: iFn=',iFn
         HQcoef=0d0
         return
      Endif

      xi=(Q/ams)**2
      eta=xi*(1d0-z)/z/4d0 -1d0
      rho=1d0/(1d0+eta)
      beta=dsqrt(eta*rho)
      amu2m2=(amu/ams)**2

c longitudinal component
         call sclca_CT(eta,xi,xsclca)
         xclca = ca*tf*(xsclca + beta*asymp_l_CT(xi) +
     >        rho*thresha_l_CT(eta,xi))
         call sclcf_CT(eta,xi,xsclcf)
         xclcf = cf*tf*(xsclcf + rho*threshf_l_CT(eta,xi))
         call sclbar_CT(eta,xi,xsclba)
         xclbar = ca*tf*(xsclba + beta*asympbar_l_CT(xi) +
     >        rho*threshbar_l_CT(eta,xi))
         fglcorr = xclca + xclcf +  xclbar*dlog(amu2m2) 
         fgtcorr = 0.d0
      
      If(iFn==2) then
c transverse component
         call sctca_CT(eta,xi,xsctca)
         xctca = ca*tf*(xsctca + beta*asymp_t_CT(xi) +
     >        rho*thresha_t_CT(eta,xi))
         call sctcf_CT(eta,xi,xsctcf)
         xctcf = cf*tf*(xsctcf + rho*threshf_t_CT(eta,xi))
         call sctbar_CT(eta,xi,xsctba)
         xctbar = ca*tf*(xsctba + beta*asympbar_t_CT(xi) +
     >        rho*threshbar_t_CT(eta,xi))
         fgtcorr = xctca + xctcf +  xctbar*dlog(amu2m2) 
      Endif

cmarco Liang's expression was fac=16d0*pi*xi/z 
      fac=16d0*xi*pi/z !overall factor converted to consist with f2HQg
         !/z here but multiply x outside of the integral to consist with ACOT
                                ! extra (alfas/4pi)^2 * eh^2 assumed

      HQcoef=fac*(fglcorr + fgtcorr)
      
      End

      Real*8 Function HQhqlcoef(iFn,z,Q,amu,ams)
cmarco light quark initiated contributions -> photon-heavy qrk
      implicit none
      Integer iFn
      Real*8 z, Q, amu, ams

      Real*8, parameter:: ca = 3d0, cf = 4d0/3d0, tf = 0.5d0
      Real*8, parameter:: pi = 3.1415265359d0
      Real*8 xi, eta, rho, beta, amu2m2
      Real*8 asymp_t_CT, asymp_l_CT,asympbar_l_CT, asympbar_t_CT !functions
      Real*8 fac
      Real*8 xchql, xschql, xqlbar, xsqlbar
      Real*8 xchqt, xschqt, xqtbar, xsqtbar
      Real*8 fhqlcorr, fhqtcorr


      If(.not.(iFn==0 .or. iFn==2)) then
         print*,'iFn is not supported in HQhqlcoef: iFn=',iFn
         HQhqlcoef=0d0
         return
      Endif

      xi=(Q/ams)**2
      eta=xi*(1d0-z)/z/4d0 -1d0
      rho=1d0/(1d0+eta)
      beta=dsqrt(eta*rho)
      amu2m2=(amu/ams)**2

c longitudinal component
         call schql_CT(eta, xi, xschql)
         xchql = cf*tf*(xschql + beta**3*asymp_l_CT(xi))
         call sqlbar_CT(eta,xi,xsqlbar)
         xqlbar = cf*tf*(xsqlbar + beta**3*asympbar_l_CT(xi))
         fhqlcorr = xchql + xqlbar*dlog(amu2m2)
         fhqtcorr = 0.d0
      
      If(iFn==2) then
c transverse component
         call schqt_CT(eta,xi,xschqt)
         xchqt = cf*tf*(xschqt + beta**3*asymp_t_CT(xi))
         call sqtbar_CT(eta,xi,xsqtbar)
         xqtbar = cf*tf*(xsqtbar + beta**3*asympbar_t_CT(xi))
         fhqtcorr = xchqt + xqtbar*dlog(amu2m2)
      Endif
cmarco Liang was 16d0*pi*xi/z
      fac=16d0*pi*xi/z !overall factor converted to consist with f2HQg
         !/z here but multiply x outside of the integral to consist with ACOT
                                ! extra (alfas/4pi)^2 * eh^2 assumed

      HQhqlcoef=fac*(fhqtcorr + fhqlcorr)

      End


      Real*8 Function HQlqcoef(iFn,z,Q,amu,ams)
cmarco light quark initiated contributions -> photon-light qrk
      implicit none
      Integer iFn
      Real*8 z, Q, amu, ams

      Real*8, parameter:: ca = 3d0, cf = 4d0/3d0, tf = 0.5d0
      Real*8, parameter:: pi = 3.1415265359d0
      Real*8 xi, eta, fac
      Real*8 xclql, xsclql, xclqt, xsclqt
      Real*8 flqtcorr, flqlcorr

      If(.not.(iFn==0 .or. iFn==2)) then
         print*,'iFn is not supported in HQhqlcoef: iFn=',iFn
         HQlqcoef=0d0
         return
      Endif

      xi=(Q/ams)**2
      eta=xi*(1d0-z)/z/4d0 -1d0

c longitudinal component
         call sclql_CT(eta, xi, xsclql)
         xclql = cf*tf*xsclql
         flqlcorr = xclql 
         flqtcorr = 0.d0
      
      If(iFn==2) then
c transverse component
         call sclqt_CT(eta, xi, xsclqt)
         xclqt = cf*tf*xsclqt
         flqtcorr = xclqt 
      Endif
camrco Liang was 16d0*pi*xi/z
      fac= 16d0*pi*xi/z !overall factor converted to consist with f2HQg
         !/z here but multiply x outside of the integral to consist with ACOT
                                ! extra (alfas/4pi)^2 * eh^2 assumed

      HQlqcoef=fac*(flqlcorr + flqtcorr)
      End


      Real*8 Function HQcoef0(iFn,z,Q,amu,ams) !LO in gluon-photon
      implicit none
      Integer iFn
      Real*8 z, Q, amu, ams

      Real*8, parameter:: pi = 3.1415265359d0
      Real*8 xi, eta
      Real*8 born_l_CT, born_t_CT !functions
      Real*8 fglcorr, fgtcorr, fac

      If(.not.(iFn==0 .or. iFn==2)) then
         print*,'iFn is not supported in HQcoef0: iFn=',iFn
         HQcoef0=0d0
         return
      Endif

      xi=(Q/ams)**2
      eta=xi*(1d0-z)/z/4d0 -1d0

c longitudinal component
         fglcorr = born_l_CT(eta,xi)
      
      If(iFn==2) then
c transverse component
         fgtcorr = born_t_CT(eta,xi)
      Else
         fgtcorr = 0.d0
      Endif

      fac= xi/pi/z !overall factor converted to consist with f2HQg0
         !/z here but multiply x outside of the integral to consist with ACOT
                                ! extra (alfas/4pi)*eh^2 assumed

      HQcoef0=fac*(fglcorr + fgtcorr)

      End

      subroutine sclca_CT(eta, xi, xsclca)
c   the subtracted term from eq (9) of PLB347 (1995) 143 - 151
c   longitudinal gluon initiated piece with C_A color factor in front
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsclca
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /-.1179D-07, -.1428D-07,
     >    -.1730D-07, -.2095D-07, -.2538D-07, -.3074D-07, -.3723D-07,
     >    -.4509D-07, -.5457D-07, -.6604D-07, -.7989D-07, -.9657D-07,
     >    -.1166D-06, -.1406D-06, -.1691D-06, -.2029D-06, -.2423D-06,
     >    -.2875D-06, -.3377D-06, -.3910D-06, -.4424D-06, -.4824D-06,
     >    -.4929D-06, -.4417D-06, -.2734D-06, 0.1048D-06, 0.8410D-06,
     >    0.2167D-05, 0.4413D-05, 0.8018D-05, 0.1347D-04, 0.2118D-04,
     >    0.3115D-04, 0.4274D-04, 0.5440D-04, 0.6402D-04, 0.6968D-04,
     >    0.7031D-04, 0.6605D-04, 0.5802D-04, 0.4795D-04, 0.3757D-04,
     >    0.2814D-04, 0.2032D-04, 0.1427D-04, 0.9805D-05, 0.6626D-05,
     >    0.4430D-05, 0.2942D-05, 0.1939D-05, 0.1271D-05, 0.8315D-06,
     >    0.5416D-06, 0.3496D-06, 0.2296D-06, 0.1507D-06, 0.9812D-07,
     >    0.6371D-07, 0.3752D-07, 0.2606D-07, 0.1129D-07, 0.1001D-07,
     >    0.6726D-08, -.6033D-10, 0.1982D-08, -.1166D-08, -.3311D-08,
     >    -.4773D-08, 0.8985D-09, 0.2197D-09, -.2427D-09, -.5576D-09,
     >    -.7721D-09/

      data (calcpts(j, 2), j = 1,neta) /-.1730D-07, -.2096D-07,
     >    -.2538D-07, -.3075D-07, -.3725D-07, -.4512D-07, -.5464D-07,
     >    -.6617D-07, -.8009D-07, -.9693D-07, -.1173D-06, -.1417D-06,
     >    -.1711D-06, -.2063D-06, -.2482D-06, -.2978D-06, -.3556D-06,
     >    -.4219D-06, -.4957D-06, -.5739D-06, -.6493D-06, -.7080D-06,
     >    -.7235D-06, -.6485D-06, -.4017D-06, 0.1531D-06, 0.1234D-05,
     >    0.3179D-05, 0.6475D-05, 0.1177D-04, 0.1977D-04, 0.3108D-04,
     >    0.4572D-04, 0.6272D-04, 0.7983D-04, 0.9395D-04, 0.1023D-03,
     >    0.1032D-03, 0.9692D-04, 0.8514D-04, 0.7037D-04, 0.5514D-04,
     >    0.4130D-04, 0.2982D-04, 0.2094D-04, 0.1439D-04, 0.9726D-05,
     >    0.6501D-05, 0.4316D-05, 0.2843D-05, 0.1869D-05, 0.1219D-05,
     >    0.7955D-06, 0.5175D-06, 0.3379D-06, 0.2175D-06, 0.1385D-06,
     >    0.8579D-07, 0.5801D-07, 0.3185D-07, 0.2039D-07, 0.1227D-07,
     >    0.4342D-08, 0.1049D-08, 0.9303D-09, -.3690D-08, -.1711D-09,
     >    -.2317D-08, -.3777D-08, -.4773D-08, -.5452D-08, -.5914D-08,
     >    -.6228D-08/

      data (calcpts(j, 3), j = 1,neta) /-.2537D-07, -.3074D-07,
     >    -.3724D-07, -.4511D-07, -.5465D-07, -.6619D-07, -.8016D-07,
     >    -.9707D-07, -.1175D-06, -.1422D-06, -.1720D-06, -.2079D-06,
     >    -.2510D-06, -.3027D-06, -.3642D-06, -.4368D-06, -.5217D-06,
     >    -.6189D-06, -.7272D-06, -.8419D-06, -.9525D-06, -.1039D-05,
     >    -.1061D-05, -.9512D-06, -.5895D-06, 0.2244D-06, 0.1810D-05,
     >    0.4663D-05, 0.9499D-05, 0.1726D-04, 0.2900D-04, 0.4559D-04,
     >    0.6706D-04, 0.9199D-04, 0.1171D-03, 0.1378D-03, 0.1500D-03,
     >    0.1513D-03, 0.1421D-03, 0.1249D-03, 0.1032D-03, 0.8086D-04,
     >    0.6056D-04, 0.4373D-04, 0.3071D-04, 0.2110D-04, 0.1427D-04,
     >    0.9545D-05, 0.6330D-05, 0.4175D-05, 0.2746D-05, 0.1799D-05,
     >    0.1177D-05, 0.7653D-06, 0.4997D-06, 0.3263D-06, 0.2127D-06,
     >    0.1402D-06, 0.9418D-07, 0.5982D-07, 0.4034D-07, 0.2889D-07,
     >    0.2081D-07, 0.1287D-07, 0.9587D-08, 0.9478D-08, 0.4861D-08,
     >    0.8381D-08, 0.6240D-08, 0.4779D-08, 0.3784D-08, 0.3106D-08,
     >    0.2644D-08/

      data (calcpts(j, 4), j = 1,neta) /-.3724D-07, -.4511D-07,
     >    -.5464D-07, -.6620D-07, -.8019D-07, -.9713D-07, -.1176D-06,
     >    -.1424D-06, -.1724D-06, -.2087D-06, -.2524D-06, -.3051D-06,
     >    -.3684D-06, -.4442D-06, -.5344D-06, -.6411D-06, -.7656D-06,
     >    -.9083D-06, -.1067D-05, -.1236D-05, -.1398D-05, -.1524D-05,
     >    -.1558D-05, -.1397D-05, -.8658D-06, 0.3268D-06, 0.2652D-05,
     >    0.6837D-05, 0.1393D-04, 0.2531D-04, 0.4253D-04, 0.6687D-04,
     >    0.9836D-04, 0.1349D-03, 0.1717D-03, 0.2021D-03, 0.2200D-03,
     >    0.2219D-03, 0.2085D-03, 0.1831D-03, 0.1514D-03, 0.1186D-03,
     >    0.8883D-04, 0.6414D-04, 0.4504D-04, 0.3095D-04, 0.2093D-04,
     >    0.1400D-04, 0.9283D-05, 0.6119D-05, 0.4024D-05, 0.2635D-05,
     >    0.1720D-05, 0.1122D-05, 0.7284D-06, 0.4753D-06, 0.3088D-06,
     >    0.2015D-06, 0.1291D-06, 0.8310D-07, 0.5541D-07, 0.3594D-07,
     >    0.2453D-07, 0.1644D-07, 0.8512D-08, 0.5240D-08, 0.5134D-08,
     >    0.7185D-08, 0.4044D-08, 0.1901D-08, 0.4413D-09, 0.6114D-08,
     >    0.5437D-08/

      data (calcpts(j, 5), j = 1,neta) /-.5464D-07, -.6620D-07,
     >    -.8018D-07, -.9714D-07, -.1177D-06, -.1425D-06, -.1726D-06,
     >    -.2090D-06, -.2530D-06, -.3062D-06, -.3704D-06, -.4477D-06,
     >    -.5406D-06, -.6519D-06, -.7842D-06, -.9407D-06, -.1123D-05,
     >    -.1333D-05, -.1566D-05, -.1813D-05, -.2052D-05, -.2229D-05,
     >    -.2287D-05, -.2051D-05, -.1274D-05, 0.4740D-06, 0.3881D-05,
     >    0.1002D-04, 0.2042D-04, 0.3710D-04, 0.6236D-04, 0.9805D-04,
     >    0.1442D-03, 0.1979D-03, 0.2518D-03, 0.2964D-03, 0.3225D-03,
     >    0.3254D-03, 0.3056D-03, 0.2685D-03, 0.2219D-03, 0.1739D-03,
     >    0.1302D-03, 0.9403D-04, 0.6603D-04, 0.4537D-04, 0.3067D-04,
     >    0.2051D-04, 0.1360D-04, 0.8964D-05, 0.5884D-05, 0.3854D-05,
     >    0.2514D-05, 0.1636D-05, 0.1062D-05, 0.6875D-06, 0.4415D-06,
     >    0.2878D-06, 0.1807D-06, 0.1151D-06, 0.6913D-07, 0.4147D-07,
     >    0.2875D-07, 0.1733D-07, 0.9258D-08, 0.1351D-08, -.1914D-08,
     >    -.2016D-08, 0.4406D-10, -.3098D-08, -.5239D-08, -.6697D-08,
     >    -.7690D-08/

      data (calcpts(j, 6), j = 1,neta) /-.8015D-07, -.9710D-07,
     >    -.1176D-06, -.1425D-06, -.1726D-06, -.2090D-06, -.2532D-06,
     >    -.3066D-06, -.3711D-06, -.4491D-06, -.5433D-06, -.6566D-06,
     >    -.7929D-06, -.9561D-06, -.1150D-05, -.1380D-05, -.1648D-05,
     >    -.1955D-05, -.2297D-05, -.2660D-05, -.3010D-05, -.3283D-05,
     >    -.3357D-05, -.3012D-05, -.1874D-05, 0.6859D-06, 0.5677D-05,
     >    0.1467D-04, 0.2990D-04, 0.5435D-04, 0.9137D-04, 0.1437D-03,
     >    0.2113D-03, 0.2900D-03, 0.3690D-03, 0.4343D-03, 0.4726D-03,
     >    0.4768D-03, 0.4478D-03, 0.3933D-03, 0.3251D-03, 0.2547D-03,
     >    0.1908D-03, 0.1377D-03, 0.9673D-04, 0.6645D-04, 0.4493D-04,
     >    0.3004D-04, 0.1995D-04, 0.1316D-04, 0.8593D-05, 0.5674D-05,
     >    0.3711D-05, 0.2394D-05, 0.1547D-05, 0.1026D-05, 0.6864D-06,
     >    0.4268D-06, 0.2468D-06, 0.1668D-06, 0.8797D-07, 0.5549D-07,
     >    0.5467D-07, 0.8638D-08, 0.4394D-07, 0.2258D-07, 0.8028D-08,
     >    -.1890D-08, -.8640D-08, -.1324D-07, -.1638D-07, -.1852D-07,
     >    -.1997D-07/

      data (calcpts(j, 7), j = 1,neta) /-.1175D-06, -.1424D-06,
     >    -.1725D-06, -.2089D-06, -.2531D-06, -.3065D-06, -.3712D-06,
     >    -.4496D-06, -.5441D-06, -.6585D-06, -.7966D-06, -.9629D-06,
     >    -.1163D-05, -.1402D-05, -.1687D-05, -.2023D-05, -.2417D-05,
     >    -.2867D-05, -.3369D-05, -.3901D-05, -.4415D-05, -.4817D-05,
     >    -.4927D-05, -.4425D-05, -.2761D-05, 0.9843D-06, 0.8293D-05,
     >    0.2145D-04, 0.4376D-04, 0.7956D-04, 0.1338D-03, 0.2103D-03,
     >    0.3094D-03, 0.4245D-03, 0.5403D-03, 0.6358D-03, 0.6919D-03,
     >    0.6980D-03, 0.6555D-03, 0.5757D-03, 0.4758D-03, 0.3728D-03,
     >    0.2792D-03, 0.2016D-03, 0.1416D-03, 0.9723D-04, 0.6578D-04,
     >    0.4393D-04, 0.2913D-04, 0.1919D-04, 0.1264D-04, 0.8225D-05,
     >    0.5357D-05, 0.3523D-05, 0.2272D-05, 0.1492D-05, 0.9729D-06,
     >    0.6333D-06, 0.3745D-06, 0.2620D-06, 0.1824D-06, 0.1038D-06,
     >    0.7170D-07, 0.7095D-07, 0.2502D-07, -.6248D-08, 0.3911D-07,
     >    0.2459D-07, 0.1470D-07, 0.7959D-08, 0.3366D-08, 0.2383D-09,
     >    -.1893D-08/

      data (calcpts(j, 8), j = 1,neta) /-.1723D-06, -.2087D-06,
     >    -.2528D-06, -.3063D-06, -.3710D-06, -.4494D-06, -.5442D-06,
     >    -.6590D-06, -.7977D-06, -.9654D-06, -.1168D-05, -.1412D-05,
     >    -.1705D-05, -.2055D-05, -.2473D-05, -.2966D-05, -.3543D-05,
     >    -.4204D-05, -.4940D-05, -.5721D-05, -.6476D-05, -.7067D-05,
     >    -.7232D-05, -.6503D-05, -.4077D-05, 0.1394D-05, 0.1208D-04,
     >    0.3131D-04, 0.6393D-04, 0.1163D-03, 0.1956D-03, 0.3076D-03,
     >    0.4526D-03, 0.6210D-03, 0.7904D-03, 0.9301D-03, 0.1012D-02,
     >    0.1021D-02, 0.9584D-03, 0.8418D-03, 0.6956D-03, 0.5450D-03,
     >    0.4082D-03, 0.2947D-03, 0.2069D-03, 0.1421D-03, 0.9608D-04,
     >    0.6424D-04, 0.4255D-04, 0.2802D-04, 0.1842D-04, 0.1201D-04,
     >    0.7843D-05, 0.5108D-05, 0.3342D-05, 0.2159D-05, 0.1384D-05,
     >    0.8661D-06, 0.5282D-06, 0.3378D-06, 0.2262D-06, 0.1472D-06,
     >    0.6927D-07, 0.3732D-07, 0.3679D-07, -.8953D-08, -.4013D-07,
     >    0.5292D-08, -.9167D-08, -.1903D-07, -.2575D-07, -.3033D-07,
     >    -.3344D-07/

      data (calcpts(j, 9), j = 1,neta) /-.2523D-06, -.3056D-06,
     >    -.3702D-06, -.4485D-06, -.5433D-06, -.6580D-06, -.7969D-06,
     >    -.9650D-06, -.1168D-05, -.1414D-05, -.1710D-05, -.2067D-05,
     >    -.2496D-05, -.3010D-05, -.3621D-05, -.4344D-05, -.5189D-05,
     >    -.6157D-05, -.7236D-05, -.8381D-05, -.9489D-05, -.1036D-04,
     >    -.1061D-04, -.9553D-05, -.6026D-05, 0.1952D-05, 0.1753D-04,
     >    0.4560D-04, 0.9323D-04, 0.1697D-03, 0.2854D-03, 0.4491D-03,
     >    0.6608D-03, 0.9066D-03, 0.1154D-02, 0.1358D-02, 0.1477D-02,
     >    0.1489D-02, 0.1398D-02, 0.1228D-02, 0.1015D-02, 0.7949D-03,
     >    0.5953D-03, 0.4298D-03, 0.3017D-03, 0.2073D-03, 0.1401D-03,
     >    0.9366D-04, 0.6213D-04, 0.4095D-04, 0.2689D-04, 0.1763D-04,
     >    0.1148D-04, 0.7522D-05, 0.4865D-05, 0.3176D-05, 0.2071D-05,
     >    0.1367D-05, 0.9203D-06, 0.5863D-06, 0.3981D-06, 0.2880D-06,
     >    0.2103D-06, 0.1330D-06, 0.1016D-06, 0.1015D-06, 0.5597D-07,
     >    0.9162D-07, 0.7051D-07, 0.5611D-07, 0.4630D-07, 0.3963D-07,
     >    0.3507D-07/

      data (calcpts(j,10), j = 1,neta) /-.3692D-06, -.4473D-06,
     >    -.5418D-06, -.6564D-06, -.7951D-06, -.9630D-06, -.1166D-05,
     >    -.1412D-05, -.1710D-05, -.2069D-05, -.2503D-05, -.3025D-05,
     >    -.3653D-05, -.4405D-05, -.5300D-05, -.6359D-05, -.7596D-05,
     >    -.9014D-05, -.1059D-04, -.1228D-04, -.1390D-04, -.1519D-04,
     >    -.1557D-04, -.1406D-04, -.8939D-05, 0.2642D-05, 0.2530D-04,
     >    0.6612D-04, 0.1355D-03, 0.2468D-03, 0.4155D-03, 0.6540D-03,
     >    0.9626D-03, 0.1321D-02, 0.1681D-02, 0.1977D-02, 0.2151D-02,
     >    0.2168D-02, 0.2035D-02, 0.1787D-02, 0.1476D-02, 0.1157D-02,
     >    0.8661D-03, 0.6252D-03, 0.4389D-03, 0.3014D-03, 0.2036D-03,
     >    0.1361D-03, 0.9018D-04, 0.5939D-04, 0.3901D-04, 0.2549D-04,
     >    0.1665D-04, 0.1087D-04, 0.7076D-05, 0.4575D-05, 0.2974D-05,
     >    0.1947D-05, 0.1253D-05, 0.8136D-06, 0.5508D-06, 0.3657D-06,
     >    0.2582D-06, 0.1818D-06, 0.1055D-06, 0.7487D-07, 0.7522D-07,
     >    0.3003D-07, 0.6594D-07, 0.4496D-07, 0.3066D-07, 0.2093D-07,
     >    0.1430D-07/

      data (calcpts(j,11), j = 1,neta) /-.5396D-06, -.6538D-06,
     >    -.7919D-06, -.9593D-06, -.1162D-05, -.1408D-05, -.1705D-05,
     >    -.2064D-05, -.2499D-05, -.3024D-05, -.3658D-05, -.4422D-05,
     >    -.5340D-05, -.6440D-05, -.7748D-05, -.9296D-05, -.1111D-04,
     >    -.1318D-04, -.1550D-04, -.1796D-04, -.2035D-04, -.2225D-04,
     >    -.2285D-04, -.2070D-04, -.1334D-04, 0.3407D-05, 0.3622D-04,
     >    0.9542D-04, 0.1961D-03, 0.3577D-03, 0.6026D-03, 0.9490D-03,
     >    0.1397D-02, 0.1918D-02, 0.2441D-02, 0.2870D-02, 0.3121D-02,
     >    0.3145D-02, 0.2951D-02, 0.2590D-02, 0.2140D-02, 0.1676D-02,
     >    0.1255D-02, 0.9058D-03, 0.6357D-03, 0.4364D-03, 0.2948D-03,
     >    0.1969D-03, 0.1304D-03, 0.8575D-04, 0.5625D-04, 0.3676D-04,
     >    0.2393D-04, 0.1552D-04, 0.1008D-04, 0.6481D-05, 0.4160D-05,
     >    0.2653D-05, 0.1713D-05, 0.1101D-05, 0.6720D-06, 0.4159D-06,
     >    0.2361D-06, 0.1315D-06, 0.5727D-07, 0.4929D-07, 0.1966D-07,
     >    -.4596D-07, -.2396D-07, -.5443D-07, -.8516D-08, -.2265D-07,
     >    -.3228D-07/

      data (calcpts(j,12), j = 1,neta) /-.7869D-06, -.9534D-06,
     >    -.1155D-05, -.1399D-05, -.1695D-05, -.2053D-05, -.2486D-05,
     >    -.3010D-05, -.3644D-05, -.4410D-05, -.5335D-05, -.6449D-05,
     >    -.7788D-05, -.9392D-05, -.1130D-04, -.1356D-04, -.1620D-04,
     >    -.1923D-04, -.2262D-04, -.2623D-04, -.2974D-04, -.3256D-04,
     >    -.3352D-04, -.3053D-04, -.2001D-04, 0.4009D-05, 0.5124D-04,
     >    0.1366D-03, 0.2818D-03, 0.5152D-03, 0.8691D-03, 0.1370D-02,
     >    0.2017D-02, 0.2770D-02, 0.3525D-02, 0.4144D-02, 0.4503D-02,
     >    0.4535D-02, 0.4252D-02, 0.3731D-02, 0.3082D-02, 0.2414D-02,
     >    0.1807D-02, 0.1304D-02, 0.9149D-03, 0.6277D-03, 0.4238D-03,
     >    0.2828D-03, 0.1872D-03, 0.1229D-03, 0.8080D-04, 0.5295D-04,
     >    0.3401D-04, 0.2244D-04, 0.1462D-04, 0.9176D-05, 0.6076D-05,
     >    0.3683D-05, 0.2688D-05, 0.1315D-05, 0.1259D-05, 0.3109D-06,
     >    0.3326D-06, 0.5592D-06, 0.2594D-06, 0.5532D-07, -.8377D-07,
     >    -.1786D-06, -.2431D-06, -.2871D-06, -.3171D-06, -.3375D-06,
     >    0.3153D-06/

      data (calcpts(j,13), j = 1,neta) /-.1144D-05, -.1386D-05,
     >    -.1679D-05, -.2034D-05, -.2464D-05, -.2985D-05, -.3615D-05,
     >    -.4377D-05, -.5298D-05, -.6413D-05, -.7758D-05, -.9378D-05,
     >    -.1133D-04, -.1366D-04, -.1644D-04, -.1973D-04, -.2357D-04,
     >    -.2799D-04, -.3293D-04, -.3821D-04, -.4338D-04, -.4758D-04,
     >    -.4914D-04, -.4507D-04, -.3027D-04, 0.3885D-05, 0.7130D-04,
     >    0.1933D-03, 0.4011D-03, 0.7355D-03, 0.1243D-02, 0.1961D-02,
     >    0.2891D-02, 0.3971D-02, 0.5053D-02, 0.5938D-02, 0.6447D-02,
     >    0.6486D-02, 0.6077D-02, 0.5330D-02, 0.4401D-02, 0.3446D-02,
     >    0.2579D-02, 0.1861D-02, 0.1304D-02, 0.8946D-03, 0.6032D-03,
     >    0.4024D-03, 0.2659D-03, 0.1747D-03, 0.1141D-03, 0.7479D-04,
     >    0.4834D-04, 0.3132D-04, 0.2016D-04, 0.1329D-04, 0.8727D-05,
     >    0.5761D-05, 0.3467D-05, 0.2542D-05, 0.1215D-05, 0.1189D-05,
     >    0.2640D-06, 0.2996D-06, 0.5363D-06, 0.2436D-06, 0.4415D-07,
     >    -.9180D-07, -.1843D-06, -.2474D-06, -.2904D-06, -.3197D-06,
     >    0.3270D-06/

      data (calcpts(j,14), j = 1,neta) /-.1657D-05, -.2007D-05,
     >    -.2431D-05, -.2945D-05, -.3568D-05, -.4322D-05, -.5234D-05,
     >    -.6338D-05, -.7672D-05, -.9286D-05, -.1123D-04, -.1358D-04,
     >    -.1640D-04, -.1978D-04, -.2381D-04, -.2858D-04, -.3416D-04,
     >    -.4059D-04, -.4778D-04, -.5550D-04, -.6310D-04, -.6938D-04,
     >    -.7199D-04, -.6670D-04, -.4629D-04, 0.1539D-05, 0.9639D-04,
     >    0.2687D-03, 0.5627D-03, 0.1037D-02, 0.1757D-02, 0.2777D-02,
     >    0.4099D-02, 0.5632D-02, 0.7167D-02, 0.8417D-02, 0.9127D-02,
     >    0.9171D-02, 0.8582D-02, 0.7520D-02, 0.6206D-02, 0.4858D-02,
     >    0.3635D-02, 0.2621D-02, 0.1836D-02, 0.1258D-02, 0.8476D-03,
     >    0.5644D-03, 0.3724D-03, 0.2439D-03, 0.1595D-03, 0.1036D-03,
     >    0.6734D-04, 0.4349D-04, 0.2802D-04, 0.1813D-04, 0.1171D-04,
     >    0.7432D-05, 0.4671D-05, 0.2520D-05, 0.1690D-05, 0.1095D-05,
     >    0.4487D-06, 0.2198D-06, 0.2762D-06, -.1392D-06, -.4223D-06,
     >    0.5138D-07, -.7992D-07, -.1695D-06, -.2305D-06, -.2721D-06,
     >    -.3004D-06/

      data (calcpts(j,15), j = 1,neta) /-.2383D-05, -.2887D-05,
     >    -.3497D-05, -.4237D-05, -.5132D-05, -.6216D-05, -.7528D-05,
     >    -.9117D-05, -.1104D-04, -.1336D-04, -.1616D-04, -.1954D-04,
     >    -.2360D-04, -.2847D-04, -.3427D-04, -.4115D-04, -.4920D-04,
     >    -.5849D-04, -.6892D-04, -.8016D-04, -.9134D-04, -.1008D-03,
     >    -.1052D-03, -.9882D-04, -.7144D-04, -.5986D-05, 0.1249D-03,
     >    0.3641D-03, 0.7735D-03, 0.1435D-02, 0.2441D-02, 0.3868D-02,
     >    0.5719D-02, 0.7864D-02, 0.1001D-01, 0.1174D-01, 0.1271D-01,
     >    0.1274D-01, 0.1190D-01, 0.1042D-01, 0.8590D-02, 0.6721D-02,
     >    0.5026D-02, 0.3621D-02, 0.2535D-02, 0.1734D-02, 0.1166D-02,
     >    0.7749D-03, 0.5102D-03, 0.3340D-03, 0.2176D-03, 0.1414D-03,
     >    0.9123D-04, 0.5901D-04, 0.3835D-04, 0.2483D-04, 0.1587D-04,
     >    0.1004D-04, 0.6855D-05, 0.4387D-05, 0.3100D-05, 0.1738D-05,
     >    0.1237D-05, 0.1319D-05, 0.4663D-06, 0.5524D-06, 0.8235D-06,
     >    0.5539D-06, 0.3704D-06, 0.2452D-06, 0.1599D-06, 0.7685D-06,
     >    0.7290D-06/

      data (calcpts(j,16), j = 1,neta) /-.3399D-05, -.4118D-05,
     >    -.4987D-05, -.6042D-05, -.7320D-05, -.8866D-05, -.1074D-04,
     >    -.1300D-04, -.1574D-04, -.1905D-04, -.2305D-04, -.2787D-04,
     >    -.3367D-04, -.4062D-04, -.4892D-04, -.5875D-04, -.7030D-04,
     >    -.8363D-04, -.9867D-04, -.1150D-03, -.1314D-03, -.1457D-03,
     >    -.1534D-03, -.1467D-03, -.1116D-03, -.2496D-04, 0.1510D-03,
     >    0.4744D-03, 0.1031D-02, 0.1933D-02, 0.3310D-02, 0.5266D-02,
     >    0.7804D-02, 0.1074D-01, 0.1367D-01, 0.1602D-01, 0.1729D-01,
     >    0.1729D-01, 0.1611D-01, 0.1407D-01, 0.1159D-01, 0.9058D-02,
     >    0.6768D-02, 0.4871D-02, 0.3403D-02, 0.2322D-02, 0.1558D-02,
     >    0.1031D-02, 0.6766D-03, 0.4404D-03, 0.2855D-03, 0.1841D-03,
     >    0.1183D-03, 0.7551D-04, 0.4836D-04, 0.3095D-04, 0.1992D-04,
     >    0.1215D-04, 0.7833D-05, 0.5229D-05, 0.3152D-05, 0.2130D-05,
     >    0.1620D-05, 0.5744D-06, 0.7410D-06, 0.6133D-06, 0.7196D-07,
     >    0.3697D-06, 0.1186D-06, -.5265D-07, 0.4973D-06, 0.4179D-06,
     >    0.3637D-06/

      data (calcpts(j,17), j = 1,neta) /-.4787D-05, -.5799D-05,
     >    -.7024D-05, -.8510D-05, -.1031D-04, -.1249D-04, -.1512D-04,
     >    -.1831D-04, -.2217D-04, -.2684D-04, -.3247D-04, -.3927D-04,
     >    -.4744D-04, -.5726D-04, -.6897D-04, -.8288D-04, -.9925D-04,
     >    -.1182D-03, -.1397D-03, -.1632D-03, -.1872D-03, -.2089D-03,
     >    -.2225D-03, -.2175D-03, -.1756D-03, -.6628D-04, 0.1608D-03,
     >    0.5829D-03, 0.1315D-02, 0.2507D-02, 0.4333D-02, 0.6934D-02,
     >    0.1031D-01, 0.1423D-01, 0.1811D-01, 0.2118D-01, 0.2278D-01,
     >    0.2267D-01, 0.2103D-01, 0.1831D-01, 0.1505D-01, 0.1175D-01,
     >    0.8769D-02, 0.6299D-02, 0.4389D-02, 0.2984D-02, 0.1991D-02,
     >    0.1311D-02, 0.8538D-03, 0.5514D-03, 0.3545D-03, 0.2259D-03,
     >    0.1436D-03, 0.9038D-04, 0.5691D-04, 0.3544D-04, 0.2219D-04,
     >    0.1349D-04, 0.8014D-05, 0.4806D-05, 0.2954D-05, 0.1390D-05,
     >    0.7233D-06, 0.4491D-06, -.4337D-06, -.1554D-06, -.2076D-06,
     >    -.6975D-06, -.3643D-06, -.5918D-06, -.8006D-07, -.1856D-06,
     >    -.2575D-06/

      data (calcpts(j,18), j = 1,neta) /-.6622D-05, -.8023D-05,
     >    -.9718D-05, -.1177D-04, -.1426D-04, -.1728D-04, -.2092D-04,
     >    -.2534D-04, -.3068D-04, -.3714D-04, -.4494D-04, -.5435D-04,
     >    -.6568D-04, -.7930D-04, -.9556D-04, -.1149D-03, -.1377D-03,
     >    -.1643D-03, -.1945D-03, -.2280D-03, -.2629D-03, -.2957D-03,
     >    -.3192D-03, -.3204D-03, -.2763D-03, -.1477D-03, 0.1293D-03,
     >    0.6528D-03, 0.1571D-02, 0.3078D-02, 0.5398D-02, 0.8718D-02,
     >    0.1304D-01, 0.1805D-01, 0.2298D-01, 0.2680D-01, 0.2868D-01,
     >    0.2835D-01, 0.2612D-01, 0.2263D-01, 0.1854D-01, 0.1444D-01,
     >    0.1075D-01, 0.7700D-02, 0.5341D-02, 0.3610D-02, 0.2390D-02,
     >    0.1559D-02, 0.1004D-02, 0.6399D-03, 0.4053D-03, 0.2541D-03,
     >    0.1585D-03, 0.9786D-04, 0.6010D-04, 0.3658D-04, 0.2153D-04,
     >    0.1259D-04, 0.7535D-05, 0.4100D-05, 0.2275D-05, 0.6996D-06,
     >    0.4511D-06, 0.2193D-06, -.4223D-06, -.4336D-06, -.1650D-07,
     >    0.2570D-07, -.3993D-06, -.2249D-07, -.2200D-06, -.3545D-06,
     >    -.4461D-06/

      data (calcpts(j,19), j = 1,neta) /-.8944D-05, -.1084D-04,
     >    -.1313D-04, -.1590D-04, -.1926D-04, -.2333D-04, -.2826D-04,
     >    -.3423D-04, -.4144D-04, -.5018D-04, -.6073D-04, -.7346D-04,
     >    -.8880D-04, -.1072D-03, -.1293D-03, -.1556D-03, -.1868D-03,
     >    -.2231D-03, -.2649D-03, -.3117D-03, -.3616D-03, -.4106D-03,
     >    -.4504D-03, -.4657D-03, -.4291D-03, -.2940D-03, 0.1615D-04,
     >    0.6224D-03, 0.1702D-02, 0.3494D-02, 0.6278D-02, 0.1028D-01,
     >    0.1552D-01, 0.2159D-01, 0.2751D-01, 0.3198D-01, 0.3397D-01,
     >    0.3323D-01, 0.3029D-01, 0.2600D-01, 0.2118D-01, 0.1643D-01,
     >    0.1219D-01, 0.8681D-02, 0.5976D-02, 0.3995D-02, 0.2606D-02,
     >    0.1672D-02, 0.1050D-02, 0.6528D-03, 0.4005D-03, 0.2438D-03,
     >    0.1417D-03, 0.8085D-04, 0.5090D-04, 0.2916D-04, 0.1133D-04,
     >    0.9738D-05, -.7403D-06, 0.3042D-05, -.1345D-05, -.2214D-05,
     >    -.6755D-06, -.4174D-05, 0.1085D-06, -.1515D-05, -.2621D-05,
     >    -.3374D-05, 0.2779D-05, 0.2429D-05, 0.2191D-05, 0.2029D-05,
     >    0.1918D-05/

      data (calcpts(j,20), j = 1,neta) /-.1170D-04, -.1418D-04,
     >    -.1718D-04, -.2081D-04, -.2521D-04, -.3054D-04, -.3699D-04,
     >    -.4480D-04, -.5424D-04, -.6568D-04, -.7950D-04, -.9619D-04,
     >    -.1163D-03, -.1405D-03, -.1696D-03, -.2043D-03, -.2455D-03,
     >    -.2939D-03, -.3500D-03, -.4137D-03, -.4831D-03, -.5545D-03,
     >    -.6190D-03, -.6600D-03, -.6477D-03, -.5303D-03, -.2221D-03,
     >    0.4126D-03, 0.1576D-02, 0.3543D-02, 0.6635D-02, 0.1113D-01,
     >    0.1703D-01, 0.2388D-01, 0.3049D-01, 0.3532D-01, 0.3712D-01,
     >    0.3572D-01, 0.3197D-01, 0.2701D-01, 0.2174D-01, 0.1674D-01,
     >    0.1232D-01, 0.8686D-02, 0.5892D-02, 0.3851D-02, 0.2443D-02,
     >    0.1508D-02, 0.9013D-03, 0.5197D-03, 0.2912D-03, 0.1579D-03,
     >    0.7953D-04, 0.3170D-04, 0.7900D-05, -.3297D-05, -.7561D-05,
     >    -.6888D-05, -.7032D-05, -.1196D-04, -.4404D-05, -.6222D-05,
     >    -.5329D-05, -.2602D-05, -.5286D-05, -.4467D-06, -.1692D-05,
     >    -.2541D-05, -.3118D-05, -.3512D-05, -.3781D-05, -.3963D-05,
     >    -.4088D-05/

      data (calcpts(j,21), j = 1,neta) /-.1470D-04, -.1781D-04,
     >    -.2158D-04, -.2614D-04, -.3167D-04, -.3836D-04, -.4647D-04,
     >    -.5628D-04, -.6815D-04, -.8253D-04, -.9992D-04, -.1209D-03,
     >    -.1463D-03, -.1768D-03, -.2135D-03, -.2575D-03, -.3099D-03,
     >    -.3718D-03, -.4443D-03, -.5276D-03, -.6206D-03, -.7201D-03,
     >    -.8181D-03, -.8986D-03, -.9318D-03, -.8660D-03, -.6136D-03,
     >    -.3460D-04, 0.1080D-02, 0.3021D-02, 0.6132D-02, 0.1071D-01,
     >    0.1680D-01, 0.2386D-01, 0.3062D-01, 0.3531D-01, 0.3655D-01,
     >    0.3428D-01, 0.2968D-01, 0.2428D-01, 0.1905D-01, 0.1439D-01,
     >    0.1041D-01, 0.7176D-02, 0.4703D-02, 0.2916D-02, 0.1706D-02,
     >    0.9332D-03, 0.4593D-03, 0.1896D-03, 0.4181D-04, -.3145D-04,
     >    -.5890D-04, -.6627D-04, -.6098D-04, -.5508D-04, -.4132D-04,
     >    -.3532D-04, -.2972D-04, -.2194D-04, -.1481D-04, -.1025D-04,
     >    -.9558D-05, -.6966D-05, -.3075D-05, -.4965D-05, 0.4133D-06,
     >    -.4645D-06, -.1062D-05, -.1469D-05, -.1747D-05, -.1936D-05,
     >    -.2065D-05/

      data (calcpts(j,22), j = 1,neta) /-.1759D-04, -.2131D-04,
     >    -.2581D-04, -.3127D-04, -.3788D-04, -.4589D-04, -.5559D-04,
     >    -.6734D-04, -.8155D-04, -.9876D-04, -.1196D-03, -.1448D-03,
     >    -.1752D-03, -.2119D-03, -.2560D-03, -.3091D-03, -.3725D-03,
     >    -.4480D-03, -.5370D-03, -.6406D-03, -.7588D-03, -.8898D-03,
     >    -.1027D-02, -.1158D-02, -.1257D-02, -.1277D-02, -.1139D-02,
     >    -.7134D-03, 0.1963D-03, 0.1866D-02, 0.4629D-02, 0.8781D-02,
     >    0.1438D-01, 0.2091D-01, 0.2711D-01, 0.3112D-01, 0.3152D-01,
     >    0.2827D-01, 0.2292D-01, 0.1735D-01, 0.1266D-01, 0.9007D-02,
     >    0.6154D-02, 0.3926D-02, 0.2252D-02, 0.1077D-02, 0.3285D-03,
     >    -.1048D-03, -.3108D-03, -.3821D-03, -.3808D-03, -.3361D-03,
     >    -.2800D-03, -.2292D-03, -.1760D-03, -.1380D-03, -.1006D-03,
     >    -.7878D-04, -.5814D-04, -.4252D-04, -.2794D-04, -.2284D-04,
     >    -.1511D-04, -.1227D-04, -.8204D-05, -.3311D-05, -.4519D-05,
     >    -.5343D-05, 0.7633D-06, 0.3809D-06, 0.1204D-06, -.5698D-07,
     >    -.1778D-06/

      data (calcpts(j,23), j = 1,neta) /-.1989D-04, -.2409D-04,
     >    -.2918D-04, -.3536D-04, -.4284D-04, -.5190D-04, -.6287D-04,
     >    -.7616D-04, -.9223D-04, -.1117D-03, -.1353D-03, -.1638D-03,
     >    -.1983D-03, -.2399D-03, -.2901D-03, -.3506D-03, -.4231D-03,
     >    -.5098D-03, -.6129D-03, -.7342D-03, -.8750D-03, -.1036D-02,
     >    -.1212D-02, -.1397D-02, -.1569D-02, -.1695D-02, -.1710D-02,
     >    -.1509D-02, -.9289D-03, 0.2640D-03, 0.2358D-02, 0.5620D-02,
     >    0.1011D-01, 0.1541D-01, 0.2038D-01, 0.2331D-01, 0.2276D-01,
     >    0.1873D-01, 0.1286D-01, 0.7356D-02, 0.3497D-02, 0.1266D-02,
     >    0.3697D-04, -.7100D-03, -.1187D-02, -.1463D-02, -.1552D-02,
     >    -.1489D-02, -.1333D-02, -.1135D-02, -.9232D-03, -.7340D-03,
     >    -.5716D-03, -.4336D-03, -.3286D-03, -.2446D-03, -.1785D-03,
     >    -.1308D-03, -.9282D-04, -.6781D-04, -.5136D-04, -.3832D-04,
     >    -.2306D-04, -.1963D-04, -.1516D-04, -.9997D-05, -.4353D-05,
     >    -.5049D-05, -.5523D-05, -.5847D-05, 0.5996D-06, 0.4496D-06,
     >    0.3474D-06/

      data (calcpts(j,24), j = 1,neta) /-.2117D-04, -.2564D-04,
     >    -.3106D-04, -.3763D-04, -.4560D-04, -.5524D-04, -.6692D-04,
     >    -.8107D-04, -.9819D-04, -.1189D-03, -.1441D-03, -.1745D-03,
     >    -.2112D-03, -.2557D-03, -.3093D-03, -.3741D-03, -.4520D-03,
     >    -.5456D-03, -.6574D-03, -.7902D-03, -.9465D-03, -.1128D-02,
     >    -.1335D-02, -.1564D-02, -.1803D-02, -.2029D-02, -.2199D-02,
     >    -.2238D-02, -.2028D-02, -.1394D-02, -.1156D-03, 0.2017D-02,
     >    0.5066D-02, 0.8726D-02, 0.1210D-01, 0.1376D-01, 0.1244D-01,
     >    0.8023D-02, 0.2015D-02, -.3294D-02, -.6393D-02, -.7245D-02,
     >    -.6777D-02, -.5883D-02, -.5009D-02, -.4254D-02, -.3594D-02,
     >    -.2993D-02, -.2443D-02, -.1947D-02, -.1520D-02, -.1169D-02,
     >    -.8818D-03, -.6554D-03, -.4863D-03, -.3526D-03, -.2554D-03,
     >    -.1867D-03, -.1368D-03, -.9494D-04, -.6941D-04, -.4806D-04,
     >    -.3168D-04, -.2748D-04, -.1583D-04, -.1031D-04, -.1109D-04,
     >    -.4956D-05, -.5318D-05, -.5565D-05, 0.9334D-06, 0.8188D-06,
     >    0.7408D-06/

      data (calcpts(j,25), j = 1,neta) /-.2120D-04, -.2568D-04,
     >    -.3111D-04, -.3769D-04, -.4567D-04, -.5532D-04, -.6702D-04,
     >    -.8120D-04, -.9835D-04, -.1191D-03, -.1443D-03, -.1748D-03,
     >    -.2117D-03, -.2563D-03, -.3102D-03, -.3754D-03, -.4540D-03,
     >    -.5486D-03, -.6623D-03, -.7982D-03, -.9596D-03, -.1150D-02,
     >    -.1372D-02, -.1626D-02, -.1907D-02, -.2205D-02, -.2495D-02,
     >    -.2732D-02, -.2841D-02, -.2708D-02, -.2186D-02, -.1130D-02,
     >    0.5125D-03, 0.2538D-02, 0.4317D-02, 0.4811D-02, 0.2999D-02,
     >    -.1337D-02, -.7059D-02, -.1210D-01, -.1476D-01, -.1475D-01,
     >    -.1299D-01, -.1067D-01, -.8534D-02, -.6815D-02, -.5453D-02,
     >    -.4354D-02, -.3441D-02, -.2691D-02, -.2071D-02, -.1573D-02,
     >    -.1175D-02, -.8679D-03, -.6419D-03, -.4655D-03, -.3374D-03,
     >    -.2412D-03, -.1729D-03, -.1209D-03, -.8633D-04, -.6337D-04,
     >    -.4589D-04, -.3428D-04, -.2211D-04, -.1625D-04, -.1012D-04,
     >    -.1049D-04, -.4079D-05, -.4251D-05, -.4369D-05, -.4448D-05,
     >    -.4503D-05/

      data (calcpts(j,26), j = 1,neta) /-.2004D-04, -.2428D-04,
     >    -.2941D-04, -.3563D-04, -.4317D-04, -.5230D-04, -.6336D-04,
     >    -.7677D-04, -.9298D-04, -.1126D-03, -.1365D-03, -.1653D-03,
     >    -.2002D-03, -.2425D-03, -.2936D-03, -.3554D-03, -.4301D-03,
     >    -.5202D-03, -.6287D-03, -.7591D-03, -.9150D-03, -.1101D-02,
     >    -.1321D-02, -.1577D-02, -.1872D-02, -.2202D-02, -.2558D-02,
     >    -.2917D-02, -.3239D-02, -.3459D-02, -.3493D-02, -.3253D-02,
     >    -.2705D-02, -.1976D-02, -.1463D-02, -.1853D-02, -.3876D-02,
     >    -.7789D-02, -.1288D-01, -.1756D-01, -.2015D-01, -.1998D-01,
     >    -.1766D-01, -.1444D-01, -.1135D-01, -.8830D-02, -.6891D-02,
     >    -.5395D-02, -.4216D-02, -.3267D-02, -.2506D-02, -.1896D-02,
     >    -.1418D-02, -.1049D-02, -.7705D-03, -.5611D-03, -.4041D-03,
     >    -.2886D-03, -.2095D-03, -.1480D-03, -.1048D-03, -.7391D-04,
     >    -.5554D-04, -.3665D-04, -.2408D-04, -.1793D-04, -.1162D-04,
     >    -.1186D-04, -.5353D-05, -.5465D-05, -.5541D-05, 0.1074D-05,
     >    0.1039D-05/

      data (calcpts(j,27), j = 1,neta) /-.1799D-04, -.2179D-04,
     >    -.2640D-04, -.3199D-04, -.3875D-04, -.4695D-04, -.5688D-04,
     >    -.6891D-04, -.8347D-04, -.1011D-03, -.1225D-03, -.1484D-03,
     >    -.1798D-03, -.2178D-03, -.2637D-03, -.3193D-03, -.3866D-03,
     >    -.4678D-03, -.5659D-03, -.6842D-03, -.8261D-03, -.9964D-03,
     >    -.1200D-02, -.1440D-02, -.1722D-02, -.2048D-02, -.2416D-02,
     >    -.2821D-02, -.3243D-02, -.3654D-02, -.4010D-02, -.4266D-02,
     >    -.4407D-02, -.4507D-02, -.4803D-02, -.5710D-02, -.7709D-02,
     >    -.1103D-01, -.1532D-01, -.1951D-01, -.2220D-01, -.2245D-01,
     >    -.2037D-01, -.1695D-01, -.1334D-01, -.1025D-01, -.7864D-02,
     >    -.6080D-02, -.4713D-02, -.3649D-02, -.2801D-02, -.2129D-02,
     >    -.1595D-02, -.1187D-02, -.8684D-03, -.6365D-03, -.4599D-03,
     >    -.3334D-03, -.2381D-03, -.1680D-03, -.1235D-03, -.8495D-04,
     >    -.5929D-04, -.4665D-04, -.3378D-04, -.2077D-04, -.1432D-04,
     >    -.1447D-04, -.7903D-05, -.7972D-05, -.8019D-05, -.1384D-05,
     >    -.1406D-05/

      data (calcpts(j,28), j = 1,neta) /-.1544D-04, -.1871D-04,
     >    -.2266D-04, -.2745D-04, -.3326D-04, -.4030D-04, -.4882D-04,
     >    -.5915D-04, -.7165D-04, -.8681D-04, -.1052D-03, -.1274D-03,
     >    -.1543D-03, -.1870D-03, -.2264D-03, -.2742D-03, -.3321D-03,
     >    -.4021D-03, -.4866D-03, -.5888D-03, -.7117D-03, -.8598D-03,
     >    -.1037D-02, -.1249D-02, -.1501D-02, -.1797D-02, -.2141D-02,
     >    -.2533D-02, -.2970D-02, -.3441D-02, -.3929D-02, -.4414D-02,
     >    -.4893D-02, -.5410D-02, -.6097D-02, -.7195D-02, -.8996D-02,
     >    -.1169D-01, -.1512D-01, -.1871D-01, -.2144D-01, -.2235D-01,
     >    -.2108D-01, -.1813D-01, -.1453D-01, -.1116D-01, -.8466D-02,
     >    -.6453D-02, -.4965D-02, -.3831D-02, -.2950D-02, -.2251D-02,
     >    -.1699D-02, -.1272D-02, -.9380D-03, -.6869D-03, -.4997D-03,
     >    -.3571D-03, -.2600D-03, -.1819D-03, -.1299D-03, -.9075D-04,
     >    -.6469D-04, -.4510D-04, -.3205D-04, -.2558D-04, -.1904D-04,
     >    -.1246D-04, -.5857D-05, -.5898D-05, -.5926D-05, -.5946D-05,
     >    0.7080D-06/

      data (calcpts(j,29), j = 1,neta) /-.1277D-04, -.1547D-04,
     >    -.1874D-04, -.2270D-04, -.2750D-04, -.3332D-04, -.4037D-04,
     >    -.4891D-04, -.5924D-04, -.7178D-04, -.8697D-04, -.1054D-03,
     >    -.1276D-03, -.1546D-03, -.1873D-03, -.2268D-03, -.2748D-03,
     >    -.3327D-03, -.4028D-03, -.4876D-03, -.5898D-03, -.7133D-03,
     >    -.8618D-03, -.1040D-02, -.1253D-02, -.1506D-02, -.1804D-02,
     >    -.2152D-02, -.2552D-02, -.3002D-02, -.3499D-02, -.4038D-02,
     >    -.4618D-02, -.5268D-02, -.6058D-02, -.7120D-02, -.8624D-02,
     >    -.1070D-01, -.1334D-01, -.1624D-01, -.1880D-01, -.2025D-01,
     >    -.1999D-01, -.1802D-01, -.1495D-01, -.1167D-01, -.8823D-02,
     >    -.6636D-02, -.5040D-02, -.3866D-02, -.2982D-02, -.2286D-02,
     >    -.1743D-02, -.1308D-02, -.9757D-03, -.7144D-03, -.5247D-03,
     >    -.3806D-03, -.2689D-03, -.1968D-03, -.1376D-03, -.9809D-04,
     >    -.7179D-04, -.5204D-04, -.3221D-04, -.2566D-04, -.1907D-04,
     >    -.1246D-04, -.5827D-05, -.5852D-05, -.5869D-05, 0.7861D-06,
     >    0.7782D-06/

      data (calcpts(j,30), j = 1,neta) /-.1024D-04, -.1241D-04,
     >    -.1503D-04, -.1821D-04, -.2206D-04, -.2673D-04, -.3238D-04,
     >    -.3923D-04, -.4753D-04, -.5758D-04, -.6977D-04, -.8452D-04,
     >    -.1024D-03, -.1240D-03, -.1502D-03, -.1820D-03, -.2205D-03,
     >    -.2670D-03, -.3233D-03, -.3915D-03, -.4738D-03, -.5733D-03,
     >    -.6933D-03, -.8376D-03, -.1011D-02, -.1218D-02, -.1464D-02,
     >    -.1754D-02, -.2094D-02, -.2485D-02, -.2929D-02, -.3427D-02,
     >    -.3981D-02, -.4606D-02, -.5340D-02, -.6249D-02, -.7431D-02,
     >    -.8975D-02, -.1091D-01, -.1312D-01, -.1531D-01, -.1698D-01,
     >    -.1754D-01, -.1668D-01, -.1456D-01, -.1177D-01, -.9012D-02,
     >    -.6734D-02, -.5036D-02, -.3817D-02, -.2926D-02, -.2254D-02,
     >    -.1725D-02, -.1312D-02, -.9835D-03, -.7334D-03, -.5357D-03,
     >    -.3905D-03, -.2849D-03, -.2056D-03, -.1461D-03, -.9979D-04,
     >    -.7335D-04, -.5350D-04, -.3361D-04, -.2701D-04, -.2039D-04,
     >    -.1376D-04, -.7115D-05, -.7130D-05, -.7141D-05, -.4813D-06,
     >    -.4861D-06/

      data (calcpts(j,31), j = 1,neta) /-.8016D-05, -.9712D-05,
     >    -.1176D-04, -.1425D-04, -.1727D-04, -.2092D-04, -.2535D-04,
     >    -.3071D-04, -.3720D-04, -.4507D-04, -.5461D-04, -.6616D-04,
     >    -.8015D-04, -.9711D-04, -.1176D-03, -.1425D-03, -.1726D-03,
     >    -.2091D-03, -.2532D-03, -.3066D-03, -.3712D-03, -.4493D-03,
     >    -.5436D-03, -.6573D-03, -.7940D-03, -.9580D-03, -.1154D-02,
     >    -.1386D-02, -.1661D-02, -.1980D-02, -.2349D-02, -.2769D-02,
     >    -.3242D-02, -.3776D-02, -.4389D-02, -.5113D-02, -.6000D-02,
     >    -.7105D-02, -.8465D-02, -.1006D-01, -.1178D-01, -.1334D-01,
     >    -.1435D-01, -.1440D-01, -.1333D-01, -.1135D-01, -.8994D-02,
     >    -.6786D-02, -.5024D-02, -.3742D-02, -.2832D-02, -.2172D-02,
     >    -.1671D-02, -.1280D-02, -.9694D-03, -.7248D-03, -.5396D-03,
     >    -.3939D-03, -.2879D-03, -.2083D-03, -.1486D-03, -.1088D-03,
     >    -.7564D-04, -.5574D-04, -.3580D-04, -.2918D-04, -.1588D-04,
     >    -.1590D-04, -.9249D-05, -.9259D-05, -.2599D-05, -.2604D-05,
     >    -.2607D-05/

      data (calcpts(j,32), j = 1,neta) /-.6153D-05, -.7455D-05,
     >    -.9030D-05, -.1094D-04, -.1326D-04, -.1606D-04, -.1946D-04,
     >    -.2357D-04, -.2856D-04, -.3460D-04, -.4192D-04, -.5078D-04,
     >    -.6152D-04, -.7454D-04, -.9028D-04, -.1094D-03, -.1325D-03,
     >    -.1605D-03, -.1944D-03, -.2355D-03, -.2851D-03, -.3451D-03,
     >    -.4177D-03, -.5052D-03, -.6106D-03, -.7374D-03, -.8890D-03,
     >    -.1070D-02, -.1284D-02, -.1536D-02, -.1828D-02, -.2163D-02,
     >    -.2543D-02, -.2970D-02, -.3452D-02, -.4003D-02, -.4647D-02,
     >    -.5416D-02, -.6342D-02, -.7441D-02, -.8684D-02, -.9956D-02,
     >    -.1104D-01, -.1161D-01, -.1141D-01, -.1034D-01, -.8643D-02,
     >    -.6739D-02, -.5023D-02, -.3691D-02, -.2739D-02, -.2071D-02,
     >    -.1588D-02, -.1222D-02, -.9344D-03, -.7078D-03, -.5294D-03,
     >    -.3914D-03, -.2865D-03, -.2075D-03, -.1497D-03, -.1065D-03,
     >    -.7590D-04, -.5396D-04, -.3800D-04, -.2670D-04, -.1872D-04,
     >    -.1273D-04, -.8742D-05, -.6082D-05, -.4086D-05, -.2756D-05,
     >    -.1425D-05/

      data (calcpts(j,33), j = 1,neta) /-.4652D-05, -.5636D-05,
     >    -.6827D-05, -.8271D-05, -.1002D-04, -.1214D-04, -.1471D-04,
     >    -.1782D-04, -.2159D-04, -.2616D-04, -.3169D-04, -.3839D-04,
     >    -.4651D-04, -.5635D-04, -.6826D-04, -.8269D-04, -.1002D-03,
     >    -.1214D-03, -.1470D-03, -.1780D-03, -.2156D-03, -.2610D-03,
     >    -.3160D-03, -.3822D-03, -.4622D-03, -.5584D-03, -.6736D-03,
     >    -.8114D-03, -.9751D-03, -.1168D-02, -.1392D-02, -.1651D-02,
     >    -.1944D-02, -.2273D-02, -.2639D-02, -.3046D-02, -.3505D-02,
     >    -.4031D-02, -.4646D-02, -.5373D-02, -.6219D-02, -.7152D-02,
     >    -.8076D-02, -.8811D-02, -.9122D-02, -.8814D-02, -.7864D-02,
     >    -.6474D-02, -.4981D-02, -.3676D-02, -.2685D-02, -.1986D-02,
     >    -.1501D-02, -.1151D-02, -.8859D-03, -.6775D-03, -.5128D-03,
     >    -.3839D-03, -.2835D-03, -.2077D-03, -.1505D-03, -.1086D-03,
     >    -.7804D-04, -.5541D-04, -.3944D-04, -.2813D-04, -.2014D-04,
     >    -.1415D-04, -.1016D-04, -.7497D-05, -.5500D-05, -.4169D-05,
     >    -.2837D-05/

      data (calcpts(j,34), j = 1,neta) /-.3472D-05, -.4207D-05,
     >    -.5096D-05, -.6174D-05, -.7481D-05, -.9063D-05, -.1098D-04,
     >    -.1330D-04, -.1611D-04, -.1952D-04, -.2366D-04, -.2866D-04,
     >    -.3472D-04, -.4207D-04, -.5095D-04, -.6173D-04, -.7479D-04,
     >    -.9059D-04, -.1097D-03, -.1329D-03, -.1609D-03, -.1949D-03,
     >    -.2359D-03, -.2855D-03, -.3452D-03, -.4172D-03, -.5035D-03,
     >    -.6068D-03, -.7296D-03, -.8745D-03, -.1044D-02, -.1239D-02,
     >    -.1460D-02, -.1707D-02, -.1978D-02, -.2274D-02, -.2596D-02,
     >    -.2953D-02, -.3356D-02, -.3824D-02, -.4374D-02, -.5007D-02,
     >    -.5697D-02, -.6361D-02, -.6858D-02, -.7012D-02, -.6688D-02,
     >    -.5890D-02, -.4790D-02, -.3645D-02, -.2667D-02, -.1936D-02,
     >    -.1429D-02, -.1079D-02, -.8275D-03, -.6368D-03, -.4866D-03,
     >    -.3682D-03, -.2751D-03, -.2032D-03, -.1480D-03, -.1074D-03,
     >    -.7742D-04, -.5545D-04, -.3947D-04, -.2815D-04, -.1949D-04,
     >    -.1416D-04, -.1017D-04, -.6839D-05, -.4841D-05, -.3509D-05,
     >    -.2843D-05/

      data (calcpts(j,35), j = 1,neta) /-.2566D-05, -.3109D-05,
     >    -.3766D-05, -.4563D-05, -.5529D-05, -.6698D-05, -.8115D-05,
     >    -.9832D-05, -.1191D-04, -.1443D-04, -.1748D-04, -.2118D-04,
     >    -.2566D-04, -.3109D-04, -.3766D-04, -.4562D-04, -.5527D-04,
     >    -.6696D-04, -.8110D-04, -.9824D-04, -.1190D-03, -.1441D-03,
     >    -.1744D-03, -.2110D-03, -.2552D-03, -.3085D-03, -.3724D-03,
     >    -.4489D-03, -.5400D-03, -.6474D-03, -.7730D-03, -.9178D-03,
     >    -.1082D-02, -.1264D-02, -.1463D-02, -.1676D-02, -.1901D-02,
     >    -.2142D-02, -.2405D-02, -.2702D-02, -.3048D-02, -.3455D-02,
     >    -.3924D-02, -.4429D-02, -.4904D-02, -.5239D-02, -.5304D-02,
     >    -.5007D-02, -.4363D-02, -.3511D-02, -.2647D-02, -.1922D-02,
     >    -.1388D-02, -.1022D-02, -.7714D-03, -.5912D-03, -.4549D-03,
     >    -.3477D-03, -.2625D-03, -.1960D-03, -.1440D-03, -.1054D-03,
     >    -.7611D-04, -.5480D-04, -.3881D-04, -.2749D-04, -.1949D-04,
     >    -.1350D-04, -.9501D-05, -.6836D-05, -.4838D-05, -.3505D-05,
     >    -.2173D-05/

      data (calcpts(j,36), j = 1,neta) /-.1882D-05, -.2280D-05,
     >    -.2762D-05, -.3346D-05, -.4055D-05, -.4912D-05, -.5951D-05,
     >    -.7210D-05, -.8734D-05, -.1058D-04, -.1282D-04, -.1553D-04,
     >    -.1882D-04, -.2280D-04, -.2762D-04, -.3346D-04, -.4054D-04,
     >    -.4910D-04, -.5948D-04, -.7205D-04, -.8724D-04, -.1056D-03,
     >    -.1279D-03, -.1548D-03, -.1872D-03, -.2263D-03, -.2732D-03,
     >    -.3294D-03, -.3962D-03, -.4752D-03, -.5675D-03, -.6739D-03,
     >    -.7942D-03, -.9276D-03, -.1072D-02, -.1224D-02, -.1382D-02,
     >    -.1545D-02, -.1717D-02, -.1904D-02, -.2118D-02, -.2370D-02,
     >    -.2669D-02, -.3013D-02, -.3381D-02, -.3720D-02, -.3946D-02,
     >    -.3963D-02, -.3711D-02, -.3205D-02, -.2557D-02, -.1912D-02,
     >    -.1379D-02, -.9917D-03, -.7282D-03, -.5492D-03, -.4207D-03,
     >    -.3236D-03, -.2470D-03, -.1871D-03, -.1391D-03, -.1025D-03,
     >    -.7449D-04, -.5384D-04, -.3852D-04, -.2786D-04, -.1986D-04,
     >    -.1387D-04, -.9868D-05, -.6536D-05, -.4537D-05, -.3204D-05,
     >    -.2538D-05/

      data (calcpts(j,37), j = 1,neta) /-.1371D-05, -.1661D-05,
     >    -.2012D-05, -.2438D-05, -.2954D-05, -.3579D-05, -.4336D-05,
     >    -.5253D-05, -.6363D-05, -.7709D-05, -.9341D-05, -.1132D-04,
     >    -.1371D-04, -.1661D-04, -.2012D-04, -.2438D-04, -.2953D-04,
     >    -.3577D-04, -.4333D-04, -.5249D-04, -.6356D-04, -.7697D-04,
     >    -.9319D-04, -.1128D-03, -.1364D-03, -.1649D-03, -.1991D-03,
     >    -.2400D-03, -.2888D-03, -.3463D-03, -.4136D-03, -.4912D-03,
     >    -.5787D-03, -.6755D-03, -.7795D-03, -.8880D-03, -.9986D-03,
     >    -.1110D-02, -.1223D-02, -.1341D-02, -.1472D-02, -.1625D-02,
     >    -.1808D-02, -.2026D-02, -.2278D-02, -.2546D-02, -.2787D-02,
     >    -.2939D-02, -.2933D-02, -.2727D-02, -.2338D-02, -.1851D-02,
     >    -.1374D-02, -.9852D-03, -.7055D-03, -.5172D-03, -.3894D-03,
     >    -.2988D-03, -.2296D-03, -.1756D-03, -.1323D-03, -.9832D-04,
     >    -.7234D-04, -.5302D-04, -.3836D-04, -.2703D-04, -.1970D-04,
     >    -.1370D-04, -.9704D-05, -.7038D-05, -.5039D-05, -.3706D-05,
     >    -.2373D-05/

      data (calcpts(j,38), j = 1,neta) /-.9934D-06, -.1204D-05,
     >    -.1458D-05, -.1767D-05, -.2140D-05, -.2593D-05, -.3141D-05,
     >    -.3806D-05, -.4611D-05, -.5586D-05, -.6768D-05, -.8200D-05,
     >    -.9934D-05, -.1204D-04, -.1458D-04, -.1766D-04, -.2140D-04,
     >    -.2592D-04, -.3140D-04, -.3803D-04, -.4606D-04, -.5577D-04,
     >    -.6753D-04, -.8172D-04, -.9885D-04, -.1195D-03, -.1443D-03,
     >    -.1739D-03, -.2093D-03, -.2510D-03, -.2997D-03, -.3559D-03,
     >    -.4192D-03, -.4891D-03, -.5638D-03, -.6411D-03, -.7187D-03,
     >    -.7950D-03, -.8699D-03, -.9455D-03, -.1026D-02, -.1117D-02,
     >    -.1226D-02, -.1358D-02, -.1518D-02, -.1702D-02, -.1895D-02,
     >    -.2067D-02, -.2170D-02, -.2155D-02, -.1991D-02, -.1696D-02,
     >    -.1334D-02, -.9843D-03, -.7016D-03, -.5005D-03, -.3659D-03,
     >    -.2753D-03, -.2113D-03, -.1620D-03, -.1240D-03, -.9339D-04,
     >    -.6940D-04, -.5141D-04, -.3741D-04, -.2675D-04, -.1942D-04,
     >    -.1342D-04, -.9422D-05, -.6756D-05, -.4756D-05, -.3423D-05,
     >    -.2090D-05/

      data (calcpts(j,39), j = 1,neta) /-.7169D-06, -.8686D-06,
     >    -.1052D-05, -.1275D-05, -.1545D-05, -.1871D-05, -.2267D-05,
     >    -.2747D-05, -.3327D-05, -.4031D-05, -.4884D-05, -.5917D-05,
     >    -.7169D-05, -.8685D-05, -.1052D-04, -.1275D-04, -.1544D-04,
     >    -.1871D-04, -.2266D-04, -.2745D-04, -.3324D-04, -.4025D-04,
     >    -.4873D-04, -.5897D-04, -.7134D-04, -.8623D-04, -.1041D-03,
     >    -.1255D-03, -.1510D-03, -.1811D-03, -.2163D-03, -.2568D-03,
     >    -.3024D-03, -.3527D-03, -.4062D-03, -.4612D-03, -.5158D-03,
     >    -.5685D-03, -.6187D-03, -.6676D-03, -.7174D-03, -.7719D-03,
     >    -.8355D-03, -.9132D-03, -.1009D-02, -.1126D-02, -.1259D-02,
     >    -.1399D-02, -.1521D-02, -.1591D-02, -.1573D-02, -.1446D-02,
     >    -.1226D-02, -.9584D-03, -.7031D-03, -.4988D-03, -.3545D-03,
     >    -.2587D-03, -.1947D-03, -.1492D-03, -.1147D-03, -.8761D-04,
     >    -.6616D-04, -.4956D-04, -.3623D-04, -.2623D-04, -.1890D-04,
     >    -.1357D-04, -.9571D-05, -.6905D-05, -.4905D-05, -.3572D-05,
     >    -.2239D-05/

      data (calcpts(j,40), j = 1,neta) /-.5152D-06, -.6243D-06,
     >    -.7562D-06, -.9162D-06, -.1110D-05, -.1345D-05, -.1629D-05,
     >    -.1974D-05, -.2391D-05, -.2897D-05, -.3510D-05, -.4253D-05,
     >    -.5152D-05, -.6242D-05, -.7561D-05, -.9160D-05, -.1110D-04,
     >    -.1344D-04, -.1628D-04, -.1973D-04, -.2389D-04, -.2893D-04,
     >    -.3502D-04, -.4238D-04, -.5127D-04, -.6197D-04, -.7482D-04,
     >    -.9021D-04, -.1085D-03, -.1302D-03, -.1554D-03, -.1845D-03,
     >    -.2173D-03, -.2533D-03, -.2915D-03, -.3306D-03, -.3691D-03,
     >    -.4057D-03, -.4398D-03, -.4717D-03, -.5030D-03, -.5357D-03,
     >    -.5727D-03, -.6176D-03, -.6733D-03, -.7430D-03, -.8276D-03,
     >    -.9246D-03, -.1025D-02, -.1112D-02, -.1159D-02, -.1142D-02,
     >    -.1046D-02, -.8819D-03, -.6861D-03, -.5007D-03, -.3536D-03,
     >    -.2504D-03, -.1824D-03, -.1371D-03, -.1051D-03, -.8080D-04,
     >    -.6168D-04, -.4655D-04, -.3462D-04, -.2542D-04, -.1848D-04,
     >    -.1335D-04, -.9553D-05, -.6820D-05, -.4820D-05, -.3420D-05,
     >    -.2420D-05/

      data (calcpts(j,41), j = 1,neta) /-.3691D-06, -.4472D-06,
     >    -.5416D-06, -.6563D-06, -.7952D-06, -.9633D-06, -.1167D-05,
     >    -.1414D-05, -.1713D-05, -.2075D-05, -.2514D-05, -.3046D-05,
     >    -.3691D-05, -.4471D-05, -.5416D-05, -.6562D-05, -.7950D-05,
     >    -.9630D-05, -.1167D-04, -.1413D-04, -.1711D-04, -.2072D-04,
     >    -.2509D-04, -.3036D-04, -.3672D-04, -.4439D-04, -.5360D-04,
     >    -.6462D-04, -.7775D-04, -.9324D-04, -.1113D-03, -.1322D-03,
     >    -.1556D-03, -.1813D-03, -.2086D-03, -.2364D-03, -.2635D-03,
     >    -.2890D-03, -.3124D-03, -.3336D-03, -.3535D-03, -.3734D-03,
     >    -.3951D-03, -.4206D-03, -.4523D-03, -.4925D-03, -.5429D-03,
     >    -.6043D-03, -.6745D-03, -.7467D-03, -.8083D-03, -.8408D-03,
     >    -.8255D-03, -.7532D-03, -.6325D-03, -.4898D-03, -.3558D-03,
     >    -.2501D-03, -.1766D-03, -.1284D-03, -.9645D-04, -.7386D-04,
     >    -.5680D-04, -.4333D-04, -.3267D-04, -.2427D-04, -.1780D-04,
     >    -.1294D-04, -.9270D-05, -.6670D-05, -.4737D-05, -.3337D-05,
     >    -.2337D-05/

      data (calcpts(j,42), j = 1,neta) /-.2638D-06, -.3195D-06,
     >    -.3871D-06, -.4689D-06, -.5682D-06, -.6883D-06, -.8339D-06,
     >    -.1010D-05, -.1224D-05, -.1483D-05, -.1797D-05, -.2177D-05,
     >    -.2637D-05, -.3195D-05, -.3870D-05, -.4688D-05, -.5680D-05,
     >    -.6881D-05, -.8335D-05, -.1010D-04, -.1223D-04, -.1481D-04,
     >    -.1793D-04, -.2169D-04, -.2624D-04, -.3172D-04, -.3830D-04,
     >    -.4617D-04, -.5555D-04, -.6662D-04, -.7954D-04, -.9441D-04,
     >    -.1111D-03, -.1295D-03, -.1489D-03, -.1686D-03, -.1878D-03,
     >    -.2057D-03, -.2218D-03, -.2361D-03, -.2490D-03, -.2613D-03,
     >    -.2741D-03, -.2886D-03, -.3064D-03, -.3289D-03, -.3579D-03,
     >    -.3944D-03, -.4389D-03, -.4895D-03, -.5414D-03, -.5851D-03,
     >    -.6073D-03, -.5946D-03, -.5408D-03, -.4524D-03, -.3489D-03,
     >    -.2524D-03, -.1767D-03, -.1244D-03, -.9029D-04, -.6776D-04,
     >    -.5190D-04, -.3990D-04, -.3044D-04, -.2297D-04, -.1704D-04,
     >    -.1250D-04, -.9105D-05, -.6505D-05, -.4638D-05, -.3305D-05,
     >    -.2372D-05/

      data (calcpts(j,43), j = 1,neta) /-.1880D-06, -.2277D-06,
     >    -.2758D-06, -.3342D-06, -.4049D-06, -.4906D-06, -.5944D-06,
     >    -.7201D-06, -.8723D-06, -.1057D-05, -.1281D-05, -.1551D-05,
     >    -.1879D-05, -.2277D-05, -.2758D-05, -.3342D-05, -.4049D-05,
     >    -.4904D-05, -.5941D-05, -.7196D-05, -.8714D-05, -.1055D-04,
     >    -.1278D-04, -.1546D-04, -.1870D-04, -.2261D-04, -.2729D-04,
     >    -.3291D-04, -.3959D-04, -.4748D-04, -.5669D-04, -.6728D-04,
     >    -.7919D-04, -.9224D-04, -.1060D-03, -.1200D-03, -.1336D-03,
     >    -.1462D-03, -.1573D-03, -.1670D-03, -.1755D-03, -.1833D-03,
     >    -.1910D-03, -.1993D-03, -.2093D-03, -.2217D-03, -.2379D-03,
     >    -.2588D-03, -.2852D-03, -.3172D-03, -.3537D-03, -.3909D-03,
     >    -.4218D-03, -.4371D-03, -.4269D-03, -.3872D-03, -.3228D-03,
     >    -.2480D-03, -.1787D-03, -.1247D-03, -.8754D-04, -.6341D-04,
     >    -.4755D-04, -.3642D-04, -.2802D-04, -.2135D-04, -.1609D-04,
     >    -.1195D-04, -.8754D-05, -.6354D-05, -.4554D-05, -.3288D-05,
     >    -.2288D-05/

      data (calcpts(j,44), j = 1,neta) /-.1338D-06, -.1621D-06,
     >    -.1963D-06, -.2378D-06, -.2880D-06, -.3489D-06, -.4227D-06,
     >    -.5121D-06, -.6204D-06, -.7516D-06, -.9106D-06, -.1103D-05,
     >    -.1337D-05, -.1619D-05, -.1961D-05, -.2376D-05, -.2879D-05,
     >    -.3488D-05, -.4225D-05, -.5117D-05, -.6197D-05, -.7504D-05,
     >    -.9086D-05, -.1100D-04, -.1330D-04, -.1608D-04, -.1941D-04,
     >    -.2340D-04, -.2815D-04, -.3376D-04, -.4031D-04, -.4784D-04,
     >    -.5630D-04, -.6557D-04, -.7537D-04, -.8529D-04, -.9487D-04,
     >    -.1037D-03, -.1115D-03, -.1182D-03, -.1238D-03, -.1288D-03,
     >    -.1335D-03, -.1384D-03, -.1439D-03, -.1508D-03, -.1596D-03,
     >    -.1712D-03, -.1863D-03, -.2053D-03, -.2284D-03, -.2546D-03,
     >    -.2812D-03, -.3031D-03, -.3135D-03, -.3057D-03, -.2764D-03,
     >    -.2298D-03, -.1760D-03, -.1263D-03, -.8785D-04, -.6152D-04,
     >    -.4446D-04, -.3332D-04, -.2552D-04, -.1959D-04, -.1499D-04,
     >    -.1126D-04, -.8392D-05, -.6126D-05, -.4459D-05, -.3193D-05,
     >    -.2259D-05/

      data (calcpts(j,45), j = 1,neta) /-.9473D-07, -.1149D-06,
     >    -.1392D-06, -.1688D-06, -.2045D-06, -.2477D-06, -.3001D-06,
     >    -.3636D-06, -.4404D-06, -.5337D-06, -.6466D-06, -.7833D-06,
     >    -.9490D-06, -.1150D-05, -.1393D-05, -.1687D-05, -.2044D-05,
     >    -.2476D-05, -.3000D-05, -.3634D-05, -.4400D-05, -.5328D-05,
     >    -.6451D-05, -.7807D-05, -.9444D-05, -.1142D-04, -.1378D-04,
     >    -.1662D-04, -.1999D-04, -.2397D-04, -.2862D-04, -.3397D-04,
     >    -.3997D-04, -.4655D-04, -.5350D-04, -.6052D-04, -.6730D-04,
     >    -.7351D-04, -.7896D-04, -.8357D-04, -.8742D-04, -.9068D-04,
     >    -.9360D-04, -.9648D-04, -.9962D-04, -.1034D-03, -.1082D-03,
     >    -.1145D-03, -.1228D-03, -.1336D-03, -.1473D-03, -.1640D-03,
     >    -.1827D-03, -.2017D-03, -.2172D-03, -.2243D-03, -.2184D-03,
     >    -.1970D-03, -.1634D-03, -.1247D-03, -.8922D-04, -.6185D-04,
     >    -.4319D-04, -.3121D-04, -.2337D-04, -.1791D-04, -.1377D-04,
     >    -.1051D-04, -.7907D-05, -.5907D-05, -.4307D-05, -.3107D-05,
     >    -.2241D-05/

      data (calcpts(j,46), j = 1,neta) /-.6701D-07, -.8119D-07,
     >    -.9870D-07, -.1195D-06, -.1447D-06, -.1754D-06, -.2127D-06,
     >    -.2576D-06, -.3120D-06, -.3781D-06, -.4581D-06, -.5551D-06,
     >    -.6724D-06, -.8147D-06, -.9868D-06, -.1196D-05, -.1449D-05,
     >    -.1755D-05, -.2125D-05, -.2575D-05, -.3118D-05, -.3776D-05,
     >    -.4571D-05, -.5532D-05, -.6691D-05, -.8089D-05, -.9765D-05,
     >    -.1177D-04, -.1416D-04, -.1699D-04, -.2028D-04, -.2407D-04,
     >    -.2832D-04, -.3298D-04, -.3790D-04, -.4286D-04, -.4765D-04,
     >    -.5203D-04, -.5584D-04, -.5904D-04, -.6167D-04, -.6384D-04,
     >    -.6570D-04, -.6744D-04, -.6924D-04, -.7133D-04, -.7392D-04,
     >    -.7731D-04, -.8181D-04, -.8777D-04, -.9555D-04, -.1054D-03,
     >    -.1173D-03, -.1308D-03, -.1443D-03, -.1552D-03, -.1602D-03,
     >    -.1556D-03, -.1401D-03, -.1158D-03, -.8818D-04, -.6290D-04,
     >    -.4347D-04, -.3029D-04, -.2185D-04, -.1636D-04, -.1252D-04,
     >    -.9628D-05, -.7341D-05, -.5528D-05, -.4108D-05, -.3008D-05,
     >    -.2181D-05/

      data (calcpts(j,47), j = 1,neta) /-.4757D-07, -.5758D-07,
     >    -.6968D-07, -.8450D-07, -.1024D-06, -.1242D-06, -.1503D-06,
     >    -.1822D-06, -.2207D-06, -.2675D-06, -.3240D-06, -.3926D-06,
     >    -.4757D-06, -.5763D-06, -.6981D-06, -.8458D-06, -.1025D-05,
     >    -.1241D-05, -.1504D-05, -.1821D-05, -.2206D-05, -.2671D-05,
     >    -.3234D-05, -.3913D-05, -.4734D-05, -.5722D-05, -.6908D-05,
     >    -.8329D-05, -.1002D-04, -.1202D-04, -.1435D-04, -.1702D-04,
     >    -.2003D-04, -.2333D-04, -.2680D-04, -.3031D-04, -.3369D-04,
     >    -.3677D-04, -.3945D-04, -.4168D-04, -.4349D-04, -.4495D-04,
     >    -.4616D-04, -.4724D-04, -.4829D-04, -.4945D-04, -.5086D-04,
     >    -.5267D-04, -.5507D-04, -.5828D-04, -.6256D-04, -.6814D-04,
     >    -.7521D-04, -.8374D-04, -.9332D-04, -.1029D-03, -.1107D-03,
     >    -.1141D-03, -.1106D-03, -.9943D-04, -.8204D-04, -.6228D-04,
     >    -.4429D-04, -.3052D-04, -.2122D-04, -.1528D-04, -.1143D-04,
     >    -.8745D-05, -.6726D-05, -.5126D-05, -.3859D-05, -.2859D-05,
     >    -.2092D-05/

      data (calcpts(j,48), j = 1,neta) /-.3318D-07, -.4036D-07,
     >    -.4933D-07, -.5977D-07, -.7242D-07, -.8763D-07, -.1062D-06,
     >    -.1288D-06, -.1559D-06, -.1890D-06, -.2290D-06, -.2774D-06,
     >    -.3361D-06, -.4072D-06, -.4933D-06, -.5976D-06, -.7240D-06,
     >    -.8771D-06, -.1062D-05, -.1287D-05, -.1558D-05, -.1887D-05,
     >    -.2285D-05, -.2765D-05, -.3345D-05, -.4043D-05, -.4881D-05,
     >    -.5885D-05, -.7080D-05, -.8490D-05, -.1014D-04, -.1203D-04,
     >    -.1415D-04, -.1648D-04, -.1893D-04, -.2141D-04, -.2379D-04,
     >    -.2597D-04, -.2785D-04, -.2941D-04, -.3066D-04, -.3166D-04,
     >    -.3246D-04, -.3313D-04, -.3376D-04, -.3442D-04, -.3519D-04,
     >    -.3615D-04, -.3743D-04, -.3914D-04, -.4144D-04, -.4450D-04,
     >    -.4849D-04, -.5354D-04, -.5964D-04, -.6647D-04, -.7329D-04,
     >    -.7875D-04, -.8108D-04, -.7854D-04, -.7046D-04, -.5801D-04,
     >    -.4393D-04, -.3116D-04, -.2142D-04, -.1486D-04, -.1069D-04,
     >    -.7993D-05, -.6113D-05, -.4700D-05, -.3586D-05, -.2700D-05,
     >    -.2000D-05/

      data (calcpts(j,49), j = 1,neta) /-.2387D-07, -.2858D-07,
     >    -.3511D-07, -.4218D-07, -.5120D-07, -.6191D-07, -.7500D-07,
     >    -.9087D-07, -.1101D-06, -.1334D-06, -.1616D-06, -.1957D-06,
     >    -.2372D-06, -.2873D-06, -.3480D-06, -.4217D-06, -.5109D-06,
     >    -.6189D-06, -.7496D-06, -.9081D-06, -.1100D-05, -.1332D-05,
     >    -.1612D-05, -.1951D-05, -.2360D-05, -.2853D-05, -.3444D-05,
     >    -.4152D-05, -.4995D-05, -.5990D-05, -.7151D-05, -.8486D-05,
     >    -.9986D-05, -.1163D-04, -.1336D-04, -.1510D-04, -.1678D-04,
     >    -.1831D-04, -.1963D-04, -.2073D-04, -.2160D-04, -.2228D-04,
     >    -.2282D-04, -.2326D-04, -.2364D-04, -.2402D-04, -.2445D-04,
     >    -.2496D-04, -.2563D-04, -.2653D-04, -.2775D-04, -.2939D-04,
     >    -.3159D-04, -.3444D-04, -.3805D-04, -.4239D-04, -.4725D-04,
     >    -.5208D-04, -.5593D-04, -.5753D-04, -.5566D-04, -.4986D-04,
     >    -.4097D-04, -.3095D-04, -.2190D-04, -.1502D-04, -.1040D-04,
     >    -.7471D-05, -.5584D-05, -.4271D-05, -.3284D-05, -.2504D-05,
     >    -.1884D-05/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0, -1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsclca = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

c   the subtracted term from eq (10) of PLB347 (1995) 143 - 151
c   longitudinal gluon initiated piece with C_F color factor in front
c   prop. to e_H^2
      subroutine sclcf_CT(eta, xi, xsclcf)
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsclcf
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /-.1526D-12, -.3323D-12,
     >    -.3907D-12, -.6839D-12, -.1600D-11, -.3278D-11, -.4479D-11,
     >    -.9221D-11, -.1419D-10, -.2587D-10, -.4799D-10, -.7559D-10,
     >    -.1451D-09, -.2621D-09, -.4500D-09, -.8116D-09, -.1474D-08,
     >    -.2638D-08, -.4581D-08, -.8208D-08, -.1447D-07, -.2578D-07,
     >    -.4622D-07, -.8126D-07, -.1450D-06, -.2590D-06, -.4588D-06,
     >    -.8141D-06, -.1438D-05, -.2515D-05, -.4340D-05, -.7316D-05,
     >    -.1190D-04, -.1839D-04, -.2652D-04, -.3509D-04, -.4205D-04,
     >    -.4536D-04, -.4420D-04, -.3927D-04, -.3230D-04, -.2498D-04,
     >    -.1844D-04, -.1315D-04, -.9162D-05, -.6272D-05, -.4243D-05,
     >    -.2849D-05, -.1902D-05, -.1265D-05, -.8396D-06, -.5559D-06,
     >    -.3675D-06, -.2427D-06, -.1601D-06, -.1055D-06, -.6950D-07,
     >    -.4569D-07, -.3001D-07, -.1968D-07, -.1290D-07, -.8435D-08,
     >    -.5514D-08, -.3594D-08, -.4557D-08, -.3116D-08, -.2128D-08,
     >    -.1452D-08, -.9914D-09, -.6763D-09, -.4610D-09, -.3142D-09,
     >    -.2142D-09/

      data (calcpts(j, 2), j = 1,neta) /-.1979D-12, -.6116D-12,
     >    -.5642D-12, -.1280D-11, -.3041D-11, -.3966D-11, -.7910D-11,
     >    -.1347D-10, -.2032D-10, -.3911D-10, -.7392D-10, -.1265D-09,
     >    -.2222D-09, -.4048D-09, -.6812D-09, -.1207D-08, -.2240D-08,
     >    -.3794D-08, -.6782D-08, -.1216D-07, -.2132D-07, -.3805D-07,
     >    -.6763D-07, -.1202D-06, -.2143D-06, -.3812D-06, -.6731D-06,
     >    -.1196D-05, -.2112D-05, -.3695D-05, -.6377D-05, -.1074D-04,
     >    -.1746D-04, -.2699D-04, -.3893D-04, -.5150D-04, -.6170D-04,
     >    -.6657D-04, -.6486D-04, -.5763D-04, -.4739D-04, -.3665D-04,
     >    -.2706D-04, -.1930D-04, -.1345D-04, -.9205D-05, -.6227D-05,
     >    -.4180D-05, -.2791D-05, -.1856D-05, -.1232D-05, -.8156D-06,
     >    -.5392D-06, -.3562D-06, -.2349D-06, -.1548D-06, -.1020D-06,
     >    -.6705D-07, -.4403D-07, -.2888D-07, -.1893D-07, -.1238D-07,
     >    -.8090D-08, -.5273D-08, -.3429D-08, -.4572D-08, -.3123D-08,
     >    -.2131D-08, -.1455D-08, -.9921D-09, -.6764D-09, -.4611D-09,
     >    -.3143D-09/

      data (calcpts(j, 3), j = 1,neta) /-.2047D-12, -.4402D-12,
     >    -.5594D-12, -.1213D-11, -.3449D-11, -.4707D-11, -.9446D-11,
     >    -.1768D-10, -.2612D-10, -.5612D-10, -.9231D-10, -.1774D-09,
     >    -.3093D-09, -.5600D-09, -.9492D-09, -.1660D-08, -.3105D-08,
     >    -.5504D-08, -.9882D-08, -.1767D-07, -.3091D-07, -.5602D-07,
     >    -.9938D-07, -.1750D-06, -.3126D-06, -.5560D-06, -.9846D-06,
     >    -.1747D-05, -.3092D-05, -.5405D-05, -.9329D-05, -.1574D-04,
     >    -.2559D-04, -.3955D-04, -.5706D-04, -.7550D-04, -.9047D-04,
     >    -.9761D-04, -.9510D-04, -.8452D-04, -.6949D-04, -.5375D-04,
     >    -.3968D-04, -.2830D-04, -.1972D-04, -.1350D-04, -.9131D-05,
     >    -.6129D-05, -.4092D-05, -.2721D-05, -.1806D-05, -.1196D-05,
     >    -.7903D-06, -.5220D-06, -.3444D-06, -.2268D-06, -.1495D-06,
     >    -.9828D-07, -.6453D-07, -.4234D-07, -.2774D-07, -.1814D-07,
     >    -.1186D-07, -.7726D-08, -.5024D-08, -.3262D-08, -.4580D-08,
     >    -.3126D-08, -.2133D-08, -.1455D-08, -.9916D-09, -.6762D-09,
     >    -.4608D-09/

      data (calcpts(j, 4), j = 1,neta) /-.3980D-12, -.9437D-12,
     >    -.1372D-11, -.2820D-11, -.4058D-11, -.7437D-11, -.1433D-10,
     >    -.2712D-10, -.4303D-10, -.7171D-10, -.1424D-09, -.2625D-09,
     >    -.4584D-09, -.8241D-09, -.1411D-08, -.2519D-08, -.4554D-08,
     >    -.8235D-08, -.1450D-07, -.2605D-07, -.4624D-07, -.8090D-07,
     >    -.1457D-06, -.2586D-06, -.4593D-06, -.8177D-06, -.1447D-05,
     >    -.2562D-05, -.4530D-05, -.7931D-05, -.1368D-04, -.2309D-04,
     >    -.3753D-04, -.5802D-04, -.8370D-04, -.1107D-03, -.1327D-03,
     >    -.1432D-03, -.1395D-03, -.1240D-03, -.1019D-03, -.7884D-04,
     >    -.5820D-04, -.4152D-04, -.2892D-04, -.1980D-04, -.1339D-04,
     >    -.8990D-05, -.6002D-05, -.3991D-05, -.2649D-05, -.1754D-05,
     >    -.1159D-05, -.7655D-06, -.5050D-06, -.3328D-06, -.2192D-06,
     >    -.1441D-06, -.9463D-07, -.6208D-07, -.4067D-07, -.2659D-07,
     >    -.1738D-07, -.1133D-07, -.7365D-08, -.4782D-08, -.3097D-08,
     >    -.4585D-08, -.3129D-08, -.2134D-08, -.1454D-08, -.9915D-09,
     >    -.6759D-09/

      data (calcpts(j, 5), j = 1,neta) /-.8492D-12, -.1819D-11,
     >    -.1594D-11, -.4321D-11, -.7149D-11, -.1278D-10, -.2327D-10,
     >    -.4772D-10, -.5993D-10, -.1160D-09, -.2318D-09, -.3877D-09,
     >    -.6909D-09, -.1180D-08, -.2148D-08, -.3792D-08, -.6799D-08,
     >    -.1217D-07, -.2153D-07, -.3862D-07, -.6690D-07, -.1197D-06,
     >    -.2149D-06, -.3801D-06, -.6744D-06, -.1203D-05, -.2123D-05,
     >    -.3762D-05, -.6655D-05, -.1164D-04, -.2008D-04, -.3386D-04,
     >    -.5505D-04, -.8509D-04, -.1227D-03, -.1624D-03, -.1945D-03,
     >    -.2099D-03, -.2045D-03, -.1818D-03, -.1495D-03, -.1156D-03,
     >    -.8534D-04, -.6087D-04, -.4240D-04, -.2902D-04, -.1963D-04,
     >    -.1318D-04, -.8800D-05, -.5851D-05, -.3883D-05, -.2571D-05,
     >    -.1699D-05, -.1122D-05, -.7403D-06, -.4877D-06, -.3213D-06,
     >    -.2112D-06, -.1387D-06, -.9099D-07, -.5960D-07, -.3897D-07,
     >    -.2547D-07, -.1659D-07, -.1079D-07, -.7007D-08, -.4537D-08,
     >    -.2929D-08, -.4588D-08, -.3128D-08, -.2132D-08, -.1454D-08,
     >    -.9910D-09/

      data (calcpts(j, 6), j = 1,neta) /-.1553D-11, -.2541D-11,
     >    -.1878D-11, -.5611D-11, -.1141D-10, -.1789D-10, -.3021D-10,
     >    -.5472D-10, -.9229D-10, -.1729D-09, -.3173D-09, -.5690D-09,
     >    -.1020D-08, -.1828D-08, -.3025D-08, -.5610D-08, -.9985D-08,
     >    -.1771D-07, -.3101D-07, -.5642D-07, -.9798D-07, -.1758D-06,
     >    -.3135D-06, -.5555D-06, -.9859D-06, -.1752D-05, -.3104D-05,
     >    -.5519D-05, -.9739D-05, -.1703D-04, -.2940D-04, -.4958D-04,
     >    -.8056D-04, -.1245D-03, -.1798D-03, -.2378D-03, -.2849D-03,
     >    -.3075D-03, -.2996D-03, -.2663D-03, -.2190D-03, -.1694D-03,
     >    -.1250D-03, -.8919D-04, -.6212D-04, -.4252D-04, -.2876D-04,
     >    -.1931D-04, -.1289D-04, -.8570D-05, -.5687D-05, -.3765D-05,
     >    -.2488D-05, -.1643D-05, -.1084D-05, -.7140D-06, -.4703D-06,
     >    -.3092D-06, -.2030D-06, -.1332D-06, -.8723D-07, -.5703D-07,
     >    -.3726D-07, -.2427D-07, -.1579D-07, -.1025D-07, -.6635D-08,
     >    -.4282D-08, -.2759D-08, -.4583D-08, -.3124D-08, -.2130D-08,
     >    -.1452D-08/

      data (calcpts(j, 7), j = 1,neta) /-.1951D-11, -.3023D-11,
     >    -.3552D-11, -.6768D-11, -.1542D-10, -.3304D-10, -.4905D-10,
     >    -.8922D-10, -.1383D-09, -.2580D-09, -.4742D-09, -.7587D-09,
     >    -.1494D-08, -.2591D-08, -.4467D-08, -.8113D-08, -.1468D-07,
     >    -.2642D-07, -.4627D-07, -.8186D-07, -.1445D-06, -.2566D-06,
     >    -.4593D-06, -.8145D-06, -.1443D-05, -.2580D-05, -.4555D-05,
     >    -.8069D-05, -.1426D-04, -.2494D-04, -.4300D-04, -.7255D-04,
     >    -.1179D-03, -.1822D-03, -.2629D-03, -.3479D-03, -.4170D-03,
     >    -.4500D-03, -.4386D-03, -.3898D-03, -.3205D-03, -.2479D-03,
     >    -.1830D-03, -.1305D-03, -.9092D-04, -.6223D-04, -.4210D-04,
     >    -.2826D-04, -.1886D-04, -.1254D-04, -.8322D-05, -.5508D-05,
     >    -.3640D-05, -.2404D-05, -.1585D-05, -.1044D-05, -.6877D-06,
     >    -.4521D-06, -.2967D-06, -.1947D-06, -.1275D-06, -.8334D-07,
     >    -.5444D-07, -.3546D-07, -.2305D-07, -.1496D-07, -.9679D-08,
     >    -.6249D-08, -.4026D-08, -.2581D-08, -.4573D-08, -.3117D-08,
     >    -.2125D-08/

      data (calcpts(j, 8), j = 1,neta) /-.3202D-11, -.4660D-11,
     >    -.6771D-11, -.1185D-10, -.2005D-10, -.3729D-10, -.7634D-10,
     >    -.1351D-09, -.2145D-09, -.3817D-09, -.7858D-09, -.1241D-08,
     >    -.2195D-08, -.3904D-08, -.6628D-08, -.1198D-07, -.2138D-07,
     >    -.3774D-07, -.6762D-07, -.1203D-06, -.2116D-06, -.3773D-06,
     >    -.6675D-06, -.1188D-05, -.2118D-05, -.3769D-05, -.6672D-05,
     >    -.1182D-04, -.2086D-04, -.3649D-04, -.6290D-04, -.1060D-03,
     >    -.1724D-03, -.2665D-03, -.3843D-03, -.5086D-03, -.6095D-03,
     >    -.6578D-03, -.6413D-03, -.5699D-03, -.4687D-03, -.3625D-03,
     >    -.2676D-03, -.1909D-03, -.1329D-03, -.9100D-04, -.6154D-04,
     >    -.4130D-04, -.2757D-04, -.1833D-04, -.1216D-04, -.8049D-05,
     >    -.5319D-05, -.3511D-05, -.2316D-05, -.1525D-05, -.1004D-05,
     >    -.6600D-06, -.4332D-06, -.2840D-06, -.1861D-06, -.1216D-06,
     >    -.7942D-07, -.5172D-07, -.3361D-07, -.2180D-07, -.1412D-07,
     >    -.9108D-08, -.5862D-08, -.3756D-08, -.2397D-08, -.4558D-08,
     >    -.3106D-08/

      data (calcpts(j, 9), j = 1,neta) /-.2020D-11, -.5453D-11,
     >    -.5060D-11, -.1092D-10, -.3336D-10, -.5003D-10, -.9420D-10,
     >    -.1724D-09, -.2710D-09, -.5493D-09, -.9121D-09, -.1654D-08,
     >    -.2942D-08, -.5559D-08, -.9296D-08, -.1649D-07, -.3097D-07,
     >    -.5391D-07, -.9745D-07, -.1736D-06, -.3048D-06, -.5456D-06,
     >    -.9811D-06, -.1731D-05, -.3082D-05, -.5485D-05, -.9689D-05,
     >    -.1719D-04, -.3034D-04, -.5312D-04, -.9155D-04, -.1544D-03,
     >    -.2510D-03, -.3881D-03, -.5599D-03, -.7412D-03, -.8885D-03,
     >    -.9592D-03, -.9351D-03, -.8313D-03, -.6838D-03, -.5289D-03,
     >    -.3904D-03, -.2785D-03, -.1939D-03, -.1327D-03, -.8974D-04,
     >    -.6022D-04, -.4019D-04, -.2671D-04, -.1772D-04, -.1173D-04,
     >    -.7748D-05, -.5113D-05, -.3372D-05, -.2221D-05, -.1462D-05,
     >    -.9603D-06, -.6301D-06, -.4131D-06, -.2704D-06, -.1766D-06,
     >    -.1153D-06, -.7510D-07, -.4878D-07, -.3163D-07, -.2046D-07,
     >    -.1318D-07, -.8481D-08, -.5434D-08, -.3464D-08, -.2200D-08,
     >    -.4531D-08/

      data (calcpts(j,10), j = 1,neta) /-.4329D-11, -.8017D-11,
     >    -.1468D-10, -.1912D-10, -.4450D-10, -.7630D-10, -.1318D-09,
     >    -.2570D-09, -.4401D-09, -.7766D-09, -.1464D-08, -.2495D-08,
     >    -.4473D-08, -.8107D-08, -.1423D-07, -.2431D-07, -.4600D-07,
     >    -.7971D-07, -.1427D-06, -.2553D-06, -.4500D-06, -.8034D-06,
     >    -.1424D-05, -.2529D-05, -.4495D-05, -.7996D-05, -.1418D-04,
     >    -.2511D-04, -.4424D-04, -.7734D-04, -.1333D-03, -.2246D-03,
     >    -.3650D-03, -.5643D-03, -.8141D-03, -.1078D-02, -.1292D-02,
     >    -.1396D-02, -.1361D-02, -.1210D-02, -.9954D-03, -.7700D-03,
     >    -.5684D-03, -.4053D-03, -.2823D-03, -.1931D-03, -.1306D-03,
     >    -.8760D-04, -.5845D-04, -.3884D-04, -.2576D-04, -.1704D-04,
     >    -.1125D-04, -.7428D-05, -.4896D-05, -.3223D-05, -.2121D-05,
     >    -.1393D-05, -.9137D-06, -.5988D-06, -.3918D-06, -.2558D-06,
     >    -.1670D-06, -.1086D-06, -.7052D-07, -.4570D-07, -.2953D-07,
     >    -.1901D-07, -.1223D-07, -.7824D-08, -.4982D-08, -.3159D-08,
     >    -.1992D-08/

      data (calcpts(j,11), j = 1,neta) /-.7740D-11, -.1319D-10,
     >    -.1127D-10, -.3932D-10, -.7316D-10, -.1185D-09, -.2253D-09,
     >    -.4273D-09, -.7028D-09, -.1122D-08, -.2186D-08, -.3787D-08,
     >    -.6692D-08, -.1282D-07, -.2105D-07, -.3761D-07, -.6681D-07,
     >    -.1181D-06, -.2093D-06, -.3678D-06, -.6528D-06, -.1171D-05,
     >    -.2076D-05, -.3676D-05, -.6540D-05, -.1168D-04, -.2046D-04,
     >    -.3634D-04, -.6416D-04, -.1120D-03, -.1930D-03, -.3253D-03,
     >    -.5284D-03, -.8167D-03, -.1178D-02, -.1560D-02, -.1872D-02,
     >    -.2022D-02, -.1973D-02, -.1755D-02, -.1444D-02, -.1117D-02,
     >    -.8243D-03, -.5878D-03, -.4092D-03, -.2799D-03, -.1892D-03,
     >    -.1269D-03, -.8463D-04, -.5622D-04, -.3727D-04, -.2465D-04,
     >    -.1627D-04, -.1073D-04, -.7072D-05, -.4653D-05, -.3060D-05,
     >    -.2009D-05, -.1317D-05, -.8626D-06, -.5641D-06, -.3682D-06,
     >    -.2400D-06, -.1560D-06, -.1012D-06, -.6552D-07, -.4230D-07,
     >    -.2721D-07, -.1746D-07, -.1116D-07, -.7094D-08, -.4488D-08,
     >    -.2823D-08/

      data (calcpts(j,12), j = 1,neta) /-.5151D-11, -.2014D-10,
     >    -.2631D-10, -.4695D-10, -.1052D-09, -.1791D-09, -.3485D-09,
     >    -.6448D-09, -.8489D-09, -.1639D-08, -.3087D-08, -.5399D-08,
     >    -.9179D-08, -.1779D-07, -.2957D-07, -.5384D-07, -.9629D-07,
     >    -.1688D-06, -.3013D-06, -.5323D-06, -.9346D-06, -.1675D-05,
     >    -.2995D-05, -.5313D-05, -.9461D-05, -.1675D-04, -.2958D-04,
     >    -.5241D-04, -.9238D-04, -.1612D-03, -.2776D-03, -.4674D-03,
     >    -.7593D-03, -.1173D-02, -.1694D-02, -.2243D-02, -.2692D-02,
     >    -.2911D-02, -.2842D-02, -.2528D-02, -.2081D-02, -.1610D-02,
     >    -.1188D-02, -.8472D-03, -.5896D-03, -.4031D-03, -.2724D-03,
     >    -.1826D-03, -.1217D-03, -.8082D-04, -.5355D-04, -.3539D-04,
     >    -.2335D-04, -.1540D-04, -.1014D-04, -.6664D-05, -.4380D-05,
     >    -.2873D-05, -.1881D-05, -.1231D-05, -.8042D-06, -.5242D-06,
     >    -.3414D-06, -.2216D-06, -.1435D-06, -.9286D-07, -.5979D-07,
     >    -.3840D-07, -.2459D-07, -.1567D-07, -.9930D-08, -.6256D-08,
     >    -.3925D-08/

      data (calcpts(j,13), j = 1,neta) /-.1063D-10, -.3297D-10,
     >    -.2997D-10, -.6987D-10, -.1541D-09, -.1764D-09, -.4019D-09,
     >    -.7702D-09, -.1329D-08, -.2305D-08, -.4447D-08, -.7561D-08,
     >    -.1408D-07, -.2476D-07, -.4276D-07, -.7568D-07, -.1385D-06,
     >    -.2503D-06, -.4271D-06, -.7685D-06, -.1350D-05, -.2407D-05,
     >    -.4305D-05, -.7545D-05, -.1347D-04, -.2398D-04, -.4235D-04,
     >    -.7490D-04, -.1318D-03, -.2300D-03, -.3951D-03, -.6661D-03,
     >    -.1080D-02, -.1670D-02, -.2411D-02, -.3195D-02, -.3840D-02,
     >    -.4154D-02, -.4059D-02, -.3614D-02, -.2975D-02, -.2302D-02,
     >    -.1699D-02, -.1211D-02, -.8425D-03, -.5757D-03, -.3887D-03,
     >    -.2604D-03, -.1735D-03, -.1151D-03, -.7620D-04, -.5031D-04,
     >    -.3317D-04, -.2184D-04, -.1437D-04, -.9435D-05, -.6194D-05,
     >    -.4058D-05, -.2655D-05, -.1734D-05, -.1131D-05, -.7362D-06,
     >    -.4786D-06, -.3101D-06, -.2004D-06, -.1293D-06, -.8305D-07,
     >    -.5313D-07, -.3392D-07, -.2152D-07, -.1358D-07, -.8518D-08,
     >    -.5306D-08/

      data (calcpts(j,14), j = 1,neta) /-.2328D-10, -.4109D-10,
     >    -.6336D-10, -.1073D-09, -.2166D-09, -.4000D-09, -.6766D-09,
     >    -.1298D-08, -.1955D-08, -.3561D-08, -.6533D-08, -.1121D-07,
     >    -.1965D-07, -.3564D-07, -.6167D-07, -.1104D-06, -.2020D-06,
     >    -.3533D-06, -.6145D-06, -.1108D-05, -.1935D-05, -.3441D-05,
     >    -.6092D-05, -.1088D-04, -.1924D-04, -.3402D-04, -.5993D-04,
     >    -.1058D-03, -.1861D-03, -.3243D-03, -.5572D-03, -.9357D-03,
     >    -.1517D-02, -.2345D-02, -.3386D-02, -.4491D-02, -.5401D-02,
     >    -.5853D-02, -.5726D-02, -.5103D-02, -.4204D-02, -.3254D-02,
     >    -.2401D-02, -.1710D-02, -.1189D-02, -.8120D-03, -.5478D-03,
     >    -.3666D-03, -.2439D-03, -.1616D-03, -.1069D-03, -.7047D-04,
     >    -.4639D-04, -.3050D-04, -.2003D-04, -.1314D-04, -.8608D-05,
     >    -.5629D-05, -.3675D-05, -.2396D-05, -.1559D-05, -.1012D-05,
     >    -.6559D-06, -.4238D-06, -.2728D-06, -.1752D-06, -.1121D-06,
     >    -.7147D-07, -.4532D-07, -.2857D-07, -.1789D-07, -.1112D-07,
     >    -.6848D-08/

      data (calcpts(j,15), j = 1,neta) /-.1614D-10, -.4985D-10,
     >    -.4193D-10, -.9810D-10, -.3052D-09, -.5043D-09, -.7527D-09,
     >    -.1530D-08, -.2329D-08, -.3894D-08, -.8865D-08, -.1514D-07,
     >    -.2616D-07, -.4793D-07, -.8227D-07, -.1503D-06, -.2650D-06,
     >    -.4862D-06, -.8500D-06, -.1523D-05, -.2672D-05, -.4765D-05,
     >    -.8445D-05, -.1498D-04, -.2667D-04, -.4723D-04, -.8297D-04,
     >    -.1465D-03, -.2575D-03, -.4472D-03, -.7674D-03, -.1288D-02,
     >    -.2085D-02, -.3222D-02, -.4654D-02, -.6183D-02, -.7451D-02,
     >    -.8090D-02, -.7929D-02, -.7077D-02, -.5836D-02, -.4518D-02,
     >    -.3333D-02, -.2373D-02, -.1648D-02, -.1124D-02, -.7570D-03,
     >    -.5058D-03, -.3360D-03, -.2222D-03, -.1467D-03, -.9650D-04,
     >    -.6339D-04, -.4159D-04, -.2725D-04, -.1782D-04, -.1165D-04,
     >    -.7591D-05, -.4940D-05, -.3209D-05, -.2080D-05, -.1345D-05,
     >    -.8676D-06, -.5575D-06, -.3569D-06, -.2278D-06, -.1446D-06,
     >    -.9136D-07, -.5733D-07, -.3575D-07, -.2207D-07, -.1349D-07,
     >    -.8146D-08/

      data (calcpts(j,16), j = 1,neta) /-.3779D-10, -.7818D-10,
     >    -.8196D-10, -.1363D-09, -.4489D-09, -.6883D-09, -.1116D-08,
     >    -.2256D-08, -.3465D-08, -.5744D-08, -.1173D-07, -.2133D-07,
     >    -.3697D-07, -.6801D-07, -.1161D-06, -.2106D-06, -.3768D-06,
     >    -.6683D-06, -.1181D-05, -.2105D-05, -.3688D-05, -.6626D-05,
     >    -.1173D-04, -.2059D-04, -.3645D-04, -.6435D-04, -.1129D-03,
     >    -.1981D-03, -.3482D-03, -.6031D-03, -.1029D-02, -.1724D-02,
     >    -.2789D-02, -.4304D-02, -.6223D-02, -.8281D-02, -.1000D-01,
     >    -.1089D-01, -.1071D-01, -.9576D-02, -.7907D-02, -.6124D-02,
     >    -.4516D-02, -.3212D-02, -.2228D-02, -.1516D-02, -.1019D-02,
     >    -.6792D-03, -.4498D-03, -.2967D-03, -.1952D-03, -.1281D-03,
     >    -.8383D-04, -.5480D-04, -.3576D-04, -.2330D-04, -.1516D-04,
     >    -.9831D-05, -.6362D-05, -.4111D-05, -.2647D-05, -.1699D-05,
     >    -.1088D-05, -.6925D-06, -.4388D-06, -.2768D-06, -.1733D-06,
     >    -.1077D-06, -.6648D-07, -.4052D-07, -.2428D-07, -.1431D-07,
     >    -.8243D-08/

      data (calcpts(j,17), j = 1,neta) /-.6224D-10, -.1157D-09,
     >    -.2071D-09, -.2779D-09, -.5111D-09, -.1001D-08, -.1657D-08,
     >    -.3073D-08, -.4998D-08, -.8622D-08, -.1677D-07, -.2878D-07,
     >    -.5099D-07, -.9334D-07, -.1627D-06, -.2805D-06, -.5088D-06,
     >    -.9048D-06, -.1583D-05, -.2830D-05, -.4949D-05, -.8740D-05,
     >    -.1552D-04, -.2748D-04, -.4835D-04, -.8505D-04, -.1485D-03,
     >    -.2604D-03, -.4541D-03, -.7820D-03, -.1333D-02, -.2222D-02,
     >    -.3583D-02, -.5523D-02, -.7988D-02, -.1065D-01, -.1292D-01,
     >    -.1413D-01, -.1394D-01, -.1251D-01, -.1035D-01, -.8017D-02,
     >    -.5909D-02, -.4197D-02, -.2903D-02, -.1970D-02, -.1319D-02,
     >    -.8760D-03, -.5778D-03, -.3793D-03, -.2484D-03, -.1620D-03,
     >    -.1055D-03, -.6854D-04, -.4444D-04, -.2874D-04, -.1856D-04,
     >    -.1194D-04, -.7653D-05, -.4891D-05, -.3114D-05, -.1972D-05,
     >    -.1244D-05, -.7786D-06, -.4830D-06, -.2973D-06, -.1809D-06,
     >    -.1085D-06, -.6401D-07, -.3663D-07, -.2033D-07, -.1066D-07,
     >    -.5102D-08/

      data (calcpts(j,18), j = 1,neta) /-.6221D-10, -.1474D-09,
     >    -.1298D-09, -.3912D-09, -.6718D-09, -.1189D-08, -.2102D-08,
     >    -.4431D-08, -.5705D-08, -.1121D-07, -.2129D-07, -.3646D-07,
     >    -.6552D-07, -.1150D-06, -.1978D-06, -.3621D-06, -.6497D-06,
     >    -.1157D-05, -.2045D-05, -.3569D-05, -.6302D-05, -.1123D-04,
     >    -.1991D-04, -.3492D-04, -.6120D-04, -.1076D-03, -.1863D-03,
     >    -.3256D-03, -.5637D-03, -.9672D-03, -.1635D-02, -.2711D-02,
     >    -.4353D-02, -.6694D-02, -.9686D-02, -.1295D-01, -.1579D-01,
     >    -.1736D-01, -.1723D-01, -.1553D-01, -.1289D-01, -.9997D-02,
     >    -.7362D-02, -.5214D-02, -.3594D-02, -.2427D-02, -.1616D-02,
     >    -.1066D-02, -.6979D-03, -.4545D-03, -.2951D-03, -.1908D-03,
     >    -.1230D-03, -.7906D-04, -.5065D-04, -.3233D-04, -.2058D-04,
     >    -.1301D-04, -.8195D-05, -.5126D-05, -.3183D-05, -.1957D-05,
     >    -.1192D-05, -.7138D-06, -.4200D-06, -.2413D-06, -.1338D-06,
     >    -.7023D-07, -.3388D-07, -.1335D-07, -.2407D-08, 0.2877D-08,
     >    0.4963D-08/

      data (calcpts(j,19), j = 1,neta) /-.7602D-10, -.1220D-09,
     >    -.2737D-09, -.3859D-09, -.9139D-09, -.1511D-08, -.2536D-08,
     >    -.4168D-08, -.7125D-08, -.1412D-07, -.2662D-07, -.4549D-07,
     >    -.8145D-07, -.1415D-06, -.2551D-06, -.4471D-06, -.7992D-06,
     >    -.1408D-05, -.2494D-05, -.4496D-05, -.7735D-05, -.1362D-04,
     >    -.2398D-04, -.4201D-04, -.7350D-04, -.1277D-03, -.2213D-03,
     >    -.3840D-03, -.6589D-03, -.1119D-02, -.1875D-02, -.3080D-02,
     >    -.4910D-02, -.7516D-02, -.1087D-01, -.1458D-01, -.1788D-01,
     >    -.1984D-01, -.1985D-01, -.1801D-01, -.1501D-01, -.1166D-01,
     >    -.8571D-02, -.6046D-02, -.4139D-02, -.2772D-02, -.1828D-02,
     >    -.1192D-02, -.7704D-03, -.4946D-03, -.3161D-03, -.2009D-03,
     >    -.1269D-03, -.7981D-04, -.4988D-04, -.3093D-04, -.1903D-04,
     >    -.1158D-04, -.6948D-05, -.4099D-05, -.2360D-05, -.1313D-05,
     >    -.6978D-06, -.3404D-06, -.1395D-06, -.3238D-07, 0.2071D-07,
     >    0.4317D-07, 0.4897D-07, 0.4694D-07, 0.4109D-07, 0.3426D-07,
     >    0.2766D-07/

      data (calcpts(j,20), j = 1,neta) /-.1486D-09, -.2084D-09,
     >    -.2156D-09, -.5165D-09, -.1028D-08, -.1695D-08, -.2959D-08,
     >    -.5026D-08, -.9531D-08, -.1689D-07, -.3069D-07, -.5319D-07,
     >    -.9289D-07, -.1644D-06, -.2927D-06, -.5169D-06, -.9236D-06,
     >    -.1621D-05, -.2863D-05, -.5112D-05, -.8725D-05, -.1553D-04,
     >    -.2730D-04, -.4743D-04, -.8240D-04, -.1426D-03, -.2449D-03,
     >    -.4185D-03, -.7110D-03, -.1193D-02, -.1971D-02, -.3194D-02,
     >    -.5033D-02, -.7630D-02, -.1101D-01, -.1480D-01, -.1829D-01,
     >    -.2051D-01, -.2077D-01, -.1904D-01, -.1596D-01, -.1242D-01,
     >    -.9104D-02, -.6373D-02, -.4315D-02, -.2845D-02, -.1840D-02,
     >    -.1173D-02, -.7391D-03, -.4604D-03, -.2842D-03, -.1733D-03,
     >    -.1043D-03, -.6193D-04, -.3594D-04, -.2030D-04, -.1104D-04,
     >    -.5610D-05, -.2531D-05, -.8511D-06, 0.3114D-08, 0.4043D-06,
     >    0.5460D-06, 0.5568D-06, 0.5061D-06, 0.4303D-06, 0.3510D-06,
     >    0.2788D-06, 0.2167D-06, 0.1660D-06, 0.1256D-06, 0.9417D-07,
     >    0.6990D-07/

      data (calcpts(j,21), j = 1,neta) /-.5347D-10, -.2247D-09,
     >    -.2536D-09, -.4946D-09, -.1075D-08, -.1854D-08, -.3507D-08,
     >    -.6687D-08, -.9907D-08, -.1667D-07, -.3265D-07, -.5625D-07,
     >    -.9228D-07, -.1809D-06, -.3111D-06, -.5438D-06, -.9714D-06,
     >    -.1708D-05, -.3045D-05, -.5259D-05, -.9173D-05, -.1617D-04,
     >    -.2835D-04, -.4914D-04, -.8478D-04, -.1455D-03, -.2474D-03,
     >    -.4174D-03, -.6997D-03, -.1152D-02, -.1866D-02, -.2962D-02,
     >    -.4565D-02, -.6829D-02, -.9739D-02, -.1308D-01, -.1630D-01,
     >    -.1854D-01, -.1909D-01, -.1776D-01, -.1503D-01, -.1172D-01,
     >    -.8532D-02, -.5885D-02, -.3892D-02, -.2485D-02, -.1542D-02,
     >    -.9325D-03, -.5493D-03, -.3140D-03, -.1730D-03, -.9005D-04,
     >    -.4266D-04, -.1663D-04, -.2895D-05, 0.3602D-05, 0.6205D-05,
     >    0.6783D-05, 0.6345D-05, 0.5478D-05, 0.4528D-05, 0.3614D-05,
     >    0.2823D-05, 0.2169D-05, 0.1646D-05, 0.1236D-05, 0.9190D-06,
     >    0.6792D-06, 0.4982D-06, 0.3639D-06, 0.2646D-06, 0.1917D-06,
     >    0.1382D-06/

      data (calcpts(j,22), j = 1,neta) /-.1087D-09, -.2056D-09,
     >    -.2857D-09, -.4519D-09, -.1035D-08, -.1817D-08, -.3161D-08,
     >    -.6500D-08, -.8736D-08, -.1626D-07, -.3079D-07, -.5446D-07,
     >    -.9652D-07, -.1794D-06, -.3003D-06, -.5267D-06, -.9420D-06,
     >    -.1654D-05, -.2896D-05, -.5136D-05, -.8853D-05, -.1543D-04,
     >    -.2682D-04, -.4618D-04, -.7917D-04, -.1347D-03, -.2258D-03,
     >    -.3773D-03, -.6192D-03, -.9964D-03, -.1572D-02, -.2419D-02,
     >    -.3614D-02, -.5217D-02, -.7271D-02, -.9648D-02, -.1207D-01,
     >    -.1397D-01, -.1470D-01, -.1397D-01, -.1198D-01, -.9338D-02,
     >    -.6697D-02, -.4463D-02, -.2789D-02, -.1633D-02, -.8906D-03,
     >    -.4390D-03, -.1801D-03, -.4064D-04, 0.2741D-04, 0.5574D-04,
     >    0.6281D-04, 0.5925D-04, 0.5137D-04, 0.4233D-04, 0.3375D-04,
     >    0.2630D-04, 0.2016D-04, 0.1524D-04, 0.1141D-04, 0.8462D-05,
     >    0.6232D-05, 0.4565D-05, 0.3327D-05, 0.2415D-05, 0.1745D-05,
     >    0.1257D-05, 0.9025D-06, 0.6467D-06, 0.4621D-06, 0.3295D-06,
     >    0.2345D-06/

      data (calcpts(j,23), j = 1,neta) /-.7139D-10, -.2032D-09,
     >    -.2202D-09, -.4896D-09, -.9366D-09, -.1551D-08, -.2642D-08,
     >    -.4985D-08, -.8101D-08, -.1518D-07, -.2690D-07, -.4750D-07,
     >    -.8275D-07, -.1502D-06, -.2509D-06, -.4601D-06, -.8073D-06,
     >    -.1424D-05, -.2501D-05, -.4335D-05, -.7507D-05, -.1324D-04,
     >    -.2278D-04, -.3909D-04, -.6652D-04, -.1117D-03, -.1864D-03,
     >    -.3059D-03, -.4916D-03, -.7702D-03, -.1172D-02, -.1726D-02,
     >    -.2437D-02, -.3320D-02, -.4357D-02, -.5539D-02, -.6817D-02,
     >    -.7998D-02, -.8679D-02, -.8506D-02, -.7418D-02, -.5731D-02,
     >    -.3914D-02, -.2337D-02, -.1169D-02, -.4055D-03, 0.3533D-04,
     >    0.2515D-03, 0.3307D-03, 0.3336D-03, 0.2995D-03, 0.2522D-03,
     >    0.2037D-03, 0.1599D-03, 0.1229D-03, 0.9307D-04, 0.6966D-04,
     >    0.5164D-04, 0.3801D-04, 0.2780D-04, 0.2022D-04, 0.1464D-04,
     >    0.1056D-04, 0.7597D-05, 0.5449D-05, 0.3897D-05, 0.2780D-05,
     >    0.1980D-05, 0.1407D-05, 0.9980D-06, 0.7070D-06, 0.5001D-06,
     >    0.3532D-06/

      data (calcpts(j,24), j = 1,neta) /-.6663D-10, -.1430D-09,
     >    -.2377D-09, -.3509D-09, -.6307D-09, -.1200D-08, -.2150D-08,
     >    -.3945D-08, -.6802D-08, -.1085D-07, -.2096D-07, -.3674D-07,
     >    -.6488D-07, -.1169D-06, -.1955D-06, -.3622D-06, -.6396D-06,
     >    -.1117D-05, -.1942D-05, -.3415D-05, -.5853D-05, -.1026D-04,
     >    -.1762D-04, -.2996D-04, -.5068D-04, -.8471D-04, -.1387D-03,
     >    -.2242D-03, -.3522D-03, -.5364D-03, -.7826D-03, -.1086D-02,
     >    -.1409D-02, -.1705D-02, -.1925D-02, -.2067D-02, -.2263D-02,
     >    -.2561D-02, -.2916D-02, -.3021D-02, -.2667D-02, -.1883D-02,
     >    -.9116D-03, -.3166D-04, 0.5909D-03, 0.9319D-03, 0.1045D-02,
     >    0.1008D-02, 0.8924D-03, 0.7462D-03, 0.6003D-03, 0.4697D-03,
     >    0.3600D-03, 0.2715D-03, 0.2024D-03, 0.1493D-03, 0.1095D-03,
     >    0.7967D-04, 0.5773D-04, 0.4164D-04, 0.2993D-04, 0.2145D-04,
     >    0.1532D-04, 0.1093D-04, 0.7775D-05, 0.5521D-05, 0.3914D-05,
     >    0.2770D-05, 0.1958D-05, 0.1382D-05, 0.9741D-06, 0.6859D-06,
     >    0.4824D-06/

      data (calcpts(j,25), j = 1,neta) /-.4096D-10, -.1024D-09,
     >    -.1250D-09, -.3239D-09, -.5429D-09, -.8035D-09, -.1449D-08,
     >    -.2800D-08, -.4499D-08, -.7629D-08, -.1569D-07, -.2552D-07,
     >    -.4639D-07, -.8264D-07, -.1419D-06, -.2453D-06, -.4483D-06,
     >    -.7893D-06, -.1374D-05, -.2390D-05, -.4106D-05, -.7060D-05,
     >    -.1218D-04, -.2085D-04, -.3488D-04, -.5793D-04, -.9397D-04,
     >    -.1492D-03, -.2306D-03, -.3418D-03, -.4774D-03, -.6178D-03,
     >    -.7062D-03, -.6706D-03, -.4351D-03, 0.5732D-05, 0.5147D-03,
     >    0.8986D-03, 0.1007D-02, 0.9469D-03, 0.9506D-03, 0.1159D-02,
     >    0.1518D-02, 0.1865D-02, 0.2064D-02, 0.2073D-02, 0.1925D-02,
     >    0.1681D-02, 0.1401D-02, 0.1126D-02, 0.8806D-03, 0.6745D-03,
     >    0.5082D-03, 0.3782D-03, 0.2785D-03, 0.2036D-03, 0.1479D-03,
     >    0.1069D-03, 0.7687D-04, 0.5511D-04, 0.3939D-04, 0.2808D-04,
     >    0.1997D-04, 0.1418D-04, 0.1005D-04, 0.7106D-05, 0.5020D-05,
     >    0.3543D-05, 0.2496D-05, 0.1757D-05, 0.1235D-05, 0.8675D-06,
     >    0.6088D-06/

      data (calcpts(j,26), j = 1,neta) /-.2490D-10, -.4478D-10,
     >    -.7078D-10, -.1422D-09, -.2641D-09, -.4349D-09, -.8422D-09,
     >    -.1633D-08, -.2776D-08, -.5104D-08, -.9995D-08, -.1603D-07,
     >    -.2874D-07, -.5237D-07, -.8911D-07, -.1598D-06, -.2803D-06,
     >    -.5038D-06, -.8796D-06, -.1533D-05, -.2617D-05, -.4537D-05,
     >    -.7801D-05, -.1317D-04, -.2206D-04, -.3644D-04, -.5860D-04,
     >    -.9246D-04, -.1406D-03, -.2029D-03, -.2731D-03, -.3271D-03,
     >    -.3154D-03, -.1690D-03, 0.1905D-03, 0.7872D-03, 0.1531D-02,
     >    0.2217D-02, 0.2644D-02, 0.2781D-02, 0.2773D-02, 0.2790D-02,
     >    0.2883D-02, 0.2974D-02, 0.2965D-02, 0.2807D-02, 0.2523D-02,
     >    0.2162D-02, 0.1780D-02, 0.1420D-02, 0.1104D-02, 0.8416D-03,
     >    0.6316D-03, 0.4681D-03, 0.3436D-03, 0.2503D-03, 0.1812D-03,
     >    0.1305D-03, 0.9363D-04, 0.6694D-04, 0.4772D-04, 0.3394D-04,
     >    0.2408D-04, 0.1706D-04, 0.1206D-04, 0.8518D-05, 0.6007D-05,
     >    0.4231D-05, 0.2976D-05, 0.2092D-05, 0.1468D-05, 0.1030D-05,
     >    0.7222D-06/

      data (calcpts(j,27), j = 1,neta) /-.1861D-10, -.4714D-10,
     >    -.5830D-10, -.1150D-09, -.2267D-09, -.3674D-09, -.6322D-09,
     >    -.1213D-08, -.1915D-08, -.3361D-08, -.6083D-08, -.1054D-07,
     >    -.1793D-07, -.3229D-07, -.5634D-07, -.9872D-07, -.1754D-06,
     >    -.3049D-06, -.5304D-06, -.9291D-06, -.1583D-05, -.2729D-05,
     >    -.4670D-05, -.7874D-05, -.1317D-04, -.2164D-04, -.3451D-04,
     >    -.5416D-04, -.8138D-04, -.1156D-03, -.1509D-03, -.1696D-03,
     >    -.1364D-03, 0.1381D-05, 0.3043D-03, 0.8057D-03, 0.1457D-02,
     >    0.2117D-02, 0.2619D-02, 0.2886D-02, 0.2985D-02, 0.3045D-02,
     >    0.3136D-02, 0.3219D-02, 0.3210D-02, 0.3060D-02, 0.2775D-02,
     >    0.2400D-02, 0.1996D-02, 0.1603D-02, 0.1254D-02, 0.9594D-03,
     >    0.7220D-03, 0.5360D-03, 0.3939D-03, 0.2869D-03, 0.2078D-03,
     >    0.1496D-03, 0.1072D-03, 0.7659D-04, 0.5455D-04, 0.3875D-04,
     >    0.2748D-04, 0.1944D-04, 0.1374D-04, 0.9692D-05, 0.6829D-05,
     >    0.4805D-05, 0.3378D-05, 0.2372D-05, 0.1665D-05, 0.1167D-05,
     >    0.8173D-06/

      data (calcpts(j,28), j = 1,neta) /-.1221D-10, -.1892D-10,
     >    -.3565D-10, -.6203D-10, -.1164D-09, -.2009D-09, -.3449D-09,
     >    -.6346D-09, -.9467D-09, -.1799D-08, -.3369D-08, -.5811D-08,
     >    -.1014D-07, -.1789D-07, -.3099D-07, -.5488D-07, -.9664D-07,
     >    -.1698D-06, -.2948D-06, -.5086D-06, -.8873D-06, -.1524D-05,
     >    -.2600D-05, -.4375D-05, -.7292D-05, -.1205D-04, -.1922D-04,
     >    -.2985D-04, -.4471D-04, -.6283D-04, -.8037D-04, -.8662D-04,
     >    -.5937D-04, 0.3383D-04, 0.2353D-03, 0.5676D-03, 0.1014D-02,
     >    0.1492D-02, 0.1891D-02, 0.2147D-02, 0.2293D-02, 0.2421D-02,
     >    0.2591D-02, 0.2779D-02, 0.2896D-02, 0.2874D-02, 0.2698D-02,
     >    0.2404D-02, 0.2044D-02, 0.1673D-02, 0.1327D-02, 0.1026D-02,
     >    0.7784D-03, 0.5813D-03, 0.4289D-03, 0.3133D-03, 0.2274D-03,
     >    0.1638D-03, 0.1176D-03, 0.8402D-04, 0.5985D-04, 0.4252D-04,
     >    0.3015D-04, 0.2132D-04, 0.1506D-04, 0.1062D-04, 0.7483D-05,
     >    0.5265D-05, 0.3700D-05, 0.2597D-05, 0.1821D-05, 0.1277D-05,
     >    0.8940D-06/

      data (calcpts(j,29), j = 1,neta) /-.4983D-11, -.9790D-11,
     >    -.1290D-10, -.3188D-10, -.5737D-10, -.9069D-10, -.1687D-09,
     >    -.3056D-09, -.4990D-09, -.9079D-09, -.1750D-08, -.2956D-08,
     >    -.5178D-08, -.9420D-08, -.1603D-07, -.2899D-07, -.5115D-07,
     >    -.8900D-07, -.1549D-06, -.2717D-06, -.4668D-06, -.8112D-06,
     >    -.1373D-05, -.2324D-05, -.3879D-05, -.6359D-05, -.1017D-04,
     >    -.1589D-04, -.2369D-04, -.3311D-04, -.4219D-04, -.4462D-04,
     >    -.2846D-04, 0.2510D-04, 0.1398D-03, 0.3315D-03, 0.5920D-03,
     >    0.8776D-03, 0.1124D-02, 0.1291D-02, 0.1397D-02, 0.1514D-02,
     >    0.1710D-02, 0.1973D-02, 0.2224D-02, 0.2368D-02, 0.2357D-02,
     >    0.2201D-02, 0.1943D-02, 0.1636D-02, 0.1327D-02, 0.1045D-02,
     >    0.8027D-03, 0.6054D-03, 0.4498D-03, 0.3305D-03, 0.2406D-03,
     >    0.1739D-03, 0.1250D-03, 0.8948D-04, 0.6380D-04, 0.4535D-04,
     >    0.3216D-04, 0.2276D-04, 0.1608D-04, 0.1134D-04, 0.7988D-05,
     >    0.5620D-05, 0.3948D-05, 0.2772D-05, 0.1944D-05, 0.1362D-05,
     >    0.9538D-06/

      data (calcpts(j,30), j = 1,neta) /-.2854D-11, -.4437D-11,
     >    -.7638D-11, -.1380D-10, -.2918D-10, -.5391D-10, -.8799D-10,
     >    -.1632D-09, -.2688D-09, -.4775D-09, -.8800D-09, -.1564D-08,
     >    -.2775D-08, -.4964D-08, -.8434D-08, -.1488D-07, -.2652D-07,
     >    -.4610D-07, -.8079D-07, -.1414D-06, -.2420D-06, -.4168D-06,
     >    -.7136D-06, -.1200D-05, -.2009D-05, -.3292D-05, -.5263D-05,
     >    -.8193D-05, -.1227D-04, -.1725D-04, -.2189D-04, -.2334D-04,
     >    -.1515D-04, 0.1224D-04, 0.7142D-04, 0.1709D-03, 0.3063D-03,
     >    0.4543D-03, 0.5785D-03, 0.6537D-03, 0.6912D-03, 0.7457D-03,
     >    0.8840D-03, 0.1130D-02, 0.1433D-02, 0.1699D-02, 0.1847D-02,
     >    0.1847D-02, 0.1719D-02, 0.1508D-02, 0.1263D-02, 0.1019D-02,
     >    0.7975D-03, 0.6098D-03, 0.4581D-03, 0.3392D-03, 0.2483D-03,
     >    0.1804D-03, 0.1300D-03, 0.9327D-04, 0.6661D-04, 0.4742D-04,
     >    0.3365D-04, 0.2383D-04, 0.1684D-04, 0.1188D-04, 0.8370D-05,
     >    0.5889D-05, 0.4138D-05, 0.2905D-05, 0.2038D-05, 0.1428D-05,
     >    0.9997D-06/

      data (calcpts(j,31), j = 1,neta) /-.9247D-12, -.2620D-11,
     >    -.4429D-11, -.7357D-11, -.1432D-10, -.2601D-10, -.4498D-10,
     >    -.8562D-10, -.1330D-09, -.2509D-09, -.4525D-09, -.7727D-09,
     >    -.1383D-08, -.2448D-08, -.4206D-08, -.7491D-08, -.1325D-07,
     >    -.2328D-07, -.4055D-07, -.7122D-07, -.1212D-06, -.2087D-06,
     >    -.3586D-06, -.6048D-06, -.1010D-05, -.1663D-05, -.2651D-05,
     >    -.4146D-05, -.6220D-05, -.8759D-05, -.1125D-04, -.1221D-04,
     >    -.8548D-05, 0.4577D-05, 0.3298D-04, 0.8095D-04, 0.1456D-03,
     >    0.2140D-03, 0.2653D-03, 0.2830D-03, 0.2709D-03, 0.2637D-03,
     >    0.3173D-03, 0.4761D-03, 0.7347D-03, 0.1029D-02, 0.1273D-02,
     >    0.1403D-02, 0.1407D-02, 0.1307D-02, 0.1142D-02, 0.9523D-03,
     >    0.7647D-03, 0.5962D-03, 0.4544D-03, 0.3402D-03, 0.2512D-03,
     >    0.1834D-03, 0.1329D-03, 0.9566D-04, 0.6849D-04, 0.4883D-04,
     >    0.3470D-04, 0.2460D-04, 0.1740D-04, 0.1228D-04, 0.8652D-05,
     >    0.6089D-05, 0.4280D-05, 0.3004D-05, 0.2107D-05, 0.1477D-05,
     >    0.1034D-05/

      data (calcpts(j,32), j = 1,neta) /0.2151D-11, 0.8299D-12,
     >    0.1550D-11, -.1431D-11, -.5444D-11, -.1006D-10, -.1886D-10,
     >    -.3642D-10, -.5890D-10, -.1180D-09, -.2167D-09, -.3646D-09,
     >    -.6557D-09, -.1191D-08, -.2029D-08, -.3601D-08, -.6539D-08,
     >    -.1130D-07, -.1982D-07, -.3464D-07, -.5947D-07, -.1027D-06,
     >    -.1758D-06, -.2982D-06, -.4972D-06, -.8188D-06, -.1314D-05,
     >    -.2050D-05, -.3091D-05, -.4386D-05, -.5697D-05, -.6336D-05,
     >    -.4837D-05, 0.1010D-05, 0.1405D-04, 0.3593D-04, 0.6474D-04,
     >    0.9324D-04, 0.1093D-03, 0.1019D-03, 0.7001D-04, 0.3092D-04,
     >    0.2157D-04, 0.8568D-04, 0.2472D-03, 0.4866D-03, 0.7427D-03,
     >    0.9454D-03, 0.1051D-02, 0.1053D-02, 0.9759D-03, 0.8503D-03,
     >    0.7063D-03, 0.5654D-03, 0.4394D-03, 0.3339D-03, 0.2494D-03,
     >    0.1837D-03, 0.1339D-03, 0.9681D-04, 0.6956D-04, 0.4972D-04,
     >    0.3540D-04, 0.2512D-04, 0.1779D-04, 0.1256D-04, 0.8858D-05,
     >    0.6235D-05, 0.4384D-05, 0.3079D-05, 0.2160D-05, 0.1514D-05,
     >    0.1060D-05/

      data (calcpts(j,33), j = 1,neta) /-.4830D-11, -.3510D-11,
     >    -.2885D-11, -.2197D-11, -.5301D-11, -.7682D-11, -.1224D-10,
     >    -.2146D-10, -.3607D-10, -.6335D-10, -.1117D-09, -.1940D-09,
     >    -.3413D-09, -.6064D-09, -.1037D-08, -.1847D-08, -.3234D-08,
     >    -.5704D-08, -.9849D-08, -.1719D-07, -.2943D-07, -.5075D-07,
     >    -.8699D-07, -.1473D-06, -.2450D-06, -.4040D-06, -.6487D-06,
     >    -.1017D-05, -.1536D-05, -.2197D-05, -.2877D-05, -.3300D-05,
     >    -.2760D-05, -.2738D-06, 0.5417D-05, 0.1496D-04, 0.2710D-04,
     >    0.3770D-04, 0.3981D-04, 0.2627D-04, -.5854D-05, -.5007D-04,
     >    -.8679D-04, -.8547D-04, -.1608D-04, 0.1319D-03, 0.3348D-03,
     >    0.5416D-03, 0.6997D-03, 0.7792D-03, 0.7796D-03, 0.7201D-03,
     >    0.6254D-03, 0.5179D-03, 0.4134D-03, 0.3205D-03, 0.2430D-03,
     >    0.1811D-03, 0.1331D-03, 0.9683D-04, 0.6990D-04, 0.5014D-04,
     >    0.3579D-04, 0.2544D-04, 0.1804D-04, 0.1276D-04, 0.9000D-05,
     >    0.6340D-05, 0.4459D-05, 0.3132D-05, 0.2198D-05, 0.1540D-05,
     >    0.1079D-05/

      data (calcpts(j,34), j = 1,neta) /-.4478D-11, -.5153D-11,
     >    -.5308D-11, -.4177D-11, -.4213D-11, -.4759D-11, -.5756D-11,
     >    -.1097D-10, -.1695D-10, -.2947D-10, -.5351D-10, -.9124D-10,
     >    -.1597D-09, -.2835D-09, -.5010D-09, -.8807D-09, -.1553D-08,
     >    -.2698D-08, -.4757D-08, -.8210D-08, -.1417D-07, -.2437D-07,
     >    -.4186D-07, -.7064D-07, -.1181D-06, -.1950D-06, -.3131D-06,
     >    -.4943D-06, -.7498D-06, -.1078D-05, -.1435D-05, -.1678D-05,
     >    -.1527D-05, -.5054D-06, 0.1898D-05, 0.5895D-05, 0.1073D-04,
     >    0.1406D-04, 0.1199D-04, 0.9194D-07, -.2455D-04, -.6061D-04,
     >    -.9966D-04, -.1249D-03, -.1138D-03, -.4696D-04, 0.7833D-04,
     >    0.2402D-03, 0.3989D-03, 0.5166D-03, 0.5738D-03, 0.5720D-03,
     >    0.5266D-03, 0.4559D-03, 0.3765D-03, 0.2997D-03, 0.2318D-03,
     >    0.1754D-03, 0.1305D-03, 0.9577D-04, 0.6957D-04, 0.5013D-04,
     >    0.3592D-04, 0.2560D-04, 0.1818D-04, 0.1287D-04, 0.9093D-05,
     >    0.6410D-05, 0.4511D-05, 0.3170D-05, 0.2224D-05, 0.1560D-05,
     >    0.1093D-05/

      data (calcpts(j,35), j = 1,neta) /-.1445D-10, -.1011D-11,
     >    0.7187D-12, -.4568D-11, -.1821D-11, -.4338D-11, -.3443D-11,
     >    -.5130D-11, -.7749D-11, -.1404D-10, -.2392D-10, -.4275D-10,
     >    -.7507D-10, -.1339D-09, -.2362D-09, -.4118D-09, -.7348D-09,
     >    -.1279D-08, -.2235D-08, -.3895D-08, -.6681D-08, -.1161D-07,
     >    -.1988D-07, -.3368D-07, -.5648D-07, -.9351D-07, -.1508D-06,
     >    -.2386D-06, -.3626D-06, -.5248D-06, -.7084D-06, -.8508D-06,
     >    -.8231D-06, -.4278D-06, 0.5567D-06, 0.2181D-05, 0.3960D-05,
     >    0.4671D-05, 0.2131D-05, -.6248D-05, -.2267D-04, -.4762D-04,
     >    -.7831D-04, -.1071D-03, -.1211D-03, -.1046D-03, -.4569D-04,
     >    0.5467D-04, 0.1784D-03, 0.2957D-03, 0.3805D-03, 0.4201D-03,
     >    0.4170D-03, 0.3824D-03, 0.3301D-03, 0.2720D-03, 0.2161D-03,
     >    0.1668D-03, 0.1260D-03, 0.9353D-04, 0.6854D-04, 0.4972D-04,
     >    0.3579D-04, 0.2560D-04, 0.1822D-04, 0.1293D-04, 0.9145D-05,
     >    0.6452D-05, 0.4545D-05, 0.3195D-05, 0.2244D-05, 0.1573D-05,
     >    0.1102D-05/

      data (calcpts(j,36), j = 1,neta) /0.6876D-11, -.4528D-12,
     >    0.3776D-11, 0.3938D-12, -.4144D-11, 0.7553D-12, -.3980D-11,
     >    -.1515D-11, -.4962D-11, -.7698D-11, -.1130D-10, -.2065D-10,
     >    -.3616D-10, -.6477D-10, -.1112D-09, -.1966D-09, -.3543D-09,
     >    -.6119D-09, -.1063D-08, -.1860D-08, -.3216D-08, -.5546D-08,
     >    -.9528D-08, -.1609D-07, -.2715D-07, -.4477D-07, -.7242D-07,
     >    -.1148D-06, -.1757D-06, -.2565D-06, -.3483D-06, -.4296D-06,
     >    -.4394D-06, -.2954D-06, 0.9171D-07, 0.7169D-06, 0.1319D-05,
     >    0.1220D-05, -.7291D-06, -.6002D-05, -.1603D-04, -.3165D-04,
     >    -.5234D-04, -.7523D-04, -.9426D-04, -.1001D-03, -.8223D-04,
     >    -.3349D-04, 0.4377D-04, 0.1353D-03, 0.2199D-03, 0.2796D-03,
     >    0.3062D-03, 0.3022D-03, 0.2761D-03, 0.2377D-03, 0.1954D-03,
     >    0.1549D-03, 0.1194D-03, 0.9004D-04, 0.6675D-04, 0.4884D-04,
     >    0.3538D-04, 0.2544D-04, 0.1818D-04, 0.1293D-04, 0.9162D-05,
     >    0.6474D-05, 0.4563D-05, 0.3211D-05, 0.2256D-05, 0.1582D-05,
     >    0.1109D-05/

      data (calcpts(j,37), j = 1,neta) /0.3214D-11, 0.2471D-11,
     >    0.1989D-11, 0.4786D-11, 0.2349D-11, -.4747D-11, 0.3463D-12,
     >    0.2695D-12, -.4435D-13, -.1458D-11, -.6294D-11, -.9686D-11,
     >    -.1874D-10, -.2966D-10, -.5306D-10, -.9410D-10, -.1660D-09,
     >    -.2915D-09, -.5026D-09, -.8926D-09, -.1533D-08, -.2640D-08,
     >    -.4533D-08, -.7698D-08, -.1291D-07, -.2141D-07, -.3468D-07,
     >    -.5509D-07, -.8459D-07, -.1242D-06, -.1711D-06, -.2145D-06,
     >    -.2301D-06, -.1838D-06, -.3719D-07, 0.1903D-06, 0.3566D-06,
     >    0.1064D-06, -.1167D-05, -.4265D-05, -.1005D-04, -.1920D-04,
     >    -.3191D-04, -.4735D-04, -.6312D-04, -.7473D-04, -.7563D-04,
     >    -.5884D-04, -.2025D-04, 0.3754D-04, 0.1038D-03, 0.1636D-03,
     >    0.2047D-03, 0.2223D-03, 0.2181D-03, 0.1986D-03, 0.1705D-03,
     >    0.1398D-03, 0.1107D-03, 0.8517D-04, 0.6412D-04, 0.4747D-04,
     >    0.3469D-04, 0.2511D-04, 0.1803D-04, 0.1287D-04, 0.9141D-05,
     >    0.6472D-05, 0.4569D-05, 0.3217D-05, 0.2262D-05, 0.1588D-05,
     >    0.1113D-05/

      data (calcpts(j,38), j = 1,neta) /0.2265D-10, -.4611D-11,
     >    0.1382D-10, 0.1316D-10, -.3562D-11, -.2469D-11, -.3007D-12,
     >    -.6720D-11, 0.3697D-11, -.9792D-12, -.1845D-11, -.3928D-11,
     >    -.8268D-11, -.1260D-10, -.2389D-10, -.4290D-10, -.7696D-10,
     >    -.1363D-09, -.2383D-09, -.4171D-09, -.7147D-09, -.1251D-08,
     >    -.2138D-08, -.3636D-08, -.6118D-08, -.1016D-07, -.1648D-07,
     >    -.2633D-07, -.4057D-07, -.5986D-07, -.8323D-07, -.1064D-06,
     >    -.1190D-06, -.1063D-06, -.5577D-07, 0.2084D-07, 0.4457D-07,
     >    -.1681D-06, -.9323D-06, -.2673D-05, -.5877D-05, -.1100D-04,
     >    -.1834D-04, -.2781D-04, -.3861D-04, -.4890D-04, -.5543D-04,
     >    -.5375D-04, -.3926D-04, -.9647D-05, 0.3266D-04, 0.7984D-04,
     >    0.1215D-03, 0.1495D-03, 0.1608D-03, 0.1569D-03, 0.1422D-03,
     >    0.1218D-03, 0.9973D-04, 0.7881D-04, 0.6055D-04, 0.4554D-04,
     >    0.3367D-04, 0.2458D-04, 0.1776D-04, 0.1274D-04, 0.9085D-05,
     >    0.6448D-05, 0.4561D-05, 0.3217D-05, 0.2265D-05, 0.1590D-05,
     >    0.1116D-05/

      data (calcpts(j,39), j = 1,neta) /0.8899D-11, 0.2293D-10,
     >    0.1677D-11, -.1608D-10, 0.2425D-11, -.1380D-10, 0.4994D-11,
     >    0.2777D-12, 0.8584D-11, 0.6138D-11, 0.2812D-11, 0.1515D-11,
     >    -.1299D-11, -.8634D-11, -.1286D-10, -.2092D-10, -.3649D-10,
     >    -.6586D-10, -.1145D-09, -.2014D-09, -.3462D-09, -.5964D-09,
     >    -.1022D-08, -.1742D-08, -.2924D-08, -.4869D-08, -.7902D-08,
     >    -.1260D-07, -.1952D-07, -.2905D-07, -.4074D-07, -.5301D-07,
     >    -.6136D-07, -.5983D-07, -.4423D-07, -.2299D-07, -.3755D-07,
     >    -.1818D-06, -.6164D-06, -.1563D-05, -.3287D-05, -.6063D-05,
     >    -.1012D-04, -.1557D-04, -.2225D-04, -.2948D-04, -.3591D-04,
     >    -.3926D-04, -.3647D-04, -.2462D-04, -.2424D-05, 0.2807D-04,
     >    0.6125D-04, 0.8998D-04, 0.1088D-03, 0.1158D-03, 0.1124D-03,
     >    0.1016D-03, 0.8679D-04, 0.7093D-04, 0.5596D-04, 0.4296D-04,
     >    0.3226D-04, 0.2383D-04, 0.1737D-04, 0.1254D-04, 0.8988D-05,
     >    0.6403D-05, 0.4540D-05, 0.3208D-05, 0.2262D-05, 0.1590D-05,
     >    0.1116D-05/

      data (calcpts(j,40), j = 1,neta) /0.3289D-10, 0.2708D-10,
     >    0.3539D-10, -.6742D-11, 0.5593D-11, 0.7691D-11, 0.2261D-10,
     >    0.8058D-11, -.1388D-12, 0.9135D-11, 0.1398D-10, -.2515D-11,
     >    0.1087D-11, -.2156D-11, -.3048D-11, -.1035D-10, -.1705D-10,
     >    -.3096D-10, -.5363D-10, -.9460D-10, -.1621D-09, -.2806D-09,
     >    -.4827D-09, -.8212D-09, -.1382D-08, -.2294D-08, -.3755D-08,
     >    -.5997D-08, -.9319D-08, -.1391D-07, -.1973D-07, -.2600D-07,
     >    -.3104D-07, -.3247D-07, -.2878D-07, -.2572D-07, -.4432D-07,
     >    -.1324D-06, -.3711D-06, -.8743D-06, -.1782D-05, -.3251D-05,
     >    -.5431D-05, -.8440D-05, -.1229D-04, -.1682D-04, -.2151D-04,
     >    -.2537D-04, -.2682D-04, -.2382D-04, -.1447D-04, 0.1894D-05,
     >    0.2362D-04, 0.4674D-04, 0.6637D-04, 0.7893D-04, 0.8326D-04,
     >    0.8034D-04, 0.7236D-04, 0.6169D-04, 0.5034D-04, 0.3966D-04,
     >    0.3040D-04, 0.2281D-04, 0.1683D-04, 0.1226D-04, 0.8842D-05,
     >    0.6330D-05, 0.4506D-05, 0.3192D-05, 0.2254D-05, 0.1587D-05,
     >    0.1116D-05/

      data (calcpts(j,41), j = 1,neta) /0.8070D-10, 0.7208D-10,
     >    -.9969D-11, 0.4621D-10, 0.3142D-10, 0.1773D-10, 0.2619D-10,
     >    0.5520D-11, 0.1387D-10, -.2577D-11, 0.4067D-11, -.4187D-11,
     >    0.1809D-11, 0.1111D-11, 0.3716D-11, -.1177D-11, -.5532D-11,
     >    -.9871D-11, -.2146D-10, -.4289D-10, -.7489D-10, -.1314D-09,
     >    -.2265D-09, -.3856D-09, -.6518D-09, -.1086D-08, -.1774D-08,
     >    -.2838D-08, -.4438D-08, -.6668D-08, -.9526D-08, -.1275D-07,
     >    -.1562D-07, -.1721D-07, -.1718D-07, -.1892D-07, -.3309D-07,
     >    -.8376D-07, -.2116D-06, -.4746D-06, -.9454D-06, -.1708D-05,
     >    -.2854D-05, -.4465D-05, -.6595D-05, -.9230D-05, -.1222D-04,
     >    -.1518D-04, -.1741D-04, -.1781D-04, -.1502D-04, -.7817D-05,
     >    0.4090D-05, 0.1945D-04, 0.3544D-04, 0.4878D-04, 0.5709D-04,
     >    0.5967D-04, 0.5728D-04, 0.5143D-04, 0.4375D-04, 0.3564D-04,
     >    0.2805D-04, 0.2148D-04, 0.1609D-04, 0.1187D-04, 0.8635D-05,
     >    0.6223D-05, 0.4450D-05, 0.3165D-05, 0.2241D-05, 0.1581D-05,
     >    0.1113D-05/

      data (calcpts(j,42), j = 1,neta) /-.5846D-10, -.7014D-10,
     >    -.5778D-10, -.1180D-09, -.2375D-10, -.5015D-10, -.7008D-11,
     >    0.8792D-11, -.1201D-10, -.3614D-10, -.1938D-10, -.1763D-10,
     >    0.7249D-11, -.6352D-11, -.4248D-11, -.9391D-11, -.7513D-11,
     >    -.1266D-10, -.1417D-10, -.2237D-10, -.3978D-10, -.6331D-10,
     >    -.1093D-09, -.1839D-09, -.3089D-09, -.5148D-09, -.8423D-09,
     >    -.1355D-08, -.2121D-08, -.3203D-08, -.4610D-08, -.6246D-08,
     >    -.7828D-08, -.9010D-08, -.9846D-08, -.1204D-07, -.2119D-07,
     >    -.4927D-07, -.1165D-06, -.2519D-06, -.4931D-06, -.8844D-06,
     >    -.1476D-05, -.2321D-05, -.3462D-05, -.4926D-05, -.6685D-05,
     >    -.8617D-05, -.1044D-04, -.1166D-04, -.1152D-04, -.9118D-05,
     >    -.3686D-05, 0.4897D-05, 0.1567D-04, 0.2668D-04, 0.3570D-04,
     >    0.4116D-04, 0.4267D-04, 0.4075D-04, 0.3648D-04, 0.3097D-04,
     >    0.2520D-04, 0.1981D-04, 0.1515D-04, 0.1134D-04, 0.8355D-05,
     >    0.6075D-05, 0.4374D-05, 0.3126D-05, 0.2221D-05, 0.1572D-05,
     >    0.1108D-05/

      data (calcpts(j,43), j = 1,neta) /0.1136D-10, -.8782D-10,
     >    0.6688D-10, -.2130D-10, 0.8003D-10, 0.2656D-10, -.1288D-10,
     >    -.8851D-11, -.1165D-10, -.1624D-11, 0.1652D-11, 0.3481D-11,
     >    -.9166D-11, -.8690D-11, -.1727D-11, 0.2107D-11, 0.7933D-11,
     >    -.2786D-11, -.5017D-11, -.1410D-10, -.1768D-10, -.3233D-10,
     >    -.4968D-10, -.8618D-10, -.1465D-09, -.2441D-09, -.3988D-09,
     >    -.6432D-09, -.1010D-08, -.1531D-08, -.2219D-08, -.3050D-08,
     >    -.3898D-08, -.4655D-08, -.5410D-08, -.7109D-08, -.1256D-07,
     >    -.2769D-07, -.6255D-07, -.1316D-06, -.2538D-06, -.4523D-06,
     >    -.7542D-06, -.1189D-05, -.1789D-05, -.2576D-05, -.3560D-05,
     >    -.4712D-05, -.5939D-05, -.7035D-05, -.7651D-05, -.7277D-05,
     >    -.5307D-05, -.1264D-05, 0.4879D-05, 0.1241D-04, 0.1996D-04,
     >    0.2602D-04, 0.2959D-04, 0.3043D-04, 0.2893D-04, 0.2583D-04,
     >    0.2188D-04, 0.1779D-04, 0.1397D-04, 0.1067D-04, 0.7984D-05,
     >    0.5875D-05, 0.4269D-05, 0.3070D-05, 0.2193D-05, 0.1557D-05,
     >    0.1101D-05/

      data (calcpts(j,44), j = 1,neta) /0.2906D-09, -.1005D-09,
     >    -.3852D-10, -.4085D-10, 0.4381D-10, 0.4428D-10, 0.1203D-11,
     >    -.1534D-10, -.7004D-11, 0.1085D-10, 0.1420D-10, -.1206D-10,
     >    0.4450D-11, 0.9734D-11, -.1428D-10, 0.5013D-12, -.3193D-11,
     >    0.5180D-11, 0.8894D-12, -.6236D-12, -.1257D-10, -.1550D-10,
     >    -.2144D-10, -.4033D-10, -.6840D-10, -.1162D-09, -.1881D-09,
     >    -.3056D-09, -.4808D-09, -.7301D-09, -.1067D-08, -.1479D-08,
     >    -.1927D-08, -.2374D-08, -.2901D-08, -.3997D-08, -.7078D-08,
     >    -.1508D-07, -.3295D-07, -.6784D-07, -.1293D-06, -.2292D-06,
     >    -.3817D-06, -.6034D-06, -.9124D-06, -.1326D-05, -.1859D-05,
     >    -.2509D-05, -.3253D-05, -.4018D-05, -.4658D-05, -.4929D-05,
     >    -.4484D-05, -.2922D-05, 0.5770D-07, 0.4431D-05, 0.9675D-05,
     >    0.1484D-04, 0.1891D-04, 0.2124D-04, 0.2167D-04, 0.2052D-04,
     >    0.1825D-04, 0.1545D-04, 0.1254D-04, 0.9835D-05, 0.7509D-05,
     >    0.5613D-05, 0.4126D-05, 0.2995D-05, 0.2154D-05, 0.1537D-05,
     >    0.1091D-05/

      data (calcpts(j,45), j = 1,neta) /0.6116D-10, 0.3562D-09,
     >    0.3791D-09, 0.2375D-09, 0.1795D-09, 0.2456D-09, 0.2054D-09,
     >    0.3163D-09, 0.1831D-09, 0.1081D-09, 0.5660D-10, 0.8214D-10,
     >    0.7798D-10, 0.1560D-10, 0.1258D-10, 0.2074D-10, 0.3867D-10,
     >    0.6209D-11, 0.2225D-10, 0.1446D-10, 0.1357D-10, 0.4389D-11,
     >    -.7446D-11, -.1488D-10, -.2801D-10, -.5172D-10, -.8844D-10,
     >    -.1439D-09, -.2279D-09, -.3493D-09, -.5138D-09, -.7197D-09,
     >    -.9534D-09, -.1207D-08, -.1533D-08, -.2187D-08, -.3875D-08,
     >    -.8040D-08, -.1711D-07, -.3462D-07, -.6532D-07, -.1152D-06,
     >    -.1917D-06, -.3035D-06, -.4610D-06, -.6749D-06, -.9555D-06,
     >    -.1309D-05, -.1734D-05, -.2207D-05, -.2676D-05, -.3038D-05,
     >    -.3120D-05, -.2687D-05, -.1476D-05, 0.7008D-06, 0.3801D-05,
     >    0.7441D-05, 0.1096D-04, 0.1369D-04, 0.1519D-04, 0.1540D-04,
     >    0.1452D-04, 0.1289D-04, 0.1089D-04, 0.8827D-05, 0.6918D-05,
     >    0.5277D-05, 0.3942D-05, 0.2896D-05, 0.2101D-05, 0.1509D-05,
     >    0.1076D-05/

      data (calcpts(j,46), j = 1,neta) /0.1917D-09, -.1535D-09,
     >    0.4083D-09, 0.2116D-09, 0.9985D-10, -.3683D-11, 0.6403D-10,
     >    0.2144D-10, 0.7432D-11, 0.7975D-10, -.1710D-10, 0.2668D-10,
     >    -.1262D-10, 0.4799D-11, 0.3884D-11, -.4044D-11, 0.4642D-11,
     >    -.6977D-11, 0.6772D-11, 0.2195D-10, 0.1218D-10, 0.8504D-11,
     >    -.4265D-11, -.5370D-11, -.1092D-10, -.2660D-10, -.4248D-10,
     >    -.7007D-10, -.1082D-09, -.1669D-09, -.2471D-09, -.3489D-09,
     >    -.4687D-09, -.6066D-09, -.7951D-09, -.1165D-08, -.2068D-08,
     >    -.4211D-08, -.8778D-08, -.1752D-07, -.3277D-07, -.5755D-07,
     >    -.9563D-07, -.1516D-06, -.2311D-06, -.3402D-06, -.4856D-06,
     >    -.6733D-06, -.9060D-06, -.1180D-05, -.1478D-05, -.1760D-05,
     >    -.1953D-05, -.1940D-05, -.1557D-05, -.6336D-06, 0.9465D-06,
     >    0.3136D-05, 0.5659D-05, 0.8059D-05, 0.9882D-05, 0.1085D-04,
     >    0.1093D-04, 0.1026D-04, 0.9090D-05, 0.7666D-05, 0.6207D-05,
     >    0.4860D-05, 0.3705D-05, 0.2766D-05, 0.2031D-05, 0.1472D-05,
     >    0.1057D-05/

      data (calcpts(j,47), j = 1,neta) /0.2895D-09, -.2610D-09,
     >    -.3456D-09, -.1412D-09, -.3047D-10, -.2021D-10, -.2062D-09,
     >    -.9289D-10, 0.4744D-10, -.9101D-10, -.2432D-10, -.1832D-10,
     >    0.5847D-10, -.2453D-10, -.3673D-10, -.2271D-10, 0.1469D-10,
     >    -.5788D-11, -.7590D-11, -.1979D-10, 0.1805D-10, -.6081D-11,
     >    -.2603D-11, -.8448D-11, -.6680D-11, -.1677D-10, -.2327D-10,
     >    -.3327D-10, -.5595D-10, -.7616D-10, -.1179D-09, -.1698D-09,
     >    -.2286D-09, -.3027D-09, -.4085D-09, -.6112D-09, -.1086D-08,
     >    -.2176D-08, -.4463D-08, -.8801D-08, -.1634D-07, -.2859D-07,
     >    -.4746D-07, -.7531D-07, -.1151D-06, -.1702D-06, -.2447D-06,
     >    -.3423D-06, -.4663D-06, -.6178D-06, -.7926D-06, -.9777D-06,
     >    -.1144D-05, -.1239D-05, -.1182D-05, -.8625D-06, -.1674D-06,
     >    0.9738D-06, 0.2517D-05, 0.4263D-05, 0.5896D-05, 0.7111D-05,
     >    0.7731D-05, 0.7740D-05, 0.7242D-05, 0.6402D-05, 0.5391D-05,
     >    0.4360D-05, 0.3411D-05, 0.2599D-05, 0.1938D-05, 0.1422D-05,
     >    0.1030D-05/

      data (calcpts(j,48), j = 1,neta) /-.1464D-09, 0.1705D-10,
     >    0.2130D-09, -.6478D-10, 0.5286D-09, 0.1417D-09, 0.3096D-09,
     >    0.1552D-09, -.5639D-10, 0.1330D-09, 0.1519D-09, 0.5894D-10,
     >    0.5478D-10, 0.4993D-10, 0.4679D-10, -.7341D-10, 0.3779D-10,
     >    0.4836D-10, 0.5389D-10, 0.6009D-11, -.5886D-12, 0.1044D-10,
     >    -.2832D-11, 0.1719D-10, 0.4355D-11, -.2739D-11, -.1025D-10,
     >    -.1470D-10, -.1767D-10, -.3432D-10, -.5392D-10, -.7840D-10,
     >    -.1105D-09, -.1499D-09, -.2074D-09, -.3156D-09, -.5618D-09,
     >    -.1113D-08, -.2252D-08, -.4395D-08, -.8110D-08, -.1414D-07,
     >    -.2344D-07, -.3724D-07, -.5702D-07, -.8466D-07, -.1223D-06,
     >    -.1724D-06, -.2372D-06, -.3185D-06, -.4163D-06, -.5270D-06,
     >    -.6404D-06, -.7353D-06, -.7752D-06, -.7035D-06, -.4463D-06,
     >    0.7188D-07, 0.8923D-06, 0.1977D-05, 0.3184D-05, 0.4294D-05,
     >    0.5103D-05, 0.5499D-05, 0.5475D-05, 0.5106D-05, 0.4503D-05,
     >    0.3787D-05, 0.3060D-05, 0.2392D-05, 0.1821D-05, 0.1357D-05,
     >    0.9954D-06/

      data (calcpts(j,49), j = 1,neta) /0.5682D-09, 0.1002D-08,
     >    -.8636D-09, 0.3879D-09, -.6704D-09, -.1877D-09, 0.6433D-10,
     >    0.4983D-09, 0.2832D-09, 0.1430D-09, -.1107D-09, -.2155D-09,
     >    -.7760D-10, 0.9064D-10, 0.5010D-10, 0.5425D-10, -.2434D-10,
     >    0.2420D-11, -.3557D-10, -.2176D-10, 0.2093D-10, 0.3055D-11,
     >    -.5441D-12, 0.2863D-11, 0.5720D-12, -.4297D-11, -.8496D-11,
     >    0.8641D-12, -.1555D-10, -.1598D-10, -.2747D-10, -.3948D-10,
     >    -.5439D-10, -.7508D-10, -.1040D-09, -.1614D-09, -.2881D-09,
     >    -.5647D-09, -.1129D-08, -.2184D-08, -.4008D-08, -.6967D-08,
     >    -.1154D-07, -.1834D-07, -.2814D-07, -.4188D-07, -.6078D-07,
     >    -.8618D-07, -.1195D-06, -.1623D-06, -.2151D-06, -.2778D-06,
     >    -.3471D-06, -.4155D-06, -.4677D-06, -.4778D-06, -.4068D-06,
     >    -.2046D-06, 0.1783D-06, 0.7663D-06, 0.1528D-05, 0.2361D-05,
     >    0.3115D-05, 0.3654D-05, 0.3904D-05, 0.3867D-05, 0.3595D-05,
     >    0.3165D-05, 0.2658D-05, 0.2146D-05, 0.1677D-05, 0.1275D-05,
     >    0.9499D-06/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsclcf = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine sclbar_CT(eta, xi, xsclba)
c   the subtracted term from eq (12) of PLB347 (1995) 143 - 151
c   longitudinal gluon initiated piece accompanying the MF log
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsclba
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.7071D-08, 0.8567D-08,
     >    0.1038D-07, 0.1257D-07, 0.1524D-07, 0.1846D-07, 0.2236D-07,
     >    0.2710D-07, 0.3283D-07, 0.3978D-07, 0.4822D-07, 0.5844D-07,
     >    0.7084D-07, 0.8591D-07, 0.1042D-06, 0.1265D-06, 0.1537D-06,
     >    0.1870D-06, 0.2279D-06, 0.2786D-06, 0.3418D-06, 0.4217D-06,
     >    0.5243D-06, 0.6586D-06, 0.8386D-06, 0.1086D-05, 0.1434D-05,
     >    0.1933D-05, 0.2658D-05, 0.3705D-05, 0.5187D-05, 0.7191D-05,
     >    0.9704D-05, 0.1252D-04, 0.1518D-04, 0.1707D-04, 0.1771D-04,
     >    0.1701D-04, 0.1527D-04, 0.1299D-04, 0.1059D-04, 0.8349D-05,
     >    0.6403D-05, 0.4797D-05, 0.3525D-05, 0.2546D-05, 0.1816D-05,
     >    0.1282D-05, 0.8938D-06, 0.6230D-06, 0.4303D-06, 0.2961D-06,
     >    0.2068D-06, 0.1394D-06, 0.9358D-07, 0.6473D-07, 0.4295D-07,
     >    0.3262D-07, 0.1892D-07, 0.1412D-07, 0.1085D-07, 0.8620D-08,
     >    0.7103D-08, 0.6068D-08, 0.5363D-08, -.1784D-08, -.2111D-08,
     >    -.2334D-08, -.2486D-08, -.2589D-08, -.2660D-08, -.2708D-08,
     >    -.2741D-08/

      data (calcpts(j, 2), j = 1,neta) /0.1038D-07, 0.1257D-07,
     >    0.1523D-07, 0.1845D-07, 0.2236D-07, 0.2709D-07, 0.3282D-07,
     >    0.3977D-07, 0.4818D-07, 0.5839D-07, 0.7077D-07, 0.8577D-07,
     >    0.1040D-06, 0.1261D-06, 0.1529D-06, 0.1857D-06, 0.2256D-06,
     >    0.2745D-06, 0.3345D-06, 0.4089D-06, 0.5016D-06, 0.6189D-06,
     >    0.7695D-06, 0.9666D-06, 0.1231D-05, 0.1593D-05, 0.2104D-05,
     >    0.2837D-05, 0.3901D-05, 0.5438D-05, 0.7612D-05, 0.1055D-04,
     >    0.1424D-04, 0.1838D-04, 0.2228D-04, 0.2506D-04, 0.2600D-04,
     >    0.2497D-04, 0.2241D-04, 0.1906D-04, 0.1554D-04, 0.1225D-04,
     >    0.9395D-05, 0.7042D-05, 0.5175D-05, 0.3742D-05, 0.2663D-05,
     >    0.1879D-05, 0.1317D-05, 0.9144D-06, 0.6334D-06, 0.4387D-06,
     >    0.2970D-06, 0.2074D-06, 0.1398D-06, 0.9388D-07, 0.6503D-07,
     >    0.4321D-07, 0.3288D-07, 0.1917D-07, 0.1438D-07, 0.1111D-07,
     >    0.8879D-08, 0.7360D-08, 0.6325D-08, 0.5620D-08, 0.5140D-08,
     >    0.4813D-08, 0.4590D-08, 0.4438D-08, 0.4335D-08, 0.4264D-08,
     >    0.4216D-08/

      data (calcpts(j, 3), j = 1,neta) /0.1522D-07, 0.1844D-07,
     >    0.2234D-07, 0.2707D-07, 0.3280D-07, 0.3974D-07, 0.4815D-07,
     >    0.5834D-07, 0.7068D-07, 0.8565D-07, 0.1038D-06, 0.1258D-06,
     >    0.1525D-06, 0.1850D-06, 0.2244D-06, 0.2724D-06, 0.3309D-06,
     >    0.4026D-06, 0.4907D-06, 0.5998D-06, 0.7358D-06, 0.9079D-06,
     >    0.1129D-05, 0.1418D-05, 0.1805D-05, 0.2338D-05, 0.3087D-05,
     >    0.4163D-05, 0.5723D-05, 0.7978D-05, 0.1117D-04, 0.1548D-04,
     >    0.2090D-04, 0.2696D-04, 0.3269D-04, 0.3676D-04, 0.3814D-04,
     >    0.3662D-04, 0.3287D-04, 0.2796D-04, 0.2279D-04, 0.1796D-04,
     >    0.1378D-04, 0.1033D-04, 0.7581D-05, 0.5477D-05, 0.3902D-05,
     >    0.2753D-05, 0.1925D-05, 0.1338D-05, 0.9239D-06, 0.6335D-06,
     >    0.4377D-06, 0.2956D-06, 0.1991D-06, 0.1380D-06, 0.9217D-07,
     >    0.6328D-07, 0.4146D-07, 0.2447D-07, 0.1743D-07, 0.1263D-07,
     >    0.9369D-08, 0.4751D-09, -.1043D-08, -.2076D-08, -.2780D-08,
     >    -.3260D-08, -.3587D-08, -.3809D-08, -.3961D-08, -.4065D-08,
     >    -.4135D-08/

      data (calcpts(j, 4), j = 1,neta) /0.2234D-07, 0.2706D-07,
     >    0.3278D-07, 0.3972D-07, 0.4813D-07, 0.5831D-07, 0.7065D-07,
     >    0.8560D-07, 0.1037D-06, 0.1257D-06, 0.1523D-06, 0.1846D-06,
     >    0.2238D-06, 0.2714D-06, 0.3292D-06, 0.3996D-06, 0.4856D-06,
     >    0.5907D-06, 0.7200D-06, 0.8801D-06, 0.1080D-05, 0.1332D-05,
     >    0.1656D-05, 0.2081D-05, 0.2649D-05, 0.3430D-05, 0.4529D-05,
     >    0.6107D-05, 0.8395D-05, 0.1171D-04, 0.1638D-04, 0.2272D-04,
     >    0.3066D-04, 0.3956D-04, 0.4796D-04, 0.5393D-04, 0.5596D-04,
     >    0.5373D-04, 0.4823D-04, 0.4102D-04, 0.3344D-04, 0.2636D-04,
     >    0.2021D-04, 0.1515D-04, 0.1113D-04, 0.8040D-05, 0.5732D-05,
     >    0.4043D-05, 0.2826D-05, 0.1960D-05, 0.1359D-05, 0.9340D-06,
     >    0.6419D-06, 0.4389D-06, 0.2964D-06, 0.2064D-06, 0.1387D-06,
     >    0.9274D-07, 0.6384D-07, 0.4204D-07, 0.3172D-07, 0.1801D-07,
     >    0.1322D-07, 0.9956D-08, 0.7730D-08, -.4522D-09, -.1485D-08,
     >    -.2189D-08, -.2668D-08, -.2995D-08, -.3218D-08, -.3369D-08,
     >    -.3473D-08/

      data (calcpts(j, 5), j = 1,neta) /0.3277D-07, 0.3971D-07,
     >    0.4810D-07, 0.5828D-07, 0.7061D-07, 0.8555D-07, 0.1036D-06,
     >    0.1256D-06, 0.1522D-06, 0.1844D-06, 0.2235D-06, 0.2708D-06,
     >    0.3283D-06, 0.3982D-06, 0.4830D-06, 0.5863D-06, 0.7124D-06,
     >    0.8667D-06, 0.1056D-05, 0.1291D-05, 0.1584D-05, 0.1954D-05,
     >    0.2430D-05, 0.3052D-05, 0.3886D-05, 0.5032D-05, 0.6644D-05,
     >    0.8958D-05, 0.1231D-04, 0.1717D-04, 0.2403D-04, 0.3332D-04,
     >    0.4497D-04, 0.5803D-04, 0.7035D-04, 0.7913D-04, 0.8209D-04,
     >    0.7883D-04, 0.7075D-04, 0.6016D-04, 0.4905D-04, 0.3866D-04,
     >    0.2965D-04, 0.2222D-04, 0.1633D-04, 0.1179D-04, 0.8411D-05,
     >    0.5937D-05, 0.4149D-05, 0.2887D-05, 0.1997D-05, 0.1377D-05,
     >    0.9428D-06, 0.6499D-06, 0.4463D-06, 0.3037D-06, 0.2070D-06,
     >    0.1459D-06, 0.9995D-07, 0.7108D-07, 0.4928D-07, 0.3230D-07,
     >    0.2527D-07, 0.2048D-07, 0.1055D-07, 0.8328D-08, 0.6813D-08,
     >    0.5781D-08, 0.5079D-08, 0.4599D-08, 0.4273D-08, 0.4051D-08,
     >    0.3899D-08/

      data (calcpts(j, 6), j = 1,neta) /0.4805D-07, 0.5822D-07,
     >    0.7053D-07, 0.8545D-07, 0.1035D-06, 0.1254D-06, 0.1520D-06,
     >    0.1842D-06, 0.2231D-06, 0.2704D-06, 0.3277D-06, 0.3971D-06,
     >    0.4815D-06, 0.5839D-06, 0.7082D-06, 0.8597D-06, 0.1045D-05,
     >    0.1271D-05, 0.1549D-05, 0.1893D-05, 0.2323D-05, 0.2866D-05,
     >    0.3563D-05, 0.4475D-05, 0.5698D-05, 0.7377D-05, 0.9741D-05,
     >    0.1313D-04, 0.1806D-04, 0.2517D-04, 0.3524D-04, 0.4885D-04,
     >    0.6594D-04, 0.8508D-04, 0.1032D-03, 0.1160D-03, 0.1204D-03,
     >    0.1156D-03, 0.1037D-03, 0.8819D-04, 0.7189D-04, 0.5667D-04,
     >    0.4346D-04, 0.3256D-04, 0.2392D-04, 0.1729D-04, 0.1232D-04,
     >    0.8691D-05, 0.6081D-05, 0.4225D-05, 0.2921D-05, 0.2010D-05,
     >    0.1380D-05, 0.9449D-06, 0.6514D-06, 0.4410D-06, 0.3051D-06,
     >    0.2084D-06, 0.1406D-06, 0.9476D-07, 0.6592D-07, 0.4414D-07,
     >    0.3385D-07, 0.2016D-07, 0.1538D-07, 0.1212D-07, 0.9899D-08,
     >    0.8387D-08, 0.6908D-09, -.1138D-10, -.4898D-09, -.8155D-09,
     >    -.1037D-08/

      data (calcpts(j, 7), j = 1,neta) /0.7044D-07, 0.8534D-07,
     >    0.1034D-06, 0.1253D-06, 0.1518D-06, 0.1839D-06, 0.2228D-06,
     >    0.2699D-06, 0.3270D-06, 0.3963D-06, 0.4803D-06, 0.5821D-06,
     >    0.7057D-06, 0.8558D-06, 0.1038D-05, 0.1260D-05, 0.1531D-05,
     >    0.1863D-05, 0.2270D-05, 0.2775D-05, 0.3405D-05, 0.4200D-05,
     >    0.5222D-05, 0.6559D-05, 0.8351D-05, 0.1081D-04, 0.1428D-04,
     >    0.1925D-04, 0.2646D-04, 0.3688D-04, 0.5164D-04, 0.7160D-04,
     >    0.9666D-04, 0.1247D-03, 0.1512D-03, 0.1701D-03, 0.1764D-03,
     >    0.1694D-03, 0.1520D-03, 0.1292D-03, 0.1053D-03, 0.8300D-04,
     >    0.6365D-04, 0.4768D-04, 0.3504D-04, 0.2532D-04, 0.1805D-04,
     >    0.1274D-04, 0.8887D-05, 0.6193D-05, 0.4276D-05, 0.2941D-05,
     >    0.2053D-05, 0.1382D-05, 0.9261D-06, 0.6392D-06, 0.4224D-06,
     >    0.3199D-06, 0.1833D-06, 0.1356D-06, 0.1032D-06, 0.8102D-07,
     >    0.6595D-07, 0.5567D-07, 0.4867D-07, 0.4390D-07, 0.4065D-07,
     >    0.3843D-07, 0.3693D-07, 0.3590D-07, 0.3520D-07, 0.3472D-07,
     >    0.3440D-07/

      data (calcpts(j, 8), j = 1,neta) /0.1032D-06, 0.1250D-06,
     >    0.1515D-06, 0.1835D-06, 0.2223D-06, 0.2694D-06, 0.3264D-06,
     >    0.3955D-06, 0.4791D-06, 0.5806D-06, 0.7037D-06, 0.8529D-06,
     >    0.1034D-05, 0.1254D-05, 0.1521D-05, 0.1846D-05, 0.2243D-05,
     >    0.2729D-05, 0.3326D-05, 0.4065D-05, 0.4988D-05, 0.6154D-05,
     >    0.7650D-05, 0.9609D-05, 0.1223D-04, 0.1583D-04, 0.2091D-04,
     >    0.2819D-04, 0.3875D-04, 0.5401D-04, 0.7562D-04, 0.1049D-03,
     >    0.1415D-03, 0.1826D-03, 0.2215D-03, 0.2492D-03, 0.2585D-03,
     >    0.2481D-03, 0.2226D-03, 0.1892D-03, 0.1542D-03, 0.1215D-03,
     >    0.9315D-04, 0.6981D-04, 0.5128D-04, 0.3707D-04, 0.2644D-04,
     >    0.1866D-04, 0.1302D-04, 0.9091D-05, 0.6303D-05, 0.4304D-05,
     >    0.2964D-05, 0.2075D-05, 0.1403D-05, 0.9480D-06, 0.6617D-06,
     >    0.4450D-06, 0.3427D-06, 0.2064D-06, 0.1589D-06, 0.1265D-06,
     >    0.1045D-06, 0.8944D-07, 0.1253D-07, 0.5554D-08, 0.8006D-09,
     >    -.2439D-08, -.4644D-08, -.6148D-08, -.7172D-08, -.7870D-08,
     >    -.8345D-08/

      data (calcpts(j, 9), j = 1,neta) /0.1510D-06, 0.1829D-06,
     >    0.2216D-06, 0.2685D-06, 0.3253D-06, 0.3941D-06, 0.4775D-06,
     >    0.5786D-06, 0.7010D-06, 0.8495D-06, 0.1030D-05, 0.1248D-05,
     >    0.1513D-05, 0.1834D-05, 0.2225D-05, 0.2701D-05, 0.3282D-05,
     >    0.3992D-05, 0.4866D-05, 0.5948D-05, 0.7297D-05, 0.9002D-05,
     >    0.1119D-04, 0.1406D-04, 0.1789D-04, 0.2316D-04, 0.3058D-04,
     >    0.4123D-04, 0.5667D-04, 0.7900D-04, 0.1106D-03, 0.1534D-03,
     >    0.2071D-03, 0.2673D-03, 0.3241D-03, 0.3646D-03, 0.3781D-03,
     >    0.3629D-03, 0.3255D-03, 0.2765D-03, 0.2252D-03, 0.1775D-03,
     >    0.1361D-03, 0.1019D-03, 0.7488D-04, 0.5409D-04, 0.3859D-04,
     >    0.2717D-04, 0.1898D-04, 0.1318D-04, 0.9152D-05, 0.6280D-05,
     >    0.4277D-05, 0.2938D-05, 0.1983D-05, 0.1379D-05, 0.9252D-06,
     >    0.6396D-06, 0.4236D-06, 0.2553D-06, 0.1859D-06, 0.1387D-06,
     >    0.3983D-07, 0.1788D-07, 0.2928D-08, -.7253D-08, -.1419D-07,
     >    -.1892D-07, -.2214D-07, -.2433D-07, -.2583D-07, -.2685D-07,
     >    -.2754D-07/

      data (calcpts(j,10), j = 1,neta) /0.2207D-06, 0.2674D-06,
     >    0.3239D-06, 0.3924D-06, 0.4755D-06, 0.5761D-06, 0.6980D-06,
     >    0.8458D-06, 0.1025D-05, 0.1242D-05, 0.1505D-05, 0.1824D-05,
     >    0.2211D-05, 0.2681D-05, 0.3252D-05, 0.3948D-05, 0.4797D-05,
     >    0.5836D-05, 0.7113D-05, 0.8694D-05, 0.1066D-04, 0.1316D-04,
     >    0.1636D-04, 0.2054D-04, 0.2614D-04, 0.3384D-04, 0.4467D-04,
     >    0.6022D-04, 0.8277D-04, 0.1154D-03, 0.1615D-03, 0.2240D-03,
     >    0.3025D-03, 0.3905D-03, 0.4737D-03, 0.5328D-03, 0.5527D-03,
     >    0.5302D-03, 0.4753D-03, 0.4036D-03, 0.3286D-03, 0.2589D-03,
     >    0.1984D-03, 0.1486D-03, 0.1092D-03, 0.7896D-04, 0.5628D-04,
     >    0.3968D-04, 0.2778D-04, 0.1927D-04, 0.1335D-04, 0.9172D-05,
     >    0.6298D-05, 0.4299D-05, 0.2963D-05, 0.2012D-05, 0.1345D-05,
     >    0.9590D-06, 0.6082D-06, 0.4600D-06, 0.2924D-06, 0.2235D-06,
     >    0.1100D-06, 0.7802D-07, 0.5624D-07, 0.4141D-07, 0.3130D-07,
     >    0.2441D-07, 0.1972D-07, 0.1652D-07, 0.1435D-07, 0.1286D-07,
     >    0.1185D-07/

      data (calcpts(j,11), j = 1,neta) /0.3220D-06, 0.3901D-06,
     >    0.4725D-06, 0.5725D-06, 0.6937D-06, 0.8405D-06, 0.1018D-05,
     >    0.1234D-05, 0.1495D-05, 0.1811D-05, 0.2195D-05, 0.2661D-05,
     >    0.3226D-05, 0.3912D-05, 0.4745D-05, 0.5760D-05, 0.6999D-05,
     >    0.8514D-05, 0.1038D-04, 0.1268D-04, 0.1556D-04, 0.1919D-04,
     >    0.2385D-04, 0.2996D-04, 0.3812D-04, 0.4934D-04, 0.6512D-04,
     >    0.8776D-04, 0.1206D-03, 0.1681D-03, 0.2354D-03, 0.3265D-03,
     >    0.4410D-03, 0.5695D-03, 0.6909D-03, 0.7773D-03, 0.8061D-03,
     >    0.7730D-03, 0.6925D-03, 0.5877D-03, 0.4781D-03, 0.3765D-03,
     >    0.2886D-03, 0.2162D-03, 0.1589D-03, 0.1148D-03, 0.8193D-04,
     >    0.5780D-04, 0.4049D-04, 0.2811D-04, 0.1949D-04, 0.1344D-04,
     >    0.9262D-05, 0.6335D-05, 0.4346D-05, 0.3018D-05, 0.2074D-05,
     >    0.1411D-05, 0.1028D-05, 0.6800D-06, 0.4667D-06, 0.3667D-06,
     >    0.2320D-06, 0.1856D-06, 0.1540D-06, 0.1325D-06, 0.1178D-06,
     >    0.1078D-06, 0.1010D-06, 0.9635D-07, 0.9319D-07, 0.9104D-07,
     >    0.8957D-07/

      data (calcpts(j,12), j = 1,neta) /0.4683D-06, 0.5674D-06,
     >    0.6873D-06, 0.8327D-06, 0.1009D-05, 0.1222D-05, 0.1481D-05,
     >    0.1795D-05, 0.2174D-05, 0.2635D-05, 0.3193D-05, 0.3870D-05,
     >    0.4692D-05, 0.5689D-05, 0.6901D-05, 0.8377D-05, 0.1018D-04,
     >    0.1238D-04, 0.1509D-04, 0.1844D-04, 0.2262D-04, 0.2790D-04,
     >    0.3468D-04, 0.4354D-04, 0.5541D-04, 0.7170D-04, 0.9460D-04,
     >    0.1275D-03, 0.1751D-03, 0.2441D-03, 0.3418D-03, 0.4742D-03,
     >    0.6407D-03, 0.8277D-03, 0.1005D-02, 0.1130D-02, 0.1172D-02,
     >    0.1123D-02, 0.1005D-02, 0.8521D-03, 0.6927D-03, 0.5450D-03,
     >    0.4176D-03, 0.3128D-03, 0.2299D-03, 0.1662D-03, 0.1186D-03,
     >    0.8370D-04, 0.5860D-04, 0.4075D-04, 0.2823D-04, 0.1950D-04,
     >    0.1342D-04, 0.9210D-05, 0.6376D-05, 0.4340D-05, 0.3028D-05,
     >    0.2093D-05, 0.1437D-05, 0.1060D-05, 0.7149D-06, 0.5039D-06,
     >    0.4057D-06, 0.2720D-06, 0.2264D-06, 0.1953D-06, 0.1741D-06,
     >    0.1597D-06, 0.1499D-06, 0.1431D-06, 0.1386D-06, 0.1355D-06,
     >    0.1334D-06/

      data (calcpts(j,13), j = 1,neta) /0.6783D-06, 0.8219D-06,
     >    0.9956D-06, 0.1206D-05, 0.1462D-05, 0.1771D-05, 0.2145D-05,
     >    0.2600D-05, 0.3150D-05, 0.3817D-05, 0.4626D-05, 0.5606D-05,
     >    0.6796D-05, 0.8242D-05, 0.9996D-05, 0.1213D-04, 0.1474D-04,
     >    0.1793D-04, 0.2186D-04, 0.2671D-04, 0.3276D-04, 0.4041D-04,
     >    0.5021D-04, 0.6303D-04, 0.8018D-04, 0.1037D-03, 0.1368D-03,
     >    0.1842D-03, 0.2531D-03, 0.3527D-03, 0.4939D-03, 0.6854D-03,
     >    0.9269D-03, 0.1198D-02, 0.1455D-02, 0.1638D-02, 0.1697D-02,
     >    0.1625D-02, 0.1452D-02, 0.1229D-02, 0.9978D-03, 0.7844D-03,
     >    0.6007D-03, 0.4499D-03, 0.3307D-03, 0.2392D-03, 0.1708D-03,
     >    0.1206D-03, 0.8451D-04, 0.5882D-04, 0.4067D-04, 0.2798D-04,
     >    0.1955D-04, 0.1315D-04, 0.9469D-05, 0.6745D-05, 0.4676D-05,
     >    0.3051D-05, 0.2398D-05, 0.1953D-05, 0.9828D-06, 0.7760D-06,
     >    0.6353D-06, 0.5393D-06, 0.4738D-06, 0.4293D-06, 0.3989D-06,
     >    0.3782D-06, 0.3641D-06, 0.3545D-06, 0.3480D-06, 0.3435D-06,
     >    0.3405D-06/

      data (calcpts(j,14), j = 1,neta) /0.9761D-06, 0.1183D-05,
     >    0.1433D-05, 0.1736D-05, 0.2103D-05, 0.2548D-05, 0.3087D-05,
     >    0.3741D-05, 0.4532D-05, 0.5492D-05, 0.6656D-05, 0.8067D-05,
     >    0.9780D-05, 0.1186D-04, 0.1438D-04, 0.1746D-04, 0.2121D-04,
     >    0.2580D-04, 0.3145D-04, 0.3843D-04, 0.4712D-04, 0.5811D-04,
     >    0.7220D-04, 0.9060D-04, 0.1152D-03, 0.1490D-03, 0.1964D-03,
     >    0.2644D-03, 0.3630D-03, 0.5058D-03, 0.7084D-03, 0.9837D-03,
     >    0.1331D-02, 0.1722D-02, 0.2093D-02, 0.2357D-02, 0.2442D-02,
     >    0.2335D-02, 0.2083D-02, 0.1759D-02, 0.1425D-02, 0.1118D-02,
     >    0.8558D-03, 0.6404D-03, 0.4707D-03, 0.3408D-03, 0.2433D-03,
     >    0.1714D-03, 0.1205D-03, 0.8340D-04, 0.5819D-04, 0.4026D-04,
     >    0.2781D-04, 0.1890D-04, 0.1263D-04, 0.9049D-05, 0.6393D-05,
     >    0.4368D-05, 0.2775D-05, 0.2145D-05, 0.1714D-05, 0.7546D-06,
     >    0.5551D-06, 0.4189D-06, 0.3261D-06, 0.2630D-06, 0.2199D-06,
     >    0.1906D-06, 0.1707D-06, 0.1570D-06, 0.1478D-06, 0.1414D-06,
     >    0.1371D-06/

      data (calcpts(j,15), j = 1,neta) /0.1392D-05, 0.1687D-05,
     >    0.2044D-05, 0.2476D-05, 0.3000D-05, 0.3635D-05, 0.4404D-05,
     >    0.5337D-05, 0.6465D-05, 0.7835D-05, 0.9495D-05, 0.1151D-04,
     >    0.1395D-04, 0.1692D-04, 0.2052D-04, 0.2491D-04, 0.3026D-04,
     >    0.3680D-04, 0.4485D-04, 0.5480D-04, 0.6719D-04, 0.8283D-04,
     >    0.1029D-03, 0.1290D-03, 0.1640D-03, 0.2119D-03, 0.2792D-03,
     >    0.3756D-03, 0.5155D-03, 0.7180D-03, 0.1006D-02, 0.1397D-02,
     >    0.1893D-02, 0.2452D-02, 0.2984D-02, 0.3362D-02, 0.3482D-02,
     >    0.3324D-02, 0.2956D-02, 0.2488D-02, 0.2009D-02, 0.1574D-02,
     >    0.1203D-02, 0.9001D-03, 0.6612D-03, 0.4787D-03, 0.3412D-03,
     >    0.2412D-03, 0.1686D-03, 0.1173D-03, 0.8115D-04, 0.5598D-04,
     >    0.3859D-04, 0.2589D-04, 0.1793D-04, 0.1186D-04, 0.8419D-05,
     >    0.5190D-05, 0.3898D-05, 0.2351D-05, 0.1751D-05, 0.6754D-06,
     >    0.3970D-06, 0.2070D-06, 0.7757D-07, -.1055D-07, -.7060D-07,
     >    -.1115D-06, -.1394D-06, -.1584D-06, -.1713D-06, -.1801D-06,
     >    -.1862D-06/

      data (calcpts(j,16), j = 1,neta) /0.1963D-05, 0.2378D-05,
     >    0.2881D-05, 0.3490D-05, 0.4229D-05, 0.5124D-05, 0.6208D-05,
     >    0.7522D-05, 0.9113D-05, 0.1104D-04, 0.1338D-04, 0.1622D-04,
     >    0.1966D-04, 0.2384D-04, 0.2892D-04, 0.3510D-04, 0.4264D-04,
     >    0.5186D-04, 0.6319D-04, 0.7719D-04, 0.9463D-04, 0.1166D-03,
     >    0.1448D-03, 0.1815D-03, 0.2304D-03, 0.2975D-03, 0.3914D-03,
     >    0.5261D-03, 0.7214D-03, 0.1005D-02, 0.1407D-02, 0.1957D-02,
     >    0.2654D-02, 0.3445D-02, 0.4200D-02, 0.4737D-02, 0.4905D-02,
     >    0.4672D-02, 0.4139D-02, 0.3467D-02, 0.2788D-02, 0.2177D-02,
     >    0.1661D-02, 0.1242D-02, 0.9134D-03, 0.6611D-03, 0.4721D-03,
     >    0.3337D-03, 0.2342D-03, 0.1627D-03, 0.1128D-03, 0.7755D-04,
     >    0.5352D-04, 0.3630D-04, 0.2484D-04, 0.1728D-04, 0.1149D-04,
     >    0.7571D-05, 0.5140D-05, 0.3272D-05, 0.2453D-05, 0.1894D-05,
     >    0.8474D-06, 0.5881D-06, 0.4114D-06, 0.2911D-06, 0.2091D-06,
     >    0.1532D-06, 0.1152D-06, 0.8923D-07, 0.7155D-07, 0.5952D-07,
     >    0.5132D-07/

      data (calcpts(j,17), j = 1,neta) /0.2719D-05, 0.3294D-05,
     >    0.3990D-05, 0.4835D-05, 0.5858D-05, 0.7098D-05, 0.8599D-05,
     >    0.1042D-04, 0.1262D-04, 0.1530D-04, 0.1854D-04, 0.2247D-04,
     >    0.2724D-04, 0.3303D-04, 0.4005D-04, 0.4862D-04, 0.5906D-04,
     >    0.7181D-04, 0.8748D-04, 0.1068D-03, 0.1309D-03, 0.1613D-03,
     >    0.2001D-03, 0.2506D-03, 0.3179D-03, 0.4097D-03, 0.5383D-03,
     >    0.7223D-03, 0.9891D-03, 0.1376D-02, 0.1929D-02, 0.2685D-02,
     >    0.3648D-02, 0.4749D-02, 0.5806D-02, 0.6560D-02, 0.6792D-02,
     >    0.6451D-02, 0.5686D-02, 0.4731D-02, 0.3782D-02, 0.2938D-02,
     >    0.2236D-02, 0.1671D-02, 0.1228D-02, 0.8906D-03, 0.6366D-03,
     >    0.4510D-03, 0.3165D-03, 0.2206D-03, 0.1529D-03, 0.1054D-03,
     >    0.7247D-04, 0.5007D-04, 0.3397D-04, 0.2328D-04, 0.1627D-04,
     >    0.1085D-04, 0.7844D-05, 0.4920D-05, 0.3835D-05, 0.2430D-05,
     >    0.1926D-05, 0.1583D-05, 0.6827D-06, 0.5235D-06, 0.4149D-06,
     >    0.3410D-06, 0.2907D-06, 0.2563D-06, 0.2329D-06, 0.2170D-06,
     >    0.2062D-06/

      data (calcpts(j,18), j = 1,neta) /0.3677D-05, 0.4455D-05,
     >    0.5396D-05, 0.6538D-05, 0.7922D-05, 0.9598D-05, 0.1163D-04,
     >    0.1409D-04, 0.1707D-04, 0.2068D-04, 0.2507D-04, 0.3038D-04,
     >    0.3683D-04, 0.4466D-04, 0.5415D-04, 0.6572D-04, 0.7983D-04,
     >    0.9706D-04, 0.1182D-03, 0.1443D-03, 0.1768D-03, 0.2176D-03,
     >    0.2697D-03, 0.3374D-03, 0.4273D-03, 0.5497D-03, 0.7207D-03,
     >    0.9649D-03, 0.1319D-02, 0.1833D-02, 0.2568D-02, 0.3579D-02,
     >    0.4879D-02, 0.6374D-02, 0.7823D-02, 0.8865D-02, 0.9184D-02,
     >    0.8698D-02, 0.7616D-02, 0.6282D-02, 0.4975D-02, 0.3839D-02,
     >    0.2909D-02, 0.2170D-02, 0.1597D-02, 0.1158D-02, 0.8295D-03,
     >    0.5883D-03, 0.4137D-03, 0.2884D-03, 0.2003D-03, 0.1379D-03,
     >    0.9479D-04, 0.6551D-04, 0.4453D-04, 0.3054D-04, 0.2084D-04,
     >    0.1450D-04, 0.9540D-05, 0.6857D-05, 0.4815D-05, 0.3211D-05,
     >    0.1906D-05, 0.1471D-05, 0.1174D-05, 0.9723D-06, 0.1680D-06,
     >    0.7420D-07, 0.1038D-07, -.3316D-07, -.6282D-07, -.8302D-07,
     >    -.9678D-07/

      data (calcpts(j,19), j = 1,neta) /0.4815D-05, 0.5834D-05,
     >    0.7067D-05, 0.8563D-05, 0.1038D-04, 0.1257D-04, 0.1523D-04,
     >    0.1845D-04, 0.2236D-04, 0.2709D-04, 0.3283D-04, 0.3979D-04,
     >    0.4823D-04, 0.5848D-04, 0.7091D-04, 0.8605D-04, 0.1045D-03,
     >    0.1270D-03, 0.1547D-03, 0.1887D-03, 0.2310D-03, 0.2842D-03,
     >    0.3518D-03, 0.4393D-03, 0.5551D-03, 0.7123D-03, 0.9310D-03,
     >    0.1242D-02, 0.1694D-02, 0.2349D-02, 0.3290D-02, 0.4593D-02,
     >    0.6281D-02, 0.8248D-02, 0.1018D-01, 0.1159D-01, 0.1204D-01,
     >    0.1138D-01, 0.9887D-02, 0.8062D-02, 0.6306D-02, 0.4815D-02,
     >    0.3625D-02, 0.2697D-02, 0.1984D-02, 0.1442D-02, 0.1035D-02,
     >    0.7363D-03, 0.5187D-03, 0.3626D-03, 0.2517D-03, 0.1742D-03,
     >    0.1200D-03, 0.8207D-04, 0.5639D-04, 0.3855D-04, 0.2627D-04,
     >    0.1773D-04, 0.1218D-04, 0.8433D-05, 0.5453D-05, 0.3663D-05,
     >    0.2898D-05, 0.1710D-05, 0.1355D-05, 0.1113D-05, 0.2814D-06,
     >    0.1690D-06, 0.9258D-07, 0.4042D-07, 0.4880D-08, -.1932D-07,
     >    -.3580D-07/

      data (calcpts(j,20), j = 1,neta) /0.6052D-05, 0.7332D-05,
     >    0.8882D-05, 0.1076D-04, 0.1304D-04, 0.1580D-04, 0.1914D-04,
     >    0.2319D-04, 0.2810D-04, 0.3405D-04, 0.4126D-04, 0.5000D-04,
     >    0.6060D-04, 0.7348D-04, 0.8909D-04, 0.1081D-03, 0.1313D-03,
     >    0.1595D-03, 0.1941D-03, 0.2368D-03, 0.2896D-03, 0.3558D-03,
     >    0.4397D-03, 0.5479D-03, 0.6905D-03, 0.8828D-03, 0.1149D-02,
     >    0.1527D-02, 0.2073D-02, 0.2866D-02, 0.4009D-02, 0.5604D-02,
     >    0.7695D-02, 0.1017D-01, 0.1265D-01, 0.1452D-01, 0.1516D-01,
     >    0.1433D-01, 0.1237D-01, 0.9951D-02, 0.7656D-02, 0.5758D-02,
     >    0.4289D-02, 0.3177D-02, 0.2336D-02, 0.1702D-02, 0.1227D-02,
     >    0.8756D-03, 0.6190D-03, 0.4342D-03, 0.3023D-03, 0.2098D-03,
     >    0.1449D-03, 0.9966D-04, 0.6879D-04, 0.4702D-04, 0.3254D-04,
     >    0.2208D-04, 0.1546D-04, 0.1077D-04, 0.7606D-05, 0.5022D-05,
     >    0.3505D-05, 0.2924D-05, 0.1862D-05, 0.1593D-05, 0.1409D-05,
     >    0.6174D-06, 0.5323D-06, 0.4742D-06, 0.4347D-06, 0.4077D-06,
     >    0.3894D-06/

      data (calcpts(j,21), j = 1,neta) /0.7225D-05, 0.8754D-05,
     >    0.1060D-04, 0.1285D-04, 0.1557D-04, 0.1886D-04, 0.2285D-04,
     >    0.2769D-04, 0.3354D-04, 0.4064D-04, 0.4925D-04, 0.5969D-04,
     >    0.7234D-04, 0.8770D-04, 0.1063D-03, 0.1290D-03, 0.1566D-03,
     >    0.1902D-03, 0.2314D-03, 0.2821D-03, 0.3446D-03, 0.4228D-03,
     >    0.5215D-03, 0.6482D-03, 0.8139D-03, 0.1036D-02, 0.1341D-02,
     >    0.1772D-02, 0.2391D-02, 0.3291D-02, 0.4591D-02, 0.6420D-02,
     >    0.8852D-02, 0.1179D-01, 0.1482D-01, 0.1722D-01, 0.1815D-01,
     >    0.1725D-01, 0.1484D-01, 0.1179D-01, 0.8890D-02, 0.6547D-02,
     >    0.4798D-02, 0.3523D-02, 0.2586D-02, 0.1889D-02, 0.1369D-02,
     >    0.9817D-03, 0.6970D-03, 0.4904D-03, 0.3405D-03, 0.2364D-03,
     >    0.1636D-03, 0.1165D-03, 0.7802D-04, 0.5204D-04, 0.3676D-04,
     >    0.2420D-04, 0.1352D-04, 0.1079D-04, 0.8921D-05, 0.7650D-05,
     >    0.1180D-06, -.4722D-06, -.8743D-06, -.1148D-05, -.1335D-05,
     >    -.1462D-05, -.1548D-05, -.1607D-05, -.1648D-05, -.1675D-05,
     >    -.1694D-05/

      data (calcpts(j,22), j = 1,neta) /0.8126D-05, 0.9846D-05,
     >    0.1193D-04, 0.1445D-04, 0.1751D-04, 0.2121D-04, 0.2570D-04,
     >    0.3114D-04, 0.3772D-04, 0.4571D-04, 0.5539D-04, 0.6712D-04,
     >    0.8135D-04, 0.9862D-04, 0.1195D-03, 0.1450D-03, 0.1760D-03,
     >    0.2137D-03, 0.2598D-03, 0.3164D-03, 0.3862D-03, 0.4730D-03,
     >    0.5821D-03, 0.7212D-03, 0.9018D-03, 0.1142D-02, 0.1468D-02,
     >    0.1925D-02, 0.2577D-02, 0.3522D-02, 0.4889D-02, 0.6829D-02,
     >    0.9448D-02, 0.1269D-01, 0.1617D-01, 0.1908D-01, 0.2047D-01,
     >    0.1972D-01, 0.1705D-01, 0.1345D-01, 0.9946D-02, 0.7133D-02,
     >    0.5103D-02, 0.3690D-02, 0.2694D-02, 0.1972D-02, 0.1441D-02,
     >    0.1041D-02, 0.7446D-03, 0.5284D-03, 0.3724D-03, 0.2599D-03,
     >    0.1772D-03, 0.1258D-03, 0.8889D-04, 0.5733D-04, 0.4279D-04,
     >    0.3074D-04, 0.2041D-04, 0.1124D-04, 0.9540D-05, 0.8379D-05,
     >    0.9215D-06, 0.3822D-06, 0.1478D-07, -.2354D-06, -.4059D-06,
     >    -.5221D-06, -.6012D-06, -.6551D-06, -.6919D-06, -.7169D-06,
     >    -.7339D-06/

      data (calcpts(j,23), j = 1,neta) /0.8555D-05, 0.1037D-04,
     >    0.1256D-04, 0.1521D-04, 0.1843D-04, 0.2233D-04, 0.2706D-04,
     >    0.3278D-04, 0.3971D-04, 0.4812D-04, 0.5831D-04, 0.7066D-04,
     >    0.8563D-04, 0.1038D-03, 0.1258D-03, 0.1526D-03, 0.1851D-03,
     >    0.2247D-03, 0.2731D-03, 0.3323D-03, 0.4050D-03, 0.4952D-03,
     >    0.6079D-03, 0.7506D-03, 0.9342D-03, 0.1175D-02, 0.1500D-02,
     >    0.1948D-02, 0.2582D-02, 0.3494D-02, 0.4813D-02, 0.6696D-02,
     >    0.9276D-02, 0.1255D-01, 0.1623D-01, 0.1956D-01, 0.2150D-01,
     >    0.2122D-01, 0.1870D-01, 0.1484D-01, 0.1085D-01, 0.7583D-02,
     >    0.5254D-02, 0.3705D-02, 0.2674D-02, 0.1958D-02, 0.1439D-02,
     >    0.1054D-02, 0.7605D-03, 0.5451D-03, 0.3902D-03, 0.2743D-03,
     >    0.1917D-03, 0.1316D-03, 0.9125D-04, 0.6188D-04, 0.4216D-04,
     >    0.3112D-04, 0.2148D-04, 0.1279D-04, 0.1140D-04, 0.3796D-05,
     >    0.3154D-05, 0.2717D-05, 0.2418D-05, 0.2215D-05, 0.2077D-05,
     >    0.1983D-05, 0.1919D-05, 0.1875D-05, 0.1845D-05, 0.1825D-05,
     >    0.1811D-05/

      data (calcpts(j,24), j = 1,neta) /0.8413D-05, 0.1019D-04,
     >    0.1235D-04, 0.1496D-04, 0.1813D-04, 0.2196D-04, 0.2661D-04,
     >    0.3224D-04, 0.3905D-04, 0.4732D-04, 0.5734D-04, 0.6948D-04,
     >    0.8420D-04, 0.1020D-03, 0.1237D-03, 0.1500D-03, 0.1819D-03,
     >    0.2207D-03, 0.2680D-03, 0.3259D-03, 0.3968D-03, 0.4842D-03,
     >    0.5930D-03, 0.7296D-03, 0.9037D-03, 0.1130D-02, 0.1429D-02,
     >    0.1837D-02, 0.2406D-02, 0.3215D-02, 0.4381D-02, 0.6047D-02,
     >    0.8359D-02, 0.1138D-01, 0.1491D-01, 0.1838D-01, 0.2084D-01,
     >    0.2132D-01, 0.1945D-01, 0.1584D-01, 0.1168D-01, 0.8046D-02,
     >    0.5399D-02, 0.3674D-02, 0.2589D-02, 0.1882D-02, 0.1394D-02,
     >    0.1027D-02, 0.7572D-03, 0.5472D-03, 0.3965D-03, 0.2795D-03,
     >    0.1985D-03, 0.1375D-03, 0.9440D-04, 0.6770D-04, 0.4313D-04,
     >    0.3334D-04, 0.2454D-04, 0.1643D-04, 0.8770D-05, 0.8095D-05,
     >    0.7637D-05, 0.6570D-06, 0.4437D-06, 0.2984D-06, 0.1995D-06,
     >    0.1320D-06, 0.8611D-07, 0.5480D-07, 0.3347D-07, 0.1894D-07,
     >    0.9044D-08/

      data (calcpts(j,25), j = 1,neta) /0.7746D-05, 0.9385D-05,
     >    0.1137D-04, 0.1377D-04, 0.1669D-04, 0.2022D-04, 0.2450D-04,
     >    0.2968D-04, 0.3595D-04, 0.4356D-04, 0.5279D-04, 0.6396D-04,
     >    0.7750D-04, 0.9393D-04, 0.1138D-03, 0.1380D-03, 0.1673D-03,
     >    0.2030D-03, 0.2464D-03, 0.2993D-03, 0.3640D-03, 0.4435D-03,
     >    0.5418D-03, 0.6644D-03, 0.8191D-03, 0.1017D-02, 0.1276D-02,
     >    0.1623D-02, 0.2097D-02, 0.2763D-02, 0.3711D-02, 0.5062D-02,
     >    0.6951D-02, 0.9470D-02, 0.1255D-01, 0.1582D-01, 0.1854D-01,
     >    0.1980D-01, 0.1897D-01, 0.1619D-01, 0.1236D-01, 0.8615D-02,
     >    0.5685D-02, 0.3727D-02, 0.2527D-02, 0.1798D-02, 0.1322D-02,
     >    0.9898D-03, 0.7401D-03, 0.5472D-03, 0.3930D-03, 0.2873D-03,
     >    0.2008D-03, 0.1385D-03, 0.9903D-04, 0.6815D-04, 0.4528D-04,
     >    0.2999D-04, 0.2199D-04, 0.1441D-04, 0.1379D-04, 0.6702D-05,
     >    0.6414D-05, 0.6217D-05, -.5833D-06, -.6745D-06, -.7366D-06,
     >    -.7790D-06, -.8078D-06, -.8274D-06, -.8408D-06, -.8499D-06,
     >    -.8561D-06/

      data (calcpts(j,26), j = 1,neta) /0.6715D-05, 0.8136D-05,
     >    0.9855D-05, 0.1194D-04, 0.1447D-04, 0.1753D-04, 0.2123D-04,
     >    0.2573D-04, 0.3117D-04, 0.3776D-04, 0.4576D-04, 0.5544D-04,
     >    0.6718D-04, 0.8141D-04, 0.9864D-04, 0.1196D-03, 0.1450D-03,
     >    0.1758D-03, 0.2132D-03, 0.2589D-03, 0.3145D-03, 0.3827D-03,
     >    0.4666D-03, 0.5705D-03, 0.7003D-03, 0.8648D-03, 0.1076D-02,
     >    0.1354D-02, 0.1727D-02, 0.2241D-02, 0.2960D-02, 0.3976D-02,
     >    0.5397D-02, 0.7320D-02, 0.9753D-02, 0.1251D-01, 0.1514D-01,
     >    0.1691D-01, 0.1715D-01, 0.1558D-01, 0.1263D-01, 0.9184D-02,
     >    0.6147D-02, 0.3950D-02, 0.2568D-02, 0.1754D-02, 0.1266D-02,
     >    0.9457D-03, 0.7134D-03, 0.5339D-03, 0.3943D-03, 0.2873D-03,
     >    0.2062D-03, 0.1459D-03, 0.1026D-03, 0.7161D-04, 0.5138D-04,
     >    0.3698D-04, 0.2292D-04, 0.1576D-04, 0.8751D-05, 0.8521D-05,
     >    0.1697D-05, 0.1590D-05, 0.1517D-05, 0.1467D-05, 0.1433D-05,
     >    0.1410D-05, 0.1394D-05, 0.1384D-05, 0.1376D-05, 0.1371D-05,
     >    0.1368D-05/

      data (calcpts(j,27), j = 1,neta) /0.5527D-05, 0.6697D-05,
     >    0.8112D-05, 0.9828D-05, 0.1191D-04, 0.1443D-04, 0.1748D-04,
     >    0.2118D-04, 0.2565D-04, 0.3108D-04, 0.3766D-04, 0.4563D-04,
     >    0.5529D-04, 0.6700D-04, 0.8117D-04, 0.9838D-04, 0.1193D-03,
     >    0.1446D-03, 0.1753D-03, 0.2127D-03, 0.2582D-03, 0.3138D-03,
     >    0.3820D-03, 0.4658D-03, 0.5698D-03, 0.7001D-03, 0.8652D-03,
     >    0.1078D-02, 0.1359D-02, 0.1736D-02, 0.2254D-02, 0.2975D-02,
     >    0.3975D-02, 0.5336D-02, 0.7100D-02, 0.9208D-02, 0.1142D-01,
     >    0.1330D-01, 0.1427D-01, 0.1389D-01, 0.1213D-01, 0.9453D-02,
     >    0.6646D-02, 0.4334D-02, 0.2749D-02, 0.1791D-02, 0.1239D-02,
     >    0.9080D-03, 0.6858D-03, 0.5201D-03, 0.3907D-03, 0.2893D-03,
     >    0.2107D-03, 0.1511D-03, 0.1076D-03, 0.7520D-04, 0.5248D-04,
     >    0.3666D-04, 0.2566D-04, 0.1810D-04, 0.1261D-04, 0.8501D-05,
     >    0.6429D-05, 0.4380D-05, 0.3013D-05, 0.2324D-05, 0.1642D-05,
     >    0.1631D-05, 0.9573D-06, 0.9524D-06, 0.9491D-06, 0.9468D-06,
     >    0.9452D-06/

      data (calcpts(j,28), j = 1,neta) /0.4356D-05, 0.5278D-05,
     >    0.6393D-05, 0.7746D-05, 0.9385D-05, 0.1137D-04, 0.1377D-04,
     >    0.1669D-04, 0.2022D-04, 0.2450D-04, 0.2968D-04, 0.3596D-04,
     >    0.4357D-04, 0.5279D-04, 0.6396D-04, 0.7751D-04, 0.9394D-04,
     >    0.1139D-03, 0.1380D-03, 0.1674D-03, 0.2031D-03, 0.2466D-03,
     >    0.2997D-03, 0.3648D-03, 0.4450D-03, 0.5445D-03, 0.6690D-03,
     >    0.8273D-03, 0.1031D-02, 0.1300D-02, 0.1660D-02, 0.2150D-02,
     >    0.2822D-02, 0.3731D-02, 0.4925D-02, 0.6402D-02, 0.8068D-02,
     >    0.9700D-02, 0.1093D-01, 0.1138D-01, 0.1074D-01, 0.9100D-02,
     >    0.6902D-02, 0.4741D-02, 0.3044D-02, 0.1922D-02, 0.1261D-02,
     >    0.8844D-03, 0.6548D-03, 0.4977D-03, 0.3789D-03, 0.2847D-03,
     >    0.2103D-03, 0.1528D-03, 0.1097D-03, 0.7798D-04, 0.5441D-04,
     >    0.3824D-04, 0.2613D-04, 0.1806D-04, 0.1267D-04, 0.8635D-05,
     >    0.5944D-05, 0.3927D-05, 0.3250D-05, 0.1909D-05, 0.1237D-05,
     >    0.1233D-05, 0.5641D-06, 0.5624D-06, 0.5613D-06, 0.5605D-06,
     >    0.5600D-06/

      data (calcpts(j,29), j = 1,neta) /0.3316D-05, 0.4017D-05,
     >    0.4866D-05, 0.5896D-05, 0.7143D-05, 0.8654D-05, 0.1048D-04,
     >    0.1270D-04, 0.1539D-04, 0.1864D-04, 0.2259D-04, 0.2737D-04,
     >    0.3316D-04, 0.4018D-04, 0.4868D-04, 0.5898D-04, 0.7148D-04,
     >    0.8663D-04, 0.1050D-03, 0.1273D-03, 0.1544D-03, 0.1873D-03,
     >    0.2274D-03, 0.2764D-03, 0.3363D-03, 0.4102D-03, 0.5017D-03,
     >    0.6164D-03, 0.7619D-03, 0.9490D-03, 0.1194D-02, 0.1520D-02,
     >    0.1957D-02, 0.2541D-02, 0.3310D-02, 0.4278D-02, 0.5426D-02,
     >    0.6659D-02, 0.7797D-02, 0.8574D-02, 0.8706D-02, 0.8034D-02,
     >    0.6662D-02, 0.4955D-02, 0.3351D-02, 0.2133D-02, 0.1347D-02,
     >    0.8913D-03, 0.6316D-03, 0.4717D-03, 0.3603D-03, 0.2743D-03,
     >    0.2056D-03, 0.1516D-03, 0.1102D-03, 0.7889D-04, 0.5555D-04,
     >    0.3887D-04, 0.2687D-04, 0.1887D-04, 0.1287D-04, 0.8864D-05,
     >    0.6196D-05, 0.4195D-05, 0.2861D-05, 0.1528D-05, 0.8609D-06,
     >    0.8608D-06, 0.1940D-06, 0.1939D-06, 0.1939D-06, 0.1938D-06,
     >    0.1938D-06/

      data (calcpts(j,30), j = 1,neta) /0.2456D-05, 0.2976D-05,
     >    0.3605D-05, 0.4368D-05, 0.5292D-05, 0.6411D-05, 0.7767D-05,
     >    0.9411D-05, 0.1140D-04, 0.1381D-04, 0.1674D-04, 0.2027D-04,
     >    0.2456D-04, 0.2976D-04, 0.3606D-04, 0.4369D-04, 0.5294D-04,
     >    0.6415D-04, 0.7774D-04, 0.9423D-04, 0.1142D-03, 0.1385D-03,
     >    0.1680D-03, 0.2040D-03, 0.2478D-03, 0.3016D-03, 0.3675D-03,
     >    0.4493D-03, 0.5515D-03, 0.6804D-03, 0.8454D-03, 0.1060D-02,
     >    0.1340D-02, 0.1708D-02, 0.2186D-02, 0.2794D-02, 0.3532D-02,
     >    0.4376D-02, 0.5249D-02, 0.6019D-02, 0.6490D-02, 0.6471D-02,
     >    0.5869D-02, 0.4789D-02, 0.3513D-02, 0.2351D-02, 0.1490D-02,
     >    0.9437D-03, 0.6290D-03, 0.4496D-03, 0.3378D-03, 0.2583D-03,
     >    0.1967D-03, 0.1476D-03, 0.1085D-03, 0.7861D-04, 0.5603D-04,
     >    0.3942D-04, 0.2812D-04, 0.1948D-04, 0.1350D-04, 0.9509D-05,
     >    0.6184D-05, 0.4190D-05, 0.2860D-05, 0.2196D-05, 0.1531D-05,
     >    0.8655D-06, 0.8663D-06, 0.2002D-06, 0.2006D-06, 0.2009D-06,
     >    0.2010D-06/

      data (calcpts(j,31), j = 1,neta) /0.1782D-05, 0.2159D-05,
     >    0.2615D-05, 0.3168D-05, 0.3839D-05, 0.4650D-05, 0.5634D-05,
     >    0.6826D-05, 0.8269D-05, 0.1002D-04, 0.1214D-04, 0.1471D-04,
     >    0.1782D-04, 0.2159D-04, 0.2615D-04, 0.3169D-04, 0.3839D-04,
     >    0.4652D-04, 0.5637D-04, 0.6831D-04, 0.8278D-04, 0.1003D-03,
     >    0.1217D-03, 0.1476D-03, 0.1791D-03, 0.2175D-03, 0.2644D-03,
     >    0.3220D-03, 0.3931D-03, 0.4814D-03, 0.5922D-03, 0.7325D-03,
     >    0.9115D-03, 0.1141D-02, 0.1435D-02, 0.1805D-02, 0.2259D-02,
     >    0.2796D-02, 0.3394D-02, 0.3997D-02, 0.4507D-02, 0.4786D-02,
     >    0.4704D-02, 0.4211D-02, 0.3395D-02, 0.2465D-02, 0.1639D-02,
     >    0.1036D-02, 0.6582D-03, 0.4417D-03, 0.3174D-03, 0.2395D-03,
     >    0.1833D-03, 0.1396D-03, 0.1045D-03, 0.7664D-04, 0.5541D-04,
     >    0.3948D-04, 0.2819D-04, 0.1956D-04, 0.1358D-04, 0.9596D-05,
     >    0.6273D-05, 0.4280D-05, 0.2951D-05, 0.2288D-05, 0.1623D-05,
     >    0.9582D-06, 0.9592D-06, 0.2932D-06, 0.2937D-06, 0.2940D-06,
     >    0.2942D-06/

      data (calcpts(j,32), j = 1,neta) /0.1272D-05, 0.1541D-05,
     >    0.1866D-05, 0.2261D-05, 0.2740D-05, 0.3319D-05, 0.4021D-05,
     >    0.4872D-05, 0.5902D-05, 0.7150D-05, 0.8664D-05, 0.1050D-04,
     >    0.1272D-04, 0.1541D-04, 0.1866D-04, 0.2261D-04, 0.2740D-04,
     >    0.3320D-04, 0.4022D-04, 0.4874D-04, 0.5904D-04, 0.7155D-04,
     >    0.8673D-04, 0.1051D-03, 0.1274D-03, 0.1546D-03, 0.1876D-03,
     >    0.2278D-03, 0.2770D-03, 0.3373D-03, 0.4117D-03, 0.5039D-03,
     >    0.6187D-03, 0.7624D-03, 0.9419D-03, 0.1164D-02, 0.1437D-02,
     >    0.1763D-02, 0.2141D-02, 0.2555D-02, 0.2964D-02, 0.3298D-02,
     >    0.3459D-02, 0.3363D-02, 0.2980D-02, 0.2382D-02, 0.1717D-02,
     >    0.1136D-02, 0.7172D-03, 0.4566D-03, 0.3082D-03, 0.2229D-03,
     >    0.1680D-03, 0.1290D-03, 0.9783D-04, 0.7330D-04, 0.5406D-04,
     >    0.3879D-04, 0.2751D-04, 0.1953D-04, 0.1356D-04, 0.9569D-05,
     >    0.6245D-05, 0.4252D-05, 0.2923D-05, 0.2259D-05, 0.1594D-05,
     >    0.9291D-06, 0.2634D-06, 0.2640D-06, 0.2645D-06, 0.2648D-06,
     >    0.2650D-06/

      data (calcpts(j,33), j = 1,neta) /0.8970D-06, 0.1087D-05,
     >    0.1317D-05, 0.1595D-05, 0.1933D-05, 0.2341D-05, 0.2837D-05,
     >    0.3437D-05, 0.4163D-05, 0.5044D-05, 0.6112D-05, 0.7404D-05,
     >    0.8970D-05, 0.1087D-04, 0.1317D-04, 0.1595D-04, 0.1933D-04,
     >    0.2341D-04, 0.2837D-04, 0.3437D-04, 0.4163D-04, 0.5045D-04,
     >    0.6112D-04, 0.7405D-04, 0.8972D-04, 0.1087D-03, 0.1317D-03,
     >    0.1597D-03, 0.1936D-03, 0.2347D-03, 0.2848D-03, 0.3457D-03,
     >    0.4200D-03, 0.5106D-03, 0.6210D-03, 0.7547D-03, 0.9159D-03,
     >    0.1109D-02, 0.1336D-02, 0.1597D-02, 0.1879D-02, 0.2154D-02,
     >    0.2370D-02, 0.2463D-02, 0.2373D-02, 0.2087D-02, 0.1657D-02,
     >    0.1189D-02, 0.7842D-03, 0.4950D-03, 0.3161D-03, 0.2139D-03,
     >    0.1556D-03, 0.1179D-03, 0.9002D-04, 0.6880D-04, 0.5155D-04,
     >    0.3760D-04, 0.2763D-04, 0.1966D-04, 0.1368D-04, 0.9687D-05,
     >    0.7028D-05, 0.5033D-05, 0.3036D-05, 0.2372D-05, 0.1707D-05,
     >    0.1042D-05, 0.1042D-05, 0.3762D-06, 0.3766D-06, 0.3768D-06,
     >    0.3770D-06/

      data (calcpts(j,34), j = 1,neta) /0.6268D-06, 0.7595D-06,
     >    0.9200D-06, 0.1115D-05, 0.1351D-05, 0.1636D-05, 0.1982D-05,
     >    0.2402D-05, 0.2909D-05, 0.3525D-05, 0.4271D-05, 0.5174D-05,
     >    0.6268D-05, 0.7595D-05, 0.9200D-05, 0.1115D-04, 0.1350D-04,
     >    0.1636D-04, 0.1982D-04, 0.2401D-04, 0.2908D-04, 0.3523D-04,
     >    0.4268D-04, 0.5169D-04, 0.6260D-04, 0.7581D-04, 0.9176D-04,
     >    0.1110D-03, 0.1343D-03, 0.1624D-03, 0.1961D-03, 0.2367D-03,
     >    0.2851D-03, 0.3429D-03, 0.4115D-03, 0.4925D-03, 0.5880D-03,
     >    0.7006D-03, 0.8336D-03, 0.9893D-03, 0.1167D-02, 0.1358D-02,
     >    0.1540D-02, 0.1681D-02, 0.1733D-02, 0.1659D-02, 0.1450D-02,
     >    0.1146D-02, 0.8190D-03, 0.5392D-03, 0.3403D-03, 0.2178D-03,
     >    0.1480D-03, 0.1076D-03, 0.8157D-04, 0.6259D-04, 0.4758D-04,
     >    0.3556D-04, 0.2612D-04, 0.1887D-04, 0.1348D-04, 0.9490D-05,
     >    0.6696D-05, 0.4633D-05, 0.3236D-05, 0.2238D-05, 0.1572D-05,
     >    0.1106D-05, 0.7737D-06, 0.5075D-06, 0.3744D-06, 0.3079D-06,
     >    0.1747D-06/

      data (calcpts(j,35), j = 1,neta) /0.4350D-06, 0.5271D-06,
     >    0.6385D-06, 0.7736D-06, 0.9373D-06, 0.1136D-05, 0.1376D-05,
     >    0.1667D-05, 0.2019D-05, 0.2446D-05, 0.2964D-05, 0.3591D-05,
     >    0.4350D-05, 0.5271D-05, 0.6385D-05, 0.7735D-05, 0.9372D-05,
     >    0.1135D-04, 0.1375D-04, 0.1666D-04, 0.2018D-04, 0.2445D-04,
     >    0.2961D-04, 0.3585D-04, 0.4340D-04, 0.5253D-04, 0.6354D-04,
     >    0.7681D-04, 0.9277D-04, 0.1119D-03, 0.1347D-03, 0.1618D-03,
     >    0.1937D-03, 0.2310D-03, 0.2742D-03, 0.3239D-03, 0.3809D-03,
     >    0.4467D-03, 0.5232D-03, 0.6132D-03, 0.7186D-03, 0.8385D-03,
     >    0.9666D-03, 0.1088D-02, 0.1179D-02, 0.1209D-02, 0.1152D-02,
     >    0.1002D-02, 0.7892D-03, 0.5624D-03, 0.3697D-03, 0.2333D-03,
     >    0.1496D-03, 0.1018D-03, 0.7418D-04, 0.5625D-04, 0.4316D-04,
     >    0.3279D-04, 0.2447D-04, 0.1795D-04, 0.1296D-04, 0.9234D-05,
     >    0.6505D-05, 0.4508D-05, 0.3110D-05, 0.2178D-05, 0.1446D-05,
     >    0.9797D-06, 0.6468D-06, 0.4471D-06, 0.3140D-06, 0.1808D-06,
     >    0.1142D-06/

      data (calcpts(j,36), j = 1,neta) /0.3005D-06, 0.3641D-06,
     >    0.4410D-06, 0.5343D-06, 0.6474D-06, 0.7844D-06, 0.9503D-06,
     >    0.1151D-05, 0.1395D-05, 0.1690D-05, 0.2047D-05, 0.2480D-05,
     >    0.3005D-05, 0.3641D-05, 0.4410D-05, 0.5343D-05, 0.6473D-05,
     >    0.7842D-05, 0.9500D-05, 0.1151D-04, 0.1394D-04, 0.1688D-04,
     >    0.2044D-04, 0.2475D-04, 0.2996D-04, 0.3624D-04, 0.4381D-04,
     >    0.5293D-04, 0.6385D-04, 0.7688D-04, 0.9234D-04, 0.1105D-03,
     >    0.1317D-03, 0.1561D-03, 0.1837D-03, 0.2147D-03, 0.2492D-03,
     >    0.2879D-03, 0.3319D-03, 0.3831D-03, 0.4434D-03, 0.5142D-03,
     >    0.5948D-03, 0.6807D-03, 0.7617D-03, 0.8210D-03, 0.8378D-03,
     >    0.7949D-03, 0.6898D-03, 0.5417D-03, 0.3854D-03, 0.2531D-03,
     >    0.1597D-03, 0.1025D-03, 0.6996D-04, 0.5100D-04, 0.3870D-04,
     >    0.2972D-04, 0.2253D-04, 0.1688D-04, 0.1235D-04, 0.8956D-05,
     >    0.6359D-05, 0.4494D-05, 0.3096D-05, 0.2163D-05, 0.1497D-05,
     >    0.1031D-05, 0.6979D-06, 0.4981D-06, 0.2982D-06, 0.2317D-06,
     >    0.1651D-06/

      data (calcpts(j,37), j = 1,neta) /0.2068D-06, 0.2505D-06,
     >    0.3035D-06, 0.3677D-06, 0.4455D-06, 0.5397D-06, 0.6539D-06,
     >    0.7923D-06, 0.9597D-06, 0.1163D-05, 0.1409D-05, 0.1707D-05,
     >    0.2068D-05, 0.2505D-05, 0.3035D-05, 0.3677D-05, 0.4454D-05,
     >    0.5396D-05, 0.6537D-05, 0.7918D-05, 0.9589D-05, 0.1161D-04,
     >    0.1406D-04, 0.1703D-04, 0.2060D-04, 0.2492D-04, 0.3011D-04,
     >    0.3636D-04, 0.4383D-04, 0.5271D-04, 0.6320D-04, 0.7547D-04,
     >    0.8960D-04, 0.1057D-03, 0.1236D-03, 0.1432D-03, 0.1645D-03,
     >    0.1875D-03, 0.2130D-03, 0.2420D-03, 0.2759D-03, 0.3161D-03,
     >    0.3636D-03, 0.4177D-03, 0.4753D-03, 0.5293D-03, 0.5682D-03,
     >    0.5779D-03, 0.5467D-03, 0.4734D-03, 0.3711D-03, 0.2636D-03,
     >    0.1730D-03, 0.1092D-03, 0.7015D-04, 0.4791D-04, 0.3500D-04,
     >    0.2655D-04, 0.2036D-04, 0.1550D-04, 0.1157D-04, 0.8508D-05,
     >    0.6110D-05, 0.4379D-05, 0.3046D-05, 0.2114D-05, 0.1514D-05,
     >    0.1048D-05, 0.7145D-06, 0.5147D-06, 0.3148D-06, 0.2482D-06,
     >    0.1816D-06/

      data (calcpts(j,38), j = 1,neta) /0.1419D-06, 0.1719D-06,
     >    0.2082D-06, 0.2523D-06, 0.3057D-06, 0.3703D-06, 0.4487D-06,
     >    0.5436D-06, 0.6585D-06, 0.7978D-06, 0.9667D-06, 0.1171D-05,
     >    0.1419D-05, 0.1719D-05, 0.2082D-05, 0.2523D-05, 0.3056D-05,
     >    0.3702D-05, 0.4485D-05, 0.5433D-05, 0.6579D-05, 0.7968D-05,
     >    0.9649D-05, 0.1168D-04, 0.1413D-04, 0.1709D-04, 0.2065D-04,
     >    0.2492D-04, 0.3002D-04, 0.3607D-04, 0.4320D-04, 0.5149D-04,
     >    0.6098D-04, 0.7165D-04, 0.8339D-04, 0.9600D-04, 0.1093D-03,
     >    0.1234D-03, 0.1383D-03, 0.1548D-03, 0.1737D-03, 0.1960D-03,
     >    0.2228D-03, 0.2547D-03, 0.2911D-03, 0.3297D-03, 0.3658D-03,
     >    0.3915D-03, 0.3972D-03, 0.3750D-03, 0.3241D-03, 0.2537D-03,
     >    0.1801D-03, 0.1181D-03, 0.7455D-04, 0.4790D-04, 0.3279D-04,
     >    0.2393D-04, 0.1820D-04, 0.1394D-04, 0.1061D-04, 0.7880D-05,
     >    0.5815D-05, 0.4149D-05, 0.2950D-05, 0.2084D-05, 0.1417D-05,
     >    0.1017D-05, 0.6842D-06, 0.2843D-06, 0.2844D-06, 0.2178D-06,
     >    0.1512D-06/

      data (calcpts(j,39), j = 1,neta) /0.9721D-07, 0.1178D-06,
     >    0.1427D-06, 0.1729D-06, 0.2094D-06, 0.2537D-06, 0.3074D-06,
     >    0.3724D-06, 0.4511D-06, 0.5466D-06, 0.6623D-06, 0.8023D-06,
     >    0.9720D-06, 0.1178D-05, 0.1427D-05, 0.1728D-05, 0.2094D-05,
     >    0.2537D-05, 0.3073D-05, 0.3722D-05, 0.4507D-05, 0.5459D-05,
     >    0.6610D-05, 0.8000D-05, 0.9679D-05, 0.1170D-04, 0.1414D-04,
     >    0.1705D-04, 0.2054D-04, 0.2466D-04, 0.2951D-04, 0.3513D-04,
     >    0.4153D-04, 0.4867D-04, 0.5644D-04, 0.6466D-04, 0.7316D-04,
     >    0.8184D-04, 0.9078D-04, 0.1003D-03, 0.1108D-03, 0.1231D-03,
     >    0.1379D-03, 0.1558D-03, 0.1771D-03, 0.2016D-03, 0.2277D-03,
     >    0.2518D-03, 0.2689D-03, 0.2724D-03, 0.2567D-03, 0.2216D-03,
     >    0.1733D-03, 0.1230D-03, 0.8063D-04, 0.5093D-04, 0.3276D-04,
     >    0.2239D-04, 0.1640D-04, 0.1247D-04, 0.9535D-05, 0.7270D-05,
     >    0.5404D-05, 0.4005D-05, 0.2872D-05, 0.2072D-05, 0.1473D-05,
     >    0.1006D-05, 0.7395D-06, 0.4729D-06, 0.3396D-06, 0.2730D-06,
     >    0.2064D-06/

      data (calcpts(j,40), j = 1,neta) /0.6647D-07, 0.8054D-07,
     >    0.9756D-07, 0.1182D-06, 0.1432D-06, 0.1735D-06, 0.2102D-06,
     >    0.2547D-06, 0.3085D-06, 0.3738D-06, 0.4529D-06, 0.5486D-06,
     >    0.6647D-06, 0.8053D-06, 0.9755D-06, 0.1182D-05, 0.1432D-05,
     >    0.1734D-05, 0.2101D-05, 0.2545D-05, 0.3082D-05, 0.3732D-05,
     >    0.4519D-05, 0.5470D-05, 0.6617D-05, 0.8001D-05, 0.9662D-05,
     >    0.1166D-04, 0.1403D-04, 0.1684D-04, 0.2014D-04, 0.2395D-04,
     >    0.2828D-04, 0.3308D-04, 0.3826D-04, 0.4367D-04, 0.4917D-04,
     >    0.5464D-04, 0.6008D-04, 0.6564D-04, 0.7160D-04, 0.7835D-04,
     >    0.8637D-04, 0.9616D-04, 0.1081D-03, 0.1225D-03, 0.1390D-03,
     >    0.1566D-03, 0.1729D-03, 0.1843D-03, 0.1864D-03, 0.1755D-03,
     >    0.1513D-03, 0.1183D-03, 0.8387D-04, 0.5499D-04, 0.3474D-04,
     >    0.2235D-04, 0.1530D-04, 0.1119D-04, 0.8507D-05, 0.6528D-05,
     >    0.4955D-05, 0.3703D-05, 0.2716D-05, 0.1963D-05, 0.1397D-05,
     >    0.9834D-06, 0.6902D-06, 0.4835D-06, 0.3369D-06, 0.2303D-06,
     >    0.1636D-06/

      data (calcpts(j,41), j = 1,neta) /0.4540D-07, 0.5501D-07,
     >    0.6663D-07, 0.8073D-07, 0.9782D-07, 0.1185D-06, 0.1436D-06,
     >    0.1740D-06, 0.2107D-06, 0.2553D-06, 0.3093D-06, 0.3747D-06,
     >    0.4540D-06, 0.5501D-06, 0.6663D-06, 0.8072D-06, 0.9780D-06,
     >    0.1185D-05, 0.1435D-05, 0.1738D-05, 0.2105D-05, 0.2549D-05,
     >    0.3087D-05, 0.3736D-05, 0.4519D-05, 0.5464D-05, 0.6598D-05,
     >    0.7957D-05, 0.9578D-05, 0.1149D-04, 0.1374D-04, 0.1633D-04,
     >    0.1926D-04, 0.2250D-04, 0.2597D-04, 0.2956D-04, 0.3316D-04,
     >    0.3667D-04, 0.4005D-04, 0.4337D-04, 0.4679D-04, 0.5052D-04,
     >    0.5486D-04, 0.6013D-04, 0.6665D-04, 0.7469D-04, 0.8439D-04,
     >    0.9556D-04, 0.1074D-03, 0.1184D-03, 0.1261D-03, 0.1274D-03,
     >    0.1198D-03, 0.1033D-03, 0.8069D-04, 0.5719D-04, 0.3748D-04,
     >    0.2367D-04, 0.1524D-04, 0.1043D-04, 0.7626D-05, 0.5800D-05,
     >    0.4447D-05, 0.3374D-05, 0.2521D-05, 0.1848D-05, 0.1328D-05,
     >    0.9483D-06, 0.6683D-06, 0.4617D-06, 0.3217D-06, 0.2217D-06,
     >    0.1484D-06/

      data (calcpts(j,42), j = 1,neta) /0.3100D-07, 0.3755D-07,
     >    0.4549D-07, 0.5512D-07, 0.6678D-07, 0.8090D-07, 0.9801D-07,
     >    0.1188D-06, 0.1439D-06, 0.1743D-06, 0.2112D-06, 0.2558D-06,
     >    0.3099D-06, 0.3755D-06, 0.4549D-06, 0.5511D-06, 0.6677D-06,
     >    0.8088D-06, 0.9797D-06, 0.1187D-05, 0.1437D-05, 0.1740D-05,
     >    0.2107D-05, 0.2550D-05, 0.3085D-05, 0.3729D-05, 0.4503D-05,
     >    0.5431D-05, 0.6536D-05, 0.7841D-05, 0.9368D-05, 0.1113D-04,
     >    0.1312D-04, 0.1531D-04, 0.1765D-04, 0.2005D-04, 0.2243D-04,
     >    0.2471D-04, 0.2685D-04, 0.2888D-04, 0.3088D-04, 0.3297D-04,
     >    0.3533D-04, 0.3814D-04, 0.4162D-04, 0.4599D-04, 0.5141D-04,
     >    0.5796D-04, 0.6552D-04, 0.7356D-04, 0.8100D-04, 0.8616D-04,
     >    0.8698D-04, 0.8179D-04, 0.7046D-04, 0.5502D-04, 0.3899D-04,
     >    0.2555D-04, 0.1615D-04, 0.1039D-04, 0.7120D-05, 0.5207D-05,
     >    0.3961D-05, 0.3035D-05, 0.2308D-05, 0.1722D-05, 0.1262D-05,
     >    0.9083D-06, 0.6484D-06, 0.4550D-06, 0.3217D-06, 0.2217D-06,
     >    0.1551D-06/

      data (calcpts(j,43), j = 1,neta) /0.2115D-07, 0.2562D-07,
     >    0.3104D-07, 0.3760D-07, 0.4556D-07, 0.5520D-07, 0.6687D-07,
     >    0.8102D-07, 0.9814D-07, 0.1189D-06, 0.1441D-06, 0.1745D-06,
     >    0.2115D-06, 0.2562D-06, 0.3103D-06, 0.3760D-06, 0.4555D-06,
     >    0.5518D-06, 0.6684D-06, 0.8097D-06, 0.9804D-06, 0.1187D-05,
     >    0.1438D-05, 0.1740D-05, 0.2105D-05, 0.2544D-05, 0.3072D-05,
     >    0.3704D-05, 0.4457D-05, 0.5347D-05, 0.6387D-05, 0.7585D-05,
     >    0.8936D-05, 0.1042D-04, 0.1200D-04, 0.1362D-04, 0.1520D-04,
     >    0.1670D-04, 0.1808D-04, 0.1934D-04, 0.2054D-04, 0.2173D-04,
     >    0.2303D-04, 0.2453D-04, 0.2637D-04, 0.2869D-04, 0.3162D-04,
     >    0.3529D-04, 0.3972D-04, 0.4485D-04, 0.5030D-04, 0.5534D-04,
     >    0.5882D-04, 0.5935D-04, 0.5579D-04, 0.4805D-04, 0.3751D-04,
     >    0.2657D-04, 0.1742D-04, 0.1101D-04, 0.7086D-05, 0.4853D-05,
     >    0.3553D-05, 0.2700D-05, 0.2073D-05, 0.1573D-05, 0.1167D-05,
     >    0.8600D-06, 0.6200D-06, 0.4400D-06, 0.3134D-06, 0.2201D-06,
     >    0.1534D-06/

      data (calcpts(j,44), j = 1,neta) /0.1442D-07, 0.1747D-07,
     >    0.2116D-07, 0.2564D-07, 0.3107D-07, 0.3764D-07, 0.4560D-07,
     >    0.5525D-07, 0.6692D-07, 0.8108D-07, 0.9824D-07, 0.1190D-06,
     >    0.1442D-06, 0.1747D-06, 0.2116D-06, 0.2564D-06, 0.3106D-06,
     >    0.3763D-06, 0.4558D-06, 0.5521D-06, 0.6685D-06, 0.8096D-06,
     >    0.9802D-06, 0.1186D-05, 0.1435D-05, 0.1735D-05, 0.2094D-05,
     >    0.2525D-05, 0.3039D-05, 0.3645D-05, 0.4353D-05, 0.5168D-05,
     >    0.6086D-05, 0.7095D-05, 0.8165D-05, 0.9254D-05, 0.1032D-04,
     >    0.1131D-04, 0.1221D-04, 0.1301D-04, 0.1374D-04, 0.1444D-04,
     >    0.1516D-04, 0.1597D-04, 0.1694D-04, 0.1816D-04, 0.1971D-04,
     >    0.2169D-04, 0.2416D-04, 0.2718D-04, 0.3065D-04, 0.3435D-04,
     >    0.3778D-04, 0.4014D-04, 0.4048D-04, 0.3803D-04, 0.3275D-04,
     >    0.2556D-04, 0.1811D-04, 0.1187D-04, 0.7499D-05, 0.4826D-05,
     >    0.3306D-05, 0.2419D-05, 0.1840D-05, 0.1413D-05, 0.1073D-05,
     >    0.7996D-06, 0.5863D-06, 0.4197D-06, 0.2997D-06, 0.2130D-06,
     >    0.1463D-06/

      data (calcpts(j,45), j = 1,neta) /0.9834D-08, 0.1192D-07,
     >    0.1443D-07, 0.1749D-07, 0.2119D-07, 0.2567D-07, 0.3110D-07,
     >    0.3768D-07, 0.4564D-07, 0.5530D-07, 0.6700D-07, 0.8117D-07,
     >    0.9834D-07, 0.1191D-06, 0.1443D-06, 0.1748D-06, 0.2118D-06,
     >    0.2566D-06, 0.3108D-06, 0.3765D-06, 0.4559D-06, 0.5521D-06,
     >    0.6685D-06, 0.8090D-06, 0.9786D-06, 0.1183D-05, 0.1428D-05,
     >    0.1722D-05, 0.2072D-05, 0.2485D-05, 0.2968D-05, 0.3523D-05,
     >    0.4148D-05, 0.4833D-05, 0.5559D-05, 0.6296D-05, 0.7012D-05,
     >    0.7676D-05, 0.8269D-05, 0.8788D-05, 0.9244D-05, 0.9661D-05,
     >    0.1007D-04, 0.1051D-04, 0.1102D-04, 0.1166D-04, 0.1247D-04,
     >    0.1351D-04, 0.1485D-04, 0.1653D-04, 0.1857D-04, 0.2094D-04,
     >    0.2345D-04, 0.2578D-04, 0.2738D-04, 0.2760D-04, 0.2593D-04,
     >    0.2233D-04, 0.1743D-04, 0.1234D-04, 0.8090D-05, 0.5112D-05,
     >    0.3293D-05, 0.2254D-05, 0.1654D-05, 0.1254D-05, 0.9610D-06,
     >    0.7277D-06, 0.5477D-06, 0.4011D-06, 0.2877D-06, 0.2077D-06,
     >    0.1477D-06/

      data (calcpts(j,46), j = 1,neta) /0.6703D-08, 0.8121D-08,
     >    0.9837D-08, 0.1192D-07, 0.1444D-07, 0.1750D-07, 0.2120D-07,
     >    0.2568D-07, 0.3111D-07, 0.3769D-07, 0.4567D-07, 0.5532D-07,
     >    0.6702D-07, 0.8121D-07, 0.9836D-07, 0.1192D-06, 0.1444D-06,
     >    0.1749D-06, 0.2119D-06, 0.2566D-06, 0.3108D-06, 0.3763D-06,
     >    0.4556D-06, 0.5514D-06, 0.6670D-06, 0.8063D-06, 0.9734D-06,
     >    0.1174D-05, 0.1412D-05, 0.1694D-05, 0.2022D-05, 0.2400D-05,
     >    0.2825D-05, 0.3292D-05, 0.3785D-05, 0.4284D-05, 0.4768D-05,
     >    0.5214D-05, 0.5608D-05, 0.5947D-05, 0.6237D-05, 0.6492D-05,
     >    0.6730D-05, 0.6974D-05, 0.7248D-05, 0.7579D-05, 0.7998D-05,
     >    0.8541D-05, 0.9245D-05, 0.1015D-04, 0.1129D-04, 0.1268D-04,
     >    0.1429D-04, 0.1600D-04, 0.1758D-04, 0.1867D-04, 0.1881D-04,
     >    0.1768D-04, 0.1522D-04, 0.1187D-04, 0.8410D-05, 0.5511D-05,
     >    0.3483D-05, 0.2243D-05, 0.1537D-05, 0.1125D-05, 0.8554D-06,
     >    0.6561D-06, 0.4988D-06, 0.3721D-06, 0.2728D-06, 0.1974D-06,
     >    0.1408D-06/

      data (calcpts(j,47), j = 1,neta) /0.4567D-08, 0.5534D-08,
     >    0.6703D-08, 0.8122D-08, 0.9841D-08, 0.1192D-07, 0.1444D-07,
     >    0.1750D-07, 0.2120D-07, 0.2568D-07, 0.3112D-07, 0.3770D-07,
     >    0.4567D-07, 0.5534D-07, 0.6703D-07, 0.8121D-07, 0.9838D-07,
     >    0.1192D-06, 0.1444D-06, 0.1749D-06, 0.2118D-06, 0.2564D-06,
     >    0.3105D-06, 0.3757D-06, 0.4545D-06, 0.5494D-06, 0.6633D-06,
     >    0.7997D-06, 0.9622D-06, 0.1154D-05, 0.1378D-05, 0.1635D-05,
     >    0.1925D-05, 0.2242D-05, 0.2577D-05, 0.2916D-05, 0.3243D-05,
     >    0.3544D-05, 0.3808D-05, 0.4032D-05, 0.4219D-05, 0.4378D-05,
     >    0.4520D-05, 0.4658D-05, 0.4807D-05, 0.4980D-05, 0.5197D-05,
     >    0.5476D-05, 0.5841D-05, 0.6317D-05, 0.6932D-05, 0.7708D-05,
     >    0.8653D-05, 0.9745D-05, 0.1091D-04, 0.1199D-04, 0.1273D-04,
     >    0.1283D-04, 0.1205D-04, 0.1037D-04, 0.8089D-05, 0.5729D-05,
     >    0.3755D-05, 0.2372D-05, 0.1527D-05, 0.1047D-05, 0.7661D-06,
     >    0.5821D-06, 0.4461D-06, 0.3387D-06, 0.2527D-06, 0.1854D-06,
     >    0.1334D-06/

      data (calcpts(j,48), j = 1,neta) /0.3113D-08, 0.3771D-08,
     >    0.4568D-08, 0.5535D-08, 0.6707D-08, 0.8125D-08, 0.9843D-08,
     >    0.1193D-07, 0.1445D-07, 0.1750D-07, 0.2121D-07, 0.2569D-07,
     >    0.3113D-07, 0.3771D-07, 0.4568D-07, 0.5534D-07, 0.6705D-07,
     >    0.8122D-07, 0.9839D-07, 0.1192D-06, 0.1443D-06, 0.1748D-06,
     >    0.2116D-06, 0.2561D-06, 0.3097D-06, 0.3744D-06, 0.4520D-06,
     >    0.5450D-06, 0.6557D-06, 0.7863D-06, 0.9388D-06, 0.1114D-05,
     >    0.1311D-05, 0.1527D-05, 0.1755D-05, 0.1986D-05, 0.2208D-05,
     >    0.2411D-05, 0.2588D-05, 0.2738D-05, 0.2860D-05, 0.2962D-05,
     >    0.3048D-05, 0.3128D-05, 0.3210D-05, 0.3302D-05, 0.3414D-05,
     >    0.3557D-05, 0.3744D-05, 0.3991D-05, 0.4314D-05, 0.4731D-05,
     >    0.5259D-05, 0.5902D-05, 0.6646D-05, 0.7437D-05, 0.8169D-05,
     >    0.8672D-05, 0.8739D-05, 0.8207D-05, 0.7063D-05, 0.5512D-05,
     >    0.3904D-05, 0.2558D-05, 0.1616D-05, 0.1041D-05, 0.7134D-06,
     >    0.5221D-06, 0.3968D-06, 0.3048D-06, 0.2315D-06, 0.1728D-06,
     >    0.1261D-06/

      data (calcpts(j,49), j = 1,neta) /0.2121D-08, 0.2570D-08,
     >    0.3113D-08, 0.3772D-08, 0.4570D-08, 0.5536D-08, 0.6708D-08,
     >    0.8127D-08, 0.9844D-08, 0.1193D-07, 0.1445D-07, 0.1751D-07,
     >    0.2121D-07, 0.2570D-07, 0.3113D-07, 0.3771D-07, 0.4569D-07,
     >    0.5535D-07, 0.6704D-07, 0.8121D-07, 0.9834D-07, 0.1191D-06,
     >    0.1442D-06, 0.1745D-06, 0.2111D-06, 0.2551D-06, 0.3080D-06,
     >    0.3714D-06, 0.4468D-06, 0.5358D-06, 0.6397D-06, 0.7591D-06,
     >    0.8934D-06, 0.1040D-05, 0.1195D-05, 0.1352D-05, 0.1503D-05,
     >    0.1641D-05, 0.1761D-05, 0.1861D-05, 0.1942D-05, 0.2007D-05,
     >    0.2061D-05, 0.2109D-05, 0.2155D-05, 0.2205D-05, 0.2263D-05,
     >    0.2336D-05, 0.2431D-05, 0.2557D-05, 0.2724D-05, 0.2944D-05,
     >    0.3228D-05, 0.3586D-05, 0.4024D-05, 0.4530D-05, 0.5069D-05,
     >    0.5567D-05, 0.5910D-05, 0.5955D-05, 0.5592D-05, 0.4813D-05,
     >    0.3756D-05, 0.2660D-05, 0.1743D-05, 0.1101D-05, 0.7091D-06,
     >    0.4858D-06, 0.3558D-06, 0.2705D-06, 0.2078D-06, 0.1578D-06,
     >    0.1178D-06/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ixi .ge. 72) ieta = 72
         pxi = (dlxi - dlaxi(ixi))/delxi
         f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >        (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >        pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
         f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >        (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >        pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
         f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >        (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >        pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
         peta = (dleta - dlaeta(ieta))/deleta
         xsclba = peta*(peta-1d0)/2d0*f(-1) +
     >        (1d0 - peta**2)*f(0) +
     >        peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine sctbar_CT(eta, xi, xsctba)
c   the subtracted term from eq (12) of PLB347 (1995) 143 - 151
c   transverse gluon initiated piece accompanying the MF log
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsctba
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.2829D-03, 0.3429D-03,
     >    0.4153D-03, 0.5032D-03, 0.6093D-03, 0.7385D-03, 0.8944D-03,
     >    0.1084D-02, 0.1313D-02, 0.1591D-02, 0.1928D-02, 0.2339D-02,
     >    0.2827D-02, 0.3429D-02, 0.4159D-02, 0.5038D-02, 0.6106D-02,
     >    0.7404D-02, 0.8979D-02, 0.1089D-01, 0.1322D-01, 0.1605D-01,
     >    0.1950D-01, 0.2372D-01, 0.2888D-01, 0.3520D-01, 0.4295D-01,
     >    0.5243D-01, 0.6398D-01, 0.7789D-01, 0.9419D-01, 0.1127D+00,
     >    0.1321D+00, 0.1504D+00, 0.1646D+00, 0.1713D+00, 0.1691D+00,
     >    0.1584D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8429D-01,
     >    0.6827D-01, 0.5456D-01, 0.4314D-01, 0.3383D-01, 0.2625D-01,
     >    0.2023D-01, 0.1549D-01, 0.1175D-01, 0.8913D-02, 0.6710D-02,
     >    0.4996D-02, 0.3763D-02, 0.2807D-02, 0.2058D-02, 0.1515D-02,
     >    0.1108D-02, 0.8360D-03, 0.6327D-03, 0.4304D-03, 0.2955D-03,
     >    0.2278D-03, 0.1604D-03, 0.9327D-04, 0.9293D-04, 0.9271D-04,
     >    0.2589D-04, 0.2578D-04, 0.2571D-04, 0.2566D-04, 0.2563D-04,
     >    0.2561D-04/

      data (calcpts(j, 2), j = 1,neta) /0.2830D-03, 0.3423D-03,
     >    0.4154D-03, 0.5027D-03, 0.6095D-03, 0.7380D-03, 0.8946D-03,
     >    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1928D-02, 0.2333D-02,
     >    0.2828D-02, 0.3430D-02, 0.4153D-02, 0.5039D-02, 0.6107D-02,
     >    0.7399D-02, 0.8973D-02, 0.1089D-01, 0.1321D-01, 0.1604D-01,
     >    0.1950D-01, 0.2371D-01, 0.2888D-01, 0.3519D-01, 0.4294D-01,
     >    0.5242D-01, 0.6398D-01, 0.7789D-01, 0.9419D-01, 0.1127D+00,
     >    0.1321D+00, 0.1504D+00, 0.1645D+00, 0.1713D+00, 0.1691D+00,
     >    0.1584D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8429D-01,
     >    0.6827D-01, 0.5462D-01, 0.4320D-01, 0.3382D-01, 0.2623D-01,
     >    0.2021D-01, 0.1548D-01, 0.1173D-01, 0.8899D-02, 0.6697D-02,
     >    0.5049D-02, 0.3750D-02, 0.2794D-02, 0.2045D-02, 0.1501D-02,
     >    0.1094D-02, 0.8227D-03, 0.6194D-03, 0.4172D-03, 0.3490D-03,
     >    0.2146D-03, 0.1472D-03, 0.1467D-03, 0.7970D-04, 0.7948D-04,
     >    0.7932D-04, 0.1255D-04, 0.1248D-04, 0.1243D-04, 0.1240D-04,
     >    0.1237D-04/

      data (calcpts(j, 3), j = 1,neta) /0.2825D-03, 0.3425D-03,
     >    0.4150D-03, 0.5030D-03, 0.6091D-03, 0.7384D-03, 0.8943D-03,
     >    0.1084D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2333D-02,
     >    0.2829D-02, 0.3431D-02, 0.4154D-02, 0.5033D-02, 0.6102D-02,
     >    0.7400D-02, 0.8975D-02, 0.1088D-01, 0.1322D-01, 0.1605D-01,
     >    0.1950D-01, 0.2372D-01, 0.2887D-01, 0.3519D-01, 0.4294D-01,
     >    0.5242D-01, 0.6397D-01, 0.7783D-01, 0.9418D-01, 0.1127D+00,
     >    0.1321D+00, 0.1503D+00, 0.1645D+00, 0.1713D+00, 0.1691D+00,
     >    0.1583D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8428D-01,
     >    0.6826D-01, 0.5460D-01, 0.4318D-01, 0.3380D-01, 0.2621D-01,
     >    0.2019D-01, 0.1546D-01, 0.1178D-01, 0.8880D-02, 0.6677D-02,
     >    0.5030D-02, 0.3730D-02, 0.2774D-02, 0.2092D-02, 0.1549D-02,
     >    0.1142D-02, 0.8033D-03, 0.6000D-03, 0.4644D-03, 0.3296D-03,
     >    0.2618D-03, 0.1945D-03, 0.1273D-03, 0.6031D-04, 0.6008D-04,
     >    0.5993D-04, 0.5982D-04, -.6914D-05, -.6963D-05, -.6996D-05,
     >    -.7019D-05/

      data (calcpts(j, 4), j = 1,neta) /0.2827D-03, 0.3428D-03,
     >    0.4153D-03, 0.5027D-03, 0.6089D-03, 0.7382D-03, 0.8942D-03,
     >    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2335D-02,
     >    0.2830D-02, 0.3426D-02, 0.4156D-02, 0.5035D-02, 0.6104D-02,
     >    0.7403D-02, 0.8971D-02, 0.1089D-01, 0.1321D-01, 0.1604D-01,
     >    0.1949D-01, 0.2371D-01, 0.2887D-01, 0.3519D-01, 0.4293D-01,
     >    0.5241D-01, 0.6395D-01, 0.7783D-01, 0.9418D-01, 0.1126D+00,
     >    0.1320D+00, 0.1503D+00, 0.1644D+00, 0.1713D+00, 0.1691D+00,
     >    0.1583D+00, 0.1416D+00, 0.1221D+00, 0.1024D+00, 0.8428D-01,
     >    0.6826D-01, 0.5457D-01, 0.4315D-01, 0.3377D-01, 0.2625D-01,
     >    0.2023D-01, 0.1550D-01, 0.1175D-01, 0.8918D-02, 0.6715D-02,
     >    0.5001D-02, 0.3768D-02, 0.2813D-02, 0.2064D-02, 0.1520D-02,
     >    0.1113D-02, 0.8415D-03, 0.6382D-03, 0.4360D-03, 0.3011D-03,
     >    0.2334D-03, 0.1660D-03, 0.9883D-04, 0.9849D-04, 0.3160D-04,
     >    0.3145D-04, 0.3134D-04, 0.3127D-04, 0.3122D-04, 0.3119D-04,
     >    0.3117D-04/

      data (calcpts(j, 5), j = 1,neta) /0.2824D-03, 0.3425D-03,
     >    0.4151D-03, 0.5025D-03, 0.6088D-03, 0.7382D-03, 0.8944D-03,
     >    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2336D-02,
     >    0.2832D-02, 0.3428D-02, 0.4152D-02, 0.5031D-02, 0.6100D-02,
     >    0.7399D-02, 0.8968D-02, 0.1088D-01, 0.1321D-01, 0.1604D-01,
     >    0.1949D-01, 0.2370D-01, 0.2886D-01, 0.3518D-01, 0.4292D-01,
     >    0.5239D-01, 0.6393D-01, 0.7782D-01, 0.9411D-01, 0.1126D+00,
     >    0.1320D+00, 0.1503D+00, 0.1644D+00, 0.1713D+00, 0.1690D+00,
     >    0.1583D+00, 0.1415D+00, 0.1221D+00, 0.1024D+00, 0.8427D-01,
     >    0.6825D-01, 0.5459D-01, 0.4317D-01, 0.3380D-01, 0.2621D-01,
     >    0.2019D-01, 0.1545D-01, 0.1178D-01, 0.8876D-02, 0.6674D-02,
     >    0.5026D-02, 0.3727D-02, 0.2771D-02, 0.2089D-02, 0.1545D-02,
     >    0.1138D-02, 0.7997D-03, 0.5964D-03, 0.4608D-03, 0.3260D-03,
     >    0.2582D-03, 0.1909D-03, 0.1237D-03, 0.5670D-04, 0.5648D-04,
     >    0.5632D-04, 0.5622D-04, 0.5615D-04, -.1057D-04, -.1060D-04,
     >    -.1062D-04/

      data (calcpts(j, 6), j = 1,neta) /0.2829D-03, 0.3424D-03,
     >    0.4150D-03, 0.5026D-03, 0.6090D-03, 0.7379D-03, 0.8935D-03,
     >    0.1083D-02, 0.1312D-02, 0.1590D-02, 0.1925D-02, 0.2332D-02,
     >    0.2828D-02, 0.3424D-02, 0.4155D-02, 0.5035D-02, 0.6098D-02,
     >    0.7398D-02, 0.8967D-02, 0.1088D-01, 0.1320D-01, 0.1603D-01,
     >    0.1948D-01, 0.2369D-01, 0.2885D-01, 0.3516D-01, 0.4290D-01,
     >    0.5237D-01, 0.6390D-01, 0.7776D-01, 0.9410D-01, 0.1125D+00,
     >    0.1319D+00, 0.1502D+00, 0.1643D+00, 0.1711D+00, 0.1690D+00,
     >    0.1582D+00, 0.1415D+00, 0.1220D+00, 0.1024D+00, 0.8425D-01,
     >    0.6824D-01, 0.5459D-01, 0.4318D-01, 0.3380D-01, 0.2621D-01,
     >    0.2020D-01, 0.1546D-01, 0.1178D-01, 0.8882D-02, 0.6679D-02,
     >    0.5031D-02, 0.3732D-02, 0.2776D-02, 0.2094D-02, 0.1550D-02,
     >    0.1143D-02, 0.8052D-03, 0.6018D-03, 0.4662D-03, 0.3314D-03,
     >    0.2637D-03, 0.1963D-03, 0.1291D-03, 0.6213D-04, 0.6190D-04,
     >    0.6175D-04, 0.6164D-04, -.5098D-05, -.5147D-05, -.5180D-05,
     >    -.5203D-05/

      data (calcpts(j, 7), j = 1,neta) /0.2822D-03, 0.3418D-03,
     >    0.4146D-03, 0.5024D-03, 0.6083D-03, 0.7374D-03, 0.8933D-03,
     >    0.1082D-02, 0.1311D-02, 0.1589D-02, 0.1925D-02, 0.2335D-02,
     >    0.2825D-02, 0.3422D-02, 0.4147D-02, 0.5028D-02, 0.6098D-02,
     >    0.7392D-02, 0.8962D-02, 0.1087D-01, 0.1319D-01, 0.1602D-01,
     >    0.1947D-01, 0.2368D-01, 0.2883D-01, 0.3514D-01, 0.4287D-01,
     >    0.5234D-01, 0.6386D-01, 0.7775D-01, 0.9403D-01, 0.1124D+00,
     >    0.1318D+00, 0.1501D+00, 0.1642D+00, 0.1711D+00, 0.1689D+00,
     >    0.1581D+00, 0.1414D+00, 0.1220D+00, 0.1024D+00, 0.8422D-01,
     >    0.6822D-01, 0.5457D-01, 0.4315D-01, 0.3378D-01, 0.2626D-01,
     >    0.2024D-01, 0.1544D-01, 0.1176D-01, 0.8925D-02, 0.6722D-02,
     >    0.5008D-02, 0.3775D-02, 0.2820D-02, 0.2071D-02, 0.1527D-02,
     >    0.1120D-02, 0.8487D-03, 0.5787D-03, 0.4431D-03, 0.3083D-03,
     >    0.2405D-03, 0.1732D-03, 0.1060D-03, 0.1057D-03, 0.3878D-04,
     >    0.3863D-04, 0.3852D-04, 0.3845D-04, 0.3840D-04, 0.3837D-04,
     >    0.3835D-04/

      data (calcpts(j, 8), j = 1,neta) /0.2819D-03, 0.3417D-03,
     >    0.4140D-03, 0.5020D-03, 0.6082D-03, 0.7369D-03, 0.8925D-03,
     >    0.1081D-02, 0.1311D-02, 0.1588D-02, 0.1923D-02, 0.2327D-02,
     >    0.2824D-02, 0.3422D-02, 0.4148D-02, 0.5023D-02, 0.6094D-02,
     >    0.7383D-02, 0.8954D-02, 0.1087D-01, 0.1319D-01, 0.1601D-01,
     >    0.1946D-01, 0.2366D-01, 0.2880D-01, 0.3511D-01, 0.4283D-01,
     >    0.5229D-01, 0.6380D-01, 0.7762D-01, 0.9395D-01, 0.1123D+00,
     >    0.1317D+00, 0.1500D+00, 0.1640D+00, 0.1709D+00, 0.1687D+00,
     >    0.1580D+00, 0.1414D+00, 0.1219D+00, 0.1023D+00, 0.8419D-01,
     >    0.6819D-01, 0.5450D-01, 0.4315D-01, 0.3378D-01, 0.2626D-01,
     >    0.2017D-01, 0.1544D-01, 0.1176D-01, 0.8926D-02, 0.6724D-02,
     >    0.5010D-02, 0.3777D-02, 0.2755D-02, 0.2073D-02, 0.1529D-02,
     >    0.1122D-02, 0.8504D-03, 0.5805D-03, 0.4449D-03, 0.3100D-03,
     >    0.2423D-03, 0.1749D-03, 0.1078D-03, 0.1074D-03, 0.4054D-04,
     >    0.4039D-04, 0.4028D-04, 0.4021D-04, 0.4016D-04, 0.4013D-04,
     >    0.4011D-04/

      data (calcpts(j, 9), j = 1,neta) /0.2821D-03, 0.3414D-03,
     >    0.4141D-03, 0.5010D-03, 0.6076D-03, 0.7361D-03, 0.8916D-03,
     >    0.1080D-02, 0.1309D-02, 0.1585D-02, 0.1921D-02, 0.2328D-02,
     >    0.2820D-02, 0.3419D-02, 0.4139D-02, 0.5022D-02, 0.6082D-02,
     >    0.7378D-02, 0.8945D-02, 0.1085D-01, 0.1317D-01, 0.1599D-01,
     >    0.1943D-01, 0.2363D-01, 0.2877D-01, 0.3506D-01, 0.4277D-01,
     >    0.5221D-01, 0.6370D-01, 0.7755D-01, 0.9379D-01, 0.1121D+00,
     >    0.1315D+00, 0.1497D+00, 0.1638D+00, 0.1707D+00, 0.1685D+00,
     >    0.1579D+00, 0.1412D+00, 0.1218D+00, 0.1023D+00, 0.8414D-01,
     >    0.6816D-01, 0.5450D-01, 0.4309D-01, 0.3378D-01, 0.2620D-01,
     >    0.2018D-01, 0.1544D-01, 0.1177D-01, 0.8867D-02, 0.6665D-02,
     >    0.5017D-02, 0.3718D-02, 0.2762D-02, 0.2080D-02, 0.1537D-02,
     >    0.1130D-02, 0.7915D-03, 0.5882D-03, 0.4526D-03, 0.3177D-03,
     >    0.2500D-03, 0.1826D-03, 0.1155D-03, 0.1151D-03, 0.4825D-04,
     >    0.4810D-04, 0.4800D-04, 0.4793D-04, 0.4788D-04, -.1882D-04,
     >    -.1885D-04/

      data (calcpts(j,10), j = 1,neta) /0.2816D-03, 0.3406D-03,
     >    0.4130D-03, 0.5005D-03, 0.6063D-03, 0.7348D-03, 0.8897D-03,
     >    0.1078D-02, 0.1307D-02, 0.1583D-02, 0.1917D-02, 0.2324D-02,
     >    0.2812D-02, 0.3413D-02, 0.4136D-02, 0.5014D-02, 0.6076D-02,
     >    0.7362D-02, 0.8930D-02, 0.1083D-01, 0.1315D-01, 0.1596D-01,
     >    0.1939D-01, 0.2359D-01, 0.2871D-01, 0.3500D-01, 0.4269D-01,
     >    0.5211D-01, 0.6357D-01, 0.7734D-01, 0.9356D-01, 0.1119D+00,
     >    0.1311D+00, 0.1493D+00, 0.1634D+00, 0.1703D+00, 0.1682D+00,
     >    0.1576D+00, 0.1410D+00, 0.1217D+00, 0.1022D+00, 0.8406D-01,
     >    0.6810D-01, 0.5448D-01, 0.4307D-01, 0.3376D-01, 0.2618D-01,
     >    0.2016D-01, 0.1543D-01, 0.1175D-01, 0.8918D-02, 0.6716D-02,
     >    0.5002D-02, 0.3770D-02, 0.2814D-02, 0.2066D-02, 0.1522D-02,
     >    0.1115D-02, 0.8435D-03, 0.5735D-03, 0.4379D-03, 0.3031D-03,
     >    0.2354D-03, 0.1680D-03, 0.1008D-03, 0.1005D-03, 0.3361D-04,
     >    0.3346D-04, 0.3335D-04, 0.3328D-04, 0.3324D-04, 0.3320D-04,
     >    0.3318D-04/

      data (calcpts(j,11), j = 1,neta) /0.2808D-03, 0.3397D-03,
     >    0.4121D-03, 0.4989D-03, 0.6049D-03, 0.7330D-03, 0.8876D-03,
     >    0.1076D-02, 0.1304D-02, 0.1579D-02, 0.1913D-02, 0.2318D-02,
     >    0.2811D-02, 0.3401D-02, 0.4126D-02, 0.5001D-02, 0.6060D-02,
     >    0.7342D-02, 0.8908D-02, 0.1080D-01, 0.1311D-01, 0.1592D-01,
     >    0.1934D-01, 0.2352D-01, 0.2864D-01, 0.3490D-01, 0.4257D-01,
     >    0.5195D-01, 0.6338D-01, 0.7713D-01, 0.9325D-01, 0.1115D+00,
     >    0.1307D+00, 0.1489D+00, 0.1630D+00, 0.1698D+00, 0.1678D+00,
     >    0.1573D+00, 0.1408D+00, 0.1215D+00, 0.1020D+00, 0.8395D-01,
     >    0.6802D-01, 0.5440D-01, 0.4305D-01, 0.3368D-01, 0.2616D-01,
     >    0.2015D-01, 0.1541D-01, 0.1174D-01, 0.8907D-02, 0.6705D-02,
     >    0.4991D-02, 0.3759D-02, 0.2804D-02, 0.2055D-02, 0.1512D-02,
     >    0.1105D-02, 0.8330D-03, 0.6298D-03, 0.4275D-03, 0.2927D-03,
     >    0.2250D-03, 0.1576D-03, 0.9045D-04, 0.9012D-04, 0.8989D-04,
     >    0.2308D-04, 0.2297D-04, 0.2290D-04, 0.2285D-04, 0.2282D-04,
     >    0.2280D-04/

      data (calcpts(j,12), j = 1,neta) /0.2794D-03, 0.3384D-03,
     >    0.4104D-03, 0.4976D-03, 0.6028D-03, 0.7303D-03, 0.8845D-03,
     >    0.1072D-02, 0.1298D-02, 0.1573D-02, 0.1906D-02, 0.2310D-02,
     >    0.2798D-02, 0.3391D-02, 0.4107D-02, 0.4980D-02, 0.6037D-02,
     >    0.7318D-02, 0.8875D-02, 0.1076D-01, 0.1306D-01, 0.1586D-01,
     >    0.1927D-01, 0.2343D-01, 0.2853D-01, 0.3476D-01, 0.4239D-01,
     >    0.5173D-01, 0.6310D-01, 0.7678D-01, 0.9279D-01, 0.1109D+00,
     >    0.1301D+00, 0.1481D+00, 0.1622D+00, 0.1691D+00, 0.1672D+00,
     >    0.1568D+00, 0.1404D+00, 0.1212D+00, 0.1018D+00, 0.8379D-01,
     >    0.6790D-01, 0.5432D-01, 0.4298D-01, 0.3368D-01, 0.2616D-01,
     >    0.2015D-01, 0.1542D-01, 0.1174D-01, 0.8843D-02, 0.6708D-02,
     >    0.4995D-02, 0.3762D-02, 0.2807D-02, 0.2059D-02, 0.1515D-02,
     >    0.1108D-02, 0.8366D-03, 0.6334D-03, 0.4312D-03, 0.2963D-03,
     >    0.2286D-03, 0.1613D-03, 0.9411D-04, 0.9378D-04, 0.9356D-04,
     >    0.2674D-04, 0.2664D-04, 0.2657D-04, 0.2652D-04, 0.2649D-04,
     >    0.2647D-04/

      data (calcpts(j,13), j = 1,neta) /0.2781D-03, 0.3369D-03,
     >    0.4082D-03, 0.4949D-03, 0.5992D-03, 0.7261D-03, 0.8799D-03,
     >    0.1066D-02, 0.1291D-02, 0.1565D-02, 0.1896D-02, 0.2297D-02,
     >    0.2783D-02, 0.3376D-02, 0.4084D-02, 0.4957D-02, 0.6001D-02,
     >    0.7282D-02, 0.8828D-02, 0.1071D-01, 0.1300D-01, 0.1577D-01,
     >    0.1916D-01, 0.2330D-01, 0.2836D-01, 0.3455D-01, 0.4214D-01,
     >    0.5141D-01, 0.6268D-01, 0.7623D-01, 0.9216D-01, 0.1102D+00,
     >    0.1291D+00, 0.1471D+00, 0.1611D+00, 0.1681D+00, 0.1663D+00,
     >    0.1560D+00, 0.1398D+00, 0.1208D+00, 0.1015D+00, 0.8356D-01,
     >    0.6773D-01, 0.5417D-01, 0.4290D-01, 0.3360D-01, 0.2609D-01,
     >    0.2015D-01, 0.1542D-01, 0.1174D-01, 0.8844D-02, 0.6643D-02,
     >    0.4997D-02, 0.3765D-02, 0.2810D-02, 0.2062D-02, 0.1518D-02,
     >    0.1111D-02, 0.8399D-03, 0.6366D-03, 0.4344D-03, 0.2996D-03,
     >    0.2319D-03, 0.1645D-03, 0.9741D-04, 0.9708D-04, 0.9686D-04,
     >    0.3005D-04, 0.2994D-04, 0.2987D-04, 0.2983D-04, 0.2979D-04,
     >    0.2977D-04/

      data (calcpts(j,14), j = 1,neta) /0.2757D-03, 0.3342D-03,
     >    0.4053D-03, 0.4909D-03, 0.5944D-03, 0.7208D-03, 0.8734D-03,
     >    0.1058D-02, 0.1282D-02, 0.1553D-02, 0.1881D-02, 0.2279D-02,
     >    0.2760D-02, 0.3346D-02, 0.4057D-02, 0.4912D-02, 0.5959D-02,
     >    0.7225D-02, 0.8761D-02, 0.1063D-01, 0.1289D-01, 0.1565D-01,
     >    0.1901D-01, 0.2312D-01, 0.2813D-01, 0.3426D-01, 0.4177D-01,
     >    0.5094D-01, 0.6209D-01, 0.7546D-01, 0.9123D-01, 0.1090D+00,
     >    0.1277D+00, 0.1456D+00, 0.1595D+00, 0.1666D+00, 0.1649D+00,
     >    0.1550D+00, 0.1390D+00, 0.1201D+00, 0.1010D+00, 0.8322D-01,
     >    0.6748D-01, 0.5402D-01, 0.4276D-01, 0.3354D-01, 0.2604D-01,
     >    0.2009D-01, 0.1537D-01, 0.1169D-01, 0.8864D-02, 0.6664D-02,
     >    0.5018D-02, 0.3720D-02, 0.2765D-02, 0.2084D-02, 0.1540D-02,
     >    0.1134D-02, 0.7956D-03, 0.5924D-03, 0.4569D-03, 0.3221D-03,
     >    0.2544D-03, 0.1870D-03, 0.1199D-03, 0.1196D-03, 0.5270D-04,
     >    0.5255D-04, 0.5245D-04, 0.5238D-04, -.1433D-04, -.1436D-04,
     >    -.1438D-04/

      data (calcpts(j,15), j = 1,neta) /0.2728D-03, 0.3303D-03,
     >    0.4008D-03, 0.4855D-03, 0.5879D-03, 0.7125D-03, 0.8631D-03,
     >    0.1045D-02, 0.1267D-02, 0.1535D-02, 0.1860D-02, 0.2254D-02,
     >    0.2733D-02, 0.3311D-02, 0.4014D-02, 0.4862D-02, 0.5890D-02,
     >    0.7144D-02, 0.8656D-02, 0.1050D-01, 0.1274D-01, 0.1547D-01,
     >    0.1879D-01, 0.2284D-01, 0.2779D-01, 0.3384D-01, 0.4124D-01,
     >    0.5028D-01, 0.6126D-01, 0.7442D-01, 0.8991D-01, 0.1074D+00,
     >    0.1259D+00, 0.1435D+00, 0.1573D+00, 0.1644D+00, 0.1630D+00,
     >    0.1534D+00, 0.1378D+00, 0.1192D+00, 0.1004D+00, 0.8273D-01,
     >    0.6712D-01, 0.5375D-01, 0.4256D-01, 0.3335D-01, 0.2591D-01,
     >    0.1998D-01, 0.1532D-01, 0.1165D-01, 0.8822D-02, 0.6623D-02,
     >    0.4978D-02, 0.3748D-02, 0.2793D-02, 0.2045D-02, 0.1502D-02,
     >    0.1095D-02, 0.8240D-03, 0.6209D-03, 0.4188D-03, 0.3507D-03,
     >    0.2163D-03, 0.1490D-03, 0.1485D-03, 0.8154D-04, 0.8133D-04,
     >    0.1452D-04, 0.1442D-04, 0.1435D-04, 0.1431D-04, 0.1427D-04,
     >    0.1425D-04/

      data (calcpts(j,16), j = 1,neta) /0.2682D-03, 0.3250D-03,
     >    0.3946D-03, 0.4778D-03, 0.5786D-03, 0.7010D-03, 0.8497D-03,
     >    0.1029D-02, 0.1247D-02, 0.1511D-02, 0.1830D-02, 0.2218D-02,
     >    0.2686D-02, 0.3253D-02, 0.3946D-02, 0.4780D-02, 0.5795D-02,
     >    0.7024D-02, 0.8518D-02, 0.1033D-01, 0.1254D-01, 0.1521D-01,
     >    0.1848D-01, 0.2246D-01, 0.2732D-01, 0.3325D-01, 0.4050D-01,
     >    0.4935D-01, 0.6008D-01, 0.7296D-01, 0.8805D-01, 0.1051D+00,
     >    0.1232D+00, 0.1404D+00, 0.1541D+00, 0.1614D+00, 0.1603D+00,
     >    0.1512D+00, 0.1361D+00, 0.1180D+00, 0.9940D-01, 0.8202D-01,
     >    0.6661D-01, 0.5338D-01, 0.4228D-01, 0.3315D-01, 0.2579D-01,
     >    0.1993D-01, 0.1528D-01, 0.1161D-01, 0.8786D-02, 0.6655D-02,
     >    0.4945D-02, 0.3715D-02, 0.2761D-02, 0.2080D-02, 0.1537D-02,
     >    0.1131D-02, 0.7928D-03, 0.5897D-03, 0.4543D-03, 0.3196D-03,
     >    0.2519D-03, 0.1846D-03, 0.1175D-03, 0.1172D-03, 0.5032D-04,
     >    0.5017D-04, 0.5008D-04, 0.5001D-04, 0.4997D-04, -.1673D-04,
     >    -.1675D-04/

      data (calcpts(j,17), j = 1,neta) /0.2625D-03, 0.3178D-03,
     >    0.3854D-03, 0.4667D-03, 0.5652D-03, 0.6851D-03, 0.8304D-03,
     >    0.1006D-02, 0.1219D-02, 0.1476D-02, 0.1789D-02, 0.2167D-02,
     >    0.2629D-02, 0.3185D-02, 0.3855D-02, 0.4675D-02, 0.5665D-02,
     >    0.6864D-02, 0.8322D-02, 0.1010D-01, 0.1225D-01, 0.1486D-01,
     >    0.1804D-01, 0.2192D-01, 0.2666D-01, 0.3243D-01, 0.3947D-01,
     >    0.4806D-01, 0.5845D-01, 0.7091D-01, 0.8548D-01, 0.1020D+00,
     >    0.1195D+00, 0.1363D+00, 0.1497D+00, 0.1571D+00, 0.1566D+00,
     >    0.1481D+00, 0.1336D+00, 0.1161D+00, 0.9804D-01, 0.8102D-01,
     >    0.6588D-01, 0.5284D-01, 0.4189D-01, 0.3291D-01, 0.2564D-01,
     >    0.1978D-01, 0.1514D-01, 0.1154D-01, 0.8721D-02, 0.6593D-02,
     >    0.4951D-02, 0.3722D-02, 0.2768D-02, 0.2022D-02, 0.1479D-02,
     >    0.1139D-02, 0.8017D-03, 0.5988D-03, 0.4634D-03, 0.3287D-03,
     >    0.2611D-03, 0.1938D-03, 0.1267D-03, 0.5977D-04, 0.5957D-04,
     >    0.5944D-04, 0.5934D-04, -.7387D-05, -.7430D-05, -.7460D-05,
     >    -.7480D-05/

      data (calcpts(j,18), j = 1,neta) /0.2543D-03, 0.3078D-03,
     >    0.3732D-03, 0.4520D-03, 0.5474D-03, 0.6629D-03, 0.8035D-03,
     >    0.9733D-03, 0.1180D-02, 0.1429D-02, 0.1731D-02, 0.2098D-02,
     >    0.2541D-02, 0.3079D-02, 0.3729D-02, 0.4525D-02, 0.5479D-02,
     >    0.6644D-02, 0.8051D-02, 0.9766D-02, 0.1184D-01, 0.1437D-01,
     >    0.1745D-01, 0.2119D-01, 0.2575D-01, 0.3131D-01, 0.3808D-01,
     >    0.4632D-01, 0.5627D-01, 0.6816D-01, 0.8206D-01, 0.9782D-01,
     >    0.1145D+00, 0.1306D+00, 0.1438D+00, 0.1513D+00, 0.1513D+00,
     >    0.1437D+00, 0.1302D+00, 0.1135D+00, 0.9614D-01, 0.7963D-01,
     >    0.6486D-01, 0.5210D-01, 0.4140D-01, 0.3251D-01, 0.2532D-01,
     >    0.1955D-01, 0.1505D-01, 0.1146D-01, 0.8710D-02, 0.6519D-02,
     >    0.4945D-02, 0.3651D-02, 0.2766D-02, 0.2020D-02, 0.1478D-02,
     >    0.1138D-02, 0.8008D-03, 0.5980D-03, 0.4628D-03, 0.3282D-03,
     >    0.2606D-03, 0.1934D-03, 0.1263D-03, 0.5934D-04, 0.5915D-04,
     >    0.5902D-04, 0.5893D-04, -.7793D-05, -.7834D-05, -.7862D-05,
     >    -.7881D-05/

      data (calcpts(j,19), j = 1,neta) /0.2427D-03, 0.2943D-03,
     >    0.3564D-03, 0.4321D-03, 0.5233D-03, 0.6339D-03, 0.7677D-03,
     >    0.9304D-03, 0.1128D-02, 0.1366D-02, 0.1654D-02, 0.2005D-02,
     >    0.2429D-02, 0.2943D-02, 0.3568D-02, 0.4323D-02, 0.5235D-02,
     >    0.6346D-02, 0.7694D-02, 0.9331D-02, 0.1131D-01, 0.1372D-01,
     >    0.1665D-01, 0.2022D-01, 0.2455D-01, 0.2983D-01, 0.3625D-01,
     >    0.4403D-01, 0.5342D-01, 0.6460D-01, 0.7767D-01, 0.9241D-01,
     >    0.1081D+00, 0.1234D+00, 0.1360D+00, 0.1437D+00, 0.1443D+00,
     >    0.1378D+00, 0.1256D+00, 0.1100D+00, 0.9352D-01, 0.7771D-01,
     >    0.6346D-01, 0.5109D-01, 0.4065D-01, 0.3199D-01, 0.2496D-01,
     >    0.1934D-01, 0.1485D-01, 0.1134D-01, 0.8593D-02, 0.6472D-02,
     >    0.4902D-02, 0.3676D-02, 0.2725D-02, 0.2047D-02, 0.1505D-02,
     >    0.1100D-02, 0.8295D-03, 0.6269D-03, 0.4251D-03, 0.2906D-03,
     >    0.2231D-03, 0.1559D-03, 0.8884D-04, 0.8859D-04, 0.8841D-04,
     >    0.2162D-04, 0.2154D-04, 0.2149D-04, 0.2145D-04, 0.2142D-04,
     >    0.2140D-04/

      data (calcpts(j,20), j = 1,neta) /0.2281D-03, 0.2765D-03,
     >    0.3351D-03, 0.4057D-03, 0.4920D-03, 0.5961D-03, 0.7219D-03,
     >    0.8744D-03, 0.1060D-02, 0.1284D-02, 0.1555D-02, 0.1885D-02,
     >    0.2284D-02, 0.2768D-02, 0.3353D-02, 0.4060D-02, 0.4921D-02,
     >    0.5965D-02, 0.7228D-02, 0.8768D-02, 0.1063D-01, 0.1289D-01,
     >    0.1564D-01, 0.1897D-01, 0.2303D-01, 0.2795D-01, 0.3393D-01,
     >    0.4116D-01, 0.4985D-01, 0.6017D-01, 0.7220D-01, 0.8575D-01,
     >    0.1002D+00, 0.1144D+00, 0.1263D+00, 0.1338D+00, 0.1352D+00,
     >    0.1300D+00, 0.1193D+00, 0.1053D+00, 0.8999D-01, 0.7513D-01,
     >    0.6159D-01, 0.4974D-01, 0.3967D-01, 0.3130D-01, 0.2449D-01,
     >    0.1896D-01, 0.1462D-01, 0.1112D-01, 0.8449D-02, 0.6401D-02,
     >    0.4834D-02, 0.3611D-02, 0.2662D-02, 0.1985D-02, 0.1511D-02,
     >    0.1106D-02, 0.7688D-03, 0.5665D-03, 0.4316D-03, 0.2972D-03,
     >    0.2298D-03, 0.1626D-03, 0.9560D-04, 0.9537D-04, 0.2855D-04,
     >    0.2844D-04, 0.2836D-04, 0.2831D-04, 0.2828D-04, 0.2826D-04,
     >    0.2824D-04/

      data (calcpts(j,21), j = 1,neta) /0.2103D-03, 0.2549D-03,
     >    0.3087D-03, 0.3736D-03, 0.4527D-03, 0.5489D-03, 0.6649D-03,
     >    0.8050D-03, 0.9762D-03, 0.1182D-02, 0.1432D-02, 0.1735D-02,
     >    0.2103D-02, 0.2547D-02, 0.3085D-02, 0.3741D-02, 0.4530D-02,
     >    0.5493D-02, 0.6658D-02, 0.8067D-02, 0.9784D-02, 0.1186D-01,
     >    0.1438D-01, 0.1744D-01, 0.2116D-01, 0.2566D-01, 0.3112D-01,
     >    0.3769D-01, 0.4558D-01, 0.5491D-01, 0.6575D-01, 0.7794D-01,
     >    0.9094D-01, 0.1037D+00, 0.1147D+00, 0.1220D+00, 0.1241D+00,
     >    0.1202D+00, 0.1113D+00, 0.9908D-01, 0.8539D-01, 0.7177D-01,
     >    0.5916D-01, 0.4799D-01, 0.3842D-01, 0.3041D-01, 0.2384D-01,
     >    0.1852D-01, 0.1426D-01, 0.1091D-01, 0.8312D-02, 0.6336D-02,
     >    0.4774D-02, 0.3554D-02, 0.2674D-02, 0.1998D-02, 0.1458D-02,
     >    0.1120D-02, 0.7841D-03, 0.5821D-03, 0.4474D-03, 0.3131D-03,
     >    0.2458D-03, 0.1787D-03, 0.1117D-03, 0.1115D-03, 0.4471D-04,
     >    0.4462D-04, 0.4455D-04, 0.4451D-04, 0.4448D-04, 0.4446D-04,
     >    0.4445D-04/

      data (calcpts(j,22), j = 1,neta) /0.1892D-03, 0.2287D-03,
     >    0.2776D-03, 0.3361D-03, 0.4075D-03, 0.4932D-03, 0.5976D-03,
     >    0.7242D-03, 0.8775D-03, 0.1063D-02, 0.1288D-02, 0.1560D-02,
     >    0.1890D-02, 0.2291D-02, 0.2775D-02, 0.3362D-02, 0.4075D-02,
     >    0.4940D-02, 0.5984D-02, 0.7251D-02, 0.8790D-02, 0.1066D-01,
     >    0.1292D-01, 0.1566D-01, 0.1898D-01, 0.2301D-01, 0.2788D-01,
     >    0.3373D-01, 0.4073D-01, 0.4899D-01, 0.5855D-01, 0.6927D-01,
     >    0.8071D-01, 0.9201D-01, 0.1019D+00, 0.1087D+00, 0.1111D+00,
     >    0.1086D+00, 0.1016D+00, 0.9138D-01, 0.7959D-01, 0.6752D-01,
     >    0.5609D-01, 0.4579D-01, 0.3685D-01, 0.2929D-01, 0.2304D-01,
     >    0.1796D-01, 0.1389D-01, 0.1066D-01, 0.8130D-02, 0.6135D-02,
     >    0.4644D-02, 0.3495D-02, 0.2617D-02, 0.1942D-02, 0.1470D-02,
     >    0.1067D-02, 0.7975D-03, 0.5958D-03, 0.3947D-03, 0.3272D-03,
     >    0.2600D-03, 0.1930D-03, 0.1261D-03, 0.5924D-04, 0.5913D-04,
     >    0.5905D-04, 0.5900D-04, 0.5896D-04, -.7732D-05, -.7749D-05,
     >    -.7760D-05/

      data (calcpts(j,23), j = 1,neta) /0.1655D-03, 0.2005D-03,
     >    0.2427D-03, 0.2942D-03, 0.3569D-03, 0.4318D-03, 0.5232D-03,
     >    0.6342D-03, 0.7686D-03, 0.9306D-03, 0.1128D-02, 0.1366D-02,
     >    0.1655D-02, 0.2006D-02, 0.2430D-02, 0.2944D-02, 0.3566D-02,
     >    0.4324D-02, 0.5236D-02, 0.6346D-02, 0.7697D-02, 0.9327D-02,
     >    0.1130D-01, 0.1370D-01, 0.1660D-01, 0.2012D-01, 0.2435D-01,
     >    0.2944D-01, 0.3551D-01, 0.4267D-01, 0.5093D-01, 0.6019D-01,
     >    0.7004D-01, 0.7982D-01, 0.8841D-01, 0.9454D-01, 0.9712D-01,
     >    0.9561D-01, 0.9035D-01, 0.8227D-01, 0.7258D-01, 0.6234D-01,
     >    0.5234D-01, 0.4311D-01, 0.3494D-01, 0.2794D-01, 0.2208D-01,
     >    0.1727D-01, 0.1340D-01, 0.1032D-01, 0.7891D-02, 0.6003D-02,
     >    0.4538D-02, 0.3418D-02, 0.2556D-02, 0.1909D-02, 0.1419D-02,
     >    0.1049D-02, 0.7738D-03, 0.5724D-03, 0.4115D-03, 0.3043D-03,
     >    0.2172D-03, 0.1635D-03, 0.1167D-03, 0.8322D-04, 0.5646D-04,
     >    0.4307D-04, 0.2969D-04, 0.2300D-04, 0.1631D-04, 0.9633D-05,
     >    0.2957D-05/

      data (calcpts(j,24), j = 1,neta) /0.1409D-03, 0.1707D-03,
     >    0.2069D-03, 0.2508D-03, 0.3035D-03, 0.3675D-03, 0.4456D-03,
     >    0.5401D-03, 0.6543D-03, 0.7925D-03, 0.9600D-03, 0.1164D-02,
     >    0.1410D-02, 0.1708D-02, 0.2069D-02, 0.2507D-02, 0.3038D-02,
     >    0.3684D-02, 0.4462D-02, 0.5404D-02, 0.6550D-02, 0.7939D-02,
     >    0.9619D-02, 0.1166D-01, 0.1413D-01, 0.1711D-01, 0.2072D-01,
     >    0.2504D-01, 0.3019D-01, 0.3626D-01, 0.4327D-01, 0.5112D-01,
     >    0.5950D-01, 0.6782D-01, 0.7521D-01, 0.8060D-01, 0.8310D-01,
     >    0.8228D-01, 0.7840D-01, 0.7221D-01, 0.6458D-01, 0.5629D-01,
     >    0.4793D-01, 0.3996D-01, 0.3271D-01, 0.2636D-01, 0.2096D-01,
     >    0.1649D-01, 0.1285D-01, 0.9932D-02, 0.7623D-02, 0.5816D-02,
     >    0.4408D-02, 0.3325D-02, 0.2498D-02, 0.1867D-02, 0.1391D-02,
     >    0.1029D-02, 0.7605D-03, 0.5595D-03, 0.4122D-03, 0.3051D-03,
     >    0.2181D-03, 0.1579D-03, 0.1177D-03, 0.8429D-04, 0.6423D-04,
     >    0.4418D-04, 0.3082D-04, 0.2413D-04, 0.1745D-04, 0.1077D-04,
     >    0.1076D-04/

      data (calcpts(j,25), j = 1,neta) /0.1168D-03, 0.1415D-03,
     >    0.1715D-03, 0.2077D-03, 0.2514D-03, 0.3048D-03, 0.3695D-03,
     >    0.4475D-03, 0.5420D-03, 0.6569D-03, 0.7959D-03, 0.9642D-03,
     >    0.1169D-02, 0.1415D-02, 0.1715D-02, 0.2078D-02, 0.2518D-02,
     >    0.3051D-02, 0.3697D-02, 0.4481D-02, 0.5431D-02, 0.6581D-02,
     >    0.7974D-02, 0.9667D-02, 0.1171D-01, 0.1419D-01, 0.1717D-01,
     >    0.2076D-01, 0.2503D-01, 0.3008D-01, 0.3591D-01, 0.4247D-01,
     >    0.4949D-01, 0.5653D-01, 0.6285D-01, 0.6757D-01, 0.6993D-01,
     >    0.6954D-01, 0.6664D-01, 0.6189D-01, 0.5601D-01, 0.4956D-01,
     >    0.4291D-01, 0.3634D-01, 0.3015D-01, 0.2456D-01, 0.1970D-01,
     >    0.1560D-01, 0.1222D-01, 0.9487D-02, 0.7313D-02, 0.5599D-02,
     >    0.4256D-02, 0.3222D-02, 0.2424D-02, 0.1814D-02, 0.1359D-02,
     >    0.1011D-02, 0.7496D-03, 0.5489D-03, 0.4018D-03, 0.2948D-03,
     >    0.2146D-03, 0.1611D-03, 0.1143D-03, 0.8092D-04, 0.6087D-04,
     >    0.4084D-04, 0.3415D-04, 0.2080D-04, 0.1413D-04, 0.1412D-04,
     >    0.7449D-05/

      data (calcpts(j,26), j = 1,neta) /0.9441D-04, 0.1144D-03,
     >    0.1386D-03, 0.1679D-03, 0.2035D-03, 0.2465D-03, 0.2988D-03,
     >    0.3618D-03, 0.4387D-03, 0.5310D-03, 0.6434D-03, 0.7796D-03,
     >    0.9444D-03, 0.1144D-02, 0.1386D-02, 0.1680D-02, 0.2035D-02,
     >    0.2466D-02, 0.2989D-02, 0.3622D-02, 0.4389D-02, 0.5322D-02,
     >    0.6448D-02, 0.7811D-02, 0.9470D-02, 0.1148D-01, 0.1389D-01,
     >    0.1680D-01, 0.2027D-01, 0.2438D-01, 0.2914D-01, 0.3452D-01,
     >    0.4033D-01, 0.4624D-01, 0.5164D-01, 0.5581D-01, 0.5808D-01,
     >    0.5806D-01, 0.5589D-01, 0.5214D-01, 0.4753D-01, 0.4257D-01,
     >    0.3746D-01, 0.3231D-01, 0.2728D-01, 0.2255D-01, 0.1829D-01,
     >    0.1461D-01, 0.1153D-01, 0.8999D-02, 0.6966D-02, 0.5350D-02,
     >    0.4084D-02, 0.3099D-02, 0.2343D-02, 0.1761D-02, 0.1313D-02,
     >    0.9785D-03, 0.7245D-03, 0.5374D-03, 0.3904D-03, 0.2902D-03,
     >    0.2101D-03, 0.1567D-03, 0.1099D-03, 0.7655D-04, 0.5652D-04,
     >    0.4316D-04, 0.2982D-04, 0.1647D-04, 0.1647D-04, 0.9795D-05,
     >    0.3125D-05/

      data (calcpts(j,27), j = 1,neta) /0.7459D-04, 0.9038D-04,
     >    0.1096D-03, 0.1328D-03, 0.1608D-03, 0.1948D-03, 0.2361D-03,
     >    0.2860D-03, 0.3463D-03, 0.4201D-03, 0.5086D-03, 0.6162D-03,
     >    0.7467D-03, 0.9047D-03, 0.1096D-02, 0.1328D-02, 0.1609D-02,
     >    0.1950D-02, 0.2363D-02, 0.2863D-02, 0.3470D-02, 0.4206D-02,
     >    0.5098D-02, 0.6182D-02, 0.7492D-02, 0.9074D-02, 0.1099D-01,
     >    0.1330D-01, 0.1607D-01, 0.1933D-01, 0.2315D-01, 0.2749D-01,
     >    0.3223D-01, 0.3712D-01, 0.4171D-01, 0.4543D-01, 0.4767D-01,
     >    0.4805D-01, 0.4654D-01, 0.4356D-01, 0.3980D-01, 0.3583D-01,
     >    0.3191D-01, 0.2802D-01, 0.2413D-01, 0.2032D-01, 0.1674D-01,
     >    0.1353D-01, 0.1078D-01, 0.8474D-02, 0.6599D-02, 0.5100D-02,
     >    0.3910D-02, 0.2980D-02, 0.2259D-02, 0.1704D-02, 0.1277D-02,
     >    0.9560D-03, 0.7089D-03, 0.5286D-03, 0.3884D-03, 0.2883D-03,
     >    0.2149D-03, 0.1548D-03, 0.1148D-03, 0.8145D-04, 0.6143D-04,
     >    0.4808D-04, 0.3474D-04, 0.2807D-04, 0.2140D-04, 0.1473D-04,
     >    0.1472D-04/

      data (calcpts(j,28), j = 1,neta) /0.5791D-04, 0.7018D-04,
     >    0.8503D-04, 0.1030D-03, 0.1248D-03, 0.1512D-03, 0.1832D-03,
     >    0.2219D-03, 0.2689D-03, 0.3258D-03, 0.3947D-03, 0.4780D-03,
     >    0.5794D-03, 0.7018D-03, 0.8505D-03, 0.1030D-02, 0.1249D-02,
     >    0.1513D-02, 0.1834D-02, 0.2222D-02, 0.2693D-02, 0.3264D-02,
     >    0.3956D-02, 0.4796D-02, 0.5814D-02, 0.7043D-02, 0.8538D-02,
     >    0.1034D-01, 0.1248D-01, 0.1505D-01, 0.1805D-01, 0.2148D-01,
     >    0.2527D-01, 0.2925D-01, 0.3310D-01, 0.3637D-01, 0.3858D-01,
     >    0.3935D-01, 0.3852D-01, 0.3628D-01, 0.3320D-01, 0.2986D-01,
     >    0.2667D-01, 0.2369D-01, 0.2079D-01, 0.1789D-01, 0.1503D-01,
     >    0.1235D-01, 0.9957D-02, 0.7905D-02, 0.6194D-02, 0.4811D-02,
     >    0.3709D-02, 0.2841D-02, 0.2160D-02, 0.1633D-02, 0.1232D-02,
     >    0.9185D-03, 0.6850D-03, 0.5115D-03, 0.3781D-03, 0.2780D-03,
     >    0.2046D-03, 0.1512D-03, 0.1112D-03, 0.7787D-04, 0.5786D-04,
     >    0.4452D-04, 0.3119D-04, 0.2452D-04, 0.1785D-04, 0.1118D-04,
     >    0.1118D-04/

      data (calcpts(j,29), j = 1,neta) /0.4422D-04, 0.5359D-04,
     >    0.6494D-04, 0.7870D-04, 0.9534D-04, 0.1155D-03, 0.1400D-03,
     >    0.1695D-03, 0.2054D-03, 0.2489D-03, 0.3015D-03, 0.3653D-03,
     >    0.4423D-03, 0.5363D-03, 0.6496D-03, 0.7869D-03, 0.9536D-03,
     >    0.1156D-02, 0.1400D-02, 0.1697D-02, 0.2057D-02, 0.2493D-02,
     >    0.3022D-02, 0.3664D-02, 0.4441D-02, 0.5384D-02, 0.6524D-02,
     >    0.7899D-02, 0.9553D-02, 0.1153D-01, 0.1384D-01, 0.1651D-01,
     >    0.1948D-01, 0.2266D-01, 0.2581D-01, 0.2862D-01, 0.3073D-01,
     >    0.3179D-01, 0.3158D-01, 0.3012D-01, 0.2772D-01, 0.2490D-01,
     >    0.2214D-01, 0.1968D-01, 0.1747D-01, 0.1533D-01, 0.1318D-01,
     >    0.1106D-01, 0.9063D-02, 0.7286D-02, 0.5765D-02, 0.4510D-02,
     >    0.3496D-02, 0.2688D-02, 0.2055D-02, 0.1561D-02, 0.1174D-02,
     >    0.8874D-03, 0.6607D-03, 0.4939D-03, 0.3672D-03, 0.2672D-03,
     >    0.2005D-03, 0.1472D-03, 0.1071D-03, 0.7381D-04, 0.5380D-04,
     >    0.4047D-04, 0.2713D-04, 0.2046D-04, 0.1379D-04, 0.7127D-05,
     >    0.7127D-05/

      data (calcpts(j,30), j = 1,neta) /0.3339D-04, 0.4040D-04,
     >    0.4896D-04, 0.5931D-04, 0.7186D-04, 0.8708D-04, 0.1055D-03,
     >    0.1279D-03, 0.1549D-03, 0.1876D-03, 0.2273D-03, 0.2755D-03,
     >    0.3337D-03, 0.4043D-03, 0.4899D-03, 0.5933D-03, 0.7195D-03,
     >    0.8717D-03, 0.1056D-02, 0.1280D-02, 0.1551D-02, 0.1880D-02,
     >    0.2279D-02, 0.2763D-02, 0.3350D-02, 0.4061D-02, 0.4922D-02,
     >    0.5962D-02, 0.7212D-02, 0.8703D-02, 0.1047D-01, 0.1251D-01,
     >    0.1481D-01, 0.1729D-01, 0.1981D-01, 0.2216D-01, 0.2408D-01,
     >    0.2527D-01, 0.2553D-01, 0.2477D-01, 0.2311D-01, 0.2086D-01,
     >    0.1846D-01, 0.1628D-01, 0.1443D-01, 0.1281D-01, 0.1125D-01,
     >    0.9669D-02, 0.8097D-02, 0.6622D-02, 0.5310D-02, 0.4192D-02,
     >    0.3272D-02, 0.2532D-02, 0.1945D-02, 0.1485D-02, 0.1125D-02,
     >    0.8448D-03, 0.6381D-03, 0.4781D-03, 0.3514D-03, 0.2648D-03,
     >    0.1914D-03, 0.1448D-03, 0.1048D-03, 0.7809D-04, 0.5809D-04,
     >    0.3809D-04, 0.3142D-04, 0.1809D-04, 0.1809D-04, 0.1142D-04,
     >    0.4756D-05/

      data (calcpts(j,31), j = 1,neta) /0.2490D-04, 0.3016D-04,
     >    0.3654D-04, 0.4428D-04, 0.5367D-04, 0.6502D-04, 0.7877D-04,
     >    0.9543D-04, 0.1156D-03, 0.1401D-03, 0.1697D-03, 0.2056D-03,
     >    0.2490D-03, 0.3017D-03, 0.3656D-03, 0.4430D-03, 0.5366D-03,
     >    0.6505D-03, 0.7880D-03, 0.9552D-03, 0.1158D-02, 0.1403D-02,
     >    0.1701D-02, 0.2062D-02, 0.2499D-02, 0.3031D-02, 0.3673D-02,
     >    0.4450D-02, 0.5386D-02, 0.6504D-02, 0.7828D-02, 0.9372D-02,
     >    0.1112D-01, 0.1302D-01, 0.1501D-01, 0.1691D-01, 0.1855D-01,
     >    0.1974D-01, 0.2028D-01, 0.2007D-01, 0.1909D-01, 0.1747D-01,
     >    0.1552D-01, 0.1357D-01, 0.1189D-01, 0.1053D-01, 0.9356D-02,
     >    0.8220D-02, 0.7059D-02, 0.5903D-02, 0.4817D-02, 0.3855D-02,
     >    0.3039D-02, 0.2368D-02, 0.1827D-02, 0.1400D-02, 0.1067D-02,
     >    0.8068D-03, 0.6068D-03, 0.4535D-03, 0.3402D-03, 0.2535D-03,
     >    0.1869D-03, 0.1402D-03, 0.1002D-03, 0.7354D-04, 0.5354D-04,
     >    0.4021D-04, 0.2687D-04, 0.2021D-04, 0.1354D-04, 0.1354D-04,
     >    0.6874D-05/

      data (calcpts(j,32), j = 1,neta) /0.1842D-04, 0.2232D-04,
     >    0.2705D-04, 0.3277D-04, 0.3967D-04, 0.4809D-04, 0.5828D-04,
     >    0.7059D-04, 0.8552D-04, 0.1036D-03, 0.1255D-03, 0.1521D-03,
     >    0.1842D-03, 0.2232D-03, 0.2705D-03, 0.3277D-03, 0.3971D-03,
     >    0.4812D-03, 0.5832D-03, 0.7063D-03, 0.8566D-03, 0.1038D-02,
     >    0.1258D-02, 0.1525D-02, 0.1849D-02, 0.2242D-02, 0.2717D-02,
     >    0.3293D-02, 0.3986D-02, 0.4815D-02, 0.5799D-02, 0.6949D-02,
     >    0.8259D-02, 0.9705D-02, 0.1123D-01, 0.1273D-01, 0.1409D-01,
     >    0.1517D-01, 0.1583D-01, 0.1597D-01, 0.1551D-01, 0.1450D-01,
     >    0.1306D-01, 0.1144D-01, 0.9914D-02, 0.8646D-02, 0.7648D-02,
     >    0.6802D-02, 0.5979D-02, 0.5131D-02, 0.4284D-02, 0.3490D-02,
     >    0.2787D-02, 0.2193D-02, 0.1706D-02, 0.1315D-02, 0.1007D-02,
     >    0.7654D-03, 0.5787D-03, 0.4354D-03, 0.3261D-03, 0.2428D-03,
     >    0.1801D-03, 0.1328D-03, 0.9812D-04, 0.7146D-04, 0.5213D-04,
     >    0.3813D-04, 0.2746D-04, 0.1946D-04, 0.1413D-04, 0.1013D-04,
     >    0.6796D-05/

      data (calcpts(j,33), j = 1,neta) /0.1353D-04, 0.1639D-04,
     >    0.1986D-04, 0.2406D-04, 0.2915D-04, 0.3532D-04, 0.4280D-04,
     >    0.5186D-04, 0.6284D-04, 0.7611D-04, 0.9222D-04, 0.1117D-03,
     >    0.1353D-03, 0.1640D-03, 0.1987D-03, 0.2407D-03, 0.2917D-03,
     >    0.3535D-03, 0.4283D-03, 0.5190D-03, 0.6291D-03, 0.7624D-03,
     >    0.9242D-03, 0.1120D-02, 0.1359D-02, 0.1647D-02, 0.1996D-02,
     >    0.2419D-02, 0.2929D-02, 0.3539D-02, 0.4264D-02, 0.5114D-02,
     >    0.6087D-02, 0.7170D-02, 0.8324D-02, 0.9486D-02, 0.1058D-01,
     >    0.1150D-01, 0.1216D-01, 0.1247D-01, 0.1237D-01, 0.1182D-01,
     >    0.1089D-01, 0.9674D-02, 0.8381D-02, 0.7203D-02, 0.6260D-02,
     >    0.5537D-02, 0.4928D-02, 0.4334D-02, 0.3718D-02, 0.3101D-02,
     >    0.2522D-02, 0.2011D-02, 0.1580D-02, 0.1228D-02, 0.9457D-03,
     >    0.7231D-03, 0.5498D-03, 0.4151D-03, 0.3125D-03, 0.2338D-03,
     >    0.1745D-03, 0.1299D-03, 0.9586D-04, 0.7119D-04, 0.5253D-04,
     >    0.3853D-04, 0.2853D-04, 0.2053D-04, 0.1520D-04, 0.1120D-04,
     >    0.8532D-05/

      data (calcpts(j,34), j = 1,neta) /0.9884D-05, 0.1197D-04,
     >    0.1451D-04, 0.1758D-04, 0.2129D-04, 0.2579D-04, 0.3125D-04,
     >    0.3787D-04, 0.4585D-04, 0.5560D-04, 0.6733D-04, 0.8161D-04,
     >    0.9883D-04, 0.1198D-03, 0.1451D-03, 0.1758D-03, 0.2130D-03,
     >    0.2581D-03, 0.3128D-03, 0.3790D-03, 0.4594D-03, 0.5567D-03,
     >    0.6748D-03, 0.8180D-03, 0.9920D-03, 0.1203D-02, 0.1457D-02,
     >    0.1766D-02, 0.2138D-02, 0.2585D-02, 0.3116D-02, 0.3739D-02,
     >    0.4456D-02, 0.5258D-02, 0.6121D-02, 0.7005D-02, 0.7857D-02,
     >    0.8612D-02, 0.9205D-02, 0.9575D-02, 0.9668D-02, 0.9447D-02,
     >    0.8908D-02, 0.8095D-02, 0.7109D-02, 0.6099D-02, 0.5209D-02,
     >    0.4514D-02, 0.3993D-02, 0.3557D-02, 0.3130D-02, 0.2683D-02,
     >    0.2236D-02, 0.1816D-02, 0.1445D-02, 0.1134D-02, 0.8796D-03,
     >    0.6770D-03, 0.5170D-03, 0.3924D-03, 0.2930D-03, 0.2224D-03,
     >    0.1664D-03, 0.1237D-03, 0.9174D-04, 0.6774D-04, 0.4974D-04,
     >    0.3641D-04, 0.2708D-04, 0.1974D-04, 0.1441D-04, 0.1041D-04,
     >    0.7744D-05/

      data (calcpts(j,35), j = 1,neta) /0.7181D-05, 0.8703D-05,
     >    0.1054D-04, 0.1277D-04, 0.1548D-04, 0.1875D-04, 0.2272D-04,
     >    0.2752D-04, 0.3334D-04, 0.4039D-04, 0.4895D-04, 0.5928D-04,
     >    0.7186D-04, 0.8704D-04, 0.1055D-03, 0.1278D-03, 0.1548D-03,
     >    0.1876D-03, 0.2273D-03, 0.2754D-03, 0.3338D-03, 0.4046D-03,
     >    0.4904D-03, 0.5944D-03, 0.7209D-03, 0.8739D-03, 0.1059D-02,
     >    0.1283D-02, 0.1554D-02, 0.1878D-02, 0.2265D-02, 0.2719D-02,
     >    0.3243D-02, 0.3833D-02, 0.4472D-02, 0.5136D-02, 0.5787D-02,
     >    0.6385D-02, 0.6885D-02, 0.7246D-02, 0.7428D-02, 0.7396D-02,
     >    0.7134D-02, 0.6646D-02, 0.5971D-02, 0.5191D-02, 0.4417D-02,
     >    0.3752D-02, 0.3245D-02, 0.2871D-02, 0.2560D-02, 0.2253D-02,
     >    0.1931D-02, 0.1607D-02, 0.1303D-02, 0.1036D-02, 0.8116D-03,
     >    0.6290D-03, 0.4830D-03, 0.3684D-03, 0.2791D-03, 0.2104D-03,
     >    0.1578D-03, 0.1178D-03, 0.8778D-04, 0.6511D-04, 0.4778D-04,
     >    0.3512D-04, 0.2578D-04, 0.1845D-04, 0.1378D-04, 0.9784D-05,
     >    0.7117D-05/

      data (calcpts(j,36), j = 1,neta) /0.5199D-05, 0.6298D-05,
     >    0.7628D-05, 0.9240D-05, 0.1120D-04, 0.1356D-04, 0.1644D-04,
     >    0.1991D-04, 0.2413D-04, 0.2923D-04, 0.3541D-04, 0.4290D-04,
     >    0.5199D-04, 0.6297D-04, 0.7629D-04, 0.9246D-04, 0.1120D-03,
     >    0.1357D-03, 0.1645D-03, 0.1993D-03, 0.2415D-03, 0.2927D-03,
     >    0.3548D-03, 0.4301D-03, 0.5213D-03, 0.6320D-03, 0.7660D-03,
     >    0.9282D-03, 0.1124D-02, 0.1359D-02, 0.1639D-02, 0.1969D-02,
     >    0.2350D-02, 0.2780D-02, 0.3250D-02, 0.3743D-02, 0.4234D-02,
     >    0.4697D-02, 0.5101D-02, 0.5419D-02, 0.5623D-02, 0.5688D-02,
     >    0.5595D-02, 0.5336D-02, 0.4918D-02, 0.4375D-02, 0.3771D-02,
     >    0.3185D-02, 0.2694D-02, 0.2326D-02, 0.2059D-02, 0.1837D-02,
     >    0.1617D-02, 0.1386D-02, 0.1152D-02, 0.9331D-03, 0.7411D-03,
     >    0.5799D-03, 0.4492D-03, 0.3446D-03, 0.2626D-03, 0.1993D-03,
     >    0.1499D-03, 0.1126D-03, 0.8394D-04, 0.6261D-04, 0.4595D-04,
     >    0.3395D-04, 0.2528D-04, 0.1795D-04, 0.1328D-04, 0.9951D-05,
     >    0.7284D-05/

      data (calcpts(j,37), j = 1,neta) /0.3747D-05, 0.4542D-05,
     >    0.5498D-05, 0.6662D-05, 0.8071D-05, 0.9782D-05, 0.1185D-04,
     >    0.1435D-04, 0.1739D-04, 0.2107D-04, 0.2553D-04, 0.3093D-04,
     >    0.3748D-04, 0.4540D-04, 0.5502D-04, 0.6667D-04, 0.8072D-04,
     >    0.9783D-04, 0.1185D-03, 0.1437D-03, 0.1741D-03, 0.2110D-03,
     >    0.2558D-03, 0.3100D-03, 0.3758D-03, 0.4556D-03, 0.5522D-03,
     >    0.6690D-03, 0.8100D-03, 0.9794D-03, 0.1181D-02, 0.1419D-02,
     >    0.1695D-02, 0.2008D-02, 0.2351D-02, 0.2714D-02, 0.3080D-02,
     >    0.3432D-02, 0.3749D-02, 0.4013D-02, 0.4205D-02, 0.4308D-02,
     >    0.4308D-02, 0.4192D-02, 0.3958D-02, 0.3614D-02, 0.3188D-02,
     >    0.2726D-02, 0.2289D-02, 0.1928D-02, 0.1663D-02, 0.1473D-02,
     >    0.1315D-02, 0.1158D-02, 0.9917D-03, 0.8239D-03, 0.6665D-03,
     >    0.5292D-03, 0.4132D-03, 0.3199D-03, 0.2452D-03, 0.1865D-03,
     >    0.1412D-03, 0.1066D-03, 0.7989D-04, 0.5923D-04, 0.4389D-04,
     >    0.3256D-04, 0.2389D-04, 0.1723D-04, 0.1323D-04, 0.9229D-05,
     >    0.6563D-05/

      data (calcpts(j,38), j = 1,neta) /0.2693D-05, 0.3262D-05,
     >    0.3953D-05, 0.4790D-05, 0.5801D-05, 0.7032D-05, 0.8515D-05,
     >    0.1032D-04, 0.1250D-04, 0.1514D-04, 0.1835D-04, 0.2223D-04,
     >    0.2693D-04, 0.3263D-04, 0.3954D-04, 0.4790D-04, 0.5803D-04,
     >    0.7034D-04, 0.8521D-04, 0.1033D-03, 0.1251D-03, 0.1516D-03,
     >    0.1838D-03, 0.2228D-03, 0.2700D-03, 0.3273D-03, 0.3967D-03,
     >    0.4807D-03, 0.5819D-03, 0.7036D-03, 0.8488D-03, 0.1020D-02,
     >    0.1219D-02, 0.1445D-02, 0.1694D-02, 0.1960D-02, 0.2230D-02,
     >    0.2494D-02, 0.2738D-02, 0.2949D-02, 0.3115D-02, 0.3224D-02,
     >    0.3266D-02, 0.3231D-02, 0.3114D-02, 0.2915D-02, 0.2640D-02,
     >    0.2311D-02, 0.1963D-02, 0.1640D-02, 0.1377D-02, 0.1186D-02,
     >    0.1051D-02, 0.9394D-03, 0.8273D-03, 0.7081D-03, 0.5877D-03,
     >    0.4752D-03, 0.3766D-03, 0.2938D-03, 0.2271D-03, 0.1738D-03,
     >    0.1325D-03, 0.9981D-04, 0.7515D-04, 0.5648D-04, 0.4182D-04,
     >    0.3115D-04, 0.2315D-04, 0.1648D-04, 0.1248D-04, 0.9150D-05,
     >    0.6484D-05/

      data (calcpts(j,39), j = 1,neta) /0.1929D-05, 0.2338D-05,
     >    0.2832D-05, 0.3431D-05, 0.4157D-05, 0.5039D-05, 0.6100D-05,
     >    0.7390D-05, 0.8955D-05, 0.1085D-04, 0.1314D-04, 0.1593D-04,
     >    0.1930D-04, 0.2338D-04, 0.2833D-04, 0.3433D-04, 0.4159D-04,
     >    0.5039D-04, 0.6106D-04, 0.7396D-04, 0.8967D-04, 0.1087D-03,
     >    0.1317D-03, 0.1596D-03, 0.1935D-03, 0.2345D-03, 0.2842D-03,
     >    0.3443D-03, 0.4170D-03, 0.5041D-03, 0.6082D-03, 0.7312D-03,
     >    0.8742D-03, 0.1037D-02, 0.1217D-02, 0.1410D-02, 0.1608D-02,
     >    0.1804D-02, 0.1989D-02, 0.2153D-02, 0.2288D-02, 0.2388D-02,
     >    0.2445D-02, 0.2452D-02, 0.2404D-02, 0.2298D-02, 0.2134D-02,
     >    0.1919D-02, 0.1669D-02, 0.1410D-02, 0.1172D-02, 0.9811D-03,
     >    0.8447D-03, 0.7488D-03, 0.6697D-03, 0.5899D-03, 0.5048D-03,
     >    0.4188D-03, 0.3383D-03, 0.2679D-03, 0.2091D-03, 0.1614D-03,
     >    0.1236D-03, 0.9402D-04, 0.7108D-04, 0.5349D-04, 0.3989D-04,
     >    0.2989D-04, 0.2189D-04, 0.1655D-04, 0.1189D-04, 0.9221D-05,
     >    0.6554D-05/

      data (calcpts(j,40), j = 1,neta) /0.1379D-05, 0.1671D-05,
     >    0.2025D-05, 0.2453D-05, 0.2972D-05, 0.3600D-05, 0.4362D-05,
     >    0.5285D-05, 0.6401D-05, 0.7759D-05, 0.9399D-05, 0.1138D-04,
     >    0.1380D-04, 0.1671D-04, 0.2025D-04, 0.2454D-04, 0.2973D-04,
     >    0.3602D-04, 0.4364D-04, 0.5288D-04, 0.6408D-04, 0.7768D-04,
     >    0.9415D-04, 0.1141D-03, 0.1382D-03, 0.1676D-03, 0.2031D-03,
     >    0.2461D-03, 0.2980D-03, 0.3602D-03, 0.4347D-03, 0.5226D-03,
     >    0.6251D-03, 0.7419D-03, 0.8716D-03, 0.1011D-02, 0.1155D-02,
     >    0.1300D-02, 0.1438D-02, 0.1563D-02, 0.1670D-02, 0.1755D-02,
     >    0.1812D-02, 0.1837D-02, 0.1825D-02, 0.1775D-02, 0.1685D-02,
     >    0.1554D-02, 0.1389D-02, 0.1201D-02, 0.1009D-02, 0.8352D-03,
     >    0.6976D-03, 0.6001D-03, 0.5322D-03, 0.4763D-03, 0.4197D-03,
     >    0.3590D-03, 0.2976D-03, 0.2402D-03, 0.1901D-03, 0.1482D-03,
     >    0.1143D-03, 0.8746D-04, 0.6646D-04, 0.5026D-04, 0.3773D-04,
     >    0.2826D-04, 0.2106D-04, 0.1546D-04, 0.1153D-04, 0.8464D-05,
     >    0.6264D-05/

      data (calcpts(j,41), j = 1,neta) /0.9836D-06, 0.1192D-05,
     >    0.1444D-05, 0.1750D-05, 0.2120D-05, 0.2568D-05, 0.3111D-05,
     >    0.3769D-05, 0.4567D-05, 0.5531D-05, 0.6704D-05, 0.8123D-05,
     >    0.9839D-05, 0.1192D-04, 0.1444D-04, 0.1750D-04, 0.2120D-04,
     >    0.2569D-04, 0.3113D-04, 0.3772D-04, 0.4570D-04, 0.5539D-04,
     >    0.6713D-04, 0.8134D-04, 0.9861D-04, 0.1195D-03, 0.1449D-03,
     >    0.1754D-03, 0.2125D-03, 0.2569D-03, 0.3099D-03, 0.3727D-03,
     >    0.4459D-03, 0.5295D-03, 0.6227D-03, 0.7233D-03, 0.8281D-03,
     >    0.9335D-03, 0.1036D-02, 0.1130D-02, 0.1213D-02, 0.1281D-02,
     >    0.1331D-02, 0.1362D-02, 0.1368D-02, 0.1349D-02, 0.1303D-02,
     >    0.1229D-02, 0.1126D-02, 0.1001D-02, 0.8613D-03, 0.7202D-03,
     >    0.5940D-03, 0.4950D-03, 0.4256D-03, 0.3776D-03, 0.3382D-03,
     >    0.2980D-03, 0.2548D-03, 0.2111D-03, 0.1702D-03, 0.1346D-03,
     >    0.1049D-03, 0.8085D-04, 0.6179D-04, 0.4692D-04, 0.3539D-04,
     >    0.2659D-04, 0.1985D-04, 0.1466D-04, 0.1092D-04, 0.8055D-05,
     >    0.5922D-05/

      data (calcpts(j,42), j = 1,neta) /0.7004D-06, 0.8482D-06,
     >    0.1028D-05, 0.1246D-05, 0.1509D-05, 0.1827D-05, 0.2214D-05,
     >    0.2683D-05, 0.3250D-05, 0.3938D-05, 0.4771D-05, 0.5778D-05,
     >    0.7001D-05, 0.8488D-05, 0.1028D-04, 0.1245D-04, 0.1509D-04,
     >    0.1828D-04, 0.2216D-04, 0.2684D-04, 0.3252D-04, 0.3942D-04,
     >    0.4777D-04, 0.5790D-04, 0.7017D-04, 0.8503D-04, 0.1031D-03,
     >    0.1248D-03, 0.1512D-03, 0.1828D-03, 0.2205D-03, 0.2653D-03,
     >    0.3174D-03, 0.3772D-03, 0.4439D-03, 0.5161D-03, 0.5919D-03,
     >    0.6686D-03, 0.7434D-03, 0.8136D-03, 0.8767D-03, 0.9305D-03,
     >    0.9725D-03, 0.1001D-02, 0.1015D-02, 0.1012D-02, 0.9913D-03,
     >    0.9518D-03, 0.8919D-03, 0.8136D-03, 0.7195D-03, 0.6161D-03,
     >    0.5131D-03, 0.4218D-03, 0.3507D-03, 0.3014D-03, 0.2676D-03,
     >    0.2398D-03, 0.2113D-03, 0.1806D-03, 0.1496D-03, 0.1206D-03,
     >    0.9525D-04, 0.7412D-04, 0.5712D-04, 0.4366D-04, 0.3312D-04,
     >    0.2499D-04, 0.1879D-04, 0.1392D-04, 0.1039D-04, 0.7724D-05,
     >    0.5658D-05/

      data (calcpts(j,43), j = 1,neta) /0.4974D-06, 0.6029D-06,
     >    0.7301D-06, 0.8846D-06, 0.1071D-05, 0.1298D-05, 0.1573D-05,
     >    0.1906D-05, 0.2309D-05, 0.2798D-05, 0.3389D-05, 0.4106D-05,
     >    0.4975D-05, 0.6027D-05, 0.7305D-05, 0.8846D-05, 0.1072D-04,
     >    0.1299D-04, 0.1574D-04, 0.1907D-04, 0.2311D-04, 0.2800D-04,
     >    0.3393D-04, 0.4113D-04, 0.4985D-04, 0.6041D-04, 0.7320D-04,
     >    0.8870D-04, 0.1073D-03, 0.1298D-03, 0.1566D-03, 0.1884D-03,
     >    0.2256D-03, 0.2681D-03, 0.3157D-03, 0.3675D-03, 0.4220D-03,
     >    0.4776D-03, 0.5321D-03, 0.5840D-03, 0.6313D-03, 0.6725D-03,
     >    0.7062D-03, 0.7312D-03, 0.7465D-03, 0.7510D-03, 0.7440D-03,
     >    0.7243D-03, 0.6914D-03, 0.6450D-03, 0.5856D-03, 0.5156D-03,
     >    0.4396D-03, 0.3647D-03, 0.2989D-03, 0.2481D-03, 0.2132D-03,
     >    0.1893D-03, 0.1697D-03, 0.1496D-03, 0.1278D-03, 0.1058D-03,
     >    0.8526D-04, 0.6726D-04, 0.5232D-04, 0.4032D-04, 0.3079D-04,
     >    0.2333D-04, 0.1759D-04, 0.1319D-04, 0.9859D-05, 0.7325D-05,
     >    0.5459D-05/

      data (calcpts(j,44), j = 1,neta) /0.3528D-06, 0.4274D-06,
     >    0.5179D-06, 0.6277D-06, 0.7598D-06, 0.9211D-06, 0.1116D-05,
     >    0.1352D-05, 0.1638D-05, 0.1984D-05, 0.2404D-05, 0.2912D-05,
     >    0.3528D-05, 0.4275D-05, 0.5179D-05, 0.6275D-05, 0.7603D-05,
     >    0.9212D-05, 0.1116D-04, 0.1352D-04, 0.1639D-04, 0.1986D-04,
     >    0.2406D-04, 0.2916D-04, 0.3535D-04, 0.4284D-04, 0.5190D-04,
     >    0.6288D-04, 0.7611D-04, 0.9204D-04, 0.1111D-03, 0.1336D-03,
     >    0.1600D-03, 0.1903D-03, 0.2242D-03, 0.2612D-03, 0.3003D-03,
     >    0.3403D-03, 0.3800D-03, 0.4180D-03, 0.4531D-03, 0.4843D-03,
     >    0.5106D-03, 0.5312D-03, 0.5454D-03, 0.5527D-03, 0.5524D-03,
     >    0.5439D-03, 0.5268D-03, 0.5004D-03, 0.4648D-03, 0.4202D-03,
     >    0.3685D-03, 0.3130D-03, 0.2588D-03, 0.2115D-03, 0.1753D-03,
     >    0.1505D-03, 0.1337D-03, 0.1199D-03, 0.1057D-03, 0.9034D-04,
     >    0.7472D-04, 0.6014D-04, 0.4747D-04, 0.3687D-04, 0.2840D-04,
     >    0.2167D-04, 0.1640D-04, 0.1240D-04, 0.9271D-05, 0.6938D-05,
     >    0.5138D-05/

      data (calcpts(j,45), j = 1,neta) /0.2498D-06, 0.3026D-06,
     >    0.3666D-06, 0.4442D-06, 0.5384D-06, 0.6517D-06, 0.7901D-06,
     >    0.9569D-06, 0.1160D-05, 0.1405D-05, 0.1702D-05, 0.2062D-05,
     >    0.2499D-05, 0.3027D-05, 0.3667D-05, 0.4443D-05, 0.5383D-05,
     >    0.6523D-05, 0.7902D-05, 0.9579D-05, 0.1160D-04, 0.1406D-04,
     >    0.1704D-04, 0.2065D-04, 0.2502D-04, 0.3033D-04, 0.3675D-04,
     >    0.4452D-04, 0.5389D-04, 0.6516D-04, 0.7864D-04, 0.9462D-04,
     >    0.1133D-03, 0.1348D-03, 0.1589D-03, 0.1853D-03, 0.2133D-03,
     >    0.2421D-03, 0.2708D-03, 0.2985D-03, 0.3243D-03, 0.3477D-03,
     >    0.3678D-03, 0.3841D-03, 0.3963D-03, 0.4039D-03, 0.4067D-03,
     >    0.4041D-03, 0.3958D-03, 0.3816D-03, 0.3610D-03, 0.3339D-03,
     >    0.3007D-03, 0.2628D-03, 0.2225D-03, 0.1834D-03, 0.1495D-03,
     >    0.1237D-03, 0.1062D-03, 0.9438D-04, 0.8469D-04, 0.7467D-04,
     >    0.6379D-04, 0.5275D-04, 0.4245D-04, 0.3348D-04, 0.2604D-04,
     >    0.2004D-04, 0.1524D-04, 0.1158D-04, 0.8709D-05, 0.6576D-05,
     >    0.4909D-05/

      data (calcpts(j,46), j = 1,neta) /0.1766D-06, 0.2140D-06,
     >    0.2593D-06, 0.3141D-06, 0.3805D-06, 0.4610D-06, 0.5583D-06,
     >    0.6765D-06, 0.8200D-06, 0.9935D-06, 0.1204D-05, 0.1458D-05,
     >    0.1766D-05, 0.2140D-05, 0.2593D-05, 0.3142D-05, 0.3807D-05,
     >    0.4612D-05, 0.5588D-05, 0.6771D-05, 0.8207D-05, 0.9939D-05,
     >    0.1205D-04, 0.1460D-04, 0.1770D-04, 0.2144D-04, 0.2598D-04,
     >    0.3147D-04, 0.3810D-04, 0.4606D-04, 0.5559D-04, 0.6689D-04,
     >    0.8012D-04, 0.9534D-04, 0.1125D-03, 0.1312D-03, 0.1512D-03,
     >    0.1719D-03, 0.1925D-03, 0.2126D-03, 0.2316D-03, 0.2488D-03,
     >    0.2640D-03, 0.2767D-03, 0.2866D-03, 0.2936D-03, 0.2972D-03,
     >    0.2976D-03, 0.2942D-03, 0.2869D-03, 0.2754D-03, 0.2595D-03,
     >    0.2392D-03, 0.2147D-03, 0.1870D-03, 0.1578D-03, 0.1297D-03,
     >    0.1055D-03, 0.8715D-04, 0.7480D-04, 0.6651D-04, 0.5970D-04,
     >    0.5264D-04, 0.4496D-04, 0.3716D-04, 0.2989D-04, 0.2356D-04,
     >    0.1830D-04, 0.1407D-04, 0.1073D-04, 0.8131D-05, 0.6124D-05,
     >    0.4591D-05/

      data (calcpts(j,47), j = 1,neta) /0.1247D-06, 0.1511D-06,
     >    0.1831D-06, 0.2218D-06, 0.2687D-06, 0.3256D-06, 0.3945D-06,
     >    0.4779D-06, 0.5790D-06, 0.7013D-06, 0.8498D-06, 0.1029D-05,
     >    0.1247D-05, 0.1511D-05, 0.1831D-05, 0.2218D-05, 0.2688D-05,
     >    0.3257D-05, 0.3946D-05, 0.4781D-05, 0.5793D-05, 0.7020D-05,
     >    0.8506D-05, 0.1031D-04, 0.1249D-04, 0.1514D-04, 0.1834D-04,
     >    0.2222D-04, 0.2689D-04, 0.3252D-04, 0.3925D-04, 0.4723D-04,
     >    0.5657D-04, 0.6735D-04, 0.7949D-04, 0.9282D-04, 0.1071D-03,
     >    0.1218D-03, 0.1366D-03, 0.1512D-03, 0.1650D-03, 0.1777D-03,
     >    0.1890D-03, 0.1986D-03, 0.2065D-03, 0.2123D-03, 0.2161D-03,
     >    0.2176D-03, 0.2167D-03, 0.2133D-03, 0.2071D-03, 0.1981D-03,
     >    0.1860D-03, 0.1709D-03, 0.1530D-03, 0.1328D-03, 0.1118D-03,
     >    0.9159D-04, 0.7433D-04, 0.6134D-04, 0.5263D-04, 0.4681D-04,
     >    0.4204D-04, 0.3707D-04, 0.3166D-04, 0.2615D-04, 0.2102D-04,
     >    0.1656D-04, 0.1286D-04, 0.9878D-05, 0.7524D-05, 0.5698D-05,
     >    0.4291D-05/

      data (calcpts(j,48), j = 1,neta) /0.8797D-07, 0.1066D-06,
     >    0.1291D-06, 0.1564D-06, 0.1895D-06, 0.2296D-06, 0.2782D-06,
     >    0.3371D-06, 0.4083D-06, 0.4947D-06, 0.5994D-06, 0.7261D-06,
     >    0.8796D-06, 0.1066D-05, 0.1291D-05, 0.1565D-05, 0.1896D-05,
     >    0.2296D-05, 0.2783D-05, 0.3372D-05, 0.4086D-05, 0.4951D-05,
     >    0.6000D-05, 0.7270D-05, 0.8808D-05, 0.1068D-04, 0.1293D-04,
     >    0.1567D-04, 0.1897D-04, 0.2293D-04, 0.2767D-04, 0.3331D-04,
     >    0.3991D-04, 0.4752D-04, 0.5611D-04, 0.6556D-04, 0.7568D-04,
     >    0.8621D-04, 0.9686D-04, 0.1073D-03, 0.1173D-03, 0.1265D-03,
     >    0.1350D-03, 0.1422D-03, 0.1482D-03, 0.1530D-03, 0.1564D-03,
     >    0.1582D-03, 0.1585D-03, 0.1572D-03, 0.1541D-03, 0.1491D-03,
     >    0.1421D-03, 0.1330D-03, 0.1219D-03, 0.1088D-03, 0.9418D-04,
     >    0.7904D-04, 0.6462D-04, 0.5233D-04, 0.4313D-04, 0.3700D-04,
     >    0.3292D-04, 0.2958D-04, 0.2609D-04, 0.2227D-04, 0.1839D-04,
     >    0.1478D-04, 0.1163D-04, 0.9027D-05, 0.6934D-05, 0.5281D-05,
     >    0.4001D-05/

      data (calcpts(j,49), j = 1,neta) /0.6194D-07, 0.7506D-07,
     >    0.9095D-07, 0.1102D-06, 0.1335D-06, 0.1617D-06, 0.1960D-06,
     >    0.2374D-06, 0.2876D-06, 0.3485D-06, 0.4222D-06, 0.5115D-06,
     >    0.6198D-06, 0.7509D-06, 0.9094D-06, 0.1102D-05, 0.1335D-05,
     >    0.1618D-05, 0.1960D-05, 0.2375D-05, 0.2878D-05, 0.3488D-05,
     >    0.4226D-05, 0.5121D-05, 0.6206D-05, 0.7520D-05, 0.9108D-05,
     >    0.1104D-04, 0.1335D-04, 0.1615D-04, 0.1949D-04, 0.2346D-04,
     >    0.2811D-04, 0.3348D-04, 0.3956D-04, 0.4625D-04, 0.5343D-04,
     >    0.6092D-04, 0.6852D-04, 0.7603D-04, 0.8325D-04, 0.8997D-04,
     >    0.9617D-04, 0.1015D-03, 0.1062D-03, 0.1099D-03, 0.1127D-03,
     >    0.1145D-03, 0.1153D-03, 0.1150D-03, 0.1135D-03, 0.1109D-03,
     >    0.1070D-03, 0.1017D-03, 0.9490D-04, 0.8672D-04, 0.7719D-04,
     >    0.6667D-04, 0.5582D-04, 0.4553D-04, 0.3680D-04, 0.3030D-04,
     >    0.2599D-04, 0.2313D-04, 0.2079D-04, 0.1833D-04, 0.1565D-04,
     >    0.1292D-04, 0.1038D-04, 0.8170D-05, 0.6337D-05, 0.4864D-05,
     >    0.3704D-05/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ixi .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsctba = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine sctca_CT(eta, xi, xsctca)
c   the subtracted term from eq (9) of PLB347 (1995) 143 - 151
c   transverse gluon initiated piece with C_A color factor in front
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsctca
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.4323D-03, 0.5138D-03,
     >    0.6270D-03, 0.7996D-03, 0.9331D-03, 0.1128D-02, 0.1413D-02,
     >    0.1683D-02, 0.2046D-02, 0.2457D-02, 0.2961D-02, 0.3609D-02,
     >    0.4386D-02, 0.5294D-02, 0.6434D-02, 0.7763D-02, 0.9365D-02,
     >    0.1136D-01, 0.1370D-01, 0.1657D-01, 0.2004D-01, 0.2424D-01,
     >    0.2932D-01, 0.3548D-01, 0.4293D-01, 0.5192D-01, 0.6267D-01,
     >    0.7534D-01, 0.8988D-01, 0.1058D+00, 0.1217D+00, 0.1351D+00,
     >    0.1421D+00, 0.1379D+00, 0.1184D+00, 0.8306D-01, 0.3588D-01,
     >    -.1530D-01, -.6227D-01, -.9944D-01, -.1244D+00, -.1372D+00,
     >    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9476D-01,
     >    -.8013D-01, -.6655D-01, -.5451D-01, -.4402D-01, -.3519D-01,
     >    -.2786D-01, -.2194D-01, -.1711D-01, -.1324D-01, -.1021D-01,
     >    -.7860D-02, -.6008D-02, -.4529D-02, -.3433D-02, -.2592D-02,
     >    -.1943D-02, -.1488D-02, -.1096D-02, -.8350D-03, -.6387D-03,
     >    -.4413D-03, -.3097D-03, -.2442D-03, -.1783D-03, -.1122D-03,
     >    -.1126D-03/

      data (calcpts(j, 2), j = 1,neta) /0.4112D-03, 0.5596D-03,
     >    0.6731D-03, 0.7794D-03, 0.9800D-03, 0.1176D-02, 0.1394D-02,
     >    0.1665D-02, 0.2028D-02, 0.2507D-02, 0.3011D-02, 0.3593D-02,
     >    0.4371D-02, 0.5280D-02, 0.6421D-02, 0.7751D-02, 0.9354D-02,
     >    0.1135D-01, 0.1370D-01, 0.1656D-01, 0.2004D-01, 0.2424D-01,
     >    0.2932D-01, 0.3547D-01, 0.4293D-01, 0.5191D-01, 0.6265D-01,
     >    0.7532D-01, 0.8986D-01, 0.1057D+00, 0.1217D+00, 0.1351D+00,
     >    0.1421D+00, 0.1379D+00, 0.1184D+00, 0.8304D-01, 0.3587D-01,
     >    -.1531D-01, -.6227D-01, -.9945D-01, -.1244D+00, -.1372D+00,
     >    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9475D-01,
     >    -.8011D-01, -.6660D-01, -.5450D-01, -.4401D-01, -.3518D-01,
     >    -.2791D-01, -.2193D-01, -.1710D-01, -.1329D-01, -.1019D-01,
     >    -.7845D-02, -.5992D-02, -.4581D-02, -.3485D-02, -.2577D-02,
     >    -.1927D-02, -.1473D-02, -.1081D-02, -.8195D-03, -.6233D-03,
     >    -.4258D-03, -.3609D-03, -.2288D-03, -.1629D-03, -.1634D-03,
     >    -.9715D-04/

      data (calcpts(j, 3), j = 1,neta) /0.4469D-03, 0.5291D-03,
     >    0.6430D-03, 0.8165D-03, 0.9509D-03, 0.1147D-02, 0.1366D-02,
     >    0.1705D-02, 0.2069D-02, 0.2482D-02, 0.2987D-02, 0.3637D-02,
     >    0.4350D-02, 0.5326D-02, 0.6402D-02, 0.7734D-02, 0.9338D-02,
     >    0.1133D-01, 0.1370D-01, 0.1656D-01, 0.2003D-01, 0.2423D-01,
     >    0.2931D-01, 0.3547D-01, 0.4292D-01, 0.5190D-01, 0.6264D-01,
     >    0.7531D-01, 0.8984D-01, 0.1057D+00, 0.1216D+00, 0.1351D+00,
     >    0.1420D+00, 0.1378D+00, 0.1184D+00, 0.8300D-01, 0.3585D-01,
     >    -.1532D-01, -.6227D-01, -.9944D-01, -.1244D+00, -.1372D+00,
     >    -.1396D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9473D-01,
     >    -.8016D-01, -.6658D-01, -.5447D-01, -.4405D-01, -.3522D-01,
     >    -.2789D-01, -.2190D-01, -.1708D-01, -.1326D-01, -.1024D-01,
     >    -.7822D-02, -.5970D-02, -.4558D-02, -.3462D-02, -.2621D-02,
     >    -.1972D-02, -.1450D-02, -.1125D-02, -.7969D-03, -.6007D-03,
     >    -.4699D-03, -.3383D-03, -.2728D-03, -.2069D-03, -.1408D-03,
     >    -.7452D-04/

      data (calcpts(j, 4), j = 1,neta) /0.4681D-03, 0.5509D-03,
     >    0.6654D-03, 0.7730D-03, 0.9749D-03, 0.1172D-02, 0.1392D-02,
     >    0.1665D-02, 0.2031D-02, 0.2445D-02, 0.3018D-02, 0.3603D-02,
     >    0.4384D-02, 0.5296D-02, 0.6441D-02, 0.7775D-02, 0.9382D-02,
     >    0.1131D-01, 0.1370D-01, 0.1656D-01, 0.2003D-01, 0.2422D-01,
     >    0.2930D-01, 0.3546D-01, 0.4290D-01, 0.5188D-01, 0.6262D-01,
     >    0.7528D-01, 0.8980D-01, 0.1057D+00, 0.1216D+00, 0.1350D+00,
     >    0.1420D+00, 0.1378D+00, 0.1183D+00, 0.8296D-01, 0.3582D-01,
     >    -.1534D-01, -.6228D-01, -.9945D-01, -.1244D+00, -.1372D+00,
     >    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9477D-01,
     >    -.8013D-01, -.6655D-01, -.5451D-01, -.4402D-01, -.3519D-01,
     >    -.2786D-01, -.2194D-01, -.1711D-01, -.1323D-01, -.1020D-01,
     >    -.7856D-02, -.6003D-02, -.4525D-02, -.3429D-02, -.2588D-02,
     >    -.1938D-02, -.1483D-02, -.1092D-02, -.8303D-03, -.6341D-03,
     >    -.4366D-03, -.3050D-03, -.2395D-03, -.1737D-03, -.1076D-03,
     >    -.1079D-03/

      data (calcpts(j, 5), j = 1,neta) /0.4681D-03, 0.5517D-03,
     >    0.6672D-03, 0.7759D-03, 0.9790D-03, 0.1178D-02, 0.1399D-02,
     >    0.1674D-02, 0.2041D-02, 0.2457D-02, 0.2967D-02, 0.3621D-02,
     >    0.4405D-02, 0.5319D-02, 0.6400D-02, 0.7738D-02, 0.9348D-02,
     >    0.1135D-01, 0.1369D-01, 0.1655D-01, 0.2002D-01, 0.2421D-01,
     >    0.2928D-01, 0.3544D-01, 0.4288D-01, 0.5185D-01, 0.6259D-01,
     >    0.7523D-01, 0.8975D-01, 0.1056D+00, 0.1215D+00, 0.1349D+00,
     >    0.1419D+00, 0.1377D+00, 0.1182D+00, 0.8289D-01, 0.3577D-01,
     >    -.1536D-01, -.6229D-01, -.9945D-01, -.1244D+00, -.1371D+00,
     >    -.1396D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9472D-01,
     >    -.8015D-01, -.6657D-01, -.5446D-01, -.4404D-01, -.3521D-01,
     >    -.2788D-01, -.2189D-01, -.1713D-01, -.1325D-01, -.1022D-01,
     >    -.7874D-02, -.6021D-02, -.4543D-02, -.3447D-02, -.2605D-02,
     >    -.1956D-02, -.1501D-02, -.1109D-02, -.8482D-03, -.5853D-03,
     >    -.4545D-03, -.3229D-03, -.2574D-03, -.1916D-03, -.1254D-03,
     >    -.1258D-03/

      data (calcpts(j, 6), j = 1,neta) /0.4370D-03, 0.5219D-03,
     >    0.6388D-03, 0.8157D-03, 0.9540D-03, 0.1155D-02, 0.1379D-02,
     >    0.1656D-02, 0.2026D-02, 0.2445D-02, 0.2957D-02, 0.3615D-02,
     >    0.4403D-02, 0.5255D-02, 0.6408D-02, 0.7750D-02, 0.9365D-02,
     >    0.1130D-01, 0.1368D-01, 0.1653D-01, 0.2000D-01, 0.2419D-01,
     >    0.2926D-01, 0.3541D-01, 0.4285D-01, 0.5181D-01, 0.6253D-01,
     >    0.7518D-01, 0.8967D-01, 0.1055D+00, 0.1214D+00, 0.1348D+00,
     >    0.1418D+00, 0.1375D+00, 0.1181D+00, 0.8279D-01, 0.3571D-01,
     >    -.1540D-01, -.6231D-01, -.9945D-01, -.1244D+00, -.1371D+00,
     >    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9473D-01,
     >    -.8015D-01, -.6657D-01, -.5446D-01, -.4403D-01, -.3520D-01,
     >    -.2787D-01, -.2188D-01, -.1712D-01, -.1324D-01, -.1022D-01,
     >    -.7869D-02, -.6016D-02, -.4538D-02, -.3442D-02, -.2601D-02,
     >    -.1951D-02, -.1496D-02, -.1105D-02, -.8434D-03, -.5804D-03,
     >    -.4497D-03, -.3181D-03, -.2526D-03, -.1867D-03, -.1206D-03,
     >    -.1210D-03/

      data (calcpts(j, 7), j = 1,neta) /0.4271D-03, 0.5137D-03,
     >    0.6327D-03, 0.8119D-03, 0.9528D-03, 0.1156D-02, 0.1384D-02,
     >    0.1664D-02, 0.2038D-02, 0.2462D-02, 0.2979D-02, 0.3643D-02,
     >    0.4369D-02, 0.5295D-02, 0.6387D-02, 0.7736D-02, 0.9359D-02,
     >    0.1131D-01, 0.1367D-01, 0.1652D-01, 0.1998D-01, 0.2417D-01,
     >    0.2923D-01, 0.3537D-01, 0.4280D-01, 0.5175D-01, 0.6246D-01,
     >    0.7509D-01, 0.8956D-01, 0.1054D+00, 0.1212D+00, 0.1346D+00,
     >    0.1415D+00, 0.1373D+00, 0.1179D+00, 0.8265D-01, 0.3561D-01,
     >    -.1546D-01, -.6233D-01, -.9945D-01, -.1243D+00, -.1371D+00,
     >    -.1395D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9470D-01,
     >    -.8012D-01, -.6654D-01, -.5449D-01, -.4400D-01, -.3517D-01,
     >    -.2790D-01, -.2191D-01, -.1709D-01, -.1327D-01, -.1025D-01,
     >    -.7831D-02, -.5978D-02, -.4566D-02, -.3470D-02, -.2629D-02,
     >    -.1980D-02, -.1458D-02, -.1066D-02, -.8051D-03, -.6089D-03,
     >    -.4781D-03, -.3465D-03, -.6143D-03, -.1485D-03, -.1490D-03,
     >    -.8274D-04/

      data (calcpts(j, 8), j = 1,neta) /0.4171D-03, 0.5064D-03,
     >    0.6284D-03, 0.8110D-03, 0.9558D-03, 0.1164D-02, 0.1396D-02,
     >    0.1682D-02, 0.2062D-02, 0.2492D-02, 0.2950D-02, 0.3621D-02,
     >    0.4356D-02, 0.5291D-02, 0.6392D-02, 0.7752D-02, 0.9319D-02,
     >    0.1128D-01, 0.1365D-01, 0.1650D-01, 0.1995D-01, 0.2413D-01,
     >    0.2919D-01, 0.3531D-01, 0.4273D-01, 0.5167D-01, 0.6235D-01,
     >    0.7495D-01, 0.8940D-01, 0.1052D+00, 0.1210D+00, 0.1343D+00,
     >    0.1413D+00, 0.1370D+00, 0.1177D+00, 0.8245D-01, 0.3546D-01,
     >    -.1554D-01, -.6236D-01, -.9945D-01, -.1243D+00, -.1371D+00,
     >    -.1395D+00, -.1340D+00, -.1232D+00, -.1095D+00, -.9470D-01,
     >    -.8011D-01, -.6653D-01, -.5448D-01, -.4398D-01, -.3522D-01,
     >    -.2788D-01, -.2189D-01, -.1707D-01, -.1325D-01, -.1023D-01,
     >    -.7811D-02, -.6025D-02, -.4546D-02, -.3450D-02, -.2609D-02,
     >    -.1959D-02, -.1438D-02, -.1113D-02, -.7847D-03, -.5884D-03,
     >    -.4576D-03, -.3260D-03, -.2605D-03, -.1947D-03, -.1285D-03,
     >    -.1289D-03/

      data (calcpts(j, 9), j = 1,neta) /0.4435D-03, 0.5367D-03,
     >    0.6631D-03, 0.7841D-03, 0.9344D-03, 0.1148D-02, 0.1388D-02,
     >    0.1681D-02, 0.2003D-02, 0.2443D-02, 0.2978D-02, 0.3594D-02,
     >    0.4342D-02, 0.5289D-02, 0.6406D-02, 0.7714D-02, 0.9296D-02,
     >    0.1127D-01, 0.1362D-01, 0.1646D-01, 0.1991D-01, 0.2407D-01,
     >    0.2912D-01, 0.3524D-01, 0.4263D-01, 0.5155D-01, 0.6220D-01,
     >    0.7476D-01, 0.8916D-01, 0.1049D+00, 0.1206D+00, 0.1339D+00,
     >    0.1408D+00, 0.1366D+00, 0.1173D+00, 0.8214D-01, 0.3525D-01,
     >    -.1566D-01, -.6242D-01, -.9946D-01, -.1243D+00, -.1371D+00,
     >    -.1395D+00, -.1340D+00, -.1232D+00, -.1095D+00, -.9470D-01,
     >    -.8011D-01, -.6651D-01, -.5446D-01, -.4403D-01, -.3520D-01,
     >    -.2786D-01, -.2194D-01, -.1711D-01, -.1323D-01, -.1020D-01,
     >    -.7853D-02, -.6000D-02, -.4521D-02, -.3425D-02, -.2584D-02,
     >    -.1934D-02, -.1480D-02, -.1088D-02, -.8263D-03, -.6301D-03,
     >    -.4326D-03, -.3010D-03, -.2355D-03, -.1696D-03, -.1035D-03,
     >    -.1039D-03/

      data (calcpts(j,10), j = 1,neta) /0.4611D-03, 0.4933D-03,
     >    0.6262D-03, 0.7544D-03, 0.9129D-03, 0.1136D-02, 0.1386D-02,
     >    0.1691D-02, 0.2025D-02, 0.2479D-02, 0.2963D-02, 0.3595D-02,
     >    0.4361D-02, 0.5262D-02, 0.6332D-02, 0.7662D-02, 0.9268D-02,
     >    0.1120D-01, 0.1357D-01, 0.1641D-01, 0.1984D-01, 0.2399D-01,
     >    0.2902D-01, 0.3512D-01, 0.4249D-01, 0.5136D-01, 0.6198D-01,
     >    0.7448D-01, 0.8881D-01, 0.1045D+00, 0.1201D+00, 0.1333D+00,
     >    0.1402D+00, 0.1360D+00, 0.1167D+00, 0.8169D-01, 0.3495D-01,
     >    -.1584D-01, -.6249D-01, -.9946D-01, -.1243D+00, -.1370D+00,
     >    -.1394D+00, -.1339D+00, -.1231D+00, -.1095D+00, -.9468D-01,
     >    -.8007D-01, -.6653D-01, -.5441D-01, -.4398D-01, -.3521D-01,
     >    -.2787D-01, -.2188D-01, -.1711D-01, -.1323D-01, -.1021D-01,
     >    -.7857D-02, -.6004D-02, -.4525D-02, -.3429D-02, -.2588D-02,
     >    -.1938D-02, -.1483D-02, -.1091D-02, -.8300D-03, -.6337D-03,
     >    -.4363D-03, -.3047D-03, -.2392D-03, -.1733D-03, -.1072D-03,
     >    -.1076D-03/

      data (calcpts(j,11), j = 1,neta) /0.4058D-03, 0.5130D-03,
     >    0.6553D-03, 0.7941D-03, 0.9646D-03, 0.1135D-02, 0.1399D-02,
     >    0.1654D-02, 0.2007D-02, 0.2415D-02, 0.2921D-02, 0.3578D-02,
     >    0.4303D-02, 0.5233D-02, 0.6333D-02, 0.7629D-02, 0.9268D-02,
     >    0.1117D-01, 0.1351D-01, 0.1632D-01, 0.1975D-01, 0.2388D-01,
     >    0.2888D-01, 0.3494D-01, 0.4227D-01, 0.5110D-01, 0.6164D-01,
     >    0.7406D-01, 0.8831D-01, 0.1038D+00, 0.1194D+00, 0.1325D+00,
     >    0.1393D+00, 0.1350D+00, 0.1159D+00, 0.8103D-01, 0.3450D-01,
     >    -.1609D-01, -.6259D-01, -.9947D-01, -.1242D+00, -.1369D+00,
     >    -.1393D+00, -.1339D+00, -.1231D+00, -.1094D+00, -.9458D-01,
     >    -.8003D-01, -.6648D-01, -.5441D-01, -.4397D-01, -.3513D-01,
     >    -.2786D-01, -.2187D-01, -.1710D-01, -.1322D-01, -.1019D-01,
     >    -.7843D-02, -.5989D-02, -.4577D-02, -.3481D-02, -.2572D-02,
     >    -.1990D-02, -.1468D-02, -.1076D-02, -.8148D-03, -.6185D-03,
     >    -.4210D-03, -.3561D-03, -.2239D-03, -.1580D-03, -.1586D-03,
     >    -.9227D-04/

      data (calcpts(j,12), j = 1,neta) /0.4531D-03, 0.5058D-03,
     >    0.6618D-03, 0.7494D-03, 0.9372D-03, 0.1127D-02, 0.1346D-02,
     >    0.1625D-02, 0.2005D-02, 0.2442D-02, 0.2914D-02, 0.3540D-02,
     >    0.4304D-02, 0.5208D-02, 0.6287D-02, 0.7563D-02, 0.9184D-02,
     >    0.1107D-01, 0.1341D-01, 0.1621D-01, 0.1961D-01, 0.2371D-01,
     >    0.2867D-01, 0.3469D-01, 0.4195D-01, 0.5071D-01, 0.6116D-01,
     >    0.7347D-01, 0.8757D-01, 0.1029D+00, 0.1183D+00, 0.1313D+00,
     >    0.1379D+00, 0.1337D+00, 0.1147D+00, 0.8008D-01, 0.3385D-01,
     >    -.1646D-01, -.6275D-01, -.9949D-01, -.1242D+00, -.1368D+00,
     >    -.1392D+00, -.1337D+00, -.1230D+00, -.1093D+00, -.9456D-01,
     >    -.7998D-01, -.6642D-01, -.5441D-01, -.4396D-01, -.3518D-01,
     >    -.2783D-01, -.2190D-01, -.1707D-01, -.1325D-01, -.1022D-01,
     >    -.7808D-02, -.5954D-02, -.4542D-02, -.3445D-02, -.2604D-02,
     >    -.1954D-02, -.1499D-02, -.1107D-02, -.8456D-03, -.5826D-03,
     >    -.4518D-03, -.3202D-03, -.2547D-03, -.1888D-03, -.1227D-03,
     >    -.1231D-03/

      data (calcpts(j,13), j = 1,neta) /0.4062D-03, 0.5431D-03,
     >    0.6522D-03, 0.7622D-03, 0.9086D-03, 0.1126D-02, 0.1377D-02,
     >    0.1625D-02, 0.1977D-02, 0.2390D-02, 0.2910D-02, 0.3520D-02,
     >    0.4273D-02, 0.5104D-02, 0.6247D-02, 0.7524D-02, 0.9082D-02,
     >    0.1098D-01, 0.1327D-01, 0.1605D-01, 0.1941D-01, 0.2347D-01,
     >    0.2837D-01, 0.3432D-01, 0.4151D-01, 0.5015D-01, 0.6047D-01,
     >    0.7261D-01, 0.8651D-01, 0.1017D+00, 0.1168D+00, 0.1295D+00,
     >    0.1360D+00, 0.1318D+00, 0.1130D+00, 0.7871D-01, 0.3290D-01,
     >    -.1700D-01, -.6298D-01, -.9950D-01, -.1241D+00, -.1367D+00,
     >    -.1390D+00, -.1336D+00, -.1228D+00, -.1092D+00, -.9446D-01,
     >    -.7991D-01, -.6638D-01, -.5436D-01, -.4389D-01, -.3511D-01,
     >    -.2782D-01, -.2189D-01, -.1705D-01, -.1324D-01, -.1021D-01,
     >    -.7855D-02, -.6000D-02, -.4521D-02, -.3424D-02, -.2582D-02,
     >    -.1932D-02, -.1477D-02, -.1085D-02, -.8239D-03, -.6275D-03,
     >    -.4300D-03, -.3650D-03, -.2329D-03, -.1670D-03, -.1009D-03,
     >    -.1012D-03/

      data (calcpts(j,14), j = 1,neta) /0.4179D-03, 0.5134D-03,
     >    0.5844D-03, 0.7266D-03, 0.9092D-03, 0.1101D-02, 0.1331D-02,
     >    0.1629D-02, 0.1970D-02, 0.2379D-02, 0.2833D-02, 0.3451D-02,
     >    0.4151D-02, 0.5069D-02, 0.6103D-02, 0.7411D-02, 0.8938D-02,
     >    0.1082D-01, 0.1308D-01, 0.1581D-01, 0.1912D-01, 0.2311D-01,
     >    0.2795D-01, 0.3380D-01, 0.4086D-01, 0.4935D-01, 0.5947D-01,
     >    0.7138D-01, 0.8499D-01, 0.9979D-01, 0.1146D+00, 0.1270D+00,
     >    0.1333D+00, 0.1290D+00, 0.1105D+00, 0.7672D-01, 0.3154D-01,
     >    -.1778D-01, -.6329D-01, -.9952D-01, -.1239D+00, -.1364D+00,
     >    -.1388D+00, -.1333D+00, -.1226D+00, -.1090D+00, -.9429D-01,
     >    -.7975D-01, -.6632D-01, -.5426D-01, -.4385D-01, -.3505D-01,
     >    -.2783D-01, -.2182D-01, -.1705D-01, -.1323D-01, -.1020D-01,
     >    -.7844D-02, -.5988D-02, -.4575D-02, -.3478D-02, -.2569D-02,
     >    -.1986D-02, -.1464D-02, -.1072D-02, -.8103D-03, -.6139D-03,
     >    -.4831D-03, -.3514D-03, -.2192D-03, -.1533D-03, -.1539D-03,
     >    -.8758D-04/

      data (calcpts(j,15), j = 1,neta) /0.3832D-03, 0.5148D-03,
     >    0.6265D-03, 0.7480D-03, 0.9156D-03, 0.1099D-02, 0.1326D-02,
     >    0.1563D-02, 0.1918D-02, 0.2281D-02, 0.2765D-02, 0.3356D-02,
     >    0.4104D-02, 0.4945D-02, 0.5978D-02, 0.7226D-02, 0.8765D-02,
     >    0.1059D-01, 0.1280D-01, 0.1547D-01, 0.1871D-01, 0.2261D-01,
     >    0.2733D-01, 0.3305D-01, 0.3994D-01, 0.4821D-01, 0.5807D-01,
     >    0.6963D-01, 0.8283D-01, 0.9717D-01, 0.1114D+00, 0.1234D+00,
     >    0.1294D+00, 0.1251D+00, 0.1069D+00, 0.7389D-01, 0.2959D-01,
     >    -.1888D-01, -.6375D-01, -.9952D-01, -.1236D+00, -.1361D+00,
     >    -.1384D+00, -.1330D+00, -.1223D+00, -.1087D+00, -.9407D-01,
     >    -.7959D-01, -.6617D-01, -.5415D-01, -.4378D-01, -.3503D-01,
     >    -.2772D-01, -.2184D-01, -.1700D-01, -.1317D-01, -.1021D-01,
     >    -.7786D-02, -.5996D-02, -.4515D-02, -.3418D-02, -.2575D-02,
     >    -.1925D-02, -.1470D-02, -.1077D-02, -.8160D-03, -.6195D-03,
     >    -.4219D-03, -.3569D-03, -.2247D-03, -.1588D-03, -.1594D-03,
     >    -.9305D-04/

      data (calcpts(j,16), j = 1,neta) /0.3814D-03, 0.4972D-03,
     >    0.5997D-03, 0.7195D-03, 0.8268D-03, 0.1025D-02, 0.1277D-02,
     >    0.1550D-02, 0.1884D-02, 0.2238D-02, 0.2726D-02, 0.3265D-02,
     >    0.3976D-02, 0.4791D-02, 0.5810D-02, 0.7055D-02, 0.8466D-02,
     >    0.1027D-01, 0.1241D-01, 0.1500D-01, 0.1813D-01, 0.2191D-01,
     >    0.2647D-01, 0.3199D-01, 0.3864D-01, 0.4661D-01, 0.5610D-01,
     >    0.6719D-01, 0.7983D-01, 0.9351D-01, 0.1071D+00, 0.1184D+00,
     >    0.1239D+00, 0.1197D+00, 0.1020D+00, 0.6990D-01, 0.2683D-01,
     >    -.2045D-01, -.6437D-01, -.9952D-01, -.1233D+00, -.1355D+00,
     >    -.1378D+00, -.1324D+00, -.1218D+00, -.1083D+00, -.9371D-01,
     >    -.7932D-01, -.6596D-01, -.5402D-01, -.4368D-01, -.3491D-01,
     >    -.2772D-01, -.2176D-01, -.1698D-01, -.1321D-01, -.1018D-01,
     >    -.7819D-02, -.5961D-02, -.4545D-02, -.3447D-02, -.2604D-02,
     >    -.1953D-02, -.1431D-02, -.1105D-02, -.8437D-03, -.5805D-03,
     >    -.4495D-03, -.3178D-03, -.2523D-03, -.1863D-03, -.1202D-03,
     >    -.1205D-03/

      data (calcpts(j,17), j = 1,neta) /0.3666D-03, 0.4863D-03,
     >    0.5352D-03, 0.6784D-03, 0.8203D-03, 0.9984D-03, 0.1178D-02,
     >    0.1458D-02, 0.1748D-02, 0.2142D-02, 0.2619D-02, 0.3166D-02,
     >    0.3768D-02, 0.4559D-02, 0.5569D-02, 0.6687D-02, 0.8117D-02,
     >    0.9818D-02, 0.1186D-01, 0.1434D-01, 0.1733D-01, 0.2093D-01,
     >    0.2528D-01, 0.3053D-01, 0.3685D-01, 0.4441D-01, 0.5339D-01,
     >    0.6385D-01, 0.7572D-01, 0.8853D-01, 0.1012D+00, 0.1116D+00,
     >    0.1165D+00, 0.1122D+00, 0.9512D-01, 0.6438D-01, 0.2300D-01,
     >    -.2262D-01, -.6522D-01, -.9947D-01, -.1227D+00, -.1347D+00,
     >    -.1370D+00, -.1316D+00, -.1211D+00, -.1077D+00, -.9331D-01,
     >    -.7897D-01, -.6564D-01, -.5376D-01, -.4350D-01, -.3483D-01,
     >    -.2762D-01, -.2171D-01, -.1692D-01, -.1315D-01, -.1017D-01,
     >    -.7809D-02, -.5949D-02, -.4532D-02, -.3432D-02, -.2588D-02,
     >    -.1938D-02, -.1482D-02, -.1089D-02, -.8271D-03, -.6305D-03,
     >    -.4328D-03, -.3010D-03, -.2354D-03, -.1695D-03, -.1033D-03,
     >    -.1037D-03/

      data (calcpts(j,18), j = 1,neta) /0.3296D-03, 0.4115D-03,
     >    0.5016D-03, 0.6332D-03, 0.7788D-03, 0.9104D-03, 0.1128D-02,
     >    0.1399D-02, 0.1634D-02, 0.1996D-02, 0.2463D-02, 0.2957D-02,
     >    0.3596D-02, 0.4314D-02, 0.5208D-02, 0.6295D-02, 0.7644D-02,
     >    0.9209D-02, 0.1113D-01, 0.1344D-01, 0.1625D-01, 0.1962D-01,
     >    0.2368D-01, 0.2858D-01, 0.3446D-01, 0.4148D-01, 0.4977D-01,
     >    0.5941D-01, 0.7029D-01, 0.8195D-01, 0.9335D-01, 0.1026D+00,
     >    0.1068D+00, 0.1023D+00, 0.8599D-01, 0.5694D-01, 0.1780D-01,
     >    -.2557D-01, -.6633D-01, -.9933D-01, -.1218D+00, -.1335D+00,
     >    -.1357D+00, -.1305D+00, -.1201D+00, -.1069D+00, -.9263D-01,
     >    -.7842D-01, -.6529D-01, -.5351D-01, -.4325D-01, -.3460D-01,
     >    -.2749D-01, -.2163D-01, -.1689D-01, -.1311D-01, -.1012D-01,
     >    -.7758D-02, -.5895D-02, -.4542D-02, -.3441D-02, -.2596D-02,
     >    -.1945D-02, -.1488D-02, -.1095D-02, -.8333D-03, -.6366D-03,
     >    -.4388D-03, -.3069D-03, -.2413D-03, -.1753D-03, -.1091D-03,
     >    -.1095D-03/

      data (calcpts(j,19), j = 1,neta) /0.2951D-03, 0.3689D-03,
     >    0.4670D-03, 0.5583D-03, 0.6835D-03, 0.8831D-03, 0.1059D-02,
     >    0.1247D-02, 0.1494D-02, 0.1828D-02, 0.2232D-02, 0.2694D-02,
     >    0.3265D-02, 0.3947D-02, 0.4766D-02, 0.5738D-02, 0.6961D-02,
     >    0.8415D-02, 0.1017D-01, 0.1228D-01, 0.1484D-01, 0.1791D-01,
     >    0.2160D-01, 0.2605D-01, 0.3136D-01, 0.3769D-01, 0.4513D-01,
     >    0.5373D-01, 0.6336D-01, 0.7359D-01, 0.8345D-01, 0.9125D-01,
     >    0.9436D-01, 0.8964D-01, 0.7425D-01, 0.4728D-01, 0.1099D-01,
     >    -.2944D-01, -.6772D-01, -.9898D-01, -.1205D+00, -.1318D+00,
     >    -.1339D+00, -.1288D+00, -.1187D+00, -.1057D+00, -.9161D-01,
     >    -.7767D-01, -.6468D-01, -.5304D-01, -.4296D-01, -.3438D-01,
     >    -.2730D-01, -.2148D-01, -.1678D-01, -.1305D-01, -.1006D-01,
     >    -.7689D-02, -.5888D-02, -.4466D-02, -.3430D-02, -.2584D-02,
     >    -.1931D-02, -.1474D-02, -.1081D-02, -.8188D-03, -.6218D-03,
     >    -.4239D-03, -.3586D-03, -.2263D-03, -.1602D-03, -.1607D-03,
     >    -.9433D-04/

      data (calcpts(j,20), j = 1,neta) /0.2649D-03, 0.3628D-03,
     >    0.4389D-03, 0.5311D-03, 0.6156D-03, 0.7351D-03, 0.9273D-03,
     >    0.1098D-02, 0.1360D-02, 0.1614D-02, 0.1975D-02, 0.2366D-02,
     >    0.2840D-02, 0.3463D-02, 0.4193D-02, 0.5110D-02, 0.6146D-02,
     >    0.7424D-02, 0.8974D-02, 0.1083D-01, 0.1308D-01, 0.1578D-01,
     >    0.1902D-01, 0.2290D-01, 0.2754D-01, 0.3302D-01, 0.3944D-01,
     >    0.4679D-01, 0.5495D-01, 0.6349D-01, 0.7155D-01, 0.7762D-01,
     >    0.7945D-01, 0.7436D-01, 0.5992D-01, 0.3533D-01, 0.2460D-02,
     >    -.3427D-01, -.6935D-01, -.9831D-01, -.1185D+00, -.1292D+00,
     >    -.1312D+00, -.1263D+00, -.1166D+00, -.1040D+00, -.9026D-01,
     >    -.7664D-01, -.6388D-01, -.5242D-01, -.4250D-01, -.3404D-01,
     >    -.2704D-01, -.2125D-01, -.1666D-01, -.1292D-01, -.9981D-02,
     >    -.7669D-02, -.5863D-02, -.4437D-02, -.3399D-02, -.2551D-02,
     >    -.1897D-02, -.1440D-02, -.1046D-02, -.7831D-03, -.5859D-03,
     >    -.4545D-03, -.3224D-03, -.2566D-03, -.1906D-03, -.1243D-03,
     >    -.1246D-03/

      data (calcpts(j,21), j = 1,neta) /0.2746D-03, 0.2937D-03,
     >    0.3818D-03, 0.4467D-03, 0.5340D-03, 0.6221D-03, 0.7518D-03,
     >    0.9649D-03, 0.1110D-02, 0.1358D-02, 0.1692D-02, 0.2035D-02,
     >    0.2442D-02, 0.2911D-02, 0.3557D-02, 0.4292D-02, 0.5185D-02,
     >    0.6263D-02, 0.7562D-02, 0.9125D-02, 0.1101D-01, 0.1327D-01,
     >    0.1598D-01, 0.1921D-01, 0.2306D-01, 0.2759D-01, 0.3285D-01,
     >    0.3881D-01, 0.4535D-01, 0.5204D-01, 0.5812D-01, 0.6231D-01,
     >    0.6271D-01, 0.5712D-01, 0.4360D-01, 0.2153D-01, -.7528D-02,
     >    -.3993D-01, -.7107D-01, -.9708D-01, -.1155D+00, -.1254D+00,
     >    -.1274D+00, -.1229D+00, -.1137D+00, -.1016D+00, -.8842D-01,
     >    -.7514D-01, -.6277D-01, -.5157D-01, -.4185D-01, -.3357D-01,
     >    -.2671D-01, -.2101D-01, -.1646D-01, -.1276D-01, -.9880D-02,
     >    -.7626D-02, -.5813D-02, -.4450D-02, -.3342D-02, -.2559D-02,
     >    -.1904D-02, -.1445D-02, -.1051D-02, -.7878D-03, -.5903D-03,
     >    -.4587D-03, -.3265D-03, -.2606D-03, -.1945D-03, -.1282D-03,
     >    -.1284D-03/

      data (calcpts(j,22), j = 1,neta) /0.2248D-03, 0.2547D-03,
     >    0.3143D-03, 0.3815D-03, 0.4381D-03, 0.5321D-03, 0.6410D-03,
     >    0.7432D-03, 0.8898D-03, 0.1121D-02, 0.1291D-02, 0.1588D-02,
     >    0.1936D-02, 0.2333D-02, 0.2822D-02, 0.3406D-02, 0.4113D-02,
     >    0.4971D-02, 0.5996D-02, 0.7237D-02, 0.8724D-02, 0.1050D-01,
     >    0.1263D-01, 0.1517D-01, 0.1817D-01, 0.2168D-01, 0.2572D-01,
     >    0.3025D-01, 0.3511D-01, 0.3993D-01, 0.4403D-01, 0.4633D-01,
     >    0.4529D-01, 0.3915D-01, 0.2645D-01, 0.6839D-02, -.1830D-01,
     >    -.4602D-01, -.7264D-01, -.9510D-01, -.1113D+00, -.1203D+00,
     >    -.1222D+00, -.1182D+00, -.1097D+00, -.9839D-01, -.8586D-01,
     >    -.7318D-01, -.6123D-01, -.5042D-01, -.4101D-01, -.3296D-01,
     >    -.2623D-01, -.2068D-01, -.1623D-01, -.1258D-01, -.9749D-02,
     >    -.7485D-02, -.5732D-02, -.4364D-02, -.3319D-02, -.2534D-02,
     >    -.1877D-02, -.1418D-02, -.1089D-02, -.8255D-03, -.6277D-03,
     >    -.4292D-03, -.2969D-03, -.2309D-03, -.1647D-03, -.1650D-03,
     >    -.9859D-04/

      data (calcpts(j,23), j = 1,neta) /0.1575D-03, 0.1414D-03,
     >    0.1837D-03, 0.2659D-03, 0.3061D-03, 0.3553D-03, 0.4615D-03,
     >    0.5397D-03, 0.6435D-03, 0.7975D-03, 0.9631D-03, 0.1172D-02,
     >    0.1414D-02, 0.1714D-02, 0.2071D-02, 0.2500D-02, 0.3019D-02,
     >    0.3651D-02, 0.4404D-02, 0.5304D-02, 0.6396D-02, 0.7693D-02,
     >    0.9237D-02, 0.1107D-01, 0.1323D-01, 0.1573D-01, 0.1859D-01,
     >    0.2172D-01, 0.2499D-01, 0.2807D-01, 0.3035D-01, 0.3096D-01,
     >    0.2865D-01, 0.2205D-01, 0.1012D-01, -.7229D-02, -.2869D-01,
     >    -.5179D-01, -.7370D-01, -.9219D-01, -.1057D+00, -.1135D+00,
     >    -.1154D+00, -.1120D+00, -.1044D+00, -.9415D-01, -.8249D-01,
     >    -.7063D-01, -.5927D-01, -.4896D-01, -.3987D-01, -.3211D-01,
     >    -.2564D-01, -.2024D-01, -.1589D-01, -.1234D-01, -.9563D-02,
     >    -.7355D-02, -.5661D-02, -.4288D-02, -.3306D-02, -.2452D-02,
     >    -.1861D-02, -.1400D-02, -.1070D-02, -.8064D-03, -.6082D-03,
     >    -.4095D-03, -.3437D-03, -.2109D-03, -.1447D-03, -.1449D-03,
     >    -.7844D-04/

      data (calcpts(j,24), j = 1,neta) /0.9565D-04, 0.1144D-03,
     >    0.1394D-03, 0.1691D-03, 0.2046D-03, 0.2465D-03, 0.2996D-03,
     >    0.3624D-03, 0.4374D-03, 0.5335D-03, 0.6405D-03, 0.7778D-03,
     >    0.9370D-03, 0.1136D-02, 0.1376D-02, 0.1657D-02, 0.2002D-02,
     >    0.2416D-02, 0.2906D-02, 0.3499D-02, 0.4216D-02, 0.5063D-02,
     >    0.6065D-02, 0.7252D-02, 0.8636D-02, 0.1023D-01, 0.1200D-01,
     >    0.1390D-01, 0.1578D-01, 0.1735D-01, 0.1812D-01, 0.1736D-01,
     >    0.1409D-01, 0.7257D-02, -.3859D-02, -.1916D-01, -.3737D-01,
     >    -.5634D-01, -.7382D-01, -.8828D-01, -.9890D-01, -.1052D+00,
     >    -.1070D+00, -.1043D+00, -.9787D-01, -.8882D-01, -.7832D-01,
     >    -.6740D-01, -.5686D-01, -.4712D-01, -.3854D-01, -.3114D-01,
     >    -.2486D-01, -.1968D-01, -.1550D-01, -.1206D-01, -.9400D-02,
     >    -.7247D-02, -.5546D-02, -.4235D-02, -.3250D-02, -.2460D-02,
     >    -.1867D-02, -.1405D-02, -.1008D-02, -.8105D-03, -.6120D-03,
     >    -.4130D-03, -.3470D-03, -.2141D-03, -.1478D-03, -.1480D-03,
     >    -.8150D-04/

      data (calcpts(j,25), j = 1,neta) /0.4989D-04, 0.6372D-04,
     >    0.7586D-04, 0.9470D-04, 0.1172D-03, 0.1402D-03, 0.1717D-03,
     >    0.2067D-03, 0.2498D-03, 0.3003D-03, 0.3632D-03, 0.4391D-03,
     >    0.5342D-03, 0.6391D-03, 0.7736D-03, 0.9330D-03, 0.1122D-02,
     >    0.1355D-02, 0.1626D-02, 0.1957D-02, 0.2347D-02, 0.2812D-02,
     >    0.3356D-02, 0.3994D-02, 0.4725D-02, 0.5546D-02, 0.6430D-02,
     >    0.7312D-02, 0.8061D-02, 0.8431D-02, 0.8039D-02, 0.6292D-02,
     >    0.2426D-02, -.4343D-02, -.1454D-01, -.2794D-01, -.4336D-01,
     >    -.5888D-01, -.7259D-01, -.8343D-01, -.9112D-01, -.9571D-01,
     >    -.9709D-01, -.9512D-01, -.9001D-01, -.8241D-01, -.7327D-01,
     >    -.6351D-01, -.5389D-01, -.4489D-01, -.3690D-01, -.2994D-01,
     >    -.2399D-01, -.1903D-01, -.1502D-01, -.1176D-01, -.9151D-02,
     >    -.7055D-02, -.5414D-02, -.4165D-02, -.3177D-02, -.2385D-02,
     >    -.1790D-02, -.1394D-02, -.9966D-03, -.7984D-03, -.5996D-03,
     >    -.4004D-03, -.3342D-03, -.2013D-03, -.2015D-03, -.1350D-03,
     >    -.6850D-04/

      data (calcpts(j,26), j = 1,neta) /0.1907D-04, 0.1918D-04,
     >    0.2593D-04, 0.3718D-04, 0.4555D-04, 0.5013D-04, 0.6176D-04,
     >    0.7818D-04, 0.9929D-04, 0.1208D-03, 0.1428D-03, 0.1736D-03,
     >    0.2073D-03, 0.2545D-03, 0.3059D-03, 0.3685D-03, 0.4413D-03,
     >    0.5237D-03, 0.6323D-03, 0.7488D-03, 0.8974D-03, 0.1060D-02,
     >    0.1249D-02, 0.1461D-02, 0.1691D-02, 0.1922D-02, 0.2125D-02,
     >    0.2235D-02, 0.2139D-02, 0.1643D-02, 0.4357D-03, -.1939D-02,
     >    -.6063D-02, -.1252D-01, -.2168D-01, -.3329D-01, -.4632D-01,
     >    -.5906D-01, -.6983D-01, -.7774D-01, -.8286D-01, -.8565D-01,
     >    -.8639D-01, -.8491D-01, -.8106D-01, -.7502D-01, -.6742D-01,
     >    -.5900D-01, -.5047D-01, -.4236D-01, -.3498D-01, -.2847D-01,
     >    -.2293D-01, -.1833D-01, -.1449D-01, -.1135D-01, -.8859D-02,
     >    -.6821D-02, -.5307D-02, -.4054D-02, -.3063D-02, -.2336D-02,
     >    -.1740D-02, -.1343D-02, -.1012D-02, -.7464D-03, -.5473D-03,
     >    -.4146D-03, -.2817D-03, -.2153D-03, -.1489D-03, -.1490D-03,
     >    -.8244D-04/

      data (calcpts(j,27), j = 1,neta) /0.2006D-05, 0.2856D-05,
     >    0.1167D-05, 0.3743D-05, 0.5087D-05, -.4811D-06, 0.1882D-06,
     >    0.3604D-06, 0.1543D-05, -.4601D-05, -.3152D-05, -.4930D-05,
     >    -.8063D-05, -.1520D-04, -.1737D-04, -.2860D-04, -.4090D-04,
     >    -.5485D-04, -.6813D-04, -.9724D-04, -.1257D-03, -.1702D-03,
     >    -.2322D-03, -.3168D-03, -.4380D-03, -.6165D-03, -.8839D-03,
     >    -.1301D-02, -.1962D-02, -.3024D-02, -.4730D-02, -.7424D-02,
     >    -.1154D-01, -.1752D-01, -.2560D-01, -.3554D-01, -.4649D-01,
     >    -.5701D-01, -.6561D-01, -.7144D-01, -.7456D-01, -.7573D-01,
     >    -.7560D-01, -.7426D-01, -.7142D-01, -.6691D-01, -.6092D-01,
     >    -.5396D-01, -.4665D-01, -.3949D-01, -.3285D-01, -.2693D-01,
     >    -.2181D-01, -.1747D-01, -.1388D-01, -.1092D-01, -.8556D-02,
     >    -.6645D-02, -.5126D-02, -.3936D-02, -.3010D-02, -.2281D-02,
     >    -.1751D-02, -.1286D-02, -.1021D-02, -.7556D-03, -.5563D-03,
     >    -.4235D-03, -.2904D-03, -.2240D-03, -.1575D-03, -.1576D-03,
     >    -.9097D-04/

      data (calcpts(j,28), j = 1,neta) /-.1237D-04, -.1446D-04,
     >    -.1884D-04, -.2362D-04, -.3282D-04, -.3729D-04, -.4875D-04,
     >    -.5886D-04, -.7149D-04, -.8621D-04, -.1070D-03, -.1237D-03,
     >    -.1536D-03, -.1859D-03, -.2326D-03, -.2819D-03, -.3422D-03,
     >    -.4187D-03, -.5150D-03, -.6270D-03, -.7669D-03, -.9413D-03,
     >    -.1158D-02, -.1426D-02, -.1763D-02, -.2192D-02, -.2745D-02,
     >    -.3476D-02, -.4466D-02, -.5839D-02, -.7781D-02, -.1055D-01,
     >    -.1448D-01, -.1986D-01, -.2687D-01, -.3531D-01, -.4447D-01,
     >    -.5320D-01, -.6021D-01, -.6468D-01, -.6654D-01, -.6648D-01,
     >    -.6542D-01, -.6384D-01, -.6161D-01, -.5836D-01, -.5391D-01,
     >    -.4846D-01, -.4244D-01, -.3633D-01, -.3050D-01, -.2519D-01,
     >    -.2053D-01, -.1653D-01, -.1318D-01, -.1042D-01, -.8179D-02,
     >    -.6375D-02, -.4933D-02, -.3800D-02, -.2919D-02, -.2222D-02,
     >    -.1691D-02, -.1279D-02, -.9605D-03, -.7213D-03, -.5418D-03,
     >    -.4088D-03, -.3024D-03, -.2292D-03, -.1693D-03, -.1227D-03,
     >    -.9611D-04/

      data (calcpts(j,29), j = 1,neta) /-.2297D-04, -.2752D-04,
     >    -.3754D-04, -.4311D-04, -.5382D-04, -.5937D-04, -.7678D-04,
     >    -.8971D-04, -.1077D-03, -.1287D-03, -.1558D-03, -.1915D-03,
     >    -.2322D-03, -.2801D-03, -.3415D-03, -.4181D-03, -.5071D-03,
     >    -.6130D-03, -.7460D-03, -.9078D-03, -.1104D-02, -.1346D-02,
     >    -.1642D-02, -.2004D-02, -.2451D-02, -.3006D-02, -.3698D-02,
     >    -.4577D-02, -.5709D-02, -.7193D-02, -.9172D-02, -.1184D-01,
     >    -.1544D-01, -.2018D-01, -.2618D-01, -.3327D-01, -.4091D-01,
     >    -.4818D-01, -.5404D-01, -.5768D-01, -.5890D-01, -.5817D-01,
     >    -.5640D-01, -.5434D-01, -.5225D-01, -.4982D-01, -.4667D-01,
     >    -.4265D-01, -.3795D-01, -.3293D-01, -.2797D-01, -.2331D-01,
     >    -.1914D-01, -.1551D-01, -.1244D-01, -.9882D-02, -.7787D-02,
     >    -.6085D-02, -.4727D-02, -.3652D-02, -.2803D-02, -.2145D-02,
     >    -.1627D-02, -.1235D-02, -.9289D-03, -.6028D-03, -.5232D-03,
     >    -.3901D-03, -.2903D-03, -.2171D-03, -.1572D-03, -.1172D-03,
     >    -.8393D-04/

      data (calcpts(j,30), j = 1,neta) /-.2720D-04, -.2861D-04,
     >    -.3471D-04, -.4794D-04, -.5707D-04, -.6429D-04, -.7893D-04,
     >    -.9699D-04, -.1206D-03, -.1465D-03, -.1769D-03, -.2139D-03,
     >    -.2600D-03, -.3148D-03, -.3814D-03, -.4633D-03, -.5624D-03,
     >    -.6828D-03, -.8292D-03, -.1008D-02, -.1224D-02, -.1489D-02,
     >    -.1811D-02, -.2204D-02, -.2684D-02, -.3275D-02, -.4004D-02,
     >    -.4911D-02, -.6053D-02, -.7509D-02, -.9389D-02, -.1184D-01,
     >    -.1503D-01, -.1911D-01, -.2418D-01, -.3008D-01, -.3642D-01,
     >    -.4249D-01, -.4745D-01, -.5062D-01, -.5165D-01, -.5077D-01,
     >    -.4867D-01, -.4620D-01, -.4390D-01, -.4181D-01, -.3953D-01,
     >    -.3672D-01, -.3327D-01, -.2936D-01, -.2529D-01, -.2133D-01,
     >    -.1768D-01, -.1444D-01, -.1165D-01, -.9313D-02, -.7372D-02,
     >    -.5788D-02, -.4514D-02, -.3498D-02, -.2694D-02, -.2069D-02,
     >    -.1577D-02, -.1198D-02, -.9051D-03, -.6122D-03, -.5125D-03,
     >    -.3860D-03, -.2861D-03, -.2129D-03, -.1596D-03, -.1197D-03,
     >    -.8635D-04/

      data (calcpts(j,31), j = 1,neta) /-.2258D-04, -.3019D-04,
     >    -.3714D-04, -.4516D-04, -.5510D-04, -.6652D-04, -.8066D-04,
     >    -.9812D-04, -.1185D-03, -.1435D-03, -.1744D-03, -.2112D-03,
     >    -.2566D-03, -.3107D-03, -.3767D-03, -.4573D-03, -.5548D-03,
     >    -.6731D-03, -.8174D-03, -.9925D-03, -.1204D-02, -.1462D-02,
     >    -.1777D-02, -.2159D-02, -.2625D-02, -.3194D-02, -.3891D-02,
     >    -.4753D-02, -.5822D-02, -.7163D-02, -.8859D-02, -.1102D-01,
     >    -.1377D-01, -.1723D-01, -.2144D-01, -.2631D-01, -.3153D-01,
     >    -.3657D-01, -.4081D-01, -.4365D-01, -.4473D-01, -.4408D-01,
     >    -.4210D-01, -.3948D-01, -.3692D-01, -.3476D-01, -.3289D-01,
     >    -.3091D-01, -.2852D-01, -.2566D-01, -.2249D-01, -.1924D-01,
     >    -.1614D-01, -.1332D-01, -.1083D-01, -.8710D-02, -.6933D-02,
     >    -.5472D-02, -.4283D-02, -.3333D-02, -.2582D-02, -.1983D-02,
     >    -.1517D-02, -.1158D-02, -.8784D-03, -.6120D-03, -.4989D-03,
     >    -.3724D-03, -.2791D-03, -.2059D-03, -.1526D-03, -.1126D-03,
     >    -.8596D-04/

      data (calcpts(j,32), j = 1,neta) /-.2433D-04, -.2931D-04,
     >    -.3516D-04, -.4244D-04, -.5156D-04, -.6163D-04, -.7470D-04,
     >    -.9082D-04, -.1098D-03, -.1328D-03, -.1611D-03, -.1946D-03,
     >    -.2361D-03, -.2861D-03, -.3465D-03, -.4206D-03, -.5098D-03,
     >    -.6182D-03, -.7499D-03, -.9101D-03, -.1103D-02, -.1340D-02,
     >    -.1626D-02, -.1974D-02, -.2397D-02, -.2912D-02, -.3542D-02,
     >    -.4314D-02, -.5266D-02, -.6446D-02, -.7921D-02, -.9772D-02,
     >    -.1209D-01, -.1496D-01, -.1841D-01, -.2238D-01, -.2663D-01,
     >    -.3079D-01, -.3438D-01, -.3695D-01, -.3815D-01, -.3789D-01,
     >    -.3633D-01, -.3394D-01, -.3131D-01, -.2897D-01, -.2711D-01,
     >    -.2553D-01, -.2389D-01, -.2192D-01, -.1961D-01, -.1709D-01,
     >    -.1455D-01, -.1214D-01, -.9967D-02, -.8077D-02, -.6471D-02,
     >    -.5135D-02, -.4045D-02, -.3161D-02, -.2449D-02, -.1896D-02,
     >    -.1457D-02, -.1111D-02, -.8444D-03, -.6046D-03, -.4781D-03,
     >    -.3582D-03, -.2716D-03, -.1983D-03, -.1450D-03, -.1117D-03,
     >    -.7837D-04/

      data (calcpts(j,33), j = 1,neta) /-.1992D-04, -.2417D-04,
     >    -.2929D-04, -.3614D-04, -.4347D-04, -.5343D-04, -.6432D-04,
     >    -.7849D-04, -.9477D-04, -.1151D-03, -.1399D-03, -.1700D-03,
     >    -.2059D-03, -.2498D-03, -.3031D-03, -.3675D-03, -.4459D-03,
     >    -.5409D-03, -.6558D-03, -.7954D-03, -.9646D-03, -.1171D-02,
     >    -.1420D-02, -.1723D-02, -.2091D-02, -.2539D-02, -.3083D-02,
     >    -.3749D-02, -.4566D-02, -.5572D-02, -.6817D-02, -.8362D-02,
     >    -.1027D-01, -.1262D-01, -.1541D-01, -.1860D-01, -.2204D-01,
     >    -.2544D-01, -.2845D-01, -.3073D-01, -.3201D-01, -.3213D-01,
     >    -.3112D-01, -.2920D-01, -.2681D-01, -.2443D-01, -.2244D-01,
     >    -.2090D-01, -.1963D-01, -.1830D-01, -.1671D-01, -.1488D-01,
     >    -.1290D-01, -.1093D-01, -.9078D-02, -.7432D-02, -.6003D-02,
     >    -.4793D-02, -.3795D-02, -.2984D-02, -.2325D-02, -.1805D-02,
     >    -.1393D-02, -.1066D-02, -.8131D-03, -.5933D-03, -.4667D-03,
     >    -.3535D-03, -.2668D-03, -.2002D-03, -.1469D-03, -.1136D-03,
     >    -.8026D-04/

      data (calcpts(j,34), j = 1,neta) /-.1712D-04, -.2071D-04,
     >    -.2527D-04, -.3077D-04, -.3773D-04, -.4540D-04, -.5514D-04,
     >    -.6700D-04, -.8094D-04, -.9790D-04, -.1186D-03, -.1438D-03,
     >    -.1749D-03, -.2115D-03, -.2566D-03, -.3113D-03, -.3772D-03,
     >    -.4571D-03, -.5546D-03, -.6724D-03, -.8150D-03, -.9890D-03,
     >    -.1199D-02, -.1454D-02, -.1765D-02, -.2141D-02, -.2598D-02,
     >    -.3156D-02, -.3838D-02, -.4672D-02, -.5699D-02, -.6963D-02,
     >    -.8515D-02, -.1040D-01, -.1263D-01, -.1518D-01, -.1792D-01,
     >    -.2066D-01, -.2314D-01, -.2513D-01, -.2639D-01, -.2679D-01,
     >    -.2629D-01, -.2496D-01, -.2303D-01, -.2086D-01, -.1882D-01,
     >    -.1719D-01, -.1597D-01, -.1496D-01, -.1390D-01, -.1265D-01,
     >    -.1121D-01, -.9674D-02, -.8164D-02, -.6756D-02, -.5513D-02,
     >    -.4435D-02, -.3537D-02, -.2791D-02, -.2192D-02, -.1706D-02,
     >    -.1319D-02, -.1013D-02, -.7732D-03, -.5733D-03, -.4467D-03,
     >    -.3401D-03, -.2535D-03, -.1935D-03, -.1402D-03, -.1068D-03,
     >    -.8018D-04/

      data (calcpts(j,35), j = 1,neta) /-.1442D-04, -.1761D-04,
     >    -.2114D-04, -.2543D-04, -.3088D-04, -.3788D-04, -.4561D-04,
     >    -.5524D-04, -.6656D-04, -.8093D-04, -.9821D-04, -.1189D-03,
     >    -.1444D-03, -.1747D-03, -.2120D-03, -.2566D-03, -.3108D-03,
     >    -.3768D-03, -.4572D-03, -.5540D-03, -.6717D-03, -.8145D-03,
     >    -.9876D-03, -.1197D-02, -.1452D-02, -.1761D-02, -.2136D-02,
     >    -.2592D-02, -.3149D-02, -.3828D-02, -.4659D-02, -.5676D-02,
     >    -.6916D-02, -.8412D-02, -.1018D-01, -.1218D-01, -.1435D-01,
     >    -.1653D-01, -.1855D-01, -.2023D-01, -.2142D-01, -.2198D-01,
     >    -.2186D-01, -.2106D-01, -.1968D-01, -.1791D-01, -.1604D-01,
     >    -.1436D-01, -.1306D-01, -.1210D-01, -.1132D-01, -.1049D-01,
     >    -.9515D-02, -.8398D-02, -.7220D-02, -.6068D-02, -.5007D-02,
     >    -.4069D-02, -.3270D-02, -.2598D-02, -.2052D-02, -.1605D-02,
     >    -.1246D-02, -.9591D-03, -.7326D-03, -.5526D-03, -.4260D-03,
     >    -.3261D-03, -.2461D-03, -.1861D-03, -.1395D-03, -.1061D-03,
     >    -.7946D-04/

      data (calcpts(j,36), j = 1,neta) /-.1137D-04, -.1382D-04,
     >    -.1702D-04, -.2062D-04, -.2489D-04, -.3011D-04, -.3664D-04,
     >    -.4486D-04, -.5375D-04, -.6514D-04, -.7944D-04, -.9638D-04,
     >    -.1165D-03, -.1415D-03, -.1711D-03, -.2073D-03, -.2513D-03,
     >    -.3046D-03, -.3692D-03, -.4476D-03, -.5425D-03, -.6577D-03,
     >    -.7973D-03, -.9666D-03, -.1172D-02, -.1421D-02, -.1723D-02,
     >    -.2090D-02, -.2536D-02, -.3079D-02, -.3741D-02, -.4548D-02,
     >    -.5527D-02, -.6701D-02, -.8081D-02, -.9647D-02, -.1134D-01,
     >    -.1306D-01, -.1468D-01, -.1608D-01, -.1713D-01, -.1775D-01,
     >    -.1788D-01, -.1748D-01, -.1660D-01, -.1530D-01, -.1377D-01,
     >    -.1222D-01, -.1087D-01, -.9851D-02, -.9116D-02, -.8513D-02,
     >    -.7875D-02, -.7120D-02, -.6263D-02, -.5366D-02, -.4494D-02,
     >    -.3697D-02, -.2997D-02, -.2401D-02, -.1913D-02, -.1499D-02,
     >    -.1166D-02, -.9065D-03, -.6999D-03, -.5266D-03, -.4067D-03,
     >    -.3067D-03, -.2334D-03, -.1734D-03, -.1334D-03, -.1001D-03,
     >    -.7340D-04/

      data (calcpts(j,37), j = 1,neta) /-.9350D-05, -.1113D-04,
     >    -.1370D-04, -.1661D-04, -.2005D-04, -.2421D-04, -.2924D-04,
     >    -.3544D-04, -.4294D-04, -.5203D-04, -.6306D-04, -.7640D-04,
     >    -.9263D-04, -.1122D-03, -.1360D-03, -.1649D-03, -.1998D-03,
     >    -.2422D-03, -.2935D-03, -.3558D-03, -.4312D-03, -.5227D-03,
     >    -.6336D-03, -.7680D-03, -.9309D-03, -.1128D-02, -.1368D-02,
     >    -.1658D-02, -.2011D-02, -.2439D-02, -.2961D-02, -.3593D-02,
     >    -.4358D-02, -.5271D-02, -.6341D-02, -.7553D-02, -.8865D-02,
     >    -.1021D-01, -.1149D-01, -.1263D-01, -.1353D-01, -.1413D-01,
     >    -.1439D-01, -.1427D-01, -.1377D-01, -.1291D-01, -.1178D-01,
     >    -.1050D-01, -.9244D-02, -.8180D-02, -.7389D-02, -.6829D-02,
     >    -.6369D-02, -.5881D-02, -.5303D-02, -.4651D-02, -.3971D-02,
     >    -.3316D-02, -.2720D-02, -.2199D-02, -.1758D-02, -.1392D-02,
     >    -.1095D-02, -.8512D-03, -.6606D-03, -.5066D-03, -.3886D-03,
     >    -.2953D-03, -.2240D-03, -.1693D-03, -.1273D-03, -.9535D-04,
     >    -.7135D-04/

      data (calcpts(j,38), j = 1,neta) /-.7323D-05, -.8879D-05,
     >    -.1071D-04, -.1298D-04, -.1574D-04, -.1902D-04, -.2306D-04,
     >    -.2791D-04, -.3375D-04, -.4091D-04, -.4954D-04, -.6005D-04,
     >    -.7274D-04, -.8814D-04, -.1067D-03, -.1294D-03, -.1568D-03,
     >    -.1900D-03, -.2303D-03, -.2792D-03, -.3383D-03, -.4100D-03,
     >    -.4970D-03, -.6023D-03, -.7300D-03, -.8847D-03, -.1072D-02,
     >    -.1299D-02, -.1575D-02, -.1909D-02, -.2315D-02, -.2806D-02,
     >    -.3397D-02, -.4101D-02, -.4924D-02, -.5855D-02, -.6865D-02,
     >    -.7905D-02, -.8912D-02, -.9819D-02, -.1057D-01, -.1111D-01,
     >    -.1141D-01, -.1146D-01, -.1122D-01, -.1071D-01, -.9941D-02,
     >    -.8985D-02, -.7943D-02, -.6946D-02, -.6119D-02, -.5514D-02,
     >    -.5091D-02, -.4743D-02, -.4372D-02, -.3933D-02, -.3439D-02,
     >    -.2928D-02, -.2438D-02, -.1994D-02, -.1609D-02, -.1283D-02,
     >    -.1016D-02, -.7942D-03, -.6176D-03, -.4770D-03, -.3677D-03,
     >    -.2804D-03, -.2130D-03, -.1610D-03, -.1217D-03, -.9104D-04,
     >    -.6771D-04/

      data (calcpts(j,39), j = 1,neta) /-.5564D-05, -.6759D-05,
     >    -.8192D-05, -.9970D-05, -.1212D-04, -.1469D-04, -.1779D-04,
     >    -.2157D-04, -.2609D-04, -.3166D-04, -.3838D-04, -.4656D-04,
     >    -.5639D-04, -.6835D-04, -.8283D-04, -.1004D-03, -.1217D-03,
     >    -.1475D-03, -.1787D-03, -.2167D-03, -.2625D-03, -.3182D-03,
     >    -.3856D-03, -.4674D-03, -.5663D-03, -.6863D-03, -.8314D-03,
     >    -.1007D-02, -.1221D-02, -.1479D-02, -.1792D-02, -.2170D-02,
     >    -.2623D-02, -.3162D-02, -.3790D-02, -.4501D-02, -.5273D-02,
     >    -.6072D-02, -.6852D-02, -.7568D-02, -.8177D-02, -.8646D-02,
     >    -.8952D-02, -.9074D-02, -.9000D-02, -.8723D-02, -.8246D-02,
     >    -.7592D-02, -.6807D-02, -.5974D-02, -.5194D-02, -.4557D-02,
     >    -.4098D-02, -.3780D-02, -.3519D-02, -.3239D-02, -.2907D-02,
     >    -.2535D-02, -.2153D-02, -.1788D-02, -.1457D-02, -.1175D-02,
     >    -.9354D-03, -.7381D-03, -.5775D-03, -.4488D-03, -.3468D-03,
     >    -.2662D-03, -.2035D-03, -.1549D-03, -.1169D-03, -.8820D-04,
     >    -.6620D-04/

      data (calcpts(j,40), j = 1,neta) /-.4321D-05, -.5241D-05,
     >    -.6319D-05, -.7696D-05, -.9306D-05, -.1129D-04, -.1367D-04,
     >    -.1662D-04, -.2009D-04, -.2435D-04, -.2952D-04, -.3579D-04,
     >    -.4337D-04, -.5257D-04, -.6371D-04, -.7722D-04, -.9360D-04,
     >    -.1134D-03, -.1374D-03, -.1666D-03, -.2019D-03, -.2446D-03,
     >    -.2965D-03, -.3593D-03, -.4353D-03, -.5274D-03, -.6389D-03,
     >    -.7739D-03, -.9375D-03, -.1135D-02, -.1374D-02, -.1663D-02,
     >    -.2009D-02, -.2418D-02, -.2895D-02, -.3434D-02, -.4020D-02,
     >    -.4630D-02, -.5230D-02, -.5788D-02, -.6274D-02, -.6666D-02,
     >    -.6944D-02, -.7097D-02, -.7115D-02, -.6989D-02, -.6715D-02,
     >    -.6298D-02, -.5755D-02, -.5125D-02, -.4469D-02, -.3865D-02,
     >    -.3379D-02, -.3033D-02, -.2795D-02, -.2600D-02, -.2389D-02,
     >    -.2140D-02, -.1862D-02, -.1578D-02, -.1307D-02, -.1065D-02,
     >    -.8552D-03, -.6799D-03, -.5353D-03, -.4180D-03, -.3246D-03,
     >    -.2506D-03, -.1920D-03, -.1466D-03, -.1113D-03, -.8399D-04,
     >    -.6332D-04/

      data (calcpts(j,41), j = 1,neta) /-.3334D-05, -.4055D-05,
     >    -.4852D-05, -.5910D-05, -.7143D-05, -.8672D-05, -.1049D-04,
     >    -.1268D-04, -.1537D-04, -.1864D-04, -.2260D-04, -.2733D-04,
     >    -.3314D-04, -.4016D-04, -.4862D-04, -.5896D-04, -.7144D-04,
     >    -.8655D-04, -.1049D-03, -.1271D-03, -.1540D-03, -.1866D-03,
     >    -.2261D-03, -.2740D-03, -.3319D-03, -.4022D-03, -.4871D-03,
     >    -.5900D-03, -.7145D-03, -.8649D-03, -.1047D-02, -.1265D-02,
     >    -.1527D-02, -.1837D-02, -.2196D-02, -.2603D-02, -.3046D-02,
     >    -.3508D-02, -.3966D-02, -.4397D-02, -.4780D-02, -.5098D-02,
     >    -.5339D-02, -.5494D-02, -.5555D-02, -.5518D-02, -.5376D-02,
     >    -.5128D-02, -.4777D-02, -.4337D-02, -.3838D-02, -.3328D-02,
     >    -.2864D-02, -.2496D-02, -.2236D-02, -.2060D-02, -.1915D-02,
     >    -.1757D-02, -.1571D-02, -.1364D-02, -.1157D-02, -.9529D-03,
     >    -.7742D-03, -.6209D-03, -.4923D-03, -.3869D-03, -.3023D-03,
     >    -.2343D-03, -.1803D-03, -.1383D-03, -.1050D-03, -.7963D-04,
     >    -.6029D-04/

      data (calcpts(j,42), j = 1,neta) /-.2479D-05, -.3065D-05,
     >    -.3689D-05, -.4454D-05, -.5396D-05, -.6551D-05, -.7966D-05,
     >    -.9624D-05, -.1164D-04, -.1409D-04, -.1709D-04, -.2071D-04,
     >    -.2511D-04, -.3044D-04, -.3685D-04, -.4467D-04, -.5412D-04,
     >    -.6560D-04, -.7945D-04, -.9630D-04, -.1166D-03, -.1413D-03,
     >    -.1713D-03, -.2076D-03, -.2514D-03, -.3046D-03, -.3689D-03,
     >    -.4468D-03, -.5409D-03, -.6546D-03, -.7917D-03, -.9566D-03,
     >    -.1154D-02, -.1386D-02, -.1657D-02, -.1962D-02, -.2295D-02,
     >    -.2644D-02, -.2991D-02, -.3321D-02, -.3618D-02, -.3872D-02,
     >    -.4073D-02, -.4215D-02, -.4293D-02, -.4303D-02, -.4241D-02,
     >    -.4104D-02, -.3890D-02, -.3602D-02, -.3251D-02, -.2861D-02,
     >    -.2468D-02, -.2115D-02, -.1837D-02, -.1644D-02, -.1513D-02,
     >    -.1406D-02, -.1289D-02, -.1150D-02, -.9963D-03, -.8400D-03,
     >    -.6934D-03, -.5621D-03, -.4501D-03, -.3568D-03, -.2801D-03,
     >    -.2181D-03, -.1688D-03, -.1301D-03, -.9944D-04, -.7544D-04,
     >    -.5744D-04/

      data (calcpts(j,43), j = 1,neta) /-.1859D-05, -.2269D-05,
     >    -.2779D-05, -.3347D-05, -.4064D-05, -.4958D-05, -.5995D-05,
     >    -.7236D-05, -.8771D-05, -.1062D-04, -.1288D-04, -.1560D-04,
     >    -.1890D-04, -.2290D-04, -.2775D-04, -.3363D-04, -.4075D-04,
     >    -.4937D-04, -.5983D-04, -.7250D-04, -.8785D-04, -.1064D-03,
     >    -.1290D-03, -.1563D-03, -.1893D-03, -.2293D-03, -.2777D-03,
     >    -.3363D-03, -.4070D-03, -.4925D-03, -.5955D-03, -.7191D-03,
     >    -.8667D-03, -.1041D-02, -.1243D-02, -.1471D-02, -.1720D-02,
     >    -.1982D-02, -.2244D-02, -.2495D-02, -.2724D-02, -.2923D-02,
     >    -.3086D-02, -.3209D-02, -.3288D-02, -.3321D-02, -.3304D-02,
     >    -.3235D-02, -.3111D-02, -.2932D-02, -.2702D-02, -.2426D-02,
     >    -.2125D-02, -.1824D-02, -.1557D-02, -.1349D-02, -.1205D-02,
     >    -.1109D-02, -.1029D-02, -.9423D-03, -.8397D-03, -.7260D-03,
     >    -.6111D-03, -.5032D-03, -.4074D-03, -.3254D-03, -.2574D-03,
     >    -.2021D-03, -.1574D-03, -.1214D-03, -.9342D-04, -.7142D-04,
     >    -.5409D-04/

      data (calcpts(j,44), j = 1,neta) /-.1425D-05, -.1723D-05,
     >    -.2083D-05, -.2524D-05, -.3056D-05, -.3699D-05, -.4481D-05,
     >    -.5430D-05, -.6576D-05, -.7963D-05, -.9650D-05, -.1169D-04,
     >    -.1416D-04, -.1716D-04, -.2079D-04, -.2519D-04, -.3052D-04,
     >    -.3698D-04, -.4482D-04, -.5431D-04, -.6579D-04, -.7972D-04,
     >    -.9660D-04, -.1170D-03, -.1417D-03, -.1717D-03, -.2079D-03,
     >    -.2518D-03, -.3047D-03, -.3686D-03, -.4455D-03, -.5378D-03,
     >    -.6479D-03, -.7776D-03, -.9280D-03, -.1098D-02, -.1284D-02,
     >    -.1479D-02, -.1676D-02, -.1865D-02, -.2041D-02, -.2195D-02,
     >    -.2325D-02, -.2428D-02, -.2499D-02, -.2539D-02, -.2546D-02,
     >    -.2517D-02, -.2450D-02, -.2345D-02, -.2200D-02, -.2016D-02,
     >    -.1803D-02, -.1571D-02, -.1344D-02, -.1143D-02, -.9871D-03,
     >    -.8809D-03, -.8099D-03, -.7514D-03, -.6872D-03, -.6114D-03,
     >    -.5277D-03, -.4433D-03, -.3645D-03, -.2946D-03, -.2351D-03,
     >    -.1856D-03, -.1456D-03, -.1129D-03, -.8693D-04, -.6693D-04,
     >    -.5093D-04/

      data (calcpts(j,45), j = 1,neta) /-.1047D-05, -.1275D-05,
     >    -.1544D-05, -.1873D-05, -.2268D-05, -.2748D-05, -.3332D-05,
     >    -.4036D-05, -.4893D-05, -.5928D-05, -.7185D-05, -.8710D-05,
     >    -.1055D-04, -.1279D-04, -.1549D-04, -.1877D-04, -.2276D-04,
     >    -.2757D-04, -.3341D-04, -.4049D-04, -.4905D-04, -.5944D-04,
     >    -.7201D-04, -.8724D-04, -.1057D-03, -.1280D-03, -.1550D-03,
     >    -.1876D-03, -.2271D-03, -.2746D-03, -.3319D-03, -.4005D-03,
     >    -.4822D-03, -.5785D-03, -.6900D-03, -.8160D-03, -.9539D-03,
     >    -.1099D-02, -.1246D-02, -.1389D-02, -.1522D-02, -.1641D-02,
     >    -.1743D-02, -.1826D-02, -.1887D-02, -.1928D-02, -.1945D-02,
     >    -.1938D-02, -.1906D-02, -.1846D-02, -.1758D-02, -.1642D-02,
     >    -.1499D-02, -.1335D-02, -.1159D-02, -.9869D-03, -.8364D-03,
     >    -.7209D-03, -.6425D-03, -.5904D-03, -.5475D-03, -.5002D-03,
     >    -.4444D-03, -.3830D-03, -.3212D-03, -.2637D-03, -.2128D-03,
     >    -.1696D-03, -.1338D-03, -.1049D-03, -.8132D-04, -.6279D-04,
     >    -.4812D-04/

      data (calcpts(j,46), j = 1,neta) /-.7797D-06, -.9460D-06,
     >    -.1149D-05, -.1390D-05, -.1685D-05, -.2043D-05, -.2478D-05,
     >    -.3000D-05, -.3631D-05, -.4402D-05, -.5337D-05, -.6469D-05,
     >    -.7835D-05, -.9494D-05, -.1150D-04, -.1394D-04, -.1689D-04,
     >    -.2047D-04, -.2480D-04, -.3005D-04, -.3641D-04, -.4411D-04,
     >    -.5345D-04, -.6475D-04, -.7843D-04, -.9499D-04, -.1150D-03,
     >    -.1392D-03, -.1685D-03, -.2037D-03, -.2461D-03, -.2970D-03,
     >    -.3574D-03, -.4286D-03, -.5110D-03, -.6042D-03, -.7062D-03,
     >    -.8140D-03, -.9235D-03, -.1030D-02, -.1131D-02, -.1222D-02,
     >    -.1300D-02, -.1366D-02, -.1417D-02, -.1454D-02, -.1474D-02,
     >    -.1479D-02, -.1466D-02, -.1434D-02, -.1383D-02, -.1313D-02,
     >    -.1221D-02, -.1110D-02, -.9850D-03, -.8519D-03, -.7227D-03,
     >    -.6105D-03, -.5250D-03, -.4674D-03, -.4293D-03, -.3978D-03,
     >    -.3632D-03, -.3223D-03, -.2773D-03, -.2321D-03, -.1902D-03,
     >    -.1533D-03, -.1220D-03, -.9633D-04, -.7513D-04, -.5833D-04,
     >    -.4486D-04/

      data (calcpts(j,47), j = 1,neta) /-.5812D-06, -.7041D-06,
     >    -.8530D-06, -.1034D-05, -.1247D-05, -.1512D-05, -.1830D-05,
     >    -.2218D-05, -.2692D-05, -.3258D-05, -.3949D-05, -.4785D-05,
     >    -.5798D-05, -.7020D-05, -.8509D-05, -.1031D-04, -.1249D-04,
     >    -.1514D-04, -.1834D-04, -.2222D-04, -.2692D-04, -.3261D-04,
     >    -.3952D-04, -.4787D-04, -.5798D-04, -.7023D-04, -.8502D-04,
     >    -.1029D-03, -.1245D-03, -.1505D-03, -.1819D-03, -.2193D-03,
     >    -.2639D-03, -.3164D-03, -.3771D-03, -.4458D-03, -.5210D-03,
     >    -.6007D-03, -.6818D-03, -.7614D-03, -.8367D-03, -.9054D-03,
     >    -.9658D-03, -.1018D-02, -.1059D-02, -.1090D-02, -.1111D-02,
     >    -.1120D-02, -.1118D-02, -.1102D-02, -.1074D-02, -.1032D-02,
     >    -.9757D-03, -.9045D-03, -.8198D-03, -.7246D-03, -.6244D-03,
     >    -.5279D-03, -.4446D-03, -.3815D-03, -.3393D-03, -.3115D-03,
     >    -.2885D-03, -.2631D-03, -.2332D-03, -.2003D-03, -.1675D-03,
     >    -.1370D-03, -.1103D-03, -.8765D-04, -.6899D-04, -.5385D-04,
     >    -.4165D-04/

      data (calcpts(j,48), j = 1,neta) /-.4289D-06, -.5178D-06,
     >    -.6274D-06, -.7621D-06, -.9198D-06, -.1112D-05, -.1351D-05,
     >    -.1637D-05, -.1984D-05, -.2400D-05, -.2909D-05, -.3527D-05,
     >    -.4273D-05, -.5175D-05, -.6268D-05, -.7597D-05, -.9203D-05,
     >    -.1115D-04, -.1351D-04, -.1637D-04, -.1983D-04, -.2403D-04,
     >    -.2912D-04, -.3527D-04, -.4272D-04, -.5174D-04, -.6264D-04,
     >    -.7582D-04, -.9172D-04, -.1109D-03, -.1339D-03, -.1615D-03,
     >    -.1943D-03, -.2329D-03, -.2775D-03, -.3278D-03, -.3832D-03,
     >    -.4419D-03, -.5019D-03, -.5609D-03, -.6172D-03, -.6690D-03,
     >    -.7152D-03, -.7550D-03, -.7880D-03, -.8138D-03, -.8322D-03,
     >    -.8427D-03, -.8453D-03, -.8395D-03, -.8249D-03, -.8008D-03,
     >    -.7669D-03, -.7226D-03, -.6678D-03, -.6033D-03, -.5315D-03,
     >    -.4565D-03, -.3860D-03, -.3231D-03, -.2767D-03, -.2458D-03,
     >    -.2256D-03, -.2088D-03, -.1903D-03, -.1684D-03, -.1445D-03,
     >    -.1206D-03, -.9858D-04, -.7925D-04, -.6292D-04, -.4952D-04,
     >    -.3852D-04/

      data (calcpts(j,49), j = 1,neta) /-.3130D-06, -.3793D-06,
     >    -.4580D-06, -.5590D-06, -.6787D-06, -.8204D-06, -.9885D-06,
     >    -.1201D-05, -.1456D-05, -.1761D-05, -.2137D-05, -.2588D-05,
     >    -.3137D-05, -.3800D-05, -.4604D-05, -.5579D-05, -.6762D-05,
     >    -.8190D-05, -.9926D-05, -.1203D-04, -.1457D-04, -.1765D-04,
     >    -.2138D-04, -.2590D-04, -.3137D-04, -.3800D-04, -.4600D-04,
     >    -.5567D-04, -.6735D-04, -.8141D-04, -.9832D-04, -.1185D-03,
     >    -.1426D-03, -.1708D-03, -.2035D-03, -.2405D-03, -.2811D-03,
     >    -.3241D-03, -.3683D-03, -.4121D-03, -.4539D-03, -.4927D-03,
     >    -.5276D-03, -.5582D-03, -.5840D-03, -.6048D-03, -.6204D-03,
     >    -.6307D-03, -.6355D-03, -.6346D-03, -.6277D-03, -.6146D-03,
     >    -.5947D-03, -.5677D-03, -.5333D-03, -.4915D-03, -.4427D-03,
     >    -.3888D-03, -.3330D-03, -.2798D-03, -.2343D-03, -.2003D-03,
     >    -.1778D-03, -.1630D-03, -.1509D-03, -.1374D-03, -.1215D-03,
     >    -.1041D-03, -.8673D-04, -.7079D-04, -.5686D-04, -.4513D-04,
     >    -.3539D-04/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsctca = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine sctcf_CT(eta, xi, xsctcf)
c   the subtracted term from eq (10) of PLB347 (1995) 143 - 151
c   transverse gluon initiated piece with C_F color factor in front
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsctcf
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /-.2005D-03, -.2004D-03,
     >    -.3501D-03, -.3497D-03, -.4991D-03, -.4983D-03, -.6470D-03,
     >    -.7952D-03, -.9425D-03, -.1089D-02, -.1383D-02, -.1524D-02,
     >    -.1962D-02, -.2243D-02, -.2666D-02, -.3227D-02, -.3769D-02,
     >    -.4434D-02, -.5209D-02, -.6075D-02, -.7007D-02, -.7963D-02,
     >    -.8887D-02, -.9694D-02, -.1011D-01, -.1027D-01, -.9623D-02,
     >    -.7967D-02, -.4835D-02, -.5091D-03, 0.5340D-02, 0.1151D-01,
     >    0.1643D-01, 0.1747D-01, 0.1237D-01, 0.7897D-03, -.1390D-01,
     >    -.2616D-01, -.3083D-01, -.2674D-01, -.1655D-01, -.4410D-02,
     >    0.6429D-02, 0.1431D-01, 0.1894D-01, 0.2087D-01, 0.2082D-01,
     >    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1299D-01, 0.1083D-01,
     >    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,
     >    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     >    0.7622D-03, 0.5780D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     >    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 2), j = 1,neta) /-.1546D-03, -.3044D-03,
     >    -.3042D-03, -.3038D-03, -.4532D-03, -.4523D-03, -.6011D-03,
     >    -.7493D-03, -.8966D-03, -.1043D-02, -.1337D-02, -.1628D-02,
     >    -.1916D-02, -.2347D-02, -.2770D-02, -.3181D-02, -.3873D-02,
     >    -.4538D-02, -.5313D-02, -.6180D-02, -.6961D-02, -.7918D-02,
     >    -.8841D-02, -.9649D-02, -.1022D-01, -.1023D-01, -.9578D-02,
     >    -.7923D-02, -.4941D-02, -.4661D-03, 0.5382D-02, 0.1155D-01,
     >    0.1647D-01, 0.1750D-01, 0.1240D-01, 0.8170D-03, -.1388D-01,
     >    -.2616D-01, -.3083D-01, -.2673D-01, -.1655D-01, -.4404D-02,
     >    0.6433D-02, 0.1429D-01, 0.1894D-01, 0.2086D-01, 0.2082D-01,
     >    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     >    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,
     >    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     >    0.7622D-03, 0.5780D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     >    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 3), j = 1,neta) /-.2373D-03, -.2372D-03,
     >    -.2369D-03, -.3865D-03, -.3859D-03, -.5351D-03, -.6838D-03,
     >    -.6820D-03, -.9793D-03, -.1125D-02, -.1270D-02, -.1561D-02,
     >    -.1848D-02, -.2280D-02, -.2703D-02, -.3264D-02, -.3806D-02,
     >    -.4471D-02, -.5246D-02, -.6112D-02, -.7044D-02, -.8001D-02,
     >    -.8924D-02, -.9582D-02, -.1015D-01, -.1016D-01, -.9512D-02,
     >    -.7858D-02, -.4877D-02, -.4031D-03, 0.5293D-02, 0.1145D-01,
     >    0.1637D-01, 0.1755D-01, 0.1244D-01, 0.8570D-03, -.1399D-01,
     >    -.2615D-01, -.3083D-01, -.2673D-01, -.1656D-01, -.4395D-02,
     >    0.6424D-02, 0.1430D-01, 0.1893D-01, 0.2086D-01, 0.2082D-01,
     >    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1299D-01, 0.1083D-01,
     >    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,
     >    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     >    0.7622D-03, 0.5778D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     >    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 4), j = 1,neta) /-.1385D-03, -.2883D-03,
     >    -.2881D-03, -.2877D-03, -.4371D-03, -.5862D-03, -.5850D-03,
     >    -.7331D-03, -.8804D-03, -.1026D-02, -.1321D-02, -.1612D-02,
     >    -.1900D-02, -.2331D-02, -.2754D-02, -.3165D-02, -.3857D-02,
     >    -.4522D-02, -.5297D-02, -.6164D-02, -.6946D-02, -.7902D-02,
     >    -.8826D-02, -.9634D-02, -.1020D-01, -.1021D-01, -.9565D-02,
     >    -.7912D-02, -.4932D-02, -.4606D-03, 0.5233D-02, 0.1154D-01,
     >    0.1645D-01, 0.1748D-01, 0.1236D-01, 0.7658D-03, -.1394D-01,
     >    -.2615D-01, -.3082D-01, -.2673D-01, -.1655D-01, -.4398D-02,
     >    0.6433D-02, 0.1429D-01, 0.1894D-01, 0.2087D-01, 0.2083D-01,
     >    0.1952D-01, 0.1753D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     >    0.8899D-02, 0.7216D-02, 0.5790D-02, 0.4600D-02, 0.3625D-02,
     >    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     >    0.7622D-03, 0.5778D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     >    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 5), j = 1,neta) /-.1435D-03, -.2933D-03,
     >    -.2930D-03, -.2926D-03, -.4421D-03, -.5912D-03, -.5900D-03,
     >    -.7381D-03, -.8854D-03, -.1031D-02, -.1326D-02, -.1617D-02,
     >    -.1905D-02, -.2336D-02, -.2759D-02, -.3170D-02, -.3862D-02,
     >    -.4527D-02, -.5302D-02, -.6169D-02, -.6951D-02, -.7908D-02,
     >    -.8831D-02, -.9640D-02, -.1021D-01, -.1022D-01, -.9573D-02,
     >    -.7921D-02, -.4944D-02, -.4749D-03, 0.5215D-02, 0.1152D-01,
     >    0.1642D-01, 0.1744D-01, 0.1231D-01, 0.8520D-03, -.1402D-01,
     >    -.2614D-01, -.3081D-01, -.2671D-01, -.1654D-01, -.4394D-02,
     >    0.6431D-02, 0.1430D-01, 0.1893D-01, 0.2087D-01, 0.2083D-01,
     >    0.1953D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     >    0.8898D-02, 0.7216D-02, 0.5788D-02, 0.4600D-02, 0.3625D-02,
     >    0.2835D-02, 0.2205D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     >    0.7621D-03, 0.5778D-03, 0.4365D-03, 0.3286D-03, 0.2464D-03,
     >    0.1844D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 6), j = 1,neta) /-.2310D-03, -.2308D-03,
     >    -.2305D-03, -.3801D-03, -.3795D-03, -.5287D-03, -.6774D-03,
     >    -.8256D-03, -.9729D-03, -.1119D-02, -.1263D-02, -.1555D-02,
     >    -.1842D-02, -.2274D-02, -.2697D-02, -.3257D-02, -.3799D-02,
     >    -.4464D-02, -.5240D-02, -.6107D-02, -.7039D-02, -.7996D-02,
     >    -.8920D-02, -.9579D-02, -.1015D-01, -.1016D-01, -.9515D-02,
     >    -.7865D-02, -.4891D-02, -.5759D-03, 0.5258D-02, 0.1140D-01,
     >    0.1630D-01, 0.1745D-01, 0.1231D-01, 0.8284D-03, -.1392D-01,
     >    -.2614D-01, -.3080D-01, -.2671D-01, -.1653D-01, -.4397D-02,
     >    0.6421D-02, 0.1430D-01, 0.1894D-01, 0.2086D-01, 0.2082D-01,
     >    0.1953D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     >    0.8897D-02, 0.7216D-02, 0.5788D-02, 0.4599D-02, 0.3625D-02,
     >    0.2836D-02, 0.2205D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     >    0.7621D-03, 0.5779D-03, 0.4365D-03, 0.3284D-03, 0.2464D-03,
     >    0.1844D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 7), j = 1,neta) /-.2194D-03, -.2192D-03,
     >    -.2189D-03, -.3685D-03, -.3680D-03, -.5171D-03, -.6659D-03,
     >    -.8140D-03, -.9613D-03, -.1107D-02, -.1252D-02, -.1543D-02,
     >    -.1831D-02, -.2262D-02, -.2685D-02, -.3246D-02, -.3788D-02,
     >    -.4453D-02, -.5228D-02, -.6096D-02, -.7028D-02, -.7985D-02,
     >    -.8910D-02, -.9569D-02, -.1014D-01, -.1030D-01, -.9660D-02,
     >    -.7863D-02, -.5043D-02, -.5842D-03, 0.5241D-02, 0.1137D-01,
     >    0.1625D-01, 0.1739D-01, 0.1222D-01, 0.7137D-03, -.1391D-01,
     >    -.2612D-01, -.3079D-01, -.2669D-01, -.1652D-01, -.4402D-02,
     >    0.6419D-02, 0.1429D-01, 0.1892D-01, 0.2086D-01, 0.2081D-01,
     >    0.1952D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     >    0.8896D-02, 0.7215D-02, 0.5787D-02, 0.4599D-02, 0.3625D-02,
     >    0.2836D-02, 0.2205D-02, 0.1704D-02, 0.1309D-02, 0.1001D-02,
     >    0.7621D-03, 0.5779D-03, 0.4365D-03, 0.3285D-03, 0.2464D-03,
     >    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 8), j = 1,neta) /-.2128D-03, -.2126D-03,
     >    -.3623D-03, -.3619D-03, -.3613D-03, -.5105D-03, -.6592D-03,
     >    -.8074D-03, -.9547D-03, -.1101D-02, -.1245D-02, -.1536D-02,
     >    -.1824D-02, -.2256D-02, -.2679D-02, -.3239D-02, -.3782D-02,
     >    -.4447D-02, -.5222D-02, -.6090D-02, -.7022D-02, -.7980D-02,
     >    -.8905D-02, -.9566D-02, -.1014D-01, -.1030D-01, -.9663D-02,
     >    -.8021D-02, -.5056D-02, -.6067D-03, 0.5056D-02, 0.1132D-01,
     >    0.1618D-01, 0.1713D-01, 0.1223D-01, 0.6853D-03, -.1398D-01,
     >    -.2611D-01, -.3077D-01, -.2667D-01, -.1652D-01, -.4388D-02,
     >    0.6431D-02, 0.1429D-01, 0.1893D-01, 0.2086D-01, 0.2082D-01,
     >    0.1951D-01, 0.1753D-01, 0.1526D-01, 0.1298D-01, 0.1083D-01,
     >    0.8895D-02, 0.7215D-02, 0.5788D-02, 0.4598D-02, 0.3624D-02,
     >    0.2836D-02, 0.2203D-02, 0.1704D-02, 0.1309D-02, 0.1001D-02,
     >    0.7620D-03, 0.5779D-03, 0.4365D-03, 0.3285D-03, 0.2464D-03,
     >    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j, 9), j = 1,neta) /-.1453D-03, -.2952D-03,
     >    -.2949D-03, -.2945D-03, -.4439D-03, -.4431D-03, -.5918D-03,
     >    -.7400D-03, -.8873D-03, -.1033D-02, -.1328D-02, -.1619D-02,
     >    -.1907D-02, -.2188D-02, -.2762D-02, -.3172D-02, -.3864D-02,
     >    -.4530D-02, -.5306D-02, -.6023D-02, -.6956D-02, -.7915D-02,
     >    -.8841D-02, -.9653D-02, -.1023D-01, -.1024D-01, -.9610D-02,
     >    -.7974D-02, -.5019D-02, -.7318D-03, 0.4913D-02, 0.1115D-01,
     >    0.1598D-01, 0.1704D-01, 0.1209D-01, 0.6323D-03, -.1395D-01,
     >    -.2608D-01, -.3072D-01, -.2665D-01, -.1649D-01, -.4378D-02,
     >    0.6416D-02, 0.1428D-01, 0.1891D-01, 0.2085D-01, 0.2080D-01,
     >    0.1950D-01, 0.1752D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     >    0.8894D-02, 0.7213D-02, 0.5787D-02, 0.4599D-02, 0.3624D-02,
     >    0.2835D-02, 0.2203D-02, 0.1702D-02, 0.1309D-02, 0.1001D-02,
     >    0.7620D-03, 0.5777D-03, 0.4363D-03, 0.3285D-03, 0.2464D-03,
     >    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7581D-04, 0.5611D-04,
     >    0.4143D-04/

      data (calcpts(j,10), j = 1,neta) /-.2188D-03, -.2186D-03,
     >    -.2183D-03, -.3679D-03, -.3673D-03, -.5165D-03, -.6652D-03,
     >    -.8134D-03, -.9608D-03, -.1107D-02, -.1251D-02, -.1543D-02,
     >    -.1830D-02, -.2262D-02, -.2685D-02, -.3246D-02, -.3788D-02,
     >    -.4454D-02, -.5230D-02, -.6098D-02, -.7032D-02, -.7841D-02,
     >    -.8769D-02, -.9583D-02, -.1016D-01, -.1018D-01, -.9704D-02,
     >    -.8077D-02, -.5135D-02, -.8675D-03, 0.4751D-02, 0.1096D-01,
     >    0.1573D-01, 0.1673D-01, 0.1185D-01, 0.4632D-03, -.1406D-01,
     >    -.2606D-01, -.3067D-01, -.2659D-01, -.1647D-01, -.4373D-02,
     >    0.6415D-02, 0.1427D-01, 0.1891D-01, 0.2083D-01, 0.2079D-01,
     >    0.1950D-01, 0.1752D-01, 0.1526D-01, 0.1297D-01, 0.1082D-01,
     >    0.8891D-02, 0.7211D-02, 0.5785D-02, 0.4598D-02, 0.3623D-02,
     >    0.2835D-02, 0.2204D-02, 0.1702D-02, 0.1308D-02, 0.1001D-02,
     >    0.7619D-03, 0.5776D-03, 0.4364D-03, 0.3285D-03, 0.2463D-03,
     >    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7581D-04, 0.5610D-04,
     >    0.4142D-04/

      data (calcpts(j,11), j = 1,neta) /-.1437D-03, -.2935D-03,
     >    -.2933D-03, -.2929D-03, -.4423D-03, -.4414D-03, -.5902D-03,
     >    -.7384D-03, -.8857D-03, -.1032D-02, -.1326D-02, -.1618D-02,
     >    -.1905D-02, -.2187D-02, -.2610D-02, -.3171D-02, -.3714D-02,
     >    -.4380D-02, -.5156D-02, -.6025D-02, -.6960D-02, -.7920D-02,
     >    -.8850D-02, -.9667D-02, -.1010D-01, -.1028D-01, -.9659D-02,
     >    -.8046D-02, -.5273D-02, -.1033D-02, 0.4546D-02, 0.1055D-01,
     >    0.1540D-01, 0.1646D-01, 0.1163D-01, 0.4108D-03, -.1410D-01,
     >    -.2601D-01, -.3059D-01, -.2652D-01, -.1642D-01, -.4356D-02,
     >    0.6410D-02, 0.1426D-01, 0.1888D-01, 0.2081D-01, 0.2078D-01,
     >    0.1949D-01, 0.1752D-01, 0.1525D-01, 0.1297D-01, 0.1082D-01,
     >    0.8887D-02, 0.7209D-02, 0.5783D-02, 0.4596D-02, 0.3622D-02,
     >    0.2834D-02, 0.2202D-02, 0.1703D-02, 0.1308D-02, 0.1000D-02,
     >    0.7617D-03, 0.5775D-03, 0.4362D-03, 0.3284D-03, 0.2463D-03,
     >    0.1843D-03, 0.1374D-03, 0.1022D-03, 0.7580D-04, 0.5609D-04,
     >    0.4142D-04/

      data (calcpts(j,12), j = 1,neta) /-.1721D-03, -.1719D-03,
     >    -.3216D-03, -.3212D-03, -.4707D-03, -.4698D-03, -.6186D-03,
     >    -.7668D-03, -.9141D-03, -.1060D-02, -.1355D-02, -.1496D-02,
     >    -.1934D-02, -.2216D-02, -.2639D-02, -.3200D-02, -.3743D-02,
     >    -.4410D-02, -.5187D-02, -.6056D-02, -.6993D-02, -.7805D-02,
     >    -.8738D-02, -.9560D-02, -.1015D-01, -.1019D-01, -.9731D-02,
     >    -.8137D-02, -.5394D-02, -.1194D-02, 0.4180D-02, 0.1010D-01,
     >    0.1486D-01, 0.1594D-01, 0.1109D-01, 0.1429D-03, -.1411D-01,
     >    -.2595D-01, -.3047D-01, -.2643D-01, -.1637D-01, -.4346D-02,
     >    0.6403D-02, 0.1424D-01, 0.1885D-01, 0.2079D-01, 0.2076D-01,
     >    0.1946D-01, 0.1749D-01, 0.1524D-01, 0.1296D-01, 0.1081D-01,
     >    0.8882D-02, 0.7204D-02, 0.5779D-02, 0.4593D-02, 0.3620D-02,
     >    0.2833D-02, 0.2201D-02, 0.1701D-02, 0.1308D-02, 0.1000D-02,
     >    0.7615D-03, 0.5774D-03, 0.4361D-03, 0.3282D-03, 0.2463D-03,
     >    0.1841D-03, 0.1373D-03, 0.1021D-03, 0.7577D-04, 0.5607D-04,
     >    0.4140D-04/

      data (calcpts(j,13), j = 1,neta) /-.1707D-03, -.1705D-03,
     >    -.3202D-03, -.3198D-03, -.4693D-03, -.4684D-03, -.6172D-03,
     >    -.7654D-03, -.9128D-03, -.1059D-02, -.1353D-02, -.1495D-02,
     >    -.1783D-02, -.2215D-02, -.2639D-02, -.3200D-02, -.3743D-02,
     >    -.4410D-02, -.5188D-02, -.5909D-02, -.6848D-02, -.7813D-02,
     >    -.8751D-02, -.9579D-02, -.1018D-01, -.1023D-01, -.9793D-02,
     >    -.8378D-02, -.5676D-02, -.1534D-02, 0.3758D-02, 0.9572D-02,
     >    0.1418D-01, 0.1522D-01, 0.1059D-01, -.1719D-03, -.1426D-01,
     >    -.2585D-01, -.3032D-01, -.2629D-01, -.1629D-01, -.4321D-02,
     >    0.6391D-02, 0.1421D-01, 0.1882D-01, 0.2075D-01, 0.2072D-01,
     >    0.1943D-01, 0.1748D-01, 0.1521D-01, 0.1294D-01, 0.1080D-01,
     >    0.8874D-02, 0.7198D-02, 0.5775D-02, 0.4590D-02, 0.3617D-02,
     >    0.2831D-02, 0.2200D-02, 0.1700D-02, 0.1307D-02, 0.9996D-03,
     >    0.7612D-03, 0.5771D-03, 0.4359D-03, 0.3281D-03, 0.2462D-03,
     >    0.1841D-03, 0.1373D-03, 0.1021D-03, 0.7575D-04, 0.5606D-04,
     >    0.4139D-04/

      data (calcpts(j,14), j = 1,neta) /-.1968D-03, -.1967D-03,
     >    -.3464D-03, -.3460D-03, -.3455D-03, -.4946D-03, -.6434D-03,
     >    -.7917D-03, -.9391D-03, -.1085D-02, -.1230D-02, -.1521D-02,
     >    -.1809D-02, -.2242D-02, -.2666D-02, -.3077D-02, -.3621D-02,
     >    -.4289D-02, -.5069D-02, -.5942D-02, -.6883D-02, -.7703D-02,
     >    -.8647D-02, -.9484D-02, -.1010D-01, -.1032D-01, -.9760D-02,
     >    -.8537D-02, -.5893D-02, -.1986D-02, 0.3039D-02, 0.8692D-02,
     >    0.1309D-01, 0.1430D-01, 0.9794D-02, -.7502D-03, -.1435D-01,
     >    -.2570D-01, -.3009D-01, -.2609D-01, -.1617D-01, -.4278D-02,
     >    0.6379D-02, 0.1415D-01, 0.1876D-01, 0.2070D-01, 0.2068D-01,
     >    0.1941D-01, 0.1744D-01, 0.1520D-01, 0.1292D-01, 0.1078D-01,
     >    0.8862D-02, 0.7189D-02, 0.5769D-02, 0.4586D-02, 0.3615D-02,
     >    0.2828D-02, 0.2198D-02, 0.1699D-02, 0.1306D-02, 0.9988D-03,
     >    0.7606D-03, 0.5768D-03, 0.4357D-03, 0.3279D-03, 0.2461D-03,
     >    0.1840D-03, 0.1372D-03, 0.1021D-03, 0.7573D-04, 0.5604D-04,
     >    0.4138D-04/

      data (calcpts(j,15), j = 1,neta) /-.1824D-03, -.1823D-03,
     >    -.3320D-03, -.3316D-03, -.4811D-03, -.4803D-03, -.6291D-03,
     >    -.7773D-03, -.9248D-03, -.1071D-02, -.1216D-02, -.1507D-02,
     >    -.1796D-02, -.2228D-02, -.2503D-02, -.3065D-02, -.3610D-02,
     >    -.4279D-02, -.5061D-02, -.5787D-02, -.6732D-02, -.7708D-02,
     >    -.8511D-02, -.9361D-02, -.9993D-02, -.1024D-01, -.9876D-02,
     >    -.8711D-02, -.6303D-02, -.2665D-02, 0.2193D-02, 0.7467D-02,
     >    0.1186D-01, 0.1284D-01, 0.8604D-02, -.1434D-02, -.1442D-01,
     >    -.2550D-01, -.2975D-01, -.2580D-01, -.1602D-01, -.4239D-02,
     >    0.6339D-02, 0.1408D-01, 0.1867D-01, 0.2062D-01, 0.2060D-01,
     >    0.1933D-01, 0.1739D-01, 0.1515D-01, 0.1289D-01, 0.1076D-01,
     >    0.8844D-02, 0.7176D-02, 0.5758D-02, 0.4578D-02, 0.3609D-02,
     >    0.2824D-02, 0.2195D-02, 0.1697D-02, 0.1304D-02, 0.9978D-03,
     >    0.7599D-03, 0.5762D-03, 0.4354D-03, 0.3277D-03, 0.2459D-03,
     >    0.1839D-03, 0.1371D-03, 0.1020D-03, 0.7567D-04, 0.5600D-04,
     >    0.4136D-04/

      data (calcpts(j,16), j = 1,neta) /-.1800D-03, -.1799D-03,
     >    -.3296D-03, -.3292D-03, -.3287D-03, -.4779D-03, -.6267D-03,
     >    -.6250D-03, -.7725D-03, -.1069D-02, -.1213D-02, -.1506D-02,
     >    -.1794D-02, -.2077D-02, -.2502D-02, -.2915D-02, -.3612D-02,
     >    -.4133D-02, -.4917D-02, -.5647D-02, -.6598D-02, -.7583D-02,
     >    -.8399D-02, -.9268D-02, -.9927D-02, -.1022D-01, -.1006D-01,
     >    -.8976D-02, -.6836D-02, -.3517D-02, 0.9542D-03, 0.5906D-02,
     >    0.1002D-01, 0.1105D-01, 0.7198D-02, -.2258D-02, -.1472D-01,
     >    -.2521D-01, -.2927D-01, -.2542D-01, -.1580D-01, -.4190D-02,
     >    0.6275D-02, 0.1396D-01, 0.1855D-01, 0.2048D-01, 0.2050D-01,
     >    0.1925D-01, 0.1732D-01, 0.1510D-01, 0.1285D-01, 0.1073D-01,
     >    0.8819D-02, 0.7157D-02, 0.5744D-02, 0.4567D-02, 0.3601D-02,
     >    0.2819D-02, 0.2191D-02, 0.1694D-02, 0.1302D-02, 0.9963D-03,
     >    0.7588D-03, 0.5754D-03, 0.4348D-03, 0.3272D-03, 0.2455D-03,
     >    0.1837D-03, 0.1370D-03, 0.1019D-03, 0.7560D-04, 0.5596D-04,
     >    0.4132D-04/

      data (calcpts(j,17), j = 1,neta) /-.1148D-03, -.2646D-03,
     >    -.2644D-03, -.2640D-03, -.4135D-03, -.4127D-03, -.5616D-03,
     >    -.7100D-03, -.8576D-03, -.1004D-02, -.1149D-02, -.1441D-02,
     >    -.1730D-02, -.2013D-02, -.2439D-02, -.2854D-02, -.3402D-02,
     >    -.4076D-02, -.4714D-02, -.5599D-02, -.6409D-02, -.7256D-02,
     >    -.8239D-02, -.9134D-02, -.9831D-02, -.1017D-01, -.1010D-01,
     >    -.9280D-02, -.7456D-02, -.4522D-02, -.5274D-03, 0.3977D-02,
     >    0.7644D-02, 0.8816D-02, 0.5388D-02, -.3332D-02, -.1483D-01,
     >    -.2478D-01, -.2863D-01, -.2489D-01, -.1552D-01, -.4146D-02,
     >    0.6172D-02, 0.1378D-01, 0.1835D-01, 0.2029D-01, 0.2033D-01,
     >    0.1912D-01, 0.1722D-01, 0.1502D-01, 0.1278D-01, 0.1068D-01,
     >    0.8782D-02, 0.7130D-02, 0.5725D-02, 0.4553D-02, 0.3590D-02,
     >    0.2811D-02, 0.2186D-02, 0.1690D-02, 0.1299D-02, 0.9941D-03,
     >    0.7572D-03, 0.5743D-03, 0.4340D-03, 0.3268D-03, 0.2452D-03,
     >    0.1835D-03, 0.1368D-03, 0.1018D-03, 0.7550D-04, 0.5588D-04,
     >    0.4127D-04/

      data (calcpts(j,18), j = 1,neta) /-.1467D-03, -.1465D-03,
     >    -.2963D-03, -.2960D-03, -.2955D-03, -.4447D-03, -.5937D-03,
     >    -.5921D-03, -.7398D-03, -.8864D-03, -.1181D-02, -.1324D-02,
     >    -.1613D-02, -.1898D-02, -.2325D-02, -.2741D-02, -.3291D-02,
     >    -.3819D-02, -.4462D-02, -.5205D-02, -.6176D-02, -.7039D-02,
     >    -.7897D-02, -.8826D-02, -.9575D-02, -.9992D-02, -.1002D-01,
     >    -.9512D-02, -.8062D-02, -.5594D-02, -.2193D-02, 0.1706D-02,
     >    0.5020D-02, 0.6064D-02, 0.3033D-02, -.4576D-02, -.1507D-01,
     >    -.2416D-01, -.2776D-01, -.2419D-01, -.1519D-01, -.4142D-02,
     >    0.5976D-02, 0.1351D-01, 0.1805D-01, 0.2003D-01, 0.2009D-01,
     >    0.1892D-01, 0.1705D-01, 0.1489D-01, 0.1269D-01, 0.1061D-01,
     >    0.8730D-02, 0.7091D-02, 0.5696D-02, 0.4531D-02, 0.3575D-02,
     >    0.2799D-02, 0.2178D-02, 0.1683D-02, 0.1295D-02, 0.9910D-03,
     >    0.7550D-03, 0.5727D-03, 0.4329D-03, 0.3260D-03, 0.2446D-03,
     >    0.1830D-03, 0.1365D-03, 0.1016D-03, 0.7536D-04, 0.5579D-04,
     >    0.4120D-04/

      data (calcpts(j,19), j = 1,neta) /-.2090D-03, -.2088D-03,
     >    -.2086D-03, -.2083D-03, -.3578D-03, -.3571D-03, -.5061D-03,
     >    -.6547D-03, -.6525D-03, -.7993D-03, -.1095D-02, -.1238D-02,
     >    -.1528D-02, -.1813D-02, -.2092D-02, -.2510D-02, -.3064D-02,
     >    -.3595D-02, -.4245D-02, -.4999D-02, -.5684D-02, -.6569D-02,
     >    -.7458D-02, -.8283D-02, -.9099D-02, -.9764D-02, -.9935D-02,
     >    -.9630D-02, -.8473D-02, -.6571D-02, -.3899D-02, -.6442D-03,
     >    0.2218D-02, 0.3113D-02, 0.6896D-03, -.5955D-02, -.1509D-01,
     >    -.2328D-01, -.2662D-01, -.2333D-01, -.1482D-01, -.4195D-02,
     >    0.5655D-02, 0.1305D-01, 0.1759D-01, 0.1960D-01, 0.1974D-01,
     >    0.1863D-01, 0.1682D-01, 0.1472D-01, 0.1256D-01, 0.1051D-01,
     >    0.8655D-02, 0.7035D-02, 0.5655D-02, 0.4501D-02, 0.3553D-02,
     >    0.2784D-02, 0.2166D-02, 0.1676D-02, 0.1289D-02, 0.9868D-03,
     >    0.7519D-03, 0.5706D-03, 0.4312D-03, 0.3248D-03, 0.2438D-03,
     >    0.1824D-03, 0.1361D-03, 0.1013D-03, 0.7515D-04, 0.5564D-04,
     >    0.4110D-04/

      data (calcpts(j,20), j = 1,neta) /-.1704D-03, -.1703D-03,
     >    -.1701D-03, -.1698D-03, -.3194D-03, -.3188D-03, -.4679D-03,
     >    -.4665D-03, -.6145D-03, -.7616D-03, -.9074D-03, -.1051D-02,
     >    -.1342D-02, -.1629D-02, -.1909D-02, -.2330D-02, -.2737D-02,
     >    -.3275D-02, -.3784D-02, -.4550D-02, -.5253D-02, -.6015D-02,
     >    -.6793D-02, -.7677D-02, -.8426D-02, -.9065D-02, -.9413D-02,
     >    -.9366D-02, -.8727D-02, -.7347D-02, -.5105D-02, -.2548D-02,
     >    -.2590D-03, 0.4423D-03, -.1496D-02, -.6912D-02, -.1477D-01,
     >    -.2202D-01, -.2513D-01, -.2227D-01, -.1444D-01, -.4398D-02,
     >    0.5099D-02, 0.1237D-01, 0.1690D-01, 0.1899D-01, 0.1922D-01,
     >    0.1822D-01, 0.1651D-01, 0.1447D-01, 0.1237D-01, 0.1037D-01,
     >    0.8549D-02, 0.6956D-02, 0.5596D-02, 0.4459D-02, 0.3522D-02,
     >    0.2761D-02, 0.2149D-02, 0.1663D-02, 0.1280D-02, 0.9806D-03,
     >    0.7475D-03, 0.5674D-03, 0.4290D-03, 0.3232D-03, 0.2427D-03,
     >    0.1816D-03, 0.1355D-03, 0.1009D-03, 0.7488D-04, 0.5544D-04,
     >    0.4096D-04/

      data (calcpts(j,21), j = 1,neta) /-.9777D-04, -.9765D-04,
     >    -.2475D-03, -.2472D-03, -.2468D-03, -.3963D-03, -.3955D-03,
     >    -.5443D-03, -.5425D-03, -.6900D-03, -.8362D-03, -.9806D-03,
     >    -.1272D-02, -.1411D-02, -.1693D-02, -.2117D-02, -.2380D-02,
     >    -.2924D-02, -.3443D-02, -.3924D-02, -.4649D-02, -.5293D-02,
     >    -.6119D-02, -.6921D-02, -.7621D-02, -.8255D-02, -.8666D-02,
     >    -.8774D-02, -.8275D-02, -.7367D-02, -.5844D-02, -.3874D-02,
     >    -.1962D-02, -.1328D-02, -.2876D-02, -.7216D-02, -.1382D-01,
     >    -.2019D-01, -.2324D-01, -.2102D-01, -.1410D-01, -.4830D-02,
     >    0.4201D-02, 0.1132D-01, 0.1589D-01, 0.1810D-01, 0.1848D-01,
     >    0.1764D-01, 0.1604D-01, 0.1411D-01, 0.1210D-01, 0.1017D-01,
     >    0.8402D-02, 0.6848D-02, 0.5517D-02, 0.4401D-02, 0.3480D-02,
     >    0.2730D-02, 0.2128D-02, 0.1649D-02, 0.1269D-02, 0.9725D-03,
     >    0.7418D-03, 0.5633D-03, 0.4261D-03, 0.3212D-03, 0.2412D-03,
     >    0.1805D-03, 0.1348D-03, 0.1003D-03, 0.7450D-04, 0.5519D-04,
     >    0.4077D-04/

      data (calcpts(j,22), j = 1,neta) /-.1735D-03, -.1734D-03,
     >    -.1732D-03, -.1730D-03, -.1727D-03, -.3222D-03, -.3215D-03,
     >    -.4705D-03, -.4690D-03, -.6168D-03, -.7635D-03, -.9088D-03,
     >    -.1052D-02, -.1192D-02, -.1476D-02, -.1754D-02, -.2022D-02,
     >    -.2424D-02, -.2805D-02, -.3302D-02, -.3902D-02, -.4582D-02,
     >    -.5160D-02, -.5890D-02, -.6402D-02, -.7051D-02, -.7399D-02,
     >    -.7551D-02, -.7244D-02, -.6584D-02, -.5435D-02, -.3748D-02,
     >    -.2404D-02, -.1634D-02, -.2806D-02, -.6324D-02, -.1186D-01,
     >    -.1759D-01, -.2080D-01, -.1952D-01, -.1382D-01, -.5557D-02,
     >    0.2891D-02, 0.9818D-02, 0.1445D-01, 0.1684D-01, 0.1745D-01,
     >    0.1682D-01, 0.1542D-01, 0.1364D-01, 0.1175D-01, 0.9902D-02,
     >    0.8205D-02, 0.6703D-02, 0.5412D-02, 0.4324D-02, 0.3423D-02,
     >    0.2689D-02, 0.2099D-02, 0.1627D-02, 0.1254D-02, 0.9617D-03,
     >    0.7340D-03, 0.5578D-03, 0.4222D-03, 0.3184D-03, 0.2392D-03,
     >    0.1791D-03, 0.1338D-03, 0.9964D-04, 0.7402D-04, 0.5483D-04,
     >    0.4054D-04/

      data (calcpts(j,23), j = 1,neta) /-.1129D-03, -.1128D-03,
     >    -.1127D-03, -.1125D-03, -.1122D-03, -.2618D-03, -.2612D-03,
     >    -.2604D-03, -.4091D-03, -.4073D-03, -.5546D-03, -.7007D-03,
     >    -.8449D-03, -.9864D-03, -.1124D-02, -.1406D-02, -.1679D-02,
     >    -.1939D-02, -.2331D-02, -.2697D-02, -.3172D-02, -.3590D-02,
     >    -.4073D-02, -.4583D-02, -.5063D-02, -.5583D-02, -.5880D-02,
     >    -.5942D-02, -.5700D-02, -.5019D-02, -.3989D-02, -.2646D-02,
     >    -.1380D-02, -.6668D-03, -.1348D-02, -.4099D-02, -.8787D-02,
     >    -.1408D-01, -.1771D-01, -.1766D-01, -.1350D-01, -.6539D-02,
     >    0.1131D-02, 0.7788D-02, 0.1250D-01, 0.1516D-01, 0.1607D-01,
     >    0.1573D-01, 0.1458D-01, 0.1301D-01, 0.1127D-01, 0.9550D-02,
     >    0.7946D-02, 0.6514D-02, 0.5274D-02, 0.4223D-02, 0.3352D-02,
     >    0.2638D-02, 0.2061D-02, 0.1599D-02, 0.1235D-02, 0.9479D-03,
     >    0.7242D-03, 0.5508D-03, 0.4171D-03, 0.3147D-03, 0.2367D-03,
     >    0.1774D-03, 0.1326D-03, 0.9877D-04, 0.7339D-04, 0.5439D-04,
     >    0.4023D-04/

      data (calcpts(j,24), j = 1,neta) /-.6910D-04, -.6903D-04,
     >    -.9893D-04, -.1138D-03, -.1286D-03, -.1583D-03, -.2028D-03,
     >    -.2471D-03, -.2911D-03, -.3496D-03, -.4225D-03, -.5093D-03,
     >    -.6097D-03, -.7229D-03, -.8780D-03, -.1043D-02, -.1247D-02,
     >    -.1470D-02, -.1739D-02, -.2031D-02, -.2367D-02, -.2716D-02,
     >    -.3103D-02, -.3481D-02, -.3821D-02, -.4103D-02, -.4266D-02,
     >    -.4227D-02, -.3915D-02, -.3268D-02, -.2253D-02, -.9436D-03,
     >    0.4012D-03, 0.1290D-02, 0.1046D-02, -.9929D-03, -.4925D-02,
     >    -.9856D-02, -.1397D-01, -.1528D-01, -.1294D-01, -.7601D-02,
     >    -.9618D-03, 0.5278D-02, 0.1004D-01, 0.1299D-01, 0.1429D-01,
     >    0.1432D-01, 0.1350D-01, 0.1220D-01, 0.1067D-01, 0.9105D-02,
     >    0.7620D-02, 0.6276D-02, 0.5100D-02, 0.4098D-02, 0.3261D-02,
     >    0.2573D-02, 0.2015D-02, 0.1566D-02, 0.1211D-02, 0.9308D-03,
     >    0.7119D-03, 0.5422D-03, 0.4110D-03, 0.3105D-03, 0.2336D-03,
     >    0.1753D-03, 0.1310D-03, 0.9769D-04, 0.7262D-04, 0.5386D-04,
     >    0.3984D-04/

      data (calcpts(j,25), j = 1,neta) /-.4463D-04, -.5957D-04,
     >    -.7450D-04, -.8938D-04, -.1042D-03, -.1190D-03, -.1486D-03,
     >    -.1781D-03, -.2073D-03, -.2512D-03, -.3095D-03, -.3671D-03,
     >    -.4385D-03, -.5383D-03, -.6356D-03, -.7593D-03, -.8927D-03,
     >    -.1063D-02, -.1253D-02, -.1455D-02, -.1694D-02, -.1941D-02,
     >    -.2196D-02, -.2435D-02, -.2639D-02, -.2786D-02, -.2809D-02,
     >    -.2651D-02, -.2252D-02, -.1543D-02, -.5098D-03, 0.8178D-03,
     >    0.2215D-02, 0.3330D-02, 0.3531D-02, 0.2191D-02, -.9599D-03,
     >    -.5427D-02, -.9834D-02, -.1238D-01, -.1187D-01, -.8389D-02,
     >    -.3088D-02, 0.2501D-02, 0.7192D-02, 0.1042D-01, 0.1214D-01,
     >    0.1261D-01, 0.1219D-01, 0.1120D-01, 0.9929D-02, 0.8561D-02,
     >    0.7221D-02, 0.5986D-02, 0.4890D-02, 0.3947D-02, 0.3152D-02,
     >    0.2494D-02, 0.1957D-02, 0.1526D-02, 0.1182D-02, 0.9102D-03,
     >    0.6974D-03, 0.5317D-03, 0.4036D-03, 0.3053D-03, 0.2299D-03,
     >    0.1726D-03, 0.1292D-03, 0.9638D-04, 0.7171D-04, 0.5322D-04,
     >    0.3940D-04/

      data (calcpts(j,26), j = 1,neta) /-.2966D-04, -.2962D-04,
     >    -.4456D-04, -.4447D-04, -.5935D-04, -.7417D-04, -.8890D-04,
     >    -.1185D-03, -.1329D-03, -.1621D-03, -.2058D-03, -.2490D-03,
     >    -.3063D-03, -.3624D-03, -.4316D-03, -.5132D-03, -.6057D-03,
     >    -.7225D-03, -.8457D-03, -.9865D-03, -.1139D-02, -.1295D-02,
     >    -.1441D-02, -.1591D-02, -.1687D-02, -.1708D-02, -.1632D-02,
     >    -.1397D-02, -.9495D-03, -.2161D-03, 0.8048D-03, 0.2109D-02,
     >    0.3533D-02, 0.4767D-02, 0.5314D-02, 0.4615D-02, 0.2265D-02,
     >    -.1537D-02, -.5856D-02, -.9181D-02, -.1023D-01, -.8583D-02,
     >    -.4844D-02, -.1984D-03, 0.4188D-02, 0.7570D-02, 0.9685D-02,
     >    0.1062D-01, 0.1064D-01, 0.1003D-01, 0.9054D-02, 0.7917D-02,
     >    0.6752D-02, 0.5644D-02, 0.4644D-02, 0.3768D-02, 0.3024D-02,
     >    0.2402D-02, 0.1891D-02, 0.1479D-02, 0.1148D-02, 0.8863D-03,
     >    0.6802D-03, 0.5196D-03, 0.3951D-03, 0.2992D-03, 0.2257D-03,
     >    0.1695D-03, 0.1270D-03, 0.9488D-04, 0.7065D-04, 0.5247D-04,
     >    0.3887D-04/

      data (calcpts(j,27), j = 1,neta) /-.3332D-04, -.3329D-04,
     >    -.4825D-04, -.4819D-04, -.6309D-04, -.6296D-04, -.7777D-04,
     >    -.9248D-04, -.1071D-03, -.1364D-03, -.1505D-03, -.1792D-03,
     >    -.2222D-03, -.2494D-03, -.3051D-03, -.3589D-03, -.4248D-03,
     >    -.4865D-03, -.5719D-03, -.6482D-03, -.7412D-03, -.8295D-03,
     >    -.9192D-03, -.9822D-03, -.9994D-03, -.9586D-03, -.8365D-03,
     >    -.5633D-03, -.9504D-04, 0.5896D-03, 0.1553D-02, 0.2755D-02,
     >    0.4087D-02, 0.5337D-02, 0.6085D-02, 0.5854D-02, 0.4228D-02,
     >    0.1195D-02, -.2655D-02, -.6188D-02, -.8228D-02, -.8095D-02,
     >    -.5908D-02, -.2429D-02, 0.1368D-02, 0.4683D-02, 0.7072D-02,
     >    0.8434D-02, 0.8900D-02, 0.8695D-02, 0.8056D-02, 0.7179D-02,
     >    0.6213D-02, 0.5253D-02, 0.4361D-02, 0.3564D-02, 0.2877D-02,
     >    0.2297D-02, 0.1817D-02, 0.1425D-02, 0.1110D-02, 0.8591D-03,
     >    0.6609D-03, 0.5058D-03, 0.3854D-03, 0.2922D-03, 0.2208D-03,
     >    0.1661D-03, 0.1246D-03, 0.9317D-04, 0.6945D-04, 0.5163D-04,
     >    0.3828D-04/

      data (calcpts(j,28), j = 1,neta) /-.1367D-04, -.1365D-04,
     >    -.2862D-04, -.2858D-04, -.2851D-04, -.4342D-04, -.4328D-04,
     >    -.5807D-04, -.7277D-04, -.7232D-04, -.1017D-03, -.1157D-03,
     >    -.1293D-03, -.1572D-03, -.1842D-03, -.2248D-03, -.2633D-03,
     >    -.2987D-03, -.3447D-03, -.3991D-03, -.4439D-03, -.4897D-03,
     >    -.5300D-03, -.5403D-03, -.5221D-03, -.4407D-03, -.2989D-03,
     >    -.2706D-04, 0.3975D-03, 0.1014D-02, 0.1850D-02, 0.2886D-02,
     >    0.4067D-02, 0.5210D-02, 0.6002D-02, 0.6036D-02, 0.4981D-02,
     >    0.2682D-02, -.5298D-03, -.3840D-02, -.6280D-02, -.7128D-02,
     >    -.6212D-02, -.3917D-02, -.9303D-03, 0.2049D-02, 0.4500D-02,
     >    0.6172D-02, 0.7042D-02, 0.7241D-02, 0.6951D-02, 0.6357D-02,
     >    0.5610D-02, 0.4815D-02, 0.4043D-02, 0.3336D-02, 0.2713D-02,
     >    0.2179D-02, 0.1734D-02, 0.1365D-02, 0.1067D-02, 0.8287D-03,
     >    0.6394D-03, 0.4906D-03, 0.3745D-03, 0.2845D-03, 0.2153D-03,
     >    0.1623D-03, 0.1219D-03, 0.9126D-04, 0.6811D-04, 0.5068D-04,
     >    0.3761D-04/

      data (calcpts(j,29), j = 1,neta) /0.8002D-06, -.1419D-04,
     >    -.1416D-04, -.1413D-04, -.1409D-04, -.1402D-04, -.2892D-04,
     >    -.2877D-04, -.2856D-04, -.4325D-04, -.5778D-04, -.5711D-04,
     >    -.7112D-04, -.8466D-04, -.1125D-03, -.1244D-03, -.1498D-03,
     >    -.1730D-03, -.1931D-03, -.2236D-03, -.2473D-03, -.2610D-03,
     >    -.2753D-03, -.2534D-03, -.2158D-03, -.1335D-03, 0.2768D-04,
     >    0.2657D-03, 0.6328D-03, 0.1148D-02, 0.1843D-02, 0.2699D-02,
     >    0.3677D-02, 0.4635D-02, 0.5363D-02, 0.5530D-02, 0.4838D-02,
     >    0.3127D-02, 0.5668D-03, -.2303D-02, -.4731D-02, -.6054D-02,
     >    -.5981D-02, -.4655D-02, -.2514D-02, -.7367D-04, 0.2202D-02,
     >    0.3995D-02, 0.5164D-02, 0.5717D-02, 0.5769D-02, 0.5467D-02,
     >    0.4952D-02, 0.4334D-02, 0.3695D-02, 0.3085D-02, 0.2533D-02,
     >    0.2051D-02, 0.1640D-02, 0.1300D-02, 0.1021D-02, 0.7954D-03,
     >    0.6157D-03, 0.4738D-03, 0.3626D-03, 0.2761D-03, 0.2094D-03,
     >    0.1580D-03, 0.1189D-03, 0.8917D-04, 0.6664D-04, 0.4965D-04,
     >    0.3688D-04/

      data (calcpts(j,30), j = 1,neta) /0.2726D-05, -.1226D-04,
     >    -.1225D-04, -.1223D-04, -.1219D-04, -.1215D-04, -.1208D-04,
     >    -.1198D-04, -.2683D-04, -.2661D-04, -.2628D-04, -.4081D-04,
     >    -.4012D-04, -.5410D-04, -.6761D-04, -.6541D-04, -.7719D-04,
     >    -.1025D-03, -.1105D-03, -.1154D-03, -.1305D-03, -.1237D-03,
     >    -.1217D-03, -.8993D-04, -.5168D-04, 0.3277D-04, 0.1769D-03,
     >    0.3852D-03, 0.6838D-03, 0.1107D-02, 0.1652D-02, 0.2325D-02,
     >    0.3112D-02, 0.3884D-02, 0.4477D-02, 0.4672D-02, 0.4216D-02,
     >    0.2951D-02, 0.9433D-03, -.1449D-02, -.3665D-02, -.5139D-02,
     >    -.5535D-02, -.4866D-02, -.3416D-02, -.1555D-02, 0.3704D-03,
     >    0.2080D-02, 0.3384D-02, 0.4200D-02, 0.4549D-02, 0.4527D-02,
     >    0.4248D-02, 0.3816D-02, 0.3319D-02, 0.2814D-02, 0.2337D-02,
     >    0.1910D-02, 0.1540D-02, 0.1228D-02, 0.9698D-03, 0.7593D-03,
     >    0.5900D-03, 0.4556D-03, 0.3496D-03, 0.2670D-03, 0.2029D-03,
     >    0.1536D-03, 0.1157D-03, 0.8690D-04, 0.6504D-04, 0.4852D-04,
     >    0.3610D-04/

      data (calcpts(j,31), j = 1,neta) /0.1204D-05, 0.1211D-05,
     >    0.1222D-05, 0.1237D-05, 0.1259D-05, -.1371D-04, -.1366D-04,
     >    -.1359D-04, -.1349D-04, -.1333D-04, -.1311D-04, -.1278D-04,
     >    -.2730D-04, -.2659D-04, -.2556D-04, -.3904D-04, -.3680D-04,
     >    -.4853D-04, -.4372D-04, -.5167D-04, -.5635D-04, -.4120D-04,
     >    -.3402D-04, -.1605D-05, 0.4573D-04, 0.1297D-03, 0.2447D-03,
     >    0.4041D-03, 0.6562D-03, 0.9796D-03, 0.1404D-02, 0.1920D-02,
     >    0.2519D-02, 0.3115D-02, 0.3590D-02, 0.3764D-02, 0.3443D-02,
     >    0.2495D-02, 0.9307D-03, -.1023D-02, -.2965D-02, -.4429D-02,
     >    -.5075D-02, -.4820D-02, -.3847D-02, -.2457D-02, -.9175D-03,
     >    0.5657D-03, 0.1835D-02, 0.2778D-02, 0.3347D-02, 0.3567D-02,
     >    0.3512D-02, 0.3267D-02, 0.2916D-02, 0.2522D-02, 0.2127D-02,
     >    0.1761D-02, 0.1433D-02, 0.1152D-02, 0.9153D-03, 0.7205D-03,
     >    0.5625D-03, 0.4360D-03, 0.3358D-03, 0.2572D-03, 0.1960D-03,
     >    0.1486D-03, 0.1123D-03, 0.8446D-04, 0.6331D-04, 0.4732D-04,
     >    0.3525D-04/

      data (calcpts(j,32), j = 1,neta) /-.4108D-06, -.4060D-06,
     >    -.3988D-06, -.3883D-06, -.1873D-05, -.1850D-05, -.3317D-05,
     >    -.3268D-05, -.4697D-05, -.6092D-05, -.7438D-05, -.8712D-05,
     >    -.9880D-05, -.1089D-04, -.1318D-04, -.1513D-04, -.1659D-04,
     >    -.1733D-04, -.1702D-04, -.1515D-04, -.9533D-05, 0.9116D-06,
     >    0.1771D-04, 0.4607D-04, 0.8921D-04, 0.1533D-03, 0.2492D-03,
     >    0.3834D-03, 0.5712D-03, 0.8215D-03, 0.1145D-02, 0.1540D-02,
     >    0.1985D-02, 0.2433D-02, 0.2792D-02, 0.2929D-02, 0.2695D-02,
     >    0.1979D-02, 0.7654D-03, -.8107D-03, -.2468D-02, -.3849D-02,
     >    -.4632D-02, -.4666D-02, -.4031D-02, -.2965D-02, -.1732D-02,
     >    -.5033D-03, 0.6184D-03, 0.1553D-02, 0.2232D-02, 0.2630D-02,
     >    0.2766D-02, 0.2698D-02, 0.2493D-02, 0.2213D-02, 0.1905D-02,
     >    0.1600D-02, 0.1319D-02, 0.1070D-02, 0.8571D-03, 0.6791D-03,
     >    0.5331D-03, 0.4152D-03, 0.3211D-03, 0.2467D-03, 0.1886D-03,
     >    0.1434D-03, 0.1086D-03, 0.8187D-04, 0.6149D-04, 0.4602D-04,
     >    0.3434D-04/

      data (calcpts(j,33), j = 1,neta) /-.1502D-05, -.1499D-05,
     >    -.1494D-05, -.2987D-05, -.2976D-05, -.2960D-05, -.2938D-05,
     >    -.2904D-05, -.2855D-05, -.4283D-05, -.4177D-05, -.4021D-05,
     >    -.5293D-05, -.4958D-05, -.5967D-05, -.5246D-05, -.5687D-05,
     >    -.4135D-05, -.1857D-05, 0.2986D-05, 0.9379D-05, 0.1956D-04,
     >    0.3607D-04, 0.6194D-04, 0.9788D-04, 0.1516D-03, 0.2260D-03,
     >    0.3319D-03, 0.4751D-03, 0.6637D-03, 0.9059D-03, 0.1200D-02,
     >    0.1530D-02, 0.1861D-02, 0.2124D-02, 0.2225D-02, 0.2050D-02,
     >    0.1508D-02, 0.5710D-03, -.6807D-03, -.2063D-02, -.3315D-02,
     >    -.4162D-02, -.4421D-02, -.4069D-02, -.3260D-02, -.2236D-02,
     >    -.1198D-02, -.2422D-03, 0.5943D-03, 0.1277D-02, 0.1765D-02,
     >    0.2043D-02, 0.2126D-02, 0.2058D-02, 0.1891D-02, 0.1669D-02,
     >    0.1431D-02, 0.1198D-02, 0.9835D-03, 0.7955D-03, 0.6352D-03,
     >    0.5020D-03, 0.3931D-03, 0.3054D-03, 0.2357D-03, 0.1807D-03,
     >    0.1379D-03, 0.1047D-03, 0.7910D-04, 0.5955D-04, 0.4466D-04,
     >    0.3338D-04/

      data (calcpts(j,34), j = 1,neta) /-.6676D-06, -.6653D-06,
     >    -.6619D-06, -.6570D-06, -.6497D-06, -.6391D-06, -.6234D-06,
     >    -.6005D-06, -.5668D-06, -.5174D-06, -.4448D-06, -.3383D-06,
     >    -.1820D-06, 0.4757D-07, 0.3840D-06, 0.8782D-06, 0.3104D-05,
     >    0.5667D-05, 0.8728D-05, 0.1252D-04, 0.2037D-04, 0.2979D-04,
     >    0.4449D-04, 0.6552D-04, 0.9590D-04, 0.1378D-03, 0.1958D-03,
     >    0.2772D-03, 0.3849D-03, 0.5267D-03, 0.7048D-03, 0.9213D-03,
     >    0.1163D-02, 0.1404D-02, 0.1595D-02, 0.1666D-02, 0.1531D-02,
     >    0.1122D-02, 0.4051D-03, -.5752D-03, -.1702D-02, -.2792D-02,
     >    -.3638D-02, -.4057D-02, -.3963D-02, -.3408D-02, -.2568D-02,
     >    -.1655D-02, -.8125D-03, -.8359D-04, 0.5332D-03, 0.1029D-02,
     >    0.1379D-02, 0.1572D-02, 0.1621D-02, 0.1560D-02, 0.1425D-02,
     >    0.1253D-02, 0.1070D-02, 0.8921D-03, 0.7305D-03, 0.5890D-03,
     >    0.4691D-03, 0.3697D-03, 0.2889D-03, 0.2240D-03, 0.1725D-03,
     >    0.1320D-03, 0.1005D-03, 0.7618D-04, 0.5748D-04, 0.4321D-04,
     >    0.3237D-04/

      data (calcpts(j,35), j = 1,neta) /0.5347D-06, 0.5363D-06,
     >    0.5386D-06, 0.5419D-06, 0.5469D-06, 0.5542D-06, 0.5649D-06,
     >    0.5806D-06, 0.6036D-06, 0.6374D-06, 0.2187D-05, 0.2260D-05,
     >    0.2367D-05, 0.2524D-05, 0.4254D-05, 0.4592D-05, 0.6588D-05,
     >    0.8816D-05, 0.1288D-04, 0.1745D-04, 0.2274D-04, 0.3211D-04,
     >    0.4453D-04, 0.6073D-04, 0.8475D-04, 0.1181D-03, 0.1628D-03,
     >    0.2234D-03, 0.3054D-03, 0.4095D-03, 0.5410D-03, 0.6985D-03,
     >    0.8741D-03, 0.1048D-02, 0.1186D-02, 0.1233D-02, 0.1131D-02,
     >    0.8216D-03, 0.2791D-03, -.4777D-03, -.1375D-02, -.2291D-02,
     >    -.3077D-02, -.3580D-02, -.3695D-02, -.3395D-02, -.2766D-02,
     >    -.1979D-02, -.1205D-02, -.5397D-03, 0.7416D-05, 0.4582D-03,
     >    0.8161D-03, 0.1067D-02, 0.1201D-02, 0.1229D-02, 0.1175D-02,
     >    0.1069D-02, 0.9362D-03, 0.7963D-03, 0.6621D-03, 0.5404D-03,
     >    0.4347D-03, 0.3453D-03, 0.2716D-03, 0.2118D-03, 0.1638D-03,
     >    0.1259D-03, 0.9621D-04, 0.7313D-04, 0.5534D-04, 0.4170D-04,
     >    0.3129D-04/

      data (calcpts(j,36), j = 1,neta) /-.1272D-06, -.1261D-06,
     >    -.1245D-06, -.1222D-06, -.1188D-06, -.1139D-06, 0.1393D-05,
     >    0.1404D-05, 0.1420D-05, 0.1443D-05, 0.1477D-05, 0.1527D-05,
     >    0.3100D-05, 0.3207D-05, 0.4864D-05, 0.5095D-05, 0.6934D-05,
     >    0.8931D-05, 0.1266D-04, 0.1673D-04, 0.2130D-04, 0.2960D-04,
     >    0.3896D-04, 0.5288D-04, 0.7206D-04, 0.9603D-04, 0.1307D-03,
     >    0.1766D-03, 0.2366D-03, 0.3126D-03, 0.4092D-03, 0.5243D-03,
     >    0.6506D-03, 0.7755D-03, 0.8721D-03, 0.9047D-03, 0.8264D-03,
     >    0.5968D-03, 0.1887D-03, -.3877D-03, -.1088D-02, -.1834D-02,
     >    -.2521D-02, -.3038D-02, -.3286D-02, -.3207D-02, -.2811D-02,
     >    -.2193D-02, -.1499D-02, -.8651D-03, -.3506D-03, 0.5516D-04,
     >    0.3822D-03, 0.6395D-03, 0.8182D-03, 0.9113D-03, 0.9262D-03,
     >    0.8813D-03, 0.7983D-03, 0.6966D-03, 0.5905D-03, 0.4894D-03,
     >    0.3984D-03, 0.3197D-03, 0.2535D-03, 0.1989D-03, 0.1548D-03,
     >    0.1195D-03, 0.9167D-04, 0.6994D-04, 0.5308D-04, 0.4011D-04,
     >    0.3018D-04/

      data (calcpts(j,37), j = 1,neta) /-.3661D-07, -.3588D-07,
     >    -.3480D-07, -.3323D-07, -.3091D-07, -.2751D-07, 0.1477D-05,
     >    0.1485D-05, 0.1496D-05, 0.1511D-05, 0.1534D-05, 0.1568D-05,
     >    0.3118D-05, 0.3191D-05, 0.4799D-05, 0.4956D-05, 0.6688D-05,
     >    0.8527D-05, 0.1202D-04, 0.1426D-04, 0.1982D-04, 0.2589D-04,
     >    0.3269D-04, 0.4355D-04, 0.5745D-04, 0.7660D-04, 0.1035D-03,
     >    0.1364D-03, 0.1804D-03, 0.2378D-03, 0.3072D-03, 0.3892D-03,
     >    0.4797D-03, 0.5693D-03, 0.6385D-03, 0.6609D-03, 0.6013D-03,
     >    0.4300D-03, 0.1266D-03, -.3072D-03, -.8445D-03, -.1435D-02,
     >    -.2010D-02, -.2491D-02, -.2801D-02, -.2875D-02, -.2689D-02,
     >    -.2270D-02, -.1706D-02, -.1120D-02, -.6135D-03, -.2218D-03,
     >    0.7605D-04, 0.3118D-03, 0.4963D-03, 0.6232D-03, 0.6876D-03,
     >    0.6946D-03, 0.6579D-03, 0.5936D-03, 0.5163D-03, 0.4364D-03,
     >    0.3607D-03, 0.2929D-03, 0.2344D-03, 0.1855D-03, 0.1452D-03,
     >    0.1128D-03, 0.8695D-04, 0.6660D-04, 0.5073D-04, 0.3844D-04,
     >    0.2901D-04/

      data (calcpts(j,38), j = 1,neta) /0.4340D-06, 0.4345D-06,
     >    0.4352D-06, 0.5863D-06, 0.5879D-06, 0.7402D-06, 0.8936D-06,
     >    0.1049D-05, 0.1206D-05, 0.1517D-05, 0.1832D-05, 0.2156D-05,
     >    0.2640D-05, 0.3290D-05, 0.4113D-05, 0.5120D-05, 0.6328D-05,
     >    0.7909D-05, 0.1005D-04, 0.1265D-04, 0.1623D-04, 0.2090D-04,
     >    0.2711D-04, 0.3525D-04, 0.4610D-04, 0.6057D-04, 0.7963D-04,
     >    0.1045D-03, 0.1369D-03, 0.1778D-03, 0.2282D-03, 0.2876D-03,
     >    0.3529D-03, 0.4165D-03, 0.4653D-03, 0.4797D-03, 0.4353D-03,
     >    0.3089D-03, 0.8466D-04, -.2385D-03, -.6450D-03, -.1103D-02,
     >    -.1567D-02, -.1985D-02, -.2300D-02, -.2460D-02, -.2429D-02,
     >    -.2195D-02, -.1796D-02, -.1306D-02, -.8268D-03, -.4301D-03,
     >    -.1358D-03, 0.8103D-04, 0.2500D-03, 0.3818D-03, 0.4719D-03,
     >    0.5163D-03, 0.5186D-03, 0.4891D-03, 0.4398D-03, 0.3814D-03,
     >    0.3214D-03, 0.2650D-03, 0.2148D-03, 0.1714D-03, 0.1354D-03,
     >    0.1058D-03, 0.8203D-04, 0.6313D-04, 0.4828D-04, 0.3672D-04,
     >    0.2779D-04/

      data (calcpts(j,39), j = 1,neta) /0.5623D-07, 0.5657D-07,
     >    0.2071D-06, 0.2078D-06, 0.3589D-06, 0.3605D-06, 0.5128D-06,
     >    0.6662D-06, 0.8212D-06, 0.9785D-06, 0.1289D-05, 0.1605D-05,
     >    0.2078D-05, 0.2562D-05, 0.3212D-05, 0.4036D-05, 0.5043D-05,
     >    0.6251D-05, 0.7983D-05, 0.1012D-04, 0.1287D-04, 0.1645D-04,
     >    0.2127D-04, 0.2748D-04, 0.3561D-04, 0.4644D-04, 0.6040D-04,
     >    0.7877D-04, 0.1022D-03, 0.1320D-03, 0.1684D-03, 0.2110D-03,
     >    0.2576D-03, 0.3029D-03, 0.3373D-03, 0.3468D-03, 0.3138D-03,
     >    0.2211D-03, 0.5647D-04, -.1822D-03, -.4860D-03, -.8348D-03,
     >    -.1199D-02, -.1545D-02, -.1832D-02, -.2025D-02, -.2087D-02,
     >    -.1997D-02, -.1755D-02, -.1398D-02, -.9886D-03, -.6044D-03,
     >    -.2986D-03, -.7958D-04, 0.7717D-04, 0.1978D-03, 0.2916D-03,
     >    0.3554D-03, 0.3859D-03, 0.3857D-03, 0.3623D-03, 0.3247D-03,
     >    0.2808D-03, 0.2361D-03, 0.1942D-03, 0.1570D-03, 0.1251D-03,
     >    0.9858D-04, 0.7692D-04, 0.5953D-04, 0.4575D-04, 0.3493D-04,
     >    0.2653D-04/

      data (calcpts(j,40), j = 1,neta) /0.5510D-07, 0.2053D-06,
     >    0.2057D-06, 0.2062D-06, 0.3569D-06, 0.3580D-06, 0.5096D-06,
     >    0.6619D-06, 0.8153D-06, 0.9703D-06, 0.1128D-05, 0.1438D-05,
     >    0.1754D-05, 0.2227D-05, 0.2711D-05, 0.3361D-05, 0.4185D-05,
     >    0.5192D-05, 0.6400D-05, 0.8132D-05, 0.1027D-04, 0.1302D-04,
     >    0.1660D-04, 0.2126D-04, 0.2732D-04, 0.3528D-04, 0.4562D-04,
     >    0.5906D-04, 0.7606D-04, 0.9755D-04, 0.1236D-03, 0.1542D-03,
     >    0.1874D-03, 0.2196D-03, 0.2437D-03, 0.2500D-03, 0.2255D-03,
     >    0.1579D-03, 0.3784D-04, -.1373D-03, -.3623D-03, -.6244D-03,
     >    -.9049D-03, -.1181D-02, -.1427D-02, -.1616D-02, -.1722D-02,
     >    -.1723D-02, -.1607D-02, -.1381D-02, -.1074D-02, -.7406D-03,
     >    -.4383D-03, -.2052D-03, -.4368D-04, 0.6896D-04, 0.1547D-03,
     >    0.2212D-03, 0.2663D-03, 0.2872D-03, 0.2859D-03, 0.2676D-03,
     >    0.2391D-03, 0.2061D-03, 0.1729D-03, 0.1419D-03, 0.1145D-03,
     >    0.9106D-04, 0.7162D-04, 0.5580D-04, 0.4311D-04, 0.3307D-04,
     >    0.2523D-04/

      data (calcpts(j,41), j = 1,neta) /0.1538D-06, 0.1540D-06,
     >    0.1542D-06, 0.3046D-06, 0.3051D-06, 0.4558D-06, 0.4569D-06,
     >    0.6085D-06, 0.6108D-06, 0.7642D-06, 0.9192D-06, 0.1227D-05,
     >    0.1387D-05, 0.1853D-05, 0.2176D-05, 0.2660D-05, 0.3310D-05,
     >    0.4134D-05, 0.5141D-05, 0.6349D-05, 0.8080D-05, 0.1007D-04,
     >    0.1282D-04, 0.1624D-04, 0.2075D-04, 0.2664D-04, 0.3413D-04,
     >    0.4397D-04, 0.5625D-04, 0.7167D-04, 0.9044D-04, 0.1121D-03,
     >    0.1358D-03, 0.1586D-03, 0.1756D-03, 0.1796D-03, 0.1617D-03,
     >    0.1126D-03, 0.2545D-04, -.1023D-03, -.2677D-03, -.4625D-03,
     >    -.6750D-03, -.8898D-03, -.1090D-02, -.1259D-02, -.1376D-02,
     >    -.1426D-02, -.1393D-02, -.1273D-02, -.1072D-02, -.8171D-03,
     >    -.5502D-03, -.3156D-03, -.1398D-03, -.2141D-04, 0.5911D-04,
     >    0.1198D-03, 0.1670D-03, 0.1987D-03, 0.2130D-03, 0.2110D-03,
     >    0.1969D-03, 0.1755D-03, 0.1509D-03, 0.1263D-03, 0.1034D-03,
     >    0.8329D-04, 0.6615D-04, 0.5193D-04, 0.4039D-04, 0.3117D-04,
     >    0.2388D-04/

      data (calcpts(j,42), j = 1,neta) /0.1268D-06, 0.1269D-06,
     >    0.1271D-06, 0.1273D-06, 0.2777D-06, 0.2782D-06, 0.2789D-06,
     >    0.4300D-06, 0.5816D-06, 0.5839D-06, 0.7373D-06, 0.8923D-06,
     >    0.1050D-05, 0.1360D-05, 0.1676D-05, 0.1999D-05, 0.2484D-05,
     >    0.3133D-05, 0.3957D-05, 0.4814D-05, 0.6172D-05, 0.7603D-05,
     >    0.9741D-05, 0.1219D-04, 0.1561D-04, 0.1981D-04, 0.2539D-04,
     >    0.3239D-04, 0.4125D-04, 0.5232D-04, 0.6577D-04, 0.8122D-04,
     >    0.9796D-04, 0.1141D-03, 0.1261D-03, 0.1287D-03, 0.1156D-03,
     >    0.8019D-04, 0.1712D-04, -.7555D-04, -.1962D-03, -.3400D-03,
     >    -.4988D-03, -.6630D-03, -.8216D-03, -.9624D-03, -.1073D-02,
     >    -.1142D-02, -.1157D-02, -.1108D-02, -.9944D-03, -.8232D-03,
     >    -.6161D-03, -.4059D-03, -.2258D-03, -.9430D-04, -.8106D-05,
     >    0.4920D-04, 0.9207D-04, 0.1254D-03, 0.1477D-03, 0.1575D-03,
     >    0.1554D-03, 0.1445D-03, 0.1285D-03, 0.1102D-03, 0.9204D-04,
     >    0.7524D-04, 0.6046D-04, 0.4794D-04, 0.3757D-04, 0.2919D-04,
     >    0.2248D-04/

      data (calcpts(j,43), j = 1,neta) /0.3333D-07, 0.3340D-07,
     >    0.1835D-06, 0.1837D-06, 0.1839D-06, 0.1842D-06, 0.3347D-06,
     >    0.3355D-06, 0.3366D-06, 0.4881D-06, 0.6405D-06, 0.6439D-06,
     >    0.7989D-06, 0.1106D-05, 0.1267D-05, 0.1583D-05, 0.1906D-05,
     >    0.2390D-05, 0.3040D-05, 0.3713D-05, 0.4571D-05, 0.5778D-05,
     >    0.7209D-05, 0.9196D-05, 0.1164D-04, 0.1475D-04, 0.1864D-04,
     >    0.2375D-04, 0.3010D-04, 0.3810D-04, 0.4761D-04, 0.5868D-04,
     >    0.7061D-04, 0.8200D-04, 0.9031D-04, 0.9201D-04, 0.8259D-04,
     >    0.5698D-04, 0.1157D-04, -.5540D-04, -.1431D-03, -.2484D-03,
     >    -.3660D-03, -.4896D-03, -.6121D-03, -.7254D-03, -.8216D-03,
     >    -.8921D-03, -.9283D-03, -.9227D-03, -.8695D-03, -.7683D-03,
     >    -.6264D-03, -.4612D-03, -.2978D-03, -.1608D-03, -.6301D-04,
     >    -.5616D-06, 0.4006D-04, 0.7022D-04, 0.9372D-04, 0.1094D-03,
     >    0.1160D-03, 0.1141D-03, 0.1058D-03, 0.9379D-04, 0.8031D-04,
     >    0.6693D-04, 0.5461D-04, 0.4381D-04, 0.3468D-04, 0.2715D-04,
     >    0.2104D-04/

      data (calcpts(j,44), j = 1,neta) /0.8178D-07, 0.9683D-07,
     >    0.1119D-06, 0.1270D-06, 0.1572D-06, 0.1724D-06, 0.2177D-06,
     >    0.2632D-06, 0.3090D-06, 0.3701D-06, 0.4466D-06, 0.5540D-06,
     >    0.6624D-06, 0.8174D-06, 0.9897D-06, 0.1210D-05, 0.1481D-05,
     >    0.1835D-05, 0.2259D-05, 0.2788D-05, 0.3462D-05, 0.4319D-05,
     >    0.5406D-05, 0.6791D-05, 0.8566D-05, 0.1082D-04, 0.1369D-04,
     >    0.1736D-04, 0.2194D-04, 0.2760D-04, 0.3441D-04, 0.4223D-04,
     >    0.5065D-04, 0.5868D-04, 0.6457D-04, 0.6569D-04, 0.5879D-04,
     >    0.4045D-04, 0.7843D-05, -.4037D-04, -.1038D-03, -.1805D-03,
     >    -.2670D-03, -.3590D-03, -.4519D-03, -.5404D-03, -.6195D-03,
     >    -.6833D-03, -.7262D-03, -.7420D-03, -.7260D-03, -.6746D-03,
     >    -.5881D-03, -.4730D-03, -.3430D-03, -.2173D-03, -.1139D-03,
     >    -.4169D-04, 0.3367D-05, 0.3205D-04, 0.5322D-04, 0.6976D-04,
     >    0.8076D-04, 0.8520D-04, 0.8352D-04, 0.7725D-04, 0.6834D-04,
     >    0.5838D-04, 0.4857D-04, 0.3955D-04, 0.3168D-04, 0.2505D-04,
     >    0.1957D-04/

      data (calcpts(j,45), j = 1,neta) /0.3399D-07, 0.4903D-07,
     >    0.4908D-07, 0.6415D-07, 0.9426D-07, 0.1094D-06, 0.1396D-06,
     >    0.1700D-06, 0.2155D-06, 0.2612D-06, 0.3223D-06, 0.3839D-06,
     >    0.4762D-06, 0.5846D-06, 0.7246D-06, 0.8820D-06, 0.1088D-05,
     >    0.1344D-05, 0.1652D-05, 0.2046D-05, 0.2546D-05, 0.3174D-05,
     >    0.3971D-05, 0.4982D-05, 0.6261D-05, 0.7899D-05, 0.9971D-05,
     >    0.1259D-04, 0.1587D-04, 0.1989D-04, 0.2474D-04, 0.3029D-04,
     >    0.3624D-04, 0.4189D-04, 0.4602D-04, 0.4677D-04, 0.4180D-04,
     >    0.2866D-04, 0.5308D-05, -.2928D-04, -.7499D-04, -.1305D-03,
     >    -.1937D-03, -.2616D-03, -.3313D-03, -.3991D-03, -.4619D-03,
     >    -.5157D-03, -.5569D-03, -.5813D-03, -.5850D-03, -.5648D-03,
     >    -.5184D-03, -.4467D-03, -.3548D-03, -.2537D-03, -.1578D-03,
     >    -.8039D-04, -.2727D-04, 0.5103D-05, 0.2530D-04, 0.4012D-04,
     >    0.5173D-04, 0.5943D-04, 0.6243D-04, 0.6099D-04, 0.5628D-04,
     >    0.4968D-04, 0.4236D-04, 0.3517D-04, 0.2860D-04, 0.2287D-04,
     >    0.1806D-04/

      data (calcpts(j,46), j = 1,neta) /0.2403D-07, 0.3905D-07,
     >    0.5409D-07, 0.5414D-07, 0.6921D-07, 0.8432D-07, 0.1145D-06,
     >    0.1297D-06, 0.1601D-06, 0.1906D-06, 0.2363D-06, 0.2974D-06,
     >    0.3589D-06, 0.4363D-06, 0.5447D-06, 0.6547D-06, 0.8120D-06,
     >    0.1003D-05, 0.1229D-05, 0.1522D-05, 0.1886D-05, 0.2341D-05,
     >    0.2923D-05, 0.3645D-05, 0.4581D-05, 0.5753D-05, 0.7236D-05,
     >    0.9121D-05, 0.1145D-04, 0.1432D-04, 0.1775D-04, 0.2168D-04,
     >    0.2590D-04, 0.2987D-04, 0.3277D-04, 0.3325D-04, 0.2967D-04,
     >    0.2028D-04, 0.3616D-05, -.2114D-04, -.5397D-04, -.9405D-04,
     >    -.1399D-03, -.1898D-03, -.2413D-03, -.2927D-03, -.3412D-03,
     >    -.3847D-03, -.4206D-03, -.4463D-03, -.4591D-03, -.4560D-03,
     >    -.4351D-03, -.3952D-03, -.3368D-03, -.2646D-03, -.1869D-03,
     >    -.1142D-03, -.5652D-04, -.1763D-04, 0.5553D-05, 0.1974D-04,
     >    0.3009D-04, 0.3822D-04, 0.4360D-04, 0.4561D-04, 0.4443D-04,
     >    0.4090D-04, 0.3603D-04, 0.3067D-04, 0.2542D-04, 0.2064D-04,
     >    0.1816D-04/

      data (calcpts(j,47), j = 1,neta) /0.3417D-07, 0.3418D-07,
     >    0.3421D-07, 0.4924D-07, 0.6429D-07, 0.6436D-07, 0.7947D-07,
     >    0.1096D-06, 0.1249D-06, 0.1552D-06, 0.1857D-06, 0.2314D-06,
     >    0.2775D-06, 0.3391D-06, 0.4014D-06, 0.4948D-06, 0.6048D-06,
     >    0.7472D-06, 0.9079D-06, 0.1119D-05, 0.1382D-05, 0.1716D-05,
     >    0.2140D-05, 0.2663D-05, 0.3339D-05, 0.4184D-05, 0.5248D-05,
     >    0.6591D-05, 0.8255D-05, 0.1029D-04, 0.1273D-04, 0.1550D-04,
     >    0.1847D-04, 0.2126D-04, 0.2327D-04, 0.2360D-04, 0.2103D-04,
     >    0.1434D-04, 0.2465D-05, -.1521D-04, -.3871D-04, -.6754D-04,
     >    -.1007D-03, -.1370D-03, -.1751D-03, -.2133D-03, -.2503D-03,
     >    -.2844D-03, -.3140D-03, -.3374D-03, -.3528D-03, -.3583D-03,
     >    -.3521D-03, -.3326D-03, -.2990D-03, -.2525D-03, -.1964D-03,
     >    -.1370D-03, -.8239D-04, -.3957D-04, -.1122D-04, 0.5333D-05,
     >    0.1525D-04, 0.2350D-04, 0.2827D-04, 0.3192D-04, 0.3325D-04,
     >    0.3231D-04, 0.3967D-04, 0.2610D-04, 0.2217D-04, 0.2139D-04,
     >    0.1488D-04/

      data (calcpts(j,48), j = 1,neta) /0.1551D-07, 0.3052D-07,
     >    0.3053D-07, 0.3056D-07, 0.4559D-07, 0.4564D-07, 0.6072D-07,
     >    0.7582D-07, 0.9098D-07, 0.1062D-06, 0.1366D-06, 0.1671D-06,
     >    0.1978D-06, 0.2439D-06, 0.2904D-06, 0.3678D-06, 0.4462D-06,
     >    0.5412D-06, 0.6685D-06, 0.8143D-06, 0.1010D-05, 0.1258D-05,
     >    0.1547D-05, 0.1926D-05, 0.2419D-05, 0.3019D-05, 0.3787D-05,
     >    0.4727D-05, 0.5913D-05, 0.7366D-05, 0.9086D-05, 0.1104D-04,
     >    0.1313D-04, 0.1509D-04, 0.1650D-04, 0.1671D-04, 0.1489D-04,
     >    0.1013D-04, 0.1680D-05, -.1091D-04, -.2770D-04, -.4837D-04,
     >    -.7228D-04, -.9860D-04, -.1264D-03, -.1548D-03, -.1824D-03,
     >    -.2087D-03, -.2323D-03, -.2522D-03, -.2670D-03, -.2758D-03,
     >    -.2771D-03, -.2696D-03, -.2523D-03, -.2250D-03, -.1884D-03,
     >    -.1451D-03, -.1001D-03, -.5924D-04, -.2765D-04, -.7038D-05,
     >    0.4754D-05, 0.1169D-04, 0.1671D-04, 0.2068D-04, 0.2329D-04,
     >    0.2419D-04, 0.2344D-04, 0.2149D-04, 0.1885D-04, 0.1600D-04,
     >    0.1322D-04/

      data (calcpts(j,49), j = 1,neta) /0.1268D-07, 0.1269D-07,
     >    0.2770D-07, 0.2771D-07, 0.2774D-07, 0.4277D-07, 0.4282D-07,
     >    0.5790D-07, 0.7300D-07, 0.7316D-07, 0.1034D-06, 0.1187D-06,
     >    0.1492D-06, 0.1800D-06, 0.2110D-06, 0.2576D-06, 0.3200D-06,
     >    0.3984D-06, 0.4784D-06, 0.5907D-06, 0.7364D-06, 0.9022D-06,
     >    0.1120D-05, 0.1394D-05, 0.1743D-05, 0.2175D-05, 0.2714D-05,
     >    0.3389D-05, 0.4234D-05, 0.5260D-05, 0.6466D-05, 0.7858D-05,
     >    0.9321D-05, 0.1070D-04, 0.1170D-04, 0.1182D-04, 0.1052D-04,
     >    0.7142D-05, 0.1146D-05, -.7803D-05, -.1976D-04, -.3455D-04,
     >    -.5172D-04, -.7074D-04, -.9095D-04, -.1117D-03, -.1324D-03,
     >    -.1522D-03, -.1706D-03, -.1866D-03, -.1996D-03, -.2088D-03,
     >    -.2135D-03, -.2124D-03, -.2049D-03, -.1902D-03, -.1683D-03,
     >    -.1398D-03, -.1068D-03, -.7290D-04, -.4251D-04, -.1928D-04,
     >    -.4354D-05, 0.4011D-05, 0.8844D-05, 0.1234D-04, 0.1510D-04,
     >    0.1693D-04, 0.1753D-04, 0.1695D-04, 0.1551D-04, 0.1360D-04,
     >    0.1152D-04/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsctcf = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine schql_CT(eta, xi, xschql)
cmarco the subtracted term from eq (26) of PLB347 (1995) 143 - 151
c   longitudinal light quark initiated piece
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xschql
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /-.2062D-13, -.3668D-13,
     >    -.6520D-13, -.1160D-12, -.2063D-12, -.3668D-12, -.6522D-12,
     >    -.1160D-11, -.2062D-11, -.3668D-11, -.6525D-11, -.1160D-10,
     >    -.2064D-10, -.3672D-10, -.6530D-10, -.1162D-09, -.2069D-09,
     >    -.3684D-09, -.6561D-09, -.1170D-08, -.2085D-08, -.3723D-08,
     >    -.6657D-08, -.1192D-07, -.2137D-07, -.3838D-07, -.6900D-07,
     >    -.1242D-06, -.2233D-06, -.3993D-06, -.7067D-06, -.1227D-05,
     >    -.2066D-05, -.3329D-05, -.5057D-05, -.7154D-05, -.9369D-05,
     >    -.1137D-04, -.1288D-04, -.1379D-04, -.1414D-04, -.1402D-04,
     >    -.1358D-04, -.1296D-04, -.1228D-04, -.1162D-04, -.1103D-04,
     >    -.1052D-04, -.1012D-04, -.9794D-05, -.9545D-05, -.9356D-05,
     >    -.9215D-05, -.9111D-05, -.9034D-05, -.8980D-05, -.8938D-05,
     >    -.8910D-05, -.8889D-05, -.8873D-05, -.8863D-05, -.8856D-05,
     >    -.8851D-05, -.8847D-05, -.8844D-05, -.8841D-05, -.8840D-05,
     >    -.8840D-05, -.8839D-05, -.8839D-05, -.8837D-05, -.8837D-05,
     >    -.8837D-05/

      data (calcpts(j, 2), j = 1,neta) /-.3027D-13, -.5384D-13,
     >    -.9569D-13, -.1702D-12, -.3027D-12, -.5383D-12, -.9573D-12,
     >    -.1703D-11, -.3027D-11, -.5384D-11, -.9577D-11, -.1703D-10,
     >    -.3029D-10, -.5390D-10, -.9585D-10, -.1706D-09, -.3037D-09,
     >    -.5406D-09, -.9630D-09, -.1717D-08, -.3060D-08, -.5465D-08,
     >    -.9771D-08, -.1749D-07, -.3136D-07, -.5633D-07, -.1013D-06,
     >    -.1823D-06, -.3277D-06, -.5860D-06, -.1037D-05, -.1801D-05,
     >    -.3032D-05, -.4886D-05, -.7422D-05, -.1050D-04, -.1375D-04,
     >    -.1668D-04, -.1890D-04, -.2024D-04, -.2075D-04, -.2058D-04,
     >    -.1993D-04, -.1903D-04, -.1803D-04, -.1705D-04, -.1619D-04,
     >    -.1545D-04, -.1485D-04, -.1438D-04, -.1401D-04, -.1373D-04,
     >    -.1352D-04, -.1337D-04, -.1326D-04, -.1318D-04, -.1312D-04,
     >    -.1308D-04, -.1305D-04, -.1303D-04, -.1301D-04, -.1300D-04,
     >    -.1299D-04, -.1299D-04, -.1299D-04, -.1297D-04, -.1297D-04,
     >    -.1297D-04, -.1297D-04, -.1297D-04, -.1297D-04, -.1297D-04,
     >    -.1297D-04/

      data (calcpts(j, 3), j = 1,neta) /-.4440D-13, -.7897D-13,
     >    -.1404D-12, -.2497D-12, -.4441D-12, -.7896D-12, -.1404D-11,
     >    -.2498D-11, -.4440D-11, -.7897D-11, -.1405D-10, -.2498D-10,
     >    -.4444D-10, -.7907D-10, -.1406D-09, -.2502D-09, -.4455D-09,
     >    -.7931D-09, -.1413D-08, -.2518D-08, -.4489D-08, -.8016D-08,
     >    -.1433D-07, -.2565D-07, -.4600D-07, -.8263D-07, -.1486D-06,
     >    -.2674D-06, -.4807D-06, -.8596D-06, -.1521D-05, -.2642D-05,
     >    -.4448D-05, -.7166D-05, -.1089D-04, -.1540D-04, -.2017D-04,
     >    -.2447D-04, -.2772D-04, -.2970D-04, -.3044D-04, -.3018D-04,
     >    -.2924D-04, -.2791D-04, -.2643D-04, -.2500D-04, -.2373D-04,
     >    -.2265D-04, -.2177D-04, -.2108D-04, -.2054D-04, -.2013D-04,
     >    -.1984D-04, -.1961D-04, -.1945D-04, -.1932D-04, -.1923D-04,
     >    -.1918D-04, -.1913D-04, -.1910D-04, -.1907D-04, -.1906D-04,
     >    -.1905D-04, -.1903D-04, -.1903D-04, -.1903D-04, -.1902D-04,
     >    -.1902D-04, -.1902D-04, -.1902D-04, -.1902D-04, -.1902D-04,
     >    -.1902D-04/

      data (calcpts(j, 4), j = 1,neta) /-.6515D-13, -.1159D-12,
     >    -.2060D-12, -.3663D-12, -.6516D-12, -.1159D-11, -.2061D-11,
     >    -.3665D-11, -.6515D-11, -.1159D-10, -.2061D-10, -.3666D-10,
     >    -.6521D-10, -.1160D-09, -.2063D-09, -.3672D-09, -.6537D-09,
     >    -.1164D-08, -.2073D-08, -.3695D-08, -.6587D-08, -.1176D-07,
     >    -.2103D-07, -.3764D-07, -.6749D-07, -.1212D-06, -.2180D-06,
     >    -.3924D-06, -.7053D-06, -.1261D-05, -.2232D-05, -.3876D-05,
     >    -.6526D-05, -.1051D-04, -.1597D-04, -.2260D-04, -.2959D-04,
     >    -.3590D-04, -.4068D-04, -.4358D-04, -.4466D-04, -.4429D-04,
     >    -.4290D-04, -.4094D-04, -.3878D-04, -.3669D-04, -.3483D-04,
     >    -.3323D-04, -.3195D-04, -.3094D-04, -.3014D-04, -.2955D-04,
     >    -.2911D-04, -.2877D-04, -.2853D-04, -.2835D-04, -.2822D-04,
     >    -.2813D-04, -.2807D-04, -.2803D-04, -.2799D-04, -.2796D-04,
     >    -.2795D-04, -.2793D-04, -.2792D-04, -.2792D-04, -.2792D-04,
     >    -.2791D-04, -.2791D-04, -.2791D-04, -.2791D-04, -.2791D-04,
     >    -.2791D-04/

      data (calcpts(j, 5), j = 1,neta) /-.9559D-13, -.1700D-12,
     >    -.3022D-12, -.5375D-12, -.9561D-12, -.1700D-11, -.3023D-11,
     >    -.5377D-11, -.9558D-11, -.1700D-10, -.3024D-10, -.5379D-10,
     >    -.9567D-10, -.1702D-09, -.3027D-09, -.5387D-09, -.9591D-09,
     >    -.1707D-08, -.3041D-08, -.5421D-08, -.9664D-08, -.1726D-07,
     >    -.3085D-07, -.5523D-07, -.9902D-07, -.1779D-06, -.3198D-06,
     >    -.5756D-06, -.1035D-05, -.1850D-05, -.3274D-05, -.5686D-05,
     >    -.9572D-05, -.1542D-04, -.2343D-04, -.3315D-04, -.4341D-04,
     >    -.5267D-04, -.5968D-04, -.6393D-04, -.6553D-04, -.6498D-04,
     >    -.6295D-04, -.6007D-04, -.5691D-04, -.5385D-04, -.5111D-04,
     >    -.4878D-04, -.4688D-04, -.4538D-04, -.4423D-04, -.4336D-04,
     >    -.4271D-04, -.4222D-04, -.4187D-04, -.4160D-04, -.4142D-04,
     >    -.4127D-04, -.4118D-04, -.4112D-04, -.4106D-04, -.4102D-04,
     >    -.4100D-04, -.4098D-04, -.4097D-04, -.4097D-04, -.4096D-04,
     >    -.4096D-04, -.4096D-04, -.4094D-04, -.4094D-04, -.4094D-04,
     >    -.4094D-04/

      data (calcpts(j, 6), j = 1,neta) /-.1402D-12, -.2493D-12,
     >    -.4431D-12, -.7882D-12, -.1402D-11, -.2493D-11, -.4433D-11,
     >    -.7885D-11, -.1402D-10, -.2493D-10, -.4435D-10, -.7887D-10,
     >    -.1403D-09, -.2496D-09, -.4439D-09, -.7899D-09, -.1406D-08,
     >    -.2504D-08, -.4459D-08, -.7949D-08, -.1417D-07, -.2530D-07,
     >    -.4524D-07, -.8098D-07, -.1452D-06, -.2608D-06, -.4689D-06,
     >    -.8439D-06, -.1517D-05, -.2713D-05, -.4800D-05, -.8335D-05,
     >    -.1403D-04, -.2261D-04, -.3435D-04, -.4861D-04, -.6365D-04,
     >    -.7724D-04, -.8752D-04, -.9375D-04, -.9609D-04, -.9529D-04,
     >    -.9229D-04, -.8810D-04, -.8346D-04, -.7895D-04, -.7492D-04,
     >    -.7150D-04, -.6872D-04, -.6653D-04, -.6483D-04, -.6355D-04,
     >    -.6259D-04, -.6188D-04, -.6136D-04, -.6098D-04, -.6071D-04,
     >    -.6051D-04, -.6037D-04, -.6027D-04, -.6020D-04, -.6015D-04,
     >    -.6011D-04, -.6008D-04, -.6007D-04, -.6005D-04, -.6004D-04,
     >    -.6002D-04, -.6003D-04, -.6003D-04, -.6003D-04, -.6003D-04,
     >    -.6001D-04/

      data (calcpts(j, 7), j = 1,neta) /-.2055D-12, -.3655D-12,
     >    -.6496D-12, -.1155D-11, -.2055D-11, -.3654D-11, -.6498D-11,
     >    -.1156D-10, -.2055D-10, -.3655D-10, -.6501D-10, -.1156D-09,
     >    -.2056D-09, -.3659D-09, -.6506D-09, -.1158D-08, -.2062D-08,
     >    -.3670D-08, -.6537D-08, -.1165D-07, -.2077D-07, -.3709D-07,
     >    -.6632D-07, -.1187D-06, -.2128D-06, -.3823D-06, -.6872D-06,
     >    -.1237D-05, -.2223D-05, -.3975D-05, -.7034D-05, -.1222D-04,
     >    -.2056D-04, -.3313D-04, -.5034D-04, -.7123D-04, -.9329D-04,
     >    -.1132D-03, -.1283D-03, -.1374D-03, -.1409D-03, -.1397D-03,
     >    -.1353D-03, -.1291D-03, -.1223D-03, -.1157D-03, -.1098D-03,
     >    -.1048D-03, -.1007D-03, -.9748D-04, -.9500D-04, -.9311D-04,
     >    -.9171D-04, -.9068D-04, -.8991D-04, -.8936D-04, -.8895D-04,
     >    -.8866D-04, -.8845D-04, -.8829D-04, -.8819D-04, -.8812D-04,
     >    -.8807D-04, -.8803D-04, -.8800D-04, -.8797D-04, -.8796D-04,
     >    -.8796D-04, -.8795D-04, -.8795D-04, -.8795D-04, -.8793D-04,
     >    -.8793D-04/

      data (calcpts(j, 8), j = 1,neta) /-.3011D-12, -.5355D-12,
     >    -.9518D-12, -.1693D-11, -.3011D-11, -.5354D-11, -.9521D-11,
     >    -.1694D-10, -.3010D-10, -.5355D-10, -.9526D-10, -.1694D-09,
     >    -.3013D-09, -.5361D-09, -.9533D-09, -.1697D-08, -.3021D-08,
     >    -.5377D-08, -.9578D-08, -.1707D-07, -.3044D-07, -.5435D-07,
     >    -.9716D-07, -.1739D-06, -.3118D-06, -.5600D-06, -.1007D-05,
     >    -.1812D-05, -.3256D-05, -.5822D-05, -.1030D-04, -.1789D-04,
     >    -.3011D-04, -.4852D-04, -.7372D-04, -.1043D-03, -.1367D-03,
     >    -.1658D-03, -.1879D-03, -.2013D-03, -.2064D-03, -.2046D-03,
     >    -.1982D-03, -.1892D-03, -.1792D-03, -.1695D-03, -.1608D-03,
     >    -.1535D-03, -.1475D-03, -.1428D-03, -.1391D-03, -.1364D-03,
     >    -.1343D-03, -.1329D-03, -.1317D-03, -.1308D-03, -.1303D-03,
     >    -.1298D-03, -.1295D-03, -.1292D-03, -.1291D-03, -.1290D-03,
     >    -.1290D-03, -.1288D-03, -.1289D-03, -.1289D-03, -.1289D-03,
     >    -.1289D-03, -.1289D-03, -.1289D-03, -.1289D-03, -.1289D-03,
     >    -.1287D-03/

      data (calcpts(j, 9), j = 1,neta) /-.4405D-12, -.7835D-12,
     >    -.1393D-11, -.2477D-11, -.4406D-11, -.7834D-11, -.1393D-10,
     >    -.2478D-10, -.4405D-10, -.7835D-10, -.1394D-09, -.2479D-09,
     >    -.4409D-09, -.7844D-09, -.1395D-08, -.2483D-08, -.4420D-08,
     >    -.7868D-08, -.1401D-07, -.2498D-07, -.4453D-07, -.7951D-07,
     >    -.1422D-06, -.2544D-06, -.4561D-06, -.8192D-06, -.1473D-05,
     >    -.2650D-05, -.4762D-05, -.8514D-05, -.1506D-04, -.2615D-04,
     >    -.4403D-04, -.7095D-04, -.1078D-03, -.1526D-03, -.1999D-03,
     >    -.2426D-03, -.2750D-03, -.2946D-03, -.3020D-03, -.2994D-03,
     >    -.2900D-03, -.2767D-03, -.2621D-03, -.2479D-03, -.2351D-03,
     >    -.2244D-03, -.2156D-03, -.2087D-03, -.2033D-03, -.1993D-03,
     >    -.1963D-03, -.1940D-03, -.1924D-03, -.1912D-03, -.1903D-03,
     >    -.1897D-03, -.1893D-03, -.1890D-03, -.1888D-03, -.1886D-03,
     >    -.1885D-03, -.1884D-03, -.1884D-03, -.1882D-03, -.1882D-03,
     >    -.1882D-03, -.1882D-03, -.1882D-03, -.1882D-03, -.1882D-03,
     >    -.1882D-03/

      data (calcpts(j,10), j = 1,neta) /-.6440D-12, -.1146D-11,
     >    -.2036D-11, -.3621D-11, -.6442D-11, -.1145D-10, -.2037D-10,
     >    -.3623D-10, -.6440D-10, -.1145D-09, -.2038D-09, -.3624D-09,
     >    -.6446D-09, -.1147D-08, -.2039D-08, -.3629D-08, -.6461D-08,
     >    -.1150D-07, -.2049D-07, -.3652D-07, -.6510D-07, -.1162D-06,
     >    -.2078D-06, -.3719D-06, -.6666D-06, -.1197D-05, -.2152D-05,
     >    -.3872D-05, -.6957D-05, -.1244D-04, -.2200D-04, -.3819D-04,
     >    -.6430D-04, -.1036D-03, -.1575D-03, -.2229D-03, -.2921D-03,
     >    -.3546D-03, -.4019D-03, -.4306D-03, -.4414D-03, -.4377D-03,
     >    -.4239D-03, -.4045D-03, -.3831D-03, -.3622D-03, -.3436D-03,
     >    -.3279D-03, -.3150D-03, -.3048D-03, -.2970D-03, -.2910D-03,
     >    -.2866D-03, -.2834D-03, -.2810D-03, -.2792D-03, -.2779D-03,
     >    -.2770D-03, -.2763D-03, -.2759D-03, -.2755D-03, -.2753D-03,
     >    -.2751D-03, -.2750D-03, -.2750D-03, -.2749D-03, -.2749D-03,
     >    -.2749D-03, -.2747D-03, -.2747D-03, -.2747D-03, -.2747D-03,
     >    -.2747D-03/

      data (calcpts(j,11), j = 1,neta) /-.9398D-12, -.1672D-11,
     >    -.2971D-11, -.5285D-11, -.9400D-11, -.1671D-10, -.2972D-10,
     >    -.5287D-10, -.9397D-10, -.1672D-09, -.2974D-09, -.5288D-09,
     >    -.9406D-09, -.1674D-08, -.2976D-08, -.5296D-08, -.9429D-08,
     >    -.1678D-07, -.2989D-07, -.5329D-07, -.9499D-07, -.1696D-06,
     >    -.3032D-06, -.5425D-06, -.9724D-06, -.1746D-05, -.3138D-05,
     >    -.5645D-05, -.1014D-04, -.1812D-04, -.3205D-04, -.5564D-04,
     >    -.9365D-04, -.1509D-03, -.2294D-03, -.3249D-03, -.4258D-03,
     >    -.5171D-03, -.5863D-03, -.6283D-03, -.6441D-03, -.6386D-03,
     >    -.6184D-03, -.5901D-03, -.5586D-03, -.5282D-03, -.5009D-03,
     >    -.4779D-03, -.4591D-03, -.4442D-03, -.4328D-03, -.4240D-03,
     >    -.4177D-03, -.4128D-03, -.4092D-03, -.4067D-03, -.4049D-03,
     >    -.4034D-03, -.4025D-03, -.4019D-03, -.4013D-03, -.4009D-03,
     >    -.4008D-03, -.4005D-03, -.4004D-03, -.4004D-03, -.4003D-03,
     >    -.4003D-03, -.4003D-03, -.4003D-03, -.4001D-03, -.4001D-03,
     >    -.4001D-03/

      data (calcpts(j,12), j = 1,neta) /-.1367D-11, -.2432D-11,
     >    -.4323D-11, -.7688D-11, -.1368D-10, -.2432D-10, -.4324D-10,
     >    -.7692D-10, -.1367D-09, -.2432D-09, -.4326D-09, -.7694D-09,
     >    -.1368D-08, -.2435D-08, -.4329D-08, -.7705D-08, -.1372D-07,
     >    -.2442D-07, -.4349D-07, -.7752D-07, -.1382D-06, -.2467D-06,
     >    -.4409D-06, -.7889D-06, -.1414D-05, -.2539D-05, -.4561D-05,
     >    -.8202D-05, -.1473D-04, -.2632D-04, -.4653D-04, -.8076D-04,
     >    -.1359D-03, -.2191D-03, -.3331D-03, -.4719D-03, -.6188D-03,
     >    -.7518D-03, -.8527D-03, -.9139D-03, -.9369D-03, -.9289D-03,
     >    -.8994D-03, -.8579D-03, -.8121D-03, -.7676D-03, -.7278D-03,
     >    -.6940D-03, -.6664D-03, -.6447D-03, -.6280D-03, -.6152D-03,
     >    -.6057D-03, -.5987D-03, -.5935D-03, -.5898D-03, -.5871D-03,
     >    -.5852D-03, -.5837D-03, -.5828D-03, -.5820D-03, -.5815D-03,
     >    -.5812D-03, -.5810D-03, -.5807D-03, -.5806D-03, -.5806D-03,
     >    -.5804D-03, -.5804D-03, -.5804D-03, -.5803D-03, -.5803D-03,
     >    -.5803D-03/

      data (calcpts(j,13), j = 1,neta) /-.1981D-11, -.3524D-11,
     >    -.6264D-11, -.1114D-10, -.1982D-10, -.3524D-10, -.6266D-10,
     >    -.1115D-09, -.1981D-09, -.3524D-09, -.6269D-09, -.1115D-08,
     >    -.1983D-08, -.3528D-08, -.6273D-08, -.1116D-07, -.1988D-07,
     >    -.3538D-07, -.6301D-07, -.1123D-06, -.2002D-06, -.3573D-06,
     >    -.6386D-06, -.1142D-05, -.2047D-05, -.3674D-05, -.6599D-05,
     >    -.1186D-04, -.2130D-04, -.3803D-04, -.6722D-04, -.1166D-03,
     >    -.1963D-03, -.3164D-03, -.4812D-03, -.6821D-03, -.8951D-03,
     >    -.1088D-02, -.1235D-02, -.1324D-02, -.1357D-02, -.1346D-02,
     >    -.1303D-02, -.1242D-02, -.1175D-02, -.1110D-02, -.1052D-02,
     >    -.1003D-02, -.9628D-03, -.9311D-03, -.9066D-03, -.8881D-03,
     >    -.8742D-03, -.8640D-03, -.8564D-03, -.8509D-03, -.8471D-03,
     >    -.8442D-03, -.8421D-03, -.8406D-03, -.8396D-03, -.8388D-03,
     >    -.8382D-03, -.8378D-03, -.8376D-03, -.8374D-03, -.8373D-03,
     >    -.8372D-03, -.8372D-03, -.8372D-03, -.8370D-03, -.8370D-03,
     >    -.8370D-03/

      data (calcpts(j,14), j = 1,neta) /-.1657D-11, -.2947D-11,
     >    -.5239D-11, -.9317D-11, -.1657D-10, -.2947D-10, -.5241D-10,
     >    -.9322D-10, -.1657D-09, -.2948D-09, -.5244D-09, -.9328D-09,
     >    -.1659D-08, -.2953D-08, -.5253D-08, -.9353D-08, -.1666D-07,
     >    -.2969D-07, -.5295D-07, -.9455D-07, -.1689D-06, -.3026D-06,
     >    -.5433D-06, -.9779D-06, -.1766D-05, -.3201D-05, -.5821D-05,
     >    -.1062D-04, -.1939D-04, -.3528D-04, -.6357D-04, -.1123D-03,
     >    -.1920D-03, -.3125D-03, -.4764D-03, -.6703D-03, -.8629D-03,
     >    -.1016D-02, -.1102D-02, -.1114D-02, -.1061D-02, -.9629D-03,
     >    -.8376D-03, -.7028D-03, -.5715D-03, -.4530D-03, -.3513D-03,
     >    -.2678D-03, -.2010D-03, -.1494D-03, -.1096D-03, -.8020D-04,
     >    -.5869D-04, -.4239D-04, -.3005D-04, -.2184D-04, -.1487D-04,
     >    -.1074D-04, -.7992D-05, -.5163D-05, -.3779D-05, -.2358D-05,
     >    -.2412D-05, -.9490D-06, -.9740D-06, -.9911D-06, -.1003D-05,
     >    -.1011D-05, -.1016D-05, -.1020D-05, -.1022D-05, -.1024D-05,
     >    0.4749D-06/

      data (calcpts(j,15), j = 1,neta) /-.2383D-11, -.4239D-11,
     >    -.7535D-11, -.1340D-10, -.2384D-10, -.4239D-10, -.7538D-10,
     >    -.1341D-09, -.2383D-09, -.4240D-09, -.7543D-09, -.1342D-08,
     >    -.2387D-08, -.4247D-08, -.7555D-08, -.1345D-07, -.2396D-07,
     >    -.4269D-07, -.7612D-07, -.1359D-06, -.2428D-06, -.4347D-06,
     >    -.7800D-06, -.1403D-05, -.2531D-05, -.4584D-05, -.8325D-05,
     >    -.1517D-04, -.2765D-04, -.5023D-04, -.9038D-04, -.1595D-03,
     >    -.2725D-03, -.4437D-03, -.6773D-03, -.9547D-03, -.1232D-02,
     >    -.1454D-02, -.1580D-02, -.1600D-02, -.1527D-02, -.1387D-02,
     >    -.1208D-02, -.1014D-02, -.8254D-03, -.6546D-03, -.5069D-03,
     >    -.3863D-03, -.2900D-03, -.2157D-03, -.1589D-03, -.1161D-03,
     >    -.8367D-04, -.6062D-04, -.4279D-04, -.3042D-04, -.2220D-04,
     >    -.1523D-04, -.1109D-04, -.6831D-05, -.5498D-05, -.4112D-05,
     >    -.2690D-05, -.1243D-05, -.1279D-05, 0.1969D-06, 0.1801D-06,
     >    0.1688D-06, 0.1610D-06, 0.1557D-06, 0.1521D-06, 0.1496D-06,
     >    0.1480D-06/

      data (calcpts(j,16), j = 1,neta) /-.3399D-11, -.6046D-11,
     >    -.1075D-10, -.1911D-10, -.3400D-10, -.6045D-10, -.1075D-09,
     >    -.1912D-09, -.3399D-09, -.6046D-09, -.1076D-08, -.1913D-08,
     >    -.3403D-08, -.6056D-08, -.1077D-07, -.1918D-07, -.3416D-07,
     >    -.6085D-07, -.1085D-06, -.1936D-06, -.3457D-06, -.6187D-06,
     >    -.1110D-05, -.1994D-05, -.3594D-05, -.6499D-05, -.1178D-04,
     >    -.2142D-04, -.3897D-04, -.7064D-04, -.1268D-03, -.2235D-03,
     >    -.3815D-03, -.6215D-03, -.9500D-03, -.1343D-02, -.1738D-02,
     >    -.2058D-02, -.2244D-02, -.2278D-02, -.2180D-02, -.1984D-02,
     >    -.1730D-02, -.1455D-02, -.1185D-02, -.9400D-03, -.7301D-03,
     >    -.5566D-03, -.4177D-03, -.3106D-03, -.2286D-03, -.1670D-03,
     >    -.1211D-03, -.8712D-04, -.6249D-04, -.4462D-04, -.3222D-04,
     >    -.2247D-04, -.1549D-04, -.1134D-04, -.8576D-05, -.5738D-05,
     >    -.4349D-05, -.2924D-05, -.1475D-05, -.1510D-05, -.3433D-07,
     >    -.5058D-07, -.6164D-07, -.6919D-07, -.7433D-07, -.7783D-07,
     >    -.8021D-07/

      data (calcpts(j,17), j = 1,neta) /-.4787D-11, -.8515D-11,
     >    -.1513D-10, -.2692D-10, -.4788D-10, -.8514D-10, -.1514D-09,
     >    -.2693D-09, -.4787D-09, -.8515D-09, -.1515D-08, -.2694D-08,
     >    -.4793D-08, -.8528D-08, -.1517D-07, -.2700D-07, -.4808D-07,
     >    -.8564D-07, -.1526D-06, -.2723D-06, -.4860D-06, -.8692D-06,
     >    -.1557D-05, -.2796D-05, -.5031D-05, -.9081D-05, -.1642D-04,
     >    -.2978D-04, -.5401D-04, -.9761D-04, -.1747D-03, -.3072D-03,
     >    -.5238D-03, -.8536D-03, -.1307D-02, -.1854D-02, -.2411D-02,
     >    -.2869D-02, -.3142D-02, -.3202D-02, -.3074D-02, -.2805D-02,
     >    -.2451D-02, -.2066D-02, -.1687D-02, -.1339D-02, -.1041D-02,
     >    -.7941D-03, -.5972D-03, -.4441D-03, -.3274D-03, -.2390D-03,
     >    -.1742D-03, -.1251D-03, -.8941D-04, -.6469D-04, -.4675D-04,
     >    -.3281D-04, -.2303D-04, -.1752D-04, -.1186D-04, -.9089D-05,
     >    -.6244D-05, -.4851D-05, -.3423D-05, -.1972D-05, -.2006D-05,
     >    -.2029D-05, -.5445D-06, -.5551D-06, -.5624D-06, -.5673D-06,
     >    -.5706D-06/

      data (calcpts(j,18), j = 1,neta) /-.6623D-11, -.1178D-10,
     >    -.2094D-10, -.3724D-10, -.6624D-10, -.1178D-09, -.2095D-09,
     >    -.3726D-09, -.6622D-09, -.1178D-08, -.2096D-08, -.3727D-08,
     >    -.6629D-08, -.1180D-07, -.2098D-07, -.3734D-07, -.6648D-07,
     >    -.1184D-06, -.2109D-06, -.3761D-06, -.6709D-06, -.1199D-05,
     >    -.2146D-05, -.3845D-05, -.6907D-05, -.1244D-04, -.2243D-04,
     >    -.4053D-04, -.7321D-04, -.1317D-03, -.2350D-03, -.4118D-03,
     >    -.7008D-03, -.1142D-02, -.1754D-02, -.2498D-02, -.3268D-02,
     >    -.3914D-02, -.4313D-02, -.4420D-02, -.4261D-02, -.3903D-02,
     >    -.3423D-02, -.2891D-02, -.2365D-02, -.1883D-02, -.1466D-02,
     >    -.1120D-02, -.8425D-03, -.6260D-03, -.4613D-03, -.3363D-03,
     >    -.2443D-03, -.1761D-03, -.1267D-03, -.9088D-04, -.6453D-04,
     >    -.4650D-04, -.3250D-04, -.2268D-04, -.1715D-04, -.1147D-04,
     >    -.8681D-05, -.5828D-05, -.4428D-05, -.2996D-05, -.1543D-05,
     >    -.1574D-05, -.1596D-05, -.1106D-06, -.1206D-06, -.1274D-06,
     >    -.1321D-06/

      data (calcpts(j,19), j = 1,neta) /-.8945D-11, -.1591D-10,
     >    -.2828D-10, -.5030D-10, -.8947D-10, -.1591D-09, -.2829D-09,
     >    -.5032D-09, -.8944D-09, -.1591D-08, -.2830D-08, -.5033D-08,
     >    -.8952D-08, -.1593D-07, -.2832D-07, -.5040D-07, -.8973D-07,
     >    -.1597D-06, -.2845D-06, -.5070D-06, -.9037D-06, -.1613D-05,
     >    -.2883D-05, -.5159D-05, -.9244D-05, -.1660D-04, -.2982D-04,
     >    -.5365D-04, -.9645D-04, -.1727D-03, -.3063D-03, -.5346D-03,
     >    -.9074D-03, -.1478D-02, -.2276D-02, -.3259D-02, -.4296D-02,
     >    -.5189D-02, -.5766D-02, -.5952D-02, -.5774D-02, -.5317D-02,
     >    -.4683D-02, -.3972D-02, -.3259D-02, -.2601D-02, -.2029D-02,
     >    -.1552D-02, -.1170D-02, -.8699D-03, -.6406D-03, -.4682D-03,
     >    -.3407D-03, -.2463D-03, -.1761D-03, -.1264D-03, -.9026D-04,
     >    -.6374D-04, -.4560D-04, -.3302D-04, -.2314D-04, -.1607D-04,
     >    -.1186D-04, -.7561D-05, -.6196D-05, -.3288D-05, -.3351D-05,
     >    -.1894D-05, -.1923D-05, -.4426D-06, -.4561D-06, -.4653D-06,
     >    -.4716D-06/

      data (calcpts(j,20), j = 1,neta) /-.1170D-10, -.2082D-10,
     >    -.3700D-10, -.6581D-10, -.1171D-09, -.2082D-09, -.3702D-09,
     >    -.6584D-09, -.1170D-08, -.2082D-08, -.3703D-08, -.6585D-08,
     >    -.1171D-07, -.2083D-07, -.3704D-07, -.6591D-07, -.1173D-06,
     >    -.2088D-06, -.3717D-06, -.6620D-06, -.1179D-05, -.2102D-05,
     >    -.3752D-05, -.6700D-05, -.1198D-04, -.2143D-04, -.3835D-04,
     >    -.6864D-04, -.1227D-03, -.2182D-03, -.3847D-03, -.6677D-03,
     >    -.1129D-02, -.1837D-02, -.2835D-02, -.4084D-02, -.5432D-02,
     >    -.6633D-02, -.7450D-02, -.7765D-02, -.7596D-02, -.7044D-02,
     >    -.6242D-02, -.5321D-02, -.4385D-02, -.3514D-02, -.2749D-02,
     >    -.2108D-02, -.1592D-02, -.1186D-02, -.8758D-03, -.6405D-03,
     >    -.4661D-03, -.3371D-03, -.2418D-03, -.1739D-03, -.1252D-03,
     >    -.8880D-04, -.6357D-04, -.4528D-04, -.3260D-04, -.2266D-04,
     >    -.1704D-04, -.1280D-04, -.8476D-05, -.7097D-05, -.4179D-05,
     >    -.4235D-05, -.2773D-05, -.2799D-05, -.1316D-05, -.1328D-05,
     >    -.1337D-05/

      data (calcpts(j,21), j = 1,neta) /-.1470D-10, -.2615D-10,
     >    -.4648D-10, -.8267D-10, -.1470D-09, -.2615D-09, -.4650D-09,
     >    -.8270D-09, -.1470D-08, -.2615D-08, -.4651D-08, -.8270D-08,
     >    -.1471D-07, -.2616D-07, -.4651D-07, -.8275D-07, -.1472D-06,
     >    -.2620D-06, -.4661D-06, -.8298D-06, -.1477D-05, -.2630D-05,
     >    -.4687D-05, -.8353D-05, -.1489D-04, -.2656D-04, -.4732D-04,
     >    -.8427D-04, -.1497D-03, -.2644D-03, -.4628D-03, -.7976D-03,
     >    -.1341D-02, -.2177D-02, -.3364D-02, -.4877D-02, -.6552D-02,
     >    -.8101D-02, -.9219D-02, -.9729D-02, -.9619D-02, -.9002D-02,
     >    -.8041D-02, -.6903D-02, -.5723D-02, -.4607D-02, -.3618D-02,
     >    -.2783D-02, -.2107D-02, -.1572D-02, -.1161D-02, -.8494D-03,
     >    -.6165D-03, -.4455D-03, -.3193D-03, -.2288D-03, -.1631D-03,
     >    -.1154D-03, -.8159D-04, -.5760D-04, -.4064D-04, -.2784D-04,
     >    -.1932D-04, -.1364D-04, -.9365D-05, -.5017D-05, -.3620D-05,
     >    -.2190D-05, -.7378D-06, -.7705D-06, 0.7073D-06, 0.6922D-06,
     >    0.6819D-06/

      data (calcpts(j,22), j = 1,neta) /-.1759D-10, -.3128D-10,
     >    -.5560D-10, -.9889D-10, -.1759D-09, -.3128D-09, -.5562D-09,
     >    -.9892D-09, -.1758D-08, -.3127D-08, -.5563D-08, -.9892D-08,
     >    -.1759D-07, -.3129D-07, -.5562D-07, -.9894D-07, -.1760D-06,
     >    -.3130D-06, -.5568D-06, -.9908D-06, -.1762D-05, -.3135D-05,
     >    -.5579D-05, -.9925D-05, -.1765D-04, -.3139D-04, -.5570D-04,
     >    -.9871D-04, -.1743D-03, -.3058D-03, -.5311D-03, -.9085D-03,
     >    -.1518D-02, -.2454D-02, -.3791D-02, -.5520D-02, -.7489D-02,
     >    -.9386D-02, -.1085D-01, -.1162D-01, -.1164D-01, -.1102D-01,
     >    -.9949D-02, -.8618D-02, -.7203D-02, -.5839D-02, -.4611D-02,
     >    -.3563D-02, -.2706D-02, -.2019D-02, -.1505D-02, -.1094D-02,
     >    -.8054D-03, -.5835D-03, -.4158D-03, -.3041D-03, -.2199D-03,
     >    -.1488D-03, -.1064D-03, -.7823D-04, -.4947D-04, -.3531D-04,
     >    -.2088D-04, -.2127D-04, -.6535D-05, -.6716D-05, -.6839D-05,
     >    -.6923D-05, -.6980D-05, -.7019D-05, -.7046D-05, -.7064D-05,
     >    -.7077D-05/

      data (calcpts(j,23), j = 1,neta) /-.1989D-10, -.3537D-10,
     >    -.6287D-10, -.1118D-09, -.1989D-09, -.3536D-09, -.6289D-09,
     >    -.1119D-08, -.1988D-08, -.3536D-08, -.6290D-08, -.1118D-07,
     >    -.1989D-07, -.3537D-07, -.6287D-07, -.1118D-06, -.1989D-06,
     >    -.3537D-06, -.6290D-06, -.1119D-05, -.1988D-05, -.3535D-05,
     >    -.6285D-05, -.1116D-04, -.1982D-04, -.3515D-04, -.6218D-04,
     >    -.1097D-03, -.1928D-03, -.3362D-03, -.5800D-03, -.9849D-03,
     >    -.1634D-02, -.2628D-02, -.4050D-02, -.5913D-02, -.8084D-02,
     >    -.1026D-01, -.1205D-01, -.1313D-01, -.1336D-01, -.1284D-01,
     >    -.1174D-01, -.1028D-01, -.8684D-02, -.7102D-02, -.5651D-02,
     >    -.4397D-02, -.3347D-02, -.2525D-02, -.1869D-02, -.1373D-02,
     >    -.9974D-03, -.7178D-03, -.5217D-03, -.3812D-03, -.2677D-03,
     >    -.1971D-03, -.1401D-03, -.9716D-04, -.6856D-04, -.5451D-04,
     >    -.4015D-04, -.2559D-04, -.1090D-04, -.1110D-04, -.1124D-04,
     >    -.1133D-04, -.1140D-04, 0.3557D-05, 0.3526D-05, 0.3506D-05,
     >    0.3492D-05/

      data (calcpts(j,24), j = 1,neta) /-.2117D-10, -.3765D-10,
     >    -.6691D-10, -.1190D-09, -.2117D-09, -.3764D-09, -.6693D-09,
     >    -.1191D-08, -.2116D-08, -.3763D-08, -.6694D-08, -.1190D-07,
     >    -.2117D-07, -.3765D-07, -.6691D-07, -.1190D-06, -.2116D-06,
     >    -.3763D-06, -.6690D-06, -.1189D-05, -.2113D-05, -.3755D-05,
     >    -.6671D-05, -.1184D-04, -.2099D-04, -.3716D-04, -.6559D-04,
     >    -.1154D-03, -.2020D-03, -.3506D-03, -.6016D-03, -.1015D-02,
     >    -.1674D-02, -.2677D-02, -.4111D-02, -.6001D-02, -.8245D-02,
     >    -.1058D-01, -.1261D-01, -.1398D-01, -.1449D-01, -.1415D-01,
     >    -.1313D-01, -.1167D-01, -.9981D-02, -.8257D-02, -.6636D-02,
     >    -.5198D-02, -.3993D-02, -.3012D-02, -.2240D-02, -.1656D-02,
     >    -.1208D-02, -.8696D-03, -.6294D-03, -.4595D-03, -.3314D-03,
     >    -.2311D-03, -.1593D-03, -.1164D-03, -.8792D-04, -.5893D-04,
     >    -.4462D-04, -.3009D-04, -.1541D-04, -.1563D-04, -.1578D-04,
     >    -.8765D-06, -.9453D-06, -.9923D-06, -.1024D-05, -.1046D-05,
     >    -.1061D-05/

      data (calcpts(j,25), j = 1,neta) /-.2120D-10, -.3770D-10,
     >    -.6701D-10, -.1192D-09, -.2120D-09, -.3770D-09, -.6703D-09,
     >    -.1192D-08, -.2119D-08, -.3769D-08, -.6704D-08, -.1192D-07,
     >    -.2120D-07, -.3770D-07, -.6700D-07, -.1192D-06, -.2119D-06,
     >    -.3767D-06, -.6697D-06, -.1190D-05, -.2114D-05, -.3756D-05,
     >    -.6670D-05, -.1183D-04, -.2096D-04, -.3706D-04, -.6531D-04,
     >    -.1147D-03, -.2003D-03, -.3466D-03, -.5925D-03, -.9958D-03,
     >    -.1634D-02, -.2600D-02, -.3976D-02, -.5792D-02, -.7973D-02,
     >    -.1030D-01, -.1244D-01, -.1402D-01, -.1480D-01, -.1472D-01,
     >    -.1390D-01, -.1256D-01, -.1091D-01, -.9150D-02, -.7443D-02,
     >    -.5897D-02, -.4564D-02, -.3478D-02, -.2601D-02, -.1928D-02,
     >    -.1405D-02, -.1021D-02, -.7362D-03, -.5363D-03, -.3782D-03,
     >    -.2779D-03, -.1911D-03, -.1333D-03, -.8977D-04, -.7579D-04,
     >    -.4648D-04, -.3195D-04, -.1727D-04, -.1749D-04, -.1763D-04,
     >    -.2736D-05, -.2805D-05, -.2852D-05, -.2884D-05, -.2906D-05,
     >    -.2921D-05/

      data (calcpts(j,26), j = 1,neta) /-.2004D-10, -.3564D-10,
     >    -.6335D-10, -.1127D-09, -.2004D-09, -.3564D-09, -.6337D-09,
     >    -.1127D-08, -.2003D-08, -.3563D-08, -.6337D-08, -.1127D-07,
     >    -.2004D-07, -.3564D-07, -.6333D-07, -.1126D-06, -.2003D-06,
     >    -.3561D-06, -.6329D-06, -.1125D-05, -.1998D-05, -.3548D-05,
     >    -.6299D-05, -.1117D-04, -.1978D-04, -.3495D-04, -.6155D-04,
     >    -.1080D-03, -.1883D-03, -.3252D-03, -.5547D-03, -.9297D-03,
     >    -.1520D-02, -.2411D-02, -.3674D-02, -.5339D-02, -.7347D-02,
     >    -.9529D-02, -.1161D-01, -.1327D-01, -.1426D-01, -.1446D-01,
     >    -.1392D-01, -.1280D-01, -.1132D-01, -.9654D-02, -.7973D-02,
     >    -.6401D-02, -.5014D-02, -.3846D-02, -.2905D-02, -.2154D-02,
     >    -.1584D-02, -.1155D-02, -.8390D-03, -.6086D-03, -.4351D-03,
     >    -.3045D-03, -.2176D-03, -.1596D-03, -.1160D-03, -.7199D-04,
     >    -.5764D-04, -.4309D-04, -.2839D-04, -.1359D-04, -.1374D-04,
     >    -.1383D-04, 0.1103D-05, 0.1059D-05, 0.1029D-05, 0.1008D-05,
     >    0.9939D-06/

      data (calcpts(j,27), j = 1,neta) /-.1799D-10, -.3199D-10,
     >    -.5687D-10, -.1011D-09, -.1799D-09, -.3199D-09, -.5688D-09,
     >    -.1012D-08, -.1798D-08, -.3198D-08, -.5689D-08, -.1011D-07,
     >    -.1799D-07, -.3199D-07, -.5685D-07, -.1011D-06, -.1798D-06,
     >    -.3196D-06, -.5680D-06, -.1010D-05, -.1793D-05, -.3184D-05,
     >    -.5652D-05, -.1002D-04, -.1774D-04, -.3134D-04, -.5516D-04,
     >    -.9672D-04, -.1685D-03, -.2908D-03, -.4954D-03, -.8290D-03,
     >    -.1353D-02, -.2141D-02, -.3255D-02, -.4719D-02, -.6487D-02,
     >    -.8424D-02, -.1032D-01, -.1192D-01, -.1301D-01, -.1344D-01,
     >    -.1320D-01, -.1239D-01, -.1116D-01, -.9702D-02, -.8158D-02,
     >    -.6655D-02, -.5287D-02, -.4105D-02, -.3126D-02, -.2348D-02,
     >    -.1730D-02, -.1269D-02, -.9212D-03, -.6598D-03, -.4856D-03,
     >    -.3396D-03, -.2373D-03, -.1792D-03, -.1204D-03, -.9128D-04,
     >    -.6187D-04, -.4727D-04, -.3254D-04, -.1772D-04, -.1785D-04,
     >    -.1794D-04, -.2994D-05, -.3034D-05, -.3061D-05, -.3079D-05,
     >    -.3092D-05/

      data (calcpts(j,28), j = 1,neta) /-.1544D-10, -.2746D-10,
     >    -.4881D-10, -.8681D-10, -.1544D-09, -.2746D-09, -.4882D-09,
     >    -.8684D-09, -.1543D-08, -.2745D-08, -.4883D-08, -.8681D-08,
     >    -.1544D-07, -.2746D-07, -.4879D-07, -.8677D-07, -.1543D-06,
     >    -.2743D-06, -.4875D-06, -.8665D-06, -.1539D-05, -.2733D-05,
     >    -.4850D-05, -.8597D-05, -.1522D-04, -.2688D-04, -.4730D-04,
     >    -.8292D-04, -.1444D-03, -.2491D-03, -.4241D-03, -.7091D-03,
     >    -.1156D-02, -.1827D-02, -.2774D-02, -.4016D-02, -.5514D-02,
     >    -.7162D-02, -.8795D-02, -.1023D-01, -.1131D-01, -.1188D-01,
     >    -.1190D-01, -.1140D-01, -.1049D-01, -.9302D-02, -.7977D-02,
     >    -.6632D-02, -.5359D-02, -.4220D-02, -.3253D-02, -.2462D-02,
     >    -.1836D-02, -.1352D-02, -.9877D-03, -.7146D-03, -.5141D-03,
     >    -.3720D-03, -.2693D-03, -.1809D-03, -.1370D-03, -.9274D-04,
     >    -.6324D-04, -.4859D-04, -.3382D-04, -.1898D-04, -.1909D-04,
     >    -.1916D-04, -.4212D-05, -.4247D-05, -.4270D-05, -.4286D-05,
     >    -.4297D-05/

      data (calcpts(j,29), j = 1,neta) /-.1277D-10, -.2271D-10,
     >    -.4036D-10, -.7178D-10, -.1277D-09, -.2270D-09, -.4037D-09,
     >    -.7180D-09, -.1276D-08, -.2270D-08, -.4037D-08, -.7178D-08,
     >    -.1276D-07, -.2270D-07, -.4034D-07, -.7175D-07, -.1276D-06,
     >    -.2268D-06, -.4031D-06, -.7165D-06, -.1272D-05, -.2259D-05,
     >    -.4010D-05, -.7107D-05, -.1258D-04, -.2222D-04, -.3910D-04,
     >    -.6853D-04, -.1193D-03, -.2058D-03, -.3503D-03, -.5854D-03,
     >    -.9541D-03, -.1507D-02, -.2286D-02, -.3306D-02, -.4536D-02,
     >    -.5889D-02, -.7241D-02, -.8461D-02, -.9428D-02, -.1004D-01,
     >    -.1024D-01, -.1001D-01, -.9412D-02, -.8529D-02, -.7474D-02,
     >    -.6343D-02, -.5227D-02, -.4190D-02, -.3279D-02, -.2512D-02,
     >    -.1892D-02, -.1404D-02, -.1030D-02, -.7499D-03, -.5410D-03,
     >    -.3879D-03, -.2773D-03, -.1976D-03, -.1400D-03, -.9860D-04,
     >    -.6902D-04, -.4830D-04, -.3499D-04, -.2462D-04, -.1721D-04,
     >    -.1127D-04, -.8316D-05, -.5345D-05, -.3864D-05, -.2377D-05,
     >    -.8862D-06/

      data (calcpts(j,30), j = 1,neta) /-.1024D-10, -.1821D-10,
     >    -.3237D-10, -.5758D-10, -.1024D-09, -.1821D-09, -.3238D-09,
     >    -.5760D-09, -.1024D-08, -.1821D-08, -.3239D-08, -.5758D-08,
     >    -.1024D-07, -.1821D-07, -.3236D-07, -.5755D-07, -.1023D-06,
     >    -.1819D-06, -.3234D-06, -.5747D-06, -.1020D-05, -.1812D-05,
     >    -.3216D-05, -.5701D-05, -.1009D-04, -.1782D-04, -.3136D-04,
     >    -.5496D-04, -.9570D-04, -.1650D-03, -.2808D-03, -.4693D-03,
     >    -.7646D-03, -.1207D-02, -.1830D-02, -.2646D-02, -.3629D-02,
     >    -.4710D-02, -.5794D-02, -.6785D-02, -.7601D-02, -.8176D-02,
     >    -.8465D-02, -.8438D-02, -.8102D-02, -.7507D-02, -.6725D-02,
     >    -.5836D-02, -.4914D-02, -.4020D-02, -.3202D-02, -.2493D-02,
     >    -.1900D-02, -.1425D-02, -.1054D-02, -.7710D-03, -.5599D-03,
     >    -.4031D-03, -.2892D-03, -.2062D-03, -.1470D-03, -.1040D-03,
     >    -.7278D-04, -.5201D-04, -.3717D-04, -.2527D-04, -.1784D-04,
     >    -.1189D-04, -.8925D-05, -.5948D-05, -.4463D-05, -.2974D-05,
     >    -.1481D-05/

      data (calcpts(j,31), j = 1,neta) /-.8016D-11, -.1426D-10,
     >    -.2534D-10, -.4507D-10, -.8017D-10, -.1425D-09, -.2535D-09,
     >    -.4509D-09, -.8013D-09, -.1425D-08, -.2535D-08, -.4507D-08,
     >    -.8015D-08, -.1425D-07, -.2533D-07, -.4505D-07, -.8011D-07,
     >    -.1424D-06, -.2531D-06, -.4499D-06, -.7988D-06, -.1419D-05,
     >    -.2518D-05, -.4462D-05, -.7897D-05, -.1395D-04, -.2455D-04,
     >    -.4302D-04, -.7490D-04, -.1291D-03, -.2198D-03, -.3672D-03,
     >    -.5983D-03, -.9443D-03, -.1432D-02, -.2069D-02, -.2837D-02,
     >    -.3682D-02, -.4530D-02, -.5310D-02, -.5966D-02, -.6459D-02,
     >    -.6762D-02, -.6850D-02, -.6712D-02, -.6358D-02, -.5827D-02,
     >    -.5174D-02, -.4456D-02, -.3729D-02, -.3033D-02, -.2404D-02,
     >    -.1863D-02, -.1415D-02, -.1057D-02, -.7793D-03, -.5689D-03,
     >    -.4116D-03, -.2959D-03, -.2112D-03, -.1502D-03, -.1071D-03,
     >    -.7589D-04, -.5357D-04, -.3719D-04, -.2677D-04, -.1933D-04,
     >    -.1336D-04, -.8891D-05, -.5909D-05, -.4421D-05, -.2929D-05,
     >    -.2935D-05/

      data (calcpts(j,32), j = 1,neta) /-.6153D-11, -.1094D-10,
     >    -.1945D-10, -.3459D-10, -.6154D-10, -.1094D-09, -.1946D-09,
     >    -.3461D-09, -.6151D-09, -.1094D-08, -.1946D-08, -.3460D-08,
     >    -.6152D-08, -.1094D-07, -.1944D-07, -.3458D-07, -.6149D-07,
     >    -.1093D-06, -.1943D-06, -.3453D-06, -.6131D-06, -.1089D-05,
     >    -.1932D-05, -.3425D-05, -.6062D-05, -.1071D-04, -.1884D-04,
     >    -.3302D-04, -.5749D-04, -.9912D-04, -.1687D-03, -.2818D-03,
     >    -.4591D-03, -.7246D-03, -.1099D-02, -.1588D-02, -.2176D-02,
     >    -.2824D-02, -.3475D-02, -.4075D-02, -.4586D-02, -.4984D-02,
     >    -.5256D-02, -.5390D-02, -.5373D-02, -.5197D-02, -.4872D-02,
     >    -.4428D-02, -.3905D-02, -.3344D-02, -.2783D-02, -.2254D-02,
     >    -.1778D-02, -.1372D-02, -.1039D-02, -.7750D-03, -.5700D-03,
     >    -.4138D-03, -.2993D-03, -.2144D-03, -.1533D-03, -.1086D-03,
     >    -.7733D-04, -.5347D-04, -.3856D-04, -.2663D-04, -.1917D-04,
     >    -.1320D-04, -.8719D-05, -.5733D-05, -.4242D-05, -.2749D-05,
     >    -.1253D-05/

      data (calcpts(j,33), j = 1,neta) /-.4651D-11, -.8273D-11,
     >    -.1470D-10, -.2615D-10, -.4652D-10, -.8272D-10, -.1471D-09,
     >    -.2616D-09, -.4650D-09, -.8270D-09, -.1471D-08, -.2616D-08,
     >    -.4651D-08, -.8272D-08, -.1470D-07, -.2614D-07, -.4649D-07,
     >    -.8263D-07, -.1469D-06, -.2611D-06, -.4635D-06, -.8232D-06,
     >    -.1461D-05, -.2589D-05, -.4583D-05, -.8095D-05, -.1424D-04,
     >    -.2496D-04, -.4346D-04, -.7493D-04, -.1275D-03, -.2130D-03,
     >    -.3471D-03, -.5478D-03, -.8304D-03, -.1200D-02, -.1645D-02,
     >    -.2134D-02, -.2626D-02, -.3081D-02, -.3469D-02, -.3778D-02,
     >    -.4002D-02, -.4138D-02, -.4179D-02, -.4117D-02, -.3944D-02,
     >    -.3669D-02, -.3314D-02, -.2906D-02, -.2477D-02, -.2054D-02,
     >    -.1656D-02, -.1304D-02, -.1003D-02, -.7573D-03, -.5638D-03,
     >    -.4133D-03, -.3015D-03, -.2165D-03, -.1553D-03, -.1105D-03,
     >    -.7918D-04, -.5679D-04, -.4036D-04, -.2840D-04, -.1944D-04,
     >    -.1496D-04, -.1047D-04, -.7485D-05, -.5992D-05, -.4496D-05,
     >    -.3000D-05/

      data (calcpts(j,34), j = 1,neta) /-.3472D-11, -.6176D-11,
     >    -.1098D-10, -.1952D-10, -.3473D-10, -.6175D-10, -.1098D-09,
     >    -.1953D-09, -.3471D-09, -.6173D-09, -.1098D-08, -.1952D-08,
     >    -.3472D-08, -.6174D-08, -.1097D-07, -.1951D-07, -.3470D-07,
     >    -.6168D-07, -.1096D-06, -.1949D-06, -.3460D-06, -.6145D-06,
     >    -.1091D-05, -.1933D-05, -.3421D-05, -.6042D-05, -.1063D-04,
     >    -.1863D-04, -.3244D-04, -.5593D-04, -.9517D-04, -.1590D-03,
     >    -.2591D-03, -.4089D-03, -.6198D-03, -.8957D-03, -.1228D-02,
     >    -.1593D-02, -.1960D-02, -.2299D-02, -.2591D-02, -.2824D-02,
     >    -.2999D-02, -.3116D-02, -.3176D-02, -.3172D-02, -.3097D-02,
     >    -.2946D-02, -.2724D-02, -.2448D-02, -.2138D-02, -.1816D-02,
     >    -.1499D-02, -.1206D-02, -.9455D-03, -.7251D-03, -.5463D-03,
     >    -.4060D-03, -.2971D-03, -.2164D-03, -.1552D-03, -.1118D-03,
     >    -.7894D-04, -.5651D-04, -.4007D-04, -.2810D-04, -.2063D-04,
     >    -.1464D-04, -.1015D-04, -.7162D-05, -.5667D-05, -.4171D-05,
     >    -.2673D-05/

      data (calcpts(j,35), j = 1,neta) /-.2566D-11, -.4564D-11,
     >    -.8112D-11, -.1443D-10, -.2566D-10, -.4563D-10, -.8115D-10,
     >    -.1443D-09, -.2565D-09, -.4563D-09, -.8115D-09, -.1443D-08,
     >    -.2566D-08, -.4563D-08, -.8110D-08, -.1442D-07, -.2565D-07,
     >    -.4559D-07, -.8103D-07, -.1440D-06, -.2557D-06, -.4541D-06,
     >    -.8060D-06, -.1428D-05, -.2528D-05, -.4466D-05, -.7857D-05,
     >    -.1377D-04, -.2398D-04, -.4134D-04, -.7034D-04, -.1175D-03,
     >    -.1915D-03, -.3022D-03, -.4581D-03, -.6620D-03, -.9073D-03,
     >    -.1177D-02, -.1448D-02, -.1699D-02, -.1915D-02, -.2088D-02,
     >    -.2220D-02, -.2314D-02, -.2371D-02, -.2391D-02, -.2369D-02,
     >    -.2298D-02, -.2174D-02, -.2002D-02, -.1791D-02, -.1559D-02,
     >    -.1320D-02, -.1086D-02, -.8718D-03, -.6811D-03, -.5214D-03,
     >    -.3915D-03, -.2898D-03, -.2121D-03, -.1538D-03, -.1104D-03,
     >    -.7900D-04, -.5655D-04, -.4009D-04, -.2812D-04, -.1914D-04,
     >    -.1315D-04, -.1016D-04, -.7162D-05, -.4166D-05, -.2669D-05,
     >    -.2670D-05/

      data (calcpts(j,36), j = 1,neta) /-.1882D-11, -.3347D-11,
     >    -.5949D-11, -.1058D-10, -.1882D-10, -.3347D-10, -.5951D-10,
     >    -.1058D-09, -.1881D-09, -.3346D-09, -.5951D-09, -.1058D-08,
     >    -.1882D-08, -.3346D-08, -.5947D-08, -.1058D-07, -.1881D-07,
     >    -.3343D-07, -.5942D-07, -.1056D-06, -.1875D-06, -.3330D-06,
     >    -.5911D-06, -.1048D-05, -.1854D-05, -.3275D-05, -.5762D-05,
     >    -.1010D-04, -.1758D-04, -.3032D-04, -.5158D-04, -.8619D-04,
     >    -.1404D-03, -.2216D-03, -.3359D-03, -.4854D-03, -.6654D-03,
     >    -.8633D-03, -.1062D-02, -.1246D-02, -.1404D-02, -.1532D-02,
     >    -.1630D-02, -.1701D-02, -.1749D-02, -.1774D-02, -.1776D-02,
     >    -.1749D-02, -.1688D-02, -.1590D-02, -.1459D-02, -.1301D-02,
     >    -.1129D-02, -.9534D-03, -.7830D-03, -.6264D-03, -.4890D-03,
     >    -.3735D-03, -.2808D-03, -.2075D-03, -.1506D-03, -.1102D-03,
     >    -.7874D-04, -.5628D-04, -.3981D-04, -.2783D-04, -.2034D-04,
     >    -.1435D-04, -.9859D-05, -.6863D-05, -.5366D-05, -.3868D-05,
     >    -.2369D-05/

      data (calcpts(j,37), j = 1,neta) /-.1371D-11, -.2439D-11,
     >    -.4334D-11, -.7709D-11, -.1371D-10, -.2438D-10, -.4336D-10,
     >    -.7711D-10, -.1371D-09, -.2438D-09, -.4336D-09, -.7709D-09,
     >    -.1371D-08, -.2438D-08, -.4333D-08, -.7705D-08, -.1370D-07,
     >    -.2436D-07, -.4329D-07, -.7695D-07, -.1366D-06, -.2426D-06,
     >    -.4306D-06, -.7632D-06, -.1351D-05, -.2386D-05, -.4198D-05,
     >    -.7357D-05, -.1281D-04, -.2209D-04, -.3758D-04, -.6279D-04,
     >    -.1023D-03, -.1614D-03, -.2447D-03, -.3537D-03, -.4847D-03,
     >    -.6290D-03, -.7738D-03, -.9079D-03, -.1023D-02, -.1116D-02,
     >    -.1188D-02, -.1241D-02, -.1278D-02, -.1300D-02, -.1310D-02,
     >    -.1304D-02, -.1279D-02, -.1230D-02, -.1155D-02, -.1056D-02,
     >    -.9399D-03, -.8136D-03, -.6854D-03, -.5616D-03, -.4483D-03,
     >    -.3493D-03, -.2664D-03, -.1995D-03, -.1473D-03, -.1075D-03,
     >    -.7764D-04, -.5563D-04, -.3960D-04, -.2821D-04, -.1997D-04,
     >    -.1398D-04, -.9931D-05, -.6934D-05, -.4836D-05, -.3337D-05,
     >    -.2438D-05/

      data (calcpts(j,38), j = 1,neta) /-.9934D-12, -.1767D-11,
     >    -.3141D-11, -.5586D-11, -.9935D-11, -.1767D-10, -.3141D-10,
     >    -.5587D-10, -.9931D-10, -.1766D-09, -.3142D-09, -.5586D-09,
     >    -.9933D-09, -.1767D-08, -.3140D-08, -.5583D-08, -.9929D-08,
     >    -.1765D-07, -.3137D-07, -.5575D-07, -.9899D-07, -.1758D-06,
     >    -.3120D-06, -.5530D-06, -.9787D-06, -.1729D-05, -.3042D-05,
     >    -.5331D-05, -.9282D-05, -.1600D-04, -.2723D-04, -.4550D-04,
     >    -.7412D-04, -.1170D-03, -.1773D-03, -.2563D-03, -.3512D-03,
     >    -.4557D-03, -.5607D-03, -.6578D-03, -.7414D-03, -.8089D-03,
     >    -.8609D-03, -.8995D-03, -.9269D-03, -.9453D-03, -.9557D-03,
     >    -.9577D-03, -.9496D-03, -.9282D-03, -.8901D-03, -.8338D-03,
     >    -.7607D-03, -.6755D-03, -.5835D-03, -.4905D-03, -.4011D-03,
     >    -.3196D-03, -.2487D-03, -.1892D-03, -.1416D-03, -.1043D-03,
     >    -.7596D-04, -.5468D-04, -.3924D-04, -.2785D-04, -.1976D-04,
     >    -.1391D-04, -.9717D-05, -.6869D-05, -.4771D-05, -.3272D-05,
     >    -.2223D-05/

      data (calcpts(j,39), j = 1,neta) /-.7169D-12, -.1275D-11,
     >    -.2266D-11, -.4031D-11, -.7170D-11, -.1275D-10, -.2267D-10,
     >    -.4032D-10, -.7167D-10, -.1275D-09, -.2267D-09, -.4031D-09,
     >    -.7168D-09, -.1275D-08, -.2266D-08, -.4029D-08, -.7165D-08,
     >    -.1274D-07, -.2264D-07, -.4023D-07, -.7144D-07, -.1269D-06,
     >    -.2252D-06, -.3991D-06, -.7063D-06, -.1248D-05, -.2195D-05,
     >    -.3847D-05, -.6698D-05, -.1155D-04, -.1965D-04, -.3283D-04,
     >    -.5349D-04, -.8442D-04, -.1280D-03, -.1849D-03, -.2535D-03,
     >    -.3289D-03, -.4046D-03, -.4747D-03, -.5350D-03, -.5838D-03,
     >    -.6214D-03, -.6493D-03, -.6694D-03, -.6833D-03, -.6921D-03,
     >    -.6963D-03, -.6953D-03, -.6874D-03, -.6703D-03, -.6414D-03,
     >    -.5995D-03, -.5460D-03, -.4838D-03, -.4172D-03, -.3501D-03,
     >    -.2859D-03, -.2275D-03, -.1767D-03, -.1343D-03, -.1003D-03,
     >    -.7396D-04, -.5387D-04, -.3888D-04, -.2779D-04, -.1985D-04,
     >    -.1415D-04, -.9951D-05, -.7103D-05, -.5004D-05, -.3504D-05,
     >    -.2455D-05/

      data (calcpts(j,40), j = 1,neta) /-.5152D-12, -.9164D-12,
     >    -.1629D-11, -.2897D-11, -.5153D-11, -.9162D-11, -.1629D-10,
     >    -.2898D-10, -.5150D-10, -.9160D-10, -.1629D-09, -.2897D-09,
     >    -.5151D-09, -.9162D-09, -.1628D-08, -.2896D-08, -.5149D-08,
     >    -.9153D-08, -.1627D-07, -.2892D-07, -.5134D-07, -.9118D-07,
     >    -.1618D-06, -.2868D-06, -.5076D-06, -.8966D-06, -.1578D-05,
     >    -.2765D-05, -.4814D-05, -.8300D-05, -.1412D-04, -.2360D-04,
     >    -.3844D-04, -.6067D-04, -.9197D-04, -.1329D-03, -.1822D-03,
     >    -.2364D-03, -.2908D-03, -.3412D-03, -.3845D-03, -.4195D-03,
     >    -.4466D-03, -.4667D-03, -.4812D-03, -.4914D-03, -.4982D-03,
     >    -.5023D-03, -.5036D-03, -.5016D-03, -.4949D-03, -.4816D-03,
     >    -.4601D-03, -.4293D-03, -.3903D-03, -.3453D-03, -.2974D-03,
     >    -.2490D-03, -.2031D-03, -.1614D-03, -.1251D-03, -.9502D-04,
     >    -.7088D-04, -.5215D-04, -.3790D-04, -.2726D-04, -.1946D-04,
     >    -.1392D-04, -.9867D-05, -.7018D-05, -.4919D-05, -.3420D-05,
     >    -.2520D-05/

      data (calcpts(j,41), j = 1,neta) /-.3691D-12, -.6564D-12,
     >    -.1167D-11, -.2075D-11, -.3691D-11, -.6563D-11, -.1167D-10,
     >    -.2076D-10, -.3689D-10, -.6562D-10, -.1167D-09, -.2075D-09,
     >    -.3690D-09, -.6563D-09, -.1166D-08, -.2074D-08, -.3689D-08,
     >    -.6557D-08, -.1165D-07, -.2071D-07, -.3678D-07, -.6531D-07,
     >    -.1159D-06, -.2054D-06, -.3636D-06, -.6423D-06, -.1130D-05,
     >    -.1980D-05, -.3448D-05, -.5945D-05, -.1012D-04, -.1690D-04,
     >    -.2754D-04, -.4346D-04, -.6588D-04, -.9520D-04, -.1305D-03,
     >    -.1693D-03, -.2083D-03, -.2444D-03, -.2754D-03, -.3005D-03,
     >    -.3199D-03, -.3343D-03, -.3447D-03, -.3521D-03, -.3572D-03,
     >    -.3605D-03, -.3622D-03, -.3623D-03, -.3602D-03, -.3548D-03,
     >    -.3448D-03, -.3289D-03, -.3064D-03, -.2782D-03, -.2458D-03,
     >    -.2112D-03, -.1768D-03, -.1440D-03, -.1142D-03, -.8838D-04,
     >    -.6709D-04, -.5000D-04, -.3666D-04, -.2661D-04, -.1911D-04,
     >    -.1372D-04, -.9668D-05, -.6819D-05, -.4869D-05, -.3370D-05,
     >    -.2320D-05/

      data (calcpts(j,42), j = 1,neta) /-.2637D-12, -.4690D-12,
     >    -.8337D-12, -.1483D-11, -.2637D-11, -.4689D-11, -.8339D-11,
     >    -.1483D-10, -.2636D-10, -.4689D-10, -.8340D-10, -.1483D-09,
     >    -.2637D-09, -.4689D-09, -.8334D-09, -.1482D-08, -.2636D-08,
     >    -.4685D-08, -.8327D-08, -.1480D-07, -.2628D-07, -.4667D-07,
     >    -.8282D-07, -.1468D-06, -.2598D-06, -.4589D-06, -.8074D-06,
     >    -.1415D-05, -.2464D-05, -.4248D-05, -.7228D-05, -.1208D-04,
     >    -.1967D-04, -.3105D-04, -.4707D-04, -.6802D-04, -.9323D-04,
     >    -.1210D-03, -.1488D-03, -.1746D-03, -.1968D-03, -.2147D-03,
     >    -.2286D-03, -.2389D-03, -.2463D-03, -.2516D-03, -.2553D-03,
     >    -.2578D-03, -.2593D-03, -.2600D-03, -.2596D-03, -.2577D-03,
     >    -.2536D-03, -.2462D-03, -.2345D-03, -.2182D-03, -.1978D-03,
     >    -.1746D-03, -.1499D-03, -.1253D-03, -.1018D-03, -.8068D-04,
     >    -.6239D-04, -.4724D-04, -.3525D-04, -.2580D-04, -.1875D-04,
     >    -.1350D-04, -.9603D-05, -.6754D-05, -.4804D-05, -.3455D-05,
     >    -.2405D-05/

      data (calcpts(j,43), j = 1,neta) /-.1880D-12, -.3343D-12,
     >    -.5942D-12, -.1057D-11, -.1880D-11, -.3342D-11, -.5944D-11,
     >    -.1057D-10, -.1879D-10, -.3342D-10, -.5944D-10, -.1057D-09,
     >    -.1879D-09, -.3342D-09, -.5940D-09, -.1056D-08, -.1878D-08,
     >    -.3339D-08, -.5935D-08, -.1055D-07, -.1873D-07, -.3326D-07,
     >    -.5903D-07, -.1046D-06, -.1852D-06, -.3271D-06, -.5755D-06,
     >    -.1009D-05, -.1756D-05, -.3028D-05, -.5152D-05, -.8608D-05,
     >    -.1402D-04, -.2213D-04, -.3355D-04, -.4848D-04, -.6645D-04,
     >    -.8622D-04, -.1061D-03, -.1245D-03, -.1403D-03, -.1530D-03,
     >    -.1629D-03, -.1703D-03, -.1756D-03, -.1794D-03, -.1820D-03,
     >    -.1838D-03, -.1850D-03, -.1857D-03, -.1859D-03, -.1854D-03,
     >    -.1838D-03, -.1807D-03, -.1753D-03, -.1668D-03, -.1550D-03,
     >    -.1404D-03, -.1238D-03, -.1061D-03, -.8858D-04, -.7196D-04,
     >    -.5695D-04, -.4401D-04, -.3330D-04, -.2475D-04, -.1815D-04,
     >    -.1320D-04, -.9453D-05, -.6753D-05, -.4804D-05, -.3304D-05,
     >    -.2404D-05/

      data (calcpts(j,44), j = 1,neta) /-.1337D-12, -.2377D-12,
     >    -.4225D-12, -.7515D-12, -.1337D-11, -.2377D-11, -.4227D-11,
     >    -.7518D-11, -.1336D-10, -.2376D-10, -.4227D-10, -.7516D-10,
     >    -.1336D-09, -.2377D-09, -.4224D-09, -.7512D-09, -.1336D-08,
     >    -.2374D-08, -.4220D-08, -.7501D-08, -.1332D-07, -.2365D-07,
     >    -.4198D-07, -.7440D-07, -.1317D-06, -.2326D-06, -.4092D-06,
     >    -.7172D-06, -.1249D-05, -.2153D-05, -.3664D-05, -.6121D-05,
     >    -.9972D-05, -.1574D-04, -.2386D-04, -.3448D-04, -.4726D-04,
     >    -.6132D-04, -.7544D-04, -.8851D-04, -.9975D-04, -.1088D-03,
     >    -.1159D-03, -.1211D-03, -.1249D-03, -.1276D-03, -.1294D-03,
     >    -.1307D-03, -.1316D-03, -.1322D-03, -.1325D-03, -.1324D-03,
     >    -.1320D-03, -.1308D-03, -.1285D-03, -.1245D-03, -.1184D-03,
     >    -.1099D-03, -.9945D-04, -.8755D-04, -.7500D-04, -.6253D-04,
     >    -.5075D-04, -.4011D-04, -.3097D-04, -.2341D-04, -.1738D-04,
     >    -.1273D-04, -.9203D-05, -.6594D-05, -.4704D-05, -.3324D-05,
     >    -.2349D-05/

      data (calcpts(j,45), j = 1,neta) /-.9491D-13, -.1688D-12,
     >    -.3000D-12, -.5336D-12, -.9492D-12, -.1688D-11, -.3001D-11,
     >    -.5338D-11, -.9488D-11, -.1687D-10, -.3001D-10, -.5337D-10,
     >    -.9489D-10, -.1688D-09, -.2999D-09, -.5334D-09, -.9485D-09,
     >    -.1686D-08, -.2997D-08, -.5326D-08, -.9457D-08, -.1680D-07,
     >    -.2981D-07, -.5283D-07, -.9350D-07, -.1652D-06, -.2906D-06,
     >    -.5093D-06, -.8867D-06, -.1529D-05, -.2601D-05, -.4347D-05,
     >    -.7081D-05, -.1118D-04, -.1694D-04, -.2448D-04, -.3355D-04,
     >    -.4354D-04, -.5356D-04, -.6285D-04, -.7083D-04, -.7728D-04,
     >    -.8226D-04, -.8597D-04, -.8866D-04, -.9058D-04, -.9192D-04,
     >    -.9285D-04, -.9349D-04, -.9391D-04, -.9416D-04, -.9426D-04,
     >    -.9416D-04, -.9377D-04, -.9288D-04, -.9118D-04, -.8830D-04,
     >    -.8390D-04, -.7785D-04, -.7036D-04, -.6189D-04, -.5297D-04,
     >    -.4413D-04, -.3577D-04, -.2826D-04, -.2180D-04, -.1647D-04,
     >    -.1223D-04, -.8957D-05, -.6482D-05, -.4652D-05, -.3317D-05,
     >    -.2357D-05/

      data (calcpts(j,46), j = 1,neta) /-.6725D-13, -.1196D-12,
     >    -.2126D-12, -.3781D-12, -.6726D-12, -.1196D-11, -.2127D-11,
     >    -.3782D-11, -.6723D-11, -.1196D-10, -.2127D-10, -.3781D-10,
     >    -.6724D-10, -.1196D-09, -.2125D-09, -.3779D-09, -.6721D-09,
     >    -.1195D-08, -.2123D-08, -.3774D-08, -.6701D-08, -.1190D-07,
     >    -.2112D-07, -.3743D-07, -.6625D-07, -.1170D-06, -.2059D-06,
     >    -.3609D-06, -.6283D-06, -.1083D-05, -.1843D-05, -.3080D-05,
     >    -.5017D-05, -.7918D-05, -.1200D-04, -.1735D-04, -.2378D-04,
     >    -.3085D-04, -.3795D-04, -.4453D-04, -.5019D-04, -.5476D-04,
     >    -.5829D-04, -.6092D-04, -.6282D-04, -.6418D-04, -.6513D-04,
     >    -.6579D-04, -.6625D-04, -.6655D-04, -.6675D-04, -.6686D-04,
     >    -.6688D-04, -.6678D-04, -.6647D-04, -.6581D-04, -.6457D-04,
     >    -.6250D-04, -.5934D-04, -.5502D-04, -.4969D-04, -.4366D-04,
     >    -.3733D-04, -.3106D-04, -.2517D-04, -.1986D-04, -.1530D-04,
     >    -.1155D-04, -.8567D-05, -.6258D-05, -.4533D-05, -.3243D-05,
     >    -.2313D-05/

      data (calcpts(j,47), j = 1,neta) /-.4757D-13, -.8461D-13,
     >    -.1504D-12, -.2675D-12, -.4758D-12, -.8460D-12, -.1504D-11,
     >    -.2676D-11, -.4756D-11, -.8458D-11, -.1504D-10, -.2675D-10,
     >    -.4757D-10, -.8460D-10, -.1503D-09, -.2674D-09, -.4755D-09,
     >    -.8451D-09, -.1502D-08, -.2670D-08, -.4740D-08, -.8419D-08,
     >    -.1494D-07, -.2648D-07, -.4687D-07, -.8278D-07, -.1457D-06,
     >    -.2553D-06, -.4445D-06, -.7663D-06, -.1304D-05, -.2179D-05,
     >    -.3549D-05, -.5602D-05, -.8492D-05, -.1227D-04, -.1682D-04,
     >    -.2182D-04, -.2685D-04, -.3150D-04, -.3550D-04, -.3874D-04,
     >    -.4123D-04, -.4309D-04, -.4444D-04, -.4540D-04, -.4608D-04,
     >    -.4654D-04, -.4687D-04, -.4709D-04, -.4723D-04, -.4733D-04,
     >    -.4737D-04, -.4736D-04, -.4726D-04, -.4703D-04, -.4654D-04,
     >    -.4565D-04, -.4416D-04, -.4190D-04, -.3882D-04, -.3503D-04,
     >    -.3075D-04, -.2629D-04, -.2185D-04, -.1768D-04, -.1394D-04,
     >    -.1073D-04, -.8092D-05, -.5992D-05, -.4372D-05, -.3157D-05,
     >    -.2257D-05/

      data (calcpts(j,48), j = 1,neta) /-.3361D-13, -.5979D-13,
     >    -.1063D-12, -.1890D-12, -.3362D-12, -.5977D-12, -.1063D-11,
     >    -.1891D-11, -.3360D-11, -.5976D-11, -.1063D-10, -.1890D-10,
     >    -.3361D-10, -.5977D-10, -.1062D-09, -.1889D-09, -.3359D-09,
     >    -.5971D-09, -.1061D-08, -.1886D-08, -.3349D-08, -.5948D-08,
     >    -.1056D-07, -.1871D-07, -.3312D-07, -.5849D-07, -.1029D-06,
     >    -.1804D-06, -.3141D-06, -.5415D-06, -.9213D-06, -.1539D-05,
     >    -.2508D-05, -.3958D-05, -.6000D-05, -.8671D-05, -.1188D-04,
     >    -.1542D-04, -.1897D-04, -.2226D-04, -.2509D-04, -.2737D-04,
     >    -.2914D-04, -.3045D-04, -.3140D-04, -.3208D-04, -.3256D-04,
     >    -.3289D-04, -.3311D-04, -.3327D-04, -.3338D-04, -.3345D-04,
     >    -.3349D-04, -.3350D-04, -.3348D-04, -.3341D-04, -.3323D-04,
     >    -.3288D-04, -.3224D-04, -.3117D-04, -.2956D-04, -.2737D-04,
     >    -.2468D-04, -.2165D-04, -.1849D-04, -.1536D-04, -.1242D-04,
     >    -.9778D-05, -.7528D-05, -.5668D-05, -.4198D-05, -.3058D-05,
     >    -.2218D-05/

      data (calcpts(j,49), j = 1,neta) /-.2372D-13, -.4218D-13,
     >    -.7498D-13, -.1334D-12, -.2372D-12, -.4218D-12, -.7500D-12,
     >    -.1334D-11, -.2371D-11, -.4217D-11, -.7501D-11, -.1334D-10,
     >    -.2371D-10, -.4218D-10, -.7495D-10, -.1333D-09, -.2370D-09,
     >    -.4213D-09, -.7489D-09, -.1331D-08, -.2363D-08, -.4197D-08,
     >    -.7449D-08, -.1320D-07, -.2337D-07, -.4127D-07, -.7262D-07,
     >    -.1273D-06, -.2216D-06, -.3821D-06, -.6501D-06, -.1086D-05,
     >    -.1770D-05, -.2793D-05, -.4234D-05, -.6118D-05, -.8385D-05,
     >    -.1088D-04, -.1339D-04, -.1571D-04, -.1770D-04, -.1931D-04,
     >    -.2056D-04, -.2149D-04, -.2216D-04, -.2264D-04, -.2297D-04,
     >    -.2320D-04, -.2337D-04, -.2348D-04, -.2355D-04, -.2360D-04,
     >    -.2364D-04, -.2365D-04, -.2366D-04, -.2363D-04, -.2358D-04,
     >    -.2345D-04, -.2319D-04, -.2273D-04, -.2197D-04, -.2083D-04,
     >    -.1927D-04, -.1737D-04, -.1523D-04, -.1299D-04, -.1078D-04,
     >    -.8717D-05, -.6857D-05, -.5267D-05, -.3962D-05, -.2942D-05,
     >    -.2147D-05/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xschql = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine schqt_CT(eta, xi, xschqt)
cmarco the subtracted term from eq (26) of PLB347 (1995) 143 - 151
c   transverse light quark initiated piece
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xschqt
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /-.9757D-09, -.1701D-08,
     >    -.2961D-08, -.5155D-08, -.8967D-08, -.1559D-07, -.2708D-07,
     >    -.4703D-07, -.8158D-07, -.1415D-06, -.2452D-06, -.4245D-06,
     >    -.7345D-06, -.1270D-05, -.2194D-05, -.3787D-05, -.6531D-05,
     >    -.1125D-04, -.1936D-04, -.3327D-04, -.5709D-04, -.9784D-04,
     >    -.1674D-03, -.2859D-03, -.4868D-03, -.8266D-03, -.1398D-02,
     >    -.2352D-02, -.3932D-02, -.6512D-02, -.1065D-01, -.1711D-01,
     >    -.2682D-01, -.4073D-01, -.5935D-01, -.8225D-01, -.1077D+00,
     >    -.1325D+00, -.1534D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     >    -.1612D+00, -.1472D+00, -.1307D+00, -.1132D+00, -.9612D-01,
     >    -.8027D-01, -.6602D-01, -.5365D-01, -.4317D-01, -.3440D-01,
     >    -.2727D-01, -.2137D-01, -.1673D-01, -.1295D-01, -.1003D-01,
     >    -.7682D-02, -.5769D-02, -.4444D-02, -.3410D-02, -.2522D-02,
     >    -.1930D-02, -.1485D-02, -.1039D-02, -.7414D-03, -.5931D-03,
     >    -.4443D-03, -.2950D-03, -.2956D-03, -.1459D-03, -.1462D-03,
     >    -.1464D-03/

      data (calcpts(j, 2), j = 1,neta) /-.9756D-09, -.1701D-08,
     >    -.2961D-08, -.5155D-08, -.8966D-08, -.1559D-07, -.2708D-07,
     >    -.4701D-07, -.8156D-07, -.1415D-06, -.2452D-06, -.4245D-06,
     >    -.7345D-06, -.1270D-05, -.2194D-05, -.3786D-05, -.6529D-05,
     >    -.1125D-04, -.1936D-04, -.3327D-04, -.5708D-04, -.9783D-04,
     >    -.1674D-03, -.2857D-03, -.4866D-03, -.8264D-03, -.1397D-02,
     >    -.2352D-02, -.3932D-02, -.6511D-02, -.1065D-01, -.1711D-01,
     >    -.2682D-01, -.4073D-01, -.5935D-01, -.8225D-01, -.1076D+00,
     >    -.1325D+00, -.1534D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     >    -.1612D+00, -.1472D+00, -.1307D+00, -.1132D+00, -.9610D-01,
     >    -.8026D-01, -.6600D-01, -.5363D-01, -.4316D-01, -.3439D-01,
     >    -.2725D-01, -.2135D-01, -.1672D-01, -.1293D-01, -.1001D-01,
     >    -.7667D-02, -.5903D-02, -.4428D-02, -.3395D-02, -.2507D-02,
     >    -.1914D-02, -.1470D-02, -.1023D-02, -.8760D-03, -.5777D-03,
     >    -.4288D-03, -.2796D-03, -.2801D-03, -.1305D-03, -.1308D-03,
     >    -.1309D-03/

      data (calcpts(j, 3), j = 1,neta) /-.9753D-09, -.1700D-08,
     >    -.2960D-08, -.5153D-08, -.8964D-08, -.1558D-07, -.2707D-07,
     >    -.4701D-07, -.8154D-07, -.1414D-06, -.2450D-06, -.4243D-06,
     >    -.7343D-06, -.1270D-05, -.2193D-05, -.3785D-05, -.6528D-05,
     >    -.1124D-04, -.1935D-04, -.3325D-04, -.5708D-04, -.9781D-04,
     >    -.1673D-03, -.2857D-03, -.4866D-03, -.8262D-03, -.1397D-02,
     >    -.2351D-02, -.3931D-02, -.6510D-02, -.1064D-01, -.1710D-01,
     >    -.2681D-01, -.4072D-01, -.5934D-01, -.8223D-01, -.1076D+00,
     >    -.1325D+00, -.1533D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     >    -.1612D+00, -.1472D+00, -.1307D+00, -.1132D+00, -.9611D-01,
     >    -.8024D-01, -.6598D-01, -.5376D-01, -.4314D-01, -.3437D-01,
     >    -.2723D-01, -.2133D-01, -.1670D-01, -.1291D-01, -.9990D-02,
     >    -.7644D-02, -.5881D-02, -.4405D-02, -.3372D-02, -.2484D-02,
     >    -.1892D-02, -.1447D-02, -.1001D-02, -.8533D-03, -.5550D-03,
     >    -.4062D-03, -.2570D-03, -.2575D-03, -.1079D-03, -.1081D-03,
     >    -.1083D-03/

      data (calcpts(j, 4), j = 1,neta) /-.9749D-09, -.1699D-08,
     >    -.2960D-08, -.5150D-08, -.8961D-08, -.1558D-07, -.2706D-07,
     >    -.4698D-07, -.8151D-07, -.1414D-06, -.2450D-06, -.4241D-06,
     >    -.7340D-06, -.1269D-05, -.2192D-05, -.3785D-05, -.6526D-05,
     >    -.1124D-04, -.1934D-04, -.3325D-04, -.5704D-04, -.9777D-04,
     >    -.1673D-03, -.2855D-03, -.4864D-03, -.8260D-03, -.1397D-02,
     >    -.2351D-02, -.3930D-02, -.6508D-02, -.1064D-01, -.1710D-01,
     >    -.2680D-01, -.4071D-01, -.5932D-01, -.8222D-01, -.1076D+00,
     >    -.1325D+00, -.1533D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     >    -.1611D+00, -.1472D+00, -.1306D+00, -.1132D+00, -.9609D-01,
     >    -.8020D-01, -.6610D-01, -.5373D-01, -.4325D-01, -.3448D-01,
     >    -.2720D-01, -.2144D-01, -.1666D-01, -.1288D-01, -.9957D-02,
     >    -.7611D-02, -.5847D-02, -.4372D-02, -.3339D-02, -.2601D-02,
     >    -.1859D-02, -.1414D-02, -.1118D-02, -.8201D-03, -.5218D-03,
     >    -.3729D-03, -.3737D-03, -.2243D-03, -.2246D-03, -.7488D-04,
     >    -.7505D-04/

      data (calcpts(j, 5), j = 1,neta) /-.9743D-09, -.1698D-08,
     >    -.2958D-08, -.5147D-08, -.8956D-08, -.1557D-07, -.2705D-07,
     >    -.4696D-07, -.8146D-07, -.1413D-06, -.2448D-06, -.4240D-06,
     >    -.7335D-06, -.1268D-05, -.2191D-05, -.3781D-05, -.6522D-05,
     >    -.1124D-04, -.1933D-04, -.3323D-04, -.5702D-04, -.9773D-04,
     >    -.1672D-03, -.2855D-03, -.4862D-03, -.8256D-03, -.1396D-02,
     >    -.2350D-02, -.3928D-02, -.6505D-02, -.1064D-01, -.1709D-01,
     >    -.2679D-01, -.4069D-01, -.5930D-01, -.8219D-01, -.1076D+00,
     >    -.1324D+00, -.1533D+00, -.1672D+00, -.1729D+00, -.1703D+00,
     >    -.1611D+00, -.1472D+00, -.1306D+00, -.1132D+00, -.9609D-01,
     >    -.8015D-01, -.6605D-01, -.5368D-01, -.4320D-01, -.3444D-01,
     >    -.2730D-01, -.2140D-01, -.1661D-01, -.1298D-01, -.9909D-02,
     >    -.7712D-02, -.5799D-02, -.4473D-02, -.3440D-02, -.2552D-02,
     >    -.1960D-02, -.1365D-02, -.1069D-02, -.7713D-03, -.6230D-03,
     >    -.4742D-03, -.3249D-03, -.1755D-03, -.1758D-03, -.1761D-03,
     >    -.2626D-04/

      data (calcpts(j, 6), j = 1,neta) /-.9735D-09, -.1697D-08,
     >    -.2955D-08, -.5144D-08, -.8947D-08, -.1555D-07, -.2702D-07,
     >    -.4691D-07, -.8139D-07, -.1411D-06, -.2447D-06, -.4236D-06,
     >    -.7330D-06, -.1267D-05, -.2189D-05, -.3779D-05, -.6517D-05,
     >    -.1123D-04, -.1932D-04, -.3320D-04, -.5697D-04, -.9766D-04,
     >    -.1671D-03, -.2853D-03, -.4858D-03, -.8250D-03, -.1395D-02,
     >    -.2348D-02, -.3925D-02, -.6501D-02, -.1063D-01, -.1708D-01,
     >    -.2678D-01, -.4067D-01, -.5927D-01, -.8214D-01, -.1075D+00,
     >    -.1324D+00, -.1532D+00, -.1672D+00, -.1728D+00, -.1703D+00,
     >    -.1611D+00, -.1472D+00, -.1306D+00, -.1132D+00, -.9608D-01,
     >    -.8023D-01, -.6598D-01, -.5361D-01, -.4313D-01, -.3436D-01,
     >    -.2723D-01, -.2132D-01, -.1669D-01, -.1291D-01, -.9987D-02,
     >    -.7641D-02, -.5877D-02, -.4402D-02, -.3369D-02, -.2480D-02,
     >    -.1888D-02, -.1444D-02, -.1147D-02, -.8498D-03, -.5515D-03,
     >    -.4026D-03, -.2534D-03, -.2540D-03, -.1043D-03, -.1046D-03,
     >    -.1047D-03/

      data (calcpts(j, 7), j = 1,neta) /-.9721D-09, -.1695D-08,
     >    -.2951D-08, -.5137D-08, -.8936D-08, -.1553D-07, -.2698D-07,
     >    -.4686D-07, -.8129D-07, -.1410D-06, -.2443D-06, -.4231D-06,
     >    -.7321D-06, -.1266D-05, -.2187D-05, -.3774D-05, -.6510D-05,
     >    -.1121D-04, -.1930D-04, -.3317D-04, -.5691D-04, -.9755D-04,
     >    -.1669D-03, -.2849D-03, -.4853D-03, -.8241D-03, -.1394D-02,
     >    -.2346D-02, -.3921D-02, -.6495D-02, -.1062D-01, -.1707D-01,
     >    -.2676D-01, -.4064D-01, -.5922D-01, -.8209D-01, -.1075D+00,
     >    -.1323D+00, -.1531D+00, -.1671D+00, -.1727D+00, -.1702D+00,
     >    -.1610D+00, -.1471D+00, -.1306D+00, -.1131D+00, -.9606D-01,
     >    -.8013D-01, -.6602D-01, -.5365D-01, -.4318D-01, -.3441D-01,
     >    -.2727D-01, -.2137D-01, -.1674D-01, -.1295D-01, -.1003D-01,
     >    -.7686D-02, -.5772D-02, -.4447D-02, -.3414D-02, -.2526D-02,
     >    -.1933D-02, -.1489D-02, -.1042D-02, -.7449D-03, -.5966D-03,
     >    -.4477D-03, -.2985D-03, -.5991D-03, -.1494D-03, -.1497D-03,
     >    -.1498D-03/

      data (calcpts(j, 8), j = 1,neta) /-.9703D-09, -.1691D-08,
     >    -.2945D-08, -.5127D-08, -.8919D-08, -.1550D-07, -.2693D-07,
     >    -.4678D-07, -.8114D-07, -.1407D-06, -.2438D-06, -.4223D-06,
     >    -.7308D-06, -.1264D-05, -.2183D-05, -.3768D-05, -.6498D-05,
     >    -.1119D-04, -.1926D-04, -.3311D-04, -.5682D-04, -.9739D-04,
     >    -.1666D-03, -.2846D-03, -.4845D-03, -.8229D-03, -.1392D-02,
     >    -.2342D-02, -.3917D-02, -.6486D-02, -.1061D-01, -.1705D-01,
     >    -.2672D-01, -.4059D-01, -.5917D-01, -.8200D-01, -.1074D+00,
     >    -.1322D+00, -.1530D+00, -.1670D+00, -.1726D+00, -.1702D+00,
     >    -.1610D+00, -.1471D+00, -.1305D+00, -.1131D+00, -.9603D-01,
     >    -.8013D-01, -.6602D-01, -.5365D-01, -.4318D-01, -.3441D-01,
     >    -.2727D-01, -.2137D-01, -.1674D-01, -.1295D-01, -.1003D-01,
     >    -.7682D-02, -.5768D-02, -.4443D-02, -.3410D-02, -.2522D-02,
     >    -.1930D-02, -.1485D-02, -.1039D-02, -.7411D-03, -.5928D-03,
     >    -.4439D-03, -.2947D-03, -.2952D-03, -.1456D-03, -.1459D-03,
     >    -.1460D-03/

      data (calcpts(j, 9), j = 1,neta) /-.9676D-09, -.1687D-08,
     >    -.2937D-08, -.5112D-08, -.8895D-08, -.1546D-07, -.2687D-07,
     >    -.4664D-07, -.8092D-07, -.1403D-06, -.2433D-06, -.4212D-06,
     >    -.7289D-06, -.1260D-05, -.2177D-05, -.3759D-05, -.6482D-05,
     >    -.1117D-04, -.1922D-04, -.3304D-04, -.5668D-04, -.9717D-04,
     >    -.1663D-03, -.2839D-03, -.4836D-03, -.8212D-03, -.1389D-02,
     >    -.2338D-02, -.3909D-02, -.6474D-02, -.1059D-01, -.1701D-01,
     >    -.2668D-01, -.4052D-01, -.5907D-01, -.8188D-01, -.1072D+00,
     >    -.1320D+00, -.1528D+00, -.1668D+00, -.1725D+00, -.1700D+00,
     >    -.1608D+00, -.1470D+00, -.1304D+00, -.1130D+00, -.9599D-01,
     >    -.8021D-01, -.6595D-01, -.5358D-01, -.4310D-01, -.3448D-01,
     >    -.2719D-01, -.2129D-01, -.1666D-01, -.1288D-01, -.9954D-02,
     >    -.7607D-02, -.5844D-02, -.4518D-02, -.3335D-02, -.2597D-02,
     >    -.1855D-02, -.1410D-02, -.1114D-02, -.8161D-03, -.6677D-03,
     >    -.3689D-03, -.3697D-03, -.2202D-03, -.2206D-03, -.7083D-04,
     >    -.7100D-04/

      data (calcpts(j,10), j = 1,neta) /-.9636D-09, -.1680D-08,
     >    -.2925D-08, -.5093D-08, -.8858D-08, -.1540D-07, -.2675D-07,
     >    -.4646D-07, -.8061D-07, -.1398D-06, -.2423D-06, -.4196D-06,
     >    -.7262D-06, -.1256D-05, -.2169D-05, -.3745D-05, -.6458D-05,
     >    -.1113D-04, -.1915D-04, -.3292D-04, -.5650D-04, -.9684D-04,
     >    -.1657D-03, -.2829D-03, -.4819D-03, -.8185D-03, -.1384D-02,
     >    -.2331D-02, -.3897D-02, -.6455D-02, -.1056D-01, -.1697D-01,
     >    -.2661D-01, -.4042D-01, -.5892D-01, -.8169D-01, -.1070D+00,
     >    -.1318D+00, -.1526D+00, -.1666D+00, -.1723D+00, -.1698D+00,
     >    -.1607D+00, -.1468D+00, -.1304D+00, -.1130D+00, -.9592D-01,
     >    -.8004D-01, -.6593D-01, -.5355D-01, -.4308D-01, -.3445D-01,
     >    -.2717D-01, -.2141D-01, -.1663D-01, -.1285D-01, -.9924D-02,
     >    -.7578D-02, -.5814D-02, -.4489D-02, -.3306D-02, -.2567D-02,
     >    -.1975D-02, -.1380D-02, -.1084D-02, -.7864D-03, -.6381D-03,
     >    -.4892D-03, -.3400D-03, -.1905D-03, -.1909D-03, -.1912D-03,
     >    -.4133D-04/

      data (calcpts(j,11), j = 1,neta) /-.9579D-09, -.1670D-08,
     >    -.2909D-08, -.5063D-08, -.8807D-08, -.1531D-07, -.2660D-07,
     >    -.4619D-07, -.8015D-07, -.1390D-06, -.2409D-06, -.4172D-06,
     >    -.7221D-06, -.1249D-05, -.2157D-05, -.3724D-05, -.6425D-05,
     >    -.1107D-04, -.1905D-04, -.3275D-04, -.5621D-04, -.9635D-04,
     >    -.1649D-03, -.2816D-03, -.4796D-03, -.8148D-03, -.1378D-02,
     >    -.2320D-02, -.3880D-02, -.6428D-02, -.1051D-01, -.1690D-01,
     >    -.2650D-01, -.4027D-01, -.5871D-01, -.8143D-01, -.1067D+00,
     >    -.1314D+00, -.1522D+00, -.1662D+00, -.1719D+00, -.1695D+00,
     >    -.1604D+00, -.1467D+00, -.1302D+00, -.1128D+00, -.9583D-01,
     >    -.8002D-01, -.6590D-01, -.5353D-01, -.4305D-01, -.3442D-01,
     >    -.2714D-01, -.2138D-01, -.1660D-01, -.1296D-01, -.9893D-02,
     >    -.7696D-02, -.5782D-02, -.4457D-02, -.3424D-02, -.2535D-02,
     >    -.1943D-02, -.1498D-02, -.1052D-02, -.7544D-03, -.6061D-03,
     >    -.4573D-03, -.3081D-03, -.3086D-03, -.1590D-03, -.1592D-03,
     >    -.1594D-03/

      data (calcpts(j,12), j = 1,neta) /-.9496D-09, -.1655D-08,
     >    -.2882D-08, -.5018D-08, -.8732D-08, -.1518D-07, -.2638D-07,
     >    -.4581D-07, -.7948D-07, -.1379D-06, -.2389D-06, -.4138D-06,
     >    -.7163D-06, -.1239D-05, -.2140D-05, -.3695D-05, -.6374D-05,
     >    -.1098D-04, -.1890D-04, -.3250D-04, -.5580D-04, -.9566D-04,
     >    -.1637D-03, -.2796D-03, -.4764D-03, -.8092D-03, -.1369D-02,
     >    -.2305D-02, -.3856D-02, -.6388D-02, -.1045D-01, -.1680D-01,
     >    -.2635D-01, -.4005D-01, -.5842D-01, -.8104D-01, -.1062D+00,
     >    -.1309D+00, -.1517D+00, -.1657D+00, -.1714D+00, -.1691D+00,
     >    -.1601D+00, -.1464D+00, -.1300D+00, -.1127D+00, -.9571D-01,
     >    -.7993D-01, -.6581D-01, -.5358D-01, -.4310D-01, -.3433D-01,
     >    -.2719D-01, -.2128D-01, -.1665D-01, -.1286D-01, -.9941D-02,
     >    -.7594D-02, -.5830D-02, -.4504D-02, -.3321D-02, -.2583D-02,
     >    -.1841D-02, -.1396D-02, -.1099D-02, -.8019D-03, -.6536D-03,
     >    -.5047D-03, -.3555D-03, -.2061D-03, -.2064D-03, -.5667D-04,
     >    -.5683D-04/

      data (calcpts(j,13), j = 1,neta) /-.9376D-09, -.1635D-08,
     >    -.2848D-08, -.4956D-08, -.8623D-08, -.1499D-07, -.2605D-07,
     >    -.4526D-07, -.7853D-07, -.1362D-06, -.2361D-06, -.4090D-06,
     >    -.7079D-06, -.1224D-05, -.2116D-05, -.3653D-05, -.6303D-05,
     >    -.1086D-04, -.1870D-04, -.3215D-04, -.5520D-04, -.9465D-04,
     >    -.1620D-03, -.2768D-03, -.4716D-03, -.8013D-03, -.1356D-02,
     >    -.2284D-02, -.3821D-02, -.6331D-02, -.1036D-01, -.1666D-01,
     >    -.2614D-01, -.3974D-01, -.5798D-01, -.8048D-01, -.1055D+00,
     >    -.1301D+00, -.1509D+00, -.1649D+00, -.1707D+00, -.1685D+00,
     >    -.1596D+00, -.1460D+00, -.1297D+00, -.1124D+00, -.9551D-01,
     >    -.7983D-01, -.6570D-01, -.5347D-01, -.4298D-01, -.3436D-01,
     >    -.2707D-01, -.2131D-01, -.1668D-01, -.1289D-01, -.9969D-02,
     >    -.7622D-02, -.5858D-02, -.4383D-02, -.3350D-02, -.2611D-02,
     >    -.1869D-02, -.1424D-02, -.1128D-02, -.8301D-03, -.5318D-03,
     >    -.3829D-03, -.3837D-03, -.2342D-03, -.2346D-03, -.8482D-04,
     >    -.8498D-04/

      data (calcpts(j,14), j = 1,neta) /-.9204D-09, -.1605D-08,
     >    -.2795D-08, -.4866D-08, -.8469D-08, -.1473D-07, -.2560D-07,
     >    -.4445D-07, -.7715D-07, -.1338D-06, -.2320D-06, -.4019D-06,
     >    -.6958D-06, -.1204D-05, -.2080D-05, -.3592D-05, -.6199D-05,
     >    -.1068D-04, -.1840D-04, -.3164D-04, -.5435D-04, -.9320D-04,
     >    -.1596D-03, -.2727D-03, -.4649D-03, -.7900D-03, -.1337D-02,
     >    -.2253D-02, -.3769D-02, -.6250D-02, -.1023D-01, -.1646D-01,
     >    -.2583D-01, -.3929D-01, -.5737D-01, -.7968D-01, -.1046D+00,
     >    -.1291D+00, -.1497D+00, -.1638D+00, -.1697D+00, -.1676D+00,
     >    -.1588D+00, -.1454D+00, -.1292D+00, -.1121D+00, -.9525D-01,
     >    -.7958D-01, -.6559D-01, -.5335D-01, -.4286D-01, -.3424D-01,
     >    -.2709D-01, -.2133D-01, -.1655D-01, -.1291D-01, -.9990D-02,
     >    -.7643D-02, -.5878D-02, -.4403D-02, -.3369D-02, -.2481D-02,
     >    -.1889D-02, -.1444D-02, -.9974D-03, -.8498D-03, -.5515D-03,
     >    -.4026D-03, -.2534D-03, -.2539D-03, -.1043D-03, -.1045D-03,
     >    -.1047D-03/

      data (calcpts(j,15), j = 1,neta) /-.8962D-09, -.1563D-08,
     >    -.2722D-08, -.4740D-08, -.8250D-08, -.1435D-07, -.2495D-07,
     >    -.4333D-07, -.7521D-07, -.1305D-06, -.2262D-06, -.3921D-06,
     >    -.6789D-06, -.1175D-05, -.2030D-05, -.3508D-05, -.6055D-05,
     >    -.1044D-04, -.1798D-04, -.3094D-04, -.5313D-04, -.9118D-04,
     >    -.1562D-03, -.2669D-03, -.4551D-03, -.7740D-03, -.1311D-02,
     >    -.2209D-02, -.3699D-02, -.6135D-02, -.1005D-01, -.1617D-01,
     >    -.2540D-01, -.3866D-01, -.5649D-01, -.7854D-01, -.1032D+00,
     >    -.1275D+00, -.1481D+00, -.1622D+00, -.1683D+00, -.1663D+00,
     >    -.1578D+00, -.1445D+00, -.1285D+00, -.1115D+00, -.9485D-01,
     >    -.7930D-01, -.6530D-01, -.5320D-01, -.4285D-01, -.3422D-01,
     >    -.2707D-01, -.2116D-01, -.1653D-01, -.1289D-01, -.9964D-02,
     >    -.7616D-02, -.5851D-02, -.4375D-02, -.3342D-02, -.2603D-02,
     >    -.1861D-02, -.1416D-02, -.1120D-02, -.8220D-03, -.5236D-03,
     >    -.3747D-03, -.3755D-03, -.2260D-03, -.2264D-03, -.7662D-04,
     >    -.7679D-04/

      data (calcpts(j,16), j = 1,neta) /-.8625D-09, -.1504D-08,
     >    -.2621D-08, -.4566D-08, -.7948D-08, -.1382D-07, -.2404D-07,
     >    -.4176D-07, -.7252D-07, -.1259D-06, -.2183D-06, -.3784D-06,
     >    -.6554D-06, -.1134D-05, -.1961D-05, -.3389D-05, -.5854D-05,
     >    -.1010D-04, -.1740D-04, -.2994D-04, -.5146D-04, -.8834D-04,
     >    -.1514D-03, -.2589D-03, -.4418D-03, -.7518D-03, -.1274D-02,
     >    -.2149D-02, -.3600D-02, -.5975D-02, -.9793D-02, -.1577D-01,
     >    -.2479D-01, -.3777D-01, -.5526D-01, -.7694D-01, -.1012D+00,
     >    -.1253D+00, -.1458D+00, -.1599D+00, -.1662D+00, -.1645D+00,
     >    -.1563D+00, -.1433D+00, -.1275D+00, -.1108D+00, -.9428D-01,
     >    -.7886D-01, -.6500D-01, -.5289D-01, -.4268D-01, -.3404D-01,
     >    -.2689D-01, -.2113D-01, -.1649D-01, -.1285D-01, -.9927D-02,
     >    -.7578D-02, -.5813D-02, -.4487D-02, -.3303D-02, -.2564D-02,
     >    -.1972D-02, -.1377D-02, -.1080D-02, -.7829D-03, -.6345D-03,
     >    -.4856D-03, -.3363D-03, -.1869D-03, -.1872D-03, -.1874D-03,
     >    -.3761D-04/

      data (calcpts(j,17), j = 1,neta) /-.8172D-09, -.1426D-08,
     >    -.2485D-08, -.4329D-08, -.7537D-08, -.1312D-07, -.2281D-07,
     >    -.3965D-07, -.6887D-07, -.1196D-06, -.2075D-06, -.3598D-06,
     >    -.6235D-06, -.1080D-05, -.1868D-05, -.3230D-05, -.5580D-05,
     >    -.9629D-05, -.1660D-04, -.2859D-04, -.4918D-04, -.8450D-04,
     >    -.1449D-03, -.2481D-03, -.4236D-03, -.7215D-03, -.1224D-02,
     >    -.2066D-02, -.3465D-02, -.5756D-02, -.9444D-02, -.1523D-01,
     >    -.2397D-01, -.3657D-01, -.5358D-01, -.7474D-01, -.9852D-01,
     >    -.1222D+00, -.1426D+00, -.1568D+00, -.1633D+00, -.1619D+00,
     >    -.1541D+00, -.1415D+00, -.1261D+00, -.1097D+00, -.9348D-01,
     >    -.7826D-01, -.6453D-01, -.5255D-01, -.4248D-01, -.3383D-01,
     >    -.2682D-01, -.2105D-01, -.1641D-01, -.1277D-01, -.9846D-02,
     >    -.7497D-02, -.5731D-02, -.4404D-02, -.3370D-02, -.2481D-02,
     >    -.1889D-02, -.1444D-02, -.9970D-03, -.8494D-03, -.5510D-03,
     >    -.4021D-03, -.2528D-03, -.2533D-03, -.1037D-03, -.1039D-03,
     >    -.1040D-03/

      data (calcpts(j,18), j = 1,neta) /-.7578D-09, -.1323D-08,
     >    -.2305D-08, -.4019D-08, -.7001D-08, -.1219D-07, -.2121D-07,
     >    -.3688D-07, -.6411D-07, -.1114D-06, -.1933D-06, -.3355D-06,
     >    -.5817D-06, -.1008D-05, -.1745D-05, -.3020D-05, -.5221D-05,
     >    -.9018D-05, -.1556D-04, -.2683D-04, -.4618D-04, -.7943D-04,
     >    -.1364D-03, -.2337D-03, -.3996D-03, -.6815D-03, -.1157D-02,
     >    -.1957D-02, -.3286D-02, -.5468D-02, -.8983D-02, -.1451D-01,
     >    -.2287D-01, -.3496D-01, -.5134D-01, -.7178D-01, -.9490D-01,
     >    -.1181D+00, -.1382D+00, -.1524D+00, -.1592D+00, -.1584D+00,
     >    -.1511D+00, -.1391D+00, -.1242D+00, -.1082D+00, -.9234D-01,
     >    -.7741D-01, -.6394D-01, -.5208D-01, -.4199D-01, -.3363D-01,
     >    -.2661D-01, -.2099D-01, -.1634D-01, -.1270D-01, -.9773D-02,
     >    -.7572D-02, -.5805D-02, -.4328D-02, -.3294D-02, -.2554D-02,
     >    -.1961D-02, -.1366D-02, -.1070D-02, -.7719D-03, -.6235D-03,
     >    -.4745D-03, -.3253D-03, -.1758D-03, -.1761D-03, -.1763D-03,
     >    -.2648D-04/

      data (calcpts(j,19), j = 1,neta) /-.6837D-09, -.1194D-08,
     >    -.2083D-08, -.3632D-08, -.6331D-08, -.1103D-07, -.1920D-07,
     >    -.3342D-07, -.5811D-07, -.1010D-06, -.1756D-06, -.3049D-06,
     >    -.5291D-06, -.9180D-06, -.1591D-05, -.2756D-05, -.4770D-05,
     >    -.8247D-05, -.1425D-04, -.2460D-04, -.4242D-04, -.7304D-04,
     >    -.1256D-03, -.2156D-03, -.3694D-03, -.6310D-03, -.1073D-02,
     >    -.1818D-02, -.3060D-02, -.5101D-02, -.8399D-02, -.1359D-01,
     >    -.2148D-01, -.3290D-01, -.4845D-01, -.6795D-01, -.9016D-01,
     >    -.1126D+00, -.1323D+00, -.1466D+00, -.1537D+00, -.1536D+00,
     >    -.1470D+00, -.1357D+00, -.1216D+00, -.1062D+00, -.9079D-01,
     >    -.7624D-01, -.6307D-01, -.5150D-01, -.4153D-01, -.3330D-01,
     >    -.2642D-01, -.2079D-01, -.1629D-01, -.1264D-01, -.9713D-02,
     >    -.7510D-02, -.5743D-02, -.4415D-02, -.3380D-02, -.2490D-02,
     >    -.1897D-02, -.1452D-02, -.1005D-02, -.8569D-03, -.5584D-03,
     >    -.4095D-03, -.2602D-03, -.2606D-03, -.1110D-03, -.1112D-03,
     >    -.1113D-03/

      data (calcpts(j,20), j = 1,neta) /-.5962D-09, -.1042D-08,
     >    -.1819D-08, -.3174D-08, -.5539D-08, -.9657D-08, -.1683D-07,
     >    -.2932D-07, -.5105D-07, -.8884D-07, -.1546D-06, -.2687D-06,
     >    -.4670D-06, -.8111D-06, -.1407D-05, -.2442D-05, -.4233D-05,
     >    -.7332D-05, -.1269D-04, -.2195D-04, -.3790D-04, -.6541D-04,
     >    -.1127D-03, -.1939D-03, -.3329D-03, -.5701D-03, -.9723D-03,
     >    -.1651D-02, -.2786D-02, -.4658D-02, -.7690D-02, -.1248D-01,
     >    -.1977D-01, -.3039D-01, -.4490D-01, -.6321D-01, -.8422D-01,
     >    -.1057D+00, -.1249D+00, -.1390D+00, -.1466D+00, -.1472D+00,
     >    -.1416D+00, -.1313D+00, -.1180D+00, -.1034D+00, -.8867D-01,
     >    -.7465D-01, -.6189D-01, -.5070D-01, -.4100D-01, -.3275D-01,
     >    -.2600D-01, -.2051D-01, -.1600D-01, -.1250D-01, -.9717D-02,
     >    -.7362D-02, -.5743D-02, -.4264D-02, -.3228D-02, -.2488D-02,
     >    -.1894D-02, -.1449D-02, -.1002D-02, -.8541D-03, -.5555D-03,
     >    -.4065D-03, -.2571D-03, -.2576D-03, -.1079D-03, -.1081D-03,
     >    -.1082D-03/

      data (calcpts(j,21), j = 1,neta) /-.5001D-09, -.8748D-09,
     >    -.1529D-08, -.2673D-08, -.4668D-08, -.8149D-08, -.1422D-07,
     >    -.2481D-07, -.4325D-07, -.7538D-07, -.1314D-06, -.2288D-06,
     >    -.3982D-06, -.6928D-06, -.1205D-05, -.2093D-05, -.3636D-05,
     >    -.6313D-05, -.1095D-04, -.1898D-04, -.3286D-04, -.5686D-04,
     >    -.9827D-04, -.1695D-03, -.2919D-03, -.5014D-03, -.8579D-03,
     >    -.1462D-02, -.2475D-02, -.4152D-02, -.6880D-02, -.1120D-01,
     >    -.1781D-01, -.2748D-01, -.4076D-01, -.5762D-01, -.7714D-01,
     >    -.9737D-01, -.1157D+00, -.1297D+00, -.1376D+00, -.1391D+00,
     >    -.1346D+00, -.1255D+00, -.1134D+00, -.9984D-01, -.8594D-01,
     >    -.7260D-01, -.6036D-01, -.4950D-01, -.4014D-01, -.3222D-01,
     >    -.2560D-01, -.2025D-01, -.1588D-01, -.1237D-01, -.9580D-02,
     >    -.7372D-02, -.5601D-02, -.4271D-02, -.3234D-02, -.2493D-02,
     >    -.1899D-02, -.1453D-02, -.1006D-02, -.8581D-03, -.5595D-03,
     >    -.4104D-03, -.2610D-03, -.2614D-03, -.1117D-03, -.1119D-03,
     >    -.1120D-03/

      data (calcpts(j,22), j = 1,neta) /-.4031D-09, -.7061D-09,
     >    -.1236D-08, -.2163D-08, -.3785D-08, -.6618D-08, -.1157D-07,
     >    -.2022D-07, -.3532D-07, -.6168D-07, -.1077D-06, -.1879D-06,
     >    -.3279D-06, -.5717D-06, -.9962D-06, -.1736D-05, -.3023D-05,
     >    -.5262D-05, -.9154D-05, -.1592D-04, -.2764D-04, -.4797D-04,
     >    -.8319D-04, -.1440D-03, -.2489D-03, -.4291D-03, -.7372D-03,
     >    -.1261D-02, -.2144D-02, -.3612D-02, -.6008D-02, -.9826D-02,
     >    -.1569D-01, -.2430D-01, -.3619D-01, -.5140D-01, -.6916D-01,
     >    -.8779D-01, -.1050D+00, -.1185D+00, -.1268D+00, -.1292D+00,
     >    -.1260D+00, -.1184D+00, -.1077D+00, -.9531D-01, -.8244D-01,
     >    -.6995D-01, -.5838D-01, -.4804D-01, -.3906D-01, -.3142D-01,
     >    -.2505D-01, -.1975D-01, -.1552D-01, -.1215D-01, -.9361D-02,
     >    -.7300D-02, -.5526D-02, -.4194D-02, -.3156D-02, -.2415D-02,
     >    -.1820D-02, -.1374D-02, -.1077D-02, -.7786D-03, -.6298D-03,
     >    -.4806D-03, -.3312D-03, -.1816D-03, -.1818D-03, -.1820D-03,
     >    -.3212D-04/

      data (calcpts(j,23), j = 1,neta) /-.3134D-09, -.5500D-09,
     >    -.9646D-09, -.1691D-08, -.2965D-08, -.5197D-08, -.9103D-08,
     >    -.1595D-07, -.2791D-07, -.4887D-07, -.8554D-07, -.1496D-06,
     >    -.2617D-06, -.4577D-06, -.7999D-06, -.1398D-05, -.2442D-05,
     >    -.4264D-05, -.7442D-05, -.1298D-04, -.2263D-04, -.3942D-04,
     >    -.6863D-04, -.1193D-03, -.2070D-03, -.3584D-03, -.6184D-03,
     >    -.1063D-02, -.1815D-02, -.3071D-02, -.5132D-02, -.8431D-02,
     >    -.1352D-01, -.2103D-01, -.3146D-01, -.4487D-01, -.6066D-01,
     >    -.7742D-01, -.9319D-01, -.1060D+00, -.1144D+00, -.1176D+00,
     >    -.1158D+00, -.1098D+00, -.1007D+00, -.8980D-01, -.7819D-01,
     >    -.6671D-01, -.5595D-01, -.4624D-01, -.3773D-01, -.3045D-01,
     >    -.2434D-01, -.1928D-01, -.1516D-01, -.1184D-01, -.9195D-02,
     >    -.7100D-02, -.5428D-02, -.4094D-02, -.3205D-02, -.2463D-02,
     >    -.1868D-02, -.1421D-02, -.9738D-03, -.8254D-03, -.5265D-03,
     >    -.3772D-03, -.3777D-03, -.2281D-03, -.2283D-03, -.7849D-04,
     >    -.7860D-04/

      data (calcpts(j,24), j = 1,neta) /-.2374D-09, -.4175D-09,
     >    -.7336D-09, -.1290D-08, -.2266D-08, -.3981D-08, -.6991D-08,
     >    -.1228D-07, -.2155D-07, -.3782D-07, -.6639D-07, -.1165D-06,
     >    -.2044D-06, -.3585D-06, -.6283D-06, -.1102D-05, -.1931D-05,
     >    -.3384D-05, -.5927D-05, -.1038D-04, -.1816D-04, -.3176D-04,
     >    -.5551D-04, -.9690D-04, -.1689D-03, -.2937D-03, -.5089D-03,
     >    -.8786D-03, -.1507D-02, -.2562D-02, -.4301D-02, -.7096D-02,
     >    -.1143D-01, -.1785D-01, -.2680D-01, -.3838D-01, -.5210D-01,
     >    -.6683D-01, -.8092D-01, -.9276D-01, -.1010D+00, -.1049D+00,
     >    -.1044D+00, -.1000D+00, -.9264D-01, -.8337D-01, -.7319D-01,
     >    -.6290D-01, -.5307D-01, -.4410D-01, -.3615D-01, -.2930D-01,
     >    -.2349D-01, -.1868D-01, -.1473D-01, -.1154D-01, -.8972D-02,
     >    -.6932D-02, -.5333D-02, -.4087D-02, -.3106D-02, -.2363D-02,
     >    -.1782D-02, -.1350D-02, -.1007D-02, -.7538D-03, -.5598D-03,
     >    -.4254D-03, -.3059D-03, -.2312D-03, -.1714D-03, -.1265D-03,
     >    -.9662D-04/

      data (calcpts(j,25), j = 1,neta) /-.1774D-09, -.3127D-09,
     >    -.5509D-09, -.9707D-09, -.1710D-08, -.3011D-08, -.5303D-08,
     >    -.9337D-08, -.1643D-07, -.2893D-07, -.5093D-07, -.8963D-07,
     >    -.1577D-06, -.2775D-06, -.4880D-06, -.8585D-06, -.1510D-05,
     >    -.2655D-05, -.4667D-05, -.8202D-05, -.1440D-04, -.2529D-04,
     >    -.4437D-04, -.7774D-04, -.1360D-03, -.2376D-03, -.4134D-03,
     >    -.7165D-03, -.1234D-02, -.2107D-02, -.3550D-02, -.5880D-02,
     >    -.9503D-02, -.1489D-01, -.2243D-01, -.3223D-01, -.4391D-01,
     >    -.5654D-01, -.6882D-01, -.7940D-01, -.8719D-01, -.9148D-01,
     >    -.9209D-01, -.8928D-01, -.8370D-01, -.7615D-01, -.6751D-01,
     >    -.5853D-01, -.4976D-01, -.4162D-01, -.3432D-01, -.2795D-01,
     >    -.2252D-01, -.1797D-01, -.1421D-01, -.1116D-01, -.8697D-02,
     >    -.6743D-02, -.5201D-02, -.3983D-02, -.3046D-02, -.2317D-02,
     >    -.1751D-02, -.1318D-02, -.9900D-03, -.7512D-03, -.5570D-03,
     >    -.4076D-03, -.3029D-03, -.2282D-03, -.1684D-03, -.1235D-03,
     >    -.9358D-04/

      data (calcpts(j,26), j = 1,neta) /-.1325D-09, -.2341D-09,
     >    -.4132D-09, -.7299D-09, -.1289D-08, -.2275D-08, -.4017D-08,
     >    -.7092D-08, -.1251D-07, -.2209D-07, -.3899D-07, -.6881D-07,
     >    -.1214D-06, -.2143D-06, -.3779D-06, -.6668D-06, -.1176D-05,
     >    -.2075D-05, -.3658D-05, -.6450D-05, -.1136D-04, -.2001D-04,
     >    -.3524D-04, -.6195D-04, -.1088D-03, -.1906D-03, -.3328D-03,
     >    -.5788D-03, -.1000D-02, -.1713D-02, -.2896D-02, -.4811D-02,
     >    -.7796D-02, -.1225D-01, -.1850D-01, -.2664D-01, -.3638D-01,
     >    -.4699D-01, -.5742D-01, -.6661D-01, -.7368D-01, -.7806D-01,
     >    -.7950D-01, -.7808D-01, -.7415D-01, -.6833D-01, -.6128D-01,
     >    -.5369D-01, -.4608D-01, -.3885D-01, -.3225D-01, -.2642D-01,
     >    -.2140D-01, -.1715D-01, -.1363D-01, -.1074D-01, -.8402D-02,
     >    -.6534D-02, -.5034D-02, -.3874D-02, -.2966D-02, -.2251D-02,
     >    -.1714D-02, -.1281D-02, -.9678D-03, -.7288D-03, -.5345D-03,
     >    -.4000D-03, -.2953D-03, -.2205D-03, -.1606D-03, -.1157D-03,
     >    -.8582D-04/

      data (calcpts(j,27), j = 1,neta) /-.9971D-10, -.1765D-09,
     >    -.3122D-09, -.5525D-09, -.9778D-09, -.1730D-08, -.3060D-08,
     >    -.5415D-08, -.9575D-08, -.1694D-07, -.2997D-07, -.5302D-07,
     >    -.9377D-07, -.1659D-06, -.2933D-06, -.5187D-06, -.9174D-06,
     >    -.1622D-05, -.2867D-05, -.5068D-05, -.8950D-05, -.1581D-04,
     >    -.2790D-04, -.4919D-04, -.8659D-04, -.1521D-03, -.2663D-03,
     >    -.4644D-03, -.8047D-03, -.1381D-02, -.2340D-02, -.3896D-02,
     >    -.6326D-02, -.9956D-02, -.1506D-01, -.2172D-01, -.2972D-01,
     >    -.3847D-01, -.4714D-01, -.5491D-01, -.6110D-01, -.6527D-01,
     >    -.6720D-01, -.6685D-01, -.6439D-01, -.6017D-01, -.5472D-01,
     >    -.4851D-01, -.4210D-01, -.3585D-01, -.3001D-01, -.2477D-01,
     >    -.2020D-01, -.1628D-01, -.1299D-01, -.1028D-01, -.8074D-02,
     >    -.6307D-02, -.4880D-02, -.3763D-02, -.2884D-02, -.2213D-02,
     >    -.1675D-02, -.1272D-02, -.9585D-03, -.7193D-03, -.5399D-03,
     >    -.4053D-03, -.3006D-03, -.2257D-03, -.1659D-03, -.1359D-03,
     >    -.9100D-04/

      data (calcpts(j,28), j = 1,neta) /-.7575D-10, -.1343D-09,
     >    -.2379D-09, -.4217D-09, -.7476D-09, -.1325D-08, -.2348D-08,
     >    -.4161D-08, -.7371D-08, -.1306D-07, -.2316D-07, -.4103D-07,
     >    -.7270D-07, -.1288D-06, -.2282D-06, -.4043D-06, -.7165D-06,
     >    -.1269D-05, -.2247D-05, -.3980D-05, -.7042D-05, -.1246D-04,
     >    -.2204D-04, -.3892D-04, -.6865D-04, -.1208D-03, -.2119D-03,
     >    -.3702D-03, -.6426D-03, -.1105D-02, -.1875D-02, -.3125D-02,
     >    -.5081D-02, -.8007D-02, -.1212D-01, -.1750D-01, -.2397D-01,
     >    -.3107D-01, -.3814D-01, -.4455D-01, -.4980D-01, -.5355D-01,
     >    -.5564D-01, -.5603D-01, -.5474D-01, -.5193D-01, -.4793D-01,
     >    -.4311D-01, -.3787D-01, -.3262D-01, -.2758D-01, -.2296D-01,
     >    -.1886D-01, -.1530D-01, -.1228D-01, -.9767D-02, -.7703D-02,
     >    -.6038D-02, -.4698D-02, -.3625D-02, -.2790D-02, -.2133D-02,
     >    -.1625D-02, -.1236D-02, -.9374D-03, -.6981D-03, -.5336D-03,
     >    -.3989D-03, -.2941D-03, -.2192D-03, -.1593D-03, -.1294D-03,
     >    -.8445D-04/

      data (calcpts(j,29), j = 1,neta) /-.5802D-10, -.1030D-09,
     >    -.1826D-09, -.3241D-09, -.5753D-09, -.1021D-08, -.1811D-08,
     >    -.3214D-08, -.5700D-08, -.1011D-07, -.1795D-07, -.3184D-07,
     >    -.5649D-07, -.1002D-06, -.1778D-06, -.3154D-06, -.5596D-06,
     >    -.9924D-06, -.1760D-05, -.3121D-05, -.5529D-05, -.9797D-05,
     >    -.1735D-04, -.3068D-04, -.5418D-04, -.9549D-04, -.1677D-03,
     >    -.2933D-03, -.5096D-03, -.8771D-03, -.1490D-02, -.2486D-02,
     >    -.4045D-02, -.6378D-02, -.9662D-02, -.1396D-01, -.1912D-01,
     >    -.2480D-01, -.3048D-01, -.3568D-01, -.4000D-01, -.4322D-01,
     >    -.4524D-01, -.4603D-01, -.4556D-01, -.4389D-01, -.4116D-01,
     >    -.3760D-01, -.3353D-01, -.2925D-01, -.2502D-01, -.2105D-01,
     >    -.1744D-01, -.1425D-01, -.1151D-01, -.9213D-02, -.7295D-02,
     >    -.5747D-02, -.4480D-02, -.3481D-02, -.2674D-02, -.2047D-02,
     >    -.1569D-02, -.1195D-02, -.8956D-03, -.6712D-03, -.5065D-03,
     >    -.3868D-03, -.2820D-03, -.2071D-03, -.1622D-03, -.1172D-03,
     >    -.8727D-04/

      data (calcpts(j,30), j = 1,neta) /-.4465D-10, -.7931D-10,
     >    -.1408D-09, -.2500D-09, -.4441D-09, -.7886D-09, -.1400D-08,
     >    -.2487D-08, -.4415D-08, -.7840D-08, -.1393D-07, -.2473D-07,
     >    -.4390D-07, -.7797D-07, -.1384D-06, -.2457D-06, -.4364D-06,
     >    -.7745D-06, -.1375D-05, -.2440D-05, -.4326D-05, -.7672D-05,
     >    -.1360D-04, -.2406D-04, -.4253D-04, -.7503D-04, -.1318D-03,
     >    -.2308D-03, -.4013D-03, -.6912D-03, -.1175D-02, -.1961D-02,
     >    -.3193D-02, -.5037D-02, -.7633D-02, -.1103D-01, -.1511D-01,
     >    -.1961D-01, -.2411D-01, -.2825D-01, -.3174D-01, -.3441D-01,
     >    -.3622D-01, -.3714D-01, -.3718D-01, -.3633D-01, -.3462D-01,
     >    -.3216D-01, -.2915D-01, -.2581D-01, -.2237D-01, -.1905D-01,
     >    -.1595D-01, -.1315D-01, -.1071D-01, -.8630D-02, -.6874D-02,
     >    -.5443D-02, -.4264D-02, -.3324D-02, -.2577D-02, -.1979D-02,
     >    -.1515D-02, -.1156D-02, -.8717D-03, -.6621D-03, -.4974D-03,
     >    -.3776D-03, -.2728D-03, -.2129D-03, -.1529D-03, -.1080D-03,
     >    -.7802D-04/

      data (calcpts(j,31), j = 1,neta) /-.3440D-10, -.6113D-10,
     >    -.1086D-09, -.1929D-09, -.3429D-09, -.6091D-09, -.1082D-08,
     >    -.1923D-08, -.3415D-08, -.6069D-08, -.1078D-07, -.1916D-07,
     >    -.3404D-07, -.6048D-07, -.1074D-06, -.1908D-06, -.3390D-06,
     >    -.6021D-06, -.1069D-05, -.1899D-05, -.3368D-05, -.5977D-05,
     >    -.1060D-04, -.1877D-04, -.3319D-04, -.5857D-04, -.1030D-03,
     >    -.1803D-03, -.3138D-03, -.5406D-03, -.9193D-03, -.1535D-02,
     >    -.2500D-02, -.3944D-02, -.5979D-02, -.8639D-02, -.1184D-01,
     >    -.1536D-01, -.1890D-01, -.2216D-01, -.2492D-01, -.2709D-01,
     >    -.2861D-01, -.2951D-01, -.2980D-01, -.2947D-01, -.2851D-01,
     >    -.2694D-01, -.2485D-01, -.2238D-01, -.1970D-01, -.1700D-01,
     >    -.1440D-01, -.1200D-01, -.9863D-02, -.8004D-02, -.6424D-02,
     >    -.5112D-02, -.4037D-02, -.3155D-02, -.2453D-02, -.1899D-02,
     >    -.1450D-02, -.1106D-02, -.8366D-03, -.6419D-03, -.4772D-03,
     >    -.3573D-03, -.2674D-03, -.2075D-03, -.1476D-03, -.1176D-03,
     >    -.8762D-04/

      data (calcpts(j,32), j = 1,neta) /-.2646D-10, -.4703D-10,
     >    -.8355D-10, -.1485D-09, -.2640D-09, -.4692D-09, -.8339D-09,
     >    -.1482D-08, -.2633D-08, -.4681D-08, -.8322D-08, -.1479D-07,
     >    -.2628D-07, -.4672D-07, -.8298D-07, -.1475D-06, -.2621D-06,
     >    -.4657D-06, -.8273D-06, -.1470D-05, -.2608D-05, -.4629D-05,
     >    -.8211D-05, -.1455D-04, -.2573D-04, -.4543D-04, -.7989D-04,
     >    -.1399D-03, -.2436D-03, -.4197D-03, -.7140D-03, -.1193D-02,
     >    -.1942D-02, -.3065D-02, -.4646D-02, -.6713D-02, -.9201D-02,
     >    -.1194D-01, -.1469D-01, -.1723D-01, -.1939D-01, -.2111D-01,
     >    -.2235D-01, -.2315D-01, -.2353D-01, -.2348D-01, -.2301D-01,
     >    -.2209D-01, -.2074D-01, -.1901D-01, -.1703D-01, -.1492D-01,
     >    -.1282D-01, -.1082D-01, -.8980D-02, -.7357D-02, -.5955D-02,
     >    -.4776D-02, -.3775D-02, -.2968D-02, -.2325D-02, -.1801D-02,
     >    -.1382D-02, -.1067D-02, -.8126D-03, -.6178D-03, -.4680D-03,
     >    -.3481D-03, -.2582D-03, -.1983D-03, -.1383D-03, -.1083D-03,
     >    -.7837D-04/

      data (calcpts(j,33), j = 1,neta) /-.2028D-10, -.3607D-10,
     >    -.6408D-10, -.1139D-09, -.2026D-09, -.3601D-09, -.6402D-09,
     >    -.1138D-08, -.2022D-08, -.3596D-08, -.6394D-08, -.1136D-07,
     >    -.2020D-07, -.3592D-07, -.6381D-07, -.1134D-06, -.2017D-06,
     >    -.3583D-06, -.6367D-06, -.1131D-05, -.2008D-05, -.3565D-05,
     >    -.6325D-05, -.1121D-04, -.1983D-04, -.3501D-04, -.6158D-04,
     >    -.1079D-03, -.1878D-03, -.3237D-03, -.5507D-03, -.9200D-03,
     >    -.1498D-02, -.2365D-02, -.3585D-02, -.5180D-02, -.7100D-02,
     >    -.9213D-02, -.1133D-01, -.1330D-01, -.1497D-01, -.1631D-01,
     >    -.1731D-01, -.1798D-01, -.1835D-01, -.1844D-01, -.1825D-01,
     >    -.1776D-01, -.1695D-01, -.1583D-01, -.1444D-01, -.1288D-01,
     >    -.1124D-01, -.9618D-02, -.8088D-02, -.6698D-02, -.5473D-02,
     >    -.4416D-02, -.3534D-02, -.2801D-02, -.2187D-02, -.1708D-02,
     >    -.1319D-02, -.1019D-02, -.7796D-03, -.5998D-03, -.4500D-03,
     >    -.3451D-03, -.2551D-03, -.1952D-03, -.1502D-03, -.1052D-03,
     >    -.7526D-04/

      data (calcpts(j,34), j = 1,neta) /-.1548D-10, -.2753D-10,
     >    -.4892D-10, -.8700D-10, -.1547D-09, -.2750D-09, -.4890D-09,
     >    -.8695D-09, -.1545D-08, -.2748D-08, -.4886D-08, -.8686D-08,
     >    -.1544D-07, -.2746D-07, -.4879D-07, -.8674D-07, -.1542D-06,
     >    -.2741D-06, -.4870D-06, -.8655D-06, -.1536D-05, -.2728D-05,
     >    -.4841D-05, -.8578D-05, -.1518D-04, -.2680D-04, -.4715D-04,
     >    -.8263D-04, -.1438D-03, -.2480D-03, -.4219D-03, -.7048D-03,
     >    -.1148D-02, -.1812D-02, -.2747D-02, -.3969D-02, -.5440D-02,
     >    -.7059D-02, -.8685D-02, -.1019D-01, -.1148D-01, -.1251D-01,
     >    -.1329D-01, -.1383D-01, -.1416D-01, -.1430D-01, -.1425D-01,
     >    -.1401D-01, -.1356D-01, -.1289D-01, -.1198D-01, -.1089D-01,
     >    -.9674D-02, -.8414D-02, -.7176D-02, -.6017D-02, -.4969D-02,
     >    -.4050D-02, -.3261D-02, -.2598D-02, -.2052D-02, -.1607D-02,
     >    -.1251D-02, -.9661D-03, -.7414D-03, -.5675D-03, -.4311D-03,
     >    -.3217D-03, -.2468D-03, -.1868D-03, -.1418D-03, -.9683D-04,
     >    -.8184D-04/

      data (calcpts(j,35), j = 1,neta) /-.1176D-10, -.2091D-10,
     >    -.3717D-10, -.6610D-10, -.1176D-09, -.2090D-09, -.3716D-09,
     >    -.6608D-09, -.1174D-08, -.2089D-08, -.3714D-08, -.6603D-08,
     >    -.1174D-07, -.2088D-07, -.3710D-07, -.6597D-07, -.1173D-06,
     >    -.2085D-06, -.3705D-06, -.6584D-06, -.1169D-05, -.2076D-05,
     >    -.3683D-05, -.6527D-05, -.1155D-04, -.2040D-04, -.3589D-04,
     >    -.6290D-04, -.1095D-03, -.1888D-03, -.3212D-03, -.5366D-03,
     >    -.8741D-03, -.1379D-02, -.2091D-02, -.3022D-02, -.4142D-02,
     >    -.5375D-02, -.6612D-02, -.7758D-02, -.8741D-02, -.9532D-02,
     >    -.1013D-01, -.1056D-01, -.1084D-01, -.1098D-01, -.1100D-01,
     >    -.1090D-01, -.1066D-01, -.1028D-01, -.9728D-02, -.9012D-02,
     >    -.8163D-02, -.7228D-02, -.6268D-02, -.5330D-02, -.4457D-02,
     >    -.3671D-02, -.2984D-02, -.2398D-02, -.1906D-02, -.1503D-02,
     >    -.1175D-02, -.9116D-03, -.7033D-03, -.5384D-03, -.4110D-03,
     >    -.3120D-03, -.2356D-03, -.1771D-03, -.1321D-03, -.9912D-04,
     >    -.7362D-04/

      data (calcpts(j,36), j = 1,neta) /-.8892D-11, -.1581D-10,
     >    -.2811D-10, -.4998D-10, -.8890D-10, -.1581D-09, -.2810D-09,
     >    -.4998D-09, -.8883D-09, -.1580D-08, -.2810D-08, -.4996D-08,
     >    -.8882D-08, -.1580D-07, -.2807D-07, -.4991D-07, -.8876D-07,
     >    -.1578D-06, -.2804D-06, -.4983D-06, -.8847D-06, -.1571D-05,
     >    -.2788D-05, -.4941D-05, -.8744D-05, -.1544D-04, -.2717D-04,
     >    -.4762D-04, -.8290D-04, -.1429D-03, -.2432D-03, -.4063D-03,
     >    -.6619D-03, -.1045D-02, -.1584D-02, -.2288D-02, -.3136D-02,
     >    -.4070D-02, -.5007D-02, -.5874D-02, -.6620D-02, -.7220D-02,
     >    -.7678D-02, -.8011D-02, -.8234D-02, -.8364D-02, -.8411D-02,
     >    -.8378D-02, -.8261D-02, -.8053D-02, -.7736D-02, -.7299D-02,
     >    -.6743D-02, -.6090D-02, -.5378D-02, -.4650D-02, -.3945D-02,
     >    -.3290D-02, -.2705D-02, -.2194D-02, -.1760D-02, -.1396D-02,
     >    -.1099D-02, -.8578D-03, -.6645D-03, -.5115D-03, -.3916D-03,
     >    -.2986D-03, -.2267D-03, -.1712D-03, -.1277D-03, -.9622D-04,
     >    -.7223D-04/

      data (calcpts(j,37), j = 1,neta) /-.6692D-11, -.1190D-10,
     >    -.2115D-10, -.3762D-10, -.6691D-10, -.1190D-09, -.2115D-09,
     >    -.3762D-09, -.6687D-09, -.1189D-08, -.2115D-08, -.3761D-08,
     >    -.6687D-08, -.1189D-07, -.2113D-07, -.3758D-07, -.6683D-07,
     >    -.1188D-06, -.2111D-06, -.3752D-06, -.6662D-06, -.1183D-05,
     >    -.2100D-05, -.3721D-05, -.6585D-05, -.1163D-04, -.2046D-04,
     >    -.3586D-04, -.6244D-04, -.1077D-03, -.1832D-03, -.3060D-03,
     >    -.4985D-03, -.7868D-03, -.1193D-02, -.1724D-02, -.2362D-02,
     >    -.3065D-02, -.3771D-02, -.4425D-02, -.4986D-02, -.5439D-02,
     >    -.5787D-02, -.6041D-02, -.6216D-02, -.6326D-02, -.6379D-02,
     >    -.6379D-02, -.6326D-02, -.6217D-02, -.6042D-02, -.5789D-02,
     >    -.5448D-02, -.5021D-02, -.4524D-02, -.3984D-02, -.3437D-02,
     >    -.2909D-02, -.2421D-02, -.1985D-02, -.1608D-02, -.1287D-02,
     >    -.1020D-02, -.8012D-03, -.6243D-03, -.4834D-03, -.3709D-03,
     >    -.2840D-03, -.2165D-03, -.1640D-03, -.1235D-03, -.9201D-04,
     >    -.6951D-04/

      data (calcpts(j,38), j = 1,neta) /-.5013D-11, -.8916D-11,
     >    -.1585D-10, -.2818D-10, -.5013D-10, -.8914D-10, -.1585D-09,
     >    -.2819D-09, -.5010D-09, -.8911D-09, -.1585D-08, -.2818D-08,
     >    -.5011D-08, -.8911D-08, -.1584D-07, -.2816D-07, -.5008D-07,
     >    -.8901D-07, -.1582D-06, -.2812D-06, -.4993D-06, -.8866D-06,
     >    -.1574D-05, -.2789D-05, -.4935D-05, -.8717D-05, -.1534D-04,
     >    -.2688D-04, -.4680D-04, -.8069D-04, -.1373D-03, -.2294D-03,
     >    -.3737D-03, -.5898D-03, -.8941D-03, -.1292D-02, -.1771D-02,
     >    -.2298D-02, -.2827D-02, -.3317D-02, -.3738D-02, -.4078D-02,
     >    -.4339D-02, -.4531D-02, -.4666D-02, -.4755D-02, -.4804D-02,
     >    -.4819D-02, -.4799D-02, -.4744D-02, -.4650D-02, -.4508D-02,
     >    -.4310D-02, -.4048D-02, -.3721D-02, -.3345D-02, -.2940D-02,
     >    -.2530D-02, -.2137D-02, -.1776D-02, -.1453D-02, -.1175D-02,
     >    -.9379D-03, -.7415D-03, -.5826D-03, -.4521D-03, -.3501D-03,
     >    -.2677D-03, -.2047D-03, -.1552D-03, -.1177D-03, -.8770D-04,
     >    -.6671D-04/

      data (calcpts(j,39), j = 1,neta) /-.3741D-11, -.6654D-11,
     >    -.1183D-10, -.2104D-10, -.3742D-10, -.6653D-10, -.1183D-09,
     >    -.2104D-09, -.3740D-09, -.6651D-09, -.1183D-08, -.2103D-08,
     >    -.3740D-08, -.6652D-08, -.1182D-07, -.2102D-07, -.3738D-07,
     >    -.6644D-07, -.1181D-06, -.2099D-06, -.3727D-06, -.6618D-06,
     >    -.1175D-05, -.2082D-05, -.3684D-05, -.6508D-05, -.1145D-04,
     >    -.2007D-04, -.3494D-04, -.6024D-04, -.1025D-03, -.1713D-03,
     >    -.2790D-03, -.4403D-03, -.6675D-03, -.9646D-03, -.1322D-02,
     >    -.1715D-02, -.2110D-02, -.2476D-02, -.2791D-02, -.3045D-02,
     >    -.3240D-02, -.3385D-02, -.3487D-02, -.3557D-02, -.3599D-02,
     >    -.3617D-02, -.3614D-02, -.3589D-02, -.3539D-02, -.3461D-02,
     >    -.3349D-02, -.3196D-02, -.2996D-02, -.2749D-02, -.2466D-02,
     >    -.2164D-02, -.1858D-02, -.1568D-02, -.1299D-02, -.1062D-02,
     >    -.8571D-03, -.6832D-03, -.5408D-03, -.4223D-03, -.3293D-03,
     >    -.2543D-03, -.1943D-03, -.1494D-03, -.1134D-03, -.8486D-04,
     >    -.6387D-04/

      data (calcpts(j,40), j = 1,neta) /-.2780D-11, -.4945D-11,
     >    -.8790D-11, -.1563D-10, -.2781D-10, -.4944D-10, -.8792D-10,
     >    -.1564D-09, -.2779D-09, -.4943D-09, -.8792D-09, -.1563D-08,
     >    -.2780D-08, -.4944D-08, -.8786D-08, -.1562D-07, -.2778D-07,
     >    -.4939D-07, -.8778D-07, -.1560D-06, -.2770D-06, -.4919D-06,
     >    -.8731D-06, -.1547D-05, -.2739D-05, -.4837D-05, -.8511D-05,
     >    -.1492D-04, -.2597D-04, -.4478D-04, -.7619D-04, -.1273D-03,
     >    -.2074D-03, -.3273D-03, -.4962D-03, -.7170D-03, -.9827D-03,
     >    -.1275D-02, -.1569D-02, -.1841D-02, -.2074D-02, -.2263D-02,
     >    -.2409D-02, -.2517D-02, -.2594D-02, -.2647D-02, -.2681D-02,
     >    -.2699D-02, -.2703D-02, -.2693D-02, -.2668D-02, -.2626D-02,
     >    -.2564D-02, -.2477D-02, -.2360D-02, -.2208D-02, -.2023D-02,
     >    -.1812D-02, -.1586D-02, -.1360D-02, -.1145D-02, -.9475D-03,
     >    -.7736D-03, -.6222D-03, -.4962D-03, -.3913D-03, -.3058D-03,
     >    -.2368D-03, -.1828D-03, -.1408D-03, -.1063D-03, -.8082D-04,
     >    -.6132D-04/

      data (calcpts(j,41), j = 1,neta) /-.2059D-11, -.3662D-11,
     >    -.6509D-11, -.1158D-10, -.2059D-10, -.3661D-10, -.6510D-10,
     >    -.1158D-09, -.2058D-09, -.3660D-09, -.6511D-09, -.1158D-08,
     >    -.2058D-08, -.3661D-08, -.6506D-08, -.1157D-07, -.2057D-07,
     >    -.3657D-07, -.6500D-07, -.1155D-06, -.2051D-06, -.3643D-06,
     >    -.6465D-06, -.1146D-05, -.2028D-05, -.3582D-05, -.6303D-05,
     >    -.1105D-04, -.1923D-04, -.3316D-04, -.5642D-04, -.9427D-04,
     >    -.1536D-03, -.2424D-03, -.3674D-03, -.5310D-03, -.7278D-03,
     >    -.9443D-03, -.1162D-02, -.1363D-02, -.1536D-02, -.1676D-02,
     >    -.1784D-02, -.1864D-02, -.1922D-02, -.1962D-02, -.1988D-02,
     >    -.2004D-02, -.2011D-02, -.2008D-02, -.1996D-02, -.1974D-02,
     >    -.1940D-02, -.1891D-02, -.1825D-02, -.1736D-02, -.1622D-02,
     >    -.1484D-02, -.1327D-02, -.1160D-02, -.9928D-03, -.8341D-03,
     >    -.6894D-03, -.5615D-03, -.4517D-03, -.3587D-03, -.2823D-03,
     >    -.2208D-03, -.1713D-03, -.1323D-03, -.1008D-03, -.7679D-04,
     >    -.5729D-04/

      data (calcpts(j,42), j = 1,neta) /-.1520D-11, -.2703D-11,
     >    -.4804D-11, -.8545D-11, -.1520D-10, -.2702D-10, -.4806D-10,
     >    -.8547D-10, -.1519D-09, -.2702D-09, -.4806D-09, -.8545D-09,
     >    -.1519D-08, -.2702D-08, -.4802D-08, -.8540D-08, -.1519D-07,
     >    -.2700D-07, -.4798D-07, -.8528D-07, -.1514D-06, -.2689D-06,
     >    -.4773D-06, -.8459D-06, -.1497D-05, -.2644D-05, -.4653D-05,
     >    -.8154D-05, -.1420D-04, -.2448D-04, -.4165D-04, -.6959D-04,
     >    -.1134D-03, -.1789D-03, -.2712D-03, -.3920D-03, -.5372D-03,
     >    -.6971D-03, -.8576D-03, -.1006D-02, -.1134D-02, -.1237D-02,
     >    -.1317D-02, -.1376D-02, -.1419D-02, -.1449D-02, -.1469D-02,
     >    -.1482D-02, -.1489D-02, -.1490D-02, -.1485D-02, -.1474D-02,
     >    -.1455D-02, -.1428D-02, -.1391D-02, -.1340D-02, -.1274D-02,
     >    -.1189D-02, -.1086D-02, -.9692D-03, -.8460D-03, -.7231D-03,
     >    -.6067D-03, -.5007D-03, -.4073D-03, -.3272D-03, -.2599D-03,
     >    -.2045D-03, -.1595D-03, -.1234D-03, -.9489D-04, -.7254D-04,
     >    -.5514D-04/

      data (calcpts(j,43), j = 1,neta) /-.1118D-11, -.1989D-11,
     >    -.3535D-11, -.6287D-11, -.1118D-10, -.1988D-10, -.3536D-10,
     >    -.6289D-10, -.1118D-09, -.1988D-09, -.3536D-09, -.6287D-09,
     >    -.1118D-08, -.1988D-08, -.3534D-08, -.6284D-08, -.1118D-07,
     >    -.1986D-07, -.3531D-07, -.6275D-07, -.1114D-06, -.1979D-06,
     >    -.3512D-06, -.6224D-06, -.1102D-05, -.1946D-05, -.3424D-05,
     >    -.6000D-05, -.1045D-04, -.1801D-04, -.3065D-04, -.5121D-04,
     >    -.8342D-04, -.1317D-03, -.1996D-03, -.2884D-03, -.3953D-03,
     >    -.5129D-03, -.6310D-03, -.7404D-03, -.8344D-03, -.9105D-03,
     >    -.9691D-03, -.1013D-02, -.1044D-02, -.1066D-02, -.1082D-02,
     >    -.1092D-02, -.1097D-02, -.1100D-02, -.1098D-02, -.1093D-02,
     >    -.1084D-02, -.1069D-02, -.1048D-02, -.1020D-02, -.9815D-03,
     >    -.9317D-03, -.8684D-03, -.7922D-03, -.7063D-03, -.6156D-03,
     >    -.5255D-03, -.4402D-03, -.3628D-03, -.2947D-03, -.2365D-03,
     >    -.1876D-03, -.1474D-03, -.1149D-03, -.8879D-04, -.6824D-04,
     >    -.5204D-04/

      data (calcpts(j,44), j = 1,neta) /-.8203D-12, -.1459D-11,
     >    -.2593D-11, -.4612D-11, -.8204D-11, -.1459D-10, -.2594D-10,
     >    -.4614D-10, -.8200D-10, -.1458D-09, -.2594D-09, -.4613D-09,
     >    -.8202D-09, -.1459D-08, -.2592D-08, -.4610D-08, -.8198D-08,
     >    -.1457D-07, -.2590D-07, -.4604D-07, -.8174D-07, -.1452D-06,
     >    -.2576D-06, -.4566D-06, -.8081D-06, -.1427D-05, -.2512D-05,
     >    -.4402D-05, -.7664D-05, -.1321D-04, -.2248D-04, -.3757D-04,
     >    -.6120D-04, -.9659D-04, -.1464D-03, -.2116D-03, -.2900D-03,
     >    -.3763D-03, -.4630D-03, -.5432D-03, -.6122D-03, -.6679D-03,
     >    -.7110D-03, -.7430D-03, -.7662D-03, -.7826D-03, -.7939D-03,
     >    -.8015D-03, -.8062D-03, -.8086D-03, -.8088D-03, -.8068D-03,
     >    -.8022D-03, -.7944D-03, -.7828D-03, -.7667D-03, -.7451D-03,
     >    -.7161D-03, -.6790D-03, -.6323D-03, -.5761D-03, -.5130D-03,
     >    -.4466D-03, -.3806D-03, -.3185D-03, -.2621D-03, -.2128D-03,
     >    -.1705D-03, -.1351D-03, -.1060D-03, -.8242D-04, -.6367D-04,
     >    -.4882D-04/

      data (calcpts(j,45), j = 1,neta) /-.6004D-12, -.1068D-11,
     >    -.1898D-11, -.3376D-11, -.6005D-11, -.1068D-10, -.1899D-10,
     >    -.3377D-10, -.6002D-10, -.1068D-09, -.1899D-09, -.3376D-09,
     >    -.6003D-09, -.1068D-08, -.1897D-08, -.3374D-08, -.6001D-08,
     >    -.1067D-07, -.1896D-07, -.3370D-07, -.5983D-07, -.1062D-06,
     >    -.1886D-06, -.3342D-06, -.5915D-06, -.1045D-05, -.1838D-05,
     >    -.3222D-05, -.5610D-05, -.9672D-05, -.1646D-04, -.2750D-04,
     >    -.4479D-04, -.7070D-04, -.1072D-03, -.1549D-03, -.2123D-03,
     >    -.2754D-03, -.3389D-03, -.3976D-03, -.4481D-03, -.4889D-03,
     >    -.5204D-03, -.5439D-03, -.5608D-03, -.5729D-03, -.5812D-03,
     >    -.5869D-03, -.5906D-03, -.5927D-03, -.5935D-03, -.5929D-03,
     >    -.5908D-03, -.5869D-03, -.5807D-03, -.5718D-03, -.5596D-03,
     >    -.5434D-03, -.5222D-03, -.4948D-03, -.4602D-03, -.4188D-03,
     >    -.3725D-03, -.3239D-03, -.2758D-03, -.2305D-03, -.1895D-03,
     >    -.1537D-03, -.1229D-03, -.9744D-04, -.7629D-04, -.5934D-04,
     >    -.4584D-04/

      data (calcpts(j,46), j = 1,neta) /-.4382D-12, -.7794D-12,
     >    -.1385D-11, -.2464D-11, -.4383D-11, -.7793D-11, -.1386D-10,
     >    -.2465D-10, -.4381D-10, -.7791D-10, -.1386D-09, -.2464D-09,
     >    -.4381D-09, -.7792D-09, -.1385D-08, -.2463D-08, -.4380D-08,
     >    -.7785D-08, -.1384D-07, -.2459D-07, -.4367D-07, -.7755D-07,
     >    -.1376D-06, -.2439D-06, -.4317D-06, -.7625D-06, -.1342D-05,
     >    -.2351D-05, -.4094D-05, -.7059D-05, -.1201D-04, -.2007D-04,
     >    -.3269D-04, -.5160D-04, -.7822D-04, -.1130D-03, -.1549D-03,
     >    -.2010D-03, -.2473D-03, -.2902D-03, -.3270D-03, -.3568D-03,
     >    -.3798D-03, -.3969D-03, -.4093D-03, -.4181D-03, -.4243D-03,
     >    -.4285D-03, -.4313D-03, -.4330D-03, -.4338D-03, -.4339D-03,
     >    -.4331D-03, -.4312D-03, -.4281D-03, -.4233D-03, -.4165D-03,
     >    -.4073D-03, -.3952D-03, -.3795D-03, -.3590D-03, -.3339D-03,
     >    -.3036D-03, -.2697D-03, -.2342D-03, -.1992D-03, -.1662D-03,
     >    -.1365D-03, -.1106D-03, -.8839D-04, -.6994D-04, -.5479D-04,
     >    -.4249D-04/

      data (calcpts(j,47), j = 1,neta) /-.3191D-12, -.5675D-12,
     >    -.1009D-11, -.1794D-11, -.3191D-11, -.5674D-11, -.1009D-10,
     >    -.1795D-10, -.3190D-10, -.5673D-10, -.1009D-09, -.1794D-09,
     >    -.3190D-09, -.5674D-09, -.1008D-08, -.1793D-08, -.3189D-08,
     >    -.5668D-08, -.1007D-07, -.1791D-07, -.3179D-07, -.5646D-07,
     >    -.1002D-06, -.1776D-06, -.3143D-06, -.5552D-06, -.9769D-06,
     >    -.1712D-05, -.2981D-05, -.5140D-05, -.8745D-05, -.1461D-04,
     >    -.2380D-04, -.3757D-04, -.5695D-04, -.8230D-04, -.1128D-03,
     >    -.1464D-03, -.1801D-03, -.2113D-03, -.2381D-03, -.2598D-03,
     >    -.2765D-03, -.2890D-03, -.2980D-03, -.3045D-03, -.3090D-03,
     >    -.3120D-03, -.3141D-03, -.3155D-03, -.3162D-03, -.3165D-03,
     >    -.3162D-03, -.3154D-03, -.3139D-03, -.3114D-03, -.3077D-03,
     >    -.3026D-03, -.2957D-03, -.2868D-03, -.2752D-03, -.2603D-03,
     >    -.2417D-03, -.2195D-03, -.1948D-03, -.1690D-03, -.1435D-03,
     >    -.1197D-03, -.9825D-04, -.7935D-04, -.6345D-04, -.5010D-04,
     >    -.3915D-04/

      data (calcpts(j,48), j = 1,neta) /-.2319D-12, -.4124D-12,
     >    -.7330D-12, -.1304D-11, -.2319D-11, -.4123D-11, -.7332D-11,
     >    -.1304D-10, -.2318D-10, -.4122D-10, -.7332D-10, -.1304D-09,
     >    -.2318D-09, -.4123D-09, -.7327D-09, -.1303D-08, -.2317D-08,
     >    -.4119D-08, -.7321D-08, -.1301D-07, -.2310D-07, -.4103D-07,
     >    -.7282D-07, -.1291D-06, -.2284D-06, -.4035D-06, -.7099D-06,
     >    -.1244D-05, -.2166D-05, -.3735D-05, -.6355D-05, -.1062D-04,
     >    -.1730D-04, -.2730D-04, -.4139D-04, -.5981D-04, -.8197D-04,
     >    -.1064D-03, -.1309D-03, -.1535D-03, -.1730D-03, -.1888D-03,
     >    -.2010D-03, -.2100D-03, -.2166D-03, -.2213D-03, -.2245D-03,
     >    -.2268D-03, -.2283D-03, -.2293D-03, -.2300D-03, -.2303D-03,
     >    -.2303D-03, -.2299D-03, -.2292D-03, -.2280D-03, -.2261D-03,
     >    -.2233D-03, -.2195D-03, -.2143D-03, -.2077D-03, -.1992D-03,
     >    -.1883D-03, -.1747D-03, -.1585D-03, -.1406D-03, -.1218D-03,
     >    -.1034D-03, -.8612D-04, -.7060D-04, -.5695D-04, -.4555D-04,
     >    -.3595D-04/

      data (calcpts(j,49), j = 1,neta) /-.1681D-12, -.2990D-12,
     >    -.5315D-12, -.9453D-12, -.1681D-11, -.2990D-11, -.5317D-11,
     >    -.9456D-11, -.1681D-10, -.2989D-10, -.5317D-10, -.9454D-10,
     >    -.1681D-09, -.2990D-09, -.5313D-09, -.9449D-09, -.1680D-08,
     >    -.2987D-08, -.5309D-08, -.9436D-08, -.1675D-07, -.2975D-07,
     >    -.5281D-07, -.9359D-07, -.1656D-06, -.2926D-06, -.5148D-06,
     >    -.9022D-06, -.1571D-05, -.2708D-05, -.4608D-05, -.7700D-05,
     >    -.1254D-04, -.1980D-04, -.3001D-04, -.4337D-04, -.5944D-04,
     >    -.7713D-04, -.9489D-04, -.1113D-03, -.1255D-03, -.1369D-03,
     >    -.1457D-03, -.1523D-03, -.1571D-03, -.1604D-03, -.1628D-03,
     >    -.1645D-03, -.1656D-03, -.1663D-03, -.1668D-03, -.1671D-03,
     >    -.1672D-03, -.1671D-03, -.1668D-03, -.1662D-03, -.1652D-03,
     >    -.1638D-03, -.1617D-03, -.1588D-03, -.1550D-03, -.1502D-03,
     >    -.1439D-03, -.1359D-03, -.1260D-03, -.1143D-03, -.1012D-03,
     >    -.8765D-04, -.7430D-04, -.6185D-04, -.5062D-04, -.4087D-04,
     >    -.3257D-04/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xschqt = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end


      subroutine sqlbar_CT(eta, xi, xsqlba)
cmarco the subtracted term from eq (27) of PLB347 (1995) 143 - 151
c   longitudinal light quark initiated piece accompanying MF log.
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsqlba
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.7071D-14, 0.1258D-13,
     >    0.2235D-13, 0.3975D-13, 0.7071D-13, 0.1257D-12, 0.2236D-12,
     >    0.3977D-12, 0.7068D-12, 0.1257D-11, 0.2236D-11, 0.3975D-11,
     >    0.7068D-11, 0.1257D-10, 0.2234D-10, 0.3972D-10, 0.7062D-10,
     >    0.1255D-09, 0.2229D-09, 0.3959D-09, 0.7023D-09, 0.1245D-08,
     >    0.2205D-08, 0.3896D-08, 0.6863D-08, 0.1204D-07, 0.2097D-07,
     >    0.3623D-07, 0.6178D-07, 0.1034D-06, 0.1688D-06, 0.2662D-06,
     >    0.4012D-06, 0.5725D-06, 0.7658D-06, 0.9555D-06, 0.1113D-05,
     >    0.1217D-05, 0.1255D-05, 0.1223D-05, 0.1129D-05, 0.9890D-06,
     >    0.8246D-06, 0.6585D-06, 0.5077D-06, 0.3804D-06, 0.2780D-06,
     >    0.2007D-06, 0.1423D-06, 0.1004D-06, 0.6907D-07, 0.4861D-07,
     >    0.3374D-07, 0.2298D-07, 0.1593D-07, 0.1030D-07, 0.8102D-08,
     >    0.5170D-08, 0.3239D-08, 0.2466D-08, 0.1462D-08, 0.1800D-08,
     >    0.5305D-09, 0.6874D-09, 0.7944D-09, 0.8672D-09, 0.9168D-09,
     >    -.5494D-09, -.5264D-09, -.5107D-09, -.5000D-09, -.4927D-09,
     >    -.4878D-09/

      data (calcpts(j, 2), j = 1,neta) /0.1038D-13, 0.1846D-13,
     >    0.3281D-13, 0.5835D-13, 0.1038D-12, 0.1845D-12, 0.3282D-12,
     >    0.5837D-12, 0.1037D-11, 0.1845D-11, 0.3282D-11, 0.5835D-11,
     >    0.1037D-10, 0.1845D-10, 0.3279D-10, 0.5829D-10, 0.1036D-09,
     >    0.1842D-09, 0.3272D-09, 0.5811D-09, 0.1031D-08, 0.1828D-08,
     >    0.3237D-08, 0.5718D-08, 0.1007D-07, 0.1767D-07, 0.3078D-07,
     >    0.5317D-07, 0.9068D-07, 0.1518D-06, 0.2477D-06, 0.3907D-06,
     >    0.5888D-06, 0.8403D-06, 0.1124D-05, 0.1403D-05, 0.1635D-05,
     >    0.1788D-05, 0.1841D-05, 0.1796D-05, 0.1658D-05, 0.1451D-05,
     >    0.1210D-05, 0.9677D-06, 0.7471D-06, 0.5589D-06, 0.4104D-06,
     >    0.2951D-06, 0.2097D-06, 0.1473D-06, 0.1041D-06, 0.7141D-07,
     >    0.4950D-07, 0.3464D-07, 0.2390D-07, 0.1685D-07, 0.1272D-07,
     >    0.9026D-08, 0.6095D-08, 0.5663D-08, 0.3391D-08, 0.3887D-08,
     >    0.2724D-08, 0.2955D-08, 0.1612D-08, 0.1719D-08, 0.1791D-08,
     >    0.1841D-08, 0.1875D-08, 0.1898D-08, 0.1913D-08, 0.1924D-08,
     >    0.1931D-08/

      data (calcpts(j, 3), j = 1,neta) /0.1522D-13, 0.2708D-13,
     >    0.4812D-13, 0.8559D-13, 0.1522D-12, 0.2707D-12, 0.4814D-12,
     >    0.8562D-12, 0.1522D-11, 0.2706D-11, 0.4814D-11, 0.8559D-11,
     >    0.1522D-10, 0.2706D-10, 0.4809D-10, 0.8551D-10, 0.1520D-09,
     >    0.2701D-09, 0.4799D-09, 0.8524D-09, 0.1512D-08, 0.2681D-08,
     >    0.4748D-08, 0.8388D-08, 0.1478D-07, 0.2592D-07, 0.4515D-07,
     >    0.7800D-07, 0.1330D-06, 0.2226D-06, 0.3633D-06, 0.5731D-06,
     >    0.8638D-06, 0.1233D-05, 0.1649D-05, 0.2058D-05, 0.2397D-05,
     >    0.2621D-05, 0.2701D-05, 0.2633D-05, 0.2429D-05, 0.2126D-05,
     >    0.1772D-05, 0.1416D-05, 0.1091D-05, 0.8163D-06, 0.5969D-06,
     >    0.4288D-06, 0.3029D-06, 0.2122D-06, 0.1470D-06, 0.1055D-06,
     >    0.6832D-07, 0.3893D-07, 0.3458D-07, 0.2684D-07, 0.1679D-07,
     >    0.5163D-08, 0.7463D-08, 0.9030D-08, -.4902D-08, -.4174D-08,
     >    -.3679D-08, -.3341D-08, -.3111D-08, -.2954D-08, -.2847D-08,
     >    -.2774D-08, -.2725D-08, -.2691D-08, -.2668D-08, -.2652D-08,
     >    -.2642D-08/

      data (calcpts(j, 4), j = 1,neta) /0.2234D-13, 0.3973D-13,
     >    0.7061D-13, 0.1256D-12, 0.2234D-12, 0.3972D-12, 0.7063D-12,
     >    0.1256D-11, 0.2233D-11, 0.3971D-11, 0.7063D-11, 0.1256D-10,
     >    0.2233D-10, 0.3971D-10, 0.7057D-10, 0.1255D-09, 0.2231D-09,
     >    0.3964D-09, 0.7042D-09, 0.1251D-08, 0.2219D-08, 0.3934D-08,
     >    0.6967D-08, 0.1231D-07, 0.2168D-07, 0.3803D-07, 0.6626D-07,
     >    0.1145D-06, 0.1952D-06, 0.3267D-06, 0.5332D-06, 0.8410D-06,
     >    0.1268D-05, 0.1809D-05, 0.2420D-05, 0.3020D-05, 0.3519D-05,
     >    0.3848D-05, 0.3965D-05, 0.3865D-05, 0.3568D-05, 0.3128D-05,
     >    0.2606D-05, 0.2084D-05, 0.1606D-05, 0.1202D-05, 0.8735D-06,
     >    0.6284D-06, 0.4504D-06, 0.3150D-06, 0.2217D-06, 0.1508D-06,
     >    0.1093D-06, 0.7222D-07, 0.4284D-07, 0.3850D-07, 0.1576D-07,
     >    0.2071D-07, 0.9091D-08, 0.1139D-07, -.2043D-08, -.9755D-09,
     >    -.2487D-09, 0.2471D-09, 0.5849D-09, 0.8149D-09, 0.9716D-09,
     >    0.1078D-08, 0.1151D-08, 0.1201D-08, 0.1234D-08, 0.1257D-08,
     >    0.1273D-08/

      data (calcpts(j, 5), j = 1,neta) /0.3277D-13, 0.5829D-13,
     >    0.1036D-12, 0.1843D-12, 0.3277D-12, 0.5827D-12, 0.1036D-11,
     >    0.1843D-11, 0.3276D-11, 0.5826D-11, 0.1036D-10, 0.1842D-10,
     >    0.3276D-10, 0.5826D-10, 0.1035D-09, 0.1841D-09, 0.3273D-09,
     >    0.5816D-09, 0.1033D-08, 0.1835D-08, 0.3255D-08, 0.5772D-08,
     >    0.1022D-07, 0.1806D-07, 0.3181D-07, 0.5580D-07, 0.9721D-07,
     >    0.1679D-06, 0.2864D-06, 0.4793D-06, 0.7823D-06, 0.1234D-05,
     >    0.1860D-05, 0.2655D-05, 0.3553D-05, 0.4433D-05, 0.5166D-05,
     >    0.5649D-05, 0.5822D-05, 0.5680D-05, 0.5241D-05, 0.4590D-05,
     >    0.3820D-05, 0.3061D-05, 0.2354D-05, 0.1770D-05, 0.1289D-05,
     >    0.9368D-06, 0.6648D-06, 0.4732D-06, 0.3234D-06, 0.2304D-06,
     >    0.1596D-06, 0.1032D-06, 0.8115D-07, 0.5179D-07, 0.3243D-07,
     >    0.2470D-07, 0.1466D-07, 0.1803D-07, 0.5327D-08, 0.6894D-08,
     >    0.7960D-08, 0.8687D-08, 0.9183D-08, 0.9520D-08, 0.9750D-08,
     >    0.9907D-08, 0.1001D-07, 0.1009D-07, 0.1014D-07, 0.1017D-07,
     >    0.1019D-07/

      data (calcpts(j, 6), j = 1,neta) /0.4805D-13, 0.8547D-13,
     >    0.1519D-12, 0.2702D-12, 0.4806D-12, 0.8545D-12, 0.1519D-11,
     >    0.2703D-11, 0.4803D-11, 0.8543D-11, 0.1520D-10, 0.2702D-10,
     >    0.4804D-10, 0.8543D-10, 0.1518D-09, 0.2699D-09, 0.4799D-09,
     >    0.8528D-09, 0.1515D-08, 0.2691D-08, 0.4773D-08, 0.8463D-08,
     >    0.1499D-07, 0.2648D-07, 0.4664D-07, 0.8183D-07, 0.1425D-06,
     >    0.2462D-06, 0.4200D-06, 0.7029D-06, 0.1147D-05, 0.1810D-05,
     >    0.2729D-05, 0.3894D-05, 0.5212D-05, 0.6505D-05, 0.7579D-05,
     >    0.8289D-05, 0.8535D-05, 0.8330D-05, 0.7691D-05, 0.6728D-05,
     >    0.5606D-05, 0.4484D-05, 0.3460D-05, 0.2584D-05, 0.1900D-05,
     >    0.1368D-05, 0.9749D-06, 0.6750D-06, 0.4691D-06, 0.3348D-06,
     >    0.2270D-06, 0.1562D-06, 0.9983D-07, 0.7776D-07, 0.4838D-07,
     >    0.2904D-07, 0.2130D-07, 0.1124D-07, 0.1461D-07, 0.1912D-08,
     >    0.3475D-08, 0.4542D-08, 0.5269D-08, 0.5763D-08, 0.6101D-08,
     >    0.6330D-08, 0.6487D-08, 0.6593D-08, 0.6666D-08, 0.6716D-08,
     >    0.6749D-08/

      data (calcpts(j, 7), j = 1,neta) /0.7043D-13, 0.1253D-12,
     >    0.2227D-12, 0.3960D-12, 0.7044D-12, 0.1253D-11, 0.2227D-11,
     >    0.3961D-11, 0.7041D-11, 0.1252D-10, 0.2227D-10, 0.3960D-10,
     >    0.7041D-10, 0.1252D-09, 0.2225D-09, 0.3957D-09, 0.7035D-09,
     >    0.1250D-08, 0.2221D-08, 0.3944D-08, 0.6996D-08, 0.1241D-07,
     >    0.2197D-07, 0.3881D-07, 0.6837D-07, 0.1199D-06, 0.2090D-06,
     >    0.3610D-06, 0.6156D-06, 0.1031D-05, 0.1682D-05, 0.2654D-05,
     >    0.4001D-05, 0.5712D-05, 0.7645D-05, 0.9542D-05, 0.1112D-04,
     >    0.1217D-04, 0.1253D-04, 0.1222D-04, 0.1128D-04, 0.9879D-05,
     >    0.8236D-05, 0.6579D-05, 0.5079D-05, 0.3800D-05, 0.2788D-05,
     >    0.1996D-05, 0.1425D-05, 0.1005D-05, 0.6910D-06, 0.4859D-06,
     >    0.3367D-06, 0.2289D-06, 0.1582D-06, 0.1018D-06, 0.7968D-07,
     >    0.5030D-07, 0.3095D-07, 0.2320D-07, 0.1314D-07, 0.1650D-07,
     >    0.3796D-08, 0.5360D-08, 0.6425D-08, 0.7150D-08, 0.7644D-08,
     >    0.7981D-08, 0.8210D-08, 0.8367D-08, -.6527D-08, -.6454D-08,
     >    -.6405D-08/

      data (calcpts(j, 8), j = 1,neta) /0.1032D-12, 0.1835D-12,
     >    0.3262D-12, 0.5802D-12, 0.1032D-11, 0.1835D-11, 0.3263D-11,
     >    0.5804D-11, 0.1032D-10, 0.1835D-10, 0.3263D-10, 0.5802D-10,
     >    0.1032D-09, 0.1835D-09, 0.3260D-09, 0.5797D-09, 0.1031D-08,
     >    0.1831D-08, 0.3253D-08, 0.5779D-08, 0.1025D-07, 0.1818D-07,
     >    0.3219D-07, 0.5687D-07, 0.1002D-06, 0.1757D-06, 0.3062D-06,
     >    0.5289D-06, 0.9021D-06, 0.1510D-05, 0.2465D-05, 0.3890D-05,
     >    0.5866D-05, 0.8377D-05, 0.1121D-04, 0.1400D-04, 0.1632D-04,
     >    0.1785D-04, 0.1840D-04, 0.1795D-04, 0.1656D-04, 0.1450D-04,
     >    0.1209D-04, 0.9673D-05, 0.7465D-05, 0.5587D-05, 0.4094D-05,
     >    0.2950D-05, 0.2092D-05, 0.1480D-05, 0.1031D-05, 0.7180D-06,
     >    0.4981D-06, 0.3489D-06, 0.2410D-06, 0.1703D-06, 0.1288D-06,
     >    0.9171D-07, 0.6230D-07, 0.4292D-07, 0.3516D-07, 0.2510D-07,
     >    0.2845D-07, 0.1574D-07, 0.1730D-07, 0.1837D-07, 0.1909D-07,
     >    0.1958D-07, 0.1992D-07, 0.2015D-07, 0.2031D-07, 0.2041D-07,
     >    0.2048D-07/

      data (calcpts(j, 9), j = 1,neta) /0.1510D-12, 0.2685D-12,
     >    0.4773D-12, 0.8489D-12, 0.1510D-11, 0.2685D-11, 0.4774D-11,
     >    0.8491D-11, 0.1509D-10, 0.2684D-10, 0.4774D-10, 0.8488D-10,
     >    0.1509D-09, 0.2684D-09, 0.4770D-09, 0.8481D-09, 0.1508D-08,
     >    0.2679D-08, 0.4760D-08, 0.8454D-08, 0.1500D-07, 0.2659D-07,
     >    0.4709D-07, 0.8320D-07, 0.1466D-06, 0.2571D-06, 0.4480D-06,
     >    0.7740D-06, 0.1320D-05, 0.2210D-05, 0.3608D-05, 0.5695D-05,
     >    0.8591D-05, 0.1227D-04, 0.1643D-04, 0.2051D-04, 0.2392D-04,
     >    0.2616D-04, 0.2696D-04, 0.2628D-04, 0.2426D-04, 0.2123D-04,
     >    0.1770D-04, 0.1414D-04, 0.1090D-04, 0.8152D-05, 0.5971D-05,
     >    0.4277D-05, 0.3024D-05, 0.2126D-05, 0.1471D-05, 0.1008D-05,
     >    0.6944D-06, 0.4892D-06, 0.2948D-06, 0.2168D-06, 0.1159D-06,
     >    0.1494D-06, 0.2220D-07, 0.3774D-07, 0.4833D-07, 0.5555D-07,
     >    0.6046D-07, -.8619D-07, -.8390D-07, -.8235D-07, -.8129D-07,
     >    -.8057D-07, -.8008D-07, -.7974D-07, -.7951D-07, -.7936D-07,
     >    -.7925D-07/

      data (calcpts(j,10), j = 1,neta) /0.2207D-12, 0.3925D-12,
     >    0.6976D-12, 0.1241D-11, 0.2207D-11, 0.3924D-11, 0.6978D-11,
     >    0.1241D-10, 0.2206D-10, 0.3923D-10, 0.6978D-10, 0.1241D-09,
     >    0.2206D-09, 0.3923D-09, 0.6972D-09, 0.1240D-08, 0.2204D-08,
     >    0.3916D-08, 0.6958D-08, 0.1236D-07, 0.2192D-07, 0.3887D-07,
     >    0.6884D-07, 0.1216D-06, 0.2143D-06, 0.3759D-06, 0.6549D-06,
     >    0.1132D-05, 0.1930D-05, 0.3232D-05, 0.5279D-05, 0.8334D-05,
     >    0.1257D-04, 0.1797D-04, 0.2406D-04, 0.3007D-04, 0.3508D-04,
     >    0.3837D-04, 0.3956D-04, 0.3857D-04, 0.3560D-04, 0.3117D-04,
     >    0.2598D-04, 0.2081D-04, 0.1595D-04, 0.1201D-04, 0.8833D-05,
     >    0.6355D-05, 0.4407D-05, 0.3191D-05, 0.2248D-05, 0.1534D-05,
     >    0.9652D-06, 0.7414D-06, 0.4458D-06, 0.4011D-06, 0.1728D-06,
     >    0.2217D-06, 0.1051D-06, 0.1278D-06, -.6740D-08, 0.3811D-08,
     >    0.1099D-07, 0.1589D-07, 0.1923D-07, 0.2150D-07, 0.2305D-07,
     >    0.2410D-07, 0.2482D-07, 0.2531D-07, 0.2564D-07, 0.2587D-07,
     >    0.2603D-07/

      data (calcpts(j,11), j = 1,neta) /0.3220D-12, 0.5726D-12,
     >    0.1018D-11, 0.1810D-11, 0.3220D-11, 0.5725D-11, 0.1018D-10,
     >    0.1811D-10, 0.3218D-10, 0.5724D-10, 0.1018D-09, 0.1810D-09,
     >    0.3219D-09, 0.5724D-09, 0.1017D-08, 0.1809D-08, 0.3216D-08,
     >    0.5714D-08, 0.1015D-07, 0.1803D-07, 0.3198D-07, 0.5671D-07,
     >    0.1004D-06, 0.1775D-06, 0.3126D-06, 0.5485D-06, 0.9557D-06,
     >    0.1652D-05, 0.2818D-05, 0.4720D-05, 0.7710D-05, 0.1218D-04,
     >    0.1838D-04, 0.2628D-04, 0.3524D-04, 0.4405D-04, 0.5141D-04,
     >    0.5627D-04, 0.5802D-04, 0.5660D-04, 0.5232D-04, 0.4571D-04,
     >    0.3816D-04, 0.3050D-04, 0.2357D-04, 0.1761D-04, 0.1302D-04,
     >    0.9293D-05, 0.6683D-05, 0.4741D-05, 0.3224D-05, 0.2282D-05,
     >    0.1566D-05, 0.1146D-05, 0.7708D-06, 0.6244D-06, 0.4290D-06,
     >    0.3504D-06, 0.2491D-06, 0.1322D-06, 0.1548D-06, 0.1702D-06,
     >    0.3068D-07, 0.3783D-07, 0.4270D-07, 0.4601D-07, 0.4827D-07,
     >    0.4981D-07, 0.5086D-07, 0.5157D-07, 0.5206D-07, 0.5239D-07,
     >    0.5262D-07/

      data (calcpts(j,12), j = 1,neta) /0.4683D-12, 0.8329D-12,
     >    0.1480D-11, 0.2633D-11, 0.4683D-11, 0.8327D-11, 0.1481D-10,
     >    0.2634D-10, 0.4681D-10, 0.8325D-10, 0.1481D-09, 0.2633D-09,
     >    0.4681D-09, 0.8325D-09, 0.1479D-08, 0.2630D-08, 0.4677D-08,
     >    0.8310D-08, 0.1476D-07, 0.2622D-07, 0.4652D-07, 0.8249D-07,
     >    0.1461D-06, 0.2581D-06, 0.4548D-06, 0.7980D-06, 0.1391D-05,
     >    0.2403D-05, 0.4102D-05, 0.6872D-05, 0.1123D-04, 0.1775D-04,
     >    0.2682D-04, 0.3838D-04, 0.5150D-04, 0.6445D-04, 0.7526D-04,
     >    0.8242D-04, 0.8503D-04, 0.8298D-04, 0.7661D-04, 0.6705D-04,
     >    0.5593D-04, 0.4469D-04, 0.3455D-04, 0.2585D-04, 0.1898D-04,
     >    0.1369D-04, 0.9675D-05, 0.6918D-05, 0.4820D-05, 0.3300D-05,
     >    0.2353D-05, 0.1633D-05, 0.1211D-05, 0.8341D-06, 0.5363D-06,
     >    0.4901D-06, 0.4109D-06, 0.3091D-06, 0.1919D-06, 0.2143D-06,
     >    0.2296D-06, 0.8995D-07, 0.9703D-07, 0.1018D-06, 0.1051D-06,
     >    0.1074D-06, 0.1089D-06, 0.1099D-06, 0.1106D-06, 0.1111D-06,
     >    0.1115D-06/

      data (calcpts(j,13), j = 1,neta) /0.6783D-12, 0.1207D-11,
     >    0.2144D-11, 0.3814D-11, 0.6784D-11, 0.1206D-10, 0.2145D-10,
     >    0.3815D-10, 0.6781D-10, 0.1206D-09, 0.2145D-09, 0.3814D-09,
     >    0.6781D-09, 0.1206D-08, 0.2143D-08, 0.3811D-08, 0.6775D-08,
     >    0.1204D-07, 0.2139D-07, 0.3799D-07, 0.6739D-07, 0.1195D-06,
     >    0.2117D-06, 0.3740D-06, 0.6590D-06, 0.1156D-05, 0.2016D-05,
     >    0.3484D-05, 0.5948D-05, 0.9971D-05, 0.1631D-04, 0.2579D-04,
     >    0.3901D-04, 0.5590D-04, 0.7514D-04, 0.9416D-04, 0.1101D-03,
     >    0.1207D-03, 0.1245D-03, 0.1214D-03, 0.1122D-03, 0.9831D-04,
     >    0.8202D-04, 0.6564D-04, 0.5065D-04, 0.3808D-04, 0.2804D-04,
     >    0.2017D-04, 0.1443D-04, 0.1026D-04, 0.7188D-05, 0.5079D-05,
     >    0.3548D-05, 0.2593D-05, 0.1868D-05, 0.1441D-05, 0.1062D-05,
     >    0.7624D-06, 0.7149D-06, 0.4847D-06, 0.5323D-06, 0.4147D-06,
     >    0.4368D-06, 0.3018D-06, 0.3121D-06, 0.3191D-06, 0.3238D-06,
     >    0.3271D-06, 0.3293D-06, 0.3308D-06, 0.3318D-06, 0.3325D-06,
     >    0.3330D-06/

      data (calcpts(j,14), j = 1,neta) /0.9761D-12, 0.1736D-11,
     >    0.3086D-11, 0.5488D-11, 0.9762D-11, 0.1736D-10, 0.3087D-10,
     >    0.5490D-10, 0.9758D-10, 0.1735D-09, 0.3087D-09, 0.5488D-09,
     >    0.9758D-09, 0.1735D-08, 0.3084D-08, 0.5483D-08, 0.9750D-08,
     >    0.1732D-07, 0.3078D-07, 0.5467D-07, 0.9698D-07, 0.1720D-06,
     >    0.3046D-06, 0.5383D-06, 0.9486D-06, 0.1665D-05, 0.2903D-05,
     >    0.5020D-05, 0.8573D-05, 0.1438D-04, 0.2354D-04, 0.3728D-04,
     >    0.5648D-04, 0.8107D-04, 0.1092D-03, 0.1371D-03, 0.1605D-03,
     >    0.1760D-03, 0.1816D-03, 0.1773D-03, 0.1637D-03, 0.1434D-03,
     >    0.1196D-03, 0.9570D-04, 0.7384D-04, 0.5544D-04, 0.4061D-04,
     >    0.2922D-04, 0.2087D-04, 0.1464D-04, 0.1027D-04, 0.7166D-05,
     >    0.5032D-05, 0.3483D-05, 0.2366D-05, 0.1631D-05, 0.1199D-05,
     >    0.8151D-06, 0.6626D-06, 0.4631D-06, 0.3815D-06, 0.2782D-06,
     >    0.1600D-06, 0.1816D-06, 0.1964D-06, 0.2064D-06, 0.2133D-06,
     >    0.6796D-07, 0.7114D-07, 0.7330D-07, 0.7478D-07, 0.7578D-07,
     >    0.7647D-07/

      data (calcpts(j,15), j = 1,neta) /0.1392D-11, 0.2477D-11,
     >    0.4402D-11, 0.7829D-11, 0.1393D-10, 0.2476D-10, 0.4403D-10,
     >    0.7832D-10, 0.1392D-09, 0.2476D-09, 0.4403D-09, 0.7829D-09,
     >    0.1392D-08, 0.2476D-08, 0.4399D-08, 0.7822D-08, 0.1391D-07,
     >    0.2471D-07, 0.4391D-07, 0.7800D-07, 0.1384D-06, 0.2454D-06,
     >    0.4347D-06, 0.7682D-06, 0.1354D-05, 0.2377D-05, 0.4145D-05,
     >    0.7171D-05, 0.1226D-04, 0.2058D-04, 0.3373D-04, 0.5351D-04,
     >    0.8124D-04, 0.1169D-03, 0.1579D-03, 0.1988D-03, 0.2333D-03,
     >    0.2561D-03, 0.2645D-03, 0.2582D-03, 0.2385D-03, 0.2088D-03,
     >    0.1742D-03, 0.1394D-03, 0.1074D-03, 0.8048D-04, 0.5895D-04,
     >    0.4236D-04, 0.2994D-04, 0.2101D-04, 0.1453D-04, 0.9938D-05,
     >    0.6780D-05, 0.4608D-05, 0.3032D-05, 0.2046D-05, 0.1299D-05,
     >    0.8574D-06, 0.4678D-06, 0.3112D-06, 0.1088D-06, 0.2541D-07,
     >    -.7929D-07, -.1984D-06, -.1773D-06, -.1630D-06, -.1532D-06,
     >    -.2966D-06, -.2920D-06, -.2889D-06, -.2868D-06, -.2854D-06,
     >    -.2844D-06/

      data (calcpts(j,16), j = 1,neta) /0.1963D-11, 0.3491D-11,
     >    0.6205D-11, 0.1104D-10, 0.1963D-10, 0.3490D-10, 0.6206D-10,
     >    0.1104D-09, 0.1962D-09, 0.3489D-09, 0.6207D-09, 0.1104D-08,
     >    0.1962D-08, 0.3490D-08, 0.6201D-08, 0.1103D-07, 0.1960D-07,
     >    0.3484D-07, 0.6190D-07, 0.1099D-06, 0.1950D-06, 0.3459D-06,
     >    0.6129D-06, 0.1083D-05, 0.1910D-05, 0.3353D-05, 0.5851D-05,
     >    0.1013D-04, 0.1733D-04, 0.2913D-04, 0.4784D-04, 0.7607D-04,
     >    0.1158D-03, 0.1673D-03, 0.2269D-03, 0.2867D-03, 0.3375D-03,
     >    0.3716D-03, 0.3841D-03, 0.3753D-03, 0.3466D-03, 0.3039D-03,
     >    0.2537D-03, 0.2030D-03, 0.1565D-03, 0.1181D-03, 0.8594D-04,
     >    0.6177D-04, 0.4362D-04, 0.3032D-04, 0.2161D-04, 0.1543D-04,
     >    0.1088D-04, 0.6887D-05, 0.5260D-05, 0.3197D-05, 0.2334D-05,
     >    0.1270D-05, 0.1566D-05, 0.2684D-06, 0.4061D-06, 0.4999D-06,
     >    0.5638D-06, 0.6074D-06, 0.6370D-06, 0.6572D-06, -.8290D-06,
     >    -.8196D-06, -.8132D-06, -.8089D-06, -.8059D-06, -.8039D-06,
     >    -.8025D-06/

      data (calcpts(j,17), j = 1,neta) /0.2719D-11, 0.4836D-11,
     >    0.8595D-11, 0.1529D-10, 0.2719D-10, 0.4835D-10, 0.8598D-10,
     >    0.1529D-09, 0.2718D-09, 0.4834D-09, 0.8598D-09, 0.1529D-08,
     >    0.2718D-08, 0.4834D-08, 0.8590D-08, 0.1527D-07, 0.2716D-07,
     >    0.4826D-07, 0.8575D-07, 0.1523D-06, 0.2702D-06, 0.4794D-06,
     >    0.8493D-06, 0.1502D-05, 0.2648D-05, 0.4652D-05, 0.8121D-05,
     >    0.1407D-04, 0.2410D-04, 0.4059D-04, 0.6682D-04, 0.1066D-03,
     >    0.1630D-03, 0.2366D-03, 0.3226D-03, 0.4099D-03, 0.4847D-03,
     >    0.5352D-03, 0.5545D-03, 0.5421D-03, 0.5006D-03, 0.4394D-03,
     >    0.3677D-03, 0.2939D-03, 0.2269D-03, 0.1708D-03, 0.1253D-03,
     >    0.9057D-04, 0.6407D-04, 0.4530D-04, 0.3153D-04, 0.2250D-04,
     >    0.1459D-04, 0.9875D-05, 0.7276D-05, 0.5574D-05, 0.3457D-05,
     >    0.2560D-05, 0.1471D-05, 0.1751D-05, 0.4418D-06, 0.5718D-06,
     >    0.6603D-06, 0.7206D-06, 0.7618D-06, 0.7898D-06, 0.8088D-06,
     >    0.8218D-06, 0.8307D-06, 0.8367D-06, 0.8408D-06, 0.8436D-06,
     >    0.8455D-06/

      data (calcpts(j,18), j = 1,neta) /0.3677D-11, 0.6539D-11,
     >    0.1162D-10, 0.2067D-10, 0.3677D-10, 0.6538D-10, 0.1163D-09,
     >    0.2068D-09, 0.3675D-09, 0.6537D-09, 0.1163D-08, 0.2067D-08,
     >    0.3676D-08, 0.6537D-08, 0.1162D-07, 0.2066D-07, 0.3673D-07,
     >    0.6527D-07, 0.1160D-06, 0.2060D-06, 0.3655D-06, 0.6485D-06,
     >    0.1149D-05, 0.2032D-05, 0.3585D-05, 0.6301D-05, 0.1101D-04,
     >    0.1910D-04, 0.3277D-04, 0.5531D-04, 0.9132D-04, 0.1463D-03,
     >    0.2249D-03, 0.3286D-03, 0.4512D-03, 0.5776D-03, 0.6873D-03,
     >    0.7621D-03, 0.7917D-03, 0.7756D-03, 0.7173D-03, 0.6298D-03,
     >    0.5273D-03, 0.4235D-03, 0.3281D-03, 0.2463D-03, 0.1814D-03,
     >    0.1306D-03, 0.9257D-04, 0.6479D-04, 0.4509D-04, 0.3217D-04,
     >    0.2119D-04, 0.1446D-04, 0.9533D-05, 0.6787D-05, 0.4982D-05,
     >    0.2797D-05, 0.1853D-05, 0.2231D-05, 0.9891D-06, 0.1165D-05,
     >    -.2155D-06, -.1339D-06, -.7834D-07, -.4048D-07, -.1468D-07,
     >    0.2897D-08, 0.1486D-07, 0.2302D-07, 0.2858D-07, 0.3237D-07,
     >    0.3495D-07/

      data (calcpts(j,19), j = 1,neta) /0.4815D-11, 0.8565D-11,
     >    0.1522D-10, 0.2707D-10, 0.4816D-10, 0.8563D-10, 0.1523D-09,
     >    0.2708D-09, 0.4814D-09, 0.8561D-09, 0.1523D-08, 0.2707D-08,
     >    0.4814D-08, 0.8562D-08, 0.1521D-07, 0.2705D-07, 0.4811D-07,
     >    0.8549D-07, 0.1519D-06, 0.2699D-06, 0.4789D-06, 0.8497D-06,
     >    0.1506D-05, 0.2664D-05, 0.4702D-05, 0.8270D-05, 0.1446D-04,
     >    0.2512D-04, 0.4319D-04, 0.7311D-04, 0.1212D-03, 0.1951D-03,
     >    0.3020D-03, 0.4449D-03, 0.6166D-03, 0.7966D-03, 0.9558D-03,
     >    0.1067D-02, 0.1113D-02, 0.1092D-02, 0.1014D-02, 0.8925D-03,
     >    0.7478D-03, 0.6015D-03, 0.4664D-03, 0.3505D-03, 0.2583D-03,
     >    0.1857D-03, 0.1329D-03, 0.9248D-04, 0.6442D-04, 0.4501D-04,
     >    0.3124D-04, 0.2118D-04, 0.1405D-04, 0.1035D-04, 0.7411D-05,
     >    0.3979D-05, 0.3207D-05, 0.2202D-05, 0.1040D-05, 0.1270D-05,
     >    0.1427D-05, 0.3386D-07, 0.1067D-06, 0.1563D-06, 0.1901D-06,
     >    0.2131D-06, 0.2287D-06, 0.2394D-06, 0.2467D-06, 0.2517D-06,
     >    0.2551D-06/

      data (calcpts(j,20), j = 1,neta) /0.6052D-11, 0.1076D-10,
     >    0.1913D-10, 0.3403D-10, 0.6052D-10, 0.1076D-09, 0.1914D-09,
     >    0.3404D-09, 0.6050D-09, 0.1076D-08, 0.1914D-08, 0.3403D-08,
     >    0.6050D-08, 0.1076D-07, 0.1912D-07, 0.3400D-07, 0.6046D-07,
     >    0.1075D-06, 0.1909D-06, 0.3393D-06, 0.6021D-06, 0.1068D-05,
     >    0.1894D-05, 0.3352D-05, 0.5918D-05, 0.1042D-04, 0.1824D-04,
     >    0.3174D-04, 0.5468D-04, 0.9285D-04, 0.1546D-03, 0.2504D-03,
     >    0.3906D-03, 0.5811D-03, 0.8145D-03, 0.1065D-02, 0.1291D-02,
     >    0.1454D-02, 0.1525D-02, 0.1504D-02, 0.1401D-02, 0.1236D-02,
     >    0.1041D-02, 0.8396D-03, 0.6525D-03, 0.4925D-03, 0.3638D-03,
     >    0.2628D-03, 0.1870D-03, 0.1314D-03, 0.9228D-04, 0.6359D-04,
     >    0.4418D-04, 0.3088D-04, 0.2162D-04, 0.1401D-04, 0.9972D-05,
     >    0.6814D-05, 0.4728D-05, 0.3851D-05, 0.2776D-05, 0.1565D-05,
     >    0.1762D-05, 0.3964D-06, 0.4879D-06, 0.5502D-06, 0.5927D-06,
     >    0.6216D-06, 0.6413D-06, 0.6548D-06, 0.6639D-06, 0.6702D-06,
     >    0.6744D-06/

      data (calcpts(j,21), j = 1,neta) /0.7225D-11, 0.1285D-10,
     >    0.2284D-10, 0.4062D-10, 0.7226D-10, 0.1285D-09, 0.2285D-09,
     >    0.4064D-09, 0.7222D-09, 0.1285D-08, 0.2285D-08, 0.4062D-08,
     >    0.7223D-08, 0.1285D-07, 0.2283D-07, 0.4060D-07, 0.7219D-07,
     >    0.1283D-06, 0.2280D-06, 0.4051D-06, 0.7191D-06, 0.1276D-05,
     >    0.2263D-05, 0.4006D-05, 0.7078D-05, 0.1247D-04, 0.2186D-04,
     >    0.3809D-04, 0.6578D-04, 0.1121D-03, 0.1875D-03, 0.3057D-03,
     >    0.4809D-03, 0.7232D-03, 0.1027D-02, 0.1361D-02, 0.1674D-02,
     >    0.1907D-02, 0.2020D-02, 0.2003D-02, 0.1874D-02, 0.1664D-02,
     >    0.1407D-02, 0.1140D-02, 0.8905D-03, 0.6748D-03, 0.4981D-03,
     >    0.3607D-03, 0.2569D-03, 0.1812D-03, 0.1264D-03, 0.8829D-04,
     >    0.6015D-04, 0.4206D-04, 0.2761D-04, 0.1906D-04, 0.1240D-04,
     >    0.8007D-05, 0.6099D-05, 0.3843D-05, 0.2850D-05, 0.1695D-05,
     >    0.4300D-06, 0.5904D-06, 0.6997D-06, -.7260D-06, -.6753D-06,
     >    -.6407D-06, -.6172D-06, -.6012D-06, -.5902D-06, -.5828D-06,
     >    -.5777D-06/

      data (calcpts(j,22), j = 1,neta) /0.8126D-11, 0.1445D-10,
     >    0.2569D-10, 0.4569D-10, 0.8127D-10, 0.1445D-09, 0.2570D-09,
     >    0.4570D-09, 0.8123D-09, 0.1445D-08, 0.2570D-08, 0.4569D-08,
     >    0.8124D-08, 0.1445D-07, 0.2568D-07, 0.4566D-07, 0.8120D-07,
     >    0.1443D-06, 0.2565D-06, 0.4558D-06, 0.8090D-06, 0.1436D-05,
     >    0.2547D-05, 0.4511D-05, 0.7973D-05, 0.1406D-04, 0.2467D-04,
     >    0.4306D-04, 0.7453D-04, 0.1274D-03, 0.2141D-03, 0.3512D-03,
     >    0.5574D-03, 0.8476D-03, 0.1220D-02, 0.1643D-02, 0.2054D-02,
     >    0.2375D-02, 0.2546D-02, 0.2550D-02, 0.2406D-02, 0.2151D-02,
     >    0.1834D-02, 0.1496D-02, 0.1177D-02, 0.8971D-03, 0.6657D-03,
     >    0.4847D-03, 0.3465D-03, 0.2451D-03, 0.1721D-03, 0.1195D-03,
     >    0.8221D-04, 0.5604D-04, 0.3922D-04, 0.2660D-04, 0.1874D-04,
     >    0.1304D-04, 0.8271D-05, 0.6108D-05, 0.3678D-05, 0.2566D-05,
     >    0.1330D-05, 0.1511D-05, 0.1337D-06, 0.2174D-06, 0.2744D-06,
     >    0.3133D-06, 0.3397D-06, 0.3577D-06, 0.3700D-06, 0.3784D-06,
     >    0.3841D-06/

      data (calcpts(j,23), j = 1,neta) /0.8555D-11, 0.1522D-10,
     >    0.2705D-10, 0.4810D-10, 0.8556D-10, 0.1521D-09, 0.2705D-09,
     >    0.4812D-09, 0.8552D-09, 0.1521D-08, 0.2706D-08, 0.4810D-08,
     >    0.8554D-08, 0.1521D-07, 0.2704D-07, 0.4808D-07, 0.8549D-07,
     >    0.1520D-06, 0.2701D-06, 0.4799D-06, 0.8520D-06, 0.1513D-05,
     >    0.2684D-05, 0.4754D-05, 0.8406D-05, 0.1483D-04, 0.2605D-04,
     >    0.4552D-04, 0.7895D-04, 0.1353D-03, 0.2283D-03, 0.3768D-03,
     >    0.6026D-03, 0.9260D-03, 0.1351D-02, 0.1849D-02, 0.2353D-02,
     >    0.2770D-02, 0.3018D-02, 0.3064D-02, 0.2924D-02, 0.2640D-02,
     >    0.2273D-02, 0.1874D-02, 0.1488D-02, 0.1143D-02, 0.8549D-03,
     >    0.6257D-03, 0.4499D-03, 0.3189D-03, 0.2234D-03, 0.1552D-03,
     >    0.1080D-03, 0.7481D-04, 0.5080D-04, 0.3538D-04, 0.2466D-04,
     >    0.1606D-04, 0.1135D-04, 0.7732D-05, 0.5332D-05, 0.4241D-05,
     >    0.3019D-05, 0.1709D-05, 0.1838D-05, 0.4264D-06, 0.4864D-06,
     >    0.5273D-06, 0.5552D-06, 0.5742D-06, 0.5871D-06, 0.5959D-06,
     >    0.6019D-06/

      data (calcpts(j,24), j = 1,neta) /0.8413D-11, 0.1496D-10,
     >    0.2660D-10, 0.4731D-10, 0.8414D-10, 0.1496D-09, 0.2660D-09,
     >    0.4732D-09, 0.8410D-09, 0.1496D-08, 0.2661D-08, 0.4731D-08,
     >    0.8412D-08, 0.1496D-07, 0.2659D-07, 0.4728D-07, 0.8408D-07,
     >    0.1494D-06, 0.2656D-06, 0.4721D-06, 0.8381D-06, 0.1488D-05,
     >    0.2640D-05, 0.4678D-05, 0.8275D-05, 0.1461D-04, 0.2567D-04,
     >    0.4492D-04, 0.7802D-04, 0.1340D-03, 0.2268D-03, 0.3760D-03,
     >    0.6052D-03, 0.9383D-03, 0.1385D-02, 0.1925D-02, 0.2495D-02,
     >    0.2996D-02, 0.3329D-02, 0.3440D-02, 0.3331D-02, 0.3050D-02,
     >    0.2661D-02, 0.2221D-02, 0.1785D-02, 0.1387D-02, 0.1048D-02,
     >    0.7719D-03, 0.5577D-03, 0.3976D-03, 0.2806D-03, 0.1956D-03,
     >    0.1362D-03, 0.9383D-04, 0.6522D-04, 0.4373D-04, 0.2997D-04,
     >    0.2133D-04, 0.1360D-04, 0.9969D-05, 0.6059D-05, 0.4962D-05,
     >    0.3735D-05, 0.2422D-05, 0.1049D-05, 0.1136D-05, 0.1195D-05,
     >    -.2647D-06, -.2374D-06, -.2187D-06, -.2060D-06, -.1973D-06,
     >    -.1914D-06/

      data (calcpts(j,25), j = 1,neta) /0.7746D-11, 0.1378D-10,
     >    0.2449D-10, 0.4355D-10, 0.7747D-10, 0.1377D-09, 0.2449D-09,
     >    0.4357D-09, 0.7743D-09, 0.1377D-08, 0.2450D-08, 0.4355D-08,
     >    0.7745D-08, 0.1377D-07, 0.2448D-07, 0.4353D-07, 0.7741D-07,
     >    0.1376D-06, 0.2446D-06, 0.4347D-06, 0.7717D-06, 0.1370D-05,
     >    0.2432D-05, 0.4309D-05, 0.7624D-05, 0.1346D-04, 0.2367D-04,
     >    0.4144D-04, 0.7206D-04, 0.1240D-03, 0.2103D-03, 0.3497D-03,
     >    0.5656D-03, 0.8828D-03, 0.1316D-02, 0.1852D-02, 0.2441D-02,
     >    0.2990D-02, 0.3395D-02, 0.3583D-02, 0.3537D-02, 0.3295D-02,
     >    0.2920D-02, 0.2479D-02, 0.2022D-02, 0.1593D-02, 0.1219D-02,
     >    0.9078D-03, 0.6620D-03, 0.4748D-03, 0.3362D-03, 0.2362D-03,
     >    0.1638D-03, 0.1133D-03, 0.7819D-04, 0.5339D-04, 0.3641D-04,
     >    0.2462D-04, 0.1679D-04, 0.1159D-04, 0.7636D-05, 0.5006D-05,
     >    0.3758D-05, 0.2430D-05, 0.1047D-05, 0.1127D-05, 0.1181D-05,
     >    0.1218D-05, -.2567D-06, -.2395D-06, -.2278D-06, -.2198D-06,
     >    -.2144D-06/

      data (calcpts(j,26), j = 1,neta) /0.6715D-11, 0.1194D-10,
     >    0.2123D-10, 0.3775D-10, 0.6716D-10, 0.1194D-09, 0.2123D-09,
     >    0.3777D-09, 0.6712D-09, 0.1194D-08, 0.2124D-08, 0.3776D-08,
     >    0.6714D-08, 0.1194D-07, 0.2122D-07, 0.3774D-07, 0.6711D-07,
     >    0.1193D-06, 0.2120D-06, 0.3768D-06, 0.6690D-06, 0.1188D-05,
     >    0.2108D-05, 0.3737D-05, 0.6612D-05, 0.1168D-04, 0.2054D-04,
     >    0.3598D-04, 0.6259D-04, 0.1078D-03, 0.1831D-03, 0.3051D-03,
     >    0.4950D-03, 0.7763D-03, 0.1165D-02, 0.1656D-02, 0.2213D-02,
     >    0.2759D-02, 0.3201D-02, 0.3456D-02, 0.3490D-02, 0.3320D-02,
     >    0.3002D-02, 0.2595D-02, 0.2157D-02, 0.1730D-02, 0.1343D-02,
     >    0.1015D-02, 0.7487D-03, 0.5417D-03, 0.3862D-03, 0.2735D-03,
     >    0.1906D-03, 0.1314D-03, 0.9113D-04, 0.6284D-04, 0.4252D-04,
     >    0.2901D-04, 0.1952D-04, 0.1272D-04, 0.8687D-05, 0.6008D-05,
     >    0.4726D-05, 0.1876D-05, 0.1977D-05, 0.5462D-06, 0.5933D-06,
     >    0.6254D-06, 0.6473D-06, -.8378D-06, -.8277D-06, -.8207D-06,
     >    -.8160D-06/

      data (calcpts(j,27), j = 1,neta) /0.5527D-11, 0.9830D-11,
     >    0.1747D-10, 0.3108D-10, 0.5528D-10, 0.9829D-10, 0.1748D-09,
     >    0.3109D-09, 0.5525D-09, 0.9827D-09, 0.1748D-08, 0.3108D-08,
     >    0.5526D-08, 0.9828D-08, 0.1747D-07, 0.3106D-07, 0.5524D-07,
     >    0.9818D-07, 0.1745D-06, 0.3102D-06, 0.5507D-06, 0.9780D-06,
     >    0.1736D-05, 0.3076D-05, 0.5444D-05, 0.9614D-05, 0.1691D-04,
     >    0.2963D-04, 0.5158D-04, 0.8887D-04, 0.1511D-03, 0.2521D-03,
     >    0.4098D-03, 0.6445D-03, 0.9714D-03, 0.1391D-02, 0.1877D-02,
     >    0.2374D-02, 0.2806D-02, 0.3100D-02, 0.3208D-02, 0.3127D-02,
     >    0.2890D-02, 0.2554D-02, 0.2168D-02, 0.1775D-02, 0.1405D-02,
     >    0.1080D-02, 0.8101D-03, 0.5929D-03, 0.4277D-03, 0.3048D-03,
     >    0.2141D-03, 0.1493D-03, 0.1037D-03, 0.7180D-04, 0.4960D-04,
     >    0.3432D-04, 0.2316D-04, 0.1623D-04, 0.1211D-04, 0.7877D-05,
     >    0.5057D-05, 0.3680D-05, 0.2263D-05, 0.2320D-05, 0.2359D-05,
     >    0.8854D-06, 0.9034D-06, 0.9157D-06, 0.9240D-06, 0.9297D-06,
     >    0.9336D-06/

      data (calcpts(j,28), j = 1,neta) /0.4356D-11, 0.7748D-11,
     >    0.1377D-10, 0.2449D-10, 0.4356D-10, 0.7746D-10, 0.1377D-09,
     >    0.2450D-09, 0.4354D-09, 0.7745D-09, 0.1378D-08, 0.2449D-08,
     >    0.4355D-08, 0.7746D-08, 0.1377D-07, 0.2448D-07, 0.4353D-07,
     >    0.7738D-07, 0.1375D-06, 0.2445D-06, 0.4340D-06, 0.7708D-06,
     >    0.1368D-05, 0.2425D-05, 0.4291D-05, 0.7579D-05, 0.1333D-04,
     >    0.2337D-04, 0.4067D-04, 0.7011D-04, 0.1192D-03, 0.1991D-03,
     >    0.3240D-03, 0.5104D-03, 0.7713D-03, 0.1109D-02, 0.1507D-02,
     >    0.1926D-02, 0.2310D-02, 0.2603D-02, 0.2758D-02, 0.2758D-02,
     >    0.2615D-02, 0.2366D-02, 0.2056D-02, 0.1721D-02, 0.1394D-02,
     >    0.1094D-02, 0.8339D-03, 0.6218D-03, 0.4527D-03, 0.3258D-03,
     >    0.2304D-03, 0.1613D-03, 0.1134D-03, 0.7795D-04, 0.5386D-04,
     >    0.3683D-04, 0.2549D-04, 0.1693D-04, 0.1274D-04, 0.8447D-05,
     >    0.5589D-05, 0.4186D-05, 0.2751D-05, 0.1296D-05, 0.1327D-05,
     >    0.1348D-05, 0.1362D-05, 0.1372D-05, -.1219D-06, -.1174D-06,
     >    -.1143D-06/

      data (calcpts(j,29), j = 1,neta) /0.3316D-11, 0.5897D-11,
     >    0.1048D-10, 0.1864D-10, 0.3316D-10, 0.5896D-10, 0.1048D-09,
     >    0.1865D-09, 0.3314D-09, 0.5895D-09, 0.1049D-08, 0.1864D-08,
     >    0.3315D-08, 0.5896D-08, 0.1048D-07, 0.1863D-07, 0.3314D-07,
     >    0.5890D-07, 0.1047D-06, 0.1861D-06, 0.3304D-06, 0.5867D-06,
     >    0.1041D-05, 0.1846D-05, 0.3266D-05, 0.5769D-05, 0.1015D-04,
     >    0.1779D-04, 0.3097D-04, 0.5339D-04, 0.9082D-04, 0.1517D-03,
     >    0.2470D-03, 0.3894D-03, 0.5895D-03, 0.8495D-03, 0.1159D-02,
     >    0.1491D-02, 0.1808D-02, 0.2068D-02, 0.2237D-02, 0.2292D-02,
     >    0.2232D-02, 0.2073D-02, 0.1847D-02, 0.1585D-02, 0.1314D-02,
     >    0.1055D-02, 0.8229D-03, 0.6239D-03, 0.4621D-03, 0.3359D-03,
     >    0.2403D-03, 0.1702D-03, 0.1186D-03, 0.8264D-04, 0.5672D-04,
     >    0.3945D-04, 0.2646D-04, 0.1780D-04, 0.1203D-04, 0.9188D-05,
     >    0.6296D-05, 0.3370D-05, 0.1920D-05, 0.1954D-05, 0.4774D-06,
     >    0.4932D-06, 0.5040D-06, 0.5114D-06, 0.5164D-06, 0.5198D-06,
     >    0.5221D-06/

      data (calcpts(j,30), j = 1,neta) /0.2456D-11, 0.4369D-11,
     >    0.7765D-11, 0.1381D-10, 0.2457D-10, 0.4368D-10, 0.7767D-10,
     >    0.1381D-09, 0.2455D-09, 0.4367D-09, 0.7768D-09, 0.1381D-08,
     >    0.2456D-08, 0.4368D-08, 0.7762D-08, 0.1380D-07, 0.2455D-07,
     >    0.4363D-07, 0.7756D-07, 0.1378D-06, 0.2448D-06, 0.4347D-06,
     >    0.7714D-06, 0.1367D-05, 0.2420D-05, 0.4274D-05, 0.7520D-05,
     >    0.1318D-04, 0.2295D-04, 0.3956D-04, 0.6730D-04, 0.1124D-03,
     >    0.1831D-03, 0.2889D-03, 0.4376D-03, 0.6315D-03, 0.8634D-03,
     >    0.1115D-02, 0.1361D-02, 0.1574D-02, 0.1729D-02, 0.1809D-02,
     >    0.1807D-02, 0.1725D-02, 0.1579D-02, 0.1391D-02, 0.1183D-02,
     >    0.9743D-03, 0.7788D-03, 0.6043D-03, 0.4562D-03, 0.3371D-03,
     >    0.2448D-03, 0.1753D-03, 0.1230D-03, 0.8669D-04, 0.6049D-04,
     >    0.4154D-04, 0.2841D-04, 0.1966D-04, 0.1383D-04, 0.9450D-05,
     >    0.6530D-05, 0.3585D-05, 0.3622D-05, 0.2147D-05, 0.6646D-06,
     >    0.6763D-06, 0.6843D-06, 0.6898D-06, 0.6935D-06, 0.6960D-06,
     >    0.6977D-06/

      data (calcpts(j,31), j = 1,neta) /0.1782D-11, 0.3169D-11,
     >    0.5632D-11, 0.1002D-10, 0.1782D-10, 0.3168D-10, 0.5634D-10,
     >    0.1002D-09, 0.1781D-09, 0.3168D-09, 0.5634D-09, 0.1002D-08,
     >    0.1781D-08, 0.3168D-08, 0.5630D-08, 0.1001D-07, 0.1781D-07,
     >    0.3165D-07, 0.5626D-07, 0.9999D-07, 0.1775D-06, 0.3153D-06,
     >    0.5596D-06, 0.9917D-06, 0.1755D-05, 0.3100D-05, 0.5455D-05,
     >    0.9560D-05, 0.1665D-04, 0.2870D-04, 0.4883D-04, 0.8158D-04,
     >    0.1329D-03, 0.2097D-03, 0.3177D-03, 0.4588D-03, 0.6281D-03,
     >    0.8132D-03, 0.9961D-03, 0.1159D-02, 0.1288D-02, 0.1369D-02,
     >    0.1397D-02, 0.1369D-02, 0.1288D-02, 0.1166D-02, 0.1019D-02,
     >    0.8616D-03, 0.7061D-03, 0.5616D-03, 0.4343D-03, 0.3274D-03,
     >    0.2414D-03, 0.1742D-03, 0.1245D-03, 0.8781D-04, 0.6139D-04,
     >    0.4228D-04, 0.2905D-04, 0.2024D-04, 0.1436D-04, 0.9946D-05,
     >    0.7004D-05, 0.4044D-05, 0.2570D-05, 0.2589D-05, 0.1101D-05,
     >    0.1110D-05, 0.1116D-05, 0.1120D-05, -.3777D-06, -.3759D-06,
     >    -.3746D-06/

      data (calcpts(j,32), j = 1,neta) /0.1272D-11, 0.2262D-11,
     >    0.4020D-11, 0.7150D-11, 0.1272D-10, 0.2261D-10, 0.4021D-10,
     >    0.7152D-10, 0.1271D-09, 0.2261D-09, 0.4021D-09, 0.7150D-09,
     >    0.1271D-08, 0.2261D-08, 0.4019D-08, 0.7146D-08, 0.1271D-07,
     >    0.2259D-07, 0.4015D-07, 0.7136D-07, 0.1267D-06, 0.2250D-06,
     >    0.3994D-06, 0.7078D-06, 0.1253D-05, 0.2213D-05, 0.3893D-05,
     >    0.6823D-05, 0.1188D-04, 0.2048D-04, 0.3485D-04, 0.5823D-04,
     >    0.9486D-04, 0.1497D-03, 0.2269D-03, 0.3278D-03, 0.4490D-03,
     >    0.5819D-03, 0.7143D-03, 0.8346D-03, 0.9331D-03, 0.1003D-02,
     >    0.1040D-02, 0.1042D-02, 0.1006D-02, 0.9370D-03, 0.8420D-03,
     >    0.7316D-03, 0.6159D-03, 0.5030D-03, 0.3989D-03, 0.3078D-03,
     >    0.2315D-03, 0.1704D-03, 0.1231D-03, 0.8770D-04, 0.6186D-04,
     >    0.4310D-04, 0.2994D-04, 0.2062D-04, 0.1411D-04, 0.9669D-05,
     >    0.6560D-05, 0.4488D-05, 0.3008D-05, 0.1971D-05, 0.1230D-05,
     >    0.7857D-06, 0.4899D-06, 0.3427D-06, 0.1946D-06, 0.4594D-07,
     >    0.4683D-07/

      data (calcpts(j,33), j = 1,neta) /0.8970D-12, 0.1596D-11,
     >    0.2836D-11, 0.5044D-11, 0.8972D-11, 0.1595D-10, 0.2837D-10,
     >    0.5045D-10, 0.8967D-10, 0.1595D-09, 0.2837D-09, 0.5044D-09,
     >    0.8969D-09, 0.1595D-08, 0.2835D-08, 0.5041D-08, 0.8965D-08,
     >    0.1594D-07, 0.2832D-07, 0.5034D-07, 0.8939D-07, 0.1587D-06,
     >    0.2817D-06, 0.4993D-06, 0.8838D-06, 0.1561D-05, 0.2747D-05,
     >    0.4814D-05, 0.8381D-05, 0.1445D-04, 0.2459D-04, 0.4108D-04,
     >    0.6692D-04, 0.1056D-03, 0.1601D-03, 0.2313D-03, 0.3170D-03,
     >    0.4110D-03, 0.5051D-03, 0.5914D-03, 0.6637D-03, 0.7184D-03,
     >    0.7533D-03, 0.7669D-03, 0.7573D-03, 0.7242D-03, 0.6695D-03,
     >    0.5985D-03, 0.5181D-03, 0.4348D-03, 0.3544D-03, 0.2805D-03,
     >    0.2162D-03, 0.1625D-03, 0.1195D-03, 0.8643D-04, 0.6152D-04,
     >    0.4342D-04, 0.3035D-04, 0.2115D-04, 0.1461D-04, 0.1015D-04,
     >    0.7032D-05, 0.4801D-05, 0.3315D-05, 0.2424D-05, 0.1681D-05,
     >    0.1235D-05, 0.7878D-06, 0.6398D-06, 0.4911D-06, 0.3421D-06,
     >    0.3427D-06/

      data (calcpts(j,34), j = 1,neta) /0.6268D-12, 0.1115D-11,
     >    0.1982D-11, 0.3525D-11, 0.6269D-11, 0.1115D-10, 0.1982D-10,
     >    0.3526D-10, 0.6266D-10, 0.1114D-09, 0.1982D-09, 0.3525D-09,
     >    0.6267D-09, 0.1115D-08, 0.1981D-08, 0.3523D-08, 0.6265D-08,
     >    0.1114D-07, 0.1979D-07, 0.3518D-07, 0.6246D-07, 0.1109D-06,
     >    0.1969D-06, 0.3489D-06, 0.6176D-06, 0.1091D-05, 0.1919D-05,
     >    0.3364D-05, 0.5857D-05, 0.1010D-04, 0.1718D-04, 0.2871D-04,
     >    0.4677D-04, 0.7381D-04, 0.1119D-03, 0.1617D-03, 0.2216D-03,
     >    0.2874D-03, 0.3534D-03, 0.4142D-03, 0.4658D-03, 0.5061D-03,
     >    0.5344D-03, 0.5501D-03, 0.5524D-03, 0.5402D-03, 0.5129D-03,
     >    0.4718D-03, 0.4202D-03, 0.3626D-03, 0.3038D-03, 0.2471D-03,
     >    0.1954D-03, 0.1503D-03, 0.1129D-03, 0.8290D-04, 0.5986D-04,
     >    0.4259D-04, 0.3009D-04, 0.2100D-04, 0.1460D-04, 0.1013D-04,
     >    0.6998D-05, 0.4762D-05, 0.3271D-05, 0.2228D-05, 0.1632D-05,
     >    0.1035D-05, 0.7373D-06, 0.5887D-06, 0.4396D-06, 0.2903D-06,
     >    0.1407D-06/

      data (calcpts(j,35), j = 1,neta) /0.4350D-12, 0.7738D-12,
     >    0.1375D-11, 0.2446D-11, 0.4351D-11, 0.7736D-11, 0.1376D-10,
     >    0.2447D-10, 0.4349D-10, 0.7735D-10, 0.1376D-09, 0.2446D-09,
     >    0.4350D-09, 0.7736D-09, 0.1375D-08, 0.2445D-08, 0.4348D-08,
     >    0.7729D-08, 0.1374D-07, 0.2442D-07, 0.4335D-07, 0.7699D-07,
     >    0.1366D-06, 0.2422D-06, 0.4286D-06, 0.7571D-06, 0.1332D-05,
     >    0.2335D-05, 0.4065D-05, 0.7008D-05, 0.1192D-04, 0.1992D-04,
     >    0.3246D-04, 0.5123D-04, 0.7766D-04, 0.1122D-03, 0.1538D-03,
     >    0.1995D-03, 0.2454D-03, 0.2878D-03, 0.3240D-03, 0.3528D-03,
     >    0.3739D-03, 0.3876D-03, 0.3936D-03, 0.3915D-03, 0.3802D-03,
     >    0.3592D-03, 0.3292D-03, 0.2924D-03, 0.2519D-03, 0.2107D-03,
     >    0.1711D-03, 0.1351D-03, 0.1039D-03, 0.7790D-04, 0.5719D-04,
     >    0.4124D-04, 0.2931D-04, 0.2065D-04, 0.1438D-04, 0.1005D-04,
     >    0.6917D-05, 0.4677D-05, 0.3184D-05, 0.2138D-05, 0.1541D-05,
     >    0.9433D-06, 0.6447D-06, 0.4957D-06, 0.3463D-06, 0.1968D-06,
     >    0.4708D-07/

      data (calcpts(j,36), j = 1,neta) /0.3005D-12, 0.5345D-12,
     >    0.9500D-12, 0.1690D-11, 0.3005D-11, 0.5344D-11, 0.9502D-11,
     >    0.1690D-10, 0.3004D-10, 0.5343D-10, 0.9503D-10, 0.1690D-09,
     >    0.3005D-09, 0.5344D-09, 0.9497D-09, 0.1689D-08, 0.3003D-08,
     >    0.5338D-08, 0.9488D-08, 0.1686D-07, 0.2994D-07, 0.5318D-07,
     >    0.9438D-07, 0.1673D-06, 0.2960D-06, 0.5229D-06, 0.9201D-06,
     >    0.1613D-05, 0.2808D-05, 0.4841D-05, 0.8237D-05, 0.1376D-04,
     >    0.2242D-04, 0.3538D-04, 0.5364D-04, 0.7751D-04, 0.1062D-03,
     >    0.1378D-03, 0.1696D-03, 0.1989D-03, 0.2240D-03, 0.2442D-03,
     >    0.2594D-03, 0.2699D-03, 0.2761D-03, 0.2777D-03, 0.2743D-03,
     >    0.2651D-03, 0.2496D-03, 0.2282D-03, 0.2023D-03, 0.1741D-03,
     >    0.1455D-03, 0.1180D-03, 0.9320D-04, 0.7159D-04, 0.5369D-04,
     >    0.3936D-04, 0.2845D-04, 0.2023D-04, 0.1425D-04, 0.9918D-05,
     >    0.6928D-05, 0.4684D-05, 0.3339D-05, 0.2292D-05, 0.1544D-05,
     >    0.1095D-05, 0.6464D-06, 0.4971D-06, 0.3476D-06, 0.1979D-06,
     >    0.1981D-06/

      data (calcpts(j,37), j = 1,neta) /0.2068D-12, 0.3678D-12,
     >    0.6537D-12, 0.1163D-11, 0.2068D-11, 0.3677D-11, 0.6539D-11,
     >    0.1163D-10, 0.2067D-10, 0.3676D-10, 0.6539D-10, 0.1163D-09,
     >    0.2068D-09, 0.3677D-09, 0.6535D-09, 0.1162D-08, 0.2067D-08,
     >    0.3673D-08, 0.6529D-08, 0.1161D-07, 0.2061D-07, 0.3659D-07,
     >    0.6495D-07, 0.1151D-06, 0.2037D-06, 0.3598D-06, 0.6331D-06,
     >    0.1110D-05, 0.1932D-05, 0.3331D-05, 0.5668D-05, 0.9470D-05,
     >    0.1543D-04, 0.2435D-04, 0.3691D-04, 0.5334D-04, 0.7311D-04,
     >    0.9485D-04, 0.1167D-03, 0.1369D-03, 0.1542D-03, 0.1682D-03,
     >    0.1789D-03, 0.1865D-03, 0.1915D-03, 0.1940D-03, 0.1939D-03,
     >    0.1906D-03, 0.1836D-03, 0.1724D-03, 0.1573D-03, 0.1393D-03,
     >    0.1198D-03, 0.1000D-03, 0.8116D-04, 0.6403D-04, 0.4914D-04,
     >    0.3688D-04, 0.2701D-04, 0.1954D-04, 0.1385D-04, 0.9811D-05,
     >    0.6817D-05, 0.4722D-05, 0.3225D-05, 0.2177D-05, 0.1579D-05,
     >    0.9795D-06, 0.6802D-06, 0.5307D-06, 0.3810D-06, 0.2312D-06,
     >    0.8135D-07/

      data (calcpts(j,38), j = 1,neta) /0.1419D-12, 0.2524D-12,
     >    0.4485D-12, 0.7978D-12, 0.1419D-11, 0.2523D-11, 0.4487D-11,
     >    0.7980D-11, 0.1418D-10, 0.2523D-10, 0.4487D-10, 0.7978D-10,
     >    0.1419D-09, 0.2523D-09, 0.4484D-09, 0.7974D-09, 0.1418D-08,
     >    0.2521D-08, 0.4480D-08, 0.7963D-08, 0.1414D-07, 0.2511D-07,
     >    0.4456D-07, 0.7898D-07, 0.1398D-06, 0.2469D-06, 0.4344D-06,
     >    0.7614D-06, 0.1326D-05, 0.2286D-05, 0.3889D-05, 0.6498D-05,
     >    0.1059D-04, 0.1671D-04, 0.2533D-04, 0.3660D-04, 0.5016D-04,
     >    0.6509D-04, 0.8007D-04, 0.9395D-04, 0.1059D-03, 0.1155D-03,
     >    0.1229D-03, 0.1283D-03, 0.1320D-03, 0.1343D-03, 0.1351D-03,
     >    0.1344D-03, 0.1316D-03, 0.1265D-03, 0.1186D-03, 0.1081D-03,
     >    0.9565D-04, 0.8217D-04, 0.6858D-04, 0.5562D-04, 0.4385D-04,
     >    0.3367D-04, 0.2521D-04, 0.1849D-04, 0.1333D-04, 0.9480D-05,
     >    0.6665D-05, 0.4643D-05, 0.3220D-05, 0.2216D-05, 0.1512D-05,
     >    0.1033D-05, 0.7036D-06, 0.2689D-06, 0.3141D-06, 0.2093D-06,
     >    0.1344D-06/

      data (calcpts(j,39), j = 1,neta) /0.9721D-13, 0.1729D-12,
     >    0.3073D-12, 0.5466D-12, 0.9722D-12, 0.1729D-11, 0.3074D-11,
     >    0.5467D-11, 0.9717D-11, 0.1728D-10, 0.3074D-10, 0.5466D-10,
     >    0.9719D-10, 0.1729D-09, 0.3072D-09, 0.5463D-09, 0.9715D-09,
     >    0.1727D-08, 0.3069D-08, 0.5455D-08, 0.9686D-08, 0.1720D-07,
     >    0.3053D-07, 0.5411D-07, 0.9577D-07, 0.1692D-06, 0.2976D-06,
     >    0.5216D-06, 0.9082D-06, 0.1566D-05, 0.2664D-05, 0.4452D-05,
     >    0.7252D-05, 0.1145D-04, 0.1735D-04, 0.2507D-04, 0.3437D-04,
     >    0.4459D-04, 0.5486D-04, 0.6437D-04, 0.7254D-04, 0.7914D-04,
     >    0.8422D-04, 0.8797D-04, 0.9062D-04, 0.9238D-04, 0.9334D-04,
     >    0.9349D-04, 0.9267D-04, 0.9059D-04, 0.8691D-04, 0.8140D-04,
     >    0.7414D-04, 0.6557D-04, 0.5631D-04, 0.4698D-04, 0.3810D-04,
     >    0.3004D-04, 0.2306D-04, 0.1728D-04, 0.1268D-04, 0.9146D-05,
     >    0.6510D-05, 0.4592D-05, 0.3213D-05, 0.2224D-05, 0.1550D-05,
     >    0.1070D-05, 0.7407D-06, 0.5159D-06, 0.3511D-06, 0.2462D-06,
     >    0.1713D-06/

      data (calcpts(j,40), j = 1,neta) /0.6647D-13, 0.1182D-12,
     >    0.2101D-12, 0.3737D-12, 0.6648D-12, 0.1182D-11, 0.2102D-11,
     >    0.3739D-11, 0.6645D-11, 0.1182D-10, 0.2102D-10, 0.3738D-10,
     >    0.6646D-10, 0.1182D-09, 0.2101D-09, 0.3736D-09, 0.6643D-09,
     >    0.1181D-08, 0.2099D-08, 0.3730D-08, 0.6624D-08, 0.1176D-07,
     >    0.2088D-07, 0.3700D-07, 0.6549D-07, 0.1157D-06, 0.2035D-06,
     >    0.3567D-06, 0.6210D-06, 0.1071D-05, 0.1822D-05, 0.3044D-05,
     >    0.4959D-05, 0.7827D-05, 0.1187D-04, 0.1715D-04, 0.2350D-04,
     >    0.3049D-04, 0.3751D-04, 0.4402D-04, 0.4960D-04, 0.5412D-04,
     >    0.5760D-04, 0.6019D-04, 0.6204D-04, 0.6331D-04, 0.6410D-04,
     >    0.6447D-04, 0.6436D-04, 0.6366D-04, 0.6213D-04, 0.5954D-04,
     >    0.5572D-04, 0.5072D-04, 0.4483D-04, 0.3849D-04, 0.3210D-04,
     >    0.2603D-04, 0.2052D-04, 0.1576D-04, 0.1180D-04, 0.8654D-05,
     >    0.6241D-05, 0.4442D-05, 0.3123D-05, 0.2179D-05, 0.1519D-05,
     >    0.1055D-05, 0.7248D-06, 0.5000D-06, 0.3351D-06, 0.2302D-06,
     >    0.1702D-06/

      data (calcpts(j,41), j = 1,neta) /0.4540D-13, 0.8075D-13,
     >    0.1435D-12, 0.2553D-12, 0.4541D-12, 0.8074D-12, 0.1436D-11,
     >    0.2554D-11, 0.4539D-11, 0.8072D-11, 0.1436D-10, 0.2553D-10,
     >    0.4539D-10, 0.8074D-10, 0.1435D-09, 0.2552D-09, 0.4538D-09,
     >    0.8066D-09, 0.1434D-08, 0.2548D-08, 0.4524D-08, 0.8035D-08,
     >    0.1426D-07, 0.2527D-07, 0.4473D-07, 0.7901D-07, 0.1390D-06,
     >    0.2436D-06, 0.4242D-06, 0.7314D-06, 0.1244D-05, 0.2079D-05,
     >    0.3387D-05, 0.5346D-05, 0.8105D-05, 0.1171D-04, 0.1605D-04,
     >    0.2083D-04, 0.2562D-04, 0.3006D-04, 0.3388D-04, 0.3697D-04,
     >    0.3935D-04, 0.4112D-04, 0.4239D-04, 0.4329D-04, 0.4388D-04,
     >    0.4423D-04, 0.4434D-04, 0.4417D-04, 0.4362D-04, 0.4252D-04,
     >    0.4072D-04, 0.3808D-04, 0.3465D-04, 0.3062D-04, 0.2628D-04,
     >    0.2192D-04, 0.1777D-04, 0.1400D-04, 0.1074D-04, 0.8047D-05,
     >    0.5904D-05, 0.4255D-05, 0.3025D-05, 0.2126D-05, 0.1481D-05,
     >    0.1031D-05, 0.7015D-06, 0.4916D-06, 0.3266D-06, 0.2217D-06,
     >    0.1467D-06/

      data (calcpts(j,42), j = 1,neta) /0.3100D-13, 0.5513D-13,
     >    0.9799D-13, 0.1743D-12, 0.3100D-12, 0.5512D-12, 0.9801D-12,
     >    0.1743D-11, 0.3098D-11, 0.5511D-11, 0.9802D-11, 0.1743D-10,
     >    0.3099D-10, 0.5512D-10, 0.9795D-10, 0.1742D-09, 0.3098D-09,
     >    0.5506D-09, 0.9787D-09, 0.1740D-08, 0.3089D-08, 0.5485D-08,
     >    0.9735D-08, 0.1725D-07, 0.3054D-07, 0.5394D-07, 0.9490D-07,
     >    0.1663D-06, 0.2896D-06, 0.4993D-06, 0.8496D-06, 0.1420D-05,
     >    0.2313D-05, 0.3650D-05, 0.5533D-05, 0.7995D-05, 0.1096D-04,
     >    0.1422D-04, 0.1749D-04, 0.2052D-04, 0.2313D-04, 0.2524D-04,
     >    0.2686D-04, 0.2807D-04, 0.2895D-04, 0.2957D-04, 0.2999D-04,
     >    0.3026D-04, 0.3040D-04, 0.3041D-04, 0.3025D-04, 0.2984D-04,
     >    0.2907D-04, 0.2782D-04, 0.2601D-04, 0.2366D-04, 0.2091D-04,
     >    0.1794D-04, 0.1497D-04, 0.1213D-04, 0.9555D-05, 0.7337D-05,
     >    0.5493D-05, 0.4024D-05, 0.2899D-05, 0.2059D-05, 0.1460D-05,
     >    0.1010D-05, 0.7099D-06, 0.4850D-06, 0.3350D-06, 0.2300D-06,
     >    0.1551D-06/

      data (calcpts(j,43), j = 1,neta) /0.2115D-13, 0.3761D-13,
     >    0.6685D-13, 0.1189D-12, 0.2115D-12, 0.3761D-12, 0.6687D-12,
     >    0.1189D-11, 0.2114D-11, 0.3760D-11, 0.6688D-11, 0.1189D-10,
     >    0.2114D-10, 0.3760D-10, 0.6683D-10, 0.1188D-09, 0.2113D-09,
     >    0.3757D-09, 0.6677D-09, 0.1187D-08, 0.2107D-08, 0.3742D-08,
     >    0.6642D-08, 0.1177D-07, 0.2083D-07, 0.3680D-07, 0.6475D-07,
     >    0.1135D-06, 0.1976D-06, 0.3407D-06, 0.5796D-06, 0.9685D-06,
     >    0.1578D-05, 0.2490D-05, 0.3775D-05, 0.5455D-05, 0.7477D-05,
     >    0.9701D-05, 0.1193D-04, 0.1400D-04, 0.1578D-04, 0.1722D-04,
     >    0.1833D-04, 0.1916D-04, 0.1975D-04, 0.2018D-04, 0.2047D-04,
     >    0.2067D-04, 0.2079D-04, 0.2084D-04, 0.2082D-04, 0.2068D-04,
     >    0.2039D-04, 0.1985D-04, 0.1899D-04, 0.1775D-04, 0.1614D-04,
     >    0.1426D-04, 0.1224D-04, 0.1021D-04, 0.8272D-05, 0.6518D-05,
     >    0.5005D-05, 0.3746D-05, 0.2741D-05, 0.1976D-05, 0.1406D-05,
     >    0.9865D-06, 0.6866D-06, 0.4766D-06, 0.3267D-06, 0.2217D-06,
     >    0.1617D-06/

      data (calcpts(j,44), j = 1,neta) /0.1442D-13, 0.2565D-13,
     >    0.4559D-13, 0.8108D-13, 0.1442D-12, 0.2564D-12, 0.4560D-12,
     >    0.8110D-12, 0.1441D-11, 0.2564D-11, 0.4560D-11, 0.8108D-11,
     >    0.1442D-10, 0.2564D-10, 0.4557D-10, 0.8104D-10, 0.1441D-09,
     >    0.2562D-09, 0.4553D-09, 0.8093D-09, 0.1437D-08, 0.2552D-08,
     >    0.4529D-08, 0.8027D-08, 0.1421D-07, 0.2509D-07, 0.4415D-07,
     >    0.7738D-07, 0.1347D-06, 0.2323D-06, 0.3952D-06, 0.6604D-06,
     >    0.1076D-05, 0.1698D-05, 0.2574D-05, 0.3720D-05, 0.5098D-05,
     >    0.6615D-05, 0.8138D-05, 0.9549D-05, 0.1076D-04, 0.1174D-04,
     >    0.1250D-04, 0.1306D-04, 0.1347D-04, 0.1376D-04, 0.1396D-04,
     >    0.1410D-04, 0.1419D-04, 0.1424D-04, 0.1426D-04, 0.1422D-04,
     >    0.1412D-04, 0.1391D-04, 0.1354D-04, 0.1295D-04, 0.1211D-04,
     >    0.1101D-04, 0.9725D-05, 0.8345D-05, 0.6957D-05, 0.5636D-05,
     >    0.4442D-05, 0.3407D-05, 0.2551D-05, 0.1870D-05, 0.1348D-05,
     >    0.9585D-06, 0.6736D-06, 0.4696D-06, 0.3241D-06, 0.2236D-06,
     >    0.1532D-06/

      data (calcpts(j,45), j = 1,neta) /0.9834D-14, 0.1749D-13,
     >    0.3109D-13, 0.5530D-13, 0.9836D-13, 0.1749D-12, 0.3110D-12,
     >    0.5531D-12, 0.9831D-12, 0.1749D-11, 0.3110D-11, 0.5530D-11,
     >    0.9833D-11, 0.1749D-10, 0.3108D-10, 0.5527D-10, 0.9829D-10,
     >    0.1747D-09, 0.3105D-09, 0.5519D-09, 0.9800D-09, 0.1740D-08,
     >    0.3089D-08, 0.5474D-08, 0.9689D-08, 0.1711D-07, 0.3011D-07,
     >    0.5277D-07, 0.9189D-07, 0.1584D-06, 0.2696D-06, 0.4504D-06,
     >    0.7337D-06, 0.1158D-05, 0.1756D-05, 0.2537D-05, 0.3477D-05,
     >    0.4511D-05, 0.5550D-05, 0.6512D-05, 0.7339D-05, 0.8008D-05,
     >    0.8524D-05, 0.8909D-05, 0.9187D-05, 0.9385D-05, 0.9524D-05,
     >    0.9620D-05, 0.9684D-05, 0.9725D-05, 0.9746D-05, 0.9745D-05,
     >    0.9716D-05, 0.9642D-05, 0.9496D-05, 0.9241D-05, 0.8837D-05,
     >    0.8258D-05, 0.7509D-05, 0.6633D-05, 0.5691D-05, 0.4745D-05,
     >    0.3847D-05, 0.3031D-05, 0.2327D-05, 0.1743D-05, 0.1278D-05,
     >    0.9198D-06, 0.6558D-06, 0.4624D-06, 0.3229D-06, 0.2254D-06,
     >    0.1564D-06/

      data (calcpts(j,46), j = 1,neta) /0.6703D-14, 0.1192D-13,
     >    0.2119D-13, 0.3769D-13, 0.6704D-13, 0.1192D-12, 0.2120D-12,
     >    0.3770D-12, 0.6701D-12, 0.1192D-11, 0.2120D-11, 0.3769D-11,
     >    0.6702D-11, 0.1192D-10, 0.2118D-10, 0.3767D-10, 0.6699D-10,
     >    0.1191D-09, 0.2116D-09, 0.3762D-09, 0.6679D-09, 0.1186D-08,
     >    0.2105D-08, 0.3731D-08, 0.6603D-08, 0.1166D-07, 0.2052D-07,
     >    0.3597D-07, 0.6263D-07, 0.1080D-06, 0.1837D-06, 0.3070D-06,
     >    0.5001D-06, 0.7893D-06, 0.1196D-05, 0.1729D-05, 0.2370D-05,
     >    0.3075D-05, 0.3783D-05, 0.4439D-05, 0.5002D-05, 0.5458D-05,
     >    0.5810D-05, 0.6072D-05, 0.6262D-05, 0.6397D-05, 0.6492D-05,
     >    0.6557D-05, 0.6602D-05, 0.6632D-05, 0.6650D-05, 0.6657D-05,
     >    0.6652D-05, 0.6629D-05, 0.6576D-05, 0.6475D-05, 0.6300D-05,
     >    0.6024D-05, 0.5629D-05, 0.5117D-05, 0.4519D-05, 0.3879D-05,
     >    0.3234D-05, 0.2621D-05, 0.2066D-05, 0.1585D-05, 0.1187D-05,
     >    0.8707D-06, 0.6277D-06, 0.4462D-06, 0.3143D-06, 0.2198D-06,
     >    0.1523D-06/

      data (calcpts(j,47), j = 1,neta) /0.4567D-14, 0.8124D-14,
     >    0.1444D-13, 0.2568D-13, 0.4568D-13, 0.8122D-13, 0.1444D-12,
     >    0.2569D-12, 0.4566D-12, 0.8121D-12, 0.1444D-11, 0.2568D-11,
     >    0.4567D-11, 0.8122D-11, 0.1443D-10, 0.2567D-10, 0.4565D-10,
     >    0.8114D-10, 0.1442D-09, 0.2563D-09, 0.4551D-09, 0.8083D-09,
     >    0.1435D-08, 0.2542D-08, 0.4500D-08, 0.7948D-08, 0.1398D-07,
     >    0.2451D-07, 0.4267D-07, 0.7358D-07, 0.1252D-06, 0.2092D-06,
     >    0.3408D-06, 0.5378D-06, 0.8153D-06, 0.1178D-05, 0.1615D-05,
     >    0.2095D-05, 0.2578D-05, 0.3025D-05, 0.3409D-05, 0.3719D-05,
     >    0.3959D-05, 0.4138D-05, 0.4267D-05, 0.4359D-05, 0.4424D-05,
     >    0.4468D-05, 0.4499D-05, 0.4520D-05, 0.4534D-05, 0.4541D-05,
     >    0.4543D-05, 0.4537D-05, 0.4520D-05, 0.4483D-05, 0.4413D-05,
     >    0.4294D-05, 0.4105D-05, 0.3835D-05, 0.3487D-05, 0.3080D-05,
     >    0.2643D-05, 0.2203D-05, 0.1785D-05, 0.1407D-05, 0.1078D-05,
     >    0.8084D-06, 0.5924D-06, 0.4274D-06, 0.3029D-06, 0.2129D-06,
     >    0.1484D-06/

      data (calcpts(j,48), j = 1,neta) /0.3113D-14, 0.5537D-14,
     >    0.9840D-14, 0.1750D-13, 0.3113D-13, 0.5535D-13, 0.9843D-13,
     >    0.1751D-12, 0.3112D-12, 0.5534D-12, 0.9844D-12, 0.1750D-11,
     >    0.3112D-11, 0.5535D-11, 0.9837D-11, 0.1749D-10, 0.3111D-10,
     >    0.5530D-10, 0.9829D-10, 0.1747D-09, 0.3102D-09, 0.5509D-09,
     >    0.9777D-09, 0.1733D-08, 0.3067D-08, 0.5417D-08, 0.9531D-08,
     >    0.1670D-07, 0.2908D-07, 0.5014D-07, 0.8532D-07, 0.1426D-06,
     >    0.2322D-06, 0.3665D-06, 0.5557D-06, 0.8030D-06, 0.1101D-05,
     >    0.1428D-05, 0.1757D-05, 0.2061D-05, 0.2323D-05, 0.2535D-05,
     >    0.2698D-05, 0.2820D-05, 0.2908D-05, 0.2971D-05, 0.3015D-05,
     >    0.3045D-05, 0.3067D-05, 0.3081D-05, 0.3091D-05, 0.3097D-05,
     >    0.3100D-05, 0.3099D-05, 0.3094D-05, 0.3082D-05, 0.3056D-05,
     >    0.3009D-05, 0.2927D-05, 0.2798D-05, 0.2614D-05, 0.2377D-05,
     >    0.2099D-05, 0.1801D-05, 0.1502D-05, 0.1217D-05, 0.9587D-06,
     >    0.7353D-06, 0.5508D-06, 0.4038D-06, 0.2913D-06, 0.2073D-06,
     >    0.1458D-06/

      data (calcpts(j,49), j = 1,neta) /0.2121D-14, 0.3773D-14,
     >    0.6706D-14, 0.1193D-13, 0.2121D-13, 0.3772D-13, 0.6708D-13,
     >    0.1193D-12, 0.2120D-12, 0.3771D-12, 0.6708D-12, 0.1193D-11,
     >    0.2121D-11, 0.3772D-11, 0.6703D-11, 0.1192D-10, 0.2120D-10,
     >    0.3768D-10, 0.6698D-10, 0.1190D-09, 0.2114D-09, 0.3754D-09,
     >    0.6662D-09, 0.1181D-08, 0.2090D-08, 0.3691D-08, 0.6495D-08,
     >    0.1138D-07, 0.1982D-07, 0.3417D-07, 0.5814D-07, 0.9715D-07,
     >    0.1583D-06, 0.2498D-06, 0.3786D-06, 0.5472D-06, 0.7499D-06,
     >    0.9731D-06, 0.1197D-05, 0.1405D-05, 0.1583D-05, 0.1727D-05,
     >    0.1839D-05, 0.1921D-05, 0.1982D-05, 0.2024D-05, 0.2054D-05,
     >    0.2075D-05, 0.2090D-05, 0.2100D-05, 0.2106D-05, 0.2111D-05,
     >    0.2113D-05, 0.2114D-05, 0.2113D-05, 0.2110D-05, 0.2101D-05,
     >    0.2083D-05, 0.2050D-05, 0.1994D-05, 0.1907D-05, 0.1781D-05,
     >    0.1620D-05, 0.1430D-05, 0.1227D-05, 0.1023D-05, 0.8291D-06,
     >    0.6532D-06, 0.5011D-06, 0.3751D-06, 0.2746D-06, 0.1981D-06,
     >    0.1411D-06/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >        (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsqlba = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end


      subroutine sqtbar_CT(eta, xi, xsqtba)
cmarco the subtracted term from eq (27) of PLB347 (1995) 143 - 151
c   transverse light quark initiated piece accompanying the MF log 
c   prop. to e_H^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsqtba
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.9803D-10, 0.1739D-09,
     >    0.3086D-09, 0.5482D-09, 0.9743D-09, 0.1731D-08, 0.3078D-08,
     >    0.5473D-08, 0.9724D-08, 0.1729D-07, 0.3076D-07, 0.5469D-07,
     >    0.9724D-07, 0.1729D-06, 0.3073D-06, 0.5465D-06, 0.9718D-06,
     >    0.1727D-05, 0.3070D-05, 0.5455D-05, 0.9683D-05, 0.1719D-04,
     >    0.3050D-04, 0.5401D-04, 0.9550D-04, 0.1684D-03, 0.2957D-03,
     >    0.5166D-03, 0.8955D-03, 0.1534D-02, 0.2586D-02, 0.4266D-02,
     >    0.6826D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2798D-01,
     >    0.3406D-01, 0.3874D-01, 0.4130D-01, 0.4150D-01, 0.3958D-01,
     >    0.3613D-01, 0.3180D-01, 0.2716D-01, 0.2264D-01, 0.1849D-01,
     >    0.1485D-01, 0.1178D-01, 0.9225D-02, 0.7162D-02, 0.5499D-02,
     >    0.4200D-02, 0.3187D-02, 0.2403D-02, 0.1803D-02, 0.1348D-02,
     >    0.1000D-02, 0.7489D-03, 0.5516D-03, 0.4103D-03, 0.2962D-03,
     >    0.2103D-03, 0.1530D-03, 0.1099D-03, 0.8117D-04, 0.6703D-04,
     >    0.3763D-04, 0.3803D-04, 0.2330D-04, 0.2349D-04, 0.8619D-05,
     >    0.8705D-05/

      data (calcpts(j, 2), j = 1,neta) /0.9804D-10, 0.1739D-09,
     >    0.3085D-09, 0.5481D-09, 0.9742D-09, 0.1731D-08, 0.3077D-08,
     >    0.5472D-08, 0.9723D-08, 0.1729D-07, 0.3076D-07, 0.5468D-07,
     >    0.9722D-07, 0.1729D-06, 0.3073D-06, 0.5464D-06, 0.9717D-06,
     >    0.1727D-05, 0.3069D-05, 0.5455D-05, 0.9682D-05, 0.1719D-04,
     >    0.3050D-04, 0.5401D-04, 0.9548D-04, 0.1684D-03, 0.2957D-03,
     >    0.5165D-03, 0.8953D-03, 0.1534D-02, 0.2586D-02, 0.4265D-02,
     >    0.6827D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2797D-01,
     >    0.3407D-01, 0.3875D-01, 0.4129D-01, 0.4150D-01, 0.3958D-01,
     >    0.3613D-01, 0.3180D-01, 0.2716D-01, 0.2264D-01, 0.1850D-01,
     >    0.1486D-01, 0.1177D-01, 0.9227D-02, 0.7149D-02, 0.5501D-02,
     >    0.4202D-02, 0.3189D-02, 0.2405D-02, 0.1804D-02, 0.1350D-02,
     >    0.1002D-02, 0.7507D-03, 0.5534D-03, 0.4121D-03, 0.2980D-03,
     >    0.2120D-03, 0.1548D-03, 0.1117D-03, 0.8293D-04, 0.5380D-04,
     >    0.3939D-04, 0.2480D-04, 0.2507D-04, 0.1026D-04, 0.1039D-04,
     >    0.1047D-04/

      data (calcpts(j, 3), j = 1,neta) /0.9802D-10, 0.1739D-09,
     >    0.3085D-09, 0.5481D-09, 0.9742D-09, 0.1731D-08, 0.3077D-08,
     >    0.5472D-08, 0.9722D-08, 0.1729D-07, 0.3076D-07, 0.5468D-07,
     >    0.9722D-07, 0.1729D-06, 0.3072D-06, 0.5464D-06, 0.9717D-06,
     >    0.1727D-05, 0.3069D-05, 0.5454D-05, 0.9682D-05, 0.1719D-04,
     >    0.3049D-04, 0.5400D-04, 0.9548D-04, 0.1684D-03, 0.2956D-03,
     >    0.5165D-03, 0.8953D-03, 0.1534D-02, 0.2585D-02, 0.4265D-02,
     >    0.6825D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2798D-01,
     >    0.3406D-01, 0.3873D-01, 0.4130D-01, 0.4150D-01, 0.3958D-01,
     >    0.3613D-01, 0.3180D-01, 0.2716D-01, 0.2264D-01, 0.1849D-01,
     >    0.1485D-01, 0.1178D-01, 0.9223D-02, 0.7160D-02, 0.5497D-02,
     >    0.4198D-02, 0.3184D-02, 0.2401D-02, 0.1800D-02, 0.1345D-02,
     >    0.9976D-03, 0.7463D-03, 0.5490D-03, 0.4077D-03, 0.2936D-03,
     >    0.2227D-03, 0.1654D-03, 0.1223D-03, 0.7854D-04, 0.6441D-04,
     >    0.5000D-04, 0.3540D-04, 0.2068D-04, 0.2087D-04, 0.5994D-05,
     >    0.6081D-05/

      data (calcpts(j, 4), j = 1,neta) /0.9800D-10, 0.1739D-09,
     >    0.3085D-09, 0.5480D-09, 0.9740D-09, 0.1731D-08, 0.3077D-08,
     >    0.5471D-08, 0.9721D-08, 0.1729D-07, 0.3075D-07, 0.5467D-07,
     >    0.9720D-07, 0.1729D-06, 0.3072D-06, 0.5463D-06, 0.9715D-06,
     >    0.1727D-05, 0.3069D-05, 0.5454D-05, 0.9680D-05, 0.1718D-04,
     >    0.3049D-04, 0.5399D-04, 0.9547D-04, 0.1684D-03, 0.2956D-03,
     >    0.5164D-03, 0.8952D-03, 0.1533D-02, 0.2585D-02, 0.4264D-02,
     >    0.6824D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2797D-01,
     >    0.3407D-01, 0.3873D-01, 0.4129D-01, 0.4149D-01, 0.3959D-01,
     >    0.3613D-01, 0.3181D-01, 0.2716D-01, 0.2264D-01, 0.1850D-01,
     >    0.1485D-01, 0.1178D-01, 0.9225D-02, 0.7161D-02, 0.5498D-02,
     >    0.4199D-02, 0.3186D-02, 0.2402D-02, 0.1801D-02, 0.1347D-02,
     >    0.9991D-03, 0.7478D-03, 0.5506D-03, 0.4092D-03, 0.2951D-03,
     >    0.2242D-03, 0.1519D-03, 0.1088D-03, 0.8006D-04, 0.6593D-04,
     >    0.5152D-04, 0.3692D-04, 0.2220D-04, 0.2239D-04, 0.7513D-05,
     >    0.7599D-05/

      data (calcpts(j, 5), j = 1,neta) /0.9798D-10, 0.1738D-09,
     >    0.3084D-09, 0.5479D-09, 0.9738D-09, 0.1730D-08, 0.3076D-08,
     >    0.5470D-08, 0.9718D-08, 0.1728D-07, 0.3074D-07, 0.5466D-07,
     >    0.9718D-07, 0.1728D-06, 0.3071D-06, 0.5462D-06, 0.9713D-06,
     >    0.1726D-05, 0.3068D-05, 0.5452D-05, 0.9678D-05, 0.1718D-04,
     >    0.3048D-04, 0.5398D-04, 0.9544D-04, 0.1683D-03, 0.2955D-03,
     >    0.5163D-03, 0.8950D-03, 0.1533D-02, 0.2584D-02, 0.4263D-02,
     >    0.6823D-02, 0.1052D-01, 0.1546D-01, 0.2146D-01, 0.2797D-01,
     >    0.3406D-01, 0.3872D-01, 0.4130D-01, 0.4149D-01, 0.3958D-01,
     >    0.3613D-01, 0.3180D-01, 0.2715D-01, 0.2263D-01, 0.1849D-01,
     >    0.1486D-01, 0.1177D-01, 0.9228D-02, 0.7150D-02, 0.5502D-02,
     >    0.4202D-02, 0.3189D-02, 0.2406D-02, 0.1805D-02, 0.1350D-02,
     >    0.1002D-02, 0.7510D-03, 0.5538D-03, 0.3974D-03, 0.2984D-03,
     >    0.2124D-03, 0.1551D-03, 0.1120D-03, 0.8327D-04, 0.5414D-04,
     >    0.3973D-04, 0.2513D-04, 0.2541D-04, 0.1059D-04, 0.1072D-04,
     >    0.1081D-04/

      data (calcpts(j, 6), j = 1,neta) /0.9794D-10, 0.1738D-09,
     >    0.3083D-09, 0.5477D-09, 0.9735D-09, 0.1730D-08, 0.3075D-08,
     >    0.5468D-08, 0.9715D-08, 0.1728D-07, 0.3073D-07, 0.5464D-07,
     >    0.9715D-07, 0.1728D-06, 0.3070D-06, 0.5460D-06, 0.9710D-06,
     >    0.1726D-05, 0.3067D-05, 0.5450D-05, 0.9674D-05, 0.1718D-04,
     >    0.3047D-04, 0.5396D-04, 0.9541D-04, 0.1683D-03, 0.2954D-03,
     >    0.5161D-03, 0.8947D-03, 0.1532D-02, 0.2584D-02, 0.4262D-02,
     >    0.6821D-02, 0.1052D-01, 0.1546D-01, 0.2146D-01, 0.2796D-01,
     >    0.3405D-01, 0.3872D-01, 0.4128D-01, 0.4148D-01, 0.3958D-01,
     >    0.3612D-01, 0.3180D-01, 0.2716D-01, 0.2263D-01, 0.1849D-01,
     >    0.1486D-01, 0.1177D-01, 0.9228D-02, 0.7149D-02, 0.5501D-02,
     >    0.4201D-02, 0.3188D-02, 0.2405D-02, 0.1804D-02, 0.1349D-02,
     >    0.1001D-02, 0.7498D-03, 0.5525D-03, 0.4112D-03, 0.2971D-03,
     >    0.2111D-03, 0.1539D-03, 0.1108D-03, 0.8203D-04, 0.6790D-04,
     >    0.3849D-04, 0.3889D-04, 0.2416D-04, 0.9350D-05, 0.9477D-05,
     >    0.9564D-05/

      data (calcpts(j, 7), j = 1,neta) /0.9790D-10, 0.1737D-09,
     >    0.3081D-09, 0.5474D-09, 0.9730D-09, 0.1729D-08, 0.3073D-08,
     >    0.5465D-08, 0.9711D-08, 0.1727D-07, 0.3072D-07, 0.5461D-07,
     >    0.9710D-07, 0.1727D-06, 0.3069D-06, 0.5457D-06, 0.9705D-06,
     >    0.1725D-05, 0.3065D-05, 0.5448D-05, 0.9670D-05, 0.1717D-04,
     >    0.3046D-04, 0.5394D-04, 0.9537D-04, 0.1682D-03, 0.2953D-03,
     >    0.5159D-03, 0.8943D-03, 0.1532D-02, 0.2582D-02, 0.4260D-02,
     >    0.6819D-02, 0.1051D-01, 0.1545D-01, 0.2145D-01, 0.2795D-01,
     >    0.3404D-01, 0.3871D-01, 0.4127D-01, 0.4147D-01, 0.3956D-01,
     >    0.3612D-01, 0.3180D-01, 0.2715D-01, 0.2263D-01, 0.1849D-01,
     >    0.1486D-01, 0.1177D-01, 0.9229D-02, 0.7150D-02, 0.5501D-02,
     >    0.4202D-02, 0.3189D-02, 0.2405D-02, 0.1804D-02, 0.1349D-02,
     >    0.1001D-02, 0.7501D-03, 0.5528D-03, 0.4114D-03, 0.2973D-03,
     >    0.2114D-03, 0.1541D-03, 0.1110D-03, 0.8225D-04, 0.6811D-04,
     >    0.3871D-04, 0.3911D-04, 0.2438D-04, 0.9568D-05, 0.9695D-05,
     >    0.9782D-05/

      data (calcpts(j, 8), j = 1,neta) /0.9783D-10, 0.1736D-09,
     >    0.3079D-09, 0.5470D-09, 0.9723D-09, 0.1728D-08, 0.3071D-08,
     >    0.5461D-08, 0.9704D-08, 0.1726D-07, 0.3069D-07, 0.5457D-07,
     >    0.9703D-07, 0.1726D-06, 0.3066D-06, 0.5453D-06, 0.9698D-06,
     >    0.1724D-05, 0.3063D-05, 0.5444D-05, 0.9663D-05, 0.1715D-04,
     >    0.3043D-04, 0.5390D-04, 0.9530D-04, 0.1681D-03, 0.2951D-03,
     >    0.5155D-03, 0.8937D-03, 0.1531D-02, 0.2581D-02, 0.4258D-02,
     >    0.6815D-02, 0.1051D-01, 0.1544D-01, 0.2144D-01, 0.2794D-01,
     >    0.3404D-01, 0.3870D-01, 0.4126D-01, 0.4146D-01, 0.3956D-01,
     >    0.3611D-01, 0.3178D-01, 0.2714D-01, 0.2263D-01, 0.1848D-01,
     >    0.1485D-01, 0.1178D-01, 0.9218D-02, 0.7154D-02, 0.5505D-02,
     >    0.4206D-02, 0.3192D-02, 0.2409D-02, 0.1807D-02, 0.1353D-02,
     >    0.1005D-02, 0.7385D-03, 0.5562D-03, 0.3999D-03, 0.3008D-03,
     >    0.2148D-03, 0.1575D-03, 0.1144D-03, 0.8568D-04, 0.5654D-04,
     >    0.4213D-04, 0.2753D-04, 0.2781D-04, 0.1299D-04, 0.1312D-04,
     >    0.1321D-04/

      data (calcpts(j, 9), j = 1,neta) /0.9773D-10, 0.1734D-09,
     >    0.3076D-09, 0.5464D-09, 0.9713D-09, 0.1726D-08, 0.3068D-08,
     >    0.5455D-08, 0.9693D-08, 0.1724D-07, 0.3066D-07, 0.5451D-07,
     >    0.9693D-07, 0.1724D-06, 0.3063D-06, 0.5447D-06, 0.9688D-06,
     >    0.1722D-05, 0.3060D-05, 0.5438D-05, 0.9653D-05, 0.1714D-04,
     >    0.3040D-04, 0.5384D-04, 0.9520D-04, 0.1679D-03, 0.2948D-03,
     >    0.5150D-03, 0.8928D-03, 0.1529D-02, 0.2578D-02, 0.4254D-02,
     >    0.6808D-02, 0.1050D-01, 0.1543D-01, 0.2143D-01, 0.2792D-01,
     >    0.3401D-01, 0.3868D-01, 0.4125D-01, 0.4145D-01, 0.3954D-01,
     >    0.3611D-01, 0.3177D-01, 0.2715D-01, 0.2263D-01, 0.1848D-01,
     >    0.1486D-01, 0.1177D-01, 0.9223D-02, 0.7158D-02, 0.5509D-02,
     >    0.4209D-02, 0.3195D-02, 0.2412D-02, 0.1810D-02, 0.1355D-02,
     >    0.1008D-02, 0.7413D-03, 0.5440D-03, 0.4026D-03, 0.3035D-03,
     >    0.2175D-03, 0.1603D-03, 0.1171D-03, 0.8839D-04, 0.5926D-04,
     >    0.4485D-04, 0.3025D-04, 0.3052D-04, 0.1571D-04, 0.1584D-04,
     >    0.1592D-04/

      data (calcpts(j,10), j = 1,neta) /0.9756D-10, 0.1731D-09,
     >    0.3071D-09, 0.5456D-09, 0.9697D-09, 0.1723D-08, 0.3063D-08,
     >    0.5447D-08, 0.9679D-08, 0.1721D-07, 0.3062D-07, 0.5443D-07,
     >    0.9678D-07, 0.1721D-06, 0.3058D-06, 0.5439D-06, 0.9673D-06,
     >    0.1719D-05, 0.3055D-05, 0.5430D-05, 0.9637D-05, 0.1711D-04,
     >    0.3035D-04, 0.5376D-04, 0.9505D-04, 0.1677D-03, 0.2943D-03,
     >    0.5142D-03, 0.8915D-03, 0.1527D-02, 0.2575D-02, 0.4248D-02,
     >    0.6801D-02, 0.1048D-01, 0.1541D-01, 0.2141D-01, 0.2790D-01,
     >    0.3398D-01, 0.3866D-01, 0.4121D-01, 0.4142D-01, 0.3952D-01,
     >    0.3609D-01, 0.3177D-01, 0.2714D-01, 0.2261D-01, 0.1847D-01,
     >    0.1485D-01, 0.1177D-01, 0.9215D-02, 0.7149D-02, 0.5499D-02,
     >    0.4199D-02, 0.3185D-02, 0.2401D-02, 0.1799D-02, 0.1344D-02,
     >    0.9965D-03, 0.7451D-03, 0.5477D-03, 0.4064D-03, 0.2922D-03,
     >    0.2212D-03, 0.1640D-03, 0.1208D-03, 0.9209D-04, 0.6295D-04,
     >    0.4854D-04, 0.3394D-04, 0.1922D-04, 0.1940D-04, 0.1953D-04,
     >    0.4614D-05/

      data (calcpts(j,11), j = 1,neta) /0.9733D-10, 0.1727D-09,
     >    0.3064D-09, 0.5443D-09, 0.9675D-09, 0.1719D-08, 0.3056D-08,
     >    0.5434D-08, 0.9656D-08, 0.1717D-07, 0.3055D-07, 0.5431D-07,
     >    0.9657D-07, 0.1717D-06, 0.3052D-06, 0.5427D-06, 0.9650D-06,
     >    0.1715D-05, 0.3048D-05, 0.5417D-05, 0.9615D-05, 0.1707D-04,
     >    0.3029D-04, 0.5364D-04, 0.9484D-04, 0.1673D-03, 0.2937D-03,
     >    0.5131D-03, 0.8895D-03, 0.1524D-02, 0.2570D-02, 0.4240D-02,
     >    0.6788D-02, 0.1047D-01, 0.1539D-01, 0.2138D-01, 0.2786D-01,
     >    0.3395D-01, 0.3862D-01, 0.4118D-01, 0.4139D-01, 0.3949D-01,
     >    0.3606D-01, 0.3175D-01, 0.2711D-01, 0.2261D-01, 0.1847D-01,
     >    0.1484D-01, 0.1176D-01, 0.9213D-02, 0.7146D-02, 0.5496D-02,
     >    0.4195D-02, 0.3180D-02, 0.2411D-02, 0.1809D-02, 0.1354D-02,
     >    0.1006D-02, 0.7398D-03, 0.5425D-03, 0.4010D-03, 0.3019D-03,
     >    0.2159D-03, 0.1586D-03, 0.1155D-03, 0.8672D-04, 0.5758D-04,
     >    0.4316D-04, 0.2856D-04, 0.2883D-04, 0.1402D-04, 0.1415D-04,
     >    0.1423D-04/

      data (calcpts(j,12), j = 1,neta) /0.9701D-10, 0.1721D-09,
     >    0.3054D-09, 0.5425D-09, 0.9642D-09, 0.1714D-08, 0.3046D-08,
     >    0.5416D-08, 0.9625D-08, 0.1712D-07, 0.3044D-07, 0.5412D-07,
     >    0.9624D-07, 0.1712D-06, 0.3041D-06, 0.5409D-06, 0.9619D-06,
     >    0.1710D-05, 0.3038D-05, 0.5400D-05, 0.9584D-05, 0.1702D-04,
     >    0.3019D-04, 0.5346D-04, 0.9453D-04, 0.1667D-03, 0.2927D-03,
     >    0.5115D-03, 0.8867D-03, 0.1519D-02, 0.2562D-02, 0.4228D-02,
     >    0.6769D-02, 0.1044D-01, 0.1535D-01, 0.2133D-01, 0.2781D-01,
     >    0.3388D-01, 0.3855D-01, 0.4112D-01, 0.4133D-01, 0.3945D-01,
     >    0.3602D-01, 0.3172D-01, 0.2710D-01, 0.2260D-01, 0.1846D-01,
     >    0.1484D-01, 0.1176D-01, 0.9208D-02, 0.7154D-02, 0.5502D-02,
     >    0.4200D-02, 0.3185D-02, 0.2400D-02, 0.1799D-02, 0.1343D-02,
     >    0.1010D-02, 0.7437D-03, 0.5463D-03, 0.4048D-03, 0.2906D-03,
     >    0.2196D-03, 0.1623D-03, 0.1191D-03, 0.9040D-04, 0.6126D-04,
     >    0.4684D-04, 0.3224D-04, 0.1751D-04, 0.1769D-04, 0.1782D-04,
     >    0.2904D-05/

      data (calcpts(j,13), j = 1,neta) /0.9653D-10, 0.1713D-09,
     >    0.3039D-09, 0.5399D-09, 0.9596D-09, 0.1705D-08, 0.3031D-08,
     >    0.5390D-08, 0.9577D-08, 0.1703D-07, 0.3030D-07, 0.5386D-07,
     >    0.9577D-07, 0.1703D-06, 0.3027D-06, 0.5382D-06, 0.9572D-06,
     >    0.1701D-05, 0.3023D-05, 0.5373D-05, 0.9537D-05, 0.1693D-04,
     >    0.3004D-04, 0.5321D-04, 0.9408D-04, 0.1659D-03, 0.2913D-03,
     >    0.5091D-03, 0.8826D-03, 0.1512D-02, 0.2551D-02, 0.4210D-02,
     >    0.6742D-02, 0.1040D-01, 0.1530D-01, 0.2126D-01, 0.2773D-01,
     >    0.3380D-01, 0.3846D-01, 0.4104D-01, 0.4126D-01, 0.3938D-01,
     >    0.3598D-01, 0.3168D-01, 0.2707D-01, 0.2257D-01, 0.1845D-01,
     >    0.1482D-01, 0.1175D-01, 0.9208D-02, 0.7152D-02, 0.5498D-02,
     >    0.4195D-02, 0.3179D-02, 0.2408D-02, 0.1806D-02, 0.1350D-02,
     >    0.1002D-02, 0.7506D-03, 0.5531D-03, 0.4116D-03, 0.2974D-03,
     >    0.2113D-03, 0.1540D-03, 0.1108D-03, 0.8206D-04, 0.6791D-04,
     >    0.3849D-04, 0.3888D-04, 0.2415D-04, 0.2433D-04, 0.9458D-05,
     >    0.9543D-05/

      data (calcpts(j,14), j = 1,neta) /0.9585D-10, 0.1701D-09,
     >    0.3017D-09, 0.5360D-09, 0.9528D-09, 0.1693D-08, 0.3010D-08,
     >    0.5352D-08, 0.9510D-08, 0.1691D-07, 0.3008D-07, 0.5348D-07,
     >    0.9509D-07, 0.1691D-06, 0.3005D-06, 0.5344D-06, 0.9504D-06,
     >    0.1689D-05, 0.3002D-05, 0.5335D-05, 0.9470D-05, 0.1681D-04,
     >    0.2983D-04, 0.5283D-04, 0.9341D-04, 0.1648D-03, 0.2893D-03,
     >    0.5056D-03, 0.8766D-03, 0.1502D-02, 0.2534D-02, 0.4184D-02,
     >    0.6704D-02, 0.1034D-01, 0.1522D-01, 0.2116D-01, 0.2761D-01,
     >    0.3367D-01, 0.3833D-01, 0.4091D-01, 0.4114D-01, 0.3930D-01,
     >    0.3591D-01, 0.3162D-01, 0.2703D-01, 0.2253D-01, 0.1843D-01,
     >    0.1481D-01, 0.1174D-01, 0.9207D-02, 0.7131D-02, 0.5490D-02,
     >    0.4200D-02, 0.3182D-02, 0.2396D-02, 0.1808D-02, 0.1352D-02,
     >    0.1004D-02, 0.7369D-03, 0.5542D-03, 0.3976D-03, 0.2983D-03,
     >    0.2122D-03, 0.1549D-03, 0.1117D-03, 0.8293D-04, 0.5377D-04,
     >    0.3935D-04, 0.2474D-04, 0.2500D-04, 0.1018D-04, 0.1031D-04,
     >    0.1039D-04/

      data (calcpts(j,15), j = 1,neta) /0.9484D-10, 0.1683D-09,
     >    0.2986D-09, 0.5305D-09, 0.9430D-09, 0.1676D-08, 0.2979D-08,
     >    0.5297D-08, 0.9412D-08, 0.1674D-07, 0.2977D-07, 0.5293D-07,
     >    0.9412D-07, 0.1674D-06, 0.2975D-06, 0.5290D-06, 0.9407D-06,
     >    0.1672D-05, 0.2971D-05, 0.5281D-05, 0.9373D-05, 0.1664D-04,
     >    0.2953D-04, 0.5229D-04, 0.9248D-04, 0.1631D-03, 0.2864D-03,
     >    0.5006D-03, 0.8680D-03, 0.1488D-02, 0.2511D-02, 0.4147D-02,
     >    0.6646D-02, 0.1026D-01, 0.1511D-01, 0.2102D-01, 0.2744D-01,
     >    0.3347D-01, 0.3814D-01, 0.4072D-01, 0.4099D-01, 0.3916D-01,
     >    0.3580D-01, 0.3155D-01, 0.2697D-01, 0.2249D-01, 0.1839D-01,
     >    0.1478D-01, 0.1173D-01, 0.9194D-02, 0.7127D-02, 0.5482D-02,
     >    0.4189D-02, 0.3185D-02, 0.2397D-02, 0.1809D-02, 0.1352D-02,
     >    0.1003D-02, 0.7511D-03, 0.5532D-03, 0.4115D-03, 0.2971D-03,
     >    0.2110D-03, 0.1536D-03, 0.1104D-03, 0.8161D-04, 0.6744D-04,
     >    0.3800D-04, 0.3839D-04, 0.2365D-04, 0.2383D-04, 0.8947D-05,
     >    0.9030D-05/

      data (calcpts(j,16), j = 1,neta) /0.9341D-10, 0.1658D-09,
     >    0.2941D-09, 0.5226D-09, 0.9290D-09, 0.1651D-08, 0.2935D-08,
     >    0.5219D-08, 0.9272D-08, 0.1649D-07, 0.2933D-07, 0.5215D-07,
     >    0.9273D-07, 0.1649D-06, 0.2930D-06, 0.5211D-06, 0.9268D-06,
     >    0.1647D-05, 0.2927D-05, 0.5203D-05, 0.9235D-05, 0.1640D-04,
     >    0.2909D-04, 0.5153D-04, 0.9111D-04, 0.1607D-03, 0.2823D-03,
     >    0.4934D-03, 0.8558D-03, 0.1467D-02, 0.2477D-02, 0.4092D-02,
     >    0.6564D-02, 0.1014D-01, 0.1494D-01, 0.2081D-01, 0.2718D-01,
     >    0.3319D-01, 0.3784D-01, 0.4044D-01, 0.4073D-01, 0.3894D-01,
     >    0.3563D-01, 0.3141D-01, 0.2687D-01, 0.2244D-01, 0.1834D-01,
     >    0.1475D-01, 0.1170D-01, 0.9181D-02, 0.7122D-02, 0.5486D-02,
     >    0.4189D-02, 0.3183D-02, 0.2393D-02, 0.1804D-02, 0.1346D-02,
     >    0.9968D-03, 0.7442D-03, 0.5461D-03, 0.4042D-03, 0.3047D-03,
     >    0.2185D-03, 0.1611D-03, 0.1178D-03, 0.8900D-04, 0.5981D-04,
     >    0.4536D-04, 0.3073D-04, 0.3099D-04, 0.1617D-04, 0.1628D-04,
     >    0.1637D-04/

      data (calcpts(j,17), j = 1,neta) /0.9140D-10, 0.1622D-09,
     >    0.2878D-09, 0.5114D-09, 0.9091D-09, 0.1616D-08, 0.2872D-08,
     >    0.5107D-08, 0.9075D-08, 0.1614D-07, 0.2871D-07, 0.5104D-07,
     >    0.9076D-07, 0.1614D-06, 0.2868D-06, 0.5100D-06, 0.9071D-06,
     >    0.1612D-05, 0.2865D-05, 0.5092D-05, 0.9038D-05, 0.1605D-04,
     >    0.2847D-04, 0.5044D-04, 0.8919D-04, 0.1574D-03, 0.2764D-03,
     >    0.4832D-03, 0.8382D-03, 0.1438D-02, 0.2428D-02, 0.4014D-02,
     >    0.6444D-02, 0.9965D-02, 0.1470D-01, 0.2049D-01, 0.2681D-01,
     >    0.3278D-01, 0.3741D-01, 0.4002D-01, 0.4037D-01, 0.3863D-01,
     >    0.3538D-01, 0.3122D-01, 0.2673D-01, 0.2233D-01, 0.1826D-01,
     >    0.1470D-01, 0.1167D-01, 0.9149D-02, 0.7108D-02, 0.5465D-02,
     >    0.4178D-02, 0.3168D-02, 0.2391D-02, 0.1800D-02, 0.1341D-02,
     >    0.1006D-02, 0.7379D-03, 0.5545D-03, 0.3973D-03, 0.2977D-03,
     >    0.2113D-03, 0.1538D-03, 0.1105D-03, 0.8168D-04, 0.6746D-04,
     >    0.3800D-04, 0.3836D-04, 0.2361D-04, 0.8782D-05, 0.8897D-05,
     >    0.8976D-05/

      data (calcpts(j,18), j = 1,neta) /0.8860D-10, 0.1573D-09,
     >    0.2791D-09, 0.4959D-09, 0.8816D-09, 0.1567D-08, 0.2785D-08,
     >    0.4953D-08, 0.8802D-08, 0.1565D-07, 0.2784D-07, 0.4950D-07,
     >    0.8801D-07, 0.1565D-06, 0.2782D-06, 0.4947D-06, 0.8797D-06,
     >    0.1564D-05, 0.2779D-05, 0.4939D-05, 0.8766D-05, 0.1557D-04,
     >    0.2762D-04, 0.4892D-04, 0.8653D-04, 0.1527D-03, 0.2682D-03,
     >    0.4689D-03, 0.8138D-03, 0.1396D-02, 0.2360D-02, 0.3904D-02,
     >    0.6272D-02, 0.9714D-02, 0.1435D-01, 0.2004D-01, 0.2626D-01,
     >    0.3217D-01, 0.3678D-01, 0.3942D-01, 0.3983D-01, 0.3817D-01,
     >    0.3502D-01, 0.3095D-01, 0.2653D-01, 0.2218D-01, 0.1817D-01,
     >    0.1462D-01, 0.1162D-01, 0.9119D-02, 0.7079D-02, 0.5455D-02,
     >    0.4161D-02, 0.3161D-02, 0.2381D-02, 0.1787D-02, 0.1342D-02,
     >    0.9912D-03, 0.7374D-03, 0.5534D-03, 0.3960D-03, 0.2961D-03,
     >    0.2096D-03, 0.1520D-03, 0.1086D-03, 0.7971D-04, 0.6547D-04,
     >    0.5098D-04, 0.3633D-04, 0.2157D-04, 0.2173D-04, 0.6842D-05,
     >    0.6917D-05/

      data (calcpts(j,19), j = 1,neta) /0.8482D-10, 0.1506D-09,
     >    0.2673D-09, 0.4749D-09, 0.8443D-09, 0.1501D-08, 0.2668D-08,
     >    0.4744D-08, 0.8430D-08, 0.1499D-07, 0.2667D-07, 0.4741D-07,
     >    0.8431D-07, 0.1499D-06, 0.2664D-06, 0.4738D-06, 0.8427D-06,
     >    0.1498D-05, 0.2662D-05, 0.4730D-05, 0.8397D-05, 0.1491D-04,
     >    0.2646D-04, 0.4687D-04, 0.8290D-04, 0.1463D-03, 0.2570D-03,
     >    0.4495D-03, 0.7805D-03, 0.1340D-02, 0.2266D-02, 0.3752D-02,
     >    0.6036D-02, 0.9363D-02, 0.1386D-01, 0.1939D-01, 0.2547D-01,
     >    0.3127D-01, 0.3585D-01, 0.3853D-01, 0.3902D-01, 0.3751D-01,
     >    0.3448D-01, 0.3054D-01, 0.2622D-01, 0.2195D-01, 0.1800D-01,
     >    0.1451D-01, 0.1154D-01, 0.9062D-02, 0.7047D-02, 0.5424D-02,
     >    0.4152D-02, 0.3145D-02, 0.2376D-02, 0.1795D-02, 0.1333D-02,
     >    0.9950D-03, 0.7403D-03, 0.5407D-03, 0.3978D-03, 0.2977D-03,
     >    0.2110D-03, 0.1532D-03, 0.1098D-03, 0.8080D-04, 0.6651D-04,
     >    0.3700D-04, 0.3733D-04, 0.2255D-04, 0.2271D-04, 0.7810D-05,
     >    0.7881D-05/

      data (calcpts(j,20), j = 1,neta) /0.7986D-10, 0.1418D-09,
     >    0.2517D-09, 0.4474D-09, 0.7953D-09, 0.1414D-08, 0.2513D-08,
     >    0.4469D-08, 0.7942D-08, 0.1413D-07, 0.2512D-07, 0.4467D-07,
     >    0.7942D-07, 0.1413D-06, 0.2510D-06, 0.4464D-06, 0.7938D-06,
     >    0.1411D-05, 0.2508D-05, 0.4457D-05, 0.7912D-05, 0.1405D-04,
     >    0.2493D-04, 0.4416D-04, 0.7812D-04, 0.1379D-03, 0.2423D-03,
     >    0.4239D-03, 0.7362D-03, 0.1265D-02, 0.2140D-02, 0.3548D-02,
     >    0.5716D-02, 0.8883D-02, 0.1318D-01, 0.1849D-01, 0.2436D-01,
     >    0.3002D-01, 0.3454D-01, 0.3727D-01, 0.3788D-01, 0.3654D-01,
     >    0.3370D-01, 0.2993D-01, 0.2577D-01, 0.2163D-01, 0.1777D-01,
     >    0.1435D-01, 0.1142D-01, 0.8980D-02, 0.6985D-02, 0.5391D-02,
     >    0.4121D-02, 0.3137D-02, 0.2363D-02, 0.1778D-02, 0.1328D-02,
     >    0.9888D-03, 0.7330D-03, 0.5476D-03, 0.4042D-03, 0.2886D-03,
     >    0.2167D-03, 0.1588D-03, 0.1152D-03, 0.8615D-04, 0.5680D-04,
     >    0.4225D-04, 0.2756D-04, 0.1276D-04, 0.1290D-04, 0.1300D-04,
     >    -.1933D-05/

      data (calcpts(j,21), j = 1,neta) /0.7364D-10, 0.1308D-09,
     >    0.2322D-09, 0.4128D-09, 0.7339D-09, 0.1304D-08, 0.2319D-08,
     >    0.4124D-08, 0.7329D-08, 0.1304D-07, 0.2318D-07, 0.4122D-07,
     >    0.7330D-07, 0.1304D-06, 0.2317D-06, 0.4120D-06, 0.7326D-06,
     >    0.1302D-05, 0.2314D-05, 0.4113D-05, 0.7302D-05, 0.1297D-04,
     >    0.2301D-04, 0.4076D-04, 0.7211D-04, 0.1273D-03, 0.2237D-03,
     >    0.3915D-03, 0.6803D-03, 0.1169D-02, 0.1980D-02, 0.3287D-02,
     >    0.5304D-02, 0.8258D-02, 0.1229D-01, 0.1729D-01, 0.2287D-01,
     >    0.2830D-01, 0.3273D-01, 0.3549D-01, 0.3628D-01, 0.3517D-01,
     >    0.3260D-01, 0.2908D-01, 0.2514D-01, 0.2116D-01, 0.1744D-01,
     >    0.1412D-01, 0.1126D-01, 0.8865D-02, 0.6916D-02, 0.5332D-02,
     >    0.4094D-02, 0.3115D-02, 0.2349D-02, 0.1775D-02, 0.1322D-02,
     >    0.9960D-03, 0.7388D-03, 0.5525D-03, 0.4084D-03, 0.2924D-03,
     >    0.2202D-03, 0.1621D-03, 0.1184D-03, 0.8922D-04, 0.5982D-04,
     >    0.4522D-04, 0.3049D-04, 0.3068D-04, 0.1581D-04, 0.1590D-04,
     >    0.1596D-04/

      data (calcpts(j,22), j = 1,neta) /0.6623D-10, 0.1177D-09,
     >    0.2090D-09, 0.3714D-09, 0.6605D-09, 0.1174D-08, 0.2087D-08,
     >    0.3712D-08, 0.6597D-08, 0.1173D-07, 0.2087D-07, 0.3711D-07,
     >    0.6598D-07, 0.1173D-06, 0.2085D-06, 0.3708D-06, 0.6595D-06,
     >    0.1172D-05, 0.2083D-05, 0.3703D-05, 0.6573D-05, 0.1167D-04,
     >    0.2071D-04, 0.3670D-04, 0.6493D-04, 0.1146D-03, 0.2015D-03,
     >    0.3527D-03, 0.6130D-03, 0.1054D-02, 0.1787D-02, 0.2969D-02,
     >    0.4798D-02, 0.7487D-02, 0.1117D-01, 0.1578D-01, 0.2096D-01,
     >    0.2608D-01, 0.3034D-01, 0.3312D-01, 0.3410D-01, 0.3330D-01,
     >    0.3108D-01, 0.2789D-01, 0.2425D-01, 0.2052D-01, 0.1698D-01,
     >    0.1379D-01, 0.1103D-01, 0.8707D-02, 0.6800D-02, 0.5253D-02,
     >    0.4030D-02, 0.3071D-02, 0.2328D-02, 0.1748D-02, 0.1307D-02,
     >    0.9787D-03, 0.7349D-03, 0.5475D-03, 0.4027D-03, 0.3013D-03,
     >    0.2137D-03, 0.1554D-03, 0.1115D-03, 0.8225D-04, 0.6777D-04,
     >    0.5312D-04, 0.3836D-04, 0.2353D-04, 0.2364D-04, 0.8718D-05,
     >    0.8771D-05/

      data (calcpts(j,23), j = 1,neta) /0.5794D-10, 0.1030D-09,
     >    0.1829D-09, 0.3251D-09, 0.5782D-09, 0.1028D-08, 0.1827D-08,
     >    0.3250D-08, 0.5776D-08, 0.1027D-07, 0.1827D-07, 0.3249D-07,
     >    0.5776D-07, 0.1027D-06, 0.1826D-06, 0.3247D-06, 0.5774D-06,
     >    0.1026D-05, 0.1824D-05, 0.3242D-05, 0.5756D-05, 0.1022D-04,
     >    0.1814D-04, 0.3214D-04, 0.5686D-04, 0.1004D-03, 0.1765D-03,
     >    0.3090D-03, 0.5373D-03, 0.9244D-03, 0.1568D-02, 0.2608D-02,
     >    0.4221D-02, 0.6599D-02, 0.9870D-02, 0.1399D-01, 0.1868D-01,
     >    0.2338D-01, 0.2740D-01, 0.3016D-01, 0.3134D-01, 0.3088D-01,
     >    0.2908D-01, 0.2633D-01, 0.2306D-01, 0.1963D-01, 0.1634D-01,
     >    0.1333D-01, 0.1071D-01, 0.8483D-02, 0.6647D-02, 0.5151D-02,
     >    0.3957D-02, 0.3017D-02, 0.2296D-02, 0.1726D-02, 0.1297D-02,
     >    0.9662D-03, 0.7208D-03, 0.5323D-03, 0.3868D-03, 0.2848D-03,
     >    0.2119D-03, 0.1533D-03, 0.1092D-03, 0.7987D-04, 0.5032D-04,
     >    0.3562D-04, 0.3583D-04, 0.2097D-04, 0.2107D-04, 0.6131D-05,
     >    0.6176D-05/

      data (calcpts(j,24), j = 1,neta) /0.4927D-10, 0.8757D-10,
     >    0.1556D-09, 0.2766D-09, 0.4919D-09, 0.8745D-09, 0.1555D-08,
     >    0.2765D-08, 0.4915D-08, 0.8741D-08, 0.1555D-07, 0.2764D-07,
     >    0.4915D-07, 0.8742D-07, 0.1554D-06, 0.2763D-06, 0.4913D-06,
     >    0.8733D-06, 0.1552D-05, 0.2759D-05, 0.4898D-05, 0.8697D-05,
     >    0.1543D-04, 0.2735D-04, 0.4839D-04, 0.8545D-04, 0.1503D-03,
     >    0.2631D-03, 0.4576D-03, 0.7877D-03, 0.1337D-02, 0.2226D-02,
     >    0.3607D-02, 0.5649D-02, 0.8470D-02, 0.1205D-01, 0.1616D-01,
     >    0.2035D-01, 0.2403D-01, 0.2670D-01, 0.2803D-01, 0.2794D-01,
     >    0.2662D-01, 0.2436D-01, 0.2154D-01, 0.1851D-01, 0.1552D-01,
     >    0.1275D-01, 0.1029D-01, 0.8201D-02, 0.6450D-02, 0.5021D-02,
     >    0.3871D-02, 0.2965D-02, 0.2252D-02, 0.1692D-02, 0.1274D-02,
     >    0.9557D-03, 0.7087D-03, 0.5191D-03, 0.3878D-03, 0.2854D-03,
     >    0.2121D-03, 0.1532D-03, 0.1090D-03, 0.7959D-04, 0.6496D-04,
     >    0.5021D-04, 0.3538D-04, 0.2050D-04, 0.2058D-04, 0.5633D-05,
     >    0.5670D-05/

      data (calcpts(j,25), j = 1,neta) /0.4076D-10, 0.7246D-10,
     >    0.1287D-09, 0.2289D-09, 0.4072D-09, 0.7238D-09, 0.1287D-08,
     >    0.2289D-08, 0.4068D-08, 0.7236D-08, 0.1287D-07, 0.2288D-07,
     >    0.4069D-07, 0.7237D-07, 0.1286D-06, 0.2287D-06, 0.4067D-06,
     >    0.7229D-06, 0.1285D-05, 0.2284D-05, 0.4055D-05, 0.7200D-05,
     >    0.1278D-04, 0.2264D-04, 0.4007D-04, 0.7075D-04, 0.1244D-03,
     >    0.2180D-03, 0.3791D-03, 0.6528D-03, 0.1109D-02, 0.1847D-02,
     >    0.2996D-02, 0.4701D-02, 0.7065D-02, 0.1008D-01, 0.1358D-01,
     >    0.1719D-01, 0.2045D-01, 0.2294D-01, 0.2435D-01, 0.2459D-01,
     >    0.2374D-01, 0.2201D-01, 0.1972D-01, 0.1713D-01, 0.1451D-01,
     >    0.1202D-01, 0.9781D-02, 0.7837D-02, 0.6189D-02, 0.4843D-02,
     >    0.3753D-02, 0.2882D-02, 0.2192D-02, 0.1657D-02, 0.1251D-02,
     >    0.9304D-03, 0.6969D-03, 0.5213D-03, 0.3893D-03, 0.2864D-03,
     >    0.2128D-03, 0.1537D-03, 0.1094D-03, 0.7983D-04, 0.6513D-04,
     >    0.3533D-04, 0.3547D-04, 0.2057D-04, 0.2063D-04, 0.5677D-05,
     >    0.5708D-05/

      data (calcpts(j,26), j = 1,neta) /0.3290D-10, 0.5849D-10,
     >    0.1039D-09, 0.1848D-09, 0.3287D-09, 0.5844D-09, 0.1039D-08,
     >    0.1848D-08, 0.3285D-08, 0.5843D-08, 0.1039D-07, 0.1848D-07,
     >    0.3285D-07, 0.5843D-07, 0.1038D-06, 0.1847D-06, 0.3284D-06,
     >    0.5837D-06, 0.1038D-05, 0.1844D-05, 0.3274D-05, 0.5814D-05,
     >    0.1032D-04, 0.1829D-04, 0.3236D-04, 0.5714D-04, 0.1005D-03,
     >    0.1761D-03, 0.3064D-03, 0.5277D-03, 0.8966D-03, 0.1495D-02,
     >    0.2427D-02, 0.3813D-02, 0.5742D-02, 0.8218D-02, 0.1111D-01,
     >    0.1414D-01, 0.1693D-01, 0.1915D-01, 0.2055D-01, 0.2102D-01,
     >    0.2059D-01, 0.1940D-01, 0.1763D-01, 0.1554D-01, 0.1332D-01,
     >    0.1115D-01, 0.9167D-02, 0.7406D-02, 0.5896D-02, 0.4635D-02,
     >    0.3607D-02, 0.2772D-02, 0.2120D-02, 0.1612D-02, 0.1218D-02,
     >    0.9103D-03, 0.6754D-03, 0.4990D-03, 0.3663D-03, 0.2780D-03,
     >    0.2041D-03, 0.1448D-03, 0.1004D-03, 0.7070D-04, 0.5594D-04,
     >    0.4110D-04, 0.2621D-04, 0.2629D-04, 0.1134D-04, 0.1138D-04,
     >    0.1140D-04/

      data (calcpts(j,27), j = 1,neta) /0.2600D-10, 0.4624D-10,
     >    0.8217D-10, 0.1461D-09, 0.2599D-09, 0.4621D-09, 0.8217D-09,
     >    0.1462D-08, 0.2598D-08, 0.4620D-08, 0.8218D-08, 0.1461D-07,
     >    0.2598D-07, 0.4621D-07, 0.8212D-07, 0.1460D-06, 0.2597D-06,
     >    0.4616D-06, 0.8204D-06, 0.1458D-05, 0.2589D-05, 0.4598D-05,
     >    0.8160D-05, 0.1446D-04, 0.2559D-04, 0.4520D-04, 0.7950D-04,
     >    0.1393D-03, 0.2424D-03, 0.4176D-03, 0.7099D-03, 0.1184D-02,
     >    0.1925D-02, 0.3027D-02, 0.4566D-02, 0.6551D-02, 0.8883D-02,
     >    0.1135D-01, 0.1367D-01, 0.1558D-01, 0.1688D-01, 0.1748D-01,
     >    0.1738D-01, 0.1664D-01, 0.1539D-01, 0.1378D-01, 0.1200D-01,
     >    0.1019D-01, 0.8465D-02, 0.6910D-02, 0.5540D-02, 0.4384D-02,
     >    0.3434D-02, 0.2666D-02, 0.2040D-02, 0.1558D-02, 0.1176D-02,
     >    0.8971D-03, 0.6761D-03, 0.4989D-03, 0.3657D-03, 0.2770D-03,
     >    0.2029D-03, 0.1435D-03, 0.1139D-03, 0.8413D-04, 0.5432D-04,
     >    0.3945D-04, 0.3954D-04, 0.2459D-04, 0.2463D-04, 0.9662D-05,
     >    0.9681D-05/

      data (calcpts(j,28), j = 1,neta) /0.2019D-10, 0.3591D-10,
     >    0.6382D-10, 0.1135D-09, 0.2019D-09, 0.3589D-09, 0.6383D-09,
     >    0.1135D-08, 0.2018D-08, 0.3589D-08, 0.6383D-08, 0.1135D-07,
     >    0.2018D-07, 0.3589D-07, 0.6378D-07, 0.1134D-06, 0.2017D-06,
     >    0.3586D-06, 0.6373D-06, 0.1133D-05, 0.2011D-05, 0.3571D-05,
     >    0.6339D-05, 0.1123D-04, 0.1988D-04, 0.3511D-04, 0.6177D-04,
     >    0.1082D-03, 0.1884D-03, 0.3246D-03, 0.5519D-03, 0.9212D-03,
     >    0.1498D-02, 0.2359D-02, 0.3563D-02, 0.5121D-02, 0.6964D-02,
     >    0.8933D-02, 0.1081D-01, 0.1240D-01, 0.1354D-01, 0.1417D-01,
     >    0.1427D-01, 0.1389D-01, 0.1307D-01, 0.1192D-01, 0.1056D-01,
     >    0.9108D-02, 0.7674D-02, 0.6336D-02, 0.5136D-02, 0.4101D-02,
     >    0.3232D-02, 0.2533D-02, 0.1947D-02, 0.1492D-02, 0.1139D-02,
     >    0.8581D-03, 0.6512D-03, 0.4883D-03, 0.3548D-03, 0.2657D-03,
     >    0.1914D-03, 0.1469D-03, 0.1022D-03, 0.7239D-04, 0.5754D-04,
     >    0.4263D-04, 0.2770D-04, 0.2775D-04, 0.1278D-04, 0.1280D-04,
     >    0.1281D-04/

      data (calcpts(j,29), j = 1,neta) /0.1546D-10, 0.2749D-10,
     >    0.4886D-10, 0.8690D-10, 0.1546D-09, 0.2748D-09, 0.4887D-09,
     >    0.8692D-09, 0.1545D-08, 0.2748D-08, 0.4887D-08, 0.8689D-08,
     >    0.1545D-07, 0.2748D-07, 0.4884D-07, 0.8685D-07, 0.1544D-06,
     >    0.2745D-06, 0.4879D-06, 0.8673D-06, 0.1540D-05, 0.2735D-05,
     >    0.4853D-05, 0.8601D-05, 0.1522D-04, 0.2689D-04, 0.4730D-04,
     >    0.8288D-04, 0.1443D-03, 0.2487D-03, 0.4229D-03, 0.7061D-03,
     >    0.1149D-02, 0.1810D-02, 0.2737D-02, 0.3941D-02, 0.5371D-02,
     >    0.6910D-02, 0.8397D-02, 0.9680D-02, 0.1065D-01, 0.1124D-01,
     >    0.1145D-01, 0.1129D-01, 0.1081D-01, 0.1005D-01, 0.9070D-02,
     >    0.7967D-02, 0.6826D-02, 0.5717D-02, 0.4696D-02, 0.3793D-02,
     >    0.3020D-02, 0.2373D-02, 0.1845D-02, 0.1422D-02, 0.1087D-02,
     >    0.8231D-03, 0.6214D-03, 0.4670D-03, 0.3481D-03, 0.2589D-03,
     >    0.1844D-03, 0.1397D-03, 0.1100D-03, 0.8011D-04, 0.5022D-04,
     >    0.3530D-04, 0.3535D-04, 0.2038D-04, 0.2041D-04, 0.5425D-05,
     >    0.5435D-05/

      data (calcpts(j,30), j = 1,neta) /0.1170D-10, 0.2081D-10,
     >    0.3698D-10, 0.6577D-10, 0.1170D-09, 0.2080D-09, 0.3699D-09,
     >    0.6579D-09, 0.1169D-08, 0.2080D-08, 0.3699D-08, 0.6577D-08,
     >    0.1169D-07, 0.2080D-07, 0.3696D-07, 0.6573D-07, 0.1169D-06,
     >    0.2078D-06, 0.3693D-06, 0.6564D-06, 0.1166D-05, 0.2070D-05,
     >    0.3673D-05, 0.6510D-05, 0.1152D-04, 0.2035D-04, 0.3581D-04,
     >    0.6274D-04, 0.1092D-03, 0.1883D-03, 0.3203D-03, 0.5349D-03,
     >    0.8706D-03, 0.1372D-02, 0.2077D-02, 0.2994D-02, 0.4087D-02,
     >    0.5271D-02, 0.6427D-02, 0.7443D-02, 0.8232D-02, 0.8751D-02,
     >    0.8997D-02, 0.8982D-02, 0.8728D-02, 0.8257D-02, 0.7602D-02,
     >    0.6810D-02, 0.5944D-02, 0.5065D-02, 0.4224D-02, 0.3456D-02,
     >    0.2782D-02, 0.2208D-02, 0.1731D-02, 0.1343D-02, 0.1033D-02,
     >    0.7865D-03, 0.5963D-03, 0.4490D-03, 0.3358D-03, 0.2494D-03,
     >    0.1853D-03, 0.1375D-03, 0.1002D-03, 0.7333D-04, 0.5391D-04,
     >    0.3897D-04, 0.2851D-04, 0.2103D-04, 0.1505D-04, 0.1056D-04,
     >    0.7572D-05/

      data (calcpts(j,31), j = 1,neta) /0.8769D-11, 0.1560D-10,
     >    0.2772D-10, 0.4930D-10, 0.8769D-10, 0.1559D-09, 0.2773D-09,
     >    0.4931D-09, 0.8765D-09, 0.1559D-08, 0.2773D-08, 0.4930D-08,
     >    0.8766D-08, 0.1559D-07, 0.2771D-07, 0.4927D-07, 0.8763D-07,
     >    0.1558D-06, 0.2768D-06, 0.4921D-06, 0.8737D-06, 0.1552D-05,
     >    0.2754D-05, 0.4880D-05, 0.8637D-05, 0.1526D-04, 0.2684D-04,
     >    0.4704D-04, 0.8189D-04, 0.1412D-03, 0.2402D-03, 0.4011D-03,
     >    0.6531D-03, 0.1030D-02, 0.1560D-02, 0.2250D-02, 0.3076D-02,
     >    0.3974D-02, 0.4858D-02, 0.5647D-02, 0.6275D-02, 0.6712D-02,
     >    0.6952D-02, 0.7007D-02, 0.6892D-02, 0.6622D-02, 0.6211D-02,
     >    0.5678D-02, 0.5058D-02, 0.4395D-02, 0.3728D-02, 0.3098D-02,
     >    0.2526D-02, 0.2029D-02, 0.1606D-02, 0.1256D-02, 0.9722D-03,
     >    0.7462D-03, 0.5675D-03, 0.4289D-03, 0.3231D-03, 0.2410D-03,
     >    0.1798D-03, 0.1335D-03, 0.9759D-04, 0.7218D-04, 0.5274D-04,
     >    0.3928D-04, 0.2881D-04, 0.1983D-04, 0.1535D-04, 0.1085D-04,
     >    0.7861D-05/

      data (calcpts(j,32), j = 1,neta) /0.6519D-11, 0.1160D-10,
     >    0.2061D-10, 0.3665D-10, 0.6520D-10, 0.1159D-09, 0.2061D-09,
     >    0.3666D-09, 0.6517D-09, 0.1159D-08, 0.2062D-08, 0.3665D-08,
     >    0.6518D-08, 0.1159D-07, 0.2060D-07, 0.3664D-07, 0.6515D-07,
     >    0.1158D-06, 0.2058D-06, 0.3658D-06, 0.6496D-06, 0.1154D-05,
     >    0.2047D-05, 0.3629D-05, 0.6422D-05, 0.1134D-04, 0.1996D-04,
     >    0.3498D-04, 0.6089D-04, 0.1050D-03, 0.1786D-03, 0.2984D-03,
     >    0.4859D-03, 0.7664D-03, 0.1161D-02, 0.1676D-02, 0.2293D-02,
     >    0.2967D-02, 0.3634D-02, 0.4235D-02, 0.4725D-02, 0.5080D-02,
     >    0.5296D-02, 0.5379D-02, 0.5342D-02, 0.5198D-02, 0.4954D-02,
     >    0.4617D-02, 0.4200D-02, 0.3725D-02, 0.3224D-02, 0.2727D-02,
     >    0.2258D-02, 0.1837D-02, 0.1471D-02, 0.1162D-02, 0.9064D-03,
     >    0.7009D-03, 0.5369D-03, 0.4070D-03, 0.3070D-03, 0.2308D-03,
     >    0.1725D-03, 0.1277D-03, 0.9475D-04, 0.6932D-04, 0.5137D-04,
     >    0.3640D-04, 0.2742D-04, 0.1993D-04, 0.1394D-04, 0.9449D-05,
     >    0.6453D-05/

      data (calcpts(j,33), j = 1,neta) /0.4816D-11, 0.8566D-11,
     >    0.1522D-10, 0.2708D-10, 0.4816D-10, 0.8564D-10, 0.1523D-09,
     >    0.2709D-09, 0.4814D-09, 0.8562D-09, 0.1523D-08, 0.2708D-08,
     >    0.4815D-08, 0.8564D-08, 0.1522D-07, 0.2706D-07, 0.4813D-07,
     >    0.8555D-07, 0.1521D-06, 0.2703D-06, 0.4799D-06, 0.8522D-06,
     >    0.1513D-05, 0.2681D-05, 0.4744D-05, 0.8380D-05, 0.1474D-04,
     >    0.2584D-04, 0.4499D-04, 0.7756D-04, 0.1320D-03, 0.2205D-03,
     >    0.3591D-03, 0.5665D-03, 0.8584D-03, 0.1239D-02, 0.1697D-02,
     >    0.2198D-02, 0.2696D-02, 0.3149D-02, 0.3523D-02, 0.3804D-02,
     >    0.3986D-02, 0.4076D-02, 0.4081D-02, 0.4010D-02, 0.3872D-02,
     >    0.3668D-02, 0.3403D-02, 0.3084D-02, 0.2726D-02, 0.2352D-02,
     >    0.1984D-02, 0.1640D-02, 0.1331D-02, 0.1065D-02, 0.8402D-03,
     >    0.6552D-03, 0.5045D-03, 0.3865D-03, 0.2938D-03, 0.2220D-03,
     >    0.1667D-03, 0.1248D-03, 0.9188D-04, 0.6793D-04, 0.4996D-04,
     >    0.3798D-04, 0.2750D-04, 0.2001D-04, 0.1552D-04, 0.1102D-04,
     >    0.8025D-05/

      data (calcpts(j,34), j = 1,neta) /0.3536D-11, 0.6289D-11,
     >    0.1118D-10, 0.1988D-10, 0.3536D-10, 0.6287D-10, 0.1118D-09,
     >    0.1989D-09, 0.3534D-09, 0.6286D-09, 0.1118D-08, 0.1988D-08,
     >    0.3535D-08, 0.6287D-08, 0.1117D-07, 0.1987D-07, 0.3534D-07,
     >    0.6281D-07, 0.1116D-06, 0.1984D-06, 0.3523D-06, 0.6257D-06,
     >    0.1110D-05, 0.1968D-05, 0.3483D-05, 0.6152D-05, 0.1083D-04,
     >    0.1897D-04, 0.3303D-04, 0.5695D-04, 0.9689D-04, 0.1619D-03,
     >    0.2637D-03, 0.4161D-03, 0.6305D-03, 0.9107D-03, 0.1247D-02,
     >    0.1616D-02, 0.1985D-02, 0.2322D-02, 0.2604D-02, 0.2820D-02,
     >    0.2968D-02, 0.3052D-02, 0.3076D-02, 0.3048D-02, 0.2973D-02,
     >    0.2854D-02, 0.2692D-02, 0.2489D-02, 0.2249D-02, 0.1983D-02,
     >    0.1707D-02, 0.1436D-02, 0.1185D-02, 0.9606D-03, 0.7668D-03,
     >    0.6041D-03, 0.4696D-03, 0.3620D-03, 0.2767D-03, 0.2094D-03,
     >    0.1585D-03, 0.1181D-03, 0.8813D-04, 0.6567D-04, 0.4769D-04,
     >    0.3571D-04, 0.2672D-04, 0.1923D-04, 0.1473D-04, 0.1024D-04,
     >    0.7239D-05/

      data (calcpts(j,35), j = 1,neta) /0.2583D-11, 0.4593D-11,
     >    0.8164D-11, 0.1452D-10, 0.2583D-10, 0.4592D-10, 0.8167D-10,
     >    0.1453D-09, 0.2582D-09, 0.4592D-09, 0.8167D-09, 0.1452D-08,
     >    0.2582D-08, 0.4592D-08, 0.8162D-08, 0.1451D-07, 0.2581D-07,
     >    0.4588D-07, 0.8154D-07, 0.1449D-06, 0.2573D-06, 0.4570D-06,
     >    0.8111D-06, 0.1438D-05, 0.2544D-05, 0.4494D-05, 0.7907D-05,
     >    0.1386D-04, 0.2413D-04, 0.4160D-04, 0.7078D-04, 0.1183D-03,
     >    0.1926D-03, 0.3040D-03, 0.4607D-03, 0.6655D-03, 0.9118D-03,
     >    0.1182D-02, 0.1452D-02, 0.1701D-02, 0.1910D-02, 0.2074D-02,
     >    0.2190D-02, 0.2262D-02, 0.2293D-02, 0.2288D-02, 0.2250D-02,
     >    0.2183D-02, 0.2087D-02, 0.1963D-02, 0.1810D-02, 0.1631D-02,
     >    0.1435D-02, 0.1233D-02, 0.1036D-02, 0.8523D-03, 0.6897D-03,
     >    0.5492D-03, 0.4326D-03, 0.3354D-03, 0.2591D-03, 0.1977D-03,
     >    0.1498D-03, 0.1123D-03, 0.8387D-04, 0.6289D-04, 0.4641D-04,
     >    0.3442D-04, 0.2543D-04, 0.1794D-04, 0.1344D-04, 0.8945D-05,
     >    0.7447D-05/

      data (calcpts(j,36), j = 1,neta) /0.1878D-11, 0.3341D-11,
     >    0.5938D-11, 0.1056D-10, 0.1879D-10, 0.3340D-10, 0.5940D-10,
     >    0.1056D-09, 0.1878D-09, 0.3340D-09, 0.5940D-09, 0.1056D-08,
     >    0.1878D-08, 0.3340D-08, 0.5936D-08, 0.1056D-07, 0.1877D-07,
     >    0.3337D-07, 0.5931D-07, 0.1054D-06, 0.1872D-06, 0.3324D-06,
     >    0.5900D-06, 0.1046D-05, 0.1851D-05, 0.3269D-05, 0.5751D-05,
     >    0.1008D-04, 0.1755D-04, 0.3026D-04, 0.5148D-04, 0.8602D-04,
     >    0.1401D-03, 0.2211D-03, 0.3352D-03, 0.4842D-03, 0.6635D-03,
     >    0.8605D-03, 0.1058D-02, 0.1239D-02, 0.1394D-02, 0.1516D-02,
     >    0.1604D-02, 0.1663D-02, 0.1694D-02, 0.1700D-02, 0.1684D-02,
     >    0.1647D-02, 0.1591D-02, 0.1517D-02, 0.1423D-02, 0.1310D-02,
     >    0.1178D-02, 0.1035D-02, 0.8878D-03, 0.7447D-03, 0.6124D-03,
     >    0.4948D-03, 0.3937D-03, 0.3099D-03, 0.2395D-03, 0.1841D-03,
     >    0.1407D-03, 0.1062D-03, 0.7922D-04, 0.5974D-04, 0.4476D-04,
     >    0.3277D-04, 0.2377D-04, 0.1778D-04, 0.1328D-04, 0.8780D-05,
     >    0.7282D-05/

      data (calcpts(j,37), j = 1,neta) /0.1361D-11, 0.2420D-11,
     >    0.4302D-11, 0.7651D-11, 0.1361D-10, 0.2420D-10, 0.4303D-10,
     >    0.7654D-10, 0.1360D-09, 0.2419D-09, 0.4304D-09, 0.7652D-09,
     >    0.1361D-08, 0.2420D-08, 0.4301D-08, 0.7648D-08, 0.1360D-07,
     >    0.2417D-07, 0.4297D-07, 0.7637D-07, 0.1356D-06, 0.2408D-06,
     >    0.4274D-06, 0.7575D-06, 0.1341D-05, 0.2368D-05, 0.4167D-05,
     >    0.7302D-05, 0.1271D-04, 0.2192D-04, 0.3730D-04, 0.6232D-04,
     >    0.1015D-03, 0.1602D-03, 0.2429D-03, 0.3509D-03, 0.4808D-03,
     >    0.6237D-03, 0.7669D-03, 0.8990D-03, 0.1012D-02, 0.1101D-02,
     >    0.1168D-02, 0.1214D-02, 0.1241D-02, 0.1252D-02, 0.1247D-02,
     >    0.1229D-02, 0.1197D-02, 0.1153D-02, 0.1097D-02, 0.1027D-02,
     >    0.9440D-03, 0.8481D-03, 0.7439D-03, 0.6371D-03, 0.5338D-03,
     >    0.4384D-03, 0.3538D-03, 0.2812D-03, 0.2206D-03, 0.1710D-03,
     >    0.1314D-03, 0.9996D-04, 0.7554D-04, 0.5680D-04, 0.4241D-04,
     >    0.3147D-04, 0.2322D-04, 0.1722D-04, 0.1258D-04, 0.9276D-05,
     >    0.6727D-05/

      data (calcpts(j,38), j = 1,neta) /0.9823D-12, 0.1747D-11,
     >    0.3105D-11, 0.5523D-11, 0.9824D-11, 0.1747D-10, 0.3106D-10,
     >    0.5525D-10, 0.9820D-10, 0.1746D-09, 0.3106D-09, 0.5523D-09,
     >    0.9821D-09, 0.1747D-08, 0.3104D-08, 0.5520D-08, 0.9817D-08,
     >    0.1745D-07, 0.3102D-07, 0.5513D-07, 0.9788D-07, 0.1738D-06,
     >    0.3085D-06, 0.5468D-06, 0.9677D-06, 0.1709D-05, 0.3008D-05,
     >    0.5271D-05, 0.9178D-05, 0.1582D-04, 0.2692D-04, 0.4499D-04,
     >    0.7328D-04, 0.1157D-03, 0.1753D-03, 0.2533D-03, 0.3472D-03,
     >    0.4503D-03, 0.5539D-03, 0.6495D-03, 0.7313D-03, 0.7967D-03,
     >    0.8460D-03, 0.8807D-03, 0.9029D-03, 0.9140D-03, 0.9153D-03,
     >    0.9074D-03, 0.8906D-03, 0.8654D-03, 0.8319D-03, 0.7900D-03,
     >    0.7389D-03, 0.6781D-03, 0.6084D-03, 0.5330D-03, 0.4559D-03,
     >    0.3816D-03, 0.3129D-03, 0.2522D-03, 0.2002D-03, 0.1569D-03,
     >    0.1216D-03, 0.9324D-04, 0.7090D-04, 0.5351D-04, 0.4017D-04,
     >    0.2997D-04, 0.2218D-04, 0.1633D-04, 0.1198D-04, 0.8832D-05,
     >    0.6432D-05/

      data (calcpts(j,39), j = 1,neta) /0.7071D-12, 0.1258D-11,
     >    0.2235D-11, 0.3976D-11, 0.7072D-11, 0.1257D-10, 0.2236D-10,
     >    0.3977D-10, 0.7069D-10, 0.1257D-09, 0.2236D-09, 0.3976D-09,
     >    0.7070D-09, 0.1257D-08, 0.2235D-08, 0.3974D-08, 0.7067D-08,
     >    0.1256D-07, 0.2233D-07, 0.3969D-07, 0.7046D-07, 0.1251D-06,
     >    0.2221D-06, 0.3936D-06, 0.6967D-06, 0.1231D-05, 0.2165D-05,
     >    0.3795D-05, 0.6607D-05, 0.1139D-04, 0.1938D-04, 0.3238D-04,
     >    0.5276D-04, 0.8326D-04, 0.1262D-03, 0.1824D-03, 0.2499D-03,
     >    0.3243D-03, 0.3988D-03, 0.4678D-03, 0.5269D-03, 0.5743D-03,
     >    0.6104D-03, 0.6362D-03, 0.6535D-03, 0.6634D-03, 0.6670D-03,
     >    0.6646D-03, 0.6564D-03, 0.6425D-03, 0.6230D-03, 0.5980D-03,
     >    0.5672D-03, 0.5300D-03, 0.4858D-03, 0.4354D-03, 0.3811D-03,
     >    0.3257D-03, 0.2723D-03, 0.2232D-03, 0.1797D-03, 0.1427D-03,
     >    0.1117D-03, 0.8649D-04, 0.6640D-04, 0.5051D-04, 0.3806D-04,
     >    0.2861D-04, 0.2142D-04, 0.1587D-04, 0.1182D-04, 0.8670D-05,
     >    0.6420D-05/

      data (calcpts(j,40), j = 1,neta) /0.5074D-12, 0.9025D-12,
     >    0.1604D-11, 0.2853D-11, 0.5075D-11, 0.9023D-11, 0.1605D-10,
     >    0.2854D-10, 0.5073D-10, 0.9022D-10, 0.1605D-09, 0.2853D-09,
     >    0.5073D-09, 0.9023D-09, 0.1604D-08, 0.2852D-08, 0.5071D-08,
     >    0.9014D-08, 0.1602D-07, 0.2848D-07, 0.5056D-07, 0.8980D-07,
     >    0.1594D-06, 0.2825D-06, 0.4999D-06, 0.8830D-06, 0.1554D-05,
     >    0.2723D-05, 0.4741D-05, 0.8174D-05, 0.1391D-04, 0.2324D-04,
     >    0.3786D-04, 0.5975D-04, 0.9057D-04, 0.1309D-03, 0.1794D-03,
     >    0.2327D-03, 0.2863D-03, 0.3358D-03, 0.3783D-03, 0.4125D-03,
     >    0.4386D-03, 0.4576D-03, 0.4706D-03, 0.4788D-03, 0.4827D-03,
     >    0.4829D-03, 0.4794D-03, 0.4723D-03, 0.4614D-03, 0.4467D-03,
     >    0.4283D-03, 0.4058D-03, 0.3789D-03, 0.3470D-03, 0.3108D-03,
     >    0.2717D-03, 0.2321D-03, 0.1939D-03, 0.1586D-03, 0.1276D-03,
     >    0.1012D-03, 0.7919D-04, 0.6120D-04, 0.4695D-04, 0.3571D-04,
     >    0.2686D-04, 0.2011D-04, 0.1501D-04, 0.1111D-04, 0.8263D-05,
     >    0.6013D-05/

      data (calcpts(j,41), j = 1,neta) /0.3632D-12, 0.6459D-12,
     >    0.1148D-11, 0.2042D-11, 0.3632D-11, 0.6458D-11, 0.1148D-10,
     >    0.2043D-10, 0.3630D-10, 0.6457D-10, 0.1149D-09, 0.2042D-09,
     >    0.3631D-09, 0.6458D-09, 0.1148D-08, 0.2041D-08, 0.3630D-08,
     >    0.6452D-08, 0.1147D-07, 0.2038D-07, 0.3619D-07, 0.6427D-07,
     >    0.1141D-06, 0.2022D-06, 0.3578D-06, 0.6320D-06, 0.1112D-05,
     >    0.1949D-05, 0.3393D-05, 0.5850D-05, 0.9954D-05, 0.1663D-04,
     >    0.2710D-04, 0.4276D-04, 0.6483D-04, 0.9367D-04, 0.1284D-03,
     >    0.1666D-03, 0.2049D-03, 0.2404D-03, 0.2708D-03, 0.2954D-03,
     >    0.3142D-03, 0.3280D-03, 0.3377D-03, 0.3440D-03, 0.3475D-03,
     >    0.3487D-03, 0.3476D-03, 0.3443D-03, 0.3385D-03, 0.3302D-03,
     >    0.3193D-03, 0.3059D-03, 0.2896D-03, 0.2702D-03, 0.2473D-03,
     >    0.2213D-03, 0.1933D-03, 0.1650D-03, 0.1377D-03, 0.1127D-03,
     >    0.9046D-04, 0.7172D-04, 0.5598D-04, 0.4323D-04, 0.3318D-04,
     >    0.2508D-04, 0.1894D-04, 0.1414D-04, 0.1054D-04, 0.7838D-05,
     >    0.5738D-05/

      data (calcpts(j,42), j = 1,neta) /0.2594D-12, 0.4613D-12,
     >    0.8200D-12, 0.1458D-11, 0.2594D-11, 0.4613D-11, 0.8202D-11,
     >    0.1459D-10, 0.2593D-10, 0.4612D-10, 0.8203D-10, 0.1458D-09,
     >    0.2593D-09, 0.4612D-09, 0.8197D-09, 0.1458D-08, 0.2592D-08,
     >    0.4608D-08, 0.8190D-08, 0.1456D-07, 0.2585D-07, 0.4590D-07,
     >    0.8147D-07, 0.1444D-06, 0.2555D-06, 0.4514D-06, 0.7942D-06,
     >    0.1392D-05, 0.2423D-05, 0.4178D-05, 0.7110D-05, 0.1188D-04,
     >    0.1935D-04, 0.3054D-04, 0.4630D-04, 0.6691D-04, 0.9170D-04,
     >    0.1190D-03, 0.1464D-03, 0.1717D-03, 0.1935D-03, 0.2111D-03,
     >    0.2246D-03, 0.2345D-03, 0.2416D-03, 0.2463D-03, 0.2492D-03,
     >    0.2506D-03, 0.2506D-03, 0.2492D-03, 0.2463D-03, 0.2418D-03,
     >    0.2356D-03, 0.2277D-03, 0.2179D-03, 0.2063D-03, 0.1923D-03,
     >    0.1759D-03, 0.1573D-03, 0.1373D-03, 0.1171D-03, 0.9766D-04,
     >    0.7982D-04, 0.6408D-04, 0.5073D-04, 0.3964D-04, 0.3064D-04,
     >    0.2344D-04, 0.1774D-04, 0.1339D-04, 0.1009D-04, 0.7391D-05,
     >    0.5591D-05/

      data (calcpts(j,43), j = 1,neta) /0.1849D-12, 0.3288D-12,
     >    0.5844D-12, 0.1039D-11, 0.1849D-11, 0.3287D-11, 0.5846D-11,
     >    0.1040D-10, 0.1848D-10, 0.3287D-10, 0.5846D-10, 0.1039D-09,
     >    0.1848D-09, 0.3287D-09, 0.5842D-09, 0.1039D-08, 0.1848D-08,
     >    0.3284D-08, 0.5837D-08, 0.1037D-07, 0.1842D-07, 0.3271D-07,
     >    0.5806D-07, 0.1029D-06, 0.1821D-06, 0.3217D-06, 0.5660D-06,
     >    0.9920D-06, 0.1727D-05, 0.2978D-05, 0.5067D-05, 0.8466D-05,
     >    0.1379D-04, 0.2177D-04, 0.3300D-04, 0.4768D-04, 0.6535D-04,
     >    0.8480D-04, 0.1043D-03, 0.1224D-03, 0.1379D-03, 0.1505D-03,
     >    0.1601D-03, 0.1672D-03, 0.1723D-03, 0.1758D-03, 0.1781D-03,
     >    0.1793D-03, 0.1797D-03, 0.1793D-03, 0.1780D-03, 0.1757D-03,
     >    0.1723D-03, 0.1678D-03, 0.1620D-03, 0.1550D-03, 0.1466D-03,
     >    0.1366D-03, 0.1249D-03, 0.1116D-03, 0.9738D-04, 0.8296D-04,
     >    0.6912D-04, 0.5646D-04, 0.4534D-04, 0.3586D-04, 0.2796D-04,
     >    0.2166D-04, 0.1656D-04, 0.1251D-04, 0.9358D-05, 0.7108D-05,
     >    0.5308D-05/

      data (calcpts(j,44), j = 1,neta) /0.1315D-12, 0.2338D-12,
     >    0.4156D-12, 0.7392D-12, 0.1315D-11, 0.2338D-11, 0.4157D-11,
     >    0.7394D-11, 0.1314D-10, 0.2337D-10, 0.4158D-10, 0.7392D-10,
     >    0.1314D-09, 0.2338D-09, 0.4155D-09, 0.7389D-09, 0.1314D-08,
     >    0.2336D-08, 0.4151D-08, 0.7378D-08, 0.1310D-07, 0.2327D-07,
     >    0.4129D-07, 0.7318D-07, 0.1295D-06, 0.2288D-06, 0.4025D-06,
     >    0.7055D-06, 0.1228D-05, 0.2118D-05, 0.3604D-05, 0.6021D-05,
     >    0.9809D-05, 0.1548D-04, 0.2347D-04, 0.3391D-04, 0.4648D-04,
     >    0.6031D-04, 0.7419D-04, 0.8705D-04, 0.9810D-04, 0.1070D-03,
     >    0.1139D-03, 0.1190D-03, 0.1227D-03, 0.1252D-03, 0.1269D-03,
     >    0.1279D-03, 0.1284D-03, 0.1284D-03, 0.1278D-03, 0.1267D-03,
     >    0.1250D-03, 0.1225D-03, 0.1192D-03, 0.1150D-03, 0.1100D-03,
     >    0.1040D-03, 0.9684D-04, 0.8850D-04, 0.7906D-04, 0.6892D-04,
     >    0.5868D-04, 0.4886D-04, 0.3989D-04, 0.3200D-04, 0.2530D-04,
     >    0.1973D-04, 0.1522D-04, 0.1162D-04, 0.8801D-05, 0.6626D-05,
     >    0.4946D-05/

      data (calcpts(j,45), j = 1,neta) /0.9338D-13, 0.1661D-12,
     >    0.2952D-12, 0.5250D-12, 0.9339D-12, 0.1660D-11, 0.2953D-11,
     >    0.5252D-11, 0.9334D-11, 0.1660D-10, 0.2953D-10, 0.5250D-10,
     >    0.9336D-10, 0.1660D-09, 0.2951D-09, 0.5248D-09, 0.9332D-09,
     >    0.1659D-08, 0.2948D-08, 0.5240D-08, 0.9305D-08, 0.1652D-07,
     >    0.2933D-07, 0.5198D-07, 0.9199D-07, 0.1625D-06, 0.2859D-06,
     >    0.5011D-06, 0.8724D-06, 0.1504D-05, 0.2559D-05, 0.4276D-05,
     >    0.6967D-05, 0.1099D-04, 0.1667D-04, 0.2409D-04, 0.3301D-04,
     >    0.4283D-04, 0.5270D-04, 0.6183D-04, 0.6968D-04, 0.7602D-04,
     >    0.8091D-04, 0.8454D-04, 0.8715D-04, 0.8899D-04, 0.9023D-04,
     >    0.9102D-04, 0.9146D-04, 0.9159D-04, 0.9142D-04, 0.9093D-04,
     >    0.9007D-04, 0.8875D-04, 0.8693D-04, 0.8453D-04, 0.8154D-04,
     >    0.7794D-04, 0.7367D-04, 0.6859D-04, 0.6266D-04, 0.5594D-04,
     >    0.4876D-04, 0.4149D-04, 0.3453D-04, 0.2818D-04, 0.2260D-04,
     >    0.1785D-04, 0.1394D-04, 0.1074D-04, 0.8206D-05, 0.6226D-05,
     >    0.4681D-05/

      data (calcpts(j,46), j = 1,neta) /0.6618D-13, 0.1177D-12,
     >    0.2092D-12, 0.3721D-12, 0.6619D-12, 0.1177D-11, 0.2093D-11,
     >    0.3722D-11, 0.6616D-11, 0.1177D-10, 0.2093D-10, 0.3721D-10,
     >    0.6617D-10, 0.1177D-09, 0.2092D-09, 0.3720D-09, 0.6615D-09,
     >    0.1176D-08, 0.2090D-08, 0.3714D-08, 0.6595D-08, 0.1171D-07,
     >    0.2079D-07, 0.3684D-07, 0.6520D-07, 0.1152D-06, 0.2026D-06,
     >    0.3552D-06, 0.6184D-06, 0.1066D-05, 0.1814D-05, 0.3031D-05,
     >    0.4938D-05, 0.7793D-05, 0.1181D-04, 0.1707D-04, 0.2340D-04,
     >    0.3036D-04, 0.3735D-04, 0.4382D-04, 0.4939D-04, 0.5389D-04,
     >    0.5735D-04, 0.5993D-04, 0.6179D-04, 0.6311D-04, 0.6400D-04,
     >    0.6460D-04, 0.6495D-04, 0.6512D-04, 0.6510D-04, 0.6491D-04,
     >    0.6451D-04, 0.6385D-04, 0.6288D-04, 0.6156D-04, 0.5983D-04,
     >    0.5770D-04, 0.5513D-04, 0.5209D-04, 0.4849D-04, 0.4426D-04,
     >    0.3951D-04, 0.3441D-04, 0.2927D-04, 0.2435D-04, 0.1985D-04,
     >    0.1592D-04, 0.1257D-04, 0.9799D-05, 0.7549D-05, 0.5764D-05,
     >    0.4369D-05/

      data (calcpts(j,47), j = 1,neta) /0.4684D-13, 0.8331D-13,
     >    0.1481D-12, 0.2634D-12, 0.4684D-12, 0.8329D-12, 0.1481D-11,
     >    0.2634D-11, 0.4682D-11, 0.8328D-11, 0.1481D-10, 0.2634D-10,
     >    0.4683D-10, 0.8329D-10, 0.1480D-09, 0.2632D-09, 0.4681D-09,
     >    0.8321D-09, 0.1479D-08, 0.2629D-08, 0.4667D-08, 0.8289D-08,
     >    0.1471D-07, 0.2607D-07, 0.4614D-07, 0.8151D-07, 0.1434D-06,
     >    0.2513D-06, 0.4376D-06, 0.7545D-06, 0.1284D-05, 0.2145D-05,
     >    0.3494D-05, 0.5515D-05, 0.8361D-05, 0.1208D-04, 0.1656D-04,
     >    0.2149D-04, 0.2643D-04, 0.3101D-04, 0.3495D-04, 0.3814D-04,
     >    0.4059D-04, 0.4242D-04, 0.4374D-04, 0.4467D-04, 0.4532D-04,
     >    0.4575D-04, 0.4603D-04, 0.4618D-04, 0.4622D-04, 0.4616D-04,
     >    0.4598D-04, 0.4567D-04, 0.4518D-04, 0.4448D-04, 0.4352D-04,
     >    0.4229D-04, 0.4076D-04, 0.3894D-04, 0.3678D-04, 0.3422D-04,
     >    0.3123D-04, 0.2786D-04, 0.2426D-04, 0.2062D-04, 0.1714D-04,
     >    0.1397D-04, 0.1120D-04, 0.8828D-05, 0.6878D-05, 0.5303D-05,
     >    0.4043D-05/

      data (calcpts(j,48), j = 1,neta) /0.3311D-13, 0.5889D-13,
     >    0.1047D-12, 0.1862D-12, 0.3311D-12, 0.5887D-12, 0.1047D-11,
     >    0.1862D-11, 0.3310D-11, 0.5886D-11, 0.1047D-10, 0.1862D-10,
     >    0.3310D-10, 0.5887D-10, 0.1046D-09, 0.1861D-09, 0.3309D-09,
     >    0.5882D-09, 0.1045D-08, 0.1858D-08, 0.3299D-08, 0.5859D-08,
     >    0.1040D-07, 0.1843D-07, 0.3262D-07, 0.5761D-07, 0.1014D-06,
     >    0.1777D-06, 0.3093D-06, 0.5333D-06, 0.9075D-06, 0.1516D-05,
     >    0.2470D-05, 0.3898D-05, 0.5910D-05, 0.8540D-05, 0.1171D-04,
     >    0.1519D-04, 0.1869D-04, 0.2192D-04, 0.2471D-04, 0.2696D-04,
     >    0.2869D-04, 0.2999D-04, 0.3092D-04, 0.3158D-04, 0.3204D-04,
     >    0.3236D-04, 0.3256D-04, 0.3268D-04, 0.3274D-04, 0.3274D-04,
     >    0.3267D-04, 0.3252D-04, 0.3228D-04, 0.3193D-04, 0.3142D-04,
     >    0.3073D-04, 0.2985D-04, 0.2877D-04, 0.2747D-04, 0.2594D-04,
     >    0.2413D-04, 0.2202D-04, 0.1964D-04, 0.1709D-04, 0.1452D-04,
     >    0.1206D-04, 0.9827D-05, 0.7877D-05, 0.6212D-05, 0.4832D-05,
     >    0.3722D-05/

      data (calcpts(j,49), j = 1,neta) /0.2337D-13, 0.4157D-13,
     >    0.7388D-13, 0.1314D-12, 0.2337D-12, 0.4156D-12, 0.7390D-12,
     >    0.1314D-11, 0.2336D-11, 0.4155D-11, 0.7391D-11, 0.1314D-10,
     >    0.2337D-10, 0.4156D-10, 0.7386D-10, 0.1313D-09, 0.2336D-09,
     >    0.4152D-09, 0.7379D-09, 0.1312D-08, 0.2329D-08, 0.4136D-08,
     >    0.7340D-08, 0.1301D-07, 0.2302D-07, 0.4067D-07, 0.7156D-07,
     >    0.1254D-06, 0.2184D-06, 0.3765D-06, 0.6406D-06, 0.1070D-05,
     >    0.1744D-05, 0.2752D-05, 0.4172D-05, 0.6028D-05, 0.8263D-05,
     >    0.1072D-04, 0.1319D-04, 0.1548D-04, 0.1744D-04, 0.1903D-04,
     >    0.2026D-04, 0.2117D-04, 0.2183D-04, 0.2230D-04, 0.2263D-04,
     >    0.2285D-04, 0.2300D-04, 0.2309D-04, 0.2314D-04, 0.2316D-04,
     >    0.2314D-04, 0.2308D-04, 0.2296D-04, 0.2279D-04, 0.2253D-04,
     >    0.2216D-04, 0.2167D-04, 0.2104D-04, 0.2028D-04, 0.1936D-04,
     >    0.1828D-04, 0.1700D-04, 0.1550D-04, 0.1382D-04, 0.1202D-04,
     >    0.1021D-04, 0.8483D-05, 0.6900D-05, 0.5535D-05, 0.4365D-05,
     >    0.3390D-05/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsqtba = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

      subroutine sclql_CT(eta, xi, xsclql)
cmarco the subtracted term from eq (28) of PLB347 (1995) 143 - 151
c   longitudinal light quark initiated piece
c   prop. to e_l^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsclql
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.2423D-19, 0.9273D-19,
     >    0.3548D-18, 0.1357D-17, 0.5186D-17, 0.1980D-16, 0.7542D-16,
     >    0.2866D-15, 0.1085D-14, 0.4089D-14, 0.1530D-13, 0.5665D-13,
     >    0.2072D-12, 0.7446D-12, 0.2620D-11, 0.8998D-11, 0.3005D-10,
     >    0.9740D-10, 0.3063D-09, 0.9353D-09, 0.2775D-08, 0.8042D-08,
     >    0.2279D-07, 0.6327D-07, 0.1727D-06, 0.4629D-06, 0.1221D-05,
     >    0.3162D-05, 0.8022D-05, 0.1983D-04, 0.4740D-04, 0.1084D-03,
     >    0.2341D-03, 0.4692D-03, 0.8571D-03, 0.1404D-02, 0.2035D-02,
     >    0.2598D-02, 0.2933D-02, 0.2958D-02, 0.2711D-02, 0.2297D-02,
     >    0.1833D-02, 0.1397D-02, 0.1031D-02, 0.7420D-03, 0.5253D-03,
     >    0.3675D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8283D-04,
     >    0.5665D-04, 0.3870D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 2), j = 1,neta) /0.1652D-19, 0.6323D-19,
     >    0.2421D-18, 0.9263D-18, 0.3541D-17, 0.1354D-16, 0.5166D-16,
     >    0.1968D-15, 0.7482D-15, 0.2834D-14, 0.1067D-13, 0.3993D-13,
     >    0.1479D-12, 0.5406D-12, 0.1944D-11, 0.6840D-11, 0.2347D-10,
     >    0.7839D-10, 0.2540D-09, 0.7985D-09, 0.2433D-08, 0.7222D-08,
     >    0.2090D-07, 0.5907D-07, 0.1635D-06, 0.4438D-06, 0.1182D-05,
     >    0.3085D-05, 0.7875D-05, 0.1956D-04, 0.4694D-04, 0.1077D-03,
     >    0.2329D-03, 0.4676D-03, 0.8553D-03, 0.1402D-02, 0.2034D-02,
     >    0.2598D-02, 0.2933D-02, 0.2958D-02, 0.2711D-02, 0.2297D-02,
     >    0.1833D-02, 0.1397D-02, 0.1031D-02, 0.7420D-03, 0.5253D-03,
     >    0.3675D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8283D-04,
     >    0.5665D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 3), j = 1,neta) /0.1125D-19, 0.4310D-19,
     >    0.1650D-18, 0.6318D-18, 0.2418D-17, 0.9246D-17, 0.3534D-16,
     >    0.1349D-15, 0.5139D-15, 0.1953D-14, 0.7395D-14, 0.2786D-13,
     >    0.1042D-12, 0.3859D-12, 0.1411D-11, 0.5072D-11, 0.1785D-10,
     >    0.6126D-10, 0.2045D-09, 0.6621D-09, 0.2081D-08, 0.6333D-08,
     >    0.1876D-07, 0.5418D-07, 0.1527D-06, 0.4206D-06, 0.1134D-05,
     >    0.2988D-05, 0.7687D-05, 0.1922D-04, 0.4632D-04, 0.1066D-03,
     >    0.2314D-03, 0.4655D-03, 0.8527D-03, 0.1399D-02, 0.2031D-02,
     >    0.2597D-02, 0.2931D-02, 0.2958D-02, 0.2711D-02, 0.2298D-02,
     >    0.1833D-02, 0.1398D-02, 0.1031D-02, 0.7420D-03, 0.5253D-03,
     >    0.3675D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8283D-04,
     >    0.5665D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 4), j = 1,neta) /0.7668D-20, 0.2937D-19,
     >    0.1125D-18, 0.4308D-18, 0.1648D-17, 0.6311D-17, 0.2413D-16,
     >    0.9224D-16, 0.3521D-15, 0.1341D-14, 0.5097D-14, 0.1931D-13,
     >    0.7272D-13, 0.2720D-12, 0.1007D-11, 0.3683D-11, 0.1323D-10,
     >    0.4656D-10, 0.1597D-09, 0.5330D-09, 0.1725D-08, 0.5406D-08,
     >    0.1646D-07, 0.4866D-07, 0.1400D-06, 0.3927D-06, 0.1074D-05,
     >    0.2866D-05, 0.7448D-05, 0.1877D-04, 0.4551D-04, 0.1053D-03,
     >    0.2294D-03, 0.4626D-03, 0.8493D-03, 0.1396D-02, 0.2028D-02,
     >    0.2595D-02, 0.2931D-02, 0.2957D-02, 0.2711D-02, 0.2298D-02,
     >    0.1833D-02, 0.1398D-02, 0.1031D-02, 0.7422D-03, 0.5255D-03,
     >    0.3675D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8283D-04,
     >    0.5665D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 5), j = 1,neta) /0.5226D-20, 0.2001D-19,
     >    0.7668D-19, 0.2937D-18, 0.1124D-17, 0.4305D-17, 0.1647D-16,
     >    0.6300D-16, 0.2408D-15, 0.9189D-15, 0.3501D-14, 0.1330D-13,
     >    0.5038D-13, 0.1897D-12, 0.7098D-12, 0.2630D-11, 0.9607D-11,
     >    0.3452D-10, 0.1214D-09, 0.4164D-09, 0.1388D-08, 0.4484D-08,
     >    0.1405D-07, 0.4267D-07, 0.1258D-06, 0.3603D-06, 0.1004D-05,
     >    0.2718D-05, 0.7148D-05, 0.1818D-04, 0.4446D-04, 0.1035D-03,
     >    0.2265D-03, 0.4587D-03, 0.8447D-03, 0.1391D-02, 0.2025D-02,
     >    0.2592D-02, 0.2930D-02, 0.2957D-02, 0.2711D-02, 0.2298D-02,
     >    0.1833D-02, 0.1398D-02, 0.1031D-02, 0.7422D-03, 0.5255D-03,
     >    0.3675D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8283D-04,
     >    0.5665D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 6), j = 1,neta) /0.3561D-20, 0.1364D-19,
     >    0.5224D-19, 0.2001D-18, 0.7665D-18, 0.2936D-17, 0.1124D-16,
     >    0.4299D-16, 0.1644D-15, 0.6284D-15, 0.2399D-14, 0.9138D-14,
     >    0.3473D-13, 0.1315D-12, 0.4953D-12, 0.1853D-11, 0.6860D-11,
     >    0.2506D-10, 0.9003D-10, 0.3165D-09, 0.1085D-08, 0.3609D-08,
     >    0.1165D-07, 0.3644D-07, 0.1103D-06, 0.3237D-06, 0.9210D-06,
     >    0.2540D-05, 0.6779D-05, 0.1746D-04, 0.4312D-04, 0.1012D-03,
     >    0.2229D-03, 0.4536D-03, 0.8383D-03, 0.1385D-02, 0.2019D-02,
     >    0.2587D-02, 0.2927D-02, 0.2957D-02, 0.2711D-02, 0.2298D-02,
     >    0.1835D-02, 0.1398D-02, 0.1031D-02, 0.7424D-03, 0.5255D-03,
     >    0.3677D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8284D-04,
     >    0.5665D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 7), j = 1,neta) /0.2426D-20, 0.9294D-20,
     >    0.3561D-19, 0.1364D-18, 0.5224D-18, 0.2001D-17, 0.7662D-17,
     >    0.2933D-16, 0.1122D-15, 0.4293D-15, 0.1640D-14, 0.6260D-14,
     >    0.2385D-13, 0.9065D-13, 0.3432D-12, 0.1293D-11, 0.4833D-11,
     >    0.1790D-10, 0.6537D-10, 0.2348D-09, 0.8247D-09, 0.2820D-08,
     >    0.9381D-08, 0.3023D-07, 0.9423D-07, 0.2841D-06, 0.8278D-06,
     >    0.2331D-05, 0.6338D-05, 0.1658D-04, 0.4145D-04, 0.9827D-04,
     >    0.2182D-03, 0.4468D-03, 0.8298D-03, 0.1376D-02, 0.2012D-02,
     >    0.2583D-02, 0.2925D-02, 0.2955D-02, 0.2711D-02, 0.2298D-02,
     >    0.1835D-02, 0.1398D-02, 0.1031D-02, 0.7425D-03, 0.5256D-03,
     >    0.3677D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8284D-04,
     >    0.5667D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 8), j = 1,neta) /0.1653D-20, 0.6333D-20,
     >    0.2425D-19, 0.9294D-19, 0.3559D-18, 0.1364D-17, 0.5223D-17,
     >    0.2000D-16, 0.7656D-16, 0.2930D-15, 0.1120D-14, 0.4281D-14,
     >    0.1634D-13, 0.6225D-13, 0.2366D-12, 0.8955D-12, 0.3373D-11,
     >    0.1261D-10, 0.4666D-10, 0.1704D-09, 0.6116D-09, 0.2147D-08,
     >    0.7331D-08, 0.2433D-07, 0.7818D-07, 0.2427D-06, 0.7266D-06,
     >    0.2097D-05, 0.5823D-05, 0.1551D-04, 0.3938D-04, 0.9454D-04,
     >    0.2121D-03, 0.4378D-03, 0.8186D-03, 0.1363D-02, 0.2001D-02,
     >    0.2576D-02, 0.2921D-02, 0.2953D-02, 0.2711D-02, 0.2299D-02,
     >    0.1835D-02, 0.1399D-02, 0.1032D-02, 0.7426D-03, 0.5256D-03,
     >    0.3677D-03, 0.2550D-03, 0.1760D-03, 0.1209D-03, 0.8284D-04,
     >    0.5667D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j, 9), j = 1,neta) /0.1126D-20, 0.4314D-20,
     >    0.1653D-19, 0.6333D-19, 0.2426D-18, 0.9293D-18, 0.3560D-17,
     >    0.1363D-16, 0.5220D-16, 0.1998D-15, 0.7647D-15, 0.2925D-14,
     >    0.1117D-13, 0.4264D-13, 0.1625D-12, 0.6173D-12, 0.2337D-11,
     >    0.8799D-11, 0.3289D-10, 0.1217D-09, 0.4440D-09, 0.1591D-08,
     >    0.5573D-08, 0.1902D-07, 0.6296D-07, 0.2013D-06, 0.6208D-06,
     >    0.1842D-05, 0.5241D-05, 0.1426D-04, 0.3689D-04, 0.8996D-04,
     >    0.2045D-03, 0.4264D-03, 0.8037D-03, 0.1347D-02, 0.1986D-02,
     >    0.2565D-02, 0.2915D-02, 0.2952D-02, 0.2711D-02, 0.2301D-02,
     >    0.1836D-02, 0.1400D-02, 0.1032D-02, 0.7430D-03, 0.5257D-03,
     >    0.3678D-03, 0.2552D-03, 0.1760D-03, 0.1209D-03, 0.8284D-04,
     >    0.5667D-04, 0.3871D-04, 0.2642D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,10), j = 1,neta) /0.7672D-21, 0.2940D-20,
     >    0.1126D-19, 0.4314D-19, 0.1653D-18, 0.6333D-18, 0.2425D-17,
     >    0.9291D-17, 0.3558D-16, 0.1363D-15, 0.5216D-15, 0.1996D-14,
     >    0.7634D-14, 0.2916D-13, 0.1113D-12, 0.4239D-12, 0.1611D-11,
     >    0.6096D-11, 0.2295D-10, 0.8574D-10, 0.3171D-09, 0.1156D-08,
     >    0.4133D-08, 0.1446D-07, 0.4922D-07, 0.1622D-06, 0.5154D-06,
     >    0.1575D-05, 0.4605D-05, 0.1285D-04, 0.3396D-04, 0.8439D-04,
     >    0.1948D-03, 0.4119D-03, 0.7844D-03, 0.1326D-02, 0.1966D-02,
     >    0.2550D-02, 0.2907D-02, 0.2949D-02, 0.2712D-02, 0.2301D-02,
     >    0.1837D-02, 0.1401D-02, 0.1033D-02, 0.7432D-03, 0.5261D-03,
     >    0.3678D-03, 0.2552D-03, 0.1760D-03, 0.1209D-03, 0.8286D-04,
     >    0.5667D-04, 0.3871D-04, 0.2643D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,11), j = 1,neta) /0.5227D-21, 0.2003D-20,
     >    0.7672D-20, 0.2940D-19, 0.1126D-18, 0.4314D-18, 0.1653D-17,
     >    0.6332D-17, 0.2426D-16, 0.9288D-16, 0.3557D-15, 0.1362D-14,
     >    0.5209D-14, 0.1992D-13, 0.7612D-13, 0.2904D-12, 0.1106D-11,
     >    0.4202D-11, 0.1590D-10, 0.5984D-10, 0.2234D-09, 0.8253D-09,
     >    0.3000D-08, 0.1072D-07, 0.3741D-07, 0.1268D-06, 0.4154D-06,
     >    0.1308D-05, 0.3941D-05, 0.1130D-04, 0.3065D-04, 0.7785D-04,
     >    0.1832D-03, 0.3936D-03, 0.7596D-03, 0.1297D-02, 0.1939D-02,
     >    0.2531D-02, 0.2897D-02, 0.2946D-02, 0.2711D-02, 0.2302D-02,
     >    0.1839D-02, 0.1402D-02, 0.1033D-02, 0.7437D-03, 0.5263D-03,
     >    0.3680D-03, 0.2553D-03, 0.1761D-03, 0.1209D-03, 0.8288D-04,
     >    0.5669D-04, 0.3871D-04, 0.2643D-04, 0.1803D-04, 0.1229D-04,
     >    0.8378D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3893D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,12), j = 1,neta) /0.3561D-21, 0.1365D-20,
     >    0.5227D-20, 0.2003D-19, 0.7674D-19, 0.2940D-18, 0.1126D-17,
     >    0.4314D-17, 0.1653D-16, 0.6330D-16, 0.2424D-15, 0.9283D-15,
     >    0.3554D-14, 0.1360D-13, 0.5199D-13, 0.1986D-12, 0.7580D-12,
     >    0.2886D-11, 0.1096D-10, 0.4146D-10, 0.1559D-09, 0.5817D-09,
     >    0.2145D-08, 0.7786D-08, 0.2775D-07, 0.9642D-07, 0.3247D-06,
     >    0.1054D-05, 0.3276D-05, 0.9683D-05, 0.2700D-04, 0.7040D-04,
     >    0.1695D-03, 0.3712D-03, 0.7283D-03, 0.1260D-02, 0.1905D-02,
     >    0.2504D-02, 0.2880D-02, 0.2938D-02, 0.2711D-02, 0.2306D-02,
     >    0.1841D-02, 0.1404D-02, 0.1035D-02, 0.7445D-03, 0.5267D-03,
     >    0.3683D-03, 0.2553D-03, 0.1761D-03, 0.1210D-03, 0.8289D-04,
     >    0.5669D-04, 0.3871D-04, 0.2643D-04, 0.1803D-04, 0.1229D-04,
     >    0.8379D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1806D-05,
     >    0.1231D-05, 0.8387D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,13), j = 1,neta) /0.2427D-21, 0.9296D-21,
     >    0.3561D-20, 0.1365D-19, 0.5227D-19, 0.2003D-18, 0.7674D-18,
     >    0.2940D-17, 0.1126D-16, 0.4314D-16, 0.1653D-15, 0.6329D-15,
     >    0.2423D-14, 0.9275D-14, 0.3549D-13, 0.1357D-12, 0.5183D-12,
     >    0.1977D-11, 0.7527D-11, 0.2858D-10, 0.1080D-09, 0.4059D-09,
     >    0.1512D-08, 0.5560D-08, 0.2016D-07, 0.7152D-07, 0.2471D-06,
     >    0.8250D-06, 0.2643D-05, 0.8058D-05, 0.2318D-04, 0.6216D-04,
     >    0.1536D-03, 0.3445D-03, 0.6896D-03, 0.1214D-02, 0.1858D-02,
     >    0.2466D-02, 0.2858D-02, 0.2930D-02, 0.2709D-02, 0.2307D-02,
     >    0.1844D-02, 0.1406D-02, 0.1036D-02, 0.7453D-03, 0.5273D-03,
     >    0.3686D-03, 0.2556D-03, 0.1763D-03, 0.1210D-03, 0.8291D-04,
     >    0.5670D-04, 0.3873D-04, 0.2643D-04, 0.1803D-04, 0.1229D-04,
     >    0.8379D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,14), j = 1,neta) /0.1653D-21, 0.6333D-21,
     >    0.2427D-20, 0.9297D-20, 0.3562D-19, 0.1365D-18, 0.5229D-18,
     >    0.2003D-17, 0.7674D-17, 0.2940D-16, 0.1126D-15, 0.4313D-15,
     >    0.1651D-14, 0.6324D-14, 0.2421D-13, 0.9261D-13, 0.3540D-12,
     >    0.1352D-11, 0.5157D-11, 0.1962D-10, 0.7446D-10, 0.2813D-09,
     >    0.1055D-08, 0.3918D-08, 0.1439D-07, 0.5196D-07, 0.1833D-06,
     >    0.6278D-06, 0.2070D-05, 0.6507D-05, 0.1932D-04, 0.5346D-04,
     >    0.1361D-03, 0.3135D-03, 0.6428D-03, 0.1155D-02, 0.1797D-02,
     >    0.2417D-02, 0.2826D-02, 0.2916D-02, 0.2706D-02, 0.2309D-02,
     >    0.1847D-02, 0.1409D-02, 0.1038D-02, 0.7467D-03, 0.5280D-03,
     >    0.3690D-03, 0.2558D-03, 0.1763D-03, 0.1211D-03, 0.8293D-04,
     >    0.5672D-04, 0.3873D-04, 0.2643D-04, 0.1803D-04, 0.1229D-04,
     >    0.8379D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,15), j = 1,neta) /0.1127D-21, 0.4316D-21,
     >    0.1653D-20, 0.6334D-20, 0.2427D-19, 0.9297D-19, 0.3562D-18,
     >    0.1365D-17, 0.5229D-17, 0.2003D-16, 0.7673D-16, 0.2938D-15,
     >    0.1126D-14, 0.4311D-14, 0.1650D-13, 0.6317D-13, 0.2416D-12,
     >    0.9237D-12, 0.3526D-11, 0.1344D-10, 0.5113D-10, 0.1938D-09,
     >    0.7313D-09, 0.2735D-08, 0.1014D-07, 0.3710D-07, 0.1332D-06,
     >    0.4659D-06, 0.1575D-05, 0.5100D-05, 0.1562D-04, 0.4467D-04,
     >    0.1174D-03, 0.2789D-03, 0.5880D-03, 0.1083D-02, 0.1721D-02,
     >    0.2352D-02, 0.2782D-02, 0.2895D-02, 0.2702D-02, 0.2311D-02,
     >    0.1851D-02, 0.1413D-02, 0.1041D-02, 0.7485D-03, 0.5291D-03,
     >    0.3696D-03, 0.2561D-03, 0.1764D-03, 0.1212D-03, 0.8298D-04,
     >    0.5673D-04, 0.3875D-04, 0.2645D-04, 0.1803D-04, 0.1229D-04,
     >    0.8381D-05, 0.5710D-05, 0.3891D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,16), j = 1,neta) /0.7679D-22, 0.2940D-21,
     >    0.1126D-20, 0.4316D-20, 0.1653D-19, 0.6334D-19, 0.2427D-18,
     >    0.9299D-18, 0.3563D-17, 0.1365D-16, 0.5229D-16, 0.2002D-15,
     >    0.7671D-15, 0.2939D-14, 0.1125D-13, 0.4307D-13, 0.1649D-12,
     >    0.6305D-12, 0.2409D-11, 0.9195D-11, 0.3504D-10, 0.1331D-09,
     >    0.5040D-09, 0.1898D-08, 0.7077D-08, 0.2615D-07, 0.9512D-07,
     >    0.3386D-06, 0.1170D-05, 0.3886D-05, 0.1226D-04, 0.3621D-04,
     >    0.9842D-04, 0.2416D-03, 0.5259D-03, 0.9966D-03, 0.1623D-02,
     >    0.2265D-02, 0.2724D-02, 0.2865D-02, 0.2693D-02, 0.2313D-02,
     >    0.1857D-02, 0.1418D-02, 0.1045D-02, 0.7509D-03, 0.5304D-03,
     >    0.3703D-03, 0.2565D-03, 0.1767D-03, 0.1213D-03, 0.8304D-04,
     >    0.5676D-04, 0.3876D-04, 0.2645D-04, 0.1803D-04, 0.1230D-04,
     >    0.8381D-05, 0.5712D-05, 0.3893D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,17), j = 1,neta) /0.5235D-22, 0.2003D-21,
     >    0.7672D-21, 0.2940D-20, 0.1127D-19, 0.4316D-19, 0.1653D-18,
     >    0.6334D-18, 0.2427D-17, 0.9299D-17, 0.3562D-16, 0.1365D-15,
     >    0.5228D-15, 0.2003D-14, 0.7668D-14, 0.2936D-13, 0.1124D-12,
     >    0.4301D-12, 0.1644D-11, 0.6281D-11, 0.2396D-10, 0.9120D-10,
     >    0.3462D-09, 0.1308D-08, 0.4904D-08, 0.1826D-07, 0.6705D-07,
     >    0.2418D-06, 0.8505D-06, 0.2888D-05, 0.9354D-05, 0.2847D-04,
     >    0.8001D-04, 0.2034D-03, 0.4584D-03, 0.8976D-03, 0.1506D-02,
     >    0.2155D-02, 0.2643D-02, 0.2820D-02, 0.2678D-02, 0.2315D-02,
     >    0.1863D-02, 0.1424D-02, 0.1050D-02, 0.7542D-03, 0.5324D-03,
     >    0.3714D-03, 0.2571D-03, 0.1770D-03, 0.1215D-03, 0.8313D-04,
     >    0.5680D-04, 0.3878D-04, 0.2646D-04, 0.1805D-04, 0.1230D-04,
     >    0.8382D-05, 0.5712D-05, 0.3893D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,18), j = 1,neta) /0.3573D-22, 0.1365D-21,
     >    0.5227D-21, 0.2003D-20, 0.7674D-20, 0.2940D-19, 0.1127D-18,
     >    0.4316D-18, 0.1653D-17, 0.6334D-17, 0.2427D-16, 0.9298D-16,
     >    0.3563D-15, 0.1364D-14, 0.5226D-14, 0.2001D-13, 0.7662D-13,
     >    0.2933D-12, 0.1122D-11, 0.4287D-11, 0.1637D-10, 0.6237D-10,
     >    0.2372D-09, 0.8985D-09, 0.3381D-08, 0.1265D-07, 0.4680D-07,
     >    0.1706D-06, 0.6078D-06, 0.2100D-05, 0.6957D-05, 0.2177D-04,
     >    0.6311D-04, 0.1661D-03, 0.3881D-03, 0.7881D-03, 0.1368D-02,
     >    0.2018D-02, 0.2537D-02, 0.2759D-02, 0.2652D-02, 0.2311D-02,
     >    0.1869D-02, 0.1432D-02, 0.1056D-02, 0.7584D-03, 0.5351D-03,
     >    0.3729D-03, 0.2580D-03, 0.1775D-03, 0.1217D-03, 0.8325D-04,
     >    0.5687D-04, 0.3882D-04, 0.2647D-04, 0.1805D-04, 0.1230D-04,
     >    0.8384D-05, 0.5714D-05, 0.3893D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,19), j = 1,neta) /0.2443D-22, 0.9299D-22,
     >    0.3561D-21, 0.1365D-20, 0.5229D-20, 0.2003D-19, 0.7675D-19,
     >    0.2940D-18, 0.1127D-17, 0.4317D-17, 0.1653D-16, 0.6334D-16,
     >    0.2427D-15, 0.9297D-15, 0.3561D-14, 0.1364D-13, 0.5222D-13,
     >    0.1998D-12, 0.7647D-12, 0.2923D-11, 0.1117D-10, 0.4260D-10,
     >    0.1622D-09, 0.6156D-09, 0.2322D-08, 0.8717D-08, 0.3243D-07,
     >    0.1190D-06, 0.4286D-06, 0.1502D-05, 0.5064D-05, 0.1621D-04,
     >    0.4834D-04, 0.1315D-03, 0.3186D-03, 0.6722D-03, 0.1212D-02,
     >    0.1851D-02, 0.2399D-02, 0.2670D-02, 0.2613D-02, 0.2304D-02,
     >    0.1875D-02, 0.1442D-02, 0.1064D-02, 0.7641D-03, 0.5385D-03,
     >    0.3750D-03, 0.2591D-03, 0.1781D-03, 0.1220D-03, 0.8342D-04,
     >    0.5695D-04, 0.3885D-04, 0.2649D-04, 0.1806D-04, 0.1231D-04,
     >    0.8387D-05, 0.5715D-05, 0.3894D-05, 0.2652D-05, 0.1807D-05,
     >    0.1231D-05, 0.8388D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,20), j = 1,neta) /0.1677D-22, 0.6337D-22,
     >    0.2424D-21, 0.9296D-21, 0.3563D-20, 0.1365D-19, 0.5229D-19,
     >    0.2004D-18, 0.7676D-18, 0.2940D-17, 0.1127D-16, 0.4316D-16,
     >    0.1653D-15, 0.6335D-15, 0.2427D-14, 0.9293D-14, 0.3558D-13,
     >    0.1362D-12, 0.5213D-12, 0.1993D-11, 0.7619D-11, 0.2909D-10,
     >    0.1108D-09, 0.4211D-09, 0.1593D-08, 0.5987D-08, 0.2235D-07,
     >    0.8247D-07, 0.2991D-06, 0.1059D-05, 0.3622D-05, 0.1181D-04,
     >    0.3608D-04, 0.1011D-03, 0.2535D-03, 0.5559D-03, 0.1044D-02,
     >    0.1658D-02, 0.2224D-02, 0.2552D-02, 0.2553D-02, 0.2286D-02,
     >    0.1880D-02, 0.1452D-02, 0.1074D-02, 0.7713D-03, 0.5433D-03,
     >    0.3778D-03, 0.2607D-03, 0.1790D-03, 0.1225D-03, 0.8365D-04,
     >    0.5708D-04, 0.3893D-04, 0.2652D-04, 0.1808D-04, 0.1231D-04,
     >    0.8391D-05, 0.5717D-05, 0.3894D-05, 0.2654D-05, 0.1807D-05,
     >    0.1231D-05, 0.8390D-06, 0.5715D-06, 0.3894D-06, 0.2652D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,21), j = 1,neta) /0.1158D-22, 0.4320D-22,
     >    0.1650D-21, 0.6332D-21, 0.2427D-20, 0.9297D-20, 0.3562D-19,
     >    0.1365D-18, 0.5229D-18, 0.2004D-17, 0.7676D-17, 0.2940D-16,
     >    0.1127D-15, 0.4316D-15, 0.1653D-14, 0.6331D-14, 0.2424D-13,
     >    0.9284D-13, 0.3553D-12, 0.1359D-11, 0.5195D-11, 0.1983D-10,
     >    0.7562D-10, 0.2876D-09, 0.1090D-08, 0.4103D-08, 0.1536D-07,
     >    0.5686D-07, 0.2073D-06, 0.7396D-06, 0.2556D-05, 0.8457D-05,
     >    0.2634D-04, 0.7564D-04, 0.1958D-03, 0.4452D-03, 0.8708D-03,
     >    0.1443D-02, 0.2016D-02, 0.2396D-02, 0.2466D-02, 0.2254D-02,
     >    0.1880D-02, 0.1463D-02, 0.1086D-02, 0.7806D-03, 0.5493D-03,
     >    0.3816D-03, 0.2628D-03, 0.1801D-03, 0.1231D-03, 0.8399D-04,
     >    0.5725D-04, 0.3900D-04, 0.2657D-04, 0.1811D-04, 0.1233D-04,
     >    0.8396D-05, 0.5720D-05, 0.3896D-05, 0.2654D-05, 0.1807D-05,
     >    0.1231D-05, 0.8390D-06, 0.5715D-06, 0.3894D-06, 0.2654D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,22), j = 1,neta) /0.8067D-23, 0.2946D-22,
     >    0.1123D-21, 0.4311D-21, 0.1654D-20, 0.6333D-20, 0.2427D-19,
     >    0.9298D-19, 0.3562D-18, 0.1365D-17, 0.5229D-17, 0.2004D-16,
     >    0.7676D-16, 0.2940D-15, 0.1126D-14, 0.4314D-14, 0.1652D-13,
     >    0.6326D-13, 0.2421D-12, 0.9263D-12, 0.3542D-11, 0.1353D-10,
     >    0.5158D-10, 0.1962D-09, 0.7445D-09, 0.2805D-08, 0.1052D-07,
     >    0.3906D-07, 0.1430D-06, 0.5127D-06, 0.1785D-05, 0.5972D-05,
     >    0.1887D-04, 0.5534D-04, 0.1470D-03, 0.3458D-03, 0.7032D-03,
     >    0.1217D-02, 0.1777D-02, 0.2201D-02, 0.2345D-02, 0.2201D-02,
     >    0.1869D-02, 0.1472D-02, 0.1099D-02, 0.7918D-03, 0.5573D-03,
     >    0.3864D-03, 0.2657D-03, 0.1818D-03, 0.1240D-03, 0.8445D-04,
     >    0.5750D-04, 0.3914D-04, 0.2664D-04, 0.1814D-04, 0.1234D-04,
     >    0.8405D-05, 0.5722D-05, 0.3897D-05, 0.2655D-05, 0.1807D-05,
     >    0.1232D-05, 0.8391D-06, 0.5717D-06, 0.3894D-06, 0.2654D-06,
     >    0.1808D-06, 0.1231D-06, 0.8388D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,23), j = 1,neta) /0.5685D-23, 0.2010D-22,
     >    0.7636D-22, 0.2936D-21, 0.1128D-20, 0.4314D-20, 0.1654D-19,
     >    0.6336D-19, 0.2427D-18, 0.9300D-18, 0.3563D-17, 0.1365D-16,
     >    0.5229D-16, 0.2004D-15, 0.7674D-15, 0.2940D-14, 0.1126D-13,
     >    0.4310D-13, 0.1650D-12, 0.6312D-12, 0.2414D-11, 0.9221D-11,
     >    0.3517D-10, 0.1339D-09, 0.5081D-09, 0.1920D-08, 0.7194D-08,
     >    0.2676D-07, 0.9820D-07, 0.3536D-06, 0.1238D-05, 0.4173D-05,
     >    0.1334D-04, 0.3972D-04, 0.1079D-03, 0.2610D-03, 0.5501D-03,
     >    0.9924D-03, 0.1517D-02, 0.1965D-02, 0.2182D-02, 0.2118D-02,
     >    0.1844D-02, 0.1476D-02, 0.1113D-02, 0.8052D-03, 0.5671D-03,
     >    0.3929D-03, 0.2696D-03, 0.1839D-03, 0.1252D-03, 0.8508D-04,
     >    0.5783D-04, 0.3930D-04, 0.2672D-04, 0.1818D-04, 0.1236D-04,
     >    0.8415D-05, 0.5729D-05, 0.3900D-05, 0.2657D-05, 0.1809D-05,
     >    0.1232D-05, 0.8393D-06, 0.5717D-06, 0.3894D-06, 0.2654D-06,
     >    0.1808D-06, 0.1231D-06, 0.8390D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,24), j = 1,neta) /0.4040D-23, 0.1371D-22,
     >    0.5190D-22, 0.1998D-21, 0.7686D-21, 0.2938D-20, 0.1127D-19,
     >    0.4317D-19, 0.1655D-18, 0.6336D-18, 0.2427D-17, 0.9300D-17,
     >    0.3562D-16, 0.1365D-15, 0.5229D-15, 0.2003D-14, 0.7670D-14,
     >    0.2937D-13, 0.1124D-12, 0.4302D-12, 0.1646D-11, 0.6284D-11,
     >    0.2397D-10, 0.9129D-10, 0.3467D-09, 0.1310D-08, 0.4914D-08,
     >    0.1830D-07, 0.6728D-07, 0.2428D-06, 0.8538D-06, 0.2894D-05,
     >    0.9329D-05, 0.2811D-04, 0.7761D-04, 0.1922D-03, 0.4178D-03,
     >    0.7832D-03, 0.1251D-02, 0.1699D-02, 0.1977D-02, 0.1998D-02,
     >    0.1796D-02, 0.1471D-02, 0.1125D-02, 0.8201D-03, 0.5792D-03,
     >    0.4010D-03, 0.2745D-03, 0.1869D-03, 0.1268D-03, 0.8597D-04,
     >    0.5829D-04, 0.3954D-04, 0.2685D-04, 0.1824D-04, 0.1240D-04,
     >    0.8430D-05, 0.5736D-05, 0.3905D-05, 0.2658D-05, 0.1811D-05,
     >    0.1233D-05, 0.8394D-06, 0.5718D-06, 0.3895D-06, 0.2654D-06,
     >    0.1808D-06, 0.1231D-06, 0.8390D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,25), j = 1,neta) /0.2879D-23, 0.9354D-23,
     >    0.3524D-22, 0.1360D-21, 0.5241D-21, 0.2003D-20, 0.7677D-20,
     >    0.2942D-19, 0.1127D-18, 0.4317D-18, 0.1653D-17, 0.6336D-17,
     >    0.2427D-16, 0.9298D-16, 0.3563D-15, 0.1364D-14, 0.5226D-14,
     >    0.2001D-13, 0.7659D-13, 0.2931D-12, 0.1121D-11, 0.4282D-11,
     >    0.1634D-10, 0.6224D-10, 0.2364D-09, 0.8938D-09, 0.3354D-08,
     >    0.1250D-07, 0.4602D-07, 0.1664D-06, 0.5867D-06, 0.1997D-05,
     >    0.6473D-05, 0.1968D-04, 0.5502D-04, 0.1387D-03, 0.3092D-03,
     >    0.5991D-03, 0.9977D-03, 0.1421D-02, 0.1734D-02, 0.1836D-02,
     >    0.1718D-02, 0.1449D-02, 0.1132D-02, 0.8349D-03, 0.5929D-03,
     >    0.4111D-03, 0.2811D-03, 0.1906D-03, 0.1290D-03, 0.8716D-04,
     >    0.5892D-04, 0.3987D-04, 0.2702D-04, 0.1833D-04, 0.1244D-04,
     >    0.8453D-05, 0.5748D-05, 0.3909D-05, 0.2661D-05, 0.1811D-05,
     >    0.1233D-05, 0.8398D-06, 0.5719D-06, 0.3895D-06, 0.2654D-06,
     >    0.1808D-06, 0.1232D-06, 0.8390D-07, 0.5715D-07, 0.3894D-07,
     >    0.2652D-07/

      data (calcpts(j,26), j = 1,neta) /0.2059D-23, 0.6393D-23,
     >    0.2394D-22, 0.9253D-22, 0.3573D-21, 0.1364D-20, 0.5231D-20,
     >    0.2004D-19, 0.7677D-19, 0.2940D-18, 0.1127D-17, 0.4317D-17,
     >    0.1653D-16, 0.6336D-16, 0.2427D-15, 0.9296D-15, 0.3560D-14,
     >    0.1363D-13, 0.5218D-13, 0.1997D-12, 0.7637D-12, 0.2918D-11,
     >    0.1114D-10, 0.4242D-10, 0.1611D-09, 0.6094D-09, 0.2289D-08,
     >    0.8532D-08, 0.3144D-07, 0.1138D-06, 0.4020D-06, 0.1372D-05,
     >    0.4467D-05, 0.1366D-04, 0.3855D-04, 0.9854D-04, 0.2239D-03,
     >    0.4461D-03, 0.7699D-03, 0.1146D-02, 0.1469D-02, 0.1635D-02,
     >    0.1601D-02, 0.1404D-02, 0.1127D-02, 0.8472D-03, 0.6080D-03,
     >    0.4232D-03, 0.2892D-03, 0.1958D-03, 0.1319D-03, 0.8879D-04,
     >    0.5981D-04, 0.4033D-04, 0.2726D-04, 0.1845D-04, 0.1250D-04,
     >    0.8484D-05, 0.5763D-05, 0.3918D-05, 0.2664D-05, 0.1814D-05,
     >    0.1234D-05, 0.8403D-06, 0.5721D-06, 0.3897D-06, 0.2654D-06,
     >    0.1808D-06, 0.1232D-06, 0.8390D-07, 0.5715D-07, 0.3894D-07,
     >    0.2654D-07/

      data (calcpts(j,27), j = 1,neta) /0.1454D-23, 0.4358D-23,
     >    0.1624D-22, 0.6296D-22, 0.2436D-21, 0.9289D-21, 0.3564D-20,
     >    0.1365D-19, 0.5230D-19, 0.2004D-18, 0.7676D-18, 0.2941D-17,
     >    0.1127D-16, 0.4316D-16, 0.1653D-15, 0.6333D-15, 0.2426D-14,
     >    0.9288D-14, 0.3555D-13, 0.1361D-12, 0.5203D-12, 0.1989D-11,
     >    0.7587D-11, 0.2891D-10, 0.1098D-09, 0.4155D-09, 0.1563D-08,
     >    0.5820D-08, 0.2145D-07, 0.7775D-07, 0.2750D-06, 0.9402D-06,
     >    0.3071D-05, 0.9431D-05, 0.2679D-04, 0.6917D-04, 0.1596D-03,
     >    0.3246D-03, 0.5772D-03, 0.8927D-03, 0.1199D-02, 0.1404D-02,
     >    0.1446D-02, 0.1327D-02, 0.1105D-02, 0.8527D-03, 0.6221D-03,
     >    0.4365D-03, 0.2991D-03, 0.2022D-03, 0.1357D-03, 0.9096D-04,
     >    0.6099D-04, 0.4098D-04, 0.2759D-04, 0.1862D-04, 0.1259D-04,
     >    0.8529D-05, 0.5785D-05, 0.3929D-05, 0.2670D-05, 0.1816D-05,
     >    0.1235D-05, 0.8409D-06, 0.5726D-06, 0.3899D-06, 0.2655D-06,
     >    0.1809D-06, 0.1232D-06, 0.8391D-07, 0.5717D-07, 0.3894D-07,
     >    0.2654D-07/

      data (calcpts(j,28), j = 1,neta) /0.1025D-23, 0.2973D-23,
     >    0.1104D-22, 0.4286D-22, 0.1661D-21, 0.6328D-21, 0.2428D-20,
     >    0.9300D-20, 0.3564D-19, 0.1365D-18, 0.5229D-18, 0.2004D-17,
     >    0.7676D-17, 0.2940D-16, 0.1127D-15, 0.4316D-15, 0.1653D-14,
     >    0.6329D-14, 0.2422D-13, 0.9270D-13, 0.3545D-12, 0.1355D-11,
     >    0.5171D-11, 0.1970D-10, 0.7482D-10, 0.2832D-09, 0.1066D-08,
     >    0.3969D-08, 0.1464D-07, 0.5307D-07, 0.1878D-06, 0.6432D-06,
     >    0.2105D-05, 0.6485D-05, 0.1851D-04, 0.4812D-04, 0.1122D-03,
     >    0.2321D-03, 0.4224D-03, 0.6744D-03, 0.9441D-03, 0.1161D-02,
     >    0.1259D-02, 0.1215D-02, 0.1058D-02, 0.8457D-03, 0.6321D-03,
     >    0.4501D-03, 0.3105D-03, 0.2100D-03, 0.1406D-03, 0.9384D-04,
     >    0.6260D-04, 0.4185D-04, 0.2805D-04, 0.1886D-04, 0.1271D-04,
     >    0.8592D-05, 0.5817D-05, 0.3945D-05, 0.2677D-05, 0.1820D-05,
     >    0.1237D-05, 0.8418D-06, 0.5730D-06, 0.3900D-06, 0.2657D-06,
     >    0.1809D-06, 0.1232D-06, 0.8393D-07, 0.5717D-07, 0.3894D-07,
     >    0.2654D-07/

      data (calcpts(j,29), j = 1,neta) /0.7223D-24, 0.2028D-23,
     >    0.7517D-23, 0.2915D-22, 0.1131D-21, 0.4311D-21, 0.1654D-20,
     >    0.6336D-20, 0.2427D-19, 0.9300D-19, 0.3562D-18, 0.1365D-17,
     >    0.5229D-17, 0.2004D-16, 0.7674D-16, 0.2940D-15, 0.1126D-14,
     >    0.4311D-14, 0.1650D-13, 0.6315D-13, 0.2415D-12, 0.9230D-12,
     >    0.3522D-11, 0.1342D-10, 0.5098D-10, 0.1931D-09, 0.7263D-09,
     >    0.2706D-08, 0.9980D-08, 0.3620D-07, 0.1282D-06, 0.4393D-06,
     >    0.1440D-05, 0.4445D-05, 0.1273D-04, 0.3327D-04, 0.7820D-04,
     >    0.1637D-03, 0.3032D-03, 0.4965D-03, 0.7194D-03, 0.9237D-03,
     >    0.1054D-02, 0.1073D-02, 0.9827D-03, 0.8201D-03, 0.6337D-03,
     >    0.4617D-03, 0.3225D-03, 0.2193D-03, 0.1468D-03, 0.9754D-04,
     >    0.6474D-04, 0.4302D-04, 0.2868D-04, 0.1919D-04, 0.1288D-04,
     >    0.8679D-05, 0.5861D-05, 0.3966D-05, 0.2689D-05, 0.1825D-05,
     >    0.1240D-05, 0.8432D-06, 0.5736D-06, 0.3904D-06, 0.2658D-06,
     >    0.1809D-06, 0.1232D-06, 0.8394D-07, 0.5718D-07, 0.3896D-07,
     >    0.2654D-07/

      data (calcpts(j,30), j = 1,neta) /0.4949D-24, 0.1383D-23,
     >    0.5113D-23, 0.1989D-22, 0.7709D-22, 0.2936D-21, 0.1127D-20,
     >    0.4317D-20, 0.1654D-19, 0.6336D-19, 0.2427D-18, 0.9300D-18,
     >    0.3563D-17, 0.1365D-16, 0.5229D-16, 0.2002D-15, 0.7671D-15,
     >    0.2937D-14, 0.1124D-13, 0.4304D-13, 0.1646D-12, 0.6288D-12,
     >    0.2400D-11, 0.9144D-11, 0.3474D-10, 0.1315D-09, 0.4950D-09,
     >    0.1848D-08, 0.6803D-08, 0.2469D-07, 0.8746D-07, 0.2998D-06,
     >    0.9835D-06, 0.3042D-05, 0.8730D-05, 0.2289D-04, 0.5411D-04,
     >    0.1142D-03, 0.2144D-03, 0.3581D-03, 0.5332D-03, 0.7101D-03,
     >    0.8477D-03, 0.9087D-03, 0.8783D-03, 0.7709D-03, 0.6216D-03,
     >    0.4676D-03, 0.3336D-03, 0.2294D-03, 0.1541D-03, 0.1022D-03,
     >    0.6752D-04, 0.4460D-04, 0.2954D-04, 0.1965D-04, 0.1312D-04,
     >    0.8800D-05, 0.5924D-05, 0.3998D-05, 0.2705D-05, 0.1833D-05,
     >    0.1244D-05, 0.8451D-06, 0.5745D-06, 0.3909D-06, 0.2660D-06,
     >    0.1810D-06, 0.1233D-06, 0.8397D-07, 0.5719D-07, 0.3896D-07,
     >    0.2654D-07/

      data (calcpts(j,31), j = 1,neta) /0.3417D-24, 0.9340D-24,
     >    0.3495D-23, 0.1351D-22, 0.5253D-22, 0.2000D-21, 0.7671D-21,
     >    0.2941D-20, 0.1127D-19, 0.4317D-19, 0.1653D-18, 0.6336D-18,
     >    0.2427D-17, 0.9299D-17, 0.3562D-16, 0.1365D-15, 0.5226D-15,
     >    0.2001D-14, 0.7661D-14, 0.2931D-13, 0.1121D-12, 0.4284D-12,
     >    0.1635D-11, 0.6229D-11, 0.2367D-10, 0.8960D-10, 0.3372D-09,
     >    0.1259D-08, 0.4636D-08, 0.1683D-07, 0.5964D-07, 0.2046D-06,
     >    0.6714D-06, 0.2079D-05, 0.5975D-05, 0.1570D-04, 0.3726D-04,
     >    0.7914D-04, 0.1500D-03, 0.2541D-03, 0.3864D-03, 0.5300D-03,
     >    0.6575D-03, 0.7388D-03, 0.7529D-03, 0.6975D-03, 0.5913D-03,
     >    0.4636D-03, 0.3410D-03, 0.2391D-03, 0.1622D-03, 0.1079D-03,
     >    0.7103D-04, 0.4665D-04, 0.3069D-04, 0.2026D-04, 0.1345D-04,
     >    0.8972D-05, 0.6011D-05, 0.4043D-05, 0.2727D-05, 0.1844D-05,
     >    0.1250D-05, 0.8478D-06, 0.5759D-06, 0.3915D-06, 0.2662D-06,
     >    0.1812D-06, 0.1234D-06, 0.8400D-07, 0.5721D-07, 0.3897D-07,
     >    0.2654D-07/

      data (calcpts(j,32), j = 1,neta) /0.2423D-24, 0.6489D-24,
     >    0.2356D-23, 0.9243D-23, 0.3575D-22, 0.1364D-21, 0.5237D-21,
     >    0.2004D-20, 0.7677D-20, 0.2942D-19, 0.1127D-18, 0.4317D-18,
     >    0.1653D-17, 0.6336D-17, 0.2427D-16, 0.9295D-16, 0.3561D-15,
     >    0.1363D-14, 0.5218D-14, 0.1998D-13, 0.7638D-13, 0.2919D-12,
     >    0.1114D-11, 0.4245D-11, 0.1613D-10, 0.6105D-10, 0.2298D-09,
     >    0.8580D-09, 0.3159D-08, 0.1147D-07, 0.4065D-07, 0.1395D-06,
     >    0.4581D-06, 0.1419D-05, 0.4083D-05, 0.1075D-04, 0.2558D-04,
     >    0.5456D-04, 0.1041D-03, 0.1782D-03, 0.2751D-03, 0.3859D-03,
     >    0.4940D-03, 0.5780D-03, 0.6183D-03, 0.6045D-03, 0.5411D-03,
     >    0.4456D-03, 0.3414D-03, 0.2466D-03, 0.1704D-03, 0.1143D-03,
     >    0.7532D-04, 0.4927D-04, 0.3219D-04, 0.2110D-04, 0.1390D-04,
     >    0.9206D-05, 0.6132D-05, 0.4104D-05, 0.2759D-05, 0.1860D-05,
     >    0.1257D-05, 0.8517D-06, 0.5778D-06, 0.3924D-06, 0.2667D-06,
     >    0.1815D-06, 0.1235D-06, 0.8406D-07, 0.5723D-07, 0.3897D-07,
     >    0.2655D-07/

      data (calcpts(j,33), j = 1,neta) /0.1613D-24, 0.4423D-24,
     >    0.1620D-23, 0.6268D-23, 0.2436D-22, 0.9282D-22, 0.3569D-21,
     >    0.1365D-20, 0.5231D-20, 0.2004D-19, 0.7675D-19, 0.2941D-18,
     >    0.1127D-17, 0.4316D-17, 0.1653D-16, 0.6333D-16, 0.2426D-15,
     >    0.9288D-15, 0.3557D-14, 0.1361D-13, 0.5204D-13, 0.1989D-12,
     >    0.7590D-12, 0.2892D-11, 0.1099D-10, 0.4159D-10, 0.1566D-09,
     >    0.5847D-09, 0.2155D-08, 0.7815D-08, 0.2770D-07, 0.9510D-07,
     >    0.3123D-06, 0.9679D-06, 0.2787D-05, 0.7349D-05, 0.1752D-04,
     >    0.3747D-04, 0.7182D-04, 0.1238D-03, 0.1935D-03, 0.2760D-03,
     >    0.3617D-03, 0.4372D-03, 0.4877D-03, 0.5012D-03, 0.4735D-03,
     >    0.4121D-03, 0.3317D-03, 0.2492D-03, 0.1771D-03, 0.1208D-03,
     >    0.8025D-04, 0.5250D-04, 0.3414D-04, 0.2220D-04, 0.1450D-04,
     >    0.9528D-05, 0.6300D-05, 0.4191D-05, 0.2802D-05, 0.1883D-05,
     >    0.1268D-05, 0.8571D-06, 0.5805D-06, 0.3938D-06, 0.2674D-06,
     >    0.1818D-06, 0.1236D-06, 0.8413D-07, 0.5727D-07, 0.3900D-07,
     >    0.2655D-07/

      data (calcpts(j,34), j = 1,neta) /0.1105D-24, 0.3016D-24,
     >    0.1082D-23, 0.4271D-23, 0.1659D-22, 0.6324D-22, 0.2432D-21,
     >    0.9297D-21, 0.3563D-20, 0.1365D-19, 0.5229D-19, 0.2004D-18,
     >    0.7676D-18, 0.2940D-17, 0.1127D-16, 0.4316D-16, 0.1653D-15,
     >    0.6329D-15, 0.2423D-14, 0.9270D-14, 0.3546D-13, 0.1355D-12,
     >    0.5172D-12, 0.1970D-11, 0.7487D-11, 0.2834D-10, 0.1067D-09,
     >    0.3984D-09, 0.1470D-08, 0.5325D-08, 0.1889D-07, 0.6482D-07,
     >    0.2130D-06, 0.6602D-06, 0.1902D-05, 0.5018D-05, 0.1198D-04,
     >    0.2567D-04, 0.4937D-04, 0.8555D-04, 0.1347D-03, 0.1946D-03,
     >    0.2595D-03, 0.3218D-03, 0.3714D-03, 0.3984D-03, 0.3962D-03,
     >    0.3642D-03, 0.3095D-03, 0.2442D-03, 0.1805D-03, 0.1266D-03,
     >    0.8544D-04, 0.5625D-04, 0.3654D-04, 0.2363D-04, 0.1530D-04,
     >    0.9963D-05, 0.6531D-05, 0.4309D-05, 0.2863D-05, 0.1913D-05,
     >    0.1284D-05, 0.8649D-06, 0.5844D-06, 0.3957D-06, 0.2683D-06,
     >    0.1823D-06, 0.1239D-06, 0.8424D-07, 0.5732D-07, 0.3902D-07,
     >    0.2657D-07/

      data (calcpts(j,35), j = 1,neta) /0.8031D-25, 0.2055D-24,
     >    0.7368D-24, 0.2908D-23, 0.1125D-22, 0.4308D-22, 0.1656D-21,
     >    0.6338D-21, 0.2427D-20, 0.9300D-20, 0.3562D-19, 0.1365D-18,
     >    0.5229D-18, 0.2004D-17, 0.7674D-17, 0.2940D-16, 0.1126D-15,
     >    0.4311D-15, 0.1650D-14, 0.6316D-14, 0.2415D-13, 0.9231D-13,
     >    0.3524D-12, 0.1342D-11, 0.5100D-11, 0.1931D-10, 0.7267D-10,
     >    0.2714D-09, 0.1002D-08, 0.3629D-08, 0.1287D-07, 0.4418D-07,
     >    0.1451D-06, 0.4500D-06, 0.1297D-05, 0.3424D-05, 0.8178D-05,
     >    0.1755D-04, 0.3384D-04, 0.5884D-04, 0.9319D-04, 0.1357D-03,
     >    0.1835D-03, 0.2317D-03, 0.2747D-03, 0.3053D-03, 0.3172D-03,
     >    0.3071D-03, 0.2759D-03, 0.2299D-03, 0.1784D-03, 0.1301D-03,
     >    0.9017D-04, 0.6026D-04, 0.3936D-04, 0.2540D-04, 0.1635D-04,
     >    0.1054D-04, 0.6843D-05, 0.4475D-05, 0.2949D-05, 0.1956D-05,
     >    0.1306D-05, 0.8760D-06, 0.5898D-06, 0.3984D-06, 0.2697D-06,
     >    0.1828D-06, 0.1242D-06, 0.8441D-07, 0.5740D-07, 0.3906D-07,
     >    0.2658D-07/

      data (calcpts(j,36), j = 1,neta) /0.5171D-25, 0.1239D-24,
     >    0.5018D-24, 0.1958D-23, 0.7728D-23, 0.2945D-22, 0.1128D-21,
     >    0.4314D-21, 0.1654D-20, 0.6336D-20, 0.2427D-19, 0.9300D-19,
     >    0.3562D-18, 0.1365D-17, 0.5229D-17, 0.2003D-16, 0.7671D-16,
     >    0.2937D-15, 0.1124D-14, 0.4303D-14, 0.1646D-13, 0.6290D-13,
     >    0.2400D-12, 0.9146D-12, 0.3475D-11, 0.1316D-10, 0.4951D-10,
     >    0.1850D-09, 0.6825D-09, 0.2474D-08, 0.8768D-08, 0.3011D-07,
     >    0.9891D-07, 0.3068D-06, 0.8843D-06, 0.2336D-05, 0.5582D-05,
     >    0.1199D-04, 0.2314D-04, 0.4037D-04, 0.6416D-04, 0.9402D-04,
     >    0.1283D-03, 0.1643D-03, 0.1986D-03, 0.2268D-03, 0.2444D-03,
     >    0.2475D-03, 0.2343D-03, 0.2065D-03, 0.1694D-03, 0.1295D-03,
     >    0.9328D-04, 0.6401D-04, 0.4241D-04, 0.2750D-04, 0.1764D-04,
     >    0.1130D-04, 0.7261D-05, 0.4700D-05, 0.3066D-05, 0.2018D-05,
     >    0.1337D-05, 0.8915D-06, 0.5976D-06, 0.4023D-06, 0.2717D-06,
     >    0.1839D-06, 0.1246D-06, 0.8462D-07, 0.5751D-07, 0.3910D-07,
     >    0.2661D-07/

      data (calcpts(j,37), j = 1,neta) /0.3531D-25, 0.9543D-25,
     >    0.3418D-24, 0.1334D-23, 0.5265D-23, 0.1999D-22, 0.7687D-22,
     >    0.2940D-21, 0.1127D-20, 0.4317D-20, 0.1654D-19, 0.6336D-19,
     >    0.2427D-18, 0.9299D-18, 0.3563D-17, 0.1365D-16, 0.5226D-16,
     >    0.2001D-15, 0.7660D-15, 0.2931D-14, 0.1121D-13, 0.4284D-13,
     >    0.1635D-12, 0.6231D-12, 0.2367D-11, 0.8963D-11, 0.3374D-10,
     >    0.1260D-09, 0.4650D-09, 0.1688D-08, 0.5974D-08, 0.2051D-07,
     >    0.6740D-07, 0.2090D-06, 0.6027D-06, 0.1592D-05, 0.3807D-05,
     >    0.8184D-05, 0.1581D-04, 0.2762D-04, 0.4402D-04, 0.6478D-04,
     >    0.8898D-04, 0.1151D-03, 0.1411D-03, 0.1646D-03, 0.1824D-03,
     >    0.1917D-03, 0.1901D-03, 0.1766D-03, 0.1532D-03, 0.1238D-03,
     >    0.9359D-04, 0.6668D-04, 0.4533D-04, 0.2980D-04, 0.1920D-04,
     >    0.1225D-04, 0.7807D-05, 0.5000D-05, 0.3227D-05, 0.2100D-05,
     >    0.1380D-05, 0.9132D-06, 0.6085D-06, 0.4077D-06, 0.2744D-06,
     >    0.1851D-06, 0.1253D-06, 0.8495D-07, 0.5766D-07, 0.3918D-07,
     >    0.2664D-07/

      data (calcpts(j,38), j = 1,neta) /0.2861D-25, 0.5749D-25,
     >    0.2328D-24, 0.9369D-24, 0.3558D-23, 0.1362D-22, 0.5230D-22,
     >    0.2003D-21, 0.7674D-21, 0.2940D-20, 0.1127D-19, 0.4317D-19,
     >    0.1653D-18, 0.6336D-18, 0.2427D-17, 0.9296D-17, 0.3561D-16,
     >    0.1363D-15, 0.5220D-15, 0.1998D-14, 0.7639D-14, 0.2919D-13,
     >    0.1114D-12, 0.4245D-12, 0.1613D-11, 0.6107D-11, 0.2298D-10,
     >    0.8583D-10, 0.3168D-09, 0.1150D-08, 0.4071D-08, 0.1398D-07,
     >    0.4592D-07, 0.1424D-06, 0.4107D-06, 0.1085D-05, 0.2595D-05,
     >    0.5583D-05, 0.1080D-04, 0.1887D-04, 0.3015D-04, 0.4449D-04,
     >    0.6138D-04, 0.7995D-04, 0.9905D-04, 0.1172D-03, 0.1327D-03,
     >    0.1436D-03, 0.1479D-03, 0.1440D-03, 0.1318D-03, 0.1127D-03,
     >    0.9003D-04, 0.6732D-04, 0.4752D-04, 0.3204D-04, 0.2091D-04,
     >    0.1339D-04, 0.8498D-05, 0.5394D-05, 0.3443D-05, 0.2216D-05,
     >    0.1439D-05, 0.9437D-06, 0.6239D-06, 0.4154D-06, 0.2781D-06,
     >    0.1870D-06, 0.1262D-06, 0.8540D-07, 0.5789D-07, 0.3930D-07,
     >    0.2670D-07/

      data (calcpts(j,39), j = 1,neta) /0.1952D-25, 0.4561D-25,
     >    0.1587D-24, 0.6522D-24, 0.2424D-23, 0.9308D-23, 0.3564D-22,
     >    0.1364D-21, 0.5231D-21, 0.2004D-20, 0.7676D-20, 0.2942D-19,
     >    0.1127D-18, 0.4316D-18, 0.1653D-17, 0.6333D-17, 0.2426D-16,
     >    0.9288D-16, 0.3557D-15, 0.1361D-14, 0.5205D-14, 0.1989D-13,
     >    0.7590D-13, 0.2892D-12, 0.1099D-11, 0.4160D-11, 0.1566D-10,
     >    0.5849D-10, 0.2158D-09, 0.7836D-09, 0.2774D-08, 0.9522D-08,
     >    0.3129D-07, 0.9705D-07, 0.2799D-06, 0.7395D-06, 0.1769D-05,
     >    0.3807D-05, 0.7365D-05, 0.1289D-04, 0.2061D-04, 0.3048D-04,
     >    0.4218D-04, 0.5520D-04, 0.6888D-04, 0.8240D-04, 0.9478D-04,
     >    0.1048D-03, 0.1112D-03, 0.1125D-03, 0.1080D-03, 0.9752D-04,
     >    0.8245D-04, 0.6516D-04, 0.4827D-04, 0.3378D-04, 0.2261D-04,
     >    0.1466D-04, 0.9330D-05, 0.5894D-05, 0.3724D-05, 0.2369D-05,
     >    0.1521D-05, 0.9858D-06, 0.6455D-06, 0.4263D-06, 0.2835D-06,
     >    0.1898D-06, 0.1276D-06, 0.8605D-07, 0.5822D-07, 0.3945D-07,
     >    0.2677D-07/

      data (calcpts(j,40), j = 1,neta) /0.7491D-26, 0.2667D-25,
     >    0.1178D-24, 0.4443D-24, 0.1649D-23, 0.6341D-23, 0.2426D-22,
     >    0.9296D-22, 0.3564D-21, 0.1365D-20, 0.5229D-20, 0.2004D-19,
     >    0.7675D-19, 0.2940D-18, 0.1127D-17, 0.4316D-17, 0.1653D-16,
     >    0.6329D-16, 0.2423D-15, 0.9270D-15, 0.3546D-14, 0.1355D-13,
     >    0.5172D-13, 0.1971D-12, 0.7486D-12, 0.2834D-11, 0.1067D-10,
     >    0.3984D-10, 0.1471D-09, 0.5338D-09, 0.1893D-08, 0.6488D-08,
     >    0.2132D-07, 0.6614D-07, 0.1907D-06, 0.5040D-06, 0.1206D-05,
     >    0.2595D-05, 0.5022D-05, 0.8793D-05, 0.1407D-04, 0.2083D-04,
     >    0.2891D-04, 0.3795D-04, 0.4760D-04, 0.5738D-04, 0.6674D-04,
     >    0.7500D-04, 0.8136D-04, 0.8488D-04, 0.8471D-04, 0.8025D-04,
     >    0.7167D-04, 0.6000D-04, 0.4698D-04, 0.3450D-04, 0.2397D-04,
     >    0.1593D-04, 0.1026D-04, 0.6498D-05, 0.4085D-05, 0.2571D-05,
     >    0.1631D-05, 0.1044D-05, 0.6753D-06, 0.4414D-06, 0.2912D-06,
     >    0.1935D-06, 0.1295D-06, 0.8699D-07, 0.5866D-07, 0.3968D-07,
     >    0.2688D-07/

      data (calcpts(j,41), j = 1,neta) /0.5321D-26, 0.2247D-25,
     >    0.7351D-25, 0.2945D-24, 0.1133D-23, 0.4324D-23, 0.1653D-22,
     >    0.6333D-22, 0.2427D-21, 0.9299D-21, 0.3563D-20, 0.1365D-19,
     >    0.5229D-19, 0.2004D-18, 0.7674D-18, 0.2940D-17, 0.1126D-16,
     >    0.4311D-16, 0.1650D-15, 0.6317D-15, 0.2415D-14, 0.9231D-14,
     >    0.3524D-13, 0.1342D-12, 0.5102D-12, 0.1931D-11, 0.7269D-11,
     >    0.2715D-10, 0.1002D-09, 0.3638D-09, 0.1290D-08, 0.4421D-08,
     >    0.1452D-07, 0.4506D-07, 0.1299D-06, 0.3434D-06, 0.8217D-06,
     >    0.1769D-05, 0.3423D-05, 0.5997D-05, 0.9603D-05, 0.1423D-04,
     >    0.1977D-04, 0.2602D-04, 0.3274D-04, 0.3969D-04, 0.4653D-04,
     >    0.5289D-04, 0.5832D-04, 0.6227D-04, 0.6408D-04, 0.6318D-04,
     >    0.5922D-04, 0.5238D-04, 0.4346D-04, 0.3375D-04, 0.2460D-04,
     >    0.1697D-04, 0.1121D-04, 0.7182D-05, 0.4523D-05, 0.2831D-05,
     >    0.1774D-05, 0.1122D-05, 0.7163D-06, 0.4626D-06, 0.3020D-06,
     >    0.1989D-06, 0.1321D-06, 0.8830D-07, 0.5931D-07, 0.3999D-07,
     >    0.2705D-07/

      data (calcpts(j,42), j = 1,neta) /0.1749D-26, 0.1238D-25,
     >    0.4942D-25, 0.1999D-24, 0.7656D-24, 0.2949D-23, 0.1128D-22,
     >    0.4317D-22, 0.1655D-21, 0.6336D-21, 0.2427D-20, 0.9300D-20,
     >    0.3562D-19, 0.1365D-18, 0.5229D-18, 0.2003D-17, 0.7671D-17,
     >    0.2937D-16, 0.1124D-15, 0.4303D-15, 0.1646D-14, 0.6290D-14,
     >    0.2400D-13, 0.9146D-13, 0.3476D-12, 0.1315D-11, 0.4952D-11,
     >    0.1850D-10, 0.6827D-10, 0.2478D-09, 0.8790D-09, 0.3012D-08,
     >    0.9895D-08, 0.3069D-07, 0.8855D-07, 0.2340D-06, 0.5598D-06,
     >    0.1205D-05, 0.2334D-05, 0.4088D-05, 0.6549D-05, 0.9714D-05,
     >    0.1351D-04, 0.1780D-04, 0.2246D-04, 0.2732D-04, 0.3221D-04,
     >    0.3692D-04, 0.4119D-04, 0.4472D-04, 0.4710D-04, 0.4792D-04,
     >    0.4677D-04, 0.4344D-04, 0.3810D-04, 0.3135D-04, 0.2418D-04,
     >    0.1751D-04, 0.1200D-04, 0.7878D-05, 0.5021D-05, 0.3147D-05,
     >    0.1961D-05, 0.1225D-05, 0.7718D-06, 0.4916D-06, 0.3168D-06,
     >    0.2066D-06, 0.1359D-06, 0.9018D-07, 0.6024D-07, 0.4046D-07,
     >    0.2727D-07/

      data (calcpts(j,43), j = 1,neta) /0.2703D-26, 0.8444D-26,
     >    0.3725D-25, 0.1405D-24, 0.5220D-24, 0.2006D-23, 0.7684D-23,
     >    0.2938D-22, 0.1127D-21, 0.4316D-21, 0.1654D-20, 0.6336D-20,
     >    0.2427D-19, 0.9298D-19, 0.3562D-18, 0.1365D-17, 0.5226D-17,
     >    0.2001D-16, 0.7661D-16, 0.2931D-15, 0.1121D-14, 0.4284D-14,
     >    0.1635D-13, 0.6231D-13, 0.2367D-12, 0.8963D-12, 0.3373D-11,
     >    0.1260D-10, 0.4650D-10, 0.1689D-09, 0.5988D-09, 0.2055D-08,
     >    0.6742D-08, 0.2091D-07, 0.6033D-07, 0.1595D-06, 0.3815D-06,
     >    0.8212D-06, 0.1590D-05, 0.2787D-05, 0.4466D-05, 0.6626D-05,
     >    0.9219D-05, 0.1217D-04, 0.1538D-04, 0.1875D-04, 0.2219D-04,
     >    0.2556D-04, 0.2877D-04, 0.3160D-04, 0.3387D-04, 0.3530D-04,
     >    0.3555D-04, 0.3439D-04, 0.3168D-04, 0.2759D-04, 0.2254D-04,
     >    0.1727D-04, 0.1243D-04, 0.8470D-05, 0.5531D-05, 0.3507D-05,
     >    0.2188D-05, 0.1358D-05, 0.8454D-06, 0.5310D-06, 0.3373D-06,
     >    0.2171D-06, 0.1412D-06, 0.9284D-07, 0.6156D-07, 0.4110D-07,
     >    0.2759D-07/

      data (calcpts(j,44), j = 1,neta) /0.1634D-26, 0.5751D-26,
     >    0.2562D-25, 0.9281D-25, 0.3562D-24, 0.1366D-23, 0.5227D-23,
     >    0.2003D-22, 0.7679D-22, 0.2940D-21, 0.1127D-20, 0.4317D-20,
     >    0.1654D-19, 0.6336D-19, 0.2427D-18, 0.9295D-18, 0.3561D-17,
     >    0.1363D-16, 0.5220D-16, 0.1998D-15, 0.7640D-15, 0.2919D-14,
     >    0.1114D-13, 0.4245D-13, 0.1612D-12, 0.6107D-12, 0.2298D-11,
     >    0.8583D-11, 0.3168D-10, 0.1150D-09, 0.4080D-09, 0.1401D-08,
     >    0.4593D-08, 0.1425D-07, 0.4110D-07, 0.1086D-06, 0.2599D-06,
     >    0.5595D-06, 0.1084D-05, 0.1899D-05, 0.3044D-05, 0.4518D-05,
     >    0.6290D-05, 0.8306D-05, 0.1051D-04, 0.1283D-04, 0.1523D-04,
     >    0.1763D-04, 0.1994D-04, 0.2209D-04, 0.2397D-04, 0.2541D-04,
     >    0.2622D-04, 0.2621D-04, 0.2516D-04, 0.2301D-04, 0.1991D-04,
     >    0.1617D-04, 0.1231D-04, 0.8811D-05, 0.5972D-05, 0.3881D-05,
     >    0.2448D-05, 0.1521D-05, 0.9401D-06, 0.5832D-06, 0.3652D-06,
     >    0.2314D-06, 0.1486D-06, 0.9657D-07, 0.6342D-07, 0.4202D-07,
     >    0.2804D-07/

      data (calcpts(j,45), j = 1,neta) /0.1110D-26, 0.4410D-26,
     >    0.1734D-25, 0.6595D-25, 0.2443D-24, 0.9300D-24, 0.3569D-23,
     >    0.1366D-22, 0.5229D-22, 0.2005D-21, 0.7677D-21, 0.2941D-20,
     >    0.1127D-19, 0.4317D-19, 0.1653D-18, 0.6333D-18, 0.2425D-17,
     >    0.9288D-17, 0.3557D-16, 0.1361D-15, 0.5205D-15, 0.1989D-14,
     >    0.7590D-14, 0.2892D-13, 0.1099D-12, 0.4160D-12, 0.1566D-11,
     >    0.5849D-11, 0.2159D-10, 0.7838D-10, 0.2780D-09, 0.9544D-09,
     >    0.3129D-08, 0.9708D-08, 0.2801D-07, 0.7400D-07, 0.1771D-06,
     >    0.3813D-06, 0.7383D-06, 0.1294D-05, 0.2075D-05, 0.3080D-05,
     >    0.4289D-05, 0.5666D-05, 0.7174D-05, 0.8773D-05, 0.1043D-04,
     >    0.1210D-04, 0.1375D-04, 0.1533D-04, 0.1677D-04, 0.1800D-04,
     >    0.1892D-04, 0.1935D-04, 0.1920D-04, 0.1831D-04, 0.1665D-04,
     >    0.1431D-04, 0.1157D-04, 0.8758D-05, 0.6236D-05, 0.4206D-05,
     >    0.2719D-05, 0.1709D-05, 0.1056D-05, 0.6505D-06, 0.4023D-06,
     >    0.2513D-06, 0.1588D-06, 0.1018D-06, 0.6605D-07, 0.4332D-07,
     >    0.2868D-07/

      data (calcpts(j,46), j = 1,neta) /0.9015D-27, 0.2622D-26,
     >    0.1135D-25, 0.4299D-25, 0.1673D-24, 0.6300D-24, 0.2432D-23,
     >    0.9301D-23, 0.3562D-22, 0.1364D-21, 0.5229D-21, 0.2004D-20,
     >    0.7676D-20, 0.2940D-19, 0.1127D-18, 0.4316D-18, 0.1653D-17,
     >    0.6329D-17, 0.2423D-16, 0.9270D-16, 0.3546D-15, 0.1355D-14,
     >    0.5172D-14, 0.1971D-13, 0.7487D-13, 0.2834D-12, 0.1067D-11,
     >    0.3984D-11, 0.1471D-10, 0.5340D-10, 0.1893D-09, 0.6503D-09,
     >    0.2135D-08, 0.6613D-08, 0.1908D-07, 0.5042D-07, 0.1207D-06,
     >    0.2598D-06, 0.5031D-06, 0.8817D-06, 0.1414D-05, 0.2098D-05,
     >    0.2924D-05, 0.3864D-05, 0.4895D-05, 0.5991D-05, 0.7128D-05,
     >    0.8286D-05, 0.9442D-05, 0.1057D-04, 0.1164D-04, 0.1260D-04,
     >    0.1341D-04, 0.1397D-04, 0.1420D-04, 0.1400D-04, 0.1327D-04,
     >    0.1200D-04, 0.1027D-04, 0.8253D-05, 0.6219D-05, 0.4407D-05,
     >    0.2958D-05, 0.1904D-05, 0.1191D-05, 0.7338D-06, 0.4501D-06,
     >    0.2775D-06, 0.1728D-06, 0.1090D-06, 0.6971D-07, 0.4516D-07,
     >    0.2959D-07/

      data (calcpts(j,47), j = 1,neta) /0.6257D-27, 0.1967D-26,
     >    0.7812D-26, 0.2892D-25, 0.1132D-24, 0.4352D-24, 0.1650D-23,
     >    0.6303D-23, 0.2431D-22, 0.9296D-22, 0.3559D-21, 0.1364D-20,
     >    0.5231D-20, 0.2004D-19, 0.7675D-19, 0.2940D-18, 0.1126D-17,
     >    0.4311D-17, 0.1650D-16, 0.6316D-16, 0.2415D-15, 0.9231D-15,
     >    0.3524D-14, 0.1342D-13, 0.5101D-13, 0.1930D-12, 0.7269D-12,
     >    0.2715D-11, 0.1002D-10, 0.3638D-10, 0.1290D-09, 0.4430D-09,
     >    0.1456D-08, 0.4506D-08, 0.1300D-07, 0.3435D-07, 0.8220D-07,
     >    0.1770D-06, 0.3428D-06, 0.6008D-06, 0.9632D-06, 0.1430D-05,
     >    0.1992D-05, 0.2634D-05, 0.3337D-05, 0.4088D-05, 0.4869D-05,
     >    0.5667D-05, 0.6470D-05, 0.7263D-05, 0.8031D-05, 0.8751D-05,
     >    0.9393D-05, 0.9915D-05, 0.1026D-04, 0.1037D-04, 0.1016D-04,
     >    0.9585D-05, 0.8626D-05, 0.7344D-05, 0.5877D-05, 0.4409D-05,
     >    0.3110D-05, 0.2079D-05, 0.1332D-05, 0.8301D-06, 0.5094D-06,
     >    0.3114D-06, 0.1912D-06, 0.1188D-06, 0.7476D-07, 0.4773D-07,
     >    0.3089D-07/

      data (calcpts(j,48), j = 1,neta) /0.1929D-27, 0.1065D-26,
     >    0.5550D-26, 0.2037D-25, 0.7890D-25, 0.2965D-24, 0.1121D-23,
     >    0.4320D-23, 0.1657D-22, 0.6348D-22, 0.2428D-21, 0.9311D-21,
     >    0.3563D-20, 0.1364D-19, 0.5229D-19, 0.2003D-18, 0.7671D-18,
     >    0.2937D-17, 0.1124D-16, 0.4303D-16, 0.1646D-15, 0.6290D-15,
     >    0.2400D-14, 0.9146D-14, 0.3475D-13, 0.1316D-12, 0.4952D-12,
     >    0.1850D-11, 0.6827D-11, 0.2478D-10, 0.8790D-10, 0.3018D-09,
     >    0.9918D-09, 0.3071D-08, 0.8855D-08, 0.2340D-07, 0.5601D-07,
     >    0.1206D-06, 0.2335D-06, 0.4093D-06, 0.6563D-06, 0.9747D-06,
     >    0.1358D-05, 0.1796D-05, 0.2276D-05, 0.2789D-05, 0.3322D-05,
     >    0.3870D-05, 0.4424D-05, 0.4977D-05, 0.5518D-05, 0.6041D-05,
     >    0.6524D-05, 0.6949D-05, 0.7287D-05, 0.7499D-05, 0.7535D-05,
     >    0.7349D-05, 0.6900D-05, 0.6183D-05, 0.5241D-05, 0.4176D-05,
     >    0.3120D-05, 0.2192D-05, 0.1459D-05, 0.9318D-06, 0.5783D-06,
     >    0.3536D-06, 0.2154D-06, 0.1319D-06, 0.8168D-07, 0.5130D-07,
     >    0.3269D-07/

      data (calcpts(j,49), j = 1,neta) /0.1342D-27, 0.7954D-27,
     >    0.3825D-26, 0.1374D-25, 0.5324D-25, 0.2004D-24, 0.7458D-24,
     >    0.2908D-23, 0.1111D-22, 0.4303D-22, 0.1656D-21, 0.6326D-21,
     >    0.2435D-20, 0.9320D-20, 0.3557D-19, 0.1364D-18, 0.5224D-18,
     >    0.2001D-17, 0.7657D-17, 0.2933D-16, 0.1121D-15, 0.4284D-15,
     >    0.1635D-14, 0.6231D-14, 0.2367D-13, 0.8962D-13, 0.3373D-12,
     >    0.1260D-11, 0.4650D-11, 0.1689D-10, 0.5988D-10, 0.2057D-09,
     >    0.6758D-09, 0.2094D-08, 0.6033D-08, 0.1595D-07, 0.3816D-07,
     >    0.8215D-07, 0.1592D-06, 0.2789D-06, 0.4472D-06, 0.6641D-06,
     >    0.9252D-06, 0.1224D-05, 0.1551D-05, 0.1901D-05, 0.2267D-05,
     >    0.2642D-05, 0.3023D-05, 0.3403D-05, 0.3783D-05, 0.4152D-05,
     >    0.4505D-05, 0.4829D-05, 0.5111D-05, 0.5328D-05, 0.5454D-05,
     >    0.5454D-05, 0.5297D-05, 0.4953D-05, 0.4421D-05, 0.3732D-05,
     >    0.2963D-05, 0.2205D-05, 0.1544D-05, 0.1024D-05, 0.6512D-06,
     >    0.4026D-06, 0.2453D-06, 0.1489D-06, 0.9093D-07, 0.5616D-07,
     >    0.3519D-07/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsclql = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end 

      subroutine sclqt_CT(eta, xi, xsclqt)
cmarco the subtracted term from eq (28) of PLB347 (1995) 143 - 151
c   transverse light quark initiated piece
c   prop. to e_l^2
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      real*8 calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      real*8 eta, xi, dleta, dlxi, xsclqt
      real*8 pxi, peta, f(-1:1), delxi, deleta
      integer ieta, ixi, j
      data (calcpts(j, 1), j = 1,neta) /0.2418D-16, 0.9248D-16,
     >    0.3534D-15, 0.1349D-14, 0.5144D-14, 0.1956D-13, 0.7412D-13,
     >    0.2795D-12, 0.1046D-11, 0.3876D-11, 0.1417D-10, 0.5081D-10,
     >    0.1778D-09, 0.6021D-09, 0.1964D-08, 0.6116D-08, 0.1817D-07,
     >    0.5128D-07, 0.1377D-06, 0.3524D-06, 0.8631D-06, 0.2031D-05,
     >    0.4617D-05, 0.1017D-04, 0.2177D-04, 0.4545D-04, 0.9263D-04,
     >    0.1844D-03, 0.3577D-03, 0.6750D-03, 0.1232D-02, 0.2160D-02,
     >    0.3605D-02, 0.5666D-02, 0.8313D-02, 0.1131D-01, 0.1428D-01,
     >    0.1683D-01, 0.1868D-01, 0.1970D-01, 0.1988D-01, 0.1925D-01,
     >    0.1794D-01, 0.1616D-01, 0.1410D-01, 0.1198D-01, 0.9952D-02,
     >    0.8106D-02, 0.6494D-02, 0.5132D-02, 0.4007D-02, 0.3097D-02,
     >    0.2373D-02, 0.1806D-02, 0.1364D-02, 0.1025D-02, 0.7660D-03,
     >    0.5700D-03, 0.4222D-03, 0.3117D-03, 0.2294D-03, 0.1682D-03,
     >    0.1230D-03, 0.8970D-04, 0.6527D-04, 0.4739D-04, 0.3434D-04,
     >    0.2483D-04, 0.1791D-04, 0.1291D-04, 0.9285D-05, 0.6669D-05,
     >    0.4784D-05/

      data (calcpts(j, 2), j = 1,neta) /0.1123D-16, 0.4299D-16,
     >    0.1644D-15, 0.6287D-15, 0.2400D-14, 0.9147D-14, 0.3479D-13,
     >    0.1318D-12, 0.4970D-12, 0.1860D-11, 0.6894D-11, 0.2520D-10,
     >    0.9034D-10, 0.3161D-09, 0.1071D-08, 0.3488D-08, 0.1087D-07,
     >    0.3229D-07, 0.9114D-07, 0.2447D-06, 0.6258D-06, 0.1532D-05,
     >    0.3602D-05, 0.8169D-05, 0.1794D-04, 0.3830D-04, 0.7952D-04,
     >    0.1608D-03, 0.3164D-03, 0.6040D-03, 0.1114D-02, 0.1971D-02,
     >    0.3317D-02, 0.5253D-02, 0.7759D-02, 0.1063D-01, 0.1349D-01,
     >    0.1597D-01, 0.1781D-01, 0.1886D-01, 0.1908D-01, 0.1852D-01,
     >    0.1731D-01, 0.1561D-01, 0.1366D-01, 0.1163D-01, 0.9669D-02,
     >    0.7886D-02, 0.6324D-02, 0.5003D-02, 0.3910D-02, 0.3025D-02,
     >    0.2321D-02, 0.1767D-02, 0.1336D-02, 0.1004D-02, 0.7509D-03,
     >    0.5590D-03, 0.4145D-03, 0.3060D-03, 0.2253D-03, 0.1653D-03,
     >    0.1209D-03, 0.8825D-04, 0.6423D-04, 0.4665D-04, 0.3381D-04,
     >    0.2445D-04, 0.1765D-04, 0.1272D-04, 0.9156D-05, 0.6579D-05,
     >    0.4719D-05/

      data (calcpts(j, 3), j = 1,neta) /0.5218D-17, 0.1998D-16,
     >    0.7647D-16, 0.2925D-15, 0.1118D-14, 0.4268D-14, 0.1626D-13,
     >    0.6185D-13, 0.2343D-12, 0.8836D-12, 0.3308D-11, 0.1226D-10,
     >    0.4481D-10, 0.1607D-09, 0.5619D-09, 0.1904D-08, 0.6199D-08,
     >    0.1932D-07, 0.5739D-07, 0.1619D-06, 0.4344D-06, 0.1110D-05,
     >    0.2715D-05, 0.6374D-05, 0.1442D-04, 0.3158D-04, 0.6700D-04,
     >    0.1381D-03, 0.2762D-03, 0.5346D-03, 0.9981D-03, 0.1785D-02,
     >    0.3032D-02, 0.4842D-02, 0.7208D-02, 0.9939D-02, 0.1270D-01,
     >    0.1512D-01, 0.1694D-01, 0.1800D-01, 0.1828D-01, 0.1781D-01,
     >    0.1668D-01, 0.1509D-01, 0.1322D-01, 0.1127D-01, 0.9386D-02,
     >    0.7664D-02, 0.6155D-02, 0.4874D-02, 0.3813D-02, 0.2953D-02,
     >    0.2267D-02, 0.1726D-02, 0.1307D-02, 0.9832D-03, 0.7359D-03,
     >    0.5481D-03, 0.4065D-03, 0.3005D-03, 0.2212D-03, 0.1624D-03,
     >    0.1189D-03, 0.8678D-04, 0.6320D-04, 0.4592D-04, 0.3329D-04,
     >    0.2409D-04, 0.1740D-04, 0.1254D-04, 0.9027D-05, 0.6488D-05,
     >    0.4656D-05/

      data (calcpts(j, 4), j = 1,neta) /0.2424D-17, 0.9281D-17,
     >    0.3554D-16, 0.1360D-15, 0.5202D-15, 0.1988D-14, 0.7590D-14,
     >    0.2893D-13, 0.1100D-12, 0.4168D-12, 0.1572D-11, 0.5883D-11,
     >    0.2180D-10, 0.7967D-10, 0.2858D-09, 0.9992D-09, 0.3381D-08,
     >    0.1102D-07, 0.3435D-07, 0.1020D-06, 0.2876D-06, 0.7709D-06,
     >    0.1968D-05, 0.4806D-05, 0.1125D-04, 0.2538D-04, 0.5526D-04,
     >    0.1164D-03, 0.2373D-03, 0.4670D-03, 0.8841D-03, 0.1601D-02,
     >    0.2748D-02, 0.4434D-02, 0.6657D-02, 0.9254D-02, 0.1191D-01,
     >    0.1426D-01, 0.1607D-01, 0.1716D-01, 0.1749D-01, 0.1710D-01,
     >    0.1605D-01, 0.1455D-01, 0.1278D-01, 0.1091D-01, 0.9102D-02,
     >    0.7443D-02, 0.5985D-02, 0.4745D-02, 0.3717D-02, 0.2881D-02,
     >    0.2214D-02, 0.1688D-02, 0.1278D-02, 0.9624D-03, 0.7208D-03,
     >    0.5372D-03, 0.3987D-03, 0.2948D-03, 0.2172D-03, 0.1595D-03,
     >    0.1168D-03, 0.8532D-04, 0.6216D-04, 0.4518D-04, 0.3276D-04,
     >    0.2371D-04, 0.1713D-04, 0.1236D-04, 0.8898D-05, 0.6398D-05,
     >    0.4592D-05/

      data (calcpts(j, 5), j = 1,neta) /0.1125D-17, 0.4310D-17,
     >    0.1650D-16, 0.6320D-16, 0.2418D-15, 0.9251D-15, 0.3535D-14,
     >    0.1350D-13, 0.5145D-13, 0.1956D-12, 0.7412D-12, 0.2795D-11,
     >    0.1046D-10, 0.3878D-10, 0.1417D-09, 0.5081D-09, 0.1776D-08,
     >    0.6011D-08, 0.1959D-07, 0.6104D-07, 0.1810D-06, 0.5103D-06,
     >    0.1367D-05, 0.3486D-05, 0.8489D-05, 0.1981D-04, 0.4444D-04,
     >    0.9606D-04, 0.2001D-03, 0.4016D-03, 0.7731D-03, 0.1420D-02,
     >    0.2469D-02, 0.4028D-02, 0.6110D-02, 0.8570D-02, 0.1111D-01,
     >    0.1341D-01, 0.1520D-01, 0.1631D-01, 0.1670D-01, 0.1638D-01,
     >    0.1544D-01, 0.1402D-01, 0.1233D-01, 0.1055D-01, 0.8818D-02,
     >    0.7222D-02, 0.5816D-02, 0.4617D-02, 0.3619D-02, 0.2809D-02,
     >    0.2160D-02, 0.1649D-02, 0.1250D-02, 0.9416D-03, 0.7056D-03,
     >    0.5263D-03, 0.3909D-03, 0.2892D-03, 0.2132D-03, 0.1566D-03,
     >    0.1148D-03, 0.8385D-04, 0.6111D-04, 0.4444D-04, 0.3225D-04,
     >    0.2336D-04, 0.1688D-04, 0.1217D-04, 0.8769D-05, 0.6306D-05,
     >    0.4528D-05/

      data (calcpts(j, 6), j = 1,neta) /0.5224D-18, 0.2001D-17,
     >    0.7665D-17, 0.2936D-16, 0.1124D-15, 0.4301D-15, 0.1646D-14,
     >    0.6288D-14, 0.2400D-13, 0.9149D-13, 0.3479D-12, 0.1318D-11,
     >    0.4969D-11, 0.1860D-10, 0.6894D-10, 0.2519D-09, 0.9032D-09,
     >    0.3154D-08, 0.1068D-07, 0.3480D-07, 0.1084D-06, 0.3215D-06,
     >    0.9049D-06, 0.2420D-05, 0.6157D-05, 0.1495D-04, 0.3471D-04,
     >    0.7731D-04, 0.1653D-03, 0.3392D-03, 0.6657D-03, 0.1244D-02,
     >    0.2195D-02, 0.3627D-02, 0.5567D-02, 0.7890D-02, 0.1033D-01,
     >    0.1256D-01, 0.1432D-01, 0.1546D-01, 0.1592D-01, 0.1566D-01,
     >    0.1480D-01, 0.1348D-01, 0.1189D-01, 0.1020D-01, 0.8535D-02,
     >    0.7002D-02, 0.5646D-02, 0.4488D-02, 0.3524D-02, 0.2738D-02,
     >    0.2108D-02, 0.1610D-02, 0.1221D-02, 0.9207D-03, 0.6905D-03,
     >    0.5154D-03, 0.3830D-03, 0.2835D-03, 0.2091D-03, 0.1537D-03,
     >    0.1127D-03, 0.8240D-04, 0.6008D-04, 0.4371D-04, 0.3172D-04,
     >    0.2298D-04, 0.1662D-04, 0.1199D-04, 0.8640D-05, 0.6216D-05,
     >    0.4464D-05/

      data (calcpts(j, 7), j = 1,neta) /0.2426D-18, 0.9293D-18,
     >    0.3560D-17, 0.1363D-16, 0.5220D-16, 0.1998D-15, 0.7649D-15,
     >    0.2925D-14, 0.1118D-13, 0.4269D-13, 0.1628D-12, 0.6186D-12,
     >    0.2344D-11, 0.8837D-11, 0.3308D-10, 0.1226D-09, 0.4479D-09,
     >    0.1605D-08, 0.5606D-08, 0.1898D-07, 0.6182D-07, 0.1925D-06,
     >    0.5700D-06, 0.1602D-05, 0.4277D-05, 0.1085D-04, 0.2621D-04,
     >    0.6041D-04, 0.1331D-03, 0.2804D-03, 0.5631D-03, 0.1073D-02,
     >    0.1928D-02, 0.3234D-02, 0.5030D-02, 0.7214D-02, 0.9542D-02,
     >    0.1171D-01, 0.1346D-01, 0.1462D-01, 0.1512D-01, 0.1494D-01,
     >    0.1417D-01, 0.1295D-01, 0.1145D-01, 0.9839D-02, 0.8252D-02,
     >    0.6782D-02, 0.5476D-02, 0.4359D-02, 0.3428D-02, 0.2665D-02,
     >    0.2054D-02, 0.1571D-02, 0.1193D-02, 0.8998D-03, 0.6755D-03,
     >    0.5045D-03, 0.3752D-03, 0.2780D-03, 0.2050D-03, 0.1509D-03,
     >    0.1107D-03, 0.8093D-04, 0.5904D-04, 0.4298D-04, 0.3120D-04,
     >    0.2261D-04, 0.1635D-04, 0.1181D-04, 0.8511D-05, 0.6124D-05,
     >    0.4401D-05/

      data (calcpts(j, 8), j = 1,neta) /0.1126D-18, 0.4314D-18,
     >    0.1653D-17, 0.6330D-17, 0.2424D-16, 0.9284D-16, 0.3554D-15,
     >    0.1360D-14, 0.5202D-14, 0.1989D-13, 0.7591D-13, 0.2894D-12,
     >    0.1100D-11, 0.4169D-11, 0.1572D-10, 0.5882D-10, 0.2180D-09,
     >    0.7962D-09, 0.2850D-08, 0.9960D-08, 0.3371D-07, 0.1097D-06,
     >    0.3413D-06, 0.1010D-05, 0.2832D-05, 0.7536D-05, 0.1902D-04,
     >    0.4563D-04, 0.1041D-03, 0.2262D-03, 0.4664D-03, 0.9094D-03,
     >    0.1667D-02, 0.2847D-02, 0.4498D-02, 0.6543D-02, 0.8759D-02,
     >    0.1086D-01, 0.1259D-01, 0.1378D-01, 0.1432D-01, 0.1422D-01,
     >    0.1354D-01, 0.1241D-01, 0.1101D-01, 0.9482D-02, 0.7970D-02,
     >    0.6561D-02, 0.5307D-02, 0.4230D-02, 0.3330D-02, 0.2594D-02,
     >    0.2001D-02, 0.1532D-02, 0.1164D-02, 0.8790D-03, 0.6603D-03,
     >    0.4935D-03, 0.3674D-03, 0.2723D-03, 0.2010D-03, 0.1480D-03,
     >    0.1086D-03, 0.7947D-04, 0.5801D-04, 0.4224D-04, 0.3068D-04,
     >    0.2224D-04, 0.1610D-04, 0.1163D-04, 0.8382D-05, 0.6033D-05,
     >    0.4337D-05/

      data (calcpts(j, 9), j = 1,neta) /0.5227D-19, 0.2003D-18,
     >    0.7671D-18, 0.2938D-17, 0.1126D-16, 0.4311D-16, 0.1652D-15,
     >    0.6321D-15, 0.2419D-14, 0.9252D-14, 0.3537D-13, 0.1350D-12,
     >    0.5145D-12, 0.1956D-11, 0.7413D-11, 0.2794D-10, 0.1046D-09,
     >    0.3874D-09, 0.1415D-08, 0.5064D-08, 0.1770D-07, 0.5985D-07,
     >    0.1946D-06, 0.6045D-06, 0.1785D-05, 0.4993D-05, 0.1322D-04,
     >    0.3315D-04, 0.7875D-04, 0.1771D-03, 0.3768D-03, 0.7551D-03,
     >    0.1417D-02, 0.2472D-02, 0.3978D-02, 0.5880D-02, 0.7983D-02,
     >    0.1002D-01, 0.1173D-01, 0.1293D-01, 0.1353D-01, 0.1351D-01,
     >    0.1291D-01, 0.1188D-01, 0.1056D-01, 0.9123D-02, 0.7686D-02,
     >    0.6340D-02, 0.5138D-02, 0.4103D-02, 0.3234D-02, 0.2522D-02,
     >    0.1947D-02, 0.1492D-02, 0.1135D-02, 0.8582D-03, 0.6452D-03,
     >    0.4827D-03, 0.3594D-03, 0.2666D-03, 0.1969D-03, 0.1451D-03,
     >    0.1065D-03, 0.7800D-04, 0.5697D-04, 0.4149D-04, 0.3017D-04,
     >    0.2187D-04, 0.1584D-04, 0.1144D-04, 0.8253D-05, 0.5943D-05,
     >    0.4273D-05/

      data (calcpts(j,10), j = 1,neta) /0.2427D-19, 0.9297D-19,
     >    0.3561D-18, 0.1364D-17, 0.5227D-17, 0.2003D-16, 0.7668D-16,
     >    0.2937D-15, 0.1124D-14, 0.4302D-14, 0.1646D-13, 0.6290D-13,
     >    0.2401D-12, 0.9151D-12, 0.3479D-11, 0.1318D-10, 0.4970D-10,
     >    0.1860D-09, 0.6888D-09, 0.2511D-08, 0.8997D-08, 0.3141D-07,
     >    0.1062D-06, 0.3449D-06, 0.1069D-05, 0.3147D-05, 0.8768D-05,
     >    0.2307D-04, 0.5728D-04, 0.1342D-03, 0.2958D-03, 0.6119D-03,
     >    0.1181D-02, 0.2110D-02, 0.3471D-02, 0.5228D-02, 0.7215D-02,
     >    0.9179D-02, 0.1087D-01, 0.1209D-01, 0.1275D-01, 0.1279D-01,
     >    0.1229D-01, 0.1135D-01, 0.1012D-01, 0.8766D-02, 0.7403D-02,
     >    0.6120D-02, 0.4968D-02, 0.3974D-02, 0.3136D-02, 0.2449D-02,
     >    0.1895D-02, 0.1453D-02, 0.1107D-02, 0.8375D-03, 0.6302D-03,
     >    0.4718D-03, 0.3516D-03, 0.2610D-03, 0.1931D-03, 0.1422D-03,
     >    0.1045D-03, 0.7655D-04, 0.5592D-04, 0.4075D-04, 0.2964D-04,
     >    0.2151D-04, 0.1557D-04, 0.1126D-04, 0.8124D-05, 0.5852D-05,
     >    0.4209D-05/

      data (calcpts(j,11), j = 1,neta) /0.1127D-19, 0.4317D-19,
     >    0.1653D-18, 0.6334D-18, 0.2427D-17, 0.9297D-17, 0.3561D-16,
     >    0.1364D-15, 0.5223D-15, 0.2000D-14, 0.7653D-14, 0.2927D-13,
     >    0.1119D-12, 0.4270D-12, 0.1627D-11, 0.6187D-11, 0.2344D-10,
     >    0.8835D-10, 0.3306D-09, 0.1224D-08, 0.4463D-08, 0.1597D-07,
     >    0.5574D-07, 0.1881D-06, 0.6101D-06, 0.1885D-05, 0.5529D-05,
     >    0.1531D-04, 0.3992D-04, 0.9777D-04, 0.2246D-03, 0.4818D-03,
     >    0.9605D-03, 0.1767D-02, 0.2981D-02, 0.4590D-02, 0.6457D-02,
     >    0.8346D-02, 0.1001D-01, 0.1125D-01, 0.1196D-01, 0.1208D-01,
     >    0.1166D-01, 0.1081D-01, 0.9681D-02, 0.8409D-02, 0.7119D-02,
     >    0.5898D-02, 0.4799D-02, 0.3844D-02, 0.3040D-02, 0.2378D-02,
     >    0.1841D-02, 0.1414D-02, 0.1078D-02, 0.8166D-03, 0.6150D-03,
     >    0.4608D-03, 0.3438D-03, 0.2553D-03, 0.1890D-03, 0.1393D-03,
     >    0.1024D-03, 0.7509D-04, 0.5489D-04, 0.4002D-04, 0.2911D-04,
     >    0.2114D-04, 0.1531D-04, 0.1108D-04, 0.7995D-05, 0.5762D-05,
     >    0.4146D-05/

      data (calcpts(j,12), j = 1,neta) /0.5232D-20, 0.2004D-19,
     >    0.7680D-19, 0.2941D-18, 0.1127D-17, 0.4318D-17, 0.1654D-16,
     >    0.6336D-16, 0.2427D-15, 0.9293D-15, 0.3558D-14, 0.1361D-13,
     >    0.5208D-13, 0.1991D-12, 0.7597D-12, 0.2895D-11, 0.1101D-10,
     >    0.4170D-10, 0.1571D-09, 0.5877D-09, 0.2175D-08, 0.7928D-08,
     >    0.2835D-07, 0.9882D-07, 0.3330D-06, 0.1077D-05, 0.3317D-05,
     >    0.9666D-05, 0.2652D-04, 0.6827D-04, 0.1641D-03, 0.3672D-03,
     >    0.7601D-03, 0.1446D-02, 0.2514D-02, 0.3972D-02, 0.5714D-02,
     >    0.7524D-02, 0.9161D-02, 0.1042D-01, 0.1117D-01, 0.1137D-01,
     >    0.1104D-01, 0.1028D-01, 0.9240D-02, 0.8052D-02, 0.6837D-02,
     >    0.5678D-02, 0.4629D-02, 0.3716D-02, 0.2943D-02, 0.2306D-02,
     >    0.1788D-02, 0.1375D-02, 0.1049D-02, 0.7957D-03, 0.5998D-03,
     >    0.4500D-03, 0.3359D-03, 0.2498D-03, 0.1850D-03, 0.1365D-03,
     >    0.1004D-03, 0.7362D-04, 0.5385D-04, 0.3929D-04, 0.2861D-04,
     >    0.2078D-04, 0.1506D-04, 0.1089D-04, 0.7866D-05, 0.5670D-05,
     >    0.4082D-05/

      data (calcpts(j,13), j = 1,neta) /0.2432D-20, 0.9314D-20,
     >    0.3569D-19, 0.1367D-18, 0.5238D-18, 0.2007D-17, 0.7688D-17,
     >    0.2945D-16, 0.1128D-15, 0.4320D-15, 0.1654D-14, 0.6333D-14,
     >    0.2424D-13, 0.9270D-13, 0.3543D-12, 0.1352D-11, 0.5153D-11,
     >    0.1959D-10, 0.7419D-10, 0.2795D-09, 0.1045D-08, 0.3861D-08,
     >    0.1408D-07, 0.5031D-07, 0.1750D-06, 0.5883D-06, 0.1896D-05,
     >    0.5805D-05, 0.1678D-04, 0.4548D-04, 0.1150D-03, 0.2696D-03,
     >    0.5826D-03, 0.1153D-02, 0.2075D-02, 0.3379D-02, 0.4991D-02,
     >    0.6716D-02, 0.8320D-02, 0.9593D-02, 0.1039D-01, 0.1066D-01,
     >    0.1041D-01, 0.9750D-02, 0.8799D-02, 0.7695D-02, 0.6554D-02,
     >    0.5457D-02, 0.4459D-02, 0.3588D-02, 0.2847D-02, 0.2234D-02,
     >    0.1734D-02, 0.1336D-02, 0.1021D-02, 0.7749D-03, 0.5849D-03,
     >    0.4391D-03, 0.3281D-03, 0.2441D-03, 0.1809D-03, 0.1336D-03,
     >    0.9832D-04, 0.7217D-04, 0.5282D-04, 0.3855D-04, 0.2808D-04,
     >    0.2040D-04, 0.1480D-04, 0.1071D-04, 0.7737D-05, 0.5580D-05,
     >    0.4019D-05/

      data (calcpts(j,14), j = 1,neta) /0.1131D-20, 0.4332D-20,
     >    0.1661D-19, 0.6360D-19, 0.2436D-18, 0.9334D-18, 0.3576D-17,
     >    0.1370D-16, 0.5248D-16, 0.2010D-15, 0.7700D-15, 0.2948D-14,
     >    0.1129D-13, 0.4318D-13, 0.1652D-12, 0.6312D-12, 0.2409D-11,
     >    0.9181D-11, 0.3489D-10, 0.1321D-09, 0.4977D-09, 0.1860D-08,
     >    0.6866D-08, 0.2501D-07, 0.8922D-07, 0.3097D-06, 0.1037D-05,
     >    0.3326D-05, 0.1010D-04, 0.2886D-04, 0.7695D-04, 0.1899D-03,
     >    0.4307D-03, 0.8910D-03, 0.1670D-02, 0.2820D-02, 0.4293D-02,
     >    0.5926D-02, 0.7491D-02, 0.8774D-02, 0.9617D-02, 0.9952D-02,
     >    0.9792D-02, 0.9219D-02, 0.8360D-02, 0.7339D-02, 0.6272D-02,
     >    0.5238D-02, 0.4292D-02, 0.3459D-02, 0.2751D-02, 0.2162D-02,
     >    0.1682D-02, 0.1296D-02, 0.9921D-03, 0.7541D-03, 0.5697D-03,
     >    0.4281D-03, 0.3203D-03, 0.2384D-03, 0.1769D-03, 0.1307D-03,
     >    0.9627D-04, 0.7069D-04, 0.5178D-04, 0.3781D-04, 0.2755D-04,
     >    0.2004D-04, 0.1454D-04, 0.1053D-04, 0.7608D-05, 0.5489D-05,
     >    0.3954D-05/

      data (calcpts(j,15), j = 1,neta) /0.5274D-21, 0.2020D-20,
     >    0.7740D-20, 0.2965D-19, 0.1136D-18, 0.4353D-18, 0.1668D-17,
     >    0.6389D-17, 0.2448D-16, 0.9377D-16, 0.3591D-15, 0.1376D-14,
     >    0.5267D-14, 0.2016D-13, 0.7716D-13, 0.2951D-12, 0.1128D-11,
     >    0.4303D-11, 0.1640D-10, 0.6230D-10, 0.2358D-09, 0.8878D-09,
     >    0.3311D-08, 0.1223D-07, 0.4447D-07, 0.1583D-06, 0.5478D-06,
     >    0.1825D-05, 0.5810D-05, 0.1746D-04, 0.4913D-04, 0.1280D-03,
     >    0.3062D-03, 0.6659D-03, 0.1307D-02, 0.2299D-02, 0.3630D-02,
     >    0.5162D-02, 0.6679D-02, 0.7965D-02, 0.8849D-02, 0.9251D-02,
     >    0.9173D-02, 0.8691D-02, 0.7920D-02, 0.6984D-02, 0.5990D-02,
     >    0.5018D-02, 0.4122D-02, 0.3330D-02, 0.2654D-02, 0.2090D-02,
     >    0.1628D-02, 0.1257D-02, 0.9634D-03, 0.7332D-03, 0.5546D-03,
     >    0.4172D-03, 0.3123D-03, 0.2328D-03, 0.1728D-03, 0.1278D-03,
     >    0.9422D-04, 0.6924D-04, 0.5073D-04, 0.3708D-04, 0.2703D-04,
     >    0.1967D-04, 0.1428D-04, 0.1034D-04, 0.7479D-05, 0.5399D-05,
     >    0.3889D-05/

      data (calcpts(j,16), j = 1,neta) /0.2473D-21, 0.9471D-21,
     >    0.3629D-20, 0.1390D-19, 0.5327D-19, 0.2040D-18, 0.7818D-18,
     >    0.2995D-17, 0.1148D-16, 0.4397D-16, 0.1685D-15, 0.6450D-15,
     >    0.2471D-14, 0.9459D-14, 0.3621D-13, 0.1386D-12, 0.5300D-12,
     >    0.2025D-11, 0.7727D-11, 0.2943D-10, 0.1118D-09, 0.4230D-09,
     >    0.1591D-08, 0.5928D-08, 0.2187D-07, 0.7937D-07, 0.2817D-06,
     >    0.9701D-06, 0.3212D-05, 0.1012D-04, 0.2997D-04, 0.8255D-04,
     >    0.2088D-03, 0.4799D-03, 0.9918D-03, 0.1830D-02, 0.3011D-02,
     >    0.4431D-02, 0.5892D-02, 0.7172D-02, 0.8091D-02, 0.8556D-02,
     >    0.8559D-02, 0.8166D-02, 0.7484D-02, 0.6629D-02, 0.5708D-02,
     >    0.4797D-02, 0.3953D-02, 0.3202D-02, 0.2558D-02, 0.2018D-02,
     >    0.1575D-02, 0.1218D-02, 0.9348D-03, 0.7124D-03, 0.5396D-03,
     >    0.4063D-03, 0.3045D-03, 0.2271D-03, 0.1688D-03, 0.1249D-03,
     >    0.9216D-04, 0.6777D-04, 0.4969D-04, 0.3635D-04, 0.2652D-04,
     >    0.1931D-04, 0.1402D-04, 0.1016D-04, 0.7350D-05, 0.5307D-05,
     >    0.3826D-05/

      data (calcpts(j,17), j = 1,neta) /0.1173D-21, 0.4490D-21,
     >    0.1721D-20, 0.6589D-20, 0.2525D-19, 0.9674D-19, 0.3706D-18,
     >    0.1420D-17, 0.5441D-17, 0.2084D-16, 0.7985D-16, 0.3059D-15,
     >    0.1172D-14, 0.4486D-14, 0.1718D-13, 0.6576D-13, 0.2515D-12,
     >    0.9621D-12, 0.3677D-11, 0.1403D-10, 0.5340D-10, 0.2028D-09,
     >    0.7668D-09, 0.2877D-08, 0.1072D-07, 0.3948D-07, 0.1429D-06,
     >    0.5049D-06, 0.1728D-05, 0.5670D-05, 0.1761D-04, 0.5118D-04,
     >    0.1370D-03, 0.3338D-03, 0.7298D-03, 0.1420D-02, 0.2446D-02,
     >    0.3744D-02, 0.5136D-02, 0.6400D-02, 0.7347D-02, 0.7871D-02,
     >    0.7950D-02, 0.7644D-02, 0.7049D-02, 0.6275D-02, 0.5426D-02,
     >    0.4578D-02, 0.3783D-02, 0.3074D-02, 0.2460D-02, 0.1946D-02,
     >    0.1521D-02, 0.1179D-02, 0.9061D-03, 0.6915D-03, 0.5244D-03,
     >    0.3954D-03, 0.2965D-03, 0.2215D-03, 0.1647D-03, 0.1220D-03,
     >    0.9011D-04, 0.6632D-04, 0.4866D-04, 0.3561D-04, 0.2600D-04,
     >    0.1893D-04, 0.1376D-04, 0.9977D-05, 0.7221D-05, 0.5217D-05,
     >    0.3762D-05/

      data (calcpts(j,18), j = 1,neta) /0.5694D-22, 0.2178D-21,
     >    0.8340D-21, 0.3197D-20, 0.1224D-19, 0.4692D-19, 0.1797D-18,
     >    0.6886D-18, 0.2639D-17, 0.1011D-16, 0.3873D-16, 0.1484D-15,
     >    0.5682D-15, 0.2177D-14, 0.8335D-14, 0.3192D-13, 0.1222D-12,
     >    0.4674D-12, 0.1787D-11, 0.6827D-11, 0.2604D-10, 0.9911D-10,
     >    0.3760D-09, 0.1421D-08, 0.5325D-08, 0.1981D-07, 0.7272D-07,
     >    0.2622D-06, 0.9210D-06, 0.3125D-05, 0.1012D-04, 0.3086D-04,
     >    0.8726D-04, 0.2252D-03, 0.5222D-03, 0.1074D-02, 0.1948D-02,
     >    0.3114D-02, 0.4422D-02, 0.5658D-02, 0.6624D-02, 0.7197D-02,
     >    0.7350D-02, 0.7127D-02, 0.6615D-02, 0.5923D-02, 0.5145D-02,
     >    0.4359D-02, 0.3615D-02, 0.2946D-02, 0.2364D-02, 0.1873D-02,
     >    0.1468D-02, 0.1140D-02, 0.8775D-03, 0.6706D-03, 0.5093D-03,
     >    0.3844D-03, 0.2888D-03, 0.2159D-03, 0.1607D-03, 0.1192D-03,
     >    0.8805D-04, 0.6485D-04, 0.4762D-04, 0.3488D-04, 0.2547D-04,
     >    0.1857D-04, 0.1350D-04, 0.9792D-05, 0.7092D-05, 0.5126D-05,
     >    0.3699D-05/

      data (calcpts(j,19), j = 1,neta) /0.2892D-22, 0.1104D-21,
     >    0.4228D-21, 0.1620D-20, 0.6209D-20, 0.2379D-19, 0.9114D-19,
     >    0.3492D-18, 0.1338D-17, 0.5126D-17, 0.1964D-16, 0.7522D-16,
     >    0.2882D-15, 0.1104D-14, 0.4228D-14, 0.1618D-13, 0.6200D-13,
     >    0.2373D-12, 0.9077D-12, 0.3470D-11, 0.1325D-10, 0.5052D-10,
     >    0.1922D-09, 0.7287D-09, 0.2744D-08, 0.1028D-07, 0.3815D-07,
     >    0.1394D-06, 0.4995D-06, 0.1739D-05, 0.5822D-05, 0.1850D-04,
     >    0.5489D-04, 0.1494D-03, 0.3666D-03, 0.7981D-03, 0.1525D-02,
     >    0.2552D-02, 0.3762D-02, 0.4955D-02, 0.5926D-02, 0.6543D-02,
     >    0.6762D-02, 0.6616D-02, 0.6188D-02, 0.5574D-02, 0.4866D-02,
     >    0.4140D-02, 0.3447D-02, 0.2817D-02, 0.2268D-02, 0.1802D-02,
     >    0.1415D-02, 0.1101D-02, 0.8490D-03, 0.6498D-03, 0.4941D-03,
     >    0.3735D-03, 0.2810D-03, 0.2103D-03, 0.1566D-03, 0.1163D-03,
     >    0.8600D-04, 0.6339D-04, 0.4659D-04, 0.3414D-04, 0.2496D-04,
     >    0.1820D-04, 0.1324D-04, 0.9609D-05, 0.6963D-05, 0.5036D-05,
     >    0.3635D-05/

      data (calcpts(j,20), j = 1,neta) /0.1592D-22, 0.6060D-22,
     >    0.2321D-21, 0.8892D-21, 0.3408D-20, 0.1305D-19, 0.5001D-19,
     >    0.1916D-18, 0.7341D-18, 0.2813D-17, 0.1078D-16, 0.4128D-16,
     >    0.1581D-15, 0.6058D-15, 0.2321D-14, 0.8889D-14, 0.3404D-13,
     >    0.1303D-12, 0.4986D-12, 0.1907D-11, 0.7287D-11, 0.2781D-10,
     >    0.1060D-09, 0.4028D-09, 0.1524D-08, 0.5727D-08, 0.2139D-07,
     >    0.7892D-07, 0.2864D-06, 0.1015D-05, 0.3480D-05, 0.1140D-04,
     >    0.3512D-04, 0.9989D-04, 0.2573D-03, 0.5892D-03, 0.1183D-02,
     >    0.2070D-02, 0.3171D-02, 0.4304D-02, 0.5265D-02, 0.5913D-02,
     >    0.6189D-02, 0.6116D-02, 0.5766D-02, 0.5228D-02, 0.4590D-02,
     >    0.3923D-02, 0.3279D-02, 0.2690D-02, 0.2172D-02, 0.1729D-02,
     >    0.1362D-02, 0.1062D-02, 0.8204D-03, 0.6291D-03, 0.4791D-03,
     >    0.3627D-03, 0.2730D-03, 0.2046D-03, 0.1526D-03, 0.1134D-03,
     >    0.8394D-04, 0.6194D-04, 0.4556D-04, 0.3341D-04, 0.2443D-04,
     >    0.1782D-04, 0.1298D-04, 0.9426D-05, 0.6834D-05, 0.4944D-05,
     >    0.3572D-05/

      data (calcpts(j,21), j = 1,neta) /0.9878D-23, 0.3747D-22,
     >    0.1434D-21, 0.5498D-21, 0.2108D-20, 0.8071D-20, 0.3093D-19,
     >    0.1185D-18, 0.4539D-18, 0.1740D-17, 0.6663D-17, 0.2553D-16,
     >    0.9780D-16, 0.3747D-15, 0.1435D-14, 0.5498D-14, 0.2105D-13,
     >    0.8060D-13, 0.3086D-12, 0.1180D-11, 0.4512D-11, 0.1724D-10,
     >    0.6569D-10, 0.2499D-09, 0.9476D-09, 0.3569D-08, 0.1337D-07,
     >    0.4960D-07, 0.1814D-06, 0.6490D-06, 0.2256D-05, 0.7524D-05,
     >    0.2373D-04, 0.6951D-04, 0.1854D-03, 0.4410D-03, 0.9218D-03,
     >    0.1677D-02, 0.2660D-02, 0.3717D-02, 0.4652D-02, 0.5315D-02,
     >    0.5637D-02, 0.5630D-02, 0.5352D-02, 0.4886D-02, 0.4316D-02,
     >    0.3706D-02, 0.3113D-02, 0.2562D-02, 0.2076D-02, 0.1658D-02,
     >    0.1309D-02, 0.1023D-02, 0.7917D-03, 0.6083D-03, 0.4640D-03,
     >    0.3518D-03, 0.2652D-03, 0.1989D-03, 0.1486D-03, 0.1105D-03,
     >    0.8189D-04, 0.6046D-04, 0.4451D-04, 0.3267D-04, 0.2391D-04,
     >    0.1746D-04, 0.1272D-04, 0.9243D-05, 0.6705D-05, 0.4854D-05,
     >    0.3507D-05/

      data (calcpts(j,22), j = 1,neta) /0.7062D-23, 0.2674D-22,
     >    0.1023D-21, 0.3922D-21, 0.1503D-20, 0.5758D-20, 0.2206D-19,
     >    0.8454D-19, 0.3239D-18, 0.1241D-17, 0.4755D-17, 0.1821D-16,
     >    0.6978D-16, 0.2673D-15, 0.1024D-14, 0.3923D-14, 0.1501D-13,
     >    0.5751D-13, 0.2202D-12, 0.8422D-12, 0.3221D-11, 0.1230D-10,
     >    0.4690D-10, 0.1785D-09, 0.6773D-09, 0.2553D-08, 0.9576D-08,
     >    0.3558D-07, 0.1304D-06, 0.4683D-06, 0.1637D-05, 0.5496D-05,
     >    0.1751D-04, 0.5196D-04, 0.1410D-03, 0.3428D-03, 0.7349D-03,
     >    0.1374D-02, 0.2240D-02, 0.3207D-02, 0.4098D-02, 0.4761D-02,
     >    0.5115D-02, 0.5162D-02, 0.4949D-02, 0.4551D-02, 0.4044D-02,
     >    0.3494D-02, 0.2946D-02, 0.2436D-02, 0.1980D-02, 0.1587D-02,
     >    0.1256D-02, 0.9835D-03, 0.7632D-03, 0.5874D-03, 0.4490D-03,
     >    0.3408D-03, 0.2574D-03, 0.1933D-03, 0.1446D-03, 0.1076D-03,
     >    0.7983D-04, 0.5901D-04, 0.4347D-04, 0.3194D-04, 0.2339D-04,
     >    0.1708D-04, 0.1246D-04, 0.9060D-05, 0.6576D-05, 0.4763D-05,
     >    0.3444D-05/

      data (calcpts(j,23), j = 1,neta) /0.5736D-23, 0.2175D-22,
     >    0.8327D-22, 0.3192D-21, 0.1223D-20, 0.4686D-20, 0.1796D-19,
     >    0.6879D-19, 0.2635D-18, 0.1010D-17, 0.3869D-17, 0.1482D-16,
     >    0.5678D-16, 0.2175D-15, 0.8331D-15, 0.3191D-14, 0.1222D-13,
     >    0.4680D-13, 0.1791D-12, 0.6852D-12, 0.2620D-11, 0.1001D-10,
     >    0.3816D-10, 0.1452D-09, 0.5510D-09, 0.2081D-08, 0.7790D-08,
     >    0.2894D-07, 0.1060D-06, 0.3809D-06, 0.1330D-05, 0.4469D-05,
     >    0.1424D-04, 0.4233D-04, 0.1152D-03, 0.2819D-03, 0.6101D-03,
     >    0.1156D-02, 0.1914D-02, 0.2787D-02, 0.3618D-02, 0.4260D-02,
     >    0.4631D-02, 0.4718D-02, 0.4562D-02, 0.4226D-02, 0.3779D-02,
     >    0.3282D-02, 0.2781D-02, 0.2310D-02, 0.1884D-02, 0.1515D-02,
     >    0.1203D-02, 0.9446D-03, 0.7346D-03, 0.5665D-03, 0.4338D-03,
     >    0.3300D-03, 0.2495D-03, 0.1876D-03, 0.1405D-03, 0.1047D-03,
     >    0.7777D-04, 0.5754D-04, 0.4244D-04, 0.3120D-04, 0.2288D-04,
     >    0.1672D-04, 0.1220D-04, 0.8877D-05, 0.6446D-05, 0.4672D-05,
     >    0.3380D-05/

      data (calcpts(j,24), j = 1,neta) /0.5089D-23, 0.1944D-22,
     >    0.7445D-22, 0.2853D-21, 0.1093D-20, 0.4188D-20, 0.1605D-19,
     >    0.6147D-19, 0.2355D-18, 0.9023D-18, 0.3458D-17, 0.1325D-16,
     >    0.5074D-16, 0.1944D-15, 0.7446D-15, 0.2851D-14, 0.1092D-13,
     >    0.4182D-13, 0.1601D-12, 0.6123D-12, 0.2342D-11, 0.8940D-11,
     >    0.3409D-10, 0.1297D-09, 0.4920D-09, 0.1857D-08, 0.6951D-08,
     >    0.2581D-07, 0.9449D-07, 0.3390D-06, 0.1182D-05, 0.3962D-05,
     >    0.1259D-04, 0.3729D-04, 0.1011D-03, 0.2465D-03, 0.5325D-03,
     >    0.1010D-02, 0.1679D-02, 0.2462D-02, 0.3223D-02, 0.3828D-02,
     >    0.4196D-02, 0.4308D-02, 0.4196D-02, 0.3912D-02, 0.3521D-02,
     >    0.3075D-02, 0.2619D-02, 0.2184D-02, 0.1790D-02, 0.1444D-02,
     >    0.1150D-02, 0.9055D-03, 0.7061D-03, 0.5459D-03, 0.4188D-03,
     >    0.3191D-03, 0.2416D-03, 0.1821D-03, 0.1365D-03, 0.1019D-03,
     >    0.7572D-04, 0.5609D-04, 0.4140D-04, 0.3047D-04, 0.2235D-04,
     >    0.1635D-04, 0.1194D-04, 0.8694D-05, 0.6317D-05, 0.4581D-05,
     >    0.3317D-05/

      data (calcpts(j,25), j = 1,neta) /0.4752D-23, 0.1836D-22,
     >    0.7038D-22, 0.2695D-21, 0.1032D-20, 0.3957D-20, 0.1516D-19,
     >    0.5808D-19, 0.2225D-18, 0.8525D-18, 0.3266D-17, 0.1251D-16,
     >    0.4794D-16, 0.1836D-15, 0.7035D-15, 0.2694D-14, 0.1032D-13,
     >    0.3951D-13, 0.1512D-12, 0.5784D-12, 0.2211D-11, 0.8445D-11,
     >    0.3221D-10, 0.1225D-09, 0.4647D-09, 0.1753D-08, 0.6560D-08,
     >    0.2435D-07, 0.8906D-07, 0.3190D-06, 0.1111D-05, 0.3716D-05,
     >    0.1177D-04, 0.3473D-04, 0.9371D-04, 0.2271D-03, 0.4874D-03,
     >    0.9189D-03, 0.1521D-02, 0.2228D-02, 0.2918D-02, 0.3474D-02,
     >    0.3820D-02, 0.3941D-02, 0.3857D-02, 0.3616D-02, 0.3271D-02,
     >    0.2874D-02, 0.2460D-02, 0.2061D-02, 0.1697D-02, 0.1374D-02,
     >    0.1098D-02, 0.8669D-03, 0.6777D-03, 0.5250D-03, 0.4036D-03,
     >    0.3082D-03, 0.2339D-03, 0.1764D-03, 0.1325D-03, 0.9899D-04,
     >    0.7366D-04, 0.5461D-04, 0.4037D-04, 0.2973D-04, 0.2183D-04,
     >    0.1599D-04, 0.1168D-04, 0.8510D-05, 0.6187D-05, 0.4491D-05,
     >    0.3252D-05/

      data (calcpts(j,26), j = 1,neta) /0.4554D-23, 0.1785D-22,
     >    0.6852D-22, 0.2624D-21, 0.1004D-20, 0.3849D-20, 0.1475D-19,
     >    0.5651D-19, 0.2165D-18, 0.8293D-18, 0.3177D-17, 0.1217D-16,
     >    0.4664D-16, 0.1787D-15, 0.6843D-15, 0.2621D-14, 0.1004D-13,
     >    0.3843D-13, 0.1471D-12, 0.5628D-12, 0.2151D-11, 0.8216D-11,
     >    0.3132D-10, 0.1192D-09, 0.4520D-09, 0.1705D-08, 0.6378D-08,
     >    0.2366D-07, 0.8651D-07, 0.3097D-06, 0.1077D-05, 0.3598D-05,
     >    0.1137D-04, 0.3346D-04, 0.8996D-04, 0.2169D-03, 0.4628D-03,
     >    0.8664D-03, 0.1424D-02, 0.2072D-02, 0.2699D-02, 0.3202D-02,
     >    0.3516D-02, 0.3627D-02, 0.3555D-02, 0.3344D-02, 0.3038D-02,
     >    0.2681D-02, 0.2306D-02, 0.1941D-02, 0.1603D-02, 0.1304D-02,
     >    0.1045D-02, 0.8282D-03, 0.6494D-03, 0.5043D-03, 0.3887D-03,
     >    0.2973D-03, 0.2261D-03, 0.1709D-03, 0.1284D-03, 0.9611D-04,
     >    0.7161D-04, 0.5316D-04, 0.3932D-04, 0.2899D-04, 0.2132D-04,
     >    0.1562D-04, 0.1142D-04, 0.8327D-05, 0.6058D-05, 0.4400D-05,
     >    0.3189D-05/

      data (calcpts(j,27), j = 1,neta) /0.4428D-23, 0.1761D-22,
     >    0.6771D-22, 0.2590D-21, 0.9912D-21, 0.3800D-20, 0.1455D-19,
     >    0.5577D-19, 0.2136D-18, 0.8187D-18, 0.3136D-17, 0.1202D-16,
     >    0.4603D-16, 0.1764D-15, 0.6754D-15, 0.2587D-14, 0.9908D-14,
     >    0.3794D-13, 0.1452D-12, 0.5555D-12, 0.2124D-11, 0.8109D-11,
     >    0.3092D-10, 0.1176D-09, 0.4459D-09, 0.1683D-08, 0.6292D-08,
     >    0.2334D-07, 0.8531D-07, 0.3054D-06, 0.1062D-05, 0.3543D-05,
     >    0.1119D-04, 0.3286D-04, 0.8811D-04, 0.2118D-03, 0.4500D-03,
     >    0.8382D-03, 0.1369D-02, 0.1977D-02, 0.2558D-02, 0.3014D-02,
     >    0.3288D-02, 0.3373D-02, 0.3299D-02, 0.3102D-02, 0.2821D-02,
     >    0.2498D-02, 0.2157D-02, 0.1822D-02, 0.1512D-02, 0.1234D-02,
     >    0.9936D-03, 0.7897D-03, 0.6210D-03, 0.4838D-03, 0.3737D-03,
     >    0.2865D-03, 0.2181D-03, 0.1652D-03, 0.1244D-03, 0.9323D-04,
     >    0.6956D-04, 0.5171D-04, 0.3828D-04, 0.2826D-04, 0.2079D-04,
     >    0.1525D-04, 0.1116D-04, 0.8144D-05, 0.5930D-05, 0.4309D-05,
     >    0.3125D-05/

      data (calcpts(j,28), j = 1,neta) /0.4341D-23, 0.1749D-22,
     >    0.6735D-22, 0.2576D-21, 0.9849D-21, 0.3777D-20, 0.1447D-19,
     >    0.5542D-19, 0.2124D-18, 0.8136D-18, 0.3117D-17, 0.1194D-16,
     >    0.4575D-16, 0.1752D-15, 0.6714D-15, 0.2571D-14, 0.9848D-14,
     >    0.3771D-13, 0.1443D-12, 0.5520D-12, 0.2110D-11, 0.8059D-11,
     >    0.3072D-10, 0.1169D-09, 0.4432D-09, 0.1672D-08, 0.6254D-08,
     >    0.2319D-07, 0.8475D-07, 0.3033D-06, 0.1054D-05, 0.3516D-05,
     >    0.1110D-04, 0.3256D-04, 0.8724D-04, 0.2094D-03, 0.4437D-03,
     >    0.8241D-03, 0.1341D-02, 0.1926D-02, 0.2476D-02, 0.2895D-02,
     >    0.3132D-02, 0.3189D-02, 0.3096D-02, 0.2897D-02, 0.2631D-02,
     >    0.2329D-02, 0.2016D-02, 0.1710D-02, 0.1424D-02, 0.1167D-02,
     >    0.9424D-03, 0.7516D-03, 0.5929D-03, 0.4632D-03, 0.3587D-03,
     >    0.2756D-03, 0.2103D-03, 0.1596D-03, 0.1204D-03, 0.9035D-04,
     >    0.6752D-04, 0.5024D-04, 0.3725D-04, 0.2752D-04, 0.2026D-04,
     >    0.1488D-04, 0.1090D-04, 0.7960D-05, 0.5800D-05, 0.4218D-05,
     >    0.3062D-05/

      data (calcpts(j,29), j = 1,neta) /0.4268D-23, 0.1743D-22,
     >    0.6717D-22, 0.2568D-21, 0.9821D-21, 0.3767D-20, 0.1443D-19,
     >    0.5527D-19, 0.2118D-18, 0.8114D-18, 0.3108D-17, 0.1191D-16,
     >    0.4561D-16, 0.1748D-15, 0.6694D-15, 0.2563D-14, 0.9819D-14,
     >    0.3759D-13, 0.1439D-12, 0.5505D-12, 0.2105D-11, 0.8036D-11,
     >    0.3065D-10, 0.1166D-09, 0.4419D-09, 0.1668D-08, 0.6236D-08,
     >    0.2312D-07, 0.8450D-07, 0.3024D-06, 0.1051D-05, 0.3504D-05,
     >    0.1106D-04, 0.3243D-04, 0.8684D-04, 0.2082D-03, 0.4409D-03,
     >    0.8175D-03, 0.1328D-02, 0.1902D-02, 0.2436D-02, 0.2834D-02,
     >    0.3042D-02, 0.3069D-02, 0.2950D-02, 0.2738D-02, 0.2472D-02,
     >    0.2181D-02, 0.1887D-02, 0.1603D-02, 0.1339D-02, 0.1101D-02,
     >    0.8922D-03, 0.7140D-03, 0.5650D-03, 0.4426D-03, 0.3436D-03,
     >    0.2648D-03, 0.2025D-03, 0.1539D-03, 0.1163D-03, 0.8747D-04,
     >    0.6546D-04, 0.4878D-04, 0.3621D-04, 0.2678D-04, 0.1974D-04,
     >    0.1451D-04, 0.1064D-04, 0.7777D-05, 0.5671D-05, 0.4128D-05,
     >    0.2997D-05/

      data (calcpts(j,30), j = 1,neta) /0.4237D-23, 0.1740D-22,
     >    0.6711D-22, 0.2565D-21, 0.9807D-21, 0.3762D-20, 0.1441D-19,
     >    0.5520D-19, 0.2115D-18, 0.8103D-18, 0.3105D-17, 0.1189D-16,
     >    0.4556D-16, 0.1746D-15, 0.6686D-15, 0.2561D-14, 0.9807D-14,
     >    0.3755D-13, 0.1437D-12, 0.5498D-12, 0.2102D-11, 0.8025D-11,
     >    0.3060D-10, 0.1164D-09, 0.4413D-09, 0.1665D-08, 0.6227D-08,
     >    0.2309D-07, 0.8437D-07, 0.3020D-06, 0.1049D-05, 0.3498D-05,
     >    0.1104D-04, 0.3237D-04, 0.8664D-04, 0.2078D-03, 0.4397D-03,
     >    0.8148D-03, 0.1323D-02, 0.1893D-02, 0.2421D-02, 0.2808D-02,
     >    0.3002D-02, 0.3006D-02, 0.2862D-02, 0.2626D-02, 0.2349D-02,
     >    0.2058D-02, 0.1775D-02, 0.1506D-02, 0.1259D-02, 0.1037D-02,
     >    0.8433D-03, 0.6771D-03, 0.5374D-03, 0.4224D-03, 0.3289D-03,
     >    0.2540D-03, 0.1947D-03, 0.1483D-03, 0.1123D-03, 0.8458D-04,
     >    0.6341D-04, 0.4733D-04, 0.3518D-04, 0.2604D-04, 0.1923D-04,
     >    0.1414D-04, 0.1038D-04, 0.7594D-05, 0.5542D-05, 0.4037D-05,
     >    0.2932D-05/

      data (calcpts(j,31), j = 1,neta) /0.4208D-23, 0.1743D-22,
     >    0.6705D-22, 0.2565D-21, 0.9801D-21, 0.3759D-20, 0.1440D-19,
     >    0.5517D-19, 0.2113D-18, 0.8097D-18, 0.3102D-17, 0.1189D-16,
     >    0.4554D-16, 0.1745D-15, 0.6681D-15, 0.2559D-14, 0.9801D-14,
     >    0.3753D-13, 0.1436D-12, 0.5495D-12, 0.2100D-11, 0.8020D-11,
     >    0.3059D-10, 0.1163D-09, 0.4410D-09, 0.1664D-08, 0.6222D-08,
     >    0.2307D-07, 0.8433D-07, 0.3018D-06, 0.1048D-05, 0.3495D-05,
     >    0.1103D-04, 0.3234D-04, 0.8656D-04, 0.2075D-03, 0.4392D-03,
     >    0.8139D-03, 0.1321D-02, 0.1891D-02, 0.2420D-02, 0.2805D-02,
     >    0.2994D-02, 0.2985D-02, 0.2823D-02, 0.2565D-02, 0.2267D-02,
     >    0.1966D-02, 0.1682D-02, 0.1420D-02, 0.1185D-02, 0.9775D-03,
     >    0.7964D-03, 0.6411D-03, 0.5104D-03, 0.4023D-03, 0.3143D-03,
     >    0.2433D-03, 0.1870D-03, 0.1427D-03, 0.1083D-03, 0.8172D-04,
     >    0.6135D-04, 0.4586D-04, 0.3414D-04, 0.2530D-04, 0.1871D-04,
     >    0.1378D-04, 0.1012D-04, 0.7412D-05, 0.5414D-05, 0.3947D-05,
     >    0.2870D-05/

      data (calcpts(j,32), j = 1,neta) /0.4152D-23, 0.1735D-22,
     >    0.6717D-22, 0.2562D-21, 0.9799D-21, 0.3757D-20, 0.1439D-19,
     >    0.5514D-19, 0.2113D-18, 0.8095D-18, 0.3102D-17, 0.1188D-16,
     >    0.4552D-16, 0.1745D-15, 0.6679D-15, 0.2559D-14, 0.9798D-14,
     >    0.3751D-13, 0.1436D-12, 0.5493D-12, 0.2100D-11, 0.8017D-11,
     >    0.3057D-10, 0.1163D-09, 0.4410D-09, 0.1664D-08, 0.6221D-08,
     >    0.2307D-07, 0.8430D-07, 0.3017D-06, 0.1048D-05, 0.3495D-05,
     >    0.1102D-04, 0.3234D-04, 0.8652D-04, 0.2075D-03, 0.4389D-03,
     >    0.8138D-03, 0.1321D-02, 0.1893D-02, 0.2423D-02, 0.2812D-02,
     >    0.3003D-02, 0.2994D-02, 0.2821D-02, 0.2546D-02, 0.2226D-02,
     >    0.1906D-02, 0.1613D-02, 0.1350D-02, 0.1121D-02, 0.9229D-03,
     >    0.7521D-03, 0.6066D-03, 0.4842D-03, 0.3826D-03, 0.2997D-03,
     >    0.2326D-03, 0.1792D-03, 0.1372D-03, 0.1043D-03, 0.7885D-04,
     >    0.5931D-04, 0.4440D-04, 0.3311D-04, 0.2457D-04, 0.1818D-04,
     >    0.1341D-04, 0.9858D-05, 0.7227D-05, 0.5284D-05, 0.3855D-05,
     >    0.2805D-05/

      data (calcpts(j,33), j = 1,neta) /0.4175D-23, 0.1735D-22,
     >    0.6707D-22, 0.2565D-21, 0.9798D-21, 0.3757D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6679D-15, 0.2558D-14, 0.9797D-14,
     >    0.3751D-13, 0.1436D-12, 0.5492D-12, 0.2100D-11, 0.8017D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2307D-07, 0.8429D-07, 0.3017D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4389D-03,
     >    0.8139D-03, 0.1322D-02, 0.1895D-02, 0.2428D-02, 0.2823D-02,
     >    0.3020D-02, 0.3015D-02, 0.2841D-02, 0.2556D-02, 0.2220D-02,
     >    0.1881D-02, 0.1571D-02, 0.1300D-02, 0.1070D-02, 0.8756D-03,
     >    0.7119D-03, 0.5740D-03, 0.4589D-03, 0.3634D-03, 0.2853D-03,
     >    0.2222D-03, 0.1716D-03, 0.1316D-03, 0.1003D-03, 0.7599D-04,
     >    0.5727D-04, 0.4295D-04, 0.3207D-04, 0.2385D-04, 0.1767D-04,
     >    0.1304D-04, 0.9599D-05, 0.7044D-05, 0.5156D-05, 0.3764D-05,
     >    0.2742D-05/

      data (calcpts(j,34), j = 1,neta) /0.4158D-23, 0.1734D-22,
     >    0.6731D-22, 0.2564D-21, 0.9796D-21, 0.3757D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9797D-14,
     >    0.3750D-13, 0.1436D-12, 0.5492D-12, 0.2100D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2307D-07, 0.8429D-07, 0.3017D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8140D-03, 0.1323D-02, 0.1898D-02, 0.2433D-02, 0.2834D-02,
     >    0.3038D-02, 0.3039D-02, 0.2871D-02, 0.2585D-02, 0.2240D-02,
     >    0.1886D-02, 0.1556D-02, 0.1271D-02, 0.1033D-02, 0.8375D-03,
     >    0.6769D-03, 0.5445D-03, 0.4352D-03, 0.3452D-03, 0.2715D-03,
     >    0.2118D-03, 0.1641D-03, 0.1261D-03, 0.9634D-04, 0.7314D-04,
     >    0.5523D-04, 0.4149D-04, 0.3104D-04, 0.2312D-04, 0.1715D-04,
     >    0.1267D-04, 0.9339D-05, 0.6861D-05, 0.5027D-05, 0.3674D-05,
     >    0.2677D-05/

      data (calcpts(j,35), j = 1,neta) /0.4069D-23, 0.1734D-22,
     >    0.6731D-22, 0.2564D-21, 0.9805D-21, 0.3757D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1436D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2307D-07, 0.8427D-07, 0.3017D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8142D-03, 0.1323D-02, 0.1899D-02, 0.2438D-02, 0.2841D-02,
     >    0.3053D-02, 0.3063D-02, 0.2903D-02, 0.2620D-02, 0.2272D-02,
     >    0.1910D-02, 0.1565D-02, 0.1264D-02, 0.1013D-02, 0.8111D-03,
     >    0.6492D-03, 0.5190D-03, 0.4135D-03, 0.3278D-03, 0.2582D-03,
     >    0.2018D-03, 0.1566D-03, 0.1207D-03, 0.9242D-04, 0.7031D-04,
     >    0.5321D-04, 0.4004D-04, 0.3000D-04, 0.2238D-04, 0.1662D-04,
     >    0.1231D-04, 0.9080D-05, 0.6678D-05, 0.4898D-05, 0.3582D-05,
     >    0.2615D-05/

      data (calcpts(j,36), j = 1,neta) /0.4145D-23, 0.1776D-22,
     >    0.6732D-22, 0.2571D-21, 0.9791D-21, 0.3755D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8144D-03, 0.1324D-02, 0.1901D-02, 0.2441D-02, 0.2849D-02,
     >    0.3065D-02, 0.3083D-02, 0.2930D-02, 0.2655D-02, 0.2311D-02,
     >    0.1944D-02, 0.1590D-02, 0.1275D-02, 0.1011D-02, 0.7981D-03,
     >    0.6305D-03, 0.4989D-03, 0.3950D-03, 0.3122D-03, 0.2456D-03,
     >    0.1922D-03, 0.1494D-03, 0.1154D-03, 0.8852D-04, 0.6750D-04,
     >    0.5118D-04, 0.3859D-04, 0.2897D-04, 0.2165D-04, 0.1611D-04,
     >    0.1194D-04, 0.8820D-05, 0.6495D-05, 0.4769D-05, 0.3492D-05,
     >    0.2550D-05/

      data (calcpts(j,37), j = 1,neta) /0.4138D-23, 0.1734D-22,
     >    0.6732D-22, 0.2570D-21, 0.9789D-21, 0.3757D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8145D-03, 0.1324D-02, 0.1902D-02, 0.2443D-02, 0.2853D-02,
     >    0.3074D-02, 0.3097D-02, 0.2952D-02, 0.2685D-02, 0.2348D-02,
     >    0.1982D-02, 0.1625D-02, 0.1301D-02, 0.1024D-02, 0.7987D-03,
     >    0.6221D-03, 0.4856D-03, 0.3806D-03, 0.2987D-03, 0.2343D-03,
     >    0.1832D-03, 0.1425D-03, 0.1102D-03, 0.8471D-04, 0.6473D-04,
     >    0.4917D-04, 0.3716D-04, 0.2795D-04, 0.2091D-04, 0.1559D-04,
     >    0.1157D-04, 0.8561D-05, 0.6312D-05, 0.4640D-05, 0.3402D-05,
     >    0.2487D-05/

      data (calcpts(j,38), j = 1,neta) /0.3888D-23, 0.1774D-22,
     >    0.6732D-22, 0.2554D-21, 0.9805D-21, 0.3757D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8145D-03, 0.1324D-02, 0.1902D-02, 0.2445D-02, 0.2858D-02,
     >    0.3081D-02, 0.3110D-02, 0.2970D-02, 0.2709D-02, 0.2378D-02,
     >    0.2016D-02, 0.1661D-02, 0.1332D-02, 0.1047D-02, 0.8111D-03,
     >    0.6242D-03, 0.4803D-03, 0.3712D-03, 0.2883D-03, 0.2246D-03,
     >    0.1749D-03, 0.1360D-03, 0.1052D-03, 0.8099D-04, 0.6200D-04,
     >    0.4719D-04, 0.3573D-04, 0.2693D-04, 0.2019D-04, 0.1508D-04,
     >    0.1121D-04, 0.8303D-05, 0.6129D-05, 0.4512D-05, 0.3311D-05,
     >    0.2423D-05/

      data (calcpts(j,39), j = 1,neta) /0.3883D-23, 0.1724D-22,
     >    0.6732D-22, 0.2544D-21, 0.9805D-21, 0.3756D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2446D-02, 0.2859D-02,
     >    0.3085D-02, 0.3117D-02, 0.2982D-02, 0.2729D-02, 0.2401D-02,
     >    0.2046D-02, 0.1694D-02, 0.1365D-02, 0.1075D-02, 0.8318D-03,
     >    0.6356D-03, 0.4832D-03, 0.3680D-03, 0.2819D-03, 0.2172D-03,
     >    0.1680D-03, 0.1301D-03, 0.1005D-03, 0.7742D-04, 0.5934D-04,
     >    0.4526D-04, 0.3432D-04, 0.2591D-04, 0.1947D-04, 0.1456D-04,
     >    0.1084D-04, 0.8043D-05, 0.5948D-05, 0.4383D-05, 0.3220D-05,
     >    0.2360D-05/

      data (calcpts(j,40), j = 1,neta) /0.4569D-23, 0.1774D-22,
     >    0.6616D-22, 0.2544D-21, 0.9809D-21, 0.3756D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     >    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2862D-02,
     >    0.3089D-02, 0.3123D-02, 0.2993D-02, 0.2742D-02, 0.2420D-02,
     >    0.2069D-02, 0.1721D-02, 0.1394D-02, 0.1104D-02, 0.8562D-03,
     >    0.6533D-03, 0.4932D-03, 0.3709D-03, 0.2799D-03, 0.2127D-03,
     >    0.1627D-03, 0.1251D-03, 0.9633D-04, 0.7409D-04, 0.5679D-04,
     >    0.4335D-04, 0.3294D-04, 0.2491D-04, 0.1875D-04, 0.1404D-04,
     >    0.1048D-04, 0.7787D-05, 0.5764D-05, 0.4254D-05, 0.3129D-05,
     >    0.2295D-05/

      data (calcpts(j,41), j = 1,neta) /0.4535D-23, 0.1701D-22,
     >    0.6738D-22, 0.2558D-21, 0.9793D-21, 0.3755D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2862D-02,
     >    0.3092D-02, 0.3128D-02, 0.2998D-02, 0.2751D-02, 0.2433D-02,
     >    0.2087D-02, 0.1741D-02, 0.1418D-02, 0.1129D-02, 0.8806D-03,
     >    0.6739D-03, 0.5081D-03, 0.3795D-03, 0.2829D-03, 0.2117D-03,
     >    0.1596D-03, 0.1214D-03, 0.9278D-04, 0.7107D-04, 0.5441D-04,
     >    0.4154D-04, 0.3159D-04, 0.2393D-04, 0.1803D-04, 0.1354D-04,
     >    0.1011D-04, 0.7529D-05, 0.5583D-05, 0.4125D-05, 0.3039D-05,
     >    0.2232D-05/

      data (calcpts(j,42), j = 1,neta) /0.5008D-23, 0.1776D-22,
     >    0.6751D-22, 0.2558D-21, 0.9809D-21, 0.3755D-20, 0.1439D-19,
     >    0.5514D-19, 0.2112D-18, 0.8092D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2864D-02,
     >    0.3093D-02, 0.3131D-02, 0.3003D-02, 0.2757D-02, 0.2443D-02,
     >    0.2100D-02, 0.1758D-02, 0.1437D-02, 0.1151D-02, 0.9024D-03,
     >    0.6945D-03, 0.5253D-03, 0.3918D-03, 0.2900D-03, 0.2144D-03,
     >    0.1592D-03, 0.1193D-03, 0.9015D-04, 0.6855D-04, 0.5228D-04,
     >    0.3984D-04, 0.3030D-04, 0.2297D-04, 0.1734D-04, 0.1303D-04,
     >    0.9756D-05, 0.7273D-05, 0.5401D-05, 0.3998D-05, 0.2949D-05,
     >    0.2169D-05/

      data (calcpts(j,43), j = 1,neta) /0.4451D-23, 0.1773D-22,
     >    0.6620D-22, 0.2545D-21, 0.9812D-21, 0.3755D-20, 0.1439D-19,
     >    0.5513D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2864D-02,
     >    0.3095D-02, 0.3132D-02, 0.3006D-02, 0.2763D-02, 0.2449D-02,
     >    0.2109D-02, 0.1769D-02, 0.1451D-02, 0.1167D-02, 0.9204D-03,
     >    0.7127D-03, 0.5421D-03, 0.4059D-03, 0.3000D-03, 0.2200D-03,
     >    0.1614D-03, 0.1191D-03, 0.8873D-04, 0.6671D-04, 0.5048D-04,
     >    0.3833D-04, 0.2910D-04, 0.2205D-04, 0.1667D-04, 0.1254D-04,
     >    0.9401D-05, 0.7020D-05, 0.5222D-05, 0.3870D-05, 0.2859D-05,
     >    0.2105D-05/

      data (calcpts(j,44), j = 1,neta) /0.4536D-23, 0.1766D-22,
     >    0.6613D-22, 0.2562D-21, 0.9802D-21, 0.3755D-20, 0.1439D-19,
     >    0.5513D-19, 0.2112D-18, 0.8095D-18, 0.3102D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     >    0.3095D-02, 0.3134D-02, 0.3008D-02, 0.2766D-02, 0.2454D-02,
     >    0.2115D-02, 0.1777D-02, 0.1462D-02, 0.1179D-02, 0.9344D-03,
     >    0.7277D-03, 0.5571D-03, 0.4196D-03, 0.3113D-03, 0.2282D-03,
     >    0.1661D-03, 0.1210D-03, 0.8875D-04, 0.6575D-04, 0.4919D-04,
     >    0.3705D-04, 0.2802D-04, 0.2120D-04, 0.1601D-04, 0.1206D-04,
     >    0.9053D-05, 0.6770D-05, 0.5043D-05, 0.3742D-05, 0.2769D-05,
     >    0.2042D-05/

      data (calcpts(j,45), j = 1,neta) /0.4531D-23, 0.1743D-22,
     >    0.6650D-22, 0.2545D-21, 0.9850D-21, 0.3771D-20, 0.1438D-19,
     >    0.5526D-19, 0.2116D-18, 0.8094D-18, 0.3104D-17, 0.1188D-16,
     >    0.4551D-16, 0.1743D-15, 0.6679D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     >    0.3096D-02, 0.3135D-02, 0.3009D-02, 0.2768D-02, 0.2457D-02,
     >    0.2120D-02, 0.1783D-02, 0.1469D-02, 0.1188D-02, 0.9449D-03,
     >    0.7394D-03, 0.5694D-03, 0.4317D-03, 0.3222D-03, 0.2370D-03,
     >    0.1725D-03, 0.1247D-03, 0.9030D-04, 0.6587D-04, 0.4854D-04,
     >    0.3615D-04, 0.2712D-04, 0.2043D-04, 0.1541D-04, 0.1160D-04,
     >    0.8714D-05, 0.6524D-05, 0.4866D-05, 0.3617D-05, 0.2679D-05,
     >    0.1979D-05/

      data (calcpts(j,46), j = 1,neta) /0.4427D-23, 0.1749D-22,
     >    0.6682D-22, 0.2549D-21, 0.9752D-21, 0.3768D-20, 0.1432D-19,
     >    0.5490D-19, 0.2113D-18, 0.8091D-18, 0.3100D-17, 0.1188D-16,
     >    0.4550D-16, 0.1743D-15, 0.6677D-15, 0.2558D-14, 0.9795D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     >    0.3096D-02, 0.3135D-02, 0.3011D-02, 0.2769D-02, 0.2460D-02,
     >    0.2122D-02, 0.1787D-02, 0.1474D-02, 0.1195D-02, 0.9525D-03,
     >    0.7480D-03, 0.5790D-03, 0.4416D-03, 0.3318D-03, 0.2457D-03,
     >    0.1794D-03, 0.1297D-03, 0.9321D-04, 0.6711D-04, 0.4869D-04,
     >    0.3573D-04, 0.2649D-04, 0.1980D-04, 0.1487D-04, 0.1117D-04,
     >    0.8388D-05, 0.6284D-05, 0.4692D-05, 0.3492D-05, 0.2591D-05,
     >    0.1916D-05/

      data (calcpts(j,47), j = 1,neta) /0.4376D-23, 0.1851D-22,
     >    0.6717D-22, 0.2583D-21, 0.1000D-20, 0.3750D-20, 0.1439D-19,
     >    0.5514D-19, 0.2121D-18, 0.8097D-18, 0.3111D-17, 0.1190D-16,
     >    0.4551D-16, 0.1743D-15, 0.6681D-15, 0.2559D-14, 0.9798D-14,
     >    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     >    0.3096D-02, 0.3135D-02, 0.3012D-02, 0.2771D-02, 0.2462D-02,
     >    0.2124D-02, 0.1790D-02, 0.1478D-02, 0.1199D-02, 0.9579D-03,
     >    0.7544D-03, 0.5861D-03, 0.4492D-03, 0.3398D-03, 0.2534D-03,
     >    0.1863D-03, 0.1351D-03, 0.9705D-04, 0.6938D-04, 0.4968D-04,
     >    0.3588D-04, 0.2621D-04, 0.1937D-04, 0.1442D-04, 0.1079D-04,
     >    0.8087D-05, 0.6054D-05, 0.4524D-05, 0.3371D-05, 0.2504D-05,
     >    0.1854D-05/

      data (calcpts(j,48), j = 1,neta) /0.5678D-23, 0.1891D-22,
     >    0.7606D-22, 0.2568D-21, 0.9618D-21, 0.3826D-20, 0.1455D-19,
     >    0.5600D-19, 0.2135D-18, 0.8070D-18, 0.3093D-17, 0.1190D-16,
     >    0.4561D-16, 0.1745D-15, 0.6681D-15, 0.2561D-14, 0.9801D-14,
     >    0.3751D-13, 0.1436D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     >    0.3096D-02, 0.3135D-02, 0.3012D-02, 0.2772D-02, 0.2463D-02,
     >    0.2125D-02, 0.1792D-02, 0.1481D-02, 0.1202D-02, 0.9617D-03,
     >    0.7589D-03, 0.5913D-03, 0.4551D-03, 0.3459D-03, 0.2597D-03,
     >    0.1923D-03, 0.1404D-03, 0.1013D-03, 0.7233D-04, 0.5142D-04,
     >    0.3666D-04, 0.2636D-04, 0.1919D-04, 0.1412D-04, 0.1048D-04,
     >    0.7817D-05, 0.5841D-05, 0.4362D-05, 0.3252D-05, 0.2418D-05,
     >    0.1792D-05/

      data (calcpts(j,49), j = 1,neta) /0.3773D-23, 0.1720D-22,
     >    0.6603D-22, 0.2522D-21, 0.1040D-20, 0.3992D-20, 0.1503D-19,
     >    0.5605D-19, 0.2113D-18, 0.8140D-18, 0.3115D-17, 0.1187D-16,
     >    0.4551D-16, 0.1745D-15, 0.6692D-15, 0.2561D-14, 0.9800D-14,
     >    0.3749D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     >    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     >    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     >    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     >    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     >    0.3096D-02, 0.3136D-02, 0.3012D-02, 0.2772D-02, 0.2463D-02,
     >    0.2127D-02, 0.1792D-02, 0.1482D-02, 0.1204D-02, 0.9644D-03,
     >    0.7620D-03, 0.5949D-03, 0.4593D-03, 0.3505D-03, 0.2645D-03,
     >    0.1971D-03, 0.1451D-03, 0.1054D-03, 0.7557D-04, 0.5369D-04,
     >    0.3800D-04, 0.2695D-04, 0.1931D-04, 0.1400D-04, 0.1027D-04,
     >    0.7599D-05, 0.5652D-05, 0.4212D-05, 0.3138D-05, 0.2334D-05,
     >    0.1731D-05/

      data (dlaeta(j), j = 1,neta) /
     > -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     > -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     > -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     > -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     > -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     >  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     > -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     > -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     > -1.33333333d0,-1.16666667d0,-1d0,-0.83333333d0,-0.66666667d0, 
     > -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     >  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     >  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     >  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     >  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     >  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     >  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     >     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     >     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      xsclqt = peta*(peta-1d0)/2d0*f(-1) +
     >     (1d0 - peta**2)*f(0) +
     >     peta*(peta+1d0)/2d0*f(1)
      return
      end

c These are the functions that give the asymptotic dependence of the
coefficient functions with the appropriate factors.
c xi = mq2/m2 (Q^2/m2)
c Longitudinal: equation (19) in PLB347 (1995) 143 - 151
      real*8 function asymp_l_CT(xi)
      implicit none
      real*8 xi, pi, term1, fii, fjj
      parameter (pi = 3.14159265359d0)
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      asymp_l_CT = 1.d0/6.d0/pi*(4.d0/xi - 4.d0/3.d0*term1 
     >     + (1.d0 - 2.d0/xi - 1.d0/6.d0*term1)*fjj(xi)
     >     - (3.d0/xi + 0.25d0*term1)*fii(xi))
      return
      end
c transverse: equation (20) in PLB347 (1995) 143 - 151
      real*8 function asymp_t_CT(xi)
      implicit none
      real*8 xi, pi, term1, fii, fjj
      parameter (pi = 3.14159265359d0)
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      asymp_t_CT = 1.d0/6.d0/pi*(-2.d0/3.d0/xi + 4.d0/3.d0*term1
     >     + (7.d0/6.d0 + 1.d0/3.d0/xi + 1.d0/6.d0*term1)*fjj(xi)
     >     + (1.d0 + 2.d0/xi + 0.25d0*term1)*fii(xi))
      return
      end
c longitudinal mass factorization: equation (21) in PLB347 (1995) 143 - 151
      real*8 function asympbar_l_CT(xi)
      implicit none
      real*8 xi, pi, term1, fjj
      parameter (pi = 3.14159265359d0)
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      asympbar_l_CT = 1.d0/6.d0/pi*(-6.d0/xi + 0.5d0*term1
     >     + (3.d0/xi + 0.25d0*term1)*fjj(xi))
      return
      end
c transverse mass factorization: equation (22) in PLB347 (1995) 143 - 151
      real*8 function asympbar_t_CT(xi)
      implicit none
      real*8 xi, pi, term1, fjj
      parameter (pi = 3.14159265359d0)
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      asympbar_t_CT = 1.d0/6.d0/pi*(4.d0/xi - 0.5d0*term1
     >     - (1.d0 + 2.d0/xi + 0.25d0*term1)*fjj(xi))
      return
      end
c equation (24) in PLB347 (1995) 143 - 151
      real*8 function fii(xi)
      implicit none
      external xLi
      real*8 pi, term1, term2, xi, xLi
      parameter (pi = 3.14159265359d0)
      term1 = dsqrt(xi)
      term2 = dsqrt(4.d0 + xi)
      fii = 4.d0/term1/term2*(-pi*pi/6.d0 
     >      - 0.5d0*(dlog((term2 + term1)/(term2 - term1)))**2
     >      + (dlog(0.5d0*(1.d0 - term1/term2)))**2 
     >      + 2.d0* xLi(2,0.5d0*(1.d0 - term1/term2)))
      return
      end
c equation (23) in PLB347 (1995) 143 - 151
      real*8 function fjj(xi)
      implicit none
      real*8 pi, xi, term1, term2
      parameter (pi = 3.14159265359d0)
      term1 = dsqrt(xi)
      term2 = dsqrt(4.d0 + xi)
      fjj = 4.d0/term1/term2*dlog((term2 + term1)/(term2 - term1))
      return
      end

c These are the functions that give the threshold dependence of the 
coefficient functions with the appropriate factors.
c eta = (W^2 - 4d0*m2)/4d0/m2  where W is the CM energy of the gamma* parton
c system. xi = mq2/m2 (Q^2/m2)
c Longitudinal CF group structure: equation (13) in PLB347 (1995) 143 - 151
      double precision function threshf_l_CT(eta,xi)
      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)
      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      threshf_l_CT = 1.d0/6.d0/pi*xi*term1**3*beta*beta*pi*pi/2.d0
      return
      end
c Transverse CF group structure: equation (14) in PLB347 (1995) 143 - 151
      double precision function threshf_t_CT(eta,xi)
      implicit none
      double precision pi, eta, xi, term1
      parameter (pi = 3.14159265359d0)
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      threshf_t_CT = 0.25d0/pi*term1*pi*pi/2.d0
      return
      end
c Transverse CA group structure: equation (16) in PLB347 (1995) 143 - 151
      double precision function thresha_t_CT(eta,xi)
      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)
      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      thresha_t_CT = 0.25d0/pi*term1*(beta*(dlog(8.d0*beta*beta))**2
     >     - 5.d0*beta*dlog(8.d0*beta*beta) - 0.25d0*pi*pi)
      return
      end
c Longitudinal CA group structure: equation (15) in PLB347 (1995) 143 - 151
      double precision function thresha_l_CT(eta,xi)
      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)
      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      thresha_l_CT = 1.d0/6.d0/pi*xi*term1**3*beta**2*
     >     (beta*(dlog(8.d0*beta*beta))**2
     >     - 5.d0*beta*dlog(8.d0*beta*beta) - 0.25d0*pi*pi)
      return
      end
c Longitudinal CA group structure for the mass factorization piece: 
c equation (17) in PLB347 (1995) 143 - 151
      double precision function threshbar_l_CT(eta,xi)
      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)
      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      threshbar_l_CT = 1.d0/6.d0/pi*xi*term1**3*beta**3*
     >     (-dlog(4.d0*beta*beta))
      return
      end
c Transverse CA group structure for the mass factorization piece: 
c equation (18) in PLB347 (1995) 143 - 151
      double precision function threshbar_t_CT(eta,xi)
      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)
      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      threshbar_t_CT = 0.25d0/pi*term1*beta*(-dlog(4.d0*beta*beta))
      return
      end
c routine taken out of Numerical Recipes
      Subroutine Locate(xx,n,x,j)
      Integer j,n
      Double Precision x,xx(n)
      Integer jl,ju,jm
      jl = 0
      ju = n+1
 10   If (ju - jl .gt. 1) then
         jm = (ju + jl)/2
         If ((xx(n) .gt. xx(1)) .eqv. (x .gt. xx(jm))) then
            jl = jm
         else
            ju = jm
         endif
         goto 10
      endif
      j = jl
      return
      End

         
c This gives the transverse Born coefficient as shown in fig 6a of
c  NPB392 (1993) 162 - 229.  For QCD take tf = 1d0/2d0, for QED take
c tf = 1d0 
c eta = (s - 4d0*m2)/4d0/m2, s is the gamma* gluon (gamma) CM Energy
c xi = Q^2/m2
      double precision function born_t_CT(eta,xi)
      implicit none
      double precision eta, xi, pi, ca, cf, tf
      parameter(ca=3d0, cf=4d0/3d0, tf=.5d0)
      parameter(pi = 3.14159265359d0)
      born_t_CT = 0.5d0*pi*tf*(1.d0 + eta + 0.25d0*xi)**(-3)*
     >         (-2.d0*((1.d0 + eta - 0.25d0*xi)**2 + eta + 1.d0)*
     >         dsqrt(eta/(1.d0 + eta)) + (2.d0*(1.d0 + eta)**2 +
     >         0.125d0*xi**2 + 2.d0*eta + 1.d0)*
     >         dlog((dsqrt(1.d0 + eta) + dsqrt(eta))/
     >              (dsqrt(1.d0 + eta) - dsqrt(eta))))
      return
      end

c transverse coefficient function for xi >> 1

      double precision function bora_t(eta,xi)
      implicit none
      double precision eta, xi, pi, ca, cf, tf, z
      parameter(ca=3d0, cf=4d0/3d0, tf=.5d0)
      parameter(pi = 3.14159265359d0)
      z=xi/(4.d0*(1.d0+eta) + xi)
      bora_t = 0.25d0*pi*tf*z*
     >         (-16.d0*(1.d0 - 2.d0*z)*(1.d0 - 2.d0*z)/xi 
     >          + 16.d0*( z*z + ( 1.d0 - z )*(1.d0 - z) )
     >          *dlog( 4.d0*(eta + 1.d0))/xi)
      return
      end
c Longitudinal coefficient function, see above for additional comments
c Fig 6b of NPB392(1993) 162 - 229.


      double precision function born_l_CT(eta,xi)
      implicit none
      double precision eta, xi, pi, tf, ca, cf
      parameter(ca=3d0, cf=4d0/3d0, tf=.5d0)
      parameter(pi = 3.14159265359d0)
      born_l_CT = 0.5d0*pi*tf*xi*(1.d0 + eta + 0.25d0*xi)**(-3.d0)*
     >         (2.d0*dsqrt(eta*(1.d0 + eta)) -
     >         dlog((dsqrt(1.d0 + eta) + dsqrt(eta))/
     >               (dsqrt(1.d0 + eta) - dsqrt(eta))))
      return
      end

c longitudinal coefficient function for xi >> 1

      double precision function bora_l(eta,xi)
      implicit none
      double precision eta, xi, pi, tf, ca, cf, z
      parameter(ca=3d0, cf=4d0/3d0, tf=.5d0)
      parameter(pi = 3.14159265359d0)
      z=xi/(4.d0*(1.d0+eta) + xi)
      bora_l = 0.5d0*pi*tf*z*( 32.d0*z*(1.d0 - z)/xi)
      return
      end
