(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     36958,       1275]
NotebookOptionsPosition[     32132,       1100]
NotebookOutlinePosition[     32495,       1116]
CellTagsIndexPosition[     32452,       1113]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Problem 1", "Section",
 CellChangeTimes->{{3.650951892234829*^9, 3.650951901694723*^9}, {
   3.682779748086904*^9, 3.682779748262773*^9}, 3.6827798312375793`*^9, {
   3.6835562399394703`*^9, 3.683556242627283*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.748807288210762*^9, 3.748807294424082*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "==", 
  RowBox[{
   RowBox[{"c", "[", "n", "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"n", " ", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.74880720937278*^9, {3.7488072559436607`*^9, 3.748807297634346*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"c", "[", "n", "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"n", " ", "x"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.748807271689809*^9, 3.748807298606222*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rhs", "=", 
  RowBox[{"Integrate", "[", " ", 
   RowBox[{
    RowBox[{"1", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"37", " ", "x"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.748807301318488*^9, 3.748807352331105*^9}, {
  3.748807432758749*^9, 3.748807435795683*^9}}],

Cell[BoxData[
 FractionBox["2", "37"]], "Output",
 CellChangeTimes->{{3.748807327086213*^9, 3.7488073539853373`*^9}, 
   3.748807437145585*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lhs", "=", " ", 
  RowBox[{"Integrate", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", "37", "]"}], " ", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"37", " ", "x"}], "]"}], "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.748807337568983*^9, 3.7488073423329153`*^9}, {
  3.748807445318129*^9, 3.7488074658077707`*^9}, {3.7488076509593067`*^9, 
  3.748807651097315*^9}}],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"c", "[", "37", "]"}]}]], "Output",
 CellChangeTimes->{3.748807651327876*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq", "=", " ", 
  RowBox[{"lhs", "\[Equal]", "rhs"}]}]], "Input",
 CellChangeTimes->{{3.748807656430512*^9, 3.748807659837723*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"c", "[", "37", "]"}]}], "\[Equal]", 
  FractionBox["2", "37"]}]], "Output",
 CellChangeTimes->{3.748807660358445*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eq", ",", 
   RowBox[{"c", "[", "37", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7488076612003193`*^9, 3.748807669603517*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c", "[", "37", "]"}], "\[Rule]", 
    FractionBox["2", 
     RowBox[{"37", " ", "\[Pi]"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.748807669825437*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.650951892234829*^9, 3.650951901694723*^9}, {
   3.682779748086904*^9, 3.682779748262773*^9}, 3.6827798312375793`*^9, {
   3.6835562399394703`*^9, 3.683556242627283*^9}, {3.7488080247356167`*^9, 
   3.748808024904813*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell["\<\
Lag[qi_,L_ ,Qi_,t_:t] := 
D[ D[L,(D[qi[t],t])],t]-D[L,qi[t]]==Qi;
  
Lag[qi_List,L_,Qi_List,t_:t] :=
(D[ D[L,(D[qi[[#]][t],t])],t]-D[L,qi[[#]][t]]==Qi[[#]]
)&  /@  Range[1,Length[qi]];

Protect[Lag];
\
\>", "Input",
 CellChangeTimes->{{3.7474814075508757`*^9, 3.747481420216249*^9}, {
  3.748808045907548*^9, 3.748808046219252*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
 "Problem 3: Sphere Rolling on a Fixed Sphere  ",
 StyleBox[" *part c is wrong*",
  FontColor->RGBColor[0.5, 0, 0.5]]
}], "Subsection",
 Evaluatable->False,
 CellChangeTimes->{{3.6128456142416887`*^9, 3.612845620848988*^9}, {
  3.6132771562726994`*^9, 3.613277157360551*^9}, {3.616297139589533*^9, 
  3.616297142365405*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["Remarks and outline", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 Hyphenation->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part a", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tcm", "=", 
   RowBox[{
    FractionBox["1", "2"], " ", "m", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["r", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"r", "[", "t", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}]}], 
  ";"}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"Trot", "=", "0"}], ";"}]], "Input",
 CellChangeTimes->{3.748808063019816*^9},
 Hyphenation->False],

Cell["T=Tcm+Trot; ", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["V= m g r[t] Cos[\[Theta]1[t]]; ", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["L=T-V", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "g"}], " ", "m", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}], " ", 
   RowBox[{"r", "[", "t", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "m", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["r", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"r", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Theta]1", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "2"]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.6128456023518333`*^9, 3.6162023254130287`*^9, 
  3.616207778720717*^9, 3.616208498482319*^9, 3.616296950136951*^9, 
  3.616297028394004*^9, 3.748808066376814*^9, 3.7488081681048527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["constraints= { r[t]-a-b==0 }", "Input",
 CellChangeTimes->{3.748808070858259*^9},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "-", "b", "+", 
    RowBox[{"r", "[", "t", "]"}]}], "\[Equal]", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.612845602406199*^9, 3.6162023254511003`*^9, 
  3.616207778760248*^9, 3.6162084985442944`*^9, 3.616296950260467*^9, 
  3.616297028522737*^9, 3.748808071414657*^9, 3.748808168155891*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constraintRule", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"constraints", " ", ",", 
    RowBox[{"{", "r", "}"}], ",", "t"}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.748808075205533*^9, 3.74880807554749*^9}},
 Hyphenation->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"r", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"a", "+", "b"}]}], "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.612845602459429*^9, 3.61620232549286*^9, 
  3.6162077788039093`*^9, 3.6162084986062737`*^9, 3.616296950400385*^9, 
  3.6162970286249123`*^9, 3.7488080759865427`*^9, 3.74880816819823*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "[", "t", "]"}], ",", 
      RowBox[{"\[Theta]1", "[", "t", "]"}]}], "}"}]}], ";"}], " "}]], "Input",\

 CellChangeTimes->{{3.748808079653047*^9, 3.748808080557971*^9}},
 Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Qeq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Lambda]", "[", "j", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"constraints", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"vars", "[", 
          RowBox[{"[", "#", "]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "1"}], "}"}]}], "]"}], "&"}], " ", "/@", 
   " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.748808084388073*^9, 3.748808091519927*^9}},
 Hyphenation->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Lambda]", "[", "1", "]"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6128456025336237`*^9, 3.61620232554214*^9, 3.616207778852358*^9, 
   3.6162084986728773`*^9, 3.6162969505385017`*^9, 3.6162970290267363`*^9, {
   3.748808085972344*^9, 3.748808092432186*^9}, 3.748808168262422*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"eqMotion", "=", 
    RowBox[{"Lag", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "\[Theta]1"}], "}"}], ",", "L", ",", "Qeq"}], 
     "]"}]}], ")"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", "eqMotion", "]"}]}], "Input",
 CellChangeTimes->{{3.421766463230115*^9, 3.421766476320742*^9}, {
  3.748808096610793*^9, 3.7488080968984833`*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{"g", " ", "m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "-", 
       RowBox[{"m", " ", 
        RowBox[{"r", "[", "t", "]"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["r", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", 
      RowBox[{"\[Lambda]", "[", "1", "]"}]}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "g"}], " ", "m", " ", 
        RowBox[{"r", "[", "t", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"r", "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["r", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"r", "[", "t", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", "0"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{3.6128456025871143`*^9, 3.616202325583686*^9, 
  3.616207778895536*^9, 3.616208498740862*^9, 3.6162969506668987`*^9, 
  3.61629702913374*^9, 3.748808108901022*^9, 3.748808168320528*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part b", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[TextData[StyleBox["NEED  TO FIX ORDER HERE",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.747481472209949*^9, 3.747481514119787*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]Sol", ",", "\[Lambda]1Sol"}], "}"}], "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"eqMotion", "//.", "\[InvisibleSpace]", "constraintRule"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], ",", 
          RowBox[{"\[Lambda]", "[", "1", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[InvisibleSpace]", 
      RowBox[{"Rule", "\[Rule]", "Equal"}]}], "]"}]}], ")"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{"\[Theta]Sol", ",", "\[Lambda]1Sol"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.421766491011459*^9, 3.421766492426163*^9}, {
   3.74880810480676*^9, 3.748808134861803*^9}, 3.748808194978588*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{"g", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
       RowBox[{"a", "+", "b"}]]}]},
    {
     RowBox[{
      RowBox[{"\[Lambda]", "[", "1", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"g", " ", "m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "-", 
       RowBox[{"a", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
       RowBox[{"b", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}]}]}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{
  3.612845602652751*^9, 3.616202325872929*^9, 3.61620777894386*^9, 
   3.616208499240749*^9, 3.616296950793442*^9, 3.616297029249*^9, {
   3.7488081133899307`*^9, 3.7488081355683327`*^9}, {3.748808173437564*^9, 
   3.74880819549105*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq\[Theta]", "=", 
  RowBox[{"(", " ", 
   RowBox[{
    RowBox[{"\[Theta]Sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"\[Theta]Sol", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], ")"}], " "}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"g", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
    RowBox[{"a", "+", "b"}]]}], "+", 
  RowBox[{
   SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "t", "]"}]}]], "Output",
 CellChangeTimes->{3.612845602663356*^9, 3.6162023258872232`*^9, 
  3.6162077789863462`*^9, 3.6162084992547092`*^9, 3.616296951201239*^9, 
  3.616297029351297*^9, 3.7488081885794983`*^9}]
}, Open  ]],

Cell[TextData[StyleBox["DO INDEFINITE INTEGRAL HERE, AND AFTER SUBSTITUTE IN \
LIMITS",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.747481472209949*^9, 3.747481514119787*^9}, {
  3.747481547230351*^9, 3.7474815580488243`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "int\[Theta]TMP", "]"}]], "Input",
 CellChangeTimes->{{3.748808259149951*^9, 3.748808263435958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"int\[Theta]TMP", "[", "t_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"eq\[Theta]", "  ", 
     RowBox[{
      RowBox[{"\[Theta]1", "'"}], "[", "t", "]"}]}], ",", "t"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.748808208089076*^9, 3.748808227620104*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
   RowBox[{"a", "+", "b"}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["\[Theta]1", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{{3.74880821246768*^9, 3.748808228334031*^9}, 
   3.7488082645971727`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int\[Theta]", "=", 
  RowBox[{
   RowBox[{"int\[Theta]TMP", "[", "t", "]"}], " ", "-", " ", 
   RowBox[{"int\[Theta]TMP", "[", "0", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.748808235546184*^9, 3.748808243066203*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"g", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Theta]1", "[", "0", "]"}], "]"}]}], 
    RowBox[{"a", "+", "b"}]]}], "+", 
  FractionBox[
   RowBox[{"g", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
   RowBox[{"a", "+", "b"}]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["\[Theta]1", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["\[Theta]1", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{
  3.61284560934161*^9, 3.6162023329418697`*^9, 3.6162077857999907`*^9, 
   3.616208506130743*^9, 3.6162969581532383`*^9, 3.616297036243435*^9, {
   3.748808243382592*^9, 3.748808265818164*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int\[Theta]", "=", 
  RowBox[{"int\[Theta]", " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]1", "[", "0", "]"}], "\[Rule]", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Theta]1", "'"}], "[", "0", "]"}], "\[Rule]", "0"}]}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7488082757655497`*^9, 3.748808298648315*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["g", 
    RowBox[{"a", "+", "b"}]]}], "+", 
  FractionBox[
   RowBox[{"g", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
   RowBox[{"a", "+", "b"}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["\[Theta]1", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{{3.7488082886144323`*^9, 3.748808299173588*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol\[Theta]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"int\[Theta]", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]1", "'"}], "[", "t", "]"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "  ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.748808309069549*^9, 3.748808316580614*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Theta]1", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"g", "-", 
        RowBox[{"g", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}]}]]}], 
     SqrtBox[
      RowBox[{"a", "+", "b"}]]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.612845609786407*^9, 3.616202333492097*^9, 3.616207786411208*^9, 
   3.616208506715253*^9, 3.616296958844026*^9, 3.616297036882926*^9, {
   3.748808306181381*^9, 3.748808316863274*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part c", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"\[Lambda]1Sol", "/.", 
    RowBox[{
     RowBox[{"\[Lambda]", "[", "1", "]"}], "\[Rule]", "0"}]}], "//.", 
   "sol\[Theta]"}]}]], "Input",
 CellChangeTimes->{{3.748808330155458*^9, 3.7488083320594873`*^9}},
 Hyphenation->False],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"g", " ", "m", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"2", " ", "a", " ", "m", " ", 
     RowBox[{"(", 
      RowBox[{"g", "-", 
       RowBox[{"g", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}]}], ")"}]}], 
    RowBox[{"a", "+", "b"}]], "-", 
   FractionBox[
    RowBox[{"2", " ", "b", " ", "m", " ", 
     RowBox[{"(", 
      RowBox[{"g", "-", 
       RowBox[{"g", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}]}], ")"}]}], 
    RowBox[{"a", "+", "b"}]]}]}]], "Output",
 CellChangeTimes->{3.612845609876047*^9, 3.6162023335471077`*^9, 
  3.616207786475807*^9, 3.6162085068027287`*^9, 3.616296958964362*^9, 
  3.616297036985402*^9, 3.748808332587267*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["sol2=Solve[eq1,Cos[\[Theta]1[t]]]  //Simplify//Flatten  ", "Input",
 CellChangeTimes->{{3.748808343171157*^9, 3.748808348392509*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}], "\[Rule]", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6128456101391582`*^9, 3.616202333748577*^9, 3.616207786747466*^9, 
   3.616208506990239*^9, 3.616296959247181*^9, 3.616297037196941*^9, {
   3.7488083364033318`*^9, 3.7488083486272593`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"sol2", "//.", 
        RowBox[{"{", 
         RowBox[{"Rule", "\[Rule]", "Equal"}], "}"}]}], ",", 
       RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
       RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[Rule]", "0"}], "}"}]}], "//", 
    "Normal"}], " ", "//", "Flatten"}]}]], "Input",
 CellChangeTimes->{{3.7488083570644827`*^9, 3.748808379138492*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]1", "[", "t", "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"ArcCos", "[", 
      FractionBox["2", "3"], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"\[Theta]1", "[", "t", "]"}], "\[Rule]", 
    RowBox[{"ArcCos", "[", 
     FractionBox["2", "3"], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.612845617593012*^9, 3.616202341582343*^9, 3.61620779428432*^9, 
   3.6162085143459*^9, 3.6162969674829273`*^9, 3.616297044858965*^9, {
   3.7488083541630983`*^9, 3.748808379757387*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Theta]1", "[", "t", "]"}], "/", "Degree"}], ")"}], "//.", 
   RowBox[{"sol3", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "//", "N"}]], "Input",
 CellChangeTimes->{3.748808393729066*^9}],

Cell[BoxData["48.18968510422141`"], "Output",
 CellChangeTimes->{3.612845617815528*^9, 3.6162023419825363`*^9, 
  3.616207794656653*^9, 3.616208514775897*^9, 3.616296967983535*^9, 
  3.6162970453930693`*^9, 3.748808394063244*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 4: Bead on a Rotating Hoop  ", "Section",
 Evaluatable->False,
 CellChangeTimes->{
  3.612661840152979*^9, {3.61327714658556*^9, 3.613277147448504*^9}, {
   3.614384876875598*^9, 3.614384878059043*^9}, {3.61620857896638*^9, 
   3.616208590741839*^9}, {3.617405100872525*^9, 3.617405101032477*^9}, {
   3.748808901748074*^9, 3.748808903462604*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["Remarks and outline", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["\<\
Lag[qi_,L_ ,Qi_,t_:t] := 
D[ D[L,(D[qi[t],t])],t]-D[L,qi[t]]==Qi;
  
Lag[qi_List,L_,Qi_List,t_:t] :=
(D[ D[L,(D[qi[[#]][t],t])],t]-D[L,qi[[#]][t]]==Qi[[#]]
)&  /@  Range[1,Length[qi]];

Protect[Lag];
\
\>", "Input",
 CellChangeTimes->{{3.7474814075508757`*^9, 3.747481420216249*^9}, {
  3.748808045907548*^9, 3.748808046219252*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 Hyphenation->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part a", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"x2rRule", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]", "[", "#", "]"}], "]"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"\[Omega]", " ", "#"}], "]"}]}], ")"}], "&"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]", "[", "#", "]"}], "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Omega]", " ", "#"}], "]"}]}], ")"}], "&"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"\[Theta]", "[", "#", "]"}], "]"}]}], ")"}], "&"}]}], 
      "}"}]}], "//", "Thread"}]}], ";"}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{"      ", 
  RowBox[{
   RowBox[{"\[Psi]Rule", "=", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Pi]", "-", " ", 
         RowBox[{"\[Psi]", "[", "#", "]"}]}], "&"}], " ", ")"}]}], "}"}]}], 
   ";"}]}]], "Input",
 Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", "m", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["x", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["y", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["z", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}], "//.", 
     "x2rRule"}], " ", "/.", "\[Psi]Rule"}], "//", "Simplify"}]}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "m", " ", 
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Omega]", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"\[Psi]", "[", "t", "]"}], "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["\[Psi]", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.612660194011135*^9, 3.614045813264426*^9, 
  3.616202311827599*^9, 3.616207761209375*^9, 3.616207939885356*^9, 
  3.6162080742063503`*^9, 3.6162084799070683`*^9, 3.616296932787323*^9, 
  3.616297008543542*^9, 3.617405106534504*^9, 3.7488089212040777`*^9, 
  3.7488089760611467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", " ", "g", " ", 
      RowBox[{"z", "[", "t", "]"}]}], "//.", "x2rRule"}], " ", "/.", 
    "\[Psi]Rule"}], "//", "Simplify"}]}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "g"}], " ", "m", " ", "r", " ", 
  RowBox[{"Cos", "[", 
   RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}]], "Output",
 CellChangeTimes->{3.6126601940710907`*^9, 3.614045813338244*^9, 
  3.6162023119387207`*^9, 3.616207761310769*^9, 3.616207939962281*^9, 
  3.616208074384902*^9, 3.616208479921177*^9, 3.616296932883341*^9, 
  3.6162970086472054`*^9, 3.617405106560491*^9, 3.748808922353199*^9, 
  3.748808977161809*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{"L", "=", 
   RowBox[{"(", 
    RowBox[{"T", "-", "V"}], ")"}], " "}]}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "m", " ", "r", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "m", " ", 
   SuperscriptBox["r", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Omega]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"\[Psi]", "[", "t", "]"}], "]"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["\[Psi]", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.612660194082342*^9, 3.614045813398355*^9, 
  3.616202312056007*^9, 3.616207761416278*^9, 3.616207939975418*^9, 
  3.6162080743971252`*^9, 3.616208480113344*^9, 3.61629693298645*^9, 
  3.616297008750492*^9, 3.617405106605216*^9, 3.7488089244194193`*^9, 
  3.74880897787351*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"Lag", "[", 
    RowBox[{"\[Psi]", ",", "L", ",", "0", ",", "t"}], "]"}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.74880899299467*^9, 3.7488090379614143`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"g", "-", 
        RowBox[{"r", " ", 
         SuperscriptBox["\[Omega]", "2"], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}], "+", 
     RowBox[{"r", " ", 
      RowBox[{
       SuperscriptBox["\[Psi]", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{{3.74880901635205*^9, 3.7488090391583357`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{
   FractionBox[
    RowBox[{"eq1", " ", "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"m", " ", "r"}]], "/.", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]", "''"}], "[", "t", "]"}], "\[Rule]", "0"}]}]}]], "Input",\

 CellChangeTimes->{{3.748809317682111*^9, 3.748809354555483*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"g", "-", 
    RowBox[{"r", " ", 
     SuperscriptBox["\[Omega]", "2"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}]}], ")"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.7488093269672127`*^9, 3.7488093549562397`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    FractionBox["eq2", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]], "\[Equal]", "0"}], " ", ",", 
   
   RowBox[{"Cos", "[", 
    RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.748809361307098*^9, 3.748809398937952*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"\[Psi]", "[", "t", "]"}], "]"}], "\[Rule]", 
    FractionBox["g", 
     RowBox[{"r", " ", 
      SuperscriptBox["\[Omega]", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.748809370737013*^9, 3.748809399413477*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{1920, 1003},
WindowMargins->{{3, Automatic}, {-50, Automatic}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 220, 3, 65, "Section"],
Cell[803, 27, 139, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[967, 33, 279, 8, 34, "Input"],
Cell[1249, 43, 260, 7, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1546, 55, 387, 10, 34, "Input"],
Cell[1936, 67, 143, 3, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2116, 75, 524, 14, 34, "Input"],
Cell[2643, 91, 125, 3, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2805, 99, 155, 3, 32, "Input"],
Cell[2963, 104, 178, 5, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3178, 114, 180, 4, 34, "Input"],
Cell[3361, 120, 230, 7, 50, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3640, 133, 272, 4, 65, "Section"],
Cell[3915, 139, 73, 1, 32, "Input"],
Cell[3991, 142, 388, 14, 182, "Input"],
Cell[CellGroupData[{
Cell[4404, 160, 386, 10, 45, "Subsection",
 Evaluatable->False],
Cell[4793, 172, 111, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[4929, 179, 100, 3, 29, "Subsubsection",
 Evaluatable->False],
Cell[5032, 184, 94, 2, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5163, 191, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[5264, 196, 567, 19, 53, "Input"],
Cell[5834, 217, 133, 4, 34, "Input"],
Cell[5970, 223, 75, 2, 33, "Input"],
Cell[6048, 227, 94, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[6167, 233, 68, 2, 32, "Input"],
Cell[6238, 237, 882, 25, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7157, 267, 133, 3, 32, "Input"],
Cell[7293, 272, 370, 8, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7700, 285, 265, 6, 34, "Input"],
Cell[7968, 293, 428, 10, 34, "Output"]
}, Open  ]],
Cell[8411, 306, 301, 10, 34, "Input"],
Cell[CellGroupData[{
Cell[8737, 320, 674, 21, 34, "Input"],
Cell[9414, 343, 348, 7, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9799, 355, 449, 12, 56, "Input"],
Cell[10251, 369, 1825, 48, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12125, 423, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[12226, 428, 156, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[12407, 434, 985, 26, 59, "Input"],
Cell[13395, 462, 1402, 38, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14834, 505, 268, 8, 32, "Input"],
Cell[15105, 515, 506, 13, 50, "Output"]
}, Open  ]],
Cell[15626, 531, 245, 4, 31, "Text"],
Cell[15874, 537, 137, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[16036, 543, 317, 9, 34, "Input"],
Cell[16356, 554, 456, 14, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16849, 573, 242, 5, 32, "Input"],
Cell[17094, 580, 933, 28, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18064, 613, 392, 11, 34, "Input"],
Cell[18459, 626, 506, 16, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19002, 647, 412, 11, 34, "Input"],
Cell[19417, 660, 668, 20, 58, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20134, 686, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[20257, 693, 286, 8, 32, "Input"],
Cell[20546, 703, 883, 24, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21466, 732, 185, 3, 33, "Input"],
Cell[21654, 737, 385, 9, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22076, 751, 583, 16, 34, "Input"],
Cell[22662, 769, 559, 15, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23258, 789, 267, 8, 32, "Input"],
Cell[23528, 799, 229, 3, 32, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23830, 810, 407, 8, 65, "Section",
 Evaluatable->False],
Cell[24240, 820, 111, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[24376, 827, 100, 3, 29, "Subsubsection",
 Evaluatable->False],
Cell[24479, 832, 388, 14, 182, "Input"],
Cell[24870, 848, 94, 2, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25001, 855, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[25102, 860, 944, 29, 34, "Input"],
Cell[26049, 891, 322, 11, 34, "Input"],
Cell[CellGroupData[{
Cell[26396, 906, 725, 22, 53, "Input"],
Cell[27124, 930, 753, 19, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27914, 954, 246, 8, 32, "Input"],
Cell[28163, 964, 454, 9, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28654, 978, 143, 5, 32, "Input"],
Cell[28800, 985, 897, 24, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29734, 1014, 239, 6, 34, "Input"],
Cell[29976, 1022, 657, 19, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30670, 1046, 340, 11, 53, "Input"],
Cell[31013, 1059, 370, 10, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31420, 1074, 348, 10, 56, "Input"],
Cell[31771, 1086, 321, 9, 47, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

