(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79192,       2328]
NotebookOptionsPosition[     71348,       2079]
NotebookOutlinePosition[     71738,       2096]
CellTagsIndexPosition[     71695,       2093]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PhysicalConstants`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7519927467405167`*^9, 3.751992754218946*^9}},
 CellID->482108048],

Cell[CellGroupData[{

Cell["Problem 1:", "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.728777385242381*^9, 3.728777390554167*^9}, {
   3.749297917153379*^9, 3.7492979173329477`*^9}, {3.749297981406815*^9, 
   3.7492979915479727`*^9}, {3.7493032115541763`*^9, 3.749303230548213*^9}, 
   3.749303902260909*^9, {3.749304041872312*^9, 3.749304042018895*^9}, 
   3.7493042552201138`*^9, 3.75131624512796*^9, {3.751992410473874*^9, 
   3.751992410707905*^9}}],

Cell["Part a", "Subsection",
 CellChangeTimes->{{3.751993008021624*^9, 3.7519930146412067`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.73082231275998*^9, 3.7308223176402597`*^9}, 
   3.749303211554613*^9, 3.749303902261362*^9, 3.7493042552203407`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "=", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"2", "\[Pi]", " ", "rad"}], "day"], "*", 
    FractionBox[
     RowBox[{"1", " ", "day"}], 
     RowBox[{"24", " ", "hour"}]], "*", 
    FractionBox[
     RowBox[{"1", " ", "hour"}], 
     RowBox[{
      SuperscriptBox["60", "2"], "sec"}]]}], "//", "N"}]}]], "Input",
 CellChangeTimes->{{3.75199242994941*^9, 3.7519925086988993`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.0000727220521664304`", " ", "rad"}], "sec"]], "Output",
 CellChangeTimes->{{3.751992494738625*^9, 3.7519925088958073`*^9}, 
   3.7519926972421427`*^9, {3.751992958231105*^9, 3.751992967808217*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "=", 
  RowBox[{"w", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rad", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"sec", "\[Rule]", "1"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7519925220374613`*^9, 3.751992538387383*^9}, 
   3.7519929630250187`*^9}],

Cell[BoxData["0.0000727220521664304`"], "Output",
 CellChangeTimes->{{3.751992530591681*^9, 3.751992538635187*^9}, 
   3.7519926981354094`*^9, {3.75199295825228*^9, 3.751992967830504*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Needs", "[", "\"\<PhysicalConstants`\>\"", "]"}], " ", "*)"}], 
  "\[IndentingNewLine]", "EarthRadius"}]], "Input",
 CellChangeTimes->{{3.751992788485177*^9, 3.7519928232270412`*^9}}],

Cell[BoxData[
 RowBox[{"6378140", " ", "Meter"}]], "Output",
 CellChangeTimes->{{3.7519927950825863`*^9, 3.751992816063508*^9}, {
  3.751992958275185*^9, 3.7519929678524733`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{
   FractionBox["EarthRadius", "Meter"], " ", "//", "N", " "}]}]], "Input",
 CellChangeTimes->{{3.7519928255255423`*^9, 3.75199284089408*^9}, 
   3.751992965336381*^9}],

Cell[BoxData["6.37814`*^6"], "Output",
 CellChangeTimes->{{3.751992832272045*^9, 3.751992841459704*^9}, {
  3.751992958306385*^9, 3.751992967876405*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"angle", "=", " ", 
   RowBox[{"33", " ", "Degree"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", "9.8"}], ";"}]}], "Input",
 CellChangeTimes->{{3.751992905477257*^9, 3.751992909309019*^9}, {
  3.751992942108501*^9, 3.751992944152977*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ratio", " ", "=", 
  FractionBox[
   RowBox[{" ", 
    RowBox[{
     SuperscriptBox["w", 
      RowBox[{"2", " "}]], "r", " ", 
     RowBox[{"Sin", "[", "angle", "]"}], 
     RowBox[{"Cos", "[", "angle", "]"}]}]}], "g"]}]], "Input",
 CellChangeTimes->{{3.751992855963786*^9, 3.751992920850197*^9}}],

Cell[BoxData["0.0015721732068386112`"], "Output",
 CellChangeTimes->{
  3.7519928644096413`*^9, {3.751992946643928*^9, 3.751992967912304*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", "ratio", "]"}], "Degree"], " "}]], "Input",
 CellChangeTimes->{{3.751992973138514*^9, 3.751992994564475*^9}}],

Cell[BoxData["0.0900788151986552`"], "Output",
 CellChangeTimes->{{3.751992979384293*^9, 3.751992995374886*^9}}]
}, Open  ]],

Cell["Part b", "Subsection",
 CellChangeTimes->{{3.751993008021624*^9, 3.751993023076572*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "50"}], ";"}]], "Input",
 CellChangeTimes->{{3.751993843526444*^9, 3.7519938469213667`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ratio", "=", " ", 
  RowBox[{
   FractionBox[
    RowBox[{"w", " ", "v"}], "g"], " ", "//", "ScientificForm"}]}]], "Input",
 CellChangeTimes->{{3.7519938492812366`*^9, 3.751993861450284*^9}, {
  3.751994109599268*^9, 3.751994111788582*^9}}],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"3.71031\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"-4\"\>"]}],
   0.000371030878400155,
   AutoDelete->True],
  ScientificForm]], "Output",
 CellChangeTimes->{3.7519938616505404`*^9, 3.751994112247716*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2:", "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.728777385242381*^9, 3.728777390554167*^9}, {
   3.749297917153379*^9, 3.7492979173329477`*^9}, {3.749297981406815*^9, 
   3.7492979915479727`*^9}, {3.7493032115541763`*^9, 3.749303230548213*^9}, 
   3.749303902260909*^9, {3.749304041872312*^9, 3.749304042018895*^9}, 
   3.7493042552201138`*^9, 3.75131624512796*^9}],

Cell["\<\
PROBLEM 2 : A rigid body consists of 4 point masses : 
\tm at (a, 0, 0)
            2 m at (0, a, 0)
            3 m at (0, a, a)
            4 m at (0, a, -a)
Find a) the moment of inertia tensor, b) the principle moments, and c) the \
orthogonal principle axes. 
Note: I suggest you use Mathematica for part of this; but, make sure I can \
follow your notation!!!
\
\>", "Text",
 CellChangeTimes->{{3.751316231034904*^9, 3.751316267690192*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.73082231275998*^9, 3.7308223176402597`*^9}, 
   3.749303211554613*^9, 3.749303902261362*^9, 3.7493042552203407`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"location", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "a", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "a", ",", "a"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "a", ",", 
       RowBox[{"-", "a"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mass", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vx", ",", "vy", ",", "vz"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], ";"}]}], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730627093515736*^9, 3.7306273066538982`*^9}, {
   3.730627349489377*^9, 3.7306273749108963`*^9}, {3.730627459934731*^9, 
   3.730627461957944*^9}, {3.730627970316581*^9, 3.730627971898576*^9}, 
   3.730822975404626*^9, {3.7308230140761747`*^9, 3.730823024955782*^9}, 
   3.7493032115549517`*^9, {3.749303566206276*^9, 3.749303608414768*^9}, {
   3.7493036832903967`*^9, 3.749303684262898*^9}, {3.749303824997427*^9, 
   3.7493038356365767`*^9}, 3.749303902261964*^9, 3.7493042552206306`*^9, {
   3.7513162753549747`*^9, 3.751316285335466*^9}},
 ExpressionUUID -> "b728850f-5aeb-48ed-85a4-f0d33622a664"],

Cell["\<\
Note, we program diagonal and off - diagonal with different formulas below!!!\
\
\>", "Subsubsection",
 CellChangeTimes->{{3.751315281816616*^9, 3.751315300725795*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "term", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"term", "[", 
   RowBox[{"n_", ",", "i_", ",", "i_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"+", 
    RowBox[{"mass", "[", 
     RowBox[{"[", "n", "]"}], "]"}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"location", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ".", 
      RowBox[{"location", "[", 
       RowBox[{"[", "n", "]"}], "]"}]}], "-", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"location", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ".", 
        RowBox[{"v", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "^", "2"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"term", "[", 
   RowBox[{"n_", ",", "i_", ",", "j_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"mass", "[", 
     RowBox[{"[", "n", "]"}], "]"}]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"location", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ".", 
      RowBox[{"v", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"location", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ".", 
      RowBox[{"v", "[", 
       RowBox[{"[", "j", "]"}], "]"}]}]}], ")"}], " "}]}]}], "Input",
 CellChangeTimes->{{3.751313765220957*^9, 3.751313822822054*^9}, {
  3.751313983616338*^9, 3.7513140121748857`*^9}, {3.751314610853696*^9, 
  3.7513146595842*^9}, {3.751315035335071*^9, 3.751315037831375*^9}, {
  3.751315108073556*^9, 3.751315113649384*^9}, {3.751315184387781*^9, 
  3.751315206305036*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"Sum", "[", " ", 
      RowBox[{
       RowBox[{"term", "[", 
        RowBox[{"n", ",", "i", ",", "j"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.7513130008518267`*^9, 3.751313037219721*^9}, {
  3.7513132362105503`*^9, 3.751313241353672*^9}, {3.751313358793824*^9, 
  3.751313358978669*^9}, {3.751313442741427*^9, 3.751313457492725*^9}, {
  3.751315335285386*^9, 3.7513153378498096`*^9}, {3.751994635034933*^9, 
  3.7519946369401217`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"16", " ", 
       SuperscriptBox["a", "2"]}], "0", "0"},
     {"0", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["a", "2"]},
     {"0", 
      SuperscriptBox["a", "2"], 
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751315328077386*^9, 3.751315338216261*^9}, 
   3.751316301712668*^9, 3.751994494576969*^9, 3.751994640040596*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"evec", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Normalize", " ", "/@", " ", 
       RowBox[{"Eigenvectors", "[", "mat", "]"}]}], " ", ")"}], " ", "//", 
     "Simplify"}], "//", "Transpose"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"evec", "//", "MatrixForm", " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Column", " ", "form"}], " ", "*)"}]}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730821578369973*^9, 3.730821588549115*^9}, {
   3.7308217236346188`*^9, 3.730821725570251*^9}, {3.7308217774571753`*^9, 
   3.730821811088728*^9}, {3.730822023885665*^9, 3.730822043103787*^9}, 
   3.730823598673546*^9, 3.749303211558276*^9, 3.749303902265414*^9, 
   3.749304255223737*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}], 
       SqrtBox[
        RowBox[{"4", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"1", "+", 
         SqrtBox["2"]}], 
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SqrtBox["2"]}], ")"}]}]]]}]},
     {"0", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"4", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}]]], 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           SqrtBox["2"]}], ")"}]}]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730822037239191*^9, 3.730822043430469*^9}, 
   3.7308233182091827`*^9, 3.730823599621149*^9, 3.749303211558469*^9, {
   3.749303851382194*^9, 3.749303860214197*^9}, 3.7493039022655487`*^9, 
   3.7493041911754837`*^9, 3.749304255223879*^9, 3.751155592277903*^9, 
   3.751155977349101*^9, 3.7511562194828*^9, 3.751156269934958*^9, 
   3.751316301784737*^9, 3.751994494814817*^9, 3.751994640146315*^9}],

Cell[BoxData[
 RowBox[{"evec", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.7308219602221117`*^9, 3.730821963773776*^9}, 
   3.730823610258027*^9, 3.749303211558662*^9, 3.749303902265677*^9, 
   3.749304255224029*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], 
    SqrtBox[
     RowBox[{"4", "-", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"1", "+", 
      SqrtBox["2"]}], 
     SqrtBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SqrtBox["2"]}], ")"}]}]]]}]}], "}"}]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{
  3.7308219640233173`*^9, 3.730822046183651*^9, 3.7308233182687902`*^9, {
   3.730823606080447*^9, 3.7308236105268593`*^9}, 3.749303211558853*^9, {
   3.749303854229412*^9, 3.749303861272521*^9}, 3.749303902265815*^9, 
   3.749304191182826*^9, 3.749304255224168*^9, 3.751155592448987*^9, 
   3.751155977379986*^9, 3.7511562194991207`*^9, 3.751156269950795*^9, 
   3.751316301802627*^9, 3.7519944948343782`*^9, 3.7519946402150784`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eval", "=", 
   RowBox[{"Eigenvalues", "[", "mat", "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eval", " ", "//", "Simplify"}], "//", "TableForm"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730821578369973*^9, 3.730821602548204*^9}, {
   3.730821726803011*^9, 3.73082172774631*^9}, {3.7308218918391047`*^9, 
   3.73082190531057*^9}, 3.7308236130895233`*^9, 3.749303211559046*^9, 
   3.7493039022659492`*^9, 3.749304255224325*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"16", " ", 
       SuperscriptBox["a", "2"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         SqrtBox["2"]}], ")"}], " ", 
       SuperscriptBox["a", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "9"}], "+", 
          SqrtBox["2"]}], ")"}]}], " ", 
       SuperscriptBox["a", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730821588845236*^9, 3.730821603167632*^9}, 
   3.730821727933222*^9, 3.730821814029463*^9, {3.730821867823512*^9, 
   3.730821905518259*^9}, 3.730822050777878*^9, 3.730823318327104*^9, 
   3.730823613443006*^9, 3.7493032115592403`*^9, {3.7493038554166203`*^9, 
   3.749303862197453*^9}, 3.749303902266081*^9, 3.7493041912309647`*^9, 
   3.74930425522447*^9, 3.7511555925704803`*^9, 3.751155977408083*^9, 
   3.751156219514842*^9, 3.751156269966255*^9, 3.751316301822803*^9, 
   3.7519944949114723`*^9, 3.7519946403024063`*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "evec", "]"}], " ", ".", "mat", ".", " ", 
     "evec"}], " ", "//", "Simplify"}], " ", "//", "MatrixForm"}]}]], "Input",\

 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.7308217312971373`*^9, 3.730821774465857*^9}, {
   3.730821836692533*^9, 3.730821843583868*^9}, {3.730821877871513*^9, 
   3.730821886225801*^9}, 3.730823616324732*^9, 3.749303211559434*^9, 
   3.7493039022662163`*^9, 3.749304255224636*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"16", " ", 
       SuperscriptBox["a", "2"]}], "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "16"}], "+", 
          RowBox[{"7", " ", 
           SqrtBox["2"]}]}], ")"}], " ", 
        SuperscriptBox["a", "2"]}], 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SqrtBox["2"]}]], "0"},
     {"0", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"16", "+", 
          RowBox[{"7", " ", 
           SqrtBox["2"]}]}], ")"}], " ", 
        SuperscriptBox["a", "2"]}], 
       RowBox[{"2", "+", 
        SqrtBox["2"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.7308217361873217`*^9, 3.7308217685015182`*^9}, {
   3.730821843838225*^9, 3.730821886523601*^9}, 3.730822057317048*^9, 
   3.730823318398673*^9, 3.730823616613171*^9, 3.749303211559628*^9, 
   3.7493038633501387`*^9, 3.7493039022663507`*^9, 3.7493041912796288`*^9, 
   3.749304255224781*^9, 3.751155592647423*^9, 3.7511559774376497`*^9, 
   3.751156219530553*^9, 3.751156269984786*^9, 3.751316301857451*^9, 
   3.751994495014802*^9, 3.751994640394286*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "evec", "]"}], " ", ".", " ", "evec"}], " ", "//",
     "Simplify"}], " ", "//", "MatrixForm"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730821939790101*^9, 3.730821939918206*^9}, 
   3.7493032115598516`*^9, 3.749303902266486*^9, 3.749304255224942*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{3.7308219403509283`*^9, 3.7308220611346292`*^9, 
  3.730823318431787*^9, 3.7308236194386387`*^9, 3.749303211560053*^9, 
  3.749303864327981*^9, 3.7493039022666187`*^9, 3.749304191327455*^9, 
  3.749304255225116*^9, 3.7511555927248507`*^9, 3.751155977465613*^9, 
  3.751156219546876*^9, 3.751156269990093*^9, 3.751316301887813*^9, 
  3.7519944951119432`*^9, 3.751994640525379*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3:", "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.728777385242381*^9, 3.728777390554167*^9}, {
   3.749297917153379*^9, 3.7492979173329477`*^9}, {3.749297981406815*^9, 
   3.7492979915479727`*^9}, {3.7493032115541763`*^9, 3.749303230548213*^9}, 
   3.749303902260909*^9, {3.749304041872312*^9, 3.749304042018895*^9}, 
   3.7493042552201138`*^9, 3.75131624512796*^9, 3.75199502902317*^9}],

Cell["PROBLEM 3", "Text",
 CellChangeTimes->{{3.751316231034904*^9, 3.751316267690192*^9}, {
  3.751995034756586*^9, 3.751995035593832*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.73082231275998*^9, 3.7308223176402597`*^9}, 
   3.749303211554613*^9, 3.749303902261362*^9, 3.7493042552203407`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", " ", 
   RowBox[{
    FractionBox["m", "2"], 
    SuperscriptBox["L", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["d\[Phi]1", "2"], "+", 
      SuperscriptBox["d\[Phi]2", "2"]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", 
   RowBox[{
    RowBox[{
     FractionBox["m", "2"], "g", " ", "L", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Phi]1", "2"], "+", 
       SuperscriptBox["\[Phi]2", "2"]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["k", "2"], 
     SuperscriptBox["L", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Phi]1", "-", "\[Phi]2"}], ")"}], "2"]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.751995046592622*^9, 3.751995199538507*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.751995204970748*^9, 3.751995208318707*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["d\[Phi]1", "2"], " ", 
   SuperscriptBox["L", "2"], " ", "m"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["d\[Phi]2", "2"], " ", 
   SuperscriptBox["L", "2"], " ", "m"}]}]], "Output",
 CellChangeTimes->{3.75199520866234*^9, 3.751995867042242*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", " ", "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.751995210324709*^9, 3.7519952120155363`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "k", " ", 
   SuperscriptBox["L", "2"], " ", 
   SuperscriptBox["\[Phi]1", "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "g", " ", "L", " ", "m", " ", 
   SuperscriptBox["\[Phi]1", "2"]}], "-", 
  RowBox[{"k", " ", 
   SuperscriptBox["L", "2"], " ", "\[Phi]1", " ", "\[Phi]2"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "k", " ", 
   SuperscriptBox["L", "2"], " ", 
   SuperscriptBox["\[Phi]2", "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "g", " ", "L", " ", "m", " ", 
   SuperscriptBox["\[Phi]2", "2"]}]}]], "Output",
 CellChangeTimes->{3.7519952125244637`*^9, 3.7519958670676947`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"T", ",", "d\[Phi]1"}], "]"}]], "Input",
 CellChangeTimes->{{3.751995395252586*^9, 3.7519953991338787`*^9}}],

Cell[BoxData[
 RowBox[{"d\[Phi]1", " ", 
  SuperscriptBox["L", "2"], " ", "m"}]], "Output",
 CellChangeTimes->{3.751995399742326*^9, 3.751995867094108*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tmat", "=", 
   RowBox[{"m", " ", 
    SuperscriptBox["L", "2"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.751995223281253*^9, 3.751995305667594*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["L", "2"], " ", "m"}], "0"},
     {"0", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "m"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.751995305939941*^9, 3.75199586709968*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"V", ",", "\[Phi]1"}], "]"}], " ", "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.751995373106505*^9, 3.751995391270322*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", " ", 
   SuperscriptBox["L", "2"], " ", "\[Phi]1"}], "+", 
  RowBox[{"g", " ", "L", " ", "m", " ", "\[Phi]1"}], "-", 
  RowBox[{"k", " ", 
   SuperscriptBox["L", "2"], " ", "\[Phi]2"}]}]], "Output",
 CellChangeTimes->{{3.75199537884556*^9, 3.75199539155072*^9}, 
   3.751995867124778*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"V", ",", "\[Phi]2"}], "]"}], " ", "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.751995373106505*^9, 3.751995391270322*^9}, {
  3.7519954531141872`*^9, 3.751995453215061*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "k"}], " ", 
   SuperscriptBox["L", "2"], " ", "\[Phi]1"}], "+", 
  RowBox[{"k", " ", 
   SuperscriptBox["L", "2"], " ", "\[Phi]2"}], "+", 
  RowBox[{"g", " ", "L", " ", "m", " ", "\[Phi]2"}]}]], "Output",
 CellChangeTimes->{3.7519954536538887`*^9, 3.7519958671518793`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vmat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"k", " ", 
         SuperscriptBox["L", "2"]}], "+", " ", 
        RowBox[{"g", " ", "L", " ", "m"}]}], ",", 
       RowBox[{
        RowBox[{"-", "k"}], " ", 
        SuperscriptBox["L", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "k"}], " ", 
        SuperscriptBox["L", "2"]}], ",", 
       RowBox[{
        RowBox[{"k", " ", 
         SuperscriptBox["L", "2"]}], "+", " ", 
        RowBox[{"g", " ", "L", " ", "m"}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Vmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.751995223281253*^9, 3.751995337525207*^9}, {
  3.7519954299376593`*^9, 3.751995477960826*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"k", " ", 
        SuperscriptBox["L", "2"]}], "+", 
       RowBox[{"g", " ", "L", " ", "m"}]}], 
      RowBox[{
       RowBox[{"-", "k"}], " ", 
       SuperscriptBox["L", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", "k"}], " ", 
       SuperscriptBox["L", "2"]}], 
      RowBox[{
       RowBox[{"k", " ", 
        SuperscriptBox["L", "2"]}], "+", 
       RowBox[{"g", " ", "L", " ", "m"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.751995305939941*^9, 3.7519954785402203`*^9, 
  3.7519958671802397`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Vmat", " ", "-", " ", 
    RowBox[{"w2", " ", "Tmat"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.751995498641375*^9, 3.751995516255644*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"k", " ", 
        SuperscriptBox["L", "2"]}], "+", 
       RowBox[{"g", " ", "L", " ", "m"}], "-", 
       RowBox[{
        SuperscriptBox["L", "2"], " ", "m", " ", "w2"}]}], 
      RowBox[{
       RowBox[{"-", "k"}], " ", 
       SuperscriptBox["L", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", "k"}], " ", 
       SuperscriptBox["L", "2"]}], 
      RowBox[{
       RowBox[{"k", " ", 
        SuperscriptBox["L", "2"]}], "+", 
       RowBox[{"g", " ", "L", " ", "m"}], "-", 
       RowBox[{
        SuperscriptBox["L", "2"], " ", "m", " ", "w2"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751995507048911*^9, 3.751995516463338*^9}, 
   3.75199586720604*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol0", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", "mat", "]"}], "\[Equal]", "0"}], ",", "w2"}], "]"}],
    " ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.751995518265297*^9, 3.751995573247109*^9}, {
  3.751995747843231*^9, 3.7519957480295897`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w2", "\[Rule]", 
     FractionBox["g", "L"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w2", "\[Rule]", 
     RowBox[{
      FractionBox["g", "L"], "+", 
      FractionBox[
       RowBox[{"2", " ", "k"}], "m"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7519955285615187`*^9, 3.7519955737708387`*^9}, 
   3.751995748797729*^9, 3.751995867234171*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "/.", 
  RowBox[{"sol0", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7519956284581413`*^9, 3.7519956318039913`*^9}, {
  3.751995804408655*^9, 3.751995804619588*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", " ", 
      SuperscriptBox["L", "2"]}], ",", 
     RowBox[{
      RowBox[{"-", "k"}], " ", 
      SuperscriptBox["L", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "k"}], " ", 
      SuperscriptBox["L", "2"]}], ",", 
     RowBox[{"k", " ", 
      SuperscriptBox["L", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7519956320725946`*^9, 3.751995805076123*^9, 
  3.751995867259444*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"mat", " ", "/.", 
       RowBox[{"sol0", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], " ", "//", "Thread"}]}]], "Input",
 CellChangeTimes->{{3.7519956284581413`*^9, 3.751995676932434*^9}, {
  3.751995751493279*^9, 3.751995751754558*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "k", " ", 
      SuperscriptBox["L", "2"]}], "-", 
     RowBox[{"b", " ", "k", " ", 
      SuperscriptBox["L", "2"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", "k", " ", 
      SuperscriptBox["L", "2"]}], "+", 
     RowBox[{"b", " ", "k", " ", 
      SuperscriptBox["L", "2"]}]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7519956320725946`*^9, {3.751995666365941*^9, 3.751995677350197*^9}, 
   3.751995752059973*^9, 3.751995867286326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]}]], "Input",
 CellChangeTimes->{{3.751995697222991*^9, 3.751995707059964*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{3.751995709931355*^9, 3.7519958673117456`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"eq1", ",", 
      RowBox[{"{", "norm", "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.751995677973612*^9, 3.751995718353717*^9}, {
  3.7519957593041897`*^9, 3.751995761539887*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.751995682110798*^9, 3.751995684555643*^9}, 
   3.751995718993786*^9, 3.751995761806212*^9, 3.7519958673422527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eVec1", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", 
   RowBox[{"sol1", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7519957352098637`*^9, 3.751995766387706*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   FractionBox["1", 
    SqrtBox["2"]]}], "}"}]], "Output",
 CellChangeTimes->{3.751995766639244*^9, 3.7519958673689013`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "/.", 
  RowBox[{"sol0", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7519956284581413`*^9, 3.7519956318039913`*^9}, {
  3.7519957959558907`*^9, 3.751995798452466*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"k", " ", 
       SuperscriptBox["L", "2"]}], "+", 
      RowBox[{"g", " ", "L", " ", "m"}], "-", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["g", "L"], "+", 
         FractionBox[
          RowBox[{"2", " ", "k"}], "m"]}], ")"}], " ", "m"}]}], ",", 
     RowBox[{
      RowBox[{"-", "k"}], " ", 
      SuperscriptBox["L", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "k"}], " ", 
      SuperscriptBox["L", "2"]}], ",", 
     RowBox[{
      RowBox[{"k", " ", 
       SuperscriptBox["L", "2"]}], "+", 
      RowBox[{"g", " ", "L", " ", "m"}], "-", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["g", "L"], "+", 
         FractionBox[
          RowBox[{"2", " ", "k"}], "m"]}], ")"}], " ", "m"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7519956320725946`*^9, 3.751995799477655*^9, 
  3.7519958673953257`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"mat", " ", "/.", 
       RowBox[{"sol0", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ")"}], ".", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], " ", "//", "Thread"}]}]], "Input",
 CellChangeTimes->{{3.7519956284581413`*^9, 3.751995676932434*^9}, {
  3.751995751493279*^9, 3.751995751754558*^9}, {3.751995812365615*^9, 
  3.7519958214606037`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], " ", "k", " ", 
      SuperscriptBox["L", "2"]}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", " ", 
         SuperscriptBox["L", "2"]}], "+", 
        RowBox[{"g", " ", "L", " ", "m"}], "-", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["g", "L"], "+", 
           FractionBox[
            RowBox[{"2", " ", "k"}], "m"]}], ")"}], " ", "m"}]}], ")"}]}]}], 
    "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", "k", " ", 
      SuperscriptBox["L", "2"]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", " ", 
         SuperscriptBox["L", "2"]}], "+", 
        RowBox[{"g", " ", "L", " ", "m"}], "-", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["g", "L"], "+", 
           FractionBox[
            RowBox[{"2", " ", "k"}], "m"]}], ")"}], " ", "m"}]}], ")"}]}]}], 
    "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7519956320725946`*^9, {3.751995666365941*^9, 3.751995677350197*^9}, 
   3.751995752059973*^9, {3.751995813079174*^9, 3.751995823045475*^9}, 
   3.75199586742039*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]}]], "Input",
 CellChangeTimes->{{3.751995697222991*^9, 3.751995707059964*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{3.751995709931355*^9, 3.751995816025223*^9, 
  3.751995867445179*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"eq2", ",", 
      RowBox[{"{", "norm", "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.751995677973612*^9, 3.751995718353717*^9}, {
  3.7519957593041897`*^9, 3.751995761539887*^9}, {3.751995825454317*^9, 
  3.7519958286048717`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.751995682110798*^9, 3.751995684555643*^9}, 
   3.751995718993786*^9, 3.751995761806212*^9, 3.7519958289494667`*^9, 
   3.751995867477667*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eVec2", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", 
   RowBox[{"sol2", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7519957352098637`*^9, 3.751995766387706*^9}, {
  3.751995835887163*^9, 3.75199586076936*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.751995766639244*^9, 3.7519958365185966`*^9, 
  3.751995867482629*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"evec", "=", 
   RowBox[{"{", 
    RowBox[{"eVec1", ",", "eVec2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"evec", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.751995839614718*^9, 3.751995855235846*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", 
       SqrtBox["2"]], 
      FractionBox["1", 
       SqrtBox["2"]]},
     {
      FractionBox["1", 
       SqrtBox["2"]], 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751995855517796*^9, 3.751995867508109*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "evec", "]"}], " ", ".", " ", "evec"}], " ", "//",
     "Simplify"}], " ", "//", "MatrixForm"}]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.730821939790101*^9, 3.730821939918206*^9}, 
   3.7493032115598516`*^9, 3.749303902266486*^9, 3.749304255224942*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{3.7308219403509283`*^9, 3.7308220611346292`*^9, 
  3.730823318431787*^9, 3.7308236194386387`*^9, 3.749303211560053*^9, 
  3.749303864327981*^9, 3.7493039022666187`*^9, 3.749304191327455*^9, 
  3.749304255225116*^9, 3.7511555927248507`*^9, 3.751155977465613*^9, 
  3.751156219546876*^9, 3.751156269990093*^9, 3.751316301887813*^9, 
  3.7519944951119432`*^9, 3.751994640525379*^9, 3.751995867532916*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"evec", ".", "Tmat", ".", 
    RowBox[{"Transpose", "[", "evec", "]"}]}], "//", "Simplify"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7519958766026363`*^9, 3.751995897329926*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["L", "2"], " ", "m"}], "0"},
     {"0", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "m"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751995883356187*^9, 3.751995897839628*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"evec", ".", "Vmat", ".", 
    RowBox[{"Transpose", "[", "evec", "]"}]}], "//", "Simplify"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.7519958766026363`*^9, 3.751995900117765*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"g", " ", "L", " ", "m"}], "0"},
     {"0", 
      RowBox[{"L", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k", " ", "L"}], "+", 
         RowBox[{"g", " ", "m"}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751995883356187*^9, 3.751995900398086*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 5:", "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.728777385242381*^9, 3.728777390554167*^9}, {
   3.749297917153379*^9, 3.7492979173329477`*^9}, {3.749297981406815*^9, 
   3.7492979915479727`*^9}, {3.7493032115541763`*^9, 3.749303230548213*^9}, 
   3.749303902260909*^9, {3.749304041872312*^9, 3.749304042018895*^9}, 
   3.7493042552201138`*^9, 3.75131624512796*^9, 3.7513163582858562`*^9}],

Cell[TextData[{
 "\nPROBLEM 5:  \na) (This is modeled from Example 14.2 in the text.)  10^6 \
neutrons are fired through a gold foil 0.1mm thick. Take the gold nucleus \
cross section to be 98.7 barns.  How many neutrons will be scattered.  The  \
specific gravity of gold is 19.32. \n\nb) (This is modeled from Example 14.5 \
in the text.)  Using what you learned in Example 14.5, find the fraction of \
the scattered neutrons that are scattered within 10 degrees of the source; \
that is between angles 170 and 190 degrees. [Think]\n",
 StyleBox["\nAMU of Gold is 197",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",
 CellChangeTimes->{{3.751316231034904*^9, 3.751316267690192*^9}, {
   3.7513164035270576`*^9, 3.751316406887678*^9}, 3.751316469702598*^9, {
   3.751316606240615*^9, 3.751316610531768*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.73082231275998*^9, 3.7308223176402597`*^9}, 
   3.749303211554613*^9, 3.749303902261362*^9, 3.7493042552203407`*^9}],

Cell["Part a)", "Subsection",
 CellChangeTimes->{{3.75131668157434*^9, 3.751316685477476*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nIncident", "=", 
   SuperscriptBox["10", "6"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thick", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "4"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sig", "=", 
   RowBox[{"98.7", " ", "*", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "28"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"density", "=", 
   RowBox[{"19.32", "*", 
    SuperscriptBox["10", "3"]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.751316420801817*^9, 3.751316456680399*^9}, {
  3.751316489888535*^9, 3.751316513799993*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mass", "=", 
   RowBox[{"197", " ", "*", "1.667", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "27"}]]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.751316544571125*^9, 3.751316552639162*^9}, {
  3.7513166251322947`*^9, 3.75131663449977*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nTarget", "=", 
  FractionBox[
   RowBox[{"density", " ", "thick"}], "mass"]}]], "Input",
 CellChangeTimes->{{3.7513165064689207`*^9, 3.751316538303939*^9}}],

Cell[BoxData["5.883087341922479`*^24"], "Output",
 CellChangeTimes->{3.7513166371468973`*^9, 3.751318311732085*^9, 
  3.752003921693274*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nScattered", " ", "=", " ", 
  RowBox[{"nIncident", " ", "nTarget", " ", "sig"}]}]], "Input",
 CellChangeTimes->{{3.7513166446937647`*^9, 3.75131666677326*^9}}],

Cell[BoxData["58066.07206477488`"], "Output",
 CellChangeTimes->{3.751316667517688*^9, 3.751318311816779*^9, 
  3.752003921709958*^9}]
}, Open  ]],

Cell["Part b)", "Subsection",
 CellChangeTimes->{{3.75131668157434*^9, 3.7513166948556337`*^9}}],

Cell[TextData[{
 "Assuming the gold  nucleus acts as a hard  sphere, then the scattering is \
isotropic. [This is not correct, but I' ll save the more difficult Rutherford \
scattering problem for the homework.] We thus need to find the solid angle \
that covers the 10-degree cone around the backward region. The  total cross \
section is given by:\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "=", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["d\[Sigma]", "d\[CapitalOmega]"], "d\[CapitalOmega]"}]}], 
     "=", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Integral]", "0"], "\[Pi]"], 
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "d\[Theta]", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Integral]", "0"], 
         RowBox[{"2", "\[Pi]"}]], "d\[Phi]"}]}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\nWe just  want the part from 170-degrees to 180-degrees: \n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Integral]", 
      SubscriptBox["\[Theta]", "170"]], 
     SubscriptBox["\[Theta]", "180"]], "  ", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "d\[Theta]", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Integral]", "0"], 
       RowBox[{"2", "\[Pi]"}]], "d\[Phi]"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n"
}], "Text",
 CellChangeTimes->{{3.751316718582075*^9, 3.7513167190146723`*^9}, {
  3.751316766451149*^9, 3.751316779357246*^9}, {3.751316832879019*^9, 
  3.751316839810429*^9}, {3.751316966780426*^9, 3.7513173190201283`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Pi]", " "}], "Degree"], " ", "//", "N"}]], "Input",
 CellChangeTimes->{{3.751317329343659*^9, 3.7513173474614677`*^9}, {
  3.7513173828129787`*^9, 3.7513174036359377`*^9}}],

Cell[BoxData["180.`"], "Output",
 CellChangeTimes->{{3.7513173893993273`*^9, 3.7513174070965548`*^9}, 
   3.751318311906075*^9, 3.752003921727187*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"180", " ", "Degree"}], " ", "//", "N"}]], "Input",
 CellChangeTimes->{{3.751317454567554*^9, 3.751317461770636*^9}}],

Cell[BoxData["3.141592653589793`"], "Output",
 CellChangeTimes->{{3.7513174581231422`*^9, 3.751317461959949*^9}, 
   3.751318311993881*^9, 3.752003921744687*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Theta]1", "=", 
  RowBox[{"170", " ", "Degree", " "}]}]], "Input",
 CellChangeTimes->{{3.75131755318353*^9, 3.751317566316449*^9}}],

Cell[BoxData[
 RowBox[{"170", " ", "\[Degree]"}]], "Output",
 CellChangeTimes->{{3.751317560740403*^9, 3.7513175668316717`*^9}, 
   3.75131831207773*^9, 3.752003921759841*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"int", "[", "\[Theta]_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "\[Theta]", ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", "0", ",", 
      RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.751317504218316*^9, 3.751317543541173*^9}, {
  3.751317580885393*^9, 3.7513175880212307`*^9}, {3.7513176457899637`*^9, 
  3.75131770287605*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.751317588319634*^9, {3.751317654506235*^9, 3.751317711245302*^9}, 
   3.751318312223201*^9, 3.752003921909977*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.7513177538989697`*^9, 3.7513177560423727`*^9}}],

Cell[BoxData[
 RowBox[{"4", " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{3.751317756357709*^9, 3.751318312300795*^9, 
  3.752003921927495*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int", "[", "\[Pi]", "]"}]], "Input",
 CellChangeTimes->{{3.751317760172871*^9, 3.7513177637180853`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.75131776424142*^9, 3.751318312392209*^9, 
  3.7520039219440527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"value170", "=", 
  FractionBox[
   RowBox[{"int", "[", 
    RowBox[{"170.", " ", "Degree"}], "]"}], 
   RowBox[{"4", "\[Pi]"}]], " "}]], "Input",
 CellChangeTimes->{{3.7513184343313303`*^9, 3.751318448186797*^9}, {
  3.751318622137115*^9, 3.751318622853099*^9}, {3.7513187101864347`*^9, 
  3.751318710729782*^9}}],

Cell[BoxData["0.00759612349389599`"], "Output",
 CellChangeTimes->{{3.75131844182832*^9, 3.751318448862357*^9}, 
   3.751318628130291*^9, 3.751318711017173*^9, 3.7520039219607897`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"int", "[", 
     RowBox[{"\[Theta]", " ", "Degree"}], " ", "]"}], 
    RowBox[{"4", "\[Pi]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", "180"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "180", ",", "30"}], "}"}]}], "]"}], ",", 
      " ", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.751317692522833*^9, 3.751317740583737*^9}, {
  3.751317778513501*^9, 3.751317816758596*^9}, {3.7513183061762257`*^9, 
  3.751318308511552*^9}, {3.751318741199708*^9, 3.751318753862689*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Ak0VdsbAHAkGcvwzJHh8v6U6F5EybdNicxJ5sd1SZ6ZdEOGpEERUmky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       "]]},
     Annotation[#, "Charting`Private`Tag$20998#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 180}, {0., 0.9999999999999989}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {30, 
      FormBox["30", TraditionalForm]}, {60, 
      FormBox["60", TraditionalForm]}, {90, 
      FormBox["90", TraditionalForm]}, {120, 
      FormBox["120", TraditionalForm]}, {150, 
      FormBox["150", TraditionalForm]}, {180, 
      FormBox["180", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{{3.751317735864493*^9, 3.751317740899704*^9}, {
   3.751317789965233*^9, 3.7513178170305653`*^9}, 3.751318312555622*^9, {
   3.75131874659577*^9, 3.751318754309177*^9}, 3.7520039221542473`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "150", ",", "180", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"int", "[", 
     RowBox[{"\[Theta]", " ", "Degree"}], " ", "]"}], 
    RowBox[{"4", "\[Pi]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "165", ",", "180"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"tab", ",", " ", "Automatic"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"tab", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "value170"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"180", ",", "value170"}], "}"}]}], "}"}], "]"}]}], 
     "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.751317692522833*^9, 3.751317740583737*^9}, {
  3.751317778513501*^9, 3.751317840075845*^9}, {3.75131832019104*^9, 
  3.7513183406308537`*^9}, {3.751318373785075*^9, 3.7513184103453083`*^9}, {
  3.751318607946134*^9, 3.7513186099885*^9}, {3.7513186569531183`*^9, 
  3.751318720004911*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwl0Qk4VOsfB/BJoZq4ihola9fSbkpS6v0d2yhJQoiyzljKlrmIjDEamhiM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       "]]},
     Annotation[#, "Charting`Private`Tag$21058#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{165., 0},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[1, 0, 0], 
    Thickness[Large], 
    LineBox[{{0, 0.00759612349389599}, {180, 0.00759612349389599}}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{150, 155, 160, 165, 170, 175, 180}, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{165, 180}, {0., 0.01703708616405092}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{{{150, 
      FormBox["150", TraditionalForm]}, {155, 
      FormBox["155", TraditionalForm]}, {160, 
      FormBox["160", TraditionalForm]}, {165, 
      FormBox["165", TraditionalForm]}, {170, 
      FormBox["170", TraditionalForm]}, {175, 
      FormBox["175", TraditionalForm]}, {180, 
      FormBox["180", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{{3.751317735864493*^9, 3.751317740899704*^9}, {
   3.751317789965233*^9, 3.75131784033428*^9}, {3.751318312769004*^9, 
   3.7513183411540422`*^9}, {3.751318386867633*^9, 3.7513184107639637`*^9}, 
   3.751318610533599*^9, {3.751318678651335*^9, 3.7513187202394133`*^9}, 
   3.752003922200664*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", 
      FractionBox[
       RowBox[{"int", "[", 
        RowBox[{"\[Theta]", " ", "Degree"}], "]"}], 
       RowBox[{"4.", "\[Pi]"}]], ",", 
      RowBox[{
       FractionBox[
        RowBox[{"int", "[", 
         RowBox[{"\[Theta]", " ", "Degree"}], "]"}], 
        RowBox[{"4.", "\[Pi]"}]], "nScattered"}]}], "}"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "180", ",", "10"}], "}"}]}], "]"}], 
  " ", "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.7513184343313303`*^9, 3.751318448186797*^9}, {
  3.7513184937224913`*^9, 3.751318531328718*^9}, {3.752003899381485*^9, 
  3.752003914944841*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "1.`", "58066.07206477488`"},
    {"10", "0.9924038765061041`", "57624.99501056539`"},
    {"20", "0.9698463103929542`", "56315.16575103331`"},
    {"30", "0.9330127018922193`", "54176.38278542393`"},
    {"40", "0.883022221559489`", "51273.6319518709`"},
    {"50", "0.8213938048432696`", "47695.11186558893`"},
    {"60", "0.75`", "43549.554048581165`"},
    {"70", "0.6710100716628343`", "38962.919177363896`"},
    {"80", "0.5868240888334652`", "34074.569831549845`"},
    {"90", "0.5`", "29033.03603238744`"},
    {"100", "0.41317591116653485`", "23991.502233225037`"},
    {"110", "0.32898992833716567`", "19103.152887410986`"},
    {"120", "0.25`", "14516.51801619372`"},
    {"130", "0.17860619515673037`", "10370.960199185953`"},
    {"140", "0.116977778440511`", "6792.440112903981`"},
    {"150", "0.0669872981077807`", "3889.6892793509523`"},
    {"160", "0.030153689607045786`", "1750.906313741574`"},
    {"170", "0.00759612349389599`", "441.0770542094941`"},
    {"180", "0.`", "0.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751318515869357*^9, 3.75131853173223*^9}, {
  3.752003915845599*^9, 3.752003922231859*^9}}]
}, Open  ]]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{1914, 999},
WindowMargins->{{1, Automatic}, {5, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 171, 3, 53, "Input",
 CellID->482108048],
Cell[CellGroupData[{
Cell[754, 27, 473, 7, 96, "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[1230, 36, 96, 1, 67, "Subsection"],
Cell[1329, 39, 267, 4, 42, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[CellGroupData[{
Cell[1621, 47, 421, 13, 80, "Input"],
Cell[2045, 62, 238, 4, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2320, 71, 291, 8, 48, "Input"],
Cell[2614, 81, 188, 2, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2839, 88, 241, 5, 86, "Input"],
Cell[3083, 95, 179, 3, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3299, 103, 212, 5, 77, "Input"],
Cell[3514, 110, 153, 2, 48, "Output"]
}, Open  ]],
Cell[3682, 115, 293, 7, 82, "Input"],
Cell[CellGroupData[{
Cell[4000, 126, 322, 9, 84, "Input"],
Cell[4325, 137, 142, 2, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4504, 144, 174, 4, 81, "Input"],
Cell[4681, 150, 112, 1, 48, "Output"]
}, Open  ]],
Cell[4808, 154, 94, 1, 67, "Subsection"],
Cell[4905, 157, 136, 3, 37, "Input"],
Cell[CellGroupData[{
Cell[5066, 164, 264, 6, 76, "Input"],
Cell[5333, 172, 271, 8, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5653, 186, 423, 6, 73, "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[6079, 194, 456, 12, 245, "Text"],
Cell[6538, 208, 267, 4, 53, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[6808, 214, 1749, 42, 247, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[8560, 258, 178, 4, 53, "Subsubsection"],
Cell[8741, 264, 1611, 47, 104, "Input"],
Cell[CellGroupData[{
Cell[10377, 315, 863, 21, 82, "Input"],
Cell[11243, 338, 979, 28, 131, "Output"]
}, Open  ]],
Cell[12237, 369, 784, 17, 82, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[13024, 388, 1788, 53, 209, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[14815, 443, 299, 6, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[15117, 451, 962, 27, 120, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[16082, 480, 536, 11, 82, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[16621, 493, 1547, 42, 145, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[18171, 537, 536, 12, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[18710, 551, 1739, 48, 175, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[20452, 601, 397, 9, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[20852, 612, 1071, 25, 122, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[21960, 642, 444, 6, 73, "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[22407, 650, 140, 2, 45, "Text"],
Cell[22550, 654, 267, 4, 53, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[22820, 660, 784, 27, 136, "Input"],
Cell[CellGroupData[{
Cell[23629, 691, 121, 2, 48, "Input"],
Cell[23753, 695, 357, 10, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24147, 710, 128, 2, 48, "Input"],
Cell[24278, 714, 682, 18, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24997, 737, 152, 3, 48, "Input"],
Cell[25152, 742, 155, 3, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25344, 750, 425, 13, 82, "Input"],
Cell[25772, 765, 760, 22, 100, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26569, 792, 184, 4, 48, "Input"],
Cell[26756, 798, 327, 8, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27120, 811, 235, 5, 48, "Input"],
Cell[27358, 818, 324, 8, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27719, 831, 848, 26, 86, "Input"],
Cell[28570, 859, 1082, 33, 100, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29689, 897, 270, 6, 82, "Input"],
Cell[29962, 905, 1238, 37, 100, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31237, 947, 337, 9, 48, "Input"],
Cell[31577, 958, 431, 13, 91, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32045, 976, 231, 5, 48, "Input"],
Cell[32279, 983, 522, 18, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32838, 1006, 488, 14, 48, "Input"],
Cell[33329, 1022, 604, 18, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33970, 1045, 224, 6, 48, "Input"],
Cell[34197, 1053, 196, 5, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34430, 1063, 367, 10, 48, "Input"],
Cell[34800, 1075, 653, 22, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35490, 1102, 256, 7, 48, "Input"],
Cell[35749, 1111, 211, 7, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35997, 1123, 233, 5, 48, "Input"],
Cell[36233, 1130, 1097, 37, 94, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37367, 1172, 539, 15, 48, "Input"],
Cell[37909, 1189, 1385, 44, 94, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39331, 1238, 224, 6, 48, "Input"],
Cell[39558, 1246, 219, 6, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39814, 1257, 418, 11, 48, "Input"],
Cell[40235, 1270, 679, 23, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40951, 1298, 304, 8, 48, "Input"],
Cell[41258, 1308, 257, 9, 97, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41552, 1322, 263, 6, 82, "Input"],
Cell[41818, 1330, 843, 27, 122, "Output"]
}, Open  ]],
Cell[42676, 1360, 397, 9, 48, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[43076, 1371, 1061, 24, 94, "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[CellGroupData[{
Cell[44162, 1399, 247, 6, 48, "Input"],
Cell[44412, 1407, 763, 22, 100, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45212, 1434, 247, 6, 48, "Input"],
Cell[45462, 1442, 842, 24, 94, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46353, 1472, 447, 6, 73, "Section",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[46803, 1480, 805, 13, 273, "Text"],
Cell[47611, 1495, 267, 4, 53, "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[47881, 1501, 94, 1, 67, "Subsection"],
Cell[47978, 1504, 621, 18, 137, "Input"],
Cell[48602, 1524, 280, 7, 48, "Input"],
Cell[CellGroupData[{
Cell[48907, 1535, 181, 4, 77, "Input"],
Cell[49091, 1541, 140, 2, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49268, 1548, 184, 3, 48, "Input"],
Cell[49455, 1553, 134, 2, 70, "Output"]
}, Open  ]],
Cell[49604, 1558, 96, 1, 67, "Subsection"],
Cell[49703, 1561, 1636, 43, 206, "Text"],
Cell[CellGroupData[{
Cell[51364, 1608, 225, 5, 75, "Input"],
Cell[51592, 1615, 150, 2, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51779, 1622, 151, 3, 48, "Input"],
Cell[51933, 1627, 161, 2, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52131, 1634, 157, 3, 48, "Input"],
Cell[52291, 1639, 175, 3, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52503, 1647, 539, 13, 48, "Input"],
Cell[53045, 1662, 289, 7, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53371, 1674, 126, 2, 48, "Input"],
Cell[53500, 1678, 143, 3, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53680, 1686, 128, 2, 48, "Input"],
Cell[53811, 1690, 118, 2, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53966, 1697, 337, 8, 78, "Input"],
Cell[54306, 1707, 184, 2, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54527, 1714, 774, 20, 126, "Input"],
Cell[55304, 1736, 6817, 127, 370, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62158, 1868, 1464, 39, 260, "Input"],
Cell[63625, 1909, 5291, 104, 359, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68953, 2018, 737, 20, 78, "Input"],
Cell[69693, 2040, 1627, 35, 570, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

