(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    200926,       5514]
NotebookOptionsPosition[    188619,       5089]
NotebookOutlinePosition[    188983,       5105]
CellTagsIndexPosition[    188940,       5102]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Problem #1)", "Section",
 CellChangeTimes->{{3.749321821140115*^9, 3.7493218270339613`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.749321830601275*^9, 3.749321836628338*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"T", "=", 
   RowBox[{
    FractionBox["1", "2"], "m", " ", 
    RowBox[{"b", "^", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d\[Theta]1", "^", "2"}], "+", 
      RowBox[{"d\[Theta]2", "^", "2"}], "+", 
      RowBox[{"d\[Theta]3", "^", "2"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.74932107706453*^9, 3.74932108533461*^9}, {
  3.74932232573177*^9, 3.7493223282229567`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["b", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["d\[Theta]1", "2"], "+", 
    SuperscriptBox["d\[Theta]2", "2"], "+", 
    SuperscriptBox["d\[Theta]3", "2"]}], ")"}], " ", "m"}]], "Output",
 CellChangeTimes->{
  3.749321086078352*^9, 3.749321838963299*^9, {3.749322232490766*^9, 
   3.7493222490130367`*^9}, 3.7493223752576036`*^9, 3.752323610243882*^9, 
   3.752323649561789*^9, 3.752323746017694*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], "k", " ", 
    RowBox[{"b", "^", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Theta]1", "-", "\[Theta]2"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Theta]2", "-", "\[Theta]3"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Theta]3", "-", "\[Theta]1"}], ")"}], "^", "2"}]}], ")"}]}],
    " ", "//", "Expand"}]}]], "Input",
 CellChangeTimes->{{3.749321083580853*^9, 3.749321083581294*^9}, {
  3.749322335951129*^9, 3.749322339547496*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", 
   SuperscriptBox["\[Theta]1", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", "\[Theta]1", " ", "\[Theta]2"}], 
  "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", 
   SuperscriptBox["\[Theta]2", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", "\[Theta]1", " ", "\[Theta]3"}], 
  "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", "\[Theta]2", " ", "\[Theta]3"}], 
  "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", 
   SuperscriptBox["\[Theta]3", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.74932108944025*^9, 3.749321838996352*^9, {3.749322232512086*^9, 
   3.749322249028737*^9}, 3.749322375290928*^9, 3.752323611394206*^9, 
   3.75232364963437*^9, 3.752323746090497*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"T", ",", "d\[Theta]1"}], "]"}]], "Input",
 CellChangeTimes->{{3.7523236130177183`*^9, 3.752323618046815*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["b", "2"], " ", "d\[Theta]1", " ", "m"}]], "Output",
 CellChangeTimes->{3.752323618779804*^9, 3.752323649706098*^9, 
  3.752323746162969*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tmat", "=", 
   RowBox[{"m", " ", 
    RowBox[{"b", "^", "2"}], " ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.7493211011181173`*^9, 3.7493211127788353`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["b", "2"], " ", "m"}], "0", "0"},
     {"0", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "m"}], "0"},
     {"0", "0", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "m"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.749321102769998*^9, 3.749321113123559*^9}, 
   3.749321839028906*^9, {3.749322232533512*^9, 3.7493222490446777`*^9}, 
   3.749322375325246*^9, 3.752323649779128*^9, 3.7523237462360153`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "\[Theta]1"}], "]"}]], "Input",
 CellChangeTimes->{{3.752323623406663*^9, 3.752323631438547*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["b", "2"], " ", "k", " ", "\[Theta]1"}], "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", "\[Theta]2"}], "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", "k", " ", "\[Theta]3"}]}]], "Output",
 CellChangeTimes->{{3.7523236317242193`*^9, 3.752323649852818*^9}, 
   3.7523237463103447`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vmat", "=", 
   RowBox[{"k", " ", 
    RowBox[{"b", "^", "2"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"Vmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321119969179*^9, 3.749321121327619*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", "k"}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", "k"}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", "k"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7493211218063717`*^9, 3.7493218390625896`*^9, {3.749322232555344*^9, 
   3.7493222490640173`*^9}, 3.7493223753556423`*^9, 3.752323649926118*^9, 
   3.752323746383006*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", " ", 
   RowBox[{"Vmat", "-", 
    RowBox[{"Tmat", " ", "\[Omega]2"}]}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321147606707*^9, 3.7493211476072903`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "k"}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749321148838374*^9, 3.749321839090378*^9, {3.749322232578562*^9, 
   3.749322249085602*^9}, 3.7493223753817043`*^9, 3.7523236499982653`*^9, 
   3.7523237464554453`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", "mat", "]"}], " ", "==", "0"}], ",", "\[Omega]2"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.749321154612245*^9, 3.7493211546128817`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", "k"}], "m"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", "k"}], "m"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493211556547318`*^9, 3.74932138678651*^9, 3.749321839114006*^9, {
   3.749322232609325*^9, 3.7493222491092377`*^9}, 3.749322375408472*^9, 
   3.752323650206521*^9, 3.752323746537819*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"eq1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"mat", " ", ".", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], " ", "==", "0"}], " ", "//",
       "Thread"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"eq1", " ", "//", "Column"}]}]}]], "Input",
 CellChangeTimes->{{3.749321161605517*^9, 3.749321183211232*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c", " ", "k"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", "k"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
         ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c", " ", "k"}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", "k"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
         ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "3"], " ", "k"}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", "k"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
         ")"}]}]}], "\[Equal]", "0"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.74932116268566*^9, 3.74932119032952*^9}, 
   3.749321396359067*^9, 3.749321839118869*^9, {3.749322232639194*^9, 
   3.749322249134534*^9}, 3.749322375435999*^9, 3.752323650291911*^9, 
   3.752323746615817*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"norm", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"b", "^", "2"}], "+", 
     RowBox[{"c", "^", "2"}]}], "==", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.7493211991680717`*^9, 3.749321199169052*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"], "+", 
   SuperscriptBox["c", "2"]}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{
  3.749321200575139*^9, 3.749321397845058*^9, 3.749321839143249*^9, {
   3.749322232660159*^9, 3.7493222491505213`*^9}, 3.7493223754411707`*^9, 
   3.752323650380107*^9, 3.7523237466891327`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"eq1", ",", 
     RowBox[{"{", "norm", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eq2", " ", "//", "Column"}]}], "Input",
 CellChangeTimes->{{3.749321206990931*^9, 3.7493212177986507`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c", " ", "k"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", "k"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
         ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c", " ", "k"}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", "k"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
         ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", 
        SuperscriptBox["b", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["b", "3"], " ", "k"}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", "k"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "m", " ", "\[Omega]2"}]}], 
         ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], "\[Equal]", "1"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.7493212082250843`*^9, 3.749321218080167*^9}, 
   3.749321398761321*^9, 3.749321839166089*^9, {3.749322232664649*^9, 
   3.749322249166909*^9}, 3.749322375460807*^9, 3.752323650469611*^9, 
   3.75232374676173*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq2", " ", "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], " ", "//", 
   "Last"}]}]], "Input",
 CellChangeTimes->{{3.749321281667933*^9, 3.749321281668489*^9}, {
  3.7493214127151833`*^9, 3.749321412834794*^9}, {3.749321483116372*^9, 
  3.749321483251974*^9}}],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   55,3,17545514524519555337,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.752323650770899*^9, 3.7523237468397303`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    FractionBox["1", 
     SqrtBox["3"]]}], ",", 
   RowBox[{"b", "\[Rule]", 
    FractionBox["1", 
     SqrtBox["3"]]}], ",", 
   RowBox[{"c", "\[Rule]", 
    FractionBox["1", 
     SqrtBox["3"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321282961935*^9, 3.7493214138669443`*^9, 3.749321484200245*^9, 
   3.749321579544352*^9, 3.749321839206811*^9, {3.749322232711966*^9, 
   3.749322249208243*^9}, 3.749322375504106*^9, 3.7523236509171886`*^9, 
   3.7523237468472767`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev1", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "/.", "sol1"}]}]], "Input",\

 CellChangeTimes->{{3.7493215953760967`*^9, 3.749321595376754*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["3"]], ",", 
   FractionBox["1", 
    SqrtBox["3"]], ",", 
   FractionBox["1", 
    SqrtBox["3"]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493215968292923`*^9, 3.7493218392515574`*^9, {3.749322232741692*^9, 
   3.749322249228471*^9}, 3.749322375537078*^9, 3.752323650990939*^9, 
   3.752323747040567*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq2", " ", "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "  ", "/.", 
   RowBox[{"a", "->", "0"}]}]}]], "Input",
 CellChangeTimes->{{3.7493216444811983`*^9, 3.749321644482582*^9}}],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   57,4,17545514524519555337,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.752323651069922*^9, 3.752323747118486*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", "0"}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", "0"}], ",", 
     RowBox[{"c", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321645407696*^9, 3.7493218392978277`*^9, {3.7493222327954063`*^9, 
   3.7493222492697144`*^9}, 3.749322375580277*^9, 3.752323651075141*^9, 
   3.7523237471236486`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev2", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "/.", 
   RowBox[{"Last", "[", "sol2", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.749321667404428*^9, 3.7493216674057903`*^9}, 
   3.749322402473234*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321668333529*^9, 3.749321839336825*^9, {3.749322232827527*^9, 
   3.7493222492899113`*^9}, {3.7493223756065197`*^9, 3.749322402982037*^9}, 
   3.752323651162218*^9, 3.752323747202026*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "/.", 
    RowBox[{"Last", "[", "sol2", "]"}]}], " ", "/.", 
   RowBox[{"a", "->", "0"}]}]}]], "Input",
 CellChangeTimes->{{3.749321667404428*^9, 3.7493216674057903`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321668333529*^9, 3.749321839336825*^9, {3.749322232827527*^9, 
   3.7493222492899113`*^9}, 3.7493223756065197`*^9, 3.7523236512425528`*^9, 
   3.752323747279726*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eVecs", "=", 
  RowBox[{
   RowBox[{"Orthogonalize", "[", 
    RowBox[{"{", 
     RowBox[{"ev1", ",", "ev2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7493216918620853`*^9, 3.7493216918635073`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["3"]], ",", 
     FractionBox["1", 
      SqrtBox["3"]], ",", 
     FractionBox["1", 
      SqrtBox["3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "3"]]}], ",", 
     FractionBox["1", 
      SqrtBox["6"]], ",", 
     FractionBox["1", 
      SqrtBox["6"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321693128323*^9, 3.749321839370804*^9, {3.74932223285415*^9, 
   3.749322249306244*^9}, 3.749322375628832*^9, 3.752323651324868*^9, 
   3.752323747358844*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"a", " ", "cross", " ", "check", " ", "for", " ", "Chris"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "eVecs", "]"}], "\[Equal]", 
    RowBox[{"Inverse", "[", "eVecs", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"eVecs", ".", 
    RowBox[{"Transpose", "[", "eVecs", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.752323657042626*^9, 3.752323738828795*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.752323667386697*^9, 3.752323683143062*^9}, {
  3.752323722806137*^9, 3.752323747436822*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.752323667386697*^9, 3.752323683143062*^9}, {
  3.752323722806137*^9, 3.752323747438059*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vdiag", "=", 
   RowBox[{
    RowBox[{"eVecs", ".", "Vmat", ".", 
     RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", "Simplify"}]}], 
  " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Vdiag", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321720002384*^9, 3.749321769158223*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0"},
     {"0", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", "k"}], "0"},
     {"0", "0", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", "k"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.749321728522335*^9, 3.749321737778191*^9}, 
   3.7493217694597387`*^9, 3.749321839406513*^9, {3.7493222328809147`*^9, 
   3.749322249322722*^9}, 3.749322375653091*^9, 3.752323651400728*^9, 
   3.752323747516664*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tdiag", "=", 
   RowBox[{
    RowBox[{"eVecs", ".", "Tmat", ".", 
     RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tdiag", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321777235162*^9, 3.749321787371119*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["b", "2"], " ", "m"}], "0", "0"},
     {"0", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "m"}], "0"},
     {"0", "0", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "m"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749321787720387*^9, 3.749321839438725*^9, {3.749322232902491*^9, 
   3.749322249339321*^9}, 3.749322375679388*^9, 3.7523236514760923`*^9, 
   3.7523237475929317`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem #2)", "Section",
 CellChangeTimes->{{3.749321821140115*^9, 3.7493218270339613`*^9}, 
   3.749321859367219*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.749321830601275*^9, 3.749321836628338*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", " ", "v2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "Ibar", " ", 
     RowBox[{"\[Omega]Bar", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]Bar", "=", 
   RowBox[{
    FractionBox["2", "L"], 
    RowBox[{"(", 
     RowBox[{"dx1", "-", "dx2"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Ibar", "=", 
   RowBox[{
    FractionBox["1", "12"], " ", "m", " ", 
    RowBox[{"L", "^", "2"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{
    RowBox[{"dx1", "^", "2"}], "+", 
    RowBox[{"dx2", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "//", "Expand"}], "//", "Factor"}]}], "Input",
 CellChangeTimes->{{3.7493218712874413`*^9, 3.749321903588821*^9}, {
   3.749322159789257*^9, 3.749322204656457*^9}, 3.749322245873176*^9, {
   3.751663805462977*^9, 3.751663808179943*^9}, {3.752323757277273*^9, 
   3.7523237577570553`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["dx1", "2"]}], "-", 
    RowBox[{"dx1", " ", "dx2"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["dx2", "2"]}]}], ")"}], " ", "m"}]], "Output",
 CellChangeTimes->{
  3.7493219046761303`*^9, {3.749322232969782*^9, 3.749322249376425*^9}, 
   3.751663595886479*^9, 3.75166371720329*^9, {3.751663808634116*^9, 
   3.751663825428602*^9}, {3.752323753873056*^9, 3.752323765552668*^9}, 
   3.75232385478249*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", " ", "g", " ", 
     RowBox[{"(", 
      RowBox[{"x1", "+", "x2"}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], "k", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x1", "^", "2"}], "+", 
       RowBox[{"x2", "^", "2"}]}], ")"}]}]}], "//", "Expand"}]}]], "Input",
 CellChangeTimes->{{3.7493219158169327`*^9, 3.7493219183961973`*^9}, {
  3.749322195207762*^9, 3.749322211849174*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g", " ", "m", " ", "x1"}], "2"], "+", 
  FractionBox[
   RowBox[{"k", " ", 
    SuperscriptBox["x1", "2"]}], "2"], "+", 
  FractionBox[
   RowBox[{"g", " ", "m", " ", "x2"}], "2"], "+", 
  FractionBox[
   RowBox[{"k", " ", 
    SuperscriptBox["x2", "2"]}], "2"]}]], "Output",
 CellChangeTimes->{
  3.749321919107637*^9, {3.749322212563838*^9, 3.7493222493988447`*^9}, 
   3.7516635959614697`*^9, 3.751663717278377*^9, 3.751663825503543*^9, 
   3.752323775424891*^9, 3.752323854805966*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"T", ",", "dx1"}], "]"}], " ", "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.752323780423774*^9, 3.75232379985119*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", "dx1", " ", "m"}], "3"], "-", 
  FractionBox[
   RowBox[{"dx2", " ", "m"}], "3"]}]], "Output",
 CellChangeTimes->{{3.7523237946521873`*^9, 3.7523238002047577`*^9}, 
   3.7523238548290854`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"T", ",", "dx2"}], "]"}], " ", "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.752323780423774*^9, 3.752323814394685*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"dx1", " ", "m"}], "3"]}], "+", 
  FractionBox[
   RowBox[{"4", " ", "dx2", " ", "m"}], "3"]}]], "Output",
 CellChangeTimes->{3.752323814666809*^9, 3.7523238548523693`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tmat", "=", 
   RowBox[{
    FractionBox["m", "3"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], 
  ";"}], "\n", 
 RowBox[{"Tmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.7493219300510683`*^9, 3.7493219300525093`*^9}, {
  3.7493222214366913`*^9, 3.749322222640099*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"2", " ", "m"}], "3"], 
      RowBox[{"-", 
       FractionBox["m", "6"]}]},
     {
      RowBox[{"-", 
       FractionBox["m", "6"]}], 
      FractionBox[
       RowBox[{"2", " ", "m"}], "3"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7493219312906523`*^9, {3.749322233043326*^9, 3.74932224942347*^9}, 
   3.751663596036193*^9, 3.751663717357873*^9, 3.751663825581245*^9, 
   3.75232385486996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "x1"}], "]"}]], "Input",
 CellChangeTimes->{{3.752323818394395*^9, 3.7523238234188147`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g", " ", "m"}], "2"], "+", 
  RowBox[{"k", " ", "x1"}]}]], "Output",
 CellChangeTimes->{3.752323823671229*^9, 3.752323854878364*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "x2"}], "]"}]], "Input",
 CellChangeTimes->{{3.752323845332829*^9, 3.7523238479149237`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g", " ", "m"}], "2"], "+", 
  RowBox[{"k", " ", "x2"}]}]], "Output",
 CellChangeTimes->{{3.752323848197557*^9, 3.752323854900199*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Vmat", "=", 
    RowBox[{
     FractionBox["k", "2"], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], ";"}], "\n"}], "\n", 
 RowBox[{"Vmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321958087817*^9, 3.749321959230324*^9}, {
  3.749322225169759*^9, 3.7493222266104727`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["k", "2"], "0"},
     {"0", 
      FractionBox["k", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7493219597560043`*^9, {3.7493222330682793`*^9, 3.749322249443738*^9}, 
   3.751663596107605*^9, 3.751663717428773*^9, 3.7516638256571693`*^9, 
   3.752323854922429*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", " ", 
   RowBox[{"Vmat", "-", 
    RowBox[{"Tmat", " ", "\[Omega]2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321972609214*^9, 3.749321983778863*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["k", "2"], "-", 
       FractionBox[
        RowBox[{"2", " ", "m", " ", "\[Omega]2"}], "3"]}], 
      FractionBox[
       RowBox[{"m", " ", "\[Omega]2"}], "6"]},
     {
      FractionBox[
       RowBox[{"m", " ", "\[Omega]2"}], "6"], 
      RowBox[{
       FractionBox["k", "2"], "-", 
       FractionBox[
        RowBox[{"2", " ", "m", " ", "\[Omega]2"}], "3"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.74932198447418*^9, {3.749322233090527*^9, 3.74932224946247*^9}, 
   3.7516635961795053`*^9, 3.7516637175042477`*^9, 3.751663825731503*^9, 
   3.7523238549442263`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"sol", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", "mat", "]"}], " ", "==", "0"}], ",", "\[Omega]2"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7493220093105173`*^9, 3.74932200931112*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", "k"}], 
      RowBox[{"5", " ", "m"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox["k", "m"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749322010378702*^9, {3.749322233117818*^9, 3.749322249484076*^9}, 
   3.751663596275498*^9, 3.751663717577138*^9, 3.751663825825527*^9, 
   3.752323854968217*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"mat", " ", ".", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], " ", "==", "0"}], " ", "//", 
   "Thread"}]}]], "Input",
 CellChangeTimes->{{3.749322024274446*^9, 3.749322025419079*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", "m", " ", "\[Omega]2"}], "6"], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["k", "2"], "-", 
        FractionBox[
         RowBox[{"2", " ", "m", " ", "\[Omega]2"}], "3"]}], ")"}]}]}], 
    "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"a", " ", "m", " ", "\[Omega]2"}], "6"], "+", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["k", "2"], "-", 
        FractionBox[
         RowBox[{"2", " ", "m", " ", "\[Omega]2"}], "3"]}], ")"}]}]}], 
    "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749322025750856*^9, {3.749322233122828*^9, 3.749322249489052*^9}, 
   3.751663596351948*^9, 3.751663717655061*^9, 3.7516638259235163`*^9, 
   3.7523238549717007`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"b", "^", "2"}]}], "==", "1"}]}]], "Input",
 CellChangeTimes->{{3.749322031768601*^9, 3.749322031769972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{
  3.74932203366545*^9, {3.749322233143323*^9, 3.749322249513311*^9}, 
   3.7516635964293623`*^9, 3.751663717734214*^9, 3.751663826016774*^9, 
   3.752323854991919*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"eq1", ",", 
    RowBox[{"{", "norm", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.749322038042506*^9, 3.7493220380429564`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", "m", " ", "\[Omega]2"}], "6"], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["k", "2"], "-", 
        FractionBox[
         RowBox[{"2", " ", "m", " ", "\[Omega]2"}], "3"]}], ")"}]}]}], 
    "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"a", " ", "m", " ", "\[Omega]2"}], "6"], "+", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["k", "2"], "-", 
        FractionBox[
         RowBox[{"2", " ", "m", " ", "\[Omega]2"}], "3"]}], ")"}]}]}], 
    "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749322039094255*^9, {3.749322233680923*^9, 3.749322249538703*^9}, 
   3.751663596505534*^9, 3.751663717818183*^9, 3.75166382610953*^9, 
   3.7523238550125313`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"eq2", " ", "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.749322045768259*^9, 3.749322045768675*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493220468518*^9, {3.7493222337493687`*^9, 3.749322249570003*^9}, 
   3.751663596604681*^9, 3.7516637179031563`*^9, 3.751663826201068*^9, 
   3.75232385503613*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"sol1", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eq2", " ", "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "]"}], " ", "//", 
    "Last"}]}]}]], "Input",
 CellChangeTimes->{{3.749322052796699*^9, 3.749322052797194*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    FractionBox["1", 
     SqrtBox["2"]]}], ",", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", 
      SqrtBox["2"]]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749322053797193*^9, {3.749322233781129*^9, 3.749322249596051*^9}, 
   3.7516635967236557`*^9, 3.751663717989986*^9, 3.751663826283716*^9, 
   3.752323855054327*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev1", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", "sol1"}]}]], "Input",
 CellChangeTimes->{{3.749322057240205*^9, 3.7493220572406263`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749322058319401*^9, {3.74932223380847*^9, 3.749322249619343*^9}, 
   3.751663596837695*^9, 3.751663718073433*^9, 3.751663826453375*^9, 
   3.75232385506264*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"eq2", " ", "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.74932206238704*^9, 3.7493220623875027`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493220636757917`*^9, {3.74932223384155*^9, 3.749322249645233*^9}, 
   3.751663596915078*^9, 3.751663718451848*^9, 3.751663826537068*^9, 
   3.7523238550905733`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"ev2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], " ", "/.", 
    RowBox[{"Last", "[", "sol2", "]"}], " "}]}]}]], "Input",
 CellChangeTimes->{{3.749322068738028*^9, 3.749322068738468*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   FractionBox["1", 
    SqrtBox["2"]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493220697838793`*^9, {3.749322233870863*^9, 3.7493222496679077`*^9}, 
   3.7516635970213842`*^9, 3.7516637185337477`*^9, 3.751663826629053*^9, 
   3.752323855094068*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"eVecs", "=", 
   RowBox[{"{", 
    RowBox[{"ev1", ",", "ev2"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.749322074382248*^9, 3.749322074382792*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749322075496131*^9, {3.749322233897458*^9, 3.7493222496903887`*^9}, 
   3.751663597113168*^9, 3.751663718622367*^9, 3.751663826712708*^9, 
   3.7523238551188717`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eVecs", ".", "Vmat", ".", 
    RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", "Simplify"}], " ", 
  "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.749322080357795*^9, 3.749322080358328*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["k", "2"], "0"},
     {"0", 
      FractionBox["k", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749322081479684*^9, {3.749322233925366*^9, 3.749322249713128*^9}, 
   3.751663597192494*^9, 3.751663718706376*^9, 3.751663826793502*^9, 
   3.752323855143962*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eVecs", ".", "Tmat", ".", 
    RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", "Simplify"}], " ", 
  "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.749322087612238*^9, 3.7493220876126842`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"5", " ", "m"}], "6"], "0"},
     {"0", 
      FractionBox["m", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749322088609194*^9, {3.7493222339534683`*^9, 3.749322249735458*^9}, 
   3.7516635972645483`*^9, 3.751663718806469*^9, 3.751663826875671*^9, 
   3.75232385516796*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part B Look at motion", "Subsection",
 CellChangeTimes->{{3.749323151502936*^9, 3.74932315857286*^9}, {
  3.751663691463077*^9, 3.75166369213722*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[Rule]", "1"}], ",", 
     RowBox[{"m", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.751663759467308*^9, 3.751663767589345*^9}}],

Cell[CellGroupData[{

Cell[BoxData["sol"], "Input",
 CellChangeTimes->{{3.751663732562742*^9, 3.751663732782607*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", "k"}], 
      RowBox[{"5", " ", "m"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox["k", "m"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.751663733120549*^9, 3.751663772129058*^9, 
  3.751663827020316*^9, 3.752323855214632*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mode1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ev1", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "\[Omega]", " ", "t"}], "]"}]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", "\[Rule]", 
      RowBox[{"Sqrt", "[", "\[Omega]2", "]"}]}], "}"}]}], " ", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.749323161380093*^9, 3.749323162472719*^9}, {
   3.749323198920594*^9, 3.7493232634316*^9}, {3.749323421770011*^9, 
   3.74932342214006*^9}, {3.7516637765315104`*^9, 3.75166377912971*^9}, 
   3.7516638627614202`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       FractionBox["3", "5"]], " ", 
      SqrtBox[
       FractionBox["k", "m"]], " ", "t"}]], 
    SqrtBox["2"]], ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "5"]], " ", 
       SqrtBox[
        FractionBox["k", "m"]], " ", "t"}]], 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749323162797749*^9, 3.749323207619527*^9, {3.7493232391956463`*^9, 
   3.7493232642158813`*^9}, 3.749323423156764*^9, 3.749502786507648*^9, 
   3.7495028535153427`*^9, 3.749573715431481*^9, {3.751663704963943*^9, 
   3.751663718892062*^9}, 3.751663779526144*^9, 3.75166382723071*^9, 
   3.751663864085526*^9, 3.752323855239161*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mode2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ev2", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "\[Omega]", " ", "t"}], "]"}]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", "\[Rule]", 
      RowBox[{"Sqrt", "[", "\[Omega]2", "]"}]}], "}"}]}], " ", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.749323161380093*^9, 3.749323162472719*^9}, {
  3.749323198920594*^9, 3.749323275677368*^9}, {3.749323425639297*^9, 
  3.749323426312739*^9}, {3.751663842880787*^9, 3.7516638680042067`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       FractionBox["k", "m"]], " ", "t"}]], 
    SqrtBox["2"]], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       FractionBox["k", "m"]], " ", "t"}]], 
    SqrtBox["2"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.749323266814205*^9, 3.749323276158842*^9}, 
   3.749323426812956*^9, 3.749502786571919*^9, 3.749502853538232*^9, 
   3.749573715452927*^9, 3.751663718975729*^9, {3.751663827343485*^9, 
   3.7516638687434072`*^9}, 3.7523238552649813`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mode1", " ", "+", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], " ", "/.", "values"}]], "Input",\

 CellChangeTimes->{{3.749323452740999*^9, 3.749323457954566*^9}, {
  3.751663875923306*^9, 3.751663877519237*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "5"]], " ", "t"}]], 
     SqrtBox["2"]]}], ",", 
   RowBox[{"1", "-", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox["3", "5"]], " ", "t"}]], 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.749323458382465*^9, 3.749502786641748*^9, 
  3.749502853594837*^9, 3.749573715542173*^9, 3.7516637193473883`*^9, 
  3.7516638276254473`*^9, 3.751663877836329*^9, 3.752323855290268*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"mode1", " ", "+", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "/.", "values"}], " ", "//", 
    "Re"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7493233546594563`*^9, 3.7493234633475227`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVmHk8VP0Xx23J7pIkYe6gCKmkkuKebKGiBUlSZCselUflaZFUlkiSSipK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      "]], LineBox[CompressedData["
1:eJwVmHk8VP0Xx23J7pIkYe6gCKmkQnFOtlDRgiQpssaj8qg8JUlliSSppKJE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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {-1.7071067038079875`, 1.7071067038079875`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.749323364844244*^9, 3.749323399337736*^9}, {
   3.7493234298535967`*^9, 3.749323463776176*^9}, 3.749502786690997*^9, 
   3.749502853633984*^9, 3.749573715656464*^9, 3.7516637195010777`*^9, 
   3.751663827728488*^9, 3.751663883111504*^9, 3.7523238556589212`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"mode2", " ", "+", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "/.", "values"}], " ", "//", 
    "Re"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7493233546594563`*^9, 3.749323477240305*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVmXk8VP8XxmUdu2SZQTIzQpaWb0KSOSmSkERFUkmpSKWkRSUklS2pbFGi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      "]], 
     LineBox[CompressedData["
1:eJwVmXk8VO8Xx2XfQ2EGYWaE0KaUJOcQJSFJm1AR2vSVsiTtQlkSEmWrVCpJ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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {-1.707106637417295, 1.7071067811865328`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.749323364844244*^9, 3.749323399337736*^9}, {
   3.7493234298535967`*^9, 3.749323477847363*^9}, 3.749502786787573*^9, 
   3.749502853739254*^9, 3.749573715759289*^9, 3.751663719584797*^9, 
   3.7516638278503647`*^9, 3.751663886744649*^9, 3.752323855747863*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x1", ",", "x2"}], "}"}], "==", 
  RowBox[{"eVecs", ".", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "n2"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.751664088337296*^9, 3.751664101058733*^9}, {
  3.7516641540379333`*^9, 3.7516641567051888`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x1", ",", "x2"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["n1", 
      SqrtBox["2"]], "-", 
     FractionBox["n2", 
      SqrtBox["2"]]}], ",", 
    RowBox[{
     FractionBox["n1", 
      SqrtBox["2"]], "+", 
     FractionBox["n2", 
      SqrtBox["2"]]}]}], "}"}]}]], "Output",
 CellChangeTimes->{3.751664101438712*^9, 3.751664157217927*^9, 
  3.752323855756764*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], "==", 
   RowBox[{"eVecs", ".", 
    RowBox[{"{", 
     RowBox[{"n1", ",", "n2"}], "}"}]}]}], " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n1", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"n2", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7516641688694553`*^9, 3.7516641755791063`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x1", ",", "x2"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    FractionBox["1", 
     SqrtBox["2"]]}], "}"}]}]], "Output",
 CellChangeTimes->{3.751664176004575*^9, 3.7523238557813387`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mix", "[", "a_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "mode1"}], " ", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "a"}], ")"}], "mode2"}]}], " ", "/.", "values"}], 
   " ", "//", "Re"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mix", "[", 
    RowBox[{"1", "/", "2"}], "]"}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "0"}], "}"}]}], " ", "//", "Simplify"}]}], "Input",\

 CellChangeTimes->{{3.751664014752939*^9, 3.7516640510781927`*^9}, {
  3.751664187237782*^9, 3.751664210413703*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.7516642110640593`*^9, 3.752323855876646*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"doPlot", "[", 
   RowBox[{"a_:", 
    RowBox[{"1", "/", "2"}]}], "]"}], ":=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"mode1", " ", "+", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "/.", "values"}], 
        ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "a"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"mode2", " ", "+", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "/.", "values"}], 
        ")"}]}]}], "\[IndentingNewLine]", " ", "//", "Re"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7493233546594563`*^9, 3.7493235443539*^9}, {
  3.749323575524152*^9, 3.749323575679125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doPlot", "[", 
  RowBox[{"1", "/", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.749323583584289*^9, 3.749323589395492*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwV13k8VO8XB3BL1hl7CjOWjC1bFNrdkyhR9C1aJEVKVBRJ0WopWiSEUpGi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      "]], LineBox[CompressedData["
1:eJwV13k4lF8bB3B79oQZtGBmSoqEdkv3TYpQFEklCUWJ0KJfVJSiJNJijRai
FC1aSEiyZEmoGPsaMxjbTHbvef0xrs/lmec5zznf+z4Hzfnk7iMCfHx858jH
/38/uOgsouMatrln7v8/HCiqVbXcq3oMylyb42aJ54rzrqiq/ge3zCI8Joml
o96/Eq+/DC3lSr6jxA8KwlWEVa9D0Y8rGX3EmhzXW3NuEfCc+1u1mbhZOnF2
+k8U7E9SKaskXvpUbP3k1D1oGzyR+on4hOEZz38qsRBdXP3pKfHburbksS0J
IF52SCSCeNLDsmnYLQlY9johp4kf8jdd/7f1EfDFHtq8l9ik8vYy3p/HIHti
nuYG4t4Y0y9jx5Kh5rSZtTzxTdcZh9GpFCijbE0fnOVA7ZT73SGVZ9DvLioS
T3y2RFmb8/o57E6kiXgSL7xTVz6w5QUo+8YbGhA7r0RBtlsmNKw5bVMzwwGB
qfM/xgJeQX2ivm4scV3bniVjW1+DxOO12w8Sn3shkT3y5w2oP3iu2jzNAfOo
HpGRh29BfN7T9hjixee+2A4fy4I3/T8adxEXbPEb4ky9A7NN3wM+TXFgXmPH
8gGVbJB5nvmf5yQH6gs+n+nvzQbmbWdJOeLnT2O+sl/ngJDZF+a7CQ7s9N15
iLUlF0aKxzRGxzlwXyzn/l+3fJh+wnlu+Y8DWX7mvqcUC8Dd89myJh4HElgb
lEYDCuCVrX6rO7FXtazbyNYv0OT3WuY8lwOyCaUCw38Koc5J+Lz/KAempN8/
8zb4CpdtwsbHRjjQFfTEeujhVxBXKMr2IH7vdjGRc6wIckVPiuwa5sD+NWv1
Bqe+gZz6ivrJQQ48+p7kw1YpA9llgh3lfRwYi3m3svVmGez22/5BnHibW3ln
zUQZ2Hb8OrStlwP9gv/25NR+h4oze7Syejiw0XCn3vWQChiWqGIe6+RAdea0
wHLODzCofGe5uYmMF8QcpbSqwZFyrMy8kQP6anf1QlyrgWbgtMKWyYFbY89G
z/+sBgeZuOiD9RxYe/vXEef0n/D8UMgOizoOXPquaa5zqBae9UesulPOgbTX
H9TS79XCb2NhT6/vHKiJMRZcVlELPTSXJ9vKSH7d7HMVN9XBx2aYHCjmwHfB
YC0+uV+gt0nJT7GQA1TDRtkfxb/BmN4w0PyBAxmZ1xtPaDHh4oK14esecYAl
y7ppfpgJzQfzt1UkcWD5WfPN6neZIJukf80pkeTbQOJR5wS53rU+ISieA1Fl
N4/u/9YI1qcHdj29R/LaGTFs6tAM6ivMtPyvcyBJovzKgq1tYPZ4U/nBkxzY
bOjvEOjYBkUKUSZpnhxo8tJYx/Frg+Pdm/2GPDigWBPWU/G8DZJz0+afd+fA
7RjL7aEy7dCfXL7Z9zAHriyrkp5rbAcnrTSt8d0ccIOfsf2+neDWtuqu21oO
8D3m5TSGdULMPtvSs7ociBFa3PQ9uROELqnPC9bmQGnZUeVnvzvhRnbiixhN
DqjbTj8+otcFK7VjK58vJfXpvvxFC383DBrrLjstz4HjURfyqiN7IO2AROCz
kUHw6l7RmZXRB13Jp3sVng+COC14eevGIeBrTfWomByAWzLlKx85jUKencVE
k/kAODfa5gtW8CBk+VA0f3g/iMe3e/o08ODWmWFLrRv98Ga/1+LWHh4UlRgL
OYT0gyAz5L8c/n/w4rPu9Zygfkiuz1njs+Ef3LGo3Bt8th96fqmmtTz+B9Hm
l112OvXD8er+yOz/xiFBv1Lwz9p+8PkW7Hxy+SQIfTE4HdHBBuWubSK8NZPg
qRc+btLGhnIBsecBOAk3pcO1p5vZsAzDh6/vmwSbgIclJxvY0JBzLzA5bBKQ
JdfjUc0Go1dPExs4k7B/7+WgnDw2LIgvZW75OAV2rs+HviWwIS/7xsXvRVMQ
/WR1xoc4NnjUW9J3/ZyC3MvcC+kxbPhG+XnMkTUF7sO/DsXeZcN/kQ3j5xZP
Qx7v9YVbN9nQfpVFzQichsdOIcltAWx47S1po7h9Bgouzju38RAbKuLk/ntp
NwNavXFlFgfZ0FO0MMnYdQa2+wD38AE2LFRawT5xaQYWJ2b33t/LhuAvW698
eTcDVV8mHjGs2WAne+ntcfosVPcmuJQbscHb4FrD3OpZ2PhAiieFbLhxNHzu
ruEsME+nxtpsZkN+TrxFvv0s/Kr+TevVY4O6y8dOuYhZcPfRubt+LRsm3w7L
fZ6ahRcppiyP5WyQbxnftFtsDuyah1Xal7FBS5TP6S91Do6zq+L3LWWDi4P0
iwW6c+DEpp6ypZH3EdIwOeo+B+XDcpM+i9iQuMf19Pxfc+CoU7bGSoYNHy95
xCV3zEHH57uWk9JsqH3mW7BpaA6ehOxrSZNikxyjyBthPiwz1fxPRoING2t3
7m5S5cPFOybaxUTY8Mjfg6W9lw/vB04vT5tmgXaB2HjIQT7stTk3mzjFggKh
NOFWFz5013sqHDvJgrbwLtVwbz4UbXyceX+cBcoPD+7tu86H69P8sj6OsSCj
a8oVI/kwyJW1u2yUBYYr4nyj7/OhrSFnbfMICxze/A7f+oQPK/nHK6SHWRBX
ZFX0KJcPC6zCw2MHWLBSbPDneCEfao2pXS/qZ0H2jputVmXk/hYvmSNsFtT/
Lp2c+cWHsnXBoftYLKD2Gens5/ChiOW8nVZ/WRAltTZRls6P1F9uXi3tLKDv
rkk/ps6Pdil1NUD8+r53doEWP5qbGb9KbmNBtcrLOi99fvRKu99yrpUF0rpq
EuW2/FhR077FopkFiWeLFOkH+FFPmZFe2sSCVZ+c1f47zI8TydSE7cSWJklG
y734MZqHDLtGFtywUzx3JYQfV/y0m4ttYMHC+PdXmeH8+MB7sH8N8bNW2zs6
d8l45mxO/6xnQan77YzWh/woc+GYvQKx/cvVuetT+VE3UzA7/w8L/g5XloW/
5EclG/zkQSziL96tn8OPWRX7X1T9ZsH9/LSRqAJ+/OM3P+kq8TIhUz5WMT+2
6cvrI3GWWbeUUSU/OjnvvDz7iwUm4VcWxdTyY8/nh2cLiOt+0lZwGvhRJ42t
dI3YhVqwflsbPzrySXlZEV9Omt411s+P90Q2aw/UscBa+6OPxig/Do6tOF1I
rPzl1G3nCX58cmOFRTxx/67Vr2Pn+DHffPS9H3FOB6u6WlgAV7vqZ+8lDj31
dGiepACqvXpro09sJ+QsA7ICeOOVRCideOm9JdpnFQXQ7NbQXinikWUNVi+V
BbBaQerbVC3J4/u7J7uWCuDxfLGfA8S3TK0jFmkIYHrszQudxA71Epm7dQSw
88CmiibilcdKqq5vEMCL+1/nNRCPT1weLDAkDrljxyQuvrFZenyLAHZ7B9xr
Ib67aHLVanMBXA4iF3qInV+823HUWgAT35ZKjxBrG/p4PrATwDm1fZb8ZHyz
lZrhdQ5kfCHmG+SJKxx7X0i4CCDTftXPlcRxnCcVxscE8GVmxKKtxO6Bh/r/
OymAMmtmFFyI1y9YJPn6jABeU5orCSYWevxbo9dfAAuXL171nLhGN8pC5bIA
amfWm9USP/y6w8MuVABP3Hy/mI+sj5etWFj4LQGsWbbuuTaxQXfR86K7Ajhy
7OeIK7H42cDvU3ECqFwlPJ5AXC9iwNJ9JIBjluaf6omfRv8TO54qgO2u8psV
SV6Msr22178VwHldAqGPiaXNVx6bn0PGWyW8e4C4idkduq1AAIdsLNr1SR7P
TTuUZlUIoMkD2NNFvC1csZddI4C6pR8NNpM8yyvXzWM0CCD1gBgnnvgVWJje
7hbAgJfPsp1JPVysFnErZQvg+7DMunJiy8OF1+aGBfCm5ET+RiYLei9vKvac
FcB3i1IllUl9qRYv32quIIjb0mSeUEl9Dtp1ugYtEcTWVz2uicS5fxODPzIE
MSP7IP/KFlJPYtQiNW1BbLLU/GFJ6jvSUmiL4HZBHPmd2lZA+oFjc76znpUg
GruPxbp1sEDTy/+yzx5BXDkes0G2k9RnxMiX1sOCWJFwZ+mpLhbw1bZh7nlB
PLHjYLcL6TfBfXmPzgeR75vbdun1skCM74HAplBBTKyavUztY4Hsqn1F7+4J
4mKRseRG0q+Whfw0zXwliLaR6x49GGTB8weZaZ4fBLFwcfbXWA4LtLLCxTTz
BPGAflxk3BALNrZvL08rF0T1xstaz0n/NNcv3Pm4RxCtz/73gP8fC6p2Pcx0
GhDE3M8R6xikH9u4X5RRGRPEogO5QdsnSD3c06uJ5xfCvAf9esmkn3tx3uy5
t1gIHU61WEXxseHOkycOobuF8H612PAusj8o5gR93rZPCOW9uyzyJdmQUH1I
WdhJCAtSj3jokP3l6cyitiBPIXz++t8UYwHZf/bedfEPFcITrwv8jRXY0CRx
9bhXnhDGjDBeHCH7mRPdpVzzmxC+17z0TkWNDd0bjTTZ5UJY8WhZZAvZDweP
zAy4NQhhj8DIp+MabOAvOONzeEwIRReMz+bqskHt9NFztiuFMd1k4tV2Yzas
0mu1SdIWxkNP5FZpmbBhLZ/9atZ6YdQ66N1B3cYG45vbey5tEcbpeTg5tp0N
jsmatukOwrg0I6uncxcb7teNrBaIEMaxw0/6bzqzQXjdpb+Zo8J4jX/ul2QI
GySn/hVOTgij6/Y/7eeus0H2i3fiVj4RFHU6q9EXxgbVHc57GiVF0MOr2O93
JBsMjmz9KqImgkK2K0c6yXnm9D2JpIP2IpgT62P1PZMNXdxoO4nPIiiexJz/
tYkNj43WnGr+KoLM/EtUXisbDoVXRWR+F8Fursl8rU42MJcKl9nUi2B6QVXd
iz42/LTx1U8YFUHpx5jYzSPnp9eWqqtWzkPuW7GILbL9EO3Jz9oZPQ/3q6fR
0i37wTY7QYSWSF7+6tbh89b9ICu8kTGaPA+Zay9GW9n2w60EL4foN/NQUlfN
ZZ5DPwSXN1a1Vs5DoRyF3688+sF7xfu33kKi6FK5UJYV1g/m3ccvRPmIotqG
X+v6f/TDtguMFybnRDE0dX4i1PWDMaWJybsoinHP9gVH1/eD3tYdGw/cFEUn
49Qi2/Z+WJmyepSRKoqOHvN7hEb7QeLImPu7JlHkz25apacwABVdF2zrTcVQ
y7xIrN95AHZ2RWooK4vjzWsKZydEBqFCo6vOYak4rh2QEeaTHASLUxsuxq8U
x/WDavPEFwyCmUBLteIGcRxP1nJQXzQIxqoaZ+WsxbEz8Y3UrdWDsM7hW4Ho
ZXGsd16dMmU/CIvrJvaMdovjMeu0r1YZg8D66hxY+lICJecUnG2cOaC14PeS
LYeksKnlNX342hCIk2Nj06g0un18e/38oWEwHdj/j75HBpkrzgRdtxmB+kJX
/v2aC/DGmqVxXsaj8C60yFGVuwDTgy8ncKljcFT4TFtVlSyu3b2A6fZ3DBaq
lP2Z+imL2Vbr125ijUHVxiU/1H/J4pDMmneiA2Ow/sS3z5cbZdE7t5/+eGQM
RGop8et7ZdHfgOqdNzMGKQ/f70nkl0O+wR19cXJc6NIf/+65Vg6X6T2GOkMu
xOyxLIzbIIfGsbbGR5ELlicfZpfoyWGJvuJynjEXsh6bpdGM5DDpgc+t+WZc
CBaLvfprhxyW6o7Gqu/mwtI/m9DQTQ4fjrrUDh/hgouv/zvJODl83uXuXxPG
hfW6Le9WPJBD9y6ZrQtucUF8BN9veyiHHjU6JTsiufDKR+RD4FM5rK7zGsi/
y4Vp79sfx97IIX6ZCw99wIX7J1M/NZWT6w/Qg59lcKHsRO2XFzNyKPbX5eGS
H1xI0FxfWMYnj9/9ro3M/8kF7/6Ywh5BeQzIfPR1roYL1BOOX1XF5fHj+cbG
P7+54OzRV3SXKo8Xpa2yjrWQ5x2bKwlYLY8q6Y9DZQe4sNpNo8rysDyKj55U
8hTlQcsxlZMvXeXR/Eip8mpxHtw8IScj7S6P/gPGowMSPOjzmdr1w0secUkM
v/N8HjwJKP+1K0AeowNm/BlUHihEeTTbRctjiv3N1eIMHhTfPXTxQ5w8akop
6MUs5cHpaBsVxUR5jDsbOEZX48HPBP3DDcnyWEF38tFawYOwVInuA2/kselk
rd2S1TyYy03vd6qUx59FbN19ejzIyE8K/1Itj5dlYx1e6/PAofCOFr1OHh3O
lymKGPIgu8Tfu5Mpjz8GHxmlAA9O1ViMHemVx9EptaU5Jjz4+5c9dVyQgs+o
7c8NdvLgPqs1oVyEgsrx3ZoHrXhgMlBrqClOwX2/5NTOW/Pg0cinSwMyFDSq
OuT3bDcPDsyECXorUzBuww73Zjse/JDVlDiziYIvtxmqxDryYLOnZ1+8AQU3
lSTPeh8i4y3JKCkECtb3a2RtdSL/pwboBMtso6DF5ncJ3Yd5YNmzfiZ9NwXV
A38bzbnyIBfPNdbsoaC86O5Xn4/wQDM+O3vCnoKRSrvY547yQMLa4KzpIQq+
G9Io7HbjwfdsI06HBwVf5IzUxBzngZ78lUqxkxQUmFx81dCDB8+9itK1fSlo
cC5+soX4OsPU/eI5CiaaKmsoevLALNyyXekqBbVXOFxxOcmDj3/D8zGUgo5g
qDNIvNz4xwO3MArKLXgTe8abByL/du1/d5uCNSMK98/78OCb095a60QK1gle
Ujl4igdrP8W89ntEwXsz8cGVxMkUZkRiMgUrmqfj9U7zIPi7g2X/cwqmGQU3
i5/hwdjSxJVyGRTM3/RC2IvY5VKrqN5rCo4LLGqqJDZe6/wt5AMFqYWdEVfO
8uDNrSdPMnIoyI7d4dFATO/rCvr1mYI3RZWHNfx4wJ/otplRREHLI2rjxcTe
42mLzUsoKJkf4Df/HA/adrMmvb9T8E7o2Qe2xAXzPD/kVVMw+lBKQx2xtnPG
ve5aCkpcnDc4/z8ePMzlnJL8Q8He1W4ppsQyCjq71zApuCymddaf+JKPr/b+
ZpKHN+ETL4gHy99KB7VRsMU28i6T2FGN25/aScGFq0V/CJ3nQVXg+vKqHgr+
qVBI0yDe3Oj3jNtHwd/3OpWtiDPWZYcsHqBgc9Vt3ZPESyInj2wZIu8XZ94R
RnyTpW9yfJSCyyc3rEohnja5QL/No+DRqquyn4hPJOXxfZwgea0/fLuSuGli
rqVlmoIF2VNpTcSWtkafhfmoWMALtu8l/pRxOV5TkIp5XO2kIWIRyz0Lo0Wo
uJ7bkMsl3tW3PJZfnIqOS7b+4REnXJtUOCFFRRn/MwOjxH8Zlfd/y1DxWrb3
bD+x7pckipE8FUMZINZBfMHR9266AhUjktmStcSlUyZy1EVU7Cq7IlpALBer
EBWoTMXCrwpTacSO61kybBoVTx7N6QwnflabG7FnGRWdNIK+eBGPeUdIF6hT
0VI3+I4FMUg7h6/UpOI24xb7pcQ30tdK3ltNxabvL2QmyPz/MpsXNqdLReXu
+TllxB5XXoTWbaKi9HVaiyPxe9VL88CQirqJS/YyiPnzdl17hlQUd9ye10ny
ED3Ou3LRlIqJ3r029sQd98oE+sypePZbXqAk8ao1CUE2O6loUX4jJpfk7aun
0SX1PVT0iv57VYZYWkJ+Nsqeiu7/hvZlkbzuS+sJmDlAxTeG7RRbYg5Z1Rpn
Kopcu2ocQvK+yP73mQBvKqa9a9mfS+rnKDdtrOcUFcVmpfYD8eso/1O7/KgY
RL+un+fLA9NKVR+1i1Tc8F/Z40xSj6eMPU5Uh1FRr7RhyInUb16rIVsvgorF
GrlDhV48ELsgczwlioo3heYqVYmTPrxzOx9Lnsd2Va4+wYNyTT6XpalU3CN5
dd7MMR5Qv9e033pORe01Gp2GxIfdUpwmXlKx6Pe/6PPuPPj3yNyxKouKZY8X
h/0l/YmhcG/fuUIqmpU23Ihw4YE//0rrimYqLre7cUfBgQc9JhL1au1UXLgx
6ObCAzywDu0/FNRFxV4v7kWl/TxYOj/z5Ho2FQdbdK0k7HlQsXhtxMNxMt8a
j+7l2fBAeePmqtNyCnh3ZjrExZwHof4qdj+oCvhxfNX0su08GMnja1mxUAGb
Lwcf7TLlQcnWrwMtqgq48MOKJXu2kn5gYya1XUsBP0wlzhdBHhR67bZcsl0B
ZVbun05ZS/rtmzV1fpYK2PnM5vvyNWR/4Mo71FgpoE9gaXiKDslPwB+PEDsF
/Kxkz72rxQP5Gw5hwy4KWESV3b5FnaxXytHv3y4qYKvhyKKWhTwQbzpv5pWl
gNvO7iuWmiHnA79nUhEfFPBG0HqKzhQXDsvW12TmKCAzdbLbeoILH83WHRwu
UMDxpwHS17hcOPqO43O6UgFfHsgJLib79ZdbrvHnexTwaG/w3ofNXDhntHPw
mqIibkj7fCsnhwvJTQFvUxcpYqB/S4vXRy788Es/V6qsiLJlc3kq77mgliEq
KL5MEYf2Ren4veZC7cKvCuE6iqh69vbQdCoXtMY2GN0xV0TRqrjDruR80v2U
djcpQBFnjo83pB7nQn9w+4RgoCJqPn/vl+XGhRHnR4fcryji3I7ppZ9ducCn
QtPQuaGIH8ec3xQ6cmFhtGphYbQiOjXTPiSS85N1iMpQ9xtF/LK27Uj8Ji7k
ui2x1OxTxAcLTRsyhbhwV11JKHuPEg5qpB+MihgDB0e11E57JdRa1niREzYG
S++uMZd2UMIjB7oubQ8dg6y5HZEuzkpo9xGXjwWOQd3vy4ulTyqhk2jpmqW+
YyB3tX+tS6gS0rUEIodsxiCqPf+I1Ccl/OsZprKVMgaRcUdLDqsuRKHRI4F6
EaOw/+7BKsm/C3FEKvVdz7ERGDdJmUjKW4SFC6vTx4WHobPb+FxhyGLcYJtw
Q9WYA48NdRZVHl6Cj299flev2g8vr55Z4LZKGc94Ht9vt64PQva4WAhylVGG
saeo3LcH1jU9ehZSqYJa55u5xzI6QUbLfTyzWgX7HUpKXyR3Qv8lLdP6WhXs
XGp0eSyuE5IZn7rUmSpo/W9bQVRIJ8h71Kl871FB47eNEhKHO2EyQNBChE8V
c1ftHePId0KDxPovZkqq6FBvr/s2sANiVsS/rLRQxVerf/2zP9YOY6PbUq7s
UMUDfaW5Vk7tYJU3krDJShVlDQq6d+xtBxEb85spu1Ux8uf+i05b2+FMwMTx
C/tU0ZtReqWV1g67f+xVX+Wmipom/yWaN7WB5Bn5Jzcvq6LLqYHVAnvbwB0K
4oyDVTE+LVVqZGcbfBU7ETV+VRXHv15YzNrWBucTvwa5XifX2013j6xvg74S
XyeDSFW8+OVjjZtCGxQv/Lmk/4EqvrmwJbP0bStcKgiPscgm9zPP8n38vQVY
zQV3J3JU0WwgKLYntwXspkYjU3NVsaNPfVQ/swU01++/LligilIz390X3m2B
+nS185+KVdHp/pdLqY4toBudf0CjThWVzrOsJP41Q4/nsLIERxXbLm5ZAOua
YVfY0kXZQ6ooEGit+HlFM+Sm7VVwG1HFR7Nfw3coN8Odzs/zv3JVMcnyeW/K
vGbAfTf4/KdVsTP888F1jU0QZ8LoYInRkO/Im8V/rjbBjkV7Ur4vpaGxqdt/
zn2NENOlVXBAjYZ5igJ/GtsaoeulaGP/chpWWHpoHq1vhADMlZmvQUO5Zcvq
X5Y0wosjjAAbHRpW5uV1iqU2gvir4d1NhjTMDE9cM+neCHb/lXt6Ag2XGgyN
Xz3cCI+NU0JnkYZhJosVGfsbYdMv+zxVExpKe9v537ZoBPfJ/BVHzMn4FF6c
hdWNUGJyi2/Qjoa+I4la3RNMkJV2X3TJnob8PaL610eZ4PjHaL3Mfhpqedyf
3DzABN4xrofuQRr25K1La21jglqEw5+zLjTccn2zFa+UCcENKzPmTtJw5oOv
wYUEJlQ/FiqL9KFhEt+O9s3RTFh8oqWTdoqGZcFR12WjmPB29raSyVkaSlpr
/+OEMKGDMREcGkDDnGK30iunmWDkVXJgwXUaes0r1pHbxYTJ+r5tRTdo2Gk6
ZptkyYSsLZK6fjdpmGL3dQLNyHiUdok2R9Dwdvfm5iJggmQRMyvtPg2dhV7E
/1jNhGKtmaQDMWT8qw0cRDWZcClWJUw6jobpTtIldupMGPFyPXz6AQ1f+PzI
WEtjQr3SoBQm0zChxtCCK8eEqGCZiZEUGhr1ve1olGGCBUe3KyWVhrZlBdvr
pZiQV+SXI5FOw8RMyxhZUSacWx2XkveChu83BoVaCzNBJy430ieDhlWhH/Yl
CzAh+SS/25/XNPQz438VPtMAjkzG7htvaRgoe8iQMdUAClu3GRq+I3+3tsmt
Gm+AGwvD5J58pKHd8Fyi21gDmFx9Obsnh4YRItHie0YaYIbzo080l4bP+oP8
7IcawPubfIFXPg2/TPi7PupvgJXaG9JpX8j1mTPsHlYDdMbtu19XSMPTlh+v
GPc1QIJwQFBIEQ1/aW1ZnfW3Aey8E0/oFdOQrqw+ot/TADKNBXsHSmhoYNr5
o6GrAcq2dho/LKNh18bO8vDOBjBYpK4kUknDoeDlmhvbG4B31Vwou4qGocVC
0VptDZA5dILjUU1DzRj7VfqtDeB+IIKpXEPybLhj5GBLA9CLX3/7WUvyYDbX
e7+5AZq0614F/6LhiqgL8j1NDXAvnhe/4Q8NLxuW+VkQ7xRRCmHV0/Bvxi9K
SWMDiPro+z5g0tA0LHTYnriw8eBB6yYahmRlS/ET+28LNBNsoaHNtjWe+cwG
WPv68Zr3rTQUvPNa9i7x4KJvysfaaXhDtZPvEnHatb9iiztpeDzFXS+Q+PCw
GLeqi4ZZwr++RBMvdNBsC+qhoZD1y9hvxHXFO8vX9tIwNce9SIw875aOz/u/
fTS8/9DbxJXYNOHOozg2DV9fVF38i5hv3vubOwZo2D30bYcDeZ8cn3o/Pg7J
U+bDxgniU02Tzm+HaPgwrKPkJZkPTdMlO4+O0FDdK1P+HJmvntewSWmMhvtt
lhTZk/lMWuy8tIJLQ6nta+utyHzrrdHQcv5HQ3sLtVxzsh5128c2jI/TcN+a
qeX7OhrAy+mz0a1JGhYbbVriT9ZP1O+axdJpGuJChwevyPo+DrfakzNDw8df
6p5NdJP1TVY8ZD1HQ90EMRM7kg/vn899AwToOLNTcrk5yZN476kAWSE65nz2
8W1nN0DyrMG1NGE6HrheaH1zoAHqNX7E1onSkarV9n3xcAPgtdECzfl0/O97
ea36RAMwE3K/F8rQMebn/V8OJP+n316ts5el4+GAdN9kUh9pbQq9wRQ6tryk
XPYi9bNA32B+8yI6SnVbSwxKMuHFLmGlU0voKGKvMJM3nwnb3KvoYip0nL1Y
H/FElgnn7zmtX0eno4DX3rhURdJvOMEHw9XpqCu61Sp+GRMCRHa6MVYSh67Y
I7aCCdQlCj7ZGnScGBabu0H6hbn5s+BuLTrauvlC2RomvEmuTDdcR8dvpd5n
dLYwwfLT/Xe16+loOi2daGDKhJ6fh/KPbaQjrBk/fsCCCQvnhmvu6dOxly08
XGvDhCv7qJMDRnTs91RPfXWECcrerYLBW+i4f2cw2/44Ez5eS5NauJWO63YV
/5Q/yYT+t3q0bWZ0zAqdDio5xwRb6UNmiTvpmLHup5NiOBOWfk29v/MAHa3O
XPJxy2ZCleZ4cpMDHUfl295p5JN+dN/s7XFHOtb4KFQIfGNC+bG+H9cO0/H9
t7hjfdVM8JXREMt3o6N9cJZpTB8T8g9m+K8+TceideZH/JXJ/lEye/3zGTou
CtVbdWJZI8jqWMVY+NFxsPj9q5OajXBUaCjL7Twd/WadOjP0GkEyXWcwKZCO
HRPpRVL2jbB/PMtJJpyO5r9f5FvcbwQhZ+GTibfoWHJo4wG3xEbIKN9zQTOS
jl9/T92+97QR+JN4sWZ36Ljg0fuSFR8aIW3rxtrAWDrK2CfN12loBG7Up63D
KXRMH7lS+VG1CSJXFa6syaNjp9TmPzGfmyBt4wGxywV0LA1Z8bO7tAnyt4z9
1Smko/ITZWOzuiYY3KeWcvsbHZODX57dwW4Ci2s3VHZV0HF5odxT+4XNINK6
W766gY6fL3yq8gxoBv/IzpnKMTqqKz3g87Jugaj4gKYLPLLe2rp/D5HzxfOn
lE+rxumo3SsWffQEOX/kmp4Ln6JjtavBpjehLbC+L33EUoCBFSONtUaFLTBk
dPpv+XwGOsSGRRtsaoWjo0I/y1YycFcRNWXDojZwfG5S5aDJwIe1L6l99Daw
OxxczlnFwKu3VHWfrGyDbT8Eiyk6DIzwSN2no9cGaukCnw5vYOD5H2Hz3+1r
g25nvpSJLQxsuaayYm9cG7jWTJ1bcZCB3q4uqQPkPOf8ekT1egQD6/6Lyo7c
3gEnLttMm99moIuVSp2vbQecscn6I3mHgW99JkMdD3VAKPfMrcj7DHxxQfDZ
7jMdkLFpYir6AQN1pt7Iv3zUARNf5n4/TWfgPe1z1GXTHRBZIxleVMLAG3Ec
w7EPnRD3xNP9WhkDZdv1Nsx87YQnp6u2mJUzMHDtwgnp6k54T42cLK9ioAjr
YY5lbyc07Zdzr/3FwLubsk9qK3XB8k6lLR2dDOy5dtY1KqALtLPOKyd3k/vb
qd9Zer0L9K42Thz5y0DRvTkK+fe6wHL5g1d9LAb6KvCEpDK7wNdDVXl4mIH6
f94lSXR0QYBB0MSbUQa6ci68bB3sgqtSHXWnuQzUHD3969NUF8RkPgkbH2dg
suuTPTcp3fA4UMgtZ5KB2vdTEgPp3ZC+64hxwDQZn8mJzoDV3ZBFL16yeZaB
j/7sWBxk0A15o2oTc3MM1CqMMwrf3g3/A5ZtLhw=
      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {-1.6524706590041909`, 1.4050205620750016`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.749323589859363*^9, 3.7495027870369577`*^9, 
  3.749502854040633*^9, 3.749573716066609*^9, 3.75166371982146*^9, 
  3.7516638280030527`*^9, 3.751663895987569*^9, 3.751664238553171*^9, 
  3.752323855978408*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem #3)", "Section",
 CellChangeTimes->{{3.749321821140115*^9, 3.7493218270339613`*^9}, {
  3.751664298532412*^9, 3.7516642986331367`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.749321830601275*^9, 3.749321836628338*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"T", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", " ", 
     RowBox[{"v1", "^", "2"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], "m", " ", 
     RowBox[{"v2", "^", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.74932107706453*^9, 3.74932108533461*^9}, {
  3.74932232573177*^9, 3.7493223282229567`*^9}, {3.751664307955811*^9, 
  3.7516643253250732`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"m", " ", 
    SuperscriptBox["v1", "2"]}], "2"], "+", 
  FractionBox[
   RowBox[{"m", " ", 
    SuperscriptBox["v2", "2"]}], "2"]}]], "Output",
 CellChangeTimes->{
  3.749321086078352*^9, 3.749321838963299*^9, {3.749322232490766*^9, 
   3.7493222490130367`*^9}, 3.7493223752576036`*^9, 3.751664329185852*^9, 
   3.752323879740088*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"(", 
      RowBox[{"3", "k"}], ")"}], " ", 
     RowBox[{"x1", "^", "2"}]}], " ", "+", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"(", 
      RowBox[{"2", "k"}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x1", "-", "x2"}], ")"}], "^", "2"}]}]}], " ", "//", 
   "Expand"}]}]], "Input",
 CellChangeTimes->{{3.749321083580853*^9, 3.749321083581294*^9}, {
  3.749322335951129*^9, 3.749322339547496*^9}, {3.751664337588853*^9, 
  3.751664376189242*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"5", " ", "k", " ", 
    SuperscriptBox["x1", "2"]}], "2"], "-", 
  RowBox[{"2", " ", "k", " ", "x1", " ", "x2"}], "+", 
  RowBox[{"k", " ", 
   SuperscriptBox["x2", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.74932108944025*^9, 3.749321838996352*^9, {3.749322232512086*^9, 
   3.749322249028737*^9}, 3.749322375290928*^9, 3.751664376735621*^9, 
   3.752323879761425*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"T", ",", "v1"}], "]"}]], "Input",
 CellChangeTimes->{{3.752323885554818*^9, 3.752323888265585*^9}}],

Cell[BoxData[
 RowBox[{"m", " ", "v1"}]], "Output",
 CellChangeTimes->{3.752323888553051*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tmat", "=", 
   RowBox[{"m", "  ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.7493211011181173`*^9, 3.7493211127788353`*^9}, {
  3.751664457185011*^9, 3.7516644603132477`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"m", "0"},
     {"0", "m"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.749321102769998*^9, 3.749321113123559*^9}, 
   3.749321839028906*^9, {3.749322232533512*^9, 3.7493222490446777`*^9}, 
   3.749322375325246*^9, 3.751664460793027*^9, 3.752323879783207*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "x1"}], "]"}]], "Input",
 CellChangeTimes->{{3.752323892074566*^9, 3.752323895401774*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", "k", " ", "x1"}], "-", 
  RowBox[{"2", " ", "k", " ", "x2"}]}]], "Output",
 CellChangeTimes->{3.752323895654223*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "x2"}], "]"}]], "Input",
 CellChangeTimes->{{3.752323897117475*^9, 3.7523238987937937`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "k", " ", "x1"}], "+", 
  RowBox[{"2", " ", "k", " ", "x2"}]}]], "Output",
 CellChangeTimes->{3.75232389901341*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vmat", "=", 
   RowBox[{"k", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"-", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"Vmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321119969179*^9, 3.749321121327619*^9}, {
  3.751664487398901*^9, 3.751664505213046*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"5", " ", "k"}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "k"}]},
     {
      RowBox[{
       RowBox[{"-", "2"}], " ", "k"}], 
      RowBox[{"2", " ", "k"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7493211218063717`*^9, 3.7493218390625896`*^9, {3.749322232555344*^9, 
   3.7493222490640173`*^9}, 3.7493223753556423`*^9, {3.7516645005012302`*^9, 
   3.751664505781662*^9}, 3.752323879804613*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", " ", 
   RowBox[{"Vmat", "-", 
    RowBox[{"Tmat", " ", "\[Omega]2"}]}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321147606707*^9, 3.7493211476072903`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"5", " ", "k"}], "-", 
       RowBox[{"m", " ", "\[Omega]2"}]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "k"}]},
     {
      RowBox[{
       RowBox[{"-", "2"}], " ", "k"}], 
      RowBox[{
       RowBox[{"2", " ", "k"}], "-", 
       RowBox[{"m", " ", "\[Omega]2"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749321148838374*^9, 3.749321839090378*^9, {3.749322232578562*^9, 
   3.749322249085602*^9}, 3.7493223753817043`*^9, 3.7516645083181267`*^9, 
   3.752323879825858*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", "mat", "]"}], " ", "==", "0"}], ",", "\[Omega]2"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.749321154612245*^9, 3.7493211546128817`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox["k", "m"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox[
      RowBox[{"6", " ", "k"}], "m"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493211556547318`*^9, 3.74932138678651*^9, 3.749321839114006*^9, {
   3.749322232609325*^9, 3.7493222491092377`*^9}, 3.749322375408472*^9, 
   3.7516645109232492`*^9, 3.752323879846382*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"eq1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"mat", " ", ".", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}]}], " ", "==", "0"}], " ", "//", 
      "Thread"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"eq1", " ", "//", "Column"}]}]}]], "Input",
 CellChangeTimes->{{3.749321161605517*^9, 3.749321183211232*^9}, {
  3.7516645244652033`*^9, 3.751664524680193*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "b", " ", "k"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", "k"}], "-", 
          RowBox[{"m", " ", "\[Omega]2"}]}], ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a", " ", "k"}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "k"}], "-", 
          RowBox[{"m", " ", "\[Omega]2"}]}], ")"}]}]}], "\[Equal]", "0"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.74932116268566*^9, 3.74932119032952*^9}, 
   3.749321396359067*^9, 3.749321839118869*^9, {3.749322232639194*^9, 
   3.749322249134534*^9}, 3.749322375435999*^9, 3.751664525159011*^9, 
   3.75232387986919*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"norm", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"b", "^", "2"}]}], "==", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.7493211991680717`*^9, 3.749321199169052*^9}, 
   3.751664529067877*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{
  3.749321200575139*^9, 3.749321397845058*^9, 3.749321839143249*^9, {
   3.749322232660159*^9, 3.7493222491505213`*^9}, 3.7493223754411707`*^9, 
   3.7516645295637302`*^9, 3.752323879891328*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"eq1", ",", 
     RowBox[{"{", "norm", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eq2", " ", "//", "Column"}]}], "Input",
 CellChangeTimes->{{3.749321206990931*^9, 3.7493212177986507`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "b", " ", "k"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", "k"}], "-", 
          RowBox[{"m", " ", "\[Omega]2"}]}], ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a", " ", "k"}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "k"}], "-", 
          RowBox[{"m", " ", "\[Omega]2"}]}], ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.7493212082250843`*^9, 3.749321218080167*^9}, 
   3.749321398761321*^9, 3.749321839166089*^9, {3.749322232664649*^9, 
   3.749322249166909*^9}, 3.749322375460807*^9, 3.751664532563075*^9, 
   3.752323879895389*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq2", " ", "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "]"}], " ", "//", "Last"}]}]], "Input",\

 CellChangeTimes->{{3.749321281667933*^9, 3.749321281668489*^9}, {
  3.7493214127151833`*^9, 3.749321412834794*^9}, {3.749321483116372*^9, 
  3.749321483251974*^9}, {3.7516645360575247`*^9, 3.751664536266477*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    FractionBox["1", 
     SqrtBox["5"]]}], ",", 
   RowBox[{"b", "\[Rule]", 
    FractionBox["2", 
     SqrtBox["5"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321282961935*^9, 3.7493214138669443`*^9, 3.749321484200245*^9, 
   3.749321579544352*^9, 3.749321839206811*^9, {3.749322232711966*^9, 
   3.749322249208243*^9}, 3.749322375504106*^9, 3.751664536762453*^9, 
   3.7523238799185867`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev1", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", "sol1"}]}]], "Input",
 CellChangeTimes->{{3.7493215953760967`*^9, 3.749321595376754*^9}, {
  3.7516645402686567`*^9, 3.7516645404938927`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["5"]], ",", 
   FractionBox["2", 
    SqrtBox["5"]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493215968292923`*^9, 3.7493218392515574`*^9, {3.749322232741692*^9, 
   3.749322249228471*^9}, 3.749322375537078*^9, 3.75166454100842*^9, 
   3.752323879939007*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"eq2", " ", "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}], "  "}]], "Input",
 CellChangeTimes->{{3.7493216444811983`*^9, 3.749321644482582*^9}, {
   3.751664544024033*^9, 3.751664544217238*^9}, 3.751664585392455*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["2", 
        SqrtBox["5"]]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["5"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["2", 
       SqrtBox["5"]]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["5"]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321645407696*^9, 3.7493218392978277`*^9, {3.7493222327954063`*^9, 
   3.7493222492697144`*^9}, 3.749322375580277*^9, 3.75166454496656*^9, 
   3.751664585847542*^9, 3.752323879963043*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev2", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", 
   RowBox[{"Last", "[", "sol2", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.749321667404428*^9, 3.7493216674057903`*^9}, 
   3.749322402473234*^9, {3.751664547901451*^9, 3.751664548090701*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", 
    SqrtBox["5"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["5"]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321668333529*^9, 3.749321839336825*^9, {3.749322232827527*^9, 
   3.7493222492899113`*^9}, {3.7493223756065197`*^9, 3.749322402982037*^9}, 
   3.751664548581481*^9, 3.75166458944842*^9, 3.752323879967162*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eVecs", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ev1", ",", "ev2"}], "}"}], " ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7493216918620853`*^9, 3.7493216918635073`*^9}, {
  3.7516646040322933`*^9, 3.7516646252232924`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["5"]], ",", 
     FractionBox["2", 
      SqrtBox["5"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", 
      SqrtBox["5"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["5"]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321693128323*^9, 3.749321839370804*^9, {3.74932223285415*^9, 
   3.749322249306244*^9}, 3.749322375628832*^9, 3.75166462567171*^9, 
   3.752323879991976*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eVecs", ".", "eVecs"}]], "Input",
 CellChangeTimes->{{3.7516646289835243`*^9, 3.751664632668223*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.751664633184065*^9, 3.752323879995906*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vdiag", "=", 
   RowBox[{
    RowBox[{"eVecs", ".", "Vmat", ".", 
     RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", "Simplify"}]}], 
  " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Vdiag", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321720002384*^9, 3.749321769158223*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"k", "0"},
     {"0", 
      RowBox[{"6", " ", "k"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.749321728522335*^9, 3.749321737778191*^9}, 
   3.7493217694597387`*^9, 3.749321839406513*^9, {3.7493222328809147`*^9, 
   3.749322249322722*^9}, 3.749322375653091*^9, 3.751664638696513*^9, 
   3.752323880019279*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tdiag", "=", 
   RowBox[{
    RowBox[{"eVecs", ".", "Tmat", ".", 
     RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tdiag", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321777235162*^9, 3.749321787371119*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"m", "0"},
     {"0", "m"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749321787720387*^9, 3.749321839438725*^9, {3.749322232902491*^9, 
   3.749322249339321*^9}, 3.749322375679388*^9, 3.7516646460837593`*^9, 
   3.752323880042506*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem #4)", "Section",
 CellChangeTimes->{{3.749321821140115*^9, 3.7493218270339613`*^9}, {
  3.751664298532412*^9, 3.7516642986331367`*^9}, {3.7516646781398907`*^9, 
  3.751664678293292*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.749321830601275*^9, 3.749321836628338*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"T", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "m", " ", 
      RowBox[{"v1", "^", "2"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], "m", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"v1", "+", 
         RowBox[{"L", " ", "d\[Theta]"}]}], ")"}], "^", "2"}]}]}], " ", "//", 
    "Expand"}]}]}]], "Input",
 CellChangeTimes->{{3.74932107706453*^9, 3.74932108533461*^9}, {
  3.74932232573177*^9, 3.7493223282229567`*^9}, {3.751664307955811*^9, 
  3.7516643253250732`*^9}, {3.751664763751994*^9, 3.751664772898234*^9}, {
  3.7516649128304453`*^9, 3.751664914876001*^9}, {3.752323991451345*^9, 
  3.752323992711875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["d\[Theta]", "2"], " ", 
   SuperscriptBox["L", "2"], " ", "m"}], "+", 
  RowBox[{"d\[Theta]", " ", "L", " ", "m", " ", "v1"}], "+", 
  RowBox[{"m", " ", 
   SuperscriptBox["v1", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.749321086078352*^9, 3.749321838963299*^9, {3.749322232490766*^9, 
   3.7493222490130367`*^9}, 3.7493223752576036`*^9, 3.751664329185852*^9, 
   3.751664781546464*^9, 3.751664915195331*^9, 3.752323911365851*^9, 
   3.752323997658766*^9, 3.7523241688380957`*^9, 3.7523244149082937`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "g", " ", "L", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}], "+", " ", 
    RowBox[{
     FractionBox["1", "2"], "k", " ", 
     SuperscriptBox["x", "2"]}]}], "//", "Expand"}]}]], "Input",
 CellChangeTimes->{{3.749321083580853*^9, 3.749321083581294*^9}, {
  3.749322335951129*^9, 3.749322339547496*^9}, {3.751664337588853*^9, 
  3.751664376189242*^9}, {3.7516647909681683`*^9, 3.751664813781786*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "L", " ", "m"}], "+", 
  FractionBox[
   RowBox[{"k", " ", 
    SuperscriptBox["x", "2"]}], "2"], "-", 
  RowBox[{"g", " ", "L", " ", "m", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.74932108944025*^9, 3.749321838996352*^9, {3.749322232512086*^9, 
   3.749322249028737*^9}, 3.749322375290928*^9, 3.751664376735621*^9, 
   3.751664819409754*^9, 3.752323911387507*^9, 3.7523240008848743`*^9, 
   3.7523241688600883`*^9, 3.7523244149354353`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "2"}], "}"}]}], "]"}], " ", "//", 
  "Normal"}]], "Input",
 CellChangeTimes->{{3.751664827089376*^9, 3.751664871365975*^9}, {
  3.752324010519559*^9, 3.75232401701582*^9}, {3.752324086965992*^9, 
  3.7523240871416893`*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   SuperscriptBox["\[Theta]", "2"], "2"]}]], "Output",
 CellChangeTimes->{
  3.7516648377123528`*^9, {3.751664868488139*^9, 3.751664871719101*^9}, 
   3.752323911470003*^9, 3.752324017608336*^9, 3.752324087675414*^9, 
   3.752324168881833*^9, 3.752324414962206*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{"V", " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "\[Rule]", 
      RowBox[{"1", "-", 
       FractionBox[
        SuperscriptBox["\[Theta]", "2"], "2"]}]}], "}"}]}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.752324022027954*^9, 3.7523240381680737`*^9}, {
  3.7523240698144703`*^9, 3.752324077736945*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"k", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"g", " ", "L", " ", "m", " ", 
     SuperscriptBox["\[Theta]", "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.752324038854473*^9, {3.7523240726084623`*^9, 3.752324077975843*^9}, 
   3.752324168903715*^9, 3.7523244149830837`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"T", ",", "v1"}], "]"}]], "Input",
 CellChangeTimes->{{3.752324097471232*^9, 3.752324102229373*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[Theta]", " ", "L", " ", "m"}], "+", 
  RowBox[{"2", " ", "m", " ", "v1"}]}]], "Output",
 CellChangeTimes->{3.752324102466586*^9, 3.752324168908371*^9, 
  3.7523244149929543`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"T", ",", "d\[Theta]"}], "]"}]], "Input",
 CellChangeTimes->{{3.752324103241207*^9, 3.75232410738174*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d\[Theta]", " ", 
   SuperscriptBox["L", "2"], " ", "m"}], "+", 
  RowBox[{"L", " ", "m", " ", "v1"}]}]], "Output",
 CellChangeTimes->{3.752324107650642*^9, 3.752324168928994*^9, 
  3.752324415019226*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tmat", "=", 
   RowBox[{"m", " ", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "L"}], " ", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"L", ",", 
        SuperscriptBox["L", "2"]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.7493211011181173`*^9, 3.7493211127788353`*^9}, {
   3.751664457185011*^9, 3.7516644603132477`*^9}, {3.751664938223125*^9, 
   3.7516649987523193`*^9}, 3.752324127125387*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", " ", "m"}], 
      RowBox[{"L", " ", "m"}]},
     {
      RowBox[{"L", " ", "m"}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "m"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.749321102769998*^9, 3.749321113123559*^9}, 
   3.749321839028906*^9, {3.749322232533512*^9, 3.7493222490446777`*^9}, 
   3.749322375325246*^9, 3.751664460793027*^9, {3.75166498657514*^9, 
   3.7516649992105*^9}, 3.752323911491173*^9, 3.752324094982127*^9, 
   3.75232412793226*^9, 3.752324168950672*^9, 3.752324415046002*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.752324134935*^9, 3.75232414029364*^9}}],

Cell[BoxData[
 RowBox[{"k", " ", "x"}]], "Output",
 CellChangeTimes->{{3.752324138181774*^9, 3.75232416897017*^9}, 
   3.7523244150732307`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"V", ",", "\[Theta]"}], "]"}]], "Input",
 CellChangeTimes->{{3.752324142039504*^9, 3.752324144805017*^9}}],

Cell[BoxData[
 RowBox[{"g", " ", "L", " ", "m", " ", "\[Theta]"}]], "Output",
 CellChangeTimes->{{3.752324145060277*^9, 3.7523241689896*^9}, 
   3.75232441510075*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vmat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"g", " ", "L", " ", "m"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Vmat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321119969179*^9, 3.749321121327619*^9}, {
   3.751664487398901*^9, 3.751664505213046*^9}, {3.751665020943573*^9, 
   3.751665067771657*^9}, 3.752324149029076*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"k", "0"},
     {"0", 
      RowBox[{"g", " ", "L", " ", "m"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7493211218063717`*^9, 3.7493218390625896`*^9, {3.749322232555344*^9, 
   3.7493222490640173`*^9}, 3.7493223753556423`*^9, {3.7516645005012302`*^9, 
   3.751664505781662*^9}, 3.751665068851091*^9, 3.752323911511827*^9, {
   3.752324150236264*^9, 3.7523241690092783`*^9}, 3.7523244151272173`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", " ", 
   RowBox[{"Vmat", "-", 
    RowBox[{"Tmat", " ", "\[Omega]2"}]}]}], ";"}], "\n", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321147606707*^9, 3.7493211476072903`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"k", "-", 
       RowBox[{"2", " ", "m", " ", "\[Omega]2"}]}], 
      RowBox[{
       RowBox[{"-", "L"}], " ", "m", " ", "\[Omega]2"}]},
     {
      RowBox[{
       RowBox[{"-", "L"}], " ", "m", " ", "\[Omega]2"}], 
      RowBox[{
       RowBox[{"g", " ", "L", " ", "m"}], "-", 
       RowBox[{
        SuperscriptBox["L", "2"], " ", "m", " ", "\[Omega]2"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749321148838374*^9, 3.749321839090378*^9, {3.749322232578562*^9, 
   3.749322249085602*^9}, 3.7493223753817043`*^9, 3.7516645083181267`*^9, 
   3.751665073935688*^9, 3.751665460765698*^9, 3.751665913262786*^9, 
   3.752323911532344*^9, 3.752324169028479*^9, 3.752324415153675*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rules1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      FractionBox["k", "m"], "\[Equal]", 
      FractionBox["g", "L"]}], ",", "k"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7516651231740513`*^9, 3.751665154435053*^9}, {
  3.7516654197832813`*^9, 3.751665453473816*^9}, {3.751665887945944*^9, 
  3.7516659048943033`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"k", "\[Rule]", 
   FractionBox[
    RowBox[{"g", " ", "m"}], "L"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.751665155180985*^9, {3.7516654204932013`*^9, 3.7516654631420603`*^9}, {
   3.7516659014662724`*^9, 3.7516659141981983`*^9}, 3.752323911553574*^9, 
   3.752324169048663*^9, 3.752324415180155*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{
    RowBox[{"mat", " ", "//.", "rules1"}], " ", "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.751665157959111*^9, 3.751665171739956*^9}, {
  3.751665368390493*^9, 3.7516653709832563`*^9}, {3.751665423146439*^9, 
  3.751665423602209*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"m", " ", 
        RowBox[{"(", 
         RowBox[{"g", "-", 
          RowBox[{"2", " ", "L", " ", "\[Omega]2"}]}], ")"}]}], "L"], 
      RowBox[{
       RowBox[{"-", "L"}], " ", "m", " ", "\[Omega]2"}]},
     {
      RowBox[{
       RowBox[{"-", "L"}], " ", "m", " ", "\[Omega]2"}], 
      RowBox[{"L", " ", "m", " ", 
       RowBox[{"(", 
        RowBox[{"g", "-", 
         RowBox[{"L", " ", "\[Omega]2"}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.751665161853362*^9, 3.751665172011241*^9}, 
   3.751665371267819*^9, {3.751665423965345*^9, 3.751665464274329*^9}, {
   3.751665907291082*^9, 3.751665914947994*^9}, 3.7523239115753593`*^9, 
   3.752324169070939*^9, 3.752324415208905*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", "mat", "]"}], " ", "==", "0"}], ",", "\[Omega]2"}], 
    "]"}], " ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.749321154612245*^9, 3.7493211546128817`*^9}, {
  3.7516650925947027`*^9, 3.751665094878145*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox["5"]}], ")"}], " ", "g"}], 
       RowBox[{"2", " ", "L"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]2", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", 
         SqrtBox["5"]}], ")"}], " ", "g"}], 
      RowBox[{"2", " ", "L"}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493211556547318`*^9, 3.74932138678651*^9, 3.749321839114006*^9, {
   3.749322232609325*^9, 3.7493222491092377`*^9}, 3.749322375408472*^9, 
   3.7516645109232492`*^9, {3.751665077142622*^9, 3.7516650951660624`*^9}, 
   3.751665172986113*^9, 3.751665497510247*^9, {3.75166590880886*^9, 
   3.751665916710905*^9}, 3.752323911590885*^9, 3.7523241690880938`*^9, 
   3.752324415229725*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"eq1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"mat", " ", ".", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}]}], " ", "==", "0"}], " ", "//", 
      "Thread"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"eq1", " ", "//", "Column"}]}]}]], "Input",
 CellChangeTimes->{{3.749321161605517*^9, 3.749321183211232*^9}, {
  3.7516645244652033`*^9, 3.751664524680193*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "L", " ", "m", " ", "\[Omega]2"}], "+", 
       FractionBox[
        RowBox[{"a", " ", "m", " ", 
         RowBox[{"(", 
          RowBox[{"g", "-", 
           RowBox[{"2", " ", "L", " ", "\[Omega]2"}]}], ")"}]}], "L"]}], 
      "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", "L", " ", "m", " ", "\[Omega]2"}], "+", 
       RowBox[{"b", " ", "L", " ", "m", " ", 
        RowBox[{"(", 
         RowBox[{"g", "-", 
          RowBox[{"L", " ", "\[Omega]2"}]}], ")"}]}]}], "\[Equal]", "0"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.74932116268566*^9, 3.74932119032952*^9}, 
   3.749321396359067*^9, 3.749321839118869*^9, {3.749322232639194*^9, 
   3.749322249134534*^9}, 3.749322375435999*^9, 3.751664525159011*^9, 
   3.75166551681985*^9, 3.751665924850765*^9, 3.752323911613229*^9, 
   3.752324169096779*^9, 3.7523244152398853`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"norm", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "+", 
     RowBox[{"b", "^", "2"}]}], "==", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.7493211991680717`*^9, 3.749321199169052*^9}, 
   3.751664529067877*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{
  3.749321200575139*^9, 3.749321397845058*^9, 3.749321839143249*^9, {
   3.749322232660159*^9, 3.7493222491505213`*^9}, 3.7493223754411707`*^9, 
   3.7516645295637302`*^9, 3.751665519351172*^9, 3.751665925714003*^9, 
   3.7523239116207438`*^9, 3.75232416911796*^9, 3.752324415266055*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"eq1", ",", 
     RowBox[{"{", "norm", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eq2", " ", "//", "Column"}]}], "Input",
 CellChangeTimes->{{3.749321206990931*^9, 3.7493212177986507`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "L", " ", "m", " ", "\[Omega]2"}], "+", 
       FractionBox[
        RowBox[{"a", " ", "m", " ", 
         RowBox[{"(", 
          RowBox[{"g", "-", 
           RowBox[{"2", " ", "L", " ", "\[Omega]2"}]}], ")"}]}], "L"]}], 
      "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", "L", " ", "m", " ", "\[Omega]2"}], "+", 
       RowBox[{"b", " ", "L", " ", "m", " ", 
        RowBox[{"(", 
         RowBox[{"g", "-", 
          RowBox[{"L", " ", "\[Omega]2"}]}], ")"}]}]}], "\[Equal]", "0"}]},
    {
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], "\[Equal]", "1"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{{3.7493212082250843`*^9, 3.749321218080167*^9}, 
   3.749321398761321*^9, 3.749321839166089*^9, {3.749322232664649*^9, 
   3.749322249166909*^9}, 3.749322375460807*^9, 3.751664532563075*^9, 
   3.751665520239748*^9, 3.7516659264424133`*^9, 3.752323911642458*^9, 
   3.752324169140656*^9, 3.752324415290662*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eq2", " ", "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "   ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.749321281667933*^9, 3.749321281668489*^9}, {
  3.7493214127151833`*^9, 3.749321412834794*^9}, {3.749321483116372*^9, 
  3.749321483251974*^9}, {3.7516645360575247`*^9, 3.751664536266477*^9}, {
  3.751665566287619*^9, 3.75166556820872*^9}, {3.751665602193852*^9, 
  3.751665639310492*^9}, {3.751665682781144*^9, 3.7516656947089167`*^9}, {
  3.7523242112040453`*^9, 3.752324226979331*^9}, {3.7523242629465714`*^9, 
  3.752324285317663*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}], " ", "L"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["5"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]}]]}], ",", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321282961935*^9, 3.7493214138669443`*^9, 3.749321484200245*^9, 
   3.749321579544352*^9, 3.749321839206811*^9, {3.749322232711966*^9, 
   3.749322249208243*^9}, 3.749322375504106*^9, 3.751664536762453*^9, 
   3.751665522127817*^9, 3.751665568594235*^9, {3.751665602877008*^9, 
   3.751665639555483*^9}, {3.75166568397521*^9, 3.7516656951243763`*^9}, 
   3.751665927143774*^9, 3.7523239117413282`*^9, 3.752324169220134*^9, {
   3.752324211383277*^9, 3.752324227343038*^9}, {3.752324268565761*^9, 
   3.7523242856140223`*^9}, 3.752324415327571*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev1", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", "sol1"}]}]], "Input",
 CellChangeTimes->{{3.7493215953760967`*^9, 3.749321595376754*^9}, {
  3.7516645402686567`*^9, 3.7516645404938927`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"]}], ")"}], " ", "L"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       SqrtBox["5"]}], ")"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SqrtBox["5"]}], ")"}], " ", 
        SuperscriptBox["L", "2"]}]}]]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["2"]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SqrtBox["5"]}], ")"}], " ", 
        SuperscriptBox["L", "2"]}]}]]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7493215968292923`*^9, 3.7493218392515574`*^9, {3.749322232741692*^9, 
   3.749322249228471*^9}, 3.749322375537078*^9, 3.75166454100842*^9, 
   3.751665698505961*^9, 3.751665927952854*^9, 3.752323911768236*^9, 
   3.752324169244812*^9, 3.7523244153525763`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"eq2", " ", "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "  ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7493216444811983`*^9, 3.749321644482582*^9}, {
   3.751664544024033*^9, 3.751664544217238*^9}, 3.751664585392455*^9, {
   3.751665705740974*^9, 3.7516657126902323`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SqrtBox["5"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["5"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}]], " ", "L"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]}]]}], ",", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SqrtBox[
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}]], 
      SqrtBox[
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321645407696*^9, 3.7493218392978277`*^9, {3.7493222327954063`*^9, 
   3.7493222492697144`*^9}, 3.749322375580277*^9, 3.75166454496656*^9, 
   3.751664585847542*^9, {3.7516657014364357`*^9, 3.751665713126824*^9}, 
   3.75166592899492*^9, 3.75232391183333*^9, 3.7523241693070917`*^9, 
   3.752324415389683*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev2", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", "/.", "sol2"}]}]], "Input",
 CellChangeTimes->{{3.749321667404428*^9, 3.7493216674057903`*^9}, 
   3.749322402473234*^9, {3.751664547901451*^9, 3.751664548090701*^9}, {
   3.751665732058434*^9, 3.751665732562866*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"7", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}]], " ", "L"}], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"7", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SqrtBox["5"]}], ")"}], " ", 
        SuperscriptBox["L", "2"]}]}]]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{"7", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}]}]], 
     SqrtBox[
      RowBox[{"7", "+", 
       RowBox[{"3", " ", 
        SqrtBox["5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SqrtBox["5"]}], ")"}], " ", 
        SuperscriptBox["L", "2"]}]}]]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321668333529*^9, 3.749321839336825*^9, {3.749322232827527*^9, 
   3.7493222492899113`*^9}, {3.7493223756065197`*^9, 3.749322402982037*^9}, 
   3.751664548581481*^9, 3.75166458944842*^9, {3.751665715523757*^9, 
   3.751665732916685*^9}, 3.751665929621319*^9, 3.752323911860957*^9, 
   3.752324169348374*^9, 3.752324415413225*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eVecs", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ev1", ",", "ev2"}], "}"}], " ", "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7493216918620853`*^9, 3.7493216918635073`*^9}, {
  3.7516646040322933`*^9, 3.7516646252232924`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}], " ", "L"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         SqrtBox["5"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}], " ", 
          SuperscriptBox["L", "2"]}]}]]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["2"]}], 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}], " ", 
          SuperscriptBox["L", "2"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SqrtBox["5"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         SqrtBox["5"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{"7", "+", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}]], " ", "L"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"7", "+", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}], " ", 
          SuperscriptBox["L", "2"]}]}]]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"7", "+", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}]}]], 
       SqrtBox[
        RowBox[{"7", "+", 
         RowBox[{"3", " ", 
          SqrtBox["5"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}], " ", 
          SuperscriptBox["L", "2"]}]}]]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.749321693128323*^9, 3.749321839370804*^9, {3.74932223285415*^9, 
   3.749322249306244*^9}, 3.749322375628832*^9, 3.75166462567171*^9, 
   3.751665735285307*^9, 3.75166593025587*^9, 3.752323911889791*^9, 
   3.752324169384573*^9, 3.752324415442107*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eVecs", ".", "eVecs"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7516646289835243`*^9, 3.751664632668223*^9}, {
   3.751665739985523*^9, 3.7516657576845713`*^9}, 3.751665805755054*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "L"}], 
         RowBox[{"3", "-", 
          SqrtBox["5"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["L", "2"]}]}]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["5"]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{
             SuperscriptBox["L", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               SuperscriptBox["L", "2"]}], ")"}]}]}]]}]]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}], ")"}], " ", "L"}], 
       RowBox[{"3", "-", 
        SqrtBox["5"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"]}]}]], "+", 
      FractionBox["\[ImaginaryI]", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{
          SuperscriptBox["L", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SuperscriptBox["L", "2"]}], ")"}]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             SqrtBox["5"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["L", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{
              SuperscriptBox["L", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"3", "+", 
                SuperscriptBox["L", "2"]}], ")"}]}]}]]}]}], ")"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox["5"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["L", "2"]}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["L", "2"]}]}], ")"}], 
         RowBox[{"3", "/", "2"}]]}]]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1", "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}], ")"}], " ", "L"}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{
           SuperscriptBox["L", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             SuperscriptBox["L", "2"]}], ")"}]}]}]]}]]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.751664633184065*^9, {3.751665737762724*^9, 3.7516657580819883`*^9}, 
   3.7516658063053293`*^9, 3.7516659309358397`*^9, 3.752323913842115*^9, 
   3.752324171278041*^9, 3.752324415546072*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vdiag", "=", 
   RowBox[{
    RowBox[{"eVecs", ".", "Vmat", ".", 
     RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "//", 
    "FullSimplify"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Vdiag", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321720002384*^9, 3.749321769158223*^9}, {
  3.751665814823187*^9, 3.751665849398672*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"k", "+", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "k"}], "+", 
         RowBox[{"2", " ", "g", " ", "L", " ", "m"}]}], 
        RowBox[{"2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SqrtBox["5"]}], ")"}], " ", 
          SuperscriptBox["L", "2"]}]}]]}], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "k"}], " ", "L"}], "+", 
          RowBox[{"g", " ", "m"}]}], ")"}]}], 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{
          SuperscriptBox["L", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SuperscriptBox["L", "2"]}], ")"}]}]}]]]},
     {
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "k"}], " ", "L"}], "+", 
          RowBox[{"g", " ", "m"}]}], ")"}]}], 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{
          SuperscriptBox["L", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            SuperscriptBox["L", "2"]}], ")"}]}]}]]], 
      FractionBox[
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             SqrtBox["5"]}], ")"}], " ", "k", " ", "L"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"7", "+", 
             RowBox[{"3", " ", 
              SqrtBox["5"]}]}], ")"}], " ", "g", " ", "m"}]}], ")"}]}], 
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.751665850048552*^9, 3.751665931709997*^9, 
  3.7523239141429443`*^9, 3.752324171514119*^9, 3.752324415613562*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vdiag", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"eVecs", ".", "Vmat", ".", 
      RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "/.", "rules1"}], "//",
     "FullSimplify"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Vdiag", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321720002384*^9, 3.749321769158223*^9}, {
  3.751665814823187*^9, 3.75166582323205*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}], " ", "g", " ", "L", " ", "m"}], 
       RowBox[{"2", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]], "0"},
     {"0", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}], ")"}], " ", "g", " ", "L", " ", "m"}], 
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.749321728522335*^9, 3.749321737778191*^9}, 
   3.7493217694597387`*^9, 3.749321839406513*^9, {3.7493222328809147`*^9, 
   3.749322249322722*^9}, 3.749322375653091*^9, 3.751664638696513*^9, {
   3.751665792966604*^9, 3.751665823692347*^9}, 3.75166593365935*^9, 
   3.7523239142627563`*^9, 3.752324171647229*^9, 3.752324415646682*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tdiag", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"eVecs", ".", "Tmat", ".", 
      RowBox[{"Transpose", "[", "eVecs", "]"}]}], " ", "/.", "rules1"}], "//",
     "FullSimplify"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Tdiag", " ", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.749321777235162*^9, 3.749321787371119*^9}, {
  3.751665966368369*^9, 3.751665968596695*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}], ")"}], " ", 
        SuperscriptBox["L", "2"], " ", "m"}], 
       RowBox[{"2", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]], "0"},
     {"0", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}], " ", 
        SuperscriptBox["L", "2"], " ", "m"}], 
       RowBox[{"7", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SqrtBox["5"]}], ")"}], " ", 
         SuperscriptBox["L", "2"]}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.749321787720387*^9, 3.749321839438725*^9, {3.749322232902491*^9, 
   3.749322249339321*^9}, 3.749322375679388*^9, 3.7516646460837593`*^9, {
   3.75166596001071*^9, 3.751665969095105*^9}, 3.752323914344887*^9, 
   3.75232417172921*^9, 3.7523244156939173`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1918, 1003},
WindowMargins->{{1, Automatic}, {1, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"11.0 for Linux x86 (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 98, 1, 96, "Section"],
Cell[681, 25, 139, 2, 52, "Input"],
Cell[CellGroupData[{
Cell[845, 31, 437, 12, 86, "Input"],
Cell[1285, 45, 490, 12, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1812, 62, 650, 19, 86, "Input"],
Cell[2465, 83, 831, 23, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3333, 111, 154, 3, 46, "Input"],
Cell[3490, 116, 182, 4, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3709, 125, 378, 10, 77, "Input"],
Cell[4090, 137, 997, 27, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5124, 169, 151, 3, 46, "Input"],
Cell[5278, 174, 364, 9, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5679, 188, 643, 20, 77, "Input"],
Cell[6325, 210, 1490, 46, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7852, 261, 257, 6, 115, "Input"],
Cell[8112, 269, 1803, 55, 210, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9952, 329, 253, 7, 69, "Input"],
Cell[10208, 338, 586, 16, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10831, 359, 415, 12, 115, "Input"],
Cell[11249, 373, 1908, 58, 199, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13194, 436, 286, 8, 69, "Input"],
Cell[13483, 446, 380, 9, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13900, 460, 290, 7, 115, "Input"],
Cell[14193, 469, 2079, 64, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16309, 538, 471, 13, 69, "Input"],
Cell[16783, 553, 271, 6, 51, "Message"],
Cell[17057, 561, 550, 16, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17644, 582, 212, 6, 69, "Input"],
Cell[17859, 590, 382, 12, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18278, 607, 392, 11, 69, "Input"],
Cell[18673, 620, 269, 6, 51, "Message"],
Cell[18945, 628, 978, 33, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19960, 666, 268, 7, 69, "Input"],
Cell[20231, 675, 391, 11, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20659, 691, 300, 8, 69, "Input"],
Cell[20962, 701, 369, 11, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21368, 717, 334, 9, 69, "Input"],
Cell[21705, 728, 812, 30, 130, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22554, 763, 464, 11, 160, "Input"],
Cell[23021, 776, 146, 2, 69, "Output"],
Cell[23170, 780, 375, 10, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23582, 795, 333, 8, 115, "Input"],
Cell[23918, 805, 987, 26, 201, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24942, 836, 333, 8, 115, "Input"],
Cell[25278, 846, 976, 28, 210, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26303, 880, 124, 2, 73, "Section"],
Cell[26430, 884, 139, 2, 78, "Input"],
Cell[CellGroupData[{
Cell[26594, 890, 1015, 30, 459, "Input"],
Cell[27612, 922, 536, 14, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28185, 941, 505, 15, 129, "Input"],
Cell[28693, 958, 539, 15, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29269, 978, 179, 4, 69, "Input"],
Cell[29451, 984, 252, 7, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29740, 996, 180, 4, 69, "Input"],
Cell[29923, 1002, 240, 7, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30200, 1014, 558, 18, 175, "Input"],
Cell[30761, 1034, 974, 29, 189, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31772, 1068, 146, 3, 69, "Input"],
Cell[31921, 1073, 183, 5, 102, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32141, 1083, 146, 3, 69, "Input"],
Cell[32290, 1088, 185, 5, 102, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32512, 1098, 471, 14, 228, "Input"],
Cell[32986, 1114, 828, 23, 189, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33851, 1142, 267, 6, 115, "Input"],
Cell[34121, 1150, 1150, 33, 189, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35308, 1188, 275, 8, 69, "Input"],
Cell[35586, 1198, 488, 14, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36111, 1217, 270, 8, 69, "Input"],
Cell[36384, 1227, 890, 28, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37311, 1260, 226, 6, 69, "Input"],
Cell[37540, 1268, 318, 8, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37895, 1281, 204, 5, 69, "Input"],
Cell[38102, 1288, 1007, 32, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39146, 1325, 310, 9, 69, "Input"],
Cell[39459, 1336, 703, 24, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40199, 1365, 388, 12, 69, "Input"],
Cell[40590, 1379, 420, 13, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41047, 1397, 200, 5, 69, "Input"],
Cell[41250, 1404, 351, 11, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41638, 1420, 324, 9, 69, "Input"],
Cell[41965, 1431, 705, 24, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42707, 1460, 257, 7, 69, "Input"],
Cell[42967, 1469, 340, 10, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43344, 1484, 190, 5, 69, "Input"],
Cell[43537, 1491, 545, 19, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44119, 1515, 252, 6, 69, "Input"],
Cell[44374, 1523, 822, 23, 189, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45233, 1551, 254, 6, 69, "Input"],
Cell[45490, 1559, 853, 24, 184, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46380, 1588, 156, 2, 100, "Subsection"],
Cell[46539, 1592, 251, 7, 69, "Input"],
Cell[CellGroupData[{
Cell[46815, 1603, 95, 1, 69, "Input"],
Cell[46913, 1606, 412, 12, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47362, 1623, 622, 15, 69, "Input"],
Cell[47987, 1640, 892, 25, 163, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48916, 1670, 591, 14, 69, "Input"],
Cell[49510, 1686, 665, 18, 163, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50212, 1709, 279, 8, 69, "Input"],
Cell[50494, 1719, 691, 20, 163, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51222, 1744, 391, 12, 69, "Input"],
Cell[51616, 1758, 21848, 372, 511, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73501, 2135, 389, 12, 69, "Input"],
Cell[73893, 2149, 27201, 460, 511, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101131, 2614, 296, 8, 69, "Input"],
Cell[101430, 2624, 456, 17, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101923, 2646, 444, 14, 69, "Input"],
Cell[102370, 2662, 257, 8, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102664, 2675, 614, 19, 118, "Input"],
Cell[103281, 2696, 175, 5, 115, "Output"]
}, Open  ]],
Cell[103471, 2704, 952, 30, 118, "Input"],
Cell[CellGroupData[{
Cell[104448, 2738, 148, 3, 69, "Input"],
Cell[104599, 2743, 25136, 426, 511, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129796, 3176, 149, 2, 73, "Section"],
Cell[129948, 3180, 139, 2, 78, "Input"],
Cell[CellGroupData[{
Cell[130112, 3186, 418, 12, 129, "Input"],
Cell[130533, 3200, 385, 11, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130955, 3216, 594, 19, 129, "Input"],
Cell[131552, 3237, 422, 11, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132011, 3253, 144, 3, 69, "Input"],
Cell[132158, 3258, 93, 2, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132288, 3265, 382, 9, 115, "Input"],
Cell[132673, 3276, 795, 20, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133505, 3301, 144, 3, 69, "Input"],
Cell[133652, 3306, 160, 4, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133849, 3315, 146, 3, 69, "Input"],
Cell[133998, 3320, 178, 5, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134213, 3330, 466, 14, 115, "Input"],
Cell[134682, 3346, 960, 27, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135679, 3378, 257, 6, 115, "Input"],
Cell[135939, 3386, 1058, 31, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137034, 3422, 253, 7, 69, "Input"],
Cell[137290, 3431, 488, 13, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137815, 3449, 456, 13, 115, "Input"],
Cell[138274, 3464, 1024, 30, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139335, 3499, 276, 8, 69, "Input"],
Cell[139614, 3509, 345, 8, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139996, 3522, 290, 7, 115, "Input"],
Cell[140289, 3531, 1158, 35, 159, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141484, 3571, 507, 13, 69, "Input"],
Cell[141994, 3586, 470, 13, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142501, 3604, 253, 6, 69, "Input"],
Cell[142757, 3612, 335, 10, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143129, 3627, 398, 10, 69, "Input"],
Cell[143530, 3639, 729, 24, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144296, 3668, 304, 7, 69, "Input"],
Cell[144603, 3677, 402, 11, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145042, 3693, 265, 6, 69, "Input"],
Cell[145310, 3701, 539, 19, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145886, 3725, 125, 2, 69, "Input"],
Cell[146014, 3729, 235, 7, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146286, 3741, 333, 8, 115, "Input"],
Cell[146622, 3751, 850, 22, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147509, 3778, 333, 8, 115, "Input"],
Cell[147845, 3788, 774, 21, 141, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[148668, 3815, 200, 3, 73, "Section"],
Cell[148871, 3820, 139, 2, 78, "Input"],
Cell[CellGroupData[{
Cell[149035, 3826, 706, 19, 129, "Input"],
Cell[149744, 3847, 593, 13, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150374, 3865, 540, 13, 129, "Input"],
Cell[150917, 3880, 529, 12, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151483, 3897, 392, 10, 69, "Input"],
Cell[151878, 3909, 314, 7, 117, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152229, 3921, 426, 12, 138, "Input"],
Cell[152658, 3935, 392, 11, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[153087, 3951, 144, 3, 69, "Input"],
Cell[153234, 3956, 216, 5, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[153487, 3966, 150, 3, 69, "Input"],
Cell[153640, 3971, 239, 6, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[153916, 3982, 564, 15, 139, "Input"],
Cell[154483, 3999, 1070, 27, 150, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155590, 4031, 139, 3, 69, "Input"],
Cell[155732, 4036, 143, 3, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155912, 4044, 150, 3, 69, "Input"],
Cell[156065, 4049, 166, 3, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156268, 4057, 504, 13, 115, "Input"],
Cell[156775, 4072, 941, 23, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157753, 4100, 257, 6, 115, "Input"],
Cell[158013, 4108, 1240, 32, 150, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159290, 4145, 417, 11, 129, "Input"],
Cell[159710, 4158, 345, 8, 102, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160092, 4171, 383, 9, 115, "Input"],
Cell[160478, 4182, 1274, 34, 165, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161789, 4221, 345, 9, 69, "Input"],
Cell[162137, 4232, 969, 27, 123, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163143, 4264, 456, 13, 115, "Input"],
Cell[163602, 4279, 1169, 31, 132, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164808, 4315, 276, 8, 69, "Input"],
Cell[165087, 4325, 438, 9, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165562, 4339, 290, 7, 115, "Input"],
Cell[165855, 4348, 1303, 36, 183, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167195, 4389, 819, 18, 69, "Input"],
Cell[168017, 4409, 1544, 45, 186, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169598, 4459, 253, 6, 69, "Input"],
Cell[169854, 4467, 1162, 39, 186, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[171053, 4511, 549, 14, 69, "Input"],
Cell[171605, 4527, 1450, 48, 199, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173092, 4580, 322, 7, 69, "Input"],
Cell[173417, 4589, 1372, 46, 199, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174826, 4640, 265, 6, 69, "Input"],
Cell[175094, 4648, 2335, 81, 199, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177466, 4734, 234, 4, 46, "Input"],
Cell[177703, 4740, 3575, 117, 323, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181315, 4862, 388, 9, 77, "Input"],
Cell[181706, 4873, 2623, 82, 170, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184366, 4960, 420, 10, 77, "Input"],
Cell[184789, 4972, 1684, 47, 152, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186510, 5024, 426, 10, 77, "Input"],
Cell[186939, 5036, 1652, 49, 158, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

