(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     32506,        968]
NotebookOptionsPosition[     28991,        860]
NotebookOutlinePosition[     29330,        875]
CellTagsIndexPosition[     29287,        872]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", "\"\<DeleteGeneratedCells\>\"", "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7444108607805567`*^9, 3.744410862784237*^9}}],

Cell[CellGroupData[{

Cell["Problem 1", "Section",
 CellChangeTimes->{{3.743524828302706*^9, 3.7435248311365547`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], " ", "//", 
  "TableForm"}]}], "Input",
 CellChangeTimes->{{3.743524573074439*^9, 3.743524609098403*^9}}],

Cell[BoxData[
 RowBox[{"?", "Dot"}]], "Input",
 CellChangeTimes->{{3.743525023028933*^9, 3.743525023522091*^9}}],

Cell[BoxData[
 RowBox[{"tmp1", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"dot", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7435246271317987`*^9, 3.743524637178048*^9}, {
  3.743524684489552*^9, 3.74352476259962*^9}, {3.7435248166308517`*^9, 
  3.743524816790339*^9}, {3.743524851366439*^9, 3.743524851654277*^9}}],

Cell[BoxData[
 RowBox[{"tmp2", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"Dot", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7435246271317987`*^9, 3.743524637178048*^9}, {
  3.743524684489552*^9, 3.7435246845849648`*^9}, {3.74352476456773*^9, 
  3.743524765175271*^9}, {3.7435248108229113`*^9, 3.743524814102273*^9}, {
  3.743524854053722*^9, 3.743524854565579*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmp1", ",", "tmp2"}], "}"}], "  ", "//", "Transpose"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.743524767244731*^9, 3.743524786984582*^9}}],

Cell[BoxData[
 RowBox[{"?", "Cross"}]], "Input",
 CellChangeTimes->{{3.7435250269529133`*^9, 3.743525027923071*^9}}],

Cell[BoxData[
 RowBox[{"tmp3", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"cross", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7435246271317987`*^9, 3.743524637178048*^9}, {
  3.743524684489552*^9, 3.74352476259962*^9}, {3.7435248166308517`*^9, 
  3.743524816790339*^9}, {3.743524866358294*^9, 3.743524866533841*^9}}],

Cell[BoxData[
 RowBox[{"tmp4", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"Cross", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7435246271317987`*^9, 3.743524637178048*^9}, {
  3.743524684489552*^9, 3.7435246845849648`*^9}, {3.74352476456773*^9, 
  3.743524765175271*^9}, {3.7435248108229113`*^9, 3.743524814102273*^9}, {
  3.7435248686616173`*^9, 3.7435248688377857`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmp3", ",", "tmp4"}], "}"}], "  ", "//", "Transpose"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.743524767244731*^9, 3.743524786984582*^9}, {
  3.743524870807333*^9, 3.743524872869295*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 2", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "y"}], ",", "x", ",", "0"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.743524903153865*^9, 3.743524919732875*^9}, {
  3.7435249809474173`*^9, 3.743524981091926*^9}}],

Cell[BoxData[
 RowBox[{"?", "Div"}]], "Input",
 CellChangeTimes->{{3.743525014353569*^9, 3.743525015379134*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.743525008050847*^9}}],

Cell[BoxData[
 RowBox[{"?", "Curl"}]], "Input",
 CellChangeTimes->{{3.743525017778831*^9, 3.74352501837118*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249328072767`*^9, 3.7435249416363173`*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249328072767`*^9, 3.7435249416363173`*^9}, {
  3.743524973507574*^9, 3.743524973619519*^9}}],

Cell[BoxData[
 RowBox[{"?", "VectorPlot"}]], "Input",
 CellChangeTimes->{{3.7435250529219017`*^9, 3.743525067074059*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{
   RowBox[{"f1", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435250755074043`*^9, 3.743525123104972*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot3D", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435250755074043`*^9, 3.7435251512661552`*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{
   RowBox[{"f2", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435250755074043`*^9, 3.7435251333768377`*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot3D", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7435250755074043`*^9, 3.743525165727652*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}, 
   3.7435250407380857`*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"r", "^", "2"}]}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.743524903153865*^9, 3.743524919732875*^9}, {
  3.7435249809474173`*^9, 3.743524981091926*^9}, {3.743525240494622*^9, 
  3.743525251214514*^9}, {3.743525543641317*^9, 3.743525568457163*^9}, {
  3.743530214175744*^9, 3.743530248095152*^9}, {3.743530296830316*^9, 
  3.743530297037874*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}], ",", 
   "\"\<Cylindrical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}, {3.744410471889131*^9, 
  3.744410478544982*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}], ",", 
   "\"\<Cylindrical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
  3.7435253340454397`*^9}, {3.743530202544264*^9, 3.743530209711529*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
  3.7435253340454397`*^9}, {3.743530202544264*^9, 3.743530209711529*^9}, {
  3.744410500951784*^9, 3.744410512158002*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Cylindrical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
  3.743525417595477*^9}, {3.7444105291069183`*^9, 3.7444105301151037`*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
  3.743525417595477*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Cylindrical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
   3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
   3.743525344956583*^9}, {3.7435254198352337`*^9, 3.743525420763837*^9}, 
   3.743525515546752*^9, {3.743530193792617*^9, 3.7435302122239428`*^9}, {
   3.744410539376836*^9, 3.7444105400797977`*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
   3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
   3.743525344956583*^9}, {3.7435254198352337`*^9, 3.743525420763837*^9}, 
   3.743525515546752*^9, {3.743530193792617*^9, 3.7435302122239428`*^9}}],

Cell[BoxData[
 RowBox[{"tx1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Rule]", " ", 
    RowBox[{"CoordinateTransform", "[", " ", 
     RowBox[{
      RowBox[{"\"\<Spherical\>\"", " ", "\[Rule]", " ", "\"\<Cartesian\>\""}],
       ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]}], "]"}]}], " ", "//",
    "Thread"}]}]], "Input",
 CellChangeTimes->{{3.7435256913183403`*^9, 3.743525711559025*^9}, {
  3.743525754533245*^9, 3.743525806772255*^9}},
 CellID->564889597],

Cell[BoxData[
 RowBox[{"tx2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], "\[Rule]", " ", 
    RowBox[{"CoordinateTransform", "[", 
     RowBox[{
      RowBox[{
      "\"\<Cartesian\>\"", " ", "\[Rule]", "  ", "\"\<Spherical\>\""}], " ", 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "//", 
   "Thread"}]}]], "Input",
 CellChangeTimes->{{3.7435256913183403`*^9, 3.7435257593807898`*^9}, {
  3.743525803513132*^9, 3.743525830852125*^9}},
 CellID->1370814107],

Cell[BoxData[
 RowBox[{"f1", " ", "/.", "tx2"}]], "Input",
 CellChangeTimes->{{3.743525971860446*^9, 3.743525977296639*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot3D", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], " ", "/.", "tx1"}], "  ", "/.",
     "tx2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743526232801693*^9, 3.743526303963011*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], " ", "/.", "tx1"}], 
       "  ", "/.", "tx2"}], ")"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "2"}], "]"}], "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"z", "\[Rule]", "0"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743526232801693*^9, 3.743526356105742*^9}, {
   3.7435263889862013`*^9, 3.743526433784524*^9}, {3.74352650412358*^9, 
   3.743526560198243*^9}, 3.7435265973980494`*^9}],

Cell[BoxData[
 RowBox[{"VectorPlot3D", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"r", "^", "2"}]}], " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], " ", "/.", "tx1"}], "  ", "/.",
     "tx2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743526232801693*^9, 3.743526303963011*^9}, {
  3.7435264435758657`*^9, 3.743526466106325*^9}, {3.743526542614937*^9, 
  3.7435265428525333`*^9}}],

Cell[BoxData[
 RowBox[{"VectorPlot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], " ", "/.", "tx1"}], 
       "  ", "/.", "tx2"}], ")"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "2"}], "]"}], "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"z", "\[Rule]", "0"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743526232801693*^9, 3.743526356105742*^9}, {
  3.7435263889862013`*^9, 3.743526433784524*^9}, {3.74352650412358*^9, 
  3.7435265368396463`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 4", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}, 
   3.7435250407380857`*^9, 3.7435266356995583`*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "r", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], " ", "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.743524903153865*^9, 3.743524919732875*^9}, {
  3.7435249809474173`*^9, 3.743524981091926*^9}, {3.743525240494622*^9, 
  3.743525251214514*^9}, {3.743525543641317*^9, 3.743525568457163*^9}, {
  3.743526644372327*^9, 3.743526658998126*^9}, {3.743526795011517*^9, 
  3.743526819057769*^9}}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}], ",", 
   "\"\<Cylindrical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
  3.743525264718607*^9, 3.743525288120139*^9}}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f1", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Cylindrical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
   3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
   3.743525417595477*^9}, 3.743526834625671*^9}],

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
   3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
   3.7435253340454397`*^9}, 3.743526831249323*^9}],

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"f2", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7435249975846786`*^9, 3.7435250021795187`*^9}, {
   3.743525264718607*^9, 3.743525288120139*^9}, {3.7435253339192038`*^9, 
   3.743525344956583*^9}, {3.7435254198352337`*^9, 3.743525420763837*^9}, 
   3.743525515546752*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}, 
   3.7435250407380857`*^9, 3.7435266356995583`*^9, {3.743527021324917*^9, 
   3.743527021612669*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}, {
  3.743528692012856*^9, 3.743528693228874*^9}}],

Cell[BoxData[
 RowBox[{"eqy", "=", " ", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"y0", " ", "+", " ", 
    RowBox[{"vy0", " ", "t"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"-", "g"}], " ", ")"}], " ", 
     RowBox[{"t", "^", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.743527038298541*^9, 3.743527089757884*^9}, {
  3.743527151900119*^9, 3.743527153610971*^9}, {3.7435272424103813`*^9, 
  3.743527242953286*^9}, {3.743528225414853*^9, 3.7435282269015703`*^9}, {
  3.743528288505281*^9, 3.743528294628393*^9}}],

Cell[BoxData[
 RowBox[{"eqx", "=", " ", 
  RowBox[{"x", "\[Equal]", " ", 
   RowBox[{"x0", " ", "+", " ", 
    RowBox[{"vx0", " ", "t", " "}]}]}]}]], "Input",
 CellChangeTimes->{{3.743527111883293*^9, 3.74352712108561*^9}, {
  3.743527156762684*^9, 3.7435271580289097`*^9}, {3.743528298997127*^9, 
  3.743528305160357*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x0", "\[Rule]", "0"}], ",", " ", 
     RowBox[{"y0", "\[Rule]", "h"}], ",", " ", 
     RowBox[{"vx0", "->", 
      RowBox[{"v0", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", " ", 
     RowBox[{"vy0", "->", 
      RowBox[{"v0", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], " ", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.743527228469318*^9, 3.743527299112165*^9}, {
   3.743527469589953*^9, 3.743527473396924*^9}, {3.743527642260502*^9, 
   3.74352764345724*^9}, 3.74352780836666*^9, {3.74352805717759*^9, 
   3.743528058473126*^9}, 3.743528230070098*^9, 3.743528323268972*^9}],

Cell[BoxData[
 RowBox[{"tRoot", "=", 
  RowBox[{"Roots", "[", 
   RowBox[{
    RowBox[{"eqy", " ", "/.", 
     RowBox[{"{", 
      RowBox[{"y", "\[Rule]", "0"}], "}"}]}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.743528635424539*^9, 3.743528638622052*^9}, {
  3.7435287145579147`*^9, 3.7435287628284807`*^9}, {3.744222913196961*^9, 
  3.7442229152550983`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "_IF", "_", " ", "it", "  ", "were", " ", "to", " ", "start", " ", "and", 
    " ", "end", " ", "at", " ", "same", " ", "height"}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"tRoot", " ", "/.", 
    RowBox[{"{", 
     RowBox[{"y0", "\[Rule]", "0"}], "}"}]}], " ", "//", 
   "PowerExpand"}]}]], "Input",
 CellChangeTimes->{{3.74352873836586*^9, 3.743528740268003*^9}, {
  3.743528805131398*^9, 3.743528823830126*^9}, {3.7442227199495792`*^9, 
  3.744222742422802*^9}, {3.74422291882034*^9, 3.744222919493482*^9}}],

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"tRoot", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "t"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Take", " ", "the", " ", "positive", " ", "root"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.743528833249235*^9, 3.7435288565221252`*^9}, {
  3.744222616259905*^9, 3.744222649968252*^9}, {3.744222681593637*^9, 
  3.744222713516358*^9}, {3.744222923516656*^9, 3.744222924242988*^9}}],

Cell[BoxData[
 RowBox[{"xSol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eqx", " ", "/.", "sol1"}], ",", "x"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.74352886604615*^9, 3.7435288946972303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xSol", " ", "/.", "values"}], " ", "//", "FullSimplify"}]], "Input",\

 CellChangeTimes->{{3.743528898125883*^9, 3.743528908770677*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"xSol", " ", "/.", "values"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"h", "\[Rule]", "0"}], "}"}]}], "//", "PowerExpand"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.743528898125883*^9, 3.7435289371812162`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"range_List", ",", "divs_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"#", " ", 
         RowBox[{"Pi", "/", "180"}]}], ",", 
        RowBox[{"#", " ", "Degree"}]}], "}"}], "&"}], "/@", 
     RowBox[{"FindDivisions", "[", 
      RowBox[{
       RowBox[{"range", " ", 
        RowBox[{"180", "/", "Pi"}]}], ",", "divs", ",", "10"}], "]"}]}]}], 
   ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.74352910474855*^9, 3.7435291047490253`*^9}}],

Cell[BoxData[
 RowBox[{"ticks", "=", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", "10"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.743529109261293*^9, 3.743529143252496*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"ticks", ",", " ", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.74352895124865*^9, 3.743529031676394*^9}, {
  3.743529148260758*^9, 3.743529160547987*^9}}],

Cell[BoxData[{
 RowBox[{"xSol0", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eqx", ",", "x"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ySol0", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eqy", ",", "y"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7442228459283257`*^9, 3.744222861576775*^9}, {
  3.7442230030823298`*^9, 3.744223035679612*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], " ", "/.", "xSol0"}], " ", "/.", 
   "ySol0"}], " ", "//.", "values", " "}]], "Input",
 CellChangeTimes->{{3.744222795036675*^9, 3.744222828653405*^9}, {
  3.744222893922064*^9, 3.744222897943293*^9}, {3.7442229519812183`*^9, 
  3.744222971056924*^9}, {3.744223051817466*^9, 3.744223094622656*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"t_", ",", "\[Theta]_"}], "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], " ", "/.", "xSol0"}], " ", "/.", 
     "ySol0"}], " ", "//.", "values"}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "\[Rule]", 
      RowBox[{"+", "10"}]}], ",", " ", 
     RowBox[{"h", "\[Rule]", "40"}], ",", " ", 
     RowBox[{"v0", "\[Rule]", "20"}]}], "}"}], " "}]}]], "Input",
 CellChangeTimes->{{3.744222795036675*^9, 3.744222828653405*^9}, {
  3.744222893922064*^9, 3.744222897943293*^9}, {3.7442229519812183`*^9, 
  3.744222971056924*^9}, {3.744223051817466*^9, 3.744223155844781*^9}, {
  3.744223191067296*^9, 3.744223191354879*^9}, {3.7442232488106403`*^9, 
  3.744223263187448*^9}}],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"ff", "[", 
    RowBox[{"t", ",", 
     RowBox[{"30", " ", "Degree"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.744223173688809*^9, 3.744223224908654*^9}, {
  3.744223272909677*^9, 3.744223287416173*^9}}],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ff", "[", 
      RowBox[{"t", ",", 
       RowBox[{"15", " ", "Degree"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ff", "[", 
      RowBox[{"t", ",", 
       RowBox[{"30", " ", "Degree"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ff", "[", 
      RowBox[{"t", ",", 
       RowBox[{"45", " ", "Degree"}]}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.744223173688809*^9, 3.744223224908654*^9}, {
  3.744223272909677*^9, 3.744223316288357*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 6", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}, 
   3.7435250407380857`*^9, 3.7435266356995583`*^9, {3.743527021324917*^9, 
   3.743527021612669*^9}, {3.744222500503978*^9, 3.744222500859995*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}, {
  3.743528692012856*^9, 3.743528693228874*^9}}],

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"m", " ", 
       RowBox[{
        RowBox[{"v", "^", "2"}], "/", "r"}]}], " ", "\[Equal]", " ", 
      RowBox[{"q", " ", "v", " ", "b"}]}], ",", "r"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.743529209050568*^9, 3.743529237330556*^9}}],

Cell[BoxData[
 RowBox[{"r0", "=", 
  RowBox[{
   RowBox[{"r", " ", "/.", "sol"}], " ", "/.", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"m", "\[Rule]", " ", 
      RowBox[{"Quantity", "[", "\"\<ProtonMass\>\"", "]"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"q", "\[Rule]", " ", 
      RowBox[{"Quantity", "[", "\"\<ElectronCharge\>\"", "]"}]}], ",", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"v", "\[Rule]", " ", 
      RowBox[{"Quantity", "[", "\"\<SpeedOfLight\>\"", "]"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"Quantity", "[", 
       RowBox[{"7.7", ",", "\"\<Teslas\>\""}], "]"}]}]}], " ", 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7435292446525507`*^9, 3.7435292460841837`*^9}, {
  3.743529283873742*^9, 3.7435292970737143`*^9}, {3.74352933446556*^9, 
  3.743529335009673*^9}, {3.743529557120139*^9, 3.74352961786689*^9}, {
  3.743529691212339*^9, 3.743529710857609*^9}, {3.74352976417073*^9, 
  3.743529768041604*^9}}],

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{"r0", ",", " ", "\"\<Meters\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.743529729543501*^9, 3.743529744856552*^9}}]
}, Closed]]
},
WindowSize->{820, 944},
WindowMargins->{{93, Automatic}, {26, Automatic}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 206, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[631, 21, 96, 1, 65, "Section"],
Cell[730, 24, 141, 2, 32, "Input"],
Cell[874, 28, 424, 13, 57, "Input"],
Cell[1301, 43, 112, 2, 32, "Input"],
Cell[1416, 47, 507, 11, 34, "Input"],
Cell[1926, 60, 516, 11, 34, "Input"],
Cell[2445, 73, 220, 6, 34, "Input"],
Cell[2668, 81, 116, 2, 32, "Input"],
Cell[2787, 85, 509, 11, 34, "Input"],
Cell[3299, 98, 522, 11, 34, "Input"],
Cell[3824, 111, 269, 7, 34, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[4130, 123, 96, 1, 51, "Section"],
Cell[4229, 126, 141, 2, 32, "Input"],
Cell[4373, 130, 398, 12, 57, "Input"],
Cell[4774, 144, 112, 2, 32, "Input"],
Cell[4889, 148, 209, 5, 34, "Input"],
Cell[5101, 155, 207, 5, 34, "Input"],
Cell[5311, 162, 112, 2, 32, "Input"],
Cell[5426, 166, 210, 5, 34, "Input"],
Cell[5639, 173, 259, 6, 34, "Input"],
Cell[5901, 181, 121, 2, 32, "Input"],
Cell[6025, 185, 406, 12, 34, "Input"],
Cell[6434, 199, 419, 12, 34, "Input"],
Cell[6856, 213, 408, 12, 34, "Input"],
Cell[7267, 227, 417, 12, 34, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[7721, 244, 124, 2, 51, "Section"],
Cell[7848, 248, 141, 2, 32, "Input"],
Cell[7992, 252, 626, 17, 57, "Input"],
Cell[8621, 271, 297, 7, 34, "Input"],
Cell[8921, 280, 349, 8, 34, "Input"],
Cell[9273, 290, 396, 8, 34, "Input"],
Cell[9672, 300, 443, 9, 34, "Input"],
Cell[10118, 311, 404, 8, 34, "Input"],
Cell[10525, 321, 352, 8, 34, "Input"],
Cell[10880, 331, 530, 10, 34, "Input"],
Cell[11413, 343, 476, 9, 34, "Input"],
Cell[11892, 354, 560, 15, 34, "Input",
 CellID->564889597],
Cell[12455, 371, 566, 16, 34, "Input",
 CellID->1370814107],
Cell[13024, 389, 124, 2, 32, "Input"],
Cell[13151, 393, 581, 18, 34, "Input"],
Cell[13735, 413, 787, 22, 57, "Input"],
Cell[14525, 437, 738, 22, 34, "Input"],
Cell[15266, 461, 824, 24, 57, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[16127, 490, 148, 2, 51, "Section"],
Cell[16278, 494, 141, 2, 32, "Input"],
Cell[16422, 498, 645, 17, 57, "Input"],
Cell[17070, 517, 297, 7, 34, "Input"],
Cell[17370, 526, 378, 8, 34, "Input"],
Cell[17751, 536, 372, 8, 34, "Input"],
Cell[18126, 546, 428, 9, 34, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[18591, 560, 198, 3, 51, "Section"],
Cell[18792, 565, 190, 3, 32, "Input"],
Cell[18985, 570, 598, 14, 32, "Input"],
Cell[19586, 586, 323, 7, 32, "Input"],
Cell[19912, 595, 707, 17, 34, "Input"],
Cell[20622, 614, 371, 9, 34, "Input"],
Cell[20996, 625, 594, 14, 56, "Input"],
Cell[21593, 641, 544, 13, 34, "Input"],
Cell[22140, 656, 266, 7, 34, "Input"],
Cell[22409, 665, 171, 4, 32, "Input"],
Cell[22583, 671, 292, 8, 32, "Input"],
Cell[22878, 681, 574, 18, 79, "Input"],
Cell[23455, 701, 254, 7, 34, "Input"],
Cell[23712, 710, 460, 12, 34, "Input"],
Cell[24175, 724, 452, 12, 57, "Input"],
Cell[24630, 738, 400, 9, 34, "Input"],
Cell[25033, 749, 816, 21, 34, "Input"],
Cell[25852, 772, 351, 9, 34, "Input"],
Cell[26206, 783, 698, 18, 125, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26941, 806, 244, 3, 51, "Section"],
Cell[27188, 811, 190, 3, 32, "Input"],
Cell[27381, 816, 391, 11, 34, "Input"],
Cell[27775, 829, 1025, 23, 125, "Input"],
Cell[28803, 854, 172, 3, 34, "Input"]
}, Closed]]
}
]
*)

