(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    154278,       3736]
NotebookOptionsPosition[    145667,       3433]
NotebookOutlinePosition[    146361,       3459]
CellTagsIndexPosition[    146226,       3453]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Problem 1", "Section",
 CellChangeTimes->{{3.743524828302706*^9, 3.7435248311365547`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell["Vertical falling:", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
  3.743445467741766*^9, 3.743445468765003*^9}, {3.744302857668048*^9, 
  3.744302860477252*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", " ", 
  RowBox[{
   RowBox[{"m", " ", 
    RowBox[{
     RowBox[{"v", "'"}], "[", "t", "]"}]}], " ", "\[Equal]", 
   RowBox[{
    RowBox[{"m", " ", "g"}], " ", "-", " ", 
    RowBox[{"b", " ", 
     RowBox[{"v", "[", "t", "]"}]}], " ", "-", " ", 
    RowBox[{"c", " ", 
     RowBox[{
      RowBox[{"v", "[", "t", "]"}], "^", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.743445129347848*^9, 3.743445129860055*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", 
   RowBox[{
    SuperscriptBox["v", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"g", " ", "m"}], "-", 
   RowBox[{"b", " ", 
    RowBox[{"v", "[", "t", "]"}]}], "-", 
   RowBox[{"c", " ", 
    SuperscriptBox[
     RowBox[{"v", "[", "t", "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{3.743443756038247*^9, 3.743443922408926*^9, 
  3.743444033273847*^9, 3.743445132761938*^9, 3.743445298018262*^9, 
  3.743445412235135*^9, 3.744302863128989*^9, 3.744989385132162*^9, 
  3.744989667655315*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{
   RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}]], "Output",
 CellChangeTimes->{3.7434437820102987`*^9, 3.743443924439932*^9, 
  3.7434440333485813`*^9, 3.743445133968092*^9, 3.743445298070675*^9, 
  3.743445412324048*^9, 3.7443028676297626`*^9, 3.74498938518323*^9, 
  3.74498966766317*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", " ", 
  RowBox[{"eq1", " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"v", "'"}], "[", "t", "]"}], "\[Rule]", "0"}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.744302910984724*^9, 3.744302926371394*^9}}],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"g", " ", "m"}], "-", 
   RowBox[{"b", " ", 
    RowBox[{"v", "[", "t", "]"}]}], "-", 
   RowBox[{"c", " ", 
    SuperscriptBox[
     RowBox[{"v", "[", "t", "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{{3.744302917070442*^9, 3.7443029268386297`*^9}, 
   3.744989385221558*^9, 3.744989667671619*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2b", "=", " ", 
  RowBox[{"eq2", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", "0"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.744302928122841*^9, 3.744302937255824*^9}}],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"g", " ", "m"}], "-", 
   RowBox[{"b", " ", 
    RowBox[{"v", "[", "t", "]"}]}]}]}]], "Output",
 CellChangeTimes->{3.744302937660639*^9, 3.744989385249114*^9, 
  3.744989667680595*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2c", "=", 
  RowBox[{"eq2", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", "0"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.744302942251946*^9, 3.744302947923997*^9}}],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"g", " ", "m"}], "-", 
   RowBox[{"c", " ", 
    SuperscriptBox[
     RowBox[{"v", "[", "t", "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{3.744302948182988*^9, 3.7449893852820263`*^9, 
  3.7449896676919327`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bSol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eq2b", ",", 
     RowBox[{"v", "[", "t", "]"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744302950406494*^9, 3.744302962100679*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"g", " ", "m"}], "b"]}], "}"}]], "Output",
 CellChangeTimes->{{3.744302957363902*^9, 3.744302976138973*^9}, 
   3.744989385316805*^9, 3.7449896677024384`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cSol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eq2c", ",", 
     RowBox[{"v", "[", "t", "]"}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744302967192762*^9, 3.7443029696579037`*^9}, {
  3.744303174720251*^9, 3.744303175239648*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{
     SqrtBox["g"], " ", 
     SqrtBox["m"]}], 
    SqrtBox["c"]]}], "}"}]], "Output",
 CellChangeTimes->{3.744302970181856*^9, 3.7443031755982533`*^9, 
  3.74498938534735*^9, 3.744989667712487*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", 
      RowBox[{"\[Beta]", " ", "D"}]}], ",", " ", 
     RowBox[{"c", " ", "\[Rule]", " ", 
      RowBox[{"\[Gamma]", " ", 
       SuperscriptBox["D", "2"]}]}], ",", 
     RowBox[{"\[Beta]", "\[Rule]", 
      RowBox[{"1.6", " ", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}]}], ",", 
     RowBox[{"\[Gamma]", "\[Rule]", "0.25"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.744302984612154*^9, 3.744303048668436*^9}, 
   3.7443031796962757`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vb", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"v", "[", "t", "]"}], " ", "/.", "bSol"}], " ", "//.", 
    "values"}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "\[Rule]", "10"}], ",", " ", 
     RowBox[{"m", "\[Rule]", "100"}], " ", ",", 
     RowBox[{"D", "\[Rule]", "1"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.744303058044351*^9, 3.744303102283923*^9}, {
  3.744303219755044*^9, 3.744303222194027*^9}}],

Cell[BoxData["6.249999999999999`*^6"], "Output",
 CellChangeTimes->{{3.7443030634666967`*^9, 3.744303103000423*^9}, 
   3.744303181188087*^9, 3.7443032225093307`*^9, 3.744989385380574*^9, 
   3.7449896677550707`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vc", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"v", "[", "t", "]"}], " ", "/.", "cSol"}], " ", "//.", 
    "values"}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "\[Rule]", "10"}], ",", " ", 
     RowBox[{"m", "\[Rule]", "100"}], " ", ",", 
     RowBox[{"D", "\[Rule]", "1"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.744303058044351*^9, 3.744303102283923*^9}, {
  3.744303149698534*^9, 3.744303149800003*^9}, {3.744303224220333*^9, 
  3.744303224926133*^9}}],

Cell[BoxData["63.24555320336759`"], "Output",
 CellChangeTimes->{{3.7443030634666967`*^9, 3.744303103000423*^9}, 
   3.744303150144864*^9, 3.744303182030208*^9, 3.744303225159309*^9, 
   3.74498938541068*^9, 3.7449896677645073`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Units`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.744303409945602*^9, 3.744303409947331*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convert", "[", 
  RowBox[{
   RowBox[{"vb", " ", 
    RowBox[{"Meter", "/", "Second"}]}], ",", 
   RowBox[{"Mile", "/", "Hour"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7443032277569733`*^9, 3.7443032485298843`*^9}, {
  3.7443033051421547`*^9, 3.744303339210677*^9}, {3.744303444367619*^9, 
  3.744303462823498*^9}, {3.744303565817371*^9, 3.7443035663051434`*^9}, {
  3.7449893875845127`*^9, 3.744989387680583*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1.3980851825340012`*^7", " ", "Mile"}], "Hour"]], "Output",
 CellChangeTimes->{{3.744989385585705*^9, 3.744989388105027*^9}, 
   3.7449896677777157`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convert", "[", 
  RowBox[{
   RowBox[{"vc", " ", 
    RowBox[{"Meter", "/", "Second"}]}], ",", 
   RowBox[{"Mile", "/", "Hour"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7443032277569733`*^9, 3.7443032485298843`*^9}, {
  3.7443033051421547`*^9, 3.744303339210677*^9}, {3.744303444367619*^9, 
  3.744303462823498*^9}, {3.744303565817371*^9, 3.7443035663051434`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"141.47627327167055`", " ", "Mile"}], "Hour"]], "Output",
 CellChangeTimes->{{3.744303439689909*^9, 3.744303463460299*^9}, 
   3.744303566846126*^9, 3.744989385618787*^9, 3.74498966778686*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Problem 2", "Section",
 CellChangeTimes->{{3.744461061695609*^9, 3.744461071225643*^9}, 
   3.7449897321413*^9}],

Cell[CellGroupData[{

Cell["Horizontal", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
  3.743445462029182*^9, 3.743445463517805*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "zero", " ", "gravity"}]}], "  ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"m", " ", 
      RowBox[{
       RowBox[{"v", "'"}], "[", "t", "]"}]}], " ", "\[Equal]", " ", 
     RowBox[{
      RowBox[{"m", " ", "g"}], " ", "-", " ", 
      RowBox[{"b", " ", 
       RowBox[{"v", "[", "t", "]"}]}], " ", "-", " ", 
      RowBox[{"c", " ", 
       RowBox[{
        RowBox[{"v", "[", "t", "]"}], "^", "2"}]}]}]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"g", "\[Rule]", "0"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", 
   RowBox[{
    SuperscriptBox["v", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "b"}], " ", 
    RowBox[{"v", "[", "t", "]"}]}], "-", 
   RowBox[{"c", " ", 
    SuperscriptBox[
     RowBox[{"v", "[", "t", "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, 
   3.7449900292630863`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{
   RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0", "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.744990029359359*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq1", ",", "bc"}], "}"}], " ", ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"b", " ", "v0"}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c"}], " ", "v0"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"b", " ", "t"}], "m"]], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "v0"}]}], ")"}]}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9, 
   3.74498974788309*^9, 3.744990029517055*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Look", " ", "at", " ", "ONLY", " ", "LINEAR", " ", "term"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"dsol2", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eq1", ",", "bc"}], "}"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{"c", "\[Rule]", "0"}], "}"}]}], ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443960636125*^9, 3.7434439618672132`*^9}, {3.744461156530561*^9, 
  3.7444611825616417`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", "t"}], "m"]}]], " ", "v0"}]}], "}"}]], "Output",
 CellChangeTimes->{3.743443785726227*^9, 3.743443849426681*^9, 
  3.743443964050158*^9, 3.743444033479967*^9, 3.7434453776918716`*^9, 
  3.744461138699439*^9, 3.7444613353591146`*^9, 3.744461758314089*^9, 
  3.744989747969326*^9, 3.744990029567032*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Look", " ", "at", " ", "ONLY", " ", "QUADRATIC", " ", "term"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"dsol3", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eq1", ",", "bc"}], "}"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{"b", "\[Rule]", "0"}], "}"}]}], ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443856444902*^9}, {
  3.7434439672291822`*^9, 3.743443968108109*^9}, {3.744461175074798*^9, 
  3.7444611802910852`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"m", " ", "v0"}], 
    RowBox[{"m", "+", 
     RowBox[{"c", " ", "t", " ", "v0"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.743443785726227*^9, {3.743443849426681*^9, 3.743443856736702*^9}, 
   3.743443968342766*^9, 3.743444033500185*^9, 3.743445377713902*^9, 
   3.7444612923500013`*^9, 3.7444613353849707`*^9, 3.7444617583370647`*^9, 
   3.7449897481131496`*^9, 3.744990029663701*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol1", " "}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", " ", "v0"}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], " ", "v0"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"b", " ", "t"}], "m"]], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "v0"}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{3.744461288768561*^9, 3.744461335403048*^9, 
  3.7444617583405247`*^9, 3.744989748169437*^9, 3.744990029763639*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol2"}]], "Input",
 CellChangeTimes->{{3.7444612791859627`*^9, 3.7444612852338142`*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"b", " ", "t"}], "m"]}]], " ", "v0"}]], "Output",
 CellChangeTimes->{3.7444612888354673`*^9, 3.744461335420974*^9, 
  3.744461758361499*^9, 3.7449897482849007`*^9, 3.744990029858717*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol3"}]], "Input",
 CellChangeTimes->{{3.7444612820001497`*^9, 3.7444612827362432`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"m", " ", "v0"}], 
  RowBox[{"m", "+", 
   RowBox[{"c", " ", "t", " ", "v0"}]}]]], "Output",
 CellChangeTimes->{{3.744461288864696*^9, 3.744461293972412*^9}, 
   3.744461335438136*^9, 3.7444617583834476`*^9, 3.744989748525633*^9, 
   3.74499002997421*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Pick", " ", "some", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"values", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"v0", "\[Rule]", "1"}], ",", " ", 
      RowBox[{"m", "\[Rule]", "1"}]}], "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.743443992092004*^9, 3.74344400357782*^9}, {
   3.743444046969207*^9, 3.743444048040835*^9}, {3.7444613059360723`*^9, 
   3.744461314319744*^9}, 3.7444613894863997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol1"}], " ", "/.", 
  "values"}]], "Input",
 CellChangeTimes->{{3.743443981138796*^9, 3.743444042168939*^9}}],

Cell[BoxData[
 FractionBox["b", 
  RowBox[{
   RowBox[{"-", "c"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"b", " ", "t"}]]}]}]]], "Output",
 CellChangeTimes->{{3.743443989606679*^9, 3.7434440502686853`*^9}, 
   3.7434453777402067`*^9, 3.744461335460238*^9, {3.744461375691464*^9, 
   3.744461392380224*^9}, 3.744461758411324*^9, 3.7449897487232723`*^9, 
   3.7449900301799517`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"dsol1", ",", "dsol2", ",", "dsol3"}], "}"}]}], " ", "/.", 
   "values"}]}]], "Input",
 CellChangeTimes->{{3.743443981138796*^9, 3.7434440721062517`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     RowBox[{"-", "c"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"b", " ", "t"}]]}]}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "b"}], " ", "t"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"c", " ", "t"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.743444064667819*^9, 3.743444072391*^9}, 
   3.743444466095496*^9, 3.743445377762745*^9, 3.74446133547845*^9, {
   3.744461377805498*^9, 3.744461394237639*^9}, 3.744461758433992*^9, 
   3.744989748835394*^9, 3.744990030385812*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"tmp1", " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"c", "\[Rule]", "1"}]}], "}"}]}], " ", "//", "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"LineLegend", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Gen\>\"", ",", "\"\<c=0\>\"", ",", "\"\<b=0\>\""}], 
       "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743444073139323*^9, 3.743444096392931*^9}, {
  3.743444290021035*^9, 3.743444349043425*^9}, {3.743444384899706*^9, 
  3.743444416065856*^9}, {3.743444512594083*^9, 3.743444514222501*^9}, {
  3.744461439008419*^9, 3.7444614548793907`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwVlGc4FQ4bxg8iex3Z+4hCpChK53mikllWSUbJiqhkU2TP0CIlK9mVjISs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          "]]}, Annotation[#, "Charting`Private`Tag$12365#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         LineBox[CompressedData["
1:eJwVlGc8FQ4bho0IkXPs7RzHyiojUup5shpEtiQro8iMECLKFkJmtmgIlRKy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          "]]}, Annotation[#, "Charting`Private`Tag$12365#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwVz3k41HkcwHFnWVckyj38XCHHlkrU51uKnI8z89BqjRwPG9FMiolSjg5M
at2SrI4noxR+7vtsGIyUzdS4hiiFacogtv3j/bz+fmuRItwDRYSEhIi/+l8e
x0G38ewUvNh+h6yWPAkfQ/RLPwhz4d2wZUK42ySEZlxqHKBNw+FbIuLm7RMQ
zt05WVE2C/x9Wbp5zeMw5vevREvPLLBnquScqsfBYyTFpG9qFhjRxCax5+Ow
nzFzkasyB+lmbVapheMgWl4ip5Q8B5o6m5MEceOQTdU6FH3qE9yg0G33wji0
KCjnWMrNg22SIGq1fQwkta7pc/YvgIWKhWViFwe6rW+bxh1bgCWnO5TtdRxI
It7bp+6+ACpVU0EvyzggQqu28w1bAIauhJVEJgdW1j8Hvy1YgNC16gidQA58
Yns97hdZhAm/38+ri3OgN1t/Z3PvIpyTyqR3O36ANDmGYdGfPHDsXabOLbKh
Zp96pUs4DyQq8C8N02yY8ouAtVgeDEQ3/MwZZYMVXcHTO4sHphmTjLAONny0
P3lJhsmDPVPDipQcNthcne+/aPUNEosHVhRt2LDM30JxV+LDd8Ghdtf8USCN
ejaJ9n6H/t3TT1in30FkxzVShP4KkFk1erjDCJSflfbYYf8TmO9X3Mrz30BR
bNicmbcQcmYd1Z2TGIaEwjW3b5+FUYyRSvyLpiEQGhpD9TGiaMJr1plVxAI9
ctAFT0NxlH/i71vKaYMwxc86IdWwCX2xbvmo8ngAHLihlzIiJdAHh5Ztq+n9
4DJFM9LQkETv06Wmk0WZMNdGutxNl0LDR6nz7i97wUT+jbrNKRn07Rzr5Jkg
BkgC35/Nk0UvlQKHWPavwG7e54e2lxyimw94h5j0wEjraWEfY3lU/tVg9ZxJ
N1SmtPsR+PLIv0J30NutC4LEKWNM5lZkGzpznhHVCQFRsZXSuQrIeOt+A2p5
B5gGGzGd/Lch1QwO0VyoA/q3GktRLBWRXmTfyAGndqgrS8gzFlVCPk/iZ4bK
2iBW2NC1970SsstSq34s2waS7Jjj4RXb0cYOoqZ4bCtwH2rdLaTuQJ2apkW6
gha4a6AsVuOljPL0vLu0yC1Ayw3q8ieoIHGZGzPV683gc/cPpvSMCrIk6dSc
v90My0dLBIWNqohk6ObJIzTDJPfIhdZkNdQdkaxMjmmCBwfNVfv81VFiPLl0
pLQR6IkU+eBdGuhqZBVd9XsDJHsFOIryNdDoWJT5JscGsGAXPUnu00QFbvfX
ODn1kL0zj97nSEBjP4ZK5lfrIL45NduxhoACDgxzjxPrwFnVq+SVjhYK6CJV
1zfWwuHwLl/561ropjVXmWxRC4VqJJ1evhbKTZEiP3tYAzptjzJdfLXRQJEM
sVOvBmi7Wg1Zjdqo8+v8FkJZNQTxxAZ7DDGU4FJvcNCsGkjlS4Tr6RgKoCtT
9zbh8FeCx5rDbQyVBuUa2TXgQPGoeCt9B0ObtRlGxDocUviUNFomhk4z59Vj
cRzKLAWrWQUYqnsu39X+DAdBy8abh08xlKdRpRp8HwcaSzq1vQtDceqDtjNX
cMgtPhOS1IMhW27+tPBlHIrJTJvjDAxl7il7rRaHQ5USbYXBxFBSrVeeRwwO
bB+FkKFhDLXOPxpoj8JBf1LZZmISQ0Td2VeVATiYVcRo/MPFkGyYle2wPw4H
EkcFgTMYirV8JMs/hYOTfsHz2TkMLR25kmRxEoeoMILG4iKGFhQt5Wo9caBa
XxG84GHINdFtadQdh0SZiddkPobO1n8lrLvikP2s+ObyMobuyZMDbJxxeHBZ
LLh2BUPmSRbRQY44PHULPEJdw1BqxO631+1xqNDuVD+0/usn2fcq3Q6HRp6e
YGMDQ7+l5cUOHsPhP5/kq6A=
          "]]}, 
        Annotation[#, "Charting`Private`Tag$12365#3"]& ]}}, {}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
       AbsolutePointSize[6], "ScalingFunctions" -> None, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 10}, {0., 0.6102430607650062}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"Gen\"", "\"c=0\"", "\"b=0\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7434444166126966`*^9, 3.7434444679341097`*^9, 3.7434445154295397`*^9, 
   3.743445378015785*^9, 3.744461335730179*^9, 3.744461381740147*^9, {
   3.7444614461806707`*^9, 3.744461455341147*^9}, 3.744461758515377*^9, 
   3.744989749023527*^9, 3.744990030557268*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fun", "[", 
   RowBox[{"b_", ",", "c_"}], "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"dsol1", ",", "dsol2", ",", "dsol3"}], "}"}]}], " ", "/.", 
   "values", " "}]}]], "Input",
 CellChangeTimes->{{3.744461561100506*^9, 3.744461565412485*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     RowBox[{"-", "c"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"b", " ", "t"}]]}]}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "b"}], " ", "t"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"c", " ", "t"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7444615568535633`*^9, 3.7444615660440083`*^9}, 
   3.744461758547441*^9, 3.744989749137992*^9, 3.744990030687365*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Manipulate"}]], "Input",
 CellChangeTimes->{{3.7444615917868423`*^9, 3.744461593643036*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}]}], \\\"]\\\"}]\) generates \
a version of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) with controls added \
to allow interactive manipulation of the value of \!\(\*StyleBox[\\\"u\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"du\\\", \
\\\"TI\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) allows the value of \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to vary between \
\!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]]\) and \!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]\) in steps \!\(\*StyleBox[\\\"du\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \
\\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"init\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) takes the initial value of \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to be \
\!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"init\\\", \\\
\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \
\\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"init\\\", \\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\
\", \\\"TI\\\"], StyleBox[\\\"lbl\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \
\\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \
\\\"]\\\"}]\) labels the controls for \!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) \
with \!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"lbl\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\
\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\
\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]}], \\\"]\\\"}]\) allows \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to take on discrete values \
\!\(\*RowBox[{SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", RowBox[{\
\\\"{\\\", RowBox[{StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) provides controls to manipulate \
each of the \!\(\*RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"c\\\", \\\"TI\\\"], StyleBox[\\\"u\\\", \
\\\"TI\\\"]], \\\"\[Rule]\\\", RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \
\\\"}\\\"}]}], \\\",\\\", RowBox[{SubscriptBox[StyleBox[\\\"c\\\", \
\\\"TI\\\"], StyleBox[\\\"v\\\", \\\"TI\\\"]], \\\"\[Rule]\\\", RowBox[{\\\"{\
\\\", RowBox[{StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) links the controls to the \
specified controllers on an external device.\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.744990030870638*^9},
 CellTags->"Info993744972030-7316328"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"fun", "[", 
       RowBox[{"b", ",", "c"}], "]"}], " ", "//", "Evaluate"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.015", "]"}], ",", "Red"}], "}"}], ",", 
        "Green", ",", "Blue"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<b=\>\"", ",", "b", ",", " ", "\"\<   c= \>\"", ",", "c"}],
        "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Both\>\"", ",", "\"\<Linear\>\"", ",", "\"\<Quadratic\>\""}], 
         "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "1", ",", "\"\<Linear\>\""}], "}"}], ",", "0.1", ",", 
     "2", ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "1", ",", "\"\<Quadratic\>\""}], "}"}], ",", "0.1", 
     ",", "2", ",", "0.1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7434441581026773`*^9, 3.743444270021695*^9}, {
  3.743444527631879*^9, 3.74344454291429*^9}, {3.7434445762267227`*^9, 
  3.743444590079043*^9}, {3.7434446339510593`*^9, 3.743444916188471*^9}, {
  3.743444948648057*^9, 3.743445018087319*^9}, {3.743445381332775*^9, 
  3.7434453948792543`*^9}, {3.744461478238141*^9, 3.744461539324254*^9}, {
  3.744461570732073*^9, 3.744461722408909*^9}, {3.7444617972563763`*^9, 
  3.744461834822801*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`b$$ = 1., $CellContext`c$$ = 1.1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`b$$], 1, "Linear"}, 0.1, 2, 0.1}, {{
       Hold[$CellContext`c$$], 1, "Quadratic"}, 0.1, 2, 0.1}}, 
    Typeset`size$$ = {470., {122., 128.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`b$12749$$ = 0, $CellContext`c$12750$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`b$$ = 1, $CellContext`c$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`b$$, $CellContext`b$12749$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$12750$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[
         $CellContext`fun[$CellContext`b$$, $CellContext`c$$]], \
{$CellContext`t, 0, 10}, PlotStyle -> {{
           Thickness[0.015], Red}, Green, Blue}, 
        PlotLabel -> {"b=", $CellContext`b$$, "   c= ", $CellContext`c$$}, 
        PlotLegends -> 
        LineLegend[{Red, Green, Blue}, {"Both", "Linear", "Quadratic"}], 
        PlotRange -> {Automatic, {0, 1}}], 
      "Specifications" :> {{{$CellContext`b$$, 1, "Linear"}, 0.1, 2, 
         0.1}, {{$CellContext`c$$, 1, "Quadratic"}, 0.1, 2, 0.1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{517., {178., 185.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.7434441582253428`*^9, {3.743444203398334*^9, 3.743444271557992*^9}, {
   3.743444534744412*^9, 3.743444543687131*^9}, {3.7434445773280478`*^9, 
   3.743444590259008*^9}, {3.743444640555604*^9, 3.74344469691673*^9}, {
   3.743444729785904*^9, 3.743444916519302*^9}, {3.743444958418499*^9, 
   3.74344501852176*^9}, {3.743445378052331*^9, 3.7434453953170156`*^9}, 
   3.744461335761627*^9, 3.744461483284277*^9, {3.744461523739381*^9, 
   3.744461539945999*^9}, {3.74446157727584*^9, 3.744461722883951*^9}, 
   3.7444617586316*^9, {3.744461805855917*^9, 3.744461835167122*^9}, 
   3.744989749694467*^9, 3.744990030988472*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Vertical
Now add gravity\
\>", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
  3.743445467741766*^9, 3.743445468765003*^9}, {3.7444617400075703`*^9, 
  3.744461743240264*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "zero", " ", "gravity"}]}], "  ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{"m", " ", 
     RowBox[{
      RowBox[{"v", "'"}], "[", "t", "]"}]}], " ", "\[Equal]", " ", 
    RowBox[{
     RowBox[{"m", " ", "g"}], " ", "-", " ", 
     RowBox[{"b", " ", 
      RowBox[{"v", "[", "t", "]"}]}], " ", "-", " ", 
     RowBox[{"c", " ", 
      RowBox[{
       RowBox[{"v", "[", "t", "]"}], "^", "2"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}, 3.7449897760893383`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", 
   RowBox[{
    SuperscriptBox["v", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"g", " ", "m"}], "-", 
   RowBox[{"b", " ", 
    RowBox[{"v", "[", "t", "]"}]}], "-", 
   RowBox[{"c", " ", 
    SuperscriptBox[
     RowBox[{"v", "[", "t", "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, 
   3.744989778511488*^9, 3.744989886070256*^9, 3.7449899589936657`*^9, 
   3.744990057207994*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{
   RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0", "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.744989778545479*^9, 3.744989886101218*^9, 3.744989959022461*^9, 
   3.744990057278658*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq1", ",", "bc"}], "}"}], " ", ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", "c", " ", "g", " ", "m"}]}]], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox[
          RowBox[{
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"4", " ", "c", " ", "g", " ", "m"}]}]], " ", "t"}], 
          RowBox[{"2", " ", "m"}]], "-", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           RowBox[{"b", "+", 
            RowBox[{"2", " ", "c", " ", "v0"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"4", " ", "c", " ", "g", " ", "m"}]}]]], "]"}]}], 
        "]"}]}]}], 
     RowBox[{"2", " ", "c"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9, 
   3.74498974788309*^9, 3.744989780356832*^9, 3.744989887836574*^9, 
   3.744989960702622*^9, 3.7449900588048267`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Look", " ", "at", " ", "ONLY", " ", "LINEAR", " ", "term"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"dsol2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"DSolve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq1", ",", "bc"}], "}"}], " ", "/.", 
        RowBox[{"{", 
         RowBox[{"c", "\[Rule]", "0"}], "}"}]}], ",", 
       RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]}]], "Input",\

 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
   3.743443960636125*^9, 3.7434439618672132`*^9}, {3.744461156530561*^9, 
   3.7444611825616417`*^9}, 3.744989806277172*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{"g", " ", "m"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"b", " ", "t"}], "m"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "g"}], " ", "m"}], "+", 
        RowBox[{"b", " ", "v0"}]}], ")"}]}]}], "b"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.743443785726227*^9, 3.743443849426681*^9, 3.743443964050158*^9, 
   3.743444033479967*^9, 3.7434453776918716`*^9, 3.744461138699439*^9, 
   3.7444613353591146`*^9, 3.744461758314089*^9, 3.744989747969326*^9, {
   3.744989780442357*^9, 3.7449898071864967`*^9}, 3.7449898880021687`*^9, 
   3.744989960860436*^9, 3.74499005905548*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Look", " ", "at", " ", "ONLY", " ", "QUADRATIC", " ", "term"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"dsol3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"DSolve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq1", ",", "bc"}], "}"}], " ", "/.", 
        RowBox[{"{", 
         RowBox[{"b", "\[Rule]", "0"}], "}"}]}], ",", 
       RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443856444902*^9}, {
   3.7434439672291822`*^9, 3.743443968108109*^9}, {3.744461175074798*^9, 
   3.7444611802910852`*^9}, 3.7449898135773277`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{
     SqrtBox["g"], " ", 
     SqrtBox["m"], " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{
       FractionBox[
        RowBox[{
         SqrtBox["c"], " ", 
         SqrtBox["g"], " ", "t"}], 
        SqrtBox["m"]], "+", 
       RowBox[{"ArcTanh", "[", 
        FractionBox[
         RowBox[{
          SqrtBox["c"], " ", "v0"}], 
         RowBox[{
          SqrtBox["g"], " ", 
          SqrtBox["m"]}]], "]"}]}], "]"}]}], 
    SqrtBox["c"]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.743443785726227*^9, {3.743443849426681*^9, 3.743443856736702*^9}, 
   3.743443968342766*^9, 3.743444033500185*^9, 3.743445377713902*^9, 
   3.7444612923500013`*^9, 3.7444613353849707`*^9, 3.7444617583370647`*^9, 
   3.7449897481131496`*^9, 3.744989780637138*^9, 3.744989814744792*^9, 
   3.7449898883011017`*^9, 3.744989961150221*^9, 3.744990059398961*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol1", " "}]], "Input",
 CellChangeTimes->{{3.744989822736958*^9, 3.744989828508909*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"b", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"4", " ", "c", " ", "g", " ", "m"}]}]], " ", 
     RowBox[{"Tan", "[", 
      RowBox[{
       FractionBox[
        RowBox[{
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", "c", " ", "g", " ", "m"}]}]], " ", "t"}], 
        RowBox[{"2", " ", "m"}]], "-", 
       RowBox[{"ArcTan", "[", 
        FractionBox[
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "v0"}]}], 
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", "c", " ", "g", " ", "m"}]}]]], "]"}]}], 
      "]"}]}]}], 
   RowBox[{"2", " ", "c"}]]}]], "Output",
 CellChangeTimes->{
  3.744461288768561*^9, 3.744461335403048*^9, 3.7444617583405247`*^9, 
   3.744989748169437*^9, 3.744989780710525*^9, {3.7449898251881933`*^9, 
   3.744989828946813*^9}, 3.744989888335181*^9, 3.744989961185832*^9, 
   3.7449900594773693`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol2"}]], "Input",
 CellChangeTimes->{{3.7444612791859627`*^9, 3.7444612852338142`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"g", " ", "m"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", "t"}], "m"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "g"}], " ", "m"}], "+", 
      RowBox[{"b", " ", "v0"}]}], ")"}]}]}], "b"]], "Output",
 CellChangeTimes->{3.7444612888354673`*^9, 3.744461335420974*^9, 
  3.744461758361499*^9, 3.7449897482849007`*^9, 3.744989780740808*^9, 
  3.7449898322936573`*^9, 3.744989888367741*^9, 3.7449899612138557`*^9, 
  3.744990059562446*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol3"}]], "Input",
 CellChangeTimes->{{3.7444612820001497`*^9, 3.7444612827362432`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["g"], " ", 
   SqrtBox["m"], " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox["c"], " ", 
       SqrtBox["g"], " ", "t"}], 
      SqrtBox["m"]], "+", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["c"], " ", "v0"}], 
       RowBox[{
        SqrtBox["g"], " ", 
        SqrtBox["m"]}]], "]"}]}], "]"}]}], 
  SqrtBox["c"]]], "Output",
 CellChangeTimes->{{3.744461288864696*^9, 3.744461293972412*^9}, 
   3.744461335438136*^9, 3.7444617583834476`*^9, 3.744989748525633*^9, 
   3.744989780774322*^9, 3.744989838257135*^9, 3.7449898883998613`*^9, 
   3.7449899612399893`*^9, 3.744990059631606*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Pick", " ", "some", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"values", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"v0", "\[Rule]", "0"}], ",", " ", 
      RowBox[{"m", "\[Rule]", "1"}], ",", 
      RowBox[{"g", "\[Rule]", "1"}]}], "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.743443992092004*^9, 3.74344400357782*^9}, {
   3.743444046969207*^9, 3.743444048040835*^9}, {3.7444613059360723`*^9, 
   3.744461314319744*^9}, 3.7444613894863997`*^9, {3.744989846979177*^9, 
   3.744989847959943*^9}, 3.744989882116207*^9, 3.7449899231039124`*^9, {
   3.744989955228015*^9, 3.744989955433198*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol1"}], " ", "/.", 
  "values"}]], "Input",
 CellChangeTimes->{{3.743443981138796*^9, 3.743444042168939*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"b", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"4", " ", "c"}]}]], " ", 
     RowBox[{"Tan", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "-", 
          RowBox[{"4", " ", "c"}]}]], " ", "t"}], "-", 
       RowBox[{"ArcTan", "[", 
        FractionBox["b", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", "c"}]}]]], "]"}]}], "]"}]}]}], 
   RowBox[{"2", " ", "c"}]]}]], "Output",
 CellChangeTimes->{{3.743443989606679*^9, 3.7434440502686853`*^9}, 
   3.7434453777402067`*^9, 3.744461335460238*^9, {3.744461375691464*^9, 
   3.744461392380224*^9}, 3.744461758411324*^9, 3.7449897487232723`*^9, 
   3.744989780817802*^9, 3.744989849490769*^9, 3.7449898884399633`*^9, 
   3.744989927166403*^9, 3.744989961276031*^9, 3.744990059760489*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"dsol1", ",", "dsol2", ",", "dsol3"}], "}"}]}], " ", "/.", 
   "values"}]}]], "Input",
 CellChangeTimes->{{3.743443981138796*^9, 3.7434440721062517`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", "c"}]}]], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "-", 
            RowBox[{"4", " ", "c"}]}]], " ", "t"}], "-", 
         RowBox[{"ArcTan", "[", 
          FractionBox["b", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"4", " ", "c"}]}]]], "]"}]}], "]"}]}]}], 
     RowBox[{"2", " ", "c"}]]}], ",", 
   FractionBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "b"}], " ", "t"}]]}], "b"], ",", 
   FractionBox[
    RowBox[{"Tanh", "[", 
     RowBox[{
      SqrtBox["c"], " ", "t"}], "]"}], 
    SqrtBox["c"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.743444064667819*^9, 3.743444072391*^9}, 
   3.743444466095496*^9, 3.743445377762745*^9, 3.74446133547845*^9, {
   3.744461377805498*^9, 3.744461394237639*^9}, 3.744461758433992*^9, 
   3.744989748835394*^9, 3.744989780859788*^9, 3.744989850791362*^9, 
   3.744989888469326*^9, 3.7449899278927183`*^9, 3.7449899613039217`*^9, 
   3.744990059837784*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"tmp1", " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"c", "\[Rule]", "1"}]}], "}"}]}], " ", "//", "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"LineLegend", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Gen\>\"", ",", "\"\<c=0\>\"", ",", "\"\<b=0\>\""}], 
       "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743444073139323*^9, 3.743444096392931*^9}, {
  3.743444290021035*^9, 3.743444349043425*^9}, {3.743444384899706*^9, 
  3.743444416065856*^9}, {3.743444512594083*^9, 3.743444514222501*^9}, {
  3.744461439008419*^9, 3.7444614548793907`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwd1nk0VV0UAPDnmeeH5xlDEpI0kCR1NqKSJCGVJAkpQ4OiFKFIZAypTOlL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          "]]}, 
        Annotation[#, "Charting`Private`Tag$17429#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         LineBox[CompressedData["
1:eJwV1nc8l98XAHA7GfFBto/PELIrpTTOadCSSqTMiBRRCkUf5WtEomhRQoVS
0UQZlfwI2RlZDXt7kk3qd/11X+/Xvc+5z32ec++5TMcTZs48XFxcLtxcXPNt
/HlHgWVOlzdwcQV81SNtYS3DxJJxDLj4hSI40sfg36f3QQyGLwQIrw44KeIL
8fmRyvyMS4Csvj/ZU2FwfL23+6TybfjpZ2z5uiYWameP3vil/BgYyy2XpAen
woKWdrUh5WyotsC8Q8Nv4P7nRM8B5VKI/aP9iL/6E4zFZmr8iCiFt/95WR9d
WgzGLmUdX6ZL4dCdWPkLgcUwyDtpkVP7GQRvnMotXVECq9ebGl4KLQfzO1sv
NV8rhernf3jUqCpIpZe+Ym4uhwuftXYss6+F1XzNKrNZ1fDs+aWW4zrNEDWx
nruUUw/9Ev0ROxyaIXjjQduQhHpQ89mxQf1GMyheWjymml8P99YJ3++YbgYp
ppWqPG8DXCuNOGJV1AIm9UWDBaEN4NNxdWSrzTdQj2GgXsRXSBQuC6IZ/YTY
148TBQObwAVqbg+e6gAnV4knI0u+AdeDiZyWyx1gXFItKbbxG8TyKbZ+Tu4A
G7acswyJU1J6hP64oQM4x9r+9UaTuOZ/HjgbdoLiuZzv0X++Qe9RtbTv3F3w
ngq0Fqz8Dq7X/N9XR3XDd76CnbN6P8Gja2lHxrM+ePLjQ0x0ahv8tGsS/Fja
B+bCV148zWiDfY1hOhWdfdD1Svx6bn4brC7r8e2S7wcT2+SveY1twPsyRVw6
tB9e3QgxNRZsh1gOc8MZ+wHI+fvEkuPcDh8l5W6vER+CtLlT4c9kO0CIGaz2
Y/UveGJb09V+uBNK1kXrnjf6BVdUlIsWuHfCxQMJBkpmvyBwOvvkEp9O4Il6
u9Xa7RcoVwdu3hnWCTN/B12+xv+CFV8VvDemdcJAq0VqFc8IePcU97T+7oTy
WLWl+eUj0JiQz5rw64Ir4mUa9w+NQsSdc9z1Z7oh20Ap09RjFPZ7+UdMXuiG
TrsT8OfcKKx7pKEqGdYNa9MlzS1jRuHtiZXxK2O7oXe7jb9o5Si8epm1Qf1t
N2wOGqryXTsGhgE2TqUT3TA1LuZtJj0O/XFH2lgnesCxxfwDb/kEKJmP+R7a
1QtCcW3unk0T8LaY+bR2Xy+8svJQ/NE9AcdpRV4brXqBtznUN4d7ElinL3aI
uPRCcmPOCk+DSTiUXZN2OKAXuusZqd8fTIJ8i1aN1KtecK0ejMr2nQKht/6Z
SbQ+8CwKdjyhNgMqVvXc1gV9QO80FphYMQMGrx80ri3ugzKehU84OAMPTPCH
bHkfLMHIkUsHZ2CbRkNocX0fNOXcDEi+PAO8bbtvT/b2wcYXDxOaqBnoC1m4
K2VRP9DiSpo3v50FAcHQuR2W/fDypMg+2e1zID2wPOrA934ovyPpm75/DlZU
8HW9bO+H7kL5xE1Oc8DcuC18QU8/yMstHTh+YQ7SehK/PKL6IfijUdDHzDlo
T3N8mcc1APslLrx2Zf2FqgF1C0PWAMy8HpF8N/sXRtP5lO84DsD9c279epZc
aHY4fjK8aQD08hdOhdpy4d1z9k9rWwcgny+V/8dhLqzZ0l0k93MAfkZ2MiJP
cmF3ra9BQvcA0O/ZWvZd4kIV7y6jsNEBuFO4u/B+Hhf+t2K4tl1kEK6J6idI
sLgxPFsw6MP6QQhM/LN3bJAbvSROpgTEDsIevbeemqPcmCGGr1XiBoH+8XS0
4zQ3DmgmZnyKH4Sc9v7qan4e9GhwiuVLGoTfS5p2p9N58FoGiB9NHwTHtMxd
R/bwoN3S/9GrPg7CxmyP7Y2veTBo1ycn9b5B4Kr9iXl+vDhYAusOLh+C4L73
9/3+48VZ7TK9TP0hWMgVz7MmjBfDuWlLxQyGQEL7YGHmTV40veSr+W7tECwJ
rdn6/AUv/nyl85DbaAh2rC0wfdDNi22azHZtyyG4npRkE2bGh2lcEcl0vyFQ
9Tpy1lyDHz9bul3JyhkCbcMf+xL1+HHokgTtQt4Q6HMd0O1fxY+lmiu1jd8P
waaI7d0XNvPjIN1sVfXHIbBL1jJ/asOP1ZoBT2pLhuBW3W9dnqv8KNpxWeR2
wxDwr7zQ83yUH8eE3OWXjAxB53jMfuF3AvjNdarajzUMDzauOP3tfwJYFUMz
oqkMg31k5dXnnwXwvLa+/cMlw9Cswl+6r1EAjS7ohJerD0PNvlNr744KYOtl
qllQdxjevzRhaGsswGfZq5w2rR2GGHfuftOYBZjqXF6SbzYMO7pc/a95CuL4
sYVnlpwfBmN/dtqWs4JYWDHV5XJhGDYtbm2eOC+IA3vObn0cMAyGRrtWW0cI
ouKNp13qQcOgkaI7yn4kiNsYFo8UwoZB2HnsaGarINZQHVzV0cNQ3ulv3rh1
IVKLmCO+ycNg2hmlSacLYYLmoSf/PpF+zc46GxUhvLyPK3G0eBh2njY4H6ch
hM0nOPXdJcOwjed7tayBEHK3HhAq+0zeh6HpI7lHCK88y00KrxyGlTZF+YKB
Qjh2nCPVUz8MinXTFqNdQjj4X1SNbOcw9P/PMaAkXRjtii56+/8dBuXoRtcr
GcIo9rhHyfLfMJjbmVqY5wpj66ndi/S4KHg/tUbjZ4kwlqy6X/qDm4Jr2rS6
yQ5hrNuum7uKn4K1MR/U1ORFsP6mldj/hCmIcFWsCrkogi0fF0YelKVAh9ag
tNleFE0mwhvu6lLQHdkdeNNZFNNdNDdt1KMgXmiyp8dNFHfPiWt1EYvwyb6K
OCuKNa+3cDSXU9A/cdC4IVoU/S4el3ulT0FK6zePY4WieJN6nPBoDQWKqV0f
ri5dhCdLlgev2kyBEIw7tI4uwlO5dJgyp+DsRnXBrJlFuI3jcDrcgsy/2frZ
VW4xVBpO1VDcT0HBto8zm8TE0L7rF3uDJQV+ZpHXH2uIId/6vyacgxQMOC8p
8nEQw1edz+vabCkoj7BQp1WJ4e11jiHmRyjYOmQ1ybIQx6DuqvQhbwoSpIJq
LxwQR+vTS6IcfCgYW/v0eau1OAr1GtDqie+Fz7rcchRHpfKmXzlnKJhRu9u4
8KQ4GjoP6wT6UpDm+C37V7g4tpo6Df7lUCDeaM95ny+Oh7gNr74OoqCxwInb
SouGc19vZstFUfBrY7O8vy4Nme+rD3oSL/i4W//echoixz2zhHjVB0OX7tU0
pLYkJfpEU3AjV7zilBENow0bjKquUbA7Iy/2sh0NuecCF3jdpOBTipTeuyga
qsp2l0TcoSAzrNCOMU7DW6yzQgLJFKTuKJMNnaLh44o6ujnxHZEvX4Zmacir
2/frPnFA1A/jXB4J/DYhV7UuhQKT2Bmd/eISeNjhje+JhxS0P9L7d1lTApM3
LXlbkkrBouK7iZMOElhx9LSZSToFR/i9f1ZWSuDJxHS9pEwK5JVLv87WSGBo
2RfWd+LK1UpV6vUSSDfe0C2bRdZ3vOhdYIsEvtXjtEUSC9QujlvVK4HsnNvp
3m9IvtzLskjglsTDfpp567Ip6Fw79dldXxIHZvY9fZxHweFT5zJF7kiiz2Jc
L/A/Em/598yl8ZJ4KsDg3kpiod+YZXxPEj19rL87Eb/wFHgT8FASF7nEDRYQ
/zkZ/XbslSRyG8qY+xdScOvEo9zWMkmkX7/pMlBEQenx2o9pc5K4X2T6UHoJ
BboumpUmDlIY6RRvXVlBwfdjyifSnaRQY3Pw0yniiOOS4ouOSqEfM/8rq5KC
Ps/ZvVUeUhgn+LzIhziJU1a/lyOFCzTSZxSrKJC55vZtf4wUhv0Zb3espuBf
3tPBQxVSyCu6yKf+CwVVElrC3msW40BGeZL1Vwo2uLv3xa1bjLd7HOPPET8r
flZcAIvRjVHjH0d8hbMsWNx4MR77EDzaTGzSvWruqdlinF14IuNAIwWfszdS
7W6LUUVhT/zuJgqKDlnW7klYjLYvdKI0WyjIfRYYp8UrjSKLRX4nfif/w8RC
PkZAGh/O/nckj3hvn9ptbiFp/GKWWdBI3MOuuNUgLo1L5h4up/2gQPK2zLUA
ujSepo3/DiB2C0oLq1sjjUaPpgVsflKgcKDBm3NSGmtSaQu42yk4x62xp/yb
NDoxMESoi+zvLcKNqm3SqLBDRJpJvCds0P6/Tmk0XzR+3YBYRez5iVUD0vjy
lrWlE3G5ov7Ve1PSuEZG/28eMX31hkovSRmsC0pqcu0m54OHmYnSdhkMbHZY
lt1D8qHVb5tHhgymMQwvs/tJvpx5LHr1jQy+vDp3V5/YQaLxy/McGbQUdr9v
RPx220rbkXwZzMn3DXQhPpJJeXpVyGBCqNvDJ8QfrzjF+XXL4Mm998/rDMyf
V6bDF2VlMa5nQ5bWIAVdD5k3Ejmy2Cn75AD/MAWDwW3TvAGyGCbkEy1F/Nvx
vv3RIFksL7N7xybmUmZqLguXxZ8HXg1vJJaPYRQUxMjikZaot/7Ee0KVf3W9
kkXfK6G/fxPnuSiZaPXJ4jdvl211FDkf1OX4si3kUG3TslSvEQps7FQfdRyQ
wyWx2moBxCo3VuxYZEOcLxl/mTjj366ow45yKLU2x/0BcV1DoOKiE3JIv2aQ
VEUsGTKofzhMDk1FlZ3Vf5P60fbBWTRXDrGp2auWOOrOkWIHhjxmq3vr08Yo
OOMTeJrDlsfVvmGn5YntzBKUY1Tl0TvO8ymbWEuo4Uy5ljy2hbTwryIu9TVS
N1gjj/aWqc5WxDwHVS6JmMljE3ug/j6xt0z7jjdB8nh9vVOC5jgFVjdsK0V6
5NGn1H1Qc4LUj9dCCm798rgmIlNXn/hHzRuX0iF5bJ4ROr6O2ElMgvvimDzy
rpioMiH2CP+04h+3Ao7ZnzRyJw4M0L09oqiA1XsmBtKIHx/ndmowU8Ds606m
apMUTG1JmU58r4Cjo1nXFk5RwMlNDCr8qID7+qprxIi5lt8R7StUwO6jfCLS
xAuUrzKXlymgkFOxJ4tYevrs9sKvCsjRVeddS7wi3eR27y8F1A94gG7EHovH
Vi9jK2JK/U4sIe7o2nS2IFQRz3QXynhPU7ApsfKBxmVFDHEZf+RHfO+AVcW1
K4qo0Ou6IoDYrsyTdfimIh6c1V93mbj5xb1y3iRFTFiRufg+8ZdzfxlG7xVR
WLVpoIy4gJZTWjymiBUecUCfoeDB+mUKFQ5KGKXKZ5ZFXGAqFDTrpIQpV0aD
c4jb7Tv6lx5VQr5DkRnvidmBN3MueihhVe3nhcXEyZ+mD+I5JbyQkBXxlThl
d0Hs6xtKqNUbMzFJnOqwT/pOsRK+e7z1+KpZCtJDvGku2nS8WsdweUI8uM42
MESPjszGv5/SibXGtowmraDj1l3rVF4SP3GUqv+5ho5q2d8a3hCnwutYK2M6
Hjg7qlhEnDz9S9nUno4FXlo6P4jvuB/XWRlNx/Uu107R/lAQanF4J+84HY36
1w96ED/Y3WrjPEVHO//VlCdx3nYLj+JZOjbSUikv4t/rt0Zf5lHGltrhXj9i
G1XNr5Liymh3bP+7i8TLJ387qmgq44ojzlQ88ffYQD8jB2WMF+64+Jl4Zev9
x6EVymig0PJLcY7Uf52jU8+rlXFtl6WBMvHgBZ2tjbXKuOn2Qg6TOJmd26ne
rIxhzjQuVWIptzrlz93KqN7a9FuHeIbDu1OAi4FHxUKCkbhJeNXHbXIMZFsW
ODgSxy6NS6/YycAGHTuT+8Rjo8YpQbsYuH2zn1kS8e73v++u2c1ATkfL/hRi
gX07IlLMGLgp3dvqMbE3Z9rV/yAD61y1dr0kNquyVNd2YaB8Qn9bPrGIt1RS
RCAZ7xf+5TvxhfzI2J3ZDNReGqog/Zfc777l35jOIeMbjLJkiPfPjkY9ymNg
IiNttxyx1iqrS7z5DPxP3Ou8InHjU1W/3E8MFM8UL2cRL4/5YK1Zx8DwCi91
XeJu9xG6MMXA9QyfIWPiXQoWKZ9VmKj3r7/tFHFsp06+tSoTTy2JkPUi7kwX
bBlUY6L7XkNTb2IO5omLaTJR/1V+1hniNGc2Z98yJhquC+dwiIVejJi1rmci
f87rlhDi4i1XuIb3M9FNwnYohnijR7E17RIT/T+rBWcTzzT2GReGMzFDeMHt
HOKMzSLLz0QwcVfAbFousarcXsFvV5l4VlntyztikcLmjNRbTIyvTaAVzK9X
blgUk5ko+TPH+TPxySKpfI8PTHx4rtmlmThR0VGlfJyJ1+xtZyeJDVdo6jhO
MtFR3a18irhu+5jB1BQTR47W3p0mFjxzcafKHyZq2WaunZ2PV/PkFIeHhXdN
Kzz/EuPF0XwtMRYe63v3ge8f2b9UsG2kOgv9eCS6xYlV/vfolqk1C7VOlvio
EVdqTSW32rBwXckPujrx2VvbXrvasXB5steneZcd66u66MDCVxxZKQ3iU+Ka
Cz+4sPDri32PtYg/2D47p+vFwj/aVO4yYqupjEPikSyMVTocvJY4SrtA48t7
FtqKXM/aRZy62nphYD4Lx3izTEznn9881rOsgIW6kVbt8x4+qJoSXcRC2b9L
RfYQ77wYrry3nIWNvUMHzYgFfphJVTexsG618/f9xOeiOuYqxljIymiOtCc+
MspXU6rBxh2JMndPENs92VJpo8XGxZVRoieJ9zsEl1HabHxT9eL8vI2reD8t
XsbGu4e77T2JVZ/y5DoYsPG5qy79NHGXI1fK9GY2Vi71Dvchdvoye3apLRvT
5B6y/YkdX/5mXLrKRrUHT45cIj4euO/PjmjSr/eyct7e+zK+ilxn42yAzapw
4rBx7ytRt9hY8fAB32XiZ2umZ2Pi2diXNX43gnj647+Gh0/ZqBM0m3d1/vt9
EYksLGZj4tu7eTeJ7yS5H71YysbyQzVyt4iTvCo3bytjo8m2DJ95Z0lHzZRV
srFxNEQ3hrjVSvJobT0b/UMOxccSq3XIbW7vYKOvkJ5rHLFehh89uYuN1/KO
FczbMKRl2rmHjdtE9svfJTZRi3/R18/G2utbS+d9yo1BHxkh892/yU4g5qz7
b/rVKBu/J7r5zjtEtL3Oa5yNseYTlfOOfZ50eWqKje69Gr6JxA8C+FxyZtg4
tKO+Yt5P9zpv4vxh4yHXlax7xBmsT0ob/rKxN3Snz7zfj6pO//vHxpOdMp/n
/X8pABGr
          "]]}, Annotation[#, "Charting`Private`Tag$17429#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwt1XVUVc8TAHC6u/O9RwgIAgZfW3cMUBAVKVExAGklVAQUC4OWkhYQASXE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          "]]}, 
        Annotation[#, "Charting`Private`Tag$17429#3"]& ]}}, {}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
       AbsolutePointSize[6], "ScalingFunctions" -> None, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 10}, {0., 0.9999999958776911}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"Gen\"", "\"c=0\"", "\"b=0\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7434444166126966`*^9, 3.7434444679341097`*^9, 3.7434445154295397`*^9, 
   3.743445378015785*^9, 3.744461335730179*^9, 3.744461381740147*^9, {
   3.7444614461806707`*^9, 3.744461455341147*^9}, 3.744461758515377*^9, 
   3.744989749023527*^9, 3.744989780941785*^9, 3.7449898519461727`*^9, 
   3.744989888558489*^9, 3.7449899286371393`*^9, 3.7449899614078293`*^9, 
   3.744990060075667*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fun", "[", 
   RowBox[{"b_", ",", "c_"}], "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"dsol1", ",", "dsol2", ",", "dsol3"}], "}"}]}], " ", "/.", 
   "values", " "}]}]], "Input",
 CellChangeTimes->{{3.744461561100506*^9, 3.744461565412485*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", "c"}]}]], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "-", 
            RowBox[{"4", " ", "c"}]}]], " ", "t"}], "-", 
         RowBox[{"ArcTan", "[", 
          FractionBox["b", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"4", " ", "c"}]}]]], "]"}]}], "]"}]}]}], 
     RowBox[{"2", " ", "c"}]]}], ",", 
   FractionBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "b"}], " ", "t"}]]}], "b"], ",", 
   FractionBox[
    RowBox[{"Tanh", "[", 
     RowBox[{
      SqrtBox["c"], " ", "t"}], "]"}], 
    SqrtBox["c"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7444615568535633`*^9, 3.7444615660440083`*^9}, 
   3.744461758547441*^9, 3.744989749137992*^9, 3.744989780991227*^9, 
   3.7449898571772013`*^9, 3.744989888597937*^9, {3.744989931714056*^9, 
   3.744989961443406*^9}, 3.744990060156296*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Manipulate"}]], "Input",
 CellChangeTimes->{{3.7444615917868423`*^9, 3.744461593643036*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}]}], \\\"]\\\"}]\) generates \
a version of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) with controls added \
to allow interactive manipulation of the value of \!\(\*StyleBox[\\\"u\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"du\\\", \
\\\"TI\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) allows the value of \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to vary between \
\!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]]\) and \!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]\) in steps \!\(\*StyleBox[\\\"du\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \
\\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"init\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) takes the initial value of \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to be \
\!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"init\\\", \\\
\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \
\\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"init\\\", \\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\
\", \\\"TI\\\"], StyleBox[\\\"lbl\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \
\\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \
\\\"]\\\"}]\) labels the controls for \!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) \
with \!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"lbl\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\
\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\
\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]}], \\\"]\\\"}]\) allows \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to take on discrete values \
\!\(\*RowBox[{SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", RowBox[{\
\\\"{\\\", RowBox[{StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) provides controls to manipulate \
each of the \!\(\*RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"c\\\", \\\"TI\\\"], StyleBox[\\\"u\\\", \
\\\"TI\\\"]], \\\"\[Rule]\\\", RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \
\\\"}\\\"}]}], \\\",\\\", RowBox[{SubscriptBox[StyleBox[\\\"c\\\", \
\\\"TI\\\"], StyleBox[\\\"v\\\", \\\"TI\\\"]], \\\"\[Rule]\\\", RowBox[{\\\"{\
\\\", RowBox[{StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) links the controls to the \
specified controllers on an external device.\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.7449900603162613`*^9},
 CellTags->"Info1153744972060-7316328"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"fun", "[", 
       RowBox[{"b", ",", "c"}], "]"}], " ", "//", "Evaluate"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.015", "]"}], ",", "Red"}], "}"}], ",", 
        "Green", ",", "Blue"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<b=\>\"", ",", "b", ",", " ", "\"\<   c= \>\"", ",", "c"}],
        "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Both\>\"", ",", "\"\<Linear\>\"", ",", "\"\<Quadratic\>\""}], 
         "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "1", ",", "\"\<Linear\>\""}], "}"}], ",", "0.1", ",", 
     "2", ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "1", ",", "\"\<Quadratic\>\""}], "}"}], ",", "0.1", 
     ",", "2", ",", "0.1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7434441581026773`*^9, 3.743444270021695*^9}, {
  3.743444527631879*^9, 3.74344454291429*^9}, {3.7434445762267227`*^9, 
  3.743444590079043*^9}, {3.7434446339510593`*^9, 3.743444916188471*^9}, {
  3.743444948648057*^9, 3.743445018087319*^9}, {3.743445381332775*^9, 
  3.7434453948792543`*^9}, {3.744461478238141*^9, 3.744461539324254*^9}, {
  3.744461570732073*^9, 3.744461722408909*^9}, {3.7444617972563763`*^9, 
  3.744461834822801*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`b$$ = 1., $CellContext`c$$ = 
    0.30000000000000004`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`b$$], 1, "Linear"}, 0.1, 2, 0.1}, {{
       Hold[$CellContext`c$$], 1, "Quadratic"}, 0.1, 2, 0.1}}, 
    Typeset`size$$ = {470., {122., 128.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`b$17809$$ = 0, $CellContext`c$17810$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`b$$ = 1, $CellContext`c$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`b$$, $CellContext`b$17809$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$17810$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[
         $CellContext`fun[$CellContext`b$$, $CellContext`c$$]], \
{$CellContext`t, 0, 10}, PlotStyle -> {{
           Thickness[0.015], Red}, Green, Blue}, 
        PlotLabel -> {"b=", $CellContext`b$$, "   c= ", $CellContext`c$$}, 
        PlotLegends -> 
        LineLegend[{Red, Green, Blue}, {"Both", "Linear", "Quadratic"}], 
        PlotRange -> {Automatic, {0, 1}}], 
      "Specifications" :> {{{$CellContext`b$$, 1, "Linear"}, 0.1, 2, 
         0.1}, {{$CellContext`c$$, 1, "Quadratic"}, 0.1, 2, 0.1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{517., {178., 185.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.7434441582253428`*^9, {3.743444203398334*^9, 3.743444271557992*^9}, {
   3.743444534744412*^9, 3.743444543687131*^9}, {3.7434445773280478`*^9, 
   3.743444590259008*^9}, {3.743444640555604*^9, 3.74344469691673*^9}, {
   3.743444729785904*^9, 3.743444916519302*^9}, {3.743444958418499*^9, 
   3.74344501852176*^9}, {3.743445378052331*^9, 3.7434453953170156`*^9}, 
   3.744461335761627*^9, 3.744461483284277*^9, {3.744461523739381*^9, 
   3.744461539945999*^9}, {3.74446157727584*^9, 3.744461722883951*^9}, 
   3.7444617586316*^9, {3.744461805855917*^9, 3.744461835167122*^9}, 
   3.744989749694467*^9, 3.744989781101372*^9, {3.744989859535893*^9, 
   3.744989888698995*^9}, {3.7449899359871683`*^9, 3.744989961566033*^9}, 
   3.744990060501368*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 3", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}, {
  3.744303790375333*^9, 3.744303790548728*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell[CellGroupData[{

Cell["Part 1 :", "Subsubsection",
 CellChangeTimes->{{3.744304092425542*^9, 3.744304096995872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq1", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"m", "  ", "a"}], " ", "==", " ", 
      RowBox[{
       RowBox[{"m", " ", "g", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "   ", "-", " ", 
       RowBox[{"\[Mu]", " ", "normal"}]}]}], ",", " ", 
     RowBox[{"normal", " ", "\[Equal]", " ", 
      RowBox[{"m", " ", "g", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], " ", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.744303821726925*^9, 3.744303911133965*^9}}],

Cell[CellGroupData[{

Cell[BoxData["eq1"], "Input",
 CellChangeTimes->{{3.744303914224573*^9, 3.744303914620755*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "m"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "normal"}], " ", "\[Mu]"}], "+", 
     RowBox[{"g", " ", "m", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], ",", 
   RowBox[{"normal", "\[Equal]", 
    RowBox[{"g", " ", "m", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.744303915055698*^9, 3.744989671087755*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", " ", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eq1", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "normal"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744303919318647*^9, 3.744303926205443*^9}, {
  3.744303969972805*^9, 3.744303973234865*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "g"}], " ", "\[Mu]", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
     RowBox[{"g", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], ",", 
   RowBox[{"normal", "\[Rule]", 
    RowBox[{"g", " ", "m", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.744303926432023*^9, {3.744303970691885*^9, 3.744303973419878*^9}, 
   3.7449896710973577`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "  ", "/.", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7443039743933077`*^9, 3.744303978930938*^9}, {
  3.744304027782509*^9, 3.74430403432001*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "g"}], ",", 
   RowBox[{"normal", "\[Rule]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{3.744304034513742*^9, 3.744989671107156*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"work", " ", "=", " ", 
  RowBox[{
   RowBox[{"\[Mu]", " ", "normal", " ", "d"}], " ", "/.", "sol"}]}]], "Input",\

 CellChangeTimes->{{3.7443040541482973`*^9, 3.744304082234325*^9}}],

Cell[BoxData[
 RowBox[{"d", " ", "g", " ", "m", " ", "\[Mu]", " ", 
  RowBox[{"Cos", "[", "\[Theta]", "]"}]}]], "Output",
 CellChangeTimes->{{3.744304078096098*^9, 3.744304082623949*^9}, 
   3.7449896711164503`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vSol", "=", " ", 
  RowBox[{
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "a", " ", "d"}], " ", "\[Equal]", " ", 
      SuperscriptBox["v", "2"]}], ",", "v"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7443042252191343`*^9, 3.744304255424395*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", "\[Rule]", 
   RowBox[{
    SqrtBox["2"], " ", 
    SqrtBox["a"], " ", 
    SqrtBox["d"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.744304246487162*^9, 3.744304255662003*^9}, 
   3.744989671127393*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kinetic", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "m", " ", 
      SuperscriptBox["v", "2"]}], " ", "/.", "vSol"}], " ", "/.", "sol"}], 
   " ", "//", "Expand"}]}]], "Input",
 CellChangeTimes->{{3.74430420682414*^9, 3.744304216465613*^9}, {
  3.744304264122631*^9, 3.7443042905083647`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "d"}], " ", "g", " ", "m", " ", "\[Mu]", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
  RowBox[{"d", " ", "g", " ", "m", " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.744304220745895*^9, {3.744304268090743*^9, 3.744304290817645*^9}, 
   3.744989671132628*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 2 :", "Subsubsection",
 CellChangeTimes->{{3.744304092425542*^9, 3.744304103748662*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"energy", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", " ", "g", " ", "h"}], " ", "-", " ", 
     RowBox[{"\[Mu]", " ", "normal", " ", "d"}]}], "  ", "/.", 
    RowBox[{"{", 
     RowBox[{"h", " ", "\[Rule]", " ", 
      RowBox[{"d", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]}], " ", "/.", 
   "sol"}]}]], "Input",
 CellChangeTimes->{{3.7443041063720903`*^9, 3.744304182130471*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "d"}], " ", "g", " ", "m", " ", "\[Mu]", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
  RowBox[{"d", " ", "g", " ", "m", " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.744304152144948*^9, 3.7443041824075537`*^9}, 
   3.744989671142212*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 5", "Section",
 CellChangeTimes->{{3.7435248946684513`*^9, 3.743524898517214*^9}, {
  3.744303790375333*^9, 3.744303790548728*^9}, {3.7443043250997763`*^9, 
  3.7443043252372417`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.743524946620356*^9, 3.7435249543733664`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlanetData", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7443044553569393`*^9, 3.744304457345543*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"Mercury\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Mercury\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Mercury\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Venus\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Venus\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Venus\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Earth\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Earth\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Earth\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Mars\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Mars\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Mars\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Jupiter\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Jupiter\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Jupiter\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Saturn\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Saturn\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Saturn\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Uranus\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Uranus\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Uranus\\\"]\"","\"planet\""},
    "Entity"], ",", 
   TemplateBox[{"\"Neptune\"",RowBox[{"Entity", "[", 
       RowBox[{"\"Planet\"", ",", "\"Neptune\""}], "]"}],
     "\"Entity[\\\"Planet\\\", \\\"Neptune\\\"]\"","\"planet\""},
    "Entity"]}], "}"}]], "Output",
 CellChangeTimes->{3.744304458620175*^9, 3.7449896751322117`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mass", "=", 
  RowBox[{"PlanetData", "[", 
   RowBox[{"\"\<Earth\>\"", ",", "\"\<Mass\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744304355491012*^9, 3.744304363236562*^9}, {
  3.74430443436504*^9, 3.744304435912822*^9}, {3.744304479831683*^9, 
  3.744304484593072*^9}}],

Cell[BoxData[
 TemplateBox[{"5.9721986`8.*^24","\"kg\"","kilograms","\"Kilograms\""},
  "Quantity"]], "Output",
 CellChangeTimes->{
  3.7443044029922657`*^9, 3.7443044373129168`*^9, {3.744304481002948*^9, 
   3.7443044849200783`*^9}, 3.744304572903987*^9, 3.74498967536637*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rTmp", "=", 
  RowBox[{"PlanetData", "[", 
   RowBox[{"\"\<Earth\>\"", ",", "\"\<Radius\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744304355491012*^9, 3.744304363236562*^9}, {
  3.74430443436504*^9, 3.744304435912822*^9}, {3.744304479831683*^9, 
  3.744304536334227*^9}}],

Cell[BoxData[
 TemplateBox[{"3958.7608367135926191044`7.","\"mi\"","miles","\"Miles\""},
  "Quantity"]], "Output",
 CellChangeTimes->{
  3.7443044029922657`*^9, 3.7443044373129168`*^9, {3.744304481002948*^9, 
   3.744304493529688*^9}, 3.7443045367249937`*^9, 3.744989675402297*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"radius", "=", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{"rTmp", ",", "\"\<SI\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744304512519322*^9, 3.744304539261929*^9}},
 NumberMarks->False],

Cell[BoxData[
 TemplateBox[{
  "6371.0079999999999999999`7.","\"km\"","kilometers","\"Kilometers\""},
  "Quantity"]], "Output",
 CellChangeTimes->{{3.744304506556941*^9, 3.744304539757221*^9}, 
   3.744304574844583*^9, 3.744305051870668*^9, 3.744989675448329*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"radius", "=", 
  RowBox[{"UnitConvert", "[", 
   RowBox[{"radius", ",", "\"\<Meter\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.744305063158556*^9, 3.7443050644834347`*^9}},
 NumberMarks->False],

Cell[BoxData[
 TemplateBox[{
  "6.3710079999999999999999497`7.*^6","\"m\"","meters","\"Meters\""},
  "Quantity"]], "Output",
 CellChangeTimes->{{3.744305058443645*^9, 3.744305064735898*^9}, 
   3.744989675492466*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"momInertia", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "/", "5"}], ")"}], " ", "mass", " ", 
   SuperscriptBox["radius", "2"]}]}]], "Input",
 CellChangeTimes->{{3.744304550904791*^9, 3.744304565707409*^9}}],

Cell[BoxData[
 TemplateBox[{
  "9.696400237484852413`6.6777807052660805*^37",
   RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"]}],"kilogram meters squared",
   RowBox[{"\"Kilograms\"", " ", 
     SuperscriptBox["\"Meters\"", "2"]}]},
  "Quantity"]], "Output",
 CellChangeTimes->{{3.7443045661626177`*^9, 3.744304577021162*^9}, 
   3.744305067618518*^9, 3.744989675558634*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"day", "=", 
  RowBox[{
   RowBox[{"UnitConvert", "[", 
    RowBox[{
     RowBox[{"Quantity", "[", 
      RowBox[{"1", ",", "\"\<Days\>\""}], "]"}], ",", "\"\<Seconds\>\""}], 
    "]"}], " ", "//", "N"}]}]], "Input",
 CellChangeTimes->{{3.7443049615557737`*^9, 3.744304965199273*^9}}],

Cell[BoxData[
 TemplateBox[{"86400.`","\"s\"","seconds","\"Seconds\""},
  "Quantity"]], "Output",
 CellChangeTimes->{3.74430496599517*^9, 3.744305069848495*^9, 
  3.7449896756991787`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"omega", "=", 
  RowBox[{"2", " ", 
   RowBox[{"\[Pi]", " ", "/", "day"}]}]}]], "Input",
 CellChangeTimes->{{3.7443047208670053`*^9, 3.744304775874157*^9}, {
  3.7443048189792337`*^9, 3.744304832931121*^9}, {3.7443049682888603`*^9, 
  3.7443049685892363`*^9}}],

Cell[BoxData[
 TemplateBox[{
  "0.0000727220521664304`",
   RowBox[{"\"per \"", "\[InvisibleSpace]", "\"second\""}],
   "reciprocal seconds",FractionBox["1", "\"Seconds\""]},
  "Quantity"]], "Output",
 CellChangeTimes->{{3.744304744737348*^9, 3.744304776203189*^9}, {
   3.744304820247223*^9, 3.744304833107337*^9}, 3.744304968993787*^9, 
   3.744305071232728*^9, 3.744989675754118*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"angMom", "=", " ", 
  RowBox[{"momInertia", " ", "omega"}]}]], "Input",
 CellChangeTimes->{{3.744304856498229*^9, 3.744304869229274*^9}}],

Cell[BoxData[
 TemplateBox[{"7.051421238969616`*^33",RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", "\"s\""}],"kilogram meters squared per second",
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], "\"Seconds\""]},
  "Quantity"]], "Output",
 CellChangeTimes->{3.744304869765316*^9, 3.744305075037896*^9, 
  3.744989675812698*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"angAcc", "=", " ", 
  RowBox[{"omega", "/", " ", "day"}]}]], "Input",
 CellChangeTimes->{{3.7443049071115417`*^9, 3.744304909992352*^9}, {
  3.744304955473507*^9, 3.74430497143967*^9}}],

Cell[BoxData[
 TemplateBox[{
  "8.416904185929443`*^-10",RowBox[{"\"per \"", "\[InvisibleSpace]", 
     SuperscriptBox["\"second\"", "2"]}],"per seconds squared",FractionBox[
   "1", 
    SuperscriptBox["\"Seconds\"", "2"]]},
  "Quantity"]], "Output",
 CellChangeTimes->{3.7443049716965322`*^9, 3.7443050787384787`*^9, 
  3.744989675856525*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"torque", "=", " ", 
  RowBox[{"momInertia", " ", "angAcc"}]}]], "Input",
 CellChangeTimes->{{3.7443049919898043`*^9, 3.744304998521078*^9}}],

Cell[BoxData[
 TemplateBox[{"8.161367174733351`*^28",RowBox[{"\"kg\"", "\[ThinSpace]", 
     SuperscriptBox["\"m\"", "2"], "\[NegativeMediumSpace]", "\"/\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"]}],
   "kilogram meters squared per second squared",FractionBox[
    RowBox[{"\"Kilograms\"", " ", 
      SuperscriptBox["\"Meters\"", "2"]}], 
    SuperscriptBox["\"Seconds\"", "2"]]},
  "Quantity"]], "Output",
 CellChangeTimes->{3.744304999453842*^9, 3.7443050824883013`*^9, 
  3.7449896759426947`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"force", " ", "=", " ", 
  RowBox[{"torque", "/", "radius"}]}]], "Input",
 CellChangeTimes->{{3.7443050186405897`*^9, 3.744305024265229*^9}}],

Cell[BoxData[
 TemplateBox[{
  "1.2810166263695402`*^22",
   RowBox[{"\"kg\"", "\[ThinSpace]", "\"m\"", "\[InvisibleSpace]", "\"/\"", 
     "\[InvisibleSpace]", 
     SuperscriptBox["\"s\"", "2"]}],"kilogram meters per second squared",
   FractionBox[
    RowBox[{"\"Kilograms\"", " ", "\"Meters\""}], 
    SuperscriptBox["\"Seconds\"", "2"]]},
  "Quantity"]], "Output",
 CellChangeTimes->{3.7443050246431026`*^9, 3.744305084939125*^9, 
  3.7449896761087723`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{"force", ",", "\"\<Newton\>\""}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 TemplateBox[{"1.2810166263695402`*^22","\"N\"","newtons","\"Newtons\""},
  "Quantity"]], "Output",
 CellChangeTimes->{3.744305093967331*^9, 3.744989676162863*^9}]
}, Open  ]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1193, 963},
WindowMargins->{{163, Automatic}, {5, Automatic}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info993744972030-7316328"->{
  Cell[52411, 1276, 5266, 79, 164, "Print",
   CellTags->"Info993744972030-7316328"]},
 "Info1153744972060-7316328"->{
  Cell[119898, 2749, 5269, 79, 164, "Print",
   CellTags->"Info1153744972060-7316328"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info993744972030-7316328", 145995, 3444},
 {"Info1153744972060-7316328", 146114, 3447}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 96, 1, 65, "Section"],
Cell[521, 18, 141, 2, 32, "Input"],
Cell[665, 22, 203, 3, 45, "Subsection"],
Cell[CellGroupData[{
Cell[893, 29, 524, 14, 26, "Input"],
Cell[1420, 45, 591, 16, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2048, 66, 176, 4, 32, "Input"],
Cell[2227, 72, 317, 6, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2581, 83, 266, 8, 32, "Input"],
Cell[2850, 93, 365, 10, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3252, 108, 209, 5, 32, "Input"],
Cell[3464, 115, 247, 7, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3748, 127, 204, 5, 32, "Input"],
Cell[3955, 134, 278, 8, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4270, 147, 262, 7, 34, "Input"],
Cell[4535, 156, 271, 7, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4843, 168, 313, 8, 34, "Input"],
Cell[5159, 178, 311, 10, 70, "Output"]
}, Open  ]],
Cell[5485, 191, 573, 16, 41, "Input"],
Cell[CellGroupData[{
Cell[6083, 211, 468, 13, 34, "Input"],
Cell[6554, 226, 216, 3, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6807, 234, 522, 14, 34, "Input"],
Cell[7332, 250, 232, 3, 70, "Output"]
}, Open  ]],
Cell[7579, 256, 137, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[7741, 262, 441, 9, 34, "Input"],
Cell[8185, 273, 192, 4, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8414, 282, 390, 8, 34, "Input"],
Cell[8807, 292, 230, 4, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9086, 302, 119, 2, 51, "Section"],
Cell[CellGroupData[{
Cell[9230, 308, 147, 2, 44, "Subsection"],
Cell[9380, 312, 143, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[9548, 318, 899, 25, 56, "Input"],
Cell[10450, 345, 611, 17, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11098, 367, 312, 7, 32, "Input"],
Cell[11413, 376, 347, 7, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11797, 388, 480, 12, 34, "Input"],
Cell[12280, 402, 773, 20, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13090, 427, 690, 18, 56, "Input"],
Cell[13783, 447, 500, 12, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14320, 464, 688, 18, 56, "Input"],
Cell[15011, 484, 505, 12, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15553, 501, 92, 2, 32, "Input"],
Cell[15648, 505, 469, 14, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16154, 524, 157, 3, 32, "Input"],
Cell[16314, 529, 294, 7, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16645, 541, 157, 3, 32, "Input"],
Cell[16805, 546, 293, 7, 49, "Output"]
}, Open  ]],
Cell[17113, 556, 511, 13, 56, "Input"],
Cell[CellGroupData[{
Cell[17649, 573, 191, 5, 32, "Input"],
Cell[17843, 580, 473, 12, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18353, 597, 291, 8, 34, "Input"],
Cell[18647, 607, 712, 20, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19396, 632, 1031, 25, 57, "Input"],
Cell[20430, 659, 30833, 573, 235, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51300, 1237, 347, 10, 34, "Input"],
Cell[51650, 1249, 600, 18, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52287, 1272, 121, 2, 32, "Input"],
Cell[52411, 1276, 5266, 79, 164, "Print",
 CellTags->"Info993744972030-7316328"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57714, 1360, 2158, 52, 193, "Input"],
Cell[59875, 1414, 2847, 54, 413, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62771, 1474, 220, 6, 70, "Subsection"],
Cell[62994, 1482, 143, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[63162, 1488, 825, 22, 56, "Input"],
Cell[63990, 1512, 695, 18, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64722, 1535, 312, 7, 32, "Input"],
Cell[65037, 1544, 417, 8, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65491, 1557, 480, 12, 34, "Input"],
Cell[65974, 1571, 1443, 39, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67454, 1615, 762, 20, 56, "Input"],
Cell[68219, 1637, 824, 22, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69080, 1664, 760, 19, 56, "Input"],
Cell[69843, 1685, 959, 28, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70839, 1718, 158, 3, 32, "Input"],
Cell[71000, 1723, 1159, 35, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72196, 1763, 157, 3, 32, "Input"],
Cell[72356, 1768, 597, 17, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72990, 1790, 157, 3, 32, "Input"],
Cell[73150, 1795, 720, 23, 69, "Output"]
}, Open  ]],
Cell[73885, 1821, 700, 16, 56, "Input"],
Cell[CellGroupData[{
Cell[74610, 1841, 191, 5, 32, "Input"],
Cell[74804, 1848, 1089, 31, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75930, 1884, 291, 8, 34, "Input"],
Cell[76224, 1894, 1463, 44, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77724, 1943, 1031, 25, 57, "Input"],
Cell[78758, 1970, 39241, 711, 235, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118036, 2686, 347, 10, 34, "Input"],
Cell[118386, 2698, 1351, 42, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119774, 2745, 121, 2, 32, "Input"],
Cell[119898, 2749, 5269, 79, 164, "Print",
 CellTags->"Info1153744972060-7316328"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125204, 2833, 2158, 52, 193, "Input"],
Cell[127365, 2887, 2988, 56, 380, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[130414, 2950, 145, 2, 51, "Section"],
Cell[130562, 2954, 141, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[130728, 2960, 99, 1, 35, "Subsubsection"],
Cell[130830, 2963, 551, 15, 34, "Input"],
Cell[CellGroupData[{
Cell[131406, 2982, 95, 1, 32, "Input"],
Cell[131504, 2985, 463, 13, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132004, 3003, 341, 9, 34, "Input"],
Cell[132348, 3014, 527, 15, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132912, 3034, 263, 6, 32, "Input"],
Cell[133178, 3042, 202, 5, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133417, 3052, 206, 5, 32, "Input"],
Cell[133626, 3059, 215, 4, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133878, 3068, 348, 9, 41, "Input"],
Cell[134229, 3079, 247, 8, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134513, 3092, 404, 11, 34, "Input"],
Cell[134920, 3105, 362, 9, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135331, 3120, 99, 1, 35, "Subsubsection"],
Cell[CellGroupData[{
Cell[135455, 3125, 450, 12, 32, "Input"],
Cell[135908, 3139, 339, 8, 32, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136308, 3154, 198, 3, 51, "Section"],
Cell[136509, 3159, 141, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[136675, 3165, 126, 2, 32, "Input"],
Cell[136804, 3169, 1684, 35, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138525, 3209, 299, 6, 34, "Input"],
Cell[138827, 3217, 277, 5, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139141, 3227, 301, 6, 34, "Input"],
Cell[139445, 3235, 281, 5, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139763, 3245, 215, 5, 34, "Input"],
Cell[139981, 3252, 263, 5, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140281, 3262, 222, 5, 34, "Input"],
Cell[140506, 3269, 216, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140759, 3279, 249, 6, 34, "Input"],
Cell[141011, 3287, 397, 9, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141445, 3301, 307, 8, 34, "Input"],
Cell[141755, 3311, 187, 4, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141979, 3320, 283, 6, 32, "Input"],
Cell[142265, 3328, 386, 8, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142688, 3341, 161, 3, 32, "Input"],
Cell[142852, 3346, 458, 9, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143347, 3360, 209, 4, 32, "Input"],
Cell[143559, 3366, 344, 8, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143940, 3379, 164, 3, 32, "Input"],
Cell[144107, 3384, 523, 11, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144667, 3400, 164, 3, 32, "Input"],
Cell[144834, 3405, 463, 11, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145334, 3421, 125, 3, 34, "Input"],
Cell[145462, 3426, 177, 3, 73, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)

