(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     56855,       1297]
NotebookOptionsPosition[     54543,       1211]
NotebookOutlinePosition[     55041,       1232]
CellTagsIndexPosition[     54953,       1227]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Homework #2 : 
 Problem 2\
\>", "Section",
 CellChangeTimes->{{3.744461061695609*^9, 3.744461071225643*^9}}],

Cell[CellGroupData[{

Cell["Horizontal", "Section",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
  3.743445462029182*^9, 3.743445463517805*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "zero", " ", "gravity"}]}], "  ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"m", " ", 
      RowBox[{
       RowBox[{"v", "'"}], "[", "t", "]"}]}], " ", "\[Equal]", " ", 
     RowBox[{
      RowBox[{"m", " ", "g"}], " ", "-", " ", 
      RowBox[{"b", " ", 
       RowBox[{"v", "[", "t", "]"}]}], " ", "-", " ", 
      RowBox[{"c", " ", 
       RowBox[{
        RowBox[{"v", "[", "t", "]"}], "^", "2"}]}]}]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"g", "\[Rule]", "0"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", 
   RowBox[{
    SuperscriptBox["v", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "b"}], " ", 
    RowBox[{"v", "[", "t", "]"}]}], "-", 
   RowBox[{"c", " ", 
    SuperscriptBox[
     RowBox[{"v", "[", "t", "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{
   RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0", "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq1", ",", "bc"}], "}"}], " ", ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}}],

Cell[BoxData[
 TemplateBox[{
  "Solve","ifun",
   "\"Inverse functions are being used by \
\\!\\(\\*RowBox[{\\\"Solve\\\"}]\\), so some solutions may not be found; use \
Reduce for complete solution information.\"",2,61,48,17493986437857842244,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.743443930156773*^9, 3.743443958760106*^9}, {
   3.7434440290561647`*^9, 3.743444033408049*^9}, 3.743445377618147*^9, {
   3.7444611067812777`*^9, 3.7444611217802963`*^9}, {3.7444612461564093`*^9, 
   3.7444612531642647`*^9}, 3.744461335292691*^9, 3.744461758241198*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"b", " ", "v0"}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c"}], " ", "v0"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"b", " ", "t"}], "m"]], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "v0"}]}], ")"}]}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Look", " ", "at", " ", "ONLY", " ", "LINEAR", " ", "term"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"dsol2", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eq1", ",", "bc"}], "}"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{"c", "\[Rule]", "0"}], "}"}]}], ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443960636125*^9, 3.7434439618672132`*^9}, {3.744461156530561*^9, 
  3.7444611825616417`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", "t"}], "m"]}]], " ", "v0"}]}], "}"}]], "Output",
 CellChangeTimes->{3.743443785726227*^9, 3.743443849426681*^9, 
  3.743443964050158*^9, 3.743444033479967*^9, 3.7434453776918716`*^9, 
  3.744461138699439*^9, 3.7444613353591146`*^9, 3.744461758314089*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Look", " ", "at", " ", "ONLY", " ", "QUADRATIC", " ", "term"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"dsol3", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eq1", ",", "bc"}], "}"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{"b", "\[Rule]", "0"}], "}"}]}], ",", 
      RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443856444902*^9}, {
  3.7434439672291822`*^9, 3.743443968108109*^9}, {3.744461175074798*^9, 
  3.7444611802910852`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"m", " ", "v0"}], 
    RowBox[{"m", "+", 
     RowBox[{"c", " ", "t", " ", "v0"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.743443785726227*^9, {3.743443849426681*^9, 3.743443856736702*^9}, 
   3.743443968342766*^9, 3.743444033500185*^9, 3.743445377713902*^9, 
   3.7444612923500013`*^9, 3.7444613353849707`*^9, 3.7444617583370647`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol1", " "}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", " ", "v0"}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], " ", "v0"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"b", " ", "t"}], "m"]], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "v0"}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{3.744461288768561*^9, 3.744461335403048*^9, 
  3.7444617583405247`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol2"}]], "Input",
 CellChangeTimes->{{3.7444612791859627`*^9, 3.7444612852338142`*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"b", " ", "t"}], "m"]}]], " ", "v0"}]], "Output",
 CellChangeTimes->{3.7444612888354673`*^9, 3.744461335420974*^9, 
  3.744461758361499*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol3"}]], "Input",
 CellChangeTimes->{{3.7444612820001497`*^9, 3.7444612827362432`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"m", " ", "v0"}], 
  RowBox[{"m", "+", 
   RowBox[{"c", " ", "t", " ", "v0"}]}]]], "Output",
 CellChangeTimes->{{3.744461288864696*^9, 3.744461293972412*^9}, 
   3.744461335438136*^9, 3.7444617583834476`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Pick", " ", "some", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"values", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"v0", "\[Rule]", "1"}], ",", " ", 
      RowBox[{"m", "\[Rule]", "1"}]}], "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.743443992092004*^9, 3.74344400357782*^9}, {
   3.743444046969207*^9, 3.743444048040835*^9}, {3.7444613059360723`*^9, 
   3.744461314319744*^9}, 3.7444613894863997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "t", "]"}], " ", "/.", "dsol1"}], " ", "/.", 
  "values"}]], "Input",
 CellChangeTimes->{{3.743443981138796*^9, 3.743444042168939*^9}}],

Cell[BoxData[
 FractionBox["b", 
  RowBox[{
   RowBox[{"-", "c"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"b", " ", "t"}]]}]}]]], "Output",
 CellChangeTimes->{{3.743443989606679*^9, 3.7434440502686853`*^9}, 
   3.7434453777402067`*^9, 3.744461335460238*^9, {3.744461375691464*^9, 
   3.744461392380224*^9}, 3.744461758411324*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"dsol1", ",", "dsol2", ",", "dsol3"}], "}"}]}], " ", "/.", 
   "values"}]}]], "Input",
 CellChangeTimes->{{3.743443981138796*^9, 3.7434440721062517`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     RowBox[{"-", "c"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"b", " ", "t"}]]}]}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "b"}], " ", "t"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"c", " ", "t"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.743444064667819*^9, 3.743444072391*^9}, 
   3.743444466095496*^9, 3.743445377762745*^9, 3.74446133547845*^9, {
   3.744461377805498*^9, 3.744461394237639*^9}, 3.744461758433992*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"tmp1", " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "\[Rule]", "1"}], ",", " ", 
       RowBox[{"c", "\[Rule]", "1"}]}], "}"}]}], " ", "//", "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"LineLegend", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Gen\>\"", ",", "\"\<c=0\>\"", ",", "\"\<b=0\>\""}], 
       "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743444073139323*^9, 3.743444096392931*^9}, {
  3.743444290021035*^9, 3.743444349043425*^9}, {3.743444384899706*^9, 
  3.743444416065856*^9}, {3.743444512594083*^9, 3.743444514222501*^9}, {
  3.744461439008419*^9, 3.7444614548793907`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{{}, {}, {
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0]], 
        LineBox[CompressedData["
1:eJwVlGc4FQ4bxg8iex3Z+4hCpChK53mikllWSUbJiqhkU2TP0CIlK9mVjISs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         "]]}, {
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 1, 0]], 
        LineBox[CompressedData["
1:eJwVlGc8FQ4bho0IkXPs7RzHyiojUup5shpEtiQro8iMECLKFkJmtmgIlRKy
srJXRjRkpVSEMor3/366P9y/333dny6ynbuhAw0VFZUxNRXV//P+S31n+dyP
8IQ7yVsgYgpydnWGEbU+gZK4dPnmkSlwgv70Ba8p6On4LbXTdRKo8n9Xj8dM
wftM7it+1pOQtkNgoqNwCgzdLp9aMZiE9jeOQveHp0BdhzVkl8okSBr/zXc4
OA1eTfmEF9ST8OWCxKMP1DNAjjwysJn2CZxvB9X1JcyC1u+AC4zZH8FtZs/U
s8fzUIohfROPJ+CT1RhD45t5MJ+fyi65MwFGo5Fy3dPzoJzxYSzy2gQc6Jzz
n+H7Che0XpwO15sA2ooiAlfEV7g7vGJ3+ec4pAWSj/haf4NYmgend+4fh0Z2
3nRVwnco2cH3Lb9nDJjINyQ+HliEUs1zSgcPjEC7WuLea1qLMPW80WdRbATC
zbNVBA0X4R9zrFAl+wjQJFQdO+uyCE3WG34Xfw7DxtaC08jdRcgwaOcMKh6G
bxMmJb00S8Al77FPm28YutIk9jR0LcHppmvV7Exv4RahUyrPZhnmOhj+mRAG
4aWKYKWe2zIYc9PNEagGYdrKHf4GLENExYOnYz8H4FApu7FZ6jLEk1JaknsH
4MsJyyCWnmXIyrodWhY/ABph33v9D61AzLa2iivbAKytsvoYcq2CdLvC4Wpy
P9iNG9fTdv2GuDI5nmsdPcCUOenqOfYbSJN+RhXlPfDEwk3g4+xv0Kv+JrNx
pwdo30X4V1P/gauKs55d53ugcLRa0VPlD4TwvdT13OqG2bekkg/5fyAjSbfm
kUo3OPctJLz0X4MRYUYpz5ed4Nlyw85dYgPcUh+sJf1uB6Fpbfrfihsgpuhz
lzDVDp00jA8CcQP8u7dCs3rbQQzjlqLObMBn0+JPkyXtMFadElIYswGrAQ0Z
ZMt2OFp+L3vs5wac+zLW6dzSBsTM9ncaVZvw9eMU41B+K1R4MBvxnPgHJUZK
9XfDm6Erg92/1PQfKHUuuBzwaYbZZr4cdft/ELT5YXjyfDPw8e75din4H+jb
hlTaHG2GG41aYY2V/+CKrs9Bln+vwZQt+KmzyBa8Pm35kMv3NWw8XWJ/tbkF
ise/h6X6NEFegMvXfWZUWOUVTR5Kb4B9DYxrEeeoMIEYalgR2wANO0roPp6n
wtoFxy9pwQ3wKW6aFOdBhY7lPCIRDg0glHvObD6KCt2knb98kG+AjGb95rxa
Klw/f8tmPq0ebrMoZbOJUGOZYvUcLVsdhOb8NVhZoEb7S8FDG4dq4PS+Kk/p
ZWq0Ct12eCdeA0KNlxPt1qnxQS792Q5iDVR//trXR0eDsbpjauNz1fBLbEy/
VIgGPc7SXKtPrga7R5WnHE/TILFyljFi6SUcfel2YvQpDc4ndY/VPq8CqsFP
WHuVFrOqqIWUXZ/Djfm6vKvXaVEs4Z6/qcVzYKS6S6MaSYsVy74vwo89BzbZ
M82VKbQYV6lYyCXyHMQi+o+VldPi1oXonl8jlXDyUJNe/iwtbuT+/pGgXQlJ
BQWWkYY7MGsjZ5xp7zMQ93b0M5aiwydHi2J1pJ6A7MGPRjn76DCl3MV3p8AT
UKIy3/tVmQ6f55ne6WF5AuqxJ2aDNegwh8H91LWlCrAqlDF+aEmHwXlbD+1e
VsCdoV97aeLpMHUuN1NFpwLo9gfPlS3ToV1JqszIlXKYXk013fWKHvca+i8a
jpZC/lHFy+9f0yMxbPbxt7pSsI7riS/roEd+yVfMGUWl8E6U7o3RKD0+38Vz
TuVyKfQbeR3KWqbHY+o7DbxYS6GuQpckK7UTKQ7JtWM6jyDVlfqrXupODChS
vbw8+ABOzjgH3fZkwBc2F+NLBEtAO4jySNOPAV9RLudeZywBdc6Jd7+vMaDu
0tVIl9ViOKh16sDZWAY8Wqdd5NldDFJFe5cpxQwYuVkarXWtGHY5rFyonGDA
7zSNS9uf70HXdJDx6DFGJBJ/frepKgK96QRpISEmJGv/O0OXUABd0tNDlqJM
qN+2wdoaUgA6l1WuZUox4Xka1ZLbngVwnOZDH48KE/4CLwt9owJQJ0lfYT/N
hBRurWYT7gLYb9nSwBDKhC37VKtu5eWDwNC6yfIME6pO/pn1qsuDr6/tQtpL
d6Hwg6RiSZ5cEE4cdb71bBcyut8k32LKBWMrPRPjml0YVkhU3lrPgbo1ValP
7btwU3ysk745B27LEof+TO3CqBauDMkzOXAotV5Cgo8ZTbRKObIjsiHWWaD3
ZjgzJje3WfWsZIEccVhQw5oFY5Tz5ByYM2A2bjY0xYEFbZiSqkf+pMNdpj9z
cy4sKG76KchiKh2Yd/A8ifVjwYGbF30TqtPh6+8z2sOJLNi6z32g9mI6FE28
d7vYzILnWJqkmDvTQKBkpj5+z27cXrrnvzc9FZhg1XZieTc+TZQUWLNJAb+j
kgzPN3YjrW9fUoVeCsxqnH0cT82KLmqfH1xVS4Gm440b6qysSDaeun6IJwWu
GsYl3ZdixRvWB2yu9CXDNwexliu2rNh1kda5RSMZumJNJIm9rDh6qcrIfX8S
HPtu8UfEhIDpe2m1T6onQjZH2GCwOQEzkg02uxUTYeXQw7KJswRs26IZOyeW
CLnRm0537AhoHtg6nceQCBsSWaOMHgRsNFcUqe5NgEd2718uRhMwQPTKZRGb
BCCMWgfWNRBwoThYXoA9Hkab7KktZIjYTRWdkbgeA4tH3/EF7SXiC9++mPtT
MbCzUV8pV4GIxMXcwoHuGFCuP+g0e4CIks1y3Ob5MZBcQ+j20iLi+FnPaDnd
GNB/VpsWY0XEkXoU3sqPhtYijn2vEoiY/tu/tdsyCiojm61Iq0R0tPhjG7QV
DiUnO3ki1ohYltJ1cu1rOGQwDwx83ySiJjxrCRsJh5CEj9o1NGyYfzxUtas8
HHTTNuRMCWxoVixxm2wfDp+L923HSLMhyazsd3/3TdjdlpXzx5YNC7vEzn97
dAMc6Xw+9fSwIYdo2pBiaijwCb8Z2exnQ2mhUzq+kaHQc0CwV/ItG970c/No
9Q8F5Ustr0LH2XC1fzk3wjIU6Ac5M5W/sKGkb2J6skgoFOU+N8mmZsfjTuTV
vvLrMH1orcNViR1VtailU96GwHmvgErmDHYc1Fy1ngy8BsoKHyr33GXH/W0w
vdfhGjD9wufauezo1aY5kHDqGpR70r8IuceOVP66T6KErsFfj8SqlSfs6LNt
t2LSGAR33ItrJjrZcY+n8n5dpiB4c2mw8dE/dtz71j9M/34A7HWS7tG15cDM
l6fkB3j84cNFYfdSew6UdPlw+AGtP8ReYifsvsCBYho/hZN/+MG856ZBrxsH
ej4JkLzb7AcFgZ1vDQI5MPev8/1QTz/gvu3y3jSVAw/WUt+81eML27UPF2y6
OdDy2vqaZsoV6GWT2eWjyonXoot45Qy94Yir63ymGic+UIzVk1f3hsdtj9ua
gBMfdrhzH1XwhluB8jcI2pxYp5N7OJzNG3Rnlf89NOTEUJqA9qLBy9Dx8ujP
zy6cuMftl5m8+WVosTEbPJ3NiVf7i7+oOHtBzePQTBlaLnznv7pOX+4B9Lom
fKn0XDglQ1PflecBBvMS6dRMXMiValqUneQBc5TuO8MELrR3vf7I0dcD2NO5
b4cIceEjbd+b4eABLmGPIodUufBijTn9eoE78JsP+wR6cOFrObMfa1uuEEAt
dbrrPRcOZ36sv7rqDLOau0bFJ7mwfbpyef6DM5yOXLC+Ps2F3I+WmC61O4Mo
a5m78jcuNNa/WFiS6QxdAkrxuWv//W390kmt4QxCB470eLNz4z3pQEvxlIvQ
5GaoK3iCG38GiWX3aF8Apomrx92eceOA0ccW7wkHUPa9zxL/ghvb9Dxoznc6
gC3b6EBZNTe2lqzctqp2gKrj+88tNXCjmDaEB6U5gGPlT0/vbm4csvVLPmPi
AI237DOvznJjYvxjq+v99v/5Su9HOA8PltjzNJ4YPA8z98jJOYE8KC8wZ1K8
YQsLNybXaUN4cMt3Ncrtmy38ssuzvhDGgxpKSnnqE7ZAJUyWlo/mwbfCxaeI
dbbAl0pqakrlQb8MUfdjobZwOkJ4ceYJD/4J9/RjYbGFWidBXZl5HhwSiU57
IW0DyZK8O16a8OL4k4C7ZVznwNJKvHjKnBdHKnsLK7YtQTRZ8eRuS160rwwe
bfliCc+2TyWct+PF5yNRMaI1ljA0HCqw250XmV+PJ7y0sQT2mwtK5yN5cdR+
pnF/2Vm4PVnvwFLDizrBp05ynbGAhAzHNlsSH+6Me8yZ+t4MfK+EXg6k8GFO
PMtPnk4zsDLMFk4V50MOrjcC96vMQIZp2LdLhg93H1k5vpJkBm/8tSRVVPnQ
Ud2gTEnHDGjOiEYxG/LhmF7VHuNaU/Dh/nzyRRgfDo/dUHldYgIWyed6mOf4
MITdVVSixAgEnjLxu3zlw8S4ueTcVCP42P/C6c13Pjysw/RVIsII7FnZqMNX
/uNtpLPbOBqBW3Sr4jY1PybxoLCPmBGEhuxNXxLgRw1rK3bJe4Zw/xK1/bAh
P/LfGlU+X2EAa5pF6zl1/DimuE+0ckwfAmtywpob+bGz0qK2qkEfqBQyWOab
+THL0fJHb7E+7BSOJyt08uOhMffPB67oA9e634nmEX5UIKhbL7Prg2KpbvqX
RX4Ml9v2+WeoB26cKwfkKQL44dL9vq0PujA1o+7XFCGA2WKOC7nSJ0E9pydf
KkYA5b/ZStlwnoRcc4vu27cE0CnJ2lhh+wRYdXqKnE8RwOcZbDKsgyfgXXlu
F22BAPZFyEvfDzgBAwFbJK06AZR765R5uu84NBGr37StCCBnh+Zt6ohjkH9Y
nr/bVhAlGhx+vhDXgiY9prBNe0F0dm2RX+DUgs/WU1/3XBDEiqXgDlk6LaCE
plSHuwmiekv50OiUJhS2rp/BAEE03xEu1p2nCUX6TWlPkwVxn4F1rhhJE0ps
jbgy2gRRmOnMpJ64BpTe9CE6yQphVXNp4HnTo7Cgdi705j4h9A7I2TF9/CjI
rGguFygK4euZjt3uh47CAzuOt59UhfC0A39UIekolMDTNAttIdyTLaQQ+w2h
cH1RWM9aCHXWZfSOhSFkuF6S258ohBz8rZdcvAEiTM7r0K4Koc1YKSE7Ug3y
9ScsHdaE0JOdUy3cQw1qT5i4tW0KYaC6Z32ouRr8OnwsMYZGGBdFbaOqJNXA
Ulx6hJ0gjN/ZK3U5Ow6Bwp9fdqLSwnjRsWfoBuEQfEgLvaplK4yjXAVz7Q9V
Yf9E3v2IbmFcPiYu4c+jAgS5C2tlfcKYJj6MWvQqsBAsd2x0UBjTl/Y/FV5R
hkJKzbTkO2H8Vjvovd2rDBwuQ8Ids8JYVickfzFSGTYCaXXoqUhY3nhjZHxz
P4ztUm48zktCxi/a35cWlCBtT2Zptw4JvfSjdt9dVYCVZe2isFMk1H05I3tp
RgH0635lqeqTkI08TTrxVgHojU7GFhmScPJ7iqFMpQL4BK47B50hYZft/aw7
Pgpg2GsmKetEwg4Z1oeLa/LA7MNREBtKQucfso9cGOUhuCEuTeclCdtkXeOO
ZcvB1/cNyevVJGxxys7PvCEHppvLCcW1JORh/H2YzkUOZJQtomgbSCj+608d
zwE5GH0ofrWmlYSiW49XjgzKgkJq/VnpIRK+c5R46sciC7OuS0K7fpJQTebv
XclEaTjFb1LUIUpGRTqW05P9kpA2LddwVpyMWZ9LDvvWScJ0KcP4ggQZg1Xm
LQQeSkIg1hJYpcnY2TCxknRDEh45UAKN5MkoYq1mqXJAEpjKlwwnDpNR8Ll1
s2a+BLRp3qL6YUrGVeMxOanr4nDUre0sMYqMdArmYa+cRGFjdF67Ofq/vlUz
3t1UFJ5pMCv4xpIxcv/msX1aoiDOa8DwPp6Mt8IYbr0XEQXm5nfPSu6QkUm2
lW32AwVGeX+wYCEZ+/u3DArPUMCjhaPBrZ6M7Vla5qFnRCBHwE60a5WMOeP0
UidDSHBQUVrO7g/5P3/4n1K9TIKhEysqa2tkbP3m8UbBkQQMvuE6on/JeO+I
7ANNXRJ49D/wCqQRwaeaXNJTPCTA8OUGGVYR1PgxoM5wQRg+/7xxLk5SBBNq
y+sPTwmC6OviO3pnRZDt5saSOJEfemTWCicsRdAsbo1e9C8f+N05/tTZSgT3
V/i7yM/xQefF+d5wWxGce31xMfAVH3gRpBnrnURQTmAm6q0zH9Sfexyw11sE
qSORL7SdFyzWntkQ4v7jUZ3KuhzPAwmyTVIDdSL48ax3tuwJLig5cJYxtEEE
+aKuw0VlLqjXWJmTbxJBPQmLx88oXPDjjHhRYosI2i+rNVzd4gSd8Ghhgy4R
1KaaUW96xgn0Hw05+sZEcDNyxlxRlBMCEqb+da+I4GpHwH3N3RzguLyj/40U
Bf1eczEHMbOB1QPNHksZChqYH549tUUEU9sbnT9lKRjNwzi7Z5EI2r20rZzy
FPwREqtIO0QE8Yc0NbYqFFxgf8B2MIsIM3ZUResaFMw83GpRIUcE+4FNvz3n
KKgS0qEWc5YAdhW/SFHxFAwxvmJmco8FLoUa/T2ZSMG+xaGnRrEs4GP0bIQ5
iYLUeo0fL3ixQOSqz62EOxRMf69rOnKEBR6rrm+m3qXgeLXW7aZRZlhv3B6+
95CCriFKwo0EZkgYYI5rbqOgofFo/2gCE2QUuF4If0PBwuWu4hh/Jijw7tE4
3knBLxsL3w3tmOA5V8JGZw8Fh7YZw4SUmGDCgv3C4Nv/9vNyPxSPMoLEFK/G
5ykKRhXY/rssxgj7nl0VKpyh4HLkeIIDKyMcvDm+7jBHwYiV74HO6wygK3G3
fP4rBc0ldvE/7mYALxeS0NISBfsFSlP5fBkgUO36+pNlCnp5MPAU2TLATZbP
Q96rFNTfGnNW12WAtLKCmLU1Cma1TGtVkhkgP2SHU/UGBf0LNUujmRngoYGD
euBfChJ+OhV5/dkJz0RaBY9sUfD3DJ2Q6+edULcsvr69TcEjbNP0V7t3wv8A
A7KPYQ==
         "]]}, {
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1]], 
        LineBox[CompressedData["
1:eJwVz3k41HkcwHFnWVckyj38XCHHlkrU51uKnI8z89BqjRwPG9FMiolSjg5M
at2SrI4noxR+7vtsGIyUzdS4hiiFacogtv3j/bz+fmuRItwDRYSEhIi/+l8e
x0G38ewUvNh+h6yWPAkfQ/RLPwhz4d2wZUK42ySEZlxqHKBNw+FbIuLm7RMQ
zt05WVE2C/x9Wbp5zeMw5vevREvPLLBnquScqsfBYyTFpG9qFhjRxCax5+Ow
nzFzkasyB+lmbVapheMgWl4ip5Q8B5o6m5MEceOQTdU6FH3qE9yg0G33wji0
KCjnWMrNg22SIGq1fQwkta7pc/YvgIWKhWViFwe6rW+bxh1bgCWnO5TtdRxI
It7bp+6+ACpVU0EvyzggQqu28w1bAIauhJVEJgdW1j8Hvy1YgNC16gidQA58
Yns97hdZhAm/38+ri3OgN1t/Z3PvIpyTyqR3O36ANDmGYdGfPHDsXabOLbKh
Zp96pUs4DyQq8C8N02yY8ouAtVgeDEQ3/MwZZYMVXcHTO4sHphmTjLAONny0
P3lJhsmDPVPDipQcNthcne+/aPUNEosHVhRt2LDM30JxV+LDd8Ghdtf8USCN
ejaJ9n6H/t3TT1in30FkxzVShP4KkFk1erjDCJSflfbYYf8TmO9X3Mrz30BR
bNicmbcQcmYd1Z2TGIaEwjW3b5+FUYyRSvyLpiEQGhpD9TGiaMJr1plVxAI9
ctAFT0NxlH/i71vKaYMwxc86IdWwCX2xbvmo8ngAHLihlzIiJdAHh5Ztq+n9
4DJFM9LQkETv06Wmk0WZMNdGutxNl0LDR6nz7i97wUT+jbrNKRn07Rzr5Jkg
BkgC35/Nk0UvlQKHWPavwG7e54e2lxyimw94h5j0wEjraWEfY3lU/tVg9ZxJ
N1SmtPsR+PLIv0J30NutC4LEKWNM5lZkGzpznhHVCQFRsZXSuQrIeOt+A2p5
B5gGGzGd/Lch1QwO0VyoA/q3GktRLBWRXmTfyAGndqgrS8gzFlVCPk/iZ4bK
2iBW2NC1970SsstSq34s2waS7Jjj4RXb0cYOoqZ4bCtwH2rdLaTuQJ2apkW6
gha4a6AsVuOljPL0vLu0yC1Ayw3q8ieoIHGZGzPV683gc/cPpvSMCrIk6dSc
v90My0dLBIWNqohk6ObJIzTDJPfIhdZkNdQdkaxMjmmCBwfNVfv81VFiPLl0
pLQR6IkU+eBdGuhqZBVd9XsDJHsFOIryNdDoWJT5JscGsGAXPUnu00QFbvfX
ODn1kL0zj97nSEBjP4ZK5lfrIL45NduxhoACDgxzjxPrwFnVq+SVjhYK6CJV
1zfWwuHwLl/561ropjVXmWxRC4VqJJ1evhbKTZEiP3tYAzptjzJdfLXRQJEM
sVOvBmi7Wg1Zjdqo8+v8FkJZNQTxxAZ7DDGU4FJvcNCsGkjlS4Tr6RgKoCtT
9zbh8FeCx5rDbQyVBuUa2TXgQPGoeCt9B0ObtRlGxDocUviUNFomhk4z59Vj
cRzKLAWrWQUYqnsu39X+DAdBy8abh08xlKdRpRp8HwcaSzq1vQtDceqDtjNX
cMgtPhOS1IMhW27+tPBlHIrJTJvjDAxl7il7rRaHQ5USbYXBxFBSrVeeRwwO
bB+FkKFhDLXOPxpoj8JBf1LZZmISQ0Td2VeVATiYVcRo/MPFkGyYle2wPw4H
EkcFgTMYirV8JMs/hYOTfsHz2TkMLR25kmRxEoeoMILG4iKGFhQt5Wo9caBa
XxG84GHINdFtadQdh0SZiddkPobO1n8lrLvikP2s+ObyMobuyZMDbJxxeHBZ
LLh2BUPmSRbRQY44PHULPEJdw1BqxO631+1xqNDuVD+0/usn2fcq3Q6HRp6e
YGMDQ7+l5cUOHsPhP5/kq6A=
         "]]}}}, {}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
       AbsolutePointSize[6], "ScalingFunctions" -> None, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 10}, {0., 0.6102430607650062}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"Gen\"", "\"c=0\"", "\"b=0\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                   True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7434444166126966`*^9, 3.7434444679341097`*^9, 3.7434445154295397`*^9, 
   3.743445378015785*^9, 3.744461335730179*^9, 3.744461381740147*^9, {
   3.7444614461806707`*^9, 3.744461455341147*^9}, 3.744461758515377*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fun", "[", 
   RowBox[{"b_", ",", "c_"}], "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"dsol1", ",", "dsol2", ",", "dsol3"}], "}"}]}], " ", "/.", 
   "values", " "}]}]], "Input",
 CellChangeTimes->{{3.744461561100506*^9, 3.744461565412485*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     RowBox[{"-", "c"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"b", " ", "t"}]]}]}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "b"}], " ", "t"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"c", " ", "t"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7444615568535633`*^9, 3.7444615660440083`*^9}, 
   3.744461758547441*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Manipulate"}]], "Input",
 CellChangeTimes->{{3.7444615917868423`*^9, 3.744461593643036*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}]}], \\\"]\\\"}]\) generates \
a version of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) with controls added \
to allow interactive manipulation of the value of \!\(\*StyleBox[\\\"u\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"du\\\", \
\\\"TI\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) allows the value of \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to vary between \
\!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]]\) and \!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]\) in steps \!\(\*StyleBox[\\\"du\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \
\\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"init\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \\\",\\\", \
SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) takes the initial value of \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to be \
\!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"init\\\", \\\
\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \
\\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"init\\\", \\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\
\", \\\"TI\\\"], StyleBox[\\\"lbl\\\", \\\"TI\\\"]]}], \\\"}\\\"}], \
\\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \
\\\"]\\\"}]\) labels the controls for \!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) \
with \!\(\*SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"lbl\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\
\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\
\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]}], \\\"]\\\"}]\) allows \
\!\(\*StyleBox[\\\"u\\\", \\\"TI\\\"]\) to take on discrete values \
\!\(\*RowBox[{SubscriptBox[StyleBox[\\\"u\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"u\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", RowBox[{\
\\\"{\\\", RowBox[{StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) provides controls to manipulate \
each of the \!\(\*RowBox[{StyleBox[\\\"u\\\", \\\"TI\\\"], \\\",\\\", \
StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}]\). \\n\!\(\*RowBox[{\\\"Manipulate\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"c\\\", \\\"TI\\\"], StyleBox[\\\"u\\\", \
\\\"TI\\\"]], \\\"\[Rule]\\\", RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"u\\\", \
\\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \
\\\"}\\\"}]}], \\\",\\\", RowBox[{SubscriptBox[StyleBox[\\\"c\\\", \
\\\"TI\\\"], StyleBox[\\\"v\\\", \\\"TI\\\"]], \\\"\[Rule]\\\", RowBox[{\\\"{\
\\\", RowBox[{StyleBox[\\\"v\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) links the controls to the \
specified controllers on an external device.\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.744461758593367*^9},
 CellTags->"Info723744443758-7795414"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"fun", "[", 
       RowBox[{"b", ",", "c"}], "]"}], " ", "//", "Evaluate"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.015", "]"}], ",", "Red"}], "}"}], ",", 
        "Green", ",", "Blue"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<b=\>\"", ",", "b", ",", " ", "\"\<   c= \>\"", ",", "c"}],
        "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Both\>\"", ",", "\"\<Linear\>\"", ",", "\"\<Quadratic\>\""}], 
         "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "1", ",", "\"\<Linear\>\""}], "}"}], ",", "0.1", ",", 
     "2", ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "1", ",", "\"\<Quadratic\>\""}], "}"}], ",", "0.1", 
     ",", "2", ",", "0.1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7434441581026773`*^9, 3.743444270021695*^9}, {
  3.743444527631879*^9, 3.74344454291429*^9}, {3.7434445762267227`*^9, 
  3.743444590079043*^9}, {3.7434446339510593`*^9, 3.743444916188471*^9}, {
  3.743444948648057*^9, 3.743445018087319*^9}, {3.743445381332775*^9, 
  3.7434453948792543`*^9}, {3.744461478238141*^9, 3.744461539324254*^9}, {
  3.744461570732073*^9, 3.744461722408909*^9}, {3.7444617972563763`*^9, 
  3.744461834822801*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`b$$ = 0.9, $CellContext`c$$ = 1.1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`b$$], 1, "Linear"}, 0.1, 2, 0.1}, {{
       Hold[$CellContext`c$$], 1, "Quadratic"}, 0.1, 2, 0.1}}, 
    Typeset`size$$ = {468., {123., 128.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`b$43180$$ = 0, $CellContext`c$43181$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`b$$ = 1, $CellContext`c$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`b$$, $CellContext`b$43180$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$43181$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[
         $CellContext`fun[$CellContext`b$$, $CellContext`c$$]], \
{$CellContext`t, 0, 10}, PlotStyle -> {{
           Thickness[0.015], Red}, Green, Blue}, 
        PlotLabel -> {"b=", $CellContext`b$$, "   c= ", $CellContext`c$$}, 
        PlotLegends -> 
        LineLegend[{Red, Green, Blue}, {"Both", "Linear", "Quadratic"}], 
        PlotRange -> {Automatic, {0, 1}}], 
      "Specifications" :> {{{$CellContext`b$$, 1, "Linear"}, 0.1, 2, 
         0.1}, {{$CellContext`c$$, 1, "Quadratic"}, 0.1, 2, 0.1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{515., {177., 184.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.7434441582253428`*^9, {3.743444203398334*^9, 3.743444271557992*^9}, {
   3.743444534744412*^9, 3.743444543687131*^9}, {3.7434445773280478`*^9, 
   3.743444590259008*^9}, {3.743444640555604*^9, 3.74344469691673*^9}, {
   3.743444729785904*^9, 3.743444916519302*^9}, {3.743444958418499*^9, 
   3.74344501852176*^9}, {3.743445378052331*^9, 3.7434453953170156`*^9}, 
   3.744461335761627*^9, 3.744461483284277*^9, {3.744461523739381*^9, 
   3.744461539945999*^9}, {3.74446157727584*^9, 3.744461722883951*^9}, 
   3.7444617586316*^9, {3.744461805855917*^9, 3.744461835167122*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Vertical
Now add gravity\
\>", "Section",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
  3.743445467741766*^9, 3.743445468765003*^9}, {3.7444617400075703`*^9, 
  3.744461743240264*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "Start", " ", "by", " ", "copying", " ", "all", " ", "the", " ", "above", 
    " ", "down", " ", "here"}], ",", " ", 
   RowBox[{"and", " ", "then", " ", "modify"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.744461900482836*^9, 3.744461914308947*^9}}]
}, Open  ]]
},
WindowSize->{808, 908},
WindowMargins->{{315, Automatic}, {36, Automatic}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info723744443758-7795414"->{
  Cell[43677, 996, 5266, 79, 196, "Print",
   CellTags->"Info723744443758-7795414"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info723744443758-7795414", 54844, 1221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 118, 4, 101, "Section"],
Cell[CellGroupData[{
Cell[701, 28, 144, 2, 51, "Section"],
Cell[848, 32, 143, 2, 35, "Input"],
Cell[CellGroupData[{
Cell[1016, 38, 899, 25, 52, "Input"],
Cell[1918, 65, 559, 16, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2514, 86, 312, 7, 32, "Input"],
Cell[2829, 95, 299, 6, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3165, 106, 480, 12, 32, "Input"],
Cell[3648, 120, 590, 11, 41, "Message"],
Cell[4241, 133, 726, 19, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5004, 157, 690, 18, 52, "Input"],
Cell[5697, 177, 453, 11, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6187, 193, 688, 18, 52, "Input"],
Cell[6878, 213, 455, 11, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7370, 229, 92, 2, 32, "Input"],
Cell[7465, 233, 425, 14, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7927, 252, 157, 3, 32, "Input"],
Cell[8087, 257, 248, 7, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8372, 269, 157, 3, 32, "Input"],
Cell[8532, 274, 246, 6, 51, "Output"]
}, Open  ]],
Cell[8793, 283, 511, 13, 52, "Input"],
Cell[CellGroupData[{
Cell[9329, 300, 191, 5, 32, "Input"],
Cell[9523, 307, 421, 11, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9981, 323, 291, 8, 32, "Input"],
Cell[10275, 333, 664, 19, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10976, 357, 1031, 25, 80, "Input"],
Cell[12010, 384, 30563, 568, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42610, 957, 347, 10, 33, "Input"],
Cell[42960, 969, 556, 18, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43553, 992, 121, 2, 32, "Input"],
Cell[43677, 996, 5266, 79, 196, "Print",
 CellTags->"Info723744443758-7795414"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48980, 1080, 2158, 52, 200, "Input"],
Cell[51141, 1134, 2800, 53, 378, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53990, 1193, 217, 6, 101, "Section"],
Cell[54210, 1201, 317, 7, 32, "Input"]
}, Open  ]]
}
]
*)

