(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    236312,       4806]
NotebookOptionsPosition[    231464,       4636]
NotebookOutlinePosition[    231832,       4652]
CellTagsIndexPosition[    231789,       4649]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[" Problem: Oscillations", "Section",
 CellChangeTimes->{{3.744461061695609*^9, 3.744461071225643*^9}, 
   3.7449897321413*^9, {3.74499014426995*^9, 3.744990147314713*^9}}],

Cell[CellGroupData[{

Cell["SHO (\[Beta]=0, q0=0)", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
   3.743445462029182*^9, 3.743445463517805*^9}, {3.744990566090476*^9, 
   3.744990575211726*^9}, {3.744990607318885*^9, 3.744990640417159*^9}, {
   3.744990942071199*^9, 3.744990944406584*^9}, 3.7449912932512083`*^9, {
   3.7449930901185637`*^9, 3.7449930930996733`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "zero", " ", "damping", " ", "and", " ", 
     "driving"}]}], "   ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", " ", 
      RowBox[{
       SuperscriptBox["w0", "2"], 
       RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", 
     RowBox[{"q0", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", "wD", " ", "t"}], "]"}]}]}], "  ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Beta]", "\[Rule]", "0"}], ",", " ", 
      RowBox[{"q0", "\[Rule]", "0"}]}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}, {3.744990158381131*^9, 
   3.744990205705883*^9}, {3.744990653101883*^9, 3.744990653566897*^9}, {
   3.744990951421031*^9, 3.744990952878166*^9}, 3.744991305974234*^9, {
   3.744993109467671*^9, 3.744993114592565*^9}, {3.7458356375956163`*^9, 
   3.745835641145843*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"x", "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}]], "Output",\

 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, {
   3.744990194282686*^9, 3.74499020652577*^9}, {3.744990654444541*^9, 
   3.744990662373081*^9}, 3.7449908236247473`*^9, 3.744990867179196*^9, 
   3.7449909561881647`*^9, {3.744991300476915*^9, 3.7449913062530117`*^9}, 
   3.7449931155985203`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], " ", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "v0"}]}], "}"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}, {3.744990215600648*^9, 
  3.744990230345748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "v0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.7449902318296337`*^9, 3.744990663334693*^9, 3.744990823663898*^9, 
   3.744990867218652*^9, 3.7449909584362097`*^9, {3.744991301347734*^9, 
   3.744991307528304*^9}, 3.744993118364545*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "eq1", "}"}], ",", "bc"}], "]"}], " ", ",", 
      RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}, {3.744990237825842*^9, 3.744990262591259*^9}, {
  3.744991314055122*^9, 3.744991314636736*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{"x0", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"t", " ", "w0"}], "]"}]}], "+", 
    FractionBox[
     RowBox[{"v0", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", " ", "w0"}], "]"}]}], "w0"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9, 
   3.74498974788309*^9, {3.7449902488218822`*^9, 3.744990262909902*^9}, 
   3.7449906645512447`*^9, 3.744990823830481*^9, 3.744990867362067*^9, 
   3.7449909596878433`*^9, {3.744991302392091*^9, 3.744991322891499*^9}, 
   3.744993119597851*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"v0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"\[Beta]", "\[Rule]", "0.1"}], ",", 
     RowBox[{"w0", "\[Rule]", "1"}], ",", 
     RowBox[{"q0", "\[Rule]", "15.1"}], ",", 
     RowBox[{"wD", "\[Rule]", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}], "  ", "/.", 
     "values"}], " ", "//", "Re"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.744990279392004*^9, 3.744990299725547*^9}, {
  3.7449906928087053`*^9, 3.744990703701223*^9}, {3.744990965986617*^9, 
  3.744991031953169*^9}, {3.744991329469304*^9, 3.7449913476335583`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUmnk4VV8XxyX5kTHzlGTKFNc820skKVJKhkKmVJQplEiGMpQkCQmVJKkQ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       "]]},
     Annotation[#, "Charting`Private`Tag$1830#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {-1.414213472383307, 1.4142135601257413`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7449903182845297`*^9, {3.744990681968917*^9, 3.744990704043785*^9}, 
   3.744990823966943*^9, 3.744990867479929*^9, {3.744990962197866*^9, 
   3.744991032629176*^9}, {3.744991303594208*^9, 3.744991348418972*^9}, 
   3.74499312080289*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "[", 
   RowBox[{"t_", ",", "\[Beta]_", ",", "w0_", ",", "wD_", ",", "q0_", ",", 
    RowBox[{"x0_:", "1"}], ",", 
    RowBox[{"v0_:", "1"}]}], "]"}], "=", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}]}]], "Input",
 CellChangeTimes->{{3.7449904561243773`*^9, 3.744990474676753*^9}, {
  3.744990729393552*^9, 3.744990731100923*^9}, {3.744991053872031*^9, 
  3.744991087620595*^9}, {3.7449913532504168`*^9, 3.744991354898115*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x0", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"t", " ", "w0"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{"v0", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"t", " ", "w0"}], "]"}]}], "w0"]}]], "Output",
 CellChangeTimes->{3.744990475097888*^9, 3.744990737299165*^9, 
  3.744990774110847*^9, 3.744990823990561*^9, 3.744990867504077*^9, 
  3.7449910896274843`*^9, 3.744991355229239*^9, 3.744993122823621*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "[", 
  RowBox[{"0.1", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.744991092861339*^9, 3.744991103782505*^9}, {
  3.7449913600377083`*^9, 3.7449913605746326`*^9}}],

Cell[BoxData["5.496340881591392`"], "Output",
 CellChangeTimes->{3.744991104040742*^9, 3.744991360895192*^9, 
  3.7449931340542316`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x1", "[", 
        RowBox[{"t", ",", "\[Beta]", ",", "w0", ",", "wD", ",", "q0"}], "]"}],
        " ", "//", "Re"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "30"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0.1"}], "}"}], ",", "0.01", ",", "5"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w0", ",", "1"}], "}"}], ",", "0.1", ",", "5"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"wD", ",", "3"}], "}"}], ",", "0", ",", "5", ",", "1"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q0", ",", "1"}], "}"}], ",", "0.1", ",", "10"}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.744990328259913*^9, 3.7449904251529408`*^9}, {
  3.744990479103593*^9, 3.7449905521939993`*^9}, {3.744990748724016*^9, 
  3.744990782306324*^9}, {3.744990872537311*^9, 3.744990881127442*^9}, {
  3.744991109769459*^9, 3.7449911893898687`*^9}, {3.7449912210133963`*^9, 
  3.744991221237327*^9}, {3.7449913673897038`*^9, 3.744991397275141*^9}, {
  3.744991429718965*^9, 3.744991429854907*^9}, {3.7449914806786346`*^9, 
  3.7449914939576483`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`q0$$ = 1, $CellContext`w0$$ = 
    2.31, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Beta]$$], 0.1}, 0.01, 5}, {{
       Hold[$CellContext`w0$$], 1}, 0.1, 5}, {{
       Hold[$CellContext`wD$$], 3}, 0, 5, 1}, {{
       Hold[$CellContext`q0$$], 1}, 0.1, 10}}, Typeset`size$$ = {
    540., {154., 162.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Beta]$3843$$ = 
    0, $CellContext`w0$3844$$ = 0, $CellContext`wD$3845$$ = 
    0, $CellContext`q0$3846$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`q0$$ = 1, $CellContext`w0$$ = 
        1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Beta]$$, $CellContext`\[Beta]$3843$$, 0], 
        Hold[$CellContext`w0$$, $CellContext`w0$3844$$, 0], 
        Hold[$CellContext`wD$$, $CellContext`wD$3845$$, 0], 
        Hold[$CellContext`q0$$, $CellContext`q0$3846$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Re[
         $CellContext`x1[$CellContext`t, $CellContext`\[Beta]$$, \
$CellContext`w0$$, $CellContext`wD$$, $CellContext`q0$$]], {$CellContext`t, 0,
          30}], "Specifications" :> {{{$CellContext`\[Beta]$$, 0.1}, 0.01, 
         5}, {{$CellContext`w0$$, 1}, 0.1, 5}, {{$CellContext`wD$$, 3}, 0, 5, 
         1}, {{$CellContext`q0$$, 1}, 0.1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{608., {252., 261.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.7449913867446823`*^9, 3.744991397732657*^9}, 
   3.74499143085113*^9, {3.7449914815291986`*^9, 3.7449914945121803`*^9}, 
   3.744993137079904*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SHO (\[Beta]\[NotEqual]0, q0=0)", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
   3.743445462029182*^9, 3.743445463517805*^9}, {3.744990566090476*^9, 
   3.744990575211726*^9}, {3.744990607318885*^9, 3.744990640417159*^9}, {
   3.744990942071199*^9, 3.744990944406584*^9}, 3.7449912932512083`*^9, {
   3.744993097953514*^9, 3.744993098116456*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "zero", " ", "driving"}]}], "  ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", " ", 
      RowBox[{
       SuperscriptBox["w0", "2"], 
       RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", 
     RowBox[{"q0", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", "wD", " ", "t"}], "]"}]}]}], "  ", "/.", 
    RowBox[{"{", 
     RowBox[{"q0", "\[Rule]", "0"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}, {3.744990158381131*^9, 
   3.744990205705883*^9}, {3.744990653101883*^9, 3.744990653566897*^9}, {
   3.744990951421031*^9, 3.744990952878166*^9}, 3.744991305974234*^9, {
   3.744993152707683*^9, 3.744993156345983*^9}, {3.745835646792481*^9, 
   3.745835647582716*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"x", "[", "t", "]"}]}], "+", 
   RowBox[{"2", " ", "\[Beta]", " ", 
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}]], "Output",\

 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, {
   3.744990194282686*^9, 3.74499020652577*^9}, {3.744990654444541*^9, 
   3.744990662373081*^9}, 3.7449908236247473`*^9, 3.744990867179196*^9, 
   3.7449909561881647`*^9, {3.744991300476915*^9, 3.7449913062530117`*^9}, {
   3.744993157216015*^9, 3.744993159984858*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], " ", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "v0"}]}], "}"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}, {3.744990215600648*^9, 
  3.744990230345748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "v0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.7449902318296337`*^9, 3.744990663334693*^9, 3.744990823663898*^9, 
   3.744990867218652*^9, 3.7449909584362097`*^9, {3.744991301347734*^9, 
   3.744991307528304*^9}, 3.744993160782838*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "eq1", "}"}], ",", "bc"}], "]"}], " ", ",", 
      RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}, {3.744990237825842*^9, 3.744990262591259*^9}, {
  3.744991314055122*^9, 3.744991314636736*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "t"}], " ", "\[Beta]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x0", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["w0", "2"]}], "+", 
          SuperscriptBox["\[Beta]", "2"]}]], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["w0", "2"]}], "+", 
            SuperscriptBox["\[Beta]", "2"]}]]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v0", "+", 
          RowBox[{"x0", " ", "\[Beta]"}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["w0", "2"]}], "+", 
            SuperscriptBox["\[Beta]", "2"]}]]}], "]"}]}]}], ")"}]}], 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["w0", "2"]}], "+", 
      SuperscriptBox["\[Beta]", "2"]}]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9, 
   3.74498974788309*^9, {3.7449902488218822`*^9, 3.744990262909902*^9}, 
   3.7449906645512447`*^9, 3.744990823830481*^9, 3.744990867362067*^9, 
   3.7449909596878433`*^9, {3.744991302392091*^9, 3.744991322891499*^9}, 
   3.744993162841893*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"v0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"\[Beta]", "\[Rule]", "0.1"}], ",", 
     RowBox[{"w0", "\[Rule]", "1"}], ",", 
     RowBox[{"q0", "\[Rule]", "15.1"}], ",", 
     RowBox[{"wD", "\[Rule]", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}], "  ", "/.", 
     "values"}], " ", "//", "Re"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.744990279392004*^9, 3.744990299725547*^9}, {
  3.7449906928087053`*^9, 3.744990703701223*^9}, {3.744990965986617*^9, 
  3.744991031953169*^9}, {3.744991329469304*^9, 3.7449913476335583`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[{{1.9090217857394887`, 0.5945877071026369}, {
       2.0454178542729324`, 0.4406093027278649}, {2.060940921839099, 
       0.42241330103529673`}, {2.0764639894052657`, 0.40417207609027495`}, {
       2.1075101245375993`, 0.3675720673429189}, {2.1696023948022667`, 
       0.2940282927543621}, {2.2937869353316005`, 0.14657021756718636`}, {
       2.542156016390269, -0.1419950278703762}, {
       2.557679083956436, -0.15945049218658916`}, {
       2.5732021515226027`, -0.1768134863325058}, {
       2.604248286654936, -0.21124653666107032`}, {
       2.666340556919603, -0.27883421244438567`}, {
       2.790525097448937, -0.40807488506480527`}, {
       2.8060481650151035`, -0.4236051212578087}, {
       2.8215712325812703`, -0.43898530289706894`}, {
       2.852617367713604, -0.46928260888306467`}, {
       2.9147096379782713`, -0.5279373975393434}, {
       2.9662488091152523`, -0.5731294407675322}}], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAs65kwp2TE0AOFY+NE1fivxDK9zTa
vxNAKtjGhcxG4b9NKWXxFkcUQE76lrW8vtu/+ot1u91WFEAxT2EYyu3av6ju
hYWkZhRAGjBHy9kb2r8EtKYZMoYUQBDzizc2ddi/uj7oQU3FFEBebTNyXh7V
vyZUa5KDQxVAOJBhTpCszL8Af3Ez8D8WQCtVsw6tTYe/ruGB/bZPFkBYdCgb
QTFcP1tEksd9XxZAs25VaaVEjj+2CbNbC38WQFXJ9R/Y3qQ/bJT0gya+FkBO
wFVInZS3P9mpd9RcPBdALTxERKmJyD+GDIieI0wXQHRrYGVGFso/NG+YaOpb
F0BxSGT3FaDLP5A0ufx3exdAkFso7vWqzj9Gv/okk7oXQPWQSbi0TdI/stR9
dck4GECi/k6HverXP6iFZGLiSRhAQ6WCcA2k2D+eNktP+1oYQECnScX9Wtk/
ipgYKS19GECjmJ7ek8HaP2Ncs9yQwRhAJ1qH3m5w3T9aDZrJqdIYQLs+AMSZ
Fd4/UL6AtsLjGEDy3jP9ErjePzwgTpD0BRlAzTRpicv03z8U5OhDWEoZQKir
HMwvJuE/CpXPMHFbGUBdh0UOg23hPwBGth2KbBlAlwFAk1uz4T/sp4P3u44Z
QAcVUKmNOuI/WsmEmyzGGUCigJPM3AbjP9oH5vA=
       "]], LineBox[CompressedData["
1:eJwUV3c81e8XFxIlZTeErKy4XHs957oXRZSGooysUMlKkhVFISQ7e2dkj5DH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       "]]},
     Annotation[#, "Charting`Private`Tag$7833#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {-0.5731294407675322, 0.5945877071026369}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7449903182845297`*^9, {3.744990681968917*^9, 3.744990704043785*^9}, 
   3.744990823966943*^9, 3.744990867479929*^9, {3.744990962197866*^9, 
   3.744991032629176*^9}, {3.744991303594208*^9, 3.744991348418972*^9}, 
   3.744993163925377*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "[", 
   RowBox[{"t_", ",", "\[Beta]_", ",", "w0_", ",", "wD_", ",", "q0_", ",", 
    RowBox[{"x0_:", "1"}], ",", 
    RowBox[{"v0_:", "1"}]}], "]"}], "=", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}]}]], "Input",
 CellChangeTimes->{{3.7449904561243773`*^9, 3.744990474676753*^9}, {
  3.744990729393552*^9, 3.744990731100923*^9}, {3.744991053872031*^9, 
  3.744991087620595*^9}, {3.7449913532504168`*^9, 3.744991354898115*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "t"}], " ", "\[Beta]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x0", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["w0", "2"]}], "+", 
        SuperscriptBox["\[Beta]", "2"]}]], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"t", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["w0", "2"]}], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v0", "+", 
        RowBox[{"x0", " ", "\[Beta]"}]}], ")"}], " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"t", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["w0", "2"]}], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}], "]"}]}]}], ")"}]}], 
  SqrtBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["w0", "2"]}], "+", 
    SuperscriptBox["\[Beta]", "2"]}]]]], "Output",
 CellChangeTimes->{3.744990475097888*^9, 3.744990737299165*^9, 
  3.744990774110847*^9, 3.744990823990561*^9, 3.744990867504077*^9, 
  3.7449910896274843`*^9, 3.744991355229239*^9, 3.744993166425198*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "[", 
  RowBox[{"0.1", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.744991092861339*^9, 3.744991103782505*^9}, {
  3.7449913600377083`*^9, 3.7449913605746326`*^9}}],

Cell[BoxData[
 RowBox[{"5.446845784896024`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.744991104040742*^9, 3.744991360895192*^9, 
  3.744993167829679*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x1", "[", 
        RowBox[{"t", ",", "\[Beta]", ",", "w0", ",", "wD", ",", "q0"}], "]"}],
        " ", "//", "Re"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "30"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0.1"}], "}"}], ",", "0.01", ",", "5"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w0", ",", "1"}], "}"}], ",", "0.1", ",", "5"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"wD", ",", "3"}], "}"}], ",", "0", ",", "5", ",", "1"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q0", ",", "1"}], "}"}], ",", "0.1", ",", "10"}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.744990328259913*^9, 3.7449904251529408`*^9}, {
  3.744990479103593*^9, 3.7449905521939993`*^9}, {3.744990748724016*^9, 
  3.744990782306324*^9}, {3.744990872537311*^9, 3.744990881127442*^9}, {
  3.744991109769459*^9, 3.7449911893898687`*^9}, {3.7449912210133963`*^9, 
  3.744991221237327*^9}, {3.7449913673897038`*^9, 3.744991397275141*^9}, {
  3.744991429718965*^9, 3.744991429854907*^9}, {3.7449914806786346`*^9, 
  3.7449914939576483`*^9}, {3.744993181257066*^9, 3.744993183405243*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`q0$$ = 1, $CellContext`w0$$ = 
    1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 1.93, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Beta]$$], 0.1}, 0.01, 5}, {{
       Hold[$CellContext`w0$$], 1}, 0.1, 5}, {{
       Hold[$CellContext`wD$$], 3}, 0, 5, 1}, {{
       Hold[$CellContext`q0$$], 1}, 0.1, 10}}, Typeset`size$$ = {
    540., {158., 166.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Beta]$11109$$ = 
    0, $CellContext`w0$11110$$ = 0, $CellContext`wD$11111$$ = 
    0, $CellContext`q0$11112$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`q0$$ = 1, $CellContext`w0$$ = 
        1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Beta]$$, $CellContext`\[Beta]$11109$$, 0], 
        Hold[$CellContext`w0$$, $CellContext`w0$11110$$, 0], 
        Hold[$CellContext`wD$$, $CellContext`wD$11111$$, 0], 
        Hold[$CellContext`q0$$, $CellContext`q0$11112$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Re[
         $CellContext`x1[$CellContext`t, $CellContext`\[Beta]$$, \
$CellContext`w0$$, $CellContext`wD$$, $CellContext`q0$$]], {$CellContext`t, 0,
          30}, PlotRange -> All], 
      "Specifications" :> {{{$CellContext`\[Beta]$$, 0.1}, 0.01, 
         5}, {{$CellContext`w0$$, 1}, 0.1, 5}, {{$CellContext`wD$$, 3}, 0, 5, 
         1}, {{$CellContext`q0$$, 1}, 0.1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{608., {256., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.7449913867446823`*^9, 3.744991397732657*^9}, 
   3.74499143085113*^9, {3.7449914815291986`*^9, 3.7449914945121803`*^9}, {
   3.744993169347568*^9, 3.744993183859707*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SHO (\[Beta]=0, q0\[NotEqual]0)", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
   3.743445462029182*^9, 3.743445463517805*^9}, {3.744990566090476*^9, 
   3.744990575211726*^9}, {3.744990607318885*^9, 3.744990640417159*^9}, {
   3.744990942071199*^9, 3.744990944406584*^9}, 3.7449912932512083`*^9, {
   3.744993100274043*^9, 3.74499310041961*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "zero", " ", "damping"}]}], "  ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", " ", 
      RowBox[{
       SuperscriptBox["w0", "2"], 
       RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", 
     RowBox[{"q0", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", "wD", " ", "t"}], "]"}]}]}], "  ", "/.", 
    RowBox[{"{", 
     RowBox[{"\[Beta]", "\[Rule]", "0"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}, {3.744990158381131*^9, 
   3.744990205705883*^9}, {3.744990653101883*^9, 3.744990653566897*^9}, {
   3.744990951421031*^9, 3.744990952878166*^9}, 3.744991305974234*^9, {
   3.744993209845305*^9, 3.744993213965435*^9}, {3.745835652186234*^9, 
   3.745835653764221*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"x", "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "t", " ", "wD"}]], " ", "q0"}]}]], "Output",\

 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, {
   3.744990194282686*^9, 3.74499020652577*^9}, {3.744990654444541*^9, 
   3.744990662373081*^9}, 3.7449908236247473`*^9, 3.744990867179196*^9, 
   3.7449909561881647`*^9, {3.744991300476915*^9, 3.7449913062530117`*^9}, {
   3.7449932076051903`*^9, 3.7449932147263317`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], " ", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "v0"}]}], "}"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}, {3.744990215600648*^9, 
  3.744990230345748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "v0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.7449902318296337`*^9, 3.744990663334693*^9, 3.744990823663898*^9, 
   3.744990867218652*^9, 3.7449909584362097`*^9, {3.744991301347734*^9, 
   3.744991307528304*^9}, 3.744993216082388*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "eq1", "}"}], ",", "bc"}], "]"}], " ", ",", 
      RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}, {3.744990237825842*^9, 3.744990262591259*^9}, {
  3.744991314055122*^9, 3.744991314636736*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "t", " ", "wD"}]], " ", "q0", " ", 
      "w0"}], "+", 
     RowBox[{"w0", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "q0"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"w0", "-", "wD"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"w0", "+", "wD"}], ")"}], " ", "x0"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"t", " ", "w0"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "q0", " ", "wD"}], "+", 
        RowBox[{"v0", " ", 
         RowBox[{"(", 
          RowBox[{"w0", "-", "wD"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"w0", "+", "wD"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", " ", "w0"}], "]"}]}]}], 
    RowBox[{"w0", " ", 
     RowBox[{"(", 
      RowBox[{"w0", "-", "wD"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"w0", "+", "wD"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9, 
   3.74498974788309*^9, {3.7449902488218822`*^9, 3.744990262909902*^9}, 
   3.7449906645512447`*^9, 3.744990823830481*^9, 3.744990867362067*^9, 
   3.7449909596878433`*^9, {3.744991302392091*^9, 3.744991322891499*^9}, 
   3.744993217580023*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"v0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"\[Beta]", "\[Rule]", "0.1"}], ",", 
     RowBox[{"w0", "\[Rule]", "1"}], ",", 
     RowBox[{"q0", "\[Rule]", "15.1"}], ",", 
     RowBox[{"wD", "\[Rule]", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}], "  ", "/.", 
     "values"}], " ", "//", "Re"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.744990279392004*^9, 3.744990299725547*^9}, {
  3.7449906928087053`*^9, 3.744990703701223*^9}, {3.744990965986617*^9, 
  3.744991031953169*^9}, {3.744991329469304*^9, 3.7449913476335583`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUWnk4ld8Tt9xrX+617/u+Xu69KkvvlCJCJdkLpRBFkigVUkmSJFuyhCwh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       "]]},
     Annotation[#, "Charting`Private`Tag$16391#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {-4.3013652176694865`, 4.301261364109036}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7449903182845297`*^9, {3.744990681968917*^9, 3.744990704043785*^9}, 
   3.744990823966943*^9, 3.744990867479929*^9, {3.744990962197866*^9, 
   3.744991032629176*^9}, {3.744991303594208*^9, 3.744991348418972*^9}, 
   3.744993218764442*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "[", 
   RowBox[{"t_", ",", "\[Beta]_", ",", "w0_", ",", "wD_", ",", "q0_", ",", 
    RowBox[{"x0_:", "1"}], ",", 
    RowBox[{"v0_:", "1"}]}], "]"}], "=", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}]}]], "Input",
 CellChangeTimes->{{3.7449904561243773`*^9, 3.744990474676753*^9}, {
  3.744990729393552*^9, 3.744990731100923*^9}, {3.744991053872031*^9, 
  3.744991087620595*^9}, {3.7449913532504168`*^9, 3.744991354898115*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "t", " ", "wD"}]], " ", "q0", " ", "w0"}], 
   "+", 
   RowBox[{"w0", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "q0"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w0", "-", "wD"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"w0", "+", "wD"}], ")"}], " ", "x0"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"t", " ", "w0"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "q0", " ", "wD"}], "+", 
      RowBox[{"v0", " ", 
       RowBox[{"(", 
        RowBox[{"w0", "-", "wD"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"w0", "+", "wD"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"t", " ", "w0"}], "]"}]}]}], 
  RowBox[{"w0", " ", 
   RowBox[{"(", 
    RowBox[{"w0", "-", "wD"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"w0", "+", "wD"}], ")"}]}]]], "Output",
 CellChangeTimes->{3.744990475097888*^9, 3.744990737299165*^9, 
  3.744990774110847*^9, 3.744990823990561*^9, 3.744990867504077*^9, 
  3.7449910896274843`*^9, 3.744991355229239*^9, 3.7449932202582912`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "[", 
  RowBox[{"0.1", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.744991092861339*^9, 3.744991103782505*^9}, {
  3.7449913600377083`*^9, 3.7449913605746326`*^9}}],

Cell[BoxData[
 RowBox[{"5.516124952563901`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.0019870316250017784`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.744991104040742*^9, 3.744991360895192*^9, 
  3.74499322144324*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x1", "[", 
        RowBox[{"t", ",", "\[Beta]", ",", "w0", ",", "wD", ",", "q0"}], "]"}],
        " ", "//", "Re"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "30"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0.1"}], "}"}], ",", "0.01", ",", "5"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w0", ",", "1"}], "}"}], ",", "0.1", ",", "5"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"wD", ",", "3"}], "}"}], ",", "0", ",", "5", ",", "1"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q0", ",", "1"}], "}"}], ",", "0.1", ",", "10"}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.744990328259913*^9, 3.7449904251529408`*^9}, {
  3.744990479103593*^9, 3.7449905521939993`*^9}, {3.744990748724016*^9, 
  3.744990782306324*^9}, {3.744990872537311*^9, 3.744990881127442*^9}, {
  3.744991109769459*^9, 3.7449911893898687`*^9}, {3.7449912210133963`*^9, 
  3.744991221237327*^9}, {3.7449913673897038`*^9, 3.744991397275141*^9}, {
  3.744991429718965*^9, 3.744991429854907*^9}, {3.7449914806786346`*^9, 
  3.7449914939576483`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`q0$$ = 9.36, $CellContext`w0$$ = 
    1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Beta]$$], 0.1}, 0.01, 5}, {{
       Hold[$CellContext`w0$$], 1}, 0.1, 5}, {{
       Hold[$CellContext`wD$$], 3}, 0, 5, 1}, {{
       Hold[$CellContext`q0$$], 1}, 0.1, 10}}, Typeset`size$$ = {
    540., {158., 167.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Beta]$17449$$ = 
    0, $CellContext`w0$17450$$ = 0, $CellContext`wD$17451$$ = 
    0, $CellContext`q0$17452$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`q0$$ = 1, $CellContext`w0$$ = 
        1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Beta]$$, $CellContext`\[Beta]$17449$$, 0], 
        Hold[$CellContext`w0$$, $CellContext`w0$17450$$, 0], 
        Hold[$CellContext`wD$$, $CellContext`wD$17451$$, 0], 
        Hold[$CellContext`q0$$, $CellContext`q0$17452$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Re[
         $CellContext`x1[$CellContext`t, $CellContext`\[Beta]$$, \
$CellContext`w0$$, $CellContext`wD$$, $CellContext`q0$$]], {$CellContext`t, 0,
          30}], "Specifications" :> {{{$CellContext`\[Beta]$$, 0.1}, 0.01, 
         5}, {{$CellContext`w0$$, 1}, 0.1, 5}, {{$CellContext`wD$$, 3}, 0, 5, 
         1}, {{$CellContext`q0$$, 1}, 0.1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{608., {256., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.7449913867446823`*^9, 3.744991397732657*^9}, 
   3.74499143085113*^9, {3.7449914815291986`*^9, 3.7449914945121803`*^9}, 
   3.7449932222279463`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SHO (\[Beta]\[NotEqual]0, q0\[NotEqual]0)", "Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
   3.743445462029182*^9, 3.743445463517805*^9}, {3.744990566090476*^9, 
   3.744990575211726*^9}, {3.744990607318885*^9, 3.744990640417159*^9}, {
   3.744990942071199*^9, 3.744990944406584*^9}, 3.7449912932512083`*^9}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"we", "'"}], "ll", " ", "non"}], "-", 
     RowBox[{"zero", "  ", "damping", " ", "and", " ", "driving"}]}]}], "  ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", " ", 
     RowBox[{
      SuperscriptBox["w0", "2"], 
      RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", 
    RowBox[{"q0", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "wD", " ", "t"}], "]"}], " "}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}, {3.744990158381131*^9, 
   3.744990205705883*^9}, {3.744990653101883*^9, 3.744990653566897*^9}, {
   3.744990951421031*^9, 3.744990952878166*^9}, 3.744991305974234*^9, {
   3.74583566182908*^9, 3.7458356665236387`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"x", "[", "t", "]"}]}], "+", 
   RowBox[{"2", " ", "\[Beta]", " ", 
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "t", " ", "wD"}]], " ", "q0"}]}]], "Output",\

 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, {
   3.744990194282686*^9, 3.74499020652577*^9}, {3.744990654444541*^9, 
   3.744990662373081*^9}, 3.7449908236247473`*^9, 3.744990867179196*^9, 
   3.7449909561881647`*^9, {3.744991300476915*^9, 3.7449913062530117`*^9}, 
   3.74499324594114*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], " ", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "v0"}]}], "}"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}, {3.744990215600648*^9, 
  3.744990230345748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "v0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.7449902318296337`*^9, 3.744990663334693*^9, 3.744990823663898*^9, 
   3.744990867218652*^9, 3.7449909584362097`*^9, {3.744991301347734*^9, 
   3.744991307528304*^9}, 3.744993245992713*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dsol1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "eq1", "}"}], ",", "bc"}], "]"}], " ", ",", 
      RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7434438450525217`*^9, 3.743443848540771*^9}, {
  3.743443929851068*^9, 3.743443958346212*^9}, {3.7444612453179817`*^9, 
  3.74446125297692*^9}, {3.744990237825842*^9, 3.744990262591259*^9}, {
  3.744991314055122*^9, 3.744991314636736*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["w0", "2"]}], "+", 
        RowBox[{"wD", " ", 
         RowBox[{"(", 
          RowBox[{"wD", "-", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], ")"}]}]}], 
       ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["w0", "2"]}], "+", 
        SuperscriptBox["\[Beta]", "2"]}]]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "t"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["w0", "2"]}], "+", 
           SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "q0", " ", "wD"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "t", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["w0", "2"]}], "+", 
              SuperscriptBox["\[Beta]", "2"]}]]}]]}], ")"}], " ", "v0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["w0", "2"], "-", 
          RowBox[{"wD", " ", 
           RowBox[{"(", 
            RowBox[{"wD", "-", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], ")"}]}]}],
          ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"t", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "wD"}], "+", "\[Beta]", "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["w0", "2"]}], "+", 
              SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}]], " ", "q0", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["w0", "2"]}], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"q0", "+", 
          RowBox[{"x0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["w0", "2"]}], "+", 
             RowBox[{"wD", " ", 
              RowBox[{"(", 
               RowBox[{"wD", "-", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], 
               ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[Beta]"}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["w0", "2"]}], "+", 
            SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["w0", "2"]}], "+", 
            SuperscriptBox["\[Beta]", "2"]}]]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "x0"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w0", "2"], "-", 
             RowBox[{"wD", " ", 
              RowBox[{"(", 
               RowBox[{"wD", "-", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], 
               ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["w0", "2"]}], "+", 
               SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}], "+", 
          RowBox[{"q0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[ImaginaryI]", " ", "wD"}], "+", "\[Beta]", "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["w0", "2"]}], "+", 
               SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7434439301576777`*^9, 3.743443958765725*^9}, {
   3.743444029060967*^9, 3.743444033454541*^9}, 3.743445377664802*^9, {
   3.7444611068838797`*^9, 3.744461121785171*^9}, {3.744461246169924*^9, 
   3.7444612531696587`*^9}, 3.744461335336873*^9, 3.744461758287525*^9, 
   3.74498974788309*^9, {3.7449902488218822`*^9, 3.744990262909902*^9}, 
   3.7449906645512447`*^9, 3.744990823830481*^9, 3.744990867362067*^9, 
   3.7449909596878433`*^9, {3.744991302392091*^9, 3.744991322891499*^9}, 
   3.744993253899167*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"v0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"\[Beta]", "\[Rule]", "0.1"}], ",", 
     RowBox[{"w0", "\[Rule]", "1"}], ",", 
     RowBox[{"q0", "\[Rule]", "15.1"}], ",", 
     RowBox[{"wD", "\[Rule]", "3"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}], "  ", "/.", 
     "values"}], " ", "//", "Re"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.744990279392004*^9, 3.744990299725547*^9}, {
  3.7449906928087053`*^9, 3.744990703701223*^9}, {3.744990965986617*^9, 
  3.744991031953169*^9}, {3.744991329469304*^9, 3.7449913476335583`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUWHc4l98b/nw+9sjeK3vv1aDOU1RStCQzpUJIkZAi2eQrK0kyokKyk5Dz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       "]]},
     Annotation[#, "Charting`Private`Tag$23781#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {-3.4444304883699814`, 4.0226037353452275`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7449903182845297`*^9, {3.744990681968917*^9, 3.744990704043785*^9}, 
   3.744990823966943*^9, 3.744990867479929*^9, {3.744990962197866*^9, 
   3.744991032629176*^9}, {3.744991303594208*^9, 3.744991348418972*^9}, 
   3.744993254386581*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "[", 
   RowBox[{"t_", ",", "\[Beta]_", ",", "w0_", ",", "wD_", ",", "q0_", ",", 
    RowBox[{"x0_:", "1"}], ",", 
    RowBox[{"v0_:", "1"}]}], "]"}], "=", 
  RowBox[{
   RowBox[{"x", "[", "t", "]"}], " ", "/.", "dsol1"}]}]], "Input",
 CellChangeTimes->{{3.7449904561243773`*^9, 3.744990474676753*^9}, {
  3.744990729393552*^9, 3.744990731100923*^9}, {3.744991053872031*^9, 
  3.744991087620595*^9}, {3.7449913532504168`*^9, 3.744991354898115*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["w0", "2"]}], "+", 
      RowBox[{"wD", " ", 
       RowBox[{"(", 
        RowBox[{"wD", "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], ")"}]}]}], 
     ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["w0", "2"]}], "+", 
      SuperscriptBox["\[Beta]", "2"]}]]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "t"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["w0", "2"]}], "+", 
         SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "q0", " ", "wD"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["w0", "2"]}], "+", 
            SuperscriptBox["\[Beta]", "2"]}]]}]]}], ")"}], " ", "v0", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["w0", "2"], "-", 
        RowBox[{"wD", " ", 
         RowBox[{"(", 
          RowBox[{"wD", "-", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"t", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "wD"}], "+", "\[Beta]", "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["w0", "2"]}], "+", 
            SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}]], " ", "q0", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["w0", "2"]}], "+", 
        SuperscriptBox["\[Beta]", "2"]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"q0", "+", 
        RowBox[{"x0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["w0", "2"]}], "+", 
           RowBox[{"wD", " ", 
            RowBox[{"(", 
             RowBox[{"wD", "-", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], 
             ")"}]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["w0", "2"]}], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "t", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["w0", "2"]}], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "x0"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["w0", "2"], "-", 
           RowBox[{"wD", " ", 
            RowBox[{"(", 
             RowBox[{"wD", "-", 
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Beta]"}]}], 
             ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["w0", "2"]}], "+", 
             SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}], "+", 
        RowBox[{"q0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "wD"}], "+", "\[Beta]", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["w0", "2"]}], "+", 
             SuperscriptBox["\[Beta]", "2"]}]]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.744990475097888*^9, 3.744990737299165*^9, 
  3.744990774110847*^9, 3.744990823990561*^9, 3.744990867504077*^9, 
  3.7449910896274843`*^9, 3.744991355229239*^9, 3.7449932544183893`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "[", 
  RowBox[{"0.1", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.744991092861339*^9, 3.744991103782505*^9}, {
  3.7449913600377083`*^9, 3.7449913605746326`*^9}}],

Cell[BoxData[
 RowBox[{"5.465371460274477`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.0018914480965342656`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.744991104040742*^9, 3.744991360895192*^9, 
  3.744993254474555*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x1", "[", 
        RowBox[{"t", ",", "\[Beta]", ",", "w0", ",", "wD", ",", "q0"}], "]"}],
        " ", "//", "Re"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "30"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0.1"}], "}"}], ",", "0.01", ",", "5"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w0", ",", "1"}], "}"}], ",", "0.1", ",", "5"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"wD", ",", "3"}], "}"}], ",", "0", ",", "5", ",", "1"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q0", ",", "1"}], "}"}], ",", "0.1", ",", "10"}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.744990328259913*^9, 3.7449904251529408`*^9}, {
  3.744990479103593*^9, 3.7449905521939993`*^9}, {3.744990748724016*^9, 
  3.744990782306324*^9}, {3.744990872537311*^9, 3.744990881127442*^9}, {
  3.744991109769459*^9, 3.7449911893898687`*^9}, {3.7449912210133963`*^9, 
  3.744991221237327*^9}, {3.7449913673897038`*^9, 3.744991397275141*^9}, {
  3.744991429718965*^9, 3.744991429854907*^9}, {3.7449914806786346`*^9, 
  3.7449914939576483`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`q0$$ = 1, $CellContext`w0$$ = 
    1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Beta]$$], 0.1}, 0.01, 5}, {{
       Hold[$CellContext`w0$$], 1}, 0.1, 5}, {{
       Hold[$CellContext`wD$$], 3}, 0, 5, 1}, {{
       Hold[$CellContext`q0$$], 1}, 0.1, 10}}, Typeset`size$$ = {
    540., {154., 162.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Beta]$23808$$ = 
    0, $CellContext`w0$23809$$ = 0, $CellContext`wD$23810$$ = 
    0, $CellContext`q0$23811$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`q0$$ = 1, $CellContext`w0$$ = 
        1, $CellContext`wD$$ = 3, $CellContext`\[Beta]$$ = 0.1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Beta]$$, $CellContext`\[Beta]$23808$$, 0], 
        Hold[$CellContext`w0$$, $CellContext`w0$23809$$, 0], 
        Hold[$CellContext`wD$$, $CellContext`wD$23810$$, 0], 
        Hold[$CellContext`q0$$, $CellContext`q0$23811$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Re[
         $CellContext`x1[$CellContext`t, $CellContext`\[Beta]$$, \
$CellContext`w0$$, $CellContext`wD$$, $CellContext`q0$$]], {$CellContext`t, 0,
          30}], "Specifications" :> {{{$CellContext`\[Beta]$$, 0.1}, 0.01, 
         5}, {{$CellContext`w0$$, 1}, 0.1, 5}, {{$CellContext`wD$$, 3}, 0, 5, 
         1}, {{$CellContext`q0$$, 1}, 0.1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{608., {252., 261.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.7449913867446823`*^9, 3.744991397732657*^9}, 
   3.74499143085113*^9, {3.7449914815291986`*^9, 3.7449914945121803`*^9}, 
   3.744993254529737*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SHO (\[Beta]\[NotEqual]0, q0\[NotEqual]0) Using Sin and Cos", \
"Subsection",
 CellChangeTimes->{{3.743443715306672*^9, 3.743443718322117*^9}, {
   3.743445462029182*^9, 3.743445463517805*^9}, {3.744990566090476*^9, 
   3.744990575211726*^9}, {3.744990607318885*^9, 3.744990640417159*^9}, {
   3.744990942071199*^9, 3.744990944406584*^9}, 3.7449912932512083`*^9, {
   3.745835579740937*^9, 3.745835583790481*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.7444610957261543`*^9, 3.7444611006915617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "start"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "use", " ", "trig", " ", "functions"}]}],
    "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"eq1", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", " ", 
     RowBox[{
      SuperscriptBox["w0", "2"], 
      RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", 
    RowBox[{"q0", " ", 
     RowBox[{"Cos", "[", " ", 
      RowBox[{"wD", " ", "t"}], "]"}], " "}]}]}]}]], "Input",
 CellChangeTimes->{{3.743443728936095*^9, 3.7434437551662493`*^9}, 
   3.743443921836101*^9, {3.744461082211541*^9, 3.744461089636134*^9}, {
   3.744461227921328*^9, 3.744461238145124*^9}, {3.744990158381131*^9, 
   3.744990205705883*^9}, {3.744990653101883*^9, 3.744990653566897*^9}, {
   3.744990951421031*^9, 3.744990952878166*^9}, 3.744991305974234*^9, {
   3.745835683928295*^9, 3.745835692733775*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"x", "[", "t", "]"}]}], "+", 
   RowBox[{"2", " ", "\[Beta]", " ", 
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["x", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{"q0", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"t", " ", "wD"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.743443756038247*^9, 3.743443922408926*^9, 3.743444033273847*^9, 
   3.743445377486005*^9, {3.744461090225333*^9, 3.744461102163734*^9}, 
   3.744461335218676*^9, 3.744461758157773*^9, 3.7449897474890623`*^9, {
   3.744990194282686*^9, 3.74499020652577*^9}, {3.744990654444541*^9, 
   3.744990662373081*^9}, 3.7449908236247473`*^9, 3.744990867179196*^9, 
   3.7449909561881647`*^9, {3.744991300476915*^9, 3.7449913062530117`*^9}, 
   3.74499324594114*^9, 3.745835617919735*^9, 3.7458356974469547`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bc", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], " ", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "v0"}]}], "}"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Boundary", " ", "Conditions"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.743443764062479*^9, 3.743443781471438*^9}, {
  3.744461114018879*^9, 3.74446111897884*^9}, {3.744990215600648*^9, 
  3.744990230345748*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "v0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7434437820102987`*^9, 3.743443924439932*^9, 3.7434440333485813`*^9, 
   3.743445377554842*^9, {3.744461103284567*^9, 3.744461119657797*^9}, 
   3.744461335236535*^9, 3.744461758182847*^9, 3.744989747589705*^9, 
   3.7449902318296337`*^9, 3.744990663334693*^9, 3.744990823663898*^9, 
   3.744990867218652*^9, 3.7449909584362097`*^9, {3.744991301347734*^9, 
   3.744991307528304*^9}, 3.744993245992713*^9, 3.74583561792411*^9, 
   3.7458357061231623`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Guess", " ", "Trig", " ", "Functions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"rule", "=", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{"A", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"wD", " ", "t"}], "]"}]}], " ", "+", " ", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"wD", " ", "t"}], "]"}]}]}]}], ",", "x", ",", "t"}], "]"}], 
    "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7458357902213573`*^9, 3.745835806818399*^9}, {
  3.745835844558503*^9, 3.745835878502915*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ",", 
     RowBox[{
      RowBox[{"A", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"t", " ", "wD"}], "]"}]}], "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"t", " ", "wD"}], "]"}]}]}]}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.745835807587912*^9, {3.745835853219431*^9, 3.745835884979803*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{"eq1", " ", "/.", "rule"}]}]], "Input",
 CellChangeTimes->{{3.745835831482257*^9, 3.745835834487155*^9}, {
  3.7458359789276667`*^9, 3.745835981031632*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "A"}], " ", 
    SuperscriptBox["wD", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"t", " ", "wD"}], "]"}]}], "-", 
   RowBox[{"B", " ", 
    SuperscriptBox["wD", "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"t", " ", "wD"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"t", " ", "wD"}], "]"}]}], "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"t", " ", "wD"}], "]"}]}]}], ")"}]}], "+", 
   RowBox[{"2", " ", "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"B", " ", "wD", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"t", " ", "wD"}], "]"}]}], "-", 
      RowBox[{"A", " ", "wD", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"t", " ", "wD"}], "]"}]}]}], ")"}]}]}], "\[Equal]", 
  RowBox[{"q0", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"t", " ", "wD"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.745835834793989*^9, {3.745835870259871*^9, 3.7458358920371304`*^9}, {
   3.745835981551956*^9, 3.745836002627719*^9}}]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq3a", "=", " ", 
   RowBox[{"eq2", " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "__", "]"}], "\[Rule]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{"Cos", "[", "__", "]"}], "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq3b", "=", " ", 
   RowBox[{"eq2", " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "__", "]"}], "\[Rule]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{"Cos", "[", "__", "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.74583590320395*^9, 3.7458359356888037`*^9}, {
  3.745835984554006*^9, 3.745835994676962*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"eq3a", ",", "eq3b"}], "}"}]], "Input",
 CellChangeTimes->{{3.745836027180995*^9, 3.7458360305647907`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eq3a", ",", "eq3b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"A", ",", "B"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.745836081208556*^9, 3.745836088903768*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"A", "\[Rule]", 
    FractionBox[
     RowBox[{"q0", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["w0", "2"], "-", 
        SuperscriptBox["wD", "2"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["w0", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w0", "2"], " ", 
       SuperscriptBox["wD", "2"]}], "+", 
      SuperscriptBox["wD", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["wD", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], ",", 
   RowBox[{"B", "\[Rule]", 
    FractionBox[
     RowBox[{"2", " ", "q0", " ", "wD", " ", "\[Beta]"}], 
     RowBox[{
      SuperscriptBox["w0", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w0", "2"], " ", 
       SuperscriptBox["wD", "2"]}], "+", 
      SuperscriptBox["wD", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["wD", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.745836082538467*^9, 3.745836089210382*^9}}]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1914, 999},
WindowMargins->{{1, Automatic}, {5, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 176, 2, 96, "Section"],
Cell[CellGroupData[{
Cell[781, 28, 383, 5, 67, "Subsection"],
Cell[1167, 35, 143, 2, 53, "Input"],
Cell[CellGroupData[{
Cell[1335, 41, 1353, 33, 82, "Input"],
Cell[2691, 76, 745, 17, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[3473, 98, 505, 13, 48, "Input"],
Cell[3981, 113, 694, 16, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[4712, 134, 612, 14, 48, "Input"],
Cell[5327, 150, 866, 19, 69, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[6230, 174, 886, 23, 82, "Input"],
Cell[7119, 199, 33102, 557, 339, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[40258, 761, 488, 10, 48, "Input"],
Cell[40749, 773, 441, 11, 69, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[41227, 789, 252, 5, 48, "Input"],
Cell[41482, 796, 136, 2, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[41655, 803, 1548, 39, 280, "Input"],
Cell[43206, 844, 2599, 50, 537, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[45854, 900, 389, 5, 53, "Subsection"],
Cell[46246, 907, 143, 2, 53, "Input"],
Cell[CellGroupData[{
Cell[46414, 913, 1248, 31, 82, "Input"],
Cell[47665, 946, 912, 21, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[48614, 972, 505, 13, 48, "Input"],
Cell[49122, 987, 694, 16, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[49853, 1008, 612, 14, 48, "Input"],
Cell[50468, 1024, 1721, 47, 114, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[52226, 1076, 886, 23, 82, "Input"],
Cell[53115, 1101, 29670, 501, 338, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[82822, 1607, 488, 10, 48, "Input"],
Cell[83313, 1619, 1240, 39, 114, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[84590, 1663, 252, 5, 48, "Input"],
Cell[84845, 1670, 213, 4, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[85095, 1679, 1647, 40, 280, "Input"],
Cell[86745, 1721, 2654, 51, 545, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[89448, 1778, 388, 5, 53, "Subsection"],
Cell[89839, 1785, 143, 2, 53, "Input"],
Cell[CellGroupData[{
Cell[90007, 1791, 1253, 31, 82, "Input"],
Cell[91263, 1824, 882, 20, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[92182, 1849, 505, 13, 48, "Input"],
Cell[92690, 1864, 694, 16, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[93421, 1885, 612, 14, 48, "Input"],
Cell[94036, 1901, 1716, 45, 76, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[95789, 1951, 886, 23, 82, "Input"],
Cell[96678, 1976, 49749, 830, 347, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[146464, 2811, 488, 10, 48, "Input"],
Cell[146955, 2823, 1240, 37, 76, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[148232, 2865, 252, 5, 48, "Input"],
Cell[148487, 2872, 231, 4, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[148755, 2881, 1548, 39, 280, "Input"],
Cell[150306, 2922, 2609, 50, 545, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[152964, 2978, 349, 4, 53, "Subsection"],
Cell[153316, 2984, 143, 2, 53, "Input"],
Cell[CellGroupData[{
Cell[153484, 2990, 1177, 29, 82, "Input"],
Cell[154664, 3021, 998, 24, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[155699, 3050, 505, 13, 48, "Input"],
Cell[156207, 3065, 694, 16, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[156938, 3086, 612, 14, 48, "Input"],
Cell[157553, 3102, 4766, 136, 233, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[162356, 3243, 886, 23, 82, "Input"],
Cell[163245, 3268, 49828, 831, 347, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[213110, 4104, 488, 10, 48, "Input"],
Cell[213601, 4116, 4109, 128, 181, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[217747, 4249, 252, 5, 48, "Input"],
Cell[218002, 4256, 232, 4, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[218271, 4265, 1548, 39, 280, "Input"],
Cell[219822, 4306, 2604, 50, 537, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[222475, 4362, 419, 6, 53, "Subsection"],
Cell[222897, 4370, 143, 2, 53, "Input"],
Cell[CellGroupData[{
Cell[223065, 4376, 1111, 27, 82, "Input"],
Cell[224179, 4405, 1012, 23, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[225228, 4433, 505, 13, 48, "Input"],
Cell[225736, 4448, 743, 17, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[226516, 4470, 722, 21, 82, "Input"],
Cell[227241, 4493, 467, 14, 48, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[227745, 4512, 202, 4, 48, "Input"],
Cell[227950, 4518, 1167, 36, 48, "Output"]
}, Closed]],
Cell[229132, 4557, 727, 22, 82, "Input"],
Cell[229862, 4581, 146, 3, 48, "Input"],
Cell[CellGroupData[{
Cell[230033, 4588, 339, 10, 48, InheritFromParent],
Cell[230375, 4600, 1049, 31, 81, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

