(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     47445,       1053]
NotebookOptionsPosition[     45713,        987]
NotebookOutlinePosition[     46052,       1002]
CellTagsIndexPosition[     46009,        999]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Problem 2", "Section",
 CellChangeTimes->{{3.650951892234829*^9, 3.650951901694723*^9}, {
   3.682779748086904*^9, 3.682779748262773*^9}, 3.6827798312375793`*^9, {
   3.6835562399394703`*^9, 3.683556261234684*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"z", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"r", "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{"w", " ", "L"}], " ", "-", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"w", " ", "c"}], ")"}]}]}], ")"}], "^", "2"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"current", " ", "=", " ", 
  RowBox[{"emf", "/", "z"}]}]}], "Input",
 CellChangeTimes->{{3.682965401488483*^9, 3.682965419532381*^9}, {
  3.683556305332303*^9, 3.683556306578347*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox["r", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"c", " ", "w"}]]}], "+", 
      RowBox[{"L", " ", "w"}]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{3.683556308618742*^9, 3.7458363170825853`*^9}],

Cell[BoxData[
 FractionBox["emf", 
  SqrtBox[
   RowBox[{
    SuperscriptBox["r", "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"c", " ", "w"}]]}], "+", 
       RowBox[{"L", " ", "w"}]}], ")"}], "2"]}]]]], "Output",
 CellChangeTimes->{3.683556308618742*^9, 3.745836317084056*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", " ", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"current", ",", "w"}], "]"}], "\[Equal]", "0"}], ",", "w"}], 
    "]"}], " ", "//", "Last"}]}]], "Input",
 CellChangeTimes->{{3.682965427409717*^9, 3.682965479483162*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"w", "\[Rule]", 
   FractionBox["1", 
    RowBox[{
     SqrtBox["c"], " ", 
     SqrtBox["L"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.682965428675662*^9, 3.682965481764263*^9}, 
   3.683556319203043*^9, 3.745836317257*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"current", " ", "/.", "sol"}], " ", "//", "PowerExpand"}]], "Input",\

 CellChangeTimes->{{3.6829654863554707`*^9, 3.6829655015034227`*^9}}],

Cell[BoxData[
 FractionBox["emf", "r"]], "Output",
 CellChangeTimes->{{3.6829654905313263`*^9, 3.682965501974769*^9}, 
   3.6835563235090733`*^9, 3.745836317347287*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "\[Rule]", "10"}], ",", " ", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{"20", "*", 
       RowBox[{"10", "^", 
        RowBox[{"-", "6"}]}]}]}], ",", " ", 
     RowBox[{"L", "\[Rule]", 
      RowBox[{"200", "*", 
       RowBox[{"10", "^", 
        RowBox[{"-", "3"}]}]}]}], ",", 
     RowBox[{"emf", "\[Rule]", "200"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.682965615813512*^9, 3.6829656672558193`*^9}, {
  3.683556375857353*^9, 3.6835563778231983`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "//.", "values"}]], "Input",
 CellChangeTimes->{{3.683556378728716*^9, 3.683556384863044*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"w", "\[Rule]", "500"}], "}"}]], "Output",
 CellChangeTimes->{{3.683556381189786*^9, 3.6835563850983343`*^9}, 
   3.745836317502349*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"current", " ", "/.", "sol"}], " ", "/.", "values"}]], "Input",
 CellChangeTimes->{{3.6835564679607773`*^9, 3.6835564756929197`*^9}}],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{3.6835564758929577`*^9, 3.745836317592359*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"current", "==", 
       RowBox[{
        RowBox[{"emf", "/", "r"}], "/", "2"}]}], ",", "w"}], "]"}], " ", "/.",
     "values"}], " ", "//", "N"}]}]], "Input",
 CellChangeTimes->{{3.682965510388628*^9, 3.6829655492386713`*^9}, {
  3.682965676983886*^9, 3.682965678135326*^9}, {3.683556364704761*^9, 
  3.683556369855755*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"-", "458.57022730789635`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", "458.57022730789635`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"-", "545.1727676863402`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", "545.1727676863402`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.6829655270637302`*^9, 3.682965549776017*^9}, 
   3.682965678444161*^9, {3.683556350172874*^9, 3.683556387242095*^9}, 
   3.745836317737829*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"Plot", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["20", "2"], ",", "current"}], " ", "}"}], "/.", 
      "values"}], " ", "//", "Evaluate"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "0", ",", "1000"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Green", ",", "Red"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6835563897871323`*^9, 3.68355642129368*^9}, {
  3.6835564515169773`*^9, 3.683556496907251*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/frTHx+3tK92DGCg4iBnren+cYGyA4zvd+3Ih/cL
jOF8h4nN3K4lLnC+4OewDROT/eB8u90VgbUCIXD+guJ9a+9ERML59zzvXvrt
Fgfnp3pXvU06nwjnO+76znI+LwXO597xkEH6YRqcr/3RPc+mIxPOt9opdcCW
KQfOX+8Zr3osPw/O38sl8E+wswDOl9qx7PaGw4VwvlLz78JdEsVwfpwR56T2
9BKE/zR9lxyZXwrn59v65+d8KoPzXWa267ToVcD5R4TqFrG1VsL55QW6i3yu
VsH5C0WFpzDx1yDkb2yzU06uReh/NOH25gV1CPMvKjNx3KiH83fk7Sp4PKUB
zu+UqLtZZdQI5xtcXDDP/S6C/+H3fI1vLU1wfo7XrtUxis2I8Flu3P3jFIJ/
SuNEsk9mC5z/UdqSsYmlFc5/K8v5+80aBH+p85e3/F5tcL5RhZ1txhcEv/rC
4taKye1w/t1ZTydl6XfA+aIlbX8m3kDwOQud4gvLOuH8SzWxcm2KXXD+1l8h
i2pOIvjBc9LltdO64fzjPjd/8An0wPnfFNJOr1qH4Nunn0/S8OqF8+P2TA+7
/QnBtzCtdnab0IdwD2eKjPILBP/WHZ+v/+374XwAed3Upg==
       "]]},
     Annotation[#, "Charting`Private`Tag$376#1"]& ], 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVl3k01d0Xxs1zZjLPmTLELSX0fQxRIpGUBsqcUKZrvpOhkpAMScZCKVMk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       "]]},
     Annotation[#, "Charting`Private`Tag$376#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6835563999660378`*^9, 3.6835564231913147`*^9}, {
   3.683556461354323*^9, 3.6835564971886873`*^9}, 3.745836317894302*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"current", " ", "/.", 
    RowBox[{"{", 
     RowBox[{"r", "\[Rule]", "20"}], "}"}]}], "/.", "sol"}], " ", "/.", 
  "values"}]], "Input",
 CellChangeTimes->{{3.6835564679607773`*^9, 3.6835564756929197`*^9}, {
  3.683556520524044*^9, 3.683556522474847*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.6835564758929577`*^9, 3.6835565227034483`*^9, 
  3.7458363179887257`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["10", "2"], ",", " ", "current"}], "}"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{"r", "\[Rule]", "20"}], "}"}]}], "/.", "values"}], " ", "//", 
     "Evaluate"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "0", ",", "1000"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Purple", ",", "Blue"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6835563897871323`*^9, 3.683556437069713*^9}, {
  3.683556525979238*^9, 3.6835565595160713`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/frTHx+3tK92DGAg4iBnren+cYGyA4zvd+3Ih/cL
jOF8h4nN3K4lLnC+4OewDROT/eB8u90VgbUCIXD+guJ9a+9ERML59zzvXvrt
Fgfnp3pXvU06nwjnO+76znI+LwXO597xkEH6YRqcr/3RPc+mIxPOt9opdcCW
KQfOX+8Zr3osPw/O38sl8E+wswDOl9qx7PaGw4VwvlLz78JdEsVwfpwR56T2
9BKE/zR9lxyZXwrn59v65+d8KoPzXWa267ToVcD5R4TqFrG1VsL55QW6i3yu
VsH5C0WFpzDx1yDkb2yzU06uReh/NOH25gV1CPMvKjNx3KiH83fk7Sp4PKUB
zu+UqLtZZdQI5xtcXDDP/S6C/+H3fI1vLU1wfo7XrtUxis2I8Flu3P3jFIJ/
SuNEsk9mC5z/UdqSsYmlFc5/K8v5+80aBH+p85e3/F5tcL5RhZ1txhcEv/rC
4taKye1w/t1ZTydl6XfA+aIlbX8m3kDwOQud4gvLOuH8SzWxcm2KXXD+1l8h
i2pOIvjBc9LltdO64fzjPjd/8An0wPnfFNJOr1qH4Nunn0/S8OqF8+P2TA+7
/QnBtzCtdnab0IdwD2eKjPILBP/WHZ+v/+374XwARRLRZg==
       "]]},
     Annotation[#, "Charting`Private`Tag$496#1"]& ], 
    TagBox[
     {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVV3k41N//HUsTRrJnkPBOKSIkW3ofWSpri5IWlbVQso9txow1CYlSWStK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       "]]},
     Annotation[#, "Charting`Private`Tag$496#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6835563999660378`*^9, 3.6835564373066397`*^9}, {
   3.683556543124194*^9, 3.6835565600302753`*^9}, 3.745836318138554*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2"}], "]"}]], "Input",
 CellChangeTimes->{{3.6835564385617323`*^9, 3.68355644090947*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/frTHx+3tK92DGCg4iBnren+cYGyA4zvd+3Ih/cL
jOF8h4nN3K4lLnC+4OewDROT/eB8u90VgbUCIXD+guJ9a+9ERML59zzvXvrt
Fgfnp3pXvU06nwjnO+76znI+LwXO597xkEH6YRqcr/3RPc+mIxPOt9opdcCW
KQfOX+8Zr3osPw/O38sl8E+wswDOl9qx7PaGw4VwvlLz78JdEsVwfpwR56T2
9BKE/zR9lxyZXwrn59v65+d8KoPzXWa267ToVcD5R4TqFrG1VsL55QW6i3yu
VsH5C0WFpzDx1yDkb2yzU06uReh/NOH25gV1CPMvKjNx3KiH83fk7Sp4PKUB
zu+UqLtZZdQI5xtcXDDP/S6C/+H3fI1vLU1wfo7XrtUxis2I8Flu3P3jFIJ/
SuNEsk9mC5z/UdqSsYmlFc5/K8v5+80aBH+p85e3/F5tcL5RhZ1txhcEv/rC
4taKye1w/t1ZTydl6XfA+aIlbX8m3kDwOQud4gvLOuH8SzWxcm2KXXD+1l8h
i2pOIvjBc9LltdO64fzjPjd/8An0wPnfFNJOr1qH4Nunn0/S8OqF8+P2TA+7
/QnBtzCtdnab0IdwD2eKjPILBP/WHZ+v/+374XwAed3Upg==
        "]]},
      Annotation[#, "Charting`Private`Tag$376#1"]& ], 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVl3k01d0Xxs1zZjLPmTLELSX0fQxRIpGUBsqcUKZrvpOhkpAMScZCKVMk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        "]]},
      Annotation[#, "Charting`Private`Tag$376#2"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/frTHx+3tK92DGAg4iBnren+cYGyA4zvd+3Ih/cL
jOF8h4nN3K4lLnC+4OewDROT/eB8u90VgbUCIXD+guJ9a+9ERML59zzvXvrt
Fgfnp3pXvU06nwjnO+76znI+LwXO597xkEH6YRqcr/3RPc+mIxPOt9opdcCW
KQfOX+8Zr3osPw/O38sl8E+wswDOl9qx7PaGw4VwvlLz78JdEsVwfpwR56T2
9BKE/zR9lxyZXwrn59v65+d8KoPzXWa267ToVcD5R4TqFrG1VsL55QW6i3yu
VsH5C0WFpzDx1yDkb2yzU06uReh/NOH25gV1CPMvKjNx3KiH83fk7Sp4PKUB
zu+UqLtZZdQI5xtcXDDP/S6C/+H3fI1vLU1wfo7XrtUxis2I8Flu3P3jFIJ/
SuNEsk9mC5z/UdqSsYmlFc5/K8v5+80aBH+p85e3/F5tcL5RhZ1txhcEv/rC
4taKye1w/t1ZTydl6XfA+aIlbX8m3kDwOQud4gvLOuH8SzWxcm2KXXD+1l8h
i2pOIvjBc9LltdO64fzjPjd/8An0wPnfFNJOr1qH4Nunn0/S8OqF8+P2TA+7
/QnBtzCtdnab0IdwD2eKjPILBP/WHZ+v/+374XwARRLRZg==
        "]]},
      Annotation[#, "Charting`Private`Tag$496#1"]& ], 
     TagBox[
      {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVV3k41N//HUsTRrJnkPBOKSIkW3ofWSpri5IWlbVQso9txow1CYlSWStK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        "]]},
      Annotation[#, "Charting`Private`Tag$496#2"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.683556441137867*^9, 3.683556501836533*^9, 
  3.683556562782938*^9, 3.745836318285334*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"current", "==", 
        RowBox[{
         RowBox[{"emf", "/", "r"}], "/", "2"}]}], ",", "w"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{"r", "\[Rule]", "10"}], "}"}]}], "/.", "values"}], " ", "//", 
   "N"}]}]], "Input",
 CellChangeTimes->{{3.682965510388628*^9, 3.6829655492386713`*^9}, {
  3.682965676983886*^9, 3.682965678135326*^9}, {3.683556364704761*^9, 
  3.683556369855755*^9}, {3.6835565831149187`*^9, 3.6835566024405727`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"-", "458.57022730789635`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", "458.57022730789635`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"-", "545.1727676863402`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", "545.1727676863402`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.683556602797039*^9, 3.745836318431904*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"current", "==", 
        RowBox[{
         RowBox[{"emf", "/", "r"}], "/", "2"}]}], ",", "w"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{"r", "\[Rule]", "20"}], "}"}]}], "/.", "values"}], " ", "//", 
   "N"}]}]], "Input",
 CellChangeTimes->{{3.682965510388628*^9, 3.6829655492386713`*^9}, {
  3.682965676983886*^9, 3.682965678135326*^9}, {3.683556364704761*^9, 
  3.683556369855755*^9}, {3.6835565831149187`*^9, 3.683556590010467*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"-", "420.84203787616707`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", "420.84203787616707`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"-", "594.0471186330549`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", "\[Rule]", "594.0471186330549`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.683556590274716*^9, 3.7458363185171556`*^9}]
}, Open  ]],

Cell[BoxData["w"], "Input",
 CellChangeTimes->{3.745836490163116*^9}]
}, Open  ]]
},
WindowSize->{1280, 948},
WindowMargins->{{1, Automatic}, {Automatic, 28}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 220, 3, 65, "Section"],
Cell[CellGroupData[{
Cell[825, 29, 544, 16, 55, "Input"],
Cell[1372, 47, 333, 11, 60, "Output"],
Cell[1708, 60, 363, 12, 78, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2108, 77, 316, 9, 34, "Input"],
Cell[2427, 88, 267, 8, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2731, 101, 174, 4, 32, "Input"],
Cell[2908, 107, 168, 3, 50, "Output"]
}, Open  ]],
Cell[3091, 113, 566, 16, 34, "Input"],
Cell[CellGroupData[{
Cell[3682, 133, 129, 2, 32, "Input"],
Cell[3814, 137, 175, 4, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4026, 146, 167, 3, 32, "Input"],
Cell[4196, 151, 95, 1, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4328, 157, 445, 12, 34, "Input"],
Cell[4776, 171, 593, 16, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5406, 192, 622, 17, 53, "Input"],
Cell[6031, 211, 9598, 174, 232, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15666, 390, 302, 8, 32, "Input"],
Cell[15971, 400, 124, 2, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16132, 407, 719, 20, 53, "Input"],
Cell[16854, 429, 9073, 165, 233, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25964, 599, 149, 3, 34, "Input"],
Cell[26116, 604, 17265, 304, 232, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43418, 913, 585, 15, 34, "Input"],
Cell[44006, 930, 491, 14, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44534, 949, 583, 15, 34, "Input"],
Cell[45120, 966, 493, 14, 34, "Output"]
}, Open  ]],
Cell[45628, 983, 69, 1, 32, "Input"]
}, Open  ]]
}
]
*)

