(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    971236,      18741]
NotebookOptionsPosition[    958304,      18322]
NotebookOutlinePosition[    959260,      18357]
CellTagsIndexPosition[    959187,      18352]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData["$Version"], "Input",
 CellChangeTimes->{{3.539348909750384*^9, 3.53934891070532*^9}}],

Cell[BoxData["\<\"10.4.0 for Linux x86 (64-bit) (February 26, 2016)\"\>"], \
"Output",
 CellChangeTimes->{
  3.539348911010058*^9, {3.592056897373326*^9, 3.592056919195349*^9}, 
   3.592057096214797*^9, 3.684450103502282*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Setup:", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"<<", "\"\<BarCharts`\>\""}], ";", 
   RowBox[{"<<", "\"\<Histograms`\>\""}], ";", 
   RowBox[{"<<", "\"\<PieCharts`\>\""}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.592056913172229*^9, 3.592056915577012*^9}},
 CellTags->"S5.33.1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"colors", "=", 
   RowBox[{"{", 
    RowBox[{
    "Red", ",", "Green", ",", "Blue", ",", "Cyan", ",", "Magenta", ",", 
     "Yellow", ",", "Black"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "colors", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.539348988919309*^9, 3.539349018937498*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", " ", "x"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}], " ", "//", 
    "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "colors"}]}], "]"}]], "Input",
 CellChangeTimes->{3.53934900404324*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxFxXss1AEcAPDDVnlOltPPjOiyYWKcNhWpRNJV7oiaZF7LKFq0rtqadJY8
IlbRaXROJXMnKpXH4eZUdJw7brrunM77cjHHZh7VH77fPz77OMal0RMNSSQS
7Z//n0icGhBMR/hvPll/Nk5FUA9tTjaVFTYSgfBe3x3cCiIc3t/vzX9EJMCC
Z10+BUQGnJ2Vd+MBcQ9OyNARuUQpvK00pOrPfDX8od8rONieB0dlK0a68prg
tIZr7k8XP8ILRUM9BgbtcE9Hd7v4YCeczAwxP6cVwh3GXht1l0VwDUe4brvn
KxxAbn3BqO+F3UWK5m5XMSwNYMy9nuuHU01SJDJPCfxNHtlqUTgIM4Ki1BqN
FN5XmRdZSRmCR9dLpJfuDMPjIWIOuUsO88tUzAHHEZh73yjX5eYPWB9/fibp
swI2DcyhN9go4duW42bqaBVs1uZGGqaNwn7XT691reDs6nzObrYajomg9hmH
jsHvZIklbUu4by/fcOLxL3jXsSR9SaAG9qH6FDdN4KqFgi8c1jis9Q5jEV4T
sPOs+4zBIC6kZErSsybhh1JZPJ0yBesYgmJDIf42wvqo79VpmNOXXTFmNQMv
i6JvWXXio8Xtessrs/DSwAHiroUWTi91EjBbcJs+J0tNzG+YIatbtVvHFy5W
pSpq5+D2WB7L4qQO/iRODVWewt/7u26vD8Pr7LhsWiReLi9vzI/DM8/kqE2Y
uFvABb+tNbgzz9Zo+BXuZC/vqXmD71ylhwc14Fuaj6ewWnC1B7XMaBBXPJ+P
GZThcnMehSPHv8+68I8o8ZaXDqKsabyZ/DM/TIs3ssrpjjq8Nt5aKVjEuRIJ
p2gZrzxclBy7grP5NA/PNfyJg6l+YwP/CxUIhds=
      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJw9xX1MFGQAB2A+tkpRRi5RnNMgclNHOoQ2KvlRkUZGxp2ENUUH4nJS2tIW
1daIzmWgQTA/CB12QmUMjiAlRe+Um6BJB8ed3PDk7vA44Dh54eLACHir+ev+
ePZEZu1T5AQFBASk/uu/X8sZ7NQNpSc+PCdxoPatLFtEHB6ejPAQ89EG/1vw
TMITVaf878JzHes03/o/AN13LfFH/H+JgvzCj7/2X4ZdB0TEYf9n8VhZypnR
sf9vxIWO2I0bl9VxLbYWWHtaChu5HvvqP4w5Mf4bvwFv8e22wEAtN6Dt6nWt
4YVr3Ig9eSnz3/bouQlX58TKmvdaeTeq1frZJU/f5D1ICr/8vbL2FrciptXa
dH2VgdtgSlKO/DTSwe3InbvXaF5r5H343ZJxOfRoF78H5YatDqfTxJ14trIw
ozL6NnfBPltqevfzbj6A/hSDOrzFwgehOWnL64zs4W5UfRV8eOUnd/gwfNnv
uHdfsnIPQpIPKeoX9fIRfBbWP8+xzcYF5l1ZHdCdauejWP/R5pmWKTsfRcXZ
IvVTFQ4+hsz0uPY5m/q4F7+ac0qvTPRxLxJuaYJcx+7xP/HkK7t9pclOPo74
uPiSRpeTj8PmPXJDrernPnjWpakiYl18AiuGY9yBXS4+AX30QeP+/AE+iW9M
5mxF9CB/AKHUlQTpB/kD/JK+8OWED4b4X1C3F5zqW+DmU5hs3fbpgmtuPgV7
idYX9v4w/xsTnc9HfBHq4dPYXxaly2v28Gksao8Kc2be5zNQmmuml87e5zPw
7jiTaz03wmeh3VmnCn1dcImLhtxNvW8ILnE+cdXjtWmCS9QsrapIzRBcotxS
3lCUJbjEwTcPOebmCS6xOmn7+kerBZdYUbckuPtHwSWillnaqn8WXGLxtGLL
hnrBJR5penWvqllwCceauJPBXYJLWE+PZXaZBZewzK+LVlsEl/hjeKXmpV7B
JZp/WN6aPyS4RFP43aI0j+ASDapyRaQQXOJc9sJe3bjgElVGo7p4UnCJyheL
9+ycElyiQpO6Zu2M4BLHl4f4pBRc4h+NTYqr
      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV0vlfzHkAx/Hp0DejeiQMQ6JrVqwrxbJb709ps7HpPpB4RBFttbaotFba
QVSmwq4OXaa1tDUptqVjdCi2u0Zt92S6p77dkY7lh9fj+Q+8NN18bN1lGQyG
5ac+u9+9r1bY72D8/oB3grWPr3FvhqNbB9sAhxWuLKvmHARriSgym22GZB4c
Iziu2LJ7OT+BbY9Sh/sXvDje2FOzQxDNPgmnXEtFF84lCOOKDSPYfkjy5NfY
cSIRGnIz4Ab7V5iZ1uZYce7jpB/NDmPfxt0tvWmWnAwo3rZIHhl9ACXX4dG+
M4X4u0Z/3z6NTISpe/g/dSyDc2hrc/HNHMiX7i/n11bBJ+unzb9P/INlpSyt
cxfqMcZ7Wy4jU4hn0iTHl6QR5S9fFVZ/U4R0rUeJu460wDPQQvmQtAQaO4dj
uG4deLlYfyH9hzLYXHMvNIkWIy21ZH617hvkBS1DQ9w7EFZ+il1GBQQ1ys8L
rnRjc1lr7quN1XC7w2euON6LBmI3/OdwDYzFwd3z7v3wYp6tE22rQ8qtpBfE
YhD/Njnlq0TWY1upnDrLYQh25s5iiaQBwZ7ytk5ONHYm3XRK0nmLDbkPTQLi
RtA5H9Nw+pdGbFjwToxMHEW3RXUqq7gJXhdaZqyjxyC41xFYq9kMs+xTa47e
Gwf/ulyYXlALgtOKOIlxE5g8cXjA40Ur3r8p3hoRPoklZldts1a2QzFbMlcS
NYVg1W4lsUsHjlY8fv2QOw2lgk2MRstOqCWYXC7yew+j81ZzxTOdcNk+/VE3
4APiH4SnaseLMTBl6294ZgauDgaViw90QflyVXak70c8FbnHFEx1gSdc1bb2
3Cx2Vwhke+6+g6P+YvlDbnNY/63HZIyZBIJT7JE2j3kYGhhG5fRIYF1V/Z/K
4QV0jEW8TuV244vzGxv36DCIdIcNl63fg9GeWe0YPoNwBjcPyNT3wMU3xcdE
Q4aU6PjX+Yb0IqalMWF5sgy51SA6YavTh7PHOt8YrZEltJ0wSrakD+PG1kMy
MbLkicOKvbt/7Ic5w3psYLkcSa0MTehSG8CeZq0pvUg5Ml3mclGtaAAf7nBb
I5bKk86owklV70Gc/ssqNzxankzVfs2+oiJFQJs0WsxcRHxvawkD86Swp9nW
RyIWkZWVWqoS1yHUslcrbaIUiJ0ofVZ9fgjziSH5dy4pkLFjyV6tj4YxRQXa
6DIoUng8k6vyPY1b1/dKmIEUeV7tdaD9II2KuKhczkWKPDPeuDTDhoZiZke4
6c8USVfnx1t++iREdNEwKIQisU2x2eFuNPy0cq72h1HE3/qqmBlIwzlPR688
liKbyFEjKo3G+pFF3tw8inAyV8s1PqThImdvmlxAES2NpvK0xzRiWSmsfCFF
Vs3a2ptn0VAzMi6cKKGIQu53Z7l5NORvnFc9WUkR8VaDe3L1NPq1e5+YtlOk
9f6oa72Ihu4uw2uunRRpUs7USW2i4bY/9EhQF0WqBvUEpu00mn3XyT/poUje
H+vKQvppVOY7OWjSFMlltYXbSGkwa/l6RqMUyebG2mrSNMwl43PO4xR5dGJF
u3CChpDJS+NNU4RfV5fKm6Yxu7Y9KP0DRZJMeJ7HZ2h8tf1Lq/KPFIkXWG7d
NkfD3yxIWzJHkd/WLZlcWKCR5VQ+vbBAkf8BwRtcCQ==
      "]]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwtyH9MFGQcx/EDDPn9kEvsnNMgclNHOoQ2Kvl8K9LIqDgkrBk5EJeT0pa0
qLZGdC4DDYJVEjbsgMoYHEFFhXLKTaikg+NOLiPg6Ph1nDxK/GiE0LXv88d7
r+0dmXVEl+Or0WhSvP3v4znjPaaJ9EQ2L3Gs/pmsQW0c2D2ICLafatImKQ/g
3oQ7as54P3sM93dvN37o/ey7MH3aHn/S+9lyFBYUvf6+97PVOHBMak94P9uM
gPLkszduVivN+L47dteu9Q1KC/YW9l9rL2pW2nCk8dWYT2Z+UP6O6ZKrnT4+
bcpBdF683GZ58JJyGIfyk0Of9ZiVLlwMjF2ue6lDOYZag3lp7T2/KN2giPOf
p9VfUXoQ09HfcnmzRSlho7Spr6a6lTeQG3TYat9mVU7jV0fG+bBTvcq/kbZz
r9PlsilncF9VUUZV9FXlHIaWymwvvt2nnMdIssUQ0e5Q/gPj6cH8nshrygXU
vOd3YtMbfyj/xWz2c+6DP/UrFxGcdFzXuGZAuYS3wkdCnPsGlcsIubBF05cy
pNTQjteeutW+MARWQ5XVxYa7K51gfSgzPa4rcPcwWF/61p5TdmFuGKwvJVwx
+o5+9BdYP7rr0YOzZUkusCsoPi6+tHnUBXYFDU6f/NmgHwF7G3m2p+q1saNg
/WnjZIzbp3cUrD+Zo/OsRwvGwK6kD2z2bF30ONgAkmmmUl/zONgA+iZ99SMJ
r0yADSRDV+GZ4VVusEE037HvzVWX3GCDaKi0bTb85UmwwTTX84D2nTAP2BA6
Wh5lym/1gA2hNV1R4a7M62BDKc1et7hu6TrYUJp+4Wxu/7kpsGHUtr9BH/aE
BCvoR0vu7oEnJVhB3yVuvr0+VYIVVLeupjIlQ4IVVOGoaCrOkmAF5T193BmU
L8EK2kLP71hZK8EK2tiw1q/vSwlWUNR6R2ft1xKsoDsXdXt2NkqwgvxbHjus
b5VgBTm3xp3265VgBfV/djOz1y7BCnKENkQbHBKsoN8mNxkfHpBgBbV+saGj
YEKCFdQS8WdxqkeCFdSkr9BFSglW0Lns1QOmGQlWUI3VaiiZl2AFVT1Ucmj/
ggQrqNKYsnXbLQlW0McbgmeXlyVYQf8BNrBhqQ==
      "]]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVjms0lAkYgDEh1/AtNRKTte1JkVw6sZv3rRQS5baT1so9NqWk3ZStxSIi
NJ1EbDToaihqKTEZm+sQY7AltxiM0ec2yE5j7Y/nPP+e82z0D3cLkpORkXFe
4X8fCBprZ4972uZc8lfYHnjRdpT1g38/1RLyj4ps6DQv0FHhXyuj2kGvc3IE
jRYKptZfFeZSPeCCvZe6PC0KbN5alF6nBoJDHXovGCQB+zbHKpUaCaWxlnFT
BlkQF3P1fDL1Dxj2Y+lMGjyAwEiSmkS9Ab+5nvCdMKiE1Tcc86emC0D58+3G
MNMm+Outub29fglE1F5OEUXw4Ehc7zvO1XIwLWC0l7P+gfAnZ01uzVXCiEuI
Xv/OAZhJ72qQla2BTN2EDfm+H6Hh9Zuatu9rwSaiooTSIoDQKEc1L1EdcLpv
Hw7/VgivlcyXH5+sh+0pUtt1jpNQxKyT6n7TBA4Cm34z+hSgzqu77qwWGDN5
vm9ONA0m9b0Vb4zbIFqSZFF1YRY60f3Tg09vQUlzLNTDWAxhyic6+GYdoMiV
t1d5NQ/NPfRX6td4IG0tDrt+ZhHc9x8ZHB7uhDE6i6qvvwQ78q7S84y6wO7K
qZMNxf/CgJTRGXK5G25JK5T2HvsCI45tTB1OD/jocQ72zkqhNKs/qn3jO1Bn
bxEZespg4RVK0uYL7+G41V2x11ZZFAccFQa/7IWoS+fdaGJZVLFLcHuytg8S
hQxea6scRmuMqA5694OL8Zr7qtkUVK3eItPtPABpxTvYB/1W4a5fDn3hLA1A
iztTEmktjzkFKcyvcwaBww1P2UpRQB9PS66S0xA8/zkGWz4o4DN+EKN6fggM
nWDnqXJFtG4plRPc/Aj2y95xd6JXI21fsJhhNwwhXTUzFZ5KaGVplVEuGIY9
MbHP/GjK2D+T2siMH4HM8OmXqqPKKLJwjaeaC2D090LBnWoV3DRhIpTlCWAq
qDKwNlEV64zOdZyOGQXxSS1Frp8apnXyA9yMxqDMsVkSbKKOpDs7Q65uDCZC
zHZQxOr41FN7r/WZcdB/9I6RyF2DTG5c7pCWEBJ8I+5ynTRwod77olatEJYk
1FSnSg0cyKgRa5yagK0vM7OajDRxvv07aqy6CGwC/j6kmaSJp28YsqOqRPAm
R3tdi1gT13INNYZ9JsGUrZ3s8qMWuvMfS/Skk+AhL9rQUa2FM8fyw3offoKF
98OcRmMCa3xL4tUPkvBrTiqRlEbgi7Ywpz4XEjpljcgDGQQ+tzXWZLmSYH78
RZMqg8DHeoU5znQSRNtHY9JvEpjdk12W4k+Cbz1OZeYSeO5wwqByFAmOM7Mt
RY8I3II/7VIsImG9w9GEunoCN5XoUrrvk3C+eMovoZFAQ/2ehqJHJPC1Enc5
NBO4TuLmsf8JCWkfyuaaWwlUqHA4EV9FwqqzagE8PoGD2yyzKDwSJnPZMPSR
wN4/p314fBIOUOjrC0YI7FErMWL2kHAvZHI+aJTA1onNpXv6SPCz0GWNCwms
umdQHzNOQlfDWb3paQIrdD6kuIpIsDBVXnw6S2BZfLbbRpKEdEYeL1JM4MMA
7T723Erfh5u8uEhgYUcHM31hpc8JCH6xRGDe7vRQ36WVv81Lu6MlBOaUOm8z
+0KC/7X0DbZSAjMNVMTLyyRUz276vLxM4H8qRV70
      "]]}, 
    {RGBColor[1, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV0vk/1HkcwPFxFMaxzvk2JeWaTW2XqK1d3m+yWrXWOEcl9VCUstiWQrZN
diqFhql2c+RqbFvWEbW2HJMjamlcEyvG0bgnnxA6MLU/vB7Pf+Bl7Bfi5q9I
o9GcP/W/O/2Hm4UjnrZvdwWns0PO2A7le/n1MK1gz+KzeiKWLzDUxYnFTAfI
4oFXAisY1m3VF6QzPaDW88bJINZp2Na0qTCZeQg4pc6qPqxEEKZWWycwwyAz
UNDkzroBsTGXIi4yfwUH++YSF1Y+HAojzDjmFbi2bijXmVUBqlecsl5P3AQN
3/GJ4aMi+LvJcscOowKIMwwIv+fVDt6xXZ3Vl0pAuXZnvaBZAiFFP639/c0/
oFfLMDl+8iVM8p7XKyhUwn1ZptcjHIL6R48rRV9XQZ7J7Ywte8cgMNJJc7es
Bow2j/O5fgQeqVnK836oA9fz/pV2yROQm1OzsNT8KZRF6UFb6hQgozzbPb8B
Cps0H1ScnYa1dV2lj1eLwO+qgG5wYBba0H38z/EmsO2LHljwfwdB9GMt4g0t
kH058yE6fYB/OzjlWomtsKFWyZDhOQ/ujt59UmkbRAcqu3E4cticeYmTafYc
VpXesotIpWHvAr/tyC/tsEoenJGYoYADTqIcRnUHBJ188Z6drIiF13sim407
waH48LJ915VQcEEpziLqBUTnVrEyUpVx+uCe0YCHXfD2afX6hPhFqO5wzq2I
koBqsXS+JmkxRmsPaPT59MC+hjtPbnFVUKNiDa3duRd00+3OVIWpos0Jl/nq
973gs3H2g3mEGqbdjM8xTeuD0Rm3cOujdPT1tGpU29UPmmeeFSeGquM9sT+/
YqYfeMIl3cuPa+DWhkLFwWsvwctSTXm3nyau/CZgmu8ghcLDzNfdAVpobWWd
VDIoBfYz0X9aez7DnsmEJzncAfj8xOr2bWbaKNvkymVaDsLE4JwpX6CNrLG1
owqtg+ATmh1iZ6SDNWbhLaExQ8B/0Z6un6WDl9vEB93MhuHY/t6nNst0kbgL
kxRrhmHKlv1Kga+Ldz0Ntm/9cQQcaezJUX09zGmMTe/XHYVtnSYzFol6OFvn
c0q3ahTeXeV2JejoY29S5bR28Bgc+culND5ZH2eav2Ke1ZJBRLcsuY9ugKFX
TISRZTLwIEz23gQDpBpNtKW+r6CZuVRjjQoD3cV5c4YLr2AhI6b86mkGTu7P
Cuq6PQ4zKpGu5jQKKw8UcLW+I3D5wnYpPZLCB6KgXZLvCTSkJpWyTlF433a1
Tr4rAdWCnnj7nynMMxSkOXMIxIhPWUfFUJjSkVIc/+nbMJOScyNxFIazz/XR
Iwl4l5lZ1KdQuAb32ajkElj5elEwt4xCVsFSpfZbBHyUPOyzKig0Meqoz71D
IIWRzSgXUrhkzs3DsYiAro1t5ZsaCheXfnuMW0ZA+eIJ7UONFPatt7qu1Epg
xHTorr2Ewq4bE76tYgLmW6zP+/ZS2KFZYJbTQcBvZ+zeqH4Kn41ZFNpLCHSG
rlC+O0hh2R8r6mJGCDSWczyNCYWljO54VxkBerPAwmaCwmJuipsxIeAonZr3
nqLw9kEDifANASGdl8ubpVDQ0pLDmyUwt1wSlfeOwkw7XuCB9wS+3PiFS/0H
CtMKnddvmCcQ7hBlKp2n8LcV6tNyOYEiTv2sXE7hR8RNUOk=
      "]]}, 
    {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVxXk41HkcAGBHlzPkmvlJkhWFDvSsxOejFEJlhhxpEmnXQ4eHLKotWaKc
q6aSWrODIg9mtChkxMa2WecwW64RcuUby1SK2d0/3uddH3iGESwnIyPj/p//
3x881i4Y97Ln+DyqTDKLt39XcjhwgGYFin8rRXHZx0FbSZhWTnOE8pAFvYvs
cLCw0cy/R/OEVfzwDyHsONjZZln2M+0EWB429wtgZ4LgboN1Ki0SnE2U0o+w
ORAfdz36Gu0nYKrHmvqyeXAiktCSaTdAlMCTeLPrYdUNF86HmTy4etwglc/s
gMq27U5O+qWQG+XG+nHnG/CJ733dcP0xvJ+9fMx1QQxneBHmt+eegIPt7xuX
V4zCbEZ3s6xsHXQ9q04XG0xCc/2LutZdz0G/82566ASBkBgXFd+pRti1P3ey
5cAs1CtslxafaoLkZtdjHy/NQQG3cYn+zUvYtnrq/g+DEkDt2l+ZJa8gOiLY
Iln3M5g39Va92NQKThb14lN7v0AXMqcLp9sggqd+vJCzCGGKoR3CrR1gx7Dd
GiWUwp8i71rVtE7g9xWPuOnJInOfj3h4uAuS7cz3OjvL4Y7c6965Rt2wxSzb
TTlAHgeXsrq+v9QDyy7JPj2fvgxHXFq52g0ieBjg1VpetBzL7gzEtK9/DbEF
3P23+lZgfpJ8smnsG8jQees9rLgK54P8Jk5W90KUzmqVhQ0KqOSYyODp9MO1
89Ym1Z6KeEFtRFnsPwBhp50nHcOVUPnZZpke90G4meKG3yYpo13UwcWGhUGY
VHX90l2hgjl5KdwNOWJQN9jBsm9XRZaXVYuC6xDwX6ZmPZRVw9+EwVnPJEOw
RP8sGL2lhjavyuRG2W+Bz/fbrWCkjgZ7T85nOQ7DhQtPomRr1NHayjrz8egw
lKSqSvtcNHBgNvUPbsIIxFv5HyJdGjhl6ZFA2z4Kp1UeeHaHrkHjSfMJ2c5R
qDcfK+Z8WoONRuc6zsa9A7PLxlW7MzUxvUsYxDAag0XaEZ3mdVpImIJMucYx
CHdJgiuPtJDvpbXHJnwcvhbx6Rp7tJHbEn9vSGMCCLPTJbFNGz82+Z/XeD4B
nyxmNreF6OBgZt282ulJyPtlZc8BGV2UtNvSrqhOQaW3ZjcvRRfP3jAUxNRM
wZCDftKEEQ11WgzVhlnvITJCP21lOQ2ZwuKvekvvoXCnzlFfezrOHuOE9RZN
w5ylysBlIR3rAkoTVN0IPIj8/DglkMKnrWGu/QcINFhL4+SCKayw36Re4kFg
QLLsYPR3FBbr5ee4exPQjlEbDwqjMFuUXZ4SSODqxY1rbaMoPHcoUawYQ+Bk
olfCeDKFm/Go3coCAsa3eV77eBQal9Llex4ScPCtNKwpp9BQX9Rc8IgAi15L
tlVQqPuV4bmPR+BmTnPy2moKV1Q5hybUEFjOGaida6RQvMXqjnwngZFCFWOu
iMLe+zOsTiEBmdA1/+i+oVCkUmrEFRFYa0YTpPVR+NekadnufgKeJUZ+sUMU
1jxY1xQ3TqCRb5vmMUVhlXZfiscUAXGEw5GmaQrLE7IZ6wmBRSsnE7sZCouC
tPoFcwSsKxnPTSQU5nd0cDM+EjgU7ZN+/xOFuQ4ZIQELBMJsWP6aXyjMKXPf
snWRQNJCkOm1RQpvrVOal0oJ5FWHSKRSCv8FsR1NYg==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {0., 6.999999857142857}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.539349006579371*^9, 3.539349015930273*^9}, {
   3.592056899069939*^9, 3.592056923076399*^9}, 3.592057096628575*^9, 
   3.653994552005143*^9, 3.6539947209853983`*^9, 3.654948464552854*^9, 
   3.684450103857827*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 1:", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Plot the sample function:", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=x /; x <= N[Pi];
f[x_]:=0 /; x >= N[Pi];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539348926308318*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0HswGwYcwPFIlHiVoMmcV6JEl5YrS806VVF0aowsK1WvqnazLUI4rh5n
WtXuZkTqlGs9SjEaz05tmlKWtHUzyx6mRdo0pS2NO1cqXahsu5vf73f3u+99
/vvdj5Es4J4gEgiEgn/3v5KGTMef7Cny3yydSmc6XUjcv9lXSlHEA7EAquKM
qm+IC6ETmXOSZnE5VFG6TKkV10PDa3Jl1eIuaKnzYG2VeAi6oDXSczIVUN83
FZHX0+9DRx/GnCFuV0EDAnlrLcmz0Nj00KW+I8+hgwzW6dvNGiivmtWkTFuC
2m+5dUB08iX03Dvy3tvnV6DBBw8ltZSsQuVfrzCLc19DF761lT6q1kGP5fSU
L4nXoQUuMq/C/g2o50bBKjGVELDZu/Exy/QUA6hXHX+yIIsIDYoaju0TkqA7
5z6S7ywxhAqtMvzqKrdAj3cquC9ERlCmxxeROY3GUI3o4UJWC7Z3JeqssB27
T+o7wO/F8sKMXFNGsEWpV7SRauxM82Qdy4UMbTQJe28HE/sZf/APNxZ2md1M
ZnhjTWVCIS0Q66u2CDFMxl5wClpUXsHeGJvPuduMncotJ/a0YemTU7TiHqyk
PCOQNYy9Q6i/mK3CzncGuSTNYs3jFyShz7Ef/7hnxGEJq8oY04zosSS6MEdC
MoEyx2nEKmMsn3WclmqJFd0nN3JtsN+XdO7yo2En2bx+N3usTv03x9IZ61hR
P/baxSSA8P8E7A+OVjPRKYsLj39moc9dEn3Z54luD/XR1nmjx7XTRed90LY8
94tH/dHvEn9hBAeiY7uFEs8QdIP54LBBBNpDztO0xqMjM3XZFcfQWYwGg7wT
6IGCF9QIPjrE5zRnJR+d1NpVFXAZbcR56VDYgO6YYjfduorWWQx07e1AV2bJ
7rEH0fc4D3Q7VOjdM8REiqspmEA57K6+hg5d3Bud0GYGTmmPTbOTmoMfb5iL
FaMWeN+dN7xk+Vawnv+23vsvS/yHLNRV8LkVOMrxg18Dn6GlT58s9qVRwHnz
TnHURXRTnHYfNdsaTDcRCEir6AiD3a1pmTbgudQy7qk1tMKsNDwj1xbs5uQu
JRtuA7PyzbycvkEX25S/optQwQftuz1+qkAnxKX3cSk0MHP+1IGkMnT0U3qw
BfUtsNLh06rWSvRhN7+5mSq0woPCtq5Bj/jf/C2/Fv1dkqUFtwUtvNp/Zr0f
bbyLnBE1jf6KrRwqUaJ1fr1bpY/QmvA4CXMW/bug+9maBn35ekxCywZ6m9Sj
Y5pgBy6TEdetSOiiCUlNnjH6pJYwEWmFVukntpdYo4+Qrwlv2qI/tPvEimmH
ljNYiUft0f4sfYfIEf2D95/rcme01/ttYWsM9D+1IW2i
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 3.140165820539889}}, {{0, 6.283185307179586}, {0., 
     3.140165820539889}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.539348926652747*^9, 3.539349023983239*^9, {3.592056899236961*^9, 
   3.592056930923074*^9}, 3.592057096786184*^9, {3.6539945553910418`*^9, 
   3.653994564214849*^9}, {3.653994602476725*^9, 3.653994613306777*^9}, 
   3.654948387490789*^9, 3.654948471686008*^9, 3.6549485069281273`*^9, 
   3.684450107282751*^9}]
}, Closed]],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["c[0]= 1/(2 Pi) Integrate[ x  ,{x,0,1 Pi}]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{
  3.539348898608249*^9, 3.539349024083955*^9, 3.592056900043282*^9, 
   3.592056931073666*^9, 3.592057096800711*^9, {3.6539945554408913`*^9, 
   3.6539945642812357`*^9}, {3.6539946025558243`*^9, 3.653994613374568*^9}, 
   3.654948390510152*^9, 3.654948474194743*^9, 3.654948511022745*^9, 
   3.684450107393661*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
c[m_]= 1/(2 Pi) Integrate[ x Exp[- I m x] ,{x,0,1 Pi}] //FullSimplify\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "\[Pi]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348899882002*^9, 3.539349024467109*^9, 3.592056900477057*^9, 
   3.592056931261525*^9, 3.592057097008535*^9, {3.653994555571148*^9, 
   3.653994564408968*^9}, {3.6539946026898823`*^9, 3.6539946135026283`*^9}, 
   3.654948392881493*^9, 3.6549484760088367`*^9, 3.6549485135191097`*^9, 
   3.68445010812355*^9}]
}, Closed]],

Cell["term[0]= c[0];", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["term[m_]= c[m] Exp[I m x] + c[-m]  Exp[-I m x]  //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "\[Pi]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348900096125*^9, 3.539349024623434*^9, 3.592056900596742*^9, 
   3.592056931376429*^9, 3.592057097120233*^9, {3.653994555646126*^9, 
   3.653994564481369*^9}, {3.653994602805489*^9, 3.6539946136003237`*^9}, 
   3.6549484779031267`*^9, 3.654948518518489*^9, 3.68445010841434*^9}]
}, Closed]],

Cell["series[n_]:= Sum[ term[m] ,{m,0,n}]", "Input",
 CellChangeTimes->{{3.6549485336493683`*^9, 3.654948534968346*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"series", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{{3.654948537062978*^9, 3.654948544343122*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox["\[Pi]", "4"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{3.654948544832046*^9, 3.684450108517291*^9}]
}, Closed]],

Cell["Plot the series with different numbers of terms", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Plot[ Join[{f[x]},Table[series[i],{i,2,5,1}] ] //Evaluate
  ,{x,0,2 Pi},PlotStyle->colors]\
\>", "Input",
 CellChangeTimes->{3.653994609851053*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxF0HswGwYcwPFIlHiVoMmcV6JEl5YrS806VVF0aowsK1WvqnazLUI4rh5n
WtXuZkTqlGs9SjEaz05tmlKWtHUzyx6mRdo0pS2NO1cqXahsu5vf73f3u+99
/vvdj5Es4J4gEgiEgn/3v5KGTMef7Cny3yydSmc6XUjcv9lXSlHEA7EAquKM
qm+IC6ETmXOSZnE5VFG6TKkV10PDa3Jl1eIuaKnzYG2VeAi6oDXSczIVUN83
FZHX0+9DRx/GnCFuV0EDAnlrLcmz0Nj00KW+I8+hgwzW6dvNGiivmtWkTFuC
2m+5dUB08iX03Dvy3tvnV6DBBw8ltZSsQuVfrzCLc19DF761lT6q1kGP5fSU
L4nXoQUuMq/C/g2o50bBKjGVELDZu/Exy/QUA6hXHX+yIIsIDYoaju0TkqA7
5z6S7ywxhAqtMvzqKrdAj3cquC9ERlCmxxeROY3GUI3o4UJWC7Z3JeqssB27
T+o7wO/F8sKMXFNGsEWpV7SRauxM82Qdy4UMbTQJe28HE/sZf/APNxZ2md1M
ZnhjTWVCIS0Q66u2CDFMxl5wClpUXsHeGJvPuduMncotJ/a0YemTU7TiHqyk
PCOQNYy9Q6i/mK3CzncGuSTNYs3jFyShz7Ef/7hnxGEJq8oY04zosSS6MEdC
MoEyx2nEKmMsn3WclmqJFd0nN3JtsN+XdO7yo2En2bx+N3usTv03x9IZ61hR
P/baxSSA8P8E7A+OVjPRKYsLj39moc9dEn3Z54luD/XR1nmjx7XTRed90LY8
94tH/dHvEn9hBAeiY7uFEs8QdIP54LBBBNpDztO0xqMjM3XZFcfQWYwGg7wT
6IGCF9QIPjrE5zRnJR+d1NpVFXAZbcR56VDYgO6YYjfduorWWQx07e1AV2bJ
7rEH0fc4D3Q7VOjdM8REiqspmEA57K6+hg5d3Bud0GYGTmmPTbOTmoMfb5iL
FaMWeN+dN7xk+Vawnv+23vsvS/yHLNRV8LkVOMrxg18Dn6GlT58s9qVRwHnz
TnHURXRTnHYfNdsaTDcRCEir6AiD3a1pmTbgudQy7qk1tMKsNDwj1xbs5uQu
JRtuA7PyzbycvkEX25S/optQwQftuz1+qkAnxKX3cSk0MHP+1IGkMnT0U3qw
BfUtsNLh06rWSvRhN7+5mSq0woPCtq5Bj/jf/C2/Fv1dkqUFtwUtvNp/Zr0f
bbyLnBE1jf6KrRwqUaJ1fr1bpY/QmvA4CXMW/bug+9maBn35ekxCywZ6m9Sj
Y5pgBy6TEdetSOiiCUlNnjH6pJYwEWmFVukntpdYo4+Qrwlv2qI/tPvEimmH
ljNYiUft0f4sfYfIEf2D95/rcme01/ttYWsM9D+1IW2i
      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwtmnk81N/3x2dBZJ3BzCiVhCRt0k73hEQJ2fctCUlIm/ogRSpJEkmhlH3N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      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVV3k8lN8XHrPIbhhmRkVSlkrJ8o2K7gklJVtIkiQhJWUPlUqiBRWhiCIk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      "]]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwtW2k4lO/btswM2WcMhiRpR2VJlOW6kiRJUZY2SVKJkpBKJUklSRIpSchO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      "]]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVV3k81F8Xto19mDHGECEhhRYqhbqnhYRsSSpJKsoPlSxtCklItkRKJQnJ
mt3ItYckJDvJli1b9vX9vn/N5/mce8/ynOecud8N1ldNLrGxsLAUsbOw/P+X
HfPW9u7y3M9b/j700UgikhaRlpd8eg45v7F7FTr4Ec10Bhu0hl5FXve2cfoO
JKHuA1U92aH3UfZamdvG/hT080Z/0vvQILSWt83zjGs6qgv4R30V+gZd8zoU
Tw7JQscib5c9D01FlUatG6dIhShAqvBVeChGWtsO2DaVfEHaX1/uKCIXIS+/
uQf2gpWowsdceJdJEfKY1g1gs6hEX1bqWyXbi1BYR/La5plKVDlSdnFqtBhV
x6qt19lUjaq/JN6OpJShx//J2v7wq0Hf7rvG/TlZiQ6+Gip6FF2Hhuc41w7c
qEP37uw15dn4E61tPFam9rQO3U3Ws9U79BMJGz31U86oQ52Di5EuF34ilCAl
LPavDhnm6t3zfPcThZnv2TzhVI/MT+ywvi7ThPbnXTn+2qkBCb94ru8j3oxC
btfEL15vRG8Y8YdsF1pQXJyQw0RII+IYFnxoJtKKChrMVQbSG9Hrtljxzaqt
aGBLf0H9ZCMK/1O46mbfitTbV+oTrv9Er4ufduZ3tqI+jW3LZtebkPNgB8vX
/Da0ZyXEKONaC4qe3PiW41wHUr9rF8Ed3ILsZYM4frh1II2lg11nU1uQXkx7
+8PgDrR/4d9/3GMtyGCqaEdkcQc6NHPi0dn/WlHsq4LKmzKdyOCvWCGXTRuy
e7jydMevTnSp862ixZkOVBZs2nxV6xeq6jJ/wLaxG33e6p1T8qcbmdXsobPu
7Eakm2x3N051o7480fi1w91IyGXN/M5yN2J51lK9bNON+FZ8N1Cpv9EePXOh
ucRuZGLPvNK29zeKyzn5dkTlNypbPiVP9f+NvIPNcOPBHnR0arjviXwPgoOm
S3HWfSiCX44eb9GL5kUU1B449aHjNzdX/rrUi9JHlpzOefWhn3XmLuuv9iKZ
Z++GGTF9yPOytF+CZy9iH5xq9f3dh3z6taXY43tRxZOQXDurftSSXcczO9WL
jrXWumy1HEAXv33IUgrpQ5wpMem8jgPI8UeS4KWXfajQy/XvgPsAUpGr8kx4
34e2KkleevNqAD2sqL1knN+HKPcdTCmdA2gsT3/j9r4+1CjLrzp15g/qlrIB
HfV+dPra0YmsU4Mo0c9Lk2eyH0n/C143YDeIzOKdbs6v9KN+l5bDIncH0RPS
7ppF3gF07Y5tpOvrQfRXpcphr9wA8vF5eFCtdxCpiZw9/e70AMqIKg7LtR9C
uqH6/ceqBhB/1d69zPvD6LbE5d3L2X9Qg57nhZHgYfQJmwhHVvxBEbWVT8Rj
hlGYTf7FY01/kEzjyZ47ZcPIdEI2b3nmD9rzy+WxJs8IClZ96n9z9yC6NJPe
+Tl0BAXamgnPMAdR4YYtXkXvR1EftW75VOsQWvym7hCdPYpsr/99+nFkCO26
rWfu8WUU6apWCNNXh1BSg/1WGBpFP5OKK7dtHEYvH6S2YaW/yMYgwPOB4zC6
2b9TFWf8RfqRH7teEXFVP6C+z8VjaLZNZPdB41Fk+nzLu07HCaTfz7zWJT2O
uHqSHApcJ1C/Zix9bfc4ylfctuflvQmktDcsd+uxcSSNVb+ZB06g691KJ/Jv
jaO//ZpzP5InkENVg9m9H+PIR9VQr3p0AnnKS6VVHZ5AubU3/mXbTaK55ktl
pmsTSJz0+VCwzRRyl3MN9/KYQo9Uyz8V+U4jKbWnbZoFM6jpyJ2jucHT6MhD
J+GELzNI1mJHd+rzabTLBL/m+zGDSrxfkd8kTKMTkU+3M4dm0OpPl8vuldMo
dJenfJ7ILHK9KS+pzj2Drv797zfj6iyy+fzIL+PRDJrn0w2IF51DWfX7pD8G
zaDLGtsMBmXmEMfAv+yYiBlUpV+zUVJ5DsUIWPWFxM+gV1NPP10+MIe6zu1B
14g8hk8Ec7tdmUNmbEPTSlyzSNpyqMkmZw5pHdG1ivOZRRXr3tcK684jw4mL
zS6Bs6ibe35PvMk8OhV530ArfBapnzwsqHxmHjmMZGr2vZ9F69tYfwjZz6Nn
QVJiMuWzSFC4KUjryTzqb56uf8U+h0yZDfno2zwa9xA86sA3hxpyJo9z/JxH
C5u3FGnS5tAR7gs1zI55RL57LqWdqOO7+ewh9tF5tEu62l/s4BwaWbtX+I9n
AT28/ObQM485dL3qeODJQwsoiJqff9F3DumLVEvo6C6gyPzGHTuD51CU5g0z
ReMFlMzPK/3jzRy6UNFTXWW5gH6mOS9T8BzSbNessrm1gOQWjmYFrMyh5B9h
zTJJC6jcb1re+/Y8yjjq71TGtYiaeI4+W/GaRzXM6JYH5EU04PeK3e3xPFp6
vmaxk7aIuP21u69EzaOn632WL0suIl3/55GGhcT93AIzmZ2LqNZfk1+cbQE1
XMmQ7rdYRF28IbfDeBdQatpH98Lzi2jcv3+QTFtA3Ht3b/S3WUSUx4HlLLIL
iJxLip2/uoiOP+6+N6C1gEovr4nv8lpELY+9J9P9FpBA7KTLwdhFNMjXek4x
dAE1B1bI6icsooXHyrWxLxbQv7y10qNJi2hdQFNixMcFJMW7dmxD5iKyCFC4
6P5tAdE+bGbTKl1EvwNqmnSoRNyv58fv/FpEU/wbtErEFtG8WeefHz2LiO2J
S4aGzCJaeXD174aBRST7RDJ4q+oiWtzbkxU9uohsnlw7KnxiEVVtqrZXXlhE
w0+EC349X0Q5f6wgjrKEglkvrH2JXkTAv77uAG0J7XZJP5hG5EkO8uhvoi8h
LwuDKo/cRbR+7tHWsXVLSEzRt2lDyyLiUFqU/Sm7hHQqlyYuMJaQsbXMt1i1
JRTH1is3+GwJuX/g2GJ+egnpu+64UvdqCWXWZRk4WCyhqaH7Sbnvl9Aunwv1
HpZLaH+9hKpf1hK66af3/J31Evr5xgy2/FxC7bkmVR12S4hjX/Vpe+FlNL/1
B9+hO0vovFt60EToMoJXPTyChF+Bkr3VXi+XUVS44XenN0son7+Egx67jCLc
N1Da3y4hoZiGW3uzlpGBltpAXtwSKqv5d8GreRmxFUoI56QtIQWZ3XuEJVZQ
XOLj/u7yJdRoX+gUJ7uC0rYZdcZVLiHPHO3kPcoryDokvcn56xJq0z8pc3b/
Cnqc/yl5c/0SCnC7yR9ntYLu+tuxrXQsofGa/G619ysoxlrG5/bsEopiHBKv
Tl5B6xz5HrQtEHxZfz1hkb2CRModxrVWllD0XHu1x5cVRJlkH0Ucy8hEZiWz
amgF+Txv3VchtIyy3ZDfma2raOJwUslRlWVkXfKl9O/uVWIv1avf2r2MBMlG
q/fRKsrbqHUmR30ZXY6xuhFrtIomDUxPWR1aRuu+eZ7967SKbA5sfmZ3Yhm5
y5TtuJ+zihaPftLwu7uM+ljT9YfwKuo6a0p+67mM9H+/sj1euYo+CDO+VvkQ
96PdXm1qXUUucX+SDUKWUe56RZ66xVV0+ayl45b4ZTQtGtotvX8NLWdnX9Br
WkYW8/eW/LXXEMPo+HbvjmVU2vyfyIzBGjrtJHmormcZhYZr6VedW0NRusXF
MePLaLvwQs51zzXUoyaQtZN3BdkLWgWVlK2hVg/yiU2HVlDjmH6i0jfivP2g
+jvdFaRRu7c8/OcaCq831NppsoJ4n9CW7AbWUG2rvVL4+RVk+vBCBg8HC+jz
W/ad8VxBU2wMqU9yLNBsvpnKVr6Ctq66z7JdYQGjrbh+x9lVlGR73XHcngUu
vnPLL7dZRYr1Fwfar7EAbxsZO1xbRQqxek2ZN1ngrey84uKDVbRBVyzbxpcF
lI85DHIkrSLh8EyX6ngWEDk18bVnjeBVeWQ6ZIAFwtJ+/UrMXkM3I7rs7w2z
wM0UrUVcsobmWBr67MZYwHVPQOJg7Rqa/pHbeGiWBTLW94U7/1lDf2/5ZM6Q
WEHVV+JBPj8LdJdvcD4lxwpRTnHfvYEFvpw1/yd9kRXSTyY4z6WwQOWnQRvr
y6zQorhLsTybBaq5brW9s2eFMyrby6MKWaA2PbJY3oUVOuTjTK7UskAjqT1I
yYcV1ona+LoQefQkn1Xak8AKSntSS7W3s8LyivUlw1FWyF2QaxDPZ4Udrx2a
3Z3ZoJShHt35iw1WR29nud5kA77C+Q0fBtmgWsP36dW7bJD94+p/rpNsYN0a
Y3jemw3mC0O+0dnZIUy45cvhMDaQLu3iuyjPDrP+B3P5MtnArCU8X8qBHfLd
GJGR/9jAbc+NWeFFdvCpkHULnWODH2GOGxrZOMCErnLi8RIbjD4OvxfMxwEj
n/Sp7oTfnYnZKizrOUBizNPPisYOG0STVHIQB9y/OHprkyo71LkM5Fl5c8Bh
4+LTWU7scC6U1caHhwRhj//bye7GDpeB1KwrRILecrqA8R12yLYZ4OAUJ4GX
ul3x6AN2aGb9VHpOiQTFG2kKss/Y4b5fI9tLAxLsn704E5rDDp0HCuTYQkgQ
uF3wezeTHSbe9wWJRZKg0y4vYWsRO1CyDtvKviXB3V9ki+pKdpCNUvOnpZOA
WZldwtrGDgOvddqN60iw5yV38LVldihe006T5ucE35+frhSycEDpUuxhMxon
NAuePcRP4gDlnsa1O+s4wdU7fTaezAGqQ6oSEQqckOVw+uwvSQ7oHXtswHmY
E1QgaYvBAQ44937vuig3TvC6bcYRpcUB8tTO7QXunFCfydI1dJQDRrdWH656
wAnXNp8IeWjCActt428+BHFCitDqXMEFDri2y6/WPY4TFPsNyxV9OMBLXFxM
t44TWq4oBV3y5wBbmSw28k9O8BnjPvUmkAN+sR8uyG/lhO654lGhCA5g/Sz6
72cPJ4Tx7hRejOcAS7n4Ss5pTjgQROlSTeKAaqFDfuLznDBG+xvvkMYB8Z93
VIotc4LO+jiN37kcwJKqt76BnQuWt4leqKzigMHBPfnKQlzwIXNaia2WA1Je
HmX1p3OB2d76WY0GDsg6l+1TK8oFaQf9/VPbOOBHpdknQSkuOPvFxnSoiwNy
KxT5+WW4gFf/kOTGXg6wu/GWb0KWCy6dWE4PH+GA+sO7bRy3cIFQW8udunEO
uJrg78atzAVFlllavNMcECY6+sJvGxesu+zY6r7MAVaFY49gJxd8GdV9l8NC
AmcRN17X3VzgfH2TwyQHCf6FdlBC93BB7e1ulktkEvxK65V01+SCO2sF1a+p
JHDx1ejR288FCt6RYS10EhzP7opmAS74ye1qKbSOBCqbg/e+PMAFXk9MFPQl
SfBb4vpj8UNcsE1o29RDGRKUz7K6eh7mgo5wvgIsTwIP6Y2tNVpc4C8++HBh
CwnauunPVrS5QC26zFB1GwlSVdz9aTpc0Cf7VsxBlQSkF5YvBI5yQegH9944
NRKozcnEjREYbT2d3K1Bgi3mEUEZulww+mm32zogQeiXv3vO6nFBpBrtgOlh
EqivK/QeIbB2wThvoA4JtPM5zSz1ueAf1DR+0SfyuaYcnEXg6PKE16zGJHis
yMKYJPAx3YeXNU4Q8cuzainHuGCx9ryKyykSvC0beylM4Pjj+5dTzpJg/Ybs
C8vEedOWdRWD50kguebJV0lg1rNzQTI2JOhx2HnLjcApv3+csrAjQc0Giae8
BLawSdsY7kiCaqUZ5EnkxzMS8Pe7EwluZw7ZtBP1ZF+9ksPjRviPCx0XJfDF
aS3PQ3dIYH55vngvUT/1loye+30SRPs/rdhH8FW4siqc84Dol9OxAdkjXPCf
V3vXxCMS6HB68o4TfIty5SZsCSABr9mSRBTRDyfKdc3XYSRQllDLfk30bziw
+lrQcxIYrVq8phL9tSbLvveIIgHfi/xJO6L/xrzN5AuxJJg9HxZZp84Flb7b
D5omkEC47mNtB6Ef4PJ31UoigZWxyvbvhL62c+z7tSmTBPVp7/bZqHBBglc4
TSyXBHkVKzW827lAmnXiCG8BCQQU4gyfEfoVXI1JGy0lwZOjnxbOKHDB2By3
V/oPEhRU5nqkSHCBjat1dkwz0c8Odh1PMS7ommYOP20nwfnZrLd7Rbjg26Tj
cddeEsQ/a+k5LcgFSSONshr/SBCpUxhoycIFsnZbTynNkaCFYdJqQcxv1OCj
J+uXiH6bSzgAMd+P+9Vn19iIvXN/0CRnnBPsfkV/KRPiBK13DZYXOjmh5+zi
UpYIJ0S09as9buGE0x3Ht8cTey7UxWDz8x+ccLSVM9JPhhPipdkPn6/iBIUf
9nYGKpxg+2l5NjWDE6KNK16j3ZxwjMy9lSWFE0TrpH5sVyew+/FLuxI4getb
gwbtICc0HBOqM4jihIGKPeQWY064Ybk+YB+x/yy1Qg9UnSDu9ZvlZt3lhKbS
EZf8U8Te+9zfL+TKCeVFr7uizhP2Vfqxu5c5ITafI+38dU440xvwgk+fEy6k
1JmMBHPCYdm9c1IChD/RL147nnGC9tTzcjUSUY/X509ukZwgkB6xa/syoQOz
RCGOGE4IvPpcrnSIBJqrDxokiDoObXkR6kT0SdhAzcSA2KtcDyub2K+TQDBX
2SuM2KtJXYGTioTueWVkP7URvB3jO/9i1xkSsMxShGwHCL7+2fX9JeZy9NVw
/f05Yu9fU4+aFiFB2d9XxulEX/V/8V9zzOIAfDLMc249F0juXcrMS+CA/GL/
9H3EXrxdarT25yUHpD1zo1YTe/Dpu3DhMU8OiNpnXN+jwQUvsN31d/oc4PKE
w1jYkrhvGShT28EO8sr/GbnFcIHcM5f1jCHifzq4a9g5jguSD13+JdzGBp+m
jR86JRK6PvIAVqrZYF/BnnyHT1yw22CvY2ASG5jqccpeLOGC87pR9tmObOB5
5e2cUQ8XSFQ4pu0bJ94t75tfb5HhhvlimSjUwwJPJQ//7XzLDf8aV/osVFeQ
VXxqOETxwLV1Dp3L7v8Q54EpifvRPOCudPKN/fF/KLlt57vPsTzwnj4t2qvw
Dy2S81PVk3kgTzlIY+DHFApzLqvcWcgDOhwh9se3TKHKA62LCt08cFqrRk69
dQJt72A7R5XlBc1CgwaLh6OoyUWr31CBF8RPbGJvUR1F7oK+/wUq8cI+izkO
j54RVH2QfJNvFy/cdd2ichpG0MUPjBCSNi+ws5jPG60OoeeuSqULtrzw4zGj
Scj7D2Khmm3q+Uj4azxZu1rQg67H0kVbUnkhmO/f1Ge3HuJd/JO7NoMXfNy1
VpkqPajM0nQ4j8kLT70ddN0+/EZ+SSbJIV+J862XWJcju5GQjqHqgRFe2JEl
9cRXsBPJ3tdB0Vv4QLq+QPrBzp/omRD39vCtfBCy+eHxRWYj4oz7Ih2gwgdm
03c+Ch1uRIM12mw31flANWrDgy1mP1DyOq1yQ10+kK2oVKd41aPd2Qf01q7w
gWJL9I6Rqa/o6F/1k5Yf+GC/73PZ/9I+o/32EYc+JPOBSFS+typHAVIZ+bdt
Op0PdHSqwqzP5KN1Q0nc/vl8MNV4aG2NloNG+yTzs77yQdhdrwqvlDQU3MG2
njzGByxk5i6aYijyPnOOx3yKDyjijnzy6b7oVhtzJmaWD4qEpt6TjG8jHZ/u
8exF4rzIPt8oRxPUaCzxvnOND6I1xjnzfVyx2cn6/Afs/JC27lFvWoU31m1S
jq/l4geWWgM40xmEVRsH7l+kEFjCoMi27QVu+lrdw1ThhzLjm+88hNJxte6m
75xq/CAcKh5beOwTxlUPmMYa/JD9WLf67MMMnPBFM+zPIX6YmNfc/HkoC98u
TdGinSDua414/PPJx+uZoQl2bvzgaHfziZ9fMRZSHw/LusMPTfct/aR5SzBn
np4niwc/cLv7WPzxLcFj2Rynw335IULtUgDJsxQXfXLlK4nkB4VsfuqTM+X4
YuJpR7ECflB21/yilF+Js28M6RoV8UPVw1StjRJVmHvfzU2PyvhhdLcmj/Xd
Kpz0/Vn3dA0/FE0hM6ZaNZ6erjOp6+SHmA1aTv8iv2LtwnPbuHr4YfxD7rGD
Y1/x80djfPsH+CE67/iGbqjBmuv4yz+OEfl+fxDJ/7sGP0BH1B6t8cPWA+pf
tMi1uJG7iVbITgaVoR6Fzaa1WL7h4sQ0FxkOCdQLXYysxdUXvT5YU8hwuf6s
cb/kdyzk/1l8/wYyPBEeOS/BV4cvHtefd5YjE++JHryyqQ5nS7Q3ftxMhms/
/AQph+vw6dT5J2IqhN3ug0X1rToc06jKMnOQDKv/+s0T2+vw9KuSDsUjZEg/
ON+0aaoOa9sa51nrkcEsMNCwg6seDy84OtUdJ8P7V+du/N1ejzVLVwy4zMkg
S7w39Q7X48CAAMX9FmQQ/C/Rrs+sHqtIJfZ9vEgGfv3XApW36rH34J7instk
EL8w1iDsX4+b0r+8EnMgQ7uCl92byHp8+3C/2SMXMpzkGM6/nl2Pa8jOqoW3
yGBC5TRkltZjyWY2yow7GTieD9pr19XjkivSVdY+ZAgS37de7k89FlZNfR/p
TwbJsYiY25P12GZ5n1ddIBnO6rlH0JfqcW55jSXXUzKM5T9ZnmVvwLxBZzT2
R5BhrlzjpxR/A7YwH2a4vCT4nS/bFEJrwCkbbk1/fEOGmMYtK3rrGjDLCFd9
zzsydOYqnjeWbsAmmeHJYglkyMnRsI6Ra8Cx7nL+RklkOHfBnQpbGvCsdqbN
ozQy3H6c76W4tQHrUA4dKswk+B2zqLm0owG/aK2XmsklQ3aXDdeEagMejbFa
VvxMhtCW/wy/7mrA++3HW6yLyXCd4lcyv7sBB++6lxVZToauibOet9Qa8O9V
/tC6KjI8D+RINSDwarFoa+E3MqgaxUs8Ic6veygrnVxPhi0mcWp7CH9qOttt
X/4kw1Tv0KQREc+UTzPFr5UMNVqyqGV7A75We2TGrZMMqco1wt+VG/CTkOOa
Nr/J4KLFsNtN1JNoeu6BaT8Zbr6dVhOUb8AVjP+qDw6RoXY7163TGxpwT5sr
dcdfMmTKR28Wk2jAa6+8zKUmyVBkkXdEX6QBS5wPfEOeIYN16njDtGAD3iP7
YmBpngwfj7vX0HiIfP68Vx5eJoOB/E61RNYGfD0x3bmFRQD2zLgx8hbqceL2
KrYsbgGoYP9rfHiwHlf8azz6jl8AFH4+Lijpqse92d3BIRQBkNr+6PPnxnos
sW9e0lFUALoyXmco43q8l4XDxkJCAJIe15XFZtRjs1LBZF1pAdD3uxcbFV+P
g45u0tikIAA9xgkitMB6nMSv6kVXEoBTDXJ1Tz3qceX3/VXs2wVAYEkkLtKp
HrOZmZ3sViPiq3iw7z1Rj52tH96IPCIA6q+RQb9wPQ6WC8l/pCcA1WpiScns
9Th5MIrV1VAAWMP6VtiJ+RpwzAwyOSkApG2vVi2/1WHzO70f+WwJ+454tbF7
ddh5//jUgp0AHB84N6FlV4dDWJf2DjoKQN/dn3k7T9Th6kdClWWuApB7Vluq
Y3Md3hd2oM/dRwAs/GQe90d9x6dPHlO09xeAyww1ySMO37HrulNOpwMFYOa1
2b0hze84Lfoai1o4kW/gJGOxtRbLJL+RmHgvAAYbkkSf8NVizooVU+tyAXgc
c0g/xKAGxznHRbyvEgAv0+8F8oI1WHujYdvgNwHQk1gfzv39K/bxiD53tUkA
sKd812f9r5ikccju7h8BEJUOvawF1Zgjzfd+OI8g/LtlyXOftxKzvaAlVh8T
hHWZOcXGB0rxmsPmNZUmQQj1/337XkU6thMxTFJuEyTeR3trjmxOx42FzqcU
ugQhOjXRWz4gDScKFmWsHxCENt20b//FpmDTdLPL3LMEjuir2Fr0AZsuFg+O
8VLA49kNPVNyNE7YN25ctoUCRmlv/ZrBFXVSvRKKlQicc1aZZHsfCQ0IrxVu
JfDeB3kdB7yRe6B6Up4KBSizF5T/GD5BJr8ecqaqU4Cb7eeIeEQEWvaQYEbq
UoDlo8/rEddYZFR2VPaqHQV8Lx7Rq9f5hDI/zzhZ21Og72Tvc1f8CYnmvC0+
4UiBie3jE5t3ZaDuDwuWmk4UGKw9L5S+PhNdC/oQyXObAuabNbav9WSh4NM8
grF+FEj077wSr5mHpo9nnY14TAH+4NP+Eu/ykPmx80n+T4j4Dw+23uXOR9KQ
d/R6CAVEzzXcmvuej9Lkrnjvj6SA1xWZ2bfGBahuonKhJYGIF7LphIkkRjuH
nXVqEimg8PDHq0QnjJ73SkfgJKJ+zZR/P8oxsmq6uTMujQKLaivqujuL0ART
4eqNXArQWFOqGr8XIdOsxs82+RSQvZBsrTpThHJTPPhPF1Ag6kr6+xmxYuTx
tuUDFFFgf1Yk5d35YkR55NtHrqSARKJP2dOhYuTssVOVtZoC8sf6Wlh5S1DL
rW7P6a8UqD5k3vp9cwmKtt8j1f6d4HPvI2F/2xK03WTwVEIzBbZG98Y7tJeg
ML2whJetFNh+0mdH/WwJmj8Mc4HtFOh/K8EVSi1FRWrPw1x+UeDXWbcXW7RK
kfF6ne8H/1CA7PHQLT22FLkGlLy0GqLAvTPiW5oLSlHUkubleyMUyB7jdNdo
LEWDrTtY88cp0Nh2+hZmKUMCR5O+NU9SIEbu+WgXvQyp5sq/mPlHgR67b081
t5She+HiqjvmKWDi3X78k1EZiiWFrxksUuA+xdOm2roMVTtTauyXKXBid2q0
tHMZoh8nXUpgocKO9NCiR2FlSL3k/o4KNiq8vn//+/N3Zchqx+JKLwcVnv86
ZT6YXoaSBMfDpXiocDe3xO5QTRlquHflwj4+KviUHNc3bClDc397t50hUyHF
qubki94yJHHWcvmmIBXqnd9+kR0rQwdrWirDqVR4sJvUMTZXhi5rHH+WSaOC
v/zvtnmWchSY+O18A50KN7q+Cx7iKUeZYjpbJxhUyCkQqflGKUetviWL5HVU
MHN8YxPJKEerc5pfFCWo4HJiUiNufTmStc15elSSCoG1W1KmZcqRbtMOK1tp
KpgbL8o+3FSOrmklKT2UoULo9QiyuWI5Cs+UX4iRpcKTz8w2h63liLnxbXmR
PJHf7ZccX7aXo+5Q8dAuBSq4Qxf3RZVyxMkWbrm8hQoHnSPstFTLkdJ1iuI6
ZSo0vd3/6T8Cm3T7z6ltI+rNjHdoJs7fNCSVndhB+KcubfPbUY5eFd4PvqFK
BYnA5BDPbeWoRHnRImQXFb7q3txerFSOBqOcN6eqUYHH3ihVZ3M5EuAfn6nZ
SwXvTMtsUblytPPOlZJhDSqcYZmb2iFdjk4P9wZy76eC1dsgxrN15ej+Kcsz
8kCF8Fe57QeFy1FsZcumwwepoPZdaFmDXI6q1Y5Pnz9MhdF+bXVPUjmaiPtW
dF+bCh16yxa0lTIkIqLz5JUOFX6Nft/2718ZOj+tKd+qT/Ax06L05lcZ8rmQ
MzVrQAU/eczp0EjooWEHFjYm8hmhTjyuLEPzafLmRieoIF684WFRShmSlH4r
63iS4Ce1gLMlugwdChKffHyKCsNN/x06HFqGAh0o/l/OEvoLqa2RvFGGMjv8
zfrPUUE7U084iNBrmx5pI7s1ka/WGX5z4zIkt2WRud+GCjIfuHbNK5WhgoHe
v1mORP2XuR2COkrRl4aoq6nXqNBqvaXgTGUpaig8MZngRIXHX15MvMog5in8
y/RLVyqshPn+fORbioSPfFzyvEcFo6AL3/mVSpGU6kX3Ox5UkI9kOr2jlaIt
UuvXnL2o0OfA3pOzWIKI6Wa77EOFF80GhpZfSpB9vBOPQSAVBsTvKePTJcjt
qeLjI8FUIEuW9J3fX4K87vfxHwilQvNWI9LjDSXo+Ukzys5wIh+FO+wuA8Wo
jEudse41FZJP7eaptCtGEpdZ5QaSqeDgyV3uZFmENpnmx/1KJfQ6WavBrVGE
VOCGQms6FdJVn+5UYxQhHdF+xZosKuy2D3T/FoWRc2WlyqfPVIjdq6Nrda0Q
1SgEw71vVLBnKzbZOMNEd4YkLUT+UoHiqCkm4ZuNdPTizqiPU2GaaZMvJZeN
hJOVz1hOUsH0dz9EFmehlGuap+NmiHk/qZS0PJ+JuudOme9eJeKZflccPZ+B
tDifmZoJCoHN+P4rSVJpSHAj37HwHUJQc3W31PuqGNThHaqfryoEUf0eCo/H
36KEATH9rl1CMPrwyFY9+lt0MFFBT15dCBKennr8t+g1ct6hfTT7oBBYtTWv
ho1GoFbkqdV0XAiC0aFHcpHe6J3F3D4RVyHwXWh3f2MfjE01Pk/RbwqB/Xna
1+KpEMy57kE8/bYQcAxsMIhye4rtmgWo9HtC0NIcIGToHo5VTOT7aD5C0KcZ
nODlFoVLjpzwp4YLwbVHMae4BGOxs7w4oj4Xgk+Ht9Bty2OxPOn3P8oLIfjH
Xlhed/s99i+xP0t5LQR/LdI+pvTEYZN93tsF44Rg2yVtWcG4D7hHJaOJP1sI
pF7/qjo5l4LDqLce8+cKQeO1rIvyUalYe2I/8OcLwYbW52ztUsT7Ibn6A1+h
EAg8Mix7UJyGnRR67vJWCMGHdRI7WFbSMaskdSN3kxAYhR7zGzbJxJ+Wm5q5
WoRArO/V+ysvMvHF9qgArjYhOCtIhy2/M3Hlc4VZzi4h6Mp7t3rZPgsH06CK
NCAE0rrMy8m3srE0z9Wr7LMEH7HuQ6MOuZiVbCCxMCcEbzLtn72Mz8U9FOWq
sQWiXsMUdKc7F78THZFpWxGCcUVt30rDPCyvYNuURqKByBUH4Vuy+ZhLSftB
HBcN9CNTPz05mY8Ht8ltj+KhQbmpcm+VXz7+oNbr94hMAz0VUkHmSD5WOnJu
nyWdBnE63Atq75mYrLd/+DiDBr+2DCfY1zPxmMH6iKNiNFDqYKMVLzNxqln7
xM71NDj9LeVduVEBVrE5GcsnR4N7BmJsm8YKsJDdbmPWTTSwCPn29iDtM/7n
QF+dVaCB1tMJ7Kb2GWe6/DjZo0SDhU+GPxXdP2O1h4Z8eTtpoHsq9ELiymcs
6rc1N2U3DQQ7lCo9xAvxfAD5UuweGqC/ClT7PYU4P+xrYZAmDVoKlu/fv1qI
XzxP/O/hfhoI52+ojfMrxHei/ETvAA2KQg4Z/44pxJqxR5xsDtOgjO12UGBD
IV6fIC9loU2DHXIe8SxDhXj1I6nGWIcG35IvpXivFmKcUSq3T58G/2r5HxfL
YxydE9OgYkCDzT/OTN3ai7EH0/O+ghENxDXe/XdID+ODpaiVZkqDyXL7NW57
jDd+kfThMaMB55vFXxx3MOb4uqKydpIGteufWVL9MO6r7fg1fYoGMzGvHLeG
Y1zewAwYPkMDNfkVHosYjOOaXuztPkuDALLMjhfJGPu03Rr4eY4GlK6V4cEc
jG27zJ9+PU8DlSI2LZ1ijHV61KD4Ag26OqSP51ZhvHlA5G/2JRoIBJdu21uP
Me/wTGSSLQ0UbtQuVTdjPPy3UTvmCg0a9r3ocujE+Otkxr+I/2iw594kSaYH
46SZ0OgnDjSIUSDH/enHOGDh+rEHV2kgvRq8UDiIscOK0eLN6zTIr350IGEY
YwPW7fGON2jQd+dc+bsRjCdud9YHuhD+NxNUE/jptP9yihsNuou+uD8jzu92
3LPp+y0alOxYOWVP+Gv50288focGY7wx25SJeLfPP70reI8GFVZp3i3dGEu0
Q/w2D6J+l4Y/ju0YF5qO1Rt6EfElz0xMNGJ8vvbl8lVvGgRO7tt/7hvBt87R
TcE+NJiS57qdX0bwWTxrnOZLYJ0fpuxMgi+N2Lt1/jSQjNL2VU8j+Mg0jp8I
oEHCMe8mq1ii3q1r9ZQgQl/n5XjdIjDelpC0vD2EqN9m26w70T/nl1wm15/R
wPr1LYfzdhiL0LPuhkQQ+H5AJTqFcV6gdXx6JA0KL0beETqC8arn5+XJV0T+
m4T6nksRelqy2yQUTYOaepmPBryEflxETVRiaDC9YPV3+V8hfnT5RrxTHKHf
2y/OHSkrxFt6pBtCE2igk5L4uz+xENecqV3+lEiDaJlFL8/gQkwx3GzyL4UG
s2oXJLPMiXnY9Wv5Rg4xr2GVOiqdn7FmasCmsDwaCD2oXN/F/Ix/KaibZDIJ
PljD60IiP2NZiWfx05gGbb2phSImn3Eym56JSyUx31/CfxfnFGCju/N3n1XT
oJIm86w5sABPzbyPz6qhwerb6mLWSwV49xDLykwdDUxFjM+8ECjARd+z411b
ifnnD/tNPsnE1kcvNoS3E/qw5b0/L8/EHKXUlexOGhzW6Bonzebjo9n2JnO/
aXDzvuNscEg+boiSWXEbphHfG9/fvy7Mw/1XAk1uLdEgWKpd6NJUDra3uq3i
skLw2SBk4pOXg6fNbISur9FAu/dWL7tHDuY4vL/hMrswWLXutRXny8EykmPG
5nzCEPbzfM6EWDa2ajhmrCYuDF0fKicHxDNxmzrZaEZdGLbvP1cZdC8V1/EF
HLt+WxhyT91ksC9FYLGb2h8j7hL2h6+Gv74Ix9Z9LDyF94ThJlI+s0n9GZ4p
cCnjfSAMCSVv7SrcQvE6x3MasY+FwSgmYsP4Lz98sU0ssvqJMFDCrikbij/C
ydqNsxNBwiC9PfXDMzNvDFJHP+0LEwaQgJf2L9yx32N2ysVwYfDYdUrek3oT
N8x9dvB/Lgzdu15xbvRzwlrqV/ZZvhAGlhtvip5//A8/c/6vKyKKuE9vf9mr
boUpmRndYW8Ie93k+79KElhlHdfY6beEP8u4xe5rRugA3fqg7jvCblNkXrjR
Gvl7SkRfe0/YE8XprPIOKE2Fk8GbQmCqnviTA15oMayVYx8Whmi5355fZp+i
w6xh1heKheHyRHvrjWPP0BMHgyK/UsKfktwU9V04ktYuvdP0RRgqOTMnZ3Qj
kdZc0tTVOqLeW2kZGwJeo+BTHt0xv4XBOZj/l+KlWCQnuamAm4MOvot2Hn9n
ktHr1EWqHCcd6sLLc448SEEiB2ptD3DTYf5q9817gqmI86IL7TY/HRK+ZfPt
EUpDAx9K7UaE6RDQVI9npNJR3C4rsVo5OnS71g3XS2QgyS+qV4c30UEnPZtp
eyoDhZtzlXNuIc5rbkV6zzKQz52Ua2grHUpsgGWaNxPZFi9/SdtNB6Opc9te
/M1ECsciXZ8eoUNYlH0tMzAbRXfZ16QepYNCSuQrC5yNRK+BTI0eHQTqet23
j2cj7qd/vnEY0aFgoTnpP/0cNNiyS87VnA7Sjhmd3Cs5yMqO507oaTp43feW
Ft+Ui1qWOupSLOiQv7ot6oRRLqqU9L77x4qI55V6Yn90LvpwseGH+RU6yIi1
shXuykMys+83u/xHB2drefKkeR568ejW/RAHOpwecN1z6E4e8k+UVqy+TgeJ
0L9j8DkPsWlOewzcoIPwhxz/4Y48dPvblyY2VzqYSbVdTl3KQ3YTjl4at+mw
VAaWj3bnox7Pgy0n7xL1+QgUPzfJR6dpIlud79FhncHxlWKHfKS7+3Nrkhcd
2k9uHjF/m4+23OXbIfmYsL8ceuW9ko98/ddrijyhwxSvlE8vhYn6n287IhBE
5CcYWnBjIxNFZx0/uxpKh1j3WRN5bSZaKb10eTaMDsgkvfuIGROdbnC7MRZO
h3OLIBp5iYno4y/9ul7Qwe3ZslSVJxM5rSSHNUXRQZ5FRT8+kInq+Ire1L6m
w6qtSVvGCyZSXteQWBFN5C/S5zP2non8FfqyCmPosF1mn/DJNCYa3D1blB1L
B8Yjb92/eUykpcVdkxJHhyh6xlxaCRPFHF/XHJdAh7L9YeNvq5mIxVqp53Ui
HSLyKviK6pnI8tr+v+FJdPjI8lmRr4WJmPeM5gNT6HAl6fPOB51MJPrEmv1R
Gh2evu+lKvQwketLZ4H7n+igqyKZudDPRI0ffMTcMumwp2O70PwgE+3IfS57
NZsO5SoZChtHmCiwInGbbS4dei5RFm+PMtFoY4H6uXxCn3k+gWsE1u2t1TpZ
QIfdrfLTaQSOn+w2MiykA+9Kw/4g4j4Hy78zR4rooDixz/fFEBNZC5BsUQkd
RseGxhsGmAhLMJzUyuhgeW7Tyz29TCShuNl9WwUdtl6gZX3tYqLbezV8N1US
86cd7hjQykTNR449laqmw/6q86u3fzDRTrNzrxk1dLDeNx4dUcNEoRevfxCs
pYOLn/vznjImGnd6kMlVR+hzVUDZooCJ9D2f4bV6OtzktU3iyGCixKD46rkf
RP2VXHYdCUzE9Trv5/hPOnyy3YZ7XzFRSX7nyK9WOlweiE/3eshE0lXjs83t
dODfxy0pfpOJ3JtZ2eo66cCyk7uo7woT7ZmWEy36TewD18eeZD0mCmfbszG3
lw4TGg9fOagz0T+K7ta0fqJfBzkGWTYzUYqy4+HoIToU3bdFpexMxK/pYfh8
hA5dYpku/8bz0RXd0NPBfwm+9A2UT7XnI1nb7Gsek3Rwn3FM+5KajyKjV6Os
FuhwI8BK8bBhPppNoSSYL9HhpArdTnVXPjL9LJNhtELoJ3265ey6fCTQpl0F
rCJwOnDloW1PHvKmBc1I84jA2poxi82VPPQu4uq9Q3wiAJs0nvhq56EScSMu
G7II1JpsEqqRyUMsslSxj1QRyDn3nI3Zkovu7nyquWudCPHeXGY9q56LXube
KD8pIQIcp29Ff6TkonxNU4PbkiLwSDBvRG4gB80fplthGRG4mNZn8y4wB7mc
iHhwVFEEejS074/+zEZhrW789soi0GTzu6fkfTbKPGv+LHCbCNhevWBZ75yN
pi6Jxf9QFYEr3lGGryjZyNH1ZfVZTRG4a1dttQFlIZuIN1SnYyJQz/Ln87Vb
GeihuMeLMEMRqJz+dv31vgwU+8ZqY46xCPBVuNZvYM1APfEbdi2fEAGknVu+
w+cTssx9Z+5jKQIpVbIC6b7pyKw1/s2LqyJgGidgJteTgo6IpymXhohAbm1e
nAh+j/Qlvv9X/FQEpGMC40u2vUdG68c+4GcioDQu9vnLm1hkLqUkXxApApk/
rwmPub9DdhsTJLPeioDVt2jSRtW3KEAxWjA+XQQ8mlisp3giUYNG8KR/PYFd
BDXzFN3QBZGwpKs/CCxZ9MkzwAm176t1ePSTwF4x9T2/7FAf4h9+0CoCLIPW
Pz89OYaY81YfitoJ3J1cyOOgiUcP6Np4dBLnb7K67VMzx+4SBhsu/SLw4Mai
SMtLuD24cDD1N4E3T4Wq617Di4fjpe/0Eveb3acWkpzxqlaF5a1+EeheEecV
CbiFOXU42l2GCHuIYPuBWE8squ/xw3GSqKf3Ehf1zGNsaXEty4TKAAvZTbv8
L0XjEK+EEW0aA4xeS583mY/GZQndGzToDCiK3uzwzv8t3jJjFLhRjAGZAg5z
tckxeO7JDttpaQbcNVcQafwbi4PxlGj4dgbUaETr/jb6gEv7txj6qzBA/0jE
9b1tH/As34WH93YS/lyerDRZJ2IL8x+TNnsIO2W+uf76R7x5MqNaDRigcCv0
jqlPMi6RcbnbasgAq/xJLVJpGp7RSf70zZgBE8W3XIZZ0rHC1f7B4uMM0B58
5WayPx0HMk+cSDzJgCjL54bvctLxGdPdW++cY0Coy7fLtNhPePrh3C+Jqwy4
d263bZB1Jt6UtE2Eep0BccWLpiURmfh0g60+6QYDHMNd6k/XZOIiyZbcv64M
6CsrDclSzcJPcnJDCu8xgBKTmtizmIXlh24dsgpkAL+uik/ilRws/tBj7l4w
Aw7eqbvG/TwHUzY8+vgqlAGBjp0NIeU5eME8jNYezoBhp7ZTUpK5uKYypffE
GwY0ab1WnizLxcUXsyKc3zJAgCv1sutoLs5mKdB7+o7Ir3fkgigtD7/ZU5VR
F88AzrSIxI9n87BTQu8DvTQin+eayt1/8rDt4WE1u08MiClBs+Lc+diie2LE
N5MBe1wq1Gw35WMt0dXjFbkMkBx2mpK7kI/VMzm4+/MZ0AaL58Pv5+OtRnwF
7J8ZsNOrfTflZT4W9RWVPVDMAO/SggPrvudjsqxUy7lSol7hxTfxf/IxW5Fc
wL1yQi8x6zP3rOXjkTmVaWYVA6bf24VZKTJx99O9CW1fGWCvU8mcRkzcuA0s
Fr4xYDbO2/DRcSYutD1WtruBAQU8pXkxbkycwW5680QjA5z1naQ2+zJxwpvT
Ss5NDGA7OST4IYKJozTOd4e2MKAwS+3ChjgmDmm2DUtvY8AWacp8cAYT+9xw
1KnrYEA2//eMWczEtwVdlse6GDAm6Oll/JWJr368k0b+zQBuniGz6J9MfPGI
10WlXgaAqM+Wni4mPtXrK6rXzwDhC5Er9D9MbHA/qObKHwYEv1NsVh9j4oPi
4R6+Q4SePIXKDaeZWC0namf8CAOS8mfajy8wsdLxd4PlfxngSjVV015hYunx
D1F94wxw4vNdkGMpwPTHaUbsUwzwcavRm2ItwLybcjhkpgk9FIFlIlsBXiv5
nAuzDNjK/9f2GIGnLcvsz80TfEtVxLUR9wcXq6XvLRL109LPGa8ycWd4fWPU
MgNe//TpSltk4gaVFl/mKgPUrzBc52eYuKK2S7ONRRQU1pQ8Nk0wMdOuf2Ke
TRS2fg88u2+IidM4R2MZJFHYWczuuvc3E7+PmTLfzSUKgZ2me8RbmPjF/gX+
EzyiMOVruK7nGxMHta0V3eAThYv+X54/KWFib1dOl1CyKAy2PVdbn83Et4TI
m9MFReEyfPAMTmBixxRa53eqKMCnIe4/kUx8ckBaiywiCmUOK3s1bzGxytql
FC5RUVhHCTjvdpmJ+UU/MtjWiUJtR5F5nhkTFx3dNTy7XhTU19ZVGG0n8rG+
fXxSShTuhkXXvxdnYuc7uGBkgyhkvgloZuFkYoXko0HdcqLQ/Ut1T2Uzoc+K
wPm2TaLAfUj8+E6cjzu6fpz/uVkURjcXDb5/n4+DKZY7q5VFwVvnLIq8mo/n
bzi1ZuwShehexR48l4cbAnIOpqiJQl9Hy4xZcx5Oer/8MWGvKEjoj3j/y8rD
Vs0+917tE4UA9mu3913Lw1XqLzc+0hIFUZ2iFNHWXBx7vDvA8wjB19S+i7/S
cvE9e7nZO0dFQdPn0mDSo1ys8jq18toxUTBIabpyViUXv2Atczh9guC7r+y7
xN0c7LyOp9n0pCgMe90xldHPwQaqBmB4ShS0G6J0dojnYLZLLUKHz4pCSgJp
h0N2Nv6vcjRH+ZIoHK66vnTldxbWDKKzsbqIQswe9eRxnkwsknD6vyVXUWjz
Lbepqs7AE0VvGmduikL21xcvsvwzcOzU5vjhu6Lg877aspIrA/Ob7ddv9BYF
Npbw36Oz6bhTwjY8PkwUKHrqMW3HU7GZnGZ/R7goFJ08Ee8Sl4LrlKk7hSJF
ofL2AbveWWJ/72fW330lCrIn+L0OhiThBCtBskmcKHTNM4+eT/qAnWJzHizn
EPyNlY533nuHuZS4rxu3E/phfN3UkOmDPXZ2Yp9OQr8jG9O12B7gRc1PAgW/
iPg9OesjQu7h0WMWSfJ9RPzOA4FHSVdxw9W0P0ujoiDdTm/XcHNEURnmlnGr
oiBgJi/5quIpohcoJ7eziEGsnsTbbT+eocAytmUKuxisvTuv+qEnAnn+TIq8
wyUGuTZuvoq8UchmjuWnEUUMLIPVpLbvi0Hdaz83+giJgXNivVOQwTt0ivuj
E1NYDNie6KVpnI9F+mInKPJiYiCiZqts6x+HyjdsOXdGXAwW2H29OqLj0f4t
a8nB68WgO7dr1D83AeWqNC6XS4mBKYvSfw71H9AOjQ96SxvEoKkzY+7eSCL6
H0REMyU=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.29629934552611825`, 3.140165820539889}}, {{
     0, 6.283185307179586}, {-0.29629934552611825`, 3.140165820539889}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.65399461374361*^9, 3.6549484834084797`*^9, 
  3.6549485548749247`*^9, 3.6844501086413794`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[100] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0HswGwYcwPFIlHiVoMmcV6JEl5YrS806VVF0aowsK1WvqnazLUI4rh5n
WtXuZkTqlGs9SjEaz05tmlKWtHUzyx6mRdo0pS2NO1cqXahsu5vf73f3u+99
/vvdj5Es4J4gEgiEgn/3v5KGTMef7Cny3yydSmc6XUjcv9lXSlHEA7EAquKM
qm+IC6ETmXOSZnE5VFG6TKkV10PDa3Jl1eIuaKnzYG2VeAi6oDXSczIVUN83
FZHX0+9DRx/GnCFuV0EDAnlrLcmz0Nj00KW+I8+hgwzW6dvNGiivmtWkTFuC
2m+5dUB08iX03Dvy3tvnV6DBBw8ltZSsQuVfrzCLc19DF761lT6q1kGP5fSU
L4nXoQUuMq/C/g2o50bBKjGVELDZu/Exy/QUA6hXHX+yIIsIDYoaju0TkqA7
5z6S7ywxhAqtMvzqKrdAj3cquC9ERlCmxxeROY3GUI3o4UJWC7Z3JeqssB27
T+o7wO/F8sKMXFNGsEWpV7SRauxM82Qdy4UMbTQJe28HE/sZf/APNxZ2md1M
ZnhjTWVCIS0Q66u2CDFMxl5wClpUXsHeGJvPuduMncotJ/a0YemTU7TiHqyk
PCOQNYy9Q6i/mK3CzncGuSTNYs3jFyShz7Ef/7hnxGEJq8oY04zosSS6MEdC
MoEyx2nEKmMsn3WclmqJFd0nN3JtsN+XdO7yo2En2bx+N3usTv03x9IZ61hR
P/baxSSA8P8E7A+OVjPRKYsLj39moc9dEn3Z54luD/XR1nmjx7XTRed90LY8
94tH/dHvEn9hBAeiY7uFEs8QdIP54LBBBNpDztO0xqMjM3XZFcfQWYwGg7wT
6IGCF9QIPjrE5zRnJR+d1NpVFXAZbcR56VDYgO6YYjfduorWWQx07e1AV2bJ
7rEH0fc4D3Q7VOjdM8REiqspmEA57K6+hg5d3Bud0GYGTmmPTbOTmoMfb5iL
FaMWeN+dN7xk+Vawnv+23vsvS/yHLNRV8LkVOMrxg18Dn6GlT58s9qVRwHnz
TnHURXRTnHYfNdsaTDcRCEir6AiD3a1pmTbgudQy7qk1tMKsNDwj1xbs5uQu
JRtuA7PyzbycvkEX25S/optQwQftuz1+qkAnxKX3cSk0MHP+1IGkMnT0U3qw
BfUtsNLh06rWSvRhN7+5mSq0woPCtq5Bj/jf/C2/Fv1dkqUFtwUtvNp/Zr0f
bbyLnBE1jf6KrRwqUaJ1fr1bpY/QmvA4CXMW/bug+9maBn35ekxCywZ6m9Sj
Y5pgBy6TEdetSOiiCUlNnjH6pJYwEWmFVukntpdYo4+Qrwlv2qI/tPvEimmH
ljNYiUft0f4sfYfIEf2D95/rcme01/ttYWsM9D+1IW2i
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVV3c8l98XR332VkmitFRSpKVS91iRygohCUkUQvbIntnZEUVWCqkUcSXZ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      "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA7I37Ve7DEUBQZI3CrcNfP9TqKICx
xRFAxgWd/tXZaj+rZGW7kccRQAxoHzNeznI/tlAePYvJEUDoNZ2MU8R3P8E8
176EyxFAGGk+mIjTez/MKJBAfs0RQBjW/MC21X4/1xRJwnfPEUAMiSCOX1eA
P+IAAkRx0RFADSHLfNimgD/t7LrFatMRQDRki2ayVoA/+NhzR2TVEUCVHrbv
pdR+PwPFLMld1xFAsxOp7unVez8OseVKV9kRQDLzxmqYznc/GZ2ezFDbEUDE
F+Cw6uVyPySJV05K3RFAgKQDKtyWaj9frB623t4RQHRlZqj852A/btNFmFbh
EUBAcfGg84EhP0VNgtM24xFAuB8guTT3Vb9QOTtVMOURQCgyuSm8QWe/WyX0
1innEUBCs9jMvFBxv5qDKZ886RFAP/ScCD+Sdr9w/WXaHOsRQCGGEki5hHq/
e+keXBbtEUAQj8LQr7F9v0hLpls67xFApJZhIOref78UrS1bXvERQGrKTDoo
UoC/4Q61WoLzEUBmFlF3Kvp/v65wPFqm9RFAjv/yuujofb960sNZyvcRQNU1
5Pq6iHq/xJKrvwn6EUD8Th1djb91vxSW0lgS/BFAhYpJs9ODcL/mOpmL//0R
QLTI5P8g7GW/QSDtRw==
      "]], LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAAJu2Qnt4EEkBA0mExNtxkPww8OCP9
BhJAOiPEvu18cD/f4P5V6ggSQNZuK5o9X3U/rEKGVQ4LEkAGIeKf5+J5P3ik
DVUyDRJA744OHYZAfT9FBpVUVg8SQDJmgfoCU38/EmgcVHoREkCbEc149QGA
P97Jo1OeExJAHrMITmBMfz+rKytTwhUSQKys3OldNX0/eI2yUuYXEkA9fQXm
R9d5P0TvOVIKGhJAqoAOds9YdT8RUcFRLhwSQM9o6VJt2m8/3rJIUVIeEkDm
BPs0EKRjPzP5rh0kIBJA4FFRKfMqUT/AyenuRiMSQDAzMStPtVW/wDY/ttkk
EkDkzPn1yU5kvxA6Zk/iJhJAspcUAyzBb7/cm+1OBikSQJxpnJv7M3W/qf10
TiorEkB2FxRUjpV5v3Zf/E1OLRJAuzQNAqbUfL9CwYNNci8SQOhOPh57zX6/
DyMLTZYxEkAerCzCsGp/v9yEkky6MxJAIQDtozumfr+o5hlM3jUSQPC9DlKc
iXy/dUihSwI4EkAKd6GOai15v0KqKEsmOhJAYHLBVje4dL8ODLBKSjwSQGSy
mB6luW6/2203Sm4+EkA+i2JIELBiv3QxRkm2QhJAYDGpGOHITD9Ak81I2kQS
QGSZr99A52M/DfVUSP5GEkC81X7tk7RvP9pW3EciSRJAxscw8wYLdT+muGNH
RksSQHIAcOLrS3k/cxrrRmpNEkDsmoqQuW18P0B8ckaOTxJA9kpgnulNfj8M
3vlFslESQJnJ2MQq2H4/2T+BRdZTEkBfZ3V8PAd+P6ahCEX6VRJAeFdbxyDl
ez9yA5BEHlgSQPZ3hVaiing/wga33SZaEkCyZQFdmVx0PwzHnkNmXBJAGo99
TXikbT/ea2V2U14SQPql5al4AGM/1VI811NgEkDQjdaThgpNPxcWfpEoYxJA
kE/Yw1BXU7+7rByoEWUSQN7AXb/ZuWS/CrBDQRpnEkAyp2e/eKlvv9cRy0A+
aRJAQ95B4D3kdL+kc1JAYmsSQFb+u7XGBXm/cNXZP4ZtEkDzTu8mcgt8vz03
YT+qbxJAanwFd+7Tfb8Kmeg+znESQOXa/vPrS36/1vpvPvJzEkAGTXq07W59
v6Nc9z0WdhJAvpQFOXNHe79UO73yFXgSQISjziL6L3i/BhqDpxV6EkAi060N
6Sx0v7j4SFwVfBJAYsQeezrMbr/hJTh7+30SQIqIMSxQpGS/peyFlw==
      "]], 
     LineBox[CompressedData["
1:eJwVVXs41VkXJgcR4rdlpDLRmCO5dSJdsFcpFLkWlXIr11wP534UqYaSkktN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      "]], 
     LineBox[{{5.509019035141801, 0.003557615964463235}, {5.510999656258636, 
      0.004270581651409305}, {5.513084520592146, 0.004837855365092937}, {
      5.515169384925657, 0.005193095179045821}, {5.5174627356925185`, 
      0.005320943317305003}, {5.519339113592678, 0.00521605655391953}, {
      5.521423977926188, 0.004883182407723396}, {5.523196112609672, 
      0.0044317506686948616`}, {5.525234067495678, 0.0037408673773391054`}}], 
     LineBox[{{5.632026030818923, 0.00261508242478266}, {5.634006651935758, 
      0.003451339058750483}, {5.636091516269269, 0.004183206914210723}, {
      5.638176380602779, 0.00473160057431889}, {5.6402612449362906`, 
      0.005072682205302171}, {5.642346109269801, 0.00519169625585124}, {
      5.644195209487827, 0.0051071517640827535`}, {5.646238951834064, 
      0.004809547702584648}, {5.6481853731161955`, 0.00433812789978721}, {
      5.650326436526539, 0.0036297828349919547`}, {5.652078215680458, 
      0.002924420644572896}, {5.6538299948343775`, 0.00212912134287623}}], 
     LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAzYFs+m0PF0ChnyowLjx0P15ccLVS
ERdAGrR08SvLdD+RgqjrRhMXQDOs2cOEnnQ/xKjgITsVF0Dcc25ZbLBzP/fO
GFgvFxdALPfRJLoJcj8T9waRPBkXQNJBekzBMG8/XRuJxBcbF0DG27DYP65p
P3lDd/0kHRdAae2xAUCdYj/EZ/kwAB8XQPjucnLsIlc/InXzQ68fF0CdWn4K
VrpRPypWV6lWIxdAxGfP6BDJR78w3g3ZDiUXQPTl+aN/hlm/kQDaCdEmF0C4
J4bnmFpjv8QmEkDFKBdA7NpWdrv9ab88RyhubioXQLj9s46t426/E3U4r8Ys
F0AbdB+gtzByv12ZuuKhLhdADsRMZiOwc7+Qv/IYljAXQFoNf20uj3S/w+Uq
T4oyF0DC0lcqMK10v/YLY4V+NBdAqIgvnisJdL8pMpu7cjYXQGVk1lpAqXK/
RVqJ9H84F0AEpRAS1Htwv49+CyhbOhdAuiLYe0bga7+rpvlgaDwXQCsYj1TR
L2W/9sp7lEM+F0ABejPE6shcvybc4awkPxdAzn7L5T/9Vb/UxB0dMEMXQGxx
ty6AGEU/BkloR7ZEF0AUPc9mOaVWP8NjXG0URhdATl0lrZKJYD/2iZSjCEgX
QGhBMAr4cWc/QK4W1+NJF0AwkTVRKzZtP1zWBBDxSxdAlGhRips5cT+m+oZD
zE0XQImDPKkJ/3I/qyQrf/JPF0BguoqlBUJ0P/VIrbLNURdARSDcLhegdD8o
b+XowVMXQMT64ZNVRnQ/W5UdH7ZVF0Be/lYKZC5zP6W5n1KRVxdA0h55QKZ9
cT960gNy
      "]], 
     LineBox[{{5.883414799939546, 0.003058832198399617}, {5.885318186111967, 
      0.0037532844559098003`}, {5.887130934847607, 0.004287381318481779}, {
      5.889246116262608, 0.004729918595784996}, {5.891109339923129, 
      0.00494361034492055}, {5.893179588434819, 0.004978147531589733}, {
      5.894939299669754, 0.004838511648595854}, {5.897630622734953, 
      0.004336155151851532}, {5.8993903339698885`, 0.003834212243863022}, {
      5.901460582481578, 0.0030923353396796116`}, {5.903530830993268, 
      0.002217554268302703}, {5.905394054653788, 0.001347764962436845}}], 
     LineBox[CompressedData["
1:eJwVVHs4ldkajzrdhuOSeLfEplRCSOaM0l7vKIqmRMg12w5bRHt/n5wuOMRQ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      "]], 
     LineBox[{{5.569584344030283, 0.002681428733484194}, {5.571460721930443, 
      0.0034818419137111426`}, {5.573337099830602, 0.004158250257976158}, {
      5.575734693814139, 0.004804691741271675}, {5.577715314930974, 
      0.005130083715957294}, {5.579800179264485, 0.005253414331591204}, {
      5.58178080038132, 0.005157686160694458}, {5.583969907931506, 
      0.004815500578830449}, {5.585950529048341, 0.004305522619484223}, {
      5.588139636598527, 0.0035456202057944646`}, {5.590224500932037, 
      0.002663023913139591}, {5.592205122048872, 0.0017167067353826724`}}], 
     LineBox[CompressedData["
1:eJwB0QIu/SFib1JlAgAAACwAAAACAAAATGWQhuqnFkB0SSmwGs5nv9SadaD6
qRZAmKasyvRabr+AKENVrKsWQL7GZJlBaHG/hClik6qtFkBYbZVsB2lzv4gq
gdGorxZAFKuqIvqrdL+MK6APp7EWQJtucaHqJHW/kCy/TaWzFkCPZS6uX890
v5Ut3oujtRZAxDi1PsCuc78nCOJGiLcWQE7QvVGF6nG/ni8cCKC5FkCcudpt
S4Buv6IwO0aeuxZA/vzB0lk7aL+mMVqEnL0WQIZQoUbyCmG/3pgMtjS/FkDn
AbELPqBVv4We/j1IwBZABITTa5XNSb/z9D7OFsQWQADohhD6aVI/uDXWfJXF
FkAwAjyRJj1eP7w29bqTxxZAyCb8uNF4Zj+mhEr/xMkWQAyYXEX2jW0/xDgz
N5DLFkCubDnXISxxPzxgbfinzRZAdrQFvzJKcz/OOnGzjM8WQHnxi//wgXQ/
0juQ8YrRFkDIKFkPhgZ1P2MWlKxv0xZAg5jk5kbGdD/bPc5th9UWQA5pD3ab
qnM/4D7tq4XXFkCLzNwppNdxP+Q/DOqD2RZA+gIX9p2tbj91GhClaNsWQH79
K4CH1mg/7EFKZoDdFkDbevHa0mZhP8s1qw7M3hZAEsO2yGXTWD8L+HAaSOMW
QOjLOYeMaEe/+kSnIHvjFkAQmVghNKdKv1e5F+jF5RZA4Ab7D7V0X78CR+Wc
d+cWQKS6x71F8GW/Oq6Xzg/pFkAUPSkLIjtrv31vPpyN6xZAlmRAXloPcb8P
SkJXcu0WQPwLPjyWAXO/FEthlXDvFkDwnL1fhlh0vxhMgNNu8RZAv1Ok7aLo
dL+pJoSOU/MWQHrQXHdmtHS/z2HC8hr1FkCHEPW1/9xzv+ydhleE9xZAsm1O
NVzEcb+ddhdPgfkWQEoU3lKrk26/LlEbCmb7FkDgs4At08Zov0wFBEIx/RZA
xIYXI5p+Yr8UR1Be
      "]], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA62GLiwumF0Bc8AjsoBNgvwUV/fgG
qBdAJJJ9snsCZ7+U1M9n76kXQNyrRw/g3Gy/iHDWGw6sF0AGtDlS/RVxv30M
3c8srhdAVJA+GYwAc79yqOODS7AXQNbFwrgRGXS/NFZQFU+yF0DSNsGDAVZ0
v1zg8OuItBdAmKodpLGtc79QfPefp7YXQE+bkvKvLnK/eAaYduG4F0BQJZqK
X4pvvzq0BAjluhdAcficYQrhab8uUAu8A70XQOWWLgXn1mK/iiFECNG+F0CX
fNyAJ2pYv+4CjOiFwBdAzrajfaJMRr8p0nyq3MMXQJj6qcjHrE4/m4rz88/F
F0Co7q6+UzheP/ZbLECdxxdAXOvBpjp/ZT+EwgBcDcoXQIz/yNAyCG0/4JM5
qNrLF0By48VxKMdwP9QvQFz5zRdAvJtemnDDcj+W3azt/M8XQKYvCYtu5nM/
8VXn5lHSF0DESFdREz90P7MDVHhV1BdATdhyHfCxcz+on1osdNYXQLD5fEyk
SXI/aU3HvXfYF0CB7yQTPzhwP5HXZ5Sx2hdAxXhmsfFoaj+Gc25I0NwXQLKv
8rLaf2M/RyHb2dPeF0AAUepnF09YP0Dk2W8=
      "]], 
     LineBox[{{4.62927605051848, 0.0020096917189797864`}, {4.630935253943379, 
      0.0031482426035625895`}, {4.632887257972673, 0.004371131211724399}, {
      4.634839262001966, 0.005423903319488901}, {4.63679126603126, 
      0.006266577160624535}, {4.638743270060553, 0.006867305865676341}, {
      4.640695274089847, 0.007203580370292905}, {4.64264727811914, 
      0.0072630720653972265`}, {4.644599282148434, 0.007044083672766122}, {
      4.646551286177727, 0.00655559190108725}, {4.648503290207021, 
      0.005816881107041316}, {4.650455294236314, 0.00485678285245547}, {
      4.652407298265608, 0.00371255131174281}, {4.654164101891972, 
      0.002561749338057602}}], 
     LineBox[{{5.536018028260762, -0.0015792708124560467`}, {
      5.538102892594273, -0.002596034267703608}, {
      5.540187756927784, -0.0034984096324149113`}, {
      5.5422726212612945`, -0.00424704213049539}, {
      5.544253242378129, -0.004786056652350116}, {
      5.546650836361668, -0.005183747619514387}, {
      5.548527214261827, -0.005286425045971158}, {
      5.5506120785953375`, -0.005180741405300829}, {
      5.552592699712172, -0.004870418769792276}, {
      5.554886050479034, -0.004272427284628898}, {
      5.556866671595869, -0.003573181311256123}, {
      5.558534563062677, -0.0028740706907787053`}}], 
     LineBox[{{5.602837930149776, -0.003506940516963963}, {
      5.604818551266611, -0.004203405521143334}, {
      5.606903415600121, -0.004756263753514284}, {
      5.608988279933632, -0.005100713857871405}, {
      5.610864657833791, -0.005220018649071133}, {
      5.613783467900706, -0.005038325476479047}, {
      5.6152428729341635`, -0.004783752026950413}, {
      5.6174319804843496`, -0.004211927099665015}, {
      5.6194126016011845`, -0.0035191154998184615`}, {
      5.621497465934695, -0.0026409128966317077`}, {
      5.6235823302682055`, -0.001647918411508288}, {
      5.6248332488683115`, -0.001014968798175871}}], 
     LineBox[{{5.8415259929720325`, 0.002001267711697718}, {5.843243333879481,
       0.0011792627014408877`}, {5.844292819989588, 0.0006582715546953649}, {
      5.847155054835336, -0.0007817965868857448}, {
      5.848967803570976, -0.0016673696407160273`}, {
      5.8508759601348075`, -0.002538915695921502}, {
      5.852497893214064, -0.003207351155361894}, {
      5.85458255426005, -0.0039389619573962815`}, {
      5.8566958376544935`, -0.004504274301328326}, {
      5.858508586390133, -0.004828403849119851}, {
      5.860321335125773, -0.0049925979792184326`}, {
      5.862224721298195, -0.004987092643500367}, {
      5.864442953303649, -0.0047515748548142235`}, {
      5.8663320283018425`, -0.0043649810554787175`}, {
      5.868049369209291, -0.00387715918379073}, {
      5.87043456491408, -0.0030127167224559895`}, {
      5.871865682336955, -0.0024080488240846615`}, {
      5.873583023244403, -0.0016183230519683793`}}], 
     LineBox[{{5.974027968437589, -0.0016465193695078834`}, {
      5.976093041328, -0.0025686071716777394`}, {
      5.978059777414105, -0.003344356079055571}, {
      5.980130025925795, -0.004019313067890697}, {
      5.982200274437485, -0.0045205681824064346`}, {
      5.984374035374759, -0.004836520757408662}, {
      5.986340771460864, -0.004924376889692287}, {
      5.988514532398139, -0.004798513784754517}, {
      5.990481268484245, -0.0044878570586925565`}, {
      5.992551516995935, -0.003972655181581595}, {
      5.994621765507624, -0.0032864946127216725`}, {
      5.996588501593729, -0.0025032618471480137`}}], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAWlyUrbzjGEDo9jn1575EvwmQEQC0
5BhA4JlSaPgvUb9mVjH7W+YYQFw9HfnQb1y/314GSpHoGEBMSD1BaRNlvx9a
6lSq6hhArnoDFxunar/Sb7Dn++wYQPBX+7fJem+/S3iFNjHvGECmUuaqtEhx
v8SAWoVm8RhADiAuwRwHcr8+iS/Um/MYQNZITyVZ8nG/t5EEI9H1GED6m71H
MQ5xvzCa2XEG+BhAAKZtb1LQbr+qoq7AO/oYQLoIv3xtLWq/I6uDD3H8GEBk
uuHeB3Bkv5yzWF6m/hhAsHo8JznBW79qlFrhhgAZQCYVMpOdkE+/SkEE7IoB
GUBK7gKGz0hCv3rnudJ+BRlAbJ63SBhmUD+B1ayZewcZQJBqyT4NRFw/+t2B
6LAJGUD6EzJH7QRkP63zR3sCDBlA3N2Tj2YraT/t7iuGGw4ZQMhmwCEexmw/
ZvcA1VAQGUBgg08ccmhvP+D/1SOGEhlALPuD5mNtcD9ZCKtyuxQZQJp4OWdh
mXA/0hCAwfAWGUDgn2Z8ck1wP0wZVRAmGRlA2Fv8YRRRbz/FISpfWxsZQOio
m6gppG0/dzfw8awdGUCMQTaie9xrP7gy1PzFHxlAJAafm5ecaj+/IMfDwiEZ
QLukhoTBFGo/pRXYbw==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.28067691679237217`, 3.390868220493906}}, {{
     0, 6.283185307179586}, {-0.28067691679237217`, 3.390868220493906}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, 
   3.6844501088597307`*^9}]
}, Closed]],

Cell["Make  a \"frequency domain\" plot of the coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "4"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "\[Pi]"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "0", ",", 
   FractionBox["1", "4"], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"9", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "6"]}], ",", "0", ",", 
   FractionBox["1", "8"], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"25", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "10"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.539348900461853*^9, 3.539349025162924*^9, 3.592056900794857*^9, 
   3.59205693153894*^9, 3.59205709743393*^9, {3.65399455589922*^9, 
   3.653994564692024*^9}, {3.653994603096509*^9, 3.653994613952845*^9}, 
   3.654948610036271*^9, 3.684450108919166*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"ChartStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Re\>\"", ",", "\"\<Im\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592056964512083*^9, 3.592056985563291*^9}, {
  3.592057062331558*^9, 3.592057071627198*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.3020588235294117, 0}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.616], 
     Thickness[Small]}], 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5404411764705882, 0.}, {1.4595588235294117`, 
            0.7853981633974483}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{44.200605242096835`, 
           74.75738054321049}, {-120.6882902111151, 22.90563888928169}}],
         StatusArea[#, Rational[1, 4] Pi]& ,
         TagBoxNote->"Pi/4"],
        StyleBox[
         FractionBox["\[Pi]", "4"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.540441176470588, 0.}, {2.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{76.7663767697085, 107.32315207082215`}, {
           22.280638889281693`, 22.905638889281693`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5404411764705883`, 0.}, {
            3.4595588235294117`, -0.3183098861837907}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{109.33214829732016`, 139.8889235984338}, {
           22.28063888928169, 80.8487633714004}}],
         StatusArea[#, (-1)/Pi]& ,
         TagBoxNote->"-Pi^(-1)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "\[Pi]"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[(-1)/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5404411764705883`, 0.}, {4.459558823529412, -0.5}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{141.89791982493182`, 172.4546951260455}, {
           22.28063888928169, 113.92248598881318`}}],
         StatusArea[#, 
          Rational[-1, 2]]& ,
         TagBoxNote->"-1/2"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "2"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[-1, 2], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{4.540441176470589, 0.}, {5.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{174.4636913525435, 205.02046665365714`}, {
           22.280638889281693`, 22.905638889281693`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.540441176470589, 0.}, {6.459558823529412, 0.25}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{207.02946288015514`, 
           237.5862381812688}, {-23.22778466048405, 22.905638889281693`}}],
         StatusArea[#, 
          Rational[1, 4]]& ,
         TagBoxNote->"1/4"],
        StyleBox[
         FractionBox["1", "4"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 4], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.540441176470589, 0.}, {
            7.459558823529412, -0.035367765131532294`}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{239.5952344077668, 270.1520097088804}, {
           22.280638889281693`, 29.343763831739324`}}],
         StatusArea[#, Rational[-1, 9]/Pi]& ,
         TagBoxNote->"-1/(9*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"9", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 9]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.540441176470589, 0.}, {
            8.459558823529413, -0.16666666666666666`}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{272.16100593537845`, 302.7177812364921}, {
           22.280638889281693`, 53.244587922458855`}}],
         StatusArea[#, 
          Rational[-1, 6]]& ,
         TagBoxNote->"-1/6"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "6"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[-1, 6], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.540441176470589, 0.}, {9.459558823529413, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{304.72677746299007`, 335.2835527641038}, {
           22.280638889281693`, 22.905638889281693`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{9.540441176470589, 0.}, {10.459558823529413`, 0.125},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{337.29254899060174`, 
           367.84932429171545`}, {-0.47357288560117894`, 
           22.905638889281693`}}],
         StatusArea[#, 
          Rational[1, 8]]& ,
         TagBoxNote->"1/8"],
        StyleBox[
         FractionBox["1", "8"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 8], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.540441176470589`, 0.}, {
            11.459558823529413`, -0.012732395447351628`}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{369.8583205182134, 400.4150958193271}, {
           22.280638889281693`, 25.22336386856644}}],
         StatusArea[#, Rational[-1, 25]/Pi]& ,
         TagBoxNote->"-1/(25*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"25", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 25]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.540441176470589`, 0.}, {
            12.459558823529413`, -0.1}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{402.4240920458251, 432.9808673469388}, {
           22.280638889281693`, 41.10900830918799}}],
         StatusArea[#, 
          Rational[-1, 10]]& ,
         TagBoxNote->"-1/10"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "10"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[-1, 10], {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[
    StyleBox[{
      {Thickness[Tiny], 
       LineBox[{{0.3020588235294117, 0.}, {12.702708823529413`, 0.}}], 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, 
      StyleBox[{
        {Thickness[Tiny], 
         LineBox[{{0.5404411764705882, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {0.5404411764705882, 0.}]}],
          LineBox[{{12.459558823529413`, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {12.459558823529413`, 
            0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
           LineBox[{{1.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.4595588235294117`, 
              0.}]}], LineBox[{{1.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.5404411764705883`, 
              0.}]}], LineBox[{{2.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.4595588235294117`, 
              0.}]}], LineBox[{{2.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.5404411764705883`, 
              0.}]}], LineBox[{{3.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.4595588235294117`, 
              0.}]}], LineBox[{{3.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.5404411764705883`, 
              0.}]}], LineBox[{{4.459558823529412, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.459558823529412, 
              0.}]}], LineBox[{{4.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.540441176470588, 
              0.}]}], 
           LineBox[{{5.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.459558823529411, 
              0.}]}], LineBox[{{5.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.540441176470588, 
              0.}]}], LineBox[{{6.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.459558823529411, 
              0.}]}], LineBox[{{6.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.540441176470588, 
              0.}]}], LineBox[{{7.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.459558823529411, 
              0.}]}], LineBox[{{7.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.540441176470588, 
              0.}]}], LineBox[{{8.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.459558823529413, 
              0.}]}], LineBox[{{8.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.540441176470589, 
              0.}]}], LineBox[{{9.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.459558823529413, 
              0.}]}], LineBox[{{9.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.540441176470589, 
              0.}]}], LineBox[{{10.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.459558823529413`, 
              0.}]}], LineBox[{{10.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.540441176470589`, 
              0.}]}], LineBox[{{11.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.459558823529413`, 
              0.}]}], LineBox[{{11.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.540441176470589`, 
              0.}]}]}, {}}}, 
        StyleBox[
         {Thickness[Tiny], 
          InsetBox["\<\"Re\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
           Automatic, {1, 0}], 
          InsetBox["\<\"Im\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
           Automatic, {1, 0}]}, "GraphicsLabel",
         StripOnInput->False]}, "GraphicsTicks",
       StripOnInput->False]},
     Antialiasing->False], "GraphicsAxes",
    StripOnInput->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.3020588235294117, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
       FormBox["\"Re\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox["\"Im\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.592057072075521*^9, 3.592057097646439*^9}, {
   3.6539945560734167`*^9, 3.653994564849016*^9}, {3.653994603235777*^9, 
   3.653994614082698*^9}, 3.6549486128139677`*^9, 3.68445010908497*^9}]
}, Closed]],

Cell["Re-write the Exp series as a Trig series", "Subsection"],

Cell[CellGroupData[{

Cell["term2[0] = term[0] //ExpToTrig //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{
  3.539348901072105*^9, 3.53934902523506*^9, 3.592056900871686*^9, 
   3.592056931675244*^9, 3.592057097671525*^9, {3.6539945561216993`*^9, 
   3.653994564877943*^9}, {3.653994603372724*^9, 3.653994614166765*^9}, 
   3.654948617597234*^9, 3.684450109269491*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["term2[m_]= term[m] //ExpToTrig //FullSimplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", "x"}], "]"}], "+", 
   RowBox[{"m", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
  RowBox[{
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901338854*^9, 3.539349025465629*^9, 3.592056901077137*^9, 
   3.592056931864159*^9, 3.592057097861994*^9, {3.653994556335165*^9, 
   3.653994565006339*^9}, {3.653994603495202*^9, 3.6539946142942657`*^9}, 
   3.654948620062367*^9, 3.684450109490156*^9}]
}, Closed]],

Cell["series2[n_]:= Sum[ term2[m] ,{m,0,n}] ", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["series[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"6", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"18", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "5"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"10", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"5", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"5", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"50", " ", "\[Pi]"}]], "+", 
  FractionBox["\[Pi]", "4"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"8", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"32", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348901508812*^9, 3.539349025532612*^9, 3.592056901121194*^9, 
   3.592056931985405*^9, 3.5920570979048*^9, {3.653994556759735*^9, 
   3.6539945651973667`*^9}, {3.653994603566409*^9, 3.6539946143891582`*^9}, 
   3.654948624824272*^9, 3.684450109565462*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["series2[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "4"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"4", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], "+", 
    RowBox[{"3", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"9", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "x"}], "]"}], "+", 
    RowBox[{"4", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"16", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", "x"}], "]"}], "+", 
    RowBox[{"5", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"25", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], "\[Pi]"]}]], "Output",
 CellChangeTimes->{
  3.539348901647589*^9, 3.53934902562461*^9, 3.592056901159855*^9, 
   3.59205693204438*^9, 3.592057097944783*^9, {3.653994556831818*^9, 
   3.653994565364707*^9}, {3.653994603636812*^9, 3.653994614428404*^9}, 
   3.654948626578991*^9, 3.6844501096477003`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"series2", "[", "5", "]"}], " ", "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"225", " ", 
    SuperscriptBox["\[Pi]", "2"]}], "-", 
   RowBox[{"1800", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "-", 
   RowBox[{"200", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "-", 
   RowBox[{"72", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}], "+", 
   RowBox[{"900", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{"450", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], "+", 
   RowBox[{"300", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "-", 
   RowBox[{"225", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], "+", 
   RowBox[{"180", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}]}], 
  RowBox[{"900", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901716475*^9, 3.539349025693151*^9, 3.592056901169058*^9, 
   3.59205693210773*^9, 3.592057098009361*^9, {3.653994556897757*^9, 
   3.6539945655319557`*^9}, {3.653994603705914*^9, 3.653994614503924*^9}, 
   3.654948629062478*^9, 3.684450109730382*^9}]
}, Closed]],

Cell["Verify that they are identical", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"series2", "[", "5", "]"}], "-", 
   RowBox[{"series", "[", "5", "]"}]}], " ", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539348901862293*^9, 3.539349025783277*^9, 3.592056901228616*^9, 
   3.592056932189663*^9, 3.592057098170868*^9, {3.6539945569647207`*^9, 
   3.653994565644332*^9}, {3.653994603768785*^9, 3.653994614569409*^9}, 
   3.654948631890818*^9, 3.684450109816341*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 1: f[x_]=x  for x=[0,2 \[Pi]]", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=x;\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349040775506*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxWlM0mEcAGAED7zBg2ImQiYujBZmWyszz5kVhsy8IiUzmzVBseW8Zqaj
Wqb41zHd1FYmZmqajmyT1Apqfilq0TEjTUXTZHN5NUGoPvh7Pzx7GJli/gU8
Dofj/vN/wojT2+kDFWFb0yl0Jq0+4+jWq3pZ/FdMDE9GjE09xcphXYGhux2r
hbXVy+QW7C7MbSpWN2K9cLXfcIscG4EX1u2tEQVa+OBmHW8g7ws89j2lEu8/
CYdHJpoUmTNwWl7ckjL1JzzMYF0fbV+EExtZbXrREuxj9zxKlv0bvrFf0z96
cwWOiT0uVEjXYM2tFWZV8R944Y6XaqJxAz5X+KR2CTPDZTvVnPJBC7zXUraG
z8GFb/3mbMoyPcsG5rTmfi67goejE16kKSUEOMhwShMktYUlpPzQ1gY7+Pxj
Lf+XzB5msi/zCu87wPW0aKP+HhEWdvTKw5sdYRw5KXCqywmOMx5KTu90hrMe
pYmoKhf4h8UF0465wvavNxMzNW6wNXe3NfiTO8xTx+0SXyLBCb7H3kXOoVWz
00aliAyXzNMEFCO6TbB+hHLVA6Y7isWENXS8zb4OUYEnbMip4ReZ0Frnam5+
sRccQAtUEW29YVapM4d2G13lWbtKd6TAsT597Fd16HRBnpJP3gYz54uihDXo
5Fl6jCtlO6zfcVHe0YBOCgg1fJOjtWxyiEcT+mXY0PvSFvRDobsrX4GWPBis
NA+iHfYQ8xPG0ddC9CNSPXojtN9NNYFe5Aq6mTPoD+K+OdMiunkgJV1hQXur
2D3jOCpco8abSQR0ha67qcQBnb2O0/FI6Emrzl/qgU4ldkmGvNAnqadJTCpa
w2BlnPFBh7GsPTJf9LPgj2aNH5pzuPOEiYH+CwXPEkU=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 6.283185178951315}}, {{0, 6.283185307179586}, {0., 
     6.283185178951315}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.539349041386338*^9, 3.539349043487687*^9}, 
   3.592056901415043*^9, 3.59205709853264*^9, 3.6539955922417393`*^9, 
   3.654948434833316*^9, 3.654948654034005*^9, 3.6844501301709003`*^9, 
   3.684450193408606*^9}]
}, Closed]],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["c[0]= 1/(2 Pi) Integrate[ f[x]  ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{{3.653995247190421*^9, 3.653995252684225*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData["\[Pi]"], "Output",
 CellChangeTimes->{
  3.539348898608249*^9, 3.539349024083955*^9, 3.592056900043282*^9, 
   3.592056931073666*^9, 3.592057096800711*^9, {3.6539945554408913`*^9, 
   3.6539945642812357`*^9}, {3.6539946025558243`*^9, 3.653994613374568*^9}, {
   3.653995261515519*^9, 3.653995288050729*^9}, 3.6539956307376213`*^9, 
   3.654948437927692*^9, 3.654948657305644*^9, 3.684450130251532*^9, 
   3.6844501935171013`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
c[m_]= 1/(2 Pi) Integrate[ f[x] Exp[- I m x] ,{x,0,2 Pi}] //FullSimplify\
\>", "Input",
 CellChangeTimes->{{3.653995280749373*^9, 3.653995281907378*^9}, {
  3.653995637266789*^9, 3.653995637423542*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]], 
    " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], 
     ")"}]}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348899882002*^9, 3.539349024467109*^9, 3.592056900477057*^9, 
   3.592056931261525*^9, 3.592057097008535*^9, {3.653994555571148*^9, 
   3.653994564408968*^9}, {3.6539946026898823`*^9, 3.6539946135026283`*^9}, {
   3.653995261668816*^9, 3.653995288137599*^9}, 3.653995639010181*^9, 
   3.6549484402127047`*^9, 3.654948659213005*^9, 3.684450130471244*^9, 
   3.6844501937487507`*^9}]
}, Closed]],

Cell["term[0]= c[0];", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["term[m_]= c[m] Exp[I m x] + c[-m]  Exp[-I m x]  //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], 
       ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "m", " ", 
           "\[Pi]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], 
          ")"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348900096125*^9, 3.539349024623434*^9, 3.592056900596742*^9, 
   3.592056931376429*^9, 3.592057097120233*^9, {3.653994555646126*^9, 
   3.653994564481369*^9}, {3.653994602805489*^9, 3.6539946136003237`*^9}, {
   3.653995261752285*^9, 3.653995288223474*^9}, 3.65399565126302*^9, 
   3.6549484441370363`*^9, 3.654948663543749*^9, 3.684450130648242*^9, 
   3.684450193922646*^9}]
}, Closed]],

Cell["series[n_]:= Sum[ term[m] ,{m,0,n}]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Plot the series with different numbers of terms", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Plot[ Join[{f[x]},Table[series[i],{i,2,5,1}] ] //Evaluate
  ,{x,0,2 Pi},PlotStyle->colors]\
\>", "Input",
 CellChangeTimes->{3.653994609851053*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxFxWlM0mEcAGAED7zBg2ImQiYujBZmWyszz5kVhsy8IiUzmzVBseW8Zqaj
Wqb41zHd1FYmZmqajmyT1Apqfilq0TEjTUXTZHN5NUGoPvh7Pzx7GJli/gU8
Dofj/vN/wojT2+kDFWFb0yl0Jq0+4+jWq3pZ/FdMDE9GjE09xcphXYGhux2r
hbXVy+QW7C7MbSpWN2K9cLXfcIscG4EX1u2tEQVa+OBmHW8g7ws89j2lEu8/
CYdHJpoUmTNwWl7ckjL1JzzMYF0fbV+EExtZbXrREuxj9zxKlv0bvrFf0z96
cwWOiT0uVEjXYM2tFWZV8R944Y6XaqJxAz5X+KR2CTPDZTvVnPJBC7zXUraG
z8GFb/3mbMoyPcsG5rTmfi67goejE16kKSUEOMhwShMktYUlpPzQ1gY7+Pxj
Lf+XzB5msi/zCu87wPW0aKP+HhEWdvTKw5sdYRw5KXCqywmOMx5KTu90hrMe
pYmoKhf4h8UF0465wvavNxMzNW6wNXe3NfiTO8xTx+0SXyLBCb7H3kXOoVWz
00aliAyXzNMEFCO6TbB+hHLVA6Y7isWENXS8zb4OUYEnbMip4ReZ0Frnam5+
sRccQAtUEW29YVapM4d2G13lWbtKd6TAsT597Fd16HRBnpJP3gYz54uihDXo
5Fl6jCtlO6zfcVHe0YBOCgg1fJOjtWxyiEcT+mXY0PvSFvRDobsrX4GWPBis
NA+iHfYQ8xPG0ddC9CNSPXojtN9NNYFe5Aq6mTPoD+K+OdMiunkgJV1hQXur
2D3jOCpco8abSQR0ha67qcQBnb2O0/FI6Emrzl/qgU4ldkmGvNAnqadJTCpa
w2BlnPFBh7GsPTJf9LPgj2aNH5pzuPOEiYH+CwXPEkU=
      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwd2Hc8le8bB3D7LNs5B4Ws6IuWEQn3RSGpjCQtRUbIyIpsFZpGKCMkZSSi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      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwd2Xk8VV0XB/A7IMN1B9yBShIRmkjJtFeGSkkyJ6WkR0lISEhSFAlJQopU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      "]]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVmnk4lF0Yxu1mxjYLY5QkRZKlUCR1HqSNRCFFJUSJyhKShCTZkrKlkArJ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      "]]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVx3841AcAx/Fbca6lPSmFnoW2PS2GstYoz3zOj6W22DmUulPWQ/P7txtH
Y/rd/LyTJHKtQlwPR6uFuOqWI3R3DnfuvjdCCYvza7nC7I/3835eW45H04NX
kEikvcv9/5XNH3YO7vrV2dDDqkK3ZRXVcqPlVnPuMbjb2Kef0lGos0Sul5IT
DUPKwCPDLgq136X1xT1OGgpzn2775DSF2h0/zL/FycGZDUeNgl4aUCWZ00Yl
nFIUW63N4VWRqZ5X2KJCTjWyDyc3KZ30qJkWTSUFnGaYfmW+n75+CXufXbUX
rhFis4JdQ4gW8fSsv/EuuhAO+oZ+t1iLaFmQKs1VQjxMSZgZ71uAeEwUNDX+
CF0TaddYZe/R1lLJvrJWhIN1KUsO3+nQkcYqe3VIjHrBm3OebbPwctp5gVks
Rsc4mUY5M4vOuYlwab8YNxN8+WbUZUeG2jeEtoJVTtd3uz+DTgazMTulDeuk
364X3Z6GxMFVtqu0Hdwn3gJTnhaj/5KXXOIloHFjHF/zx7D0qafIgSuBuTWJ
scl1DMY07gXbOgk2L8VW6ClGgQoLY7NpCfrXLGkNyKPI93e0moyTYu5iS5cm
bATOD0J9rsXJcKx+zWcx/sPwGa42zefIEMZuUWfODyHEaI64UCuDJjJ1ddTV
IXBDM0ISp2SIetxqmz4wiBGzqycPxHWhuJxzepr1Anns9nJdrBy5idvDTHL+
RlnZusjJPDmei0keP45q0Cjz//KlQI47tPU73D00eGk93CjVylGYs2qfQp/A
HtWCtCK2G+K5qQ+8Cvow5LT9/cHYHhzyLPVe0OvB/E+Jjw7k9UD3+In+NnY3
PspvOOsq6MElgdB9dlKO3eMeRnbaHih8TZRJg13ILg7cqh/bC63p4mZbtRSO
C3m0uhgFhPujS2Yc27EnNewyJVcBSUZmw27mMzi9c9UEVCsQlNzbW5HRBuf5
6XDKGwWmhoRVekox3Gb9zgWEK2Houv+XO1V/wT3BrrP2ohKWo1W8b0ZE2DtN
3kCpVCK/u7xl9nMR9mnv/147osTHSREu6prH8PrHrMngRB/ezsTvGJI0gxYx
pRdwpg+KSznPg1Ob4D3W9n3tzT7YNIedsrV7CN/XKUrmYB9Iprcizt+sx5Fh
YkYQqEK6zQ2dg/oPMIPuORmkq8BHR9G9B3cRMJidwSxVwX0ijRVeUofAAaw1
0KgQ9IbhFPWzAMHE9S+YDDX2Ecbj5mOVOMFkxwnYapDmWs0nKbcRoqI/IBep
UWjB4q7YWY4w5UoPgUKNpHerf5BV3UCEvzqL/FaNwMVX/AzddUT23pUzTAg4
3l9gH/HjIaY7+Dj5IIHAw/zA1qNFiPN1vs1IXLYbqcQo4DLiuzZO1uQT6N9k
WxAdn48E+sTX5LsEJkV21vLreQiNtcgelxOw5EkriN+ykETjiWqmCPB8KpXD
meeR/DxpNXmdBrzKNr9NyafA9vKmM+w1IDUMZf1pdRIFWeykbE8N0rVFDDE/
Af8BltE+Lw==
      "]], LineBox[CompressedData["
1:eJwVl3k8VN8bxy0ztjGDmTEzJKkoobIVIedJijYiW9okSb62ZClapAjZQwhJ
ZStrkaxZSklChSTJluzrjC39zu8vr7d777nPeZ7P53PurLV1NT3Lw8XFdYTA
xfX/v15DZaTR8W7Epf/eOnKTV9Wteh29fOGfCC6vfe/IfbXq9puxT9YHfiKu
R8uO04oBVUH6bxn5jpjrW+IO6gRVhdSmnCCG4PuH7hrnSt+puqPn/dg6C1+/
vKIMn8OqQquNR/Le/UQ9RbKl4psjq8JBXpU49BNp1t3lNB6Nqnp3yk8nh7cH
9fCfFvzuGl1l+GD0pyWtB022WXmau96tet9tdZNnfQ/islskm1rFVFk0aopz
q/cg5fJNCq+0Y6v6X7Ey/uljji4t+kmIq3LPmNdcMcf8Gb3qfR5XxRXb0bBs
34NYr5we/zS8VxXuX3J8yRuvx9x9aLb2XpWUW/z4QlAPsnmCJnTl4quyT1zy
m0/oQQK7byl0O8VXaR6wonKye9Dh7Vy8U4nxVW81NR/PlfUguBD3My4vvsps
A2v7bGMPchjYFTyRHV/VS5uvn/7Rgy51ayisCouvcuXuODo13oNe+woc0rKI
r1oefzky8a8Hyeyp+O7MF18V0nXv6rjoL6TcPifdnnyvitXgLTK29heKrOOp
uCd1ryr9peXDEdVfiJW4UtLiH1el/kRDbXj3L2S4auBCRnNsVU00882Q2S+U
WZL5UJsvtuqwH8fi99lfyA32Hi9YH1PV7dw+NOD1C3V8b6Mobbpb5XTspU//
bfy8Seq1T4zoqkXDe8J98b9Q/P3176pGI6vEZS2Ve0p/oR6NB2Kqj0Or0sQ0
aro//EKvZVe/v1cbXKX8j2H2owvXe+ROTeWLwKqDnW3enSu/kEyLq/J1sl9V
Z32x4DeRXvQ67/KmMyOXqhyK4u63y/Siw/pnN+eevlDFTvPa3KbSi1KPbR5m
L9tWpTXvODqxvReBySkfj53Hq/5zGvsv2xqzxfNat4qzyJNn/tLJc5gbD8nw
JF1AW46yPZo98fPOT8W7/S4j3strwzNv9yJW4IlTTz/cQPvVi+M/3utF81rL
l9JvBaKOtXEKjZm9KMiw4H5F+h00s2xu9L6hF+koTL5NU7+L/Ia39dR/70WR
mZcrbhPiEKVD3P3taC+yEpmYIf2JRwrPv8bWUvrQ4VW/TxlOpCDb8+Y/Kkz7
ENWg99LE3BM0abHNtfxMH9Ie+FDBl5uBrumLc5d59KFTxS8KX7tmocQ1X2VL
4vpQjaT1cq1IDmr5auZU2NmHSgZJCQ2nChHomS2l2/Yjn492W7UHStE8Q17j
pns/qrGLMPWYK0MFI0vup/z70bpzNu0gWIHWxT4aZqb1o0u6LZHO2lWId2j6
W9CvfmTrMHf9Zn81ehsWVeJoM4CoS5u0LF+/RYe+NXluOTmIfury5LLqmxFf
blqBkMsgimy+aL6yrgVV+nuNDV4dRHsS9RwuX29BW5Skzz5IHkQx90/nymm1
ItHrzmaiPwaRZlXSO5Hiz+iLrLDa9LHfiM87K3b6TRuydts3WXR0CAWpTDTt
Uf+BZGYiJQcdh5DXzvnWT+k/0IBnhz7jyhDSZRuGZ0t0IzffcwleKUNI7cqW
R3u4fqLAwAA9jb4hZHjx3bUTDj3oeVJ1TInTH0SRWJ3G2dmLhN/v2FF2fRit
3ArJ2TYzgFoP3DgzEjmMisd/Pbu7ZRDda3oXtiptGH1xDrMYPj+I1n2x7PWt
G0Z3GWnSV3pw3T897+gIjqByVrQ86eNvdHau4EdF9AiqunJm9dO0P6hyrYL/
6yejSPpWPBe/xhha/KjlnFo8ih7XOqyfcB5D23wOWPnVjyKztXeish6PoWet
TlvgzyjysHPcHCU2ju7fzOusUhpDT5v6uET+jKNLA+pqVc/HUEN9nu7c3kmk
loX6K6rH0bAewdLpyxRyMT/8Kbl1HH395pC1enQKZXOfLr3aN45qj9auz+ad
Ruus/SN3EieQzJq6LUdUp5Eo6Y1OheEEejhO3dMVNo3GnfbHln+aQLtNPwbe
2jmDzOIVHv1wmUQJ0uS4g1dnEX/vM+dyr0l0e5XuybjwWVSquFXz/rVJFLeL
yil5MItkqtQ+WoVPosbzwAyqnkVjAzqczzmT6O3DPaX7eedQoJrxgYbRSfTZ
7VHU/utzaMfVFvGsWbyeZsEJevgcGn17pOf28iS69+ruhaKkOWRqbeW5R3gK
bflzcfvVV3NozY3TD14rTqErx9ida6fmUEnTxZlixym0e27CqcSKjf5jsSti
3aeQwOVtytN2bCRteynIw2cKDS/pfua5wEa35q6sVg2ZQuG/5N5kBrGRiVSg
QU7WFCImOI3yF7MRwV6AGlowhS6YH9VaeM1GJXkhXY6vppBSEjm5+gNeb3fE
Bfn3U+igQ/Cn9h42Gj4ff//R0BR6dDvNcZUgByU/l7T3n5xCMWS1b2+pHHT4
b5Ly6fkpdHaVzNd9UhxUHPnwjbTANLruNV7XtoWD/F9mTyRsnEZEhvAoxZSD
VhErdkfaT6OsM9zfKFEc9EXuMlHCdRqphIix2+M5KHzvtvqH3tPILoYceDGV
g3iCcvY/D5pG2r++v1iXx0FDQikmbdnTqC82MsK+gYPSFK1pp55PI1vJJ1fe
NXPQ8YOMr7/LphGrJvb8ShsHfQoLt1ponEbp6X9lfvfi+kSvn5KamEbtSc7W
hfMc5KaivfYJZxpFm5lHl/7lIAVTTu9mrhlk41z5OJ5nHiXfdbVHYjMousHq
eDtpHlm8UJR/JzGDzPk5AZqi80j06+8/h9fNIAnukWg3+jy6xbBxtlWbQYon
yv6zl5pHuhpSW0e0Z9CISGmdrMw84lh2TF7Un0FSxw+tKls/jxwTDnsEmM+g
W/bE324K80i2VHg75eQM8gx+MhW5eR51d77jxNnPIC7pD7IhyvN4nrt8M71n
0Lr92VqC2+eR0M6/Oip+M6hg37fSCM15VHfi1cqroBmU5uqeMqk1j65d83yt
FzWDKrXitivtnEeaD1T8PyTMoM7V5l/10DyarhrbbZY2gyZtnn1U3zWPnvZk
EX9kz6CMv/4XeXbPIztu+/qzz2fQbu/0Vc/055H0unXB42UzaDynfpXq3nnU
ode937sOr5/j3RBjMI+izyQKc32cQSaXZa9/MZxHB29ZNAV9nUGazeLRU/vm
EfEJNVKsewZpTZ0/Prp/HlW+aTJJHJxBUVZUzTcH5tGlwRDa+okZpOrTfP3K
wXmkym/w9SlnBqFLqhHUQ/NodCPvPXWuWZTxNaLmNuZ0wyqrCoFZtEuOz7sL
s815X8m9YrMIFXkKiRnNI8kQja4mCexbjWvf5TB/zp5Jtlw3i6ztfPetwhz6
Ie9Uj8IsKn9w48UUfn7v6H9rz6vNort3ra9mYeYiy/dNac+i1sYbxN2YSzf3
P/bRn0WyR9bmVeL6PIxS7XkP4ffrUn5IYd7selw+1HwWHTd8M30C72cwgjVM
PzmL+k6cM/PH+03N//I02X4WvVcotg/B/bDGx9AG11m05YlohBfuF3364NY8
71mUH+uqZoD7eVvtTeHrILy+ltCde7j/bQa++0oiZxElRc5SFc9H9rhKT178
LLKJzAspxvOruZVMfpA5i0jBelev6M4jsYQjj+PyZ9H3oZ+/K3Vwf3IEtcNL
ZlFJiIjYKNbHyldPh6vvZpGE5LlFfo15dGhY8Z9H8ywatBM7z1GfR0krv2Kd
OmaR25NDM62q80hro1HtsaFZZMpULDPeMo+8Lm2Q1hKYQy5/vJvOy86jN6Fd
L1REcW6dM/tYuxbv52H0gU2sOdS4ozVfeM08Kny/coklP4cYDpYRThLzaFyy
/TPbYA55NXxNdCHPI/uK28HPb88hK/3VtMZpDipq2SnzNGIOvR1L3oQmOIgw
OFOcdm8O7Wl0+JU+gv1PsemPyphD2az2TPN+Duo+pYnc6ucQSaTzrdZXDrLg
+TOrxM9GLLpJt0cRB+0x2G+THshGd9yMLdXdOch40q7dM5yNYs5sOUd04aCj
CdeN9sSxkc3ygadt5znIeeSFTv8TNvIlyW7wPc1BsRFrJNa9YaPjz7zVvh7m
oIH22ZZkXg5yuLLjEFOZgyb8RPY5kzjo3OHObTQlDlrYpPBah4avT46F0eU5
iHzlVO73dRw0aL2jRV6Gg7bJNIRI6HGQgSH/xVRRDgpweLA71o+DWsXVzovN
sFGEWGmpXRCuy8suKXiCjRJKv6ioR3LQOtWPG4VH2ShHWEjm8wMO8l5tcVFl
gI2+5nssi1ZxkNd/QfOEDjb6eTTiYs9bnMP/SkkdX9joD0/2cF4TBwmm2dS+
bGGjv2Y/O4y68XunVu1Mwfkvt7CvKBTnYMdMj6AIPh+2ptkpHSfOoxe192eM
Kthox4HrjxTxnIpjXucml7LRoeQXUQ0457ZGf3ziUMRGlns/CSRiHTgn3Lcf
KGSj0xN/rp9XmkfHLibxuOezkeeuNS4CWIcMv/5PZU/Z6PrwjoF2rOPB+Hs3
LmexUfBds+MZ2DcK4aYihhlslDwQvH/vsXlU9eP4K9YjNnoTPLvhlg/WuQCZ
K+I+G7UJ7ov96z+PKJNfSMUJbDQYnMzrfQfn1n+/VWbusRFHcPrC5F1cr75i
+V48V4GQvT3nk+ZR5nLmTH4M1oXQfaO+x/PoMDFYRvUuG20KmSg/njOPLhKo
IQ1RbLQ/JD7BuHIeaex6q6gXwUbWQmP879/Oo8fBfONrsW7+C9nlpfdpHu26
x+CWDGOjK0Jx/WXt8yhksTRDIZSNQkOGTbf1zCOzR43rze6wUZIQqs4dmkdr
rTSK40Lw/ELubpWfmkdK2+ZTpoPZqFJoKPnhwjxSU5Na7YC5KURHeBXPAuIv
rnTh4PO8WyjKJ0ZoAS2tE2hJxTwRMjBEpi3g70wlPzvMXCQty9urFpCwuONL
Pcyid8LfcMkuoEvrBQq0Ma8l9an5KC0gv2jzdGPMqnc00mbUF1BdQcana5j1
SKGizjsXkMyKld17zEfu9Fwb3LOA3CfqE7fieuxI28ZOGS2gY03mmQWYPe4E
H/tmsYDo0WerjfF+Akjd701PLSC1t9YSQni/cXdUNRvPLaD8S/G9PZjTSbfT
97gtoJqtfkZfcH9e3vlOr7q0gHiG3ML6cf/ekZRvat5YQBmSb5vEcL877tya
KgheQNUf2uB4JBsNkb6dUoxeQO2ps6J1eD4LdzY3PU5cQNb/HP/bh+cnJOyv
I/1oAcWpXfMdxfOVDG3Lvvd0AaU9cPwvB89fQVhRQuzFAro6fcYuNJ6NtEOv
3w4pX0Ah52LCgxOxr0Pl7a5+XEDdLFHqzxQ2chK+2sr+uoCat/sUazxko6uh
LeDWvYBuTVuuy8N6TAn1WX1mYgEJbJP9vpjJRnnCn+50cRbQ6+kPjp+wvl+H
rl8051pE24utDGpz2ehXaGObodgiMrw1ayOI/TItvHZPjcQi0qjc23GshI14
wjyfa69bRB/jecWaythINkw6covaIrpyP3ortZaN7MPc9tHNF9G8s2Ltqs9s
5EV+8zLsxCJiZp6fcGlno9thEhv47RfR6COuu73f2SgzrIZn0WsRDd7oDVTE
+TAcRi//Gb+ItpUof9mzwEaR3Gf+1acuoqZvl77tWmGj7Z4FevmZi0hnn36A
Nc41/+NG7/1KFhHptOP4LzIHSSgGta3tWER6nR1P98lyUGVKm4RQzyJ6MNoY
oajAQXZUuRPTvxeR16DpLgWch/kL1X01HHxd1FTsmg4HGb5bmjzDXELX//wz
v27BQePa+9UPrllCo5N8yQYnOCgmL95bfeMSIt07+kTJjoN64ratEDSWkKpw
Zv9BnNfeZ11J6RZLiHh974mBCA5K5+mTG4pdQnGtkOaMv/8Oeqmcb05eQnYf
hfr+dnDQ9J/rz0qeLCHfialt2b84SLdFSi24aAlNfr31wWKGg74+sACFr/j9
G+eS/zLnEWFng7UTfRmZqKwpcbGfR6e9CyImo5fRX01pSRnmAqLU7Gjwv7+M
kKnSKV7sq1LhGoL442W0blLciVdlAVHTWi/vKFpGWkoN1KMHsK8aZ874ty+j
Y7wl38ywruXXbdekS/1FA0mU5hPTC2iisbRH48lflCpnZS6I+3Z1XZ3K9Zcr
qP6irI0+6S/asnKVzXOeCxYWNYJiG7ng2bkLLhNOXNCTWfRh8AsXKLbYDX53
44I34p/eq/3gAvnHB9peXOKCH85vr7we44K1+yWK7YO44J77Hu+HFG6gx73w
bMjgAr59zUwHY25Y3DwyGzXIBc+RdbR+IzdcutftdG2YC7Qjzv/8+pkbOFyt
/Y7jXNCm/+bSqe/cMPu55MtuNhe0LnYrHxvmhrHLgS/miNz4x1Dqxml+Huh5
s9bjqBw3KPCbBofs4oH6E1YzMnbcsP3dZMHXHB54Vzhkb+vADa4FAcqtL3ig
gf9y5yMnbpA7bVBQU8YDTQUJ1Rs8uSG7a+W/6+954Avxe4RSIDeY+qm/PtvP
A705J5Q0M7nh1eVj9HYmL/TzjD+4/IwbHGP5b5GkeWHA8hqtLJ8brvO4TKnK
8sIQ94PFna+44QL1yF1rZV6YMO95t7uBG9a/OJtDMuSF5b+2Z41HueGr3cEr
ox68sGI60xE5yQ20Zu3WAz688C/j5sHWWW4YTnsVmXydF3hMH6uZ/+WGBchQ
YYXwgmD6APcxCg8MaB+4dT6FFxhGDin2yrgP04Ojl+t4gfVoXixTnQe2XT68
eeUdL0jOBwX80eQBjVij5x4feWF1WpaTE+6TxZfhOM02XpBlD2u5m/JA8YcM
otRvXlBJcW6/6sEDwgsJ2uZ8BFgZ9SnyusQDJ3k/elQLEqBBO+iu6xUeKKfv
XF5LJoDttzTj07d4YPsyF/U1jQAx9I56/RgeON1wXvmCDAFszgw82RnPA8o/
wvL91hNAqXD65vYkHrjUmF51awMB3hiTsYZ44Gnw2gJHJQKwQ/RKSHhO+0by
/+VqEKDmm3EcoYQHSmVe0ey0CBAuf8LjL55b9Jd0EmUnATa+9VaeqOUBmysB
7aBHACvunMzWzzzAY3VZb/1BApR6MxMSZnhgtiHc+/cJAgS+lfWO5vCAh/p5
salTBDAVVzW/s8QDCXdfuE+eJsBI4UGxq7y80FDj19R8lgBS4zeCbWi8UL7q
TJOEMwGGdCLOHcU6UB7aE/DZhQBFd5L2mK7ihSYju8ibbgQw2vSSW389L7z/
XTn+9iIBrtuNXt6oxgsn2GuHuy4T4ODzBUsZDV64lq936oAvAVg8/NsltHmh
JoD4Nv8KAfIfrJ0W2s0LHtqtZTbXCdDbaeE4bsoLoVX2yZa3CJC7yc7wtwUv
HEqtmb4eQACfSxc29Fjzwseu6MEHgQSgMUJ7W2x5gUvFgFAfRAB9k2rrInes
gx20By9C8Xzu/KfO680LcWQej7wwAvS9EaeY+GIdTuQYPwwngL+WY/XoTVzf
m733HCMJ0OpBv68VxAtuFf279KIIsC6v0iMolBf60h+4iUUToHo9TV42lheC
5Z51xt0lgOjJCm73BF54/qPS4lAMnn/8ue9Vybi+ey4dS5i5yOXhx9J5gVP9
xW1XHAEOG9g7ZGXzQpfUjoYOzA9uiOpxcnnhFSkm1+EeAXTZdnPRL3nh015i
qns8nr+yyKeeMl7QJ0dPjWL+4fgqc8trXogkcVnaJGB9PTnjfwX74MCkyEwj
5is/yccbsA/I+UVDqokEaJQo2cbCPpi1ZB6LxixlZiti38ILRd13nEcwl70r
ruHu5AVaC5vrzn0CCPGeTjLu5oVo7oD3LZitd5K8knt54a3akWpqEgGyvYuM
RwZ5YRP3fWEjzIsFpzbtGOGFkyVVn25i3j8qyHt7gheeyh3a+gJzwoYXXV9m
eEHHmm38E/OQzcnidfO84OseY0FMJoDmfYFIt2VeOHhMzmED5qCvhecruQhw
Oq4hSw9zu8iJ3cJE3Ke/9WCNecN+/tXW2JfhAf6mzpi9bhWwM7AvCf+uEa5g
flt5rHlOjACcdpsrgZgZC8Ts3QwCXMM/0EIx26vl34ySJMC2qRmzCMxFztYn
fkpjn3+/zB2OmZBJ0NiMfbvCvkMKxmzWmyvquxHPce5Igh/mx1JHh98pEmD7
fWqLB+ZZC946hjKu45r0t7OY9aNyku3UCdBW2dt+BPPdD5behZoEGKz5MaOL
uZfIY8KFfZw9/eDIRsyq8EzBaBcBKO4Nq8mY/X0sCEl7CLD+O/nyJO5Xywuu
7j/78H448qEtmN02mUcFmBJgulLGMwzz6zP/HD9b4LleLI53wCySkqW/9hiu
5/RdET3MudQVTvkZAjBbZqIn8TxXDma2CDkQ4Eizy9gbzIdumz61ciJAjvdq
jUTMo0vpJ2c98HstFdUBs+KA8RtF7LOGwkyJQKyXjvNKEWdDCBC7N1PYCnPg
uMDRB9hHIv0NsgqYezjVo1Ss439KHyw/YT2GXUkpPojXUXfWKU/DrMXt6xf4
AN8XNdfhhTlGSJ2+mIHnnTvxcS3mXRGi3WrPCFDYem5iHut9nDaW4ZxPgO4/
d4+1YDZcna79qwTP5VPjk0DMcw/9iasqcD2lEY1nMKdtOPXJrJoALmFun/Qw
L29lnXn3ngC7H0kt8mHOejGrxNNEAJ2H8+dHcZ0WO1rY2q04FyrE9n7BzFuZ
89qzjQCrstQKKzHn64WE5HXiHPgg0voU84l6e7M/3fj98jrv72MWOrhben0f
1s1e1bJwzCXNa4aO/8Z1ihp9uIX5rPlyQdwIAYZfN0pdw0zt7PBtniDAqfoP
rT6YX58s2iM0i68XGIj6YnbuixLRn8fzZa6a///9kg4u364uE+B8wN9ngZjr
R/c/eslFhNRz/ibRmD0ubHSeIhBBYYkpkIZ5LZtXQ1GQCMrafDNFmJt8erjO
konA3eqs3oTZ9195Q4oYEcgkg/FhzPK3EmI6xImg+dZGTxj356uA10mqJBES
nE6ZqmL2DzOVPyhNhMLBMnQC81bq1umAdUSQjalRDMPcFUcqr9pAhB/60Ro1
mENWDQUsKBChRW3VrWXMGql1xmpbiWDKK62qg+fbL/tQwlmNCPOlCrY3MEdn
Xe1L18D11z9Q/39+oS3WOT3aRDBbzHwvhfU0WrjdWxKI0Bihu+si5gQN2i4z
fSJ4KsuWfcK8t3xCKNyQCLSF3xaqWGepbzJTuE2IEDOifEEI6//Q/gAHbXMi
TPRXbPb7f141nVb1PEqEtMrtQcuYzTok3w6dJkLrJ79IwRQCcJ/gRKyzJ4KG
9W2fRMy5vz4fPe5IhPC7vT6qWLeCI6Fjn9yJsH3dSfVLqQQodj3/UtCbCI++
127c8JAAdrN7buz2JcLBPfzp3zFX/l2hv7xJhE0Cv1+ceEQAd9ELOikxRMhc
jNpUnY7nHt7gFhFPBLUTe4+kYB/YkmWf+CXh9SW/ffDPJICJUDv5zGMikHK4
/p3OJoAyYefPjS+IMKw7W+ybS4BM/ziaRAkRppMK02LzCCDDPWkgVE6EXB5b
/5fYNyIrafmjtUQwOt/yH+059hNHwL/gMxE6XK/93Yx9ZO9lW5zWToScsuHU
4FfYZ7Nlw3e/4/mOJDaNlRLg45TLEa8+IkQUW4o0Y589G/kiqz2D36+H+FZq
CeD4M7W+jsoHIsyrM2Tso94Ti0tFDD54fL9wYeEzPj+6jihnSPLBbeLrwImv
BNj3jS8heB0feBoZ/Mf5hvX32cnRSJUPspfG63178fxM3qag7Xyw3zTPragf
fy80r/msrMUH4hmDhIVBAvB/bNWm6fHBJo0KqRTsq8G3muQOEz6ouq+97fQc
AU7uid713pwPZIy67Ec4OIdrRzxLj/LBxXdRbdcX8ffX65TupNN8sHSZFlP/
D+d5KSH/9AU+KO0Rdv8sRIQzuc2mI5F8IHRokdmHdX6SVe+vEssH45OKktZY
59b+FYXeCXz4uyYw48cmIhy2yKYS0vggY4x0WUiFCDorN1ulnvPB3aDTnvhX
FNCNNEyNvvLB+9DaszttiCBSstk/5hsf9KR+r7hmRwShdbKFnT/4IMFszdtG
ByJwsUWp5wb54MBU86/wC0QYTR5uuc7hg/4mGcGnWEd1Y8kmBRL8QDy+6SvK
JkKVZcwNzmp+cHh+//n+PCKUVocU7FzHD2v2NCyfxjrJj/UWa1Dgh9Un0/KK
KomQtNOkpVebH3j4QtImsQ48wwgm9JP80G6dXP+Uiw82bP7vsHcaP/yXGtXb
acsHo5Hdwx7p/FAk7uI95sAHhbMmAe7Z/PDOyfCEoCsf7CzXLHUu5IdT8eWd
x335wOwAn6xdDT8crvB84xbDBzfOP+Qc7uWHiNWKH3Te8UHXk/YUhXUCsMbJ
9GLXNn64K60/9uOhAOSJziXrygqATUZeHCQJguGYW481XQj4dk1LXU8VBIeO
1WZJUkKQ06n+qOKxIJw7sjbvm6wQLJJL87RyBEHWSDzGYJsQxHjUvVOvFATF
z12uo+ZC8G7Xt0X5HkH4QtifujNOCJS7eE6J4eec4myqZagkaPPcM2AsLwQj
GonNqRIkuCoS9F+4khBsknftZ60lQYMe+RIJr2vbtvHZ5FYS2GUxo4h7haAi
UrFB+xAJ4r2UahfOCcEKwSx+UyAJuMQsNvY+FYLcFJnYikkSXHgszurIEwI/
ZmlJGpsEvRpfBZqeC0Hd4TaHa8skqDtpNvyqTAjaSNu2SQgIQ/Az05yoD0IQ
cbNtqVNaGKiGxmq7RoTA6nCqyK39wnDzO0VWY0IIWCbBLR+MhWHWpYm+eUYI
9rswrQXNhaEt9hCbtSQE4Xq+986eEob7fQdeTQqRoPUxu+LhRWGQvW6IUhVI
8Kav5ObaRGGIpQoox20hQbbO48fVKcLAl14vE6pKAmdqgIjlI2EYatzLc0mL
BMMiZ3JPPxOGHMk9b4z3k+BXydrIuQph2F6868C/8yS4VX3vJ/2nMGTs49aZ
cyaBNHrTwt8nDKwfr5VGLpAAVNd2TwwKwxIvUNovk2D9NQX9B+PC8NpEtyU3
mARClfJGvn+FYd+YluXJLBLw5t15uEmCDLpO93Zn5ZDgjJm+zQspMqiOzGyd
LSCB5eANL1UZMkj+eSYQUoqvE3WrBTaSYbRfurToAwkuusqGSauToeeMbzpX
Mwl+u1yu0dcgw9fe9ugDX0iwsjY1+KQWGSp7Iv/71UWCJ5+8pp2ADJFdPKvJ
4yRQk18yZB8gw61jpwStpkkw8OOxbKkRGS53ls39f45nrVcGL5iQwbbDo0nz
Hwm6CDMmFRZkUPsyeN1OVBh+e7Zuf2NDhrYPDb1lqsIweXVwR7o7GRr2b/zE
pyEMEfUt2/I8yFD1/maZibYwCDxSFsnxIkNmvU7M793CcL7F78ltHzL41Obu
oeG5LjS9v1l6gwwueiTVk0eFwbVcINTpJhnOVJ+TzjohDOPb34rRA8hwsEqG
o2svDBu/ZYzuDiLD6rLoTEdvYfihtMVsUzgZqFoTMUW+WDddvKXBEWTge3Xg
BpefMLyy0jPriSTDeDHBOi5IGE5Wjd52u0uG3m2n9/4KFQarPRuOZMeQof1F
hapSlDBs2GVb3BlLhteFXqSaBGF4JCf2bE08GV6ofOYIYx0p8A25qyeQISt/
a79lmjAYZt/WgkQyROcOlY9lC0NI31HNnUlksMu2dpEoF4bShB+znx6Qofji
n/2HXwsD4X4bOSmVDAI7L228XScMwgdDTG0ekuHZp9ie2UZhWP/wv6aWNDKs
xMtWKLZg3b/q23n9ERkO2z5PsP2Kdfkya5/cYzLMzjabNv/ALOCTdewJGfZW
ntrK3ysMiRFNGqOY42+Pk3SxLnVTeNs908mgIyn85inW5XidXpVHBhnC+xIf
9k4Lw8ANH/1hzD3PNl2T4AiDqvao6dFMMtxEBhq3/wlDwJBxoGwWGb4ItNEq
ecnwKHPbHz/MG1rtJmf5yfBQQtukHfOl+zONisJkSLzd82NjNtaDnX+WrSgZ
ogw6c90xS20RC0ygYx1WifS/xOzCeWDbzCID0TkxmYP59estiH81GXz/1C2p
PMXzDKlYpbsWPz8muOYcZrsjB+c95Mhwx5Qmfw9zsdT3L083kUGa+kqjBrPA
4PmC3s14jvpcrkOYrfPmwyRUcd3SkhOCz3B/L912PLydDHIjtt82YF7ZxTC4
jX2SRzxtjDAfJj1ZX6lLhrDPte5HMKd9UeOa0yODTKnt2TOYZ5NruhQNyFBO
19nninnvOZNXtthHS/Ie4I05XrknNsEY+1DCzNkX8/CCi3vzETLs/mY4/X/W
qf1rxG9Fhh+s3qlLmMNDQxV1j5NBfkdLuDvmHvNVAp7YV0kaQyMOmFXXZPc/
tSNDzX2W0nHMt4Y0q3sdyDBt6+5+EHNbQX2yhPP/97OudwdmeV8Ln8MX8P1d
F1NkMfvoD1jc9iSDMq2hQRhzI9lDrfIyGR7fehwyjfsj3c4jOncV1yl/n7sN
c815mfe2gXg/ps8fxWGmq+U9SQghg0mPN8MDs/3yTv9m7LNxr6RPxpiFIo5p
694jw++8TU94MJu+iMuRwLoZ201vPYrn+WtFOLr5PRn0NL8Qx/H/V6pZ3yo/
kuFBotFgLWbJAFmZnBYyXHdYjRIxm5F0coO/kSH21INmQ8xuTQZz3j/wfT/e
6K/FHBZ1RMf+FxlefZLLXMR6fcv8r0HvD9ajnv3zfMy9nV5iKmNkKAnIjAvD
/C/Z32rNFBl4ZQd//odZ6nT4A/Icfj9v3bMDmDVlEweX5skw8r5HcjNms99P
Ng8v4/VJXwxEMV/ILvDo4KJAw9XNJnPYP+HOFWVvCRQ4KOdh1oU5W/k9T5EA
BbyD5FzfYH4782XfI2EKwM8XlfmY+4p7IqNEKXBMP8QmBTOXz2j7dToFVAa5
3cMxS+2cl3ZhUWCv5n+iNzDv4CLYH5eiQL6swFEvzBa1Ijn7ZSjwfqfweRfM
7oGrZjVlKbBv8v6J85gj9m3U3ihPgdtFH46cw/xMWM1fXIkCwnsfODhgfvdJ
9z2vMgUeNQq8csI8EL1fdFqNAs4SQ6c9MPNYWFj2aFCg9Kug33XM0hK2KU3a
FJh5uUH5//VpdzkPlCMKyJb0hqditnpwWenpbgp80G8sKcbsYRtwMcGAAvsv
HWtoxhwpF1V6+wAFkoymfo5jzhlK4vYypkD19zZxMdzPhqeZhnZHKHDVXydI
A/Ogy4sIU0u8P8UdR2wx86i+boNjFHh+7X10FOY1cx9Wbz1FgSnWJ9s3mK18
+56SzlHgTo36em2sBw/diekFR7z/vvf7r2KO4l7aMeRCgRv9OhfqMOfW8d1o
c6dAWUJXgSjOp4bb1Hd1XnheWzo22mL+vV9a5LkPBRRsdcdLMBMoChYPr1Hg
5NvlNeJYvztjdvVfDaRA5kKYcjdma8tDik4hFFDUjdA/gPXuJXnU3TqcAsfX
6G+pxJyf6salEUeBnJyYkaL/++3MFQO5RArwXNCY0cohw58NQeG0FApUBiRq
vsW8LueB1OQTCqy6tNI7kYu/B9yenunOokBWVL1PeB4Zjqm9zG7MoYAhoadI
LZ8MMa+aNLOKsH4sKi9HF+Dz7e1fM9s3FKgVrht69IIM6R7p9568p0AAfU9l
aBHOp/XGnUMf8f4eNO+7VkyGQL/UU65tFOCzr170LcH5vXVfWmEnBfR4jh4L
eoX1+2Oqf66bAsW/Tgwll+Jc1t7teOU3BXojRJb6y3Fu/Bl5VjVCAafOl68Y
lWTQj4+Z4JnE+nWrYZhW4XyaG/AInsf9Jr+VHKzG/cwPuh4nKAKfrXfsCqzH
z59UqflGFoGzqk9H+HEu6JM7CaupItBcqiAU04Cfd1QMeSQpAjSF7QKNOCd4
5Zpi8hVFQLbUpqTiC87jz17tM1tF4AL5WFFsG84V/zWSGuoioOoc9vtSBxn8
f7o9qNARAc7a0j2nu7CeEmnZDYdEQM7h0MHyfvy8Yfko2VQEbkWFWE0O4uc5
dltNLERA59uivjLOEX+z4hftJ/HzcnzkLzhHuEWOVvW7ikDumULHHA4ZUiu4
eeQ9ROBOGV+o3iIZwClb/79LIjCY/VWmH+eG3/ul91N+mA1Ufh/koQDXrZQv
K1EikL2mObWYTIFUVQOmXhxeL+WRZAHOBfg1cTQgUQT0Pbb4l9Ao4Ke76yfp
kQjMbmk3HpfAzy/0/WG9EIG2Rwb6nA0U+Oe86Z9qmwjI5H3fGIR96Mgwfra5
UwQcC488FMc+/FLpcVS+WwTGmGrjufspkC3y+vnqQRGQjHnCJJpSwKzAwkGA
LQLlj2U3w2nMi9VD40KiMBFqfG72BgWCm8zQqLAo2CYlDQPWfWXa79g/FFFY
KTvmloB1v+kAeXc/VRSO3WXddLlLgZX7VsnfJEUhcLq+IBPrOHPnhEmdgigI
3w3wOtZIgR9i/pnVSqIgz/3P4VwLBaiD9H+VW0ShMr9n23Wsw6vhWs9eqYrC
aPUvw9YeCpj+DODL0xIFZtNAOpFNgWU/qbKE/aJQ/oK/MnGdCByu2yfr6igK
r5d+hGveEoEXFXPutk6icIfeLRkeIgKslw+rzV1EIeHVVN1YpAj0ZC2c1HEX
Bb/NH7Z/SBYBt4isBEEfUQAzh2/LL0Ug0lpQ5HGwKGjGCzsrjWMdTr5b6MgU
hVlaoF+SsiiYrDb8pPdbFHy23DW6k4vrGOwbK3IRg+2Pu0NqP4tBfWuSa56b
GOzMk3WdaheD1krzqUx3MfA1TxBe3SUGQ3H1s/e9xGBT/fOtzv1iQDd4unTj
mhg8bMndNTErBk4Z7oJG4WLwMmyF4SROBSkHbrnBHDFoiTz3uf0IFTaalab/
zBODp7KfDiZbUkEVLsp/KxCDEV9T/5PHqGDIGlBsLBKD4vCzvz/bUsHj3TvV
wgoxqL7twR98gQqN8pFw7aMYzAYq24uGU/F3lfRxxpgYtP21n9Coxc8fSD+m
NSEGM6iWkPKWCvSczcdOTokBaB9R//ueCrluOtbpc2Igu1PxWXozFXo4R622
r4jh312MqMc/qLCHL9bMQoQK5exznrvYVKA6SJn5iFHhAzI7pLZAhe73j46k
0KhwVaHIb/UyFS6FFZoOMqmg+YvT0slNg2x682EvGSpsLkulzwvTQGQ96VCc
ChWe31sfW7SWBl23og+WqlHhWqwgR16WBpmDEge7t1Eh/8Av5ZgNNNDLlj+w
QYsKqbPb6aaKNPBQ2buvWI8Kj9QSVhzVaQB3Pxp26lMhUcHuZtJ2GpDnzAxX
9lIhSNK3+I0mDdJLzhjsPUAFOYEC5j8dGnxDN/a04b6PbmDak/fg6w8F9iya
U4EstmdpaS8N3Hkj9aWtqPAgZlau15AGwvUpu+2P4z5xh6vHHqSBrlH5LrYd
FZ7mfKPGHaGBUP7uXZLnqLBfyGbLLnMatIt9AN3zVFD/OdTeZ0EDt6/fUKAz
FfJOereJWNPg0XHOToYXFT6Nqd3nsaGBmXbFtPglKngmNeeZnqYBn+TNDHEf
Kkz4/nW9b0sDx3aKmPg1KhR3mC0xztJA1XRDPy2QCi81Jm4Wn6dBv/JoPC2I
Cje6b+9odKRBnEjhIVoIFW7zNeZ3/keDxcadL6lYFy8E/5v55UyDGgPzELE4
zBIuuokXcD83rEJi8VRYZB/29HKnwQbirxnRRKwr7uCoAxdpEFLjdEI0hQof
K1siejxooPNQlSqaiuc1ZH411ZMG49fn34qkUSFEhHHuqBcNTHfeUhZJp0Kk
zw3DYm8aEKT2D1AyqVAXZHTI+hINihdFEinZVJj8m+jAwSxZcp+XkkuFudN6
/6R8aNAYd7qEnI91/tox+Anma54bncmFVHi3Jcdgoy8NelWftwkXU0Fszxk/
xhUaxIhdviNcQoWqxIOkW5j3TuqCcCkVkiW0R4YxzzcR5kjlVJjfNCZ/4CrW
Y05DFqmSCptizD8+xnw8NPIk6TV+n/X9XxzMlP8saKQa3L8oCVf9azR4vU/q
nVAdFS5onLoegtldvveKEPaRpuBWqQbMsvyZKkLvqEC0vG7Me50GbQPOg4IN
VKhpu7x+O+agOrX7go1UcPf0TbPFrPVowViwiQozG+jtQZhHb1QRBLHvrr7g
a8zEnGIT8EqgFc8z2DC0BvNhdMBF4AsVjK9zr2/DzC0ttl6gjQoKGXfu92Eu
XG5r5++gggDtIvcIZrvvSaH8nVToSvK0GcXMKLXdxd9FBf9n/nW/Mb+Ll2fz
dVNBY7l0xw/MPt7j2Xw9VCg55tbYiFnJ4sUpvl4q/LkgF1yMuVvdh87XT4UN
V8OuJGKOpMF74iAVdlBDn1/CrDdNvEYcosLbb+raJphnmz+oEoepEHzwg4ws
5vS8qN+EUSpQXGouTOF+WYVbJhHGqcAMLNd+hVnIebUJYZIKGR0hob6Yyw/0
EQnT2F/HN7trYpYRdHXlxbkzGtWmnobnw002klrgUAFpanUdxtwruvn9OM4h
I7G7AYt43o9YI+s6/1Ihc68zA2G+JdXw6dM/Kph6+0h2Yv3YyWRdeYNzKW70
7lE3zBvkz7XlE2lQ9rK2NhzrjV9p7810fuyzi9nCTMxDW+WUkwRpcCRlZ2Pi
ZRpkafQF3ybTYF1b+WgM1q+SwamdJ8VxTuz+4WCO9U8+oDt8hEkDlk7zqrL/
+8No9b19Enif4ou1UpjzLL5Pqq+mgaDX321fsL9U7S0fk+RosJs07CWO/agR
YEx6hXOtoftcxCT2Myt4S0kuzrUzvFfur8Y8H0o++xjnWuhw2AsD7P/SmA+V
ETjX5HMFrO6ew/58bOBur08DhcFTF4Xs8Hxq0TeaGc4VrdXNQcdpYMStnOGC
37u4YYJjgvNs0udHSziuS6DZib31AA3uzoYs52Lfcm1/eJG8nwYdvwdMJnCf
rq2kWtYb0OB00/1l11s02Fhp827Hbpwf9/lNL8Ti9bRd7qloYb2JF12JukcD
XjHCZfoOGrwKt80oSMD7/hgYN69Bg5UbFctTyTRgmu9h122jwW2Hixnu6XiO
Z5/aXFChQeK2n8sXX9JgwBJyVDbh/eSFbox5RQNl9+nobfI0+CmvZfqijAZr
52ov62zE/pOKzZitwr4r6C47gvuYw3PA1PMd3ucaQfmn+Hw5fGX+SmwDDew/
jyk1yNBgeu5JRlEjDSxMDtDH1tBg+x+uv3PNNEiuMFnUlcZ+/1Sc4fWNBv4T
EVsZq2hgu8+uNe47DQKSI80sJXGe1Yr9Lf6Bc+KZjlYynuu+YidTzi8aVDmd
KtJgYT9vlbzK7Md60Qu8EYp1EJ5Vn6ExSAPvlWLfQQYNWpPW/fUepkG0eop9
NtaNB6N5Y/woNtXnA2F0zMzIq6Yl47jf/ROHbtFxPt3syJifpsHl0WF+Txru
33JAK2uOBjSq3XY2lQapXmp/NTk02GzIOH8V88D5cNPLS3iO2+X0U8Ro4GTj
o+r5lwZSWukVuphnLeypF/7hnF6n3tQvSoMrh0ynnbjpQBd/GxKJmaCv2+rA
Swdu5R0CephDtRQK7Yh0yBk1PrYggt+rwoi24aeDREBBfDHmxI087scF6RBj
9efLZczrpMdNrEh06DhsL7tb5P/nf6eKGZkOWQY+96mYVUlvxQ6L0OGF01Gj
IQrWL3fh1AExOvQ+lTCpw7xrPrnFgEYHGr3wZTrmd+PBBbvF6YB0F2MjMB8e
8IxCTDpQi7L+XcPc8f30BW0JOgwdtxTwxGzTeshEYxUdrLou1V7APPRuh4ra
ajpsJNrq//+6a5Wc2NY1dHi3Uz/lOmZ2kdiUwlo6mI9s7o/EfO3Z3+YN6+kg
2iW4KQsz36M/+evk6OBemHL9HebwhK+R0hvp8OFw+OI4ZkZktZvkJjrY7jF/
JoX3lxyYc5ihSAc9jf0ZJphlryYoUzfTIfRI8t8wzM8uBohSttLhaplldQtm
dccLk4IqdJibtiasxv0utznRTFSjQ6mxTYcrZn3Lffnc2+hw8vy8UQPmD4e2
Rf7dTofG4JDLSnienVrkw3NadIhWcNgqgOdvq7KwdUqHDpte5XbdwDy8cUBk
TBfP16T/Bi/WzwK94lO/Hq7vuwpbGuvLj5SV16NPh/IT/QMlmAV4YiO69tKB
wH5FOYb1yJpwMv6ynw7e3UIHSrB+UwestjYfpMNRnryrF7G+N3bpizQa0YGv
7e3G/+t/+3upT7WmdDA5cFe6A/vD/FGj0XNrOtRXPlDxx7nXlVCyJe84HZau
KJf7Y7/ZRT6mPD1JB6+JJyqh2I8eV680pdnSYbhHnlaK/RttqWQU7UiH5VP7
pG/i70FJI9aWcCc6/L0q59qI/Z+mT6CEuNAhigNia3BeFKh0fbzhTodqzQOX
evD3YjMp9NAFHzpMSb+hfMX5InFp79N7V3B/l6qvhKrhfvVzCVZeowOPxi19
Y5xHc+WedUI36TD6pZnGwTkr6XJK+/EdOoQ73eZqAVxvp0RCQxgdxO4PhfXr
4bzZ+4U9GUGH9X4uLbz4exLW7CvcGUOH/9Rfpp3dR4Ozzaqb2pPosIc76sJL
Uxrk6owF/k2hQ7H3h6JN+HtxPjOjf/1DOtSqVLEzLPH31g2pVLcndKjTPnfn
Hc7rfFU+plAuHV7FhD9PxPm+GPONsLOKDm4F587fxuerPneM7ZlqOrQpvhMt
96dBmLPR6+BaOrhWXFteDsDn595a37Z6OnzWSnvyKJQGezjPpl2bsX85f/fd
SsTn+VG/nrRfdHjwS3Y0qgR/H7/R0n3fRweditX3Qsqxn1Xn7k8M0OFpyJv/
Il7ToEjI0VJnGOfDWOjVCpyznWVHmr5O02Fv6IGkbJybctIbywUI4lBjpKdT
g3MnJW9RTI5PHLjPtKyz46EDY1fTuV0C4lD9hbJXDOcIn50nzUdYHOyfXmOE
idJhMKvWcYQuDnbae2IFZemQvs1GoklOHL49M/MVOkQH+UMJXncNxGF3YmZw
WTodUrudGvP2iYNIQO31zGd0YLnBusYD4vA5Ui4hpZAOAnd/fyQcFofslzHf
nlTinOjYJudlJQ7DJzI5q9txLtm1frY6Lw6O/wrzUgTFQeEKSUX6jjjEdZmN
rfEQh6CQ1TqMMHHQCS59edtHHAbitxpQIsRhPbH69KyfOKQWHTmxEi0OEZWF
g9/xfeIT94O7E8WBdkfzSU+GOHDZKvWmZItD+9Y3lRld+K/BobtrGsQh8uPy
aUtDBtyiRczJCDJAWTbLaFaGCY/uuV7bTWJA5yWp3k3yTKhZdZjfnswAjSYF
k2NbmcAlKybxVIwB99bXr+TvZMIV9bs62yQZ0DMoprXOmgme5vdu7lNkgGq+
+dBkFBPs7z0Qcz/EgHf+zfk9S0wIWOWXGGPMgNvSBidVeFjw+IHN+pcmDFjS
iX3iLcCC3oy125bNGTCqARr9dBacLHlkFXiSAaYBJd0am1lg8S3jQaIrA3Q7
z69KPsYCzxNB8hUXGGD38FTF1tMsiPnlUPDzIgNmc+s/v7BnQeufTbWylxjw
srshLvYCC4wWnw7m+jHgQdS4wLNAFhisyt9cG8WAn16cu9y5LDgo9em/6rsM
UDx1jmZRyILDq8ezqmIZEC5kKZVUzAKrNUobyhMYoPBi/dblShY4rs+ULnrI
AO0zYdICn1jgIlt//PkjBhyN18/rb2WBu9xgYsETBtTVlsUWtLHAd6MsMzcL
12+Y27iqmwWhiqkiGQUMMLga9G7zKAsilaoOPXmOmUt2NGiCBbGbu+88KmLA
oZvi2p+nWZCyVUog9RUD5sv636kvsCBPLZ4roZoBQl5BeRuJEvBC/aXuvVoG
oLNLGvP8ElCyre1K7BsGVG062FgsJAGvNegLUe8ZYJJkG/pXRAJatSOnQloY
0DKXk5ojIQFtOnlbgz8zwIHFXTG8SgK+72xyvv2VAWNk3Va6tAT0I+Hhm98Y
MDfCb7t1nQQMgaK8/3cGdMs5J66RlYDRXfvt/X4wgNvUxWBZTgLmdgf1XvnF
AL/nPld9NknAon6GjG8fA0iXNN6uUpSAlT1vT14ewHqpmeXJUpIAHoOBJO/f
WA90Ofq6LRLAZ0j47vmHAV0VlzsDt0qA0L71Eh4jDMi507e9XVkCRPbrWbqP
MSD91l0hmqoEsA76fXaZYoCU7afkg+oSIHXogZjzDAMSKglr92+TgLVGlcb/
zeH7E7+kqW6XgA3GP8LOcxigGVtG5NOQAIXDyx/OLTDgYYGPUh3mLSarhOyX
GDBDZC06aUrg379ahnZ/GfDn3E8Trh0SsP3I0UDbf7he1hnmNczaZpfqbLiZ
MOp2ZcsgZjC/x3OKlwkutw/6ampJgL5FMZwgMsG0S6fXA7Oh5ddrx/iZkLDy
z+A+5oNWs+VHBZmgpxod9RTz4aO0JUsSE97TtR4/wWxurbrDgsyE0xB8Nhiz
9TETbzMRJoyPHS+zwHzyuFuRqRgT7sV23yFjjvLPHNlLY0Il80l7Hq6nLrNn
rbY4E3TfaxnpYOY0say2MplQdFGmoxDvT2HucPh6CSbsDltzkob5xKrgOuYq
JgzU7n9/Avcjclf1Imk1E2Jur/BE4/7VnVtQ5lrDBIW7v2bzcH85YSrn/p8j
gh4DQS9x/xVenE8eWseE46IGWZlquL7Oh5+7ZJmwUykCbuJ5RXF1CrZsYILz
WPQOAxW83gYqvMG5U3/C4/osnjfn4H6vVwp4v6Npf0OwHhQu+j/LUWKC1dj3
B0KbcT1V06w4ZSa4E0e43mB91Q4oGIeoMsEw6038v40SwCadCbimzgSeTy/4
1m+QgONWn6fsNZnwunWfpCzWb8Q1kvwxLSYcLvS6zy0jATWPd5801sHXueuz
6ldLwKap5w0awIShM3byZOyP48xRLiU9Jmy//94rlIHfv1NWQ0afCfOONymz
NPy+4JhHAoZMGBsq/+ZLweut87zyzZgJK48NlZ14sB8Mcwo/mjBB/CSJpfSP
BfKuA0PVR5gQO3C05fMSC8LLzM2zLXEOT0nd7JxlwTGz7Vt8TzHh+QaCX+0A
vu7jYud6mgkzMhHhr3+xoCY1PfHMGbx++kPhJz/wemMM/oPnmMDfuqAk+5UF
swGcn1KuTDhfEPZnoYYFG59tZYhdwP1JmT+ugvPLuvXcQeJFJjRPn5o1fsWC
19IdJWNeTDjzR8lNL48FYS9LoiqvMYG4fLh9KYEFG/5c3m0TjvU7n3WxzJEF
qwL8ONcimeDv90m0/QwLRNfefpoczYRVtR1CX4+zYMEqhvY9jgkR5T7Cl4xY
0Pgut8/8AROumTist1bG+ZjZd/NAPhMKU9bujhhnwjn9YQ3HQtyfdufC5gGs
m57JkaAXeB69s3GzXUzYw1o58raECfspOh19DUxgBbFkd1UzYbGPTjz9BOv8
3KG67a1MOPXDSLTbDPeN1+yS+Rcm3M6Waty/nwmZD6yVPNqYQPUqT0pETIhq
PxdT0MmEqeSu4r5NTLAz8LdT6sPnVKJAwGrsc6GNLwnrZplwtlR0TjeFAZaD
MnvIDNzX7QN1nz6Ig+q/s7n8LBZMxW+/UFwpDsKsp0weSRYc/9llE1ggDq/3
bRtmr2bB9MZMl944cZDP2RfRI8cCpXIbVriNOMxfdP/2fBsLJuOcvT9M0CGR
u87Z2pwFAl9ex+St0OCH1Lm4jBgW3HrP87p8QAws5HQGuuJYcEapp7C7RQya
N4upU/FcyixPOExUiEGNblnLlWR8Li0Yi3fHikGmjQjZNB2fSyuepzn6YuD+
+OXN5Zcs2HzEeqtpqijwKwlcMPnOggjLdx85iRTwU/9RFYh1dD74SvqwKwUW
dQop5T9Z8HPjyMcP+hQYPXT82YZ+FijyTegdGydDq2v+7yV8btkGsF0qgQxJ
z61Opq+w4HpNtwy9jwTi5ZtzvnNJQC6hwnrrSxKE1/Esi/JKgBMtYXzXHRLc
+PoswRefU+F7w1yN1Uhgz+H6elhUAmjh0uOrbgpBz7+v6wOpEvD2/h4Kj6UQ
HBV46l5GlwCDzufr+hWE4KCEuegG7MsNz556p7QKwpu1CqeO4XOLS4DQ450u
CLoK/3IisY85PVqhxj6CUKL6ZfnNGglIO4efMxIEFe2sA0trsc9pp7iW1wrC
/wD1FDzn
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.024107320210178473`, 6.307295107410541}}, {{
     0, 6.283185307179586}, {-0.024107320210178473`, 6.307295107410541}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.65399461374361*^9, {3.653995262097786*^9, 3.653995289354375*^9}, 
   3.6539956616297483`*^9, 3.654948668806234*^9, 3.6844501308800993`*^9, 
   3.684450194156386*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[5] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6539956817618847`*^9, 3.653995682286201*^9}, 3.654948673785384*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxWlM0mEcAGAED7zBg2ImQiYujBZmWyszz5kVhsy8IiUzmzVBseW8Zqaj
Wqb41zHd1FYmZmqajmyT1Apqfilq0TEjTUXTZHN5NUGoPvh7Pzx7GJli/gU8
Dofj/vN/wojT2+kDFWFb0yl0Jq0+4+jWq3pZ/FdMDE9GjE09xcphXYGhux2r
hbXVy+QW7C7MbSpWN2K9cLXfcIscG4EX1u2tEQVa+OBmHW8g7ws89j2lEu8/
CYdHJpoUmTNwWl7ckjL1JzzMYF0fbV+EExtZbXrREuxj9zxKlv0bvrFf0z96
cwWOiT0uVEjXYM2tFWZV8R944Y6XaqJxAz5X+KR2CTPDZTvVnPJBC7zXUraG
z8GFb/3mbMoyPcsG5rTmfi67goejE16kKSUEOMhwShMktYUlpPzQ1gY7+Pxj
Lf+XzB5msi/zCu87wPW0aKP+HhEWdvTKw5sdYRw5KXCqywmOMx5KTu90hrMe
pYmoKhf4h8UF0465wvavNxMzNW6wNXe3NfiTO8xTx+0SXyLBCb7H3kXOoVWz
00aliAyXzNMEFCO6TbB+hHLVA6Y7isWENXS8zb4OUYEnbMip4ReZ0Frnam5+
sRccQAtUEW29YVapM4d2G13lWbtKd6TAsT597Fd16HRBnpJP3gYz54uihDXo
5Fl6jCtlO6zfcVHe0YBOCgg1fJOjtWxyiEcT+mXY0PvSFvRDobsrX4GWPBis
NA+iHfYQ8xPG0ddC9CNSPXojtN9NNYFe5Aq6mTPoD+K+OdMiunkgJV1hQXur
2D3jOCpco8abSQR0ha67qcQBnb2O0/FI6Emrzl/qgU4ldkmGvNAnqadJTCpa
w2BlnPFBh7GsPTJf9LPgj2aNH5pzuPOEiYH+CwXPEkU=
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVx3841AcAx/Fbca6lPSmFnoW2PS2GstYoz3zOj6W22DmUulPWQ/P7txtH
Y/rd/LyTJHKtQlwPR6uFuOqWI3R3DnfuvjdCCYvza7nC7I/3835eW45H04NX
kEikvcv9/5XNH3YO7vrV2dDDqkK3ZRXVcqPlVnPuMbjb2Kef0lGos0Sul5IT
DUPKwCPDLgq136X1xT1OGgpzn2775DSF2h0/zL/FycGZDUeNgl4aUCWZ00Yl
nFIUW63N4VWRqZ5X2KJCTjWyDyc3KZ30qJkWTSUFnGaYfmW+n75+CXufXbUX
rhFis4JdQ4gW8fSsv/EuuhAO+oZ+t1iLaFmQKs1VQjxMSZgZ71uAeEwUNDX+
CF0TaddYZe/R1lLJvrJWhIN1KUsO3+nQkcYqe3VIjHrBm3OebbPwctp5gVks
Rsc4mUY5M4vOuYlwab8YNxN8+WbUZUeG2jeEtoJVTtd3uz+DTgazMTulDeuk
364X3Z6GxMFVtqu0Hdwn3gJTnhaj/5KXXOIloHFjHF/zx7D0qafIgSuBuTWJ
scl1DMY07gXbOgk2L8VW6ClGgQoLY7NpCfrXLGkNyKPI93e0moyTYu5iS5cm
bATOD0J9rsXJcKx+zWcx/sPwGa42zefIEMZuUWfODyHEaI64UCuDJjJ1ddTV
IXBDM0ISp2SIetxqmz4wiBGzqycPxHWhuJxzepr1Anns9nJdrBy5idvDTHL+
RlnZusjJPDmei0keP45q0Cjz//KlQI47tPU73D00eGk93CjVylGYs2qfQp/A
HtWCtCK2G+K5qQ+8Cvow5LT9/cHYHhzyLPVe0OvB/E+Jjw7k9UD3+In+NnY3
PspvOOsq6MElgdB9dlKO3eMeRnbaHih8TZRJg13ILg7cqh/bC63p4mZbtRSO
C3m0uhgFhPujS2Yc27EnNewyJVcBSUZmw27mMzi9c9UEVCsQlNzbW5HRBuf5
6XDKGwWmhoRVekox3Gb9zgWEK2Houv+XO1V/wT3BrrP2ohKWo1W8b0ZE2DtN
3kCpVCK/u7xl9nMR9mnv/147osTHSREu6prH8PrHrMngRB/ezsTvGJI0gxYx
pRdwpg+KSznPg1Ob4D3W9n3tzT7YNIedsrV7CN/XKUrmYB9Iprcizt+sx5Fh
YkYQqEK6zQ2dg/oPMIPuORmkq8BHR9G9B3cRMJidwSxVwX0ijRVeUofAAaw1
0KgQ9IbhFPWzAMHE9S+YDDX2Ecbj5mOVOMFkxwnYapDmWs0nKbcRoqI/IBep
UWjB4q7YWY4w5UoPgUKNpHerf5BV3UCEvzqL/FaNwMVX/AzddUT23pUzTAg4
3l9gH/HjIaY7+Dj5IIHAw/zA1qNFiPN1vs1IXLYbqcQo4DLiuzZO1uQT6N9k
WxAdn48E+sTX5LsEJkV21vLreQiNtcgelxOw5EkriN+ykETjiWqmCPB8KpXD
meeR/DxpNXmdBrzKNr9NyafA9vKmM+w1IDUMZf1pdRIFWeykbE8N0rVFDDE/
Af8BltE+Lw==
      "]], LineBox[CompressedData["
1:eJwVl3k8VN8bxy0ztjGDmTEzJKkoobIVIedJijYiW9okSb62ZClapAjZQwhJ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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.024107320210178473`, 6.307295107410541}}, {{
     0, 6.283185307179586}, {-0.024107320210178473`, 6.307295107410541}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.653995262462346*^9, 3.653995290126841*^9}, {
   3.6539956774053717`*^9, 3.65399568371402*^9}, 3.654948674630805*^9, 
   3.684450130909965*^9, 3.684450194209578*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[50] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6539956817618847`*^9, 3.653995682286201*^9}, 3.654948673785384*^9, {
   3.684450203257872*^9, 3.684450203824251*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxWlM0mEcAGAED7zBg2ImQiYujBZmWyszz5kVhsy8IiUzmzVBseW8Zqaj
Wqb41zHd1FYmZmqajmyT1Apqfilq0TEjTUXTZHN5NUGoPvh7Pzx7GJli/gU8
Dofj/vN/wojT2+kDFWFb0yl0Jq0+4+jWq3pZ/FdMDE9GjE09xcphXYGhux2r
hbXVy+QW7C7MbSpWN2K9cLXfcIscG4EX1u2tEQVa+OBmHW8g7ws89j2lEu8/
CYdHJpoUmTNwWl7ckjL1JzzMYF0fbV+EExtZbXrREuxj9zxKlv0bvrFf0z96
cwWOiT0uVEjXYM2tFWZV8R944Y6XaqJxAz5X+KR2CTPDZTvVnPJBC7zXUraG
z8GFb/3mbMoyPcsG5rTmfi67goejE16kKSUEOMhwShMktYUlpPzQ1gY7+Pxj
Lf+XzB5msi/zCu87wPW0aKP+HhEWdvTKw5sdYRw5KXCqywmOMx5KTu90hrMe
pYmoKhf4h8UF0465wvavNxMzNW6wNXe3NfiTO8xTx+0SXyLBCb7H3kXOoVWz
00aliAyXzNMEFCO6TbB+hHLVA6Y7isWENXS8zb4OUYEnbMip4ReZ0Frnam5+
sRccQAtUEW29YVapM4d2G13lWbtKd6TAsT597Fd16HRBnpJP3gYz54uihDXo
5Fl6jCtlO6zfcVHe0YBOCgg1fJOjtWxyiEcT+mXY0PvSFvRDobsrX4GWPBis
NA+iHfYQ8xPG0ddC9CNSPXojtN9NNYFe5Aq6mTPoD+K+OdMiunkgJV1hQXur
2D3jOCpco8abSQR0ha67qcQBnb2O0/FI6Emrzl/qgU4ldkmGvNAnqadJTCpa
w2BlnPFBh7GsPTJf9LPgj2aNH5pzuPOEiYH+CwXPEkU=
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVV3k81F8XJtkqss18v0NJtiSiUCo5N20qSbL9QiSSPSUVJakUISQKUVGW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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.5004767381873579, 6.782944235363388}}, {{
     0, 6.283185307179586}, {-0.5004767381873579, 6.782944235363388}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.653995262462346*^9, 3.653995290126841*^9}, {
   3.6539956774053717`*^9, 3.65399568371402*^9}, 3.654948674630805*^9, 
   3.684450130909965*^9, {3.684450194209578*^9, 3.684450204332244*^9}}]
}, Closed]],

Cell["Make  a \"frequency domain\" plot of the coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Pi]", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
   FractionBox["1", "2"], ",", "0", ",", 
   FractionBox["1", "3"], ",", "0", ",", 
   FractionBox["1", "4"], ",", "0", ",", 
   FractionBox["1", "5"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.539348900461853*^9, 3.539349025162924*^9, 3.592056900794857*^9, 
   3.59205693153894*^9, 3.59205709743393*^9, {3.65399455589922*^9, 
   3.653994564692024*^9}, {3.653994603096509*^9, 3.653994613952845*^9}, {
   3.653995262770445*^9, 3.653995290364159*^9}, 3.654948679074293*^9, 
   3.684450130977219*^9, 3.684450194373826*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"ChartStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Re\>\"", ",", "\"\<Im\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592056964512083*^9, 3.592056985563291*^9}, {
  3.592057062331558*^9, 3.592057071627198*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.3020588235294117, 0.}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.616], 
     Thickness[Small]}], 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5404411764705882, 0.}, {1.4595588235294117`, 
            3.141592653589793}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{33.40774692229833, 
           64.76318693732891}, {-130.3414344011024, 118.52038573839297`}}],
         StatusArea[#, Pi]& ,
         TagBoxNote->"Pi"],
        StyleBox["\[Pi]", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.540441176470588, 0.}, {2.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{66.8424656586516, 98.19790567368219}, {
           117.89538573839297`, 118.52038573839297`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5404411764705883`, 0.}, {3.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{100.27718439500488`, 131.63262441003545`}, {
           117.89538573839297`, 118.52038573839297`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5404411764705883`, 0.}, {4.459558823529412, 1.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{133.71190313135813`, 165.0673431463887}, {
           38.87915177316408, 118.52038573839297`}}],
         StatusArea[#, 1]& ,
         TagBoxNote->"1"],
        StyleBox["1", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.540441176470589, 0.}, {5.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{167.14662186771142`, 198.502061882742}, {
           117.89538573839297`, 118.52038573839297`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.540441176470589, 0.}, {6.459558823529412, 0.5}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{200.58134060406468`, 231.93678061909526`}, {
           78.38726875577854, 118.52038573839297`}}],
         StatusArea[#, 
          Rational[1, 2]]& ,
         TagBoxNote->"1/2"],
        StyleBox[
         FractionBox["1", "2"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 2], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.540441176470589, 0.}, {7.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{234.01605934041794`, 265.3714993554485}, {
           117.89538573839297`, 118.52038573839297`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.540441176470589, 0.}, {8.459558823529413, 
            0.3333333333333333}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{267.45077807677126`, 298.80621809180184`}, {
           91.55664108331668, 118.52038573839297`}}],
         StatusArea[#, 
          Rational[1, 3]]& ,
         TagBoxNote->"1/3"],
        StyleBox[
         FractionBox["1", "3"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 3], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.540441176470589, 0.}, {9.459558823529413, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{300.88549681312446`, 332.2409368281551}, {
           117.89538573839297`, 118.52038573839297`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{9.540441176470589, 0.}, {10.459558823529413`, 0.25}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{334.3202155494778, 365.67565556450836`}, {
           98.14132724708575, 118.52038573839297`}}],
         StatusArea[#, 
          Rational[1, 4]]& ,
         TagBoxNote->"1/4"],
        StyleBox[
         FractionBox["1", "4"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 4], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.540441176470589`, 0.}, {11.459558823529413`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{367.75493428583104`, 399.1103743008616}, {
           117.89538573839297`, 118.52038573839297`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.540441176470589`, 0.}, {12.459558823529413`, 0.2},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{401.1896530221843, 432.5450930372149}, {
           102.09213894534719`, 118.52038573839297`}}],
         StatusArea[#, 
          Rational[1, 5]]& ,
         TagBoxNote->"1/5"],
        StyleBox[
         FractionBox["1", "5"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 5], {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[
    StyleBox[{
      {Thickness[Tiny], 
       LineBox[{{0.3020588235294117, 0.}, {12.702708823529413`, 0.}}], 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, 
      StyleBox[{
        {Thickness[Tiny], 
         LineBox[{{0.5404411764705882, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {0.5404411764705882, 0.}]}],
          LineBox[{{12.459558823529413`, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {12.459558823529413`, 
            0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
           LineBox[{{1.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.4595588235294117`, 
              0.}]}], LineBox[{{1.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.5404411764705883`, 
              0.}]}], LineBox[{{2.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.4595588235294117`, 
              0.}]}], LineBox[{{2.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.5404411764705883`, 
              0.}]}], LineBox[{{3.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.4595588235294117`, 
              0.}]}], LineBox[{{3.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.5404411764705883`, 
              0.}]}], LineBox[{{4.459558823529412, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.459558823529412, 
              0.}]}], LineBox[{{4.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.540441176470588, 
              0.}]}], LineBox[{{5.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.459558823529411, 
              0.}]}], LineBox[{{5.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.540441176470588, 
              0.}]}], LineBox[{{6.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.459558823529411, 
              0.}]}], LineBox[{{6.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.540441176470588, 
              0.}]}], LineBox[{{7.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.459558823529411, 
              0.}]}], LineBox[{{7.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.540441176470588, 
              0.}]}], LineBox[{{8.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.459558823529413, 
              0.}]}], 
           LineBox[{{8.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.540441176470589, 
              0.}]}], LineBox[{{9.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.459558823529413, 
              0.}]}], LineBox[{{9.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.540441176470589, 
              0.}]}], LineBox[{{10.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.459558823529413`, 
              0.}]}], LineBox[{{10.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.540441176470589`, 
              0.}]}], LineBox[{{11.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.459558823529413`, 
              0.}]}], LineBox[{{11.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.540441176470589`, 
              0.}]}]}, {}}}, 
        StyleBox[
         {Thickness[Tiny], 
          InsetBox["\<\"Re\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
           Automatic, {1, 0}], 
          InsetBox["\<\"Im\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
           Automatic, {1, 0}]}, "GraphicsLabel",
         StripOnInput->False]}, "GraphicsTicks",
       StripOnInput->False]},
     Antialiasing->False], "GraphicsAxes",
    StripOnInput->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.3020588235294117, 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
       FormBox["\"Re\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox["\"Im\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.592057072075521*^9, 3.592057097646439*^9}, {
   3.6539945560734167`*^9, 3.653994564849016*^9}, {3.653994603235777*^9, 
   3.653994614082698*^9}, 3.6539952628995237`*^9, 3.653995293259698*^9, 
   3.654948681124662*^9, 3.684450131214023*^9, 3.684450194515704*^9}]
}, Closed]],

Cell["Re-write the Exp series as a Trig series", "Subsection"],

Cell[CellGroupData[{

Cell["term2[0] = term[0] //ExpToTrig //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData["\[Pi]"], "Output",
 CellChangeTimes->{
  3.539348901072105*^9, 3.53934902523506*^9, 3.592056900871686*^9, 
   3.592056931675244*^9, 3.592057097671525*^9, {3.6539945561216993`*^9, 
   3.653994564877943*^9}, {3.653994603372724*^9, 3.653994614166765*^9}, 
   3.653995262935541*^9, 3.653995293527639*^9, 3.6549486837075777`*^9, 
   3.684450131226597*^9, 3.6844501945791063`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["term2[m_]= term[m] //ExpToTrig //FullSimplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}], "-", 
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", "x"}], "]"}], "+", 
   RowBox[{"2", " ", "m", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}]}]}], 
  RowBox[{
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901338854*^9, 3.539349025465629*^9, 3.592056901077137*^9, 
   3.592056931864159*^9, 3.592057097861994*^9, {3.653994556335165*^9, 
   3.653994565006339*^9}, {3.653994603495202*^9, 3.6539946142942657`*^9}, 
   3.653995263054452*^9, 3.6539952936537647`*^9, 3.654948687156919*^9, 
   3.684450131472282*^9, 3.684450194835306*^9}]
}, Closed]],

Cell["series2[n_]:= Sum[ term2[m] ,{m,0,n}] ", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["series[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"\[Pi]", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"6", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"18", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"8", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"32", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "5"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "10"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"10", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"10", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"50", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348901508812*^9, 3.539349025532612*^9, 3.592056901121194*^9, 
   3.592056931985405*^9, 3.5920570979048*^9, {3.653994556759735*^9, 
   3.6539945651973667`*^9}, {3.653994603566409*^9, 3.6539946143891582`*^9}, 
   3.653995263127933*^9, 3.653995293893736*^9, 3.654948689851945*^9, 
   3.684450131604927*^9, 3.684450194976117*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["series2[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"\[Pi]", "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"4", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"4", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], "+", 
    RowBox[{"6", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"9", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "x"}], "]"}], "+", 
    RowBox[{"8", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"16", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", "x"}], "]"}], "+", 
    RowBox[{"10", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Pi]"}], "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"25", " ", "\[Pi]"}]], "-", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.539348901647589*^9, 3.53934902562461*^9, 3.592056901159855*^9, 
   3.59205693204438*^9, 3.592057097944783*^9, {3.653994556831818*^9, 
   3.653994565364707*^9}, {3.653994603636812*^9, 3.653994614428404*^9}, 
   3.6539952631947737`*^9, 3.653995294100144*^9, 3.654948691527788*^9, 
   3.68445013169343*^9, 3.684450195062241*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"series2", "[", "5", "]"}], " ", "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "30"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"30", " ", "\[Pi]"}], "-", 
    RowBox[{"60", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{"30", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "-", 
    RowBox[{"20", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", "x"}], "]"}]}], "-", 
    RowBox[{"15", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", "x"}], "]"}]}], "-", 
    RowBox[{"12", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"5", " ", "x"}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.539348901716475*^9, 3.539349025693151*^9, 3.592056901169058*^9, 
   3.59205693210773*^9, 3.592057098009361*^9, {3.653994556897757*^9, 
   3.6539945655319557`*^9}, {3.653994603705914*^9, 3.653994614503924*^9}, 
   3.6539952632640333`*^9, 3.653995294316313*^9, 3.654948693593987*^9, 
   3.684450131774096*^9, 3.6844501951616697`*^9}]
}, Closed]],

Cell["Verify that they are identical", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"series2", "[", "5", "]"}], "-", 
   RowBox[{"series", "[", "5", "]"}]}], " ", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539348901862293*^9, 3.539349025783277*^9, 3.592056901228616*^9, 
   3.592056932189663*^9, 3.592057098170868*^9, {3.6539945569647207`*^9, 
   3.653994565644332*^9}, {3.653994603768785*^9, 3.653994614569409*^9}, 
   3.653995263329564*^9, 3.653995294804822*^9, 3.654948696107205*^9, 
   3.684450131874621*^9, 3.684450195253351*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 2: f[x_]=...  for x=[0,2 \[Pi]]", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=1 /; x <= N[Pi];
f[x_]:=0 /; x >= N[Pi];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349047726298*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0H0s1AEYB/Cfk7eQO3Fl3u6UU6ezSGolnLykIm5XXpIuqabiOKZ5W4mp
lrxlXlahvEVEtZuWQy93qvV2taTi8k5ebjPJ6cj1snmeZ/vuu89/3z30cD7n
GIkgCN7f/Gv19uVvBzenuRD/b8rVtyRJXJzf6LrkLMu2G4X57eBxhaaKHScF
b/2d5/8g5jP45begdNKaPrCbO3e+OnwIHBLjMyUM/g5uozPPP66aBHOLmRWy
6CmwqUbrztzj0+ALmyT3H1+cAXt67+ZVZ86CJZdmGBlJc7j3ipGot1gJPnLm
Xs5U/gI41Upsf7Z5EWy3mDpLiiTclvz8UNAPWoQa2L40qis1ngT2CHgSIhSo
g22H90lsM5eBBeRY59ICDfDRu1LORK4mmME65X/mlha4p6qrlGmlDb5q4SGX
3UR3EGVFCX1o5cAvtoGlDtg8r+z1nNWSCcLN1TNwgIGOkI/3v2KiL1zLPS20
Q9f5OClKHdBvFd1pF53QRlybooMu6C2kN3RPd3RIk6Dezgtdrtf2RM0PzZJw
J2sOof3jlAl5R9Dx9HK15GPoR6kTVL8otJfTefZMCppX01jodh2tyZ42O1uO
bvjqWNFaiVbqP2rc1oAuiBe/cGxDv2B/Ua7rQ2/sIR2mrF0OJigHbAbuoH3k
2wLDanXBEXUh0SYiPXD/ol6+9KU+7uv4zQ2XrACrotarHD4Z4D/EPmv5J8ng
APNd79xH0aKRQbkwmgJOHrMIpcrRFaGKHdQEQzBNh89Xn0X7qW2siY5bCR6O
zOYkzqOlulm+sUlGYGsLG5H2MmMwM0XX3uIyOmNlzk+aDhXsbdrEepaHDguN
EXIoq8CMscSdvGx04AjNU5+6GiwzO1FYU4A+YO083FOIlrIojoYl6KcuLe9T
bqBv8wz0OdVoQWVz+kIzWmuDdmxAN/qco6w9U4ZWOt9fIepFT/qG1jOG0B/4
TaPzk+jrD4LCqhfRxiJWQzdhAs4WkxbI6ui0zvqSZC30cQXR6U9G96k612Qa
ooO17whajNB7TfaTGSZoCZ15+KAp2oWpasg1Rz90+LggsUTbb6/dM09H/wFa
hmTn
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->NCache[{{0, 2 Pi}, {0., 1.}}, {{0, 6.283185307179586}, {0., 1.}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.539349050207024*^9, 3.592056901529409*^9, 
  3.592057098747891*^9, 3.6549489425804453`*^9, 3.654949074672969*^9, 
  3.654949595090034*^9, 3.654949626625914*^9, 3.6555539351561403`*^9, 
  3.684450221155694*^9}]
}, Closed]],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
c[0]= 1/(2 Pi) Integrate[ 1  ,{x,0,1 Pi}] +1/(2 Pi) Integrate[ 0  ,{x,1 Pi,2 \
Pi}]\
\>", "Input",
 CellChangeTimes->{{3.654948984508869*^9, 3.6549489847297783`*^9}, {
  3.654949615571412*^9, 3.65494964814408*^9}, {3.6549497088990498`*^9, 
  3.654949727640229*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 CellChangeTimes->{
  3.539348898608249*^9, 3.539349024083955*^9, 3.592056900043282*^9, 
   3.592056931073666*^9, 3.592057096800711*^9, {3.6539945554408913`*^9, 
   3.6539945642812357`*^9}, {3.6539946025558243`*^9, 3.653994613374568*^9}, 
   3.654948390510152*^9, 3.654948474194743*^9, 3.654948511022745*^9, 
   3.654948944741342*^9, 3.654948988970234*^9, 3.654949076772931*^9, {
   3.6549495968046494`*^9, 3.6549496489913397`*^9}, 3.65494972964876*^9, 
   3.6555539379157343`*^9, 3.6844502212011747`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
c[m_]= 1/(2 Pi) Integrate[ 1 Exp[- I m x] ,{x,0,1 Pi}] //FullSimplify\
\>", "Input",
 CellChangeTimes->{{3.654948986114046*^9, 3.654948986361717*^9}, {
  3.654949655056314*^9, 3.654949657327663*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "\[Pi]"}]]}], ")"}]}], 
   
   RowBox[{"2", " ", "m", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348899882002*^9, 3.539349024467109*^9, 3.592056900477057*^9, 
   3.592056931261525*^9, 3.592057097008535*^9, {3.653994555571148*^9, 
   3.653994564408968*^9}, {3.6539946026898823`*^9, 3.6539946135026283`*^9}, 
   3.654948392881493*^9, 3.6549484760088367`*^9, 3.6549485135191097`*^9, 
   3.6549489471425743`*^9, 3.6549489908822393`*^9, 3.654949078761942*^9, 
   3.654949663153792*^9, 3.655553939438118*^9, 3.6844502213434*^9}]
}, Closed]],

Cell["term[0]= c[0];", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["term[m_]= c[m] Exp[I m x] + c[-m]  Exp[-I m x]  //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]]}], ")"}]}], 
   RowBox[{"2", " ", "m", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348900096125*^9, 3.539349024623434*^9, 3.592056900596742*^9, 
   3.592056931376429*^9, 3.592057097120233*^9, {3.653994555646126*^9, 
   3.653994564481369*^9}, {3.653994602805489*^9, 3.6539946136003237`*^9}, 
   3.6549484779031267`*^9, 3.654948518518489*^9, {3.65494895212764*^9, 
   3.654948954010151*^9}, 3.654948994665717*^9, 3.6549490833912086`*^9, 
   3.654949669189684*^9, 3.655553942728485*^9, 3.684450221397848*^9}]
}, Closed]],

Cell["series[n_]:= Sum[ term[m] ,{m,0,n}]", "Input",
 CellChangeTimes->{{3.6549485336493683`*^9, 3.654948534968346*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"series", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{{3.654948537062978*^9, 3.654948544343122*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   "\[Pi]"]}]], "Output",
 CellChangeTimes->{3.654948544832046*^9, 3.6549489574770317`*^9, 
  3.654948998965178*^9, 3.654949088991107*^9, 3.654949672981954*^9, 
  3.655553946080818*^9, 3.6844502214467688`*^9}]
}, Closed]],

Cell["Plot the series with different numbers of terms", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Plot[ Join[{f[x]},Table[series[i],{i,2,5,1}] ] //Evaluate
  ,{x,0,2 Pi},PlotStyle->colors]\
\>", "Input",
 CellChangeTimes->{
  3.653994609851053*^9, {3.654949113915764*^9, 3.654949118961306*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxF0H0s1AEYB/Cfk7eQO3Fl3u6UU6ezSGolnLykIm5XXpIuqabiOKZ5W4mp
lrxlXlahvEVEtZuWQy93qvV2taTi8k5ebjPJ6cj1snmeZ/vuu89/3z30cD7n
GIkgCN7f/Gv19uVvBzenuRD/b8rVtyRJXJzf6LrkLMu2G4X57eBxhaaKHScF
b/2d5/8g5jP45begdNKaPrCbO3e+OnwIHBLjMyUM/g5uozPPP66aBHOLmRWy
6CmwqUbrztzj0+ALmyT3H1+cAXt67+ZVZ86CJZdmGBlJc7j3ipGot1gJPnLm
Xs5U/gI41Upsf7Z5EWy3mDpLiiTclvz8UNAPWoQa2L40qis1ngT2CHgSIhSo
g22H90lsM5eBBeRY59ICDfDRu1LORK4mmME65X/mlha4p6qrlGmlDb5q4SGX
3UR3EGVFCX1o5cAvtoGlDtg8r+z1nNWSCcLN1TNwgIGOkI/3v2KiL1zLPS20
Q9f5OClKHdBvFd1pF53QRlybooMu6C2kN3RPd3RIk6Dezgtdrtf2RM0PzZJw
J2sOof3jlAl5R9Dx9HK15GPoR6kTVL8otJfTefZMCppX01jodh2tyZ42O1uO
bvjqWNFaiVbqP2rc1oAuiBe/cGxDv2B/Ua7rQ2/sIR2mrF0OJigHbAbuoH3k
2wLDanXBEXUh0SYiPXD/ol6+9KU+7uv4zQ2XrACrotarHD4Z4D/EPmv5J8ng
APNd79xH0aKRQbkwmgJOHrMIpcrRFaGKHdQEQzBNh89Xn0X7qW2siY5bCR6O
zOYkzqOlulm+sUlGYGsLG5H2MmMwM0XX3uIyOmNlzk+aDhXsbdrEepaHDguN
EXIoq8CMscSdvGx04AjNU5+6GiwzO1FYU4A+YO083FOIlrIojoYl6KcuLe9T
bqBv8wz0OdVoQWVz+kIzWmuDdmxAN/qco6w9U4ZWOt9fIepFT/qG1jOG0B/4
TaPzk+jrD4LCqhfRxiJWQzdhAs4WkxbI6ui0zvqSZC30cQXR6U9G96k612Qa
ooO17whajNB7TfaTGSZoCZ15+KAp2oWpasg1Rz90+LggsUTbb6/dM09H/wFa
hmTn
      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1nk0VesbB/CDRAc5mq4pyc2sQYhKfXezUpHcUulykTTrZrpKNMk8RmQo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      "]], 
     LineBox[CompressedData["
1:eJwVlHk8Vev3x82chHP2PkQkt5BmU+krtLhuiTJlSipJRRGZEtLpUkky3EyV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      "]], 
     LineBox[{{5.38614577510123, 0.002492328296774482}, {5.387780131629036, 
      0.003142165067111069}}], LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAcv2tlNacFUBA+olH+BeDP9ALwJ/O
nhVAwNM9O1axhD+KKOS1vqIVQOD6YwXr5oc/AGIs4p6qFUBg0v48bV2OP9dH
TZMfyhVA0BFw0XdmnD+EE4/1IAkWQNhSz00TGaw/RxuwLcORFkA4mowXB5C+
P15ccLVSERdAkB+BdlXGxz8m6XlDYI4XQBZM5qiGWtA/V+YgRQ0WGEDQI4Dh
63XVP90cZ5anlBhA8Kk+AgVl2j9WJTzl3JYYQGKkpUhNe9o/0C0RNBKZGEB+
Xpg9l5HaP8I+u9F8nRhAgJT0FzC+2j+oYA8NUqYYQPTQNNB0F9s/cqS3g/y3
GEB4na9aRMrbPwcsCHFR2xhAtUtXIMww3T+ANN2/ht0YQOBZRQY9R90/+jyy
DrzfGEAoQ43Arl3dP+xNXKwm5BhAkfDNlpSK3T/Sb7Dn++wYQJx8fApp5N0/
nLNYXqb+GEBmvisRL5jePxW8La3bABlAwUlnB6qu3j+OxAL8EAMZQLUFcmQl
xd4/gdWsmXsHGUBnu4w3HfLeP2b3ANVQEBlAouD2gRBM3z/g/9UjhhIZQKud
zO6NYt8/WQircrsUGUDBX56LC3nfP0wZVRAmGRlA+/HKOQem3z/FISpfWxsZ
QDUkcD2FvN8/Pir/rZAdGUD0I6ZVA9PfP7gy1PzFHxlAeA6Se4Hp3z8xO6lL
+yEZQLb8WKj//98/+6Lx4g==
      "]], 
     LineBox[{{5.397393993557296, 0.006991541695707593}, {5.399316765942949, 
      0.0077668964747940605`}}], 
     LineBox[{{5.39162567640034, 0.004676424859798134}, {5.393548448785992, 
      0.005446303031795829}}]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVmHk4lG8Xx8fMWGL0a6GkUqRSFFmyd25LCwmpEGlBipAWS0qWSrJvWcoW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      "]], 
     LineBox[CompressedData["
1:eJwVlHk8VesXxs0S5+xz9hYScgudRkKR5F1JhqRMSXLpSpRESRKSyhBXIqVC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      "]], LineBox[CompressedData["
1:eJwVVXk4lWkbpyRN1nHeJ0pIaaREi1Kku0IoMqU6rYwUSmSKIcopSxRlXw7Z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      "]], 
     LineBox[CompressedData["
1:eJwBwQI+/SFib1JlAgAAACsAAAACAAAAsMwA2aJlF0BQHJggL26cPyjtFgdM
ZxdA0GHpwXCsnT/0hfffHG8XQBBe5P3IzKE/Jul5Q2COF0CMrEd9I0WuPxuF
gPd+kBdAwEaxq54mrz8QIYernZIXQIzuAzKdBLA/BL2NX7yUF0AcTCjoenaw
PyxHLjb2lhdAZqYWdqTusD/u9JrH+ZgXQI6+EDDkW7E/4pChexibF0DayYbl
bs+xP8zIruNVnxdASPJDQy64sj9yqOODS7AXQAz9HYcYcbY/vmdNxDbSF0Do
8zkaAkm+P1fmIEUNFhhAWQGrYx25xz8y/2WuBxgYQHfmIpek/Mc/DBirFwIa
GECrIOnrWkDIP8BJNer2HRhAeEe61VPIyD8orUmP4CUYQCfPoJxu2sk/+HNy
2bM1GEDZNhNfBgfMP5oBxG1aVRhAm/lRCNA/0D/dHGeWp5QYQJW/fM1A7tQ/
ViU85dyWGEB7iKAnKBnVP9AtETQSmRhAhBhw9B9E1T/CPrvRfJ0YQKwR3Oc/
mtU/qGAPDVKmGECAUbY5OkfWP3Kkt4P8txhAEPzqK+Cj1z8HLAhxUdsYQPcI
AmsnZto/gDTdv4bdGEB9MQNVn5LaP/o8sg683xhA/2Mmfx+/2j/sTVysJuQY
QA/aY4Y3GNs/0m+w5/vsGEBaPXn+vsrbP5yzWF6m/hhA8FecSvAw3T8VvC2t
2wAZQOakG3/MXd0/jsQC/BADGUCgwWe2rIrdP4HVrJl7BxlAzRhCHHjk3T9m
9wDVUBAZQDFlGkszmN4/4P/VI4YSGUALL2YcKMXeP1kIq3K7FBlAfj1ozR7y
3j9MGVUQJhkZQNCFj7wQTN8/xSEqX1sbGUBjkKtxC3nfPz4q/62QHRlAi9ds
9Aam3z+4MtT8xR8ZQIFoSAAD098/MTupS/shGUBv+bFQ///fP06lNjY=
      "]], 
     LineBox[{{5.067263359730418, 0.005932851564675448}, {5.0692007479378915`,
       0.00528208393195316}, {5.073075524352838, 0.003976983529030281}, {
      5.075012912560311, 0.0033227208532238955`}}], 
     LineBox[{{5.102446329578125, -0.006042372311802102}, {
      5.105236168596891, -0.007003060757371032}, {
      5.106011123879876, -0.007270119431336083}, {
      5.107948512087349, -0.007938123676706571}, {
      5.109885900294822, -0.008606609269882867}}], 
     LineBox[{{5.749623118234478, -0.03589891621459318}, {
      5.751637664261484, -0.03482848110496076}, {
      5.753292122351297, -0.03394260531850296}, {
      5.755238543633428, -0.0328925793047149}, {
      5.759131386197691, -0.03076718097516612}, {
      5.761077807479822, -0.029691816170441643`}, {
      5.762732265569635, -0.02877112127698106}}], 
     LineBox[{{5.0906088876304665`, -0.0019809353604128693`}, {
      5.092449406427566, -0.0026106482328984715`}, {
      5.094386794635039, -0.003274257325661195}, {
      5.096614791073634, -0.004038316865238478}, {
      5.098261571049985, -0.00460365073462167}}], 
     LineBox[{{5.78819301701294, -0.0138358443330098}, {
      5.789814950092197, -0.012835820330492437`}, {
      5.791436883171453, -0.011829999629967891`}}], 
     LineBox[{{5.769111451374624, -0.02516412455256717}, {
      5.77073338445388, -0.02423260581271028}, {
      5.772355317533137, -0.02329524453955495}}], 
     LineBox[{{5.830172461417234, 0.013899982120063409`}, {5.831794394496491, 
      0.015048227879726067`}, {5.833416327575748, 0.016202110959803895`}}], 
     LineBox[{{5.7767440776299495`, -0.02072958760957999}, {
      5.778366010709206, -0.019770603844858875`}, {
      5.780274167273038, -0.01863492877939557}, {
      5.781896100352295, -0.017663269340352006`}}], 
     LineBox[{{5.83780508767256, 0.01935258604220172}, {5.839427020751817, 
      0.02052729179635482}, {5.841335177315649, 0.021916467218182245`}, {
      5.842957110394906, 0.023103350092167435`}}], 
     LineBox[{{5.822539835161908, 0.008572383079549856}, {5.824161768241165, 
      0.009693999668518055}, {5.825783701320422, 0.010821288497052411`}}]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVmHk4lG8Xx8fMWGL0a6GkUqRSFFmyd25LCwmpEGlBipAWS0qWSrJvWcoW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      "]], 
     LineBox[CompressedData["
1:eJwVlHk8VesXxs0S5+xz9hYScgudRkKR5F1JhqRMSXLpSpRESRKSyhBXIqVC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      "]], LineBox[CompressedData["
1:eJwVVXk4lWkbpyRN1nHeJ0pIaaREi1Kku0IoMqU6rYwUSmSKIcopSxRlXw7Z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      "]], 
     LineBox[CompressedData["
1:eJwBwQI+/SFib1JlAgAAACsAAAACAAAAsMwA2aJlF0BQHJggL26cPyjtFgdM
ZxdA0GHpwXCsnT/0hfffHG8XQBBe5P3IzKE/Jul5Q2COF0CMrEd9I0WuPxuF
gPd+kBdAwEaxq54mrz8QIYernZIXQIzuAzKdBLA/BL2NX7yUF0AcTCjoenaw
PyxHLjb2lhdAZqYWdqTusD/u9JrH+ZgXQI6+EDDkW7E/4pChexibF0DayYbl
bs+xP8zIruNVnxdASPJDQy64sj9yqOODS7AXQAz9HYcYcbY/vmdNxDbSF0Do
8zkaAkm+P1fmIEUNFhhAWQGrYx25xz8y/2WuBxgYQHfmIpek/Mc/DBirFwIa
GECrIOnrWkDIP8BJNer2HRhAeEe61VPIyD8orUmP4CUYQCfPoJxu2sk/+HNy
2bM1GEDZNhNfBgfMP5oBxG1aVRhAm/lRCNA/0D/dHGeWp5QYQJW/fM1A7tQ/
ViU85dyWGEB7iKAnKBnVP9AtETQSmRhAhBhw9B9E1T/CPrvRfJ0YQKwR3Oc/
mtU/qGAPDVKmGECAUbY5OkfWP3Kkt4P8txhAEPzqK+Cj1z8HLAhxUdsYQPcI
AmsnZto/gDTdv4bdGEB9MQNVn5LaP/o8sg683xhA/2Mmfx+/2j/sTVysJuQY
QA/aY4Y3GNs/0m+w5/vsGEBaPXn+vsrbP5yzWF6m/hhA8FecSvAw3T8VvC2t
2wAZQOakG3/MXd0/jsQC/BADGUCgwWe2rIrdP4HVrJl7BxlAzRhCHHjk3T9m
9wDVUBAZQDFlGkszmN4/4P/VI4YSGUALL2YcKMXeP1kIq3K7FBlAfj1ozR7y
3j9MGVUQJhkZQNCFj7wQTN8/xSEqX1sbGUBjkKtxC3nfPz4q/62QHRlAi9ds
9Aam3z+4MtT8xR8ZQIFoSAAD098/MTupS/shGUBv+bFQ///fP06lNjY=
      "]], 
     LineBox[{{5.067263359730418, 0.005932851564675448}, {5.0692007479378915`,
       0.00528208393195316}, {5.073075524352838, 0.003976983529030281}, {
      5.075012912560311, 0.0033227208532238955`}}], 
     LineBox[{{5.102446329578125, -0.006042372311802102}, {
      5.105236168596891, -0.007003060757371032}, {
      5.106011123879876, -0.007270119431336083}, {
      5.107948512087349, -0.007938123676706571}, {
      5.109885900294822, -0.008606609269882867}}], 
     LineBox[{{5.749623118234478, -0.03589891621459318}, {
      5.751637664261484, -0.03482848110496076}, {
      5.753292122351297, -0.03394260531850296}, {
      5.755238543633428, -0.0328925793047149}, {
      5.759131386197691, -0.03076718097516612}, {
      5.761077807479822, -0.029691816170441643`}, {
      5.762732265569635, -0.02877112127698106}}], 
     LineBox[{{5.0906088876304665`, -0.0019809353604128693`}, {
      5.092449406427566, -0.0026106482328984715`}, {
      5.094386794635039, -0.003274257325661195}, {
      5.096614791073634, -0.004038316865238478}, {
      5.098261571049985, -0.00460365073462167}}], 
     LineBox[{{5.78819301701294, -0.0138358443330098}, {
      5.789814950092197, -0.012835820330492437`}, {
      5.791436883171453, -0.011829999629967891`}}], 
     LineBox[{{5.769111451374624, -0.02516412455256717}, {
      5.77073338445388, -0.02423260581271028}, {
      5.772355317533137, -0.02329524453955495}}], 
     LineBox[{{5.830172461417234, 0.013899982120063409`}, {5.831794394496491, 
      0.015048227879726067`}, {5.833416327575748, 0.016202110959803895`}}], 
     LineBox[{{5.7767440776299495`, -0.02072958760957999}, {
      5.778366010709206, -0.019770603844858875`}, {
      5.780274167273038, -0.01863492877939557}, {
      5.781896100352295, -0.017663269340352006`}}], 
     LineBox[{{5.83780508767256, 0.01935258604220172}, {5.839427020751817, 
      0.02052729179635482}, {5.841335177315649, 0.021916467218182245`}, {
      5.842957110394906, 0.023103350092167435`}}], 
     LineBox[{{5.822539835161908, 0.008572383079549856}, {5.824161768241165, 
      0.009693999668518055}, {5.825783701320422, 0.010821288497052411`}}]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwdl3c4Vu8fxx88jy2KlL4VlSQVQpHR5yariJKVVJJUsrMikUrISohSikLT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      "]], LineBox[CompressedData["
1:eJwVVHs81PkaFiu2+X3nTCgmViyhkKJz6mzS242iE0kIxWd20qZjynUtRxda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      "]], LineBox[CompressedData["
1:eJwVlHs01Vkbx9GdsH8NdaaEjFCMS7wuE55nTAlFb6EJ1RjdVEbqyCpxotGb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      "]], 
     LineBox[CompressedData["
1:eJwVVXs4ldkXVsk9OfujVKpT5FLuFZpxWblHI+QSTqIwqeiCUi4hIyJMbiUJ
53QuX2oyUyKyMjGZEGMiuqgpJPcSUuj3/f7Yz37Ws/fz7rXW+653r9l72DVw
vpiYWD6z/r9j0KP0tFEW2He+3yPfGo+KN3R8fD+yIHuesrfM1wT8T/6Od8I4
C4QJd/RyPBPRgLwcPzfBAs7lmx8ulPyCU/pqD3qnWCDl6lUSwT6LdpscvUam
WTDTvLZTOjgZ30x57TKaY87FD413KqeijUSOm8diAkN3fQiv+QLmSFcP+7II
jH1/JV4XnIWCoNT0eIqAZhjX47FcNi775PPqmxKBB7Ocz3UN2TgxSCrnKRPg
Lb8xaemfg9ajW1xllhMw9bwfJJjOQZZLrYuuCgG/SwbfFl/KRX+3/gGjVQRu
sR8fTdLLw7Cyu6lebAKR6hF2J5ry8MhG5ZX/rCXw2T4CQuMuolVn944aNQYv
sOXzsOwlfHl52ElCi8CMqXFQtnk+LlaV/SnXgED2Pz79+3MK8GXihe33NhKQ
MrBzn9a4gsK+Zdu7NzOxjeMj08orGGFf7DjfhECdDa9BZ1sh1js29Mj8QOC2
9cORG62FmHpAoSzQlImf/B4qfegqvggxdgg1J9DKtvV6OXYVww1st5VbEpg/
prNfK6EIuyzibTp2ErC++uOBwNQS1LISdne7E3BqnNSarS/BUf8xessupn6S
pTQkxUWLwKXWlt4E9H8faR7ZykW5R4VWQRwC3qE9maoxXOzUVLc650tA3lej
PuEuF6+du2F5049AkHuOmcxHLk6cf/qifC+BixZZGe/VeSg5yI3uCiCQ2FJT
XeTLw7PyPMHmnwlI+JtEGV3m4TNWI5gHE3icKheQ+YSHR9q7LJJCCNxbj93y
JteQy5kyW3KcgFGzvcYmMT66/Xj/k1Ikw/+5B/ueaPMxo9HLTO8Ugdwvjksf
evOx4os9RymaQIOf638ZZ/g4ntzL140lkB7H0nn8Gx9Vyp/WK8YRSBhso8Sf
8dHT9qiCbgKB/bfY5rHzBBgX5qenmEjgS5u4LltDgFULZk/qJBFwXdB39+kO
AfboD12kkgnERpW1dYUJcHVt8jvtcwSOrYqIfJgvQPuRE/OpNAKHkp4padwX
4JlYxZ+00wl8jb/VAm8FWHp9wSGSyeC7NsXMzRfi+x+LyjdcIAAbAuKs1IWo
EJzRzsomILPXWdzTRoiO0xvYG3IJ8GV21v4ZJMRw9RUWrIsEauJyl2omCvG3
8rsp6/MJvNE3Ni/nCrHzHV+oUEAgrcDscjAKkQq3GtcqJKCYf1t5ySshmhYb
EoUiAvR6sw/UlBBPGLRwtEoY/cSYf3hORFjkWxO1mMfUJ1nXtnqDCF+MeP+l
ySdwSmYUZ61FKK7i0CsvZPpdIV2c5CNCi9I+PU2aQMlJl3WRYSLc39XuJF9K
IPoba4llsgi5wccuadxk8gtYtcK6UIRNuf4Vi24RED+/N2R7mQglNebma/zO
4G8bUOHUi1DfbXjNotsEApZc5xR1iPBgT8oh9XIC4Vp/sav6RZjNOpkqV8HM
o94exS1fRNhSrNSx7h4BoXFbHkeKxi9PxCdkqwnIBVoCWULjxj3FFutqGH4T
/gw1VaORk5bpK/uAQLJRn6SmPo15KjoitT8Z/0hzl/c0pfHBNpUGmToCajPL
Fp+wpfFbVwVR+4vpX0O1j8iZRjVJoYFMAwFO6fbjM7to3JNnHa36mEDP6GSF
vj+NyXUbL0s3MfmFvXl+52caH7q19q59QsBZQ2XhYAiNQ/EoLt3K5KN8xLP4
GI0ahLNjbRsBk/7LBR3HaXS2cAyVesr4hZpE4v2TNM5bxVKV6iCg/Ugn/VUU
jVqOYpYjzwjEOX21EouhMeBFQZrkcwJPm/mGW5n4vFTa9eEXjD/MrPyaFU1j
w0XNSYluAp0tnzSfnqLxY/1SpeHXzDzq7FX2jKRR2+P2Hom3BMQ+SNbmhtPo
foYbO/SO0efS4+sdjtCYScHfC/sYPV3Iakg5QGMl6PUPview63v5ltAAGj+3
NhouHGD6Y/Pu3E0OjSvn7rkMDjJ8yZLmOjcad6V7FoiPMP74b02rhCON8VW2
VQOjBNjdz/p3bKWx2vHdQvFPDF7CpjfZm2lkSx8+vGCSud/rEe2jwtS/yEll
eorxI42KW1fkaew5U/VH+zSBAi+XjEoxhq/imNTZbwzeYpPfro4yelMeXPt8
lvHvm3dOf30twkSVxy0t3xl/zZA7UvJEhAFsUXT9PAomT9ooBVaL0EYtWatq
AQUD5d++W4pEqHanc/DvhRTYp0rGGmUz+tS2PcOXpOCU2iPZnXEi7Ndbp18g
TUHNmrijSQdEKDJ+l3J2EQVN6xV325mKUNtuj5mvEgWWxuWetu1CXORoPrBz
KQVj9ytXeFcKcaz2erz+MgpmpnS7JAqF2PQ6xGvXCgq+cGizgzHMPHu8GNu0
koLcX3SaD/kJMdP73pX1qyk4srD5B2qrEI/4XnJgr2Hy2bHv1hu2EF32Rk4p
qTL3G2t1Or4LcFNXb/onNQoaLA5GX38tQIUpQdByDQra7HwPRFUKcDxEaW5S
kwLduBbjsjwB3o741/OtNgWl4x29q5wEaPzLDtnKTRQoa/s1GZbxUTlFt+Km
EQXp+XOOE2f5+CVtUSDPhAL9GPfkod187MocYuX/QAHb2bB12UY+Vkt6i46b
UhBUPuVfJs3Hi+tU4gvNKVCZ3He2u/MaRhWkKEcBBeJmxn7jN66hKc/uWJA1
BW+kZwI9XK7hSqH6ao4tBebVlY09a66h2OrschN7hq/TxfHszzx8aeqR7udA
QWifzW7HGh7iHw/XmW2nwDUm0Espg4dFd0vaDJ0o2GVxYn8ph4dxVfGnNZ0p
aN3Mj0/R4qE/+mmvcqVgqD3L7OYEF8G5bETbjYJsxbKM4zVcVH20KknagwI6
L2NleyoXxRtnDb97UnBvRiXzuTsX69uq0gZ8KHBKqP3wz/sStH9rDLX7KJhT
va3AXcD8r31LhssDKVheHTkw1lCMcrsTE7N+piCg401/dmYx9p+y5VQFU2Ai
FRud71SMjR//GM87SAHnTsPneUrFWDpxoeh8CPO+g1R1/bMiTJs++tOZwxQ4
NPni4KUiDJl1/hp5lAJ+yavRCJ8idA6v+dU9jIJw093k19VF+D9Cc32q
      "]], 
     LineBox[{{4.995870604285046, 0.0093176821194519}, {4.997517384261396, 
      0.009858817508956404}, {4.999454772468869, 0.01049481368454629}, {
      5.003329548883816, 0.01176442596277931}, {5.005266937091289, 
      0.012397873318005275`}, {5.007204325298761, 0.01303030234117984}}], 
     LineBox[CompressedData["
1:eJwVUns0lXkUldV43KLw+4jyzB0yFqPHaEnOUYgpikrGK+tSLbpeU/RgbsVM
7xfpWprIK+7r++hW0iBkDJWkO97dSiGmiFFCqPnmj7POOmufc9Zee29zXqzf
LlUVFZUQtv7vvCteFQIdgpW+ZXRI7kVwncx+ukGP4ElX2Qn5ijQIU3j7Oi4m
KNJ+9/Tbe5eg20lry7gTweTqmuqck9nAc5iy/9eZoFmhx5Fhkxx4a9W/YNiF
4Lajjr8F38qBKVL1pG8dwV7/w5rHlddg0Qh/c+uPBCk3su3uwjzYXtDkczOQ
YLO7oDzNuQCUWeV2JcEEBVVlqseOFEDExUJtaSjBi5X1hh21BbD/l+TmfB5B
zvgfT2m3QkjfYeuTHkVQuK4Catddh5Z5Z73jDxPc8IDH8E2KwfCghzQzmaC9
aVHC9qBi4PWpaN4TEPyo9NIJzSyG8cqEPzmpBFeumpXUzReBUczONYVnCGbO
N3LJGBJBRLdh1sNzBHv8knzsLcRAe7R+Gr1AMPC9WUWrvxjQ1Eu+NoOg+/pH
ySurxLCrZfmyjqsE3y9KWaYqkADjPHx8Nofla2UWI5FKYFJU3Lc0j6Cs/PJJ
r04JnD62JDfuOkGbx2eMwu2k0DrcPissJqjYdIrq2iEF48C0oCoxwarUE8PO
R6VQulzNgMMQrLtjkF3/WApTOTX7vy8lOKArhDdjUlg3L0nhLyf40Gbx9iF9
GbT1jpwrKCNYPZ3Rmhskg88ZXXPXVrN4nqN+QocM3OZk8MJrCaorY+ac+SCD
c9E+NafqCK4ZL/U5oE2DmUddUnsDQc3sRGxCGiLlv3TNPCD4KUAqdAigQW6y
2nFpE0Enp/3y3TE0uE/IxmJbWP4cf22nTBrOh+/ZIlQQbLRe5NcmpqHziTlT
2UowNrKf51RBg7mzcl5vO8FJaZ1yzyMaokTCSM0ugpLnfruDu2m4RXwb7J8R
VFn/olR/kIbZo/O4/s9ZvfdHH7z8kQaP4fqU5JcEF2q3pXZ8peHiT0d78l8R
hIUNhc80Geiqd3J50Evw1ofXd3J1GbBYPv77SD/BndH1hVwjBvg5JVPUIMHl
vQahkWYM3OZE7XB+SzAi7dqrKC4DXxItb/OGCN7cuWn1smUMePa+0D31ns1L
+IbEgu8YSNucFVcyStBcb05Fpy0D3RVbm9vGCFZYgUMjO1taa9vOfCT4s7XN
gnh2Pzqj8ZTFBJvv4kChwpqBMpXUAc8p1n+bN3pDlgyoRK91j51m/a7Y21Np
yoBX10T+5VmCRvZmYW6GDKS7y1UqvxJkNLtVU3QYUN7gh76eQ+ESQ2O3BA0G
uCZWlRpzKVx6mys1/kJDTslnHa4ahVdGrbRujdGg79q8x1WDwhaJah3nDeuP
Iq8qhEPh/H35SeadNKhFJOgdnk9h9+Ds6EQjDYJxz0ihNoUpB00Gz5XT8On4
kmr5Qvb+gbVDbxENb8R1Ue8I+7/X3eHRERpC12TWqBtQKCqNrwmJoqG9KUrf
0pBCxecG35KtNPw1onM/2JhCuWlV0QULGlyO9RscMqUwQOvQVRMNGsp070Zf
NqcwuPn6JH9IBkWrwgybuRSOfnSs97whA5OGFbFvrSjcknTsfnuaDIQB6vVq
NhQK72khN14Gx5OYOLCjkKOJW7+xlcGe2pmG0h8ovCopErxMl0KPX4vx49UU
KhvKFYJIKQT0Fez7x4lCZ3Hb19cuUvBU32hqARSqnZh+N9MvAWvvrMRLG1g8
VllzniuB3Bf8phIvCnMjz7ryx8SwKA4tmjay+teebqXuiUHj0sDjuVtY3JAS
P/UVw2DnKm5iAIWqZifbtfaKICxKMyk9kMJN3rrh0XYi6JxWtjDBFAqeuS0p
GC2GRpNfkwfCKPxSpZwWxheDOELxd0Akq7fliGvTriJYwAviBu6lsPBK6oGz
S4vAjB9qnhBNIZ/cHRlQXof/ANVCnf8=
      "]], 
     LineBox[{{5.3859534978626655`, 0.03421265801459206}, {5.387780131629036, 
      0.03362708437542972}, {5.389702904014688, 0.03300435329782682}, {
      5.393548448785992, 0.03173963067172224}, {5.395471221171644, 
      0.03109776316167187}, {5.3974901321765785`, 0.03041707340991348}, {
      5.399316765942949, 0.029795332870944685`}, {5.401047261090036, 
      0.029201216728242302`}}], LineBox[CompressedData["
1:eJwVVHk41esWdpAh1VZd34dECol9DOU4XUqLnKgMO5lCKDJedDUoXO0UlShK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      "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAvma+CgnmF0DAx+OKWC2EP05/j8xp
5xdAcDHplk72hj/cPmI7UukXQAAzC5on2Yo/Nl6e4S7sF0B4gSFUDF+QPyxT
o+jF7RdAWJRH74IGkj9UNkISeO8XQPgtBxSYzZM/rlV+uFTyF0DIuj29ddWW
PwontwQi9BdAWDd6DA7DmD9X5iBFDRYYQNInSHO6768/Mv9lrgcYGEBhWTDb
NpSwPwwYqxcCGhhAN9IHtK4xsT/ASTXq9h0YQCznmaT0b7I/KK1Jj+AlGECQ
2YSIufm0P/hzctmzNRhArLXmcRZBuj+aAcRtWlUYQEJWaQrFysI/3RxnlqeU
GEAiRDIRinzPP1YlPOXclhhAmhwfhzH1zz/QLRE0EpkYQIGpifIjN9A/wj67
0XydGEDceYeV3bDQP6hgDw1SphhAg3WqBsim0T9ypLeD/LcYQDIt40fGm9M/
BywIcVHbGEByGd24k6TXP4A03b+G3RhA0m761kDm1z/6PLIOvN8YQKn1h5MK
KNg/7E1crCbkGEAy7ylR8KvYP9JvsOf77BhAi/74muu02T+cs1hepv4YQBph
uWnVyts/FbwtrdsAGUBrsAOK3w3cP47EAvwQAxlAitKRrPdQ3D+B1ayZewcZ
QMXb6UFO19w/ZvcA1VAQGUCCoD+feuTdP+D/1SOGEhlAu8zixdon3j9ZCKty
uxQZQCsJvnpBa94/TBlVECYZGUBInyzRHvLeP8UhKl9bGxlAxzN3k5M13z8+
Kv+tkB0ZQIrUcyULed8/uDLU/MUfGUD+UkeXhLzfPzE7qUv7IRlAI/YK+f7/
3z+44Rdp
      "]], 
     LineBox[{{3.8943555524891873`, -0.025021977804388223`}, {
      3.8963328957949, -0.024118834853165738`}, {
      3.912984207843011, -0.01652172035753234}, {
      3.915065621849025, -0.015575243315821996`}, {
      3.917147035855039, -0.014629935897086194`}, {
      3.9213098638670667`, -0.012743381431627565`}, {
      3.9233912778730806`, -0.011802408224283564`}, {
      3.9254726918790945`, -0.01086315229310758}, {
      3.9275541058851084`, -0.009925748588282601}, {
      3.9286988835884165`, -0.009411014696005846}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAfFf/ILCsFUA4IY5jtnCXP7t+UPiO
rhVAyM6trea9lj/cvuCbVLAVQPw5ooFVE5Y/lII1QpiyFUAM8KYwwjeVP9Sp
hhl3tBVA1FlxFQOBlD+5G5VVCrYVQPQDqVUu5pM/rK1rY4C4FUDM0laRkPKS
P+zUvDpfuhVAsIaOtw44kj8s/A0SPrwVQCR804plfJE/H47kH7S+FUBs+r9m
v4OQPwQA81tHwBVAgAoRRDPHjz+8w0cCi8IVQJjo2V0P+I0/vxwXcjfEFUDw
qdD9tp+MPxwrKX0vxhVAeF+v5XAIiz9cUnpUDsgVQDh/aaRng4k/T+RQYoTK
FUDoguzjbICHPzRWX54XzBVASB30fgg1hj/sGbREW84VQKgZyFM+VoQ/73KD
tAfQFUCo1PUHkPKCP0yBlb//0RVAYE3q9jROgT+MqOaW3tMVQEAFrL//eX8/
fzq9pFTWFUDwr8SMx1R7P2Ssy+Dn1xVAwJQ3d3OqeD+k0xy4xtkVQJCVVUgT
fXU/FHK0lg==
      "]], 
     LineBox[{{4.44912460053905, 0.00265423561252965}, {4.45125543296081, 
      0.001951975392647222}, {4.452605281553779, 0.001507323033337546}}], 
     LineBox[{{4.464561083377228, -0.002418947346822811}, {
      4.466103767483478, -0.002923394171709587}, {
      4.468032122616292, -0.0035530603134370647`}}], 
     LineBox[{{5.5339331639272515`, -0.02662488112858892}, {
      5.535705298610735, -0.027433499612647308`}}], 
     LineBox[{{5.5013198410017985`, -0.011772217833612514`}, {
      5.503146474768169, -0.012597874598044873`}}], 
     LineBox[{{5.596479093932569, -0.054272228094321986`}, {
      5.598459715049404, -0.05509501015101873}, {
      5.6004299118445715`, -0.05590876135385227}}], 
     LineBox[{{5.588139636598527, -0.050758985670562806`}, {
      5.590224500932037, -0.051644393175133106`}, {
      5.592205122048872, -0.052481247791872666`}}], 
     LineBox[{{5.5547818072623585`, -0.03609106961296355}, {
      5.556866671595869, -0.03702925148664262}}], 
     LineBox[{{5.4897832066878856`, -0.006591889450265287}, {
      5.491609840454256, -0.007407652083749411}}], 
     LineBox[{{5.571460721930443, -0.04352803720544479}, {
      5.573441343047278, -0.044399043641456575`}, {
      5.575411539842445, -0.04526245310031816}}], 
     LineBox[{{5.544357485594805, -0.031373388216307724`}, {
      5.546442349928316, -0.03231998998090688}}], 
     LineBox[{{5.495551523844842, -0.00917401583250825}, {
      5.497378157611212, -0.009995175179209684}}], 
     LineBox[{{5.484399444008059, -0.00419888582665201}, {
      5.4858415232972995`, -0.004838128325824434}}], 
     LineBox[{{5.507088158158755, -0.01438363909318309}, {
      5.508914791925125, -0.015212878847518319`}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.13661968280487335`, 1.13661969485458}}, {{
     0, 6.283185307179586}, {-0.13661968280487335`, 1.13661969485458}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.65399461374361*^9, 3.6549484834084797`*^9, 3.6549485548749247`*^9, 
   3.6549489611779547`*^9, 3.6549490012808447`*^9, {3.654949091715728*^9, 
   3.654949119367454*^9}, 3.654949675659943*^9, 3.655553949605734*^9, 
   3.684450221525401*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[5] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}, {3.6549490143697987`*^9, 3.654949016022552*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0H0s1AEYB/Cfk7eQO3Fl3u6UU6ezSGolnLykIm5XXpIuqabiOKZ5W4mp
lrxlXlahvEVEtZuWQy93qvV2taTi8k5ebjPJ6cj1snmeZ/vuu89/3z30cD7n
GIkgCN7f/Gv19uVvBzenuRD/b8rVtyRJXJzf6LrkLMu2G4X57eBxhaaKHScF
b/2d5/8g5jP45begdNKaPrCbO3e+OnwIHBLjMyUM/g5uozPPP66aBHOLmRWy
6CmwqUbrztzj0+ALmyT3H1+cAXt67+ZVZ86CJZdmGBlJc7j3ipGot1gJPnLm
Xs5U/gI41Upsf7Z5EWy3mDpLiiTclvz8UNAPWoQa2L40qis1ngT2CHgSIhSo
g22H90lsM5eBBeRY59ICDfDRu1LORK4mmME65X/mlha4p6qrlGmlDb5q4SGX
3UR3EGVFCX1o5cAvtoGlDtg8r+z1nNWSCcLN1TNwgIGOkI/3v2KiL1zLPS20
Q9f5OClKHdBvFd1pF53QRlybooMu6C2kN3RPd3RIk6Dezgtdrtf2RM0PzZJw
J2sOof3jlAl5R9Dx9HK15GPoR6kTVL8otJfTefZMCppX01jodh2tyZ42O1uO
bvjqWNFaiVbqP2rc1oAuiBe/cGxDv2B/Ua7rQ2/sIR2mrF0OJigHbAbuoH3k
2wLDanXBEXUh0SYiPXD/ol6+9KU+7uv4zQ2XrACrotarHD4Z4D/EPmv5J8ng
APNd79xH0aKRQbkwmgJOHrMIpcrRFaGKHdQEQzBNh89Xn0X7qW2siY5bCR6O
zOYkzqOlulm+sUlGYGsLG5H2MmMwM0XX3uIyOmNlzk+aDhXsbdrEepaHDguN
EXIoq8CMscSdvGx04AjNU5+6GiwzO1FYU4A+YO083FOIlrIojoYl6KcuLe9T
bqBv8wz0OdVoQWVz+kIzWmuDdmxAN/qco6w9U4ZWOt9fIepFT/qG1jOG0B/4
TaPzk+jrD4LCqhfRxiJWQzdhAs4WkxbI6ui0zvqSZC30cQXR6U9G96k612Qa
ooO17whajNB7TfaTGSZoCZ15+KAp2oWpasg1Rz90+LggsUTbb6/dM09H/wFa
hmTn
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwdl3c4Vu8fxx88jy2KlL4VlSQVQpHR5yariJKVVJJUsrMikUrISohSikLT
SFRGZkalyN4zMs5zjj3C7+73D9frus5z7vt85vu9ydrJ6BwrjUYLwH/+/Wf7
zF3Tt+f6/tGb3jdotG4QExaT2HjvNMidrymS2NgNUx2RBi1RTmA8GJimr9oN
3epVvTlRflA3XCEW69UNDZcHXj+PigB/xHdcmOqGn6ETKx9FJUJd8Xbp6z09
cDjeuywuKh3mMhOL3xb0wf5jItmxOhmQVSf7YGtbHzQcn2L0lGfA4aJtkXdn
+4Dt/JsX7iWZkOR7JlRHvh+srm+gHue9gyCn/9o2p/WDSM6iH/UmFz6dX6d5
JGIAQkULH8VGfQbZPOkzVkcHQfvrw91FfEUgMh6IZJ0G4UugudAeoyJIaLLo
HgwdhIrF2paNbUVQvGXFOG/lIFSOlNmMjxZDz0NhF3G1IaiueOkdL1AG5eJK
Z1U2/4Hvfh4pg2aV8INfULewYRgMVOSDLRMqwbPHNqeLOQw108xLtd2V8L7t
6sNOrhGocbi4O+9iFUjXx6RfVsN8wjI/3KcaJkN9XCeSRuCnokbdnsRvYKHq
HcN/fhSGZ9iX1S//hPXEMek1dWOwvOVwmeK9n+A/b6rB+D0GQkfuBe969xPy
U+h/aubGANJEhUQmfoK9qJ3VpBgB0eZK20nXWlC5FaR604GA/R8vHnvsWgfr
3iyJJiwTcGwgfW10VB3wZdhKK6xkwoWV0x3BWXWg7M3483wzE+5dDLjgPl4H
24y3swprMWFI5KGvvusvsLgmpSMRxIS73t9S513qwTBCp9qbjYSUlFUO5N16
CEnz0eHnISG/zlzud2Y9pBtrsUWuIuG31EB+LVUPHi9dNphuIkG5bbE2zaUB
8jNvo0k1EvpVZP6aujTC74rJWLfLJMyddy/Wv9sI52z2fau+QsKK6LxAjcxG
YJwuZfD5k7BvVGelNNUIPi0/bpiEkhCeYCXBcGkCqV7Jd9PJJCgt3j3yzrkZ
kpJO6Pr8wOddtbvPGdkMwvInRrzqSVBZ0Og8md4MXdcOep9tIWH/3MQlTqIZ
4tMLnZZ7STgwZXL75KUWSMutMjk2RYKmm3RNVkgL2P96N/5hjgTtCfbVnC9b
YO/10Fc8SyToUrlJWUMt8DFwU4QXOwUGYyKFHLatoOeuxuoiTMER+3H6yVut
ULSjxAqto+DoSLVe1rNWEP4UJ7q4gQLjPz4tln2t8OCB5e/9WymwGOiYzLRq
Azsrq5J+OQosbXJUOPzbwJFpqye2l4KTfeEBlolt0Jw9HXpwHwVWPSDA0dkG
R4nQS+eAgnMdT3dYnmiHqBEZetkhCmwtvV0zvdvh8zFageNhCi60GX1kf9AO
B/jy4zmOUGDXwqaT2dwOL0Sl59lMKLA3bw9jn22HvUGKCefNKHBoyq4/saYD
5kNrH388ToFzwzlrdtMOqAzwYmw/RYGr8f4XJ9w7gLy2NkTbioLLv4TJjOgO
CDjsmGFkTYFHbYXviV8dQDe/KKFoS8HV79vjM450wp0JrmdyDhRc02ftZjh3
wt9djWIVjhT4fW2VOBHRCa20zJpDzhQEVN3JZtR0gl2TOrfYZQpu6NosWIx1
Aj/fZKGLGwU3K1Q1Mni74Mj+1+NZ7hTcLh/7YaHXBedbmNvoXhQEaX4RzrDr
gnoDHyOhKxSElD4+yQjpgl3feAyEvCm4o+H5zOJFF1ieK5Sh+1AQWmw4kl7Z
Baq8BG8/5nAkKccY6oIxdvmFd1cpqDztr/qGrRtGbawF3Hwp0E0c7TIT7IZp
1zBr8WsUVHWa32DdgufgLhbOcsym35RWsyh0w9vAFa/P+FHQ/3Ft6rJmNyh9
JFaPYnZNnVVaMukGvyDWszb+FNBimqv/2naD4Pr5jGrM4QEfLBc8u4FtS/0G
0esUrHeOI+aCukF2qr3iDOaXJ738Z+O7oTTrzfcozEp65qtmXnbD0pkdBlmY
vygpPZvK6wZznsALRZiNJdbunfzWDcxfiqoFmHsFZyvGO7pBV5j+Jw2zE0vz
cYrohptXpsNvYP5L5I4wl7uBZLc2OIw5pP2+LyHQA6z7u3XYMa+t9uQf29QD
DRJHEt7i+6bkmj0dkeuBNWcb7LUxKzxXlB8+0APeak2t3/H3lkStKR8y7oGs
3GUOLcxH/GdMB8/1AO2+svBrHK9Oh6ahAY8e0HfK3saG2f5Ernf/7R7487rl
1CEc73nd+7x9cT0wkmDSeR3nY7W4mWz3px44ZiKvUYLzmbRSsaTzaw88NN7g
8BXnW3ZZ2LijvQfSfewdynE96Lc2erYu9cBO1R++oR4UtFbkcLXw94J5oXLj
cVw/F97HPmwS64VBxY/Ra//VV6Tp53qNXmg8N9No50LBqmt7j/461gunYguf
LTlR8OSScF+tTS8MvXpufxPXb752I/uPwF6QVFhx3fYSBRN/TQyqqnvBWdu8
N8iGAv/hPd0Vbb2gUFD1PAP3x4rm1a5fRnthCyM0+ivuH6l3DTGlK/pAzaMt
os2SAuuLJh0FRn1wz0/m4AVjCkjTPU75Z/sgfjIwc5cR7h/N1Sx5bn1QlVzk
P2hIwQPRBvEPsX2gJKExqaRHQW2DsX1Wax84vhWIN1OnAGkYL6RY98OhAeSf
uoOCWWFJxRuu/SDmJtc0I0lB5siC6+mAfvhPkUcPSVCwOSZ5eE1SP5hKxAp8
EqOAbWi8JainH9YKGVYYr8b1FXb3g53VAJDmLImaiyQcbqlxlz71GzLVdDz+
VpJg4XyQfH98CJY785t3mJEgNhG57rfdEExvmXOCYyQMuDdrCl8dAvmqlMBj
hiQ4+5yP93g8BMzO6e++OiQEBt7SUOwbgojYX/OdiiS8SyiO/mD/B5LNNeom
15LAW7VvX57fMFTPpIg3fGJCnd71syORw7DFgu/ty3dMuF9TGfZf0jCYCxSt
DHnNhM31Zr0+ZcPwwVHZ6vxjJih1ud9RxXv6+X3D4qQAJpybyuwoiBqBSrbc
74aHmSDlNcdBJI8AR/Kb753aTCDnkdzG9yPw+iqLug9iwlXaz8BrTSMgN+Zz
tEOeCVE8hAysH4WU3UJJev8xoXCTVEDR81EoSHBlWxglYP67ssOTnFGwD5LN
vztIwB5vPXP/ilHIL5zer9RLwOs6e2n0ZxR+ag2qvm8i4OGN9NbPO8cA2bru
vFxKQKNMUXmi2hi0vFPTDy0kYFX7zww/gzHQezFlnvORgBCF8UBwHoOUnsgC
tQwCvAYU5D+/G4O/kVo7NjwmIPuu1sbEsjGQqvtPpjieAFLNlMuvYQzc7twS
9owh4HysZ9f+mTFYx+BfWhtGgKnOpzuFygS8KJPhVvIlIGqi2uOxHr6n2xcu
xysEfE9sO3PNkoBP+ZdzctwJ0Jz9q7j/GgH1fgcd/R0JkH8B/QXFBBDhelEz
VgQ4mhz58aiOgLQZmnL5SQJespz55NtHwK0D8VIpFgRstgiIVGMw4dVotkSS
MQGn2O/5bBBmgqZ/2JGCowTEZyXbLkowwc96YnnEgAABnnLVAl2cl9zt4jcP
EqCf27Dt0XEmGJVGZI5pExB09vcqXzsmbPJ4O2WnScByHscf1VBcJ1ssvz4B
fC/7QzH5P5hgHaf7fH4vAVIiJ/wTuplQvE3vN+seAs6VX7p0lWICXW1ug6j8
v+/4IvaYiwS/p2U37skQwDtgILwC6xy3nUYfR3bh36s08VxbR8IFc/tJs50E
2A4OTp/cQcLNrVYB9tsJuKnmPPpdngQNkq1JSJKApHuzPWqqJPD7VCnUShBQ
9Me/6Y0mCWUrGh483UpAB3B933CYBEelOI5AcVw/MXdLwkxIqEJ1Xte2ELB2
VOTD4kkSbqRFjoRsJmCvRtIbB1sSol/IWL7aRIBxnFRyhyMJVgUWX7qwPuTo
fe2Q70HCbUvPdnnMn3bIKD28hrnv96F4UQIc3DNZvQNJyEJBvAKYxT7LfzcP
J2GzWs5/cRsJ+MWZc18xlgSBUR3X3ZgDjZSshR+TYLDhLlf7BgKUEz7tnHpO
Ql2ddet9zGMDqjO/3pAQ9JGnwwbzE5nPxVnv8Rx4bs51ALPxFfXQuwUksPHH
mMph5igtNXUuJ8E27k7eP/7Eq73J8DsJZhGB0pqYHUwrR3Y1kEDzPPLcFrPY
k0M5vB0k1EQprH6A+defb/4j/SQkuy27dmIOlDfUqx4lQT58OUse33efb+3q
F5MkSJUzquIxj3451n37L44vt23av+9NFGh8aUunQG9y5kAcZiMLc3ctXgpi
TqwJl8XxYmDtJi5EQfrCM68WzB/GLLnZ1lNwazXHVBSOt+j1M4lFeK6+U7lu
q4jzU1fddzFRHusQXQ7VzTh/gUK2CtdUKBCSApsNOL+jqXZVKnhOP1DwvaC5
DZ9Pjd5bd4wCr4tKm5xxfRipOJ2as6BAZEHg9ytcPx9qLk/k2FFQ6uivewzX
16W10wUxrhRIOkh9LsT1t9HaK8gN78Hdt0Um9+H6vDl1dYNcCAWjydzap+UI
UITlQYEoCqIVYpW4FAgYDrqexYyngD3OJ7oE1/vR9YE6b17gvX4yVfrsPgLo
tpyrQjMpyHHmgEMq+Pz0kHa7jxS8sJu2RGr4vAMRLpJVFBxPFzlzXB2/72Lc
w+QhCszXZP5UOUTAo3frbANICvaUZcfG6RNwZDFB9swsBTXVo4/ZDAnIiXxa
vpFzHG7Sv3DScb8H5L5kxm8bB80YS9lXpwj4j1FwINJ2HKYadXmueOC5svUK
Q8RpHP7bd0VwHM+fcO09FU89x+FGeWfaFTyfWIPeHHoXNA6fjNvr3t0kYIj7
8dHGl+OwW1HK+cc9fJ6A3+n1zHGo7TzeeDWbAOfdKpuez4zDM8ab1dUfcP8a
zfTuok1AVO0LgS0F+P73nGxh5QTkXOT2minH8RS2crCWn4ChoIq34s3/4qXu
k+Y5AQ6k2DebJQK41RZVd/tPYB2k4GzKxoSykx+XPgZNgH2oRcoRTrxvEncH
fI2fgPZRyamTq5iwcfPmYCJvAuqeVWs34rk2uo3tvgJtEvpV2S6sOMqE2/Ll
WUVBk6Cyd+updS+Y0Kjjc/BD5CR0+qXJmrxlgrjl7u70uElwvhzscxfvu5Kb
j/gS0ybhgdiKUr5CJiw1uF/wrZwEcku6sMAvJnh4SWxU5pyCvXuuNQsuMsG2
4Hbwu9tTkCS5lDe2jYT3tWpiryKm4PtlMt9DigT674mcpPv4+ffHXy/uJCFp
hVX/3dQpiOyvpzHkSOg8rQTOFVNYFxrsmlEhwZT1z+ROjmmoCdh02Azvcy2d
Q1YpgdNgvPaMvjf2d4akTZN7+DR4qQ8Oh7uTcDzez0ArdhqmzT/uSvQkwWEk
W7X/+TScUDI+leVDQkyEqMjm8mmQ7pRKeXoD64WmydpHbDOQ5cO6LTaKBKY/
/0EHnhmgDzY+ORmN/eN2qSJVwRl4EbShShTPKb6rp9+2bZ6B3yqqY/fiSdgj
Vh0iojEDVUt8HMpPSLh1IfFAjP8MfAyolHV9TULEyk+fbIJmIJD7gG0nnlvx
n+p3K0TOwCXdWj/NdBLe8HKL/UqcAf5ZAfmlTBIaMtz+CnyegRvFxs4SuSR0
HY+43P1lBv4rNHho9YGEP6wvh9NrZqDUSN0s+iMJi8ZdzQadM2Diq2M5lEfC
1rmD70MXZ8DK5N0j9SISZJJsdloyZsEzevCoTjH2u3p+yTv4ZsG+peaIdgnW
V4+y71avn4XayGv8smV4Lmr/4HwgPgtOy7JF6/DcPMP843dx5yzINNg9WsLs
ri7qyKk6C1dMHxRnVuC9NbxvoOnALFh9kFrwx/os+J6xZareLCjreWkfrCLh
0UDwIe0Ts7BOo3WurJqE1PBnxavPzsKmITD1+kpCpuJnpQG7WdCJZrwR/0ZC
efCkxE3vWVjyzFa4gOd0I9fBmMWAWahKkO/hqcH+P/gRm+edWWj4en93KuYZ
rnEX8t4s3BlSF1PG/pwzRLv7YsIsfE7qTi3DvJb7oUHfs1mQTnIu1f5JwvYQ
Zr7lm1lwTFd1LMJ8KCQu3rBwFi4+VrF6UIv1JfcYR9WXWXBmC02cx3wpRN1D
48csHCo4dsqojoSr3LH9eU2zMKFjG/8Uc2jIsNGe7lkIY/l9eAhzAjcUvx2a
hSJ1zSsSv3B+Q+7JSFKz8MpRXcQScyH30KOnc7Owj39sRzDmmhBV3v9Y52Cp
9Xn6G8yd3He9o7nnILBCJLkKMzNkYIhPcA42CWozOjDTeJTNbv83BxsPezYM
Yha4E15OE5+D2BMHBYcxb+Lpk/feOQc3r6UW9mGWu6OYNKGA33fkW1M9Zg2e
UAEHtTlglqmfLsB87E73td9ac3BhS4/JI8w2PHvGThvMAQvLr3w3zG53gk+0
mM5B9t6ImAOYb/F0VhmdngP7hvYeLsyxd+SUvp2fg6tr6pIr8Pen8NxO0XKe
gzjD+o6rmHPvtAl99pqDfQ33o7ZjruSRvaF0fQ7CCNHy7zi+zXduUpnBc1Cf
W+h1EfMQT8vpHVFzsJ9zdeZfnJ+5O7tqnj2Yg4PGq1xvY+bmDVDdmDwHUWGT
n7kwrwttfHn/1RzI0XQTb+B8S/HuEFmZPQehuwaFpnB9qIT63Q7Jn4Nnz+a3
nsJsGSpp4/t9DmrI57JrcH3Z8/rWTTfMwdYngnvP4/rzDa1Fzp1zQBt7QrzF
9fk41HvDWeYcvCDWRG/F9dsT+q1Rd+U8zKrtupbxhYRx3k1aJSLzsJAlM1SI
+4M1zP2dyuZ5oKXxHyjH/SQetjFSWn4e0MgA8yPuN9sw54NCJvNgGvJ6j2Yh
CR585blhJ+fh53Y9BUGsW26HiUhw2M6DmJq+Wyvu57SwEtZ5j3kw0Nz++yju
9+EwofyuuHmw+Ux0D7wjIZLl7HLFk3lw1Vo1EplFwl73TI2MtHkorZcM3YPn
SYClQZX/B3zeW5vPl96SILIjqHFT8zzwrSOlwtJI0K1cIM+uWYDJNKuytw9J
IFQOKeiLLkCOB2fjLJ5v0elxngrbFiBo0VNbLY6E7tg9S3TFBTA9cvTqezwf
Pc858aSYLkBy6vU6mzCcf9a+rUMxC6A8MOn8zZcEfY/dF38+WoCpFQNOpXj+
jv/xe/3h+QIcCjtX9v4KCftr18sHv1/A+/JeZiie3w2JpkiqYQEG6qJ8GQ54
X6hVW9gL/QV4KH1a7gSeR56ZEWTUXyiYj3X5q0DCipJ91QEP/+I5dp9PH++P
T7wl9NXP/sIH6ZqZOBkSViXVXdn3/i/YrCDEduD9U/Zt4mxA01+4t30+S16U
BMnNe5WE1i/C7jPTsWOcuN++fepWfL4IeSJsN8NymZCw5sB/1W8WwW9mOHo4
kwm61l9NLHMWQX/1f3sOYv/3ZKat2r9iETbcTubgfYp9wubF7Ko/i2C920z+
bQgTcjwh+IT0Ejyi0LXYU0zw3Vy22y93Cfje3PpwnZsJ/SyZ+n8+L4EeHM2I
wT5Fv+fR+WOVS5Cyt2Egk8aEdU88H21rWQJSmqOebQbrpQ07uH7OL8G+ioN7
BfsJmFwb1S22fxlErUq4eIoIsJy9thCivQwrt+lwfMojoLTpkvCUwTJwRDMO
u+VivxWrpV91ehlk415d5EknQFZoLtfl+jL4x+l3V2I/Z89vFVFStgwh6zpO
pfpjfUTov9z5fRly9WzKRbEeUqnZVx7bsAwm7hE7U7Be4g4TXLD7vQzih+BR
hyvW37fOvuOi05CqSrvRwjkCOKdaivZz0pBaKuIdsiYg3+ZIzWVeGrI6XLzQ
d5qALZpqfzqEaIjVXpGfG/u1cdY1ollbaWjjgPToKqznUlzDdg5upyGHiwNq
vljvWfSyKa+XpiGZt44dM9ifFReTxoF7aeiusm3QRi0C3Haft85TpqGRy8W/
qjUIkHza4UTup6HQ4i+jtxEBkf7VIRY6NCRypZ9ljyr2lySKi9CjoRLtzH1b
sS+dPZ37vMyQhuquhudIKBFwGp4VSZvTEBE/SJ7E+lZ6yXea9SINKdNI6ydY
H78+7+LItKehAwrl+xWxft5Ra/O7zZmGOlMFmjqk8PnP9BqzvWho9sOtEAus
v1P4wODpVRoyTDjyVRbrc3FPuS9h/jQk/rNOcA32a5sOieTYBtHQuJE+qxDW
90/e8UofC6Uhl0Cdaims/zduoKVAJA2ZOtI6j2J/lhA4sWFnNA293GV0OBj7
hXXk75i1cTTEX/pkWy32E3HHW/kYCTT083Szz3bMa0q/36ISaSin2N48CvuR
2J3Fix3JNFQQYf6VB7NQbLZ7dSoN3f64vjcG+5mo5dSxnFc0VNvy+YUs5pUX
H55LTqeh5Iffpf/5s8i68I6IdzTkvdnUNw7zCtUAk6u5NGTrPvbkHObQ5+7f
L+TR0O/Rl8/++TNu/otaJp9paC5Z8t4/PxbkZVmgXkpDbSMBHv/3a72Ge6Qr
aGihxMz83/OBegferPtKQ78Mvqj/ex/9/d6tHD/w95o7qvw7L2Cj1KOJOpzf
706H/92HFrRhdXcjDUmq2/n985PXKIGwb6009Ony1eb7mBct6IyPnTS0qe3A
aX78vVfLZq4+76WhDul2kX/+bH7XyOTd3zR0YqaTTw7Hy+t+p/21YRoSFDuL
OjDP0Or67QgaWhv29308jreHXbml2TgN3XiX53oe52Py14f6A9M0tHrPLm9t
nC9Xtdf6svM0JOp3/MdenE8yJbFs/RIN2diXuSlhvzZ2JTB7isGCFJ5+y3XC
9WDfd2VnLxcLGktsMnuO62VY3+FZDR8LCuL+qz+K/dpvUePo1NUsKEr/5Z63
uN5sgnV4o0VYUOc2523bpQnoG1e+6b+BBdUOf7F7j/1ad/kmt+NbWdDR4J/t
LPIEnJJZPaq1nQXVTd9klOB67ojjtJHbxYJEl75dvreXgNZLzGM8e1iQjIIG
vx3uh/qVBfIFmizoATd36gDuJyOfjFcvdFnQ7lzLczK432r7k7fE6rMgdDFb
MUSHgJrcEEEnYxbUde/alCvu14qT5hNiNizooEBeCb8ZAZVZQ7bWF1hQ66rO
jo2436s5rrQm27OguaTtr9VP4t9nxhdLuLOgH87aoiVn8fmMtoidgSxIbqvG
mdcuBDRaXGJzDGFBxr/urDdzJ6A5fcEjPZwF/T5bTAnhedR2fP0pufssaH2W
YkQVnl+9b07uVEpjQcrBXZTgXQL6WYnEK69Z0P1p3Q7jGAIGzK4J5mWwoFPv
/oqkxWN/x5I4r/aRBT09tiB0K4kApkl35YFqFpS7M6hy9XsC/i5anzMcxe9P
eO7n3kHAktFEcyTJgh4j0YffeglYTr2hXzfJgqT0WUbkh7B/NHomb7LIgsa5
B2/LTRDAlTLAcmIFKzpjUCw9wsUEYYMLj21lWdHHiJacLcpM2P3YocnXjRVt
uZ285cQz7LdGvd97eLGi4DshSb9fMqFaJeie01VWJLtdqMYb7yPrliTDMzdZ
0X7ORNt87M+ihZorNKNZkfeTRInEFiZMh2h84MlmRf0rTw9a4P32yXNNfPwE
K/JsaDxhok5C4Bdxz6gZVgTdBsHjmiQYrZYzubPAitiqrRIidUkYydJf6cvG
hoRvFc/VYP+1nrgebCXIhkoe3dx79BTW/zajV7bJsyF1rwCnI3i/ax4ttnjv
yobkU23OHc/G+uHOJQU2TzbUGu7iJYb9S1/56hVHfdiQxoeRtj6sbwKU7YpH
b7Ch1M74oVOlJBRvEZQUj2FDfx6Un92E9eL+aZupqFw25Ju0h5FFkBAuy/+j
O48NqWSg3u3jJHTYfUyTLmJDY9F5Fg+nsD7v4rOsrmRDWt9DnOz+kpBXmVPC
0sqGXAZEzmZzUaD0kDPS+S8bavy90rB2MwVBDVkXC2l0pMWYcKvZSkET/8kD
vAw6SmCZ9i2RpMDjZuZ0Kh8dHf/6ODRcmoL3DhYnuzbSkcU4bTBzHwX0NLri
ri10VJot6HxGlQLj3rcCPtvoKGD+7U12oGDSlK1MWJaOfsWbpMhqUiCHXksZ
qNPRN/UtUjQDCgK8TekJWnQ0pxHrYHaEgtpsWuefg3TUOL1+JMmIAuftJndv
GdFReejS2GozCt6uWprJP0tHrCu2h58/TcGSflot9wU6umN1ab3lGQoO3zZ6
ZW5PR2qCxQ8PnKVgdCHl1KQbHf2c2/Zt2JaCHQOG5TsC6cjw7ZF7MQ4UNF/c
GXEuhI72tB3UEXaiIJDgPJ4YTkeHA9vlgp0p6J4pHl11n47sT6Rt0LpMQdjV
xzn6D+nI0rv6V5gbBcosPv6BiXRkunxcptKdgmhuBaH5VDp6u1ilvdKLAvUI
gU7513Q0mKWQJ3qFAkJwLNUhg46eqWzRFvWm4GFclUtqNh0FztiU8ftQoLsh
RaXnAx0ZHGMVpDBPPQ1g/FdAR0Wf1fhLr1KQJHH6h3ExHR1JjY695UuB4SuV
+PByOoqzLgpUukbBX5m1Zyur6OjujtyCNswvsid3stbQkR//GxEnPwpM99VO
q9Th57uEroxjZit8U+TeSEf6Yk8/nfOnIEMjJCS9lY4OzGgWVGI+WWFr/KeT
jobW7LH67zoF3PoHNm7po6PHb4cCTmL+8FN0yHKQjq4cWseIwHzO5G9m7Agd
hZZXfknHvKq12ecnk45KdiilfcZcdOq9FvckHYk9GQ8uxOzQd5dfc5aOnqAq
/deY111wbPH9S0dWnA21QZgrRg8l59IY6GSG5/wxzG4u2xwoOgNdDrdM48O8
aZpNcQcXA3W7Xil4j+9b491NO8fHQGw3+dfrY/ZZzq9+vJKBbq59nfITf6/k
zfjo5tUMVBWxHR3A3MDpcWrVOgZ6LpnxNRnHKyDMSFJ/IwNZNubsHMfxlVkl
M35rMwM1CdJ1pDG3x/Lkf5ZgIOH3b5fMcD4Un5QZysswkBHviubLOJ/94k9F
HOQZSPdScOk5nO+oF759KYoMtLya6tLE9TCatddzHWKgyvLXGtW4XuIVBdWN
NRlIeYWdiTOuJ+18Jne4LgMNpA/uZsP19qQ87THLUQZiuGX1E7g+Dx+6dUHF
hIESO7eE6DhSMF9zRs79OAM5vEi8H2qP+6953ZehMwz09WBbaNsFClhOzkRs
tmWg6Ma72gO4/t/2/DpuacdAK+LUedtsKOAaCR374cpAxf7uZ0OsKMhxupjL
5clAu6Rbqg6cosBmUuv6AR8GcnGZHhg6QUHh4pJQ7g0GSnq2Z2zKlAJXARfV
x9H4+aQhPhF9CobDq50j4hioJv9SgdVBCqz5xJ/7JzCQtef8/lhtCo5yN/Gd
fcZAekwbv2pEgSxdrWtbNo7PRkcvUwUK0gJiBUU+MNCMi8o+nt0UiLGQOtz5
DFTarG39ZhcF/EtJGaOlDLThGL3wowTupxnOgMxfDNSxS8CGWkOBrYd1TlIT
vm/ww50CQhR0TuYN32tjIN6A8xzrBSj4Tjke8+hjINHD1TXzHBS8HqkXV5lg
IImtnNm/pkmw63pSUbaKHdFjb9iMYn/de3J+4b0wO7rNbpvWjP2wRfsx2dR1
7OjOeHBkJva/B1vY44M3s6PxhQy17fnYT/2ytzOQY0cusiLpMikk/P6ixNd8
lB1ZGypL3vcg4ZRWlHqVCTsyu9QVqO9MQmPpiPun4+xIYvKeC3GRhPKix50J
Z/Dv20WoGUsSnn2iZ5xxYUc5FU4NmzRIOPv2p9FIJDtaw1BRrcf77NTaioDd
Mezo2HuPnZk0fL+AgizPeHYkOdsqxCSZcMT05Sp6EjuK9910/voPJqgu3ahb
/44doTSu5DvYnwkZKBoZNLCjX5kTdL1ZAsrGHh3NFOFA57zZT+i9G4PPZtHX
ZzZwIHVtmnPMozH4VBySqbaZAy3mW9nn3B6DjBjPldVSHCjko1+r74kxSFA7
WturwoFk5xdntrGMgXsY/ajQKQ50ZjnGbY3WKEjsunTEM4kDbd5X0cmSOQyj
kZ3DbikcSDnikKdZ3DBkTR695fqSAwXO72iM8BsGtXylTw5ZHKj9WHPTi8PD
YKzHLm5Tgt//KzoxeOgPXL/4dOZILweq7Et8LSPyB9qfNz2W2syJ7Jb5p0bO
D8K9jZpjHU85kWgG/0eDr31glZoeixK40Pr6S+mFRc3Arj6+3u8JF3rvX9yn
e70Z3rQqJBc840JXlPWiRtSbYZ7vU7ryGy5kV341wre0CaLdyioVCrkQT3qI
5nBFI1Sqt8xLdnOhNq0809jGepBtZz29UpwbXaD77o0UqIVGd60BQ0luNKvS
/Sqt4Sf48gddCt/JjeoemxZTD35CtQafF88ebpTdoxG9VuIn2LxYc5ehzY08
cj9ujfOtgTiPnaVz57nR5w7t4aLJaqCtNN3W+4obRV+f2mCpVgYuz1avbU7n
RspHDQRFOkqhV7GBs+YdN1Lfet/osG8plJ0yHv6Yx40OESISop9LIPi10Zu7
X7lRu45jr59uMazSNZRXH+FGfa4M0eaBfBD304UnUjxoRZdfl5ZZFsSs4pSN
leZBd4q+vL6XmwnsKRVioXI86FX7fd2ltZkw9E2b1UuZBwVtrs6zLEyHN+u0
yg0P8SDxV4/7ZcZfwsa39BwtAx6k/HtPXH3ZC4hUL0tRMeJB+rwHH5TGp4Hr
hQNB2yx40KS17uqgQynQt8B6ZcMpHmQunaR0RuI5GEeUXBS05kH0Sq3lO/Rn
IC+5Kq3xHA/65msiYDmRBAnFwfXRF3nQ1Ve1H7MGngJTvphR5MiDFLoMJgvc
nsDajqKdIy48yMv8TPaq7YkQ4uy/ocedBzWT9RnVfxMgQvxJV4oXD5LcfahP
zvshLN11ylz25UFD46K/t9+Pg06pz8yS6zyI9DnjoR0dC4aF17o/3OJBH36O
eQ97R4O0Wc3Gq8E8CHWbF9b7R4HMZ75kjggeFHlIxiJPLQKSvAqyHtzlQd1G
3J7NsaFwM1E1OjCeBz3xV5U8cfsm/A89uc+5
      "]], LineBox[CompressedData["
1:eJwVVHs81PkaFiu2+X3nTCgmViyhkKJz6mzS242iE0kIxWd20qZjynUtRxda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      "]], LineBox[CompressedData["
1:eJwVlHs01Vkbx9GdsH8NdaaEjFCMS7wuE55nTAlFb6EJ1RjdVEbqyCpxotGb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      "]], 
     LineBox[CompressedData["
1:eJwVVXs4ldkXVsk9OfujVKpT5FLuFZpxWblHI+QSTqIwqeiCUi4hIyJMbiUJ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      "]], 
     LineBox[{{4.995870604285046, 0.0093176821194519}, {4.997517384261396, 
      0.009858817508956404}, {4.999454772468869, 0.01049481368454629}, {
      5.003329548883816, 0.01176442596277931}, {5.005266937091289, 
      0.012397873318005275`}, {5.007204325298761, 0.01303030234117984}}], 
     LineBox[CompressedData["
1:eJwVUns0lXkUldV43KLw+4jyzB0yFqPHaEnOUYgpikrGK+tSLbpeU/RgbsVM
7xfpWprIK+7r++hW0iBkDJWkO97dSiGmiFFCqPnmj7POOmufc9Zee29zXqzf
LlUVFZUQtv7vvCteFQIdgpW+ZXRI7kVwncx+ukGP4ElX2Qn5ijQIU3j7Oi4m
KNJ+9/Tbe5eg20lry7gTweTqmuqck9nAc5iy/9eZoFmhx5Fhkxx4a9W/YNiF
4Lajjr8F38qBKVL1pG8dwV7/w5rHlddg0Qh/c+uPBCk3su3uwjzYXtDkczOQ
YLO7oDzNuQCUWeV2JcEEBVVlqseOFEDExUJtaSjBi5X1hh21BbD/l+TmfB5B
zvgfT2m3QkjfYeuTHkVQuK4Catddh5Z5Z73jDxPc8IDH8E2KwfCghzQzmaC9
aVHC9qBi4PWpaN4TEPyo9NIJzSyG8cqEPzmpBFeumpXUzReBUczONYVnCGbO
N3LJGBJBRLdh1sNzBHv8knzsLcRAe7R+Gr1AMPC9WUWrvxjQ1Eu+NoOg+/pH
ySurxLCrZfmyjqsE3y9KWaYqkADjPHx8Nofla2UWI5FKYFJU3Lc0j6Cs/PJJ
r04JnD62JDfuOkGbx2eMwu2k0DrcPissJqjYdIrq2iEF48C0oCoxwarUE8PO
R6VQulzNgMMQrLtjkF3/WApTOTX7vy8lOKArhDdjUlg3L0nhLyf40Gbx9iF9
GbT1jpwrKCNYPZ3Rmhskg88ZXXPXVrN4nqN+QocM3OZk8MJrCaorY+ac+SCD
c9E+NafqCK4ZL/U5oE2DmUddUnsDQc3sRGxCGiLlv3TNPCD4KUAqdAigQW6y
2nFpE0Enp/3y3TE0uE/IxmJbWP4cf22nTBrOh+/ZIlQQbLRe5NcmpqHziTlT
2UowNrKf51RBg7mzcl5vO8FJaZ1yzyMaokTCSM0ugpLnfruDu2m4RXwb7J8R
VFn/olR/kIbZo/O4/s9ZvfdHH7z8kQaP4fqU5JcEF2q3pXZ8peHiT0d78l8R
hIUNhc80Geiqd3J50Evw1ofXd3J1GbBYPv77SD/BndH1hVwjBvg5JVPUIMHl
vQahkWYM3OZE7XB+SzAi7dqrKC4DXxItb/OGCN7cuWn1smUMePa+0D31ns1L
+IbEgu8YSNucFVcyStBcb05Fpy0D3RVbm9vGCFZYgUMjO1taa9vOfCT4s7XN
gnh2Pzqj8ZTFBJvv4kChwpqBMpXUAc8p1n+bN3pDlgyoRK91j51m/a7Y21Np
yoBX10T+5VmCRvZmYW6GDKS7y1UqvxJkNLtVU3QYUN7gh76eQ+ESQ2O3BA0G
uCZWlRpzKVx6mys1/kJDTslnHa4ahVdGrbRujdGg79q8x1WDwhaJah3nDeuP
Iq8qhEPh/H35SeadNKhFJOgdnk9h9+Ds6EQjDYJxz0ihNoUpB00Gz5XT8On4
kmr5Qvb+gbVDbxENb8R1Ue8I+7/X3eHRERpC12TWqBtQKCqNrwmJoqG9KUrf
0pBCxecG35KtNPw1onM/2JhCuWlV0QULGlyO9RscMqUwQOvQVRMNGsp070Zf
NqcwuPn6JH9IBkWrwgybuRSOfnSs97whA5OGFbFvrSjcknTsfnuaDIQB6vVq
NhQK72khN14Gx5OYOLCjkKOJW7+xlcGe2pmG0h8ovCopErxMl0KPX4vx49UU
KhvKFYJIKQT0Fez7x4lCZ3Hb19cuUvBU32hqARSqnZh+N9MvAWvvrMRLG1g8
VllzniuB3Bf8phIvCnMjz7ryx8SwKA4tmjay+teebqXuiUHj0sDjuVtY3JAS
P/UVw2DnKm5iAIWqZifbtfaKICxKMyk9kMJN3rrh0XYi6JxWtjDBFAqeuS0p
GC2GRpNfkwfCKPxSpZwWxheDOELxd0Akq7fliGvTriJYwAviBu6lsPBK6oGz
S4vAjB9qnhBNIZ/cHRlQXof/ANVCnf8=
      "]], 
     LineBox[{{5.3859534978626655`, 0.03421265801459206}, {5.387780131629036, 
      0.03362708437542972}, {5.389702904014688, 0.03300435329782682}, {
      5.393548448785992, 0.03173963067172224}, {5.395471221171644, 
      0.03109776316167187}, {5.3974901321765785`, 0.03041707340991348}, {
      5.399316765942949, 0.029795332870944685`}, {5.401047261090036, 
      0.029201216728242302`}}], LineBox[CompressedData["
1:eJwVVHk41esWdpAh1VZd34dECol9DOU4XUqLnKgMO5lCKDJedDUoXO0UlShK
ppMikRQZ9t6/7VArY5p0kAZDkbiJZpkq3d/9Yz3rWc9a633Wetf7fZo7I5x2
SUpISMSx9n+v3DaU4hJKgJswWuV1shRdn1+5mBNB4PpiG4vOwDJsUWpdM8LG
/SnGqpNRZZjeH1Txcg8B01WqTZqWN7B9eEWD1gECXotDnp9UKEeH6WtDZXwC
4crGQr2ecrRZVP5rQxqB1stn68W7KtFO7VFo3VkC5z8XNQemVSJv8fureI7A
mGK+TmZtJbprcHVqswlID/cGh8+vwpBlxerCfAL/+iY0axBUYbjWHa+qAgLz
+sD1nz1VGKk9lFNRSGBaiWlUlxJgzHItWnaVwALZvhWGjgJM1s/jXKkgYOLd
Z6PfJ8BULtoXVhG4Nw+1+yWFKOc8Ne+mkED7541JhTpCzDH4cTefIfDEY2Vy
wAYhXjBUk8urJlArnfXFOFCIN1ZlSWTXETjke2kODghRYMJYZDYQyBH0Shj9
IkLxb09izzUR0J1I/vXDYhHe/v0fU2l3CWiM+mrzXETYbp76KamNQEtPvsC/
RoRP1twwPNFB4OjTmaOcDhF2r20NO9ZJwL8ooGxyWISv1815e+Q5gdiHrRvi
lBh8A/q68d0EZqylnhM9BkctNwXwewlIYf3sobUMfrQKvhz3kr0ft/PLMI/B
oJCCXRn9BDKcJAOk/Rmctr6yJGaAAFk56HZ8L4MzfzR7HxwksCI3iKORwKCk
zeD5qP8SGNLYOfEqnUEZW+nufcMEXJWemLQXMDh74zKVvSMEHDLTPrytYJCz
ycot8h2BngWmTvrIoLIdvyP8E4EoN72WRU8ZVLO/OD/sC6sfyU3rWvoZ1HS4
5Rj6lYDzSnmdcyMM6jj2pgRPEMgs7RLyxxjU432/HzjFzv9io/6J7wwabFk0
O+AbASMpmebrUmJc6WRm6/+DwKPN71qG5cVounVb4s6fBLI/0GgLjhjNnQ80
+v5CQYk7sPTqQjGCS6akjxSFotXfObpUjNauItg+i0LQ8tC0ahUx2rp1xnnK
Ujgnyp32XCRGO/ex2m3yFF4rRl6aqyZG3raF39wUKGj8x3LgAZtv4dvXRsyl
MGuRpnm8qhg9PLdEOXMopD3uLQlTFqO3126h03wKPzlak5uVxJgWXzyyYSGF
lLaZaNv5Ymws7tM0V6Iw6Vzp5jxHjBOtyu6GlEL3H15K4TJi1PvKO7VMhUKM
Q7pF+k8G96p01M2oUigvcdEznGQw1bJuWmExhY2mRRyJDww2Bk4ZSWhQuH/c
74XVIIMTKcaBY0soyDw7FpDcxfIpCM59s5RC22C6dXcrg95d+R09WhT6Q2qV
DeoZTJPokm/TofB355vEIwIWT2cBNOlS2D7dZNpVyOLZbdpfrUfh9LW7HUYZ
LN6e+OulXAo3rdfMTWT1koqflTOMKPiMvdBevoPBhkE9x6SVFOy4clG77Rkc
V/BLiDOh0KhSYFu1mkEv945PAasp/NZaE7tkDoNFsS7aVmYUFB71fTv0VYT1
l9d7O66h8PR1rvyubhGO34tJX29BoV14SGVfnQgXfAl+yAMKJyXVB0ihCL3o
qATXisJa9WSJ0CQRpq7V+n2JNYWM9w/OOISx/SfSC+RsKWy20QnqN2Txl+6L
fe5IQSop5G9aLMQ5NhM3BFsojJinRW9MEKJuxOCbuq0U8kX1T0u2C/FUjYtL
iRtbP2119Nk8Idb1p5y8sI3l13PdRPOgAMdkm+vOeFJIfhVvmV0jQF2DmYnE
7RSqYh7HOKQKWL2NGqX7UCjU920t3CHAU9Hh/hE7KJS9LDbzNhVgfV5Rjp8f
u38KI8vIsv3viKxdIAXRXBcXmStVOJYw8VItgoKuhXz+rGeVuPy6IZn/bwq7
67pOhORXokd7oN2sPRS+CSqLrgZX4m31Z+J3+yl4gGdz1XgFzl7vMdpygEJ2
iXtY9K0K1Am11X4STWG1YnCj+qEK9Ejje96LpSAdnC6faVmB+6vD05/GUajo
Dg2u+VmOt3s/3qnkU4h2rzGa3VCOY1IrZori2X3uTY5JxZejBy875HQiha4p
/p63kzdQZ/jget9TFLL8blrGN5fim4yhx36pFHK0jf1iDEtRUfPYtdwzFIYS
s3QLEq6j9M0Un9p0CkmjrSUy/deQa2NgOp5B4a2nWr+B8TV8P5ZzZyqLQojM
Op+I0yX4KjU/RvlPCmc498cjX13FBy1lAy4X2fk79eWV+MUYWTxwZHM5BdvV
01M+iZfQxJWn5FjJ3udkmW9TYz569X0cOS6gMK5sv7VzJA95sRMXr4goqBn5
R7up5uGLV/draDWFURXpDYObL6CZQFpu8C8KxYqlpZ2959GAp1ArdZNCXvn4
0ckVf+LHH1H2ssjyebDmr/LEbOxp9+Y+uk3B3XxiaQ0nC8vnKQTxG9j/Zvzu
Gru2c9h6IIWMNFFokTZ79LnpLI57ciH3DgUJ7hdvZ6czOMoztjG5S0Fui+us
0s+puGF32DvFB+z714lcdXggGR8bgtfUQwr8wpLmrMMn8FagfaNpO4WPB9xU
h3sOowNfPTGzg8ISsx3fq8vi8H+j7spW
      "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAvma+CgnmF0DAx+OKWC2EP05/j8xp
5xdAcDHplk72hj/cPmI7UukXQAAzC5on2Yo/Nl6e4S7sF0B4gSFUDF+QPyxT
o+jF7RdAWJRH74IGkj9UNkISeO8XQPgtBxSYzZM/rlV+uFTyF0DIuj29ddWW
PwontwQi9BdAWDd6DA7DmD9X5iBFDRYYQNInSHO6768/Mv9lrgcYGEBhWTDb
NpSwPwwYqxcCGhhAN9IHtK4xsT/ASTXq9h0YQCznmaT0b7I/KK1Jj+AlGECQ
2YSIufm0P/hzctmzNRhArLXmcRZBuj+aAcRtWlUYQEJWaQrFysI/3RxnlqeU
GEAiRDIRinzPP1YlPOXclhhAmhwfhzH1zz/QLRE0EpkYQIGpifIjN9A/wj67
0XydGEDceYeV3bDQP6hgDw1SphhAg3WqBsim0T9ypLeD/LcYQDIt40fGm9M/
BywIcVHbGEByGd24k6TXP4A03b+G3RhA0m761kDm1z/6PLIOvN8YQKn1h5MK
KNg/7E1crCbkGEAy7ylR8KvYP9JvsOf77BhAi/74muu02T+cs1hepv4YQBph
uWnVyts/FbwtrdsAGUBrsAOK3w3cP47EAvwQAxlAitKRrPdQ3D+B1ayZewcZ
QMXb6UFO19w/ZvcA1VAQGUCCoD+feuTdP+D/1SOGEhlAu8zixdon3j9ZCKty
uxQZQCsJvnpBa94/TBlVECYZGUBInyzRHvLeP8UhKl9bGxlAxzN3k5M13z8+
Kv+tkB0ZQIrUcyULed8/uDLU/MUfGUD+UkeXhLzfPzE7qUv7IRlAI/YK+f7/
3z+44Rdp
      "]], 
     LineBox[{{3.8943555524891873`, -0.025021977804388223`}, {
      3.8963328957949, -0.024118834853165738`}, {
      3.912984207843011, -0.01652172035753234}, {
      3.915065621849025, -0.015575243315821996`}, {
      3.917147035855039, -0.014629935897086194`}, {
      3.9213098638670667`, -0.012743381431627565`}, {
      3.9233912778730806`, -0.011802408224283564`}, {
      3.9254726918790945`, -0.01086315229310758}, {
      3.9275541058851084`, -0.009925748588282601}, {
      3.9286988835884165`, -0.009411014696005846}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAfFf/ILCsFUA4IY5jtnCXP7t+UPiO
rhVAyM6trea9lj/cvuCbVLAVQPw5ooFVE5Y/lII1QpiyFUAM8KYwwjeVP9Sp
hhl3tBVA1FlxFQOBlD+5G5VVCrYVQPQDqVUu5pM/rK1rY4C4FUDM0laRkPKS
P+zUvDpfuhVAsIaOtw44kj8s/A0SPrwVQCR804plfJE/H47kH7S+FUBs+r9m
v4OQPwQA81tHwBVAgAoRRDPHjz+8w0cCi8IVQJjo2V0P+I0/vxwXcjfEFUDw
qdD9tp+MPxwrKX0vxhVAeF+v5XAIiz9cUnpUDsgVQDh/aaRng4k/T+RQYoTK
FUDoguzjbICHPzRWX54XzBVASB30fgg1hj/sGbREW84VQKgZyFM+VoQ/73KD
tAfQFUCo1PUHkPKCP0yBlb//0RVAYE3q9jROgT+MqOaW3tMVQEAFrL//eX8/
fzq9pFTWFUDwr8SMx1R7P2Ssy+Dn1xVAwJQ3d3OqeD+k0xy4xtkVQJCVVUgT
fXU/FHK0lg==
      "]], 
     LineBox[{{4.44912460053905, 0.00265423561252965}, {4.45125543296081, 
      0.001951975392647222}, {4.452605281553779, 0.001507323033337546}}], 
     LineBox[{{4.464561083377228, -0.002418947346822811}, {
      4.466103767483478, -0.002923394171709587}, {
      4.468032122616292, -0.0035530603134370647`}}], 
     LineBox[{{5.5339331639272515`, -0.02662488112858892}, {
      5.535705298610735, -0.027433499612647308`}}], 
     LineBox[{{5.5013198410017985`, -0.011772217833612514`}, {
      5.503146474768169, -0.012597874598044873`}}], 
     LineBox[{{5.596479093932569, -0.054272228094321986`}, {
      5.598459715049404, -0.05509501015101873}, {
      5.6004299118445715`, -0.05590876135385227}}], 
     LineBox[{{5.588139636598527, -0.050758985670562806`}, {
      5.590224500932037, -0.051644393175133106`}, {
      5.592205122048872, -0.052481247791872666`}}], 
     LineBox[{{5.5547818072623585`, -0.03609106961296355}, {
      5.556866671595869, -0.03702925148664262}}], 
     LineBox[{{5.4897832066878856`, -0.006591889450265287}, {
      5.491609840454256, -0.007407652083749411}}], 
     LineBox[{{5.571460721930443, -0.04352803720544479}, {
      5.573441343047278, -0.044399043641456575`}, {
      5.575411539842445, -0.04526245310031816}}], 
     LineBox[{{5.544357485594805, -0.031373388216307724`}, {
      5.546442349928316, -0.03231998998090688}}], 
     LineBox[{{5.495551523844842, -0.00917401583250825}, {
      5.497378157611212, -0.009995175179209684}}], 
     LineBox[{{5.484399444008059, -0.00419888582665201}, {
      5.4858415232972995`, -0.004838128325824434}}], 
     LineBox[{{5.507088158158755, -0.01438363909318309}, {
      5.508914791925125, -0.015212878847518319`}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.09417805877643876, 1.0941776354745425`}}, {{
     0, 6.283185307179586}, {-0.09417805877643876, 1.0941776354745425`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, {
   3.654949012338499*^9, 3.6549490167500353`*^9}, 3.6549497461684017`*^9, 
   3.655553951560014*^9, 3.684450221586493*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[50] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}, {3.6549490143697987`*^9, 3.654949016022552*^9}, 
   3.684450215334691*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0H0s1AEYB/Cfk7eQO3Fl3u6UU6ezSGolnLykIm5XXpIuqabiOKZ5W4mp
lrxlXlahvEVEtZuWQy93qvV2taTi8k5ebjPJ6cj1snmeZ/vuu89/3z30cD7n
GIkgCN7f/Gv19uVvBzenuRD/b8rVtyRJXJzf6LrkLMu2G4X57eBxhaaKHScF
b/2d5/8g5jP45begdNKaPrCbO3e+OnwIHBLjMyUM/g5uozPPP66aBHOLmRWy
6CmwqUbrztzj0+ALmyT3H1+cAXt67+ZVZ86CJZdmGBlJc7j3ipGot1gJPnLm
Xs5U/gI41Upsf7Z5EWy3mDpLiiTclvz8UNAPWoQa2L40qis1ngT2CHgSIhSo
g22H90lsM5eBBeRY59ICDfDRu1LORK4mmME65X/mlha4p6qrlGmlDb5q4SGX
3UR3EGVFCX1o5cAvtoGlDtg8r+z1nNWSCcLN1TNwgIGOkI/3v2KiL1zLPS20
Q9f5OClKHdBvFd1pF53QRlybooMu6C2kN3RPd3RIk6Dezgtdrtf2RM0PzZJw
J2sOof3jlAl5R9Dx9HK15GPoR6kTVL8otJfTefZMCppX01jodh2tyZ42O1uO
bvjqWNFaiVbqP2rc1oAuiBe/cGxDv2B/Ua7rQ2/sIR2mrF0OJigHbAbuoH3k
2wLDanXBEXUh0SYiPXD/ol6+9KU+7uv4zQ2XrACrotarHD4Z4D/EPmv5J8ng
APNd79xH0aKRQbkwmgJOHrMIpcrRFaGKHdQEQzBNh89Xn0X7qW2siY5bCR6O
zOYkzqOlulm+sUlGYGsLG5H2MmMwM0XX3uIyOmNlzk+aDhXsbdrEepaHDguN
EXIoq8CMscSdvGx04AjNU5+6GiwzO1FYU4A+YO083FOIlrIojoYl6KcuLe9T
bqBv8wz0OdVoQWVz+kIzWmuDdmxAN/qco6w9U4ZWOt9fIepFT/qG1jOG0B/4
TaPzk+jrD4LCqhfRxiJWQzdhAs4WkxbI6ui0zvqSZC30cQXR6U9G96k612Qa
ooO17whajNB7TfaTGSZoCZ15+KAp2oWpasg1Rz90+LggsUTbb6/dM09H/wFa
hmTn
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwUnHc8lX8Ux+8gEpUdSVYlSTKiyHlSGpIiKyG/BplJVkpFklBJZomSrLIy
EimEUPbI3nvda29+p796ndf3ud/1fN7nfM7tlvDlG9rXKCQS6QgjifTvT+oP
looeeXcVhvjYEwykThDiEdop+PISUDwYCJGlTphp89dsCrgBD7ds9bo90wWd
R0q7MwPuw/T1zR0/ensgvv4YKSnnIVCO3HDd09gLl1l2PCclPYbnCxZhv3/1
Qf2tvk8fAp5DL7FRoyF0AE7UdW+7W/ACPO5GHBx0GYToce1rH3JegpGsuNJ9
7SEwFpWdnksMgU/7TZmHaMOQffi9knBsGHygPPT5+HkEeAw4H6q/fQ0/DwXT
a61Hocpviv1NQCQE5QwOpxWNQXBtqmRP0VvonfMM/nplHAo7LaqcC97BiUY6
f8HcOEyOCTuw/oiC2+3X7YPcaSC81MT7Luc9KP/kCfIk0eEcc0COfFY01H77
pExSosM9bvVLZekfwEutTOiAHR0+iVCol1JjIIvUc3fHWzo078uOmUqMBfHF
x0fqyujAfNhe3TshDvyZVKc16XRQUJcYF4iNh7UqzkdxmyfATL/7Rer7BLgX
TuJf3DMBgVdfyR9/+xEeXFpXfVl1Agpuajc1h38CTwGW20w6E0C/x+J2IywR
znOqqXL8NwGCfgVCDMFJ8Dip0uyzxQScCXMtDA1IBnvV6d9bbSdA5TxfevCJ
FDjjtxbuhXH9hRnGrqIUYNc92yllNQHWptX6e46lgnXodSadqxNANU+MdyxI
hSvr+l0VDSfglc2TpR/EZ5gI5RYVPjMBMg7XzrD8+AytykLjOocnoNT1SKTO
4TTYvT9MRwD3b+q+bSIiJw2ufj/flsczAXOPF1SHDqaD9RHjd36kCXj2rD5Q
Nisdbh6eqyodpMO3108VS9IzoGafW+33DDrwZa7cn0j8AkfZvdf0T9Eh5VtT
tZJkFvxurmm/JUWHkz8zRL0SsqD9QQ27EBcdnKpsfvHHfoWHOopFTIU0YPt7
iu/ajmwILHAtOhxEg+i2HVbJ77NBkSmKWdiCBkq95NwF4Rx4UnzuzBrQoGa4
beOxtzng5zvFvo2fBhYTX02fCX4Dc30nowzUB2k+6HNj+De4nXkzcKFxHEJX
bzKIbs2F35f+3GD/Pg77GDX1bMJyIeTMxwn+2HEo3iAR94X3O/RUmt+RCBwH
E451i+Tg7zD+XJim/mgcZrZ0n9bg+gHs/Jd73FzHwW/79zfBAT+g5KH4QM6t
cTj++/X+PLY8cMsL/9lvh/N5GXDJa+fB8SNNNpH2OK7KPRcfnAfup3xdc1zG
4ddKdZNgSx7oZNuYr3s4Die/Pvv2cns+3Puv21L1xTiUOJyOZL6aD15V38/v
fo/j0swebnH5MHSC5GyTheMjhVcnR/PhBS81PrsKx2PdT5jvLwAvrxL4MoLj
l1UkWh0LoHeqbCvjehqUNn2hFa0WQOguN3HWUzQo+5XgGra5EAi145MFtTRQ
f2huvFG3EJYGtDKuzOK4ihjxMKwQWB63+Aqx0kF9sVNkvq0Q1u+NtnQXoMPv
jDeMNiJFUBr0eFxCkg4aNw0Hu8yKQPPY84ezh+jwR5L3t97HImhXLWjJO4nj
g7WJv2lFsDASfMBSF8ff+/sTcsWwINT9psEUxy+duZXhUgwaIT2845Y4zs+i
J5FbDLu/S1SE38LxhmLFSPIvKGjes7vWFcdfPNzKdfwXMHDf7nz0AMfPEKve
Pr/gLEPyWqInjjOvdK5U/AKLV9B58jGOF379ac9ZAqQq0y0G3nQov+8UM6Bf
AvVTbpe6cFxTSfaJUXgJNGZHXR9/RIeKWZpVdWcJ7J6wSfPzwPHPnzSP7ygF
8wIpnXI3HLex2J9jUQohZd1phc44vnsnl3RSKTzXaz3pg/mlord7NnqyFK6d
HDipeB3H30Y28SmUgUxzpe6ICY5fNPr27E4ZlHUo7ijQwXFevkhqXhmECXwR
a0N+Kmrq3V0YfsOLLMmtJip0qDx19sTlp7/hSGjHw2076VCloFojH/kHSnZv
5uoYpMG5qdX0hJ4/YLh56JlANQ2qknJCtouXgz/rvrJT2Thu6eIaaF0OdUZH
XryLpkH1Dnnj9anlEC4o4mToTwPtrgm4N1MOCQmgHeOGfIUniUwdrAD5nfX1
qdY4bmDFeP1eBfh7/94ZbYzjnOKDrQUVcJW76XnEORyv7C3TYqoEhx92xDc1
HPd5l1h8uhJaHvRt4ziM48dN/JX8K6FhaO5D0gEa1JK33kqpq4RO64buMBka
JLSPJASwVkFdlpVdvTQNLJXVBcqlqoAqkxBgtJ8GEq/injJpVcGxHwZGYnI0
GJ5bt3bkVhX8x/6tb+tBGqyJnilUeFkFxdO6b6MxP3Cde/lkb1oVFEx5bRo5
gZ+/26QpWlsF1VLXs+u0aABx27n4pqpgt+qeqKN4Hp26a00bOavB+9anIB5L
XJ/0KYJBthoyR8/47nahQaCB4m66fTW4Rm40uhVCg3jPe+N9AdVw2WSvgX4c
Db6nFKa1fK4GW99rFg1faTDErKXya7Ia8gS5/0y10UDlq8X5CPsaMFv/+V4/
Bx3O9yVvCQyogcqyz40XttLhOvts25PPNfBJ9esHW1GsV4eV39+vqYGLhyRC
OPbQ4aWFx3XHyRpoK5iIk5OhQ1xQyV4rjlqIHHmvVqRIh+/5G6dMZWpBO7vc
LBP1Ujumk6WnXQtjIwdSl47SYZDvtZuGfS0ICnX4+SCPK2pdqqoBtTD1yFfR
UIMOHPa7mBU/14JHW2HjlbN02BVhU763phboT6Q9orTooFyWFiA6WQtuloeA
8zwdtGYX9Pk46mD/zs3sGRibiRDbNsnUAd1yYcQb47uaXt0M2nXAAaLJL7Tp
8ML1T+zizTrQqVnlrTtHh5gYDhv6izpIEzVJ1dPEelJjINOfWgcahz2+C5+m
Q/VqxFxLdR18fa8vAifo0C/R9616og42Ve44mq1KhyW9PR6/2OvBkml1OPIw
HTY/vHkid389FP9Q3rGqQIdDLSvVcTfrgXpUqvc/vL+zTMdCIl7UQ/a+LBtv
MTpclfUxCkyth5siiWCxjQ7PfXkG7k/Uw47rntSojXToVdq3rHezAQyuRud3
dtFgwdwxX+NFA1y79VG1DPPlxsAcL9XUBjg7/OeQWjENxPLIGorVDZCiRmu0
w/d/cPQEu9REAzwaTD5rmUgDzS3PGkTZ/0Lp1qlAjSgaXD1W95pv/1/4j89q
l3QoDW7b8f+3SesvXM3xb5Z4ToNn4aY7GW/i84Iu8Wcf0+B9SczIov9fWGfX
7J/0gAZZ06Mp9JS/UKUTbqdzhwYVQrJO/VV/QUxi3Yy6Mw16NG4rtdL/gm1u
1eNQBxrMu/wg1WxuhIP2PKeIW7j/D4zFv6QbwZZv52ZVjEWrT/vmnmsEXkLE
4RU+r7jy4lyaXSOUhqu1quJ8h+5ahjD7N8Kvn3tK+HE9pSXVduPkRlD/mXdL
CPej7Lp1R1pFIyy8oVxQ80K9L0xZMY83wqUhqbsuT5E3lz+fjdmaIMAgNTQG
6zsxF73wWbIJXo51a2dH0ODojO5jY6smkGuJWCeXRoNjDlIVn32aYFIuqcLs
Ow2OT63jZk5oAqUP9pp8ZTQ4OfEl6vNgE8TRJM/5duP9jvF9ZzJrhvhAyXcK
LOj/rCcZjB81Q5GW2dTBzajXkbLTn6ObQVFNedN6HjpoW74PYCpsBsP7rJ0h
yJ/O0J0mo55m6DVYoTQL0UHvuo7QZ0oLLE0xdv/cQQf9AUlzJpEW4LPu/6Mu
QQcDM8YkoyMtcI6zZdM19DeGfW3TqaYtEJjSwsSCfBpdzVRietACl+IOy8nI
08G455mHUWQLUCFY7S/q0+SyeWnq9xbY8ylv9/RBOph2wWam9haotZ/keoR+
9T/TLfpGKy3Qf7by8WNlOlzuoL9JFWiFTQyO2osYXzUp7V2n3AqCcvcC2zC+
1vZuj9HFVmh/RMmWwdjMyNU+1bUVrMffOi5jPb7eov113atWcPod+0UF17Mw
3EMy+toK9/44RK0eoINlE/VEamMrNNRJ3lWVo4O1QevTdfOtUFo+8YZ9Px1s
/qbXXeRtA+7KfFOHvXSw1Xu6NfVAG/RQpZkddtPBrv7a5XV6bXBIWfIjP96X
vY5K/EXHNtgqxrH1Ft7nrVoeekpgG2iGKpd64307Vf9yu1jbBrKzdYIC7Jgv
yneHpZxrB5nt8wefoP+4p0HpZLRrh/urfUMlIzS4/7t558Xn7XBqil9cA3l8
oJ5mk5LUDk8cv3RL/KWBR6lvOmNFO0TO2627W06DhyevLhmOtQNnh8NpXfSX
nr+UVVNYO4Cjy47xdw4NvI5zP2GU7IDtB3bP0VBvj4vGKg1Pd8D5+aXd9Z9o
4H2smCfFsgNc/WNLn8TQwOdnhDGjTwfEvotk2PqOBr6qztGG8R2wsiA98TKc
Bn75Z0eSSzrANizeeQV5fkaIyzAOdsCh9UlHTIJpUHLpgXIitRPyBJqSsgNR
v5GjHfqcncDSl1nBhXFpu8FDimgnPCW2m1pjrPdHkZss1wlJWUoj/chL79ct
sWvHOmFvf94VD5zfPnZecVW3E55z37snj+uTghrLls06oUdBbN30W1zfI8to
ybkT5nkolGTcv4Bd6PiCdyeonZ7r0cF8lGDs8mA+rBMeG3PlVqcj76cNOOYS
OoHn9hmXTbk0KFZUjJ7J6QSP30H8s0VYH3duOTD9pxP2n/7EZF1JgxvkxgsT
453QFF7QHdpDg5gv+u9GZLpg7cAlt6F1dJD7oCA7fLQLGqRVGDaifywI4C0a
1OmC3pA6XWZ83+cezOkNXOsCDY+zvL+56dBu83ewz6kLWj0PvDnFj/q7+MW1
93EXPBz4zuoiSIfFkyGsPaFdoMKR5HpahA7eB5wjuuK7oCPrDlM26o1bTF+6
M7sL2Anr+WxxOkSxKxS0/+6C5XtXy49j/pde49Fpa+2C10ePnNdH/X4fne1r
GeuC3EKvzwPIr0Zzg3PzaheU6R13nd6H/eCvzPVNm7rh/F7R2DvSyE9G8Ou/
Qt0wHmQRcxfj2SinvQ37u+Hg7wO68/i8p7/ejzrVbti5M3uJjvNx3DugVXu+
G3wmoo5Z4npvrXh6qq92A7txo7QF7kfqwqxDlWM3WPRHMU3jfr8db1hX6dUN
/ePORznQ36nLZYaWh3RDCfndnT943kbhYIk/cd2gcot0WnI7HaaWdTVLy7rh
WH/kQyZeOjwYlu/81dINl3WZ9r1Cf7Gxkdu+eLQb7Jxl0klYzyTS6oN+buyB
zGuDvG4MmE8sdNtytXugRkPE5CS+P7qe/I1vV3ogg/1K3KNm5O8YNznHoQd4
DSz0FWpowCozE/D1UQ84Zqq438L8+2p7vVhWcA/si3OI1PxJA3G2jMzM2B4I
pKZfaPlGg8zFwJMZWT0gpPFCV+IL5vNBh+a00h5obRNiVf+M/rNex/pzcw+4
xGR8OJ5EA5OfcqspIz2wpVy0dfdHGoymcPknL/cAz4OKnkX0V64R08JJbL1w
9kzGxe+xNGD2q0v7JNgLNjujjjlhHHw7Xe3jvl4YSn60JozPi5kH/o0neiFu
bEn7ezwNPus4WMRp9QI/udNZDfkmVHWWYi73wstPBZLJyVgfecQVHtr3wtKk
fMQ7zAepI0v2lzx64a7WeK5aFvrBvMokpYBe4JCy9X6OfIgEvR/mjeqFIsYt
92/i+ZstnHdOp/aC3FmVstZSGgSonL5cld8Lz3sOmuRX0YA6ONnk3dULMYcZ
tqd20ODbt2LuaxO9sGHa8V3IAA0cXrzSOkLug+9PdG4m0ZD3Q6qlC0J9MBpU
CptIdAjfxMPYIN0HTHcHhcXx/en2DhGfiT440p7UsZ+ZDsVPX2RZmvaBnpFb
/8Qm9I+Xr00ft+sDnbItU0GcdFBQOCgt+qAP4p8LPF2HeqFvYLNee94H4Wpf
c5SQt7jOztiWyD44OFu0TQr9kGlGes+X5D6oswtabEC98fl4bw/80QfbPuzU
kkY91pgYXbSr7INK6rM+OfRTPrLSIRodfXBM1VWjE3lUZWaoFafhfu7kTEvt
Qr/W+ncj41offHLLkhJEvaenflTv2tgPDFw/93/C2NrrvleuYD+s239keyPG
YhfPF4RJ9YM7dww1CuPWfbtWHVX6wTNHqZ4F40CGpYPamv1wZiXfjgvnP9NU
4Shl0g8/mcdf5uP665KiUlls+6E9oameG/f33cNprN+tHzornN5w4/6d9NV3
/3zaDy27hHiK8XxSkoLXIt/0wx3dqyJ78fz9pMm3dxL7gatP8owW3k9kfVGr
fm4/jGqYfT2I97f5vo3O5rZ++JAZb+uE/qLk/BH/0dF+GNhSea4F8527OPef
kuV+CNoucm/HejpMVn876i4wAI/JixVPyXSoE2OVnbw4AF2uV+UM+7B+LHTY
VlgNQLNP1j77dhqoVaQlJNwZgI76GaFurG+rUY/7vXwH4Pl3e4Ov2N9lOl8U
ufJ6AMQ+K29f94cGthr7TODjAFzslwquRz+6U5j6amvOAPCdGQuRLaBB+0xD
/VzZAAz3MUVIoJ8KKUtgr2segNwKj/if//rDyHtnUoYHQHDPnNQ61Duzg/YT
v8UBICu5rJvPoEHeyZ1F11kGQaPd5NIbrBcu2xZJavyD4GjKlTWPvEhPlisL
SwyCZ81IEwuODxW/c1k5OAhTfpuaajCOeu2Y3nRqEM7l3duimUkDQ7tT9IwL
g9BswqbtgusJTfnz91sOwn+Gbu+fY33uc2w8xnN3EAIvR85d+YH1an77jeNP
B2H+eHT2EPJmd8c8zCliEG7NaTtwIm8HVpN+xiQPwl6bOlp1BQ2WHsyONeQN
wkjK3utc9VjvvR6pKvQMQrCZdkAL+kWN9eXW5tOD8EK+M0VxmAbsflwhIYxD
sP17K8/vCRqEv3g/MrdrCLKerxaEI3+XuUa4xQ8OQTgxts4R+RMPkSEM1Icg
JV0nQRn5SwvPD8yyHoLuVteDdsify/b1PwbdhiBGo0K6BPOxStS5oS3Ph0Cq
qaR+AOsdw45QzlNvh+Bc6Mib4i10KIvtOHw7dQhML97NNUJ/5C+x63p8wRDE
018ov0c96ibaBjTVDsFMUPb6QNQrv3Tmt/V9Q7CeaQOLhDAdOj+v9B+cHYLr
K1Y7/0N9x8irsVsyDcO6KqreAewnrbL8lF5tGQZBjqgPsRhLK9VdK9s9DIru
W5XTMZ7N3eq/eGgYXkk+vWiE8TfiSraExjB8svS69A7nc/+Z0GtoPAwydcJZ
j3C948cnN/raDoMAWbCbFf0da+nBgzn3hyFj0yYjJazXNafdr4z4D8PDldJQ
HgE6hFSUPN0aNQyPHWVo0Xzoj7U2Z51OGwbfplePx9CPi9Tpd98pHIaOntHj
85ivBvUiWT/VY6zw90s58pXY1H+gtR/ne3hk0omNDoodjr7K60egk0nqpBX6
jdX/cjOs+Udg631RszIKHX72MnSG7xkB4+fVsuqr2B8Mv5RbOTMCZ/U7jEYx
v3LZtJjsvTQC/gPTmuQhzN80kSfGdiMQ2NJgbIz6uDaT2pYbMAKjYgH6sg00
kHBZYBp/PwI0bd0vFZjP6YuEjGDGCGgwChZM/UYe3byNNItHoD1V9k3yLxrc
JVV53fs7AuxjLdls6D9VH/KmJg2OgBtvQw5vPg2Y1l1qaV8YAb46Zr165PGP
dwzjpg2j8MHgPaGB9SVgw/g+EBiFQYW+HQ+wnho8kze8sXcUwnSTX9ljvI3d
zTNSZRQS7ehbRfH57peFSZVnR0HgFI39Oc4Xx8PatGY6CuGMV5tS8zA/hJ2n
StuPQpGeao0n8iMr8Hqv6cNRyGNd57CG+WI+olvfP3AUOiKOmfPieb4LS3jk
fRiF29EK0Xno9xbLD9m8zRyFCi0rnbo6Gsi7njZ48GsUeB/klxugX/hUYy1F
DI3CJk/XXsd+Grx+mNz8Q3IMTrAdEfFHfhr25RVFHh6DDx/Lkyao6I9aq1Lu
a46By1jCbzUmOmh6d72+dGkMQjfrPniI/ZuP3KQX2I2BdofIlih838WdFPvt
7mMQHR1wMAz1QH7Kabz2Ygweej9bNkW9KB8UO9kRNQaau23WJpAvlz452R9p
Y9DY6uSqhnylv1ATjCwcgybJb1q6mM/ph/XW368fg/7qjTsEUJ+Sw2bTJv1j
EBY2ZRyEvJkHO3eozI1BzUELpVzUc5Sqd5kg8zjQGcxa/JG/9vHQjNUt45CS
Mn1kI+qf/3X82/bd4/C2ud1Y7l//eCLb9/uhcYgJaWahYhwwVeYUcXoc1ngU
2O/g58sjW/67ZzQOMsIbRCNwfmaNUQ0Tm3EIHx9vsMX1j80vK6jcw/nMtN7S
MR88iGYTFXyO8eH7Rbtw/9/OCW5cjRwHAV+X83x4vvllqYW2lHFQOfZl0z8/
LRsPvbn543DTZeP1o3g/trrnKt/UjMP7fZWmT/D+Esj/Zbv1jIP7uavu0Xi/
IoYe/ocZaTA3WGnhiu/DZN3LO9t4aLB3r8rm45jvwj6/N1vZSYPYoY82zFi/
Nm8oUs49SQPhhLEV8RnMp1/qd725gH1Z7AfNjnHsn670c7hZ0qDVTta9ZJAG
hZvmVozu0GC3SihtGvlay2EaUvajwYqKnYxDGw0OXd9SJ/CGBm5OunM6jTRw
4tr9Yxn7FN/ppqboWvRveQcTWlHXEXUPwA71OG6tHvQN/7Rj51YoQL1K8F18
EN5JA9HRtIvRJchvkZXVXczjHjcbcgRR31WKKnuk/tXd1FeFCsjj+LNioQis
y91R7vunsT6y9mnybMQ8rXu/jKSPsYTS3w338J5vjD22/g/jky8ukccxDy5Y
3BvkQH7MBgZmjdHH73xUIWbxr788bDdaLkuHQy9NuU1xvaiX812HsQ/3i19c
mcD95A09+Jt4DPt0aPPgxXrdBuvLt52hQ1JyZu6vf3wFvSh4qov3fvKz3jye
d8soX9aKMR364ozevcH70AmVeN9mSwffyttZ7OjXmbo/2XxzosOH5hspl/B+
s/fsU3x9D+tKUd2J7jGspz9kyw2eYV3h5X52boEGtcyZIQrBmLf1mMWE17Ae
aite5omgw75XdbIumC/H+pTnahPRN3m2S0lgPXu770f+5ww6GM/d3zWAPOrc
PuL3Ihd9koRgvTfqhennTz27IjpsXeXmXI96ymY9Lny2HH3OSdKmy3iPNnol
I3vr6TBtIq/3jIsOQm/VM1nb6LBrybzbG/N97dCfByO9dDh689COM6hfL9mz
p8tG6ZDqk8bxF+vDQbdq7vhp9KEidyREUf+jxec7Hy9jXncrvS+FvEZubkgw
Y5iAA7fnfsxirG1o4KjGOgFunW8VXJEfxuhmEOOaAOXEMw1fMM4aM2KhCkzA
NdNX0skYWyt01HWJTsBv+ZYHphhvd/8vMm/PBKx4Hoz5g/PVlPVYRMpOgIac
psgMru/FZSZ3T2kCDiUCdyvq4qDJ4KrR0QnIO2Sj6In7HY21LFU6PQE3+TL+
0tEfRk6MvuQ/PwEc+ddKd/z7vknphsmC4QTsYhy/ugvvg/HRhHjj5QngC7js
soj9cFbFralMywl4uDyhHI3+wWrLbG6Q/QR8Y72iLoH3LXjZxdvBdQKqRXOe
BOD78Jy5u03GZwLkK2weijCiv4e1gc0BE7A75Y2YPr7PYW/3z7SwCTBk/3Rm
E75vLQGvE4nxE7A3YXfE2BQNGMyYOfxS8b7upm97hLxmJfu0Wn6dAJpHsfdJ
rIdWC6yxp/In4K1uvMixXhoIHn1+U7x0Aqh3T0c/xP6l2o9dmal6Avwtx4U4
WlD/DS/X9TdOwJXj5qMLWC8VhHiqCzsnIF1M6uEx1POwRejr94MT0LH9lsMi
6v1NGr+ZB30CBn5aaYqWo/9cCZf+b34CAhjXPS3C/pJ6YvsSkCbhylFx337k
J9P/XZEg8yR8+xHp5IP11aJZ1H9l0yQsxTceT0feBMRiDFt5MZZzyLyGcaWN
+I6c7ZMAjmUQibHHlwRa2K5J8Oo0ETDFz8uT92a77JuEP4YnTsTg/IPqyZ76
CpOwXHXPwxbXfx24/+wBmIQIP+5L6cirZnsaH/eJSWDMlDhpj/snix/ondKc
hDvLL/3fYX+cfjMrqUZvEjgEOB4ewvNfzzl0O9VkEtJZRxzksD5uZcw96m82
CTU8uc2P0N/X7bjNyHdjEj4OGZ31RZ6fHZf/9c55Eng+Bxq0Ic8U70T1NO9J
YHo0Ni0xjf1inAWr8otJmDeuWVu3SAPH0h0VhWGTULfvdT8d3+8gS4RWQ8Ik
NF9O1mlAPUTtMeS8lDYJs9vJDMnIs5EGT/1AziSEPKs8Z7uBDjw2NcF2hZPQ
310bx7qRDpVPnxks/JkE8WLnRg/k2TtJnd+jfhLKZEIFy5Bn1cp1rSzteJ+8
VGhF/S7TCt687J+EgcNuL9NQ35mb718SoE1C2laRraeRZ7v9SsIf5iZBpGTq
cQTyIaE9172XNAU2t5zUE5CfXvu06EzmKXgmpvjaCvl68/KGGbBPwR+tPR6d
GOul7xEv4ZsC98m8FibkcXP9wNA5kSm4OZh+sQvHy2bef2ySmAKDtUdPbTD2
5DG1uSw7Ba4yYTWJOL+KgsC+EaUpeKG30eSf35zTb6TfOjYFW6O0pXRwfyku
gZ+XNaZAufAhQz7u3zLsnMMj3SmIOPTtAg3PJ5bNemCjyRREnzPX7sXztzeX
zAWbTUFeUF7yh3/fJwscuRPnPAUxB2bUY/E+WQ6vKO9/MAVPyJ4eM3jfhcZf
V796T4G4k9DIHvSnipH7PX6HTQGnvLi3HfqhyR9jR3WipsBZf1Bn2xINPnbG
M7Yl4PwSPw0tsJ4Kiog8Gc+Zgo0l7I43sD9pVG1Xdy6cAt//ZppPYL8YcOUV
K6l8CrzUr2tZY93T8NSr8K6fgt86h+WGkUfGDxz+7O1ToJ8T2V2O/eP3ogqt
V/1T0Ebb/0YE/ZtLvw+nKA3vZ6eW+ST6WRmmE/Uf56YgzLx6RA37p9Fd1BA5
0jTsOXT3mhjqP+bkD4Nc5mmIdH/h+xL5MLW4w3+cfRqWV+55hGD/xe+j0FrB
Nw1qknNVMhjXJky90ReZBmVRzwtmGPv9Tr7UKTENfW9iDPbj54+PWglbyOLn
qz3NX2D9JrGJ90woTUM6j9BDD8wH2Xt7o12PTUNX7xLvGvLmoPnWjHpmGmLu
cnGQMJ/svWEk7qc7DdLv5uh3kbf+51uGuUym4Yh7cYcV8vY2pe7jG7NpEJJo
q8pH3gyr/W123piGuIHqcHvkjWtSY1+y8zS8qnYUu4m8PZYt+pznPQ0yd1Qn
BDE/Npy4cyrLfxreSfCunpungZjR/s7k0GmoqjDbFrhCgwLPN2yRcdPw/DCj
Bhv6I/aw89HBKdNQIVd0JArft2nieqVnWdOw9Dj8xk70Gav1jtfdSqahuYJq
1Yv5/MzwnjWHqml4s+dJFQfqKXy1K8i6cRriZW595UO9jXCESl7tnIbqM8fU
p9G/Hdql+fPi4DScqBzhjEB/90SJwfA8fRqiHS8KcmK9aTybTVefn4Zx0aWJ
s6jvXVftHquSZuCUXm+kFurfyWWn4CHmGfheXV3CjXwU+bWm7988A47706Je
Ycz1LuD07i0zEH/473I7xlcyTnYLCc1A3H/vVbsx/ly66rJFfAZ2cNfcjcaY
3J6+abP0DLS/ktfaifG5ScsYJsUZUGEmkS1wvch1wofXYAZG+IKu2eJ+xvn/
1s6emIENrWMjirjfw/ueWo6fnYGW8LBn//yq39Gj5H79Gdg5ZVmxG/lr0V8I
abs0A9+quuP18T4krJOl6s1n4M1r25cX8L5uP7hW9OfGDEhveWEmh/mrJHCr
UaEzru+52WgMeTTLffwk7fEMrMmk8mxGP5tRfVjo4/MZqDncG/8I3xdD/1Rm
VMgMrCtabaejL4zaaNr7InYGtr/mt/FAvzQhwnPnSfIMTOayFl/D/Eso/GF3
/zIDAbOGmmbYP7ZfUgS7XzOwfHQ6fxx53OswXm9eOQPG7rx3n3Zh/+cdbX3p
7wz491n/cUJ/+zvckKrfMQNvW0ofpTchL6mbX2kOzMC0MlfiWdSvRVGx9HEa
7u9U3JVzqO+spru/Ds/NgEHxQG0u8sk0LmMivzYDf6KEhCKQTz3K0LQk0yys
H546P4t8fuCJ9BXbNAtdUZcMypCnaQldEQHeWeigPx4WwPgobPjKuX0W9Lbr
BtGQv4Dz+Wc37JqFXVYziao43mXu3E/ZNwtwXf08N84nfXev2+KBWZBrULW7
hjze9+/hnFSZhZeJ/Pn7kMeK6LCEoeOzsCDn0HKjGvvRr2ePdGnOYm04cFAI
84t1OWNjo94sRHzlPH4I809OV45tlcks7B6NuJGJfLLM3mQsMZuF8045Cn7I
5wUW8fAftrMgQT9x6jP2B3GC7TJfnGaB5Ff6THCABmon1E1jvGaBHvyfTASd
BmfpV/86PsP9+9vtcMd8eSHsvqZa8Cz202XZd7A+2oykK/d+mIUZoWNJx9AP
OQdWpqUlzkLlrouPCvD9ux8elniYMQu0qPvDcqiPoOfb+USKZuFyvnxVJ+on
UvGQ/8QfPP+9jDubUF/xXTpM+XWzMH5BRmwb6i/N58Y9/9ZZMHjXzcyI+syV
9Zm51IvnydTPL0Bef7VGW+8bnYUf/h9PaKO+qx/96FmdmoVR6xJyCtabFqlm
w4qlWbh5MqO0EXno+ztd/YY6B3y8ddOlyAvtwaZTNhvmQIeNbOiOPC3slshT
5pyDljlPvRWMqbXHFFi3zkG1dmW1MvLHdvdSUovIHKjG0AAw5t3huuOjBD4f
VBLFgLFwRWC4q8wcqDAuPnmKn9/jnMypfmgOvn/0YG/B9eSFynz4VOdgh5VA
xzjuB0p7yUOn5kAj8YLgb9zvKfs1lyytOXAd87tjj+c5v5Wf/vjCHAhf8to2
iOc1LpQz1/9vDhTPH4jYh/dhbnO2facF7sdXjXIG7+smj6XurN0cFGz6knwM
7/PR9cijQQ9wfX/NXQ2YH5+zZ2df9Z6DHxnyx/71n2HZdfvl/OdgS+CaAhv6
mURWFqHayDk4r7lPmwfr55cMsZCo2Dl489uGSRrrZ74JbLRPnoPFNelNMEuD
+hSH5c0/5iCpbCIvcZQGHRee3+osngP/V3xRopjvhygJw8kVczC9ruxyNdaD
qY+F/91vmINEScP1+ehvV3Q6GjXb5+AD42nKMtZTptWFs4L9eN5NTiy+2I+x
x3L9Ghubg5D+On6nevR35/ap5M7MQf3LzXqF6Ad3LJzK8FuZg4081Pk7yO++
qKuSRozzkHBM60QU8nvw9P33e9jmoVNB5YkS8nV0Oox/iWseNqjVzakjf2fe
pL8oE5iHd/tds2uQT/3jlcyvxObB/h1jVy3G/9GG7ltIzsNlit5/mvi8VSjD
nKLcPDwxcOM9gvM5Htluy6w8DypXnUricb37wwf7/h6dB9u0/3Y9wv08ealj
FHt6Hk7oHW6rwP2+VL5R63R+HupkGF+643ne9D1RP35xHpj+E1sNxvPGPovO
574yD4bh/DSmVhqkKvxQ7LOch6Z82ct/8L6Knkzv9HSdB0E+X1ZJvN+G9aeC
VjzmwY0h6+UW7Ef7n7yhOvvOw+1RkXjFSRow+xzvtAifh2yDQ4vNy9jvsrzW
7Imeh8Eh0kYhzMe7fWjfjBLn4cFix61KKh3UfULDzn6fh7sqAbeZUC+GLGNM
pcXz8Obnxlp35NXK54iTauU8bM6te92K9fUuS3Bvzt95+NTicoUd9efnM6wt
3zkP5/VDhPlRn+EskJ80OA8ZZzWOT6B+E31e7hOfwP0sXi59gfr+zjL45t3C
PDgd5lCcQ/1X+CizbqUsQAQI529DXtpZXrgGsizATKc2UJAnmk/fIBvnArz9
uHQkCmPShkP6j7cuAEdbAucyxpt9nxWRxBYg+lLd943/eNzQI+squQA3V203
N+O4jK9C1JTcAoyk3g81wVh1g99mm8MLUO7tH/cG1zvv23mvX20BlIx5z4Uh
n1c3yI9d0lwAabEGPR3cn4Pvk4tNegswIHFMvgbr56MN7aXalxbgIp1rAy+e
L9hXRvGP+QJssZ59uQv7zZgNj2PU7BZg7MYH/vXYb37xbeH64bIAcPGOZT4r
+glfz4nUJwsgpzuZUYk8Dm5ourQnYAH4e7cryCKPC757K6JfLcCl4Hfm3phf
+f0aEkI+LoCFxDcZdcy/Eqx7+NjTF6A28HvKLNZPJb/7j32+LUBP/4JsPtZP
Iz/xq27lGH+YaBzE+mnN6lYzW78AdzPkaKZYP938qgm79gV4JbEpQRLr5zPW
nclD/QvQ52fxTB/rZ4Sf67YrNHy+4dm2UdRrMmulb+vcAlT/sM6aQj3n+Yku
6pIWgfja98gJ9V7F6nK9knkRzhW5Gt1BHrr8/jScZF+EWE2fZCbkZZJVWK2A
bxHMdfQfbEeeKE8d05REFmF8kXy+CHnjZCsTzpBYhB11z3ctYiz2VNBfSnYR
fgrxOufi83Jst1ZjlRZBfD23PBvOr/b0l7XwsUWosB2p68N6qccm0PJKYxGy
YpzPq+L+zJ7aneLSXYQoiDsmgPt3Yiv68tR4EQbZx3qtkLfHT/l2MpktwrPz
2lLiyFsom23gA9tFsLjONnEc/X7c0wLKotMiDHxXpH3D/jyLjffmrfuLsF7v
1pIb9u+lT606Rh8vQuaHzfxu2N8PP+X61hG6CNEn3W1X0c/6k6+s/Xq7CNXe
1buZVmlwwDFVNSVuERQPSXj7IH8eRpqlD7IWIT6hX9gb/ax4VTirRd4iSGp0
dU9if1NxdOSsVgnep3uhz0nkj2+Pd4Nw4yJcNFR+FIF6+h7RwMfSuQjvvlbe
DUS9XeXYYTw5sAgcRxZz/31fy+J1620zbRGE252XVlGvKQv5PQVzi+gP+XSt
UM96Npt3fVxbhNwrG/6LQr0vd5pYvmRagpcpK7LvkIconcTEO5uWoN9O/Po1
5OVkyRL9Cu8SZD5jEx3DeFxJXU5j+xIM+UzyKSBvgcmhznK7luDKe4YgVYwP
iQ5kC+xbggIxoZubMO4Mll9lUFgCS88DQv/6VS8WzyNjKkuQIqodR8P1JO/V
eNYfX4LQgYPvGDGumRAqydVcgkaObOlu3K/ztRsbYvSWYIz5NaM35g+BplzN
ZyZLMPhTS2sRz1ugwRrgZLYEWytc8pQx/1zPM6w3sV2C/c6i9ucxP22Ui99y
wmkJcjO3j6tifUyPnbu4794SmGYf5t+MPBpuPR7J67UEnfaZUnmY/2IoPTsG
g5ZAWqBItQP9jIbTfouqN0tgXqnXegF5nBy6/ynrwxJwJl4aC1+jgUq1gOyT
jCVw3SHWeAf9Uu8xK6ebuf/2n5n2BP2UT9bXrxeKlgByTaJyRrB+RuoREvVL
kBSXLfUV/Zgr54eHHG1LEFcQo/cK/ZrQ46nixd4leGD12b4M/Vzx4hGWntEl
8AvmitFGv2dt63/m9/QSHH1Xd1QJ/SBHd7t/2vISBHI0ZvuiX8zS3Vv3mmEZ
uBQ2eKojHyald3g9WZdB0qCSww15ZDhcZmjNtQxV9Npfu5CvhJQtEToCy8Dp
69p/Bvk7J2bepSy2DEW0dr8J9LOzIRliOySX4dnmkCROHH+9geE6m9wy6H1Q
4EjHmLiv/XFGaRkU+t9rVeN8/ZNvx9uOLoPZHvG268irnxltf/HpZRB/bUB2
/tcPNx92TDq/DL/uxtBmkdfGM35ZwReXgXY+tLQbeb2X37x078oyxEb5JMli
PhKT3w3mVssgsKvpdxfyWhbn7HH21jJoJ6rf6EVe7QSKixTuLMNu8cCtMpjv
ePy51gs9XAbDooKIPOT1P+fU5/SAZQjK7rB2wP5zY8HBMo/Xy/Ax9JUpHXnN
Zi1g4I5ehrMJvRbuyCtHVM3tgxnLcJXBVaaG4d/vWQzTf+cuw/rvB1/6Yr62
UugZNy5ehpR4TldpFjoU/pm64vEX73OrhsN25NOO924EV+cyWLloxl5EPrdd
ZmiKGVyGSZu4YnPUa9knP86DE8tQN2TIooJ6dprj0vy9sAyqGmHQ9O/v61Tf
eBtTVoB61OWvHPJQ6bfjJ41lBYwzG6Y0kJ+7fxNX3DlXQOC0kb0g8iUuckCR
S2AFeNVtZ2IwrrP+bh8jtgLcV8kjvRi7fzmeqLh3BfZnyb34i7EUpXKgTH4F
9OLj5v99D9+soS9irLIC5cY+DK3/+AzpMKIdX4HFXeev03F92W7zEPezK/D6
3pH33zFfdErSqzkNVuCRZ8jCKdyvn7MLa4zpCmw0TLUKxnyjWEA6oWixAifu
bPgYhzz2sT5xL7u5Avly+mxem//9fW3Y7LjHCpC2PbfOxvw2PCq83913Bbj0
NXIFkb9ghQQrzsAVuCv8Ie065kfan+xOhQ8rUCjxaN2ff7/X4D26tSxxBSgR
gSLD6E9PXv6ta5S5Aq6jDb1q6E/fzrWUPfi1AkFac1YXkDcN1auMnFUrQD6e
0ravnwYLfqPwoXEFvKta1/793i3mr4OrQtcKXJD3D/2O+tIWWUkvHcL9PiV7
vcB6sWr9iHZxcgVeORx/VY28ffzCJjG+uAKKFeO3nyBvBpTgqw+oq+Dwp8Ot
APXOcEYwkoN1Fbwv/wz1RB5SQmKaorlWYfSOPtGAPBl3S3EpbFuFG0Ftht9K
sV/b+0WzdMcqPB3pkD5U+u/3B/DkotQquNo4XtHC+HLBr59jB1Zh+27hATJ+
fhPbudX7sArW3MZUdeTvm36jIsfJVfgrVKu3E/m+HmV6K/rcKtgYH+p8gfxz
jQ0mHriwCrzS+Ru8kLd8hZuDJf+tQkZSZ+Ei8mbrsSBy0XIVoskWfv3/+udy
d+Mx+1XY8NMnQAXzUTEvS+j9O6vwViy4bhbz1a3LATXsnquwZb+gCgX96J+5
qBMHglYhzHk0qwn9p5tI4f77X1ZB5v7DhDHkp5ecqjH0YxWUXxscyUB+NLre
mJ8vwf3tCeaxQH7S8nw8cqtW4dGDhQYy+kv+t85vdjWtAqnb3tEFefK4fzXr
RdcqpNUSKsXI05CJVu3S0CqUm4gM9SJP51RUxq9NroIn+42ECuQpa9ue9VWL
q1Ct0a96D/UqtMIrdoi6BkGNLBv/1ZvHrQwQvWENZn17Nm5D/Y/nTFzYyLUG
2nyriwz/vh993e7gIrAGDz8FHY3G+Lvr7+fdYmsgsvpTYAHjHYZZCRp712BT
VpwHRQD1f/BDUab8Gri5uCjn4fj0loBOIZU1EDK2bJPB2Gj+3pLP8TUwz3jw
8yKu9/OvFc+MJsbK+7gO//v+9ovB/kv6axA735/ZhPsNCFbTKL20Bn+eBJ2R
R74WHWXMZa+vAb/cnj06yNd/uts93titwTdN4qQS8lUix/qG6TbGVXPydLwv
aa6FLzfd10D3wZFNt/E+Q6f6alqerIFiZtT1VrzvtZqaMbWANZBLTFER/uc3
XnwS5X+PsVPssDXWN+tNps8LCtegdXRLZyn2F3XjGgmS5WuwfexW7Xl830oV
B4uC69dA39ZLfiv2d1GJOztJ7Wug+rBWSQr1wvKUc8myfw22vbyn9wr1ZG9N
4qkfX4Nm5awN1qi3ptNj0jC3BqEdz+uTkB9iT/Pp+LU12N/oRbFBfnQeXUlb
z0AizI8rhSWjvplnmvJUmEnERUYXuIc8fLt6ruIWK4lIeTIu1vEL839dcUvc
ZhJBi6ifaCimgeixw0NtXCTCLPrN1+sYN6SlzXLwkYgAps6JIIx9RCUYTm4j
ERTbaBsT/LzKy7fsbsIkIs2cxTivBP0qhXf75x0kYvSboVYW8hZj/1RyYDeJ
qAxyVvvX/xl2Uw8JSJEIpvngBB2sZxu1XU9oyZCIZs9dt4drka98uo7XARLx
VjhdbQHrtcN+88s5h0hE9X/+F5wwv4i/a7tBVyERcsfYKnUx//g/KPMxPEEi
vtrkCjBhP32MToQ+P00ixr9XmH+boMH8pS8fCs+SCKWqk8dfz9HgEkTnSRmQ
iO8PH+/7jX6SI5m/4ooRieD3FNpdirwVC75oCTUlER7haVU5yJvUqtssxYJE
OBR8sriEevhkftOWZk0iEvnutNehXvZUX+1vsSMR9F8RxjtRTwmHDExKHEjE
idVnlzVRb+LRpxvSXUhEZLnSrxOoxxg20Hx3l0R0PD9XxYY8iTnLFD99QCKu
ffNQDEc9R3XuUHH1JBH1B2oO0f71Y+p8mWbeJKLQP+o1FXl5m8Yqdd6PRMRc
DElpwFhwGykG/EkEq4eQudk2zO9eU9skA0lE+IeYU6kY89P7g7aEkogNSeoP
MzEOvdDMxhhOIgwp+7odMeb9Wf5oIpJEDJw+1kjD+YIl81fa3pMIxi0hrjsw
5gpOdyyLJRFSe7bf34I8BqzFjmV+JBEqDVwHf+N+2S1eX3ufTCImOeteEnge
/5pnbc/T8POvDFjv4nk3Knvo3v1CIj7q/Rfvjvfh98Gx/HoOibBd05jUxfti
2WShpvuDROw3Luxdwftk6j4rL/UL35dpSXE78uZ1+mgi/28SEaytEiSKvDFk
HNjBVEkirPqiks9jv0fy3sbd2UAiPNV7zwuhn1zcOzL9op9E5Cr7st5A3lxC
2q3vDZOInp1nT4khb3Okml7LcRIhf8GB4EfenCyLjPQncf2ipXEj5G26Nqvu
6CyJKLdf92EO65X94U8a0oskYiJnaHj63+9rYiILBVZJRKwa03UT1LPt5pfK
6ylkYt/r6N/KqPex217pM4xkYq544UsI8mHdc1uyez2ZkDwYn+xYhP2Ohk10
BRuZ4CktZ2z9ifUm01Qgh51MSCcWVVUUoP/brhMYy00mbOebO85hfPXJCdZA
PjJx72lP2hWMeyYPeT7YRibOvxpxZcLPXzaSWrYWJhP2EbMblQpp0Fkk7HBh
Bxn13jK3hOuZ7OMeVdtNJqIcleyOI59tocxXZfaSib2PH9pwY34woiy3CO4n
E8K/JhMuY/5otqKd3yBPJp7YeXzZifXOoL7795wimTAtCVl3oYEGf1UajvYq
k4lHpw2odPTXdey5srnHyESvtNJGYfSP2ndSPsafJBNq+emh74dpUN37XjRY
g0zcSHi1dhH9fMUXH84bOmSCU8+2WHGZBr+MDaaErpIJy8RPkWz4vks+D5pd
vk4mCiZvegojb2VMt5vfW+N5uD31OdH//DFar9lnRybqeFVam1E/Falh+Tsd
ycTP05+O2WH9qlonIX/9NpkQNbpy4g/Wg+qL2XHxbmQizntRdhD1WpOiLjDi
TiYasmiM31HPdYwtzyW9yITZ0TzHk8hDg6EV1daHTJRvWMf8UJAOjclLTsnP
yIR5vw2/5Xb0ewx+w/QAMsG48t/4IsYtFwRMZELIxAehU6myQnRoTfpUfes1
mUj1UPXgxLidelgtI5JMvNuh4fgKn+80KM+afU8m2i6VvizF+bsTjSUV48iE
+OK15ihcv5cyHnn7E5l4nXRBbjfy16d/jzMnhUwcXcfrYIr5oP/TxsfL6WSi
MdX51L/fJwySIxcPf0W92dyXn8HzD+vts72fSyY4DtTfMcH6PvrxR1dePplg
Gt3C4Y/3R9PtLDlaRibWxuTZrPC+6Ql2yo8qyITj7/qdOzDfTa6RUopryERu
ffKfEiodZuOFQ061kAnfjVovehYwn66msvh2kAnFKIVJTuwHFs6r3vvTg/vj
0LW5jPl3eeXytbOjeD4hiffvO9D/aU81+tPJxP1HaYtfka+12IcaNdNk4gXn
tKo88kVa4czjXEA91a/n3IF+i6IdLau7QiYUWsLLQ5Anhli52GAyhTj6Wsrl
FdafdcuF/I2MFEJMkDlYEfXPrKX7jI+FQmTM7WO6m0eD9TF95IsbKcTlC8Uj
1t+xni45OoZzUIjYQj4/9lwasJ5bN9TGQyH2ymar2X779++Ngo22b8X5Nv90
e4Tx5sWdVabbKYSjsleoPj7PcfbL0ShRCnHsS9psN87HGX3iS88uCkH1YZkX
zUd/uPBXYockhXC54U/lRv54NK9HmEnjftxUgpKQ/y3v59nj5CjE+k0UrQHk
jX/e+9GQIoVQMu/mT8d8InCGb0HiMIVQPMUmx4x8bYuKt7Y+gvun3jeqb6GB
4NzBzkQ1CrHJf2x+A/pHIY2y87RTFIK4EqD8GvOb2OzwIXttCkH7pfruDvr3
nafvJKXpUYiPGu8aYlZosOvtBpEZQwqRpfD43Q30JxLqkutdrlCIfSzhGwKx
X5CM/Hb3qzmFUHi0044ZeZOa1qAvWlEIjpCTzEaol/0RNn/dHCiE5ufHs3cw
n6+OumY4uVCI7tu69izIU5mS98sbdymEzNbcOhPkKdgn6Ob1BxSilW6jcQv1
fLkp6ux/nhTi4Nun4ar/fs8snrLX0JtC8D2r3V2CfCw55W4470chbuZIriOJ
IP9FZUOn/SnEXH3ZYj/GgVyNv44FUog9s57+rqJ0ML3S9+FwKIXYbO/A8xVj
yc+TDw+EUwghrW8x7zCeJ5Eu73tLISrBdrccxkVn2QjxaAqhre+pexPnC4jg
FxSOw/XDR5INhelgMrZrme8ThRD5HOk9ifuTUJZv5kihEH/7Wmf+/V501kc1
a0M6hWAC+/JDyGNB09lghiwKwdZ0JHwKz/9M3NhhJYdCdAlRwq0w3xg6W2rP
/qAQXE16sXFY73YVO0vTfuJ4hZFkKvrvaa5HGwd/UYjDS8Xb/DbSIe9KwGjn
bwoxfD65m8B+zoCcGFdTSyH8By+b6qMfETuX7fX7L+635oVfKfZv9IhfVwtb
KMT00PZQ60UaPFHuFsrsoRDL68dLjyJ/er601aQBCrF0aH/WFczHIs3LrbEj
FCLwddjEN6x32c68YWFTFOLGUmvsRczvXsVizgFzFKJZxybiB/Zb2twyur5L
eB9f6N5hqF/BqyDruUYhjrhYnZzF+jPyWYPdjUoltP0s/LuQhyyyIc2RiUrc
c0wqvZZDA89z5uW2G6iEp3DnnG/Wv99vO3w030Qlmkptoy5mot7H3Z+YclKJ
R3bTec3pNBhUfm5+gZdKPH6s8pEN4wzfcDXtrVSip2AP21waDTya40VPb6cS
ilvvt4fguObuL+RjolTCL+2HCS0DeXIp7FDeRSV88mS5l75g/SyuzpXfQyXm
KhfrMrNp8Jm747XUPiohvnCkSAD3e//q6O1dslQiIMnDZgeeRyNtQV9IgUrw
SqcV/cL8soXCdIBPiUrY8h5XX0Bee89xcXEA7v9QOec/v50SKTzJchTXO7Jh
shH96d1xqSrqCSrxq+WAjxXe76nDyknL6lTC5pOEix7ef3eznuW4NpUIkz14
YwrzZdLuqycH9KhE17pvFR7Yf7u63NzZaUgl+M6p5wegH+Xk8euuvkwl9GoE
i/cin51Xw/LKzKgEd4Y5Zx8r+s+0mIifllSiuyn9jjvyeUwr3zDDnkq8/+oS
cRz1F+hrJUd1phLPzY0gAutFTxH3Rq07VEKUX/F1EvIoQ8obiLhPJdb/tv5k
i/x5HLLMH31IJTpSvx9r+PfvJxy4Xh/yphLnsh13tIvRQST5u4O3H467LXI9
2EkH+6Hrmg3+VOK/vuSJzF10yBflFBcLohLAWJ1/T5wOm01yyfZhVMK0TSSv
DmPTUPOWH2+oRIqG9rUvGKfUsGewRVEJhfgOm50Yk9i+PbsYQyUaaB6tIjjf
uRNm1+MTqMSREyvzSTvoEOm+WXUuiUrkeOmdrhD9129mb1VLoxI7nZ6//Pd7
b5XZqzMBX6jEFaeW3Gbk9Zn0psrOHCoxzHGvtg7zUZvl1zipPCrR7Gc/eAfr
5d0ONqOyEirx+W4Zx+w/P8GXJb+lnEq84Qr90ob3K6BzeZNZNZXIvvRb9TX6
zZySzAJyM5UwCLzr8xz9JQv1v/Cz7VTCu2ttOALzreHhDU5vuqnElO8f+2/Y
7y2mXtp9cIRKiLQeDPLCfkV9dD31MQ318nrx9lWsd2E701vrpqjE9cztzz4j
b4OmJpki81Tilvfkwcfo1xRfM/vbLVOJ+LteT+ZQr971ny2+kxiIGncnGs9X
9F+bjI+yMjIQsoVlG/7xsVOdaZvhegYioOSTc2wy+lnP1NlYNgbizO2HwfKf
aFD8/WLVDDsDwWxDsfkUj/VpgTHhKA8DUfIn9h5XHA3MZFMevuBnIArHOD7f
ikX+bAyNOwQZiNvCvsrlGDPEMSjsFcX5IhYDhfHzOt1Jm+/sYiDMB/1sbT/S
IFrgwnDJHgbCkmlDTlIS+mc9aiGPNAPBrr2Y3vwZ+7EXiW+uyjEQZoPWEwPI
58vf+s6fFRmIKD3j26X/fh/OSNEiHWYg1j26MHwD66cM8UlC8wgDceSsZEQp
8ufhqscQrsZAjLMLN/37/yCq00ntQ6cYiE32FqtqeL92u3VfPNJmIKJX9vn7
jtMwn65Z1uoxEJpaNfe3ztNgU0T8MeGLDMTZ9xKOg5g/kzhW575dYSCKntyz
jUT/s6oRV81ynYHgb5GXMMX+48xj7Y8G1gzE3zJq5zL6p/D8Zc8YOwbCbkX4
+HXUz+hSjMm0AwMRxhriHYT1QPmAlqLqbQbi1e0tti7Ik5/dEru/GwPx3s7x
DiPy05rwYaTNnYGQKRTjlkF97+k7W7THi4Fo3BoUMb0bedp8UzkikJFoE12Y
jVdC//aszO55KCMx47vh8et//76WTezDg3BGwrmP0FjFuNnXrenmW0ZCL8Za
ugpjLZa/bFeiGYk4FTa7zRiXeEur6sQxEk47OyJ+HKIDweTjpPaJkZhk0Ynv
UKRD1qOehAMpjMTqid6aWwfoIM1wuGNXOiPBtkUx9YEsHeI8gjn5shiJpgN7
xVil6SBEpp9g+cZIGDAX/V+xlUdT9X1x5N17X4lMScmU5CdzVISzjRHhGSJF
UUqmUIg0kCH1lSFEI5oLJWNShjRTolLK9CqE3r2vkkL8jj/3Wmfdve85+zPs
u85dt1gDz4+HbGMn6ligc140oha/j9hU4e2RhywIUlgm+RPzR1Ls5JeuJyyQ
lwgveIH5ZmrcTfbVCxZ8bNDN5Mzctxmj4kvbWSDIVTx9CuNtR6RvZWEHrpc8
sy+cwH75172hkx9ZoHZCU0QHn1cLP8Ql8jMLAvQXrpEbwP0U+jR55wALnkUr
i+fh+aOWp1TrMcwCiiu93xnPL0XDb1TW/GSBRtX7eD7WG5UArY0aYyw4+zCh
eB7Gw9nB5NTFEyyoCZGa6C7A/m1nX4PoNAsmxo+tj8yl0fGvRr+nhQgIyGgd
5KVhP7o9S51PEOBQ8sBgy1HM19zv3tzZBBQ/+nX0YxyNfmxde7JdlIBtPCFe
RCyNAnrynzRJEBBxbveYyT7c317jExXzCdgfIpkFEZgvPrnoXF1IwKkqo6Hk
PTRq8yzenitPQC6HWb0Ix7YfiLwUZQKqCp/UTeG43n1rS4wqAQb1wcUrIjE/
vLsrGKROgGW0kXR1NNYjV8mVXloEZEcNDScdpJFae1CAgx4BC2LOzMlNoFE+
5/F5tJKAFWqSqPc41rdWhXYdIwKWGNm4crJolO4QTSqbEqDdJ7Wy8xyNyJa2
NZLmBLzLGRTZifnhoJ1GqLA1Xv/DdEcf5pvfzxIvjdoS8PpPuq9O/Yzerp77
nkNAioTi5y58Ht5WmWbP3Aj4pPAvSuAbjd49HI6o2Yjrn+pzOTxGo0f157vP
+hAgZPo24CjGnzH6I3HCjwBJVWL6O/ZH5fc5aw/tIqApqZaa+b53qUb4tk8Y
AZHV30Q5uN/kDL2/OEcQIKM1tvunJta7qqoFltEElF3z8TXSZ5DISvH1BgcI
mFw1NiKN+z+hPCBONY6AB8YZ/ZGIQZN6TRUyiQRIvfy9yNGSQXtLFw9RKQSk
137fk2GD8a0dJT/+HwFDg0rievYM2lbS6jycTkBw8YkwVUfsFxc8idfNJqDm
ZUJ4Kgf7vfj7d6LyCPgSwvyUdmGQ20gZ9/45AmKE49uqcey04YaEcCEBqz6d
5ITh2K4+33zdFQLzn6iOiTODrNVPhaffICCj60mlnBODzLJSC9+VECC2fGm9
xHq8P1NH2uTKCLjx5VW1ii2DVvnHCG2rIuBxXmCeJ65fry1U7/o9ArzKLD48
MGWQpvFOX7qOgHvXpjd6Y7yrXfHKNGgigH35gL2NLoOWzHNt3P+UgL4EQuwE
5h/5mHU/GpoJKDqoyLLAeirlsMrZ4S0BFgp+shzMh2LVmvFZHwi4WaPh9YHF
oNnKKnc6uwhwe2Hg7IX5VeD3PImd/QTM18z/44r90cQW0rx4iIBkYfcO0Qcz
/fIv7CePgH2HQizWzPw/e27o9aExAh6JtNU3JdNogOwTfDxBQFTCNc3jURgv
YR26IgIk3B8my7P9adT1scXHWZiEX50JFpKbaPTeqikjlyIhY3PfIW1HGrXf
qmnoFiFBuey0sYQVjV7KlvJVxEm496hZoMeYRs+OXFUKlCZh98W3WeUradT0
/RynVJaE/kbRM0V6NKpzz4obW0yCquwH/Y862B83HCs1USYxXy6ucNDFerg8
ru+IKgnz3iIfMX2Mt+wo8efqJITlBpspGNLo5nSw2TxtEqQkfgjEAI2u7Noe
tmEFCYYH9Hqk1tGooN2z4OwqEng5paXdbph/TDivuWtIuHhy01jdNhqdurpW
8H9AQsyB5f9OY7xnipvq7rYkIXSDqJR9Io1S9+v7VNiQwBmo6biO+enoV/WM
CXsSRtrJpMRiGh1xVGow45BQ0ia34yaehw/eleEnu5HwXPe26WeMx4hUYY6U
Nwkm/n72z/H5hY6NH/b0JaFjzyDLWoJBQT782/k7SLD8vtJx5nuEr0H3PM3d
eL+eJ8l6rmKQ14U3sGcPCa/O9jcrWuD5hP0i9G4UCZGKzXq+Dgxy2dOQP72f
hPWbtQUmPRjk0FXVanWYBO6oDrvFl0G2a0sE/ksgQWJPYH5FIParpZd02o6S
QB2T/3VqD4PQojNbF6TifCsM/T1iGGSUmJHunUHCNWW7ka5DDDKgk+svZZOg
UhZkL5GA9WrjQWYoj4RYI4NYbhLW04d7FXXPk7DzF7fT9CiDVDUDnaIK8X66
ft29CMcj6d1De6+QILp+bkUuXn/nFycx/AYJXhqFvbVHGLTP45FCaAkJdPrZ
m8k4n0nt6prgOyR82GBFTUYzSEixyDWwkoRsy2QNRVzv0yMKtH8NCeIBYtn/
ArDfHMhM2fGAhE1qUoIFPgxytSNUtjeS4L7oxo6F7gxaeCv6gc9jXP/zcz2x
dgzqkfjuseU5CSmj7090Y7wGdLaneraRUF3mHknM/P9oulbN4x0J+9+ENBN4
fvxdUNPo1onr8diqGTNzP3BXwZgTlwSzsnNTqU9pZN0ilenQT0LnX+mQd9iv
iege1bAfImF5wEivFsZX7p8Qn7U/SFgwOlDlshbz82buhOVvEr4+M3ZqUqPR
knq3HPNxEl6Xm387Pgf70SXPdGAKP79X6/IEzUMlycYvTIQo6K3dQfu+46G9
w7f81hAUbLqQc1+0joeMHJcIGM6mwKA8+bXNDR4SKMs5vVKUggo5s38bcnno
0fzZBvoSFJjLCQbGpPDQsZgDr3TnUyCnlDfEO8BDTt3MLu2FFIQsvWM1FMFD
8823C2vKU9DtF3n2TBgPfbrccV5dmYJ5j8Wb1XFcyLYzVFOlIO1gYG/VXh7y
D37QvlSdAqOfuzI9Y3lI67VuyBItCvR+TbYrHeWhn/qXKSU9CuLsJAMlcT3V
uQsuyq+koC056ezyIh46OHncRM6IAtW84YHNTTxkuXW6Q9aUghSbBW/Tenlo
dlN4uIw5Be5z574pFKBR67J+EWlrCqSPtGoHqNAo5/jGqxLrKPAhr0jdtqOR
kgt8mutMwahlCiq5iPWxsixyzgYKrJuS055h/1q0cJk425OCM3X2bOlZDFrN
nWst7IvzObf5i2K+nrKK6xXcQcH6SMkeP6wXTdd/xUzvosBerU//XwiDHMM+
3hoPo+BpVCKbexnz9VuHdX8iKJiYuDJ+sR77w9WNX0ajKYh8vyk+rRP7K4Hr
svw4Cm4lvNxQNZuPNLbLlfMSKfDzHlmzSZGP+E/SHEZSKJDJs+P+WcFHlctn
ffuWSkFzi+JXCys+ik2LPDKQQQF5IKKCceEj85/fFn/NpjBfhC6u2MJHlLtX
NTePAptyt4c2/nz0sqbVufccrj/M4qZfMB+dlLf83lWA8wU2Vz4Nwc9v/hb1
5DIFgfZWLrZBfNQZkyZUeh3v5xXdjXV+fPRPzSD1dDEFmaPWK3578pFiR6dM
QikFUW/W59+34yOLxMOFwRUU+C/tmTe0io/nF1VN97sUJDmdnnJV4KOUvhdV
cJ+C0gEt4y5BPipKCzNXb6BArPqCyc4eBr0ykWmRfERBnZqeR1cVg34M17r/
e4rzVx77q32cQfNP+3L7mynYbZn01m0jgwxtqODWVgoc23fPtsf+dvPv4rG7
b3C/OCdGauD57fAll/iL7/H7Ze5FB2zxvCVw4VRkLwWfZ395OLCUh76VWCpv
/ULBVGXI8qDE70jEa6jIdpACzmpDgfiPI8jlrkGjHEPBpzmT6GHQMOoNax5p
nMb1utez3mkPolmK4VFFs9iw1zpoWaPjAFJ9KSOUQ7Ih6/jkhFJAPwpW3yaz
S4wNU4IB6t3pX9A496+ZmAIbhKwr0PjdXrQ440LzH2U2eKzoNWTiehAgK3eu
Khtevr8h6JDehZLPpAdVaLFhrnKO6uryD0jKddmpTaZsOOw9yvpr1oZWCbUo
WZnj9TtL6zRjW5Hn7fAiLWs2dGQvkjJOaEH5Ig8aBB3YsIh5bD08/BgFuls0
/ufEBpHSw6GxvU2IGPQzznBjg3yRkvTm6Xr0fyCPqoY=
      "]], 
     LineBox[{{3.201398687058356, -0.0883599176106407}, {
      3.203367448943143, -0.08941336803739611}}], 
     LineBox[{{3.331855066687166, -0.03316233550938065}, {
      3.333927447618521, -0.03267820485982698}, {
      3.3357646886044985`, -0.031961080241251945`}, {
      3.337795323378473, -0.03086742865112979}, {
      3.3389556861064604`, -0.030106999888965324`}, {
      3.3413924478352293`, -0.028208812327389372`}, {
      3.3438872277003973`, -0.025875680043286654`}, {
      3.3455310748983775`, -0.02414443391496652}, {
      3.347271618990357, -0.02216151850225506}, {
      3.3510427978563064`, -0.017419552685699197`}, {
      3.3513328885383062`, -0.017033498927896386`}, {
      3.3528800388422884`, -0.014932730906078993`}}], LineBox[CompressedData["

1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAA3nPE/TOHGECmhWQoxUKRP8CHyB7J
iBhAF4SsmnlvlD90uVLxvYwYQIoK7VZZDZw/EJGHCJ+OGECkx1ImCnGfP2Ys
7RXMkBhAHD/u79KPoT8CBCItrZIYQBimgdBgB6M/3RxnlqeUGEDMPTzxlG6k
Px0YS6HAlhhAHE8qDzG+pT/QLRE0EpkYQI0ZvjL99KY/STbmgkebGEC+eXxk
z9ynP8I+u9F8nRhA4f5cCiOBqD88R5Agsp8YQE53wxHG3ag/tU9lb+ehGEBJ
G7J4MO+oP/VKSXoApBhAyQSCf363qD/5RVJfNKYYQOx8fPVML6g/0IOhCaWo
GEBKnKmFDDqnP9N+qu7YqhhAwUEXzxUHpj8Ueo758awYQNpixSjIl6Q/xo9U
jEOvGEDv9pMKUq6iPwaLOJdcsRhAWzaGFDaqoD+Akw3mkbMYQA6RNN4Uhpw/
wI7x8Kq1GECMknasYXSXP1gESXFKtxhApG4NVvI3kz9Wt6TU
      "]], 
     LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAPkDtr9P1CUA28xLAlB+RPysw7HPW
+QlAstAiJ5p4lj9Wdaum3v0JQMqIljs/b5s//A7uLB0CCkDY/7BPqxagP7JW
I2WCBQpAgzy+Gg7MoT9JQnM5mgoKQOp6YATPB6Q/dIcybKIOCkCe5qh7N4Kl
P5Z1+EUXEwpAWwloN0rWpj88DzvMVRcKQNsGHeYGzac/46h9UpQbCkANl8Jc
dnioP4pCwNjSHwpAhi2e31DZqD8w3AJfESQKQNq3BQQH8ag/1nVF5U8oCkDi
S0d8uMGoP30PiGuOLApA6rtIlylOqD8kqcrxzDAKQNwBR5G3mac/ykINeAs1
CkCOyVjVS6imP3DcT/5JOQpAqPxDUU5+pT8XdpKEiD0KQPoU0P6WIKQ/vg/V
CsdBCkBmsAPHXpSiP2SpF5EFRgpAWPyo5C/foD8KQ1oXREoKQJkOEtirDZ4/
JdommCVPCkAYnlzf3YeZP1h23yPBUgpAmwd2WWkJlj96ZKX9NVcKQHqYdDyj
l5E/pKlkMD5bCkAZSc3+LvyKP1vxmWijXgpAjbzFleIGhD9H97E1
      "]], 
     LineBox[{{3.39398588848118, 0.02526265788226835}, {3.396006853565755, 
      0.024997027279476083`}, {3.3977473976577337`, 0.02456600129151519}, {
      3.399584638643711, 0.023914575743797867`}, {3.401808667205683, 
      0.02286782552582835}, {3.403549211297662, 0.021862007072168323`}, {
      3.4053864522836395`, 0.020634122198808252`}, {3.4073155553189154`, 
      0.019174729120967668`}}], 
     LineBox[{{3.3663209071081184`, 0.004390040962419616}, {
      3.3668043915781154`, 0.005057963089264173}, {3.3684482387760957`, 
      0.007283608862581833}, {3.3707737990767663`, 0.0102914489885006}, {
      3.3727029021120423`, 0.012637645647888537`}, {3.3745401430980198`, 
      0.0147275255164477}, {3.376474080977996, 0.016757908348435577`}, {
      3.3783113219639738`, 0.018511415347651407`}, {3.3802404249992497`, 
      0.020155271531447826`}}], 
     LineBox[{{6.048290501784898, 0.016771310669055302`}, {6.048580272603946, 
      0.016478989132695382`}, {6.050415487791241, 0.014532032452917176`}, {
      6.0518353648045675`, 0.012918658496447865`}, {6.054858640349956, 
      0.009207417736595374}, {6.056307494445189, 0.0073131817989877165`}, {
      6.058046119359469, 0.004958095623098301}}], 
     LineBox[{{6.112619623613252, -0.019682191721877358`}, {
      6.114261658254517, -0.017188635587781893`}, {
      6.115903692895781, -0.014527881759683487`}, {
      6.116348008151647, -0.013781068874798715`}}], 
     LineBox[{{6.023756572438952, 0.023269760656429644`}, {6.025398607080216, 
      0.02399713722205498}, {6.027330412540527, 0.024653351062713737`}, {
      6.029262218000838, 0.02508504826494827}, {6.030614481823056, 
      0.025249601433153322`}, {6.0331258289214595`, 0.02524730322285009}, {
      6.03505763438177, 0.02496924256796941}, {6.037086030115097, 
      0.024417254427781497`}, {6.038921245302392, 0.023689435285089253`}, {
      6.040659870216672, 0.022802482227167575`}}], 
     LineBox[{{6.186370070147685, -0.003394744990421793}, {
      6.188407942467975, -0.010153617904748205`}, {
      6.190456597181495, -0.01711447031552686}, {
      6.192613075827305, -0.024547979181436315`}, {
      6.196926033118924, -0.039409371157564294`}, {
      6.199082511764734, -0.04665869559235932}, {
      6.201131166478254, -0.053319650350430944`}, {
      6.204042412650095, -0.06224150929356119}, {
      6.205551947702164, -0.06654589230628592}, {
      6.207600602415683, -0.07195844612968383}, {
      6.209185614220354, -0.0757582136099374}}], 
     LineBox[{{3.3114213907040035`, -0.018584655544113114`}, {
      3.3140325906775128`, -0.022306891543748764`}, {
      3.3152760192363244`, -0.023909547098859077`}, {
      3.3173484001676794`, -0.02632081765538364}, {
      3.3193171620524664`, -0.028296728580967892`}}], 
     LineBox[{{3.437272253079746, -0.011938119880170898`}, {
      3.4388435776072264`, -0.01326249406758912}, {
      3.4402940310172094`, -0.014400376233892035`}, {
      3.4422279688971855`, -0.015782057764489005`}, {
      3.443291634731174, -0.016472384590728355`}, {
      3.444132897708963, -0.016981989616000517`}}], 
     LineBox[{{6.252002497732901, 0.06602273841622545}, {6.2534257736391385`, 
      0.08087573834318598}, {6.255150956555788, 0.09973005409275625}, {
      6.257415259133888, 0.12584198596529506`}, {6.259463913847407, 
      0.15074204443604347`}, {6.261620392493217, 0.17818597183976573`}, {
      6.265933349784836, 0.23652235841097274`}, {6.2680898284306465`, 
      0.2672201797066138}, {6.270354131008746, 0.30039611661835036`}, {
      6.2724027857222655`, 0.3311367978574649}, {6.274559264368076, 
      0.3641226190319372}, {6.276715743013885, 0.3976301426745056}, {
      6.278872221659695, 0.4315321525168234}, {6.281028700305505, 
      0.465698690759063}, {6.283185178951315, 0.49999795918366946`}}], 
     LineBox[{{6.085381166622868, -0.02979305654154572}, {
      6.087216381810164, -0.03100890307728752}, {
      6.089051596997459, -0.03197872808135403}, {
      6.091176583003801, -0.032777529821239576`}, {
      6.093011798191096, -0.03317520937319592}, {
      6.094847013378391, -0.033292962212824205`}}], 
     LineBox[{{6.074176694953065, -0.018001947469705834`}, {
      6.075625549048299, -0.019865388639473402`}, {
      6.077460764235594, -0.022107676057616134`}, {
      6.078779221462254, -0.023626108381389725`}}], 
     LineBox[{{6.2165499887957925`, -0.08779911403006967}, {
      6.218490819577022, -0.08912565620195995}, {
      6.2205394742905415`, -0.08955215684172925}, {
      6.222350916353022, -0.08904036373847413}}], 
     LineBox[{{3.4135089913795387`, 0.013504547116116317`}, {
      3.4151528385775194`, 0.011800583210519891`}, {3.415733019941515, 
      0.011184131923383168`}, {3.418034406018686, 0.008675580889812117}}], 
     LineBox[{{6.100739020032341, -0.031718393354864524`}, {
      6.102670825492652, -0.03054789028265649}, {
      6.104506040679947, -0.02914065039202868}, {
      6.106230177053273, -0.027561950645486916`}}], 
     LineBox[{{3.4519991900357647`, -0.020079871975067682`}, {
      3.4539282930710407`, -0.020358376703033493`}, {
      3.4557655340570186`, -0.020444274724797287`}, {
      3.4565391092090114`, -0.020428349692881972`}}], 
     LineBox[{{3.207512210805854, -0.08838870904270689}, {
      3.209480972690641, -0.08649616360810762}}], 
     LineBox[{{3.3235655429617452`, -0.03146130863673741}, {
      3.3255343048465322`, -0.032402899806236056`}}], 
     LineBox[{{3.215801734531275, -0.075277262335506}, {
      3.217770496416062, -0.07044641504442165}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.08955215684172925, 1.089546884590811}}, {{
     0, 6.283185307179586}, {-0.08955215684172925, 1.089546884590811}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, {
   3.654949012338499*^9, 3.6549490167500353`*^9}, 3.6549497461684017`*^9, 
   3.655553951560014*^9, {3.684450215842959*^9, 3.684450221660392*^9}}]
}, Closed]],

Cell["Make  a \"frequency domain\" plot of the coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", "0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "\[Pi]"]}], ",", "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"3", " ", "\[Pi]"}]]}], ",", "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"5", " ", "\[Pi]"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.539348900461853*^9, 3.539349025162924*^9, 3.592056900794857*^9, 
   3.59205693153894*^9, 3.59205709743393*^9, {3.65399455589922*^9, 
   3.653994564692024*^9}, {3.653994603096509*^9, 3.653994613952845*^9}, 
   3.654948610036271*^9, 3.654949328129447*^9, {3.655553925089974*^9, 
   3.6555539542141*^9}, 3.684450221702795*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"ChartStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Re\>\"", ",", "\"\<Im\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592056964512083*^9, 3.592056985563291*^9}, {
  3.592057062331558*^9, 3.592057071627198*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.3020588235294117, 0}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.616], 
     Thickness[Small]}], 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5404411764705882, 0.}, {1.4595588235294117`, 0.5}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{44.200605242096835`, 
           74.75738054321049}, {-120.68829021111506`, 22.905638889281732`}}],
         StatusArea[#, 
          Rational[1, 2]]& ,
         TagBoxNote->"1/2"],
        StyleBox[
         FractionBox["1", "2"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 2], {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.540441176470588, 0.}, {2.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{76.7663767697085, 107.32315207082215`}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5404411764705883`, 0.}, {3.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{109.33214829732016`, 139.8889235984338}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5404411764705883`, 0.}, {
            4.459558823529412, -0.3183098861837907}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{141.89791982493182`, 172.4546951260455}, {
           22.280638889281732`, 113.92248598881322`}}],
         StatusArea[#, (-1)/Pi]& ,
         TagBoxNote->"-Pi^(-1)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "\[Pi]"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[(-1)/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.540441176470589, 0.}, {5.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{174.4636913525435, 205.02046665365714`}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.540441176470589, 0.}, {6.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{207.02946288015514`, 237.5862381812688}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.540441176470589, 0.}, {7.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{239.5952344077668, 270.1520097088804}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.540441176470589, 0.}, {
            8.459558823529413, -0.1061032953945969}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{272.16100593537845`, 302.7177812364921}, {
           22.28063888928173, 53.24458792245889}}],
         StatusArea[#, Rational[-1, 3]/Pi]& ,
         TagBoxNote->"-1/(3*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"3", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 3]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.540441176470589, 0.}, {9.459558823529413, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{304.72677746299007`, 335.2835527641038}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{9.540441176470589, 0.}, {10.459558823529413`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{337.29254899060174`, 367.84932429171545`}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.540441176470589`, 0.}, {11.459558823529413`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{369.8583205182134, 400.4150958193271}, {
           22.28063888928173, 22.90563888928173}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.540441176470589`, 0.}, {
            12.459558823529413`, -0.06366197723675814}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{402.4240920458251, 432.9808673469388}, {
           22.28063888928173, 41.10900830918803}}],
         StatusArea[#, Rational[-1, 5]/Pi]& ,
         TagBoxNote->"-1/(5*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"5", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 5]/Pi, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[
    StyleBox[{
      {Thickness[Tiny], 
       LineBox[{{0.3020588235294117, 0.}, {12.702708823529413`, 0.}}], 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, 
      StyleBox[{
        {Thickness[Tiny], 
         LineBox[{{0.5404411764705882, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {0.5404411764705882, 0.}]}],
          LineBox[{{12.459558823529413`, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {12.459558823529413`, 
            0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
           LineBox[{{1.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.4595588235294117`, 
              0.}]}], LineBox[{{1.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.5404411764705883`, 
              0.}]}], LineBox[{{2.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.4595588235294117`, 
              0.}]}], LineBox[{{2.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.5404411764705883`, 
              0.}]}], LineBox[{{3.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.4595588235294117`, 
              0.}]}], LineBox[{{3.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.5404411764705883`, 
              0.}]}], LineBox[{{4.459558823529412, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.459558823529412, 
              0.}]}], LineBox[{{4.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.540441176470588, 
              0.}]}], LineBox[{{5.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.459558823529411, 
              0.}]}], LineBox[{{5.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.540441176470588, 
              0.}]}], LineBox[{{6.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.459558823529411, 
              0.}]}], LineBox[{{6.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.540441176470588, 
              0.}]}], LineBox[{{7.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.459558823529411, 
              0.}]}], LineBox[{{7.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.540441176470588, 
              0.}]}], 
           LineBox[{{8.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.459558823529413, 
              0.}]}], LineBox[{{8.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.540441176470589, 
              0.}]}], LineBox[{{9.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.459558823529413, 
              0.}]}], LineBox[{{9.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.540441176470589, 
              0.}]}], LineBox[{{10.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.459558823529413`, 
              0.}]}], LineBox[{{10.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.540441176470589`, 
              0.}]}], LineBox[{{11.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.459558823529413`, 
              0.}]}], LineBox[{{11.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.540441176470589`, 
              0.}]}]}, {}}}, 
        StyleBox[
         {Thickness[Tiny], 
          InsetBox["\<\"Re\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
           Automatic, {1, 0}], 
          InsetBox["\<\"Im\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
           Automatic, {1, 0}]}, "GraphicsLabel",
         StripOnInput->False]}, "GraphicsTicks",
       StripOnInput->False]},
     Antialiasing->False], "GraphicsAxes",
    StripOnInput->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.3020588235294117, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
       FormBox["\"Re\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox["\"Im\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.592057072075521*^9, 3.592057097646439*^9}, {
   3.6539945560734167`*^9, 3.653994564849016*^9}, {3.653994603235777*^9, 
   3.653994614082698*^9}, 3.6549486128139677`*^9, 3.6549493299949427`*^9, {
   3.6555539265428133`*^9, 3.655553956304641*^9}, 3.684450221793887*^9}]
}, Closed]],

Cell["Re-write the Exp series as a Trig series", "Subsection"],

Cell[CellGroupData[{

Cell["term2[0] = term[0] //ExpToTrig //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 CellChangeTimes->{
  3.539348901072105*^9, 3.53934902523506*^9, 3.592056900871686*^9, 
   3.592056931675244*^9, 3.592057097671525*^9, {3.6539945561216993`*^9, 
   3.653994564877943*^9}, {3.653994603372724*^9, 3.653994614166765*^9}, 
   3.654948617597234*^9, 3.6549493328935347`*^9, 3.655553959016693*^9, 
   3.684450221807502*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["term2[m_]= term[m] //ExpToTrig //FullSimplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"m", " ", "x"}], "]"}]}], 
  RowBox[{"m", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901338854*^9, 3.539349025465629*^9, 3.592056901077137*^9, 
   3.592056931864159*^9, 3.592057097861994*^9, {3.653994556335165*^9, 
   3.653994565006339*^9}, {3.653994603495202*^9, 3.6539946142942657`*^9}, 
   3.654948620062367*^9, 3.654949336113909*^9, 3.6555539610249863`*^9, 
   3.6844502219268637`*^9}]
}, Closed]],

Cell["series2[n_]:= Sum[ term2[m] ,{m,0,n}] ", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["series[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], "\[Pi]"], 
  "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"6", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{"3", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "5"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"10", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{"5", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348901508812*^9, 3.539349025532612*^9, 3.592056901121194*^9, 
   3.592056931985405*^9, 3.5920570979048*^9, {3.653994556759735*^9, 
   3.6539945651973667`*^9}, {3.653994603566409*^9, 3.6539946143891582`*^9}, 
   3.654948624824272*^9, 3.6549493401192207`*^9, 3.684450222051445*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["series2[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "\[Pi]"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], 
   RowBox[{"3", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], 
   RowBox[{"4", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}], 
   RowBox[{"5", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348901647589*^9, 3.53934902562461*^9, 3.592056901159855*^9, 
   3.59205693204438*^9, 3.592057097944783*^9, {3.653994556831818*^9, 
   3.653994565364707*^9}, {3.653994603636812*^9, 3.653994614428404*^9}, 
   3.654948626578991*^9, 3.654949341745473*^9, 3.655553964859816*^9, 
   3.684450222122757*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"series2", "[", "5", "]"}], " ", "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"15", " ", "\[Pi]"}], "+", 
   RowBox[{"60", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{"20", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "+", 
   RowBox[{"12", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}]}], 
  RowBox[{"30", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901716475*^9, 3.539349025693151*^9, 3.592056901169058*^9, 
   3.59205693210773*^9, 3.592057098009361*^9, {3.653994556897757*^9, 
   3.6539945655319557`*^9}, {3.653994603705914*^9, 3.653994614503924*^9}, 
   3.654948629062478*^9, 3.6549493469298353`*^9, 3.655553966917391*^9, 
   3.6844502221661777`*^9}]
}, Closed]],

Cell["Verify that they are identical", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"series2", "[", "5", "]"}], "-", 
   RowBox[{"series", "[", "5", "]"}]}], " ", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539348901862293*^9, 3.539349025783277*^9, 3.592056901228616*^9, 
   3.592056932189663*^9, 3.592057098170868*^9, {3.6539945569647207`*^9, 
   3.653994565644332*^9}, {3.653994603768785*^9, 3.653994614569409*^9}, 
   3.654948631890818*^9, 3.654949349354373*^9, 3.655553969013239*^9, 
   3.684450222216654*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 3: f[x_]=...  for x=[0,2 \[Pi]]", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=Sin[x] /; x <= N[Pi];
f[x_]:=0 /; x >= N[Pi];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349053690878*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF1nk0VW3UAHBDcc1ESWaFQoMpKrUPhUSmlBIvIW+DKYSUSN5knqIkZJbI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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 0.9999998782428621}}, {{0, 6.283185307179586}, {0.,
      0.9999998782428621}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.539349055652882*^9, 3.59205690165224*^9, 3.592057098895738*^9, 
   3.6555540805835247`*^9, 3.65555458149955*^9, 3.6555580395979958`*^9, 
   3.655558132397368*^9, 3.656350114092636*^9, 3.684450230043438*^9, {
   3.68445042824487*^9, 3.6844504566696444`*^9}}]
}, Closed]],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["c[0]= 1/(2 Pi) Integrate[Sin[x],{x,0,1 Pi}]", "Input",
 CellChangeTimes->{{3.655554040449512*^9, 3.6555540407034903`*^9}, {
  3.655554560803001*^9, 3.6555545687030888`*^9}, {3.655558018620522*^9, 
  3.6555580195451717`*^9}, {3.655558101424471*^9, 3.6555581026782618`*^9}, {
  3.655558158856255*^9, 3.655558159511436*^9}, {3.6555584163240767`*^9, 
  3.6555584226826468`*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["1", "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.539348898608249*^9, 3.539349024083955*^9, 3.592056900043282*^9, 
   3.592056931073666*^9, 3.592057096800711*^9, {3.6539945554408913`*^9, 
   3.6539945642812357`*^9}, {3.6539946025558243`*^9, 3.653994613374568*^9}, 
   3.654948390510152*^9, 3.654948474194743*^9, 3.654948511022745*^9, {
   3.655554013533903*^9, 3.6555540429279613`*^9}, 3.655554085295927*^9, 
   3.6555545838122473`*^9, 3.6555580424656353`*^9, 3.655558104315441*^9, {
   3.655558154424096*^9, 3.655558163438938*^9}, {3.65555841924098*^9, 
   3.6555584232528048`*^9}, {3.6563501141593437`*^9, 3.656350129108726*^9}, 
   3.6844502300692863`*^9, {3.68445042829312*^9, 3.684450456701879*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", "1", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", "Pi"}], ")"}]}], " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"1", " ", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.656350103803959*^9, 3.6563501099050837`*^9}}],

Cell[BoxData[
 FractionBox["1", "\[Pi]"]], "Output",
 CellChangeTimes->{{3.65635011425928*^9, 3.6563501473367987`*^9}, 
   3.684450230089958*^9, {3.684450428318652*^9, 3.684450456738611*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
c[m_]= 1/(2 Pi) Integrate[ Sin[x] Exp[- I m x] ,{x,0,1 Pi}] //FullSimplify\
\>", "Input",
 CellChangeTimes->{{3.655554047855514*^9, 3.655554048143386*^9}, {
  3.655554570959148*^9, 3.655554575566895*^9}, {3.6555546087592907`*^9, 
  3.6555546107814827`*^9}, {3.6555580301849947`*^9, 3.655558031560699*^9}, {
  3.6555581610636883`*^9, 3.655558161751276*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "\[Pi]"}]]}], 
  RowBox[{
   RowBox[{"2", " ", "\[Pi]"}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["m", "2"], " ", "\[Pi]"}]}]]], "Output",
 CellChangeTimes->{
  3.539348899882002*^9, 3.539349024467109*^9, 3.592056900477057*^9, 
   3.592056931261525*^9, 3.592057097008535*^9, {3.653994555571148*^9, 
   3.653994564408968*^9}, {3.6539946026898823`*^9, 3.6539946135026283`*^9}, 
   3.654948392881493*^9, 3.6549484760088367`*^9, 3.6549485135191097`*^9, 
   3.655554016151898*^9, 3.655554050921568*^9, 3.6555540876951847`*^9, {
   3.655554586023901*^9, 3.6555546117649803`*^9}, 3.655558044530075*^9, 
   3.6555581653843813`*^9, 3.65635011442415*^9, 3.6563501498780203`*^9, 
   3.684450230277135*^9, {3.684450428491597*^9, 3.684450456923441*^9}}]
}, Closed]],

Cell["term[0]= c[0]", "Input",
 CellChangeTimes->{3.6844503280960283`*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["1", "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.684450328423048*^9, {3.6844504285145407`*^9, 3.684450456943741*^9}}],

Cell[CellGroupData[{

Cell["term[m_]= c[m] Exp[I m x] + c[-m]  Exp[-I m x]  //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]]}], ")"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348900096125*^9, 3.539349024623434*^9, 3.592056900596742*^9, 
   3.592056931376429*^9, 3.592057097120233*^9, {3.653994555646126*^9, 
   3.653994564481369*^9}, {3.653994602805489*^9, 3.6539946136003237`*^9}, 
   3.6549484779031267`*^9, 3.654948518518489*^9, 3.655554056534498*^9, 
   3.6555540913378897`*^9, 3.6555545900250196`*^9, 3.6555580510417433`*^9, 
   3.6555581689507217`*^9, 3.6563501145081472`*^9, 3.656350154636302*^9, 
   3.684450230310898*^9, {3.684450428546501*^9, 3.684450456975171*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"term", "[", "1", "]"}], "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"c", "[", "m", "]"}], " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "m", " ", "x"}], "]"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"-", "m"}], "]"}], "  ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "m", " ", "x"}], "]"}]}]}], " ", ",", 
     RowBox[{"m", "\[Rule]", "1"}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6844503820774727`*^9, 3.684450403192418*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.684450391012137*^9, 3.684450457096743*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"term", "[", 
   RowBox[{"-", "1"}], "]"}], "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"c", "[", "m", "]"}], " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "m", " ", "x"}], "]"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"c", "[", 
        RowBox[{"-", "m"}], "]"}], "  ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "m", " ", "x"}], "]"}]}]}], " ", ",", 
     RowBox[{"m", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6844503820774727`*^9, 3.684450414402087*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.684450391012137*^9, 3.6844504572088137`*^9}}]
}, Closed]],

Cell["series[n_]:= Sum[ term[m] ,{m,0,n}]", "Input",
 CellChangeTimes->{{3.6549485336493683`*^9, 3.654948534968346*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"series", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.684450295244153*^9, 3.684450301882801*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], "+", 
  FractionBox["1", "\[Pi]"]}]], "Output",
 CellChangeTimes->{{3.684450297729579*^9, 3.684450302237132*^9}, {
  3.684450419366661*^9, 3.684450457236723*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"series", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.654948537062978*^9, 3.654948544343122*^9}, 
   3.684450423553918*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], "+", 
  FractionBox["1", "\[Pi]"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{"3", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.654948544832046*^9, 3.6555540607715054`*^9, 3.655554096096627*^9, {
   3.6555545945768623`*^9, 3.6555546171973124`*^9}, 3.655558056410533*^9, 
   3.655558173106843*^9, 3.656350114691337*^9, 3.656350157861409*^9, 
   3.684450230425733*^9, {3.6844504218050003`*^9, 3.684450457270605*^9}}]
}, Closed]],

Cell["Plot the series with different numbers of terms", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Plot[ Join[{f[x]},Table[series[i],{i,2,5,1}] ] //Evaluate
  ,{x,0,2 Pi},PlotStyle->colors]\
\>", "Input",
 CellChangeTimes->{3.653994609851053*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxF1nk0VW3UAHBDcc1ESWaFQoMpKrUPhUSmlBIvIW+DKYSUSN5knqIkZJbI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      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1mk4VW0bBmCpsDfSoKQkScbeSiikrkXIUESaeZWQpFLGREplLlOGSGSu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      "]], 
     LineBox[CompressedData["
1:eJwVlHs4lOkbx8ep1Mz7znSkUinSSeu4UQ7dS1Rs5bQUu5EkJMQQaSNpJiqG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      "]], LineBox[CompressedData["
1:eJwVU3k4Vesa52Kbh7WWqZKkDGVomx3h/VKhiMw6IWmSTCkludIpJam21I5t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      "]], 
     LineBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAA7C8afRfkE0BAxl6eSrSTP46px6c3
5hNAqAoErEqHkz/SnCL9d+oTQFj4Md5wLJM/dBbQJ5jsE0CwJ+Hhl/6SP5/T
fjKt7xNAQHJobJ67kj+6CSt92PATQNCXKPIPopI/XIPYp/jyE0A4DZLiYXOS
P/78hdIY9RNA8AGqsW1Ekj+gdjP9OPcTQFgAR9MzFZI/QvDgJ1n5E0CAGwS8
tOWRPzPX3s+N+xNACLmVICO0kT9sYHoydf0TQLgFreceiZE/9FZmEnH/E0DY
nuLPEVyRPwREPtJoAxRAWLwVy0cBkT8iHu5RWAsUQDD8ozL/SJA/YNJNUTcb
FEAgeZ6l55uNP9o6DVD1OhRAsMYm2KNhhz/QC4xNcXoUQADPogc4zHM/fL+W
Jnx8FECgTqGxh+RyP2LkAAm+fhRAoA80Pt3jcT+sULtm5IAUQAB0zjPb7nA/
zOaEUl2DFECAavEU3KhvPz4pMCIxhRRAAL3spXUGbj+Ilep/V4cUQMCnnG1D
GWw/Gm5fO6SLFECAyQKW1TtoP2TaGZnKjRRAQI9liKRLZj8QjiRy1Y8UQMDQ
cbVfc2Q/J7TCJg==
      "]], LineBox[CompressedData["
1:eJwVU3k4ldsbPU2ukLidb391k4yFaEIq0qtUKlODyFUpMpSQIkk6ZioyJpRz
jvMdYxGlVPQqNKASXUURuSopRVwZ4vf9/tjPftbz7r3Wetd+t/IBr+0HJ3M4
nBJ2/X/Xk1glexy5AFveB+zY7Yqmk5IOOD1gsY6iaMtCd9RaMG4qrmRxzbeO
4nWHsalZUvF6NRc4FwI/Ki06gkobK081PWbrUjF9Yh0vTIjy3Jr3lAtxuwzV
mKPeWKy40kC1jgs/4g1Od6YexbGz/Umbn3Phun51YX66D34odDhxrp4LSyVr
1ILzjmGsk6v1xQYuVDzsc73GP45vXigXlL3iglJ5MNUh9MVDORfdpzez+Ke8
Oz/rBMbt5rVndnChfeO33epFp9Boxrk71zq5IGe7ZPlYViCqLB9M/97FBccT
G0PKb51Gj4zCYeozyy8Z6pN0Jwi3V855Z/uFC4KrzK99T8/guJ9ayYGvXJAM
Ho9g9vHQrLPtz+heVi811l6ug4ct93Y8/6ef1Qv1ftHaGYxqGrLaYwNceOJx
zt3oYAhKWfjLGg9xwWzi4GepbyF4ixP6yWyYC5fWllV1uIYi58iaDV6jLP+G
lJPq3aF4VclMMeA3m5dXR+AnpzBM2FDMKZtg8909zyKyJwzfFXns/TCJgh/z
CuwzPcJxZfHRCtWpFEjamvdPGgjHjMIReXUJCn5NVz+51SMCiclzVxNJCuLy
XZa9/hKBEs6+swJkKJhtGdNa+CkSP+ZWHurhUmB3C0aM2qMxS99xznN1Ckqv
tZQF1MaghkWqX+ImCi6NPoubUpGAgjaPusLNbP3R9knFYwk42xtU6rZSoPRP
9FfjVYkomfjp2VRrVi8seH5fUSJ+fqOv7mdHgZ54eL9QmIS5zg2Ndu4USDTt
Ggo9eRG1AqWXKZ6jQG53z7Z309Iw6uw8IxJDATdp4SLNVWnYdWnJJtkLFEy1
l9Nc75GGgpIde8YTKDBvlJ387mUaUt/To9vSKOhPjFx8IS0dOQe0P2TkUbBa
ZsDlsPIVfL3JInF+DQUHnQaWG3EEqLdrXwZdR4Hl/PmbKSLABOejuTOfs3jn
T2HNIgGaByfjxEsKMqxG6p/sEuDDu60975spUFgq/EsqX4AFOp6mgm4KNK1K
aTtzIcoY8awu9VCgljzCf75PiO5bEuzjvlEgQ4+aKBwToprrLW9eHwWds+5E
G6YKMVUwftlxmII2vu/C4E4hhs26MKg0ncDXHMub7V6ZKErxClovTSBhSVfD
9JBMfDjX+g+XGQQG9rTUjCVmIkdNfk6+PIG8Dr0s49uZGKiXaKT/F4Ezscvz
FoxmYnrpsWpbBQK7SmqWJ0qL8K7RTssARQKVm47aPJorwl+mlCOqEBBENdcE
GYrQ1yYldPMiAlONmzV0/EWY1HxCxkOH9VMko1cZIcKbe+ySY5cQuGySy1dI
FmH/wTnZjboEhl0MftNFIvT0S6/ZY0Tg34rIdPWPIowZObWDZ0zASlXrWG2/
CK8GObzLBAI3V9j6L5sQ4ZeIeb2fTAn4iFWOG9EMuqTw5X0sCHhstyfrTRkM
n8tLS7Ii0CNnY/zekkGG76h6exuBrVWtbit3M/ghW1l/zIZA7J2C5UpHGJyk
Pfm+oh2B3vOtkgV+DCpd/7DRxJ6ATJyb1dAZBveWiuwi9hIouzZx+W48g6eN
wjpyHAl0Gaq+001j8HKF86HaAwRUfjWMumQy2PJEPVDOlUDr+nLL4SIGh80l
pum6E4i7tO2e7R0GZ7/8GGNzmED8vQWnPCsY3NWczU/zItC9hrhXPmPQd0+U
RvlRAjP/bHvJecVgUodb0ftjBAqK100ZbGawoVuzUs2fgNYuNQNOF4N9R6TM
NwUQePLkhi/5wqBc/5dX7oEE+kemDXb0Mmg5kv+xgEcgwIQsTRli8EjQea+X
IQT0fjlo8kYZPD/5yK+fYQS2Vfu3KUwwmB9hEUwiCSzQze71mCzGGqnFUqui
CRxdazvsNU2M3bGyiX+fI3C1UzNDXVKMkrO+zw2KYd/3Sn9gjJQYNVJeMIIL
BJYN3dbPlhHjprnXdSrjCUTL3nTzkRWjucKLww8S2fdMdux+PVOM1vN6czGZ
gFKFs90vOTHuVJzxuTyFgN83C7dGeTHazddeUJZKwHp1Q63bn2J0UNrqfDed
gFp7vX4pi/crH8osvUIgI2n77gcsdlGJbr/FJ2DfHd0dyuJDqjmKJUICJL8x
dYLl81R77HBDRKANbs/TY7GP+se0IjGbh/QnDWVW32/BtObCbAKTK8HrEev3
1EI1uiCXgOWbZ4zqDDHyNNbbXM0nUFpfeXqltBjDNA8k5l0j4JAVVjB1uhij
tIJf5hQSqFLn90RKiPH8IsHM7CL2vvmL7gdTxBinjRbiGwS2ZI3vKeaIMVmn
7ZyohMCtq6a/7X4zmLb491PhbXb+VD8FlgwzmLFEQVJwh8CH4/YJjwcZzFxq
uDHjHgHHWet+xvYxmLXMPuxyOQHvBm8b6W8MFupe4qQ+INCk2Dao3MngTb3b
ximVBA5FFgvutTJYqt8UmFzN5s8bUZ/+hsEKA+5w/FPWT+ii9Pu1DFat1DWI
qyXA/NYdVq9m8Omq7b6xz9i8Mr/PgPvs/BnG9Z19SaDuefeqc4UMNhkVLolu
JGDe9q7iXjaDb9c8PxL5D4GP7V9br/AZ/HetzJfQZgLO0/8o841l8DMs0gh5
S6DG0KX3UDiDX022uPBaWT9LYlLlAhkcXB/1IbCDANdswVoPNwZHTLOVTnWy
/ranXlXey+D4hkd7T3YRCLzS5B+xg0EJs6lvfbsJHJ8pTfasYf+XOa/Rs49A
0otJNStmMKhgwZc/8pPAo9DvCfs4DCpb3rc6PMjO15YZ8fo/RahlPVbrOkxA
7sAGhc+vRWi407/KcRINK332/+F4RYR7HbxLtsvTcPnHvDuOs0UYH5LTs3EW
Dd57tU+nSoiwKqdd2ZCioeLfruKggUzUGrSOVZ1Dg7HtU57Fi0wcilnmOqDE
8jmtlv+Pl4lx2D/74lIakqx1lda+EmJll5bV2eU0VDWbzlAtF+J/0k7hQXo0
WLd0lxWKhehg19jnspKG/vp43kNfIWr23agxABqi9t/yeiwvxIcqvoHNVjR8
1j13THGVAAfNrhU/20bDzY0d7scVBKjh1fX5wQ4a3jQbHHw/zsfYezY2ebY0
PFE7UZ8Xxce/d65YfGofDTn3G/4uTMzAgfCh9wpeNGgYN4qpyMu4oPvkesdY
GmDocHdWewrODecNBcXRYGe2aBUnOgXllCPzrySw/DqP7/kuTcFhu6RZby/S
wPG5n3Yj8CLWPSnotOGzdbvREk+pZPTJ6Qzdep3lzzCpDxuJR1fTLwaHimm4
xKzN9UyKR4f2Hz1RN2moz+L/5akTj9aBQ/zsW2y+eX0PQqrj0F/ikl9HKQ1y
LdEqbrZxuPrmVMmuuzQ48iZ2v+q6gIutpcumlNPAS3Vy9Je7gLOjZquZPGDP
mxn26jvG4H1Xi6oVDWw/BidtOnZGII+6a7P6Fas3wPtY6xeOOXx77eNNbP6a
Sal7zoThZcP97Qlv2Lp3V2ZNfChWVU+6XddCg9KTECfriyEYcczTrP4diwd1
1k1cD8aAmb5jvW00/GiZHlddzkPnTSHO2p00tLstnWIpOo1SC29PVRlg/U3W
zh7deRjrXqleVP+PzUty4+AJd1cszZXy/TbE9htstPbgVyf8HwwKaxA=
      "]], 
     LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAeLkO1jgQGEDAJn38vsltP26uE93P
ERhAgArYfP2WcD9iShqR7hMYQEB1fgI13XI/KvjFK7sXGEDAWygwV/p2PzL/
Za4HGBhAYNkBHLdNdz8MGKsXAhoYQGBzOa6Cd3k/wEk16vYdGECgt2/2RNV9
PyitSY/gJRhA4HmIVsRcgz/4c3LZszUYQBDfNdbLkow/mgHEbVpVGED4z8GK
4yOYP3QaCddUVxhA6PAEM9vImD9OM05AT1kYQECuYJ+vbpk/AmXYEkRdGEA4
h3MT77yaP2vI7LctZRhAmMAaZ8pjnT88jxUCAXUYQHSzww+AbaE/3RxnlqeU
GECs9g/m1DenP1YlPOXclhhAWNpq82Ojpz/QLRE0EpkYQJTrpyl9D6g/wj67
0XydGECgETgBTumoP6hgDw1SphhAdCLzzGijqj9ypLeD/LcYQByXy018Ma4/
BywIcVHbGEDKNczrYtqyP4A03b+G3RhAaCKnVsMYsz/6PLIOvN8YQJiKK/9n
V7M/7E1crCbkGEBKBEjZfdWzP9JvsOf77BhAKsLCUNrUtD+cs1hepv4YQNq0
6jpK4LY/FbwtrdsAGUBCpKM76CK3P47EAvwQAxlAIi27lclltz+B1ayZewcZ
QFiS4hFW7Lc/ZvcA1VAQGUA4t2U7lPy4P+D/1SOGEhlALj2dGktBuT9ZCKty
uxQZQDg5tMJEhrk/TBlVECYZGUCE2j8fABG6P8UhKl9bGxlAVgDKq8FWuj8+
Kv+tkB0ZQOamXrHFnLo/uDLU/MUfGUCagT4bDOO6PzE7qUv7IRlAEntZ1JQp
uz9L+Qq2
      "]], 
     LineBox[{{4.90216758940559, 0.024390463964157783`}, {4.904243420664441, 
      0.024259195568309466`}, {4.912546745699848, 0.023721404094810605`}, {
      4.929153395770664, 0.022585818631786825`}, {4.931229227029515, 
      0.02243834635832026}, {4.933305058288368, 0.022289664364760486`}, {
      4.937456720806072, 0.021988693222054823`}, {4.939532552064923, 
      0.021836415194977005`}, {4.941608383323775, 0.021682949691724518`}, {
      4.9436842145826265`, 0.021528302392562065`}}], 
     LineBox[{{4.88140927681707, 0.025631897991377023`}, {4.883485108075922, 
      0.02551365251331275}, {4.887636770593625, 0.025273198392994828`}, {
      4.895940095629033, 0.024776561304027694`}, {4.898015926887885, 
      0.02464915156513134}}], 
     LineBox[{{4.9478358771003315`, 0.021215485364920045`}, {
      4.949911708359183, 0.021057327233988288`}, {4.954063370876886, 
      0.020737541085602745`}, {4.962366695912294, 0.02008425654753107}, {
      4.964442527171146, 0.0199181140962289}, {4.9665183584299974`, 
      0.019750855441408227`}, {4.968594189688849, 0.01958248682566327}}], 
     LineBox[{{3.407417087057614, 0.004041257584458002}, {3.409254328043592, 
      0.0035516566790310955`}, {3.4109803676014705`, 0.003094341336063955}}], 
     LineBox[{{3.436619549045254, -0.003397643303039377}, {
      3.4383600931372333`, -0.0038180041103628715`}, {
      3.4422279688971855`, -0.00474292496304049}}], 
     LineBox[{{5.151065043662154, 0.001292765550888697}, {5.152849601794186, 
      0.00108914108339353}}]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1mk4VW0bBmCpsDfSoKQkScbeSiikrkXIUESaeZWQpFLGREplLlOGSGSu
UCgVIsrYpF5DGtgpMu+FbU+mb30/1rGO88czHM9z39daaxzOWTsJCggI9FLP
/99zq+gff2td3fGNtXQyQaUccsvkFGXj7FFh6BrX5lKOiZ/RFh2x5/D6itOM
WV45GPqN3aWxgWAZuIt/UapAq0dPfnZsFFocPHYfVHmF5sjxRamxaTBxDQrf
uKUKe+74vU2KfYzsbc0a5uXViFxdmZoQWwVlQc2+BuM6DHCEZvU9mlH4wVDZ
rLAZ2tMxe0vcv0J+52dtrn8bGjsPXRNcy8BTeTq3O/EHCAObyRyHPzANXRxX
+vwXjribks8O9+HenE1exr//oHKNatDr7CEMtDw0faXYB5sk1cyfZ0lsUR7N
bxQZhHB3/pkKbxJuRl4r3iweRJnaRu2UyyQ0CnXXlsoMQq5K48OhWyTOlLwf
DN00iOEePc5/BSSW8MruMQ4OIljD0rxpiBovMFFrnT2IFx89xktdR1HcZFgl
uW0Ip5ezX8VfGMXufVeHNA2HIOvgG+rpN4oVtPrePXuGcH3Cf9Xm8FF8s3yr
4mo/BCuZ4F0FD0bRcqNru/k1at+nklIy+0YRtMZt78PGIayc/2pntPMYPlUU
ZRXvHUbLuovzpc+NYbp+sWLM4WHcMtaqv+8zBtVRN2tnh2EIhhaYlYSOgaA/
iWJ5DKOPfs+q7eEYtrj6tqclDKN0YaC9DHMM3N+cCLVvw9T6+pfyfMax/Oid
iL7DI6Bvn9ZTvzKOQc8dOlHHR/DW7uXMy9BxyA8Iv1I7NQLtNPWgd3fG8cjz
7AZj3xHIysuHjZSPw3ntsgUCCSMYUpqbqCnAgv+3hJCgTyMI0agtfh3KglZd
yq5kXSbadl0yfRHNwiX/i+zrBBMKtuqMx0ksaOsprHc2ZqLmeqp4Wh4Lb7du
WylmzcRMq5dLQAMLwqxD8T0uTHj7KsrqikygONbV+91tJmojfzxVXzgBjecu
+TLJTEjejzVXWT6BlR7pKo5pTBQ3zvguV57AzwVvBlofMDGyov0/9q4JsLsu
yxlWMuH8KiSsJGQC/impWiY9TDz7vF3uUdQEMriy66f6mZjXO16akTgBm80S
6jkjTGQsOPYnJncCDM7koR8cJjrtteFePwGVwl6HvnkkDgj2s9YLs7FVb2/e
4FIS2cvSIhQk2JgnFHlwQooES3W/vIwUGwZ3pSZ40iRi91VbiiqxQeYemxhf
ReJj1p2H/cZs/Btl8/vhOhJGu8yO5QSz0argarRWk4Ql6djudYuNgGDh5C9a
JA7fCbQwSmAj+Dlt0n8rVbeDT/X+ZLNxv6fgZ40uifio1dLytWwcPbVbaIk+
iZ521ufUuRxwH1Sw3+wmwbwiYXpGlIM4YiJqrQUJnorqa70lHOwQ71a4bElC
3N++8Ls8B41Za3coWJPQkmsKlzbgIL1u2VLNgyRuuKTtjL/CQfP1iITjx0hE
LSorcwzlYChqOsj9OIk7ZS3qmtEcbNvyy87PgUSBGF3uvzQO2jvX/bjsSKL1
iefUwioOFE2v/TVzIdF1OMqDUccBEWKiqX6KRL/gw4HHH6n9zFFzXexKYtqm
66tFJwfG1V23ak+TWMczfRY5zYH4OOvRCNXnGzMc19vO52LXGl/1/HMkdMwD
M9XEuXj8PDPF0Z3EntSnMU0yXHB3Ta2sO0/ioPEnkWQFLgRkt6ifu0DiOLM/
8NR6Lg4s3ayyxIOEl/7qsyJ6XFjVPaky9yQROKDT076Ti4aLtnYMymFxNra5
5lz0GMj8OOdFIrUnzMz4KBcSr/deCqRyJvdWVvXSE1woJdJTZikXba3S7nHl
Ir3JIdnPh0RtGEvxuh8XllZpW477kmijmcZPB3ERWbykopVyb1jqXJ8ILj6f
lthqeJEEhzZ2nozjQlJAJzefski4MePUXS5a27aJSfiRWE5PsfidxYWzXoPT
acoq4cwK2wIuzBziSqopm4Un3bGspNbf9J+q7SUSR+jDwo11XPi9aNqXTvl0
uL63wScu2FVC7p2U/ekJf8rbufBg2wQu8ycRGT5grcXgYs5YyFUTynfpqC7s
4yJgo4+3J+WC8LiNyqPU+SyetUumXEnvS73P44LRK6BdRvljuJ7YSkEe6J0O
81ood9Jj/G7TeehetPDNX8rM8J4+8SU8XLzG9ZigLCCqezBkJQ//rlwkNU15
YcStWgEFHp482Jc/Q3mN6G8Nv/U8rOqt1OBT3hyxNWNck4e+cwcKmJQNRCMX
ntnOQ88HeekuyvsiGJd7jXhwP6vu00DZUVRr2N6Cmj/3dv0jyp4RYUc7DvAw
+OwEPYzyDdHORmt7HrIry3CMckLEZu33J3kw/1B2Up1yjmhIjpE7D0UtYUFT
1Hk9j/guWeXLQ2yhdXQ15QbRTde0r/LgttIo5grlrxHXR4vCqPE18Td0KPeJ
dtirxfKQuOnymSHqfngR/3zMSuahtUPP9A5luliQnmwmD2eklkoTlFdEtj1M
fMSDg7LlTwZ1/6piatKLnvJAU9dOuER5W2RgSHgFDxW68oYLKdtGKjsGfOCh
efjwFSWqntzEAr6wW3ngrnaUeEjVX0DkZ8K9kwfeib7bipTvRfqtOsGk7ocn
fkOcqtdfke/bTBbxoVeZIxRH9cOY2BqjGmk+Oh9pH+ih+kXwplfJNnk+gk3W
pKtTVrgpG71Bgw//G/rrXlD95nzT3VRyPx/Nx7/PDzhDwlu89vlNOz6SJ1fp
pLmRCLkprSjszIdxwbvT5VQ/592sEeR786HaYfHlF9X/AzclK7qS+Li03epl
rxOJ6DknZuvT+Qji3NYZpPJji1eRwZM8PjhWnjcGTpAIsrVovPKCj2yRn0Ed
VP5Iq4W2rfnKB23+fJWLdlQ93muTpjOo+fPKVtjYUve/eJ3d2F8+1GWkO1WO
knjCq/5dw+Gjf7fMz9pDJEwaJskTUpOgS69oqdpHYmSbmebu1ZNoEv/uep7K
w9uPk3w0lSbx6bvut1VWJBgJWjPztk5ipCXB+CSVpz5O50RzDkyie7bBvcKE
qhfB3+v64idR+EeF6a5HYre3+qnm1EnIVNWFNFN5PdYfmP8iexJzn2bQ1HRI
7PgsoxH2bBItcq8+NFN535p2gFBtnUTmxnrfrg0k5m1vOuImOYXrF9e60+Wo
/PIpiiJjp8DkRScS00wsqNFpCkqZQraX9mc7LhNlYjXzlmZNQdr8i/+5cSYW
Z3y5qPNsCrV5irru1Pfu7fvxE0HtU6D7OFT/bWFCWX6LtqTMNFbt060upr6f
zPdljK3Z0yDu2Dt8NWPirtTOlU0F07j645dbpCETJg7v9tuWUt6oHqC1g4l0
zvemK/XT+N4p/tZZnQlr+emnjf3TeKEQftlYiolSH4Qd3TCDr95ux2cZIwiQ
f6se+HwG40oLfS67jeDPnKLd/VUzuDvnY/UcpxHs/pV6cl/DDP588FW+ZDeC
Fek+qUodM3jYYXJ8r8UIXqxSozXzZ7BrhZ3yjY0jYC2PZcjtmMUY/9uxVeQw
3CSORdW8nYXLnMxkTddhbJgJYAueEiA4Hkt+eu0cQv7J82eZbgLE45iRnqO6
Q1D77Nj73V2AKOtR+qCrPgTlLPO2p74CRG7yfsvfskNYYyZd6hwqQHw1ZH3q
4g1CMuGpV1OuADFjIr4tsnAQ/H8GWTG9AsTFipzDXdT/Zr3doXE5xzlEvktt
MKOhH+r3zrQHeAoSIqlbbGxKe2FoVX3k2YW5xK6GZS9U7/6GWo9lrVrwPOLC
3TcHVRUYuLDwvN692/OJ2a/7TIsiO3CisNl6MFqIAMN8s1X8f1D85/Renwxh
QoYWwxY5/g5D0Z0DnjnChOQ2J733W9+hmGV148JDYWKerEpd9oJ32F6hXXam
WJhIFgweTKlogo25kIJjjTDR0+HkkCDdhKun7nP2dgsTq5npbV/aG/Aju/2e
qrwIkVzede67Ux3iZA2Hf94XIVySu8Wd3lWj9H2/T322CHF2QkT+T141vvlF
CRY9ECEyq18t8Q+uhlz7N6nrRSLE4pIXL9n61ciPOm+gWi1CGNV1b1xe9hp1
AmmJ3gwRojJu6K/yv1Xgd/P0JVbTCG7AkXCnQ+VYFZP2nitPIwakpMVeS5eD
gNHBbkUa0f38fJjF9zKEpES7PdtAI57M0ouF7csgaaOUeHQHjWj5VLRnyOUl
/qm1Gcq1oxHWCTIZ4cHPcSz3cQJxl0YcUtCVP99fAiH9MZnAdBpx21yFlZVf
goJvmpmvsmhEfsz5Iin3EvDFyx7rFtCISqFo6TJOMW57vm3QrKQR192Dqsdp
xWjQ7+ArM2hE3ohGsoHuE2z6IWi/SIFOmCR6W8yNf4A2L6MeS2U6kf8gqcFI
7QECJEJP31pPJwwvFL4TrslDk4G4r6gWnbB11g6kj+bC8YFUzHxjOhE6WjxL
35+DJO/1b3gn6UTf375GnmYmBBYdUOp+RCeihUalp/KScT5r6fKvj+lEQ+Iv
9qE5yeje2irysYROLCx+qRN35A7e/msz8LKcTjB8eRlpEkkIy7cuiHlHJ+Rm
1J4tvR6PxSaWGvqDdMI3MP7b8YRoKASaIF1VlCCWzOPmXg5AnGP6gyQ1UeK1
aMJ+PssfQjn1cpGbKS9Ylvpc7iL63hsL+uqKEnKExVnbZk/8D/rMMek=
      "]], 
     LineBox[CompressedData["
1:eJwVlHs4lOkbx8ep1Mz7znSkUinSSeu4UQ7dS1Rs5bQUu5EkJMQQaSNpJiqG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      "]], LineBox[CompressedData["
1:eJwVU3k4Vesa52Kbh7WWqZKkDGVomx3h/VKhiMw6IWmSTCkludIpJam21I5t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      "]], 
     LineBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAA7C8afRfkE0BAxl6eSrSTP46px6c3
5hNAqAoErEqHkz/SnCL9d+oTQFj4Md5wLJM/dBbQJ5jsE0CwJ+Hhl/6SP5/T
fjKt7xNAQHJobJ67kj+6CSt92PATQNCXKPIPopI/XIPYp/jyE0A4DZLiYXOS
P/78hdIY9RNA8AGqsW1Ekj+gdjP9OPcTQFgAR9MzFZI/QvDgJ1n5E0CAGwS8
tOWRPzPX3s+N+xNACLmVICO0kT9sYHoydf0TQLgFreceiZE/9FZmEnH/E0DY
nuLPEVyRPwREPtJoAxRAWLwVy0cBkT8iHu5RWAsUQDD8ozL/SJA/YNJNUTcb
FEAgeZ6l55uNP9o6DVD1OhRAsMYm2KNhhz/QC4xNcXoUQADPogc4zHM/fL+W
Jnx8FECgTqGxh+RyP2LkAAm+fhRAoA80Pt3jcT+sULtm5IAUQAB0zjPb7nA/
zOaEUl2DFECAavEU3KhvPz4pMCIxhRRAAL3spXUGbj+Ilep/V4cUQMCnnG1D
GWw/Gm5fO6SLFECAyQKW1TtoP2TaGZnKjRRAQI9liKRLZj8QjiRy1Y8UQMDQ
cbVfc2Q/J7TCJg==
      "]], LineBox[CompressedData["
1:eJwVU3k4ldsbPU2ukLidb391k4yFaEIq0qtUKlODyFUpMpSQIkk6ZioyJpRz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      "]], 
     LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAeLkO1jgQGEDAJn38vsltP26uE93P
ERhAgArYfP2WcD9iShqR7hMYQEB1fgI13XI/KvjFK7sXGEDAWygwV/p2PzL/
Za4HGBhAYNkBHLdNdz8MGKsXAhoYQGBzOa6Cd3k/wEk16vYdGECgt2/2RNV9
PyitSY/gJRhA4HmIVsRcgz/4c3LZszUYQBDfNdbLkow/mgHEbVpVGED4z8GK
4yOYP3QaCddUVxhA6PAEM9vImD9OM05AT1kYQECuYJ+vbpk/AmXYEkRdGEA4
h3MT77yaP2vI7LctZRhAmMAaZ8pjnT88jxUCAXUYQHSzww+AbaE/3RxnlqeU
GECs9g/m1DenP1YlPOXclhhAWNpq82Ojpz/QLRE0EpkYQJTrpyl9D6g/wj67
0XydGECgETgBTumoP6hgDw1SphhAdCLzzGijqj9ypLeD/LcYQByXy018Ma4/
BywIcVHbGEDKNczrYtqyP4A03b+G3RhAaCKnVsMYsz/6PLIOvN8YQJiKK/9n
V7M/7E1crCbkGEBKBEjZfdWzP9JvsOf77BhAKsLCUNrUtD+cs1hepv4YQNq0
6jpK4LY/FbwtrdsAGUBCpKM76CK3P47EAvwQAxlAIi27lclltz+B1ayZewcZ
QFiS4hFW7Lc/ZvcA1VAQGUA4t2U7lPy4P+D/1SOGEhlALj2dGktBuT9ZCKty
uxQZQDg5tMJEhrk/TBlVECYZGUCE2j8fABG6P8UhKl9bGxlAVgDKq8FWuj8+
Kv+tkB0ZQOamXrHFnLo/uDLU/MUfGUCagT4bDOO6PzE7qUv7IRlAEntZ1JQp
uz9L+Qq2
      "]], 
     LineBox[{{4.90216758940559, 0.024390463964157783`}, {4.904243420664441, 
      0.024259195568309466`}, {4.912546745699848, 0.023721404094810605`}, {
      4.929153395770664, 0.022585818631786825`}, {4.931229227029515, 
      0.02243834635832026}, {4.933305058288368, 0.022289664364760486`}, {
      4.937456720806072, 0.021988693222054823`}, {4.939532552064923, 
      0.021836415194977005`}, {4.941608383323775, 0.021682949691724518`}, {
      4.9436842145826265`, 0.021528302392562065`}}], 
     LineBox[{{4.88140927681707, 0.025631897991377023`}, {4.883485108075922, 
      0.02551365251331275}, {4.887636770593625, 0.025273198392994828`}, {
      4.895940095629033, 0.024776561304027694`}, {4.898015926887885, 
      0.02464915156513134}}], 
     LineBox[{{4.9478358771003315`, 0.021215485364920045`}, {
      4.949911708359183, 0.021057327233988288`}, {4.954063370876886, 
      0.020737541085602745`}, {4.962366695912294, 0.02008425654753107}, {
      4.964442527171146, 0.0199181140962289}, {4.9665183584299974`, 
      0.019750855441408227`}, {4.968594189688849, 0.01958248682566327}}], 
     LineBox[{{3.407417087057614, 0.004041257584458002}, {3.409254328043592, 
      0.0035516566790310955`}, {3.4109803676014705`, 0.003094341336063955}}], 
     LineBox[{{3.436619549045254, -0.003397643303039377}, {
      3.4383600931372333`, -0.0038180041103628715`}, {
      3.4422279688971855`, -0.00474292496304049}}], 
     LineBox[{{5.151065043662154, 0.001292765550888697}, {5.152849601794186, 
      0.00108914108339353}}]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1nc0lv0fB3Ak26N6NJT9oJKKR0Wh95VKhWiIhlJIixIZKckoOyOzjCiV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      "]], LineBox[CompressedData["
1:eJwVUHs81HkXnvBJ5vudyUq9EqVN6pUupi0Vy3EJoVzKvcQQQpOE2F4xwsRW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      "]], 
     LineBox[CompressedData["
1:eJwVVHk41Wkb1mEsFb/3SCUt1hpaPoXWwfPgjC17NFRjPdasEcpyDh2c5Vep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      "]], LineBox[CompressedData["
1:eJwVU3s4ldkaV/Z23+y9Prru9m66sJ95VFJDjLI4UdlC7kmoJJEYo0hmR/b+
vkU0dMqQMsQYOePyyBg5pleqye3EMJHLGEMZlQwl1EnOOn+sZz3v895+7+99
f58cjnQ/ulhNTe04ff//wxlhkLJJhDMeD/SmehwEdrnQZ7JZhN0cJbdTWwPg
rk3PHWWrCG8L2RLiYBEEbbIMrPgPjRetjN1rfQjOPpf4L3klwh9OTY/eY6Ng
t7z4gPXfInxiiC3/VvcLMCzbcCBgSoSDExw6e77+AsqjbPyK39J8n7oAl6xo
GJrd72vxUYSjzguYiasx4KBxxdPbAGGSI13Rcy4OUKjYM16EsFaF2vqmuTgY
bC70yGMQzr4CUwNRZyAuvcp9dCnCGR1fqoID4qHUsMPt9GqE1cTNizM2JoDB
Wt29WZsR3h361eNL+edgQHnJuW4Lwvkr1R5J+YlQMrrcefAzhONeSZZEWiWC
falMbmxN84vZ7Oj8RIjZ7Linxp7GTz0Xjx5Lgl7bJIduD2qXb93s3n8eigu0
HN57UbyM86eMZjJEq2fslPjS/MN6k5bmyaD3MO8fIf4Ie358tamETYYdLvV2
M8EIj3VZ5anLlFDoP7t9yWmEfd248R/lKvD8/OfXRnEIt1kKJufDVKCxIvl7
o3iEh369YVWRooKwHn2RkQJhM7lvndMDFZi7Gz9lWITXdV6e3/cZC0/NxrMZ
gnDiNK+ow5WFLIOqvUwqwrzvIoxvHWfhfdv2n9BF2u+on1tBLguNu7xSRVkI
V4aOLEZzLMQYr7QVZSMc7OBn9a2AA2P+n2+EVxF29p1tv7CGg9TGEweFeQjf
f3vHJMmJA5sCcyTMp/WecLPkIAcT5+Z+MbiBcNGR2p0TkRy4b1eaGRQj3DDb
ndd+iQOe2OmZfgnC4y829ToVclDz3uCqfinC25JaXn5yi4MVtbnq+uUID/zL
TjrcwUFb1qFaQSXCptLstJZBDhSnTCIEVXRfX5mEC8Y5GDa/1a1XQ/c/1m9b
wCNwWXTmgl4t5du/sWDKgIDj5A6sV4fwtehjzrkrCMw94r3Vraf82igWrq8j
UFrWclP3DsXz7Kbi3QYC/mkZAboNCM+NKDLLLAjoh3szuo2UX6RUr9tBoGGP
uEnnPp2nfkuRxJFAtGw4QecXyselD479zgTWaZZs1mmi+2Xt7/3tTqD7WcSo
dgvCetcDpw/4EiD3t+Rqt9F+N4puSw8SsC5856r9CGFl1/4Z60MExpOAp91B
8YZCZlkwgbwg1W2tTopnqX5s7DECbrbyk1q/IVwbH3sl+ziBRRLRWq1uqo8j
xkPCcAJVH7p7NJ8gvExs6zJE7eD+a2mafQhXf/NHn8YJAkvqDttpDiBsqJKq
lNTflC2b0RhEuMNH6LY/jEB87ESpxhDFY/GzvSqUgKl3daDGMMIlPZ+GaoUQ
GNwab6jxFGGx3Kd9+DCBDAY380cRDiqzumAYSMD+NV/BH0NY1ny36rofgemO
VnP+C3o/N3qCFF4Eiisy/+KNI2wz6Vdd40rA96LPNd4EwpcT13Q47iGgE7Fq
H2+Sxqf8t2+jPYF6+Qif95rWHylZOGlNYLV2ZKT6DOWD7+E1J6PzC1zE72YR
Fua4746REhgWbmieeEfxHeEVuhoRKFz2ck3fPMJprJNi/QIHSnFLe/sC1c8/
/c6tfsNB8OqbCQ8WMdi5XfT87Ci9d9mx7ko+g+POyKVerRxomjomF2syWM3P
LqWrnoOxTevNrmkzmLg3Zt0q4+Cm5UgKJ2DwE62XH3PSOTDdFbg9wIjBMTFW
Ch1HDgTyHS88ljI4dNUPR/PNqT5cVn2zZzmDTa9UoFwJBxXe/ZNbVzFYmfo+
s2GaBfMQnyLd9Qyd92Fdbw4LKMxi3yITikcokhcmsfAmwujjjIzBtZX7vnsc
ykL1qS6fYVMG2wxJPpym+rdUuere3spg/0r/zvqHKliWsrG23ILBUZXnrX4v
VcFcmuBo0TYGD1gR5/B0FdRdbr3ztQ2Ds6dKTbrcVGBTtCs6ZCeDZTV/7HrW
oQT7e7a9jCed16+6sq4mGdY+lLDa3gweizqbIMhMBl7rvPmCD62X+aNlX1gy
POj8d9qLA7Se3aP5p+Jk2D1sie8eof0bAheexJ8Hl0Vm35/8ksHrtuWk60uT
YDL+918vnqJ+vyaT9FeJ8D8t9vqU
      "]], LineBox[CompressedData["
1:eJwVVXk4Vd0bRaIkJefcI1MyZEiokEL79SVTSEWpJJ+UL1Myh2S+7kCG615S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      "]], 
     LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAFipY2sOUGEB8DNQU0e2CP1YlPOXc
lhhAzN0i+aonhD/QLRE0EpkYQORy/ymGdYU/wj670XydGECQEb0N/huIP6hg
Dw1SphhAqE+rdCSUjT9ypLeD/LcYQHiY74VYmZQ/sp+bjhW6GEAmIshpulGV
P2S1YSFnvBhASh21bHIflj/evTZwnL4YQI720f9A5ZY/kNP8Au7AGED0vMWl
7raXP9DO4A0HwxhAzqXvVGR2mD9K17VcPMUYQAqRhzS6QZk/POhf+qbJGEAC
liMC8d2aPwcsCHFR2xhASt4tiHzMoD+ANN2/ht0YQPf1Dn9cPKE/+jyyDrzf
GEBM4j0jK62hP+xNXKwm5BhAkYYoBZWRoj/Sb7Dn++wYQCMqyJmeZaQ/nLNY
Xqb+GECa6L/SmzqoPxW8La3bABlAOJ5MT3K5qD+OxAL8EAMZQDTY35E4Oak/
gdWsmXsHGUC2ZZRTlDuqP2b3ANVQEBlAiVzWnodLrD/g/9UjhhIZQIF+pTPb
0aw/WQircrsUGUAIUM0eHlmtP0wZVRAmGRlAnL4UjnFqrj/FISpfWxsZQGy8
jNaB9K4/Pir/rZAdGUDy2w3+gH+vP7gy1PzFHxlA5pcScLcFsD8xO6lL+yEZ
QHDN3KolTLA/8Mjc9A==
      "]], 
     LineBox[{{4.88140927681707, -0.007473640118534124}, {
      4.883485108075922, -0.007370233220016259}, {
      4.887636770593625, -0.0071605965054472726`}, {
      4.895940095629033, -0.006730345275236027}, {
      4.929153395770664, -0.004876798307038896}, {
      4.931229227029515, -0.004754644125633006}}], 
     LineBox[{{5.055735899895955, 0.0032784775393248228`}, {
      5.0575764186930545`, 0.003399340790784168}, {5.059513806900528, 
      0.003526361335698471}, {5.061451195108001, 0.003653160169741582}, {
      5.063388583315474, 0.003779724530961197}}], 
     LineBox[{{3.3011838289031097`, 0.0032806621453038906`}, {
      3.302841733648193, 0.0028527172618987226`}}], 
     LineBox[{{3.2738284006092204`, 0.010914874800282463`}, {
      3.2759007815405754`, 0.010298336084131325`}, {3.284190305265996, 
      0.00789513785341859}, {3.286262686197351, 0.007310015267913916}}], 
     LineBox[{{5.067263359730418, 0.004032098805384107}, {5.069297617348266, 
      0.00416416504879564}, {5.071138136145365, 0.0042833821511685235`}, {
      5.073075524352838, 0.004408582876368901}, {5.075012912560311, 
      0.004533472666242477}}], 
     LineBox[{{4.972745852206554, -0.00218993993195115}, {
      4.9748216834654055`, -0.0020566960876936755`}, {
      4.978973345983109, -0.001789106751649401}, {
      4.98104917724196, -0.0016547906137758493`}}], 
     LineBox[{{4.868954289263959, -0.008073636596532312}, {
      4.871030120522811, -0.007976124342682314}, {
      4.873105951781662, -0.007877603210419859}, {
      4.875181783040514, -0.007778083627975524}, {
      4.877257614299365, -0.0076775761343976096`}}], 
     LineBox[{{4.93538088954722, -0.004508353705784358}, {
      4.937456720806072, -0.004384244006204633}, {
      4.939532552064923, -0.0042595091382994915`}, {
      4.941608383323775, -0.004134162568010406}, {
      4.9436842145826265`, -0.004008217837718247}}], 
     LineBox[{{3.290407448060062, 0.0061584921684019606`}, {3.292479828991417,
       0.005592064938541419}, {3.294552209922772, 0.00503184239876428}}], 
     LineBox[{{4.947939668663274, -0.003748218697138792}, {
      4.949911708359183, -0.003626931231675474}, {
      4.951987539618035, -0.003498730771315895}, {
      4.954167162439829, -0.003363550831562555}, {
      4.956139202135738, -0.003240755793057104}}], 
     LineBox[{{5.078887688975255, 0.004782268588098472}, {5.080825077182729, 
      0.00490614932228614}, {5.082762465390202, 0.005029668327677697}, {
      5.084699853597675, 0.005152812938307338}, {5.086637241805148, 
      0.005275570503291745}}], 
     LineBox[{{5.044305309471866, 0.0025243015176257128`}, {
      5.0459520894482175`, 0.00263327643084409}, {5.047889477655691, 
      0.0027613591797983894`}, {5.050020604683912, 0.0029020820921267596`}, {
      5.051764254070637, 0.003017076539855598}}], 
     LineBox[{{4.985200839759665, -0.0013851891763816473`}, {
      4.987276671018517, -0.0012499335397591106`}, {
      4.989041127588541, -0.001134742820652592}, {
      4.990712171751918, -0.0010254699488155238`}}], 
     LineBox[{{3.337795323378473, -0.0052685903289836945`}, {
      3.3416631991384254`, -0.0060634595182401906`}}], 
     LineBox[{{4.997807992492518, -0.000559687778149371}, {
      4.999454772468869, -0.0004512221471003573}, {
      5.0012952912659685`, -0.0003298509118984036}, {
      5.002312420074896, -0.000262715403849742}}], 
     LineBox[{{5.015050747539027, 0.0005810329290065093}, {5.016891266336126, 
      0.000703276405227821}}], 
     LineBox[{{3.3455310748983775`, -0.006838070760751047}, {
      3.347465012778354, -0.007217818275461488}}], 
     LineBox[{{5.036943234283472, 0.0020361565497687695`}, {5.038202536618327,
       0.0021197492292984906`}, {5.0401399248258, 0.00224828496979595}}], 
     LineBox[{{5.02125038980294, 0.000992988913695425}, {5.022703430958543, 
      0.001089600010209614}, {5.0242533415245205`, 0.0011926641335685637`}}], 
     LineBox[{{4.960290864653443, -0.0029807755774563863`}, {
      4.962055321223467, -0.0028697044308543494`}}], 
     LineBox[{{3.331855066687166, -0.0040081108995441705`}, {
      3.333927447618521, -0.004453341714176121}}]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1nc0lv0fB3Ak26N6NJT9oJKKR0Wh95VKhWiIhlJIixIZKckoOyOzjCiV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      "]], LineBox[CompressedData["
1:eJwVUHs81HkXnvBJ5vudyUq9EqVN6pUupi0Vy3EJoVzKvcQQQpOE2F4xwsRW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      "]], 
     LineBox[CompressedData["
1:eJwVVHk41Wkb1mEsFb/3SCUt1hpaPoXWwfPgjC17NFRjPdasEcpyDh2c5Vep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      "]], LineBox[CompressedData["
1:eJwVU3s4ldkaV/Z23+y9Prru9m66sJ95VFJDjLI4UdlC7kmoJJEYo0hmR/b+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      "]], LineBox[CompressedData["
1:eJwVVXk4Vd0bRaIkJefcI1MyZEiokEL79SVTSEWpJJ+UL1Myh2S+7kCG615S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      "]], 
     LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAFipY2sOUGEB8DNQU0e2CP1YlPOXc
lhhAzN0i+aonhD/QLRE0EpkYQORy/ymGdYU/wj670XydGECQEb0N/huIP6hg
Dw1SphhAqE+rdCSUjT9ypLeD/LcYQHiY74VYmZQ/sp+bjhW6GEAmIshpulGV
P2S1YSFnvBhASh21bHIflj/evTZwnL4YQI720f9A5ZY/kNP8Au7AGED0vMWl
7raXP9DO4A0HwxhAzqXvVGR2mD9K17VcPMUYQAqRhzS6QZk/POhf+qbJGEAC
liMC8d2aPwcsCHFR2xhASt4tiHzMoD+ANN2/ht0YQPf1Dn9cPKE/+jyyDrzf
GEBM4j0jK62hP+xNXKwm5BhAkYYoBZWRoj/Sb7Dn++wYQCMqyJmeZaQ/nLNY
Xqb+GECa6L/SmzqoPxW8La3bABlAOJ5MT3K5qD+OxAL8EAMZQDTY35E4Oak/
gdWsmXsHGUC2ZZRTlDuqP2b3ANVQEBlAiVzWnodLrD/g/9UjhhIZQIF+pTPb
0aw/WQircrsUGUAIUM0eHlmtP0wZVRAmGRlAnL4UjnFqrj/FISpfWxsZQGy8
jNaB9K4/Pir/rZAdGUDy2w3+gH+vP7gy1PzFHxlA5pcScLcFsD8xO6lL+yEZ
QHDN3KolTLA/8Mjc9A==
      "]], 
     LineBox[{{4.88140927681707, -0.007473640118534124}, {
      4.883485108075922, -0.007370233220016259}, {
      4.887636770593625, -0.0071605965054472726`}, {
      4.895940095629033, -0.006730345275236027}, {
      4.929153395770664, -0.004876798307038896}, {
      4.931229227029515, -0.004754644125633006}}], 
     LineBox[{{5.055735899895955, 0.0032784775393248228`}, {
      5.0575764186930545`, 0.003399340790784168}, {5.059513806900528, 
      0.003526361335698471}, {5.061451195108001, 0.003653160169741582}, {
      5.063388583315474, 0.003779724530961197}}], 
     LineBox[{{3.3011838289031097`, 0.0032806621453038906`}, {
      3.302841733648193, 0.0028527172618987226`}}], 
     LineBox[{{3.2738284006092204`, 0.010914874800282463`}, {
      3.2759007815405754`, 0.010298336084131325`}, {3.284190305265996, 
      0.00789513785341859}, {3.286262686197351, 0.007310015267913916}}], 
     LineBox[{{5.067263359730418, 0.004032098805384107}, {5.069297617348266, 
      0.00416416504879564}, {5.071138136145365, 0.0042833821511685235`}, {
      5.073075524352838, 0.004408582876368901}, {5.075012912560311, 
      0.004533472666242477}}], 
     LineBox[{{4.972745852206554, -0.00218993993195115}, {
      4.9748216834654055`, -0.0020566960876936755`}, {
      4.978973345983109, -0.001789106751649401}, {
      4.98104917724196, -0.0016547906137758493`}}], 
     LineBox[{{4.868954289263959, -0.008073636596532312}, {
      4.871030120522811, -0.007976124342682314}, {
      4.873105951781662, -0.007877603210419859}, {
      4.875181783040514, -0.007778083627975524}, {
      4.877257614299365, -0.0076775761343976096`}}], 
     LineBox[{{4.93538088954722, -0.004508353705784358}, {
      4.937456720806072, -0.004384244006204633}, {
      4.939532552064923, -0.0042595091382994915`}, {
      4.941608383323775, -0.004134162568010406}, {
      4.9436842145826265`, -0.004008217837718247}}], 
     LineBox[{{3.290407448060062, 0.0061584921684019606`}, {3.292479828991417,
       0.005592064938541419}, {3.294552209922772, 0.00503184239876428}}], 
     LineBox[{{4.947939668663274, -0.003748218697138792}, {
      4.949911708359183, -0.003626931231675474}, {
      4.951987539618035, -0.003498730771315895}, {
      4.954167162439829, -0.003363550831562555}, {
      4.956139202135738, -0.003240755793057104}}], 
     LineBox[{{5.078887688975255, 0.004782268588098472}, {5.080825077182729, 
      0.00490614932228614}, {5.082762465390202, 0.005029668327677697}, {
      5.084699853597675, 0.005152812938307338}, {5.086637241805148, 
      0.005275570503291745}}], 
     LineBox[{{5.044305309471866, 0.0025243015176257128`}, {
      5.0459520894482175`, 0.00263327643084409}, {5.047889477655691, 
      0.0027613591797983894`}, {5.050020604683912, 0.0029020820921267596`}, {
      5.051764254070637, 0.003017076539855598}}], 
     LineBox[{{4.985200839759665, -0.0013851891763816473`}, {
      4.987276671018517, -0.0012499335397591106`}, {
      4.989041127588541, -0.001134742820652592}, {
      4.990712171751918, -0.0010254699488155238`}}], 
     LineBox[{{3.337795323378473, -0.0052685903289836945`}, {
      3.3416631991384254`, -0.0060634595182401906`}}], 
     LineBox[{{4.997807992492518, -0.000559687778149371}, {
      4.999454772468869, -0.0004512221471003573}, {
      5.0012952912659685`, -0.0003298509118984036}, {
      5.002312420074896, -0.000262715403849742}}], 
     LineBox[{{5.015050747539027, 0.0005810329290065093}, {5.016891266336126, 
      0.000703276405227821}}], 
     LineBox[{{3.3455310748983775`, -0.006838070760751047}, {
      3.347465012778354, -0.007217818275461488}}], 
     LineBox[{{5.036943234283472, 0.0020361565497687695`}, {5.038202536618327,
       0.0021197492292984906`}, {5.0401399248258, 0.00224828496979595}}], 
     LineBox[{{5.02125038980294, 0.000992988913695425}, {5.022703430958543, 
      0.001089600010209614}, {5.0242533415245205`, 0.0011926641335685637`}}], 
     LineBox[{{4.960290864653443, -0.0029807755774563863`}, {
      4.962055321223467, -0.0028697044308543494`}}], 
     LineBox[{{3.331855066687166, -0.0040081108995441705`}, {
      3.333927447618521, -0.004453341714176121}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.04115885950119892, 1.030516312743753}}, {{
     0, 6.283185307179586}, {-0.04115885950119892, 1.030516312743753}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.65399461374361*^9, 3.6549484834084797`*^9, 3.6549485548749247`*^9, 
   3.655554064078704*^9, 3.65555410094699*^9, 3.6555546202039623`*^9, 
   3.655558060238863*^9, 3.656350115169125*^9, 3.684450230737939*^9, {
   3.684450428922514*^9, 3.684450457346353*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[10] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}, {3.6844504355412197`*^9, 3.684450448716207*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF1nk0VW3UAHBDcc1ESWaFQoMpKrUPhUSmlBIvIW+DKYSUSN5knqIkZJbI
EJJkigwhilQi83jvPcY7mb7zre9bzvlnr986Z63nnGc/e+8jbe9mfpWFiYlJ
iZmJ6X8jay1n56j6gxOUmv+LUjuk5CTibUF1XHNQDIvLAzHGv+LcYKF9+8Ee
LA5pt45UxAVAPNPuqxlY7PUcL8iOiwbfCyzvzmGxK2JRICUuDbIEb504H5sG
Z5P8Gp/FFcG5W055dyKLIEKyJiUxrhbuGqkdFL9fCzNUtg1tzy7QL/h5lFO3
CzTXYk3fuv8Ei+RjstW/+qB18OJDlt1DsKDW9OE0cRAQHYuVHPsxMFNON24i
jIKVu8Fc+aUp0C1KXDYQmIAaaYWgumwi8K4F7XtNmwJGx1GXlxVEqBj0ElZn
nQZ1P8OLgc1E2N7bxl/JMw0F35wPINNEsCxbFHklMw3JD4t+1yqRYPLHbzUN
o2nwHVdTrX1LgtmVWwTm1GlQfQVjH+vJIJbacl1DawYsnilkDrjOAb/7yU9P
7WeBfaTApdp7DmZOfRB8f2MWqhQPaibfnwOPdEr9d49ZkKpV7bgYNQdlycMH
l4NmgTSuRf1eOAd+59hEpzJm4ZGqiWEbcQ4QgaaAiOFZqOz0XKy4MQ8GCafs
Gy4R4eZOyscEj3mwVKJ95LpCBAl738defvPwpKb3mPE1IgQv3xNXCZsHuVaO
pzXeRDATe6Rf+GoeDtpFPzeKJ8LM9WfJmVPz4J1rdV7sCxFEt348GeO0ANVa
XsT76iTokb2zVcRtAbIchgI8tUgQpafenO6zANTdS/W2J0nA8rjwzNvHC6BO
UT0jaUaCKc5Usx/5CyB7JljtqDMJKvgDbMXQBZA8XPxp4CUJW1/7bp7PIpC/
rYx2spKB8/ialnLgIhS/yHhVzkGGRpv36+8fL0Lm3fDReD4yaKYpB31JWoTw
y76Fh0XJICEjE0r+sAg/DyXd3K5CBqI861M1piUYm+qQP/wPGUJUm0rrHi+B
9Bv3PnoRGX7o3zWojFmCgaMHLvuVkWGPtfJQ0bMlkNo7rb1YSYaG4BSetLwl
qHw4rdqJ5XG99/Y1/5YlSCi+H773Oxm8feUkjhKWgfg+eJfrEhmaIv6UKfMv
A/sdhbNeNDIIpccZ7tu5DGyfF7o9VslQ2rruu3PvMrh0UjoubkGBvKvvO0V/
GSbLQ71aBFFw+hgS+jZkGc4asuepK6NQ3n1c6nX0Mlw0VwirU0Nhy8RiRcbT
ZUj0u1d0UhOFDF67sdjcZUg/p1anAigM2mqCe/MyDJcSRt4aoXCBZXpJiZ0C
xq/0XbWdUMjekRa+h48C8v18kqbXUVhSOC8jJkwB+z/rWy2dUYg7V2/CJU+B
3jfmnmc9UOjMSsqf1qOAop/+uz/+KOjqn7HLeUQBPxlXveB4FEzmHPtuR1Fg
yv6NHEciCpeSAox1Eynw5PCuwEfPUHCZLdMay6aA6eiOFzdSUEiIlhSRaaLA
yqjvtZ85KKRpHo2Zb6dAX8MAs/QrFF4NW7DX91Dgzp1hPvvXKHxUDVu2HaPA
GdX0kI4iFMb7lrpTWKnQQLvWZ1CJAhrIZ+DCRYUiKUn2C1Uo0Pcp1GkJUmGX
p1WuVTUKPPds3/TLUOEX5bbG2ToU1KXawkR0qGDEdiy0rxmF/66lnUwIpELC
3+qYwF4UogWqqhwfU0HsPUu8YB8KSVU9ymoxVLAPXFpP/YlCITen1Pc0Khyr
c9yW1o9Cb7HXKn8tFW7mJIufGkbh76Voz6HPVOiatHR4PoLCNEv+TFEnFWZR
Jv7pURTWLP7+NB7EvPvPC7cJFGTpBuURa1RwU3O/Jz2LwsEMRyXrrTQY3wnz
R4koHDEMyFTkocH2e0VtRiQUzqaUxbaJ0eDT41v5l1AULPW+Ep7voUGqpF6x
xRwKV9DpgOtKNODlbxA5PY/CbW1JV4IWDdi/tO7YuYhCwMyR8b6TNBDbOvlq
CXNovIV1riENqD6daa1LKKSMh57Ru4w9/0flrTUFhdyorPrtDjR4XmfStYuK
QolGreb4DRq0NnqbdGNuCl2SC/ajQTaHhqc8HYUfHAYJa0E0SHkYb9KDeSI0
hdUnnAbmAcmqvgwUqBwLt+biacDFKi0puIICIUxv6PoLGhgl0QSyMe/kTDYe
zaLBoCmd68AqCvvC0GrrQhr8qV7lfoP5TNizJJMaGtx8cn93/BoKVpwk9tbP
NFCortakYb4Zpu2t85UGLfz+FhbrKNzjTBz70EeDqA/Z3rmYI8JmzNWHaGBy
QzJtHvMLTqh/M0UDF5PeDpUNLL9h8Qf3zmPrSZez3MRcwzmVkk6ngZJ40fHn
mDvDtLhFWegQwVxxvw7zIGes3xNOOrQJ1jYNYEbDxqd4BOlwWbxh2wJmJq6j
liGimJ3fX13DzB8e1cS0hw5R39NrNjBLc42q+inRwSHfT5yOWSVcI2NRjQ5z
7bpB05h1uCL4XY7TgZ7MTurCfC586P6ELh0mVj/bFGF25FIn2RrT4fOlyJ5g
zF7hoZd/XaCDcbqTmRnm/7gGW81t6dCtd6VHCHNiuIpm+790OKETZfMV+/4c
rpAcXXc6iPMzkwIxvwvvF6r1pcOjkq9B+zC3cB16qPkAu1+wTbIV29+f4cHz
JaF04OUcr7fFPMX1y1Yxjg7rlxxvkrD80MP3d2Y9pwOhqFjUAzMnd5CWRCYd
Kl4Sv5Gw/O6K+JH/9DUdFs4cj7XDrMCtKCJQRofVs20X2rDzcSwiICSsmg6O
nR93K2K2jtjr6N9Bh0+ukT3dNBScuf2/UXrpMOXcVimM2T+iG3EfpENR1sFs
C+w8pkb4iTugdLBSMH36dhmF4Yj2H6cFGMB9Jnhy6wIKC9zSug0iDDinFiG4
BasPlsjbb4/JMOBuVKUBHaunPZESMQdUGdDnUdDbgtWbU6S7gdB5Buj/7PRa
nULBm6fpXaQNA3j/q2CUTqIQEikix+7EAK4K20g7rJ7zIhtYGN4MEJr0+v0S
q/eZSKHqv88Y4DeWL1ExgEIMs8NG80sGFBT+UkH+oHD4dolOcR4D2top9xt+
oxBkbdwaWMmAnf0edUVY/xFRfPxD+icDjiNii0rd2HlM/SHCOcSABA+rbt+v
WP63ydosTDKASs+eqe5AoZheP9pAZcCJpJ1d+9tQON2yMucgvAIGhrUepQ3Y
vDl2Rs1IcgUO8L5Rr8P64ZOiZz5q8itwJVFH43MNCkOJ6utbNFYg/NBZWhXW
T32uunHlXFiBJdmxAP1S7LywjMpOJayA2bCCKCkNBSNv5etdKSsg8V8IWwDW
3xemAwoqs1dg+YjcEY5kFE50i6mGlq8AlSXemw2bD71pFxCF3hUY+e7pkBWO
zbPjbVbOQqvgvr0zwfU21r98SqLn4lZhssDppPZJFHgbjrQFJa+CmfbE/ifY
fKvibtiyPWsVIr0rpQaPobAt49udI+WrsHciabclNh8b2xcdgvpWgb25sXpg
Dwp7ZQ5rComtQYT5Z80T2LxF26uGNLLXoN/hUI1FNRleCJ8UbStcA/f8maWw
d2Q4bf/lvHXFGjwPYb5cWUqGl9T+tsDmNXCr7aqi5ZHBXGatrHV6DSwrLOb4
EshQ4QOhlw+sw/Zz6t5JN8ngL9OoHPBuHUo7ToXv3kaGMeYSo+nadbhCaJT9
h5sMRsMp/55rWYfupY/uMWxk2PXSJ0X+1zps/R4t8YdBgkpxRY4uxjo0Vu1n
5x8lwdLOuCGpExtgzhgPmC0hgTOfXXRD4waElwfs9jcgwYF1fwrLdSbkfFXO
UU87IhT8e8sVdWZC2AfufjyA/f8pdjtO9LszIQT7ONdRMyLszTL8UebLhMRT
Q+01TxJB+oxIhdNjJiS4RvFTjCwRhBLLbrflMiGOfX201alZYOyfXYqdYEKA
d0i4C/s/bba5uCjlyIxkekV6dVjNQEvplJP9NWbEwmCMWcZsBtrY7/zOdGZG
tozUi7npz0BnSVK93G1m5NQMD9ui6gz0bO2PVnrEjKx36i2lc8/ASKGNkmYe
M3I4fEtJavU0rK7ZXzUhMiO6O2pz5IWnQTnVpc/fiwX5Wj7KJvFuEk6Z1VuV
e7Ai2T+uUd3/joHiuEmT4qMtSK5b2MWHrsPgwX9LK/XJVoTLinND9X4/OLzp
Mp+NYUPOPU3Z0XqgB+T23zT1yWBH7phOyHn2NAMxZnDGK4cdIXnIm5QlNEPp
ktl/HvnsyD1TziT0QjMcr9ascillRx7qHOqy+PUZLAzZ9jg2sCOKWvkP+gea
4MH1dKrpCDvCl3Y6c3L8E/zJ7ktVkCEg7t2p17rHaiGDw/DIXjkCwrKNv3+n
Uy1cc6n5LqtAQIhhdv4XJ2tgUS2bIK1CQDTKWr/WTX8EzkYPD2EdAvJNw1Ty
CPkDaI7w6G2xJyAhZZlcY8vvIF7iFGkgnYCUZH4KZGIuhor2aZ/mbAIiI5VH
FiYUwW+/aJaSV9j6nEQ3ed43INX3Wzi4hICwu1HFlXcVQEH0LR2FegKSzKdS
uqycB5+Z0p56DxGQTpsGfl+7lzD95pSM3RgBaYnLi7nWngrcNjMFBlMEJDpZ
PeNX3ws49169QWyOgKAxjuG55GcwdKud2LBBQAwv2kRtiMYCq5SHTwErB6LQ
w2H+xDgK5DqFWRLZOZCnv3/py1wNAxcFB+HrfByIysyailJcEMT8JGSYC3Ig
X2wKeC3M/KHs0RslLWEOpK/Itez0/dvQp2bxTlaUA8k/8czZ/cJNYIzQtfkk
ORCpPq2OWDtLEI9Na6fJcCBM/38hoGs5IofbkTQz/EUBd0hyjHP5Adz5Boep
qSq4O6n9Dx4fxi1kIf/08gncGiwd0ro6uK2KPQoO6OF+yV1Tz2yMe3+TBTHX
BrepJ8M79gpuL+mXzHev4q7yn91h7IJb73CQ9tI93Ha5RYnIC9xs2gtiAS9x
F/5Wy/yYhZvBU1V0tBD3E6/GFrUa3C3avxh7h3Af+sNiK7CHc9NMAhfkR17j
NiAdtfznFdemHfOtXEWquTc9vM4d19XKg7/f5zUL+ybeTW+47NtQ+cGH70ej
wR63G/ybNhM//VVnEnf1xCip3FVg03enJax3kHBnWlOP7/DetmkpDjc3Vgpu
Y+ZDua6egpsevx5lfmcFdxdXxNlbfkKblpWQryZs2b5phXtcyhLhuIMFo5el
OHZsWl+0eP+nWNz/WLuXmwsIb1pu+s5JuyjclhNSujw7dm56QOzfxNwnuC/I
ao3/ScTdtV9AbVsS7oYTH7rvpeDOs+PjMc/B7ZH17uHqO9zsSoRbZv24A9UG
ah8N4GZolfJW/8VNPGtdIDeG+5tb8eQKEfeLtxf/yVnHvb16f2E/k8imoxpZ
VvlZcT/oLUi6y47bicrUa8qPe2ijd/ejbbgvEV57fBDCbSRynl9OBHeTtILt
ZVHcJxQ2CmPEcVeq9Kw2SeJWPvbKcEUa9/8ANplQIA==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwV1nk4Vdv/B/BzxOUYbioNGkxFvmgQSknvTaVIg0aJW5lCFJUhEkmDKUMy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      "]], LineBox[CompressedData["
1:eJwVUns01HkctXmMzPdXUnmkoieWjldFJZ/PUjaPJTkaqcg0kxSzmPkNpVYi
hm0tpZgSGZ1Ewo5H8s6q1uRkEsWmduhhtWvqoEXrsbN/3PM5n3PP5957Pueu
Yn+/hztPTU3NR4X/p772jcMafUysmjYxstrkD02KjOMD/UzU3dhrrZ/KAmnw
CMtqgInh29pzcpcGQtFr9x0x75gYW6fzsC37AOQevGnTOszEiqi1PZ4Lg6H/
bPRXcUom6kx4T0v7D0HS/uD5AaNM7FDoaNcrQyD/zthQ3z9MNFwy1pxrfhh4
+wwHR74wcfKT5hpD4AC7V/DEcY6Jvb9nPT4RxIW9rKd1ieoEJ0eSOX0xRyCy
mCvW1CZ4oE5kfDcnFJz90y4aEYJbvcYKrXKOQvzJvZwuXYK9Ikvuq9owMPdz
DS9fQpCdo8fxzT8Gy7vyA74YEsxifJjbKj4OGvIA24xVKn3NdTdYJyLg+WPZ
YL0dQc2qsGdsQSTIPMw6tRwIigUZhbV9kdDcnljvu40gN254Qea2KLj1yClr
yJWg8Y9ys8rxKMh1E5+x20XQ4X2RYtQzGjIffA4/7UUwQ1TpXpAfDSd/Ldu5
2J/gip26mk5OfOC5MO2C9hE8zt2SvvocHw7fD11ZfJBgXvs++3AZHwKwTWc8
hGCkxaS/ARGAV7PphPMRgjcuWvSu9hAAOp9+k3qMYImLwDg9SQAbG/s6u3kE
FzYXzQXUC8DcaXODCZ+ggi4ZSFQKwDVddqUghuBukfcfLFMa9LZ+zKqOI1jx
VHpqxp0GrXueCWpnCM57VODvE03DF4dbEZ5JBG1yk8MY2TQoazQCL4sITl84
xDevpWFwU4jbwHmC5uBaWN1Dw4uqRjurTII7Zl/nSj/S0GG/zCTmEsFhHzXh
Gi0htEiFzFYxwXgbrWpiJIQq22cTJI+gXYmPD99cCMUV1m9ZEoKsZ9eLDmwU
Qp71ebnkJsF8Tvz5J05CuFD2Z8NICUGJacrmzm+EkLxhZ7FjOcFFjjVuXFch
xJUWXEqsJKir/KUtW8VHWs4mPLlLcOiq+gqe6p5TEsgzalDtQd4mn+yFUMMf
9tjdQlDjRZiYo/LX3h5rltJGcNfnycxKVb5ALYZG028EY2cun3jHEEJp5yXF
eAfBBUkG+upjNMzmrG20fEqwUOPhmaUvadjNrhSzewjqzbu+dn0LDRJLF6G4
T/XvD6kNzhIaxsfle+SvCPaN/OAblkCDW1OwNWOQYMhUvWPFQRpyUpRM5/eq
Pi94v2ilAw1Oy8iD20qV3yNOwpUBAaS/uVIwOEowvcmsrlkqAEWpxQ9GEwSt
Wt+s25IggET41iFljmDp7DVpgL4AurWfL25Sp3B+g/Npg1d8WN/F+TTOoLBM
ZCvbX8AHGedsMVuXwkb2YPOt1XzQS2s0dl5FoWV7uUg2Pxr82l9rwToKbb/W
65m9HwU1y19237agcNO5FodTkVEQWD75k5EdhVny0H9tOiNB0m2v9tmFQq+r
Bmrjf/OgK3VoqtmNwv6IPEtPDx64hfreY3tSeM2+wnQmPgI+TPGi5X4UTjM0
JR1a4WBnUvL2NofCFHlanmTsKLSGmbazkyn0vqOolnHZMLqyu3VDGoVu37X4
pUpC4Mj09rPydApja+v/+ll6CGofdAQxLlK4RBQzl1IWDFMaSnftbAoVy2fq
DUgQ/AfY9SjJ
      "]], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAASAGQ7cGCDkD4+Erpwchpvz2UQeR9
hg5AauWZ7QQlar9aV00rbIoOQDx8EMKigmq/nkqzwoyODkDM9l1HCuFqv5Pd
ZLlIkg5AHh6kd/4ya7+IcBawBJYOQFIc8RWkgWu/DOVNyrebDkAwh/vBQ/Nr
v+kmiI4Tng5AYgTBbwAgbL8irZ8c8KUOQHQyVW5tq2y/PnCrY96pDkAG48fJ
hOtsv4NjEfv+rQ5AiJk4IcMqbb949sLxurEOQPTmpDllYG2/LAijZeSzDkBs
7Neo4n1tv9isNNDJuQ5AsC0hxnvIbb/NP+bGhb0OQLpfG2FP822/6gLyDXTB
DkAwHxEUrxxuvwbG/VRixQ5AgHt08kBCbr+mdKaXpckOQCoChT+yZm6/RiNP
2ujNDkASg0iEqoZuv+bR9xws0g5AsvgTvCqibr+GgKBfb9YOQLhW+ng0uW6/
Ji9JorLaDkCm697iyctuv8bd8eT13g5AIpB2tu3Zbr/welYHzOIOQMQfpqXd
4m6/N/5QZUDnDkBLYB40wehuvzyyx74=
      "]], 
     LineBox[{{3.9692864567056865`, -0.0015710152247024214`}, {
      3.9712638000114, -0.001499850890797902}, {
      3.972512648415009, -0.0014546441418640962`}, {
      3.9754266280234276`, -0.0013484346337866476`}, {
      3.9772999006288403`, -0.0012796620170290656`}, {
      3.9803666444173085`, -0.0011663311987194277`}, {
      3.98153242699009, -0.0011230317522493934`}, {
      3.9822124668242127`, -0.0010977230875255603`}, {
      3.986195557281213, -0.0009488224439984797}, {
      3.9873613398539947`, -0.0009050547083150886}, {
      3.989012865165434, -0.0008429303516042639}, {
      3.9905769567839164`, -0.0007839824990883999}}], LineBox[CompressedData["

1:eJwVk2s4lAkUx2lVa2k7T1vJpSjZ2la3TasS5yTbhEgqdxrjnZmXbV1SuUUU
TYqwRDQVuYQoK6rVRqnQJJNlRKXLg3STUDtItW8fznOe85zz4X9+539mCwIc
heNUVFScuPia5wWMyDcuB3rj0vHrD77OmJAWaapjCnSvoGT8Z3sXnKkxdP6v
FUB83f8cHs9wxW1pCzwWmQGtvlq7LGSjG0ouzPAsWQ3EqJXIX09wx5iYaXae
FkDr6+4VG7a6Y19xTf11AtJ7VuQVPOCByRKX9quWQJdDY2OOdHiihxpzKccK
6Ng836bici88lXjcZxYPKDDe1t1Ztg3rS+IZ6XqgqsxkS7EpH8ei9a5k2gAt
MH3iPzmXj9sKsucwG4CiRpcuH1X1Rnn07Sel9kCfH8zq3RPqjdJPrdUpDkA2
8sWLVdq9sblZPC3JEeiA1Y0rC1YJ0ET5eo/rFiAnXrqDOFmAq8MTa+OdgBoY
S0cNpQCD7A20JS5Abeviw85t8kHzOz8P+7lxPF4+jRPm+2Bp/pbKCg+gCWkD
itSJDMKddr29XkDfFubeHd7EYCev+6OAD3RUqdAxOslgtyxuTaoAKKbp5jGb
IQbLeCkGIQxQll+X4KdVQoy8Kf3iJgL640FLRHyUEGN5Fr8dZoEejD39mCQT
osNN67kBfhxvgc7dcHURKg61RFhvB+p2+zR41kqEVhtoy2x/INfHMwq0IkWo
bV3xITWQu5ciNmDZTRE+LRrxWr0DqLP8Qt7jAW4+N7908U4gkblynqqRGCXy
4CGz3UAa8tGCImcxaqZ/spkeCpRdkj+zaZ8YA5OKMtXDufk2s/igUjG2Htz6
YiwCqDf6UeBKhRi1Kg0XqUcBvf3ebsOLj2KURpTGde0FAgwwM9ZjUWWXa2tb
DFDQzKZyRzMWGf/xhrL9QEtIX57mzOKZrBa2LQ6oo6LLds4OFo29Pa+VSTg/
WO69KJKwmOymPjkvHujFToPy91ksvt9c6ZlxGKhCK/tC1lkWw3SwMiiR80vV
LN+qyyyGl2x6eT4JqLBMSbq3WDSgv62DUoBaFHMTZzayGLtSeIxJ5fSF7v9g
1Myiukp/v8VRIPvBp3xsYVGYXKIcyQCqSWI707l+mZFvrEUmUL9it/3zJhan
6k9rWXqc+5fTWRZMA4uZPScXaJ4A8gwI4R2p4fQUt2z1OQXkSD/2XCxjkTS0
azRygOS6UvWqXBbz1G5N+nIaKOD22r7WFBbz0++vMc/n+Hx3aXddGIvblXpn
ewqAPujEvjohZPHeu4aR9kIgTetRpy22LJq82rm+sRjo+tsOf94iFkOmrz3S
XgLUyO+R/avJ4tijxp7yc0DG+pIk5Wsx8ttCTQrKOD2Jq2xr6sTYIx2XEF0O
VNy57ktvthgnjg025Fd83dcidcYOMSbU7jGIvgj0u3efny5PjO+uzA8Ivgwk
nJLz1kFLjLv2ldfZVQFVZ9yqOdArwoxnp78J/gcoxSlD7lAqQr1CY3e7ao7P
+XeS9FARRue0F9E1IJ+FeSsLLUQIkoPdkxqATr6USYsshLgz2mSZqgxovre+
9MYwgyPrqg89vANkaONsZ17BYIfGUOUvTUA5m3OM6t0YzN6+Qv+hHCjB6bBO
hDaDSxxfuBbe5/xndGB0b7MA02zTCo93cP+Q0LnJK1yAw1akPPIQaKDO0tFq
tgAjNWT2vp1AzmFT2xQybwxMmPIk9zFQ35+29anJ3pinWB84/IzjfbT4k2o/
H41uOGmd6eJqcycle5yPbwyl0Rt7gBaGha6p5fFR6024WulzoFfpUXsGVfn4
P+TIapk=
      "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAWD1ZwQFvEUAkK9Gn0d5ev8fSnG+v
cBFA9KwZNBtzX782aOAdXXIRQKwAtndEAmC/zMcdhL90EUBM/ShOEGdgv4Tt
PMjndhFA8tiERK+/YL/zgoB2lXgRQE4YT5zpAmG/lopAa1x6EUAaiI57bUhh
v3E/6wa7fBFAjsvDK2iiYb8UR6v7gX4RQJwZ1srU42G/HzNkfXuAEUDgvR2c
bCpiv/asoLhbghFALuok9mlrYr9SttgKiYQRQGRkZUpFtGK/dGkLSYGGEUAq
A2/6yPNiv0vjR4RhiBFAjouDrSAuY79WzwAGW4oRQKSlJvlAaWO/Ybu5h1SM
EUCWq5XEAqJjv9SLa5aAjhFAYlYrGK7dY793kyuLR5ARQBiN0NlTDGS/Tg1o
xieSEUAS17ZkbTtkv8HdGdVTlBFAYOK0lTJvZL+YV1YQNJYRQNg+zlqAmWS/
O18WBfuXEUDWtPm9gb9kv64vyBMnmhFA9iQb8jPrZL/EBzoXGp4RQPSjn2nT
MmW/z/PymBOgEUDInJ340lJlv6ZtL9TzoRFABpD5fNpuZb8ZPuHiH6QRQMar
17hpjGW/8LcdHgCmEUCu/0uZbqNlv/uj1p/5pxFA8ta0TyS5Zb8GkI8h86kR
QDaU5HFCzGW/EXxIo+yrEUDrO0OMx9xlv+j1hN7MrRFAT9VRKBDqZb+mNfSE

      "]], 
     LineBox[{{4.47219254881534, -0.0023886398327869584`}, {
      4.473913605771376, -0.002364661817837155}, {
      4.475745543147549, -0.002338205520742708}, {
      4.477673898280363, -0.0023093294387436254`}, {
      4.481530608545991, -0.0022484722258979007`}, {
      4.483621055626664, -0.002213789256423514}, {
      4.4857115027073355`, -0.002177938554682527}, {
      4.489892396868681, -0.0021028154609930697`}, {
      4.4916692768872535`, -0.002069539402252172}, {
      4.494073291030026, -0.002023271711152991}, {
      4.496163738110699, -0.0019818972862266546`}, {
      4.498672274607504, -0.0019308800859986197`}, {
      4.500344632272043, -0.0018960584546414668`}, {
      4.502644124060782, -0.0018471464550899367`}, {
      4.5045255264333885`, -0.0018062591806295562`}, {
      4.5070340629301935`, -0.0017505608062662013`}, {
      4.508706420594733, -0.0017126978318062326`}, {
      4.510692345321373, -0.0016669975225785754`}}], LineBox[CompressedData["
1:eJwVkntQ1AUQx48m0xMFXIlxEpCnhwRCoGgS7DKOcQji8cxSznv87iwJrkDg
FIIzOWEEJjNBwHAOguOljDicogcMIRCPJGK4Q714BlSOaYEoUGi//tjZ2b/2
8304ShSRstc4HM4edv7fcvlNE0qBhpetHD6tDMbA8Jag5wzQ4oCjeb97CNr4
dVRflQP97vpbZ2/Dfmxo5ZaZPgYqzlNzhkvCcLu2Nl+ZAKQK5Z+JChOgcJ2t
1j0RSHL6lSq3WIABu8RYpwBS9udYDfhH4Es4ft8/CSjDJfnrEUEkGpcVgXPJ
QB7vHO35bHUU6lx1I5+nACXVOGl6qqJw9PE3uV5KoGhNSJPhbjS+8daZ6jdP
AbnlkL1HTgxqCy97T6UD8es1NmaBsejKu1TR/gWQt1ed4OJSLGptOitaVSxv
ktzrgMMhnHgRrA3+Eoizs607W3cIVckiL+tsIJeG5sQK8Yfo8FTZPKFm9Yha
CnaZf4S6ROXoUi6Q7cEZJW/bYSyyvHFg4zmgE13HkpvyD6NfXp9xPA+o81t+
FuN5BHW23fy2AqCm8BZO3M9HcGfcQzOP80Atk/zawfI4FJ7rdYAL7D8ff1/r
ICFaffKVYcNFVk/ZrVq7GSFen64WjhUCbRJNT6tTjuLKyN/D7sVAZ61N8+3W
Ity6anLeqhRoLEAy7hwnwm7VUsboZZZ3cTzaQiPCfbDwRF8GxExZPDb8KsKu
SG7NNg3Q1ETJ8O53xfgka7HbsgJIXmI0M5wUo0bYlm5ZCXQ+Y8OzTr0Y6aHx
9V+qWL3Pv/fctyDGgnsO6W41QOHbX3Hffk+CN5ctSy3qgLR/lATlnJBgbKqb
s6keqOHpDo1FjQQNq10Kb18DWjaNlVeZJBjD3x3Ouw5UxMOxxs1SzEzhJay/
wfr1yC+JCZWid/SfjuubgKbTBu5EpEtx8KdV9Q90QFeyZApFpRTt7h503NoM
NHsyeq+7UYrv/xVI6+4A+bzIH3jwrxRn4z/ova8Hsk9Vx2RsYVC2Eul/qxUo
8sfGIlEQgzMBx565tAOFrST1+R1n0CI+dqN5B9DVtPqh0hwG20Nse9Z2AmW+
XB60r2RQ1LUjYqSLzXdiIU6rZ/Bac+YPzj1sX+e4dh1GBo0zCbPcPqChUMei
7x4xmCo+qzD2s/xbYn2E/zC4MHd6sukeUKVTo++FtTJM8S0qdRpk+xxjNs/Z
LMMrIvXtNUPsnVZescdVhgIMTVwzzPqxeGqTylOGcm6BWG8AmhuP12f7yPA/
6yuYNw==
      "]], 
     LineBox[{{4.736441071726692, 0.0024974373706128155`}, {4.738295475554521,
       0.002482757886998206}, {4.7402474795838145`, 0.002466161506471014}, {
      4.74196984496371, 0.002450548861699901}, {4.743864446881593, 
      0.002432332945372961}}], LineBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAA3oPahnD1FUAFtds+bAFmvzyS7JFo
9xVAm6zn7DlzZr9r8kQHEfoVQHpC2NYyCWe/9q4QqFj7FUC1Nzw53k9nv1S9
IrNQ/RVAkes3hpa6Z78O2kbJQAEWQFn6AkKJiGi/hBOP9SAJFkAjlXpu5gRq
v2sdgYPxChZAdqdRg0xWar/CG1AHZg0WQMBkYo6PwGq/CdiuRskOFkAMBN9L
n/pqv2j3tWzGERZAoakwYa1ya78fqPGhzRMWQHZ6Wn8vwGu/PizSKvAVFkBj
xCB8QA5sv3w0kzw1GhZAaVTPGFOfbL8z5c5xPBwWQOoHkX733my/ujxUTnoe
FkB7wumFSSFtv2nMV+H4HxZA5TPkliBLbb/4RBVgvyIWQKxgs166k22/r/VQ
lcYkFkCKzDPEicRtvzZN1nEEJxZAj9QwokP2bb9W0bb6JikWQLBso+F0IW6/
TR0ZzQgsFkBLtQvhPlVuv5TZdwxsLRZAR9lN03trbr+0XViVji8WQPwZ8eo9
im6/aw6UypUxFkBhvzJGjqNuv5hDP0SaMxZAzo+7ce64br95vZ6DETYWQH9+
BHfdzW6/MG7auBg4FkBh1kzdxdpuv0/yukE7OhZAvrCKNSHkbr8OxC4ZyzwW
QKljg7GY6W6/jfp7U4A+FkCeq/0ru+luv6x+XNyiQBZA/hn6we7lbr/7W/O9
jkIWQISp2kO73m6/eG41GX9GFkCGN1WNt8RuvwkL/nYKRxZAiKC3m+2/br8o
j97/LEkWQBi91CxYqm6/RxO/iE9LFkDotJogSZBuv3J7FDg=
      "]], 
     LineBox[{{3.2655388768837996`, -0.007565728925811525}, {
      3.2676112578151546`, -0.007786052540000341}, {
      3.2696836387465096`, -0.007995650719868854}}], LineBox[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAA4jfVCM6zCkC01HYMCBSEv8P2FGYu
tgpANrgCaYL/g7/EXlTqubsKQGGqyrDxy4O/g06kAVK8CkDikORyHsaDv6aF
08ulwwpAyM4wNKF5g78YGZO8m8cKQJQ/EubLTIO/82UCvSTOCkDhZdDWrf2C
v/o/Ep6HzwpAYN6jcBjsgr9s09GOfdMKQNtjyLVauIK/TvpQcGnbCkDXdckL
aEqCvxJITzNB6wpApFJtrmdWgb9f5i6/0e4KQAJ9mzxkG4G/9G7OFC3zCkBG
f/UqWdGAv9aVTfYY+wpARZmcUZRFgL//Pk0dRP4KQPzEAebmC4C/uLzM1wQD
C0DlBnBjLGd/vypQjMj6BgtAF3T3ztDQfr+/2CseVgsLQJGhTixAKH6/DHcL
quYOC0CZwtBO+Jt9v34Ky5rcEgtAO2mHSrj9fL9gMUp8yBoLQJaTy5cnunu/
P8qZuoseC0AnHz9mYB17v0JYyV20IgtAMeYNNvJter//ISlWryQLQNS2ndWm
GXq/bo/4JwgqC0Au02PwwTN5v//Ltz8pMQtAhgWS62b8d78GpscgjDILQB8m
htJEv3e/6MxGAng6C0AaFFSPmV52v8dllkA7PgtAdaUz70K1db9c7jWWlkIL
QPOLgLXi73S/PIeF1FlGC0CMrsQGaER0vz8VtXeCSgtAvKJR0+SFc78ergS2
RU4LQKi9A/u72HK/kEHEpjtSC0AphDckwCFyv3JoQ4gnWgtAywY6hQCycL82
tkFL/2kLQOKh+iRhnGu/X19BciptC0AUVhpE7XNqvxjdwCzrcQtAMMd+emC3
aL/4dRBrrnULQO5WHSy9V2e/H/kfczx6C0DC5nsgq65lv2yX//7MfQtAMKKM
taBiZL9MME89kIELQGiQ8SnkBGO/DuU7JQ==
      "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAA36ywRwP9DkDVA0tF6sBuv8RSN/oP
AQ9AX78f9hetbr9kAeA8UwUPQG8B5VYWlG6/BLCIf5YJD0BBeu9v3XZuv6Re
McLZDQ9AqMfRDnZVbr9EDdoEHRIPQPfYCoXpL26/5LuCR2AWD0DN3TqmQQZu
v4RqK4qjGg9ARkJKxojYbb9pELI8sB4PQPUzk8NeqW2//6TyxPAiD0CN6acE
+3Ntvx9/R+KjJw9AzSvBfWo0bb8DJc6UsCsPQDBXWefa+Wy/otN21/MvD0DX
JkLueLhsv0KCHxo3NA9ACYhSA05zbL+C33CfvTwPQHLptT7U3Wu/Io4Z4gBB
D0A+QU7toY1rv8I8wiRERQ9Anb75td85a78CmhOqyk0PQGul7zXph2q/5z+a
XNdRD0CMXio9nS5qv0L3ZC9RVg9A244q72/Iab+CVLa0114PQEG+4Cb5+2i/
IgNf9xpjD0Ce7W7tCZFov8KxBzpeZw9AzVd05Q8jaL9iYLB8oWsPQAnQwkgd
sme/vBd7TxtwD0D6YnepZjhnv6C9AQIodA9ASmzxzZjHZr9AbKpEa3gPQAqm
s/AsTma/gMn7yfGAD0Dt7E0jY1NlvwCEntT+kQ9ASc/GOjhAY7+gMkcXQpYP
QB7tlgq7tWK/QOHvWYWaD0CmWU9qICliv+CPmJzIng9A7sVsrn2aYb87R2Nv
QqMPQKSTNP2gAmG/IO3pIU+nD0AKnkAgdndgv0qKTkQlqw9AFr5Kc0bkX7+q
UwAN
      "]], 
     LineBox[{{4.769283689279864, 0.0020869524055302877`}, {4.77115436945636, 
      0.002054515497121748}, {4.772781047870706, 0.0020255791618928416`}, {
      4.7746947871817, 0.0019906797071297137`}, {4.7766085264926925`, 
      0.0019548687088573966`}, {4.778617952769236, 0.0019163033898157442`}, {
      4.78043600511468, 0.0018805756218187386`}, {4.782349744425673, 
      0.0018421262904150647`}, {4.784072109805568, 0.001806798034494424}, {
      4.785966711723452, 0.0017671605052325002`}}], 
     LineBox[{{4.895940095629033, -0.0012162765844160434`}, {
      4.898015926887885, -0.0012705570642629006`}}], 
     LineBox[{{3.298696971785483, -0.00987832574088751}, {
      3.300769352716838, -0.00994318353671835}, {
      3.302841733648193, -0.009999513529867662}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAcZ6o8OuzEUC9zBGPCwVmv0gY5SvM
tRFASj4CsUsIZr9TBJ6txbcRQJLBP9csCWa/XvBWL7+5EUBzGhcncwdmv5kT
HpdTuxFASNS/SzIEZr90yMgysr0RQGCMPkoz/GW/f7SBtKu/EUAsox7er/Jl
v1Yuvu+LwRFAk9Wdn0HnZb+bcHyFusMRQLJSeHgJ12W/CF2lxsrFEUAQaJQF
0cRlv6tkZbuRxxFAwkEZZeOyZb+2UB49i8kRQNkpRVGNnGW/wTzXvoTLEUBq
8PJcr4Nlv8wokEB+zRFAPlQ0Fk1oZb/XFEnCd88RQKYXvlNqSmW/ro6F/VfR
EUBPj42buCtlvyFfNwyE0xFADpm1qGUFZb/42HNHZNURQDyS1L/p4WS/A8Us
yV3XEUAYBPQLMbpkvw6x5UpX2RFA+7WsPA+QZL+xuKU/HtsRQFNvE+sYaGS/
HqXOgC7dEUCM1bBeSjdkv3nPpWY=
      "]], 
     LineBox[{{5.4762276613690375`, -0.002278097024621538}, {
      5.478246572373973, -0.002342252815680731}, {
      5.480073206140343, -0.002399453727752943}}], 
     LineBox[{{5.594706959249085, -0.00348386561999566}, {
      5.596479093932569, -0.0034532407687629142`}, {
      5.598563958266079, -0.003415269801243948}, {
      5.602222895171391, -0.003343586464644551}, {
      5.6027336869331, -0.003333071022045544}, {
      5.604818551266611, -0.003288867110911438}, {
      5.606799172383446, -0.003244972656040672}, {
      5.608878824556123, -0.003196904368861586}, {
      5.611177387483818, -0.0031414362973650363`}, {
      5.613158008600653, -0.0030916869216243157`}, {
      5.6152428729341635`, -0.003037383362914571}}], 
     LineBox[{{4.7500266874629915`, 0.002365632530125378}, {4.751921289380874,
       0.0023428668245276483`}, {4.753643654760769, 0.002321263277108479}, {
      4.755557394071763, 0.00229625538979299}, {4.757184072486109, 
      0.002274175716909123}, {4.759054752662605, 0.002247858812703273}}], 
     LineBox[{{3.2821179243346412`, -0.009035324049735909}, {
      3.284293924312564, -0.009180184237982355}, {
      3.286262686197351, -0.00930207460622224}}], 
     LineBox[{{5.455077165126863, -0.0015561465697815089`}, {
      5.462768254669472, -0.0018279943525215158`}, {
      5.4646910270551246`, -0.0018944545363872617`}}], 
     LineBox[{{3.249477924665798, -0.005480740520565762}, {
      3.251032210364313, -0.005712593004418157}, {
      3.253104591295668, -0.006011494022279363}}], 
     LineBox[{{3.3152760192363244`, -0.010166561821767686`}, {
      3.3173484001676794`, -0.010167284739120637`}, {
      3.3194207810990344`, -0.010160653756154703`}}], 
     LineBox[{{4.720825039492344, 0.0025783115479388764`}, {4.722679443320173,
       0.0025727495453825707`}, {4.724631447349466, 0.0025657103035912924`}, {
      4.72638825097583, 0.0025583388781226677`}, {4.728633055609518, 
      0.00254749591360476}, {4.730487459437347, 0.002537338018678785}, {
      4.732244263063711, 0.0025267167356395545`}}], 
     LineBox[{{4.972745852206554, -0.002603320496620348}, {
      4.9748216834654055`, -0.002618231018518811}, {
      4.976793723161315, -0.002631112733961556}, {
      4.979284720671936, -0.002645585444060959}, {
      4.98104917724196, -0.0026546150727909095`}}], 
     LineBox[{{3.2739320196557884`, -0.00839234296033898}, {
      3.2759007815405754`, -0.008561390225689962}, {
      3.2779731624719304`, -0.008729390505991613}}], 
     LineBox[{{3.7873406131417044`, -0.0023419730924614038`}, {
      3.7899508911407964`, -0.0024343752013900356`}, {
      3.790718619964058, -0.0024610388937840594`}, {
      3.792733908125121, -0.002529903993667053}, {
      3.7945572640803684`, -0.0025907866096731803`}, {
      3.7963806200356163`, -0.0026502968350178525`}}], 
     LineBox[{{4.935837572424168, -0.0021203162450746656`}, {
      4.937664303931957, -0.00215324768729205}, {
      4.939532552064923, -0.002186032089461199}, {
      4.941608383323775, -0.0022213793571184528`}}], 
     LineBox[{{5.577923801364325, -0.0036978568538790857`}, {
      5.579800179264485, -0.0036808019748331474`}, {
      5.58178080038132, -0.0036609186722064563`}, {
      5.583750997176487, -0.0036392244136857757`}, {
      5.586159015481692, -0.0036101173889751086`}, {
      5.588139636598527, -0.00358404308964143}, {
      5.590224500932037, -0.003554520630443347}}], 
     LineBox[{{4.517486298333557, -0.0015048980804903782`}, {
      4.519158655998096, -0.0014637039827393168`}, {
      4.5211445807247355`, -0.0014141612870511447`}, {
      4.522351813913823, -0.001383722786469959}, {
      4.526088488070526, -0.0012880335930529332`}, {
      4.52762496667482, -0.0012480683457057528`}, {
      4.529610891401459, -0.001195905485090655}, {
      4.531283249065998, -0.0011515526227472972`}}], 
     LineBox[{{4.902478964094417, -0.0013850594800548695`}, {
      4.904243420664441, -0.0014294507702124135`}, {
      4.90621546036035, -0.001478444716453004}}], 
     LineBox[{{3.3069864955109036`, -0.010087170057256433`}, {
      3.3090588764422586`, -0.010118788098372834`}, {
      3.3111312573736136`, -0.010142461265941989`}}], 
     LineBox[{{3.290407448060062, -0.009530744337877472}, {
      3.292479828991417, -0.009631147571737424}, {
      3.294552209922772, -0.009722450824061906}}], 
     LineBox[{{3.804249840474054, -0.002890957288251818}, {
      3.8060731964293018`, -0.0029428794767329966`}, {
      3.808088484590365, -0.00299854756908274}, {
      3.8099118405456127`, -0.0030473426204135337`}}], 
     LineBox[{{4.95219512274392, -0.0023832772641454595`}, {
      4.954063370876886, -0.002408545589256831}, {
      4.956139202135738, -0.002435422782568205}}], 
     LineBox[{{5.468536571826428, -0.002025343878777164}, {
      5.470459344212081, -0.002089708337084379}, {
      5.472285977978451, -0.0021501483927617495`}}], 
     LineBox[{{3.257466953156171, -0.006602947494083683}, {
      3.2594253531363018`, -0.006852063079683947}, {
      3.261394115021089, -0.007092395574037956}}], 
     LineBox[{{3.775651941807537, -0.0018966134967177894`}, {
      3.7772833655569693`, -0.001961744626621911}, {
      3.778914789306401, -0.002025941103787488}, {
      3.782743836812423, -0.0021728447559423844`}, {
      3.783041331731436, -0.00218403245561467}}], 
     LineBox[{{4.79212895230485, 0.0016328194076189531`}, {4.794023554222733, 
      0.0015899162006359378`}, {4.795745919602628, 0.0015502879068989613`}, {
      4.797659658913622, 0.001505575727985575}, {4.799573398224615, 
      0.001460166082647099}, {4.801200076638961, 0.0014210344816071039`}}], 
     LineBox[{{3.3235655429617452`, -0.010125925106904595`}, {
      3.3256379238931, -0.010098125633089578`}, {
      3.327710304824455, -0.010063568559052983`}}], 
     LineBox[{{3.7097861881713774`, 0.0012652175659884192`}, {
      3.711298645526884, 0.0011869058874245664`}, {3.713253522380942, 
      0.001085653110994204}, {3.715208399235, 0.0009844075920146167}, {
      3.7175748291109647`, 0.0008619264227886069}, {3.7194268177095458`, 
      0.0007661839562729759}, {3.721278806308127, 0.0006705846006604121}, {
      3.7228632854424686`, 0.0005889381521339875}}], 
     LineBox[{{4.987276671018517, -0.0026783187702610154`}, {
      4.989352502277368, -0.002683373520751259}, {
      4.9913245419732775`, -0.002686850093748765}}], 
     LineBox[{{4.71301702337517, 0.0025896588805766957`}, {4.714871427202999, 
      0.002588733450084894}, {4.716628230829363, 0.002586839203490591}}], 
     LineBox[{{4.96662214999294, -0.0025513547856858415`}, {
      4.968594189688849, -0.0025693807575329153`}}], 
     LineBox[{{4.883485108075922, -0.0008788226472366035}, {
      4.8843154405794635`, -0.0009018737332658538}, {
      4.886972504590792, -0.000975151995608796}}], 
     LineBox[{{4.820624530645544, 0.0009205727922288244}, {4.822538269956537, 
      0.0008684395190983242}}], 
     LineBox[{{4.914783453881261, -0.0016831462912169724`}, {
      4.91784011540992, -0.0017527216268623824`}, {
      4.918774239476404, -0.001773599136671716}, {
      4.920746279172313, -0.0018170660833490555`}}], 
     LineBox[{{5.628586004668631, -0.0026442034679274957`}, {
      5.629836923268737, -0.0026034267628512906`}, {
      5.631817544385572, -0.0025375412126650366`}}], 
     LineBox[{{3.7638481111498803`, -0.0013992040979789047`}, {
      3.7660553315167595`, -0.0014955368816016758`}, {
      3.7676867552661912`, -0.0015657948694224105`}, {
      3.769606077324347, -0.0016473935374388838`}}], 
     LineBox[{{5.619673209642873, -0.0029154849082809638`}, {
      5.622018682018073, -0.0028474245679797434`}, {
      5.6235823302682055`, -0.002800716070015697}}], 
     LineBox[{{4.542258096239527, -0.0008519399007025938}, {
      4.5442440209661665`, -0.0007963510932220788}, {
      4.5459163786307055`, -0.0007492641360562094}, {
      4.548048634652991, -0.0006888903108378802}}], 
     LineBox[{{3.453154717919048, -0.000992229862148468}, {
      3.453831596177042, -0.000933074846903993}, {
      3.454411777541038, -0.0008824792372830589}, {
      3.4573707024973994`, -0.0006260757293242315}}], 
     LineBox[{{5.636091516269269, -0.0023899495579005024`}, {
      5.638280623819455, -0.00231155215081313}, {
      5.6402612449362906`, -0.0022390258160501957`}, {
      5.6422418660531255`, -0.0021650127811713273`}}], 
     LineBox[{{5.449308847969906, -0.0013468790226445451`}, {
      5.4511354817362765`, -0.001413580842479343}}], 
     LineBox[{{4.558877150530874, -0.00037763701686312966`}, {
      4.5600268964252475`, -0.00034424686691859565`}}], 
     LineBox[{{4.841675663066473, 0.0003281612768791843}, {
      4.8420584109286775`, 0.0003170957437330787}}], 
     LineBox[{{5.483918750911647, -0.002517132564532593}, {
      5.4858415232972995`, -0.00257451674583763}}], 
     LineBox[{{5.437772213655993, -0.0009184128483026347}, {
      5.439694986041646, -0.000990519596521939}}], 
     LineBox[{{4.960290864653443, -0.002485332260864526}, {
      4.962262904349352, -0.002507216688726747}}], 
     LineBox[{{3.331855066687166, -0.009974780087645935}, {
      3.333927447618521, -0.009920848189242363}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.010167284739120637`, 1.002589561338965}}, {{
     0, 6.283185307179586}, {-0.010167284739120637`, 1.002589561338965}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, 
   3.655554106709433*^9, 3.655558073305297*^9, 3.656350115469261*^9, 
   3.684450230848481*^9, {3.684450428973*^9, 3.684450457403925*^9}}]
}, Closed]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.655554544265765*^9, 3.655554546831702*^9}}],

Cell["Make  a \"frequency domain\" plot of the coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "\[Pi]"], ",", "0", ",", 
   FractionBox["1", "\[Pi]"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"3", " ", "\[Pi]"}]]}], ",", "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"15", " ", "\[Pi]"}]]}], ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.539348900461853*^9, 3.539349025162924*^9, 3.592056900794857*^9, 
   3.59205693153894*^9, 3.59205709743393*^9, {3.65399455589922*^9, 
   3.653994564692024*^9}, {3.653994603096509*^9, 3.653994613952845*^9}, 
   3.654948610036271*^9, 3.656350115578405*^9, 3.6844502308631573`*^9, {
   3.684450428988092*^9, 3.684450457442504*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"ChartStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Re\>\"", ",", "\"\<Im\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592056964512083*^9, 3.592056985563291*^9}, {
  3.592057062331558*^9, 3.592057071627198*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.3020588235294117, 0}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.616], 
     Thickness[Small]}], 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5404411764705882, 0.}, {1.4595588235294117`, 
            0.3183098861837907}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{43.21943630393334, 
           73.84881748813035}, {-121.65675786475032`, 54.883260961120584`}}],
         StatusArea[#, Pi^(-1)]& ,
         TagBoxNote->"Pi^(-1)"],
        StyleBox[
         FractionBox["1", "\[Pi]"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Pi^(-1), {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.540441176470588, 0.}, {2.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{75.86420303233969, 106.49358421653669`}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5404411764705883`, 0.}, {3.4595588235294117`, 
            0.3183098861837907}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{108.50896976074603`, 
           139.13835094494306`}, {-121.65675786475032`, 54.883260961120584`}}],
         StatusArea[#, Pi^(-1)]& ,
         TagBoxNote->"Pi^(-1)"],
        StyleBox[
         FractionBox["1", "\[Pi]"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Pi^(-1), {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5404411764705883`, 0.}, {4.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{141.15373648915238`, 171.7831176733494}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.540441176470589, 0.}, {
            5.459558823529412, -0.1061032953945969}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{173.79850321755876`, 204.42788440175576`}, {
           54.258260961120584`, 113.52160056974421`}}],
         StatusArea[#, Rational[-1, 3]/Pi]& ,
         TagBoxNote->"-1/(3*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"3", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 3]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.540441176470589, 0.}, {6.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{206.44326994596508`, 237.07265113016211`}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.540441176470589, 0.}, {7.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{239.08803667437144`, 269.7174178585684}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.540441176470589, 0.}, {8.459558823529413, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{271.7328034027778, 302.3621845869748}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.540441176470589, 0.}, {
            9.459558823529413, -0.02122065907891938}, "RoundingRadius" -> 0]},
          
          
          ImageSizeCache->{{304.37757013118414`, 335.0069513153812}, {
           54.258260961120584`, 66.61092888284531}}],
         StatusArea[#, Rational[-1, 15]/Pi]& ,
         TagBoxNote->"-1/(15*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"15", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 15]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{9.540441176470589, 0.}, {10.459558823529413`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{337.0223368595905, 367.6517180437875}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.540441176470589`, 0.}, {11.459558823529413`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{369.66710358799685`, 400.2964847721939}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.540441176470589`, 0.}, {12.459558823529413`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{402.31187031640314`, 432.94125150060023`}, {
           54.258260961120584`, 54.883260961120584`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[
    StyleBox[{
      {Thickness[Tiny], 
       LineBox[{{0.3020588235294117, 0.}, {12.702708823529413`, 0.}}], 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, 
      StyleBox[{
        {Thickness[Tiny], 
         LineBox[{{0.5404411764705882, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {0.5404411764705882, 0.}]}],
          LineBox[{{12.459558823529413`, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {12.459558823529413`, 
            0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
           LineBox[{{1.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.4595588235294117`, 
              0.}]}], LineBox[{{1.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.5404411764705883`, 
              0.}]}], LineBox[{{2.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.4595588235294117`, 
              0.}]}], LineBox[{{2.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.5404411764705883`, 
              0.}]}], LineBox[{{3.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.4595588235294117`, 
              0.}]}], LineBox[{{3.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.5404411764705883`, 
              0.}]}], LineBox[{{4.459558823529412, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.459558823529412, 
              0.}]}], LineBox[{{4.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.540441176470588, 
              0.}]}], LineBox[{{5.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.459558823529411, 
              0.}]}], LineBox[{{5.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.540441176470588, 
              0.}]}], LineBox[{{6.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.459558823529411, 
              0.}]}], LineBox[{{6.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.540441176470588, 
              0.}]}], LineBox[{{7.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.459558823529411, 
              0.}]}], LineBox[{{7.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.540441176470588, 
              0.}]}], 
           LineBox[{{8.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.459558823529413, 
              0.}]}], LineBox[{{8.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.540441176470589, 
              0.}]}], LineBox[{{9.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.459558823529413, 
              0.}]}], LineBox[{{9.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.540441176470589, 
              0.}]}], LineBox[{{10.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.459558823529413`, 
              0.}]}], LineBox[{{10.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.540441176470589`, 
              0.}]}], LineBox[{{11.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.459558823529413`, 
              0.}]}], LineBox[{{11.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.540441176470589`, 
              0.}]}]}, {}}}, 
        StyleBox[
         {Thickness[Tiny], 
          InsetBox["\<\"Re\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
           Automatic, {1, 0}], 
          InsetBox["\<\"Im\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
           Automatic, {1, 0}]}, "GraphicsLabel",
         StripOnInput->False]}, "GraphicsTicks",
       StripOnInput->False]},
     Antialiasing->False], "GraphicsAxes",
    StripOnInput->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.3020588235294117, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
       FormBox["\"Re\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox["\"Im\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.592057072075521*^9, 3.592057097646439*^9}, {
   3.6539945560734167`*^9, 3.653994564849016*^9}, {3.653994603235777*^9, 
   3.653994614082698*^9}, 3.6549486128139677`*^9, 3.6563501157248163`*^9, 
   3.684450230931737*^9, {3.684450429065184*^9, 3.684450457525333*^9}}]
}, Closed]],

Cell["Re-write the Exp series as a Trig series", "Subsection"],

Cell[CellGroupData[{

Cell["term2[0] = term[0] //ExpToTrig //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["1", "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.539348901072105*^9, 3.53934902523506*^9, 3.592056900871686*^9, 
   3.592056931675244*^9, 3.592057097671525*^9, {3.6539945561216993`*^9, 
   3.653994564877943*^9}, {3.653994603372724*^9, 3.653994614166765*^9}, 
   3.654948617597234*^9, 3.656350115762343*^9, 3.684450230941923*^9, {
   3.6844504290773582`*^9, 3.6844504575502567`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["term2[m_]= term[m] //ExpToTrig //FullSimplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "+", 
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", "x"}], "]"}]}], 
  RowBox[{"\[Pi]", "-", 
   RowBox[{
    SuperscriptBox["m", "2"], " ", "\[Pi]"}]}]]], "Output",
 CellChangeTimes->{
  3.539348901338854*^9, 3.539349025465629*^9, 3.592056901077137*^9, 
   3.592056931864159*^9, 3.592057097861994*^9, {3.653994556335165*^9, 
   3.653994565006339*^9}, {3.653994603495202*^9, 3.6539946142942657`*^9}, 
   3.654948620062367*^9, 3.656350115877437*^9, 3.684450231093213*^9, {
   3.68445042922824*^9, 3.684450457690487*^9}}]
}, Closed]],

Cell["series2[n_]:= Sum[ term2[m] ,{m,0,n}] ", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["series[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], "+", 
  FractionBox["1", "\[Pi]"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{"3", " ", "\[Pi]"}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", "x"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"8", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{"15", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348901508812*^9, 3.539349025532612*^9, 3.592056901121194*^9, 
   3.592056931985405*^9, 3.5920570979048*^9, {3.653994556759735*^9, 
   3.6539945651973667`*^9}, {3.653994603566409*^9, 3.6539946143891582`*^9}, 
   3.654948624824272*^9, 3.656350116026599*^9, 3.684450231304532*^9, {
   3.684450429481268*^9, 3.6844504577797956`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["series2[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData["Indeterminate"], "Output",
 CellChangeTimes->{
  3.539348901647589*^9, 3.53934902562461*^9, 3.592056901159855*^9, 
   3.59205693204438*^9, 3.592057097944783*^9, {3.653994556831818*^9, 
   3.653994565364707*^9}, {3.653994603636812*^9, 3.653994614428404*^9}, 
   3.654948626578991*^9, 3.656350116228054*^9, 3.6844502314572277`*^9, {
   3.684450429600506*^9, 3.684450457934084*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"series2", "[", "5", "]"}], " ", "//", "TrigReduce"}]], "Input"],

Cell[BoxData["Indeterminate"], "Output",
 CellChangeTimes->{
  3.539348901716475*^9, 3.539349025693151*^9, 3.592056901169058*^9, 
   3.59205693210773*^9, 3.592057098009361*^9, {3.653994556897757*^9, 
   3.6539945655319557`*^9}, {3.653994603705914*^9, 3.653994614503924*^9}, 
   3.654948629062478*^9, 3.6563501165357122`*^9, 3.6844502316086483`*^9, {
   3.684450429722316*^9, 3.684450458044281*^9}}]
}, Closed]],

Cell["Verify that they are identical", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"series2", "[", "5", "]"}], "-", 
   RowBox[{"series", "[", "5", "]"}]}], " ", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["Indeterminate"], "Output",
 CellChangeTimes->{
  3.656350116672271*^9, 3.6844502317848663`*^9, {3.68445042984564*^9, 
   3.684450458151024*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem 4: f[x_]=...  for x=[0,2 \[Pi]]", "Section",
 CellChangeTimes->{3.539349236841261*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=Exp[-x^2];\
\>", "Input",
 CellChangeTimes->{{3.5393491348382*^9, 3.539349140876157*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349053690878*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVk3c8lu8Xx+09nmlUJFlFw2h8ee77OiiiskUySrJKRlYhoxKSlVlCsrOS
TVYUkhBCS0hKeZA9f373P9fr/TrnOp/Pdc65d1k7G1xiYmBgMGBmYPj/yVzP
1Tl6KBC/svn/j47EBMSkRB9Yod9APby0xfNfonQGY5yRIDYxMLzFTgMcLcRC
LxRFfDRRtcXDqm0j5TH+qCbJ9tKtLc7tO8ZQWHMLwdWHutgWW3NJRjIU3kXq
Y8nZPzfoaAdiFTVMu4eceSadgra479qP/MyYSNT4XOgp7xZr9o6I+DZFIxnT
Ls3QdTrKmDK4lFnzAH1S/mA+v0ZHDJyv8jtL41CE9vKI/hZb7FacWyxIQBay
8p9SVumoGnuqsis7CYUrBGh8XqEjAVPyLe20R4jNhkmKa4u7wv8RH8ekIv/C
QI0jS3QU/+G53GhLGjq5Uybs8CIdNQ87dHk1PUFhF400pRboaNfqoOCTmqfI
gzlM6eM/OtLjiKk5VJmBugpm7BJn6egmVduqvTQTtTQ82q49Q0dDB6qz/hVk
I7n1y9z+U3TEgblph+TlILFfGSeZ/tLREe29Uzuyc9H7yuMUz0k6irV5eEgj
7Rn6+u+T5oEJOjqddKM5MaYIRX3g9ZsYpiPcULg0XrMYLZx6dGz661a/zs6z
fm8pRsUyxNyJz3TEbFeQ69H0HFk0pRg9G6Cj84EiMyk1L5DRRZ8I7/d0tHh3
We3Xf6UoP+lXLOs7OoqI6ItVrCxFWQUGBrfa6aj20f2jraVlyKSmiUG/hY6E
y9f9Zwoq0NG6zIRD1XRUXDvYrSJXiT5nfWo4UUFHJ16V7Q7Oq0Rmgk8aTpXS
kWeX05tt2VXoe5i6sXQhHfX8/sJ3LK0GHbEM0pd+QkfhO+sex8fUI0KcZfeZ
23Sk8faRfANvAxI9MVshGUBHr4NNKYcMGhDlpf/eUR86erPePSj6qQFpnn7Q
tecaHbVONtvM/mlES9wqs+Pn6aj9Td6NJEIzesit4Cn9Hx1p37Kz4DNuRpjv
Ut2I4lYcl4BbSc2Ivr2Lcn8/Hb0te8zqJN6CFlzecRftpqOOp1FRoPQasbWV
79nDS0fv/D2zfpq0olCHogcbn6eQjopiqHlyK5o40ypW1D+FOhfol7uHW1He
dKyJbtcWOznI1zi0IXN/3r+Wr7b4nHlthE87ytzuMVGTM4W6jqj1HErtQA8u
lK16ukyh34tsm6rXupDMyPCV43N/0ebu081HHnShKR8m24g/fxFF70Hovhdd
qPHwolv72F+EcnZShP91IS3NjrntfX9RrOnRPdNu3UhM60OPZNlfhFc5GKa4
9aA6bT6mb25/UfSNjuwV1140EWWVrPzjDzq6Hq33wmUASX3Y02CVM4mUfR0T
OKIGULhPcDRzyiRSWVX7alE0gDAhUZ6UB5MIX/53mWNqAP3+9Veh4uYkUp83
vmtxeRB9UbZt8jGaRDp/hevYbYdQpuj857Mbv9GlL09kzc99Rgc7uqlvT/5G
bV9NbzHtHkaT3307krsmEKgZrWZZj6G6e0s95w1/IDMXremysxOoSuS1LIH+
HdXt2hvUkPkHcfkWcchXfEZGiXuffrk6jdrMFuXCtfoR+0i+U63nNDp02O8Q
r2I/qpY9cPTRzWm06vcEPdzRj8TqFd+ZRkwj2b6+mwP0PvT3B23xQ8E0kpHz
KBiP70PBiron2/9sxc0tEvR/9qLKzmv/yh1n0IN35249jP6AtrO+VI+ynUUN
LNhlR95u1Ct5nVXYeRZFq7k3BS91oQiNQ2+eeM2ipYsWlBejXYgppED7Rcgs
8j1wolKlugtNcKXo9+fNov2jkQ689l2onOBvtYM+i9rDxjIc779H+jtUfXK8
/qGMJKGPumLv0F3FlpKGkDlk0/bdyie7FfVr+mhVRs2hEl3BBLaQViRhLj9c
lDiHXk3z9xfYt6Km2495U3PmkDzblIne3la00edh79c6h9bdxD+PFb5Bnt5S
osoc88hkVn9V4+VrZPvybuiLu/MoetbtauNUMyrrxsSeRc6jNlnfusaeZsQy
/q88PWEejX8h0L6UN6N0vvNj0dnzaDrWP/mSfzP6anUUubyZR7c2K+eqic3o
DNOvOTn2BfRe8Gq1s8ordFxT+3xW8ALarJ5arkpvRLrTNh89IhZQ76/ZsZCw
RnQ2yV/nePwCwva9KHRxa0ROk6W0scwFZJlz6nmYWiOKi9wpLN6ygDzVPyj8
HG1APz7OdT9mXkQjk5M/j8g2oDv2qepxAYuoeHl0pDnhJYokVlfbhCyiA+2f
ly87vURJ1b3ySlGLiKAxU6Gq/hIV8HCJfUhdRBt8eJ03vRb1FbuvEeoXEcmI
uEnUrkWSy1pl4euL6EQAg+kgew1qCZ2Tun1jCVFHjiUvZFSifk6tuPWgJVRb
wBW3068SjYc+Zva6t4Tc8px0fIwrEUeYxrBD8hLqSCu+3M5WibTDEpN065ZQ
zY8U6VeXK1BnGI1nO9MysvOuEF7Hy9HAvdszz0OXEe9p5ZIgzlI0wT1oJRuz
jJpP/Zmp/PkCLd/b15nxcBmxW5mQRV6/QNvC+/MSni0jfs22c1dvvUDm4TI2
fu+WUeR1WsZBhhfoe3hH/wniCjqwYs5MZCpBv+9Tar8lriBPcT8HaaliFMV4
cfNN2grKLrNKKuYuRoc9nqsV56ygwdP3aqpHilCQuU5bQOUK2m1hqKZ2owgJ
y4b07xpYQZEtlmuP8gvRidbV6YuCq2jvDq9/IFqAsphGJSfiVhEb6y5aqGIe
OuUp79D1eBU96t9/hYk9D83+8s+vzFxFB1z1sqqHchHevUMxtGwVcTqYHv0Z
lIv6Us/A3r5V9N/Y7t49/TmIBWs3u0JZQ0d0YL9ISDa64PU8cjpmDXlHK3xj
EspEfE3/tQc9WkPZ4kqkN/QMVM3TxELNWEO7TlyidrzJQKT0nuv/la2hl+y6
RgneGai549/FoI9rKH7zvtLeL0+RjPjho5Qd6+gr+yDLxvN0RO+oHj6SuY5U
B2LbtEPSULKg+vb2gnW08en0ZKxdGjph/dbYvHwddbNFOwlopqG0xU/tAW/W
UcSpV651bGnIQHy9tO3XOkrPFJA7RExF5V4o9Nz+DUSSHKkKlXuM/MSb5f0r
NtAX/pLp6cIkNMb4/NSv+g3kd2QpTtUnCZ36/tjOsHUDLZycVv2jmYS2pXk9
lh7cQLJmB2tOjySiShFZzq6VDfSKqJKluD0RzQnFDIvhmyigaERX7HE8usJ/
PrKpeRPlKqQcVP76APVOncqTe7eJTpuKf/xe+gCpdP7XEt+3iQivH1X03nuA
uO6TVx3HN9H8j3/2D5UfIKM7F19wsjDA0NQzz6RHMWiWSXBniSQDCEbb09ku
R6P9G34LTA4MEGT+5o7n9QiUb+d6lX6FAWIqlYjnaBFItttm/JMLAxhtcpc/
27yPZDJO9pd6MwBzs2N3xN37aJe2cLltCAMYji0KnUwOR5T4Uo/2bAZwcncx
pgyGoZV9k3PR4wxw1OgQdD66i7wTvl65+ZsBinfheXyX76JFhp4xxykGMI3p
icxRvovmPlT2qi8wQLg6W8b4UDD6ez24dJ6VEfJ0qNO+O4PRcMsu97OSjODB
kCeYXHkbvbEw/SdmwwjvTE+mUaSDUGvJhK21PSOEPVVYU18PRO3s14eeXmEE
qLj9oO1DIOp8ntQo5cEIhdpfKH2BgaiX9VOkXDAjHCHdnv38PQCNFFjIHc1h
hPzHWs6W1v5ojGkq9Xo+IwisW/otC/mjHyY3yTXFjGDcYFi3v+smmmBMXcGq
GOHlYMnNi3AT0Y2HW9XbGcGwRX7go7QfWlu3vqT7hxHinK+PbhJ90IbBv4Go
aUboaPhXXtd9A21m3zrVM8cI1gc7WNhjbiAmgwxF4/Utf1pV1IOUG4gz6wfj
OT4m0Ao5HNoqeh0J6Nin2B5kAgvJ6LMqp7yQfIrTRz93JnhpcGCigtEdbfy5
UebpzQTWhvGepN5rqF0l5IGzLxOsVFy6/jbrGrIeTNe9cJsJfM1OHjxz+hqK
pQy8ORbLBLv6KsZrUtzQQphaJXcpE8Qe93x1xMAVNQ3qxrNUMoHSooiX7F5X
FCFj4b5ewwQPEpesrjG5IunXXgfpr5jgavpL6/UXLsiUsSCn5wMTSKnFmP3a
5oKqvQSTkv4xgYgON6sK3QkFv5bwillkgkft+Py2XCdkQFUwvrfKBDk/2gqj
LjqhyZJTRD9mZtj+c4H839AVtGMqMPQ8mRkM7eZ3WXVeRv42f65LKzLDL2a3
emK3Azqm32hW5sYMoTKdpf+O2qLYe5eVmL2YQRV/2yq4eQmNtlD59H2YgSD8
Zryl5RIKUnZs/HOLGQzWCPk1RpdQ426yjEQcM3xgcaj7622D8AWb+ZiKrXpp
kpUeg9Yo4iD/++EaZgiXoSuWZVujL45VOfsbmAG/2K7n5GmNfL/xmre3bvFN
JlN1qjWqaS1vYhxihhrdA1cdTS+go484olzWmGHSm1wR89MKhfSVONQxsMCP
S6rOR2Os0Ed+C3UeVhZ4XXLGvhizQp63ny9k87LAHwODIf4ES1TmZGbxTZQF
WulKeWaGFkgB8vfqqLJArzjm9XDaDMn+0G2RDWaBpKPCn1VLzqABB7nIS2Es
QNc2l+T2OIOCpzjOpkawgNK86y6no2fQ8GLjH1ICC4SfxbrnG4xRLJcSZSV7
Kz9aaH1uwAitHRC62NrGAh6YsXPYbkOUWzonx9TJAmI7RP6q0Q3Qmf+6F1R6
WKCkhqfFv8YAFauFhRUNsQDftHlzoLEBumS89jx+kgWkZdlOB0fqo84bwwyX
eFlh26hh9INteshns7Y9hcgK5HJzI8JnXSRzOyl2gMoKiguRFl9v6aKg+wYy
p0RZwfjQpWSxfh10JK1ZV/EAK1y5Xnmc5c5plNaSk8KozwrfRbm+hnKdRG4E
V1pKLCt8VHM3uJqtgX5HtLtEJrLC1ZFvpjcvayBrXonMgGRWWPtsvk/8oAbS
5/rIezGDFYYT1LjFao6jgyzYN+lSVpj80l/R9fEYmlrkCHr+gRX23/0lQt+r
jmw9rcvTP7KC23EzwcxFNfR1rub3g0+s8EDl5cFPzWro3cxVQ89RVshyK973
6rwayp/slVD5xwrj/q011imqyPFb2ptmEhs8f9rMMXkA0IjFymqZABtkyrPT
tsaKzD4bHszexgbWFy4GBTxHSGuQLSlUnA1aeM08ktgQkvlwxVFHgQ2Erh64
+LEaQ+Ovj/IO6LPBuS+vjvdpqaCLhV0Gk1FscP52o/rh+cPIUuhNkHwcG/A9
dpK4VHwYmQW9LPFKYgMZ24/+xlcOI70zeSSWdDb4tLrW6TZ+CNE2bvXseMEG
oaJiEw6jSoiic8RAp28r37XLL3dDAfFX7guKHWQDn9FaXr4WBcQlLlEy9IUN
vmr+rBUIV0AMCwSS3TgbjPIcruDdoYD+PP7d7b/IBugP0/OL6vKo+e9j/efC
7HB8jeNOjPkBVG8SG7gowg64or2v2dp+VN0Y9hwTZ4e54dZ9Rx/vR8VxXsT2
vezAbNImvmdkH0rG9LtHVNghQJI3JdpbDnncZ9GnWLKDkJ9CCrVvD3JZXAkw
s2aH9Ck7mLy9B125MFOcZrtVv0z1+LNDe5D1oa+Efc7scPTfyTvDSTJI50tF
1/EAduCU7nn06Yo0ktp3Wc8rnR3Kv8TnsqpIoj9RX3+7Z7FDklYRV9uaBCqZ
07/jlscOwWWpYUfrJRBWe7TaqYQdZnjRKkVDAhmdZJOwaWKHhuJqQuy53SjQ
4cmi3gg7FH3RjFfJ2IU03lFidMbZoab6wu1l512IRz5E7tRvdhjMcXymRduF
EpeuXtCcZQct1FL4sF8MFd6lvcWYOODk/WOP+oli6HPmx5S94hzgNBnz+Z+a
CErnPPmfjBQH8L9PqLGa3IHsneo+SO7lgF67Mf9XsTvQP6VMjl0KHBBgVuVj
/3s74mp2cxNU4wD7qx3/vqdtQ0dHeDVYrDmgf6Hb0P2oENo4HjjMaMsBFwSu
sRylC6Lm3Lkbmw4c8ISRfOFdliDSdf1UtOLKAf92dZvaCAkiW4Zc4ZlADjgh
f4GLnVUAPRA99vfLEw4Y8/X4p8NEQeUdv7zeZHJA5lerGuvXZDR0I5LpeS4H
vPgwmSJ2j4zEPg4J3n7OAW5mJdkPBMgoP9JVbW8jB4j2iStLHSKh1wypCZ7D
W+9dmmS7G0lAvwqPiZ8f4wCBtH+nXC0IiMfid77WBAfkfaHrTsoSkGHVoaYd
0xzw15XCRIzjR8OuHX+aNjlATPKamO8OPrQysqzKv5MTNq3+a31mzo1EolM7
lsQ5wUONy2UHJzcCdNxkRIoTLM9o+fuXc6G7j6KulO3nhMiyzUAShQtRjKQT
zuGc0HjHTkNyiAPtazH6k23BCaNpSWufItmQ3rUVz+gLnPDm2/YCbW025L4r
jdHnEif8ILqeucPKhqr9JgV0nDhhhjupzfgmK9I4HKQ658sJXWL941LXWdD5
7KJ4SOaEuAtj96uimRCb6uwO/zROcJ5meM1tyIQKhpSevszgBPsJywvSVCa0
wltdpFzACWl+L2jPHzGiWPfmVqU6Tih9cMy08zkDalUdXJEZ5oTHa7n0awwb
+NVP2wPtxjgh1/TRQ4mH6zjVw5I9a4ITcM6TlbsOrePWOaPk3TOc0H0v5sLM
1TV8jW9KToSJC9aO8Ppfn1nBD35msiJKcIFhZFXwr/1LeL/H8R+6MlywcyWy
5+GnRdyPP+RyhBwXGDRkD1qELuLtarze3Ie4YKh9upd7YgG3yRWMZtXggpTS
/Mr85/N4oqfcq2U7Lsj6JOukfe0fjhOctY5e4YKDQiP1yQf+4T9yn7/3dOEC
XuH+ifd/ZnGFL4c///PmAuq6VNk7h1m8Q111/m8oF8x0WjR9cprBGYhnpEee
cQHT/kSLzSN03DWDKjRQxAXhP8YVY7qn8JEjfRydL7hAXvfzPtsrU3izpdHv
qpotP9KuOU2Zf/HQfIOC6LdcYMZu8fKn1B+cdEJXUXWSCxyiBe0/WP3Cb33i
kzhC54J/Q87Jndy/8LmrnZR9/7gA6wv78aFyAu+PO70gtMoFlxV5aNPUCfzR
6MmqaS5ukO7Njdz2eRyX8D+B0vZywye/UJOsuDE8jsRxMH4/NzQxGx77qjeG
s2W9EQtX4AYWWvbBWZ4xfKJDg8lbmRs8/TeSnt4dxQu2HW/R1eaG/ZlPT/8I
HsEPl6ue3HTghrzW4uqGvGE8W4uRNu/EDQ9JejURbsO40JcGuUlXbrijEYlI
KsP4KjPwfbzODan228E6+RveoI93F4Zyw2zlqpfk8hdc66+yiWUuN3w0HFZQ
nh7C8SsJ6rkF3GAVqWk+Hz6EK0z+OzD3fOu+N1Lnlx3Ct/3K5wir5gbudzB6
6vIg/mdMtLrsLTeYp4+2u65+xKM+M4nwTm3lK7uLPz3Th98+Z8VpOssNRqZS
loi9D78+VDOfvsANZa15nIuVvbj1gHvn0U1uOL6nMjN3Zy+u2Dvub0PgAd8Q
N+2y5R68/237SI0CDwx5efCYfOnC27Wl37Md4QHv5AjYfNyF17fdqtFX4YF1
VYaZe1ZdeM4bWuxPdR5YnY1lv9/+Hr/xqvA42ZgH9MsvRgzOv8NFamJyHL14
wKWlJ3MzsR0nKdNjy3x44N0TsS5ppXacrepkIEMAD2QIlF+r72rDp8pZzOJD
eOBpU+ShPXxteEOJJ3dTEg+oOSanWia9wW3yzK4K1/IAjSfu9rG/zXj5tV/a
eg08sFBv6Z+e0oxzYN7Sd5t5QLn/bN4O/WY8/33c8FwHD6Q9s1M9U/UKn5vr
Muj6wgOd5FNMnvFN+C2keeTuJg/8THydeTKgAe/l6CfXMfNC/PR1x2rVBlyq
x2Z6jp0X9J6yhPCyNODtNkG51gReEE3b8zJHoB4nhb3cju/ihafTZIudJ17i
6b2KDPNqvHCaalTqtFiFzz1u+iyryQvnHu0Jo8ZW4Rp2+lXWJ3mhjkXYW1ah
Cv+9fNWty5AXRBylvO67VeIKO/PGntnwQrajzrM05gq8yUGszTqYFz41nVea
si7FKYpFmUlhvPB+PHyBRinFbdewoK4IXnBOlgoofv0C54o8p4In8IKW83/p
8/tf4Aal8QXCObzgMq56IJSnBP++wRPT1cYLaeKrx0gzRfhGo9Bg3TteuK9y
7/WGbxG+7Y6EWEE3L9zeayoSxFWEG3HTCkMHeWGCR2HhyN5C/LXg5Xa1X7wg
IXv+ZadPPp53sI2pjIMPXup2x+hfzMVf/+vVesrDB/+SkktOs+Xio+XDUdEE
PhgYViiJycvBd2BLoleF+OBO0ZOJHwvZeKSWtIq0DB+Ejbk6Kqdk4e7Wd64l
afJBktyLOqJEBh4lGV199yQf9Euz9BcMPsULJpIZPXX5QN8iEzOMeoqPXy2N
NDDhg93btnc/Y3iKm/qMPuO244NzfmrGin+f4Fis6phfMB/Ukm7s9/iRipuZ
nJa9Eral/+TM8RdXU3HPbWfdzCL4wCPhc1TycgpenObCcCSeD4zy7tSepaTg
4gWpO6Yz+UDb98GJ7+bJONvrdSPrFj7wiTFa8jqUhGe5ZyVktvGB2LeM7KnO
RFxjt+7QxDs+8KaeC1tySMSDA9KsnPv5YHsCaXdhRgLOqqLu6PuTD5p5RL5u
yMbjGb8m8+sn+WCU5Urble44/FhiLJ1pmg/6NK39wDsOvz3/wz10actPuQE3
S3sszlIc4h/PyQ+8UuG3L/s9wDMs5ZsGefmhmqN7ynPfA/wY7xCLCIkfmHZD
Rv3XGPy2o2zY0238UFR1mnvhWAzOLNkZWyzLD1XP/9Pw3BmNMz0k57Wf5gfP
9c8uf4gRePqJ2j+8BvzgvT/z+a24+7jaos0B/TP88N2vbjfv9vt4kFF56UdL
flAcvpM1IBuOM/KfrR9z5gcG+pR78MUwPO0lI5OMOz+YaOq/HpkPxeFK3rHL
3vwgt49LdCk0FA9oW22bCeAHjxE7ZcWKEJzhdkrvRjQ/tBZrrx+SvIunKWgK
qsXzQ9j3yIyM5mAcvtPP3nnID28dlXySLgXjAbjqN+6n/HBRZI5149kdnGF5
9JdQKT9IVWjfI2rfxjed9mwq9PODl7ekQOrrQNxRQDd/3xA/TL28M9ISEIj3
1rmflfnKD8pdu1MWVALxPP6GFyLj/LDzNHuubVkAbvT8jD3HAj8Uu55/pWDv
j9ed9aUyr/DDZK73Yd0/N/E9TOlN6+v8cIevUvu4203cP9czYpmJAExBUcJP
b/nhRiuNE1NcBPi9KDR6ucYHD+00Qn94CJD4xEn90WkfvC79Z9wvPgKkctgd
dPl+A99zkld9jESAuF0FZ2Z5b+Abj0wfD24jQNZMt0DJdW88B6PrN+8lAPd5
cclDCR74F2JQTqMcAR7wf1jkVfXASeOUzbr9BEjPaz+s9Mcd94tQzq9SIMBs
Kke4sYY7bvDtDluRMgFOcM5b2XFew+++ELLIpxFg4fSHEamXbnjt3WcvcnEC
1Ku9LOFzc8OlD3afz1AjgPWN9pHj31zxtYAdNUnaBAg1pId+fu2CyxsXERNO
ESDYQpDL/pYLbrtHzT5WhwAvL1pXrIAL3t1tR400IICS9nX1Uzed8SzxF863
zQjwJuTYkkmEE67XrCXh7EiAvPOdvs9YHfHSl/Nu1lcIUHzq6XndFAdcqOJJ
o/FVAtgs5HUHHnXAh3OXLWluBJjfdkXex9Ued4nMTeK8QYCHAwka4vO2eG+I
8cSaDwEShMPNk5Ns8aNBjEem/QgQRbxS641scQaPs739gVvx0vx89chLeJQZ
J39GKAGS2NlS43AbfM6wzCLhHgEO7jv7LvbvRdz09IX8sPsEuGMy2dz5+CIu
BlVartEE0BpWfTzMeBEvlnS4jScRwO7ID9eNjxfwrunW5YGcrXmHF9zsc7HC
lX67n+jII8BrWk/6jllLPHFULKE+nwCHPynxGHlY4uf7vZWyigngEC5i7hlo
gU/XyDhfqyQAbzlDQGPROdyorPelbTUBGO/WPWpC5/DKwgAes9qteNhJBt9u
MzzgyUAuNBAAvzd2e335LE64GzLG20qAkuOnB0ItTXH3ACVFxnYC7FjS+PVw
1QQfuD4cOPeWALJ+SrYKD03wtCtHd356T4ByZnnrL5/O4AcNJs7mfCSAQqkF
fsfFGNcXOfFe7ScBulXq918dMsA9w5senf+15Sc5NL0v2ABPXqXZ35wkgK1n
VGSmkgE+MSjPWE3f2p9nCRZ2sfr4zfjtivJLBPg+V5754aIensEav6mzQoCG
pm7yt216eLs7oePKGgFcS9Nfn8rSxamGrJdyGIig3Sq3kR2hg+fz0+N3chLB
ZHYI4T6n8J6bDhcxbiK812KhL6+exBf/jh44x0sEJXLsz683T+JqHQOt8UQi
HAlItGK4p40PhjSt8G4jgq16yfZnNSdwNqZ4y7W9RKjSkOu18jqOy7kSZLft
I8Lp1qjjFQLHcYPhsMUjB4ggpS59trziGP64zj/qmiIRznLPmkRuqONKPg5N
v1WIYFOadm8qRQ03+z0awYETIW1lnNKsrYb7n7U8JwVE4Ig3XuNeUsXbjxjO
XTi2pWcvrD50RhW/MEeTGjxFhI3Y6sY2CcCDL1bMLugQwe6Cyl5qBcLze+Tr
KfpEkHGx4xKVRvhSsZSpnjERnj22UHnIh+MRToSwNxZE4PSc9hRcUcFrx0f/
ll0lQu/ZutIQ5aP4m55k5yIXIlh7Vdjs+nAE76kznslxIwIiOizZOR3BJ+Lf
zD3yJIKa+WjDaNZhnKL5bDXwJhG6LAK0v8odwncq2vj5BBBhEm1/t69HCd+7
U2TTPYgItygfahe9lXBYjGCyDybChWHbjZF2RfxKthunTgQRuvec+eTur4B7
PZC9pxlFhM8vZKbmDijgQf5jPKoxRDB3b51v/C6PJ5qcISjFE2HPZePWfVry
eDO7suC2FCIE1+uhl1IH8R32jJLjBURYa7whxyIvh0sbVWd9K9qKR47/ZqqQ
xRXgmszgcyLc+/HYmgXJ4ieEfsh2lBHh4t6w5Cmjvbh7a6tCyUsibMt9LhmY
IIP7lwaWPqsnwuAJloIyORk8LE35cGbjVn/alGwLX0njad75/yW2ECHj8PLV
9wtSeIdMFNx8RwS9KhZJbldJ/CNFq8nrPRGa64NKH5El8REGpmOu3UTIG14z
rKqQwJcGrmna9BGhwKpfMYhFApcINdHR/kIElSD/bY+LxHGfX6LmAn+JkDqq
PvlJQww/cTLrnDKdCETlg9LrsztxSsG+c5YzRHiZLjXLf24nXuhCM8uaJ0L6
KnP0ZUVRfHjxrOnhDSJQ+N2Fs5h34Plnv5uYMZDAuvl2D8PN7fj1GnuTm0wk
+K/sbF7byjac5O915jUbCQ6ZO/ZdXxXGj7PFGZ3hJ0Hck/SLskJCOMl+h9EN
Ignc+dM3OjIE8a9tTw1TyCSge61VhCoK4t73SwzGBUnQ2Dtnst9EAM+jdOl5
ipGAFDYsK15Owfl3c5+OlyeB4dp4p8RbIv75dsypakUS3OviHtX3IOI548Kn
vh4igWLg6R3kXURcLU/mpJQyCUoeckkc8iPg7vIaWuVqJAi7pMbtEMGHw4N3
J4aOkeDybqt8vxVenHfe6MSGBglGNA1vn3bgxbMqL2pqnCSBeE599R8dHnwQ
BR7vNyTB4bCoqP6jXHjWE47jK8YkMP4dnepSxYm7MUcdEzUlQcjy7gN2NE6c
502Kuq05Ca7YxeriWhw4rlOrumCzVW+XeuZVPzb8qfkiJuBJgjVXbk1ckxk3
Unk5S/UmwY7eQ6+E6Ew427Zb2dQbJGAQTNvwTWTCHT/yEak3SRDz9CBTK50R
VzCQGiMHk+Db5+6gF0UM+NjBP4nkEBJciPZ0k7rIgMfzl5wmh5Hgpyo9ZFqQ
AV/pwCpIEVv9qx9L/8G1iTVpGocR40mQRDsetPvbGuYutR0RE0lgaW+miZut
YVKs3/8RHpIA+xHxqfDjKhbWdMWCkEICAYaSFPvBFcwAu32QP4sETzo8lfcu
LmEjCi/6ecpJoK3w7mzbg3kslnj9Hk8lCRq6fh/oPDCPaUzjwFNNAvbWsomE
d3NYXkF7LncdCWrNrD6Z8c1hbjIjvlyvSZAd2//v7dNZTII9R56rlQQXlZe3
SZyexfp/OI1ztpNgj84ZCbalGUz56bIuZycJphMz808ZzGCMosTdHP0kyLqQ
FScrNI2VrPV/ZB8gQeoCy6LiQzpm8yk5nH2IBGpr/4W/ZKNjrYkyC2xfSTDj
f/hJ9s+/WBQZ2ljHSfCvOc0r/s0kJsbp7My8QILzpbqyHgs/MUZenR3LiyRI
S7qysjvkJzZC2Nc2tUyC9OmsyFfbf2JPhSbFh9ZJUDAyyPvixDgmJWPXX8xK
hjuTDOpOlWMYu5zGrSx2Mpx4myBRYzqGTRyQPJjMSYZaVHupamUUyz0yGnqX
lwxTCW3GueqjmJymFWZJ3WLtqfX7E98x3pP4b0NBMvxmUGWNi/uOTemIJGgJ
k+FgadQByrHvWNGZT9NKImSg/RpgvJA5jCnYmmRwS5JhrPq6O9fMV+zIHV3u
KiUyCJQcpWdWDGFCofsrCw+TYbY/TYOsMoQthfNeyjhKhhLmg4JVDYNYdezb
ukgaGQoPLjwP7hnAaBmabrbHyDDe8m1BlP8jJpIjtdNcY0vv/RzHsaf92MYz
1g79E2Q4Jdj468x//Vj9i1eS2CkyPGx9W7b7ch+m9goNko3IoDj086fL2Ads
9xvRYM4zZKCjh++33f2AsbxdV9g0IcNyoIG7q+wHrKWnJvz3OTII91czsF/v
wU6MHIHGi2QQGZyO5JDuxnQYD2ZfvUaGz0e+WE9GvcOmb3zpjvAgQ5Xdm4DH
yx3Yg7mwtUIvMtxVM/x+/FIHNvDzhz7dhwzcokdS0fG32IXOR2vOt8nwUZfr
ir5UG8ZyQks6KpgMPSbhrPszW7GsxgX94hAy5MpIUWKlWrHfpfrZ0+Fb9dlm
v7cffIO5P2I3cI0jg9atvWdjL7RgAtQy3+gEMtRU4ExX/jVjVRHW2c+TyNDy
7/5j57vN2Ebgy7WZx1vztMxYfV/2Crtrfy3bLYsM5y4VZ/btbcIeHvq2dq2C
DHlJeT4yn+owWlG4dGzV1rySLkuJqtRh32SUDUpryCDz3XivaspLTGJHXPZc
PRlCd7840+VUixUwnTTwaCVDQ1WS0+WD1Zie75JvXDsZiN1c33flVGGz85nZ
ZR1k6LsvYRkpXoUd/sWwPt9Fhu0uDLfO7qzEGt6XZ3sOkkFh0JcDHSnHrLVs
euI/bb3XiM8HXpVhLK+I6+VfyPCTb+7OA/0yTKv8isHidzIMP0uVZvAoxXqS
xde9fpMhZm+URG1fCfbDIcLg+ioZBBOq66wmi7Ar528oeKyToZEzPea5ThE2
d8aW5Lq5tR9yNefnSwsxlmN4jz0zBVKyiLnbwwowcdEpfVNuCiTu4fnoZPwM
y6MMyRvxUsDT5O7Dgc48TIH7NVGPnwL9Cmvkd9p5mOrS425NMgWqWOSsd2vn
Yud7Tusf2U4Bu8vrE2qXsrGJ1v/kFUUoUJoleqJiJgtzrpckHthJgV8HfWnn
ArKwm/nrXVK7KVD5myOZIyMTexxcoCcgS4GI1qCIEeYMbEiZV29emQI3tCTu
uog8wazllw/M0CigiWgel1rTsN/SP/j/4hTQUY/7suSehi1TXr4fU6OAlYVm
XmVmKiZEv6Lbq02BfVEfjMNVH2NpP0wPdJ2iQPutexdqi5Ix6c/H+Dt0KHCT
1Vm/TCwZO9y24/0rAwp0NG9r6OB6hBk/7dB5YUaBllad67IbidjnpMr9ReYU
uI1/DFQOTMRsojL4nllSgO7eqVvIloi5+/l2pltv1bNddIoXSsBiTOR0Yhwp
oOA+VaxoEod1cYefdr1BgWaV5R8ph2MwYW+NZwm+FDjsV0Nz+RCNWY8xcNbd
pMAn159Jhm7R2HytRzPXLQr4PNTHJMujsG1XrVQy7lFgv/7s16e5EZjNkHBS
+30K2FCkzu5kisAKNHoXpiMp4B1zj0fE8j4GO7VKsFgKRO3aLDcWC8cudSns
+ZhMgQKt3tTOt6FYIe1v8HoKBYbyD1VcxkOxpZzssd1PtuZlIOvJWBqChQXu
SHPJpMD04pPQgey7WLECmyBXIQU2zKm10cV3sJXYQRasngIaexqCuZSDsGOM
sdYXGymwvSTdx78vELvvpNMQ+ooCWttzVijXAjExjVc+/W8o4F/2NtW9NAA7
vpg/69xFgdj0ty+LH9/EIi7a6cX3UKDiPluG+pwfNvB+V2FtLwXetDcqOOv4
YY458Q6cgxTwfe3HcIzXF4s6GzCc/p0CbAdTPoyWXMcGW5TxtlEK9Li3Jh+V
uI6JK8w/ov+ggNux6P8SEr2xMi5HE9pvCozUbarKh3lhQzWGnX2zW/vr6SAi
FemBSYpK13KwUEH29qh1ANkNSylaIUqyUSFCM0jRuNgVE1DttFPloMLi4etX
QdcVY7PxIN/goYKo8BWl/Q9csPHcV46TFCqEezlc97e5ilmqJDSwC1LhZ92e
ZeylE9bf4SggIUyFLt/V0tvCTthrOrHJXIQKQqeunzz/+TKWdei8cKckFXzU
C1vMQh0w0TeKzr+lqYDpGiteXLPH4k3ZW9j2UsG89P1+ezd7LNin0AXtp8LT
xvZQGTs7zK5x7U3xYSrMlg6VDrpewmROJ3k+0KQC20KTY9HmBSzt65WOIi0q
/NYDsYpHFzAhFxDvOEmFznqNgOH/LmAcD36+Y9GjQpuXxVtH3/PYxMAhSU9T
KvidIlw3VbDEzjty+sSYbeU/MwvcEWaBDax+7io0p4IJg0T19R/mWKvobd+f
56mwjZ+5oSTrHJZr0/PB1IEK9yQ3+bfpn8XEFzL3eFymQt2wXW7qK1Ps4d3r
/tFOVPieIXlp/3+mWFiemGy7KxVuLB/dJrXPBHOcvhqkcmPL/w/eP62HjbG9
vtzyoveo4KoQ8FmpWR8LCROhCdyngiFV1GzeVh/7kXhAky+SCgm84gwJ3PpY
WpmhxUYMFebGFYdMzPQwKv1R6NeHVGAy9mF7IqyDua0XxPYnU4Gkzmmg6HN6
6/9sSO1MocLDEPeby99OYWEyY2V16VSIkUXPhktOYgzWciMpeVRwVonYYeur
hVm64H/j87f0Vjx+Dc+fwGpu6i1FFFJB2/vTGNXtBOb5yJ3Pv4QKH4qjeLzc
NLE/vbXKVtVU2NXPEPck+jj2UfP0g53tVHAQVP7ZgqthSmesUgQ7qDAeaMM0
9UUVi7FxzeXvpEL/Hedn/P6q2KnAuPrNbiqkcpQYCb4BrKn6y+S3QSoYPfji
oD+EY2Jt9IWPn6iw6Ra+KnQYx/w+MjJ1fdnat151PVochh2dkxRq+E6F0Utt
PvoWNKxw39Vjab+ooPUiWOInSRnjoQXoJk5SQVycM6Xm7n+Yg3aMWdRfKhRK
Zb9z3DyKSdiVuwTMUKGx5kGh6OIRLCltI/n8MhWOBW0TMGA7jN0mR86LcQqA
Upfxfs9EBexpgvNNdW4B6CkOOHRGTgFr2q7HbssrAMbe1O60JnmMQYIo/Iwo
AOtvrpaihYOYr9ID2qFtAuDpXxt1bXo/9qjyWovJDgF4HMwwyEzbj1XTjHRu
iArAw1yBxNR7+7ClY9Tz9eIC0BT+rSjlsBzmYZxwS0tWAELM5bvMqvZgsYNe
PFf2CcBQ/VD9iPgerNTCNC7igAB4/Ejr74iUwWYvCWd/UBSA09s8tXyuSWNX
PR+1W9AEgCpQ2Kh2XhK7v+JjGIALQJ55jdXQiASWf9P8czoIwHB9rbCGvQT2
O1hk6ucxASiOD1k767Mbs01IJbqdFoDVaz4Obxp2YXe2BzyM1RWAQ+t2Gvqm
u7CM1PO7K/QFgOhlJHV0Vgwbyd51aM1YABJ0zS78lBPDLCufmgZbbvUjdpKr
3VsES26wcXxrLQAuF2dqhsV2YEOtkr4EOwGoOvfK1m5gG3ZmMDv1obMA1Lxm
YSZdE8Jiv9s//3ZNAL71tajSjQSxnl97Xkl4C4Bk3je3QnUBTGfl2XhhgAC4
1+0PjzpOwcKZnJb+3RaArx5zHOkmZKydaz/Xf6ECMOqZLuTmTsI0txfvexUt
AFYLz7UdOwiYnshUbn2cANReYvkVTCZgpjvlpGqTBOBVsmwbvZkPc9ydI1r2
ZEvfe7ud0D4ezE1y/OHzTAGYMuyQklzgwnykJQQLc7f636F3wraDEwuXTePP
fi4AH2q2a59JYcfi9n2997RMANSblxpWE9mwlAM7ONKqBMDUhFe/KYUVK1JM
ZEhqFAAeyvffg23MWI9K1ExYtwAIf3DZqRPDgI0hnt+3BgXg70SA/KLBBm1e
PWTE97sAnMkdjep/uUpjO8HyyeOXACh//Y6Uzy/ThE4FfLg6s3X/5cfjYYcW
aXv11t7aLW/tL+Nv74j/5mkqRt7N5xkFwaBmV5et/T/aKdO52rOcgoArO+jd
rpuhWZq7lBkQBUF++mpI+tFp2t55vYjdwoLgJ5OTMFP6l7Z4X95uTkwQYkXf
yHxWmKQ1S5GgRUYQJnfdTMLHJ2hR9bNC8QcF4c5ymWNZ+zjN3PTDjO1RQXBJ
WJ858nmMtmfmRfsREAT/HJOdRMFR2kJo7FOOE4LAdK7jw4DXd1qTuIfvoK4g
iHliPp8WvtHOGR3e72MlCM7hQR/d64doc3cWv+1wFgRuWdKSnlU/7X5FZXTd
TUE4p5GYtL+0hyb167r6+QhB2CX88bqZ2ntaR2vhqHGqIMRZlkScK2+jueWM
3jpZLAgim6Qxi90tNLtjv484lgjCdFaZ47G0Zpr58PRkSKkgNPzSrTwl1kw7
LrRh+LpSEMZmxBK89ryiCYUISag2CkI58+hXsGyk1dmdbj7cIwj3OKIY7wbX
0l4wG3kb9wpCS1SCYXpvDS0n1UzOvV8QVp1z2pila2jRH+1inw8JgqOgn5DC
QBXNRjPIRm5UEHhra0jhDhU0LukKFvE5QWg2GeANVHpBMxkXO84rIASEORGv
vHe5NIXNS4XsQkJwr+fY2dpDuTQeoWeCTNuEIIgYUg9PcmgNWod+L4gIwbWV
6AiDoGyaTIFW5LCkEGRvUz0Z7phJW7rmNvjikBA43n+edrj5Ce0hY7OTmbEQ
TLO7MCtfTqR92WEXnx0rBMnRngmvpoJpZyRpPz7HC4GPVencfuNgWtc+ohIp
SQhGZ3ITo+vv0Jrwmm7fx1v+3liM9aXepuWc5+c1yBKCwxGRJoX3gmhuGRW3
1iqEoKIzgcFgxY/GLsfhqv9JCELfXbfjDr9GC1D6Uh/8RQhsGb4tFrFfo63Q
SvhqvwmBsamSR1uwG+3PafN8qTEhODkhFMkQ6UrrcS7+ufpnK39f0rMTYc60
5BemllkbQjDxnpamdtWBRq3dV/CJQRhqfkUOijba0yKamdYIzMIgi7Tl7grZ
0wL78pN82IVB+urrfbd7bWm2iwx9egRhOHyEWYl004Y2vNm3O5gkDDd5rMXl
Zi/SznI8c6uhCANzm9SpeYeLtFPCxgQpYWF4ftHss6KNNa1l116rc9uFwT/3
psCN8Qs0fO9mQZSIMAgm2ssSr1ygVSr0rrXsFAYpngDG0bnzNHmV3JOru4Th
+OcAwlDAedr/AJEy+J8=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 0.9999999999999836}}, {{0, 6.283185307179586}, {0.,
      0.9999999999999836}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.539349055652882*^9, 3.539349239835309*^9, 
  3.592056901812167*^9, 3.592057099053848*^9, 3.684450462393339*^9, 
  3.684450496631474*^9, 3.684450655379141*^9}]
}, Closed]],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["c[0]= 1/(2 Pi) Integrate[ f[x]  ,{x,0,2 Pi}] ", "Input",
 CellChangeTimes->{{3.654948984508869*^9, 3.6549489847297783`*^9}, {
  3.654949615571412*^9, 3.65494964814408*^9}, {3.6549497088990498`*^9, 
  3.654949727640229*^9}, {3.684450515532826*^9, 3.684450548314762*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Erf", "[", 
   RowBox[{"2", " ", "\[Pi]"}], "]"}], 
  RowBox[{"4", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 CellChangeTimes->{
  3.539348898608249*^9, 3.539349024083955*^9, 3.592056900043282*^9, 
   3.592056931073666*^9, 3.592057096800711*^9, {3.6539945554408913`*^9, 
   3.6539945642812357`*^9}, {3.6539946025558243`*^9, 3.653994613374568*^9}, 
   3.654948390510152*^9, 3.654948474194743*^9, 3.654948511022745*^9, 
   3.654948944741342*^9, 3.654948988970234*^9, 3.654949076772931*^9, {
   3.6549495968046494`*^9, 3.6549496489913397`*^9}, 3.65494972964876*^9, 
   3.6555539379157343`*^9, 3.6844502212011747`*^9, {3.684450496650613*^9, 
   3.6844505488441668`*^9}, 3.684450655413558*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
c[m_]= 1/(2 Pi) Integrate[ f[x] Exp[- I m x] ,{x,0,2 Pi}] //FullSimplify\
\>", "Input",
 CellChangeTimes->{{3.654948986114046*^9, 3.654948986361717*^9}, {
  3.654949655056314*^9, 3.654949657327663*^9}, {3.6844505208525887`*^9, 
  3.684450522507264*^9}, {3.684450552755707*^9, 3.684450552961217*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["m", "2"], "4"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "m"}], "+", 
         RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"Erfi", "[", 
       FractionBox["m", "2"], "]"}]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 CellChangeTimes->{
  3.539348899882002*^9, 3.539349024467109*^9, 3.592056900477057*^9, 
   3.592056931261525*^9, 3.592057097008535*^9, {3.653994555571148*^9, 
   3.653994564408968*^9}, {3.6539946026898823`*^9, 3.6539946135026283`*^9}, 
   3.654948392881493*^9, 3.6549484760088367`*^9, 3.6549485135191097`*^9, 
   3.6549489471425743`*^9, 3.6549489908822393`*^9, 3.654949078761942*^9, 
   3.654949663153792*^9, 3.655553939438118*^9, 3.6844502213434*^9, 
   3.6844504967669687`*^9, 3.684450553756406*^9, 3.684450655573389*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["term[0]= c[0]", "Input",
 CellChangeTimes->{3.6844505601323223`*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Erf", "[", 
   RowBox[{"2", " ", "\[Pi]"}], "]"}], 
  RowBox[{"4", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 CellChangeTimes->{3.684450560487145*^9, 3.684450655593274*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["term[m_]= c[m] Exp[I m x] + c[-m]  Exp[-I m x]  //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], " ", "m", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]]}], ")"}], 
       " ", 
       RowBox[{"Erfi", "[", 
        FractionBox["m", "2"], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]], " ", 
       RowBox[{"Erfi", "[", 
        RowBox[{
         FractionBox["m", "2"], "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "]"}]}], "+", 
      RowBox[{"Erfi", "[", 
       RowBox[{
        FractionBox["m", "2"], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "]"}]}], ")"}]}], 
   RowBox[{"4", " ", 
    SqrtBox["\[Pi]"]}]]}]], "Output",
 CellChangeTimes->{
  3.539348900096125*^9, 3.539349024623434*^9, 3.592056900596742*^9, 
   3.592056931376429*^9, 3.592057097120233*^9, {3.653994555646126*^9, 
   3.653994564481369*^9}, {3.653994602805489*^9, 3.6539946136003237`*^9}, 
   3.6549484779031267`*^9, 3.654948518518489*^9, {3.65494895212764*^9, 
   3.654948954010151*^9}, 3.654948994665717*^9, 3.6549490833912086`*^9, 
   3.654949669189684*^9, 3.655553942728485*^9, 3.684450221397848*^9, 
   3.684450496795452*^9, 3.6844505631323843`*^9, 3.684450655640749*^9}]
}, Closed]],

Cell["series[n_]:= Sum[ term[m] ,{m,0,n}]", "Input",
 CellChangeTimes->{{3.6549485336493683`*^9, 3.654948534968346*^9}, {
  3.684450624234624*^9, 3.684450650935773*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"series", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.654948537062978*^9, 3.654948544343122*^9}, 
   3.684450568430114*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Erf", "[", 
    RowBox[{"2", " ", "\[Pi]"}], "]"}], 
   RowBox[{"4", " ", 
    SqrtBox["\[Pi]"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}], " ", 
       RowBox[{"Erfi", "[", 
        FractionBox["1", "2"], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"Erfi", "[", 
        RowBox[{
         FractionBox["1", "2"], "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "]"}]}], "+", 
      RowBox[{"Erfi", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "]"}]}], ")"}]}], 
   RowBox[{"4", " ", 
    SqrtBox["\[Pi]"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]]}], ")"}], " ", 
       RowBox[{"Erfi", "[", "1", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"Erfi", "[", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "]"}]}], "+", 
      RowBox[{"Erfi", "[", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], "]"}]}], ")"}]}], 
   RowBox[{"4", " ", 
    SqrtBox["\[Pi]"]}]]}]], "Output",
 CellChangeTimes->{
  3.654948544832046*^9, 3.6549489574770317`*^9, 3.654948998965178*^9, 
   3.654949088991107*^9, 3.654949672981954*^9, 3.655553946080818*^9, 
   3.6844502214467688`*^9, 3.684450496816003*^9, {3.684450565446005*^9, 
   3.6844505689480143`*^9}, 3.6844506603730927`*^9}]
}, Closed]],

Cell["Plot the series with different numbers of terms", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Plot[ Join[{f[x]},Table[series[i],{i,2,5,1}] ] //Evaluate
  ,{x,0,2 Pi},PlotStyle->colors]\
\>", "Input",
 CellChangeTimes->{
  3.653994609851053*^9, {3.654949113915764*^9, 3.654949118961306*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVk3c8lu8Xx+09nmlUJFlFw2h8ee77OiiiskUySrJKRlYhoxKSlVlCsrOS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      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1Hk8FfsbB/BKKNcVsraJdrlSElJ9Sir3akGyhJvr0o2ICF1trkRKKhVK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      "]], LineBox[CompressedData["
1:eJwVV3k81F8XHjN2M5aZsYYUoaJESYV7SEpkS5IKSSqJFmRrUz9FIpKQJNkb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      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVl3k81F8Xx2WPIYOxJam0U8IPIecmSwuFhIQkUaIkWxJSUUISomwx9hlG
9kkuIkubJEv2nUgS2Xm+z19e79c995xzP+dzr/lusb1ufImVhYUljI2F5f9/
2TDP54H/7mr2k49mfn/VA9Ii0juknp0HE/mYlI9ve2C2K/xke8R10BL751DY
3gO9h+v7iyL8YPfOf6107l74fnOIlhrxBJIyl24uQS80hvwlx0ckAuVQ0vut
9F4wiPWujonIBbuRtX0Sd/tA87R4QbQeA3aXp9wlhfXB97OzHH01DPjx2MBw
9kUfsDnQM92r8uDSySDRrII+sLm76U/Cm3xw3fTfsYSRPhAvWvH7Qy+GuGdG
Wq9O9EPI5vL46AgMN+pmSiJ5B0D3w8sDFXwV8BLpmsqJDcD7QHPh/4wroLlj
++4SmQGoXfnaLtVRAbVxwRLUQwNQN15tNz1RCR2nxrqarg1AQ22Wd6xANWxX
fFtz6/MAfPLzSBsxqwMtVk2lCwGDcFJd8ZFlXB3EcfyREQ8dhM//fl/92lsH
/vJvmyqeE+x85cCbK/WQzBK1qYdG8DnLsrDbDXCQpOx7pmUQGlW0mv5L/Agc
u6PVJHYMwc85zrXDNxvhydti7fCSIVjbZlCt8qwR5NRb74VVDIGw4bNHcvmN
8E0z/6tP3RBAxmZh8b+NcFP55tXdbUMQaa66e8r1K9heOXm28t8QaJZeOZ3g
2gTPn1re65cfhtNDuWKREU3wJuvArU6VYbhM/tf16HUTlN0PbqzRHIZnVwIu
u083QYD72m17/WEYFX95R9/1G/St0yzsth+Gp94f0xdvNIN+xJGA5JhhSEsT
dJ562gzXWNI3hSUMQ1mTucJwXjPoaLgHXaYOw/CeobKvf5pBQv5g6ljuMKh1
rHzNuPEdzupk7ZR8PwyD6vuXTW+0AKt3daT672FYcHCv1H/aAgPj5dcEZoaB
P/JNoFZeC9jjg4nf5ofh4IQeed+fFpjRuzcmwzoCYXE2OzhutMJuDiPXaaER
UF15apjv0gasbsu7lJRGQM3H8Tl3eBswSNUi7SojoL6k1W2V2wY35W+9dlIf
Ac2Fv1e5J9tgNjO377zWCByZPRNkdbUdboz8l+5+agS03fZ9fh3cDg5rMY+f
GI+A7l9OCndWO7w/RF1+fmYEjv4pTn492g6Z23k93M6NwMlf4uVc9j8gxtnq
0jn7ETB0mma3evADuGIfGYxdHgGj8YYTr6k/4LbX+/RLV0fAZOx2u+XAD3hc
JJO+22UETC+bSL9m7YDRJ/26N1xHwGxE1oFraweobPxpkO42AhZDXTN5Nh3w
harysNtrBCztitS5/DtAvupPUY/3CFgNhAVYJnZAaEvXkS8+I2DTBwJc3R3A
u8PK5Zb/CFywETOzXOkASoQGSSlgBGx7puLzJDthr+Xwaue9EbjU9Wqv5blO
MByz6F8IHAF7S2/XPO9OMDtyvNH54Qhc7jAu5XzRCSQ5gw2Nj0bgisVeFsvS
TnB5dTBB+vEIOLaz6eW1dcL2PBaf8yEj4GTeGco53wlx93LSQ0JHwLm1oPmc
aBewmTtKZ4SNgMv3S7acpl3g4iv/LzN8BFxNNDPPuXfBlQ8CxuFPR+DmN5Ep
RmQXlAtkz9tFjICb8W9lzoIu+MybM7bz2Qh4fK29c+5bFxg8G5BpJ9jLMKma
Md0FP6Lls7wiR+DWFy9eTsFuuCQVdYszagS8TxoZnzvQDaeOyT4LINjn0+5Y
hmE3eBjIzk0Q7KvP2svh0g2z7sOpOtEj4Pfhx45zT7qhdEttYgjB/sfznRk5
3TBZeWaokuCA+scFHJ+7YWebkucQwfeO2i1Z/OoG+5ktpnME36/V0GKQeqD7
9WzA/zlQl/KIQ7YHXpamrP4/Pqjm1xeLEz3QU6jWUEXwQ+33IgzHHjh/dnA4
lODgdwlWHME9gMyGzugR/FjLk2qR2QO/beLFfhP9hlSeGs+t64E3W4PkHxAc
hnYpcIz2gA5STVxPcN15fw06Wy/kG16w9yH0OJo40WMm1Avvf3wK6iL0qu82
v8e6rReohnYccgSbflSlrFPqhbkVzfizhN6DpWLpa9q9YN9zwesGMQ/X9HnV
1TO9UCyXGutGzIslqq1h2b4XCvU52S8+IeoHlFguefaCw7t0pgYxX0mXmMmF
h72wqPi1Yh0xf9UT5oJzWb2g1/us3iB4BN6rqlJn3/QC/YX7t2bCXyY7xJRn
PvZC/0EXdb2gEbi+ru3sn8leiE1s/W+S8OfyZPH477VemDYqaNxK+De48/md
SYE++Jb96IcW4e+0YrNX4wp9EDAUYaBD+F8pVUXx5xHi/8wXy4qdxP2oihCt
GTXpg9+WJwpnPUeg27l1dMijD/yVzqiZ3BwBioyZfC+zD+jhJ49LXhmBZLJK
VfeHPpDsvm7///ssvyZi0tVJrF8dPhB4cQT0f7R4/ljtg8x2yakEK2Le4aa4
WasfbshGVnUZjoCgr7LRt9P9oCOiR75tMAJJV0UGvtr1g2rwIx324yNQptvC
+SWwH+LPBPj8IN6fv8tnTtY39MN1K+flaEXCbz//663t6IdHVh9PRu4fAf42
iuv7iX6wetddc2fvCOzJ/x71jn8A3qgYaFO2Eff5ypmut8YDcD0Z3TIjj8CU
6X/Xyy4OwP4QpZEiEuFvbcq6N24D4HW6upKVewRebP4uUxI9ALKahwbOrw7D
1+8mTq9/DIDKL+aE/M9hQFomS2m2g/BjIEhBpXwY5kV2qdxzHYS9vl3O70uG
IW98yfU88X+wckhnv07+MGyNSvkpmjwIr945OJIzhoFtdLr9Yd8g1OzgaRoK
H4b3oU9LHG2GwMAWVIPOD4Ov7aUZXZchuGBO9RU6OwwqKgflt/kPAef5l5NP
jIcho7c3vSNxCA63Onqe1RmGYEX55/o9Q/Du3YC9/J5hMGj/7L7Pehjs7fd2
zk0R+3KS83iuDUPiHW7xkLEhKA/w+DV8ZxgGltLUyP1DsE9W6lJi/DDs7eO3
nmwaAgE/ZxOBrmGo16EHzeYPQbMMSXGaeMfNniWXa90cAguXY1OFZ0fB6MXf
ZpWRQZD+Gy4x7DgK5e+yXTS6BmHIvU1bxGcU5Jl7TA58GwSX2w6xHgmjoGwm
AxPlgxAY+EBLZWAU3OrU3mVEDUJ+XGVkidMYHKzQqDNAg0CqP3jwjd9PkNK4
0NYSPADlW/YEVKROgKtfwK7UhT5Y/KTmnFQ0ATqtvbKJE33wn/cJc//aCXi9
kXbySU8f0Jqc9qGxCeBMXtUxrumDl/dyf2DZX9Ah5R94KbwPvIaUFHH+L5A8
LhH6XaYPFDNh8G3lJLyWLv/sp9cLJjF7UrquTcHnK7nvb0x3wkaOt0fC7ach
Tp2mWzH9HYIUa15XPJyBkKaIxbdbP0GL3u1jJeEzIGD5YPHA5EeQsTzQmxsz
A2l9Zrtx6Ueouh/Pl5gxA/MLPuQdRh9h9bv75Tt1M/D+T/wv2bsfwMNrh5Qa
9yz8jLuwaDJcD/Zvgx7lB82CeRvJi/H+PejoHbdJC/wHqru6vFLHK+DUlF2r
e9g/+J5zyHJ9RQWcjfU7qRP9D3IujVyLiKwA5/ECjcHUf6C3Q6dGWLMCop5s
Ft9a8w9k+EyV3m7HMNQ68zWebQ64Wpp7jYLK4MHlxCNR/nMgRs402xdYDE/I
TKbdwzmQ/zge8E21GGKZzQeUwudAuyR28cN4EdBJPNLfEudgU8Z5XGxcBN8Z
bssCeA5yEr5x35UphO0LxwpDVubg4DQflbftNdQ8mtlx33seqI/1WutY6NCy
/ljUSsA8NC88q3FyocHwo3g2z8fzoHzB6MJAbzZwB+v2XombhypLuc3Hq7Pg
eHBM7KnyeTC1lSnhisqAz8EapI2sC5AVd2stxJoK3TxPvSN5FqCcFOB6vyMF
fgcPjfIJLcD7g+9TT59NAYHHYTUsMgtw8oKLvrdZMpx+3Os7rLMAskHBO39b
JUHb4/t/8h4tgHCPI8fxnbEwytt+fm/EAnipx72y04iBhcdyn6kvFqBi06Xf
Sqefg0RIS9bz7AXgThdKnnsQBZYhu+zufFoAsQS/GF6WCOgL+dhylLwI4WSW
/dtDA2GatEWnSnwRGqniUxqT94E11D1ffesiuMiPv6w2vgcyoVLh+xSJ9e4r
Ndt2+IN9qMsx4TOLIM1Ra4YmboIHX01xqNUi2LxlDXYacoGgUPEdXPaLUOF5
LHyy4SpkhFaxLnosgn/xJ78Xo+fhZ9L5eU4/gvcdK1/8YgL1oVd7JoIWgcXD
N9/I+DAkW/Q7FoQRbMh3dTGKBQ/rpk5rxxJ8YjqJ/bwBDl93ca02idi/X631
eoY5VnbP02JkLAJaPnxO4+EFHGB5st6/hKhfHyZ67+NVLL73YcuWtkXoLbBA
Gwc88dG6pamLoksgQJ38tHz+AZ5UP66kv3kJGouiuXz8A3Fkboyn0k7iS+hl
sQN3QhDujf5vlV2FWD+t7Hui8RH2vHSdN810CWz+Tl0NJ4fhNNaB7aNRS7BL
UlV1jO0Z1vc4cKUxfgmmEqeXqnye4ekxP1pJ6hI8FLtnsmfmGdb8Kqn4qHAJ
Ym4/7E/pjsTfE03Rnu9LIKZj9MMoORqzH2qwcBJehsbROO5NQ7E4iyGWYCK5
DLtEgwQpei+woYxDn4bMMkhLZZlT01/gl7zsl/mUlmH+5R/Lx3YvscKPQ+45
p5dhVKRk15NPcfiCZ96TqYhlME+eWRW2SsT8VQcbAl4uQ++x4TvbcxMxk1TF
TqEuw8OZultxa4lYMLnp1sHCZfh4PlOizyAJV3/8ezGgdRlc6l1qHvQmYRdR
nwTh3mWgMsdNVNhe4U227O1po0S8Ulis9PZX2GNO+OSHhWVQuvrmZZz9K7xr
q7KqsOQKCPfm6J/ofYWbncpd02RWQOml6ZEPy6/w3WJduqrcCsiekmoIEkvG
P/TNtlpprgDV9LJgqUEyDnzeY/lbdwUiz3+V3O+QjBX7HZ7fPbUCBde2HRv0
S8Yhnl6kNBsiPvBeJn9uMlatYtFTvbICvdb/KTyoScZDpEd3G26sQNIlocBD
HclYMzn232TACqhqOR/1YE/Bvz8ye1VSif077kVvPJmC40SPbGygr4AYm+On
fOsUfNT2wxnLohXovKRo/+xaCk6a62jwr10Bl7l1KXtDUrC+lh2HUOMKyFTv
fzsUm4IXQiYgtW0F7KJCtv9MS8HGW1cK6sdWwP+/6o7m8hS86vTg97npFZjZ
ap1VVp+Cs4v59kwuroCJb1Ldn28p2Jw12s6fbRVC4nYsunWlYHYDqURB0io0
hzSx6Q2nYMbztHaq8Cp8TG3IvjyZgq369wmrbFoF/Q2epT9mUzCPXPHJ+u2r
kHTcbzZ+OQUXecKjc/tWQbW4dnc+KxXbVtW++6VMxFOub9nITcUb+AxX/WAV
nDg/ZrSQqLjMrE1V8OgqeAU7hg4LUPHlZJubVMNVMLm9PuGEMBUL/xqlK58l
4jlisjhFqbhS5cZo3YVVUJJSvC8mTsXXAha2nnNcBZn5rSt3JahY4tNdq1+u
xH63ttEjG6n4vShPjN/tVZCN+LnxPME3bSOayPdXYaJDyKmZiJemS/BRQ1ZB
umk/g0rk+ziXrKcctQqdp1UrGol6Xlp7A+riV0GD44j7WQoVy4Tml1mkrUJB
vm8mCFJxY6v63EQOsb9EXvU+PxXf2Vp9wK94FTJMX6/s5KHiwXV5+mOY2P/T
+6U2BxXr98U7nK5bBQbjwXjtWgrOrwgOeNu4CpILupWvF1KwRJJn/M72Vbif
sPsPx98UHOBnV/K0j9DzRYhh1XgKHrM2+rY0tgptzyoKRwdScMmmvesbF4l5
dQb99mhKwdIrojJqbGsw2GXt3luXgoM62YHKuwZiZx5dLCb8YPqy281Lcg18
CvSHGBkpuNz7w5N+mTXI8DI58D0uBW+3KMnSl1uDGdeHpo7hKXhGLKJXWnMN
po42pf10T8GW875LwbprYJ6t8LTVIQW/a70qMntyDbwMTn1TPZuCI6J19OvP
r4Fh0cXhc2opWF54ofjG3TWIk1ffc+hfMo75O9TU8WgNWCr/5gwNJOO1pqZf
OhFrELl9b+76r8n481PaNomUNaA6XKmqzUzGThtsnlRVr8HHxvTy/84k4+ZJ
/SzZT2sgLx5P/aaZjNU/H6yJ/r4GjUHiZ2d2JmOeUKElx+E1sPESHaycf4VN
HlzMX8/OgmZYJpPTI1/haVbRza+3E0zNfu9SlITTXENlR3azoEamqDotJglb
9LOpSe5jQZFpKP6WdxKurJwyCVRmQdrBrzg+ayThcP+GYAs9FpRktXNxyisR
71u984/1CgsaFeI9a2kUj2kON679dmJBqs0cnb188XjvV7vhDhcWVDIzMl1R
H4d3UU+0FHixIP9T7HovIA5vOS5eZP+QBQkkHQ/t3vYSC0cXuDeksyB5RYa4
aGMMXpQbn3k6TOQTL2lIrXqGa63M/0rbrUPy6w2s9Fr98YEE59Y7bqxIYM8z
8aceEbA64V3o4cWKRoespoPbI6BB/eGz6z6sSP+I5XYzjWdg25586sJ9VkT7
nTFhsy4SIoXbarUjWdH8uOpTwUdR8C9Yq4S3gBWVPGK5VBwaA0xP0djYv6xI
0jpXNdE2AQLfy3hGzLEi/7duq/A2AYwpCmceL7GiqUCFxw9FE2H8tT75Dhsb
6j0QLUj6kAiSk3cf2QixoaLNOm5d0UngZzdxa6ciG7Lb+mTOdOoVaBtVWhS6
ErxavPuONxUiH19VYvNkQ7tGQ59fpFJhoIbCb3SbDTWa75Nb95kKAWqOlRP3
2FCS+/pj56VToXKb0C6ZKDZ0+d3T3qjKVND8ZzcbUcyGzA1nuexn0yBMfsOX
3jdsiD23kt1DIh26HEsz9lWwIck7kbmKkA4+PXyWDXVsyJLh3F8YlA5v6oqq
1v1gQ/M1zd/eC2eA6kvucJdlNjQo+dY+QyoTHn5/faWchR2hY1SOM5qZ0LrB
6giJgx05CaceTbfKBI/7ef/S+diRtKHJhNrLTCh0trDqkWJHcRvOmAsKZgF7
BruK3DZ2JGDr86ZnXxaY9OcI3N7JjszvFemfOpEFM6Zs1SLy7CjGad85oXtZ
oIBoe04eJuJXtffITGZBgLcpe5wOO8rg9pyd48qGrwUs3WPHiP0dG384bskG
l91nnj4wZkclA4kBsqezIUdwda7sIjua8DTIprzOhr1Dp2r2BrIj/9PWR1Ws
aNB2RfbJpWB2pD9ID/cmfn8GTnKfTQwj8sP9pHP3aNA7Vzkh+Jwd2bWd2fgv
nQaRPErCi+nsiKVP8veDCRocfiLQrUhjR+HebB2MZRpMCv1Kd2YQ54+9/daT
RIejm9LU+0rYkSXNNrZtDx2W94tdrKtnR5cflFzqs6VDZsGMLOtndiR/Mb5g
+DodTA9+/afexI6aq18GBvrQgaEVHJz7g1jXnaZERdLBqtbeZKyb0GdiPogt
iQ48+kektg2wo3kej2HebDpcOrOcFz1OnD9Sp38M00HwR9vtxt9Ef7vnAdfT
ocK6UIdnhh1RT/Xx7PtGB4nL19rvLLMj4YWdt1oH6VA7cTylmIUDxeU+GyX/
ooPbjZ3Of9g5UBmbsdXQDB0+e/eyXOLjQHbz46umbDlwe62sIYHMgQRUfNlm
1+fArvuxkW0UDqT6/UvZXoEc+M7tYS0owYEsJ6wllig5EBBqvEtfigMNOm7i
u7gxB/YL7p9+sJUDTdS5BF2UzoHOaN4yvIMD2ZQeuLMskwPBG0cfLOzhQNUt
2QNyu3NAJan6lOJ+op5+fN6cbA4MyrwSd1bkQEm3lHvOyudAROadgTQVDqQd
LW5vopgDsM+C3qvOgUj6FodH/suBidfKnhKIA8kb3XEWVM2BWBWhwybaHOjh
iufo94M5oFv2myfsKAc62pGbd0A9B/6ij821+kQ9pcX67Ro5kFSTkbDOiAPF
vHip+Jpgg+MPLquf4UBe1/WmWwhe/HxBwf0sB+q03cwbSXD6ac3lHCsOVPDn
9f0xIp9Jm8T70QscyKVn1b5VLQfWWc092WrPgfyznd5YEfVz+r6dtXTkQLJs
TSE+Kjlgac/YFn2NA6H9LiOKRP/rx0N+fXHlQDK+f9vuKeRA0fUrxes9ifNk
ubo47c8Buxmdu0ducyAT9Wvlv/bmAPnW1hN3/DiQ2PCXZq5dOVC+sipcfI8D
NQ6NvWduy4GrAR3dU0FE/GmPTM7NOSDGVZKxJ4QDCXtFR4yL54CrwA2NhEgO
xN0i0ubPnwM/wxpcnsQQ+0sL1r3izgFbPplU/zgOlMCrPejAmgNGPK18F6kc
yJxqoviT8EvdQ3ktkwwOdPwYe1Mq4SfEFeyhQ+NAIcssYdzDdJBnP9Szs4DQ
a7bs07vvdMgIiBYSL+FAuh/YQiQ/0UF63ZQeTxnhh4TUTslqOmxYTWZMvCP0
U7tWKJxHh8k57oC8bxyowX5o3VAgHew9bIuSWwk/bIjk9r1Nh+6ZNz+fdXAg
n0vKbzFxvz79uXbaY4ADRfAGfD1kRgfaeLOM+l8O5NQyoLt7Kx1kHPedlZ0j
9NhUYUoSpkPcaFDopiUOpObHeyOWgw6Ph9T+rbFyouDpLYGvR2jg2JNUWy3I
ifhrOvOGiPeh32pxqVCEE+0raQiVek4Di87T8ukSnKgpQkiALZAGx9o5Yx9t
5USBgXtGv9jSYNc3J8eTCgQfOg9+YsT373tVvjYjTuSfVnTN0S0brHUiDtef
4UQFP63/3bLOhpZ34+7Ms5wowHK98MGj2VBTkdAdd4ETueTWydVKZBPfCeyM
Czc4kf6aavOesiy4mNNoPB7OiX52/Eg2nsoEa7HagANRnOhjqd2k6rdMsAh4
+9ozlhMtJ0c6vy/MBEPTLEH2ZE6kfM2xtO1WJmis3muSzOdEXo0amcMrGSB8
UsX45HdOdI3jfQHpXzpU/4o3yhPnQprFHLv7MlMBm0XendvEhQa1DtlGBaQC
szI479BWLrS87q4Xy7lUYER5khv2cKFd6W7uKzypEHfI6Gu/OheS+vPFPdmB
Cu6h7EbC1lyo9+PhLHHhFNghd9XQM5kLXbbiPzF9KAkmwrt/uqVxIY2oI+gD
OQlezxg9cM3iQjLW07SfDYlwqEyV6fyaC5lTQsm+YolgcoJTxq6KC4XfV9tz
PTce7l55NWfYz4UY8drV1z69gM7U1oQ9W7kR+2df7fyvkfBMSvtX1ytuxHLA
NcXcyx9s0nOjUdx6tCtayUi+MRxzHp6W9Etaj6SV/MrbVZ9i+g+llLfU9Wi0
uz37yKuneJGPmatGJ/iupMfpGxE40q26Tql8PQo/o86hwR+J6w63L+7qXY/q
ZhKXVg4+x/KdrOfJMjwI2bh39J+Kxy3uOkOndvEgbh+16mV6PL6z4eHVMFke
lPGrM47Gm4AbtPi8eP/jQeF8ByXraxKwXaboUw5dHiRQ5XniikQSjvGQfbfg
wIM6RU7tfez7CrOQTXf2Z/Ogh3yCmsLE7/kbVIpYWy4PSjLuTmOqU3G/ynfu
z/k8yImkWL7VhoqrrU1+lr7hQXbKKkeUM6j4Ec2Y/vQDD6oLkG+3/i8VCx49
pXh4nMhX+mGLxZE0fK+DX0blNw8arJ7KGbuYhmeufRaW+8uDlmtGLivdT8Mt
UQb/xJZ4UJnfl86Fd2n45cCJ0ikeXqQtoaWlhtKxjN9RSNrDi+L+XrwHezNw
lCC3fPQ+XsKfd0rO6GVgzrRa6RAFXlSmGX1uy8UMPPpRl9VLjRexV+nGtMZm
YLqETs2p47xI2rzxaxFbJlYuOnxi7Qovkv0+r7ZYl4nTj63TmHXmRcuWRdqH
ezOxWFeF7PgNYj/1QaPqXCZeYkP8rbd4EckxwkhVJgtXGGl+zXnEi2Te+V24
4Z2Fj/1SM7PO5EUu4lmjT0WzsabT8yOZdKK/cbn5I3uzscL43/0zebzILnGm
75lmNpYYo3EHM3lR9RkxGZJdNp4YlGIWfuBFFdt21ZtmZePei7fTWBqJ9dAT
3FPMbPy9vzXiRDMvivmCWbd/yMblveFX+zp5keTnCoULP7NxeCfrJr5JXnSU
9oBbUoaG7587v958mhfZvPBIDjlAw7d+vJlN/seLnER2yz7XpGHbNrfPqmu8
qK17u9YtMxo2NfvKvMdGQtoDzlcNL9Lw8Ra59M9cJOSj41ZecY2GFZuH/ewE
SOho6tU9TvdpeNfpI065wiSUsXfDeFoYDUs2JZovipGQ6vlWGe8YGmZvND8Q
voWELMt5bMeyaHj+ZOGmju0kxL7zj+iDfBr+9YnMs2MPCZk3/80ueUPDLR8a
+t8okJCwgVz/cAMNNxzf+YVThYTCu0oP932lYVx/742ROgl9VN2w6NpGwwVH
e9PjgIRmQtGvl900nFGrETlyhISaP5Svnhuk4TjdWH+FoyRkKHBWKH+Mhp/W
zDrd0SchF6FD5FeTNByobXy2zpDgsLme7X9p2Ptdjo7QGRIqSHC7fHiOhq9p
8SpYnyWh5W0sUX8XafhipYNUphWhz0ZdI41VGjZH1TwzF4j8M8bBG9fRsT6W
ntO0J/QafLbvKRsdI807A48cSYih2CoXz0HHSm/bvzRfIyH5QP1bwEXHuzSU
yzbfJKGJLQ/YvLjpeNObiAxHTxKi7Xer0F1Px4JqvyMLb5NQyNy11GyCOUtP
3GXxJ6FBcbnMNIIXVTKcT9wnIZt3de9UCJ4sYreIfkhC+l3lk9ZEvv7/Luj2
hZDQ5YO/ZSSJeq0FbxVknxL9lsbZXif6+agosdkzioSQq3OqOdFvxWsP3qpY
Qu8PjhOtLHRccODbHCmBmN+Ldaq/Vmg4k7F/0CyZ2K/CGhxD6JGwP6QxOY2E
4p4mDbX/o+GInNGyX1kkVKLhdipvmtBXTidTNZeYr7fXJylC79u0V1H38gk9
geSwlZiHXZbFNfEyoj9sSJ7oouGim2PHDStIqPOC5JHGVhrmPuS1M6iahKYO
1ISdJOZP+xLVO/ORhKgH2bPF39HwaozM271fSUis2/eFPeEfQ9v8WNvvhD5n
E/sMCH/NzDQaN3aRUExWXdX4KxrWLT+/n6uf6EeLIzCZ8GdM0CSv5jAJyY6d
/PuX8K+GBKkme5KERqNiZB28afge6KkErRH6kgY4IvRpuJm7RaicjQ+xh9su
SyMa3tFkNzXDxYcETK/5nVAk/GoXkGkrwIfaEisLborRsGDw242aW/jQw6A/
w8Ld2djutP6823aCOTyP3P+cjYskO5qzd/OhCu8Om/DybGyROx8qrsCHtMXC
w/3is3FysyLLrBYfmq988bPcNBvPxFd17tXjQ5J3dzqJa2djXQejUtsTfChu
3TolwQPZ+OfCNdfG03zI65PCjZ71xHuzOWsw244PhW9K7ZssysJVV6TrbQOJ
frXy6aJrmVhYMTc1NpgPfUQ+1a7Dmdh++VBAYxgR38/Y6PIpE/M8Oaeu+ZwP
3TerLTB+kYmNC6Lp4hl8qFdfdA7vz8R9q6SIxnpCj4Dxb3ePZeDVSrH28k98
xPdV5E9FuQws8UBGmv6VD5msM5iKEcjAJrwaOY/aifpYc86nJR2/F73aoDXG
h5QkDl4utE7HWfL1rIXc/Ig6f9t434U07Gb74GasHj/alWxhkyRPxeHbnzKD
TvAj7e713ca8VEwfjVvncYof9W4KM383lIKHrxU8MTbjR0pfhjp6YlOw+e2B
bF4HfmQpdsxZcC0ZH4o8PHgnkB/5VNHeMt++wpzvV0xsa/jRaPXXp/pSCTjN
Le15aj0/EtvWM6z9Nh7rbjv1Y/QTP2qUmj/x7lw8DvRPOn+9hR+x/GvWMHse
hznUjzj6jPAjxnJ66yr3S8zOeOgXvX4D8k+tv3y19TlmfSGU1WCwAcXc1dmw
bs9TvOa8e02hZQOq0EwrOprugA2rj8lcdxRASLvd6aFJDBS8nXW1dRJAnfuv
dqmWxYBY8avKM9cEUMisuG3BtljozVyw1nAVQOYj441c07Hg8iQzdr03wSzd
HquPX0K4xfoN1EcC6L7Y5bxNBQnQOFW30JYhgFb/4LnL9smg9NPt6McsATT6
LuZkQ1QyxAxIP8c0AeTkSD68Wp0MNi1eSmkMAVR3wSunY2sKTL3Zdf1miQBi
3HxeZNmZAgJBDwf56gTQ0RtF4gs6qWC06egXrRFi3fHGjvLf6eARUvXSZkwA
TZAz6I0bMyBuSeOy77gAim6bJ8fqZcBo+4F1zN8CqIJz7PPRhAzwjd6oeGBe
ALkV/PlCPpoJtA2/ozevJyO3qGBVZkgWNPleuXiIl4ysT90R68rPgrlfA/vP
8ZGR+VG5tOwfWaD1sa0umkxGJTPOlsd2ZkP7w6pFPgkySiiwtfUoywZO1mjr
5T1ktOcNPiHUQgPZGwJ7JeTIaD65bi1zjgbGvcFzKvsJnvktNCBGh/hyv/Cb
imQk8G/XXjULOijdvlL1U52MOFeuzzi10cHi50AYtyYZKbk9v8s1Rwe/s9bn
diAyavtavwMR36sNKqdnLmgT9c5rZD4yzIELMxo72vXJKJpiaXG9KgcCLxZP
/ztJRpKWN50munKA1nQACxuR0eXIigi2hRyYZ+wwNzxDRs3Rm/evyuVCmLNA
cK0VGaUlP3YSfZYLZcMDvwqvkdEWnrmFUhkG1DbFXc91IfoXm/1zex8DmsrP
/MlwJaOdqWMu/KoMGI2unXnpQUYXWjgtqMcZIKyXvXTXl4zWC4efeuLMgM2K
dndu+xP16gOmG90ZsGfzpjW3ADIqNTX+3neHAWgujPVyIBm5qvFXuIQywCnd
df3JMDK6FNvDC1kM8Hy297FeOBltXdEK+cdgQIDfIOlwBBkJBx6R8SlmQIyZ
qYBSNBkd9rIW+POOASlHNkTIxZDRu1cW0r31DMjZXye08wUZ7XUswXFfGFDN
pSYqkUBGZ2XGdvv+YMCXv9MxQklkRIvILEjuYcCPnmwJvmQi36P0k5GDDJgq
3iTFkkboHdv2X/cvBiyltCQupBPz+S2kpzzNAM7wJ1v+ZpLRrn0Jvy3+MUDy
8rrtw3QyUr5+KXL9KgN2mjDTenLJ6L++b+bP1uWBArq5qz2PjL4tzGiPsefB
IVnZrKZ8Mlr4dECTlzsPjooN7f1YSEZfKr33LPDkwWn2BHpNMRm1/9Wbes2X
B9ZTpvtxKRkFpsV6qArkwZXODXklb8joZcY89ZFgHrjV1Sm8fkvsL/O4mCac
B34FdwuyMRkNrOW8CBPJg+AkNeXUSjKKMHivqCWWB1Ehf4sT3hHnpV4VqxTP
gyQv2sGYGjLKCGpT4N2YB9l2l948rSWjQ7ZfnaUl86DIUOrQ43oyMh5KLWDZ
lAeVGq3l9z+QUafDgb/ZBH/cFY58PxHx2h2UrVJ50Cp8rMrzCxlNKj1ff5Hg
fhZW7RtfySg0d+jNNYJ/TTBrHL+RUYdms4QOwfNtN/XsvpNReseK8DCRj61G
tt6qlYxstB/HGhHMnzd03KydyH9aMSaI6Ec8PuGjYQcZ2Z9WX/eQ6FfmkdnJ
413EfhPPGmOJPNjvLtB4pIeMDvgebxkhzqt2od7oUB8Z4fPp2/VE80DHIOCb
8gAZPTwskOZCyQPDg+pn5IfIaPfN58fthPLg3PaZlt0jhP9iezi3kvPAnkw3
3zZGRjwLG79k8ufB7TEpS5FfZGRqK2Qmup6Y34m0c2q/ySjuBN/7Yo48EKbL
nbP+Q/hPmfFSjDUPclw0LNJmyUi+z/XkxkUGeDe9O9swR8QfMhB9O8sAPaUT
ZycXyCg4Vldq8x8G9M6dNVdeJaP+vur320YYQDvbZ2bBIoiUQqwt3vcx4Nab
y2a+rILI2uGwwO5OBgj6eZq+5xRE+8y/f9nXyAAdzigT0w2CyGddtY56IbF+
WdLEmyyILFUSQrvpDOiuTzmdICSIqDseDx9OY4BX6GvjYVFBJHn7TNPRaAZk
CTcaekgLIrGBLZNmNxng4WFm+GKrIGJ1PU9ZvsKAI23dp8plBJGJoqaLjQ0D
Ol/+Osm5WxBVM5P6rugzYMM2XoPoA4JIppb83n8LsX4/Qp+pKIhsa5nPd4ow
IGNYXL/7P0HULff1bxgPA7Sydp3YoSaI7ts9IMFQLrgd0D1WpEXwFdvyZ365
gJ59OvpDWxC5qS9H/LLLBb5Zk6OruoKIu2D/s/pjuZBWclFP94QgspEVquQW
zIV2uKvTcloQzeSw/siIy4G0V9w6i2cEkayvMJe4bw64soVrS5kLos427l7S
+Rwg1SYcsbcURBVVG939N+eA5smyw//sBBG73CQ1/gUdUiznDol4CKKjDyQM
xm7RwET97TTFSxDZ0Z29DpnSgFPiXjrFWxBpbHUa26VAA8dWfjLFVxAtH3+Z
/n40GxSMdwwKBQqi3umOXduNsqFK70wwOVoQjW548TeHPwv6FfJbSEWCKCnx
qYwGpEMk+dZjUgmhr6jJd/KGdNCd0kQkpiCqM8z0e9SdBln0hkzeckHU2CN2
xcYnDVx39fvwvBdEUy//cyzJT4V1UuRt3C2CaN5jd/9NMhWk11+/zvaP0ENf
fvBqSBKs4zspuTBHnI8aYhNqnAT9AnL1kwuCiBbWbXFRLAlSxMa3/lgh9I26
WGulmwg7djm0MDiEUOOVAuc0x3iQ1Tt/yJoihLifH7V9HhMLKg9O8ZYqCSHJ
w48teCOegtijfSU5ykJIyU83Lo7vKcyH8F2iqgqhmXM3VMsehgMz8kP5Ew0h
JJCtb2y2FAYaVD1Xe20hNKVb2NlTHQxa76BdyEQIyefrx1w/EADbaqUC15sK
oYrKZPRi411g/7CisGZGxNeFeZI4/KGm6U3Iz3NCyIZLzDs1+zYc7VdBlReF
EAvFTPJqtyvsHhb5VXSJWD8RPteS7gI8P2djaQ5EPnafx6s9TvDhT/7f51eJ
+BPOTNWFi0CbjUgKdRZC/iJtG2+yn4eQhRsG964T/Pzv03dkU3BeMVz0ukHE
n9bJnFE6DuZoXv2PK8ESrj0KXgfB3/mhRo07wcPP3933UcPPZoKXczwJ1nGo
oHScxG0jQ0a/bwshZD9b+zHwAr7w+eXy9ftCqPfqSJrZK1fs9pLL+EYUUc/Z
7wKX3j384r+e5ZvFQiiGi6WFXvYMD10JM761JIQebgy+5cBKxU423gruK0LI
h3/ikq4BFc+Y2gveWBNCkRXbxPljqJhdW7PpMpsw0la7sdNELhVvlZo0MucV
RiYaEhtfmaZhmyYDI5WNwsjnwRN0PSUD/1DjM5xVE0b66745mm+mY9sDC/v/
aAijyLkP0vcv0fHPnUMbfmkKo+oLrI3e2XS8IPz2y6CWMIrreG1Wo5yDxX47
nWo+LowG+ThKC47n4jMpH0/mWwijF/fjyVH5DNzIG2Jww1sYNSQknZ8sfI3F
vXSzn/sIozCTO2tWra+x7SDL+nJfYZQUceFb3PxrPFvmXs1zTxhd3t9c+kAt
H0tcO69OfSyMOCX3Lv99k48vNSrsbo0TRlWODyrKCwpwjsavwJUEYSRt9oW7
o6kAz2ekD257JYxkDLRk3k4V4OC7kkkuqcR5ulvuNe4txAwFTlGeHGFE7TYu
35ZYiBcj29kPYWHUKGPesHSrCGuvi7S9WCmMZlJ0zslHFuFQ55MVj94JI48X
B+O25BRhad13t1tqiXqHVKdU+oqwzhxt+nqjMFL9q6wlo12Mw8/69yb3CSPr
uepGv+Vi3F6jplk/IIxOfkc9GoIleKvC7MvfQ8Io+dRsI31nCS7kcTTT+CmM
SL+mVTONSvCPN6c/f58WRsHNvvJzr0rwdqmdZdzsFFRXGzN+S7EUJ+Qukrdz
UlDEyrjb6JFSLHL4s8NhbgoKzn4cwWFSijnt3IW8SRRkOaeUdOxmKR7OfOc4
LkxBR3mii8fppdha/XkFlygFlW8yjah8U4pbPjqKyIhT0PvdXge16kvx+9/k
KstNFOS4VCyoNVCK0/6zEf+8nYJ0yzjF9gsxsVSt4vWfOynIxlvg1kkpJo42
56rh3ENB1mzAQtnNxIG3c1xgHwUJ6HuVRB1i4lVSwPtz8hT04koG5yk9JvZI
OCPppUBBIg+PF9INmdihcrmWoUxBZbHRbmdtmbjXuHHTJ1UKqtIQTk91ZGLz
wZSbY2oUlJBHvxPlysRHuU5s3goUZH7R64L1XSauiJFy1zxMQWFFxlHKD5lY
dc90g8URCtJ3iWcywph4l0GsxzM9CmLVzZB79IKJk7qdPuYeoyAZK7704UQm
FnNBWz+eoCCt/fuvDFKZOHydsNeoAQUZX/fiDchkYu5nI5/YDSmIX3lhO6Yz
sb/Mm21bjAl9ZC8bvcxj4vnCsFuHTChIqnDbTpFCJnbRs/1y1pSCPIQVD+8v
YeLRtv+2e5hTkNpzPbVhJhPbOK6/HWFBQYvFb+lqb5m4bamzMceSyH8kQUUW
M7FhKGPHB2tifrcS3ZgVTFwndd9nxIaCsg7sYB2qZGLEMGtiu0jMe17XN7uK
iUsO790lfYmC+vfVBvG9Y2L5b6t3NBwoaN9OqXIegjPtmr6ZXyHqH/aoTCbi
t/5L3e1+lYJM2HMUvhP5XgTd8nvqTEHXVM/mvyLqCYobfKdfpyCnlcohLqKf
4CzpvQ03KEihb8yJi+iXVWPGf/gmBe2ZCZ5IJM7j/am2hdWDguw7xdZ/LWbi
aeuXspu9KIh7pNLhRQETO05dC1D3piBfMZecJQYT99/VajPzoSAe9YZ7MzQm
thAS2efmS/hvXOnJ/QwmbqKO3Qv3pyDptG9e2SlMfFz5bTstgIJGPz0au5zA
xFW14fvr7xN6FC8Fl8UwsdpZuwdDgYQ/cp9wpUUw8R4f3gNSjynox2QgHHzA
xA+DN2mIhBLrv80HLvoy8VDMfj3+JxTkuvcS7wFPwg+Fp61WIyjos7FAT54D
E6+8u3T5XySR/1gc16XzRH9Nnjcnowk/zhzKKTVlYsrvl4+6X1BQuPJ+D11t
JnZdoUe2xFGQ4WYVcV81JvHeVSR+TiD8z3x/yFSe0G/XYGF5MgW5HEqgjEgw
MYutbH9CFuH/qKAr98eJ++ii+SuaRkGkr0N3SrtL8Rtfw/mwHGJ+uzarhn4t
xR4v3fj9XlOQm+/esg1FpXiiuUztPJOCqpPc5r29S/Hxgc86ZmXEfCIF5BId
S3H6n17DU+WEn+zkTGwsSrEtP4cDVFFQ8vtbtBLVUtyqZ/BscwPRX8YEb9lU
CVYyPZ8g+pGCitiem1Z1leAIuxuZGz5TUMaGmfV2DSVY/24UXvtKQRaX3Ke9
kktwFbNrvKedgpTPLg4NGJRg6frf/1o7iPviPxdSoVKC77SuY23sIvz/7PEh
lS0lWHVmu1hFHwXNT3wTm54uxjly17STxgj/SExcjX1ajEka/qdixiloeqmX
X8urGF85HmER/ouYRy7l4T3rYizjUOTi/4d4P/TqXRp3F+PYpNU4mwVCf8X7
V8PeFOH7Qk9mpdeLIOTK0uH3oRCnPL/ue4RXBHl53aubzijEVRsNuez5RJCa
XeF/Px8UYhYZsng2WQSZyk+L2GsWYh+lZxr/SYggV6PBgbDMAux+5vm9Y3tF
kMemW+5PLufjyHZPkpOcCHIM1b6gqZmPC6zMo8L2iyDvVwMXXITy8fQl8fRv
iiJo39APR6uy1/iax8sGKw0RdI0Sa2rB/RrbP08kuxqIoHAXmR9tDxn4wUb/
F5GnRNCP8mtfC0wZmJpos63YSAQpX66/LSTDwP3pW/5bPiOCJE3kJ/K8c7F1
SYp5oLUIolm/28HTTMem7emJL66LIJ8p73XNZllYbyND7t1TESR/7EFwOTUZ
60t+uVr5TARVC0T9EtuTjA03TWbiKBHkknRRPD7nFTbfLLujLFYEkXjpb7cV
JmHHbRlSha9E0MO7s462LvE4ZG/ShvQ8EVQ3zHNEWC4KN6mH/wn+SujrN31d
2eEqbtHI3f/omwiq8BzOzRO3xR2HPjsHfRdBLH1++aO+RngQSD/vtROsPDq8
U9kEZo887PfpE0FJFdv06hS9QEzf/9u1PyJoqtXk7uD3J2Bt6VJoTBZF5RuO
REZeSoanARnjukKi6N9gKYfPhhSozujdok4RRd5/5ugizBTYM2sYtk1cFPk0
g+ZFcirMhR5wmJEWRdLKw6eO1qVDOJ4Wi5YXRY2Cz1QLTelQtdXdp/2UKApw
P6BQ6FUAO8ZuHbEJE0Vqqh6ykncqwGxYWodPRAztNZj6dT/9C3RJOkSnR4oh
Be9/Z9XsW8F0u8ZQZ7QYWt0/vWnXw1ZolCMrCcaKoTJ/01uCWa1Qpfnmq0+8
GFLKCuLr/NUKGTYb+IzTxNDWrfH6Gu5t4EotvrdcLIbC509sWQ1oBy5Z7htG
HWKoyu11x2RMB/grdeHALjHE/7kzbrW0AxY1XvOX9YihtpkjdLaODpgwsKTt
GBRDy51z3yYkO6HpOmNkaYLo71zioFJSJ8Tlm1unrRL9uWyLvULtAkqZHL2D
RRyJrFI18qu7IKyadVmATRyxd49HTQ52wd3vtNjbXOIoLi34wcHt3WA/x/Ld
UEAccfp6b5ZI7Ybete/bAgXF0eBDCZXx6m44y53t+kZYHFWFrR6iDXaDvvgZ
gR3i4shOtUdlZVsP1GzZc/7cRoKn1ZghR3pAc88aPXyTONrRHHuc92IPlCg0
L9dsFkcTl4cZXgE9cEA988TSFnGk+mZbYfOrHvgfBd1XZg==
      "]]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwUV3k81F8XHrJlydjGkiJJ6qfFVoqcmxSVbEkSkpQlFSoJSZJsCVnLPsNY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      "]]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVl3k81c/3x2VvRalQSRLa9JEWRV43FRWhSIRvSKIoO5GUNlt2CUkSIsq+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      "]], LineBox[CompressedData["
1:eJwVkns8Vekax9dae3eZigiFnNrKuA21j4o9op5C08WtbdSmGNcyqHaN3CqK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      "]], LineBox[CompressedData["
1:eJwVV3k4lG8Xto5lMIsxhiRJkjakXZ5jiaRs2ZL8hFDZQ7SIqFTIvjODsUt2
Qh6kQippoyQJSYrKUlJ97/cP132dc+6z3OeZ6z0rnbwtjvHx8PA8If78/39p
dbnZngQB4BFPstgWuQcNL7RN0VMIbLvrhhvJDCWKajIWCwksv71Ep9IZLW1i
OXd2CQBnx2t5/qAA9PjMMM8xcUEw+/K4zoZ2GZ3919ydTSOwzWnT0rbLSCUi
LbFfShBiu/dd1fO9gi5GW6jslxeE0CaGmOrjSLSN02G6eRNhv5G6SzXkOuLc
K8rmNReEzkIR/TnbWORH9dXKThSEmpAb75cUktBkTLfPjVRBYBWJH9d1TkJO
4kr5oZmCUPTExu8zNwmZi74Sd+YKgo+BXqCjcjJSE9j9bk2NICyd/2CUuzIF
fV0Qvlj5TBDOtX6dnFtIRa6BTnW5rwSheZ1yevqmNDQ02zSZ8EYQGrjxnZdd
09Cjb14HAz8Q/vdu2G/qS0Nln58r7fohCBGHg28mc9LRiXecBx10ErRW/ZA7
y8pEI0cWf9cySWB/xdHgo14mshs8qFYoSwKeLUbeEV6ZyGiAlHZVkQQdoiun
97dlIpVnHidMNEgwcUpy/7x9FuKY389GW0mw9Fd2qissC7F6VzxT20mC2Tin
6/fys5DQo75dkrokaLhl1aL2OQuN398u3m9OApXvqqzmk9nIYU+8TpcVCfR9
Yotqrmajl3c/BzQeIsH+RLeHjwqy0b3W7KHMoyRwFHaIchjKRlroJz3mGAmi
1rdkPv+ZjWrumBteOE7UMyar5E5nI26jQMVRXxIM1h/oGNVlI7kdDqMWASTw
b+sP7znERon19Sz9YBLMyPcJPfFmo4iaE2HKYSRgpW34sTKNjZY0OmqlL5FA
6+rWrb5lbORfuXxS+CoJhD/wzvW3sJFzea/F51gSCHw8NT49zEYOrAcX1ZNI
wEgLiBr7xkZ2F+9UnU4jQecyAfdRHg6ymqoeuZNFxJsVpOwX5iAz6xK6QC4J
JqdesNZROMi4laO7r4AETpNT1RekOMhANcUvtoQEkV8+b9m3jIN0EqNzX5aT
oOrwWZ9rChyk9Te8T66aBD/3Tu2A1Ry0zf0Mn3M9CeTQDs+TazlIo89Ho7iJ
BEXDpEnyBg7aoOXmNI1JcO4YN3GlGgepFByJ39JBAoVvZOsyDQ5aRbVsP9tJ
gssdI8vKNDlI/sy+7209JKAaBfcrbOUgmVFQFH5KArv57oui2ziIYbLNwuQF
CWLoIczjBKY0bLiYOEDob/whQYvAoopKVa/fkkBj49y/CCJeMEp2RGGEBKq+
Ni66WziIZ55KdxsnAZ+i9RP/zRz0+z8h3ZuTJIDC0YNy6hw03/XH98dXEvRn
Z4rs2MhB3zbP5uz4QeDkZrGHqhw0lTX59MICCSRylEP6lDnoo9B73vu/SbCv
1SHcVJGDRnxfqYvxCIGW+lUD3eUc9PbNo6MWAkIwFe0+XyLNQf17OuJShYWA
+vDw/as0Dnp2q7FtSEwIfGj2X4dEOeixTOU3JZoQJPsulpTwc1DHlyzzShkh
qJk/9/LARzbCNolhC8uFYL3G4z+3XrBRY9u1yt2KQvB8l30M7102qkg6TetW
FQL3a3tuBKSzUek/Tx3qJiHoZRq5p0WwUcFxF1/rzYQ9vOfsLU82ytxt/nRk
lxDYN0RfrtVio5RCQ961IASWltobCxXZKJ6mre6tLwQ/6/V9Y4TYKHJMNe73
foJvRe91ncfZKCBawJzhIASZZ9eaWZtmI5+FxVA7JyFoiIl/St2QjTyOfqvg
uArBxNkb1l0i2chpyxB1g7cQgN9lvR2tWcjkbX3vnlAh0A/39Ny+MgsZGZbz
REUIQdA6vQTSQibSr+Sq9UUS8Qf59759mIl2XoqLdYgTgtSTwTolfplIecNJ
s9O5QjB7Lt37S00GmoodmvQvEAKxU7UKFy5noKpZ80t+JUR/Usl/9Wwy0O7m
7Y2eVULAOqD9ymM+HVkak5Rc2on5uvA5Oq9LR2HHcxbMRoRAxf/5jR2+qcjg
ESPeZFwIQo9culS5NRWJqUeu3z9J1GMfFhfwOwWl/vQ6avid0PPt4w8TF1NQ
+RWth7v5hMHyykPz8qvJaDD/VbaqojAo+La7HwxKRLkixjtUlIVBzd71j9vm
ROTu2fJstaowpLKTG8e/JKAfmvnCKzWEAdR3P1M9moBEO/z8pHWFIXbe3F1I
Jx5tHxE3EHAi8PnsFW+f3EAJ8vpf3uYQmDQut67jEqrr+XT6Qb4wtLpT9qcp
XEKvz9zgqywWhuHqtc98z0UghVevpSMqhaE3x8PcXyMcld3w1VVtE4YKr/Nt
kBqK7vOwUwKHifjqmkmF7EC0OPJLh7JCBHi6/Vi89urIykC2x1OBwFq3/3bG
rULUbc0hBmsILCwYqcXUwi5fJt8/VCUwpzum4IEhvpIR61G7UQRCrYOH1fab
Y4blmpTD2gQ2yK05csoZb7hnOVV4RAQci7cd7Q70x46Ft5IhUwQq3qbr59VF
YJLOd7kLHBGgUoNE5t0u4ZuvNfPucAn+iMv9cazLeFG88dbOmyIwI2UA0aev
4ET/jk7NFhFQE1qr/W3dNdypM7CoMiwCvbfFffyP38Beb5aFuY2KQOSSca8l
KRZLBTgIFUyIQL+1+zNXm1jsVPRBctU3EWApMo+ML8TiJYmv65fziUKR0nUz
EY14rDbI9x9NSRTct3iSsyIT8cuAPWOmKqIwoWi1ENCbiM9TIk/GrBeFYaPc
qCzpJNytKx5E3iIKQaVqWk/ykrBLsXScoIEozLg/rzpbnYxTA9ff/eX2f/sN
PsHyVKxN9Tba7iEKFT5Fvxs+peKx4songT6iwCPSfClVKQ1rvN06+CNIFLYr
Nh3vS0nDPXo6c1+uioJtHbT+PpWOeWjWa0ZKRYHzbE9MDG8m9uVKsfpviQLL
PZRXdn0mHtn2QvhxtSj0q6p/fGaViTscLCdvN4mC47I/yx4XZOKrZRY34x6K
gsJD5flG7Sy8iOjZV56IQqqSHDvVKQt7PHsac/6ZKJix6GcyLmVhk0Uzn+Nv
iPk8o6eJdWVh+l7TzTqfRUHFUCgzdE82Dn8jobRtWhTUdg50n3TKxrNejxkb
fhD133hxyj8kG79MOjDP+i0KkQYava+rs7HhWvGPEv9E4Wd0xPutj7JxQ3PP
KwF+Mqi4fVO5OZaNMz4Y354RJYOa/7j9mCQbi50ml4xLkMHdl/Imfy0bh4g+
TB+kE/Yb7Krz2mzsqL7vXKcsGVJ1pAZ8jrHx0w4RzxZ5MgzvXfxy7TQb69p2
HalRJEPRmMnE7Ug2VrqwF3FUybA94/dRyyI2TqILqyVvJPja9w221LExqeCB
QpQGGUIb/qlrdbDx6R1XaBe3ksGxUP/bw142nugx4AvaSYbevPlyz0E2PuRI
+uGpTYYJmWLSyo9s3P3j3gdnXTL8FClOH5thY60rl54fMiCDMJOH0fSLjW/K
7rlnuo8MZhW74np5OFi+XKBujwkZZpcfaDEW4OBYnY6CXRZk0LIanDYR4mDe
F+Ep6tZkyHw1K/RahIP93PUi19iRobmeNDVF5uAPv/mClzuQ4Vz8x4gr4hxs
eaP9uKQTGQR8nrUUS3DwPcWLdiKuZNCP9rx6kMLBW+t0jP8dJ4O9eNurCAIX
GvFqzXmSITFBh7ObwKy3res/+5JB897DwfNE/DWf0OXvA4j46vxrewj+3/wg
8SqYDM/XXyhJJPJ7pPz723OeDAq/fOEkUd+QKp5uDyPq/cVr2UXiYNOWkOGG
S2SI0lw+U87Pwa3m2k/Lr5Jh8P6yVXJE/+pjf9q40YR+5y/8WfmTjXOD7lSl
x5GB585xtWXTbCwpdj4vNokMrCgFqtIYG0ewtRIvpxF6inGea71m4zmNpYhz
WWTgbK1tPvaYjV3vNwX45ZChIWtJnN3GxkZfdto4FBN69aQp6eezsbZHil7x
TWLfXtyPsklkY43PPzbNVhL6fryjfPAiG8t+KhO+1kiGIEkFccHDbCzhLjL3
vIXQM8T9QvMeNub/eOz9iruEPWWDt8MmNp4alW+sfUiGflgf7PIvGw87ny3g
6SX0Vr/O303s84uRV/HGzwn/1YWf5R5m45bh2JPvBwn71k7ZmPhsHDvIt1z8
KxliSy3e1jGyccTh/0Rsv5Nh7+HUP+zvWTj4ddNc7jwxX/s9s+efZGGnfv/H
2/+RIXJe/pHc5Sy8+fn4BReqGFRIHlokfczEKgf1PG4xxEAtcbN9fXMmlutj
2y6yxEC4972xa1wmFui1VY9dKQasjbts7m3LxC8fdo80aYiB7RpuXEVQBu7e
t+YJaZsYBI2WpJ43yMC4K7zJfJcY7H3EoFlJZuCiB1qJH/XEIJJ/5cTaknR8
5m75HkkrMWi1Pr+Y3pOGlzfFF504LUa8L4Hzm8dTMH3ndGLtWcLf7Pq58/kp
mHTbOIwnlKivSah/2jkFf60TsEuOFIPUOf111kPJuLUqkNyeJgYNl8cTXbuI
39MSOy+ZZjEoSilWST2TgOtOfdpn1ioGCuVDpcMbE7Dw7qA1VzqI+FZ1nfMj
8bjsSdLwbI8YDH8+YdpsGI9nZ3stet+KgbsA40eyaBwOR4bbrvwTAx6cXD/9
MQrnPt/MM6crDlRHkxSP3jD8/q9YfG+XOLR2zX5Q0XBHf9tYAy2PCCy21vOR
wEkke0lJ4eZTApcEp9FeeSJLslb51QFxGN7z1Vjyji+6L32yW/cTgY97tK60
P41K1Lr4aoUlIDZ7u2QShCF/p0un0gwloMJ8rekbShSKXR3XeMWYsO/YZ8+p
j0I3JzJ5A00loPevAbfUIRqNe9XcsLCRADhJPR1WEoNsz34oJbtJQISbbrJ5
Zizanagzev6yBMiZ3HllLJWASPf/WDrdkwClm17fObkpqMC/ICW/SwIEpGss
WVMpyGCV6euJRxJg9jrb/5FmKrocyvnP+6UEjHY05I/fTUWCu/ROnPtI5Ht7
ZG1Mfxrifvpchj9LAEOxvqxsWTrST02c5puRALWQkT+zR9JRxNyY/9WfEtAp
nX/t17t0JFAReSFZhAKaH+aN4wYyENdBvX1AnAITKnck7kgR33virwWW0ynA
ODJlzmOeiSJOrLuWJ0uBnqbJ+o6OTMS/+nFixToKnLu1Rl00JwvlPgt89WMT
BVrl0Gzdiyyke3GF7DZNCvH+6bUniO/Ni+982He0CHvPl5B3ntmIL12ypPsA
BTo3KDC7Vdkod2/zlLgFBRTkJ06dsWEj3QWXTebWFHAZOqG1KpyNLlrW1bxy
oIDjaJGDzSs2UuT/b0HWmQIzs90B7/6xUXul0E4HNwo4vDe6XSbJQbyUQ3jU
+//xkWdidnAQ5w4vn4o/BTq+ybVUGnMQeJTonwyiQEGE4Py+IxwU2vW761so
Bfx0pf0HQ4j7JCL7+d84CthWHP7l3kTEaxhK6yZTYHTQlLa2i4h/P33oUjoF
QgVv/jj0kojX1nlHzqPA7N1D/eRpDlL48mmlaSFR3+oL968vclBrRrxLfCkF
evk6rM8I5iCeXx8+sWooEHTM2D1HJgdxCqPW2zdQ4Kd81GK/Yg4C6y3e7GYK
6F/4bnZ+XQ4aFhiqHGmlQOK3tn/Rm3NQaPXl2dX3KLCP9ZstuisHKTht2na8
i9Bjg+OT7zo5qJXaH1z2iAJl2sFqBntzkCMObZ5+SgElvdQTAiY56J/n2n8a
Lwm9yW/XbjiYg04wTcs2vKZAX0T6aKBNDnre4n9IZYjQK9l0cPfhHITc0kmr
Roh8R1X6wxxyUAmltXr5OAV4XHjzdI/mIEbDmCNrkgKc+8fJoc456IIjWULy
K8EXmf9hx7EcNCms3iT+nagn+Ravj2sOsqy0dheepxD35i6k6JaDWg6dk+Jf
pIBwVUOwGYHX8uW2//lDAY848/hFwn/fiw/blniooPly2lOBwBeKA2N+8VEh
sVtrrs0lB9WcFxmbF6CCvkge450Tkc88c9csiUrob9p82jEHrVDeFP9NmAqc
GM3h60eI/IttE19FqSAXLhS0zC4HXX1siabEqMCw33NB2ZqoJ/dj0icJKtyf
UJ8rM89Bs4FnpsapVGgXHBgs30/UZyyuN0on6nGk7F5vmIMcVnDS3jOoUCV/
SmE1Mf/EHxozQ0wq8Ph6JKXtzEF/M2yzBmSpYGFXGzpH6LnZ5/OPl3JUmJB4
qPx2VQ5y1w/Z91yeCkoLfC2wLAc9m8pbeKxIBWXBlUbnhHOQcNtWkx4lKtD7
la9b/uUg7aQubpcyFbw6o+2Kf3BQ0e5p8w5Voh/RU25dg8S9S7tY1LaeCrbJ
zrSkXg6ijzP+tWykQrxP6sqhuxx0PmZn2W0NKjRvND39qYiDqpwe8dVrUiH7
WphhWToHTWx1PFSzlQqdojYJX65zkMW7S6RbO6lwrrl5cMqDg65Us46UaVHB
g1c2vNSeg5qvlFYXa1OhKLdy/hPxvtaoPXXk6hL99dm3flThoKVQuaa0fcT8
m79Ijt5mI3WrW7SU/VSIpfjb+sexketaXfdEEyrs37L4QdSdjZ4+dZO6YUEl
7pOGKhM6cS8rVntH2FFhlGfv7wOHs5FZh5GS9wmi3yG+w2tbM1HNnTk/Jw+i
npv5r5quZiJWfU6blRcVFC6quPpYZKLh4l8OWn5UqPibRdnzPgP53ChOEzlD
5K86bXN3Nh3F2olQuFepMPNF86DDbCqaPVh7JOU6FYZlNKRwRSqyPXC07Fo0
UZ/oWqadRypSgNtGvnFUUBuMqd7zPgVVrD4eoZ1GhaXCkFql9mTUO9P5q7+I
Cv7LExTZRxOR5qT/3p4Sor5L3wvO0xNR6geFFFxGBe6Yi3dNewJyfBmkWVBB
BffmNpHNKxPQTJOK96kGKlDDL6279TIOUa9Ejop3UqE3VKKZbhyDzJfvfaL7
kai/WPXgw3sXUWBUe4bjJyo4+m2R+zYXhjJ/a7mHfCb6D/wkrLU6DE0MqPM2
TlMBrFKu1PNdQCHJyzar/yT8ub4PfzsGoTLKdPIKERqEJnQb8bUdQyS+ZIcl
VRoMz+bdPlvlg9f7UtfJbqABHPauXO/lhy2Gry1s20SDVu+Gb0/X+uOslgux
pzbTgIcv604L5zTWPHu8fXIXDRT6ip5evh6Cj85qKQ/spxH3Mj9lcdVl3Dz+
4UutFw2EA2IK/7sThx/0ZXrf8qEBa5kG+rQ8Hve1WH0r8qNBpJfTfdGQeDyR
/GA2I5AGtiHjFNHdCZhhWPo7LIQG/TWvfhfVJmKPQj8RkxgabHeimHyOScGn
E9ZdN4wl/ANMzLI+puCLF0bFdOJp4PNmvWgjSsWpNtZUzWQaNNCab6t8TcUd
QjulZbNpEPThnM0NvXQs5867evwmDdxXhX3c9DgTr7FsLHh3iwbUEuWtB+Sy
sAacUhmopEHRF58dpcez8F7W2LqeWsJf78nJFXzZ2L+zU6PqDjG/lMj3ecQ9
1KMSCyGPiPk2XloIL+LgVwyj9tNPaKDycYhXuIuDR3j49H2f0kAsVTtT5hMH
/+w/ZejygsCeG1Xfr8nBSldtTPa9pUEiOjb5gZ2Dz36St2d+ocEM9r/5LCgX
7zUuOLxzmtDDeb3w/YRczLi54bDDNxq4xM3+ky/PxeU+WnYFczSYJW/S4nmf
i4cXDtlu/Uvw/9218ijKw2WH3tvY8dChZuplyHGrPBzc5G4Twkcn9llv6MmJ
PEy/cNr6PokOM2eYFVUJeXgPKcnSmkKH5hubGHVvCbu7nOUZGh0ySfN9CV/z
8FBX3sFsSTpUjN1T6/ybh4OiqyzGpenQcWlNsPpyLtaf3mEhKkuH5zm5nS7r
uJhm3ma+UY4O4EYO+7ydi0sYvWaBCnQoa+tWmzHn4sBAG7N0RTrMjrHrPY5w
sV7/kGmLEh14VHzu73DnYupOV9MRZTps971eZe3HxYMZX0xIa+kQ+r75ZftZ
Li7+42+iuo4ORV4WCecjCL7/lg6YbCDqPaxkcjmKi3Xbwg/4bSL4Lmf6DSZw
MWUV+UCyOh1io+74Xkgn+CLi9zdupoN/19p2Lw4XF43L7B/aQvSzWnW4OJ+L
A/bmGPNtJ+Lbag6olRB8JSrGyjuJ/rxPxfOWc7GEWMW+fVp0aKB071peycVv
PLft89Kmw+itwcGL1QTfkxajeKCDQGyShEYtF/urGxjV6dIh8keJt2odF0PC
o72v9Qn+Li73JIHF5yz3/jWgQ6LyiM0c4f/aetBQ0YgO3PTsHQ9quLigwdnQ
wJjgM1v4N1zFxadkPxucOEDkF5xx1a0g+M75GcSY0sHszWm1z2VcLDb0a0+V
OR2Cpj2V3hRx8QAK2/PyIJGvL59K5xJ8OcJ7Fq3ooNT1ufNGNhf78cfqy9sS
+SaE11imcjE6Jq2va0fsx9J90f/iCL4H2Xqu9sR8DGYPVVzl4n4VZb1rDsR+
ibrx7A3j4vxrN3XLHQm9v/HMrA7iYm2TZp15F0IPfC62xpmLRSv0dGTdiPn0
BOods+XiV7SHoH2cDnvvPdKz38/FPi8G0GVPYj5y3aeWa3Dx7m1HUYk3HeSE
D778uIqIT5vQfuxL4D/8Uz8ZXJxnv7CbGUgHNQnR19Ozedhy153vUkGE/Yly
w5/RPEySDS+UOkPoNaVy68TzPHzilQRNKoQOHvHW2KkyD2tYKI9KXibqW2qx
6HPOw6NqU6mSkcS+CVS2vTPJw8mUqgOS14j9jFbzM9mRhxd7dtfTY4h+B1YI
movl4XZDq2u0ZDpYxmfOzZXkYn/lZYiWSgdqNvkgKy4XKwu+/0FNJ+a1Q8aA
HZiLr7V7HKFm00GTXj09iHKxxe4INUoBHbSqjd2UH+bgEY3ql2J1dBDbN9se
fI+DE2nB18Ua6LD/xfvD63I52GBGG8Qa6cCaGi81DuHgkpvdxeQWOnT2bEx7
o8nBfioj50Tv06FXPiiQvZWNeeVpq4RfEv4LG/w5mZm4aunlK6F+OqTq5BmV
6GdilzeZUUKv6eC4/smj8s8ZuDNVZZ40RMxzvezRiq0ZOFYSugTHCb6tVjzP
WtOwgoi3N/88HWy3ll/LKEzGvOImcr8WiH411YPddZPxCHVD19dfdJgwDDrh
MJiE81ifFV//IfKF2+16Ip6ElVXcXlYISkKR0hc3slsCXm/4324HKUkYHonN
D5i8gbddMiXf1pQEanfkqf9UwrAJr1qh1ylJ4Dl+f2zZo/No5szbpzEBhH34
5+4VAqEoYfbaUvlpSYC/R789XBmG+j+OmU+flQQ19dUd5kfC0dHHGUveEYR/
0Ie1gs+vIP8MIQvfJElosJjf9eJwLErf8m7pVL0kcB5GTC4TTUNat6LWJN6W
hNaBSW3juDT0TmWnRU2TJIitOnrvi3Q6UpJLKpzFktAzoCcWvCoD3eQztgjo
lAQWX6nNys1ZqPVJXWHgANHfjJ2uXioHjR2PsQj+LQmDU/xmtjpc5OF4RiPg
jySIOi+GfT/FRbPWrnTff5JQ0mkSI1HARQL62n3u/Ayw89254p5wPlKU/2pu
S2ZAz60i0d8P8lEJ47W6pTgDaq4oTfjN5yMN8n2aGYUBPKVbqx2UCpDOz6yn
hpIMGJrpOXA9pAA59h0w37aMAQWdsi9F1heiic4d6puXM8DpTZvJd6tC5I1X
0zatYMD36J+ndS4UopCyP73KqxjwvMv1tHhvIcq6fNOMuY4BZ7ZxVqidKEKv
d4qbze1kQITh9+l9F4qRk/qvTd+0GJAe/pE9ll2MJteMUb5oM8CxLG3p8Z1i
9Itx58moLgOCalK0In8VI9a0h+nzfQyoiIna6e1egjhjtpt69zNg8OSz1EMX
S9CaQX1KjwkDlkL+k4jMKEFbu+Se3LVgQDKs0C97WIKs8npMqu0YEItnZqYV
S9FgWsPGW/YMkN3lxDewtRS5xHIlSh0YEHj0duGSUSnyP3/uca4TA2ac4nSn
PUvR0in38mwXBrgH8Es0h5Si8BOWMemuBJ+bhQyOKUXxNutN4k8w4Nxw9xPn
slIka8LaGOPBgL/P1E/zN5aiXH0BiWteDOi7ImDz4n4pUt018+WSDwOooiXB
/X2lqFJ98FGYHwPKXkZ8JQ+Vou0qnTfP+zMgNGKpy2uiFLXK10QHBzIg1fbK
ap7vpWivFMczIIgBU63VK/BiKeolRx3wPUP0X60+WMJXhmSCDEpTzjFA/+Tm
TjPRMuQ0yiPSEsIADq7KWKKWoTKzJtfRUAZoWZIO3mSWobnmgA7RcAaIxfd8
O7qsDGmvVVNUv0Twv/55UWZFGYpMmrxgc4UBljHDrGcry9BT3vy3568ygDVq
+Ch6VRmS9fpvF/c6A4RTvNr2KpUhl9cyad3RhN5OcvL8BL5p8Hx+5gYDlCxu
SjYrlqH5qhhL6XgGjI4sf+2nUIZghVHV7kQGyP1gViovL0NXr/NTXZIZoHb5
17uXrDLUt3DH81oqA4qsJmsvSpYhOZeghxXpBNZ4e3WteBk61qux9lUmsX9b
OY3dgmWoXOvL5T/ZDOjsGC8/9qcU/SwqHF2VQ+y/peWLXz9KkY6Uk+6+PIKf
foV7+VMpuhYmx/HJJ+axRzHj//N//uXln+RCYv5X+1Hk01K03C7u8J1iQt++
gJVLd0tRhQZJWrScAVBq8u9Bfin6ld3qr1bBgIkNP3VWJJUiXfLZPusqBtjv
OG3iEV6KXnyYjs6rYwDDr7xs3L4UyZuVfO5qIPQ+zrwiubcUuTe7GM00EvP2
7dDaolGKFhMHBHZjYr9vFxda85cifd5EJ+c2Buzvfa9iPVmCoj1NWq/eZUDr
mM/yfb0lSMHg7tmXDwhcqWtNSStBx6vODyx1EXrue1gyfLYEVclv37aqh9hn
Ff2EgiMlaM9C2XfvXqL/fi82Vb4ExTi7mSX3MWC4LZxVu1SM+p+sLG9+zoDe
Ybtek9fF6ERR8nGRAWL/HyySnOOLUeyh0OHc9www2zF+T3q+CA3c26nd9YF4
n9ZfN3j3FCFFjbmM6TGi36GSxy05RahW9ISN1iTB57zm3V4j4veg6eDjF98Z
oAn31WSiCtFq+TXNwgJSUKa5+arp+3yUfWuRtpokBf6q8WbRRfmIqfPYTUdY
CjyOffzT75WPSC4BkmfEpMA96tXG7J9cNF5898RnhhRExXk0/eXhooItjjKP
V0vBlKyHvep4DpJ/sNl7cg0RP8Phf56dg5Jthe6RVKWgQ2nZRzZx318+W+6D
NkpBZDZPOpe4h93alh5UbJUCzgPqz+Vr2EjlQFpggqEUzCg+vzTASkecIY+e
W0ZSoOAgyUv2SUMsH1DsMZYCtfcVwo33UpFwwsdHAmZS4HhxUD3HIwVN9G9Z
HWgrBQ0rG6+KFieiYpe+Z7bHCf9nf3qOtkYj1XNkdfnrUtB6peLfsJkziry2
XIsZLQU8ZonNJ8Ps0FjqJkOJGwRe9oUUUbwfcWoPHvkbT2DPLNMKM30sNZ1x
dShdCkKbTFujn3tiHqf1I9klUsT33Fvnp5QI/MrwQMKKbqK/2Eraje/JWNP6
v2zpHimoINW4at1NwfEuvsWUx1Jg+wrN8yem4v1hSfjfU8I/WGF/95Z03N74
9vO7ASkoeiUjHBOchcs3eOlzPklB7GDVMpu/OThC8sacgggThD+I6fM7F+G8
FO8QPTITilIWgkOfFOH2ZWZCruJMcBFSm0rZVYx5lGgypTQmDPJTpyLoJfic
ZoLWFlkmtH6vrhppLMUBVinhRuuYMJpy4yDf93KcOHBazGMDEb8u68IG61u4
5ohtUswmJuz/ltl06/Yt/P2YTOGzzUyIUjm6zRJVYK/AjO4jWkwI9JVe/PWv
ArumsGl+B5gwwTe7Xd6rCl9aFpqeaMoE29Gpyi9pVZjLdlxVb84ES5J5u8G9
KjxSuHLLkhUTpkwSNaNlq7FDQ57tZQcm/BT5t18NV+PzWhHvixyZEPrAz4P2
sRpntrqceOjEhL2JY0YnJWrw687V56huTCibvjAcergGWw8UstO9Cf/6lSt+
fa3BAUciVe74MiF95uTDY/RanPjevfLdKSZ0PBVJ3LmlFvd9WntXKYgJAn/r
ESO4Fpsslo6XhzIhaG6yxuRXLfYMifJ+epEJLdJa0+3SdTiKz/PnjwgmFLQG
z8dsqcPdohtFd1wl+n+wyUnZuw4bLqvYcDeO8L+S2iv7ug7vl3tysi2BCUqC
d5P8vtVhs+Vfi3ESExr6fwioCtdj2xXrlZvTmGAw/T6ycnM9tlcwdmnMYMIZ
ubMBIXvr8dGVJ3Ibspgg1jvaxLWvxydWFcnX5jBBOaabtXCxHnspPbCvziPq
qaBJKSTVY7/V4+mV+Uywbny6NbOgHp9doyRdXsyEEd+e7isP6nGoip5VWSkT
XnqNqs++rMcRa50SSm4ygftNp+jmWD2OWsehFFYyITcppp2XtwHHrscH8quZ
kL0t+mSaeANO2jB0Pa+W4FvLtzFIpgGnb/zTlVPPhMXlPXGZSg04e5OcMOc2
E+JPLSkIbmrAuWq7DLKbCD7eYbeK7Q24QN0uIvMOE+73C81l6jTgEo3g9nRM
9PPb/FCXUQO+tTmVJ62NmKfE9zWa5g24RrNeO+UuE8r5zsy/sWnADVtenku6
x4TvlSP2+EgDbt4615jwgJhfYOLcoFMDbt3G+BXXxQR6nfeRzW4NuGP75m2x
Dwn93V5sbjvRgLt2WATEPGLCiWu3ZC95NuDHO32ro54wgZESXHfeuwH37Yr9
du0psT+je8uLfRrwS61bm64+YwJT4EWpkG8DfrP7seeVF8S8aKGHkwn7sPaX
0kuvCP5FBw9LIn4UiU2GDzBB7bZOLBD8E7BO5eIbJoxHNJ09ROSf0tnnGvqW
2O8F1fEs1wY8o3ucG/KOCWZr26+KEfXP6UWOnHtPvJ/GmFVc+wa8qF+ocPYD
kW8w7JSzdQP+u+e+Q/AYE/j0grSMTBswn+FY5umPTPCg6epbGjZg0l6BNwGf
iPndLjkYrt2ARY1Wyfh/ZkLiw9CtLzQbMGWfro3fF2Jf7mQ17VVtwKz9oc+8
vjFB60Xgwg16A5Y7wKZ5/mBCe+rRw0cFG/BKkxbTk3NMUC3812S6UI9VzZYe
uv1iAudz6kxIfz3eaL5M1PU3EzQM912/Q+yXhsXOvS5/CH1/ra1g1NXjXZZB
HY680qD7VmyfcGw9BqsUvv/4pWFfzw5O7tl6rG9dB0cEpaHs7byuuWs93m87
23xIRBrSnd5afdxejx3sfWotaNLw1/VX1+u+Ohx3seizgaQ0yJbvXHWtvg53
FA2v3CUlDa7m6JRpRh1WnTOLWSUjDS3Ohy6zHOvwQrS626yCNDSKJ8lHD9Vi
1ZrjWROK0tDe6tz8vKkWO7zOeTaoJA01t6IfrEutxR3KdLinIg10V99Vgia1
OBZ/ZyWrSYOZJX+RWXkNvjumanpNQxrk7+aa/AuvwfNk50shmtLg92R5U71t
Dba3ffbNdfv/4/fY6P2rxmu/VXdvA6LfkfLIGqjG7YoB5wZMCf9DGbkXEyvx
3N6bVY/MpcFl+9fOSLtKrOI9NtF2UBrO7ArWjF1RiWOarKxKbKQheZ2hXk5B
BT5suXXj2f+k4bmw3Uy4+S08e2nhnZy3NPAUZd/w/VWC15RtYtJ8paEz5XC6
zbESbNfntl/wlDS07haR2/akGLfK9zd8CZQGJfGK/95nFuHo+oa4lhBi/mzv
lsEVBVj5U7CeYwzBb3XH4FAHBy+7FLoQEisNcivEV9nwcDB15ZXSrHhpEK79
EfPhVDb+ZZso+SZZGhyj8o7+Mc7APZ3lH6zY0qCC+rcL3k3EfkUfwo0rpGHY
41dY/Zaz2E1/ctuJKmkArm6lwPgpbD888zmyhqhPZ95SRug4Nju3wC6sk4ZQ
cen8/3ZY4iBSauD7BqI/4ZryjGcGaGeNgPBY4//jA78aqrigjWbkZv47BD+D
q2Xb5otYkSwlnTZp8Fnf1HKnOBS1uB3o2NonDSz38/mq7FRUzW8ZZPWcmLeS
88+fzemoiG233v+lNIgp5fxn/C4Txb1yS6x8LQ09zcmTdcR96GJ40WX9B2nY
GrdEYgvmI9E19QKKs9JQVFf6qHJvObIZV9gjzmQR751q7KV+G2n8O1YuxGLB
2AFrPv8nt5EYq1SaT5YFy6PfuVp4NaJWoy2T88tZ4O9GnU4ob0IqN41uDK9m
wcUCY1mBHS3o5ym/geotLHjEEt6/sbENpfN2eNpZEfxGU7krdj9Ab+XckgsT
WTD6eZXuf6lPkfVqrbHBZBYcPXdcVbj3KerdQNOkp7Ggv9rM9KlQH2rXbnp6
LosFuYkRJm2n+1CRI0XcooAFPXFWU3yHniE/bn34Uj0Lpu7YrHZUeIGE1gv7
mr9hgUDp/fvzzf0oVPMtvvyWBdsnGl+sWuhHi1pVEs3vWPD4WHiJjfoAmjpg
X6Y8ygKDA1dMe/MHUJ93xcffUyxYb/RB+mvMa5RZbetQ8JcFMbrG0iuODiKp
5g033/DIgOK4XfPBjEEU08G3ROWXAZMriyVhLwZR2IuytLNCMpB9TOfvPaO3
yHWB54UZVQbcW5aK+tWH0PC/F6su02Vgf0bBA3xyCB0SLvVrYshAiDjbMS1/
CO2XsaIqy8iAE9suTUHmHbq3UvW/w8tkwHH76ks9Fu+Qtuq/m7HLZWB9jHW4
W9Q71KDxfOneChlYZK5onLn3DqnvKjb+vVIGQgO6TN3+vUP/A8vagO0=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.11003586283330011`, 0.9999999999999836}}, {{
     0, 6.283185307179586}, {-0.11003586283330011`, 0.9999999999999836}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.65399461374361*^9, 3.6549484834084797`*^9, 3.6549485548749247`*^9, 
   3.6549489611779547`*^9, 3.6549490012808447`*^9, {3.654949091715728*^9, 
   3.654949119367454*^9}, 3.654949675659943*^9, 3.655553949605734*^9, 
   3.684450221525401*^9, 3.6844504968819227`*^9, 3.6844505747501097`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[5] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}, {3.6549490143697987`*^9, 3.654949016022552*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVk3c8lu8Xx+09nmlUJFlFw2h8ee77OiiiskUySrJKRlYhoxKSlVlCsrOS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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVl3k81c/3x2VvRalQSRLa9JEWRV43FRWhSIRvSKIoO5GUNlt2CUkSIsq+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      "]], LineBox[CompressedData["
1:eJwVkns8Vekax9dae3eZigiFnNrKuA21j4o9op5C08WtbdSmGNcyqHaN3CqK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      "]], LineBox[CompressedData["
1:eJwVV3k4lG8Xto5lMIsxhiRJkjakXZ5jiaRs2ZL8hFDZQ7SIqFTIvjODsUt2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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.09547470040435288, 0.9999999999999836}}, {{
     0, 6.283185307179586}, {-0.09547470040435288, 0.9999999999999836}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, {
   3.654949012338499*^9, 3.6549490167500353`*^9}, 3.6549497461684017`*^9, 
   3.655553951560014*^9, 3.684450221586493*^9, 3.6844504969357*^9, 
   3.684450580837777*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[20] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}, {3.6549490143697987`*^9, 3.654949016022552*^9}, 
   3.684450591120813*^9, {3.6844506868308764`*^9, 3.684450707029258*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVk3c8lu8Xx+09nmlUJFlFw2h8ee77OiiiskUySrJKRlYhoxKSlVlCsrOS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      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVl3c81f8Xx5FSRlEqJIRKlGS0ed1UKJJEJH1TmUUhq8gsZYayV9mJwrUS
hewQsvde17j25vf5/XPv4/l4nXPe57zfn/c4Bx48VdWjo6GhCSB+/v+/6Rdj
dZ+Uk8y7/Tt/0dJ0g28P3yGe9/eg5vxN0VG/G3MdPsotfk9hpMQnNFLZje4L
5b2Zfg6QkDVUlA3uQcOzgaRYv3cojNhR/E60DzWeM2zhfpF42SYZUoJBBPxL
PdpX/BFPrrlZeUUMoqjbqMa68BMyygZiHq0O4sBKy95PP6Lxuzz3yumMIbQe
z4mbSY7HzUMBlV2cI7gW/KIoyO8b9r8zyZSIo0DmJmd6gHwKAmzSza9PUdBw
e25zT3EK3nWphvScHcMmg+TPloWpmBW+wKZUPgYdp/1TET/IYKSw9zvVjWPh
zZLsyJl0RFTuawtgnYC3d8MHiex0nFRNtphSmkBuqNfpsvQMmHjWyernT4Az
c81hKjkLnEk6FaO+k0jJbak9dzQbB++cSywpmITC7wwB18Rs7LCUivk7OQmr
GpNSrvjveMI4vUlcgAqWpiucegdz8JXXY83qFBUxHQcff4vOgeF7TZbaq1TU
jXZsv/TxB3bMcHEUP6HCaOq7jjdPLqan5XruOVBBs+if1hyWi48hN7XZ3lER
tG5GL7AvDzJVLoat4VQc36x8yyQ4D3svXWfP/UJFCZNwQtben3CJaAjLyqbi
v51blmkDfkJb6bJJdREVcxy9ikrsv6DrdpKHroYKT96f4QF+vxAWvWyh1kqF
3J/QE/ks+ZC1DPrxtp+I56rJLqWaj2infv7v44Quu3vhc0A+Hn5TDBqeo6J0
rbaFpy0fBc/uy3KtUaHw3Tv3PW8BVnc6O9zYNIUyC8XIrboFSIrS7ffdOgUF
sa3OLxMKsF07/GwXM6FTinSnxwpgUsvqIM1K6PFO8gYnCpERodmdspPQH8gI
t1sWQlCcK0+andB5Vphv5BRCRlklapjg8pasyeL1QiSNvrmSSfBVf4u6sxd/
w24/W+CXXVOoUDmR8e3Nb6x/FwyqYiN05olAwcrfmFLfcDywg9BLE18EsxZh
yXA6MYmJ0F0M7m5XLwKXtLGfBQOhywiSXIKL8Ndood6ejtCXu/kXO4rg6S9+
vHaVij8Z4ZtN+IuRe67ghdk8FUpmWsM9+sWgnjyZpDdJReXRvX9ufSkGuWax
hjxEcLSPD0myBBFKhsFWjYT9vWvPMmxKkLupNX+hktC5GG8J55Xg/UZdJ6WQ
YF+XfexypRC2oE2RS6aiysEqbkijDLb+STF2dlQon5Nw0w4rg9WuLcyKT6mo
np98XNtdBmHuYrf8+wSbGJ34YVSO2Bzb2ZzLBN/RzvW2rUClvpdANCMVNadk
66QiK7Hn0e/tzvsmoTKznp7YV4mzvdLLUysTqPn6I5BXqArZBw/vt2ifQO1B
qbvbUqswf19BpyV8AnW7hIbbC6sRNfT8H0lgAqMLWzYuPKtB8tOeiKukcWwI
XCs69b4GBbZJCmOHx8Gu8t7tGLkGH5Mpk2ys40ACLzvnTA3OKrt8Xu4Zg1q9
Xsv2XbWYGvL8WfxnDI9okiLoJWpx4Hdig2DmGD5onj5CNa+F2HxY/xfPMXx+
ZT8x4FcLNl03nxabMfxMKSK3pdWiTf97XJzeGEa23pApna6F0R4LpcMXxiDz
3ehmhHkdFhsYt49tUHBz4BvHB786uIk4xpOI88SQbb7DLa0OnUXb86T7KHhv
5GxoOV2HmVWlCLFyChL8y4493vkPUqpyOgfzKPhZsH1GR/wf+K3ovPJTKRjm
DH2pZP4PN9bmzw2EUbB2uUdW1u8fPH/FfX78noKd5oe3nk77B/+GjDt+7hQc
jjCpOlb3Dx/Y+0Q1nCk4X0H2E5j+B2ua+8VZLyi4Mb+kwbmzHktxBm9Tn1Gg
z0/av0O8HpxDDZ8vmFBgp+zaS69aj4Mvew7qGVDg+6IyftmsHh8PNxRxPKAg
Lm6nCdW3HupS7dy371KQW6cpPphaD8vy1vf8tymoXY9YaKutx1Ne1ftm6hQM
Cg/k1k7VY4ZdxeeCKgUrt0ScS9kasEvGiPbddQpYXczk8040oLAo11j9GgUH
v2Uxk280YFCVVtdHkYKzbWu1CWYNYLgUonbuKgXXGS4FRvg24LhWutuNKxTo
Srhrf0htwDYxI9FqBQpe3Ks54F7bAN5Pw9eTCH7nsWfIYaoBajrxXYMEx2Rp
J1myNWJ1xjfDhvDP6Ysye3yiESPKF/20ifh/d4ycvH+jEaekZQ54EeP3nzu+
esusEdbtQiv0RH5LBpYFSr6NqL+1LeGnMgXbP/xwlU1tRBWny6d0FQoE82mV
Ttc2QrRwl3oPUe+ZMXk20alGMC4qHwIxH8oc3o0CbE04bc1hVqZB5H+pPpTz
RBNsnds8rLUo8A7TObTZrAmxXg12YjoURJfFUZZ9mnD+q8Ki6EMKsmfHUqgp
Tah8b+93Xp+CPqXn59qpTXApSgl+YkzB6TVfFbJpMypMZi752RDzZ/cocKtP
M/r6TzXfs6Xg3Ips591vzQj/4dnDZk98Hy/2HSRXN4NBSs4u2pG4D5dmHm+d
aAbFqLV5hwsFsKlMu8vSgsv3LGVUX1NAWohZSjvagt5QJ2b9NxTIWr0kbVVq
gUiVYK6cGwUX59Tf3H3cgjc7Unomie/xkoVodZp7C8qfbRK960mB3MyW3VsT
W7Bbp/+puxcF8uZdd+6WtyDoqZz/M28KFKayotKGW2Dx3DWJ/R0FV019Rhi2
tmLNOHDAiGDFSUOxu4dbMZbB9/4pwUpPLlinybXido+XCD/ByuOcPxn0W3H9
wo6r9kQ8FeNp+ruvW3FM1eObIzHeDUqFYlpMK2S+OF48ROSj+ijaj6GoFa0K
zezGRL5qI7Yt2n2t0KFP0Lr+loJbhmp8aXRt4GEfsKgi6tcYOmrAwN8Gf/Mt
433E/tLU3/xV+0Ib0ncGWvk4UKA10DGbqtOGjj9ZkzXEfGvrZp5jcGxD9YTP
/WhrCu72eTtrR7bhw3MyzRZi//33wKA89WcbdgwZHVsg9p9OD1gZOttQFbr4
zNKQgvs6HBraa20IW6jydCD234MuangqdzsOcEZps2tToNfxSUT7TjvmJ/t9
W4nvU1/7hXnqi3bU/XsawShHnD9tqt+3hLTDLJMmpVCagkctm+RTm9uhRT6+
u0KEAmPNdq8ti+3Yvln+KSc/BSZN6fV39nYgVuNzK3UvBaYNeg+23OqAP/vf
8jN0FJiryXy+Y9mBC1tCE5LmR/Hs3x5qyocOrPt8vJY4Ogqr2tKXd/51wIY1
WOdq7Sjsqo4Ep6h0osc/Qv9y8Cjslei6N5t2Ilvq2E4p91E4/Gk9dOddJ658
J1/JfTEK53KP9M3VnVhPP38/RGsUb4rH/2opdkGj48jBtt2jKO/UdKET6Mb8
M+qDRbsR3Ko8vZtWshuyexu9J/RH0P+dI37jUjfSqkx+RqmMgMa/uWKVeHdK
8z0b0xAYwWlFzZ0Lid0oiTuRZ1syjLgsjU8U8R7I0PDsmWQYhmTsKYnRiz14
VDMVvJU6hEK/vcXDaj2I2Gdw91jzEDpNmoYHrHrwqjSW+UvCEHYLaoh15/Tg
0/dVp5mrQ3jlc+tXvWwvWKci6RSCBrHT/uSNfzd7MfDkgiWTyyA+Pt7TV6vb
iyTf22V7nwwiV65xy1/XXojQk8t3Xx4k7gV15fKKXjwa8BEYmR+A46hUd2lb
L+4pJ4ac7B/A9ubd5iVjvaC/IsDaWTsAYXKD/+/tfTg43n6e9HUAD4zUO/JU
+1D7dreX8eMBUG9JPc192Ad3Y86DcXcGYH9pN+0Piz6YOelGQ2kAIbwNgtkB
fVgxKOz3FR1AbYOacVprHw4YJOTHLfTjv9+S6ymUPjyqOr2rfrQfYynsPt9W
+3CmdPv6nc5+bPWsJyfx9EOcrqvJsqQfJFm1lbgH/bB0sa77GNKPxT1Cp1zM
+2HYwVPE49uPVMqK+T3nfnSNyBh3vukHv3/06N6ofqgOHo3hsurHpuHplrc9
/RjMentJQb0fubklu/Wm+hGnXi0ccK0fFr4hNy7QDkDk9ZrkLrl+9J+VLV/i
G4CxmB6Hz6l+lHj5Zj/SGYBRZuakPHc/7B/ozcqZDhD3V65M4e5+nDp1RkzA
cQB/DhZeUt/Rj4Tu7vi2yAGUasaGfqfrh7uEWKBSFxFvc1/64dE+XGupthT9
bxBVYvsdVrP7sOVrVCojsW4VGbMq4Wl9+OlsNT74chBLuRz9h5P6IHqURy8y
fBCzwfs9JyP6wOpgosbaMQgZslghjUsfym5e8BkbG0RiSLpIvG0fnIR2V5YR
fUtOhJ6hALEu07W5F524h7Bj+0zOB90+1AsyS0zfGULFujyrwMU+eC51Pal+
PARr6sMmnO3D5WpyYqItYR+lbCZwog+Z1nf4H4YOoYFe8MEZnj4EViSy1bcO
oVjPvejlXC9UIu2vpYwOoWl2jObraC+2Wqi6eS4PQZwqKhfW1Qub/cs0l7mG
keKV5ZZS1gst0yvUjNvDaGn31kkO7AXfjA/X4KNh2IufCU90I75ry+ZLe+yG
4fTCjk/TthemtgbBVhHDuDY2YFZ8txeurq9lT/UNg0t3/NMKTy/IYQUfso1H
kGi7fr3jfQ9seLf9Gn5J7NOrjB1qTsQ+JDYtx7sRtIUxXvF70oOK+C7p56kj
cAm1u2qo0IPutLXBM/MjuKcd0lq21A3m8jNnfjiMoshRyKxFvRt1ik4PKT6j
6Km57TNP6kZgdZnXvqhRpHxu6WU42g3+eo1e26JRRH5f5WOn68bpLkuP89so
KMy+sktbuwt6c6kdeX7EOcd4RfbBzk4I2ywxTEQT57rs9WW+0Q5Ql0niPBkU
hGHkokhhB+xoalztmyjo1XbrOvWsA35ME8fBPQZ9oScX8lra8fOAsHN+7BjM
HzC9O5PbhuWqsyYfiXcnV4XIj0ehbZB6oajpWDoG9sZrDw/YtiGpzliUNEKw
Vu/nQ+fbEOryrfXX0XFcStj0KZu4pxqP5xdHSo+juYOpSSahFTvba1IclMcR
s/Ox3U3PVrhLTrvCdByryRkcQrdaYTMgKfGLPA4a24/JZtQWpPte5oksGgf1
sh+vTnMLqNK3tjk0jMNeint7U34LDAKsu2QWxsEV739U430LbsnnePw8O4Ht
QZZ6D2Ra4DdTYRWhOIFLsQ9JmsItqIpsu2+vPYFMcvx04Z4WXFpcPSVjP4FX
xcX2I9RmSHxGf17BBPJjDWPZE5vxRF3lb3jdBA756E8pBjcjkfZ+zsu+CTya
/afb8rYZ/FrOPtKbJ7GaOTrab9gMVqbi83kKk5DtO7v//NFmTBhf9c/9S/TF
ZTxiET+aIMx5xzGsexJRClYOi8lN0Ct+/NhuahKM8cEyWh+bMOFdwhexjYrp
Ukoj7+sm6A8Nzd8VoWJ2aNhPSLkJakHC0R1En2xhUDa6p7URDL1JJrlWRJ+a
2/os+08jckSOnw61pyL9+TFR/rxG8P2SqNL0piLHTooqG9mI8YHzC/+IPspY
4LCfmU4jPh7/VZCWQQX5v5ViJpVGqD2/4OmbRwWfZVu/Foh4zHIHrldRkfS5
s5p1fyNcJa4rVowRfTelvTe1vgFnXtbu/jxLxVWYbCovaMBYyc3uN0RfqKZp
ke3+tQGqWpqWl4k+F7t5/JjeEO9cp/uR+SJTGFvldlyRaEB29bOZzEdTsB8y
12h+WY/HHPN5/uZTYA9YdorRqwfPA5u3Fi+m8Cjr+QeBa/V4NWe3X9x9Cu1/
grwu7KvHDW5X+eTPU9gjfIQslf4Po0ZBodHDU0iM5Qs51FaHfZvzLvroT8PP
cOeH9Z21qD/4fDPn02no/ce4d/dsDbzlpEo/WU/DmJm7+XJDDejeJl8lv53G
rbpn77cG1WCYMeJGY+I0Pu2TCvDlrUEmq8M97slp1Md8qfxrUQ3TE+cOxC5M
QyuSIn5DphrCqgu9x2hm0H32wLe3W6sR/v6pPthmIHlM47h4ZBVe7dExeSAx
A4caod8MjZWQOcV9nHJuBiVbJK7Vx1ZiQaOZ+uzSDNxPCO53sKrEo2AVi9fq
M/j15eHhl1yVRL0XbBOsCfu7vD56Jn/AKL12/oTjDJai9M3MLv1B0d3v69/f
zsCg0VTEhPsPTkeecP4TPINlGu4qqb8V4OHnd5v4MYNGy2dsdKQKNMt2XrUu
IvI1Vya/5qmA38MQZpqqGYTFhaZMr5Vjc+xOH7bOGVRQDr2y/1WOscObAiVp
ZjEYI+pFd60ccQq/NPO2zoLjvFOYjXg5dIxsueTYZsGv2lCcw1GOf4kz4Rr8
s0gYGvvpPVSGnGP9MS8uzSLo4oUjDV5lsFD+qL/p2izGrHvYtz8vw7Gn2kKe
6rMQU0wd7dUtw8eU+i/h+rOgv/ei7qJMGd5IFKflv51FYK/jJraFUjTK217J
9iHyKfX2Nx8qhaD2ie5vQcT4tuIHDzeXovBVOEtkwixYhyOfPckpxXqDpeHL
slk846n2zHIqhZXNIZ6zW+dA+1EpUWp3KYo929NPsM5hUF/kRSBDKdg/+Ske
4ZhDkNVpme6lEqSVr9twCM1h5pWkJktnCSa4mv7Ny89BMuyUgUhMCaSPez2a
uD6HVsXcck7/EnhevEg7qDEHvYMhfb9el0DY+JtogwFhHxrgwqNfAv28N27k
N3NIYnpdHMFfgoxaab4v7+ZQIpDB/Ju1BPSDM5lRgXOwq9n98cV6MaK26/T7
xs9BiPustX9zMTrvnYZp6RwMhSkeAm+KccxiosHg7xysVF2vuZsVw+5tjPG9
pjnEfxATeHKnGFyprCHKQ3NY4Yz5FHesGLfoRmaPMswjpueDWe6fIsTuifQQ
3DGPoBuefpTUIswKq/Nz750HB0tFom9gEfxuFlxnOjyP7sCksEv3i1AdE5w4
IjePUv35Sp2J37gsf1UnznUeXc84VPZNFeI6VbfJ0nseCsdt7/PWFOJ2sIPy
5YB5VJ792VrwtRAmlPTz/bHz6GDbHjj1qBD+73g5+YvnUeaQ/cS8qwADTbO1
4ZsWYKd/7jV/Xj4mHXdcMWFawB/hCGHRoHwsHRHOP79rAVfUTqofepYPFrt7
X9v4FzDNw8cyI5QPKb4Kd07ZBeSfd4rGkV94bRh50d9xATIsvh6Zvbl4x5aT
o/t2Ac1Z5w6XhuYiOKf+hKTPAtqF4toN1HORzMzI9y9yAcx1VSdfVfxAQ4rF
KuuvBXiHipLl83LQdfvds+6SBTRYm8ou2eZghC5x9Fv1AoxzHpi7n8vBmlpX
s3LnAmo+eL19kvcdB5euZHiuLYAt4WUWb1U2jkfpHtXevAidqczHae+zcUbR
IVqEZRHfoqO779/JxrXwdN8K7kW497ytF53IguUF3idbzy/iR54BiY0/Cw6j
ZwaaLi5iy/6qGe7pTLi9V9OOV1xE72M6x0e/MxE+4HZV7s4igvslfjQYZaLY
bfbQqxeLmOqMceIpyUDjtiv+a86LkN2u3KkQnoFBt/BN1h6LONt5NnzJMgNb
3eW6jcIWMeY48XZEJAMcjKHKfTGLeCQ40Ci4LQNH3CdztZMXsSr050/nUDqu
ugcFX/+5CLmzabr5n9OhxTjOUF5CME+BeZdnOh67X7CS/bsIqUU5GmOzdHi6
j6pKdS+CLzgEmTLpCGNEwdfhRbD29I/qH05Hsvv740JTi2C/tGXHY7Z0VLuf
Z95Ht4Sn4y7MyiNkdDL6vvjAuASpi+v1+5rImHQfGGbZtYSP0T9WuUrIoGE6
q/Fm3xJy7jY0Xcgkg9XDu5hGcAmG9D3XXOPJOMDUJ/Hi6BLc8zM7O4LJEPc4
FTUjuQQ+c914aS8ybnp02w9eXsKyjt7rYSsydJmkxu8pL0F8c+pubhMyLDzc
7rTcWsLB9p+dQrpkvGbqLFe9t4RBf517dNpkBHiIn640WMJzDcv6UDUy4pje
xF02XULEmVqZ4WtkZHm0sf+yWYIwt7RRqzwZZUxiLqedCH2z54SuLBnNHq+m
Ut2WoInfeCFNxjBTyz0RvyWc1FBNZD5DxpLHseqYkCUkCWn+t12KDEZm5/M8
0UuIZ5m2MDtBBpdnY2LglyVkqPjNHxYlQ5hZhJMtfQkXVrR6BETIOOfp8MY9
dwk3OV4c1xAiQ9tTSPdl1RL4TSupIgJk4l58WTffsATpwJSXqXxkvPSsJZl2
Evk59SSf5CHDm/nQt5HBJVSWBJck7yMjwvPF/oeTS2iMKhHdxknGN+a/Hu0L
S3Bj5rE8t4eMfE+BZXWaZYj58d46tYuMGmYbw79bl0G9ulYwuYOMHs/KRgW2
ZUidftSrwUzGNPOBy4Wcy4ixV+R7uJUMOi9L8jn+ZSyOXzmymZ6MXSwVBzKE
l6Fx98LciY00CHrx+IhKLKP5mcefjqU0SLI8W48/t4yg1wIKazNpuOxVanzg
0jKsLnzSeT2ehlss3G0hSssoWGcwejyYBn0v0yvs6sto8zbkiO1MgxVLcZbX
3WW4eN30EmpMwxsvzkMM+kQ+4FIdq0xDEMuTD45PllEj1K4zVJiGBK9CumWr
ZdgG3TvMlp2GbJa9Zs8clmH5mux+PykN5V6Pu8beLKNQNHi0JjINo17suV1B
y7ibaB9IdUmDD+3DjdKPy6C5V8EUbZmGk5apsikJyyjt5s+21U+Ds7ZyuWP2
MgzXnJzfXU6DUE0Ys1H+MvxreD1/S6Sh+iLl+o2yZXx8dzN+x4E0cIq8bTzQ
vIyEm3GvBxdT8TOikZOxm8hfOMjPpC8VujsP3p0eWoYCW8nlzVWpSFkq6Ctc
WMbPsAsjD8NToVC2Qn24dwWBj56I94mnYuLcVUkl3hXU0y1YTe1OxYdvQdaS
h1eQZlLAumcxBd0BUuv0p1YgP+e/N/l7Cqz1njLF3VrBm3uaBRbiKeBuyVP2
/m8F2xmVmfy3p6BQidnPSn8Fb5OsDjX9+4btkp855K1WYCpV0BZz/hvi6PoO
Dvuv4Ekmx1nrtWQoWZ0wqgknxqOG8TokJmN6xCEpO3YFvQ/FQnRuJUOmllvC
LWMFmpbn56cSk9AQeYsk3LACXS7BUMkrX0AvXaFlzL6KlODx7d8eJSAxhSNC
jXsVzOsFPC0sCVARNOg5L7gKY3F8YEmNRygTvSGL5CrmbyvWDC/EQbxV2vLr
zVU0zwYdSnaLxX3r1HdUv1UYtiWwCv2NwvbCMxXOoasQ6ngcGmEZRbyfC+l3
x6yihOG/Vf/9UdgZVff8TMYqsj0TP901/4SiypmHzk2rMOdV6Hh94iNM99pF
sHevgmbPD/nnlZHY/4C+JW54FavnnEz3nY2E1QK78p+lVWgGLptb80dAiP/k
aXbuNSiI+GXaCIeh3vineZzgGsQiBBedskPhlCWXfPrYGnKlo385KoaiVUmD
/67MGpRcosWCHEPgGtilPSm3hqJG6z1l/CGQ6DUIdLq+hoSJM1P7KoLhaW3D
HKezhg9cN0svCwXjdCGN/GmjNVS67rh1oCsIA8xuThVma8hmPb4hEhoEPw22
XO0Xa6iJzVx7oB1E9MfB8xPORLwjjLcK+IMwOnbghJPHGnwW+ojmKBABpxIf
7/qwBtKa6uGGn4GQdRaPiw0j+FheluWHQExW5nSfil2Dpmtf266ngQjbe3Ff
RfIaLtn3l0YqB0LhwR917cw1jPGdCWGQCMRs0k2fiZ9rkCxL0D3FHYiPC20V
jqVr+NgmepKTMRBKsrqbd9WsgTWk6qD/agCWPMcQ27yGMkeF/3xnAhDXZPHi
VM8a+m3zhacnAqDKv5ZePrKGsFgR+hCC141fT96ZXoPO5KdIo+kAfMliEZ5Y
XoNarvUalgOgSReg67hpHaQtvM+XNweC/hpP5E7mdXD8V9pisTsQKYFxLTHs
63Akpz90EwrE3V5R9lP710HvdmmUFYFgPJalXH6Q4L6g3l7NQGRaw+2O6Do8
N7qsGiwD8aCw9Pf4yXWE+R4PyfMPxA4WlXUHrEOHcZT7aXYgDKN0nsWorCOI
yUnVZnMQ2MeHk0/eXif6juVM8+NBKDhlNlx2fx2VZ7Yx2t0JAleV091x83V8
rE0wXcwOQslexiAH23VodqW82ToahGcP/OrYXhH1ePkX3ucORuVClPxJf6Ie
m7bjB18F4yV/0QmHLCI+k9Cru1oh6KdNVRr5ReSjRX/s6LsQKPWEG9wsW8el
JEOk/g4B10fr8MMt6+hnvZh9QCQUzg662b4969CVvNHy7W4oRv678W9lZB1q
V83ozr4LRfZ+kW01y+uwSKWp854IBd/aXsGzmzZgoa0WQ8sdhjft9Ihh2sDH
ddG1fPkwTPyYur2dfQOGnXyy0WZhuBXaaWHDvQEh5bhBh+Aw/Hzx512v4AYW
L/S+PP4rDAe1shOVjm1g6+baPx69YfA8E1ucKbUBVltKw9NN4Zjl8Ovmk9lA
TILETNaBcGgv2q+4y22A5kV02wXpcPxuerxnTnkDlSwLmWPq4RDO0jxxT2MD
KpyVwsGPw+EXcFmp/N4GuqVZDY/Yh2PZUtxAwpAY3z37lJNXOO6r8zqHm25g
Njl3i2twOMokmcMZnhP2iSpTPFHhEGNfyjJz2oCdpmaVZHw4gmYG6trciPyO
skqmJYRjo65u/LLfBvJlh9xd4sKhn/Zra0rIBmzmXJkCP4aj2jdJgCt6A9qR
9H/aA8Jx0ixY5tWXDejEns2XcwtHuIrr7QnyBo4ekysvsw4HvdgzC83cDSio
HU7RfBAO4x067wqLNpDC7yw6oRCO+gmlxKNVG8j+Y091FgnHueozxQENG/BR
KAvYyRiOqORD3TSdG+D+kpAV0h8GRq9dK48GifiLsl1cP8Jgbkyzp2GC4PxR
7w9eYWhRHBfDwgbObwk5x6QdBrXXD8nb6GlIRXpNOxnGQ7F1riVfZisNyYfF
/m/Yt1Dk6qpUP2OmIZnmiMeoPAmFwCXpkQ52GlJ/lJeFQncIGsnk+Z2cNCQd
tujZL+9D4C4gTK+wn4akebPqtfHFEEzT7eVNO0hDavaOuK0RFIw4c6+jQ0do
SGW3RfZ8kw6GVu+ms9yiNKTuN94FP4nzraCAquZ6kob0kZprb84VBB/HCnct
eRpS+68vIlYmARBdfzlPZ0RDyn9i52uT4IckA7Mnk8Y0JF1+V+XHJ/wgUqs7
2GZKQ0rhclG1/u4LoRjFxnQbGpKnp+2iYakPDlzlzNR/S0Pi+xcRK5fnBfaA
dMuKeBoSyV3ra6ykK/w24sczvxD1Hza64q34GmxGoXrR34h8WhjuCOm9wvbz
zup2WUS9XBWZjp+cwdB7XUq0lIjnmNzV7mEPV8WLyVx/CPuOY2eFZ+xAn3Hy
IMNfwl7VZLHhoS1o3u7f3d1IQ6LhSVxjfGiD5WOUWd9Bwv/aU9eH/eawCew0
th8l7K9s2y0ZZYYFmrr+RxNEvKdP8+2NTTH7L7v+4jwNydGR6ZLNdWOYSycp
iS0T+cuLzNiLPwI1LrKIe53Qr9ye+SFmiPHnrulzm2lJpCMw+OKoi9s35Ge+
bSPYYtPXhaEHGFUyialmoSXRGEk0Osneh2GmDvcPNlrCn0F2IvweBnnVPsTv
JthQcFPYlDZ03eSZP3AS/HnI4bmjFvqmz75y3E/46zYNtV/VxANt0VXjAwSL
3x7bfOMWcj7l0s4JEmzAVEybpwazAvmDNkcI/0uqd+w3VNERtFVX/BihV7vk
Kv25AdacEwvqYoR+Wcw5dUoFFcJbXG9JEsxxfzJ5lwrsl+RltM8Q9jaZP/g/
K6NJpvFi/3mCaZteglUZtxLKf9SQCO460PO54Rrq2fIk8i4RzCs4dWyHMo5q
KJ65rEBwpzefaKwyavujBQKUCN7c4qnZch0qyoGhzirEeDyuTg5kFVRnue96
qkZw+wdundQbUDpg73FHk7DP0eLRGlBFhbvZJgVtQreTNNNTVoPCrK6tpA7B
N+KU9SnqMClTNdbQJexPPP1S0KCBsrRh/QeGhL5X8Cj/6G1UMDxvjTYm2OIV
U8wNbVRqb1MeMCXsk4e2D0/+h+rU4IJDlrSkfAmTpNc9OqjZIixl+JzQ784d
cdd9gNo7OQmfXxLruU25ZmnjIeo3t7076kro5tqKZbYGaNR6vOmJO+H/JPL7
wG0jNH9bsfrm/f/13uI3pvgYbbe5/xMPJPTzZX71+k/Rm3z36OkEQlf/ST0s
bIF+uonI50m0JB3F0E/cGpYY0LDf9SOFltTNsX6o5q0Vhmkjl6W/05I+Ovux
fVmwwaR6d9nFCiKfV0HK1pMvsbr2QO/6GBHvcn1EXr0L1lVnmn2ohH//V1Ve
g1fYiHdRqpulJYlxeEpozr8CnWqMhPoaLSnlP+MBFkZX0MdLxgfQ0pH4uvyC
J7xcsWW1iKt5Mx1JbOffN09Y3mBb3ADtne10pJSRo7oi62/AuGJpGbaTjmRK
/bDW8eQtmFW2jHTsoSORmGf09rW+xfbYAG3efQST7Tdi4AbW5UM1Orx0JB+T
tnWZSDfsvJ51MUqA8A9seJ2y6IZdMfJZfYcJPftn7m9Fd7AvNQkfPEr47/tv
9HKQO/YoG0boixHjUx65M3S6gyN6kS1Bko5EHXr9oJ3bA1yLb1+PnKYj0eCz
f6iaB7ivcS4JS9OR8vdvyeR97YH9UZ+NjS8QOo1Cg9xXD/AsnOlOvkzosSff
T//1AJ9Sxc3JK0T991KEt456gP+TVqmYMsEsC3amqx4QnB89a65K2DMp7uNg
8MQhRduv5FtEvht/lSe3eeLwRyb+OS1ivpSzeUbpPSE0F+p/8h5RX1m6Gs2i
B4SvHt1m85DInxrncKzPA0cjc+2+G9CRPq5/mDUt8YDorBJ1+THB0V1VVZ88
IHal4+F5UyK+XM7wVUsPnIgwaXppQdSrPdQ9TfLA+tiLDCsbOpJKvSrtrm0e
qDj39v1TOzqSY8ukvG2FOwLc/c0MHYl6P/Fvk37tjgctUdfvv6Ijdd/n0TQ+
4w5RoZRjWm+J+iLY1nmH3LBilcd005OIf17a1MzbDR/Ym0svfaAj1VzKiNep
eAudhwOx0kFEPTc6FGXuvcXRtGmXk2FEPStN/52ZeIPi6ywkoRhifEMjL/4V
V8y7y2YzpRP2swfl7RpeobDlegB9NhH/Rz7nJF7BW+iuxdoPol6G79wTsS44
XGItNvmbjsRasUD7RM8ZmrTJCXX/CN0+PibXzAE51nuDg2eIfO0uGF2rewbX
EkFrvwU6ko6LeLWeqjlUd4ure6wQbNx2P7bWFJQ0JbaXmzaRHKk2qeGRj8E9
4eSms+v/nHGl3fAehs+/M7i9l+Cg4fbfHreR4RF2WXXfJhLNFemy8tybcG79
LKDIS7CEbd++VUX4ctQcYRMgmPO95CeJC/gf2xFmPQ==
      "]], 
     LineBox[CompressedData["
1:eJwVlHk41OsbxocZQ8ohypGIIlQODpKI9yskkn0JcexkyT5jGWNMu0rUVBRj
OWU5TQ5lq+gdyZZkPZEiUcmSE6HIL7/n/OGa63Pd93M/9/d5r8tW3wiHAEES
iVQMf//9Rqg0x/hokgnSrsGxlUkCp/hPJ6jqAO+mqG1ftcLW95dcFfeQCZZe
GW+0wgHLCArrbTIE5ojpLDe54vK8rXOipmSC7yKULNfsjRkzGl1kC+BCg4nj
8n7Y0mhf2YoV5KknuCr5BuDRQZeQGQeYP27CSSk/hst2+B8cdwF/u3B/QW0o
ToyPUhlxJxOEuVre5jvhWEr6wmi3L5nIl1gW1i2KxCP+2fxngWTCW2Te+H+M
KMy7X8RtDAFmbTO6ZxGNzewb3KuiYZ/m19LemhjMOR+qS6bD/JCT3dKxWDzW
tPEX+yTQiyUdXqyLw9ok/jg3BfZRhy5J58dhtkFIw/QJ8Bv36eQq0XBP7Iab
BmfBH+Hdpnudhrf9/Tj27AUyMWJ3xr5mmYajJ4JtXmbA/ufVjlQbOm5QklJT
vgrzCv+bFM2kYwmveoHobOC1pZ1VjXTsnRX0GudCnq6N5+oHOi7vWV8lVgjz
Z3ddHf9GxySxunSPImDrr3K0JTq2swgMLv0L/AKLex9O0nFeqsT+b2Wwf+f9
1mftdDzz6OFm8/twT26fVnMOHRsv+i9crgG9/IZzjycdp2uJd448At25gS0n
TsdDIQ9KNPjQp3vc+VU5Davf9mMznsL3B5y+ZWZKw4y3YkeftYK/i+lV0ByH
n2+q3S3TAfsJl/C9hnFYzslXPLAb+vHVMjwLYnFY+rqJ+//Avo4g3YClGPyo
tfqJwCDkadEPlZnGYFGyT47tMLxv8T75XFY0djdaS8sdJROKrNpfc8qj8HLF
Hzv2ToGOX1xU6o/AVtNryGf+hfkBXtz8TDjOVql80/cV+Gt/450voVj/pkhG
5Ar006zupVYH4bP/3Dv2mEQhWNOM4uGkANwv7mm6TohC8KUNv5O1/DDtZMVi
sRjotTqFC51HcfNjj66F9RSCNO/sy3rjiqWXhP4ylQZ2CFCJ6XTAgTrlJzJl
gdl/9fFdDuGoVu5PwS3AQT/O+6/ux8H0vXkKysAlLQYpbQp4sXIdMaEKzLrS
1dqzHd2Sc5ts3QWsy9K47WaMzIl7rw9rAZ+2E1S9boXMMu/m+usCX15RUmQ4
oCvtrvR7+sC8A0f+XHRF2gRvp40J9N9KkefSfBA70YWSYw79P/9UmvzdH3VX
koYnLIFb88g9E4Eocodz5ikHCkH8s896jVUYKpP8+a3OD3TFyfkwxxj007qk
WzSYQiju+nT0bUYsOnzG4c6RMAqRP+dYEdQSh6Z/FHnNx8J+7+7bjvLxaNcH
26Zdp8FvZ2nKO8pAA8fULwWkgX9LoPkxm2R0ekbELS8d9mkM1FruZiKdmA/b
Xl0GP9k8dFgiBY18a5iWvA7cM0GrH0lBFxncauubkP96Wd/EgYUMBJJYp/Mo
RAaz7PD4XRYaP+Vqxf+TQnxpPstWJqcijqjuhuViClH+vNmz0z4VmVySGNbh
UYiuBNu4huxUNCP1uTi8HPSAipT+wVR0M6stqrgS+tlV+M1uYKOD8kWG72ph
/3HfA3MWbLRQwBbaXE8hIk2eXOfHsFGhyh+dTg3QP61H/kAWG9neMcxOb4L5
MPWfEVVstKIp49faBvOVIs0a7WxUWjmvLvgC3qPxQSTtFRu57O1eNOwBfzQn
zHiEjciP7/LjXkL/9+bc1LdsVL4/Le3vQdi3wvE17mcjz5ZAp4lhCmH3JT2d
1sJGotamW5TG4HskFI5rlrNRbZfCp6PjFEKrWLIhKpONApxXKq5Ngf98WrVl
KBtJDg4kdf0LfXlvPjYbsRHfq8pcdB76cD4dWhFho/CxTHGz7/DeRaN7SB2p
SDb4+KvkFbh35A2r6XOpqGXa6s8akhDRtcMkYAilotgo1fBZihCRgapzvs6w
0IvEEVKAmBCRP5vlobCXhZJW655x1wvB/+fQVZHSFKR2MpszsFGIIAz9Sz16
mYh90UHNeosQoXiNESJDSUaakppzp7aBPhV6yHYtA725trYOqwgR3lJpT4qF
k9Ce/Ke2OpqgL2cupL+LR++VCzaF6wBHq8tJ8unocmnyWNEeIYJ0zdYo7yoN
Td/To8sSwE3uD2dUY1F+UwlXwB76tH0/kjsbjg5bnQo2dBYi+I/MooeNQtHy
Cx/tODdgD693hqnByGlAtvmTD+RXpUlpz/miNVMXPndGQ158ldlYig2Kloja
x+VAnlYH9XysJ55MfxZ5KQvmafe+FOn7YF8x5dusHNCjEjxO3vXD9qL9Yn63
QOdrl0zSgnHrWa39TiWQb+v42422EEwIp9HMeaBr366QEg/HWhSjt6qV/91T
eCi2JhKXsK9JbaoVIkYCW663N0ZhRYEvFqJ1cD/e7ayBlmgs/rOwfLoR8phu
d85VxeLTjJX3Qy2Q5+XDi+TG4Z/Lzps628Gvd0yOk0zDM99E2BW94JfLFCDk
43Egzbe6sB/0gdHUnUPxeHj+0eSV19Dfgtu08XICdonZqHDqLegk+bR6w0Tc
MXvckTYGfWYlRUZfJWKzyNYzQeOw7x1z3cGwJFw3s7XuyBT45VrEH8wlYd3w
pC+W/0Key5IVOZyBeVN9yoZf4X0LtrcvDTKwcoiGm/o3uG/Pc3bsvmSc8+nM
RfkfkP/Uw80uMxlvCHrX8Msq3CPqrn7Eq2R8/oPB4qoglVDE6TK1G5hY0J+z
c5YKXIxEfjVl4sTRz16jolSCLzOzO9mfiee8La70/kIl8idU50fimTjkbX7L
U0kq4f3EpN6IxcSjnss/qqRBX6jQ5SQysfsbR61iWdBHvFQmg5i4x/2uf9YW
KkGyeXfC6iATW76iZp/bRiWIXXV/NG1mYr6rd0eiCpUYuXL+Y8RoMtZ/+UAg
bCfs/13DxT8nGZc7Sel5agCfm55rsEzGar1hITbakM8vXOZNMnC+fTMX6UF/
2bmrNikMLNOl0KtlAH5DVkufMANn2CQIbzOGfOFDbtEnk7BwR4+h1H6Yz5Np
9VpIxMxD6pGUA9B/fO1vL90T8WLbqVsLltD3YuD2TVUJ+GOzvtiAPXDiun2y
lvHYy/yySZsz5KGLehEn6Phl41TcQzfQzS2J+vs03MTnDuf4gL7GMo77LRbf
ekgp94mCfutTDtdKR2G5vV7vHeJgP7Xs4w/RSMypqZExS6ASLC8eK/1LOD5Z
GZKqkgr3SRNvDk85hv3KuhymMuB7JNs1OPLeOH7pt45lDvglGCe4Bh6YKHAJ
LsuG/YK9H2a9nLHz9P3R+lzgpe+iN0ztcMie9Z4dBcAXDvdlGB/A/wfrM7c6

      "]], LineBox[CompressedData["
1:eJwVl3k8lO0Xxod6DWOIEi30WooSQpZU3I+dlD3rq2xZyr4zZp4RhcobUlII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      "]], LineBox[CompressedData["
1:eJwVkHlMk3cYx5tqLJu8STkyZBSBqGQrcXJszHDUd2qABRkVZsMAEZrKfYij
YAttX8qkoVSY2worDGGAiZwtGzrmsA/gYNaAq66IxZFBg8R1DHa0a1WEPfzx
yy+ffL/f5wrglySdpdNotGh82/+317U5P5tdSZrPRxGB/BNgsxmTjAuuJGX0
INX5yRCjP3OIYUGejJmosKTAzVbDWs8K+qHaz2rOACtX8rTM6kqONbnPLMxl
QdCnV34RrqE/rWIuLkMAEXeeOXz/Rf/zt0vWjuUAfXxn1kUH6g4yzmDPg9Dy
kVTuC+SVB8rl6EKoORL7rmIL+cp67PrNYjC5PPTQ7yDIRV3BP/vU5yDwgeAv
G4Mg/b18s3MnS+GuQN7DZ6IO9+IbiTJgveVWq/EkyLFmWfvZ/UIodrTzjXuQ
e1S80ZBycFfe8uEEoJ+8bt46eAEEySecZQcIkgzzktNZIrjBemzqexN5l21o
aFMELit5Q5aDmI+s6u+eFUOq1nnJOxT1KNNGRUcl9F9Q5HPDCZJ64uiayaiC
zfdei1VEYP0U9vEEpgS4u6/u03NQn194v3tYAp2mMJr9KNbbornXxkvB1jbx
a1AsMr+d6DdJISbn5Pf8ePQXTVpmE2XwZfCiWpO4Xb9ZaRiVgfVZ8XljMnJL
3I0egoKo2y8/YKQQZOZSQWTXOxQ0qFRBnHSC5K4avTk8ChZP+bgIM3Ge6ntF
+SUUhPr1LvcJCJK599o3PtUUfPL08Lgld/s+I3fi6il4OPRTm3cRQQY/9nj+
xyUK3qjkibmlBEmzt76k11EgPv6EpxBiPlTpbKiiYJooC9OLCFK3K0/6RS4F
e+foTLsE59mQNfokUHCu4/JqkBz7Nw2pD7EpmMjzN/Br8X6eGtBvycAzTHtV
o0QO7g4XfyWD7I1oubEB90vL1YyyZTAyOZ3B+BzzIb6q73ql8GpjWiSnGfUC
/eEulhTSU6xewlbs90NNuJ6SwGCAyNbXTpAdA/nFCXNVkDTcNOB9Det/Xc98
kV4J3ZIDSm4/5gcLp8ZVYvgvZjhbocP8TMCOBJ0IWsz3/ewjuO/U6UbSVAGr
nZkbQbdQr3pESGfLgVO4/og/jvPULLuxp4WwtOn6mdGA/mHRK9rWj2FzfI9Z
P4M8+FuEuu48vH5xv//AfbzvMV2gs6QUPtwdNVhnRr2XPbqUWAxTXgV3j/6O
8+hO1s93CsAyX+4W8if6PU7zfvTjw1abPMXvb/QvWm+Hs88AK6uhnbAj5+xs
GWOkAtN2pMngRC69bNKyTsH/EhHS4Q==
      "]], LineBox[CompressedData["
1:eJwVUWtMU2cYPhRk3npqUH9IcKIL6FoNXucMGe+nErm4CerSWjBFinhBUxS7
QqG0H4i0kEmlNEC9URhgEGsqbiIQsSo2CIIo8xi7QFyGtJYQhQ68b3v34+TL
k/d53+dylsozd6XzGIb5Br//39TVshtlISxhWuR5jbVJIL4nsMWHsoR28WOC
SlPAGLc8cvkKnJvWf719aD9cmbuucOFKlhDuSPAS2UHofhT1wH814vGdwoXc
YeCJxZIXG5H/e3mk5pIClPJTJywxLAk17S3kXCfgTFh5u347S168tXjVXiXY
POf9VAkssa7yLP1n4icYVfxq3CXBe3P7k2a4s4G31sGRZJY4FMXvOwdzYMlU
7+KIFJbsO7d50nlDDXvy/mqecxDvt9gvSGR5oIx6Pfk+A+/H1izYsEwD5X4f
N3kUmOeA//XZf2jgaldgAZeF+z2NqacN+dCjD+ruUuH+cEW2SqgFd/yXguu5
yK92cCcdWghgheJaLfpJ8AXmxOsg9PGGC8ZCnN/ndgR36+A78+aR/GKWDKgt
6edCKCRJfhAdLWXJvObQLY92UFAFS7OSylhi/7vEUZFLoWJof1usCf2lnTzK
1VCwW48xGytZkth+NlXfSeFhmiYm7CxLzpRM77RwFF6FG8rmX0Q9ds7Pfh4K
gd6Kp3512Jcs9t/WSQrLbDUhbxqw797b0DpNIepYc9pwE/b1odPwyUcheV3r
5Yc21D+S0qn3UsiZvjvRfg2xdZYi2UXB3Nb/bdNvqG8c69PcQz8al66qDfVl
8g5fA4U+GHWeuoX3BiQ3ewooeHmTfOUd5EvMblaCfpyff5TfR+wLnDkQRqFR
2VjV8AD5HeLErU90sO2rBJenD/tNXPD9dJwORh+/DVn5BPPbak1TLVooptaU
TA7zdBgqi/haCI+Iq2txYd+z9cZxaT44hyZGpoYxX84haUG1BmZEbs3QuHG/
qiP89Hgu1L8au3J7DPXaLzqcAbkQXW1+zXuD//fPp8xVgRqKpl4qS97hfPD4
SBwvGwLsBl3lLAGxWmreRR/KgnrZmrvP+QLCRMczCcLjEM13BSwOEhCHJ90k
7M6EogxR6S/BAkK+2O0+UJgB/mH9ZrsI+fVNA596ZVA3qHrmi0B8SVQnnScF
vfpzCbNeQOhNkX6RaTf8B0qzgYA=
      "]], LineBox[CompressedData["
1:eJwVkXtMk1cYh0shKNfvE5gwIxtsmgEDpOU2QeFgYSLGQqFr7OxYgzI6p3JJ
ZcBo+5WJxk2QMRRFYQ04q0CUDrxl2LcyCWMRKA5kjolcyv2OChMV9u6Pk5Mn
v+f83pNz3JNS45PZLBZrG67/95FFXdVpHkVY5PXTwBsboWlb06bIKOSR6YzO
M36gHYzuiduFbHU++9ujPLhbGRhixqcIs7nc1eQTB5XRjVN28ZindBcM3vkE
diwd2CIQYc6vz5k8sQ/yhDcbehKR7VPdo1T7wYwSgykV/famQ5B/BDR3zdge
csyNbceCS9KAHKqO/CqLItKr/vdd+9KBaX3VOs9QxKCZufmhWA6sYxVdKz9Q
RCN5MBnxTxZouDudd5yliJt/s+/UQDaQgVlxfhme38tz1ffmQP/pcxd/r8D8
Wlo5af0GmLCIpzZVeP6hJoBdnQtu0+PusVqKkKKE7aUKBRguFB8orkH/YeGG
Mp4SpDGh2u7rmF/7WlbzSgmsl0PjLg3Ihx29Mn5WgUZ7yltymyJxCXbLe9wY
IKLA1J8acT4r+bsjXzDQb9GnGzRQpOg6X/LvJQaY+uPPNzdThB6dz3/Qy4Bb
0pbgL1sp0r9QUNthrQYD/Vd2bRv2D1s4THDUIAWmcbYT2dCoWSNQw+phz1Xu
I4oYR40vnGVqOLg+ttbnb4rMRX8QHJephi69XOzRh/3TNVPpCjWEp5RZvj+I
7+ulKM9CrqYM9a4jeN+OcF0S+k63h6UuExSp+16WzsE+ldTG3nEGWbTPajxe
DRNrOb/aLSDnSfOLgtQg1Ilkaxcp4qdLNXIc1aAX575lvoz/GdpZ93iMAU92
ZdObN9jPKf2t9BYDMd1Dwa9ZNKGPz2YqVQyormYWvmQj7xeYVxEGGhRWw4sW
NOkX0S0hiyqYEFwMfW5JE5IQVkonqkC4fG9sxpombjYRLbFrlHCyXRg+ZYv+
x/L0sF0K0FeOnhm3p4nU7+wpF1UueO6245kc0KdP2Ha25EDiu5rzA040YYp9
ZZLebCh5xp3rW4/cou3zNmXByoW95Y834LyMP4wePZngnzb57NFGZLOlhk1N
R0EWqYzpegf97hKu5SU5/DlVtdT+HvYXv10Xxc+AK9tnBfe9aMIaelKwruQg
PFmXd+WeN00MAWZWHQsp4DDitKr3RX5x4zOfncmgKAypvcNFv3fr0Nbqz+GX
pDb2rQBk58sWBvdPYSxIKm4IwnkVtpI9BULYLTEZlB9h3jM6cnmFD83nrM1/
DEGeX56TcnnwH13Rv1Y=
      "]], LineBox[CompressedData["
1:eJwVknsw3FcUx+mQxHj0mki62p1Y6a6gpiGkjRnJuRUUsR0JIkyyQdebtVns
evv9liBNBRP1DlZFUWSTRmlk6zEUoYltRNbEiI6KJE07RjHSSNLTP+7c+cz3
nu/5nnuvdUTSich39PT0ANf/u7ws9OdZD0IZTfDuZXUAiAsNX2u9CNXjPvHU
HA2B0Y4L4jpvZL/Y384KRbDFcPuqfZFt1c0v/goHp6Br5pV+WG9inlPaJYYo
O/eY8i8IpXV21zKjo0Grjd5VcgK5X3SjR5MALXt/SMoPJbRxVtw+JEmGRxue
v7Cnkccq9I1UKUAmdNxcEfoz15dcJ1IhM/nNeHoE6lWCnTLDNFB/XsZTiAkN
2/jRr9giHZ58wFekROF5543APssM8B/24SfFYb8yE4nKIAtuatZlEQmE8rLX
+2yWsoDToxoMkmDeqzNf1tzKhiy1kPhIUS/Z49WSnwMLbS9FbjJkywf1m+65
4PHt1c79Kei/r8jGYz0XWuuOb+2VE7oiHOQ0ChkwqXjtuzuN0KmCxqjAGgak
JW3VRhlYzzeRNCwwMF0U9HQrk1C1N/uemMfCIaX+pyvZhA7kDd8tDGGhLrPz
/GIu1vc+Ll69yIJeasj0DIv+Q/zlSz0siCWGH97JI7S03tHMd46Fsejr5zTn
0S/+z8c7/2XBIfzMgLoQ551nn80TJZSGGr3bfIFQf9sgSSNPCWsB3WcqL6K/
dj7B304Jp4ThHV8VE+roVdD0zF4Jt71MX2WXoH9I1KVYgRJ49Cefc2Xon6yf
PMVRQr5rZJX4Mt53xOJJa0MlPD1gvhz8Dc4X4GgQ8ZwFPwfNwWOVqD/kba8d
Y0EtiM0/Uk2o1C3++4cNLFhY7brvVIv6Vs2mQMpCGmfQWnAF3/NkcGeFKwtz
5olSTgPmb6txPbzFADW27DdWYZ68uZ79vQw0G4yYvm0ilIw6LhUkMrDjjfT0
ajPeX5OII+IyMLUy9lLXSujC9nqR6d0ccHme4j3Zju+1mjPyybYcqFrkVfZ3
YL9ogWfigWwIm0lzaVFj/vep6mhMJgzf4+dV30CWxq2VyDLAdnxK+/VN5LdO
pu6ydFjps01K7kWWmW2eDVBAYPe0JuoW5k2aJDUH5dDbxZiE3kZ/hfzjGbNU
YFS6NjqA81YIX1m2yoAUFv1hOoZ5/570mDOMhxTGxVn/Dv6/73g6RWAM6NIX
2LUJ5PE5h1+rIqEx4ZDVo3uYX2Ev/31bGAich+TdWtQ/u2zm1RUKNiPT7f/c
R16lmpk9gTB5ys24+wGet9+xz2pZCHF53fwjOmSLBrO00cNQfqy8tXYW+YUf
08v9CP4Dykuufw==
      "]], LineBox[CompressedData["
1:eJwVVnc81X0UtovIHahQGWWVjHp5G3x/rj0yroxoIDJK9sqNu0kSiheptJAo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      "]], LineBox[CompressedData["
1:eJwVkX9Q02Ucx5exkJtszH0bsGw0ULiAGAOFAo/PY+yWKKxt8sNQYhGSQ5Cf
y9gYTX4Mti+NiRnhRZHYEQEOSGlz6Ozq/FEOBphy3Lqjg91R5NAOartu1uMf
zz33vs/z+Xze79fDK6mSHdtCoVDS8Xl6BwSpu6f/ZCGKkVegfC8TQk0amcXD
QtpPeZ9P3pLC0ZaFQe9fLHSjvNKjXngH3AqjrOFfFlpaDG4grTVQIVclKf24
nqNY33e1Djbyy7bX/MdC/dYZ38HLSggQZswdf5ZA/WcDRsPPNEBnWuxEKRVr
6+yBzFo1sATsbnkggSg7bfSPsjQQyfVID9MI9Ehsz7Wc0MI3xKIgN5hAzvCQ
QJHoNCTRbjIlDAIlTp0bOsZphn3evtk3WASqflJG2xxtgdse/Xjm87h/W6nU
UtEKErfyDITi+T999evlqDaQz+VIU18gkMTRtRbRoIPV268Jkl/Euidur4/d
DlX2XUx+BIHGRmnjvw23w99XmI9jeXh/hsL/SWoHNI34ndFRBELfvXVk0doB
zw38Pha5C+dJUwxWJ+nB2PuLiRuD992bV0V+qQe26ftqzssECqHKhFNUA/Tp
RiXsOAItzVUW0+UG2KnpTdz+Cp7HzY99aDbASF1bCJ2P/RdGcwSbBthdXvMo
SEAg0/1exySfhCl5kZOaTKCXLvG4xcUkCAuyxp7ZQyCtK4/PaCXh55w9Jn8K
9u+0No71kSAT8qp9r+J6wrQ7cYSExbRgyWYa7u9SWJrNJJQIfPzHe7Ef6iHr
Z4Mk/BHjZjzMwNoRHqf6mIRa7uz6KsJ+oqPnOe+T4COuzay8jnUUxd+cTYKW
NmReEmI+y3fUtlAStm451+USYZ23NjT7wAAmr7ZqYT/mW+8pe9BpgLD1ijfv
HcB+dCRrOcUA/e7DfGc2/r8rbpJxXw8xLiHjrhjze+KNaCzXw6W5xPVbEswH
pRuyNzog5c6OmR9kmPdq7crXdR1w3b7VbM/FfKU3z19bbQfR5IbRlv80f2CR
7VA75A3cFX9biPMumCaytunA1WtJMB/F/ZbUI5LCNig1XaQPv439no9gxn/R
CvWaxukLJVg3TTBV9BboLogXd5fj9zvWUn4M/RA44rAEYwWel7980SHQwAVh
AN1wEuc54aX3ZKhhXOBynK7F/K7Ge04mnwInrTOnRkWgG/aBaT+qhPAPRMM9
jVjb/pnKqzwOJSuUoOtNWLt0p8IM78KIxFa2osXzlPUx7OQisB1k2+abMQ/1
7ixPei78D0pGkcE=
      "]], LineBox[CompressedData["
1:eJwVV3k4ld0XVflKodC9931FMhYikinJOZVEST4NlLEimcmQOVNml8s1yxBy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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.08986958978825663, 1.0676046696070354`}}, {{
     0, 6.283185307179586}, {-0.08986958978825663, 1.0676046696070354`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, {
   3.654949012338499*^9, 3.6549490167500353`*^9}, 3.6549497461684017`*^9, 
   3.655553951560014*^9, 3.684450221586493*^9, 3.6844504969357*^9, 
   3.684450580837777*^9, 3.684450620067059*^9, 3.68445070010085*^9, 
   3.6844507357535887`*^9}]
}, Closed]],

Cell["Make  a \"frequency domain\" plot of the coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Erf", "[", 
     RowBox[{"2", " ", "\[Pi]"}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["\[Pi]"]}]], ",", "0", ",", 
   FractionBox[
    RowBox[{"Re", "[", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", 
         RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Erfi", "[", 
       FractionBox["1", "2"], "]"}]}], "+", 
     RowBox[{"Im", "[", 
      RowBox[{"Erf", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", 
          RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{"Re", "[", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
    RowBox[{"4", " ", "\[ExponentialE]", " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Erfi", "[", "1", "]"}]}], "+", 
     RowBox[{"Im", "[", 
      RowBox[{"Erf", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
    RowBox[{"4", " ", "\[ExponentialE]", " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{"Re", "[", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"9", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Erfi", "[", 
       FractionBox["3", "2"], "]"}]}], "+", 
     RowBox[{"Im", "[", 
      RowBox[{"Erf", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"9", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{"Re", "[", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", "4"], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Erfi", "[", "2", "]"}]}], "+", 
     RowBox[{"Im", "[", 
      RowBox[{"Erf", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", "4"], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{"Re", "[", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"25", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Erfi", "[", 
       FractionBox["5", "2"], "]"}]}], "+", 
     RowBox[{"Im", "[", 
      RowBox[{"Erf", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"25", "/", "4"}]], " ", 
     SqrtBox["\[Pi]"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.539348900461853*^9, 3.539349025162924*^9, 3.592056900794857*^9, 
   3.59205693153894*^9, 3.59205709743393*^9, {3.65399455589922*^9, 
   3.653994564692024*^9}, {3.653994603096509*^9, 3.653994613952845*^9}, 
   3.654948610036271*^9, 3.654949328129447*^9, {3.655553925089974*^9, 
   3.6555539542141*^9}, 3.684450221702795*^9, 3.684450497047887*^9, 
   3.684450748684223*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"ChartStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Re\>\"", ",", "\"\<Im\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592056964512083*^9, 3.592056985563291*^9}, {
  3.592057062331558*^9, 3.592057071627198*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.3020588235294117, 0}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.616], 
     Thickness[Small]}], 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5404411764705882, 0.}, {1.4595588235294117`, 
            0.14104739588693907`}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{52.049956747404835`, 
           82.02588498385164}, {-116.75090526667867`, 26.638627105878555`}}],
         StatusArea[#, Rational[1, 4] Pi^Rational[-1, 2] Erf[2 Pi]]& ,
         TagBoxNote->"Erf[2*Pi]/(4*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{"Erf", "[", 
            RowBox[{"2", " ", "\[Pi]"}], "]"}], 
          RowBox[{"4", " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] Pi^Rational[-1, 2] Erf[2 Pi], {}], 
        "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.540441176470588, 0.}, {2.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{83.98376666865896, 113.95969490510575`}, {
           26.013627105878562`, 26.638627105878562`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5404411764705883`, 0.}, {3.4595588235294117`, 
            0.1098478223669306}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{115.9175765899131, 
           145.89350482635987`}, {-85.17150250069193, 26.638627105878555`}}],
         StatusArea[#, Rational[1, 4] E^Rational[-1, 4] Pi^Rational[-1, 2] 
          Re[
            Erf[Rational[1, 2] (Complex[0, 1] + 4 Pi)]]]& ,
         TagBoxNote->"Re[Erf[(I + 4*Pi)/2]]/(4*E^(1/4)*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{"Re", "[", 
            RowBox[{"Erf", "[", 
              RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                  RowBox[{"\[ImaginaryI]", "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"1", "/", "4"}]], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^Rational[-1, 4] Pi^Rational[-1, 2] Re[
           Erf[Rational[1, 2] (Complex[0, 1] + 4 Pi)]], {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{3.5404411764705883`, 0.}, {
            4.459558823529412, -0.06755114846239424}, "RoundingRadius" -> 0]},
          
          
          ImageSizeCache->{{147.8513865111672, 177.82731474761403`}, {
           26.013627105878555`, 95.01215545654216}}],
         StatusArea[#, Rational[1, 4] E^Rational[-1, 4] 
          Pi^Rational[-1, 2] (-Erfi[
              Rational[1, 2]] + Im[
             Erf[Rational[1, 2] (Complex[0, 1] + 4 Pi)]])]& ,
         TagBoxNote->
          "(-Erfi[1/2] + Im[Erf[(I + 4*Pi)/2]])/(4*E^(1/4)*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{
            RowBox[{"-", 
              RowBox[{"Erfi", "[", 
                FractionBox["1", "2"], "]"}]}], "+", 
            RowBox[{"Im", "[", 
              RowBox[{"Erf", "[", 
                RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{"\[ImaginaryI]", "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"1", "/", "4"}]], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^Rational[-1, 4] Pi^Rational[-1, 2] (-Erfi[
             Rational[1, 2]] + Im[
            Erf[Rational[1, 2] (Complex[0, 1] + 4 Pi)]]), {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.540441176470589, 0.}, {5.459558823529412, 
            0.05188843717757434}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{179.78519643242134`, 
           209.76112466886815`}, {-26.506509282440085`, 26.638627105878562`}}],
         StatusArea[#, Rational[1, 4] E^(-1) Pi^Rational[-1, 2] Re[
            Erf[Rational[1, 2] (Complex[0, 2] + 4 Pi)]]]& ,
         TagBoxNote->"Re[Erf[(2*I + 4*Pi)/2]]/(4*E*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{"Re", "[", 
            RowBox[{"Erf", "[", 
              RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
          RowBox[{"4", " ", "\[ExponentialE]", " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^(-1) Pi^Rational[-1, 2] Re[
           Erf[Rational[1, 2] (Complex[0, 2] + 4 Pi)]], {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.540441176470589, 0.}, {
            6.459558823529412, -0.08563801330161676}, "RoundingRadius" -> 0]},
          
          
          ImageSizeCache->{{211.71900635367547`, 241.69493459012227`}, {
           26.013627105878555`, 113.3192130567198}}],
         StatusArea[#, Rational[1, 4] E^(-1) Pi^Rational[-1, 2] (-Erfi[1] + Im[
             Erf[Rational[1, 2] (Complex[0, 2] + 4 Pi)]])]& ,
         TagBoxNote->"(-Erfi[1] + Im[Erf[(2*I + 4*Pi)/2]])/(4*E*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{
            RowBox[{"-", 
              RowBox[{"Erfi", "[", "1", "]"}]}], "+", 
            RowBox[{"Im", "[", 
              RowBox[{"Erf", "[", 
                RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
          RowBox[{"4", " ", "\[ExponentialE]", " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^(-1) Pi^Rational[-1, 2] (-Erfi[1] + Im[
            Erf[Rational[1, 2] (Complex[0, 2] + 4 Pi)]]), {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.540441176470589, 0.}, {7.459558823529412, 
            0.01486628615295367}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{243.6528162749296, 273.62874451137634`}, {
           10.966356098873852`, 26.638627105878562`}}],
         StatusArea[#, Rational[1, 4] E^Rational[-9, 4] Pi^Rational[-1, 2] 
          Re[
            Erf[Rational[1, 2] (Complex[0, 3] + 4 Pi)]]]& ,
         TagBoxNote->"Re[Erf[(3*I + 4*Pi)/2]]/(4*E^(9/4)*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{"Re", "[", 
            RowBox[{"Erf", "[", 
              RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"9", "/", "4"}]], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^Rational[-9, 4] Pi^Rational[-1, 2] Re[
           Erf[Rational[1, 2] (Complex[0, 3] + 4 Pi)]], {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.540441176470589, 0.}, {
            8.459558823529413, -0.06815795653775363}, "RoundingRadius" -> 0]},
          
          
          ImageSizeCache->{{275.5866261961837, 305.5625544326305}, {
           26.013627105878555`, 95.62635092306476}}],
         StatusArea[#, Rational[1, 4] E^Rational[-9, 4] 
          Pi^Rational[-1, 2] (-Erfi[
              Rational[3, 2]] + Im[
             Erf[Rational[1, 2] (Complex[0, 3] + 4 Pi)]])]& ,
         TagBoxNote->
          "(-Erfi[3/2] + Im[Erf[(3*I + 4*Pi)/2]])/(4*E^(9/4)*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{
            RowBox[{"-", 
              RowBox[{"Erfi", "[", 
                FractionBox["3", "2"], "]"}]}], "+", 
            RowBox[{"Im", "[", 
              RowBox[{"Erf", "[", 
                RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{
                    RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"9", "/", "4"}]], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^Rational[-9, 4] Pi^Rational[-1, 2] (-Erfi[
             Rational[3, 2]] + Im[
            Erf[Rational[1, 2] (Complex[0, 3] + 4 Pi)]]), {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.540441176470589, 0.}, {9.459558823529413, 
            0.0025833731692615066`}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{307.5204361174378, 337.49636435388464`}, {
           23.3988034848238, 26.638627105878562`}}],
         StatusArea[#, Rational[1, 4] E^(-4) Pi^Rational[-1, 2] Re[
            Erf[Rational[1, 2] (Complex[0, 4] + 4 Pi)]]]& ,
         TagBoxNote->"Re[Erf[(4*I + 4*Pi)/2]]/(4*E^4*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{"Re", "[", 
            RowBox[{"Erf", "[", 
              RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"4", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", "4"], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^(-4) Pi^Rational[-1, 2] Re[
           Erf[Rational[1, 2] (Complex[0, 4] + 4 Pi)]], {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{9.540441176470589, 0.}, {
            10.459558823529413`, -0.04795981245045575}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{339.4542460386919, 369.43017427513877`}, {
           26.013627105878562`, 75.18231097972517}}],
         StatusArea[#, Rational[1, 4] E^(-4) Pi^Rational[-1, 2] (-Erfi[2] + Im[
             Erf[Rational[1, 2] (Complex[0, 4] + 4 Pi)]])]& ,
         TagBoxNote->"(-Erfi[2] + Im[Erf[(4*I + 4*Pi)/2]])/(4*E^4*Sqrt[Pi])"],
        
        StyleBox[
         FractionBox[
          RowBox[{
            RowBox[{"-", 
              RowBox[{"Erfi", "[", "2", "]"}]}], "+", 
            RowBox[{"Im", "[", 
              RowBox[{"Erf", "[", 
                RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", "4"], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^(-4) Pi^Rational[-1, 2] (-Erfi[2] + Im[
            Erf[Rational[1, 2] (Complex[0, 4] + 4 Pi)]]), {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.540441176470589`, 0.}, {11.459558823529413`, 
            0.00027228552879408863`}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{371.38805595994603`, 401.36398419639283`}, {
           25.738026723853345`, 26.638627105878562`}}],
         StatusArea[#, Rational[1, 4] E^Rational[-25, 4] Pi^Rational[-1, 2] Re[
            Erf[Rational[1, 2] (Complex[0, 5] + 4 Pi)]]]& ,
         TagBoxNote->"Re[Erf[(5*I + 4*Pi)/2]]/(4*E^(25/4)*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{"Re", "[", 
            RowBox[{"Erf", "[", 
              RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"5", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"25", "/", "4"}]], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^Rational[-25, 4] Pi^Rational[-1, 2] Re[
           Erf[Rational[1, 2] (Complex[0, 5] + 4 Pi)]], {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.540441176470589`, 0.}, {
            12.459558823529413`, -0.035504877106286366`}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{403.32186588120015`, 433.29779411764696`}, {
           26.013627105878562`, 62.575747001996106`}}],
         StatusArea[#, Rational[1, 4] E^Rational[-25, 4] 
          Pi^Rational[-1, 2] (-Erfi[
              Rational[5, 2]] + Im[
             Erf[Rational[1, 2] (Complex[0, 5] + 4 Pi)]])]& ,
         TagBoxNote->
          "(-Erfi[5/2] + Im[Erf[(5*I + 4*Pi)/2]])/(4*E^(25/4)*Sqrt[Pi])"],
        StyleBox[
         FractionBox[
          RowBox[{
            RowBox[{"-", 
              RowBox[{"Erfi", "[", 
                FractionBox["5", "2"], "]"}]}], "+", 
            RowBox[{"Im", "[", 
              RowBox[{"Erf", "[", 
                RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                    RowBox[{
                    RowBox[{"5", " ", "\[ImaginaryI]"}], "+", 
                    RowBox[{"4", " ", "\[Pi]"}]}], ")"}]}], "]"}], "]"}]}], 
          RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"25", "/", "4"}]], " ", 
            SqrtBox["\[Pi]"]}]], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] E^Rational[-25, 4] Pi^Rational[-1, 2] (-Erfi[
             Rational[5, 2]] + Im[
            Erf[Rational[1, 2] (Complex[0, 5] + 4 Pi)]]), {}], 
        "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[
    StyleBox[{
      {Thickness[Tiny], 
       LineBox[{{0.3020588235294117, 0.}, {12.702708823529413`, 0.}}], 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, 
      StyleBox[{
        {Thickness[Tiny], 
         LineBox[{{0.5404411764705882, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {0.5404411764705882, 0.}]}],
          LineBox[{{12.459558823529413`, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {12.459558823529413`, 
            0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
           LineBox[{{1.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.4595588235294117`, 
              0.}]}], LineBox[{{1.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.5404411764705883`, 
              0.}]}], LineBox[{{2.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.4595588235294117`, 
              0.}]}], LineBox[{{2.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.5404411764705883`, 
              0.}]}], LineBox[{{3.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.4595588235294117`, 
              0.}]}], LineBox[{{3.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.5404411764705883`, 
              0.}]}], LineBox[{{4.459558823529412, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.459558823529412, 
              0.}]}], LineBox[{{4.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.540441176470588, 
              0.}]}], LineBox[{{5.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.459558823529411, 
              0.}]}], LineBox[{{5.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.540441176470588, 
              0.}]}], LineBox[{{6.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.459558823529411, 
              0.}]}], LineBox[{{6.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.540441176470588, 
              0.}]}], LineBox[{{7.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.459558823529411, 
              0.}]}], LineBox[{{7.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.540441176470588, 
              0.}]}], LineBox[{{8.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.459558823529413, 
              0.}]}], LineBox[{{8.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.540441176470589, 
              0.}]}], LineBox[{{9.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.459558823529413, 
              0.}]}], LineBox[{{9.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.540441176470589, 
              0.}]}], LineBox[{{10.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.459558823529413`, 
              0.}]}], LineBox[{{10.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.540441176470589`, 
              0.}]}], LineBox[{{11.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.459558823529413`, 
              0.}]}], LineBox[{{11.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.540441176470589`, 
              0.}]}]}, {}}}, 
        StyleBox[
         {Thickness[Tiny], 
          InsetBox["\<\"Re\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
           Automatic, {1, 0}], 
          InsetBox["\<\"Im\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
           Automatic, {1, 0}]}, "GraphicsLabel",
         StripOnInput->False]}, "GraphicsTicks",
       StripOnInput->False]},
     Antialiasing->False], "GraphicsAxes",
    StripOnInput->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.3020588235294117, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
       FormBox["\"Re\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox["\"Im\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.592057072075521*^9, 3.592057097646439*^9}, {
   3.6539945560734167`*^9, 3.653994564849016*^9}, {3.653994603235777*^9, 
   3.653994614082698*^9}, 3.6549486128139677`*^9, 3.6549493299949427`*^9, {
   3.6555539265428133`*^9, 3.655553956304641*^9}, 3.684450221793887*^9, 
   3.6844504971203747`*^9, 3.684450748810864*^9}]
}, Closed]]
}, Closed]]
},
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{1914, 999},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
Magnification->1.25,
FrontEndVersion->"10.4 for Linux x86 (64-bit) (February 25, 2016)",
StyleDefinitions->"Default.nb",
PrivateNotebookOptions -> {"ColorPalette" -> {RGBColor, -1}},
RenderingOptions -> {"ObjectDithering" -> True},
RenderingOptions -> {"RasterDithering" -> False}
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S5.33.1"->{
  Cell[991, 37, 294, 7, 38, "Input",
   CellTags->"S5.33.1"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S5.33.1", 959101, 18346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 99, 1, 38, "Input"],
Cell[669, 25, 225, 4, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[931, 34, 57, 1, 63, "Section"],
Cell[991, 37, 294, 7, 38, "Input",
 CellTags->"S5.33.1"],
Cell[1288, 46, 361, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[1674, 59, 427, 13, 38, "Input"],
Cell[2104, 74, 11669, 213, 298, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13822, 293, 61, 1, 63, "Section"],
Cell[13886, 296, 68, 1, 38, "Input"],
Cell[13957, 299, 79, 1, 56, "Subsection"],
Cell[14039, 302, 114, 5, 73, "Input"],
Cell[CellGroupData[{
Cell[14178, 311, 112, 2, 38, "Input"],
Cell[14293, 315, 2735, 58, 292, "Output"]
}, Closed]],
Cell[17043, 376, 86, 1, 56, "Subsection"],
Cell[CellGroupData[{
Cell[17154, 381, 90, 1, 30, "Input"],
Cell[17247, 384, 387, 7, 60, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[17671, 396, 126, 3, 38, "Input"],
Cell[17800, 401, 730, 18, 71, "Output"]
}, Closed]],
Cell[18545, 422, 63, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[18633, 427, 107, 1, 38, "Input"],
Cell[18743, 430, 1350, 35, 74, "Output"]
}, Closed]],
Cell[20108, 468, 152, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[20285, 474, 161, 3, 64, "Input"],
Cell[20449, 479, 1170, 34, 73, "Output"]
}, Closed]],
Cell[21634, 516, 69, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[21728, 520, 189, 5, 52, "Input"],
Cell[21920, 527, 70991, 1184, 287, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[92948, 1716, 292, 5, 38, "Input"],
Cell[93243, 1723, 38376, 653, 295, "Output"]
}, Closed]],
Cell[131634, 2379, 75, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[131734, 2383, 403, 13, 30, "Input"],
Cell[132140, 2398, 839, 24, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[133016, 2427, 418, 10, 38, "Input"],
Cell[133437, 2439, 21150, 540, 280, "Output"]
}, Closed]],
Cell[154602, 2982, 62, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[154689, 2986, 90, 1, 30, "Input"],
Cell[154782, 2989, 334, 6, 60, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[155153, 3000, 94, 1, 38, "Input"],
Cell[155250, 3003, 740, 20, 66, "Output"]
}, Closed]],
Cell[156005, 3026, 87, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[156117, 3031, 58, 1, 38, "Input"],
Cell[156178, 3034, 3052, 86, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[159267, 3125, 59, 1, 38, "Input"],
Cell[159329, 3128, 2260, 70, 121, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[161626, 3203, 98, 2, 38, "Input"],
Cell[161727, 3207, 1198, 32, 68, "Output"]
}, Closed]],
Cell[162940, 3242, 52, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[163017, 3246, 158, 4, 30, "Input"],
Cell[163178, 3252, 311, 5, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[163538, 3263, 88, 1, 63, "Section"],
Cell[163629, 3266, 68, 1, 38, "Input"],
Cell[163700, 3269, 62, 1, 56, "Subsection"],
Cell[163765, 3272, 76, 4, 52, "Input"],
Cell[CellGroupData[{
Cell[163866, 3280, 112, 2, 38, "Input"],
Cell[163981, 3284, 2147, 48, 299, "Output"]
}, Closed]],
Cell[166143, 3335, 86, 1, 56, "Subsection"],
Cell[CellGroupData[{
Cell[166254, 3340, 159, 2, 30, "Input"],
Cell[166416, 3344, 443, 7, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[166896, 3356, 244, 5, 38, "Input"],
Cell[167143, 3363, 834, 21, 71, "Output"]
}, Closed]],
Cell[167992, 3387, 63, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[168080, 3392, 107, 1, 38, "Input"],
Cell[168190, 3395, 1511, 39, 74, "Output"]
}, Closed]],
Cell[169716, 3437, 84, 1, 38, "Input"],
Cell[169803, 3440, 69, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[169897, 3444, 189, 5, 52, "Input"],
Cell[170089, 3451, 79845, 1331, 298, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[249971, 4787, 262, 4, 38, "Input"],
Cell[250236, 4793, 26254, 445, 298, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[276527, 5243, 313, 5, 38, "Input"],
Cell[276843, 5250, 17124, 294, 294, "Output"]
}, Closed]],
Cell[293982, 5547, 75, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[294082, 5551, 403, 13, 30, "Input"],
Cell[294488, 5566, 615, 12, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[295140, 5583, 418, 10, 38, "Input"],
Cell[295561, 5595, 20557, 524, 299, "Output"]
}, Closed]],
Cell[316133, 6122, 62, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[316220, 6126, 90, 1, 30, "Input"],
Cell[316313, 6129, 388, 6, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[316738, 6140, 94, 1, 38, "Input"],
Cell[316835, 6143, 879, 23, 66, "Output"]
}, Closed]],
Cell[317729, 6169, 87, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[317841, 6174, 58, 1, 38, "Input"],
Cell[317902, 6177, 2808, 77, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[320747, 6259, 59, 1, 38, "Input"],
Cell[320809, 6262, 2409, 73, 121, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[323255, 6340, 98, 2, 38, "Input"],
Cell[323356, 6344, 948, 25, 63, "Output"]
}, Closed]],
Cell[324319, 6372, 52, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[324396, 6376, 158, 4, 30, "Input"],
Cell[324557, 6382, 381, 6, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[324987, 6394, 90, 1, 63, "Section"],
Cell[325080, 6397, 68, 1, 38, "Input"],
Cell[325151, 6400, 62, 1, 56, "Subsection"],
Cell[325216, 6403, 114, 5, 73, "Input"],
Cell[CellGroupData[{
Cell[325355, 6412, 112, 2, 38, "Input"],
Cell[325470, 6416, 2307, 50, 292, "Output"]
}, Closed]],
Cell[327792, 6469, 86, 1, 56, "Subsection"],
Cell[CellGroupData[{
Cell[327903, 6474, 307, 7, 30, "Input"],
Cell[328213, 6483, 554, 9, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[328804, 6497, 241, 5, 38, "Input"],
Cell[329048, 6504, 768, 17, 73, "Output"]
}, Closed]],
Cell[329831, 6524, 63, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[329919, 6529, 107, 1, 38, "Input"],
Cell[330029, 6532, 1197, 27, 73, "Output"]
}, Closed]],
Cell[331241, 6562, 152, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[331418, 6568, 161, 3, 64, "Input"],
Cell[331582, 6573, 654, 18, 73, "Output"]
}, Closed]],
Cell[332251, 6594, 69, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[332345, 6598, 238, 6, 52, "Input"],
Cell[332586, 6606, 87575, 1480, 291, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[420198, 8091, 338, 5, 38, "Input"],
Cell[420539, 8098, 33095, 566, 287, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[453671, 8669, 365, 6, 38, "Input"],
Cell[454039, 8677, 37279, 630, 287, "Output"]
}, Closed]],
Cell[491333, 9310, 75, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[491433, 9314, 403, 13, 30, "Input"],
Cell[491839, 9329, 733, 17, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[492609, 9351, 418, 10, 38, "Input"],
Cell[493030, 9363, 20667, 524, 280, "Output"]
}, Closed]],
Cell[513712, 9890, 62, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[513799, 9894, 90, 1, 30, "Input"],
Cell[513892, 9897, 380, 7, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[514309, 9909, 94, 1, 38, "Input"],
Cell[514406, 9912, 602, 15, 65, "Output"]
}, Closed]],
Cell[515023, 9930, 87, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[515135, 9935, 58, 1, 38, "Input"],
Cell[515196, 9938, 1655, 46, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[516888, 9989, 59, 1, 38, "Input"],
Cell[516950, 9992, 1511, 47, 65, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[518498, 10044, 98, 2, 38, "Input"],
Cell[518599, 10048, 705, 18, 65, "Output"]
}, Closed]],
Cell[519319, 10069, 52, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[519396, 10073, 158, 4, 30, "Input"],
Cell[519557, 10079, 359, 6, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[519965, 10091, 90, 1, 63, "Section"],
Cell[520058, 10094, 68, 1, 38, "Input"],
Cell[520129, 10097, 62, 1, 56, "Subsection"],
Cell[520194, 10100, 119, 5, 73, "Input"],
Cell[CellGroupData[{
Cell[520338, 10109, 112, 2, 38, "Input"],
Cell[520453, 10113, 6832, 125, 292, "Output"]
}, Closed]],
Cell[527300, 10241, 86, 1, 56, "Subsection"],
Cell[CellGroupData[{
Cell[527411, 10246, 412, 6, 30, "Input"],
Cell[527826, 10254, 731, 11, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[528594, 10270, 441, 13, 38, "Input"],
Cell[529038, 10285, 191, 3, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[529266, 10293, 398, 7, 38, "Input"],
Cell[529667, 10302, 899, 18, 71, "Output"]
}, Closed]],
Cell[530581, 10323, 106, 2, 38, "Input"],
Cell[530690, 10327, 145, 3, 64, "Output"],
Cell[CellGroupData[{
Cell[530860, 10334, 107, 1, 38, "Input"],
Cell[530970, 10337, 1333, 31, 82, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[532340, 10373, 628, 18, 38, "Input"],
Cell[532971, 10393, 437, 12, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[533445, 10410, 669, 20, 38, "Input"],
Cell[534117, 10432, 439, 12, 63, "Output"]
}, Closed]],
Cell[534571, 10447, 152, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[534748, 10453, 125, 2, 38, "Input"],
Cell[534876, 10457, 544, 15, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[535457, 10477, 151, 3, 38, "Input"],
Cell[535611, 10482, 1135, 30, 73, "Output"]
}, Closed]],
Cell[536761, 10515, 69, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[536855, 10519, 189, 5, 52, "Input"],
Cell[537047, 10526, 92102, 1553, 287, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[629186, 12084, 339, 5, 38, "Input"],
Cell[629528, 12091, 34147, 595, 289, "Output"]
}, Closed]],
Cell[663690, 12689, 92, 1, 38, "Input"],
Cell[663785, 12692, 75, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[663885, 12696, 403, 13, 30, "Input"],
Cell[664291, 12711, 725, 17, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[665053, 12733, 418, 10, 38, "Input"],
Cell[665474, 12745, 20660, 520, 281, "Output"]
}, Closed]],
Cell[686149, 13268, 62, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[686236, 13272, 90, 1, 30, "Input"],
Cell[686329, 13275, 410, 7, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[686776, 13287, 94, 1, 38, "Input"],
Cell[686873, 13290, 675, 17, 66, "Output"]
}, Closed]],
Cell[687563, 13310, 87, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[687675, 13315, 58, 1, 38, "Input"],
Cell[687736, 13318, 1577, 43, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[689350, 13366, 59, 1, 38, "Input"],
Cell[689412, 13369, 393, 6, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[689842, 13380, 98, 2, 38, "Input"],
Cell[689943, 13384, 398, 6, 38, "Output"]
}, Closed]],
Cell[690356, 13393, 52, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[690433, 13397, 158, 4, 30, "Input"],
Cell[690594, 13403, 158, 3, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[690801, 13412, 132, 2, 63, "Section"],
Cell[690936, 13416, 68, 1, 38, "Input"],
Cell[691007, 13419, 62, 1, 56, "Subsection"],
Cell[691072, 13422, 148, 5, 52, "Input"],
Cell[CellGroupData[{
Cell[691245, 13431, 112, 2, 38, "Input"],
Cell[691360, 13435, 19089, 326, 292, "Output"]
}, Closed]],
Cell[710464, 13764, 62, 1, 56, "Subsection"],
Cell[710529, 13767, 86, 1, 45, "Subsection"],
Cell[CellGroupData[{
Cell[710640, 13772, 307, 4, 30, "Input"],
Cell[710950, 13778, 726, 14, 71, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[711713, 13797, 341, 6, 38, "Input"],
Cell[712057, 13805, 1114, 28, 97, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[713208, 13838, 106, 2, 38, "Input"],
Cell[713317, 13842, 210, 6, 71, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[713564, 13853, 107, 1, 38, "Input"],
Cell[713674, 13856, 1680, 42, 92, "Output"]
}, Closed]],
Cell[715369, 13901, 201, 3, 38, "Input"],
Cell[CellGroupData[{
Cell[715595, 13908, 151, 3, 38, "Input"],
Cell[715749, 13913, 2540, 72, 92, "Output"]
}, Closed]],
Cell[718304, 13988, 69, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[718398, 13992, 238, 6, 52, "Input"],
Cell[718639, 14000, 98454, 1637, 287, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[817130, 15642, 338, 5, 38, "Input"],
Cell[817471, 15649, 42486, 712, 287, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[859994, 16366, 413, 6, 38, "Input"],
Cell[860410, 16374, 62803, 1053, 287, "Output"]
}, Closed]],
Cell[923228, 17430, 75, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[923328, 17434, 403, 13, 30, "Input"],
Cell[923734, 17449, 4939, 154, 172, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[928710, 17608, 418, 10, 38, "Input"],
Cell[929131, 17620, 29145, 698, 278, "Output"]
}, Closed]]
}, Closed]]
}
]
*)

