(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    200836,       4083]
NotebookOptionsPosition[    196023,       3922]
NotebookOutlinePosition[    196978,       3957]
CellTagsIndexPosition[    196906,       3952]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData["$Version"], "Input",
 CellChangeTimes->{{3.539348909750384*^9, 3.53934891070532*^9}}],

Cell[BoxData["\<\"10.4.0 for Linux x86 (64-bit) (February 26, 2016)\"\>"], \
"Output",
 CellChangeTimes->{
  3.539348911010058*^9, {3.592056897373326*^9, 3.592056919195349*^9}, 
   3.592057096214797*^9, 3.684450843515994*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setup:", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"<<", "\"\<BarCharts`\>\""}], ";", 
   RowBox[{"<<", "\"\<Histograms`\>\""}], ";", 
   RowBox[{"<<", "\"\<PieCharts`\>\""}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.592056913172229*^9, 3.592056915577012*^9}},
 CellTags->"S5.33.1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"colors", "=", 
   RowBox[{"{", 
    RowBox[{
    "Red", ",", "Green", ",", "Blue", ",", "Cyan", ",", "Magenta", ",", 
     "Yellow", ",", "Black"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "colors", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.539348988919309*^9, 3.539349018937498*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", " ", "x"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}], " ", "//", 
    "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "colors"}]}], "]"}]], "Input",
 CellChangeTimes->{3.53934900404324*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxFxXss1AEcAPDDVnlOltPPjOiyYWKcNhWpRNJV7oiaZF7LKFq0rtqadJY8
IlbRaXROJXMnKpXH4eZUdJw7brrunM77cjHHZh7VH77fPz77OMal0RMNSSQS
7Z//n0icGhBMR/hvPll/Nk5FUA9tTjaVFTYSgfBe3x3cCiIc3t/vzX9EJMCC
Z10+BUQGnJ2Vd+MBcQ9OyNARuUQpvK00pOrPfDX8od8rONieB0dlK0a68prg
tIZr7k8XP8ILRUM9BgbtcE9Hd7v4YCeczAwxP6cVwh3GXht1l0VwDUe4brvn
KxxAbn3BqO+F3UWK5m5XMSwNYMy9nuuHU01SJDJPCfxNHtlqUTgIM4Ki1BqN
FN5XmRdZSRmCR9dLpJfuDMPjIWIOuUsO88tUzAHHEZh73yjX5eYPWB9/fibp
swI2DcyhN9go4duW42bqaBVs1uZGGqaNwn7XT691reDs6nzObrYajomg9hmH
jsHvZIklbUu4by/fcOLxL3jXsSR9SaAG9qH6FDdN4KqFgi8c1jis9Q5jEV4T
sPOs+4zBIC6kZErSsybhh1JZPJ0yBesYgmJDIf42wvqo79VpmNOXXTFmNQMv
i6JvWXXio8Xtessrs/DSwAHiroUWTi91EjBbcJs+J0tNzG+YIatbtVvHFy5W
pSpq5+D2WB7L4qQO/iRODVWewt/7u26vD8Pr7LhsWiReLi9vzI/DM8/kqE2Y
uFvABb+tNbgzz9Zo+BXuZC/vqXmD71ylhwc14Fuaj6ewWnC1B7XMaBBXPJ+P
GZThcnMehSPHv8+68I8o8ZaXDqKsabyZ/DM/TIs3ssrpjjq8Nt5aKVjEuRIJ
p2gZrzxclBy7grP5NA/PNfyJg6l+YwP/CxUIhds=
      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJw9xX1MFGQAB2A+tkpRRi5RnNMgclNHOoQ2KvlRkUZGxp2ENUUH4nJS2tIW
1daIzmWgQTA/CB12QmUMjiAlRe+Um6BJB8ed3PDk7vA44Dh54eLACHir+ev+
ePZEZu1T5AQFBASk/uu/X8sZ7NQNpSc+PCdxoPatLFtEHB6ejPAQ89EG/1vw
TMITVaf878JzHes03/o/AN13LfFH/H+JgvzCj7/2X4ZdB0TEYf9n8VhZypnR
sf9vxIWO2I0bl9VxLbYWWHtaChu5HvvqP4w5Mf4bvwFv8e22wEAtN6Dt6nWt
4YVr3Ig9eSnz3/bouQlX58TKmvdaeTeq1frZJU/f5D1ICr/8vbL2FrciptXa
dH2VgdtgSlKO/DTSwe3InbvXaF5r5H343ZJxOfRoF78H5YatDqfTxJ14trIw
ozL6NnfBPltqevfzbj6A/hSDOrzFwgehOWnL64zs4W5UfRV8eOUnd/gwfNnv
uHdfsnIPQpIPKeoX9fIRfBbWP8+xzcYF5l1ZHdCdauejWP/R5pmWKTsfRcXZ
IvVTFQ4+hsz0uPY5m/q4F7+ac0qvTPRxLxJuaYJcx+7xP/HkK7t9pclOPo74
uPiSRpeTj8PmPXJDrernPnjWpakiYl18AiuGY9yBXS4+AX30QeP+/AE+iW9M
5mxF9CB/AKHUlQTpB/kD/JK+8OWED4b4X1C3F5zqW+DmU5hs3fbpgmtuPgV7
idYX9v4w/xsTnc9HfBHq4dPYXxaly2v28Gksao8Kc2be5zNQmmuml87e5zPw
7jiTaz03wmeh3VmnCn1dcImLhtxNvW8ILnE+cdXjtWmCS9QsrapIzRBcotxS
3lCUJbjEwTcPOebmCS6xOmn7+kerBZdYUbckuPtHwSWillnaqn8WXGLxtGLL
hnrBJR5penWvqllwCceauJPBXYJLWE+PZXaZBZewzK+LVlsEl/hjeKXmpV7B
JZp/WN6aPyS4RFP43aI0j+ASDapyRaQQXOJc9sJe3bjgElVGo7p4UnCJyheL
9+ycElyiQpO6Zu2M4BLHl4f4pBRc4h+NTYqr
      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV0vlfzHkAx/Hp0DejeiQMQ6JrVqwrxbJb709ps7HpPpB4RBFttbaotFba
QVSmwq4OXaa1tDUptqVjdCi2u0Zt92S6p77dkY7lh9fj+Q+8NN18bN1lGQyG
5ac+u9+9r1bY72D8/oB3grWPr3FvhqNbB9sAhxWuLKvmHARriSgym22GZB4c
Iziu2LJ7OT+BbY9Sh/sXvDje2FOzQxDNPgmnXEtFF84lCOOKDSPYfkjy5NfY
cSIRGnIz4Ab7V5iZ1uZYce7jpB/NDmPfxt0tvWmWnAwo3rZIHhl9ACXX4dG+
M4X4u0Z/3z6NTISpe/g/dSyDc2hrc/HNHMiX7i/n11bBJ+unzb9P/INlpSyt
cxfqMcZ7Wy4jU4hn0iTHl6QR5S9fFVZ/U4R0rUeJu460wDPQQvmQtAQaO4dj
uG4deLlYfyH9hzLYXHMvNIkWIy21ZH617hvkBS1DQ9w7EFZ+il1GBQQ1ys8L
rnRjc1lr7quN1XC7w2euON6LBmI3/OdwDYzFwd3z7v3wYp6tE22rQ8qtpBfE
YhD/Njnlq0TWY1upnDrLYQh25s5iiaQBwZ7ytk5ONHYm3XRK0nmLDbkPTQLi
RtA5H9Nw+pdGbFjwToxMHEW3RXUqq7gJXhdaZqyjxyC41xFYq9kMs+xTa47e
Gwf/ulyYXlALgtOKOIlxE5g8cXjA40Ur3r8p3hoRPoklZldts1a2QzFbMlcS
NYVg1W4lsUsHjlY8fv2QOw2lgk2MRstOqCWYXC7yew+j81ZzxTOdcNk+/VE3
4APiH4SnaseLMTBl6294ZgauDgaViw90QflyVXak70c8FbnHFEx1gSdc1bb2
3Cx2Vwhke+6+g6P+YvlDbnNY/63HZIyZBIJT7JE2j3kYGhhG5fRIYF1V/Z/K
4QV0jEW8TuV244vzGxv36DCIdIcNl63fg9GeWe0YPoNwBjcPyNT3wMU3xcdE
Q4aU6PjX+Yb0IqalMWF5sgy51SA6YavTh7PHOt8YrZEltJ0wSrakD+PG1kMy
MbLkicOKvbt/7Ic5w3psYLkcSa0MTehSG8CeZq0pvUg5Ml3mclGtaAAf7nBb
I5bKk86owklV70Gc/ssqNzxankzVfs2+oiJFQJs0WsxcRHxvawkD86Swp9nW
RyIWkZWVWqoS1yHUslcrbaIUiJ0ofVZ9fgjziSH5dy4pkLFjyV6tj4YxRQXa
6DIoUng8k6vyPY1b1/dKmIEUeV7tdaD9II2KuKhczkWKPDPeuDTDhoZiZke4
6c8USVfnx1t++iREdNEwKIQisU2x2eFuNPy0cq72h1HE3/qqmBlIwzlPR688
liKbyFEjKo3G+pFF3tw8inAyV8s1PqThImdvmlxAES2NpvK0xzRiWSmsfCFF
Vs3a2ptn0VAzMi6cKKGIQu53Z7l5NORvnFc9WUkR8VaDe3L1NPq1e5+YtlOk
9f6oa72Ihu4uw2uunRRpUs7USW2i4bY/9EhQF0WqBvUEpu00mn3XyT/poUje
H+vKQvppVOY7OWjSFMlltYXbSGkwa/l6RqMUyebG2mrSNMwl43PO4xR5dGJF
u3CChpDJS+NNU4RfV5fKm6Yxu7Y9KP0DRZJMeJ7HZ2h8tf1Lq/KPFIkXWG7d
NkfD3yxIWzJHkd/WLZlcWKCR5VQ+vbBAkf8BwRtcCQ==
      "]]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwtyH9MFGQcx/EDDPn9kEvsnNMgclNHOoQ2Kvl8K9LIqDgkrBk5EJeT0pa0
qLZGdC4DDYJVEjbsgMoYHEFFhXLKTaikg+NOLiPg6Ph1nDxK/GiE0LXv88d7
r+0dmXVEl+Or0WhSvP3v4znjPaaJ9EQ2L3Gs/pmsQW0c2D2ICLafatImKQ/g
3oQ7as54P3sM93dvN37o/ey7MH3aHn/S+9lyFBYUvf6+97PVOHBMak94P9uM
gPLkszduVivN+L47dteu9Q1KC/YW9l9rL2pW2nCk8dWYT2Z+UP6O6ZKrnT4+
bcpBdF683GZ58JJyGIfyk0Of9ZiVLlwMjF2ue6lDOYZag3lp7T2/KN2giPOf
p9VfUXoQ09HfcnmzRSlho7Spr6a6lTeQG3TYat9mVU7jV0fG+bBTvcq/kbZz
r9PlsilncF9VUUZV9FXlHIaWymwvvt2nnMdIssUQ0e5Q/gPj6cH8nshrygXU
vOd3YtMbfyj/xWz2c+6DP/UrFxGcdFzXuGZAuYS3wkdCnPsGlcsIubBF05cy
pNTQjteeutW+MARWQ5XVxYa7K51gfSgzPa4rcPcwWF/61p5TdmFuGKwvJVwx
+o5+9BdYP7rr0YOzZUkusCsoPi6+tHnUBXYFDU6f/NmgHwF7G3m2p+q1saNg
/WnjZIzbp3cUrD+Zo/OsRwvGwK6kD2z2bF30ONgAkmmmUl/zONgA+iZ99SMJ
r0yADSRDV+GZ4VVusEE037HvzVWX3GCDaKi0bTb85UmwwTTX84D2nTAP2BA6
Wh5lym/1gA2hNV1R4a7M62BDKc1et7hu6TrYUJp+4Wxu/7kpsGHUtr9BH/aE
BCvoR0vu7oEnJVhB3yVuvr0+VYIVVLeupjIlQ4IVVOGoaCrOkmAF5T193BmU
L8EK2kLP71hZK8EK2tiw1q/vSwlWUNR6R2ft1xKsoDsXdXt2NkqwgvxbHjus
b5VgBTm3xp3265VgBfV/djOz1y7BCnKENkQbHBKsoN8mNxkfHpBgBbV+saGj
YEKCFdQS8WdxqkeCFdSkr9BFSglW0Lns1QOmGQlWUI3VaiiZl2AFVT1Ucmj/
ggQrqNKYsnXbLQlW0McbgmeXlyVYQf8BNrBhqQ==
      "]]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVjms0lAkYgDEh1/AtNRKTte1JkVw6sZv3rRQS5baT1so9NqWk3ZStxSIi
NJ1EbDToaihqKTEZm+sQY7AltxiM0ec2yE5j7Y/nPP+e82z0D3cLkpORkXFe
4X8fCBprZ4972uZc8lfYHnjRdpT1g38/1RLyj4ps6DQv0FHhXyuj2kGvc3IE
jRYKptZfFeZSPeCCvZe6PC0KbN5alF6nBoJDHXovGCQB+zbHKpUaCaWxlnFT
BlkQF3P1fDL1Dxj2Y+lMGjyAwEiSmkS9Ab+5nvCdMKiE1Tcc86emC0D58+3G
MNMm+Outub29fglE1F5OEUXw4Ehc7zvO1XIwLWC0l7P+gfAnZ01uzVXCiEuI
Xv/OAZhJ72qQla2BTN2EDfm+H6Hh9Zuatu9rwSaiooTSIoDQKEc1L1EdcLpv
Hw7/VgivlcyXH5+sh+0pUtt1jpNQxKyT6n7TBA4Cm34z+hSgzqu77qwWGDN5
vm9ONA0m9b0Vb4zbIFqSZFF1YRY60f3Tg09vQUlzLNTDWAxhyic6+GYdoMiV
t1d5NQ/NPfRX6td4IG0tDrt+ZhHc9x8ZHB7uhDE6i6qvvwQ78q7S84y6wO7K
qZMNxf/CgJTRGXK5G25JK5T2HvsCI45tTB1OD/jocQ72zkqhNKs/qn3jO1Bn
bxEZespg4RVK0uYL7+G41V2x11ZZFAccFQa/7IWoS+fdaGJZVLFLcHuytg8S
hQxea6scRmuMqA5694OL8Zr7qtkUVK3eItPtPABpxTvYB/1W4a5fDn3hLA1A
iztTEmktjzkFKcyvcwaBww1P2UpRQB9PS66S0xA8/zkGWz4o4DN+EKN6fggM
nWDnqXJFtG4plRPc/Aj2y95xd6JXI21fsJhhNwwhXTUzFZ5KaGVplVEuGIY9
MbHP/GjK2D+T2siMH4HM8OmXqqPKKLJwjaeaC2D090LBnWoV3DRhIpTlCWAq
qDKwNlEV64zOdZyOGQXxSS1Frp8apnXyA9yMxqDMsVkSbKKOpDs7Q65uDCZC
zHZQxOr41FN7r/WZcdB/9I6RyF2DTG5c7pCWEBJ8I+5ynTRwod77olatEJYk
1FSnSg0cyKgRa5yagK0vM7OajDRxvv07aqy6CGwC/j6kmaSJp28YsqOqRPAm
R3tdi1gT13INNYZ9JsGUrZ3s8qMWuvMfS/Skk+AhL9rQUa2FM8fyw3offoKF
98OcRmMCa3xL4tUPkvBrTiqRlEbgi7Ywpz4XEjpljcgDGQQ+tzXWZLmSYH78
RZMqg8DHeoU5znQSRNtHY9JvEpjdk12W4k+Cbz1OZeYSeO5wwqByFAmOM7Mt
RY8I3II/7VIsImG9w9GEunoCN5XoUrrvk3C+eMovoZFAQ/2ehqJHJPC1Enc5
NBO4TuLmsf8JCWkfyuaaWwlUqHA4EV9FwqqzagE8PoGD2yyzKDwSJnPZMPSR
wN4/p314fBIOUOjrC0YI7FErMWL2kHAvZHI+aJTA1onNpXv6SPCz0GWNCwms
umdQHzNOQlfDWb3paQIrdD6kuIpIsDBVXnw6S2BZfLbbRpKEdEYeL1JM4MMA
7T723Erfh5u8uEhgYUcHM31hpc8JCH6xRGDe7vRQ36WVv81Lu6MlBOaUOm8z
+0KC/7X0DbZSAjMNVMTLyyRUz276vLxM4H8qRV70
      "]]}, 
    {RGBColor[1, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV0vk/1HkcwPFxFMaxzvk2JeWaTW2XqK1d3m+yWrXWOEcl9VCUstiWQrZN
diqFhql2c+RqbFvWEbW2HJMjamlcEyvG0bgnnxA6MLU/vB7Pf+Bl7Bfi5q9I
o9GcP/W/O/2Hm4UjnrZvdwWns0PO2A7le/n1MK1gz+KzeiKWLzDUxYnFTAfI
4oFXAisY1m3VF6QzPaDW88bJINZp2Na0qTCZeQg4pc6qPqxEEKZWWycwwyAz
UNDkzroBsTGXIi4yfwUH++YSF1Y+HAojzDjmFbi2bijXmVUBqlecsl5P3AQN
3/GJ4aMi+LvJcscOowKIMwwIv+fVDt6xXZ3Vl0pAuXZnvaBZAiFFP639/c0/
oFfLMDl+8iVM8p7XKyhUwn1ZptcjHIL6R48rRV9XQZ7J7Ywte8cgMNJJc7es
Bow2j/O5fgQeqVnK836oA9fz/pV2yROQm1OzsNT8KZRF6UFb6hQgozzbPb8B
Cps0H1ScnYa1dV2lj1eLwO+qgG5wYBba0H38z/EmsO2LHljwfwdB9GMt4g0t
kH058yE6fYB/OzjlWomtsKFWyZDhOQ/ujt59UmkbRAcqu3E4cticeYmTafYc
VpXesotIpWHvAr/tyC/tsEoenJGYoYADTqIcRnUHBJ188Z6drIiF13sim407
waH48LJ915VQcEEpziLqBUTnVrEyUpVx+uCe0YCHXfD2afX6hPhFqO5wzq2I
koBqsXS+JmkxRmsPaPT59MC+hjtPbnFVUKNiDa3duRd00+3OVIWpos0Jl/nq
973gs3H2g3mEGqbdjM8xTeuD0Rm3cOujdPT1tGpU29UPmmeeFSeGquM9sT+/
YqYfeMIl3cuPa+DWhkLFwWsvwctSTXm3nyau/CZgmu8ghcLDzNfdAVpobWWd
VDIoBfYz0X9aez7DnsmEJzncAfj8xOr2bWbaKNvkymVaDsLE4JwpX6CNrLG1
owqtg+ATmh1iZ6SDNWbhLaExQ8B/0Z6un6WDl9vEB93MhuHY/t6nNst0kbgL
kxRrhmHKlv1Kga+Ldz0Ntm/9cQQcaezJUX09zGmMTe/XHYVtnSYzFol6OFvn
c0q3ahTeXeV2JejoY29S5bR28Bgc+culND5ZH2eav2Ke1ZJBRLcsuY9ugKFX
TISRZTLwIEz23gQDpBpNtKW+r6CZuVRjjQoD3cV5c4YLr2AhI6b86mkGTu7P
Cuq6PQ4zKpGu5jQKKw8UcLW+I3D5wnYpPZLCB6KgXZLvCTSkJpWyTlF433a1
Tr4rAdWCnnj7nynMMxSkOXMIxIhPWUfFUJjSkVIc/+nbMJOScyNxFIazz/XR
Iwl4l5lZ1KdQuAb32ajkElj5elEwt4xCVsFSpfZbBHyUPOyzKig0Meqoz71D
IIWRzSgXUrhkzs3DsYiAro1t5ZsaCheXfnuMW0ZA+eIJ7UONFPatt7qu1Epg
xHTorr2Ewq4bE76tYgLmW6zP+/ZS2KFZYJbTQcBvZ+zeqH4Kn41ZFNpLCHSG
rlC+O0hh2R8r6mJGCDSWczyNCYWljO54VxkBerPAwmaCwmJuipsxIeAonZr3
nqLw9kEDifANASGdl8ubpVDQ0pLDmyUwt1wSlfeOwkw7XuCB9wS+3PiFS/0H
CtMKnddvmCcQ7hBlKp2n8LcV6tNyOYEiTv2sXE7hR8RNUOk=
      "]]}, 
    {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVxXk41HkcAGBHlzPkmvlJkhWFDvSsxOejFEJlhhxpEmnXQ4eHLKotWaKc
q6aSWrODIg9mtChkxMa2WecwW64RcuUby1SK2d0/3uddH3iGESwnIyPj/p//
3x881i4Y97Ln+DyqTDKLt39XcjhwgGYFin8rRXHZx0FbSZhWTnOE8pAFvYvs
cLCw0cy/R/OEVfzwDyHsONjZZln2M+0EWB429wtgZ4LgboN1Ki0SnE2U0o+w
ORAfdz36Gu0nYKrHmvqyeXAiktCSaTdAlMCTeLPrYdUNF86HmTy4etwglc/s
gMq27U5O+qWQG+XG+nHnG/CJ733dcP0xvJ+9fMx1QQxneBHmt+eegIPt7xuX
V4zCbEZ3s6xsHXQ9q04XG0xCc/2LutZdz0G/82566ASBkBgXFd+pRti1P3ey
5cAs1CtslxafaoLkZtdjHy/NQQG3cYn+zUvYtnrq/g+DEkDt2l+ZJa8gOiLY
Iln3M5g39Va92NQKThb14lN7v0AXMqcLp9sggqd+vJCzCGGKoR3CrR1gx7Dd
GiWUwp8i71rVtE7g9xWPuOnJInOfj3h4uAuS7cz3OjvL4Y7c6965Rt2wxSzb
TTlAHgeXsrq+v9QDyy7JPj2fvgxHXFq52g0ieBjg1VpetBzL7gzEtK9/DbEF
3P23+lZgfpJ8smnsG8jQees9rLgK54P8Jk5W90KUzmqVhQ0KqOSYyODp9MO1
89Ym1Z6KeEFtRFnsPwBhp50nHcOVUPnZZpke90G4meKG3yYpo13UwcWGhUGY
VHX90l2hgjl5KdwNOWJQN9jBsm9XRZaXVYuC6xDwX6ZmPZRVw9+EwVnPJEOw
RP8sGL2lhjavyuRG2W+Bz/fbrWCkjgZ7T85nOQ7DhQtPomRr1NHayjrz8egw
lKSqSvtcNHBgNvUPbsIIxFv5HyJdGjhl6ZFA2z4Kp1UeeHaHrkHjSfMJ2c5R
qDcfK+Z8WoONRuc6zsa9A7PLxlW7MzUxvUsYxDAag0XaEZ3mdVpImIJMucYx
CHdJgiuPtJDvpbXHJnwcvhbx6Rp7tJHbEn9vSGMCCLPTJbFNGz82+Z/XeD4B
nyxmNreF6OBgZt282ulJyPtlZc8BGV2UtNvSrqhOQaW3ZjcvRRfP3jAUxNRM
wZCDftKEEQ11WgzVhlnvITJCP21lOQ2ZwuKvekvvoXCnzlFfezrOHuOE9RZN
w5ylysBlIR3rAkoTVN0IPIj8/DglkMKnrWGu/QcINFhL4+SCKayw36Re4kFg
QLLsYPR3FBbr5ee4exPQjlEbDwqjMFuUXZ4SSODqxY1rbaMoPHcoUawYQ+Bk
olfCeDKFm/Go3coCAsa3eV77eBQal9Llex4ScPCtNKwpp9BQX9Rc8IgAi15L
tlVQqPuV4bmPR+BmTnPy2moKV1Q5hybUEFjOGaida6RQvMXqjnwngZFCFWOu
iMLe+zOsTiEBmdA1/+i+oVCkUmrEFRFYa0YTpPVR+NekadnufgKeJUZ+sUMU
1jxY1xQ3TqCRb5vmMUVhlXZfiscUAXGEw5GmaQrLE7IZ6wmBRSsnE7sZCouC
tPoFcwSsKxnPTSQU5nd0cDM+EjgU7ZN+/xOFuQ4ZIQELBMJsWP6aXyjMKXPf
snWRQNJCkOm1RQpvrVOal0oJ5FWHSKRSCv8FsR1NYg==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {0., 6.999999857142857}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.539349006579371*^9, 3.539349015930273*^9}, {
   3.592056899069939*^9, 3.592056923076399*^9}, 3.592057096628575*^9, 
   3.653994552005143*^9, 3.6539947209853983`*^9, 3.654948464552854*^9, 
   3.684450843644289*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1:", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Plot the sample function:", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=x /; x <= N[Pi];
f[x_]:=0 /; x >= N[Pi];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539348926308318*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0HswGwYcwPFIlHiVoMmcV6JEl5YrS806VVF0aowsK1WvqnazLUI4rh5n
WtXuZkTqlGs9SjEaz05tmlKWtHUzyx6mRdo0pS2NO1cqXahsu5vf73f3u+99
/vvdj5Es4J4gEgiEgn/3v5KGTMef7Cny3yydSmc6XUjcv9lXSlHEA7EAquKM
qm+IC6ETmXOSZnE5VFG6TKkV10PDa3Jl1eIuaKnzYG2VeAi6oDXSczIVUN83
FZHX0+9DRx/GnCFuV0EDAnlrLcmz0Nj00KW+I8+hgwzW6dvNGiivmtWkTFuC
2m+5dUB08iX03Dvy3tvnV6DBBw8ltZSsQuVfrzCLc19DF761lT6q1kGP5fSU
L4nXoQUuMq/C/g2o50bBKjGVELDZu/Exy/QUA6hXHX+yIIsIDYoaju0TkqA7
5z6S7ywxhAqtMvzqKrdAj3cquC9ERlCmxxeROY3GUI3o4UJWC7Z3JeqssB27
T+o7wO/F8sKMXFNGsEWpV7SRauxM82Qdy4UMbTQJe28HE/sZf/APNxZ2md1M
ZnhjTWVCIS0Q66u2CDFMxl5wClpUXsHeGJvPuduMncotJ/a0YemTU7TiHqyk
PCOQNYy9Q6i/mK3CzncGuSTNYs3jFyShz7Ef/7hnxGEJq8oY04zosSS6MEdC
MoEyx2nEKmMsn3WclmqJFd0nN3JtsN+XdO7yo2En2bx+N3usTv03x9IZ61hR
P/baxSSA8P8E7A+OVjPRKYsLj39moc9dEn3Z54luD/XR1nmjx7XTRed90LY8
94tH/dHvEn9hBAeiY7uFEs8QdIP54LBBBNpDztO0xqMjM3XZFcfQWYwGg7wT
6IGCF9QIPjrE5zRnJR+d1NpVFXAZbcR56VDYgO6YYjfduorWWQx07e1AV2bJ
7rEH0fc4D3Q7VOjdM8REiqspmEA57K6+hg5d3Bud0GYGTmmPTbOTmoMfb5iL
FaMWeN+dN7xk+Vawnv+23vsvS/yHLNRV8LkVOMrxg18Dn6GlT58s9qVRwHnz
TnHURXRTnHYfNdsaTDcRCEir6AiD3a1pmTbgudQy7qk1tMKsNDwj1xbs5uQu
JRtuA7PyzbycvkEX25S/optQwQftuz1+qkAnxKX3cSk0MHP+1IGkMnT0U3qw
BfUtsNLh06rWSvRhN7+5mSq0woPCtq5Bj/jf/C2/Fv1dkqUFtwUtvNp/Zr0f
bbyLnBE1jf6KrRwqUaJ1fr1bpY/QmvA4CXMW/bug+9maBn35ekxCywZ6m9Sj
Y5pgBy6TEdetSOiiCUlNnjH6pJYwEWmFVukntpdYo4+Qrwlv2qI/tPvEimmH
ljNYiUft0f4sfYfIEf2D95/rcme01/ttYWsM9D+1IW2i
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 3.140165820539889}}, {{0, 6.283185307179586}, {0., 
     3.140165820539889}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.539348926652747*^9, 3.539349023983239*^9, {3.592056899236961*^9, 
   3.592056930923074*^9}, 3.592057096786184*^9, {3.6539945553910418`*^9, 
   3.653994564214849*^9}, {3.653994602476725*^9, 3.653994613306777*^9}, 
   3.654948387490789*^9, 3.654948471686008*^9, 3.6549485069281273`*^9, 
   3.684450843893367*^9}]
}, Open  ]],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["c[0]= 1/(2 Pi) Integrate[ x  ,{x,0,1 Pi}]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{
  3.539348898608249*^9, 3.539349024083955*^9, 3.592056900043282*^9, 
   3.592056931073666*^9, 3.592057096800711*^9, {3.6539945554408913`*^9, 
   3.6539945642812357`*^9}, {3.6539946025558243`*^9, 3.653994613374568*^9}, 
   3.654948390510152*^9, 3.654948474194743*^9, 3.654948511022745*^9, 
   3.684450843946623*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
c[m_]= 1/(2 Pi) Integrate[ x Exp[- I m x] ,{x,0,1 Pi}] //FullSimplify\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "\[Pi]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348899882002*^9, 3.539349024467109*^9, 3.592056900477057*^9, 
   3.592056931261525*^9, 3.592057097008535*^9, {3.653994555571148*^9, 
   3.653994564408968*^9}, {3.6539946026898823`*^9, 3.6539946135026283`*^9}, 
   3.654948392881493*^9, 3.6549484760088367`*^9, 3.6549485135191097`*^9, 
   3.684450844087739*^9}]
}, Open  ]],

Cell["term[0]= c[0];", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["term[m_]= c[m] Exp[I m x] + c[-m]  Exp[-I m x]  //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "m", " ", "x"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "m", " ", "\[Pi]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"\[ImaginaryI]", " ", "m", " ", "\[Pi]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348900096125*^9, 3.539349024623434*^9, 3.592056900596742*^9, 
   3.592056931376429*^9, 3.592057097120233*^9, {3.653994555646126*^9, 
   3.653994564481369*^9}, {3.653994602805489*^9, 3.6539946136003237`*^9}, 
   3.6549484779031267`*^9, 3.654948518518489*^9, 3.684450844138115*^9}]
}, Open  ]],

Cell["series[n_]:= Sum[ term[m] ,{m,0,n}]", "Input",
 CellChangeTimes->{{3.6549485336493683`*^9, 3.654948534968346*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"series", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{{3.654948537062978*^9, 3.654948544343122*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox["\[Pi]", "4"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{3.654948544832046*^9, 3.68445084415909*^9}]
}, Open  ]],

Cell["Plot the series with different numbers of terms", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Plot[ Join[{f[x]},Table[series[i],{i,2,5,1}] ] //Evaluate
  ,{x,0,2 Pi},PlotStyle->colors]\
\>", "Input",
 CellChangeTimes->{3.653994609851053*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJxF0HswGwYcwPFIlHiVoMmcV6JEl5YrS806VVF0aowsK1WvqnazLUI4rh5n
WtXuZkTqlGs9SjEaz05tmlKWtHUzyx6mRdo0pS2NO1cqXahsu5vf73f3u+99
/vvdj5Es4J4gEgiEgn/3v5KGTMef7Cny3yydSmc6XUjcv9lXSlHEA7EAquKM
qm+IC6ETmXOSZnE5VFG6TKkV10PDa3Jl1eIuaKnzYG2VeAi6oDXSczIVUN83
FZHX0+9DRx/GnCFuV0EDAnlrLcmz0Nj00KW+I8+hgwzW6dvNGiivmtWkTFuC
2m+5dUB08iX03Dvy3tvnV6DBBw8ltZSsQuVfrzCLc19DF761lT6q1kGP5fSU
L4nXoQUuMq/C/g2o50bBKjGVELDZu/Exy/QUA6hXHX+yIIsIDYoaju0TkqA7
5z6S7ywxhAqtMvzqKrdAj3cquC9ERlCmxxeROY3GUI3o4UJWC7Z3JeqssB27
T+o7wO/F8sKMXFNGsEWpV7SRauxM82Qdy4UMbTQJe28HE/sZf/APNxZ2md1M
ZnhjTWVCIS0Q66u2CDFMxl5wClpUXsHeGJvPuduMncotJ/a0YemTU7TiHqyk
PCOQNYy9Q6i/mK3CzncGuSTNYs3jFyShz7Ef/7hnxGEJq8oY04zosSS6MEdC
MoEyx2nEKmMsn3WclmqJFd0nN3JtsN+XdO7yo2En2bx+N3usTv03x9IZ61hR
P/baxSSA8P8E7A+OVjPRKYsLj39moc9dEn3Z54luD/XR1nmjx7XTRed90LY8
94tH/dHvEn9hBAeiY7uFEs8QdIP54LBBBNpDztO0xqMjM3XZFcfQWYwGg7wT
6IGCF9QIPjrE5zRnJR+d1NpVFXAZbcR56VDYgO6YYjfduorWWQx07e1AV2bJ
7rEH0fc4D3Q7VOjdM8REiqspmEA57K6+hg5d3Bud0GYGTmmPTbOTmoMfb5iL
FaMWeN+dN7xk+Vawnv+23vsvS/yHLNRV8LkVOMrxg18Dn6GlT58s9qVRwHnz
TnHURXRTnHYfNdsaTDcRCEir6AiD3a1pmTbgudQy7qk1tMKsNDwj1xbs5uQu
JRtuA7PyzbycvkEX25S/optQwQftuz1+qkAnxKX3cSk0MHP+1IGkMnT0U3qw
BfUtsNLh06rWSvRhN7+5mSq0woPCtq5Bj/jf/C2/Fv1dkqUFtwUtvNp/Zr0f
bbyLnBE1jf6KrRwqUaJ1fr1bpY/QmvA4CXMW/bug+9maBn35ekxCywZ6m9Sj
Y5pgBy6TEdetSOiiCUlNnjH6pJYwEWmFVukntpdYo4+Qrwlv2qI/tPvEimmH
ljNYiUft0f4sfYfIEf2D95/rcme01/ttYWsM9D+1IW2i
      "]]}, 
    {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwtmnk81N/3x2dBZJ3BzCiVhCRt0k73hEQJ2fctCUlIm/ogRSpJEkmhlH3N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      "]]}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVV3k8lN8XHrPIbhhmRkVSlkrJ8o2K7gklJVtIkiQhJWUPlUqiBRWhiCIk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      "]]}, 
    {RGBColor[0, 1, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwtW2k4lO/btswM2WcMhiRpR2VJlOW6kiRJUZY2SVKJkpBKJUklSRIpSchO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      "]]}, 
    {RGBColor[1, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwVV3k81F8Xto19mDHGECEhhRYqhbqnhYRsSSpJKsoPlSxtCklItkRKJQnJ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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.29629934552611825`, 3.140165820539889}}, {{
     0, 6.283185307179586}, {-0.29629934552611825`, 3.140165820539889}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.65399461374361*^9, 3.6549484834084797`*^9, 
  3.6549485548749247`*^9, 3.684450844211441*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot[ {f[x], series[100] } //Evaluate ,{x,0,2 Pi}]", "Input",
 CellChangeTimes->{
  3.653994599133656*^9, {3.653994831421143*^9, 3.653994831802074*^9}, {
   3.6549483586859407`*^9, 3.654948359130992*^9}, {3.654948565646303*^9, 
   3.654948574802985*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0HswGwYcwPFIlHiVoMmcV6JEl5YrS806VVF0aowsK1WvqnazLUI4rh5n
WtXuZkTqlGs9SjEaz05tmlKWtHUzyx6mRdo0pS2NO1cqXahsu5vf73f3u+99
/vvdj5Es4J4gEgiEgn/3v5KGTMef7Cny3yydSmc6XUjcv9lXSlHEA7EAquKM
qm+IC6ETmXOSZnE5VFG6TKkV10PDa3Jl1eIuaKnzYG2VeAi6oDXSczIVUN83
FZHX0+9DRx/GnCFuV0EDAnlrLcmz0Nj00KW+I8+hgwzW6dvNGiivmtWkTFuC
2m+5dUB08iX03Dvy3tvnV6DBBw8ltZSsQuVfrzCLc19DF761lT6q1kGP5fSU
L4nXoQUuMq/C/g2o50bBKjGVELDZu/Exy/QUA6hXHX+yIIsIDYoaju0TkqA7
5z6S7ywxhAqtMvzqKrdAj3cquC9ERlCmxxeROY3GUI3o4UJWC7Z3JeqssB27
T+o7wO/F8sKMXFNGsEWpV7SRauxM82Qdy4UMbTQJe28HE/sZf/APNxZ2md1M
ZnhjTWVCIS0Q66u2CDFMxl5wClpUXsHeGJvPuduMncotJ/a0YemTU7TiHqyk
PCOQNYy9Q6i/mK3CzncGuSTNYs3jFyShz7Ef/7hnxGEJq8oY04zosSS6MEdC
MoEyx2nEKmMsn3WclmqJFd0nN3JtsN+XdO7yo2En2bx+N3usTv03x9IZ61hR
P/baxSSA8P8E7A+OVjPRKYsLj39moc9dEn3Z54luD/XR1nmjx7XTRed90LY8
94tH/dHvEn9hBAeiY7uFEs8QdIP54LBBBNpDztO0xqMjM3XZFcfQWYwGg7wT
6IGCF9QIPjrE5zRnJR+d1NpVFXAZbcR56VDYgO6YYjfduorWWQx07e1AV2bJ
7rEH0fc4D3Q7VOjdM8REiqspmEA57K6+hg5d3Bud0GYGTmmPTbOTmoMfb5iL
FaMWeN+dN7xk+Vawnv+23vsvS/yHLNRV8LkVOMrxg18Dn6GlT58s9qVRwHnz
TnHURXRTnHYfNdsaTDcRCEir6AiD3a1pmTbgudQy7qk1tMKsNDwj1xbs5uQu
JRtuA7PyzbycvkEX25S/optQwQftuz1+qkAnxKX3cSk0MHP+1IGkMnT0U3qw
BfUtsNLh06rWSvRhN7+5mSq0woPCtq5Bj/jf/C2/Fv1dkqUFtwUtvNp/Zr0f
bbyLnBE1jf6KrRwqUaJ1fr1bpY/QmvA4CXMW/bug+9maBn35ekxCywZ6m9Sj
Y5pgBy6TEdetSOiiCUlNnjH6pJYwEWmFVukntpdYo4+Qrwlv2qI/tPvEimmH
ljNYiUft0f4sfYfIEf2D95/rcme01/ttYWsM9D+1IW2i
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVV3c8l98XR332VkmitFRSpKVS91iRygohCUkUQvbIntnZEUVWCqkUcSXZ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      "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA7I37Ve7DEUBQZI3CrcNfP9TqKICx
xRFAxgWd/tXZaj+rZGW7kccRQAxoHzNeznI/tlAePYvJEUDoNZ2MU8R3P8E8
176EyxFAGGk+mIjTez/MKJBAfs0RQBjW/MC21X4/1xRJwnfPEUAMiSCOX1eA
P+IAAkRx0RFADSHLfNimgD/t7LrFatMRQDRki2ayVoA/+NhzR2TVEUCVHrbv
pdR+PwPFLMld1xFAsxOp7unVez8OseVKV9kRQDLzxmqYznc/GZ2ezFDbEUDE
F+Cw6uVyPySJV05K3RFAgKQDKtyWaj9frB623t4RQHRlZqj852A/btNFmFbh
EUBAcfGg84EhP0VNgtM24xFAuB8guTT3Vb9QOTtVMOURQCgyuSm8QWe/WyX0
1innEUBCs9jMvFBxv5qDKZ886RFAP/ScCD+Sdr9w/WXaHOsRQCGGEki5hHq/
e+keXBbtEUAQj8LQr7F9v0hLpls67xFApJZhIOref78UrS1bXvERQGrKTDoo
UoC/4Q61WoLzEUBmFlF3Kvp/v65wPFqm9RFAjv/yuujofb960sNZyvcRQNU1
5Pq6iHq/xJKrvwn6EUD8Th1djb91vxSW0lgS/BFAhYpJs9ODcL/mOpmL//0R
QLTI5P8g7GW/QSDtRw==
      "]], LineBox[CompressedData["
1:eJwBoQNe/CFib1JlAgAAADkAAAACAAAAJu2Qnt4EEkBA0mExNtxkPww8OCP9
BhJAOiPEvu18cD/f4P5V6ggSQNZuK5o9X3U/rEKGVQ4LEkAGIeKf5+J5P3ik
DVUyDRJA744OHYZAfT9FBpVUVg8SQDJmgfoCU38/EmgcVHoREkCbEc149QGA
P97Jo1OeExJAHrMITmBMfz+rKytTwhUSQKys3OldNX0/eI2yUuYXEkA9fQXm
R9d5P0TvOVIKGhJAqoAOds9YdT8RUcFRLhwSQM9o6VJt2m8/3rJIUVIeEkDm
BPs0EKRjPzP5rh0kIBJA4FFRKfMqUT/AyenuRiMSQDAzMStPtVW/wDY/ttkk
EkDkzPn1yU5kvxA6Zk/iJhJAspcUAyzBb7/cm+1OBikSQJxpnJv7M3W/qf10
TiorEkB2FxRUjpV5v3Zf/E1OLRJAuzQNAqbUfL9CwYNNci8SQOhOPh57zX6/
DyMLTZYxEkAerCzCsGp/v9yEkky6MxJAIQDtozumfr+o5hlM3jUSQPC9DlKc
iXy/dUihSwI4EkAKd6GOai15v0KqKEsmOhJAYHLBVje4dL8ODLBKSjwSQGSy
mB6luW6/2203Sm4+EkA+i2JIELBiv3QxRkm2QhJAYDGpGOHITD9Ak81I2kQS
QGSZr99A52M/DfVUSP5GEkC81X7tk7RvP9pW3EciSRJAxscw8wYLdT+muGNH
RksSQHIAcOLrS3k/cxrrRmpNEkDsmoqQuW18P0B8ckaOTxJA9kpgnulNfj8M
3vlFslESQJnJ2MQq2H4/2T+BRdZTEkBfZ3V8PAd+P6ahCEX6VRJAeFdbxyDl
ez9yA5BEHlgSQPZ3hVaiing/wga33SZaEkCyZQFdmVx0PwzHnkNmXBJAGo99
TXikbT/ea2V2U14SQPql5al4AGM/1VI811NgEkDQjdaThgpNPxcWfpEoYxJA
kE/Yw1BXU7+7rByoEWUSQN7AXb/ZuWS/CrBDQRpnEkAyp2e/eKlvv9cRy0A+
aRJAQ95B4D3kdL+kc1JAYmsSQFb+u7XGBXm/cNXZP4ZtEkDzTu8mcgt8vz03
YT+qbxJAanwFd+7Tfb8Kmeg+znESQOXa/vPrS36/1vpvPvJzEkAGTXq07W59
v6Nc9z0WdhJAvpQFOXNHe79UO73yFXgSQISjziL6L3i/BhqDpxV6EkAi060N
6Sx0v7j4SFwVfBJAYsQeezrMbr/hJTh7+30SQIqIMSxQpGS/peyFlw==
      "]], 
     LineBox[CompressedData["
1:eJwVVXs41VkXJgcR4rdlpDLRmCO5dSJdsFcpFLkWlXIr11wP534UqYaSkktN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      "]], 
     LineBox[{{5.509019035141801, 0.003557615964463235}, {5.510999656258636, 
      0.004270581651409305}, {5.513084520592146, 0.004837855365092937}, {
      5.515169384925657, 0.005193095179045821}, {5.5174627356925185`, 
      0.005320943317305003}, {5.519339113592678, 0.00521605655391953}, {
      5.521423977926188, 0.004883182407723396}, {5.523196112609672, 
      0.0044317506686948616`}, {5.525234067495678, 0.0037408673773391054`}}], 
     LineBox[{{5.632026030818923, 0.00261508242478266}, {5.634006651935758, 
      0.003451339058750483}, {5.636091516269269, 0.004183206914210723}, {
      5.638176380602779, 0.00473160057431889}, {5.6402612449362906`, 
      0.005072682205302171}, {5.642346109269801, 0.00519169625585124}, {
      5.644195209487827, 0.0051071517640827535`}, {5.646238951834064, 
      0.004809547702584648}, {5.6481853731161955`, 0.00433812789978721}, {
      5.650326436526539, 0.0036297828349919547`}, {5.652078215680458, 
      0.002924420644572896}, {5.6538299948343775`, 0.00212912134287623}}], 
     LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAzYFs+m0PF0ChnyowLjx0P15ccLVS
ERdAGrR08SvLdD+RgqjrRhMXQDOs2cOEnnQ/xKjgITsVF0Dcc25ZbLBzP/fO
GFgvFxdALPfRJLoJcj8T9waRPBkXQNJBekzBMG8/XRuJxBcbF0DG27DYP65p
P3lDd/0kHRdAae2xAUCdYj/EZ/kwAB8XQPjucnLsIlc/InXzQ68fF0CdWn4K
VrpRPypWV6lWIxdAxGfP6BDJR78w3g3ZDiUXQPTl+aN/hlm/kQDaCdEmF0C4
J4bnmFpjv8QmEkDFKBdA7NpWdrv9ab88RyhubioXQLj9s46t426/E3U4r8Ys
F0AbdB+gtzByv12ZuuKhLhdADsRMZiOwc7+Qv/IYljAXQFoNf20uj3S/w+Uq
T4oyF0DC0lcqMK10v/YLY4V+NBdAqIgvnisJdL8pMpu7cjYXQGVk1lpAqXK/
RVqJ9H84F0AEpRAS1Htwv49+CyhbOhdAuiLYe0bga7+rpvlgaDwXQCsYj1TR
L2W/9sp7lEM+F0ABejPE6shcvybc4awkPxdAzn7L5T/9Vb/UxB0dMEMXQGxx
ty6AGEU/BkloR7ZEF0AUPc9mOaVWP8NjXG0URhdATl0lrZKJYD/2iZSjCEgX
QGhBMAr4cWc/QK4W1+NJF0AwkTVRKzZtP1zWBBDxSxdAlGhRips5cT+m+oZD
zE0XQImDPKkJ/3I/qyQrf/JPF0BguoqlBUJ0P/VIrbLNURdARSDcLhegdD8o
b+XowVMXQMT64ZNVRnQ/W5UdH7ZVF0Be/lYKZC5zP6W5n1KRVxdA0h55QKZ9
cT960gNy
      "]], 
     LineBox[{{5.883414799939546, 0.003058832198399617}, {5.885318186111967, 
      0.0037532844559098003`}, {5.887130934847607, 0.004287381318481779}, {
      5.889246116262608, 0.004729918595784996}, {5.891109339923129, 
      0.00494361034492055}, {5.893179588434819, 0.004978147531589733}, {
      5.894939299669754, 0.004838511648595854}, {5.897630622734953, 
      0.004336155151851532}, {5.8993903339698885`, 0.003834212243863022}, {
      5.901460582481578, 0.0030923353396796116`}, {5.903530830993268, 
      0.002217554268302703}, {5.905394054653788, 0.001347764962436845}}], 
     LineBox[CompressedData["
1:eJwVVHs4ldkajzrdhuOSeLfEplRCSOaM0l7vKIqmRMg12w5bRHt/n5wuOMRQ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      "]], 
     LineBox[{{5.569584344030283, 0.002681428733484194}, {5.571460721930443, 
      0.0034818419137111426`}, {5.573337099830602, 0.004158250257976158}, {
      5.575734693814139, 0.004804691741271675}, {5.577715314930974, 
      0.005130083715957294}, {5.579800179264485, 0.005253414331591204}, {
      5.58178080038132, 0.005157686160694458}, {5.583969907931506, 
      0.004815500578830449}, {5.585950529048341, 0.004305522619484223}, {
      5.588139636598527, 0.0035456202057944646`}, {5.590224500932037, 
      0.002663023913139591}, {5.592205122048872, 0.0017167067353826724`}}], 
     LineBox[CompressedData["
1:eJwB0QIu/SFib1JlAgAAACwAAAACAAAATGWQhuqnFkB0SSmwGs5nv9SadaD6
qRZAmKasyvRabr+AKENVrKsWQL7GZJlBaHG/hClik6qtFkBYbZVsB2lzv4gq
gdGorxZAFKuqIvqrdL+MK6APp7EWQJtucaHqJHW/kCy/TaWzFkCPZS6uX890
v5Ut3oujtRZAxDi1PsCuc78nCOJGiLcWQE7QvVGF6nG/ni8cCKC5FkCcudpt
S4Buv6IwO0aeuxZA/vzB0lk7aL+mMVqEnL0WQIZQoUbyCmG/3pgMtjS/FkDn
AbELPqBVv4We/j1IwBZABITTa5XNSb/z9D7OFsQWQADohhD6aVI/uDXWfJXF
FkAwAjyRJj1eP7w29bqTxxZAyCb8uNF4Zj+mhEr/xMkWQAyYXEX2jW0/xDgz
N5DLFkCubDnXISxxPzxgbfinzRZAdrQFvzJKcz/OOnGzjM8WQHnxi//wgXQ/
0juQ8YrRFkDIKFkPhgZ1P2MWlKxv0xZAg5jk5kbGdD/bPc5th9UWQA5pD3ab
qnM/4D7tq4XXFkCLzNwppNdxP+Q/DOqD2RZA+gIX9p2tbj91GhClaNsWQH79
K4CH1mg/7EFKZoDdFkDbevHa0mZhP8s1qw7M3hZAEsO2yGXTWD8L+HAaSOMW
QOjLOYeMaEe/+kSnIHvjFkAQmVghNKdKv1e5F+jF5RZA4Ab7D7V0X78CR+Wc
d+cWQKS6x71F8GW/Oq6Xzg/pFkAUPSkLIjtrv31vPpyN6xZAlmRAXloPcb8P
SkJXcu0WQPwLPjyWAXO/FEthlXDvFkDwnL1fhlh0vxhMgNNu8RZAv1Ok7aLo
dL+pJoSOU/MWQHrQXHdmtHS/z2HC8hr1FkCHEPW1/9xzv+ydhleE9xZAsm1O
NVzEcb+ddhdPgfkWQEoU3lKrk26/LlEbCmb7FkDgs4At08Zov0wFBEIx/RZA
xIYXI5p+Yr8UR1Be
      "]], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA62GLiwumF0Bc8AjsoBNgvwUV/fgG
qBdAJJJ9snsCZ7+U1M9n76kXQNyrRw/g3Gy/iHDWGw6sF0AGtDlS/RVxv30M
3c8srhdAVJA+GYwAc79yqOODS7AXQNbFwrgRGXS/NFZQFU+yF0DSNsGDAVZ0
v1zg8OuItBdAmKodpLGtc79QfPefp7YXQE+bkvKvLnK/eAaYduG4F0BQJZqK
X4pvvzq0BAjluhdAcficYQrhab8uUAu8A70XQOWWLgXn1mK/iiFECNG+F0CX
fNyAJ2pYv+4CjOiFwBdAzrajfaJMRr8p0nyq3MMXQJj6qcjHrE4/m4rz88/F
F0Co7q6+UzheP/ZbLECdxxdAXOvBpjp/ZT+EwgBcDcoXQIz/yNAyCG0/4JM5
qNrLF0By48VxKMdwP9QvQFz5zRdAvJtemnDDcj+W3azt/M8XQKYvCYtu5nM/
8VXn5lHSF0DESFdREz90P7MDVHhV1BdATdhyHfCxcz+on1osdNYXQLD5fEyk
SXI/aU3HvXfYF0CB7yQTPzhwP5HXZ5Sx2hdAxXhmsfFoaj+Gc25I0NwXQLKv
8rLaf2M/RyHb2dPeF0AAUepnF09YP0Dk2W8=
      "]], 
     LineBox[{{4.62927605051848, 0.0020096917189797864`}, {4.630935253943379, 
      0.0031482426035625895`}, {4.632887257972673, 0.004371131211724399}, {
      4.634839262001966, 0.005423903319488901}, {4.63679126603126, 
      0.006266577160624535}, {4.638743270060553, 0.006867305865676341}, {
      4.640695274089847, 0.007203580370292905}, {4.64264727811914, 
      0.0072630720653972265`}, {4.644599282148434, 0.007044083672766122}, {
      4.646551286177727, 0.00655559190108725}, {4.648503290207021, 
      0.005816881107041316}, {4.650455294236314, 0.00485678285245547}, {
      4.652407298265608, 0.00371255131174281}, {4.654164101891972, 
      0.002561749338057602}}], 
     LineBox[{{5.536018028260762, -0.0015792708124560467`}, {
      5.538102892594273, -0.002596034267703608}, {
      5.540187756927784, -0.0034984096324149113`}, {
      5.5422726212612945`, -0.00424704213049539}, {
      5.544253242378129, -0.004786056652350116}, {
      5.546650836361668, -0.005183747619514387}, {
      5.548527214261827, -0.005286425045971158}, {
      5.5506120785953375`, -0.005180741405300829}, {
      5.552592699712172, -0.004870418769792276}, {
      5.554886050479034, -0.004272427284628898}, {
      5.556866671595869, -0.003573181311256123}, {
      5.558534563062677, -0.0028740706907787053`}}], 
     LineBox[{{5.602837930149776, -0.003506940516963963}, {
      5.604818551266611, -0.004203405521143334}, {
      5.606903415600121, -0.004756263753514284}, {
      5.608988279933632, -0.005100713857871405}, {
      5.610864657833791, -0.005220018649071133}, {
      5.613783467900706, -0.005038325476479047}, {
      5.6152428729341635`, -0.004783752026950413}, {
      5.6174319804843496`, -0.004211927099665015}, {
      5.6194126016011845`, -0.0035191154998184615`}, {
      5.621497465934695, -0.0026409128966317077`}, {
      5.6235823302682055`, -0.001647918411508288}, {
      5.6248332488683115`, -0.001014968798175871}}], 
     LineBox[{{5.8415259929720325`, 0.002001267711697718}, {5.843243333879481,
       0.0011792627014408877`}, {5.844292819989588, 0.0006582715546953649}, {
      5.847155054835336, -0.0007817965868857448}, {
      5.848967803570976, -0.0016673696407160273`}, {
      5.8508759601348075`, -0.002538915695921502}, {
      5.852497893214064, -0.003207351155361894}, {
      5.85458255426005, -0.0039389619573962815`}, {
      5.8566958376544935`, -0.004504274301328326}, {
      5.858508586390133, -0.004828403849119851}, {
      5.860321335125773, -0.0049925979792184326`}, {
      5.862224721298195, -0.004987092643500367}, {
      5.864442953303649, -0.0047515748548142235`}, {
      5.8663320283018425`, -0.0043649810554787175`}, {
      5.868049369209291, -0.00387715918379073}, {
      5.87043456491408, -0.0030127167224559895`}, {
      5.871865682336955, -0.0024080488240846615`}, {
      5.873583023244403, -0.0016183230519683793`}}], 
     LineBox[{{5.974027968437589, -0.0016465193695078834`}, {
      5.976093041328, -0.0025686071716777394`}, {
      5.978059777414105, -0.003344356079055571}, {
      5.980130025925795, -0.004019313067890697}, {
      5.982200274437485, -0.0045205681824064346`}, {
      5.984374035374759, -0.004836520757408662}, {
      5.986340771460864, -0.004924376889692287}, {
      5.988514532398139, -0.004798513784754517}, {
      5.990481268484245, -0.0044878570586925565`}, {
      5.992551516995935, -0.003972655181581595}, {
      5.994621765507624, -0.0032864946127216725`}, {
      5.996588501593729, -0.0025032618471480137`}}], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAWlyUrbzjGEDo9jn1575EvwmQEQC0
5BhA4JlSaPgvUb9mVjH7W+YYQFw9HfnQb1y/314GSpHoGEBMSD1BaRNlvx9a
6lSq6hhArnoDFxunar/Sb7Dn++wYQPBX+7fJem+/S3iFNjHvGECmUuaqtEhx
v8SAWoVm8RhADiAuwRwHcr8+iS/Um/MYQNZITyVZ8nG/t5EEI9H1GED6m71H
MQ5xvzCa2XEG+BhAAKZtb1LQbr+qoq7AO/oYQLoIv3xtLWq/I6uDD3H8GEBk
uuHeB3Bkv5yzWF6m/hhAsHo8JznBW79qlFrhhgAZQCYVMpOdkE+/SkEE7IoB
GUBK7gKGz0hCv3rnudJ+BRlAbJ63SBhmUD+B1ayZewcZQJBqyT4NRFw/+t2B
6LAJGUD6EzJH7QRkP63zR3sCDBlA3N2Tj2YraT/t7iuGGw4ZQMhmwCEexmw/
ZvcA1VAQGUBgg08ccmhvP+D/1SOGEhlALPuD5mNtcD9ZCKtyuxQZQJp4OWdh
mXA/0hCAwfAWGUDgn2Z8ck1wP0wZVRAmGRlA2Fv8YRRRbz/FISpfWxsZQOio
m6gppG0/dzfw8awdGUCMQTaie9xrP7gy1PzFHxlAJAafm5ecaj+/IMfDwiEZ
QLukhoTBFGo/pRXYbw==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.28067691679237217`, 3.390868220493906}}, {{
     0, 6.283185307179586}, {-0.28067691679237217`, 3.390868220493906}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.653994603041923*^9, 3.6539946138813553`*^9}, 
   3.6539948325858994`*^9, {3.654948562245084*^9, 3.6549485752540903`*^9}, 
   3.68445084436171*^9}]
}, Open  ]],

Cell["Make  a \"frequency domain\" plot of the coefficients", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}], ",", 
       RowBox[{"Im", "[", 
        RowBox[{"c", "[", "i", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], " ", "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "4"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "\[Pi]"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "0", ",", 
   FractionBox["1", "4"], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"9", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "6"]}], ",", "0", ",", 
   FractionBox["1", "8"], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"25", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "10"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.539348900461853*^9, 3.539349025162924*^9, 3.592056900794857*^9, 
   3.59205693153894*^9, 3.59205709743393*^9, {3.65399455589922*^9, 
   3.653994564692024*^9}, {3.653994603096509*^9, 3.653994613952845*^9}, 
   3.654948610036271*^9, 3.684450844369812*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"coeffs", ",", 
   RowBox[{"ChartStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Re\>\"", ",", "\"\<Im\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.592056964512083*^9, 3.592056985563291*^9}, {
  3.592057062331558*^9, 3.592057071627198*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.3020588235294117, 0}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.616], 
     Thickness[Small]}], 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5404411764705882, 0.}, {1.4595588235294117`, 
            0.7853981633974483}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{44.200605242096835`, 
           74.75738054321049}, {-120.6882902111151, 22.90563888928169}}],
         StatusArea[#, Rational[1, 4] Pi]& ,
         TagBoxNote->"Pi/4"],
        StyleBox[
         FractionBox["\[Pi]", "4"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[1, 4] Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.540441176470588, 0.}, {2.4595588235294117`, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{76.7663767697085, 107.32315207082215`}, {
           22.280638889281693`, 22.905638889281693`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5404411764705883`, 0.}, {
            3.4595588235294117`, -0.3183098861837907}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{109.33214829732016`, 139.8889235984338}, {
           22.28063888928169, 80.8487633714004}}],
         StatusArea[#, (-1)/Pi]& ,
         TagBoxNote->"-Pi^(-1)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "\[Pi]"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[(-1)/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5404411764705883`, 0.}, {4.459558823529412, -0.5}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{141.89791982493182`, 172.4546951260455}, {
           22.28063888928169, 113.92248598881318`}}],
         StatusArea[#, 
          Rational[-1, 2]]& ,
         TagBoxNote->"-1/2"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "2"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[-1, 2], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{4.540441176470589, 0.}, {5.459558823529412, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{174.4636913525435, 205.02046665365714`}, {
           22.280638889281693`, 22.905638889281693`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.540441176470589, 0.}, {6.459558823529412, 0.25}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{207.02946288015514`, 
           237.5862381812688}, {-23.22778466048405, 22.905638889281693`}}],
         StatusArea[#, 
          Rational[1, 4]]& ,
         TagBoxNote->"1/4"],
        StyleBox[
         FractionBox["1", "4"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 4], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.540441176470589, 0.}, {
            7.459558823529412, -0.035367765131532294`}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{239.5952344077668, 270.1520097088804}, {
           22.280638889281693`, 29.343763831739324`}}],
         StatusArea[#, Rational[-1, 9]/Pi]& ,
         TagBoxNote->"-1/(9*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"9", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 9]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.540441176470589, 0.}, {
            8.459558823529413, -0.16666666666666666`}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{272.16100593537845`, 302.7177812364921}, {
           22.280638889281693`, 53.244587922458855`}}],
         StatusArea[#, 
          Rational[-1, 6]]& ,
         TagBoxNote->"-1/6"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "6"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[-1, 6], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.540441176470589, 0.}, {9.459558823529413, 0.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{304.72677746299007`, 335.2835527641038}, {
           22.280638889281693`, 22.905638889281693`}}],
         StatusArea[#, 0]& ,
         TagBoxNote->"0"],
        StyleBox["0", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{9.540441176470589, 0.}, {10.459558823529413`, 0.125},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{337.29254899060174`, 
           367.84932429171545`}, {-0.47357288560117894`, 
           22.905638889281693`}}],
         StatusArea[#, 
          Rational[1, 8]]& ,
         TagBoxNote->"1/8"],
        StyleBox[
         FractionBox["1", "8"], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[1, 8], {}], "Tooltip"]& ]}, 
     {RGBColor[1, 0, 0], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.540441176470589`, 0.}, {
            11.459558823529413`, -0.012732395447351628`}, "RoundingRadius" -> 
            0]},
          
          ImageSizeCache->{{369.8583205182134, 400.4150958193271}, {
           22.280638889281693`, 25.22336386856644}}],
         StatusArea[#, Rational[-1, 25]/Pi]& ,
         TagBoxNote->"-1/(25*Pi)"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"25", " ", "\[Pi]"}]]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[Rational[-1, 25]/Pi, {}], "Tooltip"]& ]}, 
     {RGBColor[0, 0, 1], EdgeForm[{Opacity[0.616], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.540441176470589`, 0.}, {
            12.459558823529413`, -0.1}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{402.4240920458251, 432.9808673469388}, {
           22.280638889281693`, 41.10900830918799}}],
         StatusArea[#, 
          Rational[-1, 10]]& ,
         TagBoxNote->"-1/10"],
        StyleBox[
         RowBox[{"-", 
           FractionBox["1", "10"]}], {}, StripOnInput -> False]],
       Annotation[#, 
        Style[
         Rational[-1, 10], {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[
    StyleBox[{
      {Thickness[Tiny], 
       LineBox[{{0.3020588235294117, 0.}, {12.702708823529413`, 0.}}], 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, 
      StyleBox[{
        {Thickness[Tiny], 
         LineBox[{{0.5404411764705882, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {0.5404411764705882, 0.}]}],
          LineBox[{{12.459558823529413`, 0.}, 
           Offset[{-1.102182119232618*^-15, -6.}, {12.459558823529413`, 
            0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
           LineBox[{{1.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.4595588235294117`, 
              0.}]}], LineBox[{{1.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {1.5404411764705883`, 
              0.}]}], LineBox[{{2.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.4595588235294117`, 
              0.}]}], LineBox[{{2.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {2.5404411764705883`, 
              0.}]}], LineBox[{{3.4595588235294117`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.4595588235294117`, 
              0.}]}], LineBox[{{3.5404411764705883`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {3.5404411764705883`, 
              0.}]}], LineBox[{{4.459558823529412, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.459558823529412, 
              0.}]}], LineBox[{{4.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {4.540441176470588, 
              0.}]}], 
           LineBox[{{5.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.459558823529411, 
              0.}]}], LineBox[{{5.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {5.540441176470588, 
              0.}]}], LineBox[{{6.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.459558823529411, 
              0.}]}], LineBox[{{6.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {6.540441176470588, 
              0.}]}], LineBox[{{7.459558823529411, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.459558823529411, 
              0.}]}], LineBox[{{7.540441176470588, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {7.540441176470588, 
              0.}]}], LineBox[{{8.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.459558823529413, 
              0.}]}], LineBox[{{8.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {8.540441176470589, 
              0.}]}], LineBox[{{9.459558823529413, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.459558823529413, 
              0.}]}], LineBox[{{9.540441176470589, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {9.540441176470589, 
              0.}]}], LineBox[{{10.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.459558823529413`, 
              0.}]}], LineBox[{{10.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {10.540441176470589`, 
              0.}]}], LineBox[{{11.459558823529413`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.459558823529413`, 
              0.}]}], LineBox[{{11.540441176470589`, 0.}, 
             Offset[{-7.347880794884119*^-16, -4.}, {11.540441176470589`, 
              0.}]}]}, {}}}, 
        StyleBox[
         {Thickness[Tiny], 
          InsetBox["\<\"Re\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
           Automatic, {1, 0}], 
          InsetBox["\<\"Im\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
           Automatic, {1, 0}]}, "GraphicsLabel",
         StripOnInput->False]}, "GraphicsTicks",
       StripOnInput->False]},
     Antialiasing->False], "GraphicsAxes",
    StripOnInput->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.3020588235294117, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
       FormBox["\"Re\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox["\"Im\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.592057072075521*^9, 3.592057097646439*^9}, {
   3.6539945560734167`*^9, 3.653994564849016*^9}, {3.653994603235777*^9, 
   3.653994614082698*^9}, 3.6549486128139677`*^9, 3.6844508444934196`*^9}]
}, Open  ]],

Cell["Re-write the Exp series as a Trig series", "Subsection"],

Cell[CellGroupData[{

Cell["term2[0] = term[0] //ExpToTrig //Simplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{
  3.539348901072105*^9, 3.53934902523506*^9, 3.592056900871686*^9, 
   3.592056931675244*^9, 3.592057097671525*^9, {3.6539945561216993`*^9, 
   3.653994564877943*^9}, {3.653994603372724*^9, 3.653994614166765*^9}, 
   3.654948617597234*^9, 3.684450844508748*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["term2[m_]= term[m] //ExpToTrig //FullSimplify", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
   RowBox[{"Cos", "[", 
    RowBox[{"m", " ", "x"}], "]"}], "+", 
   RowBox[{"m", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
  RowBox[{
   SuperscriptBox["m", "2"], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901338854*^9, 3.539349025465629*^9, 3.592056901077137*^9, 
   3.592056931864159*^9, 3.592057097861994*^9, {3.653994556335165*^9, 
   3.653994565006339*^9}, {3.653994603495202*^9, 3.6539946142942657`*^9}, 
   3.654948620062367*^9, 3.684450844647999*^9}]
}, Open  ]],

Cell["series2[n_]:= Sum[ term2[m] ,{m,0,n}] ", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["series[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"6", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"18", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "5"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"10", " ", "\[ImaginaryI]", " ", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"5", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], "+", 
      RowBox[{"5", " ", "\[ImaginaryI]", " ", "\[Pi]"}]}], ")"}]}], 
   RowBox[{"50", " ", "\[Pi]"}]], "+", 
  FractionBox["\[Pi]", "4"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"8", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"8", " ", "\[ImaginaryI]", " ", "x"}]], " ", "\[Pi]"}]}], 
     ")"}]}], 
   RowBox[{"32", " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{
  3.539348901508812*^9, 3.539349025532612*^9, 3.592056901121194*^9, 
   3.592056931985405*^9, 3.5920570979048*^9, {3.653994556759735*^9, 
   3.6539945651973667`*^9}, {3.653994603566409*^9, 3.6539946143891582`*^9}, 
   3.654948624824272*^9, 3.684450844772593*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["series2[5]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "4"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"4", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], "+", 
    RowBox[{"3", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"9", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "x"}], "]"}], "+", 
    RowBox[{"4", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"16", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", "x"}], "]"}], "+", 
    RowBox[{"5", " ", "\[Pi]", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "x"}], ")"}]}], "]"}]}]}], 
   RowBox[{"25", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], "\[Pi]"]}]], "Output",
 CellChangeTimes->{
  3.539348901647589*^9, 3.53934902562461*^9, 3.592056901159855*^9, 
   3.59205693204438*^9, 3.592057097944783*^9, {3.653994556831818*^9, 
   3.653994565364707*^9}, {3.653994603636812*^9, 3.653994614428404*^9}, 
   3.654948626578991*^9, 3.684450844788514*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"series2", "[", "5", "]"}], " ", "//", "TrigReduce"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"225", " ", 
    SuperscriptBox["\[Pi]", "2"]}], "-", 
   RowBox[{"1800", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "-", 
   RowBox[{"200", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "-", 
   RowBox[{"72", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}], "+", 
   RowBox[{"900", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{"450", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], "+", 
   RowBox[{"300", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "-", 
   RowBox[{"225", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], "+", 
   RowBox[{"180", " ", "\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}]}], 
  RowBox[{"900", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{
  3.539348901716475*^9, 3.539349025693151*^9, 3.592056901169058*^9, 
   3.59205693210773*^9, 3.592057098009361*^9, {3.653994556897757*^9, 
   3.6539945655319557`*^9}, {3.653994603705914*^9, 3.653994614503924*^9}, 
   3.654948629062478*^9, 3.684450844806488*^9}]
}, Open  ]],

Cell["Verify that they are identical", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"series2", "[", "5", "]"}], "-", 
   RowBox[{"series", "[", "5", "]"}]}], " ", "//", "FullSimplify"}]], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539348901862293*^9, 3.539349025783277*^9, 3.592056901228616*^9, 
   3.592056932189663*^9, 3.592057098170868*^9, {3.6539945569647207`*^9, 
   3.653994565644332*^9}, {3.653994603768785*^9, 3.653994614569409*^9}, 
   3.654948631890818*^9, 3.6844508448335876`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 1: f[x_]=x  for x=[0,2 \[Pi]]", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=x;\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349040775506*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxWlM0mEcAGAED7zBg2ImQiYujBZmWyszz5kVhsy8IiUzmzVBseW8Zqaj
Wqb41zHd1FYmZmqajmyT1Apqfilq0TEjTUXTZHN5NUGoPvh7Pzx7GJli/gU8
Dofj/vN/wojT2+kDFWFb0yl0Jq0+4+jWq3pZ/FdMDE9GjE09xcphXYGhux2r
hbXVy+QW7C7MbSpWN2K9cLXfcIscG4EX1u2tEQVa+OBmHW8g7ws89j2lEu8/
CYdHJpoUmTNwWl7ckjL1JzzMYF0fbV+EExtZbXrREuxj9zxKlv0bvrFf0z96
cwWOiT0uVEjXYM2tFWZV8R944Y6XaqJxAz5X+KR2CTPDZTvVnPJBC7zXUraG
z8GFb/3mbMoyPcsG5rTmfi67goejE16kKSUEOMhwShMktYUlpPzQ1gY7+Pxj
Lf+XzB5msi/zCu87wPW0aKP+HhEWdvTKw5sdYRw5KXCqywmOMx5KTu90hrMe
pYmoKhf4h8UF0465wvavNxMzNW6wNXe3NfiTO8xTx+0SXyLBCb7H3kXOoVWz
00aliAyXzNMEFCO6TbB+hHLVA6Y7isWENXS8zb4OUYEnbMip4ReZ0Frnam5+
sRccQAtUEW29YVapM4d2G13lWbtKd6TAsT597Fd16HRBnpJP3gYz54uihDXo
5Fl6jCtlO6zfcVHe0YBOCgg1fJOjtWxyiEcT+mXY0PvSFvRDobsrX4GWPBis
NA+iHfYQ8xPG0ddC9CNSPXojtN9NNYFe5Aq6mTPoD+K+OdMiunkgJV1hQXur
2D3jOCpco8abSQR0ha67qcQBnb2O0/FI6Emrzl/qgU4ldkmGvNAnqadJTCpa
w2BlnPFBh7GsPTJf9LPgj2aNH5pzuPOEiYH+CwXPEkU=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 6.283185178951315}}, {{0, 6.283185307179586}, {0., 
     6.283185178951315}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.539349041386338*^9, 3.539349043487687*^9}, 
   3.592056901415043*^9, 3.59205709853264*^9, 3.6539955922417393`*^9, 
   3.654948434833316*^9, 3.654948654034005*^9, 3.6844508449248867`*^9}]
}, Open  ]],

Cell["Compute the Fourier coefficients", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 2: f[x_]=...  for x=[0,2 \[Pi]]", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=1 /; x <= N[Pi];
f[x_]:=0 /; x >= N[Pi];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349047726298*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF0H0s1AEYB/Cfk7eQO3Fl3u6UU6ezSGolnLykIm5XXpIuqabiOKZ5W4mp
lrxlXlahvEVEtZuWQy93qvV2taTi8k5ebjPJ6cj1snmeZ/vuu89/3z30cD7n
GIkgCN7f/Gv19uVvBzenuRD/b8rVtyRJXJzf6LrkLMu2G4X57eBxhaaKHScF
b/2d5/8g5jP45begdNKaPrCbO3e+OnwIHBLjMyUM/g5uozPPP66aBHOLmRWy
6CmwqUbrztzj0+ALmyT3H1+cAXt67+ZVZ86CJZdmGBlJc7j3ipGot1gJPnLm
Xs5U/gI41Upsf7Z5EWy3mDpLiiTclvz8UNAPWoQa2L40qis1ngT2CHgSIhSo
g22H90lsM5eBBeRY59ICDfDRu1LORK4mmME65X/mlha4p6qrlGmlDb5q4SGX
3UR3EGVFCX1o5cAvtoGlDtg8r+z1nNWSCcLN1TNwgIGOkI/3v2KiL1zLPS20
Q9f5OClKHdBvFd1pF53QRlybooMu6C2kN3RPd3RIk6Dezgtdrtf2RM0PzZJw
J2sOof3jlAl5R9Dx9HK15GPoR6kTVL8otJfTefZMCppX01jodh2tyZ42O1uO
bvjqWNFaiVbqP2rc1oAuiBe/cGxDv2B/Ua7rQ2/sIR2mrF0OJigHbAbuoH3k
2wLDanXBEXUh0SYiPXD/ol6+9KU+7uv4zQ2XrACrotarHD4Z4D/EPmv5J8ng
APNd79xH0aKRQbkwmgJOHrMIpcrRFaGKHdQEQzBNh89Xn0X7qW2siY5bCR6O
zOYkzqOlulm+sUlGYGsLG5H2MmMwM0XX3uIyOmNlzk+aDhXsbdrEepaHDguN
EXIoq8CMscSdvGx04AjNU5+6GiwzO1FYU4A+YO083FOIlrIojoYl6KcuLe9T
bqBv8wz0OdVoQWVz+kIzWmuDdmxAN/qco6w9U4ZWOt9fIepFT/qG1jOG0B/4
TaPzk+jrD4LCqhfRxiJWQzdhAs4WkxbI6ui0zvqSZC30cQXR6U9G96k612Qa
ooO17whajNB7TfaTGSZoCZ15+KAp2oWpasg1Rz90+LggsUTbb6/dM09H/wFa
hmTn
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->NCache[{{0, 2 Pi}, {0., 1.}}, {{0, 6.283185307179586}, {0., 1.}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.539349050207024*^9, 3.592056901529409*^9, 
  3.592057098747891*^9, 3.6549489425804453`*^9, 3.654949074672969*^9, 
  3.654949595090034*^9, 3.654949626625914*^9, 3.6555539351561403`*^9, 
  3.684450845026168*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 3: f[x_]=...  for x=[0,2 \[Pi]]", "Section",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=Sin[x] /; x <= N[Pi];
f[x_]:=0 /; x >= N[Pi];\
\>", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349053690878*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxF1nk0VW3UAHBDcc1ESWaFQoMpKrUPhUSmlBIvIW+DKYSUSN5knqIkZJbI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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 0.9999998782428621}}, {{0, 6.283185307179586}, {0.,
      0.9999998782428621}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.539349055652882*^9, 3.59205690165224*^9, 
  3.592057098895738*^9, 3.6555540805835247`*^9, 3.65555458149955*^9, 
  3.6555580395979958`*^9, 3.655558132397368*^9, 3.656350114092636*^9, 
  3.684450845118074*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problem 4: f[x_]=...  for x=[0,2 \[Pi]]", "Section",
 CellChangeTimes->{3.539349236841261*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Clear[\"Global`*\"]", "Input",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["Part a) ", "Subsection",
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Clear[f];
f[x_]:=Exp[-x^2];\
\>", "Input",
 CellChangeTimes->{{3.5393491348382*^9, 3.539349140876157*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Plot[f[x],{x,0,2 Pi}]", "Input",
 CellChangeTimes->{3.539349053690878*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwVk3c8lu8Xx+09nmlUJFlFw2h8ee77OiiiskUySrJKRlYhoxKSlVlCsrOS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      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{0, 2 Pi}, {0., 0.9999999999999836}}, {{0, 6.283185307179586}, {0.,
      0.9999999999999836}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.539349055652882*^9, 3.539349239835309*^9, 
  3.592056901812167*^9, 3.592057099053848*^9, 3.684450845208902*^9}]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
CellGrouping->Manual,
WindowSize->{1914, 999},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
ShowCellLabel->True,
ShowCellTags->False,
Magnification->1.25,
FrontEndVersion->"10.4 for Linux x86 (64-bit) (February 25, 2016)",
StyleDefinitions->"Default.nb",
PrivateNotebookOptions -> {"ColorPalette" -> {RGBColor, -1}},
RenderingOptions -> {"ObjectDithering" -> True},
RenderingOptions -> {"RasterDithering" -> False}
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S5.33.1"->{
  Cell[991, 37, 294, 7, 38, "Input",
   CellTags->"S5.33.1"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S5.33.1", 196820, 3946}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 99, 1, 38, "Input"],
Cell[669, 25, 225, 4, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[931, 34, 57, 1, 81, "Section"],
Cell[991, 37, 294, 7, 38, "Input",
 CellTags->"S5.33.1"],
Cell[1288, 46, 361, 9, 64, "Input"],
Cell[CellGroupData[{
Cell[1674, 59, 427, 13, 38, "Input"],
Cell[2104, 74, 11669, 213, 298, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13822, 293, 61, 1, 81, "Section"],
Cell[13886, 296, 68, 1, 38, "Input"],
Cell[13957, 299, 79, 1, 56, "Subsection"],
Cell[14039, 302, 114, 5, 73, "Input"],
Cell[CellGroupData[{
Cell[14178, 311, 112, 2, 38, "Input"],
Cell[14293, 315, 2735, 58, 292, "Output"]
}, Open  ]],
Cell[17043, 376, 86, 1, 56, "Subsection"],
Cell[CellGroupData[{
Cell[17154, 381, 90, 1, 30, "Input"],
Cell[17247, 384, 387, 7, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17671, 396, 126, 3, 38, "Input"],
Cell[17800, 401, 731, 18, 71, "Output"]
}, Open  ]],
Cell[18546, 422, 63, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[18634, 427, 107, 1, 38, "Input"],
Cell[18744, 430, 1351, 35, 74, "Output"]
}, Open  ]],
Cell[20110, 468, 152, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[20287, 474, 161, 3, 64, "Input"],
Cell[20451, 479, 1169, 34, 73, "Output"]
}, Open  ]],
Cell[21635, 516, 69, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[21729, 520, 189, 5, 52, "Input"],
Cell[21921, 527, 70989, 1184, 287, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92947, 1716, 292, 5, 38, "Input"],
Cell[93242, 1723, 38373, 653, 295, "Output"]
}, Open  ]],
Cell[131630, 2379, 75, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[131730, 2383, 403, 13, 30, "Input"],
Cell[132136, 2398, 839, 24, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133012, 2427, 418, 10, 38, "Input"],
Cell[133433, 2439, 21153, 540, 280, "Output"]
}, Open  ]],
Cell[154601, 2982, 62, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[154688, 2986, 90, 1, 30, "Input"],
Cell[154781, 2989, 334, 6, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155152, 3000, 94, 1, 38, "Input"],
Cell[155249, 3003, 740, 20, 66, "Output"]
}, Open  ]],
Cell[156004, 3026, 87, 1, 38, "Input"],
Cell[CellGroupData[{
Cell[156116, 3031, 58, 1, 38, "Input"],
Cell[156177, 3034, 3052, 86, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159266, 3125, 59, 1, 38, "Input"],
Cell[159328, 3128, 2258, 70, 121, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161623, 3203, 98, 2, 38, "Input"],
Cell[161724, 3207, 1198, 32, 68, "Output"]
}, Open  ]],
Cell[162937, 3242, 52, 0, 56, "Subsection"],
Cell[CellGroupData[{
Cell[163014, 3246, 158, 4, 30, "Input"],
Cell[163175, 3252, 313, 5, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[163537, 3263, 88, 1, 81, "Section"],
Cell[163628, 3266, 68, 1, 38, "Input"],
Cell[163699, 3269, 62, 1, 56, "Subsection"],
Cell[163764, 3272, 76, 4, 52, "Input"],
Cell[CellGroupData[{
Cell[163865, 3280, 112, 2, 38, "Input"],
Cell[163980, 3284, 2121, 47, 299, "Output"]
}, Open  ]],
Cell[166116, 3334, 86, 1, 56, "Subsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166239, 3340, 90, 1, 81, "Section"],
Cell[166332, 3343, 68, 1, 38, "Input"],
Cell[166403, 3346, 62, 1, 56, "Subsection"],
Cell[166468, 3349, 114, 5, 73, "Input"],
Cell[CellGroupData[{
Cell[166607, 3358, 112, 2, 38, "Input"],
Cell[166722, 3362, 2307, 50, 292, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169078, 3418, 90, 1, 81, "Section"],
Cell[169171, 3421, 68, 1, 38, "Input"],
Cell[169242, 3424, 62, 1, 56, "Subsection"],
Cell[169307, 3427, 119, 5, 73, "Input"],
Cell[CellGroupData[{
Cell[169451, 3436, 112, 2, 38, "Input"],
Cell[169566, 3440, 6779, 124, 292, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176394, 3570, 132, 2, 81, "Section"],
Cell[176529, 3574, 68, 1, 38, "Input"],
Cell[176600, 3577, 62, 1, 56, "Subsection"],
Cell[176665, 3580, 148, 5, 52, "Input"],
Cell[CellGroupData[{
Cell[176838, 3589, 112, 2, 38, "Input"],
Cell[176953, 3593, 19042, 325, 292, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

