(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     43056,       1216]
NotebookOptionsPosition[     39768,       1104]
NotebookOutlinePosition[     40106,       1119]
CellTagsIndexPosition[     40063,       1116]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Lag[qi_,L_ ,Qi_,t_:t] := 
D[ D[L,(D[qi[t],t])],t]-D[L,qi[t]]==Qi;
  
Lag[qi_List,L_,Qi_List,t_:t] :=
(D[ D[L,(D[qi[[#]][t],t])],t]-D[L,qi[[#]][t]]==Qi[[#]]
)&  /@  Range[1,Length[qi]];
\
\>", "Input",
 CellChangeTimes->{{3.7474814075508757`*^9, 3.747481420216249*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["Protect[Lag];", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
 "Problem 3: Sphere Rolling on a Fixed Sphere  ",
 StyleBox[" *part c is wrong*",
  FontColor->RGBColor[0.5, 0, 0.5]]
}], "Subsection",
 Evaluatable->False,
 CellChangeTimes->{{3.6128456142416887`*^9, 3.612845620848988*^9}, {
  3.6132771562726994`*^9, 3.613277157360551*^9}, {3.616297139589533*^9, 
  3.616297142365405*^9}},
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["Remarks and outline", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 Hyphenation->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part a", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tcm", "=", 
   RowBox[{
    FractionBox["1", "2"], " ", "m", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["r", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"r", "[", "t", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}]}], 
  ";"}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"Trot", "=", 
   RowBox[{
    FractionBox["1", "2"], " ", "I1", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Theta]1", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["\[Theta]2", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], ")"}], "2"]}]}], 
  ";"}]], "Input",
 Hyphenation->False],

Cell["T=Tcm+Trot; ", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell["V= m g r[t] Cos[\[Theta]1[t]]; ", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["L=T-V", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "g"}], " ", "m", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}], " ", 
   RowBox[{"r", "[", "t", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "m", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["r", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"r", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Theta]1", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "I1", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]1", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "+", 
      RowBox[{
       SuperscriptBox["\[Theta]2", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], ")"}], 
    "2"]}]}]], "Output",
 CellChangeTimes->{3.6128456023518333`*^9, 3.6162023254130287`*^9, 
  3.616207778720717*^9, 3.616208498482319*^9, 3.616296950136951*^9, 
  3.616297028394004*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["constraints= {b \[Theta]1[t] - a \[Theta]2[t]==0, r[t]-a-b==0 }", \
"Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", 
      RowBox[{"\[Theta]1", "[", "t", "]"}]}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"\[Theta]2", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], "-", "b", "+", 
     RowBox[{"r", "[", "t", "]"}]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{3.612845602406199*^9, 3.6162023254511003`*^9, 
  3.616207778760248*^9, 3.6162084985442944`*^9, 3.616296950260467*^9, 
  3.616297028522737*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constraintRule", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"constraints", " ", ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]2", ",", "r"}], "}"}], ",", "t"}], "]"}], 
  " "}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{"a", "+", "b"}]}], "]"}]}], ",", 
    RowBox[{"\[Theta]2", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"\[Theta]1", "[", "t", "]"}]}], "a"]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.612845602459429*^9, 3.61620232549286*^9, 
  3.6162077788039093`*^9, 3.6162084986062737`*^9, 3.616296950400385*^9, 
  3.6162970286249123`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vars", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "[", "t", "]"}], ",", 
      RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
      RowBox[{"\[Theta]2", "[", "t", "]"}]}], "}"}]}], ";"}], " "}]], "Input",\

 Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Qeq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Lambda]", "[", "j", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"constraints", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"vars", "[", 
          RowBox[{"[", "#", "]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}], "&"}], " ", "/@", 
   " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Lambda]", "[", "2", "]"}], ",", 
   RowBox[{"b", " ", 
    RowBox[{"\[Lambda]", "[", "1", "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "a"}], " ", 
    RowBox[{"\[Lambda]", "[", "1", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.6128456025336237`*^9, 3.61620232554214*^9, 
  3.616207778852358*^9, 3.6162084986728773`*^9, 3.6162969505385017`*^9, 
  3.6162970290267363`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"(", 
   RowBox[{"eqMotion", "=", 
    RowBox[{"Lag", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "\[Theta]1", ",", "\[Theta]2"}], "}"}], ",", "L", 
      ",", "Qeq"}], "]"}]}], ")"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", "eqMotion", "]"}]}], "Input",
 CellChangeTimes->{{3.421766463230115*^9, 3.421766476320742*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{"g", " ", "m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "-", 
       RowBox[{"m", " ", 
        RowBox[{"r", "[", "t", "]"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["r", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", 
      RowBox[{"\[Lambda]", "[", "2", "]"}]}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "g"}], " ", "m", " ", 
        RowBox[{"r", "[", "t", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"r", "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["r", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"r", "[", "t", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"I1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "+", 
          RowBox[{
           SuperscriptBox["\[Theta]2", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]}], 
      "\[Equal]", 
      RowBox[{"b", " ", 
       RowBox[{"\[Lambda]", "[", "1", "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"I1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Theta]2", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       RowBox[{"\[Lambda]", "[", "1", "]"}]}]}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{3.6128456025871143`*^9, 3.616202325583686*^9, 
  3.616207778895536*^9, 3.616208498740862*^9, 3.6162969506668987`*^9, 
  3.61629702913374*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part b", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[TextData[StyleBox["NEED  TO FIX ORDER HERE",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.747481472209949*^9, 3.747481514119787*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Lambda]2Sol", ",", "\[Theta]Sol", ",", "\[Lambda]1Sol"}], 
     "}"}], "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"eqMotion", "//.", "\[InvisibleSpace]", "constraintRule"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], ",", 
          RowBox[{"\[Lambda]", "[", "1", "]"}], ",", 
          RowBox[{"\[Lambda]", "[", "2", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[InvisibleSpace]", 
      RowBox[{"Rule", "\[Rule]", "Equal"}]}], "]"}]}], ")"}], ";", " ", 
  RowBox[{"Column", "[", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]2Sol", ",", "\[Theta]Sol", ",", "\[Lambda]1Sol"}], 
    "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.421766491011459*^9, 3.421766492426163*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", "g", " ", "m", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"I1", "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "m"}]}], ")"}]}]]}]},
    {
     RowBox[{
      RowBox[{"\[Lambda]", "[", "1", "]"}], "\[Equal]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"g", " ", "I1", " ", "m", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
        RowBox[{"I1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "m"}]}]]}]}]},
    {
     RowBox[{
      RowBox[{"\[Lambda]", "[", "2", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"g", " ", "m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "-", 
       RowBox[{"a", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "-", 
       RowBox[{"b", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Theta]1", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}]}]}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{3.612845602652751*^9, 3.616202325872929*^9, 
  3.61620777894386*^9, 3.616208499240749*^9, 3.616296950793442*^9, 
  3.616297029249*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq\[Theta]", "=", 
  RowBox[{"(", " ", 
   RowBox[{
    RowBox[{"\[Theta]Sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"\[Theta]Sol", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], ")"}], " "}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g", " ", "I1", " ", "m", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
   RowBox[{"I1", "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "m"}]}]], "+", 
  RowBox[{"\[Lambda]", "[", "1", "]"}]}]], "Output",
 CellChangeTimes->{3.612845602663356*^9, 3.6162023258872232`*^9, 
  3.6162077789863462`*^9, 3.6162084992547092`*^9, 3.616296951201239*^9, 
  3.616297029351297*^9}]
}, Open  ]],

Cell[TextData[StyleBox["DO INDEFINITE INTEGRAL HERE, AND AFTER SUBSTITUTE IN \
LIMITS",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.747481472209949*^9, 3.747481514119787*^9}, {
  3.747481547230351*^9, 3.7474815580488243`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int\[Theta]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"eq\[Theta]", "  ", 
        RowBox[{
         RowBox[{"\[Theta]1", "'"}], "[", "t", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}], " ", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]1", "[", "0", "]"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Theta]1", "'"}], "[", "0", "]"}], "\[Rule]", "0"}]}], 
      "}"}]}], "//", "Simplify"}], "//", "Apart"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "t"], 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"g", " ", "I1", " ", "m", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
       RowBox[{"I1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "m"}]}]], "+", 
      RowBox[{"\[Lambda]", "[", "1", "]"}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["\[Theta]1", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Output",
 CellChangeTimes->{3.61284560934161*^9, 3.6162023329418697`*^9, 
  3.6162077857999907`*^9, 3.616208506130743*^9, 3.6162969581532383`*^9, 
  3.616297036243435*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol\[Theta]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"int\[Theta]", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]1", "'"}], "[", "t", "]"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "/.", 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x_", "]"}]}]], "\[Rule]", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"Cos", "[", "x", "]"}]}]]}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "nsmet"}], "MessageName"], ":", 
  " ", "\<\"This system cannot be solved with the methods available to Solve. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Solve\\\", ButtonNote -> \
\\\"Solve::nsmet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845609783896*^9, 3.616202333489471*^9, 
  3.616207786408807*^9, 3.6162085067127533`*^9, 3.616296958841485*^9, 
  3.616297036880424*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "t"], 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"g", " ", "I1", " ", "m", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
        RowBox[{"I1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "m"}]}]], "+", 
       RowBox[{"\[Lambda]", "[", "1", "]"}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["\[Theta]1", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], 
    RowBox[{"\[DifferentialD]", "t"}]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.612845609786407*^9, 3.616202333492097*^9, 
  3.616207786411208*^9, 3.616208506715253*^9, 3.616296958844026*^9, 
  3.616297036882926*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part c", "Subsubsection",
 Evaluatable->False,
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"\[Lambda]2Sol", "/.", 
    RowBox[{
     RowBox[{"\[Lambda]", "[", "2", "]"}], "\[Rule]", "0"}]}], "//.", 
   "sol\[Theta]"}]}]], "Input",
 Hyphenation->False],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(\\(\[Integral]\\_0\\%t\\) \
\\(\\(\\(\\(\\(\\((\\(g\\\\ I1\\\\ m\\\\ \\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\) + \
\\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\) \\(\\(\[DifferentialD] \
t\\)\\)\\)\\)\\)\\) \[Equal] 0}\\)\[NoBreak] is neither a list of replacement \
rules nor a valid dispatch table, and so cannot be used for replacing. \\!\\(\
\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6128456098733788`*^9, 3.6162023335447702`*^9, 
  3.616207786473057*^9, 3.6162085068003283`*^9, 3.616296958961317*^9, 
  3.616297036982689*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", "g", " ", "m", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"I1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "m"}]}], ")"}]}]]}], "//.", 
  "\[VeryThinSpace]", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "t"], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"g", " ", "I1", " ", "m", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
         RowBox[{"I1", "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "m"}]}]], "+", 
        RowBox[{"\[Lambda]", "[", "1", "]"}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["\[Theta]1", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], "\[Equal]", "0"}]}]], "Output",
 CellChangeTimes->{3.612845609876047*^9, 3.6162023335471077`*^9, 
  3.616207786475807*^9, 3.6162085068027287`*^9, 3.616296958964362*^9, 
  3.616297036985402*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["sol2=Solve[eq1,Cos[\[Theta]1[t]]] //Flatten  ", "Input",
 Hyphenation->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\
\\(g\\\\ I1\\\\ m\\\\ \\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0}\\)\[NoBreak] is neither a list of replacement rules \
nor a valid dispatch table, and so cannot be used for replacing. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845609987514*^9, 3.6162023336263027`*^9, 
  3.6162077866213408`*^9, 3.61620850687573*^9, 3.6162969591229687`*^9, 
  3.616297037093762*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\
\\(g\\\\ I1\\\\ m\\\\ \\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0}\\)\[NoBreak] is neither a list of replacement rules \
nor a valid dispatch table, and so cannot be used for replacing. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845609987514*^9, 3.6162023336263027`*^9, 
  3.6162077866213408`*^9, 3.61620850687573*^9, 3.6162969591229687`*^9, 
  3.6162970370969753`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "naqs"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"\[Theta]1\
\\\", \\\"\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[t]\\)\\) \
\[Equal] \\(a\\^2\\\\ g\\\\ m\\\\ \
\\(\\(Sin[\\(\\(\[Theta]1[t]\\)\\)]\\)\\)\\)\\/\\(\\(\\((a + b)\\)\\)\\\\ \\(\
\\((I1 + \\(\\(a\\^2\\\\ m\\)\\))\\)\\)\\)\\)\\)//.\[VeryThinSpace] \\(\\(\\(\
\\(\\(\[Integral]\\_0\\%t\\) \\(\\(\\(\\(\\(\\((\\(g\\\\ I1\\\\ m\\\\ \
\\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\) \\(\\(\[DifferentialD] \
t\\)\\)\\)\\)\\)\\) \[Equal] 0\\)\\)\\)\[NoBreak] is not a quantified system \
of equations and inequalities. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Solve\\\", ButtonNote -> \\\"Solve::naqs\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845609987514*^9, 3.6162023336263027`*^9, 
  3.6162077866213408`*^9, 3.61620850687573*^9, 3.6162969591229687`*^9, 
  3.6162970371943703`*^9}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", "g", " ", "m", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"I1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "m"}]}], ")"}]}]]}], "//.", 
    "\[VeryThinSpace]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "t"], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"g", " ", "I1", " ", "m", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
           RowBox[{"I1", "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "m"}]}]], "+", 
          RowBox[{"\[Lambda]", "[", "1", "]"}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"Cos", "[", 
    RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], "]"}]], "Output",
 CellChangeTimes->{3.6128456101391582`*^9, 3.616202333748577*^9, 
  3.616207786747466*^9, 3.616208506990239*^9, 3.616296959247181*^9, 
  3.616297037196941*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"sol2", "//.", 
      RowBox[{"{", 
       RowBox[{"Rule", "\[Rule]", "Equal"}], "}"}]}], ",", 
     RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
     RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}], "//", 
   "Flatten", " "}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\
\\(g\\\\ I1\\\\ m\\\\ \\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0}\\)\[NoBreak] is neither a list of replacement rules \
nor a valid dispatch table, and so cannot be used for replacing. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.6162970396172943`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\
\\(g\\\\ I1\\\\ m\\\\ \\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0}\\)\[NoBreak] is neither a list of replacement rules \
nor a valid dispatch table, and so cannot be used for replacing. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.616297039627174*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "naqs"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"\[Theta]1\
\\\", \\\"\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[t]\\)\\) \
\[Equal] \\(a\\^2\\\\ g\\\\ m\\\\ \
\\(\\(Sin[\\(\\(\[Theta]1[t]\\)\\)]\\)\\)\\)\\/\\(\\(\\((a + b)\\)\\)\\\\ \\(\
\\((I1 + \\(\\(a\\^2\\\\ m\\)\\))\\)\\)\\)\\)\\)//.\[VeryThinSpace] \\(\\(\\(\
\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\\(g\\\\ I1\\\\ m\\\\ \
\\(\\(Sin[\\(\\(\[Theta]1[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0\\)\\)\\)\[NoBreak] is not a quantified system of \
equations and inequalities. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Solve\\\", ButtonNote -> \\\"Solve::naqs\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.616297039741815*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\
\\(g\\\\ I1\\\\ m\\\\ \\(\\(Sin[\\(\\(Reduce`ReduceVar[\\(\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0}\\)\[NoBreak] is neither a list of replacement rules \
nor a valid dispatch table, and so cannot be used for replacing. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.616297039849523*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(ReplaceRepeated \
:: reps\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.6162970398521433`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "naqs"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"\[Theta]1\
\\\", \\\"\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[t]\\)\\) \
\[Equal] \\(a\\^2\\\\ g\\\\ m\\\\ \
\\(\\(Sin[\\(\\(Reduce`ReduceVar[1]\\)\\)]\\)\\)\\)\\/\\(\\(\\((a + \
b)\\)\\)\\\\ \\(\\((I1 + \\(\\(a\\^2\\\\ m\\)\\))\\)\\)\\)\\)\\)//.\
\[VeryThinSpace] \
\\(\\(\\(\\(Simplify`InertIntegrate[\\(\\(\\(\\(\\(\\((\\(g\\\\ I1\\\\ m\\\\ \
\\(\\(Sin[\\(\\(Reduce`ReduceVar[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\)]\\)\\)\\)\\/\\(Plus[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\) + \\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \\(\\(\\(\\(\
\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\), \\(\\({t, 0, t}\\)\\)\\)\
\\)]\\)\\) \[Equal] 0\\)\\)\\)\[NoBreak] is not a quantified system of \
equations and inequalities. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Solve\\\", ButtonNote -> \\\"Solve::naqs\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.616297039959401*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "naqs"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(Solve[\\(\\(\\(\\(\\(\\(\\(\\(\\(\\(\\*\
SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\) \[Equal] \\(a\\^2\\\\ g\\\\ m\\\
\\ \\(\\(Sin[\\(\\(\[Theta]1[t]\\)\\)]\\)\\)\\)\\/\\(\\(\\((a + b)\\)\\)\\\\ \
\\(\\((I1 + \\(\\(\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\
\\)\\)\\\\ m\\)\\))\\)\\)\\)\\)\\)//.\[VeryThinSpace] \\(\\(\\(\\(\\(\
\[Integral]\\_0\\%t\\) \\(\\(\\(\\(\\(\\((\\(\\(g\\\\ I1\\\\ m\\\\ \
\\(\\(Power[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\\\ \
\\(\\(Sin[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \
\\(\\(\[Lambda][1]\\)\\))\\)\\)\\\\ \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"\[Theta]1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[t]\\)\\)\\)\\) \\(\\(\[DifferentialD] \
t\\)\\)\\)\\)\\)\\) \[Equal] 0\\)\\)\\)\\), \
\\(\\(Cos[\\(\\(\[Theta]1[t]\\)\\)]\\)\\)\\)\\)]\\)\[NoBreak] is not a \
quantified system of equations and inequalities. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Solve\\\", ButtonNote -> \\\"Solve::naqs\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.616297040060542*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Solve :: \
naqs\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.6162970400637093`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "bdomv"}], "MessageName"], ":", 
  " ", "\<\"Warning: \[NoBreak]\\!\\(\[Theta]1[t]\\)\[NoBreak] is not a valid \
domain specification. Mathematica is assuming it is a variable to eliminate. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Solve\\\", ButtonNote -> \
\\\"Solve::bdomv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845612668871*^9, 3.616202336221422*^9, 
  3.616207789186001*^9, 3.616208509320249*^9, 3.61629696213547*^9, 
  3.616297040161626*^9}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Theta]1", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", "g", " ", "m", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"I1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "m"}]}], ")"}]}]]}], "//.", 
    "\[VeryThinSpace]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "t"], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"g", " ", "I1", " ", "m", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}], 
           RowBox[{"I1", "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "m"}]}]], "+", 
          RowBox[{"\[Lambda]", "[", "1", "]"}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["\[Theta]1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"Cos", "[", 
    RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}], ",", 
   RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Output",
 CellChangeTimes->{3.612845617593012*^9, 3.616202341582343*^9, 
  3.61620779428432*^9, 3.6162085143459*^9, 3.6162969674829273`*^9, 
  3.616297044858965*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Theta]1", "[", "t", "]"}], "/", "Degree"}], ")"}], "//.", 
    RowBox[{"sol3", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "//.", 
   RowBox[{"{", 
    RowBox[{"I1", "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "m"}], "5"]}], "}"}]}], "//", 
  "N"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(Cos[\\(\\(\[Theta]1[t]\\)\\)]\\)}\\)\[NoBreak]\
 is neither a list of replacement rules nor a valid dispatch table, and so \
cannot be used for replacing. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845617767189*^9, 3.616202341951191*^9, 
  3.616207794618894*^9, 3.616208514771756*^9, 3.616296967978662*^9, 
  3.616297045320326*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ReplaceRepeated", "::", "reps"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\({\\(Cos[\\(\\(\[Theta]1[t]\\)\\)]\\)}\\)\[NoBreak]\
 is neither a list of replacement rules nor a valid dispatch table, and so \
cannot be used for replacing. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/reps\\\", ButtonNote -> \\\
\"ReplaceRepeated::reps\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612845617767189*^9, 3.616202341951191*^9, 
  3.616207794618894*^9, 3.616208514771756*^9, 3.616296967978662*^9, 
  3.616297045390895*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"57.29577951308232`", " ", 
   RowBox[{"\[Theta]1", "[", "t", "]"}]}], "//.", "\[VeryThinSpace]", 
  RowBox[{"Cos", "[", 
   RowBox[{"\[Theta]1", "[", "t", "]"}], "]"}]}]], "Output",
 CellChangeTimes->{3.612845617815528*^9, 3.6162023419825363`*^9, 
  3.616207794656653*^9, 3.616208514775897*^9, 3.616296967983535*^9, 
  3.6162970453930693`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1920, 1003},
WindowMargins->{{718, -718}, {-68, Automatic}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 324, 11, 145, "Input"],
Cell[885, 33, 76, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[986, 39, 386, 10, 45, "Subsection",
 Evaluatable->False],
Cell[1375, 51, 111, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[1511, 58, 100, 3, 29, "Subsubsection",
 Evaluatable->False],
Cell[1614, 63, 94, 2, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1745, 70, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[1846, 75, 567, 19, 53, "Input"],
Cell[2416, 96, 455, 15, 53, "Input"],
Cell[2874, 113, 75, 2, 33, "Input"],
Cell[2952, 117, 94, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[3071, 123, 68, 2, 32, "Input"],
Cell[3142, 127, 1196, 36, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4375, 168, 128, 3, 33, "Input"],
Cell[4506, 173, 541, 15, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5084, 193, 237, 7, 34, "Input"],
Cell[5324, 202, 645, 19, 50, "Output"]
}, Open  ]],
Cell[5984, 224, 285, 10, 34, "Input"],
Cell[CellGroupData[{
Cell[6294, 238, 618, 20, 34, "Input"],
Cell[6915, 260, 429, 11, 34, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7381, 276, 417, 11, 56, "Input"],
Cell[7801, 289, 2684, 74, 75, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10534, 369, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[10635, 374, 156, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[10816, 380, 1003, 27, 36, "Input"],
Cell[11822, 409, 1886, 54, 105, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13745, 468, 268, 8, 32, "Input"],
Cell[14016, 478, 464, 12, 50, "Output"]
}, Open  ]],
Cell[14495, 493, 245, 4, 31, "Text"],
Cell[CellGroupData[{
Cell[14765, 501, 626, 19, 34, "Input"],
Cell[15394, 522, 762, 21, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16193, 548, 579, 19, 44, "Input"],
Cell[16775, 569, 533, 10, 23, "Message"],
Cell[17311, 581, 804, 22, 51, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18164, 609, 98, 3, 35, "Subsubsection",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[18287, 616, 218, 7, 32, "Input"],
Cell[18508, 625, 1100, 19, 47, "Message"],
Cell[19611, 646, 1369, 40, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21017, 691, 108, 2, 33, "Input"],
Cell[21128, 695, 1088, 18, 47, "Message"],
Cell[22219, 715, 1090, 18, 47, "Message"],
Cell[23312, 735, 1334, 22, 55, "Message"],
Cell[24649, 759, 1564, 44, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26250, 808, 347, 10, 34, "Input"],
Cell[26600, 820, 1084, 18, 47, "Message"],
Cell[27687, 840, 1082, 18, 47, "Message"],
Cell[28772, 860, 1317, 22, 55, "Message"],
Cell[30092, 884, 1089, 18, 48, "Message"],
Cell[31184, 904, 642, 12, 23, "Message"],
Cell[31829, 918, 1333, 23, 55, "Message"],
Cell[33165, 943, 1456, 24, 51, "Message"],
Cell[34624, 969, 632, 12, 23, "Message"],
Cell[35259, 983, 609, 11, 23, "Message"],
Cell[35871, 996, 1666, 46, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37574, 1047, 405, 14, 58, "Input"],
Cell[37982, 1063, 681, 12, 23, "Message"],
Cell[38666, 1077, 681, 12, 23, "Message"],
Cell[39350, 1091, 378, 8, 32, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

